<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propriedades da Chave Adicional',
    'additional-key-info.update' => 'Obter a Chave Adicional',
    'additional-key-info.updateDescription' => 'Recupere a chave adicional e instale-a.',
    'additional-key-info.download' => 'Descarregar Chave',
    'additional-key-info.downloadDescription' => 'Transferir a chave de licença atual.',
    'additional-key-info.install' => 'Instalar Chave',
    'additional-key-info.installDescription' => 'Instalar a chave de licença atual.',
    'additional-key-info.revert' => 'Reverter a Chave',
    'additional-key-info.revertDescription' => 'Reverter para a chave de licença instalada anteriormente.',
    'additional-key-info.revertNotAvailableDescription' => 'Nenhuma chave instalada.',
    'additional-key-info.installSuccess' => 'Começou a instalação da chave de licença.',

    'additional-key-revert.title' => 'Reverter chave adicional',
    'additional-key-revert.success' => 'A chave adicional foi revertida.',

    'additional-key-upload.title' => 'Instalar uma Chave de Licença',
    'additional-key-upload.success' => 'Foi enviada uma nova chave adicional.',

    'additional-keys.title' => 'Chaves de Licença Adicionais',

    'change-subscriptions-owner.title' => 'Reatribuir as assinaturas selecionadas',
    'change-subscriptions-owner.success' => 'A propriedade da subscrição foi alterada',

    'customers.hint' => 'Aqui, pode gerir as contas dos seus clientes do serviço de alojamento, criar contas em conjunto com assinaturas de serviço, gerir clientes já existentes e remover contas. Para administrar websites, correio ou outros serviços fornecidos a um cliente, vá ao respetivo Painel de Cliente, clicando na ligação da coluna à direita da lista.',

    'customer-domains.hint' => 'Aqui, configura e gere os websites.',

    'customer-subscriptions.hint' => 'Aqui pode gerir as assinaturas do cliente.',

    'domains.hint' => 'Aqui, poderá visualizar as informações sobre todos os nomes de domínios registados no sistema e continuar a gerir os serviços de hospedagem. Para adicionar um domínio para si ou para os clientes de hospedagem, basta clicar em Adicionar Domínio. Poderá criar um novo cliente e subscrição quando cria um domínio ou selecionar a partir de domínios existentes.',

    'database-servers.title' => 'Servidores de Base de Dados',

    'database-server-create.title' => 'Novo servidor de base de dados',

    'database-server-properties.title' => 'Servidor da base de dados',

    'database-server-upgrade.drawerTitle' => 'Atualização de MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Atualização concluída',
    'database-server-upgrade.drawerSubTitle.line1' => 'A gaveta não pode ser fechada enquanto a atualização está a ser executada.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Se ocorrerem problemas durante a atualização consulte %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'O servidor de base de dados MariaDB foi atualizado para a versão %%releaseVersion%%. Se deparar com qualquer problema, siga as instruções %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Já tem a versão LTS instalada.',
    'database-server-upgrade.troubleshootingArticle' => 'neste artigo da KB',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Utilize %%troubleshootingArticle%% para resolver quasiquer problemas na atualização de MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Atualize o seu servidor local de base de dados MariaDB para a atual versão de suporte (LTS) de longo-prazo.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Recomendamos vivamente que efetue uma cópia de segurança do seu servidor antes da atualização e que inicie a atualização durante as horas de menos tráfego dos websites.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Durante a atualização de MariaDB, o servidor Plesk e os websites alojados ficarão indisponíveis. A atualização de MariaDB é habitualmente ausente de erros e demora cerca de 10 minutos, mas mesmo assim pode afetar todo o servidor.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Atenção: se estiver a executar MariaDB 5.5, o Pleask atualiza primeiro para MariaDB 10.5. Depois da atualização estar concluída, volte a iniciar este assistente para atualizar para a versão LTS atual de MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Versão atual',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Selecione a versão para a qual atualizar',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Não há lançamentos maiores',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Notas da versão',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Data de lançamento: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Data do fim de vida: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Só forks MariaDB expedidos pelos fornecedores do sistema operativo ou pelo fornecedor de MariaDB podem ser atualizados.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Verificações pré-atualização',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'A interpretar os ficheiros de configuração de MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'A analisar bases de dados com mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'A analisar a configuração do gestor de pacotes',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'A verificar a compatibilidade do sistema',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'A verificar WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Para continaur a atualização, selecione todas as caixas de verificação. É necessário certificar-se de que aconcorda com as alterações à configuração que serão feitas pela atualização e que tem acesso a opções de recuperação.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'As seguintes variáveis serão removidas para compatibilidade com a nova versão:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => 'Os seguintes ficheiros de configuração serão removidos porque fazem parte do pacote mariadb-server que será atualizado:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} {count, plural, one {do ficheiro {files}} other {dos # ficheiros: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Acesso a opções de recuperação (a consola de linhas de comandos do servidor e Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Confirmo que tenho acesso SSH ao servidor',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Utilize um cliente SSH ou abra %%sshTerminalExtension%% num novo separador do browser (não feche a janela da extensão SSH Terminal até a atualização estar concluída). Se a atualização falhar, ter acesso a SSH ajudará na recuperação.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Extensão SSH Terminal',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Confirmo que tenho acesso ao Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Abra o %%repairKit%% num novo separador do browser e inicie sessão utilizando as credenciais de administrador. Não feche a janela da extensão Repair Kit até a atualização estar concluída.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Efetuar cópias de segurança das bases de dados',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Antes da atualização, faça cópias de segurança de todas as bases de dados alojadas no servidor',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'O Plesk guardará a cópia de segurança das bases de dados no diretório %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket no Plesk não está disponível',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Sem WebSocket, não será possível ver resultados em tempo real do processo de atualização.',

    'database-server-upgrade.submitPopover.title' => 'Para prevenir potencial perda de dados, recomendamos vivamente que crie um dump das bases de dados alojadas antes de avançar. Continuar sem criar um dump?',

    'database-server-databases.title' => 'Bases de dados',

    'database-server-change-password.title' => 'Palavra-passe do Administrador',

    'home.title' => 'Início',

    'license.title' => 'Informações acerca da Licença',

    'primary-key-info.title' => 'Chave de Licença Plesk',
    'primary-key-info.update' => 'Obter Chaves',
    'primary-key-info.updateDescription' => 'Obter as chaves de licença encomendadas e instalá-las.',
    'primary-key-info.upload' => 'Instalar Chave',
    'primary-key-info.uploadDescription' => 'Faça o upload e instale uma nova chave de licença.',
    'primary-key-info.revert' => 'Reverter a Chave',
    'primary-key-info.revertDescription' => 'Reverter para a chave de licença instalada anteriormente.',
    'primary-key-info.expireTitle' => 'A sua licença do Plesk caducou',
    'primary-key-info.header' => 'Por esse motivo, certos serviços críticos ficaram indisponíveis. %%warning%%',
    'primary-key-info.headWarning' => 'Os seus websites podem estar em risco!',
    'primary-key-info.softwareUpdatesTitle' => 'Atualizações de software',
    'primary-key-info.softwareUpdates' => '%%title%% estão desativadas. O seu sistema pode estar vulnerável a ameaças.',
    'primary-key-info.websiteBackupsTitle' => 'Cópias de seguranças de websites',
    'primary-key-info.websiteBackups' => '%%title%% já não estão disponíveis. Corre o risco de perda de dados.',
    'primary-key-info.sslCertificatesTitle' => 'Certificados SSL/TLS',
    'primary-key-info.sslCertificates' => '%%title%% não serão renovados automaticamente. Isto poderá comprometer a segurança e a confiança.',
    'primary-key-info.monitoringTitle' => 'Monitorização',
    'primary-key-info.monitoring' => '%%title%% indisponível. Problemas com sobrecargas e desempenho poderão passar despercebidos.',
    'primary-key-info.fileDbManagementTitle' => 'Gestão de ficheiros e bases de dados',
    'primary-key-info.fileDbManagement' => '%%title%% está desativada. Não poderá gerir os seus ficheiros e bases de dados de forma eficiente.',
    'primary-key-info.technicalSupportTitle' => 'Assistência técnica',
    'primary-key-info.technicalSupport' => '%%title%% indisponível. A perda de acesso à assistência necessária para problemas no servidor poderá levar ao prolongamento dos tempos de inatividade.',
    'primary-key-info.renewLicense' => 'Para restaurar estes serviços, adquira uma nova licença para o Plesk.',
    'primary-key-info.footer' => 'Para perguntas ou assistência, ',
    'primary-key-info.supportLink' => 'contacte a assistência do Plesk',

    'primary-key-revert.title' => 'Reverter a Chave de Licença',
    'primary-key-revert.success' => 'A chave Plesk foi revertida.',

    'primary-key-upload.title' => 'Instalar uma Chave de Licença',
    'primary-key-upload.success' => 'Foi enviada uma nova chave Plesk.',

    'resellers.hint' => 'Aqui é possível gerir as contas dos revendedores - os seus clientes que revendem serviços de alojamento e alojam os seus próprios sites. Aqui é possível criar contas juntamente com as subscrições de serviços, gerir revendedores já existentes e remover contas.',

    'reseller-customers.hint' => 'Aqui, define e gere os clientes.',

    'reseller-domains.hint' => 'Aqui, configura e gere os websites.',

    'reseller-subscriptions.hint' => 'Aqui, gere as subscrições do revendedor.',

    'subscriptions.hint' => 'Os clientes obtêm serviços de alojamento de si, subscrevendo um plano de alojamento. Pode gerir aqui estas subscrições, bem como as suas próprias subscrições que criou para alojar os seus sites. Para administrar os websites, correio ou qualquer outro serviço fornecido com uma subscrição, vá para o Painel de Cliente do subscritor, clicando na ligação na coluna à direita da lista.',

    'server-mail-settings.title' => 'Configurações',
    'server-mail-spam-filter.title' => 'Filtro Spam',
    'server-mail-antivirus.title' => 'Antivírus',
    'server-mail-black-list.title' => 'Lista Negra',
    'server-mail-white-list.title' => 'Lista Branca',
    'server-mail-queue.title' => 'Fila do Correio',
    'server-mail-statistics.title' => 'Estatísticas',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Configurações',
    'server-spam-filter.black-list' => 'Lista negra',
    'server-spam-filter.white-list' => 'Lista branca',

    'firewall.title' => 'Gestão da Firewall',
    'firewall-general.title' => 'Geral',
    'firewall-general.toggleStatus' => 'Proteção por firewall',
    'firewall-general.buttonDefault' => 'Repor predefinição',
    'firewall-general.buttonPanic' => 'Modo de Pânico',
    'firewall-general.confirmationDefault' => 'Repor a configuração da firewall nos seus valores predefinidos?',
    'firewall-general.confirmationPanic' => 'Ativar o Modo de Pânico? Os utilizadores não poderão aceder aos seus domínios e alguns serviços de rede poderão parar de funcionar.',
    'firewall-general.successDefault' => 'As definições da firewall foram repostas nas suas predefinições.',
    'firewall-general.successPanic' => 'O modo de pânico foi ativado.',
    'firewall-general.info' => 'Por motivos de segurança, a firewall bloqueia todas as ligações, exceto as que tenham sido explicitamente autorizadas. Pode permitir uma ligação criando uma regra. Para mais informações consulte a documentação',
    'firewall-general.interfaces' => 'Interfaces de rede',
    'firewall-icmp.title' => 'Protocolo ICMP',
    'firewall-rules.title' => 'Regras da Firewall',

    'dns.title' => 'Definições de DNS',
    'dns-records.title' => 'Modelo de Registos de Zona',
    'dns-soa-record.title' => 'Modelo das Definições da Zona',

    'php-handler.title' => 'Definições para %%name%%',
    'php-handler.extensions.title' => 'Extensões',
    'php-handler.extensions.description' => 'Estas configurações das extensões do PHP são apenas para este manipulador.',
    'php-handler.extensions.descriptionShared' => 'Estas configurações são comuns para os seguintes manipuladores PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',
    'php-handler.extensions.buttonManage' => 'Gerir pacotes PECL',
    'php-handler.extensions.manage.title' => 'Gerir pacotes PECL',
    'php-handler.extensions.manage.risks' => 'As extensões PHP são facultadas por pacotes PECL de terceiros. Está a instalá-las por sua própria conta e risco.',
    'php-handler.extensions.manage.description' => 'Instalar, melhorar e desinstalar pacotes PECL. As alterações serão aplicadas a todos os websites que sejam executados em %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Porque é que o pacote desejado não está na lista?',
    'php-handler.extensions.manage.limitations' => 'As extensões PHP expedidas pelo fornecedor do painel de controlo e vendedores de SO não aparecem na lista.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Atualizar",
    'ServerInformation.sectionGeneral' => "Geral",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versão",
    'ServerInformation.os' => "Sistema operativo",
    'ServerInformation.key' => "Chave licença do Plesk",
    'ServerInformation.uptime' => "Tempo de atividade",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dias}} {hours, plural, one {# hora} other {# horas}} {minutes, plural, one {# minuto} other {# minutos}}",
    'ServerInformation.sectionCpu' => "Utilização do CPU",
    'ServerInformation.la1min' => "Último 1 minuto",
    'ServerInformation.la5min' => "Últimos 5 minutos",
    'ServerInformation.la15min' => "Últimos 15 minutos",
    'ServerInformation.sectionMemory' => "Uso de memória",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Total (excluindo o kernel)",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Usada",
    'ServerInformation.memoryFree' => "Livre",
    'ServerInformation.memoryShared' => "Partilhado",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Cached",
    'ServerInformation.memoryAvailable' => "Disponível",
    'ServerInformation.memoryUsage' => "Utilização",
    'ServerInformation.sectionSwap' => "Uso de Swap",
    'ServerInformation.sectionVirtualMemory' => "Utilização da Memória Virtual",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Usada",
    'ServerInformation.swapFree' => "Livre",
    'ServerInformation.swapUsage' => "Utilização",
    'ServerInformation.sectionHarddisk' => "Uso de disco rígido",
    'ServerInformation.harddiskDirectory' => "Sistema de arquivos",
    'ServerInformation.harddiskProtectedDir' => "Diretórios importantes",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Usado",
    'ServerInformation.harddiskAvailable' => "Disponível",
    'ServerInformation.harddiskCapacity' => "Utilização",
    'ServerInformation.sectionDomains' => "Domínios",
    'ServerInformation.activeDomains' => "Ativo",
    'ServerInformation.inactiveDomains' => "Inativo",
    'ServerInformation.problemDomains' => "Problemas",
    'ServerInformation.refreshed' => "Informação atualizada.",

    'ServerAbout.copyright' => '© 2025 WebPros International GmbH. Todos os direitos reservados.',
    'ServerAbout.linkLicenseManagement' => 'Ir para Informações acerca da Licença',
    'ServerAbout.panelVersion' => 'Versão',
    'ServerAbout.installedPatchVersion' => 'Atualizar #%%patch%%',
    'ServerAbout.licenseKey' => 'Chave de licença',
    'ServerAbout.productDescription' => 'Plesk é a principal plataforma WebOps para executar, automatizar e acrescentar aplicações, websites e alojamento.',
    'ServerAbout.readEula' => 'Ler %%link%%.',
    'ServerAbout.linkEula' => 'Acordo de Licença do Utilizador Final',
    'ServerAbout.visitForum' => 'Visitar %%link%%',
    'ServerAbout.linkForum' => 'Fуrum Plesk',
    'ServerAbout.followUs' => 'Siga-nos',
    'ServerAbout.visitSite' => 'Saiba mais em %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Encontre inspiração em %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blog',
    'ServerAbout.ip2locationCopyright' => 'O Plesk utiliza uma base de dados IP2Location LITE para %%link%%.',
    'ServerAbout.linkGeolocation' => 'Geolocalização de IP',

    'ServerAbout.darkThemePromoTitle' => 'Parabéns!',
    'ServerAbout.darkThemePromoDescription' => 'Encontrou um gatinho mágico.',
    'ServerAbout.darkThemePromoButton' => 'Plim! Venha para o lado das trevas',
    'ServerAbout.darkThemeTourDescription' => 'Alterne esta opção para ativar ou desativar o tema escuro para o seu interface.',
    'ServerAbout.darkThemeTourButton' => 'Percebi',

    'ts-sessions.title' => 'Terminal Server Sessions',
    'ts-sessions-properties.title' => 'Propriedades da sessão',

    'BandwidthLimiting.bandwidthThrottling' => 'Não pode controlar a largura de banda porque o QoS não está instalado.',
    'BandwidthLimiting.virtualHostingRequired' => 'A limitação de largura de banda só está disponível para domínios com alojamento Web.',
    'BandwidthLimiting.bandwidthLabel' => 'Utilização máxima da largura de banda',
    'BandwidthLimiting.bandwidthHint' => 'O limite de utilização da largura de banda só é aplicado aos dados transferidos através do protocolo HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Ligações limitadas a',
    'BandwidthLimiting.maxConnectionHint' => 'Se limitar a largura de banda, recomendamos que também limite o número de ligações simultâneas ao website. Caso contrário, os processos do servidor web aumentarão a carga do servidor em caso de pedidos frequentes ao website.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'As definições de limitação de largura de banda foram alteradas.',
    'BandwidthLimiting.unlimited' => 'Ilimitado',

    'ip-address-domains.title' => 'Websites que utilizam o endereço IP %%ipAddress%% %%type%%',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Configurar Como Predefinido',
    'ip-address-domains.type-SHARED' => 'partilhado',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicado',

    'HotlinkProtection.virtualHostingRequired' => 'A Proteção Hotlink só está disponível em domínios com alojamento Web.',
    'HotlinkProtection.enabledLabel' => 'Ativar proteção Hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensões de ficheiros protegidas',
    'HotlinkProtection.friendsLabel' => 'Endereços de websites amigáveis',
    'HotlinkProtection.success' => 'As definições da proteção Hotlink foram alteradas.',

    'Odbc.add' => 'Adicionar ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% criado / %%allowed%% permitido.',
    'Odbc.limitExceeded' => 'O limite de ligações ODBC DSN foi ultrapassado.',
    'Odbc.unlimited' => 'Ilimitado',
    'Odbc.addTooltip' => 'Adicionar fonte de dados ODBC.',
    'Odbc.status' => 'Estado',
    'Odbc.name' => 'Nome da conexão',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Descrição da conexão',
    'Odbc.hostname' => 'Nome de anfitrião',
    'Odbc.statusSystem' => 'é um DSN de sistema.',
    'Odbc.statusConfigured' => 'DSN configurado.',
    'Odbc.statusNotConfigured' => 'DSN não configurado.',
    'Odbc.noSelectionText' => 'Selecione um ou mais artigos para remover.',
    'Odbc.removeConfirmation' => 'Remover {count, plural, =1 {a ligação {name}} other {as # ligações selecionadas}}?',
    'Odbc.removeSuccess' => 'As ligações selecionadas foram removidas.',

    'DomainAliasSettings.title' => 'Definições do nome alternativo do domínio',
    'DomainAliasSettings.updateSuccess' => 'As propriedades do nome alternativo do domínio %%name%% foram modificadas. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'As configurações do site serão aplicadas em %%restartInterval%% minutos.',

    'Home.Backup.offStatus' => 'Este backup não é válido. Não é possível restaurar dados a partir deste ficheiro.',
    'Home.Backup.task-failedStatus' => 'Ocorreu uma tarefa de cópia de segurança.',
    'Home.Backup.activeSchedule' => 'Agenda: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Agendas: %%schedules%%',
    'Home.Backup.noSchedule' => "A agenda de backup não está definida",
    'Home.Backup.period_hourly' => 'A cada hora %%schedule%%',
    'Home.Backup.period_daily' => 'Diariamente %%schedule%%',
    'Home.Backup.period_weekly' => 'Semanalmente %%schedule%%',
    'Home.Backup.period_monthly' => 'Mensalmente %%schedule%%',
    'Home.Backup.create' => 'Criar um backup',
    'Home.Backup.schedule' => 'Agenda',
    'Home.ChangeLog.seeHistory' => 'Ver o histórico de alterações',
    'Home.CustomButtons.add' => 'Adicionar botão personalizado',
    'Home.CustomButtons.noButtons' => 'Não existem botões personalizados',
    'Home.Customization.title' => 'Painel de controlo',
    'Home.Customization.description' => 'Escolha as opções que gostaria de ver',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Servidor',
    'Home.Customization.securitySection' => 'Segurança',
    'Home.Customization.backup' => 'Último backup do servidor',
    'Home.Customization.ipBan' => 'Exclusão de endereços IP',
    'Home.Customization.mailQueue' => 'Fila do Correio',
    'Home.Customization.mySubscriptions' => 'As minhas assinaturas',
    'Home.Customization.overusedSubscriptions' => 'Assinaturas em utilização excessiva',
    'Home.Customization.serverInfo' => 'Informação do Servidor',
    'Home.Customization.updates' => 'Atualizações do Plesk',
    'Home.Customization.promo' => 'Promoção',
    'Home.Customization.changeLog' => 'Novidades',
    'Home.Customization.customButtons' => 'Personalizar teclas',
    'Home.Customization.drag' => 'Arraste para mover o painel',
    'Home.EmptyView.title' => 'Aproveite ao máximo o seu painel de controlo ao escolher as opções que pretende ver.',
    'Home.EmptyView.titleLocked' => 'O painel de controlo está bloqueado pelo seu fornecedor de serviços.',
    'Home.EmptyView.customize' => 'Personalizar',
    'Home.Extension.title' => 'Extensão',
    'Home.IpBan.banned' => 'Banidos',
    'Home.IpBan.trusted' => 'Fiáveis',
    'Home.IpBan.more' => 'Ver mais',
    'Home.MailQueue.total' => 'Total',
    'Home.MailQueue.deferred' => 'Deferido',
    'Home.MailQueue.held' => 'Retido',
    'Home.MailQueue.more' => 'Ver mais',
    'Home.MailQueue.clean' => 'Limpar fila do correio',
    'Home.MailQueue.checkLogs' => 'Verificar registos',
    'Home.MailQueue.repair' => 'Reparar',
    'Home.MailQueue.cleanConfirmQuestion' => 'Limpar a fila do correio?',
    'Home.MailQueue.cleanConfirmYes' => 'Sim',
    'Home.MailQueue.cleanConfirmNo' => 'Não',
    'Home.MailQueue.queueCleaned' => 'A fila de correio foi limpa com sucesso.',
    'Home.OverusedSubscriptions.empty' => 'Não foram encontradas assinaturas em utilização excessiva',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% de %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Ver todas em utilização excessiva: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Abrir na lista',
    'Home.PromoNewHomeView.title' => 'Damos-lhe as boas-vindas à nova página inicial!',
    'Home.PromoNewHomeView.description' => 'Se tiver algum problema ao utilizá-la, pedimos-lhe que partilhe o seu feedback. Ele irá ajudar-nos muito a fazer melhoramentos.',
    'Home.PromoNewHomeView.feedback' => 'Partilhar feedback',
    'Home.PromoNewHomeView.switch' => 'Reverter para "Início"',
    'Home.ServerInfo.hostname' => 'Nome de anfitrião',
    'Home.ServerInfo.copyHostname' => 'Copiar o nome do anfitrião',
    'Home.ServerInfo.ipAddress' => 'Endereço IP',
    'Home.ServerInfo.copyIpAddress' => 'Copiar o endereço IP',
    'Home.ServerInfo.publicIpAddress' => 'Endereço IP público',
    'Home.ServerInfo.copyPublicIpAddress' => 'Copiar endereço IP público',
    'Home.ServerInfo.os' => 'SO',
    'Home.ServerInfo.copyOs' => 'Copiar SO',
    'Home.ServerInfo.uptime' => 'Tempo de atividade',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dias}} {hours, plural, one {# hora} other {# horas}} {minutes, plural, one {# minuto} other {# minutos}}",
    'Home.ServerInfo.more' => 'Ver mais',
    'Home.Subscriptions.add' => 'Adicionar nova',
    'Home.Subscriptions.empty' => 'Crie assinaturas para hospedar vários websites num espaço isolado no servidor. %%link%%',
    'Home.Subscriptions.help' => 'Saber mais',
    'Home.Updates.title' => 'Atualizações de produto',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => 'Atualização %%version%%, n.º %%patch%%',
    'Home.Updates.manageComponents' => 'Adicionar ou Remover Componentes',
    'Home.Updates.lastUpdated' => 'Última atualização a %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Verificar atualizações',
    'Home.Updates.enableAutoupdate' => 'Permitir atualizações automáticas',
    'Home.Updates.lastChecked' => 'Última verificação a %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% está disponível',
    'Home.Updates.installNewVersion' => 'Instalar Agora',
    'Home.Updates.patchAvailable' => 'Estão disponíveis atualizações pequenas',
    'Home.Updates.patchAvailableVersion' => 'Estão disponíveis atualizações pequenas para %%currentVersion%%',
    'Home.Updates.installPatch' => 'Atualizar Agora',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Está disponível uma atualização para {package}} other {Estão disponíveis atualizações para {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# pacote} other {# pacotes}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Atualizar agora} other {Atualizar tudo}}',
    'Home.Promo.close' => 'Fechar o bloco',
    'Home.Promo.viewSlide' => 'Ver diapositivo %%slideNumber%%',
    'Home.Promo.Customize.title' => 'Personalize o seu painel de controlo!',
    'Home.Promo.Customize.content' => 'Utilize as suas funcionalidades favoritas de forma imediata com o novo painel de controlo personalizável',
    'Home.Promo.Customize.action' => 'Personalizar',
    'Home.Promo.SwitchToPuv.title' => 'Conhece as visualizações da interface do Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Se não fornecer serviços de alojamento aos seus clientes utilizando os planos de serviço, talvez queira experimentar a interface mais conveniente para gerir páginas web, os seus ficheiros, bases de dados, contas de e-mail e aplicações web.',
    'Home.Promo.SwitchToPuv.action' => 'Experimentar agora',
    'Home.Status.error' => 'Erro',
    'Home.Status.warning' => 'Aviso',
    'Home.Status.info' => 'Informações',

    'HostingSettings.title' => 'Configurações de alojamento',
    'HostingSettings.updateSuccess' => 'As definições foram atualizadas.',
    'HostingSettings.emptyLogin' => 'É necessário especificar um nome de utilizador.',
    'HostingSettings.emptyPassword' => 'É necessário especificar uma palavra-passe.',
    'HostingSettings.ipV6OnlyNotSupported' => 'O servidor de FTP não suporta IPv6. Alocar pelo menos um endereço IPv4, caso contrário, o utilizador não conseguirá carregar ficheiros para o servidor via FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Preferências de domínio',
    'HostingSettings.domainSettingsSection.domainName' => 'Nome do domínio',
    'HostingSettings.domainSettingsSection.description' => 'Por exemplo, example.com ',

    'HostingSettings.submitPopover.title' => 'Remover o conteúdo de %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Mudar o tipo de alojamento de "Website" para "%%type%%" permitirá remover todo o conteúdo do website, incluindo os seguintes diretórios:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Gostaria de alterar o tipo de alojamento para o seu site?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Para aceder a mais definições, introduza as credenciais de utilizador do sistema e, em seguida, clique em "Criar espaço na rede".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Para aceder a mais definições, clique em "Seguinte" para criar alojamento.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipo de alojamento',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipo',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Página web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redirecionamento',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Sem alojamento web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Utilize a zona DNS do domínio para ter caixas de correio sob este nome de domínio',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'O caminho para o diretório inicial do website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Os visitantes serão redirecionados para aqui através de um redirecionamento SEO amigável HTTP 301.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Reencaminhar visitantes para',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipo de re-endereçamento',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Movido permanentemente (código 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirecionar os visitantes do website para outro site e mostrar o endereço de destino. Este redirecionamento irá manter a classificação de pesquisa do site',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Movido temporariamente (código 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirecione os visitantes do site para uma cópia temporária do site se não quiser que os motores de busca indexem este site temporário.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Re-endereçamento em Janela',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirecionar as visitas do web site para outro site e não exibir o endereço de destino, de modo a que não se apercebam do redirecionamento.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Nenhum',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Raiz do documento',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'É impossível mudar a raiz do documento porque há aplicações da web instaladas neste site.',
    'HostingSettings.domainSettingsSection.save' => 'Gravar',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Modo de compatibilidade',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Deixe o site a funcionar no modo de compatibilidade para a opção de legado "Separar conteúdo SSL/TLS e não SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Este website está a funcionar no modo de compatibilidade, pelo que não pode ser gerido através da interface do Plesk. Isto deve-se ao facto de ter utilizado a opção descontinuada "Separar conteúdo SSL/TLS e não SSL/TLS" antes da atualização. A partir do Plesk 11, o website passará a armazenar o conteúdo disponível por meio de ligações HTTP e HTTPS no mesmo diretório. Recomendamos que mova todos os dados do diretório "httpsdocs/" para "httpdocs/" e que, em seguida, desative o modo de compatibilidade. Isso também fará com que as aplicações instaladas no diretório "httpsdocs/" sejam acessíveis pela Internet. Atenção: não poderá voltar a ativar o modo de compatibilidade.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Mudar esta definição?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Mudar esta definição contradiz a política de segurança do servidor, podendo prejudicar o desempenho ou tornar o servidor vulnerável a ataques.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Alterar',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Reverter',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'As predefinições da política de segurança foram aplicadas',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Parta maior segurança, aplique os valores predefinmidos de segurança. Tenha em conta que certas permissões permitem que os subscritores modifiquem estas definições.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicar predefinição segura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Mais informações acerca das definições de alojamento seguro',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Suporte SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Ativado',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Encriptar ligações entre o website e o browser do visitante.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificado',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Para ativar HTTPS, envie um certificado SSL/TLS para o repositório do domínio e depois selecione-o a partir daí.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirecionar visitantges de HTTP para HTTPS através de um redirecionamento SEO amigável 301',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Não existem certificados SSL/TLS no seu repositório. Para adicionar um certificado, vá até %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'esta página',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (outro repositório)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Não selecionado',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Selecione a linguagem de programação e scripting a ser interpretada pelo servidor web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'o diretório cgi-bin está localizado em %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Utilização adicional de SSI para *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versão Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documentos personalizados de erro',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'o diretório cgi-bin está localizado em',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'o documento raiz deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'o diretório raiz do espaço na rede',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'a raiz anterior deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documentos personalizados de erro',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permissões adicionais de escrita/modificação',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicação do Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Estatísticas de rede',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Ferramenta',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Proteger o acesso às suas estatísticas da web com o seu nome de utilizador e palavra-passe FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Desativado',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Configurações do espaço de rede',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Endereços IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Quota de espaço no disco',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Ativado',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Proibir operações nos ficheiros do website se a quota de espaço em disco definida nas definições da subscrição (caso existam) forem ultrapassadas.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'A quota de espaço no disco não é suportada devido à configuração do sistema de ficheiros do servidor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credenciais de sistema do utilizador',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gerir os ficheiros e pastas do website através de FTP ou File Manager. É permitido o acesso ao servidor através de SSH.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gerir os ficheiros e pastas do website através de FTP ou File Manager. É permitido o acesso ao servidor através de Remote Desktop.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nome de utilizador',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Senha',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Especifique aqui uma nova palavra-passe para mudar a palavra-passe do utilizador do sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Acesso SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Acesso ao Remote Desktop',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Ativado',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Aceder ao servidor com credenciais do utilizador do sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipo',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Desativado',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Para {count, plural, other {# domínios}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'As seguintes definições são mútuas para os {count, plural, other {# domínios do webspace {name}}}:',

    'OdbcAdd.title' => 'Adicionar um ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nome da conexão',
    'OdbcAdd.descriptionLabel' => 'Descrição da conexão',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Criar ODBC DSN',

    'OdbcEdit.title' => 'Configure uma Conexão ODBC',
    'OdbcEdit.saveSuccess' => 'As definições de ligação foram guardadas.',
    'OdbcEdit.test' => 'Testar a conexão',
    'OdbcEdit.connectSuccess' => 'Conexão bem sucedida.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Caminho do ficheiro da base de dados',
    'OdbcEdit.excel.defaultdir.label' => 'Directório de dados predefinido',
    'OdbcEdit.excel.fil.label' => 'Versão da Base de Dados',
    'OdbcEdit.excel.maxbuffersize.label' => 'Tamanho máximo do buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Tempo de ócio da página',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Caminho do ficheiro da base de dados',
    'OdbcEdit.access.uid.label' => 'ID de Login',
    'OdbcEdit.access.pwd.label' => 'Senha',
    'OdbcEdit.access.pagetimeout.label' => 'Tempo de ócio da página',
    'OdbcEdit.access.pagetimeout.description' => 'O período de tempo, em decimas de segundo, que uma página não utilizada fica na buffer. Esta opção é aplicada a todas as fontes de dados que utilizam o driver do Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Tamanho máximo do buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'O tamanho da buffer interna, em KB, alinhados ao limite de 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Apenas leitura',
    'OdbcEdit.access.readonly.description' => 'Marca a base de dados como só de leitura para não permitir actualizações.',
    'OdbcEdit.access.exclusive.label' => 'Exclusivo',
    'OdbcEdit.access.exclusive.description' => 'Marca a base de dados como exclusiva para não permitir a partilha de actualizações.',
    'OdbcEdit.access.safetransactions.label' => 'Transações seguras',
    'OdbcEdit.access.safetransactions.description' => 'Caso 0, predefinido, todas as transações são efetuadas imediatamente. Caso 1, todas as transações só são gravadas no disco após uma operação de escrita (commit operation), mas o desempenho é ligeiramente reduzido.',
    'OdbcEdit.access.threads.label' => 'Operações',
    'OdbcEdit.access.threads.description' => 'O número de operações em background que o motor irá utilizar.',
    'OdbcEdit.access.maxscanrows.label' => 'Máximo de linhas a examinar',
    'OdbcEdit.access.maxscanrows.description' => 'O número de linhas a serem varridas quando definir o tipo de dados de uma coluna baseado nos dados existentes.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Especifica como as modificações efectuadas fora de uma transacção são escritas na base de dados.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Especifica se o driver do MS Access executará as transacções explícitas, definidas pelo utilizador, assincronamente.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Servidor',
    'OdbcEdit.mssql.uid.label' => 'ID de Login',
    'OdbcEdit.mssql.pwd.label' => 'Senha',
    'OdbcEdit.mssql.database.label' => 'Base de dados predefinida',
    'OdbcEdit.mssql.app.label' => 'Nome da aplicação',
    'OdbcEdit.mssql.wsid.label' => 'ID da estação de trabalho',
    'OdbcEdit.mssql.language.label' => 'Linguagem predefinida',
    'OdbcEdit.mssql.oemtoansi.label' => 'Este parâmetro especifica se deve converter os carateres em valores OEM',

    'OdbcEdit.mysql.driver.label' => 'Driver MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Servidor',
    'OdbcEdit.mysql.server.description' => 'O nome de host do servidor de MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Base de dados predefinida',
    'OdbcEdit.mysql.user.label' => 'Nome de utilizador',
    'OdbcEdit.mysql.user.description' => 'O nome de utilizador utilizado para ligar ao MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Senha',
    'OdbcEdit.mysql.password.description' => 'A palavra-passe da conta de utilizador no servidor',
    'OdbcEdit.mysql.port.label' => 'Porta',
    'OdbcEdit.mysql.port.description' => 'A porta TCP/IP a utilizar se o servidor não for o localhost',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'O \'Windows named pipe\' ao qual ligar se o servidor for localhost',
    'OdbcEdit.mysql.option.label' => 'Opção',
    'OdbcEdit.mysql.option.description' => 'Opções que especificam como é que MyODBC deve funcionar. Consulte a <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentação</a>',

    'ProtectedDirectoryList.add' => 'Adicionar Diretório Protegido',
    'ProtectedDirectoryList.addTooltip' => 'Criar diretório protegido.',
    'ProtectedDirectoryList.name' => 'Nome',
    'ProtectedDirectoryList.realmTitle' => 'Título da área protegida',
    'ProtectedDirectoryList.noSelectionText' => 'Selecione um ou mais artigos para remover.',
    'ProtectedDirectoryList.edit' => 'Editar',
    'ProtectedDirectoryList.remove' => 'Remover Proteção',
    'ProtectedDirectoryList.removeTooltip' => 'Remover a proteção dos diretórios selecionados.',
    'ProtectedDirectoryList.removeConfirmation' => 'Esta operação resultará na remoção de proteção {count, plural, =1 {do diretório {name}} other {dos # diretórios selecionados}}. {count, plural, =1 {Este diretório tornar-se-á livremente acessível} other {Os diretórios tornar-se-ão livremente acessíveis}} aos utilizadores da Internet.',
    'ProtectedDirectoryList.removeSuccess' => 'Os diretórios selecionados foram removidos.',

    'ProtectedDirectoryAdd.title' => 'Criar Diretório Protegido',
    'ProtectedDirectoryAdd.submit' => 'Criar',
    'ProtectedDirectoryAdd.success' => 'O diretório protegido %%path%% foi criado com sucesso',

    'ProtectedDirectoryEdit.title' => 'Definições de Diretórios Protegidos',
    'ProtectedDirectoryEdit.success' => 'As configurações do diretório protegido foram alteradas',

    'ProtectedDirectoryUserAdd.title' => 'Criar utilizador do diretório protegido',
    'ProtectedDirectoryUserAdd.subtitle' => 'Diretório %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nome de utilizador',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Senha',
    'ProtectedDirectoryUserAdd.submit' => 'Criar',
    'ProtectedDirectoryUserAdd.success' => 'Foi criado o utilizador do diretório protegido %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Senha para o utilizador de directório protegido',
    'ProtectedDirectoryUserPassword.subtitle' => 'Utilizador %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Senha',
    'ProtectedDirectoryUserPassword.submit' => 'Gravar',
    'ProtectedDirectoryUserPassword.success' => 'As credenciais do utilizador foram guardadas.',

    'SummaryReport.Layout.title' => 'Propriedades do Formato de Relatório',
    'SummaryReport.Layout.success' => 'O formato do relatório %%name%% foi atualizado.',

    'SummaryReport.Layout.Add.title' => 'Criar Formato de Relatório',
    'SummaryReport.Layout.Add.success' => 'Foi criado o formato de relatório %%name%%.',

    'SummaryReport.Report.buttonLayouts' => 'Esquemas',
    'SummaryReport.Report.buttonSchedule' => 'Agenda',
    'SummaryReport.Report.buttonProperties' => 'Propriedades',
    'SummaryReport.Report.buttonTrafficHistory' => 'Histórico do Tráfego',
    'SummaryReport.Report.buttonPrint' => 'Imprimir',
    'SummaryReport.Report.buttonSend' => 'Enviar Por E-mail',
    'SummaryReport.Report.successSent' => 'O relatório foi enviado para %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Agendamento de entrega para %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Foi actualizada a agenda uma entrega de relatório.',

    'SummaryReport.Schedule.Add.title' => 'Criar agendamentos de entrega para %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Foi agendado uma entrega de relatório.',

    'VirtualDirectory.errNotExist' => 'Este diretório virtual está ligado a uma pasta física inexistente.',
    'VirtualDirectory.errNoPermissions' => 'Não tem permissão para ver os conteúdos deste diretório.',
    'VirtualDirectory.tabBrowse' => 'Diretórios',
    'VirtualDirectory.tabBrowseHint' => 'Trabalhar com ficheiros e diretórios físicos e virtuais no site %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'MIME Type',
    'VirtualDirectory.tabMimeTypesHint' => 'Gerir tipos de MIME registados.',
    'VirtualDirectory.tabErrorDocs' => 'Documentos de Erros',
    'VirtualDirectory.tabErrorDocsHint' => 'Gerir documentos de erros.',
    'VirtualDirectory.tabProtection' => 'Protecção',
    'VirtualDirectory.tabProtectionHint' => 'Restringir o acesso ao diretório com proteção por palavra-passe.',

    'VirtualDirectory.errorDocType.default' => 'Predefinido',
    'VirtualDirectory.errorDocType.file' => 'Ficheiro',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.Sidebar.buttonProperties' => 'Propriedades do Directório',
    'VirtualDirectory.Sidebar.buttonPropertiesHint' => 'Ver e mudar as propriedades do directório virtual.',
    'VirtualDirectory.Sidebar.buttonPermissions' => 'Permissões de Acesso de Directório',
    'VirtualDirectory.Sidebar.buttonPermissionsHint' => 'Configurar as permissões de acesso a um directório.',
    'VirtualDirectory.Sidebar.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.Sidebar.buttonAspDotNetHint' => 'Configurar definições de ASP.NET.',
    'VirtualDirectory.Sidebar.buttonPhp' => 'PHP',
    'VirtualDirectory.Sidebar.buttonPhpHint' => 'Configurar definições de PHP.',

    'VirtualDirectory.CreateDirectory.title' => 'Criar Directório',
    'VirtualDirectory.CreateDirectory.name' => 'Nome do diretório',
    'VirtualDirectory.CreateDirectory.success' => 'O diretório %%name%% foi criado.',
    'VirtualDirectory.CreateDirectory.errExists' => 'O diretório %%name%% já existe.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Criar Directório Virtual',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'O diretório %%name%% foi criado.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Propriedades do Directório Virtual',
    'VirtualDirectory.EditVirtualDirectory.success' => 'O diretório virtual foi editado.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Fechar',

    'VirtualDirectory.MimeTypeList.add' => 'Adicionar MIME Type',
    'VirtualDirectory.MimeTypeList.edit' => 'Editar o tipo MIME',
    'VirtualDirectory.MimeTypeList.addHint' => 'Registar um novo MIME Type.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Extensão',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Conteúdo',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Selecione um ou mais artigos para remover.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Remover {count, plural, =1 {o MIME Type selecionado} one {# MIME Type selecionado} other {# MIME Types selecionados}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Os MIME Types selecionados foram removidos.',

    'VirtualDirectory.CreateMimeType.title' => 'Adicionar MIME Type',
    'VirtualDirectory.CreateMimeType.success' => 'Foi registado um novo MIME Type.',

    'VirtualDirectory.EditMimeType.title' => 'Editar o tipo MIME',
    'VirtualDirectory.EditMimeType.success' => 'O MIME Type foi editado.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Erro',
    'VirtualDirectory.ErrorDocList.columnName' => 'Descrição',
    'VirtualDirectory.ErrorDocList.columnType' => 'Tipo',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Localização',
    'VirtualDirectory.ErrorDocList.edit' => 'Editar',

    'VirtualDirectory.EditErrorDoc.title' => 'Editar documento de erros',
    'VirtualDirectory.EditErrorDoc.success' => 'O documento de erros foi editado.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Erro',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Tipo',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Localização',

    'VirtualDirectory.Protection.notSupported' => 'A proteção do diretório não é suportada para este diretório porque o seu nome ultrapassa o limite de 245 caracteres ou contém caracteres não suportados.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'A proteção do diretório virtual está desligada',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Proteger',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'O diretório %%path%% foi protegido.',
    'VirtualDirectory.Protection.tools' => 'Ferramentas',
    'VirtualDirectory.Protection.removeProtection' => 'Remover proteção',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Fazer um URL que corresponda ao diretório acessível para todos.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Remover proteção do diretório virtual? Isso também removerá todos os utilizadores do diretório protegido e as configurações de proteção de diretório.',
    'VirtualDirectory.Protection.settings' => 'Configurações',
    'VirtualDirectory.Protection.settingsTooltip' => 'Ver o local do diretório e especificar um título para a área protegida.',

    'VirtualDirectory.AspDotNet.title' => 'Configurar definições de ASP.NET',

    'VirtualDirectory.Php.title' => 'Versão de PHP',
    'VirtualDirectory.Php.version' => 'Versão',
    'VirtualDirectory.Php.success' => 'A versão do PHP foi atualizada.',


    'MassMailPage.sendEmail' => 'Enviar E-Mail em Massa',
    'MassMailPage.selectAtLeastOneTemplate' => 'Selecione pelo menos um modelo',
    'MassMailPage.confirmRemoval' => 'Tem a certeza de que pretende remover {count, select, 1 {o modelo selecionado} other {os modelos selecionados}}?',
    'MassMailPage.remove' => 'Eliminar',
    'MassMailPage.filters' => 'Filtros',
    'MassMailPage.name' => 'Nome do modelo',
    'MassMailPage.sender' => 'Remetente',
    'MassMailPage.recipients' => 'Destinatários',
    'MassMailPage.subject' => 'Assunto',
    'MassMailPage.created' => 'Data de criação',
    'MassMailPage.send' => 'Enviar',
    'MassMailPage.recipientsNone' => 'Nenhum',
    'MassMailPage.recipientsAdmins' => 'Administrador',
    'MassMailPage.recipientsResellers' => 'Todos os revendedores',
    'MassMailPage.recipientsResellersSelected' => 'Revendedores seleccionados',
    'MassMailPage.recipientsResellersExcept' => 'Todos os revendedores excepto os seleccionados',
    'MassMailPage.recipientsClients' => 'Todos os clientes',
    'MassMailPage.recipientsClientsSelected' => 'Clientes selecionados',
    'MassMailPage.recipientsClientsExcept' => 'Todos os clientes exceto os selecionados',
    'MassMailPage.templatesRemoved' => 'Removeu {count, select, 1 {Modelo} other {Modelos}}.',
    'MassMailPage.emptyViewTitle' => 'Nenhum modelo para mensagens de e-mail em massa',
    'MassMailPage.addNew' => 'Criar modelo',
    'CreateMassMailTemplatePage.templateCreated' => 'O modelo foi criado.',
    'EditMassMailTemplatePage.templateUpdated' => 'O modelo foi atualizado.',
    'SendMassMailPage.emailSent' => 'O e-mail foi enviado.',
    'SendMassMailPage.fieldIsRequired' => 'O campo não pode estar vazio',
    'SendMassMailPage.saveAsTemplate' => 'Guardar a mensagem definida para um novo modelo',
    'SendMassMailPage.newTemplateName' => 'Novo nome do modelo',
    'SendMassMailPage.selectedTemplate' => 'Modelo selecionado',
    'SendMassMailPage.send' => 'Enviar',
    'VirtualHostTemplatePage.name' => 'Nome',
    'VirtualHostTemplatePage.sizeInBytes' => 'Dimensão',
    'VirtualHostTemplatePage.modified' => 'Data de modificação',
    'VirtualHostTemplatePage.permissions' => 'Autorizações',
    'VirtualHostTemplatePage.user' => 'Utilizador',
    'VirtualHostTemplatePage.group' => 'Grupo',
    'VirtualHostTemplatePage.uploadTemplate' => 'Carregar',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'O modelo foi carregado.',
    'VirtualHostTemplatePage.root' => 'Modelo Virtual',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Nenhum ficheiro no modelo',
    'VirtualHostTemplatePage.total' => 'Total de objetos no diretório {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Definir como predefinição',
    'VirtualHostTemplatePage.successfullyReset' => 'O modelo foi alterado para a predefinição.',

    'TrafficUsageByDomain.List.service' => 'Serviço',
    'TrafficUsageByDomain.List.usage' => 'Usada',
    'TrafficUsageByDomain.List.incoming' => 'Entrada',
    'TrafficUsageByDomain.List.outgoing' => 'Saída',
    'TrafficUsageByDomain.List.percentOfAll' => '% de todos',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Nome do Domínio',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Nome do proprietário",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Usado',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Limite',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Disponível',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Usado (em %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Só os meus domínios',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Apenas domínios de revendedores',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Nome do proprietário',

    'TrafficUsageByReseller.emptyView' => 'O revendedor não tem clientes',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Domínios do revendedor",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Domínios de clientes do revendedor: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Informações e estatísticas',
    'InfoAndStatistics.Main.overview' => 'Visão Geral',
    'InfoAndStatistics.Main.domains' => 'Domínios',
    'InfoAndStatistics.Main.trafficUsage' => 'Utilização de tráfego',
    'InfoAndStatistics.Main.reports' => 'Relatórios',
    'InfoAndStatistics.Main.serverSettings' => 'Definições do Servidor',
    'InfoAndStatistics.TrafficUsage.customers' => 'Clientes',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Revendedores',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domínios',

    'ConfigureMailClient.title' => 'Selecione o seu cliente de correio',
    'ConfigureMailClient.description' => 'Para configurar %%email%% automaticamente',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Manual',
    'ConfigureMailClient.Common.email' => 'Email:',
    'ConfigureMailClient.Common.start' => 'Iniciar',
    'ConfigureMailClient.Common.finish' => 'Concluir',
    'ConfigureMailClient.Common.next' => 'Seguinte',
    'ConfigureMailClient.Common.prev' => 'Anterior',
    'ConfigureMailClient.Common.back' => 'Anterior',
    'ConfigureMailClient.Common.manualLink' => 'Está a ter dificuldade em adicionar a sua conta de email? Experimente a configuração manual.',
    'ConfigureMailClient.Thunderbird.title' => 'Configurar a sua conta de correio',
    'ConfigureMailClient.Thunderbird.description' => 'Siga as instruções para adicionar a sua conta de correio ao Mozilla Thunderbird.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Abrir o Thunderbird',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Abra o Thunderbird no seu computador e, em seguida, clique em "Definições da conta" no menu principal do Thunderbird.',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Adicione a sua conta',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Clique em "Ações da conta" e depois em "Adicionar conta de correio eletrónico".',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Introduza os seus dados',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Introduza o seu nome, tal como pretende que apareça em quaisquer mensagens que envie. Introduza também o seu endereço de email e palavra-passe e, em seguida, clique em "Continuar".',
    'ConfigureMailClient.Thunderbird.step4.title' => 'Já está!',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Agora, o Thunderbird tentará adicionar a sua conta de correio automaticamente.',

    'ConfigureMailClient.Outlook.title' => 'Configurar a sua conta de correio',
    'ConfigureMailClient.Outlook.warning' => 'Não podemos adicionar a sua conta correio automaticamente ao Outlook 2019 ou posterior.',
    'ConfigureMailClient.Outlook.warningTooltip' => 'Utilizamos a descoberta automática para adicionar contas de correio automaticamente. O Outlook 2019 e versões posteriores utilizam servidores proxy para pedidos de descoberta automática, o que não é suportado no Plesk e pela extensão Plesk Premium Email.',
    'ConfigureMailClient.Outlook.description' => 'Siga as instruções para adicionar a sua conta de correio ao Microsoft Office Outlook 2016.',
    'ConfigureMailClient.Outlook.step1.title' => 'Adicionar uma nova conta',
    'ConfigureMailClient.Outlook.step1.description' => 'Abra o Outlook 2016 no seu computador e depois aceda ao separador "Ficheiro".',
    'ConfigureMailClient.Outlook.step2.title' => 'Adicionar uma nova conta',
    'ConfigureMailClient.Outlook.step2.description' => 'Clique em "Adicionar conta".',
    'ConfigureMailClient.Outlook.step3.title' => 'Introduza o seu endereço de email',
    'ConfigureMailClient.Outlook.step3.description' => 'Introduza o seu endereço de email.',
    'ConfigureMailClient.Outlook.step4.title' => 'Introduza a sua palavra-passe',
    'ConfigureMailClient.Outlook.step4.description' => 'Introduza a palavra-passe da sua conta de email e depois clique em "Ligar".',
    'ConfigureMailClient.Outlook.step5.title' => 'Já está!',
    'ConfigureMailClient.Outlook.step5.description' => 'Clique em "OK" para concluir a configuração da sua conta.',

    'ConfigureMailClient.Outlook365.title' => 'Configurar a sua conta de correio',
    'ConfigureMailClient.Outlook365.warning' => 'Não podemos adicionar a sua conta correio automaticamente ao Outlook 2019 ou posterior.',
    'ConfigureMailClient.Outlook365.warningTooltip' => 'Utilizamos a descoberta automática para adicionar contas de correio automaticamente. O Outlook 2019 e versões posteriores utilizam servidores proxy para pedidos de descoberta automática, o que não é suportado no Plesk e pela extensão Plesk Premium Email.',
    'ConfigureMailClient.Outlook365.description' => 'Siga as instruções para adicionar a sua conta de correio ao Microsoft Outlook 365.',
    'ConfigureMailClient.Outlook365.step1.title' => 'Adicionar uma nova conta',
    'ConfigureMailClient.Outlook365.step1.description' => 'Abra o Outlook 365 no seu computador. Caso ainda não tenha configurado uma conta de correio no Outlook 365, introduza o seu endereço na página do assistente.',
    'ConfigureMailClient.Outlook365.step2.title' => 'Adicionar uma nova conta',
    'ConfigureMailClient.Outlook365.step2.description' => 'Selecione IMAP como fornecedor de e-mail. Introduza a sua palavra-passe, utilize as definições recomendadas e, em seguida, clique em "Continuar".',
    'ConfigureMailClient.Outlook365.step3.title' => 'Introduza o seu endereço de email',
    'ConfigureMailClient.Outlook365.step3.description' => 'Confirme a sincronização da sua conta IMAP e espere que a configuração termine.',
    'ConfigureMailClient.Outlook365.step4.title' => 'Adicionar mais contas',
    'ConfigureMailClient.Outlook365.step4.description' => 'Para adicionar mais contas de correio ao Outlook 365, clique em "Adicionar conta".',
    'ConfigureMailClient.Outlook365.step5.title' => 'Já está!',
    'ConfigureMailClient.Outlook365.step5.description' => 'Repita os passos acima para adicionar uma nova conta.',

    'ConfigureMailClient.Gmail.title' => 'Configurar a sua conta de correio',
    'ConfigureMailClient.Gmail.description' => 'Siga as instruções para adicionar a sua conta de email à aplicação Gmail no seu dispositivo móvel.',
    'ConfigureMailClient.Gmail.step1.title' => 'Adicionar uma nova conta',
    'ConfigureMailClient.Gmail.step1.description1' => 'Abra a aplicação Gmail no seu telemóvel Android. No canto superior direito, toque na imagem do seu perfil.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Toque em "Adicionar outra conta”.',
    'ConfigureMailClient.Gmail.step1.description3' => 'Toque em "Outra".',
    'ConfigureMailClient.Gmail.step2.title' => 'Introduza o seu endereço de email',
    'ConfigureMailClient.Gmail.step2.description' => 'Introduza o seu endereço de email e depois toque em "Seguinte".',
    'ConfigureMailClient.Gmail.step3.title' => 'Selecione o tipo de conta',
    'ConfigureMailClient.Gmail.step3.description' => 'Para guardar no servidor cópias das mensagens de email transferidas, toque em "Pessoal (IMAP)". Para eliminar as mensagens de email do servidor, toque em "Pessoal (POP3)".',
    'ConfigureMailClient.Gmail.step4.title' => 'Introduza a sua palavra-passe',
    'ConfigureMailClient.Gmail.step4.description' => 'Introduza a palavra-passe da sua conta de correio e depois toque em "Seguinte".',
    'ConfigureMailClient.Gmail.step5.title' => 'Definições de remoção de correio',
    'ConfigureMailClient.Gmail.step5.description' => 'Selecione se ao eliminar emails da aplicação também irá eliminá-los do servidor e, em seguida, toque em "Seguinte".',
    'ConfigureMailClient.Gmail.step6.title' => 'Opções da conta',
    'ConfigureMailClient.Gmail.step6.description1' => 'A aplicação irá buscar automaticamente as definições de saída de correio.',
    'ConfigureMailClient.Gmail.step6.description2' => 'Caso pretenda, altere as opções predefinidas da conta e depois toque em "Seguinte".',
    'ConfigureMailClient.Gmail.step7.title' => 'Já está!',
    'ConfigureMailClient.Gmail.step7.description1' => '(Opcional) Introduza o seu nome, tal como pretende que apareça em qualquer mensagem que enviar.',
    'ConfigureMailClient.Gmail.step7.description2' => 'Toque em "Seguinte" para concluir a configuração da sua conta.',

    'ConfigureMailClient.Ios.title' => 'Configurar a sua conta de correio',
    'ConfigureMailClient.Ios.description' => 'Leia o código QR ou abra a ligação abaixo no seu dispositivo iOS para adicionar automaticamente a sua conta de correio à aplicação iOS Mail.',
    'ConfigureMailClient.Ios.link'  =>  'Adicionar uma conta ao iOS Mail',

    'ConfigureMailClient.Manual.title' => 'Configurar a sua conta de correio manualmente',
    'ConfigureMailClient.Manual.description' => 'Utilize estes valores quando adicionar %%email%% ao seu cliente de email.',
    'ConfigureMailClient.Manual.username' => 'Nome de utilizador do servidor de correio:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Servidor de saída de email (requer autenticação):',
    'ConfigureMailClient.Manual.incomingServer' => 'Servidor de chegada de correio:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Protocolos de chegada de correio suportados:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Protocolos de saída de correio suportados:',


    'Databases.Page.title' => 'Bases de dados para %%database%%',
    'Databases.Page.databaseTab' => 'Bases de dados',
    'Databases.Page.userTab' => 'Gestão de utilizadores',
    'Databases.Page.serversLink' => 'Servidores de Base de Dados',
    'Databases.Page.backupLink' => 'Gestão de cópias de segurança',

    'Databases.List.add' => 'Adicionar base de dados',
    'Databases.List.find' => 'Procurar base de dados...',
    'Databases.List.databaseColumn' => 'Base de dados',
    'Databases.List.relatedToColumn' => 'Relacionada com',
    'Databases.List.relatedToDomains' => 'Relativo a %%domains%%',
    'Databases.List.noRelatedDomains' => 'Atribuir esta base de dados a um website',
    'Databases.List.noDomainRelations' => 'Nenhum website relacionado',
    'Databases.List.openWebAdmin' => 'phpMyAdmin',
    'Databases.List.changeRelatedDomain' => 'Alterar',
    'Databases.List.connectionInfo' => 'Informações da ligação',
    'Databases.List.downloadDump' => 'Exportar captura',
    'Databases.List.uploadDump' => 'Importar captura',
    'Databases.List.copy' => 'Copiar base de dados',
    'Databases.List.checkDatabase' => 'Verificar e reparar',
    'Databases.List.assignToSubscription' => 'Mover para subscrição',
    'Databases.List.assignToSubscription_powerUser' => 'Mover para espaço web',
    'Databases.List.remove' => 'Eliminar',
    'Databases.List.removeConfirmation' => 'Remover a base de dados %%name%%?',
    'Databases.List.removeButtonDisabledHint' => 'Não é possível remover esta base de dados porque está a ser utilizada por uma aplicação web instalada.',
    'Databases.List.databaseRemoved' => 'A base de dados foi removida.',
    'Databases.List.downloadMsSqlClient' => 'Transferir um SQL Client local',
    'Databases.List.downloadMsSqlClientHint' => 'Transferir um SQL Client local',
    'Databases.List.webadmin' => 'Admin Web',
    'Databases.List.webadminHint' => 'Aceda a este servidor através da base de dados Web Admin.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => 'Não é possível %%action%% uma dump: a subscrição encontra-se suspensa.',
    'Databases.List.dumpExport' => 'exportar',
    'Databases.List.dumpImport' => 'importar',
    'Databases.List.copyDatabaseName' => 'Copiar nome da base de dados',
    'Databases.List.copySuccess' => 'O nome %%name%% foi copiado para a área de transferência',

    'Databases.DatabaseSummary.host' => 'Sistema anfitrião',
    'Databases.DatabaseSummary.serverUnavailable' => 'O servidor não está disponível.',
    'Databases.DatabaseSummary.user' => 'Utilizador',
    'Databases.DatabaseSummary.users' => 'Utilizadores',
    'Databases.DatabaseSummary.noUser' => 'Nenhum utilizador de base de dados',
    'Databases.DatabaseSummary.seeAll' => 'ver tudo',
    'Databases.DatabaseSummary.createUser' => 'Criar utilizador',
    'Databases.DatabaseSummary.calculatingSize' => 'A calcular o tamanho...',
    'Databases.DatabaseSummary.tablesCount' => 'Tabelas',
    'Databases.DatabaseSummary.size' => 'Dimensão',

    'Databases.InPlaceSelect.editButtonHint' => 'Editar',
    'Databases.InPlaceSelect.saveButtonHint' => 'Gravar',
    'Databases.InPlaceSelect.closeButtonHint' => 'Cancelar',

    'Databases.ConnectionInfo.title' => 'Informações sobre a ligação',
    'Databases.ConnectionInfo.description' => 'para a base de dados %%database%%',
    'Databases.ConnectionInfo.hint' => 'Pode utilizar estes dados de ligação a bases de dados, por exemplo, ao instalar uma aplicação web.',
    'Databases.ConnectionInfo.host' => 'Sistema anfitrião',
    'Databases.ConnectionInfo.copyHost' => 'Copiar anfitrião para a área de transferência',
    'Databases.ConnectionInfo.databaseName' => 'Nome da base de dados',
    'Databases.ConnectionInfo.copyDatabaseName' => 'Copiar nome da base de dados para a área de transferência',
    'Databases.ConnectionInfo.user' => 'Nome de utilizador',
    'Databases.ConnectionInfo.copyUser' => 'Copiar nome do utilizador para a área de transferência',
    'Databases.ConnectionInfo.password' => 'Senha',
    'Databases.ConnectionInfo.noDefaultUser' => 'Sem utilizador predefinido',

    'Databases.Add.title' => 'Adicionar base de dados',
    'Databases.Add.name' => 'Nome da base de dados',
    'Databases.Add.server' => 'Servidor da base de dados',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => 'Sítio relacionado',
    'Databases.Add.noDomainRelations' => 'Sem sítios relacionados',
    'Databases.Add.userSection' => 'Utilizadores',
    'Databases.Add.userSectionDescription' => 'Criar um utilizador padrão da base de dados. O Plesk acederá à base de dados para este utilizador. Caso nenhum utilizador tenha sido atribuído a esta base de dados, ela não está acessível.',
    'Databases.Add.createUser' => 'Criar um utilizador da base de dados',
    'Databases.Add.username' => 'Nome do utilizador de base de dados',
    'Databases.Add.password' => 'Senha',
    'Databases.Add.passwordConfirmation' => 'Confirmar a palavra-passe',
    'Databases.Add.allDbAccess' => 'O utilizador possui acesso a todas as bases de dados na subscrição selecionada',
    'Databases.Add.aclRadio' => 'Controle de acesso',
    'Databases.Add.aclLocalhost' => 'Permitir apenas ligações locais',
    'Databases.Add.aclAny' => 'Permitir ligações remotas de qualquer host',
    'Databases.Add.aclCustom' => 'Permitir ligações remotas de',
    'Databases.Add.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados podem aceder a base de dados para este utilizador.",
    'Databases.Add.aclHostsLabel' => 'Introduza os nomes de anfitrião ou endereços IP dos anfitriões remotos que têm permissão para aceder aqui',
    'Databases.Add.remoteAccess' => 'Acesso remoto',
    'Databases.Add.remoteAccessDenied' => 'Utilizar as regras da firewall do sistema',
    'Databases.Add.remoteAccessAllowed' => 'Permitir ligações remotas de',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nOs endereços IP especificados podem aceder à base de dados do servidor através de uma regra de firewall. As alterações efetuadas a esta lista serão pré-moderadas pelo seu fornecedor de alojamento.",
    'Databases.Add.remoteAccessHint' => 'Contacte o fornecedor do alojamento e certifique-se de que a opção especificada acima está de acordo com as regras atuais da firewall para solicitações de acesso ao MariaDB/MySQL.',
    'Databases.Add.example' => "Por exemplo:\n%%example%%",
    'Databases.Add.denied' => 'Utilizar as regras da firewall do sistema',
    'Databases.Add.allowed' => 'Permitir ligações remotas de',
    'Databases.Add.databaseCreated' => 'A base de dados %%name%% foi criada.',
    'Databases.Add.create' => 'Criar Base de Dados',

    'Databases.Clone.title' => 'Copiar base de dados',
    'Databases.Clone.clone' => 'OK',
    'Databases.Clone.warning' => 'Atenção: se os nomes das tabelas coincidirem, a tabela da origem substituirá a do destino.',
    'Databases.Clone.formDescription' => 'Copiar conteúdos da base de dados para uma base de dados nova ou existente. Quando forem copiadas para uma base de dados existente, as tabelas da base de dados existente são adicionadas à lista de tabelas da base de dados de destino.',
    'Databases.Clone.copyData' => 'Criar uma cópia completa',
    'Databases.Clone.copyDataHint' => 'Se estiver selecionada, a base de dados será inteiramente copiada (incluindo a estrutura e dados). Se estiver desmarcada, somente a estrutura das tabelas serão copiadas.',
    'Databases.Clone.copyHint' => 'Vai copiar a base de dados %%databaseName%%',
    'Databases.Clone.server' => 'Servidor da base de dados de destino',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => 'Outros...',
    'Databases.Clone.database' => 'Destino da base de dados',
    'Databases.Clone.newDatabase' => 'Criar base de dados com nome',
    'Databases.Clone.newDatabaseName' => 'Novo nome da base de dados',
    'Databases.Clone.existingDatabaseName' => 'Nome existente da base de dados',
    'Databases.Clone.existingDatabase' => 'Copiar para base de dados existente',
    'Databases.Clone.externalDbHost' => 'Nome do anfitrião ou endereço IP',
    'Databases.Clone.externalDbLogin' => 'Nome de utilizador',
    'Databases.Clone.externalDbPassword' => 'Senha',
    'Databases.Clone.subscription' => 'Assinatura de destino',
    'Databases.Clone.subscription_powerUser' => 'Espaço na rede de destino',
    'Databases.Clone.cloneInProgress' => 'A replicar a %%source%% base de dados para a %%destination%% base de dados. Será notificado do progresso através de e-mail (%%email%%).',
    'Databases.Clone.unableToClone' => 'Impossível copiar a base de dados "%%source%%".',
    'Databases.Clone.unableToCreateExternalDatabase' => 'Impossível criar a base de dados "%%destination%%" no servidor especificado.',
    'Databases.Clone.databaseCloned' => 'A base de dados "%%source%%" foi copiada.',
    'Databases.Clone.emailSubjSuccess' => 'A base de dados "%%sourceDatabase%%" foi copiada.',
    'Databases.Clone.emailSubjFailure' => 'Não foi possível copiar a base de dados "%%sourceDatabase%%".',
    'Databases.Clone.emailBodySuccess' => 'A base de dados "%%sourceDatabase%%" (%%sourceHost%%) foi copiada para a base de dados "%%destDatabase%%" (%%destHost%%).',
    'Databases.Clone.emailBodyFailure' => 'Impossível copiar a base de dados "%%sourceDatabase%%" (%%sourceHost%%) para a base de dados "%%destDatabase%%" (%%destHost%%). O procedimento de cópia falhou.',
    'Databases.Clone.localServer' => 'servidor local',

    "Databases.Import.confirm" => 'Importar captura',
    'Databases.Import.recreateDatabase' => 'Recriar a base de dados',
    'Databases.Import.rootDirectory' => 'Diretório inicial',
    'Databases.Import.uploadFromFile' => 'Carregar uma dump do seu computador local',
    'Databases.Import.uploadFromWebspace' => 'Importar uma dump armazenada no seu servidor de alojamento',
    'Databases.Import.uploadHint' => 'Vai importar um dump para %%databaseName%%',
    'Databases.Import.uploadPopupTitle' => 'Importar capturas de bases de dados',
    'Databases.Import.uploading' => 'A importar...',
    'Databases.Import.waitMessage' => 'Aguarde, por favor...',

    "Databases.Export.confirm" => 'Exportar captura',
    'Databases.Export.downloadDumpAutomatically' => 'Descarregar automaticamente a dump após a sua criação',
    'Databases.Export.downloadDumpName' => 'Nome do ficheiro de dump',
    'Databases.Export.downloadHint' => 'Irá criar uma dump de %%database%% e transferi-la',
    'Databases.Export.downloadPopupTitle' => 'Exportar captura',
    'Databases.Export.downloadRelativePath' => 'Guardar captura para o seguinte diretório',
    'Databases.Export.rootDirectory' => 'Diretório inicial',
    'Databases.Export.waitMessage' => 'Aguarde, por favor...',

    'MoveDatabasePage.title' => 'Mover bases de dados para outra subscrição',
    'MoveDatabasePage.title_powerUser' => 'Mover bases de dados para outro espaço web',
    'MoveDatabasePage.description' => 'Vai mover a base de dados %%name%%',
    'MoveDatabasePage.hint' => 'As bases de dados selecionadas serão movidas para a subscrição selecionada. Os utilizadores da base de dados também serão movidos, a menos que possuam acesso a outras bases de dados. Nota: depois de serem movidos, os utilizadores que tinham acesso à base de dados antes de serem movidos deixarão de poder aceder à base de dados através da hiperligação no Plesk.',
    'MoveDatabasePage.subscriptionName' => 'Mover para subscrição',
    'MoveDatabasePage.subscriptionName_powerUser' => 'Mover para espaço web',
    'MoveDatabasePage.save' => 'Mover',
];