<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Dirección IP o subred',
    'access-network.subnetOrIpAddressHint' => 'Por ejemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletters',
    'admin.announcement-settings.getConsentLoading' => 'Recuperando la información sobre los newsletters...',
    'admin.announcement-settings.getConsentWarning' => 'No pudo recuperarse el estado de su suscripción.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Deseo recibir los newsletters de WebPros. Estos proporcionan información general sobre el producto, además de otras informaciones de carácter técnico y de seguridad. Autorizo a WebPros a recopilar, procesar y usar mis datos personales (email), incluyendo procesamiento transversal, conforme a las leyes de protección de datos aplicables y vigentes para el envío de dichos newsletters de forma directa o mediante un servicio de terceros. De no seleccionar esta casilla, mi consentimiento se verá revocado, WebPros dejará de enviarme emails y este eliminará mis datos personales de sus sistemas de forma permanente.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Las empresas de WebPros enumeradas aquí pueden usar mi nombre y mi dirección de correo electrónico (%%adminEmail%%) para proporcionarme contenido publicitario personalizado, como boletines y ofertas individuales relacionadas con los productos de WebPros. Las empresas que solicitan mi consentimiento son las siguientes: WebPros International LLC y WebPros International GmbH. Dicha información se utilizará de conformidad con la %%privacyPolicy%% hasta que reitre mi consentimiento, y existe la posibilidad de que se comparta con otras entidades pertenecientes al grupo WebPros. Puedo modificar o retirar mi consentimiento en cualquier momento desmarcando la casilla, haciendo clic en una de las comunicaciones recibidas o enviando un mensaje a emailing privacy@plesk.com',
    'admin.announcement-settings.privacyPolicy' => 'Política de privacidad de WebPros',
    'admin.announcement-settings.noConsent' => 'Cancelar mi suscripción al newsletter de WebPros.',
    'admin.announcement-settings.reportConsentError' => 'No pudo guardarse su configuración para la obtención de información de Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Lo sentimos, en este momento no podemos actualizar su perfil. Inténtelo de nuevo transcurridos unos minutos.',
    'admin.announcement-settings.invalidConsentType' => "Tipo de consentimiento desconocido: '%%type%%'",
    'admin.announcement-settings.retry' => 'Reintentar',
    'admin.announcement-settings.consentGivenInfo' => 'Esperamos que haya disfrutado de nuestro newsletter genérico. Ahora le proporcionamos una alternativa mejor aún si cabe - personalizada y con sugerencias e información sumamente útil conforme a sus necesidades particulares. Si desea recibir su newsletter personalizado, seleccione la primera opción que aparece a continuación y haga clic en Aceptar.',

    'admin.personal-info.title' => 'Edición del perfil del administrador',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Configuración de Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Configuración',

    'admin-alias.login' => 'Nombre de usuario',
    'admin-alias.password' => 'Contraseña',
    'admin-alias.passwordConfirmation' => 'Confirme la contraseña',
    'admin-alias.email' => 'Email',
    'admin-alias.contact' => 'Nombre de contacto',
    'admin-alias.comments' => 'Comentarios',
    'admin-alias.emptyLogin' => 'Proporcione un nombre de usuario.',
    'admin-alias.loginTooLong' => 'La longitud del nombre de usuario excede los 20 caracteres.',
    'admin-alias.emptyEmail' => 'Indique una dirección de email.',
    'admin-alias.emptyContactName' => 'Proporcione un nombre de contacto.',
    'admin-alias.contactNameTooLong' => 'La longitud del nombre de contacto excede los 255 símbolos.',
    'admin-alias.emptyPassword' => 'Proporcione una contraseña.',
    'admin-alias.commentsTooLong' => 'La longitud del comentario excede los 255 símbolos.',
    'admin-alias.emailActivation' => 'Activar cuenta por email',
    'admin-alias.simplePanel' => 'Activar modo restringido',
    'admin-alias.simplePanelHint' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador adicional en Plesk. Para modificar las acciones disponibles, vaya a %%link%%.',
    'admin-alias.simplePanelLink' => 'Herramientas y configuración > Configuración de modo restringido',
    'admin-alias.lockPowerUser' => 'Forzar vista Power User para el administrador adicional',
    'admin-alias.lockPowerUserHint' => 'Habilidad para restringir la visualización al administrador adicional de Plesk (sin acceso a planes de servicio, clientes y revendedores).',

    'admin-info.plesk-settings.multiplyLogin' => 'Permitir múltiples sesiones bajo esta cuenta',
    'admin-info.plesk-settings.adminLanguage' => 'Idioma de la interfaz del administrador',
    'admin-info.plesk-settings.password' => 'Contraseña',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirme la contraseña',
    'admin-info.plesk-settings.oldPassword' => 'Contraseña anterior',

    'admin-panel.form.contact-info.login' => 'Nombre de usuario',
    'admin-panel.form.contact-info.contactName' => 'Nombre de contacto',
    'admin-panel.form.contact-info.emptyLogin' => 'Indique un nombre de usuario.',
    'admin-panel.form.contact-info.emptyContactName' => 'Proporcione un nombre de contacto.',
    'admin-panel.form.contact-info.loginTooLong' => 'El nombre de usuario es demasiado largo (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'El nombre de contacto es demasiado largo (se permiten un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.email' => 'Dirección de email',
    'admin-panel.form.contact-info.emptyEmail' => 'Indique una dirección de email.',
    'admin-panel.form.contact-info.companyName' => 'Nombre de la empresa',
    'admin-panel.form.contact-info.longCompanyName' => 'Este nombre de empresa es demasiado largo. Tenga en cuenta que se permite un máximo de %max% símbolos.',
    'admin-panel.form.contact-info.phone' => 'Nº de teléfono',
    'admin-panel.form.contact-info.longPhone' => 'Este número de teléfono es demasiado largo (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.fax' => 'Nº de fax',
    'admin-panel.form.contact-info.imNumber' => 'Mensajería instantánea',
    'admin-panel.form.contact-info.longFax' => 'Este número de fax es demasiado largo (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'El número de teléfono especificado no es válido.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'El número de fax indicado no es correcto.',
    'admin-panel.form.contact-info.address' => 'Dirección',
    'admin-panel.form.contact-info.longAddress' => 'Esta dirección es demasiado larga (se permite un máximo de %max% símbolos).',
    'admin-panel.form.contact-info.city' => 'Ciudad',
    'admin-panel.form.contact-info.longCity' => 'El nombre de esta ciudad es demasiado largo.',
    'admin-panel.form.contact-info.shortCity' => 'El nombre de esta ciudad es demasiado corto.',
    'admin-panel.form.contact-info.state' => 'Estado/Provincia',
    'admin-panel.form.contact-info.postalCode' => 'Código postal',
    'admin-panel.form.contact-info.country' => 'País',
    'admin-panel.form.contact-info.additionalInfo' => 'Información adicional',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Solo texto sin formato − Se ignorarán todas las etiquetas HTML.',
    'admin-panel.form.contact-info.duplicateEmail' => 'En el sistema ya existe un usuario con esta dirección de email.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Suscripción',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Propiedades del sitio web aprovisionado junto con la suscripción.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Propiedades del sitio web aprovisionado junto con la suscripción.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Propiedades del sitio web aprovisionado junto con la suscripción.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Crear suscripción para el cliente',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Deseleccione esta casilla si ahora no desea crear una suscripción de servicio de hosting o un sitio web para el cliente. Si el cliente no dispone de una suscripción, no podrá acceder al panel del cliente.',
    'admin-panel.form.domain-info-section.domainName' => 'Nombre de dominio',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Indique un nombre de dominio.',
    'admin-panel.form.domain-info-section.shared' => 'compartida',
    'admin-panel.form.domain-info-section.exclusive' => 'dedicada',
    'admin-panel.form.domain-info-section.userName' => 'Nombre de usuario',
    'admin-panel.form.domain-info-section.userNameHint' => 'Cuenta de usuario del sistema utilizada para administrar los archivos y carpetas de los sitios web creados dentro de la suscripción.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Indique un nombre de usuario.',
    'admin-panel.form.domain-info-section.password' => 'Contraseña',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Indique una contraseña.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirme la contraseña',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Dirección IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "La dirección IP donde se aloja el sitio web es una dirección de red del host virtual del sitio web.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Dirección IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Ninguna',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Configuración de suscripción adicional',
    'admin-panel.form.domain-info-section.credentials' => 'Credenciales del usuario del sistema',
    'admin-panel.form.domain-info-section.credentialsHint' => 'para acceder a los archivos alojados mediante FTP y SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'para acceder a los archivos alojados mediante FTP y RDP',

    'admin-panel.form.login-info.userName' => 'Nombre de usuario',
    'admin-panel.form.login-info.emptyUserName' => 'Indique un nombre de usuario.',
    'admin-panel.form.login-info.oldPassword' => 'Contraseña anterior',
    'admin-panel.form.login-info.password' => 'Contraseña',
    'admin-panel.form.login-info.emptyPassword' => 'Indique una contraseña.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Confirme la contraseña',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Si cambia la contraseña también se cambiará la contraseña de la dirección de email interna',
    'admin-panel.form.login-info.emailActivation' => 'Activar cuenta por email',
    'admin-panel.form.login-info.emailActivationHint' => 'Una cuenta creada no está activa hasta que el usuario la activa mediante el enlace enviado por email o hasta que el administrador la activa manualmente.',

    'admin-panel.form.subscription-info-section.subscription' => 'Suscripción',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Plan de servicio',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Plan de servicio actual',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Plan de servicio nuevo',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Plan simple',
    'admin-panel.form.subscription-info-section.none' => 'Ninguna',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Complementos',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Una vez cambiada la asociación del plan, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Personalice los parámetros de la suscripción una vez creada.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Personalice los parámetros de la suscripción una vez creado el cliente.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Una vez creada, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Añadir suscripción',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'app.configure.otherSettings' => 'Otro',
    'app.configure.passwordConfirmation' => 'Confirme la contraseña',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Forzar las actualizaciones de todas las aplicaciones instaladas',
    'app.update-settings.forceUpdatesHint' => 'Las aplicaciones de todos los clientes se actualizarán de forma automática en cuanto las actualizaciones estén disponibles. Los clientes no podrán desactivar las actualizaciones automáticas de sus aplicaciones. Importante: tenga precaución al utilizar esta opción, ya que las actualizaciones pueden afectar a la funcionalidad de las aplicaciones de forma significativa. Por ejemplo, las extensiones de las aplicaciones pueden dejar de funcionar con otra versión de estas.',
    'app.update-settings.suggestUpdates' => 'Habilitar la opción "Actualizar esta aplicación automáticamente" de forma predeterminada',
    'app.update-settings.suggestUpdatesHint' => 'En el caso de aplicaciones instaladas recientemente, la opción "Actualizar esta aplicación automáticamente" será habilitada en la configuración de la aplicación.',

    'backup.server-settings.rotation' => 'Número máximo de archivos de backup completo a almacenar (incluyendo tanto los backups programados como los manuales)',
    'backup.server-settings.rotationDescription' => 'Los usuarios puede almacenar esta cantidad de backups completos en el almacenamiento del servidor. De superarse el límite, únicamente se conservaran los backups más recientes. Esto no afecta a los backups incrementales.',
    'backup.server-settings.maxProcesses' => 'Número máximo de procesos de backup programados ejecutados de forma simultánea',
    'backup.server-settings.niceScheduled' => 'Ejecutar procesos de backup programados con poca prioridad',
    'backup.server-settings.niceScheduledPriority' => 'Prioridad',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Indique un valor entre 1 y 19 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.niceScheduledIoPriority' => 'Prioridad de E/S',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Indique un valor entre 0 y 7 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.niceAlways' => 'Ejecutar todos los procesos de backup con prioridad baja',
    'backup.server-settings.niceAlwaysPriority' => 'Prioridad',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Indique un valor entre 1 y 19 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Prioridad de E/S',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Indique un valor entre 0 y 7 ambos incluidos, siendo el número más elevado el que tiene menor prioridad.',
    'backup.server-settings.compressionLevel' => 'Nivel de compresión',
    'backup.server-settings.compressionLevelNoCompression' => 'Sin compresión',
    'backup.server-settings.compressionLevelFastest' => 'Más rápido',
    'backup.server-settings.compressionLevelFast' => 'Rápido',
    'backup.server-settings.compressionLevelNormal' => 'Normal',
    'backup.server-settings.compressionLevelMaximum' => 'Máximo',
    'backup.server-settings.freeSpaceRequired' => 'Iniciar el backup únicamente si su servidor dispone de la cantidad especificada de espacio en disco libre (en megabytes)',
    'backup.server-settings.checkBackupDiskSpace' => 'Iniciar el backup únicamente si su servidor dispone de suficiente espacio en disco libre',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Utilizar la funcionalidad de backups nativa de MS SQL. En el caso de bases de datos remotas, compruebe que ha configurado debidamente la configuración de backup del servidor MS SQL remoto en Herramientas y configuración > Servidores de bases de datos.',
    'backup.server-settings.localFtpRestriction' => 'Permitir la configuración de un almacenamiento de backups FTP en el servidor local',
    'backup.server-settings.backupSecuritySettings' => 'Configuración de seguridad de backups',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Guardar los backups en el almacenamiento del servidor en caso de que se produzca un error carga al almacenamiento remoto',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'En caso de que no fuera posible efectuar la carga al almacenamiento remoto, los backups manuales y programados se guardarán en el almacenamiento del servidor local. Los usuarios deben disponer de permisos para almacenar backups en el almacenamiento del servidor.',
    'backup.server-settings.AllowScheduleHourly' => 'Permitir que los clientes y revendedores programen copias de seguridad por hora',

    'change-current-subscription.hint' => 'Aquí puede cambiar la asociación con planes de servicio para la suscripción. Tenga en cuenta que la selección de \'ninguno\' como plan de servicio nuevo desvincula la suscripción del plan de servicio y la convierte en \'Personalizada\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'change-password.oldPassword' => 'Contraseña anterior',
    'change-password.password' => 'Contraseña nueva',
    'change-password.passwordConfirmation' => 'Confirme la contraseña',
    'change-password.oldPasswordIsIncorrect' => 'La contraseña anterior no es correcta. Inténtelo de nuevo.',
    'change-password.unableToFindAdditionalAdminAccount' => 'No se pudo encontrar la cuenta de administrador adicional.',
    'change-password.warningAboutAdminPasswordSyntax' => "La contraseña debería estar formada por %%min%% - %%max%% caracteres y no debería incluir el nombre de usuario.\nNo utilice interrogantes, espacios ni caracteres del alfabeto nacional en la contraseña.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "No utilice interrogantes, espacios, puntos y coma ni caracteres del alfabeto nacional en la contraseña.\nLa contraseña debería estar formada por %%min%% - %%max%% caracteres y no debería incluir el nombre de usuario.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Directiva de sobreventa de recursos',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Sobreventa permitida',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'La sobreventa permite a un revendedor vender más recursos de los asignados con un plan. En el caso de permitirse, un revendedor se regirá por el uso actual de recursos, en vez de regirse por la asignación inicial de recursos.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Sobreventa no permitida',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'En el caso de que no se permita la sobreventa, un revendedor solo podrá vender tantos recursos como los asignados inicialmente con un plan, sin tener en cuenta la cantidad de estos recursos que esté siendo utilizada.',

    'change-reseller-subscription.hint' => 'Aquí puede cambiar la asociación con el plan de servicio para la suscripción del revendedor. Tenga en cuenta que la selección de \'ninguno\' como plan de servicio nuevo desvincula la suscripción de los planes de servicio y la convierte en \'Personalizada\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Plan nuevo',
    'change-reseller-subscription.oldSubscription' => 'Plan actual',
    'change-reseller-subscription.none' => 'ninguna',
    'change-reseller-subscription.infoSubscriptionChanged' => 'La asociación de la suscripción con el plan de servicio ha sido actualizada.',
    'change-reseller-subscription.customizeSubscription' => 'Una vez actualizada la asociación con el plan de servicio, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',

    'change-subscription.hint' => 'Aquí puede cambiar la asociación con planes de servicio para las suscripciones seleccionadas.',
    'change-subscription.selectPlanLegend' => 'Plan de servicio',
    'change-subscription.selectPlanDescription' => 'Para cambiar a otro plan de servicio, seleccione el plan nuevo en la lista. Tenga en cuenta que la selección de \'ninguno\' desvincula las suscripciones del plan de servicio y las convierte en \'Personalizadas\'.',
    'change-subscription.servicePlan' => 'Plan de servicio nuevo',
    'change-subscription.selectAddonPlansLegend' => 'Planes complementarios',
    'change-subscription.selectAddonPlansDescription' => 'Añada o elimine planes complementarios.',
    'change-subscription.noChange' => 'no cambiar',
    'change-subscription.none' => 'ninguno',
    'change-subscription.add' => 'añadir',
    'change-subscription.del' => 'eliminar',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Dirección IP o subred',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Por ejemplo, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Acceso a Plesk con privilegios de administrador',
    'control-panel-access.settings.policyAllow' => 'Permitido, excluyendo las redes presentes en la lista.',
    'control-panel-access.settings.policyDeny' => 'Denegado desde las redes que no aparecen en la lista.',

    'create-subscription.title' => 'Añadir una suscripción',
    'create-subscription.titleOwn' => 'Adición de su propia suscripción',
    'create-subscription.poolIsEmpty' => 'No se pudo crear una suscripción porque en Plesk no existe ninguna dirección IP compartida ni ninguna dirección IP dedicada disponible.',
    'create-subscription.infoNewSubscriptionCreated' => 'La suscripción %%name%% ha sido creada.',
    'create-subscription.createBeforeAppInstall' => 'Para instalar la aplicación es necesario disponer de una suscripción.',

    'customer.hint' => 'Aquí puede dar de alta clientes nuevos para sus servicios de hosting. Al dar de alta un cliente nuevo, creará una cuenta de cliente en Plesk así como una suscripción a uno de sus planes de hosting. Asimismo, también puede crear complementos adicionales. La suscripción también puede proporcionar un conjunto de recursos y servicios totalmente personalizado y no vinculado a ningún plan. En este caso, seleccione \'Ninguno\' al lado del plan de servicio.',
    'customer.contactInfoSection' => 'Información de contacto',
    'customer.additionalInfoSection' => 'Información adicional del cliente',
    'customer.accessToPanelSection' => 'Acceso a Plesk',
    'customer.contactInfoSectionHint' => 'Introduzca la información de contacto del cliente.',
    'customer.accessToPanelSectionHint' => 'Credenciales que usará el cliente para acceder a su panel del cliente.',
    'customer.unableCreateSubscription' => 'La suscripción no puede ser creada − %%reason%%',
    'customer.poolIsEmpty' => 'El grupo de direcciones IP está vacío',
    'customer.buttonOk' => 'Añadir cliente',

    'database-settings.dbPrefixRadio' => 'Añadir un prefijo y un guion bajo al principio de los nombres de las bases de datos',
    'database-settings.dbPrefixNone' => 'Ninguno',
    'database-settings.dbPrefixUsername' => 'Nombre de usuario',
    'database-settings.dbPrefixExternalId' => 'ID externa de una suscripción',
    'database-settings.dbPrefixCustom' => 'Prefijo personalizado',
    'database-settings.dbUserPrefixRadio' => 'Añadir un prefijo y un guion bajo al principio de los nombres de usuario de las bases de datos',
    'database-settings.dbUserPrefixHint' => 'Los nombres de usuario de las bases de datos tendrán el formato <prefix>_<database_user_name>. Debido a las restricciones de longitud de los nombres de usuario de la base de datos, es necesario abreviar <prefix>.',
    'database-settings.grantAlterDatabase' => 'Conceder el permiso ALTER DATABASE a todos los usuarios de la base de datos Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Este permiso será concedido a usuarios nuevos y también a los usuarios existentes.',
    'database-settings.aclRadio' => 'Configuración predeterminada para el acceso remoto de usuarios de base de datos MariaDB/MySQL',
    'database-settings.aclLocalhost' => 'Solo permitir conexiones locales',
    'database-settings.aclAny' => 'Permitir conexiones remotas desde cualquier host',
    'database-settings.aclCustom' => 'Permitir conexiones remotas desde',
    'database-settings.aclDescription' => 'Esta opción solo modifica los permisos de los usuarios. Para activar el acceso remoto al servidor MariaDB/MySQL local, seleccione la opción correspondiente en %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Configuración MariaDB/MySQL local',
    'database-settings.example' => "Por ejemplo:",
    'database-settings.aclExampleDescription' => "Los hosts especificados pueden acceder a la base de datos en nombre de este usuario.",
    'database-settings.dbPrefixAlphaNumeric' => 'El valor del prefijo solo puede incluir valores alfanuméricos y guion bajo.',

    'dns.add-acl-record.description' => 'Añada una dirección IP de un servidor DNS que pueda recibir una copia de la zona DNS.',
    'dns.add-acl-record.ipAddress' => 'Dirección IP',
    'dns.add-acl-record.ipAddressWithMask' => 'Máscara/dirección IP',

    'dns.settings.recursion' => 'Consultas DNS recursivas',
    'dns.settings.recursionOn' => 'Aceptar todas las peticiones',
    'dns.settings.recursionLocal' => 'Aceptar únicamente peticiones locales',
    'dns.settings.recursionLocalnets' => 'Permitir solo para peticiones desde red(es) local(es)',
    'dns.settings.recursionOff' => 'Denegar para todas las peticiones',
    'dns.settings.customConfiguration' => 'Configuración DNS adicional',
    'dns.settings.customConfigurationPlaceholder' => 'La configuración indicada aquí invalidará la configuración a nivel del servidor.',
    'dns.settings.customConfigurationHint' => 'Si no encuentra alguna opción, añádala al campo que se muestra arriba usando la sintaxis de named.conf.',
    'dns.settings.customConfigurationExample' => 'Por ejemplo, para ocultar el nombre de host del servidor DNS, añada la siguiente línea: ',
    'dns.settings.restoreDefaultButton' => 'Usar la configuración predeterminada',

    'dns.template.synchronize-done' => 'La plantilla de zona DNS se ha aplicado correctamente.',
    'dns.template.synchronize-error' => 'La plantilla de zona DNS no se ha aplicado a algunas zonas DNS.',
    'dns.template.synchronize-progress' => 'Aplicando la plantilla de zona DNS.',

    'domain-restriction.name' => 'Nombre de dominio',
    'domain-restriction.nameDescription' => 'Puede especificar un patrón wildcard usando el signo de asterisco (*). Por ejemplo, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'El nombre de dominio especificado ya está en la lista.',

    'event-handler.eventLabel' => 'Evento',
    'event-handler.priorityLabel' => 'Prioridad',
    'event-handler.userLabel' => 'Usuario',
    'event-handler.commandLabel' => 'Comando',
    'event-handler.commandHint' => 'Para un resultado óptimo, introduzca la ruta completa a un archivo script en el campo \'command\'. En ningún caso le recomendamos introducir comandos de sistema, puesto que es posible que no funcionen. Por ejemplo, los comandos con operadores de redirección de salida > o < no funcionarán.',
    'event-handler.priorityHighestText' => 'la más alta',
    'event-handler.priorityHighText' => 'alta',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'baja',
    'event-handler.priorityLowestText' => 'la más baja',
    'event-handler.priorityCustomText' => 'personalizada',
    'event-handler.priorityHighestOption' => 'la más alta (%%value%%)',
    'event-handler.priorityHighOption' => 'alta (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'baja (%%value%%)',
    'event-handler.priorityLowestOption' => 'la más baja (%%value%%)',

    'extension.upload.fileUpload' => 'Ruta al archivo del paquete de la extensión',

    'external-webmail.hint' => 'Cuando registre otro webmail en Plesk, este estará a disposición de sus clientes apareciendo como opción en las propiedades \'Correo\' de las suscripciones y los planes de hosting. En la lista de opciones de webmail se mostrará el nombre del webmail y al hacer clic en el icono del webmail que aparece al lado de un buzón en el panel del cliente se abrirá la URL correspondiente.',
    'external-webmail.name' => 'Nombre del servicio de webmail',
    'external-webmail.url' => 'URL del servicio de webmail',
    'external-webmail.enabled' => 'Disponible',

    'ftp-settings.generalSection' => 'General',
    'ftp-settings.portRange' => 'Puerto o rango de puertos para conexiones pasivas en modo FTP',
    'ftp-settings.hintPortRange' => '(valor predeterminado: %%defaultPortRange%%)',

    'health.upload.hint' => 'Cargue su configuración de Health Server Monitor. La configuración se aplicará tan pronto como se haya cargado.',
    'health.upload.selectFile' => 'Archivo de configuración',

    'install-local-package.selectUploadType' => 'Seleccione una de las siguientes opciones:',
    'install-local-package.uploadAsFile' => 'Cargar un paquete APS',
    'install-local-package.downloadFromCatalog' => 'Seleccionar una aplicación del catálogo de aplicaciones',
    'install-local-package.formInfo' => "Amplíe la lista de aplicaciones disponibles cargando una aplicación nueva o añada una aplicación del catálogo disponible para su posterior configuración.",
    'install-local-package.invalidFileExtension' => 'La aplicación cargada debe ser un archivo ZIP con extensión .zip.',
    'install-local-package.packagesNotSelected' => 'No se ha seleccionado ninguno de los paquetes.',
    'install-local-package.fileNotUploaded' => 'No se puede cargar el archivo.',
    'install-local-package.visible' => 'Hacerlo disponible para los clientes',
    'install-local-package.isCommercial' => 'Esta aplicación es comercial y requiere la compra de una clave de licencia.',
    'install-local-package.visibleDescription' => 'Haga que esta aplicación esté disponible para que los clientes puedan instalarla.',

    'ip-address.addTitle' => 'Añadir dirección IP',
    'ip-address.editTitle' => 'La dirección IP %%address%% en la interfaz %%interface%%',
    'ip-address.generalSection' => 'General',
    'ip-address.interface' => 'Interfaz',
    'ip-address.addressAndSubnetPrefixLength' => 'Dirección IP y máscara de subred',
    'ip-address.addressHintIPv4' => 'Por ejemplo, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Por ejemplo, 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Dirección IP pública',
    'ip-address.hintPublicIp' => 'Si su servidor Plesk se encuentra detrás de NAT, puede usar una dirección IP pública',
    'ip-address.distributionType' => 'La dirección IP se distribuye como',
    'ip-address.distributionTypeShared' => 'Compartida',
    'ip-address.distributionTypeExclusive' => 'Dedicada',
    'ip-address.certificate' => 'Certificado SSL/TLS',
    'ip-address.defaultSite' => 'Sitio predeterminado',
    'ip-address.ftpOverSslNotSupportedByServer' => 'El servidor FTP instalado no soporta FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'El servidor FTP instalado no dispone de soporte para direcciones IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'No es posible añadir la dirección IP. Esta interfaz de red obtiene direcciones IP de forma automática.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Nota: la URL personalizada de Plesk está activada para todos los dominios desconocidos. En vez de mostrarse el sitio predeterminado presente en "https://%%ip%%/", se mostrará la interfaz de Plesk',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'El adaptador de red %%interface%% no existe. Mueva esta dirección IP a otro adaptador de red o elimínela de la lista.',
    'ip-address.none' => 'ninguna',

    'ip-ban.filter.name' => 'Nombre',
    'ip-ban.filter.content' => 'Contenido',
    'ip-ban.filter.filterExistsError' => 'Ya existe un filtro con este nombre.',

    'ip-ban.jail.name' => 'Nombre',
    'ip-ban.jail.filter' => 'Filtro',
    'ip-ban.jail.filterDescription' => 'Seleccione el filtro.',
    'ip-ban.jail.action' => 'Acción',
    'ip-ban.jail.actionDescription' => 'Seleccione una acción y haga clic en el botón para añadirla.',
    'ip-ban.jail.logPath' => 'Ruta del registro',
    'ip-ban.jail.banTime' => 'Periodo de prohibición de la dirección IP',
    'ip-ban.jail.maxRetry' => 'El número máximo de intentos fallidos de inicio de sesión',
    'ip-ban.jail.timeUnit' => 'segundos',
    'ip-ban.jail.addAction' => 'Añadir',
    'ip-ban.jail.chooseAction' => 'Seleccionar:',
    'ip-ban.jail.apache-auth-filter-description' => 'Errores de autorización de Apache (al acceder al archivo)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Errores de autorización de Apache (cualquier acceso)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Errores de autorización de Apache (al acceder al syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spam bots y bad web crawlers',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Errores de autenticación de Courier IMAP y POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Errores de autenticación de Dovecot IMAP, POP3 y Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Errores de autenticación de Dovecot IMAP, POP3 y Sieve (modo agresivo)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Errores de autenticación de webmail Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Vulneraciones de control de acceso y seguridad del firewall para aplicaciones web (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Errores de autenticación de Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Errores de autenticación de Qmail SMTP',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Errores de autenticación de webmail Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Errores de autenticación de WordPress',
    'ip-ban.jail.plesk-manual-filter-description' => 'Filtro ficticio para la prohibición manual',
    'ip-ban.jail.postfix-filter-description' => 'Errores del cliente SMTP de Postfix (incluyendo RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Errores del cliente SMTP de Postfix, errores de autenticación y ataques DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Errores de autenticación de Postfix SMTP y SASL',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Ataques DDoS del SMTP de Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Errores de autenticación y del cliente SMTP de Postfix',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Errores del cliente SMTP de Postfix (incluyendo RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Errores del cliente SMTP de Postfix (solo RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Errores de inicio de sesión de ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hosts prohibidos de forma reiterada por Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Errores de inicio de sesión SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Errores de acceso SSH, errores de negociación y ataques DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Errores de acceso SSH y ataques DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Errores de negociación y de acceso SSH',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Prohibir mediante firewall firewalld, en todos los puertos',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Prohibir mediante firewall firewalld, en múltiples puertos',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Prohibir mediante firewall firewalld, en un único puerto',
    'ip-ban.jail.iptables-action-description' => 'Prohibir mediante firewall iptables, en un único puerto',
    'ip-ban.jail.iptables-allports-action-description' => 'Prohibir mediante firewall iptables, en todos los puertos',
    'ip-ban.jail.iptables-multiport-action-description' => 'Prohibir mediante firewall iptables, en múltiples puertos',
    'ip-ban.jail.sendmail-action-description' => 'Enviar una notificación por email mediante Sendmail',
    'ip-ban.jail.jailExistsError' => 'Ya existe un jail con este nombre.',
    'ip-ban.jail.invalidInteger' => 'El valor especificado no es válido. Indique un número entero.',

    'ip-ban.settings.pageHint' => 'Aquí puede configurar la prohibición de direcciones IP para así proteger su servidor y los sitios web alojados frente a un posible tráfico malintencionado.',
    'ip-ban.settings.detectionEnabled' => 'Activar detección de intrusiones',
    'ip-ban.settings.banPeriod' => 'Periodo de prohibición de la dirección IP',
    'ip-ban.settings.banTimeWindow' => 'Intervalo de tiempo para la detección de ataques subsiguientes',
    'ip-ban.settings.maxRetries' => 'Número de errores antes de proceder con la prohibición de la dirección IP',
    'ip-ban.settings.timeUnit' => 'segundos',
    'ip-ban.settings.invalidInteger' => 'Se ha proporcionado un valor que no es válido. Indique un número entero positivo.',

    'ip-ban.trusted-ip.ipAddress' => 'Dirección IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Una dirección IP, una máscara CIDR o un nombre de host DNS.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Descripción',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Explicación de por qué la dirección IP se añadió a la lista de confianza.',

    'login-info.hint' => 'Aquí puede editar el nombre de usuario y la contraseña utilizados por el usuario para acceder a su panel del cliente.',
    'login-info.resellerHint' => 'Aquí puede cambiar el nombre de usuario y/o la contraseña utilizada por el revendedor para acceder a su Plesk.',
    'login-info.myProfileHint' => 'Aquí puede cambiar la contraseña que utiliza para acceder a su Plesk.',

    'firewall-rule.titleEdit' => 'Edición de una regla de firewall',
    'firewall-rule.titleNew' => 'Añadiendo una regla',
    'firewall-rule.isEnabled' => 'Activar la regla',
    'firewall-rule.name' => 'Nombre de la regla',
    'firewall-rule.profiles' => 'Perfiles',
    'firewall-rule.profilesHint' => 'Seleccione al menos un perfil.',
    'firewall-rule.profileDomain' => 'Dominio',
    'firewall-rule.profilePrivate' => 'Privado',
    'firewall-rule.profilePublic' => 'Público',
    'firewall-rule.action' => 'Acción',
    'firewall-rule.actionAllow' => 'Permitir',
    'firewall-rule.actionBlock' => 'Denegar',
    'firewall-rule.port' => 'Permitir conexiones al siguiente puerto o intervalo de puertos',
    'firewall-rule.portHint' => 'Por ejemplo: 1000 o 1000-1051',
    'firewall-rule.protocolTcp' => 'Protocolo TCP',
    'firewall-rule.protocolUdp' => 'Protocolo UDP',
    'firewall-rule.remoteAddresses' => 'Direcciones remotas',
    'firewall-rule.remoteAddressesHint' => 'Por ejemplo: 192.168.0.1 o 192.168.0.0/16',
    'firewall-rule.newRule' => 'Regla Nueva',
    'firewall-rule.successNew' => 'La regla de firewall ha sido añadida.',
    'firewall-rule.successEdit' => 'La regla de firewall ha sido actualizada.',

    'mail.lists-server-settings.email' => "Email del administrador de la lista de correo",
    'mail.lists-server-settings.emptyEmail' => 'Indique una dirección de email.',
    'mail.lists-server-settings.newPassword' => 'Contraseña nueva',
    'mail.lists-server-settings.emptyPassword' => 'Indique una contraseña.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirme la contraseña',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'El software de listas de correo ha sido configurado.',

    'mail.outgoing-messages.hint' => 'Aquí puede especificar un límite de correos salientes desde un buzón de correo.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'El número máximo de emails salientes',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Predeterminado (%%domainOutgoingMessages%% mensajes por hora)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalizado para este buzón',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensajes por hora',

    'mail-gate-settings.host' => 'Dirección IP o nombre de host',
    'mail-gate-settings.port' => 'Puerto',
    'mail-gate-settings.login' => 'Nombre de usuario',
    'mail-gate-settings.password' => 'Contraseña',
    'mail-gate-settings.encryption' => 'El servidor SMTP requiere una conexión cifrada',
    'mail-gate-settings.allowUsers' => 'Permitir a los scripts de los usuarios enviar correo mediante este servidor SMTP (usando las credenciales especificadas)',
    'mail-gate-settings.useDefaultSettings' => 'Usar el servidor de correo instalado con Plesk y la cuenta de correo predeterminada creada por Plesk',

    'mail-gate.hint' => 'Aquí puede especificar el servidor SMTP que debe usarse cuando el servidor de correo de Plesk no esté instalado o no se le permita enviar correos. Plesk y los scripts de los usuarios usarán este servidor como una retransmisión SMTP para el envío de correos, como puede ser el caso de las notificaciones por email.',
    'mail-gate.enableMailGate' => 'Permitir a Plesk enviar notificaciones por email mediante este servidor SMTP',
    'mail-gate.notifications' => 'Notificaciones por email a través de un servidor SMTP externo',
    'mail-gate.smtpSettings' => 'Configuración de servidor SMTP externo',

    'optimization-settings.apacheModulesSection' => 'Módulos Apache',
    'optimization-settings.nginxSettingsSection' => 'Configuración de nginx',
    'optimization-settings.nginxHttp3Enabled' => 'Soporte de HTTP/3',
    'optimization-settings.nginxHttp3EnabledHint' => 'Activar el soporte para HTTP/3 a nivel del servidor para todos los sitios web alojados mejora el rendimiento del sitio web en las redes modernas. Sin embargo, puede desactivar el soporte para HTTP/3 en la configuración de una suscripción individual si es necesario. El tiempo necesario para activar o desactivar el soporte para HTTP/3 depende del número de dominios afectados y puede tardar varios minutos.',
    'optimization-settings.apacheSettingsSection' => 'Configuración de Apache',
    'optimization-settings.additionalPageHint' => 'Realice modificaciones en los módulos únicamente en el caso de entender totalmente las consecuencias de sus acciones. Tenga en cuenta que algunas modificaciones pueden reducir el rendimiento de Apache o incluso ocasionar que no esté operativo. ',
    'optimization-settings.pageHint' => 'Aquí puede optimizar Plesk desactivando módulos Apache que no se estén utilizando. Esta optimización mejora el uso de la memoria y le permite dar servicio a más clientes de hosting. Tenga en cuenta que algunos módulos tienen dependencias entre ellos y que solo pueden activarse o desactivarse cuando los módulos de los que dependen están activados o desactivados.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Esta prestación solo va dirigida a usuarios avanzados. ',
    'optimization-settings.apacheRestartInterval' => 'Intervalo de reinicio de Apache (segundos)',
    'optimization-settings.apacheRestartIntervalHint' => 'Una vez en el intervalo especificado, Plesk comprueba los cambios realizados en los dominios y subdominios. En el caso de que alguno de los cambios requiera el reinicio del servidor web, Plesk reiniciará Apache.',
    'optimization-settings.gracefulRestart' => 'Reinicio estable de Apache',
    'optimization-settings.gracefulRestartHint' => 'Selecciónelo para evitar que todos los sitios web alojados en el servidor queden inoperativos cada vez que modifique la configuración de hosting.',
    'optimization-settings.pipedLog' => 'Registros redireccionados',
    'optimization-settings.mpmMode' => 'Modo MPM',
    'optimization-settings.moduleDeprecated' => '(En desuso)',

    'personal-info.contactInfoSection' => 'Información de contacto',
    'personal-info.hint' => 'Aquí puede editar la información de contacto del usuario.',
    'personal-info.hintMyProfile' => 'Aquí puede editar su información de contacto.',

    'php-handler.extension.title' => 'Instalar paquete PECL',
    'php-handler.extension.description' => "Puede instalar una versión beta de una extensión indicando parámetros adicionales con el nombre del paquete. Por ejemplo, 'msgpack-beta'.",
    'php-handler.extension.name' => 'Nombre del paquete',

    'php-handler.ini.formHint' => 'Este archivo php.ini solo es usado por este controlador.',
    'php-handler.ini.formHintSharedIni' => 'Este archivo php.ini también es usado por los siguientes controladores PHP: %%handlers%%. La configuración se aplica a todos aquellos sitios web que utilicen estos controladores.',
    'php-handler.ini.incorrectTextForIniFile' => "La configuración especificada no es correcta y no puede guardarse en el archivo php.ini. Error: %%message%%.",

    'plan-item-custom.planItemName' => 'Nombre del servicio',
    'plan-item-custom.buttonLabel' => 'Este nombre también se usará como etiqueta para el botón personalizado.',
    'plan-item-custom.planItemDescription' => 'Descripción del servicio',
    'plan-item-custom.buttonTooltip' => 'Este texto también se mostrará como un tooltip para el botón personalizado',
    'plan-item-custom.url' => 'URL vinculada al botón personalizado',
    'plan-item-custom.backgroundImage' => 'Imagen de fondo para el botón personalizado',
    'plan-item-custom.emptyItemName' => 'Proporcione una etiqueta para el servicio.',
    'plan-item-custom.emptyItemDescription' => 'Proporcione un texto para el tooltip del servicio.',
    'plan-item-custom.emptyUrl' => 'Especifique una URL.',
    'plan-item-custom.longItemName' => 'La etiqueta para este servicio es demasiado larga. La longitud máxima permitida es de %max% símbolos.',
    'plan-item-custom.longItemDescription' => 'El texto para este servicio es demasiado largo. La longitud máxima permitida es de %max% símbolos.',
    'plan-item-custom.longUrl' => 'Esta URL es demasiado larga. La longitud máxima permitida es de %max% símbolos.',
    'plan-item-custom.useCustomButton' => 'Usar botón personalizado para el servicio',
    'plan-item-custom.useCustomButtonHint' => 'Añada un botón personalizado a la página principal del usuario y en las páginas del sitio web.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Abrir la URL en Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Especifique si desea abrir la URL en una página de Plesk o en una ventana nueva del navegador.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'No usar marcos',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Si añade un botón personalizado que redirecciona a una extensión de Plesk o a una aplicación del panel del cliente, puede indicar cómo desea que se muestre esta extensión o aplicación: en un marco o como parte del GUI de Plesk.',
    'plan-item-custom.includeDomId' => 'Incluir ID de suscripción',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Incluir el nombre del dominio principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Incluir el nombre de usuario FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Incluir la contraseña FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Incluir ID del cliente',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Incluir el nombre de la empresa del cliente",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Incluir nombre de contacto del cliente",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Incluir el email del cliente",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',
    'plan-item-custom.fileNotUploaded' => 'No se puede cargar el archivo.',

    'preview-domain-settings.previewType' => 'Seleccione cómo desea previsualizar los sitios web',
    'preview-domain-settings.previewQuick' => 'Previsualización rápida predeterminada',
    'preview-domain-settings.previewDisabled' => 'Desactivar la previsualización rápida',
    'preview-domain-settings.previewQuickDescription' => 'Una opción recomendada que puede usarse de inmediato.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Vista previa rápida de un nombre de dominio en Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Seleccione uno de sus sitios web servidos por Plesk para realizar la previsualización.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Para usar esta prestación, %%link%% al menos un dominio.',
    'preview-domain-settings.subscriptionCreateLink' => 'cree',
    'preview-domain-settings.previewZoneTypeExternal' => 'Vista previa rápida en un nombre de dominio externo',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Usar un nombre de dominio externo (zona DNS). Si selecciona esta opción, añada el siguiente registro DNS (de tipo A) a la zona de dominio externa: *.<Plesk_IP>.external.dom. Aquí, <Plesk_IP> es la dirección IP del servidor Plesk, donde los puntos (.) para IPv4 o los dos puntos (:) para IPv6 se reemplazan por guiones (-). Por ejemplo, *.192-0-2-12.external.dom. Si en Plesk se ha registrado más de una dirección IP, añada un registro para cada una de las direcciones.',
    'preview-domain-settings.sitePreviewProtection' => 'Requerir autenticación',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Requerir nombre de usuario FTP y contraseña para acceder a la previsualización.',
    'preview-domain-settings.nginxNotInstalled' => 'La previsualización rápida predeterminada no está disponible porque no se ha instalado el servidor web nginx.',
    'preview-domain-settings.nginxDisabled' => 'La previsualización rápida predeterminada no está disponible porque el servidor web nginx está desactivado.',

    'reseller-preferences.settingsSection' => 'Configuración',
    'reseller-preferences.multiLogin' => 'Permitir múltiples sesiones',
    'reseller-preferences.language' => 'Idioma de la interfaz',
    'reseller-preferences.interfaceView' => 'Seleccione su interfaz',
    'reseller-preferences.serviceProviderView' => 'Vista de proveedor de servicios',
    'reseller-preferences.serviceProviderViewHint' => 'Esta vista va dirigida a administradores de servidor que proporcionen y comercialicen servicios de hosting web a sus clientes mediante planes de servicios.',
    'reseller-preferences.powerUserView' => 'Vista Power User',
    'reseller-preferences.powerUserViewHint' => 'Esta vista es la más apropiada para la gestión de sitios web, sus archivos, bases de datos, cuentas de email, aplicaciones web y otros servicios.',

    'reseller.hint' => 'Aquí puede dar de alta un revendedor nuevo para sus servicios de hosting.',
    'reseller.contactInfoSection' => 'Información de contacto',
    'reseller.contactInfoSectionHint' => 'Introduzca la información de contacto del revendedor.',
    'reseller.accessToPanelSection' => 'Acceso a Plesk',
    'reseller.accessToPanelSectionHint' => 'Credenciales que usará el revendedor para acceder a Plesk para la administración de los servicios a los que está suscrito.',
    'reseller.subscription' => 'Suscripción',
    'reseller.subscriptionSectionHint' => 'Seleccione el plan de servicio al que se suscribirá el revendedor.',
    'reseller.servicePlan' => 'Plan de servicio',
    'reseller.none' => 'ninguno',
    'reseller.customizeSubscription' => 'Una vez creado el revendedor, personalizar los parámetros de la suscripción. Tenga en cuenta que esto bloqueará la sincronización de la suscripción.',
    'reseller.subscriptionNotSynchronized' => 'La suscripción no pudo sincronizarse con el plan de servicio. La configuración de la suscripción detallada a continuación entra en conflicto con el plan de servicio: %%problems%%.',

    'security-policy.encryptionSection' => 'Modo de seguridad mejorada',
    'security-policy.encryptionSectionHint' => 'El modo de seguridad mejorada proporciona protección avanzada de los datos confidenciales presentes en Plesk. En este modo, Plesk emplea múltiples mecanismos de seguridad totalmente transparentes para los usuarios de Plesk. Para mejorar la seguridad de Plesk, le recomendamos activar este modo.',
    'security-policy.encryptionEnable' => 'Modo de seguridad mejorada',
    'security-policy.securePassword' => 'Modo de seguridad mejorada',
    'security-policy.strengthSection' => 'Seguridad de contraseñas',
    'security-policy.strengthSectionHint' => 'La mayoría de contraseñas que los usuarios pueden establecer o cambiar en Plesk son validadas para así garantizar que aquí se cumplen los requisitos mínimos de seguridad de contraseñas. Las contraseñas seguras al menos están formadas por 9-12 caracteres e incluyen dígitos, letras en minúsculas y mayúsculas, caracteres especiales y ninguna palabra del diccionario. Estas son más difíciles de adivinar pero también de recordar. <a href="%%link%%" target="_blank">Más información sobre la seguridad de contraseñas</a>.',
    'security-policy.passwordStrength' => 'Seguridad mínima de contraseñas',
    'security-policy.secureFtpSection' => 'FTP seguro',
    'security-policy.ftpOverSsl' => 'Directiva de uso de FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS. Aquí puede seleccionar las conexiones que desea permitir.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS. Aquí puede seleccionar las conexiones que desea permitir. La opción seleccionada se aplicará a todas las direcciones IP del servidor. Si desea utilizar ajustes personalizados para cada dirección IP, seleccione la opción correspondiente y modifique la directiva FTPS en Herramientas y configuración> Direcciones IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS se utiliza para proteger la comunicación entre el servidor FTP y los clientes FTP externos mediante los protocolos SSL/TLS. Si desea ajustar la configuración FTPS para cada dirección IP, en primer lugar seleccione la opción "Utilizar ajustes de FTPS personalizados para cada dirección IP" en Herramientas y configuración> Directiva de seguridad> FTP seguro.',
    'security-policy.ftpOverSslOptionRequired' => 'Permitir únicamente conexiones FTPS seguras',
    'security-policy.ftpOverSslOptionEnabled' => 'Permitir tanto conexiones FTPS seguras como conexiones FTP no seguras',
    'security-policy.ftpOverSslOptionDisabled' => 'Permitir únicamente conexiones FTP no seguras. No utilizar FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Utilizar directiva FTPS personalizada para cada dirección IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Directiva de controladores personalizada',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Active esta opción para que los clientes no puedan sobrescribir los controladores IIS definidos a nivel del servidor mediante el archivo web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Permitir la invalidación de controladores web.config',
    'security-policy.emailPasswordsSection' => 'Almacenamiento de contraseñas de email',
    'security-policy.emailPasswordsSectionHint' => 'Las contraseñas de las cuentas de email pueden cifrarse simétricamente o mediante hash. Después de cambiar esta configuración, la nueva política se aplicará a todas las cuentas nuevas y existentes la próxima vez que se cambie la contraseña.',
    'security-policy.emailPasswordHashingLabel' => 'Método de almacenamiento',
    'security-policy.emailPasswordSymmetric' => 'Cifrado simétrico',
    'security-policy.emailPasswordHashing' => 'Hash',
    'security-policy.emailPasswordSymmetricHint' => 'Más práctico. Las contraseñas se pueden descifrar.',
    'security-policy.emailPasswordHashingHint' => 'Más seguro. Las contraseñas no se pueden descifrar.',

    'server-mail-antivirus.used' => 'Antivirus usado',
    'server-mail-antivirus.policy' => 'Usar opciones del servidor',
    'server-mail-antivirus.policyOff' => 'Detección desactivada',
    'server-mail-antivirus.policyAny' => 'Analizar tanto el correo entrante como el correo saliente',
    'server-mail-antivirus.policyFrom' => 'Solo analizar correo saliente',
    'server-mail-antivirus.policyTo' => 'Solo analizar correo entrante',
    'server-mail-antivirus.allowPersonalSettings' => 'Permitir opciones personales',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Permita el reemplazo de la configuración a nivel del servidor en cada dirección de email',
    'server-mail-antivirus.incoming' => 'para correo entrante',
    'server-mail-antivirus.outgoing' => 'para correo saliente',
    'server-mail-antivirus.success' => 'La configuración del antivirus ha sido modificada.',

    'server-mail-black-list.title' => 'Añadir dominio a la lista negra',
    'server-mail-black-list.domainName' => 'Nombre del dominio',
    'server-mail-black-list.emailAddress' => 'Direcciones de email',
    'server-mail-black-list.emailAddressHint' => 'No debe haber ningún carácter no ASCII a la izquierda del signo @. Las direcciones pueden incluir wildcards "*" y "?" (por ejemplo, *@domain.com, user?@*.com). Las partes no ASCII de los nombres de dominio no deben contener wildcards.',
    'server-mail-black-list.action' => 'Qué hacer con el correo que coincida con el criterio:',
    'server-mail-black-list.actionDelete' => 'Eliminar del servidor',
    'server-mail-black-list.actionSpam' => 'Marcar como spam',
    'server-mail-black-list.success' => 'El dominio ha sido añadido a la lista negra.',

    'server-mail-white-list.title' => 'Añadir red a la lista blanca',
    'server-mail-white-list.descEmailAddress' => 'Las direcciones de email indicadas aquí no serán reconocidas como spam por parte de SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'Las entradas IP indicadas aquí se añadirán a las excepciones del servidor de correo.',
    'server-mail-white-list.ipAddress' => 'Máscara/dirección IP',
    'server-mail-white-list.ipAddressHint' => 'La dirección IP puede incluir una máscara CIDR o wildcard.',
    'server-mail-white-list.emailAddress' => 'Direcciones de email',
    'server-mail-white-list.emailAddressHint' => 'No debe haber ningún carácter no ASCII a la izquierda del signo @. Las direcciones pueden incluir wildcards "*" y "?" (por ejemplo, *@domain.com, user?@*.com). Las partes no ASCII de los nombres de dominio no deben contener wildcards.',
    'server-mail-white-list.emailAddressOrIp' => 'Email o direcciones IP',
    'server-mail-white-list.wildcardPattern' => 'Las direcciones IP pueden incluir wildcards (por ejemplo, 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'Las direcciones IP pueden contener máscaras CIDR (por ejemplo, 10.0.0.0/8).',
    'server-mail-white-list.success' => 'La red se ha añadido a la lista blanca.',

    'server-mail-settings.general.title' => 'Opciones generales',
    'server-mail-settings.general.mailUiEnabled' => 'Habilitar funciones de gestión de correo en Plesk',
    'server-mail-settings.general.mailUiEnabledHint' => 'Al deseleccionar la casilla, se elimina la capacidad de crear buzones de correo y cambiar la configuración de correo para dominios a través de la GUI de Plesk. El servicio de correo seguirá funcionando y el servicio de webmail seguirá estando disponible.',
    'server-mail-settings.general.serverName' => 'Servidor de correo instalado',
    'server-mail-settings.general.changeServerName' => 'instalar y usar otro servidor de correo',
    'server-mail-settings.general.imapServerName' => 'Servidor POP3/IMAP instalado',
    'server-mail-settings.general.changeImapServerName' => 'instalar y usar otro servidor IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Puede %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Tamaño máximo del mensaje',
    'server-mail-settings.general.kbytes' => 'KBytes',
    'server-mail-settings.general.maxConnections' => 'Número máximo de conexiones (IMAP, POP3, IMAP a través de SSL/TLS o POP3 a través de SSL/TLS).',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'El número máximo de servidores (IMAP o POP3) iniciados.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'El número máximo de usuarios de correo que pueden iniciar sesión de forma simultánea.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Número máximo de conexiones por dirección IP',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Número máximo de conexiones para un usuario por dirección IP',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'El número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS) a aceptar desde la misma dirección IP.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'El número máximo de conexiones (IMAP, POP3, IMAP mediante SSL/TLS o POP3 mediante SSL/TLS) que puede establecer un usuario de correo desde cada dirección IP.',
    'server-mail-settings.general.messageSubmission' => 'Activar el servicio SMTP en el puerto 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Activar el servicio SMTP en el puerto 587 en todas las direcciones IP',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Habilitado',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'todas las direcciones IP',
    'server-mail-settings.general.outgoingEmailMode' => 'Modo de envío del correo saliente',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Enviar desde las direcciones IP del dominio',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Enviar desde las direcciones IP del dominio y usar los nombres de dominio en el saludo SMTP',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Enviar desde las direcciones IP especificadas',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Ninguno',
    'server-mail-settings.general.subaddressing' => 'Activar subdireccionamiento de email',
    'server-mail-settings.general.subaddressingHint' => 'Esta opción permite configurar direcciones de email %%verpStyleLink%% para listas de correo',
    'server-mail-settings.general.verpStyleLink' => 'Estilo VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Activar advertencia de cuota de buzón de correo',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Enviar una notificación a los usuarios de correo cuando su uso de la cuota de correo supere el 95 %',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Personalizar la advertencia de cuota de buzón personalizada',
    'server-mail-settings.general.fixSender' => 'Corregir remitentes establecidos incorrectamente para correo saliente',
    'server-mail-settings.general.fixSenderHint' => 'Configure encabezados de correo válidos de forma automática así como direcciones de remitentes para correos salientes desde dominios para así reducir la posibilidad de que se consideren spam',
    'server-mail-settings.general.maxMessageSizeHint' => 'En los correos con archivos adjuntos, el valor debe ser un 35-40 % superior al del tamaño del adjunto. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Para más información, consulte el artículo de nuestra base de conocimiento',

    'server-mail-settings.autodiscover.title' => 'Detección automática de correo',
    'server-mail-settings.autodiscover.description' => 'Descubra cómo funciona en la %%link%%',
    'server-mail-settings.autodiscover.link' => 'base de conocimiento',
    'server-mail-settings.autodiscover.enabled' => 'Activar detección automática de correo',
    'server-mail-settings.autodiscover.enabledHint' => 'De activarse esta prestación, se reconfigurarán todos los dominios que tengan activada la detección automática',
    'server-mail-settings.autodiscover.customServer' => 'Nombre de dominio personalizado',
    'server-mail-settings.autodiscover.customServerHint' => 'Especifique un nombre de dominio personalizado que utilizarán los servidores de correo entrante y saliente para la configuración de detección automática de correo.',
    'server-mail-settings.autodiscover.customServerCertHint' => 'Nota: el nombre de dominio debe estar protegido con un certificado SSL/TLS válido.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Reconfigurar registros DNS de detección automática',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'De activarse esta prestación, se reconfigurarán todos los registros DNS de detección automática de dominios que tengan activada la detección automática',

    'server-mail-settings.relay.title' => 'Opciones de retransmisión',
    'server-mail-settings.relay.type' => "En retransmisión",
    'server-mail-settings.relay.open' => "abierto",
    'server-mail-settings.relay.openSpamWarning' => "La apertura de su retransmisión de correo expone su servidor de correo a spam.",
    'server-mail-settings.relay.openSpamChange' => "Mantenga la opción únicamente si desea probar el servidor de correo de forma temporal o si su servidor Plesk se encuentra en una red interna no accesible mediante Internet.",
    'server-mail-settings.relay.closed' => "cerrado",
    'server-mail-settings.relay.auth' => "autorización obligatoria: ",
    'server-mail-settings.relay.notSupported' => "no soportada por el servidor de correo",
    'server-mail-settings.relay.change' => 'Para que Plesk pueda enviar notificaciones cuando la retransmisión esté cerrada, puede %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'cambiar la configuración SMTP',
    'server-mail-settings.relay.pop3' => "POP3 antes que SMTP",
    'server-mail-settings.relay.lockTime' => "tiempo de bloqueo",
    'server-mail-settings.relay.min' => "min",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'No usar restricciones de retransmisión para las siguientes redes:',
    'server-mail-settings.relay.noRelayNetworksHint' => "Máscara/dirección IP",

    'server-mail-settings.outgoing.title' => 'Limitaciones de correos salientes',
    'server-mail-settings.outgoing.description' => 'Estos son los límites predeterminados. Estos pueden sobrescribirse en cada suscripción y plan de servicio. Los límites no funcionan a nivel del servidor, pero actúan como plantilla para aquellos planes y suscripciones para los que no se ha especificado ningún límite personalizado. Tenga en cuenta que la activación de la limitación de los correos salientes puede afectar al rendimiento del servidor de correo. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Obtenga más información sobre la limitación del correo saliente',
    'server-mail-settings.outgoing.enabled' => 'Activar limitaciones de correos salientes',
    'server-mail-settings.outgoing.countRecipients' => 'Contar el número de destinatarios en vez de mensajes',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Activa el modo que cuenta el número de destinatarios en vez de los mensajes cuando se limita el correo saliente y el recuento de estadísticas. Por ejemplo, un mensaje enviado a 10 destinatarios se contabilizará como diez mensajes.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Límite predeterminado de correos salientes desde un buzón de correo (por hora)',
    'server-mail-settings.outgoing.domainLimit' => 'Límite predeterminado de correos salientes desde un dominio (por hora)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Límite predeterminado de correos salientes desde una suscripción (por hora)',
    'server-mail-settings.outgoing.unlimited' => 'Ilimitado',
    'server-mail-settings.outgoing.sendmail' => 'Permitir a los scripts y usuarios utilizar Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Los scripts y usuarios podrán enviar correos (en nombre del usuario de sistema de la suscripción) usando Sendmail incluso si se han excedido los límites de un buzón de correo y un dominio. El número máximo de mensajes que puede enviarse mediante Sendmail se definirá por el límite para toda una suscripción. Esta opción no permite a los scripts hacer uso de Sendmail a nivel del servidor, si bien actúa como opción predeterminada para los planes de servicio y las suscripciones.',
    'server-mail-settings.outgoing.reportPeriod' => 'Mostrar informes basándose en las estadísticas de las últimas',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Se crean los informes y en la página principal se muestra una alerta acerca de los intentos de exceder los límites de correo saliente durante el periodo especificado.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Enviar una notificación por email cada',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Las notificaciones proporcionan estadísticas acerca de los intentos de exceder los límites de correo saliente durante el periodo especificado.',
    'server-mail-settings.outgoing.periodP1D' => '1 día',
    'server-mail-settings.outgoing.periodP1W' => '1 semana',
    'server-mail-settings.outgoing.periodP2W' => '2 semanas',
    'server-mail-settings.outgoing.periodP1M' => '1 mes',
    'server-mail-settings.outgoing.periodPT15M' => '15 minutos',
    'server-mail-settings.outgoing.periodPT1H' => '1 hora',
    'server-mail-settings.outgoing.periodPT6H' => '6 horas',
    'server-mail-settings.outgoing.periodPT12H' => '12 horas',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Los límites del correo saliente no funcionarán en el caso de remitentes cuya dirección IP esté presente en la lista blanca del servidor de correo. Por ejemplo, si en la lista blanca existe localhost (127.0.0.0 / 8, ::1 / 128), todos los correos procedentes del servidor local se enviarán correctamente sean cuales sean las limitaciones establecidas. Aquellos que envíen correos pueden utilizar direcciones IP locales (sitios web y scripts personalizados alojados en el servidor local) o direcciones IP externas (clientes que envían correos a través de clientes de correo instalados en sus ordenadores o dispositivos móviles). Para que se apliquen los límites establecidos para todos los remitentes de correo (tanto locales como externos), elimine todas las direcciones IP y redes de la lista blanca. Tenga en cuenta que la eliminación de localhost (127.0.0.0 / 8, ::1 / 128) de la lista blanca puede ocasionar una interrupción de los sitios web y scripts que envían correos desde este servidor. Si desea más información acerca de las limitaciones del correo saliente, consulte la sección Protección frente a spam saliente de la guía del administrador.',
    'server-mail-settings.outgoing.relayIsOpen' => 'La retransmisión de correo está abierta. No se aplicarán los límites de correo saliente.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'El límite de correos salientes para un dominio (%%value%%) no puede ser superior al límite para una suscripción (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'El límite de correos salientes para una dirección de email (%%value%%) no puede ser superior al límite para un dominio (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'El límite de correos salientes para una dirección de email (%%value%%) no puede ser superior al límite para una suscripción (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Configuración de Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Usar enlaces seguros en las listas de correo',
    'server-mail-settings.mailman.secureLinksHint' => 'Active o desactive la generación de enlaces seguros (HTTPS) en las listas de correo.',
    'server-mail-settings.mailman.noLocalhost' => 'Para usar listas de correo es necesario que localhost (127.0.0.0/8, ::1/128) esté presente en la lista blanca del servidor de correo. De todos modos, para poder hacer uso del control del correo saliente, localhost no debería estar en esta lista. Así, si activó el control del correo saliente, puede usar el redireccionamiento de correo en el buzón en vez de usar listas de correo.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Para usar listas de correo es necesario que localhost esté presente en la lista blanca del servidor de correo. De todos modos, para poder hacer uso del control del correo saliente, localhost no debería estar en esta lista. Así, si activó el control del correo saliente, puede usar el redireccionamiento de correo en el buzón en vez de usar listas de correo. Tenga en cuenta que en este momento la lista blanca no incluye ninguna dirección IPv4 localhost (127.0.0.0/8), por lo que el control del correo saliente sí que funcionará para las direcciones IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Para usar listas de correo es necesario que localhost esté presente en la lista blanca del servidor de correo. De todos modos, para poder hacer uso del control del correo saliente, localhost no debería estar en esta lista. Así, si activó el control del correo saliente, puede usar el redireccionamiento de correo en el buzón en vez de usar listas de correo. Tenga en cuenta que en este momento la lista blanca no incluye ninguna dirección IPv6 localhost (::1/128), por lo que el control del correo saliente sí que funcionará para las direcciones IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Activar DMARC para la comprobación del correo entrante',
    'server-mail-settings.spam-filter.dmarcHint' => 'Esta opción se encuentra disponible cuando DKIM y SPF están activados para los correos entrantes.',
    'server-mail-settings.spam-filter.dkim' => 'Protección antispam DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Permitir la firma del correo saliente',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Comprobar correo entrante',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Esta opción no puede desactivarse se DMARC se encuentra activado para los correos entrantes.',
    'server-mail-settings.spam-filter.spf' => 'Protección antispam SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Activar protección antispam SPF para el análisis del correo entrante',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Esta opción no puede desactivarse se DMARC se encuentra activado para los correos entrantes.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'La comprobación SPF sigue en curso aunque se experimenten problemas al realizar la búsqueda en el DNS',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'En primer lugar, SPF realiza una búsqueda en el DNS. Seleccione esta opción para seguir realizando la comprobación si esta búsqueda resulta fallida. Esta opción está deseleccionada si esta no tiene ningún efecto en el modo de comprobación actual.',
    'server-mail-settings.spam-filter.behavior' => 'Modo de verificación SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'En este caso, SPF aplica reglas locales y de conjetura. El mensaje puede rechazarse en función del modo de comprobación seleccionado y del resultado de dicha comprobación.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Solo crear cabeceras SPF de recepción, nunca bloquear',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Usar avisos de error temporal cuando tenga problemas de resolución DNS',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Rechazar correo cuando SPF resuelva a "fail" (denegar)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Rechazar correo cuando SPF resuelva a "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Rechazar correo cuando SPF resuelva a "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Rechazar correo cuando SPF no resuelva a "pass"',
    'server-mail-settings.spam-filter.localRules' => 'Reglas locales SPF',
    'server-mail-settings.spam-filter.guessRules' => 'Reglas de conjetura SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Texto de explicación SPF',
    'server-mail-settings.spam-filter.rbl' => "Protección antispam basada en listas negras del DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Activar protección antispam basada en listas negras del DNS",
    'server-mail-settings.spam-filter.rblServer' => "Zonas DNS para el servicio DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "Separe las entradas con un punto y coma, por ejemplo: 'dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Encabezados de respuesta automática adicionales',
    'server-mail-settings.auto-reply-headers.description' => 'Configure encabezados adicionales para cualquier mensaje de respuesta automática procedente del servidor Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Encabezados adicionales',

    'server-mail-settings.pop3-names.title' => "Nombres para cuentas de correo POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Solo se permite el uso de nombres completos de cuentas de correo POP3/IMAP",
    'server-mail-settings.pop3-names.enabled' => "Pueden usarse nombres cortos (webmaster) y completos (webmaster@domain.com) de cuentas de correo POP3/IMAP.",

    'server-mail-settings.success' => 'La configuración del servidor de correo ha sido actualizada.',

    'server-mail-spam-filter.general' => 'General',
    'server-mail-spam-filter.isEnabled' => 'Activar filtración antispam SpamAssassin a nivel de servidor',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin no está instalado.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Activar protección antispam greylisting a nivel de servidor',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Aplicar configuración individual al filtro antispam',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "El filtro antispam está desactivado porque el servidor de correo no soporta la configuración del filtro antispam a nivel del buzón de correo.",
    'server-mail-spam-filter.settings' => 'Configuración de SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Máximo de procesos',
    'server-mail-spam-filter.maxChildrenDescription' => 'Número máximo de procesos de trabajo spamd a ejecutar.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Puntuación necesaria',
    'server-mail-spam-filter.requiredHitsDescription' => 'Puntuación que debe recibir el mensaje para cualificarse como spam.',
    'server-mail-spam-filter.maxMailLimit' => 'No filtrar si el tamaño del correo excede este valor',
    'server-mail-spam-filter.maxMailLimitText' => 'tamaño máximo',
    'server-mail-spam-filter.kbytes' => "KBytes",
    'server-mail-spam-filter.maxThreadsLimit' => 'Nº procesos que puede crear el filtro antispam',
    'server-mail-spam-filter.tagTitle' => 'Etiqueta de spam',
    'server-mail-spam-filter.tagDescription' => 'Se añadirá el siguiente texto al principio del asunto de los mensajes que se consideren spam.',
    'server-mail-spam-filter.alarmMessage' => 'Texto de alerta cuando se detecte spam',
    'server-mail-spam-filter.languages' => 'Idiomas de confianza',
    'server-mail-spam-filter.locales' => 'Idiomas de confianza',
    'server-mail-spam-filter.success' => 'La configuración del filtro antispam ha sido modificada.',
    'server-mail-spam-filter.personalSettingsWarning' => 'El administrador del servidor ha desactivado la habilidad para aplicar una configuración personalizada de la filtración de spam. Los parámetros de filtración de spam especificados a continuación no podrán ser aplicados',

    'service-plan.admin-plan.subscription_section' => 'Común',
    'service-plan.admin-plan.tools_section' => 'Herramientas y recursos',
    'service-plan.admin-plan.apps_section' => 'Aplicaciones y bases de datos',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Apariencia de Plesk',
    'service-plan.admin-plan.statistics_section' => 'Estadísticas',
    'service-plan.admin-plan.general_section' => 'General',
    'service-plan.admin-plan.mail_section' => 'Correo',
    'service-plan.admin-plan.server_section' => 'Servidor',
    'service-plan.admin-plan.modules_section' => 'Extensiones',
    'service-plan.admin-plan.troubleshooting_section' => 'Ayuda y resolución de problemas',
    'service-plan.admin-plan.simplePanel' => 'Modo restringido',
    'service-plan.admin-plan.enabled' => 'Activar modo restringido',
    'service-plan.admin-plan.enabledDescription' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador en Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador adicional en Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Proporcionar sólo las aplicaciones que yo seleccione',
    'service-plan.applications-subscription.useFilterDescription' => 'Use esta opción para seleccionar las aplicaciones que deberían estar disponibles para el suscriptor.',
    'service-plan.applications-subscription.applications' => 'Aplicaciones',
    'service-plan.applications-subscription.isCommercial' => 'Esta aplicación es comercial y requiere la compra de una clave de licencia.',

    'service-plan.applications.useFilterLabel' => 'Proporcionar sólo las aplicaciones que yo seleccione',
    'service-plan.applications.useFilterDescription' => 'Use esta opción para seleccionar las aplicaciones que deberían estar disponibles para los suscriptores.',
    'service-plan.applications.applications' => 'Aplicaciones',
    'service-plan.applications.isCommercial' => 'Esta aplicación es comercial y requiere la compra de una clave de licencia.',

    'service-plan.dns.dnsZoneType' => 'Zona DNS del dominio',
    'service-plan.dns.dnsZoneTypeMaster' => 'Principal',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secundario',

    'service-plan.extras.groupOtherServices' => 'Otros servicios',
    'service-plan.extras.none' => 'Ninguno',

    'service-plan.hosting.enablePhysicalHosting' => 'Habilitar hosting',
    'service-plan.hosting.sectionCoreHosting' => 'Propiedades generales',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Servidor de bases de datos predeterminado',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avanzado',
    'service-plan.hosting.phpSettingsHelpLink' => 'Descubra cómo seleccionar la configuración PHP más adecuada',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Estado de los sitios web si se suspende la suscripción',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Estado de los sitios web en suscripciones suspendidas',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'El estado seleccionado se aplicará a todos los sitios web bajo las suscripciones del plan cuando se suspenda la suscripción, como por ejemplo en el caso de que esta expire o haya vencido su periodo de pago.',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'El estado seleccionado se aplicará a los sitios web cuando se suspenda la suscripción, como por ejemplo en el caso de que esta expire o haya vencido su periodo de pago.',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Desactivado',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Los visitantes de los sitios web serán redireccionados a la página predeterminada del servidor web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspendido',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Los visitantes de los sitios web serán redireccionados a la página de documentos de error personalizados mediante un código HTTP 503 del motor de búsqueda.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Activo',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Los sitios web seguirán siendo accesibles mediante Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Asignar direcciones IP compartidas',
    'service-plan.ip.allocateExclusiveIp' => 'Asignar direcciones IP dedicadas',
    'service-plan.ip.allocateExclusiveIpV4' => 'Asignar direcciones IPv4 dedicadas',
    'service-plan.ip.allocateExclusiveIpV6' => 'Asignar direcciones IPv6 dedicadas',

    'service-plan.mail.mailService' => 'Servicio de correo',
    'service-plan.mail.mailServiceDisabled' => 'Desactivado',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Desactivado para el correo entrante',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk no proporcionará ningún servicio de correo en los dominios.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Los dominios solo pueden enviar correo y únicamente mediante Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Activado',
    'service-plan.mail.mailServiceEnabledHint' => 'Los dominios pueden enviar y recibir correo.',
    'service-plan.mail.mailServiceNotConfigured' => 'No configurado',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk no proporcionará ningún servicio de correo en los dominios.',
    'service-plan.mail.webMail' => 'Webmail',
    'service-plan.mail.mailingLists' => 'Activar listas de correo',
    'service-plan.mail.mailToNonExistentUser' => 'Directiva relacionada con mensajes para usuarios no existentes',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Devolver con mensaje',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Reenviar a la dirección',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rechazar',
    'service-plan.mail.mailAutodiscovery' => 'Activar detección automática de correo',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Descubra cómo funciona en la <a href="%%link%%" target="_blank">base de conocimiento</a>',
    'service-plan.mail.bounceMessage' => 'Esta dirección ya no acepta correo.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Redireccionar a un servidor de correo externo con la dirección IP',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - desactivado',
    'service-plan.mail.notConfiguredConfirm' => 'Eliminar todos los buzones de correo de los dominios afectados de forma permanente, incluyendo los emails enviados y recibidos.',
    'service-plan.mail.notConfiguredConfirmError' => 'Confirme',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Nota: La opción Conservar estadísticas de tráfico y web no se modifica en las suscripciones cuando usted la actualiza para un plan de servicio. La única forma de actualizar esta opción para cada dominio es modificarla en la base de datos de Plesk. Para más información, consulte <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">este artículo de nuestra base de conocimientos</a>.',
    'service-plan.misc.retainEnabled' => 'Conservar estadísticas de tráfico y web durante',
    'service-plan.misc.logRotation' => 'Rotación de registros',
    'service-plan.misc.logRotationCondition' => 'Condición de rotación de registros',
    'service-plan.misc.logRotationBySize' => 'Por tamaño',
    'service-plan.misc.logRotationByTime' => 'Por hora',
    'service-plan.misc.logRotationDaily' => 'Diariamente',
    'service-plan.misc.logRotationWeekly' => 'Semanalmente',
    'service-plan.misc.logRotationMonthly' => 'Mensualmente',
    'service-plan.misc.logRotationSizeDescription' => 'El valor de tamaño debe estar entre %%min%% y %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Número máximo de archivos de registro',
    'service-plan.misc.compress' => 'Comprimir archivos de registro',
    'service-plan.misc.sendLogToEmail' => 'Una vez Plesk haya recuperado los datos presentes en los archivos de registro de los servidores FTP y web, enviar los registros por email a esta dirección',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'meses',
    'service-plan.misc.logRotationPeriodGreater' => 'El periodo de rotación de registros no puede ser superior al límite a nivel del servidor de %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'De estar desactivado, todos los sitios web de la suscripción usarán el mismo grupo de aplicaciones IIS dedicado para la suscripción.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Seleccione los servicios y privilegios proporcionados con la suscripción.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Mostrar más permisos disponibles',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Mostrar menos permisos',
    'service-plan.permissions-subscription.noShellManagement' => 'No permitido',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Administración del acceso al servidor a través de SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Los clientes pueden activar SSH para su usuario de sistema. El parámetro de hosting "Acceso SSH al shell del servidor bajo el usuario de sistema de la suscripción" actúa como predeterminado.',

    'service-plan.permissions.permissionsTabDescription' => 'Selecciones los servicios y permisos proporcionados con el plan.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Seleccione los servicios y privilegios que se añadirán a las suscripciones con este plan complementario. Tenga en cuenta que los permisos no seleccionados en el complemento no modificarán los parámetros de la suscripción de ninguna manera.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Los permisos permiten a los clientes cambiar algunas opciones de sus suscripciones. Cuando se crea una suscripción, Plesk aplica los valores predeterminados del plan a la configuración que el cliente puede cambiar. A posteriori, la actualización del plan o la aplicación de un plan complementario no invalida los cambios efectuados por el cliente.',
    'service-plan.permissions.showMorePermissions' => 'Mostrar más permisos disponibles',
    'service-plan.permissions.hideMorePermissions' => 'Mostrar menos permisos',
    'service-plan.permissions.noShellManagement' => 'No permitido',
    'service-plan.permissions.systemAccessLabel' => 'Administración del acceso al servidor a través de SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Hace que el parámetro de hosting "Acceso SSH al shell del servidor bajo la suscripción del usuario del sistema" actúe como un valor predeterminado.',

    'service-plan.resources-subscription.overusePolicy' => 'Directiva de sobreuso',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Sobreuso no permitido',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'No permita el sobreuso de recursos. En el caso de que se supere el límite establecido de uso de recursos, la suscripción se suspenderá de forma automática.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Se permite el sobreuso de espacio en disco y tráfico',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Permita el sobreuso de espacio en disco y tráfico pero no permita el sobreuso de otros recursos.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Sobreuso permitido (no recomendado)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Permita al suscriptor usar más recursos de los proporcionados inicialmente con la suscripción.',
    'service-plan.resources-subscription.overuseNotify' => 'Notificarme por email en caso de sobreuso.',
    'service-plan.resources-subscription.oversellPolicy' => 'Directiva de sobreventa de recursos',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Sobreventa permitida',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'La sobreventa permite a un revendedor vender más recursos de los asignados con una suscripción. En el caso de permitirse, un revendedor se regirá por el uso actual de recursos, en vez de regirse por la asignación inicial de recursos.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Sobreventa no permitida',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'En el caso de que no se permita la sobreventa, un revendedor solo podrá vender tantos recursos como los asignados inicialmente con una suscripción, sin tener en cuenta la cantidad de estos recursos que esté siendo utilizada.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Defina los límites acerca del uso de los recursos proporcionados con la suscripción.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Mostrar más recursos disponibles',
    'service-plan.resources-subscription.hideMoreResources' => 'Mostrar menos recursos',

    'service-plan.resources.overusePolicy' => 'Directiva de sobreuso',
    'service-plan.resources.overusePolicyNotAllowed' => 'Sobreuso no permitido',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'No permita el sobreuso de recursos. En el caso de que se supere el límite establecido de uso de recursos, la suscripción se suspenderá de forma automática.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Se permite el sobreuso de espacio en disco y tráfico',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Permita el sobreuso de espacio en disco y tráfico pero no permita el sobreuso de otros recursos.',
    'service-plan.resources.overusePolicyAllowed' => 'Sobreuso permitido (no recomendado)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Permita a los clientes utilizar más recursos de los proporcionados inicialmente por el plan.',
    'service-plan.resources.overuseNotify' => 'Notificarme por email en caso de sobreuso.',
    'service-plan.resources.oversellPolicy' => 'Directiva de sobreventa de recursos',
    'service-plan.resources.oversellPolicyAllowed' => 'Sobreventa permitida',
    'service-plan.resources.oversellPolicyAllowedHint' => 'La sobreventa permite a un revendedor vender más recursos de los asignados con un plan. En el caso de permitirse, un revendedor se regirá por el uso actual de recursos, en vez de regirse por la asignación inicial de recursos.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Sobreventa no permitida',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'En el caso de que no se permita la sobreventa, un revendedor solo podrá vender tantos recursos como los asignados inicialmente con un plan, sin tener en cuenta la cantidad de estos recursos que esté siendo utilizada.',
    'service-plan.resources.mainGroupTitle' => 'Defina los recursos proporcionados con el plan.',
    'service-plan.resources.additionalGroupTitle' => 'Mostrar más recursos disponibles',
    'service-plan.resources.hideMoreResources' => 'Mostrar menos recursos',
    'service-plan.resources.allowSitebuilderUpsell' => 'Permitir al cliente crear sitios web Presence Builder de prueba.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Este parámetro permite al cliente crear más sitios web Presence Builder que los proporcionados por el plan de servicio. Para poder publicarlos, el cliente deberá comprar estos sitios web.',

    'service-plan.servicePlanName' => 'Nombre del plan de servicio',
    'service-plan.resellerPlanName' => 'Nombre del plan de revendedor',
    'service-plan.addonPlanName' => 'Nombre del plan complementario',
    'service-plan.adminPlanPermissionsTab' => 'Herramientas administrativas',
    'service-plan.adminPlanPermissionsTabDescription' => 'Seleccione las prestaciones a disposición del administrador cuando está activado el modo restringido.',
    'service-plan.hostingPermissionsTab' => 'Herramientas de hosting',
    'service-plan.hostingPermissionsTabDescription' => 'Seleccione las herramientas de hosting web y la configuración a disposición del administrador en el modo de visualización Power User cuando el modo restringido está activado.',
    'service-plan.resourcesTab' => 'Recursos',
    'service-plan.resourcesTabDescription' => 'Defina los recursos proporcionados con el plan y la directiva acerca del uso de los recursos.',
    'service-plan.subscriptionResourcesTabDescription' => 'Defina los recursos proporcionados con la suscripción y la directiva acerca del uso de los recursos.',
    'service-plan.hostingTab' => 'Parámetros de hosting',
    'service-plan.hostingTabDescription' => 'Especifique los parámetros del servicio de hosting proporcionados con el plan. Tenga en cuenta que la configuración de hosting indicada en el plan complementario no se aplicará a aquellas suscripciones a las que el plan de servicio o el plan complementario concedió el permiso "Administración de la configuración de hosting".',
    'service-plan.secureSettingsDescription' => 'Si desea que el hosting proporcionado sea más seguro, %%link%%. Tenga en cuenta que algunos de los permisos, de haberse concedido, permiten a los suscriptores cambiar estos parámetros de configuración. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'aplique la configuración de seguridad predeterminada',
    'service-plan.secureSettingsHelpLink' => 'Más info acerca de la configuración de hosting seguro',
    'service-plan.mailTab' => 'Correo',
    'service-plan.mailTabDescription' => 'Indique los parámetros del servicio de correo proporcionado con el plan.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Indique los parámetros del servicio DNS proporcionado con el plan.',
    'service-plan.performanceTab' => 'Rendimiento',
    'service-plan.performanceTabDescription' => 'Indique los parámetros del sistema que afectan al rendimiento de todos los servicios proporcionados con el plan.',
    'service-plan.permissionsTab' => 'Permisos',
    'service-plan.miscTab' => 'Registros y estadísticas',
    'service-plan.miscTabDescription' => 'Indique la cantidad de registros y estadísticas de las suscripciones del plan que deberían guardarse. Tenga en cuenta que estas opciones no se sincronizan en las suscripciones.',
    'service-plan.miscTabAdminPlanDescription' => 'Especifique cómo deberían guardarse las estadísticas y los registros de las suscripciones.',
    'service-plan.extrasTab' => 'Servicios adicionales',
    'service-plan.extrasTabDescription' => 'Seleccione los servicios que deberían incluirse en el plan además de hosting web, DNS y servicios de mensajería.',
    'service-plan.ipTab' => 'Direcciones IP',
    'service-plan.ipTabDescription' => 'Defina los parámetros de los recursos IP proporcionados con el plan.',
    'service-plan.applicationsTab' => 'Aplicaciones',
    'service-plan.applicationsTabDescription' => 'Seleccione las aplicaciones que deberían estar disponibles en el plan. Puede escoger proporcionar todas las aplicaciones disponibles en el Catálogo de Aplicaciones, además de aquellas que usted haya cargado al servidor, o escoger las aplicaciones manualmente. Si desea proporcionar todas las aplicaciones disponibles, no deberá realizar ninguna acción en esta pestaña. Simplemente vaya a la pestaña Permisos y seleccione la opción Acceso al catálogo de aplicaciones. Si desea seleccionar las aplicaciones manualmente, puede hacerlo en esta pestaña.',
    'service-plan.applicationsTabDescription-addon' => 'Seleccione las aplicaciones que desea que estén disponibles en el complemento.',
    'service-plan.applicationsTabDescription-subscription' => 'Seleccione las aplicaciones que deberían estar disponibles en la suscripción. Puede escoger proporcionar todas las aplicaciones disponibles en el Catálogo de Aplicaciones, además de aquellas que usted haya cargado al servidor, o escoger las aplicaciones manualmente. Si desea proporcionar todas las aplicaciones disponibles, no deberá realizar ninguna acción en esta pestaña. Simplemente vaya a la pestaña Permisos y seleccione la opción Acceso al catálogo de aplicaciones. Si desea seleccionar las aplicaciones manualmente, puede hacerlo en esta pestaña.',
    'service-plan.planSyncSubsriptionWarning' => 'Algunas suscripciones no han sido sincronizadas con el plan. Estas se han marcado como \'No sincronizadas\' en la lista de suscripciones. Si desea volver a intentar realizar la sincronización, vaya a la página general de una suscripción y haga clic en el botón Sincr.',
    'service-plan.planSyncResellerWarning' => 'Algunos revendedores no han sido sincronizados con el plan. Estos se han marcado como \'No sincronizados\' en la lista de revendedores. Si desea volver a intentar realizar la sincronización, vaya a la página general de un revendedor y haga clic en el botón Sincr.',
    'service-plan.planSyncAdminWarning' => 'No se pudieron aplicar los cambios a las suscripciones porque Plesk no proporciona algunos de los servicios o recursos afectados por dichos cambios. Motivo: %%reason%%',
    'service-plan.duplicateName' => 'Ya existe un plan con este nombre.',
    'service-plan.phpSettingsTab' => 'Configuración de PHP',
    'service-plan.phpHandlerNotFound' => 'No ha podido recuperarse la información sobre la versión de PHP del plan. Reinstálela o seleccione otra versión de PHP para el plan de servicios.',
    'service-plan.phpHandlerNotRegistered' => "La versión %%fullVersion%% de PHP no está instalada. El scripting PHP para los dominios que usen este plan de servicio no estará disponible. Instale PHP <nobr> %%fullVersion%%</nobr> o seleccione otra versión de PHP para el plan de servicio.",

    'service-plan.phpSettingsTabDescription' => 'Aquí puede especificar la configuración de PHP para cada suscripción que reemplazará la configuración definida por el archivo php.ini a nivel del servidor. Esto puede resultar útil, por ejemplo, si desea limitar el consumo de recursos del sistema por parte de los scripts PHP de los clientes. De permitirse, los clientes pueden reemplazar esta configuración PHP con su propia configuración por dominio. Cuando establezca un parámetro al valor predeterminado, PHP utilizará el valor del parámetro de la configuración PHP a nivel de servidor. Tenga en cuenta que se soportan los siguientes marcadores de posición: {DOCROOT} y {WEBSPACEROOT} corresponden al directorio raíz de documentos de un dominio y al directorio raíz de una suscripción que obtiene una configuración PHP personalizada; {TMP} corresponde al directorio que almacena archivos temporales. Nota: La configuración siguiente se pueden sobrescribir con parámetros especificados en los archivos .htaccess, php.ini o .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Aquí puede especificar la configuración PHP para cada suscripción, que invalidará la configuración definida por el plan de servicio principal. Esto puede resultarle útil si desea eliminar algún grupo de limitaciones PHP en el plan de servicio principal. Al definir un parámetro al valor predeterminado, PHP usará el valor del parámetro de la configuración PHP del plan de servicio. Tenga en cuenta que se soportan los siguientes marcadores de posición: {DOCROOT}y {WEBSPACEROOT} corresponden al directorio raíz de documentos de un dominio y al directorio raíz de una suscripción que obtiene una configuración personalizada de PHP; {TMP} corresponde al directorio que almacena los archivos temporales.',
    'service-plan.phpSettingsPhpVersion' => 'Su versión actual de PHP es %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Aquí puede especificar la configuración PHP para cada suscripción que invalidará la configuración definida por el archivo php.ini a nivel del servidor. Cuando usted defina un parámetro al valor predeterminado, PHP usará el valor del parámetro de la configuración PHP a nivel de servidor.',
    'service-plan.webServerSettingsTab' => 'Servidor web',
    'service-plan.webServerSettingsTabDescription' => 'Aquí puede especificar los parámetros de configuración del servidor web Apache para este plan de servicio. Si Apache se está ejecutando con nginx como servidor frontend, en esta página también puede indicar los parámetros de configuración de nginx. Dicha configuración se aplicará a todos los dominios nuevos. De todos modos, cuando realice alguna modificación en esta configuración, los cambios efectuados no se aplicarán a los dominios existentes.',
    'service-plan.servicesTab' => 'Servicios',
    'service-plan.servicesTabDescription' => 'Aquí puede indicar los servicios que desea asignar al plan de servicio.',
    'service-plan.servicePropertiesTab' => 'Propiedades de %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Aquí puede especificar las propiedades del servicio %%serviceName%% asignado al plan de servicio.',
    'service-plan.longTaskWarning' => 'Dispone de %%subscriptionsCount%% suscripciones en este plan. Tenga en cuenta que la tarea de sincronización puede tardar bastante en completarse y que esta se realizará en segundo plano.',
    'service-plan.hostingParametersTab' => 'Parámetros de hosting',
    'service-plan.adminInfoSection' => 'Información para el administrador',
    'service-plan.descriptionInPanel' => 'Descripción',
    'service-plan.longDescription' => 'La descripción proporcionada es demasiado larga.',
    'service-plan.conflictPermissions' => 'No se pudieron conceder los siguientes permisos porque estos entran en conflicto con el plan de revendedor: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Tipo de inicio',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automático',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manual',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Desactivar',
    'services.change-startup-type.autoActionError' => 'No se pudo configurar el tipo de inicio a \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'No se pudo establecer el tipo de inicio a \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'No se pudo establecer el tipo de inicio a \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Restablecer los valores predeterminados',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restaure los parámetros de la sesión a los valores predeterminados.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Los parámetros de sesión tienen los valores predeterminados.',
    'sessions.settings.idleTime' => 'Tiempo de inactividad de la sesión',
    'sessions.settings.disableCheckSessionIp' => 'Permitir cambios de dirección IP durante una única sesión',
    'sessions.settings.minuteShortTitle' => 'min',

    'settings-ui.controls.title' => 'Controles',

    'settings-ui.interface-views.description' => "Puede ver el IU usando distintos modos de visualización. En función de la vista usada, las funciones y las opciones de configuración estarán en sitios distinto, incluso puede que estén desactivados o activados. La finalidad de las distintas vistas es ofrecer la mejor experiencia posible a los distintos perfiles de usuario.",
    'settings-ui.interface-views.panelSimpleLink' => 'Herramientas y configuración > Configuración de modo restringido',
    'settings-ui.interface-views.useCustomView' => 'Activar modo restringido',
    'settings-ui.interface-views.useCustomViewHint' => 'Seleccione esta opción para limitar el número de acciones que puede realizar el administrador en Plesk. Si desea cambiar la disponibilidad de las acciones, vaya a %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Esta vista es la más apropiada para la gestión de sitios web, sus archivos, bases de datos, cuentas de email, aplicaciones web y otros servicios.',
    'settings-ui.interface-views.selectUiModeTitle' => "Selección de su interfaz",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Vista Power User (recomendado para desarrolladores y agencias web)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Vista Proveedor de servicios (para proveedores de hosting web)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Esta vista va dirigida a administradores de servidor que proporcionen y comercialicen servicios de hosting web a sus clientes mediante planes de servicios.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Ocultar controles de devolución',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Oculta el botón que permite configurar cómo procesar los correos enviados a direcciones inexistentes',

    'settings-ui.branding.description' => 'Personalice la interfaz de Plesk cambiando el modo en el que se muestra la página en la barra de título del navegador y/o reemplazando el logo de Plesk que aparece en la esquina superior izquierda.',
    'settings-ui.branding.buttonDefault' => 'Logo predeterminado',
    'settings-ui.branding.sectionTitle' => 'Nombre personalizado',
    'settings-ui.branding.enableCustomTitle' => 'Habilitar nombre personalizado en las páginas de Plesk',
    'settings-ui.branding.customTitle' => 'Texto del título',
    'settings-ui.branding.sectionLogo' => 'Logo personalizado',
    'settings-ui.branding.enableCustomLogo' => 'Habilitar logo personalizado para el panel',
    'settings-ui.branding.logo' => 'Archivo del logo',
    'settings-ui.branding.logoUrl' => 'URL del logo',
    'settings-ui.branding.logoUrlEnabled' => 'Personalizado',
    'settings-ui.branding.logoUrlDisabled' => 'Predeterminado',
    'settings-ui.branding.sectionFavicon' => 'Favicon personalizado',
    'settings-ui.branding.enableCustomFavicon' => 'Habilitar favicon personalizado',
    'settings-ui.branding.sectionFaviconDesc' => 'El mismo favicon debe cargarse en ambos formatos para así disfrutar de un mejor soporte en los distintos navegadores.',
    'settings-ui.branding.faviconSvg' => 'SVG de archivo de favicon',
    'settings-ui.branding.faviconSvgHint' => 'Formato permitido: SVG',
    'settings-ui.branding.faviconIco' => 'ICO de archivo de favicon',
    'settings-ui.branding.faviconIcoHint' => 'Formato permitido: ICO',
    'settings-ui.branding.show' => 'Mostrar',
    'settings-ui.branding.updateSuccess' => 'Las propiedades de personalización de Plesk han sido modificadas.',
    'settings-ui.branding.sectionBackground' => 'Fondo de pantalla de inicio de sesión personalizado',
    'settings-ui.branding.enableCustomBackground' => 'Habilitar imagen de fondo',
    'settings-ui.branding.backgroundFile' => 'Imagen de fondo',
    'settings-ui.branding.backgroundColor' => 'Color de fondo',
    'settings-ui.branding.backgroundResetColor' => 'Restablecer',
    'settings-ui.branding.backgroundFit' => 'Diseño de fondo',
    'settings-ui.branding.background.fit.fill' => 'Llenar pantalla',
    'settings-ui.branding.background.fit.fit' => 'Adaptar a la pantalla',
    'settings-ui.branding.background.fit.center' => 'Centro',
    'settings-ui.branding.background.fit.tile' => 'Mosaico',

    'sitebuilder.trial.description' => 'Aquí puede configurar el modo Probar y comprar (anteriormente denominado escenario de adquisición de clientes). En este modo, el cliente puede crear un sitio web con todas las funciones disponibles en la aplicación incluida Presence Builder. En cualquier caso, la publicación de sitios web de prueba no está disponible para los clientes hasta que estos contraten un plan de servicio de hosting o adquieran un complemento para el plan. El modo Probar y comprar también puede concederse a los clientes ya existentes a través de un plan de hosting o un complemento de plan. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Para más información, consulte la documentación.',
    'sitebuilder.trial.lifetimeLabel' => 'Vigencia de sitios web de prueba',
    'sitebuilder.trial.lifetimeUnits' => 'días',
    'sitebuilder.trial.lifetimeDescription' => 'Esto es el tiempo que debería transcurrir antes de que estos sitios de prueba no adquiridos por los clientes fueran eliminados del servidor.',
    'sitebuilder.trial.signupLabel' => 'Habilitar acceso público a modo de prueba',
    'sitebuilder.trial.signupDescription' => 'Si desea ampliar su cartera de clientes publicitando hosting con Presence Builder y proporcionándoles una demo de este software, habilite el acceso público al modo de pruebas y publique la URL de acceso del modo de pruebas en su sitio web.',
    'sitebuilder.trial.signupLinkLabel' => 'URL de acceso al modo de pruebas',
    'sitebuilder.trial.signupLinkDescription' => 'Esta URL abrirá Presence Builder en modo de pruebas. Publique esta URL en su sitio web para publicitar hosting con Presence Builder y ampliar su cartera de clientes.',
    'sitebuilder.trial.promotionLabel' => 'Mostrar notificación de modo de prueba en el editor de Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Use esta opción si desea mostrar una notificación adicional sobre la ejecución de Presence Builder en modo de prueba.',

    'update-settings.policyHintForPum' => 'Aquí puede configurar la instalación automática de actualizaciones. El email de notificación puede enviarse cuando existan actualizaciones que puedan instalarse manualmente o bien cuando se hayan instalado actualizaciones de forma manual.',
    'update-settings.policyHint' => 'El email de notificación puede enviarse cuando existan actualizaciones que puedan instalarse de forma manual o que se instalaron de forma automática.',
    'update-settings.branchDisabledDescription' => 'No notificarme cuando existan actualizaciones',
    'update-settings.automaticPatchesInstallation' => 'Instalar actualizaciones de Plesk automáticamente (Recomendado)',
    'update-settings.automaticPatchesThirdParty' => 'Instalar actualizaciones de forma automática para los componentes de terceros incluidos en Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Instalar actualizaciones de paquetes de sistema de forma automática',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Tenga en cuenta que esto también instalará las actualizaciones de forma automática para los componentes de terceros incluidos en Plesk',
    'update-settings.installerProxyMode' => 'Acceder a Plesk Installer a través del puerto y nombre de host de Plesk',
    'update-settings.installerProxyModeHint' => 'Acceder a la interfaz web de Plesk Installer sin tener que abrir un puerto TCP 8447 adicional en el cortafuegos.',
    'update-settings.automaticPatchesNotification' => 'Notificar sobre actualizaciones de paquetes de sistema instalados y disponibles',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Dirección de email',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Frecuencia de notificaciones',
    'update-settings.daily' => 'Cada día',
    'update-settings.weekly' => 'Cada semana',
    'update-settings.generalSection' => 'General',
    'update-settings.notificationsSection' => 'Notificaciones',
    'update-settings.safeUpdatesSection' => 'Actualizaciones seguras',
    'update-settings.safeUpdatesSectionHint' => 'Plesk se encarga de que las actualizaciones de paquetes del sistema se instalen desde el mismo repositorio desde el que inicialmente se instalaron los paquetes. Este tipo de actualizaciones se consideran seguras. Si las desactiva, es posible que su administrador de paquetes del sistema instale actualizaciones desde cualquier repositorio del sistema.',
    'update-settings.safeUpdatesSectionWarn' => 'A menos que sea un usuario avanzado, le recomendamos dejar activadas las actualizaciones seguras. Las actualizaciones indiscriminadas de los paquetes del sistema desde otros repositorios pueden afectar negativamente al funcionamiento de su servidor.',
    'update-settings.allowSafeUpdates' => 'Activar actualizaciones seguras para paquetes del sistema',

    'requiredFields' => 'Campos obligatorios',

    'ip-ban.banned-ip.ipAddress' => 'Dirección IP',
    'ip-ban.banned-ip.hintIpAddress' => 'Una dirección IP o una máscara CIDR.',
    'ip-ban.banned-ip.banType' => 'Prohibir la dirección IP: ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'Durante una semana',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Permanentemente',

    'server-mail-smarthost.settings.title' => 'Configuración de smarthost',
    'server-mail-smarthost.settings.useSmarthost' => 'Enviar el correo de los usuarios a través de un smarthost',
    'server-mail-smarthost.configuration.title' => 'Configuración de smarthost',
    'server-mail-smarthost.configuration.hostnameOrIP' => 'Nombre de host o dirección IP',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => 'Para desactivar las búsquedas MX o SRV, ponga el nombre del host o la dirección IP entre corchetes; por ejemplo, [example.com]',
    'server-mail-smarthost.configuration.checkConnection' => 'Comprobar conexión',
    'server-mail-smarthost.configuration.port' => 'Puerto',
    'server-mail-smarthost.configuration.username' => 'Nombre de usuario',
    'server-mail-smarthost.configuration.password' => 'Contraseña',
    'server-mail-smarthost.configuration.encryption' => 'Conexión cifrada',
    'server-mail-smarthost.configuration.encryption.Unix.on' => 'Requerido',
    'server-mail-smarthost.configuration.encryption.Unix.off' => 'No se requiere',
    'server-mail-smarthost.configuration.encryption.Windows.off' => 'Ninguno',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => 'Se requiere autenticación',
    'server-mail-smarthost.configuration.checkConnection.success' => 'Se ha establecido la conexión con el smarthost.',
    'server-mail-smarthost.success' => 'Se ha modificado la configuración del smarthost.',
    'server-mail-smarthost.settings.noteTitle' => 'Nota:',
    'server-mail-smarthost.settings.note' => '%%title%% Si configura el envío de correo a través de un smarthost, deberá actualizar de forma manual el SPF y otros registros DNS relacionados en la plantilla DNS y las zonas DNS de los dominios existentes. Esto es necesario para evitar errores de verificación para el correo enviado a través del smarthost. %%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => 'Consulte más detalles.',
];