<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "הגישה נדחתה. החשבון שלך הושעה.",
    'login_up__login_has_been_locked' => "ניסית להיכנס למערכת באמצעות סיסמה שגויה פעמים רבות מדי. מטעמי אבטחה, לא תוכל להיכנס למערכת תחת שם משתמש זה לזמן מה.",
    'login_up__unable_to_check_pass' => "לא ניתן לבדוק את הסיסמה: %1",
    'login_up__warning_limits_licence_key' => "‫אחד מהפריטים הבאים חרג מהמגבלה שמגדיר מפתח הרישיון שלך: מספר חשבונות המשתמשים, הדומיינים, חשבונות הדוא\"ל או משתמשי האינטרנט שמתארחים בשרת שלך.\nפנה למחלקת המכירות של Plesk כדי לרכוש מפתח שיאפשר לך לאחסן את המספר הרצוי של משתמשים ודומיינים. פנה לתמיכה הטכנית של Plesk אם לדעתך קיבלת הודעה זו בטעות.\nהמגבלה ברישיון של חשבונות משתמשים/דומיינים/חשבונות דואר/משתמשי אינטרנט/ערכות שפה: %2.\nהמספר של חשבונות משתמשים/דומיינים/חשבונות דואר/משתמשי אינטרנט/ערכות שפה שמאוחסנים כרגע: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "‫כמות המשאבים שאתה פועל איתם חרגה מהמגבלות שמגדיר רישיון המוצר הנוכחי שלך.‬ ‫פנה למחלקת המכירות של Plesk ורכוש מפתח רישיון חדש.‬",
    'login_up__grace_period' => 'אתה פועל כרגע במסגרת תקופת החסד של רישיון המוצר שלך. כדי לעדכן את רישיון המוצר, בחר באפשרות \'אחזור מפתחות\' ב%1דף \'פרטי רישיון\'%2.',
    'login_up__partner_license_message' => 'אתה פועל כרגע במסגרת רישיון מוצר מוגבל שנדרש עבורו רישום לפני הפעלת סט התכונות המלא. כדי לעדכן את רישיון המוצר, בחר באפשרות \'אחזור מפתחות\' ב%1דף \'פרטי רישיון\'%2.',
    'login_up__system_admin_disabled' => 'אסור למשתמש העל (חשבון שורש או חשבון מנהל מערכת) להיכנס ל-Plesk מטעמי אבטחה.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "מדריך Plesk למנהל המערכת",
    'plesk_guide_reseller' => "מדריך Plesk למשווק",
    'plesk_guide_client' => "מדריך Plesk ללקוח",
    'plesk_guide_domain_admin' => "מדריך Plesk למנהל הדומיין",
    'plesk_guide_mailuser' => "מדריך Plesk למשתמש הדוא\"ל",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'חיפוש', // multiple usage: TBI
    'nav__general' => 'תפריט ראשי',
    '__home' => 'דף הבית',
    '__applications' => 'יישומים',
    '__settings' => '‫הגדרות‬',
    'nav__system' => 'מערכת',
    '__master' => 'מסטר',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'רמה אחת למעלה',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'הסרה',
    'bt_make_default' => 'הפיכה לברירת המחדל',

    // common list object search keys
    'bt_show_all' => "איפוס חיפוש",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'פעיל',
    '__object_off' => 'מושעה',

    '__home_description' => 'חזרה לדף הבית.',
    'indicator_title' => '%1% בשימוש, %2% פנויים', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'נדרשה כתובת URL לא חוקית.',

    // business objects
    'mn_list__mail_names_for_client' => 'חשבונות הדוא"ל תחת חשבון המשתמש %1',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'שם',
    'domains_list__state__filter_title' => 'שימוש במשאבים',
    'domains_list__filter_state_any' => 'כלשהו',
    'domains_list__filter_state_overuse' => 'שימוש יתר',
    'domains_list__filter_state_normal' => 'במסגרת המגבלות',
    'domains_list__status__filter_title' => 'מצב',
    'domains_list__filter_status_any' => 'כלשהו',
    'domains_list__filter_status_blocked' => 'מושעה',
    'domains_list__filter_status_active' => 'פעיל',
    'domains_list__subrows__filter_title' => 'הצגה',
    'domains_list__subrows_off' => 'דומיינים בלבד',
    'domains_list__subrows_subdomain_domainaliases' => 'עם תחומי משנה וכינויים',
    'domains_list__subrows_subdomain' => 'עם תת-דומיינים',
    'domains_list__subrows_domainaliases' => 'עם כינוי',

    // objects list
    'domains_list__owner__title' => 'בעלים',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "עיין לאיתור יישומים",
    'site_apps__promo_main_text' => "קטלוג Application Packaging Standard‏ (APS) מכיל את רשימת היישומים שניתן להקצות לדומיין או לשטח אינטרנט. אם ברצונך להקצות יישומים שאינם נמצאים כרגע בקטלוג, ניתן לעשות זאת בקלות על ידי מילוי ההוראות לאריזת APS ב-www.apsstandard.com",
    'site_apps__promo_download_now' => "הורדת יישומים:",
    'site_apps__promo_close' => "סגור חסימה זו",
    'site_apps__promo_preset__mostused' => '%1 הפופולריים ביותר',
    'site_apps__promo_preset__lessused' => '%1 הפופולריים ביותר הבאים',
    'site_apps__promo_preset__all' => "הכול",
    'site_apps__promo_disclaimer_note' => '‫שים לב שאת היישומים שהותקנו מקטלוג ה-APS סיפקו צדדים שלישיים ו-Plesk אינו תומך ביישומים אלה.‬',
    'site_apps__promo_preset__page_title' => '%1 יישומי APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'מוסיף יישומים...',

    // Errors
    'site_apps__no_applications_for_update' => 'אין לך יישומים מותקנים במאגר היישומים.',
    'site_apps__incorrect_download_preset_configuration' => 'נמצאו שגיאות בקביעה מראש של תצורת הורדת קטלוג APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'כתובת ה-URL שצוינה אינה חוקית.',
    'site_apps__no_updates_at_the_moment' => 'אין כרגע עדכונים זמינים ליישומים.',
    'site_apps__incorrect_content_returned_by_catalog' => 'התקבל מידע שגוי מקטלוג יישומי ה-APS. נסה שוב מאוחר יותר.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'הגדרות קטלוג APS נשמרו, אך Plesk לא הצליח לבסס חיבור לקטלוג ה-APS שצוין בהגדרות קטלוג APS‏ (%1). ודא שכתובת קטלוג ה-APS נכונה ושקטלוג ה-APS שנמצא בכתובת זו פעיל.',
    'site_apps__cannot_retrieve_updates' => 'לא ניתן להוריד עדכונים ליישום כרגע: לא ניתן לבסס חיבור לקטלוג ה-APS‏ (%1). ודא שכתובת קטלוג ה-APS נכונה ושקטלוג ה-APS שנמצא בכתובת זו פעיל.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'אין יישומי אינטרנט זמינים להתקנה.',
    'site_apps__site_applications_already_installed_in_root' => 'יישומי אינטרנט אחרים כבר מותקנים בספריות הבסיס של המארחים הווירטואליים האלה',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "יישומי אינטרנט ‎.NET אינם נתמכים בפלטפורמת Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'יישומי אינטרנט בכלל השרתים אינם נתמכים',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 יישומי אינטרנט נוספים מתוזמנים להוספה למאגר היישומים.",
    'site_apps__applications_all_in_vault' => "יישומי אינטרנט שנבחרו כבר נמצאים במאגר היישומים.",
    'site_apps__applications_already_in_download_queue' => "%1 יישומי אינטרנט שנבחרו נוספים כעת למאגר היישומים.",
    'site_apps__applications_already_in_valut' => "%1 יישומי אינטרנט שנבחרו כבר נמצאים במאגר היישומים.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'אחר (לא מסווג לקטגוריה)',

    // Errors
    'site_apps__no_applications_in_category' => 'אין יישומים זמינים בקטגוריה זו. בחר קטגוריה אחרת.',
    'site_apps__no_category_selected__please_specify' => 'בחר קטגוריה בתפריט הימני. כל היישומים הזמינים בקטגוריה שנבחרה יפורטו בחלון זה.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'חשבון מנהל מערכת',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'כללי',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'שנה את שם המחשב המארח',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'אבטחה',
    'bt_setup_firewall' => 'הגדר חומת אש',
    'bt_manage_firewall_rules' => 'נהל כללי חומת אש',
    'cu_firewall__rule' => 'צור כלל חומת אש',
    'cu_firewall__protocol' => 'הגדר פרוטוקול עבור הכלל (\'tcp\' או \'udp\')',
    'cu_firewall__name' => "הגדר שם כלל",
    'cu_firewall__disabled' => 'אם \'true\', הכלל מנוטרל לאחר היצירה',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'בחר שרת DNS', // PFW
    'bt_soa_records_template' => 'תבנית רשומות SOA',
    'bt_restrict_creation_of_subzones' => 'הגבלת יצירה של תת-אזורים',

    'databases' => 'מסדי נתונים',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'יישומים',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'דואר',
    'bt_select_mailserver' => 'בחר שרת דואר', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'בחר אנטי-וירוס', // PFW
    'bt_virus_protection_settings' => 'הגדרות הגנה מפני וירוסים',
    'bt_select_spamfilter' => 'בחר מסנן הודעות זבל', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'בחר דואר אינטרנט',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'יומני רישום ונתונים סטטיסטיים',
    'bt_server_statistics_settings' => 'הגדרות הנתונים הסטטיסטיים של השרת',
    'bt_select_web_statistics' => 'תוכנת סטטיסטיקת אינטרנט זמינה', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'ממשק Plesk',

    'components_and_modules' => 'רכיבים ומודולים',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'הגדר VPN', // PFU
    'bt_setup_samba' => 'הגדר samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'חשבון מנהל הדומיין',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'הגדרות חשבון',

    'domain' => 'דומיין',
    'bt_dns_soa_records' => 'רשומות DNS SOA',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'הגדרות מתזמן המשימות',

    'website' => '‏אתר אינטרנט',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting עבור משתמשי רשת',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'בחר  אישור SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'סטטיסטיקת אינטרנט',
    'bt_log_rotation_settings' => 'הגדרות סבב יומן רישום',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "מגבלות", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "מדיניות שימוש יתר ומכירת יתר",
    'limits__overuse_policy_legend' => "שימוש יתר",
    'limits__oversell_policy_legend' => "מכירת יתר",
    'limits__reseller_overuse_description' => "מדיניות שימוש יתר אומרת ל-Plesk מה לעשות כאשר נעשה שימוש יתר במשאבים.",
    'limits__overuse_text' => "מדיניות שימוש יתר",

    // limit names
    'limit_group__disk_space_and_traffic' => 'שטח דיסק ותעבורה',
    'limit__disk_space' => 'שטח דיסק',
    'limit__max_traffic' => 'תעבורה',
    'limit_group__client' => 'לקוחות',
    'limit__max_cl' => 'לקוחות',
    'limit_group__domain' => 'דומיינים',
    'limit__max_dom' => 'דומיינים',
    'limit__max_dom_powerUser' => 'מינויים',
    'limit__max_subdom' => 'תת-דומיינים',
    'limit__max_dom_aliases' => 'כינויי דומיינים',
    'limit__max_wu' => 'משתמשי אינטרנט',
    'limit__max_subftp_users' => 'חשבונות FTP נוספים', // PFW
    'limit_group__mail' => 'דואר',
    'limit__max_box' => 'תיבות דואר',
    'limit__mbox_quota' => 'גודל תיבת דואר',
    'limit__total_mboxes_quota' => 'מיכסה כוללת של תיבות דואר', // PFW
    'limit__max_maillists' => 'רשימות דיוור',
    'limit_group__database' => 'מסדי נתונים',
    'limit__max_mssql_db' => 'מסדי נתוני Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'מיכסה כוללת של מסדי נתוני MS SQL', // PFW
    'limit__max_odbc' => 'חיבורי ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'מיכסת מסדי נתוני MariaDB/MySQL', // PFW
    'limit__pgsql_dbase_space' => 'מיכסה של מסד נתוני PostgreSQL', // PFW
    'limit_group__application' => 'יישומים',
    'limit__max_iis_app_pools' => 'מאגרי יישומי IIS', // PFW
    'limit_group__security' => 'אבטחה',
    'limit_group__validity' => 'תאריך תפוגה',
    'limit__expiration' => 'תאריך תפוגה',
    'limit__validity' => 'תקופת תוקף',
    'limit__max_site_builder' => 'אתרים שפורסמו באמצעות בונה הנוכחות',
    'limit__max_site' => 'דומיינים',
    'limit__mssql_dbase_filesize' => 'גודל קובץ מסד נתוני MS SQL',
    'limit__mssql_dbase_log_filesize' => 'גודל קובץ יומן רישום של מסד נתוני MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'הגודל המרבי לקובץ מסד נתוני MS SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'הגודל המרבי לקובץ יומן רישום של מסד נתוני MS SQL.',
    'limit__units_mssql_dbase_filesize' => "‎ MB",
    'limit__units_mssql_dbase_log_filesize' => "‎ MB",

    'dom_pref__invalid_max_site_limit' => 'מגבלת דומיינים לא חוקית. הערך המזערי הוא 1.',

    'property__has_wrong_value' => 'המאפיין %1 מכיל ערך שגוי.',
    'property__name_outgoing_messages_domain_limit' => 'מגדיר את המגבלה על הודעות יוצאות מדומיין (לשעה). כדי להגדיר את הערך \'ללא הגבלה\', ציין "1-". ציין "ברירת מחדל" כדי להגדיר את הערך המצוין בהגדרות בכלל השרתים.',
    'property__name_outgoing_messages_mbox_limit' => 'מגדיר את המגבלה על הודעות יוצאות מתיבת דואר (לשעה). כדי להגדיר את הערך \'ללא הגבלה\', ציין "1-". ציין "ברירת מחדל" כדי להגדיר את הערך המצוין בהגדרות בכלל השרתים.',
    'property__name_outgoing_messages_subscription_limit' => 'מגדיר את המגבלה על הודעות יוצאות ממינוי (לשעה). כדי להגדיר את הערך \'ללא הגבלה\', ציין "1-". ציין "ברירת מחדל" כדי להגדיר את הערך המצוין בהגדרות בכלל השרתים.',

    // for CLI report & email notifications
    '__resource_notify' => 'הצג הודעה',
    '__general' => 'כללי',
    '__template_shared' => 'תבנית משותפת',
    'limit__overuse' => 'מדיניות שימוש יתר',
    'limit__max_traffic_soft' => 'הצג הודעה כאשר השימוש בתעבורה מגיע ל-',
    'limit__disk_space_soft' => 'הצג הודעה כאשר השימוש בשטח הדיסק מגיע ל-',
    '__overuse' => 'מדיניות שימוש יתר',
    'performance__title' => 'ביצועים',
    'performance__bandwidth' => 'שימוש מקסימלי ברוחב פס (KB/s)',
    'performance__max_connections' => 'החיבורים מוגבלים ל-',

    'gch__hosting_php_isapi' => 'הפעל PHP כהרחבת ISAPI',
    'gch__hosting_ssi_html' => 'השתמש ב-SSI עבור קובצי ‎*.htm‏, ‎*.html',
    'gch__hosting_php_handler_type' => 'הפעל PHP כ',
    'gch__hosting_php_handler_id' => 'הפעל PHP כ',
    'gch__hosting_php_served_by_nginx' => 'nginx משרת PHP',
    'gch__hosting_unpaid_website_status' => 'מצב אתרי האינטרנט במינויים מושעים',
    'gch__mn_no_autoresponder' => 'אין הודעות מענה אוטומטי שמוגדרות לחשבון הדוא"ל.',
    'gch__no_clients_selected' => "לא נבחרו חשבונות לקוחות",
    'gch__no_domains_selected' => "לא נבחרו דומיינים",

    // limit units
    'limit__units_disk_space' => "‎ MB",
    'limit__units_max_traffic' => "‎ MB/חודש",
    'limit__units_mbox_quota' => "‎ KB",
    'limit__units_mysql_dbase_space' => "‎ MB", // PFW
    'limit__units_mssql_dbase_space' => "‎ MB", // PFW
    'limit__units_pgsql_dbase_space' => "‎ MB", // PFW
    'limit__units_total_mboxes_quota' => "‎ MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'שם המשאב',
    '__resource_usage' => 'בשימוש',
    '__resource_limit' => 'מגבלה',

    '__never_expires' => 'לא פג לעולם',
    '__resource_free' => '%1 ללא %2',
    '__resource_unlimited' => '%1 בשימוש מתוך ללא הגבלה',

    '__unlimited' => 'ללא הגבלה',
    '__increment' => "הגדלה (+)",
    '__decrement' => "הפחתה (-)",
    '__pt' => 'יחידות',
    '__procent' => '%',
    '__overused' => 'שימוש יתר',
    '__left' => 'נותר',
    '__available' => 'זמין',
    '__not_available' => 'לא כלול',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'שם המשווק', // reseller report
    'report__full_client_name' => 'שם הלקוח', // customer report
    'report__full_domain_name' => 'שם הדומיין', // domain report
    'report__full_owner' => 'בעלים', // customer & domain reports
    'report__full_creation_date' => 'תאריך יצירה',
    'report__full_size' => 'גודל',
    'report__full_traffic' => 'תעבורה',
    'report__full_active_clients' => 'לקוחות פעילים', // reseller report
    'report__full_clients' => 'לקוחות', // reseller report
    'report__full_active_domains' => 'דומיינים פעילים', // reseller & customer reports
    'report__full_domains' => 'דומיינים', // reseller & customer reports
    'report__full_subdomains' => 'תת-דומיין',
    'report__full_mboxes' => 'תיבות דואר',
    'report__full_disk_space' => 'שטח דיסק',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'תגובה',
    'report__full_mail_antispam' => 'מניעת הודעות זבל',
    'report__full_mail_antivirus' => 'אנטי-וירוס',
    'report__full_mail_lists' => 'רשימת דיוור',
    'report__full_web_users' => 'משתמשי אינטרנט',
    'report__full_mysql_databases' => 'מסד נתונים MariaDB/MySQL',
    'report__full_mssql_databases' => 'מסד נתוני MSSQL',
    'report__full_pgsql_databases' => 'מסד נתונים PostgreSQL',

    // common summary report
    'report__section_general' => 'כללי',
    'report__version' => 'גירסת מוצר',
    'report__build' => 'מהדורת מוצר',
    'report__status' => 'מצב',
    'report__company_name' => 'שם החברה',
    'report__personal_name' => 'שם רשמי',
    'report__login' => 'שם משתמש',
    'report__phone' => 'טלפון',
    'report__fax' => 'פקס',
    'report__email' => 'דוא״ל',
    'report__address' => 'כתובת',
    'report__city' => 'עיר',
    'report__state' => 'מדינה/מחוז',
    'report__zip_code' => 'מיקוד',
    'report__country' => 'ארץ',
    'report__creation_date' => 'תאריך יצירה',
    'report__expiration_date' => 'תאריך תפוגה',
    'report__dumps_total_size' => 'גודל כולל של קובצי גיבוי',
    'report__section_resellers' => 'משווקים',
    'report__active_resellers' => 'משווקים בעלי מינויים פעילים',
    'report__resellers' => 'משווקים',
    'report__section_full_resellers' => 'משווקים',
    'report__section_clients' => 'לקוחות',
    'report__active_clients' => 'לקוחות בעלי מינויים פעילים',
    'report__clients' => 'לקוחות',
    'report__section_full_clients' => 'לקוחות',
    'report__section_personal_clients' => 'לקוחות משויכים',
    'report__active_personal_clients' => 'הלקוחות שלך שהם בעלי מינויים פעילים',
    'report__personal_clients' => 'לקוחות משויכים',
    'report__section_full_personal_clients' => 'לקוחות משויכים',
    'report__section_domains' => 'דומיינים',
    'report__disk_usage' => 'ניצול דיסק',
    'report__traffic' => 'תעבורה',
    'report__active_domains' => 'דומיינים פעילים',
    'report__domains' => 'דומיינים',
    'report__subdomains' => 'תת-דומיינים',
    'report__mboxes' => 'תיבות דואר',
    'report__mail_groups' => 'העברת דואר',
    'report__mail_autoresp' => 'מענה אוטומטי',
    'report__mail_lists' => 'רשימות דיוור',
    'report__web_users' => 'משתמשי אינטרנט',
    'report__mysql_databases' => 'מסדי נתוני MariaDB/MySQL',
    'report__mssql_databases' => 'מסדי נתוני MSSQL',
    'report__pgsql_databases' => 'מסדי נתוני PostgreSQL',
    'report__section_full_domains' => 'דומיינים',
    'report__section_personal_domains' => 'דומיינים אישיים',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'דומיינים אישיים',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'אתרים שפורסמו באמצעות בונה הנוכחות',
    'report__invalid_email' => 'ציין כתובת דוא"ל חוקית.',


    // CLI-specific sections
    'report__section_hosting' => 'אירוח',
    'report__section_webusers' => 'משתמשי אינטרנט',
    'report__section_mailnames' => 'חשבונות דואר אלקטרוני',
    'report__section_maillists' => 'רשימות דיוור',
    'report__section_databases' => 'מסדי נתונים',
    'report__section_siteapps' => 'יישומי אינטרנט',
    'report__section_aspnetapps' => 'יישומי ASP.NET', // PFW
    'report__owner_pname' => "שמו הרשמי של הספק",
    'report__owner_login' => "שם המשתמש של הספק",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'ערכת השפה שצוינה מותקנת, אך אינה מאופשרת במערכת.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'תוקף אסימון ההפעלה פג.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'חשבונות המשווקים הבאים יומרו לחשבונות לקוחות',
    'downgradeResellers__downgrade' => 'חשבונות משווקים שיומרו',
    // controls
    'downgradeResellers__submit_downgrade' => 'בצע המרת חשבון.',
    'downgradeResellers__cancel_downgrade' => 'בטל המרת חשבון.',
    'downgradeResellers__confirm' => 'אשר המרה',
    'downgradeResellers__confirm_message' => 'אשר את המרת החשבון כדי להמשיך',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'חשבונות הלקוחות הבאים יומרו לחשבונות משווקים',
    'upgradeClients__upgrade' => 'חשבונות לקוחות שיומרו',
    // controls
    'upgradeClients__submit_upgrade' => 'בצע המרת חשבון.',
    'upgradeClients__cancel_upgrade' => 'בטל המרת חשבון.',
    'upgradeClients__confirm' => 'אשר המרה',
    'upgradeClients__confirm_message' => 'אשר את המרת החשבון כדי להמשיך',
    // errors
    'upgradeClient__user_is_already_reseller' => 'לא ניתן להמיר את החשבון \'%1\' לחשבון משווק: \'%1\' הוא כבר משווק.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'חשבונות מנהלי הדומיינים הבאים יומרו לחשבונות לקוחות',
    'upgradeDomainUser__upgrade' => 'חשבונות מנהלי הדומיינים שיומרו',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'בצע המרת חשבון.',
    'upgradeDomainUser__cancel_upgrade' => 'בטל המרת חשבון.',
    'upgradeDomainUser__confirm' => 'אשר המרה',
    'upgradeDomainUser__confirm_message' => 'אשר את המרת החשבון כדי להמשיך',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'לא ניתן להמיר את חשבונות מנהלי הדומיינים',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'לא ניתן להמיר את חשבונות מנהלי הדומיינים הבאים לחשבונות לקוחות:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'לא ניתן היה להמיר כמה חשבונות מנהלי דומיינים לחשבונות לקוחות. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'חשבון מנהל הדומיין אינו קיים',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "הדומיין צריך להיות שייך ישירות למנהל השרת או למשווק.",
    'upgradeDomainUser__all_logins_already_used' => 'לא ניתן ליצור חשבון עבור הלקוח שנוצר.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'חשבון מנהל הדומיין הומר',
    'upgradeDomainUser__upgrade_notification_body' => 'חשבון מנהל הדומיין שלך הומר לחשבון לקוח בשם המשתמש \'%%login%%\' ועם הסיסמה \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'למשווק שנבחר אין את ההרשאה \'%1\', אך לחלק מהלקוחות יש אותה.',
    'clientOwnerChanger__application_not_allowed' => 'היישום \'%1\' אינו זמין למשווק שנבחר, אך זמין לחלק מהלקוחות.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'שימוש מרבי ברוחב פס (%1)',
    'hosting_performance__max_connection_label' => 'החיבורים מוגבלים ל-',
    'performance__invalid_value' => "הערך אינו חוקי. עליו להיות בטווח שבין %1 ל-%2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'דואר אינטרנט',
    'webmail__server_text' => 'תוכנות דואר אינטרנט זמינות',
    'webmail__none' => 'ללא',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'מאגר ה-IP של השרת',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "גיבוי שרת.",
    '__default_backup_comment_reseller' => "גיבוי חשבון משווק נוצר על ידי %1.",
    '__default_backup_comment_client' => "גיבוי חשבון לקוח נוצר על ידי %1.",
    '__default_backup_comment_domain' => "גיבוי מינוי נוצר על ידי %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "מאגר ה-IP של הלקוח %1.",
    'backup__ip_mapping__resellers_ip' => "מאגר ה-IP של המשווק %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'מארח וירטואלי',
    'backup__restore__object_plesk_admin' => 'מנהל מערכת Plesk',
    'backup__restore__object_ftpuser' => 'חשבון FTP',
    'backup__restore__object_frontpageuser' => 'חשבון Frontpage',
    'backup__restore__object_webuser' => 'משתמש אינטרנט',
    'backup__restore__object_domain' => 'דומיין',
    'backup__restore__object_subdomain' => 'תת-דומיין',
    'backup__restore__object_domainalias' => 'כינוי דומיין',
    'backup__restore__object_client' => 'לקוח',
    'backup__restore__object_reseller' => 'משווק',
    'backup__restore__object_autoresponder' => 'מענה אוטומטי',
    'backup__restore__object_mailalias' => 'כינוי דואר',
    'backup__restore__object_database' => 'מסד נתונים',
    'backup__restore__object_mailname' => 'חשבון דוא״ל',
    'backup__restore__object_db_user' => 'משתמש מסד נתונים',
    'backup__restore__object_ssl_certificate' => 'אישור SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'לא ניתן לשחזר את המשווקים הבאים מכיוון שהם מומרים ללקוחות: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'לא ניתן לשחזר את הלקוחות הבאים מכיוון שהם מומרים למשווקים: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'לא ניתן לשחזר את הלקוחות הבאים מכיוון שהם מועברים לבעלים אחרים: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'שטח הדיסק בשרת היעד לא מספיק להעברת כל המנויים שנבחרו. זמין: ‎%1 MB. נדרש: ‎%2 MB. הערה: השטח הנדרש מחושב כסכום של תוכני אינטרנט, דואר ומסדי נתונים של דומיינים. מכיוון שהחישוב הזה מתבצע פעם ביום ומאוחסן במטמון, ייתכן שגודל הדומיינים בפועל יהיה שונה מהגודל המחושב. אם אתם בטוחים שהדומיינים שנבחרו לא יתפסו יותר שטח ממה שזמין, תוכלו להמשיך בהעברה.',
    'backup__restore__capability_not_enough_disk_windows_text' => 'השטח בדיסק \'%1\' בשרת היעד לא מספיק להעברת כל המנויים שנבחרו. זמין: ‎%2 MB. נדרש: ‎%3 MB. הערה: השטח הנדרש מחושב כסכום של תוכני אינטרנט, הדואר ומסדי הנתונים של הדומיינים. מכיוון שהחישוב הזה מתבצע פעם ביום ומאוחסן במטמון, ייתכן שגודל הדומיינים בפועל יהיה שונה מהגודל המחושב. אם אתם בטוחים שהדומיינים שנבחרו לא יתפסו יותר שטח ממה שזמין, תוכלו להמשיך בהעברה.',
    'backup__restore__capability_not_enough_disk_resolution' => 'כדי להמשיך בהעברה, פנו שטח דיסק בשרת היעד.',
    'backup__restore__capability_source_not_enough_disk_text' => 'שטח הדיסק בשרת המקור אינו מספיק לאחסון קבצים זמניים להעברה. זמין: ‎%1 MB. נדרש: ‎%2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'פנה שטח דיסק בשרת המקור.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'פרטי שרת',

    'backup__restore__capability_not_installed_component_text' => 'הרכיב %1 אינו מותקן בשרת היעד. %1 לא יהיה זמין עבור כל האובייקטים המשוחזרים.',
    'backup__restore__capability_not_installed_component_resolution' => 'התקן את %1. שים לב שהפעולה עשויה להימשך מספר דקות.',
    'backup__restore__capability_existing_sys_user_text' => 'בשרת היעד כבר קיים משתמש מערכת בשם %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'שנה את שם משתמש המערכת הקיים בשרת היעד.',
    'backup__restore__capability_license_usage_text' => 'לאחר העברת הנתונים, המערכת תחרוג ממגבלות המקור הבאות (שמוגדרות על ידי מפתח הרישיון) בשרת היעד:',
    'backup__restore__capability_license_usage_resolution' => 'התקן על שרת היעד מפתח רישיון אחר שיספק את כמות המשאבים הנדרשת.',
    'backup__restore__capability_max_allowed_packet_text' => "הפרמטר 'max_allowed_packet' בשרת מסד הנתונים המשמש כמקור שווה ל-%1, הגדול יותר מאשר בשרת היעד, שם הוא שווה ל-%2. ייתכן שכמה אובייקטים של מסד הנתונים עבור הדומיינים שצוינו לא ישוחזרו.",
    'backup__restore__capability_max_allowed_packet_resolution' => "הגדל את הערך 'max_allowed_packet' בשרת מסד הנתונים המשמש כיעד.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'לא ניתן להעביר את מסדי הנתונים של PostgreSQL מכיוון שגירסת PostgreSQL בשרת היעד מוקדמת מזו שבשרת המקור. הגירסה הנוכחית היא %1, הגירסה הנדרשת היא %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'התקן את הגירסה הנדרשת של PostgreSQL בשרת היעד.',
    'backup__restore__capability_db_server_connection_problems' => 'לא ניתן להתחבר לשרת מסד הנתונים PostgreSQL ביעד. מסדי הנתונים לא יועברו, אלא אם כן תשחזר את החיבור.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'בדוק את הגדרות החיבור בשרת מסד הנתונים המשמש כיעד.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'הרכיב %1 כבוי בשרת היעד.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'הפעל את %1 בשרת היעד.',
    'backup__restore__capability_not_configured_component_text' => 'תצורת הרכיב %1 לא נקבעה בשרת היעד.',
    'backup__restore__capability_not_configured_component_resolution' => 'קבע את תצורת %1 בדף \'כלים והגדרות\'.',

    'backup__restore__capability_webmail_is_not_available' => 'שירות דואר האינטרנט %1 אינו זמין בשרת היעד. במקומו, Plesk ישתמש בשירות דואר האינטרנט הבא: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'כדי להשתמש באותו דואר אינטרנט כמו בשרת המקור, יש להתקין אותו בשרת זה.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'כדי להשתמש באותו דואר אינטרנט כמו בשרת המקור, יש להתקין אותו בשרת היעד.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "דואר האינטרנט '%1' אינו זמין בשרת היעד. במקום זאת, במינויים הבאים: %3,‏ Plesk ישתמש בשירות דואר האינטרנט הבא: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'התקן את דואר האינטרנט הנדרש בשרת היעד.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'הגדרות דואר אינטרנט',

    'backup__restore__capability_shell_is_not_available' => 'המעטפת %1 אינה זמינה בשרת היעד. במקומה, ייעשה שימוש באחת מהמעטפות הזמינות.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'כדי להשתמש באותה המעטפת כמו בשרת המקור, יש להפעיל (ב-‎/etc/shells) או להתקין אותה בשרת היעד.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'שרת DNS היעד אינו תומך ברשתות שבתבנית הגבלות ההעברה. הרשומות עם כתובות ה-IP של הרשת בהגבלות ההעברה של ה-DNS לא ישוחזרו.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'שרת DNS היעד אינו תומך ברשתות בתבנית הגבלות העברה, אך לחלק מהמינויים יש רשתות בהגבלות ההעברה של ה-DNS. הרשומות עם כתובות ה-IP של הרשת בהגבלות ההעברה של ה-DNS לא ישוחזרו.',

    'backup__restore__capability_wrong_php_handler_text' => 'מטפל ה-PHP ‏%1 אינו זמין בשרת היעד. במקומו, Plesk ישתמש במטפל ה-PHP הבא: %2.',
    'backup__restore__capability_no_php_handler_text' => 'מטפל PHP‏ %1 לא זמין בשרת היעד.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'כדי להשתמש באותו מטפל PHP כמו בשרת המקור, יש להפעיל או להתקין אותו בשרת היעד.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'מטפל ה-PHP %1 אינו זמין. במקום, Plesk ישתמש ב-%2 עבור תוכניות השירות הבאות: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'מטפל ה-PHP %1 אינו זמין. במקום, Plesk ישתמש ב-%2 עבור אתרי האינטרנט הבאים: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'מטפל ה-PHP %1 אינו זמין. הוא יהיה לא זמין עבור האתרים הבאים: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'ה-%1 %2 אינו זמין בשרת היעד. במקומו, ייעשה שימוש בגירסת ברירת המחדל.',
    'backup__restore__capability_wrong_component_version_resolution' => 'כדי להשתמש באותו %1 כמו בשרת המקור, יש להפעיל או להתקין אותו בשרת היעד.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'מדיניות השימוש באנטי-וירוס בשרת היעד אינה מאפשרת הגדרות אנטי-וירוס אישיות (לכתובת דוא"ל) עבור דואר יוצא. הגדרות אלה לא יועברו.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'מדיניות השימוש באנטי-וירוס בשרת היעד אינה מאפשרת הגדרות אנטי-וירוס אישיות (לכתובת דוא"ל) עבור דואר נכנס. הגדרות אלה לא יועברו.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'מדיניות השימוש באנטי-וירוס בשרת היעד אינה מאפשרת הגדרות אנטי-וירוס אישיות (לכתובת דוא"ל). הגדרות אלה לא יועברו.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "כדי להעביר הגדרות אנטי-וירוס אישיות (עבור כל כתובת דוא\"ל), יש להפעיל את האפשרויות המתאימות ב'כלים והגדרות'> 'הגדרות הגנה מפני וירוסים'.",
    'backup__restore__capability_antivirus_not_active_text' => 'לא מופעלת אף תוכנת אנטי-וירוס. כל הגדרות האנטי-וירוס משרת המקור לא יפעלו עד שתבחר בתוכנת האנטי-וירוס בשרת היעד.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'בחר בתוכנת האנטי-וירוס ב\'כלים והגדרות\'> \'הגדרות הגנה מפני וירוסים\'> מקטע \'הגדרות אנטי-וירוס\'.',

    'backup__restore__capability_antivirus_another_active_text' => 'תוכנת האנטי-וירוס %2 אינה זמינה בשרת היעד. במקומה, ייעשה שימוש ב-%1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'כדי להשתמש באותו אנטי-וירוס כמו בשרת המקור, התקן אותו ובחר בו ב\'כלים והגדרות\'> \'הגדרות הגנה מפני וירוסים\'> מקטע \'הגדרות אנטי-וירוס\'.',
    'backup__restore__capability_not_available_sni_text' => 'SNI אינו זמין בשרת היעד. אתרי האינטרנט שיש להם אותה כתובת IP לא יוכלו להשתמש באישורי SSL/TLS נפרדים.',
    'backup__restore__capability_not_available_sni_resolution' => "בדוק שמערכת ההפעלה בשרת היעד תומכת ב-SNI, ושהתמיכה ב-SNI פעילה ב-Plesk (תיבת הסימון 'הפעל תמיכה ב-SNI, המאפשרת שימוש באישורי SSL/TLS נפרדים באתרי אינטרנט בעלי אותה כתובת P' ב'כלים והגדרות'> 'הגדרות שרת').",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'הגדרות שרת',

    'backup__restore__capability_vhost_already_exists_text' => 'לא ניתן להעביר את אתר האינטרנט %1: בשרת היעד כבר קיים אתר אינטרנט באותו השם.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'שנה את שם אתר האינטרנט בעל אותו השם או הסר אותו מהשרת.',
    'backup__restore__capability_removed_vhosts' => 'המינויים הבאים לא ישוחזרו מכיוון שהם מכילים את שמות הדומיינים שכבר קיימים בשרת היעד: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'ישנם %3 מטפלי PHP שונים מהסוג %1 ומגירסה %2 בשרת המקור. במקומם, ייעשה שימוש במטפל אחד מהסוג ומהגירסה המתאימים בשרת היעד. שים לב שהגדרות PHP עשויות להשתנות בין שרת המקור לשרת היעד.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'מתקין Plesk אינו תומך ב-Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'מתקין Plesk אינו תומך ב-Python. התקן את Python באופן ידני.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'הגדרות שרת דואר',

    'backup__restore__capability_ftps_disabled' => 'השימוש ב-FTPS מאובטח מותר בשרת המקור, אך אסור במטרה. ייתכן שיישומי משתמש שמשתמשים ב-FTP לא יפעלו בצורה תקינה.',
    'backup__restore__capability_ftps_required' => 'השימוש ב-FTP שאינו מאובטח מותר בשרת המקור, אך אסור במטרה. ייתכן שיישומי משתמש שמשתמשים ב-FTP לא יפעלו בצורה תקינה.',
    'backup__restore__capability_ftps_policy_resolution' => 'שנה את מדיניות ה-FTP המאובטח ב\'כלים והגדרות\'> \'מדיניות אבטחה\'.',

    'backup__restore__capability_too_much_download_time_text' => '%1 מגה-בתים יועברו משרת המקור לשרת היעד תוך %2 שעות.',
    'backup__restore__capability_too_much_download_time_resolution' => 'להעברה מהירה יותר, בדוק את חיבור הרשת בין שרת המקור לשרת היעד ומצא פתרון לבעיות (אם ישנן).',
    'backup__restore__too_low_download_speed' => "פחות מ-0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'להעברה מהירה יותר, בדוק את חיבור הרשת בין שרת המקור לשרת היעד ומצא פתרון לבעיות (אם ישנן).',
    'backup__restore__capability_zero_download_speed_text' => 'מהירות ההורדה המזערית הקבילה היא ‎%1 MBps. מהירות ההורדה בין שרת המקור לשרת היעד היא ‎0 MBps. ייתכן שהדבר נגרם כתוצאה מהבעיות בחיבור הרשת. ההעברה אינה אפשרית.',
    'backup__restore__capability_zero_download_speed_resolution' => 'בדוק את חיבור הרשת בין שרת המקור לשרת היעד ומצא פתרון לבעיות.',
    'backup__restore__capability_too_slow_download_speed_text' => 'מהירות ההורדה המזערית הקבילה היא ‎%2 MBps. מהירות ההורדה בין שרת המקור לשרת היעד היא ‎%1 MBps. הדבר עלול להאריך את זמן ההעברה. בסביבה הנוכחית, העברה של ‎%3 MB תימשך %4 שעות.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'מהירות ההורדה המזערית הקבילה היא ‎%2 MBps. מהירות ההורדה בין שרת המקור לשרת היעד היא ‎%1 MBps. הדבר עלול להאריך את זמן ההעברה.',

    'backup__restore__capability_remote_database_migration' => "הדומיינים הבאים משתמשים במסד נתונים מרוחק: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "אין להסיר דומיינים אלה משרת המקור לאחר ההעברה אם גירסת Plesk בשרת המקור ישנה יותר מ-11.5! במקום זאת, השעה אותם. אם תסיר את הדומיינים, מסדי הנתונים יוסרו מהשרת המרוחק. הערה: קובצי ה-Dump של מסדי נתונים מרוחקים יאוחסנו בשרת המקור בספריה %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'ייתכן שקובצי גיבוי של שרתי מסד הנתונים של MySQL מוקדמים מ-5.1 (%1) לא ישוחזרו ב-MySQL 5.1.x מכיוון ש-MySQL 5.1.x מטפל אחרת בתווי Unicode.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'קרא את המאמר הקשור מס\' 136850 במאגר הידע',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP אינו מותקן בשרת היעד.',
    'backup__restore__capability_courier_not_installed_resolution' => 'התקן את Courier-IMAP באמצעות מתקין Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot אינו מותקן בשרת היעד.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'התקן את Dovecot באמצעות מתקין Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'זמן אחזקת הנתונים הסטטיסטיים של התעבורה בתצורות האובייקטים הבאים קצר מהערך בכלל השרתים בשרת היעד.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'שנה את הערך בכלל השרתים עבור זמן אחזקת הנתונים הסטטיסטיים בשרת היעד. הגדר שעה זו כשווה לערך הקטן ביותר בתצורות הדומיינים או כמוקדמת ממנו.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'הזמן לאחזקת הנתונים הסטטיסטיים של התעבורה בחלק מהדומיינים קצר מהערך בכלל השרתים (%1). הערך ישונה ל-%1 עבור דומיינים אלה.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'הזמן לחישוב הנתונים הסטטיסטיים של התעבורה בחלק מתוכניות השירות קצר מהערך בכלל השרתים (%1). הערך ישונה ל-%1 עבור תוכניות שירות אלה.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'מיפוי כתובת IP בלעדית לכתובת IP משותפת ינטרל FTP ו-HTTPS אנונימיים (אלא אם כן תופעל תמיכה ב-SNI).',

    'backup__restore__no_postgresql_commands_text' => 'המינוי משתמש במסד נתונים מרוחק של PostgreSQL, ולא ניתן ליצור את קובץ הגיבוי הזמני שלו מכיוון שהפקודות pg_dump ו-psql חסרות בשרת המקור.',
    'backup__restore__no_postgresql_commands_resolution' => 'התקן כל חבילת לקוח של PostgreSQL שתומכת בפקודות האלה.',
    'backup__restore__capability_apache_modules_disabled_text' => 'המודולים הבאים מסוג Apache מנוטרלים בשרת היעד: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'על מנת למנוע בעיות אפשריות, אפשר מודולים אלה.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'המודולים הבאים מסוג Apache אינם מותקנים בשרת היעד: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'על מנת למנוע בעיות אפשריות, התקן מודולים אלה ואפשר אותם.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'רישיונך אינו תומך במגבלת ההודעות היוצאות. הגדרות התצורה המתאימות לא יועברו.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'התקן על שרת היעד מפתח רישיון אחר שמספק את התכונות הנדרשות.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'מגבלת ההודעות היוצאות כבויה בשרת היעד. הגדרות התצורה המתאימות לא יועברו.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'הפעל את מגבלת ההודעות היוצאות בשרת היעד.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'הגדרות דואר בכלל השרתים',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'שרת הדואר שבשימוש בשרת היעד אינו תומך במגבלת ההודעות היוצאות מתיבת דואר. ערך גבול זה לא יועבר.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'שנה את שרת הדואר לזהה לזה שאתה משתמש בו בשרת המקור.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'הגדרות דואר בכלל השרתים',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'שרת הדואר שבשימוש בשרת היעד אינו תומך במגבלת ההודעות היוצאות מדומיין. ערך גבול זה לא יועבר.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'שנה את שרת הדואר לזהה לזה שאתה משתמש בו בשרת המקור.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'הגדרות דואר בכלל השרתים',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'שרת הדואר שבשימוש בשרת היעד אינו תומך במגבלת ההודעות היוצאות ממינוי. ערך גבול זה לא יועבר.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'שנה את שרת הדואר לזהה לזה שאתה משתמש בו בשרת המקור.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'הגדרות דואר בכלל השרתים',

    'bu_conflict_resolver_absent_phosting' => 'לא ניתן לשחזר את הקבצים שצוינו מכיוון שאחסון האתרים הפיזי המיועד לשחזור אינו קיים. ראשית, צור דומיין עם אחסון אתרים פיזי, ולאחר מכן הפעל שוב את השחזור של הגיבוי.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'נתוני המשווקים לא ישוחזרו, מכיוון שניהול המשווקים אינו נתמך.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'הרכיב ModSecurity אינו מותקן בשרת היעד.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'התקן את ModSecurity כדי שחומת האש של אפליקציית האינטרנט תישאר פעילה עבור האתרים שהועברו. שים לב שההתקנה עשויה להימשך מספר דקות.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'התקן את ModSecurity אם ברצונך להעביר את הגדרות חומת האש של אפליקציית האינטרנט. שים לב שההתקנה עשויה להימשך מספר דקות.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'תצורת הרכיב ModSecurity לא נקבעה בשרת היעד.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'קבע את תצורת ModSecurity אם ברצונך שחומת האש של אפליקציית האינטרנט תישאר פעילה עבור האתרים שהועברו.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'חומת אש של אפליקציית אינטרנט (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity כבוי בשרת היעד.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'הפעל את ModSecurity אם ברצונך שחומת האש של אפליקציית האינטרנט תישאר פעילה עבור האתרים שהועברו.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'חומת אש של אפליקציית אינטרנט (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'הרכיב ModSecurity אינו מותקן. הגדרות חומת האש של אפליקציית האינטרנט לא ישוחזרו עבור האובייקטים הבאים: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "לא ניתן לשחזר את אתרי האינטרנט מכיוון שהם שייכים למינוי %1 שאינו נמצא ב-Plesk.",
    'bu_conflict_resolver_attend_websites_subscription' => "אי אפשר לאחסן אתרים מסוימים כי יש מנויים עם שמות זהים: %1.",
    'backup__restore__capability_not_installed_dns_text' => 'הרכיב %1 אינו מותקן בשרת היעד. שירות ה-DNS לא יהיה זמין והגדרות DNS יאבדו. כל הלקוחות של אתרי האינטרנט לא יהיו פעילים.',
    'bu_conflict_resolver_dns_not_installed' => 'שירות ה-DNS אינו מותקן. הגדרות ה-DNS לא ישוחזרו עבור האובייקטים הבאים: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'לא ניתן לשחזר את המינויים הבאים מכיוון שהם מועברים לבעלים אחרים: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'לא ניתן לשחזר את המינויים הבאים מכיוון שהם מועברים לספקים אחרים: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'לא ניתן למצוא את כלי שירות לשחזור בונה הנוכחות באינטרנט כדי לשחזר את נתוני בונה הנוכחות באינטרנט. כנראה שבונה הנוכחות באינטרנט אינו מותקן.',
    'backup__restore__capability_renamed_db' => 'שם מסד הנתונים "%1" כבר נמצא בשימוש מינוי אחר. שם מסד הנתונים המשוחזר ישונה ל-"%2".',
    'backup__restore__capability_renamed_db_user' => 'שם המשתמש של מסד הנתונים "%1" כבר נמצא בשימוש מינוי אחר. שם המשתמש של מסד הנתונים המשוחזר ישונה ל-"%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'מתקין Plesk אינו תומך ב-Perl. התקן את ActiveState Perl באופן ידני.',
    'backup__restore__capability_php_handler' => '‫%%version%% %%type%%‏ (id=%%id%%)‬',
    'backup__restore__capability_php_handler_served_by_apache' => '‫%%version%% %%type%% מטופל על-ידי Apache‏ (id=%%id%%)‬',
    'backup__restore__capability_php_handler_served_by_nginx' => '‫%%version%% %%type%% מטופל על-ידי nginx‏ (id=%%id%%)‬',


    '__sni' => 'SNI',
    '__kav' => '‫אנטי-וירוס של Kaspersky‬',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'התנגשויות שימוש במשאבים',
    'backup__restore__hint_resource_usage_conflicts' => 'התנגשויות שימוש במשאבים מתרחשות כאשר קיימת חריגה ממגבלות השימוש במשאבים של האובייקט המשוחזר לאחר השחזור.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'אפשר שימוש יתר',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'שחזר את האובייקט ואפשר לו להשתמש ביותר משאבים מאלה שסופקו בהתחלה.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'אין לשחזר',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'אין לשחזר אובייקטים בעלי התנגשויות שימוש במשאבים.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'התנגשויות תצורה',
    'backup__restore__hint_configuration_conflicts' => 'התנגשויות תצורה מתרחשות כאשר לאובייקט משוחזר יש הגדרות ויישומי אינטרנט שאינם זמינים, או שהשרת הנוכחי או מדיניות הבעלים של האובייקט אוסרים אותם. לדוגמה, התנגשויות תצורה יתרחשו אם לחשבונות דוא"ל משוחזרים יהיו הגדרות נפרדות לסינון הודעות זבל, כאשר המדיניות הנוכחית בכלל השרתים אוסרת על קיום ההגדרות האלה בחשבונות דוא"ל.',
    'backup__restore__text_configuration_resolution_policy_automatic' => '‫אוטומטי‬',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'שחזר את האובייקט והפעל אוטומטית את כל אפשרויות התצורה המתנגשת שההרשאות שלך מאפשרות לנהל.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'אין לשחזר',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'אין לשחזר אובייקטים בעלי התנגשויות תצורה.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'מאגרי יישומים ייעודיים של IIS אינם מותרים בהגדרות מאגר היישומים של IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'שנה את הגדרות מאגר היישומים של IIS ב\'כלים והגדרות\'> \'מאגר יישומי IIS\'> \'הגדרות כלליות\'.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'מאגרי יישומים משותפים של IIS אינם מותרים בהגדרות מאגר היישומים של IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'שנה את הגדרות מאגר היישומים של IIS ב\'כלים והגדרות\'> \'מאגר יישומי IIS\'> \'הגדרות כלליות\'.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'שמות קצרים לחשבונות דוא"ל POP3/IMAP אינם מותרים בשרת היעד.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'שמות קצרים לחשבונות דוא"ל לא יהיו זמינים לאחר שחזור הנתונים.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'לא ניתן לפתוח את קובץ יומן הרישום.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'לא ניתן לשחזר את המינוי %1: הוא הוסר מחשבונך ואין לך את ההרשאה ליצירת מינויים. אם יש צורך לשחזר אותו, פנה לספק השירות שלך.',

    'backup__error11' => 'שטח הדיסק לא מספיק לגיבוי.',
    'backup__error3011' => 'החיבור נדחה: אין תוכניות שמאזינות לכתובת וליציאה שצוינו.',
    'backup__error3012' => 'הזמן הקצוב לחיבור הסתיים.',
    'backup__error3013' => 'הרשת אינה זמינה.',
    'backup__error3014' => 'אין מסלול למארח.',
    'backup__error3015' => 'החיבור נכשל.',
    'backup__error3016' => 'לא ניתן לפענח את שם המחשב המארח.',
    'backup__error3017' => 'שם המשתמש או הסיסמה שגויים.',
    'backup__error3018' => 'חיבור ה-SSH נכשל.',

    'backup__error3110' => 'לא ניתן להתחבר לסוכן העברה מרוחק: החיבור למארח אינו זמין.',
    'backup__error3111' => 'סוכן ההעברה נעול על ידי משימת העברה שנכשלה, או שתהליך העברה אחר משתמש בו. הפעל מחדש את סוכן ההעברה בשרת המקור.',
    'backup__error3112' => 'החיבור למארח אינו זמין, או שסוכן ההעברה אינו פועל במארח המקור.',
    'backup__error3113' => 'לא ניתן לפרוס את סוכן ההעברה למארח Linux. בדוק את חיבור ה-SSH למארח המקור.',
    'backup__error3114' => 'לא ניתן לפרוס את סוכן ההעברה למארח Linux: חיבור ה-SSH נכשל.',
    'backup__error3115' => 'שם המשתמש או הסיסמה שגויים.',
    'backup__error3116' => 'למשתמש שצוין אין הרשאות ניהול.',

    'dns_t__unable_to_remove_ns_record' => 'לא ניתן להסיר את רשומת ה-NS מתבנית ה-DNS: כל אזור DNS חייב להכיל רשומת NS אחת לפחות.',
    'dns__unsupported_server_zone_transfer' => 'לא ניתן להעביר את תבנית הגבלות ההעברה עקב תצורת ה-DNS בכלל השרתים: כתובות הרשת הבאות מותרות להעברת אזור בשרת המקור, אך שרת Microsoft DNS אוסר אותן: %1',
    'dns__unsupported_domain_zone_transfer' => 'לא ניתן להעביר את תבנית הגבלות ההעברה עקב תצורת ה-DNS של הדומיינים: כתובות הרשת הבאות מותרות להעברת אזור בחלק מהדומיינים, אך שרת Microsoft DNS אוסר אותן: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'לא ניתן לגשת אל ספריית הרשת הזמנית המשותפת לקובצי גיבוי. בדוק את הגדרות ספריית הרשת, שם המשתמש של הרשת וסיסמת הרשת. שגיאה: %1',

    'dbbackup__temp_dir_wrong_value' => 'צוין הערך הלא חוקי עבור הספריה הזמנית.',
    'dbbackup__network_temp_dir_wrong_value' => 'צוין הערך הלא חוקי עבור ספריית הרשת הזמנית.',
    'dbbackup__server_backup_not_configured' => 'תצורת ההגדרות של גיבוי מסד הנתונים לא נקבעה בשרת.',
    'dbbackup__temp_dir' => 'ספריה זמנית',
    'dbbackup__temp_dir_hint' => 'הנתיב לתיקיה פיזית בשרת המרוחק בה ממוקם MS SQL server. ל-MS SQL server חייבת להיות יכולת לגשת לתיקיה זו לשם קריאה וכתיבה של קובצי גיבוי זמניים. לדוגמה, C:DirectoryPath',
    'dbbackup__network_temp_dir_hint' => '‫הנתיב למיקום המשותף ברשת אשר ממופה לתיקיה הפיזית המצוינת למעלה.‬ ‫Plesk ייגש אל התיקיה המשותפת כדי להוריד ולהעלות קובצי גיבוי.‬ ‫לדוגמה, ‎\\\\ServerName\\DirectoryPath‬',
    'dbbackup__network_user_hint' => 'שם המשתמש של משתמש רשת נוצר בשרת המרוחק. לדוגמה, ServerNameUserName. חייבת להיות למשתמש גישה אל התיקיה המשותפת המצוינת מעלה.',
    'dbbackup__network_password_hint' => 'הסיסמה של משתמש הרשת',

    'dbbackup__success_import_without_dublicate_users' => 'המשתמשים הבאים לא יובאו: %1. הם כבר קיימים בשרת מסד הנתונים.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "דחוס קובצי יומן רישום",
    'log_rot__log_rot_status' => "סטטוס סבב יומן רישום",
    'log_rot__log_rot_period' => "תנאי סבב יומן רישום",
    'log_rot__log_rot_size' => "לפי גודל",
    'log_rot__log_rot_time' => "לפי זמן",
    'log_rot__logrotation_enable' => "הפעל סבב יומן רישום",
    'log_rot__mail' => "שלח קובצי יומן רישום מעובדים לדוא\"ל",
    'log_rot__max_number_of_logfiles' => "מספר מרבי של קובצי יומן רישום",
    'log_rot__time_period' => "תקופה",
    'log_rot__unable_turn_off' => 'לא ניתן לבטל את סבב יומן הרישום, משום שההגדרה נאכפת ברמת השרת',
    'log_rot__unable_set_period' => 'לא ניתן להגדיר תקופת סבב יומן רישום שונה מ\'יומית\', משום שההגדרה נאכפת ברמת השרת',
    'log_rot__unable_set_max_log_files' => 'לא ניתן להגדיר עבור קובצי יומן מספר מקסימום הגדול מהמגבלה %1 המוגדרת ברמת השרת',

    /// action log
    // common/various
    'actionlog__digit_expected' => "נדרש מספר: %1",
    'actionlog__incorrect_rotation' => "צוינו פרמטרים לא חוקיים של סבב יומן הרישום: %1",
    'actionlog__unknown_rot_period' => "תקופת סבב לא מוכרת: %1",
    'actionlog__unknown_rot_type' => "סוג סבב לא מוכר: %1",
    'actionlog__session_preferences' => 'הגדרות הפעלה',
    'actionlog__nis2_delete_prohibited' => 'אסור להסיר רשומות יומני רישום כי הגבלות מנחות של NIS2 נמצאות בתוקף.',
    'actionlog__nis2_forbidden_rot_type' => "אי אפשר להשתמש בסוג סבב יומן רישום '%1' כי הגבלות מנחות של NIS2 נמצאות בתוקף.",
    // items (PFU schema)
    'actionlog__admin_info' => 'פרטי מנהל המערכת',
    'actionlog__admin_preferences' => "העדפות של מנהל מערכת",
    'actionlog__service' => '‫שירות‬',
    'actionlog__ip_addr' => 'כתובת IP',
    'actionlog__client' => 'חשבון לקוח',
    'actionlog__client_status' => 'מצב החשבון של הלקוח',
    'actionlog__client_preferences' => "העדפות הממשק של הלקוח",
    'actionlog__client_ip_pool' => "מאגר ה-IP של הלקוח",
    'actionlog__client_siteapp' => "מאגר יישומי האינטרנט של המשתמש",
    'actionlog__client_guid' => "ה-GUID של הלקוח",
    'actionlog__domain' => 'דומיין ברירת מחדל (הדומיין הראשון שנוסף למינוי)',
    'actionlog__domain_owner' => 'בעלי המינוי',
    'actionlog__domain_plan' => '‫תוכנית שירות של מינוי‬',
    'actionlog__domain_status' => 'דומיין ברירת מחדל, מצב',
    'actionlog__domain_dns' => 'דומיין ברירת מחדל, אזור DNS',
    'actionlog__subdomain' => 'תת-דומיין של דומיין ברירת מחדל',
    'actionlog__domain_alias' => 'דומיין ברירת מחדל, כינוי',
    'actionlog__domain_alias_dns' => 'דומיין ברירת מחדל, אזור ה-DNS של הכינוי',
    'actionlog__site' => 'דומיין',
    'actionlog__site_status' => 'מצב הדומיין',
    'actionlog__site_dns' => 'אזור ה-DNS של הדומיין',
    'actionlog__site_guid' => 'ה-GUID של הדומיין',
    'actionlog__site_subdomain' => 'תת-דומיין',
    'actionlog__site_alias' => 'כינוי דומיין',
    'actionlog__site_alias_dns' => 'אזור ה-DNS של כינוי הדומיין',
    'actionlog__domain_limits' => 'מגבלות מינוי',
    'actionlog__domain_limit_size' => 'מגבלת שטח דיסק למינוי',
    'actionlog__domain_limit_traffic' => 'מגבלת תעבורה למינוי',
    'actionlog__domain_limits_powerUser' => 'מגבלות מינוי',
    'actionlog__domain_limit_size_powerUser' => 'מגבלת שטח דיסק למינוי',
    'actionlog__domain_limit_traffic_powerUser' => 'מגבלת תעבורה למינוי',
    'actionlog__domain_guid' => "דומיין ברירת מחדל, GUID",
    'actionlog__cp_user' => 'משתמש Plesk',
    'actionlog__mailname' => 'חשבון דואר אלקטרוני',
    'actionlog__maillist' => 'רשימת דיוור',
    'actionlog__phosting' => 'הגדרות אחסון אתרים',
    'actionlog__forwarding' => 'אחסון אתרים רגיל או של העברת התמונה קדימה',
    'actionlog__webuser' => 'חשבון משתמש אינטרנט',
    'actionlog__site_application' => 'יישום אינטרנט',
    'actionlog__license' => 'מפתח רישיון',
    'actionlog__additional_license' => 'מפתח רישיון נוסף',
    'actionlog__template_domain' => "תוכנית השירות של המשווק",
    'actionlog__template_admin' => "תוכנית השירות של מנהל המערכת",
    'actionlog__template_reseller' => 'תכנית משווק',
    'actionlog__admin_alias' => 'חשבון מנהל מערכת נוסף', // PFW
    'actionlog__ftpuser' => 'חשבון FTP נוסף', // PFW
    'actionlog__db_server' => 'שרת מסד נתונים',
    'actionlog__db' => 'מסד נתונים',
    'actionlog__db_user' => 'חשבון משתמש למסד הנתונים',
    'actionlog__client_sapppkg_pool' => "יישום האינטרנט של המשתמש", // PFW, not used?
    'actionlog__remote_dns' => 'מצב שרת ה-DNS המרוחק', // PFW
    'actionlog__reseller' => 'חשבון משווק',
    'actionlog__reseller_guid' => 'ה-GUID של המשווק',
    'actionlog__reseller_ip_pool' => "מאגר ה-IP של המשווק",
    'actionlog__reseller_limit_size' => 'מגבלת שטח דיסק לחשבון משווק',
    'actionlog__reseller_limit_traffic' => 'מגבלת תעבורה לחשבון משווק',
    'actionlog__reseller_limits' => 'מגבלות חשבון המשווק',
    'actionlog__reseller_permissions' => 'הרשאות המשווק',
    'actionlog__reseller_preferences' => "העדפות הממשק של המשווק",
    'actionlog__reseller_siteapp' => "יישומי אינטרנט במאגר של המשווק",
    'actionlog__reseller_status' => 'מצב חשבון המשווק',
    'actionlog__health_status' => 'מצב תקינות השרת',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'המערכת הגיעה למגבלה',
    'actionlog__added' => 'נוסף',
    'actionlog__removed' => 'הוסר',
    'actionlog__change' => 'שונה',
    'actionlog__update' => 'עודכן',
    'actionlog__move' => 'הועבר',
    'actionlog__upgrade' => 'שודרג', // PFU?
    'actionlog__update_or_add' => 'עודכן או נוסף',
    'actionlog__expired' => 'פג תוקף',
    'actionlog__create' => 'נוצר',
    'actionlog__delete' => 'נמחק',
    'actionlog__clear' => 'הוסר',
    'actionlog__service_stop' => 'הופסק',
    'actionlog__service_restart' => 'הופעל מחדש',
    'actionlog__service_start' => 'הופעל',
    'actionlog__login' => 'מחובר',
    'actionlog__logout' => 'מנותק',
    'actionlog__install' => 'מותקן',
    'actionlog__uninstall' => 'הוסר',
    'actionlog__reconfigure' => 'התצורה נקבעה מחדש',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'בקשה לאיפוס סיסמה',
    'actionlog__event_admin_update' => 'פרטי מנהל המערכת עודכנו',
    'actionlog__event_admin_preferences_update' => "ההעדפות של מנהל המערכת עודכנו",
    'actionlog__event_service_restart' => 'השירות הופעל מחדש',
    'actionlog__event_service_start' => 'השירות הופעל',
    'actionlog__event_service_stop' => 'השירות הופסק',
    'actionlog__event_ip_address_create' => 'נוצרה כתובת IP',
    'actionlog__event_ip_address_delete' => 'כתובת ה-IP נמחקה',
    'actionlog__event_ip_address_update' => 'כתובת ה-IP עודכנה',
    'actionlog__event_client_create' => 'נוצר חשבון לקוח',
    'actionlog__event_client_delete' => 'חשבון הלקוח נמחק',
    'actionlog__event_client_update' => 'חשבון הלקוח עודכן',
    'actionlog__event_client_status_update' => 'מצב החשבון של הלקוח עודכן',
    'actionlog__event_client_preferences_update' => "העדפות הממשק של הלקוח עודכנו",
    'actionlog__event_client_siteapp_added' => "נוסף יישום אינטרנט למאגר היישומים של חשבון הלקוח",
    'actionlog__event_client_siteapp_removed' => "יישום האינטרנט הוסר ממאגר היישומים של חשבון הלקוח",
    'actionlog__event_domain_limit_size_reached' => 'המערכת הגיעה למגבלת שטח הדיסק למינוי',
    'actionlog__event_domain_limit_traffic_reached' => 'המערכת הגיעה למגבלת התעבורה למינוי',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'המערכת הגיעה למגבלת שטח הדיסק למינוי',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'המערכת הגיעה למגבלת התעבורה למינוי',
    'actionlog__event_dns_record_create' => 'נוצר רישום לשרת ה-DNS',
    'actionlog__event_dns_record_delete' => 'נמחק רישום לשרת ה-DNS',
    'actionlog__event_dns_record_update' => 'עודכן רישום לשרת ה-DNS',
    'actionlog__event_dns_zone_soa_record_update' => 'עודכן רישום SOA DNS',
    'actionlog__event_dns_zone_switch_to_master' => 'אזור DNS הוחלף לראשי',
    'actionlog__event_dns_zone_switch_to_slave' => 'אזור DNS הוחלף למשני',
    'actionlog__event_dns_zone_turn_off' => 'אזור DNS מנוטרל',
    'actionlog__event_dns_zone_turn_on' => 'אזור DNS מופעל',
    'actionlog__event_pw_admin_force_reset' => 'הסיסמה לחשבון מנהל המערכת שסומן כנדרש לאיפוס סיסמה שונתה',

    'actionlog__domain_limit_database' => 'מיכסת מסד נתונים למינוי',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'המערכת הגיעה למיכסת מסדי הנתונים של MariaDB/MySQL למינוי',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'המערכת הגיעה למיכסה הרכה של מסדי הנתונים של MariaDB/MySQL למינוי',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'המערכת הגיעה למיכסת מסדי הנתונים של Microsoft SQL Server למינוי',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'המערכת הגיעה למיכסה הרכה של מסדי הנתונים של Microsoft SQL Server למינוי',
    'actionlog__event_plesk_component_upgrade' => 'רכיב Plesk עודכן',
    'actionlog__event_plesk_component_install' => 'רכיב Plesk מותקן',
    'actionlog__event_plesk_component_uninstall' => 'רכיב Plesk הוסר',
    'actionlog__event_domain_create' => 'דומיין ברירת מחדל (הדומיין הראשון שנוסף למינוי) נוצר',
    'actionlog__event_domain_delete' => 'דומיין ברירת מחדל (הדומיין הראשון שנוסף למינוי) נמחק',
    'actionlog__event_domain_update' => 'דומיין ברירת מחדל (הדומיין הראשון שנוסף למינוי) עודכן',
    'actionlog__event_domain_owner_change' => 'בעלי המינוי השתנו',
    'actionlog__event_domain_plan_change' => '‫תוכנית שירות של מינוי השתנתה‬',
    'actionlog__event_domain_status_update' => 'דומיין ברירת מחדל, המצב עודכן',
    'actionlog__event_domain_dns_update' => 'דומיין ברירת מחדל, אזור ה-DNS עודכן',
    'actionlog__event_subdomain_create' => 'נוצר תת-דומיין של דומיין ברירת מחדל',
    'actionlog__event_subdomain_delete' => 'התת-דומיין של דומיין ברירת מחדל נמחק',
    'actionlog__event_subdomain_update' => 'התת-דומיין של דומיין ברירת מחדל עודכן',
    'actionlog__event_domain_alias_create' => 'דומיין ברירת מחדל, נוצר כינוי',
    'actionlog__event_domain_alias_delete' => 'דומיין ברירת מחדל, הכינוי נמחק',
    'actionlog__event_domain_alias_update' => 'דומיין ברירת מחדל, הכינוי עודכן',
    'actionlog__event_domain_limits_update' => 'מגבלות המינוי עודכנו',
    'actionlog__event_cp_user_login' => 'משתמש Plesk נכנס למערכת',
    'actionlog__event_cp_user_logout' => 'משתמש Plesk יצא מהמערכת',
    'actionlog__event_mailname_create' => 'נוצר חשבון דוא"ל',
    'actionlog__event_mailname_delete' => 'חשבון הדוא"ל נמחק',
    'actionlog__event_mailname_clear' => 'חשבון דואר רוקן',
    'actionlog__event_mailname_update' => 'חשבון הדוא"ל עודכן',
    'actionlog__event_maillist_create' => 'נוצרה רשימת דיוור',
    'actionlog__event_maillist_delete' => 'רשימת הדיוור נמחקה',
    'actionlog__event_maillist_update' => 'רשימת הדיוור עודכנה',
    'actionlog__event_phys_hosting_create' => 'נוצר אחסון אתרים פיזי',
    'actionlog__event_phys_hosting_delete' => 'אחסון האתרים הפיזי נמחק',
    'actionlog__event_phys_hosting_update' => 'אחסון האתרים הפיזי עודכן',
    'actionlog__event_forwarding_create' => 'נוצר אחסון אתרים רגיל או של העברת תמונה קדימה',
    'actionlog__event_forwarding_delete' => 'אחסון האתרים הרגיל או של העברת התמונה קדימה נמחקו',
    'actionlog__event_forwarding_update' => 'אחסון האתרים הרגיל או של העברת התמונה קדימה עודכנו',
    'actionlog__event_webuser_create' => 'נוצר חשבון משתמש באינטרנט',
    'actionlog__event_webuser_delete' => 'חשבון המשתמש באינטרנט נמחק',
    'actionlog__event_webuser_update' => 'חשבון המשתמש באינטרנט עודכן',
    'actionlog__event_siteapp_install' => 'יישום האינטרנט הותקן',
    'actionlog__event_siteapp_reconfigure' => 'תצורת יישום האינטרנט נקבעה מחדש',
    'actionlog__event_siteapp_uninstall' => 'יישום האינטרנט הוסר',
    'actionlog__event_license_update' => 'מפתח הרישיון עודכן',
    'actionlog__event_admin_alias_create' => 'נוצר חשבון מנהל מערכת נוסף',
    'actionlog__event_admin_alias_delete' => 'חשבון מנהל המערכת הנוסף נמחק',
    'actionlog__event_admin_alias_update' => 'חשבון מנהל המערכת הנוסף עודכן',
    'actionlog__event_ftpuser_create' => 'נוצר חשבון FTP נוסף',
    'actionlog__event_ftpuser_update' => 'חשבון ה-FTP הנוסף עודכן',
    'actionlog__event_ftpuser_delete' => 'חשבון ה-FTP הנוסף נמחק',
    'actionlog__event_template_domain_create' => "נוצרה תוכנית שירות של משווק",
    'actionlog__event_template_domain_update' => "תוכנית השירות של המשווק עודכנה",
    'actionlog__event_template_domain_delete' => "תוכנית השירות של המשווק נמחקה",
    'actionlog__event_template_admin_create' => "נוצרה תוכנית שירות של מנהל מערכת",
    'actionlog__event_template_admin_update' => "תוכנית השירות של מנהל המערכת עודכנה",
    'actionlog__event_template_admin_delete' => "תוכנית השירות של מנהל המערכת נמחקה",
    'actionlog__event_database_server_create' => 'נוצר שרת מסד נתונים',
    'actionlog__event_database_server_update' => 'שרת מסד הנתונים עודכן',
    'actionlog__event_database_server_delete' => 'שרת מסד הנתונים נמחק',
    'actionlog__event_remote_dns_status_update' => 'מצב שרת ה-DNS המרוחק עודכן',
    'actionlog__event_session_preferences_update' => 'הגדרות ההפעלה עודכנו',
    'actionlog__event_domain_alias_dns_update' => 'דומיין ברירת מחדל, כינוי אזור ה-DNS של הדומיין עודכן',
    'actionlog__event_domain_move' => 'דומיין ברירת מחדל הועבר למינוי חדש',
    'actionlog__event_site_move' => 'דומיין הועבר למינוי חדש',
    'actionlog__event_site_subdomain_move' => 'תת-דומיין הועבר למינוי חדש',
    'actionlog__event_subdomain_move' => 'תת-דומיין של דומיין ברירת מחדל הועבר למינוי חדש',
    'actionlog__event_license_expired' => 'פג תוקף רישיון Plesk',
    'actionlog__event_database_create' => 'נוצר מסד נתונים',
    'actionlog__event_database_delete' => 'מסד הנתונים הוסר',
    'actionlog__event_database_user_create' => 'נוצר חשבון משתמש למסד נתונים',
    'actionlog__event_database_user_update' => 'הגדרות חשבון המשתמש למסד הנתונים עודכנו',
    'actionlog__event_database_user_delete' => 'חשבון המשתמש למסד הנתונים הוסר',
    'actionlog__event_client_guid_update' => "ה-GUID של הלקוח עודכן",
    'actionlog__event_domain_guid_update' => 'דומיין ברירת מחדל, GUID עודכן',
    'actionlog__event_reseller_create' => 'נוצר חשבון משווק',
    'actionlog__event_reseller_delete' => 'חשבון המשווק נמחק',
    'actionlog__event_reseller_update' => 'חשבון המשווק עודכן',
    'actionlog__event_reseller_guid_update' => 'ה-GUID של המשווק עודכן',
    'actionlog__event_reseller_ip_pool_update' => "מאגר ה-IP של המשווק עודכן",
    'actionlog__event_reseller_limit_size_reached' => 'המערכת הגיעה למגבלת שטח הדיסק לחשבון משווק',
    'actionlog__event_reseller_limit_traffic_reached' => 'המערכת הגיעה למגבלת התעבורה לחשבון משווק',
    'actionlog__event_reseller_limits_update' => 'מגבלות חשבון המשווק עודכנו',
    'actionlog__event_reseller_permissions_update' => 'הרשאות חשבון המשווק עודכנו',
    'actionlog__event_reseller_preferences_update' => "העדפות הממשק של המשווק עודכנו",
    'actionlog__event_reseller_siteapp_added' => "נוסף יישום למאגר היישומים של חשבון המשווק",
    'actionlog__event_reseller_siteapp_removed' => "היישום נמחק ממאגר היישומים של חשבון המשווק",
    'actionlog__event_reseller_status_update' => 'מצב חשבון המשווק עודכן',
    'actionlog__event_template_reseller_create' => 'נוצרה תוכנית משווק',
    'actionlog__event_template_reseller_delete' => 'תוכנית המשווק נמחקה',
    'actionlog__event_template_reseller_update' => 'תוכנית המשווק עודכנה',
    'actionlog__event_health_status_change' => 'מצב תקינות השרת השתנה',
    'actionlog__event_siteapp_upgrade' => 'יישום האינטרנט שודרג',
    'actionlog__event_extension_install' => 'הרחבה הותקנה',
    'actionlog__event_extension_uninstall' => 'ההרחבה הוסרה',
    'actionlog__event_extension_upgrade' => 'ההרחבה שודרגה',
    'actionlog__event_extension_status_update' => 'מצב ההרחבה עודכן',
    'actionlog__event_additional_license_expired' => 'תוקף רישיון נוסף פג',
    'actionlog__event_hostname_changed' => 'שם המארח של השרת השתנה',
    'actionlog__event_smb_user_create' => 'נוצר משתמש נוסף',
    'actionlog__event_smb_user_delete' => 'נמחק משתמש נוסף',
    'actionlog__event_smb_user_update' => 'עודכן משתמש נוסף',
    'actionlog__dns_record' => 'רשומת DNS',
    'actionlog__dns_zone' => 'אזור DNS',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC אינו מותקן על המארח המרוחק. לקבלת סיוע, פנה לספק השירות שלך.",
    'rsession_no_account_errmsg' => "לא ניתן לגשת לשירות המרוחק תחת חשבונך. הסיבה הנפוצה ביותר היא שהשירות עבור החשבון שלך טרם הופעל. המתן מספר דקות, ולאחר מכן נסה שוב. אם תתקל בשגיאה זו שוב, פנה אל מנהל המערכת.",
    'rsession_no_domain_errmsg' => "לא ניתן לגשת לשירות המרוחק עבור דומיין זה. הסיבה הנפוצה ביותר היא שהשירות עבור דומיין זה טרם הופעל. המתן מספר דקות, ולאחר מכן נסה שוב. אם תתקל בשגיאה זו שוב, פנה אל מנהל המערכת.",
    'rsession_unknown_errmsg' => "השרת המרוחק דחה את הניסיון לבסס הפעלה. לתמיכה, פנה למנהל המערכת. השגיאה הייתה: %1",
    'rsession_unknown2_errmsg' => "שגיאה לא מוכרת אירעה בזמן ביסוס פעולה מרוחקת. קרוב לוודאי שהשרת המרוחק אינו עונה כראוי או שאינו עונה כלל. בקש ממנהל המערכת לחפש את פרטי השגיאה ביומן הרישום של שרת האינטרנט.",
    'rsession_no_connect_errmsg' => "לא ניתן לגשת אל השירות המרוחק: החיבור להפעלה המרוחקת נכשל. לתמיכה, פנה למנהל המערכת.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "אפשר העלאה לספריה הנכנסת",
    'anonftp__allow_create_dirs' => 'אפשר יצירת ספריות בספריה הנכנסת',
    'anonftp__allow_download_incoming' => 'אפשר הורדה מהספריה הנכנסת',
    'anonftp__display_login' => 'הצג הודעת כניסה למערכת',
    'anonftp__login_text' => 'טקסט הודעה',
    'anonftp__limit_incoming_disk_space' => "הגבל את שטח הדיסק בספריה הנכנסת",
    'anonftp__limit_maximum_bandwidth' => "הגבל את רוחב הפס להורדה לדומיין FTP וירטואלי זה",
    'anonftp__limit_maximum_connections' => "הגבל את מספר החיבורים הבו-זמניים",
    'anonftp__unable_init' => "לא ניתן לאתחל חשבון FTP אנונימי: %1",
    'anonftp__unable_set_quota' => "לא ניתן להגדיר את מגבלת שטח הדיסק של הספריה הנכנסת: %1",
    'anonftp__unable_update' => "לא ניתן לעדכן מאפייני חשבון FTP אנונימי: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'אישורי SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "אישור ה-CA אינו חותם על האישור.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "זוג מפתח פרטי/אישור לא תואם.",
    'class_sslcertificate__invalid_cert_format' => "תבנית אישור לא חוקית.",
    'class_sslcertificate__invalid_private_key_format' => "תבנית מפתח פרטי לא חוקית.",
    'class_sslcertificate__prob_invalid_priv_key' => "נראה שתבנית המפתח הפרטי אינה חוקית.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'אין קבצים להעלאה.',
    'login_up__access_denied_no_permission' => "הגישה נדחתה. אין לך הרשאה להיכנס למערכת.",
    'mail__unable_remove_pattern' => "לא ניתן להסיר כתובת מהרשימה השחורה של השרת: %1", // PFW
    'mail__incorrect_network_format' => 'תבנית רשת שגויה: %1', // PFW
    'initconf__unable_change_passwd' => "לא ניתן לשנות את הסיסמה של מנהל המערכת: %1",
    'initconf__unable_get_passwd' => 'לא ניתן לקבל את סיסמת מנהל המערכת הנוכחית: %1 נכשל: %2',
    'initconf__invalid_hostname' => 'שגיאה בשם מארח "%1"',
    'initconf__unable_reconfig' => 'לא ניתן לקבוע את התצורה של Plesk‏: reconfig נכשל: %1',
    'initconf__unable_update_admin' => 'לא ניתן לעדכן את פרטי הקשר של מנהל המערכת: %1',
    '__refresh' => 'רענון',
    '__dalias_not_exist' => 'כינוי הדומיין אינו קיים.',
    '__bug146523_explanation' => ' גירסאות קודמות של Plesk התירו שימוש בעד 16 תווים בשמות משתמש FTP. בגירסה זו של Plesk, מספר התווים המרבי המותר בשמות משתמש FTP מוגבל ל-15. כדי לפתור בעיה זו, יש לקצר את אורך שמות משתמש FTP שהושפעו מהשינוי ל-15 תווים ולשנות תו אחד לפחות בשמות משתמש FTP אלה כדי להימנע מבעיות התנגשות של שמות משתמש. אנחנו מתנצלים על אי-הנוחות שנגרמה לכם עקב השינוי.',
    'domain__cannot_change_webmail' => 'לא ניתן לשנות דואר אינטרנט עבור הדומיין: %1',
    'sb_publish_disable_warning' => 'אם תכבה יצירת אתר אינטרנט בבונה הנוכחות, אתר האינטרנט הקודם שנוצר בבונה הנוכחות יוסר וכל נתוני אתר האינטרנט יאבדו. לחץ על \'אישור\' אם ברצונך להמשיך.',
    '__sbnet_client_use_sbnet' => "צור חשבון משתמש מתאים בבונה הנוכחות",
    'mail_resp_activate' => 'הפעל מענה אוטומטי',
    'limitsManger__limit_available_error' => 'לא ניתן להקצות את כמות המשאבים הנדרשת ("%%limitName%%"): רק %%available%% זמין עבור החשבון שלך.',
    'limitsManger__limit_reserved_error' => 'לא ניתן להקצות פחות משאבים ("%%limitName%%") מאלה שכבר בשימוש.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'לא ניתן לשנות את שם הדומיין: כבר קיימת ספריה וירטואלית בשם שצוין.',
    'domain_unable_to_rename' => 'לא ניתן לשנות את שם הדומיין.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'כללי',
    'spamfilter__spamassassin_status_legend' => 'סינון הודעות זבל SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'הגדרות SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "הפעל סינון הודעות זבל SpamAssassin בכלל השרתים",
    'spamfilter__spamassassin_user_status_legend' => 'הפעל סינון הודעות זבל SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'הפעל הגנת רשימה אפורה מפני הודעות זבל בכלל השרתים',
    'spamfilter__personal_settings_not_allowed' => 'מדיניות המערכת אינה מתירה שימוש בהגדרות נפרדות לסינון הודעות זבל.',
    'spamfilter__required_score' => 'הניקוד שהודעה חייבת לקבל כדי להיחשב להודעת זבל',
    'spamfilter__rewrite_header_subject' => 'הוסף את הטקסט הבא לתחילת הנושא של כל הודעה המזוהה כהודעת זבל',
    'spamfilter__use_mailuser_prefs' => 'החל הגדרות נפרדות על סינון הודעות זבל',
    'spamfilter__score_error' => 'הניקוד לא אמור להיות שלילי, החלק לפני הספרה העשרונית חייב להיות קטן מ-100 ולא יכול לכלול יותר משתי ספרות לאחר הנקודה העשרונית.',
    'spamfilter__rewrite_header_error' => 'נושא ההודעה יכול להכיל כל תו הניתן להדפסה מלבד סולמית (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'החזרה',
    'nonexistent_mail__mode_discard' => 'ביטול',
    'nonexistent_mail__mode_catch_addr' => 'העבר לכתובת דוא"ל',
    'nonexistent_mail__mode_catch_ip' => 'העבר לכתובת IP',
    'nonexistent_mail__bounce_not_supported' => 'מצב החזרה אינו נתמך',
    'nonexistent_mail__discard_not_supported' => 'מצב ביטול אינו נתמך',
    'nonexistent_mail__catch_not_supported' => 'העברה הלאה לכתובת דוא"ל אינה נתמכת',
    'nonexistent_mail__redirect_not_supported' => 'העברה הלאה לכתובת IP אינה נתמכת',
    'nonexistent_mail__ip_used_on_this_host' => 'כתובת ה-IP זוהתה כ-localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'מכיוון שבקרת הדואר היוצא פעילה, כתובת הדוא"ל %1 לנמענים שאינם קיימים צריכה להיות שייכת לדומיין שנבחר. אם היא אינה שייכת לו, תיושם המדיניות "דחייה" במקום העברה הלאה.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'מכיוון שבקרת הדואר היוצא מופעלת, כתובת הדוא"ל שצוינה להעברת דוא"ל (%1) צריכה להיות שייכת לדומיין שנבחר. אם היא אינה שייכת לו, ההודעה שנשלחה לכתובת זו לא תימנה ב\'בקרת דואר יוצא\'.',
    // mail acc extras
    '__antivirus' => "אנטי-וירוס",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'תמיכה ב-ASP.NET כבויה עבור אתר אינטרנט זה.',
    'phosting__php_forced_by_site_isolation' => 'לא ניתן לשנות הגדרות PHP: לא הוענקה ההרשאה לעקיפת מדיניות האבטחה בכלל השרתים.',
    'phosting__option_forced_by_site_isolation' => 'לא ניתן לשנות הגדרות %1: לא הוענקה ההרשאה לעקיפת מדיניות האבטחה בכלל השרתים.',
    'phosting__php_handler_id_not_registered' => 'מטפל ה-PHP אינו מותר בהגדרות בידוד האתרים. ייעשה שימוש במטפל PHP ברירת המחדל.',
    'phosting__php_served_by_nginx_is_not_available' => '‫מטפל ה-PHP (יישום FPM מטופל על-ידי nginx) אינו מותר בהגדרות בידוד האתרים.‬ ‫ייעשה שימוש במטפל PHP ברירת המחדל.‬',

    // tooltips

    'b_get_password_cancel' => 'חזור אל המסך הקודם מבלי לשלוח את הדוא"ל.',
    'b_get_password_send' => 'לחץ על "אישור" לשליחת הודעת שחזור סיסמה לכתובת הדוא"ל הרשומה במערכת.',

    'b_back' => 'חזור אל הדף הקודם.',
    'b_next' => 'עבור אל הדף הבא.',

    'b_dnsnstemplatelist_remove' => 'מחק את שרתי השמות שנבחרו.',
    'b_dnsnstemplatelist_search' => 'הזן תבנית חיפוש ולחץ למציאת שרתי שמות.',
    'b_dnsnstemplatelist_show_all' => 'הצג את כל שרתי השמות.',

    'l_dnsnstemplatelist_ns' => 'מיין רשומות תבנית DNS לפי שרת שמות.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'צור קישורים מאובטחים לקבצים ולתיקיות',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'אפשר קבצים ציבוריים',
    'cu__serverfilesharing_fsPublicFolder' => 'תיקיה לאחסון קבצים ציבוריים',
    'cu__serverfilesharing_fsPublicUrl' => 'כתובת URL לגישת מבקר לקבצים ציבוריים',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'אפשר הגנה על קבצים ציבוריים באמצעות סיסמה',
    'cu__serverfilesharing_fsPartnerFolder' => 'תיקיה לאחסון קבצים מוגנים בסיסמה',
    'cu__serverfilesharing_fsPartnersLogin' => 'שם משתמש לגישה לקבצים',
    'cu__serverfilesharing_fsPartnersPassword' => 'סיסמה לגישה לקבצים',
    'cu__serverfilesharing_fsDomain' => 'כתובת URL בסיסית של תיקיית אינטרנט. שם דומיין',
    'cu__serverfilesharing_fsPrefix' => 'כתובת URL בסיסית של תיקיית אינטרנט. קידומת',
    'cu__serverfilesharing_commandUpdate' => 'עדכן את הגדרות שיתוף הקבצים',
    'cu__serverfilesharing_commandInfo' => 'הצג את הגדרות שיתוף הקבצים הנוכחיות',
    'subscription_rename_is_forbidden' => 'המדיניות בכלל השרתים אוסרת על שינוי שמות מינויים.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "חשבונות FTP תחת הדומיין %1", // for Additional FTP Accounts
    '__ftp_users_list' => "חשבונות FTP",
    'ftp__user_name' => "שם חשבון FTP",
    'ftp__user_home' => "‫ספריית בית‬",
    'ftp__invalid_path' => "צוין נתיב לא חוקי",
    'i_ftp_ses_sub_user' => '‫הפעלת חשבון FTP.‬',
    '__new_passwd' => "סיסמה %1 חדשה",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => '‫לא ניתן לקבוע את התצורה של שרת אינטרנט במארח <%%host%%>‬',
    'apacheConfigurationFailedMessageBody' => "לא ניתן להפיק את קובץ התצורה של שרת האינטרנט במארח <%%host%%> עקב השגיאות הבאות: \n  \n %%error%% \n  \n פתור את השגיאות בתבניות התצורה של שרת האינטרנט והפק שוב את הקובץ.",

    'apacheConfigurationMessageAdminTitle' => 'יצירת תצורת שרת האינטרנט נכשלה',
    'apacheConfigurationMessageClientTitle' => 'אזהרה',

    'apacheConfigurationFailedAdminHomeMessage' => 'עקב שגיאות בתבניות התצורה לא נבנה קובץ תצורה חדש. הודעת השגיאה המפורטת נשלחה לדוא"ל שלך, לכן בדוק את הדוא"ל, תקן את השגיאות ולחץ על %1 כדי לנסות ליצור מחדש את התצורה.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'כאן', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'עקב שגיאות בתבניות התצורה לא נבנתה תצורה חדשה עבור הדומיין %1. הודעת השגיאה המפורטת נשלחה לדוא"ל שלך, לכן בדוק את הדוא"ל, תקן את השגיאות ולחץ על %2 כדי לנסות ליצור מחדש את התצורה.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'כאן', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'ייתכן חוסר עקביות בתצורת שרת האינטרנט עבור הדומיין %1. פנה למנהל השרת כדי לפתור את הבעיה.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'עקב שגיאות בתבניות התצורה לא נבנתה תצורה חדשה עבור חלק מהדומיינים. הודעת השגיאה המפורטת נשלחה לדוא"ל שלך, לכן בדוק את הדוא"ל, תקן את השגיאות ולחץ על %1 כדי לנסות ליצור מחדש את התצורה.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'כאן', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'ייתכן חוסר עקביות בתצורת שרת האינטרנט עבור חלק מהדומיינים שלך. פנה למנהל השרת כדי לפתור את הבעיה.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "מסמכי שגיאות מותאמים אישית",
    'dom_pref__webusers_script' => "אפשר למשתמשי אינטרנט להשתמש בקובצי Script",
    '__seoRedirect' => 'קבע את תצורת הדומיין המועדף כ-',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'ללא',

    '__sites' => 'דומיינים',
    'domain_plan__perm_denied_manage_phosting' => 'אין לך את ההרשאה לניהול הגדרות אחסון אתרים.',
    '__owned_by_client' => 'שייך ללקוח',
    'backup__restore__object_client_template' => 'תבנית לקוח',
    '__template_name' => 'שם תוכנית השירות',
    'template__not_exists' => 'אין תוכנית שירות כזו',
    'template__exists' => 'כבר קיימת תוכנית בשם %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'כתובת ה-IP שצוינה אינה נמצאת במאגר המשווק.',
    '__owner_name' => 'בעלי תוכנית השירות',

    'chown__error_check' => 'אירעו מספר בעיות בניסיון להקצות חלק מהמינויים לבעלים חדשים.',

    '__redirect_hint' => 'תנותב מחדש לכתובת החדשה בעוד 15 שניות... אם לא תועבר אוטומטית למיקום החדש, אפשר JavaScript או לחץ על ההיפר-קישור %%link%%.',

    'backup__restore__object_maillist' => 'רשימת דיוור',
    'backup__restore__object_site' => 'אתר',
    'backup__restore__object_user' => 'משתמש',
    'backup__restore__object_role' => 'תפקיד',

    'limit__name_max_site' => 'אתרים',

    'iis_pool__unable_rename_client' => "לא ניתן לשנות את שם מאגר יישומי IIS‏: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'שירות FTP אנונימי נתמך רק עבור הדומיין הראשי של מינוי.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'שירות FTP אנונימי נתמך רק עבור הדומיין הראשי של מינוי.',

    '__gb' => '‎ GB',
    '__tb' => 'TB',
    '__gb_month' => '‎ GB/חודש',
    '__tb_month' => 'TB/חודש',

    '__customer_total' => 'סך הכול ללקוח',
    '__site' => 'אתר',
    '__def_site' => 'אתר ברירת מחדל',
    '__subscription_name' => 'שם מינוי',
    '__subscription_name_powerUser' => 'שם מינוי',

    'limit__units_max_traffic_suffix' => '/חודש',

    'dom_pref__discard' => "דחייה",

    'mail__pattern_already_exists' => 'התבנית \'\'%1\'\' כבר נמצאת ברשימה השחורה.',

    '__not_supported' => 'לא נתמך',

    'plesk_key__sitebuilder' => 'אתרים שפורסמו באמצעות בונה הנוכחות',
    'limit__name_max_site_builder' => 'אתרים שפורסמו באמצעות בונה הנוכחות',
    'plesk_key__wpb-multi-language-sites-support' => 'תמיכה עבור אתרים מרובי שפות בבונה הנוכחות (Presence Builder)',

    'login_up__access_denied_no_subscriptions' => "הגישה נדחתה. אין מינויים זמינים לחשבון זה.",

    'interval__day' => '%1 ימים',
    'interval__hour' => '%1 שעות',
    'interval__minute' => '%1 דקות',
    'interval__second' => '%1 שניות',

    ///License options
    'plesk_key__backward_incompatibility' => '‫אתה מנסה להשתמש במפתח רישיון שנוצר עבור גירסה אחרת של Plesk.‬ ‫פנה לנציגי המכירות של Plesk כדי להשיג מפתח רישיון מתאים.‬',
    //Standalone or virtualization
    'virtualization_any' => "שרת פיזי או כל פתרון וירטואליזציה",
    'virtualization_pvc' => "גורמים מכילים של Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "‫שרת Virtuozzo‬",
    'plesk_key__virtualization' => "חוקי עבור הסביבות הבאות:",
    'plesk_key__virtualization_only_key' => 'מפתח הרישיון מיועד אך ורק לשימוש עם Plesk שפועל בתוך סביבה וירטואלית %1.',
    'plesk_key__virtualizations_only_key' => 'מפתח הרישיון מיועד אך ורק לשימוש עם Plesk שפועל בתוך הסביבות הווירטואליות הבאות: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'השימוש בערכות שפה מותאמות אישית אסור.',
    'plesk_key__allowed-locales' => 'שפות זמינות',
    'plesk_key__allowed-locales-any' => 'כל שפה',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'הספריה cgi-bin ממוקמת ב-',
    '_cgi_bin_mode_webspace' => 'ספריית הבסיס של המינוי',
    '_cgi_bin_mode_www_root' => 'בסיס המסמכים של דומיין זה',

    /// Custom buttons
    'custom_button__sort_key' => '‫עדיפות‬',
    'custom_button__place' => '‫מיקום‬',
    'custom_button__place_navigation' => '‫גישה משותפת‬',
    'custom_button__place_admin' => '‫דף הבית של מנהל המערכת‬',
    'custom_button__place_admin-settings' => '‫דף \'כלים והגדרות\' של מנהל המערכת‬',
    'custom_button__place_reseller' => "‫דף הבית של המשווק‬",
    'custom_button__place_reseller-settings' => '‫דף \'כלים וכלי עזר\' של המשווק‬',
    'custom_button__place_client' => '‫דף הבית של הלקוח‬',
    'custom_button__place_domain' => "‫דף 'אתרי אינטרנט ודומיינים' של המינוי‬",
    'custom_button__place_domain_powerUser' => "‫דף 'אתרי אינטרנט ודומיינים' של המינוי‬",
    'custom_button__place_domain-properties' => '‫כלי אתר אינטרנט‬',
    'custom_button__private' => '‫הצג אותי בלבד‬',
    'custom_button__image' => '‫תמונת רקע‬',
    'custom_button__conhelp' => "‫טקסט תיאור כלי‬",
    'custom_button__edit' => "‫הגדרות של קישור לשירות נוסף‬",
    'custom_button__include_client_cname' => "‫כלול את שם החברה של הלקוח‬",
    'custom_button__include_client_email' => "‫כלול את הדוא\"ל של הלקוח‬",
    'custom_button__include_client_id' => "‫כלול את מזהה הלקוח‬",
    'custom_button__include_client_pname' => "‫כלול את שם איש הקשר של הלקוח‬",
    'custom_button__include_domain_id' => "‫כלול מזהה מינוי, מזהה דומיין ומזהה כינוי דומיין‬",
    'custom_button__include_domain_id_powerUser' => "‫כלול מזהה מינוי, מזהה דומיין ומזהה כינוי דומיין‬",

    'custom_button__include_domain_name' => "‫כלול את שם הדומיין הראשי‬",
    'custom_button__include_ftp_user' => "‫כלול שם משתמש FTP‬",
    'custom_button__include_ftp_pass' => "‫כלול סיסמת FTP‬",
    'custom_button__internal_open' => "‫פתח כתובת URL ב-Plesk‬",
    'custom_button__text' => "‫תווית לחצן‬",
    'custom_button__url' => "‫כתובת URL‬",

    'custom_button__not_image' => 'הקובץ אינו קובץ תמונה.',
    'custom_button__big_image' => 'גודל הקובץ לא יכול לחרוג מ-‎100 KB.',
    'custom_button__failed_copy_image' => 'לא ניתן להעתיק את הקובץ: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'לא ניתן לשחזר גיבוי שאינו של משתמש מתקדם בתצוגת \'משתמש מתקדם\'.',
    '__unknown_network_interface' => 'ממשק רשת לא מוכר',

    'init_conf__ip_address' => 'כתובת IP',

    //Confirmation page
    'bt_confirm' => 'אישור',
    'b_confirm' => 'אשר בעלות על האתרים שלך.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'הגדרות מאגר יישומי ה-IIS הייעודי נקבעות בהתאם למדיניות האבטחה בכלל השרתים (תצורת בידוד אתרים).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'הגדרות מאגר יישומי ה-IIS הייעודי נקבעות בהתאם להגדרות הביצועים בכלל השרתים.',

    '__current' => 'נוכחי',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'השתמשת כמעט בכל הדומיינים שמספק לך רישיון Plesk ‏(90% ואף יותר).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'השתמשת כמעט בכל הדומיינים.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'השתמשת כמעט בכל אתרי בונה הנוכחות שמספק לך רישיון Plesk ‏(90% ואף יותר).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'השתמשת כמעט בכל אתרי בונה הנוכחות.',
    'promo__button_hide' => 'הסתרה',
    'promo__button_next' => 'הבא>>',
    'promo__button_prev' => '<< הקודם',
    'promo__button_license' => 'עדכון רישיון',

    'promo__google_integration_title' => 'שילוב עם שירותי Google',
    'promo__google_integration' => 'קבע את תצורת השילוב עם שירותי Google, כגון AdSense, ‏Google Apps וכלי מנהל אתר.',
    'promo__google_integration_button' => 'קביעת תצורה',

    'promo__button_learn_more' => 'למידע נוסף',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'ניתן להתאים אישית את מראה הממשק ואת הגדרות המיתוג באמצעות ערכות נושא מותאמות אישית. להנחיות להתאמה אישית של ערכות נושא של Plesk, עיין ב-%1.',
    'panel_branding__description_link' => 'המסמך הבא',

    ///// File Manager new buttons
    'bt_extract_archive' => 'חילוץ קבצים',
    'filemanager_error_extracting_files' => 'אירעה שגיאה במהלך חילוץ קובצי הארכיון: %1',
    'filemanager_no_archive_files_specified' => 'ציין את הארכיונים שברצונך לחלץ.',
    'filemanager_not_zip_archive_specified' => 'לא ניתן לחלץ את %1, הוא אינו ארכיון ZIP.',
    'filemanager_files_successfully_extracted' => 'קובצי הארכיון חולצו.',
    'filemanager_error_file_download' => 'הורדת הקובץ נכשלה: %1',
    'filemanager__user_poolgrp' => 'קבוצת מאגר יישומים',

    'loading' => 'טוען...',
    'bt_create_archive' => 'הוספה לארכיון',
    'filemanager__pack' => "הנתיב לארכיון: %1",
    'filemanager__archive_name' => 'שם קובץ ארכיון',
    'filemanager__empty_filename' => 'הזן את שם קובץ הארכיון.',
    'filemanager_archive_created' => 'הארכיון נוצר בהצלחה.',
    'filemanager_error_creating_archive' => 'לא ניתן ליצור את הארכיון: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "רשומה זו תתנגש עם הרשומה AAAA עבור האזור.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(שרת FTP אינו תומך בכתובות IPv6)",
    'cmd_dns__glue_dns_record_conflict' => 'רשומה זו תתנגש עם רשומת הדבק עבור האזור \'%1\'.',
    '__ftp_ipv6_not_supported' => "(שרת FTP אינו תומך בכתובות IPv6)",
    '__ipv6_not_supported' => 'IPv6 אינו נתמך.',
    'mail__ipv6_not_supported' => 'שרת הדואר אינו תומך ב-IPv6.',
    'mail__relay_while_list_ipv6_not_supported' => 'שרת הדואר אינו תומך ברשימה הלבנה של ממסר IPv6.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'ערך המסיכה חייב להיות כפולה של 16.',
    'mail__ip_or_mask_is_invalid' => 'כתובת IP או מסיכה לא חוקיות.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'העברה הלאה לכתובות IP מסוג IPv6 אינה נתמכת.',
    'sa__invalid_trusted_networks' => 'רשתות מהימנות שצוינו באופן שגוי: %1',
    'dns_add__enter_ipv6_address' => "כתובת IPv6",
    'license_trial_days_left' => 'Plesk פועל ברישיון ניסיון שיפוג בעוד %1 ימים.',
    'excl_ipv6_num' => 'כתובת IPv6 ייעודית',
    '__ip_mask' => "‫מסיכת רשת משנה‬",
    '__ipv4_addr' => 'כתובת IPv4',
    '__ipv6_addr' => 'כתובת IPv6',
    'template__num_excl_ipv6s' => 'הקצה למשווק כתובות IPv6 ייעודיות',
    'anonftp__exclusive_ipv4_required' => 'נדרשת כתובת IPv4 ייעודית לשם הגדרת שירות FTP אנונימי ושימוש בו.',
    'anonftp__ipv4_already_used' => 'לא ניתן להגדיר שירות FTP אנונימי עבור אתר זה מאחר שתצורתו כבר נקבעה בדומיין אחר באותה כתובת IPv4.',


    'restart__kav' => "‫אנטי-וירוס של Kaspersky‬",
    '__view_migration_log_detailed_info' => 'הצג את יומן הרשום',

    'chown__error_ip_absent_in_ip_pool' => 'כתובת ה-IP ‏%1 אינה נמצאת במאגר ה-IP של משתמש היעד.',
    'chown__error_ip_not_exist' => 'כתובת ה-IP בעלת המזהה \'%1\' אינה קיימת.',
    'chown__error_domain_ip_not_selected' => 'יש לבחור כתובת IP אחת לפחות עבור הדומיין %1. בדוק את הערכים שנבחרו למיפוי IP.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'כתובת IPv6 או מסיכה לא חוקיות: כתובת IP צריכה להיות כתובת חוקית לשידור ליעד בודד.',

    '__subscriptions' => 'מינויים',

    '__owned_by_reseller' => 'שייך למשווק',
    '__owned_by_provider' => 'שייך לספק',

    'service_plan__anonymous' => 'מותאם אישית',
    'subscription_not_locked__change_limits_warning' => 'מינוי זה אינו נעול: מגבלות השימוש במשאבים ישונו במהלך הסינכרון עם תוכנית השירות.',
    'subscription_not_locked__change_permissions_warning' => 'מינוי זה אינו נעול: ההרשאות ישונו במהלך הסינכרון עם תוכנית השירות.',

    'subscription__conflict_resolution_policy' => 'מדיניות פתרון התנגשויות',
    'subscription__conflict_resolution_policy_lock' => "נעל מינוי",

    'backup__list__backup_warnings' => 'אזהרות',
    'backup__list__backup_info' => 'מידע',
    'backup__restore__object_reseller_template' => 'תבנית משווק',
    'backup__restore__object_domain_template' => 'תבנית דומיין',

    'subscription__unable_lock_anonymous' => 'המינוי אינו קשור לתוכנית שירות, ולכן לא ניתן לבטל את נעילתו.',
    'subscription__unable_sync_anonymous' => 'המינוי אינו קשור לתוכנית שירות, ולכן לא ניתן לסנכרן אותו.',
    'subscription__unable_sync_locked' => 'המינוי נעול, ולכן לא ניתן לסנכרן אותו.',
    'subscription__locked' => 'המינוי נעול.',
    'component_name__urlrewrite' => "‫שכתוב כתובת URL‬",
    '__quantity' => 'כמות',
    'hst__www_root_dir_absent' =>  'אזהרה: הספריה שצוינה כבסיס למסמכים אינה קיימת.',
    'object_creation__domain_is_not_a_webspace' => 'ניתן ליצור אובייקט זה רק במינוי.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'המינוי מכיל אתרים, ולכן לא ניתן לשנות את סוג אחסון האתרים או למחוק אותו.',
    'phosting__apache_error_docs_are_not_enabled' => 'מסמכי שגיאה מותאמים אישית לא מופעלים בדומיין.',
    'phosting__addon_domain_ip_must_match_webspace' => 'שגיאה: עדכון כתובת ה-IP נכשל. לא ניתן להקצות לדומיינים של הרחבה כתובות IP שלא הוקצו לדומיין הראשי של המינוי.',
    'domain_plan__unable_change' => 'לא ניתן לשנות תוכנית שירות: %1.',
    'domain_plan__different_hosting_type' => 'הסוג הנוכחי של אחסון אתרים שונה מהסוג שצוין בתוכנית השירות.',
    'domain_plan__addon_text' => 'תוכנית הרחבה',
    'domain_plan__addon_description' => 'תוכנית ההרחבה משמשת כתוספת לתוכנית אחסון אתרים.',
    'asp_net__managed_runtime_version' => 'גירסת זמן הרצה מנוהלת ASP.NET',
    'plan__can_not_change_hosting_type' => 'בלתי אפשרי לשנות סוג אחסון אתרים בזמן עריכת תוכנית.',
    'plan__apply_problems' => 'התוכנית לא הוחלה עקב בעיות בפונקציונליות הבאה: %1',
    'plan_save__subscription_update_problem' => 'לא ניתן להחיל את השינויים בתוכנית על %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "המינוי מושעה זמנית עד להשלמת תהליך הגיבוי או השחזור. חזור מאוחר יותר.",
    '__login_incorrect_plain_shadow_password' => 'ציינת סיסמה שגויה לחשבון מנהל המערכת. השתמש בהרשאות מנהל המערכת (שורש), או השג את הסיסמה הנכונה. למידע נוסף על השגת הסיסמה, קרא את הקובץ ‎/etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'אינך יכול לשלוח את כתובת ה-IP שאינה בבעלותך',

    'dns__dns_zone_not_synchronized' => 'אזור ה-DNS שונה. אם ברצונך להחיל שינויים בתבנית DNS על אזור זה, לחץ על הלחצן \'החלת שינויים בתבנית DNS\' בדף זה או בחר באפשרות \'החל את השינויים על כל האזורים\' ב\'לוח ניהול שרת\'> \'כלים והגדרות\'> \'הגדרות תבנית DNS\'> \'החלת שינויים בתבנית DNS\'.',
    'dns__dns_zone_synchronize_link' => 'לחיצה',
    'dns__dns_zone_synchronize_done' => 'אזור ה-DNS סונכרן בהצלחה.',

    'dns__dns_zone_template_error' => 'אירעו בעיות בסינכרון אזורי ה-DNS עם תבנית אזור ה-DNS. ‏%1',

    'dns__soa_rname_type_owner' => 'כתובת הדואר האלקטרוני של בעל אתר האינטרנט',
    'dns__soa_rname_type_domain' => 'כתובת דואר אלקטרוני של דומיין',
    'dns__soa_rname_type_external' => 'כתובת דואר אלקטרוני חיצונית',
    'dns__soa_rname_enforce_email' => 'איסור שינוי כתובת דואר אלקטרוני RNAME בכל דומיין בנפרד',
    'dns__soa_rname_label' => 'דוא״ל (RNAME)',
    'dns__soa_rname_hint' => 'כתובת הדואר האלקטרוני של האדם שאחראי לאזור ה-DNS של הדומיין. הוחזר על ידי שרת ה-DNS בתגובה לשאילתות SOA.',

    'dns__dns_zone_soa_sync_title' => 'עקוף הגדרות SOA עבור כל הדומיינים הקיימים',
    'dns__dns_zone_soa_sync_legend' => 'דרוש אישור',
    'dns__dns_zone_soa_sync_text' => 'לעדכן את כל רשומות ה-SOA של כל הדומיינים המאוחסנים על ידי החלת השינויים שנעשו בתבנית ה-SOA?',

    'cu_db__repair_mysql_dbus' => "תקן סיסמאות משתמש MariaDB/MySQL. פעולה זו הכרחית אם שדרגת ל-Plesk 11 מגרסאות מוקדמות יותר.",

    'cu_scheduled_backup_comment' => '‫גיבוי מתוזמן‬',
    'cu_scheduled_backup_error' => 'אירעה שגיאה בתהליך הגיבוי: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> אירעה שגיאה בתהליך הגיבוי.',
    'cu_scheduled_backup_mail_message' => "%1\nנקודת כניסה של Plesk‏: %2\n\nהשגיאות הבאות אירעו במהלך הגיבוי המתוזמן:\n\n%3",

    'cu_scheduled_backup_hourly' => 'גיבוי שעתי',
    'cu_scheduled_backup_daily' => 'גיבוי יומי',
    'cu_scheduled_backup_weekly' => 'גיבוי שבועי',
    'cu_scheduled_backup_monthly' => 'גיבוי חודשי',
    'cu_scheduled_backup_comment_backup_all' => '%1. כל התצורה והתוכן.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. כל התצורה והתוכן מלבד הודעות אימייל.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. רק תצורה והודעות אימייל.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. כל התצורה והתוכן, מלבד מאגרי נתונים של המשתמש.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. כל התצורה והתוכן מלבד קובצי המשתמש.',
    'cu_scheduled_backup_comment_backup_database' => '%1. רק תצורה ומאגרי הנתונים של המשתמש.',
    'cu_scheduled_backup_comment_backup_file' => '%1. רק תצורה וקובצי המשתמש',
    'cu_scheduled_backup_comment_backup_domain' => '%1. תצורת הדומיין.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'האפשרות לאחסן גיבויים מתוזמנים באחסון ענן מרוחק היא תכונת פרימיום. פנה לספק אחסון האתרים שלך כדי לקבל גישה אליה.',

    'i_backup_invalid_file' => 'זה אינו גיבוי חוקי. לא ניתן לשחזר נתונים מקובץ זה. לפרטים נוספים, לחץ על שם הגיבוי.',

    'filemanager_resulting_archive_exists' => 'בספריית היעד כבר קיים הקובץ %1.',

    'agent_unable_to_connect' => 'אין אפשרות להתחבר לסוכן ב-\'%2\'. ודא שהסוכן מותקן ופועל, ושאין בעיות בחיבור עם המארח \'%2\'.',
    'agent_test_connection_failed' => 'החיבור לסוכן ב-\'%2\' נכשל.',

    'agent_unable_to_resolve_host' => 'לא ניתן לאתר את המארח המרוחק \'%1\'. ודא שאין בעיות בחיבור עם המארח.',
    'agent_unknown_curl_error' => 'השגיאה \'%1\' אירעה במהלך החיבור לסוכן ב-\'%2\'.',
    'agent_unexpected_htp_code' => 'קוד ה-HTTP הלא צפוי, \'%1\', התקבל לבקשת ה-HTTP מהסוכן ב-\'%2\'.',
    'agent_unable_to_auth' => '‫לא ניתן לאמת במארח \'%1\'.‬ ‫כדי לפתור בעיה זו, בצע את ההוראות בכתובת: http://kb.plesk.com/116606.‬',
    'agent_internal_server_error' => 'המערכת נתקלה בשגיאת שרת פנימית במהלך ביצוע הפקודה במארח המרוחק \'%1\'.',
    'agent_response_is_empty' => 'התקבלה תגובה ריקה לבקשת HTTP מהסוכן ב-\'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'לא ניתן למצוא את סוכן ההגירה וההעברה במטמון המקומי. פתח מחדש את סוכן ההגירה וההעברה כדי לטפל בבעיה.',

    '__hosting_webdeploy' => "פרסום פריסת אינטרנט",
    'cu_domain__webdeploy' => "פרסום 'פריסת רשת' (ברירת מחדל: %1)",
    'cu_dom_tpl__webdeploy' => "פרסום 'פריסת רשת' (ברירת מחדל: %1)",
    'cu_subdomain__webdeploy' => "פרסום 'פריסת רשת' (ברירת מחדל: %1)",
    'webdeploy__not_installed' => "'פריסת הרשת' של Microsoft אינה מותקנת בשרת",
    'webdeploy__forced_by_site_isolation' => "לא ניתן לשנות את ההגדרות של פרסום 'פריסת אינטרנט': אין לך הרשאה לעקוף את מדיניות האבטחה בכלל השרתים. למידע נוסף, פנה לספק השירות.",



    'backup__restore_options__admin__server_configuration_license' => 'מפתח רישיון',
    'migration_start_migrate_server_license' => 'העבר מפתח רישיון',

    'defaultcomponents__delegation_rule_not_exist' => '(כלל ההקצאה הנדרש \'appPoolPipeline, appPoolNetFx\' אינו קיים)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'מנהל המערכת יצר את הגיבוי.',
    'i_backup_created_by_reseller' => 'משווק יצר את הגיבוי.',
    'i_backup_created_by_client' => 'לקוח יצר את הגיבוי.',

    'migration__object_exists_on_target_host' => '(כבר קיים במארח היעד)',

    'cu_cl_pref__manage_website_maintenance' => 'גישה לפעולות מתקדמות: העתקת אתר אינטרנט',
    'cu_cl_pref__manage_protected_dirs' => 'ניהול ספריות מוגנות בסיסמה',
    'cu_cl_pref__manage_mail_settings' => 'יכולת לשנות הגדרות דואר',


    'cu__command_update_php_settings' => 'מעדכן הגדרות PHP.',
    'cu__php_settings_option' => 'מגדיר נתיב לקובץ עם הגדרות PHP.',

    'cu__additional_php_settings_option' => 'מגדיר נתיב לקובץ עם פקודות PHP.',
    'cu__command_show_php_settings' => 'מציג את הגדרות PHP הנוכחיות.',
    'cu__general_settings' => 'הגדרות כלליות:',
    'cu__performance_settings' => 'הגדרות ביצועים:',
    'cu__php_fpm_settings' => 'הגדרות PHP-FPM‏:',
    'cu__additional_directives' => 'הוראות נוספות:',

    'php_settings_permission_required' => 'ניהול משותף של הגדרות PHP',
    'php_settings_performance_permission_required' => 'ניהול הגדרות ביצועים של אחסון אתרים',
    'php_settings_customized' => 'הגדרות PHP הותאמו אישית.',
    'php_settings_synchronized_with_plan' => 'הגדרות PHP חייבות להיות מסונכרנות עם התוכנית.',
    'phosting__unknown_shell_type' => 'מעטפת לא זמינה',

    'login_up__access_denied_subscription_deleted' => 'הגישה נמנעה: המינוי שלך הוסר.',

    'role_restricted_to_subscription' => '(הועבר באמצעות המינוי: %1)',

    'filemanager__extract' => "חלץ קבצים אל: %1",

    'cu__license_command_check_installed_license' => 'בדוק את תוקף מפתח הרישיון המותקן (מחזיר את קוד היציאה 0 אם המפתח חוקי ו-1 אם הוא אינו חוקי)',

    'promo__mobile_manager_title' => '\'מנהל נייד לשרת\' של Plesk ‏(Plesk Server Mobile Manager)',
    'promo__mobile_manager' => "הרחב את תפקוד Plesk כך שתוכל לשלוט בשרת ולנטר אותו ממכשירים ניידים (BlackBerry, ‏iPhone ו-Android).",
    'promo__mobile_monitor_title' => '\'מנטר נייד לשרת\' של Plesk ‏(Plesk Server Mobile Monitor)',
    'promo__mobile_monitor' => 'קבל את המידע החשוב ביותר על שרתי Plesk בכל זמן ובכל מקום ממכשיר נייד (BlackBerry, ‏iPhone ו-Android).',
    'promo__mobile_button' => 'למידע נוסף',

    'subDomainNameHint' => 'הזן * כשם תת-דומיין כדי ליצור תת-דומיין של תו כללי. המבקרים באתר ינותבו מחדש אל התת-דומיין הזה, ללא תלות בשם התת-דומיין שהזינו בדפדפן.',
    'subdomains__wildcard_name_invalid' => "שם התת-דומיין אינו חוקי. ניתן להשתמש רק בתווים אלפאנומריים, במקף (-) ובכוכבית (*) לשמות תתי-דומיינים של תו כללי.",
    'subdomains__name_invalid' => "שם התת-דומיין אינו חוקי. ניתן להשתמש רק בתווים אלפאנומריים ובמקף (-) לשמות תת-דומיינים.",

    'domain__wildcard_no_www_prefix' => 'אי אפשר להשתמש בקידומת www לתת-דומיינים עם תווים כלליים.',

    '__service_title__milter' => "מסנן הדואר Postfix של Plesk",
    '__service_description__milter' => "מסנן הדואר Postfix של Plesk",
    '__milter' => "סיומת מסנן דואר",
    'restart__milter' => "מסנן דואר Plesk‏ (%1)",
    'restart__pop3' => "‫שרת Courier POP3‬",
    'restart__pop3s' => "‫שרת Courier POP3 עם תמיכה ב-SSL/TLS‬",
    'restart__imap' => "‫שרת Courier IMAP‬",
    'restart__imaps' => "‫שרת Courier IMAP עם תמיכה ב-SSL/TLS‬",
    'restart__authdaemon' => "‫Daemon אימות של Courier IMAP‬",
    'restart__imap-pop3' => "‫‫Dovecot IMAP ושרת POP3‬‬",


    'addon_packages_not_supported' => 'ההרחבות ליישומי אינטרנט בחבילת APS אינן נתמכות.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'לא ניתן להקצות כתובת IP לדומיין באופן אוטומטי. ציין כתובת IP באמצעות האפשרות ‎-ip.',

    'plesk_key__mb_accounts' => 'חשבונות משתמשים (משווקים או לקוחות) במנהל הלקוחות והעסקים',

    'actionlog__subdomain_dns' => 'אזור ה-DNS של התת-דומיין',
    'actionlog__site_subdomain_dns' => 'אזור ה-DNS של תת-דומיין תחת דומיין נוסף',

    // PfW only
    'actionlog__event_site_create' => 'נוצר דומיין',
    'actionlog__event_site_delete' => 'הדומיין נמחק',
    'actionlog__event_site_update' => 'הדומיין עודכן',

    'actionlog__event_site_status_update' => 'מצב הדומיין עודכן',
    'actionlog__event_site_dns_update' => 'אזור ה-DNS של הדומיין עודכן',
    'actionlog__event_site_guid_update' => 'ה-GUID של הדומיין עודכן',

    'actionlog__event_site_subdomain_create' => 'נוצר תת-דומיין',
    'actionlog__event_site_subdomain_delete' => 'התת-דומיין נמחק',
    'actionlog__event_site_subdomain_update' => 'התת-דומיין עודכן',

    'actionlog__event_site_alias_create' => 'נוצר כינוי דומיין',
    'actionlog__event_site_alias_delete' => 'כינוי הדומיין נמחק',
    'actionlog__event_site_alias_update' => 'כינוי הדומיין עודכן',

    'actionlog__event_site_alias_dns_update' => 'אזור ה-DNS של כינוי הדומיין עודכן',
    'actionlog__event_subdomain_dns_update' => 'אזור ה-DNS של תת-דומיין תחת דומיין ברירת המחדל עודכן',
    'actionlog__event_site_subdomain_dns_update' => 'אזור ה-DNS של תת-דומיין עודכן',
    // End of PfW only

    'win_policy__bad_password' => 'האימות נכשל. הסיסמה אינה חוקית.',
    'win_policy__password_too_short' => 'האימות נכשל. הסיסמה אינה עומדת בדרישות מדיניות הסיסמה מכיוון שהיא קצרה מדי.',
    'win_policy__password_too_long' => 'האימות נכשל. הסיסמה אינה עומדת בדרישות מדיניות הסיסמה מכיוון שהיא ארוכה מדי.',
    'win_policy__password_not_complex_enough' => 'האימות נכשל. הסיסמה אינה מורכבת מספיק ואינה עומדת בדרישות המדיניות ליצירת סיסמאות. כדי שסיסמה תהיה חזקה, יש להשתמש לפחות בכל התנאים הבאים: שמונה תווים; אות אחת קטנה או רישית; שלוש ספרות ותו מיוחד אחד (!, @, #, $, %, ^, &, *, ?, _, ~) או ספרה אחת ושני תווים מיוחדים.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'לא ניתן לעדכן את רישיון המוצר.',


    'filemanager__error_path_is_not_allowed' => 'הנתיב אינו מותר',
    'filemanager__error_path_is_invalid' => 'הנתיב אינו חוקי',
    'filemanager__error_path_not_found' => 'הנתיב לא נמצא',
    'filemanager__error_path_already_exists' => 'הנתיב כבר קיים',
    'filemanager__error_access_is_denied' => 'הגישה נמנעה',
    'filemanager__error_directory_not_empty' => 'התיקיה אינה ריקה',
    'filemanager__error_sharing_violation' => 'הפרת שיתוף',
    'filemanager__error_not_same_device' => 'נתיב היעד לא נמצא באותו התקן',
    'filemanager__unable_to_resolve_realpath' => "לא ניתן למצוא את הקובץ %1 במיקום שצוין",
    'filemanager__access_to_realpath_denied' => "‫הגישה ל-realpath נדחית: %1 עד %2.‬",
    'bt_exit' => 'יציאה',

    'filemanager__copy_error__' => "לא ניתן להעתיק את %1 ל-%2: %3",
    'filemanager__copy_move' => "העתק (העבר) קבצים מ-%1",
    'filemanager__count_size__' => 'גודל הבחירה: %1',
    'filemanager__count_size_error__' => 'לא ניתן לחשב את הגודל של %1: %2',
    'filemanager__create_dir_error__' => "לא ניתן ליצור את הספריה %1: %2",
    'filemanager__dir_not_exists' => "הספריה %1 אינה קיימת.",
    'filemanager__dirname' => "שם ספריה",
    'filemanager__filename' => "שם קובץ",
    'filemanager__is_no_such' => "אין קובץ או ספריה בשם %1",
    'filemanager__empty_selection' => "לא נבחרו קבצים.",
    'filemanager__move_error__' => "לא ניתן להעביר את %1 ל-%2: %3",
    'filemanager__not_allowed' => "אינך מורשה לשנות את ההרשאות לקובץ זה.",
    'filemanager__remove' => "הסר קבצים מ-%1",
    'filemanager__remove_error__' => "לא ניתן להסיר את הקובץ %1: %2",
    'filemanager__set_win_permissions_dir' => "הגדר הרשאות לתיקיה %1",
    'filemanager__set_win_permissions_file' => "הגדר הרשאות לקובץ %1",
    'filemanager__touch_confirm' => "האם אתה בטוח שברצונך לשנות את חותמת הזמן של הקבצים שנבחרו?",
    'filemanager__upload_error__' => "לא ניתן להעלות את %1 ל-%2: %3",
    'filemanager__upload_file' => "העלה קובץ",
    'filemanager__upload_file_src' => "נתיב לקובץ",

    '__fastcgi_unix_support' => 'תמיכת FastCGI',

    'dns__subdomain_dns_zone_parent' => 'רשומות ה-DNS של תת-דומיין זה מאוחסנות באזור DNS האב. ניתן לשנות את אזור האב %1 או ליצור אזור נפרד עבור התת-דומיין.',
    'dns__subdomain_dns_zone_parent_link' => 'כאן',
    'dns__no_dns_zone' => 'אין אזור DNS שהוקצה לדומיין. כדי לנהל אזור DNS עבור הדומיין שלך, יש ללחוץ על הלחצן \'שחזר ברירות מחדל\'.',
    'dns__unable_turn_on_subdomain_zone' => 'לא ניתן להפעיל את האזור של התת-דומיין, מכיוון שיש רשומת CNAME עבור תת-דומיין זה באזור דומיין האב שלו.',

    '__hosting_write_modify' => 'הרשאות כתיבה/שינוי נוספות',

    'aspdotnet__group_framework_version' => "גירסת מסגרת",

    'bt_restore_default' => "קביעה כברירת מחדל",
    'b_autoinstaller' => 'עדכן את Plesk או את הרכיבים שלו.',
    'b_autoinstaller_configure' => 'עדכן הגדרות.',
    'b_autoinstaller_install' => 'התקן את הרכיבים שנבחרו.',

    '__iis_app_pool__use_dedicated' => 'מאגר יישומי IIS ייעודי',
    '__iis_app_pool__use_dedicated_addons' => 'מאגר יישומי IIS ייעודי לכל אתר אינטרנט',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'הפעלת יישומי 32 סיביות',
    '__iis_app_pool__load_user_profile' => 'טעינה של פרופיל המשתמש',
    'bt_iis_app_pool' => "מאגר יישומים של IIS",

    'performance__cpu_usage' => 'שימוש מקסימלי ב-CPU (%)',
    'performance__cpu_usage_action' => 'פעולת מגבלה',
    'performance__cpu_usage_interval' => 'מרווח זמן של מגבלה (דקות)',
    'performance__cpu_usage_action_not_supported' => 'הפעולה שצוינה אינה נתמכת על ידי שרת האינטרנט.',

    'performance__idle_timeout_action_not_supported' => 'פעולת הזמן הקצוב לחוסר פעילות שצוינה אינה נתמכת על ידי שרת האינטרנט.',
    'performance__max_worker_processes' => 'המספר המרבי של תהליכי עובד:',
    'performance__idle_timeout' => 'זמן קצוב לחוסר פעילות (דקות)',
    'performance__idle_timeout_action' => 'פעולת זמן קצוב לחוסר פעילות',
    'performance__recycling_by_time' => 'מיחזור במרווחי זמן קבועים (בדקות)',
    'performance__recycling_by_requests' => 'מיחזור כאשר המערכת מגיעה למספר המקסימלי של בקשות',
    'performance__recycling_by_virtual_memory' => 'מיחזור כאשר נעשה שימוש בכמות המרבית של זיכרון וירטואלי',
    'performance__recycling_by_private_memory' => 'מיחזור כאשר נעשה שימוש בכמות המרבית של זיכרון פרטי',
    'performance__managed_pipeline_mode' => 'מצב קו צינור מנוהל',
    'performance__managed_pipeline_mode_not_supported' => 'המצב שצוין אינו נתמך על ידי שרת האינטרנט.',

    'iis_app_pool' => 'ניהול מאגר יישומי IIS.',
    'b_iis_app_pool' => 'נהל מאגר יישומי IIS.',
    'iis_app_pool_cl_dom' => 'ניהול מאגר יישומי IIS.',

    'bt_protect' => 'הגנה',
    'bt_unprotect' => 'הסרת הגנה',
    'bt_show_additional_users' => 'הצג יותר משתמשים',
    'bt_hide_additional_users' => 'הצג פחות משתמשים',
    'error_doc__code_400' => 'בקשה שגויה',
    'error_doc__code_401' => 'אין הרשאה',
    'error_doc__code_401.1' => 'לא מורשה - הכניסה למערכת נכשלה',
    'error_doc__code_401.2' => 'אין הרשאה - הכניסה למערכת נכשלה עקב תצורת השרת',
    'error_doc__code_401.3' => 'אין הרשאה - אין הרשאה עקב ACL במשאב',
    'error_doc__code_401.4' => 'אין הרשאה - המסנן הכשיל את מתן ההרשאה',
    'error_doc__code_401.5' => 'אין הרשאה - יישום ISAPI/CGI הכשיל את מתן ההרשאה',
    'error_doc__code_401.7' => 'אין הרשאה - נמנעה עקב מדיניות מתן הרשאות לכתובות URL',
    'error_doc__code_403' => 'אסור',
    'error_doc__code_403.1' => 'גישה אסורה - הגישה לביצוע נמנעה',
    'error_doc__code_403.2' => 'גישה אסורה - גישת הקריאה נמנעה',
    'error_doc__code_403.3' => 'גישה אסורה - גישת הכתיבה נמנעה',
    'error_doc__code_403.4' => 'גישה אסורה - נדרש SSL',
    'error_doc__code_403.5' => 'גישה אסורה - נדרש SSL 128',
    'error_doc__code_403.6' => 'גישה אסורה - כתובת IP נמנעה',
    'error_doc__code_403.7' => 'גישה אסורה - נדרש אישור לקוח',
    'error_doc__code_403.8' => 'גישה אסורה - הגישה לאתר נמנעה',
    'error_doc__code_403.9' => 'גישה אסורה - משתמשים רבים מדי',
    'error_doc__code_403.10' => 'אסור - תצורה לא חוקית',
    'error_doc__code_403.11' => 'אסור - שינוי סיסמה',
    'error_doc__code_403.12' => 'גישה אסורה - הממפה מנע את הגישה',
    'error_doc__code_403.13' => 'אסור - אישור הלקוח נשלל',
    'error_doc__code_403.14' => 'אסור - רישום הספריה נמנע',
    'error_doc__code_403.15' => 'אסור - חריגה מרישיונות הגישה של הלקוח',
    'error_doc__code_403.16' => 'אסור - אישור הלקוח אינו מהימן או שהמבנה שלו שגוי',
    'error_doc__code_403.17' => 'אסור - פג תוקף אישור הלקוח או שהאישור אינו תקף עדיין',
    'error_doc__code_403.18' => 'אסור - לא ניתן לבצע את הבקשה ממאגר יישומים זה',
    'error_doc__code_403.19' => 'גישה אסורה - גישת CGI נמנעה',
    'error_doc__code_403.20' => 'גישה אסורה - הכניסה למערכת באמצעות Passport נכשלה',
    'error_doc__code_404' => 'לא נמצא',
    'error_doc__code_404.2' => 'לא נמצא - נמנע עקב מדיניות נעילה',
    'error_doc__code_404.3' => 'לא נמצא - נמנע עקב מדיניות MIMEMAP',
    'error_doc__code_405' => 'פעולת השירות אינה מותרת',
    'error_doc__code_406' => 'לא קביל',
    'error_doc__code_407' => 'נדרש אימות Proxy',
    'error_doc__code_408' => 'זמן קצוב לבקשה',
    'error_doc__code_412' => 'התנאי המוקדם נכשל',
    'error_doc__code_414' => 'ה-URI של הבקשה ארוך מדי',
    'error_doc__code_415' => 'סוג מדיה שאינו נתמך',
    'error_doc__code_431' => 'שדות הכותרת של הבקשה ארוכים מדי',
    'error_doc__code_500' => 'שגיאת שרת פנימית',
    'error_doc__code_500.12' => 'שגיאת שרת פנימית - היישום מופעל מחדש',
    'error_doc__code_500.13' => 'שגיאת שרת פנימית - השרת עמוס מדי',
    'error_doc__code_500.15' => 'שגיאת שרת פנימית - בקשות ישירות ל-GLOBAL.ASA אסורות',
    'error_doc__code_500.16' => 'שגיאת שרת פנימית - שגיאת גישת UNC',
    'error_doc__code_500.17' => 'שגיאת שרת פנימית - לא נמצא מאגר הרשאות לכתובת URL',
    'error_doc__code_500.18' => 'שגיאת שרת פנימית - לא ניתן לפתוח מאגר הרשאות של כתובת URL',
    'error_doc__code_500.19' => 'שגיאת שרת פנימית - מטה-נתוני קובץ שגויים',
    'error_doc__code_500.100' => 'שגיאת שרת פנימית - שגיאת ASP',
    'error_doc__code_501' => 'לא מיושם',
    'error_doc__code_502' => 'שער לא תקין',
    'error_doc__code_503' => 'השירות אינו זמין באופן זמני',

    'mimetype_edit__already_exists' => 'סוג ה-MIME כבר מוגדר להרחבה זו.',
    'mimetype_edit__not_exists' => 'סוג MIME זה אינו קיים.',

    'php__group_php_version' => "גירסת PHP",

    'virtualdir__path' => '‫‏נתיב‬',
    'virtualdir__read' => 'הרשאת קריאה',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'הרשאת כתיבה',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'גישה למקור קובץ Script',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'עיון בספריה',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'בצע הרשאות',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'ביקור ביומן הרישום',
    'virtualdir__app_create' => 'צור יישום',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => '‫מפעיל אימות אנונימי.‬',
    'virtualdir__auth_windows' => '‫מפעיל אימות Windows.‬',
    'virtualdir__auth_not_enabled' => '‫יש להפעיל אימות אנונימי או של Windows.‬',
    'virtualdir__require_ssl' => 'דרוש SSL/TLS',
    'virtualdir__enable_default_doc' => 'השתמש במסמכי ברירת מחדל',
    'virtualdir__default_doc' => 'הזמנת חיפוש מסמכי ברירת מחדל',
    'virtualdir__enable_parent_paths' => 'אפשר שימוש בנתיבי אב',
    'virtualdir__execute_in_mta' => 'אפשר ביצוע יישום במצב MTA‏ (apartment עם הליכי משנה מרובים)',
    'virtualdir_create__title' => 'צור ספריה וירטואלית ב-%1',
    'virtualdir_edit__title' => 'מאפייני הספריה הווירטואלית %1',
    'virtualdir_edit__legend' => 'ספריה וירטואלית',
    'virtualdir_edit__application_legend' => 'הגדרות יישום',
    'virtualdir_edit__security_legend' => 'אבטחת ספריה',
    'virtualdir_edit__documents_legend' => 'מסמכים',
    'virtualdir_edit__list_legend' => 'ספריות וירטואליות מקוננות',
    'virtualdir_error__path_not_in__' => 'צוין נתיב לא חוקי',
    'virtualdir_root' => 'ספריות וירטואליות',
    'virtualdir_root__title' => 'ספריות וירטואליות',
    'virtualdir_root__list_legend' => 'ספריות וירטואליות',
    'virtualdir_se__none' => 'ללא',
    'virtualdir_se__script' => 'קובצי Script בלבד',
    'virtualdir_se__script_execute' => 'קובצי Script וקובצי הפעלה',
    'virtualdirs__title' => 'ספריות וירטואליות',
    'virtualdirs__path_not_exists' => 'נתיב לא חוקי.',
    'virtualdirs__select_for_remove' => "בחר את הספריות הווירטואליות שיוסרו.",
    'virtualdirs_remove__title' => 'הסרת ספריות וירטואליות',

    'asp_max_buffer_text' => 'גודל מקסימלי של מאגר ה-ASP ‏(KB)',
    'asp_max_body_text' => 'גודל מקסימלי של גוף ישות של בקשת ASP ‏(KB)',
    'asp_buffers_legend' => 'הגדרות ASP',
    'asp_client_debug_text' => 'אפשר איתור באגים בקובצי Script בצד הלקוח של ASP',
    'asp_server_debug_text' => 'אפשר איתור באגים בקובצי Script בצד השרת של ASP',

    'permissions__group_or_user_name' => 'שמות קבוצות או משתמשים',
    'permissions__FullControl' => 'בקרה מלאה',
    'permissions__Modify' => 'שינוי',
    'permissions__ReadAndExecute' => 'קריאה וביצוע',
    'permissions__ListFolderContents' => 'פירוט תוכן התיקיה',
    'permissions__Read' => 'קריאה',
    'permissions__Write' => 'כתיבה',
    'permissions__ReadControl' => 'בקרת קריאה',
    'permissions__WriteControl' => 'כתיבת בקרה',
    'permissions__ExecuteControl' => 'ביצוע בקרה',
    'permissions__TraverseFolderOrExecuteFile' => 'העברת תיקיה / הפעלת קובץ',
    'permissions__ListFolderOrRead' => 'פירוט תיקיה / קריאת נתונים',
    'permissions__CreateFilesOrWrite' => 'יצירת קבצים / כתיבת נתונים',
    'permissions__CreateFoldersOrAppend' => 'יצירת תיקיות / צירוף נתונים',
    'permissions__DeleteSubfoldersandFiles' => 'מחיקת תיקיות משנה וקבצים',
    'permissions__Delete' => 'מחיקה',
    'permissions__ChangePermissions' => 'שינוי הרשאות',
    'permissions__TakeOwnership' => 'לקיחת בעלות',
    'permissions__inherited_from' => 'עבר בירושה מ-',
    'permissions__not_inherited' => '<not inherited>',
    'permissions__apply_to' => 'החל על',
    'permissions__apply_onto' => 'החל על:',
    'permissions__apply_onto1' => 'תיקיה זו בלבד',
    'permissions__apply_onto2' => 'תיקיות משנה בלבד',
    'permissions__apply_onto3' => 'תיקיה זו ותיקיות משנה אלה',
    'permissions__apply_onto4' => 'קבצים בלבד',
    'permissions__apply_onto5' => 'תיקיה זו וקבצים אלה',
    'permissions__apply_onto6' => 'תיקיות משנה וקבצים בלבד',
    'permissions__apply_onto7' => 'תיקיה זו, תיקיות משנה וקבצים אלה',

    'filemanager__not_allowed_dir' => "אינך מורשה לשנות את ההרשאות לתיקיה זו.",

    'filemanager__allow' => "אפשר",
    'filemanager__deny' => "מניעה",
    'filemanager__user_domusr' => 'מנהל אתר אינטרנט',
    'filemanager__user_webusr' => 'משתמש אינטרנט',
    'filemanager__user_admins' => 'מנהלי מערכת',
    'filemanager__user_system' => 'מערכת',
    'filemanager__user_aspnet' => 'משתמש ASP.NET',
    'filemanager__user_poolusr' => 'משתמש מאגר יישומים',
    'filemanager__user_sysaccount' => 'משתמש מערכת נוסף',

    'bt_permissions_advanced' => 'מתקדם',
    'b_permissions_advanced' => 'לחץ להצגת הרשאות גישה מיוחדות ולהגדרתן.',

    'hotlink-protection_invalid_friend_domain' => 'שם לא תקני עבור דומיין ידידותי.',
    'hotlink-protection_duplicate_friend_domain' => 'שם זהה לדומיין ידידותי.',
    'hotlink-protection_invalid_extensions' => 'סיומות הקובץ מכילות תווים לא מתאימים.',

    'i_domain_alias_status_on' => 'כינוי הדומיין מאופשר.',
    'i_domain_alias_status_off' => 'כינוי הדומיין מנוטרל.',
    'i_domain_alias_status_with_parent' => 'כינוי הדומיין מנוטרל, מכיוון שכינוי הדומיין כבוי.',
    'i_domain_alias_turn_off' => 'לחץ כדי לנטרל.',
    'i_domain_alias_turn_on' => 'לחץ כדי לאפשר.',

    'domain_alias__control_title' => 'כינוי דומיין %1',
    'domain_alias__control_info_legend' => 'מידע',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'שם שירות',
    'domain_alias__control_details_title' => 'פרטים',

    'domain_alias__invalid_values' => 'שם הדומיין שציינת אינו חוקי. שמות דומיינים יכולים להכיל אותיות, ספרות ומקפים. אורכו של כל חלק בשם הדומיין שנמצא בין נקודות לא יעלה על 63 סימנים.',
    'domain_alias__domain_already_exists' => "שם כינוי הדומיין %1 שגוי. הדומיין %1 כבר קיים.",
    'domain_alias__www_prefix_domain_already_exists' => "שם כינוי הדומיין www.%1 שגוי. כינוי זה כבר נוצר עבור הדומיין %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'שם כינוי הדומיין webmail.%1 שגוי. כינוי זה כבר נוצר עבור הדומיין %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'שם כינוי הדומיין lists.%1 שגוי. כינוי זה כבר נוצר עבור הדומיין %1.',
    'domain_alias__dns_record_already_exists' => 'לא ניתן להגדיר את כינוי הדומיין %1, מכיוון שכבר קיימת רשומת DNS שמצביעה אל המארח %1.',
    'domain_alias__domain_alias_already_exists' => "כבר קיים כינוי דומיין בשם זה.",
    'domain_aliases__mail_server_not_support_aliases' => 'שרת הדואר אינו תומך בתכונה \'כינויי דומיינים\'. ייתכן שהתכונה \'כינויי דומיינים\' לא תתפקד כראוי.',
    'domain_alias__restrict_domain_creation' => 'המדיניות בכלל השרתים אוסרת את השם שצוין לכינוי הדומיין. אם שם כינוי הדומיין שייך לך, פנה לספק אחסון האתרים שלך.',
    'domain_alias__restrict_creation_with_www' => 'הזן שם דומיין ללא הקידומת \'www\'. הקידומת www עבור הדומיין תתווסף אוטומטית לתצורת שרת האינטרנט.',
    'domain_unable_to_set_name' => 'שם שגוי %1.',

    'domain_alias__domain_service_dns_disabled' => 'שרת DNS אחר משרת את הדומיין הזה.',
    'domain_alias__domain_service_dns_enabled_master' => 'שרת DNS זה משמש כשרת שמות ראשי עבור אזור DNS זה.',
    'domain_alias__domain_service_dns_enabled_slave' => 'שרת DNS זה משמש כשרת שמות משני עבור אזור DNS זה.',
    'domain_alias__domain_service_mail_enabled' => 'שירות הדואר מופעל עבור הדומיין.',
    'domain_alias__domain_service_mail_disabled' => 'שירות הדואר כבוי עבור הדומיין.',
    'domain_alias__domain_service_mail_mx' => '%1 משמש כשרת הדואר.',

    'domain_alias__service_seoRedirect_hint' => 'כאשר מבקרים פותחים את כתובת ה-URL של הכינוי, הם מנותבים מחדש לכתובת ה-URL של הדומיין הראשי. Plesk משתמש בניתוב מחדש HTTP 301 המותאם למנועי חיפוש, כלומר דירוג מנוע החיפוש לא יפוצל בין כתובות URL.',

    'bt_task_run_now' => 'הפעלה כעת',
    'ftp__read_perm' => "הרשאת קריאה",
    'ftp__write_perm' => "הרשאת כתיבה",

    'filemanager__upload_backup_file_hint' => 'כאן ניתן להעלות קובצי גיבוי לאחסון Plesk. גודל הקובץ המרבי מוגבל לשני ג\'יגה-בתים.',

    '__default_for_mssql' => 'ברירת מחדל ל-MS SQL',

    '__login_does_not_pass_validation' => "שם המשתמש אינו חוקי. ודא שהוא עומד בדרישות הבאות: %1",
    '__login_allowed_symbols' => 'מותרים רק תווים אלפאנומריים כולל נקודה, מקף וקו תחתון. התו הראשון צריך להיות אלפאנומרי.',

    'restart__nginx' => '‫שרת Proxy הפוך (nginx)‬',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "‫ברצוני לקבל מ-Plesk הודעות ומידע כללי על המוצר.‬",
    'admin_ed__i_would_like_recieve_tech_announce' => "‫ברצוני לקבל מ-Plesk מידע הקשור לאבטחה וכן הודעות טכניות אחרות.‬",

    '__login_status_inactive' => 'החשבון שלך אינו פעיל. פנה למנהל המערכת של Plesk.',

    'migration__task_keep_in_process' => 'אישור',
    'migration__task_keep_in_process_conhelp' => 'חזור אל הדף \'כלים והגדרות\'. ההעברה תמשיך ברקע.',

    'chk_js__warning_about_ftp_login_syntax' => "בשם המשתמש ניתן להשתמש בסימנים אלפאנומריים, מקף ומקף תחתון.",
    'chk_js__warning_about_passwd_syntax' => "אין להשתמש במרכאות, רווח ותווים אלפביתיים מקומיים בסיסמה.\nעל הסיסמה להיות באורך %1 עד %2 תווים, ואסור לה לכלול את שם המשתמש.",
    'chk_js__warning_about_plesk_login_syntax' => "בשם המשתמש ניתן להשתמש באותיות קטנות אלפאנומריות ובסימנים נקודה, מקף ומקף תחתון.",
    'chk_js__warning_about_admin_passwd_syntax' => "בסיסמה אין להשתמש במירכאות, רווח, נקודה פסיק ותווים אלפביתיים מקומיים.\nאורך הסיסמה צריך להיות בין %1 ל-%2 תווים, והיא לא אמורה להכיל את שם המשתמש.",

    'cmd_server__admin_alias_not_found' => "‫לא ניתן למצוא את חשבון מנהל המערכת הנוסף.‬",

    'panel_branding__skins_already_exists' => "הערה: ערכת הנושא '%1' כבר קיימת. היא תוחלף בערכת הנושא שאתה מתקין כעת.",
    'panel_branding__skins_file_exists' => "לא ניתן ליצור ספריה לערכת הנושא '%1': כבר קיים קובץ בשם זה.",

    'actionlog__login_failed' => 'הכניסה נכשלה',
    'actionlog__event_cp_user_login_failed' => 'כניסת משתמש Plesk נכשלה',
    'actionlog__api_login_failed' => 'הכניסה באמצעות API נכשלה',
    'actionlog__event_cp_user_api_login_failed' => 'כניסת משתמש Plesk באמצעות API נכשלה',
    'actionlog__pw_reset' => 'התבקש איפוס סיסמה',
    'actionlog__pw_admin_force_reset' => 'ביקש לבצע איפוס כפוי של סיסמת ‫מנהל מערכת‬',

    'ch_pass_admin__email_subject' => "הבקשה שלכם לאיפוס סיסמה ב-Plesk",
    'ch_pass_admin__email_body' => "שלום, %1.\n\nסיסמת המנהל לא יכולה להישלח באמצעות אימייל בשל סיבות אבטחה.\n\nלהתחברות כ-'admin', השתמש/י בפקודת 'plesk login'.\n\nלהגדרת סיסמת 'admin' חדשה, השתמש/י ב-'plesk bin admin --set-password -passwd <new_password>' command\n\n",
    'ch_pass_admin__message_send_error' => 'לא ניתן לשלוח את הדוא"ל: %1',

    'ch_pass_by_secret__email_subject' => "רוצה לאפס את הסיסמה שלך ב-Plesk?",
    'ch_pass_by_secret__email_body' => "שלום %2,\n\nאם ביקשת איפוס סיסמה, יש ללחוץ על הקישור הזה להגדרת סיסמה חדשה:%1\n\nהכניסה שלך: %3",
    'ch_pass_by_secret__message_send_error' => 'לא ניתן לשלוח את הקוד הסודי: %1',
    'ch_pass_by_secret__title' => '‫שינוי הסיסמה שלך‬',
    'ch_pass_by_secret__secret' => 'קוד סודי',

    'custom_button__noframe' => "‫אין להשתמש במסגרות‬",

    'custom_button__internal_hint' => '‫ציין אם לפתוח את כתובת ה-URL בדף Plesk או בחלון דפדפן חדש.‬',
    'custom_button__noframe_hint' => '‫‫אם תוסיף לחצן מותאם אישית שמפנה להרחבת Plesk או יישום בלוח הלקוח, תוכל לציין כיצד יש להציג הרחבה זו או יישום זה: במסגרת או כחלק מממשק המשתמש הגרפי של Plesk.‬‬',


    'actionlog__patch' => 'עדכון',
    'actionlog__patch_available' => 'זמין',
    'actionlog__event_patch_available' => 'קיים עדכון',
    'actionlog__patch_installed' => 'מותקן',
    'actionlog__event_patch_installed' => 'העדכון הותקן',

    'actionlog__extension' => 'הרחבה',
    'actionlog__extension_status' => 'מצב הרחבה',
    'actionlog__cloning' => 'שכפול שרתים',
    'actionlog__cloning_complete' => 'הושלם',
    'actionlog__event_cloning_complete' => 'שכפול שרתים הושלם',

    'actionlog__ssl_web_binding' => 'אישור SSL/TLS בדומיין',
    'actionlog__ssl_web_binding_update' => 'מוקצה/לא מוקצה',
    'actionlog__event_ssl_web_binding_update' => 'אישור SSL/TLS בדומיין מוקצה/לא מוקצה',

    'actionlog__ssl_web_mail_binding' => 'אישור SSL/TLS בדואר אינטרנט',
    'actionlog__ssl_web_mail_binding_update' => 'מוקצה/לא מוקצה',
    'actionlog__event_ssl_web_mail_binding_update' => 'אישור SSL/TLS בדואר אינטרנט מוקצה/לא מוקצה',

    'actionlog__ssl_mail_binding' => 'אישור SSL/TLS בשרת דואר',
    'actionlog__ssl_mail_binding_update' => 'מוקצה/לא מוקצה',
    'actionlog__event_ssl_mail_binding_update' => 'אישור SSL/TLS בשרת דואר מוקצה/לא מוקצה',

    'actionlog__ssl_panel_binding' => 'אישור SSL/TLS ב-Plesk',
    'actionlog__ssl_panel_binding_update' => 'מוקצה/לא מוקצה',
    'actionlog__event_ssl_panel_binding_update' => 'אישור SSL/TLS ב-Plesk מוקצה/לא מוקצה',

    'actionlog__hostname' => 'שם המארח של השרת',
    'actionlog__hostname_changed' => 'שונה',

    'actionlog__smb_user' => 'משתמש נוסף',
    'actionlog__smb_user_create' => 'נוצר משתמש נוסף',
    'actionlog__smb_user_delete' => 'נמחק משתמש נוסף',
    'actionlog__smb_user_update' => 'עודכן משתמש נוסף',

    'actionlog__event_mail_management_status_update' => 'עדכון סטטוס ניהול דואר',
    'actionlog__mail_management' => 'סטטוס ניהול דואר',
    'actionlog__mail_management_status_update' => 'עודכן',

    'virtualization_openvz' => 'OpenVZ',

    'passwordSecurityLevelCheckFailed' => 'הסיסמה שלך אינה מורכבת מספיק. על פי מדיניות השרת, חוזק הסיסמה המזערי הוא %1. כדי לשפר את חוזק הסיסמה יש להשתמש בספרות, באותיות גדולות וקטנות ובתווים מיוחדים, כגון !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'חלש מאוד',
    'passwordSecurityLevelCheckFailedWeak' => 'חלש',
    'passwordSecurityLevelCheckFailedMediocre' => 'בינוני',
    'passwordSecurityLevelCheckFailedStrong' => 'חזק',
    'passwordSecurityLevelCheckFailedStronger' => 'חזק מאוד',

    'dns__dns_default_ipv4_modified' => 'רשומות עם כתובת ה-IP הזו ייחשבו לכאלו ששונו על ידי משתמש ולא יסתנכרנו עם תבנית ה-DNS בכלל השרתים.',
    'dns__dns_default_ipv6_modified' => 'רשומות עם כתובת ה-IP הזו ייחשבו לכאלו ששונו על ידי משתמש ולא יסתנכרנו עם תבנית ה-DNS בכלל השרתים.',

    'dns__view_dns_record_master_title' => 'הצגת רשומות משאב',
    'dns__view_dns_record_off_title' => 'הצגת רשומות שרת שמות',
    'dns__view_dns_record_slave_title' => 'הצגת רשומות שרת DNS ראשיות',

    'dns_unable_to_resolve_hostname' => "לא ניתן לפענח את שם המארח \"%1\"‏: %2 \n ודא שמפענח ה-DNS של מערכת ההפעלה מוגדר ופועל כהלכה.",

    'no_database_server_available' => 'אין שרתי מסד נתונים זמינים עבור מינוי זה.',

    'database_used_by_application_can_not_be_moved' => 'לא ניתן להעביר את מסד הנתונים: יישום אתר אינטרנט משתמש במסד נתונים זה.',
    'database_user_update_orphaned_is_restricted' => 'אסור לעדכן חשבונות משתמשים של מסד נתונים יתום. ניתן רק למחוק או לתקן אותם.',

    'database_unable_to_get_max_filesize_default_message' => 'לא ניתן לקבוע את גודל הקובץ המרבי של מסד הנתונים: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'לא ניתן להגדיר את גודל הקובץ המרבי של מסד הנתונים: ‏\'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'לא ניתן לקבוע את הגודל המרבי של קובץ יומן הרישום של מסד הנתונים: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'לא ניתן להגדיר את הגודל המרבי של קובץ יומן הרישום של מסד הנתונים: \'%1\'',

    'database_unable_to_get_max_filesize' => 'לא ניתן לקבוע את המגבלה הנוכחית על גודל הקובץ של מסד נתוני Microsoft SQL ‏\'%1\'. בלתי אפשרי להגדיר מגבלה חדשה.',
    'database_unable_to_set_max_filesize' => 'לא ניתן להגדיר את המגבלה על גודל הקובץ של מסד נתוני Microsoft SQL ‏\'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'לא ניתן לקבוע את המגבלה הנוכחית על גודל קובץ יומן הרישום של מסד נתוני Microsoft SQL ‏\'%1\'. בלתי אפשרי להגדיר מגבלה חדשה.',
    'database_unable_to_set_max_log_filesize' => 'לא ניתן להגדיר את המגבלה על גודל קובץ יומן הרישום של מסד נתוני Microsoft SQL ‏\'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'לא ניתן ליצור את מסד נתוני Microsoft SQL ‏\'%1\': גודל הקובץ שלו גדול מהגודל המרבי המותר.',
    'database_unable_to_move_because_max_filesize' => 'לא ניתן להעביר את מסד נתוני Microsoft SQL ‏\'%1\': גודל הקובץ שלו גדול מהגודל המרבי המותר: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'לא ניתן ליצור את מסד נתוני Microsoft SQL ‏\'%1\': גודל קובץ יומן הרישום שלו גדול מהגודל המרבי המותר.',
    'database_unable_to_move_because_max_log_filesize' => 'לא ניתן להעביר את מסד נתוני Microsoft SQL ‏\'%1\': גודל קובץ יומן הרישום שלו גדול מהגודל המרבי המותר: %2.',
    'database_unable_to_restore_because_max_filesize' => 'לא ניתן לשחזר את מסד נתוני Microsoft SQL ‏\'%1\': גודל הקובץ שלו גדול מהגודל המרבי המותר.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'MS SQL server זהה כבר רשום ב-Plesk. ציין MS SQL server אחר כארגז חול (sandbox).',
    'database_server__mssql_server_registered_as_sandbox' => 'MS SQL server זהה המשמש כארגז חול (sandbox) כבר רשום ב-Plesk. ציין MS SQL server אחר כארגז חול (sandbox).',

    'database_server_mysql_unable_to_connect_via_cli' => 'לא מצליח להתחבר לשרת דרך %1: %2',

    'bu_conflict_resolver_feature_not_available' => 'התכונה %1 אינה נתמכת על ידי צומתי השירות הבאים: %2. תכונה זו תנוטרל עבור כל האובייקטים שנוצרו בצמתים אלה.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'שרת זה אינו תומך בתכונה %1. תכונה זו תנוטרל עבור כל האובייקטים המשוחזרים.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'הרכיב %1 אינו מותקן. הוא לא יהיה זמין עבור אתרי האינטרנט הבאים: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'הרכיב %1 אינו מותקן. הוא יוחלף ב-%2 עבור אתרי האינטרנט הבאים: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'גירסת Plesk הנוכחית אינה תומכת בשמות משתמש המכילים את התו נקודה (.). לקוחות ומשווקים עם שמות משתמש כאלה לא ישוחזרו.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'לא ניתן למצוא קובץ גיבוי המכיל את הנתונים עבור ה-%1 %2. הנתונים עבור ה-%1 %2 לא ישוחזרו.',

    'bu_conflict_resolver_zone_master_removed' => "לא ניתן לשחזר את רשומת ה-DNS הראשית: הרשומה באזור המשני מצביעה אל כתובת ה-IP הקיימת %1. רשומת ה-DNS הראשית תוסר מהאזור המשני.",
    'bu_conflict_resolver_dns_not_supported_https' => 'התמיכה לרישומי DNS של HTTPS מושבתת. רישומי HTTPS לא ישוחזרו לדומיינים הבאים: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 אינו נתמך.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 אינו נתמך. הוא לא יהיה זמין עבור אתרי האינטרנט הבאים: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'הרכיב %1 אינו מותקן.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'הוא לא יהיה זמין עבור צומתי השירות הבאים: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'הוא לא יהיה זמין עבור האובייקטים הבאים: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'שרתי מסדי הנתונים הבאים אינם זמינים ברשת זה: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'ניהול ה-smarthost לא נתמך. הגדרות ה-smarthost לא ישוחזרו.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'קובץ הגיבוי של מסד נתוני MS SQL מאוחסן בתבנית MS SQL מקומית, אותה ניתן לשחזר רק ל-MS SQL server המקומי או ל-MS SQL server מרוחק עם הגדרות גיבוי שתצורתן נקבעה במלואה. חלק ממסדי הנתונים שלך לא שוחזרו מכיוון שאין MS SQL server מתאים שרשום ב-Plesk. הדומיינים הבאים הושפעו: {{objects}}. פנה לספק אחסון האתרים שלך.',

    'bu_conflict_resolver_not_available_webmail' => 'שירות דואר האינטרנט %1 אינו זמין. הוא יוחלף ב-%2 עבור האובייקטים הבאים: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'שירות דואר האינטרנט %1 אינו זמין. הוא יוחלף ב-%2 עבור תוכניות השירות הבאות: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "מסדי נתונים מהסוג '%1' אינם תומכים בשמות משתמש שחופפים לשמות מסדי נתונים. שמו של המשתמש '%2' יוחלף ל-'%3' עבור מסד הנתונים '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'המגבלה על השימוש בשטח הדיסק אינה מוגדרת בתצורת שרת היעד. הערך של הגדרה זו ישונה ל"ללא הגבלה".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'המגבלה על מספר החיבורים אינה מוגדרת בתצורת שרת היעד. הערך של הגדרה זו ישונה ל"ללא הגבלה".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'המגבלה על השימוש בתעבורה אינה מוגדרת בתצורת שרת היעד. הערך של הגדרה זו ישונה ל"ללא הגבלה".',
    'cu__pleskrestore_backup_file_extracted' => 'קובץ הגיבוי חולץ ל-"%1".',
    '__mod_bw_not_supported' => 'המודול mod_bw לשרת האינטרנט Apache אינו נתמך עקב התצורה של מערכת הקבצים. המגבלות על שימוש בתעבורה ועל המספר המרבי של חיבורים לא יפעלו.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'הרשאת POP3 עבור ממסר דואר אינה נתמכת. במקומה, ייעשה שימוש בהרשאת POP3 before SMTP. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'תכנית שירות \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 אינו נתמך. הוא יוחלף ב-%2 עבור תוכניות השירות הבאות: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 אינו נתמך. הוא יוחלף ב-%2 עבור אתרי האינטרנט הבאים: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'האובייקטים הבאים לא נמצאו בקובץ הגיבוי: %1',
    'bu_conflict_resolver_absent_domains' => 'לא ניתן לשחזר חלק מהאובייקטים מכיוון שהם שייכים לדומיינים הבאים שאינם נמצאים ב-Plesk: ‏%1',
    'bu_conflict_resolver_absent_parent_domains' => "לא ניתן לשחזר חלק מאתרי האינטרנט מכיוון שהם שייכים לדומייני האב הבאים שאינם נמצאים ב-Plesk: ‏%1",
    'bu_conflict_resolver_dns_not_supported' => 'לא ניתן לשחזר אזורי DNS: שירות ה-DNS כבוי בתצורת השרת.',
    'bu_conflict_resolver_mail_not_supported' => 'לא ניתן לשחזר תיבות דואר: שירות הדואר כבוי בתצורת השרת.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'שרת האינטרנט IIS אינו תומך בפעולת מגבלות ה-CPU שצוינו. הערך יאופס ל-%1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'אישור SSL/TLS ‏%1 לשרת',
    'bu_conflict_detector_domain_ssl_cert_name' => 'אישור SSL/TLS  ‏%2 של הדומיין %1',
    'bu_conflict_detector_ssl_cert_name' => 'אישור SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'לא ניתן לשחזר את תוכן האובייקטים הבאים מכיוון שהם אינם נמצאים ב-Plesk: ‏%1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'לא ניתן לשחזר את תוכן תיבות הדואר הבאות מכיוון שהן אינן נמצאות ב-Plesk: ‏%1',
    'bu_conflict_resolver_absent_objects_maillist' => 'לא ניתן לשחזר את תוכן רשימות הדיוור הבאות מכיוון שהן אינן נמצאות ב-Plesk: ‏%1',
    'bu_conflict_resolver_absent_objects_database' => 'לא ניתן לשחזר את תוכן מסדי הנתונים הבאים מכיוון שהם אינם נמצאים ב-Plesk: ‏%1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => '‫השחזור של היישום "%1" ב-"%2" נכשל מכיוון שיישום אחר כבר מותקן ב-"%3".‬ ‫באפשרותך להסיר את היישום שמותקן ולנסות שוב.‬',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'אין תמיכה בפונקציית המענה האוטומטי.',
    'bu_conflict_resolver_not_available_mail_content' => 'אין תמיכה בשחזור תוכן הדואר.',
    'bu_conflict_resolver_invalid_mail_name' => 'תיבות הדוא"ל הבאות לא שוחזרו כי שימוש בתת-כתובות דוא"ל מאופשר וכתובות דוא"ל מסוימות כוללות סימן "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'המשתמשים הבאים לא שוחזרו כי שימוש בתת-כתובות דוא"ל מאופשר וכתובות דוא"ל מסוימות כוללות סימן "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'התוקף של הרישיונות הבאים פג והם לא ישוחזרו: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'הרישיונות הבאים לא נכונים או שפג תוקפם ולא ניתנים לשחזור: {{objects}}',
    'expiration_unsupported' => "המגבלה 'תפוגה' אינה נתמכת.",

    'component_name__dbconnector' => "‫מחבר מסדי נתונים‬",
    'component_name__mysqlserver' => 'שרת MariaDB/MySQL',
    'component_name__troubleshooting' => '‫פתרון בעיות‬',
    'component_name__savi' => 'ממשק אנטי וירוס Sophos',

    '__subscription_has_no_license_key' => 'את משאבי המינוי מספק צומת השירות #%1, שאין לו מפתח רישיון משויך.',
    '__subscription_has_expired_license_key' => 'את משאבי המינוי מספק צומת השירות %1, שפג תוקף מפתח הרישיון שלו, %2.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> לא מצליח לשמור קבצי תצורה',
    '__cfgmonConfigurationFileSaveErrorBody' => "לא ניתן לשמור קובצי תצורה אחדים במארח <%%host%%>: אירעו השגיאות הבאות:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'אפשרות זו מאפשרת לקבוע תצורה של כתובות דוא"ל בסגנון VERP לרשימות דוא"ל',
    'mail__enter_right_ip_mask' => "הזן את מסיכת ה-IP בין 1 ל-32",
    'mail__enter_right_ip_mask_24' => "הזן את מסיכת ה-IP בין 24 ל-32",
    'mail__invalid_dom_name' => "שם הדומיין %1 אינו תקף.",
    'mail__invalid_pop_lock_time' => "הזמן לנעילת POP3 אינו חוקי.",
    'mail__invalid_rbl_server' => "שם אזור ה-DNS אינו חוקי.",
    'mail__total_files_size' => "גודל מאגר כולל: %1",
    'mail__filename_already_in_repository' => "במאגר כבר קיים קובץ בשם זה",
    'mail__no_white_list_mask_feature_24' => "השתמש בערך מסיכה 24 או גבוה יותר.\nשרת הדואר שלך אינו תומך בהגדרת מסיכות. ביכולתנו רק לבצע אמולציה במסיכת הגדרות עבור ערכים מ-24 ומעלה.",
    'mail__unable_add_new_mail_name' => "לא ניתן להוסיף את חשבון הדואר האלקטרוני: %1",
    'mail_server_is_not_installed' => 'שרת הדואר (Postfix או Qmail) אינו מותקן. התקן אותו כדי להמשיך בעבודה.',
    'mail_server_not_available' => 'אין שרתי דואר נתמכים זמינים בצומת השירות.',
    '__not_installed' => '(לא מותקן)',
    'mail__service_node_outgoing_messages_is_disabled' => 'סינון הודעות זבל מהודעות דוא"ל יוצאות מנוטרל.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'צומת השירות אינו תומך בהגבלת מספר הודעות הדוא"ל היוצאות מדומיין עבור הדומיין %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'צומת השירות אינו תומך בהגבלת מספר הודעות הדוא"ל היוצאות מתיבת דואר עבור הדומיין %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'ציין כתובת מסוג אחד לפחות (IPv4 או IPv6).',

    'mail__outgoing_email_mode_invalid' => 'צוין מצב דואר יוצא לא חוקי.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'צוינה כתובת IPv4 לא חוקית.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'צוינה כתובת IPv6 לא חוקית.',
    'mail__outgoing_email_mode_unavailable' => 'שינוי מצב הדואר היוצא אינו נתמך, כנראה מכיוון ששרת הדואר Postfix אינו מותקן בשרת זה.',

    'mail__autoresponder_attachment_not_supported' => 'שרת הדואר שנמצא בשימוש כרגע אינו תומך בניהול קבצים מצורפים במענה אוטומטי.',

    'mail__smtp_white_list_not_supported' => 'שרת הדואר שנמצא כעת בשימוש אינו תומך ברשימות לבנות של כתובות IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'שרת הדואר שנבחר כעת אינו תומך במסיכות CIDR. יש לציין את כתובת ה-IP בפורמט \'‎192.*.0.*‎\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'שרת הדואר שנבחר כעת אינו תומך בתבניות IP עם תווים כלליים. יש לציין את כתובת ה-IP בפורמט \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'לא ניתן לשנות את ההגדרות עבור שירות האימות DKIM',

    'sfdk_domain__serverwide_disabled' => 'מכובה בהתאם למדיניות השרת',
    'feature__domainkeys__serverwide_disabled' => 'הגנת DKIM מפני הודעות זבל בכלל השרתים מכובה',

    'defaultcomponents__error_set_default' => 'לא ניתן להגדיר את %1 כ-%2 ברירת המחדל',
    'defaultcomponents__error_set_default_none' => 'אי אפשר להגדיר "none" כרכיב ברירת המחדל עבור %1',
    'defaultcomponents__required_package_not_default' => 'הרכיב %1 שדרוש לפעולתו אינו מוגדר כברירת המחדל.',

    '__percentage' => '%',
    '__seconds' => 'שניות',
    '__resource_remain' => 'נותר',

    '__not_registered' => '(לא רשום)',
    '__php_handler_id' => 'גירסת PHP',
    '__php_handler_id_string' => 'PHP‏ %1 (%2)',
    '__php_handler_not_registered' => 'מטפל ה-PHP‏ "%1" אינו רשום. הוא כנראה נמחק מהשרת. רשום מטפל בעל אותם המאפיינים ונסה שוב.',
    '__php_handler_not_registered_on_domain' => 'הדומיין "%1": מטפל ה-PHP‏ "%2" אינו רשום. הוא כנראה נמחק מהשרת. רשום מטפל בעל אותם המאפיינים ונסה שוב.',
    '__php_fpm_handler' => 'יישום FPM',
    '__php_fpm-dedicated_handler' => 'יישום FPM ייעודי',

    'mailname_create_assigned_user_dublicate_error' => 'לא ניתן ליצור משתמש עבור תיבת הדואר. המשתמש בשם המשתמש %1 כבר קיים ויש לו תיבת דואר אחרת.',
    'mailname_create_assigned_user_role_absent_error' => 'לא ניתן ליצור משתמש עבור תיבת הדואר. תפקיד ברירת המחדל %1 של המשתמש אינו קיים.',

    'gphd__mime_types' => 'סוגי MIME',
    'gphd__handlers' => 'מטפלי Apache',
    'gphd__ip_restrictions_allow' => 'אפשר גישה לאתר עבור המארחים והרשתות שצוינו (למעט אלה שנמנעו)',
    'gphd__ip_restrictions_deny' => 'מנע גישה לאתר עבור המארחים והרשתות שצוינו',
    'gphd__directory_index' => 'קובצי אינדקס',
    'gphd__nginx_transparent_mode' => 'המצב בו Apache מטפל הן בתוכן סטטי והן בתוכן דינמי, בעוד nginx מעביר רק בקשות ותגובות HTTP ללא שינוי.',
    'gphd__nginx_serve_static' => 'הגש קבצים סטטיים ישירות על ידי nginx',
    'gphd__nginx_static_extensions' => 'סיומות קבצים סטטיים שחייבות להיות מטופלות על ידי nginx',
    'gphd__nginx_serve_php' => 'עבד קובצי PHP על ידי nginx',
    'gphd__www_root' => '‫ספריית שורש WWW‬',

    'eol__none' => 'אין לשנות',
    'eol__lf' => 'המר לסגנון Unix',
    'eol__cr' => 'המר לסגנון MacOS',
    'eol__crlf' => 'המר לסגנון Windows',

    'ui__dns_bad_zone' => 'אזור לא עקבי "%1":',
    'ui__dns_ns_has_no_address_records' => 'לרשומת NS ‏"%1" אין רשומות כתובת (A או AAAA).',
    '__dns_bad_zone' => 'אזור לא עקבי "%1":',
    '__dns_ns_has_no_address_records' => 'לרשומת NS ‏"%1" אין רשומות כתובת (A או AAAA).',
    '__dns_ptr_is_wildcard' => 'רשומת ה-PTR %1 אינה חוקית: הרשומה מצביעה אל דומיין תו כללי.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] אפשר גישה מרחוק למשתמש מסד הנתונים \'%3\' של הלקוח \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'לא ניתן לאפשר חיבורים מרוחקים למשתמש מסד הנתונים \'%1\': לא ניתן לקבוע את מספר יציאת TCP המשמשת את Microsoft SQL server ‏\'%2\'. הסיבות האפשריות הן הבאות: פרוטוקול TCP/IP לא מאופשר בתצורת שרת הרשת, או שתצורת השרת נקבעה כך שהשרת ישתמש ביציאות TCP דינמיות. קבע את תצורת השרת כך שיאזין ליציאת TCP קבועה ספציפית ונסה לאפשר שוב חיבורים מרוחקים.',

    'command__convertResellerHasCustomer' => 'לחשבון המשווק \'%1\' יש חשבון לקוח אחד או מספר חשבונות לקוחות. כדי להמיר חשבון משווק זה לחשבון לקוח, ראשית העבר חשבונות לקוחות אלה לבעלים חדשים או המר אותם לחשבונות משווקים.',
    'command__convertResellerNotReseller' => 'רק חשבונות משווקים ניתנים להמרה לחשבונות לקוחות. \'%1\' אינו משווק.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'לא ניתן לסנכרן את המינוי עם תוכנית השירות. ההגדרות הבאות של המינוי מתנגשות עם תוכניות השירות: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'החשבון \'%1\' הוא חשבון משווק. לא ניתן להעביר חשבונות משווקים לבעלים חדשים מכיוון שהם כבר בבעלותו של מנהל השרת.',
    'moveCustomer__wrong_owner_type' => "ניתן להעביר את חשבון הלקוח '%1' רק למשווק או למנהל מערכת, לא ללקוח אחר.",
    'moveCustomer__customer_already_belongs_to_owner' => 'חשבון הלקוח \'%1\' כבר שייך לבעלים שנבחרו.',
    'upgradeClient__user_is_admin' => 'לא ניתן להמיר את החשבון \'%1\' לחשבון משווק, מכיוון שהוא חשבון מנהל מערכת.',

    'mail__error_setting_max_connections_courier' => 'לא ניתן להגדיר את מספר החיבורים (IMAP, ‏POP3,‏ IMAP באמצעות SSL/TLS או POP3 באמצעות SSL/TLS) המרבי: %1',
    'mail__error_setting_max_connections_dovecot' => 'לא ניתן להגדיר את מספר החיבורים (IMAP, ‏POP3,‏ IMAP באמצעות SSL/TLS או POP3 באמצעות SSL/TLS) המרבי: %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'לא ניתן להגדיר את המספר החיבורים (IMAP, ‏POP3,‏ IMAP באמצעות SSL/TLS או POP3 באמצעות SSL/TLS) המרבי לכתובת ‎IP:‏ %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'לא ניתן להגדיר את מספר החיבורים (IMAP, ‏POP3,‏ IMAP באמצעות SSL/TLS או POP3 באמצעות SSL/TLS) המרבי לכתובת ‎IP עבור משתמש דואר ספציפי:‏ %1',
    'outgoing_messages_limit_value_invalid' => 'הערך חייב להימצא בטווח %%MIN%%..%%MAX%%. רק מנהל מערכת Plesk יכול לכוונן הגדרה זו.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "הדומיינים הבאים משתמשים בכתובות דוא\"ל חיצוניות להעברה הלאה של דואר שנשלח לכתובות שאינן קיימות. ההודעות שנשלחו לכתובות אלה לא יימנו ב'בקרת דואר יוצא': %1",
    'outgoing_messages_white_list_not_empty' => 'המגבלות על הדואר היוצא לא יפעלו עבור שולחי דואר שכתובות ה-IP שלהם נמצאות ברשימה הלבנה של שרת הדואר. לדוגמה, אם קיים localhost (127.0.0.0 / 8, ::1 / 128)‎ ברשימה הלבנה, כל הדואר מהשרת המקומי יישלח בהצלחה למרות המגבלות. שולחי דואר יכולים להשתמש בכתובות IP מקומיות (אתרי אינטרנט וקובצי Script מותאמים אישית שמתארחים בשרת המקומי) או בכתובות IP חיצוניות (לקוחות ששולחים דואר מתוכנות דואר שמותקנות במחשבים או במכשירים הניידים שלהם). כדי להפעיל את המגבלות עבור כל שולחי הדואר (הן המקומיים והן החיצוניים), הסר את כל כתובות ורשתות ה-IP מהרשימה הלבנה. שים לב שהסרת localhost (127.0.0.0 / 8, ::1 / 128)‎ מהרשימה הלבנה עלולה לשבש את הפעולה של אתרי אינטרנט וקובצי Script ששולחים דואר משרת זה. לפרטים על המגבלות על דואר יוצא, ראה "הגנה מפני הודעות זבל יוצאות" במדריך למנהל המערכת.',
    'outgoing_messages_relay_open' => 'ממסר הדואר פתוח: המגבלות על הדואר היוצא לא יפעלו.',

    'notification_aps_app_updates_available' => 'עדכונים זמינים עבור היישומים הבאים:',
    'notification_aps_app_updates_installed' => 'העדכונים הותקנו אוטומטית עבור היישומים הבאים:',
    'notification_aps_app_updates_requirements' => 'העדכונים זמינים עבור היישומים הבאים, אך לא ניתן להתקין אותם מכיוון שהגדרות אחסון האתרים של אתרי האינטרנט המתאימים אינן עומדות בדרישות ההתקנה:',
    'notification_admin_aps_app_updates_available_item' => '%%name%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'תוסף "%%name%%" ב-%%parentName%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'ערכת נושא "%%name%%" ב-%%parentName%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'תוסף "%%name%%" ב-%%parentName%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'ערכת נושא "%%name%%" ב-%%parentName%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%%‏ (%%url%%). הגירסה שלך: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'תוסף "%%name%%" ב-%%parentName%%‏ (%%url%%). הגירסה שלך: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'ערכת נושא "%%name%%" ב-%%parentName%%‏ (%%url%%). הגירסה שלך: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%%‏ (%%url%%). הגירסה החדשה: %%to%%. הגירסה הקודמת: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%%‏ (%%url%%). הגירסה החדשה: %%to%%. הגירסה הקודמת: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%%‏ (%%url%%). הגירסה החדשה: %%to%%. הגירסה הקודמת: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%%‏ (%%url%%). הגירסה המותקנת: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%%‏ (%%url%%). הגירסה שלך: %%from%%. הגירסה הזמינה: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'יישום חיצוני',

    'notification_outgoing_mail_exceeded_limits_domains' => 'דומיינים',
    'notification_outgoing_mail_exceeded_limits_mails' => 'כתובות דוא"ל',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'מינויים',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 הודעות לשעה',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'ללא הגבלה',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, המגבלה היא %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 ניסיונות לחרוג מההגבלות מ-%2 ועד ל-%3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 ניסיונות לחרוג מההגבלות מ-%2 ועד עכשיו',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "‫החרמת כתובת IP‏ (Fail2Ban)‬",

    'backup__restore__capability_fail2ban_not_installed_text' => 'רכיב Fail2ban אינו מותקן בשרת היעד.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'התקן את Fail2ban. שים לב שהפעולה עשויה להימשך מספר דקות.',

    'plesk_key__no_reseller_support' => 'לא ניתן לנהל משווקים עקב הגבלות רישיון.',
    'plesk_key__no_customers_support' => 'לא ניתן לנהל לקוחות עקב הגבלות רישיון.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'לא ניתן לעבור לתצוגה \'ספק שירות\' עקב הגבלות רישיון.',
    'plesk_key__no_security_core_support' => 'תכונות ליבת האבטחה (ModSecurity ו-Fail2Ban) אינן זמינות עקב הגבלות רישיון.',
    'plesk_key__outgoing-antispam' => 'בקרת דואר יוצא',
    'plesk_key__security-core' => 'ליבת אבטחה (ModSecurity ו-Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'ניהול חשבונות',
    'plesk_key__can-manage-subscriptions' => 'ניהול מינויים',
    'plesk_key__can-manage-customers' => 'ניהול לקוחות',
    'plesk_key__can-manage-resellers' => 'ניהול משווקים',
    'plesk_key__can-manage-custom-view' => 'זמינות מצב מוגבל',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'ניהול מינויים כבוי, אך יש לך כמה מינויים (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'ניהול משווקים כבוי, אך יש לך כמה משווקים (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => '‫ניהול לקוחות כבוי, אך יש לך כמה לקוחות (%1).‬',
    'plesk_key__limits_unlimited_subscriptions' => 'משאבי מינוי מסוימים בממשק Plesk שאתם לא יכולים לנהל יותר (כמו הגבלות על תיבות דואר ומקום פנוי בדומיין) מוגדרים כעת כלא מוגבלים.',
    'plesk_key__no_subscriptions_support' => 'לא ניתן לנהל מינויים עקב הגבלות רישיון.',
    'plesk_key__no_custom_view_support' => 'לא ניתן להשתמש במצב מוגבל עקב הגבלות רישיון.',
    'plesk_key__trial_forbidden_region' => 'מצטערים, Plesk לא זמין כרגע באזורך.',
    'additional_key__main_key' => 'המפתח הוא מפתח ראשי: לא ניתן להעלות מפתח ראשי כמפתח נוסף.',

    'gch__hosting_waf_rule_engine' => 'מצב חומת אש של אפליקציית אינטרנט',

    'backup__fieldset__restoration_options' => 'אפשרויות שחזור',
    'backup__restore_options__restore' => '‫שיחזור‬',
    'backup__restore_options__domain__domain_configuration' => 'תצורת דומיין',
    'backup__restore_options__domain__virtual_host_content' => 'תוכן מארח וירטואלי',
    'backup__restore_options__domain__mail' => 'דואר',
    'backup__restore_options__domain__databases' => 'מסדי נתונים',
    'backup__restore_options__client__client_configuration' => 'תצורת חשבון הלקוח',
    'backup__restore_options__client__domains' => "הדומיינים של הלקוח",
    'backup__restore_options__reseller__reseller_configuration' => 'תצורת חשבון המשווק',
    'backup__restore_options__reseller__personal_domains' => "הדומיינים של המשווק",
    'backup__restore_options__reseller__clients' => "לקוחות המשווק",
    'backup__restore_options__admin__server_configuration' => 'הגדרות שרת',
    'backup__restore_options__admin__administrator_configuration' => '‫תצורת חשבון מנהל המערכת‬',
    'backup__restore_options__admin__personal_domains' => "‫הדומיינים של מנהל המערכת‬",
    'backup__restore_options__admin__personal_clients' => "‫לקוחות מנהל המערכת‬",
    'backup__restore_options__admin__resellers' => 'משווקים',

    'badge_new' => 'חדש',
    'upgrade_php_on_subscription' => 'שדרג PHP במינויים שלך לגירסה 5.3.0 או מתקדמת יותר.',

    'pkey_notify__body_expiration_notification' => 'פג תוקף מפתח הרישיון. ישנן תכונות שיכולות להיות לא זמינות. פנה לספק אחסון האתרים שלך.',

    'crontab__crontab_entry_exists' => "המשימה המתוזמנת כבר קיימת.",
    'crontab__crontab_entry_not_exists' => "המשימה המתוזמנת אינה קיימת.",
    'crontab__invalid_values_found' => "ערכי פרמטר שגויים.",
    'crontab__cmd_max_len' => "אורך הפקודה לא יכול לעלות על %1 תווים.",

    'domain__domain_exists' => "קיים דומיין עם הקידומת 'www' ובאותו השם: %1. %2.",
    'domain__subdomain_exists' => "קיים תת-דומיין עם הקידומת 'www' ובאותו השם: %1. %2.",
    'domain__dalias_exists' => "קיים כינוי דומיין עם הקידומת 'www' ובאותו השם: %1. %2.",
    'domain__record_exists' => "קיימת רשומת DNS שמצביעה אל המארח %1. %2.",

    'ip_addr__cannot_assign_certificate' => "לא ניתן להגדיר את האישור '%1' כאישור ברירת מחדל: חסר מפתח פרטי.",
    'ip_addr__update_dns_error' => '‫אירעו בעיות בעת עדכון כתובת ה-IP באזורי DNS.‬ %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'לא ניתן להוסיף את כתובת ה-IP. ממשק רשת זה מקבל כתובות IP באופן אוטומטי.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'לא ניתן להסיר את כתובת ה-IP‏ %1. ממשק רשת זה מקבל כתובות IP באופן אוטומטי.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'לא ניתן לתקן את כתובת ה-IP‏ %1. ממשק רשת זה מקבל כתובות IP באופן אוטומטי.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'לא ניתן לשנות את הממשק של כתובת ה-IP‏ %1, משום שממשק הרשת %2 מקבל כתובות IP באופן אוטומטי.',

    'shm_lmsg__limit_for_resource_exceeded' => 'המערכת חרגה ממגבלת המינוי על מספר ה-%%type%%. המגבלה היא %%limit%%, ונעשה שימוש ב-%%usage%% כעת.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'יצירת ה-%%type%% אינה מותרת עבור מינוי זה.',
    'shm_lmsg__resource_title__db-mysql' => 'מסדי נתוני MariaDB/MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'מסדי נתוני MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'מסדי נתוני PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'משתמשי מסד נתונים',
    'shm_lmsg__resource_title__iis-application-pool' => 'מאגרי יישומי IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'חשבונות FTP נוספים',

    'db_user_unable_remove_mysql_global_privileges' => 'לא ניתן להסיר את ההרשאות הגלובליות של MariaDB/MySQL ממשתמש מסד הנתונים %1. סיבה: %2',
    'report__client_description' => '‫תיאור‬',

    'db__user_role_error' => 'צוין תפקיד שגוי של משתמש מסד נתונים: %1. בחר באחד מהתפקידים הבאים: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'לא מצליח לקבוע את מגבלת גודל הקובץ לבסיסי הנתונים הבאים של Microsoft SQL Server כי יש להם גודל קובץ גדול יותר: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'לא מצליח לקבוע את מגבלת גודל קובץ יומן הרישום לבסיסי הנתונים הבאים של Microsoft SQL Server כי יש להם גודל קובץ יומן רישום גדול יותר: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => '‫לא ניתן להגדיר כתובת IP ציבורית: חייבת להיות כתובת IP פרטית.‬',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => '‫לא ניתן להגדיר כתובת IPv4 ציבורית עבור כתובת ה-IPv6.‬',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => '‫לא ניתן להגדיר כתובת IPv6 ציבורית עבור כתובת ה-IPv4.‬',
    'ipaddress__cannot_set_up_public_ip_invalid' => '‫לא ניתן להגדיר כתובת IP ציבורית: כתובת IP לא חוקית.‬',

    '__user_already_exists' => "‫המשתמש %1 כבר קיים.‬",
    '__user_name_is_empty' => "‫ציין שם משתמש.‬",

    'upgrade_php_on_domain' => 'לא ניתן למצוא PHP מגרסה 5.3.0 או מתקדמת יותר באף אחד מהדומיינים שלך ב-WordPress. נסה לשדרג את PHP.',

    'component_name__waf' => 'חומת אש של אפליקציית אינטרנט',
    'component_name__vcs' => '‫מערכת בקרת גירסאות‬',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => '‫זוהה ניסיון התחזות אפשרי: הקישור ניסה להציג תוכן לא רלוונטי.‬',
    'forceResetPasswordUpdated' => 'הסיסמה שונתה. השתמש בסיסמה החדשה כדי להיכנס ל-Plesk.',

    'php_handlers_error_no_available_instance' => '‫לא ניתן ליצור דומיין: אין מטפלי PHP זמינים.‬',
    'domain_error_unable_to_apply_hosting_settings' => '‫לא ניתן להחיל הגדרות אחסון אתרים: %1‬',

    'plesk_not_configured' => '‫התצורה של Plesk לא נקבעה.‬ ‫עבור אל לוח הבקרה כדי לבצע קביעת תצורה שלאחר התקנה.‬',
    'cmd_mail__mail_password_duplicated' => '‫הצמד שצוין של כתובת דואר אלקטרוני וסיסמה כבר קיים בשרת הדואר.‬ ‫ציין כתובת דואר אלקטרוני או סיסמה אחרת.‬',

    'extensionRequirementOs' => '‫החבילה אינה תומכת במערכת ההפעלה (%1).‬',
    'extensionRequirementPleskMinVersion' => '‫Plesk %1 היא הגירסה המוקדמת ביותר שנתמכת על-ידי החבילה.‬',
    'extensionRequirementPleskMaxVersion' => '‫החבילה אינה תומכת בגרסאות החל מ-Plesk %1.‬',
    'extensionBlacklisted' => '‫ההרחבה %1 אינה מותרת להתקנה.‬',
    'extensionDisabled' => 'ההרחבה מנוטרלת.',


    'optimization_settings__unable_set_mpm_event' => '‫לא ניתן להגדיר את מצב mpm_event: מצב זה מחייב כיבוי של מודול Apache PHP5, אבל מודול זה משמש את הדומיינים.‬',
    'optimization_settings__unable_turn_off_php' => '‫לא ניתן לכבות את מודול Apache PHP5: הוא משמש את הדומיינים.‬',

    'hst_def__fp_admin_login' =>  '‫שם משתמש FTP‬',
    'hst_def__fp_admin_passwd' =>  '‫סיסמת FTP‬',

    'database_user_orphaned_old_password_wrong' => "‫לא ניתן לתקן את המשתמש היתום '%1': הסיסמה שגויה.‬",
    'cannot_load_partner_central_property_key_no_exist' => "‫לא ניתן לאחזר מאפיינים מותאמים אישית: מפתח הרישיון לא קיים.‬",
    'extensionScriptFailure' => "ההפעלה של %1 נכשלה עם ההודעה הבאה:\n%3",
    '__ssl_redirect' => "הפניית Permanent SEO-safe 301 מ-HTTP ל-HTTPS",
    'component_name__dotnetcore' => 'ליבת ‎.NET',
    'mail__dkim_not_supported' => 'ניהול DKIM אינו נתמך.',
    'mail__dmarc_not_supported' => 'ניהול DMARC אינו נתמך.',
    'mail__relay_white_list_not_supported' => 'ניהול הרשימה הלבנה של הממסר אינו נתמך.',
    'mail__black_list_not_supported' => 'ניהול הרשימה השחורה אינו נתמך.',
    'mail__autoresponder_not_supported' => 'ניהול המענה האוטומטי אינו נתמך.',
    'mail__autoresponder_message_subject' => 'תגובה אוטומטית',
    'defaultcomponents__not_supported_version' => '(גירסה שאינה נתמכת)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'האישור \'%1\' לא נמצא.',
    'certificate__unable_setup_certificate' => 'לא ניתן להתקין את האישור: תוכן המפתח הפרטי והאישור חסר.',
    'certificate__used_by_panel' => 'אחד מהאישורים שאתה עומד למחוק משמש לאבטחת Plesk.',
    'certificate__used_by_mail_server' => 'אחד מהאישורים שאתה עומד למחוק משמש לאבטחת שרת הדואר.',
    'certificate__used_by_domain_service' => 'אחד מהאישורים שאתה עומד למחוק משמש את שירות הדומיין.',
    'mail_server__not_installed' => 'לא ניתן להתקין את האישור עבור שרת הדואר כי שרת הדואר אינו מותקן.',

    'email_activation_mail_subject' => 'הפעל את חשבונך ב-Plesk',
    'email_activation_mail_body' => "נוצר חשבון בשרת Plesk‏ %1 \n\nפרטי חשבון: \nשם: %2 \nכתובת דוא\"ל: %3 \n\nאם המידע נכון, והחשבון נוצר עבורך, הפעל אותו באמצעות הקישור הבא: \n\n%4 \n\nבהפעלת החשבון, אתה מתיר לבעל השרת לאסוף נתונים אישיים שלך (שם ודואר אלקטרוני), לאחסן אותם, לעבדם ולהשתמש בהם לצורך היצירה של חשבונך והתמיכה בו, בהתאם לחוקים החלים על הגנת הנתונים אשר בתוקף, במסגרת חוזה.",

    'backup_transport_permission_name' => 'ניהול %1',
    'backup_transport_permission_description' => 'מאפשר להשתמש ב-%1 לאחסון גיבויים.',

    'domain_move_err_target_no_hosting' => 'לא ניתן להעביר את הדומיין למינוי ללא אירוח.',
    'domain_move_err_already_in_target' => 'הדומיין שייך כבר למינוי היעד.',
    'domain_move_err_main_domain' => 'לא ניתן להעביר את הדומיין הראשי.',
    'domain_move_err_subdomain_without_parent' => 'לא ניתן להעביר את התת-דומיין %1 ללא דומיין האב %2.',
    'domain_move_err_root_exists' => 'נתיב היעד עבור www_root %1 קיים כבר.',
    'domain_move_err_nested_roots' => 'לא ניתן להעביר את הדומיין מכיוון שהוא משתף את בסיס המסמכים עם דומיין אחר: %1.',
    'domain_move_err_no_mail_service' => 'לא ניתן להעביר את הדומיין מכיוון ששירות הדואר מושבת במינוי היעד.',
    'domain_move_err_app' => "היישום שמותקן ב-%1 הועבר אל המינוי '%2': %3",
    'domain_move_database_used_by_app' => "מסד הנתונים '%1' ב-%2 נמצא בשימוש של היישום שהועבר. כדי להקצות מחדש את מסד הנתונים ל-'%3', הרץ את הפקודה `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "מינוי היעד '%1' ננעל לסנכרון.",
    'domain_move_filesharing_disabled' => 'שיתוף קבצים הושבת.',
    'domain_move_website_preview_disabled' => 'תצוגה מקדימה של אתר אינטרנט הושבתה.',
    'domain_move_additional_webserver_settings' => "עיין בהנחיות שרת האינטרנט הנוסף של הדומיין, כדי למנוע תצורה לא תקינה.",
    'domain_move_no_permission' => "%1 אינו מותר עבור המינוי '%2'.",
    'domain_move_no_access' => "אין גישה למינוי '%1'.",
    'domain_split_no_create_permission' => "יצירת דומיין אינה מותרת.",
    'domain_split_empty_login' => 'חובה לספק את שם הכניסה של משתמש המערכת.',
    'domain_split_empty_password' => 'חובה לספק את הסיסמה של משתמש המערכת.',
    'domain_split_err_home_exists' => 'לא ניתן להעביר את הדומיין %1, מכיוון שיעד נתיב הבית כבר קיים ב-%2. שנה את שם הדומיין כדי להעבירו למינוי חדש.',
    'domain_split_err_no_hosting_subdomains' => 'לא ניתן להעביר את הדומיין למינוי חדש, מכיוון שלדומיין אין אחסון אתרים אבל יש לו תת-דומיינים. כדי להעביר את הדומיין, שנה את הערך \'סוג אחסון אתרים\' ל\'אחסון אתר אינטרנט\' (ב\'הגדרות אחסון אתרים\').',
    'domain_split_target_locked' => "מינוי היעד '%1' נעול לסנכרון.",
    'domain_split_target_unsynced' => "מינוי היעד '%1' לא סונכרן עם התוכנית עקב: %2.",
    'domain_merge_scheduled_backup_deactivated' => "גיבוי מתוזמן הושבת ב-'%1'.",
    'domain_merge_database_error' => "מסד הנתונים '%1' ב-%2 לא הועבר למינוי '%3'‏: %4",
    'domain_merge_anon_ftp_deactivated' => "FTP אנונימי ב-'%1' כובה.",
    'domain_merge_smb_user_access' => "המשתמש הנוסף '%1' הועבר למינוי '%2', אבל גישת המשתמש למינוי בוטלה.",
    'domain_merge_scheduled_tasks' => "משימות מתוזמנות הועברו אל מינוי היעד. סקירה של תצורת המשימות.",
    'domain_merge_scheduled_tasks_deactivated' => "משימות מתוזמנות הועברו אל מינוי היעד והושבתו. סקירה של תצורת המשימות.",
    'domain_merge_no_remove_permission' => "הסרת מינויים אינה מותרת.",
    'domain_merge_err_has_addons' => 'לא ניתן להעביר את הדומיין הראשי עם הדומיינים הנוספים שלו. העבר תחילה את הדומיין או הדומיינים %1.',
    'domain_merge_err_has_webusers' => 'לא ניתן להעביר את הדומיין הראשי עם משתמשי האינטרנט שלו.',
    'domain_merge_err_root_exists' => 'נתיב היעד %1 כבר קיים.',

    'database_server_edit_used_for_psa' => 'עדכון מסד הנתונים MariaDB/MySQL המקומי אסור.',
    'suggest_repair_main_suggestion_ui' => '<b>ניתן לתקן שגיאה זו</b> באמצעות כלי העזר `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'ניתן לתקן שגיאה זו באמצעות כלי העזר `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'לך ל\'אבחן ותקן\'',
    'suggest_repair_using_cli_and_ui' => 'כדי לעשות זאת, הרץ את פקודת `plesk repair %1` דרך ה-CLI או %2 והקלק על "תקן" ליד “Plesk Database”',
    'suggest_repair_using_cli' => 'כדי לעשות זאת, הרץ את פקודת `plesk repair %1` דרך ה-CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'שירות ה-DNS לא היה זמין כשהגיבוי נוצר. עם זאת, ישנם אזורי DNS פעילים בגיבוי, והם יאופשרו לאובייקטים הבאים: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'בקר משאבים (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'תמיכה ב-SmarterMail מרוחק',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(לא מותרת על פי מפתח הרישיון)',
    'plesk_key__validation_failed' => '%1 (קוד שגיאה: %2)',
    'promo__button_details' => 'פרטים',
    'promo__extension_catalog_title' => 'קטלוג הרחבות',
    'promo__extension_catalog_description' => 'בואו לעיין בקטלוג ההרחבות החדשות ולתגבר את Plesk במגוון הרחבות חזקות!',
    'promo__button_open_catalog' => 'פתיחת הקטלוג',

    'backup__repository_check_login' => "לא ניתן לגשת לאחסון: %1 יש לוודא שהכנסת את אישורי האחסון הנכונים.",
    'backup__repository_check_error_list' => "לא ניתן לגשת לאחסון: %1 יש לוודא שהכנסת את הגדרות האחסון הנכונות.",
    'backup__repository_check_error_mkdir' => "לא ניתן ליצור את הספריה: %1 יש לבדוק אם יש לך הרשאות ליצור תיקיות באחסון.",
    'backup__repository_check_error_upload' => "לא ניתן להעלות את הקובץ לאחסון: %1 יש לבדוק אם יש לך הרשאות להעלות קבצים לאחסון.",
    'backup__repository_check_error_download' => "לא ניתן להוריד את הקובץ מהאחסון: %1 יש לבדוק אם יש לך הרשאות להעלות ולהוריד קבצים מהאחסון.",
    'backup__repository_check_error_resume-upload' => "לא ניתן לחדש העלאה של הקובץ לאחסון: %1 יש לבדוק אם יש לך הרשאות לחדש העלאות לאחסון.",
    'backup__repository_check_error_resume-download' => "לא ניתן לחדש הורדה של הקובץ מהאחסון: %1 יש לבדוק אם יש לך הרשאות לחדש הורדות מהאחסון.",
    'backup__repository_check_error_enable-utf8' => "לא ניתן להפעיל את האחסון: %1 יש לבדוק אם האחסון תומך בקידוד UTF8.",
    'backup__repository_check_error_rm' => "לא ניתן להפעיל את האחסון: %1 יש לבדוק אם יש לך הרשאות למחוק קבצים מהאחסון.",
    'backup__repository_check_error_rmdir' => "לא ניתן להפעיל את האחסון: %1 יש לבדוק אם יש לך הרשאות למחוק תיקיות מהאחסון.",

    'backup__ftp_repository_check_login' => "%1 באפשרותך לבדוק אותם באופן עצמאי באמצעות הפקודה: %2",
    'backup__ftp_repository_check_error_list' => "%1 באפשרותך לבדוק אותם באופן עצמאי באמצעות הפקודה: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודה: %2",
    'backup__ftp_repository_check_error_upload' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודות: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודות: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודות: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודות: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודה: %2",
    'backup__ftp_repository_check_error_rm' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודות: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 באפשרותך לבדוק זאת באופן עצמאי באמצעות הפקודות: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'לא ניתן לשנות הגדרות ל-DMARC. כדי לאפשר אפשרות זו, נא להפעיל את DKIM ואת הגנת SPF מפני הודעות זבל.',
    'spf_server_wide_disable_failed' => 'לא ניתן לשנות הגדרות להגנת דואר זבל של SPF. כדי לנטרל את SPF, נא לכבות את DMARC לדואר נכנס.',
    'sfdk_server_wide_verify_disable_failed' => 'לא ניתן לשנות הגדרות להגנת דואר זבל של DKIM. כדי לנטרל את DKIM, נא לכבות את DMARC לדואר נכנס.',

    'ccs_not_supported' => 'תצורת מאגר האישורים המרכזי של IIS לא נקבעה במערכת.',
    'ccs_not_enabled' => 'ניהול מאגר האישורים המרכזי של IIS לא מאופשר ב-Plesk.',
    'ad_not_supported' => 'השרת לא מחובר לדומיין.',

    'component_name__appinit' => "אתחול יישום",
    'component_name__cors' => "שיתוף משאב מכמה מקורות",
    'component_name__httpcompression' => 'דחיסת תוכן HTTP',
    'common_feature_is_not_supported' => 'תכונה זו אינה נתמכת יותר.',
    'common_feature_is_not_supported_in_proto' => 'תכונה זו אינה נתמכת לגרסת פרוטוקול %1.',
    'autoinstaller__plesk_component' => 'רכיב Plesk',
    'plesk_key__key_expired' => 'מפתח הרישיון שלכם פג תוקף. כדי להמשיך להשתמש ב-Plesk‏, %1.',
    'plesk_key__key_purchase' => 'קנו רישיון חדש',
    'plesk_key__key_expired_period' => 'מפתח הרישיון שלכם פג תוקף לפני יותר מ-%1 ימים.',

    'sa_action_move' => 'העבר הודעות זבל לתיקייה \'דואר זבל\'',

    'bu_conflict_resolver_tomcat_not_supported' => 'יישומי Java אינם נתמכים יותר. הם לא יהיו זמינים עבור אתרי האינטרנט הבאים: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'גירסאות לנייד של אתרי אינטרנט שנוצרו ומאוחסנות ב-UNITY Mobile אינן נתמכות יותר. הן לא יהיו זמינות עבור אתרי האינטרנט הבאים: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'מדיניות השימוש בכלל השרתים לא מאפשרת שימוש בהגדרות אנטי-וירוס אישיות. הן ישוחזרו באופן חלקי לחשבונות דוא"ל בדומיינים הבאים: {{objects}}',

    'module__not_installed' => "ההרחבה %1 אינה מותקנת",

    'mail__mail_autodiscovery_server_error' => 'יש לציין שם דומיין מותאם אישית לגילוי אוטומטי של דואר',
    'mail__error_mail_autodiscovery_enable' => 'לא ניתן להגדיר גילוי אוטומטי של דוא"ל: %1',
    'mail__error_mail_autodiscovery_server' => 'לא ניתן להגדיר שם דומיין מוגדר אישית לגילוי אוטומטי של דוא"ל: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'לא ניתן לקבוע מחדש את תצורת רשומות DNS לגילוי אוטומטי לדומיינים: %1',

    'mail__smarthost_not_configured_error' => 'לא נקבעה תצורת smarthost.',
    'mail__smarthost_attach_domains_error' => 'צירוף הדומיינים ל-smarthost הסתיים עם שגיאות:',

    '__invalid_url' => 'כתובת ה-URL "%1" אינה חוקית',
    'actionlog__cloning_start' => 'הפעלה',
    'actionlog__event_cloning_start' => 'הפעלת שכפול שרתים',

    '__UPLOAD_ERR_FORM_SIZE' => "הקובץ שהועלה חורג מהגודל המותר של",
    '__UPLOAD_ERR_INI_SIZE' => "הקובץ שהועלה חורג מהגודל המותר של",
    '__UPLOAD_ERR_NO_FILE' => "לא התקבל קובץ",
    '__UPLOAD_ERR_OK' => "הקובץ הועלה בהצלחה",
    '__UPLOAD_ERR_PARTIAL' => "הקובץ הועלה באופן חלקי, נסה שוב",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'הספריה הזמנית חסרה',
    '__UPLOAD_ERR_CANT_WRITE' => 'כתיבת קובץ לדיסק נכשלה',
    '__UPLOAD_ERR_UNKNOWN' => 'אירעה שגיאה לא מוכרת של העלאת קובץ',
    '__accounts' => "חשבונות",
    '__access' => "גישה",
    '__address' => "כתובת",
    '__addresses' => "כתובות",
    '__acl_records' => 'רשומות ACL',
    '__admin_repository' => "מאגר של מנהל מערכת",
    '__all' => 'הכול',
    '__allowed' => "מותר",
    '__anonftp_status' => "FTP אנונימי",
    '__antispam' => "נגד הודעות זבל",
    '__apache_restart' => "...%1 שרת האינטרנט מופעל מחדש, נא להמתין...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "תמיכה ב-Microsoft ASP.NET",
    '__asp_win_support' => "תמיכה ב- Microsoft ASP",
    '__attachments' => "קבצים מצורפים",
    '__attachments_list' => "קבצים מצורפים",
    '__author' => 'מחבר',
    '__autoresp_name_already_exists' => "כבר קיים מענה אוטומטי בשם %1.",
    '__autoresponder' => "מענה אוטומטי",
    '__autoresponders' => "מענה אוטומטי",
    '__autoresponders_list' => "מענה אוטומטי",
    '__autoresponder_attachment_files' => "קבצים מצורפים של מענה אוטומטי",
    '__auto_updates_list' => '‫עדכונים זמינים‬',
    '__backup_utilites' => "כלי עזר לגיבוי",
    '__bind_status' => "מצב שרת DNS",
    '__bu_is_not_installed' => "השירות אינו זמין כעת, מכיוון שלא הותקנו כלי העזר לעדכון.",
    '__bu_not_support_in_key' => "יכולת גיבוי אינה נתמכת על ידי מפתח הרישיון.",
    '__notifications_not_support_in_key' => 'מפתח הרישיון אינו תומך בהודעות',
    'disabled_by_key' => 'לא נתמך על ידי מפתח הרישיון',
    '__bytes' => "בתים",
    '__can_not_use_reserved_words' => "לא ניתן להשתמש במילים השמורות.",
    '__certificate' => "אישור",
    '__cgi_support' => "תמיכה ב-CGI",
    '__city' => "עיר",
    '__cl_not_exist' => "חשבון הלקוח אינו קיים.",
    '__client' => 'לקוח',
    '__client_card' => "כרטיס לקוח",
    '__client_contact_name' => "שם איש קשר של לקוח",
    '__client_form' => "מידע אישי",
    '__client_ip_pool' => "מאגר ה-IP של הלקוח",
    '__client_limits' => "מגבלות חשבון לקוח",
    '__client_permissions' => "הרשאות של לקוח",
    '__client_preferences' => "העדפות של לקוח",
    '__client_status' => "מצב לקוח",
    '__client_total' => "סך הכול ללקוח",
    '__client_with_login_name_already_exists' => "כבר קיים משתמש בשם המשתמש \"%1\".",
    '__client_domuser_with_login_already_exists' => "‫שם המשתמש '%1' כבר משמש את מנהל המערכת של הדומיין '%1'.‬",
    '__clients_global_changes' => "שנה את חשבונות הלקוחות שנבחרו",
    '__cmd_not_found' => "פקודה לא מוכרת: %1",
    '__comments' => "הערות",
    '__component_version' => "גירסת רכיב",
    '__component_not_installed' => "הרכיב %1 לא הותקן",
    '__confirm_overwrite' => "אשר החלפה.",
    '__confirm_stop' => "עליך לאשר את עצירת התהליך.",
    '__confirm_passwd' => "אשר סיסמה %1",
    '__conhelp' => "‫תיאור‬",
    '__contact_name' => "שם איש קשר",
    '__country' => "ארץ",
    '__countries' => 'ארץ',
    '__country_unknown' => 'לא ניתן לזהות את קוד המשנה של הארץ.',
    '__courier-imap' => '‫שרת Courier‬',
    '__create_domain' => 'צור דומיין',
    '__crypted' => 'מוצפן',
    '__cp_access' => "גישה ל-Plesk",
    '__cp_user' => "משתמש Plesk",
    '__create' => "יצירה",
    '__create_client_template_without_template' => "צור חשבון משתמש ללא תבנית",
    '__create_domain_for' => "צור דומיין עבור <b>%1</b>",
    '__create_domain_template_without_template' => "צור דומיין ללא תבנית",
    '__creation_date' => "תאריך יצירה",
    '__crontab_unix' => "מתזמן",
    '__crontab_win' => "מתזמן",
    '__ct_month_jan' => 'ינואר',
    '__ct_month_feb' => 'פברואר',
    '__ct_month_mar' => 'מרץ',
    '__ct_month_apr' => 'אפריל',
    '__ct_month_may' => 'מאי',
    '__ct_month_jun' => 'יוני',
    '__ct_month_jul' => 'יולי',
    '__ct_month_aug' => 'אוגוסט',
    '__ct_month_sep' => 'ספטמבר',
    '__ct_month_oct' => 'אוקטובר',
    '__ct_month_nov' => 'נובמבר',
    '__ct_month_dec' => 'דצמבר',
    '__custom_button' => "לחצן מותאם אישית",
    '__custom_buttons_list' => "קישורים לשירותים נוספים",
    '__daily' => "יומי",
    '__database_not_activated' => "%1 לא הופעל בדף ניהול השרת.",
    '__database_not_installed' => "מסד הנתונים %1 אינו מותקן.",
    '__database_not_run' => "מסד הנתונים %1 אינו פועל.",
    '__database_is_corrupt' => "מסד הנתונים של Plesk פגום. הפעל את כלי העזר Reconfigurator כדי לתקן אותו.",
    '__databases' => "מסדי נתונים",
    '__databases_list' => "מסדי נתונים",
    '__database_type_not_supported_by_key' => '‫כדי להשתמש בשרת %1, אתה זקוק לתמיכה עבורו במפתח הרישיון שלך.‬ ‫פנה לנציג המכירות של Plesk.‬',
    '__date_immediately' => "היום",
    '__date_never' => "אף פעם",
    '__day(s)' => "יום/ימים",
    '__day0' => "א'",
    '__day1' => "ב'",
    '__day2' => "ימי שלישי",
    '__day3' => "ד'",
    '__day4' => "ימי חמישי",
    '__day5' => "ו'",
    '__day6' => "ש'",
    '__days' => "%1 ימים",
    '__db_admin_login_empty' => "הזנת שם משתמש ריק, ובכך כיבית את הבקרה באמצעות %1 בממשק. האם ברצונך להמשיך?",
    '__db_unable_to_unregister' => 'לא ניתן להסיר פרמטרים של חיבור מסד נתונים',
    '__db_db_exists' => 'יש מסד נתונים אחד לפחות בשרת',
    '__db_unable_to_change_server_name' => 'לא ניתן לשנות את השם עבור השרת',
    '__db_unable_to_change_port' => 'לא ניתן לשנות את היציאה עבור השרת',
    '__db_already_exist' => "מסד הנתונים %1 כבר קיים.",
    '__db_credentials_invalid' => "אישורי מסד הנתונים אינם חוקיים.",
    '__db_invalid_password_characters' => 'הסיסמה מכילה תווים לא חוקיים',
    '__db_engine' => "מנוע מסד נתונים", // indirect
    '__db_type' => "סוג מסד נתונים",
    '__db_user' => "משתמש מסד נתונים",
    '__db_server' => 'שרת מסד נתונים',
    '__def_domain' => "דומיין ברירת מחדל",
    '__default_for_mysql' => 'ברירת מחדל עבור MySQL',
    '__default_for_mariadb' => 'ברירת מחדל עבור MariaDB',
    '__default_for_percona' => 'ברירת מחדל עבור Percona',
    '__default_for_postgresql' => 'ברירת מחדל עבור PostgreSQL',
    '__delete' => "מחיקה",
    '__demo' => "פונקציה זו אינה זמינה בגירסת ההדגמה.",
    '__directory' => "ספריה",
    '__disable_lock_screen' => 'מונע ממשתמשים לעבוד עם Plesk עד שמסכי הממשק טעונים במלואם',
    '__dismiss_news?' => "האם אתה בטוח שברצונך לסגור לחלוטין את בלוק החדשות?  \n  \n לא תוכל לראות את בלוק החדשות עד שחדשות נוספות יהיו זמינות.",
    '__description' => "‫תיאור‬",
    '__disabled' => "כבוי",
    '__disk_space_limit' => "מגבלת שטח דיסק",
    '__cgroups_cpu_usage_limit' => 'מגבלת שימוש במעבד',
    '__cgroups_ram_usage_limit' => 'מגבלת שימוש ב-RAM',
    '__cgroups_disk_read_usage_limit' => 'מגבלת רוחב פס של קריאת דיסק',
    '__cgroups_disk_write_usage_limit' => 'מגבלת רוחב פס של כתיבה לדיסק',
    '__disk_usage_by' => "שטח דיסק מנוצל על ידי %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "רשומת ה-DNS‏ '%1' כבר קיימת.",
    '__dns_master_should_be_remote' => "צריכים להיות לך שני שרתי שמות מוסמכים במארחים נפרדים.",
    '__dns_record_not_exist' => "רשומת ה-DNS לא קיימת.",
    '__dns_server' => "שרת DNS", // indirect
    '__dom_id_is_undefined' => "מזהה דומיין אינו מוגדר.",
    '__dom_name' => "שם הדומיין",
    '__dom_name_is_invalid' => "שם הדומיין אינו חוקי. ודא ששם הדומיין שלך מורכב מסימנים אלפאנומריים, נקודה ומקף בלבד, ושאורכו לא עולה על 255 סימנים. כל חלק משם הדומיין שנמצא בין נקודות לא יכיל מעל 63 סימנים.",
    '__dom_not_exist' => "הדומיין אינו קיים.",
    '__domain' => "דומיין",
    '__domain_' => 'דומיין %1',
    '__domain_form' => "טופס דומיין",
    '__domain_id' => "מזהה דומיין",
    '__domain_is_turned_off_for_backup' => "אתר האינטרנט %1 מכובה זמנית עקב גיבוי או שחזור, ואינו זמין כעת.",
    '__domain_limits' => "מגבלות דומיין",
    '__domain_name' => "שם הדומיין",
    '__mail_name_in_ASCII_form' => "שם חשבון דוא\"ל בתבנית ASCII",
    '__message_error' => 'שגיאה',
    '__message_warning' => 'אזהרה',
    '__message_info' => 'מידע',
    '__domain_name_in_ASCII_form' => "שם דומיין בתבנית ASCII",
    '__domain_repository' => "מאגר של הדומיין %1",
    '__domain_status' => "מצב הדומיין",
    '__domain_found_tech' => "נמצאה טכנולוגיה בדומיין",
    '__domain_dns' => 'אזור ה-DNS של הדומיין',
    '__domain_total_powerUser' => "כמות כוללת עבור המינוי",
    '__domain_user' => "מנהל דומיין",
    '__domains_global_changes' => "שנה את הדומיינים שנבחרו",
    '__mailnames_global_changes' => "שנה את חשבונות הדוא\"ל שנבחרו",
    '__backup_manager' => 'מנהל הגיבויים',
    '__domains_list' => "דומיינים",
    'domains_list__list_header' => "דומיינים",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "שם הדומיין מתחיל ב-www, למרות שהקידומת WWW כבר נמצאת בשימוש. האם להמשיך בכל זאת?",
    '__dovecot' => '‫‫Dovecot IMAP ושרת POP3‬‬',
    '__dsmail' => "שירות דואר",
    '__dsmaillist' => "שירות רשימת דיוור",
    '__dumps_tot_size' => "גודל כולל של קובצי גיבוי באחסון מקומי",
    '__email' => "דוא״ל",
    '__email_addr_is_invalid' => "כתובת הדוא\"ל אינה חוקית.",
    '__enabled' => "מופעל",
    '__enter_cert_text' => "הזן טקסט אישור",
    '__enter_size' => "הזן גודל",
    '__exclusive' => "ייעודי",
    '__expiration_date' => "תאריך תפוגה",
    '__fax' => "פקס",
    '__file' => "קובץ",
    '__file_is_empty' => "הקובץ ריק.",
    '__file_name' => "שם קובץ",
    '__file_type' => 'סוג קובץ',
    '__filemanager' => "מנהל הקבצים",
    '__filepath_is_empty' => "הנתיב לקובץ ריק",
    '__files_list' => "קבצים",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "הגדרות FTP",
    '__ftp_serv' => "שרת FTP", // indirect
    '__ftp_server_parameters_are_empty' => "עליך להגדיר תחילה את מאפייני חשבון ה-FTP!",
    '__ftp_status' => "מצב שרת FTP",
    '__full_day0' => "יום ראשון",
    '__full_day1' => "יום שני",
    '__full_day2' => "יום שלישי",
    '__full_day3' => "יום רביעי",
    '__full_day4' => "יום חמישי",
    '__full_day5' => "יום שישי",
    '__full_day6' => "יום שבת",
    '__full_month1' => "ינואר",
    '__full_month10' => "אוקטובר",
    '__full_month11' => "נובמבר",
    '__full_month12' => "דצמבר",
    '__full_month2' => "פברואר",
    '__full_month3' => "מרץ",
    '__full_month4' => "אפריל",
    '__full_month5' => "מאי",
    '__full_month6' => "יוני",
    '__full_month7' => "יולי",
    '__full_month8' => "אוגוסט",
    '__full_month9' => "ספטמבר",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "מכסת דיסק קשיח",
    '__hard_disk_quota_not_supported' => 'מיכסת דיסק קשיח אינה נתמכת עקב תצורת מערכת הקבצים של השרת',
    '__help_topic_not_found' => 'נושאי העזרה שביקשת (%1) לא קיים.',
    '__hosting_ip_dns_ip_not_equiv' => "אף אחת מכתובות ה-IP שצוינו ברשומות A DNS אינה תואמת לכתובת ה-IP שמשמשת לאחסון אתרים.",
    '__hosting_scripting' => "תמיכה ב-Scripting של אחסון אתרים",
    '__hosting_setup_page_title' => "הגדרת אחסון אתרי אינטרנט עבור הדומיין %1",
    '__hosting_title' => "אחסון אתרים (%1)",
    '__hosting_type' => "סוג אחסון אתרים",
    '__hostname_is_empty' => "שם המארח ריק.",
    '__hour(s)' => 'שעה/ות',
    '__hst_type_incorrect' => "סוג אחסון האתרים שגוי.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "‫זמן חוסר פעילות‬",
    '__iface' => "ממשק",
    '__image' => "‫תמונה‬",
    '__imap_status' => "מצב שרת IMAP",
    '__incorrect_databases_login_pass' => "האישורים שציינת עבור גישה ל-PostgreSQL שגויים.",
    '__incorrect_ip_or_network_address' => 'רשת או כתובת IP שגויות.',
    '__info' => 'מידע',
    '__install' => "התקנה",
    '__install_prefix' => "התקן קידומת",
    '__invalid_cert_id' => "מזהה אישור לא חוקי",
    '__invalid_context' => "הקשר לא חוקי: %1",
    '__invalid_db_usr_name' => "שם משתמש מסד הנתונים אינו חוקי.",
    '__invalid_dir_name' => "שם הספריה אינו חוקי",
    '__invalid_dom_name' => "שם הדומיין אינו חוקי.",
    '__invalid_filename' => "שם קובץ לא חוקי. אין להשתמש בשילוב של גרש יחיד ו/או \"../\".",
    '__invalid_id' => "מזהה לא חוקי.",
    '__invalid_lines_num' => "ערך לא מתאים למספר שורות, מותר להשתמש רק בספרות.",
    '__invalid_max_letter_size' => "גודל ההודעה המרבי אינו חוקי.",
    '__invalid_restart_apache_interval' => "מרווח הזמן להפעלה מחדש של Apache אינו חוקי.",
    '__invalid_tmpl_name' => "שם התבנית אינו חוקי.",
    '__invalid_value' => "ערך לא מתאים.",
    '__ip_addr' => "כתובת IP",
    '__ip_address_and_mask' => "כתובת IP ומסיכת רשת משנה",
    '__ip_alias__mask' => "כתובת IP ומסיכת רשת משנה",
    '__ip_addr_is_invalid' => "כתובת ה-IP אינה חוקית.",
    '__ip_addr_list' => "כתובות IP",
    '__ip_address_and_mask_hint' => 'לדוגמה, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "‎ KB",
    '__kbps' => "‎ KB/s",
    '__kbytes' => "קילו-בתים",
    '__key_for_virtuozzo_only' => "מפתח הרישיון שלך מיועד לשימוש אך ורק בגורמים מכילים של Virtuozzo.",
    '__key_limits_exceeding' => "פעולה זו חורגת מהמגבלות שמגדיר רישיון התוכנה שלך. אם קיבלת הודעה זו, פנה אל הספק או אל היצרן כדי להבהיר את מגבלות הרישיון הזה או להרחיב אותן.",
    '__kilo' => "K",
    '__keywords' => 'מילות מפתח',
    '__lang_unknown' => 'לא ניתן לזהות את השפה.',
    '__languages' => 'שפה',
    '__learn_more' => 'למידע נוסף',
    '__loading' => 'טוען...',
    '__locales' => "ערכות שפה",
    '__lists' => "רשימות דיוור",
    '__literal_bytes' => "B",
    '__processing' => "המתן.<br>טוען...",
    '__locale' => "‫שפת ממשק‬",
    '__locale_is_not_defined' => "שפת הממשק אינה מוגדרת.",
    '__local_server_mysql' => 'שרת MariaDB/MySQL מקומי',
    '__local_server_postgresql' => 'שרת PostgreSQL מקומי',
    '__local_server_mssql' => 'שרת MS SQL מקומי',
    '__log_and_statistics_files' => 'קובצי יומן רישום ודוחות סטטיסטיים',
    '__config_files' => 'קובצי תצורה',
    '__chroot_files' => 'סביבה שעברה chroot',
    '__login' => "כניסה %1",
    '__login1' => "‫כניסה‬",
    '__login_disabled' => "הכניסה למערכת אסורה",
    '__login_enabled' => "הכניסה למערכת מותרת",
    '__login_incorrect' => "שם המשתמש או הסיסמה שגויים. נסו שוב.",
    '__login_rate_limit_reached' => "יותר מדי ניסיונות התחברות. נסו שוב מאוחר יותר.",
    '__login_name' => "שם משתמש %1",
    '__login_name_is_invalid' => "שם משתמש %1 אינו חוקי.",
    '__logon_time' => "‫זמן כניסה‬",
    '__ma' => "כינויי דואר",
    '__mail' => "דואר",
    '__mail_alias_name' => "שם כינוי דואר",
    '__mail_autodiscovery' => 'גילוי אוטומטי של דואר',
    '__mail_exchanger_name_is_invalid' => "שם Mail Exchanger אינו חוקי.",
    '__mail_groups' => "קבוצות דואר",
    '__mail_list_engine' => "תוכנת רשימת דיוור",
    '__mail_name' => "חשבון דואר אלקטרוני",
    '__mail_name_form' => "מאפייני חשבון דוא\"ל",
    '__mail_names' => "חשבונות דואר אלקטרוני",
    '__mail_serv' => "שרת דואר",
    '__mail_user' => 'משתמש דואר',
    '__mailgroup' => "קבוצת דואר",
    '__maillist' => "רשימת דיוור",
    '__maillists' => "רשימות דיוור",
    '__maillist_member' => 'חבר ברשימת דיוור',
    '__mailname' => "חשבון דואר אלקטרוני",
    '__mailname_redir_self' => "חשבון דוא\"ל לא יכול להעביר דואר לעצמו.",
    '__max_dom_num_reached_for_cl' => "המערכת הגיעה למגבלה על מספר הדומיינים עבור חשבון לקוח זה.",
    '__max_file_size_available' => "גודל הקובץ המרבי המותר %1",
    '__max_subdom_num_reached_for_cl' => "המערכת הגיעה למגבלה על מספר התת-דומיינים עבור חשבון לקוח זה.",
    '__max_subdom_num_reached_for_dom' => "המערכת הגיעה למגבלה על מספר התת-דומיינים עבור הדומיין.",
    '__max_subdom_num_reached_for_key' => "המערכת הגיעה למגבלה על מספר התת-דומיינים שמתיר מפתח הרישיון.",
    '__max_traffic_limit' => "מגבלת תעבורה",
    '__maximum_excl_ip_num' => "חשבונות דואר אלקטרוני",
    '__mb' => "‎ MB",
    '__mbytes' => "מגה-בתים",
    '__mb_month' => "‎ MB/חודש",
    '__mb_sec' => "MB/שניה",
    '__gb_sec' => "GB/שניה",
    '__tb_sec' => "TB/שניה",
    '__mega' => "M",
    '__minute(s)' => 'דקה/ות',
    '__mls_not_in_key' => "מפתח המוצר שלך אינו תומך בממשק רב-לשוני.",
    '__modification_date' => "תאריך שינוי",
    '__module' => "הרחבה",
    '__month' => "חודש",
    '__month(s)' => "חודש/ים",
    '__month1' => "ינו",
    '__month10' => "אוק",
    '__month11' => "נוב",
    '__month12' => "דצמ",
    '__month2' => "פבר",
    '__month3' => "מרס",
    '__month4' => "אפריל",
    '__month5' => "מאי",
    '__month6' => "יוני",
    '__month7' => "יולי",
    '__month8' => "אוג",
    '__month9' => "ספט'",
    '__monthly' => "חודשי",
    '__months' => "חודשים",
    '__moved_permanently' => 'הועבר לצמיתות',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "שרת",
    'mssql__server' => "שם Microsoft SQL Server",
    'mssql__unable_to_change_server_name_db_exists' => "לא ניתן לשנות את שם השרת: יש בו מסד נתונים אחד לפחות.",
    '__mssql_status' => "מצב Microsoft SQL server",
    '__multiply_login_deny' => "לא ניתן להכניס אותך למערכת. משתמש אחר באותו שם משתמש (%1) כבר נכנס ל-Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "מצב שרת MySQL",
    '__mysql_version' => "גירסת MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "מצב שרת MariaDB",
    '__mariadb_version' => "גירסת MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "מצב שרת Percona",
    '__percona_version' => "גירסת Percona",
    '__name' => "שם",
    '__name_invalid' => "השם אינו חוקי.",
    '__nameserver' => "שרת שמות",
    '__network' => "רשת",
    '__networks' => "רשתות",
    '__no' => "‫לא‬",
    '__no_ip_address_with_properly_type_available' => "לא ניתן לשחזר את הנתונים המגובים מכיוון שאין כתובות IP מתאימות הנדרשות לשחזור.",
    '__no_clients_specified' => "לא צוינו חשבונות לקוחות.",
    '__no_comments' => "אין תגובות.",
    '__nologin' => "אסור",
    '__none' => "ללא",
    '__not_configured' => "תצורה לא מוגדרת",
    '__not_implemented_yet' => "לא יושם עדיין",
    '__not_supported_by_ftp' => "(לא נתמך על ידי שרת FTP)",
    '__notification' => "הודעה",
    '__num_displayed' => "מוצגים %1 מתוך %2",
    '__num_is_invalid' => "המספר אינו חוקי.",
    '__object_not_found' => 'האובייקט לא נמצא: %1',
    '__off' => "לא פעיל",
    '__ok' => "אישור",
    '__old_passwd' => "סיסמה %1 ישנה",
    '__on' => "פעיל",
    '__others' => "אחרים",
    '__other_ip__will_be_added' => 'כתובות IP זמינות אחרות (יוספו למאגר ה-IP של הלקוח)',
    '__p' => "P",
    '__passwd' => "סיסמת %1",
    '__passwd_is_invalid' => "סיסמת %1 אינה חוקית.",
    '__path' => "‫‏נתיב‬",
    '__perl_unix_support' => "תמיכה ב-Perl",
    '__perl_win_support' => "תמיכה ב-Perl",
    '__perm_denied' => "ההרשאה נדחתה.",
    '__permissions' => "הרשאות",
    '__personal_name' => "שם רשמי",
    '__pg_admin_not_activated' => "PostgreSQL לא הופעל בדף ניהול השרת.",
    '__pg_not_inst' => "PostgreSQL לא הותקן.",
    '__pg_not_run_or_inst' => "PostgreSQL לא הותקן או שאינו פועל.",
    '__pg_not_support_in_key' => "מפתח הרישיון אינו תומך ב-PostgreSQL.",
    '__phone' => "טלפון",
    '__phosting' => "אחסון אתרים פיזי",
    '__php_support' => "תמיכה ב-PHP",
    '__php_run_as_isapi' => "הפעל כהרחבת ISAPI",
    '__php_safe_mode' => "'safe_mode' של PHP מופעל",
    '__php_version' => "גירסת PHP",
    '__physical' => "אחסון אתרים פיזי",
    '__plesk_stat_pdir' => "הגן על הספריה '‎/plesk-stat/webstat/‎'",
    '__plesk_stat_dir_name' => "נתונים סטטיסטיים של דומיין",
    '__plesk_stat_protect' => "‫‫הגן על הגישה לסטטיסטיקת האינטרנט באמצעות שם המשתמש והסיסמה ל-FTP של המשתמש‬‬",
    '__plesk_stat_protect_install' => "נגיש דרך הספריה המוגנת בסיסמה '‎/plesk-stat/webstat/‎'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "מצב שרת POP3",
    '__popen_error' => "אירעה שגיאה במהלך קריאה לפונקציה popen.",
    '__port' => 'יציאה',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "מצב PostgreSQL",
    '__preferences' => "‫הגדרות‬",
    '__account_preferences' => "הגדרות חשבון",
    '__interface_preferences_general' => 'כללי',
    '__interface_preferences_default' => 'העדפות ברירת מחדל של ממשק',
    '__interface_preferences_admin' => "העדפות ממשק של מנהל מערכת",
    '__interface_template' => 'תבנית התאמה אישית של ממשק',
    '__interface_preferences' => "העדפות ממשק",
    '__proceed?' => "האם ברצונך להמשיך?",
    '__provider_contact_name' => "שם איש קשר של בעלים",
    '__python_unix_support' => "תמיכה ב-Python",
    '__python_win_support' => "תמיכה ב-Python",
    '__quota' => "מיכסה",
    '__r' => "R",
    '__reconfigure' => "קבע מחדש תצורה",
    '__record_type' => "סוג רשומה",
    '__release' => "מהדורה",
    '__remote_db_not_supported_by_key' => 'אחסון מסד נתונים מרוחק אינו נתמך על ידי מפתח הרישיון שלך.',
    '__remove_protection' => 'הסרת הגנה',
    '__report' => "דוח",
    '__report_size_na' => "השירות אינו זמין",
    '__reports_list' => "דוחות",
    '__requested' => "נדרש",
    '__required_fields' => "שדות חובה",
    '__resp_name_invalid' => "שם המענה האוטומטי אינו חוקי. השתמש אך ורק בסימנים אלפאנומריים, נקודות, מקף תחתון ותווים לבנים.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "שם השרת אינו חוקי.",
    '__screenshots' => 'צילומי מסך',
    '__script_warning' => "בהסרת יכולת ה-Scripting מדומיין זה, כל קובצי ה-Script המושפעים יוצגו בטקסט פשוט כשהדפדפן יקרא להם. מומלץ למנהל המערכת להסיר את כל קובצי ה-Script התלויים מהדומיין הנתון.",
    '__sec' => "שניות",
    '__second(s)' => "שנייה/ות",
    '__see_list_of_logged_in' => "ראה את רשימת המשתמשים שמחוברים כרגע למערכת.",
    '__select_certs_to_remove' => "בחר אישורים להסרה.",
    '__select_files_to_remove' => "בחר קבצים שיוסרו.",
    '__select_ip' => "הקצה כתובת IP",
    '__select_ip_to_remove' => "בחר כתובת IP להסרה.",
    '__select_domain_template' => "השתמש בהגדרות תבניות דומיינים",
    '__select_templates_to_remove' => "בחר תבניות להסרה.",
    '__server' => "שרת",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "שרת מסד נתוני MariaDB/MySQL",
    '__service_description__mysql' => "שרת מסד נתוני MariaDB/MySQL",
    '__service_title__web' => "שרת אינטרנט",
    '__service_description__web' => "שרת אינטרנט",
    '__service_title__smtp' => "שרת SMTP",
    '__service_description__smtp' => "שרת SMTP",
    '__service_title__mail' => "שרת IMAP/POP3",
    '__service_description__mail' => "שרת IMAP/POP3",
    '__service_title__dns' => "שרת DNS",
    '__service_description__dns' => "שרת DNS",
    '__service_title__postgresq' => "שרת מסד נתוני PostgreSQL",
    '__service_description__postgresq' => "שרת מסד נתוני PostgreSQL",
    '__service_title__spamassassin' => "שירות סינון הודעות זבל SpamAssassin",
    '__service_description__spamassassin' => "שירות סינון הודעות זבל SpamAssassin",
    '__all_services' => "כל השירותים",
    '__sessions' => "הפעלות",
    'sessions__feature_ftp_session_manager_not_supported' => "תכונת הפעלות FTP אינה נתמכת על ידי שרת ה-FTP הנוכחי",
    '__sessions_list' => "הפעלות",
    '__set' => "הפעלה",
    '__shared' => "משותף",
    '__shell_access_warning' => "התרת גישת מעטפת למערכת מסוכן ביותר לאבטחת המערכת. הרשה גישה אל המערכת רק אם אתה מבין בבירור את מעשיך, ורק למשתמשים מהימנים. האם אתה באמת רוצה לאפשר גישה?",
    '__siteapp_not_support_in_key' => "יישומי אינטרנט אינם נתמכים על ידי מפתח הרישיון",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'התצורה של יישום אינטרנט זה שונתה באופן ידני. על מנת להגן על השינויים הידניים, קביעה מחדש של תצורה באמצעות Plesk הפכה ללא זמינה.',
    '__site_management' => "‫פרסום באינטרנט‬", // indirect
    '__size' => "גודל",
    '__skins' => 'מעטפות',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "מצב שרת SMTP",
    '__some_fields_are_empty_or_invalid' => "חלק מהשדות ריקים או מכילים ערך לא מתאים.",
    '__no_email_addresses_selected' => 'לא נבחרו כתובות אימייל.',
    '__unable_to_set_parameters' => "לא ניתן להגדיר את הפרמטרים של הרכיב.",
    '__spamassassin' => "מסנן הודעות זבל",
    '__spamassassin_status' => "מצב SpamAssassin",
    '__spamd_status' => 'מצב מסנן הודעות זבל',
    '__splited_backup' => "(גיבוי לאמצעי אחסון מרובים)",
    '__split_backup_file' => "צור גיבוי באמצעי אחסון מרובים",
    '__split_backup_size' => "גודל אמצעי אחסון",
    '__split_backup_less_than_500' => "לא נתמכים גודלי אמצעי אחסון הנמוכים מ-500 מגה-בתים",
    '__ssi' => "SSI",
    '__ssi_support' => "תמיכה ב-SSI",
    '__ssi_with_html' => "השתמש ב-SSI עבור קובצי ‎*.htm‏, ‎*.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "תמיכה ב-SSL/TLS",
    '__same_ssl' => "השתמש בספריה יחידה לאחסון תוכן SSL/TLS ולא-SSL/TLS",
    '__same_ssl_cu' => "תוכן SSL/TLS/לא- SSL/TLS משותף",
    '__state' => "מדינה/מחוז",

    '__status__Active' => 'פעיל',
    '__status__active' => 'פעיל',
    '__status__Passive' => 'כבוי',
    '__status__passive' => 'כבוי',
    '__status__off' => 'כבוי',
    '__status__with_parent' => 'כבוי',
    '__status__backup_restore' => 'מושעה באופן זמני עקב גיבוי או שחזור',
    '__status__admin' => 'מושעה על ידי מנהל שרת',
    '__status__resseler' => 'מושעה על ידי משווק',
    '__status__client' => 'מושעה על ידי לקוח',
    '__status__unknown' => 'המצב אינו ידוע',

    '__status_of' => "מצב %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "שרת Stunnel", // indirect
    '__subdomain' => "תת-דומיין",
    '__subdomain_name' => "שם תת-דומיין",
    '__subdomain_name_in_ASCII_form' => "שם תת-דומיין בתבנית ASCII",
    '__subdomains' => "תת-דומיינים",
    '__domainaliases' => "כינויי דומיינים",
    '__subdomains_list' => "תת-דומיינים",
    '__subdomains_not_support_in_key' => "פעולות תת-דומיינים אינן נתמכות על ידי מפתח הרישיון",
    '__sys_user_type' => "משתמש FTP",
    '__sys_user_type_main' => "השתמש בחשבון משתמש FTP של הדומיין הראשי",
    '__sys_user_type_native' => "צור חשבון משתמש FTP נפרד עבור תת-דומיין זה",
    '__target_domain' => "דומיין יעד",
    '__template' => "תבנית",
    '__template_not_accepted' => "לא ניתן לקבל את התבנית: המערכת חורגת מהמגבלות הבאות.",
    '__templates' => "תבניות",
    '__templates_list' => "תבניות",
    '__tera' => "T",
    '__title' => "כותר",
    '__total' => "%1 כולל",
    '__total_size' => "גודל כולל",
    '__total_used' => "סך הכול בשימוש",
    '__traffic' => "תעבורה",
    '__traffic_by_client' => "תעבורה לפי לקוח",
    '__traffic_by_domain' => "תעבורה לפי דומיין",
    '__traffic_by_service' => "תעבורה לפי שירות",
    '__traffic_history' => "היסטוריית תעבורה",
    '__unable_change_locale' => "לא ניתן לשנות את שפת הממשק: %1",
    '__unable_create_new_dom' => "לא ניתן ליצור דומיין: %1",
    '__unable_define_dom_name' => "לא ניתן להגדיר שם דומיין: %1",
    '__unable_define_necessary_properties' => "לא ניתן להגדיר את כל המאפיינים הנדרשים.",
    '__unable_define_properties' => "לא ניתן להגדיר מאפיינים: %1",
    '__unable_exec_util' => "לא ניתן להפעיל כלי עזר: %1",
    '__unable_get_dns_a_recs' => "לא ניתן לאחזר כתובות IP לרשומות A DNS עבור חשבון אחסון אתרים זה: %1",
    '__unable_get_mbox_quota' => "לא ניתן לאחזר את המידע על מגבלת גודל תיבת הדואר.",
    '__unable_redirect_to_myself' => "לא ניתן להעביר לאותו החשבון.",
    '__unable_redirect_to_my_alias' => "לא ניתן להעביר דואר לכינוי דואר.",
    '__default_domain_redirect_to_myself' => "לא ניתן להגדיר דומיין כברירת מחדל עבור כתובות IP: זוהה ניתוב מחדש עצמי.",
    '__unable_remove_client' => "לא ניתן להסיר את הלקוח: %1",
    '__unable_set_up_mbox_quota' => "לא ניתן להגדיר את מגבלת גודל תיבת הדואר עבור הדומיין: %1",
    '__unable_setup_pass' => "לא ניתן להגדיר סיסמה: %1",
    '__unable_to_create_new_account' => "לא ניתן ליצור חשבון: %1",
    '__unable_to_define_db_size' => "לא ניתן להגדיר את גודל מסד הנתונים.",
    '__unable_to_enable_short_names' => "לא ניתן להתיר את השימוש בשמות קצרים של חשבונות דוא\"ל עבור חשבונות POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "לא ניתן להביא את הנתונים שנשלחו: %1",
    '__unable_to_open_file' => "לא ניתן לפתוח את הקובץ %1: %2",
    '__unable_to_update_subdomain' => "לא ניתן לערוך שינויים בתת-דומיין: %1",
    '__unable_update_cl_data' => "לא ניתן לשמור שינויים בחשבון המשתמש: %1",
    '__unable_update_db_params' => "לא ניתן לעדכן פרמטרים של מסד נתונים: %1",
    '__unable_update_dom_data' => "לא ניתן לעדכן נתוני דומיין: %1",
    '__undefined' => "לא מוגדר",
    '__uninstall' => "הסרת התקנה",
    '__unknown_error' => "שגיאה לא מוכרת",
    '__unlimited_lower' => "ללא הגבלה",
    '__unset' => "‫כיבוי‬",
    '__update' => "עדכון",
    '__uploaded_file_is_invalid' => "הקובץ שהועלה אינו חוקי: %1",
    '__url' => "‫כתובת URL‬",
    '__usage' => "ניצול דיסק",
    '__user_already_logged' => "משתמש אחר באותו שם משתמש (%1) כבר נכנס ל-Plesk.",
    '__version' => "גירסה",
    '__aps_license' => "מפתח רישיון",
    '__vh_type' => "סוג אחסון אתרים וירטואלי",
    '__vhosts_apache_status' => "מצב שרת אינטרנט",
    '__wrong_charset_conversion' => 'ערכת תווים שגויה, המרה מ-"%1" ל-"%2" אינה מותרת',
    '__warning_' => "אזהרה!",
    '__warning_excl_ip_num' => "כתובת IP ייעודית",
    '__warning_expiration' => "תאריך תפוגה",
    '__web_scripting' => "Scripting באינטרנט", // indirect
    '__web_serv' => "שרת אינטרנט", // indirect
    '__web_statistic' => "סטטיסטיקת אינטרנט", // indirect
    '__webmail' => "דואר אינטרנט", // +indirect
    '__webstat_not_installed' => "Webalizer אינו מותקן בשרת. פנה לספק השירות לקבלת סיוע בהתקנת Webalizer.",
    '__webstat_support' => "סטטיסטיקת אינטרנט",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "במעבר בין תוכנה סטטיסטית אחת לאחרת, כל הדוחות שנוצרו על ידי התוכנה הראשונה יימחקו, וייווצרו דוחות חדשים בהתאם למידע שייקרא מקובצי יומן הרישום השמורים בשרת. המשמעות היא שאם קבעת את תצורת המערכת (ב'דומיינים'> 'שם דומיין'> 'מנהל יומן רישום'> 'סבב יומן רישום') כך שיישמרו קובצי יומן רישום מהחודש האחרון בלבד, סטטיסטיקת אינטרנט תהיה זמינה רק לחודש האחרון. האם ברצונך לעבור לחבילת נתונים סטטיסטיים אחרת?",
    '__webstat_perm_denied' => 'אין לך הרשאה לניהול סטטיסטיקת אינטרנט.',
    '__webuser' => "משתמש אינטרנט",
    '__sysusers_list' => "משתמשי מערכת",
    '__sysuser' => "משתמש מערכת",
    '__weekly' => "שבועי",
    '__whats_new_in_version' => "מה חדש ב-Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "פעולה זו זמינה רק עבור דומיינים עם אחסון אתרים.",
    '__wrong_hosting_type__none' => 'לא נקבעה תצורת אחסון אתרי אינטרנט בדומיין %1.',
    '__wrong_hosting_type__std_fwd' => 'נקבעה תצורת העברה סטנדרטית בדומיין %1. פעולה זו זמינה רק עבור דומיינים עם אחסון אתרים.',
    '__wrong_hosting_type__frm_fwd' => 'נקבעה תצורת העברה בתוך מסגרת בדומיין %1. פעולה זו זמינה רק עבור דומיינים עם אחסון אתרים.',
    '__wu' => "משתמשי אינטרנט",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "הקידומת WWW שונתה. הקפד לשנות את אישור ה-SSL/TLS בהתאם.",
    '__year' => "שנה",
    '__year(s)' => "שנה/שנים",
    '__yes' => "‫כן‬",
    '__you' => "אתה",
    '__zip_code' => "מיקוד",
    '__form_normal' => "רגיל",
    '__form_advanced' => "מתקדם",

    'admin_ed__edit_administrator_info' => "‫עריכת פרופיל מנהל מערכת‬",
    'admin_ed__create_default_client' => "ברצוני ליצור חשבון לקוח שיהווה ברירת מחדל.",
    'admin_ed__unable_update' => "לא ניתן לעדכן פרטי מנהל מערכת: %1",

    'auth__update_admin_info' => "הזן את הפרטים של מנהל המערכת. מידע זה נדרש כדי להפעיל את %1.",
    'auth__you_not_have_perm' => "אין לך הרשאות לניהול דומיין זה.",
    'auth__key_expired_admin' => 'פג תוקף רישיון Plesk שלך.כדי להמשיך להשתמש ב-Plesk, חדש את הרישיון או קנה אחד חדש.',
    'auth__key_expired_admin_restricted' => 'פג תוקף רישיון Plesk שלך. כדי להמשיך להשתמש ב-Plesk, פנה אל ספק השירות שלך.',
    'auth__key_expired_client' => 'פג תוקף רישיון Plesk. פנה לספק אחסון האתרים שלך.',
    'autoinstaller__not_installed' => 'רכיב המתקין האוטומטי אינו מותקן.',
    'autoinstaller__release_action' => 'פעולות זמינות',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'שדרוג לגירסת Plesk החדשה',
    'autoinstaller__release_action_update' => 'עדכון או הוספת רכיבים חדשים',
    'autoinstaller__release_action_up2date' => 'יש לך גירסה עדכנית',
    'autoinstaller__component_action' => 'מצב',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'לא מותקן',
    'autoinstaller__component_action_update' => 'זמינים עדכונים',
    'autoinstaller__component_action_upgrade' => 'ישנו עדכון זמין',
    'autoinstaller__component_action_up2date' => 'יש לך גירסה עדכנית',
    'autoinstaller__component_action_error' => 'עדכונים אינם זמינים',
    'autoinstaller__component_serverbuildtime' => 'המהדורה העדכנית ביותר',
    'autoinstaller__component_localbuildtime' => 'המהדורה שלך',
    'autoinstaller__component_installed_version' => 'הגירסה שלך',
    'autoinstaller__component_available_version' => 'הגירסה העדכנית ביותר',
    'autoinstaller__component' => 'רכיב',
    'autoinstaller__components' => 'רכיבים',
    'autoinstaller__components_title' => '%1 רכיבים',
    'autoinstaller__component_dependency_note' => 'נדרש להתקנת הרכיבים שבחרת',
    'autoinstaller__install_confirm' => 'כן, ברצוני לעדכן רכיבים אלה',
    'autoinstaller__install_confirm_request' => 'בחר בתיבת הסימון כדי לאשר',
    'autoinstaller__install_title' => 'אישור התקנת הרכיבים שנבחרו',
    'autoinstaller__key_update_confirm' => 'אשר דילוג על עדכון מפתח והתקנת מפתח ברירת המחדל',
    'autoinstaller__key_update_confirm_request' => 'בחר את תיבת הסימון כדי לאשר.',
    'autoinstaller__key_update_failed' => '<p>Plesk אינו יכול לעדכן את רישיון המוצר שלך.</p><p>%1</p><p>המשך העדכון ללא רישיון מוצר מתאים יביא להתקנה של רישיון ברירת המחדל שיש לו תפקוד מוגבל. מומלץ למנהלי מערכת להשיג תחילה את מפתח הרישיון המתאים לפני שימשיכו בשדרוג המוצר.</p>',
    'autoinstaller__email' => 'שלח הודעה אל',
    'autoinstaller__email_admin' => "דוא\"ל של מנהל המערכת",
    'autoinstaller__email_email' => 'כתובת דוא"ל מותאמת אישית...',
    'autoinstaller__release' => 'שם מהדורה',
    'autoinstaller__releases' => 'מהדורות זמינות',
    'autoinstaller__releases_title' => 'מעדכן Plesk',
    'autoinstaller__select_components_to_install' => 'בחר את הרכיבים להתקנה',
    'autoinstaller__status_error' => 'שגיאה: %1',
    'autoinstaller__status_install_error' => 'לא ניתן היה להתחיל בהתקנה: %1',
    'autoinstaller__status_install_busy' => 'לא ניתן היה להתחיל בהתקנה: פרוצדורת התקנה אחרת פועלת כרגע.',
    'autoinstaller__status_install_ok' => 'ההתקנה החלה. תקבל הודעה בדואר אלקטרוני לגבי התקדמות ההתקנה (%1).',
    'autoinstaller__status_query_busy' => 'ההתקנה מתבצעת.',
    'autoinstaller__status_query_error' => 'לא ניתן לאחזר מצב התקנה: %1',
    'autoinstaller__status_unknown' => 'לא ניתן לאחזר מצב מתקין אוטומטי.',
    'autoinstaller__status_busy' => 'המתקין האוטומטי אינו פנוי, נא להמתין.',
    'autoinstaller__configure_title' => 'הגדרות מעדכן',
    'autoinstaller__preferences_legend' => '‫הגדרות‬',
    'autoinstaller__target' => 'ספרית הורדה זמנית',
    'autoinstaller__target_invalid' => "ציין נתיב מוחלט",
    'autoinstaller__check_updates' => 'חפש עדכונים כאשר מנהל המערכת נכנס ל-Plesk',
    'autoinstaller__check_updates_warning' => 'חדש <a href="%1">זמינים עדכונים</a> עבור %2',
    'autoinstaller__source_type' => 'סוג מקור',
    'autoinstaller__source' => 'כתובת URL למקור',
    'autoinstaller_source__preferences_legend' => '‫הגדרות‬',
    'autoinstaller_source__type' => 'סוג מקור',
    'autoinstaller_source__url_invalid' => 'מקור לא חוקי',
    'autoinstaller_source__url_invalid_network' => 'כתובת URL לא חוקית למקור (דוגמה: http://source, ftp://source)',
    'autoinstaller_source__url' => 'כתובת URL למקור',
    'autoinstaller__source_invalid_network' => 'ציינת כתובת רשת לא חוקית',
    'backup__repository' => 'מיקום אחסון קובצי גיבוי',
    'backup__error_notify_email' => 'אם מתרחשות שגיאות במהלך הגבוי, יש לשלוח הודעה לדוא"ל',
    'backup__dump_info' => "פרטי גיבוי",
    'backup__dump_file_name_not_defined' => "לא צוין שם קובץ גיבוי",
    'backup__local_file' => 'קובץ גיבוי מקומי',
    'backup__domain_ftp' => 'שרת FTP מרוחק',
    'backup__wrong_path' => "נתיב שגוי לאחסון קובצי הגיבוי: אין להשתמש ברצף התווים ../../",
    'backup__unable_to_connect_to_ftp_server' => "לא ניתן להתחבר לשרת FTP: %1",
    'backup__unable_to_read_file' => 'לא ניתן לקרוא את קובץ הגיבוי.',
    'backup__backup_task_does_not_exist' => "לא קיימת משימת גיבוי, עליך ליצור אותה לפני ההפעלה.",
    'backup__restore_params' => "פרמטרים של שחזור",
    'backup__confirmation' => "אזהרה: הדומיין לא יהיה זמין במהלך הגיבוי/שחזור.",
    'backup__backup_method' => 'פעולת שירות של גיבוי',
    'backup__dumpfile_name' => "‫שם קובץ גיבוי‬",
    'backup__dumpfile_name_is_invalid' => "שם קובץ הגיבוי אינו חוקי: השתמש בסימנים אלפאנומריים, מקש, נקודה ומקף תחתון, אין להשתמש בשמות כמו description.*‎ כשם לקובץ גיבוי.",
    'backup__email_required' => "כתובת הדואר האלקטרוני שלך נדרשת לדווח לך על התקדמות גיבוי ושחזור. ציין את הדוא\"ל שלך בפרטי החשבון.",
    'backup__error_during_backup' => "לא ניתן ליצור את קובץ הגיבוי: %1",
    'backup__input_email_warning' => "עליך לציין דוא\"ל לקבלת הודעה או לנקות את תיבת הסימון.",
    'backup__make_download' => "אין לאחסן את קובץ הגיבוי באחסון אלא להוריד אותו בלבד",
    'backup__make_dump' => 'צור קובץ גיבוי ואחסן אותו באחסון מקומי',
    'backup__makedump_to_ftp' => 'צור קובץ גיבוי ואחסן אותו בשרת FTP מרוחק',
    'backup__restore_ip' => "כתובות IP לשחזור",
    'backup__select_dumpfile' => "בחר קובץ גיבוי.",
    'backup__time' => "זמן לגיבוי",
    'backup__day' => 'יום גיבוי',
    'backup__view_dump_info' => "הצג את פרטי הגיבוי עבור הדומיין %1",
    'backup__wrong_domain_name' => "קובץ הגיבוי מכיל את הנתונים של הדומיין %1, ולכן לא ניתן לשחזר אותו בדומיין %2",
    'backup__incorrect_ftp_user_or_passwd' => "משתמש או סיסמת FTP שגויים. תקן מאפייני חשבון FTP",
    'backup__access_denied' => "הגישה נדחתה. תקן מאפייני חשבון FTP",
    'backup__restore_from' => "שחזר את %1",
    'backup__domain_session_failed' => 'הדומיין %1 לא גובה',
    'backup__client_session_failed' => 'הלקוח %1 לא גובה',
    'backup__domain_session_restore_failed' => 'הדומיין %1 לא שוחזר',
    'backup__client_session_restore_failed' => 'חשבון הלקוח %1 לא שוחזר',
    'backup__domain_session_complete' => 'הדומיין %1 גובה',
    'backup__domain_session_backup' => 'גיבוי הדומיין %1',
    'backup__client_session_backup' => 'גיבוי של הלקוח %1',
    'backup__domain_stop_title' => 'ביטול גיבוי של הדומיין %1',
    'backup__client_stop_title' => 'ביטול גיבוי של חשבון הלקוח %1',
    'backup__domain_restore_stop_title' => 'ביטול השחזור של הדומיין %1',
    'backup__client_restore_stop_title' => 'ביטול השחזור של חשבון הלקוח %1',
    'backup__domain_session_backup_stop' => 'אתה עומד לבטל את תהליך הגיבוי הפעיל. לא ייווצר קובץ גיבוי.',
    'backup__backup_stop_confirm' => 'כן, ברצוני לעצור את תהליך הגיבוי',
    'backup__restore_stop_confirm' => 'כן, ברצוני לעצור את תהליך השחזור',
    'backup__domain_session_restore' => 'שחזור הדומיין %1',
    'backup__domain_session_restore_stop' => 'אתה עומד לבטל את תהליך השחזור הפעיל.',
    'backup__domain_backup_file_info' => 'פרטי קובץ גיבוי של דומיין',
    'backup__domain_backup_file_list' => 'קובצי גיבוי קיימים',
    'backup__domain_backup_progress' => 'התקדמות של גיבוי אתר האינטרנט %1',
    'backup__domain_restore_progress' => 'התקדמות של שחזור אתר האינטרנט %1',
    'backup__domain_backup_progress_elapsed_time' => 'זמן שחלף: %1',
    'backup__domain_restore_progress_elapsed_time' => 'זמן שחלף: %1',
    'backup__domain_restore_session_complete' => 'הדומיין %1 משוחזר.',
    'backup__domain_restore_session_complete_message' => 'הדומיין %1 שוחזר.',
    'backup__domain_backup_file_delete' => 'קובצי הגיבוי הבאים יוסרו:',
    'backup__domain_backup_file_for_remove' => 'בחר קובצי גיבוי שברצונך להסיר',
    'backup__backup_overwrite_file_confirm' => 'אישור החלפה',
    'backup__backup_overwrite_file_confirm_text' => 'כבר קיים קובץ גיבוי בשם "%1". האם ברצונך להחליף אותו?',
    'backup__backup_confirm_overwrite' => 'אשר החלפת קובץ',
    'backup__backup_overwrite_legeng' => 'החלף',
    'backup__backup_not_contain_domain' => 'קובץ הגיבוי אינו מכיל מידע על הדומיין %1',
    'backup__backup_not_contain_client' => 'קובץ הגיבוי אינו מכיל מידע על חשבון הלקוח %1',
    'backup__backup_client_info' => "גבה את ההגדרות ואת פרטי החשבון של הלקוח",
    'backup__client_backup_progress' => 'התקדמות הגיבוי של חשבון הלקוח %1',
    'backup__client_session_complete' => 'חשבון הלקוח %1 מגובה',
    'backup__client_backup_file_info' => 'פרטי קובץ גיבוי של לקוח',
    'backup__restore_client_info' => "שחזר את פרטי ההגדרות והחשבון של הלקוח",
    'backup__client_session_restore' => 'משחזר חשבון לקוח %1',
    'backup__client_db_server_map' => 'מיפוי שרתי מסדי נתונים',
    'backup__domain_db_server_map' => 'מיפוי שרתי מסדי נתונים',
    'backup__client_restore_session_complete_message' => 'חשבון הלקוח %1 שוחזר.',
    'backup__client_restore_session_complete' => 'חשבון הלקוח %1 שוחזר.',
    'backup__restore_select_some' => 'בחר אובייקטים שברצונך לשחזר.',
    'backup__client_restore_progress' => 'התקדמות השחזור עבור חשבון הלקוח %1',
    'backup__new_backup' => 'יצירת גיבוי חדש',
    'backup__done' => 'בוצע:',
    'backup__done_domains' => '%1 דומיינים מתוך %2',
    'backup__done_clients' => '%1 לקוחות מתוך %2',
    'backup__remaining' => 'נותר:',
    'backup__remaining_domains' => '%1 דומיינים',
    'backup__remaining_clients' => '%1 לקוחות',
    'backup__overall_backup_progress' => 'התקדמות גיבוי כוללת',
    'backup__comment_n_a' => 'לא רלוונטי',
    'backup__command_ignore' => 'המערכת מתעלמת מהפקודה "%1"',
    'backup__no_objects' => 'אין אובייקטים לגיבוי',
    'backup__cli_warning_not_enough_ip' => 'אזהרה: אין מספיק כתובות IP כדי לבצע מיפוי IP ברירת מחדל:',
    'backup__local_repository' => "אחסון של Plesk",
    'backup__ftp_repository' => 'אחסון FTP',
    'backup__ftp_login' => 'שם משתמש',
    'backup__ftp_password' => 'סיסמה',
    'backup__ftp_account_settings' => 'הגדרות חשבון FTP',
    'backup__ftp_account_preferences' => 'הגדרות חשבון FTP',
    'backup__repository_not_exist' => 'הספריה אינה קיימת',
    'backup__repository_not_readable' => 'הספריה שצוינה אינה ניתנת לקריאה',
    'backup__ftp_repository_not_configure' => 'על מנת להשתמש באחסון גיבוי FTP, <a href="%1">יש לציין תחילה את חשבון ה-FTP</a>.',
    'backup__ftp_repository_list_not_configure' => 'לא צוינו הגדרות חשבון',
    'backup__repository_list_unable_listing' => 'לא ניתן לאחזר רשימת קבצים',
    'backup__ftp_repository_unable_listing' => 'לא ניתן לאחזר את הרישום של הספריה "%1":',
    'backup__repository_legend' => 'אחסון קובצי גיבוי',
    'backup__store_in_repository' => 'אחסן קבצים ב-',
    'backup__local_repository_lable' => 'אחסון מקומי',
    'backup__ftp_repository_lable' => 'אחסון FTP',
    'backup__ftp_repository_not_configure_hint' => '(לא מצוינות הגדרות חשבון)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(חשבון FTP לא צוין או שאינו נתמך)',
    'backup__other_user_process_modified' => 'משתמש אחר עצר את תהליך הגיבוי או ההעברה.',
    'backup__another_user_exist' => 'הפעולה המתבצעת אותחלה על ידי משתמש Plesk אחר. משתמש זה עדיין מחובר ל-Plesk.',
    'backup__ftp_repository_wait' => 'המתן בזמן אחזור המידע על אחסון FTP',
    'backup__ftp_write_test_failed' => 'נכשלה כתיבת נתוני הבדיקה לחשבון ה-FTP‏ %1:',
    'backup__ftp_storage' => 'אחסון FTP(S)',
    'bt_upload_to_repository' => 'העלאת קבצים לאחסון מקומי',
    'bt_new_restore' => "‫שיחזור‬",
    'bt_backup_schedule' => "גיבוי לוח זמנים",
    'backup_exist_backups' => "קובצי גיבוי קיימים",
    'backup_dialog__page_title' => "יצירת קובץ גיבוי",
    'backup_dialog__please_wait' => "תהליך הגיבוי עומד להתחיל. פעולה זו עשויה להימשך זמן מה. המתן...",
    'backup_conf__page_title' => 'תצורת גיבוי',
    'bt_accept' => "קבל",
    'bt_access' => "גישה",
    'bt_action_log' => "יומן פעולות",
    'bt_add' => "הוסף",
    'bt_add_client' => "הקצאה למשתמשים",
    'bt_database_server_add' => 'הוספת שרת מסד נתונים',
    'bt_add_services' => "הוספת שירותים",
    'bt_anonftp_stats' => "נתונים סטטיסטיים של FTP אנונימי",
    'bt_anonymous_ftp' => "FTP אנונימי",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "צרף קובץ",
    'bt_autoinstaller' => 'מעדכן',
    'bt_auto-updates' => 'מעדכן',
    'bt_back' => "<< הקודם",
    'bt_backup' => "גיבוי",
    'bt_backup_configure' => "הגדרות גיבוי",
    'bt_buy_certs' => "קניית אישורים",
    'bt_card' => "כרטיס",
    'bt_cert' => "אישור",
    'bt_certificates' => "אישורים",
    'bt_change_passwd' => "שינוי סיסמה",
    'bt_clear' => "נקה",
    'bt_client_templates' => "תבניות לקוח",
    'bt_clients' => "לקוחות",
    'bt_codepage_change' => 'שינוי קידוד',
    'bt_comp_info' => "ניהול רכיבים",
    'bt_configure_maillists' => "הגדרת Mailman",
    'bt_configure' => 'קביעת תצורה',
    'bt_copy' => "העתקה",
    'bt_copy_move' => "העתקה/העברה",
    'bt_create' => "יצירה",
    'bt_create_account' => "יצירת חשבון",
    'bt_create_dir' => "הוספת ספריה",
    'bt_create_file' => "הוספת קובץ",
    'bt_count_size' => "חישוב גודל",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "מתזמן משימות",
    'bt_custom_button_new' => "הוספת לחצן",
    'bt_custom_buttons' => "לחצנים מותאמים אישית",
    'bt_customize' => "התאמה אישית",
    'bt_databases' => "מסדי נתונים",
    'bt_database_servers' => 'שרתי מסד נתונים',
    'bt_sqlservers' => "שרתי מסד נתונים",
    'bt_db_usr_new' => "הוספת משתמש מסד נתונים",
    'bt_db_new' => "הוספת מסד נתונים",
    'bt_db_phpmyadmin' => "מנהל מערכת MySQL",
    'bt_dbuser_default' => "הגדרה כברירת מחדל עבור ניהול אתרים של מסד נתונים",
    'bt_decline' => "דחה",
    'bt_default' => "ברירת מחדל",
    'bt_defaultcomponents' => "שירותים של צד שלישי",
    'bt_defaults' => "ברירות מחדל",
    'bt_delete' => "מחיקה",
    'bt_directories' => "ספריות מוגנות",
    'bt_disable' => "כיבוי",
    'bt_dns_zone_sync' => 'החלת שינויים בתבניות DNS',
    'bt_dnsrecord_add' => 'הוספת רשומה',
    'bt_do_backup' => "גיבוי",
    'bt_do_restore' => "‫שיחזור‬",
    'bt_do_upload' => "העלאה",
    'bt_domain_aliases' => "כינויי דומיינים",
    'bt_domain_templates' => "תבניות דומיינים",
    'bt_domain_user' => "מנהל דומיין",
    'bt_domain_user_passwd' => "סיסמה של מנהל דומיין",
    'bt_domains' => "דומיינים",
    'bt_domain_alias_add' => 'הוספת כינוי דומיין',
    'bt_download' => "הורדה",
    'bt_edit' => "עריכה",
    'bt_enable' => "הפעלה",
    'bt_export' => 'ייצוא',
    'bt_extras' => "תוספות",
    'bt_finish' => "סיים",
    'bt_ftp_account' => "מאפייני חשבון FTP",
    'bt_forget_password' => "שכחת סיסמה?",
    'bt_fp_ssl_webadmin' => "ניהול אתרים FP-SSL/TLS",
    'bt_fp_webadmin' => "ניהול אתרים FP",
    'bt_ftp_stats' => "נתוני FTP סטטיסטיים",
    'bt_get_password' => "קבלת סיסמה",
    'bt_global_changes' => "שינוי",
    'bt_help' => "עזרה",
    'bt_hide_aliases' => "הסתר כינויים",
    'bt_hide_toolbar' => 'הסתר סרגל כלים',
    'bt_hide_subdomains' => "הסתרת תת-דומיינים",
    'bt_hide_domainaliases' => "הסתרת כינויי דומיינים",
    'bt_home' => "דף הבית",
    'bt_hosting' => "אירוח",
    'bt_icf' => 'חומת אש',
    'bt_install' => "התקנה",
    'bt_ip_aliasing' => "כתובות IP",
    'bt_ip_add' => "הוספת כתובת IP",
    'bt_ip_pool' => "מאגר IP",
    'bt_key_info' => "פרטי רישיון",
    'bt_key_buyonline_addons' => 'הזמנת הרחבות של Plesk',
    'bt_key_buyonline_upgrades' => 'הזמנת שדרוגים ל-Plesk',
    'bt_key_buyonline_new' => 'הזמנת מפתח חדש',
    'bt_limits' => "מגבלות",
    'bt_locale_add' => 'הוספת אזור',
    'bt_locales' => 'אזורים',
    'bt_log_manager' => "מנהל יומן הרישום",
    'bt_login' => "כניסה",
    'bt_logo' => "‫מיתוג‬",
    'bt_logo_send_link' => "צירוף קובץ",
    'bt_logo_send_logo' => "צירוף לוגו",
    'bt_logout' => "יציאה",
    'bt_logrotation' => "סבב יומן רישום",
    'bt_mail' => "דואר",
    'bt_mail_alias_add' => "הוספת כינוי דואר",
    'bt_mail_aliases' => "כינויי דואר",
    'bt_mail_group_add' => "הוספת חבר",
    'bt_mail_groups' => "קבוצות",
    'bt_mail_name_add' => "הוספת חשבון דוא\"ל",
    'bt_mail_preferences' => "‫הגדרות‬",
    'bt_mail_group' => "קבוצת דואר",
    'bt_mail_mailbox' => "תיבת דואר",
    'bt_mail_redirect' => "רכיב העברה",
    'bt_mail_resp_add' => "הוספת מענה אוטומטי",
    'bt_mail_resp_attach_add' => "הוספת קובץ מצורף",
    'bt_mail_resp_files' => "קבצים מצורפים",
    'bt_mail_responders' => "מענה אוטומטי",
    'bt_mail_spamfilter' => "מסנן הודעות זבל",
    'bt_mail_webmail' => "דואר אינטרנט",
    'bt_maillist_new' => "הוספת רשימת דיוור",
    'bt_maillists' => "רשימות דיוור",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "יצירת גיבוי",
    'bt_manage' => "ניהול",
    'bt_master' => "מסטר",
    'bt_migrate' => 'העברה',
    'bt_modules_add' => 'הוספת הרחבה',
    'bt_modules_manage' => 'ניהול הרחבות',
    'bt_move' => "העברה",
    'bt_new_client' => "הוספת חשבון לקוח",
    'bt_new_domain' => "הוספת דומיין",
    'bt_next' => "הבא>>",
    'bt_next_page' => "הבא",
    'bt_network_add' => "‫הוספת רשת‬",
    'bt_notifications' => "הודעות",
    'bt_off' => "לא פעיל",
    'bt_on' => "פעיל",
    'bt_on_off' => "הפעלה/כיבוי",
    'bt_performance' => 'ביצועים',
    'bt_permissions' => "הרשאות",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "‫הגדרות‬",
    'bt_prev_page' => "הקודם",
    'bt_preview' => 'תצוגה מקדימה של אתר',
    'bt_print' => "הדפסה",
    'bt_reboot' => "אתחול מחדש",
    'bt_reload' => "טעינה מחדש",
    'bt_refresh' => "רענון",
    'bt_register' => "הירשם",
    'bt_remove' => "הסרה",
    'bt_enable_selected' => 'הפעלה',
    'bt_disable_selected' => 'כיבוי',
    'bt_repair_ip' => "תיקון IP",
    'bt_report' => "דוח",
    'bt_report_new' => "הוספת פריסה",
    'bt_reset' => "איפוס",
    'bt_restart_services' => "ניהול שירותים",
    'bt_save' => "‏‏שמור",
    'bt_send_by_email' => "שלח בדוא\"ל",
    'bt_send_file' => "שלח קובץ",
    'bt_send_mail' => "שלח דואר",
    'bt_send_passwd' => "שלח סיסמה",
    'bt_send_text' => "שלח טקסט",
    'bt_server' => "שרת",
    'bt_server_add' => "הוספת שרת",
    'bt_server_preferences' => "הגדרות שרת",
    'bt_servers_list' => "שרתים",
    'bt_sessions' => "הפעלות",
    'bt_set' => "קבע",
    'bt_set_as_default' => "הגדרה כברירת מחדל",
    'bt_setup' => 'הגדרה',
    'bt_show_aliases' => "הצג כינויים",
    'bt_show_subdomains' => "הצגת תת-דומיינים",
    'bt_show_domainaliases' => "הצגת כינויי דומיינים",
    'bt_shutdown' => "כיבוי",
    'bt_site_apppkgs' => "מאגר יישומים",
    'bt_site_apppool' => "מאגר יישומים",
    'bt_application-pool' => "יישומי אינטרנט",
    'bt_site_apps' => "יישומי אינטרנט",
    'bt_site_app_add' => "התקנת יישום",
    'bt_site_builder' => "תמיכה בבונה הנוכחות",
    'bt_skeleton' => 'תבנית מארח וירטואלי',
    'bt_skins' => 'מעטפות',
    'bt_skin_add' => 'הוספת מעטפת',
    'bt_skin_manual' => 'הפניה למעטפות Plesk מותאמות אישית', // not used
    'bt_skin_download' => 'הורדת מעטפת',
    'bt_skin_replace' => 'עדכון מעטפת',
    'bt_skip' => 'דילוג',
    'bt_spamassassin' => "מסנן הודעות זבל",
    'bt_spamassassin_train' => "תרגול",
    'bt_spamfilter' => "מסנן הודעות זבל",
    'bt_start' => "הפעלה",
    'bt_stop' => "עצירה",
    'bt_recycle' => "מיחזור",
    'bt_statistics' => "‫נתונים סטטיסטיים‬",
    'bt_subdomain_new' => "הוספת תת-דומיין",
    'bt_subdomains' => "תת-דומיינים",
    'bt_submit' => "שלח",
    'bt_summary_report' => "דוח סיכום",
    'bt_support' => "תמיכה",
    'bt_switch' => "עבור",
    'bt_system_time' => "זמן מערכת",
    'bt_task_new' => "הוספת משימה",
    'bt_dom_tmpl_add' => 'הוספת תבנית דומיין',
    'bt_cl_tmpl_add' => 'הוספת תבנית לקוח',
    'bt_cron_backup' => 'הגדרות גיבוי מתוזמן',
    'bt_test' => "בדיקת חיבור",
    'bt_text' => "טקסט",
    'bt_touch' => "שינוי חותמת זמן",
    'bt_traffic' => "תעבורה",
    'bt_traffic_history' => "היסטוריית תעבורה",
    'bt_update' => "עדכון",
    'bt_upload' => "העלאה",
    'bt_upload_from_ftp' => "העלאת FTP",
    'bt_virtualdirs' => 'ספריות וירטואליות',
    'bt_virtualdir_new' => 'הוספת ספריה וירטואלית',
    'bt_virtualdir_add' => 'הוספת ספריה וירטואלית',
    'bt_web_app_new' => "התקנת יישום Java",
    'bt_web_stats' => "סטטיסטיקת אינטרנט",
    'bt_web_stats_ssl' => "SSL/TLS של נתוני אינטרנט סטטיסטיים",
    'bt_web_user_add' => "הוספת משתמש אינטרנט",
    'bt_web_users' => "משתמשי אינטרנט",
    'bt_webadmin' => "ניהול אתרים",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "ראה את רשימת השינויים המלאה",
    'cert_add__unable_set_ca_cert' => "לא ניתן להגדיר את אישור ה-CA:‏ %1",
    'cert_add__unable_set_cert' => "לא ניתן להגדיר את האישור:‏ %1",
    'cert_add__unable_set_private_key' => "לא ניתן להגדיר את המפתח הפרטי: %1",
    'certificates_list__certificate_used_as_default' => "אחד מהאישורים שאתה עומד למחוק משמש כאישור ברירת המחדל.",
    'certificates_list__certificates_assigned_on_ip' => "אישור אחד או כמה מוקצים לכתובת ה-IP/דומיינים.",
    'ch_pass__admin_pass' => "‫שינוי סיסמת מנהל המערכת‬",
    'ch_pass__old_pass' => "‫סיסמה ישנה‬",
    'ch_pass__pass_confirm' => "אישור",
    'ch_pass__unable_change_admin_pass' => "לא ניתן לשנות את הסיסמה של מנהל המערכת: %1",
    'check_mail_cycle__aliases' => "זוהה מחזור דואר, הכתובת \"‎%1\" מוכלת בכינוי של חשבון דוא\"ל זה.",
    'check_mail_cycle__autoresponders' => "זוהה מחזור דואר, הכתובת \"‎%1\" מוכלת במענה האוטומטי של חשבון דוא\"ל זה.",
    'check_mail_cycle__mail_groups' => "זוהה מחזור דואר, הכתובת \"‎%1\" מוכלת בקבוצת הדואר של חשבון דוא\"ל זה.",
    'check_mail_cycle__mail_name' => "זוהה מחזור דואר, הכתובת \"‎%1\" חופפת לכתובת של חשבון דוא\"ל זה.",
    'check_mail_cycle__redirect' => "זוהה מחזור דואר, הכתובת \"‎%1\" חופפת לרכיב ההעברה של חשבון דוא\"ל זה.",
    'check_mail_dup__redirect' => "זוהתה כפילות בהעברה, הכתובת \"%1\" חופפת לכתובת ההעברה של חשבון דוא\"ל זה.",
    'check_mail_dup__mail_groups' => "זוהתה כפילות בהעברה, הכתובת \"%1\" מוכלת בקבוצת הדואר של חשבון דוא\"ל זה.",
    'check_maillist_cycle__admin' => "זוהה מחזור דואר, הדוא\"ל \"%1\" של מנהל המערכת חופף לכתובת של רשימת דיוור.",
    'check_maillist_cycle__member' => "זוהה מחזור דואר, הכתובת \"%1\" חופפת לכתובת של רשימת דיוור.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "פרטי החשבון של %1",
    'cl_limits__cl' => "המגבלות של %1 של הלקוח",
    'cl_logo__setup_logo_pref' => "הגדר מאפייני לוגו עבור הלקוח %1",
    'cl_new__enter_new_cl_data' => "הזן את המידע על הלקוח החדש",
    'cl_new__unable_to_sent_notification' => 'חשבון המשתמש נוצר. עם זאת, נכשלה שליחת הודעה ללקוח: %1',
    'cl_perm__all_ip' => "כל כתובות ה-IP הזמינות",
    'cl_perm__all_ip_based_hst_will_be_nb' => "כל חשבונות אחסון האתרים מבוססי ה-IP עבור לקוח יועברו להיות מבוססי שמות.",
    'cl_perm__allow_client_create_domain' => "השדות בהם אתה מנסה לבחור ישימים רק ללקוחות שמורשים ליצור דומיינים.",
    'cl_perm__allow_create_nb_w_ip' => "לקוחות יכולים ליצור אחסון אתרים מבוסס שמות באמצעות %1",
    'cl_perm__allow_creation_ip_based_hosting' => "אפשר יצירה של חשבונות אירוח מבוססי IP",
    'cl_perm__available_ips' => "כתובות IP זמינות",
    'cl_perm__change_limits' => "התאמת מגבלות",
    'cl_perm__cl_disk_space' => "שטח דיסק כולל זמין",
    'cl_perm__cl_expiration' => "תקופת חוקיות של חשבון לקוח",
    'cl_perm__cl_max_box' => "תיבות דואר",
    'cl_perm__cl_max_db' => "מסדי נתונים",
    'cl_perm__cl_max_dom' => "דומיינים",
    'cl_perm__cl_max_maillists' => "רשימות דיוור",
    'cl_perm__cl_max_subdom' => "תת-דומיינים",
    'cl_perm__cl_max_traffic' => "כמות כוללת של תעבורה זמינה",
    'cl_perm__cl_max_wu' => "משתמשי אינטרנט",
    'cl_perm__cl_mbox_quota' => "מגבלת גודל תיבת הדואר עבור חשבון משתמש זה",
    'cl_perm__current_maximum_exp_date' => "ערך המקסימום הנוכחי של תקופת חוקיות של דומיין הוא %1; נדרש: %2.",
    'cl_perm__current_maximum_mailbox_quota' => "המגבלה המוגדרת הנוכחית על כמות שטח דיסק שמוקצה לאחסון תיבות דואר תחת חשבון משתמש זה היא %1; נדרש: %2",
    'cl_perm__current_total_requested' => "הערך הכולל הנוכחי של מגבלות דומיין עבור %1 הוא %2; נדרש: %3.",
    'cl_perm__current_total_requested_dom' => "המספר הנוכחי של %1 שמשתייכים ללקוח זה הוא %2; נדרש: %3.",
    'cl_perm__disk_space' => "כמות מרבית של שטח דיסק",
    'cl_perm__dashboard_stdgui' => 'ממשק משתמש',
    'cl_perm__dashboard' => 'תצוגת דף הבית',
    'cl_perm__stdgui' => 'תצוגה סטנדרטית',
    'cl_perm__manage_dashboard' => 'ניהול דף הבית דף הבית',
    'cl_perm__dashboard_and_stdgui' => 'מותרות תצוגת דף הבית ותצוגה סטנדרטית',
    'cl_perm__dashboard_only' => 'מותרת תצוגת דף הבית בלבד',
    'cl_perm__stdgui_only' => 'מותרת תצוגה סטנדרטית בלבד',
    'cl_perm__edit_cl' => "הרשאות של %1 של לקוח",
    'cl_perm__exp_date_exceeded' => "תקופת החוקיות שאתה מנסה להגדיר חורגת מהמגבלה שצוינה בדומיינים הנפרדים הקשורים ללקוח זה.",
    'cl_perm__invalid_value' => "ערך לא חוקי, מותרות ספרות בלבד.",
    'cl_perm__limit_disk_space' => "%1 הגבל את הכמות הכוללת של שטח דיסק",
    'cl_perm__limit_expiration' => "%1 הגבל את תקופת החוקיות עבור חשבון הלקוח",
    'cl_perm__limit_max_box' => "%1 הגבל את המספר המרבי של תיבות דואר",
    'cl_perm__limit_max_db' => "%1 הגבל את המספר המרבי של מסדי נתונים",
    'cl_perm__limit_max_dom' => "%1 הגבל את המספר המרבי של דומיינים",
    'cl_perm__limit_max_maillists' => "%1 הגבל את המספר המרבי של רשימות דיוור",
    'cl_perm__limit_max_subdom' => "%1 הגבל את המספר המרבי של תת-דומיינים",
    'cl_perm__limit_max_traffic' => "%1 הגבל את הכמות הכוללת של תעבורה",
    'cl_perm__limit_max_wu' => "%1 הגבל את המספר המרבי של משתמשי אינטרנט",
    'cl_perm__limit_mbox_quota' => "%1 הגדר את מיכסת תיבת הדואר",
    'cl_perm__limits_exceeded' => "מגבלה אחת או כמה שאתה מנסה להגדיר כבר חורגת מהמגבלות שהוגדרו בדומיינים הנפרדים המשתייכים ללקוח זה. המגבלה הכוללת עבור הלקוח חייבת להיות גדולה או שווה לסכום הכולל של מגבלות הדומיין המוגדרות עבור חשבון לקוח זה.",
    'cl_perm__mailbox_quota_exceeded' => "המגבלה שאתה מנסה להגדיר על כמות שטח הדיסק המוקצה לתיבות דואר חורגת מהמגבלה המוגדרת בדומיינים הנפרדים הקשורים לחשבון לקוח זה.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "המגבלה שאתה מנסה להגדיר על כמות שטח הדיסק המוקצה לתיבות דואר חורגת מהמגבלה המוטלת ברמת השרת.",
    'cl_perm__make_dumps' => "גבה ושחזר נתונים",

    'cl_perm__max_box' => "מספר מרבי של תיבות דואר",
    'cl_perm__max_db' => "מספר מרבי של מסדי נתונים",
    'cl_perm__max_dom' => "דומיינים",
    'cl_perm__max_maillists' => "מספר מרבי של רשימות דיוור",
    'cl_perm__max_subdom' => "תת-דומיינים",
    'cl_perm__max_traffic' => "כמות מרבית של תעבורה",
    'cl_perm__max_wu' => "מספר מרבי של משתמשי אינטרנט",
    'cl_perm__max_dom_aliases' => "כינויי דומיינים",
    'cl_perm__mbox_quota' => "מיכסת תיבת דואר",
    'cl_perm__not_allow_create_nb_hst' => "לקוח לא יכול ליצור אחסון אתרים מבוסס שמות.",
    'cl_perm__this_ip_used_vrt_hst' => "בכתובת IP זו משתמש אחסון אתרים וירטואלי. כדי למחוק כתובת IP זו, הסר שירות אחסון אתרים או שנה את הסוג שלו למבוסס שמות.",
    'cl_perm__unable_off_ipb_creating' => "ללקוח כבר מוגדר שירות אחסון אתרים מבוסס IP. כדי להשבית תכונה זו עבור הלקוח, נקה את תיבת הסימון \"יצירת דומיין\" או הסר את כל חשבונות אחסון האתרים מבוסס ה-IP.",
    'cl_perm__unable_off_nb_creating' => "ללקוח כבר מוגדר שירות אחסון אתרים מבוסס שמות. כדי לנטרל תכונה זו עבור הלקוח, נקה את תיבת הסימון \"יצירת דומיין\" או הסר את כל חשבונות אחסון האתרים מבוסס השמות.",
    'cl_perm__unable_set_domain_limit' => "לא ניתן להגביל את מספר הדומיינים המרבי: ללקוח כבר יש %1 דומיינים",
    'cl_perm__unable_update_client_limitations' => "לא ניתן לשנות את המגבלות של חשבון הלקוח: %1",
    'cl_pref__edit_cl' => "ההעדפות של הלקוח %1",
    'class_anonftp__create_ftp_domain' => "אין דומיין FTP וירטואלי עבור מזהה דומיין זה (dom_id), נסה ליצור אותו תחילה.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "מגבלת שטח הדיסק שאתה מנסה להגדיר (%1) לא תעלה על מגבלת שטח הדיסק הכולל שמוגדר ברמת הדומיין (%2).",
    'class_anonftp__invalid_input_only_digits' => "צוין ערך לא חוקי, מותרות ספרות בלבד.",
    'class_anonftp__unable_change_ownerships' => "לא ניתן לשנות בעלות או הרשאות עבור קובץ המיכסה: %1",
    'class_anonftp__unable_copy_quota_file' => "לא ניתן להעתיק את קובץ המיכסה: %1",
    'class_anonftp__unable_get_disk_usage' => "לא ניתן לאחזר את המידע על שימוש בדיסק בספריה הנכנסת: %1",
    'class_anonftp__unable_parse_quota_file' => "לא ניתן לפרש את קובץ המיכסה.",
    'class_anonftp__unable_read_quota_file' => "לא ניתן לקרוא את קובץ המיכסה: %1",
    'class_anonftp__unable_update_quota' => "לא ניתן לעדכן את המיכסה: הקבצים בספריה הנכנסת משתמשים ב-%1‎ KBs‏ של שטח דיסק, כמות החורגת מערך המיכסה החדשה.",
    'class_anonftp__unable_write_temp_file' => "לא ניתן לכתוב לקובץ הזמני: %1",
    'class_bsdomain__warn_max_date__' => "תאריך התפוגה הוגדר ל-%1",
    'class_client__client_creation_notification' => "הודעה על יצירת לקוח.",
    'class_client__client_with_contact_name_already_exists' => "כבר קיים לקוח בשם %1.",
    'class_client__disk_space' => "שטח דיסק",
    'class_client__invalid_max_dom' => "ערך לא חוקי של מספר דומיינים, מותרות ספרות בלבד.",
    'class_client__limit_exceed' => "לא ניתן להקצות את כמות ה-%1 המבוקשת, מכיוון שזה יביא לחריגה מההקצאות לחשבון של לקוח %2 (%3). אם ברצונך להקצות משאבים נוספים, עבור אל 'לקוחות'> 'שם לקוח'> 'מגבלות' ושנה את ההקצאות כנדרש. לאחר מכן, חזור אל מסך זה ונסה להתאים שוב את ההקצאות.",
    'class_client__limit_exceed_unlimited' => "אם ברצונך להקצות את הכמות הבלתי מוגבלת של משאבים (%1), עליך לעבור תחילה אל 'לקוחות'> 'שם לקוח'> 'מגבלות', ולאחר מכן בחר בתיבת הסימון 'ללא הגבלה' המתאימה לסוג המשאב הנדרש. לאחר מכן, חזור אל מסך זה ונסה להתאים שוב את ההקצאות.",
    'class_client__max_box' => "תיבות דואר",
    'class_client__max_db' => "מסדי נתונים",
    'class_client__max_maillists' => "רשימות דיוור",
    'class_client__max_subdom' => "תת-דומיינים",
    'class_client__max_traffic' => "תעבורה מרבית",
    'class_client__max_wu' => "משתמשי אינטרנט",
    'class_client__max_dom_aliases' => "כינויי דומיינים",
    'class_client__mbox_quota' => "מיכסת תיבת דואר",
    'class_client__unable_define_cl_status' => "לא ניתן להגדיר את מצב חשבון הלקוח: %1",
    'class_client__unable_define_inactive_dom' => "לא ניתן להגדיר דומיינים לא פעילים: %1.",
    'class_client__unable_del_ip' => "לא ניתן להסיר כתובות IP:‏ %1",
    'class_db__db_name_not_set' => "שם מסד הנתונים אינו מוגדר.",
    'class_db__db_not_exist_for_curr_dom' => "מסד הנתונים אינו קיים עבור דומיין זה.",
    'class_db__invalid_db_or_dom_name' => "מזהה הדומיין או מסד הנתונים אינו חוקי, או ששם מסד הנתונים לא מוגדר.",
    'class_db__invalid_pass' => "הסיסמה אינה חוקית.",
    'class_db__mailgrp_member_exist' => "החבר בקבוצת הדואר כבר קיים.",
    'class_db__access_hosts_notsupport' => 'הגדרת מאחסני גישה אינה נתמכת עבור סוג מסד נתונים זה',
    'class_db__unable_add' => 'לא ניתן להוסיף רשומת מארח גישה: %1',
    'class_db__unable_del' => 'לא ניתן למחוק רשומת מארח גישה: %1',
    'class_db__inc_user_not_exist' => 'משתמש מסד הנתונים "%1" אינו קיים',
    'class_db__inc_access_record_exist' => 'רשומת גישה זו כבר קיימת',
    'class_db__inc_access_record_not_exist' => 'לא קיימת רשימת גישה נתונה',
    'class_db__inc_unable_del_last_record' => 'לא ניתן למחוק את הרשומה האחרונה של מארח הגישה',
    'class_domtmpleditform__dns_master' => "ראשי",
    'class_domtmpleditform__dns_slave' => "משני",
    'class_domtmpleditform__dns_type' => "סוג אזור DNS של דומיין",
    'cmd_dns__a_dns_record_already_exist' => "רשומה זו תתנגש עם הרשומה A עבור האזור.",
    'cmd_dns__domain_last_ns' => 'לא ניתן למחוק את רשומת ה-DNS האחרונה מסוג NS עבור הדומיין.',
    'cmd_dns__canonical_dom_name_is_invalid' => "שם הדומיין הקנוני אינו חוקי.",
    'cmd_dns__cname_dns_record_already_exist' => "רשומה זו תתנגש עם רשומת ה-CNAME עבור האזור.",
    'cmd_dns__cname_in_rr_combination' => 'באזור ה-DNS נמצא שילוב שגוי של רשומות DNS',
    'cmd_dns__cname_coexist_with_data' => 'רשומת אזור DNS‏ CNAME אינה יכולה להתקיים במקביל לרשומות DNS אחרות באותו האזור.',
    'cmd_dns__dns_record_type_is_invalid' => "סוג רשומת ה-DNS אינו חוקי.",
    'cmd_dns__ext_host_is_not_resolved' => "השם הקנוני %1 אינו מפוענח לרשומת A או AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'לא ניתן להוסיף את הרשומה %1 לאזור %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "שם Mail Exchanger אינו חוקי.",
    'cmd_dns__mx_priority_is_invalid' => "עדיפות MX אינה חוקית.",
    'cmd_dns__name_server_is_invalid' => "שרת השמות אינו חוקי.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "ערך מסיכת הרשת צריך להיות 24, 16 או 8.",
    'cmd_dns__this_dns_record_already_exists' => "כבר קיימת רשומת DNS כזו.",
    'cmd_dns__unable_add_record' => "לא ניתן להוסיף רשומת '%1':‏ %2",
    'cmd_dns__unable_add_a_record' => "לא ניתן להוסיף רשומת A:‏ %1",
    'cmd_dns__unable_add_cname_record' => "לא ניתן להוסיף רשומת CNAME:‏ %1",
    'cmd_dns__unable_add_dns_record' => "לא ניתן להוסיף רשומת DNS:‏ %1.",
    'cmd_dns__unable_add_ext_ns_record' => "לא ניתן להוסיף רשומת EXT_NS:‏ %1",
    'cmd_dns__unable_add_ns_record' => "לא ניתן להוסיף רשומת NS:‏ %1",
    'cmd_dns__unable_add_ptr_record' => "לא ניתן להוסיף רשומת PTR:‏ %1",
    'cmd_dns__unable_add_txt_record' => "לא ניתן להוסיף רשומת TXT:‏ %1",
    'cmd_dns__unable_create_dns_zone' => "לא ניתן ליצור את אזור ה-DNS‏ %1",
    'cmd_dns__unable_define_dns_record' => "לא ניתן להגדיר את רשומת ה-DNS‏ %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "לא ניתן לאחזר את מצב אזור ה-DNS‏ המוגדר כברירת מחדל: %1",
    'cmd_dns__unable_insert_a_record' => "לא ניתן להכניס רשומת A:‏ %1",
    'cmd_dns__unable_insert_mx_record' => "לא ניתן להכניס רשומת MX:‏ %1",
    'cmd_dns__unable_insert_ns_record' => "לא ניתן להכניס רשומת NS:‏ %1",
    'cmd_dns__unable_set_dns_zone_status' => "לא ניתן להגדיר את מצב אזור ה-DNS‏: %1",
    'cmd_domains__dom_already_exists' => "הדומיין %1 כבר קיים.",
    'cmd_domains__dns_record_already_exists' => "לא ניתן ליצור את הדומיין %1, מכיוון שכבר קיימת רשומת DNS שמצביעה אל המארח %1.",
    'cmd_domains__dom_already_exists1' => "ישנם %2 תת-דומיינים בדומיין זה. הדומיין %1 כבר קיים.",
    'cmd_domains__dom_already_exists2' => "התת-דומיין %1 כבר קיים.",
    'cmd_domains__dalias_already_exists' => "כינוי זה כבר קיים.",
    'cmd_domains__domain_alias_already_exists' => 'כבר קיים כינוי דומיין בשם זה.',
    'cmd_domains__unable_del_mail_for_dom' => "לא ניתן למחוק את שירותי הדואר עבור הדומיין: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "לא ניתן למחוק חשבון FTP אנונימי עבור הדומיין: %1",
    'cmd_domains__unable_update_dom_param' => "לא ניתן לעדכן את הפרמטרים של הדומיין: %1.",
    'cmd_domains__unable_rename_client_exist' => "שם המשתמש של מנהל הדומיין כבר נמצא בשימוש.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "סוג אחסון האתרים אינו פיזי.",
    'cmd_hosting__unable_create_user' => "לא ניתן ליצור את המשתמש %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "לא ניתן להגדיר כתובת IP עבור המארחים הווירטואליים מבוססי השמות: %1",
    'cmd_hosting__unable_del_old_hst' => "לא ניתן למחוק את אחסון האתרים הקודם שהוגדר: %1",
    'cmd_hosting__unable_del_protected_directory' => "לא ניתן למחוק את הספריה המוגנת: %1.",
    'cmd_hosting__unable_del_web_user' => "לא ניתן למחוק משתמש אינטרנט: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "לא ניתן ליצור או לעדכן את המארח הווירטואלי: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "לא ניתן להגדיר את אחסון האתרים בהעברה בתוך מסגרת.",
    'cmd_hosting__unable_rebuild_ftp_config' => "לא ניתן לבנות מחדש את קובץ התצורה proftpd:‏ %1",
    'cmd_hosting__unable_set_up_ssl' => "לא ניתן להגדיר SSL/TLS:‏ %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "לא ניתן להסיר את ההגנה מספריית ה-SSL/TLS:‏ %1",
    'cmd_hosting__unable_update_dest_url' => "לא ניתן לעדכן את כתובת ה-URL המשמשת כיעד: %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "לא ניתן לעדכן את אזור ה-DNS עבור הדומיין: הרחבת כלי העזר נכשלה.",
    'cmd_hosting__unable_update_ftp_passwd' => "לא ניתן לעדכן סיסמת FTP:‏ %1.",
    'cmd_hosting__unable_update_user' => "לא ניתן לעדכן את המשתמש %2: %1",
    'cmd_hosting__unknown_hst_type' => "סוג אחסון אתרים לא מוכר.",
    'cmd_hosting__you_not_have_permission_del_hst' => "אין לך את ההרשאה לסיים את שירות אחסון האתרים.",
    'cmd_mail__autoresponder__not_configured' => "לא נקבעה תצורת המענה האוטומטי עבור חשבון דוא\"ל זה",
    'cmd_mail__addr_already_used_in_mail_redirect' => "הכתובת %1 כבר משמשת להעברת דואר.",
    'cmd_mail__alias_already_exists' => "הכינוי כבר קיים.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "מזהה המענה האוטומטי ומזהה חשבון הדוא\"ל אינם תואמים.",
    'cmd_mail__autoresp_id_is_undefined' => "מזהה המענה האוטומטי אינו מוגדר.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "כבר קיים כינוי דואר בשם כזה עבור חשבון הדוא\"ל: %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "חשבון הדוא\"ל %1 כבר רשום כמנוי על רשימת דיוור זו.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "בדומיין זה כבר קיים חשבון הדוא\"ל %1.",
    'cmd_mail__mail_name_not_exist' => "חשבון הדוא\"ל אינו קיים.",
    'cmd_mail__mail_name_passwd_part' => "הסיסמה לא אמורה להכיל שם חשבון דוא\"ל כחלק ממנה.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "רשימת הדיוור %1 כבר קיימת בדומיין זה.",
    'cmd_mail__mailname_already_exist_in_mg' => "חשבון הדוא\"ל %1 כבר נמצא בקבוצת דואר.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "בדומיין זה כבר קיים חשבון הדוא\"ל %1.",
    'cmd_mail__mailname_already_exists' => "חשבון הדוא\"ל כבר קיים.",
    'cmd_mail__mailname_is_invalid' => "שם חשבון הדוא\"ל %1 אינו חוקי.",
    'cmd_mail__mailname_unable_update' => "לא ניתן לעדכן את מאפייני חשבון הדוא\"ל:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "המערכת הגיעה למספר המענים האוטומטיים המרבי עבור דומיין זה.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "המערכת הגיעה למספר המרבי של קבוצות דואר עבור דומיין זה.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "המערכת הגיעה למספר רכיבי ההעברה המרבי עבור דומיין זה.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "המערכת הגיעה למספר תיבות הדואר המרבי.",
    'cmd_mail__no_members_specified' => "לא צוינו חברים.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "הסיסמה פשוטה מדי, בחר אחרת.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "כתובת דוא\"ל זו כבר נמצאת בשימוש.",
    'cmd_mail__unable_define_autoresp_id' => "לא ניתן להגדיר את המזהה %1 של מענה אוטומטי.",
    'cmd_mail__unable_update_mail_for_dom' => "נכשל שינוי הגדרות שירות הדואר עבור הדומיין %1",
    'cmd_mail__unable_del_mail_for_dom' => "לא ניתן להסיר את שירות הדואר מהדומיין %1.",
    'cmd_mail__unable_del_mail_redirection' => "לא ניתן להסיר את שירות העברת הדואר %1.",
    'cmd_mail__unable_remove_autoresp' => "לא ניתן להסיר מענים אוטומטיים: %1",
    'cmd_mail__unable_remove_mail_group_members' => "לא ניתן להסיר את החברים בקבוצת הדואר: %1",
    'cmd_mail__unable_turn_off_mail_group' => "כיבוי קבוצת הדואר נכשל: %1",
    'cmd_mail__unable_update_mail_redirect' => "לא ניתן לקבוע מחדש את תצורת שירות העברת הדואר %1.",
    'cmd_mail__uploaded_file_is_too_big' => "גודל הקובץ שהועלה גדול מדי.",
    'cmd_mail__additionally' => "בנוסף:",
    'cmd_pd__invalid_login' => "שם משתמש שגוי.",
    'cmd_pd__this_user_already_exist' => "כבר קיים משתמש כזה.",
    'cmd_pd__unable_define_hst_type' => "לא ניתן להגדיר סוג אחסון אתרים.",
    'cmd_pd__unable_upd_pd_usr' => "לא ניתן לעדכן את המאפיינים של משתמש ספריה מוגנת: %1.",
    'cmd_pd__user_is_undefined' => "המשתמש אינו מוגדר.",
    'cmd_server__no_enough_free_disk_space' => "אין מספיק שטח דיסק.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "הסיסמה הישנה שגויה. נסה שוב.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "המערכת הגיעה למגבלת משתמשי האינטרנט המרבית עבור דומיין זה.",
    'cmd_web_usr__unable_create_user' => "לא ניתן ליצור משתמש מערכת: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "לא ניתן להגדיר מגבלת משתמשי אינטרנט מרבית: %1",
    'cmd_web_usr__user_already_exists' => "המשתמש כבר קיים.",
    'cmd_web_usr__web_user_name_is_invalid' => "שם משתמש האינטרנט %1 אינו חוקי.",
    'cmd_web_usr__web_user_not_exist' => "משתמש האינטרנט אינו קיים.",
    'common_func__exec_bad_argument' => "ארגומנט exec לא אמור להכיל סימן גרש יחיד.",
    '__eol' => 'מעברי שורה',
    'eol__binary_file' => 'לא ניתן לשנות סגנון מעבר שורה בקובץ בינארי.',
    'cp_access_admin_deny' => "הגישה ממנהל המערכת לכתובת '%1' מוגבלת בהתאם למדיניות הגבלת גישת IP שמוחלת כרגע.",
    'create_domain_warn__' => "החריגות הבאות בוצעו במהלך יצירת דומיין:",
    'create_domain__client_select' => 'בחר בלקוח שעבורו ייווצר הדומיין',

    'dashboard__nav_button_name' => "דף הבית",
    'dalias__list_title' => 'כינויי דומיינים עבור הדומיין %1',
    'dalias__list_legend' => 'כינויי דומיינים',
    'dalias__list_header' => 'כינויי דומיינים',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'שם כינוי דומיין',
    'dalias__list_ascii_name' => 'בתבנית ASCII',
    'dalias__remove_title' => 'כינויי הדומיינים הבאים של הדומיין %1 יוסרו:',
    'dalias__select_domain_aliases_to_remove' => 'בחר את כינויי הדומיינים שיוסרו.',
    'dalias__mail_turn_on_failed' => 'לא ניתן להפעיל את שירות הדואר: %1',
    'dalias__web_turn_on_failed' => 'לא ניתן להפעיל את שירות האינטרנט: %1',
    'db_usr_edit__db_usr_name_old' => "שם משתמש מסד נתונים ישן",
    'database_server_edit_form__cannot_infer_type' => 'לא ניתן להסיק מהנתונים שסופקו מהי שיטת החיבור. כדי לחבר דרך TCP/IP עם היציאה שסופקה, ציין את "127.0.0.1" כשם המארח של שרת מסד הנתונים. כדי להשתמש בשקע "%1" של Unix, השאר את שדה היציאה ריק.',
    'database_server_edit_form__duplicate' => 'כבר רשום שרת מסד נתונים עם שילוב זה של כתובת מארח ומספר יציאה.',
    'database_server_edit_form__host_is_invalid' => 'שם המארח שצוין אינו חוקי.',
    'database_server_edit_form__port_is_invalid' => 'מספר היציאה שצוין אינו חוקי.',
    'database_server_error__consult_admin' => 'פנה למנהל השרת.',
    'database_server_error__last__connection_failed' => 'הניסיון האחרון לשלוט בשרת מסד נתונים זה נכשל עקב בעיות רשת.',
    'database_server_error__last__permission_denied' => 'הניסיון האחרון לשלוט בשרת מסד נתונים זה נכשל מכיוון שלחשבון שסופק אין הרשאות ניהוליות.',
    'database_server_error__last__credentials_not_set' => "הניסיון האחרון לשלוט בשרת זה נכשל מכיוון שלא צוינו שם משתמש וסיסמה חוקיים של מנהל מערכת.",
    'database_server_error__last__other_error' => 'הניסיון האחרון לשלוט בשרת מסד נתונים זה נכשל.',
    'database_server_error__real__connection_failed' => 'החיבור לשרת מסד הנתונים נכשל עקב בעיות רשת:',
    'database_server_error__real__permission_denied' => 'החיבור לשרת מסד הנתונים נכשל מכיוון שלחשבון שסופק אין הרשאות ניהוליות:',
    'database_server_error__real__duplicate_object' => 'החיבור לשרת מסד הנתונים נכשל עקב התנגשות שמות:',
    'database_server_error__real__unacceptable_name' => 'החיבור לשרת מסד הנתונים נכשל עקב שם אובייקט לא חוקי:',
    'database_server_error__real__unacceptable_password' => 'החיבור לשרת מסד הנתונים נכשל עקב סיסמה לא מקובלת:',
    'database_server_error__real__credentials_not_set' => "Plesk אינו יכול להתחבר לשרת מסד הנתונים מכיוון שלא צוינו שם משתמש וסיסמה חוקיים של מנהל מערכת.",
    'database_server_error__real__other_error' => 'החיבור לשרת מסד הנתונים נכשל.',
    'database_server_error__test__connection_failed' => 'בדיקת החיבור לשרת מסד הנתונים נכשלה עקב בעיות רשת:',
    'database_server_error__test__permission_denied' => 'בדיקת החיבור לשרת מסד הנתונים נכשלה מכיוון שלחשבון שסופק אין הרשאות ניהוליות:',
    'database_server_error__test__duplicate_object' => 'בדיקת החיבור לשרת מסד הנתונים נכשלה עקב התנגשות שמות:',
    'database_server_error__test__unacceptable_name' => 'בדיקת החיבור לשרת מסד הנתונים נכשלה עקב שם אובייקט לא חוקי:',
    'database_server_error__test__unacceptable_password' => 'בדיקת החיבור לשרת מסד הנתונים נכשלה עקב סיסמה לא מקובלת:',
    'database_server_error__test__credentials_not_set' => "בדיקת החיבור לשרת זה נכשלה מכיוון שלא צוינו שם משתמש וסיסמה חוקיים של מנהל מערכת.",
    'database_server_error__test__other_error' => 'בדיקת החיבור לשרת מסד הנתונים נכשלה:',

    'db__create_new_db' => "הוסף מסד נתונים",
    'db__db_add' => "הוספת מסד נתונים",
    'db__db_for_dom' => "מסד נתונים של אתר האינטרנט %1",
    'db__db_id_undefined' => "לא מוגדר מזהה מסד הנתונים.",
    'db__db_name' => "‫שם מסד נתונים‬",
    'db__db_not_exist' => "מסד הנתונים אינו קיים.",
    'db__db_type' => "סוג",
    'db__db_server' => "שרת מסד נתונים",
    'db_server_not_exist' => "שרת מסד הנתונים אינו קיים.",
    'db__db_user_not_exist' => "משתמש מסד הנתונים אינו קיים.",
    'db__domain_not_exist' => "הדומיין אינו קיים.",
    'db__enter_db_name' => "הזן שם מסד נתונים חדש.",
    'db__invalid_db_id' => "מזהה מסד נתונים אינו חוקי.",
    'db__invalid_db_name' => "שם מסד הנתונים אינו חוקי. שם מסד הנתונים צריך להכיל אך ורק סימנים אלפביתיים לטיניים, ספרות, מקף תחתון או מקף. אורכו לא יעלה על 63 סימנים.",
    'db__max_db_reached_for_dom' => "המערכת הגיעה למגבלה על מספר מסדי הנתונים עבור דומיין זה.",
    'db__max_mssql_db_reached_for_dom' => "המערכת הגיעה למגבלה על מסדי נתונים של שרת Microsoft SQL עבור דומיין זה",
    'db__postgres_not_connect_for_admin' => "לא ניתן להתחבר ל-PostgreSQL. הפעל את התמיכה ב-PostgreSQL בדף ניהול השרת.",
    'db__postgres_not_connect_for_client' => "לא ניתן להתחבר ל-PostgreSQL. לעזרה, פנה למנהל המערכת.",
    'db__remove_db_on_domain' => "יוסרו מסדי הנתונים הבאים תחת אתר האינטרנט %2 שנמצא בבעלות הלקוח %1:",
    'db__remove_db_on_domain_of_cl' => "יוסרו מסדי הנתונים הבאים עבור הדומיין %2 שנמצא בבעלות הלקוח %1:",
    'db__remove_db_linked_resource' => 'מסד נתונים זה נמצא בשימוש של יישום אינטרנט. ניתן להסירו רק לאחר הסרת יישום אינטרנט זה.',
    'db__remove_db_users' => "יוסרו המשתמשים הבאים של מסד הנתונים %3 תחת אתר האינטרנט %2 שנמצא בבעלות הלקוח %1:",
    'db__remove_db_users_of_cl' => "יוסרו המשתמשים הבאים של מסד הנתונים %3 תחת אתר האינטרנט %2 שנמצא בבעלות הלקוח %1:",
    'db__select_db_for_remove' => "בחר את מסדי הנתונים שיוסרו.",
    'db__select_db_users_for_remove' => "בחר את משתמשי מסדי הנתונים שיוסרו.",
    'db__unable_create_db_user' => "לא ניתן ליצור את משתמש מסד הנתונים: %1",
    'db__unable_define_db_name' => "לא ניתן להגדיר את שם מסד הנתונים: %1",
    'db__unable_define_db_user' => "לא ניתן להגדיר את משתמש מסד הנתונים: %1",
    'db__unable_define_db_users' => "לא ניתן להגדיר משתמשי מסד נתונים: %1",
    'db__unable_select_dom_name' => "לא ניתן לבחור שם דומיין: %1",
    'db_edit__db_for_dom' => "משתמשים עבור מסד הנתונים %1 בדומיין %2",
    'db_edit__invalid_db_name' => "שם מסד הנתונים אינו חוקי.",
    'db_edit__no_users' => "אין משתמשים עם הרשאות עבור מסד נתונים זה.",
    'db_edit__unable_define_db_usrs' => "לא ניתן להגדיר את משתמשי מסד הנתונים: %1",
    'db_edit__unable_select_db_usr' => "לא ניתן לבחור את משתמש מסד הנתונים.",
    'db_edit__db_user_password_for_' => "הקלד את הסיסמה כדי להיכנס למערכת כמשתמש מסד הנתונים %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "הוספת משתמש מסד נתונים",
    'db_usr_edit__db_usr_name' => "שם משתמש מסד הנתונים",
    'db_usr_edit__edit_db_usr' => "הגדר אישורים עבור חשבון משתמש מסד הנתונים",
    'db_usr_edit__for_db' => "ב-%1 מסד נתונים",
    'db_usr_edit__not_create_pass' => "פעולה זו תביא ליצירת חשבון משתמש מסד נתונים ללא סיסמה. האם ברצונך ליצור משתמש מבלי להקצות סיסמה?",
    'dbuser__only_one_user_can_be_default' => "ניתן להגדיר כברירת מחדל משתמש אחד בלבד.",
    'db_server__cannot_delete_default' => "לא ניתן למחוק את שרת מסד הנתונים המוגדר כברירת מחדל.",
    'db_server__cannot_delete_local' => "לא ניתן למחוק את שרת מסד הנתונים.",
    'db_server__cannot_delete_used' => 'לא ניתן למחוק שרת מסד נתונים בזמן שיש מסדי נתונים או משתמשי מסדי נתונים שמתארחים בו.',
    'demo__disabled_in_demo' => "פעולה זו אינה נתמכת בגירסת ההדגמה.",
    'defaultcomponents__title' => "בחירת רכיבי ברירת מחדל",
    'defaultcomponents__select_default' => "בחר רכיב ברירת מחדל של %1", //to check
    'defaultcomponents__not_installed' => "(לא מותקן)",
    'defaultcomponents__not_configured' => "(תצורה לא נקבעה)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "חלק מקטגוריות השירותים כוללות בחירות לא חוקיות או שלא בוצעו בחירות.",
    'defaultcomponents__depends_on' => "(דורש %1)",
    'defaultcomponents__parameters' => "פרמטרים של %1",
    'component_name__antivirus' => "אנטי-וירוס",
    'component_name__database' => "‫שרת SQL‬",
    'component_name__sqladmin' => "‫ניהול אתרים של MySQL‬",
    'component_name__sqladminmysql' => "‫ניהול אתרים של MySQL‬",
    'component_name__dnsserver' => "‫שרת DNS‬",
    'component_name__firewall' => "חומת אש",
    'component_name__ftpserver' => "‫שרת FTP‬",
    'component_name__java' => "Java",
    'component_name__mailserver' => "‫שרת דואר‬",
    'component_name__local_mailserver' => "שרת דואר מקומי",
    'component_name__psa' => "Plesk",
    'component_name__script' => "‫Scripting באינטרנט‬",
    'component_name__spamfilter' => "מסנן הודעות זבל",
    'component_name__stats' => "סטטיסטיקת אינטרנט",
    'component_name__stunnel' => "עטיפת SSL/TLS",
    'component_name__webmail' => "דואר אינטרנט",
    'component_name__webpublish' => "‫פרסום באינטרנט‬",
    'component_name__webserver' => "‫שרת אינטרנט‬",
    'dns__dns_record_invalid_values' => 'צוינו ערכי רשומת משאב לא חוקיים: %1: %2',
    'dns__dns_record_not_found' => 'רשומת ה-DNS לא נמצאה',
    'dns__dns_zone_invalid_values' => 'צוינו פרמטרים שגויים של אזור DNS.',

    'dns__soa_mname_title' => 'שרת שמות ראשי',
    'dns__soa_mname_legend' => 'שרת שמות',
    'dns__soa_mname_autoselect' => '(בחירה אוטומטית)',

    'dns__dns_zone_off_remove_title' => "רשומות המשאבים הבאות יוסרו מהאזור %1:",
    'dns__dns_zone_master_remove_title' => "הסרת רשומות משאבים מאזור ה-DNS‏ %1",
    'dns__dns_zone_slave_remove_title' => "יוסרו הרשומות הבאות של רשת שמות ראשי עבור %1:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'הזן מחרוזת רשומה',
    'dns_add__is_spf_syntax' => 'רשומת SPF',
    'dns_add__spf_value_is_invalid' => "ערך רשומת ה-SPF שגוי, הוא חייב להתחיל ב-'v=spf'",
    'dns__dns_zone_status' => "מצב אזור DNS.",
    'dns__invalid_ip_address' => "כתובת ה-IP של שרת DNS ראשי חדש אינה נכונה או ריקה.",
    'dns__ip_address' => "כתובת IP",
    'dns__master_dns_type' => "זה שרת DNS ראשי",
    'dns__masters' => "שרתי DNS ראשיים",
    'dns__soa_minimum_too_large' => 'אחסון של תגובות שליליות במטמון למשך יותר משלוש שעות אינו מומלץ.',
    'dns__select_masters_to_remove' => "בחר את שרתי ה-DNS הראשיים שיוסרו.",
    'dns__select_template_record_to_remove' => 'בחר רשומות תבנית DNS שיוסרו.',
    'dns__nameservers_for_domain' => "שרתי שמות עבור הדומיין",
    'dns__remove_dns_zone_of_domain__' => "הסרת רשומות DNS מהדומיין %1",
    'dns__remove_dns_zone_template__' => "רשומות ה-DNS הבאות יוסרו מהתבנית:",
    'dns__remove_this_dns_record?' => "האם אתה בטוח שברצונך להסיר רשומת DNS זו?",
    'dns__restore_default' => "שיחזור אזור ה-DNS לפי התבנית",
    'dns__restore_default_confirm' => "שחזור אזור ה-DNS יבטל את תצורת אזור ה-DNS הנוכחית. האם להמשיך בכל זאת?",
    'dns__restore_default_error' => "שגיאה בשחזור אזור DNS‏:",
    'dns__slave_dns_type' => "הוא שרת DNS משני",
    'dns__subdomain_dns_rec_removed' => "רשומת ה-A הוסרה מאזור התת-דומיין %1.",
    'dns__zone_switched_off_no_ns' => "האזור כובה מכיוון שאין רשומת NS‏ %1 שחייבת להימצא באזור. כדי להוסיף את הרשומה לאזור, לחץ על הלחצן 'הוספת רשומה'.",
    'dns__cant_switch_on_no_ns' => "לא ניתן להפעיל את האזור, מכיוון שאין רשומת NS‏ %1 שחייבת להימצא באזור. כדי להוסיף את הרשומה לאזור, לחץ על הלחצן 'הוספת רשומה'.",
    'dns__unable_activate/deactivate_dns' => "לא ניתן להפעיל/להשבית DNS‏: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "לא ניתן להוסיף שרת DNS ראשי: ערך כפול.",
    'dns__unable_add_dns_master_local_ip' => "לא ניתן להוסיף כתובת IP עבור שרת DNS ראשי: רשומה זו צריכה להיווצר בשרת מרוחק.",
    'dns__unable_define_dns_record' => "לא ניתן להגדיר את רשומת ה-DNS:‏ %1",
    'dns__unable_get_dns_template_status' => "לא ניתן לאחזר את מצב תבנית ה-DNS‏.",
    'dns__unable_remove_dns_rec' => "לא ניתן להסיר את רשומת ה-DNS:‏ %1",
    'dns__warnings__' => "התוצאה של שינוי אזור DNS‏:",
    'dns__you_not_have_perm_manage_dns' => "אין לכם את ההרשאה לנהל את אזור ה-DNS לדומיין הזה.",
    'dns__cant_create_record_with_server_ip' => "לא ניתן להוסיף כתובת IP זו מכיוון שהיא תואמת לכתובת ה-IP של שרת זה המנוהל על ידי Plesk.",

    'dns__tabs_acl' => "העברות אזור",
    'dns__acl_add_network_legend' => "‫הוספת רשת‬",
    'dns__acl_add_ip_legend' => "הוספת כתובת IP",
    'dns__acl_network_not_allowed' => "כתובת רשת זו אינה מותרת על ידי DNS ב-Windows.",
    'dns__acl_enter_ip_address_with_mask' => "כתובת IP/מסיכה",
    'dns__acl_enter_ip_address' => "כתובת IP",
    'dns__acl_list_network_legend' => "רשתות המורשות להשיג עותק של אזור DNS",
    'dns__acl_list_ip_legend' => "כתובות IP המורשות להשיג עותק של אזור DNS",
    'bt_dns_acl_add_network' => "‫הוספת רשת‬",
    'bt_dns_acl_add_ip' => "הוספת כתובת IP",

    'dns_add__add_rec_for_zone' => "הוסף %1 עבור אזור %2",
    'dns_add__canonical_dom_name_is_invalid' => "שם הדומיין הקנוני אינו חוקי.",
    'dns_add__enter_canonical_name' => "שם קנוני",
    'dns_add__enter_dom_name' => "שם הדומיין",
    'dns_add__enter_ip_address' => "כתובת IP",
    'dns_add__enter_ip_mask' => "כתובת IP ומסיכת רשת",
    'dns_add__enter_mail_domain' => "דומיין דואר",
    'dns_add__enter_mail_exchanger' => "שרת Mail Exchange",
    'dns_add__enter_nameserver' => "שרת שמות",
    'dns_add__enter_txt_record' => "רשומת TXT",
    'dns_add__enter_service_name' => "שם שירות",
    'dns_add__hint_service_name' => "דוגמה: SIP (בלי קו תחתון)",
    'dns_add__enter_protocol' => "פרוטוקול",
    'dns_add__hint_protocol_name' => "דוגמה: TCP (בלי קו תחתון)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "‫עדיפות‬",
    'dns_add__specify_weight_of_service' => "משקל יחסי לרשומות בעלות עדיפות זהה",
    'dns_add__enter_target_host' => "מארח יעד",
    'dns_add__hint_target_host' => "דוגמה: example.com",
    'dns_add__enter_target_port' => "יציאת יעד",
    'dns_add__caa_tag' => "תג",
    'dns_add__caa_value' => "ערך",
    'dns_add-invalid-A_ip' => "כתובת ה-IP אינה חוקית.",
    'dns_add-invalid-AAAA_ip' => "כתובת ה-IP אינה חוקית.",
    'dns_add-invalid-PTR_ip_mask' => "זוג כתובת IP/מסיכת רשת לא חוקי.",
    'dns_add-invalid-SRV_service_name' => "שם שירות לא חוקי",
    'dns_add-invalid-SRV_protocol_name' => "פרוטוקול לא חוקי",
    'dns_add-invalid-SRV_target_port' => "פתחת מטרה לא תקנית",

    'dns_add__invalid_ip' => "כתובת ה-IP אינה חוקית.",
    'dns_add__low' => "‫נמוך‬",
    'dns_add__mail_dom_name_is_invalid' => "שם דומיין הדואר אינו חוקי.",
    'dns_add__nameserver_is_invalid' => "שרת השמות אינו חוקי.",
    'dns_add__record' => "רשומת %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "ציין עדיפות של שרת Mail Exchange",
    'dns_add__unable_insert_new_dns_rec' => "לא ניתן להכניס רשומת DNS‏ חדשה: %1",
    'dns_add__very_high' => "גבוה מאוד",
    'dom_ctrl__allowed' => "מותר",
    'dom_ctrl__db' => "מסדי נתוני MariaDB/MySQL",
    'dom_ctrl__mssql_db' => "מסדי נתוני MS SQL",
    'dom_ctrl__disk_space' => "שטח דיסק",
    'dom_ctrl__dom_adm' => "דומיין %1 מתוך %2",
    'dom_ctrl__dom_cl' => "דומיין %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "לדומיין מוגדרת העברה הלאה עם כתובת URL להעברה שאינה מוגדרת",
    'dom_ctrl__domain_has_frame_forwarding' => "לדומיין יש העברה בתוך מסגרת לכתובת ה-URL‏ %1",
    'dom_ctrl__domain_has_no_hosting' => "לדומיין אין אחסון אתרים שתצורתו נקבעה",
    'dom_ctrl__domain_has_physical_hosting' => "תצורת אחסון אתרי אינטרנט נקבעה עבור דומיין זה בכתובת ה-IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "לדומיין יש העברה הלאה סטנדרטית לכתובת ה-URL‏ %1",
    'dom_ctrl__maillists' => "רשימות דיוור",
    'dom_ctrl__mboxes' => "תיבות דואר",
    'dom_ctrl__mg' => "העברת דואר",
    'dom_ctrl__resource_name' => "משאב",
    'dom_ctrl__resp' => "מענה אוטומטי",
    'dom_ctrl__subdom' => "תת-דומיינים",
    'dom_ctrl__dom_aliases' => "כינויי דומיינים",
    'dom_ctrl__traffic' => "תעבורה",
    'dom_ctrl__unable_activate/deactivate_dom' => "לא ניתן להפעיל/להשבית דומיין: %1",
    'dom_ctrl__used' => "בשימוש",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "משתמשי אינטרנט",
    'dom_pref__bounce_with_phrase' => "החזר עם הודעה",
    'dom_pref__bounce' => "החזרה",
    'dom_pref__catch_addr' => "העבר לכתובת",
    'dom_pref__reject' => 'דחייה',
    'dom_pref__confirm_domain_removing' => "אל תשכח לדווח למבקרי הדומיין על שינוי שם הדומיין. האם אתה בטוח שברצונך לשנות את שם הדומיין?",
    'dom_pref__db_inconsystency' => "חוסר עקביות במסד נתונים.",
    'dom_pref__dbs' => "‫מסדי נתונים‬",
    'dom_pref__delete_traffic_stat' => "שמור נתונים סטטיסטיים של אינטרנט ותעבורה",
    'dom_pref__delete_traffic_stat_older' => "שמור נתונים סטטיסטיים של אינטרנט ותעבורה",
    'dom_pref__dom_level_name_conflict' => "שם המשתמש של מנהל הדומיין מתנגש עם שם משתמש של אחד מהלקוחות.",
    'dom_pref__invalid_disk_space_limit' => "מגבלת שטח דיסק לא חוקית. ערך מרבי: %1",
    'dom_pref__invalid_expiration_date_limit' => "תקופת חוקיות לא חוקית.",
    'dom_pref__invalid_max_traffic_limit' => "מגבלת תעבורה לא חוקית. ערך מרבי: %1",
    'dom_pref__limits_of_dom' => "מגבלות עבור הדומיין %1",
    'dom_pref__mail_grps' => "קבוצות דואר",
    'dom_pref__mail_nonexistent_user' => "מה לעשות עם דואר שנשלח למשתמשים שלא קיימים",
    'dom_pref__mail_redirs' => "רכיבי העברת דואר",
    'dom_pref__mail_resps' => "מענה אוטומטי של דואר",
    'dom_pref__max_limit_is_invalid' => "%1 אינו חוקי.",
    'dom_pref__max_num_of_%objects_is_invalid' => "המספר המרבי של %1 אינו חוקי.",
    'dom_pref__new_limit_less_currently_used' => "%1: נדרש - %2, בשימוש כרגע - %3",
    'dom_pref__older_that' => "עבור",
    'dom_pref__postboxes' => "תיבות דואר",
    'dom_pref__preferences_of_dom' => "הגדרות עבור הדומיין %1",
    'dom_pref__redirect_to_itself' => "ההעברה הלאה בדומיין תהיה מוגדרת לעצמה",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "ציינת את הזמן לשמירת נתונים סטטיסטיים של תעבורה בדומיין כפחות מהערך הכול המוגדר עבור השרת (%1 חודשים). תקופת שמירת הנתונים הסטטיסטיים מוגדרת כשווה לערך ברירת המחדל עבור השרת (%1 חודשים).",
    'dom_pref__unable_add_www_prefix_in_dom' => "לא ניתן להוסיף קידומת www לדומיין: %1",
    'dom_pref__unable_define_physical_hst_param' => "לא ניתן להגדיר פרמטרים של אחסון אתרים פיזי:‏ %1",
    'dom_pref__unable_rename_domain' => "אין אפשרות לשנות את שם הדומיין %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "לא ניתן להגדיר את מיכסת תיבת הדואר עבור דומיין זה: %1",
    'dom_pref__unable_set_up_web_user_script' => "לא נין להגדיר scripting עבור משתמשי אינטרנט: %1",
    'dom_pref__unlimited' => "ללא הגבלה",
    'dom_pref__web_usrs' => "משתמשי אינטרנט",
    'dom_pref__you_already_have_%object' => "יש לך כבר %1",
    'cu_domain__error_unable_update_ftp_users' => 'עדכון משתמשי דומיין ה-FTP נכשל: %1',
    'dom_cli__warning_ignore_quota' => 'אזהרה: המערכת מתעלמת מהאפשרות "-hard_quota": מיכסת שטח הדיסק הקשיח אינה נתמכת',
    'dom_user_client_login_exist' => "לא ניתן לאפשר גישה של מנהל דומיין אל Plesk בדומיין %1: שם משתמש זה כבר נמצא בשימוש.",
    'domain__unable_to_turn_on_service' => "הפעלת השירות %1 נכשלה.",
    'domains__change_the_status_of_domain?' => "האם אתה בטוח שברצונך לשנות את המצב של הדומיין %1?",
    'domains__unable_to_change_client_status' => "לא ניתן לשנות את מצב חשבון הלקוח‏: %1",
    'domains__unable_update_apache_settings' => "לא ניתן לעדכן הגדרות Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "אין לך את ההרשאות למחוק דומיינים.",
    'domains_list__unable_remove_doms' => "לא ניתן להסיר דומיינים: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'בחר את כינויי הדומיינים שיוסרו.',
    'domain_aliases_remove__title' => 'הסרת כינויי דומיינים',
    'domain_aliases__max_aliases_reached_for_dom' => "המערכת הגיעה למגבלה על מספר הכינויים עבור דומיין זה.",
    'domain_edit__edit_title' => 'ערוך שם כינוי דומיין',
    'domain_alias_edit__type' => 'סוג כינוי דומיין',
    'domain_aliases__list_header' => 'כינויי דומיינים',
    'domain_aliases__name' => 'שם',
    'domain_aliases__type' => 'סוג',
    'domain_aliases__type_full' => 'אינטרנט+FTP+דואר',
    'domain_aliases__type_web_ftp' => 'אינטרנט+FTP',
    'domain_aliases__page_title' => 'כינויי דומיינים',
    'domain_aliases__legend' => 'כינויי דומיינים',
    'domain_alias__domain_exists' => 'כבר קיים דומיין בשם כזה',
    'domain_alias__subdomain_exists' => 'כבר קיים תת-דומיין בשם כזה',
    'domain_alias__dns_record_exists' => 'כבר קיימת רשומת DNS בשם כינוי הדומיין שצוין',
    'domain_alias__domain_alias_exists' => "כבר קיים כינוי דומיין בשם זה",
    'domain_alias__invalid_type_full' => 'שרת הדואר אינו תומך בכינויי דומיינים',
    'domain_alias__redirect_exists' => 'זוהה ניתוב מחדש לעצמו.',

    'ds__anonymous_ftp' => "FTP אנונימי",
    'drweb__pagetitle' => 'הגדרות אנטי-וירוס',
    'drweb__drweb' => 'בדיקת דואר על ידי אנטי-וירוס',
    'drweb__drweb_direction' => 'בדיקת וירוסים בדואר',
    'drweb__drweb_direction_off' => 'אל תבדוק אם יש וירוסים',
    'drweb__drweb_direction_any' => 'דואר יוצא ונכנס',
    'drweb__drweb_direction_from' => 'דואר יוצא בלבד',
    'drweb__drweb_direction_to' => 'דואר נכנס בלבד',
    'drweb__disable_reason_key' => 'אנטי-וירוס אינו נתמך על ידי מפתח הרישיון.',
    'drweb__disable_reason_perm' => 'אין לך הרשאה לנהל אנטי-וירוס.',
    'drweb__disable_reason_install' => 'אנטי-וירוס אינו מותקן.',
    'drweb__filters' => 'מסנני אנטי-וירוס',
    'ds__dns' => "אזור DNS",
    'ds__mail' => "דואר",
    'dumps_list__deletion_page_title' => "קובצי הגיבוי הבאים של הדומיין %1 יוסרו:",
    'dumps_list__dumpfile_is_invalid' => "הקובץ %1 אינו קובץ גיבוי דומיין חוקי.",
    'dumps_list__page_title' => "אחסון קובצי גיבוי",
    'dumps_upload__page_title' => "העלאת קובצי גיבוי לאחסון",
    'dumps_list__repository_is_not_exist' => "לא קיים אחסון קובצי גיבוי.",
    'dumps_list__unable_to_remove' => "לא ניתן להסיר את קובץ הגיבוי: %1",
    'dumps_list__dumpfile_can_conflict' => "שם הקובץ שציינת מתנגש עם הקובץ %1. ציין שם קובץ אחר.",
    'dusr_ed__allow_dl_usr_access' => "אפשר גישה למנהל דומיין",
    'dusr_ed__information' => "מאפיינים של מנהל הדומיין %1",
    'dusr_ed__locale' => "השפה של מנהל הדומיין",
    'dusr_ed__skin' => "מעטפת ממש של מנהל הדומיין",
    'dusr_ed__personal_information' => 'מידע אישי',
    'ess__error' => "שגיאה",
    'example__' => "דוגמה: %1",
    'extras__allow_certificate_purchasing' => "אפשר רכישת אישורים",
    'extras__allow_domain_registration' => "אפשר רישום דומיין",
    'extras__allow_extras' => "אפשר שירותים נוספים",
    'extras__buy_new_key' => "הרישיון הנוכחי שלך אינו מאפשר לך לשנות אובייקטים אלה.",
    'extras__setup_services' => "הגדר שירותים נוספים",

    'ruleeditform__error' => 'לא ניתן לעדכן את כלל חומת האש.',
    'ruleeditform__name_is_required' => 'ציין את שם הכלל.',
    'ruleeditform__profiles_is_required' => 'בחר פרופיל אחד לפחות.',
    'ruleeditform__invalid_ip' => 'הרשת או כתובת ה-IP שצוינה אינן חוקיות.',
    'ruleeditform__invalid_port' => 'היציאה שצוינה אינה חוקית. הערכים האפשריים הם 1000 או 1000-1051',

    'get_password__encrypted_password' => "לא ניתן לשלוח את פרטי הסיסמה: הסיסמה מאוחסנת בצורה מוצפנת.",
    'get_password__mail_error' => "אירעה שגיאה במהלך הניסיון לשלוח את הסיסמה לדוא\"ל %1: %2",
    'get_password__mail_ok' => "הסיסמה נשלחה בהצלחה לדוא\"ל: %1",
    'get_password__message' => "שם המשתמש שלך לגישה למערכת: %1 הסיסמה שלך היא %2",
    'get_password__subject' => "סיסמה לשם גישה למערכת",
    'groups__available' => "קבוצות דואר זמינות",
    'groups__groups_for_mailname' => "קבוצות דואר אליהן רשום חשבון הדוא\"ל %1",
    'groups__member_of' => "חבר בקבוצות הדואר הבאות",
    'help__help_area' => "אזור עזרה.",
    'hst_def__auth_disabled' => "אסור",
    'hst_def__auth_enabled' => "מותר",
    'hst_def__change_curr_dns_ip' => "תשונה כתובת ה-IP הנוכחית של רשומת ה-A DNS",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "אף אחת מכתובות ה-IP של רשומות ה-A DNS תואמת לכתובת ה-IP שהוקצתה לחשבון אחסון האתרים שנוצר",
    'hst_def__dest_url' => "כתובת URL יעד",
    'hst_def__disk_quota' => "מיכסת דיסק",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "מגבלת שטח הדיסק בספריה הנכנסת של ה-FTP האנונימי חורגת ממכסת שטח הדיסק שאתה מנסה להגדיר. מגבלת שטח הדיסק בספריה הנכנסת של ה-FTP האנונימי לא תעלה על מגבלת שטח הדיסק של הדומיין.",
    'hst_def__frame_forwarding_definition' => "הקצאת העברה בתוך מסגרת עבור הדומיין %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "אזהרה: משתמש ה-FTP‏ %1 משמש בהגדרות חשבון אחסון אתרים, אך לא קיים במערכת.",
    'hst_def__hst_type_is_not_defined' => "לא מוגדר סוג אחסון אתרים",
    'hst_def__ip_based' => "מבוסס IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "העברת חשבון אחסון אתרים זה לכתובת IP משותפת תהפוך את שירות ה-FTP האנונימי בדומיין זה ללא זמין. האם להמשיך בכל זאת?",
    'hst_def__password_is_invalid_password_syntax' => "הסיסמה אינה חוקית. אין להשתמש בגרש יחיד ובתווים אלפביתיים מקומיים בסיסמה. אורך הסיסמה צריך להיות בין 5 ל-14 תווים. הסיסמה לא אמורה להכיל את שם המשתמש.",
    'hst_def__shell' => "גישת SSH למעטפת השרת תחת משתמש המערכת של המינוי",
    'hst_def__shell_windows' => "גישת שולחן עבודה מרוחק לשרת תחת משתמש המערכת של המינוי",
    'hst_def__standard_forwarding_definition' => "הקצאת העברה סטנדרטית עבור הדומיין %1",
    'hst_def__title_name_based' => "מבוסס שמות",
    'hst_def__unable_create/update_physic_hst' => "לא ניתן ליצור/לעדכן אחסון אתרים פיזי: %1",
    'hst_def__unable_create/update_std_fwd' => "לא ניתן ליצור/לעדכן העברה סטנדרטית: %1",
    'hst_def__unable_create_forwarding_myself' => "לא ניתן ליצור העברה לדומיין עצמו.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "לא ניתן לאפשר את השימוש בספריה יחידה לאחסון תוכן SSL/TLS ולא-SSL/TLS: תמיכה ב-SSL/TLS אינה מופעלת.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "לא ניתן להפעיל תמיכה ב-SSL/TLS: לא מותקן אישור SSL/TLS.",
    'hst_def__url_is_invalid' => "כתובת ה-URL לא חוקית.",
    'hst_def__virtual_host_access' => "גישת מארח וירטואלי עבור הדומיין %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "אזהרה. המארח הווירטואלי משתמש בכתובת IP שאינה קיימת לאחסון אתרים.",
    'hst_def__you_have_no_ips' => "אין לך כתובות IP זמינות ואינך מורשה ליצור אחסון אתרים מבוסס שמות.",
    'hst_sel__header' => "כדי לאחסן אתר אינטרנט בשרת זה, בחר באפשרות 'אחסון אתרים פיזי'. כדי להגדיר העברה של דומיין לאתר במחשב אחר, בחר באפשרות 'העברה בתוך מסגרת' או 'העברה סטנדרטית'. בהעברה סטנדרטית, משתמש מנותב מחדש לאתר וכתובת ה-URL בפועל מוצגת בדפדפן של המשתמש, כך שהוא יודע על הניתוב מחדש. בהעברה בתוך מסגרת, משתמש מנותב מחדש לאתר מבלי לדעת שהאתר שוכן בפועל במיקום אחר.",
    'hst_sel__physical_hst' => "אחסון אתרים פיזי",
    'hst_sel__select_hst_type' => "בחר את סוג אחסון האתרים עבור הדומיין",
    'hst_sel__select_hst_type_warning' => "בחר את סוג אחסון האתרים עבור הדומיין",
    'hst_sel__hosting_exists' => "לא ניתן ליצור אחסון אתרים, מכיוון שהתצורה שלו כבר נקבעה עבור דומיין זה. תנותב מחדש לדף ניהול אחסון האתרים.",
    'hst_sel__standard_frw' => "העברה סטנדרטית",
    'hst_sel__frame_frw' => "העברה בתוך מסגרת",
    '__frame_frw' => "העברה בתוך מסגרת",
    '__hosting_exists' => "לא ניתן ליצור אחסון אתרים, מכיוון שהתצורה שלו כבר נקבעה עבור דומיין זה. תנותב מחדש לדף ניהול אחסון האתרים.",
    '__choose_hst_type' => "בחר את סוג אחסון האתרים הנדרש.",
    '__no_hst_conf' => "לא נקבעה תצורת אחסון אתרים עבור הדומיין שלך.",
    '__physical_hst' => "אחסון אתרים פיזי",
    '__select_hst_type' => "בחר את סוג אחסון האתרים עבור הדומיין",
    '__standard_frw' => "העברה סטנדרטית",
    '__warning' => "אזהרה! כל הפרמטרים הקודמים שנקבעו יבוטלו. האם אתה בטוח שברצונך לשנות את סוג אחסון האתרים?",
    'i_cl_off' => "הלקוח אינו פעיל.",
    'i_cl_off_by_admin' => "חשבון הלקוח מושעה על ידי מנהל השרת.",
    'i_cl_off_expired' => "פג תוקף חשבון הלקוח.",
    'i_cl_on' => "הלקוח פעיל.",

    'icf__title' => 'חומת אש של חיבור לאינטרנט',
    'icf__if_legend' => 'ממשקים',
    'icf__mode' => 'מצב',

    'invalid_value' => 'הערך אינו חוקי',

    'ip_addr__already_exists' => "כתובת ה-IP‏ %1 כבר קיימת.",
    'ip_addr__cant_add' => "כתובת ה-IP‏ %1 אינה קיימת או שייכת למאגר IP של לקוח אחר",
    'ip_alias__interface' => "ממשק",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 כתובת IP לאחסון אתרים וירטואלי מבוסס שמות אינה חוקית.",
    'ip_alias__invalid_ip_or_netmask' => "זוג כתובת IP/מסיכת רשת לא חוקי.",
    'ip_alias__orig_ip_can_not_be_deleted' => "כתובת ה-IP‏ %1 היא כתובת ה-IP המקורית של השרת, כך שלא ניתן להסיר אותה.",
    'ip_alias__ip_is_invalid' => "%1 כתובת ה-IP אינה חוקית.",
    'ip_alias__ip_mask_is_invalid' => "%1 מסיכת ה-IP אינה חוקית.",
    'ip_alias__ip_not_exist' => "כתובת ה-IP‏ %1 אינה קיימת.",
    'ip_alias__ip_address_and_mask' => 'כתובת IP ומסיכת רשת משנה',
    'ip_alias__mask' => "‫מסיכת רשת משנה‬",
    'ip_alias__remove_selected_ip_aliases?' => "האם אתה בטוח שברצונך להסיר את כתובות ה-IP שנבחרו?",
    'ip_alias__select_ip' => "בחר כתובת IP אחת לפחות מהרשימה כדי להסיר אותה.",
    'ip_alias__this_ip_used_for_domain' => "(%1) כתובת IP זו משמשת עבור הדומיין %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) כתובת IP זו משמשת עבור מארחים וירטואליים מבוססי שמות.",
    'ip_alias__unable_add_ip' => "לא ניתן להוסיף IP:‏ %1",
    'ip_alias__unable_remove_ip' => "לא ניתן להסיר IP:‏ %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "לא ניתן לשנות את סוג כתובת ה-IP למשותפת, כי זה יהפוך FTP אנונימי עבור הדומיין '%1' ללא זמין.",
    'ip_ctrl__ip_addr' => "כתובת IP‏ %2 בממשק %1",
    'ip_ctrl__ip_exists_many_pools' => "לא ניתן לשנות את סוג ה-IP. כתובת IP זו שייכת למאגרים של כמה משתמשים באותו זמן.",
    'ip_ctrl__ssl_cert' => "אישור SSL/TLS",
    'limit__date_in_past' => "תקופת החוקיות אינה חוקית. %1 נמצא בעבר.",
    'limit__enter_date' => "הזן תאריך",
    'limit__max_db' => "מסדי נתונים",
    'limit__name_disk_space' => "שטח דיסק",
    'limit__name_max_box' => "תיבות דואר",
    'limit__name_max_db' => "מסדי נתוני MariaDB/MySQL",
    'limit__name_max_dom' => "דומיינים",
    'limit__name_max_maillists' => "רשימות דיוור",
    'limit__name_max_subdom' => "תת-דומיינים",
    'limit__name_max_traffic' => "תעבורה",
    'limit__name_max_wu' => "משתמשי אינטרנט",
    'limit__name_mbox_quota' => "מיכסת תיבת דואר",
    'limit__name_max_mn' => "חשבונות דואר אלקטרוני",
    'limit__name_max_cl' => 'לקוחות',
    'limit__name_total_mboxes_quota' => "מיכסה כוללת של תיבת דואר",
    'limit__name_mysql_dbase_space' => "שטח מסד נתוני MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "שטח מסד נתוני MSSQL",
    'limit__name_pgsql_dbase_space' => "שטח מסד נתוני PostgreSQL",
    'limit__name_expiration' => 'תאריך תפוגה',

    'locale_upload__unable_to_install' => 'לא ניתן להתקין את קובץ ערכת השפה',
    'locale_upload__wrong_package' => 'הקובץ שהעלית אינו מכיל ערכת שפה חוקית עבור גירסת Plesk.',
    'locale_upload__wrong_locale' => 'הקובץ שהעלית אינו מכיל ערכת שפה חוקית.',

    'ma__create_title' => 'יוצר כינוי דואר עבור %1',
    'ma__edit_title' => "ערוך את כינוי הדואר %1",
    'ma__enter_new_alias' => "הזן כינוי חדש.",
    'ma__invalid_alias' => "כינוי דואר לא חוקי.",
    'ma__mail_aliases_mailname' => "כינויי דואר עבור חשבון הדוא\"ל %1",
    'ma__mailname_does_not_exist' => "חשבון הדוא\"ל אינו קיים.",
    'ma__select_ma_for_remove' => "בחר כינויי דואר שיוסרו.",
    'ma__unable_to_add_new_ma' => "לא ניתן להוסיף כינוי דואר: %1",

    'mail_queue__not_allowed_by_license_key' => 'מפתח הרישיון לא מתיר ניהול תור דואר.',
    'maillist__' => "רשימת הדיוור %1",
    'maillist__already_exists' => "רשימת הדיוור כבר קיימת.",
    'maillist__mail_alias_already_exists_in_this_domain' => "בדומיין זה כבר קיים כינוי הדואר %1",
    'maillists__' => "רשימת דיוור %1",
    'maillists__limit_cl_max_maillists' => "המערכת הגיעה למגבלה על מספר רשימות הדיוור עבור הלקוח (מגבלה: %1, בשימוש: %2)",
    'maillists__limit_dom_max_maillists' => "המערכת הגיעה למגבלה על מספר רשימות הדיוור עבור הדומיין.",
    'maillists__list' => "רשימות דיוור",
    'maillists__mailman_not_installed_or_conf' => "הרחבות שרת Mailman אינן מותקנות כרגע בשרת או שתצורתן לא נקבעה. פנה אל מנהל השרת כדי להתקין את הרחבות השרת Mailman או לקבוע את תצורתן כראוי.",
    'maillists__status' => "שירות רשימות הדיוור מופעל",
    'maillists__unable_to_delete__' => "לא ניתן למחוק את רשימת הדיוור: %1",
    'maillists__disabled_text' => 'לא ניתן לנהל רשימות דיוור מכיוון שרכיב שרת רשימות הדיוור Mailman אינו מותקן או שלא נקבעה תצורתו.',
    'maillist_member__already_exists' => 'מנוי רשימת הדיוור כבר קיים.',
    'maillist_member__not_exists' => 'אין משתמש כזה ברשימת הדיוור.',
    'mailserver_switching_warning' => "אזהרה!  \n  \n שינוי שרת דואר מיועד רק עבור הגדרה ראשונית, ואם השרת כבר נמצא בשימוש, השינוי יגרום לבעיות הבאות: איבוד תוכן תיבות דואר והגדרות, ובמקרים שתצורת השרת אליו עברת כבר נקבעה, גם התנגשויות שונות.  \n אם השרת נמצא בשימוש כעץ ואתה בטוח לגבי מעבר לשרת אחר, באפשרותך לדווח ללקוחות שלך לגבי הפעולה, כך שיוכלו להוריד את הדואר שלהם ולשמור אותו.",
    'manager__access_denied' => "הגישה נדחתה: %1",
    'manager__admin' => "מנהל מערכת",
    'manager__client' => 'לקוח',
    'manager__domain' => "דומיין",
    'manager__domain_cl_limit_exceeding' => "המערכת מגיעה למגבלה על מספר הדומיינים עבור חשבון לקוח זה.",
    'manager__domain_is_not_yours' => "הדומיין %1 אינו שייך לך.",
    'manager__domain_key_limit_exceeding' => "המערכת הגיעה למגבלה על יצירת דומיינים שהוגדרה על ידי מפתח הרישיון שלך.",
    'manager__no_perm_to_call' => "אין לך את ההרשאה להתקשר ל-%1.",
    'manager__no_perm_to_create_domains' => "אין לך את ההרשאה ליצור דומיינים.",
    'manager__no_perm_to_modify_domain' => "אין לך את ההרשאה לשנות את הדומיין %1.",
    'manager__no_perm_to_modify_domains' => "אין לך את ההרשאה לשנות דומיינים.",
    'manager__no_perm_to_remove_domain' => "אין לך את ההרשאה להסיר את הדומיין %1.",
    'manager__no_perm_to_remove_domains' => "אין לך את ההרשאה להסיר דומיינים.",
    'manager__node_doesnt_exist' => "%1 אינו קיים.",
    'manager__user_disabled' => "החשבון שלך מושעה. אינך יכול להפעיל את המערכת.",
    'mail_quota_unsupported' => "לא נתמך על ידי שרת הדואר",
    'mbox_quota_unsupported' => "לא נתמך על ידי שרת הדואר",
    'mn__create_title' => "צור חשבון דוא\"ל",
    'mn__edit_title' => "‫הגדרות‬",
    'mn__files_list_title' => "קבצים מצורפים",
    'mn__files_remove' => "הסר קבצים ממאגר הקבצים המצורפים. כנראה שמענה אוטומטי השתמש בקבצים אלה. הם יוסרו הן מהמאגר והן מהמענה האוטומטי שהשתמשו בהם.",
    'mn__files_select_for_remove' => "בחר קבצים שיוסרו.",
    'mn__mail_alias_form' => "צורת כינוי דואר",
    'mn__mail_aliases_list' => "כינויי דואר",
    'mn__mailbox' => "ניהול תיבת דואר",
    'mn__unable_define_mn' => "לא ניתן להגדיר חשבונות דוא\"ל: %1",
    'mn__unable_remove_mbox_quota' => "לא ניתן להסיר מיכסת תיבת דואר: %1",
    'mn__upload_file' => "העלה קובץ",
    'mn_edit__attach_filename_changed' => 'שם הקובץ שהועלה %1 שונה ל-%2 מכיוון שהשם המקורי הכיל תווים שאינם ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "עליך להוסיף חבר בקבוצת דואר לפני הפיכת קבוצת הדואר לזמינה.",
    'mn_edit__add_resp_or_turn_off_box' => "עליך להוסיף מענה אוטומטי או לנקות את תיבת הסימון של המענה האוטומטי.",
    'mn_edit__attachments' => "קבצים מצורפים",
    'mn_edit__dom_quota_less_then_quota' => "גודל תיבת דואר זו חייב שלא לחרוג מהמגבלה על כמות שטח הדיסק שהוקצתה עבור תיבות דואר בדומיין זה.",
    'mn_edit__enter_external_rcpnt_email' => "הזן כתובת דוא\"ל של חבר קבוצת דואר חיצוני",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "הקלד כתובת להעברת דואר הלאה או נקה את תיבת הסימון.",
    'mn_edit__ext_rcpnt_email_invalid' => "כתובת הדוא\"ל של הנמען החיצוני אינה חוקית.",
    'mn_edit__file_exists' => "קיימים קבצים. האם להחליף?",
    'mn_edit__files_deld_from_repository' => "קבצים אלה יימחקו מהמאגר ומהמענה האוטומטי המכילים אותם. האם ברצונך להמשיך?",
    'mn_edit__mail_name' => "חשבון דואר אלקטרוני",
    'mn_edit__mail_name_invalid' => "שם חשבון הדוא\"ל אינו חוקי.",
    'mn_edit__mail_redir' => "רכיבי העברת דואר",
    'mn_edit__mail_redir_add' => "הוספת חבר בקבוצת דואר",
    'mn_edit__mail_resps' => "מענה אוטומטי של דואר",
    'mn_edit__mailbox' => "תיבת דואר",
    'mn_edit__enable_mailbox' => "תיבת דואר",
    'mn_edit__mailgroup' => "קבוצת דואר",
    'mn_edit__mailgroup_addresses' => "חברים בקבוצת דואר",
    'mn_edit__mailgroup_disabled' => "זמין רק כאשר חשבון דוא\"ל כבר נוסף.",
    'mn_edit__max_dom_quota' => "ברירת מחדל עבור הדומיין (%1)",
    'mn_edit__mbox_quota_invalid' => "צוין גודל שגוי של תיבת דואר.",
    'mn_edit__new_resp_name' => "שם מענה אוטומטי חדש",
    'mn_edit__no_autoresponders' => "עליך להוסיף מענה אוטומטי אחד לפחות לפני שתכבה/תפעיל את שירות המענה האוטומטי.",
    'mn_edit__no_file_sel' => "לא נבחרו קבצים.",
    'mn_edit__no_mail_addresses' => "לא צוינו או נבחרו כתובות דוא\"ל.",
    'mn_edit__none' => "ללא",
    'mn_edit__not_create_pass' => "הדבר לא יביא ליצירת סיסמה עבור חשבון זה. ללא סיסמה, המשתמש לא יוכל להציג ולשלוח דואר.",
    'mn_edit__redir_email_invalid' => "העברת כתובת הלאה אינה חוקית.",
    'mn_edit__redirect_addr' => "מעביר כתובת הלאה",
    'mn_edit__remove_autoresp?' => "האם אתה בטוח שברצונך להסיר את המענה האוטומטי?",
    'mn_edit__remove_rcpnts?' => "האם אתה בטוח שברצונך להסיר נמענים אלה?",
    'mn_edit__repository' => "מאגר",
    'mn_edit__resps_attach' => "קבצים מצורפים של מענה אוטומטי",
    'mn_edit__select_rcpnt_from_list' => "בחר נמען אחד לפחות מהרשימה כדי להסיר אותו.",
    'mn_edit__select_registered_users' => "בחר משתמשים רשומים",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "בחרת לקבל תיבת דואר, אך לא הגדרת כתובת עבורה.",
    'mn_edit__unable_act_deact_mail_group' => "לא ניתן להפעיל או להשבית קבוצת דואר: %1",
    'mn_edit__unable_act_deact_mail_redir' => "לא ניתן להפעיל או להשבית העברת דואר: %1",
    'mn_edit__unable_act_deact_postbox' => "לא ניתן להפעיל או להשבית תיבת דואר: %1",
    'mn_edit__unable_act_deact_resp' => "לא ניתן להפעיל או להשבית מענה אוטומטי: %1",
    'mn_edit__unable_add_attach' => "לא ניתן להוסיף קובץ מצורף: %1",
    'mn_edit__unable_add_mail_group_member' => "לא ניתן להוסיף חבר בקבוצת דואר: %1",
    'mn_edit__unable_add_resp' => "לא ניתן להוסיף מענה אוטומטי: %1",
    'mn_edit__unable_change_mail_name' => "לא ניתן לשנות שם חשבון דוא\"ל: %1",
    'mn_edit__unable_deactivate_mail_group' => "לא ניתן להשבית קבוצת דואר: %1",
    'mn_edit__unable_deactivate_resp' => "לא ניתן להשבית מענה אוטומטי של דואר: %1",
    'mn_edit__unable_define_resp_id' => "לא ניתן להגדיר מזהה של מענה אוטומטי: %1",
    'mn_edit__unable_remove_attach' => "לא ניתן להסיר קבצים מצורפים: %1",
    'mn_edit__unable_remove_autoresp' => "לא ניתן להסיר מענה אוטומטי: %1",
    'mn_edit__unable_remove_mail_group_member' => "לא ניתן להסיר חברים בקבוצת דואר: %1",
    'mn_edit__wrong_way' => 'ההודעות הממוענות ל-%1 לא יועברו, מאחר שאין לחשבון דוא"ל זה תיבת דואר או רכיב העברה פעילים.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'תיבת הדואר בכתובת %1 כובתה. ההודעות בתיבת הדואר לא הוסרו, אך לא תוכל לאחזר אותן באמצעות פרוטוקול IMAP או POP3.',
    'mn_list__mail_names_for_domain' => "חשבונות דוא\"ל תחת הדומיין %1",
    'mn_list__sa_cannot_unable' => "לא ניתן להפעיל סינון הודעות זבל",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'לקוח',
    'mn_list__tab_title_domain' => 'דומיין',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "שם",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "לא ניתן להסיר את חשבונות הדוא\"ל: %1",
    'module_upload__module_was_installed' => 'מודול זה כבר מותקן. אם ברצונך להתקין גירסה חדשה יותר של מודול זה, הסר את המודול באמצעות Plesk, ולאחר מכן נסה להתקין.',
    'module_upload__unable_to_install' => 'לא ניתן להתקין את קובץ חבילת המודול',
    'module_upload__wrong_package' => 'הקובץ שהועלה אינו תומך בחבילת מודול.',
    'module_upload__wrong_module' => 'הקובץ שהועלה אינו מכיל חבילת מודול.',

    'news_articles_title' => 'חדשות Plesk',
    'notification_text__invalid_subject_length' => "אורך נושא הודעה לא חוקי. עליו להיות בין 1 ל-255 תווים.",
    'notification_text__invalid_text_length' => "אורך טקסט הודעה לא חוקי. עליו להיות בין 1 ל-65533 תווים.",
    'notification_text__subject' => "נושא הודעה",
    'notification_text__text' => "טקסט הודעה",
    'notification_text__title' => "ערוך הודעה",
    'notification_text__unable_set_text' => "לא ניתן לשנות טקסט הודעה:",

    'odbc__cant_add_dsn' => "לא ניתן להוסיף את ה-DSN‏ %1:‏ %2",
    'odbc__cant_connect' => "לא ניתן להתחבר למקור הנתונים באמצעות ההגדרות שהוגדרו. השרת החזיר: %1",
    'odbc__cant_delete_dsn' => "לא ניתן למחוק את ה-DSN‏ %1:‏ %2",
    'odbc__cant_get_drivers_info' => "לא ניתן להשיג מידע על מנהלי התקנים.",
    'odbc__cant_get_drivers' => "לא ניתן לאחזר רשימה של מנהלי התקנים ODBC:‏ %1",
    'odbc__cant_open_info_file' => "לא ניתן לפתוח את הקובץ עם מידע כל מנהלי התקני ODBC.",
    'odbc__cant_parse_string' => "לא ניתן לפרש את מחרוזת החיבור.",
    'odbc__driver_not_set' => "מנהל התקן אינו מוגדר",
    'odbc__driver_or_name_not_set' => "לא הוגדרו מנהל ההתקן או השם של חיבור ה-ODBC",
    'odbc__dsn_already_exists' => "כבר קיים במערכת DSN בשם זה (%1)",
    'odbc__dsn_not_exists' => "DSN זה אינו קיים",
    'odbc__enter_dsn_name' => "הזן שם DSN",
    'odbc__invalid_dsn_name' => "תחביר שגוי עבור שם חיבור ODBC (%1): השתמש בסימנים אלפאנומריים בלבד.",
    'odbc__no_such_driver' => "מנהל התקן ODBC בשם כזה (%1) אינו נתמך.",
    'odbc__unknown_driver' => "שם מנהל התקן לא מוכר (%1).",
    'odbc_dsn_system' => "DSN",

    'pb__aliases' => "כינויים",
    'pb__anonftp' => "FTP אנונימי",
    'pb__autoinstaller_releases' => 'מעדכן',
    'pb__cert' => "אישורים",
    'pb__cl_pool' => "כתובות IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "‫הגדרות‬",
    'pb__cl_rpt' => "דוח",
    'pb__cl_rpt_list' => "התאמה אישית",
    'pb__cl_templates' => "תבניות לקוח",
    'pb__cl_traffic' => "תעבורה",
    'pb__cl_traffic_history' => "היסטוריית תעבורה",
    'pb__cl_traffic_of' => "התעבורה של %1",
    'pb__client' => "%1",
    'pb__clients' => "לקוחות",
    'pb__comp_info' => "רכיבי שרת",
    'pb__common_acl' => 'אפשור העברת ACL',
    'pb__cp_access' => "גישה",
    'pb__crontab' => "מתזמן",
    'pb__scheduler' => "מתזמן",
    'pb__custom_buttons' => "לחצנים מותאמים אישית",
    'pb__databases_db' => 'מסדי נתונים',
    'pb__sqlservers_db' => 'שרתי SQL', //to check
    'pb__db' => "מסדי נתונים",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'שרתי מסד נתונים',
    'pb__dl_usr_ed' => "מנהל דומיין",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "מגבלות דומיין",
    'pb__dom_pref' => "‫הגדרות‬",
    'pb__dom_sum_report' => "דוח סיכום דומיין",
    'pb__dom_templates' => "תבניות דומיינים",
    'pb__dom_traffic' => "התעבורה של %1",
    'pb__domains' => "דומיינים",
    'pb__domain_aliases' => 'כינויי דומיינים',
    'pb__dumps_list' => "אחסון קובצי גיבוי",
    'pb__forwarding_setup' => "הגדרת העברה הלאה",
    'pb__filemanager' => "מנהל הקבצים",
    'pb__ip_aliasing' => "כתובות IP",
    'pb__ip_clients' => "הסרת כתובות IP",
    'pb__license_management' => 'פרטי רישיון',
    'pb__locales' => 'אזורים',
    'pb__log_files' => "קובצי יומן רישום",
    'pb__mail' => 'דואר',
    'pb__mail_name_files' => "קבצים מצורפים",
    'pb__mail_name_redirects' => "רכיבי העברת דואר",
    'pb__mail_name_resp_attach_add' => "קובץ מצורף חדש",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "מענה אוטומטי של דואר",
    'pb__mail_names' => "דואר",
    'pb__maillists' => "רשימות דיוור",
    'pb__modules' => 'מודולים',
    'pb__modules_management' => 'ניהול מודולים',
    'pb__notifications' => "הודעות",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "הגדרת אחסון אתרים פיזי",
    'pb__prtd_dirs' => "ספריות מוגנות",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "התאמה אישית",
    'pb__server' => "שרת",
    'pb__sessions' => "הפעלות",
    'pb__sapp_pool' => "מאגר יישומי אינטרנט",
    'pb__siteapp_install' => 'התקנת יישומי אינטרנט',
    'pb__site_app_pkgs' => 'יישומי אינטרנט',
    'pb__site_apps' => "יישומי אינטרנט",
    'pb__additional_key_info' => 'מאפייני מפתח',
    'pb__additional_key_properties' => 'מאפייני מפתח',
    'pb__skins' => 'מעטפות',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "מסנן הודעות זבל",
    'pb__statistics' => "‫נתונים סטטיסטיים‬",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "תת-דומיינים",
    'pb__templates' => "תבניות",
    'pb__virtualdirs' => 'ספריות וירטואליות',
    'pb__web_users' => "משתמשי אינטרנט",
    'pdir__invalid_hst' => "סוג אחסון האתרים אינו חוקי. חייב להיות פיזי.",
    'pdir__pd_id_is_undefined' => "מזהה הספריה המוגנת אינו מוגדר.",
    'pdir__pdir_exist' => "ספריה בשם זה כבר מוגנת.",
    'pdir__pdir_not_exist' => "הספריה המוגנת אינה קיימת.",
    'pdir__pdir_usr_not_exist' => "משתמש הספריה המוגנת אינו קיים.",
    'pdir__remove_pdir_usrs' => "יוסרו המשתמשים הבאים של הספריה המוגנת %2 תחת אתר האינטרנט %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "יוסרו המשתמשים הבאים של הספריה המוגנת %2 תחת התת-דומיין %1:",
    'pdir__select_pdir_usrs_for_remove' => "בחר את משתמשי הספריה המוגנת שיוסרו.",
    'pdir__select_pdirs_to_remove' => "בחר את הספריות שתוסר מהן ההגנה.",
    'pdir__unable_define_pdir_users' => "לא ניתן להגדיר את משתמשי הספריה המוגנת.",
    'pdir__unable_define_pdirs_properties' => "לא ניתן להגדיר את מאפייני הספריות: %1",
    'pdir__unable_select_dom_param' => "לא ניתן לבחור פרמטרים של דומיין: %1",
    'pdir_ed__dir_already_protect' => "ספריה זו כבר מוגנת.",
    'pdir_ed__invalid_login' => "ציינת שם משתמש שגוי.",
    'pdir_ed__login_exists' => "משתמש זה כבר קיים. נסה לציין שם משתמש אחר.",
    'pdir_ed__pdir_users' => "משתמשי ספריה מוגנת",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "יש לבחור תיבת סימון אחת לפחות מתיבות סימון SSL/TLS ולא-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "לא ניתן ליצור את משתמש הספריה המוגנת: %1",
    'pdir_ed__unable_create_pdir' => "לא ניתן ליצור את הספריה המוגנת: %1",
    'pdir_ed__unable_define_hst_type' => "לא ניתן להגדיר את סוג אחסון האתרים.",
    'pdir_ed__unable_update_pdir' => "לא ניתן לשמור הגדרות עבור הספריה המוגנת: %1",
    'pdir_ed__wrong_symbol_in_header' => "אין להשתמש בתו %1 בכותר הספריה.",
    'pdir_usr_ed__not_create_pass' => "הדבר לא יביא ליצירת סיסמה עבור המשתמש החדש של הספריה המוגנת. ללא סיסמה, המשתמש לא יוכל להיכנס למערכת.",
    'pdir_usr_ed__unable_select_pdir_usr' => "לא ניתן לבחור את משתמש הספריה המוגנת: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "לא ניתן להגדיר את משתמשי הספריה המוגנת: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "לא ניתן להסיר את משתמשי הספריה המוגנת: %1",
    'phosting__anonftp_encrypt' => 'הסיסמה של משתמש FTP מוצפנת, ולכן לא ניתן להשתמש בה להגנת הספריה /plesk-stat/webstat/. הזן מחדש את סיסמת ה-FTP שלך או בחר באפשרות "נגיש דרך הספריה המוגנת בסיסמה \'‎/plesk-stat/webstat/‎\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "שם הדומיין %%domain_name%% מפוענח לכתובת ה-IP‏ %%dns_ip_address%. אתר האינטרנט שלך מוקצה לכתובת ה-IP‏ %%hosting_ip_address%%. אם אתר האינטרנט שלך אינו נפתח בדפדפן אינטרנט כאשר אתה מפנה אליו באמצעות שם הדומיין שלו, עבור אל מסך ניהול ה-DNS ('דומיינים'> 'שם דומיין'> DNS) ושנה את המאפיינים של רשומת המשאב A: הקצה את כתובת ה-IP‏ %%hosting_ip_address%% לשם הדומיין %%domain_name%%.",
    'phosting__ip_change_warning' => "כתובת IP שונתה. השינויים המתאימים גם כן נעשו באזור ה-DNS של הדומיין.",
    'phosting__other_hosting_exists_on_ip' => "לא ניתן לשנות את האישור מכיוון שכתובת ה-IP שלו נמצאת בשימוש של חשבון אחסון אתרים אחד או יותר.",
    'phosting__unable_to_change_certificate' => "לא ניתן להתקין את האישור: %1",
    'phosting__unable_to_change_ip_address' => "לא ניתן לשנות את כתובת ה-IP‏: %1",
    'phosting__unable_to_set_cert' => "לא ניתן להגדיר את  אישור ה-SSL/TLS:‏ %1",
    'phosting__unable_update' => "לא ניתן לעדכן הגדרות אחסון אתרים: %1",
    'phosting__unable_manage' => "לא ניתן לנהל אחסון אתרים: %1",
    'phosting__failed_to_add_logs_fail2ban' => "לא ניתן היה להגדיר את fail2ban למעקב אחר יומני הרישום של הדומיין. המעקב אחר יומני הרישום יתבצע באופן אוטומטי בפעם הבאה ששירות fail2banיופעל מחדש.\n%1",

    'picker_acl_record__tittle' => 'בחר רשומת ACL',
    'picker_autoresponder__title' => 'בחר מענה אוטומטי',
    'picker_black_list__domain_name' => 'בחר שם דומיין',
    'picker_certificate' => 'בחר  אישור SSL/TLS',

    'picker_dns_zone_template__title' => 'בחר רשומת משאב',
    'picker_domain__title' => 'בחר אתר אינטרנט',
    'picker_domain_alias__title' => 'בחר כינוי דומיין',
    'picker_resource_record__title' => 'בחר רשומת משאב',
    'picker_disabled_resource_record__title' => 'בחר שרת שמות',
    'picker_ip_address__title' => 'בחר כתובת IP',
    'picker_ip_address_clients__title' => 'בחר לקוחות שמשתמשים בכתובת IP זו',
    'picker_mail_queue' => 'בחר הודעות דוא"ל',
    'picker_site_application__title' => 'בחר יישום אינטרנט',
    'picker_subdomain__title' => 'בחר תת-דומיין',
    'picker_web_user__title' => 'בחר משתמש אינטרנט',
    'picker_custom_button__title' => 'בחר לחצן מותאם אישית',
    'picker_license_key__title' => "בחירת מפתח רישיון",
    'picker_spamfilter_address__title' => 'בחר כתובת מסנן הודעות זבל',
    'picker_white_list__networks' => 'בחירת רשתות',

    'plesk_key__action_logs' => "רישום של פעולות שמבצעים משתמשי Plesk",
    'plesk_key__app_vault' => "מאגר יישומים",
    'plesk_key__backup' => "פונקציות גיבוי ושחזור",
    'plesk_key__client_templs' => "ניהול תוכניות שירות",
    'plesk_key__clients' => "חשבונות משתמשים (משווקים ולקוחות)",
    'plesk_key__resellers_only' => "חשבונות משתמשים (משווקים)",
    'plesk_key__customers_only' => "חשבונות משתמשים (לקוחות)",
    'plesk_key__domains' => "דומיינים",
    'plesk_key__domain_aliases' => "כינויי דומיינים",
    'plesk_key__subdomains_limit' => "תת-דומיינים",
    'plesk_key__databases' => "מסדי נתונים",
    'plesk_key__mssql_databases' => "מסדי נתוני MS SQL",
    'plesk_key__manage_dashboard' => 'התאמה אישית של דף הבית',
    'plesk_key__drweb' => "ניהול אנטי-וירוס",
    'plesk_key__event_manager' => "מנהל אירועים",
    'plesk_key__expirations' => "ניהול תאריכי תפוגה של חשבונות",
    'plesk_key__group_ops' => "שינוי מספר אובייקטים בבת אחת",
    'plesk_key__expiration' => "תאריך תפוגה של מפתח",
    'plesk_key__edition_name' => "מהדורת Plesk",
    'plesk_key__key_number' => "מספר מפתח",
    'plesk_key__languages' => "ערכות שפה",
    'plesk_key__mailnames' => "חשבונות דואר אלקטרוני",
    'plesk_key__migration_manager' => "מנהל הגירה והעברה",
    'plesk_key__mssql' => "תמיכה ב-Microsoft SQL Server",
    'plesk_key__myplesk_func' => "קישורים לרכישת אישורי SSL/TLS ושירותי רישום דומיינים",
    'plesk_key__myplesk_server_id' => "מזהה שרת נשלט MPC",
    'plesk_key__notifications' => "ניהול הודעות",
    'plesk_key__postgresql' => "תמיכה בשרת מסד נתונים PostgreSQL",
    'plesk_key__qmail_queue' => 'ניהול תור דואר',
    'plesk_key__remote_db' => 'אחסון מסד נתונים מרוחק',
    'plesk_key__slave_servers' => "שרתים נשלטים",
    'plesk_key__spamassassin' => "ניהול מסנן הודעות זבל",
    'plesk_key__subdomains' => "ניהול תת-דומיינים",
    'plesk_key__sys_access' => "ניהול הגישה לשרת",
    'plesk_key__traffic_reports' => "דוחות שימוש בתעבורה",
    'plesk_key__tts' => "מחלקת תמיכה",
    'plesk_key__virtuozzo' => "חוקי עבור גורמים מכילים של Virtuozzo בלבד",
    'plesk_key__webusers' => "משתמשי אינטרנט",
    'plesk_key__cpu_cores' => 'ליבות CPU',
    'plesk_key__ram' => 'זיכרון',
    'plesk_key__license_update_date' => 'עדכון מפתח הרישיון הבא',
    'plesk_key__autoinstaller_config' => 'ניהול הגדרות מעדכן',
    'plesk_key__check_wrong' => "מפתח הרישיון אינו חוקי. כדי להשתמש ב-Plesk, השג והתקן מפתח רישיון חוקי חדש.",
    'plesk_key__upload_check_wrong' => 'מפתח הרישיון שהועלה אינו חוקי.',
    'plesk_key__revert_check_wrong' => 'מפתח הרישיון הקודם שהותקן אינו חוקי.',
    'plesk_key__viruozzo_only_key' => 'מפתח הרישיון מיועד אך ורק לשימוש עם Plesk שפועל בתוך גורמים מכילים של Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'ניתן להשתמש בעותק מורשה זה של Plesk רק עם כתובות ה-IP הבאות: %2. כתובות ה-IP הבאות אינן מכוסות על ידי הרישיון שלך: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'כמות המשאבים שנמצאים כרגע בשימוש חורגת מהמגבלות שמגדיר הרישיון שלך.',
    'plesk_key__wp-toolkit-deluxe' => 'ערכת כלים WP דלוקס',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'מספר אתרי האינטרנט המתארחים בשרת חורג מהמגבלות שמגדיר הרישיון שלך. יש לך %2 אתרים מתארחים. הרישיון שלך מאפשר אחסון של %1 אתרים בלבד.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'מספר כינויי הדומיינים בשרת חורג מהמגבלות שמגדיר הרישיון שלך. יש לך %2 כינויי דומיינים. הרישיון שלך מאפשר אחסון של %1 כינויי דומיינים בלבד.',
    'plesk_key__limits_exceeded_lim-subdom' => 'מספר תתי הדומיינים בשרת חורג מהמספר המקסימלי שמוגדר ברישיון שלכם. יש לכם %2 תתי דומיינים. הרישיון שלכם מאפשר אחסון של %1 תתי דומיינים בלבד.',
    'plesk_key__limits_exceeded_lim-db' => 'מספר מסדי הנתונים בשרת חורג מהמספר המקסימלי שמוגדר ברישיון שלכם. יש לכם %2 מסדי נתונים. הרישיון שלכם מאפשר אחסון של %1 מסדי נתונים בלבד.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'מספר מסדי הנתונים מסוג MS SQL בשרת חורג מהמספר המקסימלי שמוגדר ברישיון שלכם. יש לכם %2 מסדי נתונים. הרישיון שלכם מאפשר אחסון של %1 מסדי נתונים בלבד.',
    'plesk_key__limits_exceeded_lim_cl' => 'מספר חשבונות הלקוחות שמקבלים שירות חורג מהמגבלות שמגדיר הרישיון שלך. יש לך %2 חשבונות לקוחות שמקבלים שירות כרגע. הרישיון שלך מאפשר מתן שירות ל-%1 חשבונות לקוחות בלבד.',
    'plesk_key__limits_exceeded_lim_mn' => 'מספר חשבונות הדוא"ל שמקבלים שירות חורג מהמגבלות שמגדיר הרישיון שלך. יש לך %2 חשבונות דוא"ל שמקבלים שירות כרגע. הרישיון שלך מאפשר מתן שירות ל-%1 חשבונות דוא"ל בלבד.',
    'plesk_key__limits_exceeded_lim_wu' => 'מספר חשבונות משתמשי האינטרנט שמקבלים שירות חורג מהמגבלות שמגדיר הרישיון שלך. יש לך %2 חשבונות משתמשי אינטרנט שמקבלים שירות כרגע. הרישיון שלך מאפשר מתן שירות ל-%1 חשבונות משתמשי אינטרנט בלבד.',
    'plesk_key__limits_exceeded_MLS' => 'מספר ערכות השפה המותקנות כרגע חורג מהמגבלות שמגדיר הרישיון שלך. ישנן %2 ערכות שפה מותקנות. הרישיון שלך מאפשר התקנה של %1 ערכות שפה בלבד.',
    'plesk_key__wrong_version' => '‫אתה מנסה להשתמש במפתח רישיון שנוצר עבור גירסה אחרת של Plesk.‬ ‫פנה לנציגי המכירות של Plesk כדי להשיג את מפתח הרישיון המתאים.‬',
    'plesk_key__other_product' => '‫אתה מנסה להשתמש במפתח רישיון שנוצר עבור מוצר אחר.‬ ‫פנה לנציגי המכירות של Plesk כדי להשיג את מפתח הרישיון המתאים.‬',
    'plesk_key__invalid_machine_id_trial' => 'הרישיון הנוכחי שלכם אינו בתוקף כי הוא כבר הופעל בשרת Plesk אחר. כדי להמשיך להשתמש ב-Plesk, התקינו רישיון חדש או התקינו את הרישיון הנוכחי שלכם פעם נוספים באמצעות הזנת קוד ההפעלה (אם יש לכם כזה).',
    'plesk_key__invalid_machine_id_retail' => 'הרישיון הנוכחי שלכם אינו בתוקף מפני שהוא כבר מופעל בשרת Plesk אחר.
WebPros EULA (https://www.plesk.com/legal/) אוסר על שימוש ברישיון יחיד בשני שרתים או יותר בו-זמנית. כדי להמשיך להשתמש ב-Plesk, התקינו רישיון חדש או התקינו שוב את הרישיון הנוכחי שלכם באמצעות הזנת קוד ההפעלה שלו. הוא נשלח אליכם באימייל בעת רכישת הרישיון.
<br>לא מוצאים את קוד ההפעלה? אפשר לאחזר אותו באמצעות Plesk 360. לשם כך, היכנסו ל-/https://platform360.io עם האימייל שבו השתמשתם לרכישת הרישיון, עברו ללשונית \'Licenses\', וראו את קוד ההפעלה של הרישיון שלכם. לחלופין, אפשר ליצור קשר עם התמיכה של Plesk Licensing and Purchase באמצעות הטופס המקוון (https://www.plesk.com/licensing-and-purchase-support/). זכרו לציין את מספר הרישיון שלכם במקטע "How can we help you?" בטופס.',
    'plesk_key__limits_exceeded_error' => 'לא ניתן להתקין את מפתח הרישיון: כמויות המשאבים שנמצאות כרגע בשימוש חורגות מהמגבלות שהוגדרו במפתח הרישיון שהועלה.',
    'plesk_key__limits_exceeded_note' => 'כמויות המשאבים שנמצאות כרגע בשימוש חורגות מהמגבלות שהוגדרו במפתח הרישיון שהועלה.',
    'plesk_key__hardware_limits_exceeded' => 'תצורת החומרה חרגה מהגבולות שהוגדרו על ידי רישיון Plesk.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'לשרת יש %1 מתוך הזיכרון שהותקן, אבל הרישיון שלכם לא מאפשר יותר מ-%2.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'לשרת יש %1 ליבות CPU שהותקנו, אבל הרישיון שלכם לא מאפשר יותר מ-%2.',
    'plesk_key__key_file_invalid' => 'קובץ המפתח שהועלה אינו חוקי או שאינו מכיל מפתח רישיון.',
    'plesk_key__server_request_error' => 'לא ניתן לעדכן את הרישיון. ודא שהחיבורים לשרת הרישיונות ka.plesk.com ביציאה %1 של ה-TCP נעולים. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">ראה כיצד לעשות זאת</a>.',
    'key__no_key_file_in_zip' => 'קובץ ה-zip. שהועלה אינו מכיל קובץ מפתח',
    'key__key_upload' => 'התקנת מפתח רישיון',
    'additional_key__prop_name' => 'מאפיין',
    'additional_key__prop_value' => 'ערך',
    'additional_key__descr_name' => 'שם מפתח',
    'additional_key__descr_key_number' => 'מספר מפתח',
    'additional_key__descr_key_vz' => "מפתח רישיון זה מיועד לשימוש אך ורק בגורמים מכילים של Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'תיבות דואר',
    'additional_key__descr_lim_date' => 'תאריך תפוגה',
    'additional_key__descr_license_update_date' => 'עדכון מפתח הרישיון הבא',
    'additional_key__file_invalid' => 'קובץ המפתח שהועלה אינו חוקי או שאינו מכיל מפתח רישיון.',
    'additional_key__file_incompatible' => 'קובץ המפתח שהועלה אינו חוקי עבור יישום זה.',
    'additional_key__not_exists' => 'אין מפתח רישיון מותקן.',
    'additional_key_update__result_response' => 'תגובת שרת רישוי: %1',
    'additional_key_update__result_network' => 'לא ניתן להתחבר לשרת הרישוי. ודא שהרשת שלך מאפשרת תקשורת עם %1: %2.',
    'additional_key_update__result_lock' => 'עדכון המפתח כבר מתבצע',
    'additional_key_update__result_internal_error' => 'אירעה שגיאה בעת עדכון מפתח הרישיון: %1',

    'proceed_to_cl_pool' => "המשך לקביעת תצורת מאגר ה-IP של הלקוח",
    'proceed_to_hosting_setup' => "המשך להגדרת אחסון אתרים",
    'removeCerts__remove_certificates_cp' => "האישורים הבאים יוסרו:",
    'removeCerts__remove_certificates_domain' => "האישורים הבאים בבעלות %1 יוסרו:",
    'removeClientsIP_remove_clients_ip' => "כתובת IP זו תוסר מהמאגרים של הלקוחות הבאים:",
    'removeMailAliases__remove_mail_aliases' => "כינויי הדואר הבאים עבור חשבון הדואר %1 יוסרו:",
    'removeMailNames__remove_mailnames' => "חשבונות הדוא\"ל וכינויי הדואר הבאים יוסרו מהדומיין %1:",
    'removeMailNames__remove_mailnames_of_cl' => "חשבונות הדוא\"ל וכינויי הדואר הבאים יוסרו מהדומיין %2 שבבעלות הלקוח %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "חשבונות דוא\"ל אלה לא יימחקו.",
    'removeFtpSessions__remove_title' => "הפעלות ה-FTP הבאות יופסקו:",
    'removeTemplates__remove_templates' => "התבניות הבאות יוסרו:",
    'resp_edit__always_respond' => "הגב תמיד",
    'resp_edit__reply_subject' => "נושא המענה",
    'resp_edit__answer_subject' => "השב עם נושא",
    'resp_edit__answer_txt' => "ענה עם טקסט",
    'resp_edit__attach' => "צרף קבצים",
    'resp_edit__default_subject' => "הנדון: %1",
    'resp_edit__for' => "עבור",
    'resp_edit__frw_rqst_email' => "עם התקבל התגובה האוטומטית, העבר את ההודעה המקורית לדוא\"ל שצוין",
    'resp_edit__fwd_email_invalid' => "כתובת הדואר האלקטרוני המוגדרת כיעד אינה חוקית.",
    'resp_edit__in_body' => "כאשר מילים שצוינו נמצאות בגוף ההודעה",
    'resp_edit__in_subject' => "כאשר מילים שצוינו נמצאות בנושא ההודעה",
    'resp_edit__invalid_resp_freq' => "תדירות התגובה אינה חוקית.",
    'resp_edit__invalid_rqst_txt' => "טקסט בקשה לא חוקי.",
    'resp_edit__invalid_store_lim_num' => "ערך המגבלה אינו חוקי.",
    'resp_edit__limits_title' => "מגבלות",
    'resp_edit__maximum_allowed_resp_freq_reached' => "מספר התגובות המרבי ליום חורג מהשיעור שהוגדר. מותר: %1, נדרש: %2",
    'resp_edit__no_files_sel' => "לא נבחרו קבצים.",
    'resp_edit__no_txt_supplied' => "לא סופק טקסט.",
    'resp_edit__reply_title' => "מענה",
    'resp_edit__reply_to_address' => "כתובת חזרה",
    'resp_edit__reply_to_invalid' => "כתובת החזרה אינה חוקית.",
    'resp_edit__reply_uniq_email' => "ענה לכתובת הדוא\"ל הייחודית לא יותר מאשר",
    'resp_edit__conditions_title' => "תנאים",
    'resp_edit__request_title' => "בקשה",
    'resp_edit__resp' => "מענה אוטומטי",
    'resp_edit__resp_name' => "שם מענה אוטומטי",
    'resp_edit__resp_not_exist' => "המענה האוטומטי אינו קיים.",
    'resp_edit__resp_status' => "מצב מענה אוטומטי",
    'resp_edit__rqst_txt' => 'ציין את התנאי עבור מענה אוטומטי זה',
    'resp_edit__select_files_on_server_for_attach' => "בחר את הקבצים שברצונך לצרף",
    'resp_edit__store_up_to' => "אחסן עד",
    'resp_edit__subj_line_invalid' => "שורת הנושא שגויה.",
    'resp_edit__text_too_big' => "טקסט הודעת המענה גדול מדי.",
    'resp_edit__times_in_a_day' => "פעמים ביום.",
    'resp_edit__unable_define_resp_cond' => "לא ניתן להגדיר את תנאי המענה האוטומטי: %1",
    'resp_edit__unable_define_resp_status' => "לא ניתן להגדיר מצב מענה אוטומטי: %1",
    'resp_edit__unable_turn_on_resp' => "לא ניתן להפעיל את המענה האוטומטי: %1",
    'resp_edit__uniq_email' => "כתובות דוא\"ל ייחודיות",
    'resp_edit__content_type' => 'תבנית שליחת דואר',
    'resp_edit__content_type_text' => 'טקסט רגיל',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'קידוד',
    'restart__dns' => 'שרת DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "שרת IMAP/POP3 (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "שרת MariaDB/MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "שירותים",
    'restart__smtp' => "שרת SMTP (%1)",
    'restart__spamd' => "מסנן הודעות זבל",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "שרת אינטרנט (%1)",
    'restart__ftp' => "שרת FTP (%1)",
    'restart__service_start' => '‫אפשר זמן מה עבור השירות כדי שיפעל.‬',
    'restart__service_stop' => '‫אפשר זמן מה עבור השירות כדי שיעצור.‬',
    'restart__service_restart' => '‫אפשר זמן מה עבור השירות כדי שיפעל מחדש.‬',
    'rm_domains__some_domains_are_not_exist' => "חלק מדומיינים שצוינו אינם קיימים. ייתכן שהם הוסרו על ידי משתמש אחר.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "קבוצות דואר",
    'rpt_cl_dom_mail_lists' => "רשימות דיוור",
    'rpt_cl_dom_mail_resps' => "תגובה אוטומטית",
    'rpt_cl_dom_mail_antispam' => "נגד הודעות זבל",
    'rpt_cl_dom_mail_antivirus' => "אנטי-וירוס",
    'rpt_cl_dom_postboxes' => "תיבות דואר",
    'rpt_cl_dom_redirects' => "רכיבי העברה",
    'rpt_cl_dom_subdomains' => "תת-דומיין",
    'rpt_cl_dom_domain_aliases' => "כינויי דומיינים",
    'rpt_cl_dom_web_users' => "משתמשי אינטרנט",
    'rpt_cl_report_for_admin__' => "‫דוח עבור מנהל המערכת %1‬",
    'rpt_cl_report_for_reseller__' => "‫דוח עבור המשווק %1‬",
    'rpt_cl_report_for_cl__' => "‫דוח על הלקוח %1‬",
    'rpt_cl_section_domains' => "דומיינים",
    'rpt_cl_section_full_domains' => "דומיינים",
    'rpt_cl_section_general' => "כללי",
    'rpt_create' => "צור דוח",
    'rpt_empty' => "על הדוח להכיל מקטע אחד לפחות",
    'rpt_dom_report_for_dom__' => "דוח דומיין עבור %1",
    'rpt_dom_section_databases' => "מסדי נתונים",
    'rpt_dom_section_full_databases' => "מסדי נתונים",
    'rpt_dom_section_full_maillists' => "רשימות דיוור",
    'rpt_dom_section_full_mailnames' => "חשבונות דואר אלקטרוני",
    'rpt_dom_section_full_webusers' => "משתמשי אינטרנט",
    'rpt_dom_section_full_siteapps' => 'יישומי אינטרנט',
    'rpt_dom_section_full_aspnetapps' => 'יישומי אינטרנט מסוג ASP.NET',
    'rpt_dom_section_general' => "כללי",
    'rpt_dom_section_hosting' => "אירוח",
    'rpt_dom_section_maillists' => "רשימות דיוור",
    'rpt_dom_section_mailnames' => "חשבונות דואר אלקטרוני",
    'rpt_dom_section_siteapps' => 'יישומי אינטרנט',
    'rpt_dom_section_aspnetapps' => 'יישומי אינטרנט מסוג ASP.NET',
    'rpt_dom_section_webusers' => "משתמשי אינטרנט",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "ערוך דוח %1",
    'rpt_enter_email_address' => "הזן את כתובת הדוא\"ל אליה יישלח הדוח.",
    'rpt_list' => "פריסות דוח מותאמות אישית",
    'rpt_section_full' => "מלא",
    'rpt_section_none' => "ללא",
    'rpt_section_summary' => "סיכום",
    'rpt_default_full' => 'דוח מלא',
    'rpt_default_summary' => 'דוח סיכום',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "שגיאה בשליחת הדוח: %1",
    'rpt_send_report_by_email_ok__' => "הדוח נשלח אל %1",
    'sa_action' => "פעולה",
    'sa_action_del' => "מחיקה",
    'sa_action_desc' => "מה לעשות עם דוא\"ל זבל",
    'sa_action_save' => "סמן כהודעת זבל ואחסן בתיבת דואר",
    'sa_admin_blacklist' => "רשימה שחורה של מנהל מערכת",
    'sa_admin_whitelist' => "רשימה לבנה של מנהל מערכת",
    'sa_db_del_confirm' => "האם אתה בטוח שברצונך לנקות את מסד הנתונים של מסנן הודעות הזבל?",
    'sa_eml_in_ignorelist' => "הדוא\"ל נמצא ברשימת ההתעלמות",
    'sa_empty_email' => "לא ניתן להוסיף תבנית דוא\"ל ריקה.",
    'sa_exists_email' => "כבר קיימת תבנית דוא\"ל כזו.",
    'sa_disabled__mailname_not_filtering' => "הגדרות השרת הנוכחיות אינן מאפשרות להשתמש בסינון דואר עבור חשבון דוא\"ל זה",
    'sa_disabled__filtering_is_disabled' => 'סינון הודעות זבל כובה על ידי מנהל השרת',
    'sa_disabled__hasnt_mailbox' => "לא ניתן להפעיל סינון הודעות זבל ללא תיבת דואר",
    'sa_enable_filter' => "הפעל סינון הודעות זבל",
    'sa_forget' => "שכח",
    'sa_from' => "מ-",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "התבנית אינה חוקית.",
    'sa_spam' => "הודעת זבל",
    'sa_trainer__page_title' => 'תרגול מסנן הודעות זבל',
    'sa_trainer__tools_legend' => 'כלים',
    'sa_trainer__info_legend' => 'מידע',
    'sa_trainer__messages_list_legend' => 'הודעות בתיבת הדואר שלך',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'נושא',
    'sa_trainer__from' => 'מ-',
    'sa_trainer__date' => 'תאריך',
    'sa_trainer__info_text' => 'הודעות שנלמדו: %1 כהודעת זבל, %2 כ-לא הודעת זבל, %3 בסך הכול.',
    'sa_trainer__messages' => 'הודעה/ות',
    'sa_trainer__select__all' => 'הכול',
    'sa_trainer__select__spam_only' => 'הודעת זבל',
    'sa_trainer__select__ham_only' => 'לא-הודעת זבל',
    'sa_trainer__select__unknown_only' => 'לא מוכר',
    'sa_trainer__cannot_remove_messages' => 'לא ניתן להסיר את ההודעות שנבחרו מתיבת הדואר.',
    'sa_trainer__remove_messages_confirm' => 'האם אתה בטוח שברצונך להסיר את ההודעות שנבחרו מתיבת הדואר?',
    'sa_subj' => "נושא",
    'sa_training' => "תרגול מסנן הודעות זבל",
    'sa_training_legend' => "תרגול סינון בייסיאני",
    'sa_use_srv_settings' => "השתמש בהגדרות של כלל השרתים",
    'sa_user_blacklist' => "רשימה שחורה של משתמש",
    'sa_user_whitelist' => "רשימה לבנה של משתמש",
    'sa_usr_disabled_by_srv' => "מנהל השרת אינו מתיר הגדרות סינון הודעות זבל נפרדות",
    'sa_usr_no_postbox' => "לא ניתן לאפשר סינון הודעות זבל, מכיוון שתיבת הדואר כבויה בחשבון דואר אלקטרוני זה.",
    'sa_filters' => 'מסנני הודעות זבל',
    'spamfilter__tools_legend' => 'כלים',
    'spamfilter__prefs_legend' => '‫הגדרות‬',
    'spamfilter__max_children' => 'המספר המרבי של תהליכי עובד spamd להרצה',
    'spamfilter__rewrite_header_subject_hint' => 'השאר שדה זה ריק אם אינך מעוניין להוסיף טקסט. הקלד _SCORE_ אם תרצה לכלול את הניקוד בנושא ההודעה.',
    'spamfilter__reject_spam' => 'מחק דוא"ל זבל כאשר הוא מגיע לתיבת הדואר',
    'spamfilter__enabled' => 'מופעל',
    'spamfilter_addresses_list__items' => 'כתובות',
    'spamfilter_addresses__remove_title' => 'הכתובות הבאות יוסרו מהרשימה:',
    'spamfilter_addresses__empty_selection' => 'לא נבחרו כתובות.',
    'server__admin_info' => "פרטי מנהל המערכת",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "הזן למטה את תיאור הבאג",
    'server__power_management' => "ניהול צריכת חשמל",
    'server__services' => "שירותים",
    'server__system' => "מערכת",
    'server__title' => "ניהול שרת",
    'server_preferences__admin_skin' => "מעטפת ממשק של מנהל מערכת",
    'server_preferences__default_language' => "שפת ברירת מחדל",
    'server_preferences__default_skin' => "מעטפת ברירת מחדל",
    'server_preferences__restart_apache_interval' => "מרווח זמן להפעלה מחדש של Apache",
    'server_preferences__system' => 'הגדרות מערכת',
    'mail__tabs_preferences' => "‫הגדרות‬",
    'mail__tabs_white_list' => "רשימה לבנה",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "חפש במילון את הסיסמאות עבור תיבות הדואר",
    'sessions__agreement' => "כן, אני מעוניין לסיים הפעלות אלה.",
    'sessions__select_sessions_for_remove' => "בחר את ההפעלות שיופסקו.",
    'sessions__tabs_cp_sessions' => 'הפעלות Plesk',
    'sessions__tabs_ftp_sessions' => '‫הפעלות FTP‬',
    'sessions__ftp_sessions_login' => 'שם משתמש חשבון FTP',
    'sessions__ftp_sessions_domain' => 'שם הדומיין',
    'sessions__ftp_sessions_path' => '‫מיקום נוכחי‬',
    'sessions__ftp_sessions_file' => 'שם קובץ',
    'sessions__ftp_sessions_action' => 'מצב',
    'sessions__ftp_sessions_speed' => '‫מהירות, KB/S‬',
    'sessions__ftp_sessions_comp' => '‫התקדמות, %‬',

    'site_apps__access_level' => 'רמת גישה',
    'site_apps__access_level_commercial' => 'מסחרי',
    'site_apps__access_level_free' => 'חינם',
    'site_apps__action_installer' => "התקנת יישומי אינטרנט",
    'site_apps__action_reconfigure' => "קביעה מחדש של תצורת יישום אינטרנט",
    'site_apps__custom_button_level' => 'האם תרצה ליצור לחצן מותאם אישית עבור גישה ליישום זה?',
    'site_apps__custom_button_level_false_domain_user_only' => '‫לא‬',
    'site_apps__custom_button_level_domain_user_only' => '‫כן‬',
    'site_apps__custom_button_level_false' => '‫לא‬',
    'site_apps__custom_button_level_domain' => 'כן, והפוך אותו לזמין עבור הדומיין הנוכחי בלבד',
    'site_apps__custom_button_level_client' => 'כן, והפוך אותו לזמין עבור כל הדומיינים של הלקוח',
    'site_apps__custom_button_level_admin' => 'כן, והפוך אותו לזמין עבור כל הדומיינים',
    'site_apps__description' => "‫תיאור‬",
    'site_apps__dir_used_by_sapp__' => "הספריה \"%1\" משמשת יישום אינטרנט אחר",
    'site_apps__dir_used_by_unknown__' => "הספריה \"%1\" כבר קיימת. אם תמשיך, התוכן שלה יוחלף.",
    'site_apps__dir_invalid_name__' => "שם הספריה %1 שגוי",
    'site_apps__file_name' => 'שם קובץ של יישום אינטרנט',
    'site_apps__invalid_install_prefix' => "קידומת התקנה לא חוקית",
    'site_apps__invalid_package' => "יישום האינטרנט אינו חוקי",
    'site_apps__key_status' => 'רישוי',
    'site_apps__key_status_free' => 'מופץ בחופשיות. לא נדרש מפתח רישיון',
    'site_apps__key_status_ok' => 'מותקן מפתח הרישיון הנדרש',
    'site_apps__key_status_problem' => 'מפתח הרישיון הנדרש אינו מותקן',
    'site_apps__name' => "שם",
    'site_apps__no_domains' => 'לא ניתן להתקין את יישום האינטרנט. כבר ישנו יישום אינטרנט אחר המותקן בספריית הבסיס של דומיין זה. מומלץ ליצור תת-דומיין עבור יישום האינטרנט.',
    'site_apps__package_info_' => "פרטי חומת אש של אפליקציית אינטרנט",
    'site_apps__package_integrated' => "יישום מובנה, לא ניתן להסרה",
    'site_apps__pool_select_packages_to_add' => 'בחר את יישומי האינטרנט שיוספו למאגר',
    'site_apps__release' => "מהדורה",
    'site_apps__resource_used_by_sapp' => "משאב זה נמצא בשימוש של יישום האינטרנט המותקן",
    'site_apps__root_used_by_sapp' => "משאב זה נמצא בשימוש של יישום אינטרנט מותקן",
    'site_apps__these_domains_will_not_delete' => '(תת-) דומיינים אלה לא יימחקו',
    'site_apps__upload_site_app_pkg_title' => 'העלה יישום אינטרנט חדש',
    'site_apps__version' => "גירסה",
    'site_apps__access_to' => "גישה אל %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "לא ניתן לפרק את אריזת הארכיון. ייתכן ש-Archiver אינו מותקן בשרת. פנה אל מנהל המערכת של {$PROD_NAME} כדי שתותקן אצלך תוכנת archiver.",
    'skeleton__archive_corrupted' => "בבדיקת הארכיון התגלה שקובץ הארכיון פגום או שסוג ארכיון זה אינו נתמך.",
    'skeleton__archive_too_large' => "בבדיקת הארכיון התגלה שקובץ הארכיון גדול מדי.",
    'skeleton__not_supported_archive_type' => "סוג זה של ארכיון (קובץ %1) אינו נתמך.",
    'skin_download__title' => 'הורדת מעטפת',
    'skin_download_now__title' => 'הורדת המעטפת מתבצעת',
    'skin_download_now__text' => 'יצירת חבילת המעטפות מתבצעת.<br>פרוצדורה זו עשויה להימשך זמן מה.<br>עם הופעת חלון הדו-שיח, ניתן להמשיך לעבוד עם Plesk.',
    'skin_file__help_for_using_types' => "השתמש בארכיוני המעטפות באחת מהתבניות הבאות:",
    'skin_info__title' => 'מאפייני מעטפת',
    'skin_mng_err__rpm_not_skin' => 'ה-RPM אינו חבילת מעטפות של Plesk',
    'skin_mng_err__psa_install_noreloc' => 'נכשלה התקנת מעטפת מבוססת rpm במיקום שצוין.',
    'skin_mng_err__already_exists' => 'ספריית התקנת המעטפות כבר קיימת, וישנה חבילת מעטפות פרוסה.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'הקובץ שהועלה אינו חבילת מעטפות RPM חוקית.',
    'skin_mng_err__rpm_upgrade_noskin' => 'הקובץ שהועלה אינו חבילת מעטפות חוקית.',
    'skin_mng_err__rpm_upgrade_base' => "הקובץ שהועלה אינו חבילת מעטפות חוקית של {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'לא ניתן להתקין את המעטפת: תבנית מעטפת לא חוקית.',
    'skin_mng_err__no_a_skin' => "הקובץ שהועלה אינו חבילת מעטפות חוקית של {$PROD_NAME}.",
    'skin_upload__title' => 'העלאת מעטפת חדשה',
    'skin_upload__already_exists' => "המעטפת '%1' כבר קיימת.",
    'skin_upload__unable_to_apply' => "הקובץ שהועלה אינו מכיל מעטפת של Plesk, או שתבנית הארכיון אינה נתמכת.",
    'skin_upload__unable_to_rename__' => "לא ניתן להחליף את שם המעטפת %2 ל-%1: %3.",
    'skin_upload__file_name' => 'נתיב לקובץ חבילת המעטפות',
    'skins_list__title' => 'מאגר מעטפות',
    'skins_remove__title' => 'הסרת מעטפת',
    'skins_remove__select_skins_for_remove' => 'בחר את המעטפות שיוסרו',

    'spf__unable_update' => 'לא ניתן לעדכן פרמטרים של SPF',
    'statistics__active_domains' => "דומיינים פעילים",
    'statistics__clients' => "לקוחות",
    'statistics__subdomains' => "תת-דומיינים",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "מסדי נתונים",
    'statistics__db_users' => "משתמשי מסד נתונים",
    'statistics__dirs' => "ספריות מוגנות",
    'statistics__dom_active' => "פעיל",
    'statistics__dom_passive' => "פסיבי",
    'statistics__dom_problem' => "בעיה",
    'statistics__domains' => "דומיינים",
    'statistics__domains_with_host' => "דומיינים עם אחסון אתרים",
    'statistics__doms' => "דומיינים",
    'statistics__filesystem' => "מערכת קבצים",
    'statistics__general' => "כללי",
    'statistics__hdd_available' => "זמין",
    'statistics__hdd_capacity' => "קיבולת",
    'statistics__hdd_total' => "סך הכול",
    'statistics__hdd_usage' => "שימוש בדיסק קשיח",
    'statistics__hdd_used' => "בשימוש",
    'statistics__ip' => "כתובת IP",
    'statistics__key_number' => "מספר מפתח",
    'statistics__l1' => "הדקה האחרונה",
    'statistics__l15' => "15 הדקות האחרונות",
    'statistics__l5' => "5 הדקות האחרונות",
    'statistics__la' => "שימוש ב-CPU",
    'statistics__mail_autoresponders' => "מענה אוטומטי",
    'statistics__mail_boxes' => "תיבות דואר",
    'statistics__mail_groups' => "קבוצות דואר",
    'statistics__mail_lists' => "רשימות דיוור",
    'statistics__mail_redirects' => "רכיבי העברת דואר",
    'statistics__mem' => "שימוש בזיכרון",
    'statistics__mem_usage' => "שימוש",
    'statistics__memory_available' => "זמין",
    'statistics__memory_buffer' => "מאגר",
    'statistics__memory_cached' => "מאוחסן במטמון",
    'statistics__memory_free' => "פנוי",
    'statistics__memory_shared' => "משותף",
    'statistics__memory_total' => "סך הכול",
    'statistics__memory_used' => "בשימוש",
    'statistics__os' => "מערכת הפעלה",
    'statistics__problem_clients' => "לקוחות בעייתיים",
    'statistics__problem_domains' => "דומיינים בעייתיים",
    'statistics__swap' => "שימוש בפעולת החלפה",
    'statistics__swap_free' => "פנוי",
    'statistics__swap_total' => "סך הכול",
    'statistics__swap_usage' => "שימוש",
    'statistics__swap_used' => "בשימוש",
    'statistics__system_stat' => "פרטי שרת",
    'statistics__unable_define_active_doms' => "לא ניתן לקבוע את מספר הדומיינים הפעילים: %1",
    'statistics__unable_define_inactive_doms' => "לא ניתן לקבוע את מספר הדומיינים הלא פעילים: %1",
    'statistics__failed_define_swap_usage' => 'הגדרת השימוש בפעולת החלפה נכשלה',
    'statistics__failed_define_load_averages' => 'הגדרת ממוצעי עומס נכשלה',
    'statistics__up_time' => "זמן פעולה רציפה של המערכת:",
    'statistics__ver' => "גירסה",
    'statistics__web_users' => "משתמשי אינטרנט",
    'statistics__mem_win' => "שימוש בזיכרון פיזי",
    'statistics__memory_total_win' => "סך הכול",
    'statistics__memory_used_win' => "בשימוש",
    'statistics__memory_free_win' => "זמין",
    'statistics__swap_win' => "שימוש בזיכרון וירטואלי",
    'statistics__swap_total_win' => "סך הכול",
    'statistics__swap_used_win' => "בשימוש",
    'statistics__swap_free_win' => "זמין",
    'status__domain_has_reasons_to_be_off' => "הדומיין עדיין מושעה מהסיבה הבאה: %1",
    'subdomain__create__' => "צור תת-דומיין בדומיין %1",
    'subdomain__edit__' => "נהל את תת-דומיין %1",
    'subdomain__invalid_name' => "שם תת-דומיין לא חוקי: השתמש בסימנים אלפאנומריים ובמקף בלבד.",
    'subdomain__incorrect_name' => "שם תת-דומיין לא חוקי.",
    'subdomains__maillists_enabled_in_domain' => "שם התת-דומיין lists.%1 שגוי: שם דומיין זה כבר נמצא בשימוש של רשימות דיוור תחת הדומיין %1.",
    'subdomains__dalias_exists' => 'כבר קיים כינוי דומיין בשם זה.',
    'subdomains__name_exists' => "כבר קיים תת-דומיין בשם כזה.",
    'subdomains__regular_domain_exists' => "כבר קיים דומיין בשם כזה.",
    'subdomains__domain_alias_exists' => 'כבר קיים כינוי דומיין בשם זה.',
    'subdomains__remove_subdomains_on_domain' => "התת-דומיינים הבאים של הדומיין %1 יוסרו:",
    'subdomains__select_subdomains_for_remove' => "בחר את התת-דומיינים שיוסרו.",
    'subdomains__webmail_enabled_in_domain' => "שם התת-דומיין webmail.%1 שגוי שם דומיין זה כבר נמצא בשימוש לגישה לדואר אינטרנט תחת הדומיין %1.",
    'subdomains__dns_record_already_exists' => 'לא ניתן ליצור את התת-דומיין %1, מכיוון שישנה כבר רשומת DNS שמצביעה אל המארח %1.',
    'subdomains__www_prefix_in_domain' => "שם התת-דומיין www.%1 שגוי: הדומיין %1 כבר כולל את הקידומת WWW.",
    'subdomains__user_type_quota_exceeds' => 'לא ניתן לשנות את חשבון המשתמש, מכיוון שהדבר יביא לחריגה משטח הדיסק שהוקצה.',
    'subdomains__creation_in_dns_slave' => "שרת השמות של Plesk מתפקד כשרת שמות משני עבור דומיין זה. על מנת שהתת-דומיין שלך יעבוד כראוי, ודא שקובץ האזור בשרת ה-DNS הראשי מכיל את הרשומה %1.",
    'sys_user__attributes_not_changed' => "\nתכונות משתמש המערכת הבאות לא שונו: %1",
    'sys_user__no_access_without_password' => "לא הגדרת סיסמה. משתמש המערכת ייווצר, אך לא יוכל להיכנס למערכת עד שתינתן לו/לה סיסמה. האם ברצונך להמשיך?",
    'sys_user__no_hard_quota' => "לא נתמך",
    'sysuser__zero_quota_is_unlimited' => "0 עבור 'ללא הגבלה'",
    'template__num_excl_ips' => "הקצה כתובות IP ייעודיות ללקוח",
    'template__sel_sh_ips' => "כתובות IP משותפות שנבחרו",
    'template__av_sh_ips' => "כתובות IP משותפות זמינות",
    'template__up_to_excl_ip' => "עד %1 כתובות IP",
    'templates__all_clients' => "כל הלקוחות",
    'templates__cl_domain_templates' => "תבניות עבור %1",
    'templates__cl_templates' => "תבניות לקוח",
    'time__invalid_ip' => "כתובת IP או שם דומיין לא חוקיים.",
    '__please_select_country' => 'בחר את הארץ שלך',
    'time__unable_set_time' => "לא ניתן להגדיר את שעת המערכת: %1",
    'time__sinchronization_setup_error' => 'אין אפשרות להגדיר סנכרון זמן: timemng נכשל: %1',
    'time__sinchronization_disable_error' => 'לא ניתן להשבית סנכרון זמן: timemng נכשל: %1',
    'tmpl__create' => "צור תבנית",
    'tmpl__edit__' => 'תבנית %1',
    'tmpl__logrotation_warn' => "סבב יומן רישום בדומיין שנוצר לפי תבנית זו יבוצע רק במקרה של יצירת חשבון אחסון אתרים פיזי עוקב עבורו.",
    'tmpl__name' => "שם תבנית",
    'tmpl__dom_exist' => "במאגר התבניות של מנהל המערכת או של הלקוח כבר קיימת תבנית דומיין בשם כזה.",
    'tmpl__name_invalid' => "שם תבנית לא חוקי או ריק.",
    'tmpl__use_next_ip_addr' => "ייעשה שימוש בכתובת ה-IP הפנויה הבאה",
    'tmpl_name_already_exists' => "כבר קיימת תבנית בשם '%1'.",

    'vh_based__no_free_ip_for_vh' => "אין באחסון האתרים הווירטואלי מבוסס ה-IP כתובות IP פנויות. הוסף כתובת IP.",

    'wu__at_domains_text' => "אפשר תבנית גישה של משתמש אינטרנט@‎%1",
    'wu__unable_create' => "לא ניתן ליצור משתמש אינטרנט: %1",
    'wu_edit__disk_quota' => "מיכסת דיסק",
    'wu_edit__invalid_pass' => "הסיסמה אינה חוקית.",
    'wu_edit__invalid_quota' => "ערך מיכסת שטח הדיסק שצוין אינו חוקי. הזן מספר שלם חיובי.",
    'wu_edit__invalid_quota_value' => "מיכסת שטח הדיסק שצוינה קטנה משטח הדיסק שנמצא בשימוש כרגע (%1MB). ייתכן שתפקודים מסוימים יהפכו ללא זמינים. האם אתה בטוח שברצונך להמשיך?",
    'wu_edit__not_create_pass' => "הפעולה לא תביא ליצירת סיסמה עבור משתמש האינטרנט החדש. ללא סיסמה, המשתמש לא יוכל להיכנס למערכת.",
    'wu_edit__unable_update' => "לא ניתן לעדכן את מאפיין משתמש האינטרנט: %1",

    'dns__tabs_general' => 'הגדרות אזור',
    'dns__tabs_zone_settings' => 'רשומות SOA',
    'soa__seconds' => 'שניות',
    'soa__minutes' => 'דקות',
    'soa__hours' => 'שעות',
    'soa__days' => 'ימים',

    'DomainSubdirectory' => 'ספריית משנה ליעד',

    'filemanager__select_codepage' => 'בחר דף קידוד:',

    'bt_server_app_add' => 'הוספת יישום שרת',
    'packages_list' => 'יישומי שרת',

    'bt_packages_management' => 'ניהול חבילות',
    'pb__packages_management' => 'ניהול יישומים',
    'bt_package_new' => 'הוספת יישום',
    '__packages' => 'יישומי שרת',

    'dom_ctrl__mysql_dbase_space' => 'מיכסה כוללת של מסד נתוני MariaDB/MySQL',
    'dom_ctrl__mssql_dbase_space' => 'מיכסה כוללת של מסדי נתוני MS SQL',

    'dns_add__enter_ixfr_path' => 'הזנת נתיב IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'רשומת SPF TXT כבר קיימת. יכולה להיות רשומת SPF אחת בלבד. כדי להוסיף רשומה, מחק את הרשומה הקיימת לפני כן.',

    'component_name__network' => 'עבודה ברשת',
    'component_name__sitebuilder' => 'בונה הנוכחות',

    'bt_skin_set' => 'הגדרת מעטפת',
    'bt_set_skin' => 'הגדרת מעטפת',
    'firewall__rule_already_exists' => 'כבר קיים כלל בשם "%1"',
    'firewall__rule_readonly' => 'כלל "%1" הוא לקריאה בלבד',
    'pb__firewall' => 'חומת אש',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'אנטי-וירוס',
    'antivirus__antivirus' => 'הגנת אנטי-וירוס',
    'antivirus__antivirus_direction_off' => 'כבוי',
    'antivirus__antivirus_direction_any' => 'דואר יוצא ונכנס',
    'antivirus__antivirus_direction_from' => 'דואר יוצא בלבד',
    'antivirus__antivirus_direction_to' => 'דואר נכנס בלבד',
    'antivirus__unable_to_update_settings' => 'לא ניתן לשנות הגדרות אנטי-וירוס: %1',




    '__normal' => 'רגיל',
    '__low' => 'נמוך',
    '__high' => 'גבוה',

    'mail__antivirus' => "אנטי-וירוס של שרת דואר פנימי",
    'mail__use_internal_antivirus' => 'השתמש באנטי-וירוס פנימי',

    'sa__tabs_blacklist' => 'רשימה שחורה',

    '__mysql_databases' => 'מסדי נתוני MariaDB/MySQL',

    'cl_perm__mysql_dbase_space' => 'מיכסה כוללת של מסד נתוני MariaDB/MySQL',
    'cl_perm__mssql_dbase_space' => 'מיכסה כוללת של מסדי נתוני MS SQL',
    'cl_perm__max_mssql_db' => 'מספר מרבי של מסדי נתונים של Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'מיכסה כוללת של תיבות דואר',

    'i_i_cl_on' => 'חשבון הלקוח פעיל.',
    'i_i_cl_off_by_admin' => 'חשבון לקוח מושעה על ידי מנהל מערכת.',

    'sa_exists_tn' => 'הרשת כבר נמצאת ברשימה.',

    'defaultcomponents__not_activated' => 'לא מופעל',

    'bt_traffic_at_domains' => 'תעבורה',

    '__awstats_perl_warning' => 'ללא התקנה של Perl,‏ AWStats לא יאפשר למשתמשים לבדוק נתונים סטטיסטיים של שנים קודמות.',

    'class_client__mysql_dbase_space' => 'הערך חרג מגבולות הלקוח.',
    'class_client__mssql_dbase_space' => 'הערך חרג מגבולות הלקוח.',
    'class_client__max_mssql_db' => 'הערך חרג מגבולות הלקוח.',

    'dns__remove_transfer_restrictions_list_items' => 'הרשתות הבאות יוסרו מרשימת בקרת הגישה:',

    'bt_up' => "למעלה",
    'bt_down' => "למטה",

    'bt_install_selected' => 'התקנת מפתחות רישיון שנבחרו', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'הדומיין מפוענח לכתובת IP אחרת: (%1). תקן הגדרות DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'שרת הדואר שנמצא כרגע בשימוש אינו תומך בהפעלה בו זמנית של תיבת דואר ושל קבוצות דואר. לחץ על \'אישור\' כדי להפעיל תיבת דואר במחיר של כיבוי קבוצות דואר. לחץ על \'ביטול\' כדי להשאיר הכול ללא שינוי.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'שרת הדואר שנמצא כרגע בשימוש אינו תומך בהפעלה בו זמנית של תיבת דואר ושל קבוצות דואר. לחץ על \'אישור\' כדי להפעיל קבוצות דואר במחיר של כיבוי תיבת דואר. לחץ על \'ביטול\' כדי להשאיר הכול ללא שינוי.',

    'mysql_dbase_space_limit' => 'מגבלת שטח של מסד נתוני MariaDB/MySQL',
    'mysql_dbase_usage' => 'שימוש בשטח של מסד נתוני MariaDB/MySQL',
    'mssql_dbase_space_limit' => 'מגבלת שטח מסד נתונים של Microsoft SQL Server',
    'mssql_dbase_usage' => 'שימוש בשטח מסד נתונים של Microsoft SQL Server',

    '__statistics' => "‏נתונים סטטיסטיים", //indirect

    'dns__soa_minimum_value_is_big' => 'הגדרת ערך TTL מזערי שעולה על 3 שעות עלולה להפוך את הדומיינים שלך ללא נגישים עבור חלק ממנהלי הדומיין. מומלץ להגדיר ערך כזה רק אם רשם שמות הדומיינים שלך מתעקש על כך.',

    'virusfilter__interface_not_available' => 'אין מסנני וירוסים זמינים.',
    'virusfilter__none_virus_filter' => 'ללא',
    'virusfilter__mailname_status_text' => 'אנטי-וירוס (%1)',
    'virusfilter__status_none' => 'כבוי',
    'virusfilter__status_any' => 'דואר יוצא ונכנס',
    'virusfilter__status_outgoing' => 'רק דואר יוצא',
    'virusfilter__status_incoming' => 'רק דואר נכנס',

    'visibility__root_override_parse_error' => 'ישנה שגיאת תחביר בקובץ %1 בשורה %2.',

    'sb__not_support_publishing_api' => "אוטומציית פרסום אינה נתמכת על ידי הרכיב",

    'component_name__cphosting' => "אחסון אתרים של Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'הגדרת מיכסת תיבות דואר אינה נתמכת על ידי שרת הדואר הנוכחי.',
    '__unable_get_total_mboxes_quota' => 'הגדרת מיכסת תיבות דואר אינה נתמכת על ידי שרת הדואר הנוכחי.',

    'install_prefix__parent_not_exists' => "ספריית האב אינה קיימת.",

    'bt_change_version' => 'שינוי גירסה‏',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "בחר הכול",
    '__uncheck_all' => "נקה הכול",

    'dns__editing_domain_controller_zone' => "עריכת רשומות אזור DNS עבור בקר דומיין עלולה לגרום לבעיות בתפקוד הדומיין",

    'pb__interface_management' => "ניהול ממשק",
    'interface_management__tabs_skins' => "מעטפות",
    'interface_management__tabs_interface_templates' => "תבניות ממשק",
    'interface_management__tabs_locales' => "אזורים",
    'locales_list__title' => "מאגר ערכות שפה",
    'locales_list__legend' => "שפות זמינות",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "ערכת שפה",
    'locales_list__lang_title' => "שפה",
    'locales_list__country_title' => "ארץ",
    'locales_list__used_title' => "בשימוש",

    'backup__suspend_warning_during_backup' => "הדומיין לא יהיה זמין במהלך תהליך הגיבוי",
    'backup__suspend_warning_during_restore' => "הדומיין לא יהיה זמין במהלך תהליך השחזור",
    'backup__suspend_domain' => "השעיית דומיין",

    'locales_list__mls_limit' => "רישיון Plesk הנוכחי שלך מאפשר שימוש ב-%2 שפות. כרגע, מוגדרות אצלך %1 שפות כזמינות למשתמשים, מספר החורג מזה שסופק עם הרישיון. בחר %2 שפות בהן ברצונך להשתמש והפוך את השאר ללא זמינות למשתמשים על ידי לחיצה על הסמלים שלהן בעמודה 'S'.",

    'bt_change_owner' => 'הקצאת בעלים חדשים',
    'chown__limit_name' => 'שם המשאב',
    'chown__error_limits' => "לא ניתן להמשיך בהעברת המינוי: למינוי זה נדרשים יותר משאבים ממה שהספק של הבעלים החדשים יכול לספק לו.",
    'chown__error_empty_ip_pool' => "לא ניתן להמשיך בהעברת המינוי: מאגר ה-IP של הספק של הבעלים החדשים ריק. ודא שלספק יש כתובת IP אחת לפחות במאגר.",

    'backup__backup_time' => 'זמן לגיבוי',
    'backup__backup_time_hour' => 'שעות',
    'backup__backup_time_minute' => 'דקות',
    'backup__every' => 'כל',
    'backup__day_of_month' => 'יום בחודש',

    'subdomain__select_hst_type' => 'בחר את סוג אחסון האתרים עבור התת-דומיין',
    'hst_sel__subdom_subfolder_hst' => 'תת-דומיין או תיקיית משנה',
    'subdomain__www_root_folder_not_exists' => 'ספריית הבית %1 של האתר אינה קיימת',
    '__site_home_dir' => 'ספריית בית של אתר',
    'subdomain__aspnet_disabled_domain' => 'מכובה על ידי דומיין',

    'domains__remove_description' => 'כל נתוני הדומיין, כולל התוכן וההגדרות של הדומיין ושל התת-דומיינים המתאימים, נתוני יישומי האינטרנט, תכולת תיבת הדואר, דואר, הגדרות אנטי-וירוס וסינון הודעות דואר זבל, קובצי יומן רישום, נתוני מאגר הגיבוי של הדומיין ואישורי SSL/TLS יימחקו. אם אין לך קובץ גיבוי במחשב המקומי, כל הנתונים יאבדו לצמיתות.',
    'subdomains__remove_description' => 'יימחקו כל נתוני התת-דומיין, לרבות תוכן והגדרות תת-דומיין, נתוני יישומי רשת וקובצי יומן רישום. אם אין לך קובץ גיבוי במחשב המקומי, כל הנתונים יאבדו לצמיתות.',

    'mail__tabs_spam_filtering' => 'סינון הודעות זבל',
    'mail__tabs_antivirus' => 'אנטי-וירוס',
    'antivirus__use_server_settings_scan' => 'השתמש בהגדרות ברירת המחדל בכלל השרתים (בצע סריקה)',
    'antivirus__use_server_settings_no_scan' => 'השתמש בהגדרות ברירת המחדל בכלל השרתים (אל תבצע סריקה)',
    'antivirus__check_for_viruses' => 'בצע סריקה לאיתור וירוסים',
    'antivirus__dont_check_for_viruses' => 'אל תבצע סריקה לאיתור וירוסים',
    'antivirus__incoming_mail' => 'דואר נכנס',
    'antivirus__outgoing_mail' => 'דואר יוצא',

    'domain_alias__CNAME_dns_record_exists' => 'כבר קיימת רשומת DNS CNAME בשם כזה',
    'domain_alias__A_dns_record_exists' => 'כבר קיימת רשומת DNS A בשם כזה',
    'domain_alias__bad_prefix' => 'קידומת שגויה עבור כינוי דומיין',
    'domain_alias__domain_doesnt_exist' => "הדומיין אינו קיים",

    'dns__zone_ttl_message_info' => 'אם ערך ה-TTL לא מצוין, ערך ה-TTL בתבנית רשומת ה-SOA (%1) ישמש לרשומת DNS זו.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "קובץ בשם index.html ייווצר לשם ניתוב מחדש של יישום האינטרנט שנבחר. אם כבר קיים קובץ בשם index.html, הוא יגובה כ-index.html.old ויוחלף בקובץ החדש. לחץ על 'אישור' כדי לאשר",

    'bt_ftp_ctrl' => "חשבונות FTP נוספים",
    'ftp_users_no_permission' => "אין לך הרשאה לנהל חשבונות FTP עבור דומיין זה",
    'ftp_users_limit_reached' => "המערכת הגיעה למגבלת חשבונות ה-FTP עבור דומיין זה",
    'pb__ftp_ctrl' => "ניהול FTP",
    'class_client__max_subftp_users' => "חשבונות FTP נוספים",

    '__client_form_settings' => "הגדרות לקוח",
    '__sbnet_client_keep_sbnet' => "שמור את חשבון המשתמש המתאים בבונה הנוכחות",
    '__sbnet_cant_add_more_sites' => "המערכת הגיעה למגבלה על כמות האתרים שיכולים להשתמש בבונה הנוכחות עבור לקוח זה",
    '__sbnet_legend_text' => "שילוב בונה הנוכחות",
    '__sbnet_synchronize_user_with_sbnet' => "צור חשבון משתמש מתאים בבונה הנוכחות",
    '__sbnet_client_warning_delete_sb_user' => "אתה מנסה להסיר את חשבון משתמש בונה הנוכחות המשויך ללקוח זה. הדבר יביא למחיקת כל אתרי האינטרנט של המשתמש ואת כל ההגדרות הרלוונטיות האחרות ממערכת בונה הנוכחות, תוך הסרת היכולת לערוך אתרי אינטרנט קיימים באמצעות בונה הנוכחות, גם אם תפעיל אפשרות זו מאוחר יותר. אם מאוחר יותר תיצור שוב חשבון משתמש בונה נוכחות, תצטרך ליצור ולפרסם את כל אתרי האינטרנט שלך מאפס. האם אתה רוצה לכבות יצירה ופרסום של אתרי אינטרנט באמצעות בונה הנוכחות?",
    'sb__build_site_with_subdomains' => "צור את תת-הדומיינים 'בלוג' ו'גלריית תמונות'",
    '__sbnet_client_dont_have_sbuser' => "לא ניתן ליצור ולפרסם אתר באמצעות בונה הנוכחות: משתמש בונה הנוכחות אינו קיים",

    '__component_disabled' => "הרכיב כבוי",

    'subdomains__physical_path_not_exist' => "ישנם תת-דומיינים המקושרים לתיקיות פיזיות שאינן קיימות",

    'dnsserver_bind_to_msdns_switching_warning' => "אזהרה: יועברו רק 254 הכתובות הראשונות של רשתות משנה עם 8/ ו-16/ מסיכות הממוקמות ברשימת בקרת הגישה. הן יועברו ככתובות IP נפרדות. האם ברצונך להמשיך?",

    '__sbnet_net_framework_required_for_site' => "ייתכן שלאתרים של בונה הנוכחות תידרש תמיכה ב-ASP.NET 2.0 בדומיין שלך. מומלץ לאפשר תמיכה ב-ASP.NET 2.0 אם אתה משתמש בבונה הנוכחות.",

    'subdomain_auto_create_dir' => "צור תיקיה פיזית עבור תת-דומיין",

    'sa_trainer__unable_to_get_messages_list' => "לא ניתן להשיג את הרשימה של ההודעות בתיבת הדואר: %1",
    'sa_trainer__pass_doesnt_exist' => "הסיסמה עבור חשבון דוא\"ל זה חסרה",

    '__sitebuilder_error' => "אירעה שגיאה בניסיון להתחבר לבונה הנוכחות. לקבלת סיוע, פנה לספק השירות שלך.",
    'wsb_error_user_not_exist' => "חשבון משתמש זה של בונה הנוכחות אינו קיים.",
    'wsb_error_site_already_exist' => "האתר כבר קיים בבונה הנוכחות.",
    'wsb_error_site_limit_reached' => "המערכת הגיעה למגבלה על מספר האתרים של בונה הנוכחות.",
    'wsb_error_internal_error' => "אירעה שגיאה פנימית בבונה הנוכחות. לקבלת סיוע, פנה לספק השירות שלך.",
    'wsb_error_user_already_exist' => "בבונה הנוכחות כבר קיים משתמש בונה נוכחות בשם כזה.",
    'sb_error_user_not_exist' => "משתמש בונה הנוכחות אינו קיים.",
    'wsb_error_object_not_found' => "בונה הנוכחות לא הצליח למצוא את ערך המארח הנכון.",

    'mg_no_mail_groups' => "אין קבוצות דואר",

    'drweb__drweb_incoming' => 'בדיקת דואר נכנס לווירוסים',
    'drweb__drweb_outgoing' => 'בדיקת דואר יוצא לווירוסים',
    'drweb__disable_reason_serv' => 'שרת הדואר אינו תומך בהגדרות מסנן אנטי-וירוס ברמת תיבת הדואר',

    'vz_sitebuilder3_client_cant_be_created' => "לא ניתן ליצור חשבון לקוח: לא מותקן SiteBuilder מגירסה 3.1 או מאוחרת יותר",

    // new limits

    'class_client__max_odbc' => "חיבורי ODBC",
    'cl_perm__max_odbc' => "מספר מרבי של חיבורי ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'שם כינוי דומיין',
    'domain_alias__list_ascii_name' => 'בתבנית ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'ניהול ממשק',
    'pb__interface_templates' => 'ניהול ממשק',
    'pb__interface_clients' => 'לקוחות המשתמשים ב-%1',

    // service management
    'bt_service_showall' => "הצג הכול",
    'bt_service_hideall' => "הסתר הכול",
    'bt_service_start' => "הפעלה",
    'bt_service_stop' => "עצירה",
    'bt_service_restart' => "הפעלה מחדש",
    'bt_service_disable' => "כיבוי",
    'bt_service_manual' => "‫ידני‬",
    'bt_service_auto' => "אוטומטי",
    'service_startup_auto' => '‫אוטומטי‬',
    'service_startup_manual' => '‫ידני‬',
    'service_startup_disabled' => 'כבוי',
    'service_action_ok' => "הפעולה עם שירות %1 הושלמה בהצלחה",
    'service_action_failed_disabled_service' => "לא ניתן היה להשלים את הפעולה עם שירות %1 מכיוון שהוא כבוי",
    'service_action_failed_error' => "לא ניתן היה להשלים את הפעולה: %1",
    'service_group_action_ok' => "הפעולה עם השירותים הבאים הושלמה בהצלחה: %1",
    'service_group_action_disabled' => "לא ניתן היה להשלים את הפעולה עם השירותים הבאים מכיוון שהם כבויים: %1",
    'service_group_action_failed' => "לא ניתן להשלים את הפעולה עם השירותים הבאים: %1. כדי לקבל מידע מפורט על השגיאה, בצע את הפעולה עם כל שירות בנפרד",

    // php 4vs5
    'bt_php' => "הגדרות PHP",

    'bt_insert' => "הכנס",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "אירעה שגיאה במסד נתוני בונה הנוכחות. לקבלת סיוע, פנה לספק השירות שלך.",
    'wsb_error_sitebuilder_access_denied_error' => "לא ניתן לגשת אל הקובץ: לבונה הנוכחות אין זכויות גישה עבור הקובץ או התיקיה הנדרשים. לקבלת סיוע, פנה לספק השירות שלך.",
    'wsb_error_sitebuilder_connection_failed' => "לא ניתן להתחבר לבונה הנוכחות מכיוון שהחיבור אבד. לקבלת סיוע, פנה לספק השירות שלך.",
    'wsb_error_critical_during_operation' => "אירעה שגיאה קריטית בבונה הנוכחות: %1",
    'wsb_error_license_during_operation' => "אירעה שגיאה ברישיון בונה הנוכחות: %1",
    'wsb_error_during_operation' => "אירעה שגיאה בבונה הנוכחות: %1",
    'wsb_error_license_error' => "המערכת הגיעה למגבלת רישיון בונה הנוכחות.",

    // Other
    '__confrim_service_stop' => "אזהרה! אם תעצור את השירות %1, Plesk עלול להפסיק לעבוד. האם אתה בטוח שברצונך לעצור את השירות %1?",
    'index_redirect_help_text' => 'כעת תנותב מחדש באופן אוטומטי לאתר האינטרנט הנדרש. אם הדפדפן שלך לא תומך בניתוב מחדש, לחץ על %1 כאן %2',
    'bt_default_settings' => "שחזור ערכי ברירת מחדל",
    'logfiles__remove_failed' => "לא ניתן למחוק את הקובץ %1: הקובץ נעול על ידי יישום אחר. נסה שוב מאוחר יותר",
    'subdomain__invalid_homedirectory' => "ספריית הבית של התת-דומיין שצוין אינה חוקית",
    'scheduler_item__empty_filename' => "ציין את קובץ ההפעלה שיופעל",
    'subdomains__overlapped_domain_exists' => 'התת-דומיין חופף לאזור ה-DNS של הדומיין %1',
    'subdomains__overlapped_domain_alias_exists' => 'התת-דומיין חופף לאזור ה-DNS של כינוי הדומיין %1',
    'services_action_none_selected' => 'לא ניתן היה להשלים את הפעולה: בחר את השירותים הנדרשים',
    'cl_perm__max_subftp_users' => "מספר מרבי של חשבונות FTP נוספים",
    'login_up__access_denied_no_cp_access' => 'הגישה נדחתה. אין לך את ההרשאה לגשת אל Plesk.',
    'drweb__disable_reason_admin' => "מדיניות השרת אינה מתירה הגדרות מסנן אנטי-וירוס ברמת תיבת הדואר.",

    '__use_default' => 'השתמש בברירת מחדל',

    'webalizer_hidden_referrer__already_exist' => 'כבר קיים ערך כזה.',
    'webalizer_group_referrer__already_exist' => 'כבר קיים מפנה קבוצה בשם כזה.',

    'pb__dashboard' => 'דף הבית',

    'server_interface__page_title' => 'הגדרות ממשק שרת',
    'server_interface__tabs_locales' => 'אזורים',
    'server_interface__tabs_skins' => 'מעטפות',
    'server_interface__tabs_interface_templates' => 'תבניות ממשק',
    'bt_server_interface' => 'העדפות ממשק',
    'pb__server_interface' => 'העדפות ממשק',

    'bt_wizard_next' => 'הבא>>',
    'bt_wizard_prev' => '<< הקודם',

    '__limit_exceeded_max_dom_server' => 'לא ניתן לאחסן דומיינים נוספים בשרת זה, מכיוון שהגעת למגבלה על מספר הדומיינים בשרת שמתיר מפתח הרישיון. צור קשר עם ספק השירות כדי לפתור בעיה זו.',
    '__limit_exceeded_max_subdom_server' => 'לא ניתן לאחסן תת-דומיינים נוספים בשרת זה. פנה אל ספק השירות שלך.',
    '__limit_exceeded_max_dom_aliases_server' => 'לא ניתן להגדיר כינויי דומיינים נוספים בשרת זה. פנה אל ספק השירות שלך.',
    '__limit_exceeded_max_wu_server' => 'לא ניתן ליצור משתמשי אינטרנט נוספים מכיוון שהגעת למגבלה על מספר משתמשי האינטרנט בשרת שמתיר מפתח הרישיון. צור קשר עם ספק השירות כדי לפתור בעיה זו.',
    '__limit_exceeded_max_mn_server' => 'לא ניתן ליצור חשבונות דוא"ל נוספים, מכיוון שהגעת למגבלה על מספר חשבונות הדוא"ל שמתיר מפתח הרישיון. צור קשר עם ספק השירות כדי לפתור בעיה זו.',

    '__limit_exceeded_max_cl_useradmin' => 'הגעת למגבלה על מספר חשבונות הלקוחות שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'הגעת למגבלה על מספר הדומיינים שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'הגעת למגבלה על מספר התת-דומיינים שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'הגעת למגבלה על מספר כינויי הדומיינים שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'לא נותר לך שטח דיסק פנוי',
    '__limit_exceeded_max_wu_useradmin' => 'הגעת למגבלה על מספר חשבונות משתמשי האינטרנט שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_db_useradmin' => 'הגעת למגבלה על מספר מסדי הנתונים שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_box_useradmin' => 'הגעת למגבלה על מספר תיבות הדואר שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'הגעת למגבלה על מספר חשבונות הדואר האלקטרוני שמגדיר מפתח הרישיון שלך (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'הגעת למגבלה על מספר רשימות הדיוור שמגדיר מפתח הרישיון שלך (%2)',

    '__limit_exceeded_max_dom_userclient' => 'הגעת למגבלה על מספר הדומיינים (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'הגעת למגבלה על מספר התת-דומיינים (%2) שמתיר ספק השירות שלך',
    '__limit_exceeded_max_dom_aliases_userclient' => 'הגעת למגבלה על מספר כינויי הדומיינים (%2)',
    '__limit_exceeded_disk_space_userclient' => 'הגעת למגבלת ניצול שטח הדיסק (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'הגעת למגבלה על כמות השימוש ברוחב פס לחודש (%2)',
    '__limit_exceeded_max_wu_userclient' => 'הגעת למגבלה על מספר משתמשי האינטרנט (%2) שמתיר ספק השירות שלך.',
    '__limit_exceeded_max_db_userclient' => 'הגעת למגבלה על מספר מסדי הנתונים (%2)',
    '__limit_exceeded_max_box_userclient' => 'הגעת למגבלה על מספר תיבות הדואר (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'הגעת למגבלה על מספר רשימות הדיוור (%2)',
    '__limit_exceeded_expiration_userclient' => 'תוקף החשבון שלך פג ב-%2',

    '__limit_exceeded_max_subdom_userdomain' => 'הגעת למגבלה על מספר התת-דומיינים (%2) שמתיר ספק השירות שלך',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'הגעת למגבלה על מספר כינויי הדומיינים (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'הגעת למגבלת ניצול שטח הדיסק (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'הגעת למגבלה על כמות רוחב הפס שמנוצל בחודש (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'הגעת למגבלה על מספר חשבונות משתמשי האינטרנט (%2)',
    '__limit_exceeded_max_db_userdomain' => 'הגעת למגבלה על מספר מסדי הנתונים (%2)',
    '__limit_exceeded_max_box_userdomain' => 'הגעת למגבלה על מספר תיבות הדואר (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'הגעת למגבלה על מספר רשימות הדיוור (%2)',
    '__limit_exceeded_expiration_userdomain' => 'תוקף החשבון שלך פג ב-%2',

    'sapp_error_validation_not_found' => 'לא ניתן לאמת את יישום האינטרנט מכיוון שאחד מהקבצים הנדרשים (%1) לא נמצא. פנה אל נציג התמיכה הטכנית לקבלת סיוע.',
    'sapp_error_validation_spec_failed' => 'יישום האינטרנט שהועלה אינו מתאים למפרטים של AppPacks:‏ %1.',
    'sapp_error_validation_register' => 'לא ניתן לרשום את יישום האינטרנט הממוקם בספריה "%1": %2 עליך להסיר את יישום האינטרנט מהשרת מכיוון שהוא לא יתפקד כראוי.',

    'sapp__install_failed' => 'התקנת יישום האינטרנט נכשלה: %1',
    'sapp__install_res_failed' => 'יצירת המשאב הנדרש נכשלה.',

    'server_preferences__subdomains_blog_and_photo' => 'צור את תת-הדומיינים \'בלוג\' ו\'גלריית תמונות\' כברירת מחדל',
    'plesk_key__blog_and_photo' => 'יכולת לנהל את מצב ברירת המחדל של תיבת הסימון של התת-דומיינים \'יצירת בלוג\' ו\'גלריית תמונות\'',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'לא ניתן לשנות את סוג כתובת ה-IP לייעודית, מכיוון שהיא מוקצית ליותר ממשתמש אחד.',

    // 8.1.1

    '__write_modify_warning' => 'בחירת הרשאות כתיבה/שינוי נוספות תגרום לחלק מיישומי האינטרנט לפעול כראוי, אך היא עלולה גם להעלות במידה משמעותית את סיכוני האבטחה',
    '__write_modify_subdomain_warning' => 'בחירת הרשאות כתיבה/שינוי נוספות תגרום לחלק מיישומי האינטרנט לפעול כראוי, אך היא עלולה גם להעלות במידה משמעותית את סיכוני האבטחה',

    'phosting__php_incorrect_version_used' => "זוהו בעיות בגירסת PHP. כדי לפתור בעיות אלה, בחר את תיבת הסימון עם גירסת ה-PHP הנדרשת להלן ולחץ על 'אישור'. כדי לכבות PHP בדומיין זה, לחץ על 'אישור' ללא בחירת גירסת PHP",
    'fp__mail_preferences' => 'הגדרות דואר',

    'mail__invalid_white_pattern' => 'הערך שצוין אינו חוקי. השתמש בתבניות הבאות: mail@example.com עבור כתובות דוא"ל, example.com עבור דומיינים.',
    'mail__invalid_black_pattern' => 'הערך שצוין אינו חוקי. השתמש בתבנית הבאה: mail@example.com עבור כתובות דוא"ל, example.com עבור דומיינים.',

    'resp_edit__reply_as_html' => 'שלח כ-HTML',
    'exception__path_very_long' => "הנתיב ארוך מדי. ודא שבנתיב יש פחות מ-%1 תווים.",

    // 8.2


    //SAPP
    'sapp_on' => 'פעיל',
    'sapp_off' => 'לא פעיל',
    'sapp_directive_aspect' => 'נדרש',
    'sapp_databases_num' => 'מסדי נתונים',
    'sapp_db_required' => 'נדרש',
    'sapp_Required' => 'נדרש',
    'sapp_Variant' => 'משתנה',
    'sapp_db_id' => 'מזהה מסד נתונים',
    'sapp_db_id_type' => 'סוג מסד נתונים (מזהה: %1)',
    'sapp_db_id_min_version' => 'גירסה מזערית של מסד נתונים (מזהה: %1)',
    'sapp_db_id_table_prefix' => 'קידומת טבלה של מסד נתונים (מזהה: %1)',
    'sapp_Default' => 'ערך ברירת מחדל',
    'sapp_apache_mod_req' => 'מודול Apache',
    'sapp_dbtype_not_installed' => '‫לא מותקן‬',
    'sapp_apache_mod_not_installed' => '‫לא מותקן‬',
    'sapp_error_invalid_type' => 'היישום "%1" אינו תומך בפעולה המבוקשת.',
    'sapp_error_unknown_app_type' => 'סוג יישום שאינו נתמך: %1.',
    'sapp__ssl_text' => 'להתקין את היישום במארח וירטואלי "//‏:‏http" או "//‏:‏https"?',
    'sapp__app_to_upgrade' => 'יישומים שיעודכנו',
    'sapp__upgrade_apps_title' => 'שדרג יישומים',
    'sapp__upgrade_to_ver' => 'שדרג לגירסה',
    'sapp__choose_pkg_ver' => 'בחר חבילה...',
    'sapp__pkg_cant_upgrade_pkg' => 'לא ניתן להשתמש בחבילה "%1" לשדרוג יישום האינטרנט "%2".',
    'sapp__app_ugrade_error' => 'לא ניתן לשדרג את היישום: %1. פנה אל מנהל המערכת שלך.',
    'sapp__no_suitable_db_found' => 'לא נמצא מסד נתונים מתאים.',
    'sapp__upgrade_success' =>  'היישום שודרג בהצלחה.',
    'sapp__pkg_info_changelog' => 'היסטוריית שינויים',
    'sapp_requirement_legend' => 'תכונות אחסון אתרים שנדרשות על ידי היישום',

    // other
    'bt_apply' => 'החל',
    'mn_edit__add_alias_if_mailbox_disabled' => 'כדי ליצור כינוי דואר, יש להפעיל את תיבת הדואר בחשבון דוא"ל זה. האם להפעיל את תיבת הדואר?',
    'mn_edit__mailbox_disable_if_has_alias' => 'כיבוי תיבת הדואר יסיר את כינויי הדואר, מאחר שהם יפסיקו לפעול. האם לכבות את תיבת הדואר?',
    'antivirus__disable_reason_install' => 'לא ניתן לנהל אנטי-וירוס מכיוון שהוא אינו מותקן.',
    'antivirus__disable_reason_key' => 'לא ניתן לנהל אנטי-וירוס מכיוון שהוא לא מופעל על ידי מפתח רישיון מתאים.',
    'antivirus__disable_reason_deny_personal_settings' => 'לא ניתן לנהל אנטי-וירוס מכיוון שמדיניות השרת אוסרת על הגדרות אנטי-וירוס אישיות.',
    'change_foreign_user_password' => 'שינוי סיסמה',
    'change_foreign_user_password_hint' => "המשתמש אינו שייך ליישום זה. לחץ על הקישור כדי לעבור ליישום אחר ולשנות שם את סיסמת המשתמש. כדי לעשות זאת, צריכות להיות לך הזכויות המתאימות ביישום.",
    'cf_url_text' => 'כתובת URL‏ JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'תבנית מחרוזת',
    'lang_unknown' => 'שפה לא מוכרת',
    'pb__cl_ed' => 'פרטי לקוח',
    'pb__actionlog' => 'יומן פעולות',
    'pb__cl_limits' => 'מגבלות לקוח',
    'pb__edit' => 'עריכה',
    'pb__subdom_edit' => 'הגדרות אחסון אתרים',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'גבה את תוכן תיבות הדואר',

    'maillist_import_result' => "\nכמות כוללת של כתובות דוא\"ל בקובץ: %1\n כמות של כתובות דוא\"ל מיובאות: %2\n כמות של כתובות דוא\"ל שכבר קיימות: %3\n כמות של כתובות דוא\"ל כפולות בקובץ שצוין: %4\n כמות של כתובות דוא\"ל לא חוקיות בקובץ: %5",
    'maillist_import_error' => 'לא ניתן לייבא רשימת כתובות דוא"ל',

    'dom_pref__external_mail_srv' => "נתב מחדש לשרת דואר חיצוני עם כתובת ה-IP:",
    'mn_edit__store_messages' => 'תיבת דואר',

    // aps

    'sapp__before_upgrade_notice' => 'מומלץ לגבות את היישום ואת נתוני המשתמש לפני הפעלת תהליך השדרוג.',
    'sapp__application_properties' => 'מאפייני יישום',
    'sapp__application_root_descr' => 'הדף הראשי של היישום',

    'sapp__aps_license_invalid_id' => 'למפתח הרישיון יש מזהה לא חוקי: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'במסד הנתונים כבר קיים רישיון בעל מספר המפתח %1.',
    'sapp__aps_lic_del_used' => 'לא ניתן למחוק את מפתח הרישיון, הוא נמצא בשימוש של אחד מהיישומים המותקנים.',
    'sapp__aps_lic_del_unknown' => 'לא ניתן למחוק את מפתח הרישיון: %1',
    'sapp__aps_cappi_duplicate' => "היישום כבר נמצא במאגר היישומים של לקוח זה",
    'sapp__appi_not_shared_no_install' => "אין יישום כזה במאגר היישומים של הלקוח. אם ברצונך להתקין יישום זה באתר, תחילה עליך להוסיף את היישום למאגר היישומים של הלקוח.",
    'sapp__appi_shared_not_client' => "אין יישום כזה במאגר היישומים של הלקוח. אם אינך רוצה לשדרג את היישום לגירסה שצוינה, תחילה עליך להוסיף גירסת יישום זו למאגר היישומים של הלקוח.",
    'sapp__apply_license_script_not_found' => 'לא ניתן למצוא את קובץ ה-Script "החל-רישיון" עבור יישום אינטרנט זה.',
    'sapp__unable_to_activate_key' => 'אירעה שגיאה במהלך ניסיון להפעיל מפתח רישיון: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'ישנם יישומי אינטרנט שנדרשת להם נוכחות של יישום אינטרנט זה במערכת.',
    'sapp__unable_to_delete_ai_in_pool' => 'יישום זה עדיין נמצא במאגר יישומים של לקוח. אם ברצונך להסיר יישום זה, תחילה עליך להסיר אותו ממאגרי היישומים של כל הלקוחות או לא לגבות עליו תשלום.',
    'sapp__unable_to_delete_app_template' => 'לא ניתן להסיר את היישום #%1: %2',
    'sapp__limit_exceeded_client' => 'הגעת למגבלה על מספר הפעמים שניתן להתקין יישום אינטרנט זה (%2).',


    // atis module

    '_week_on' => 'שבוע ב',
    '__week_first' => 'ראשון',
    '__week_second' => 'שני',
    '__week_third' => 'שלישי',
    '__week_fourth' => 'רביעי',
    '__week_last' => 'אחרון',
    '__not_started' => 'המתנה',
    '__started' => 'פועל',
    '__cancel_pending' => 'ביטול',
    '__canceled' => 'בוטל',
    '__error' => 'שגיאה',
    '__done' => 'בוצע',

    '__php_cgi_handler' => 'יישום CGI',
    '__php_isapi_handler' => 'הרחבת ISAPI',
    '__php_fastcgi_handler' => 'יישום FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'הפעל כ',

    'cf_dbfolder_text' => 'תיקיית מסד נתונים',
    'cf_isnewdb_text' => 'יצירת מסד נתונים',
    'cf_isnewdb_title' => 'בחר את תיבת הסימון אם יש ליצור את מסד הנתונים',

    'pb__site_apps_upgrade' => 'שדרוג יישום אינטרנט',

    'detach' => 'ניתוק',
    'preferences' => "שינוי סיסמה",

    'toolsbar__switch_user?' => "האם אתה בטוח שברצונך להיכנס למערכת תחת חשבון משתמש אחר?",
    '__aps_left' => 'התקנות נותרו',
    'aps__license_key' => 'מפתח רישיון',
    'aps__download_code' => 'הורדה וקוד הפעלה של מפתח רישיון',
    'aps__license_key_hint' => 'אחזר משרת הרישוי באמצעות קוד ההפעלה',
    'aps__database_not_available' => 'לא זמין, בדוק מגבלות דומיין או לקוח',
    'aps__yes' => 'כן',
    'aps__no' => 'לא',
    '__click_to_enlarge' => 'לחץ כדי להגדיל',
    'site_apps__back_to_list' => 'חזור לרשימה',
    'sapp__pkg_info_installation_requirements' => 'דרישות התקנה',
    '__close_window' => 'סגור',

    //SAPP END

    'skin_info__already_default' => 'המעטפת כבר מוגדרת כמעטפת ברירת המחדל.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => '‫הגדרות Plesk Premium Antivirus עבור %1‬',
    'drweb:properties_legend' => '‫הגדרות‬',
    'drweb:status' => 'בדיקת וירוסים בדואר',

    // sb integration
    'sitebuilder_wizard' => 'אשף בונה הנוכחות',
    'dom_site_builder' => 'לחץ כדי לפתוח את אשף בונה הנוכחות.',
    'sb_plesk_admin_url' => 'כתובת URL של שרת בונה הנוכחות. הבטח שכתובת זו מפוענחת כראוי ב-DNS',
    'sb_plesk_admin_login' => 'שם המשתמש עבור הכניסה של מנהל השרת לבונה הנוכחות',
    'sb_plesk_admin_password' => 'סיסמה של מנהל מערכת',
    'sb_sitebuilder_preferences' => 'אישורים של מנהל מערכת בונה הנוכחות',
    'sb__server' => 'העדפות מנהל המערכת של בונה הנוכחות',
    'sb__sitebuilder_support' => 'תמיכה בבונה הנוכחות',
    'sb_keep_sb_user' => 'שמור את חשבון המשתמש המתאים בבונה הנוכחות',
    'sb_create_sb_user' => 'צור חשבון משתמש מתאים בבונה הנוכחות',
    'sb__build_site_using_sitebuilder' => "צור אתר אינטרנט באמצעות בונה הנוכחות",
    'sb_no_current_sb_server_set' => 'תצורת החיבור לבונה הנוכחות לא נקבעה עדיין: עליך להוסיף רשומת A בתבנית אזור ה-DNS שתצביע אל שרת בונה הנוכחות.',
    'sb_unable_update_sb_server_sb_return_message' => "לא ניתן לאחזר את המידע ממערכת בונה הנוכחות: %1",
    'sb_unable_connect_sb_wrong_con_params' => "לא ניתן להתחבר אל בונה הנוכחות: שם משתמש או סיסמה שגויים.",
    'sb_init_sb_manager' => "מאתחל את מנהל בונה הנוכחות: %1",
    'sb_err_couldnt_connect_sb' => "ההתחברות למערכת בונה הנוכחות נכשלה.",
    'sb_err_client_dont_have_sbuser' => "ללקוח זה אין חשבון משתמש בבונה הנוכחות.",
    'sb_err_sitebuilder_not_configured' => "לא נקבעה תצורת בונה הנוכחות.",
    'sb_err_you_dont_have_sbaccount' => "המערכת נכשלה בהרשאה שלך בבונה הנוכחות.",
    'sb_error_critical_during_operation' => "השגיאה הבאה אירעה בבונה הנוכחות: %1",
    'sb_err_sso_is_not_enabled' => "תמיכה בכניסה יחידה אינה מופעלת ב-Plesk.",

    'warning__super_zone_exist' => "האזור %1 נוצר, אך שם אזור זה הוא אזור משנה של האזור האחר שכבר קיים, %2, השייך למשתמש אחר, %3. ניתן לעשות זאת, אך יש להקפיד לבחור את חשבון המשתמש הנכון.",
    'error__super_zone_exist' => "לא ניתן ליצור את אזור ה-DNS מכיוון שאזור-העל שלו שייך למשתמש אחר.",

    'locales__files_not_exits' => 'לא ניתן לשנות אזור: הקבצים שצוינו של ערכת שפת הממשק אינם קיימים במערכת.',
    'locales__unavailable' => 'לא ניתן לשנות אזור: ערכת שפת המשק שצוינה אינה זמינה.',

    // DB BU

    'pb__dbbackup_list' => 'קובצי גיבוי של מסד נתונים',
    // server
    'dbbackup__server_backup_settings' => 'גיבוי',
    'dbbackup__network_temp_dir' => 'ספריית רשת זמנית',
    'dbbackup__network_user' => 'שם משתמש',
    'dbbackup__network_pass' => 'סיסמה',
    // domain
    'dbbackup__add_database_legend' => 'שחזר מסד נתונים מגובה',
    'dbbackup__add_database_restore' => 'שחזר מסד נתונים מקובץ גיבוי',
    'dbbackup__add_database_file' => 'קובץ גיבוי של מסד נתונים',
    'dbbackup__add_database_user' => 'שם משתמש ברירת מחדל',
    'dbbackup__add_database_pass' => 'סיסמת ברירת מחדל של משתמש',
    'dbbackup__add_database_pass2' => 'אישור סיסמת ברירת מחדל של משתמש',

    'bt_dbbackup_now' => 'גיבוי',

    'bt_repair' => 'תקן',

    'dbbackup__mssql_dump_upload_not_allowed' => 'העלאה של קובצי Dump של מסד נתוני שרת SQL אסורה על ידי ספק אחסון האתרים.',

    // APS categories

    'cf_invalid_password' => 'אורך הסיסמה לא יעלה על 16 תווים',
    'cf_invalid_description_length' => 'אורך התיאור לא יעלה על 256 סימנים',
    'ip_addr__ip_used_by_external_mail_server' => 'כתובת ה-IP %1 כבר נמצאת בשימוש שרת דואר חיצוני',

    // 8.4.1

    '__ftp_login_is_invalid' => 'שם משתמש או סיסמה של חשבון FTP אינם חוקיים. ציין אישורי משתמש FTP נכונים.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'המערכת הגיעה למגבלה על שינויי מספרים סידוריים. לא ניתן לבצע שינויי אזורי DNS נוספים היום.',
    'dns__zone_apply_changes' => 'שינויים שבוצעו ברשומות DNS עדיין לא נשמרו. השינויים שבוצעו מודגשים מטה. לחץ על \'עדכון\' כדי להחיל את השינויים על אזור DNS או לחץ על \'חזור למצב הקודם\' כדי לזנוח את השינויים.',
    'dns__update_dns_zone' => 'לחץ כדי לשמור את השינויים שנעשו ברשומות DNS',
    'dns__revert_dns_zone' => 'לחץ כדי לבטל את השינויים שנעשו ברשומות DNS',
    'bt_revert' => 'חזרה למצב קודם',
    'dns__dns_zone_has_beed_updated' => 'נשמרו שינויים שבוצעו ברשומות DNS.',
    'dns__dns_zone_has_beed_reverted' => 'בוטלו שינויים שבוצעו ברשומות DNS',
    'db__nondefault_server_not_allowed' => 'השימוש בשרת מסד נתונים שאינו ברירת מחדל אינו מותר',

    'site_apps__non_removable' => 'פריטים שלא ניתן להסיר',
    'site_apps__non_removable_items' => 'לא ניתן להסיר את יישומי האינטרנט הבאים:',

    'rpt_reseller_section_general' => 'כללי',
    'rpt_reseller_section_domains' => 'דומיינים',
    'rpt_reseller_section_clients' => 'לקוחות',
    'statistics__cl_active_domains' => "דומיינים פעילים",
    'rpt_reseller_cl_domains' => "דומיינים",
    'rpt_reseller_cl_subdomains' => "תת-דומיינים",
    'by__cl_domains' => "דומיינים של לקוחות",
    'dom_ctrl__cl_mboxes' => "תיבות דואר",
    'rpt_reseller_cl_redirects' => "רכיבי העברה",
    'rpt_reseller_cl_mail_groups' => "קבוצות דואר",
    'rpt_reseller_cl_mail_resps' => "מענה אוטומטי",
    'rpt_reseller_cl_mail_lists' => "רשימות דיוור",
    'rpt_reseller_cl_web_users' => "משתמשי אינטרנט",
    'rpt_reseller_cl_data_bases' => "מסדי נתונים",

    'statistics__active_clients' => 'לקוחות בעלי מינויים פעילים',
    'statistics__clients_active_domains' => 'דומיינים פעילים',
    'statistics__clients_doms' => 'דומיינים',
    'statistics__cl_doms' => 'דומיינים',
    '__clients_subdomains' => 'תת-דומיינים',
    '__clients_domains' => 'דומיינים',
    'dom_ctrl__clients_mboxes' => 'תיבות דואר',
    'dom_ctrl__clients_redir' => 'רכיבי העברה',
    'dom_ctrl__clients_mg' => 'קבוצות דואר',
    'dom_ctrl__clients_resp' => 'מענה אוטומטי',
    'dom_ctrl__clients_maillists' => 'רשימות דיוור',
    'dom_ctrl__clients_wu' => 'משתמשי אינטרנט',
    'dom_ctrl__clients_db' => 'מסדי נתונים',

    'dom_ctrl__cl_redir' => 'רכיבי העברה', // to resolve!
    'dom_ctrl__cl_mg' => 'קבוצות דואר', // to resolve!
    'dom_ctrl__cl_resp' => 'מענה אוטומטי', // to resolve!
    'dom_ctrl__cl_maillists' => 'רשימות דיוור', // to resolve!
    'dom_ctrl__cl_wu' => 'משתמשי אינטרנט', // to resolve!
    'dom_ctrl__cl_db' => 'מסדי נתונים', // to resolve!

    'rpt_cl_section_clients' => 'לקוחות',

    'rpt_admin_section_general' => 'כללי',
    'rpt_admin_section_resellers' => 'משווקים',
    'rpt_admin_section_clients' => 'לקוחות',
    'rpt_admin_section_personal_clients' => 'לקוחות משויכים',
    'rpt_admin_section_domains' => 'דומיינים',
    'rpt_admin_section_personal_domains' => 'דומיינים אישיים',

    'rpt_reseller_section_personal_domains' => 'דומיינים אישיים',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "אפשר מכירת יתר",
    'limits__reseller_oversell_description' => "מכירת יתר מאפשרת למשווק למכור יותר משאבים מאלה שהוקצו לו/לה בפועל. אם מכירת יתר מותרת, המשווק כפוף לשימוש במשאבים בפועל במקום על ידי הקצאת משאבים התחלתית",
    'limits__overuse_block_text' => "מדיניות שימוש יתר",
    'limits__overuse_block_true_text' => "שימוש יתר אינו מותר",
    'limits__reseller_overuse_block_true_description' => "חסום את שימוש היתר במשאבים. השימוש במשאבים בפועל לא יכול לחרוג מהקצאת המשאבים ההתחלתית",
    'limits__overuse_block_false_text' => "מותר שימוש יתר",
    'limits__reseller_overuse_block_false_description' => "אין לחסום את שימוש היתר במשאבים, המאפשר למשווק להשתמש ביותר משאבים מאלה שסופקו לו בהתחלה. השימוש במשאבים בפועל יכול לחרוג מהקצאת המשאבים ההתחלתית",
    'limits__reseller_overuse_notify_text' => "דווח למשווק כאשר המערכת מגיעה למגבלת המשאבים",
    'reseller_perm__manage_sh_access_disabled' => "משווקים אינם יכולים לאפשר או לאסור גישה למעטפת",
    'reseller_perm__manage_sh_access_chrooted' => "משווקים יכולים לאפשר גישה רק לסביבה שעברה chroot",
    'reseller_perm__manage_sh_access_any' => "משווקים יכולים לאפשר גישה לכל סוג מעטפת",
    'template__reseller_num_excl_ips' => "הקצה כתובות IP ייעודיות למשווק",

    // Reseller's Home page
    'domains__reseller_info' => "%1 לקוחות, %2 דומיינים, %3 שטח דיסק בשימוש, %4 מהנתונים הועברו.",
    'domains__reseller_info_hiding_traffic' => "%1 לקוחות, %2 דומיינים, %3 משטח הדיסק נמצאים בשימוש.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "כל יישומי האינטרנט ממוינים כעת לפי קטגוריות, דבר שמקל על בחירת היישום הנכון להתקנה.",
    'feature__domainkeys__reseller' => "ניתן להשתמש במנגנון אימות שולח דוא\"ל DKIM כדי להפחית את כמות דוא\"ל הזבל והדיוג.",

    '__reseller_form' => "טופס משווק",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "הפוך תבנית זו לזמינה למשתמשים אחרים",
    'template__shared_description' => "בחר באפשרות זו אם ברצונך שהלקוחות יוכלו להשתמש בתבנית זו.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "מנהל דומיין אינו יכול לאפשר או לאסור גישה למעטפת",
    'domain_perm__manage_sh_access_chrooted' => "מנהל דומיין יכול לאפשר גישה רק לסביבה שעברה chroot",
    'domain_perm__manage_sh_access_any' => "מנהל דומיין יכול לאפשר גישה לכל סוג מעטפת",

    // APS Catalog
    'bt_add_to_vault' => "הוספה למאגר",
    'bt_hide_updates' => "הסתר עדכונים זמינים",
    'bt_show_updates' => "הצג עדכונים זמינים",

    '__site_apps__applications' => "יישומים",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "יישומים שנבחרו להוספה למאגר",
    'site_apps__application_selected' => "נבחר",
    'site_apps__currently_in_vault' => "גירסאות אחרות כבר נמצאות במאגר:",
    'site_apps__new_versions' => "גירסאות חדשות:",
    'site_apps__patches' => "תיקונים:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "מספר היישומים המתוזמנים להוספה למאגר: %1",
    'site_apps__applications_downloading_now' => "היישומים הבאים מורדים כעת: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "כבר נמצא בכספת",

    // Server > Action Log
    'bt_skin_edit' => "עריכת תיאור מעטפת",
    'limits__oversell_legend' => "מכירת יתר",
    'limitsManager__limit_available_error' => "לא ניתן להקצות את כמות המשאבים הנדרשת (%%quantity%% %%limitName%%). זמינים רק %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "לא ניתן להגדיר את המגבלה הנדרשת על שימוש במשאבים (%%quantity%% %%limitName%%), מכיוון שהערך החדש קטן מכמות המשאבים השמורים עבור לקוחותיך או מכמות המשאבים בהם אתה משתמש (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "לא ניתן להגדיר את המגבלה הנדרשת על שימוש במשאבים (%%quantity%% %%limitName%%), מכיוון שהערך החדש קטן מכמות המשאבים שכבר משמשים את החשבון ואת האתרים שלך בפועל (%%used%% %%limitName%%).",

    'domains_list__resource__filter_title' => "שימוש במשאבים",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "קטלוג יישומי APS",
    'site_apps__applications_have_updates' => "זמינות גירסאות מעודכנות של היישומים הבאים: %1 כדי להציג את העדכונים, ודא שאזור החיפוש נראה לעין, בחר בתיבת הסימון <b>הצג עדכונים בלבד</b> וחפש את היישומים הרצויים.",
    'site_apps__progress_adding_to_vault' => "מוסיף למאגר:",
    'site_apps__progress_done_message' => "התקדמות:",
    'site_apps__progress_applications_left' => "נותרו %1 יישומים מתוך %2",
    'site_apps__download_item_long_task_title' => "הורד יישום APS (%1)",
    'site_apps__download_transaction_long_task_title' => "הורד יישום APS מקטלוג APS",
    'site_apps__last_check_for_updates' => "חיפוש אחרון של עדכונים: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "כל היישומים המתוזמנים נוספו בהצלחה למאגר היישומים",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 יישומים מתוזמנים נוספו בהצלחה למאגר היישומים.",
    'site_apps__no_search_results' => 'לא נמצאו יישומים. נסה בקשת חיפוש שונה או עיין ביישומים לפי קטגוריות.',
    'site_apps__search_results_title' => 'תוצאות חיפוש',
    '__site_apps__search_by_application' => 'שם יישום',
    '__site_apps__search_by_vendor' => 'ספק',
    '__site_apps__search_by_vendor__all' => 'כל הספקים',
    '__site_apps__search_by_packager' => 'כורך האובייקטים',
    '__site_apps__search_by_certification_level' => 'רמת אישור',
    '__site_apps__search_by_cert__any' => 'כלשהו',
    '__site_apps__search_by_cert__silver_and_higher' => 'כסף ומעלה',
    '__site_apps__search_by_cert__gold_and_higher' => 'זהב ומעלה',
    '__retry' => 'נסה שוב',
    'site_apps__application_packager_site' => 'כורך האובייקטים',
    'site_apps__add_to_pool_message' => "יישומים המסומנים כ\"זמינים לכל\" מופצים באופן אוטומטי לכל המשווקים והלקוחות בכמות התקנות בלתי מוגבלת. יישומים מוגבלים מופצים לכל המשווקים והלקוחות באופן ידני על בסיס אישי במספר מצוין במפורש של התקנות זמינות.",
    'site_apps__make_available_for_all' => "הפוך את היישומים שנבחרו זמינים לכל המשתמשים",

    'site_apps__broadcast_app_text' => "יישומים המסומנים כ\"זמינים לכל\" מופצים באופן אוטומטי לכל המשווקים והלקוחות בכמות התקנות בלתי מוגבלת. יישומים מוגבלים מופצים לכל המשווקים והלקוחות באופן ידני על בסיס אישי במספר מצוין במפורש של התקנות זמינות.",
    'site_apps__broadcast_app_name' => 'הפוך את היישום זמין לכל המשתמשים',

    // User Application Pool per application
    'site_apps__available_clients' => 'משתמשים זמינים',
    'site_apps__no_more_clients_to_add_to_pool' => 'אין עוד חשבונות משתמשים שניתן לספק להם את היישום הזה',

    // Installed application instances
    'site_apps__installations' => 'התקנות',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "שם וכתובת IP של דומיין",
    '__assign_ip_address' => "הקצה כתובת IP",
    '__switch_on_service' => "הפעל שירות",
    '__hosting_configuration' => "תצורת אחסון אתרים",
    '__vrt_hst' => "אחסון אתר אינטרנט",
    '__vrt_hst_hint' => "אחסן אתר אינטרנט בשרת זה.",
    '__fwd' => "העברה",
    '__web_hosting_settings' => "הגדרות אחסון אתרים",
    '__fwd_hint' => "נתב מחדש מבקרים לאתר אינטרנט אחר.",
    '__none_hint' => "אין לאחסן אתר אינטרנט כרגע.",
    '__login_hint' => "שם משתמש זה משמש לגישה לאתר האינטרנט שלך באמצעות FTP",
    '__password_hint' => "סיסמה זו משמשת לגישה אל אתר האינטרנט שלך באמצעות FTP",
    '__advanced_hosting_setup' => "קבע תצורת הגדרות מתקדמות של אחסון אתרי אינטרנט",
    '__domain_creation_successful' => "הדומיין נוצר.",
    'bt_hosting_settings' => "הגדרות אחסון אתרים",
    '__change_hosting_type' => "שנה סוג אחסון אתרים עבור הדומיין %1",
    '__hosting_type_change_warning' => "אם תשנה את אחסון האתרים לסוג 'העברה הלאה' או 'ללא אחסון אתרים', כל הקבצים והספריות הקשורים לאתר שלך יוסרו מהשרת. הקפד לשמור עותק מקומי של האתר שלך.",
    '__current_hosting_type' => "סוג אחסון אתרים נוכחי",
    '__new_hosting_type' => "סוג אחסון אתרים חדש",
    '__fwd_settings' => "הגדרות העברה",
    '__fwd_settings_legend' => "הגדרות העברה",
    '__fwd_destination_url' => "כתובת URL יעד",
    '__fwd_type' => "סוג העברה",
    '__fwd_type_standart' => "העברה סטנדרטית",
    '__fwd_type_standart_hint' => "נתב מחדש מבקרים באתר האינטרנט לאתר אחר והצג להם את כתובת היעד, כך שידעו על הניתוב מחדש.",
    '__fwd_type_frame' => "העברה בתוך מסגרת",
    '__fwd_type_frame_hint' => "ניתוב מחדש של מבקרים לאתר אחר, מבלי להראות להם את כתובת היעד, כך שאינם יודעים על הניתוב מחדש.",
    '__hosting_type_template_warning' => "סוג אחסון האתרים שבחרת שונה מהסוג שמצוין בתבנית. אם תמשיך, המערכת תתעלם מהגדרות אחסון אתרים בתבנית שנבחרה. האם אתה בטוח שברצונך להגדיר את סוג אחסון האתרים?",

    '__no_resellers_selected' => "עליך לבחור חשבון ספק אחד לפחות.",

    'ippool_Manager__no_available_ips' => "אין במאגר ה-IP כתובות IP פנויות.",
    'ippool_Manager__ip_shared' => "משותפים",
    'ippool_Manager__ip_exclusive' => "ייעודי",

    'ippoolManager__ip_shared' => "משותפים",
    'ippoolManager__ip_exclusive' => "ייעודי",

    '__users_list' => "משתמשים",
    '__users' => "משתמשים",
    '__user_name' => "שם המשתמש",

    'limit__name_max_dom_aliases' => "כינויי דומיינים",
    'limit__name_max_subftp_users' => "חשבונות FTP נוספים",
    'limit__name_max_mssql_db' => "מסדי נתוני Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "מאגרי יישומי IIS",
    'limit__name_max_odbc' => "חיבורי ODBC",
    'total_mboxes_quota_unsupported' => 'לא נתמך על ידי שרת הדואר',
    'limit_soft__disk_space' => 'דווח כאשר המערכת מגיעה למגבלה על שטח דיסק',
    'limit_soft__max_traffic' => 'דווח כאשר המערכת מגיעה למגבלה על תעבורה',
    'limitsManager__commit_failed' => "לא ניתן לשנות מגבלות משאבים.",
    'limitsManager__date_in_past' => "תאריך התפוגה %1 שגוי.",
    'limitsManager__limit_not_supported' => "לא ניתן להגדיר מגבלות עבור סוג המשאב %1.",
    'limitsManager__limit_oversell_inconsistency' => "לא ניתן להקצות את כמויות המשאבים שצוינו כאשר מכירת יתר כבויה.",
    'limitsManager__limit_overuse_inconsistency' => "השימוש במשאבים חורג מהמגבלות שהוגדרו.",
    'limitsManager__no_resource_available' => "לא נשארו משאבים זמינים מסוג זה (%%limitName%%). נדרש: %%quantity%%; זמין: %%unused%%.",
    'limitsManager__no_total_resource_available' => "אין משאבים זמינים מסוג זה (%%limitName%%) מספק השירות שלך. נדרש: %%quantity%%; זמין: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "תאריך התפוגה חייב להיות קטן או שווה ל-%1.",
    'limitsManager__invalid_disk_space_limit' => "כמות שטח הדיסק חייבת להיות נמוכה או שווה ל-%1.",
    'limitsManager__invalid_max_traffic_limit' => "כמות התעבורה חייבת להיות נמוכה או שווה ל-%1.",
    'ippoolManager__ip_has_suballocations' => "לא ניתן לשנות את סוג כתובת IP שכבר הוקצתה למשתמש. כתובת ה-IP‏ %%ip%% כבר מוקצית למשתמשים ככתובת IP‏ %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "כתובת IP זו כבר מוקצית למשתמש.",
    'ippoolManager__ip_is_not_in_pool' => "אין כתובת IP‏ %%ip%% במאגר.",
    'ippoolManager__can_not_allocate_ip' => "כתובת ה-IP‏ %%ip%% זמינה רק כ-%%available%%.",
    'ippoolManager__unable_to_set_default_type' => "לא ניתן להקצות את כתובת ה-IP‏ %%ip%% כייעודית.",
    'ippoolManager__ip_used_by_hst_or_frw' => "כתובת ה-IP‏ %%ip%% כבר משמשת לאחסון אתרים.",
    'ippoolManager__active_anon_ftp_on_ip' => "גישת FTP אנונימי כבר מופעלת עבור כתובת ה-IP‏ %%ip%%",
    'ippoolManager__no_vacant_ips' => "אין כתובות IP פנויות.",
    'ippoolManager__no_available_ips' => "אין כתובות IP זמינות.",
    'templates__dublicate_name' => "כבר קיימת תבנית בשם כזה. בחר שם אחר עבור תבנית זו.",
    'cl_perm__client_limits_exceeded' => "ערכי מגבלת המשאבים שצוינו חורגים מהערכים שמתירה תוכנית אחסון האתרים שלך, או שערכים אלה מספקים פחות משאבים מאלה שהאתרים שלך משתמשים בהם כרגע.",
    'cl_perm__reseller_limits_exceeded' => "ערכי מגבלת המשאבים שצוינו חורגים מהערכים שמתירה תוכנית אחסון האתרים שלך, או שערכים אלה מספקים פחות משאבים מאלה שמשתמשים בהם חשבונות משתמשים ואתרים.",

    'site_apps__preferences_show_all_versions_title' => "הצג את הרשימה המלאה של גירסאות עבור כל יישום שאוחזר מהקטלוג",
    'site_apps__preferences_show_all_versions_hint' => "אם תבחר באפשרות זו, ייתכן שייקח זמן רב לאחזר את כל הגירסאות של כל יישום בכל פתיחה של הקטלוג. אם לא תבחר באפשרות זו, יוצגו רק הגירסאות העדכניות ביותר.",
    '__select_user_template' => "צור חשבון משתמש על סמך תבנית",
    'ip_already_added_to_all_clients' => "כתובת IP זו כבר מוקצית לכל המשתמשים.",

    'site_apps__cancelled_apps' => "ביטלת את הוספת היישומים הבאים: %2",

    'sb_url_is_not_resolved' => 'לא ניתן לפענח את כתובת ה-URL: בדוק את הגדרות ה-DNS שלך. כתובת ה-URL‏ %1 חייבת להיות מפוענחת בכתובת IP של השרת עם בונה נוכחות מותקן.',

    'ip_addr__is_last_on_interface' => 'לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא כתובת ה-IP האחרונה שנמצאת בממשק רשת.',
    'ip_addr__used_for_current_session' => 'לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת הפעלה פעילה.',
    'ip_addr__used_for_hosting' => 'לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת לאחסון אתר אינטרנט.',
    'ip_addr__is_main' => 'לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא כתובת ה-IP הראשית של ממשק רשת.',
    'ip_addr__ip_used_by_message_submission' => 'לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת לשליחת הודעת הדואר',

    // RESELLER ACTION LOG

    '__cl_domains' => 'דומיינים של לקוחות',
    'excl_ip_num' => 'כתובת IP ייעודית',

    'sb_err_sitebuilder_not_installed' => 'בונה הנוכחות אינו מותקן.',

    '__perm_allow_oversell_can_not_be_revoked' => 'לא ניתן לשלול ממשתמש הרשאה להיתר מכירת יתר מכיוון שהמשתמש כבר הקצה יותר משאבים מאלו שזמינים, ועבר למצב מכירת יתר.',
    'limitsManager__invalid_limit_value' => 'צוין ערך שגוי %%value%% עבור המגבלה %%limit_name%%',
    'limit__max_mn' => 'מספר מרבי של חשבונות דוא"ל',

    'limits__client_overuse_description' => 'מדיניות שימוש יתר מורה ל-Plesk מה לעשות כאשר ניצול המשאבים חורג מהקצאת המשאבים ההתחלתית.',
    'limits__client_overuse_block_true_description' => 'חסום את שימוש היתר במשאבים. השימוש במשאבים בפועל לא יכול לחרוג מהקצאת המשאבים ההתחלתית',
    'limits__client_overuse_block_false_description' => 'אין לחסום את שימוש היתר במשאבים המאפשר ללקוח להשתמש ביותר משאבים מאלה שסופקו לו בהתחלה. השימוש במשאבים בפועל יכול לחרוג מהקצאת המשאבים ההתחלתית',
    'limits__client_overuse_notify_text' => 'דווח ללקוח כאשר המערכת מגיעה למגבלת המשאבים',

    'limits__domain_overuse_description' => 'מדיניות שימוש יתר מורה ל-Plesk מה לעשות כאשר ניצול המשאבים חורג מהקצאת המשאבים ההתחלתית.',
    'limits__domain_overuse_block_true_description' => 'מדיניות שימוש יתר אומרת ל-Plesk מה לעשות כאשר נעשה שימוש יתר במשאבים.',
    'limits__domain_overuse_block_false_description' => 'אין לחסום את שימוש היתר במשאבים המאפשר לדומיין להשתמש ביותר משאבים מאלה שסופקו לו בהתחלה. השימוש במשאבים בפועל יכול לחרוג מהקצאת המשאבים ההתחלתית',
    'limits__domain_overuse_notify_text' => 'דווח לבעלי הדומיין כאשר המערכת מגיעה למגבלת המשאבים',

    'dns__dns_rr_delete' => 'פריטים שיוסרו',
    'dns__delete_rr' => 'רשומות ה-DNS הבאות יוסרו מאזור ה-DNS‏:',
    'dns__dns_rr_delete_non_removable' => 'פריטים שלא ניתן להסיר',
    'dns__non_delete_rr' => 'לא ניתן להסיר את רשומות ה-DNS הבאות:',
    'dns__dns_rr_delete_confirm_message' => 'אשר את ההסרה של רשומות DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'תבנית יישום אינטרנט לא מוכרת: יישום האינטרנט עלול להיות לא זמין להתקנה ולשימוש.',

    '__php_handler_type_desc' => 'הפעל PHP כ',
    'sfdk_domain_sign__failed' => 'אירעה שגיאה לא מזוהה בניסיון להפעיל חתימת דואר באמצעות DKIM בדומיין. למידע נוסף, עיין ביומן השגיאות של השרת.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'הודעת הצלחה של עדכון מפתח של Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'הודעת דחייה של עדכון מפתח של Plesk',
    'pkey_notify__subj_update_error_notification' => 'הודעת שגיאה של עדכון מפתח של Plesk',
    'pkey_notify__update_successful' => '%1 עדכון הושלם בהצלחה.',
    'pkey_notify__update_failed_no_more_try' => 'לא ניתן לעדכן את %1. המפתח שאתה מנסה לשלוח אינו חוקי. אין עוד צורך שתנסה לעדכן מפתח זה.',
    'pkey_notify__update_failed_try_later' => 'לא ניתן לעדכן את %1: אירעה שגיאה במהלך עיבוד המפתח שלך. ניתן לנסות לאחזר את המפתח ידנית ב-Plesk (\'כלים והגדרות\' > \'פרטי רישיון\') או לאפשר ל-Plesk לנסות לעדכן אותו במהלך 24 השעות הקרובות. אם אינך רוצה עוד לקבל הודעה זו, הסר מפתח זה מ-Plesk.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'דומיינים',
    'rpt_reseller_dom_subdomains' => 'תת-דומיין',
    'rpt_reseller_dom_domain_aliases' => 'כינויי דומיינים',
    'rpt_reseller_dom_postboxes' => 'תיבות דואר',
    'rpt_reseller_dom_redirects' => 'רכיבי העברה',
    'rpt_reseller_dom_mail_groups' => 'קבוצות דואר',
    'rpt_reseller_dom_mail_resps' => 'תגובה אוטומטית',
    'rpt_reseller_dom_mail_antispam' => 'נגד הודעות זבל',
    'rpt_reseller_dom_mail_antivirus' => 'אנטי-וירוס',
    'rpt_reseller_dom_mail_lists' => 'רשימות דיוור',
    'rpt_reseller_dom_web_users' => 'משתמשי אינטרנט',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'לקוחות',
    '__cl_name' => 'שם הלקוח',
    '__cl_creation_date' => 'תאריך יצירה',
    '__clients_traffic' => 'תעבורה של לקוח',
    'rpt_reseller_cl_mail_antispam' => 'נגד הודעות זבל',
    'rpt_reseller_cl_mail_antivirus' => 'אנטי-וירוס',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'בונה הנוכחות אינו מותקן.',
    'sitebuilder_disabled' => 'בונה הנוכחות כבוי.',
    'b_sitebuilder_disabled' => 'בונה הנוכחות כבוי.',
    'webmail_not_installed' => 'לא מותקנת תוכנת דואר אינטרנט.',
    'webmail_disabled' => 'שירות דואר האינטרנט כבוי.',
    'spamassassin_not_installed' => 'SpamAssassin אינו מותקן.',
    // pfu:
    'anonymous_ftp_shared' => 'לא ניתן להגדיר FTP אנונימי: סוג כתובת IP משותפת.',
    'anonymous_ftp_used' => 'לא ניתן להגדיר FTP אנונימי: בכתובת ה-IP משתמש דומיין אחר עבור שירות FTP אנונימי.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET אינו מותקן.',
    'site_builder_no_package' => 'בונה הנוכחות אינו זמין. בדוק שבונה הנוכחות מותקן ונבחר כרכיב פעיל.',
    'site_builder_not_configured' => 'לא נקבעה תצורת בונה הנוכחות.',

    // various

    'disabled_by_admin' => 'מנוטרל על ידי מנהל השרת',

    '__not_allowed' => 'לא מותר',

    '__ip_addr_state_unknown' => "כתובת ה-IP אינה ניתנת להפעלה כעת מכיוון שהמערכת מעבדת עדיין את בקשתך. המתן דקה.",

    'ip_addr__repair_is_not_allowed' => 'לא ניתן לתקן כתובת IP תחת סביבת Virtuozzo.',

    'ippoolManager__ip_used_by_nohost_domain' => "לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת דומיין אחד או יותר ללא אירוח.",
    'ippoolManager__ip_used_for_mail_service' => "לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת דומיין אחד או יותר ככתובת ה-IP של שירות הדואר.",
    'ippoolManager__ip_used_for_send_emails' => "לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת לשליחת דוא\"ל מכתובת IP ספציפית (ראה 'הגדרות שרת דואר').",
    'ippoolManager__ip_used_in_dns_zone' => 'לא ניתן להסיר את כתובת ה-IP‏ %%ip%% מכיוון שהיא משמשת אזור DNS של דומיין אחד או יותר.',
    'ip_ctrl__cannot_manage_on_vz' => 'התקנה זו של Plesk עובדת תחת גורמים מכילים של Virtuozzo. רק מנהל הצומת של הגורמים המכילים של Virtuozzo יכול להוסיף כתובות IP חדשות.',

    'client_template__limits_auto_adjusted' => 'מגבלות מתבנית לקוח הותאמו באופן אוטומטי.',

    '__entries' => 'ערכים',

    '__path_is_not_set' => 'לא צוין הנתיב. ציין נתיב חוקי.',

    'defaultcomponents__imap_required' => '(שרת הדואר הנוכחי אינו תומך ב-IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk תומך רק בתוכנה מסחרית של סטטיסטיקת אינטרנט לחישוב נתונים סטטיסטיים של תת-דומיינים. במערכת לא מותקנת כרגע תוכנה כזו.',


    'server_settings_invalid_traffic_statistics' => 'שמירה שגויה פרמטר סטטיסטיקת תנועה.',
    'server_settings_invalid_logrotate_period' => 'פרמטר פרק זמן רענון יומן שגוי.',

    'spam_filter/address/file_size' => 'לא ניתן להעלות את הקובץ. הגודל המקסימלי של קובץ להעלאה הוא %1.',
    'spam_filter/address/file_empty_content' => 'קרתה שגיאה בקריאת כתובות האימייל מהקובץ. יש לוודא שאתם מעלים קובץ בקידוד UTF-8 שמכיל כתובת אימייל אחת או יותר ונסו שוב.',
    'spam_filter/address/addresses_empty_content' => 'אין כתובות דוא"ל ברשימה.',
    'spam_filter/address/addresses_available' => 'רק %1 כתובות דוא"ל ייחודיות יוספו.',
    'spam_filter/address/invalid_addresses' => 'כתובות הדוא"ל הבאות אינן חוקיות: %1.',

    'current_resources' => 'המשאבים הנוכחיים',
    'plan_limitations' => 'מגבלות התוכנית',
    'cannot_switch_plan' => 'אי אפשר להחליף לתוכנית שנבחרה כי המשאבים הנוכחיים חורגים ממגבלות התוכנית:',
];