<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Erişim reddedildi.  Hesabınız askıya alındı.",
    'login_up__login_has_been_locked' => "Çok fazla sayıda yanlış bir şifreyi kullanarak oturum açmaya çalıştınız. Güvenlik nedenlerinden ötürü, bir süre bu kullanıcı adıyla oturum açamazsınız.",
    'login_up__unable_to_check_pass' => "Şifre kontrol edilemiyor: %1",
    'login_up__warning_limits_licence_key' => "Aşağıdaki öğelerden biri, lisans anahtarınızla tanımlanan sınırı aştı: sunucunuzda barındırılan kullanıcı hesabı, alan adları, posta hesabı veya web kullanıcısı sayısı.\nLütfen istediğiniz sayıda kullanıcıyı ve etki alanını barındırmanıza izin verecek bir anahtar satın almak için Plesk satış departmanıyla irtibata geçin. Bu mesajı yanlışlıkla aldığınızı düşünüyorsanız lütfen Plesk teknik destek departmanıyla irtibata geçin.\nKullanıcı hesapları/alan adları/posta hesapları/web kullanıcıları/dil paketleri için lisanslı sınır: %2.\nŞu an barındırılan kullanıcı hesapları/alan adları/posta hesapları/web kullanıcıları/dil paketleri sayısı: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Çalıştığınız kaynakların miktarı, geçerli ürün lisansınızla tanımlı sınırları aştı. Lütfen Plesk satış departmanıyla irtibata geçin ve yeni bir lisans anahtarı satın alın.",
    'login_up__grace_period' => 'Şu an ürün lisansınızın ödemesiz süresinde çalışıyorsunuz. Ürün lisansınızı güncellemek için, %1Lisans Bilgisi sayfasındaki%2 Anahtarları Kurtar seçeneğini seçin.',
    'login_up__partner_license_message' => 'Şu an tam özellik kümesini etkinleştirmeden önce kaydolmanızı gerektiren sınırlı bir ürün lisansıyla çalışıyorsunuz. Ürün lisansınızı güncellemek için, %1Lisans Bilgisi sayfasındaki%2 Anahtarları Kurtar seçeneğini seçin.',
    'login_up__system_admin_disabled' => 'Superuser\'ın (kök veya yönetici hesabı) güvenlik nedenleriyle Plesk\'te oturum açması yasaktır.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk Yöneticisinin Kılavuzu",
    'plesk_guide_reseller' => "Plesk Satıcısının Kılavuzu",
    'plesk_guide_client' => "Plesk Müşterisinin Kılavuzu",
    'plesk_guide_domain_admin' => "Plesk Alan Adı Yöneticisinin Kılavuzu",
    'plesk_guide_mailuser' => "Plesk E-Posta Kullanıcısının Kılavuzu",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Arayın', // multiple usage: TBI
    'nav__general' => 'Ana Menü',
    '__home' => 'Anasayfa',
    '__applications' => 'Başvurular',
    '__settings' => 'Ayarlar',
    'nav__system' => 'Sistem',
    '__master' => 'Ana',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Bir üst Seviye',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Sil',
    'bt_make_default' => 'Varsayılan Yap',

    // common list object search keys
    'bt_show_all' => "Aramayı sıfırla",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Etkin',
    '__object_off' => 'Askıya alınmış',

    '__home_description' => 'Başlangıç sayfasına dönün.',
    'indicator_title' => '%1% kullanıldı, %2% boş', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'Geçersiz URL istendi.',

    // business objects
    'mn_list__mail_names_for_client' => '%1 Kullanıcı Hesabı altındaki Posta Hesapları',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'Adı',
    'domains_list__state__filter_title' => 'Kaynak Kullanımı',
    'domains_list__filter_state_any' => 'Herzaman',
    'domains_list__filter_state_overuse' => 'Fazla kullanım',
    'domains_list__filter_state_normal' => 'Sınırlar dahilinde',
    'domains_list__status__filter_title' => 'Durum',
    'domains_list__filter_status_any' => 'Herzaman',
    'domains_list__filter_status_blocked' => 'Askıya alınmış',
    'domains_list__filter_status_active' => 'Etkin',
    'domains_list__subrows__filter_title' => 'Göster',
    'domains_list__subrows_off' => 'Sadece alan adları',
    'domains_list__subrows_subdomain_domainaliases' => 'Alt alan adlarıyla ve takma adlarıyla',
    'domains_list__subrows_subdomain' => 'Alt alan adlarıyla',
    'domains_list__subrows_domainaliases' => 'Takma adlarıyla',

    // objects list
    'domains_list__owner__title' => 'Sahibi',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Uygulamalara gözat",
    'site_apps__promo_main_text' => "Uygulama Paketleme Standardı (APS) katalogu, bir alan adına veya web alanına sağlanabilecek uygulamaların listesini içerir. Şu an katalogda olmayan uygulamaları sağlamak istediğinizde, bunu www.apsstandard.com üzerindeki APS paketleme talimatlarını izleyerek gerçekleştirebilirsiniz",
    'site_apps__promo_download_now' => "Uygulamaları İndirin:",
    'site_apps__promo_close' => "Bu bloğu kapatın",
    'site_apps__promo_preset__mostused' => '%1 En Popüler',
    'site_apps__promo_preset__lessused' => 'Sonraki %1 En Popüler',
    'site_apps__promo_preset__all' => "Hepsi",
    'site_apps__promo_disclaimer_note' => 'Lütfen APS Katalogundan yüklenen uygulamaların üçüncü kişiler tarafından sağlandığından ve Plesk tarafından desteklenmediğinden emin olun.',
    'site_apps__promo_preset__page_title' => '%1 APS Uygulamaları',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Uygulamaları eklemeyin...',

    // Errors
    'site_apps__no_applications_for_update' => 'Uygulama Deposunda yüklü hiçbir uygulamanız yok.',
    'site_apps__incorrect_download_preset_configuration' => 'APS Katalogu indirmesi ön ayarını yapılandırmada hata bulundu.',
    'site_apps__aps_catalog_url_is_invalid' => 'Belirtilen URL geçerli değil.',
    'site_apps__no_updates_at_the_moment' => 'Şu an kullanılabilir hiçbir uygulama güncellemesi yok.',
    'site_apps__incorrect_content_returned_by_catalog' => 'APS uygulamaları katalogundan yanlış bilgiler alındı. Lütfen daha sonra yeniden deneyin.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS katalogu ayarları kaydedildi, ancak Plesk, APS katalogu ayarlarında (%1) belirtilen APS kataloguyla bir bağlantı oluşturamadı. APS katalog adresi doğru olduğundan ve bu adresteki APS katalogu etkin olduğundan emin ol.',
    'site_apps__cannot_retrieve_updates' => 'Şu an uygulama güncellemeleri indirilemiyor: APS kataloguyla (%1) bağlantı oluşturulamıyor.  APS katalog adresi doğru olduğundan ve bu adresteki APS katalogu etkin olduğundan emin ol.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Kurulum için kullanılabilir web uygulaması yok.',
    'site_apps__site_applications_already_installed_in_root' => 'Diğer web uygulamaları zaten bu sanal ana bilgisayarların kök dizinlerinde yüklü',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET web uygulamaları Unix/Linux platformunda desteklenmiyor",
    'site_apps__server_wide_packages_not_supported' => 'Sunucu çapında web uygulamaları desteklenmiyor',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 web uygulamasının daha Uygulama Deposuna eklenmesi planlandı.",
    'site_apps__applications_all_in_vault' => "Seçilen web uygulamaları Uygulama Deposunda zaten var.",
    'site_apps__applications_already_in_download_queue' => "Seçilen %1 web uygulaması şu an Uygulama Deposuna ekleniyor.",
    'site_apps__applications_already_in_valut' => "Seçilen %1 web uygulaması zaten Uygulama Deposunda.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Diğer (kategorileştirilmemiş)',

    // Errors
    'site_apps__no_applications_in_category' => 'Bu kategoride kullanılabilir hiçbir uygulama yok.  Lütfen başka bir kategori seçin.',
    'site_apps__no_category_selected__please_specify' => 'Soldaki menüden bir kategori seçin.  Seçilen kategorideki kullanılabilir tüm uygulamalar bu pencerede sıralanır.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Yönetici hesabı',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Genel',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Host adını değiştir',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Güvenlik',
    'bt_setup_firewall' => 'Güvenlik duvarını ayarlayın',
    'bt_manage_firewall_rules' => 'Güvenlik duvarı kurallarını yönetin',
    'cu_firewall__rule' => 'Bir güvenlik duvarı kuralı oluşturun',
    'cu_firewall__protocol' => 'Kural için bir iletişim kuralı ayarlayın (\'tcp\' veya \'udp\')',
    'cu_firewall__name' => "Bir kural adı ayarlayın",
    'cu_firewall__disabled' => '\'true\' ise, oluşturulduktan sonra kural devre dışı bırakılır',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'DNS sunucusunu seçin', // PFW
    'bt_soa_records_template' => 'SOA kayıtları şablonu',
    'bt_restrict_creation_of_subzones' => 'Alt bölge oluşturmayı sınırlayın',

    'databases' => 'Veritabanları',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Başvurular',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Posta',
    'bt_select_mailserver' => 'Posta sunucusunu seçin', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Antivirüsü seçin', // PFW
    'bt_virus_protection_settings' => 'Virüs koruma ayarları',
    'bt_select_spamfilter' => 'Gereksiz posta filtresini seçin', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Web Postasını Seçin',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Günlükler ve istatistikler',
    'bt_server_statistics_settings' => 'Sunucu istatistikleri ayarları',
    'bt_select_web_statistics' => 'Kullanılabilir web istatistikleri yazılımı', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk arayüzü',

    'components_and_modules' => 'Bileşenler ve modüller',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'VPN ayarlayın', // PFU
    'bt_setup_samba' => 'Samba ayarlayın',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'Alan adı yönetici hesabı',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Hesap ayarları',

    'domain' => 'Alan Adı',
    'bt_dns_soa_records' => 'DNS SOA kayıtları',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Görev planlayıcısı ayarları',

    'website' => 'Web Sitesi',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Web kullanıcıları için komut dosyaları',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'SSL/TLS sertifikasını seçin',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Web istatistikleri',
    'bt_log_rotation_settings' => 'Günlük döndürme ayarları',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limitler", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Fazla kullanım ve fazla satma ilkesi",
    'limits__overuse_policy_legend' => "Fazla kullanım",
    'limits__oversell_policy_legend' => "Fazla satış",
    'limits__reseller_overuse_description' => "Fazla kullanma ilkesi Plesk'e, kaynaklar fazla kullanıldığında ne yapılması gerektiğini söyler.",
    'limits__overuse_text' => "Fazla kullanım ilkesi",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Disk alanı ve trafiği',
    'limit__disk_space' => 'Disk alanı',
    'limit__max_traffic' => 'Trafik',
    'limit_group__client' => 'Müşteriler',
    'limit__max_cl' => 'Müşteriler',
    'limit_group__domain' => 'Alan Adları',
    'limit__max_dom' => 'Alan Adları',
    'limit__max_dom_powerUser' => 'Abonelik',
    'limit__max_subdom' => 'Alt alan adları',
    'limit__max_dom_aliases' => 'Takma alan adları',
    'limit__max_wu' => 'Web Kullanıcıları',
    'limit__max_subftp_users' => 'Ek FTP hesapları', // PFW
    'limit_group__mail' => 'Posta',
    'limit__max_box' => 'Posta kutuları',
    'limit__mbox_quota' => 'Posta kutusu boyutu',
    'limit__total_mboxes_quota' => 'Toplam posta kutusu kotası', // PFW
    'limit__max_maillists' => 'Postalama listeleri',
    'limit_group__database' => 'Veritabanları',
    'limit__max_mssql_db' => 'Microsoft SQL Server veritabanları', // PFW
    'limit__mssql_dbase_space' => 'Toplam MS SQL veritabanı kotası', // PFW
    'limit__max_odbc' => 'ODBC bağlantıları', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MariaDB/MySQL Veritabanları kotası', // PFW
    'limit__pgsql_dbase_space' => 'PostgreSQL veri tabanı kotası', // PFW
    'limit_group__application' => 'Başvurular',
    'limit__max_iis_app_pools' => 'IIS uygulama havuzları', // PFW
    'limit_group__security' => 'Güvenlik',
    'limit_group__validity' => 'Son kullanım tarihi',
    'limit__expiration' => 'Son kullanım tarihi',
    'limit__validity' => 'Geçerlilik dönemi',
    'limit__max_site_builder' => 'Presence Builder\'la yayınlanan siteler',
    'limit__max_site' => 'Alan Adları',
    'limit__mssql_dbase_filesize' => 'MS SQL veritabanı dosya boyutu',
    'limit__mssql_dbase_log_filesize' => 'MS SQL veritabanı günlük dosyası boyutu',
    'limit__mssql_dbase_filesize_hint' => 'Bir Microsoft SQL veritabanının maksimum dosya boyutu.',
    'limit__mssql_dbase_log_filesize_hint' => 'Bir Microsoft SQL veritabanının maksimum günlük dosyası boyutu.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Geçersiz alan adları sınırı. Minimum değer 1.',

    'property__has_wrong_value' => '%1 özelliğinin değeri yanlış.',
    'property__name_outgoing_messages_domain_limit' => 'Bir alan adından giden mesajların sınırını ayarlar (saatte). Sınırsız değerini ayarlamak için, "-1" belirtin. Sunucu çapındaki ayarlarda belirtilen değeri ayarlamak için, "varsayılanı" belirtin.',
    'property__name_outgoing_messages_mbox_limit' => 'Bir posta kutusundan giden mesajların sınırını ayarlar (saatte). Sınırsız değerini ayarlamak için, "-1" belirtin. Sunucu çapındaki ayarlarda belirtilen değeri ayarlamak için, "varsayılanı" belirtin.',
    'property__name_outgoing_messages_subscription_limit' => 'Bir abonelikten giden mesajların sınırını ayarlar (saatte). Sınırsız değerini ayarlamak için, "-1" belirtin. Sunucu çapındaki ayarlarda belirtilen değeri ayarlamak için, "varsayılanı" belirtin.',

    // for CLI report & email notifications
    '__resource_notify' => 'Uyarı',
    '__general' => 'Genel',
    '__template_shared' => 'Paylaşılmış şablon',
    'limit__overuse' => 'Fazla kullanım ilkesi',
    'limit__max_traffic_soft' => 'Trafik kullanımına ulaştığında bildirin',
    'limit__disk_space_soft' => 'Disk alanı kullanımına ulaştığında bildirin',
    '__overuse' => 'Fazla kullanım ilkesi',
    'performance__title' => 'Performans',
    'performance__bandwidth' => 'Maksimum bant genişliği kullanımı (KB/sn)',
    'performance__max_connections' => 'Bağlantı sınırları',

    'gch__hosting_php_isapi' => 'PHP yi ISAPI olarak çalıştır',
    'gch__hosting_ssi_html' => '*.htm, *.html dosyaları için SSI kullanın',
    'gch__hosting_php_handler_type' => 'PHP\'yi farklı çalıştır',
    'gch__hosting_php_handler_id' => 'PHP\'yi farklı çalıştır',
    'gch__hosting_php_served_by_nginx' => 'PHP ngnix tarafından sunulur',
    'gch__hosting_unpaid_website_status' => 'Askıya alınan aboneliklerdeki web sitelerinin durumu',
    'gch__mn_no_autoresponder' => 'Posta hesabı için ayarlanmış hiçbir otomatik yanıt yok.',
    'gch__no_clients_selected' => "Hiçbir müşteri hesabı seçilmedi",
    'gch__no_domains_selected' => "Hiçbir alan adı seçili değil",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/ay",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Kaynak adı',
    '__resource_usage' => 'Kullanılmış',
    '__resource_limit' => 'Sınır',

    '__never_expires' => 'Her zaman geçerli',
    '__resource_free' => 'Toplam: %2 Boş: %1',
    '__resource_unlimited' => 'Sınırsız arasından %1 kullanıldı',

    '__unlimited' => 'Sınırsız',
    '__increment' => "Artır (+)",
    '__decrement' => "Azalt (-)",
    '__pt' => 'birimler',
    '__procent' => '%',
    '__overused' => 'Aşırı kullanılmış',
    '__left' => 'sol',
    '__available' => 'kullanılabilir',
    '__not_available' => 'Dahil değil',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Satıcı adı', // reseller report
    'report__full_client_name' => 'Müşteri adı', // customer report
    'report__full_domain_name' => 'Alan adı', // domain report
    'report__full_owner' => 'Sahibi', // customer & domain reports
    'report__full_creation_date' => 'Oluşturulma tarihi',
    'report__full_size' => 'Boyut',
    'report__full_traffic' => 'Trafik',
    'report__full_active_clients' => 'Etkin müşteriler', // reseller report
    'report__full_clients' => 'Müşteriler', // reseller report
    'report__full_active_domains' => 'Aktif alan adları', // reseller & customer reports
    'report__full_domains' => 'Alan Adları', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Postkt',
    'report__full_disk_space' => 'Disk alanı',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Yan.',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Posta listesi',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MariaDB/MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'Genel',
    'report__version' => 'Ürün sürümü',
    'report__build' => 'Ürün yapısı',
    'report__status' => 'Durum',
    'report__company_name' => 'Firma adı',
    'report__personal_name' => 'İsim',
    'report__login' => 'Kullanıcı adı',
    'report__phone' => 'Telefon',
    'report__fax' => 'Faks',
    'report__email' => 'E-posta',
    'report__address' => 'Adres',
    'report__city' => 'Şehir',
    'report__state' => 'İl/İlçe',
    'report__zip_code' => 'Posta Kodu',
    'report__country' => 'Ülke',
    'report__creation_date' => 'Oluşturulma tarihi',
    'report__expiration_date' => 'Son kullanım tarihi',
    'report__dumps_total_size' => 'Toplam yedekleme dosyaları boyutu',
    'report__section_resellers' => 'Satıcılar',
    'report__active_resellers' => 'Etkin abonelikleri olan satıcılar',
    'report__resellers' => 'Satıcılar',
    'report__section_full_resellers' => 'Satıcılar',
    'report__section_clients' => 'Müşteriler',
    'report__active_clients' => 'Etkin abonelikleri olan müşteriler',
    'report__clients' => 'Müşteriler',
    'report__section_full_clients' => 'Müşteriler',
    'report__section_personal_clients' => 'Kendi müşterileri',
    'report__active_personal_clients' => 'Etkin abonelikleri olan kendi müşterileriniz',
    'report__personal_clients' => 'Kendi müşterileri',
    'report__section_full_personal_clients' => 'Kendi müşterileri',
    'report__section_domains' => 'Alan Adları',
    'report__disk_usage' => 'Disk kullanımı',
    'report__traffic' => 'Trafik',
    'report__active_domains' => 'Aktif alan adları',
    'report__domains' => 'Alan Adları',
    'report__subdomains' => 'Alt alan adları',
    'report__mboxes' => 'Posta kutuları',
    'report__mail_groups' => 'Posta yönlendirmeleri',
    'report__mail_autoresp' => 'Otomatik yanıtlar',
    'report__mail_lists' => 'Postalama listeleri',
    'report__web_users' => 'Web Kullanıcıları',
    'report__mysql_databases' => 'MariaDB/MySQL Veritabanları',
    'report__mssql_databases' => 'MSSQL veritabanları',
    'report__pgsql_databases' => 'PostgreSQL veritabanları',
    'report__section_full_domains' => 'Alan Adları',
    'report__section_personal_domains' => 'Kişisel alan adları',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Kişisel alan adları',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Presence Builder\'la yayınlanan siteler',
    'report__invalid_email' => 'Lütfen geçerli bir e-posta adresi belirtin.',


    // CLI-specific sections
    'report__section_hosting' => 'Barındırma',
    'report__section_webusers' => 'Web Kullanıcıları',
    'report__section_mailnames' => 'Posta Hesapları',
    'report__section_maillists' => 'Postalama Listeleri',
    'report__section_databases' => 'Veritabanları',
    'report__section_siteapps' => 'Web Uygulamaları',
    'report__section_aspnetapps' => 'ASP.NET Uygulamaları', // PFW
    'report__owner_pname' => "Sağlayıcının kişisel adı",
    'report__owner_login' => "Sağlayıcının kullanıcı adı",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Belirtilen dil paketi yüklü, ancak sistemde etkinleştirilmemiş.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'Oturum belirtecinin süresi doldu.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Aşağıdaki satıcı hesapları müşteri hesaplarına dönüştürülecek',
    'downgradeResellers__downgrade' => 'Dönüştürülecek olan satıcı hesapları',
    // controls
    'downgradeResellers__submit_downgrade' => 'Hesap dönüştürmeyi gerçekleştir.',
    'downgradeResellers__cancel_downgrade' => 'Hesap dönüştürmeyi iptal edin.',
    'downgradeResellers__confirm' => 'Dönüştürmeyi onaylayın',
    'downgradeResellers__confirm_message' => 'Hesap dönüştürmeye devam etmeyi onaylayın',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'Aşağıdaki müşteri hesapları satıcı hesaplarına dönüştürülecek',
    'upgradeClients__upgrade' => 'Dönüştürülecek olan müşteri hesapları',
    // controls
    'upgradeClients__submit_upgrade' => 'Hesap dönüştürmeyi gerçekleştir.',
    'upgradeClients__cancel_upgrade' => 'Hesap dönüştürmeyi iptal edin.',
    'upgradeClients__confirm' => 'Dönüştürmeyi onaylayın',
    'upgradeClients__confirm_message' => 'Hesap dönüştürmeye devam etmeyi onaylayın',
    // errors
    'upgradeClient__user_is_already_reseller' => '\'%1\' hesabı bir satıcı hesabına dönüştürülemiyor: \'%1\' zaten bir satıcı.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Aşağıdaki alan adı yönetici hesapları, müşteri hesaplarına dönüştürülecek',
    'upgradeDomainUser__upgrade' => 'Dönüştürülecek olan alan adı yönetici hesapları',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Hesap dönüştürmeyi gerçekleştir.',
    'upgradeDomainUser__cancel_upgrade' => 'Hesap dönüştürmeyi iptal edin.',
    'upgradeDomainUser__confirm' => 'Dönüştürmeyi onaylayın',
    'upgradeDomainUser__confirm_message' => 'Hesap dönüştürmeye devam etmeyi onaylayın',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Dönüştürülemeyen alan adı yönetici hesapları',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Aşağıdaki alan adı yönetici hesapları, müşteri hesaplarına dönüştürülemedi:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Birden fazla alan adı yönetici hesabı, müşteri hesaplarına dönüştürülemedi. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Alan adı yönetici hesabı yok',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Alan adının doğrudan sunucu yöneticisine veya bir satıcıya ait olması gerekir.",
    'upgradeDomainUser__all_logins_already_used' => 'Elde edilen müşteri için bir hesap oluşturulamıyor.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Alan adı yönetici hesabı dönüştürüldü',
    'upgradeDomainUser__upgrade_notification_body' => 'Alan adı yönetici hesabınız, kullanıcı adı \'%%login%%\' ve şifresi \'%%password%%\' olan bir müşteri hesabına dönüştürüldü.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Seçilen satıcının \'%1\' izni yok, ancak müşterilerin bazılarının bu izni var.',
    'clientOwnerChanger__application_not_allowed' => 'Seçilen satıcı, \'%1\' uygulamasını kullanamaz, ancak müşterilerin bazıları onu kullanabilir.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maksimum bant genişliği kullanımı (%1)',
    'hosting_performance__max_connection_label' => 'Bağlantı sınırları',
    'performance__invalid_value' => "Değer geçersiz.  %1 ile %2 aralığında olmalıdır.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Kullanılabilir web postası istemcileri',
    'webmail__none' => 'Hiçbiri',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Sunucu IP Havuzu',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Sunucu yedeklemesi.",
    '__default_backup_comment_reseller' => "%1 tarafından satıcı hesabı yedeği oluşturuldu.",
    '__default_backup_comment_client' => "%1 tarafından müşteri hesabı yedeği oluşturuldu.",
    '__default_backup_comment_domain' => "%1 tarafından abonelik yedeklemesi oluşturuldu.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Müşteri %1 IP havuzu",
    'backup__ip_mapping__resellers_ip' => "Satıcı %1 IP havuzu",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Sanal ana bilgisayar',
    'backup__restore__object_plesk_admin' => 'Plesk yöneticisi',
    'backup__restore__object_ftpuser' => 'FTP hesabı',
    'backup__restore__object_frontpageuser' => 'FrontPage hesabı',
    'backup__restore__object_webuser' => 'web kullanıcısı',
    'backup__restore__object_domain' => 'alan adı',
    'backup__restore__object_subdomain' => 'alt alan adı',
    'backup__restore__object_domainalias' => 'takma alan adı',
    'backup__restore__object_client' => 'müşteri',
    'backup__restore__object_reseller' => 'satıcı',
    'backup__restore__object_autoresponder' => 'otomatik yanıt',
    'backup__restore__object_mailalias' => 'posta takma adı',
    'backup__restore__object_database' => 'veritabanı',
    'backup__restore__object_mailname' => 'posta hesabı',
    'backup__restore__object_db_user' => 'veritabanı kullanıcısı',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS sertifikası',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Müşterilere dönüştürüldüklerinden, aşağıdaki satıcılar geri yüklenemez: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Satıcılara dönüştürüldüklerinden, aşağıdaki müşteriler geri yüklenemez: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Başka bir sahibe taşındıklarından, aşağıdaki müşteriler geri yüklenemez: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Seçilen tüm abonelikleri taşımak için hedef sunucudaki disk alanı yetersiz. Boş: %1 MB. Gerekli: %2 MB. Not: Gerekli alan, alan adlarının web, posta ve veritabanı içeriğinin toplamı olarak hesaplanır. Bu hesaplama günde bir defa gerçekleşir ve önbellekte saklanır, bu sebeple alan adlarının gerçek boyutu, hesaplanan boyuttan farklı olabilir. Seçilen alan adlarının boş alandan daha fazla yer kaplamadığından eminseniz taşımaya devam edebilirsiniz.',
    'backup__restore__capability_not_enough_disk_windows_text' => 'Seçilen tüm abonelikleri taşımak için hedef sunucudaki %1 diskindeki disk alanı yetersiz. Boş: %2 MB. Gerekli: %3 MB. Not: Gerekli alan, alan adlarının web, posta ve veritabanı içeriğinin toplamı olarak hesaplanır. Bu hesaplama günde bir defa gerçekleşir ve önbellekte saklanır, bu sebeple alan adlarının gerçek boyutu, hesaplanan boyuttan farklı olabilir. Seçilen alan adlarının boş alandan daha fazla yer kaplamadığından eminseniz taşımaya devam edebilirsiniz.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Taşımaya devam etmek için hedef sunucuda disk alanı açın.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Geçici dosyaları aktarma amaçlı saklamak için kaynak sunucudaki disk alanı yetersiz. Boş: %1 MB. Gerekli: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Lütfen kaynak sunucusunda disk alanını boşaltın.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Sunucu bilgileri',

    'backup__restore__capability_not_installed_component_text' => '%1 bileşeni, hedef sunucuda kurulmamış. %1, geri yüklenen tüm nesneler için kullanılamayacaktır.',
    'backup__restore__capability_not_installed_component_resolution' => 'Lütfen %1 kurun. Bunun birkaç dakika süreceğini unutmayın.',
    'backup__restore__capability_existing_sys_user_text' => 'Hedef sunucusunda adı %1 olan bir sistem kullanıcısı zaten var.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Lütfen hedef sunucudaki varolan sistem kullanıcısını yeniden adlandırın.',
    'backup__restore__capability_license_usage_text' => 'Veri aktarmadan sonra, (lisans anahtarıyla tanımlanan) aşağıdaki kaynak sınırları hedef sunucusunda aşılır:',
    'backup__restore__capability_license_usage_resolution' => 'Lütfen hedef sunucuya gerekli miktarda kaynak sağlayacak başka bir lisans anahtarı yükleyin.',
    'backup__restore__capability_max_allowed_packet_text' => "Kaynak veritabanı sunucusundaki 'max_allowed_packet' parametresi %1 olup, bu %2 olduğu hedef sunucudakinden büyüktür. Aşağıda belirtilen alan adları için bazı veritabanı nesneleri geri yüklenemeyebilir.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Lütfen hedef veritabanı sunucusundaki 'max_allowed_packet' değerini artırın.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'PostgreSQL veritabanları aktarılamıyor, çünkü hedef sunucusundaki PostgreSQL sürümü, kaynak sunucusundakinden daha eski.  Geçerli sürüm %1, gerekli sürüm ise %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Lütfen hedef sunucuya PostgreSQL\'nin gerekli sürümünü kurun.',
    'backup__restore__capability_db_server_connection_problems' => 'Hedef PostgreSQL veritabanı sunucusuna bağlanılamıyor.  Bağlantıyı geri yüklemediğiniz sürece veritabanları aktarılmaz.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Lütfen hedef veritabanı sunucusundaki bağlantı ayarlarını kontrol edin.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => '%1 bileşeni, hedef sunucuda kapanmış.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Lütfen hedef sunucusunda %1 açın.',
    'backup__restore__capability_not_configured_component_text' => '%1 bileşeni, hedef sunucuda yapılandırılmamış.',
    'backup__restore__capability_not_configured_component_resolution' => 'Lütfen Araçlar ve Ayarlar sayfasındaki %1 öğesini yapılandırın.',

    'backup__restore__capability_webmail_is_not_available' => '%1 web postası servisi, hedef sunucuda kullanılamaz. Onun yerine Plesk, aşağıdaki web postası servisini kullanır: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Kaynak sunucudakiyle aynı web postasını kullanmak için, onu bu sunucuya kurmanız gerekir.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Kaynak sunucudakiyle aynı web postasını kullanmak için, onu hedef sunucuya kurmanız gerekir.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "'%1' web postası, hedef sunucuda kullanılamaz. Onun yerinde aşağıdaki aboneliklerde: %3, Plesk, aşağıdaki web postası servisini kullanır: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Lütfen hedef sunucuya gerekli web postasını kurun.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Web postası ayarları',

    'backup__restore__capability_shell_is_not_available' => '%1 kabuğu hedef sunucuda kullanılamıyor.  Onun yerine kullanılabilir kabuklardan biri kullanılacaktır.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Kaynak sunucudakiyle aynı kabuğu kullanmak için, onu (/etc/shells altında) açmanız veya hedef sunucuya kurmanız gerekir.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Hedef DNS sunucusu, Aktarma Sınırlamaları Şablonundaki ağları desteklemez.  Ağ IP adresleri DNS aktarma sınırlamalarında olan kayıtlar geri yüklenmez.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Hedef DNS sunucusu, Aktarma Sınırlamaları Şablonundaki ağları desteklemez, ancak bazı aboneliklerin DNS aktarma sınırlamalarında ağları bulunur. Ağ IP adresleri DNS aktarma sınırlamalarında olan kayıtlar geri yüklenmez.',

    'backup__restore__capability_wrong_php_handler_text' => 'PHP işleyicisi %1, hedef sunucuda kullanılamıyor. Onun yerine Plesk, aşağıdaki PHP işleyicisini kullanır: %2.',
    'backup__restore__capability_no_php_handler_text' => 'PHP İşleyici %1 hedef sunucuda kullanılamıyor.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Kaynak sunucudakiyle aynı PHP işleyicisini kullanmak için, onu açmanız veya hedef sunucuya kurmanız gerekir.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP işleyicisi %1 kullanılamaz. Onun yerine Plesk, aşağıdaki hizmet planları için %2 kullanır: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP işleyicisi %1 kullanılamaz. Onun yerine Plesk, aşağıdaki web siteleri için %2 kullanır: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP işleyicisi %1 uygun değil. Şu internet siteleri için kullanılamayacak: {{object}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2, hedef sunucuda kullanılamıyor.  Onun yerine varsayılan sürüm kullanılır.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Kaynak sunucudakiyle aynı %1 kullanmak için, onu açmanız veya hedef sunucuya kurmanız gerekir.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Hedef sunucudaki antivirüs kullanımı ilkesi, giden posta için kişisel (e-posta adresiyle) antivirüs ayarlarına izin vermez. Bu ayarlar aktarılmaz.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Hedef sunucudaki antivirüs kullanımı ilkesi, gelen posta için kişisel (e-posta adresiyle) antivirüs ayarlarına izin vermez.  Bu ayarlar aktarılmaz.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Hedef sunucudaki antivirüs kullanımı ilkesi, kişisel (e-posta adresiyle) antivirüs ayarlarına izin vermez. Bu ayarlar aktarılmaz.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Kişisel antivirüs ayarlarını (e-posta adresiyle) aktarmak için, lütfen Araçlar ve Ayarlar > Virüs Koruma Ayarları altındaki ilgili seçenekleri açın.",
    'backup__restore__capability_antivirus_not_active_text' => 'Hiçbir antivirüs yazılımı açılmamış.  Hedef sunucusundaki antivirüs yazılımını seçmediğiniz sürece kaynak sunucusundaki tüm antivirüs ayarları çalışmaz.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Lütfen Araçlar ve Ayarlar > Virüs Koruma Ayarları > Antivirüs ayarları bölümünden antivirüs yazılımını seçin.',

    'backup__restore__capability_antivirus_another_active_text' => 'Antivirüs yazılımı %2, hedef sunucuda kullanılamıyor.  onun yerine %1 kullanılacaktır.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Kaynak sunucudakiyle aynı antivirüsü kullanmak için lütfen onu kurun ve Araçlar ve Ayarlar > Virüs Koruma Ayarları > Antivirüs ayarları bölümünden seçin.',
    'backup__restore__capability_not_available_sni_text' => 'SNI, hedef sunucuda kullanılamıyor. Aynı IP adresine sahip olan web siteleri, bireysel SSL/TLS sertifikalarını kullanamaz.',
    'backup__restore__capability_not_available_sni_resolution' => "Lütfen hedef sunucudaki işletim sisteminin SNI'yi desteklediğini ve Plesk'te SNI desteğinin açık olduğunu (Araçlar ve Ayarlar> Sunucu Ayarları altındaki 'Aynı IP adresi olan web sitelerinde bireysel SSL/TLS sertifikalarının kullanılmasına izin veren SNI desteğini açın' onay kutusunu) kontrol edin.",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Sunucu ayarları',

    'backup__restore__capability_vhost_already_exists_text' => 'Web sitesi %1 aktarılamıyor: hedef sunucusunda aynı adda bir web sitesi zaten var.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Lütfen web sitesini yeniden adlandırın veya aynı addaki web sitesini sunucudan kaldırın.',
    'backup__restore__capability_removed_vhosts' => 'Hedef sunucuda zaten varolan alan adlarını içerdiklerinden, aşağıdaki abonelikler geri yüklenemez: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Kaynak sunucusunda, tipi %1 ve sürümü %2 olan %3 farklı PHP işleyicisi vardır. Bunların yerine, hedef sunucuda uygun tip ve sürümde bir işleyicisi kullanılacak.  Kaynak ile hedef sunucudaki PHP ayarlarının farklı olabileceğini unutmayın.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Yükleyicisi Microsoft FrontPage\'i desteklemez.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Yükleyicisi Python\'i desteklemez. Lütfen Python\'u manuel olarak kurun.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Posta sunucusu ayarları',

    'backup__restore__capability_ftps_disabled' => 'Güvenli FTPS kullanmaya kaynak sunucuda izin verilir, ancak hedefte bu yasaklanır. FTP kullanan kullanıcı uygulamaları düzgün çalışmayabilir.',
    'backup__restore__capability_ftps_required' => 'Güvenli olmayan FTP kullanmaya kaynak sunucuda izin verilir, ancak hedefte bu yasaklanır. FTP kullanan kullanıcı uygulamaları düzgün çalışmayabilir.',
    'backup__restore__capability_ftps_policy_resolution' => 'Araçlar ve Ayarlar > Güvenlik İlkesi altındaki Güvenli FTP ilkesini değiştirin.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabayt veri %2 saatte kaynak sunucudan hedefe taşınır.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Daha hızlı bir aktarma için lütfen kaynakla hedef sunucular arasındaki ağ bağlantısını kontrol edin ve (varsa) sorunları çözün.',
    'backup__restore__too_low_download_speed' => "0,01'den az",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Daha hızlı bir aktarma için lütfen kaynakla hedef sunucular arasındaki ağ bağlantısını kontrol edin ve (varsa) sorunları çözün.',
    'backup__restore__capability_zero_download_speed_text' => 'Minimum kabul edilebilir indirme hızı %1 MB/sn.  Kaynak ile hedef sunucuların arasındaki indirme hızı 0 MB/sn.  Bu, ağ bağlantısı sorunlarından kaynaklanmış olabilir.  Aktarma yapılamıyor.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Lütfen kaynakla hedef sunucular arasındaki ağ bağlantınızı kontrol edin ve sorunları çözün.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Minimum kabul edilebilir indirme hızı %2 MB/sn. Kaynak ile hedef sunucu arasındaki indirme hızı %1 MB/sn. Bu, aktarma süresini artırabilir. Geçerli ortamınızda, %3 MB\'ın göçü %4 saat sürer.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Minimum kabul edilebilir indirme hızı %2 MB/sn. Kaynak ile hedef sunucu arasındaki indirme hızı %1 MB/sn. Bu, aktarma süresini artırabilir.',

    'backup__restore__capability_remote_database_migration' => "Aşağıdaki alan adları, uzak veritabanlarını kullanıyor: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Kaynak sunucusundaki Plesk sürümü 11.5'den eskiyse, aktarmadan sonra bu alan adlarını kaynak sunucusundan kaldırmayın! Onun yerine onları askıya alın. Alan adlarını kaldırırsanız, veritabanları uzak sunucudan kaldırılır. Not: Uzak veritabanlarının döküm dosyaları, %1 dizinindeki kaynak sunucusunda saklanır.",

    'backup__restore__capability_mysql_50_to_51_migration' => '5.1 (%1) öncesi MySQL veritabanı sunucularının yedekleme dosyaları, MySQL 5.1.x üzerinde geri yüklenemeyebilir, çünkü MySQL 5.1.x, Unicode karakterleri farklı ele alır.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Lütfen ilgili bilgi tabanı maddesini #136850 okuyun',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP, hedef sunucuya kurulmamış.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Lütfen Plesk Yükleyicisini kullanarak Courier-IMAP kurun.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot, hedef sunucuya kurulmamış.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Lütfen Plesk Yükleyicisini kullanarak Dovecot kurun.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Aşağıdaki nesnelerin yapılandırmalarındaki trafik istatistiklerini saklama süresi, hedef sunucudaki sunucu çapındaki değerden azdır.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Lütfen istatistikleri hedef sunucuda saklama süresinin sunucu çapındaki değerini değiştirin. Bu süreyi alan adlarının yapılandırmalarındaki en küçük değere eşit veya ondan az olarak ayarlayın.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Bazı alan adlarındaki trafik istatistiklerini saklama süresi, sunucu çapındaki değerden (%1) azdır. Bu alan adları için değer, %1 olarak değiştirilecek.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Bazı servis planlarındaki trafik istatistiklerini saklama süresi, sunucu çapındaki değerden (%1) azdır. Bu servis planları için değer, %1 olarak değiştirilecek.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Özel bir IP adresini paylaşılmış biriyle eşleştirmek, (SNI desteği açık olmadığı takdirde) anonim FTP ve HTTPS\'yi devre dışı bırakır.',

    'backup__restore__no_postgresql_commands_text' => 'Abonelik bir uzak PostgreSQL veritabanını kullanır ve kaynak sunucuda pg_dump ile psql komutları bulunmadığından, onun geçici yedekleme dosyası oluşturulamaz.',
    'backup__restore__no_postgresql_commands_resolution' => 'Lütfen bu komutları destekleyen herhangi bir PostgreSQL istemci paketini kurun.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Aşağıdaki Apache modülleri hedef sunucuda devre dışı bırakıldı: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Lütfen olası sorunları önlemek için bu modülleri etkinleştirin.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Aşağıdaki Apache modülleri hedef sunucuda kurulmadı: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Lütfen olası sorunları önlemek için bu modülleri kurun ve etkinleştirin.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Lisansınız, giden mesajları sınırlamayı desteklemiyor. İlgili yapılandırma ayarları aktarılmaz.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Lütfen hedef sunucuya gerekli özellikleri sağlayan başka bir lisans anahtarı yükleyin.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Giden mesajları sınırlama, hedef sunucusunda kapanmış. İlgili yapılandırma ayarları aktarılmaz.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Lütfen hedef sunucudaki giden mesaj sınırlamasını açın.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Sunucu Çapında Posta Ayarları',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Bir posta kutusunun giden mesajlarının sınırı, hedef sunucuda kullanılan posta sunucusu tarafından desteklenmiyor. Bu sınırın değeri aktarılmaz.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Lütfen posta sunucusunu, kaynak sunucuda kullandığınızın aynısıyla değiştirin.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Sunucu Çapında Posta Ayarları',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Bir alan adının giden mesajlarının sınırı, hedef sunucuda kullanılan posta sunucusu tarafından desteklenmiyor. Bu sınırın değeri aktarılmaz.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Lütfen posta sunucusunu, kaynak sunucuda kullandığınızın aynısıyla değiştirin.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Sunucu Çapında Posta Ayarları',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Bir aboneliğin giden mesajlarının sınırı, hedef sunucuda kullanılan posta sunucusu tarafından desteklenmiyor. Bu sınırın değeri aktarılmaz.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Lütfen posta sunucusunu, kaynak sunucuda kullandığınızın aynısıyla değiştirin.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Sunucu Çapında Posta Ayarları',

    'bu_conflict_resolver_absent_phosting' => 'Geri yüklenmeleri için fiziksel barındırma bulunmadığından, belirtilen dosyalar geri yüklenemiyor. Lütfen önce fiziksel barındırmayla bir alan adı oluşturun ve sonra yedeklemeyi kurtarmayı tekrar başlatın.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Satıcı yönetimi desteklenmediğinden, satıcı verileri geri yüklenmez.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'ModSecurity bileşeni, hedef sunucuya kurulmamış.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Aktarılan siteler için web uygulamasının güvenlik duvarının çalışmaya devam etmesini sağlamak için lütfen ModSecurity\'yi kurun. Bu kurulumun birkaç dakika sürebileceğini unutmayın.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Web uygulamasının güvenlik duvarının ayarlarını aktarmak istiyorsanız ModSecurity\'yi kurun. Bu kurulumun birkaç dakika sürebileceğini unutmayın.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'ModSecurity bileşeni, hedef sunucuda yapılandırılmamış.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Aktarılan siteler için web uygulamasının güvenlik duvarının çalışmaya devam etmesini istiyorsanız ModSecurity\'yi yapılandırın.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Web Uygulamasının Güvenlik Duvarı (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'Hedef sunucudaki ModSecurity kapanmış.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktarılan siteler için web uygulamasının güvenlik duvarının çalışmaya devam etmesini istiyorsanız ModSecurity\'yi etkinleştirin.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Web Uygulamasının Güvenlik Duvarı (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'ModSecurity bileşeni kurulmamış. Web uygulamasının güvenlik duvarı ayarları aşağıdaki nesneler için geri yüklenmez: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Plesk'te bulunmayan %1 aboneliğine ait olduklarından, web siteleri geri yüklenemiyor.",
    'bu_conflict_resolver_attend_websites_subscription' => "Aynı ada sahip abonelikler olduğu için bazı web siteleri geri yüklenemiyor: %1.",
    'backup__restore__capability_not_installed_dns_text' => '%1 bileşeni, hedef sunucuda kurulmamış. DNS servisi kullanılamaz ve DNS ayarları kaybolur. Tüm müşterilerin web siteleri kapalı olacaktır.',
    'bu_conflict_resolver_dns_not_installed' => 'DNS servisi yüklü değil. DNS ayarları aşağıdaki nesneler için geri yüklenmez: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Başka sahiplere taşındıklarından, aşağıdaki abonelikler geri yüklenemez: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Başka sağlayıcılara taşındıklarından, aşağıdaki abonelikler geri yüklenemez: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Web Presence Builder verilerini geri yüklemek için Web Presence Builder\'ı kurtarma programı bulunamıyor. Web Presence Builder büyük olasılık yüklü değil.',
    'backup__restore__capability_renamed_db' => 'Veritabanı adı "%1" zaten başka bir abonelik tarafından kullanılıyor. Geri yüklenen veritabanının adı, "%2" olarak değiştirilir.',
    'backup__restore__capability_renamed_db_user' => 'Veritabanı kullanıcı adı "%1" zaten başka bir abonelik tarafından kullanılıyor. Geri yüklenen veritabanı kullanıcısının adı, "%2" olarak değiştirilir.',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Yükleyicisi Perl\'i desteklemez. Lütfen ActiveState Perl\'u manuel olarak kurun.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% Apache tarafından sunulur (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% nginx tarafından sunulur (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirüs',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Kaynak Kullanımı Çakışmaları',
    'backup__restore__hint_resource_usage_conflicts' => 'Kaynak kullanımı çakışmaları, kurtarma sonrasında geri yüklenen nesnenin kaynak kullanımı sınırları aşıldığında oluşur.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Fazla kullanıma izin verin',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Nesneyi geri yükleyin ve ilk başta verilenden daha gazla kaynak kullanmasına izin verin.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Geri yüklemeyin',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Kaynak kullanımı sorunları olan nesneleri geri yüklemeyin.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Yapılandırma Çakışmaları',
    'backup__restore__hint_configuration_conflicts' => 'Yapılandırma çakışmaları, geri yüklenen nesnenin kullanılamayan veya geçerli sunucu veya nesne sahibi ilkesi tarafından yasaklanmış olan ayarları ve web uygulamaları olduğunda oluşur.  Örneğin geçerli sunucu çapındaki ilke, posta hesaplarında bu ayarların olmasını yasakladığında, geri yüklenen posta hesaplarının bireysel gereksiz posta filtreleme ayarları olduğunda yapılandırma çakışmaları oluşur.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Otomatik',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Nesneyi geri yükleyin ve izinlerinizin yönetmenize izin verdiği tüm çakışan yapılandırma seçeneklerini otomatik olarak açın.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Geri yüklemeyin',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Yapılandırma sorunları olan nesneleri geri yüklemeyin.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'IIS uygulama havuzu ayarlarında atanmış IIS uygulama havuzlarına izin verilmez.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Lütfen Araçlar ve Ayarlar > IIS Uygulama Havuzu > Küresel Ayarlar altında IIS uygulama havuzu ayarlarınızı değiştirin.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'IIS uygulama havuzu ayarlarında paylaşılmış IIS uygulama havuzlarına izin verilmez.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Lütfen Araçlar ve Ayarlar > IIS Uygulama Havuzu > Küresel Ayarlar altında IIS uygulama havuzu ayarlarınızı değiştirin.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Hedef sunucuda kısa POP3/IMAP posta hesabı adlarına izin verilmez.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Veriler kurtarıldıktan sonra posta hesaplarının kısa adları kullanılamaz.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Günlük dosyası açılamıyor.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => '%1 aboneliği geri yüklenemiyor: hesabınızdan kaldırıldı ve abonelikleri oluşturma izniniz yok. Onu geri yüklemeniz gerektiğinde, lütfen servis sağlayıcınızla irtibata geçin.',

    'backup__error11' => 'Yedekleme için yetersiz disk alanı.',
    'backup__error3011' => 'Bağlantı reddedildi: Belirtilen adres ve bağlantı noktasında dinleyen hiçbir program yok.',
    'backup__error3012' => 'Bağlantı zamanaşımı.',
    'backup__error3013' => 'Ağa erişilemiyor.',
    'backup__error3014' => 'Ana bilgisayara giden rota yok.',
    'backup__error3015' => 'Bağlantı başarısız.',
    'backup__error3016' => 'Ana makine adı çözümlenemiyor.',
    'backup__error3017' => 'Yanlış kullanıcı adı veya şifre.',
    'backup__error3018' => 'SSH bağlantısı başarısız.',

    'backup__error3110' => 'Uzak göç aracısına bağlanılamıyor: Ana bilgisayara bağlantı kullanılamaz.',
    'backup__error3111' => 'Göç aracısı, başarısız bir göç görevi tarafından kilitlenmiş veya başka bir göç işlemi tarafından kullanılmış. Lütfen kaynak sunucudaki göç aracısını yeniden başlatın.',
    'backup__error3112' => 'Ana bilgisayara bağlantı kullanılamaz veya göç aracısı kaynak ana bilgisayarında çalışmıyor.',
    'backup__error3113' => 'Göç aracısı bir Linux ana bilgisayarına dağıtılamıyor. Lütfen kaynak ana bilgisayarla olan SSH bağlantısını kontrol edin.',
    'backup__error3114' => 'Göç aracısı bir Linux ana bilgisayarına dağıtılamıyor: SSH bağlantısı başarısız.',
    'backup__error3115' => 'Yanlış kullanıcı adı veya şifre.',
    'backup__error3116' => 'Belirtilen kullanıcının yönetim ayrıcalıkları yok.',

    'dns_t__unable_to_remove_ns_record' => 'NS kaydı DNS şablonundan kaldırılamıyor: Her DNS bölgesinin en az bir NS kaydının olması gerekir.',
    'dns__unsupported_server_zone_transfer' => 'Sunucu çapında DNS yapılandırmasından dolayı Aktarma Sınırlamaları Şablonu aktarılamıyor: Kaynak sunucusunda bölge aktarması için aşağıdaki ağ adreslerine izin verilir, ancak bu adresler, Microsoft DNS Sunucusu tarafından yasaklanır: %1',
    'dns__unsupported_domain_zone_transfer' => 'Alan adlarının DNS yapılandırmasından dolayı Aktarma Sınırlamaları Şablonu aktarılamıyor: Bazı alan adlarında bölge aktarması için aşağıdaki ağ adreslerine izin verilir, ancak bu adresler, Microsoft DNS Sunucusu tarafından yasaklanır: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Yedekleme dosyaları için paylaşılmış geçici ağ dizinine erişilemiyor. Lütfen ağ dizinini, kullanıcı adını ve şifre ayarlarını kontrol edin. Hata: %1',

    'dbbackup__temp_dir_wrong_value' => 'Geçici dizin için geçersiz değer belirtildi.',
    'dbbackup__network_temp_dir_wrong_value' => 'Geçici ağ dizini için geçersiz değer belirtildi.',
    'dbbackup__server_backup_not_configured' => 'Sunucudaki veritabanı yedekleme ayarları yapılandırılmamış.',
    'dbbackup__temp_dir' => 'Geçici dizin',
    'dbbackup__temp_dir_hint' => 'MS SQL sunucusunun bulunduğu uzak sunucudaki bir fiziksel klasörün yolu. MS SQL sunucusunun, geçici yedekleme dosyalarını okumak ve yazmak için bu klasöre erişebilmesi gerekir. Örneğin, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Yukarıda belirtilen klasörle eşleştirilmiş ağ paylaşımının yolu. Plesk, yedekleme dosyalarını indirmek ve karşıya yüklemek için, paylaşılmış klasöre erişir. Örneğin \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Uzak sunucuda oluşturulan bir ağ kullanıcısının kullanıcı adı. Örneğin, ServerName\\UserName. Kullanıcının, yukarıda belirtilen paylaşılmış klasöre erişimi olmalıdır.',
    'dbbackup__network_password_hint' => 'Ağ kullanıcısının şifresi',

    'dbbackup__success_import_without_dublicate_users' => 'Aşağıdaki kullanıcılar içeri aktarılmadı: %1. Bunlar veritabanı sunucusunda zaten vardır.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Log dosyalarını sıkıştır",
    'log_rot__log_rot_status' => "Günlük döndürme durumu",
    'log_rot__log_rot_period' => "log dönüşüm periyodu",
    'log_rot__log_rot_size' => "Boyuta göre",
    'log_rot__log_rot_time' => "Tarihe göre",
    'log_rot__logrotation_enable' => "Günlük döndürmeyi açın",
    'log_rot__mail' => "İşlenmiş günlük dosyalarını e-postaya gönderin",
    'log_rot__max_number_of_logfiles' => "Maksimum log dosyası sayısı",
    'log_rot__time_period' => "periyod",
    'log_rot__unable_turn_off' => 'Sunucu seviyesine zorla uygulandığından, günlük dönüşü kapatılamıyor',
    'log_rot__unable_set_period' => 'Sunucu seviyesinde zorla uygulandığından, günlük dönüş dönemi \'günlükten\' farklı olarak ayarlanamıyor',
    'log_rot__unable_set_max_log_files' => 'Maksimum günlük dosyası sayısı, sunucu çapındaki %1 sınırından fazlaya ayarlanamıyor',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Kabuul edilen sayı: %1",
    'actionlog__incorrect_rotation' => "Geçersiz devir kayıt parametreleri belirlendi: %1",
    'actionlog__unknown_rot_period' => "Bilinmeyen devir periyotları: %1",
    'actionlog__unknown_rot_type' => "Bilinmeyen devir tipi: %1",
    'actionlog__session_preferences' => 'Oturum ayarları',
    'actionlog__nis2_delete_prohibited' => 'Yürürlükteki NIS2 direktifi kısıtlamalarından dolayı günlük kayıtlarını silmek yasaktır.',
    'actionlog__nis2_forbidden_rot_type' => "Yürürlükteki NIS2 direktifi kısıtlamalarından dolayı \"%1\" günlük dönüşüm türü kullanılamaz.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Yönetici Bilgileri',
    'actionlog__admin_preferences' => "Yöneticinin tercihleri",
    'actionlog__service' => 'Servis',
    'actionlog__ip_addr' => 'IP Adresi',
    'actionlog__client' => 'Müşteri hesabı',
    'actionlog__client_status' => 'Müşteri hesabının durumu',
    'actionlog__client_preferences' => "Müşterinin arayüz tercihleri",
    'actionlog__client_ip_pool' => "Müşterinin IP havuzu",
    'actionlog__client_siteapp' => "Müşterinin web uygulaması havuzu",
    'actionlog__client_guid' => "Müşteri GUID",
    'actionlog__domain' => 'Varsayılan alan adı (bir aboneliğe eklenen ilk alan adı)',
    'actionlog__domain_owner' => 'Aboneliğin sahibi',
    'actionlog__domain_plan' => 'Aboneliğin servis planı',
    'actionlog__domain_status' => 'Varsayılan alan adı, durum',
    'actionlog__domain_dns' => 'Varsayılan alan adı, DNS bölgesi',
    'actionlog__subdomain' => 'Varsayılan bir alan adının alt alan adı',
    'actionlog__domain_alias' => 'Varsayılan alan adı, takma adı',
    'actionlog__domain_alias_dns' => 'Varsayılan alan adı, takma adı DNS bölgesi',
    'actionlog__site' => 'Alan Adı',
    'actionlog__site_status' => 'Alan adı durumu',
    'actionlog__site_dns' => 'Alan adı DNS bölgesi',
    'actionlog__site_guid' => 'Alan adı GUID',
    'actionlog__site_subdomain' => 'Alt alan adı',
    'actionlog__site_alias' => 'Takma alan adı',
    'actionlog__site_alias_dns' => 'Takma alan adı DNS bölgesi',
    'actionlog__domain_limits' => 'Abonelik sınırları',
    'actionlog__domain_limit_size' => 'Abonelik için disk alanı sınırı',
    'actionlog__domain_limit_traffic' => 'Abonelik için trafik sınırı',
    'actionlog__domain_limits_powerUser' => 'Abonelik sınırları',
    'actionlog__domain_limit_size_powerUser' => 'Abonelik için disk alanı sınırı',
    'actionlog__domain_limit_traffic_powerUser' => 'Abonelik için trafik sınırı',
    'actionlog__domain_guid' => "Varsayılan alan adı, GUID",
    'actionlog__cp_user' => 'Plesk kullanıcısı',
    'actionlog__mailname' => 'Posta hesabı',
    'actionlog__maillist' => 'Gönderim listesi',
    'actionlog__phosting' => 'Barındırma ayarları',
    'actionlog__forwarding' => 'Standart veya frame içinde yönlendirme hosting',
    'actionlog__webuser' => 'Web kullanıcısı hesabı',
    'actionlog__site_application' => 'Web uygulaması',
    'actionlog__license' => 'Lisans anahtarı',
    'actionlog__additional_license' => 'Ek lisans anahtarı',
    'actionlog__template_domain' => "Satıcının servis planı",
    'actionlog__template_admin' => "Yöneticinin servis planı",
    'actionlog__template_reseller' => 'Satıcı planı',
    'actionlog__admin_alias' => 'Ek yönetici hesabı', // PFW
    'actionlog__ftpuser' => 'Ek FTP hesabı', // PFW
    'actionlog__db_server' => 'Veritabanı Sunucusu',
    'actionlog__db' => 'Veritabanı',
    'actionlog__db_user' => 'Veritabanı kullanıcı hesabı',
    'actionlog__client_sapppkg_pool' => "Kullanıcının web uygulaması", // PFW, not used?
    'actionlog__remote_dns' => 'Uzak DNS sunucu durumu', // PFW
    'actionlog__reseller' => 'Satıcı hesabı',
    'actionlog__reseller_guid' => 'Satıcı GUID',
    'actionlog__reseller_ip_pool' => "Satıcının IP havuzu",
    'actionlog__reseller_limit_size' => 'Satıcı hesabı için disk alanı sınırı',
    'actionlog__reseller_limit_traffic' => 'Satıcı hesabı için trafik sınırı',
    'actionlog__reseller_limits' => 'Satıcı hesabının sınırları',
    'actionlog__reseller_permissions' => 'Satıcı izinleri',
    'actionlog__reseller_preferences' => "Satıcının arayüz tercihleri",
    'actionlog__reseller_siteapp' => "Satıcının havuzundaki web uygulamaları",
    'actionlog__reseller_status' => 'Satıcı hesabının durumu',
    'actionlog__health_status' => 'Sunucunun sağlık durumu',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'ulaşıldı',
    'actionlog__added' => 'eklendi',
    'actionlog__removed' => 'silindi',
    'actionlog__change' => 'değişti',
    'actionlog__update' => 'güncellendi',
    'actionlog__move' => 'taşındı',
    'actionlog__upgrade' => 'yükseltildi', // PFU?
    'actionlog__update_or_add' => 'güncellendi veya eklendi',
    'actionlog__expired' => 'sona ermiş',
    'actionlog__create' => 'oluşturuldu',
    'actionlog__delete' => 'silindi',
    'actionlog__service_stop' => 'durduruldu',
    'actionlog__service_restart' => 'yeniden başlatıldı',
    'actionlog__service_start' => 'başladı',
    'actionlog__login' => 'giriş yapıldı',
    'actionlog__logout' => 'çıkış yapıldı',
    'actionlog__install' => 'kuruldu',
    'actionlog__uninstall' => 'kaldırıldı',
    'actionlog__reconfigure' => 'tekrar konfigüre edildi',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Şifre sıfırlama isteği',
    'actionlog__event_admin_update' => 'Yönetici bilgileri güncelleştirildi',
    'actionlog__event_admin_preferences_update' => "Yönetici tercihleri güncellendi",
    'actionlog__event_service_restart' => 'Hizmet yeniden başlatıldı',
    'actionlog__event_service_start' => 'Hizmet başlatıldı',
    'actionlog__event_service_stop' => 'Hizmet durduruldu',
    'actionlog__event_ip_address_create' => 'IP adresi oluşturuldu',
    'actionlog__event_ip_address_delete' => 'IP adresi silindi',
    'actionlog__event_ip_address_update' => 'IP adresi güncelleştirildi',
    'actionlog__event_client_create' => 'Müşteri hesabı oluşturuldu',
    'actionlog__event_client_delete' => 'Müşteri hesabı silindi',
    'actionlog__event_client_update' => 'Müşteri hesabı güncellendi',
    'actionlog__event_client_status_update' => 'Müşteri hesabının durumu güncellendi',
    'actionlog__event_client_preferences_update' => "Müşterinin arayüz tercihleri güncellendi",
    'actionlog__event_client_siteapp_added' => "Web uygulaması, müşteri hesabının uygulama havuzuna eklendi",
    'actionlog__event_client_siteapp_removed' => "Web uygulaması, müşteri hesabının uygulama havuzundan kaldırıldı",
    'actionlog__event_domain_limit_size_reached' => 'Abonelik için disk alanı sınırına ulaşıldı',
    'actionlog__event_domain_limit_traffic_reached' => 'Abonelik için trafik sınırına ulaşıldı',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Abonelik için disk alanı sınırına ulaşıldı',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Abonelik için trafik sınırına ulaşıldı',
    'actionlog__event_dns_record_create' => 'DNS kaydı oluşturuldu',
    'actionlog__event_dns_record_delete' => 'DNS kaydı silindi',
    'actionlog__event_dns_record_update' => 'DNS kaydı güncellendi',
    'actionlog__event_dns_zone_soa_record_update' => 'SOA DNS kaydı güncellendi',
    'actionlog__event_dns_zone_switch_to_master' => 'DNS bölgesi birincile geçti',
    'actionlog__event_dns_zone_switch_to_slave' => 'DNS bölgesi ikincile geçti',
    'actionlog__event_dns_zone_turn_off' => 'DNS bölgesi devre dışı',
    'actionlog__event_dns_zone_turn_on' => 'DNS bölgesi etkin',
    'actionlog__event_pw_admin_force_reset' => 'Zorunlu şifre sıfırlama için işaretlenen bir yönetici hesabının şifresi değiştirildi',

    'actionlog__domain_limit_database' => 'Abonelik için veritabanı kotası',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Abonelik için MariaDB/MySQL veritabanı kotasına ulaşıldı',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Abonelik için MariaDB/MySQL veritabanı yumuşak kotasına ulaşıldı',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Abonelik için Microsoft SQL sunucu veritabanı kotasına ulaşıldı',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Abonelik için Microsoft SQL sunucu veritabanı yumuşak kotasına ulaşıldı',
    'actionlog__event_plesk_component_upgrade' => 'Plesk bileşeni güncellendi',
    'actionlog__event_plesk_component_install' => 'Plesk bileşeni yüklendi',
    'actionlog__event_plesk_component_uninstall' => 'Plesk bileşeni kaldırıldı',
    'actionlog__event_domain_create' => 'Varsayılan alan adı (bir aboneliğe eklenen ilk alan adı) oluşturuldu',
    'actionlog__event_domain_delete' => 'Varsayılan alan adı (bir aboneliğe eklenen ilk alan adı) silindi',
    'actionlog__event_domain_update' => 'Varsayılan alan adı (bir aboneliğe eklenen ilk alan adı) güncellendi',
    'actionlog__event_domain_owner_change' => 'Abonelik sahibi değiştirildi',
    'actionlog__event_domain_plan_change' => 'Aboneliğin servis planı değişti',
    'actionlog__event_domain_status_update' => 'Varsayılan alan adı, durum güncellendi',
    'actionlog__event_domain_dns_update' => 'Varsayılan alan adı, DNS bölgesi güncellendi',
    'actionlog__event_subdomain_create' => 'Varsayılan bir alan adının alt alan adı oluşturuldu',
    'actionlog__event_subdomain_delete' => 'Varsayılan bir alan adının alt alan adı silindi',
    'actionlog__event_subdomain_update' => 'Varsayılan bir alan adının alt alan adı güncellendi',
    'actionlog__event_domain_alias_create' => 'Varsayılan alan adı, takma adı oluşturuldu',
    'actionlog__event_domain_alias_delete' => 'Varsayılan alan adı, takma adı silindi',
    'actionlog__event_domain_alias_update' => 'Varsayılan alan adı, takma adı güncellendi',
    'actionlog__event_domain_limits_update' => 'Abonelik sınırları güncellendi',
    'actionlog__event_cp_user_login' => 'Plesk kullanıcısı oturum açtı',
    'actionlog__event_cp_user_logout' => 'Plesk kullanıcısı oturumdan çıktı',
    'actionlog__event_mailname_create' => 'Posta hesabı oluşturuldu',
    'actionlog__event_mailname_delete' => 'Posta hesabı silindi',
    'actionlog__event_mailname_clear' => 'Posta hesabı boşaltıldı',
    'actionlog__event_mailname_update' => 'Posta hesabı güncellendi',
    'actionlog__event_maillist_create' => 'Posta listesi oluşturuldu',
    'actionlog__event_maillist_delete' => 'Posta listesi silindi',
    'actionlog__event_maillist_update' => 'Posta listesi güncelleştirildi',
    'actionlog__event_phys_hosting_create' => 'Fiziksel barındırma oluşturuldu',
    'actionlog__event_phys_hosting_delete' => 'Fiziksel barındırma silindi',
    'actionlog__event_phys_hosting_update' => 'Fiziksel barındırma güncelleştirildi',
    'actionlog__event_forwarding_create' => 'Standart veya çerçeve iletim barındırması oluşturuldu',
    'actionlog__event_forwarding_delete' => 'Standart veya çerçeve iletim barındırması silindi',
    'actionlog__event_forwarding_update' => 'Standart veya çerçeve iletim barındırması güncelleştirildi',
    'actionlog__event_webuser_create' => 'Web kullanıcısı hesabı oluşturuldu',
    'actionlog__event_webuser_delete' => 'Web kullanıcısı hesabı silindi',
    'actionlog__event_webuser_update' => 'Web kullanıcısı hesabı güncelleştirildi',
    'actionlog__event_siteapp_install' => 'Web uygulaması yüklendi',
    'actionlog__event_siteapp_reconfigure' => 'Web uygulaması yeniden yapılandırıldı',
    'actionlog__event_siteapp_uninstall' => 'Web uygulaması kaldırıldı',
    'actionlog__event_license_update' => 'Lisans anahtarı güncelleştirildi',
    'actionlog__event_admin_alias_create' => 'Ek yönetici hesabı oluşturuldu',
    'actionlog__event_admin_alias_delete' => 'Ek yönetici hesabı silindi',
    'actionlog__event_admin_alias_update' => 'Ek yönetici hesabı güncellendi',
    'actionlog__event_ftpuser_create' => 'Ek FTP hesabı oluşturuldu',
    'actionlog__event_ftpuser_update' => 'Ek FTP hesabı güncellendi',
    'actionlog__event_ftpuser_delete' => 'Ek FTP hesabı silindi',
    'actionlog__event_template_domain_create' => "Satıcının servis planı oluşturuldu",
    'actionlog__event_template_domain_update' => "Satıcının servis planı güncellendi",
    'actionlog__event_template_domain_delete' => "Satıcının servis planı silindi",
    'actionlog__event_template_admin_create' => "Yöneticinin servis planı oluşturuldu",
    'actionlog__event_template_admin_update' => "Yöneticinin servis planı güncellendi",
    'actionlog__event_template_admin_delete' => "Yöneticinin servis planı silindi",
    'actionlog__event_database_server_create' => 'Veritabanı sunucusu yaratıldı',
    'actionlog__event_database_server_update' => 'Veritabanı sunucusu güncellendi',
    'actionlog__event_database_server_delete' => 'Veritabanı sunucusu silindi',
    'actionlog__event_remote_dns_status_update' => 'Uzak DNS sunucu durumu güncellendi',
    'actionlog__event_session_preferences_update' => 'Oturum ayarları güncellendi',
    'actionlog__event_domain_alias_dns_update' => 'Varsayılan alan adı, takma alan adının DNS bölgesi güncellendi',
    'actionlog__event_domain_move' => 'Varsayılan alan adı yeni bir aboneliğe taşındı',
    'actionlog__event_site_move' => 'Alan adı yeni bir aboneliğe taşındı',
    'actionlog__event_site_subdomain_move' => 'Alt alan adı yeni bir aboneliğe taşındı',
    'actionlog__event_subdomain_move' => 'Varsayılan bir alan adının alt alan adı yeni bir aboneliğe taşındı',
    'actionlog__event_license_expired' => 'Plesk lisansının süresi doldu',
    'actionlog__event_database_create' => 'Veritabanı oluşturuldu',
    'actionlog__event_database_delete' => 'Veritabanı kaldırıldı',
    'actionlog__event_database_user_create' => 'Veritabanı kullanıcı hesabı oluşturuldu',
    'actionlog__event_database_user_update' => 'Veritabanı kullanıcı hesabı ayarları güncellendi',
    'actionlog__event_database_user_delete' => 'Veritabanı kullanıcı hesabı kaldırıldı',
    'actionlog__event_client_guid_update' => "Müşteri GUID güncellendi",
    'actionlog__event_domain_guid_update' => 'Varsayılan alan adı, GUID güncellendi',
    'actionlog__event_reseller_create' => 'Satıcı hesabı oluşturuldu',
    'actionlog__event_reseller_delete' => 'Satıcı hesabı silindi',
    'actionlog__event_reseller_update' => 'Satıcı hesabı güncellendi',
    'actionlog__event_reseller_guid_update' => 'Satıcı GUID güncellendi',
    'actionlog__event_reseller_ip_pool_update' => "Satıcının IP havuzu güncellendi",
    'actionlog__event_reseller_limit_size_reached' => 'Satıcı hesabı için disk alanı sınırına ulaşıldı',
    'actionlog__event_reseller_limit_traffic_reached' => 'Satıcı hesabı için trafik sınırına ulaşıldı',
    'actionlog__event_reseller_limits_update' => 'Satıcı hesabının sınırları güncellendi',
    'actionlog__event_reseller_permissions_update' => 'Satıcı hesabının izinleri güncellendi',
    'actionlog__event_reseller_preferences_update' => "Satıcının arayüz tercihleri güncellendi",
    'actionlog__event_reseller_siteapp_added' => "Uygulama, satıcı hesabının uygulama havuzuna eklendi",
    'actionlog__event_reseller_siteapp_removed' => "Uygulama, satıcı hesabının uygulama havuzundan kaldırıldı",
    'actionlog__event_reseller_status_update' => 'Satıcı hesabının durumu güncellendi',
    'actionlog__event_template_reseller_create' => 'Satıcı planı oluşturuldu',
    'actionlog__event_template_reseller_delete' => 'Satıcı planı silindi',
    'actionlog__event_template_reseller_update' => 'Satıcı planı güncellendi',
    'actionlog__event_health_status_change' => 'Sunucunun sağlık durumu değişti',
    'actionlog__event_siteapp_upgrade' => 'Web uygulaması yükseltildi',
    'actionlog__event_extension_install' => 'Uzantı yüklü',
    'actionlog__event_extension_uninstall' => 'Uzantı kaldırıldı',
    'actionlog__event_extension_upgrade' => 'Uzantı yükseltildi',
    'actionlog__event_extension_status_update' => 'Uzantı durumu güncellendi',
    'actionlog__event_additional_license_expired' => 'Ek lisansın süresi doldu',
    'actionlog__event_hostname_changed' => 'Sunucu sahibi ana bilgisayar adı değişti',
    'actionlog__event_smb_user_create' => 'Ek kullanıcı oluşturuldu',
    'actionlog__event_smb_user_delete' => 'Ek kullanıcı silindi',
    'actionlog__event_smb_user_update' => 'Ek kullanıcı güncellendi',
    'actionlog__dns_record' => 'DNS Kaydı',
    'actionlog__dns_zone' => 'DNS alanı',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC, uzak ana bilgisayarda kurulu değil. Destek için servis sağlayıcınızla irtibata geçin.",
    'rsession_no_account_errmsg' => "Hesabınız altındaki uzak servise erişilemiyor.  En sık görülen neden, hesabınızın servisinin henüz etkinleştirilmemiş olmasıdır.  Lütfen birkaç dakika bekleyin ve sonra yeniden deneyin. Bu hatayla tekrar karşılaşırsanız, sistem yöneticinizle irtibata geçin.",
    'rsession_no_domain_errmsg' => "Bu alan adı için uzak servise erişilemiyor. En sık görülen neden, bu alan adının servisinin henüz etkinleştirilmemiş olmasıdır. Lütfen birkaç dakika bekleyin ve sonra yeniden deneyin. Bu hatayla tekrar karşılaşırsanız, sistem yöneticinizle irtibata geçin.",
    'rsession_unknown_errmsg' => "Uzak sunucu, bir oturum açma denemesini reddetti. Destek için sistem yöneticinizle irtibata geçin.  Hata: %1",
    'rsession_unknown2_errmsg' => "Bir uzak oturum oluşturulurken bilinmeyen hata oluştu.  Büyük olasılık uzak sunucu, doğru veya hiç yanıt vermiyordur.  Sistem yöneticinizden, web sunucusu hata günlüğündeki hata ayrıntılarını kontrol etmesini iste.",
    'rsession_no_connect_errmsg' => "Uzak servise erişilemiyor: Uzaktan oturuma bağlanma başarısız.  Destek için sistem yöneticinizle irtibata geçin.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Geliş dizini için yükleme izni ver",
    'anonftp__allow_create_dirs' => 'Geliş dizininde dizin oluşumuna müsaade et.',
    'anonftp__allow_download_incoming' => 'Geliş dizini için downloada müsaade et',
    'anonftp__display_login' => 'Login mesajı göster',
    'anonftp__login_text' => 'Mesaj içeriği',
    'anonftp__limit_incoming_disk_space' => "Geliş dizininde Disk alanını limitle",
    'anonftp__limit_maximum_bandwidth' => "Bu sanal FTP alan adı için indirme bant genişliğini sınırlayın",
    'anonftp__limit_maximum_connections' => "Eş zamanlı bağlantı sayısı için limit oluştur",
    'anonftp__unable_init' => "Anonim FTP hesabı başlatılamıyor: %1",
    'anonftp__unable_set_quota' => "Gelen dizin disk alan limiti ayarlanamıyor: %1",
    'anonftp__unable_update' => "Anonim FTP hesap özellikleri güncellenemiyor: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS sertifikaları', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA sertifikası, sertifikayı imzalamaz.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Uyumsuz özel anahtar/sertifika çifti.",
    'class_sslcertificate__invalid_cert_format' => "Geçersiz sertifika biçimi.",
    'class_sslcertificate__invalid_private_key_format' => "Geçersiz özel anahtar biçimi.",
    'class_sslcertificate__prob_invalid_priv_key' => "Büyük olasılık, özel anahtar biçimi geçersizdir.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Karşıya yüklenecek hiçbir dosya yok.',
    'login_up__access_denied_no_permission' => "Erişim reddedildi.  Oturum açma izniniz yok.",
    'mail__unable_remove_pattern' => "Adres, sunucu kara listesinden kaldırılamıyor: %1", // PFW
    'mail__incorrect_network_format' => 'Yanlış ağ biçimi: %1', // PFW
    'initconf__unable_change_passwd' => "Yöneticinin şifresi değiştirilemiyor: %1",
    'initconf__unable_get_passwd' => 'Geçerli yönetici parolası alınamadı: %1 başarısız oldu: %2',
    'initconf__invalid_hostname' => '"%1" ana bilgisayar adında hata',
    'initconf__unable_reconfig' => 'Plesk yapılandırılamıyor: yeniden yapılandırma başarısız oldu: %1',
    'initconf__unable_update_admin' => 'Yönetici irtibat bilgileri güncellenemedi: %1',
    '__refresh' => 'Yenile',
    '__dalias_not_exist' => 'Takma alan adı yok.',
    '__bug146523_explanation' => 'Plesk\'in önceki sürümleri, FTP kullanıcı adı olarak maksimum 16 karakter kullanılmasına izin veriyordu. Plesk\'in bu sürümü, FTP kullanıcı adlarında izin verilen karakter sayısını 15 ile sınırlar. Bu sorunu çözmek için, etkilenen FTP kullanıcı adları için FTP kullanıcı adı uzunluğunu 15 karaktere indirin ve kullanıcı adı çarpışma sorunlarını önlemek için, etkilenen FTP kullanıcı adlarında en azından bir karakteri değiştirin. Bu değişiklikten kaynaklanabilecek tüm rahatsızlıklar için özür dileriz.',
    'domain__cannot_change_webmail' => 'Alan adının web postası değiştirilemiyor: %1',
    'sb_publish_disable_warning' => 'Presence Builder\'la web sitesi oluşturmayı kapatırsanız, daha önce Presence Builder\'da oluşturulan web sitesi kaldırılır ve tüm web sitesi verileri kaybolur.  Devam etmek istiyorsanız Tamam tuşunu tıklatın.',
    '__sbnet_client_use_sbnet' => "Presence Builder'da ilgili bir kullanıcı hesabı oluşturun",
    'mail_resp_activate' => 'Otomatik yanıtı etkinleştirin',
    'limitsManger__limit_available_error' => 'Gerekli kaynak miktarı ("%%limitName%%") ayrılamıyor: hesabınız için sadece %%available%% kullanılabilir.',
    'limitsManger__limit_reserved_error' => 'Zaten kullanılandan daha az kaynak ("%%limitName%%") ayrılamıyor.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Alan adı yeniden adlandırılamıyor: Adı belirtilen bir sanal dizin zaten var.',
    'domain_unable_to_rename' => 'Alan adı yeniden adlandırılamıyor.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Genel',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin gereksiz posta filtrelemesi',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin Ayarları',
    'spamfilter__spamassassin_server_status_legend' =>  "Sunucu çapında SpamAssassin gereksiz posta filtrelemesini açın",
    'spamfilter__spamassassin_user_status_legend' => 'SpamAssassin gereksiz posta filtrelemesini açın',
    'spamfilter__greylisting_status_legend' => 'Sunucu çapında gri liste gereksiz posta korumasını açın',
    'spamfilter__personal_settings_not_allowed' => 'Sistem ilkesi tarafından bireysel gereksiz posta filtreleme ayarlarının kullanımına izin verilmez.',
    'spamfilter__required_score' => 'Bir mesajın gereksiz posta kabul edilmesi için alması gereken puan',
    'spamfilter__rewrite_header_subject' => 'Gereksiz mesaj olarak algılanan her mesajın konusunun başına aşağıdaki metni ekleyin',
    'spamfilter__use_mailuser_prefs' => 'Gereksiz posta filtrelemeye bireysel ayarları uygulayın',
    'spamfilter__score_error' => 'Puanın eksi olmaması, ondalık noktasından önceki kısmın 100\'den küçük olması ve ondalık noktadan sonra en fazla iki basamak içermesi gerekir.',
    'spamfilter__rewrite_header_error' => 'Mesaj konusu numara işareti (#) dışındaki yazdırılabilir tüm karakterleri içerebilir.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Geri dönder',
    'nonexistent_mail__mode_discard' => 'Göz ardı edin',
    'nonexistent_mail__mode_catch_addr' => 'E-posta adresine iletin',
    'nonexistent_mail__mode_catch_ip' => 'IP\'ye iletin',
    'nonexistent_mail__bounce_not_supported' => 'Sıçrama modu desteklenmiyor',
    'nonexistent_mail__discard_not_supported' => 'Göz ardı etme modu desteklenmiyor',
    'nonexistent_mail__catch_not_supported' => 'E-posta adresine iletme desteklenmiyor',
    'nonexistent_mail__redirect_not_supported' => 'IP\'ye iletme desteklenmiyor',
    'nonexistent_mail__ip_used_on_this_host' => 'IP adresi, localhost olarak çözümlenir',
    'nonexistent_mail_address_should_be_local_domain' => 'Giden posta kontrolü açık olduğundan, varolmayan alıcıların Eposta adresi %1, seçilen alan adına ait olmalıdır. Aksi takdirde, iletme yerine "Reddet" ilkesi uygulanır.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Giden posta kontrolü açıldığından, posta iletme (%1) için belirtilen Eposta adresi, seçilen alan adına ait olmalıdır. Aksi takdirde, bu adrese gönderilen mesajlar, Giden Posta Kontrolünde sayılmaz.',
    // mail acc extras
    '__antivirus' => "AntiVirüs",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'Bu web sitesi için ASP.NET desteği kapalı.',
    'phosting__php_forced_by_site_isolation' => 'PHP ayarları değiştirilemiyor: sunucu çapındaki güvenlik ilkesini geçersiz kılma izni verilmemiş.',
    'phosting__option_forced_by_site_isolation' => '%1 ayarları değiştirilemiyor: sunucu çapındaki güvenlik ilkesini geçersiz kılma izni verilmemiş.',
    'phosting__php_handler_id_not_registered' => 'Site yalıtım ayarlarında PHP işleyicisine izin verilmez.  Varsayılan PHP işleyicisi kullanılır.',
    'phosting__php_served_by_nginx_is_not_available' => 'Site yalıtım ayarlarında PHP işleyicisine (FPM application served by nginx) izin verilmez. Varsayılan PHP işleyicisi kullanılır.',

    // tooltips

    'b_get_password_cancel' => 'E-postayı göndermeden önceki ekrana dönün.',
    'b_get_password_send' => 'Sistemde kayıtlı Eposta adresine bir şifre kurtarma mesajı göndermek için Tamam tuşunu tıklatın.',

    'b_back' => 'Önceki sayfaya dön.',
    'b_next' => 'Bir sonraki sayfaya git.',

    'b_dnsnstemplatelist_remove' => 'Seçili isim sunucularını sil.',
    'b_dnsnstemplatelist_search' => 'İsim sunucusu adına göre arama yap.',
    'b_dnsnstemplatelist_show_all' => 'Bütün isim sunucularını göster.',

    'l_dnsnstemplatelist_ns' => 'DNS şablonu kayıtlarını ad sunucusuna göre sıralayın.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Güvenli dosya ve klasör bağlantıları oluşturun',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Genel dosyaları etkinleştirin',
    'cu__serverfilesharing_fsPublicFolder' => 'Genel dosya depolaması için klasör',
    'cu__serverfilesharing_fsPublicUrl' => 'ziyaretçilerin genel dosyalara erişimi için URL',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Genel dosyaların şifre korumasını etkinleştirin',
    'cu__serverfilesharing_fsPartnerFolder' => 'Şifre korumalı dosya depolaması için klasör',
    'cu__serverfilesharing_fsPartnersLogin' => 'Dosya erişimi için kullanıcı adı',
    'cu__serverfilesharing_fsPartnersPassword' => 'Dosya erişimi şifresi',
    'cu__serverfilesharing_fsDomain' => 'Web klasörü kök URL\'si. Alan adı',
    'cu__serverfilesharing_fsPrefix' => 'Web klasörü kök URL\'si.  Önek',
    'cu__serverfilesharing_commandUpdate' => 'Dosya paylaşma ayarlarını güncelleyin',
    'cu__serverfilesharing_commandInfo' => 'Geçerli dosya paylaşma ayarlarını görüntüleyin',
    'subscription_rename_is_forbidden' => 'Aboneliği yeniden adlandırma, sunucu çapında ilkeyle yasaklanmış.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "%1 Alan Adı Altındaki FTP Hesapları", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP hesapları",
    'ftp__user_name' => "FTP hesabı adı",
    'ftp__user_home' => "Ana dizin",
    'ftp__invalid_path' => "Geçersiz yol belirtildi",
    'i_ftp_ses_sub_user' => 'FTP hesabı oturumu.',
    '__new_passwd' => "Yeni %1 şifresi",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => '<%%host%%> ana bilgisayarında bir web sunucusu yapılandırılamıyor',
    'apacheConfigurationFailedMessageBody' => "Aşağıdaki hatalardan dolayı, ana bilgisayarda <%%host%%> sunucuyu yapılandırma dosyası oluşturulamıyor:\n\n %%error%%\n\n Lütfen web sunucusu yapılandırma şablonlarındaki hataları giderin ve dosyayı tekrar oluşturun.",

    'apacheConfigurationMessageAdminTitle' => 'Web sunucusu yapılandırmasını oluşturma başarısız',
    'apacheConfigurationMessageClientTitle' => 'Uyarı',

    'apacheConfigurationFailedAdminHomeMessage' => 'Yapılandırma şablonlarındaki hatalardan dolayı yeni yapılandırma dosyası oluşturulmadı. Ayrıntılı hata mesajı e-postanıza gönderildi, dolayısıyla lütfen e-postayı kontrol edin, hataları giderin ve yapılandırmayı yeniden oluşturmayı denemek için %1 bağlantısını tıklatın.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'buraya', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Yapılandırma şablonlarındaki hatalardan dolayı %1 alan adı için yeni yapılandırma oluşturulmadı. Ayrıntılı hata mesajı Epostanıza gönderildi, dolayısıyla lütfen Epostayı kontrol edin, hataları giderin ve yapılandırmayı yeniden oluşturmayı denemek için %2 bağlantısını tıklatın.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'buraya', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => '%1 alan adı için web sunucusu yapılandırması tutarsız olabilir. Sorunu çözmek için lütfen sunucu yöneticisiyle irtibata geçin.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Yapılandırma şablonlarındaki hatalardan dolayı alan adlarının bazıları için yeni yapılandırma oluşturulmadı. Ayrıntılı hata mesajı Epostanıza gönderildi, dolayısıyla lütfen Epostayı kontrol edin, hataları giderin ve yapılandırmayı yeniden oluşturmayı denemek için %1 bağlantısını tıklatın.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'buraya', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Alan adlarınızın bazıları için web sunucusu yapılandırması tutarsız olabilir. Sorunu çözmek için lütfen sunucu yöneticisiyle irtibata geçin.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Özel hata belgeleri",
    'dom_pref__webusers_script' => "Web kullanıcılarının komut dosyalarını kullanmasına izin verin",
    '__seoRedirect' => 'Tercih edilen alan adını bu şekilde yapılandırın',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Hiçbiri',

    '__sites' => 'Alan Adları',
    'domain_plan__perm_denied_manage_phosting' => 'Barındırma ayarlarını yönetme izniniz yok.',
    '__owned_by_client' => 'müşteriye aittir',
    'backup__restore__object_client_template' => 'Müşteri şablonu',
    '__template_name' => 'Servis planı adı',
    'template__not_exists' => 'Böyle bir servis planı yok',
    'template__exists' => '%1 adına sahip bir planı zaten var.',
    'clientOwnerChanger__ip_not_in_pool' => 'Belirtilen IP adresi satıcının havuzunda değil.',
    '__owner_name' => 'Servis planı sahibi',

    'chown__error_check' => 'Aboneliklerin bazıları yeni bir sahibe atanmaya çalışılırken bazı sorunlarla karşılaşıldı.',

    '__redirect_hint' => '15 saniye içinde yeni adrese yönlendirileceksiniz... Otomatik olarak yeni konuma götürülmüyorsanız, lütfen javascript\'i etkinleştirin veya %%link%% bağlantısını tıklatın.',

    'backup__restore__object_maillist' => 'Gönderim listesi',
    'backup__restore__object_site' => 'Konum',
    'backup__restore__object_user' => 'Kullanıcı',
    'backup__restore__object_role' => 'Rolü',

    'limit__name_max_site' => 'site',

    'iis_pool__unable_rename_client' => "IIS Uygulama Havuzu yeniden adlandırılamıyor: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonim FTP servisi sadece bir aboneliğin ana alan adı için desteklenir.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Anonim FTP servisi sadece bir aboneliğin ana alan adı için desteklenir.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/ay',
    '__tb_month' => 'TB/ay',

    '__customer_total' => 'Müşteri toplamı',
    '__site' => 'Konum',
    '__def_site' => 'Varsayılan tesis',
    '__subscription_name' => 'Abonelik Adı',
    '__subscription_name_powerUser' => 'Abonelik Adı',

    'limit__units_max_traffic_suffix' => '/ay',

    'dom_pref__discard' => "Reddet",

    'mail__pattern_already_exists' => '"%1" deseni zaten kara listede.',

    '__not_supported' => 'Desteklenmiyor',

    'plesk_key__sitebuilder' => 'Presence Builder\'la yayınlanan siteler',
    'limit__name_max_site_builder' => 'Presence Builder\'la yayınlanan siteler',
    'plesk_key__wpb-multi-language-sites-support' => 'Presence Builder\'da çok dilli siteler için destek',

    'login_up__access_denied_no_subscriptions' => "Erişim reddedildi.  Bu hesap için kullanılabilir abonelik yok.",

    'interval__day' => '%1 Gün(ler)',
    'interval__hour' => '%1 saat',
    'interval__minute' => '%1 dakika',
    'interval__second' => '%1 saniye',

    ///License options
    'plesk_key__backward_incompatibility' => 'Plesk\'in başka bir sürümü için oluşturulmuş lisans anahtarını kullanmaya çalışıyorsunuz. Uygun bir lisans anahtarı almak için Plesk satış temsilcileriyle irtibata geçin.',
    //Standalone or virtualization
    'virtualization_any' => "Fiziksel sunucu veya herhangi bir sanallaştırma çözümü",
    'virtualization_pvc' => "Virtuozzo kapsayıcılarında",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Sunucusu",
    'plesk_key__virtualization' => "Aşağıdaki ortamlar için geçerlidir:",
    'plesk_key__virtualization_only_key' => 'Lisans anahtarı ancak bir %1 sanal ortamının içinde çalışan Plesk\'le kullanılmak için tasarlanmıştır.',
    'plesk_key__virtualizations_only_key' => 'Lisans anahtarı ancak aşağıdaki sanal ortamların içinde çalışan Plesk\'le kullanılmak için tasarlanmıştır: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Özel dil paketlerini kullanmak yasaktır.',
    'plesk_key__allowed-locales' => 'Kullanılabilir diller',
    'plesk_key__allowed-locales-any' => 'Herhangi bir dil',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin dizini burada bulunur',
    '_cgi_bin_mode_webspace' => 'aboneliğin kök dizini',
    '_cgi_bin_mode_www_root' => 'bu alan adının belge kökü',

    /// Custom buttons
    'custom_button__sort_key' => 'Öncelik',
    'custom_button__place' => 'Konum',
    'custom_button__place_navigation' => 'Ortak Erişim',
    'custom_button__place_admin' => 'Yöneticinin Başlangıç sayfası',
    'custom_button__place_admin-settings' => 'Yöneticinin Araçlar ve Ayarlar sayfası',
    'custom_button__place_reseller' => "Satıcının Başlangıç sayfası",
    'custom_button__place_reseller-settings' => 'Satıcının Araçlar ve Yardımcı Programlar sayfası',
    'custom_button__place_client' => 'Müşterinin Başlangıç sayfası',
    'custom_button__place_domain' => "Aboneliğin Web Siteleri ve Alan Adları sayfası",
    'custom_button__place_domain_powerUser' => "Aboneliğin Web Siteleri ve Alan Adları sayfası",
    'custom_button__place_domain-properties' => 'Web Sitesi Araçları',
    'custom_button__private' => 'Sadece bana gösterin',
    'custom_button__image' => 'Fon resmi',
    'custom_button__conhelp' => "Araç ipucu metni",
    'custom_button__edit' => "Ek Servis Bağlantısının Ayarları",
    'custom_button__include_client_cname' => "Müşterinin şirket adını dahil edin",
    'custom_button__include_client_email' => "Müşterinin e-postasını dahil edin",
    'custom_button__include_client_id' => "Müşteri kimliğini dahil edin",
    'custom_button__include_client_pname' => "Müşterinin kişi adını dahil edin",
    'custom_button__include_domain_id' => "Abonelik kimliğini, alan adı kimliğini ve alan adı takma adı kimliğini dahil edin",
    'custom_button__include_domain_id_powerUser' => "Abonelik kimliğini, alan adı kimliğini ve alan adı takma adı kimliğini dahil edin",

    'custom_button__include_domain_name' => "Birincil Alan adını dahil edin",
    'custom_button__include_ftp_user' => "FTP kullanıcı adını dahil edin",
    'custom_button__include_ftp_pass' => "FTP şifresini dahil edin",
    'custom_button__internal_open' => "URL'yi Plesk'te açın",
    'custom_button__text' => "Buton metni",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Dosya bir resim dosyası değil.',
    'custom_button__big_image' => 'Dosya boyutu 100 KB aşmamalıdır.',
    'custom_button__failed_copy_image' => 'Dosyalarının kopyası alınamıyor: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Power User görünümünde Power User dışındaki bir yedekleme geri yüklenemiyor.',
    '__unknown_network_interface' => 'Bilinmeyen ağ arayüzü',

    'init_conf__ip_address' => 'IP Adresi',

    //Confirmation page
    'bt_confirm' => 'Onayla',
    'b_confirm' => 'Sitelerinizin sahipliğini onaylayın.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Atanmış IIS uygulama havuzunun ayarları, sunucu çapında güvenlik ilkesine göre ayarlanır (site yalıtım yapılandırması).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Atanmış IIS uygulama havuzunun ayarları, sunucu çapında performans ayarlarına göre ayarlanır.',

    '__current' => 'Geçerli',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Neredeyse Plesk lisansınızla sağlanan tüm alan adlarını (%90\'ını ve daha da fazlasını) kullandınız.',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Neredeyse tüm alan adlarınızı kullandınız.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Neredeyse Plesk lisansınızla sağlanan tüm Presence Builder sitelerini (%90\'ını ve daha fazlasını) kullandınız.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Neredeyse tüm Presence Builder sitelerini kullandınız.',
    'promo__button_hide' => 'Gizle',
    'promo__button_next' => 'İleri >>',
    'promo__button_prev' => '<< Geri',
    'promo__button_license' => 'Lisansı Güncelleyin',

    'promo__google_integration_title' => 'Google servisleriyle entegrasyon',
    'promo__google_integration' => 'Örneğin AdSense, Google Apps, Webmaster araçları gibi Google servisleriyle entegrasyonu yapılandırın.',
    'promo__google_integration_button' => 'Yapılandırma',

    'promo__button_learn_more' => 'Daha Fazla Bilgi Edin',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Arayüz görünümünü ve markalama ayarlarını özel temalar yardımıyla özelleştirebilirsiniz. Plesk temalarını özelleştirme talimatları için bakın %1.',
    'panel_branding__description_link' => 'aşağıdaki belge',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Dosyaları Çıkartın',
    'filemanager_error_extracting_files' => 'Arşiv dosyalarını çıkartırken bir hata oluştu: %1',
    'filemanager_no_archive_files_specified' => 'Ayıklamak istediğiniz arşivleri belirtin.',
    'filemanager_not_zip_archive_specified' => '%1 çıkartılamıyor, bir ZIP arşivi değil.',
    'filemanager_files_successfully_extracted' => 'Arşiv dosyaları ayıklandı.',
    'filemanager_error_file_download' => 'Dosya indirme başarısız: %1',
    'filemanager__user_poolgrp' => 'Uygulama havuzu grubu',

    'loading' => 'Yükleniyor...',
    'bt_create_archive' => 'Arşive Ekleyin',
    'filemanager__pack' => "Arşiv yolu: %1",
    'filemanager__archive_name' => 'Arşiv dosya adı',
    'filemanager__empty_filename' => 'Lütfen arşiv dosyasının adını girin.',
    'filemanager_archive_created' => 'Arşiv başarıyla oluşturuldu.',
    'filemanager_error_creating_archive' => 'Arşiv oluşturulamıyor: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Bu kayıt, bölgesi için yapışkan AAAA kaydıyla çakışır.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP sunucusu IPv6 adreslerini desteklemiyor.)",
    'cmd_dns__glue_dns_record_conflict' => 'Bu kayıt, \'%1\' bölgesi için yapışkan kaydıyla çakışır.',
    '__ftp_ipv6_not_supported' => "(FTP sunucusu IPv6 adreslerini desteklemiyor.)",
    '__ipv6_not_supported' => 'IPv6 desteklenmiyor.',
    'mail__ipv6_not_supported' => 'IPv6, posta sunucusu tarafından desteklenmiyor.',
    'mail__relay_while_list_ipv6_not_supported' => 'IPv6 iletmesi beyaz listesi, posta sunucusu tarafından desteklenmiyor.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'İşaret değerinin, 16\'nın katı olması gerekir.',
    'mail__ip_or_mask_is_invalid' => 'IP adresi veya maske geçersiz.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'IPv6 IP adreslerine iletme desteklenmiyor.',
    'sa__invalid_trusted_networks' => 'Yanlış belirtilen güvenilir ağlar: %1',
    'dns_add__enter_ipv6_address' => "IPv6 adresi",
    'license_trial_days_left' => 'Plesk\'iniz, %1 gün sonra süresi dolacak olan bir deneme lisansıyla çalışıyor.',
    'excl_ipv6_num' => 'Atanmış IPv6 adresi',
    '__ip_mask' => "Subnet Maskesi",
    '__ipv4_addr' => 'IPv4 adresi',
    '__ipv6_addr' => 'IPv6 adresi',
    'template__num_excl_ipv6s' => 'Atanmış IPv6 adreslerini satıcıya ayırın',
    'anonftp__exclusive_ipv4_required' => 'Anonim FTP servisini kurmak ve kullanmak için atanmış bir IPv4 adresi gerekir.',
    'anonftp__ipv4_already_used' => 'Zaten aynı IPv4 adresinin başka bir alan adında yapılandırılmış olduğundan, bu site için anonim FTP servisi ayarlayamazsınız.',


    'restart__kav' => "Kaspersky Antivirüs",
    '__view_migration_log_detailed_info' => 'Günlüğü görüntüleyin',

    'chown__error_ip_absent_in_ip_pool' => 'IP adresi %1, hedef kullanıcının IP havuzunda yok.',
    'chown__error_ip_not_exist' => 'Kimliği \'%1\' olan IP adresi yok.',
    'chown__error_domain_ip_not_selected' => '%1 alan adı için en az bir IP adresinin seçilmesi gerekir. IP eşleme için seçilen değerleri kontrol edin.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 adresi veya maske geçersiz: IP adresinin geçerli bir tek noktaya yayın adresi olması gerekir.',

    '__subscriptions' => 'Abonelik',

    '__owned_by_reseller' => 'satıcıya aittir',
    '__owned_by_provider' => 'sağlayıcıya aittir',

    'service_plan__anonymous' => 'Özel',
    'subscription_not_locked__change_limits_warning' => 'Bu abonelik kilitli değil: Kaynak kullanımı sınırları, servis planıyla senkronizasyon sırasında değiştirilir.',
    'subscription_not_locked__change_permissions_warning' => 'Bu abonelik kilitli değil: İzinler, servis planıyla senkronizasyon sırasında değiştirilir.',

    'subscription__conflict_resolution_policy' => 'Çözünürlük ilkesiyle çakışıyor',
    'subscription__conflict_resolution_policy_lock' => "Aboneliği kilitleyin",

    'backup__list__backup_warnings' => 'Uyarılar',
    'backup__list__backup_info' => 'Danışma',
    'backup__restore__object_reseller_template' => 'Satıcı şablonu',
    'backup__restore__object_domain_template' => 'Alan adı şablonu',

    'subscription__unable_lock_anonymous' => 'Bu abonelik bir servis planına bağlı değil, dolayısıyla kilidi açılamaz.',
    'subscription__unable_sync_anonymous' => 'Bu abonelik bir servis planına bağlı değil, dolayısıyla senkronize edilemez.',
    'subscription__unable_sync_locked' => 'Bu abonelik kilitlenir ve böylece senkronize edilemez.',
    'subscription__locked' => 'Abonelik kilitli.',
    'component_name__urlrewrite' => "URL Yeniden Yazma",
    '__quantity' => 'Miktar',
    'hst__www_root_dir_absent' =>  'Dikkat: Bir belge kökü olarak belirtilen dizin yok.',
    'object_creation__domain_is_not_a_webspace' => 'Bu nesne sadece bir abonelikte oluşturulabilir.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Abonelik site içeriyor, dolayısıyla barındırma tipini değiştiremez veya onu silemezsiniz.',
    'phosting__apache_error_docs_are_not_enabled' => 'Özel hata belgeleri alan adında etkinleştirilmemiş.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Hata: IP adresi güncellenemedi. Aboneliğin ana alan adına atanmamış olan bir IP adresine eklenti alan adı atanamaz.',
    'domain_plan__unable_change' => 'Servis planı değiştirilemiyor: %1.',
    'domain_plan__different_hosting_type' => 'Geçerli barındırma tipi, servis planında belirtilen tipten farklı.',
    'domain_plan__addon_text' => 'Eklenti planı',
    'domain_plan__addon_description' => 'Eklenti planı, bir barındırma planı eklemek için kullanılır.',
    'asp_net__managed_runtime_version' => 'ASP.NET ile yönetilen çalışma süresi sürümü',
    'plan__can_not_change_hosting_type' => 'Bir planı düzenlerken barındırma tipini değiştirmek imkansızdır.',
    'plan__apply_problems' => 'Plan, aşağıdaki işlevle ilgili sorunlardan dolayı uygulanmadı: %1',
    'plan_save__subscription_update_problem' => '%1 için plan değişiklikleri uygulanamıyor.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Yedekleme veya geri yükleme işlemi tamamlanana kadar, abonelik geçici olarak askıya alındı.  Lütfen daha sonra geri gelin.",
    '__login_incorrect_plain_shadow_password' => 'Yöneticinin hesabı için yanlış bir şifre belirttiniz. Lütfen sistem yöneticisi (kök) kimlik bilgilerini kullanın veya doğru şifreyi alın. Şifreyi öğrenme hakkında daha fazla bilgi edinmek için, /etc/psa/README.psa.shadow dosyasını okuyun.',

    '__perm_denied_ip' => 'Sahip olmadığınız IP adresi gönderilemiyor',

    'dns__dns_zone_not_synchronized' => 'DNS bölgesi değiştirildi. DNS şablonu değişikliklerini bu bölgeye uygulamak istiyorsanız, ya bu sayfadaki \'DNS Şablonu Değişikliklerini Uygula\' düğmesini tıklatın veya Sunucu Yönetim Paneli > Araçlar ve Ayarlar > DNS Şablonu Ayarları > DNS Şablonu Değişikliklerini Uygula altındaki \' DNS Şablonu Değişikliklerini Uygulayın\' seçeneğini seçin.',
    'dns__dns_zone_synchronize_link' => 'Doğru şekilde biçimlendirilmiş bir metin dosyası örneği için',
    'dns__dns_zone_synchronize_done' => 'DNS bölgesi başarıyla senkronize edildi.',

    'dns__dns_zone_template_error' => 'Bunlar, DNS bölgelerini DNS bölgesi şablonuyla senkronize etme sorunlarıydı.%1',

    'dns__soa_rname_type_owner' => 'Web sitesi sahibinin e-posta adresi',
    'dns__soa_rname_type_domain' => 'Alan adının e-posta adresi',
    'dns__soa_rname_type_external' => 'Harici e-posta adresi',
    'dns__soa_rname_enforce_email' => 'RNAME e-posta adressini alan adı tabanında değiştirmeyi yasaklayın',
    'dns__soa_rname_label' => 'E-posta (RNAME)',
    'dns__soa_rname_hint' => 'Alan adının DNS bölgesinden sorumlu kişinin e-posta adresi. SOA sorgularına yanıt olarak DNS sunucu tarafından geri döndürüldü.',

    'dns__dns_zone_soa_sync_title' => 'Varolan tüm alan adlarının SOA ayarlarını geçersiz kıl',
    'dns__dns_zone_soa_sync_legend' => 'Onay gerekli',
    'dns__dns_zone_soa_sync_text' => 'Yapılan değişiklikler SOA şablonuna uygulanarak, barındırılan tüm alan adlarının SOA kayıtları güncellensin mi?',

    'cu_db__repair_mysql_dbus' => "MariaDB/MySQL kullanıcı şifrenizi onarın. Bu işlem, eski sürümlerden Plesk 11'e yükselttiğinizde gerekir.",

    'cu_scheduled_backup_comment' => 'Planlanan Yedekleme',
    'cu_scheduled_backup_error' => 'Yedekleme işlemi sırasında bir hata oluştu: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Planlı yedekleme sırasında bir hata oluştu.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk giriş noktası: %2 \n\nPlanlı yedekleme işlemi sırasında aşağıdaki hatalar oluştu: \n\n%3",

    'cu_scheduled_backup_hourly' => 'Saatlik Yedekleme',
    'cu_scheduled_backup_daily' => 'Günlük Yedekleme',
    'cu_scheduled_backup_weekly' => 'Haftalık Yedekleme',
    'cu_scheduled_backup_monthly' => 'Aylık Yedekleme',
    'cu_scheduled_backup_comment_backup_all' => '%1. Tüm yapılandırma ve içerik.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Posta mesajları hariç, tüm yapılandırma ve içerik.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Yalnızca yapılandırma ve posta mesajları.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Kullanıcı veritabanları hariç tüm yapılandırma ve içerik.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Kullanıcı dosyaları hariç tüm yapılandırma ve içerik.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Yalnızca yapılandırma ve kullanıcı veritabanları.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Yalnızca yapılandırma ve kullanıcı dosyaları.',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Alan adı yapılandırması.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Planlanmış yedeklemeleri uzak bir bulut deposunda depolamak premium bir özelliktir. Kilidi açmak için barındırma sağlayıcınıza başvurun.',

    'i_backup_invalid_file' => 'Bu, geçerli bir yedekleme değil.  Bu dosyadan veriler geri yüklenemez.  Ayrıntılar için yedekleme adını tıklatın.',

    'filemanager_resulting_archive_exists' => '%1 dosyası hedef dizinde zaten var.',

    'agent_unable_to_connect' => '\'%2\' konumundaki aracıya bağlanılamıyor.  Lütfen aracı yüklü olduğundan ve çalıştığından ve \'%2\' ana bilgisayarında hiçbir bağlantı sorunu olmadığından emin olun.',
    'agent_test_connection_failed' => '\'%2\' konumundaki aracıya bağlantı başarısız.',

    'agent_unable_to_resolve_host' => 'Uzak ana bilgisayar \'%1\' bulunamıyor.  Lütfen ana bilgisayarda hiçbir bağlantı sorunu olmadığından emin olun.',
    'agent_unknown_curl_error' => '\'%2\' konumundaki aracıya bağlantı sırasında \'%1\' hatası oluştu.',
    'agent_unexpected_htp_code' => '\'%2\' aracısına yapılan HTTP talebinde beklenmeyen http kodu \'%1\' alındı.',
    'agent_unable_to_auth' => '\'%1\' ana bilgisayarında doğrulama yapılamıyor. Bu sorunu çözmek için, lütfen http://kb.plesk.com/116606 adresindeki talimatları izleyin.',
    'agent_internal_server_error' => 'Uzak ana bilgisayarda \'%1\' komutu yürütme sırasında dahili bir sunucu hatası bulundu.',
    'agent_response_is_empty' => '\'%1\' aracısına yapılan HTTP talebinde boş bir yanıt alındı.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Yerel önbellekte Migration & Transfer Agent bulunamıyor.  Lütfen sorunu gidermek için Migration &Transfer Manager\'ı yeniden açın.',

    '__hosting_webdeploy' => "Web Dağıtımını yayınlama",
    'cu_domain__webdeploy' => "Web Dağıtımını yayınlama (varsayılan: %1)",
    'cu_dom_tpl__webdeploy' => "Web Dağıtımını yayınlama (varsayılan: %1)",
    'cu_subdomain__webdeploy' => "Web Dağıtımını yayınlama (varsayılan: %1)",
    'webdeploy__not_installed' => "Microsoft Web Dağıtımı sunucuda yüklü değil",
    'webdeploy__forced_by_site_isolation' => "Web Dağıtımını yayınlama ayarları değiştirilemiyor: Sunucu çapındaki güvenlik ilkesini geçersiz kılma izniniz yok.  Ayrıntılar için sağlayıcınızla irtibata geçin.",



    'backup__restore_options__admin__server_configuration_license' => 'Lisans anahtarı',
    'migration_start_migrate_server_license' => 'Lisans anahtarını aktarın',

    'defaultcomponents__delegation_rule_not_exist' => '(gerekli atama kuralı \'appPoolPipeline, appPoolNetFx\' yok)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Yedekleme, yönetici tarafından oluşturuldu.',
    'i_backup_created_by_reseller' => 'Yedekleme, bir satıcı tarafından oluşturuldu.',
    'i_backup_created_by_client' => 'Yedekleme, bir müşteri tarafından oluşturuldu.',

    'migration__object_exists_on_target_host' => '(hedef ana bilgisayarda zaten var)',

    'cu_cl_pref__manage_website_maintenance' => 'Gelişmiş işlemlere erişin: Web Sitesini Kopyalayın',
    'cu_cl_pref__manage_protected_dirs' => 'Şifre korumalı dizinler yönetimi',
    'cu_cl_pref__manage_mail_settings' => 'Posta ayarlarını değiştirme yeteneği',


    'cu__command_update_php_settings' => 'PHP ayarlarını günceller.',
    'cu__php_settings_option' => 'PHP ayarlarıyla dosyanın yolunu ayarlar.',

    'cu__additional_php_settings_option' => 'Ek PHP direktifleriyle dosyanın yolunu ayarlar.',
    'cu__command_show_php_settings' => 'Geçerli PHP ayarlarını görüntüler.',
    'cu__general_settings' => 'Genel Ayarlar:',
    'cu__performance_settings' => 'Performans Ayarları:',
    'cu__php_fpm_settings' => 'PHP-FPM ayarları:',
    'cu__additional_directives' => 'Ek direktifler:',

    'php_settings_permission_required' => 'Ortak PHP ayarları yönetimi',
    'php_settings_performance_permission_required' => 'Barındırma performans ayarları yönetimi',
    'php_settings_customized' => 'PHP ayarları özelleştirildi.',
    'php_settings_synchronized_with_plan' => 'PHP ayarlarının planla senkronize edilmesi gerekir.',
    'phosting__unknown_shell_type' => 'Kullanılamayan kabuk',

    'login_up__access_denied_subscription_deleted' => 'Erişim reddedildi: Aboneliğiniz kaldırıldı.',

    'role_restricted_to_subscription' => '(abonelikle aktarıldı: %1)',

    'filemanager__extract' => "Dosyaları buraya çıkartın: %1",

    'cu__license_command_check_installed_license' => 'Yüklü lisans anahtarının geçerliliğini kontrol edin (anahtar geçerliyse 0, geçersizse 1 çıkış kodunu verir)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Sunucuyu taşınabilir cihazlardan (BlackBerry, iPhone ve Android) kontrol edebilmek ve izleyebilmek için, Plesk işlevselliğini genişletin.",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Plesk sunucuları hakkındaki en önemli bilgileri taşınabilir bir cihazdan (BlackBerry, iPhone ve Android) her zaman ve her yerden elde edin.',
    'promo__mobile_button' => 'Daha Fazla Bilgi Edin',

    'subDomainNameHint' => 'Bir joker alt alan adı oluşturmak için, bir alt alan adı olarak * girin. Site ziyaretçileri, bir tarayıcıya girdikleri alt alan adına bakılmaksızın bu alt alan adına yönlendirilecektir.',
    'subdomains__wildcard_name_invalid' => "Alt alan adı geçersiz. Joker alt alan adları için sadece alfasayısal karakterler, bir çizgi (-) ve bir yıldız (*) kullanabilirsiniz.",
    'subdomains__name_invalid' => "Alt alan adı geçersiz. Alt alan adları için sadece alfasayısal karakterler ve bir çizgi (-) kullanabilirsiniz.",

    'domain__wildcard_no_www_prefix' => 'Joker alt alan adları için www önekini kullanmak mümkün değil.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix posta filtresi",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3 sunucusu",
    'restart__pop3s' => "SSL/TLS destekli Courier POP3 sunucusu",
    'restart__imap' => "Courier IMAP sunucusu",
    'restart__imaps' => "SSL/TLS destekli Courier IMAP sunucusu",
    'restart__authdaemon' => "Courier IMAP doğrulaması daemon",
    'restart__imap-pop3' => "Dovecot IMAP ve POP3 sunucusu",


    'addon_packages_not_supported' => 'APS paketlenmiş web uygulamalarının eklentileri desteklenmiyor.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Alan adına otomatik olarak bir IP adresi atanamıyor. Lütfen -ip seçeneğini kullanarak bir IP adresi belirtin.',

    'plesk_key__mb_accounts' => 'Customer and Business Manager\'daki kullanıcı hesapları (satıcılar ve müşteriler)',

    'actionlog__subdomain_dns' => 'Alt alan adı DNS bölgesi',
    'actionlog__site_subdomain_dns' => 'Bir ek alan adı altındaki bir alt alan adının DNS bölgesi',

    // PfW only
    'actionlog__event_site_create' => 'Alan adı oluşturuldu',
    'actionlog__event_site_delete' => 'Alan adı silindi',
    'actionlog__event_site_update' => 'Alan adı güncellendi',

    'actionlog__event_site_status_update' => 'Alan adı durumu güncellendi',
    'actionlog__event_site_dns_update' => 'Alan adı DNS bölgesi güncellendi',
    'actionlog__event_site_guid_update' => 'Alan adı GUID güncellendi',

    'actionlog__event_site_subdomain_create' => 'Alt alan adı oluşturuldu',
    'actionlog__event_site_subdomain_delete' => 'Alt alan adı silindi',
    'actionlog__event_site_subdomain_update' => 'Alt alan adı güncellendi',

    'actionlog__event_site_alias_create' => 'Takma alan adı oluşturuldu',
    'actionlog__event_site_alias_delete' => 'Takma alan adı silindi',
    'actionlog__event_site_alias_update' => 'Takma alan adı güncellendi',

    'actionlog__event_site_alias_dns_update' => 'Bir takma alan adının DNS bölgesi güncellendi',
    'actionlog__event_subdomain_dns_update' => 'Varsayılan alan adı altındaki bir alt alan adının DNS bölgesi güncellendi',
    'actionlog__event_site_subdomain_dns_update' => 'Bir alt alan adının DNS bölgesi güncellendi',
    // End of PfW only

    'win_policy__bad_password' => 'Doğrulama başarısız. Şifre geçerli değil.',
    'win_policy__password_too_short' => 'Doğrulama başarısız. Şifre, şifre ilke koşullarını sağlamıyor, çünkü çok kısa.',
    'win_policy__password_too_long' => 'Doğrulama başarısız. Şifre, şifre ilke koşullarını sağlamıyor, çünkü çok uzun.',
    'win_policy__password_not_complex_enough' => 'Doğrulama başarısız. Şifreniz yeterince karmaşık değil ve politika gereksinimlerini karşılamıyor. Güçlü şifreler aşağıdakilerin hepsini içermelidir: Sekiz karakter, bir küçük ya da bir büyük harf, üç numara ve bir özel karakter (!, @, #, $, %, ^, &, *, ?, _, ~) ya da bir numara ve iki özel karakter.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Ürün lisansı güncellenemiyor.',


    'filemanager__error_path_is_not_allowed' => 'Yola izin verilmiyor',
    'filemanager__error_path_is_invalid' => 'Yol geçersiz',
    'filemanager__error_path_not_found' => 'Yol bulunamadı',
    'filemanager__error_path_already_exists' => 'Yol zaten mevcut',
    'filemanager__error_access_is_denied' => 'Erişim reddedildi',
    'filemanager__error_directory_not_empty' => 'Klasör boş değil',
    'filemanager__error_sharing_violation' => 'İhlali paylaşma',
    'filemanager__error_not_same_device' => 'Hedef yolu aynı aygıtta değil',
    'filemanager__unable_to_resolve_realpath' => "%1 dosyası belirtilen konumda bulunamıyor",
    'filemanager__access_to_realpath_denied' => "realpath erişimi reddedildi: %1 - %2.",
    'bt_exit' => 'Kapat',

    'filemanager__copy_error__' => "%1 den %2 ye kopyalanamıyor: %3",
    'filemanager__copy_move' => "dosyaları %1 dan kopyala(taşı)",
    'filemanager__count_size__' => 'Seçilen boyut: %1',
    'filemanager__count_size_error__' => '%1 boyutu hesaplanamıyor: %2',
    'filemanager__create_dir_error__' => "Dizin yaratılamıyor %1: %2",
    'filemanager__dir_not_exists' => "Dizin %1 yok.",
    'filemanager__dirname' => "Dizin adı",
    'filemanager__filename' => "Dosya adı",
    'filemanager__is_no_such' => "%1 adıyla bir dosya veya dizin yok",
    'filemanager__empty_selection' => "Hiçbir dosya seçilmedi.",
    'filemanager__move_error__' => "%1 den %2 ye taşınamıyor: %3",
    'filemanager__not_allowed' => "Bu dosya için izinleri değiştirme izniniz yok.",
    'filemanager__remove' => "%1 dan dosyaları kaldır",
    'filemanager__remove_error__' => "%1 dosya kaldırılamıyor: %2",
    'filemanager__set_win_permissions_dir' => "%1 klasörü için izileri ayarla",
    'filemanager__set_win_permissions_file' => "%1 dosyası için iziznleri ayarla",
    'filemanager__touch_confirm' => "Seçili dosyalar için tarihi değiştirmek istediğinize eminmisiniz?",
    'filemanager__upload_error__' => "%1 den %2 ye yüklenmiyor: %3",
    'filemanager__upload_file' => "Dosya yükle",
    'filemanager__upload_file_src' => "Dosyanın yolu",
    'filemanager__max_image_size_exceeded' => 'Görüntü görüntülenemiyor.  Resim boyutu %2 bayttan fazla olamaz',

    '__fastcgi_unix_support' => 'FastCGI desteği',

    'dns__subdomain_dns_zone_parent' => 'Bu alt alan adının DNS kayıtları, üst DNS bölgesinde saklanır. Üst bölgeyi %1 değiştirebilir veya alt alan adı için ayrı bir bölge oluşturabilirsiniz.',
    'dns__subdomain_dns_zone_parent_link' => 'buraya',
    'dns__no_dns_zone' => 'Alan adına atanmış hiçbir DNS bölgesi yok. Alan adınız için DNS bölgesini yönetmek için, \'Varsayılanı Geri Yükle\' düğmesine basmanız gerekir.',
    'dns__unable_turn_on_subdomain_zone' => 'Üst alan adı bölgesinde bu alt alan adı için bir CNAME kaydı olduğundan, alt alan adı bölgesi açılamıyor.',

    '__hosting_write_modify' => 'Ek yazma/değiştirme izinleri',

    'aspdotnet__group_framework_version' => "Framework Versiyonu",

    'bt_restore_default' => "Temizle",
    'b_autoinstaller' => 'Plesk\'i veya bileşenlerini güncelleyin.',
    'b_autoinstaller_configure' => 'Güncelleştirme ayarları.',
    'b_autoinstaller_install' => 'Seçili bileşenleri yükle.',

    '__iis_app_pool__use_dedicated' => 'Atanmış IIS uygulama havuzu',
    '__iis_app_pool__use_dedicated_addons' => 'Her web sitesi için atanmış IIS uygulama havuzu',
    '__iis_app_pool__enable_32bit_app_on_win64' => '32 bit uygulamaları etkinleştir',
    '__iis_app_pool__load_user_profile' => 'Kullanıcı profilini yükle',
    'bt_iis_app_pool' => "IIS Uygulama Havuzu",

    'performance__cpu_usage' => 'Maksimum işlemci kullanımı (%)',
    'performance__cpu_usage_action' => 'Sınır eylemi',
    'performance__cpu_usage_interval' => 'Sınır aralığı (dakika)',
    'performance__cpu_usage_action_not_supported' => 'Belirtilen eylem, web sunucusu tarafından desteklenmiyor.',

    'performance__idle_timeout_action_not_supported' => 'Belirtilen boşta zamanaşımı eylemi, web sunucusu tarafından desteklenmiyor.',
    'performance__max_worker_processes' => 'Maksimum çalışan işlemi sayısı',
    'performance__idle_timeout' => 'Boşta zamanaşımı (dakika)',
    'performance__idle_timeout_action' => 'Boşta zamanaşımı eylemi',
    'performance__recycling_by_time' => 'Düzenli zaman aralıklarında geri dönüştürme (dakika)',
    'performance__recycling_by_requests' => 'Maksimum istek sayısına ulaşıldığında geri dönüştürme',
    'performance__recycling_by_virtual_memory' => 'Maksimum sanal bellek miktarı kullanıldığında geri dönüştürme',
    'performance__recycling_by_private_memory' => 'Maksimum kişisel bellek miktarı kullanıldığında geri dönüştürme',
    'performance__managed_pipeline_mode' => 'Yönetilen ardışık düzen modu',
    'performance__managed_pipeline_mode_not_supported' => 'Belirtilen mod, web sunucusu tarafından desteklenmiyor.',

    'iis_app_pool' => 'IIS uygulama havuzu yönetimi.',
    'b_iis_app_pool' => 'IIS uygulama havuzunu yönetin.',
    'iis_app_pool_cl_dom' => 'IIS uygulama havuzu yönetimi.',

    'bt_protect' => 'Şifre Koruması',
    'bt_unprotect' => 'Şifre Korumasını Kaldır',
    'bt_show_additional_users' => 'Daha fazla kullanıcı göster',
    'bt_hide_additional_users' => 'Daha az kullanıcı göster',
    'error_doc__code_400' => 'Hatalı İstek',
    'error_doc__code_401' => 'Yetki Verilmemiş',
    'error_doc__code_401.1' => 'Yetkisiz - Oturum açma başarısız oldu',
    'error_doc__code_401.2' => 'Yetkisiz - Sunucu yapılandırmasından yolayı oturum açma başarısız oldu',
    'error_doc__code_401.3' => 'Yetkisiz - Sunucudaki ACL nedeniyle yetkilendirilmedi',
    'error_doc__code_401.4' => 'Yetkisiz - Yetkilendirme filtre nedeniyle başarısız oldu',
    'error_doc__code_401.5' => 'Yetkisiz - Yetkilendirme ISAPI/CGI uygulaması nedeniyle başarısız oldu',
    'error_doc__code_401.7' => 'Yetkisiz - URL yetkilendirme ilkesinden dolayı reddedildi',
    'error_doc__code_403' => 'Yasak',
    'error_doc__code_403.1' => 'Yasak - Yürütme erişimi reddedildi',
    'error_doc__code_403.2' => 'Yasak - Okuma erişimi reddedildi',
    'error_doc__code_403.3' => 'Yasak - Yazma erişimi reddedildi',
    'error_doc__code_403.4' => 'Yasak - SSL gerekli',
    'error_doc__code_403.5' => 'Yasak - SSL 128 gerekli',
    'error_doc__code_403.6' => 'Yasak - IP adresi reddedildi',
    'error_doc__code_403.7' => 'Yasak - İstemci sertifikası gerekli',
    'error_doc__code_403.8' => 'Yasak - Site erişimi engellendi',
    'error_doc__code_403.9' => 'Yasak - Çok fazla kullanıcı',
    'error_doc__code_403.10' => 'Yasak - Geçersiz yapılandırma',
    'error_doc__code_403.11' => 'Yasak - Şifre değiştirmesi',
    'error_doc__code_403.12' => 'Yasak - Eşleyici erişimi reddetti',
    'error_doc__code_403.13' => 'Yasak - İstemci sertifikası iptal edildi',
    'error_doc__code_403.14' => 'Yasak - Dizin listesi reddedildi',
    'error_doc__code_403.15' => 'Yasak - İstemci erişimi lisansları aşıldı',
    'error_doc__code_403.16' => 'Yasak - İstemci sertifikası güvenilmez veya bozuk',
    'error_doc__code_403.17' => 'Yasak - İstemci sertifikasının süresi doldu ya da henüz geçerli değil',
    'error_doc__code_403.18' => 'Yasak - Bu uygulama havuzundan istek yürütülemez',
    'error_doc__code_403.19' => 'Yasak - CGI erişimi reddedildi',
    'error_doc__code_403.20' => 'Yasak - Passport oturum açması başarısız',
    'error_doc__code_404' => 'Bulunamadı',
    'error_doc__code_404.2' => 'Bulunamadı - Kilitleme ilkesinden dolayın reddedildi',
    'error_doc__code_404.3' => 'Bulunamadı - MIMEMAP ilkesinden dolayın reddedildi',
    'error_doc__code_405' => 'Yönteme izin verilmiyor',
    'error_doc__code_406' => 'Kabul edilemez',
    'error_doc__code_407' => 'Proxy kimlik doğrulaması gerekiyor',
    'error_doc__code_408' => 'Talep zaman aşımı',
    'error_doc__code_412' => 'Önkoşul başarısız oldu',
    'error_doc__code_414' => 'İstek URI\'si çok uzun',
    'error_doc__code_415' => 'Desteklenmeyen ortam türü',
    'error_doc__code_431' => 'Talep başlık alanları çok büyük',
    'error_doc__code_500' => 'İç sunucu hatası',
    'error_doc__code_500.12' => 'Dahili sunucu hatası - Uygulama yeniden başlatılıyor',
    'error_doc__code_500.13' => 'Dahili sunucu hatası - Sunucu çok meşgul',
    'error_doc__code_500.15' => 'Dahili sunucu hatası - GLOBAL.ASA için doğrudan talepler yasak',
    'error_doc__code_500.16' => 'Dahili sunucu hatası - UNC erişim hatası',
    'error_doc__code_500.17' => 'Dahili sunucu hatası - URL yetkilendirme deposu bulunamadı',
    'error_doc__code_500.18' => 'Dahili sunucu hatası - URL yetkilendirme deposu açılamıyor',
    'error_doc__code_500.19' => 'Dahili sunucu hatası - Bozuk dosya meta verisi',
    'error_doc__code_500.100' => 'Dahili sunucu hatası - ASP hatası',
    'error_doc__code_501' => 'Gerçeklenmemiş',
    'error_doc__code_502' => 'Hatalı ağ geçidi',
    'error_doc__code_503' => 'Hizmet geçici olarak kullanım dışı',

    'mimetype_edit__already_exists' => 'Bu uzantı için tanımlanmış MIME tipi zaten mevcut.',
    'mimetype_edit__not_exists' => 'MIME tipi yok.',

    'php__group_php_version' => "PHP Sürümü",

    'virtualdir__path' => 'Yol',
    'virtualdir__read' => 'Okuma izni',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Yazma izni',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Script çalıştırma yetkisi',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Dizin görüntüleme',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Çalıştırma yetkisi',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Ziyaretleri Logla',
    'virtualdir__app_create' => 'Uygulama Yarat',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Anonim doğrulamayı açar.',
    'virtualdir__auth_windows' => 'Windows doğrulamasını açar.',
    'virtualdir__auth_not_enabled' => 'Anonim veya Windows doğrulamasının açılması gerekir.',
    'virtualdir__require_ssl' => 'SSL/TLS iste',
    'virtualdir__enable_default_doc' => 'Varsayılan belgeleri kullanın',
    'virtualdir__default_doc' => 'Varsayılan döküman sıralaması',
    'virtualdir__enable_parent_paths' => 'Üst yolları kullanmaya izin verin',
    'virtualdir__execute_in_mta' => 'MTA (çok dişli apartman) modunda uygulama yürütmesine izin verin',
    'virtualdir_create__title' => '%1 için Sanal dizin oluştur',
    'virtualdir_edit__title' => 'Sanal dizin %1 özellikleri',
    'virtualdir_edit__legend' => 'Sanal dizin',
    'virtualdir_edit__application_legend' => 'Uygulama ayarları',
    'virtualdir_edit__security_legend' => 'Dizin Güvenliği',
    'virtualdir_edit__documents_legend' => 'Dökümanlar',
    'virtualdir_edit__list_legend' => 'İçerlek sanal dizinler',
    'virtualdir_error__path_not_in__' => 'Geçersiz yol belirtildi',
    'virtualdir_root' => 'Sanal Dizinler',
    'virtualdir_root__title' => 'Sanal Dizinler',
    'virtualdir_root__list_legend' => 'Sanal Dizinler',
    'virtualdir_se__none' => 'Hiçbiri',
    'virtualdir_se__script' => 'Sadece Script',
    'virtualdir_se__script_execute' => 'Scriptler ve exeler',
    'virtualdirs__title' => 'Sanal Dizinler',
    'virtualdirs__path_not_exists' => 'geçersiz yol.',
    'virtualdirs__select_for_remove' => "Silmek istediğiniz sanal dizinleri seçiniz.",
    'virtualdirs_remove__title' => 'Sanal dizinleri sil',

    'asp_max_buffer_text' => 'Maksimum ASP arabelleği boyutu (KB)',
    'asp_max_body_text' => 'Bir ASP talebinin maksimum tüzel kişilik gövdesi boyutu (KB)',
    'asp_buffers_legend' => 'ASP Ayarları',
    'asp_client_debug_text' => 'ASP istemci tarafında komut dosyası hata ayıklamayı etkinleştirin',
    'asp_server_debug_text' => 'ASP sunucu tarafında komut dosyası hata ayıklamayı etkinleştirin',

    'permissions__group_or_user_name' => 'Grup veya kullanıcı adları',
    'permissions__FullControl' => 'Tam Denetim',
    'permissions__Modify' => 'Değiştir',
    'permissions__ReadAndExecute' => 'Oku ve Çalıştır',
    'permissions__ListFolderContents' => 'Klasör İçeriklerini Listele',
    'permissions__Read' => 'Okuma',
    'permissions__Write' => 'Yazma',
    'permissions__ReadControl' => 'Okuma Denetimi ',
    'permissions__WriteControl' => 'Yazma Denetimi',
    'permissions__ExecuteControl' => 'Yürütme Denetimi',
    'permissions__TraverseFolderOrExecuteFile' => 'Klasöre Çapraz Geçiş Yapma/Dosya Yürütme',
    'permissions__ListFolderOrRead' => 'Klasörü Listele / Veri Oku',
    'permissions__CreateFilesOrWrite' => 'Dosya Oluştur / Veri Yaz',
    'permissions__CreateFoldersOrAppend' => 'Klasör Oluştur / Veri Ekle',
    'permissions__DeleteSubfoldersandFiles' => 'Alt Klasörleri ve Dosyaları Sil',
    'permissions__Delete' => 'Sil',
    'permissions__ChangePermissions' => 'İzinleri Değiştir',
    'permissions__TakeOwnership' => 'Sahiplik Al',
    'permissions__inherited_from' => 'Devralındığı yer',
    'permissions__not_inherited' => '<devralınmamış>',
    'permissions__apply_to' => 'Uygulama alanı',
    'permissions__apply_onto' => 'Uygulanacak:',
    'permissions__apply_onto1' => 'Yalnızca bu klasör',
    'permissions__apply_onto2' => 'Yalnızca alt klasörler',
    'permissions__apply_onto3' => 'Bu klasör ve alt klasörler',
    'permissions__apply_onto4' => 'Yalnızca dosyalar',
    'permissions__apply_onto5' => 'Bu klasör ve dosyalar',
    'permissions__apply_onto6' => 'Yalnızca alt klasörler ve dosyalar',
    'permissions__apply_onto7' => 'Bu klasör, alt klasörler ve dosyalar',

    'filemanager__not_allowed_dir' => "Bu klasör için izinleri değiştirme izniniz yok.",

    'filemanager__allow' => "İzin verin",
    'filemanager__deny' => "Reddedin",
    'filemanager__user_domusr' => 'Web sitesi yöneticisi',
    'filemanager__user_webusr' => 'Web kullanıcısı',
    'filemanager__user_admins' => 'Lokal administrator',
    'filemanager__user_system' => 'SİSTEM',
    'filemanager__user_aspnet' => 'ASP.NET kullanıcısı',
    'filemanager__user_poolusr' => 'Application pool kullanıcısı',
    'filemanager__user_sysaccount' => 'Ek sistem kullanıcısı',

    'bt_permissions_advanced' => 'Gelişmiş',
    'b_permissions_advanced' => 'Özel izinler ayarlamak ve görüntülemek için tıklatın.',

    'hotlink-protection_invalid_friend_domain' => 'Dost alan adı için geçersiz ad.',
    'hotlink-protection_duplicate_friend_domain' => 'Dost alan adları için yinelenen ad.',
    'hotlink-protection_invalid_extensions' => 'Dosya uzantıları uygun olmayan karakter içeriyor.',

    'i_domain_alias_status_on' => 'Takma alan adı etkinleştirildi.',
    'i_domain_alias_status_off' => 'Takma alan adı devre dışı bırakıldı.',
    'i_domain_alias_status_with_parent' => 'Alan adı kapandığından, takma alan adı devre dışı bırakıldı.',
    'i_domain_alias_turn_off' => 'Devre dışı bırakmak için tıklatın.',
    'i_domain_alias_turn_on' => 'Etkinleştirmek için tıklatın.',

    'domain_alias__control_title' => 'Takma alan adı %1',
    'domain_alias__control_info_legend' => 'Bilgi',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Hizmet adı',
    'domain_alias__control_details_title' => 'Detaylar',

    'domain_alias__invalid_values' => 'Belirttiğiniz alan adı geçersizdir. Alan adları harf, basamak ve çizgilerden oluşabilir. Noktaların arasındaki alan adının her parçası, 63 simgeden uzun olmamalıdır.',
    'domain_alias__domain_already_exists' => "Takma alan adının %1 yanlış adı. %1 alan adı zaten var.",
    'domain_alias__www_prefix_domain_already_exists' => "Takma alan adı www.%1 yanlış adı. Alan adı %1 için bu takma adı zaten oluşturuldu.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Takma alan adı web postasının %1 yanlış adı. Alan adı %1 için bu takma adı zaten oluşturuldu.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Takma alan adı listelerinin %1 yanlış adı. Alan adı %1 için bu takma adı zaten oluşturuldu.',
    'domain_alias__dns_record_already_exists' => '%1 alan adı ayarlanamıyor, çünkü ana bilgisayara %1 işaret eden bir DNS kaydı zaten var.',
    'domain_alias__domain_alias_already_exists' => "Adı böyle olan bir takma alan adı zaten var.",
    'domain_aliases__mail_server_not_support_aliases' => 'Posta sunucusu, takma alan adları özelliğini desteklemez. Takma alan adları düzgün çalışmayabilir.',
    'domain_alias__restrict_domain_creation' => 'Bir takma alan adı için belirtilen ad, sunucu çapındaki ilke tarafından yasaklanmış. Bu takma alan adı size aitse lütfen barındırma sağlayıcınızla irtibata geçin.',
    'domain_alias__restrict_creation_with_www' => 'Lütfen \'www\' öneki olmayan bir alan adı girin. Alan adının www öneki, web sunucusu yapılandırmasına otomatik olarak eklenir.',
    'domain_unable_to_set_name' => 'Yanlış ad %1.',

    'domain_alias__domain_service_dns_disabled' => 'Bu alan adına başka bir DNS sunucusu tarafından servis sağlanıyor.',
    'domain_alias__domain_service_dns_enabled_master' => 'Bu DNS sunucusu, bu DNS bölgesi için birincil ana ad sunucusu olarak çalışır.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Bu DNS sunucusu, bu DNS bölgesi için bir ikincil ad sunucusu olarak çalışır.',
    'domain_alias__domain_service_mail_enabled' => 'Alan adı için posta servisi açık.',
    'domain_alias__domain_service_mail_disabled' => 'Alan adı için posta servisi kapalı.',
    'domain_alias__domain_service_mail_mx' => '%1, posta sunucusu olarak kullanıldı.',

    'domain_alias__service_seoRedirect_hint' => 'Ziyaretçiler takma adının URL\'sini açtıklarında, birincil alan adının URL\'sine yönlendirilirler. Plesk, arama motoru için uygun HTTP 301 yeniden yönlendirmesini kullanır, yani arama motoru sırası URL\'ler arasında bölünmez.',

    'bt_task_run_now' => 'Şimdi Çalıştır',
    'ftp__read_perm' => "Okuma izni",
    'ftp__write_perm' => "Yazma izni",

    'filemanager__upload_backup_file_hint' => 'Burada yedekleme dosyalarını Plesk deposuna yükleyebilirsiniz. Maksimum dosya boyutu, iki gigabaytla sınırlıdır.',

    '__default_for_mssql' => 'MS SQL için varsayılan',

    '__login_does_not_pass_validation' => "Kullanıcı adı geçersiz.  Aşağıdaki gereksinimleri sağladığından emin olun: %1",
    '__login_allowed_symbols' => 'Sadece noktalar, çizgiler ve altçizgiler de dahil, alfasayısal karakterlere izin verilir.  İlk karakterin alfasayısal olması gerekir.',

    'restart__nginx' => 'Ters Vekil Sunucu (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Plesk'ten genel ürün bilgileri ve duyuruları almak istiyorum.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Plesk'ten güvenlikle ilgili bilgileri ve diğer teknik bildirimleri almak istiyorum.",

    '__login_status_inactive' => 'Hesabınız etkin değil. Lütfen Plesk yöneticisiyle irtibata geçin.',

    'migration__task_keep_in_process' => 'Tamam',
    'migration__task_keep_in_process_conhelp' => 'Araçlar ve Ayarlar sayfasına dönün.  Göç arka planda devam edecek.',

    'chk_js__warning_about_ftp_login_syntax' => "Kullanıcı adında alfasayısal, çizgi ve alt çizgi simgelerini kullanabilirsiniz.",
    'chk_js__warning_about_passwd_syntax' => "Bir şifrede tırnak, boşluk ve ulusal alfabe karakterlerini kullanmayın.\nŞifrenin %1 - %2 karakter arasında olması ve kullanıcı adını içermemesi gerekir.",
    'chk_js__warning_about_plesk_login_syntax' => "Kullanıcı adında küçük harfli alfasayısal, nokta, çizgi ve alt çizgi simgelerini kullanabilirsiniz.",
    'chk_js__warning_about_admin_passwd_syntax' => "Bir şifrede tırnak, boşluk, noktalı virgül ve ulusal alfabe karakterlerini kullanmayın.\nŞifrenin %1 - %2 karakter uzunluğunda olması ve kullanıcı adını içermemesi gerekir.",

    'cmd_server__admin_alias_not_found' => "Ek yönetici hesabı bulunamıyor.",

    'panel_branding__skins_already_exists' => "Not: Tema '%1' zaten var.  Şu an kurduğunuz temayla değiştirilir.",
    'panel_branding__skins_file_exists' => "'%1' teması için bir dizin oluşturulamıyor: Adı böyle olan bir dosya zaten var.",

    'actionlog__login_failed' => 'oturum açma başarısız oldu',
    'actionlog__event_cp_user_login_failed' => 'Plesk kullanıcısı oturum açamadı',
    'actionlog__api_login_failed' => 'API üzerinden oturum açma başarısız oldu',
    'actionlog__event_cp_user_api_login_failed' => 'Plesk kullanıcısı API üzerinden oturum açamadı',
    'actionlog__pw_reset' => 'şifre sıfırlama talep edildi',
    'actionlog__pw_admin_force_reset' => 'yönetici şifresini zorla sıfırlamayı talep etti',

    'ch_pass_admin__email_subject' => "Plesk şifre sıfırlama isteğiniz",
    'ch_pass_admin__email_body' => "Merhaba, %1.\n\nYönetici şifresi güvenlik sebepleriyle e-posta ile gönderilemez.\n\n'Admin' olarak giriş yapmak için 'plesk login' komutunu kullanın.\n\nYeni bir 'admin' şifresi belirlemek için 'plesk bin admin --set-password -passwd <new_password>' komutunu kullanın\n\n",
    'ch_pass_admin__message_send_error' => 'E-posta gönderilemed: %1',

    'ch_pass_by_secret__email_subject' => "Plesk şifreniz sıfırlamak mı istiyorsunuz?",
    'ch_pass_by_secret__email_body' => "Merhaba %2,\n\nŞifre sıfırlama talebinde bulunduysanız yeni bir şifre belirlemek için bu bağlantıyı takip edin: %1\n\nKullanıcı adınız: %3",
    'ch_pass_by_secret__message_send_error' => 'Gizli kod gönderilemiyor: %1',
    'ch_pass_by_secret__title' => 'Şifrenizi Değiştirin',
    'ch_pass_by_secret__secret' => 'Gizli kod',

    'custom_button__noframe' => "Çerçeveleri kullanmayın",

    'custom_button__internal_hint' => 'URL\'yi bir Plesk sayfasında mı, yoksa yeni bir tarayıcı penceresinde mi açacağını belirtin.',
    'custom_button__noframe_hint' => 'Bir Plesk uzantısına veya Müşteri Paneli bir uygulamaya götüren özel bir düğme eklediğinizde, bu uzantının/uygulamanın nasıl görüntüleneceğini belirtebilirsiniz: bir çerçevede veya Plesk GUI\'sinin bir parçası olarak.',


    'actionlog__patch' => 'Güncelle',
    'actionlog__patch_available' => 'kullanılabilir',
    'actionlog__event_patch_available' => 'Güncelleştirme var',
    'actionlog__patch_installed' => 'kuruldu',
    'actionlog__event_patch_installed' => 'Güncelleme yüklü',

    'actionlog__extension' => 'Uzantı',
    'actionlog__extension_status' => 'Uzantı durumu',
    'actionlog__cloning' => 'Sunucu kopyalama',
    'actionlog__cloning_complete' => 'tamamlandı',
    'actionlog__event_cloning_complete' => 'Sunucu kopyalama tamamlandı',

    'actionlog__ssl_web_binding' => 'Alan adındaki SSL/TLS sertifikası',
    'actionlog__ssl_web_binding_update' => 'atanmış/atanmamış',
    'actionlog__event_ssl_web_binding_update' => 'Alan adındaki SSL/TLS sertifikası atanmış/atanmamış',

    'actionlog__ssl_web_mail_binding' => 'Web postasındaki SSL/TLS sertifikası',
    'actionlog__ssl_web_mail_binding_update' => 'atanmış/atanmamış',
    'actionlog__event_ssl_web_mail_binding_update' => 'Web postasındaki SSL/TLS sertifikası atanmış/atanmamış',

    'actionlog__ssl_mail_binding' => 'Posta sunucusundaki SSL/TLS sertifikası',
    'actionlog__ssl_mail_binding_update' => 'atanmış/atanmamış',
    'actionlog__event_ssl_mail_binding_update' => 'Posta sunucusundaki SSL/TLS sertifikası atanmış/atanmamış',

    'actionlog__ssl_panel_binding' => 'Plesk\'teki SSL/TLS sertifikası',
    'actionlog__ssl_panel_binding_update' => 'atanmış/atanmamış',
    'actionlog__event_ssl_panel_binding_update' => 'Plesk\'teki SSL/TLS sertifikası atanmış/atanmamış',

    'actionlog__hostname' => 'Sunucu sahibi ana bilgisayar adı',
    'actionlog__hostname_changed' => 'değişti',

    'actionlog__smb_user' => 'Ek kullanıcı',
    'actionlog__smb_user_create' => 'Ek kullanıcı oluşturuldu',
    'actionlog__smb_user_delete' => 'Ek kullanıcı silindi',
    'actionlog__smb_user_update' => 'Ek kullanıcı güncellendi',

    'actionlog__event_mail_management_status_update' => 'Posta yönetimi durum güncellemesi',
    'actionlog__mail_management' => 'Posta yönetimi durumu',
    'actionlog__mail_management_status_update' => 'güncellendi',

    'virtualization_openvz' => 'OpenVZ',

    'passwordSecurityLevelCheckFailed' => 'Şifreniz yeterince karmaşık değil. Sunucu ilkesine göre en düşük şifre güvenlik düzeyi %1 şeklindedir. Şifrenin güvenlik düzeyini artırmak için, numaralar, büyük ve küçük harfli karakterler ve!,@,#,$,%,^,&,*,?,_,~ gibi özel karakterler kullanın',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Çok zayıf',
    'passwordSecurityLevelCheckFailedWeak' => 'Zayıf',
    'passwordSecurityLevelCheckFailedMediocre' => 'Orta',
    'passwordSecurityLevelCheckFailedStrong' => 'Güçlü',
    'passwordSecurityLevelCheckFailedStronger' => 'Çok güçlü',

    'dns__dns_default_ipv4_modified' => 'Bu IP adresi olan kayıtlar, kullanıcı tarafından değiştirilmiş kabul edilecek ve sunucu çapında DNS şablonuyla senkronize edilmeyecektir.',
    'dns__dns_default_ipv6_modified' => 'Bu IP adresi olan kayıtlar, kullanıcı tarafından değiştirilmiş kabul edilecek ve sunucu çapında DNS şablonuyla senkronize edilmeyecektir.',

    'dns__view_dns_record_master_title' => 'Kaynak Kayıtlarını Görüntüleme',
    'dns__view_dns_record_off_title' => 'Ad Sunucusu Kayıtlarını Görüntüleme',
    'dns__view_dns_record_slave_title' => 'Birincil DNS Sunucusu Kayıtlarını Görüntüleme',

    'dns_unable_to_resolve_hostname' => "Ana makine adı \"%1\" çözümlenemiyor: %2\nİşletim sisteminin DNS çözücüsünün kurulu olduğundan ve düzgün çalıştığından emin olun.",

    'no_database_server_available' => 'Bu abonelik için kullanılabilir hiçbir veritabanı sunucusu yok.',

    'database_used_by_application_can_not_be_moved' => 'Veritabanı taşınamıyor: Bir web sitesi uygulaması bu veritabanını kullanıyor.',
    'database_user_update_orphaned_is_restricted' => 'Yalnız bırakılmış veritabanı kullanıcı hesaplarını güncellemek yasaktır. Bunları sadece silebilir veya onarabilirsiniz.',

    'database_unable_to_get_max_filesize_default_message' => 'Veritabanının maksimum dosya boyutu belirlenemiyor: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Veritabanının maksimum dosya boyutu ayarlanamıyor: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Veritabanının maksimum günlük dosyası boyutu belirlenemiyor: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Veritabanının maksimum günlük dosyası boyutu ayarlanamıyor: \'%1\'',

    'database_unable_to_get_max_filesize' => '\'%1\' Microsoft SQL veritabanının dosyası boyutunun geçerli sınırı belirlenemiyor. Yeni bir sınır ayarlamak imkansız.',
    'database_unable_to_set_max_filesize' => 'Microsoft SQL veritabanının \'%1\' dosya boyutunun sınırı ayarlanamıyor.',
    'database_unable_to_get_max_log_filesize' => '\'%1\' Microsoft SQL veritabanının günlük dosyası boyutunun geçerli sınırı belirlenemiyor. Yeni bir sınır ayarlamak imkansız.',
    'database_unable_to_set_max_log_filesize' => 'Microsoft SQL veritabanının \'%1\' günlük dosya boyutunun sınırı ayarlanamıyor.',

    'database_unable_to_create_because_max_filesize' => 'Microsoft SQL veritabanı \'%1\' oluşturulamıyor: Dosya boyutu, izin verilen maksimum boyuttan daha büyük.',
    'database_unable_to_move_because_max_filesize' => 'Microsoft SQL veritabanı \'%1\' taşınamıyor: Dosya boyutu, izin verilen maksimum boyuttan daha büyük: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Microsoft SQL veritabanı \'%1\' oluşturulamıyor: Günlük dosyası boyutu, izin verilen maksimum boyuttan daha büyük.',
    'database_unable_to_move_because_max_log_filesize' => 'Microsoft SQL veritabanı \'%1\' taşınamıyor: Günlük dosyası boyutu, izin verilen maksimum boyuttan daha büyük: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Microsoft SQL veritabanı \'%1\' geri yüklenemiyor: Dosya boyutu, izin verilen maksimum boyuttan daha büyük.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Plesk\'te zaten aynı MS SQL sunucusu kayıtlı. Lütfen korumalı olarak başka bir MS SQL sunucusu belirtin.',
    'database_server__mssql_server_registered_as_sandbox' => 'Plesk\'te zaten aynı korumalı MS SQL sunucusu kayıtlı. Lütfen korumalı olarak başka bir MS SQL sunucusu belirtin.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Sunucuya \'%1\': %2 ile bağlanılamıyor',

    'bu_conflict_resolver_feature_not_available' => '%1 özelliği aşağıdaki servis düğümleri tarafından desteklenmiyor: %2. Bu düğümlerde oluşturulan tüm nesneler için bu özellik devre dışı bırakılır.',
    'bu_conflict_resolver_feature_not_available_single_server' => '%1 özelliği bu sunucu tarafından desteklenmiyor.  Geri yüklenen tüm nesneler için bu özellik devre dışı bırakılır.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Bileşen %1 yüklenmedi. Aşağıdaki web siteleri için kullanılamaz: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Bileşen %1 yüklenmedi. Aşağıdaki web siteleri için %2 ile değiştirilir: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Geçerli Plesk sürümü, noktalı (.) kullanıcı adlarını desteklemiyor karakter. Bu kullanıcı adlarına sahip olan müşteriler ve satıcılar geri yüklenmez.',
    'bu_conflict_resolver_unable_to_find_backup_part' => '%1 %2 verileriyle bir yedekleme dosyası bulunamıyor. %1 %2 verileri geri yüklenmeyecek.',

    'bu_conflict_resolver_zone_master_removed' => "Birincil DNS kaydı geri yüklenemiyor: İkincil bölgedeki kayıt, varolan IP adresine %1 işaret ediyor. Birincil DNS kaydı ikincil bölgeden kaldırılacak.",
    'bu_conflict_resolver_dns_not_supported_https' => 'HTTPS DNS kayıtları için destek kapatıldı. Şu alan adları için HTTPS kayıtları geri yüklenmeyecek: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 desteklenmiyor.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 desteklenmiyor. Aşağıdaki web siteleri için kullanılamaz: {{objects}}',
    'bu_conflict_resolver_not_available_component' => '%1 bileşeni kurulmamış.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Aşağıdaki servis düğümleri için kullanılamaz: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Aşağıdaki nesneler için kullanılamaz: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Aşağıdaki veritabanı sunucuları bu sunucuda kullanılamaz: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'Smarthost yönetimi desteklenmiyor. Smarthost ayarları geri yüklenmeyecek.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL veritabanı yedekleme dosyası, yedekleme ayarları tam yapılandırılmış olarak sadece yerel MS SQL sunucusunda veya uzak MS SQL sunucusuna geri yüklenebilen MS SQL doğal biçiminde saklanır. Plesk\'te kayıtlı uygun hiçbir MS SQL sunucusu olmadığından, veritabanlarınızın bazıları geri yüklenmedi. Aşağıdaki alan adları etkilendi: {{objects}}. Barındırma sağlayıcınızla irtibata geçin.',

    'bu_conflict_resolver_not_available_webmail' => 'Web postası servisi %1 kullanılamıyor.  Aşağıdaki nesneler için %2 ile değiştirilir: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Web postası servisi %1 kullanılamıyor.  Aşağıdaki servis planları için %2 ile değiştirilir: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "'%1' tipi veritabanları, veritabanı adlarıyla çakışan kullanıcı adlarını desteklemiyor.  Kullanıcı '%2', '%4' veritabanı için '%3' olarak yeniden adlandırılır.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Disk alanı kullanımıyla ilgili sınır, hedef sunucu yapılandırmasında ayarlanmamıştır.  Bu ayarın değeri, "Sınırsız" olarak değiştirilir.',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Bağlantı sayısının sınırı, hedef sunucu yapılandırmasında ayarlanmamış. Bu ayarın değeri, "Sınırsız" olarak değiştirilir.',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Trafik kullanımıyla ilgili sınır, hedef sunucu yapılandırmasında ayarlanmamıştır. Bu ayarın değeri, "Sınırsız" olarak değiştirilir.',
    'cu__pleskrestore_backup_file_extracted' => 'Yedekleme dosyası "%1" konumuna ayıklandı.',
    '__mod_bw_not_supported' => 'Apache web sunucusunun mod_bw modülü, dosya sisteminin yapılandırmasından dolayı desteklenmiyor.  Trafik kullanımıyla ilgili sınırlar ve maksimum bağlantı sayısı çalışmaz.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Posta iletme için POP3 yetkilendirmesi desteklenmez, onun yerine SMTP\'den önce POP3 yetkilendirmesi kullanılır.  ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Servis planı \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 desteklenmiyor. Aşağıdaki servis planları için %2 ile değiştirilir: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 desteklenmiyor.  Aşağıdaki web siteleri için %2 ile değiştirilir: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Yedekleme dosyasında aşağıdaki nesneler bulunamadı: %1',
    'bu_conflict_resolver_absent_domains' => 'Plesk\'te bulunmayan aşağıdaki alan adlarına ait olduklarından, bazı nesneler geri yüklenemiyor: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Plesk'te bulunmayan aşağıdaki üst alan adlarına ait olduklarından, bazı web siteleri geri yüklenemiyor:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'DNS bölgeleri geri yüklenemiyor: DNS servisi, sunucu yapılandırmasında kapandı.',
    'bu_conflict_resolver_mail_not_supported' => 'Posta kutuları geri yüklenemiyor: Posta servisi, sunucu yapılandırmasında kapandı.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Belirtilen işlemci sınırı eylemi, IIS web sunucusu tarafından desteklenmiyor. Değer, %1 olarak sıfırlanır.',
    'bu_conflict_detector_server_ssl_cert_name' => 'sunucu SSL/TLS sertifikası %1',
    'bu_conflict_detector_domain_ssl_cert_name' => '%1 alan adının SSL/TLS  sertifikası %2',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS sertifikasını %1',
    'bu_conflict_resolver_absent_objects' => 'Nesneler Plesk\'te bulunmadığından, aşağıdaki nesnelerin içindekiler geri yüklenemez: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Posta kutuları Plesk\'te bulunamadığından, aşağıdaki posta kutularının içindekiler geri yüklenemez: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Postalama listeleri Plesk\'te bulunamadığından, aşağıdaki postalama listelerinin içindekiler geri yüklenemez: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Veritabanları Plesk\'te bulunamadığından, aşağıdaki veritabanlarının içindekiler geri yüklenemez: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => '"%2" üzerindeki "%1" uygulamasını kurtarma başarısız oldu, çünkü "%3" üzerinde zaten başka bir uygulama yüklü. Yüklü uygulamayı kaldırıp yeniden deneyebilirsiniz.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Posta otomatik yanıtlama işlevi desteklenmiyor.',
    'bu_conflict_resolver_not_available_mail_content' => 'Posta içeriğini kurtarma desteklenmiyor.',
    'bu_conflict_resolver_invalid_mail_name' => 'Şu posta kutuları geri yüklenemedi çünkü e-posta alt adresleme etkinleştirilmiş ve bazı e-posta adresleri "%1" işareti içeriyor: %2',
    'bu_conflict_resolver_invalid_user_name' => 'Şu kullanıcılar geri yüklenemedi çünkü e-posta alt adresleme etkinleştirilmiş ve bazı e-posta adresleri "%1" işareti içeriyor: %2',
    'bu_conflict_resolver_licenses_expired' => 'Aşağıdaki lisansların süresi doldu ve geri yüklenemez: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Aşağıdaki lisansların geçerli değil ya da süresi dolmuş ve geri yüklenemez: {{objects}}',
    'expiration_unsupported' => "'expiration' sınırı desteklenmiyor.",

    'component_name__dbconnector' => "Veritabanı Konektörü",
    'component_name__mysqlserver' => 'MariaDB/MySQL Sunucusu',
    'component_name__troubleshooting' => 'Sorun Giderme',
    'component_name__savi' => 'Sophos Anti Virüs Arayüzü',

    '__subscription_has_no_license_key' => 'Abonelik kaynakları, ilişkili bir lisans anahtarı olmayan servis düğümü #%1 tarafından sağlanır.',
    '__subscription_has_expired_license_key' => 'Abonelik kaynakları, lisans anahtarının %2 süresi dolan servis düğümü #%1 tarafından sağlanır.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Yapılandırma dosyaları kaydedilemiyor',
    '__cfgmonConfigurationFileSaveErrorBody' => "<%%host%%> ana bilgisayarına bazı yapılandırma dosyaları kaydedilemiyor: Aşağıdaki hatalar oluştu:\n\n %%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Bu seçenek, posta listeleri için VERP tarzı e-posta adreslerini yapılandırma yeteneğini etkinleştirir',
    'mail__enter_right_ip_mask' => "1 ile 32 arasındaki IP maskesini girin",
    'mail__enter_right_ip_mask_24' => "24 ile 32 arasındaki IP maskesini girin",
    'mail__invalid_dom_name' => "Alan adı %1 geçersiz.",
    'mail__invalid_pop_lock_time' => "POP3 kilit süresi geçerli değil.",
    'mail__invalid_rbl_server' => "DNS bölgesinin adı geçersiz.",
    'mail__total_files_size' => "Toplam depo boyutu: %1",
    'mail__filename_already_in_repository' => "Depoda aynı ada sahip bir dosya zaten var",
    'mail__no_white_list_mask_feature_24' => "24 veya üstündeki bir maske değerini kullanın.\nPosta sunucunuz, maskeleri ayarlamayı desteklemiyor. Sadece 24'ten az olmayan değerler için ayar maskesini öykünebiliriz.",
    'mail__unable_add_new_mail_name' => "Posta hesabı eklenemiyor: %1",
    'mail_server_is_not_installed' => 'Posta sunucusu (Postfix veya Qmail) yüklü değil. Çalışmaya devam etmek için onu kurun.',
    'mail_server_not_available' => 'Servis düğümünde kullanılabilir hiçbir desteklenmiş posta sunucusu yok.',
    '__not_installed' => '(kurulu değil)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Giden e-posta mesajlarındaki gereksiz posta filtreleme devre dışı bırakılmış.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Servis düğümü, bir alan adından %1 alan adına giden Eposta mesajı sayısını sınırlandırmayı desteklemiyor.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Servis düğümü, bir posta kutusundan %1 alan adına giden Eposta mesajı sayısını sınırlandırmayı desteklemiyor.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'En az bir tip (IPv4 veya IPv6) adres belirtin.',

    'mail__outgoing_email_mode_invalid' => 'Geçersiz bir giden posta modu belirtildi.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Geçersiz bir IPv4 adresi belirtildi.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Geçersiz bir IPv6 adresi belirtildi.',
    'mail__outgoing_email_mode_unavailable' => 'Büyük olasılık bu sunucuda Postfix posta sunucusu yüklü olmadığından, giden posta modunu değiştirme desteklenmiyor.',

    'mail__autoresponder_attachment_not_supported' => 'Şu an kullanılan posta sunucusu otomatik yanıtlama eklenti yönetimini desteklemiyor.',

    'mail__smtp_white_list_not_supported' => 'Mevcut kullanılan posta sunucusu IP adresi beyaz listelemeyi desteklemiyor.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR maskeleri seçilen mevcut posta sunucusu tarafından desteklenmiyor. Belirtilen IP adresi "192.*.0.*" biçimindedir.',
    'mail__smtp_whitelist_mask_not_supported' => 'Joker IP desenleri seçilen mevcut posta sunucusu tarafından desteklenmiyor. Belirtilen IP adresi "192.0.0.0/8" biçimindedir.',

    'sfdk_server_wide_verify_failed' => 'DKIM doğrulama servisinin ayarları değiştirilemiyor',

    'sfdk_domain__serverwide_disabled' => 'Sunucu ilkesine göre kapalı',
    'feature__domainkeys__serverwide_disabled' => 'Sunucu çapında DKIM gereksiz posta koruması kapalı',

    'defaultcomponents__error_set_default' => '%1, varsayılan %2 olarak ayarlanamıyor',
    'defaultcomponents__error_set_default_none' => '%1 için varsayılan bileşen "hiçbiri" olarak belirlenemedi',
    'defaultcomponents__required_package_not_default' => 'Çalışması için gereken %1 bileşeni varsayılan değil.',

    '__percentage' => '%',
    '__seconds' => 'Saniye',
    '__resource_remain' => 'Kalan',

    '__not_registered' => '(kayıtlı değil)',
    '__php_handler_id' => 'PHP versiyonu',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP işleyicisi "%1" kayıtlı değil. Büyük olasılık sunucudan silinmiştir. Aynı özelliklerdeki bir işleyiciyi kaydedin ve yeniden deneyin.',
    '__php_handler_not_registered_on_domain' => 'Alan adı "%1": PHP işleyicisi "%2" kayıtlı değil. Büyük olasılık sunucudan silinmiştir. Aynı özelliklerdeki bir işleyiciyi kaydedin ve yeniden deneyin.',
    '__php_fpm_handler' => 'FPM uygulama',
    '__php_fpm-dedicated_handler' => 'Atanmış FPM uygulaması',

    'mailname_create_assigned_user_dublicate_error' => 'Posta kutusu için bir kullanıcı oluşturulamıyor.  Kullanıcı adı %1 olan kullanıcı zaten var ve onun başka bir posta kutusu var.',
    'mailname_create_assigned_user_role_absent_error' => 'Posta kutusu için bir kullanıcı oluşturulamıyor.  Kullanıcının varsayılan rolü %1 yok.',

    'gphd__mime_types' => 'MIME türleri',
    'gphd__handlers' => 'Apache işleyicileri',
    'gphd__ip_restrictions_allow' => 'Siteye (reddedilenler hariç) belirtilen ana bilgisayarlara ve ağlara erişim izni verin',
    'gphd__ip_restrictions_deny' => 'Belirtilen ana bilgisayarlar ve ağlar için siteye erişimi reddedin',
    'gphd__directory_index' => 'İndeks dosyaları',
    'gphd__nginx_transparent_mode' => 'nginx\'in HTTP taleplerini ve yanıtlarını değiştirmeden sadece geçirdiği Apache\'nin statik ve dinamik içeriği işlediği mod.',
    'gphd__nginx_serve_static' => 'Statik dosyalara doğrudan nginx ile servis sağlayın',
    'gphd__nginx_static_extensions' => 'Statik dosyaların uzantılarının nginx ile işlenmesi gerekir',
    'gphd__nginx_serve_php' => 'nginx ile PHP dosyalarını işleyin',
    'gphd__www_root' => 'WWW Kök Dizini',

    'eol__none' => 'değiştirmeyin',
    'eol__lf' => 'Unix stiline dönüştür',
    'eol__cr' => 'MacOS stiline dönüştür',
    'eol__crlf' => 'Windows stiline dönüştür',

    'ui__dns_bad_zone' => 'Tutarsız bölge "%1":',
    'ui__dns_ns_has_no_address_records' => '"%1" NS kaydının hiçbir adres kaydı yoktur (A veya AAAA).',
    '__dns_bad_zone' => 'Tutarsız bölge "%1":',
    '__dns_ns_has_no_address_records' => '"%1" NS kaydının hiçbir adres kaydı yoktur (A veya AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR kaydı "%1" geçersiz: Kayıt, bir joker alan adına işaret ediyor.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] \'%4\' müşterisinin \'%3\' veritabanı kullanıcısına uzaktan erişim izni verin',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => '\'%1\' veritabanı kullanıcısına uzaktan erişim izni verilemiyor: Microsoft SQL sunucusu \'%2\' tarafından kullanılan TCP bağlantı noktası numarası belirlenemiyor. Bunun nedenleri aşağıdakilerdir: Sunucu ağ yapılandırmasında TCP/IP iletişim kuralı etkinleştirilmemiş veya sunucu, dinamik TCP bağlantı noktalarını kullanmak üzere yapılandırılmış. Özel bir sabit TCP bağlantı noktasını dinlemek için sunucuyu yapılandırın ve uzaktan bağlantılara tekrar izin vermeyi deneyin.',

    'command__convertResellerHasCustomer' => '\'%1\' satıcı hesabının bir veya birden fazla müşteri hesabı vardır. Bu satıcı hesabını bir müşteri hesabına dönüştürmek için, önce bu müşteri hesaplarını yeni bir sahibe aktarın veya satıcı hesaplarına dönüştürün.',
    'command__convertResellerNotReseller' => 'Sadece satıcı hesapları müşteri hesaplarına dönüştürülebilir. \'%1\' bir satıcı değil.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Abonelik, servis planıyla senkronize edilemedi. Aboneliğin aşağıdaki ayarları, servis planıyla çakışıyor: %%problems%%.',

    'moveCustomer__wrong_customer_type' => '\'%1\' hesabı bir satıcı hesabı. Sunucu yöneticisine ait olduklarından, satıcı hesapları yeni bir sahibe taşınamaz.',
    'moveCustomer__wrong_owner_type' => "Müşteri hesabı '%1' sadece bir satıcıya veya yöneticiye taşınabilir, başka bir müşteriye taşınamaz.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Müşteri hesabı \'%1\' zaten seçilen sahibe ait.',
    'upgradeClient__user_is_admin' => 'Bu bir yönetici hesabı olduğundan, \'%1\' hesabı bir satıcı hesabına dönüştürülemiyor.',

    'mail__error_setting_max_connections_courier' => 'Maksimum bağlantı sayısı ayarlanamıyor (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3): %1',
    'mail__error_setting_max_connections_dovecot' => 'Maksimum bağlantı sayısı ayarlanamıyor (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'IP adresi başına maksimum bağlantı sayısı ayarlanamıyor (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3): %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Belli bir posta kullanıcısı için IP adresi başına maksimum bağlantı sayısı ayarlanamıyor (IMAP, POP3, SSL/TLS üzerinden IMAP veya SSL/TLS üzerinden POP3): %1',
    'outgoing_messages_limit_value_invalid' => 'Değerin %%MIN%%..%%MAX%% aralığında olması gerekir. Bu ayarı sadece Plesk yöneticisi ayarlayabilir.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Aşağıdaki alan adları, varolmayan adreslere gönderilen postalarda posta iletme için harici Eposta adreslerini kullanın. Bu adreslere gönderilen mesajlar, Giden Posta Kontrolünde sayılmaz:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Giden posta sınırları, IP adresleri posta sunucusunun beyaz listesinde bulunan posta gönderenleri için geçerli olmaz. Örneğin beyaz listede localhost (127.0.0.0 / 8, ::1 / 128) olduğunda, sınırlamalara bakılmaksızın, yerel sunucudaki tüm postalar başarıyla gönderilir. Posta gönderenleri, ya yerel (yerel sunucuda barındırılan web siteleri ve özel komut dosyaları), ya da harici IP adreslerini (bilgisayarlarına veya mobil cihazlarına kurulu posta istemcilerinden posta gönderen müşteriler) kullanabilir. Sınırların (hem yerel, hem de harici) tüm posta gönderenleri için geçerli olması için, beyaz listedeki tüm IP adreslerini ve ağları kaldırın. Beyaz listeden localhost\'un (127.0.0.0 / 8, ::1 / 128) kaldırılmasının, bu sunucudan posta gönderen web sitelerinin ve komut dosyalarının çalışmasını bozabileceğini unutmayın. Giden postadaki sınırlamalar hakkındaki ayrıntılar için, Yönetici Kılavuzunda, Giden Gereksiz Postadan Korunma altına bakın.',
    'outgoing_messages_relay_open' => 'Posta iletme açıktır: Giden posta sınırları geçerli olmaz.',

    'notification_aps_app_updates_available' => 'Aşağıdaki uygulamalar için güncellemeler kullanılabilir:',
    'notification_aps_app_updates_installed' => 'Güncellemeler, aşağıdaki uygulamalar için otomatik olarak yüklendi:',
    'notification_aps_app_updates_requirements' => 'Güncellemeler, aşağıdaki uygulamalar için kullanılabilir, ancak ilgili web sitelerinin barındırma ayarları kurulum koşullarını sağlamadığından dolayı yüklenemez:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) üzerindeki "%%name%%" eklentisi. Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) üzerinde "%%name%%" teması. Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) üzerindeki "%%name%%" eklentisi. Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) üzerinde "%%name%%" teması. Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Sürümünüz: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) üzerindeki "%%name%%" eklentisi. Sürümünüz: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) üzerinde "%%name%%" teması. Sürümünüz: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Yeni sürüm: %%to%%. Önceki sürüm: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Yeni sürüm: %%to%%. Önceki sürüm: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Yeni sürüm: %%to%%. Önceki sürüm: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Yüklü sürüm: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Sürümünüz: %%from%%. Kullanılabilir sürüm: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'harici uygulama',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Alan Adları',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-posta Adresleri',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonelik',
    'notification_outgoing_mail_exceeded_limits_limit_value' => 'saatte %1 mesaj',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Sınırsız',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, sınır %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%2 ile %3 arasında sınırları aşmak için %1 deneme',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%2 ile şimdi arasında sınırlarını aşmak için %1 deneme',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP Adresi Yasaklaması (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Fail2ban bileşeni, hedef sunucuda kurulmamış.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Fail2ban Kur. Bunun birkaç dakika süreceğini unutmayın.',

    'plesk_key__no_reseller_support' => 'Lisans sınırlamalarından dolayı satıcıları yönetemezsiniz.',
    'plesk_key__no_customers_support' => 'Lisans sınırlamalarından dolayı müşterileri yönetemezsiniz.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Lisans sınırlamaları nedeniyle Servis Sağlayıcısı görünümüne geçilemiyor.',
    'plesk_key__no_security_core_support' => 'Güvenlik çekirdeği özellikleri (ModSecurity ve Fail2Ban), lisans sınırlamalarından dolayı kullanılamaz.',
    'plesk_key__outgoing-antispam' => 'Giden Posta Kontrolü',
    'plesk_key__security-core' => 'Güvenlik Çekirdeği (ModSecurity ve Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Hesap yönetimi',
    'plesk_key__can-manage-subscriptions' => 'Abonelik yönetimi',
    'plesk_key__can-manage-customers' => 'Müşteri yönetimi',
    'plesk_key__can-manage-resellers' => 'Satıcı yönetimi',
    'plesk_key__can-manage-custom-view' => 'Sınırlı Mod kullanılabilirliği',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Abonelikler yönetimi kapalı, ancak birden fazla aboneliğiniz var (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Satıcı yönetimi kapalı, ancak birden fazla satıcınız var (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Müşteri yönetimi kapalı, ancak birden fazla müşteriniz var (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Plesk arayüzünde artık yönetemeyeceğiniz bazı abonelik kaynakları (posta kutuları ve alan adının disk alanındaki kısıtlamalar gibi) sınırsız olarak ayarlandı.',
    'plesk_key__no_subscriptions_support' => 'Lisans sınırlamalarından dolayı abonelikleri yönetemezsiniz.',
    'plesk_key__no_custom_view_support' => 'Lisans sınırlamalarından dolayı Sınırlı Modu kullanamazsınız.',
    'plesk_key__trial_forbidden_region' => 'Üzgünüz, Plesk şu an bölgenizde kullanılamıyor.',
    'additional_key__main_key' => 'Anahtar, bir ana anahtardır: Bir ana anahtarı bir ek anahtar olarak karşıya yükleyemezsiniz.',

    'gch__hosting_waf_rule_engine' => 'Web uygulamasının güvenlik duvarı modu',

    'backup__fieldset__restoration_options' => 'Geri yükleme seçenekleri',
    'backup__restore_options__restore' => 'Gerikur',
    'backup__restore_options__domain__domain_configuration' => 'Alan adı yapılandırması',
    'backup__restore_options__domain__virtual_host_content' => 'Sanal ana bilgisayar içeriği',
    'backup__restore_options__domain__mail' => 'Posta',
    'backup__restore_options__domain__databases' => 'Veritabanları',
    'backup__restore_options__client__client_configuration' => 'Müşteri hesabı yapılandırması',
    'backup__restore_options__client__domains' => "Müşteri alan adları",
    'backup__restore_options__reseller__reseller_configuration' => 'Satıcı hesabı yapılandırması',
    'backup__restore_options__reseller__personal_domains' => "Satıcının alan adları",
    'backup__restore_options__reseller__clients' => "Satıcı müşterileri",
    'backup__restore_options__admin__server_configuration' => 'Sunucu ayarları',
    'backup__restore_options__admin__administrator_configuration' => 'Yönetici hesabı yapılandırması',
    'backup__restore_options__admin__personal_domains' => "Yöneticinin alan adları",
    'backup__restore_options__admin__personal_clients' => "Yöneticinin müşterileri",
    'backup__restore_options__admin__resellers' => 'Satıcılar',

    'badge_new' => 'Yeni',
    'upgrade_php_on_subscription' => 'Aboneliğinizdeki PHP\'yi sürüm 5.3.0 ve üstüne yükseltin.',

    'pkey_notify__body_expiration_notification' => 'Lisans anahtarının süresi doldu. Bazı özellikler kullanılamaz. Barındırma sağlayıcınızla irtibata geçin.',

    'crontab__crontab_entry_exists' => "Planlanan görev zaten var.",
    'crontab__crontab_entry_not_exists' => "Planlanan görev yok.",
    'crontab__invalid_values_found' => "Yanlış parametre değerleri.",
    'crontab__cmd_max_len' => "Komut, %1 karakterden uzun olamaz.",

    'domain__domain_exists' => "'www' öneki ve aynı adı bulunan bir alan adı var: %1.%2.",
    'domain__subdomain_exists' => "'www' öneki ve aynı adı bulunan bir alt alan adı var: %1.%2.",
    'domain__dalias_exists' => "'www' öneki ve aynı adı bulunan bir takma alan adı var: %1.%2.",
    'domain__record_exists' => "%1.%2. ana bilgisayarına işaret eden bir DNS kaydı var.",

    'ip_addr__cannot_assign_certificate' => "'%1' sertifikası varsayılan olarak ayarlanamaz: özel anahtar eksik.",
    'ip_addr__update_dns_error' => 'IP adresi DNS bölgelerinde güncellenirken sorunlar oluştu. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'IP adresi eklenemiyor. Bu ağ arabirimi, IP adreslerini otomatik olarak alır.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'IP adresi %1 kaldırılamıyor. Bu ağ arabirimi, IP adreslerini otomatik olarak alır.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'IP adresi %1 onarılamıyor. Bu ağ arabirimi, IP adreslerini otomatik olarak alır.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Ağ arabirimi %2, IP adreslerini otomatik olarak aldığından, IP adresinin %1 arabirimi değiştirilemiyor.',

    'shm_lmsg__limit_for_resource_exceeded' => '%%type%% numarasındaki abonelik sınırı aşıldı. Sınır %%limit%% ve şu an %%usage%% kullanılıyor.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Bu abonelik için %%type%% oluşturulmasına izin verilmez.',
    'shm_lmsg__resource_title__db-mysql' => 'MariaDB/MySQL Veritabanları',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL Veritabanı',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL veritabanları',
    'shm_lmsg__resource_title__db-user' => 'veritabanı kullanıcıları',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS uygulama havuzları',
    'shm_lmsg__resource_title__additional-ftp-account' => 'ek FTP hesapları',

    'db_user_unable_remove_mysql_global_privileges' => 'Veritabanı kullanıcısı %1\'in MariaDB/MySQL küresel ayrıcalıkları kaldırılamıyor. Nedeni: %2',
    'report__client_description' => 'Tanım',

    'db__user_role_error' => 'Yanlış veritabanı kullanıcısının rolü belirtildi: %1. Lütfen aşağıdaki rollerden birini seçin: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Daha büyük bir dosya boyutları olduğundan, aşağıdaki Microsoft SQL Server veritabanları için dosya boyut sınırı ayarlanamıyor: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Daha büyük bir günlük dosya boyutları olduğundan, aşağıdaki Microsoft SQL Server veritabanları için günlük dosya boyut sınırı ayarlanamıyor: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Bir genel IP adresi ayarlanamıyor: kişisel bir IP adresinin bulunması gerekir.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'IPv6 adresi için bir genel IPv4 adresi ayarlanamıyor.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'IPv4 adresi için bir genel IPv6 adresi ayarlanamıyor.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Bir genel IP adresi ayarlanamıyor: Geçersiz IP adresi.',

    '__user_already_exists' => "Kullanıcı %1 sistemde mevcut.",
    '__user_name_is_empty' => "Lütfen bir kullanıcı adı belirtin.",

    'upgrade_php_on_domain' => 'WordPress alan adlarınızın herhangi birinde PHP sürümü 5.3.0 veya üstü bulunamadı. PHP\'yi yükseltmeyi deneyin.',

    'component_name__waf' => 'Web Uygulamasının Güvenlik Duvarı',
    'component_name__vcs' => 'Sürüm Kontrol Sistemi',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Olası bir hile denemesi algılandı: Bağlantı, ilgisiz içeriği görüntülemeyi denedi.',
    'forceResetPasswordUpdated' => 'Şifreniz değişti. Plesk\'e giriş yapmak için yeni şifrenizi kullanın.',

    'php_handlers_error_no_available_instance' => 'Bir alan adı oluşturulamıyor: kullanılabilir PHP işleyicisi yok.',
    'domain_error_unable_to_apply_hosting_settings' => 'Barındırma ayarları ayarlanamıyor: %1',

    'plesk_not_configured' => 'Plesk yapılandırılmamış. Kurulum sonrası yapılandırmayı gerçekleştirmek için, denetim masasına gidin.',
    'cmd_mail__mail_password_duplicated' => 'Belirtilen e-posta adresiyle parola çifti, posta sunucusunda zaten var. Lütfen başka bir e-posta adresi veya parola belirtin.',

    'extensionRequirementOs' => 'İşletim sistemi (%1), paket tarafından desteklenmiyor.',
    'extensionRequirementPleskMinVersion' => 'Paketin desteklediği ilk sürüm, Plesk %1.',
    'extensionRequirementPleskMaxVersion' => 'Plesk %1 ile başlayan sürümler, paket tarafından desteklenmiyor.',
    'extensionBlacklisted' => 'Kurulumda %1 uzantısının kullanılmasına izin verilmiyor.',
    'extensionDisabled' => 'Uzantı devre dışı bırakılır.',


    'optimization_settings__unable_set_mpm_event' => 'mpm_event modu ayarlanamadı: Apache PHP5 modülünün kapalı olmasını gerektiriyor, ancak bu modül, alan adları tarafından kullanılıyor.',
    'optimization_settings__unable_turn_off_php' => 'Apache PHP5 modülü kapatılamıyor: alan adları tarafından kullanılıyor.',

    'hst_def__fp_admin_login' =>  'FTP kullanıcı adı',
    'hst_def__fp_admin_passwd' =>  'FTP şifresi',

    'database_user_orphaned_old_password_wrong' => "Yalnız bırakılmış kullanıcı '%1' onarılamıyor: parola yanlış.",
    'cannot_load_partner_central_property_key_no_exist' => "Özel özellikler alınamıyor: lisans anahtarı yok.",
    'extensionScriptFailure' => "%1'i gerçekleştirme başarısız oldu ve aşağıdaki mesajı verdi:\n%3",
    '__ssl_redirect' => "HTTP'den HTTPS'ye sabit SEO güvenli 301 yeniden yönlendirmesi",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM yönetimi desteklenmiyor.',
    'mail__dmarc_not_supported' => 'DMARC yönetimi desteklenmiyor.',
    'mail__relay_white_list_not_supported' => 'Röle beyaz listesi yönetimi desteklenmiyor.',
    'mail__black_list_not_supported' => 'Kara liste yönetimi desteklenmiyor.',
    'mail__autoresponder_not_supported' => 'Otomatik yanıtlama yönetimi desteklenmiyor.',
    'mail__autoresponder_message_subject' => 'Otomatik yanıt',
    'defaultcomponents__not_supported_version' => '(sürüm desteklenmiyor)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => '\'%1\' sertifikası bulunamadı.',
    'certificate__unable_setup_certificate' => 'Sertifika kurulamıyor: Özel anahtar ve sertifika içeriği eksik.',
    'certificate__used_by_panel' => 'Sileceğiniz sertifikalardan biri, Plesk\'i emniyete almak için kullanılıyor.',
    'certificate__used_by_mail_server' => 'Sileceğiniz sertifikalardan biri, posta sunucusunu emniyete almak için kullanılıyor.',
    'certificate__used_by_domain_service' => 'Sileceğiniz sertifikalardan biri, alan adı hizmeti tarafından kullanılıyor.',
    'mail_server__not_installed' => 'Posta sunucusu yüklü olmadığından, posta sunucusunun sertifikası yüklenemiyor.',

    'email_activation_mail_subject' => 'Lütfen Plesk\'teki hesabınızı etkinleştirin',
    'email_activation_mail_body' => "Plesk sunucusu %1 üzerinde bir hesap oluşturuldu \n\nHesap ayrıntıları: \nAdı: %2 \nE-posta adresi: %3 \n\nBu bilgiler doğruysa ve hesap, sizin için oluşturulduysa, lütfen onu aşağıdaki bağlantıdan etkinleştirin: \n\n%4 \n\nHesabı etkinleştirdiğinizde sunucu sahibine, yürürlükte olan geçerli veri koruma yasasına uygun olarak ve bir sözleşmenin bir parçası olarak, hesabınızı oluşturmak ve desteklemek için kişisel verilerinizi (adınızı ve e-postanızı) toplama, saklama, işleme ve kullanma yetkisi vermiş oluyorsunuz.",

    'backup_transport_permission_name' => '%1 yönetimi',
    'backup_transport_permission_description' => 'Yedeklemeleri saklamak için %1 kullanmanıza izin verir.',

    'domain_move_err_target_no_hosting' => 'Alan adı, barındırmasız bir aboneliğe taşınamıyor.',
    'domain_move_err_already_in_target' => 'Alan adı zaten hedef aboneliğe ait.',
    'domain_move_err_main_domain' => 'Ana alan adı taşınamaz.',
    'domain_move_err_subdomain_without_parent' => 'Üst alan adı %2 olmadan alt alan adı %1 taşınamıyor.',
    'domain_move_err_root_exists' => 'www_kök %1\'in hedef yolu zaten var.',
    'domain_move_err_nested_roots' => 'Belge kökünü başka bir alan adıyla paylaştığından, alan adı taşınamıyor: %1.',
    'domain_move_err_no_mail_service' => 'Posta hizmeti hedef abonelikte devre dışı bırakıldığından, alan adı taşınamıyor.',
    'domain_move_err_app' => "%1 üzerinde yüklü olan uygulama, '%2' aboneliğine taşınmadı: %3",
    'domain_move_database_used_by_app' => "%2 üzerindeki veritabanı '%1', taşınan uygulama tarafından kullanılıyor. Veritabanını '%3'ye tekrar atamak için, `plesk bin database --assign-to-subscription` komutunu çalıştırın",
    'domain_move_target_locked' => "Hedef abonelik '%1', senkronizasyon için kilitlendi.",
    'domain_move_filesharing_disabled' => 'Dosya paylaşma devre dışı bırakıldı.',
    'domain_move_website_preview_disabled' => 'Web sitesi ön izlemesi devre dışı bırakıldı.',
    'domain_move_additional_webserver_settings' => "Bozuk yapılandırmayı önlemek için, alan adının ek web sunucusu direktiflerini inceleyin.",
    'domain_move_no_permission' => "'%2' aboneliği için %1 yasaktır.",
    'domain_move_no_access' => "'%1' aboneliğine erişim yok.",
    'domain_split_no_create_permission' => "Alan adı oluşturmak yasaktır.",
    'domain_split_empty_login' => 'Sistem kullanıcısının oturum adı gerekir.',
    'domain_split_empty_password' => 'Sistem kullanıcısının parolası gerekir.',
    'domain_split_err_home_exists' => 'Alan adı %1 taşınamıyor, çünkü %2 üzerinde hedef başlangıç yolu zaten var. Yeni bir aboneliğe taşımak için alan adını yeniden adlandırın.',
    'domain_split_err_no_hosting_subdomains' => 'Alan adında barındırma olmayıp, alt alan adları olduğundan, alan adı yeni bir aboneliğe taşınamıyor. Alan adını taşımak için, "Barındırma tipi" değerini (Barındırma Ayarlarından) "Web sitesi barındırma" olarak değiştirin.',
    'domain_split_target_locked' => "Hedef abonelik '%1', senkronizasyon için kilitlendi.",
    'domain_split_target_unsynced' => "Hedef abonelik '%1', aşağıdaki nedenle planla senkronize edilmedi: %2.",
    'domain_merge_scheduled_backup_deactivated' => "'%1' üzerinde planlanan yedekleme devre dışı bırakıldı.",
    'domain_merge_database_error' => "%2 üzerindeki veritabanı '%1', '%3' aboneliğine taşınmadı: %4",
    'domain_merge_anon_ftp_deactivated' => "'%1' üzerindeki anonim FTP kapanmış.",
    'domain_merge_smb_user_access' => "Ek kullanıcı '%1', '%2' aboneliğine taşındı, ancak kullanıcının aboneliğe olan erişimi kaldırıldı.",
    'domain_merge_scheduled_tasks' => "Planlanan görevler, hedef aboneliğe taşındı. Görevlerin yapılandırmasını inceleyin.",
    'domain_merge_scheduled_tasks_deactivated' => "Planlanan görevler, hedef aboneliğe taşındı ve devre dışı bırakıldı. Görevlerin yapılandırmasını inceleyin.",
    'domain_merge_no_remove_permission' => "Abonelikleri kaldırmaya izin verilmiyor.",
    'domain_merge_err_has_addons' => 'Ana alan adı ek alan adlarıyla taşınamıyor; önce %1 alan ad(lar)ını taşıyın.',
    'domain_merge_err_has_webusers' => 'Ana alan adı, web kullanıcılarıyla taşınamıyor.',
    'domain_merge_err_root_exists' => 'Hedef yolu %1 zaten var.',

    'database_server_edit_used_for_psa' => 'Yerel MariaDB/MySQL veri tabanı sunucusunun kullanılmasına izin verilmez.',
    'suggest_repair_main_suggestion_ui' => '<b>Bu hatayı "Plesk tamir" özelliğini</b> kullanarak düzeltebilirsiniz.',
    'suggest_repair_main_suggestion_cli' =>  '"Plesk tamir" özelliğini kullanarak bu hatayı düzeltebilirsiniz.',
    'suggest_repair_repair_kit_link_title' => 'Tanımla ve Onar\'a git',
    'suggest_repair_using_cli_and_ui' => 'Bunu yapmak için ya CLI ve %2 ile "plesk repair %1" komutunu girin ya da "Plesk Veri Tabanı" yanındaki Onar\'a basın.',
    'suggest_repair_using_cli' => 'Bunu yapmak için CLI ile "plesk repair %1" komutunu girin',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Yedek oluşturulduğunda DNS hizmeti kullanılamıyordu. Ancak, yedekte etkin DNS bölgeleri var ve şu nesneler için etkinleştirilecekler: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Kaynak Kontrol Birimi (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Uzaktan SmarterMail desteği',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(lisans anahtarı tarafından izin verilmez)',
    'plesk_key__validation_failed' => '%1 (Hata kodu: %2)',
    'promo__button_details' => 'Detaylar',
    'promo__extension_catalog_title' => 'Uzantı Katalogu',
    'promo__extension_catalog_description' => 'Yeni uzantı kataloğunu inceleyin ve çeşitli güçlü uzantılarla Plesk\'inize güç katın!',
    'promo__button_open_catalog' => 'Katalogu aç',

    'backup__repository_check_login' => "Depolama birimine erişilemiyor: %1 Doğru depolama bilgilerini girdiğinizden emin olun.",
    'backup__repository_check_error_list' => "Depolama birimine erişilemiyor: %1 Doğru depolama ayarlarını girdiğinizden emin olun.",
    'backup__repository_check_error_mkdir' => "Dizin oluşturulamıyor: %1 Depolama biriminde klasör oluşturma izniniz olup olmadığını kontrol edin.",
    'backup__repository_check_error_upload' => "Dosya depolama birimine yüklenemiyor: %1 Depolama birimine dosya yükleme izniniz olup olmadığını kontrol edin.",
    'backup__repository_check_error_download' => "Dosya depolama biriminden indirilemiyor: %1 Depolama biriminden dosya indirme ve yükleme izniniz olup olmadığını kontrol edin.",
    'backup__repository_check_error_resume-upload' => "Dosyanın depolama birimine yüklenmesine devam edilemiyor: %1 Depolama birimine dosya yüklemeye devam etme izniniz olup olmadığını kontrol edin.",
    'backup__repository_check_error_resume-download' => "Dosyanın depolama biriminden indirilmesine devam edilemiyor: %1 Depolama biriminden dosya indirmeye devam etme izniniz olup olmadığını kontrol edin.",
    'backup__repository_check_error_enable-utf8' => "Depolama birimi çalıştırılamıyor: %1 Depolama biriminin UTF8 kodlamasını destekleyip desteklemediğini kontrol edin.",
    'backup__repository_check_error_rm' => "Depolama birimi çalıştırılamıyor: %1 Depolama biriminden dosya silme izniniz olup olmadığını kontrol edin.",
    'backup__repository_check_error_rmdir' => "Depolama birimi çalıştırılamıyor: %1 Depolama biriminden klasör silme izniniz olup olmadığını kontrol edin.",

    'backup__ftp_repository_check_login' => "%1 Onları bağımsız olarak komutla kontrol edebilirsiniz : %2",
    'backup__ftp_repository_check_error_list' => "%1 Onları bağımsız olarak komutla kontrol edebilirsiniz : %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Onu bağımsız olarak komutla kontrol edebilirsiniz : %2",
    'backup__ftp_repository_check_error_upload' => "%1 Onu bağımsız olarak komutlarla kontrol edebilirsiniz : %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Onu bağımsız olarak komutlarla kontrol edebilirsiniz : %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Onu bağımsız olarak komutlarla kontrol edebilirsiniz : %2 %3%4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Onu bağımsız olarak komutlarla kontrol edebilirsiniz : %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Onu bağımsız olarak komutla kontrol edebilirsiniz : %2",
    'backup__ftp_repository_check_error_rm' => "%1 Onu bağımsız olarak komutlarla kontrol edebilirsiniz : %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Onu bağımsız olarak komutlarla kontrol edebilirsiniz : %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'DMARC için ayarlar değiştirilemiyor. Bu seçeneği etkinleştirmek için lütfen DKIM ve SPF gereksiz posta korumasını açın.',
    'spf_server_wide_disable_failed' => 'SPF gereksiz posta koruması için ayarlar değiştirilemiyor. SPF\'yi devre dışı bırakmak için lütfen gelen postalar için DMARC\'yi kapatın.',
    'sfdk_server_wide_verify_disable_failed' => 'DKIM gereksiz posta koruması için ayarlar değiştirilemiyor. DKIM\'yi devre dışı bırakmak için lütfen gelen postalar için DMARC\'yi kapatın.',

    'ccs_not_supported' => 'IIS Merkezi Sertifika Deposu, sistemde yapılandırılmamış.',
    'ccs_not_enabled' => 'IIS Merkezi Sertifika Deposu yönetimi Plesk\'te etkinleştirilmemiş.',
    'ad_not_supported' => 'Sunucu bir alan adına katılmamış.',

    'component_name__appinit' => "Uygulama Başlatma",
    'component_name__cors' => "Kökenler Arası Kaynak Paylaşımı",
    'component_name__httpcompression' => 'HTTP İçerik Sıkıştırma',
    'common_feature_is_not_supported' => 'Bu özellik artık desteklenmiyor.',
    'common_feature_is_not_supported_in_proto' => 'Bu özellik %1 protokol sürümü için desteklenmiyor.',
    'autoinstaller__plesk_component' => 'Plesk bileşeni',
    'plesk_key__key_expired' => 'Lisans anahtarınızın süresi doldu. Plesk\'i kullanmaya devam etmek için %1.',
    'plesk_key__key_purchase' => 'yeni bir lisans satın alın',
    'plesk_key__key_expired_period' => 'Lisans anahtarınızın süresi %1 günden daha uzun bir süre önce doldu.',

    'sa_action_move' => 'Gereksiz postaları "Önemsiz e-posta" klasörüne taşıyın',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java uygulamaları artık desteklenmiyor. Aşağıdaki internet siteleri için kullanılamaz: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'UNITY Mobile ile barındırılan internet sitelerinin mobil sürümleri artık desteklenmiyor. Aşağıdaki internet siteleri için kullanılamaz: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Sunucu genişliği kullanım politikası kişisel antivirüs ayarlarının kullanılmasına izin vermiyor. Şu alan adlarındaki e-posta hesapları için eksik olarak geri yüklenecek: {{objects}}',

    'module__not_installed' => "%1 uzantısı yüklü değil",

    'mail__mail_autodiscovery_server_error' => 'Otomatik posta bulma için özel bir alan adı belirtin',
    'mail__error_mail_autodiscovery_enable' => 'Otomatik posta bulma etkinleştirilemiyor: %1',
    'mail__error_mail_autodiscovery_server' => 'Otomatik posta bulma için özel bir alan adı ayarlanamıyor: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Alan adları otomatik olarak keşfedilen DNS kayıtlarını yeniden yapılandıramıyor: %1',

    'mail__smarthost_not_configured_error' => 'Bir smarthost yapılandırılmadı.',
    'mail__smarthost_attach_domains_error' => 'Alan adlarının smarthost\'a eklenmesi hatalarla tamamlandı:',

    '__invalid_url' => '"%1" URL\'si geçersiz',
    'actionlog__cloning_start' => 'başlat',
    'actionlog__event_cloning_start' => 'Sunucu klonlama başlangıcı',

    '__UPLOAD_ERR_FORM_SIZE' => "Yüklenen dosya izin verilen boyuttan büyük",
    '__UPLOAD_ERR_INI_SIZE' => "Yüklenen dosya izin verilen boyuttan büyük",
    '__UPLOAD_ERR_NO_FILE' => "Alınan dosya yok",
    '__UPLOAD_ERR_OK' => "Dosya başarıyla yüklendi",
    '__UPLOAD_ERR_PARTIAL' => "Dosya kısmen yüklendi, lütfen tekrar deneyiniz",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Geçici klasör eksik',
    '__UPLOAD_ERR_CANT_WRITE' => 'Dosyanın diske yazılması başarısız',
    '__UPLOAD_ERR_UNKNOWN' => 'Bilinmeyen bir dosyayı karşıya yükleme hatası oluştu',
    '__accounts' => "Hesaplar",
    '__access' => "Erişim",
    '__address' => "Adres",
    '__addresses' => "Adresler",
    '__acl_records' => 'ACL Kayıtları',
    '__admin_repository' => "Yönetici deposu",
    '__all' => 'Hepsi',
    '__allowed' => "İzin verildi",
    '__anonftp_status' => "Anonim FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 web sunucusu yeniden başlatılıyor, lütfen bekleyin...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET desteği",
    '__asp_win_support' => "Microsoft ASP desteği",
    '__attachments' => "Eklentiler",
    '__attachments_list' => "Eklentiler",
    '__author' => 'Oluşturan',
    '__autoresp_name_already_exists' => "Adı %1 olan bir otomatik yanıt zaten var.",
    '__autoresponder' => "Otomatik yanıt",
    '__autoresponders' => "Otomatik yanıtlar",
    '__autoresponders_list' => "Otomatik yanıtlar",
    '__autoresponder_attachment_files' => "Otomatik Yanıt Eklenti Dosyaları",
    '__auto_updates_list' => 'Kullanılabilir Güncellemeler',
    '__backup_utilites' => "Yedekleme araçları",
    '__bind_status' => "DNS Sunucusu durumu",
    '__bu_is_not_installed' => "Bu servis şu an çalışmıyor : yedekleme modülleri kurulu değil.",
    '__bu_not_support_in_key' => "Yedekleme özelliği mevcut lisansınız tarafından desteklenmiyor.",
    '__notifications_not_support_in_key' => 'Bildirimler, lisans anahtarı tarafından desteklenmez',
    'disabled_by_key' => 'Lisans anahtarı tarafından desteklenmiyor',
    '__bytes' => "bayt",
    '__can_not_use_reserved_words' => "Rezerve edilmiş kelimeler kullanılamaz.",
    '__certificate' => "Sertifika",
    '__cgi_support' => "CGI desteği",
    '__city' => "Şehir",
    '__cl_not_exist' => "Müşteri hesabı yok.",
    '__client' => 'Müşteri',
    '__client_card' => "Müşteri kartı",
    '__client_contact_name' => "Müşteri kişi adı",
    '__client_form' => "Kişisel bilgiler",
    '__client_ip_pool' => "Müşterinin IP havuzu",
    '__client_limits' => "Müşteri hesabının sınırları",
    '__client_permissions' => "Müşteri izinleri",
    '__client_preferences' => "Müşterinin tercihleri",
    '__client_status' => "Müşteri durumu",
    '__client_total' => "Müşteri Toplamı",
    '__client_with_login_name_already_exists' => "Kullanıcı adı _\"%1_\" olan bir kullanıcı zaten var.",
    '__client_domuser_with_login_already_exists' => "Kullanıcı adı '%1' zaten etki alanı '%1' yöneticisi tarafından kullanımda.",
    '__clients_global_changes' => "Seçilen müşteri hesaplarını değiştirin",
    '__cmd_not_found' => "Tanımsız komut: %1",
    '__comments' => "Yorumlar",
    '__component_version' => "Modül versiyonu",
    '__component_not_installed' => "Bileşen %1 yüklenmedi",
    '__confirm_overwrite' => "Üzerine yazmayı onaylayın.",
    '__confirm_stop' => "İşlemi durdurmayı onaylamanız gerekir.",
    '__confirm_passwd' => "%1 şifresini onaylayın",
    '__conhelp' => "Tanım",
    '__contact_name' => "İrtibat adı",
    '__country' => "Ülke",
    '__countries' => 'Ülke',
    '__country_unknown' => 'Ülkenin alt kodu tanınamıyor.',
    '__courier-imap' => 'Kurye sunucusu',
    '__create_domain' => 'Alan adı oluşturun',
    '__crypted' => 'şifrelenmiş',
    '__cp_access' => "Plesk'e erişim",
    '__cp_user' => "Plesk Kullanıcısı",
    '__create' => "Oluştur",
    '__create_client_template_without_template' => "Şablonsuz kullanıcı hesabı oluşturun",
    '__create_domain_for' => "<b>%1</b> için bir alan adı oluşturun",
    '__create_domain_template_without_template' => "Şablonsuz alan adı oluşturun",
    '__creation_date' => "Oluşturulma tarihi",
    '__crontab_unix' => "Zamanlayıcı",
    '__crontab_win' => "Zamanlayıcı",
    '__ct_month_jan' => 'Ocak',
    '__ct_month_feb' => 'Şubat',
    '__ct_month_mar' => 'Mart',
    '__ct_month_apr' => 'Nisan',
    '__ct_month_may' => 'May.',
    '__ct_month_jun' => 'Haziran',
    '__ct_month_jul' => 'Temmuz',
    '__ct_month_aug' => 'Ağustos',
    '__ct_month_sep' => 'Eylül',
    '__ct_month_oct' => 'Ekim',
    '__ct_month_nov' => 'Kasım',
    '__ct_month_dec' => 'Aralık',
    '__custom_button' => "Özel Button",
    '__custom_buttons_list' => "Ek servislerin bağlantıları",
    '__daily' => "Günlük",
    '__database_not_activated' => "%1 sunucu yönetim panelinde aktif değil.",
    '__database_not_installed' => "Veritabanı %1 kurulu değil.",
    '__database_not_run' => "Veritabanı %1 çalışmıyor.",
    '__database_is_corrupt' => "Plesk'in veritabanı bozulmuş. Düzeltmek için lütfen Yeniden yapılandırıcı programını başlatın.",
    '__databases' => "Veritabanları",
    '__databases_list' => "Veritabanları",
    '__database_type_not_supported_by_key' => '%1 sunucusunu kullanmak için, onun için lisans anahtarınızda destek olması gerekir. Lütfen Plesk satış temsilcinize danışın.',
    '__date_immediately' => "bugün",
    '__date_never' => "asla",
    '__day(s)' => "Gün(ler)",
    '__day0' => "Paz",
    '__day1' => "Pzt",
    '__day2' => "Sal",
    '__day3' => "Çrş",
    '__day4' => "Prş",
    '__day5' => "Cum",
    '__day6' => "Cmt",
    '__days' => "%1 Gün(ler)",
    '__db_admin_login_empty' => "Boş bir kullanıcı adı girerek, arayüzde %1 üzerinden kontrolü kapattınız. Devam etmek istiyor musunuz?",
    '__db_unable_to_unregister' => 'Veritabanı bağlantı parametreleri silinemiyor',
    '__db_db_exists' => 'Sunucuda en az bir veritabanı var',
    '__db_unable_to_change_server_name' => 'Sunucu adı değiştirilemez',
    '__db_unable_to_change_port' => 'Sunucu portu değiştirilemez',
    '__db_already_exist' => "Veritabanı %1 sistemde mevcut.",
    '__db_credentials_invalid' => "Veritabanı yetkileri doğru değil.",
    '__db_invalid_password_characters' => 'Şifre geçersiz karakterler içeriyor',
    '__db_engine' => "Veritabanı motoru", // indirect
    '__db_type' => "Veritabanı tipi",
    '__db_user' => "Veritabanı kullanıcısı",
    '__db_server' => 'Veritabanı Sunucusu',
    '__def_domain' => "Varsayılan alan adı",
    '__default_for_mysql' => 'MySQL için seçili',
    '__default_for_mariadb' => 'MariaDB için varsayılan',
    '__default_for_percona' => 'Percona için varsayılan',
    '__default_for_postgresql' => 'PostgreSQL için varsayılan',
    '__delete' => "Sil",
    '__demo' => "Bu işlev deneme sürümünde kullanılamaz.",
    '__directory' => "Dizin",
    '__disable_lock_screen' => 'Kullanıcıların arayüz ekranlarının yüklenmesi tamamlanmadan önce Plesk\'te çalışmasını önleyin',
    '__dismiss_news?' => "Haber bloğunu tamamen kapatmak istediğinizden emin misiniz?\n\n Başka haber kullanılabilir hale gelmeden önce, haber bloğunu göremezsiniz.",
    '__description' => "Tanım",
    '__disabled' => "kapalı",
    '__disk_space_limit' => "Disk alanı kullanım limiti",
    '__cgroups_cpu_usage_limit' => 'İşlemci kullanım sınırı',
    '__cgroups_ram_usage_limit' => 'Bellek kullanım sınırı',
    '__cgroups_disk_read_usage_limit' => 'Disk Okuma Bant Genişliği sınırı',
    '__cgroups_disk_write_usage_limit' => 'Disk Yazma Bant Genişliği sınırı',
    '__disk_usage_by' => "Disk alanı kullanımı %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS kaydı '%1' sistemde mevcut.",
    '__dns_master_should_be_remote' => "Ayrı hostlarda iki farklı yetkili isim sunucunuz olmalı",
    '__dns_record_not_exist' => "DNS kaydı mevcut değil.",
    '__dns_server' => "DNS Sunucusu", // indirect
    '__dom_id_is_undefined' => "Alan adı kimliği tanımlanmamış.",
    '__dom_name' => "Alan adı",
    '__dom_name_is_invalid' => "Alan adı geçersiz. Lütfen alan adınızın sadece alfasayısal, nokta ve çizgi simgelerinden oluştuğundan ve uzunluğu 255 simgeden fazla olmadığından emin olun. Noktaların arasındaki alan adının her parçası, 63 simgeden fazla olmamalıdır.",
    '__dom_not_exist' => "Alan adı yok.",
    '__domain' => "Alan Adı",
    '__domain_' => 'Alan adı %1',
    '__domain_form' => "Alan adı formu",
    '__domain_id' => "Alan adı kimliği",
    '__domain_is_turned_off_for_backup' => "Web sitesi %1, yedekleme ve geri yükleme için geçici olarak kapandı ve şu an kullanılamıyor.",
    '__domain_limits' => "Alan adı sınırları",
    '__domain_name' => "Alan adı",
    '__mail_name_in_ASCII_form' => "ASCII biçiminde posta hesabı adı",
    '__message_error' => 'Hata',
    '__message_warning' => 'Uyarı',
    '__message_info' => 'Danışma',
    '__domain_name_in_ASCII_form' => "ASCII biçiminde alan adı",
    '__domain_repository' => "%1 alan adının deposu",
    '__domain_status' => "Alan adı durumu",
    '__domain_found_tech' => "Alan adında bulunan teknoloji",
    '__domain_dns' => 'Alan adı DNS bölgesi',
    '__domain_total_powerUser' => "Toplam abonelik miktarı",
    '__domain_user' => "Alan adı yöneticisi",
    '__domains_global_changes' => "Seçilen alan adlarını değiştirin",
    '__mailnames_global_changes' => "Seçilen posta hesaplarını değiştirin",
    '__backup_manager' => 'Yedekleme Yöneticisi',
    '__domains_list' => "Alan Adları",
    'domains_list__list_header' => "alan adları",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "WWW öneki kullanılmış olmasına rağmen, alan adı www ile başlar.\nYine de devam edilsin mi?",
    '__dovecot' => 'Dovecot IMAP ve POP3 sunucusu',
    '__dsmail' => "Posta servisi",
    '__dsmaillist' => "Mailing listesiesi servisi",
    '__dumps_tot_size' => "Yerel depodaki yedekleme dosyalarının toplam boyutu",
    '__email' => "E-posta",
    '__email_addr_is_invalid' => "E-posta adresi geçersiz.",
    '__enabled' => "açık",
    '__enter_cert_text' => "Sertifika metnini giriniz",
    '__enter_size' => "Boyut girin",
    '__exclusive' => "Atanmış",
    '__expiration_date' => "Son kullanım tarihi",
    '__fax' => "Faks",
    '__file' => "Dosya",
    '__file_is_empty' => "Dosya boş.",
    '__file_name' => "Dosya adı",
    '__file_type' => 'Dosya tipi',
    '__filemanager' => "Dosya Yöneticisi",
    '__filepath_is_empty' => "Dosya yolu boş",
    '__files_list' => "Dosyalar",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP ayarları",
    '__ftp_serv' => "FTP Sunucusu", // indirect
    '__ftp_server_parameters_are_empty' => "Önce FTP hesabı özelliklerini ayarlamanız gerekir!",
    '__ftp_status' => "FTP Sunucusu durumu",
    '__full_day0' => "Pazar",
    '__full_day1' => "Pazartesi",
    '__full_day2' => "Salı",
    '__full_day3' => "Çarşamba",
    '__full_day4' => "Perşembe",
    '__full_day5' => "Cuma",
    '__full_day6' => "Cumartesi",
    '__full_month1' => "Ocak",
    '__full_month10' => "Ekim",
    '__full_month11' => "Kasım",
    '__full_month12' => "Aralık",
    '__full_month2' => "Şubat",
    '__full_month3' => "Mart",
    '__full_month4' => "Nisan",
    '__full_month5' => "May.",
    '__full_month6' => "Haziran",
    '__full_month7' => "Temmuz",
    '__full_month8' => "Ağustos",
    '__full_month9' => "Eylül",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Hard Disk kotası",
    '__hard_disk_quota_not_supported' => 'sabit disk kotası, sunucu dosya sisteminin yapılandırmasından dolayı desteklenmiyor',
    '__help_topic_not_found' => 'Talep ettiğiniz yardım başlığı (%1)bulunamadı.',
    '__hosting_ip_dns_ip_not_equiv' => "DNS adres(A) kayıtlarındaki IP adreslerinin hiçbiri hosting için kullanılmamaktadır",
    '__hosting_scripting' => "Barındırma scripting desteği",
    '__hosting_setup_page_title' => "%1 alan adı için web barındırma ayarı",
    '__hosting_title' => "Barındırma (%1)",
    '__hosting_type' => "Barındırma tipi",
    '__hostname_is_empty' => "İstemci adı boş.",
    '__hour(s)' => 'Saat',
    '__hst_type_incorrect' => "Barındıma tipi geçersiz.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "İşlemsizlik süresi",
    '__iface' => "Arayüz",
    '__image' => "İmaj",
    '__imap_status' => "IMAP Sunucusu durumu",
    '__incorrect_databases_login_pass' => "PostgreSQL erişimi için atadığınız değerler doğru değil.",
    '__incorrect_ip_or_network_address' => 'Yanlış IP adresi veya ağı.',
    '__info' => 'Bilgi',
    '__install' => "Kur",
    '__install_prefix' => "Uzantıyı kur",
    '__invalid_cert_id' => "Sertifika id si geçersiz",
    '__invalid_context' => "Geçersiz kontekst: %1",
    '__invalid_db_usr_name' => "Veritabanı kullanıcı adı geçersiz.",
    '__invalid_dir_name' => "Dizin adı geçersiz",
    '__invalid_dom_name' => "Alan adı geçersiz.",
    '__invalid_filename' => "Geçersiz dosya adı. Tek tırnak işareti ve/veya _\"../_\" kombinasyonunu kullanmayın.",
    '__invalid_id' => "Geçersiz tanımlayıcı.",
    '__invalid_lines_num' => "Geçersiz sayısal değer, sadece rakkam kullanınız.",
    '__invalid_max_letter_size' => "Maksimum mesaj boyutu geçersiz.",
    '__invalid_restart_apache_interval' => "Apache için yeniden başlatma zaman aralığı geçerli değil",
    '__invalid_tmpl_name' => "Şablon adı geçerli değil.",
    '__invalid_value' => "Yanlış değer.",
    '__ip_addr' => "IP adresi",
    '__ip_address_and_mask' => "IP Adresi ve Alt Ağ Maskesi",
    '__ip_alias__mask' => "IP Adresi ve Alt Ağ Maskesi",
    '__ip_addr_is_invalid' => "IP adresi geçerli değil.",
    '__ip_addr_list' => "IP Adresleri",
    '__ip_address_and_mask_hint' => 'Örneğin %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/saniye",
    '__kbytes' => "Kilobayt",
    '__key_for_virtuozzo_only' => "Lisans anahtarınız ancak Virtuozzo containers'ta kullanılmak için tasarlanmıştır.",
    '__key_limits_exceeding' => "Bu eylem, yazılım lisansınızın tanımladığı sınırları aşıyor.  Bu mesajı aldığınızda, bu lisansın sınırlarını netleştirmek veya genişletmek için sağlayıcınız veya üreticiyle irtibata geçebilirsiniz.",
    '__kilo' => "K",
    '__keywords' => 'Anahtar kelimeler',
    '__lang_unknown' => 'Dil tanınamıyor.',
    '__languages' => 'Dil',
    '__learn_more' => 'Daha fazla bilgi',
    '__loading' => 'Yükleniyor...',
    '__locales' => "Dil paketleri",
    '__lists' => "Postalama listeleri",
    '__literal_bytes' => "B",
    '__processing' => "Lütfen bekleyin.<br>Yükleniyor...",
    '__locale' => "Arayüz dili",
    '__locale_is_not_defined' => "Arayüz dili tanımlı değil.",
    '__local_server_mysql' => 'Yerel MariaDB/MySQL sunucusu',
    '__local_server_postgresql' => 'Yerel PostgreSQL sunucusu',
    '__local_server_mssql' => 'Yerel MS SQL sunucusu',
    '__log_and_statistics_files' => 'Günlük dosyaları ve istatistik raporları',
    '__config_files' => 'Yapılandırma dosyaları',
    '__chroot_files' => 'Chroot edilmiş ortam',
    '__login' => "%1 Kullanıcı Adı",
    '__login1' => "Giriş",
    '__login_disabled' => "Oturum açma yasaklandı",
    '__login_enabled' => "Oturum açmaya izin verildi",
    '__login_incorrect' => "Yanlış kullanıcı adı veya şifresi. Tekrar deneyin.",
    '__login_rate_limit_reached' => "Çok fazla oturum açma girişimi. Lütfen daha sonra tekrar deneyin.",
    '__login_name' => "%1 kullanıcı adı",
    '__login_name_is_invalid' => "%1 kullanıcı adı geçersiz.",
    '__logon_time' => "Logon zamanı",
    '__ma' => "Posta takma adları",
    '__mail' => "Posta",
    '__mail_alias_name' => "Eposta Takma ismi",
    '__mail_autodiscovery' => 'Otomatik posta bulma',
    '__mail_exchanger_name_is_invalid' => "Mail exchanger adı geçerli değil.",
    '__mail_groups' => "E-posta grupları",
    '__mail_list_engine' => "Mailing listesi yazılımı",
    '__mail_name' => "Posta hesabı",
    '__mail_name_form' => "Posta hesabı özellikleri",
    '__mail_names' => "Posta hesapları",
    '__mail_serv' => "Posta sunucusu",
    '__mail_user' => 'Eposta kullanıcısı',
    '__mailgroup' => "Mail grup",
    '__maillist' => "Gönderim listesi",
    '__maillists' => "Postalama listeleri",
    '__maillist_member' => 'Mailing listesi üyesi',
    '__mailname' => "Posta hesabı",
    '__mailname_redir_self' => "Posta hesabı postayı kendine iletemez.",
    '__max_dom_num_reached_for_cl' => "Bu alan adı hesabı için alan adı sayısı sınırına ulaşıldı.",
    '__max_file_size_available' => "Müsade edilen maksimum dosya boyutu %1",
    '__max_subdom_num_reached_for_cl' => "Bu müşteri hesabı için alt alan adı sayısı sınırına ulaşıldı.",
    '__max_subdom_num_reached_for_dom' => "Alan adı için alt alan adlarının sayısının sınırına ulaşıldı.",
    '__max_subdom_num_reached_for_key' => "Lisans anahtarıyla tanımlanan izin verilen alt alan adları sayısının sınırına ulaşıldı.",
    '__max_traffic_limit' => "Veri Trafiği limiti",
    '__maximum_excl_ip_num' => "Posta hesapları",
    '__mb' => "MB",
    '__mbytes' => "Megabayt",
    '__mb_month' => "MB/ay",
    '__mb_sec' => "MB/sn",
    '__gb_sec' => "GB/sn",
    '__tb_sec' => "TB/sn",
    '__mega' => "M",
    '__minute(s)' => 'Dakika',
    '__mls_not_in_key' => "Ürün anahtarınız çok dilli arayüzü desteklemiyor.",
    '__modification_date' => "Değiştirme tarihi",
    '__module' => "Uzantı",
    '__month' => "Ay",
    '__month(s)' => "Ay(lar)",
    '__month1' => "Ock",
    '__month10' => "Ekm",
    '__month11' => "Kas",
    '__month12' => "Ara",
    '__month2' => "Şub",
    '__month3' => "Mar",
    '__month4' => "Nisan",
    '__month5' => "May.",
    '__month6' => "Haziran",
    '__month7' => "Temmuz",
    '__month8' => "Ağu",
    '__month9' => "Eyl",
    '__monthly' => "Aylık",
    '__months' => "Aylar",
    '__moved_permanently' => 'Kalıcı Olarak Taşındı',
    '__mssql' => "Microsoft SQL Sunucusu",
    '__mssql__server' => "Sunucu",
    'mssql__server' => "Microsoft SQL sunucusu adı",
    'mssql__unable_to_change_server_name_db_exists' => "Sunucu adı değiştirilemez: bu sunucuda en az bir veritabanı mevcut.",
    '__mssql_status' => "Microsoft SQL Sunucusu durumu",
    '__multiply_login_deny' => "Oturum açılamıyor. Aynı kullanıcı adına (%1) sahip başka bir kullanıcı Plesk'te zaten oturum açmış.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL sunucusu durumu",
    '__mysql_version' => "MySQL sürümü",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB sunucusunun durumu",
    '__mariadb_version' => "MariaDB sürümü",
    '__percona' => "Percona",
    '__percona_status' => "Percona sunucusunun durumu",
    '__percona_version' => "Percona sürümü",
    '__name' => "Adı",
    '__name_invalid' => "İsim geçerli değil.",
    '__nameserver' => "İsim sunucusu",
    '__network' => "Ağ",
    '__networks' => "Ağlar",
    '__no' => "Hayır",
    '__no_ip_address_with_properly_type_available' => "Yedeklenmiş data geri kurulamıyor, geri kurulum için uygun IP Adresleri bulunamıyor.",
    '__no_clients_specified' => "Hiçbir müşteri hesabı belirtilmedi.",
    '__no_comments' => "Yorum yok.",
    '__nologin' => "Yasak",
    '__none' => "Hiçbiri",
    '__not_configured' => "Yapılandırılmamış",
    '__not_implemented_yet' => "Henüz uyarlanmamış",
    '__not_supported_by_ftp' => "(FTP Sunucusu tarafından desteklenmiyor)",
    '__notification' => "Bildiri",
    '__num_displayed' => "%1 in %2 si gösteriliyor",
    '__num_is_invalid' => "Sayı geçerli değil.",
    '__object_not_found' => 'Nesne bulunamadı: %1',
    '__off' => "Kapalı",
    '__ok' => "Tamam",
    '__old_passwd' => "Eski %1 şifresi",
    '__on' => "Açık",
    '__others' => "Diğerleri",
    '__other_ip__will_be_added' => 'Kullanılabilir diğer IP adresleri (müşterinin IP havuzuna eklenir)',
    '__p' => "P",
    '__passwd' => "%1 Şifreniz",
    '__passwd_is_invalid' => "%1 Şifre geçerli değil.",
    '__path' => "Yol",
    '__perl_unix_support' => "Perl desteği",
    '__perl_win_support' => "Perl desteği",
    '__perm_denied' => "Buna yetkiniz bulunmuyor.",
    '__permissions' => "Yetkiler",
    '__personal_name' => "İsim",
    '__pg_admin_not_activated' => "PostgreSQL yönetim sayfasında aktive edilmemiş.",
    '__pg_not_inst' => "PostgreSQL kurulu değil.",
    '__pg_not_run_or_inst' => "PostgreSQL kurulu değil veya çalışmıyor.",
    '__pg_not_support_in_key' => "PostgreSQL mevcut lisansınız tarafından desteklenmiyor",
    '__phone' => "Telefon",
    '__phosting' => "Fiziksel Hosting",
    '__php_support' => "PHP desteği",
    '__php_run_as_isapi' => "ISAPI olarak çalıştır",
    '__php_safe_mode' => "PHP 'safe_mode' açık",
    '__php_version' => "PHP versiyonu",
    '__physical' => "Fiziksel Hosting",
    '__plesk_stat_pdir' => "'/plesk-stat/webstat/' dizinini koruyun",
    '__plesk_stat_dir_name' => "Alan adı istatistikleri",
    '__plesk_stat_protect' => "Kullanıcının FTP kullanıcı adı ve parolasıyla web istatistiklerine erişimi koruyun",
    '__plesk_stat_protect_install' => "şifreyle korunmuş dizinden erişilebilir '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3 Sunucusu durumu",
    '__popen_error' => "Popen fonksyonu çağırılırken bir hata oluştu.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL durumu",
    '__preferences' => "Ayarlar",
    '__account_preferences' => "Hesap Ayarları",
    '__interface_preferences_general' => 'Genel',
    '__interface_preferences_default' => 'Varsayılan Arayüz Tercihleri',
    '__interface_preferences_admin' => "Yönetici arayüz tercihleri",
    '__interface_template' => 'Arayüz özelleştirme şablonu',
    '__interface_preferences' => "Arayüz tercihleri",
    '__proceed?' => "Devam etmek istiyor musunuz?",
    '__provider_contact_name' => "Sahibinin irtibat adı",
    '__python_unix_support' => "Python desteği",
    '__python_win_support' => "Python desteği",
    '__quota' => "Kota",
    '__r' => "R",
    '__reconfigure' => "Tekrar konfigüre et",
    '__record_type' => "Kayıt tipi",
    '__release' => "Sürüm",
    '__remote_db_not_supported_by_key' => 'Lisans anahtarınız, uzak veritabanı barındırmasını desteklemiyor.',
    '__remove_protection' => 'Şifre Korumasını Kaldır',
    '__report' => "Rapor",
    '__report_size_na' => "Hizmet kullanılamıyor",
    '__reports_list' => "Raporlar",
    '__requested' => "Talep edilen",
    '__required_fields' => "Zorunlu alanlar",
    '__resp_name_invalid' => "Otomatik Yanıt adı geçersiz. Sadece alfasayısal, noktalar, alt çizgi ve beyaz boşluk simgeleri kullanın.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Sunucu adı geçerli değil.",
    '__screenshots' => 'Ekran görüntüleri',
    '__script_warning' => "Komut dosyası oluşturma kapasitesi bu alan adından kaldırıldığında, etkilenen tüm komut dosyaları bir tarayıcıyla çağrıldığında düz metin olarak görüntülenir.  Yöneticinin tüm bağımlı komut dosyalarını belli bir alan adından kaldırması önerilir.",
    '__sec' => "Saniye",
    '__second(s)' => "Saniye",
    '__see_list_of_logged_in' => "Şu an sisteme giriş yapmış kullanıcıları listele.",
    '__select_certs_to_remove' => "Silinecek Sertifikaları seçiniz.",
    '__select_files_to_remove' => "Silinecek dosyaları seçiniz.",
    '__select_ip' => "IP adresini atayın",
    '__select_ip_to_remove' => "Silinecek IP Adresini seçiniz.",
    '__select_domain_template' => "Alan adı şablonu ayarlarını kullanın",
    '__select_templates_to_remove' => "Silinecek şablonları seçiniz.",
    '__server' => "Sunucu",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MariaDB/MySQL veritabanı sunucusu",
    '__service_description__mysql' => "MariaDB/MySQL veritabanı sunucusu",
    '__service_title__web' => "Web Sunucusu",
    '__service_description__web' => "Web Sunucusu",
    '__service_title__smtp' => "SMTP sunucusu",
    '__service_description__smtp' => "SMTP sunucusu",
    '__service_title__mail' => "IMAP/POP3 sunucusu",
    '__service_description__mail' => "IMAP/POP3 sunucusu",
    '__service_title__dns' => "DNS Sunucusu",
    '__service_description__dns' => "DNS Sunucusu",
    '__service_title__postgresq' => "PostgreSQL veritabanı sunucusu",
    '__service_description__postgresq' => "PostgreSQL veritabanı sunucusu",
    '__service_title__spamassassin' => "SpamAssassin gereksiz posta filtreleme servisi",
    '__service_description__spamassassin' => "SpamAssassin gereksiz posta filtreleme servisi",
    '__all_services' => "Tüm Servisler",
    '__sessions' => "Oturumlar",
    'sessions__feature_ftp_session_manager_not_supported' => "FTP Sunucusu FTP oturum özelliğini desteklemiyor",
    '__sessions_list' => "Oturumlar",
    '__set' => "Aç",
    '__shared' => "Paylaşılan",
    '__shell_access_warning' => "Sisteme kabuk erişimi izni vermek, sistem güvenliği için çok tehlikelidir. Sisteme erişime ancak ne yaptığınızı açık bir şekilde anlıyorsanız ve sadece güvenilir kullanıcılara erişim izni verin. Erişime izin vermek istediğinizden emin misiniz?",
    '__siteapp_not_support_in_key' => "Web uygulamaları, lisans anahtarı tarafından desteklenmez",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Bu web uygulamasının yapılandırması manuel olarak değiştirildi. Manuel değişiklikleri korumak için, Plesk üzerinden yeniden yapılandırma kullanılamaz hale getirir.',
    '__site_management' => "Web yayınlama", // indirect
    '__size' => "Boyut",
    '__skins' => 'Dış Görünümler',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP Sunucusu durumu",
    '__some_fields_are_empty_or_invalid' => "Bazı alanlar boş veya yanlış değerler içeriyor.",
    '__no_email_addresses_selected' => 'Hiçbir e-posta adresi seçilmedi.',
    '__unable_to_set_parameters' => "Bileşenin parametreleri belirlenemedi.",
    '__spamassassin' => "İstenmeyen Posta Filtresi",
    '__spamassassin_status' => "SpamAssassin durumu",
    '__spamd_status' => 'SpamAssasin durumu',
    '__splited_backup' => "(çok birimli yedekleme)",
    '__split_backup_file' => "Çok birimli bir yedekleme oluşturun",
    '__split_backup_size' => "Birim boyutu",
    '__split_backup_less_than_500' => "500 megabayttan küçük birimler desteklenmez",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI desteği",
    '__ssi_with_html' => "*.htm, *.html dosyaları için SSI kullan",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS destekli",
    '__same_ssl' => "SSL/TLS ve SSL/TLS dışı içeriği barındırmak için tek dizin kullanın",
    '__same_ssl_cu' => "Ortak SSL/TLS ve SSL/TLS dışı içerik",
    '__state' => "İl/ilçe",

    '__status__Active' => 'Etkin',
    '__status__active' => 'etkin',
    '__status__Passive' => 'Kapalı',
    '__status__passive' => 'kapalı',
    '__status__off' => 'kapalı',
    '__status__with_parent' => 'kapalı',
    '__status__backup_restore' => 'yedekleme veya geri yükleme için geçici olarak askıya alındı',
    '__status__admin' => 'sunucu yöneticisi tarafından askıya alındı',
    '__status__resseler' => 'satıcı tarafından askıya alındı',
    '__status__client' => 'müşteri tarafından askıya alındı',
    '__status__unknown' => 'durum bilinmiyor',

    '__status_of' => "%1 durumu",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel Sunucusu", // indirect
    '__subdomain' => "Alt alan adı",
    '__subdomain_name' => "Alt alan adı",
    '__subdomain_name_in_ASCII_form' => "ASCII biçiminde alt alan adı",
    '__subdomains' => "Alt alan adları",
    '__domainaliases' => "Takma alan adları",
    '__subdomains_list' => "Alt alan adları",
    '__subdomains_not_support_in_key' => "Alt alan adı işlemleri, lisans anahtarı tarafından desteklenmiyor",
    '__sys_user_type' => "FTP kullanıcısı",
    '__sys_user_type_main' => "Ana alan adın FTP kullanıcı hesabını kullanın",
    '__sys_user_type_native' => "Bu alt alan adı için ayrı bir FTP hesabı oluşturun",
    '__target_domain' => "Hedef alan adı",
    '__template' => "Şablon",
    '__template_not_accepted' => "Şablon oluşturulamıyor: aşağıdaki limitler aşılıyor.",
    '__templates' => "Şablonlar",
    '__templates_list' => "Şablonlar",
    '__tera' => "T",
    '__title' => "Başlık",
    '__total' => "Toplam %1",
    '__total_size' => "Toplam boyut",
    '__total_used' => "Toplam kullanılan",
    '__traffic' => "Trafik",
    '__traffic_by_client' => "Müşteriye göre trafik",
    '__traffic_by_domain' => "Alan adına göre trafik",
    '__traffic_by_service' => "Servis Veri trafiği",
    '__traffic_history' => "Veri trafiği istatistikleri",
    '__unable_change_locale' => "Arayüz dili değiştirilemiyor: %1",
    '__unable_create_new_dom' => "Alan adı oluşturulamıyor: %1",
    '__unable_define_dom_name' => "Alan adı tanımlanamıyor: %1",
    '__unable_define_necessary_properties' => "Gerekli özellikleri Tanımlama işlemi gerçekleştirilemedi.",
    '__unable_define_properties' => "Özellikler tanımlanamıyor: %1",
    '__unable_exec_util' => "Programı yürütmek için açılamıyor: %1",
    '__unable_get_dns_a_recs' => "Bu barındırma hesabı için A DNS kayıtlarının IP adresleri alınamıyor: %1",
    '__unable_get_mbox_quota' => "Posta kutusu boyut sınırındaki bilgiler alınamıyor.",
    '__unable_redirect_to_myself' => "Aynı hesaba iletilemiyor.",
    '__unable_redirect_to_my_alias' => "Posta bir posta takma adına iletilemiyor.",
    '__default_domain_redirect_to_myself' => "Alan adı, IP adresi için varsayılan olarak ayarlanamıyor:\n kendine yeniden yönlendirme algılandı.",
    '__unable_remove_client' => "Müşteri kaldırılamıyor: %1",
    '__unable_set_up_mbox_quota' => "Alan adı için posta kutusunun boyut sınırı ayarlanamıyor: %1",
    '__unable_setup_pass' => "Şifre ayarlanamıyor: %1",
    '__unable_to_create_new_account' => "Hesabı oluşturulamıyor: %1",
    '__unable_to_define_db_size' => "Veritabanı boyut tanımlama işlemi gerçekleştirilemedi",
    '__unable_to_enable_short_names' => "POP3/IMAP hesapları için kısa posta hesap adları kullanmaya izin verilemiyor.",
    '__unable_to_fetch_data_from_submit' => "Gönderilen data alınamıyor: %1",
    '__unable_to_open_file' => "%1 dosyası açılamıyor: %2",
    '__unable_to_update_subdomain' => "Alt alan adında değişiklik yapılamıyor: %1",
    '__unable_update_cl_data' => "Değişiklikler, kullanıcı hesabına kaydedilemiyor: %1",
    '__unable_update_db_params' => "Veritabanı parametreleri güncellenemiyor: %1",
    '__unable_update_dom_data' => "Alan adı verileri güncellenemiyor: %1",
    '__undefined' => "Tanımsız",
    '__uninstall' => "Kaldır",
    '__unknown_error' => "Bilinmeyen hata",
    '__unlimited_lower' => "Sınırsız",
    '__unset' => "Kapat",
    '__update' => "Güncelle",
    '__uploaded_file_is_invalid' => "Yüklenen dosya geçersiz: %1",
    '__url' => "URL",
    '__usage' => "Disk kullanımı",
    '__user_already_logged' => "Aynı kullanıcı adına (%1) sahip başka bir kullanıcı Plesk'te zaten oturum açmış.",
    '__version' => "Versiyon",
    '__aps_license' => "Lisans anahtarı",
    '__vh_type' => "Sanal ana bilgisayar tipi",
    '__vhosts_apache_status' => "Web Sunucusu durumu",
    '__wrong_charset_conversion' => 'Yanlış karakter kümesi, "%1"den "%2"ye dönüştürmeye izin verilmez',
    '__warning_' => "Uyarı!",
    '__warning_excl_ip_num' => "Adanmış IP adresi",
    '__warning_expiration' => "Son kullanım tarihi",
    '__web_scripting' => "Web komut dosyası", // indirect
    '__web_serv' => "Web Sunucusu", // indirect
    '__web_statistic' => "Web istatistikleri", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer sunucuda yüklü değil. Webalizer kurulumuyla ilgili destek için servis sağlayıcınızla irtibata geçin.",
    '__webstat_support' => "Web istatistikleri",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Bir istatistik programından diğerine geçtiğinizde, daha önce kullandığınız istatistik programıyla oluşturulan tüm raporlar silinir ve sunucuda tutulan günlük dosyalarından okunan bilgilere göre yeni raporlar oluşturulur. Bu, (Alan Adları > alan adı > Günlük Yöneticisi > Günlük Döndürme altında) sistemi sadece son aylık günlük dosyalarını tutacak şekilde yapılandırdığınızda, web istatistiklerinin sadece son ay için kullanılabileceği anlamına gelir. Başka bir istatistik paketine geçmek istiyor musunuz?",
    '__webstat_perm_denied' => 'Web istatistiklerini yönetme izniniz yok.',
    '__webuser' => "Web kullanıcısı",
    '__sysusers_list' => "Sistem kullanıcıları",
    '__sysuser' => "Sistem kullanıcısı",
    '__weekly' => "Haftalık",
    '__whats_new_in_version' => "Plesk %1 yenilikleri neler?",
    '__wrong_hosting_type__virtual_required' => "Bu işlem sadece web barındırmalı alan adları için kullanılabilir.",
    '__wrong_hosting_type__none' => '%1 alan adında yapılandırılmış bir web barındırması yok.',
    '__wrong_hosting_type__std_fwd' => '%1 alan adının standart iletmesi yapılandırılmış. Bu işlem sadece web barındırmalı alan adları için kullanılabilir.',
    '__wrong_hosting_type__frm_fwd' => '%1 alan adının çerçeve iletmesi yapılandırılmış. Bu işlem sadece web barındırmalı alan adları için kullanılabilir.',
    '__wu' => "Web Kullanıcıları",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW öneki değiştirildi. SSL/TLS sertifikasını buna göre değiştirdiğinizden emin olun.",
    '__year' => "Yıl",
    '__year(s)' => "Yıl(lar)",
    '__yes' => "Evet",
    '__you' => "Siz",
    '__zip_code' => "Posta Kodu",
    '__form_normal' => "Normal",
    '__form_advanced' => "Gelişmiş",

    'admin_ed__edit_administrator_info' => "Yönetici Profilini Düzenleme",
    'admin_ed__create_default_client' => "Varsayılan bir müşteri hesabı oluşturmak istiyorum.",
    'admin_ed__unable_update' => "Yönetici bilgileri günellenemiyor: %1",

    'auth__update_admin_info' => "Lütfen yönetici bilgilerini girin. %1 çalıştırmak için bu bilgiler gerekir.",
    'auth__you_not_have_perm' => "Bu alan adını yönetme izniniz yok.",
    'auth__key_expired_admin' => 'Plesk lisansınızın süresi doldu. Plesk\'i kullanmaya devam etmek için lisansınızı yenileyin veya yenisini satın alın.',
    'auth__key_expired_admin_restricted' => 'Plesk lisansınızın süresi doldu. Plesk\'i kullanmaya devam etmek için hizmet sağlayıcınızla irtibata geçin.',
    'auth__key_expired_client' => 'Plesk lisansının süresi doldu. Barındırma sağlayıcınızla irtibata geçin.',
    'autoinstaller__not_installed' => 'Otomatik yükleyici bileşeni yüklü değil.',
    'autoinstaller__release_action' => 'Mevcut işlemler',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Yeni Plesk sürümüne yükseltiyor',
    'autoinstaller__release_action_update' => 'Yeni modül ekle/güncelle',
    'autoinstaller__release_action_up2date' => 'Güncel bir sürümünüz var',
    'autoinstaller__component_action' => 'Durum',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Kurulu değil',
    'autoinstaller__component_action_update' => 'Yeni güncellemeler var',
    'autoinstaller__component_action_upgrade' => 'Bir güncelleme kullanılabilir',
    'autoinstaller__component_action_up2date' => 'Güncel bir sürümünüz var',
    'autoinstaller__component_action_error' => 'Güncellemeler kullanılamaz',
    'autoinstaller__component_serverbuildtime' => 'En son sürüm',
    'autoinstaller__component_localbuildtime' => 'Mevcut sürüm',
    'autoinstaller__component_installed_version' => 'Sürümünüz',
    'autoinstaller__component_available_version' => 'En son sürüm',
    'autoinstaller__component' => 'Modül',
    'autoinstaller__components' => 'Modüller',
    'autoinstaller__components_title' => '%1 Modüller',
    'autoinstaller__component_dependency_note' => 'seçtiğiniz bileşenlerin kurulumu için gerekir',
    'autoinstaller__install_confirm' => 'Evet, bu bileşenleri kurmak istiyorum',
    'autoinstaller__install_confirm_request' => 'Lütfen onaylamak için onay kutusunu işaretleyin',
    'autoinstaller__install_title' => 'Seçilen Bileşenlerin Kurulumunu Onaylayın',
    'autoinstaller__key_update_confirm' => 'Anahtar güncellemesini atlamayı ve varsayılan anahtarı kurmayı onaylayın',
    'autoinstaller__key_update_confirm_request' => 'Lütfen onaylamak için onay kutusunu işaretleyin.',
    'autoinstaller__key_update_failed' => '<p>Plesk, ürün lisansınızı güncelleyemiyor.</p><p>%1</p><p>Uygun bir ürün lisansı olmadan yükseltmeye devam etmek, sınırlı işlevselliğe sahip varsayılan lisansın kurulmasına neden olur. Yöneticiler, ürün yükseltmesine devam etmeden önce uygun lisans anahtarını edinmesi önerilir.</p>',
    'autoinstaller__email' => 'Bildirimi buraya gönderin',
    'autoinstaller__email_admin' => "Yöneticinin e-postası",
    'autoinstaller__email_email' => 'Özel e-posta adresi...',
    'autoinstaller__release' => 'Sürüm adı',
    'autoinstaller__releases' => 'Müsait sürümler',
    'autoinstaller__releases_title' => 'Plesk Güncelleyicisi',
    'autoinstaller__select_components_to_install' => 'Kurulacak olan bileşenleri seçin',
    'autoinstaller__status_error' => 'Hata: %1',
    'autoinstaller__status_install_error' => 'Kurulum başlatılamadı: %1',
    'autoinstaller__status_install_busy' => 'Kurulum henüz başlatılamıyor: başka bir kurulum şu an çalışıyor.',
    'autoinstaller__status_install_ok' => 'Kurulum başlatıldı. Kurulum aşaması size e-postayla (%1) bildirilecektir.',
    'autoinstaller__status_query_busy' => 'Kurulum işlemi devam ediyor.',
    'autoinstaller__status_query_error' => 'Kurulum durumu tespit edilemiyor: %1',
    'autoinstaller__status_unknown' => 'Otomatik yükleyici durumu alınamıyor.',
    'autoinstaller__status_busy' => 'Otomatik yükleyici meşgul, lütfen bekleyin.',
    'autoinstaller__configure_title' => 'Güncelleyici ayarları',
    'autoinstaller__preferences_legend' => 'Ayarlar',
    'autoinstaller__target' => 'Geçici indirme dizini',
    'autoinstaller__target_invalid' => "Mutlak yol belirtin",
    'autoinstaller__check_updates' => 'Yöneticinin Plesk\'teki oturum açmasıyla ilgili güncellemeleri kontrol edin',
    'autoinstaller__check_updates_warning' => '%2 için yeni <a href="%1">güncellemeler</a> kullanılabilir',
    'autoinstaller__source_type' => 'Kaynak tipi',
    'autoinstaller__source' => 'Kaynak URL',
    'autoinstaller_source__preferences_legend' => 'Ayarlar',
    'autoinstaller_source__type' => 'Kaynak tipi',
    'autoinstaller_source__url_invalid' => 'Geçersiz kaynak',
    'autoinstaller_source__url_invalid_network' => 'Geçersiz kaynak URL\'si (Örnek: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Kaynak URL',
    'autoinstaller__source_invalid_network' => 'Geçersiz bir ağ adresi belirttiniz',
    'backup__repository' => 'Yedekleme dosyaları depolama konumu',
    'backup__error_notify_email' => 'Yedekleme sırasında hata oluşursa, e-postaya bildirim gönderin',
    'backup__dump_info' => "Yedekleme bilgisi",
    'backup__dump_file_name_not_defined' => "Yedekleme dosyasının adı belirtilmedi",
    'backup__local_file' => 'Lokal yedekleme dosyası',
    'backup__domain_ftp' => 'uzak FTP sunucusu',
    'backup__wrong_path' => "Yedekleme dosyaları deposunun yanlış yolu: ../../ karakter sırasını kullanmayın",
    'backup__unable_to_connect_to_ftp_server' => "FTP sunucusuna bağlanılamıyor: %1",
    'backup__unable_to_read_file' => 'Yedekleme dosyası okunamıyor.',
    'backup__backup_task_does_not_exist' => "Yedekleme görevi mevcut değil, açmadan önce oluşturulmalı.",
    'backup__restore_params' => "Geri kurma parametreleri",
    'backup__confirmation' => "Uyarı: Alan adı yedekleme/kurtarma sırasında kullanılamaz.",
    'backup__backup_method' => 'Yedekleme yöntemi',
    'backup__dumpfile_name' => "Yedekleme dosyası adı",
    'backup__dumpfile_name_is_invalid' => "Yedekleme dosyasının adı geçersiz: sadece alfasayısal, çizgi, nokta ve alt çizgi simgeleri kullanın, açıklama gibi adlar kullanmayın.*  yedekleme dosyası adı olarak.",
    'backup__email_required' => "E-posta adresinizin size yedekleme ve geri yükleme aşamalarını bildirmesi gerekir. Lütfen hesap ayrıntılarında e-postanızı belirtin.",
    'backup__error_during_backup' => "Yedek dosyası yaratılamıyor: %1",
    'backup__input_email_warning' => "Ya bildirim için bir e-posta belirtmeniz, ya da onay kutusundaki işareti kaldırmanız gerekir.",
    'backup__make_download' => "yedekleme dosyasını saklama, sadece indir",
    'backup__make_dump' => 'yedekleme dosyası oluşturun ve yerel depoda sakla',
    'backup__makedump_to_ftp' => 'yedekleme dosyası oluşturun ve uzak FTP sunucusunda sakla',
    'backup__restore_ip' => "Geri kurma için IP Adresi",
    'backup__select_dumpfile' => "Bir Yedekleme dosyası seçiniz.",
    'backup__time' => "Yedekleme zamanı",
    'backup__day' => 'Yedekleme günü',
    'backup__view_dump_info' => "%1 alan adı için yedekleme bilgilerini görüntüleyin",
    'backup__wrong_domain_name' => "Yedekleme dosyası, %1 alan adı verilerini içeriyor ve bu nedenle %2 alan adı üzerinde geri yüklenemez",
    'backup__incorrect_ftp_user_or_passwd' => "Yanlış FTP kullanıcısı veya şifresi. Lütfen FTP Hesabı Özelliklerini düzeltin",
    'backup__access_denied' => "Erişim reddedildi.  Lütfen FTP Hesabı Özelliklerini düzeltin",
    'backup__restore_from' => "%1 geri yükleyin",
    'backup__domain_session_failed' => 'Alan adı %1 yedeklenmedi',
    'backup__client_session_failed' => 'Müşteri %1 yedeklenmedi',
    'backup__domain_session_restore_failed' => 'Alan adı %1 geri yüklenmedi',
    'backup__client_session_restore_failed' => 'Müşteri hesabı %1 geri yüklenmedi',
    'backup__domain_session_complete' => 'Alan adı %1 yedeklendi',
    'backup__domain_session_backup' => 'Alan adı %1 yedeklemesi',
    'backup__client_session_backup' => 'Müşteri %1 yedeklemesi',
    'backup__domain_stop_title' => 'Alan adı %1 yedeklemesinin iptal edilmesi',
    'backup__client_stop_title' => 'Müşteri hesabı %1 yedeklemesini iptal etme',
    'backup__domain_restore_stop_title' => 'Alan adı %1 kurtarmasının iptal edilmesi',
    'backup__client_restore_stop_title' => 'Müşteri hesabı %1 kurtarmasını iptal etme',
    'backup__domain_session_backup_stop' => 'Etkin yedekleme işlemini iptal etmek üzeresiniz.  Yedekleme dosyası oluşturulmayacak.',
    'backup__backup_stop_confirm' => 'Evet, yedekleme işlemini durdurmak istiyorum',
    'backup__restore_stop_confirm' => 'Evet, kurtarma işlemini durdurmak istiyorum',
    'backup__domain_session_restore' => '%1 alan adını kurtarmak',
    'backup__domain_session_restore_stop' => 'Etkin kurtarma işlemini iptal etmek üzeresiniz.',
    'backup__domain_backup_file_info' => 'Alan Adı Yedekleme Dosyası Bilgileri',
    'backup__domain_backup_file_list' => 'varolan yedekleme dosyaları',
    'backup__domain_backup_progress' => 'Müşteri web sitesini %1 yedekleme aşaması',
    'backup__domain_restore_progress' => 'Web sitesini %1 geri yükleme aşaması',
    'backup__domain_backup_progress_elapsed_time' => 'Geçen süre: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Geçen süre: %1',
    'backup__domain_restore_session_complete' => 'Alan adı %1 geri yüklenir.',
    'backup__domain_restore_session_complete_message' => 'Alan adı %1 geri yüklendi.',
    'backup__domain_backup_file_delete' => 'Aşağıdaki yedekleme dosyaları kaldırılacak:',
    'backup__domain_backup_file_for_remove' => 'Kaldırmak istediğiniz yedekleme dosyalarını seçin',
    'backup__backup_overwrite_file_confirm' => 'Değiştirme onayı',
    'backup__backup_overwrite_file_confirm_text' => 'Adı "%1" olan bir yedekleme dosyası zaten var. Değiştirmek istiyor musunuz?',
    'backup__backup_confirm_overwrite' => 'Dosya değiştirmeyi onaylayın',
    'backup__backup_overwrite_legeng' => 'Değiştirin',
    'backup__backup_not_contain_domain' => 'Yedekleme dosyası, alan adı %1 hakkında bilgi içermiyor',
    'backup__backup_not_contain_client' => 'Yedekleme dosyası, müşteri hesabı %1 hakkında bilgi içermiyor',
    'backup__backup_client_info' => "Müşteri ayarlarını ve hesap ayrıntılarını yedekleme",
    'backup__client_backup_progress' => 'Müşteri Hesabını %1 Yedekleme Aşaması',
    'backup__client_session_complete' => 'Müşteri hesabı %1 yedeklendi',
    'backup__client_backup_file_info' => 'Müşteri Yedekleme Dosyası Bilgileri',
    'backup__restore_client_info' => "Müşterinin ayarlarını ve hesap ayrıntılarını geri yükleyin",
    'backup__client_session_restore' => 'Müşteri Hesabını %1 Geri Yükleme',
    'backup__client_db_server_map' => 'Veritabanı Sunucuları Eşlemesi',
    'backup__domain_db_server_map' => 'Veritabanı Sunucuları Eşlemesi',
    'backup__client_restore_session_complete_message' => 'Müşteri hesabı %1 geri yüklendi.',
    'backup__client_restore_session_complete' => 'Müşteri hesabı %1 geri yüklendi.',
    'backup__restore_select_some' => 'Lütfen geri yüklemek istediğiniz nesneleri seçin.',
    'backup__client_restore_progress' => 'Müşteri Hesabı %1 için Kurtarma Aşaması',
    'backup__new_backup' => 'Yeni Yedekleme Oluşturma',
    'backup__done' => 'Bitti:',
    'backup__done_domains' => '%1 / %2 alan adı',
    'backup__done_clients' => '%1 müşteri / %2',
    'backup__remaining' => 'Kalan:',
    'backup__remaining_domains' => '%1 alan adı',
    'backup__remaining_clients' => '%1 müşteri',
    'backup__overall_backup_progress' => 'Genel yedekleme aşaması',
    'backup__comment_n_a' => 'yok',
    'backup__command_ignore' => '"%1" komutu göz ardı ediliyor',
    'backup__no_objects' => 'yedekleme için hiçbir nesne yok',
    'backup__cli_warning_not_enough_ip' => 'UYARI: varsayılan IP eşlemeyi gerçekleştirmek için yeterli IP adresi yok:',
    'backup__local_repository' => "Plesk'in deposu",
    'backup__ftp_repository' => 'FTP depolaması',
    'backup__ftp_login' => 'Kullanıcı adı',
    'backup__ftp_password' => 'Şifre',
    'backup__ftp_account_settings' => 'FTP Hesabı Ayarları',
    'backup__ftp_account_preferences' => 'FTP hesabı ayarları',
    'backup__repository_not_exist' => 'Dizin mevcut değil',
    'backup__repository_not_readable' => 'Belirtilen dizin okunamıyor',
    'backup__ftp_repository_not_configure' => 'Bir FTP yedekleme deposunu kullanmak için, <a href="%1">önce FTP hesabını belirtin</a>',
    'backup__ftp_repository_list_not_configure' => 'Hesap ayarları belirtilmedi',
    'backup__repository_list_unable_listing' => 'Dosya listesi alınamıyor',
    'backup__ftp_repository_unable_listing' => '"%1" dizininin listesi alınamıyor:',
    'backup__repository_legend' => 'Yedekleme dosyaları deposu',
    'backup__store_in_repository' => 'Dosyaları burada depolayın',
    'backup__local_repository_lable' => 'Yerel depolama',
    'backup__ftp_repository_lable' => 'FTP depolaması',
    'backup__ftp_repository_not_configure_hint' => '(hesap ayarları belirtilmez)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP hesabı belirtilmedi veya desteklenmedi)',
    'backup__other_user_process_modified' => 'Başka bir kullanıcı, yedeklemeyi veya göç işlemi durdurdu.',
    'backup__another_user_exist' => 'Yürütülen işlem, başka bir Plesk kullanıcısı tarafından başlatıldı. Bu kullanıcı halen Plesk\'te oturum açmış durumda.',
    'backup__ftp_repository_wait' => 'Lütfen yaklaşık FTP deposu hakkındaki bilgiler alınırken bekleyin',
    'backup__ftp_write_test_failed' => 'Test verilerini %1 FTP hesabına yazma başarısız oldu:',
    'backup__ftp_storage' => 'FTP(S) depolaması',
    'bt_upload_to_repository' => 'Dosyaları Yerel Depoya Yükle',
    'bt_new_restore' => "Gerikur",
    'bt_backup_schedule' => "Yedeklemeyi Planlayın",
    'backup_exist_backups' => "Varolan yedekleme dosyaları",
    'backup_dialog__page_title' => "Yedekleme dosyası oluşturma",
    'backup_dialog__please_wait' => "Yedekleme işlemi başlamak üzere. Bu işlem biraz zaman alabilir.  Lütfen bekleyin...",
    'backup_conf__page_title' => 'Yedekleme Yapılandırması',
    'bt_accept' => "Kabul",
    'bt_access' => "Erişim",
    'bt_action_log' => "Eylem Günlüğü",
    'bt_add' => "Ekle",
    'bt_add_client' => "Kullanıcılara Atayın",
    'bt_database_server_add' => 'Veritabanı Sunucusu Ekleyin',
    'bt_add_services' => "Hizmet Ekle",
    'bt_anonftp_stats' => "Anon.FTP istatistikleri",
    'bt_anonymous_ftp' => "Anonim FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Ekle",
    'bt_autoinstaller' => 'Güncelleyici',
    'bt_auto-updates' => 'Güncelleyici',
    'bt_back' => "<< Geri",
    'bt_backup' => "Yedekleyin",
    'bt_backup_configure' => "Yedekleme Ayarları",
    'bt_buy_certs' => "Sertifika satın alın",
    'bt_card' => "Kart",
    'bt_cert' => "Sertifika",
    'bt_certificates' => "Sertifikalar",
    'bt_change_passwd' => "Şifre değiştir",
    'bt_clear' => "Temizle",
    'bt_client_templates' => "Müşteri Şablonları",
    'bt_clients' => "Müşteriler",
    'bt_codepage_change' => 'Kodlamayı Değiştir',
    'bt_comp_info' => "Modül Bilgileri",
    'bt_configure_maillists' => "Mailman Ayarlayın",
    'bt_configure' => 'Yapılandırma',
    'bt_copy' => "Kopyala",
    'bt_copy_move' => "Kopyala/Taşı",
    'bt_create' => "Oluştur",
    'bt_create_account' => "Hesap Oluştur",
    'bt_create_dir' => "Bir Dizin Ekle",
    'bt_create_file' => "Dosya Ekle",
    'bt_count_size' => "Boyutu Hesapla",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Görev Zamanlayıcı",
    'bt_custom_button_new' => "Bir düğme ekleyin",
    'bt_custom_buttons' => "Özel Butonlar",
    'bt_customize' => "Özelleştir",
    'bt_databases' => "Veritabanları",
    'bt_database_servers' => 'Veritabanı Sunucuları',
    'bt_sqlservers' => "Veritabanı Sunucuları",
    'bt_db_usr_new' => "Bir veritabanı kullanıcısı ekleyin",
    'bt_db_new' => "Bir Veritabanı Ekle",
    'bt_db_phpmyadmin' => "MySQL Yöneticisi",
    'bt_dbuser_default' => "DB Webadmin için Varsayılan Yap",
    'bt_decline' => "Red et",
    'bt_default' => "Varsayılan",
    'bt_defaultcomponents' => "3. Parti servisler",
    'bt_defaults' => "Varsayılanlar",
    'bt_delete' => "Sil",
    'bt_directories' => "Korunmuş Dizinler",
    'bt_disable' => "Kapatın",
    'bt_dns_zone_sync' => 'DNS Şablonu Değişikliklerini Uygulayın',
    'bt_dnsrecord_add' => 'Kayıt Ekleyin',
    'bt_do_backup' => "Yedekle",
    'bt_do_restore' => "Gerikur",
    'bt_do_upload' => "Yükle",
    'bt_domain_aliases' => "Takma alan adları",
    'bt_domain_templates' => "Alan Adı Şablonları",
    'bt_domain_user' => "Alan Adı Yöneticisi",
    'bt_domain_user_passwd' => "Alan Adı Yöneticisi Şifresi",
    'bt_domains' => "Alan Adları",
    'bt_domain_alias_add' => 'Takma Alan Adı Ekleyin',
    'bt_download' => "İndir",
    'bt_edit' => "Düzenle",
    'bt_enable' => "Aç",
    'bt_export' => 'Ver',
    'bt_extras' => "İlaveler",
    'bt_finish' => "Bitir",
    'bt_ftp_account' => "FTP hesap özellikleri",
    'bt_forget_password' => "Şifrenizi mi unuttunuz?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin'i",
    'bt_fp_webadmin' => "FP Webadmin'i",
    'bt_ftp_stats' => "FTP istatistikleri",
    'bt_get_password' => "Şifreyi al",
    'bt_global_changes' => "Değiştir",
    'bt_help' => "Yardım",
    'bt_hide_aliases' => "Takma isimleri gizle",
    'bt_hide_toolbar' => 'Araç çubğunu gizle',
    'bt_hide_subdomains' => "Alt Alan Adlarını Gizleyin",
    'bt_hide_domainaliases' => "Takma Alan Adlarını Gizleyin",
    'bt_home' => "Anasayfa",
    'bt_hosting' => "Barındırma",
    'bt_icf' => 'Firewall',
    'bt_install' => "Kur",
    'bt_ip_aliasing' => "IP Adresleri",
    'bt_ip_add' => "IP Adresi Ekle",
    'bt_ip_pool' => "IP havuzu",
    'bt_key_info' => "Lisans Bilgisi",
    'bt_key_buyonline_addons' => 'Plesk Eklentilerini Sipariş Edin',
    'bt_key_buyonline_upgrades' => 'Plesk Yükseltmelerini Sipariş Et',
    'bt_key_buyonline_new' => 'Yeni lisans al',
    'bt_limits' => "Limitler",
    'bt_locale_add' => 'Yerel Ayarı Ekleyin',
    'bt_locales' => 'Yerel ayar değerleri',
    'bt_log_manager' => "Günlük Yöneticisi",
    'bt_login' => "Oturum Aç",
    'bt_logo' => "Marka",
    'bt_logo_send_link' => "Link ekle",
    'bt_logo_send_logo' => "Logo ekle",
    'bt_logout' => "Oturumu Kapat",
    'bt_logrotation' => "Günlük döndürmesi",
    'bt_mail' => "Posta",
    'bt_mail_alias_add' => "Posta Takma Adı Ekle",
    'bt_mail_aliases' => "Posta Takma Adları",
    'bt_mail_group_add' => "Üye Ekle",
    'bt_mail_groups' => "Gruplar",
    'bt_mail_name_add' => "Posta Hesabı Ekle",
    'bt_mail_preferences' => "Ayarlar",
    'bt_mail_group' => "Mail Grup",
    'bt_mail_mailbox' => "Posta kutusu",
    'bt_mail_redirect' => "İletici",
    'bt_mail_resp_add' => "Otomatik Yanıt Ekle",
    'bt_mail_resp_attach_add' => "Ek Ekle",
    'bt_mail_resp_files' => "Eklenti dosyaları",
    'bt_mail_responders' => "Otomatik yanıtlar",
    'bt_mail_spamfilter' => "İstenmeyen Posta Filtresi",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Postalama Listesi Ekle",
    'bt_maillists' => "Postalama Listeleri",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Yedekleme oluştur",
    'bt_manage' => "Yönet",
    'bt_master' => "Ana",
    'bt_migrate' => 'Taşı',
    'bt_modules_add' => 'Uzantı Ekleyin',
    'bt_modules_manage' => 'Uzantıları Yönetin',
    'bt_move' => "Taşı",
    'bt_new_client' => "Müşteri Hesabı Ekle",
    'bt_new_domain' => "Alan Adı Ekle",
    'bt_next' => "İleri >>",
    'bt_next_page' => "İleri",
    'bt_network_add' => "Ağ Ekle",
    'bt_notifications' => "Bildiriler",
    'bt_off' => "Kapalı",
    'bt_on' => "Açık",
    'bt_on_off' => "Aç/Kapat",
    'bt_performance' => 'Performans',
    'bt_permissions' => "Yetkiler",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Ayarlar",
    'bt_prev_page' => "Önceki",
    'bt_preview' => 'Önizleme',
    'bt_print' => "Yazdır",
    'bt_reboot' => "Yeniden başlat",
    'bt_reload' => "Yeniden Yükle",
    'bt_refresh' => "Yenile",
    'bt_register' => "Tescil et",
    'bt_remove' => "Sil",
    'bt_enable_selected' => 'Aç',
    'bt_disable_selected' => 'Kapatın',
    'bt_repair_ip' => "Ip yi düzelt",
    'bt_report' => "Rapor",
    'bt_report_new' => "Yerleşim Ekle",
    'bt_reset' => "Temizle",
    'bt_restart_services' => "Hizmet Yönetimi",
    'bt_save' => "Kaydet",
    'bt_send_by_email' => "E-postayla Gönderin",
    'bt_send_file' => "Dosya gönder",
    'bt_send_mail' => "E-posta gönder",
    'bt_send_passwd' => "Şifre gönder",
    'bt_send_text' => "Metin gönder",
    'bt_server' => "Sunucu",
    'bt_server_add' => "Sunucu Ekle",
    'bt_server_preferences' => "Sunucu Ayarları",
    'bt_servers_list' => "Sunucular",
    'bt_sessions' => "Oturumlar",
    'bt_set' => "Ata",
    'bt_set_as_default' => "Varsayılan olarak ata",
    'bt_setup' => 'Ayarla',
    'bt_show_aliases' => "Takma isimleri göster",
    'bt_show_subdomains' => "Alt Alan Adlarını Gösterin",
    'bt_show_domainaliases' => "Takma Alan Adlarını Gösterin",
    'bt_shutdown' => "Kapat",
    'bt_site_apppkgs' => "Uygulama deposu",
    'bt_site_apppool' => "Uygulama Havuzu",
    'bt_application-pool' => "Web Uygulamaları",
    'bt_site_apps' => "Web Uygulamaları",
    'bt_site_app_add' => "Uygulamayı Yükle",
    'bt_site_builder' => "Presence Builder Desteği",
    'bt_skeleton' => 'Sanal Ana Bilgisayar Şablonu',
    'bt_skins' => 'Dış Görünümler',
    'bt_skin_add' => 'Cilt Ekle',
    'bt_skin_manual' => 'Özel Plesk Dış Görünüm Referansı', // not used
    'bt_skin_download' => 'Dış Görünümü İndirin',
    'bt_skin_replace' => 'Arayüzü güncelle',
    'bt_skip' => 'Atla',
    'bt_spamassassin' => "İstenmeyen Posta Filtresi",
    'bt_spamassassin_train' => "Eğitim",
    'bt_spamfilter' => "İstenmeyen Posta Filtresi",
    'bt_start' => "Başlat",
    'bt_stop' => "Durdur",
    'bt_recycle' => "Recycle ( Yenile )",
    'bt_statistics' => "İstatistikler",
    'bt_subdomain_new' => "Alt Alan Adı Ekleyin",
    'bt_subdomains' => "Alt alan adları",
    'bt_submit' => "Gönder",
    'bt_summary_report' => "Özet Rapor",
    'bt_support' => "Destek",
    'bt_switch' => "Çevir",
    'bt_system_time' => "Sistem zamanı",
    'bt_task_new' => "Görev Ekle",
    'bt_dom_tmpl_add' => 'Alan Adı Şablonu Ekleyin',
    'bt_cl_tmpl_add' => 'Müşteri Şablonu Ekleyin',
    'bt_cron_backup' => 'Otomatik Yedekleme Ayarları',
    'bt_test' => "Bağlantıyı Sına",
    'bt_text' => "Metin",
    'bt_touch' => "Zaman Damgasını Değiştirin",
    'bt_traffic' => "Trafik",
    'bt_traffic_history' => "Veri trafiği istatistikleri",
    'bt_update' => "Güncelle",
    'bt_upload' => "Yükle",
    'bt_upload_from_ftp' => "FTP den yükle",
    'bt_virtualdirs' => 'Sanal Dizinler',
    'bt_virtualdir_new' => 'Sanal Dizin Ekle',
    'bt_virtualdir_add' => 'Sanal Dizin Ekle',
    'bt_web_app_new' => "Java Uygulamasını Kurun",
    'bt_web_stats' => "Web istatistikleri",
    'bt_web_stats_ssl' => "Web istatistikleri SSL/TLS",
    'bt_web_user_add' => "Web Kullanıcısı Ekle",
    'bt_web_users' => "Web Kullanıcıları",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Tüm değişiklikleri listele",
    'cert_add__unable_set_ca_cert' => "CA sertifikası ayarlanamıyor: %1",
    'cert_add__unable_set_cert' => "Sertifika ayarlanamıyor: %1",
    'cert_add__unable_set_private_key' => "Özel anahtar ayarlanamıyor: %1",
    'certificates_list__certificate_used_as_default' => "sileceğiniz sertifikalardan biri, Varsayılan Sertifika olarak kullanılır.",
    'certificates_list__certificates_assigned_on_ip' => "IP adreslerine/alan adlarına bir veya daha fazla sertifika atanmış.",
    'ch_pass__admin_pass' => "Yöneticinin Şifresini Değiştirme",
    'ch_pass__old_pass' => "Eski şifre",
    'ch_pass__pass_confirm' => "Onayla",
    'ch_pass__unable_change_admin_pass' => "Yöneticinin şifresi değiştirilemiyor: %1",
    'check_mail_cycle__aliases' => "Posta çevrimi algılandı, _\"%1_\" adresi bu posta hesabının takma adlarında bulunuyor.",
    'check_mail_cycle__autoresponders' => "Posta çevrimi algılandı, _\"%1_\" adresi bu posta hesabının otomatik yanıtlarında bulunuyor.",
    'check_mail_cycle__mail_groups' => "Posta çevrimi algılandı, _\"%1_\" adresi bu posta hesabının posta grubunda bulunuyor.",
    'check_mail_cycle__mail_name' => "Posta çevrimi algılandı, _\"%1_\" adresi bu posta hesabıyla çakışıyor.",
    'check_mail_cycle__redirect' => "Posta çevrimi algılandı, _\"%1_\" adresi bu posta hesabının ileticiyle çakışıyor.",
    'check_mail_dup__redirect' => "Çift iletme algılandı, \"%1\" adresi bu posta hesabının iletme adresiyle çakışıyor.",
    'check_mail_dup__mail_groups' => "Çift iletme algılandı, \"%1\" adresi bu posta hesabının posta grubunda bulunuyor.",
    'check_maillist_cycle__admin' => "Posta çevrimi algılandı, yöneticinin \"%1\" e-postası bir postalama listesinin adresiyle çakışıyor.",
    'check_maillist_cycle__member' => "Posta döngüsü algılandı, adres \"%1\" posta listesinin adresine uyuyor.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1's hesap detayları",
    'cl_limits__cl' => "Müşteri %1 sınırları",
    'cl_logo__setup_logo_pref' => "%1 müşterisi için logo özelliklerini ayarlayın",
    'cl_new__enter_new_cl_data' => "Yeni müşteriyle ilgili bilgileri girin",
    'cl_new__unable_to_sent_notification' => 'Kullanıcı hesabı oluşturuldu, ancak müşteriye bir bildirim gönderme başarısız oldu: %1',
    'cl_perm__all_ip' => "Bütün müsati IP ler",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Müşterilerin tüm IP tabanlı barındırma hesapları, Ad tabanlıya aktarılacak.",
    'cl_perm__allow_client_create_domain' => "Seçmeye çalıştığınız alanlar ancak alan adı oluşturmasına izin verilen müşteriler tarafından kullanılabilir.",
    'cl_perm__allow_create_nb_w_ip' => "Müşteri, %1 kullanarak Ad tabanlı barındırma oluşturabilir",
    'cl_perm__allow_creation_ip_based_hosting' => "IP-tabanlı hosting hesabı açılmasına müsaade et",
    'cl_perm__available_ips' => "Müsait IP ler",
    'cl_perm__change_limits' => "Ayarlamayı sınırlar",
    'cl_perm__cl_disk_space' => "Toplam müsait Disk alanı",
    'cl_perm__cl_expiration' => "Müşteri hesabının geçerlilik dönemi",
    'cl_perm__cl_max_box' => "Posta kutuları",
    'cl_perm__cl_max_db' => "Veritabanları",
    'cl_perm__cl_max_dom' => "Alan Adları",
    'cl_perm__cl_max_maillists' => "Postalama listeleri",
    'cl_perm__cl_max_subdom' => "Alt alan adları",
    'cl_perm__cl_max_traffic' => "Toplam kalan Veri trafiği",
    'cl_perm__cl_max_wu' => "Web Kullanıcıları",
    'cl_perm__cl_mbox_quota' => "Bu kullanıcı hesabının posta kutusu boyutunun sınırı",
    'cl_perm__current_maximum_exp_date' => "Alan adı geçerlilik süresi maksimum değeri %1; %2 istendi.",
    'cl_perm__current_maximum_mailbox_quota' => "Bu kullanıcı hesabı altında posta kutusu barındırmak için ayrılan disk alanı miktarı için şu an tanımlı olan sınır %1; istenilen ise %2",
    'cl_perm__current_total_requested' => "%1 için alan adı sınırları geçerli toplam değeri %2; %3 istendi.",
    'cl_perm__current_total_requested_dom' => "Bu müşteriye ait geçerli %1 sayısı %2; istenen %3.",
    'cl_perm__disk_space' => "Maksimum Disk alanı",
    'cl_perm__dashboard_stdgui' => 'Kullanıcı arayüzü',
    'cl_perm__dashboard' => 'Başlangıç sayfası görünümü',
    'cl_perm__stdgui' => 'Standart görünüm',
    'cl_perm__manage_dashboard' => 'Başlangıç sayfası yönetimi',
    'cl_perm__dashboard_and_stdgui' => 'Başlangıç sayfası görünümüne ve standart görünüme izin verilir',
    'cl_perm__dashboard_only' => 'Sadece Başlangıç sayfası görünümüne izin verilir',
    'cl_perm__stdgui_only' => 'Sadece standart görünüme izin verilir',
    'cl_perm__edit_cl' => "Müşteri %1 izinleri",
    'cl_perm__exp_date_exceeded' => "Ayarlamaya çalıştığınız geçerlilik süresi, bu müşteriyle ilgili bireysel alan adları içinde belirtilen sınırı aşıyor.",
    'cl_perm__invalid_value' => "Geçersiz değer, sadece rakamlara izin verilir.",
    'cl_perm__limit_disk_space' => "%1 Toplam Disk alanına limit koy",
    'cl_perm__limit_expiration' => "%1 Müşteri hesabının geçerlilik dönemini sınırla",
    'cl_perm__limit_max_box' => "%1 Maksimum posta kutusu sayısına limit koy",
    'cl_perm__limit_max_db' => "%1 Maksimum Veritabanı sayısına limit koy",
    'cl_perm__limit_max_dom' => "%1 Maksimum alan adı sayısını sınırlayın",
    'cl_perm__limit_max_maillists' => "%1 Maksimum Mailing listesi sayısına limit koy",
    'cl_perm__limit_max_subdom' => "%1 Maksimum alt alan adı sayısını sınırlayın",
    'cl_perm__limit_max_traffic' => "%1 Maksimum Veri trafiği sayısına limit koy",
    'cl_perm__limit_max_wu' => "%1 Maksimum web kullanıcısı sayısına limit koy",
    'cl_perm__limit_mbox_quota' => "%1 Posta kutusu kotasını ayarlayın",
    'cl_perm__limits_exceeded' => "Ayarlamaya çalıştığınız bir veya daha fazla sınır, zaten bu müşteriye ait bireysel alan adlarında tanımlı sınırlarla aşılıyor.\nMüşteri için toplam sınırın, bu müşteri hesabı için tanımlanan alan adı sınırlarının genel toplamına eşit veya daha fazla olması gerekir.",
    'cl_perm__mailbox_quota_exceeded' => "Ayarlamaya çalıştığınız posta kutuları için ayrılmış disk alanı miktarındaki sınır, bu müşteri hesabıyla ilgili bireysel alan adları içinde tanımlı sınırı aşıyor.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Ayarlamaya çalıştığınız posta kutuları için ayrılmış disk alanı miktarındaki sınır, sunucu seviyesinde konulan sınırlamayı aşıyor.",
    'cl_perm__make_dumps' => "Verileri yedekleme ve geri yükleme",

    'cl_perm__max_box' => "Maksimum posta kutusu sayısı",
    'cl_perm__max_db' => "Maksimum Veritabanı sayısı",
    'cl_perm__max_dom' => "alan adları",
    'cl_perm__max_maillists' => "Maksimum Mailing Listesi sayısı",
    'cl_perm__max_subdom' => "alt alan adları",
    'cl_perm__max_traffic' => "maximum Veri trafiği",
    'cl_perm__max_wu' => "Maksimum web Kullanıcısı sayısı",
    'cl_perm__max_dom_aliases' => "takma alan adları",
    'cl_perm__mbox_quota' => "posta kutusu kotası",
    'cl_perm__not_allow_create_nb_hst' => "Müşteri, Ad tabanlı barındırma oluşturamaz.",
    'cl_perm__this_ip_used_vrt_hst' => "Bu IP adresi sanal barındırma tarafından kullanılır.\nBu IP adresini silmek, barındırma servisini kaldırmak veya tipini Ad tabanlı olarak değiştirmek için.",
    'cl_perm__unable_off_ipb_creating' => "Müşterinin zaten IP tabanlı barındırma servisi kurulumu var. Müşteri için bu özelliği devre dışı bırakmak için, \\\"Alan adı oluşturma\\\" onay kutusundaki işareti kaldırın veya tüm IP tabanlı barındırma hesaplarını kaldırın.",
    'cl_perm__unable_off_nb_creating' => "Müşterinin zaten Ad tabanlı barındırma servisi kurulumu var. Müşteri için bu özelliği devre dışı bırakmak için, \\\"Alan adı oluşturma\\\" onay kutusundaki işareti kaldırın veya tüm Ad tabanlı barındırma hesaplarını kaldırın.",
    'cl_perm__unable_set_domain_limit' => "Maksimum alan adı sayısı sınırlanamıyor: Müşterinin zaten %1 alan adı var",
    'cl_perm__unable_update_client_limitations' => "Müşteri hesabının sınırları değiştirilemiyor: %1",
    'cl_pref__edit_cl' => "Müşterinin%1 tercihleri",
    'class_anonftp__create_ftp_domain' => "Bu dom_id için hiçbir sanal FTP alan adı yok, önce onu oluşturmayı deneyin.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Ayarlamaya çalıştığınız disk alanı sınırının (%1), alan adı seviyesinde (%2) tanımlanan toplam disk alanı sınırını aşmaması gerekir.",
    'class_anonftp__invalid_input_only_digits' => "Geçersiz değer, sadece rakkam giriniz",
    'class_anonftp__unable_change_ownerships' => "kota dosyası için sahibi ya da izinleri değiştirilemiyor: %1",
    'class_anonftp__unable_copy_quota_file' => "Kota dosyalarının kopyası alınamıyor: %1",
    'class_anonftp__unable_get_disk_usage' => "Gelen dizinde disk kullanım bilgileri alınamıyor: %1",
    'class_anonftp__unable_parse_quota_file' => "Kota dosyası içeriği algılanamıyor.",
    'class_anonftp__unable_read_quota_file' => "Kota dosyası okanamıyor: %1",
    'class_anonftp__unable_update_quota' => "Kota Güncelleme işlemi gerçekleştirilemedi: Geliş dizininde %1 KB Disk alanı bulunmaktadır, bu değer atamak istediğiniz değerden yüksek",
    'class_anonftp__unable_write_temp_file' => "Geçici dosyaya yazılamıyor: %1",
    'class_bsdomain__warn_max_date__' => "Son kullanım tarihi %1 olarak ayarlandı",
    'class_client__client_creation_notification' => "Müşteri oluşturma uyarısı.",
    'class_client__client_with_contact_name_already_exists' => "Adı %1 olan bir müşteri zaten var.",
    'class_client__disk_space' => "Disk alanı",
    'class_client__invalid_max_dom' => "Geçersiz alan adı değeri, sadece basamaklara izin verilir.",
    'class_client__limit_exceed' => "İstediğiniz %1 miktarı ayrılamaz, çünkü bu, müşteri %2 hesabı (%3) için ayrılanları aşar.  Daha fazla kaynak ayırmak istiyorsanız, Müşteriler > Müşteri adı > Sınırlar altına gidin ve ayırmaları gerektiği şekilde değiştirin.  Sonra bu ekrana dönün ve ayırmaları tekrar ayarlamayı deneyin.",
    'class_client__limit_exceed_unlimited' => "Sınırsız miktarda kaynak (%1) ayırmak istiyorsanız, önce Müşteriler > Müşteri adı > Sınırlara gitmeniz ve gerekli kaynak tipine tekabül eden Sınırsız onay kutusunu işaretlemeniz gerekir. Sonra bu ekrana dönün ve ayırmaları tekrar ayarlamayı deneyin.",
    'class_client__max_box' => "Posta kutuları",
    'class_client__max_db' => "Veritabanları",
    'class_client__max_maillists' => "Postalama listeleri",
    'class_client__max_subdom' => "Alt alan adları",
    'class_client__max_traffic' => "Maksimum Veri trafiği",
    'class_client__max_wu' => "Web Kullanıcıları",
    'class_client__max_dom_aliases' => "Takma alan adları",
    'class_client__mbox_quota' => "Posta kutusu kotası",
    'class_client__unable_define_cl_status' => "Müşteri hesabının durumu tanımlanamıyor: %1",
    'class_client__unable_define_inactive_dom' => "Etkin olmayan %1 alan adları tanımlanamıyor.",
    'class_client__unable_del_ip' => "IP Adresleri kaldırılamadı: %1",
    'class_db__db_name_not_set' => "Veritabanı adı tanımlanmamış.",
    'class_db__db_not_exist_for_curr_dom' => "Bu alan adı için veritabanı yok.",
    'class_db__invalid_db_or_dom_name' => "Alan adı veya veritabanı kimliği geçersiz veya veritabanı adı tanımlanmamış.",
    'class_db__invalid_pass' => "Şifre geçerli değil.",
    'class_db__mailgrp_member_exist' => "The Mail grup member sistemde mevcut.",
    'class_db__access_hosts_notsupport' => 'Bu veritabanı tipi için ana bilgisayar ayarına erişim desteklenmiyor',
    'class_db__unable_add' => 'Ana bilgisayar kaydı erişimi eklenmiyor: %1',
    'class_db__unable_del' => 'Ana bilgisayar kaydı erişimi silinemiyor: %1',
    'class_db__inc_user_not_exist' => 'Veritabanı kullanıcısı "%1" yok',
    'class_db__inc_access_record_exist' => 'Bu erişim kaydı zaten var',
    'class_db__inc_access_record_not_exist' => 'Verilen erişim kaydı yok',
    'class_db__inc_unable_del_last_record' => 'Son erişim ana bilgisayar kaydı silinemiyor',
    'class_domtmpleditform__dns_master' => "Birincil",
    'class_domtmpleditform__dns_slave' => "İkincil",
    'class_domtmpleditform__dns_type' => "Alan adı DNS bölgesi tipi",
    'cmd_dns__a_dns_record_already_exist' => "Bu kayıt, bölgesi için yapışkan A kaydıyla çakışır.",
    'cmd_dns__domain_last_ns' => 'Alan adı için son NS DNS kaydı silinemiyor.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kural alan adı geçersiz.",
    'cmd_dns__cname_dns_record_already_exist' => "Bu kayıt, bölgesi için yapışkan CNAME kaydıyla çakışır.",
    'cmd_dns__cname_in_rr_combination' => 'DNS bölgesinde DNS kayıtlarının yanlış kombinasyonu var',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS bölge kaydı, aynı bölgedeki diğer DNS kayıtlarıyla birlikte var olamaz.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS kaydı tipi geçersiz.",
    'cmd_dns__ext_host_is_not_resolved' => "Kural adı %1, A veya AAAA kaydına çözümlenmez.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => '%1 kaydı %2 bölgesine eklenemedi: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Mail exchanger adı geçerli değil.",
    'cmd_dns__mx_priority_is_invalid' => "MX önceliği geçersiz.",
    'cmd_dns__name_server_is_invalid' => "Ad sunucusu geçersiz.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Ağ maskesinin değeri 24, 16 veya 8 olmalıdır.",
    'cmd_dns__this_dns_record_already_exists' => "Böyle bir A DNS kaydı zaten var.",
    'cmd_dns__unable_add_record' => "'%1' kaydı eklenemiyor: %2",
    'cmd_dns__unable_add_a_record' => "A kaydı eklenemiyor: %1",
    'cmd_dns__unable_add_cname_record' => "CNAME kaydı eklenemiyor: %1",
    'cmd_dns__unable_add_dns_record' => "DNS kaydı eklenemiyor: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "EXT_NS kaydı eklenemiyor: %1",
    'cmd_dns__unable_add_ns_record' => "NS kaydı eklenemiyor: %1",
    'cmd_dns__unable_add_ptr_record' => "PTR kaydı eklenemiyor: %1",
    'cmd_dns__unable_add_txt_record' => "TXT kaydı eklenemiyor: %1",
    'cmd_dns__unable_create_dns_zone' => "DNS zone Oluşturma işlemi gerçekleştirilemedi %1",
    'cmd_dns__unable_define_dns_record' => "DNS kaydı %1 tanımlanamıyor.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Varsayılan DNS zone durumu görüntülenemiyor: %1",
    'cmd_dns__unable_insert_a_record' => "A kaydı eklenemiyor: %1",
    'cmd_dns__unable_insert_mx_record' => "MX kaydı eklenemiyor: %1",
    'cmd_dns__unable_insert_ns_record' => "NS kaydı eklenemiyor: %1",
    'cmd_dns__unable_set_dns_zone_status' => "DNS zone durumu ayarlanamıyor: %1",
    'cmd_domains__dom_already_exists' => "Alan adı %1 zaten var.",
    'cmd_domains__dns_record_already_exists' => "%1 alan adı oluşturulamıyor, çünkü ana bilgisayara %1 işaret eden bir DNS kaydı zaten var.",
    'cmd_domains__dom_already_exists1' => "Bu alan adında toplam %2 alt alan adı var. Alan adı %1 zaten var.",
    'cmd_domains__dom_already_exists2' => "alt alan adı %1 zaten var.",
    'cmd_domains__dalias_already_exists' => "Bu takma adı zaten var.",
    'cmd_domains__domain_alias_already_exists' => 'Adı böyle olan bir takma alan adı zaten var.',
    'cmd_domains__unable_del_mail_for_dom' => "Alan adının posta servisleri silinemiyor: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Alan adının anonim FTP hesabı silinemiyor: %1",
    'cmd_domains__unable_update_dom_param' => "Alan adı parametreleri güncellenemiyor: %1.",
    'cmd_domains__unable_rename_client_exist' => "alan adı yöneticisinin kullanıcı adı zaten kullanımda.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Hosting tipi fiziksel değil.",
    'cmd_hosting__unable_create_user' => "Kullanıcı yaratılamıyor %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Ad-tabanlı hostlara IP adres tanımlanamıyor: %1",
    'cmd_hosting__unable_del_old_hst' => "Önceden ayarlanmış barındırma silinemiyor: %1",
    'cmd_hosting__unable_del_protected_directory' => "Korunmuş dizin silinemiyor: %1.",
    'cmd_hosting__unable_del_web_user' => "Web kullanıcıları silinemiyor: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Virtual Host yaratılamaıyor ya da güncellenemiyor: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Frame içinde yönlendirme hosting oluşturulamadı.",
    'cmd_hosting__unable_rebuild_ftp_config' => "proftpd yapılandırma dosyası yeniden oluşturulamıyor: %1.",
    'cmd_hosting__unable_set_up_ssl' => "SSL/TLS ayarlanamıyor: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "SSL/TLS dizinden koruma kaldırılamıyor: %1",
    'cmd_hosting__unable_update_dest_url' => "Güncelleme işlemi gerçekleştirilemedi %1",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Alan adının DNS bölgesi güncellenemiyor: Yardımcı programı yürütme başarısız oldu.",
    'cmd_hosting__unable_update_ftp_passwd' => "FTP şifre Güncelleme işlemi gerçekleştirilemedi %1",
    'cmd_hosting__unable_update_user' => "Kullanıcı güncellenemiyor %2: %1",
    'cmd_hosting__unknown_hst_type' => "Bilinmeyen hosting tipi.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Hosting servisini kapatmak için yetkiniz yok.",
    'cmd_mail__autoresponder__not_configured' => "Bu posta hesabı için otomatik yanıt yapılandırılmamış",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Posta iletme için zaten %1 adresi kullanılıyor.",
    'cmd_mail__alias_already_exists' => "Takma isim sistemde mevcut.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Otomatik yanıt kimliği ile posta hesabı kimliği eşleşmiyor.",
    'cmd_mail__autoresp_id_is_undefined' => "Otomatik Yanıt Kimliği tanımlanmamış.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "%1 posta hesabı için adı böyle olan posta takma adı zaten var.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Posta hesabı %1, zaten bu postalama listesine abone.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Posta hesabı %1, bu alan adında zaten var.",
    'cmd_mail__mail_name_not_exist' => "Posta hesabı yok.",
    'cmd_mail__mail_name_passwd_part' => "Şifrenin bir parçasının, posta hesabı adından oluşmaması gerekir.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Postalama listesi %1, bu alan adında zaten var.",
    'cmd_mail__mailname_already_exist_in_mg' => "Posta hesabı %1, bir posta grubunda zaten var.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Posta hesabı %1, bu alan adında zaten var.",
    'cmd_mail__mailname_already_exists' => "Posta hesabı zaten var.",
    'cmd_mail__mailname_is_invalid' => "Posta hesabı adı %1 geçersiz.",
    'cmd_mail__mailname_unable_update' => "Posta hesabı özellikleri güncellenemiyor:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Bu alan adı için maksimum otomatik yanıt sayısına ulaşıldı.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Bu alan adı için maksimum posta grubu sayısına ulaşıldı.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Bu alan adı için maksimum iletici sayısına ulaşıldı.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Maksimum posta kutusu sayısına ulaşıldı.",
    'cmd_mail__no_members_specified' => "hiçbir üte belirtilmedi.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Şifre çok basit başka bir şifre seçiniz.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Bu e-posta adresi zaten kullanılıyor.",
    'cmd_mail__unable_define_autoresp_id' => "Otomatik yanıt kimliği %1 tanımlanamıyor.",
    'cmd_mail__unable_update_mail_for_dom' => "%1 alan adı için posta servis ayarları değiştirilemedi",
    'cmd_mail__unable_del_mail_for_dom' => "Posta servisi %1 alan adından kaldırılamıyor.",
    'cmd_mail__unable_del_mail_redirection' => "Posta iletme servisi %1 kaldırılamıyor.",
    'cmd_mail__unable_remove_autoresp' => "Otomatik yanıtlar kaldırılamıyor: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Mail grup üyeleri kaldırılamıyor: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Posta grubunu kapatma başarısız oldu: %1",
    'cmd_mail__unable_update_mail_redirect' => "Posta iletme servisi %1 yeniden yapılandırılamıyor.",
    'cmd_mail__uploaded_file_is_too_big' => "Yüklenen dosya boyutu çok büyük.",
    'cmd_mail__additionally' => "Ayrıca:",
    'cmd_pd__invalid_login' => "Yanlış kullanıcı adı.",
    'cmd_pd__this_user_already_exist' => "Böyle bir kullanıcı zaten var.",
    'cmd_pd__unable_define_hst_type' => "Hosting tipi tanımlama işlemi gerçekleştirilemedi.",
    'cmd_pd__unable_upd_pd_usr' => "Korunmuş dizin kullanıcısı özellikleri güncellenemiyor: %1.",
    'cmd_pd__user_is_undefined' => "Kullanıcı tanımlı değil.",
    'cmd_server__no_enough_free_disk_space' => "Yeterli Disk alanı yok.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "eski şifre yanlış. Lütfen yeniden deneyin.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "bu alan adı için maksimum web kullanıcısı sınırına ulaşıldı.",
    'cmd_web_usr__unable_create_user' => "sistem Kullanıcısı Oluşturma işlemi gerçekleştirilemedi: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Maksimum web Kullanıcısı limit Tanımlama işlemi gerçekleştirilemedi: %1",
    'cmd_web_usr__user_already_exists' => "Kullanıcı sistemde mevcut.",
    'cmd_web_usr__web_user_name_is_invalid' => "web kullanıcı adı %1 geçerli değil.",
    'cmd_web_usr__web_user_not_exist' => "web Kullanıcısı mevcut değil.",
    'common_func__exec_bad_argument' => "exec argümanı tek tırnakla kullanılmamalı.",
    '__eol' => 'Satır sonları',
    'eol__binary_file' => 'İkili dosyada satır sonu stili değiştirilemiyor.',
    'cp_access_admin_deny' => "'%1' adresinden erişim IP erişim kuralları çerçevesinde engellenmiş durumda.",
    'create_domain_warn__' => "Alan adını oluşturma sırasında aşağıdaki istisnalar yapıldı:",
    'create_domain__client_select' => 'Alan adını oluşturmak istediğiniz müşteriyi seçin',

    'dashboard__nav_button_name' => "Anasayfa",
    'dalias__list_title' => '%1 alan adının takma alan adları',
    'dalias__list_legend' => 'Takma alan adları',
    'dalias__list_header' => 'Takma alan adları',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Takma alan adı',
    'dalias__list_ascii_name' => 'ASCII biçiminde',
    'dalias__remove_title' => '%1 alan adının aşağıdaki takma alan adları kaldırılacak:',
    'dalias__select_domain_aliases_to_remove' => 'Kaldırılacak takma alan adlarını seçin.',
    'dalias__mail_turn_on_failed' => 'Posta servisi açılamıyor: %1',
    'dalias__web_turn_on_failed' => 'Web servisi açılamıyor: %1',
    'db_usr_edit__db_usr_name_old' => "Eski veritabanı kullanıcı adı",
    'database_server_edit_form__cannot_infer_type' => 'Belirtilen verilerden bağlantı yöntemi çıkarılamıyor. Belirtilen bağlantı noktası ile TCP/IP üzerinden bağlanmak için veritabanı sunucusu ana bilgisayar adı olarak "127.0.0.1" girin veya "%1" Unix soketini kullanmak için bağlantı noktası alanını boş bırakın.',
    'database_server_edit_form__duplicate' => 'Bu host adresi ve port numarasının bu kombinasyonu olan bir veritabanı sunucusu zaten kayıtlı.',
    'database_server_edit_form__host_is_invalid' => 'Belirtilen ana bilgisayar adı geçerli değil.',
    'database_server_edit_form__port_is_invalid' => 'Belirtilen bağlantı noktası numarası geçerli değil.',
    'database_server_error__consult_admin' => 'Lütfen sunucu yöneticisiyle bağlantı kurun.',
    'database_server_error__last__connection_failed' => 'Ağ sorunlarından dolayı, bu veritabanı sunucusunu kontrol etmek için son girişim başarısız oldu.',
    'database_server_error__last__permission_denied' => 'Bu veritabanı sunucusunu kontrol etmek için son girişim başarısız oldu, çünkü sağlanan hesap yönetici önceliklerine sahip değil.',
    'database_server_error__last__credentials_not_set' => "Bu sunucuya bağlanma konusundaki son deneme başarısız oldu, çünkü geçerli hiçbir yönetici kullanıcı adı ve şifresi belirtilmemiş.",
    'database_server_error__last__other_error' => 'Bu veritabanı sunucusunu kontrol etmek için son girişim başarısız oldu.',
    'database_server_error__real__connection_failed' => 'Ağ sorunlarından dolayı veritabanı sunucusuna bağlantı başarısız oldu:',
    'database_server_error__real__permission_denied' => 'Veritabanı sunucusuna bağlantı başarısız oldu, sağlanan hesap yönetici önceliklerine sahip değil:',
    'database_server_error__real__duplicate_object' => 'Veritabanı sunucusuna bağlantı isim uyuşmazlığı yüzünden başarısız oldu:',
    'database_server_error__real__unacceptable_name' => 'Veritabanı sunucusuna bağlantı geçersiz nesne adı yüzünden başarısız oldu:',
    'database_server_error__real__unacceptable_password' => 'Kabul edilemeyecek bir şifre yüzünden veritabanı sunucusuyla bağlantı kurulamadı:',
    'database_server_error__real__credentials_not_set' => "Plesk, veritabanı sunucusuna bağlanamıyor, çünkü geçerli hiçbir yönetici kullanıcı adı ve şifresi belirtilmemiş.",
    'database_server_error__real__other_error' => 'Veritabanı sunucusuna bağlantı başarısız:',
    'database_server_error__test__connection_failed' => 'Ağ sorunlarından dolayı veritabanı sunucusuna test bağlantı başarısız oldu:',
    'database_server_error__test__permission_denied' => 'Veritabanı sunucusuna test bağlantısı başarısız oldu, çünkü sağlanan hesap, yönetici önceliklerine sahip değil:',
    'database_server_error__test__duplicate_object' => 'Veritabanı sunucusuna test bağlantısı ad çakışması yüzünden başarısız oldu:',
    'database_server_error__test__unacceptable_name' => 'Veritabanı sunucusuna test bağlantısı geçersiz nesne adı yüzünden başarısız oldu:',
    'database_server_error__test__unacceptable_password' => 'Veritabanı sunucusuna test bağlantısı, kabul edilmeyen bir şifre yüzünden başarısız oldu:',
    'database_server_error__test__credentials_not_set' => "Bu sunucuyla yapılan test bağlantısı, geçerli hiçbir yönetici kullanıcı adı ve şifresi belirtilmediğinden başarısız oldu.",
    'database_server_error__test__other_error' => 'Veritabanı sunucusuna test bağlantısı başarısız oldu:',

    'db__create_new_db' => "Bir Veritabanı Ekle",
    'db__db_add' => "Veritabanı Ekle",
    'db__db_for_dom' => "Web Sitesi %1 Veritabanları",
    'db__db_id_undefined' => "Veritabanı id si tanımlı değil.",
    'db__db_name' => "Veritabanı adı",
    'db__db_not_exist' => "Veritabanı mevcut değil.",
    'db__db_type' => "Tür",
    'db__db_server' => "Veritabanı Sunucusu",
    'db_server_not_exist' => "Veritabanı sunucusu yok.",
    'db__db_user_not_exist' => "Veritabanı Kullanıcısı mevcut değil.",
    'db__domain_not_exist' => "Alan adı yok.",
    'db__enter_db_name' => "Veritabanı adını giriniz.",
    'db__invalid_db_id' => "Veritabanı identifier geçerli değil.",
    'db__invalid_db_name' => "Veritabanı adı geçersiz.  Veritabanı adının sadece Latin alfabesi simgeleri, rakamlar, alt çizgi veya çizgi içermesi gerekir.  63 simgeden uzun olamaz.",
    'db__max_db_reached_for_dom' => "Bu alan adı için veritabanı sayısının sınırına ulaşıldı.",
    'db__max_mssql_db_reached_for_dom' => "Bu alan adı için Microsoft SQL Server veritabanı sayısının sınırına ulaşıldı",
    'db__postgres_not_connect_for_admin' => "PostgreSQL'e bağlanılamıyor. Sunucunun yönetim sayfasında PostgreSQL desteğini açın.",
    'db__postgres_not_connect_for_client' => "PostgreSQL'e bağlanılamıyor. Yardım için sistem yöneticinize danış.",
    'db__remove_db_on_domain' => "%1 müşterisine ait olan %2 web sitesi altındaki aşağıdaki veritabanları kaldırılacak:",
    'db__remove_db_on_domain_of_cl' => "%1 müşterisine ait olan %2 alan adı için aşağıdaki veritabanları kaldırılacak:",
    'db__remove_db_linked_resource' => 'Bu veritabanı bir web uygulaması tarafından kullanımda.  Ancak bu web uygulaması kaldırıldıktan sonra kaldırılabilir.',
    'db__remove_db_users' => "%1 müşterisine ait olan %2 web sitesi altındaki %3 veritabanının aşağıdaki kullanıcıları kaldırılacak:",
    'db__remove_db_users_of_cl' => "%1 müşterisine ait olan %2 web sitesi altındaki %3 veritabanının aşağıdaki kullanıcıları kaldırılacak:",
    'db__select_db_for_remove' => "Silmek için Veritabanı seçiniz.",
    'db__select_db_users_for_remove' => "Silmek için Veritabanı Kullanıcısı seçiniz.",
    'db__unable_create_db_user' => "Veritabanı kullanıcısı yaratılamıyor: %1",
    'db__unable_define_db_name' => "Veritabanı adı tanımlanamıyor: %1",
    'db__unable_define_db_user' => "Veritabanı kullanıcısı tanımlanamıyor: %1",
    'db__unable_define_db_users' => "Veritabanı kullanıcıları tanımlanamıyor: %1",
    'db__unable_select_dom_name' => "Alan adı seçilemiyor: %1",
    'db_edit__db_for_dom' => "Alan adı %2 üzerindeki veritabanı %1 kullanıcıları",
    'db_edit__invalid_db_name' => "The Veritabanı adı geçerli değil.",
    'db_edit__no_users' => "Bu Veritabanı için yetkilendirilmiş kullanıcı yok.",
    'db_edit__unable_define_db_usrs' => "Veritabanı kullanıcıları tanımlanamıyor: %1",
    'db_edit__unable_select_db_usr' => "Veritabanı Kullanıcısı Seçilemiyor.",
    'db_edit__db_user_password_for_' => "Lütfen veritabanı kullanıcısı %1 olarak oturum açmak için şifreyi girin",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Veritabanı kullanıcısı ekleyin",
    'db_usr_edit__db_usr_name' => "Veritabanı kullanıcı adı",
    'db_usr_edit__edit_db_usr' => "Veritabanı kullanıcı hesabı için kimlik bilgilerini ayarlayın",
    'db_usr_edit__for_db' => "%1 veritabanında",
    'db_usr_edit__not_create_pass' => "Bu işlem, şifresiz bir veritabanı kullanıcı hesabı oluşturmaya neden olur.\nBir şifre atamadan bir kullanıcı oluşturmak istiyor musunuz?",
    'dbuser__only_one_user_can_be_default' => "Sadece bir kullanıcı varsayılan olarak ayarlanabilir.",
    'db_server__cannot_delete_default' => "Varsayılan veritabanı sunucusu silinemez.",
    'db_server__cannot_delete_local' => "Yerel veritabanı sunucusu silinemez.",
    'db_server__cannot_delete_used' => 'Üzerinde barındırılan veritabanları veya veritabanı kullanıcıları varken bir veritabanı sunucusu silinemez.',
    'demo__disabled_in_demo' => "Bu işlem demo sürümde desteklenmiyor.",
    'defaultcomponents__title' => "3. parti bileşenler",
    'defaultcomponents__select_default' => "Varsayılan %1 bileşenini seçin", //to check
    'defaultcomponents__not_installed' => "(kurulu değil)",
    'defaultcomponents__not_configured' => "(yapılandırılmamış)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Bazı bölümler geçersiz seçim içeriyor.",
    'defaultcomponents__depends_on' => "(%1 gerekiyor)",
    'defaultcomponents__parameters' => "%1 Parametreleri",
    'component_name__antivirus' => "Antivirüs",
    'component_name__database' => "SQL Sunucu",
    'component_name__sqladmin' => "MySQL Webadmin'i",
    'component_name__sqladminmysql' => "MySQL Webadmin'i",
    'component_name__dnsserver' => "DNS Sunucusu",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "FTP Sunucusu",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Posta Sunucusu",
    'component_name__local_mailserver' => "Yerel Posta Sunucusu",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web Komut Dosyası",
    'component_name__spamfilter' => "İstenmeyen Posta Filtresi",
    'component_name__stats' => "Web İstatistikleri",
    'component_name__stunnel' => "SSL/TLS Sarıcı",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Web yayınlama",
    'component_name__webserver' => "Web Sunucusu",
    'dns__dns_record_invalid_values' => 'Yanlış DNS kaydı değerleri belirtildi: %1: %2',
    'dns__dns_record_not_found' => 'DNS kayıdı bulunamadı',
    'dns__dns_zone_invalid_values' => 'Yanlış DNS bölgesi parametreleri belirtildi.',

    'dns__soa_mname_title' => 'Birincil Ad Sunucusu',
    'dns__soa_mname_legend' => 'İsim Sunucusu',
    'dns__soa_mname_autoselect' => '(Otomatik seçim)',

    'dns__dns_zone_off_remove_title' => "Aşağıdaki kaynak kayıtları %1 bölgesinden kaldırılacak:",
    'dns__dns_zone_master_remove_title' => "Kaynak Kaydını %1 DNS Bölgesinden Kaldırma",
    'dns__dns_zone_slave_remove_title' => "%1 için aşağıdaki birincil ad sunucusu kayıtları silinecek:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Kayıt dizinini girin',
    'dns_add__is_spf_syntax' => 'SPF kaydı',
    'dns_add__spf_value_is_invalid' => "SPF değeri hatalı, 'v=spf' şeklinde başlamalı",
    'dns__dns_zone_status' => "DNS zone durumu.",
    'dns__invalid_ip_address' => "Yeni birincil DNS Sunucusu IP Adresi geçerli değil veya boş.",
    'dns__ip_address' => "IP adresi",
    'dns__master_dns_type' => "bir birincil DNS sunucusudur",
    'dns__masters' => "birincil DNS sunucuları",
    'dns__soa_minimum_too_large' => 'Olumsuz yanıtların üç saatten fazla önbelleğe alınması önerilmez.',
    'dns__select_masters_to_remove' => "Kaldırılacak birincil DNS sunucularını seçin.",
    'dns__select_template_record_to_remove' => 'Kaldırılacak DNS şablon kayıtlarını seçin.',
    'dns__nameservers_for_domain' => "Alan adı için ad sunucuları",
    'dns__remove_dns_zone_of_domain__' => "%1 alan adından DNS kayıtlarını kaldırma",
    'dns__remove_dns_zone_template__' => "Aşağıdaki DNS kayıtları şablondan kaldırılacak:",
    'dns__remove_this_dns_record?' => "Bu DNS kaydını silmek istediğinize emin misiniz?",
    'dns__restore_default' => "DNS zone şablona göre geri kuruluyor",
    'dns__restore_default_confirm' => "DNS bölgesini geri yüklemek, geçerli DNS bölgesi yapılandırmasını göz ardı eder. Yine de devam edilsin mi?",
    'dns__restore_default_error' => "DNS zone gerikurma işlemi esnasında hata oluştu:",
    'dns__slave_dns_type' => "ikincil DNS sunucusu",
    'dns__subdomain_dns_rec_removed' => "A kaydı, %1 alt alan adı bölgesinden kaldırıldı.",
    'dns__zone_switched_off_no_ns' => "Bölgede varolması gereken NS kaydı %1 olmadığından, bölge kapandı. Kaydı bölgeye eklemek için, Kaydı Ekleyin düğmesini tıklatın.",
    'dns__cant_switch_on_no_ns' => "Bölgede varolması gereken NS kaydı %1 olmadığından, bölge açılamıyor.  Kaydı bölgeye eklemek için, Kaydı Ekleyin düğmesini tıklatın.",
    'dns__unable_activate/deactivate_dns' => "DNS aktif/pasif yapılamıyor: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Birincil DNS sunucusu eklenemiyor: bu sunucu sistemde mevcut.",
    'dns__unable_add_dns_master_local_ip' => "Birincil DNS sunucusu için IP adresi eklenemiyor: bu kaydın uzak bir sunucuda oluşturulması gerekir.",
    'dns__unable_define_dns_record' => "DNS kaydı tanımlanamıyor: %1",
    'dns__unable_get_dns_template_status' => "DNS Şablonu durumu bilgileri bulunamıyor.",
    'dns__unable_remove_dns_rec' => "DNS kaydı kaldırılamıyor: %1",
    'dns__warnings__' => "DNS zone güncelleme sonucu:",
    'dns__you_not_have_perm_manage_dns' => "Bu alan adının DNS bölgesini yönetme izniniz yok.",
    'dns__cant_create_record_with_server_ip' => "Bu Plesk'le yönetilen sunucunun IP adresiyle eşleştiğinden, bu IP adresi eklenemiyor.",

    'dns__tabs_acl' => "Bölge Aktarmaları",
    'dns__acl_add_network_legend' => "Ağ Ekle",
    'dns__acl_add_ip_legend' => "IP Adresi Ekle",
    'dns__acl_network_not_allowed' => "Windows'ta DNS tarafından bu ağ adresine izin verilmez.",
    'dns__acl_enter_ip_address_with_mask' => "IP Adresi/maske",
    'dns__acl_enter_ip_address' => "IP Adresi",
    'dns__acl_list_network_legend' => "Ağların, DNS bölgesinin bir kopyasını almasına izin verildi",
    'dns__acl_list_ip_legend' => "IP adreslerinin, DNS bölgesinin bir kopyasını almasına izin verilir",
    'bt_dns_acl_add_network' => "Ağ Ekle",
    'bt_dns_acl_add_ip' => "IP Adresi Ekle",

    'dns_add__add_rec_for_zone' => "%2 zonu için %1 ekle",
    'dns_add__canonical_dom_name_is_invalid' => "Kural alan adı geçersiz.",
    'dns_add__enter_canonical_name' => "Kural ad",
    'dns_add__enter_dom_name' => "Alan adı",
    'dns_add__enter_ip_address' => "IP Adresi",
    'dns_add__enter_ip_mask' => "IP adresi ve ağ maskesi",
    'dns_add__enter_mail_domain' => "Posta alan adı",
    'dns_add__enter_mail_exchanger' => "Mail exchange sunucusu",
    'dns_add__enter_nameserver' => "İsim Sunucusu",
    'dns_add__enter_txt_record' => "TXT kaydı",
    'dns_add__enter_service_name' => "Hizmet adı",
    'dns_add__hint_service_name' => "Örnek: SIP (altı çizili sembol olmadan)",
    'dns_add__enter_protocol' => "İletişim Kuralları",
    'dns_add__hint_protocol_name' => "Örnek: TCP (altı çizili sembol olmadan)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Öncelik",
    'dns_add__specify_weight_of_service' => "Aynı önceliğe sahip kayıtlar için göreli ağırlık",
    'dns_add__enter_target_host' => "Hedef ana bilgisayar",
    'dns_add__hint_target_host' => "Örnek: example.com",
    'dns_add__enter_target_port' => "Hedef bağlantı noktası",
    'dns_add__caa_tag' => "Etiket",
    'dns_add__caa_value' => "Değer",
    'dns_add-invalid-A_ip' => "IP adresi geçerli değil.",
    'dns_add-invalid-AAAA_ip' => "IP adresi geçerli değil.",
    'dns_add-invalid-PTR_ip_mask' => "Geçersiz IP Adresi/netmask çifti.",
    'dns_add-invalid-SRV_service_name' => "Geçersiz hizmet adı",
    'dns_add-invalid-SRV_protocol_name' => "Geçersiz protokol",
    'dns_add-invalid-SRV_target_port' => "Geçersiz hedef portu",

    'dns_add__invalid_ip' => "IP adresi geçerli değil.",
    'dns_add__low' => "düşük",
    'dns_add__mail_dom_name_is_invalid' => "Posta alan adı geçersiz.",
    'dns_add__nameserver_is_invalid' => "Ad sunucusu geçersiz.",
    'dns_add__record' => "%1 kaydı",
    'dns_add__select_prefer_for_mail_exchange_server' => "Mail exchange sunucusunun önceliğini belirtin",
    'dns_add__unable_insert_new_dns_rec' => "Yeni DNS kaydı eklenemiyor: %1",
    'dns_add__very_high' => "çok yüksek",
    'dom_ctrl__allowed' => "İzin verildi",
    'dom_ctrl__db' => "MariaDB/MySQL Veritabanları",
    'dom_ctrl__mssql_db' => "MS SQL Veritabanı",
    'dom_ctrl__disk_space' => "Disk alanı",
    'dom_ctrl__dom_adm' => "Alan adı %1 / %2",
    'dom_ctrl__dom_cl' => "Alan adı %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Alan adında, tanımlanmamış iletme URL'siyle iletme ayarlanmış",
    'dom_ctrl__domain_has_frame_forwarding' => "Alan adının %1 URL'sine çerçeve iletmesi var",
    'dom_ctrl__domain_has_no_hosting' => "Alan adının yapılandırılmış barındırması yok",
    'dom_ctrl__domain_has_physical_hosting' => "IP adresi %1 üzerindeki bu alan adı için web barındırması yapılandırılmıştır",
    'dom_ctrl__domain_has_standard_forwarding' => "Alan adının %1 URL'sine standart iletmesi var",
    'dom_ctrl__maillists' => "Postalama listeleri",
    'dom_ctrl__mboxes' => "Posta kutuları",
    'dom_ctrl__mg' => "Posta yönlendirmeleri",
    'dom_ctrl__resource_name' => "Kaynak",
    'dom_ctrl__resp' => "Otomatik yanıtlar",
    'dom_ctrl__subdom' => "Alt alan adları",
    'dom_ctrl__dom_aliases' => "Takma alan adları",
    'dom_ctrl__traffic' => "Trafik",
    'dom_ctrl__unable_activate/deactivate_dom' => "Alan adı etkinleştirilemiyor/devre dışı bırakılamıyor: %1",
    'dom_ctrl__used' => "Kullanılmış",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Web Kullanıcıları",
    'dom_pref__bounce_with_phrase' => "Mesajla sıçra",
    'dom_pref__bounce' => "Geri dönder",
    'dom_pref__catch_addr' => "Adrese ilet",
    'dom_pref__reject' => 'Reddet',
    'dom_pref__confirm_domain_removing' => "Lütfen alan adı ziyaretçilerine alan adı değişikliğini bildirmeyi unutmayın. Alan adını yeniden adlandırmak istediğinizden emin misiniz?",
    'dom_pref__db_inconsystency' => "Veritabanı kararsız.",
    'dom_pref__dbs' => "Veritabanları",
    'dom_pref__delete_traffic_stat' => "Web ve trafik istatistiklerini sakla",
    'dom_pref__delete_traffic_stat_older' => "Web ve trafik istatistiklerini sakla",
    'dom_pref__dom_level_name_conflict' => "Alan adı yöneticisinin kullanıcı adı, müşterilerden birinin bir kullanıcı adıyla çakışıyor.",
    'dom_pref__invalid_disk_space_limit' => "Geçersiz disk alanı sınırı. En büyük değer: %1",
    'dom_pref__invalid_expiration_date_limit' => "Geçersiz geçerlilik süresi.",
    'dom_pref__invalid_max_traffic_limit' => "Geçersiz trafik sınırı. En büyük değer: %1",
    'dom_pref__limits_of_dom' => "Alan adı %1 sınırları",
    'dom_pref__mail_grps' => "e-posta grupları",
    'dom_pref__mail_nonexistent_user' => "Varolmayan kullanıcılara gönderilen posta ne yapılmalı",
    'dom_pref__mail_redirs' => "posta ileticileri",
    'dom_pref__mail_resps' => "posta otomatik yanıtları",
    'dom_pref__max_limit_is_invalid' => "%1 geçerli değil.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maksimum sayısı %1 geçerli değil.",
    'dom_pref__new_limit_less_currently_used' => "%1: telp edilen - %2, kullanılan - %3",
    'dom_pref__older_that' => "için",
    'dom_pref__postboxes' => "posta kutuları",
    'dom_pref__preferences_of_dom' => "Alan adı %1 ayarları",
    'dom_pref__redirect_to_itself' => "Alan adının iletmesi, kendisine ayarlıdır",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Alan adı trafik istatistiklerini saklama süresinin, sunucu için tanımlanan toplam değerden (%1 ay) daha az olmasını belirttiniz. İstatistikleri saklama süresi, sunucunun (%1 ay) varsayılan değerine eşit olarak ayarlanır.",
    'dom_pref__unable_add_www_prefix_in_dom' => "Alan adına bir www öneki eklenemiyor: %1",
    'dom_pref__unable_define_physical_hst_param' => "Fiziksel hosting parametreleri eklenemez: %1",
    'dom_pref__unable_rename_domain' => "%1 alan adı yeniden adlandırılamıyor: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Bu alan adı için posta kutusu kotası ayarlanamıyor: %1",
    'dom_pref__unable_set_up_web_user_script' => "web Kullanıcısı için scripting desteği atanamadı: %1",
    'dom_pref__unlimited' => "Sınırsız",
    'dom_pref__web_usrs' => "web Kullanıcıları",
    'dom_pref__you_already_have_%object' => "%1 zaten mevcut",
    'cu_domain__error_unable_update_ftp_users' => 'Alan adı FTP kullanıcıları güncellenemedi: %1',
    'dom_cli__warning_ignore_quota' => 'UYARI: "-hard_quota" seçeneği göz ardı edilir: sabit disk kotası desteklenmiyor',
    'dom_user_client_login_exist' => "Alan adı yöneticisinin %1 alan adındaki Plesk'e erişmesine izin verilemiyor: Bu kullanıcı adı zaten kullanımda.",
    'domain__unable_to_turn_on_service' => "%1 servisini açma başarısız oldu.",
    'domains__change_the_status_of_domain?' => "%1 alan adının durumunu değiştirmek istediğinizden emin misiniz?",
    'domains__unable_to_change_client_status' => "Müşteri hesabı durumu değiştirilemiyor: %1",
    'domains__unable_update_apache_settings' => "Apache Ayarları Güncelleme işlemi gerçekleştirilemedi",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Alan adlarını silme izniniz yok.",
    'domains_list__unable_remove_doms' => "Alan adları kaldırılamıyor: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Kaldırılacak takma alan adlarını seçin.',
    'domain_aliases_remove__title' => 'Takma alan adlarını kaldırma',
    'domain_aliases__max_aliases_reached_for_dom' => "Bu alan adı için takma adı sayısının sınırına ulaşıldı.",
    'domain_edit__edit_title' => 'Takma alan adını düzenleyin',
    'domain_alias_edit__type' => 'Takma alan adı tipi',
    'domain_aliases__list_header' => 'Takma alan adları',
    'domain_aliases__name' => 'Adı',
    'domain_aliases__type' => 'Tür',
    'domain_aliases__type_full' => 'WEB & FTP & MAIL',
    'domain_aliases__type_web_ftp' => 'WEB & FTP',
    'domain_aliases__page_title' => 'Takma alan adları',
    'domain_aliases__legend' => 'Takma alan adları',
    'domain_alias__domain_exists' => 'Adı böyle olan bir alan adı zaten var',
    'domain_alias__subdomain_exists' => 'Adı böyle olan alt alan adı zaten var',
    'domain_alias__dns_record_exists' => 'Belirtilen takma alan adında bir DNS kaydı zaten var',
    'domain_alias__domain_alias_exists' => "Adı böyle olan bir takma alan adı zaten var",
    'domain_alias__invalid_type_full' => 'Posta sunucusu takma alan adlarını desteklemiyor',
    'domain_alias__redirect_exists' => 'Kendine yeniden yönlendirme algılandı',

    'ds__anonymous_ftp' => "Anonim FTP",
    'drweb__pagetitle' => 'Antivirüs ayarları',
    'drweb__drweb' => 'Antivirus mail kontrol',
    'drweb__drweb_direction' => 'Mesajları virüs için denetle',
    'drweb__drweb_direction_off' => 'Virüs için kontrol etmeyin',
    'drweb__drweb_direction_any' => 'Gelen ve giden posta',
    'drweb__drweb_direction_from' => 'Sadece giden posta',
    'drweb__drweb_direction_to' => 'Sadece gelen posta',
    'drweb__disable_reason_key' => 'Dr.Web mevcut lisansınız tarafından desteklenmiyor.',
    'drweb__disable_reason_perm' => 'Dr.Web yönetimi için yetkiniz yok.',
    'drweb__disable_reason_install' => 'Antivirüs yüklü değil.',
    'drweb__filters' => 'Virüsten koruma filtreleri',
    'ds__dns' => "DNS alanı",
    'ds__mail' => "Posta",
    'dumps_list__deletion_page_title' => "%1 alan adının aşağıdaki yedekleme dosyaları kaldırılacak:",
    'dumps_list__dumpfile_is_invalid' => "%1 dosyası geçerli bir alan adı yedekleme dosyası değil.",
    'dumps_list__page_title' => "Yedekleme dosyaları deposu",
    'dumps_upload__page_title' => "Yedekleme Dosyaları Depoya Yükleniyor",
    'dumps_list__repository_is_not_exist' => "Yedekleme dosyaları deposu yok.",
    'dumps_list__unable_to_remove' => "Yedekleme dosyası Silinemiyor : %1",
    'dumps_list__dumpfile_can_conflict' => "Belirttiğiniz dosya adı, %1 dosyasıyla çakışıyor. Lütfen başka bir dosya adı belirtin.",
    'dusr_ed__allow_dl_usr_access' => "Alan adı yönetici erişimine izin verin",
    'dusr_ed__information' => "Alan Adı %1 Yöneticisinin Özellikleri",
    'dusr_ed__locale' => "Alan adı yöneticisinin dili",
    'dusr_ed__skin' => "Alan adı yöneticisinin arayüz dış görünümü",
    'dusr_ed__personal_information' => 'Kişisel bilgiler',
    'ess__error' => "Hata",
    'example__' => "Örnek: %1",
    'extras__allow_certificate_purchasing' => "Sertifika alımına müsade et",
    'extras__allow_domain_registration' => "Alan adı kaydına izin verin",
    'extras__allow_extras' => "İlave servislere müsade et",
    'extras__buy_new_key' => "Geçerli lisansınız, bu nesneleri değiştirmenize izin vermiyor.",
    'extras__setup_services' => "Ek servisleri ayarlayın",

    'ruleeditform__error' => 'Güvenlik duvarı kuralı güncellenemedi.',
    'ruleeditform__name_is_required' => 'Kural adını belirtin.',
    'ruleeditform__profiles_is_required' => 'En az bir profil seçin.',
    'ruleeditform__invalid_ip' => 'Belirtilen IP adresi veya ağı geçersiz.',
    'ruleeditform__invalid_port' => 'Belirtilen bağlantı noktası geçersiz. 1000 veya 1000-1051 değerleri kullanılabilir',

    'get_password__encrypted_password' => "Şifre bilgileri gönderilemiyor: Şifre, şifrelenmiş biçimde saklanmış.",
    'get_password__mail_error' => "Şifre, %1 Epostasına gönderilmeye çalışılırken bir hata oluştu: %2",
    'get_password__mail_ok' => "Şifre başarıyla Epostaya gönderildi: %1",
    'get_password__message' => "Sisteme erişmek için kullanıcı adınız: %1\nŞifreniz %2",
    'get_password__subject' => "PLESK Şifreniz",
    'groups__available' => "E-posta grupları",
    'groups__groups_for_mailname' => "Posta hesabının %1 abone olduğu posta grupları",
    'groups__member_of' => "Bu Mail gruplarının üyesi",
    'help__help_area' => "Destek bölümü.",
    'hst_def__auth_disabled' => "yasak",
    'hst_def__auth_enabled' => "İzin verildi",
    'hst_def__change_curr_dns_ip' => "DNS A kaydının IP adresi değiştirilecek",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "DNS A kaydındaki IP adreslerinin hiç biri hosting için kullanılan IP adresi ile aynı değil",
    'hst_def__dest_url' => "Hedef URL",
    'hst_def__disk_quota' => "Disk kotası",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Ayarlamaya çalıştığınız disk alanı sınırı, anonim FTP gelen dizinindeki disk alanı sınırı tarafından aşıldı. Anonim FTP gelen dizinindeki disk alanı sınırının, alan adı disk alanı sınırını aşmaması gerekir.",
    'hst_def__frame_forwarding_definition' => "Alan adı %1 için çerçeve iletme ataması",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Dikkat: FTP kullanıcısı %1, barındırma hesap ayarlarında kullanılır, ancak sistemde yoktur.",
    'hst_def__hst_type_is_not_defined' => "Hosting tipi tanımlanmamış",
    'hst_def__ip_based' => "IP-tabanlı",
    'hst_def__name_based_power_anonymous_ftp_down' => "Bu barındırma hesabını paylaşılmış IP adresine aktarmak, bu alan adında anonim FTP servisini kullanılamaz hale getirir. Yine de devam edilsin mi?",
    'hst_def__password_is_invalid_password_syntax' => "Şifre geçerli değil.\nBir parolada tek kesme işareti ve ulusal alfabe karakterlerini kullanmayın.\n Parola uzunluğunun 5 ile 14 karakter arasında olması gerekir. Parolanın kullanıcı adını içermemesi gerekir.",
    'hst_def__shell' => "Aboneliğin sistem kullanıcısı altında sunucu kabuğuna SSH erişimi",
    'hst_def__shell_windows' => "Aboneliğin sistem kullanıcısı altında sunucuya Uzak Masaüstü erişimi",
    'hst_def__standard_forwarding_definition' => "Alan adı %1 için standart iletme ataması",
    'hst_def__title_name_based' => "İsim-tabanlı",
    'hst_def__unable_create/update_physic_hst' => "fiziksel hosting yaratılamıyor/güncellenemiyor: %1",
    'hst_def__unable_create/update_std_fwd' => "Standart yönlendirme oluşturma/güncelleme başarısız: %1",
    'hst_def__unable_create_forwarding_myself' => "Alan adının kendisine iletme oluşturulamıyor.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "SSL/TLS ve SSL/TLS dışı içeriği depolamak için tek dizin kullanmaya izin verilemiyor: SSL/TLS desteği açık değil.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "SSL/TLS desteği açılamıyor:SSL/TLS Sertifikası kurulu değil",
    'hst_def__url_is_invalid' => "URL geçerli değil.",
    'hst_def__virtual_host_access' => "%1 alan adı için sanal ana bilgisayar erişimi",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "UYARI. Bu sanal ana bilgisayar, barındırma için varolmayan bir IP adresi kullanıyor.",
    'hst_def__you_have_no_ips' => "Tarafınıza atanmış IP Adresleri bulunmuyor.İsim-tabanlı hosting oluşturma yetkiniz yok .",
    'hst_sel__header' => "Bu sunucuda bir web sitesi barındırmak için, Fiziksel barındırma seçeneğini seçin.\n Başka bir makinedeki bir siteye alan adı iletmesi kurmak için, Çerçeve iletme veya Standart iletme seçeneğini seçin.\n Standart iletmede bir kullanıcı, siteye yönlendirilir ve kullanıcının tarayıcınızda geçerli sitenin URL'si gösterilir ve böylece kullanıcı, yönlendirmeyi anlar.Çerçeve iletmeyle bir kullanıcı, sitenin gerçekte başka bir konumda bulunduğunu bilmeden siteye yönlendirilir.",
    'hst_sel__physical_hst' => "Fiziksel Hosting",
    'hst_sel__select_hst_type' => "Alan adının barındırma tipini seçin",
    'hst_sel__select_hst_type_warning' => "Alan adının barındırma tipini seçin",
    'hst_sel__hosting_exists' => "Bu alan adı için zaten yapılandırılmış olduğundan, barındırma oluşturulamıyor. Barındırma yönetimi sayfasına yönlendirileceksiniz.",
    'hst_sel__standard_frw' => "Standart iletme",
    'hst_sel__frame_frw' => "Frame içinde yönlendirme",
    '__frame_frw' => "Frame içinde yönlendirme",
    '__hosting_exists' => "Bu alan adı için zaten yapılandırılmış olduğundan, barındırma oluşturulamıyor. Barındırma yönetimi sayfasına yönlendirileceksiniz.",
    '__choose_hst_type' => "Gerekli Hosting tipini seçiniz.",
    '__no_hst_conf' => "Alan adınız için yapılandırılmış hiçbir barındırma yok.",
    '__physical_hst' => "Fiziksel Hosting",
    '__select_hst_type' => "Alan adının barındırma tipini seçin",
    '__standard_frw' => "Standart iletme",
    '__warning' => "Uyarı!  Daha önce ayarlanan tüm parametreler göz ardı edilecek.  Barındırma tipini değiştirmek istediğinizden emin misiniz?",
    'i_cl_off' => "Müşteri etkin değil.",
    'i_cl_off_by_admin' => "Müşteri hesabı sunucu yöneticisi tarafından askıya alındı.",
    'i_cl_off_expired' => "Müşteri hesabının süresi doldu.",
    'i_cl_on' => "Müşteri etkin.",

    'icf__title' => 'Internet Firewall Bağlantısı',
    'icf__if_legend' => 'Arayüzler',
    'icf__mode' => 'Mod',

    'invalid_value' => 'Geçersiz Değer',

    'ip_addr__already_exists' => "IP Adresi %1 sistemde mevcut.",
    'ip_addr__cant_add' => "IP %1 yok veya başka bir müşterinin IP havuzuna ait",
    'ip_alias__interface' => "Arayüz",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP Adresi İsim-tabanlı virtual hosting için geçerli değil.",
    'ip_alias__invalid_ip_or_netmask' => "Geçersiz IP Adresi/netmask çifti.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP adresi %1, orijinal sunucu IP'si, dolayısıyla onu kaldıramazsınız.",
    'ip_alias__ip_is_invalid' => "%1 IP Adresi geçerli değil.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP maskesi geçerli değil.",
    'ip_alias__ip_not_exist' => "IP Adresi %1 mevcut değil.",
    'ip_alias__ip_address_and_mask' => 'IP adresi ve alt ağ maskesi',
    'ip_alias__mask' => "Subnet Maskesi",
    'ip_alias__remove_selected_ip_aliases?' => "Seçili IP adreslerini kaldırmak istediğinizden emin misiniz?",
    'ip_alias__select_ip' => "Silmek için listeden en az bir IP Adresi seçiniz.",
    'ip_alias__this_ip_used_for_domain' => "(%1) bu IP adresi, alan adı %2 için kullanılır.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) Bu IP Adresi i İsim-tabanlı virtual hostlar için kullanılıyor.",
    'ip_alias__unable_add_ip' => "IP eklenemiyor: %1",
    'ip_alias__unable_remove_ip' => "IP Silinemiyor: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "IP adres tipini paylaşılmış olarak değiştiremezsiniz, yoksa Anonim FTP'yi alan adı '%1' için kullanılamaz hale getirir.",
    'ip_ctrl__ip_addr' => "%1 arayüzündeki IP adresi %2",
    'ip_ctrl__ip_exists_many_pools' => "IP tipini değiştiremezsiniz. Bu IP adresi, aynı anda birden fazla kullanıcının havuzuna ait.",
    'ip_ctrl__ssl_cert' => "SSL/TLS sertifikası",
    'limit__date_in_past' => "Geçerlilik dönemi geçersiz. %1 geçmişte.",
    'limit__enter_date' => "Tarih giriniz",
    'limit__max_db' => "Veritabanları",
    'limit__name_disk_space' => "disk alanı",
    'limit__name_max_box' => "posta kutuları",
    'limit__name_max_db' => "MariaDB/MySQL Veritabanları",
    'limit__name_max_dom' => "alan adları",
    'limit__name_max_maillists' => "postalama listeleri",
    'limit__name_max_subdom' => "alt alan adları",
    'limit__name_max_traffic' => "trafik",
    'limit__name_max_wu' => "web Kullanıcıları",
    'limit__name_mbox_quota' => "posta kutusu kotası",
    'limit__name_max_mn' => "posta hesapları",
    'limit__name_max_cl' => 'istemciler',
    'limit__name_total_mboxes_quota' => "toplam posta kutusu kotası",
    'limit__name_mysql_dbase_space' => "MariaDB/MySQL veritabanı alanı",
    'limit__name_mssql_dbase_space' => "MSSQL veritabanı alanı",
    'limit__name_pgsql_dbase_space' => "PostgreSQL veri tabanı alanı",
    'limit__name_expiration' => 'süre sonu',

    'locale_upload__unable_to_install' => 'Dil paketi dosyası kurulamıyor',
    'locale_upload__wrong_package' => 'Karşıya yüklediğiniz dosya, bu Plesk sürümü için geçerli bir dil paketi içermiyor.',
    'locale_upload__wrong_locale' => 'Karşıya yüklediğiniz dosya, geçerli bir dil paketi içermiyor.',

    'ma__create_title' => '%1 için posta takma adı oluşturma',
    'ma__edit_title' => "Takma isim %1 i düzenle",
    'ma__enter_new_alias' => "Yeni takma isimi gir.",
    'ma__invalid_alias' => "Geçersiz Takma isim.",
    'ma__mail_aliases_mailname' => "Posta hesabı %1 için posta takma adları",
    'ma__mailname_does_not_exist' => "Posta hesabı yok.",
    'ma__select_ma_for_remove' => "Silmek için Takma isim seçiniz.",
    'ma__unable_to_add_new_ma' => "Takma isim eklenemiyor: %1",

    'mail_queue__not_allowed_by_license_key' => 'Lisans anahtarıyla posta sırası yönetimine izin verilmez.',
    'maillist__' => "Mailing listesi %1",
    'maillist__already_exists' => "Mailing listesi sistemde mevcut.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Bu alan adı için posta takma adı %1 zaten var",
    'maillists__' => "Mailing listeleri %1",
    'maillists__limit_cl_max_maillists' => "Müşteri için etki alanı sayısı sınırına ulaşıldı (sınır: %1, kullanıldı: %2)",
    'maillists__limit_dom_max_maillists' => "Alan adı için postalama listesi sayısının sınırına ulaşıldı.",
    'maillists__list' => "Postalama listeleri",
    'maillists__mailman_not_installed_or_conf' => "\nMailman Sunucusu Uzantıları şu an yüklü değil veya yapılandırılmamış\n sunucuda. Mailman Sunucusu Uzantılarının yüklenmesi veya düzgün bir biçimde yapılandırılması için sunucu yöneticisiyle irtibata geçin.",
    'maillists__status' => "Postalama listesi servisi açık",
    'maillists__unable_to_delete__' => "Mailing listesi Silme işlemi gerçekleştirilemedi: %1",
    'maillists__disabled_text' => 'Mailman postalama listelerinin sunucu bileşeni yüklü olmadığından veya yapılandırılmadığından, postalama listelerini yönetemezsiniz.',
    'maillist_member__already_exists' => 'Mailing listesi üyesi sistemde mevcut.',
    'maillist_member__not_exists' => 'Mailing listesinde böyle bir kullanıcı yok.',
    'mailserver_switching_warning' => "Uyarı!\n\n Posta sunucusunu değiştirme sadece ilk ayar için planlanmıştır ve sunucu zaten kullanımdaysa, aşağıdaki sorunlara neden olur: ayar ve posta kutusu içeriği kaybı ve geçtiğiniz sunucunun zaten yapılandırılmış olduğu durumlarda, farklı çakışmalar.\n Bu sunucu şimdi kullanımdaysa ve başkasına geçme konusunda eminseniz, postalarını indirip kaydetmeleri için müşterilerinize işlem hakkında bilgi verebilirsiniz.",
    'manager__access_denied' => "Yetkiniz yok: %1",
    'manager__admin' => "Yönetici",
    'manager__client' => 'Müşteri',
    'manager__domain' => "Alan Adı",
    'manager__domain_cl_limit_exceeding' => "Bu alan adı hesabı için alan adı sayısı sınırına ulaşıldı.",
    'manager__domain_is_not_yours' => "Alan adı %1 size ait değil.",
    'manager__domain_key_limit_exceeding' => "Lisans anahtarınızla tanımlanan alan adı, oluşturma sınırına ulaşıldı.",
    'manager__no_perm_to_call' => "Yetkiniz yok %1",
    'manager__no_perm_to_create_domains' => "Alan adı oluşturma izniniz yok.",
    'manager__no_perm_to_modify_domain' => "%1 alan adını değiştirme izniniz yok.",
    'manager__no_perm_to_modify_domains' => "Alan adlarını değiştirme izniniz yok.",
    'manager__no_perm_to_remove_domain' => "%1 alan adını kaldırma izniniz yok.",
    'manager__no_perm_to_remove_domains' => "Alan adlarını silme izniniz yok.",
    'manager__node_doesnt_exist' => "%1 mevcut değil",
    'manager__user_disabled' => "Hesabınız askıya alındı. Sistemi çalıştıramazsınız.",
    'mail_quota_unsupported' => "posta sunucusu tarafından desteklenmiyor",
    'mbox_quota_unsupported' => "posta sunucusu tarafından desteklenmiyor",
    'mn__create_title' => "Posta hesabı oluşturun",
    'mn__edit_title' => "Ayarlar",
    'mn__files_list_title' => "Eklenti dosyaları",
    'mn__files_remove' => "Dosyaları eklentiler deposundan kaldırın.  Bu dosyalar bir olasılık otomatik yanıtlar tarafından kullanıldı. Bunlar hem depodan, hem de onları kullanan otomatik yanıtlardan kaldırılır.",
    'mn__files_select_for_remove' => "Silinecek dosyaları seçiniz.",
    'mn__mail_alias_form' => "Takma isim formu",
    'mn__mail_aliases_list' => "Posta takma adları",
    'mn__mailbox' => "Posta kutusu yönetimi",
    'mn__unable_define_mn' => "Posta hesapları ayarlanamıyor: %1",
    'mn__unable_remove_mbox_quota' => "Posta kutusu kotası silinemiyor: %1",
    'mn__upload_file' => "Dosya yükle",
    'mn_edit__attach_filename_changed' => 'Adı ASCII dışı karakter içerdiğinden, karşıya yüklenen dosya %1, %2 olarak yeniden adlandırıldı.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Mail grup aktive edilmeden önce bir üye eklenmelidir..",
    'mn_edit__add_resp_or_turn_off_box' => "Otomatik yanıt eklemeniz veya otomatik yanıt onay kutusundaki işareti kaldırmanız gerekir.",
    'mn_edit__attachments' => "Eklentiler",
    'mn_edit__dom_quota_less_then_quota' => "Bu posta kutusunun boyutunun, bu alan adındaki posta kutuları için ayrılan disk alanı miktarındaki sınırı aşmaması gerekir.",
    'mn_edit__enter_external_rcpnt_email' => "Harici posta grubu üyesinin e-postasını girin",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Posta iletme için bir adres girin veya onay kutusundaki işareti kaldırın.",
    'mn_edit__ext_rcpnt_email_invalid' => "Harici alıcının e-posta adresi geçersiz.",
    'mn_edit__file_exists' => "Dosya var. Üzerine yazılsın mı?",
    'mn_edit__files_deld_from_repository' => "Bu dosyalar, onları içeren depodan ve otomatik yanıtlardan silinecek. Devam etmek istiyor musunuz?",
    'mn_edit__mail_name' => "Posta hesabı",
    'mn_edit__mail_name_invalid' => "Posta hesabı adı geçersiz.",
    'mn_edit__mail_redir' => "Posta ileticileri",
    'mn_edit__mail_redir_add' => "Mail Grup Üyesi ekle",
    'mn_edit__mail_resps' => "Posta otomatik yanıtları",
    'mn_edit__mailbox' => "Posta kutusu",
    'mn_edit__enable_mailbox' => "Posta kutusu",
    'mn_edit__mailgroup' => "Mail grup",
    'mn_edit__mailgroup_addresses' => "Mail grup üyeleri",
    'mn_edit__mailgroup_disabled' => "Sadece posta hesabı zaten eklendiğinde kullanılabilir.",
    'mn_edit__max_dom_quota' => "Alan adı (%1) için varsayılan",
    'mn_edit__mbox_quota_invalid' => "Yanlış posta kutusu boyutu belirtildi.",
    'mn_edit__new_resp_name' => "Yeni otomatik yanıt adı",
    'mn_edit__no_autoresponders' => "Otomatik yanıt servisini açmadan/kapatmadan önce en az bir otomatik yanıt eklemeniz gerekir.",
    'mn_edit__no_file_sel' => "Hiçbir dosya seçilmedi.",
    'mn_edit__no_mail_addresses' => "Hiçbir e-posta adresi belirtilmedi veya seçilmedi.",
    'mn_edit__none' => "Hiçbiri",
    'mn_edit__not_create_pass' => "Bu, bu hesap için bir şifre oluşturmaz.\nŞifre olmadığında kullanıcı, posta görüntüleyemez ve gönderemez.",
    'mn_edit__redir_email_invalid' => "İletme adresi geçersiz.",
    'mn_edit__redirect_addr' => "İletme adresi",
    'mn_edit__remove_autoresp?' => "Otomatik yanıtı kaldırmak istediğinizden emin misiniz?",
    'mn_edit__remove_rcpnts?' => "Bu alıcıları istediğinize emin misiniz?",
    'mn_edit__repository' => "depo",
    'mn_edit__resps_attach' => "Otomatik yanıt eklenti dosyaları",
    'mn_edit__select_rcpnt_from_list' => "Silmek için listeden en az bir alıcı seçiniz.",
    'mn_edit__select_registered_users' => "Kayıtlı üyeleri seç",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Bir post kutunuzun olmasını seçtiniz, ancak şifresini ayarlamadınız.",
    'mn_edit__unable_act_deact_mail_group' => "Posta grubu etkinleştirilemiyor veya devre dışı bırakılamıyor: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Posta iletme etkinleştirilemiyor veya devre dışı bırakılamıyor: %1",
    'mn_edit__unable_act_deact_postbox' => "Posta kutusu etkinleştirilemiyor veya devre dışı bırakılamıyor: %1",
    'mn_edit__unable_act_deact_resp' => "Otomatik yanıtlar etkinleştirilemiyor veya devre dışı bırakılamıyor: %1",
    'mn_edit__unable_add_attach' => "Ek dosyalar eklenemiyor: %1",
    'mn_edit__unable_add_mail_group_member' => "Mail grup üyeleri eklenemiyor: %1",
    'mn_edit__unable_add_resp' => "Otomatik yanıt eklenemiyor: %1",
    'mn_edit__unable_change_mail_name' => "Posta hesabı adı değiştirilemiyor: %1",
    'mn_edit__unable_deactivate_mail_group' => "Mail grupları pasif yapılamıyor: %1",
    'mn_edit__unable_deactivate_resp' => "Posta otomatik yanıtları devre dışı bırakılamıyor: %1",
    'mn_edit__unable_define_resp_id' => "Otomatik yanıt kimliği tanımlanamıyor: %1",
    'mn_edit__unable_remove_attach' => "Ekli dosyalar kaldırılamıyor: %1",
    'mn_edit__unable_remove_autoresp' => "Otomatik yanıt kaldırılamıyor: %1",
    'mn_edit__unable_remove_mail_group_member' => "Mail grup üyeleri kaldırılamıyor: %1",
    'mn_edit__wrong_way' => '%1 alıcısına gönderilen mesajlar teslim edilmez, çünkü bu posta hesabının açık bir posta kutusu veya posta ileticisi yok.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => '%1 adresindeki posta kutusu kapandı.  Posta kutusundaki mesajlar kaldırılmadı, ancak onları IMAP veya POP3 iletişim kuralıyla alamazsınız.',
    'mn_list__mail_names_for_domain' => "%1 alan adı altındaki posta hesapları",
    'mn_list__sa_cannot_unable' => "Gereksiz posta filtrelemesi açılamıyor.",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Müşteri',
    'mn_list__tab_title_domain' => 'Alan Adı',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Adı",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Posta hesapları kaldırılamıyor: %1",
    'module_upload__module_was_installed' => 'Bu modül zaten yüklü. Bu modülün daha yeni bir sürümünü kurmak istiyorsanız, lütfen modülü Plesk\'ten kaldırın ve sonra kurmayı deneyin.',
    'module_upload__unable_to_install' => 'Modül paketi dosyası kurulamıyor',
    'module_upload__wrong_package' => 'Karşıya yüklenen dosya, desteklenen bir modül paketi değil.',
    'module_upload__wrong_module' => 'Karşıya yüklenen dosya bir modül paketi içermiyor.',

    'news_articles_title' => 'Plesk Haberleri',
    'notification_text__invalid_subject_length' => "Geçersiz uyarı konusu uzunluğu. 1 ile 255 karakter arasında olmalıdır.",
    'notification_text__invalid_text_length' => "Geçersiz uyarı metni uzunluğu. 1 ile 65533 karakter arasında olmalıdır.",
    'notification_text__subject' => "Uyarı konusu",
    'notification_text__text' => "Bildiri metni",
    'notification_text__title' => "Bildiriyi düzenle",
    'notification_text__unable_set_text' => "Bildiri metni değiştirilemedi:",

    'odbc__cant_add_dsn' => "DSN %1 eklenemiyor : %2",
    'odbc__cant_connect' => "Tanımlanan ayarlar kullanılarak veri kaynağına bağlanılamıyor.  Sunucu bunu verdi: %1",
    'odbc__cant_delete_dsn' => "DSN %1 silinemiyor: %2",
    'odbc__cant_get_drivers_info' => "Sürücü hakkında bilgi alınamıyor.",
    'odbc__cant_get_drivers' => "ODBC sürücüleri listesi geri alınamıyor: %1",
    'odbc__cant_open_info_file' => "ODBC sürücü bilgileriyle dosya açılamıyor.",
    'odbc__cant_parse_string' => "Bağlantı satırı ayrıştırılamıyor",
    'odbc__driver_not_set' => "Sürücü kurulu değil",
    'odbc__driver_or_name_not_set' => "ODBC bağlantısının sürücüsü veya adı ayarlanmamış",
    'odbc__dsn_already_exists' => "Bu isimde bir DSN (%1) sistemde mevcut",
    'odbc__dsn_not_exists' => "Bu DSN mevcut değil",
    'odbc__enter_dsn_name' => "DSN adı giriniz",
    'odbc__invalid_dsn_name' => "Yazım hatası (%1): lütfen sadedce alfanümerik karakterler giriniz.",
    'odbc__no_such_driver' => "Adı böyle olan bir ODBC sürücüsü (%1) desteklenmiyor.",
    'odbc__unknown_driver' => "Bilinmeyen sürücü adı (%1).",
    'odbc_dsn_system' => "Sistem DSN",

    'pb__aliases' => "Takma isimler",
    'pb__anonftp' => "Anonim FTP",
    'pb__autoinstaller_releases' => 'Güncelleyici',
    'pb__cert' => "Sertifikalar",
    'pb__cl_pool' => "IP Adresleri",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Ayarlar",
    'pb__cl_rpt' => "Rapor",
    'pb__cl_rpt_list' => "Özelleştir",
    'pb__cl_templates' => "Müşteri şablonları",
    'pb__cl_traffic' => "Trafik",
    'pb__cl_traffic_history' => "Veri trafiği istatistikleri",
    'pb__cl_traffic_of' => "Veri trafiği %1",
    'pb__client' => "%1",
    'pb__clients' => "Müşteriler",
    'pb__comp_info' => "Sunucu Bileşenleri",
    'pb__common_acl' => 'ACL\'yi Aktarmaya İzin Verin',
    'pb__cp_access' => "Erişim",
    'pb__crontab' => "Zamanlayıcı",
    'pb__scheduler' => "Zamanlayıcı",
    'pb__custom_buttons' => "Özel Butonlar",
    'pb__databases_db' => 'Veritabanları',
    'pb__sqlservers_db' => 'SQL Sunucuları', //to check
    'pb__db' => "Veritabanları",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Veritabanı sunucuları',
    'pb__dl_usr_ed' => "Alan adı yöneticisi",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Alan adı sınırları",
    'pb__dom_pref' => "Ayarlar",
    'pb__dom_sum_report' => "Alan Adı Özet Raporu",
    'pb__dom_templates' => "Alan Adı Şablonları",
    'pb__dom_traffic' => "Veri trafiği %1",
    'pb__domains' => "Alan Adları",
    'pb__domain_aliases' => 'Takma alan adları',
    'pb__dumps_list' => "Yedekleme dosyaları deposu",
    'pb__forwarding_setup' => "Yönlendirme ayarları",
    'pb__filemanager' => "Dosya Yöneticisi",
    'pb__ip_aliasing' => "IP Adresleri",
    'pb__ip_clients' => "IP Adresleri silme",
    'pb__license_management' => 'Lisans Bilgisi',
    'pb__locales' => 'Yerel ayar değerleri',
    'pb__log_files' => "Log dosyaları",
    'pb__mail' => 'Posta',
    'pb__mail_name_files' => "Eklenti dosyaları",
    'pb__mail_name_redirects' => "Posta ileticileri",
    'pb__mail_name_resp_attach_add' => "Yeni Eklenti",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Posta otomatik yanıtları",
    'pb__mail_names' => "Posta",
    'pb__maillists' => "Postalama listeleri",
    'pb__modules' => 'Modüller',
    'pb__modules_management' => 'Modülleri Yönetin',
    'pb__notifications' => "Bildiriler",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Fiziksel Hosting kurulumu",
    'pb__prtd_dirs' => "Korunmuş Dizinler",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Özelleştir",
    'pb__server' => "Sunucu",
    'pb__sessions' => "Oturumlar",
    'pb__sapp_pool' => "Web Uygulaması Havuzu",
    'pb__siteapp_install' => 'Web uygulaması kurulumu',
    'pb__site_app_pkgs' => 'Web Uygulamaları',
    'pb__site_apps' => "Web Uygulamaları",
    'pb__additional_key_info' => 'Lisans özellikleri',
    'pb__additional_key_properties' => 'Lisans özellikleri',
    'pb__skins' => 'Dış Görünümler',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "İstenmeyen Posta Filtresi",
    'pb__statistics' => "İstatistikler",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Alt alan adları",
    'pb__templates' => "Şablonlar",
    'pb__virtualdirs' => 'Sanal Dizinler',
    'pb__web_users' => "Web Kullanıcıları",
    'pdir__invalid_hst' => "Barındırma tipi geçersiz.  Fiziksel olmalıdır.",
    'pdir__pd_id_is_undefined' => "Korunmuş dizin kimliği tanımlanmamış.",
    'pdir__pdir_exist' => "Bu ada sahip dizin zaten korunmuş.",
    'pdir__pdir_not_exist' => "Korunmuş dizin yok.",
    'pdir__pdir_usr_not_exist' => "Korunmuş dizin kullanıcısı yok.",
    'pdir__remove_pdir_usrs' => "%1 web sitesi altındaki %2 korunmuş dizininin aşağıdaki kullanıcıları kaldırılacak:",
    'pdir__remove_pdir_usrs_on_subdom' => "%1 alt alan adı altındaki %2 korunmuş dizininin aşağıdaki kullanıcıları kaldırılacak:",
    'pdir__select_pdir_usrs_for_remove' => "Kaldırılacak korunmuş dizin kullanıcılarını seçin.",
    'pdir__select_pdirs_to_remove' => "Korumasını kaldırmak istediğiniz dizinleri seçin.",
    'pdir__unable_define_pdir_users' => "Korunmuş dizin kullanıcıları tanımlanamıyor.",
    'pdir__unable_define_pdirs_properties' => "Korunmuş dizinlerin özellikleri ayarlanamıyor: %1",
    'pdir__unable_select_dom_param' => "Alan adı parametreleri seçilemiyor: %1",
    'pdir_ed__dir_already_protect' => "Bu dizin zaten korunmuş.",
    'pdir_ed__invalid_login' => "Yanlış kullanıcı adı belirttiniz.",
    'pdir_ed__login_exists' => "Bu kullanıcı zaten var. Başka bir kullanıcı adı belirtmeyi deneyin.",
    'pdir_ed__pdir_users' => "Korunmuş dizin kullanıcıları",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "SSL/TLS ve SSL/TLS dışı onay kutularından en az bir onay kutusunun işaretlenmesi gerekir.",
    'pdir_ed__unable_cr_pdir_usr' => "Korunmuş dizin kullanıcısı oluşturulamıyor: %1",
    'pdir_ed__unable_create_pdir' => "Korunmuş dizin oluşturulamıyor: %1",
    'pdir_ed__unable_define_hst_type' => "Hosting tipi tanımlama işlemi gerçekleştirilemedi.",
    'pdir_ed__unable_update_pdir' => "Korunmuş dizinin ayarları kaydedilemiyor: %1",
    'pdir_ed__wrong_symbol_in_header' => "Lütfen dizin başlığında %1 karakterini kullanmayın.",
    'pdir_usr_ed__not_create_pass' => "Bu, yeni korunmuş dizin kullanıcısı için bir şifre oluşturmaz.\nŞifre olmadığında kullanıcı oturum açamaz.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Korunmuş dizin kullanıcısı seçilemiyor: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Korunmuş dizin kullanıcıları tanımlanamıyor: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Korunmuş dizin kullanıcıları kaldırılamıyor: %1",
    'phosting__anonftp_encrypt' => 'FTP kullanıcısının şifresi şifrelenmiştir ve bu nedenle /plesk-stat/webstat/ dizinini korumak için kullanılamaz. Lütfen FTP şifrenizi yeniden girin veya "şifreyle korunmuş dizinle erişilebilir \'/plesk-stat/webstat/\'" seçeneğindeki seçimi kaldırın',
    'phosting__hosting_and_dns_ip_difference_warning' => "%%domain_name%% alan adı %%dns_ip_address%% IP adresine çözümlenir. Web sitenize IP adresi %%hosting_ip_address%% atanır. Onu alan adıyla andığınızda web siteniz bir web tarayıcısında açılmıyorsa, DNS yönetim ekranına (Alan Adları > Alan adı > DNS) gidin ve A kaynak kaydının özelliklerini değiştirin: %%domain_name%% alan adına %%hosting_ip_address%% IP adresini atayın.",
    'phosting__ip_change_warning' => "IP adresi değiştirildi. İlgili değişiklikler, alan adının DNS bölgesinde de yapıldı.",
    'phosting__other_hosting_exists_on_ip' => "Sertifika değiştirilemiyor . Bu IP Adresi birçok hosting hesabında kullanılıyor.",
    'phosting__unable_to_change_certificate' => "Sertifika kurulamıyor: %1",
    'phosting__unable_to_change_ip_address' => "IP adresi değiştirilemiyor: %1",
    'phosting__unable_to_set_cert' => "SSL/TLS sertifikası ayarlanamıyor: %1",
    'phosting__unable_update' => "Barındırma ayarları güncellenemiyor: %1",
    'phosting__unable_manage' => "Hostingh yönetilemiyor: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Alan adının günlüklerinin takibi için fail2ban yapılandırması tamamlanamadı. Bir sonraki sefere, fail2ban hizmeti yeniden başlatıldığında günlükler otomatik olarak takip edilecek.\n%1",

    'picker_acl_record__tittle' => 'Bir ACL kaydı seçin',
    'picker_autoresponder__title' => 'Otomatik yanıt seçin',
    'picker_black_list__domain_name' => 'Bir Alan Adı Seçin',
    'picker_certificate' => 'Bir SSL/TLS Sertifikasını seçin',

    'picker_dns_zone_template__title' => 'Bir Kaynak Kaydı Seçin',
    'picker_domain__title' => 'Bir Web Sitesi Seçin',
    'picker_domain_alias__title' => 'Bir Takma Alan Adı Seçin',
    'picker_resource_record__title' => 'Bir Kaynak Kaydı Seçin',
    'picker_disabled_resource_record__title' => 'Bir Ad Sunucusu Seçin',
    'picker_ip_address__title' => 'Bir IP Adresi seçin',
    'picker_ip_address_clients__title' => 'Bu IP Adresini Kullanan Müşterileri Seçin',
    'picker_mail_queue' => 'E-Posta Mesajlarını Seçin',
    'picker_site_application__title' => 'Bir Web Uygulaması Seçin',
    'picker_subdomain__title' => 'Bir Alt Alan Adı Seçin',
    'picker_web_user__title' => 'Bir Web Kullanıcısı Seçin',
    'picker_custom_button__title' => 'Özel bir Düğme Seçin',
    'picker_license_key__title' => "Lisans anahtarını seçme",
    'picker_spamfilter_address__title' => 'Gereksiz Posta Filtresi Adresi Seçin',
    'picker_white_list__networks' => 'Ağ seçimi',

    'plesk_key__action_logs' => "Plesk kullanıcıları tarafından gerçekleştirilen eylemlerin kaydını tutma",
    'plesk_key__app_vault' => "Uygulama deposu",
    'plesk_key__backup' => "Yedekleme ve kurtarma işlevleri",
    'plesk_key__client_templs' => "Servis planları yönetimi",
    'plesk_key__clients' => "Kullanıcı hesapları (satıcılar ve müşteriler)",
    'plesk_key__resellers_only' => "Kullanıcı hesapları (satıcılar)",
    'plesk_key__customers_only' => "Kullanıcı hesapları (müşteriler)",
    'plesk_key__domains' => "Alan Adları",
    'plesk_key__domain_aliases' => "Takma alan adları",
    'plesk_key__subdomains_limit' => "Alt alan adları",
    'plesk_key__databases' => "Veritabanları",
    'plesk_key__mssql_databases' => "MS SQL Veritabanı",
    'plesk_key__manage_dashboard' => 'Başlangıç sayfasını özelleştirme',
    'plesk_key__drweb' => "Antivirüs yönetimi",
    'plesk_key__event_manager' => "Olay yönetimi",
    'plesk_key__expirations' => "Hesabın sona erme tarihlerinin yönetimi",
    'plesk_key__group_ops' => "Birden fazla nesneyi birden değiştirme",
    'plesk_key__expiration' => "Lisans bitiş tarihi",
    'plesk_key__edition_name' => "Plesk Sürümü",
    'plesk_key__key_number' => "Anahtar numarası",
    'plesk_key__languages' => "Dil paketleri",
    'plesk_key__mailnames' => "Posta hesapları",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL Sunucusu desteği",
    'plesk_key__myplesk_func' => "SSL/TLS sertifikalarını ve alan adı kayıt servislerini satın alma bağlantıları",
    'plesk_key__myplesk_server_id' => "MPC slave Sunucu belirleyici",
    'plesk_key__notifications' => "Bildirim yönetimi",
    'plesk_key__postgresql' => "PostgreSQL veritabanı sunucusu desteği",
    'plesk_key__qmail_queue' => 'Posta sırası yönetimi',
    'plesk_key__remote_db' => 'Uzak veritabanı barındırması',
    'plesk_key__slave_servers' => "İkincil sunucular",
    'plesk_key__spamassassin' => "Gereksiz posta filtresi yönetimi",
    'plesk_key__subdomains' => "Alt alan adları yönetimi",
    'plesk_key__sys_access' => "Sunucuya erişimin yönetimi",
    'plesk_key__traffic_reports' => "Trafik kullanımı raporları",
    'plesk_key__tts' => "Yardım Masası",
    'plesk_key__virtuozzo' => "Sadece Virtuozzo containers için geçerlidir",
    'plesk_key__webusers' => "Web Kullanıcıları",
    'plesk_key__cpu_cores' => 'İşlemci çekirdekleri',
    'plesk_key__ram' => 'Bellek',
    'plesk_key__license_update_date' => 'Bir sonraki lisans anahtarı güncellemesi',
    'plesk_key__autoinstaller_config' => 'Güncelleyici ayarları yönetimi',
    'plesk_key__check_wrong' => "Lisans anahtarı geçersiz. Plesk'i kullanmak için, lütfen yeni bir geçerli lisans anahtarı elde edin ve kurun.",
    'plesk_key__upload_check_wrong' => 'Karşıya yüklenmiş lisans anahtarı geçerli değil.',
    'plesk_key__revert_check_wrong' => 'Daha önce yüklü olan lisans anahtarı geçerli değil.',
    'plesk_key__viruozzo_only_key' => 'Lisans anahtarı ancak Virtuozzo containers içinde çalışan Plesk\'le kullanılmak için tasarlanmıştır.',
    'plesk_key__ip_ranges_exceeded' => 'Bu lisanslı Plesk kopyasını sadece aşağıdaki IP adresleriyle kullanabilirsiniz: %2. Aşağıdaki IP adresleri lisansınız tarafından kapsanmıyor: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Geçerli olarak kullanılan kaynakların miktarı, lisansınızla tanımlı sınırları aşıyor.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Araç Kiti Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Sunucuda barındırılan web siteleri sayısı, lisansınızın tanımladığı sınırı aşıyor. Barındırılmış %2 siteniz var; lisansınız sadece %1 siteyi barındırma izni veriyor.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Sunucudaki takma alan adlarının sayısı, lisansınızın tanımladığı sınırı aşıyor. %2 takma alan adınız var; lisansınız sadece %1 takma alan adını barındırma izni veriyor.',
    'plesk_key__limits_exceeded_lim-subdom' => 'Sunucudaki alt alan adlarının sayısı, lisansınızın tanımladığı sınırı aşıyor. %2 alt alan adınız var; lisansınız sadece %1 alt alan adını barındırma izni veriyor.',
    'plesk_key__limits_exceeded_lim-db' => 'Sunucudaki veritabanı sayısı, lisansınızın tanımladığı sınırı aşıyor. %2 veritabanınız var; lisansınız sadece %1 veritabanı barındırma izni veriyor.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'Sunucudaki MS SQL veritabanı sayısı, lisansınızın tanımladığı sınırı aşıyor. %2 veritabanınız var; lisansınız sadece %1 veritabanı barındırma izni veriyor.',
    'plesk_key__limits_exceeded_lim_cl' => 'Servis sağlanan müşteri hesapları sayısı, lisansınızla tanımlanan sınırları aşıyor.  Şu an servis sağlanan %2 müşteri hesabınız var; lisansınız sadece %1 müşteri hesabına servis sağlanmasına izin veriyor.',
    'plesk_key__limits_exceeded_lim_mn' => 'Servis sağlanan e-posta hesapları sayısı, lisansınızla tanımlanan sınırları aşıyor.  Şu an servis sağlanan %2 e-posta hesabınız var; lisansınız sadece %1 e-posta hesabına servis sağlanmasına izin veriyor.',
    'plesk_key__limits_exceeded_lim_wu' => 'Servis sağlanan web kullanıcısı hesaplarının sayısı, lisansınızla tanımlanan sınırları aşıyor.  Şu an servis sağlanan %2 web kullanıcısı hesabınız var; lisansınız sadece %1 web kullanıcısı hesabına servis sağlanmasına izin veriyor.',
    'plesk_key__limits_exceeded_MLS' => 'Şu anda kurulan dil paketlerinin sayısı, lisansınızın tanımladığı sınırı aşıyor. Yüklü %2 dil paketi var; lisansınız sadece %1 dil paketi kurmanıza izin veriyor.',
    'plesk_key__wrong_version' => 'Plesk\'in başka bir sürümü için oluşturulmuş lisans anahtarını kullanmaya çalışıyorsunuz. Uygun lisans anahtarını almak için Plesk satış temsilcileriyle irtibata geçin.',
    'plesk_key__other_product' => 'Başka bir ürün için oluşturulmuş bir lisans anahtarını kullanmaya çalışıyorsunuz. Uygun lisans anahtarını almak için Plesk satış temsilcileriyle irtibata geçin.',
    'plesk_key__invalid_machine_id_trial' => 'Mevcut lisansınız geçerli değil çünkü başka bir Plesk sunucusunda etkinleştirilmiş. Plesk\'i kullanmaya devam etmek için ya yeni bir lisans kurun ya da mevcut lisansınızın aktivasyon kodunu girerek (varsa) tekrar kurun.',
    'plesk_key__invalid_machine_id_retail' => 'Mevcut lisansınız başka bir Plesk sunucusunda etkinleştirildiği için geçerli değil. WebPros EULA (https://www.plesk.com/legal/), aynı anda iki veya daha fazla sunucuda tek bir lisansın kullanılmasına izin vermez. Plesk\'i kullanmaya devam etmek için yeni bir lisans kurun veya aktivasyon kodunu girerek mevcut lisansınızı bir kez daha kurun. Aktivasyon kodu, lisansı satın aldığınızda size e-posta ile gönderildi. <br>Aktivasyon kodunu bulamıyor musunuz? Plesk 360\'ı kullanarak geri alabilirsiniz. Bunun için lisansı satın alırken kullandığınız e-posta adresiyle https://platform360.io/ adresinde oturum açın, "Licenses" sekmesine gidin ve aktivasyon kodunuzu göreceksiniz. Alternatif olarak çevrim içi formu (https://www.plesk.com/licensing-and-purchase-support/) kullanarak Plesk Lisanslama ve Satın Alma desteğiyle iletişime geçebilirsiniz. Formun "How can we help you?" bölümünde lisans numaranızı belirtmeyi unutmayın.',
    'plesk_key__limits_exceeded_error' => 'Lisans anahtarı kurulamıyor: o sırada kullanılan kaynakların miktarları, karşıya yüklenen lisans anahtarında tanımlanan sınırları aşıyor.',
    'plesk_key__limits_exceeded_note' => 'O sırada kullanılan kaynakların miktarları, karşıya yüklenen lisans anahtarında tanımlanan sınırları aşıyor.',
    'plesk_key__hardware_limits_exceeded' => 'Donanım yapılandırması, Plesk lisansınız tarafından belirlenen sınırı aşıyor.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'Sunucuda %1 bellek kurulu fakat lisansınız en fazla %2 belleğe izin veriyor.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'Sunucuda %1 işlemci çekirdeği kurulu fakat lisansınız en fazla %2 işlemci çekirdeğine izin veriyor.',
    'plesk_key__key_file_invalid' => 'Yüklenen lisans geçerli değil.',
    'plesk_key__server_request_error' => 'Lisans güncellenemedi. TCP bağlantı noktası %1 üzerindeki ka.plesk.com lisans sunucusunun bağlantıları engellenmediğinden emin olun. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Bunun nasıl yapılacağına bakın</a>.',
    'key__no_key_file_in_zip' => 'Yüklenen .zip dosyasında lisans bulunamadı',
    'key__key_upload' => 'Lisans kurulumu',
    'additional_key__prop_name' => 'Özellik',
    'additional_key__prop_value' => 'Değer',
    'additional_key__descr_name' => 'Lisans adı',
    'additional_key__descr_key_number' => 'Anahtar numarası',
    'additional_key__descr_key_vz' => "Bu lisans anahtarı ancak Virtuozzo containers'ta kullanılmak için tasarlanmıştır.",
    'additional_key__descr_key_mailboxes' => 'Posta kutuları',
    'additional_key__descr_lim_date' => 'Son kullanım tarihi',
    'additional_key__descr_license_update_date' => 'Bir sonraki lisans anahtarı güncellemesi',
    'additional_key__file_invalid' => 'Yüklenen lisans geçerli değil.',
    'additional_key__file_incompatible' => 'Yüklenen lisans bu yazılım için geçerli değil.',
    'additional_key__not_exists' => 'Lisans kurulu değil.',
    'additional_key_update__result_response' => 'Lisanslama sunucusu yanıtı: %1',
    'additional_key_update__result_network' => 'Lisanslama sunucusuna bağlanılamıyor.  Lütfen ağın %1 ile iletişime izin verdiğinden emin olun: %2.',
    'additional_key_update__result_lock' => 'Anahtarı güncelleme zaten yürütülüyor',
    'additional_key_update__result_internal_error' => 'Lisans anahtarı güncellenirken hata oluştu: %1',

    'proceed_to_cl_pool' => "Müşterinin IP havuzunu yapılandırmaya devam edin",
    'proceed_to_hosting_setup' => "Hosting kurulumuna başla",
    'removeCerts__remove_certificates_cp' => "Bu Sertifikalar silinecek:",
    'removeCerts__remove_certificates_domain' => "%1 e ait bu Sertifikalar silinecek:",
    'removeClientsIP_remove_clients_ip' => "Bu IP adresi, aşağıdaki müşterilerin havuzlarından kaldırılacak:",
    'removeMailAliases__remove_mail_aliases' => "%1 posta hesabının aşağıdaki posta takma adları kaldırılacak:",
    'removeMailNames__remove_mailnames' => "%1 alan adından aşağıdaki posta hesapları ve takma adları kaldırılacak:",
    'removeMailNames__remove_mailnames_of_cl' => "%1 müşterisine ait olan %2 alan adından aşağıdaki posta hesapları ve takma adları kaldırılacak:",
    'removeMailNames__these_mailnames_will_not_delete' => "Bu posta hesapları silinmeyecek.",
    'removeFtpSessions__remove_title' => "Bu FTP Oturumları sonlandırılacak:",
    'removeTemplates__remove_templates' => "Bu Şablonlar silinecek:",
    'resp_edit__always_respond' => "Her zaman cevap ver",
    'resp_edit__reply_subject' => "Yanıt konusu",
    'resp_edit__answer_subject' => "Başlıkla cevap ver",
    'resp_edit__answer_txt' => "Mesaj metni",
    'resp_edit__attach' => "Dosya Ekle",
    'resp_edit__default_subject' => "Konu: %1",
    'resp_edit__for' => "için",
    'resp_edit__frw_rqst_email' => "Otomatik yanıt üzerine orijinal mesajı belirtilen e-postaya iletin",
    'resp_edit__fwd_email_invalid' => "Hedef e-posta adresi geçersiz.",
    'resp_edit__in_body' => "mesaj gövdesinde belirtilen sözcükler bulunduğunda",
    'resp_edit__in_subject' => "mesaj konusunda belirtilen sözcükler bulunduğunda",
    'resp_edit__invalid_resp_freq' => "Cevap frekansı geçerli değil.",
    'resp_edit__invalid_rqst_txt' => "Geçersiz talep metni.",
    'resp_edit__invalid_store_lim_num' => "Limit değeri geçerli değil.",
    'resp_edit__limits_title' => "Limitler",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Günlük maksimum yanıt sayısı, tanımlanan oranı aşıyor.  İzin verilen: %1, istendi: %2",
    'resp_edit__no_files_sel' => "Hiçbir dosya seçilmedi.",
    'resp_edit__no_txt_supplied' => "Metin belirtilmedi.",
    'resp_edit__reply_title' => "Cevapla",
    'resp_edit__reply_to_address' => "Dönüş adresi",
    'resp_edit__reply_to_invalid' => "Dönüş adresi geçerli değil.",
    'resp_edit__reply_uniq_email' => "Benzersiz e-posta adresine cevap için en fazla",
    'resp_edit__conditions_title' => "Koşullar",
    'resp_edit__request_title' => "Talep et",
    'resp_edit__resp' => "Otomatik yanıt",
    'resp_edit__resp_name' => "Otomatik yanıt adı",
    'resp_edit__resp_not_exist' => "Otomatik yanıt yok.",
    'resp_edit__resp_status' => "Otomatik yanıt durumu",
    'resp_edit__rqst_txt' => 'Bu otomatik yanıtın koşulunu belirtin',
    'resp_edit__select_files_on_server_for_attach' => "Eklemek istediğiniz dosyaları seçiniz",
    'resp_edit__store_up_to' => "Bu kadar sakla",
    'resp_edit__subj_line_invalid' => "Konu satırı geçersiz.",
    'resp_edit__text_too_big' => "Cevap metni çok uzun.",
    'resp_edit__times_in_a_day' => "kere/gün.",
    'resp_edit__unable_define_resp_cond' => "Otomatik yanıt koşulu tanımlanamıyor: %1",
    'resp_edit__unable_define_resp_status' => "Otomatik yanıt durumu tanımlanamıyor: %1",
    'resp_edit__unable_turn_on_resp' => "Otomatik yanıt açılamıyor: %1",
    'resp_edit__uniq_email' => "benzersiz e-posta adresleri",
    'resp_edit__content_type' => 'Posta gönderme biçimi',
    'resp_edit__content_type_text' => 'Düz Metin',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kodlama',
    'restart__dns' => 'DNS Sunucusu (%1)',
    'restart__drweb' => 'Plesk Premium Antivirüs',
    'restart__mail' => "IMAP/POP3 Sunucusu (%1)",
    'restart__mssql' => "Microsoft SQL sunucusu",
    'restart__mysql' => "MariaDB/MySQL sunucusu",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Servisler",
    'restart__smtp' => "SMTP Sunucusu (%1)",
    'restart__spamd' => "İstenmeyen Posta Filtresi",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "WEB Sunucusu (%1)",
    'restart__ftp' => "FTP Sunucusu (%1)",
    'restart__service_start' => 'Lütfen servisin başlaması için birkaç saat geçmesine izin verin.',
    'restart__service_stop' => 'Lütfen servisin durması için birkaç saat geçmesine izin verin.',
    'restart__service_restart' => 'Lütfen servisin yeniden başlaması için birkaç saat geçmesine izin verin.',
    'rm_domains__some_domains_are_not_exist' => "Belirtilen alan adlarının bazıları yok. Bir olasılık başka bir kullanıcı tarafından kaldırılmış olabilirler.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGrup",
    'rpt_cl_dom_mail_lists' => "MList",
    'rpt_cl_dom_mail_resps' => "OtCvp",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirüs",
    'rpt_cl_dom_postboxes' => "Postkt",
    'rpt_cl_dom_redirects' => "İleticiler",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUser",
    'rpt_cl_report_for_admin__' => "Yönetici %1 için rapor",
    'rpt_cl_report_for_reseller__' => "Satıcı %1 için rapor",
    'rpt_cl_report_for_cl__' => "Müşteri %1 hakkında rapor",
    'rpt_cl_section_domains' => "Alan Adları",
    'rpt_cl_section_full_domains' => "Alan Adları",
    'rpt_cl_section_general' => "Genel",
    'rpt_create' => "Rapor oluştur",
    'rpt_empty' => "Rapor en az bir bölüm içermelidir",
    'rpt_dom_report_for_dom__' => "%1 için alan adı raporu",
    'rpt_dom_section_databases' => "Veritabanları",
    'rpt_dom_section_full_databases' => "Veritabanları",
    'rpt_dom_section_full_maillists' => "Postalama listeleri",
    'rpt_dom_section_full_mailnames' => "Posta hesapları",
    'rpt_dom_section_full_webusers' => "Web Kullanıcıları",
    'rpt_dom_section_full_siteapps' => 'Web uygulamaları',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET web uygulamaları',
    'rpt_dom_section_general' => "Genel",
    'rpt_dom_section_hosting' => "Barındırma",
    'rpt_dom_section_maillists' => "Postalama listeleri",
    'rpt_dom_section_mailnames' => "Posta hesapları",
    'rpt_dom_section_siteapps' => 'Web uygulamaları',
    'rpt_dom_section_aspnetapps' => 'ASP.NET web uygulamaları',
    'rpt_dom_section_webusers' => "Web Kullanıcıları",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Raporu düzenle %1",
    'rpt_enter_email_address' => "Raporun teslim edileceği e-posta adresini girin.",
    'rpt_list' => "Özel rapor görünümleri",
    'rpt_section_full' => "Dolu",
    'rpt_section_none' => "Hiçbiri",
    'rpt_section_summary' => "Özet",
    'rpt_default_full' => 'Tam rapor',
    'rpt_default_summary' => 'Özet Rapor',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Rapor gönderiminde hata oluştu: %1",
    'rpt_send_report_by_email_ok__' => "Rapor %1 konumuna gönderildi",
    'sa_action' => "İşlem",
    'sa_action_del' => "Sil",
    'sa_action_desc' => "SPAM mesaj ile ne yapılacak",
    'sa_action_save' => "Spam olarak işaretle ve posta kutusunda sakla",
    'sa_admin_blacklist' => "Yöneticinin Kara Listesi",
    'sa_admin_whitelist' => "Yöneticinin Beyaz Listesi",
    'sa_db_del_confirm' => "Gereksiz Posta Filtresi veritabanını silmek istediğinizden emin misiniz?",
    'sa_eml_in_ignorelist' => "E-posta, göz ardı etme listesinde",
    'sa_empty_email' => "Boş e-posta deseni eklenemiyor.",
    'sa_exists_email' => "Böyle bir e-posta deseni zaten var.",
    'sa_disabled__mailname_not_filtering' => "Geçerli sunucu ayarları, bu posta hesabı için posta filtrelemesi kullanılmasına izin vermez",
    'sa_disabled__filtering_is_disabled' => 'Gereksiz posta filtrelemesi sunucu yöneticisi tarafından kapandı',
    'sa_disabled__hasnt_mailbox' => "Bir posta kutusu olmadan gereksiz posta filtrelemesini açmak imkansızdır",
    'sa_enable_filter' => "Gereksiz posta filtrelemeyi açın",
    'sa_forget' => "unut",
    'sa_from' => "Kimden",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Patern geçerli değil.",
    'sa_spam' => "istenmeyen Posta",
    'sa_trainer__page_title' => 'Gereksiz posta filtresi eğitimi',
    'sa_trainer__tools_legend' => 'Araçlar',
    'sa_trainer__info_legend' => 'Bilgi',
    'sa_trainer__messages_list_legend' => 'Posta kutunuzdaki iletiler',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Konu',
    'sa_trainer__from' => 'Kimden',
    'sa_trainer__date' => 'Tarih',
    'sa_trainer__info_text' => 'Öğrenilen iletiler: %1 istenmeyen posta, %2 istenmeyen posta değil, %3 toplam.',
    'sa_trainer__messages' => 'iletiler',
    'sa_trainer__select__all' => 'Hepsi',
    'sa_trainer__select__spam_only' => 'İstenmeyen Posta',
    'sa_trainer__select__ham_only' => 'İstenmeyen Posta Değil',
    'sa_trainer__select__unknown_only' => 'Bilinmiyor',
    'sa_trainer__cannot_remove_messages' => 'Seçilen iletiler posta kutusundan kaldırılamıyor.',
    'sa_trainer__remove_messages_confirm' => 'Seçilen iletileri posta kutusundan kaldırmak istediğinizden emin misiniz?',
    'sa_subj' => "Konu",
    'sa_training' => "Gereksiz posta filtresi eğitimi",
    'sa_training_legend' => "Bayesian filtresi öğrenimi",
    'sa_use_srv_settings' => "Sunucu genel Ayarlarını kullan",
    'sa_user_blacklist' => "Kullanıcının Kara Listesi",
    'sa_user_whitelist' => "Kullanıcının Beyaz Listesi",
    'sa_usr_disabled_by_srv' => "Sunucu yöneticisi tarafından bireysel gereksiz posta filtreleme ayarlarına izin verilmedi",
    'sa_usr_no_postbox' => "Posta kutusu bu e-posta hesabı için kapalı olduğundan, gereksiz posta filtrelemesi etkinleştirilemiyor.",
    'sa_filters' => 'İstenmeyen posta filtreleri',
    'spamfilter__tools_legend' => 'Araçlar',
    'spamfilter__prefs_legend' => 'Ayarlar',
    'spamfilter__max_children' => 'Çalışacak işçi spamd işlemlerin maksimum sayısı',
    'spamfilter__rewrite_header_subject_hint' => 'Herhangi bir metin eklemek istemiyorsanız, bu alanı boş bırakın. Puanı mesaj konusuna dahil etmek istiyorsanız, _SCORE_ yazın.',
    'spamfilter__reject_spam' => 'Gereksiz postayı posta kutusuna geldiğinde silin',
    'spamfilter__enabled' => 'Açık',
    'spamfilter_addresses_list__items' => 'adresler',
    'spamfilter_addresses__remove_title' => 'Aşağıdaki adresler listeden kaldırılacak:',
    'spamfilter_addresses__empty_selection' => 'Hiçbir adres seçilmedi.',
    'server__admin_info' => "Yönetici Bilgileri",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Bu detaylarını aşağıda belirtiniz",
    'server__power_management' => "Güç Yönetimi",
    'server__services' => "Servisler",
    'server__system' => "Sistem",
    'server__title' => "Sunucu Yönetimi",
    'server_preferences__admin_skin' => "Yöneticinin arayüz dokusu",
    'server_preferences__default_language' => "Varsayılan dil",
    'server_preferences__default_skin' => "Varsayılan Arayüz",
    'server_preferences__restart_apache_interval' => "Apache restart aralığı",
    'server_preferences__system' => 'Sistem Ayarları',
    'mail__tabs_preferences' => "Ayarlar",
    'mail__tabs_white_list' => "Beyaz Liste",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Sözlükteki posta kutularının şifrelerini kontrol edin",
    'sessions__agreement' => "Evet, Bu Oturumları sonlandırmak istiyorum.",
    'sessions__select_sessions_for_remove' => "Silmek için Oturumları seçiniz.",
    'sessions__tabs_cp_sessions' => 'Plesk Oturumları',
    'sessions__tabs_ftp_sessions' => 'FTP Oturumları',
    'sessions__ftp_sessions_login' => 'FTP hesabı kullanıcı adı',
    'sessions__ftp_sessions_domain' => 'Alan adı',
    'sessions__ftp_sessions_path' => 'Mevcut Konum',
    'sessions__ftp_sessions_file' => 'Dosya adı',
    'sessions__ftp_sessions_action' => 'Durum',
    'sessions__ftp_sessions_speed' => 'Hızı, KB/S',
    'sessions__ftp_sessions_comp' => 'İşlem, %',

    'site_apps__access_level' => 'Erişim seviyesi',
    'site_apps__access_level_commercial' => 'Ticari',
    'site_apps__access_level_free' => 'Ücretsiz',
    'site_apps__action_installer' => "Web uygulaması kurulumu",
    'site_apps__action_reconfigure' => "Web uygulamasını yeniden yapılandırma",
    'site_apps__custom_button_level' => 'Bu uygulamaya erişmek için bir özel düğme oluşturmak ister misiniz?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Hayır',
    'site_apps__custom_button_level_domain_user_only' => 'Evet',
    'site_apps__custom_button_level_false' => 'Hayır',
    'site_apps__custom_button_level_domain' => 'Evet ve onu sadece geçerli alan adı için kullanılabilir hale getirin',
    'site_apps__custom_button_level_client' => 'Evet ve onu müşterinin tüm alan adları için kullanılabilir hale getirin',
    'site_apps__custom_button_level_admin' => 'Evet ve onu tüm alan adları için kullanılabilir hale getirin',
    'site_apps__description' => "Tanım",
    'site_apps__dir_used_by_sapp__' => "Dizin _\"%1_\", başka bir web uygulaması tarafından kullanılıyor",
    'site_apps__dir_used_by_unknown__' => "Dizin _\"%1_\" zaten var. Devam ederseniz, içeriğinin üzerine yazılır.",
    'site_apps__dir_invalid_name__' => "Dizin adı %1 yanlış",
    'site_apps__file_name' => 'Web uygulaması dosya adı',
    'site_apps__invalid_install_prefix' => "Geçersiz kurulum ön eki",
    'site_apps__invalid_package' => "Web uygulaması geçersiz",
    'site_apps__key_status' => 'Lisanslama',
    'site_apps__key_status_free' => 'Serbest olarak dağıtılır. Gerekli hiçbir lisans anahtarı yok',
    'site_apps__key_status_ok' => 'Gerekli lisans kurulmuş',
    'site_apps__key_status_problem' => 'Gerekli lisans kurulu değil',
    'site_apps__name' => "Adı",
    'site_apps__no_domains' => 'Web uygulaması kurulamıyor. Zaten bu alan adının kök dizinine kurulu başka bir web uygulaması var. Web uygulaması için bir alt alan adı oluşturmayı düşünün.',
    'site_apps__package_info_' => "Web Uygulaması Bilgileri",
    'site_apps__package_integrated' => "tümleşik uygulamadır, kaldırılamaz",
    'site_apps__pool_select_packages_to_add' => 'Havuza eklenecek web uygulamalarını seçin',
    'site_apps__release' => "Sürüm",
    'site_apps__resource_used_by_sapp' => "Bu kaynak, yüklü web uygulaması tarafından kullanılır",
    'site_apps__root_used_by_sapp' => "Bu kaynak, yüklü bir web uygulaması tarafından kullanılır.",
    'site_apps__these_domains_will_not_delete' => 'Bu (alt) alan adları silinmeyecek',
    'site_apps__upload_site_app_pkg_title' => 'Yeni web uygulaması yükleyin',
    'site_apps__version' => "Versiyon",
    'site_apps__access_to' => "%1e erişim",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Arşiv, paketinden çıkartılamıyor.  Sunucuya arşivleyici yüklenmemiş olabilir. Arşivleyici yazılımının kurulmasını sağlaması için {$PROD_NAME} yöneticisiyle irtibata geçin.",
    'skeleton__archive_corrupted' => "Archive denetimi: arşiv dosyası bozuk veya desteklenmiyor.",
    'skeleton__archive_too_large' => "Archive denetimi: dosya boyutu çok büyük.",
    'skeleton__not_supported_archive_type' => "Bu tip arşiv (dosya %1) desteklenmiyor",
    'skin_download__title' => 'Dış Görünümü İndirin',
    'skin_download_now__title' => 'Arayüz download işlemi',
    'skin_download_now__text' => 'Dış görünüm paketini oluşturma sürüyor.<br>Bu prosedür biraz zaman alabilir.<br> İletişim kutusu penceresi göründükten sonra, Plesk\'le çalışmaya devam edebilirsiniz.',
    'skin_file__help_for_using_types' => "Lütfen bu formattaki bir doku seçiniz",
    'skin_info__title' => 'Arayüz doku özellikleri',
    'skin_mng_err__rpm_not_skin' => 'Bu RPM bir Plesk dış görünüm paketi değil',
    'skin_mng_err__psa_install_noreloc' => 'Belirtilen konuma devir/dakika tabanlı dış görünümü kurma başarısız oldu.',
    'skin_mng_err__already_exists' => 'Dış görünüm kurulum dizini zaten var ve dağıtılmış bir dış görünüm paketi var.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Karşıya yüklenen dosya, geçerli bir RPM dış görünüm paketi değil.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Karşıya yüklenen dosya, geçerli bir dış görünüm paketi değil.',
    'skin_mng_err__rpm_upgrade_base' => "Karşıya yüklenen dosya, geçerli bir {$PROD_NAME} dış görünüm paketi değil.",
    'skin_mng_err__rpm_upgrade_other' => 'Dış görünüm kurulamıyor: geçersiz dış görünüm biçimi.',
    'skin_mng_err__no_a_skin' => "Karşıya yüklenen dosya, geçerli bir {$PROD_NAME} dış görünüm paketi değil.",
    'skin_upload__title' => 'Yeni Arayüz dokusu yükle',
    'skin_upload__already_exists' => "Arayüz '%1' sistemde mevcut",
    'skin_upload__unable_to_apply' => "Karşıya yüklenen dosya, bir Plesk dış görünümü içermiyor veya arşiv biçimi desteklenmiyor.",
    'skin_upload__unable_to_rename__' => "Dış görünüm %2, %1 olarak yeniden adlandırılamıyor: %3.",
    'skin_upload__file_name' => 'Arayüz dosya yolu',
    'skins_list__title' => 'Arayüz deposu',
    'skins_remove__title' => 'Arayüz kaldır',
    'skins_remove__select_skins_for_remove' => 'Kaldırılacak kaplamaları seçin',

    'spf__unable_update' => 'SPF parametreleri güncellenemiyor',
    'statistics__active_domains' => "Aktif alan adları",
    'statistics__clients' => "Müşteriler",
    'statistics__subdomains' => "Alt alan adları",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Veritabanları",
    'statistics__db_users' => "veritabanı kullanıcıları",
    'statistics__dirs' => "Korunmuş dizinler",
    'statistics__dom_active' => "Etkin",
    'statistics__dom_passive' => "Kapalı",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Alan Adları",
    'statistics__domains_with_host' => "Barındırmalı alan adları",
    'statistics__doms' => "Alan Adları",
    'statistics__filesystem' => "Dosya sistemi",
    'statistics__general' => "Genel",
    'statistics__hdd_available' => "Müsait",
    'statistics__hdd_capacity' => "Kapasite",
    'statistics__hdd_total' => "Toplam",
    'statistics__hdd_usage' => "Hard Disk kullanımı",
    'statistics__hdd_used' => "Kullanılmış",
    'statistics__ip' => "IP Adresi",
    'statistics__key_number' => "Anahtar numarası",
    'statistics__l1' => "Son 1 dakika",
    'statistics__l15' => "Son 15 dakika",
    'statistics__l5' => "Son 5 dakika",
    'statistics__la' => "CPU kullanımı",
    'statistics__mail_autoresponders' => "Otomatik yanıtlar",
    'statistics__mail_boxes' => "Posta kutuları",
    'statistics__mail_groups' => "E-posta grupları",
    'statistics__mail_lists' => "Postalama listeleri",
    'statistics__mail_redirects' => "Posta ileticileri",
    'statistics__mem' => "Memory kullanımı",
    'statistics__mem_usage' => "Kullanım",
    'statistics__memory_available' => "Müsait",
    'statistics__memory_buffer' => "Ara bellek",
    'statistics__memory_cached' => "Önbelleğe alınmış",
    'statistics__memory_free' => "Boş",
    'statistics__memory_shared' => "Paylaşılan",
    'statistics__memory_total' => "Toplam",
    'statistics__memory_used' => "Kullanılmış",
    'statistics__os' => "İşletim Sistemi",
    'statistics__problem_clients' => "Sorunlu müşteriler",
    'statistics__problem_domains' => "Sorunlu alan adları",
    'statistics__swap' => "Kullanımı Değiştir",
    'statistics__swap_free' => "Boş",
    'statistics__swap_total' => "Toplam",
    'statistics__swap_usage' => "Kullanım",
    'statistics__swap_used' => "Kullanılmış",
    'statistics__system_stat' => "Sunucu Bilgileri",
    'statistics__unable_define_active_doms' => "Etkin alan adlarının sayısı belirlenemiyor: %1",
    'statistics__unable_define_inactive_doms' => "Etkin olmayan alan adlarının sayısı belirlenemiyor: %1",
    'statistics__failed_define_swap_usage' => 'Değiştirme Kullanımı tanımlanamadı',
    'statistics__failed_define_load_averages' => 'Yük Ortalamaları tanımlanamadı',
    'statistics__up_time' => "Sistem Açık Kalma Süresi:",
    'statistics__ver' => "Versiyon",
    'statistics__web_users' => "Web Kullanıcıları",
    'statistics__mem_win' => "Fiziksel Bellek Kullanımı",
    'statistics__memory_total_win' => "Toplam",
    'statistics__memory_used_win' => "Kullanılmış",
    'statistics__memory_free_win' => "Müsait",
    'statistics__swap_win' => "Sanal Bellek Kullanımı",
    'statistics__swap_total_win' => "Toplam",
    'statistics__swap_used_win' => "Kullanılmış",
    'statistics__swap_free_win' => "Müsait",
    'status__domain_has_reasons_to_be_off' => "Alan adı, aşağıdaki nedenle halen askıda: %1",
    'subdomain__create__' => "%1 alan adında bir alt alan adı oluşturun",
    'subdomain__edit__' => "%1 alt alan adını yönetin",
    'subdomain__invalid_name' => "Geçersiz alt alan adı: Sadece alfasayısal karakterler ve çizgi simgeleri kullanın.",
    'subdomain__incorrect_name' => "Geçersiz alt alan adı.",
    'subdomains__maillists_enabled_in_domain' => "Yanlış alt alan adı listeleri.%1: Bu alan adı zaten %1 alan adındaki postalama listesinde kullanımda.",
    'subdomains__dalias_exists' => 'Adı böyle olan bir takma alan adı zaten var.',
    'subdomains__name_exists' => "Adı böyle olan alt alan adı zaten var.",
    'subdomains__regular_domain_exists' => "Adı böyle olan bir alan adı zaten var.",
    'subdomains__domain_alias_exists' => 'Adı böyle olan bir takma alan adı zaten var.',
    'subdomains__remove_subdomains_on_domain' => "Alan adı %1 için aşağıdaki alt alan adları kaldırılacak:",
    'subdomains__select_subdomains_for_remove' => "Silinecek alt alan adını seçin.",
    'subdomains__webmail_enabled_in_domain' => "Yanlış alt alan adı web postası.%1: Bu alan adı, %1 alan adı altındaki web postasına erişmek için kullanılır.",
    'subdomains__dns_record_already_exists' => '%1 alt alan adı oluşturulamıyor, çünkü ana bilgisayara %1 işaret eden bir DNS kaydı zaten var.',
    'subdomains__www_prefix_in_domain' => "Yanlış alt alan adı www.%1: Alan adı %1 zaten WWW önekine sahip.",
    'subdomains__user_type_quota_exceeds' => 'Ayrılan disk alanını aşmasına neden olacağından, kullanıcı hesabı değiştirilemiyor.',
    'subdomains__creation_in_dns_slave' => "Plesk'in ad sunucusu, bu alan adı için bir ikincil ad sunucusu olarak çalışıyor. Alt alan adınızın düzgün bir biçimde çözümlenmesi için, birincil DNS sunucudaki bölge dosyasının %1 kaydını içerdiğinden emin olun.",
    'sys_user__attributes_not_changed' => "\nDeğiştirilemeyen sistem kullanıcı sembolleri: %1",
    'sys_user__no_access_without_password' => "Bir şifre ayarlamadınız. Sistem kullanıcısı oluşturulur, ancak bir şifre verilmediği sürece sistemde oturum açamaz. Devam etmek istiyor musunuz?",
    'sys_user__no_hard_quota' => "desteklenmiyor",
    'sysuser__zero_quota_is_unlimited' => "Sınırsız için 0 değerini verin",
    'template__num_excl_ips' => "Atanmış IP adreslerini müşteriye ayırın",
    'template__sel_sh_ips' => "Kullanıcı için Paylaşımlı IP Adreslerini seç",
    'template__av_sh_ips' => "Müsait paylaşımlı IP adresleri",
    'template__up_to_excl_ip' => "%1 IP Adresine kadar",
    'templates__all_clients' => "tüm müşteriler",
    'templates__cl_domain_templates' => "%1 için Şablonlar",
    'templates__cl_templates' => "Müşteri şablonları",
    'time__invalid_ip' => "Geçersiz IP adresi veya alan adı.",
    '__please_select_country' => 'Lütfen, ülkenizi seçin',
    'time__unable_set_time' => "Sistem saati ayarlanamadı: %1",
    'time__sinchronization_setup_error' => 'Zaman senkronizasyonu kurulamıyor: timemng başarısız: %1',
    'time__sinchronization_disable_error' => 'Zaman senkronizasyonu devre dışı bırakılamıyor: timemng başarısız: %1',
    'tmpl__create' => "Şanlon oluştur",
    'tmpl__edit__' => 'Şablon %1',
    'tmpl__logrotation_warn' => "Bu şablonla oluşturulan alan adındaki günlük döndürmesi ancak onun için devamında fiziksel barındırma hesabı oluşturulduğunda gerçekleştirilir.",
    'tmpl__name' => "Şablon adı",
    'tmpl__dom_exist' => "Yöneticinin veya müşterinin şablon havuzunda adı böyle olan bir alan adı şablonu zaten var.",
    'tmpl__name_invalid' => "Şablon adı geçerli değil yada boş.",
    'tmpl__use_next_ip_addr' => "Bir sonraki müsait IP kullanılacak",
    'tmpl_name_already_exists' => "Adı '%1' olan şablon zaten var.",

    'vh_based__no_free_ip_for_vh' => "IP tabanlı sanal barındırma için boş IP adresi yok. Lütfen bir IP adresi ekleyin.",

    'wu__at_domains_text' => "webuser@%1 erişim biçimine izin verin",
    'wu__unable_create' => "Web Kullanıcısı Oluşturma işlemi gerçekleştirilemedi: %1",
    'wu_edit__disk_quota' => "Disk kotası",
    'wu_edit__invalid_pass' => "Şifre geçerli değil.",
    'wu_edit__invalid_quota' => "Belirtilen disk alanının kota değeri geçersiz. Lütfen bir artı tamsayı girin.",
    'wu_edit__invalid_quota_value' => "Belirtilen disk alanı kotası, o sırada kullanılandan (%1MB) daha az.  Bazı işlevler kullanılamayabilir.  Devam etmek istediğinizden emin misiniz?",
    'wu_edit__not_create_pass' => "Bu eylem, yeni web kullanıcısı için bir şifre oluşturmaz.\nŞifre olmadığında kullanıcı oturum açamaz.",
    'wu_edit__unable_update' => "Web kullanıcısı güncelleme işlemi gerçekleştirilemedi: %1",

    'dns__tabs_general' => 'Bölge Ayarları',
    'dns__tabs_zone_settings' => 'SOA Kayıtları',
    'soa__seconds' => 'saniye',
    'soa__minutes' => 'dakika',
    'soa__hours' => 'saat',
    'soa__days' => 'gün',

    'DomainSubdirectory' => 'Hedef alt dizin',

    'filemanager__select_codepage' => 'Codepage Seçin:',

    'bt_server_app_add' => 'Sunucu Uygulaması Ekle',
    'packages_list' => 'Sunucu Uygulamaları',

    'bt_packages_management' => 'Paket Yönetimi',
    'pb__packages_management' => 'Uygulama Yönetimi',
    'bt_package_new' => 'Uygulama Ekle',
    '__packages' => 'Sunucu Uygulamaları',

    'dom_ctrl__mysql_dbase_space' => 'Toplam MariaDB/MySQL veritabanı kotası',
    'dom_ctrl__mssql_dbase_space' => 'Toplam MS SQL veritabanı kotası',

    'dns_add__enter_ixfr_path' => 'IXFR Yolunu gir',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT kaydı zaten var. Sadece bir SPF kaydı olabilir. Bir kayıt eklemek için, bir önceki varolanı silin.',

    'component_name__network' => 'Ağ',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Dokuyu ata',
    'bt_set_skin' => 'Dokuyu ata',
    'firewall__rule_already_exists' => 'Adı "%1" olan kural zaten var',
    'firewall__rule_readonly' => '"%1" kuralı salt okunur',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirüs',
    'antivirus__antivirus' => 'Antivirus koruması',
    'antivirus__antivirus_direction_off' => 'Kapalı',
    'antivirus__antivirus_direction_any' => 'Gelen ve giden posta',
    'antivirus__antivirus_direction_from' => 'Sadece giden posta',
    'antivirus__antivirus_direction_to' => 'Sadece gelen posta',
    'antivirus__unable_to_update_settings' => 'Antivirüs ayarları değiştirilemiyor: %1',




    '__normal' => 'Normal',
    '__low' => 'Düşük',
    '__high' => 'Yüksek',

    'mail__antivirus' => "Entegre posta sunucusu antivirüsü",
    'mail__use_internal_antivirus' => 'Entegre antivirüsü kullan',

    'sa__tabs_blacklist' => 'Kara Liste',

    '__mysql_databases' => 'MariaDB/MySQL Veritabanları',

    'cl_perm__mysql_dbase_space' => 'Toplam MariaDB/MySQL veritabanı kotası',
    'cl_perm__mssql_dbase_space' => 'Toplam MS SQL veritabanı kotası',
    'cl_perm__max_mssql_db' => 'Maksimum Microsoft SQL Veritabanı sayısı',
    'cl_perm__total_mboxes_quota' => 'Toplam posta kutusu kotası',

    'i_i_cl_on' => 'Müşteri hesabı etkin.',
    'i_i_cl_off_by_admin' => 'Müşteri hesabı yönetici tarafından askıya alındı.',

    'sa_exists_tn' => 'Ağ zaten listede.',

    'defaultcomponents__not_activated' => 'aktive edilmedi',

    'bt_traffic_at_domains' => 'Trafik',

    '__awstats_perl_warning' => 'Perl kurulu değilse AWstats çalışmayacaktır.',

    'class_client__mysql_dbase_space' => 'Değeri müşteri sınırını aşıyor.',
    'class_client__mssql_dbase_space' => 'Değeri müşteri sınırını aşıyor.',
    'class_client__max_mssql_db' => 'Değeri müşteri sınırını aşıyor.',

    'dns__remove_transfer_restrictions_list_items' => 'Aşağıdaki ağlar erişim denetimi listesinden kaldırılacak:',

    'bt_up' => "Çalışıyor",
    'bt_down' => "Çalışmıyor",

    'bt_install_selected' => 'Seçili Olanı Kur', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Alan adı başka bir IP adresine çözümleniyor: (%1). Lütfen DNS ayarlarını düzeltin.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Şu an kullanımda olan posta sunucusu, posta kutusuyla posta gruplarının aynı anda açılmasını desteklemez.  Posta gruplarını kapatmak için, posta kutusundaki Tamam tuşuna basın.  Her şeyi olduğu gibi bırakmak için İptal tuşuna basın.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Şu an kullanımda olan posta sunucusu, posta kutusuyla posta gruplarının aynı anda açılmasını desteklemez.  Posta kutusunu kapatmak için, posta gruplarındaki Tamam tuşuna basın. Her şeyi olduğu gibi bırakmak için İptal tuşuna basın.',

    'mysql_dbase_space_limit' => 'MariaDB/MySQL veritabanı alan sınırı',
    'mysql_dbase_usage' => 'MariaDB/MySQL veritabanı alanı kullanımı',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server veritabanı alanı sınırı',
    'mssql_dbase_usage' => 'Microsoft SQL Server veritabanı alanı kullanımı',

    '__statistics' => "istatistikler", //indirect

    'dns__soa_minimum_value_is_big' => '3 saatten fazla olan Minimum TTL değeri, alan adlarınızı alan adı yöneticilerinin bazıları için erişilemez kılabilir. Böyle bir değeri ancak alan adları kayıt memurunuz ısrar ettiğinde ayarlamanız önerilir.',

    'virusfilter__interface_not_available' => 'Kullanılabilir hiçbir virüs filtresi yok.',
    'virusfilter__none_virus_filter' => 'Hiçbiri',
    'virusfilter__mailname_status_text' => 'Antivirüs (%1)',
    'virusfilter__status_none' => 'kapalı',
    'virusfilter__status_any' => 'gelen ve giden posta',
    'virusfilter__status_outgoing' => 'sadece giden posta',
    'virusfilter__status_incoming' => 'sadece gelen posta',

    'visibility__root_override_parse_error' => '%1 dosyasında %2 satırında bir söz dizimi hatası var.',

    'sb__not_support_publishing_api' => "Yayımlama otomasyonu bileşen tarafından desteklenmiyor",

    'component_name__cphosting' => "Plesk Barındırma",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Posta kutusu kotasının ayarlanması geçerli posta sunucusu tarafından desteklenmiyor.',
    '__unable_get_total_mboxes_quota' => 'Posta kutusu kotasının ayarlanması geçerli posta sunucusu tarafından desteklenmiyor.',

    'install_prefix__parent_not_exists' => "Üst dizin yok.",

    'bt_change_version' => 'Sürüm Değiştir',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Tümünü Seç",
    '__uncheck_all' => "Tümünü Temizle",

    'dns__editing_domain_controller_zone' => "Alan adı kontrol birimi için DNS bölgesi kayıtlarını düzenlemek, çalışan alan adında sorunlara neden olabilir",

    'pb__interface_management' => "Arayüz Yönetimi",
    'interface_management__tabs_skins' => "Dış Görünümler",
    'interface_management__tabs_interface_templates' => "Arayüz Şablonları",
    'interface_management__tabs_locales' => "Yerel ayar değerleri",
    'locales_list__title' => "Dil paketleri deposu",
    'locales_list__legend' => "Kullanılabilir diller",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Dil paketi",
    'locales_list__lang_title' => "Dil",
    'locales_list__country_title' => "Ülke",
    'locales_list__used_title' => "Kullanılmış",

    'backup__suspend_warning_during_backup' => "Alan adı, yedekleme işlemi sırasında kullanılamaz",
    'backup__suspend_warning_during_restore' => "Alan adı, kurtarma işlemi sırasında kullanılamaz",
    'backup__suspend_domain' => "Alan adını askıya alın",

    'locales_list__mls_limit' => "Geçerli Plesk lisansınız, %2 dil kullanmanıza izin verir. Şu an kullanıcılar için %1 dili kullanılabilir hale getirindiniz ve bu, lisansla sağlanan sayıyı aşıyor. Lütfen kullanmak istediğiniz %2 dillerini seçin ve 'S' sütunundaki simgelerini tıklatarak diğerlerini kullanıcılar için kullanılamaz hale getirin.",

    'bt_change_owner' => 'Yeni Sahip Atayın',
    'chown__limit_name' => 'Kaynak adı',
    'chown__error_limits' => "Abonelik aktarmaya devam edilemiyor: bu abonelik, yeni sahibin sağlayıcısı tarafından sağlanabileceğinden daha fazla kaynak gerektirir.",
    'chown__error_empty_ip_pool' => "Abonelik aktarmaya devam edilemiyor: Yeni sahibin sağlayıcısının IP havuzu boş. Lütfen sağlayıcının havuzda en azından bir IP adresi bulunduğundan emin olun.",

    'backup__backup_time' => 'Yedekleme zamanı',
    'backup__backup_time_hour' => 'saat',
    'backup__backup_time_minute' => 'dakika',
    'backup__every' => 'her',
    'backup__day_of_month' => 'gün',

    'subdomain__select_hst_type' => 'Alt alan adı için barındırma tipini seçin',
    'hst_sel__subdom_subfolder_hst' => 'Alt klasörde alt alan adı',
    'subdomain__www_root_folder_not_exists' => '%1 site ana dizini yok',
    '__site_home_dir' => 'Site ana dizini',
    'subdomain__aspnet_disabled_domain' => 'alan adıyla kapalı',

    'domains__remove_description' => 'Alan adı ile ilgili alt alan adlarının içerik ve ayarları, web uygulaması verileri, posta kutusu içerikleri, posta, virüs önleme ve istenmeyen posta filtreleme ayarları, günlük dosyaları, alan adı yedekleme deposu verileri ve SSL/TLS sertifikası da dahil olmak üzere, tüm alan adı verileri silinecek. Yerel makinenizde bir yedekleme dosyanız yoksa, tüm veriler kalıcı olarak kaybolur.',
    'subdomains__remove_description' => 'Alt alan adı içerik ve ayarları, web uygulamaları verileri ve günlük dosyaları da dahil, tüm alt alan adı verileri silinir. Yerel makinenizde bir yedekleme dosyanız yoksa, tüm veriler kalıcı olarak kaybolur.',

    'mail__tabs_spam_filtering' => 'İstenmeyen Posta Filtreleri',
    'mail__tabs_antivirus' => 'Antivirüs',
    'antivirus__use_server_settings_scan' => 'Varsayılan sunucu çapındaki ayarları kullanın (Tarayın)',
    'antivirus__use_server_settings_no_scan' => 'Varsayılan sunucu çapındaki ayarları kullanın (Taramayın)',
    'antivirus__check_for_viruses' => 'Virüs taraması',
    'antivirus__dont_check_for_viruses' => 'Virüs taraması yapma',
    'antivirus__incoming_mail' => 'Gelen posta',
    'antivirus__outgoing_mail' => 'Giden posta',

    'domain_alias__CNAME_dns_record_exists' => 'Adı böyle olan bir DNS CNAME kaydı zaten var',
    'domain_alias__A_dns_record_exists' => 'Adı böyle olan bir DNS A kaydı zaten var',
    'domain_alias__bad_prefix' => 'Takma alan adı için yanlış önek',
    'domain_alias__domain_doesnt_exist' => "Alan adı yok",

    'dns__zone_ttl_message_info' => 'TTL değeri belirtilmediyse, bu DNS kaydı için SOA Kaydı Şablonu (%1) kullanılacaktır.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Seçilen web uygulamasına yönlendirmek için adı index.html olan bir dosya oluşturulacak.  index.html adında bir dosya zaten varsa, index.html.old adıyla yedeklenir ve yerine yenisi konur.  Onaylamak için Tamam tuşuna basın",

    'bt_ftp_ctrl' => "Ek FTP Hesapları",
    'ftp_users_no_permission' => "Bu alan adı için FTP hesaplarını yönetme izniniz yok",
    'ftp_users_limit_reached' => "Bu alan adı için FTP hesapları sınırına ulaşıldı",
    'pb__ftp_ctrl' => "FTP yönetimi",
    'class_client__max_subftp_users' => "Ek FTP hesapları",

    '__client_form_settings' => "Müşteri ayarları",
    '__sbnet_client_keep_sbnet' => "İlgili kullanıcı hesabını Presence Builder'da sakla",
    '__sbnet_cant_add_more_sites' => "Bu müşteri için Presence Builder'ı kullanabilen sitelerin miktarındaki sınırına ulaşıldı",
    '__sbnet_legend_text' => "Presence Builder entegrasyonu",
    '__sbnet_synchronize_user_with_sbnet' => "Presence Builder'da ilgili bir kullanıcı hesabı oluşturun",
    '__sbnet_client_warning_delete_sb_user' => "Bu müşteriyle ilişkili Presence Builder kullanıcı hesabını kaldırmaya çalışıyorsunuz.  Bu, tüm kullanıcıların web sitelerini ve ilgili diğer tüm ayarları Presence Builder sisteminden silerek, bu seçeneği daha sonra tekrar açtığınızda bile, varolan web sitelerini Presence Builder'la düzenleme özelliğini kaldırır. Daha sonra tekrar bir Presence Builder kullanıcı hesabı oluşturursanız, tüm web sitelerinizi sıfırdan oluşturmanız ve yayınlamanız gerekir. Web sitesi oluşturmayı kapatmak ve Presence Builder üzerinden yayınlamak istiyor musunuz?",
    'sb__build_site_with_subdomains' => "Web Günlüğü ve Fotoğraf Galerisi alt alan adları oluşturun",
    '__sbnet_client_dont_have_sbuser' => "Presence Builder kullanılarak site oluşturulamıyor ve yayınlanamıyor: Presence Builder Kullanıcısı yok",

    '__component_disabled' => "Bileşen kapalı",

    'subdomains__physical_path_not_exist' => "Var olmayan fiziksel klasörlere bağlı alt alan adları var",

    'dnsserver_bind_to_msdns_switching_warning' => "Uyarı: Erişim Kontrol Listesinde bulunan /8 ve /16 maskesi olan alt ağların sadece ilk 254 IP adresi aktarılır.  Bunlar ayrı IP adresleri olarak aktarılır. Devam etmek istiyor musunuz?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder siteleri için alan adınızda ASP.NET 2.0 desteği gerekebilir. Presence Builder'ı kullanıyorsanız, ASP.NET 2.0 desteğini etkinleştirmenizi öneririz.",

    'subdomain_auto_create_dir' => "Alt alan adı için fiziksel dizin oluşturun",

    'sa_trainer__unable_to_get_messages_list' => "Posta kutusundaki ileti listesi alınamıyor: %1",
    'sa_trainer__pass_doesnt_exist' => "Bu posta hesabının şifresi eksik",

    '__sitebuilder_error' => "Presence Builder'a bağlanmaya çalışılırken bir hata oluştu. Destek için servis sağlayıcınızla irtibata geçin.",
    'wsb_error_user_not_exist' => "Bu Presence Builder kullanıcı hesabı yok.",
    'wsb_error_site_already_exist' => "Bu site Presence Builder'da zaten var.",
    'wsb_error_site_limit_reached' => "Presence Builder siteleri sayısının sınırına ulaşıldı.",
    'wsb_error_internal_error' => "Dahili Presence Builder hatası oluştu. Destek için servis sağlayıcınızla irtibata geçin.",
    'wsb_error_user_already_exist' => "Presence Builder'da adı böyle olan Presence Builder kullanıcısı zaten var.",
    'sb_error_user_not_exist' => "Presence Builder kullanıcısı yok.",
    'wsb_error_object_not_found' => "Presence Builder doğru ana bilgisayar girişini bulamadı.",

    'mg_no_mail_groups' => "Posta grubu yok",

    'drweb__drweb_incoming' => 'Gelen postaların virüs önleme denetimi',
    'drweb__drweb_outgoing' => 'Giden postaların virüs önleme denetimi',
    'drweb__disable_reason_serv' => 'Posta sunucusu, posta kutusu seviyesindeki antivirüs filtresi ayarlarını desteklemez',

    'vz_sitebuilder3_client_cant_be_created' => "Müşteri hesabı oluşturulamıyor: SiteBuilder sürüm 3.1 veya üstü yüklü değil",

    // new limits

    'class_client__max_odbc' => "ODBC bağlantıları",
    'cl_perm__max_odbc' => "maksimum ODBC bağlantısı sayısı",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Takma alan adı',
    'domain_alias__list_ascii_name' => 'ASCII biçiminde',


    // Interface Customization Templates
    'interface_preferences' => 'Arayüz Yönetimi',
    'pb__interface_templates' => 'Arayüz Yönetimi',
    'pb__interface_clients' => '%1 kullanan müşteriler',

    // service management
    'bt_service_showall' => "Tümünü Göster",
    'bt_service_hideall' => "Tümünü Gizle",
    'bt_service_start' => "Başlat",
    'bt_service_stop' => "Durdur",
    'bt_service_restart' => "Yeniden başlat",
    'bt_service_disable' => "Kapatın",
    'bt_service_manual' => "Manuel",
    'bt_service_auto' => "Otomatik",
    'service_startup_auto' => 'Otomatik',
    'service_startup_manual' => 'Manuel',
    'service_startup_disabled' => 'Kapalı',
    'service_action_ok' => "%1 servisiyle işlem başarıyla tamamlandı",
    'service_action_failed_disabled_service' => "Kapandığından dolayı, işlem %1 servisiyle tamamlanamadı",
    'service_action_failed_error' => "İşlem tamamlanamadı: %1",
    'service_group_action_ok' => "Aşağıdaki servislerle işlem başarıyla tamamlandı: \n %1",
    'service_group_action_disabled' => "Kapandığından dolayı, işlem aşağıdaki servislerle tamamlanamadı: %1",
    'service_group_action_failed' => "İşlem, aşağıdaki servislerle tamamlanamıyor: \n %1. \n Ayrıntılı hata bilgilerini almak için, işlemi her servisle ayrı olarak gerçekleştirin",

    // php 4vs5
    'bt_php' => "PHP Ayarları",

    'bt_insert' => "Insert Tuşu",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder veritabanı hatası oluştu. Destek için servis sağlayıcınızla irtibata geçin.",
    'wsb_error_sitebuilder_access_denied_error' => "Dosyaya erişilemiyor: Presence Builder'ın gerekli dosya veya klasöre erişim hakkı yok. Destek için servis sağlayıcınızla irtibata geçin.",
    'wsb_error_sitebuilder_connection_failed' => "Bağlantı kaybolduğundan, Presence Builder'a bağlanılamıyor. Destek için servis sağlayıcınızla irtibata geçin.",
    'wsb_error_critical_during_operation' => "Kritik Presence Builder hatası oluştu:\n%1",
    'wsb_error_license_during_operation' => "Presence Builder lisans hatası oluştu:\n%1",
    'wsb_error_during_operation' => "Presence Builder hatası oluştu:\n%1",
    'wsb_error_license_error' => "Presence Builder lisans sınırlaması bulundu.",

    // Other
    '__confrim_service_stop' => "Uyarı! %1 servisini durdurursanız, Plesk'in çalışması durabilir. %1 servisini durdurmak istediğinizden emin misiniz?",
    'index_redirect_help_text' => 'Şimdi otomatik olarak gerekli web sitesine yönlendirilirsiniz.  Tarayıcınız yeniden yönlendirmeyi desteklemiyorsa, lütfen burada %2 %1 tıklatın',
    'bt_default_settings' => "Varsayılanı Geri Yükle",
    'logfiles__remove_failed' => "%1 dosyası silinemiyor: dosya, başka bir uygulama tarafından kilitlenmiş. Lütfen daha sonra yeniden deneyin",
    'subdomain__invalid_homedirectory' => "Belirtilen alt alan adının başlangıç dizini geçersiz",
    'scheduler_item__empty_filename' => "Lütfen çalıştırılacak yürütülebilir dosyayı belirtin",
    'subdomains__overlapped_domain_exists' => 'Alt alan adı, %1 alan adının DNS bölgesiyle çakışıyor',
    'subdomains__overlapped_domain_alias_exists' => 'Alt alan adı, %1 takma alan adının DNS bölgesiyle çakışıyor',
    'services_action_none_selected' => 'İşlem tamamlanamadı: lütfen gerekli servisleri seçin',
    'cl_perm__max_subftp_users' => "maksimum ek FTP hesapları sayısı",
    'login_up__access_denied_no_cp_access' => 'Erişim reddedildi. Plesk\'e erişme izniniz yok.',
    'drweb__disable_reason_admin' => "Sunucu ilkesi tarafından posta kutusu seviyesinde Antivirüs filtresi ayarlarına izin verilmez.",

    '__use_default' => 'Varsayılanı Kullan',

    'webalizer_hidden_referrer__already_exist' => 'Böyle bir giriş zaten var.',
    'webalizer_group_referrer__already_exist' => 'Adı böyle olan grup referansı zaten var.',

    'pb__dashboard' => 'Anasayfa',

    'server_interface__page_title' => 'Sunucu Arayüzü Ayarları',
    'server_interface__tabs_locales' => 'Yerel ayar değerleri',
    'server_interface__tabs_skins' => 'Dış Görünümler',
    'server_interface__tabs_interface_templates' => 'Arayüz Şablonları',
    'bt_server_interface' => 'Arayüz Tercihleri',
    'pb__server_interface' => 'Arayüz Tercihleri',

    'bt_wizard_next' => 'İleri >>',
    'bt_wizard_prev' => '<< Geri',

    '__limit_exceeded_max_dom_server' => 'Lisans anahtarının sunucuda izin verdiği alan adı sayısı sınırına ulaşıldığından, bu sunucuda daha fazla alan adı barındıramazsınız. Bu sorunu çözmek için, servis sağlayıcınızla irtibata geçin.',
    '__limit_exceeded_max_subdom_server' => 'Bu sunucuda daha fazla alt alan adı barındıramazsınız. Lütfen servis sağlayıcınızla irtibata geçin.',
    '__limit_exceeded_max_dom_aliases_server' => 'Bu sunucuda daha fazla takma alan adı ayarlayamazsınız. Lütfen servis sağlayıcınızla irtibata geçin.',
    '__limit_exceeded_max_wu_server' => 'Lisans anahtarının sunucuda izin verdiği web kullanıcısı sayısı sınırına ulaşıldığından, daha fazla web kullanıcısı oluşturamazsınız. Bu sorunu çözmek için servis sağlayıcınızla irtibata geçin.',
    '__limit_exceeded_max_mn_server' => 'Lisans anahtarının sunucuda izin verdiği posta hesabı sayısı sınırına ulaşıldığından, daha fazla posta hesabı oluşturamazsınız. Bu sorunu çözmek için servis sağlayıcınızla irtibata geçin.',

    '__limit_exceeded_max_cl_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan müşteri hesabı sayısının sınırına ulaştınız',
    '__limit_exceeded_max_dom_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan alan adları sayısının sınırına ulaştınız',
    '__limit_exceeded_max_subdom_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan alt alan adları sayısının sınırına ulaştınız',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Lisans anahtarınızla tanımlanan takma alan adları sayısının (%2) sınırına ulaştınız',
    '__limit_exceeded_disk_space_useradmin' => 'Hiçbir boş disk alanınız kalmadı',
    '__limit_exceeded_max_wu_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan web kullanıcısı hesabı sayısının sınırına ulaştınız',
    '__limit_exceeded_max_db_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan veritabanları sayısının sınırına ulaştınız',
    '__limit_exceeded_max_box_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan posta kutusu sayısının sınırına ulaştınız',
    '__limit_exceeded_max_mn_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan e-posta hesabı sayısının sınırına ulaştınız',
    '__limit_exceeded_max_maillists_useradmin' => 'Lisans anahtarınızla (%2) tanımlanan postalama listeleri sayısının sınırına ulaştınız',

    '__limit_exceeded_max_dom_userclient' => 'Alan adları sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Servis sağlayıcınızın izin verdiği alt alan adları sayısının (%2) sınırına ulaştınız',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Takma alan adları sayısının (%2) sınırına ulaştınız',
    '__limit_exceeded_disk_space_userclient' => 'Disk alanı kullanım sınırına (%2) ulaştınız',
    '__limit_exceeded_max_traffic_userclient' => 'Aylık bant genişliği kullanım miktarı sınırına (%2) ulaştınız',
    '__limit_exceeded_max_wu_userclient' => 'Servis sağlayıcınızın izin verdiği web kullanıcıları (%2) sayısının sınırına ulaştınız.',
    '__limit_exceeded_max_db_userclient' => 'Veritabanları sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_max_box_userclient' => 'Posta kutuları sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Postalama listelerinin sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_expiration_userclient' => '%2 tarihinde hesabınızın süresi doldu',

    '__limit_exceeded_max_subdom_userdomain' => 'Servis sağlayıcınızın izin verdiği alt alan adları sayısının (%2) sınırına ulaştınız',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Takma alan adları sayısının (%2) sınırına ulaştınız',
    '__limit_exceeded_disk_space_userdomain' => 'Disk alanı kullanım sınırına (%2) ulaştınız',
    '__limit_exceeded_max_traffic_userdomain' => 'Kullanılan aylık bant genişliği miktarı sınırına (%2) ulaştınız',
    '__limit_exceeded_max_wu_userdomain' => 'Web kullanıcısı hesaplarının (%2) sayısının sınırına ulaştınız',
    '__limit_exceeded_max_db_userdomain' => 'Veritabanları sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Posta kutuları sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Postalama listelerinin sayısının sınırına ulaştınız (%2)',
    '__limit_exceeded_expiration_userdomain' => '%2 tarihinde hesabınızın süresi doldu',

    'sapp_error_validation_not_found' => 'Web uygulaması doğrulanamıyor, çünkü gerekli dosyalardan (%1) biri bulunamadı.  Destek için teknik destek temsilcinizle irtibata geçin.',
    'sapp_error_validation_spec_failed' => 'Karşıya yüklenen web uygulaması, AppPacks spesifikasyonlarına uygun değil: %1.',
    'sapp_error_validation_register' => '"%1" dizininde bulunan web uygulaması kaydedilemiyor: %2 Düzgün çalışmayacağı için, web uygulamasını sunucudan kaldırmanız önerilir.',

    'sapp__install_failed' => 'Web uygulaması kurulumu başarısız: %1',
    'sapp__install_res_failed' => 'İstediğiniz kaynağı oluşturma başarısız oldu.',

    'server_preferences__subdomains_blog_and_photo' => 'Varsayılan olarak Web Günlüğü ve Fotoğraf Galerisi alt alan adları oluşturun',
    'plesk_key__blog_and_photo' => 'Web Günlüğü ve Fotoğraf Galerisi Oluşturun alt alan adları onay kutusunun varsayılan durumunu yönetme yeteneği',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Birden fazla kullanıcıya atanmış olduğundan, IP adres tipi atanmış olarak değiştirilemiyor.',

    // 8.1.1

    '__write_modify_warning' => 'Ek yazma/değiştirme izinlerini seçmek, bazı web uygulamalarının düzgün çalışmasını sağlar, ancak güvenlik risklerini de önemli ölçüde artırır',
    '__write_modify_subdomain_warning' => 'Ek yazma/değiştirme izinlerini seçmek, bazı web uygulamalarının düzgün çalışmasını sağlar, ancak güvenlik risklerini de önemli ölçüde artırır',

    'phosting__php_incorrect_version_used' => "PHP sürümü sorunları algılandı. Bu sorunları çözmek için, aşağıdaki gerekli PHP sürümüyle onay kutusunu işaretleyin ve Tamam seçeneğini tıklatın. Bu alan adındaki PHP'yi kapatmak için, PHP sürümünü seçmeden Tamam tuşunu tıklatın",
    'fp__mail_preferences' => 'Posta Ayarları',

    'mail__invalid_white_pattern' => 'Belirtilen değer geçersiz. Aşağıdaki biçimi kullanın: E-posta adresleri için posta@örnek.com, alan adları için örnek.com.',
    'mail__invalid_black_pattern' => 'Belirtilen değer geçersiz. Aşağıdaki biçimi kullanın: Eposta adresleri için posta@örnek.com, alan adları için örnek.com.',

    'resp_edit__reply_as_html' => 'HTML olarak gönderin',
    'exception__path_very_long' => "Yol çok uzun.  Lütfen yolda %1 karakterden az olduğundan emin olun.",

    // 8.2


    //SAPP
    'sapp_on' => 'Açık',
    'sapp_off' => 'Kapalı',
    'sapp_directive_aspect' => 'Zorunlu',
    'sapp_databases_num' => 'Veritabanları',
    'sapp_db_required' => 'Zorunlu',
    'sapp_Required' => 'Zorunlu',
    'sapp_Variant' => 'Varyant',
    'sapp_db_id' => 'Veritabanı kimliği',
    'sapp_db_id_type' => 'DB (kimlik: %1) tipi',
    'sapp_db_id_min_version' => 'DB (kimlik: %1) dak sürümü',
    'sapp_db_id_table_prefix' => 'DB (kimlik: %1) tablo öneki',
    'sapp_Default' => 'Varsayılan değer',
    'sapp_apache_mod_req' => 'Apache modülü',
    'sapp_dbtype_not_installed' => 'kurulu değil',
    'sapp_apache_mod_not_installed' => 'kurulu değil',
    'sapp_error_invalid_type' => '"%1" uygulaması, istediğiniz eylemi desteklemiyor.',
    'sapp_error_unknown_app_type' => 'Desteklenmeyen uygulama tipi: %1.',
    'sapp__ssl_text' => 'Uygulama "http://" veya "https://" sanal ana bilgisayara yüklensin mi?',
    'sapp__app_to_upgrade' => 'Yükseltilecek olan uygulamalar',
    'sapp__upgrade_apps_title' => 'Uygulamaları yükseltin',
    'sapp__upgrade_to_ver' => 'Sürüme yükseltin',
    'sapp__choose_pkg_ver' => 'Bir paket seçin...',
    'sapp__pkg_cant_upgrade_pkg' => '"%1" paketi, "%2" web uygulamasını yükseltmek için kullanılamaz.',
    'sapp__app_ugrade_error' => 'Uygulama yükseltilemiyor: %1. Lütfen sistem yöneticinize başvurun.',
    'sapp__no_suitable_db_found' => 'Uygun veritabanı bulunamadı.',
    'sapp__upgrade_success' =>  'Uygulama başarıyla yükseltildi.',
    'sapp__pkg_info_changelog' => 'Değişikliklerin geçmişi',
    'sapp_requirement_legend' => 'Uygulama için gereken barındırma özellikleri',

    // other
    'bt_apply' => 'Uygulayın',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Bir posta takma adı oluşturmak için, bu posta hesabında posta kutusunun açılması gerekir.  Posta kutusu açılsın mı?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Posta kutusunu kapatmak, çalışmayı durduracaklarından posta takma adlarını kaldırır.  Posta kutusu kapatılsın mı?',
    'antivirus__disable_reason_install' => 'Yüklenmediğinden, antivirüsü yönetemezsiniz.',
    'antivirus__disable_reason_key' => 'Uygun bir lisans anahtarıyla etkinleştirilmediğinden, antivirüsü yönetemezsiniz.',
    'antivirus__disable_reason_deny_personal_settings' => 'Sunucu ilkesi bireysel antivirüs ayarlarını yasakladığından, antivirüsü yönetemezsiniz.',
    'change_foreign_user_password' => 'Şifreyi değiştirin',
    'change_foreign_user_password_hint' => "Kullanıcı, bu uygulamaya ait değil. Başka bir uygulamaya gitmek ve orada kullanıcının şifresini değiştirmek için bağlantıyı tıklatın. Bunu yapmak için, uygulamada uygun yetilere sahip olmanız gerekir.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Dize Biçimi',
    'lang_unknown' => 'Bilinmeyen dil',
    'pb__cl_ed' => 'Müşteri ayrıntıları',
    'pb__actionlog' => 'Eylem günlüğü',
    'pb__cl_limits' => 'Müşteri sınırları',
    'pb__edit' => 'Düzenle',
    'pb__subdom_edit' => 'Barındırma ayarları',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Posta kutularının içeriğini yedekleme',

    'maillist_import_result' => "\nDosyadaki toplam e-posta adresi miktarı: %1\n içeri alınan e-posta adresi miktarı: %2\n zaten varolan e-posta adresi miktarı: %3\n belirtilen dosyadaki çoğaltılmış e-posta adresi miktarı: %4\n dosyadaki geçersiz e-posta adresi miktarı: %5",
    'maillist_import_error' => 'E-posta adresleri listesi içeri alınamıyor',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Seçtiğiniz dosya ya boş, ya da seçilen kodlamada geçerli bir HTML belgesi değil. Lütfen doğru kodlamayı seçin veya dosyaya doğrudan bir içerik ekleyin.",

    'dom_pref__external_mail_srv' => "IP adresiyle harici bir posta sunucusuna yeniden yönlendirin:",
    'mn_edit__store_messages' => 'Posta kutusu',

    // aps

    'sapp__before_upgrade_notice' => 'Yükseltme işlemini başlatmadan önce uygulama ve kullanıcı verilerini yedeklemeniz önerilir.',
    'sapp__application_properties' => 'Uygulama özellikleri',
    'sapp__application_root_descr' => 'Uygulamanın ana sayfası',

    'sapp__aps_license_invalid_id' => 'Lisans anahtarının geçersiz kimliği: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Anahtar numarası %1 olan lisans, veritabanında zaten var.',
    'sapp__aps_lic_del_used' => 'Lisans anahtarı silinemiyor; yüklü uygulamalardan biri tarafından kullanılıyor.',
    'sapp__aps_lic_del_unknown' => 'Lisans anahtarı silinemiyor: %1',
    'sapp__aps_cappi_duplicate' => "Bu uygulama zaten bu müşterinin uygulama havuzunda",
    'sapp__appi_not_shared_no_install' => "Müşterinin uygulama havuzunda böyle bir uygulama yok. Bu uygulamayı bir siteye kurmak istiyorsanız, önce bu uygulamayı müşterinin uygulama havuzuna eklemeniz gerekir.",
    'sapp__appi_shared_not_client' => "Müşterinin uygulama havuzunda böyle bir uygulama yok. Uygulamayı belirtilen sürüme yükseltmek istiyorsanız, önce bu uygulama sürümünü müşterinin uygulama havuzuna eklemeniz gerekir.",
    'sapp__apply_license_script_not_found' => 'Bu web uygulaması için "uygulama-lisansı" komut dosyası bulunamıyor.',
    'sapp__unable_to_activate_key' => 'Bir lisans anahtarını etkinleştirme denemesi sırasında bir hata oluştu: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Sistemde bu web uygulamasının varlığını gerektiren web uygulamaları kurulu.',
    'sapp__unable_to_delete_ai_in_pool' => 'Bu uygulama halen bir müşterinin havuzunda.  Bu uygulamayı kaldırmak istiyorsanız, önce onu tüm müşterilerin uygulama havuzlarından kaldırmanız veya parasız hale getirmeniz gerekir.',
    'sapp__unable_to_delete_app_template' => 'Uygulama #%1 kaldırılamıyor: %2',
    'sapp__limit_exceeded_client' => 'Bu web uygulamasını yükleyebileceğiniz (%2) sayının sınırına ulaştınız.',


    // atis module

    '_week_on' => 'hafta,',
    '__week_first' => 'birinci',
    '__week_second' => 'ikinci',
    '__week_third' => 'üçüncü',
    '__week_fourth' => 'dördüncü',
    '__week_last' => 'sonuncu',
    '__not_started' => 'Bekleme',
    '__started' => 'Koşuyor',
    '__cancel_pending' => 'İptal ediliyor',
    '__canceled' => 'İptal Edilmiş',
    '__error' => 'Hata',
    '__done' => 'Yapıldı',

    '__php_cgi_handler' => 'CGI uygulaması',
    '__php_isapi_handler' => 'ISAPI uzantısı',
    '__php_fastcgi_handler' => 'FastCGI uygulaması',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'farklı çalıştırın',

    'cf_dbfolder_text' => 'Veritabanı Klasörü',
    'cf_isnewdb_text' => 'Veritabanı Oluştur',
    'cf_isnewdb_title' => 'Veritabanının oluşturulması gerekiyorsa, onay kutusunu işaretle',

    'pb__site_apps_upgrade' => 'Web uygulamasını yükseltme',

    'detach' => 'Bağlantıyı Kes',
    'preferences' => "Şifre değiştir",

    'toolsbar__switch_user?' => "Başka bir kullanıcı hesabında oturum açmak istediğinizden emin misiniz?",
    '__aps_left' => 'Kalan kurulumlar',
    'aps__license_key' => 'Lisans anahtarı',
    'aps__download_code' => 'Lisans anahtarı indirmesi ve etkinleştirme kodu',
    'aps__license_key_hint' => 'Etkinleştirme kodunu kullanarak lisanslama sunucusundan alın',
    'aps__database_not_available' => 'kullanılamaz, lütfen alan adını veya müşteri sınırlarını kontrol edin',
    'aps__yes' => 'evet',
    'aps__no' => 'Hayır',
    '__click_to_enlarge' => 'Büyütmek için tıklatın',
    'site_apps__back_to_list' => 'Listeye geri dön',
    'sapp__pkg_info_installation_requirements' => 'Kurulum gereksinimleri',
    '__close_window' => 'Kapat',

    //SAPP END

    'skin_info__already_default' => 'Doku zaten varsayılan olarak atanmış.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirüs',
    'drweb:properties_page_title' => '%1 için plesk Premium Antivirüs Ayarları',
    'drweb:properties_legend' => 'Ayarlar',
    'drweb:status' => 'Mesajları virüs için denetle',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder Sihirbazı',
    'dom_site_builder' => 'Presence Builder Sihirbazını açmak için tıklatın.',
    'sb_plesk_admin_url' => 'Presence Builder sunucu URL\'si.  Bu adresin DNS\'de düzgün bir biçimde çözünmesini sağlayın',
    'sb_plesk_admin_login' => 'Sunucu yöneticisinin Presence Builder\'da oturum açması için kullanıcı adı',
    'sb_plesk_admin_password' => 'Yönetici şifresi',
    'sb_sitebuilder_preferences' => 'Presence Builder yöneticisinin kimlik bilgileri',
    'sb__server' => 'Presence Builder Sistem Yöneticisinin tercihleri',
    'sb__sitebuilder_support' => 'Presence Builder desteği',
    'sb_keep_sb_user' => 'İlgili kullanıcı hesabını Presence Builder\'da sakla',
    'sb_create_sb_user' => 'Presence Builder\'da ilgili bir kullanıcı hesabı oluşturun',
    'sb__build_site_using_sitebuilder' => "Presence Builder kullanılarak bir web sitesi oluşturun",
    'sb_no_current_sb_server_set' => 'Presence Builder bağlantısı henüz yapılandırılmamış: DNS bölgesi şablonuna Presence Builder sunucusuna işaret edecek bir A kaydı eklemeniz gerekir.',
    'sb_unable_update_sb_server_sb_return_message' => "Presence Builder sistemindeki bilgiler alınamıyor:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Presence Builder'a bağlanılamıyor: Yanlış kullanıcı adı veya şifre.",
    'sb_init_sb_manager' => "Presence Builder yöneticisini başlatma: %1",
    'sb_err_couldnt_connect_sb' => "Presence Builder sistemine bağlanma başarısız oldu.",
    'sb_err_client_dont_have_sbuser' => "Bu müşterinin Presence Builder'da bir kullanıcı hesabı yok.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder yapılandırılmamış.",
    'sb_err_you_dont_have_sbaccount' => "Sizi Presence Builder'da yetkilendirme başarısız oldu.",
    'sb_error_critical_during_operation' => "Presence Builder'da aşağıdaki hata oluştu:\n%1",
    'sb_err_sso_is_not_enabled' => "Plesk'te tek oturum açma desteği açık değil.",

    'warning__super_zone_exist' => "%1 bölgesi oluşturuldu, ancak bu bölge adı, başka bir kullanıcıya %3 ait olan ve zaten varolan başka bir bölgenin %2 bir alt bölgesidir. Bu mümkündür, ancak doğru kullanıcı hesabını seçtiğinizden emin olun.",
    'error__super_zone_exist' => "Üst bölgesi başka bir kullanıcıya ait olduğundan, DNS bölgesi oluşturulamıyor.",

    'locales__files_not_exits' => 'Yerel ayar değiştirilemiyor: Belirtilen arayüz dil paketi dosyaları sistemde yok.',
    'locales__unavailable' => 'Yerel ayar değiştirilemiyor: Belirtilen arayüz dil paketi kullanılamaz.',

    // DB BU

    'pb__dbbackup_list' => 'Veritabanı yedekleme dosyaları',
    // server
    'dbbackup__server_backup_settings' => 'Yedekleme',
    'dbbackup__network_temp_dir' => 'Geçici ağ dizini',
    'dbbackup__network_user' => 'Kullanıcı adı',
    'dbbackup__network_pass' => 'Şifre',
    // domain
    'dbbackup__add_database_legend' => 'Yedeklenmiş veritabanını geri yükleyin',
    'dbbackup__add_database_restore' => 'Veritabanını yedekleme dosyasından geri yükleyin',
    'dbbackup__add_database_file' => 'Veritabanı yedekleme dosyası',
    'dbbackup__add_database_user' => 'Varsayılan kullanıcı adı',
    'dbbackup__add_database_pass' => 'Varsayılan kullanıcı şifresi',
    'dbbackup__add_database_pass2' => 'Varsayılan kullanıcı şifresi onayı',

    'bt_dbbackup_now' => 'Yedekle',

    'bt_repair' => 'Onarın',

    'dbbackup__mssql_dump_upload_not_allowed' => 'SQL Server veritabanı dökümlerini karşıya yükleme, barındırma sağlayıcısı tarafından yasaklanmıştır.',

    // APS categories

    'cf_invalid_password' => 'Şifre, 16 karakterden uzun olamaz',
    'cf_invalid_description_length' => 'Açıklama 256 simgeden uzun olamaz',
    'ip_addr__ip_used_by_external_mail_server' => 'IP adresi %1 zaten harici posta sunucusu tarafından kullanılıyor',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP hesabı kullanıcı adı veya şifresi geçersiz. Lütfen doğru FTP kullanıcı kimlik bilgilerini belirtin.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Seri numarası değişikliklerinin sınırına ulaşıldı. Bugün başka hiçbir DNS bölgesi değişikliği gerçekleştirilemez.',
    'dns__zone_apply_changes' => 'DNS kayıtlarında yapılan değişiklikler henüz kaydedilmedi.  Değişiklikler, aşağıda vurgulanmıştır. Değişiklikleri DNS bölgesine uygulamak için Güncelleme seçeneğini tıklatın veya değişiklikleri iptal etmek için Geri Al seçeneğini tıklatın.',
    'dns__update_dns_zone' => 'DNS kayıtlarında yapılan değişiklikleri kaydetmek için tıklatın',
    'dns__revert_dns_zone' => 'DNS kayıtlarında yapılan değişiklikleri iptal etmek için tıklatın',
    'bt_revert' => 'Geri Al',
    'dns__dns_zone_has_beed_updated' => 'DNS kayıtlarında yapılan değişiklikler kaydedildi.',
    'dns__dns_zone_has_beed_reverted' => 'DNS kayıtlarında yapılan değişiklikler iptal edildi',
    'db__nondefault_server_not_allowed' => 'Varsayılan olmayan veritabanı sunucusunun kullanılmasına izin verilmez',

    'site_apps__non_removable' => 'Kaldırılamayan öğeler',
    'site_apps__non_removable_items' => 'Aşağıdaki ağı uygulamaları kaldırılamaz:',

    'rpt_reseller_section_general' => 'Genel',
    'rpt_reseller_section_domains' => 'Alan Adları',
    'rpt_reseller_section_clients' => 'Müşteriler',
    'statistics__cl_active_domains' => "Aktif alan adları",
    'rpt_reseller_cl_domains' => "Alan Adları",
    'rpt_reseller_cl_subdomains' => "Alt alan adları",
    'by__cl_domains' => "istemcilerin alan adları",
    'dom_ctrl__cl_mboxes' => "Posta kutuları",
    'rpt_reseller_cl_redirects' => "İleticiler",
    'rpt_reseller_cl_mail_groups' => "E-posta grupları",
    'rpt_reseller_cl_mail_resps' => "Otomatik yanıtlar",
    'rpt_reseller_cl_mail_lists' => "Postalama listeleri",
    'rpt_reseller_cl_web_users' => "Web Kullanıcıları",
    'rpt_reseller_cl_data_bases' => "Veritabanları",

    'statistics__active_clients' => 'Etkin abonelikleri olan müşteriler',
    'statistics__clients_active_domains' => 'Aktif alan adları',
    'statistics__clients_doms' => 'Alan Adları',
    'statistics__cl_doms' => 'Alan Adları',
    '__clients_subdomains' => 'Alt alan adları',
    '__clients_domains' => 'Alan Adları',
    'dom_ctrl__clients_mboxes' => 'Posta kutuları',
    'dom_ctrl__clients_redir' => 'İleticiler',
    'dom_ctrl__clients_mg' => 'E-posta grupları',
    'dom_ctrl__clients_resp' => 'Otomatik yanıtlar',
    'dom_ctrl__clients_maillists' => 'Postalama listeleri',
    'dom_ctrl__clients_wu' => 'Web Kullanıcıları',
    'dom_ctrl__clients_db' => 'Veritabanları',

    'dom_ctrl__cl_redir' => 'İleticiler', // to resolve!
    'dom_ctrl__cl_mg' => 'E-posta grupları', // to resolve!
    'dom_ctrl__cl_resp' => 'Otomatik yanıtlar', // to resolve!
    'dom_ctrl__cl_maillists' => 'Postalama listeleri', // to resolve!
    'dom_ctrl__cl_wu' => 'Web Kullanıcıları', // to resolve!
    'dom_ctrl__cl_db' => 'Veritabanları', // to resolve!

    'rpt_cl_section_clients' => 'Müşteriler',

    'rpt_admin_section_general' => 'Genel',
    'rpt_admin_section_resellers' => 'Satıcılar',
    'rpt_admin_section_clients' => 'Müşteriler',
    'rpt_admin_section_personal_clients' => 'Kendi müşterileri',
    'rpt_admin_section_domains' => 'Alan Adları',
    'rpt_admin_section_personal_domains' => 'Kişisel alan adları',

    'rpt_reseller_section_personal_domains' => 'Kişisel alan adları',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Fazla satışa izin verin",
    'limits__reseller_oversell_description' => "Fazla satma, satıcının ona gerçekte ayrılandan daha fazla kaynak satmasına izin verir.  Fazla satmaya izin verildiğinde, satıcı ilk kaynak ayırma yerine geçerli kaynak kullanımıyla yönetilir",
    'limits__overuse_block_text' => "Fazla kullanım ilkesi",
    'limits__overuse_block_true_text' => "Fazla kullanıma izin verilmez",
    'limits__reseller_overuse_block_true_description' => "Kaynakların fazla kullanımını engelle. Geçerli kaynak kullanımı, ilk kaynak ayırmayı aşamaz",
    'limits__overuse_block_false_text' => "Fazla kullanıma izin verilir",
    'limits__reseller_overuse_block_false_description' => "Kaynakların fazla kullanılmasını engelleyerek, satıcının bireysel olarak sağlanandan daha fazla kaynak kullanılmasına izin verir. Geçerli kaynak kullanımı, ilk kaynak ayırmayı aşabilir",
    'limits__reseller_overuse_notify_text' => "Satıcıyı kaynak sınırlarına ulaşma konusunda bilgilendirin",
    'reseller_perm__manage_sh_access_disabled' => "Satıcı, kabuk erişimine izin veremez veya onu yasaklayamaz",
    'reseller_perm__manage_sh_access_chrooted' => "Satıcı sadece chroot edilmiş bir ortama erişime izin verebilir",
    'reseller_perm__manage_sh_access_any' => "Satıcı herhangi bir kabuk tipine erişime izin verebilir",
    'template__reseller_num_excl_ips' => "Atanmış IP adreslerini satıcıya ayırın",

    // Reseller's Home page
    'domains__reseller_info' => "%1 müşteri, %2 alan adı, disk alanının %3 kadarı kullanıldı, verilerin %4 kadarı aktarıldı.",
    'domains__reseller_info_hiding_traffic' => "%1 müşteri, %2 alan adı, disk alanının %3 kadarı kullanıldı.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Tüm web uygulamaları artık kategorilere göre sıralanır ve bu sayede yüklemek için doğru uygulamayı seçmek kolaylaşır.",
    'feature__domainkeys__reseller' => "Gereksiz posta ve şifre çalma epostaları miktarını azaltmak için DKIM eposta gönderen doğrulaması mekanizmasını kullanabilirsiniz.",

    '__reseller_form' => "Satıcı formu",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Bu şablonu diğer kullanıcılar için kullanılabilir hale getirin",
    'template__shared_description' => "Müşterilerinizin bu şablonu kullanabilmesini istiyorsanız, bu seçeneği seçin.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Alan adı yöneticisi kabuk erişimine izin veremez veya onu yasaklayamaz",
    'domain_perm__manage_sh_access_chrooted' => "Alan adı yöneticisi sadece chroot edilmiş bir ortama erişime izin verebilir",
    'domain_perm__manage_sh_access_any' => "Alan adı yöneticisi herhangi bir kabuk tipine erişime izin verebilir",

    // APS Catalog
    'bt_add_to_vault' => "Depoya Ekleyin",
    'bt_hide_updates' => "Kullanılabilir güncellemeleri gizleyin",
    'bt_show_updates' => "Kullanılabilir tüm güncellemeleri gösterin",

    '__site_apps__applications' => "Başvurular",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Depoya eklemeyin için seçilen uygulamalar",
    'site_apps__application_selected' => "Seçildi",
    'site_apps__currently_in_vault' => "Diğer sürümler zaten depoda:",
    'site_apps__new_versions' => "Yeni sürümler:",
    'site_apps__patches' => "Yamalar:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Depoya eklenmesi planlanan uygulama sayısı: %1",
    'site_apps__applications_downloading_now' => "Aşağıdaki uygulamalar şu an indiriliyor: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Zaten depoda",

    // Server > Action Log
    'bt_skin_edit' => "Dış Görünüm Açıklamasını Düzenleyin",
    'limits__oversell_legend' => "Fazla satma",
    'limitsManager__limit_available_error' => "Gerekli kaynak miktarı (%%quantity%% %%limitName%%) ayrılamıyor.  Sadece %%available%% %%limitName%% kullanılabilir.",
    'limitsManager__limit_reserved_error' => "Gerekli kaynak kullanımı sınırı ayarlanamıyor (%%quantity%% %%limitName%%), çünkü yeni değer, müşterileriniz için ayrılan veya kendiniz tarafından kullanılan (%%reserved%% %%limitName%%) kaynakların miktarından azdır.",
    'limitsManager__limit_used_error' => "Gerekli kaynak kullanımı sınırı ayarlanamıyor (%%quantity%% %%limitName%%), çünkü yeni değer, zaten hesap ve siteleriniz tarafından kullanılan (%%used%% %%limitName%%) kaynakların gerçek miktarından azdır.",

    'domains_list__resource__filter_title' => "Kaynak Kullanımı",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS uygulamaları katalogu",
    'site_apps__applications_have_updates' => "Aşağıdaki uygulamaların güncellenmiş sürümleri kullanılabilir:\n%1\nGüncellemeleri görüntülemek için, Arama alanını görünür hale getirin, <b>Sadece güncellemeleri gösterin</b> onay kutusunu işaretleyin ve istediğiniz uygulamaları arayın.",
    'site_apps__progress_adding_to_vault' => "Havuza eklemeyin:",
    'site_apps__progress_done_message' => "İlerleme Durumu:",
    'site_apps__progress_applications_left' => "%1 / %2 uygulama kaldı",
    'site_apps__download_item_long_task_title' => "APS uygulamasını indirin (%1)",
    'site_apps__download_transaction_long_task_title' => "APS uygulamalarını APS Katalogundan indirin",
    'site_apps__last_check_for_updates' => "son güncelleme kontrolü: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Tüm planlanmış uygulamalar, Uygulama Deposuna başarıyla eklendi",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "Planlanan %1 uygulama, Uygulama Deposuna başarıyla eklendi.",
    'site_apps__no_search_results' => 'Hiçbir uygulama bulunamadı.  Farklı arama talebi deneyin veya uygulamalara kategorilere göre göz atın.',
    'site_apps__search_results_title' => 'Arama sonuçları',
    '__site_apps__search_by_application' => 'Uygulama adı',
    '__site_apps__search_by_vendor' => 'Satıcı',
    '__site_apps__search_by_vendor__all' => 'Tüm satıcılar',
    '__site_apps__search_by_packager' => 'Paketleyici',
    '__site_apps__search_by_certification_level' => 'Sertifika seviyesi',
    '__site_apps__search_by_cert__any' => 'Herzaman',
    '__site_apps__search_by_cert__silver_and_higher' => 'Gümüş ve üstü',
    '__site_apps__search_by_cert__gold_and_higher' => 'Altın ve üstü',
    '__retry' => 'Yeniden dene',
    'site_apps__application_packager_site' => 'Paketleyici',
    'site_apps__add_to_pool_message' => "Sınırsız miktarda kurulumlarla tüm satıcı ve müşterilere \"tümü için kullanılabilir\" olarak işaretli uygulamalar otomatik olarak dağıtılır. Sınırlı uygulamalar, bireysel bazda, özellikle belirtilen sayıda kullanılabilir kurulumlarla tüm satıcılara ve müşterilere manuel olarak dağıtılır.",
    'site_apps__make_available_for_all' => "Seçilen uygulamaları tüm kullanıcılar için kullanılabilir hale getirin",

    'site_apps__broadcast_app_text' => "Sınırsız miktarda kurulumlarla tüm satıcı ve müşterilere \"tümü için kullanılabilir\" olarak işaretli uygulamalar otomatik olarak dağıtılır. Sınırlı uygulamalar, bireysel bazda, özellikle belirtilen sayıda kullanılabilir kurulumlarla tüm satıcılara ve müşterilere manuel olarak dağıtılır.",
    'site_apps__broadcast_app_name' => 'Uygulamayı tüm kullanıcılar için kullanılabilir hale getirin',

    // User Application Pool per application
    'site_apps__available_clients' => 'Mevcut kullanıcılar',
    'site_apps__no_more_clients_to_add_to_pool' => 'Bu uygulamayı verebileceğiniz başka hiçbir kullanıcı hesabı yok',

    // Installed application instances
    'site_apps__installations' => 'Kurulumlar',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Alan adı ve IP adresi",
    '__assign_ip_address' => "IP adresini atayın",
    '__switch_on_service' => "Servisi açın",
    '__hosting_configuration' => "Barındırma yapılandırması",
    '__vrt_hst' => "Web sitesi barındırması",
    '__vrt_hst_hint' => "Bu sunucuda bir web sitesi barındırın.",
    '__fwd' => "İletim",
    '__web_hosting_settings' => "Barındırma ayarları",
    '__fwd_hint' => "Ziyaretçileri başka bir web sitesine yeniden yönlendirin.",
    '__none_hint' => "Şu an bir web sitesini barındırmayın.",
    '__login_hint' => "Bu kullanıcı adı, FTP üzerinden web sitenize erişmek için kullanılır",
    '__password_hint' => "Bu şifre, FTP üzerinden web sitenize erişmek için kullanılır",
    '__advanced_hosting_setup' => "Gelişmiş web sitesi barındırma ayarlarını yapılandırın",
    '__domain_creation_successful' => "Alan adı oluşturuldu.",
    'bt_hosting_settings' => "Barındırma Ayarları",
    '__change_hosting_type' => "Alan adı %1 için barındırma tipini değiştirin",
    '__hosting_type_change_warning' => "Barındırma tipini iletme veya barındırma yok şeklinde değiştirdiğinizde, sitenizle ilgili tüm dosyalar ve dizinler sunucudan kaldırılır.  Sitenizin yerel bir kopyasını kaydettiğinizden emin olun.",
    '__current_hosting_type' => "Geçerli barındırma tipi",
    '__new_hosting_type' => "Yeni barındırma tipi",
    '__fwd_settings' => "İletme ayarları",
    '__fwd_settings_legend' => "İletme ayarları",
    '__fwd_destination_url' => "Hedef URL",
    '__fwd_type' => "İletme tipi",
    '__fwd_type_standart' => "Standart iletme",
    '__fwd_type_standart_hint' => "Web sitesi ziyaretçilerini başka bir siteye yönlendirin ve yönlendirme hakkında bilgileri olması için onlara hedef adresi gösterin.",
    '__fwd_type_frame' => "Frame içinde yönlendirme",
    '__fwd_type_frame_hint' => "Web sitesi ziyaretçilerini başka bir siteye yönlendirin, ancak yönlendirme hakkında bilgileri olmaması için onlara hedef adresi göstermeyin.",
    '__hosting_type_template_warning' => "Seçtiğiniz barındırma tipi, şablonda belirtilen tipten farklıdır.  Devam ederseniz, seçilen şablondaki web barındırma ayarları göz ardı edilir. Seçilen barındırma tipini ayarlamak istediğinizden emin misiniz?",

    '__no_resellers_selected' => "En az bir satıcı hesabı seçmeniz gerekir.",

    'ippool_Manager__no_available_ips' => "IP havuzunda boş IP adresi yok.",
    'ippool_Manager__ip_shared' => "paylaşılan",
    'ippool_Manager__ip_exclusive' => "atanmış",

    'ippoolManager__ip_shared' => "paylaşılan",
    'ippoolManager__ip_exclusive' => "atanmış",

    '__users_list' => "Kullanıcı Sayısı",
    '__users' => "Kullanıcı Sayısı",
    '__user_name' => "Kullanıcının adı",

    'limit__name_max_dom_aliases' => "takma alan adları",
    'limit__name_max_subftp_users' => "ek FTP hesapları",
    'limit__name_max_mssql_db' => "Microsoft SQL Server veritabanları",
    'limit__name_max_iis_app_pools' => "IIS uygulama havuzları",
    'limit__name_max_odbc' => "ODBC bağlantıları",
    'total_mboxes_quota_unsupported' => 'posta sunucusu tarafından desteklenmiyor',
    'limit_soft__disk_space' => 'Disk alanına ulaştığında bildirin',
    'limit_soft__max_traffic' => 'Trafiğe ulaştığında bildirin',
    'limitsManager__commit_failed' => "Kaynak sınırları değiştirilemiyor.",
    'limitsManager__date_in_past' => "Yanlış son kullanım tarihi %1.",
    'limitsManager__limit_not_supported' => "Kaynak tipi %1 sınırları ayarlanamaz.",
    'limitsManager__limit_oversell_inconsistency' => "Fazla satış kapalıyken belirtilen kaynak miktarları ayrılamıyor.",
    'limitsManager__limit_overuse_inconsistency' => "Kaynak kullanımı, tanımlı sınırları aşıyor.",
    'limitsManager__no_resource_available' => "Bu tipten (%%limitName%%) kalan kullanılabilir kaynak yok.  İstenen: %%quantity%%; kullanılabilir: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Servis sağlayıcınızdan kullanabileceğiniz bu tip (%%limitName%%) hiçbir kaynak yok. İstenen: %%quantity%%; kullanılabilir: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Son kullanım tarihinin %1 değerinden az veya ona eşit olması gerekir.",
    'limitsManager__invalid_disk_space_limit' => "Disk alanı miktarının %1 değerinden az veya ona eşit olması gerekir.",
    'limitsManager__invalid_max_traffic_limit' => "Trafik miktarının %1 değerinden az veya ona eşit olması gerekir.",
    'ippoolManager__ip_has_suballocations' => "Bir kullanıcıya zaten atanmış olan IP adresi tipi değiştirilemiyor.  IP adresi %%ip%% kullanıcılara zaten %%reserved%% IP adresi olarak ayrılmış.",
    'ippoolManager__ip_is_already_in_pool' => "Bu IP adresi zaten kullanıcıya atanmış.",
    'ippoolManager__ip_is_not_in_pool' => "Havuzda IP adresi %%ip%% yok.",
    'ippoolManager__can_not_allocate_ip' => "IP adresi %%ip%% sadece %%available%% olarak kullanılabilir.",
    'ippoolManager__unable_to_set_default_type' => "IP adresi %%ip%% atandı olarak ayrılamaz.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP adresi %%ip%% zaten barındırma için kullanılıyor.",
    'ippoolManager__active_anon_ftp_on_ip' => "IP adresi %%ip%% için anonim FTP erişimi zaten açık",
    'ippoolManager__no_vacant_ips' => "Boş IP adresi yok.",
    'ippoolManager__no_available_ips' => "Kullanılabilir IP adresi yok.",
    'templates__dublicate_name' => "Adı böyle olan bir şablon zaten var. Lütfen bu şablon için başka bir ad seçin.",
    'cl_perm__client_limits_exceeded' => "Belirtilen kaynak sınırı değerleri, barındırma planınızın izin verdiği değerleri aşıyor veya bu değerler, siteleriniz tarafından o sırada kullanılandan daha az kaynak sunuyor.",
    'cl_perm__reseller_limits_exceeded' => "Belirtilen kaynak sınırı değerleri, barındırma planınızın izin verdiği değerleri aşıyor veya bu değerler, kullanıcı hesapları ve siteleri tarafından o sırada kullanılandan daha az kaynak sunuyor.",

    'site_apps__preferences_show_all_versions_title' => "Katalogdan alınan her uygulama için sürümlerin tam listesini gösterin",
    'site_apps__preferences_show_all_versions_hint' => "Bu seçenek seçildiğinde, katalogu açtığınız her defasında her uygulamanın tüm sürümlerini almanız çok zaman alır.  Bu seçenek seçilmediğinde, sadece son sürümleri gösterilir.",
    '__select_user_template' => "Bir şablona dayalı kullanıcı hesabı oluşturun",
    'ip_already_added_to_all_clients' => "Bu IP adresi zaten tüm kullanıcılara atanmış.",

    'site_apps__cancelled_apps' => "Aşağıdaki uygulamaları eklemeyi iptal ettiniz: %2",

    'sb_url_is_not_resolved' => 'URL çözümlenemiyor: DNS ayarlarınızı kontrol edin.  %1 URL\'sinin, sunucunun IP adresini yüklü Presence Builder\'la çözümlemesi gerekir.',

    'ip_addr__is_last_on_interface' => 'IP adresi %%ip%% kaldırılamıyor, çünkü bir ağ arayüzünde bulunan son IP adresi.',
    'ip_addr__used_for_current_session' => 'IP adresi %%ip%% kaldırılamıyor, çünkü etkin bir oturumu tarafından kullanılıyor.',
    'ip_addr__used_for_hosting' => 'IP adresi %%ip%% kaldırılamıyor, çünkü bir web sitesini barındırmak için kullanılıyor.',
    'ip_addr__is_main' => 'IP adresi %%ip%% kaldırılamıyor, çünkü bir ağ arayüzünün birincil IP adresi.',
    'ip_addr__ip_used_by_message_submission' => 'IP adresi %%ip%% kaldırılamıyor, çünkü posta mesajını gönderme için kullanılıyor',

    // RESELLER ACTION LOG

    '__cl_domains' => 'müşterilerinin alan adları',
    'excl_ip_num' => 'Adanmış IP adresi',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder yüklü değil.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Kullanıcı zaten kullanılabildiğinden daha fazla kaynak ayırarak, fazla satış moduna geçtiğinden, fazla satışa izin verme izni, kullanıcı tarafından kaldırılamaz.',
    'limitsManager__invalid_limit_value' => '%%limit_name%% sınırı için yanlış değer %%value%% belirtildi',
    'limit__max_mn' => 'Maksimum posta hesapları sayısı',

    'limits__client_overuse_description' => 'Fazla kullanma ilkesi Plesk\'e, kaynak kullanımı ilk kaynak ayırmayı aştığında ne yapılması gerektiğini söyler.',
    'limits__client_overuse_block_true_description' => 'Kaynakların fazla kullanımını engelle. Geçerli kaynak kullanımı, ilk kaynak ayırmayı aşamaz',
    'limits__client_overuse_block_false_description' => 'Kaynakların fazla kullanılmasını engelleyerek, müşterinin bireysel olarak sağlanandan daha fazla kaynak kullanılmasına izin verir.  Geçerli kaynak kullanımı, ilk kaynak ayırmayı aşabilir',
    'limits__client_overuse_notify_text' => 'Müşteriyi kaynak sınırlarına ulaşma konusunda bilgilendirin',

    'limits__domain_overuse_description' => 'Fazla kullanma ilkesi Plesk\'e, kaynak kullanımı ilk kaynak ayırmayı aştığında ne yapılması gerektiğini söyler.',
    'limits__domain_overuse_block_true_description' => 'Fazla kullanma ilkesi Plesk\'e, kaynaklar fazla kullanıldığında ne yapılması gerektiğini söyler.',
    'limits__domain_overuse_block_false_description' => 'Kaynakların fazla kullanılmasını engelleyerek, alan adının bireysel olarak sağlanandan daha fazla kaynak kullanılmasına izin verir. Geçerli kaynak kullanımı, ilk kaynak ayırmayı aşabilir',
    'limits__domain_overuse_notify_text' => 'Alan adı sahibini kaynak sınırlarına ulaşma konusunda bilgilendirin',

    'dns__dns_rr_delete' => 'Kaldırılacak öğeler',
    'dns__delete_rr' => 'Aşağıdaki DNS kayıtları DNS bölgesinden kaldırılacak:',
    'dns__dns_rr_delete_non_removable' => 'Kaldırılamayan öğeler',
    'dns__non_delete_rr' => 'Aşağıdaki DNS kayıtları kaldırılamaz:',
    'dns__dns_rr_delete_confirm_message' => 'DNS kayıtlarını kaldırmayı onaylayın',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Bilinmeyen web uygulaması biçimi: web uygulaması kurulum ve kullanım için kullanılamayabilir.',

    '__php_handler_type_desc' => 'PHP\'yi farklı çalıştır',
    'sfdk_domain_sign__failed' => 'Alan adında DKIM ile posta imzalama açılmaya çalışılırken, tanımlanamayan hata oluştu. Daha fazla bilgi için sunucunun hata günlüğüne bakın.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Plesk anahtar güncelleme başarısı bildirimi',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk anahtar güncellemesini reddetme bildirimi',
    'pkey_notify__subj_update_error_notification' => 'Plesk anahtar güncelleme hatası bildirimi',
    'pkey_notify__update_successful' => '%1 güncelleme başarıyla tamamlandı.',
    'pkey_notify__update_failed_no_more_try' => '%1 güncellenemiyor. Göndermeye çalıştığınız anahtar geçersiz.  Artık bu anahtarı güncellemeyi denememeniz gerekir.',
    'pkey_notify__update_failed_try_later' => '%1 güncellenemiyor: anahtarınız işlenirken bir hata oluştu. Anahtarı Plesk\'te (Araçlar ve Ayarlar>Lisans Bilgisi) manuel olarak kurtarmayı deneyebilir veya Plesk\'in 24 saat içinde güncellemesi için bekleyebilirsiniz. Bu bildirimi bir daha almak istemiyorsanız, bu anahtarı Plesk\'ten kaldırın.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Alan Adları',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'Postkt',
    'rpt_reseller_dom_redirects' => 'İleticiler',
    'rpt_reseller_dom_mail_groups' => 'MGrup',
    'rpt_reseller_dom_mail_resps' => 'OtCvp',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirüs',
    'rpt_reseller_dom_mail_lists' => 'MList',
    'rpt_reseller_dom_web_users' => 'WUser',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Müşteriler',
    '__cl_name' => 'Müşteri adı',
    '__cl_creation_date' => 'Oluşturulma tarihi',
    '__clients_traffic' => 'Müşteri trafiği',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirüs',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder yüklü değil.',
    'sitebuilder_disabled' => 'Presence Builder kapalı.',
    'b_sitebuilder_disabled' => 'Presence Builder kapalı.',
    'webmail_not_installed' => 'Web postası yazılımı yüklü değil.',
    'webmail_disabled' => 'Web postası servisi kapalı.',
    'spamassassin_not_installed' => 'SpamAssassin yüklü değil.',
    // pfu:
    'anonymous_ftp_shared' => 'Anonim FTP ayarlanamıyor: paylaşılmış IP adres tipi.',
    'anonymous_ftp_used' => 'Anonim FTP ayarlanamıyor: IP adresi, anonim FTP servisi için başka bir alan adı tarafından kullanılıyor.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET yüklü değil.',
    'site_builder_no_package' => 'Presence Builder kullanılamaz.  Lütfen Presence Builder yüklü ve etkin bileşen olarak seçili olup olmadığını kontrol edin.',
    'site_builder_not_configured' => 'Presence Builder yapılandırılmamış.',

    // various

    'disabled_by_admin' => 'Sunucu yöneticisi tarafından devre dışı bırakılmış',

    '__not_allowed' => 'İzin Verilmiyor',

    '__ip_addr_state_unknown' => "Sistem halen talebinizi işlediğinden, IP adresi şu an çalışmıyor. Lütfen bir dakika bekleyin.",

    'ip_addr__repair_is_not_allowed' => 'IP adresi Virtuozzo ortamında onarılamaz.',

    'ippoolManager__ip_used_by_nohost_domain' => "%%ip%% IP adresi kaldırılamadı çünkü barındırma olmadan bir veya daha fazla alan adında kullanılıyor.",
    'ippoolManager__ip_used_for_mail_service' => "%%ip%% IP adresi kaldırılamadı çünkü bir veya daha fazla alan adının posta hizmeti IP adresi olarak kullanılıyor.",
    'ippoolManager__ip_used_for_send_emails' => "%%ip%% IP adresi kaldırılamaz çünkü belirli bir IP'den (Posta Hizmeti Ayarlarına bakın) e-postalar gönderilmek için kullanılıyor.",
    'ippoolManager__ip_used_in_dns_zone' => 'IP adresi %%ip%% kaldırılamaz, çünkü bir veya daha fazla alan adının DNS bölgesi tarafından kullanılıyor.',
    'ip_ctrl__cannot_manage_on_vz' => 'Plesk\'in bu kurulumu, Virtuozzo containers altında çalışır. Yeni IP adresleri sadece Virtuozzo containers düğüm yöneticisi tarafından eklenebilir.',

    'client_template__limits_auto_adjusted' => 'Müşteri şablonunun sınırları otomatik olarak ayarlandı.',

    '__entries' => 'Girdiler',

    '__path_is_not_set' => 'Yol belirtilmemiş.  Lütfen geçerli bir yol belirtin.',

    'defaultcomponents__imap_required' => '(Geçerli posta sunucusu IMAP\'i desteklemiyor)',

    '__commercial_web_stats_not_installed' => 'Plesk sadece alt alan adı istatistikleri hesaplaması için paralı web istatistikleri yazılımını destekler. Şu an sistemde kurulu böyle bir yazılım yok.',


    'server_settings_invalid_traffic_statistics' => 'Geçersiz trafik istatistiklerini koru parametresi.',
    'server_settings_invalid_logrotate_period' => 'Geçersiz günlük döndürme dönemi parametresi.',

    'spam_filter/address/file_size' => 'Dosyalar yüklenemiyor. Karşıya yüklenecek olan bir dosyanın maksimum boyutu %1.',
    'spam_filter/address/file_empty_content' => 'E-posta adresleri dosyadan okunamadı. Bir veya daha fazla e-posta adresi içeren UTF-8 kodlamasında bir dosya yüklediğinizden emin olun ve tekrar deneyin.',
    'spam_filter/address/addresses_empty_content' => 'Listede hiçbir e-posta adresi yok.',
    'spam_filter/address/addresses_available' => 'Sadece ilk %1 benzersiz e-posta adresi eklenecek.',
    'spam_filter/address/invalid_addresses' => 'Aşağıdaki e-posta adresleri geçersiz: %1.',

    'current_resources' => 'Mevcut kaynaklar',
    'plan_limitations' => 'Plan sınırları',
    'cannot_switch_plan' => 'Seçili plana geçilemiyor çünkü şu mevcut kaynaklar plan sınırlarını aşıyor:',
];