<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Acesso negado. Sua conta foi suspensa.",
    'login_up__login_has_been_locked' => "Você tentou efetuar o login utilizando uma senha errada muitas vezes. Por razões de segurança, não será possível efetuar o login com este nome de usuário por algum tempo.",
    'login_up__unable_to_check_pass' => "Não foi possível verificar a senha: %1",
    'login_up__warning_limits_licence_key' => "Um dos itens a seguir excedeu o limite definido por sua chave de licença: número de contas de usuários, domínios, contas de e-mail ou usuários da web hospedados em seu servidor.\nEntre em contato com a central de vendas do Plesk para comprar uma chave que permitirá que você hospede o número desejado de usuários e domínios. Entre em contato com o departamento de suporte técnico do Plesk se perceber que recebeu esta mensagem por engano.\nO limite licenciado para contas de usuários/domínios/contas de e-mail/usuários da web/pacotes de idiomas: %2.\nO número de contas de usuários/domínios/contas de e-mail/usuários da web/pacotes de idiomas: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "A quantidade de recursos que você está operando excedeu os limites definidos por sua licença de produto atual. Entre em contato com a central de vendas do Plesk e compre uma nova chave de licença.",
    'login_up__grace_period' => 'No momento, você está operando dentro do período de carência da licença do produto. Para atualizar a licença do produto, selecione a opção Recuperar Chaves na %1página de Informações da Licença%2.',
    'login_up__partner_license_message' => 'Você está operando atualmente com uma licença de produto limitada que requer registro antes de ativar o conjunto completo de recursos. Para atualizar a licença do produto, selecione a opção Recuperar Chaves na %1página de Informações da Licença%2.',
    'login_up__system_admin_disabled' => 'O superusuário (conta raiz ou do administrador) é proibido para login no Plesk por razões de segurança.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Guia do administrador do Plesk",
    'plesk_guide_reseller' => "Guia do revendedor do Plesk",
    'plesk_guide_client' => "Guia do cliente do Plesk",
    'plesk_guide_domain_admin' => "Guia do administrador de domínio do Plesk",
    'plesk_guide_mailuser' => "Guia do usuário de e-mail do Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Buscar', // multiple usage: TBI
    'nav__general' => 'Menu principal',
    '__home' => 'Página inicial',
    '__applications' => 'Aplicativos',
    '__settings' => 'Configurações',
    'nav__system' => 'Sistema',
    '__master' => 'Mestre',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Nível superior',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Remover',
    'bt_make_default' => 'Tornar padrão',

    // common list object search keys
    'bt_show_all' => "Reinicializar a busca",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Ativo',
    '__object_off' => 'Suspenso',

    '__home_description' => 'Voltar para página inicial.',
    'indicator_title' => '%1% utilizados, %2% livres', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'Uma URL inválida foi solicitada.',

    // business objects
    'mn_list__mail_names_for_client' => 'Contas de e-mail sob a conta de usuário %1',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'Nome',
    'domains_list__state__filter_title' => 'Uso de recursos',
    'domains_list__filter_state_any' => 'Qualquer',
    'domains_list__filter_state_overuse' => 'Abuso na utilização',
    'domains_list__filter_state_normal' => 'Dentro dos limites',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Qualquer',
    'domains_list__filter_status_blocked' => 'Suspenso',
    'domains_list__filter_status_active' => 'Ativo',
    'domains_list__subrows__filter_title' => 'Mostrar',
    'domains_list__subrows_off' => 'Apenas domínios',
    'domains_list__subrows_subdomain_domainaliases' => 'Com subdomínios e nomes alternativos',
    'domains_list__subrows_subdomain' => 'Com subdomínios',
    'domains_list__subrows_domainaliases' => 'Com nomes alternativos',

    // objects list
    'domains_list__owner__title' => 'Proprietário',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Pesquisar aplicativos",
    'site_apps__promo_main_text' => "O catálogo Application Packaging Standard (APS) contém a lista de aplicativos que podem ser provisionados para um domínio ou espaço web. Se você quiser fornecer aplicativos que não se encontram atualmente no catálogo, pode fazer isso facilmente seguindo as instruções para pacotes de APS em www.apsstandard.com",
    'site_apps__promo_download_now' => "Download dos aplicativos:",
    'site_apps__promo_close' => "Fechar este bloco",
    'site_apps__promo_preset__mostused' => '%1 mais popular',
    'site_apps__promo_preset__lessused' => 'Próximo %1 mais popular',
    'site_apps__promo_preset__all' => "Todos",
    'site_apps__promo_disclaimer_note' => 'Observe que os aplicativos instalados a partir do Catálogo APS são fornecidos por terceiros e não são suportados pelo Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Aplicativos de APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Acréscimo de aplicativos...',

    // Errors
    'site_apps__no_applications_for_update' => 'Você não possui nenhuma aplicação instalada no Application Vault.',
    'site_apps__incorrect_download_preset_configuration' => 'Foram encontrados erros na configuração do download preconfigurado do Catálogo do APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'O URL especificado não é válido.',
    'site_apps__no_updates_at_the_moment' => 'Não há nenhuma atualização de aplicativo disponível no momento.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Informações incorretas foram recebidas do catálogo de aplicativos do APS. Tente novamente mais tarde.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'As configurações de catálogo do APS foram salvas, mas o Plesk não pôde estabelecer uma conexão com o catálogo do APS especificado nas configurações do catálogo do APS (%1). Certifique-se de que o endereço do catálogo APS esteja correto e o catálogo APS nesse endereço esteja ativo.',
    'site_apps__cannot_retrieve_updates' => 'Não é possível efetuar o download das atualizações de aplicativos no momento: não é possível estabelecer uma conexão com o catálogo APS (%1). Certifique-se de que o endereço do catálogo APS esteja correto e o catálogo APS nesse endereço esteja ativo.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Não há nenhum aplicativo da web disponível para instalação.',
    'site_apps__site_applications_already_installed_in_root' => 'Outros aplicativos da web já estão instalados nos diretórios-raiz desses hosts virtuais',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Os aplicativos da web .NET não são suportados na plataforma Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Os aplicativos da web em todo o servidor não são suportados',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 mais aplicativos da web são agendados para acréscimo ao Application Vault.",
    'site_apps__applications_all_in_vault' => "Aplicativos da web selecionados já estão presentes no Application Vault.",
    'site_apps__applications_already_in_download_queue' => "%1 aplicativos da web selecionados estão sendo acrescentados ao Application Vault no momento.",
    'site_apps__applications_already_in_valut' => "%1 aplicativos da web selecionados já estão no Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Outros (não categorizados)',

    // Errors
    'site_apps__no_applications_in_category' => 'Nenhum aplicativo disponível nessa categoria. Selecione outra categoria.',
    'site_apps__no_category_selected__please_specify' => 'Selecione uma categoria no menu à esquerda. Todos os aplicativos disponíveis na categoria selecionada serão relacionados nesta janela.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Conta do administrador',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Geral',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Altere o nome do host',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Segurança',
    'bt_setup_firewall' => 'Configurar o firewall',
    'bt_manage_firewall_rules' => 'Gerencie as regras do firewall',
    'cu_firewall__rule' => 'Criar uma regra de firewall',
    'cu_firewall__protocol' => 'Configurar um protocolo para a regra (\'tcp\' ou \'udp\')',
    'cu_firewall__name' => "Configurar um nome de regra",
    'cu_firewall__disabled' => 'Se for \'verdadeiro (true)\', a regra é desabilitada após a criação',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Selecionar o servidor de DNS', // PFW
    'bt_soa_records_template' => 'Modelo de registro SOA',
    'bt_restrict_creation_of_subzones' => 'Restringir criação de subzonas',

    'databases' => 'Bancos de dados',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplicativos',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-mail',
    'bt_select_mailserver' => 'Selecionar o servidor de e-mail', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Selecionar o antivírus', // PFW
    'bt_virus_protection_settings' => 'Configurações de proteção contra vírus',
    'bt_select_spamfilter' => 'Selecionar o filtro de spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Selecionar o Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logs e estatísticas',
    'bt_server_statistics_settings' => 'Configurações de estatísticas do servidor',
    'bt_select_web_statistics' => 'Software de estatísticas da web disponível', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interface Plesk',

    'components_and_modules' => 'Componentes e módulos',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'Configurar o VPN', // PFU
    'bt_setup_samba' => 'Configurar o Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'Conta do administrador de domínio',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Configurações da conta',

    'domain' => 'Domínio',
    'bt_dns_soa_records' => 'Registros SOA do DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Configurações do programador de tarefas',

    'website' => 'Site',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripts para usuários da web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Selecionar o certificado SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Estatísticas da web',
    'bt_log_rotation_settings' => 'Configurações de rotação de log',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limites", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Política de abuso na utilização e excesso de vendas",
    'limits__overuse_policy_legend' => "Abuso na utilização",
    'limits__oversell_policy_legend' => "Excesso de vendas",
    'limits__reseller_overuse_description' => "A política de uso informa ao Plesk o que fazer quando os recursos são usados em excesso.",
    'limits__overuse_text' => "Política de abuso na utilização",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Espaço de disco e tráfego',
    'limit__disk_space' => 'Espaço em disco',
    'limit__max_traffic' => 'Tráfego',
    'limit_group__client' => 'Clientes',
    'limit__max_cl' => 'Clientes',
    'limit_group__domain' => 'Domínios',
    'limit__max_dom' => 'Domínios',
    'limit__max_dom_powerUser' => 'Assinaturas',
    'limit__max_subdom' => 'Subdomínios',
    'limit__max_dom_aliases' => 'Nomes alternativos de domínio',
    'limit__max_wu' => 'Usuários da web',
    'limit__max_subftp_users' => 'Contas de FTP adicionais', // PFW
    'limit_group__mail' => 'E-mail',
    'limit__max_box' => 'Caixas de e-mail',
    'limit__mbox_quota' => 'Tamanho da caixa postal',
    'limit__total_mboxes_quota' => 'Cota total de caixas postais', // PFW
    'limit__max_maillists' => 'Mala direta',
    'limit_group__database' => 'Bancos de dados',
    'limit__max_mssql_db' => 'Bancos de dados do Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Cota total das bases de dados MS SQL', // PFW
    'limit__max_odbc' => 'Conexões ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Cota total das bases dados MariaDB/MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Cota de bancos de dados PostgreSQL', // PFW
    'limit_group__application' => 'Aplicativos',
    'limit__max_iis_app_pools' => 'Conjuntos de aplicativos IIS', // PFW
    'limit_group__security' => 'Segurança',
    'limit_group__validity' => 'Data de expiração',
    'limit__expiration' => 'Data de expiração',
    'limit__validity' => 'Período de validade',
    'limit__max_site_builder' => 'Sites publicados com o Presence Builder',
    'limit__max_site' => 'Domínios',
    'limit__mssql_dbase_filesize' => 'Tamanho do arquivo de banco de dados do MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Tamanho do arquivo de log de banco de dados do MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'O tamanho máximo de um arquivo de banco de dados do Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'O tamanho máximo de um arquivo de log de banco de dados do Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Limite de domínios inválidos. O valor mínimo é 1.',

    'property__has_wrong_value' => 'A propriedade %1 possui um valor errado.',
    'property__name_outgoing_messages_domain_limit' => 'Configurar o limite padrão para as mensagens de saída de um domínio (por hora). Especificar "-1", para definir o valor como ilimitado. Especificar "padrão" para definir o valor especificado nas configurações de todo o servidor.',
    'property__name_outgoing_messages_mbox_limit' => 'Configurar o limite padrão para as mensagens de saída de uma caixa de e-mail (por hora). Especificar "-1", para definir o valor como ilimitado. Especificar "padrão" para definir o valor especificado nas configurações de todo o servidor.',
    'property__name_outgoing_messages_subscription_limit' => 'Configurar o limite padrão para as mensagens de saída de uma assinatura (por hora). Especificar "-1", para definir o valor como ilimitado. Especificar "padrão" para definir o valor especificado nas configurações de todo o servidor.',

    // for CLI report & email notifications
    '__resource_notify' => 'Notificar',
    '__general' => 'Geral',
    '__template_shared' => 'Modelo compartilhado',
    'limit__overuse' => 'Política de abuso na utilização',
    'limit__max_traffic_soft' => 'Comunicar quando o uso de tráfego for alcançando',
    'limit__disk_space_soft' => 'Comunique quando o uso do espaço de disco for alcançando',
    '__overuse' => 'Política de abuso na utilização',
    'performance__title' => 'Desempenho',
    'performance__bandwidth' => 'Uso da largura de banda máximo (KB/s)',
    'performance__max_connections' => 'Conexões limitadas a',

    'gch__hosting_php_isapi' => 'Executar o PHP como extensão ISAPI',
    'gch__hosting_ssi_html' => 'Utilizar o SSI para arquivos *.htm, *.html',
    'gch__hosting_php_handler_type' => 'executar o PHP como',
    'gch__hosting_php_handler_id' => 'executar o PHP como',
    'gch__hosting_php_served_by_nginx' => 'PHP servido por nginx',
    'gch__hosting_unpaid_website_status' => 'Status dos sites em assinaturas suspensas',
    'gch__mn_no_autoresponder' => 'Não há nenhuma resposta automática configurada para sua conta de e-mail.',
    'gch__no_clients_selected' => "Nenhuma conta de cliente selecionada",
    'gch__no_domains_selected' => "Nenhum domínio selecionado",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/mês",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nome do recurso',
    '__resource_usage' => 'Utilizado',
    '__resource_limit' => 'Limite',

    '__never_expires' => 'Nunca expira',
    '__resource_free' => '%1 livre de %2',
    '__resource_unlimited' => '%1 utilizada de Ilimitado',

    '__unlimited' => 'Ilimitado',
    '__increment' => "Aumentar (+)",
    '__decrement' => "Diminua (-)",
    '__pt' => 'unidades',
    '__procent' => '%',
    '__overused' => 'Abuso na utilização',
    '__left' => 'à esquerda',
    '__available' => 'disponível',
    '__not_available' => 'Não incluído',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nome do revendedor', // reseller report
    'report__full_client_name' => 'Nome do cliente', // customer report
    'report__full_domain_name' => 'Nome do domínio', // domain report
    'report__full_owner' => 'Proprietário', // customer & domain reports
    'report__full_creation_date' => 'Data de criação',
    'report__full_size' => 'Tamanho',
    'report__full_traffic' => 'Tráfico',
    'report__full_active_clients' => 'Clientes ativos', // reseller report
    'report__full_clients' => 'Clientes', // reseller report
    'report__full_active_domains' => 'Domínios ativos', // reseller & customer reports
    'report__full_domains' => 'Domínios', // reseller & customer reports
    'report__full_subdomains' => 'Subdomínio',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'Espaço em disco',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Mala direta',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MariaDB/MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'Banco de Dados PostgreSQL',

    // common summary report
    'report__section_general' => 'Geral',
    'report__version' => 'Versão do produto',
    'report__build' => 'Compilação do produto',
    'report__status' => 'Status',
    'report__company_name' => 'Nome da empresa',
    'report__personal_name' => 'Nome pessoal',
    'report__login' => 'Nome do usuário',
    'report__phone' => 'Telefone',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Endereço',
    'report__city' => 'Cidade',
    'report__state' => 'Estado/província',
    'report__zip_code' => 'Código postal/CEP',
    'report__country' => 'País',
    'report__creation_date' => 'Data de criação',
    'report__expiration_date' => 'Data de expiração',
    'report__dumps_total_size' => 'Tamanho total dos arquivos de backup',
    'report__section_resellers' => 'Revendedores',
    'report__active_resellers' => 'Revendedores com assinaturas ativas',
    'report__resellers' => 'Revendedores',
    'report__section_full_resellers' => 'Revendedores',
    'report__section_clients' => 'Clientes',
    'report__active_clients' => 'Clientes com assinaturas ativas',
    'report__clients' => 'Clientes',
    'report__section_full_clients' => 'Clientes',
    'report__section_personal_clients' => 'Clientes próprios',
    'report__active_personal_clients' => 'Seus próprios clientes com assinaturas ativas',
    'report__personal_clients' => 'Clientes próprios',
    'report__section_full_personal_clients' => 'Clientes próprios',
    'report__section_domains' => 'Domínios',
    'report__disk_usage' => 'Uso do disco',
    'report__traffic' => 'Tráfico',
    'report__active_domains' => 'Domínios ativos',
    'report__domains' => 'Domínios',
    'report__subdomains' => 'Subdomínios',
    'report__mboxes' => 'Caixas de e-mail',
    'report__mail_groups' => 'Encaminhamentos de e-mail',
    'report__mail_autoresp' => 'Respostas automáticas',
    'report__mail_lists' => 'Mala direta',
    'report__web_users' => 'Usuários da web',
    'report__mysql_databases' => 'Bancos de dados MariaDB/MySQL',
    'report__mssql_databases' => 'Bancos de dados do MSSQL',
    'report__pgsql_databases' => 'Bases de dados PostgreSQL',
    'report__section_full_domains' => 'Domínios',
    'report__section_personal_domains' => 'Domínios pessoais',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domínios pessoais',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Sites publicados com o Presence Builder',
    'report__invalid_email' => 'Especifique um endereço de e-mail válido.',


    // CLI-specific sections
    'report__section_hosting' => 'Hospedagem',
    'report__section_webusers' => 'Usuários da web',
    'report__section_mailnames' => 'Contas de e-mail',
    'report__section_maillists' => 'Mala direta',
    'report__section_databases' => 'Bancos de dados',
    'report__section_siteapps' => 'Aplicativos da web',
    'report__section_aspnetapps' => 'Aplicativos do ASP.NET', // PFW
    'report__owner_pname' => "Nome pessoal do provedor",
    'report__owner_login' => "Nome de usuário do provedor",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'O pacote de idioma especificado está instalado, mas não está habilitado no sistema.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'O token da sessão expirou.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'As contas de revendedores a seguir serão convertidas para contas de clientes',
    'downgradeResellers__downgrade' => 'Contas de revendedores que serão convertidas',
    // controls
    'downgradeResellers__submit_downgrade' => 'Realizar a conversão da conta.',
    'downgradeResellers__cancel_downgrade' => 'Cancelar a conversão da conta.',
    'downgradeResellers__confirm' => 'Confirmar a conversão',
    'downgradeResellers__confirm_message' => 'Confirmar a conversão da conta para prosseguir',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'As contas de clientes a seguir serão convertidas para contas de revendedores',
    'upgradeClients__upgrade' => 'Contas de clientes que serão convertidas',
    // controls
    'upgradeClients__submit_upgrade' => 'Realizar a conversão da conta.',
    'upgradeClients__cancel_upgrade' => 'Cancelar a conversão da conta.',
    'upgradeClients__confirm' => 'Confirmar a conversão',
    'upgradeClients__confirm_message' => 'Confirmar a conversão da conta para prosseguir',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Não é possível converter a conta \'%1\' para uma conta de revendedor. \'%1\' já é um revendedor.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'As contas de administrador do domínio a seguir serão convertidas em contas de clientes:',
    'upgradeDomainUser__upgrade' => 'Contas de administrador do domínio que serão convertidas',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Realizar a conversão da conta.',
    'upgradeDomainUser__cancel_upgrade' => 'Cancelar a conversão da conta.',
    'upgradeDomainUser__confirm' => 'Confirmar a conversão',
    'upgradeDomainUser__confirm_message' => 'Confirmar a conversão da conta para prosseguir',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Contas de administrador do domínio que não podem ser convertidas',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'As contas de administrador do domínio a seguir não puderam ser convertidas em contas de clientes:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Várias contas de administrador do domínio não puderam ser convertidas em contas de clientes. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'A conta de administrador do domínio não existe',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "O domínio deve pertencer diretamente ao administrador do servidor ou a um revendedor.",
    'upgradeDomainUser__all_logins_already_used' => 'Impossível criar uma conta para o cliente resultante.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'A conta de administrador de domínio foi convertida',
    'upgradeDomainUser__upgrade_notification_body' => 'Sua conta de administrador do domínio foi convertida em uma conta de cliente com nome de usuário \'%%login%%\' e senha \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'O revendedor selecionado não tem a permissão \'%1\', porém alguns clientes possuem essa permissão.',
    'clientOwnerChanger__application_not_allowed' => 'O aplicativo \'%1\' não está disponível para o revendedor selecionado, mas está disponível para alguns clientes.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Uso máximo da largura de banda (%1)',
    'hosting_performance__max_connection_label' => 'Conexões limitadas a',
    'performance__invalid_value' => "O valor é inválido. Ele deve se estar na faixa de %1 a %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'WebMail',
    'webmail__server_text' => 'Clientes de webmail disponíveis',
    'webmail__none' => 'Nenhum',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Pool de IP do servidor',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Backup do servidor.",
    '__default_backup_comment_reseller' => "Backup da conta do revendedor criada por %1.",
    '__default_backup_comment_client' => "Backup da conta do cliente criada por %1.",
    '__default_backup_comment_domain' => "Backup da conta da assinatura criada por %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Pool de IP do cliente %1",
    'backup__ip_mapping__resellers_ip' => "Pool de IP do revendedor %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Host virtual',
    'backup__restore__object_plesk_admin' => 'Administrador Plesk',
    'backup__restore__object_ftpuser' => 'Conta FTP',
    'backup__restore__object_frontpageuser' => 'Conta Frontpage',
    'backup__restore__object_webuser' => 'usuário web',
    'backup__restore__object_domain' => 'domínio',
    'backup__restore__object_subdomain' => 'subdomínio',
    'backup__restore__object_domainalias' => 'nome alternativo do domínio',
    'backup__restore__object_client' => 'cliente',
    'backup__restore__object_reseller' => 'revendedor',
    'backup__restore__object_autoresponder' => 'resposta automática',
    'backup__restore__object_mailalias' => 'nome alternativo de e-mail',
    'backup__restore__object_database' => 'banco de dados',
    'backup__restore__object_mailname' => 'conta de e-mail',
    'backup__restore__object_db_user' => 'usuário do banco de dados',
    'backup__restore__object_ssl_certificate' => 'Certificado SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Os seguintes revendedores não podem ser restaurados, pois eles foram convertidos para clientes: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Os seguintes clientes não podem ser restaurados, pois eles foram convertidos para revendedores: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Os seguintes clientes não podem ser restaurados, pois eles foram movidos para outro proprietário: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Espaço em disco insuficiente no servidor de destino para migrar todas as assinaturas selecionadas. Disponível: %1 MB. Obrigatório: %2 MB. Observação: O espaço necessário é calculado como a soma dos conteúdos da web, e-mail e banco de dados dos domínios. Este cálculo é realizado uma vez por dia e armazenado em cache, portanto o tamanho real dos domínios pode ser diferente do tamanho calculado. Se tiver certeza de que os domínios selecionados não ocupam mais espaço do que o disponível, você pode prosseguir com a migração.',
    'backup__restore__capability_not_enough_disk_windows_text' => 'Espaço em disco insuficiente no disco \'%1\' no servidor de destino para migrar todas as assinaturas selecionadas. Disponível: %2 MB. Obrigatório: %3 MB. Observação: O espaço necessário é calculado como a soma dos conteúdos da web, e-mail e banco de dados dos domínios. Este cálculo é realizado uma vez por dia e armazenado em cache, portanto o tamanho real dos domínios pode ser diferente do tamanho calculado. Se tiver certeza de que os domínios selecionados não ocupam mais espaço do que o disponível, você pode prosseguir com a migração.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Para prosseguir com a migração, libere espaço em disco no servidor de destino.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Espaço em disco insuficiente no servidor de origem para armazenar arquivos temporários para a transferência. Disponível: %1 MB. Necessário: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Libere espaço em disco no servidor de origem.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informações do servidor',

    'backup__restore__capability_not_installed_component_text' => 'O componente %1 não está instalado no servidor de destino. %1 estará indisponível para todos os objetos restaurados.',
    'backup__restore__capability_not_installed_component_resolution' => 'Instale %1. Note que isso pode levar alguns minutos.',
    'backup__restore__capability_existing_sys_user_text' => 'Já existe um usuário do sistema com o nome %1 no servidor de destino.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Renomeie o usuário do sistema existente no servidor de destino.',
    'backup__restore__capability_license_usage_text' => 'Os limites de recurso a seguir (definidos pela chave de licença) serão excedidos no servidor de destino após a transferência de dados:',
    'backup__restore__capability_license_usage_resolution' => 'Instale no servidor de destino outra chave de licença que fornecerá a quantidade de recursos necessária.',
    'backup__restore__capability_max_allowed_packet_text' => "O parâmetro 'max_allowed_packet' no servidor do banco de dados de origem é %1, maior que no servidor de destino, no qual é %2. Alguns objetos do banco de dados para os domínios especificados abaixo podem não ser restaurados.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Aumente o valor 'max_allowed_packet' no servidor do banco de dados de destino.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Não foi possível transferir os bancos de dados PostgreSQL, pois a versão do PostgreSQL no servidor de destino é anterior ao do servidor de origem. A versão atual é %1; a versão necessária é %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Instale a versão necessária de PostgreSQL no servidor de destino.',
    'backup__restore__capability_db_server_connection_problems' => 'Não foi possível conectar com o servidor de banco de dados PostgreSQL de destino. O banco de dados não será transferido a menos que você restaure a conexão.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Verifique as configurações de conexão no servidor de base de dados de destino.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'O componente %1 está desativado no servidor de destino.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Ative %1 no servidor de destino.',
    'backup__restore__capability_not_configured_component_text' => 'O componente %1 não está configurado no servidor de destino.',
    'backup__restore__capability_not_configured_component_resolution' => 'Configure %1 na página Ferramentas e Configurações.',

    'backup__restore__capability_webmail_is_not_available' => 'O serviço de webmail %1 não está disponível no servidor de destino. Em vez disso, o Plesk utilizará o seguinte serviço de webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Para usar o mesmo webmail do servidor de origem, você deve instalá-lo no servidor.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Para usar o mesmo webmail do servidor de origem, você deve instalá-lo no servidor de destino.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "O webmail '%1' não está disponível no servidor de destino. Em vez disso, as seguintes descrições: %3, o Plesk utilizará o seguinte serviço de webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Instale o webmail necessário no servidor de destino.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Configurações de Webmail',

    'backup__restore__capability_shell_is_not_available' => 'O selo %1 não está disponível no servidor de destino. Um dos selos disponíveis será usado no lugar.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Para usar o mesmo selo do servidor de origem, você deve ativar (in /etc/Selles) ou instalá-lo no servidor de destino.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'O servidor DNS de destino não suporta redes no Modelo de Restrições de Transferência. Os registros com os endereços IP da rede nas restrições de transferência DNS não serão restaurados.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'O servidor DNS de destino não suporta redes no Modelo de Restrições de Transferência, mas algumas assinaturas possuem redes nas restrições de transferência de DNS. Os registros com os endereços IP da rede nas restrições de transferência DNS não serão restaurados.',

    'backup__restore__capability_wrong_php_handler_text' => 'O PHP handler %1 não está disponível no servidor de destino. Em vez disso, o Plesk utilizará o seguinte PHP handler: %2.',
    'backup__restore__capability_no_php_handler_text' => 'O manipulador PHP %1 não está disponível no servidor de destino.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Para usar o mesmo PHP handler do servidor de origem, você deve ativá-lo ou instalá-lo no servidor de destino.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'O PHP handler "%1" não está disponivel. Ao invés disso, o Plesk utilizará %2 para os planos de serviço a seguir: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'O PHP handler "%1" não está disponivel. Ao invés disso, o Plesk utilizará %2 para os sites a seguir: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'O manipulador de PHP %1 não está disponível. Não estará disponível para os seguintes sites: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'O %1 %2 não está disponível no servidor de destino. A versão padrão será usada no lugar.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Para usar o mesmo %1 do servidor de origem, você deve ativá-lo ou instalá-lo no servidor de destino.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'A política de uso de antivírus no servidor de destino não permite configurações pessoais de antivírus (por endereço de e-mail) para a caixa de saída. Essas configurações não serão transferidas.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'A política de uso de antivírus no servidor de destino não permite configurações pessoais de antivírus (por endereço de e-mail) para a caixa de entrada. Essas configurações não serão transferidas.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'A política de uso de antivírus no servidor de destino não permite configurações pessoais de antivírus (por endereço de e-mail). Essas configurações não serão transferidas.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Para transferir configurações de antivírus pessoais (por endereço de e-mail), ative as opções correspondentes em Ferramentas e Configurações > Configurações de Proteção de Vírus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Nenhum software de antivírus está ativo. Todas as configurações de antivírus a partir do servidor de origem não funcionarão até que você selecione o software de antivírus no servidor de destino.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Selecione o software de antivírus na seção de configuração Ferramentas e Configurações > Configurações de Proteção de Vírus > Antivírus.',

    'backup__restore__capability_antivirus_another_active_text' => 'O software de antivírus %2 não está disponível no servidor de destino. %1 será usado no lugar.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Para usar o mesmo antivírus como no servidor de origem, instale-o e selecione-o na seção de configuração Ferramentas e Configurações > Configurações de Proteção de Vírus > Antivírus.',
    'backup__restore__capability_not_available_sni_text' => 'O SNI não está disponível no servidor de destino. Os websites que possuem o mesmo endereço de IP serão incapazes de usar certificados SSL/TLS individuais.',
    'backup__restore__capability_not_available_sni_resolution' => "Verifique se o sistema operacional no servidor de destino suporta SNI e se ele está ativo no Plesk (a caixa de seleção 'Ativar suporte SNI, que permite usar certificados SSL/TLS individuais em websites com o mesmo endereço de IP' em Ferramentas & Configurações> Configurações do servidor).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Configurações do servidor',

    'backup__restore__capability_vhost_already_exists_text' => 'O website %1 não pode ser transferido: um website com o mesmo nome já existe no servidor de destino.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Renomeie ou remova o website com o mesmo nome do servidor.',
    'backup__restore__capability_removed_vhosts' => 'As assinaturas a seguir não serão restauradas pois elas contêm os nomes de domínio que já existem no servidor de destino: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'No servidor de origem, exitem diferentes PHP handlers %3 do tipo %1 e versão %2. Em vez deles, um manejador do tipo e versão apropriados será utilizado no servidor de destino. Note que as configurações PHP no servidor de origem e destino podem ser diferentes.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'O Plesk Installer não suporta o Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'O Plesk Installer não suporta o Python. Instale o Python manualmente.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Configurações do servidor de e-mail',

    'backup__restore__capability_ftps_disabled' => 'Usar o FTPS seguro é permitido no servidor de origem, mas proibido no de destino. Aplicativos do usuário que usam FTP podem não funcionar corretamente.',
    'backup__restore__capability_ftps_required' => 'Usar o FTP não seguro é permitido no servidor de origem, mas proibido no de destino. Aplicativos do usuário que usam FTP podem não funcionar corretamente.',
    'backup__restore__capability_ftps_policy_resolution' => 'Alterar a política de segurança do FTP em Ferramentas e Configurações> Política de Segurança.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabytes de dados serão transferidos do servidor de origem para o destino em %2 horas.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Para uma transferência mais rápida, por favor, verifique sua conexão de rede entre os servidores de origem e de destino e solucione os problemas (se houver).',
    'backup__restore__too_low_download_speed' => "menos que 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Para uma transferência mais rápida, por favor, verifique sua conexão de rede entre os servidores de origem e de destino e solucione os problemas (se houver).',
    'backup__restore__capability_zero_download_speed_text' => 'A velocidade mínima de download aceitável é %1 MBps. A velocidade de download entre o servidor de origem e de destino é 0 MBps. Isto pode ser causado por problemas na conexão de rede. Não é possível fazer a transferência.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Verifique sua conexão de rede entre os servidores de origem e de destino e solucione os problemas (se houver).',
    'backup__restore__capability_too_slow_download_speed_text' => 'A velocidade mínima de download aceitável é %2 MBps. A velocidade de download entre o servidor de origem e de destino é %1 MBps. Isto pode aumentar o tempo de transferência. Em seu ambiente atual, a migração de %3 MB levará %4 horas.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'A velocidade mínima de download aceitável é %2 MBps. A velocidade de download entre o servidor de origem e de destino é %1 MBps. Isto pode aumentar o tempo de transferência.',

    'backup__restore__capability_remote_database_migration' => "Os seguintes domínios estão utilizando bancos de dados remotos: %1 ",
    'backup__restore__capability_remote_database_migration_resolution' => "Não remova estes domínios do servidor de origem após a transferência se a versão do Plesk da fonte de origem for anterior a versão 11.5! Suspenda-os em vez disso. Se você remover estes domínios, os bancos de dados serão removidos do servidor remoto. Observação: Os arquivos de despejo dos bancos de dados remotos serão armazenados no servidor de destino e também no servidor de origem no diretório %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Arquivos de backup dos servidores do banco de dados MySQL anteriores ao 5.1 (%1) podem não ser restaurados no MySQL 5.1.x, pois o MySQL 5.1.x lida com caracteres Unicode de forma diferente.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Por favor, leia o artigo da base de conhecimento relacionada #136850.',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP não está instalado no servidor de destino.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Por favor, instale o Courier-IMAP usando o Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'O Dovecot não está instalado no servidor de destino.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Por favor, instale o Dovecot usando o Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'O tempo de retenção dos dados estatísticos de tráfego nas configurações dos seguintes objetos é inferior ao valor de todo o servidor no servidor de destino.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Por favor, altere o valor de todo o servidor para o tempo de retenção dos dados estatísticos no servidor de destino. Defina-o igual ou inferior ao menor valor nos domínios configurações.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'O tempo de retenção dos dados estatísticos de tráfego em alguns domínios é inferior ao valor de todo o servidor (%1). O valor será alterado para %1 para esses domínios.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'O tempo para manter as estatísticas de tráfego em alguns planos de serviço é inferior ao valor de todo o servidor (%1). O valor será alterado para %1 para esses planos de serviço.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Mapear um endereço de IP exclusivo a um compartilhado irá desabilitar o FTP e o HTTPS anônimos (a menos que o suporte SNI esteja ligado).',

    'backup__restore__no_postgresql_commands_text' => 'A assinatura utiliza um banco de dados PostgreSQL remoto e o arquivo temporário de backup do mesmo não pôde ser gerado, pois o pg_dump e os comandos psql estão faltando no servidor de origem.',
    'backup__restore__no_postgresql_commands_resolution' => 'Por favor, instale qualquer pacote de cliente do PostgreSQL e que ofereça suporte a esses comandos.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Os módulos Apache a seguir estão desabilitados no servidor de destino: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Habilite esses módulos para evitar possíveis problemas.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Os módulos Apache a seguir não estão instalados no servidor de destino: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Instale e habilite esses módulos para evitar possíveis problemas.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Limitação das mensagens de saída não é suportada por sua licença. As definições de configuração correspondentes não serão transferidas.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Instale no servidor de destino outra chave de licença que forneça os recursos necessários.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Limitação de mensagens de saída está desativada no servidor de destino. As definições de configuração correspondentes não serão transferidas.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Por favor, ative a limitação das mensagens de saída no servidor de destino.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Configurações de e-mail de todo o servidor',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'A limitação das mensagens enviadas de uma caixa de e-mail não é suportada pelo servidor de e-mail que é utilizado no servidor de destino. O valor deste limite não será transferido.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Por favor, altere o servidor de e-mail para o mesmo que você utiliza no servidor de origem.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Configurações de e-mail de todo o servidor',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'A limitação das mensagens enviadas de um domínio não é suportada pelo servidor de e-mail utilizado no servidor de destino. O valor deste limite não será transferido.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Por favor, altere o servidor de e-mail para o mesmo que você utiliza no servidor de origem.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Configurações de e-mail de todo o servidor',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'A limitação das mensagens enviadas de uma assinatura não é suportada pelo servidor de e-mail utilizado no servidor de destino. O valor deste limite não será transferido.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Por favor, altere o servidor de e-mail para o mesmo que você utiliza no servidor de origem.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Configurações de e-mail de todo o servidor',

    'bu_conflict_resolver_absent_phosting' => 'Não é possível restaurar os arquivos especificados, pois não existe a hospedagem física para restaurá-los. Por favor, crie um domínio com uma hospedagem física primeiro e depois inicie a restauração do backup novamente.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Os dados dos revendedores não serão restaurados porque o gerenciamento de revendedores não é suportado.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'O componente ModSecurity não está instalado no servidor de destino.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Por favor, instale o ModSecurity se você quiser manter o firewall do aplicativo web funcionando para os sites transferidos. Note que a instalação pode levar alguns minutos.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Instalar o ModSecurity se quiser transferir as configurações do firewall do aplicativo web. Note que a instalação pode levar alguns minutos.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'O componente ModSecurity não está configurado no servidor de destino.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configurar o ModSecurity se você quiser manter o firewall do aplicativo web funcionando para os sites transferidos.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall de aplicativo web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'O ModSecurity está desativado no servidor de destino.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Ativar ModSecurity se você quiser manter o firewall do aplicativo web funcionando para os sites transferidos.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall de aplicativo web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'O componente ModSecurity não é instalado. As configurações do firewall de aplicativo web não serão restaurados para os seguintes objetos: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Websites não podem ser restaurados, pois pertencem à assinatura %1 e que não se encontra no Plesk.",
    'bu_conflict_resolver_attend_websites_subscription' => "Alguns websites não podem ser restaurados porque há assinaturas com os mesmos nomes: %1.",
    'backup__restore__capability_not_installed_dns_text' => 'O componente %1 não está instalado no servidor de destino. O serviço DNS não está disponível e as configurações serão perdidas. Todos os sites dos clientes ficarão inoperantes.',
    'bu_conflict_resolver_dns_not_installed' => 'O serviço de DNS não está instalado. As configurações de DNS não serão restaurados para os seguintes objetos: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'As seguintes assinaturas não podem ser restauradas, pois elas foram movidas para outro proprietário: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'As seguintes assinaturas não podem ser restauradas, pois elas foram movidas para outro provedor: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Impossível encontrar a utilidade da restauração do Web Presence Builder para restaurar os dados do Web Presence Builder. O Web Presence Builder provavelmente não está instalado.',
    'backup__restore__capability_renamed_db' => 'O nome do banco de dados "%1" já é usado por outra assinatura. O nome do banco de dados restaurada será alterado para "%2".',
    'backup__restore__capability_renamed_db_user' => 'O nome do usuário do banco de dados "%1" já é usado por outra assinatura. O nome do banco de dados restaurada será alterado para "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'O Plesk Installer não suporta o Perl. Instale o ActiveState Perl manualmente.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% servido por Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% servido por ngnix (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Antivírus Kaspersky',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflitos de uso do recurso',
    'backup__restore__hint_resource_usage_conflicts' => 'Conflitos no uso de recursos ocorrem quando os limites de uso de recursos do objeto restaurado são excedidos durante a restauração.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Permita o abuso na utilização',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Restaure o objeto e permita que ele utilize mais recursos do que inicialmente fornecido.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Não restaure',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Não restaure objetos que apresentam conflitos de uso.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflitos de configuração',
    'backup__restore__hint_configuration_conflicts' => 'Conflitos de configuração ocorrem quando o objeto restaurado tem configurações e aplicativos da web que não estão disponíveis ou são proibidos pela política de proprietário do objeto ou servidor atual. Por exemplo, conflitos de configuração ocorrerão se as contas de e-mail restauradas apresentarem configurações de filtragem de spam individuais enquanto a política no âmbito do servidor proíbe que as contas de e-mail tenham essas configurações.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automático',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Restaure o objeto e ative automaticamente todas as opções de configuração conflitantes que suas permissões permitirem gerenciar.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Não restaure',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Não restaure objetos que apresentarem conflitos de configuração.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Os pools de aplicativos IIS dedicados não são permitidos nas configurações do pool do aplicativo IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Altere suas configurações do pool do aplicativo IIS em Tools & Settings > IIS Application Pool > Global Settings.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Os pools de aplicativos IIS compartilhados não são permitidos nas configurações do pool do aplicativo IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Altere suas configurações do pool do aplicativo IIS em Tools & Settings > IIS Application Pool > Global Settings.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Nomes curtos da conta de e-mail POP3/IMAP não são permitidos no servidor de destino.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Nomes curtos para contas de e-mail ficaram indisponíveis após restauração dos dados.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Não é possível abrir o arquivo de log.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Não foi possível restaurar a assinatura %1: ela foi removida de sua conta e você não possui permissão para criar assinaturas. Se precisar restaurá-la, entre em contato com o seu provedor de serviços.',

    'backup__error11' => 'Espaço em disco insuficiente para backup.',
    'backup__error3011' => 'A conexão foi recusada: Nenhum programa está respondendo no endereço e porta especificado.',
    'backup__error3012' => 'Tempo limite de conexão.',
    'backup__error3013' => 'A rede está inacessível.',
    'backup__error3014' => 'Sem rota para o host.',
    'backup__error3015' => 'A conexão falhou.',
    'backup__error3016' => 'Não é possível resolver o nome de host.',
    'backup__error3017' => 'Nome do usuário ou senha incorretos.',
    'backup__error3018' => 'Falha de conexão ao SSH.',

    'backup__error3110' => 'Não é possível conectar com o agente de migração remota: Conexão com o host não está disponível.',
    'backup__error3111' => 'O agente de migração é bloqueado por uma tarefa de migração com problemas ou é utilizado por outro processo de migração. Por favor, reinicie o agente de migração no servidor de origem.',
    'backup__error3112' => 'A conexão com o host não está disponível ou o agente de migração não está executando no host de origem.',
    'backup__error3113' => 'Não é possível implementar o agente de migração para um host Linux. Verifique a conexão SSH para o host de origem.',
    'backup__error3114' => 'Não é possível implementar o agente de migração para um host Linux: Falha de conexão ao SSH.',
    'backup__error3115' => 'Nome do usuário ou senha incorretos.',
    'backup__error3116' => 'O usuário especificado não possui privilégios administrativos.',

    'dns_t__unable_to_remove_ns_record' => 'Não foi possível remover o registro NS do modelo DNS: Cada zona DNS deve ter, pelo menos, um registro NS.',
    'dns__unsupported_server_zone_transfer' => 'Não foi possível transferir o Modelo de Restrições de Transferência por causa da configuração DNS dos servidores: No servidor de origem, os endereços de rede a seguir são permitidos para a transferência de zona, mas esses endereços são proibidos pelo Servidor DNS da Microsoft: %1',
    'dns__unsupported_domain_zone_transfer' => 'Não foi possível transferir o Modelo de Restrições de Transferência por causa da configuração DNS dos domínios: Em alguns domínios, os endereços de rede a seguir são permitidos para a transferência de zona, mas esses endereços são proibidos pelo Servidor DNS da Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Não é possível acessar o diretório de rede temporário compartilhado para os arquivos de backup. Por favor, verifique as configurações do diretório de rede, usuário e senha. Erro: %1',

    'dbbackup__temp_dir_wrong_value' => 'O valor inválido por o diretório temporário foi especificado.',
    'dbbackup__network_temp_dir_wrong_value' => 'O valor inválido para o diretório de rede temporário foi especificado.',
    'dbbackup__server_backup_not_configured' => 'As configurações de backup do banco de dados não estão configuradas no servidor.',
    'dbbackup__temp_dir' => 'Diretório temporário',
    'dbbackup__temp_dir_hint' => 'O caminho para uma pasta física no servidor remoto onde o servidor MS SQL está localizado. O servidor MS SQL deve poder acessar esta pasta para ler e gravar os arquivos de backup temporários. Por exemplo, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'O caminho para o compartilhamento de rede mapeado da pasta física está especificado acima. O Plesk irá acessar a pasta de compartilhamento para download e upload dos arquivos de backup. Por exemplo, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'O nome de usuário de um usuário da rede criado no servidor da rede. Por exemplo, ServerName\\UserName. O usuário deve ter acesso à pasta compartilhada especificada acima.',
    'dbbackup__network_password_hint' => 'A senha do usuário da rede',

    'dbbackup__success_import_without_dublicate_users' => 'Os usuários a seguir não foram importados: %1. Eles já existem no servidor de banco de dados.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Comprima os arquivos de log",
    'log_rot__log_rot_status' => "Status de rotação de log",
    'log_rot__log_rot_period' => "Condição de rotação de logs",
    'log_rot__log_rot_size' => "por tamanho",
    'log_rot__log_rot_time' => "por horário",
    'log_rot__logrotation_enable' => "Ative a rotação de logs",
    'log_rot__mail' => "Envie os arquivos de log processados para o e-mail",
    'log_rot__max_number_of_logfiles' => "Número máximo de arquivos de log",
    'log_rot__time_period' => "período",
    'log_rot__unable_turn_off' => 'Não é possível desativar a rotação de log porque ela é forçada no nível do servidor',
    'log_rot__unable_set_period' => 'Não é possível definir o período de rotação de log diferente de \'daily\', porque ele é forçado no nível do servidor',
    'log_rot__unable_set_max_log_files' => 'Não é possível definir um número máximo de arquivos de log maiores que o limite de todo o servidor %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Espera-se um número: %1",
    'actionlog__incorrect_rotation' => "Parâmetros de rotação de logs inválidos especificados: %1",
    'actionlog__unknown_rot_period' => "Período de rotação desconhecido: %1",
    'actionlog__unknown_rot_type' => "Tipo de rotação desconhecido: %1",
    'actionlog__session_preferences' => 'Configurações de sessão',
    'actionlog__nis2_delete_prohibited' => 'A remoção de registros de log é proibida devido às restrições da diretiva NIS2 em vigor.',
    'actionlog__nis2_forbidden_rot_type' => "O tipo de rotação de log '%1' não pode ser usado devido às restrições da diretiva NIS2 em vigor.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Informações sobre o administrador',
    'actionlog__admin_preferences' => "Preferências do administrador",
    'actionlog__service' => 'Serviço',
    'actionlog__ip_addr' => 'Endereço IP',
    'actionlog__client' => 'Conta do cliente',
    'actionlog__client_status' => 'Status da conta do cliente',
    'actionlog__client_preferences' => "Preferências de interface do cliente",
    'actionlog__client_ip_pool' => "Pool de IP do cliente",
    'actionlog__client_siteapp' => "Pool de aplicativos da web do cliente",
    'actionlog__client_guid' => "GUID do cliente",
    'actionlog__domain' => 'Domínio padrão (o primeiro domínio adicionado a uma assinatura)',
    'actionlog__domain_owner' => 'Proprietário da assinatura',
    'actionlog__domain_plan' => 'Plano de serviço de assinatura',
    'actionlog__domain_status' => 'Domínio padrão, status',
    'actionlog__domain_dns' => 'Domínio padrão, zona DNS',
    'actionlog__subdomain' => 'Subdomínios de um domínio padrão',
    'actionlog__domain_alias' => 'Domínio padrão, nome alternativo',
    'actionlog__domain_alias_dns' => 'Domínio padrão, zona DNS de nome alternativo',
    'actionlog__site' => 'Domínio',
    'actionlog__site_status' => 'Status do domínio',
    'actionlog__site_dns' => 'Zona DNS do domínio',
    'actionlog__site_guid' => 'GUID do domínio',
    'actionlog__site_subdomain' => 'Subdomínio',
    'actionlog__site_alias' => 'Nome alternativo do domínio',
    'actionlog__site_alias_dns' => 'Zona DNS do nome alternativo do domínio',
    'actionlog__domain_limits' => 'Limites de assinatura',
    'actionlog__domain_limit_size' => 'Limite de espaço do disco para a assinatura',
    'actionlog__domain_limit_traffic' => 'Limite de tráfego para a assinatura',
    'actionlog__domain_limits_powerUser' => 'Limites de assinatura',
    'actionlog__domain_limit_size_powerUser' => 'Limite de espaço do disco para a assinatura',
    'actionlog__domain_limit_traffic_powerUser' => 'Limite de tráfego para a assinatura',
    'actionlog__domain_guid' => "Domínio padrão, GUID",
    'actionlog__cp_user' => 'Usuário do Plesk',
    'actionlog__mailname' => 'Conta de e-mail',
    'actionlog__maillist' => 'Mala direta',
    'actionlog__phosting' => 'Configurações de hospedagem',
    'actionlog__forwarding' => 'Hospedagem de encaminhamento padrão ou de quadro',
    'actionlog__webuser' => 'Conta do usuário da web',
    'actionlog__site_application' => 'Aplicativo da web',
    'actionlog__license' => 'Chave de licença',
    'actionlog__additional_license' => 'Chave de licença adicional.',
    'actionlog__template_domain' => "Plano de serviços do revendedor",
    'actionlog__template_admin' => "Plano de serviços do administrador",
    'actionlog__template_reseller' => 'Plano de revendedor',
    'actionlog__admin_alias' => 'Conta de administrador adicional', // PFW
    'actionlog__ftpuser' => 'Conta de FTP adicional', // PFW
    'actionlog__db_server' => 'Servidor do banco de dados',
    'actionlog__db' => 'Banco de dados',
    'actionlog__db_user' => 'Conta de usuário do banco de dados',
    'actionlog__client_sapppkg_pool' => "Aplicativo da web do usuário", // PFW, not used?
    'actionlog__remote_dns' => 'Status do servidor DNS remoto', // PFW
    'actionlog__reseller' => 'Conta do revendedor',
    'actionlog__reseller_guid' => 'GUID do revendedor',
    'actionlog__reseller_ip_pool' => "Pool de IP do revendedor",
    'actionlog__reseller_limit_size' => 'Limite de espaço do disco para conta do revendedor',
    'actionlog__reseller_limit_traffic' => 'Limite de tráfego para conta do revendedor',
    'actionlog__reseller_limits' => 'Limites da conta do revendedor',
    'actionlog__reseller_permissions' => 'Permissões do revendedor',
    'actionlog__reseller_preferences' => "Preferências de interface do revendedor",
    'actionlog__reseller_siteapp' => "Aplicativos da web no pool do revendedor",
    'actionlog__reseller_status' => 'Status da conta do revendedor',
    'actionlog__health_status' => 'Status de integridade do servidor',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'alcançado',
    'actionlog__added' => 'adicionado',
    'actionlog__removed' => 'removido',
    'actionlog__change' => 'alteradas',
    'actionlog__update' => 'atualizado',
    'actionlog__move' => 'transferido',
    'actionlog__upgrade' => 'atualizado', // PFU?
    'actionlog__update_or_add' => 'atualizado ou adicionado',
    'actionlog__expired' => 'expirado',
    'actionlog__create' => 'criado',
    'actionlog__delete' => 'excluído',
    'actionlog__service_stop' => 'interrompido',
    'actionlog__service_restart' => 'reiniciado',
    'actionlog__service_start' => 'iniciado',
    'actionlog__login' => 'Login efetuado',
    'actionlog__logout' => 'Logout efetuado',
    'actionlog__install' => 'instalado',
    'actionlog__uninstall' => 'não instalado',
    'actionlog__reconfigure' => 'reconfigurado',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Solicitação de redefinição de senha',
    'actionlog__event_admin_update' => 'Informações sobre administrador atualizadas',
    'actionlog__event_admin_preferences_update' => "Preferências do administrador atualizadas",
    'actionlog__event_service_restart' => 'Serviço reiniciado',
    'actionlog__event_service_start' => 'Serviço iniciado',
    'actionlog__event_service_stop' => 'Serviço interrompido',
    'actionlog__event_ip_address_create' => 'Endereço de IP criado',
    'actionlog__event_ip_address_delete' => 'Endereço de IP excluído',
    'actionlog__event_ip_address_update' => 'Endereço de IP atualizado',
    'actionlog__event_client_create' => 'Conta do cliente criada',
    'actionlog__event_client_delete' => 'Conta do cliente excluída',
    'actionlog__event_client_update' => 'Conta do cliente atualizada',
    'actionlog__event_client_status_update' => 'Status da conta do cliente atualizado',
    'actionlog__event_client_preferences_update' => "Preferências de interface do cliente atualizadas",
    'actionlog__event_client_siteapp_added' => "Aplicativo da web adicionado ao pool de aplicativos da conta do cliente",
    'actionlog__event_client_siteapp_removed' => "Aplicativo da web removido do pool de aplicativos da conta do cliente",
    'actionlog__event_domain_limit_size_reached' => 'Limite de espaço no disco para assinatura alcançado',
    'actionlog__event_domain_limit_traffic_reached' => 'Limite de tráfego para a assinatura alcançado',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Limite de espaço no disco para assinatura alcançado',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Limite de tráfego para a assinatura alcançado',
    'actionlog__event_dns_record_create' => 'Registro DNS criado',
    'actionlog__event_dns_record_delete' => 'Registro DNS removido',
    'actionlog__event_dns_record_update' => 'Registro DNS atualizado',
    'actionlog__event_dns_zone_soa_record_update' => 'Registro DNS SOA atualizado',
    'actionlog__event_dns_zone_switch_to_master' => 'Zona DNS alterada para primária',
    'actionlog__event_dns_zone_switch_to_slave' => 'Zona DNS alterada para secundária',
    'actionlog__event_dns_zone_turn_off' => 'Zona DNS desabilitada',
    'actionlog__event_dns_zone_turn_on' => 'Zona DNS abilitada',
    'actionlog__event_pw_admin_force_reset' => 'A senha de uma conta de administrador sinalizada para redefinição de senha obrigatória foi alterada',

    'actionlog__domain_limit_database' => 'Cota das bases de dados para assinatura',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'A cota das bases de dados MariaDB/MySQL para a assinatura foi atingida',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'A cota flexível das bases de dados MariaDB/MySQL para a assinatura foi atingida',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'A cota de bases de dados do servidor Microsoft SQL para a assinatura foi atingida',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'A cota flexível de bases de dados do servidor Microsoft SQL para a assinatura foi atingida',
    'actionlog__event_plesk_component_upgrade' => 'Componente Plesk atualizado',
    'actionlog__event_plesk_component_install' => 'Componente Plesk instalado',
    'actionlog__event_plesk_component_uninstall' => 'Componente Plesk desinstalado',
    'actionlog__event_domain_create' => 'Domínio padrão (o primeiro domínio adicionado a uma assinatura) criado',
    'actionlog__event_domain_delete' => 'Domínio padrão (o primeiro domínio adicionado a uma assinatura) excluído',
    'actionlog__event_domain_update' => 'Domínio padrão (o primeiro domínio adicionado a uma assinatura) atualizado',
    'actionlog__event_domain_owner_change' => 'Proprietário da assinatura alterado',
    'actionlog__event_domain_plan_change' => 'Mudança no plano de serviço de assinatura',
    'actionlog__event_domain_status_update' => 'Domínio padrão, status atualizado',
    'actionlog__event_domain_dns_update' => 'Domínio padrão, zona DNS atualizada',
    'actionlog__event_subdomain_create' => 'Subdomínio criado',
    'actionlog__event_subdomain_delete' => 'Subdomínio excluído',
    'actionlog__event_subdomain_update' => 'Subdomínio atualizado',
    'actionlog__event_domain_alias_create' => 'Nome alternativo do domínio criado',
    'actionlog__event_domain_alias_delete' => 'Nome alternativo do domínio excluído',
    'actionlog__event_domain_alias_update' => 'Nome alternativo do domínio atualizado',
    'actionlog__event_domain_limits_update' => 'Limites de assinatura atualizados',
    'actionlog__event_cp_user_login' => 'Usuário do Plesk efetuou login',
    'actionlog__event_cp_user_logout' => 'Usuário do Plesk efetuou logout',
    'actionlog__event_mailname_create' => 'Conta de e-mail criada',
    'actionlog__event_mailname_delete' => 'Conta de e-mail excluída',
    'actionlog__event_mailname_clear' => 'Conta de e-mail esvaziada',
    'actionlog__event_mailname_update' => 'Conta de e-mail atualizada',
    'actionlog__event_maillist_create' => 'Mala direta criada',
    'actionlog__event_maillist_delete' => 'Mala direta excluída',
    'actionlog__event_maillist_update' => 'Mala direta atualizada',
    'actionlog__event_phys_hosting_create' => 'Hospedagem física criada',
    'actionlog__event_phys_hosting_delete' => 'Hospedagem física excluída',
    'actionlog__event_phys_hosting_update' => 'Hospedagem física atualizada',
    'actionlog__event_forwarding_create' => 'Hospedagem de encaminhamento padrão ou de estrutura criada',
    'actionlog__event_forwarding_delete' => 'Hospedagem de encaminhamento padrão ou de estrutura excluída',
    'actionlog__event_forwarding_update' => 'Hospedagem de encaminhamento padrão ou de estrutura atualizada',
    'actionlog__event_webuser_create' => 'Conta de usuário da web criada',
    'actionlog__event_webuser_delete' => 'Conta de usuário da web excluída',
    'actionlog__event_webuser_update' => 'Conta de usuário da web atualizada',
    'actionlog__event_siteapp_install' => 'Aplicativo da web instalado',
    'actionlog__event_siteapp_reconfigure' => 'Aplicativo da web reconfigurado',
    'actionlog__event_siteapp_uninstall' => 'Aplicativo da web desinstalado',
    'actionlog__event_license_update' => 'Chave de licença atualizada',
    'actionlog__event_admin_alias_create' => 'Conta de administrador adicional criada',
    'actionlog__event_admin_alias_delete' => 'Conta de administrador adicional excluída',
    'actionlog__event_admin_alias_update' => 'Conta de administrador adicional atualizada',
    'actionlog__event_ftpuser_create' => 'Conta FTP adicional criada',
    'actionlog__event_ftpuser_update' => 'Conta FTP adicional atualizada',
    'actionlog__event_ftpuser_delete' => 'Conta FTP adicional excluída',
    'actionlog__event_template_domain_create' => "Plano de serviços do revendedor criado",
    'actionlog__event_template_domain_update' => "Plano de serviços do revendedor atualizado",
    'actionlog__event_template_domain_delete' => "Plano de serviços do revendedor excluído",
    'actionlog__event_template_admin_create' => "Plano de serviços do administrador criado",
    'actionlog__event_template_admin_update' => "Plano de serviços do administrador atualizado",
    'actionlog__event_template_admin_delete' => "Plano de serviços do administrador excluído",
    'actionlog__event_database_server_create' => 'Servidor do banco de dados criado',
    'actionlog__event_database_server_update' => 'Servidor do banco de dados atualizado',
    'actionlog__event_database_server_delete' => 'Servidor do banco de dados excluído',
    'actionlog__event_remote_dns_status_update' => 'Status do servidor DNS remoto atualizado',
    'actionlog__event_session_preferences_update' => 'Configurações de sessão atualizadas',
    'actionlog__event_domain_alias_dns_update' => 'Domínio padrão, zona de DNS do nome alternativo do domínio atualizada',
    'actionlog__event_domain_move' => 'Domínio padrão movido para uma nova assinatura',
    'actionlog__event_site_move' => 'Domínio movido para uma nova assinatura',
    'actionlog__event_site_subdomain_move' => 'Subdomínio movido para uma nova assinatura',
    'actionlog__event_subdomain_move' => 'Subdomínio de um domínio padrão movido para uma nova assinatura',
    'actionlog__event_license_expired' => 'A licença do Plesk expirou',
    'actionlog__event_database_create' => 'Banco de dados criado',
    'actionlog__event_database_delete' => 'Banco de dados removido',
    'actionlog__event_database_user_create' => 'Conta de usuário do banco de dados criada',
    'actionlog__event_database_user_update' => 'Configurações da conta de usuário do banco de dados atualizadas',
    'actionlog__event_database_user_delete' => 'Conta de usuário do banco de dados removida',
    'actionlog__event_client_guid_update' => "GUID do cliente atualizado",
    'actionlog__event_domain_guid_update' => 'Domínio padrão, GUID atualizado',
    'actionlog__event_reseller_create' => 'Conta de revendedor criada',
    'actionlog__event_reseller_delete' => 'Conta de revendedor excluída',
    'actionlog__event_reseller_update' => 'Conta do revendedor atualizada',
    'actionlog__event_reseller_guid_update' => 'GUID de revendedor atualizado',
    'actionlog__event_reseller_ip_pool_update' => "Pool de IP do revendedor atualizado",
    'actionlog__event_reseller_limit_size_reached' => 'Limite de espaço do disco para conta do revendedor alcançado',
    'actionlog__event_reseller_limit_traffic_reached' => 'Limite de tráfego para conta do revendedor alcançado',
    'actionlog__event_reseller_limits_update' => 'Limites de conta do revendedor atualizados',
    'actionlog__event_reseller_permissions_update' => 'Permissões da conta do revendedor atualizadas',
    'actionlog__event_reseller_preferences_update' => "Preferências de interface do revendedor atualizadas",
    'actionlog__event_reseller_siteapp_added' => "Aplicativo adicionado ao pool de aplicativos da conta do revendedor",
    'actionlog__event_reseller_siteapp_removed' => "Aplicativo removido do pool de aplicativos da conta do revendedor",
    'actionlog__event_reseller_status_update' => 'Status da conta do revendedor atualizado',
    'actionlog__event_template_reseller_create' => 'Plano do revendedor criado',
    'actionlog__event_template_reseller_delete' => 'Plano do revendedor excluído',
    'actionlog__event_template_reseller_update' => 'Plano do revendedor atualizado',
    'actionlog__event_health_status_change' => 'Status de integridade do servidor alterado',
    'actionlog__event_siteapp_upgrade' => 'Aplicativo da web atualizado',
    'actionlog__event_extension_install' => 'Extensão instalada',
    'actionlog__event_extension_uninstall' => 'Extensão desinstalada',
    'actionlog__event_extension_upgrade' => 'Extensão aprimorada',
    'actionlog__event_extension_status_update' => 'Status da extensão atualizado',
    'actionlog__event_additional_license_expired' => 'A licença adicional expirou',
    'actionlog__event_hostname_changed' => 'Nome de host do servidor alterado',
    'actionlog__event_smb_user_create' => 'Usuário adicional criado',
    'actionlog__event_smb_user_delete' => 'Usuário adicional excluído',
    'actionlog__event_smb_user_update' => 'Usuário adicional atualizado',
    'actionlog__dns_record' => 'Registro DNS',
    'actionlog__dns_zone' => 'Zona DNS',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "O Plesk API RPC não foi instalado no host remoto. Entre em contato com seu provedor de serviços para obter assistência.",
    'rsession_no_account_errmsg' => "Não foi possível acessar o serviço remoto sob sua conta. O motivo mais comum é que o serviço para sua conta ainda não foi ativado. Espere alguns minutos e tente novamente. Se encontrar este erro novamente, entre em contato com seu administrador do sistema.",
    'rsession_no_domain_errmsg' => "Não foi possível acessar o serviço remoto por este domínio. Geralmente o motivo é que o serviço para este domínio ainda não foi ativado. Espere alguns minutos e tente novamente. Se encontrar este erro novamente, entre em contato com seu administrador do sistema.",
    'rsession_unknown_errmsg' => "O servidor remoto rejeitou a tentativa de estabelecer uma sessão. Entre em contato com seu administrador do sistema para obter suporte. O erro foi: %1",
    'rsession_unknown2_errmsg' => "Erro desconhecido durante o estabelecimento de uma sessão remota. O servidor remoto provavelmente não pode responder ou não responde de forma adequada. Peça a seu administrador do sistema que verifique detalhes de erros no log de erros do servidor da web.",
    'rsession_no_connect_errmsg' => "Não foi possível acessar o serviço remoto: a conexão com a sessão remota falhou. Entre em contato com seu administrador do sistema para obter suporte.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Permitir o upload a partir do diretório de entrada",
    'anonftp__allow_create_dirs' => 'Permitir a criação de diretórios no diretório de entrada',
    'anonftp__allow_download_incoming' => 'Permitir o download a partir do diretório de entrada',
    'anonftp__display_login' => 'A mensagem de login de exibição',
    'anonftp__login_text' => 'Texto da mensagem',
    'anonftp__limit_incoming_disk_space' => "Espaço de disco limite no diretório de entrada",
    'anonftp__limit_maximum_bandwidth' => "Largura de banda para download limite para este domínio FTP virtual",
    'anonftp__limit_maximum_connections' => "Número limite de conexões simultâneas",
    'anonftp__unable_init' => "Não é possível inicializar uma conta FTP anônima: %1",
    'anonftp__unable_set_quota' => "Não é possível configurar o limite de espaço de disco do diretório de entrada: %1",
    'anonftp__unable_update' => "Não é possível atualizar as propriedades de uma conta FTP anônima: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificados SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => " O certificado CA não assina o certificado.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Par de certificado/chave privada incompatível.",
    'class_sslcertificate__invalid_cert_format' => "Formato de certificado inválido.",
    'class_sslcertificate__invalid_private_key_format' => "Formato de chave privada inválido.",
    'class_sslcertificate__prob_invalid_priv_key' => "O formato de chave privada é provavelmente inválido.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Nenhum arquivo para efetuar upload.',
    'login_up__access_denied_no_permission' => "Acesso negado. Você não tem permissão para efetuar o login.",
    'mail__unable_remove_pattern' => "Não foi possível remover o endereço da lista negra do servidor: %1", // PFW
    'mail__incorrect_network_format' => 'Formato de rede incorreto: %1', // PFW
    'initconf__unable_change_passwd' => "Não é possível alterar a senha do administrador: %1",
    'initconf__unable_get_passwd' => 'Não é possível obter a senha de administrador atual: %1 falhou: %2',
    'initconf__invalid_hostname' => 'Erro no nome do host "%1"',
    'initconf__unable_reconfig' => 'Não foi possível configurar o Plesk:  reconfiguração falhou: %1',
    'initconf__unable_update_admin' => 'Não é possível atualizar as informações de contato do administrador: %1',
    '__refresh' => 'Atualizar',
    '__dalias_not_exist' => 'O nome alternativo do domínio não existe.',
    '__bug146523_explanation' => ' Versões anteriores do Plesk disponíveis utilizando até 16 caracteres para os nomes de usuário do FTP. Esta versão do Plesk limita o número máximo de caracteres permitido nos nomes de usuários do FTP para 15. Para resolver este problema, reduza a extensão do nome de usuário do FTP para 15 caracteres para os nomes de usuários do FTP afetados, e altere, pelo menos, um caractere nos nomes de usuários do FTP afetados a fim de evitar problemas de colisão de nome de usuário. Desculpe qualquer inconveniência possível causada por essa alteração.',
    'domain__cannot_change_webmail' => 'Não foi possível mudar o webmail para o domínio: %1',
    'sb_publish_disable_warning' => 'Se você desativar a criação do web site com o Presence Builder, o web site criado anteriormente no Presence Builder será removido e todos os dados do web site serão perdidos. Clique em OK se deseja continuar.',
    '__sbnet_client_use_sbnet' => "Criar uma conta de usuário correspondente no Presence Builder",
    'mail_resp_activate' => 'Ativar a resposta automática',
    'limitsManger__limit_available_error' => 'Não é possível alocar a quantidade exigida de recursos ("%%limitName%%"): somente %%available%% está disponível para sua conta.',
    'limitsManger__limit_reserved_error' => 'Não é possível alocar menos recursos ("%%limitName%%") do que os já utilizados.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Não é possível renomear o domínio: Um diretório virtual com o nome especificado já existe.',
    'domain_unable_to_rename' => 'Não é possível renomear o domínio.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Geral',
    'spamfilter__spamassassin_status_legend' => 'Filtragem de spam do SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Configurações do SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Ative a filtragem de spam SpamAssassin em todo o servidor",
    'spamfilter__spamassassin_user_status_legend' => 'Ativar a filtragem de spam do SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Ative a proteção anti-spam greylisting em todo o servidor',
    'spamfilter__personal_settings_not_allowed' => 'O uso de configurações de filtragem de spam individuais não é permitido pela política do sistema.',
    'spamfilter__required_score' => 'A pontuação que uma mensagem deve receber para ser classificada como spam',
    'spamfilter__rewrite_header_subject' => 'Adicionar o seguinte texto ao início do assunto de cada mensagem reconhecida como spam',
    'spamfilter__use_mailuser_prefs' => 'Aplicar configurações individuais à filtragem de spam',
    'spamfilter__score_error' => 'A pontuação não deve ser negativa, a parte antes do ponto decimal deve ser inferior a 100 e não pode incluir mais do que dois dígitos depois do ponto decimal.',
    'spamfilter__rewrite_header_error' => 'O assunto da mensagem pode conter quaisquer caracteres imprimíveis, exceto o sinal numérico (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Devolução',
    'nonexistent_mail__mode_discard' => 'Descartar',
    'nonexistent_mail__mode_catch_addr' => 'Encaminhe para endereço de e-mail',
    'nonexistent_mail__mode_catch_ip' => 'Encaminhar para IP',
    'nonexistent_mail__bounce_not_supported' => 'Modo de devolução não suportado',
    'nonexistent_mail__discard_not_supported' => 'Modo Descartar não suportado',
    'nonexistent_mail__catch_not_supported' => 'Encaminhamento para o endereço de e-mail não suportado',
    'nonexistent_mail__redirect_not_supported' => 'O encaminhamento para IP não é suportado',
    'nonexistent_mail__ip_used_on_this_host' => 'Endereço de IP resolvido para o host local',
    'nonexistent_mail_address_should_be_local_domain' => 'Como o controle do e-mail em andamento está ligado, o endereço de e-mail %1 para os destinatários não existentes deve pertencer ao domínio selecionado. Se não estiver, então a política "Reject" será aplicada em vez de encaminhada.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Desde que o controle de saída de e-mails estiver ligado, o endereço de e-mail especificado para enviar e-mails (%1) deve pertencer ao domínio selecionado. Se não estiver, então as mensagens enviadas para esse endereço não serão contadas no Controle de Saída de E-mail.',
    // mail acc extras
    '__antivirus' => "Antivírus",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'O suporte do ASP.NET foi desabilitado para este web site.',
    'phosting__php_forced_by_site_isolation' => 'Impossível alterar as configurações de PHP: a permissão para anular a política de segurança em todo o servidor não é concedida.',
    'phosting__option_forced_by_site_isolation' => 'Impossível alterar as configurações %1: a permissão para anular a política de segurança em todo o servidor não é concedida.',
    'phosting__php_handler_id_not_registered' => 'O PHP handler não é permitido nas configurações de isolamento local. O PHP handler-padrão será utilizado.',
    'phosting__php_served_by_nginx_is_not_available' => 'O PHP handler (Aplicativo FPM servido por nginx) não é permitido nas configurações de isolamento local. O PHP handler-padrão será utilizado.',

    // tooltips

    'b_get_password_cancel' => 'Volte para a tela anterior sem enviar o e-mail.',
    'b_get_password_send' => 'Clique em OK para enviar uma mensagem de recuperação de senha para o endereço de e-mail registrado no sistema.',

    'b_back' => 'Voltar para a página anterior.',
    'b_next' => 'Ir para a próxima página.',

    'b_dnsnstemplatelist_remove' => 'Excluir os servidores de nomes selecionados.',
    'b_dnsnstemplatelist_search' => 'Inserir um padrão de busca e clique para encontrar os nomes dos servidores.',
    'b_dnsnstemplatelist_show_all' => 'Exibir todos os servidores por nome.',

    'l_dnsnstemplatelist_ns' => 'Ordenar os registros de modelo de DNS.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Gerar links seguros para os arquivos e pastas',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Habilitar os arquivos públicos',
    'cu__serverfilesharing_fsPublicFolder' => 'Pasta para armazenagem de arquivos públicos',
    'cu__serverfilesharing_fsPublicUrl' => 'URL para acesso de visitante aos arquivos públicos',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Habilitar a proteção de senha de arquivos públicos',
    'cu__serverfilesharing_fsPartnerFolder' => 'Pasta para a armazenagem de arquivos protegidos por senha',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nome de usuário para acesso a arquivos',
    'cu__serverfilesharing_fsPartnersPassword' => 'Senha para acesso a arquivos',
    'cu__serverfilesharing_fsDomain' => 'URL da raiz da pasta da web. Nome do domínio',
    'cu__serverfilesharing_fsPrefix' => 'URL da raiz da pasta da web. Prefixo',
    'cu__serverfilesharing_commandUpdate' => 'Atualizar as configurações de compartilhamento de arquivo',
    'cu__serverfilesharing_commandInfo' => 'Mostrar as configurações de compartilhamento de arquivo atuais',
    'subscription_rename_is_forbidden' => 'Pela política de todo o servidor é proibido renomear as assinaturas.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "Contas de FTP sob o Domínio %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Contas de FTP",
    'ftp__user_name' => "Nome da conta de FTP",
    'ftp__user_home' => "Diretório Home",
    'ftp__invalid_path' => "Caminho inválido especificado",
    'i_ftp_ses_sub_user' => 'Sessão da conta de FTP.',
    '__new_passwd' => "Nova senha %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'A reconfiguração do Apache no host <%%host%%> falhou',
    'apacheConfigurationFailedMessageBody' => "A geração da nova configuração do Apache no host <%%host%%> falhou porque houve o(s) seguinte(s) erro(s):\n\n%%error%%\n\nCorrija o(s) erro(s) nos modelos da configuração do Apache e tente gerar novamente o arquivo de configuração.",

    'apacheConfigurationMessageAdminTitle' => 'A geração da configuração do servidor web falhou',
    'apacheConfigurationMessageClientTitle' => 'Aviso',

    'apacheConfigurationFailedAdminHomeMessage' => 'O novo arquivo de configuração não foi preparado em razão dos erros nos modelos de configuração. A mensagem de erro detalhada foi enviada para seu e-mail, portanto, verifique o e-mail, corrija os erros e clique em %1 para tentar gerar novamente a configuração',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'aqui', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'A nova configuração para o domínio %1 não foi concluída em razão dos erros nos modelos de configuração.  A mensagem de erro detalhada foi enviada para seu e-mail, portanto, verifique o e-mail, corrija os erros e clique em %2 para tentar gerar novamente a configuração.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'aqui', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'A configuração do servidor web para o domínio %1 pode ser inconsistente. Entre em contato com o administrador do servidor para resolver o problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'A nova configuração para alguns domínios não foi concluída em razão dos erros nos modelos de configuração.  A mensagem de erro detalhada foi enviada para seu e-mail, portanto, verifique o e-mail, corrija os erros e clique em %1 para tentar gerar novamente a configuração.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'aqui', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'A configuração do servidor web para alguns de seus domínios pode ser inconsistente. Entre em contato com o administrador do servidor para resolver o problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documentos de erro customizados",
    'dom_pref__webusers_script' => "Permite aos usuários de internet utilizar os scripts",
    '__seoRedirect' => 'Configure o domínio de sua preferência como ',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Nenhum',

    '__sites' => 'Domínios',
    'domain_plan__perm_denied_manage_phosting' => 'Você não tem permissão para gerenciar as configurações de hospedagem.',
    '__owned_by_client' => 'propriedade do cliente',
    'backup__restore__object_client_template' => 'Modelo do cliente',
    '__template_name' => 'Nome do plano de serviços',
    'template__not_exists' => 'Não existe nenhum plano de serviço desse tipo',
    'template__exists' => 'Um plano com o nome %1 já existe.',
    'clientOwnerChanger__ip_not_in_pool' => 'O endereço IP especificado não está no pool do revendedor.',
    '__owner_name' => 'Proprietário do plano de serviço',

    'chown__error_check' => 'Alguns problemas foram encontrados ao tentar atribuir algumas das assinaturas a um novo proprietário.',

    '__redirect_hint' => 'Você será redirecionado para o novo endereço em 15 segundos... Se não for conduzido automaticamente ao novo local, habilite o javascript ou clique no hyperlink %%link%%.',

    'backup__restore__object_maillist' => 'Mala direta',
    'backup__restore__object_site' => 'Website',
    'backup__restore__object_user' => 'Usuário',
    'backup__restore__object_role' => 'Função',

    'limit__name_max_site' => 'sites',

    'iis_pool__unable_rename_client' => "Não é possível renomear o Pool de Aplicativos IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'O serviço FTP anônimo é suportado apenas para o domínio principal de uma assinatura.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'O serviço FTP anônimo é suportado apenas para o domínio principal de uma assinatura.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/mês',
    '__tb_month' => 'TB/mês',

    '__customer_total' => 'Total do cliente',
    '__site' => 'Site',
    '__def_site' => 'Site-padrão',
    '__subscription_name' => 'Nome da assinatura',
    '__subscription_name_powerUser' => 'Nome da assinatura',

    'limit__units_max_traffic_suffix' => '/mês',

    'dom_pref__discard' => "Rejeitar",

    'mail__pattern_already_exists' => 'O padrão "%1" já se encontra na lista negra.',

    '__not_supported' => 'Não suportado',

    'plesk_key__sitebuilder' => 'Sites publicados com o Presence Builder',
    'limit__name_max_site_builder' => 'Sites publicados com o Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Suporte para sites multilingues no Presence Builder',

    'login_up__access_denied_no_subscriptions' => "Acesso negado. Não há nenhuma assinatura disponível para esta conta.",

    'interval__day' => '%1 dia(s)',
    'interval__hour' => '%1 hora(s)',
    'interval__minute' => '%1 minuto(s)',
    'interval__second' => '%1 segundo(s)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Você está tentando usar uma chave de licença criada para outra versão do Plesk. Entre em contato com os representantes de vendas do Plesk para obter uma chave de licença adequada.',
    //Standalone or virtualization
    'virtualization_any' => "O servidor físico ou qualquer solução de visualização",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Servidor Virtuozzo",
    'plesk_key__virtualization' => "Válido para os seguintes ambientes:",
    'plesk_key__virtualization_only_key' => 'A chave de licença deve ser utilizada apenas com o Plesk funcionando dentro de um ambiente virtual %1.',
    'plesk_key__virtualizations_only_key' => 'A chave de licença deve ser utilizada apenas com o Plesk funcionando dentro dos seguintes ambientes virtuais: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'O uso de pacotes de idiomas customizados é proibido.',
    'plesk_key__allowed-locales' => 'Idiomas disponíveis',
    'plesk_key__allowed-locales-any' => 'Qualquer idioma',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'o diretório cgi-bin está localizado em',
    '_cgi_bin_mode_webspace' => 'o diretório raiz da assinatura',
    '_cgi_bin_mode_www_root' => 'o documento raiz deste domínio',

    /// Custom buttons
    'custom_button__sort_key' => 'Prioridade',
    'custom_button__place' => 'Localização',
    'custom_button__place_navigation' => 'Acesso comum',
    'custom_button__place_admin' => 'Página inicial do administrador',
    'custom_button__place_admin-settings' => 'Página de configurações e ferramentas de administração',
    'custom_button__place_reseller' => "Página inicial do revendedor",
    'custom_button__place_reseller-settings' => 'Página de utilidades e ferramentas de revendedor',
    'custom_button__place_client' => 'Página inicial do cliente',
    'custom_button__place_domain' => "Página de Websites e Domínios da Assinatura",
    'custom_button__place_domain_powerUser' => "Página de Websites e Domínios da Assinatura",
    'custom_button__place_domain-properties' => 'Ferramentas de web site',
    'custom_button__private' => 'Mostre-me apenas',
    'custom_button__image' => 'Imagem do plano de fundo',
    'custom_button__conhelp' => "Texto da dica de ferramenta",
    'custom_button__edit' => "Configurações de um link para um serviço adicional",
    'custom_button__include_client_cname' => "Incluir o nome da empresa do cliente",
    'custom_button__include_client_email' => "Inclua o e-mail do cliente",
    'custom_button__include_client_id' => "Incluir a ID do cliente",
    'custom_button__include_client_pname' => "Incluir o nome do contato do cliente",
    'custom_button__include_domain_id' => "Incluir a ID de assinatura, ID de domínio e ID de apelido de domínio",
    'custom_button__include_domain_id_powerUser' => "Incluir a ID de assinatura, ID de domínio e ID de apelido de domínio",

    'custom_button__include_domain_name' => "Incluir o nome de Domínio Primário",
    'custom_button__include_ftp_user' => "Incluir o nome de usuário de FTP",
    'custom_button__include_ftp_pass' => "Incluir senha FTP",
    'custom_button__internal_open' => "Abrir a URL no Plesk",
    'custom_button__text' => "Rótulo do botão",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'O arquivo não é um arquivo de imagem.',
    'custom_button__big_image' => 'O tamanho do arquivo não deve exceder 100 KB.',
    'custom_button__failed_copy_image' => 'Não foi possível copiar o arquivo: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Não é possível restaurar um backup de Usuário sem Autorização na visualização do Usuário com Autorização.',
    '__unknown_network_interface' => 'Interface de rede desconhecida',

    'init_conf__ip_address' => 'Endereço IP',

    //Confirmation page
    'bt_confirm' => 'Confirme',
    'b_confirm' => 'Confirmar a propriedade de seus sites.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'As configurações do pool de aplicativos IIS dedicado são definidas de acordo com a política de segurança em todo o servidor (configuração de isolamento do site).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'As configurações do pool de aplicativos IIS dedicado são definidas de acordo com as configurações de desempenho em todo o servidor.',

    '__current' => 'Atual',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Você utilizou quase todos os domínios fornecidos com sua licença do Plesk (90% ou até mais).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Você utilizou quase todos os domínios',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Você utilizou quase todos os sites do Presence Builder fornecidos com sua licença do Plesk (90% ou até mais).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Você utilizou quase todos os sites do Presence Builder',
    'promo__button_hide' => 'Ocultar',
    'promo__button_next' => 'Seguinte >>',
    'promo__button_prev' => '<< Anterior',
    'promo__button_license' => 'Atualizar a licença',

    'promo__google_integration_title' => 'Integração com os serviços do Google',
    'promo__google_integration' => 'Configurar a integração com os serviços Google, como AdSense, Google Apps e ferramentas para webmaster.',
    'promo__google_integration_button' => 'Configurar',

    'promo__button_learn_more' => 'Saiba mais',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'É possível customizar a aparência da interface e configurações de personalização por meio de temas customizados. Para instruções sobre a customização de temas do Plesk, consulte o %1.',
    'panel_branding__description_link' => 'documento seguinte',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extrair os arquivos',
    'filemanager_error_extracting_files' => 'Ocorreu um erro ao extrair os arquivos: %1',
    'filemanager_no_archive_files_specified' => 'Especifique os arquivos que deseja extrair.',
    'filemanager_not_zip_archive_specified' => '%1 não pode ser extraído, por não se tratar de um arquivo ZIP.',
    'filemanager_files_successfully_extracted' => 'Os arquivos foram extraídos.',
    'filemanager_error_file_download' => 'O download do arquivo falhou: %1',
    'filemanager__user_poolgrp' => 'Grupo do pool de aplicativos',

    'loading' => 'Carregando...',
    'bt_create_archive' => 'Adicionar ao arquivo',
    'filemanager__pack' => "Caminho para o arquivo: %1",
    'filemanager__archive_name' => 'Nome do arquivo',
    'filemanager__empty_filename' => 'Digitar o nome do arquivo.',
    'filemanager_archive_created' => 'O arquivo foi criado com êxito.',
    'filemanager_error_creating_archive' => 'Não é possível criar o arquivo: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Este registro irá conflitar com o registro AAAA para a zona.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(O servidor de FTP não suporta endereços IPv6).",
    'cmd_dns__glue_dns_record_conflict' => 'Este registro irá conflitar com o registro para a zona \'%1\'.',
    '__ftp_ipv6_not_supported' => "(O servidor de FTP não suporta endereços IPv6).",
    '__ipv6_not_supported' => 'O IPv6 não é suportado.',
    'mail__ipv6_not_supported' => 'O IPv6 não é suportado pelo servidor de e-mail.',
    'mail__relay_while_list_ipv6_not_supported' => 'A lista branca de retransmissão do IPv6 não é suportada pelo servidor de e-mail.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'O valor da máscara deve ser um múltiplo de 16.',
    'mail__ip_or_mask_is_invalid' => 'O endereço de IP, ou máscara, é inválido.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'O encaminhamento para os endereços de IPv6 não é suportado.',
    'sa__invalid_trusted_networks' => 'Redes confiáveis especificadas incorretamente: %1',
    'dns_add__enter_ipv6_address' => "endereço de IPv6",
    'license_trial_days_left' => 'Seu Plesk está funcionando com uma licença de avaliação que irá expirar em %1 dias.',
    'excl_ipv6_num' => 'Endereço IPv6 dedicado',
    '__ip_mask' => "Máscara de sub-rede",
    '__ipv4_addr' => 'Endereço IPv4',
    '__ipv6_addr' => 'Endereço IPv6',
    'template__num_excl_ipv6s' => 'Alocar os endereços de IPv6 dedicados ao revendedor',
    'anonftp__exclusive_ipv4_required' => 'Um endereço de IPv4 dedicado é necessário para configurar e utilizar o serviço de FTP anônimo.',
    'anonftp__ipv4_already_used' => 'Não é possível configurar o serviço FTP anônimo para este site, porque já está configurado em outro domínio no mesmo endereço de IPv4.',


    'restart__kav' => "Antivírus Kaspersky",
    '__view_migration_log_detailed_info' => 'Visualizar o log',

    'chown__error_ip_absent_in_ip_pool' => 'O endereço de IP %1 não está presente no pool de IPs do usuário-alvo.',
    'chown__error_ip_not_exist' => 'O endereço de IP com ID \'%1\' não existe.',
    'chown__error_domain_ip_not_selected' => 'Pelo menos um endereço de IP para o domínio %1 deve ser selecionado. Verifique os valores selecionados para o mapeamento de IP.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'O endereço IPv6 ou a máscara é inválida: o endereço IP deve ser um endereço unicast válido.',

    '__subscriptions' => 'Assinaturas',

    '__owned_by_reseller' => 'propriedade do revendedor',
    '__owned_by_provider' => 'propriedade do provedor',

    'service_plan__anonymous' => 'Customizar',
    'subscription_not_locked__change_limits_warning' => 'Essa assinatura está bloqueada: Os limites de uso de recursos serão alterados durante a sincronização com o plano de serviço.',
    'subscription_not_locked__change_permissions_warning' => 'Essa assinatura está bloqueada: As permissões serão alteradas durante a sincronização com o plano de serviço.',

    'subscription__conflict_resolution_policy' => 'Política de resolução de conflitos',
    'subscription__conflict_resolution_policy_lock' => "Bloqueio da assinatura",

    'backup__list__backup_warnings' => 'Avisos',
    'backup__list__backup_info' => 'Informações',
    'backup__restore__object_reseller_template' => 'Modelo do revendedor',
    'backup__restore__object_domain_template' => 'modelo do domínio',

    'subscription__unable_lock_anonymous' => 'Essa assinatura não está vinculada ao plano de serviço e, portanto, não pode ser desbloqueada.',
    'subscription__unable_sync_anonymous' => 'Essa assinatura não está vinculada ao plano de serviço e, portanto, não pode ser sincronizada.',
    'subscription__unable_sync_locked' => 'Essa assinatura está bloqueada e, portanto, não pode ser sincronizada.',
    'subscription__locked' => 'A assinatura está bloqueada.',
    'component_name__urlrewrite' => "Reescreva a URL",
    '__quantity' => 'Quantidade',
    'hst__www_root_dir_absent' =>  'Aviso: O diretório especificado como documento raiz não existe.',
    'object_creation__domain_is_not_a_webspace' => 'Este objeto pode ser criado somente em uma assinatura.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'A assinatura contém sites, no entanto, você não pode mudar o tipo de hospedagem ou exclui-la.',
    'phosting__apache_error_docs_are_not_enabled' => 'Documentos de erro personalizados não estão habilitados no domínio.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Erro: Falha ao atualizar o endereço IP. Os complementos de domínios não podem ser atribuídos a um endereço IP não atribuído ao domínio principal da assinatura.',
    'domain_plan__unable_change' => 'Não foi possível alterar o plano de serviço: %1.',
    'domain_plan__different_hosting_type' => 'O tipo atual de hospedagem é diferente do tipo especificado no plano de serviço.',
    'domain_plan__addon_text' => 'Plano complementar',
    'domain_plan__addon_description' => 'O plano complementar é utilizado para suplementar um plano de hospedagem.',
    'asp_net__managed_runtime_version' => 'Versão do tempo de execução gerenciado por ASP.NET',
    'plan__can_not_change_hosting_type' => 'Não é possível alterar o tipo de hospedagem ao editar um plano.',
    'plan__apply_problems' => 'O plano não foi aplicado em função de problemas com a seguinte funcionalidade: %1',
    'plan_save__subscription_update_problem' => 'Não foi possível aplicar as alterações de plano para %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "A assinatura é temporariamente suspensa até que o processo de backup ou restauração seja concluído. Volte mais tarde.",
    '__login_incorrect_plain_shadow_password' => 'Você especificou uma senha incorreta na conta do administrador. Utilizar as credenciais (raiz) do administrador do sistema ou obtenha a senha correta. Para saber mais sobre a obtenção da senha, leia o arquivo /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Você não pode enviar o endereço IP que você não possui',

    'dns__dns_zone_not_synchronized' => 'A zona DNS foi modificada. Caso prefira aplicar alterações no modelo DNS a esta zona, clique no botão \'Aplicar Alterações no Modelo DNS\' nesta página ou escolha a opção \'Aplicar as alterações a todas as zonas\' no Painel de administração do servidor > Ferramentas e Configurações > Configurações do Modelo de DNS > Aplicar Alterações no Modelo de DNS.',
    'dns__dns_zone_synchronize_link' => 'Clique',
    'dns__dns_zone_synchronize_done' => 'A zona DNS foi sincronizada com êxito.',

    'dns__dns_zone_template_error' => 'Houve problemas ao sincronizar as zonas de DNS com o modelo de zona DNS.%1',

    'dns__soa_rname_type_owner' => 'Endereço de e-mail do proprietário do site',
    'dns__soa_rname_type_domain' => 'Endereço de e-mail do domínio',
    'dns__soa_rname_type_external' => 'Endereço de e-mail externo',
    'dns__soa_rname_enforce_email' => 'Proíbe a alteração do endereço de e-mail RNAME por domínio',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'O endereço de e-mail da pessoa responsável pela zona DNS do domínio. Retornado pelo servidor DNS em resposta as consultas SOA.',

    'dns__dns_zone_soa_sync_title' => 'Substituir as configurações SOA de todos os domínios existentes',
    'dns__dns_zone_soa_sync_legend' => 'Necessário confirmação',
    'dns__dns_zone_soa_sync_text' => 'Atualizar os registros SOA de todos os domínios hospedados, aplicando as alterações feitas no modelo SOA?',

    'cu_db__repair_mysql_dbus' => "Repare minhas senhas de usuário do MariaDB/MySQL. Essa operação é necessária se você atualizou para o Plesk 11 a partir de versões anteriores.",

    'cu_scheduled_backup_comment' => 'Backup Agendado',
    'cu_scheduled_backup_error' => 'Ocorreu um erro durante o processo de backup. %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Ocorreu um erro durante o backup agendado.',
    'cu_scheduled_backup_mail_message' => "%1\nPonto de entrada do Plesk: %2\n\nOs seguintes erros ocorreram durante o processo de backup agendado:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Backup por hora',
    'cu_scheduled_backup_daily' => 'Fazer backup diariamente',
    'cu_scheduled_backup_weekly' => 'Backup Semanal',
    'cu_scheduled_backup_monthly' => 'Backup Mensal',
    'cu_scheduled_backup_comment_backup_all' => '%1. Toda a configuração e conteúdo.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Toda a configuração e conteúdo, exceto mensagens de e-mail.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Apenas a configuração e mensagens de e-mail.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Toda a configuração e conteúdo, exceto bancos de dados do usuário.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Toda a configuração e conteúdo, exceto arquivos do usuário.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Apenas a configuração e os bancos de dados do usuário.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Apenas a configuração e os arquivos do usuário',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Configuração de domínio.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Armazenar backups agendados em um armazenamento remoto em nuvem é um recurso premium. Entre em contato com seu provedor de hospedagem para desbloqueá-lo.',

    'i_backup_invalid_file' => 'Este não é um backup válido. Os dados não podem ser restaurados a partir desse arquivo. Clique no nome do backup para mais detalhes.',

    'filemanager_resulting_archive_exists' => 'O arquivo %1 já existe no diretório alvo.',

    'agent_unable_to_connect' => 'Impossível conectar-se com o agente no \'%2\'. Verifique se o agente está instalado e em execução, e se não existem problemas de conexão com o host \'%2\'.',
    'agent_test_connection_failed' => 'A conexão com o agente no \'%2\' falhou.',

    'agent_unable_to_resolve_host' => 'Não foi possível localizar o host remoto \'%1\'. Verificar se não existem problemas de conexão com o host.',
    'agent_unknown_curl_error' => 'Erro \'%1\' durante a conexão com o agente no \'%2\'.',
    'agent_unexpected_htp_code' => 'O código inesperado HTTP \'%1\' foi recebido na solicitação HTTP para o agente no \'%2\'.',
    'agent_unable_to_auth' => 'Não é possível autenticar no host \'%1\'. Para resolver esse problema, siga as instruções no link http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Um erro no servidor interno foi encontrado durante a execução do comando no computador remoto \'%1\'.',
    'agent_response_is_empty' => 'Uma resposta vazia foi recebida na solicitação HTTP para o agente no \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Não foi possível encontrar o Agente de Migração no cache local. Reabrir o Gerenciador de Migração para fixar o problema.',

    '__hosting_webdeploy' => "Publicação do Web Deploy",
    'cu_domain__webdeploy' => "Publicação do Web Deploy (padrão: %1)",
    'cu_dom_tpl__webdeploy' => "Publicação do Web Deploy (padrão: %1)",
    'cu_subdomain__webdeploy' => "Publicação do Web Deploy (padrão: %1)",
    'webdeploy__not_installed' => "O Microsoft Web Deploy não está instalado no servidor.",
    'webdeploy__forced_by_site_isolation' => "Não foi possível alterar as configurações de publicação do Web Deploy: Você não tem permissão para ignorar a política de segurança em todo o servidor. Entre em contato com seu provedor para obter detalhes.",



    'backup__restore_options__admin__server_configuration_license' => 'Chave de licença',
    'migration_start_migrate_server_license' => 'Transferir a chave de licença',

    'defaultcomponents__delegation_rule_not_exist' => '(a regra de delegação exigida \'appPoolPipeline, appPoolNetFx\' não existe)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'O backup foi criado pelo administrador.',
    'i_backup_created_by_reseller' => 'O backup foi criado por um revendedor.',
    'i_backup_created_by_client' => 'O backup foi criado por um cliente.',

    'migration__object_exists_on_target_host' => '(já existe no host alvo)',

    'cu_cl_pref__manage_website_maintenance' => 'Acesso a operações avançadas: Modo de copiar web site',
    'cu_cl_pref__manage_protected_dirs' => 'Gerenciamento de diretórios protegidos por senha',
    'cu_cl_pref__manage_mail_settings' => 'Capacidade de mudar configurações de e-mail',


    'cu__command_update_php_settings' => 'Atualizar configurações PHP',
    'cu__php_settings_option' => 'Caminho para o arquivo com configurações PHP',

    'cu__additional_php_settings_option' => 'Caminho para o arquivo com diretrizes PHP adicionais.',
    'cu__command_show_php_settings' => 'Exibir configurações PHP atuais',
    'cu__general_settings' => 'Configurações gerais:',
    'cu__performance_settings' => 'Configurações de desempenho:',
    'cu__php_fpm_settings' => 'Configurações PHP-FPM:',
    'cu__additional_directives' => 'Diretrizes adicionais:',

    'php_settings_permission_required' => 'Gerenciamento de configurações de PHP comuns',
    'php_settings_performance_permission_required' => 'Gerenciamento das configurações de desempenho de hospedagem',
    'php_settings_customized' => 'As configurações do PHP foram personalizadas.',
    'php_settings_synchronized_with_plan' => 'As configurações PHP devem estar sincronizadas com o plano.',
    'phosting__unknown_shell_type' => 'Shell não disponível',

    'login_up__access_denied_subscription_deleted' => 'Acesso negado: Sua assinatura foi removida.',

    'role_restricted_to_subscription' => '(transferido com a assinatura: %1)',

    'filemanager__extract' => "Extrair arquivos para: %1",

    'cu__license_command_check_installed_license' => 'Verificar a validade da chave de licença instalada (retorna o código de saída 0 se a chave é válida e 1 se ela é inválida)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Aumente a funcionalidade do Plesk para poder controlar e monitorar o servidor a partir de dispositivos móveis (BlackBerry, iPhone, e Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor ',
    'promo__mobile_monitor' => 'Obtenha as informações mais importantes sobre servidores de Plesk a qualquer momento e a qualquer lugar a partir do dispositivo móvel (BlackBerry, iPhone, e Android).',
    'promo__mobile_button' => 'Saiba mais',

    'subDomainNameHint' => 'Inserir * como um nome de subdomínio para criar um subdomínio coringa. Os visitantes do site serão redirecionados para esse subdomínio, independentemente do nome do subdomínio que eles digitarem em um navegador.',
    'subdomains__wildcard_name_invalid' => "O nome de domínio é inválido. É permitido usar somente caracteres alfanuméricos, um hífen (-) e um asterisco (*) para nomes de subdomínios coringas.",
    'subdomains__name_invalid' => "O nome de domínio é inválido. É permitido usar somente caracteres alfanuméricos, um hífen (-) para nomes de subdomínios.",

    'domain__wildcard_no_www_prefix' => 'Não é possível usar o prefixo www para subdomínios coringas.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix filtro de e-mail",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Servidor Courier POP3",
    'restart__pop3s' => "Servidor Courier POP3 com suporte SSL/TLS",
    'restart__imap' => "Servidor Courier IMAP",
    'restart__imaps' => "Servidor Courier IMAP com suporte SSL/TLS",
    'restart__authdaemon' => "Autenticação daemon Courier IMAP",
    'restart__imap-pop3' => "Servidor Dovecot IMAP e POP3",


    'addon_packages_not_supported' => 'Sub-sistemas para aplicativos APS da web empacotados não são suportados.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Não é possível atribuir automaticamente um endereço IP para o domínio. Especificar um endereço IP usando a opção -ip.',

    'plesk_key__mb_accounts' => 'Contas de usuário (revendedores e clientes) em Cliente e Gestão de Negócios',

    'actionlog__subdomain_dns' => 'Zona DNS do subdomínio',
    'actionlog__site_subdomain_dns' => 'Zona de DNS de um subdomínio sob um domínio adicional',

    // PfW only
    'actionlog__event_site_create' => 'Domínio criado',
    'actionlog__event_site_delete' => 'Domínio excluído',
    'actionlog__event_site_update' => 'Domínio atualizado',

    'actionlog__event_site_status_update' => 'Status de domínio atualizado',
    'actionlog__event_site_dns_update' => 'Zona DNS do domínio atualizada',
    'actionlog__event_site_guid_update' => 'Domínio GUID atualizado',

    'actionlog__event_site_subdomain_create' => 'Subdomínio criado',
    'actionlog__event_site_subdomain_delete' => 'Subdomínio excluído',
    'actionlog__event_site_subdomain_update' => 'Subdomínio atualizado ',

    'actionlog__event_site_alias_create' => 'Nome alternativo do domínio criado',
    'actionlog__event_site_alias_delete' => 'Nome alternativo do domínio excluído',
    'actionlog__event_site_alias_update' => 'Nome alternativo do domínio atualizado',

    'actionlog__event_site_alias_dns_update' => 'Zona de DNS de um nome alternativo do domínio atualizada',
    'actionlog__event_subdomain_dns_update' => 'Zona de DNS de um subdomínio sob o domínio padrão que foi atualizado',
    'actionlog__event_site_subdomain_dns_update' => 'Zona de DNS de um subdomínio atualizado',
    // End of PfW only

    'win_policy__bad_password' => 'Falha na validação. A senha é inválida.',
    'win_policy__password_too_short' => 'Falha na validação. A senha não atende aos requisitos de política de senha porque é muito curta.',
    'win_policy__password_too_long' => 'Falha na validação. A senha não atende aos requisitos de política de senha porque é muito longa.',
    'win_policy__password_not_complex_enough' => 'Falha na validação. A senha não é complexa o suficiente e não atende aos requisitos da política de senha. Senhas fortes devem conter pelo menos todos os seguintes itens a seguir: oito caracteres; um caractere maiúsculo ou minúsculo; três números e um caractere especial (!, @, #, $,%, ^, &, *,?, _, ~) ou um número e dois caracteres especiais.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Não foi possível atualizar a licença do produto.',


    'filemanager__error_path_is_not_allowed' => 'O caminho não é permitido',
    'filemanager__error_path_is_invalid' => 'O caminho é inválido',
    'filemanager__error_path_not_found' => 'O caminho não foi encontrado',
    'filemanager__error_path_already_exists' => 'O caminho já existe',
    'filemanager__error_access_is_denied' => 'Acesso negado',
    'filemanager__error_directory_not_empty' => 'A pasta se encontra vazia',
    'filemanager__error_sharing_violation' => 'Violação de compartilhamento',
    'filemanager__error_not_same_device' => 'O caminho de destino não é o mesmo dispositivo',
    'filemanager__unable_to_resolve_realpath' => "Não é possível encontrar o arquivo %1 no local especificado.",
    'filemanager__access_to_realpath_denied' => "Acesso ao realpath negado: %1 a %2.",
    'bt_exit' => 'Sair',

    'filemanager__copy_error__' => "Não é possível copiar %1 para %2: %3",
    'filemanager__copy_move' => "Copiar (mover) arquivos de %1",
    'filemanager__count_size__' => 'Tamanho da seleção: %1',
    'filemanager__count_size_error__' => 'Não é possível calcular tamanho para %1: %2',
    'filemanager__create_dir_error__' => "Não é possível criar diretório %1: %2",
    'filemanager__dir_not_exists' => "O diretório %1 não existe.",
    'filemanager__dirname' => "Nome do diretório",
    'filemanager__filename' => "Nome do arquivo",
    'filemanager__is_no_such' => "Não há nenhum arquivo ou diretório com nome %1",
    'filemanager__empty_selection' => "Nenhum arquivo selecionado.",
    'filemanager__move_error__' => "Não é possível mover %1 para %2: %3",
    'filemanager__not_allowed' => "Você não pode alterar permissões para esse arquivo.",
    'filemanager__remove' => "Remover arquivos de %1",
    'filemanager__remove_error__' => "Não é possível remover arquivo %1: %2",
    'filemanager__set_win_permissions_dir' => "Definir permissões para a pasta %1",
    'filemanager__set_win_permissions_file' => "Definir permissões para o arquivo %1",
    'filemanager__touch_confirm' => "Tem certeza de que deseja alterar a marcação de data/hora dos arquivos selecionados?",
    'filemanager__upload_error__' => "Não é possível fazer o upload de %1 para %2: %3",
    'filemanager__upload_file' => "Carregar arquivo",
    'filemanager__upload_file_src' => "Caminho para arquivo",
    'filemanager__max_image_size_exceeded' => 'Não é possível exibir a imagem. O tamanho da imagem não pode ser superior a %2 bytes',

    '__fastcgi_unix_support' => 'Suporte FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Os registros DNS deste subdomínio estão armazenados na zona DNS pai. Modifique a zona pai de %1 ou crie uma zona separada para o subdomínio.',
    'dns__subdomain_dns_zone_parent_link' => 'aqui',
    'dns__no_dns_zone' => 'Nenhuma zona DNS foi atribuída com domínio. Para gerenciar a zona DNS para o seu domínio, você deve pressionar o botão \'Restore Defaults\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Não é possível ativar a zona do subdomínio, porque existe um registro CNAME para esse subdomínio na zona de seu domínio pai.',

    '__hosting_write_modify' => 'Permissões adicionais de gravação/modificação',

    'aspdotnet__group_framework_version' => "Versão do framework",

    'bt_restore_default' => "Definir como padrão",
    'b_autoinstaller' => 'Atualizar o Plesk ou seus componentes.',
    'b_autoinstaller_configure' => 'Atualizar configurações.',
    'b_autoinstaller_install' => 'Instalar os componentes selecionados.',

    '__iis_app_pool__use_dedicated' => 'Pool de aplicativos IIS dedicado',
    '__iis_app_pool__use_dedicated_addons' => 'Pool do aplicativo IIS dedicado para cada website',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Ativar aplicativos de 32 bits',
    '__iis_app_pool__load_user_profile' => 'Carregar o perfil do usuário',
    'bt_iis_app_pool' => "Pool de Aplicativos IIS",

    'performance__cpu_usage' => 'Utilização de CPU máxima (%)',
    'performance__cpu_usage_action' => 'Limite de ação',
    'performance__cpu_usage_interval' => 'Limite do intervalo (minutos)',
    'performance__cpu_usage_action_not_supported' => 'A ação especificada não é suportada pelo servidor web.',

    'performance__idle_timeout_action_not_supported' => 'A ação do tempo limite de ociosidade especificado não é suportada pelo servidor web.',
    'performance__max_worker_processes' => 'Número máximo de processos de trabalho',
    'performance__idle_timeout' => 'Tempo limite de ociosidade (minutos)',
    'performance__idle_timeout_action' => 'Ação do tempo limite de ociososidade',
    'performance__recycling_by_time' => 'Reciclando em intervalos de tempo regulares (minutos)',
    'performance__recycling_by_requests' => 'Reciclando quando o número máximo de solicitações for atingido',
    'performance__recycling_by_virtual_memory' => 'Reciclando quando a quantidade máxima de memória virtual é utilizada',
    'performance__recycling_by_private_memory' => 'Reciclando quando a quantidade máxima de memória privada é utilizada',
    'performance__managed_pipeline_mode' => 'Modo pipeline gerenciado',
    'performance__managed_pipeline_mode_not_supported' => 'O modo especificado não é suportado pelo servidor da web.',

    'iis_app_pool' => 'Gerenciamento do Pool de aplicativos IIS.',
    'b_iis_app_pool' => 'Gerenciar o pool de aplicativos IIS.',
    'iis_app_pool_cl_dom' => 'Gerenciamento do Pool de aplicativos IIS.',

    'bt_protect' => 'Proteger',
    'bt_unprotect' => 'Remover a proteção',
    'bt_show_additional_users' => 'Exibir mais usuários',
    'bt_hide_additional_users' => 'Exibir menos usuários',
    'error_doc__code_400' => 'Solicitação incorreta',
    'error_doc__code_401' => 'Não autorizado',
    'error_doc__code_401.1' => 'Não autorizado - falha no login',
    'error_doc__code_401.2' => 'Não autorizado - falha no login devido à configuração do servidor',
    'error_doc__code_401.3' => 'Não autorizado - não autorizado devido ao ACL no recurso',
    'error_doc__code_401.4' => 'Não autorizado - falha na autorização pelo filtro',
    'error_doc__code_401.5' => 'Não autorizado - falha na autorização pelo aplicativo ISAPI/CGI',
    'error_doc__code_401.7' => 'Não autorizado - negado devido à política de autorização de URL',
    'error_doc__code_403' => 'Proibido',
    'error_doc__code_403.1' => 'Proibido - acesso de execução negado',
    'error_doc__code_403.2' => 'Proibido - acesso de leitura negado',
    'error_doc__code_403.3' => 'Proibido - acesso de escrita negado',
    'error_doc__code_403.4' => 'Proibido - SSL exigido',
    'error_doc__code_403.5' => 'Proibido - SSL 128 exigido',
    'error_doc__code_403.6' => 'Proibido - endereço de IP rejeitado',
    'error_doc__code_403.7' => 'Proibido - certificado de cliente exigido',
    'error_doc__code_403.8' => 'Proibido - acesso ao site negado',
    'error_doc__code_403.9' => 'Proibido - demasiados usuários',
    'error_doc__code_403.10' => 'Proibido - configuração inválida',
    'error_doc__code_403.11' => 'Proibido - alteração de senha',
    'error_doc__code_403.12' => 'Proibido - acesso de mapeador negado',
    'error_doc__code_403.13' => 'Proibido- certificado de cliente revogado',
    'error_doc__code_403.14' => 'Proibido- listagem de diretórios negada',
    'error_doc__code_403.15' => 'Proibido - licenças de acesso de cliente excedidas',
    'error_doc__code_403.16' => 'Proibido - certificado de cliente não confiável ou incorreto',
    'error_doc__code_403.17' => 'Proibido- o certificado de cliente expirou ou ainda não é válido',
    'error_doc__code_403.18' => 'Proibido - não é possível executar a solicitação a partir do pool de aplicativos',
    'error_doc__code_403.19' => 'Proibido - acesso de CGI negado',
    'error_doc__code_403.20' => 'Proibido - falha no login de passaporte',
    'error_doc__code_404' => 'Não encontrado',
    'error_doc__code_404.2' => 'Não encontrado - negado devido à política de bloqueio',
    'error_doc__code_404.3' => 'Não encontrado - negado devido à política de MIMEMAP',
    'error_doc__code_405' => 'Método não permitido',
    'error_doc__code_406' => 'Não aceitável',
    'error_doc__code_407' => 'Autenticação de proxy exigida',
    'error_doc__code_408' => 'Tempo limite da solicitação',
    'error_doc__code_412' => 'Falha de pré-condição',
    'error_doc__code_414' => 'URL de pedido longa demais',
    'error_doc__code_415' => 'Tipo de mídia não suportado',
    'error_doc__code_431' => 'Campos de cabeçalho de solicitação muito grandes',
    'error_doc__code_500' => 'Erro de servidor interno',
    'error_doc__code_500.12' => 'Erro de servidor interno - reinício de aplicação',
    'error_doc__code_500.13' => 'Erro de servidor interno - servidor ocupado demais',
    'error_doc__code_500.15' => 'Erro de servidor interno - proíbem-se solicitações diretas para o GLOBAL.ASA',
    'error_doc__code_500.16' => 'Erro de servidor interno - erro de acesso de UNC',
    'error_doc__code_500.17' => 'Erro de servidor interno - armazenamento de autorização de URL não encontrado',
    'error_doc__code_500.18' => 'Erro de servidor interno - armazenamento de autorização de URL não aberto',
    'error_doc__code_500.19' => 'Erro de servidor interno - metadados de arquivo incorreto',
    'error_doc__code_500.100' => 'Erro de servidor interno - erro de ASP',
    'error_doc__code_501' => 'Não implementado',
    'error_doc__code_502' => 'Gateway incorreto',
    'error_doc__code_503' => 'O serviço está temporariamente indisponível',

    'mimetype_edit__already_exists' => 'O tipo de MIME já está definido para esta extensão.',
    'mimetype_edit__not_exists' => 'O tipo MIME não existe.',

    'php__group_php_version' => "Versão do PHP",

    'virtualdir__path' => 'Atalho',
    'virtualdir__read' => 'Permissão de leitura',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Permissão de gravação',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Acesso à fonte do script',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Pesquisa no diretório',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Executar permissões',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Visitas de log',
    'virtualdir__app_create' => 'Criar aplicativo',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Aciona autenticação anônima.',
    'virtualdir__auth_windows' => 'Aciona autenticação do Windows.',
    'virtualdir__auth_not_enabled' => 'Autenticação anônima ou do Windows deve ser acionada.',
    'virtualdir__require_ssl' => 'Exigir SSL/TLS',
    'virtualdir__enable_default_doc' => 'Usar documentos-padrão',
    'virtualdir__default_doc' => 'Ordem de busca de documentos-padrão',
    'virtualdir__enable_parent_paths' => 'Permitir uso de caminhos pai',
    'virtualdir__execute_in_mta' => 'Permitir a execução de aplicativos em modo MTA (compartimento com vários segmentos)',
    'virtualdir_create__title' => 'Criar o diretório virtual em %1',
    'virtualdir_edit__title' => 'Propriedades do diretório virtual %1',
    'virtualdir_edit__legend' => 'Diretório virtual',
    'virtualdir_edit__application_legend' => 'Configurações do aplicativo',
    'virtualdir_edit__security_legend' => 'Segurança de diretório',
    'virtualdir_edit__documents_legend' => 'Documentos',
    'virtualdir_edit__list_legend' => 'Diretórios virtuais aninhados',
    'virtualdir_error__path_not_in__' => 'Caminho inválido especificado',
    'virtualdir_root' => 'Diretórios virtuais',
    'virtualdir_root__title' => 'Diretórios virtuais',
    'virtualdir_root__list_legend' => 'Diretórios virtuais',
    'virtualdir_se__none' => 'Nenhum',
    'virtualdir_se__script' => 'Somente scripts',
    'virtualdir_se__script_execute' => 'Scripts e executáveis',
    'virtualdirs__title' => 'Diretórios virtuais',
    'virtualdirs__path_not_exists' => 'Caminho inválido.',
    'virtualdirs__select_for_remove' => "Selecione os diretórios virtuais a serem removidos",
    'virtualdirs_remove__title' => 'Remover os diretórios virtuais',

    'asp_max_buffer_text' => 'Tamanho máximo do buffer (KB) do ASP',
    'asp_max_body_text' => 'Tamanho máximo do corpo da entidade de uma solicitação (KB) do ASP',
    'asp_buffers_legend' => 'Configurações do ASP',
    'asp_client_debug_text' => 'Habilitar a depuração de script ASP do lado do cliente',
    'asp_server_debug_text' => 'Habilitar a depuração de script ASP do lado do servidor',

    'permissions__group_or_user_name' => 'Nomes de usuário ou grupo',
    'permissions__FullControl' => 'Controle total',
    'permissions__Modify' => 'Modificar',
    'permissions__ReadAndExecute' => 'Ler e executar',
    'permissions__ListFolderContents' => 'Listar conteúdos da pasta',
    'permissions__Read' => 'Ler',
    'permissions__Write' => 'Gravar',
    'permissions__ReadControl' => 'Controle de leitura',
    'permissions__WriteControl' => 'Controle de gravação',
    'permissions__ExecuteControl' => 'Executar controle',
    'permissions__TraverseFolderOrExecuteFile' => 'Desviar pasta / Executar arquivo',
    'permissions__ListFolderOrRead' => 'Listar pasta / Ler dados',
    'permissions__CreateFilesOrWrite' => 'Criar Arquivos / Gravar Dados',
    'permissions__CreateFoldersOrAppend' => 'Criar pastas / Acrescentar dados',
    'permissions__DeleteSubfoldersandFiles' => 'Excluir subpastas e arquivos',
    'permissions__Delete' => 'Remover',
    'permissions__ChangePermissions' => 'Alterar Permissões',
    'permissions__TakeOwnership' => 'Apropriar-se',
    'permissions__inherited_from' => 'Herdados de',
    'permissions__not_inherited' => '<não herdado>',
    'permissions__apply_to' => 'Aplicar a',
    'permissions__apply_onto' => 'Aplicar a:',
    'permissions__apply_onto1' => 'Somente esta pasta',
    'permissions__apply_onto2' => 'Somente subpastas',
    'permissions__apply_onto3' => 'Esta pasta e subpastas',
    'permissions__apply_onto4' => 'Somente arquivos',
    'permissions__apply_onto5' => 'Esta pasta e arquivos',
    'permissions__apply_onto6' => 'Somente subpasta e arquivos',
    'permissions__apply_onto7' => 'Esta pasta, subpastas e arquivos',

    'filemanager__not_allowed_dir' => "Você não tem autorização para alterar as permissões desta pasta.",

    'filemanager__allow' => "Permitir",
    'filemanager__deny' => "Negar",
    'filemanager__user_domusr' => 'Administrador do website',
    'filemanager__user_webusr' => 'Usuário web',
    'filemanager__user_admins' => 'Administradores',
    'filemanager__user_system' => 'SISTEMA',
    'filemanager__user_aspnet' => 'Usuário ASP.NET',
    'filemanager__user_poolusr' => 'Usuário do pool de aplicativos',
    'filemanager__user_sysaccount' => 'Usuário do sistema adicional',

    'bt_permissions_advanced' => 'Avançado',
    'b_permissions_advanced' => 'Clicar para visualizar as permissões especiais.',

    'hotlink-protection_invalid_friend_domain' => 'Nome inválido para domínio amigável.',
    'hotlink-protection_duplicate_friend_domain' => 'Nome duplicado para domínio amigável.',
    'hotlink-protection_invalid_extensions' => 'As extensões de arquivo contêm caracteres impróprios.',

    'i_domain_alias_status_on' => 'O nome alternativo de domínio está habilitado.',
    'i_domain_alias_status_off' => 'O nome alternativo de domínio está desabilitado.',
    'i_domain_alias_status_with_parent' => 'O nome alternativo de domínio está desabilitado porque o domínio está desativado.',
    'i_domain_alias_turn_off' => 'Clicar para desabilitar.',
    'i_domain_alias_turn_on' => 'Clicar para habilitar.',

    'domain_alias__control_title' => 'Nome alternativo do domínio %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nome do serviço',
    'domain_alias__control_details_title' => 'Detalhes',

    'domain_alias__invalid_values' => 'O nome do domínio especificado não é válido. Os nomes de domínio pode comprometer letras, dígitos e hífens. Cada parte do nome de domínio entre os pontos não deve ter mais de 63 símbolos.',
    'domain_alias__domain_already_exists' => "O nome incorreto do alias do domínio %1. O domínio %1 já existe.",
    'domain_alias__www_prefix_domain_already_exists' => "Nome incorreto do alias de domínio www.%1. Este alias já foi criado para o domínio %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nome incorreto do alias de domínio webmail.%1. Este alias já foi criado para o domínio %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nome incorreto do alias de domínio lists.%1. Este alias já foi criado para o domínio %1.',
    'domain_alias__dns_record_already_exists' => 'Impossível configurar o alias %1 de domínio, pois um registro do DNS apontando para o host %1 já existe.',
    'domain_alias__domain_alias_already_exists' => "O alias de domínio com esse nome já existe.",
    'domain_aliases__mail_server_not_support_aliases' => 'O servidor de e-mail não suporta o recurso de nomes alternativos do domínio. Os nomes alternativos do domínio podem não funcionar corretamente.',
    'domain_alias__restrict_domain_creation' => 'O nome alternativo de domínio especificado é proibido pela política de todo o servidor. Entre em contato com seu provedor de hospedagem, se este nome alternativo de domínio lhe pertencer.',
    'domain_alias__restrict_creation_with_www' => 'Insira o nome de um domínio sem o prefixo \'www\'. O prefixo www para o domínio será automaticamente adicionado à configuração do servidor da web.',
    'domain_unable_to_set_name' => 'Nome incorreto %1.',

    'domain_alias__domain_service_dns_disabled' => 'Este domínio é servido por outro servidor do DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Este servidor DNS atua como nome de servidor primário para esta zona DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Este servidor DNS atua como nome de servidor secundário para esta zona DNS.',
    'domain_alias__domain_service_mail_enabled' => 'O serviço de e-mail está ativado para o domínio.',
    'domain_alias__domain_service_mail_disabled' => 'O serviço de e-mail está desativado para o domínio.',
    'domain_alias__domain_service_mail_mx' => '%1 é utilizado como servidor de e-mail.',

    'domain_alias__service_seoRedirect_hint' => 'Quando os visitantes abrirem a URL alias, eles serão direcionados para a URL de domínio primário. O Plesk usa o redirecionamento HTTP 301 fácil de usar do mecanismo de busca, o que significa que a classificação do mecanismo de busca não será dividido entre as URLs.',

    'bt_task_run_now' => 'Executar agora',
    'ftp__read_perm' => "Permissão de leitura",
    'ftp__write_perm' => "Permissão de gravação",

    'filemanager__upload_backup_file_hint' => 'Aqui você pode fazer o upload de arquivos de backup para armazenamento do Plesk. O tamanho máximo do arquivo é limitado a dois gigabytes.',

    '__default_for_mssql' => 'padrão para MS SQL',

    '__login_does_not_pass_validation' => "O nome de usuário é inválido. Certifique-se de que atenda os seguintes requisitos: %1",
    '__login_allowed_symbols' => 'Apenas caracteres alfanuméricos incluindo períodos, travessões e sublinhados são permitidos. O primeiro caractere deve ser alfanumérico.',

    'restart__nginx' => 'Servidor de Proxy reverso (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Gostaria de receber informações gerais do produto e anúncios do Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Gostaria de receber informações relacionadas à segurança e outras notificações técnicas do Plesk.",

    '__login_status_inactive' => 'Sua conta está inativa. Entre em contato com o administrador do Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Retorne à página de Ferramentas e Configurações. A migração continuará em segundo plano.',

    'chk_js__warning_about_ftp_login_syntax' => "Você pode usar símbolos alfanuméricos, traço e sublinhado no nome do usuário.",
    'chk_js__warning_about_passwd_syntax' => "Não use aspas, espaço e caracteres do alfabeto nacional em uma senha.\nA senha deve estar entre %1 e %2 caracteres de comprimento e não deve conter o nome de usuário.",
    'chk_js__warning_about_plesk_login_syntax' => "Você pode usar símbolos alfanuméricos, traço, ponto, sublinhado e minúsculas no nome do usuário.",
    'chk_js__warning_about_admin_passwd_syntax' => "Não utilize aspas, espaço, ponto e vírgula e caracteres de alfabetos nacionais em um senha.\nA senha deve ter entre %1 e %2 caracteres de extensão e não deve conter o nome de usuário.",

    'cmd_server__admin_alias_not_found' => "Impossível localizar a conta de administrador adicional.",

    'panel_branding__skins_already_exists' => "Observação: A aparência '%1' já existe. Será substituída com a aparência que você está instalando atualmente.",
    'panel_branding__skins_file_exists' => "Não é possível criar um diretório para o tema '%1': Um arquivo com este nome já existe.",

    'actionlog__login_failed' => 'falha em efetuar login',
    'actionlog__event_cp_user_login_failed' => 'O usuário de Plesk falhou em efetuar login',
    'actionlog__api_login_failed' => 'falha em efetuar login por meio de API',
    'actionlog__event_cp_user_api_login_failed' => 'O usuário de Plesk falhou em efetuar login por meio de API',
    'actionlog__pw_reset' => 'solicitou redefinição de senha',
    'actionlog__pw_admin_force_reset' => 'solicitou redefinição forçada de senha do administrador',

    'ch_pass_admin__email_subject' => "Sua solicitação de redefinição de senha do Plesk",
    'ch_pass_admin__email_body' => "Olá, %1.\n\nA senha do administrador não pode ser enviada por e-mail por motivos de segurança.\n\nPara fazer login como 'admin', use o comando 'plesk login'.\n\nPara definir uma nova senha 'admin', use o comando 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Não foi possível enviar o e-mail: %1',

    'ch_pass_by_secret__email_subject' => "Redefinir sua senha do Plesk?",
    'ch_pass_by_secret__email_body' => "Olá %2,\n\nSe você solicitou uma redefinição de senha, siga este link para definir uma nova senha: %1\n\nSeu login: %3",
    'ch_pass_by_secret__message_send_error' => 'Não é possível enviar o código secreto: %1',
    'ch_pass_by_secret__title' => 'Alterar Sua Senha',
    'ch_pass_by_secret__secret' => 'Código secreto',

    'custom_button__noframe' => "Não use quadros",

    'custom_button__internal_hint' => 'O URL será aberto na mesma janela de navegador do Plesk.',
    'custom_button__noframe_hint' => 'Se você adicionar um botão personalizado que leva a um serviço (como um aplicativo ou módulo do Plesk) no Painel do Cliente, pode especificar como esse serviço deve ser apresentado: em um quatro ou parte de um Plesk GUI.',


    'actionlog__patch' => 'Atualizar',
    'actionlog__patch_available' => 'disponível',
    'actionlog__event_patch_available' => 'Atualização disponível',
    'actionlog__patch_installed' => 'instalado',
    'actionlog__event_patch_installed' => 'Atualização instalada',

    'actionlog__extension' => 'Extensão',
    'actionlog__extension_status' => 'Status da extensão',
    'actionlog__cloning' => 'Clonagem de servidor',
    'actionlog__cloning_complete' => 'concluído',
    'actionlog__event_cloning_complete' => 'Clonagem de servidor concluída',

    'actionlog__ssl_web_binding' => 'Certificado SSL/TLS no domínio',
    'actionlog__ssl_web_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_web_binding_update' => 'Certificado SSL/TLS no domínio atribuído/não atribuído',

    'actionlog__ssl_web_mail_binding' => 'Certificado SSL/TLS no webmail',
    'actionlog__ssl_web_mail_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificado SSL/TLS no webmail atribuído/não atribuído',

    'actionlog__ssl_mail_binding' => 'Certificado SSL/TLS no servidor de correio',
    'actionlog__ssl_mail_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_mail_binding_update' => 'Certificado SSL/TLS no servidor de correio atribuído/não atribuído',

    'actionlog__ssl_panel_binding' => 'Certificado SSL/TLS no Plesk',
    'actionlog__ssl_panel_binding_update' => 'atribuído/não atribuído',
    'actionlog__event_ssl_panel_binding_update' => 'Certificado SSL/TLS no Plesk atribuído/não atribuído',

    'actionlog__hostname' => 'Nome de host do servidor',
    'actionlog__hostname_changed' => 'alteradas',

    'actionlog__smb_user' => 'Usuário adicional',
    'actionlog__smb_user_create' => 'Usuário adicional criado',
    'actionlog__smb_user_delete' => 'Usuário adicional excluído',
    'actionlog__smb_user_update' => 'Usuário adicional atualizado',

    'actionlog__event_mail_management_status_update' => 'Atualização de status de gerenciamento de e-mail',
    'actionlog__mail_management' => 'Status de gerenciamento de e-mail',
    'actionlog__mail_management_status_update' => 'atualizado',

    'virtualization_openvz' => 'OpenVZ',

    'passwordSecurityLevelCheckFailed' => 'Sua senha não é complexa o suficiente. De acordo com a política do servidor, a força mínima da senha é %1. Para melhorar a força da senha, utilize números, caracteres maiúsculos e minúsculos e caracteres especiais como !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Muito fraca',
    'passwordSecurityLevelCheckFailedWeak' => 'Fraca',
    'passwordSecurityLevelCheckFailedMediocre' => 'Média',
    'passwordSecurityLevelCheckFailedStrong' => 'Forte',
    'passwordSecurityLevelCheckFailedStronger' => 'Muito forte',

    'dns__dns_default_ipv4_modified' => 'Os registros com este endereço de IP serão considerados como um usuário modificado e não sincronizará com o modelo DNS no tamanho do servidor.',
    'dns__dns_default_ipv6_modified' => 'Os registros com este endereço de IP serão considerados como um usuário modificado e não sincronizará com o modelo DNS no tamanho do servidor.',

    'dns__view_dns_record_master_title' => 'Visualizando os Registros de recursos',
    'dns__view_dns_record_off_title' => 'Visualizando os Registros de servidor de nomes',
    'dns__view_dns_record_slave_title' => 'Visualizando os Principais Registros do Servidor DNS',

    'dns_unable_to_resolve_hostname' => "Não foi possível solucionar o nome do host \"%1\": %2\nCertifique-se de que o solucionador DNS do sistema operacional está configurado e funcionando corretamente.",

    'no_database_server_available' => 'Não há servidores de banco de dados disponível para esta assinatura.',

    'database_used_by_application_can_not_be_moved' => 'Impossível mover para a base de dados: Um aplicativo do website utiliza esta base de dados.',
    'database_user_update_orphaned_is_restricted' => 'A atualização das contas do usuário órfão de banco de dados é proibida. É possível apenas excluí-las ou repará-las.',

    'database_unable_to_get_max_filesize_default_message' => 'Impossível determinar o tamanho máximo do arquivo de banco de dados: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Impossível estabelecer o tamanho máximo do arquivo de banco de dados: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Impossível determinar o tamanho máximo do arquivo de log de banco de dados: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Impossível estabelecer o tamanho máximo do arquivo de log de banco de dados: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Impossível determinar o limite existente do tamanho do arquivo de banco de dados\'%1\' do Microsoft SQL. Impossível estabelecer um novo limite.',
    'database_unable_to_set_max_filesize' => 'Impossível estabelecer o limite para o tamanho do arquivo do banco de dados Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Impossível determinar o limite existente do tamanho do arquivo de log de banco de dados\'%1\' do Microsoft SQL. Impossível estabelecer um novo limite.',
    'database_unable_to_set_max_log_filesize' => 'Impossível estabelecer o limite para o tamanho do arquivo de log do banco de dados Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Impossível criar um banco de dados \'%1\' do Microsoft SQL: O tamanho do seu arquivo excede o tamanho máximo permitido.',
    'database_unable_to_move_because_max_filesize' => 'Impossível mover um banco de dados \'%1\' do Microsoft SQL: O tamanho do seu arquivo excede o tamanho máximo permitido %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Impossível criar um banco de dados \'%1\' do Microsoft SQL: O tamanho do seu arquivo de log excede o tamanho máximo permitido.',
    'database_unable_to_move_because_max_log_filesize' => 'Impossível mover um banco de dados \'%1\' do Microsoft SQL: O tamanho do seu arquivo de log excede o tamanho máximo permitido %2.',
    'database_unable_to_restore_because_max_filesize' => 'Impossível restaurar um banco de dados \'%1\' do Microsoft SQL: O tamanho do seu arquivo excede o tamanho máximo permitido.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Um servidor MS SQL idêntico já está registrada no Plesk. Especifique outro servidor MS SQL como uma área restrita.',
    'database_server__mssql_server_registered_as_sandbox' => 'Uma área restrita idêntica ao servidor MS SQL já está registrada no Plesk. Especifique outro servidor MS SQL como uma área restrita.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Incapaz de conectar ao servidor via \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'O recurso %1 não é suportado pelos seguintes nós de serviço: %2. Este recurso será desativado para todos os objetos criados nesses nós.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'O recurso %1 não é suportado por este servidor. Este recurso será desativado para todos os objetos restaurados.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'O componente %1 não é instalado. Ficará indisponível para os sites a seguir: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'O componente %1 não é instalado. Será substituído por %2 os seguintes sites: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'A versão atual do Plesk não suporta nomes de usuário com o caractere ponto (. ). Os clientes e os revendedores com tais nomes de usuário não serão restaurados.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Impossível localizar um arquivo de backup com os dados para o %1 %2. Os dados para o %1 %2 não serão restaurados.',

    'bu_conflict_resolver_zone_master_removed' => "Não é possível restaurar o registro DNS primário: O registro na zona secundária aponta para o endereço IP existente %1. O registro DNS primário será removido da zona secundária.",
    'bu_conflict_resolver_dns_not_supported_https' => 'O suporte para registros DNS HTTPS está desativado. Os registros HTTPS não serão restaurados para os seguintes domínios: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 não é suportado.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 não é suportado. Ficará indisponível para os sites a seguir: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'O componente %1 não é instalado.',
    'bu_conflict_resolver_disabled_in_multi_server' => ' Ficará indisponível para os nós de serviço a seguir: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => ' Ficará indisponível para os objetos a seguir: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Os seguintes servidores de base de dados não estão disponíveis neste servidor: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'O gerenciamento do smarthost não é suportado. As configurações do smarthost não serão restauradas.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'O arquivo de backup da base de dados MS SQL é armazenado em formato nativo, que apenas pode ser restaurado para o servidor MS SQL local ou para o servidor MS SQL remoto com configurações de backup completamente configuradas. Algumas de suas bases de dados não foram restauradas porque não há servidor MS SQL apropriado registrado no Plesk. Os seguintes domínios foram afetados: {{objects}}. Entre em contato com o seu provedor de hospedagem.',

    'bu_conflict_resolver_not_available_webmail' => 'O serviço do webmail %1 não está disponível.Será substituído por %2 os seguintes objetos: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'O serviço do webmail %1 não está disponível.Será substituído por %2 os seguintes planos de serviço: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Os bancos de dados do tipo '%1' não suportam nomes de usuário que coincidam com nomes de banco de dados.O usuário '%2' será renomeado '%3' para o banco de dados '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'O limite de espaço em disco não está definido na configuração do servidor de destino. O valor dessa definição será alterado para "Unlimited" (ilimitado).',
    'bu_conflict_resolver_wrong_max_connections_value' => 'O limite do número de conexões não está definido na configuração do servidor de destino. O valor dessa definição será alterado para "Unlimited" (ilimitado).',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'O limite do uso de tráfego não está definido na configuração do servidor de destino. O valor dessa definição será alterado para "Unlimited" (ilimitado).',
    'cu__pleskrestore_backup_file_extracted' => 'O arquivo de backup foi extraído para "%1".',
    '__mod_bw_not_supported' => 'O módulo mod_bw para o servidor web Apache não é suportado devido à configuração do sistema de arquivos. Os limites de uso de tráfego e o número máximo de conexões não funcionarão.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'A autorização POP3 para retransmissão de e-mail não é suportada; em vez disso o POP3 antes da autorização SMTP será usado. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Plano de serviços \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 não é suportado. Será substituído por %2 os seguintes planos de serviço: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 não é suportado. Será substituído por %2 os seguintes sites: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Os seguintes objetos não foram encontrados no arquivo de backup: %1',
    'bu_conflict_resolver_absent_domains' => 'Alguns objetos não podem ser restaurados, por pertencerem aos seguintes domínios e que não foram encontrados no Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Alguns sites não podem ser restaurados, por pertencerem aos seguintes domínios pais e que não foram encontrados no Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Não é possível restaurar as zonas de DNS: O serviço de DNS está desativado na configuração do servidor.',
    'bu_conflict_resolver_mail_not_supported' => 'Não é possível restaurar as caixas postais: O serviço de e-mail está desativado na configuração do servidor.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'A ação de limite de CPU especificada não é suportada pelo servidor IIS. O valor será reinicializado para %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Certificado de servidor SSL/TLS %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificado SSL/TLS %2 do domínio %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificado SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'O conteúdo dos seguintes objetos não podem ser restaurados, pois não foram encontrados no Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'O conteúdo das seguintes caixas postais não podem ser restaurados, pois não foram encontradas no Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'O conteúdo das seguintes malas diretas não podem ser restaurados, pois não foram encontradas no Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'O conteúdo dos seguintes bancos de dados não podem ser restaurados, pois não foram encontrados no Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'A restauração da aplicação "%1" em "%2" falhou porque outro aplicativo já está instalado para "%3". Você pode remover o aplicativo instalado e tentar novamente.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'A função de e-mail de auto resposta não é suportada.',
    'bu_conflict_resolver_not_available_mail_content' => 'A restauração do conteúdo do e-mail não é suportada.',
    'bu_conflict_resolver_invalid_mail_name' => 'As seguintes caixas de e-mails não foram restauradas porque o subendereço de e-mail está habilitado e certos endereços de e-mail contêm sinal "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Os seguintes usuários não foram restaurados porque o subendereço de e-mail está habilitado e certos endereços de e-mail contêm sinal "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'As seguintes licenças expiraram e não serão restauradas: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'As seguintes licenças não são válidas ou expiraram e não serão restauradas: {{objects}}',
    'expiration_unsupported' => "O limite 'expiration' não é suportado.",

    'component_name__dbconnector' => "Conector do Banco de Dados",
    'component_name__mysqlserver' => 'Servidor MariaDB/MySQL',
    'component_name__troubleshooting' => 'Resolução de problemas',
    'component_name__savi' => 'Interface Antivírus Sophos',

    '__subscription_has_no_license_key' => 'Os recursos de assinatura são fornecidos pelo nó de serviço #%1, o qual não possui uma chave de licença associada.',
    '__subscription_has_expired_license_key' => 'Os recursos de assinatura são fornecidos pelo nó de serviço #%1 cuja chave de licença %2 expirou.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Não foi possível salvar os arquivos de configuração',
    '__cfgmonConfigurationFileSaveErrorBody' => "Não foi possível salvar alguns arquivos de configuração no host <%%host%%>: Ocorreram os seguintes erros:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Esta opção permite configurar endereços de e-mail no estilo VERP para listas de e-mail',
    'mail__enter_right_ip_mask' => "Digite a máscara IP entre 1 e 32",
    'mail__enter_right_ip_mask_24' => "Digite a máscara IP entre 24 e 32",
    'mail__invalid_dom_name' => "O nome de domínio %1 é inválido.",
    'mail__invalid_pop_lock_time' => "O tempo de bloqueio de POP3 é inválido.",
    'mail__invalid_rbl_server' => "O nome da zona DNS é inválido.",
    'mail__total_files_size' => "Tamanho total do repositório: %1",
    'mail__filename_already_in_repository' => "Um arquivo com o mesmo nome já está no repositório",
    'mail__no_white_list_mask_feature_24' => "Use um valor de máscara de 24 ou superior. Seu servidor de e-mail não suporta configuração de máscaras. Nós podemos apenas emular configuração de máscara para valores não menores do que 24.",
    'mail__unable_add_new_mail_name' => "Não foi possível adicionar a conta de e-mail: %1",
    'mail_server_is_not_installed' => 'O servidor do e-mail (Postfix ou Qmail) não está instalado. Instale-o para continuar funcionando.',
    'mail_server_not_available' => 'Não há servidores de e-mail suportados disponíveis no nó de serviço.',
    '__not_installed' => '(não instalado)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Filtragem de spam nas mensagens de e-mail de saída está desabilitado.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'O nó do serviço não suporta limitar o número de mensagens de e-mail de saída de um domínio para o domínio %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'O nó do serviço não suporta limitar o número de mensagens de e-mail de saída de uma caixa postal para o domínio %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Especificar pelo menos um tipo de endereço (IPv4 ou IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Um modo de e-mail de saída inválido foi especificado.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Um endereço IPv4 inválido foi especificado.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Um endereço IPv6 inválido foi especificado.',
    'mail__outgoing_email_mode_unavailable' => 'Não é possível a alteração do modo de envio de mensagens, provavelmente porque o servidor de correio do Postfix não está instalado neste servidor.',

    'mail__autoresponder_attachment_not_supported' => 'O servidor de e-mail usado atualmente não suporta gerenciamento de anexos autoresponder.',

    'mail__smtp_white_list_not_supported' => 'O servidor de e-mail usado atualmente não oferece suporte à lista de permissões de endereços IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'As máscaras CIDR não são suportadas pelo servidor de correio selecionado no momento. Especifique o endereço IP no formato \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Os padrões de IP coringa não são suportados pelo servidor de e-mail selecionado no momento. Especifique o endereço IP no formato \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Não é possível alterar as configurações para o serviço de verificação DKIM',

    'sfdk_domain__serverwide_disabled' => 'Desativado de acordo com a política do servidor',
    'feature__domainkeys__serverwide_disabled' => 'A proteção contra spam DKIM do lado do servidor está desligada',

    'defaultcomponents__error_set_default' => 'Não foi possível configurar %1 como o padrão %2',
    'defaultcomponents__error_set_default_none' => 'Não é possível definir "nenhum" como o componente padrão para %1',
    'defaultcomponents__required_package_not_default' => 'O componente %1 requerido para este trabalho não é padrão.',

    '__percentage' => '%',
    '__seconds' => 'Segundos',
    '__resource_remain' => 'Restante',

    '__not_registered' => '(não registrado)',
    '__php_handler_id' => 'Versão do PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'O PHP handler "%1" não é registrado. Provavelmente foi apagado do servidor. Registre um handler com as mesmas propriedades e tente novamente.',
    '__php_handler_not_registered_on_domain' => 'Domínio "%1": O PHP handler "%2" não é registrado. Provavelmente foi apagado do servidor. Registre um handler com as mesmas propriedades e tente novamente.',
    '__php_fpm_handler' => 'Aplicativo FPM',
    '__php_fpm-dedicated_handler' => 'Aplicativo FPM dedicado',

    'mailname_create_assigned_user_dublicate_error' => 'Não foi possível criar um usuário para a caixa de e-mail. O usuário com o nome de usuário %1 já existe e tem outra caixa de e-mail.',
    'mailname_create_assigned_user_role_absent_error' => 'Não foi possível criar um usuário para a caixa de e-mail. O papel-padrão %1 do usuário não existe.',

    'gphd__mime_types' => 'Tipos de MIME',
    'gphd__handlers' => 'Handlers Apache',
    'gphd__ip_restrictions_allow' => 'Permitir o acesso ao site para hosts e redes especificados (excluindo os negados)',
    'gphd__ip_restrictions_deny' => 'Negar o acesso ao site para redes e hosts especificados',
    'gphd__directory_index' => 'Arquivos de índice',
    'gphd__nginx_transparent_mode' => 'O modo Apache lida tanto com conteúdo estático quanto dinâmico, enquanto nginx só passa solicitações e respostas HTTP sem modificação.',
    'gphd__nginx_serve_static' => 'Fornecer arquivos estáticos diretamente pelo nginx',
    'gphd__nginx_static_extensions' => 'Extensões de arquivos estáticos que devem ser manipulados pelo nginx',
    'gphd__nginx_serve_php' => 'Processar arquivos PHP por nginx',
    'gphd__www_root' => 'WWW Diretório Raiz',

    'eol__none' => 'não modificar',
    'eol__lf' => 'converter para estilo Unix',
    'eol__cr' => 'converter para estilo MacOS',
    'eol__crlf' => 'converter para estilo Windows',

    'ui__dns_bad_zone' => 'Zona divergente "%1": ',
    'ui__dns_ns_has_no_address_records' => 'O registro de NS "%1" não têm registro de endereço (A ou AAAA).',
    '__dns_bad_zone' => 'Zona divergente "%1": ',
    '__dns_ns_has_no_address_records' => 'O registro de NS "%1" não têm registro de endereço (A ou AAAA).',
    '__dns_ptr_is_wildcard' => 'O registro PTR "%1" é inválido: O registro aponta para um domínio universal.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Permitir acesso remoto para o usuário do banco de dados \'%3\' do cliente \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Não é possível permitir conexões remotas para o usuário de banco de dados \'%1\': Não é possível determinar o número da porta TCP utilizada pelo Microsoft SQL Server \'%2\'. As possíveis razões são as seguintes: o protocolo TCP/IP não está habilitado na configuração de rede do servidor ou o servidor está configurado para usar portas TCP dinâmicas. Configurar o servidor para responder em uma porta TCP específica e tente permitir as conexões remotas novamente.',

    'command__convertResellerHasCustomer' => 'A conta de revendedor \'%1\' possui uma ou várias contas de clientes. Para converter essa conta de revendedor em uma conta de cliente, primeiramente transfira essas contas de clientes para um novo proprietário ou converta-as em contas de revendedores.',
    'command__convertResellerNotReseller' => 'Somente as contas de revendedor podem ser convertidas em contas de clientes. \'%1\' não é um revendedor.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Não foi possível sincronizar a assinatura com o plano de serviços. As configurações a seguir da assinatura entram em conflito com o plano de serviços: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'A conta \'%1\' é uma conta de revendedor. Contas de revenda não podem ser movidas para um novo proprietário, porque elas são de propriedade do administrador do servidor.',
    'moveCustomer__wrong_owner_type' => "A conta de cliente '%1' pode ser movida somente à um revendedor ou administrador, não para outro cliente.",
    'moveCustomer__customer_already_belongs_to_owner' => 'A conta de cliente \'%1\' já pertence ao proprietário selecionado.',
    'upgradeClient__user_is_admin' => 'A conta \'%1\' não pode ser convertida para uma conta de revenda, pois é uma conta de administrador.',

    'mail__error_setting_max_connections_courier' => 'Não é possível definir o número máximo de conexões (IMAP, POP3, IMAP sobre SSL/TLS, ou POP3 sobre SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Não é possível definir o número máximo de conexões (IMAP, POP3, IMAP sobre SSL/TLS, ou POP3 sobre SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Não é possível definir o número máximo de conexões (IMAP, POP3, IMAP sobre SSL/TLS, ou POP3 sobre SSL/TLS) por endereço de IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Não é possível definir o número máximo de conexões (IMAP, POP3, IMAP sobre SSL/TLS, ou POP3 sobre SSL/TLS) por endereço de IP para um usuário de e-mail específico: %1',
    'outgoing_messages_limit_value_invalid' => 'O valor deve estar na faixa %%MIN%%..%%MAX%%. Somente o administrador do Plesk pode ajustar essa configuração.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Os domínios a seguir utilizam endereços de e-mail externos para encaminhar e-mails para os e-mails enviados para endereços não existentes. As mensagens enviadas para esses endereços, não serão contabilizadas no Controle de e-mail de saída:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Os limites da saída de e-mails não funcionarão para os remetentes cujos endereços de IP estão na lista branca do servidor do e-mail. Por exemplo, se houver localhost (127.0.0.0 / 8, ::1 / 128) na lista branca, todos os e-mails do servidor local serão enviados com sucesso independente das limitações. Os remetentes podem utilizar endereços de IP locais (sites e scripts personalizados hospedados no servidor local) ou externos (clientes que enviam e-mails do e-mail instalado em seus computadores ou dispositivos móveis). Para fazer os limites funcionarem para todos os remetentes (tanto locais quanto externos), remova todos os endereços de IP e redes da lista branca. Observe que ao remover o localhost (127.0.0.0 / 8, ::1 / 128) da lista branca pode romper a operação dos sites e scripts que enviam e-mails deste servidor. Para detalhes sobre as limitações na saída de e-mails, consulte o Guia do Administrador, Proteção do Spam de Saída.',
    'outgoing_messages_relay_open' => 'A retransmissão de e-mail está aberta: Os limites de e-mail de saída não funcionarão.',

    'notification_aps_app_updates_available' => 'As atualizações estão disponíveis os seguintes aplicativos:',
    'notification_aps_app_updates_installed' => 'As atualizações foram instaladas automaticamente para as seguintes aplicações:',
    'notification_aps_app_updates_requirements' => 'As atualizações estão disponíveis para as seguintes aplicações, porém não podem ser instaladas, pois as configurações de hospedagem dos sites correspondentes não atende aos requisitos de instalação:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" na %%parentName%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" na %%parentName%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" na %%parentName%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" na %%parentName%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Sua versão: %%from%%. Versões disponíveis: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" na %%parentName%% (%%url%%). Sua versão: %%from%%. Versões disponíveis: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" na %%parentName%% (%%url%%). Sua versão: %%from%%. Versões disponíveis: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nova versão: %%to%%. Versão anterior: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nova versão: %%to%%. Versão anterior: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nova versão: %%to%%. Versão anterior: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versão instalada: %%from%%. Versões disponíveis: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Sua versão: %%from%%. Versões disponíveis: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'aplicativo externo',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domínios',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Endereços de E-mails',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Assinaturas',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 mensagens por hora',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Ilimitado',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, o limite é %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 tentativa(s) para exceder os limites de %2 até %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 tentativa(s) para exceder os limites de %2 até o momento',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Proibindo endereço IP (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'O componente Fail2ban não está instalado no servidor de destino.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Instalar Fail2ban. Note que isso pode levar alguns minutos.',

    'plesk_key__no_reseller_support' => 'Você não pode gerenciar os revendedores devido as restrições de licença.',
    'plesk_key__no_customers_support' => 'Você não pode gerenciar os clientes devido as restrições de licença.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Não é possível alternar para a exibição de prestador de serviços devido as restrições de licença.',
    'plesk_key__no_security_core_support' => 'Os principais recursos de segurança (ModSecurity e Fail2Ban) não estão disponíveis devido as restrições de licença.',
    'plesk_key__outgoing-antispam' => 'Controle de e-mail de saída',
    'plesk_key__security-core' => 'Core de Segurança (ModSecurity e Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Gerenciamento de contas',
    'plesk_key__can-manage-subscriptions' => 'Gerenciamento de assinaturas',
    'plesk_key__can-manage-customers' => 'Gestão de clientes',
    'plesk_key__can-manage-resellers' => 'Gerenciamento de revendedores',
    'plesk_key__can-manage-custom-view' => 'Disponibilidade do Modo Restrito',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Gerenciamento de assinaturas está desativado, mas você tem várias assinaturas (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Gerenciamento de revendedores está desativado, mas você tem vários revendedores (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Gerenciamento de clientes está desativado, mas você tem vários cliente (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Certos recursos de assinatura que você não pode mais gerenciar na interface do Plesk (como limites de caixas de e-mail e espaço em disco de domínios) agora são definidos como ilimitados.',
    'plesk_key__no_subscriptions_support' => 'Você não pode gerenciar assinaturas devido as restrições de licença.',
    'plesk_key__no_custom_view_support' => 'Não é possível utilizar o Modo Restrito em razão das restrições de licença.',
    'plesk_key__trial_forbidden_region' => 'O Plesk não está disponível atualmente na sua região.',
    'additional_key__main_key' => 'A chave é uma chave principal: Você não pode carregar uma chave principal como uma chave adicional.',

    'gch__hosting_waf_rule_engine' => 'Modo de firewall de aplicativo web',

    'backup__fieldset__restoration_options' => 'Opções de restauração',
    'backup__restore_options__restore' => 'Restaurar',
    'backup__restore_options__domain__domain_configuration' => 'Configuração de domínio',
    'backup__restore_options__domain__virtual_host_content' => 'Conteúdo do host virtual',
    'backup__restore_options__domain__mail' => 'E-mail',
    'backup__restore_options__domain__databases' => 'Bancos de dados',
    'backup__restore_options__client__client_configuration' => 'Configuração da conta do cliente',
    'backup__restore_options__client__domains' => "Domínios do cliente",
    'backup__restore_options__reseller__reseller_configuration' => 'Configuração de conta do revendedor',
    'backup__restore_options__reseller__personal_domains' => "Domínios do revendedor",
    'backup__restore_options__reseller__clients' => "Clientes do revendedor",
    'backup__restore_options__admin__server_configuration' => 'Configurações do servidor',
    'backup__restore_options__admin__administrator_configuration' => 'Configuração da conta do administrador',
    'backup__restore_options__admin__personal_domains' => "Domínios do administrador",
    'backup__restore_options__admin__personal_clients' => "Clientes do administrador",
    'backup__restore_options__admin__resellers' => 'Revendedores',

    'badge_new' => 'Novo',
    'upgrade_php_on_subscription' => 'Atualizar o PHP na sua assinatura para a versão 5.3.0 ou posterior.',

    'pkey_notify__body_expiration_notification' => 'A chave de licença expirada. Algumas características podem estar indisponíveis. Entre em contato com o seu provedor de hospedagem.',

    'crontab__crontab_entry_exists' => "A tarefa agendada já existe.",
    'crontab__crontab_entry_not_exists' => "A tarefa agendada não existe.",
    'crontab__invalid_values_found' => "Valores de parâmetro incorretos.",
    'crontab__cmd_max_len' => "O comando não pode exceder %1 caracteres.",

    'domain__domain_exists' => "Há um domínio com o prefixo 'www' e o mesmo nome: %1.%2.",
    'domain__subdomain_exists' => "Há um subdomínio com o prefixo 'www' e o mesmo nome: %1.%2.",
    'domain__dalias_exists' => "Há um alias do domínio com o prefixo 'www' e o mesmo nome: %1.%2.",
    'domain__record_exists' => "Existe um registro DNS apontando para o host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "O certificado '%1' não pode ser estabelecido como padrão: a chave privada está ausente.",
    'ip_addr__update_dns_error' => 'Problemas ocorreram ao atualizar o endereço IP nas zonas DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Não é possível adicionar o endereço IP. Essa interface de rede obtém endereços IP automaticamente.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Não foi possível remover o endereço IP %1. Essa interface de rede obtém endereços IP automaticamente.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Não foi possível reparar o endereço IP %1. Essa interface de rede obtém endereços IP automaticamente.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Não é possível alterar a interface do endereço IP %1 porque a interface de rede %2 obtém os endereços IP automaticamente.',

    'shm_lmsg__limit_for_resource_exceeded' => 'O limite da assinatura do número de %%type%% foi excedido. O limite é %%limit%% e %%usage%% atualmente está sendo utilizado.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'A criação de %%type%% não é permitida para esta assinatura.',
    'shm_lmsg__resource_title__db-mysql' => 'Bancos de dados MariaDB/MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Bases de dados MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Bases de dados PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'usuários de banco de dados',
    'shm_lmsg__resource_title__iis-application-pool' => 'Conjuntos de aplicativos IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'contas de FTP adicionais',

    'db_user_unable_remove_mysql_global_privileges' => 'Não foi possível remover privilégios globais MariaDB/MySQL do usuário do banco de dados %1. Motivo: %2',
    'report__client_description' => 'Descrição',

    'db__user_role_error' => 'A função incorreta do usuário do banco de dados foi especificada: %1. Escolha uma das funções a seguir: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Não é possível definir o limite de tamanho de arquivo para os seguintes bancos de dados Microsoft SQL Server, porque eles têm um maior tamanho de arquivo: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Não é possível definir o limite de tamanho de arquivo de log para os seguintes bancos de dados Microsoft SQL Server, porque eles têm um maior tamanho de arquivo de log: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Não é possível configurar um endereço IP público: é preciso um endereço IP privado.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Não é possível configurar um endereço IPv4 público para o endereço IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Não é possível configurar um endereço IPv6 público para o endereço IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Não foi possível configurar um endereço IP público: endereço IP inválido.',

    '__user_already_exists' => "O usuário %1 já existe.",
    '__user_name_is_empty' => "Especifique um nome de usuário.",

    'upgrade_php_on_domain' => 'Não foi possível encontrar a versão PHP 5.3.0 ou posterior em qualquer um dos seus domínios WordPress. Tente atualizar PHP.',

    'component_name__waf' => 'Firewall de aplicativo web',
    'component_name__vcs' => 'Sistema de Controle de Versão',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Uma possível tentativa de falsificação foi detectada: O link tentou exibir conteúdo irrelevante.',
    'forceResetPasswordUpdated' => 'Sua senha foi alterada. Use a nova senha para fazer login no Plesk.',

    'php_handlers_error_no_available_instance' => 'Não é possível criar um domínio: não há manipuladores de PHP disponíveis.',
    'domain_error_unable_to_apply_hosting_settings' => 'Não é possível aplicar as configurações de hospedagem: %1',

    'plesk_not_configured' => 'Plesk não está configurado. Vá para o painel de controle para executar a configuração pós-instalação.',
    'cmd_mail__mail_password_duplicated' => 'Os dois endereços de e-mail e senha especificados já existem no servidor de e-mail. Por favor, especifique outro endereço de e-mail ou senha.',

    'extensionRequirementOs' => 'O sistema operacional (%1) não é suportado pelo pacote.',
    'extensionRequirementPleskMinVersion' => 'O Plesk %1 é a versão mais antiga suportada pelo pacote.',
    'extensionRequirementPleskMaxVersion' => 'As versões a partir do Plesk %1 não são suportadas pelo pacote.',
    'extensionBlacklisted' => 'A extensão %1 não é permitida para a instalação.',
    'extensionDisabled' => 'A extensão está desativada.',


    'optimization_settings__unable_set_mpm_event' => 'Não foi possível definir o modo mpm_event: o módulo Apache PHP5 precisa ser desligado, porém este módulo é utilizado pelos domínios.',
    'optimization_settings__unable_turn_off_php' => 'Não é possível desligar o módulo Apache PHP5: ele é usado pelos domínios.',

    'hst_def__fp_admin_login' =>  'Nome de usuário do FTP',
    'hst_def__fp_admin_passwd' =>  'Senha do FTP',

    'database_user_orphaned_old_password_wrong' => "Não é possível reparar o usuário órfão '%1': a senha está incorreta.",
    'cannot_load_partner_central_property_key_no_exist' => "Não foi possível recuperar as propriedades personalizadas: a chave de licença não existe.",
    'extensionScriptFailure' => "A execução de %1 falhou com a seguinte mensagem: %3",
    '__ssl_redirect' => "Redirecionamento 301 SEO seguro permanente do HTTP para o HTTPS.",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'O gerenciamento DKIM não é suportado.',
    'mail__dmarc_not_supported' => 'O gerenciador DMARC não é suportado.',
    'mail__relay_white_list_not_supported' => 'O gerenciando da lista branca de retransmissão não é suportado.',
    'mail__black_list_not_supported' => 'O gerenciamento da lista negra não é suportado.',
    'mail__autoresponder_not_supported' => 'O gerenciamento autorresponder não é suportado.',
    'mail__autoresponder_message_subject' => 'Resposta automática',
    'defaultcomponents__not_supported_version' => '(versão não suportada)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'O certificado \'%1\' não foi encontrado.',
    'certificate__unable_setup_certificate' => 'Não é possível instalar o certificado: A chave privada e o conteúdo do certificado estão ausentes.',
    'certificate__used_by_panel' => 'Um dos certificados que você pretende excluir é usado para proteger o Plesk.',
    'certificate__used_by_mail_server' => 'Um dos certificados que você pretende excluir é usado para proteger o servidor de e-mail.',
    'certificate__used_by_domain_service' => 'Um dos certificados que você deseja excluir é usado pelo serviço de domínio.',
    'mail_server__not_installed' => 'Não é possível instalar o certificado para o servidor de correio porque o servidor de correio não está instalado.',

    'email_activation_mail_subject' => 'Ative sua conta no Plesk',
    'email_activation_mail_body' => "Foi criada uma conta no servidor Plesk %1 Detalhes da conta: Nome: %2 Endereço de e-mail: %3 Caso essas informações estejam corretas e a conta foi criada por você, ative-a com o seguinte link: %4 Ao ativar a conta, você autoriza o suporte do servidor a coletar, armazenar, processar e usar seus dados pessoais (nome e e-mail), para criar e manter sua conta, em conformidade com as leis de proteção de dados vigentes, como parte do contrato.",

    'backup_transport_permission_name' => '%1 gerenciamento',
    'backup_transport_permission_description' => 'Permite usar %1 para armazenar backups.',

    'domain_move_err_target_no_hosting' => 'Não é possível mover o domínio para uma assinatura sem hospedagem.',
    'domain_move_err_already_in_target' => 'O domínio já pertence à assinatura de destino.',
    'domain_move_err_main_domain' => 'O domínio principal não pode ser movido.',
    'domain_move_err_subdomain_without_parent' => 'Não é possível mover o subdomínio %1 sem o domínio pai %2.',
    'domain_move_err_root_exists' => 'O caminho de destino para www_root %1 já existe.',
    'domain_move_err_nested_roots' => 'Não é possível mover o domínio porque ele compartilha a root do documento com outro domínio: %1.',
    'domain_move_err_no_mail_service' => 'Não é possível mover o domínio porque o serviço de e-mail está desativado na assinatura de destino.',
    'domain_move_err_app' => "O aplicativo instalado no %1 não foi movido para a assinatura '%2': %3",
    'domain_move_database_used_by_app' => "O banco de dados '%1' em %2 é usado pelo aplicativo movido. Para reatribuir o banco de dados para '%3', execute o `banco de dados plesk bin --atribuir-a-assinatura`",
    'domain_move_target_locked' => "A assinatura de destino '%1' foi bloqueada para sincronização.",
    'domain_move_filesharing_disabled' => 'O compartilhamento de arquivos foi desativado.',
    'domain_move_website_preview_disabled' => 'A pré-visualização do site foi desativada.',
    'domain_move_additional_webserver_settings' => "Revise as diretivas adicionais do servidor da web do domínio para evitar que a configuração seja interrompida.",
    'domain_move_no_permission' => "%1 não é permitido para a assinatura '%2'.",
    'domain_move_no_access' => "Nenhum acesso à assinatura '%1'.",
    'domain_split_no_create_permission' => "Criação de domínio não é permitida.",
    'domain_split_empty_login' => 'O login do usuário do sistema é obrigatório.',
    'domain_split_empty_password' => 'A senha do usuário do sistema é obrigatória.',
    'domain_split_err_home_exists' => 'O domínio %1 não pode ser movido porque seu caminho inicial de destino já existe em %2. Renomeie o domínio para movê-lo para uma nova assinatura.',
    'domain_split_err_no_hosting_subdomains' => 'O domínio não pode ser movido para uma nova assinatura porque o domínio não tem hospedagem, mas possui subdomínios. Para mover o domínio, altere seu valor "Tipo de hospedagem" para "Hospedagem de sites" (em Configurações de hospedagem).',
    'domain_split_target_locked' => "A assinatura de destino '%1' está bloqueada para sincronização.",
    'domain_split_target_unsynced' => "A assinatura de destino '%1' não foi sincronizada com o plano devido a: %2.",
    'domain_merge_scheduled_backup_deactivated' => "O backup agendado foi desativado em '%1'.",
    'domain_merge_database_error' => "O banco de dados '%1' em%2 não foi movido para a assinatura '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "O FTP anônimo em '%1' foi desativado.",
    'domain_merge_smb_user_access' => "O usuário adicional '%1' foi movido para a assinatura '%2', mas o acesso do usuário à assinatura foi revogado.",
    'domain_merge_scheduled_tasks' => "As tarefas agendadas foram movidas para a assinatura de destino. Revise a configuração das tarefas.",
    'domain_merge_scheduled_tasks_deactivated' => "As tarefas agendadas foram movidas para assinatura de destino e desativadas. Revise a configuração das tarefas.",
    'domain_merge_no_remove_permission' => "Remoção de assinaturas não é permitida.",
    'domain_merge_err_has_addons' => 'Não é possível mover o domínio principal com seus domínios adicionais; mova o(s) domínio(s) %1 primeiro.',
    'domain_merge_err_has_webusers' => 'Não é possível mover o domínio principal com seus usuários da web.',
    'domain_merge_err_root_exists' => 'O caminho de destino %1 já existe.',

    'database_server_edit_used_for_psa' => 'A atualização do servidor de banco de dados MariaDB/MySQL local não é permitida.',
    'suggest_repair_main_suggestion_ui' => '<b>Você pode corrigir este erro</b> usando o utilitário `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Você pode corrigir este erro usando o utilitário `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'vá para Diagnosticar e Reparar',
    'suggest_repair_using_cli_and_ui' => 'Para fazer isso, execute o comando `plesk repair %1` através da CLI ou %2 e clique em Reparar ao lado de" Banco de dados Plesk "',
    'suggest_repair_using_cli' => 'Para isso, execute o comando `plesk repair %1` via CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'O serviço DNS não estava disponível quando o backup foi criado. No entanto, existem zonas DNS ativas no backup e elas serão habilitadas para os seguintes objetos: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Controlador de Recursos (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Suporte de SmarterMail remoto',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(não permitido pela chave de licença)',
    'plesk_key__validation_failed' => '%1 (Código do erro: %2)',
    'promo__button_details' => 'Detalhes',
    'promo__extension_catalog_title' => 'Catálogo de Extensões',
    'promo__extension_catalog_description' => 'Confira o novo catálogo de extensões e turbine seu Plesk com uma variedade de extensões poderosas!',
    'promo__button_open_catalog' => 'Abra o Catálogo',

    'backup__repository_check_login' => "Incapaz de acessar o armazenamento: %1 Certifique-se de inserir as credenciais de armazenamento corretas.",
    'backup__repository_check_error_list' => "Incapaz de acessar o armazenamento: %1 Certifique-se de ter inserido as configurações de armazenamento corretas.",
    'backup__repository_check_error_mkdir' => "Não foi possível criar o diretório: %1 Verifique se você tem permissão para criar pastas no armazenamento.",
    'backup__repository_check_error_upload' => "Não foi possível fazer upload do arquivo para o armazenamento: %1 Verifique se você tem permissão para fazer upload de arquivos para o armazenamento.",
    'backup__repository_check_error_download' => "Não foi possível baixar o arquivo do armazenamento: %1 Verifique se você tem permissão para fazer upload e download de arquivos do armazenamento.",
    'backup__repository_check_error_resume-upload' => "Não foi possível retomar o upload do arquivo para o armazenamento: %1 Verifique se você tem permissão para retomar uploads para o armazenamento.",
    'backup__repository_check_error_resume-download' => "Não foi possível retomar o download do arquivo do armazenamento: %1 Verifique se você tem permissão para retomar os downloads do armazenamento.",
    'backup__repository_check_error_enable-utf8' => "Incapaz de operar o armazenamento: %1 Verifique se o armazenamento é compatível com a codificação UTF8.",
    'backup__repository_check_error_rm' => "Incapaz de operar o armazenamento: %1 Verifique se você tem permissão para excluir arquivos do armazenamento.",
    'backup__repository_check_error_rmdir' => "Incapaz de operar o armazenamento: %1 Verifique se você tem permissão para excluir pastas do armazenamento.",

    'backup__ftp_repository_check_login' => "%1 Você pode verificá-los independentemente com o comando: %2",
    'backup__ftp_repository_check_error_list' => "%1 Você pode verificá-los independentemente com o comando: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Você pode verificar isso independentemente com o comando: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Você pode verificar isso independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Você pode verificar isso independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Você pode verificar isso independentemente com os comandos: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Você pode verificar isso independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Você pode verificar isso independentemente com o comando: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Você pode verificar isso independentemente com os comandos: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Você pode verificar isso independentemente com os comandos: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Não foi possível alterar as configurações do DMARC. Para ativar esta opção, ative a proteção contra spam DKIM e SPF.',
    'spf_server_wide_disable_failed' => 'Não foi possível alterar as configurações de proteção contra spam SPF. Para desativar o SPF, desligue o DMARC para e-mails recebidos.',
    'sfdk_server_wide_verify_disable_failed' => 'Não foi possível alterar as configurações de proteção contra spam DKIM. Para desativar o DKIM, desative o DMARC para e-mails recebidos.',

    'ccs_not_supported' => 'O Armazenamento da Central de Armazenamento de Certificados do IIS não está configurado no sistema.',
    'ccs_not_enabled' => 'O gerenciamento da Central de Armazenamento de Certificados do IIS não está habilitado no Plesk.',
    'ad_not_supported' => 'O servidor não está associado a um domínio.',

    'component_name__appinit' => "Inicialização do Aplicativo",
    'component_name__cors' => "Compartilhamento de Recursos Entre Origens",
    'component_name__httpcompression' => 'Compressão de Conteúdo HTTP',
    'common_feature_is_not_supported' => 'Este recurso não é mais compatível.',
    'common_feature_is_not_supported_in_proto' => 'Este recurso não é compatível com a versão de protocolo %1.',
    'autoinstaller__plesk_component' => 'Componente do Plesk',
    'plesk_key__key_expired' => 'Sua chave de licença expirou. Para continuar usando o Plesk, %1.',
    'plesk_key__key_purchase' => 'compre uma nova licença',
    'plesk_key__key_expired_period' => 'Sua chave de licença expirou há mais de %1 dias.',

    'sa_action_move' => 'Mover spam para a pasta “Lixo Eletrônico”',

    'bu_conflict_resolver_tomcat_not_supported' => 'Os aplicativos Java não são mais suportados. Eles não estarão disponíveis para os seguintes sites: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Versões móveis de sites hospedados com UNITY Mobile não são mais suportadas. Eles não estarão disponíveis para os seguintes sites: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'A política de uso de todo o servidor não permite o uso de configurações pessoais de antivírus. Eles não serão restaurados completamente para contas de e-mail nos seguintes domínios: {{objects}}',

    'module__not_installed' => "A extensão %1 não está instalada",

    'mail__mail_autodiscovery_server_error' => 'Especifique um nome de domínio personalizado para descoberta automática de e-mail',
    'mail__error_mail_autodiscovery_enable' => 'Não foi possível definir a descoberta automática de e-mail: %1',
    'mail__error_mail_autodiscovery_server' => 'Não é possível definir um nome de domínio personalizado para descoberta automática de e-mail: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Não é possível reconfigurar os registros DNS de descoberta automática de domínios: %1',

    'mail__smarthost_not_configured_error' => 'Um smarthost não está configurado.',
    'mail__smarthost_attach_domains_error' => 'A anexação de domínios ao smarthost terminou com erros:',

    '__invalid_url' => 'URL "%1" é inválida',
    'actionlog__cloning_start' => 'iniciar',
    'actionlog__event_cloning_start' => 'Início da clonagem do servidor',

    '__UPLOAD_ERR_FORM_SIZE' => "Arquivo carregado excede o tamanho permitido",
    '__UPLOAD_ERR_INI_SIZE' => "Arquivo carregado excede o tamanho permitido",
    '__UPLOAD_ERR_NO_FILE' => "Nenhum arquivo recebido",
    '__UPLOAD_ERR_OK' => "Upload do arquivo com sucesso",
    '__UPLOAD_ERR_PARTIAL' => "Arquivo parcialmente enviado, tente novamente",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Falta pasta temporária',
    '__UPLOAD_ERR_CANT_WRITE' => 'Falha ao gravar arquivo em disco',
    '__UPLOAD_ERR_UNKNOWN' => 'Ocorreu um erro desconhecido de upload de arquivo',
    '__accounts' => "Contas",
    '__access' => "Acesso",
    '__address' => "Endereço",
    '__addresses' => "Endereços",
    '__acl_records' => 'Registros ACL',
    '__admin_repository' => "Repositório do administrador",
    '__all' => 'Todos',
    '__allowed' => "Permitido",
    '__anonftp_status' => "FTP anônimo",
    '__antispam' => "Antispam",
    '__apache_restart' => "...%1 servidor web está sendo reiniciado, aguarde...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Suporte a Microsoft ASP.NET",
    '__asp_win_support' => "Suporte a Microsoft ASP",
    '__attachments' => "Anexos",
    '__attachments_list' => "Anexos",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Resposta automática com nome %1 já existe.",
    '__autoresponder' => "Resposta automática",
    '__autoresponders' => "Respostas automáticas",
    '__autoresponders_list' => "Respostas automáticas",
    '__autoresponder_attachment_files' => "Arquivos de anexo de resposta automática",
    '__auto_updates_list' => 'Atualizações disponíveis',
    '__backup_utilites' => "Utilitários de backup",
    '__bind_status' => "Status do servidor DNS",
    '__bu_is_not_installed' => "Este serviço não está atualmente disponível, porque os utilitários de backup não foram instalados.",
    '__bu_not_support_in_key' => "O recurso de backup não é suportado pela chave de licença.",
    '__notifications_not_support_in_key' => 'As notificações não são suportadas pela chave de licença',
    'disabled_by_key' => 'Não suportado pela chave de licença',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "Você não pode usar as palavras reservadas.",
    '__certificate' => "Certificado",
    '__cgi_support' => "Suporte a CGI",
    '__city' => "Cidade",
    '__cl_not_exist' => "Conta de cliente não existe.",
    '__client' => 'Cliente',
    '__client_card' => "Cartão do cliente",
    '__client_contact_name' => "Nome de contato do cliente",
    '__client_form' => "Informações pessoais",
    '__client_ip_pool' => "Pool de IP do cliente",
    '__client_limits' => "Limites de conta de cliente",
    '__client_permissions' => "Permissões do cliente",
    '__client_preferences' => "Preferências do cliente",
    '__client_status' => "Status do cliente",
    '__client_total' => "Total do cliente",
    '__client_with_login_name_already_exists' => "Um usuário com nome de usuário \"%1\" já existe.",
    '__client_domuser_with_login_already_exists' => "O nome de usuário '%1' já está em uso pelo administrador do domínio '%1'.",
    '__clients_global_changes' => "Modificar contas de clientes selecionadas",
    '__cmd_not_found' => "Comando desconhecido: %1",
    '__comments' => "Comentários",
    '__component_version' => "Versão do componente",
    '__component_not_installed' => "O componente %1 não foi instalado",
    '__confirm_overwrite' => "Confirmar a reescrita.",
    '__confirm_stop' => "Você deve confirmar a interrupção do processo.",
    '__confirm_passwd' => "Confirme %1 senha",
    '__conhelp' => "Descrição",
    '__contact_name' => "Nome de contato",
    '__country' => "País",
    '__countries' => 'País',
    '__country_unknown' => 'Não é possível reconhecer o subcódigo do país.',
    '__courier-imap' => 'Servidor Courier',
    '__create_domain' => 'Criar um domínio',
    '__crypted' => 'criptografado',
    '__cp_access' => "Acesso ao Plesk",
    '__cp_user' => "Usuário do Plesk",
    '__create' => "Criar",
    '__create_client_template_without_template' => "Criar conta de usuário sem modelo",
    '__create_domain_for' => "Criar um domínio para <b>%1</b>",
    '__create_domain_template_without_template' => "Criar domínio sem modelo",
    '__creation_date' => "Data de criação",
    '__crontab_unix' => "Agendador",
    '__crontab_win' => "Agendador",
    '__ct_month_jan' => 'Janeiro',
    '__ct_month_feb' => 'Fevereiro',
    '__ct_month_mar' => 'Março',
    '__ct_month_apr' => 'Abril',
    '__ct_month_may' => 'Mai',
    '__ct_month_jun' => 'Junho',
    '__ct_month_jul' => 'Julho',
    '__ct_month_aug' => 'Agosto',
    '__ct_month_sep' => 'Setembro',
    '__ct_month_oct' => 'Outubro',
    '__ct_month_nov' => 'Novembro',
    '__ct_month_dec' => 'Dezembro',
    '__custom_button' => "Botão customizado",
    '__custom_buttons_list' => "Links para serviços adicionais",
    '__daily' => "Diário",
    '__database_not_activated' => "%1 não foi ativado na página de administração do servidor.",
    '__database_not_installed' => "Banco de dados %1 não está instalado.",
    '__database_not_run' => "Banco de dados %1 não está em execução.",
    '__database_is_corrupt' => "O banco de dados do Plesk está corrompido. Abra o utilitário do Reconfigurador para corrigir isso.",
    '__databases' => "Bancos de dados",
    '__databases_list' => "Bancos de dados",
    '__database_type_not_supported_by_key' => 'Para usar o servidor %1, você precisa do suporte para ele, em sua chave de licença. Por favor, consulte seu representante de vendas Plesk.',
    '__date_immediately' => "hoje",
    '__date_never' => "nunca",
    '__day(s)' => "Dia(s)",
    '__day0' => "Dom",
    '__day1' => "Seg",
    '__day2' => "Ter",
    '__day3' => "Qua",
    '__day4' => "Qui",
    '__day5' => "Sex",
    '__day6' => "Sab",
    '__days' => "%1 dia(s)",
    '__db_admin_login_empty' => "Você digitou um nome de usuário vazio, desativando o controle em %1 na interface. Deseja continuar?",
    '__db_unable_to_unregister' => 'Não é possível remover parâmetros de conexão de banco de dados',
    '__db_db_exists' => 'Há pelo menos um banco de dados no servidor',
    '__db_unable_to_change_server_name' => 'O nome para o servidor não pode ser alterado',
    '__db_unable_to_change_port' => 'A porta para o servidor não pode ser alterada',
    '__db_already_exist' => "O banco de dados %1 já existe.",
    '__db_credentials_invalid' => "As credenciais de banco de dados são inválidas.",
    '__db_invalid_password_characters' => 'A senha contém caracteres inválidos',
    '__db_engine' => "Mecanismo de banco de dados", // indirect
    '__db_type' => "Tipo de banco de dados",
    '__db_user' => "Usuário do banco de dados",
    '__db_server' => 'Servidor do banco de dados',
    '__def_domain' => "Domínio-padrão",
    '__default_for_mysql' => 'padrão para o MySQL',
    '__default_for_mariadb' => 'padrão para MariaDB',
    '__default_for_percona' => 'padrão para Percona',
    '__default_for_postgresql' => 'padrão para PostgreSQL',
    '__delete' => "Remover",
    '__demo' => "Esta função não está disponível na versão demo.",
    '__directory' => "Diretório",
    '__disable_lock_screen' => 'Impedir que os usuários trabalhem com o Plesk até que as telas de interface estejam completamente carregadas',
    '__dismiss_news?' => "Tem certeza de que deseja fechar completamente o bloco de notícias?\n\nVocê não conseguirá ver o bloco de notícias até que mais notícias estejam disponíveis.",
    '__description' => "Descrição",
    '__disabled' => "desativado",
    '__disk_space_limit' => "Limite de espaço em disco",
    '__cgroups_cpu_usage_limit' => 'Limite de uso da CPU',
    '__cgroups_ram_usage_limit' => 'Limite de uso da RAM',
    '__cgroups_disk_read_usage_limit' => 'Limite de leitura de disco da banda larga',
    '__cgroups_disk_write_usage_limit' => 'Limite da gravação de disco da banda larga',
    '__disk_usage_by' => "Espaço em disco usado por %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Registro DNS '%1' já existe.",
    '__dns_master_should_be_remote' => "Você deve ter dois servidores de nomes diferentes autoritativos em hosts separados.",
    '__dns_record_not_exist' => "O registro DNS não existe.",
    '__dns_server' => "Servidor DNS", // indirect
    '__dom_id_is_undefined' => "A ID de domínio está indefinida.",
    '__dom_name' => "Nome do domínio",
    '__dom_name_is_invalid' => "O nome de domínio é inválido. Certifique-se de que seu nome de domínio tem apenas símbolos alfanuméricos, símbolos de hífen e ponto e tem mais do que 255 símbolos de comprimento. Cada parte do nome de domínio entre os pontos não deve exceder 63 símbolos.",
    '__dom_not_exist' => "O domínio não existe.",
    '__domain' => "Domínio",
    '__domain_' => 'Domínio %1',
    '__domain_form' => "Formulário de domínio",
    '__domain_id' => "ID de domínio",
    '__domain_is_turned_off_for_backup' => "O site %1 está temporariamente desativado para backup/restauração e não está disponível no momento.",
    '__domain_limits' => "Limites de domínio",
    '__domain_name' => "Nome do domínio",
    '__mail_name_in_ASCII_form' => "Nome de conta de e-mail no formato ASCII",
    '__message_error' => 'Erro',
    '__message_warning' => 'Aviso',
    '__message_info' => 'Informações',
    '__domain_name_in_ASCII_form' => "Nome de domínio no formato ASCII",
    '__domain_repository' => "Repositório de domínio %1",
    '__domain_status' => "Status do domínio",
    '__domain_found_tech' => "Tecnologia encontrada no domínio",
    '__domain_dns' => 'Zona DNS do domínio',
    '__domain_total_powerUser' => "Quantidade total para a assinatura",
    '__domain_user' => "Administrador de domínio",
    '__domains_global_changes' => "Modificar domínios selecionados",
    '__mailnames_global_changes' => "Modificar contas de e-mail selecionadas",
    '__backup_manager' => 'Gerenciador de backup',
    '__domains_list' => "Domínios",
    'domains_list__list_header' => "domínios",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "O nome de domínio começa com www, embora o prefixo WWW seja usado.\nDeseja continuar mesmo assim?",
    '__dovecot' => 'Servidor Dovecot IMAP e POP3',
    '__dsmail' => "Serviço de e-mail",
    '__dsmaillist' => "Serviço de lista de mala direta",
    '__dumps_tot_size' => "Tamanho total dos arquivos de backup no armazenamento local",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "O endereço de e-mail é inválido.",
    '__enabled' => "ativado",
    '__enter_cert_text' => "Digite o texto do certificado",
    '__enter_size' => "Digitar tamanho",
    '__exclusive' => "Dedicado",
    '__expiration_date' => "Data de expiração",
    '__fax' => "Fax",
    '__file' => "Arquivo",
    '__file_is_empty' => "O arquivo está vazio.",
    '__file_name' => "Nome do arquivo",
    '__file_type' => 'Tipo de arquivo',
    '__filemanager' => "Gerenciador de arquivos",
    '__filepath_is_empty' => "O caminho para o arquivo está vazio",
    '__files_list' => "Arquivos",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Configurações de FTP",
    '__ftp_serv' => "Servidor de FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Você deve primeiro definir as propriedades da conta FTP!",
    '__ftp_status' => "Status do servidor FTP",
    '__full_day0' => "Domingo",
    '__full_day1' => "Segunda-feira",
    '__full_day2' => "Terça-feira",
    '__full_day3' => "Quarta-feira",
    '__full_day4' => "Quinta-feira",
    '__full_day5' => "Sexta-feira",
    '__full_day6' => "Sábado",
    '__full_month1' => "Janeiro",
    '__full_month10' => "Outubro",
    '__full_month11' => "Novembro",
    '__full_month12' => "Dezembro",
    '__full_month2' => "Fevereiro",
    '__full_month3' => "Março",
    '__full_month4' => "Abril",
    '__full_month5' => "Mai",
    '__full_month6' => "Junho",
    '__full_month7' => "Julho",
    '__full_month8' => "Agosto",
    '__full_month9' => "Setembro",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Cota do disco rígido",
    '__hard_disk_quota_not_supported' => 'a cota de disco rígido não é suportada por causa da configuração do sistema de arquivos do servidor',
    '__help_topic_not_found' => 'O tópico de ajuda solicitado (%1) não existe.',
    '__hosting_ip_dns_ip_not_equiv' => "Nenhum dos endereços IP especificados nos registros DNS A coincidem com o endereço IP usado para hospedagem.",
    '__hosting_scripting' => "Suporte de script de hospedagem",
    '__hosting_setup_page_title' => "Configuração de hospedagem da web para domínio %1",
    '__hosting_title' => "Hospedagem (%1)",
    '__hosting_type' => "Tipo de hospedagem",
    '__hostname_is_empty' => "O nome do host está vazio.",
    '__hour(s)' => 'Hora(s)',
    '__hst_type_incorrect' => "O tipo de hospedagem é incorreto.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Tempo ocioso",
    '__iface' => "Interface",
    '__image' => "Imagem",
    '__imap_status' => "Status do servidor IMAP",
    '__incorrect_databases_login_pass' => "As credenciais especificadas para acessar PostgreSQL estão incorretas.",
    '__incorrect_ip_or_network_address' => 'Rede ou endereço IP incorreto.',
    '__info' => 'Info',
    '__install' => "Instalar",
    '__install_prefix' => "Instalar prefixo",
    '__invalid_cert_id' => "ID de certificado inválida",
    '__invalid_context' => "Contexto inválido: %1",
    '__invalid_db_usr_name' => "O nome de usuário do banco de dados é inválido.",
    '__invalid_dir_name' => "O nome do diretório é inválido",
    '__invalid_dom_name' => "O nome de domínio é inválido.",
    '__invalid_filename' => "Nome de arquivo inválido. Não use combinação de \"../\" e/ou aspas simples.",
    '__invalid_id' => "Identificador inválido.",
    '__invalid_lines_num' => "Valor inadequado para o número de linhas, apenas dígitos são permitidos.",
    '__invalid_max_letter_size' => "O tamanho máximo de mensagem é inválido.",
    '__invalid_restart_apache_interval' => "O intervalo de reinício do Apache é inválido.",
    '__invalid_tmpl_name' => "O nome do modelo é inválido.",
    '__invalid_value' => "Valor incorreto.",
    '__ip_addr' => "Endereço IP",
    '__ip_address_and_mask' => "Máscara de sub-rede e endereço IP",
    '__ip_alias__mask' => "Máscara de sub-rede e endereço IP",
    '__ip_addr_is_invalid' => "O endereço IP é inválido.",
    '__ip_addr_list' => "Endereços IP",
    '__ip_address_and_mask_hint' => 'Por exemplo, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Sua chave de licença se destina somente para uso no Virtuozzo containers.",
    '__key_limits_exceeding' => "Esta ação excede os limites definidos por sua licença de software. Se você recebeu esta mensagem, pode entrar em contato com seu fornecedor ou fabricante para esclarecê-la ou estender os limites desta licença.",
    '__kilo' => "K",
    '__keywords' => 'Palavras-chave',
    '__lang_unknown' => 'Não é possível reconhecer o idioma.',
    '__languages' => 'Idioma',
    '__learn_more' => 'Saiba mais',
    '__loading' => 'Carregando...',
    '__locales' => "Pacotes de idiomas",
    '__lists' => "Mala direta",
    '__literal_bytes' => "B",
    '__processing' => "Aguarde.<br>Carregando...",
    '__locale' => "Idioma da interface",
    '__locale_is_not_defined' => "O idioma da interface não está definido.",
    '__local_server_mysql' => 'Servidor local MariaDB/MySQL',
    '__local_server_postgresql' => 'Servidor PostgreSQL local',
    '__local_server_mssql' => 'Servidor MS SQL local',
    '__log_and_statistics_files' => 'Arquivos de log e relatórios estatísticos',
    '__config_files' => 'Arquivos de configuração',
    '__chroot_files' => 'Ambiente com chroot',
    '__login' => "Login %1",
    '__login1' => "Login",
    '__login_disabled' => "Login proibido",
    '__login_enabled' => "Login permitido",
    '__login_incorrect' => "Nome de usuário ou senha incorretos. Tente novamente.",
    '__login_rate_limit_reached' => "Muitas tentativas de login. Tente novamente mais tarde.",
    '__login_name' => "Nome de usuário %1",
    '__login_name_is_invalid' => "O nome de usuário %1 é inválido.",
    '__logon_time' => "Tempo de login",
    '__ma' => "Nomes alternativos de e-mail",
    '__mail' => "E-mail",
    '__mail_alias_name' => "Nome do nome alternativo de e-mail",
    '__mail_autodiscovery' => 'Descoberta automática de e-mail',
    '__mail_exchanger_name_is_invalid' => "O nome do servidor de mensagens é inválido.",
    '__mail_groups' => "Grupos de correio",
    '__mail_list_engine' => "Software da lista de mala direta",
    '__mail_name' => "Conta de e-mail",
    '__mail_name_form' => "Propriedades da conta de e-mail",
    '__mail_names' => "Contas de e-mail",
    '__mail_serv' => "Servidor de e-mail",
    '__mail_user' => 'Usuário de e-mail',
    '__mailgroup' => "Grupo de e-mail",
    '__maillist' => "Mala direta",
    '__maillists' => "Mala direta",
    '__maillist_member' => 'Membro da malas direta',
    '__mailname' => "Conta de e-mail",
    '__mailname_redir_self' => "A conta de e-mail não pode encaminhar e-mails para si mesma.",
    '__max_dom_num_reached_for_cl' => "Foi atingido o limite do número de domínios para esta conta de cliente.",
    '__max_file_size_available' => "Tamanho de arquivo máximo permitido %1",
    '__max_subdom_num_reached_for_cl' => "Foi atingido o limite do número de subdomínios para esta conta de cliente.",
    '__max_subdom_num_reached_for_dom' => "Foi atingido o limite do número de subdomínios para o domínio.",
    '__max_subdom_num_reached_for_key' => "Foi atingido o limite do número de subdomínios permitidos pela chave de licença.",
    '__max_traffic_limit' => "Limite de tráfego",
    '__maximum_excl_ip_num' => "Contas de e-mail",
    '__mb' => "MB",
    '__mbytes' => "megabytes",
    '__mb_month' => "MB/mês",
    '__mb_sec' => "MB/sec",
    '__gb_sec' => "GB/s",
    '__tb_sec' => "TB/s",
    '__mega' => "M",
    '__minute(s)' => 'Minuto(s)',
    '__mls_not_in_key' => "A chave do produto não oferece suporte a interface multilíngue.",
    '__modification_date' => "Data de modificação",
    '__module' => "Extensão",
    '__month' => "Mês",
    '__month(s)' => "Mês(es)",
    '__month1' => "Jan",
    '__month10' => "Out",
    '__month11' => "Nov",
    '__month12' => "Dez",
    '__month2' => "Fev",
    '__month3' => "Mar",
    '__month4' => "Abril",
    '__month5' => "Mai",
    '__month6' => "Junho",
    '__month7' => "Julho",
    '__month8' => "Ago",
    '__month9' => "Set",
    '__monthly' => "Mensal",
    '__months' => "Meses",
    '__moved_permanently' => 'Movido permanentemente',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Servidor",
    'mssql__server' => "Nome do servidor Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "nome do servidor não pode ser alterado: há, pelo menos, um banco de dados nele.",
    '__mssql_status' => "Status do Microsoft SQL Server",
    '__multiply_login_deny' => "Não é possível iniciar a sessão. Outro usuário com o mesmo nome de usuário (%1) já está logado no Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Status do servidor MySQL",
    '__mysql_version' => "Versão MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB status do servidor",
    '__mariadb_version' => "MariaDB versão",
    '__percona' => "Percona",
    '__percona_status' => "Percona status do servidor",
    '__percona_version' => "Percona versão",
    '__name' => "Nome",
    '__name_invalid' => "O nome é inválido.",
    '__nameserver' => "servidor de nome",
    '__network' => "Rede",
    '__networks' => "Redes",
    '__no' => "Não",
    '__no_ip_address_with_properly_type_available' => "Não é possível restaurar o backup de dados porque não há endereços IP apropriados necessários para a restauração.",
    '__no_clients_specified' => "Não há contas de cliente especificadas.",
    '__no_comments' => "Sem comentários.",
    '__nologin' => "Proibido",
    '__none' => "Nenhum",
    '__not_configured' => "Não configurado",
    '__not_implemented_yet' => "Ainda não implementado",
    '__not_supported_by_ftp' => "(não suportado pelo servidor FTP)",
    '__notification' => "Notificação",
    '__num_displayed' => "%1 de %2 exibido",
    '__num_is_invalid' => "O número é inválido.",
    '__object_not_found' => 'Objeto não encontrado: %1',
    '__off' => "Desligar",
    '__ok' => "OK",
    '__old_passwd' => "Senha antiga %1",
    '__on' => "Ligar",
    '__others' => "Outros",
    '__other_ip__will_be_added' => 'Outros endereços IP disponíveis (serão adicionados ao pool de IP do cliente)',
    '__p' => "P",
    '__passwd' => "Senha %1",
    '__passwd_is_invalid' => "A senha %1 é inválida.",
    '__path' => "Atalho",
    '__perl_unix_support' => "Suporte a Perl",
    '__perl_win_support' => "Suporte a Perl",
    '__perm_denied' => "Permissão negada.",
    '__permissions' => "Permissões",
    '__personal_name' => "Nome pessoal",
    '__pg_admin_not_activated' => "O PostgreSQL não foi ativado na página de administração do servidor.",
    '__pg_not_inst' => "O PostgreSQL não foi instalado.",
    '__pg_not_run_or_inst' => "O PostgreSQL não foi instalado ou não está em execução.",
    '__pg_not_support_in_key' => "O PostgreSQL não é suportado pela chave de licença.",
    '__phone' => "Telefone",
    '__phosting' => "Hospedagem física",
    '__php_support' => "Suporte a PHP",
    '__php_run_as_isapi' => "executar como extensão ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' ativado",
    '__php_version' => "Versão do PHP",
    '__physical' => "Hospedagem física",
    '__plesk_stat_pdir' => "Proteger o diretório '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Estatísticas do domínio",
    '__plesk_stat_protect' => "Proteger o acesso às estatísticas da web com o nome do usuário e senha FTP",
    '__plesk_stat_protect_install' => "acessível via diretório protegido por senha '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Status do servidor POP3",
    '__popen_error' => "Ocorreu um erro ao chamar a função popen.",
    '__port' => 'Porta',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Status do PostgreSQL",
    '__preferences' => "Configurações",
    '__account_preferences' => "Configurações da conta",
    '__interface_preferences_general' => 'Geral',
    '__interface_preferences_default' => 'Preferências de Interface-padrão',
    '__interface_preferences_admin' => "Preferências de interface do administrador",
    '__interface_template' => 'Modelo de customização de interface',
    '__interface_preferences' => "Preferências de interface",
    '__proceed?' => "Deseja continuar?",
    '__provider_contact_name' => "Nome do contato do provedor",
    '__python_unix_support' => "Suporte a Python",
    '__python_win_support' => "Suporte a Python",
    '__quota' => "Cota",
    '__r' => "R",
    '__reconfigure' => "Reconfigurar",
    '__record_type' => "Tipo de registro",
    '__release' => "Versão",
    '__remote_db_not_supported_by_key' => 'A hospedagem de banco de dados remoto não é suportada pela sua chave de licença.',
    '__remove_protection' => 'Remover a proteção',
    '__report' => "Relatório",
    '__report_size_na' => "O serviço está indisponível",
    '__reports_list' => "Relatórios",
    '__requested' => "Solicitado",
    '__required_fields' => "Campos obrigatórios",
    '__resp_name_invalid' => "O nome da resposta automática é inválido. Use apenas símbolos alfanuméricos, pontos, sublinhado e espaços em branco.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "O nome do servidor é inválido.",
    '__screenshots' => 'Imagens de tela',
    '__script_warning' => "Ao remover os recursos de script deste domínio, todos os scripts influenciados serão exibidos em texto sem formatação ao serem chamados por um navegador.  É aconselhável que o administrador remova todos os scripts dependentes do domínio determinado.",
    '__sec' => "Segundos",
    '__second(s)' => "Segundo(s)",
    '__see_list_of_logged_in' => "Consulte a lista de usuários registrados no momento.",
    '__select_certs_to_remove' => "Selecione certificados a serem removidos.",
    '__select_files_to_remove' => "Selecione arquivos a serem removidos.",
    '__select_ip' => "Atribuir endereço IP",
    '__select_ip_to_remove' => "Selecione um endereço IP a ser removido.",
    '__select_domain_template' => "Use as configurações de modelo de domínio",
    '__select_templates_to_remove' => "Selecione modelos a serem removidos.",
    '__server' => "Servidor",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Servidor de banco de dados MariaDB/MySQL",
    '__service_description__mysql' => "Servidor de banco de dados MariaDB/MySQL",
    '__service_title__web' => "Servidor Web",
    '__service_description__web' => "Servidor Web",
    '__service_title__smtp' => "servido SMTP",
    '__service_description__smtp' => "servido SMTP",
    '__service_title__mail' => "Servidor IMAP/POP3",
    '__service_description__mail' => "Servidor IMAP/POP3",
    '__service_title__dns' => "Servidor DNS",
    '__service_description__dns' => "Servidor DNS",
    '__service_title__postgresq' => "Servidor de banco de dados PostgreSQL",
    '__service_description__postgresq' => "Servidor de banco de dados PostgreSQL",
    '__service_title__spamassassin' => "Serviço de filtragem de spam SpamAssassin",
    '__service_description__spamassassin' => "Serviço de filtragem de spam SpamAssassin",
    '__all_services' => "Todos os serviços",
    '__sessions' => "Sessões",
    'sessions__feature_ftp_session_manager_not_supported' => "O recurso de sessões de FTP  não é suportado pelo servidor de FTP atual",
    '__sessions_list' => "Sessões",
    '__set' => "Ativar",
    '__shared' => "Compartilhado",
    '__shell_access_warning' => "Permitir o acesso de shell ao sistema é altamente perigoso para a segurança do sistema. Permita o acesso ao sistema apenas se você compreender claramente o que está fazendo, e apenas a usuários confiáveis. Você realmente deseja permitir o acesso?",
    '__siteapp_not_support_in_key' => "Os aplicativos web não são suportados pela chave de licença",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'A configuração deste aplicativo da web foi alterada manualmente. Para proteger as modificações manuais, a reconfiguração por meio do Plesk foi indisponibilizada.',
    '__site_management' => "Publicação na Web", // indirect
    '__size' => "Tamanho",
    '__skins' => 'Skins',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Status do servidor SMTP",
    '__some_fields_are_empty_or_invalid' => "Alguns campos estão vazios ou contêm um valor incorreto.",
    '__no_email_addresses_selected' => 'Nenhum endereço de e-mail foi selecionado.',
    '__unable_to_set_parameters' => "Não é possível definir os parâmetros do componente.",
    '__spamassassin' => "Filtro de spam",
    '__spamassassin_status' => "Status do SpamAssassin",
    '__spamd_status' => 'Status do filtro de spam',
    '__splited_backup' => "(backup multivolume)",
    '__split_backup_file' => "Criar um backup multivolume",
    '__split_backup_size' => "Tamanho de volume",
    '__split_backup_less_than_500' => "Tamanhos de volume menores que 500 megabytes não são suportados",
    '__ssi' => "SSI",
    '__ssi_support' => "Suporte a SSI",
    '__ssi_with_html' => "utilizar o SSI para arquivos *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Suporte SSL/TLS",
    '__same_ssl' => "Use um único diretório para abrigar conteúdo SSL/TLS e não SSL/TLS.",
    '__same_ssl_cu' => "Conteúdo comum SSL/TLS e não SSL/TLS.",
    '__state' => "Estado/província",

    '__status__Active' => 'Ativo',
    '__status__active' => 'ativo',
    '__status__Passive' => 'Desativado',
    '__status__passive' => 'desativado',
    '__status__off' => 'desativado',
    '__status__with_parent' => 'desativado',
    '__status__backup_restore' => 'temporariamente suspenso para fazer backup ou restaurar',
    '__status__admin' => 'suspenso pelo administrador do servidor',
    '__status__resseler' => 'suspenso pelo revendedor',
    '__status__client' => 'suspenso pelo cliente',
    '__status__unknown' => 'o status é desconhecido',

    '__status_of' => "Status %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Servidor stunnel", // indirect
    '__subdomain' => "Subdomínio",
    '__subdomain_name' => "Nome do subdomínio",
    '__subdomain_name_in_ASCII_form' => "Nome de subdomínio no formato ASCII",
    '__subdomains' => "Subdomínios",
    '__domainaliases' => "Nomes alternativos de domínio",
    '__subdomains_list' => "Subdomínios",
    '__subdomains_not_support_in_key' => "As operações de subdomínio não são suportadas pela chave de licença",
    '__sys_user_type' => "Usuário de FTP",
    '__sys_user_type_main' => "Usar a conta de usuário FTP do domínio principal",
    '__sys_user_type_native' => "Criar uma conta de usuário FTP separada para este subdomínio",
    '__target_domain' => "Domínio de destino",
    '__template' => "Modelo",
    '__template_not_accepted' => "Não é possível aceitar o modelo: as seguintes limitações foram ultrapassadas.",
    '__templates' => "Modelos",
    '__templates_list' => "Modelos",
    '__tera' => "T",
    '__title' => "Título",
    '__total' => "Total %1",
    '__total_size' => "Tamanho total",
    '__total_used' => "Total usado",
    '__traffic' => "Tráfego",
    '__traffic_by_client' => "Tráfego por cliente",
    '__traffic_by_domain' => "Tráfego por domínio",
    '__traffic_by_service' => "Tráfego por serviço",
    '__traffic_history' => "Histórico de tráfego",
    '__unable_change_locale' => "Não é possível alterar o idioma da interface: %1",
    '__unable_create_new_dom' => "Não é possível criar um domínio: %1",
    '__unable_define_dom_name' => "Não é possível definir novo domínio: %1",
    '__unable_define_necessary_properties' => "Não é possível definir todas as propriedades necessárias.",
    '__unable_define_properties' => "Não é possível definir as propriedades: %1",
    '__unable_exec_util' => "Não é possível executar utilitário: %1",
    '__unable_get_dns_a_recs' => "Não é possível recuperar endereços IP para registros de DNS A para esta conta de hospedagem: %1",
    '__unable_get_mbox_quota' => "Não é possível recuperar as informações sobre o limite de tamanho da caixa de correio.",
    '__unable_redirect_to_myself' => "Não é possível encaminhar para a mesma conta.",
    '__unable_redirect_to_my_alias' => "Não é possível encaminhar e-mails para um nome alternativo de e-mail.",
    '__default_domain_redirect_to_myself' => "Não é possível definir o domínio como padrão para o endereço IP:\n redirecionar para detecção própria.",
    '__unable_remove_client' => "Não é possível remover cliente: %1",
    '__unable_set_up_mbox_quota' => "Não é possível definir o limite de tamanho de caixa de e-mail para o domínio: %1",
    '__unable_setup_pass' => "Não é possível definir senha: %1",
    '__unable_to_create_new_account' => "Não é possível criar uma conta: %1",
    '__unable_to_define_db_size' => "Não é possível definir o tamanho do banco de dados.",
    '__unable_to_enable_short_names' => "Não é possível permitir a utilização de nomes curtos de conta de e-mail para contas POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Não é possível buscar os dados enviados: %1",
    '__unable_to_open_file' => "Não é possível abrir o arquivo %1: %2",
    '__unable_to_update_subdomain' => "Não é possível fazer alterações no subdomínio: %1",
    '__unable_update_cl_data' => "Não é possível salvar alterações para a conta de usuário: %1",
    '__unable_update_db_params' => "Não é possível atualizar parâmetros de banco de dados: %1",
    '__unable_update_dom_data' => "Não é possível atualizar dados de domínio: %1",
    '__undefined' => "indefinido",
    '__uninstall' => "Desinstalar",
    '__unknown_error' => "Erro desconhecido",
    '__unlimited_lower' => "Ilimitado",
    '__unset' => "Desativar",
    '__update' => "Atualizar",
    '__uploaded_file_is_invalid' => "O arquivo carregado é inválido: %1",
    '__url' => "URL",
    '__usage' => "Uso do disco",
    '__user_already_logged' => "Outro usuário com o mesmo nome de usuário (%1) já está logado no Plesk.",
    '__version' => "Versão",
    '__aps_license' => "Chave de licença",
    '__vh_type' => "Tipo de host virtual",
    '__vhosts_apache_status' => "Status do servidor Web",
    '__wrong_charset_conversion' => 'Conjunto de caracteres errado, a conversão de "%1" para "%2" não é permitida',
    '__warning_' => "Advertência!",
    '__warning_excl_ip_num' => "Endereço IP dedicado",
    '__warning_expiration' => "Data de expiração",
    '__web_scripting' => "Web scripting", // indirect
    '__web_serv' => "Servidor Web", // indirect
    '__web_statistic' => "Estatísticas da web", // indirect
    '__webmail' => "WebMail", // +indirect
    '__webstat_not_installed' => "O Webalizer não está instalado no servidor. Entre em contato com seu provedor de serviços para obter assistência sobre a instalação do Webalizer.",
    '__webstat_support' => "Estatísticas da web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Quando você troca de um programa de estatísticas para outro, todos os relatórios criados pelo programa de estatísticas utilizado anteriormente são excluídos e novos relatórios são criados de acordo com as informações lidas nos arquivos de log mantidos no servidor.  Isso significa que, se você tiver configurado o sistema (em Domínios > nome de domínio > Gerenciador de Log > Rotação de Logs) para manter os arquivos de log apenas do último mês, então as estatísticas da web estarão disponíveis apenas para o último mês. Você deseja trocar para outro pacote de estatísticas?",
    '__webstat_perm_denied' => 'Você não tem permissão para gerenciar estatísticas da web.',
    '__webuser' => "Usuário web",
    '__sysusers_list' => "Usuários do sistema",
    '__sysuser' => "Usuário do sistema",
    '__weekly' => "Semanal",
    '__whats_new_in_version' => "O que há de novo no Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Esta operação está disponível apenas para domínios com hospedagem da web.",
    '__wrong_hosting_type__none' => 'Não há nenhuma hospedagem da web configurada no domínio %1.',
    '__wrong_hosting_type__std_fwd' => 'O domínio %1 tem encaminhamento-padrão configurado. Esta operação está disponível apenas para domínios com hospedagem da web.',
    '__wrong_hosting_type__frm_fwd' => 'O domínio %1 tem encaminhamento de quadro configurado. Esta operação está disponível apenas para domínios com hospedagem da web.',
    '__wu' => "Usuários da web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "O prefixo WWW foi alterado. Certifique-se de modificar o certificado SSL/TLS de forma adequada.",
    '__year' => "Ano",
    '__year(s)' => "Ano(s)",
    '__yes' => "Sim",
    '__you' => "Você",
    '__zip_code' => "Código postal/CEP",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avançado",

    'admin_ed__edit_administrator_info' => "Edição do Perfil do Administrador",
    'admin_ed__create_default_client' => "Eu gostaria de criar uma conta de cliente padrão.",
    'admin_ed__unable_update' => "Não é possível atualizar as informações do administrador: %1",

    'auth__update_admin_info' => "Insira informações do administrador. Esta informação é necessária para operar %1.",
    'auth__you_not_have_perm' => "Você não tem permissões para gerenciar este domínio.",
    'auth__key_expired_admin' => 'Sua licença Plesk expirou. Para continuar utilizando o Plesk, renove sua licença ou adquira uma nova.',
    'auth__key_expired_admin_restricted' => 'Sua licença Plesk expirou. Entre em contato com seu provedor de serviços para continuar a utilizando o Plesk.',
    'auth__key_expired_client' => 'A licença do Plesk expirou Entre em contato com o seu provedor de hospedagem.',
    'autoinstaller__not_installed' => 'O componente Autoinstaller não está instalado.',
    'autoinstaller__release_action' => 'Operações disponíveis',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Atualização para a nova versão do Plesk',
    'autoinstaller__release_action_update' => 'Atualização ou adição de novos componentes',
    'autoinstaller__release_action_up2date' => 'Você tem uma versão atualizada',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Não instalado',
    'autoinstaller__component_action_update' => 'As atualizações estão disponíveis',
    'autoinstaller__component_action_upgrade' => 'Uma atualização está disponível',
    'autoinstaller__component_action_up2date' => 'Você tem uma versão atualizada',
    'autoinstaller__component_action_error' => 'As atualizações não estão disponíveis',
    'autoinstaller__component_serverbuildtime' => 'Último lançamento',
    'autoinstaller__component_localbuildtime' => 'Seu lançamento',
    'autoinstaller__component_installed_version' => 'Sua versão',
    'autoinstaller__component_available_version' => 'Versão mais recente',
    'autoinstaller__component' => 'Componente',
    'autoinstaller__components' => 'Componentes',
    'autoinstaller__components_title' => '%1 Componentes',
    'autoinstaller__component_dependency_note' => 'necessária para a instalação dos componentes selecionados',
    'autoinstaller__install_confirm' => 'Sim, quero instalar estes componentes',
    'autoinstaller__install_confirm_request' => 'Marque a caixa de seleção para confirmar',
    'autoinstaller__install_title' => 'Confirmar a instalação dos componentes selecionados',
    'autoinstaller__key_update_confirm' => 'Confirmar ignorando atualização da chave e instalar a chave-padrão',
    'autoinstaller__key_update_confirm_request' => 'Marque a caixa de seleção para confirmar.',
    'autoinstaller__key_update_failed' => '<p>O Plesk não conseguiu atualizar sua licença de produto.</p><p>%1</p><p>Prosseguir com a atualização sem uma licença de produto apropriada resultará na instalação de uma licença-padrão com funcionalidade limitada. Os administradores são aconselhados a primeiro adquirir a chave de licença apropriada antes de prosseguir com a atualização do produto.</p>',
    'autoinstaller__email' => 'Enviar aviso para',
    'autoinstaller__email_admin' => "E-mail do administrador",
    'autoinstaller__email_email' => 'Endereço de e-mail personalizado...',
    'autoinstaller__release' => 'Nome do lançamento',
    'autoinstaller__releases' => 'Lançamentos disponíveis',
    'autoinstaller__releases_title' => 'Atualizador do Plesk',
    'autoinstaller__select_components_to_install' => 'Selecionar os componentes a serem instalados',
    'autoinstaller__status_error' => 'Erro: %1',
    'autoinstaller__status_install_error' => 'Não foi possível iniciar a instalação: %1',
    'autoinstaller__status_install_busy' => 'Não foi possível iniciar a instalação: outro procedimento de instalação está sendo executado.',
    'autoinstaller__status_install_ok' => 'Instalação iniciada. Você será notificado sobre o progresso de instalação via e-mail (%1).',
    'autoinstaller__status_query_busy' => 'A instalação está em andamento.',
    'autoinstaller__status_query_error' => 'Não é possível recuperar o status da instalação: %1',
    'autoinstaller__status_unknown' => 'Não é possível recuperar o status do autoinstaller:',
    'autoinstaller__status_busy' => 'O Autoinstaller está ocupado, aguarde.',
    'autoinstaller__configure_title' => 'Configurações do atualizador',
    'autoinstaller__preferences_legend' => 'Configurações',
    'autoinstaller__target' => 'Diretório de download temporário',
    'autoinstaller__target_invalid' => "Especificar caminho absoluto",
    'autoinstaller__check_updates' => 'Verifique se há atualizações após o login do administrador no Plesk',
    'autoinstaller__check_updates_warning' => 'Novas <a href="%1">atualizações</a> estão disponíveis para %2 ',
    'autoinstaller__source_type' => 'Tipo de fonte',
    'autoinstaller__source' => 'URL de fonte',
    'autoinstaller_source__preferences_legend' => 'Configurações',
    'autoinstaller_source__type' => 'Tipo de fonte',
    'autoinstaller_source__url_invalid' => 'Fonte inválida',
    'autoinstaller_source__url_invalid_network' => 'URL de fonte inválida (Exemplo: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL de fonte',
    'autoinstaller__source_invalid_network' => 'Você especificou um endereço de rede inválido',
    'backup__repository' => 'Local do armazenamento de arquivos de backup',
    'backup__error_notify_email' => 'Se ocorrerem erros durante o backup, enviar notificação para o e-mail',
    'backup__dump_info' => "Informações sobre o backup",
    'backup__dump_file_name_not_defined' => "O nome do arquivo de backup não foi especificado",
    'backup__local_file' => 'Arquivo de backup local',
    'backup__domain_ftp' => 'servidor FTP remoto',
    'backup__wrong_path' => "Caminho incorreto para o armazenamento de arquivos de backup: Não use a sequência de caracteres ../../",
    'backup__unable_to_connect_to_ftp_server' => "Não foi possível se conectar ao servidor FTP: %1",
    'backup__unable_to_read_file' => 'Não foi possível ler o arquivo de backup.',
    'backup__backup_task_does_not_exist' => "A tarefa de backup não existe, você deve criá-la antes de ligar.",
    'backup__restore_params' => "Parâmetros de restauração",
    'backup__confirmation' => "Advertência: o domínio não estará disponível durante o backup/restauração.",
    'backup__backup_method' => 'Método de backup',
    'backup__dumpfile_name' => "Nome do arquivo de backup",
    'backup__dumpfile_name_is_invalid' => "O nome do arquivo de backup é inválido: use somente símbolos alfanuméricos, traço, ponto e sublinhado, não use nomes como descrição.* como nome do arquivo de backup.",
    'backup__email_required' => "Seu endereço de e-mail é necessário para mantê-lo informado sobre o progresso do backup e da restauração. Especifique seu e-mail nos detalhes da conta.",
    'backup__error_during_backup' => "Não foi possível criar o arquivo de backup: %1",
    'backup__input_email_warning' => "Você deve especificar o e-mail para notificação ou desmarcar a caixa de seleção.",
    'backup__make_download' => "não armazenar o arquivo de backup no armazenamento, só fazer o download dele",
    'backup__make_dump' => 'criar arquivo de backup e armazenar em armazenamento local',
    'backup__makedump_to_ftp' => 'criar arquivo de backup e armazenar no servidor FTP remoto',
    'backup__restore_ip' => "Endereço IP para restauração",
    'backup__select_dumpfile' => "Selecione um arquivo de backup.",
    'backup__time' => "Tempo de backup",
    'backup__day' => 'Dia de backup',
    'backup__view_dump_info' => "Exibir as informações de backup para o domínio %1",
    'backup__wrong_domain_name' => "O arquivo de backup contém os dados do domínio %1 e, portanto, não pode ser restaurado no domínio %2",
    'backup__incorrect_ftp_user_or_passwd' => "Usuário ou senha FTP incorretos. Corrija as Propriedades de Conta FTP",
    'backup__access_denied' => "Acesso negado. Corrija as Propriedades de Conta FTP",
    'backup__restore_from' => "Restaurar %1",
    'backup__domain_session_failed' => 'Não foi feito backup do domínio %1',
    'backup__client_session_failed' => 'Não foi feito o backup para o cliente %1',
    'backup__domain_session_restore_failed' => 'O domínio %1 não foi restaurado',
    'backup__client_session_restore_failed' => 'A conta do cliente %1 não foi restaurada.',
    'backup__domain_session_complete' => 'Foi feito backup do domínio %1',
    'backup__domain_session_backup' => 'Backup do domínio %1',
    'backup__client_session_backup' => 'Backup do cliente %1',
    'backup__domain_stop_title' => 'Cancelamento do backup do domínio %1',
    'backup__client_stop_title' => 'Cancelamento do backup da conta do cliente %1',
    'backup__domain_restore_stop_title' => 'Cancelamento da restauração do domínio %1',
    'backup__client_restore_stop_title' => 'Cancelamento da restauração da conta do cliente %1',
    'backup__domain_session_backup_stop' => 'Você está prestes a cancelar o processo de backup ativo. O arquivo de backup não será criado.',
    'backup__backup_stop_confirm' => 'Sim, eu quero interromper o processo de backup',
    'backup__restore_stop_confirm' => 'Sim, eu quero interromper o processo de restauração',
    'backup__domain_session_restore' => 'Restauração do domínio %1',
    'backup__domain_session_restore_stop' => 'Você está prestes a cancelar o processo de restauração ativo.',
    'backup__domain_backup_file_info' => 'Informações do arquivo de backup de domínio',
    'backup__domain_backup_file_list' => 'arquivos de backup existentes',
    'backup__domain_backup_progress' => 'Progresso do backup do site %1',
    'backup__domain_restore_progress' => 'Progresso da restauração do site %1',
    'backup__domain_backup_progress_elapsed_time' => 'Tempo decorrido: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Tempo decorrido: %1',
    'backup__domain_restore_session_complete' => 'O domínio %1 está restaurado.',
    'backup__domain_restore_session_complete_message' => 'O domínio %1 foi restaurado.',
    'backup__domain_backup_file_delete' => 'Os seguintes arquivos de backup serão removidos:',
    'backup__domain_backup_file_for_remove' => 'Selecione os arquivos de backup que deseja remover',
    'backup__backup_overwrite_file_confirm' => 'Confirmação de substituição',
    'backup__backup_overwrite_file_confirm_text' => 'Já existe um arquivo de backup com o nome "%1". Deseja substituí-lo?',
    'backup__backup_confirm_overwrite' => 'Confirmar substituição de arquivo',
    'backup__backup_overwrite_legeng' => 'Substituir',
    'backup__backup_not_contain_domain' => 'O arquivo de backup não contém informações sobre o domínio %1',
    'backup__backup_not_contain_client' => 'O arquivo de backup não contém informações sobre a conta do cliente %1',
    'backup__backup_client_info' => "Fazer backup de configurações e detalhes da conta do cliente",
    'backup__client_backup_progress' => 'Progresso do backup de conta de cliente %1',
    'backup__client_session_complete' => 'Foi feito o backup na conta do cliente %1',
    'backup__client_backup_file_info' => 'Informações de arquivo de backup do cliente',
    'backup__restore_client_info' => "Restaurar as configurações e detalhes da conta do cliente",
    'backup__client_session_restore' => 'Restauração da conta do cliente %1',
    'backup__client_db_server_map' => 'Mapeamento de servidores de banco de dados',
    'backup__domain_db_server_map' => 'Mapeamento de servidores de banco de dados',
    'backup__client_restore_session_complete_message' => 'A conta do cliente %1 foi restaurada.',
    'backup__client_restore_session_complete' => 'A conta do cliente %1 foi restaurada.',
    'backup__restore_select_some' => 'Selecione os objetos que deseja restaurar.',
    'backup__client_restore_progress' => 'Progresso de restauração para a conta de cliente %1',
    'backup__new_backup' => 'Criação de novo backup',
    'backup__done' => 'Concluído:',
    'backup__done_domains' => '%1 domínio(s) de %2',
    'backup__done_clients' => '%1 cliente(s) de %2',
    'backup__remaining' => 'Restante:',
    'backup__remaining_domains' => '%1 domínio(s)',
    'backup__remaining_clients' => '%1 cliente(s)',
    'backup__overall_backup_progress' => 'Progresso global do backup',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => 'O comando "%1" é ignorado',
    'backup__no_objects' => 'não há objetos para fazer backup',
    'backup__cli_warning_not_enough_ip' => 'ADVERTÊNCIA: não há endereços IP suficientes para realizar o mapeamento de IP padrão: ',
    'backup__local_repository' => "Armazenamento do Plesk",
    'backup__ftp_repository' => 'Armazenamento FTP',
    'backup__ftp_login' => 'Nome do usuário',
    'backup__ftp_password' => 'Senha',
    'backup__ftp_account_settings' => 'Configurações da conta FTP',
    'backup__ftp_account_preferences' => 'Configurações da conta FTP',
    'backup__repository_not_exist' => 'O diretório não existe.',
    'backup__repository_not_readable' => 'O diretório especificado não é legível',
    'backup__ftp_repository_not_configure' => 'Para usar um armazenamento de backup em FTP, <a href="%1">primeiro especifique a conta FTP.</a>',
    'backup__ftp_repository_list_not_configure' => 'As configurações de conta não foram especificadas',
    'backup__repository_list_unable_listing' => 'Não é possível recuperar a lista de arquivos',
    'backup__ftp_repository_unable_listing' => 'Não é possível recuperar a listagem do diretório "%1": ',
    'backup__repository_legend' => 'Armazenamento de arquivos de backup',
    'backup__store_in_repository' => 'Armazenar arquivos em',
    'backup__local_repository_lable' => 'Disco local',
    'backup__ftp_repository_lable' => 'Armazenamento FTP',
    'backup__ftp_repository_not_configure_hint' => '(as configurações de conta não estão especificadas)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(A conta FTP não está especificada ou não é suportada)',
    'backup__other_user_process_modified' => 'Outro usuário interrompeu o processo de backup ou migração.',
    'backup__another_user_exist' => 'A operação em andamento foi iniciada por outro usuário do Plesk. Este usuário ainda está conectado ao Plesk.',
    'backup__ftp_repository_wait' => 'Aguarde enquanto as informações sobre o armazenamento FTP são recuperadas',
    'backup__ftp_write_test_failed' => 'Falha ao gravar dados de teste na conta FTP %1: ',
    'backup__ftp_storage' => 'Armazenamento do FTP(S)',
    'bt_upload_to_repository' => 'Fazer upload de arquivos para o armazenamento local',
    'bt_new_restore' => "Restaurar",
    'bt_backup_schedule' => "Programar backup",
    'backup_exist_backups' => "Arquivos de backup existentes",
    'backup_dialog__page_title' => "Criação de arquivo de backup",
    'backup_dialog__please_wait' => "O processo de backup está prestes a iniciar. Esta operação pode levar algum tempo. Aguardar...",
    'backup_conf__page_title' => 'Configuração de backup',
    'bt_accept' => "Aceitar",
    'bt_access' => "Acesso",
    'bt_action_log' => "Registro de ações",
    'bt_add' => "Adicionar",
    'bt_add_client' => "Atribuir aos usuários",
    'bt_database_server_add' => 'Adicionar servidor de banco de dados',
    'bt_add_services' => "Adicionar serviços",
    'bt_anonftp_stats' => "Estatísticas de Anon.FTP",
    'bt_anonymous_ftp' => "FTP anônimo",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Anexar",
    'bt_autoinstaller' => 'Atualizador',
    'bt_auto-updates' => 'Atualizador',
    'bt_back' => "<< Voltar",
    'bt_backup' => "Fazer backup",
    'bt_backup_configure' => "Configurações de backup",
    'bt_buy_certs' => "Comprar certificados",
    'bt_card' => "Cartão",
    'bt_cert' => "Certificado",
    'bt_certificates' => "Certificados",
    'bt_change_passwd' => "Alterar senha",
    'bt_clear' => "Remover",
    'bt_client_templates' => "Modelos de cliente",
    'bt_clients' => "Clientes",
    'bt_codepage_change' => 'Alterar codificação',
    'bt_comp_info' => "Gerenciamento de componentes",
    'bt_configure_maillists' => "Configurar o Mailman",
    'bt_configure' => 'Configurar',
    'bt_copy' => "Copiar",
    'bt_copy_move' => "Copiar/mover",
    'bt_create' => "Criar",
    'bt_create_account' => "Criar uma Conta",
    'bt_create_dir' => "Adicionar um Diretório",
    'bt_create_file' => "Adicionar um arquivo",
    'bt_count_size' => "Calcular o tamanho",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Agendador de tarefas",
    'bt_custom_button_new' => "Adicionar um botão",
    'bt_custom_buttons' => "Botões customizados",
    'bt_customize' => "Customizar",
    'bt_databases' => "Bancos de dados",
    'bt_database_servers' => 'Servidores do banco de dados',
    'bt_sqlservers' => "Servidores do banco de dados",
    'bt_db_usr_new' => "Adicionar um usuário da base de dados",
    'bt_db_new' => "Adicionar uma Base de Dados",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Tornar padrão para DB Webadmin",
    'bt_decline' => "Rejeitar",
    'bt_default' => "Padrão",
    'bt_defaultcomponents' => "Serviços de terceiros",
    'bt_defaults' => "Padrões",
    'bt_delete' => "Remover",
    'bt_directories' => "Diretórios protegidos",
    'bt_disable' => "Desativar",
    'bt_dns_zone_sync' => 'Aplicar as alterações do modelo DNS',
    'bt_dnsrecord_add' => 'Adicionar registro',
    'bt_do_backup' => "Fazer backup",
    'bt_do_restore' => "Restaurar",
    'bt_do_upload' => "Upload",
    'bt_domain_aliases' => "Nomes alternativos de domínio",
    'bt_domain_templates' => "Modelos de domínio",
    'bt_domain_user' => "Administrador de domínio",
    'bt_domain_user_passwd' => "Senha do administrador de domínio",
    'bt_domains' => "Domínios",
    'bt_domain_alias_add' => 'Adicionar nomes alternativos de domínio',
    'bt_download' => "Download",
    'bt_edit' => "Editar",
    'bt_enable' => "Ativar",
    'bt_export' => 'Exportar',
    'bt_extras' => "Extras",
    'bt_finish' => "Encerrar",
    'bt_ftp_account' => "Propriedades da conta FTP",
    'bt_forget_password' => "Esqueceu a senha?",
    'bt_fp_ssl_webadmin' => "Webadmin FP-SSL/TLS",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Estatísticas de FTP",
    'bt_get_password' => "Obter senha",
    'bt_global_changes' => "Modificar",
    'bt_help' => "Ajuda",
    'bt_hide_aliases' => "Ocultar nomes alternativos",
    'bt_hide_toolbar' => 'Ocultar barra de ferramentas',
    'bt_hide_subdomains' => "Ocultar subdomínios",
    'bt_hide_domainaliases' => "Ocultar nomes alternativos de domínio",
    'bt_home' => "Página inicial",
    'bt_hosting' => "Hospedagem",
    'bt_icf' => 'Firewall',
    'bt_install' => "Instalar",
    'bt_ip_aliasing' => "Endereços IP",
    'bt_ip_add' => "Adicionar endereço IP",
    'bt_ip_pool' => "Pool de IP",
    'bt_key_info' => "Informações de licença",
    'bt_key_buyonline_addons' => 'Fazer pedido de complementos para o Plesk',
    'bt_key_buyonline_upgrades' => 'Fazer pedido de upgrades para o Plesk',
    'bt_key_buyonline_new' => 'Fazer pedido de nova chave',
    'bt_limits' => "Limites",
    'bt_locale_add' => 'Adicionar localidade',
    'bt_locales' => 'Localidades',
    'bt_log_manager' => "Gerenciador de logs",
    'bt_login' => "Login",
    'bt_logo' => "Marca",
    'bt_logo_send_link' => "Anexar um link",
    'bt_logo_send_logo' => "Anexar logo",
    'bt_logout' => "Logout",
    'bt_logrotation' => "Rotação do Logs",
    'bt_mail' => "E-mail",
    'bt_mail_alias_add' => "Adicionar Alias do E-mail",
    'bt_mail_aliases' => "Nomes alternativos de e-mail",
    'bt_mail_group_add' => "Adicionar Membro",
    'bt_mail_groups' => "Grupos",
    'bt_mail_name_add' => "Adicionar Conta do E-mail",
    'bt_mail_preferences' => "Configurações",
    'bt_mail_group' => "Grupo de e-mail",
    'bt_mail_mailbox' => "Caixa postal",
    'bt_mail_redirect' => "Página de redirecionamento",
    'bt_mail_resp_add' => "Adicionar Resposta Automática",
    'bt_mail_resp_attach_add' => "Adicionar Anexo",
    'bt_mail_resp_files' => "Arquivos anexos",
    'bt_mail_responders' => "Respostas automáticas",
    'bt_mail_spamfilter' => "Filtro de spam",
    'bt_mail_webmail' => "WebMail",
    'bt_maillist_new' => "Adicionar Lista de Correspondência",
    'bt_maillists' => "Mala direta",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Criar backup",
    'bt_manage' => "Gerenciar",
    'bt_master' => "Mestre",
    'bt_migrate' => 'Migrar',
    'bt_modules_add' => 'Adicionar módulo',
    'bt_modules_manage' => 'Gerenciar extensões',
    'bt_move' => "Mover",
    'bt_new_client' => "Adicionar Conta do Cliente",
    'bt_new_domain' => "Adicionar Domínio",
    'bt_next' => "Seguinte >>",
    'bt_next_page' => "Próximo",
    'bt_network_add' => "Adicionar Rede",
    'bt_notifications' => "Notificações",
    'bt_off' => "Desligar",
    'bt_on' => "Ligar",
    'bt_on_off' => "Liga / Desliga",
    'bt_performance' => 'Desempenho',
    'bt_permissions' => "Permissões",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Configurações",
    'bt_prev_page' => "Prev",
    'bt_preview' => 'Visualização do site',
    'bt_print' => "Impressão",
    'bt_reboot' => "Reiniciar",
    'bt_reload' => "Recarregar",
    'bt_refresh' => "Atualizar",
    'bt_register' => "Registrar",
    'bt_remove' => "Remover",
    'bt_enable_selected' => 'Ativar',
    'bt_disable_selected' => 'Desativar',
    'bt_repair_ip' => "Reparar IP",
    'bt_report' => "Relatório",
    'bt_report_new' => "Adicionar Layout",
    'bt_reset' => "Reinicializar",
    'bt_restart_services' => "Gerenciamento de serviços",
    'bt_save' => "Salvar",
    'bt_send_by_email' => "Envie por e-mail",
    'bt_send_file' => "Enviar arquivo",
    'bt_send_mail' => "Enviar e-mail",
    'bt_send_passwd' => "Enviar senha",
    'bt_send_text' => "Enviar texto",
    'bt_server' => "Servidor",
    'bt_server_add' => "Adicionar Servidor",
    'bt_server_preferences' => "Configurações do servidor",
    'bt_servers_list' => "Servidores",
    'bt_sessions' => "Sessões",
    'bt_set' => "Ajustar",
    'bt_set_as_default' => "Definir como padrão",
    'bt_setup' => 'Configuração',
    'bt_show_aliases' => "Mostrar nome alternativos",
    'bt_show_subdomains' => "Mostrar subdomínios",
    'bt_show_domainaliases' => "Mostrar nomes alternativos de domínio",
    'bt_shutdown' => "Desligar",
    'bt_site_apppkgs' => "Cofre de aplicativos",
    'bt_site_apppool' => "Pool de aplicativos",
    'bt_application-pool' => "Aplicativos da web",
    'bt_site_apps' => "Aplicativos da web",
    'bt_site_app_add' => "Instalar aplicativo",
    'bt_site_builder' => "Suporte ao Presence Builder",
    'bt_skeleton' => 'Modelo de host virtual',
    'bt_skins' => 'Skins',
    'bt_skin_add' => 'Adicionar Capa',
    'bt_skin_manual' => 'Personalizar referência de skins do Plesk', // not used
    'bt_skin_download' => 'Fazer o download de skin',
    'bt_skin_replace' => 'Atualizar skin',
    'bt_skip' => 'Pular',
    'bt_spamassassin' => "Filtro de spam",
    'bt_spamassassin_train' => "Treinamento",
    'bt_spamfilter' => "Filtro de spam",
    'bt_start' => "Iniciar",
    'bt_stop' => "Interromper",
    'bt_recycle' => "Reciclar",
    'bt_statistics' => "Estatísticas",
    'bt_subdomain_new' => "Adicionar Subdomínio",
    'bt_subdomains' => "Subdomínios",
    'bt_submit' => "Enviar",
    'bt_summary_report' => "Relatório resumido",
    'bt_support' => "Suporte",
    'bt_switch' => "Botão",
    'bt_system_time' => "Horário do sistema",
    'bt_task_new' => "Adicionar tarefa",
    'bt_dom_tmpl_add' => 'Adicionar Modelo do Domínio',
    'bt_cl_tmpl_add' => 'Adicionar um modelo do cliente',
    'bt_cron_backup' => 'Configurações de backup programado',
    'bt_test' => "Conexão de teste",
    'bt_text' => "Texto",
    'bt_touch' => "Alterar o carimbo de data/hora",
    'bt_traffic' => "Tráfego",
    'bt_traffic_history' => "Histórico de tráfego",
    'bt_update' => "Atualizar",
    'bt_upload' => "Upload",
    'bt_upload_from_ftp' => "Upload de FTP",
    'bt_virtualdirs' => 'Diretórios virtuais',
    'bt_virtualdir_new' => 'Adicionar Diretório Virtual',
    'bt_virtualdir_add' => 'Adicionar Diretório Virtual',
    'bt_web_app_new' => "Instalar aplicativo Java",
    'bt_web_stats' => "Estatísticas da web",
    'bt_web_stats_ssl' => "Estatísticas da web SSL/TLS",
    'bt_web_user_add' => "Adicionar Usuário da Web",
    'bt_web_users' => "Usuários da web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Consulte a lista completa de alterações",
    'cert_add__unable_set_ca_cert' => "Não é possível definir o certificado CA: %1",
    'cert_add__unable_set_cert' => "Não é possível definir o certificado: %1",
    'cert_add__unable_set_private_key' => "Não é possível definir a chave privada: %1",
    'certificates_list__certificate_used_as_default' => "um dos certificados que você pretende excluir é usado como o Certificado Padrão.",
    'certificates_list__certificates_assigned_on_ip' => "um ou vários certificados estão atribuídos para os endereços IP/domínios.",
    'ch_pass__admin_pass' => "Alteração da senha do administrador",
    'ch_pass__old_pass' => "Senha antiga",
    'ch_pass__pass_confirm' => "Confirme",
    'ch_pass__unable_change_admin_pass' => "Não é possível alterar a senha do administrador: %1",
    'check_mail_cycle__aliases' => "Ciclo de e-mail detectado, o endereço \"%1\" está contido nos nomes alternativos desta conta de e-mail.",
    'check_mail_cycle__autoresponders' => "Ciclo de e-mail detectado, o endereço \"%1\" está contido nas respostas automáticas desta conta de e-mail.",
    'check_mail_cycle__mail_groups' => "Ciclo de e-mail detectado, o endereço \"%1\" está contido no grupo de e-mail desta conta de e-mail.",
    'check_mail_cycle__mail_name' => "Ciclo de e-mail detectado, o endereço \"%1\" coincide com esta conta de e-mail.",
    'check_mail_cycle__redirect' => "Ciclo de e-mail detectado, o endereço \"%1\" coincide com o encaminhador desta conta de e-mail.",
    'check_mail_dup__redirect' => "O redirecionamento duplicado foi detectado, o endereço \"%1\" coincide com o endereço de redirecionamento desta conta de e-mail.",
    'check_mail_dup__mail_groups' => "O redirecionamento duplicado foi detectado, o endereço \"%1\" está contido no grupo de e-mail desta conta de e-mail.",
    'check_maillist_cycle__admin' => "Ciclo de e-mail detectado, o e-mail \"%1\" do administrador coincide com o endereço de uma mala direta.",
    'check_maillist_cycle__member' => "Ciclo de e-mail detectado, o endereço \"%1\" coincide com o endereço de uma mala direta.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detalhes da conta de %1",
    'cl_limits__cl' => "Limites do cliente %1",
    'cl_logo__setup_logo_pref' => "Definir propriedades de logotipo para o cliente %1",
    'cl_new__enter_new_cl_data' => "Inserir as informações no novo cliente",
    'cl_new__unable_to_sent_notification' => 'A conta de usuário foi criada, no entanto, houve uma falha no envio de notificação ao cliente: %1',
    'cl_perm__all_ip' => "Todos os IPs disponíveis",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Todas as contas de hospedagem com base em IP para o cliente serão transferidas com base em nome.",
    'cl_perm__allow_client_create_domain' => "Os campos que você está tentando selecionar só são aplicáveis aos clientes que têm permissão para criar domínios.",
    'cl_perm__allow_create_nb_w_ip' => "O cliente pode criar hospedagem com base em nome usando %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Permitir a criação de contas de hospedagem com base em IP",
    'cl_perm__available_ips' => "IPs disponíveis",
    'cl_perm__change_limits' => "Ajuste de limites",
    'cl_perm__cl_disk_space' => "Espaço total disponível em disco",
    'cl_perm__cl_expiration' => "Período de validade de conta de cliente",
    'cl_perm__cl_max_box' => "Caixas de e-mail",
    'cl_perm__cl_max_db' => "Bancos de dados",
    'cl_perm__cl_max_dom' => "Domínios",
    'cl_perm__cl_max_maillists' => "Mala direta",
    'cl_perm__cl_max_subdom' => "Subdomínios",
    'cl_perm__cl_max_traffic' => "Quantidade total de tráfego disponível",
    'cl_perm__cl_max_wu' => "Usuários da web",
    'cl_perm__cl_mbox_quota' => "O limite do tamanho de caixa de correio para esta conta de usuário",
    'cl_perm__current_maximum_exp_date' => "O valor atual máximo do período de validade do domínio é %1; o necessário é %2.",
    'cl_perm__current_maximum_mailbox_quota' => "O limite atualmente definido para a quantidade de espaço em disco alocada para abrigar as caixas de correio nessa conta de usuário é %1; o necessário é %2",
    'cl_perm__current_total_requested' => "O valor total atual de limites de domínio para %1 é %2; o necessário é %3.",
    'cl_perm__current_total_requested_dom' => "O número atual de %1 pertencente a este cliente é %2; o necessário é %3.",
    'cl_perm__disk_space' => "quantidade máxima de espaço em disco",
    'cl_perm__dashboard_stdgui' => 'Interface de usuário',
    'cl_perm__dashboard' => 'Visualização da página inicial',
    'cl_perm__stdgui' => 'Modo de exibição padrão',
    'cl_perm__manage_dashboard' => 'Gerenciamento de página inicial',
    'cl_perm__dashboard_and_stdgui' => 'Visualização da página inicial e visualização-padrão são permitidas',
    'cl_perm__dashboard_only' => 'Apenas a visualização da página inicial é permitida',
    'cl_perm__stdgui_only' => 'Somente o modo de exibição padrão é permitido',
    'cl_perm__edit_cl' => "Permissões do cliente %1",
    'cl_perm__exp_date_exceeded' => "O período de validade que você está tentando definir ultrapassa o limite especificado nos domínios individuais relacionados a este cliente.",
    'cl_perm__invalid_value' => "Valor inválido, apenas dígitos são permitidos.",
    'cl_perm__limit_disk_space' => "%1 Limitar a quantidade total de espaço em disco",
    'cl_perm__limit_expiration' => "%1 Limitar o período de validade para a conta de cliente",
    'cl_perm__limit_max_box' => "%1 Limitar o número máximo de caixas de correio",
    'cl_perm__limit_max_db' => "%1 Limitar o número máximo de bancos de dados",
    'cl_perm__limit_max_dom' => "%1 Limitar o número máximo de domínios",
    'cl_perm__limit_max_maillists' => "%1 Limitar o número máximo de malas diretas",
    'cl_perm__limit_max_subdom' => "%1 Limitar o número máximo de subdomínios",
    'cl_perm__limit_max_traffic' => "%1 Limitar a quantidade total de tráfego",
    'cl_perm__limit_max_wu' => "%1 Limitar o número máximo de usuários da web",
    'cl_perm__limit_mbox_quota' => "%1 Definir a cota de caixa de correio",
    'cl_perm__limits_exceeded' => "Um ou vários limites que você está tentando definir já foram ultrapassados pelos limites definidos nos domínios individuais que pertencem a este cliente.\nO limite total para o cliente deve ser maior ou igual à soma total dos limites de domínio definidos para esta conta de cliente.",
    'cl_perm__mailbox_quota_exceeded' => "O limite da quantidade de espaço em disco alocado para as caixas de correio que você está tentando definir ultrapassa o limite definido nos domínios individuais relacionados a esta conta de cliente.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "O limite da quantidade de espaço em disco alocado para as caixas de correio que você está tentando definir ultrapassa a limitação imposta no nível do servidor.",
    'cl_perm__make_dumps' => "Fazer backup e restaurar dados",

    'cl_perm__max_box' => "número máximo de caixas de correio",
    'cl_perm__max_db' => "número máximo de bancos de dados",
    'cl_perm__max_dom' => "domínios",
    'cl_perm__max_maillists' => "número máximo de malas diretas",
    'cl_perm__max_subdom' => "subdomínios",
    'cl_perm__max_traffic' => "quantidade máxima de tráfego",
    'cl_perm__max_wu' => "número máximo de usuários da web",
    'cl_perm__max_dom_aliases' => "nomes alternativos de domínio",
    'cl_perm__mbox_quota' => "cota da caixa de correio",
    'cl_perm__not_allow_create_nb_hst' => "O cliente não pode criar hospedagem com base em nome.",
    'cl_perm__this_ip_used_vrt_hst' => "Esse endereço IP é usado por hospedagem virtual.\nPara excluir este endereço IP, remova o serviço de hospedagem ou altere seu tipo para com base em nome.",
    'cl_perm__unable_off_ipb_creating' => "O cliente já tem o serviço de hospedagem com base em IP configurado. Para desativar esse recurso para o cliente, desmarque a caixa de seleção \"Criação de domínio\" ou remova todas as contas de hospedagem com base em IP.",
    'cl_perm__unable_off_nb_creating' => "O cliente já tem o serviço de hospedagem com base em nome configurado. Para desativar esse recurso para o cliente, desmarque a caixa de seleção \"Criação de domínio\" ou remova todas as contas de hospedagem com base em nome.",
    'cl_perm__unable_set_domain_limit' => "Não é possível limitar o número máximo de domínios: o cliente já tem %1 domínios",
    'cl_perm__unable_update_client_limitations' => "Não é possível modificar os limites da conta de cliente: %1",
    'cl_pref__edit_cl' => "Preferências do cliente %1",
    'class_anonftp__create_ftp_domain' => "Nenhum domínio de FTP virtual para esta dom_id, tente criá-lo primeiro.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "O limite de espaço em disco que você está tentando definir (%1) não deve exceder o limite total de espaço em disco definido no nível do domínio (%2).",
    'class_anonftp__invalid_input_only_digits' => "Valor inválido especificado, apenas dígitos são permitidos.",
    'class_anonftp__unable_change_ownerships' => "Não é possível alterar a propriedade ou permissões para o arquivo de cota: %1",
    'class_anonftp__unable_copy_quota_file' => "Não foi possível copiar o arquivo de cota: %1",
    'class_anonftp__unable_get_disk_usage' => "Não é possível recuperar informações de uso de disco no diretório de entrada: %1",
    'class_anonftp__unable_parse_quota_file' => "Não foi possível analisar o arquivo de cota.",
    'class_anonftp__unable_read_quota_file' => "Não foi possível ler o arquivo de cota: %1",
    'class_anonftp__unable_update_quota' => "Não é possível atualizar cota: os arquivos no diretório de entrada usam %1 KBs de espaço em disco, o que excede o novo valor de cota.",
    'class_anonftp__unable_write_temp_file' => "Não é possível gravar o arquivo temporário: %1",
    'class_bsdomain__warn_max_date__' => "A data de validade foi definida para %1",
    'class_client__client_creation_notification' => "Aviso de criação do cliente.",
    'class_client__client_with_contact_name_already_exists' => "Já existe um cliente com o nome %1.",
    'class_client__disk_space' => "Espaço em disco",
    'class_client__invalid_max_dom' => "Valor inválido do número de domínios, apenas dígitos são permitidos.",
    'class_client__limit_exceed' => "Não é possível alocar a quantidade solicitada de %1, porque isso excederia as alocações para a conta do cliente %2 (%3). Se você deseja alocar mais recursos, vá para Clientes > nome do cliente > Limites e altere as alocações conforme necessário. Em seguida, retorne a esta tela e tente ajustar novamente as alocações.",
    'class_client__limit_exceed_unlimited' => "Se você deseja alocar a quantidade ilimitada de recursos (%1), primeiro você deve ir para Clientes > nome do cliente > Limites e marcar a caixa de seleção Ilimitada correspondente ao tipo de recurso necessário. Em seguida, retorne a esta tela e tente ajustar novamente as alocações.",
    'class_client__max_box' => "Caixas de e-mail",
    'class_client__max_db' => "Bancos de dados",
    'class_client__max_maillists' => "Mala direta",
    'class_client__max_subdom' => "Subdomínios",
    'class_client__max_traffic' => "Tráfego máximo",
    'class_client__max_wu' => "Usuários da web",
    'class_client__max_dom_aliases' => "Nomes alternativos de domínio",
    'class_client__mbox_quota' => "Cota da caixa de correio",
    'class_client__unable_define_cl_status' => "Não é possível definir o status da conta de cliente: %1",
    'class_client__unable_define_inactive_dom' => "Não é possível definir domínios inativos %1.",
    'class_client__unable_del_ip' => "Não é possível remover IPs: %1",
    'class_db__db_name_not_set' => "O nome do banco de dados não está definido.",
    'class_db__db_not_exist_for_curr_dom' => "O banco de dados não existe para este domínio.",
    'class_db__invalid_db_or_dom_name' => "O ID do banco de dados ou domínio é inválido ou o nome do banco de dados não está definido.",
    'class_db__invalid_pass' => "A senha é inválida.",
    'class_db__mailgrp_member_exist' => "O membro do grupo de e-mail já existe.",
    'class_db__access_hosts_notsupport' => 'A configuração de hosts de acesso não é suportada para este tipo de banco de dados',
    'class_db__unable_add' => 'Não é possível adicionar o registro de host de acesso: %1',
    'class_db__unable_del' => 'Não é possível excluir o registro de host de acesso: %1',
    'class_db__inc_user_not_exist' => 'O usuário de banco de dados "%1" não existe',
    'class_db__inc_access_record_exist' => 'Este registro de acesso já existe',
    'class_db__inc_access_record_not_exist' => 'O registro de acesso dado não existe',
    'class_db__inc_unable_del_last_record' => 'Não é possível eliminar o último registro de host de acesso',
    'class_domtmpleditform__dns_master' => "Primário",
    'class_domtmpleditform__dns_slave' => "Secundário",
    'class_domtmpleditform__dns_type' => "Tipo de zona DNS do domínio",
    'cmd_dns__a_dns_record_already_exist' => "Este registro irá conflitar com o registro A para a zona.",
    'cmd_dns__domain_last_ns' => 'Não é possível excluir o último registro NS DNS do domínio.',
    'cmd_dns__canonical_dom_name_is_invalid' => "O nome de domínio canônico é inválido.",
    'cmd_dns__cname_dns_record_already_exist' => "Este registro irá conflitar com o registro CNAME para a zona.",
    'cmd_dns__cname_in_rr_combination' => 'Uma combinação incorreta de registros DNS está presente na zona DNS',
    'cmd_dns__cname_coexist_with_data' => 'O registro de zona DNS CNAME não pode coexistir com outros registros DNS na mesma zona.',
    'cmd_dns__dns_record_type_is_invalid' => "O tipo de registro de DNS é inválido.",
    'cmd_dns__ext_host_is_not_resolved' => "O nome canônico %1 não soluciona um registro A ou AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Não é possível adicionar o registro %1 à zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "O nome do servidor de mensagens é inválido.",
    'cmd_dns__mx_priority_is_invalid' => "A prioridade MX é inválida.",
    'cmd_dns__name_server_is_invalid' => "O servidor de nomes é inválido.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "O valor da máscara de rede deve ser 24, 16 ou 8.",
    'cmd_dns__this_dns_record_already_exists' => "Esse registro DNS A já existe.",
    'cmd_dns__unable_add_record' => "Não é possível adicionar registro '%1': %2",
    'cmd_dns__unable_add_a_record' => "Não é possível adicionar registro A: %1",
    'cmd_dns__unable_add_cname_record' => "Não é possível adicionar registro CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Não é possível adicionar registro DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Não é possível adicionar registro EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Não é possível adicionar registro NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Não é possível adicionar registro PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Não é possível adicionar registro TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Não é possível criar a zona DNS %1",
    'cmd_dns__unable_define_dns_record' => "Não é possível definir o registro DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Não é possível recuperar o status de zona DNS padrão: %1",
    'cmd_dns__unable_insert_a_record' => "Não é possível inserir registro A: %1",
    'cmd_dns__unable_insert_mx_record' => "Não é possível inserir registro MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Não é possível inserir registro NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Não é possível definir o status de zona DNS: %1",
    'cmd_domains__dom_already_exists' => "O domínio %1 já existe.",
    'cmd_domains__dns_record_already_exists' => "Não é possível criar o domínio %1 porque um registro DNS apontando para o host %1 já existe.",
    'cmd_domains__dom_already_exists1' => "Existem %2 subdomínios neste domínio. O domínio %1 já existe.",
    'cmd_domains__dom_already_exists2' => "O subdomínio %1 já existe.",
    'cmd_domains__dalias_already_exists' => "Esse nome alternativo já existe.",
    'cmd_domains__domain_alias_already_exists' => 'O alias de domínio com esse nome já existe.',
    'cmd_domains__unable_del_mail_for_dom' => "Não é possível excluir os serviços de e-mail para o domínio: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Não é possível excluir a conta FTP anônima para o domínio:  %1",
    'cmd_domains__unable_update_dom_param' => "Não é possível atualizar os parâmetros de domínio: %1.",
    'cmd_domains__unable_rename_client_exist' => "o nome de usuário do administrador de domínio já está em uso.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "O tipo de hospedagem não é físico.",
    'cmd_hosting__unable_create_user' => "Não é possível criar usuário %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Não é possível definir endereço IP para os hosts virtuais com base em nome: %1",
    'cmd_hosting__unable_del_old_hst' => "Não é possível excluir a hospedagem previamente configurada: %1",
    'cmd_hosting__unable_del_protected_directory' => "Não é possível excluir o diretório protegido: %1.",
    'cmd_hosting__unable_del_web_user' => "Não é possível excluir o usuário da web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Não é possível criar ou atualizar o Virtual Host: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Não é possível configurar a hospedagem de encaminhamento de quadro.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Não é possível recriar o arquivo de configuração proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Não é possível configurar SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Não é possível remover a proteção do diretório SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Não é possível atualizar a URL de destino %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Não é possível atualizar a zona DNS para o domínio: falha na execução de utilitário.",
    'cmd_hosting__unable_update_ftp_passwd' => "Não é possível atualizar a senha FTP %1.",
    'cmd_hosting__unable_update_user' => "Não é possível atualizar usuário %2: %1",
    'cmd_hosting__unknown_hst_type' => "Tipo de hospedagem desconhecido.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Você não tem permissão para encerrar o serviço de hospedagem.",
    'cmd_mail__autoresponder__not_configured' => "A resposta automática para esta conta de e-mail não foi configurada",
    'cmd_mail__addr_already_used_in_mail_redirect' => "O endereço %1 já está sendo usado para encaminhamento de e-mail.",
    'cmd_mail__alias_already_exists' => "o nome alternativo já existe.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "A ID da resposta automática e a ID da conta de e-mail não coincidem.",
    'cmd_mail__autoresp_id_is_undefined' => "A ID da resposta automática está indefinida.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "O nome alternativo de e-mail com esse nome já existe para a conta de e-mail %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "A conta de e-mail %1 já está inscrita nesta mala direta.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "A conta de e-mail %1 já existe nesse domínio.",
    'cmd_mail__mail_name_not_exist' => "A conta de e-mail não existe.",
    'cmd_mail__mail_name_passwd_part' => "O nome da conta de e-mail não deve fazer parte da senha.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "A mala direta %1 já existe nesse domínio.",
    'cmd_mail__mailname_already_exist_in_mg' => "A conta de e-mail %1 já está em um grupo de e-mail.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "A conta de e-mail %1 já existe nesse domínio.",
    'cmd_mail__mailname_already_exists' => "A conta de e-mail já existe.",
    'cmd_mail__mailname_is_invalid' => "O nome da conta de e-mail %1 é inválido.",
    'cmd_mail__mailname_unable_update' => "Não é possível atualizar as propriedades de conta de e-mail:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "O número máximo de respostas automáticas foi atingido para este domínio.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "O número máximo de grupos de e-mail foi atingido para este domínio.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "O número máximo de encaminhadores foi atingido para este domínio.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "O número máximo de caixas de correio foi atingido.",
    'cmd_mail__no_members_specified' => "nenhum membro especificado.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "A senha é muito simples, escolha outra.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Este endereço de e-mail já está sendo usado.",
    'cmd_mail__unable_define_autoresp_id' => "Não é possível definir a ID de resposta automática %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Falha ao alterar as configurações de serviço de e-mail para o domínio %1",
    'cmd_mail__unable_del_mail_for_dom' => "Não é possível remover o serviço de e-mail do domínio %1.",
    'cmd_mail__unable_del_mail_redirection' => "Não é possível remover o serviço de encaminhamento de e-mail %1.",
    'cmd_mail__unable_remove_autoresp' => "Não é possível remover respostas automáticas: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Não é possível remover os membros do grupo de e-mail: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Falha ao desativar o grupo de e-mail: %1",
    'cmd_mail__unable_update_mail_redirect' => "Não é possível reconfigurar o serviço de encaminhamento de e-mail %1.",
    'cmd_mail__uploaded_file_is_too_big' => "O tamanho do arquivo carregado é muito grande.",
    'cmd_mail__additionally' => "Além disso: ",
    'cmd_pd__invalid_login' => "Nome de usuário incorreto.",
    'cmd_pd__this_user_already_exist' => "Esse usuário já existe.",
    'cmd_pd__unable_define_hst_type' => "Não é possível definir o tipo de hospedagem.",
    'cmd_pd__unable_upd_pd_usr' => "Não é possível atualizar as propriedades de usuário do diretório protegido:  %1.",
    'cmd_pd__user_is_undefined' => "O usuário está indefinido.",
    'cmd_server__no_enough_free_disk_space' => "Não há espaço em disco.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "a senha antiga está incorreta. Tente de novo.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "o limite máximo de usuários web foi atingido para este domínio.",
    'cmd_web_usr__unable_create_user' => "não é possível criar usuário do sistema: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "não é possível definir o limite máximo de usuários da web: %1",
    'cmd_web_usr__user_already_exists' => "o usuário já existe.",
    'cmd_web_usr__web_user_name_is_invalid' => "o nome de usuário da web %1 é inválido.",
    'cmd_web_usr__web_user_not_exist' => "o usuário da web não existe.",
    'common_func__exec_bad_argument' => "o argumento exec não deve conter o símbolo de aspas simples.",
    '__eol' => 'Quebras de linha',
    'eol__binary_file' => 'Não é possível alterar o estilo de quebra de linha no arquivo binário.',
    'cp_access_admin_deny' => "O acesso para administrador do endereço '%1' é restrito em conformidade com a diretiva de restrição de acesso IP atualmente aplicada.",
    'create_domain_warn__' => "As exceções a seguir foram feitas durante a criação do domínio:",
    'create_domain__client_select' => 'Selecione o cliente para criar o domínio para',

    'dashboard__nav_button_name' => "Página inicial",
    'dalias__list_title' => 'Nomes alternativos de domínio do domínio %1',
    'dalias__list_legend' => 'Nomes alternativos de domínio',
    'dalias__list_header' => 'Nomes alternativos de domínio',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Nome alternativo do domínio',
    'dalias__list_ascii_name' => 'Em formato ASCII',
    'dalias__remove_title' => 'Os seguintes nomes alternativos de domínio para o domínio %1 serão removidos:',
    'dalias__select_domain_aliases_to_remove' => 'Selecione os nomes alternativos de domínio a serem removidos.',
    'dalias__mail_turn_on_failed' => 'Não é possível ativar o serviço de e-mail: %1',
    'dalias__web_turn_on_failed' => 'Não é possível ativar o serviço da web: %1',
    'db_usr_edit__db_usr_name_old' => "Nome de usuário de banco de dados antigo",
    'database_server_edit_form__cannot_infer_type' => 'Não é possível inferir o método de conexão dos dados fornecidos. Especifique "127.0.0.1" como o nome do host do servidor de banco de dados para conectar-se por TCP/IP com a porta fornecida ou deixe o campo da porta vazio para usar o soquete Unix "%1".',
    'database_server_edit_form__duplicate' => 'Um servidor de banco de dados com esta combinação de número de porta e endereço de host já está registrado.',
    'database_server_edit_form__host_is_invalid' => 'O nome do host especificado não é válido.',
    'database_server_edit_form__port_is_invalid' => 'O número de porta especificado não é válido.',
    'database_server_error__consult_admin' => 'Entre em contato com o administrador do servidor.',
    'database_server_error__last__connection_failed' => 'A última tentativa para controlar esse servidor de banco de dados falhou por causa de problemas de rede.',
    'database_server_error__last__permission_denied' => 'A última tentativa para controlar este servidor de banco de dados falhou porque a conta fornecida não possui privilégios administrativos.',
    'database_server_error__last__credentials_not_set' => "A última tentativa para se conectar a este servidor falhou, pois não foram especificados um nome de usuário e uma senha de administrador válidos.",
    'database_server_error__last__other_error' => 'A última tentativa para controlar este servidor de banco de dados falhou.',
    'database_server_error__real__connection_failed' => 'A conexão com o servidor de banco de dados falhou por causa de problemas de rede:',
    'database_server_error__real__permission_denied' => 'Falha na conexão com o servidor de banco de dados porque a conta fornecida não possui privilégios administrativos:',
    'database_server_error__real__duplicate_object' => 'A conexão com o servidor de banco de dados falhou por causa de um conflito de nome:',
    'database_server_error__real__unacceptable_name' => 'A conexão com o servidor de banco de dados falhou por causa de um nome de objeto inválido:',
    'database_server_error__real__unacceptable_password' => 'A conexão com o servidor de banco de dados falhou por causa de uma senha inaceitável:',
    'database_server_error__real__credentials_not_set' => "O Plesk não pode se conectar ao servidor de banco de dados porque não foram especificados um nome de usuário e uma senha de administrador válidos.",
    'database_server_error__real__other_error' => 'Falha na conexão com o servidor de banco de dados:',
    'database_server_error__test__connection_failed' => 'A conexão de teste com o servidor de banco de dados falhou por causa de problemas de rede:',
    'database_server_error__test__permission_denied' => 'Falha na conexão de teste com o servidor de banco de dados porque a conta fornecida não possui privilégios administrativos:',
    'database_server_error__test__duplicate_object' => 'A conexão de teste com o servidor de banco de dados falhou por causa de um conflito de nome:',
    'database_server_error__test__unacceptable_name' => 'A conexão de teste com o servidor de banco de dados falhou por causa de um nome de objeto inválido:',
    'database_server_error__test__unacceptable_password' => 'A conexão de teste com o servidor de banco de dados falhou por causa de uma senha inaceitável:',
    'database_server_error__test__credentials_not_set' => "A teste de conexão para este servidor falhou, pois não foram especificados um nome de usuário e uma senha de administrador válidos.",
    'database_server_error__test__other_error' => 'Falha na conexão de teste com o servidor de banco de dados:',

    'db__create_new_db' => "Adicionar uma Base de Dados",
    'db__db_add' => "Adicionar Base de Dados",
    'db__db_for_dom' => "Bancos de dados do site %1",
    'db__db_id_undefined' => "A ID do banco de dados está indefinida.",
    'db__db_name' => "Nome do banco de dados",
    'db__db_not_exist' => "O banco de dados não existe.",
    'db__db_type' => "Tipo",
    'db__db_server' => "Servidor do banco de dados",
    'db_server_not_exist' => "O servidor de banco de dados não existe.",
    'db__db_user_not_exist' => "O usuário do banco de dados não existe.",
    'db__domain_not_exist' => "O domínio não existe.",
    'db__enter_db_name' => "Digite o novo nome do banco de dados.",
    'db__invalid_db_id' => "O identificador de banco de dados é inválido.",
    'db__invalid_db_name' => "O nome do banco de dados é inválido. O nome do banco de dados deve conter apenas símbolos do alfabeto latino, dígitos, sublinhado ou traço. Ele não pode ter mais que 63 símbolos.",
    'db__max_db_reached_for_dom' => "Foi atingido o limite do número de bancos de dados para este domínio.",
    'db__max_mssql_db_reached_for_dom' => "O limite do número de bancos de dados do Microsoft SQL Server é alcançado para este domínio.",
    'db__postgres_not_connect_for_admin' => "Não foi possível se conectar ao PostgreSQL. Ative o suporte a PostgreSQL na página de administração do servidor.",
    'db__postgres_not_connect_for_client' => "Não foi possível se conectar ao PostgreSQL. Consulte o administrador do sistema para obter ajuda.",
    'db__remove_db_on_domain' => "Os bancos de dados a seguir no website %2, de propriedade do cliente %1, serão removidos:",
    'db__remove_db_on_domain_of_cl' => "Os seguintes bancos de dados para domínio %2 pertencentes ao cliente %1 serão removidos:",
    'db__remove_db_linked_resource' => 'Este banco de dados está em uso por um aplicativo da web. Ele pode ser removido somente após a desinstalação do aplicativo da web.',
    'db__remove_db_users' => "Os seguintes usuários do banco de dados %3 no site %2 pertencentes ao cliente %1 serão removidos:",
    'db__remove_db_users_of_cl' => "Os seguintes usuários do banco de dados %3 no site %2 pertencentes ao cliente %1 serão removidos:",
    'db__select_db_for_remove' => "Selecione os bancos de dados a serem removidos.",
    'db__select_db_users_for_remove' => "Selecione os usuários de banco de dados a serem removidos.",
    'db__unable_create_db_user' => "Não é possível criar o usuário do banco de dados: %1",
    'db__unable_define_db_name' => "Não é possível definir o nome do banco de dados: %1",
    'db__unable_define_db_user' => "Não é possível definir o usuário do banco de dados: %1",
    'db__unable_define_db_users' => "Não é possível definir usuários do banco de dados: %1",
    'db__unable_select_dom_name' => "Não é possível selecionar novo domínio: %1",
    'db_edit__db_for_dom' => "Usuários para banco de dados %1 no domínio %2",
    'db_edit__invalid_db_name' => "O nome do banco de dados é inválido.",
    'db_edit__no_users' => "Não há nenhum utilizador com credenciais para este banco de dados.",
    'db_edit__unable_define_db_usrs' => "Não é possível definir os usuários do banco de dados: %1",
    'db_edit__unable_select_db_usr' => "Não é possível selecionar o usuário do banco de dados.",
    'db_edit__db_user_password_for_' => "Digite a senha para efetuar login como usuário do banco de dados %1 ",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Adicionar usuário do banco de dados",
    'db_usr_edit__db_usr_name' => "Nome do usuário do banco de dados",
    'db_usr_edit__edit_db_usr' => "Configurar as credenciais para conta de usuário do banco de dados",
    'db_usr_edit__for_db' => " no banco de dados %1",
    'db_usr_edit__not_create_pass' => "Esta operação resultará na criação de uma conta de usuário de banco de dados sem senha.\nVocê deseja criar um usuário sem atribuir uma senha?",
    'dbuser__only_one_user_can_be_default' => "Apenas um usuário pode ser definido como padrão.",
    'db_server__cannot_delete_default' => "O servidor de banco de dados padrão não pode ser excluído.",
    'db_server__cannot_delete_local' => "O servidor de banco de dados local não pode ser excluído.",
    'db_server__cannot_delete_used' => 'Um servidor do banco de dados não pode ser excluído enquanto existirem bancos de dados ou usuários do banco de dados hospedados nele.',
    'demo__disabled_in_demo' => "Esta operação não é suportada na versão demo.",
    'defaultcomponents__title' => "Seleção de componentes-padrão",
    'defaultcomponents__select_default' => "Selecione o componente-padrão %1", //to check
    'defaultcomponents__not_installed' => "(não instalado)",
    'defaultcomponents__not_configured' => "(não configurado)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Algumas categorias de serviços contêm seleções inválidas ou nenhuma seleção foi feita.",
    'defaultcomponents__depends_on' => "(exige %1)",
    'defaultcomponents__parameters' => "Parâmetros do %1",
    'component_name__antivirus' => "Antivírus",
    'component_name__database' => "Servidor SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Servidor DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Servidor de FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Servidor de e-mail",
    'component_name__local_mailserver' => "Servidor de e-mail local",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web Scripting",
    'component_name__spamfilter' => "Filtro de spam",
    'component_name__stats' => "Estatísticas da web",
    'component_name__stunnel' => "Invólucro SSL/TLS",
    'component_name__webmail' => "WebMail",
    'component_name__webpublish' => "Publicação na Web",
    'component_name__webserver' => "Servidor Web",
    'dns__dns_record_invalid_values' => 'Valores de registros de DNS incorretos foram especificados: %1; %2',
    'dns__dns_record_not_found' => 'Registro DNS não encontrado',
    'dns__dns_zone_invalid_values' => 'Parâmetros de zona DNS incorretos foram especificados.',

    'dns__soa_mname_title' => 'Servidor de nomes principal',
    'dns__soa_mname_legend' => 'Servidor de nomes',
    'dns__soa_mname_autoselect' => '(Auto seleção)',

    'dns__dns_zone_off_remove_title' => "Os seguintes registros de recursos serão removidos da zona %1:",
    'dns__dns_zone_master_remove_title' => "Remoção de registros de recursos da Zona DNS %1",
    'dns__dns_zone_slave_remove_title' => "Os seguintes registros do nome de servidor primário para %1 serão removidos:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Inserir uma string de registro',
    'dns_add__is_spf_syntax' => 'Registro de SPF',
    'dns_add__spf_value_is_invalid' => "O valor do registro SPF é incorreto, ele deve iniciar com 'v=spf'",
    'dns__dns_zone_status' => "Status de zona DNS.",
    'dns__invalid_ip_address' => "O endereço IP do novo servidor DNS primário é inválido ou está vazio.",
    'dns__ip_address' => "Endereço IP",
    'dns__master_dns_type' => "é um servidor DNS primário",
    'dns__masters' => "servidores DNS primários",
    'dns__soa_minimum_too_large' => 'Não é recomendada a colocação em cache de respostas negativas durante mais de três horas.',
    'dns__select_masters_to_remove' => "Selecionar servidores DNS primários a serem removidos.",
    'dns__select_template_record_to_remove' => 'Selecionar registros de modelo DNS a serem removidos.',
    'dns__nameservers_for_domain' => "Servidores de nomes para o domínio",
    'dns__remove_dns_zone_of_domain__' => "Remoção de registros DNS do domínio %1",
    'dns__remove_dns_zone_template__' => "Os seguintes registros DNS serão removidos do modelo:",
    'dns__remove_this_dns_record?' => "Você tem certeza de que deseja remover este registro DNS?",
    'dns__restore_default' => "Restaurar a zona DNS pelo modelo",
    'dns__restore_default_confirm' => "Restaurar a zona DNS descartará a configuração de zona DNS atual. Deseja continuar mesmo assim?",
    'dns__restore_default_error' => "Erro na restauração da zona DNS:",
    'dns__slave_dns_type' => "é um servidor DNS secundário",
    'dns__subdomain_dns_rec_removed' => "O registro A foi removido da zona de subdomínio %1.",
    'dns__zone_switched_off_no_ns' => "A zona foi desativada porque não há nenhum registro NS %1, que deve estar presente na zona. Para adicionar o registro à zona, clique no botão Adicionar Registro.",
    'dns__cant_switch_on_no_ns' => "A zona não pode ser ativada porque não há nenhum registro NS %1, que deve estar presente na zona. Para adicionar o registro à zona, clique no botão Adicionar Registro.",
    'dns__unable_activate/deactivate_dns' => "Não é possível ativar/desativar DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Não é possível adicionar servidor DNS primário: entrada duplicada.",
    'dns__unable_add_dns_master_local_ip' => "Não é possível adicionar endereço IP para servidor DNS primário: este registro deve ser criado em um servidor remoto.",
    'dns__unable_define_dns_record' => "Não é possível definir o registro DNS: %1",
    'dns__unable_get_dns_template_status' => "Não é possível recuperar o status de modelo DNS.",
    'dns__unable_remove_dns_rec' => "Não é possível remover o registro DNS: %1",
    'dns__warnings__' => "O resultado da modificação de zona DNS:",
    'dns__you_not_have_perm_manage_dns' => "Você não tem permissão para gerenciar a zona DNS para este domínio.",
    'dns__cant_create_record_with_server_ip' => "Não é possível adicionar o endereço de IP porque ele corresponde ao endereço de IP no servidor gerenciado pelo Plesk.",

    'dns__tabs_acl' => "Transferências de zona",
    'dns__acl_add_network_legend' => "Adicionar Rede",
    'dns__acl_add_ip_legend' => "Adicionar endereço IP",
    'dns__acl_network_not_allowed' => "Este endereço de rede não é permitido pelo DNS no Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Máscara/endereço IP",
    'dns__acl_enter_ip_address' => "Endereço IP",
    'dns__acl_list_network_legend' => "Redes com permissão para obter uma cópia da zona DNS",
    'dns__acl_list_ip_legend' => "Endereços IP com permissão para obter uma cópia da zona DNS",
    'bt_dns_acl_add_network' => "Adicionar Rede",
    'bt_dns_acl_add_ip' => "Adicionar endereço IP",

    'dns_add__add_rec_for_zone' => "Adicionar %1 para zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "O nome de domínio canônico é inválido.",
    'dns_add__enter_canonical_name' => "Nome canônico",
    'dns_add__enter_dom_name' => "Nome do domínio",
    'dns_add__enter_ip_address' => "Endereço IP",
    'dns_add__enter_ip_mask' => "Máscara de rede e endereço IP",
    'dns_add__enter_mail_domain' => "Domínio de e-mail",
    'dns_add__enter_mail_exchanger' => "Servidor de troca de e-mails",
    'dns_add__enter_nameserver' => "Servidor de nomes",
    'dns_add__enter_txt_record' => "Registro TXT",
    'dns_add__enter_service_name' => "Nome do serviço",
    'dns_add__hint_service_name' => "Exemplo: SIP (sem símbolo de sublinhado)",
    'dns_add__enter_protocol' => "Protocolo",
    'dns_add__hint_protocol_name' => "Exemplo: TCP (sem símbolo de sublinhado)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioridade",
    'dns_add__specify_weight_of_service' => "Peso relativo para registros com a mesma prioridade",
    'dns_add__enter_target_host' => "Host de destino",
    'dns_add__hint_target_host' => "Exemplo: exemplo.com",
    'dns_add__enter_target_port' => "Porta de destino",
    'dns_add__caa_tag' => "Marcar",
    'dns_add__caa_value' => "Valor",
    'dns_add-invalid-A_ip' => "O endereço IP é inválido.",
    'dns_add-invalid-AAAA_ip' => "O endereço IP é inválido.",
    'dns_add-invalid-PTR_ip_mask' => "Par de endereço IP/máscara de rede inválido.",
    'dns_add-invalid-SRV_service_name' => "Nome de serviço inválido",
    'dns_add-invalid-SRV_protocol_name' => "Protocolo inválido",
    'dns_add-invalid-SRV_target_port' => "Porta de destino inválida",

    'dns_add__invalid_ip' => "O endereço IP é inválido.",
    'dns_add__low' => "baixo",
    'dns_add__mail_dom_name_is_invalid' => "O nome de domínio de e-mail é inválido.",
    'dns_add__nameserver_is_invalid' => "O servidor de nomes é inválido.",
    'dns_add__record' => "Registro de %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Especifique a prioridade do servidor de troca de e-mails",
    'dns_add__unable_insert_new_dns_rec' => "Não é possível inserir novo registro DNS: %1",
    'dns_add__very_high' => "muito alta",
    'dom_ctrl__allowed' => "Permitido",
    'dom_ctrl__db' => "Bancos de dados MariaDB/MySQL",
    'dom_ctrl__mssql_db' => "Bases de dados MS SQL",
    'dom_ctrl__disk_space' => "Espaço em disco",
    'dom_ctrl__dom_adm' => "Domínio %1 de %2",
    'dom_ctrl__dom_cl' => "Domínio %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domínio tem redirecionamento configurado com redirecionamento de URL indefinido",
    'dom_ctrl__domain_has_frame_forwarding' => "Domínio tem redirecionamento de quadro para a URL %1",
    'dom_ctrl__domain_has_no_hosting' => "O domínio não tem nenhuma hospedagem configurada",
    'dom_ctrl__domain_has_physical_hosting' => "A hospedagem da web é configurada para esse domínio no endereço IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domínio tem redirecionamento-padrão para a URL %1",
    'dom_ctrl__maillists' => "Mala direta",
    'dom_ctrl__mboxes' => "Caixas de e-mail",
    'dom_ctrl__mg' => "Encaminhamentos de e-mail",
    'dom_ctrl__resource_name' => "Recurso",
    'dom_ctrl__resp' => "Respostas automáticas",
    'dom_ctrl__subdom' => "Subdomínios",
    'dom_ctrl__dom_aliases' => "Nomes alternativos de domínio",
    'dom_ctrl__traffic' => "Tráfego",
    'dom_ctrl__unable_activate/deactivate_dom' => "Não é possível ativar/desativar domínio: %1",
    'dom_ctrl__used' => "Utilizado",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Usuários da web",
    'dom_pref__bounce_with_phrase' => "Devolução com mensagem",
    'dom_pref__bounce' => "Devolução",
    'dom_pref__catch_addr' => "Redirecionar para endereço",
    'dom_pref__reject' => 'Rejeitar',
    'dom_pref__confirm_domain_removing' => "Não se esqueça de informar os visitantes do domínio sobre a mudança do nome de domínio. Tem certeza de que deseja renomear o domínio?",
    'dom_pref__db_inconsystency' => "inconsistência de banco de dados.",
    'dom_pref__dbs' => "bancos de dados",
    'dom_pref__delete_traffic_stat' => "Manter estatísticas de tráfego e web",
    'dom_pref__delete_traffic_stat_older' => "Manter estatísticas de tráfego e web",
    'dom_pref__dom_level_name_conflict' => "Conflitos de nome de usuário do administrador de domínio com um nome de usuário de um dos clientes.",
    'dom_pref__invalid_disk_space_limit' => "Limite de espaço em disco inválido. Valor máximo: %1",
    'dom_pref__invalid_expiration_date_limit' => "Período de validade inválido.",
    'dom_pref__invalid_max_traffic_limit' => "Limite de tráfego inválido. Valor máximo: %1",
    'dom_pref__limits_of_dom' => "Limites para domínio %1",
    'dom_pref__mail_grps' => "grupos de correio",
    'dom_pref__mail_nonexistent_user' => "O que fazer com mensagens enviadas para usuários inexistentes",
    'dom_pref__mail_redirs' => "páginas de redirecionamento de e-mail",
    'dom_pref__mail_resps' => "respostas automáticas de e-mail",
    'dom_pref__max_limit_is_invalid' => "%1 é inválido.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Número máximo de %1 é inválido.",
    'dom_pref__new_limit_less_currently_used' => "%1: solicitado - %2, atualmente utilizado - %3",
    'dom_pref__older_that' => "para",
    'dom_pref__postboxes' => "caixas de e-mail",
    'dom_pref__preferences_of_dom' => "Configurações para domínio %1",
    'dom_pref__redirect_to_itself' => "O domínio terá o redirecionamento definido para si",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Você especificou o tempo de conservação das estatísticas de tráfego do domínio para ser menor que o valor total definido para o servidor (%1 mês(es)).  O período de conservação das estatísticas foi definido como igual ao valor-padrão para o servidor (%1 mês(es)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Não é possível adicionar um prefixo www ao domínio:  %1",
    'dom_pref__unable_define_physical_hst_param' => "Não é possível definir parâmetros físicos de hospedagem: %1",
    'dom_pref__unable_rename_domain' => "Não foi possível renomear o domínio %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Não é possível definir a cota de caixa de correio para esse domínio: %1",
    'dom_pref__unable_set_up_web_user_script' => "Não é possível configurar scripts para usuários da web: %1",
    'dom_pref__unlimited' => "Ilimitado",
    'dom_pref__web_usrs' => "usuários da web",
    'dom_pref__you_already_have_%object' => "Você já tem %1",
    'cu_domain__error_unable_update_ftp_users' => 'Falha ao atualizar os usuários de FTP do domínio: %1',
    'dom_cli__warning_ignore_quota' => 'ADVERTÊNCIA: A opção "-hard_quota" é ignorada: não há suporte para cota de disco rígido',
    'dom_user_client_login_exist' => "Não é possível permitir o acesso do administrador do domínio ao Plesk no domínio %1: este nome de usuário já está em uso.",
    'domain__unable_to_turn_on_service' => "Falha ao ativar o serviço %1.",
    'domains__change_the_status_of_domain?' => "Tem certeza de que deseja alterar o status do domínio %1?",
    'domains__unable_to_change_client_status' => "Não é possível alterar o status da conta de cliente: %1",
    'domains__unable_update_apache_settings' => "Não é possível atualizar as configurações do Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Você não tem permissões para excluir domínios.",
    'domains_list__unable_remove_doms' => "Não é possível remover domínios: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Selecione os nomes alternativos de domínio a serem removidos.',
    'domain_aliases_remove__title' => 'Remover os nomes alternativos do domínio',
    'domain_aliases__max_aliases_reached_for_dom' => "O limite do número de nomes alternativos é alcançado para este domínio.",
    'domain_edit__edit_title' => 'Editar um nome alternativo de domínio',
    'domain_alias_edit__type' => 'Tipo de nome alternativo de domínio',
    'domain_aliases__list_header' => 'Nomes alternativos de domínio',
    'domain_aliases__name' => 'Nome',
    'domain_aliases__type' => 'Tipo',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Nomes alternativos de domínio',
    'domain_aliases__legend' => 'Nomes alternativos de domínio',
    'domain_alias__domain_exists' => 'Um domínio com esse nome já existe',
    'domain_alias__subdomain_exists' => 'O subdomínio com esse nome já existe',
    'domain_alias__dns_record_exists' => 'Um registro DNS com o nome alternativo de domínio especificado já existe',
    'domain_alias__domain_alias_exists' => "O alias de domínio com esse nome já existe",
    'domain_alias__invalid_type_full' => 'O servidor de e-mail não suporta os nomes alternativos de domínios',
    'domain_alias__redirect_exists' => 'O redirecionamento para si próprio foi detectado.',

    'ds__anonymous_ftp' => "FTP anônimo",
    'drweb__pagetitle' => 'Configurações do antivírus',
    'drweb__drweb' => 'Verificação de antivírus em e-mail',
    'drweb__drweb_direction' => 'Verificação de vírus em e-mail',
    'drweb__drweb_direction_off' => 'Não realiza a verificação de vírus',
    'drweb__drweb_direction_any' => 'E-mail de entrada e saída',
    'drweb__drweb_direction_from' => 'Apenas e-mail de saída',
    'drweb__drweb_direction_to' => 'Apenas e-mail de entrada',
    'drweb__disable_reason_key' => 'O antivírus não é suportado pela chave de licença.',
    'drweb__disable_reason_perm' => 'Você não tem permissão para gerenciar o antivírus.',
    'drweb__disable_reason_install' => 'O antivírus não foi instalado.',
    'drweb__filters' => 'Filtros de antivírus',
    'ds__dns' => "Zona DNS",
    'ds__mail' => "E-mail",
    'dumps_list__deletion_page_title' => "Serão removidos os seguintes arquivos de backup do domínio %1:",
    'dumps_list__dumpfile_is_invalid' => "O arquivo %1 não é um arquivo de backup de domínio válido.",
    'dumps_list__page_title' => "Armazenamento de arquivos de backup",
    'dumps_upload__page_title' => "Upload de arquivos de backup para o armazenamento",
    'dumps_list__repository_is_not_exist' => "O armazenamento de arquivos de backup não existe.",
    'dumps_list__unable_to_remove' => "Não foi possível remover o arquivo de backup: %1",
    'dumps_list__dumpfile_can_conflict' => "O nome de arquivo que Você especificou conflita com o arquivo %1 Por favor, especifique outro nome de arquivo.",
    'dusr_ed__allow_dl_usr_access' => "Permitir o acesso do administrador de domínio",
    'dusr_ed__information' => "Propriedades do administrador do domínio %1",
    'dusr_ed__locale' => "Idioma do administrador do domínio",
    'dusr_ed__skin' => "Aparência de interface do administrador do domínio",
    'dusr_ed__personal_information' => 'Informações pessoais',
    'ess__error' => "Erro",
    'example__' => "Exemplo: %1",
    'extras__allow_certificate_purchasing' => "Permitir a compra de certificados",
    'extras__allow_domain_registration' => "Permitir o registro de domínios",
    'extras__allow_extras' => "Permitir serviços adicionais",
    'extras__buy_new_key' => "Sua licença atual não permite que você modifique esses objetos.",
    'extras__setup_services' => "Configurar os serviços adicionais",

    'ruleeditform__error' => 'Não é possível atualizar a regra de firewall.',
    'ruleeditform__name_is_required' => 'Especifique o nome da regra.',
    'ruleeditform__profiles_is_required' => 'Selecione ao menos um perfil.',
    'ruleeditform__invalid_ip' => 'A rede ou o endereço IP especificado é inválido.',
    'ruleeditform__invalid_port' => 'A porta especificada é inválida. Os valores possíveis são 1000 ou 1000-1051',

    'get_password__encrypted_password' => "Não é possível enviar as informações de senha: a senha é armazenada de forma criptografada.",
    'get_password__mail_error' => "Ocorreu um erro ao tentar enviar a senha para o e-mail %1: %2",
    'get_password__mail_ok' => "A senha foi enviada com sucesso para o e-mail: %1",
    'get_password__message' => "Seu nome de usuário para acessar o sistema: %1\nSua senha é %2",
    'get_password__subject' => "Senha para acessar o sistema",
    'groups__available' => "Grupos de mensagens disponíveis",
    'groups__groups_for_mailname' => "Grupos de mensagens nos quais a conta de e-mail %1 está inscrita",
    'groups__member_of' => "Membro dos seguintes grupos de mensagens",
    'help__help_area' => "Área de ajuda.",
    'hst_def__auth_disabled' => "proibido",
    'hst_def__auth_enabled' => "permitido",
    'hst_def__change_curr_dns_ip' => "O endereço IP atual do registro DNS A será alterado",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Nenhum dos endereços IP do registro DNS A corresponde com o endereço IP atribuído para a conta de hospedagem que está sendo criada",
    'hst_def__dest_url' => "URL de destino",
    'hst_def__disk_quota' => "Cota de disco",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "O limite de espaço em disco que você está tentando definir foi ultrapassado pelo limite de espaço em disco no diretório de entrada de FTP anônimo. O limite de espaço em disco no diretório de entrada de FTP anônimo não deve exceder o limite de espaço de disco do domínio.",
    'hst_def__frame_forwarding_definition' => "Atribuição de redirecionamento de quadro para o domínio %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Advertência: O usuário de FTP %1 é usado nas configurações da conta de hospedagem, mas não existe no sistema.",
    'hst_def__hst_type_is_not_defined' => "O tipo de hospedagem não é definido.",
    'hst_def__ip_based' => "Com base em IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Transferir essa conta de hospedagem para um endereço IP compartilhado tornará indisponível o serviço FTP anônimo neste domínio. Deseja continuar mesmo assim?",
    'hst_def__password_is_invalid_password_syntax' => "A senha é inválida.\nNão use aspas simples e caracteres do alfabeto nacional em uma senha.\nA senha deve ter de 5 a 14 caracteres. A senha não deve conter o nome de usuário.",
    'hst_def__shell' => "Acesso de SSH ao shell do servidor sob o usuário do sistema da assinatura",
    'hst_def__shell_windows' => "Acesso do desktop remoto ao servidor sob o usuário do sistema da assinatura",
    'hst_def__standard_forwarding_definition' => "Atribuição de redirecionamento-padrão para o domínio %1",
    'hst_def__title_name_based' => "Com base em nome",
    'hst_def__unable_create/update_physic_hst' => "Não é possível criar/atualizar hospedagem física: %1",
    'hst_def__unable_create/update_std_fwd' => "Não é possível criar/atualizar redirecionamento-padrão: %1",
    'hst_def__unable_create_forwarding_myself' => "Não é possível criar o redirecionamento para o próprio domínio.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Não é possível permitir o uso de um único diretório para armazenar conteúdo SSL/TLS e não SSL/TLS: O suporte SSL/TLS não está ligado.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Não é possível ativar o suporte a SSL/TLS: nenhum certificado SSL/TLS instalado.",
    'hst_def__url_is_invalid' => "URL é inválida.",
    'hst_def__virtual_host_access' => "Acesso ao host virtual para domínio %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ADVERTÊNCIA. Este host virtual está usando um endereço IP inexistente para hospedagem.",
    'hst_def__you_have_no_ips' => "Você não tem nenhum endereço IP disponível e não tem permissão para criar hospedagem com base em nome.",
    'hst_sel__header' => "Para hospedar um site neste servidor, selecione a opção de hospedagem Física.\n Para configurar o redirecionamento de domínio para um site em outra máquina, selecione a opção Redirecionamento de Quadro ou Redirecionamento Padrão.\n Com o redirecionamento-padrão, um usuário é redirecionado ao site e a URL do site real é mostrada no navegador do usuário, para que ele saiba sobre o redirecionamento.  Com o redirecionamento de quadro, um usuário é redirecionado ao site sem saber que o site na verdade reside em outro local.",
    'hst_sel__physical_hst' => "Hospedagem física",
    'hst_sel__select_hst_type' => "Selecionar o tipo de hospedagem para o domínio",
    'hst_sel__select_hst_type_warning' => "Selecionar o tipo de hospedagem para o domínio",
    'hst_sel__hosting_exists' => "Não é possível criar de hospedagem, já que ela já está configurada para este domínio. Você será redirecionado para a página de gerenciamento de hospedagem.",
    'hst_sel__standard_frw' => "Encaminhamento padrão",
    'hst_sel__frame_frw' => "Redirecionamento de quadro",
    '__frame_frw' => "Redirecionamento de quadro",
    '__hosting_exists' => "Não é possível criar de hospedagem, já que ela já está configurada para este domínio. Você será redirecionado para a página de gerenciamento de hospedagem.",
    '__choose_hst_type' => "Selecione o tipo de hospedagem necessário.",
    '__no_hst_conf' => "Não há nenhuma hospedagem configurada para o seu domínio.",
    '__physical_hst' => "Hospedagem física",
    '__select_hst_type' => "Selecionar o tipo de hospedagem para o domínio",
    '__standard_frw' => "Encaminhamento padrão",
    '__warning' => "Advertência! Todos os parâmetros definidos anteriormente serão descartados. Tem certeza de que deseja alterar o tipo de hospedagem?",
    'i_cl_off' => "O cliente está inativo.",
    'i_cl_off_by_admin' => "A conta de cliente foi suspensa pelo administrador do servidor.",
    'i_cl_off_expired' => "A conta de cliente expirou.",
    'i_cl_on' => "O cliente está ativo.",

    'icf__title' => 'Firewall de conexão com a internet',
    'icf__if_legend' => 'Interfaces',
    'icf__mode' => 'Modo',

    'invalid_value' => 'O valor é inválido',

    'ip_addr__already_exists' => "O endereço IP %1 já existe.",
    'ip_addr__cant_add' => "O IP %1 não existe ou pertence ao pool de IP de outro cliente",
    'ip_alias__interface' => "Interface ",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "O endereço IP %1 para hospedagem virtual com base em nome é inválido.",
    'ip_alias__invalid_ip_or_netmask' => "Par de endereço IP/máscara de rede inválido.",
    'ip_alias__orig_ip_can_not_be_deleted' => "O endereço IP %1 é o IP do servidor original, portanto, você não pode removê-lo.",
    'ip_alias__ip_is_invalid' => "O endereço de IP %1 é inválido.",
    'ip_alias__ip_mask_is_invalid' => "A máscara de IP %1 é inválida.",
    'ip_alias__ip_not_exist' => "O endereço IP %1 não existe.",
    'ip_alias__ip_address_and_mask' => 'Máscara de sub-rede e endereço IP',
    'ip_alias__mask' => "Máscara de sub-rede",
    'ip_alias__remove_selected_ip_aliases?' => "Você tem certeza de que deseja remover os endereços IP selecionados?",
    'ip_alias__select_ip' => "Selecione pelo menos um endereço IP da lista para removê-lo.",
    'ip_alias__this_ip_used_for_domain' => "(%1) este endereço IP é usado para o domínio %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) este endereço IP é usado para hosts virtuais com base em nome.",
    'ip_alias__unable_add_ip' => "Não é possível adicionar IP: %1",
    'ip_alias__unable_remove_ip' => "Não é possível remover IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Você não pode alterar o tipo de endereço IP para compartilhado, já que isso vai tornar indisponível o FTP anônimo para o domínio '%1'.",
    'ip_ctrl__ip_addr' => "Endereço IP %2 na interface %1",
    'ip_ctrl__ip_exists_many_pools' => "Você não pode alterar o tipo de IP. Este endereço IP pertence aos pools de vários usuários ao mesmo tempo.",
    'ip_ctrl__ssl_cert' => "Certificado SSL/TLS",
    'limit__date_in_past' => "Período de validade é inválido. %1 está no passado.",
    'limit__enter_date' => "Inserir data",
    'limit__max_db' => "Bancos de dados",
    'limit__name_disk_space' => "espaço em disco",
    'limit__name_max_box' => "caixas de e-mail",
    'limit__name_max_db' => "Bancos de dados MariaDB/MySQL",
    'limit__name_max_dom' => "domínios",
    'limit__name_max_maillists' => "mala direta",
    'limit__name_max_subdom' => "subdomínios",
    'limit__name_max_traffic' => "tráfego",
    'limit__name_max_wu' => "usuários da web",
    'limit__name_mbox_quota' => "cota da caixa de correio",
    'limit__name_max_mn' => "contas de e-mail",
    'limit__name_max_cl' => 'clientes',
    'limit__name_total_mboxes_quota' => "cota total de caixas postais",
    'limit__name_mysql_dbase_space' => "Espaço de banco de dados MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "Espaço de banco de dados MSSQL",
    'limit__name_pgsql_dbase_space' => "Espaço de banco de dados PostgreSQL",
    'limit__name_expiration' => 'data de expiração',

    'locale_upload__unable_to_install' => 'Não é possível instalar o arquivo de pacote de idiomas',
    'locale_upload__wrong_package' => 'O arquivo no qual você fez upload não contém um pacote de idiomas válido para esta versão do Plesk.',
    'locale_upload__wrong_locale' => 'O arquivo no qual você fez upload não contém um pacote de idiomas válido.',

    'ma__create_title' => 'Criação de nome alternativo de e-mail para %1',
    'ma__edit_title' => "Editar nome alternativo de e-mail %1",
    'ma__enter_new_alias' => "Inserir novo nome alternativo.",
    'ma__invalid_alias' => "Nome alternativo de e-mail inválido.",
    'ma__mail_aliases_mailname' => "Nomes alternativos de e-mail para a conta de e-mail %1",
    'ma__mailname_does_not_exist' => "Conta de e-mail não existe.",
    'ma__select_ma_for_remove' => "Selecione os nomes alternativos de e-mail a serem removidos.",
    'ma__unable_to_add_new_ma' => "Não é possível adicionar um alaias de e-mail: %1",

    'mail_queue__not_allowed_by_license_key' => 'O gerenciamento da fila de e-mails não é permitido pela chave de licença.',
    'maillist__' => "Mala direta %1",
    'maillist__already_exists' => "A mala direta já existe.",
    'maillist__mail_alias_already_exists_in_this_domain' => "O nome alternativo de e-mail %1 já existe nesse domínio",
    'maillists__' => "Malas Diretas %1",
    'maillists__limit_cl_max_maillists' => "Foi atingido o limite no número de listas de endereçamento para o cliente (limite: %1, utilizado: %2)",
    'maillists__limit_dom_max_maillists' => "Foi atingido o limite do número de malas diretas para o domínio.",
    'maillists__list' => "Mala direta",
    'maillists__mailman_not_installed_or_conf' => "\nAs Extensões de Servidor do Mailman não estão instaladas ou configuradas\nno servidor. Entre em contato com o administrador do servidor para instalar as Extensões de Servidor do Mailman ou para configurá-las corretamente.",
    'maillists__status' => "O serviço de mala direta está ativado.",
    'maillists__unable_to_delete__' => "Não é possível excluir a mala direta: %1",
    'maillists__disabled_text' => 'Você não pode gerenciar malas diretas porque o componente de servidor de listas de discussão do Mailman não está instalado ou configurado.',
    'maillist_member__already_exists' => 'O assinante da mala direta já existe.',
    'maillist_member__not_exists' => 'Esse usuário não existe na mala direta.',
    'mailserver_switching_warning' => "Advertência!\n\nA alteração do servidor de e-mail é pretendida apenas para a configuração inicial e, se o servidor já estiver sendo utilizado, causa os seguintes problemas: perda de configurações e conteúdo das caixas postais e, nos casos em que o servidor ao qual você se conecta já está configurado, vários conflitos.\nSe este servidor estiver sendo utilizado agora e você tiver certeza sobre alternar para outro, é possível notificar seus clientes sobre a operação, de modo que eles possam efetuar o download e salvar seu e-mail.",
    'manager__access_denied' => "Acesso negado: %1",
    'manager__admin' => "Administrador",
    'manager__client' => 'Cliente',
    'manager__domain' => "Domínio",
    'manager__domain_cl_limit_exceeding' => "Foi atingido o limite do número de domínios para esta conta de cliente.",
    'manager__domain_is_not_yours' => "O domínio %1 não pertence a você.",
    'manager__domain_key_limit_exceeding' => "O limite da criação de domínios definido pela sua chave de licença foi atingido.",
    'manager__no_perm_to_call' => "Você não tem permissão para chamar %1.",
    'manager__no_perm_to_create_domains' => "Você não tem permissão para criar domínios.",
    'manager__no_perm_to_modify_domain' => "Você não tem permissão para modificar o domínio %1.",
    'manager__no_perm_to_modify_domains' => "Você não tem permissão para modificar domínios.",
    'manager__no_perm_to_remove_domain' => "Você não tem permissão para remover o domínio %1.",
    'manager__no_perm_to_remove_domains' => "Você não tem permissão para remover domínios.",
    'manager__node_doesnt_exist' => "%1 não existe.",
    'manager__user_disabled' => "Sua conta está suspensa. Você não pode operar o sistema.",
    'mail_quota_unsupported' => "não suportado pelo servidor de e-mail",
    'mbox_quota_unsupported' => "não suportado pelo servidor de e-mail",
    'mn__create_title' => "Criar conta de e-mail",
    'mn__edit_title' => "Configurações",
    'mn__files_list_title' => "Arquivos anexos",
    'mn__files_remove' => "Remover arquivos do repositório de anexos. Este arquivos possivelmente são usados por respostas automáticas. Eles serão removidos do repositório e das respostas automáticas que os utilizam.",
    'mn__files_select_for_remove' => "Selecione arquivos a serem removidos.",
    'mn__mail_alias_form' => "Formulário de nomes alternativos de e-mail",
    'mn__mail_aliases_list' => "Nomes alternativos de e-mail",
    'mn__mailbox' => "Gerenciamento de caixa de correio",
    'mn__unable_define_mn' => "Não é possível configurar contas de e-mail: %1",
    'mn__unable_remove_mbox_quota' => "Não é possível remover cota de caixa de correio: %1",
    'mn__upload_file' => "Carregar arquivo",
    'mn_edit__attach_filename_changed' => 'O arquivo carregado %1 foi renomeado para %2 porque seu nome continha caracteres que não eram ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Você deve adicionar um membro do grupo de e-mail antes de ativar o grupo de e-mail.",
    'mn_edit__add_resp_or_turn_off_box' => "Você deve adicionar uma resposta automática ou desmarcar a caixa de seleção de resposta automática.",
    'mn_edit__attachments' => "Anexos",
    'mn_edit__dom_quota_less_then_quota' => "O tamanho desta caixa de correio não deve exceder o limite na quantidade de espaço em disco alocado para caixas de correio neste domínio.",
    'mn_edit__enter_external_rcpnt_email' => "Digite o e-mail do membro do grupo de e-mail externo",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Digite um endereço de direcionamento de e-mail ou desmarque a caixa de seleção.",
    'mn_edit__ext_rcpnt_email_invalid' => "O endereço de e-mail do destinatário externo é inválido.",
    'mn_edit__file_exists' => "O arquivo existe. Sobrescrever?",
    'mn_edit__files_deld_from_repository' => "Esses arquivos serão excluídos do repositório e das respostas automáticas que os contiverem. Deseja continuar?",
    'mn_edit__mail_name' => "Conta de e-mail",
    'mn_edit__mail_name_invalid' => "O nome da conta de e-mail é inválido.",
    'mn_edit__mail_redir' => "Páginas de redirecionamento de e-mail",
    'mn_edit__mail_redir_add' => "Adicionar membro de grupo de e-mail",
    'mn_edit__mail_resps' => "Respostas automáticas de e-mail",
    'mn_edit__mailbox' => "Caixa postal",
    'mn_edit__enable_mailbox' => "Caixa postal",
    'mn_edit__mailgroup' => "Grupo de e-mail",
    'mn_edit__mailgroup_addresses' => "Membros do grupo de e-mail",
    'mn_edit__mailgroup_disabled' => "Disponível somente quando a conta de e-mail já estiver adicionada.",
    'mn_edit__max_dom_quota' => "Padrão para o domínio (%1)",
    'mn_edit__mbox_quota_invalid' => "Tamanho de caixa de correio especificado é incorreto.",
    'mn_edit__new_resp_name' => "Novo nome da resposta automática",
    'mn_edit__no_autoresponders' => "Você deve adicionar pelo menos uma resposta automática antes de ativar/desativar o serviço de resposta automática.",
    'mn_edit__no_file_sel' => "Não há arquivos selecionados.",
    'mn_edit__no_mail_addresses' => "Nenhum endereço de e-mail foi especificado ou selecionado.",
    'mn_edit__none' => "Nenhum",
    'mn_edit__not_create_pass' => "Isso não irá criar uma senha para esta conta.\nSem senha, o usuário não conseguirá ver e enviar e-mails.",
    'mn_edit__redir_email_invalid' => "O redirecionamento de endereço é inválido.",
    'mn_edit__redirect_addr' => "Endereço de redirecionamento",
    'mn_edit__remove_autoresp?' => "Você tem certeza de que deseja remover a resposta automática?",
    'mn_edit__remove_rcpnts?' => "Você tem certeza de que deseja remover esses destinatários?",
    'mn_edit__repository' => "Repositório",
    'mn_edit__resps_attach' => "Arquivos de anexo de resposta automática",
    'mn_edit__select_rcpnt_from_list' => "Selecione pelo menos um destinatário da lista para removê-lo.",
    'mn_edit__select_registered_users' => "Selecionar usuários cadastrados",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Você optou por ter uma caixa de correio, mas não definiu a senha para ele.",
    'mn_edit__unable_act_deact_mail_group' => "Não é possível ativar ou desativar o grupo de e-mail: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Não é possível ativar ou desativar redirecionamento de e-mails: %1",
    'mn_edit__unable_act_deact_postbox' => "Não é possível ativar ou desativar a caixa de correio: %1",
    'mn_edit__unable_act_deact_resp' => "Não é possível ativar ou desativar as respostas automáticas: %1",
    'mn_edit__unable_add_attach' => "Não é possível adicionar arquivo anexo: %1",
    'mn_edit__unable_add_mail_group_member' => "Não é possível adicionar membro do grupo de e-mail: %1",
    'mn_edit__unable_add_resp' => "Não é possível adicionar resposta automática: %1",
    'mn_edit__unable_change_mail_name' => "Não é possível alterar o nome da conta de e-mail: %1",
    'mn_edit__unable_deactivate_mail_group' => "Não é possível desativar grupo de e-mail: %1",
    'mn_edit__unable_deactivate_resp' => "Não é possível desativar respostas automáticas de e-mail: %1",
    'mn_edit__unable_define_resp_id' => "Não é possível definir ID de resposta automática: %1",
    'mn_edit__unable_remove_attach' => "Não é possível remover arquivo(s) anexo(s): %1",
    'mn_edit__unable_remove_autoresp' => "Não é possível remover resposta automática: %1",
    'mn_edit__unable_remove_mail_group_member' => "Não é possível remover membros do grupo de e-mail: %1",
    'mn_edit__wrong_way' => 'As mensagens endereçadas a %1 não serão entregues, já que esta conta de e-mail não tem uma caixa de correio ou uma página de redirecionamento de e-mail ativada.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'A caixa de correio no endereço %1 foi desativada. As mensagens na caixa de correio não foram removidas, mas você não será capaz de recuperá-las por meio do protocolo IMAP ou POP3.',
    'mn_list__mail_names_for_domain' => "Contas de e-mail sob o domínio %1",
    'mn_list__sa_cannot_unable' => "Não é possível ativar a filtragem de spam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Cliente',
    'mn_list__tab_title_domain' => 'Domínio',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nome",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Não é possível remover as contas de e-mail: %1",
    'module_upload__module_was_installed' => 'Este módulo já está instalado. Se você deseja instalar uma versão mais recente deste módulo, desinstale o módulo pelo Plesk e, em seguida, tente instalá-la.',
    'module_upload__unable_to_install' => 'Não é possível instalar o arquivo de pacote de módulo',
    'module_upload__wrong_package' => 'O arquivo carregado não é um pacote de módulo suportado.',
    'module_upload__wrong_module' => 'O arquivo carregado não contém um pacote de módulo.',

    'news_articles_title' => 'Notícias do Plesk',
    'notification_text__invalid_subject_length' => "Comprimento do assunto de aviso inválido. Deve ser entre 1 e 255 caracteres.",
    'notification_text__invalid_text_length' => "Comprimento de texto de aviso inválido. Deve ser entre 1 e 65533 caracteres.",
    'notification_text__subject' => "Observe o assunto",
    'notification_text__text' => "Texto de aviso",
    'notification_text__title' => "Editar aviso",
    'notification_text__unable_set_text' => "Não é possível modificar o texto de aviso: ",

    'odbc__cant_add_dsn' => "Não é possível adicionar DSN %1: %2",
    'odbc__cant_connect' => "Não é possível se conectar à fonte de dados usando as configurações definidas. O servidor retornou: %1",
    'odbc__cant_delete_dsn' => "Não é possível excluir DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Não é possível obter informações sobre os drivers.",
    'odbc__cant_get_drivers' => "Não é possível recuperar uma lista de drivers ODBC: %1",
    'odbc__cant_open_info_file' => "Não é possível abrir o arquivo com as informações dos drivers ODBC.",
    'odbc__cant_parse_string' => "Não foi possível analisar o string de conexão.",
    'odbc__driver_not_set' => "O driver não está definido",
    'odbc__driver_or_name_not_set' => "Driver ou nome da conexão ODBC não foram definidos",
    'odbc__dsn_already_exists' => "DSN com esse nome (%1) já existe no sistema",
    'odbc__dsn_not_exists' => "Este DSN não existe",
    'odbc__enter_dsn_name' => "Digitar nome do DSN",
    'odbc__invalid_dsn_name' => "Sintaxe errada para nome de conexão ODBC (%1): use apenas símbolos alfanuméricos.",
    'odbc__no_such_driver' => "O driver ODBC com esse nome (%1) não é suportado.",
    'odbc__unknown_driver' => "Nome de driver desconhecido (%1).",
    'odbc_dsn_system' => "DSN do sistema",

    'pb__aliases' => "Nomes alternativos",
    'pb__anonftp' => "FTP anônimo",
    'pb__autoinstaller_releases' => 'Atualizador',
    'pb__cert' => "Certificados",
    'pb__cl_pool' => "Endereços IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Configurações",
    'pb__cl_rpt' => "Relatório",
    'pb__cl_rpt_list' => "Customizar",
    'pb__cl_templates' => "Modelos de cliente",
    'pb__cl_traffic' => "Tráfego",
    'pb__cl_traffic_history' => "Histórico de tráfego",
    'pb__cl_traffic_of' => "Tráfego de %1",
    'pb__client' => "%1",
    'pb__clients' => "Clientes",
    'pb__comp_info' => "Componentes do servidor",
    'pb__common_acl' => 'Permitir transferência de ACL',
    'pb__cp_access' => "Acesso",
    'pb__crontab' => "Agendador",
    'pb__scheduler' => "Agendador",
    'pb__custom_buttons' => "Botões customizados",
    'pb__databases_db' => 'Bancos de dados',
    'pb__sqlservers_db' => 'Servidores SQL', //to check
    'pb__db' => "Bancos de dados",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Servidores de banco de dados',
    'pb__dl_usr_ed' => "Administrador de domínio",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limites de domínio",
    'pb__dom_pref' => "Configurações",
    'pb__dom_sum_report' => "Relatório de resumo de domínio",
    'pb__dom_templates' => "Modelos de domínio",
    'pb__dom_traffic' => "Tráfego de %1",
    'pb__domains' => "Domínios",
    'pb__domain_aliases' => 'Nomes alternativos de domínio',
    'pb__dumps_list' => "Armazenamento de arquivos de backup",
    'pb__forwarding_setup' => "Configuração de redirecionamento",
    'pb__filemanager' => "Gerenciador de arquivos",
    'pb__ip_aliasing' => "Endereços IP",
    'pb__ip_clients' => "Remoção de endereços IP",
    'pb__license_management' => 'Informações de licença',
    'pb__locales' => 'Localidades',
    'pb__log_files' => "Arquivos de log",
    'pb__mail' => 'E-mail',
    'pb__mail_name_files' => "Arquivos anexos",
    'pb__mail_name_redirects' => "Páginas de redirecionamento de e-mail",
    'pb__mail_name_resp_attach_add' => "Novo anexo",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Respostas automáticas de e-mail",
    'pb__mail_names' => "E-mail",
    'pb__maillists' => "Mala direta",
    'pb__modules' => 'Módulos',
    'pb__modules_management' => 'Gerenciar módulos',
    'pb__notifications' => "Notificações",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Configuração de hospedagem física",
    'pb__prtd_dirs' => "Diretórios protegidos",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Customizar",
    'pb__server' => "Servidor",
    'pb__sessions' => "Sessões",
    'pb__sapp_pool' => "Pool de aplicativos da web",
    'pb__siteapp_install' => 'Instalação de aplicativo da web',
    'pb__site_app_pkgs' => 'Aplicativos da web',
    'pb__site_apps' => "Aplicativos da web",
    'pb__additional_key_info' => 'Propriedades de chave',
    'pb__additional_key_properties' => 'Propriedades de chave',
    'pb__skins' => 'Skins',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtro de spam",
    'pb__statistics' => "Estatísticas",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomínios",
    'pb__templates' => "Modelos",
    'pb__virtualdirs' => 'Diretórios virtuais',
    'pb__web_users' => "Usuários da web",
    'pdir__invalid_hst' => "O tipo de hospedagem é inválido. Ele deve ser físico.",
    'pdir__pd_id_is_undefined' => "A ID do diretório protegido está indefinida.",
    'pdir__pdir_exist' => "Um diretório com esse nome já está protegido.",
    'pdir__pdir_not_exist' => "O diretório protegido não existe.",
    'pdir__pdir_usr_not_exist' => "O usuário de diretório protegido não existe.",
    'pdir__remove_pdir_usrs' => "Os seguintes usuários do diretório protegido %2 no site %1 serão removidos:",
    'pdir__remove_pdir_usrs_on_subdom' => "Os seguintes usuários do diretório protegido %2 no subdomínio %1 serão removidos:",
    'pdir__select_pdir_usrs_for_remove' => "Selecione os usuários de diretório protegido a serem removidos.",
    'pdir__select_pdirs_to_remove' => "Selecione os diretórios para remover a proteção.",
    'pdir__unable_define_pdir_users' => "Não é possível definir os usuários de diretório protegido.",
    'pdir__unable_define_pdirs_properties' => "Não é possível definir as propriedades de diretórios protegidos: %1",
    'pdir__unable_select_dom_param' => "Não é possível selecionar parâmetros de domínio: %1",
    'pdir_ed__dir_already_protect' => "Este diretório já está protegido.",
    'pdir_ed__invalid_login' => "Você especificou um nome de usuário incorreto.",
    'pdir_ed__login_exists' => "Este usuário já existe. Tente especificar outro nome de usuário.",
    'pdir_ed__pdir_users' => "Usuários de diretório protegido",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Pelo menos uma caixa de seleção deve ser selecionada dentre as caixas de seleção SSL/TLS e não SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Não é possível criar o usuário de diretório protegido: %1",
    'pdir_ed__unable_create_pdir' => "Não é possível criar o diretório protegido: %1",
    'pdir_ed__unable_define_hst_type' => "Não é possível definir o tipo de hospedagem.",
    'pdir_ed__unable_update_pdir' => "Não é possível salvar as configurações do diretório protegido: %1",
    'pdir_ed__wrong_symbol_in_header' => "Não use o caractere %1 no título do diretório.",
    'pdir_usr_ed__not_create_pass' => "Isso não criará uma senha para o novo usuário de diretório protegido.\nSem uma senha, o usuário não conseguirá efetuar login.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Não é possível selecionar o usuário de diretório protegido: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Não é possível definir os usuários de diretório protegido: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Não é possível remover os usuários de diretório protegido: %1",
    'phosting__anonftp_encrypt' => 'A senha do usuário de FTP é criptografada e, portanto, não pode ser usada para proteger o diretório /plesk-stat/webstat/. Digite novamente sua senha FTP ou desmarque a opção "acessível via diretório protegido por senha \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "O nome de domínio %%domain_name%% resolve para o endereço IP %%dns_ip_address%%. A seu site é atribuído o endereço %%hosting_ip_address%%. Se seu site não abre em um navegador da web quando você se referir a ele pelo seu nome de domínio, vá para a tela de gerenciamento de DNS (Domínios > Nome de domínio > DNS) e altere as propriedades do registro de recursos A:  atribua o endereço IP %%hosting_ip_address%% ao nome de domínio %%domain_name%%.",
    'phosting__ip_change_warning' => "Endereço IP alterado. As alterações correspondentes também foram feitas na zona de DNS do domínio.",
    'phosting__other_hosting_exists_on_ip' => "Não é possível alterar o certificado porque este endereço IP está sendo usado em uma ou várias contas de hospedagem.",
    'phosting__unable_to_change_certificate' => "Não é possível instalar o certificado: %1",
    'phosting__unable_to_change_ip_address' => "Não é possível alterar o endereço IP: %1",
    'phosting__unable_to_set_cert' => "Não é possível definir o certificado SSL/TLS: %1",
    'phosting__unable_update' => "Não é possível atualizar as configurações de hospedagem: %1",
    'phosting__unable_manage' => "Não é possível gerenciar hospedagem: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Não foi possível configurar o fail2ban para rastrear logs do domínio. Os logs serão rastreados automaticamente na próxima vez que o serviço fail2ban for reiniciado.\n%1",

    'picker_acl_record__tittle' => 'Selecionar um registro ACL',
    'picker_autoresponder__title' => 'Selecionar uma resposta automática',
    'picker_black_list__domain_name' => 'Selecionar um nome de domínio',
    'picker_certificate' => 'Selecionar um Certificado SSL/TLS',

    'picker_dns_zone_template__title' => 'Selecionar um registro de recursos',
    'picker_domain__title' => 'Selecione um site',
    'picker_domain_alias__title' => 'Selecionar um nome alternativo de domínio',
    'picker_resource_record__title' => 'Selecionar um registro de recursos',
    'picker_disabled_resource_record__title' => 'Selecionar um servidor de nomes',
    'picker_ip_address__title' => 'Selecionar um endereço IP',
    'picker_ip_address_clients__title' => 'Selecionar clientes que utilizam este endereço IP',
    'picker_mail_queue' => 'Selecione mensagens de e-mail',
    'picker_site_application__title' => 'Selecionar um aplicativo da web',
    'picker_subdomain__title' => 'Selecionar um subdomínio',
    'picker_web_user__title' => 'Selecionar um usuário da web',
    'picker_custom_button__title' => 'Selecionar um botão customizado',
    'picker_license_key__title' => "Seleção de chave de licença",
    'picker_spamfilter_address__title' => 'Selecionar um endereço de filtro de spam',
    'picker_white_list__networks' => 'Seleção de redes',

    'plesk_key__action_logs' => "Registro de ações executadas por usuários do Plesk",
    'plesk_key__app_vault' => "Cofre de aplicativos",
    'plesk_key__backup' => "Funções de restauração e backup",
    'plesk_key__client_templs' => "Gerenciamento de planos de serviço",
    'plesk_key__clients' => "Contas de usuário (revendedores e clientes)",
    'plesk_key__resellers_only' => "Contas de usuário (revendedores)",
    'plesk_key__customers_only' => "Contas de usuário (clientes)",
    'plesk_key__domains' => "Domínios",
    'plesk_key__domain_aliases' => "Nomes alternativos de domínio",
    'plesk_key__subdomains_limit' => "Subdomínios",
    'plesk_key__databases' => "Bancos de dados",
    'plesk_key__mssql_databases' => "Bases de dados MS SQL",
    'plesk_key__manage_dashboard' => 'Customização da página inicial',
    'plesk_key__drweb' => "Gerenciamento de antivírus",
    'plesk_key__event_manager' => "Gerenciador de eventos",
    'plesk_key__expirations' => "Gerenciamento de datas de vencimento de conta",
    'plesk_key__group_ops' => "Modificação de vários objetos ao mesmo tempo",
    'plesk_key__expiration' => "Data de vencimento da chave",
    'plesk_key__edition_name' => "Plesk Edition",
    'plesk_key__key_number' => "Número da chave",
    'plesk_key__languages' => "Pacotes de idiomas",
    'plesk_key__mailnames' => "Contas de e-mail",
    'plesk_key__migration_manager' => "Gerenciador de migração",
    'plesk_key__mssql' => "Suporte ao Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Links para a aquisição de certificado SSL/TLS e serviços de registro de domínio.",
    'plesk_key__myplesk_server_id' => "Identificador do servidor escravo MPC",
    'plesk_key__notifications' => "Gerenciamento de notificações",
    'plesk_key__postgresql' => "Suporte ao servidor de banco de dados PostgreSQL",
    'plesk_key__qmail_queue' => 'Gerenciamento da fila de mensagens',
    'plesk_key__remote_db' => 'Hospedagem de banco de dados remoto',
    'plesk_key__slave_servers' => "Servidores escravos",
    'plesk_key__spamassassin' => "Gerenciamento de filtro de spam",
    'plesk_key__subdomains' => "Gerenciamento de subdomínios",
    'plesk_key__sys_access' => "Gestão de acesso ao servidor",
    'plesk_key__traffic_reports' => "Relatórios de uso de tráfego",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Válido apenas para Virtuozzo containers",
    'plesk_key__webusers' => "Usuários da web",
    'plesk_key__cpu_cores' => 'Núcleos de CPU',
    'plesk_key__ram' => 'Memória',
    'plesk_key__license_update_date' => 'Próxima atualização de chave de licença',
    'plesk_key__autoinstaller_config' => 'Gerenciamento de configurações do atualizador',
    'plesk_key__check_wrong' => "A chave de licença é inválida. Para usar o Plesk, obtenha e instale uma nova chave de licença válida.",
    'plesk_key__upload_check_wrong' => 'A chave de licença carregada não é válida.',
    'plesk_key__revert_check_wrong' => 'A chave de licença instalada anteriormente não é válida.',
    'plesk_key__viruozzo_only_key' => 'A chave de licença é destinada somente para uso com o Plesk operando dentro do Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Você pode usar essa cópia licenciada do Plesk apenas com os seguintes endereços IP: %2. Os seguintes endereços IP não são cobertos por sua licença: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'O valor dos recursos atualmente utilizados excede os limites definidos pela sua licença.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'O número de sites hospedados no servidor excede os limites definidos por sua licença. Você tem %2 sites hospedados; sua licença permite hospedar apenas %1 sites.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'O número de nomes alternativos de domínio no servidor excede os limites definidos por sua licença. Você tem %2 nomes alternativos de domínio; sua licença permite hospedar apenas %1 de nomes alternativos de domínio.',
    'plesk_key__limits_exceeded_lim-subdom' => 'O número de subdomínios no servidor excede os limites definidos pela sua licença. Você tem %2 subdomínios; sua licença permite hospedar apenas %1 subdomínios.',
    'plesk_key__limits_exceeded_lim-db' => 'O número de bancos de dados no servidor excede os limites definidos por sua licença. Você tem %2 bancos de dados; sua licença permite hospedar apenas %1 bancos de dados.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'O número de bancos de dados MS SQL no servidor excede os limites definidos por sua licença. Você tem %2 bancos de dados; sua licença permite hospedar apenas %1 bancos de dados.',
    'plesk_key__limits_exceeded_lim_cl' => 'O número de contas de clientes atendidas excede os limites definidos por sua licença. Você tem %2 contas de clientes atualmente atendidas; sua licença permite atender apenas %1 contas de clientes.',
    'plesk_key__limits_exceeded_lim_mn' => 'O número de contas de e-mail atendidas excede os limites definidos por sua licença. Você tem %2 contas de e-mail atualmente atendidas; sua licença permite atender apenas %1 contas de e-mail.',
    'plesk_key__limits_exceeded_lim_wu' => 'O número de contas de usuário web atendidas excede os limites definidos por sua licença. Você tem %2 contas de usuário web atualmente atendidas; sua licença permite atender apenas %1 contas de usuário web.',
    'plesk_key__limits_exceeded_MLS' => 'O número de pacotes de idiomas instalados excede os limites definidos por sua licença. Existem %2 pacotes de idioma instalados; sua licença permite a instalação de apenas %1 pacotes de idiomas.',
    'plesk_key__wrong_version' => 'Você está tentando usar uma chave de licença criada para outra versão do Plesk. Entre em contato com os representantes de vendas do Plesk para obter uma chave de licença adequada.',
    'plesk_key__other_product' => 'Você está tentando usar uma chave de licença criada para outro produto. Entre em contato com os representantes de vendas do Plesk para obter uma chave de licença adequada.',
    'plesk_key__invalid_machine_id_trial' => 'Sua licença atual não é válida porque já está ativada em outro servidor Plesk. Para continuar usando o Plesk, instale uma nova licença ou instale sua licença atual novamente inserindo seu código de ativação (se você tiver uma).',
    'plesk_key__invalid_machine_id_retail' => 'Sua licença atual não é válida porque já está ativada em outro servidor Plesk. O WebPros EULA (https://www.plesk.com/legal/) proíbe o uso de uma única licença em dois ou mais servidores ao mesmo tempo. Para continuar usando o Plesk, instale uma nova licença ou instale sua licença atual novamente inserindo seu código de ativação. Ele foi enviado a você por e-mail quando você comprou a licença. <br>Não consegue encontrar o código de ativação? Você pode recuperá-lo usando o Plesk 360. Para isso, entre em https://platform360.io/ com o e-mail que você usou para comprar a licença, vá até a aba "Licenças" e veja o código de ativação da sua licença. Ou você pode entrar em contato com o suporte de licenciamento e compra do Plesk usando o formulário on-line (https://www.plesk.com/licensing-and-purchase-support/). Lembre-se de mencionar o número da sua licença no campo "Como podemos ajudá-lo?" seção do formulário.',
    'plesk_key__limits_exceeded_error' => 'Não é possível instalar a chave de licença: os valores de recursos atualmente em uso excedem os limites definidos dentro da chave de licença carregada.',
    'plesk_key__limits_exceeded_note' => 'Os valores de recursos atualmente em uso excedem os limites definidos dentro da chave de licença carregada.',
    'plesk_key__hardware_limits_exceeded' => 'A configuração de hardware excede os limites definidos pela sua licença Plesk.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'O servidor tem %1 de memória instalada, mas sua licença não permite mais que %2.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'O servidor tem %1 núcleos de CPU instalados, mas sua licença não permite mais que %2.',
    'plesk_key__key_file_invalid' => 'O arquivo de chave carregado não é válido ou não contém uma chave de licença.',
    'plesk_key__server_request_error' => 'Não foi possível atualizar a licença. Certifique-se de que as conexões com o servidor de licença ka.plesk.com na porta TCP %1 não estejam bloqueadas. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Veja como fazer isso </a>.',
    'key__no_key_file_in_zip' => 'O arquivo carregado .zip não contém arquivo de chave',
    'key__key_upload' => 'Instalação da chave de licença',
    'additional_key__prop_name' => 'Propriedade',
    'additional_key__prop_value' => 'Valor',
    'additional_key__descr_name' => 'Nome da chave',
    'additional_key__descr_key_number' => 'Número da chave',
    'additional_key__descr_key_vz' => "Esta chave de licença se destina somente para uso no Virtuozzo containers.",
    'additional_key__descr_key_mailboxes' => 'Caixas de e-mail',
    'additional_key__descr_lim_date' => 'Data de expiração',
    'additional_key__descr_license_update_date' => 'Próxima atualização de chave de licença',
    'additional_key__file_invalid' => 'O arquivo de chave carregado não é válido ou não contém uma chave de licença.',
    'additional_key__file_incompatible' => 'O arquivo de chave carregado não é válido para este aplicativo.',
    'additional_key__not_exists' => 'Nenhuma chave de licença instalada.',
    'additional_key_update__result_response' => 'Resposta do servidor de licenciamento: %1',
    'additional_key_update__result_network' => 'Não é possível se conectar ao servidor de licenças. Certifique-se de que sua rede permite a comunicação com %1: %2.',
    'additional_key_update__result_lock' => 'Atualização da chave já está em andamento',
    'additional_key_update__result_internal_error' => 'Erro ao atualizar a chave de licença: %1',

    'proceed_to_cl_pool' => "Avançar para a configuração de pool de IP do cliente",
    'proceed_to_hosting_setup' => "Avançar para a instalação de hospedagem",
    'removeCerts__remove_certificates_cp' => "Serão removidos os seguintes certificados: ",
    'removeCerts__remove_certificates_domain' => "Serão removidos os seguintes certificados pertencentes a %1: ",
    'removeClientsIP_remove_clients_ip' => "Este endereço IP será removido dos pools dos seguintes clientes:",
    'removeMailAliases__remove_mail_aliases' => "Os seguintes nomes alternativos de e-mail para a conta de e-mail %1 serão removidos:",
    'removeMailNames__remove_mailnames' => "Os seguintes nomes alternativos e contas de e-mail serão removidos do domínio %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Os seguintes nomes alternativos e contas de e-mail serão removidos do domínio %2 pertencentes ao cliente %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Essas contas de e-mail não serão excluídas.",
    'removeFtpSessions__remove_title' => "As seguintes sessões de FTP serão encerradas:",
    'removeTemplates__remove_templates' => "Serão removidos os seguintes modelos:",
    'resp_edit__always_respond' => "sempre responder",
    'resp_edit__reply_subject' => "Assunto da resposta",
    'resp_edit__answer_subject' => "Responder com assunto",
    'resp_edit__answer_txt' => "Responder com texto",
    'resp_edit__attach' => "Anexar arquivos",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "para ",
    'resp_edit__frw_rqst_email' => "Após a resposta automática, encaminhe a mensagem original para o e-mail especificado",
    'resp_edit__fwd_email_invalid' => "O endereço de e-mail de destino é inválido.",
    'resp_edit__in_body' => "quando as palavras especificadas são encontradas no corpo da mensagem",
    'resp_edit__in_subject' => "quando as palavras especificadas são encontradas no assunto da mensagem",
    'resp_edit__invalid_resp_freq' => "A frequência de resposta é inválida.",
    'resp_edit__invalid_rqst_txt' => "Texto de solicitação inválido.",
    'resp_edit__invalid_store_lim_num' => "O valor limite é inválido.",
    'resp_edit__limits_title' => "Limites",
    'resp_edit__maximum_allowed_resp_freq_reached' => "O número máximo de respostas por dia excede o valor definido. Permitido: %1, solicitado: %2",
    'resp_edit__no_files_sel' => "Não há arquivos selecionados.",
    'resp_edit__no_txt_supplied' => "Nenhum texto fornecido.",
    'resp_edit__reply_title' => "Responder",
    'resp_edit__reply_to_address' => "Endereço do remetente",
    'resp_edit__reply_to_invalid' => "O endereço do remetente é inválido.",
    'resp_edit__reply_uniq_email' => "Responda para o endereço de e-mail exclusivo no máximo",
    'resp_edit__conditions_title' => "Condições",
    'resp_edit__request_title' => "Solicitar",
    'resp_edit__resp' => "Resposta automática",
    'resp_edit__resp_name' => "Nome da resposta automática",
    'resp_edit__resp_not_exist' => "Resposta automática não existe.",
    'resp_edit__resp_status' => "Status da resposta automática",
    'resp_edit__rqst_txt' => 'Especifique a condição para esta resposta automática',
    'resp_edit__select_files_on_server_for_attach' => "Selecione os arquivos que deseja anexar",
    'resp_edit__store_up_to' => "Armazenar até",
    'resp_edit__subj_line_invalid' => "Linha de assunto é incorreta.",
    'resp_edit__text_too_big' => "O texto da mensagem de resposta é muito grande.",
    'resp_edit__times_in_a_day' => "vezes por dia.",
    'resp_edit__unable_define_resp_cond' => "Não é possível definir a condição de resposta automática: %1",
    'resp_edit__unable_define_resp_status' => "Não é possível definir o status de resposta automática: %1",
    'resp_edit__unable_turn_on_resp' => "Não é possível ativar a resposta automática: %1",
    'resp_edit__uniq_email' => "endereços de e-mail exclusivos",
    'resp_edit__content_type' => 'Formato de envio de e-mail',
    'resp_edit__content_type_text' => 'Texto sem formatação',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Codificação',
    'restart__dns' => 'Servidor de DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Servidor de IMAP/POP3 (%1)",
    'restart__mssql' => "Microsoft SQL server",
    'restart__mysql' => "Servidor MariaDB/MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Serviços",
    'restart__smtp' => "Servidor de SMTP (%1)",
    'restart__spamd' => "Filtro de spam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Servidor Web (%1)",
    'restart__ftp' => "Servidor de FTP (%1)",
    'restart__service_start' => 'Aguarde algum tempo para o início do serviço.',
    'restart__service_stop' => 'Aguarde algum tempo para que o serviço seja interrompido.',
    'restart__service_restart' => 'Aguarde algum tempo para reiniciar o serviço.',
    'rm_domains__some_domains_are_not_exist' => "Alguns dos domínios especificados não existem. Possivelmente, eles foram removidos por outro usuário.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "Antispam",
    'rpt_cl_dom_mail_antivirus' => "Antivírus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Páginas de redirecionamento",
    'rpt_cl_dom_subdomains' => "Subdomínio",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Relatório para o administrador %1",
    'rpt_cl_report_for_reseller__' => "Relatório para o revendedor %1",
    'rpt_cl_report_for_cl__' => "Relatório sobre o cliente %1",
    'rpt_cl_section_domains' => "Domínios",
    'rpt_cl_section_full_domains' => "Domínios",
    'rpt_cl_section_general' => "Geral",
    'rpt_create' => "Criar relatório",
    'rpt_empty' => "O relatório deve conter pelo menos uma seção",
    'rpt_dom_report_for_dom__' => "Relatório de domínio para %1",
    'rpt_dom_section_databases' => "Bancos de dados",
    'rpt_dom_section_full_databases' => "Bancos de dados",
    'rpt_dom_section_full_maillists' => "Mala direta",
    'rpt_dom_section_full_mailnames' => "Contas de e-mail",
    'rpt_dom_section_full_webusers' => "Usuários da web",
    'rpt_dom_section_full_siteapps' => 'Aplicativos da Web',
    'rpt_dom_section_full_aspnetapps' => 'Aplicações web ASP.NET',
    'rpt_dom_section_general' => "Geral",
    'rpt_dom_section_hosting' => "Hospedagem",
    'rpt_dom_section_maillists' => "Mala direta",
    'rpt_dom_section_mailnames' => "Contas de e-mail",
    'rpt_dom_section_siteapps' => 'Aplicativos da Web',
    'rpt_dom_section_aspnetapps' => 'Aplicações web ASP.NET',
    'rpt_dom_section_webusers' => "Usuários da web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Editar relatório %1",
    'rpt_enter_email_address' => "Insira o endereço de e-mail para o qual o relatório será entregue.",
    'rpt_list' => "Layouts de relatório personalizado",
    'rpt_section_full' => "Completo",
    'rpt_section_none' => "Nenhum",
    'rpt_section_summary' => "Resumo",
    'rpt_default_full' => 'Relatório completo',
    'rpt_default_summary' => 'Relatório resumido',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Erro ao enviar o relatório: %1",
    'rpt_send_report_by_email_ok__' => "O relatório foi enviado para %1",
    'sa_action' => "Ação",
    'sa_action_del' => "Remover",
    'sa_action_desc' => "O que fazer com e-mail de spam",
    'sa_action_save' => "Marcar como spam e armazenar na caixa de correio",
    'sa_admin_blacklist' => "Lista negra do administrador",
    'sa_admin_whitelist' => "Lista branca do administrador",
    'sa_db_del_confirm' => "Você tem certeza de que deseja limpar o banco de dados do filtro de spam?",
    'sa_eml_in_ignorelist' => "O e-mail está na lista de ignorados",
    'sa_empty_email' => "Não é possível adicionar um padrão de e-mail vazio.",
    'sa_exists_email' => "Este padrão de e-mail já existe.",
    'sa_disabled__mailname_not_filtering' => "As configurações de servidor atuais não permitem usar filtragem de e-mail para esta conta",
    'sa_disabled__filtering_is_disabled' => 'A filtragem de spam foi desativada pelo administrador do servidor',
    'sa_disabled__hasnt_mailbox' => "Impossível ativar a filtragem de spam sem uma caixa de correio",
    'sa_enable_filter' => "Ativar a filtragem de spam",
    'sa_forget' => "esquecer",
    'sa_from' => "De",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Padrão é inválido.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Treinamento de filtro de spam',
    'sa_trainer__tools_legend' => 'Ferramentas',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Mensagens em sua caixa de correio',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Assunto',
    'sa_trainer__from' => 'De',
    'sa_trainer__date' => 'Data',
    'sa_trainer__info_text' => 'Mensagens descobertas: %1 como spam, %2 como não spam, %3 total.',
    'sa_trainer__messages' => 'mensagem(ns)',
    'sa_trainer__select__all' => 'Todos',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Não spam',
    'sa_trainer__select__unknown_only' => 'Desconhecido',
    'sa_trainer__cannot_remove_messages' => 'Não é possível remover as mensagens selecionadas da caixa de correio.',
    'sa_trainer__remove_messages_confirm' => 'Você tem certeza de que deseja remover as mensagens selecionadas da caixa de correio?',
    'sa_subj' => "Assunto",
    'sa_training' => "Treinamento de filtro de spam",
    'sa_training_legend' => "Treinamento de filtro bayesiano",
    'sa_use_srv_settings' => "Utilize configurações em todo o servidor",
    'sa_user_blacklist' => "Lista negra do usuário",
    'sa_user_whitelist' => "Lista branca do usuário",
    'sa_usr_disabled_by_srv' => "As configurações de filtragem de spam individuais não são permitidas pelo administrador do servidor",
    'sa_usr_no_postbox' => "Não é possível ativar a filtragem de spam porque a caixa de correio está desativada para esta conta de e-mail.",
    'sa_filters' => 'Filtros de spam',
    'spamfilter__tools_legend' => 'Ferramentas',
    'spamfilter__prefs_legend' => 'Configurações',
    'spamfilter__max_children' => 'O número máximo de processos de spam de trabalho para executar',
    'spamfilter__rewrite_header_subject_hint' => 'As mensagens de spam serão colocadas em sua caixa de entrada e você será capaz de reconhecê-las facilmente pelo assunto. Você também pode configurar seu programa cliente de e-mail para filtrar mensagens por assunto.',
    'spamfilter__reject_spam' => 'Excluir e-mail de spam quando chegar na caixa de correio',
    'spamfilter__enabled' => 'Ativado',
    'spamfilter_addresses_list__items' => 'endereços',
    'spamfilter_addresses__remove_title' => 'Os seguintes endereços serão removidos da lista:',
    'spamfilter_addresses__empty_selection' => 'Nenhum endereço selecionado.',
    'server__admin_info' => "Informações sobre o administrador",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Insira a descrição do bug abaixo",
    'server__power_management' => "Gerenciamento de energia",
    'server__services' => "Serviços",
    'server__system' => "Sistema",
    'server__title' => "Administração do servidor",
    'server_preferences__admin_skin' => "Aparência de interface do administrador",
    'server_preferences__default_language' => "Idioma-padrão",
    'server_preferences__default_skin' => "Skin-padrão",
    'server_preferences__restart_apache_interval' => "Intervalo de reinicialização do Apache",
    'server_preferences__system' => 'Configurações de sistema',
    'mail__tabs_preferences' => "Configurações",
    'mail__tabs_white_list' => "Lista branca",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Verifique as senhas para caixas de correio no dicionário",
    'sessions__agreement' => "Sim, quero encerrar estas sessões.",
    'sessions__select_sessions_for_remove' => "Selecione as sessões a serem encerradas.",
    'sessions__tabs_cp_sessions' => 'Sessões do Plesk',
    'sessions__tabs_ftp_sessions' => 'Sessões de FTP',
    'sessions__ftp_sessions_login' => 'Nome de usuário da conta de FTP',
    'sessions__ftp_sessions_domain' => 'Nome do domínio',
    'sessions__ftp_sessions_path' => 'Local atual',
    'sessions__ftp_sessions_file' => 'Nome do arquivo',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Velocidade, KB/S',
    'sessions__ftp_sessions_comp' => 'Progresso, %',

    'site_apps__access_level' => 'Nível de acesso',
    'site_apps__access_level_commercial' => 'Comercial',
    'site_apps__access_level_free' => 'Grátis',
    'site_apps__action_installer' => "Instalação de aplicativo da web",
    'site_apps__action_reconfigure' => "Reconfiguração do aplicativo da web",
    'site_apps__custom_button_level' => 'Você gostaria de criar um botão personalizado para acessar este aplicativo?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Não',
    'site_apps__custom_button_level_domain_user_only' => 'Sim',
    'site_apps__custom_button_level_false' => 'Não',
    'site_apps__custom_button_level_domain' => 'Sim, e disponibilizá-lo apenas para o domínio atual',
    'site_apps__custom_button_level_client' => 'Sim, e disponibilizá-lo para todos os domínios do cliente',
    'site_apps__custom_button_level_admin' => 'Sim, e  disponibilizá-lo para todos os domínios',
    'site_apps__description' => "Descrição",
    'site_apps__dir_used_by_sapp__' => "O diretório \"%1\" é usado por outro aplicativo web",
    'site_apps__dir_used_by_unknown__' => "O diretório \"%1\" já existe. Seu conteúdo será substituído se você prosseguir.",
    'site_apps__dir_invalid_name__' => "O nome do diretório %1 está incorreto",
    'site_apps__file_name' => 'Nome do arquivo do aplicativo web',
    'site_apps__invalid_install_prefix' => "Prefixo de instalação inválido",
    'site_apps__invalid_package' => "O aplicativo web é inválido",
    'site_apps__key_status' => 'Licenciamento',
    'site_apps__key_status_free' => 'Distribuído livremente. Nenhuma chave de licença necessária',
    'site_apps__key_status_ok' => 'A chave de licença necessária está instalada',
    'site_apps__key_status_problem' => 'A chave de licença necessária não está instalada',
    'site_apps__name' => "Nome",
    'site_apps__no_domains' => 'O aplicativo da web não pode ser instalado. Já existe outro aplicativo da web instalado no diretório raiz deste domínio. Considere a criação de um subdomínio para o aplicativo da web.',
    'site_apps__package_info_' => "Informações do aplicativo web",
    'site_apps__package_integrated' => "aplicativo interno, não pode ser removido",
    'site_apps__pool_select_packages_to_add' => 'Selecione os aplicativos web para adicionar ao pool',
    'site_apps__release' => "Versão",
    'site_apps__resource_used_by_sapp' => "Este recurso é usado pelo aplicativo web instalado",
    'site_apps__root_used_by_sapp' => "Este recurso é usado por um aplicativo web instalado",
    'site_apps__these_domains_will_not_delete' => 'Estes (sub)domínios não serão excluídos',
    'site_apps__upload_site_app_pkg_title' => 'Faça o upload do novo aplicativo web',
    'site_apps__version' => "Versão",
    'site_apps__access_to' => "Acesso a %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Não é possível descompactar o arquivo. O arquivador possivelmente não está instalado no servidor. Entre em contato com o administrador de {$PROD_NAME} para instalar o software do arquivador.",
    'skeleton__archive_corrupted' => "A verificação de arquivo descobriu que o arquivo está corrompido, ou que este tipo de arquivo não é suportado.",
    'skeleton__archive_too_large' => "A verificação de arquivo descobriu que o arquivo é muito grande.",
    'skeleton__not_supported_archive_type' => "Este tipo de arquivo (arquivo %1) não é suportado.",
    'skin_download__title' => 'Fazer o download de skin',
    'skin_download_now__title' => 'Download de skin em andamento',
    'skin_download_now__text' => 'A criação de pacotes de skins está em andamento.<br>Este procedimento pode levar algum tempo.<br>Depois que a janela de diálogo for exibida, você pode continuar a trabalhar com o Plesk.',
    'skin_file__help_for_using_types' => "Utilize os arquivos de skin em um dos seguintes formatos:",
    'skin_info__title' => 'Propriedades de skin',
    'skin_mng_err__rpm_not_skin' => 'Este RPM não é um pacote de skins do Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Falha ao instalar a aparência com base em rpm no local especificado.',
    'skin_mng_err__already_exists' => 'O diretório de instalação da aparência já existe e há um pacote de aparências implantado.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'O arquivo carregado não é um pacote de skins RPM válido.',
    'skin_mng_err__rpm_upgrade_noskin' => 'O arquivo carregado não é um pacote de skins válido.',
    'skin_mng_err__rpm_upgrade_base' => "O arquivo carregado não é um pacote de skins {$PROD_NAME} válido.",
    'skin_mng_err__rpm_upgrade_other' => 'Não é possível instalar a skin: formato da skin inválido.',
    'skin_mng_err__no_a_skin' => "O arquivo carregado não é um pacote de skins {$PROD_NAME} válido.",
    'skin_upload__title' => 'Fazer o upload de nova skin',
    'skin_upload__already_exists' => "A skin '%1' já existe.",
    'skin_upload__unable_to_apply' => "O arquivo carregado não contém uma skin para Plesk, ou o formato do arquivo não é suportado.",
    'skin_upload__unable_to_rename__' => "Não é possível renomear skin %2 para %1: %3.",
    'skin_upload__file_name' => 'Caminho para o arquivo de pacote de skin',
    'skins_list__title' => 'Repositório de skins',
    'skins_remove__title' => 'Remoção de skins',
    'skins_remove__select_skins_for_remove' => 'Selecione as skins a serem removidas',

    'spf__unable_update' => 'Não é possível atualizar parâmetros de SPF:',
    'statistics__active_domains' => "Domínios ativos",
    'statistics__clients' => "Clientes",
    'statistics__subdomains' => "Subdomínios",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Bancos de dados",
    'statistics__db_users' => "Usuários de banco de dados",
    'statistics__dirs' => "Diretórios protegidos",
    'statistics__dom_active' => "Ativo",
    'statistics__dom_passive' => "Passivo",
    'statistics__dom_problem' => "Problema",
    'statistics__domains' => "Domínios",
    'statistics__domains_with_host' => "Domínios com hospedagem",
    'statistics__doms' => "Domínios",
    'statistics__filesystem' => "Sistema de arquivos",
    'statistics__general' => "Geral",
    'statistics__hdd_available' => "Disponível",
    'statistics__hdd_capacity' => "Capacidade",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Uso do disco rígido",
    'statistics__hdd_used' => "Utilizado",
    'statistics__ip' => "Endereço IP",
    'statistics__key_number' => "Número da chave",
    'statistics__l1' => "Último minuto",
    'statistics__l15' => "Últimos 15 minutos",
    'statistics__l5' => "Últimos 5 minutos",
    'statistics__la' => "Uso da CPU",
    'statistics__mail_autoresponders' => "Respostas automáticas",
    'statistics__mail_boxes' => "Caixas de e-mail",
    'statistics__mail_groups' => "Grupos de correio",
    'statistics__mail_lists' => "Mala direta",
    'statistics__mail_redirects' => "Páginas de redirecionamento de e-mail",
    'statistics__mem' => "Uso de memória",
    'statistics__mem_usage' => "Uso",
    'statistics__memory_available' => "Disponível",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Em cache",
    'statistics__memory_free' => "Livre",
    'statistics__memory_shared' => "Compartilhado",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Utilizado",
    'statistics__os' => "SO",
    'statistics__problem_clients' => "Clientes com problema",
    'statistics__problem_domains' => "Domínios com problema",
    'statistics__swap' => "Uso de troca",
    'statistics__swap_free' => "Livre",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Uso",
    'statistics__swap_used' => "Utilizado",
    'statistics__system_stat' => "Informações do servidor",
    'statistics__unable_define_active_doms' => "Não é possível determinar o número de domínios ativos: %1",
    'statistics__unable_define_inactive_doms' => "Não é possível determinar o número de domínios inativos: %1",
    'statistics__failed_define_swap_usage' => 'Falha ao definir a Utilização de Swap',
    'statistics__failed_define_load_averages' => 'Falha ao definir as Médias de Carga',
    'statistics__up_time' => "Tempo de atividade do sistema: ",
    'statistics__ver' => "Versão",
    'statistics__web_users' => "Usuários da web",
    'statistics__mem_win' => "Uso da memória física",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Utilizado",
    'statistics__memory_free_win' => "Disponível",
    'statistics__swap_win' => "Uso de memória virtual",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Utilizado",
    'statistics__swap_free_win' => "Disponível",
    'status__domain_has_reasons_to_be_off' => "O domínio ainda está suspenso pelo seguinte motivo: %1",
    'subdomain__create__' => "Criar um subdomínio no domínio %1",
    'subdomain__edit__' => "Gerenciar subdomínio %1",
    'subdomain__invalid_name' => "Nome de subdomínio inválido: use somente símbolos de traço e alfanuméricos.",
    'subdomain__incorrect_name' => "Nome de subdomínio inválido.",
    'subdomains__maillists_enabled_in_domain' => "Nome de subdomínio incorreto lists.%1: este nome de domínio já está em uso por listas de endereçamento no domínio %1.",
    'subdomains__dalias_exists' => 'O alias de domínio com esse nome já existe.',
    'subdomains__name_exists' => "O subdomínio com esse nome já existe.",
    'subdomains__regular_domain_exists' => "Um domínio com esse nome já existe.",
    'subdomains__domain_alias_exists' => 'O alias de domínio com esse nome já existe.',
    'subdomains__remove_subdomains_on_domain' => "Serão removidos os seguintes subdomínios para o domínio %1:",
    'subdomains__select_subdomains_for_remove' => "Selecione os subdomínios a serem removidos",
    'subdomains__webmail_enabled_in_domain' => "Nome de subdomínio incorreto webmail.%1: este nome de domínio é usado para acesso ao webmail no domínio %1.",
    'subdomains__dns_record_already_exists' => 'Não é possível criar o subdomínio %1 porque um registro DNS apontando para o host %1 já existe.',
    'subdomains__www_prefix_in_domain' => "Nome de subdomínio incorreto www.%1: o domínio %1 já tem o prefixo WWW.",
    'subdomains__user_type_quota_exceeds' => 'Não é possível alterar a conta de usuário porque o resultado seria superior ao espaço em disco alocado.',
    'subdomains__creation_in_dns_slave' => "O nome de servidor do Plesk está atuando como um nome de servidor secundário para este domínio. Para que seu subdomínio seja resolvido corretamente, verifique se o arquivo de zona no servidor DNS primário contém o registro %1.",
    'sys_user__attributes_not_changed' => "\nOs seguintes atributos de usuário do sistema não foram alterados: %1",
    'sys_user__no_access_without_password' => "Você não definiu uma senha. O usuário do sistema será criado, mas não será capaz de efetuar login no sistema até que seja criada uma senha para ele. Gostaria de continuar?",
    'sys_user__no_hard_quota' => "não suportado",
    'sysuser__zero_quota_is_unlimited' => "0 para ilimitado",
    'template__num_excl_ips' => "Alocar endereços IP dedicados para o cliente",
    'template__sel_sh_ips' => "Endereços IP compartilhados selecionados",
    'template__av_sh_ips' => "Endereços IP compartilhados disponíveis",
    'template__up_to_excl_ip' => "Até %1 endereços IP",
    'templates__all_clients' => "todos os clientes",
    'templates__cl_domain_templates' => "Modelos para %1",
    'templates__cl_templates' => "Modelos de cliente",
    'time__invalid_ip' => "Endereço IP ou nome de domínio inválido.",
    '__please_select_country' => 'Selecione o seu país',
    'time__unable_set_time' => "Não é possível definir a hora do sistema: %1",
    'time__sinchronization_setup_error' => 'Não foi possível configurar a sincronização de tempo: falha de timemng: %1',
    'time__sinchronization_disable_error' => 'Não foi possível desativar a sincronização de horário: falha de timemng: %1',
    'tmpl__create' => "Criar modelo",
    'tmpl__edit__' => 'Modelo %1',
    'tmpl__logrotation_warn' => "Rotação de logs no domínio criado por este modelo será realizada apenas em caso de criação de conta de hospedagem física subsequente para ele.",
    'tmpl__name' => "Nome do modelo",
    'tmpl__dom_exist' => "Um modelo de domínio com esse nome já existe no pool de modelos do administrador ou do cliente.",
    'tmpl__name_invalid' => "Nome do modelo está inválido ou vazio.",
    'tmpl__use_next_ip_addr' => "O próximo endereço IP vago será usado",
    'tmpl_name_already_exists' => "Modelo com nome '%1' já existe.",

    'vh_based__no_free_ip_for_vh' => "Não há endereços IP vagos para a hospedagem virtual com base em IP. Adicione um endereço IP.",

    'wu__at_domains_text' => "Permitir formato de acesso de usuário da web@%1",
    'wu__unable_create' => "Não é possível criar usuário da web: %1",
    'wu_edit__disk_quota' => "Cota de disco",
    'wu_edit__invalid_pass' => "A senha é inválida.",
    'wu_edit__invalid_quota' => "O valor de cota de espaço em disco especificado é inválido. Insira um número inteiro positivo.",
    'wu_edit__invalid_quota_value' => "A cota de espaço em disco especificada é menor que a atualmente em uso (%1 MB). Algumas funcionalidades podem ficar indisponíveis. Tem certeza de que deseja continuar?",
    'wu_edit__not_create_pass' => "Essa ação não criará uma senha para o novo usuário da web.\nSem uma senha, o usuário não conseguirá efetuar login.",
    'wu_edit__unable_update' => "Não é possível atualizar a propriedade de usuário da web: %1",

    'dns__tabs_general' => 'Configurações de zona',
    'dns__tabs_zone_settings' => 'Registros SOA',
    'soa__seconds' => 'segundos',
    'soa__minutes' => 'minutos',
    'soa__hours' => 'horas',
    'soa__days' => 'dias',

    'DomainSubdirectory' => 'Subdiretório de destino',

    'filemanager__select_codepage' => 'Selecionar o Codepage:',

    'bt_server_app_add' => 'Adicionar Aplicativo do Servidor',
    'packages_list' => 'Aplicativos do servidor',

    'bt_packages_management' => 'Gerenciamento de pacotes',
    'pb__packages_management' => 'Gerenciamento de aplicativos',
    'bt_package_new' => 'Adicionar Aplicativo',
    '__packages' => 'Aplicativos do servidor',

    'dom_ctrl__mysql_dbase_space' => 'Cota total das bases de dados MariaDB/MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Cota total das bases de dados MS SQL',

    'dns_add__enter_ixfr_path' => 'Inserir o caminho IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'O registro SPF TXT já existe. Somente pode haver um registro SPF. Para adicionar um registro, apague o existente antes.',

    'component_name__network' => 'Rede',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Defina a skin',
    'bt_set_skin' => 'Defina a skin',
    'firewall__rule_already_exists' => 'Regra com nome "%1" já existe',
    'firewall__rule_readonly' => 'A regra "%1" é somente leitura',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivírus',
    'antivirus__antivirus' => 'Proteção de antivírus',
    'antivirus__antivirus_direction_off' => 'Desativado',
    'antivirus__antivirus_direction_any' => 'E-mail de entrada e saída',
    'antivirus__antivirus_direction_from' => 'Apenas e-mail de saída',
    'antivirus__antivirus_direction_to' => 'Apenas e-mail de entrada',
    'antivirus__unable_to_update_settings' => 'Impossível alterar as configurações de antivírus: %1',




    '__normal' => 'Normal',
    '__low' => 'Baixo',
    '__high' => 'Alto',

    'mail__antivirus' => "Antivírus de servidores de e-mail internos",
    'mail__use_internal_antivirus' => 'Usar um antivírus interno',

    'sa__tabs_blacklist' => 'Lista negra',

    '__mysql_databases' => 'Bancos de Dados MariaDB/MySQL',

    'cl_perm__mysql_dbase_space' => 'Cota total das bases de dados MariaDB/MySQL',
    'cl_perm__mssql_dbase_space' => 'Cota total das bases de dados MS SQL',
    'cl_perm__max_mssql_db' => 'Número máximo de bancos de dados do Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Cota total de caixas postais',

    'i_i_cl_on' => 'A conta do cliente está ativa.',
    'i_i_cl_off_by_admin' => 'A conta de cliente foi suspensa pelo administrador.',

    'sa_exists_tn' => 'A rede já está na lista.',

    'defaultcomponents__not_activated' => 'não ativado',

    'bt_traffic_at_domains' => 'Tráfego',

    '__awstats_perl_warning' => 'Sem Perl instalado, AWStats não permitirá que os usuários verifiquem estatísticas de anos anteriores.',

    'class_client__mysql_dbase_space' => 'O valor ultrapassa o limite do cliente.',
    'class_client__mssql_dbase_space' => 'O valor ultrapassa o limite do cliente.',
    'class_client__max_mssql_db' => 'O valor ultrapassa o limite do cliente.',

    'dns__remove_transfer_restrictions_list_items' => 'As seguintes redes serão removidas da lista de controle de acesso:',

    'bt_up' => "Para cima",
    'bt_down' => "Abaixo",

    'bt_install_selected' => 'Instalar as chaves de licença selecionadas', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'O domínio resolve para outro endereço de IP: (%1). Corrigir as configurações de DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'O servidor de e-mail atualmente em uso não suporta a caixa postal e os grupos de e-mail ativados simultaneamente. Pressione OK para ativar a caixa postal à custa de desativar os grupos de e-mail. Pressionar Cancelar para deixar tudo intacto.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'O servidor de e-mail atualmente em uso não suporta a caixa postal e os grupos de e-mail ativados simultaneamente. Pressionar OK para ativar os grupos de e-mail à custa de desativar a caixa postal. Pressionar Cancelar para deixar tudo intacto.',

    'mysql_dbase_space_limit' => 'Limite de espaço do banco de dados MariaDB/MySQL',
    'mysql_dbase_usage' => 'Uso de espaço do banco de dados MariaDB/MySQL',
    'mssql_dbase_space_limit' => 'Limite de espaço do banco de dados do Microsoft SQL Server',
    'mssql_dbase_usage' => 'Uso de espaço do banco de dados do Microsoft SQL Server',

    '__statistics' => "estatísticas", //indirect

    'dns__soa_minimum_value_is_big' => 'A definição do valor TTL mínimo, que é superior a 3 horas, pode tornar os domínios inacessíveis para alguns dos administradores de domínios. Recomenda-se definir este valor somente se seu registrador de nomes de domínios insistir.',

    'virusfilter__interface_not_available' => 'Nenhum filtro de vírus está disponível.',
    'virusfilter__none_virus_filter' => 'Nenhum',
    'virusfilter__mailname_status_text' => 'Antivírus (%1)',
    'virusfilter__status_none' => 'desativado',
    'virusfilter__status_any' => 'e-mail de entrada e saída',
    'virusfilter__status_outgoing' => 'apenas e-mail de saída',
    'virusfilter__status_incoming' => 'apenas e-mail de entrada',

    'visibility__root_override_parse_error' => 'Há um erro de sintaxe no arquivo %1 na linha %2.',

    'sb__not_support_publishing_api' => "A automação de publicação não é suportada pelo componente",

    'component_name__cphosting' => "Hospedagem do Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'A configuração de quota de caixas postais não é suportada pelo servidor de e-mail atual.',
    '__unable_get_total_mboxes_quota' => 'A configuração de quota de caixas postais não é suportada pelo servidor de e-mail atual.',

    'install_prefix__parent_not_exists' => "O diretório pai não existe.",

    'bt_change_version' => 'Alterar a versão',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Selecionar Todos",
    '__uncheck_all' => "Limpar todos",

    'dns__editing_domain_controller_zone' => "A edição dos registros de zona DNS para o controlador de domínios pode causar problemas no funcionamento do domínio",

    'pb__interface_management' => "Gerenciamento de interface",
    'interface_management__tabs_skins' => "Skins",
    'interface_management__tabs_interface_templates' => "Modelos de interface",
    'interface_management__tabs_locales' => "Localidades",
    'locales_list__title' => "Repositório de pacotes de idiomas",
    'locales_list__legend' => "Idiomas disponíveis",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Pacote de idioma",
    'locales_list__lang_title' => "Idioma",
    'locales_list__country_title' => "País",
    'locales_list__used_title' => "Utilizado",

    'backup__suspend_warning_during_backup' => "O domínio não estará disponível durante o processo de backup",
    'backup__suspend_warning_during_restore' => "O domínio não estará disponível durante o processo de restauração",
    'backup__suspend_domain' => "Suspender o domínio",

    'locales_list__mls_limit' => "Sua licença atual do Plesk permite usar %2 idiomas. Neste momento, você tem %1 idiomas definidos como disponíveis aos usuários, o que excede o número fornecido com a licença. Selecione %2 idiomas que deseja usar e indisponibilize o restante para usuários clicando em seus ícones na coluna 'S'.",

    'bt_change_owner' => 'Atribuir um novo proprietário',
    'chown__limit_name' => 'Nome do recurso',
    'chown__error_limits' => "Não é possível continuar a transferência de assinatura: esta assinatura requer mais recursos do que pode ser fornecido pelo provedor do novo proprietário.",
    'chown__error_empty_ip_pool' => "Não é possível continuar a transferência de assinatura: O pool de IP do provedor do novo proprietário está vazio.  Certifique-se de que o provedor tenha pelo menos um endereço IP no pool.",

    'backup__backup_time' => 'Tempo de backup',
    'backup__backup_time_hour' => 'horas',
    'backup__backup_time_minute' => 'minutos',
    'backup__every' => 'cada',
    'backup__day_of_month' => 'dia e mês',

    'subdomain__select_hst_type' => 'Selecionar o tipo de hospedagem para o subdomínio',
    'hst_sel__subdom_subfolder_hst' => 'Subdomínio em subpasta',
    'subdomain__www_root_folder_not_exists' => 'O diretório inicial do site %1 não existe.',
    '__site_home_dir' => 'Diretório inicial do site',
    'subdomain__aspnet_disabled_domain' => 'desativado por domínio',

    'domains__remove_description' => 'Todos os dados do domínio, incluindo conteúdo e configurações do respectivo subdomínio, dados de aplicativos da web, conteúdo da caixa postal, e-mail, configurações de antivírus e filtros de spam, arquivos de registro, dados do repositório de backup do domínio e certificados SSL/TLS serão excluídos. Se você não tiver um arquivo de backup em sua máquina local, todos os dados serão perdidos permanentemente.',
    'subdomains__remove_description' => 'Todos os dados de subdomínio, incluindo conteúdo e configurações, dados de aplicativos web e arquivos de log de subdomínio serão excluídos. Se não existir um arquivo de backup em sua máquina local, todos os dados serão permanentemente perdidos.',

    'mail__tabs_spam_filtering' => 'Filtragem de spam',
    'mail__tabs_antivirus' => 'Antivírus',
    'antivirus__use_server_settings_scan' => 'Utilizar as configurações-padrão em todo o servidor (realize a verificação)',
    'antivirus__use_server_settings_no_scan' => 'Utilizar as configurações-padrão em todo o servidor (não realize a verificação)',
    'antivirus__check_for_viruses' => 'Verificação de vírus',
    'antivirus__dont_check_for_viruses' => 'Não procure vírus',
    'antivirus__incoming_mail' => 'E-mail de entrada',
    'antivirus__outgoing_mail' => 'E-mail de saída',

    'domain_alias__CNAME_dns_record_exists' => 'O registro CNAME do DNS com esse nome já existe',
    'domain_alias__A_dns_record_exists' => 'O registro A do DNS com esse nome já existe',
    'domain_alias__bad_prefix' => 'Prefixo errado para o nome alternativo de domínio',
    'domain_alias__domain_doesnt_exist' => "O domínio não existe",

    'dns__zone_ttl_message_info' => 'Se o valor TTL não for especificado, o valor TTL no Modelo de Registro SOA (%1) será usado para este registro DNS.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Um arquivo denominado index.html será criado para o redirecionamento para o aplicativo web selecionado. Se já existir um arquivo denominado index.html, será feito backup dele como index.html.old e, então, ele será substituído pelo novo. Aperte OK para confirmar",

    'bt_ftp_ctrl' => "Contas de FTP adicionais",
    'ftp_users_no_permission' => "Você não tem permissão para gerenciar as contas de FTP para este domínio.",
    'ftp_users_limit_reached' => "O limite de contas de FTP foi alcançado para este domínio",
    'pb__ftp_ctrl' => "Gerenciamento de FTP",
    'class_client__max_subftp_users' => "Contas de FTP adicionais",

    '__client_form_settings' => "Configurações de cliente",
    '__sbnet_client_keep_sbnet' => "Manter a conta de usuário correspondente no Presence Builder",
    '__sbnet_cant_add_more_sites' => "O limite da quantidade de sites que podem usar o Presence Builder foi alcançado para este cliente",
    '__sbnet_legend_text' => "Integração do Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Criar uma conta de usuário correspondente no Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Você está tentando remover a conta de usuário do Presence Builder associada a esse cliente. Isso excluirá todos os sites do usuário e todas as outras configurações relevantes do sistema do Presence Builder, removendo a capacidade de editar sites existentes pelo Presence Builder, mesmo se você ativar essa opção novamente mais tarde. Se você criar uma conta de usuário do Presence Builder novamente mais tarde, será preciso criar e publicar todos os seus sites do zero. Você deseja desativar a publicação e criação de sites pelo Presence Builder?",
    'sb__build_site_with_subdomains' => "Subdomínios de Criar Blog e Galeria de Fotos",
    '__sbnet_client_dont_have_sbuser' => "Não é possível criar e publicar um site usando o Presence Builder: O usuário do Presence Builder não existe",

    '__component_disabled' => "Componente desativado",

    'subdomains__physical_path_not_exist' => "Existem subdomínios vinculados a pastas físicas inexistentes",

    'dnsserver_bind_to_msdns_switching_warning' => "Advertência: somente os primeiros 254 endereços de IP das sub-redes com /8 e /16 máscaras localizados na Lista de Controle de Acesso serão transferidos. Eles serão transferidos como endereços de IP separados. Deseja continuar?",

    '__sbnet_net_framework_required_for_site' => "Os sites do Presence Builder podem exigir suporte a ASP.NET 2.0 em seu domínio. É recomendável habilitar o suporte a ASP.NET 2.0 se você estiver usando o Presence Builder.",

    'subdomain_auto_create_dir' => "Criar diretório físico para o subdomínio",

    'sa_trainer__unable_to_get_messages_list' => "Não é possível obter a lista de mensagens na caixa de correio: %1",
    'sa_trainer__pass_doesnt_exist' => "Está faltando a senha para esta conta de e-mail",

    '__sitebuilder_error' => "Ocorreu um erro ao tentar conectar ao Presence Builder. Entre em contato com seu provedor de serviços para obter assistência.",
    'wsb_error_user_not_exist' => "A conta de usuário do Presence Builder não existe.",
    'wsb_error_site_already_exist' => "Este site já existe no Presence Builder.",
    'wsb_error_site_limit_reached' => "O limite no número de sites do Presence Builder foi alcançado.",
    'wsb_error_internal_error' => "Ocorreu um erro interno no Presence Builder: Entre em contato com seu provedor de serviços para obter assistência.",
    'wsb_error_user_already_exist' => "Já existe um usuário do Presence Builder com esse nome.",
    'sb_error_user_not_exist' => "O usuário do Presence Builder não existe.",
    'wsb_error_object_not_found' => "O Presence Builder não conseguiu encontrar a entrada de host correta.",

    'mg_no_mail_groups' => "Nenhum grupo de e-mail",

    'drweb__drweb_incoming' => 'Verificação de antivírus para e-mais de entrada',
    'drweb__drweb_outgoing' => 'Verificação de antivírus para e-mais de saída',
    'drweb__disable_reason_serv' => 'O servidor de e-mail não suporta as configurações do filtro de antivírus no nível de caixa postal',

    'vz_sitebuilder3_client_cant_be_created' => "Não é possível criar conta de cliente: O SiteBuilder versão 3.1 ou posterior não está instalado.",

    // new limits

    'class_client__max_odbc' => "Conexões ODBC",
    'cl_perm__max_odbc' => "número máximo de conexões ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Nome alternativo do domínio',
    'domain_alias__list_ascii_name' => 'Em formato ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Gerenciamento de interface',
    'pb__interface_templates' => 'Gerenciamento de Interface',
    'pb__interface_clients' => 'Clientes que usam %1',

    // service management
    'bt_service_showall' => "Exibir todos",
    'bt_service_hideall' => "Ocultar tudo",
    'bt_service_start' => "Iniciar",
    'bt_service_stop' => "Interromper",
    'bt_service_restart' => "Reiniciar",
    'bt_service_disable' => "Desativar",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Automático",
    'service_startup_auto' => 'Automático',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Desativado',
    'service_action_ok' => "A operação com serviço de %1 foi concluída com sucesso",
    'service_action_failed_disabled_service' => "Não foi possível concluir a operação com serviço de %1 porque ele está desativado",
    'service_action_failed_error' => "Não foi possível concluir a operação: %1",
    'service_group_action_ok' => "A operação com os seguintes serviços foi concluída com êxito: \n %1",
    'service_group_action_disabled' => "Não foi possível concluir a operação com os seguintes serviços porque eles estão desativados: \n %1",
    'service_group_action_failed' => "Não foi possível concluir a operação com os seguintes serviços: \n %1. \n Para receber informações detalhadas sobre o erro, execute a operação com cada serviço separadamente",

    // php 4vs5
    'bt_php' => "Configurações do PHP",

    'bt_insert' => "Inserir",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Ocorreu um erro de banco de dados no Presence Builder: Entre em contato com seu provedor de serviços para obter assistência.",
    'wsb_error_sitebuilder_access_denied_error' => "Não foi possível acessar o arquivo: O Presence Builder não tem nenhum direito de acesso para o arquivo ou pasta necessário. Entre em contato com seu provedor de serviços para obter assistência.",
    'wsb_error_sitebuilder_connection_failed' => "Não é possível conectar-se ao Presence Builder porque a conexão foi perdida. Entre em contato com seu provedor de serviços para obter assistência.",
    'wsb_error_critical_during_operation' => "Ocorreu um erro crítico no Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Ocorreu um erro de licença no Presence Builder:\n%1",
    'wsb_error_during_operation' => "Ocorreu um erro no Presence Builder:\n%1",
    'wsb_error_license_error' => "Foi encontrada uma limitação de licença do Presence Builder.",

    // Other
    '__confrim_service_stop' => "Advertência! Se você interromper o serviço 1%, o Plesk pode parar de funcionar. Tem certeza de que deseja interromper o serviço %1?",
    'index_redirect_help_text' => 'Agora, você será redirecionado automaticamente para o website requerido. Se seu navegador não suporta o redirecionamento, clique em %1 aqui %2',
    'bt_default_settings' => "Restaurar os padrões",
    'logfiles__remove_failed' => "Não é possível excluir o arquivo %1: o arquivo está bloqueado por outra aplicação. Tente novamente mais tarde",
    'subdomain__invalid_homedirectory' => "Diretório inicial de subdomínio especificado é inválido",
    'scheduler_item__empty_filename' => "Especifique o arquivo executável a ser executado",
    'subdomains__overlapped_domain_exists' => 'Subdomínio é sobreposto por zona DNS de domínio %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdomínio é sobreposto por zona DNS de alias de domínio %1',
    'services_action_none_selected' => 'Não foi possível concluir a operação: selecione os serviços necessários',
    'cl_perm__max_subftp_users' => "número máximo de contas de FTP adicionais",
    'login_up__access_denied_no_cp_access' => 'Acesso negado. Você não tem permissão para acessar o Plesk.',
    'drweb__disable_reason_admin' => "As configurações do filtro de antivírus no nível da caixa postal não são permitidos pela política do servidor.",

    '__use_default' => 'Usar padrão',

    'webalizer_hidden_referrer__already_exist' => 'Essa entrada já existe.',
    'webalizer_group_referrer__already_exist' => 'Um referenciador de grupo com esse nome já existe.',

    'pb__dashboard' => 'Página inicial',

    'server_interface__page_title' => 'Configurações da interface do servidor',
    'server_interface__tabs_locales' => 'Localidades',
    'server_interface__tabs_skins' => 'Skins',
    'server_interface__tabs_interface_templates' => 'Modelos de interface',
    'bt_server_interface' => 'Preferências de interface',
    'pb__server_interface' => 'Preferências de interface',

    'bt_wizard_next' => 'Seguinte >>',
    'bt_wizard_prev' => '<< Voltar',

    '__limit_exceeded_max_dom_server' => 'Você não pode hospedar mais domínios neste servidor porque o limite do número de domínios permitido no servidor pela chave de licença foi atingido. Entre em contato com seu provedor de serviços para resolver este problema.',
    '__limit_exceeded_max_subdom_server' => 'Você não pode hospedar mais subdomínios neste servidor. Entre em contato com seu provedor de serviços.',
    '__limit_exceeded_max_dom_aliases_server' => 'Você não pode configurar mais nomes alternativos de domínio neste servidor. Entre em contato com seu provedor de serviços.',
    '__limit_exceeded_max_wu_server' => 'Não é possível criar mais usuários de web porque o limite do número de usuários de web autorizado pela chave de licença foi atingido. Entre em contato com seu provedor de serviços para resolver este problema.',
    '__limit_exceeded_max_mn_server' => 'Não é possível criar mais contas de e-mail porque o limite do número de contas de e-mail autorizado pela chave de licença foi atingido. Entre em contato com seu provedor de serviços para resolver este problema.',

    '__limit_exceeded_max_cl_useradmin' => 'Você atingiu o limite do número de contas de cliente definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Você atingiu o limite do número de domínios definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Você atingiu o limite do número de subdomínios definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Você atingiu o limite do número de nomes alternativos de domínio definido pela sua chave de licença (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Você não tem mais espaço livre em disco',
    '__limit_exceeded_max_wu_useradmin' => 'Você atingiu o limite do número de contas de usuários de web definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Você atingiu o limite do número de bancos de dados definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Você atingiu o limite do número de caixas de correio definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Você atingiu o limite do número de contas de e-mail definido pela sua chave de licença (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Você atingiu o limite do número de malas diretas definido pela sua chave de licença (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Você atingiu o limite do número de domínios (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Você atingiu o limite do número de subdomínios (%2) permitido pelo seu fornecedor de serviços',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Você atingiu o limite do número de nomes alternativos de domínio (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Você atingiu o limite de uso de espaço em disco (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Você atingiu o limite na quantidade de uso de largura de banda por mês (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Você atingiu o limite do número de usuários de web (%2) permitido pelo seu fornecedor de serviços.',
    '__limit_exceeded_max_db_userclient' => 'Você atingiu o limite do número de bancos de dados (%2)',
    '__limit_exceeded_max_box_userclient' => 'Você atingiu o limite do número de caixas de correio (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Você atingiu o limite do número de malas diretas (%2)',
    '__limit_exceeded_expiration_userclient' => 'Sua conta expirou em %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Você atingiu o limite do número de subdomínios (%2) permitido pelo seu fornecedor de serviços',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Você atingiu o limite do número de nomes alternativos de domínio (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Você atingiu o limite de uso de espaço em disco (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Você atingiu o limite na quantidade de largura de banda utilizada por mês (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Você atingiu o limite do número de contas de usuário da web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Você atingiu o limite do número de bancos de dados (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Você atingiu o limite do número de caixas de correio (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Você atingiu o limite do número de malas diretas (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Sua conta expirou em %2',

    'sapp_error_validation_not_found' => 'Não é possível validar o aplicativo web porque um dos arquivos necessários (%1) não foi encontrado. Entre em contato com um representante de suporte técnico para obter assistência.',
    'sapp_error_validation_spec_failed' => 'O aplicativo web carregado não está em conformidade com as especificações de AppPacks: %1.',
    'sapp_error_validation_register' => 'Não é possível registrar o aplicativo web localizado no diretório "%1": %2 Você deve remover o aplicativo web do servidor porque ele não funcionará corretamente.',

    'sapp__install_failed' => 'A instalação de aplicativo web não foi bem-sucedida: %1',
    'sapp__install_res_failed' => 'Falha ao criar o recurso solicitado.',

    'server_preferences__subdomains_blog_and_photo' => 'Subdomínios de Criar Blogo e Galeria de fotos por padrão',
    'plesk_key__blog_and_photo' => 'Capacidade de gerenciar o estado-padrão da caixa de seleção de subdomínios de Criar Blog e Galeria de Fotos',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Impossível alterar o tipo de endereço de IP para dedicado, porque ele é atribuído para mais que um usuário.',

    // 8.1.1

    '__write_modify_warning' => 'Selecionar permissões adicionais de gravação/modificação fará com que alguns aplicativos web funcionem corretamente, mas também vai aumentar significativamente os riscos de segurança',
    '__write_modify_subdomain_warning' => 'Selecionar permissões adicionais de gravação/modificação fará com que alguns aplicativos web funcionem corretamente, mas também vai aumentar significativamente os riscos de segurança',

    'phosting__php_incorrect_version_used' => "Foram detectados problemas de versão de PHP. Para resolver esses problemas, marque a caixa de seleção com a versão de PHP necessária abaixo e clique em OK. Para desligar o PHP neste domínio, clique em OK sem selecionar a versão de PHP",
    'fp__mail_preferences' => 'Configurações de e-mail',

    'mail__invalid_white_pattern' => 'O valor especificado é inválido. Use os seguintes formatos: email@exemplo.com para endereços de e-mail, exemplo.com para domínios.',
    'mail__invalid_black_pattern' => 'O valor especificado é invalido. Utilizar o seguinte formato de entrada: mail@example.com para os endereços de e-mail, example.com para domínios.',

    'resp_edit__reply_as_html' => 'Enviar como HTML',
    'exception__path_very_long' => "O caminho está longo demais. Certifique-se de que haja menos que %1 caracteres no caminho.",

    // 8.2


    //SAPP
    'sapp_on' => 'Ligar',
    'sapp_off' => 'Desligar',
    'sapp_directive_aspect' => 'Obrigatório',
    'sapp_databases_num' => 'Bancos de dados',
    'sapp_db_required' => 'Obrigatório',
    'sapp_Required' => 'Obrigatório',
    'sapp_Variant' => 'Variante',
    'sapp_db_id' => 'Id do banco de dados',
    'sapp_db_id_type' => 'DB (id: %1) tipo',
    'sapp_db_id_min_version' => 'DB (id: %1) versão min',
    'sapp_db_id_table_prefix' => 'DB (id: %1) prefixo de tabela',
    'sapp_Default' => 'Valor-padrão',
    'sapp_apache_mod_req' => 'Módulo Apache',
    'sapp_dbtype_not_installed' => 'não instalado',
    'sapp_apache_mod_not_installed' => 'não instalado',
    'sapp_error_invalid_type' => 'O aplicativo "%1" não suporta a ação solicitada.',
    'sapp_error_unknown_app_type' => 'Tipo de aplicação não suportada: %1.',
    'sapp__ssl_text' => 'Instalar o aplicativo no host virtual "http://" ou "https://"?',
    'sapp__app_to_upgrade' => 'Aplicativos a serem atualizados',
    'sapp__upgrade_apps_title' => 'Atualizar aplicativos',
    'sapp__upgrade_to_ver' => 'Atualizar para a versão',
    'sapp__choose_pkg_ver' => 'Selecione um pacote...',
    'sapp__pkg_cant_upgrade_pkg' => 'O pacote "%1" não pode ser usado para atualizar o aplicativo web "%2".',
    'sapp__app_ugrade_error' => 'Não é possível atualizar o aplicativo: %1. Entre em contato com o administrador do sistema.',
    'sapp__no_suitable_db_found' => 'Nenhum banco de dados apropriado encontrado.',
    'sapp__upgrade_success' =>  'O aplicativo foi atualizado com êxito.',
    'sapp__pkg_info_changelog' => 'Histórico de alterações',
    'sapp_requirement_legend' => 'Recursos de hospedagem exigidos pelo aplicativo',

    // other
    'bt_apply' => 'Aplicar',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Para criar um nome alternativo de e-mail, a caixa postal deve ser ativada nesta conta de e-mail. Deseja ativar a caixa postal?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Desativar a caixa postal removerá os nomes alternativos de e-mail, a partir do momento em que eles pararem de funcionar. Deseja desativar a caixa postal?',
    'antivirus__disable_reason_install' => 'Não é possível gerenciar o antivírus porque ele não está instalado.',
    'antivirus__disable_reason_key' => 'Não é possível gerenciar o antivírus porque ele não foi ativado por uma chave de licença adequada.',
    'antivirus__disable_reason_deny_personal_settings' => 'Não é possível gerenciar o antivírus porque a política do servidor proíbe configurações de antivírus individuais.',
    'change_foreign_user_password' => 'Alterar senha',
    'change_foreign_user_password_hint' => "O usuário não pertence a este aplicativo. Clique no link para ir a outro aplicativo e alterar a senha do usuário nele.  Para fazer isso, você deve ter os direitos adequados no aplicativo.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Formato de string',
    'lang_unknown' => 'Idioma desconhecido',
    'pb__cl_ed' => 'Detalhes do cliente',
    'pb__actionlog' => 'Registro de ações',
    'pb__cl_limits' => 'Limites do cliente',
    'pb__edit' => 'Editar',
    'pb__subdom_edit' => 'Configurações de hospedagem',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Efetuar o backup das caixas postais',

    'maillist_import_result' => "\nValor total dos endereços de e-mail em arquivo: %1\nquantidade de endereços de e-mail importados: %2\nquantidade de endereços de e-mail já existentes: %3\nquantidade de endereços de e-mail duplicados no arquivo especificado: %4\nQuantidade total de endereços de e-mail no arquivo: %5",
    'maillist_import_error' => 'Impossível importar a lista de endereços de e-mail',

    //  spaw

    'spaw__unable_to_edit_no_body' => "O arquivo selecionado está vazio ou não é um documento HTML válido na codificação selecionada. Selecione a codificação correta ou simplesmente adicione conteúdo ao arquivo.",

    'dom_pref__external_mail_srv' => "Redirecione um servidor de e-mail externo com o endereço de IP:",
    'mn_edit__store_messages' => 'Caixa postal',

    // aps

    'sapp__before_upgrade_notice' => 'É recomendável fazer backup dos dados de usuário e aplicativo antes de iniciar o processo de atualização.',
    'sapp__application_properties' => 'Propriedades do aplicativo',
    'sapp__application_root_descr' => 'A página principal do aplicativo',

    'sapp__aps_license_invalid_id' => 'Chave de licença tem ID inválida: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Já existe uma licença com o número de chave %1 no banco de dados.',
    'sapp__aps_lic_del_used' => 'Não é possível excluir a chave de licença, ela está sendo usada por um dos aplicativos instalados.',
    'sapp__aps_lic_del_unknown' => 'Não é possível excluir a chave de licença: %1',
    'sapp__aps_cappi_duplicate' => "Este aplicativo já está no pool de aplicativos do cliente",
    'sapp__appi_not_shared_no_install' => "Não há uma aplicação desse tipo no pool de aplicativos do cliente. Se você deseja instalar este aplicativo em um site, deve primeiro adicioná-lo ao pool de aplicativos do cliente.",
    'sapp__appi_shared_not_client' => "Não há uma aplicação desse tipo no pool de aplicativos do cliente. Se você deseja fazer o upgrade deste aplicativo para a versão especificada, deve primeiro adicionar esta versão ao pool de aplicativos do cliente.",
    'sapp__apply_license_script_not_found' => 'Não foi possível encontrar o script "apply-license" para este aplicativo web.',
    'sapp__unable_to_activate_key' => 'Ocorreu um erro durante uma tentativa de ativar uma chave de licença: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Existem aplicativos web instalados que exigem a presença deste aplicativo web no sistema.',
    'sapp__unable_to_delete_ai_in_pool' => 'Este aplicativo ainda está no pool do cliente. Se você deseja remover este aplicativo, precisa primeiro removê-lo de todos os pools de aplicativos dos clientes ou fazê-lo gratuitamente.',
    'sapp__unable_to_delete_app_template' => 'Não é possível remover o aplicativo #%1: %2',
    'sapp__limit_exceeded_client' => 'Você atingiu o limite quanto ao número de vezes que pode instalar este aplicativo web (%2).',


    // atis module

    '_week_on' => 'semana em',
    '__week_first' => 'primeiro',
    '__week_second' => 'segundo',
    '__week_third' => 'terceiro',
    '__week_fourth' => 'quarto',
    '__week_last' => 'último',
    '__not_started' => 'Esperando',
    '__started' => 'Em execução',
    '__cancel_pending' => 'Cancelando',
    '__canceled' => 'Cancelado',
    '__error' => 'Erro',
    '__done' => 'Concluído',

    '__php_cgi_handler' => 'Aplicativo CGI',
    '__php_isapi_handler' => 'Extensão ISAPI',
    '__php_fastcgi_handler' => 'Aplicativo FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'executar como',

    'cf_dbfolder_text' => 'Pasta do banco de dados',
    'cf_isnewdb_text' => 'Criar banco de dados',
    'cf_isnewdb_title' => 'Selecionar a caixa de seleção se o banco de dados precisa ser criado',

    'pb__site_apps_upgrade' => 'Atualização de aplicativos da web',

    'detach' => 'Desconectar',
    'preferences' => "Alterar senha",

    'toolsbar__switch_user?' => "Tem certeza de que deseja efetuar login em outra conta de usuário?",
    '__aps_left' => 'Instalações faltando',
    'aps__license_key' => 'Chave de licença',
    'aps__download_code' => 'Código de ativação e download da chave de licença',
    'aps__license_key_hint' => 'Recuperar a partir do servidor de licenças usando o código de ativação',
    'aps__database_not_available' => 'não está disponível, verifique os limites de cliente ou domínio',
    'aps__yes' => 'sim',
    'aps__no' => 'não',
    '__click_to_enlarge' => 'Clique para ampliar.',
    'site_apps__back_to_list' => 'Voltar à lista',
    'sapp__pkg_info_installation_requirements' => 'Requisitos de instalação',
    '__close_window' => 'Fechar',

    //SAPP END

    'skin_info__already_default' => 'A aparência já está definida como a aparência-padrão.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Configurações do Plesk Premium Antivirus para %1',
    'drweb:properties_legend' => 'Configurações',
    'drweb:status' => 'Verificação de vírus em e-mail',

    // sb integration
    'sitebuilder_wizard' => 'Assistente do Presence Builder',
    'dom_site_builder' => 'Clique para abrir o Assistente do Presence Builder.',
    'sb_plesk_admin_url' => 'URL do servidor do Presence Builder. Certifique-se de que este endereço resolve corretamente no DNS',
    'sb_plesk_admin_login' => 'Nome de usuário para login do administrador do servidor para o Presence Builder',
    'sb_plesk_admin_password' => 'Senha do administrador',
    'sb_sitebuilder_preferences' => 'Credenciais do administrador do Presence Builder',
    'sb__server' => 'Preferências do administrador do sistema do Presence Builder',
    'sb__sitebuilder_support' => 'Suporte ao Presence Builder',
    'sb_keep_sb_user' => 'Manter a conta de usuário correspondente no Presence Builder',
    'sb_create_sb_user' => 'Criar uma conta de usuário correspondente no Presence Builder',
    'sb__build_site_using_sitebuilder' => "Criar site usando o Presence Builder",
    'sb_no_current_sb_server_set' => 'A conexão com o Presence Builder ainda não está configurada: você precisa adicionar um registro A no modelo de zona DNS que apontará para o servidor do Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Não é possível recuperar as informações do sistema do Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Não é possível conectar-se ao Presence Builder: nome de usuário ou senha errados.",
    'sb_init_sb_manager' => "Inicializando o gerenciador do Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Falha ao conectar-se ao sistema do Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Este cliente não tem uma conta de usuário no Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "O Presence Builder não está configurado.",
    'sb_err_you_dont_have_sbaccount' => "Falha ao autorizar você no Presence Builder.",
    'sb_error_critical_during_operation' => "O seguinte erro ocorreu no Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Suporte para logon único não está ativado no Plesk.",

    'warning__super_zone_exist' => "A zona %1 foi criada; no entanto, este nome de zona é uma subzona de outra zona já existente %2, que pertence a outro usuário %3. Isso é possível, mas certifique-se de que você selecionou a conta de usuário correta.",
    'error__super_zone_exist' => "Não é possível criar a zona DNS porque sua superzona pertence a outro usuário.",

    'locales__files_not_exits' => 'Não é possível alterar a localidade: os arquivos de pacote de idiomas de interface especificados não existem no sistema.',
    'locales__unavailable' => 'Não é possível alterar a localidade: o pacote de idiomas de interface especificado não está disponível.',

    // DB BU

    'pb__dbbackup_list' => 'Arquivos de backup do banco de dados',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Diretório de rede temporário',
    'dbbackup__network_user' => 'Nome do usuário',
    'dbbackup__network_pass' => 'Senha',
    // domain
    'dbbackup__add_database_legend' => 'Restaurar o banco de dados cujo backup foi efetuado',
    'dbbackup__add_database_restore' => 'Restaurar o banco de dados a partir do arquivo de backup',
    'dbbackup__add_database_file' => 'Arquivo de backup do banco de dados',
    'dbbackup__add_database_user' => 'Nome de usuário padrão',
    'dbbackup__add_database_pass' => 'Senha de usuário padrão',
    'dbbackup__add_database_pass2' => 'Confirmação de senha de usuário padrão',

    'bt_dbbackup_now' => 'Fazer backup',

    'bt_repair' => 'Reparar',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Fazer o upload dos descartes da base de dados do SQL Server é proibido pelo provedor da hospedagem.',

    // APS categories

    'cf_invalid_password' => 'A senha não pode conter mais que 16 caracteres',
    'cf_invalid_description_length' => 'A descrição não pode conter mais que 256 símbolos',
    'ip_addr__ip_used_by_external_mail_server' => 'O endereço de IP %1 já é utilizado pelo servidor de e-mail externo',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Nome de usuário ou senha FTP é inválido. Especifique credenciais de usuário FTP corretas.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Foi atingido o limite de alterações de número de série. Mais nenhuma alteração de zona DNS pode ser realizada hoje.',
    'dns__zone_apply_changes' => 'As alterações feitas nos registros DNS ainda não foram salvas. As alterações feitas estão destacadas a seguir. Clique em Atualizar para aplicar as alterações à zona DNS ou clique em Reverter para abandonar as alterações.',
    'dns__update_dns_zone' => 'Clique para salvar as alterações feitas nos registros DNS',
    'dns__revert_dns_zone' => 'Clique para cancelar as alterações feitas nos registros DNS',
    'bt_revert' => 'Reverter',
    'dns__dns_zone_has_beed_updated' => 'As alterações feitas em registros DNS foram salvas.',
    'dns__dns_zone_has_beed_reverted' => 'As alterações feitas em registros DNS foram canceladas',
    'db__nondefault_server_not_allowed' => 'Não é permitida a utilização do servidor de banco de dados não-padrão',

    'site_apps__non_removable' => 'Itens que não podem ser removidos',
    'site_apps__non_removable_items' => 'Os seguintes aplicativos web não podem ser removidos:',

    'rpt_reseller_section_general' => 'Geral',
    'rpt_reseller_section_domains' => 'Domínios',
    'rpt_reseller_section_clients' => 'Clientes',
    'statistics__cl_active_domains' => "Domínios ativos",
    'rpt_reseller_cl_domains' => "Domínios",
    'rpt_reseller_cl_subdomains' => "Subdomínios",
    'by__cl_domains' => "domínios dos clientes",
    'dom_ctrl__cl_mboxes' => "Caixas de e-mail",
    'rpt_reseller_cl_redirects' => "Páginas de redirecionamento",
    'rpt_reseller_cl_mail_groups' => "Grupos de correio",
    'rpt_reseller_cl_mail_resps' => "Respostas automáticas",
    'rpt_reseller_cl_mail_lists' => "Mala direta",
    'rpt_reseller_cl_web_users' => "Usuários da web",
    'rpt_reseller_cl_data_bases' => "Bancos de dados",

    'statistics__active_clients' => 'Clientes com assinaturas ativas',
    'statistics__clients_active_domains' => 'Domínios ativos',
    'statistics__clients_doms' => 'Domínios',
    'statistics__cl_doms' => 'Domínios',
    '__clients_subdomains' => 'Subdomínios',
    '__clients_domains' => 'Domínios',
    'dom_ctrl__clients_mboxes' => 'Caixas de e-mail',
    'dom_ctrl__clients_redir' => 'Páginas de redirecionamento',
    'dom_ctrl__clients_mg' => 'Grupos de correio',
    'dom_ctrl__clients_resp' => 'Respostas automáticas',
    'dom_ctrl__clients_maillists' => 'Mala direta',
    'dom_ctrl__clients_wu' => 'Usuários da web',
    'dom_ctrl__clients_db' => 'Bancos de dados',

    'dom_ctrl__cl_redir' => 'Páginas de redirecionamento', // to resolve!
    'dom_ctrl__cl_mg' => 'Grupos de correio', // to resolve!
    'dom_ctrl__cl_resp' => 'Respostas automáticas', // to resolve!
    'dom_ctrl__cl_maillists' => 'Mala direta', // to resolve!
    'dom_ctrl__cl_wu' => 'Usuários da web', // to resolve!
    'dom_ctrl__cl_db' => 'Bancos de dados', // to resolve!

    'rpt_cl_section_clients' => 'Clientes',

    'rpt_admin_section_general' => 'Geral',
    'rpt_admin_section_resellers' => 'Revendedores',
    'rpt_admin_section_clients' => 'Clientes',
    'rpt_admin_section_personal_clients' => 'Clientes próprios',
    'rpt_admin_section_domains' => 'Domínios',
    'rpt_admin_section_personal_domains' => 'Domínios pessoais',

    'rpt_reseller_section_personal_domains' => 'Domínios pessoais',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Permitir excesso de vendas",
    'limits__reseller_oversell_description' => "O excesso de vendas permite que o revendedor venda mais recursos do que os que realmente foram alocados para ele. Se for permitido excesso de vendas, o revendedor é regido pelo uso de recursos real em vez da alocação inicial de recursos",
    'limits__overuse_block_text' => "Política de abuso na utilização",
    'limits__overuse_block_true_text' => "O abuso de utilização não é permitido",
    'limits__reseller_overuse_block_true_description' => "Bloquear o uso excessivo de recursos. O uso de recursos reais não pode exceder a alocação inicial de recursos",
    'limits__overuse_block_false_text' => "O abuso da utilização é permitido",
    'limits__reseller_overuse_block_false_description' => "Não bloquear o uso excessivo de recursos, permitindo que o revendedor use mais recursos do que o inicialmente previsto. O uso de recursos reais pode exceder a alocação inicial de recursos",
    'limits__reseller_overuse_notify_text' => "Notificar o revendedor sobre atingir os limites de recursos",
    'reseller_perm__manage_sh_access_disabled' => "O revendedor não pode permitir ou proibir acesso a shell",
    'reseller_perm__manage_sh_access_chrooted' => "O revendedor pode permitir o acesso somente a um ambiente com chroot",
    'reseller_perm__manage_sh_access_any' => "O revendedor pode permitir o acesso a qualquer tipo de shell",
    'template__reseller_num_excl_ips' => "Alocar endereços IP dedicados para o revendedor",

    // Reseller's Home page
    'domains__reseller_info' => "%1 clientes, %2 domínios, %3 espaço em disco usado, %4 de dados transferidos.",
    'domains__reseller_info_hiding_traffic' => "%1 clientes, %2 domínios, %3 espaço em disco usado.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Todos os aplicativos da web agora são classificados por categorias, o que torna mais fácil a escolha do aplicativo certo para instalação.",
    'feature__domainkeys__reseller' => "Você pode usar o mecanismo de autenticação do emissor de e-mail DKIM para reduzir a quantidade e-mails com spam e com phishing.",

    '__reseller_form' => "Formulário de revendedor",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Disponibilizar este modelo para outros usuários",
    'template__shared_description' => "Selecione esta opção se deseja que seus clientes possam utilizar este modelo.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "O administrador do domínio não pode permitir ou proibir acesso a shell",
    'domain_perm__manage_sh_access_chrooted' => "O administrador do domínio pode permitir o acesso somente a um ambiente com chroot",
    'domain_perm__manage_sh_access_any' => "O administrador do domínio pode permitir o acesso a qualquer tipo de shell",

    // APS Catalog
    'bt_add_to_vault' => "Adicionar ao Cofre",
    'bt_hide_updates' => "Ocultar atualizações disponíveis",
    'bt_show_updates' => "Mostrar atualizações disponíveis",

    '__site_apps__applications' => "Aplicativos",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplicativos selecionados para adição ao cofre",
    'site_apps__application_selected' => "Selecionado",
    'site_apps__currently_in_vault' => "Outras versões já no cofre:",
    'site_apps__new_versions' => "Novas versões:",
    'site_apps__patches' => "Patches:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Número de aplicativos agendados para adição ao cofre:  %1",
    'site_apps__applications_downloading_now' => "Agora estão sendo baixados os seguintes aplicativos: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Já no cofre",

    // Server > Action Log
    'bt_skin_edit' => "Editar descrição de skin",
    'limits__oversell_legend' => "Excesso de vendas",
    'limitsManager__limit_available_error' => "Não é possível alocar a quantidade necessária de recursos (%%quantity%% %%limitName%%). Somente %%available%% %%limitName%% estão disponíveis.",
    'limitsManager__limit_reserved_error' => "Não é possível definir o limite de uso do recurso necessário (%%quantity%% %%limitName%%) porque o novo valor é menor do que a quantidade de recursos reservados para os seus clientes ou é usado por você mesmo (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Não é possível definir o limite de uso do recurso necessário (%%quantity%% %%limitName%%) porque o novo valor é menor do que a quantidade real de recursos já usados por sua conta e sites (%%used%% %%limitName%%).",

    'domains_list__resource__filter_title' => "Uso de recursos",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catálogo de aplicativos APS",
    'site_apps__applications_have_updates' => "As versões atualizadas dos seguintes aplicativos estão disponíveis:\n%1\nPara ver as atualizações, verifique se a área Search está visível, selecione a caixa de seleção <b>Mostrar somente atualizações</b> e pesquise os aplicativos que precisa.",
    'site_apps__progress_adding_to_vault' => "Adicionando ao cofre: ",
    'site_apps__progress_done_message' => "Progresso:",
    'site_apps__progress_applications_left' => "%1 de %2 aplicações faltando",
    'site_apps__download_item_long_task_title' => "Efetue o download do aplicativo APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Efetue o download de aplicativos APS do Catálogo APS",
    'site_apps__last_check_for_updates' => "última verificação de atualizações: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Todos os aplicativos agendados foram adicionados com sucesso ao Cofre de Aplicativo",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aplicativos agendados foram adicionados com sucesso ao Cofre de Aplicativo.",
    'site_apps__no_search_results' => 'Nenhum aplicativo encontrado. Tente fazer pesquisas diferentes ou procure aplicativos por categorias.',
    'site_apps__search_results_title' => 'Resultados da busca',
    '__site_apps__search_by_application' => 'Nome do aplicativo',
    '__site_apps__search_by_vendor' => 'Fornecedor',
    '__site_apps__search_by_vendor__all' => 'Todos os fornecedores',
    '__site_apps__search_by_packager' => 'Empacotador',
    '__site_apps__search_by_certification_level' => 'Nível de certificação',
    '__site_apps__search_by_cert__any' => 'Qualquer',
    '__site_apps__search_by_cert__silver_and_higher' => 'Prata e superior',
    '__site_apps__search_by_cert__gold_and_higher' => 'Ouro e superior',
    '__retry' => 'Tentar novamente',
    'site_apps__application_packager_site' => 'Empacotador',
    'site_apps__add_to_pool_message' => "Os aplicativos marcados como \"disponível para todos\" são automaticamente distribuídos a todos os revendedores e clientes com uma quantidade ilimitada de instalações. Os aplicativos restritos são distribuídos manualmente a todos os revendedores e clientes  em uma base individual, com um número de instalações disponíveis explicitamente especificado.",
    'site_apps__make_available_for_all' => "Disponibilizar aplicativos selecionados para todos os usuários",

    'site_apps__broadcast_app_text' => "Os aplicativos marcados como \"disponível para todos\" são automaticamente distribuídos a todos os revendedores e clientes com uma quantidade ilimitada de instalações. Os aplicativos restritos são distribuídos manualmente a todos os revendedores e clientes  em uma base individual, com um número de instalações disponíveis explicitamente especificado.",
    'site_apps__broadcast_app_name' => 'Disponibilizar aplicativos para todos os usuários',

    // User Application Pool per application
    'site_apps__available_clients' => 'Usuários disponíveis',
    'site_apps__no_more_clients_to_add_to_pool' => 'Não há mais contas de usuário que você pode fornecer a este aplicativo para',

    // Installed application instances
    'site_apps__installations' => 'Instalações',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nome de domínio e endereço IP",
    '__assign_ip_address' => "Atribuir endereço IP",
    '__switch_on_service' => "Ativar serviço",
    '__hosting_configuration' => "Configuração de hospedagem",
    '__vrt_hst' => "Hospedagem de site",
    '__vrt_hst_hint' => "Hospedar um site neste servidor.",
    '__fwd' => "Redirecionamento",
    '__web_hosting_settings' => "Configurações de hospedagem",
    '__fwd_hint' => "Redirecionar os visitantes para outro site.",
    '__none_hint' => "Não hospedar um site no momento.",
    '__login_hint' => "Este nome de usuário é usado para acessar seu site por meio de FTP",
    '__password_hint' => "Esta senha é usada para acessar seu site por meio de FTP",
    '__advanced_hosting_setup' => "Configurar configurações avançadas de hospedagem web",
    '__domain_creation_successful' => "O domínio foi criado.",
    'bt_hosting_settings' => "Configurações de hospedagem",
    '__change_hosting_type' => "Alterar o tipo de hospedagem para domínio %1",
    '__hosting_type_change_warning' => "Quando você alterar o tipo de hospedagem para encaminhamento ou deixar sem hospedagem, todos os arquivos e diretórios relacionados ao seu site serão removidos do servidor. Certifique-se de salvar uma cópia local do seu site.",
    '__current_hosting_type' => "Tipo de hospedagem atual",
    '__new_hosting_type' => "Novo tipo de hospedagem",
    '__fwd_settings' => "Configurações de encaminhamento",
    '__fwd_settings_legend' => "Configurações de encaminhamento",
    '__fwd_destination_url' => "URL de destino",
    '__fwd_type' => "Tipo de redirecionamento",
    '__fwd_type_standart' => "Encaminhamento padrão",
    '__fwd_type_standart_hint' => "Redirecionar os visitantes do site para outro site e mostrar-lhes o endereço de destino, para que saibam sobre o redirecionamento.",
    '__fwd_type_frame' => "Redirecionamento de quadro",
    '__fwd_type_frame_hint' => "Redirecionar os visitantes do site para outro site, mas não mostrar-lhes o endereço de destino, para que não saibam sobre o redirecionamento.",
    '__hosting_type_template_warning' => "O tipo de hospedagem selecionado é diferente do tipo especificado no modelo. Se você continuar, as configurações de hospedagem da web no modelo selecionado serão ignoradas. Tem certeza de que deseja definir o tipo selecionado de hospedagem?",

    '__no_resellers_selected' => "Você deve selecionar pelo menos uma conta de revendedor.",

    'ippool_Manager__no_available_ips' => "Não há endereços IP vagos no pool de IP.",
    'ippool_Manager__ip_shared' => "compartilhado",
    'ippool_Manager__ip_exclusive' => "dedicado",

    'ippoolManager__ip_shared' => "compartilhado",
    'ippoolManager__ip_exclusive' => "dedicado",

    '__users_list' => "Usuários",
    '__users' => "Usuários",
    '__user_name' => "Nome do usuário",

    'limit__name_max_dom_aliases' => "nomes alternativos de domínio",
    'limit__name_max_subftp_users' => "contas de FTP adicionais",
    'limit__name_max_mssql_db' => "Bancos de dados do Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Conjuntos de aplicativos IIS",
    'limit__name_max_odbc' => "Conexões ODBC",
    'total_mboxes_quota_unsupported' => 'não suportado pelo servidor de e-mail',
    'limit_soft__disk_space' => 'Notificar ao alcançar espaço limite do disco',
    'limit_soft__max_traffic' => 'Notificar ao alcançar tráfego limite',
    'limitsManager__commit_failed' => "Não é possível alterar os limites de recursos.",
    'limitsManager__date_in_past' => "Data de vencimento incorreta %1.",
    'limitsManager__limit_not_supported' => "Não é possível definir limites para o tipo de recurso %1.",
    'limitsManager__limit_oversell_inconsistency' => "Não é possível alocar os valores especificados de recursos com excesso de vendas desativado.",
    'limitsManager__limit_overuse_inconsistency' => "Uso do recurso ultrapassa os limites definidos.",
    'limitsManager__no_resource_available' => "Não existem recursos disponíveis deste tipo (%%limitName%%) sobrando. Solicitado: %%quantity%%; disponível: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Não existem recursos deste tipo (%%limitName%%) disponíveis pelo seu provedor de serviços. Solicitado: %%quantity%%; disponível: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "A data de validade deve ser menor ou igual a %1.",
    'limitsManager__invalid_disk_space_limit' => "A quantidade de espaço em disco deve ser menor ou igual a %1.",
    'limitsManager__invalid_max_traffic_limit' => "A quantidade de tráfego deve ser menor ou igual a %1.",
    'ippoolManager__ip_has_suballocations' => "Não é possível alterar o tipo de endereço IP já alocado a um usuário. O endereço IP %%ip%% já está alocado ao(s) usuário(s) como endereço IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Este endereço IP já está atribuído ao usuário.",
    'ippoolManager__ip_is_not_in_pool' => "Não há nenhum endereço IP %%ip%% no pool.",
    'ippoolManager__can_not_allocate_ip' => "O endereço IP %%ip%% está disponível apenas como %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "O endereço IP %%ip%% não pode ser alocado como dedicado.",
    'ippoolManager__ip_used_by_hst_or_frw' => "O endereço IP %%ip%% já é usado para hospedagem.",
    'ippoolManager__active_anon_ftp_on_ip' => "O acesso FTP anônimo já está ativado para o endereço IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Não há endereços IP vagos.",
    'ippoolManager__no_available_ips' => "Não há endereços IP disponíveis.",
    'templates__dublicate_name' => "Um modelo com esse nome já existe. Selecione outro nome para este modelo.",
    'cl_perm__client_limits_exceeded' => "Os valores de limite de recurso especificados ultrapassaram os valores permitidos pelo seu plano de hospedagem ou esses valores oferecem menos recursos do que os atualmente usados por seus sites.",
    'cl_perm__reseller_limits_exceeded' => "Os valores de limite de recurso especificados ultrapassaram os valores permitidos pelo seu plano de hospedagem ou esses valores oferecem menos recursos do que os atualmente usados por sites e contas de usuário.",

    'site_apps__preferences_show_all_versions_title' => "Visualizar a lista completa de versões para cada aplicativo recuperado do catálogo",
    'site_apps__preferences_show_all_versions_hint' => "Se esta opção estiver selecionada, pode levar um tempo considerável para recuperar todas as versões de cada aplicativo a cada vez que o catálogo for aberto. Se essa opção não estiver selecionada, apenas as versões mais recentes serão mostradas.",
    '__select_user_template' => "Criar conta de usuário com base em um modelo",
    'ip_already_added_to_all_clients' => "Este endereço IP já está atribuído a todos os usuários.",

    'site_apps__cancelled_apps' => "Você cancelou a adição dos seguintes aplicativos: %2",

    'sb_url_is_not_resolved' => 'A URL não pode ser resolvida: verifique suas configurações de DNS. A URL %1 deve ser resolvida no endereço IP do servidor com o Presence Builder instalado.',

    'ip_addr__is_last_on_interface' => 'Não é possível remover o endereço IP %%ip%% porque ele é o último endereço IP presente em uma interface de rede.',
    'ip_addr__used_for_current_session' => 'Não é possível remover o endereço IP %%ip%% porque ele é usado por uma sessão ativa.',
    'ip_addr__used_for_hosting' => 'Não é possível remover o endereço IP %%ip%% porque ele é usado para hospedar um site.',
    'ip_addr__is_main' => 'Não é possível remover o endereço IP %%ip%% porque ele é o endereço IP primário de uma interface de rede.',
    'ip_addr__ip_used_by_message_submission' => 'Não é possível remover o endereço IP %%ip%% porque ele é usado para o envio de mensagens de correio',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domínios de clientes',
    'excl_ip_num' => 'Endereço IP dedicado',

    'sb_err_sitebuilder_not_installed' => 'O Presence Builder não está instalado.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Permissão para permitir que oversell não possa ser revogado do usuário desde que o usuário já tenha alocado mais recursos do que os disponíveis, entrando em modo oversell.',
    'limitsManager__invalid_limit_value' => 'Valor incorreto %%value%% especificado para o limite %%limit_name%%',
    'limit__max_mn' => 'Número máximo de contas de e-mail',

    'limits__client_overuse_description' => 'A política de uso informa z ao Plesk o que fazer quando o uso de recursos excede a alocação inicial de recursos.',
    'limits__client_overuse_block_true_description' => 'Bloquear o uso excessivo de recursos. O uso de recursos reais não pode exceder a alocação inicial de recursos',
    'limits__client_overuse_block_false_description' => 'Não bloquear o uso excessivo de recursos, permitindo que o cliente use mais recursos do que o inicialmente previsto. O uso de recursos reais pode exceder a alocação inicial de recursos',
    'limits__client_overuse_notify_text' => 'Notificar o cliente sobre atingir os limites de recursos',

    'limits__domain_overuse_description' => 'A política de uso informa z ao Plesk o que fazer quando o uso de recursos excede a alocação inicial de recursos.',
    'limits__domain_overuse_block_true_description' => 'A política de uso informa ao Plesk o que fazer quando os recursos são usados em excesso.',
    'limits__domain_overuse_block_false_description' => 'Não bloquear o uso excessivo de recursos, permitindo que o domínio use mais recursos do que o inicialmente previsto. O uso de recursos reais pode exceder a alocação inicial de recursos',
    'limits__domain_overuse_notify_text' => 'Notificar o proprietário do domínio sobre atingir os limites de recursos',

    'dns__dns_rr_delete' => 'Itens que serão removidos',
    'dns__delete_rr' => 'Os seguintes registros DNS serão removidos da zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Itens que não podem ser removidos',
    'dns__non_delete_rr' => 'Os seguintes registros DNS não podem ser removidos:',
    'dns__dns_rr_delete_confirm_message' => 'Confirmar a remoção de registros DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Formato de aplicativo web desconhecido: aplicativo web pode não estar disponível para instalação e uso.',

    '__php_handler_type_desc' => 'Executar o PHP como',
    'sfdk_domain_sign__failed' => 'Ocorreu um erro não identificado ao tentar ativar a assinatura do e-mail com DKIM no domínio. Consulte o log de erros do servidor para obter mais informações.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notificação de sucesso na atualização de chave do Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notificação de adiamento na atualização de chave do Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notificação de erro na atualização de chave do Plesk',
    'pkey_notify__update_successful' => 'Atualização de %1 foi concluída com êxito.',
    'pkey_notify__update_failed_no_more_try' => 'Não é possível atualizar %1. A chave que você está tentando enviar é inválida. Você não deve mais tentar atualizar esta chave.',
    'pkey_notify__update_failed_try_later' => 'Não foi possível atualizar %1: ocorreu um erro ao processar sua chave. Você pode tentar recuperar a chave manualmente no Plesk (Ferramentas & Configurações > Informações de licença) ou deixar o Plesk tentar atualizá-la nas próximas 24 horas. Caso não queira mais receber esta notificação, remova esta chave do Plesk.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domínios',
    'rpt_reseller_dom_subdomains' => 'Subdomínio',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Páginas de redirecionamento',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivírus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Clientes',
    '__cl_name' => 'Nome do cliente',
    '__cl_creation_date' => 'Data de criação',
    '__clients_traffic' => 'Tráfego do cliente',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivírus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'O Presence Builder não está instalado.',
    'sitebuilder_disabled' => 'O Presence Builder está desativado.',
    'b_sitebuilder_disabled' => 'O Presence Builder está desativado.',
    'webmail_not_installed' => 'O software de webmail não está instalado.',
    'webmail_disabled' => 'O serviço de webmail está desativado.',
    'spamassassin_not_installed' => 'O SpamAssassin não está instalado.',
    // pfu:
    'anonymous_ftp_shared' => 'Não é possível configurar FTP anônimo: tipo de endereço IP compartilhado.',
    'anonymous_ftp_used' => 'Não é possível configurar FTP anônimo: o endereço IP é usado por outro domínio para o serviço FTP anônimo.',
    // pfw:
    'aspdotnet_not_installed' => 'O ASP.NET não foi instalado.',
    'site_builder_no_package' => 'O Presence Builder não está disponível. Verifique se o Presence Builder está instalado e selecionado como um componente ativo.',
    'site_builder_not_configured' => 'O Presence Builder não está configurado.',

    // various

    'disabled_by_admin' => 'Desativado pelo administrador do servidor',

    '__not_allowed' => 'Não permitido',

    '__ip_addr_state_unknown' => "O endereço IP não está funcionando agora porque o sistema ainda está processando sua solicitação. Aguarde um instante.",

    'ip_addr__repair_is_not_allowed' => 'O endereço IP não pode ser reparado em ambiente Virtuozzo.',

    'ippoolManager__ip_used_by_nohost_domain' => "O endereço IP %%ip%% não pode ser removido porque esta sendo usado por um ou mais domínios sem hospedagem.",
    'ippoolManager__ip_used_for_mail_service' => "O endereço IP %%ip%% não pode ser removido porque é usado por um ou mais domínios para seus endereços IP de serviço de e-mail.",
    'ippoolManager__ip_used_for_send_emails' => "O endereço IP %%ip%% não pode ser removido porque é usado para enviar e-mails de um IP específico (consulte Configurações do Servidor de E-mail).",
    'ippoolManager__ip_used_in_dns_zone' => 'O endereço IP %%ip%% não pode ser removido porque ele é usado pela zona DNS de um ou mais domínios.',
    'ip_ctrl__cannot_manage_on_vz' => 'Esta instalação do Plesk está funcionando no Virtuozzo containers. Novos endereços de IP podem ser adicionados apenas pelo administrador de nós do Virtuozzo containers.',

    'client_template__limits_auto_adjusted' => 'Os limites do modelo de cliente foram ajustados automaticamente.',

    '__entries' => 'Entradas',

    '__path_is_not_set' => 'O caminho não é especificado. Especifique um caminho válido.',

    'defaultcomponents__imap_required' => '(O servidor de e-mail atual não suporta IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk suporta apenas software de estatísticas de web comercial para cálculo de estatísticas do subdomínio. Esse software não está instalado atualmente no sistema.',


    'server_settings_invalid_traffic_statistics' => 'Parâmetro de estatísticas de tráfego de retenção inválido.',
    'server_settings_invalid_logrotate_period' => 'Parâmetro de período de rotação de log inválido.',

    'spam_filter/address/file_size' => 'Não foi possível fazer o upload do arquivo. O tamanho máximo de um arquivo para upload é %1.',
    'spam_filter/address/file_empty_content' => 'Ocorreu um problema ao ler os endereços de e-mail do arquivo. Certifique-se de enviar um arquivo na codificação UTF-8 contendo um ou mais endereços de e-mail e tente novamente.',
    'spam_filter/address/addresses_empty_content' => 'Não há nenhum endereço de e-mail na lista.',
    'spam_filter/address/addresses_available' => 'Apenas os %1 primeiros endereços de e-mail exclusivos serão adicionados.',
    'spam_filter/address/invalid_addresses' => 'Os seguintes endereços de e-mail são inválidos: %1.',

    'current_resources' => 'Recursos atuais',
    'plan_limitations' => 'Limitações do plano',
    'cannot_switch_plan' => 'Não é possível alternar para o plano selecionado porque os seguintes recursos atuais estão excedendo as limitações do plano:',
];