<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installing %%name%% at %%path%%...',
    'aps-install.queueNoPath' => 'Installing  %%name%%...',
    'aps-install.done' => '%%name%% was successfully installed at %%path%%. You can see your credentials for logging in to the application below. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% was successfully installed. You can see your credentials for logging in to the application below. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% was successfully installed at %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% was successfully installed. %%additionalMessage%%',
    'aps-install.error' => 'Installation of %%name%% at %%path%% failed. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Installation of %%name%% failed. %%errorMessage%%',

    'aps-update.queueDownload' => 'Downloading %%packageName%%...',
    'aps-update.errorDownload' => 'Downloading of %%packageName%% has failed:',
    'aps-update.queueInstall' => 'Updating an installation of %%name%% for %%domainName%%...',
    'aps-update.doneInstall' => 'The installation of %%name%% for %%domainName%% was successfully updated.',
    'aps-update.errorInstall' => 'Updating an installation of %%name%% for %%domainName%% has failed:',
    'aps-update.queueInstallMulti' => 'Updating %%instances%% installations of %%name%%...',
    'aps-update.doneInstallMulti' => '%%successes%% installations of %%name%% were successfully updated.',
    'aps-update.errorInstallMulti' => 'Updating of %%failures%% installations of %%name%% has failed:',
    'aps-update.incorrectUpdateInformation' => 'The update information is incorrect.',

    'common.hideCompletedTasks' => 'Hide Completed',
    'common.progressBarHide' => 'Hide',
    'common.progressBarShow' => 'Show',
    'common.close' => 'Close',
    'common.refresh' => 'Refresh Page',
    'common.taskInProgress' => '%%count%% tasks in progress...',
    'common.percentCompleted' => '%%percent%%% completed',
    'common.allTasksCompleted' => 'All %%num%% tasks were successfully completed.',
    'common.minimize' => 'Minimize',
    'common.statusDone' => 'Done',
    'common.statusError' => 'Failed',
    'common.statusNotStarted' => 'Queued',
    'common.statusCanceled' => 'Canceled',
    'common.progressDialogLink' => 'detailed progress',
    'common.progressLabel' => '%%count%% in progress',
    'common.successLabel' => '{count, plural, one {# success} other {# successes}}',
    'common.successLabelTooltip' => 'Close all success notifications',
    'common.warningLabel' => '{count, plural, one {# warning} other {# warnings}}',
    'common.warningLabelTooltip' => 'Close all warning notifications',
    'common.errorLabel' => '{count, plural, one {# error} other {# errors}}',
    'common.errorLabelTooltip' => 'Close all error notifications',

    'database-check.queue' => 'Checking %%database%% database tables...',
    'database-check.done' => 'The %%database%% database has no errors.',
    'database-check.error' => 'Unable to check the %%database%% database for errors.',
    'database-check.done-with-errors' => "The %%database%% database has %%number%% problems. \n %%link%%",
    'database-check.info-link-title' => 'See Details and Resolve',

    'database-download.queue' => 'Preparing a %%database%% dump for exporting...',
    'database-download.done' => 'The dump of %%database%% is ready. You can %%downloadLink%% it.',
    'database-download.downloadLink' => 'download',
    'database-download.error' => 'Unable to export a dump of %%database%%:',

    'database-repair.queue' => 'Repairing %%database%% database tables...',
    'database-repair.done' => 'The %%database%% database has no errors.',
    'database-repair.error' => 'Unable to repair the %%database%% database.',
    'database-repair.done-with-errors' => "The %%database%% database has %%number%% problems. \n %%link%%",
    'database-repair.info-link-title' => 'See Details',

    'database-upload.queue' => 'Importing a dump of %%database%%...',
    'database-upload.done' => 'The dump of %%database%% was imported.',
    'database-upload.error' => 'Unable to import the %%database%% dump:',
    'database-upload.done-with-errors' => "The dump of %%database%% was imported with errors.",
    'database-upload.orphanedUsersSuccess' => 'The database %%database%% was imported successfully. However, some users became orphaned (having no associated logins on the database server). To be able to access your databases, assign logins to these users. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'The following users became orphaned (having no associated logins on the database server): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'View users',

    'domain-app-scan.queue' => 'Scanning for applications...',
    'domain-app-scan.done' => 'Scanning for applications was completed.',
    'domain-app-scan.error' => 'Scanning for applications finished with errors.',

    'domain-move.queue' => 'Moving %%domainName%% to %%webspaceName%%',
    'domain-move.done' => '%%domainName%% was moved to %%webspaceName%%',
    'domain-move.error' => '%%domainName%% was not moved to %%webspaceName%%',

    'domain-split.queue' => 'Moving %%domainName%% to new subscription',
    'domain-split.done' => '%%domainName%% was moved to new subscription',
    'domain-split.error' => '%%domainName%% was not moved to new subscription',

    'file-manager-import-file.done' => 'The %%fileName%% file has been imported to <a href="%%listUrl%%">the %%fileDir%% folder</a>.',
    'file-manager-import-file.error' => 'Unable to import the %%fileName%% file: %%errorMessage%%.<br><a href="%%url%%">Download to my computer</a>',
    'file-manager-import-file.queue' => 'Importing the %%fileName%% file from %%host%%.',
    'file-manager-import-file.progress' => 'Importing the %%fileName%% file from %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'An authentication error occurred. Make sure you provide the correct login and password',
    'file-manager-import-file.errors.resolve' => 'Could not resolve the %%host%% hostname. Make sure you provide the correct URL',
    'file-manager-import-file.errors.connect' => 'Could not connect to the %%host%% server. Make sure you provide the correct URL',
    'file-manager-import-file.errors.notFound' => 'The remote file was not found or is not accessible. Make sure you provide the correct URL and the file is accessible',
    'file-manager-import-file.errors.maxSize' => 'The disk space limit or free space %%diskSpaceLimit%% has been exceeded',
    'file-manager-import-file.errors.lowSpeedTime' => 'Could not import the file because the transfer speed was too slow: less than %%lowSpeedLimit%% bytes were transferred during the last %%lowSpeedTime%% seconds. The website the file is hosted on may be experiencing a lot of traffic at the moment. Try importing the file later',
    'file-manager-import-file.errors.certificate' => 'Could not import the file because the SSL/TLS certificate of the %%host%% server is not trusted. Make sure that the website the file is hosted on is secured with a trusted certificate',
    'file-manager-import-file.errors.redirects' => 'The maximum number of redirects (%%maxRedirects%%) has been exceeded. Make sure the %%host%% server works properly',

    'force-log-rotation.queue' => 'Applying global log rotation settings',
    'force-log-rotation.done' => 'Global log rotation settings were applied.',
    'force-log-rotation.error' => 'Applying global log rotation finished with errors',
    'force-log-rotation.systemLogRotationError' => 'System logs: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Service plan %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domain %%name%%: %%error%%',

    'initial-setup.queue' => 'Initializing Plesk...',
    'initial-setup.done' => 'Plesk has been initialized.',
    'initial-setup.doneWithErrors' => 'An error occurred while initializing Plesk.',
    'initial-setup.error' => 'Initializing Plesk has failed.',
    'initial-setup.step.setupPanel' => 'Setting up Plesk Panel',
    'initial-setup.step.requestLicense' => 'Requesting License',
    'initial-setup.step.configureServer' => 'Configuring Web Server',
    'initial-setup.step.secureServer' => 'Securing the Server',

    'ip-update.queue' => 'Updating IP address',
    'ip-update.done' => 'IP address updated.',
    'ip-update.error' => 'IP Address updating finished with errors',
    'ip-update.updating' => 'Updating IP address',
    'ip-update.updatingWebServer' => 'Updating IP address: updating web server',
    'ip-update.updatingFtpServer' => 'Updating IP address: updating FTP server',
    'ip-update.updatingDnsZones' => 'Updating IP address: updating DNS zones',
    'ip-update.restartingDnsService' => 'Updating IP address: restarting DNS server',

    'ip-reload-public.queue' => 'Updating public IP addresses using cloud metadata',
    'ip-reload-public.done' => 'Public IP addresses were updated',

    'logrotate_anonymize_ips.queue' => 'Anonymize IP addresses in logs',
    'logrotate_anonymize_ips.queueRevert' => 'De-anonymize IP addresses in logs',
    'logrotate_anonymize_ips.done' => 'IP addresses were anonymized.',
    'logrotate_anonymize_ips.doneRevert' => 'IP addresses were de-anonymized.',
    'logrotate_anonymize_ips.error' => 'IP addresses anonymizing finished with errors',
    'logrotate_anonymize_ips.errorRevert' => 'IP addresses de-anonymizing finished with errors',

    'panel-components-install.queue' => 'Installing the selected components',
    'panel-components-install.done' => 'The selected components were successfully installed.',
    'panel-components-install.error' => 'Unable to install the components. The notification with the error description was sent to your email.',

    'panel-update.queue' => 'Plesk is installing updates. This may take some time. %%warning%%',
    'panel-update.warning' => 'Please do not perform any management operations in Plesk until the update is complete.',
    'panel-update.done' => 'Plesk was updated. See more information in the %%changelog%%.',
    'panel-update.changelog' => 'Plesk changelog',
    'panel-update.error' => 'Failed to update Plesk. %%errorDetails%%',
    'panel-update.support' => 'To solve this problem, you can send the update log to Plesk support. %%failedLog%% Copy the log to your computer before you close this message.',
    'panel-update.failedLog' => 'View the update log from %%date%%.',

    'pum-update-packages.queue' => 'Updating %%count%% package(s)...',
    'pum-update-packages.done' => '%%count%% packages were updated successfully.',
    'pum-update-packages.error' => 'Update failed.',

    'scheduler-run-task.queue' => 'Running task "%%task%%"...',
    'scheduler-run-task.done' => 'Task "%%task%%" successfully completed in %%seconds%% seconds.',
    'scheduler-run-task.error' => 'Task "%%task%%" completed with error in %%seconds%% seconds.',
    'scheduler-run-task.popupSeeDetails' => 'See details',
    'scheduler-run-task.popupTitle' => 'Run scheduled task',
    'scheduler-run-task.popupDone' => 'Task "%%task%%" successfully completed in %%seconds%% seconds, output:',
    'scheduler-run-task.popupError' => 'Task "%%task%%" completed with error in %%seconds%% seconds, output:',
    'scheduler-run-task.popupClose' => 'Close',

    'sdk.queue' => 'The task "%%name%%" is in progress...',
    'sdk.error' => 'The task "%%name%%" has failed.',
    'sdk.done' => 'The task "%%name%%" has finished.',
    'sdk.canceled' => 'The task "%%name%%" has been canceled.',

    'sync-php-settings.queue' => 'Applying global PHP %%version%% settings to domains',
    'sync-php-settings.done' => 'Global PHP %%version%% settings were successfully applied to domains',
    'sync-php-settings.error' => 'Error occurred while applying global PHP %%version%% setting to domains',

    'sync-service-plan.queue' => 'Syncing service plan %%name%% with subscriptions',
    'sync-service-plan.done' => 'Service plan %%name%% was successfully synced with subscriptions',
    'sync-service-plan.doneWithErrors' => 'The sync of service plan %%name%% was completed. Some subscriptions were not synced with the plan',
    'sync-service-plan.error' => 'Error occurred while syncing of service plan %%name%% with subscriptions',

    'domain-create.queue' => 'Creating domain %%domainName%%',
    'domain-create.done' => 'Domain %%domainName%% created',
    'domain-create.error' => 'Domain %%domainName%% creation failed',
    'domain-create.warning' => 'Domain %%domainName%% created with few problems:<br> %%problems%%',
    'domain-create.refreshUrl' => 'View',
    'domain-create.steps.createCustomer' => 'Creating customer',
    'domain-create.steps.createSubscription' => 'Creating a subscription',
    'domain-create.steps.createDomain' => 'Adding a domain',
    'domain-create.steps.configureDns' => 'Configuring the DNS zone',
    'domain-create.steps.createHosting' => 'Creating physical hosting',
    'domain-create.steps.configurePhp' => 'Configuring PHP',
    'domain-create.steps.configureMail' => 'Configuring mail',

    'domain-delete.queue' => 'Deletion of domains processing',
    'domain-delete.done' => 'Domains deleted',
    'domain-delete.error' => 'Domains deletion failed',
    'domain-delete.step.domains' => 'Deleting domains…',

    'domain-resolve-checking.warning' => 'Domain %%domainName%% resolve problems detected: <br> %%errors%%',

    'customer-create.queue' => 'Creation of customer %%customerName%% processing',
    'customer-create.done' => 'Customer %%customerName%% created',
    'customer-create.error' => 'Customer %%customerName%% creation failed',
    'customer-create.warning' => 'Customer %%customerName%% created with few problems:<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'You can try to synchronize it manually.',

    'customer-delete.queue' => 'Deletion of customers processing',
    'customer-delete.done' => 'Customers deleted',
    'customer-delete.error' => 'Customers deletion failed',

    'reseller-delete.queue' => 'Deletion of resellers processing',
    'reseller-delete.done' => 'Resellers deleted',
    'reseller-delete.error' => 'Resellers deletion failed',

    'subscription-create.queue' => 'Creation of subscription %%subscriptionName%% processing',
    'subscription-create.done' => 'Subscription %%subscriptionName%% created',
    'subscription-create.error' => 'Subscription %%subscriptionName%% creation failed',
    'subscription-create.warning' => 'Subscription %%subscriptionName%% created with few problems:<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'You can try to synchronize it manually.',

    'subscription-delete.queue' => 'Deletion of subscriptions processing',
    'subscription-delete.done' => 'Subscriptions deleted',
    'subscription-delete.error' => 'Subscriptions deletion failed',

    'websites-diagnostic.queue' => 'Running websites diagnostic',
    'websites-diagnostic.done' => 'Websites diagnostic is completed',
    'websites-diagnostic.error' => 'Websites diagnostic is completed with errors',

    'install-php-extension.queue' => 'Installing the %%extensionName%% package on the %%phpHandlerName%% PHP handler',
    'install-php-extension.done' => 'The %%extensionName%% package was installed on the %%phpHandlerName%% PHP handler',
    'install-php-extension.error' => 'Failed to install the %%extensionName%% package on the %%phpHandlerName%% PHP handler',
    'install-php-extension.step.validate' => 'Checking requirements',
    'install-php-extension.step.dependencies' => 'Resolving dependencies',
    'install-php-extension.step.process' => 'Installing package',
    'install-php-extension.step.enable' => 'Enabling extension',
    'install-php-extension.step.sync' => 'Synchronizing sites',
    'install-php-extension.errorReason' => 'The list of available packages is provided by PECL. The most common reasons for the failed installation are the following:',
    'install-php-extension.errorReasonDependencies' => '- The package has external dependencies on additional libraries.',
    'install-php-extension.errorReasonRequirements' => '- The package does not meet the installation requirements (OS, PHP version, and so on).',
    'install-php-extension.errorReasonOutdated' => '- The package is outdated.',
    'install-php-extension.errorOutput' => 'To identify the reason for the failed installation, examine the utility output.',

    'uninstall-php-extension.queue' => 'Uninstalling the %%extensionName%% package from the %%phpHandlerName%% PHP handler',
    'uninstall-php-extension.done' => 'The %%extensionName%% package was uninstalled from the %%phpHandlerName%% PHP handler',
    'uninstall-php-extension.error' => 'Failed to uninstall the %%extensionName%% package from the %%phpHandlerName%% PHP handler',
    'uninstall-php-extension.step.validate' => 'Checking requirements',
    'uninstall-php-extension.step.process' => 'Uninstalling package',
    'uninstall-php-extension.step.sync' => 'Synchronizing websites',

    'upgrade-database-server.queue' => 'Upgrading the database server',
    'upgrade-database-server.error' => 'Failed to upgrade the database server',
    'upgrade-database-server.done' => 'The database server was upgraded',
    'upgrade-database-server.step.validate' => 'Checking the system',
    'upgrade-database-server.step.dump' => 'Creating a databases\' dump',
    'upgrade-database-server.step.disableService' => 'Disabling the old system service',
    'upgrade-database-server.step.configureRepo' => 'Configuring a new repository',
    'upgrade-database-server.step.upgradePackages' => 'Upgrading the database server',
    'upgrade-database-server.step.updateConfiguration' => 'Updating the server configuration',
    'upgrade-database-server.step.startService' => 'Starting the new system service',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Upgrading the structure of all tables',
    'upgrade-database-server.step.sync' => 'Syncing system components',
    'upgrade-database-server.step.validateInstallation' => 'Validating installation',

    'update-spam-filter-individual-settings.queue' => 'Updating spam filter settings',
    'update-spam-filter-individual-settings.done' => 'Spam filter settings were updated',
    'update-spam-filter-individual-settings.error' => 'Failed to update spam filter settings',
    'update-spam-filter-individual-settings.mailNameError' => 'Email address %%name%%: %%error%%',

    'update-default-cert.queue' => 'Updating the default certificate',
    'update-default-cert.done' => 'The default certificate was updated.',
    'update-default-cert.error' => 'Updating the default certificate finished with errors.',
    'update-default-cert.step.updating' => 'Updating the default certificate…',

    'smarthost-attach-server-domains.queue' => 'Attaching domains to the smarthost',
    'smarthost-attach-server-domains.done' => 'Domains were attached to the smarthost',
    'smarthost-attach-server-domains.doneWithErrors' => 'Attaching domains to the smarthost finished with errors',
    'smarthost-attach-server-domains.error' => 'Unable to attach domains to the smarthost',
];
