<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Sous-réseau ou adresse IP',
    'access-network.subnetOrIpAddressHint' => 'Par exemple : 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Newsletters',
    'admin.announcement-settings.getConsentLoading' => 'Récupération des informations sur les newsletters...',
    'admin.announcement-settings.getConsentWarning' => 'Impossible de récupérer le statut de votre abonnement.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Je souhaite recevoir les newsletters de WebPros. Celles-ci peuvent contenir des informations liées à la sécurité, des informations techniques ou encore des informations générales sur le produit. Je consens et j\'autorise WebPros à recueillir, traiter et utiliser mes données personnelles (e-mail), traitement transfrontalier inclus, conformément aux lois applicables sur la protection des données actuellement en vigueur pour m\'envoyer des newslettters, soit directement, soit via un service tiers. En décochant cette case, je révoque mon consentement et j\'ordonne à WebPros de cesser de m\'envoyer des e-mails et de supprimer définitivement mes données personnelles de ses systèmes.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Les entreprises WebPros mentionnées ici peuvent utiliser mon nom et mon adresse e-mail (%%adminEmail%%) afin de m\'envoyer du contenu marketing personnalisé comme des newsletters et des offres ciblées liées aux produits WebPros. Les entreprises qui demandent le consentement sont : WebPros International LLC et WebPros International GmbH. Les informations seront utilisées conformément à la %%privacyPolicy%% jusqu\'à ce que je retire mon consentement et peuvent être partagées en interne avec d\'autres entités du groupe WebPros. Je peux modifier ou retirer mon consentement à tout moment en cliquant sur le lien disponible dans toutes les communications reçues ou en envoyant un e-mail à l\'adresse suivante : privacy@plesk.com.',
    'admin.announcement-settings.privacyPolicy' => 'Politique de confidentialité de WebPros',
    'admin.announcement-settings.noConsent' => 'Me désabonner de la newsletter de WebPros.',
    'admin.announcement-settings.reportConsentError' => 'Impossible d\'enregistrer vos paramètres pour la réception d\'informations provenant de Plesk : %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Désolé, nous ne pouvons pas mettre à jour votre profil pour le moment. Veuillez réessayer plus tard.',
    'admin.announcement-settings.invalidConsentType' => "Type de consentement inconnu : '%%type%%'",
    'admin.announcement-settings.retry' => 'Réessayer',
    'admin.announcement-settings.consentGivenInfo' => 'Nous espérons que vous avez apprécié la newsletter générique de WebPros. Nous pouvons désormais vous proposer une meilleure alternative ! Notre newsletter personnalisée, composée d\'informations utiles et d\'astuces pratiques qui correspondent à vos besoins. Pour recevoir votre newsletter WebPros personnalisée, choisissez la première proposition ci-dessous et cliquez sur OK.',

    'admin.personal-info.title' => 'Édition du profil d\'administrateur',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Paramètres de Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Paramètres',

    'admin-alias.login' => 'Nom d\'utilisateur',
    'admin-alias.password' => 'Mot de passe',
    'admin-alias.passwordConfirmation' => 'Confirmer le mot de passe',
    'admin-alias.email' => 'Adresse mail',
    'admin-alias.contact' => 'Nom du contact',
    'admin-alias.comments' => 'Commentaires',
    'admin-alias.emptyLogin' => 'Veuillez indiquer un nom d\'utilisateur.',
    'admin-alias.loginTooLong' => 'La longueur du nom d\'utilisateur dépasse les 20 caractères.',
    'admin-alias.emptyEmail' => 'Veuillez indiquer une adresse mail.',
    'admin-alias.emptyContactName' => 'Veuillez indiquer un nom de contact.',
    'admin-alias.contactNameTooLong' => 'La longueur du nom du contact dépasse les 255 symboles.',
    'admin-alias.emptyPassword' => 'Veuillez indiquer un mot de passe.',
    'admin-alias.commentsTooLong' => 'La longueur du commentaire dépasse les 255 symboles.',
    'admin-alias.emailActivation' => 'Activer le compte par mail',
    'admin-alias.simplePanel' => 'Activer le mode Restreint',
    'admin-alias.simplePanelHint' => 'Cochez cette option pour limiter les actions autorisées à l\'administrateur supplémentaire dans Plesk. Pour modifier les actions disponibles, allez ici %%link%%.',
    'admin-alias.simplePanelLink' => 'Outils & Paramètres > Paramètres du mode Restreint',
    'admin-alias.lockPowerUser' => 'Forcer la Vue Power User pour un administrateur supplémentaire',
    'admin-alias.lockPowerUserHint' => 'Possibilité de limiter la Vue pour un administrateur Plesk supplémentaire (sans accès aux clients, revendeurs et packs de services).',

    'admin-info.plesk-settings.multiplyLogin' => 'Autoriser plusieurs sessions sous ce compte',
    'admin-info.plesk-settings.adminLanguage' => 'Langue de l\'interface de l\'administrateur',
    'admin-info.plesk-settings.password' => 'Mot de passe',
    'admin-info.plesk-settings.passwordConfirmation' => 'Confirmer le mot de passe',
    'admin-info.plesk-settings.oldPassword' => 'Ancien mot de passe',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => 'L\'ancien mot de passe est incorrect. Veuillez réessayer.',

    'admin-panel.form.contact-info.login' => 'Nom d\'utilisateur',
    'admin-panel.form.contact-info.contactName' => 'Nom du contact',
    'admin-panel.form.contact-info.emptyLogin' => 'Veuillez indiquer un identifiant de connexion.',
    'admin-panel.form.contact-info.emptyContactName' => 'Veuillez indiquer un nom de contact.',
    'admin-panel.form.contact-info.loginTooLong' => 'L\'identifiant de connexion est trop long (%max% caractères maximum sont autorisés).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Le nom du contact est trop long (maximum %max% symboles sont autorisés).',
    'admin-panel.form.contact-info.email' => 'Adresse mail',
    'admin-panel.form.contact-info.emptyEmail' => 'Veuillez indiquer une adresse mail.',
    'admin-panel.form.contact-info.companyName' => 'Raison sociale',
    'admin-panel.form.contact-info.longCompanyName' => 'La raison sociale est trop longue (maximum %max% symboles sont autorisés).',
    'admin-panel.form.contact-info.phone' => 'Numéro de téléphone',
    'admin-panel.form.contact-info.longPhone' => 'Ce numéro de téléphone est trop long (maximum %max% symboles sont autorisés).',
    'admin-panel.form.contact-info.fax' => 'Numéro de fax',
    'admin-panel.form.contact-info.imNumber' => 'Messagerie instantanée',
    'admin-panel.form.contact-info.longFax' => 'Ce numéro de fax est trop long (maximum %max% symboles sont autorisés).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Le numéro de téléphone précisé n\'est pas valide.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Le numéro de fax est incorrect.',
    'admin-panel.form.contact-info.address' => 'Adresse',
    'admin-panel.form.contact-info.longAddress' => 'L\'adresse est trop longue (maximum %max% symboles sont autorisés).',
    'admin-panel.form.contact-info.city' => 'Ville',
    'admin-panel.form.contact-info.longCity' => 'Ce nom de ville est trop long.',
    'admin-panel.form.contact-info.shortCity' => 'Ce nom de ville est trop court.',
    'admin-panel.form.contact-info.state' => 'Région/Département',
    'admin-panel.form.contact-info.postalCode' => 'Code postal/CP',
    'admin-panel.form.contact-info.country' => 'Pays',
    'admin-panel.form.contact-info.additionalInfo' => 'Informations supplémentaires',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Texte brut uniquement : toutes les balises HTML seront ignorées.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Un utilisateur avec cette adresse mail existe déjà dans le système.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abonnement',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Les propriétés du site Web sont provisionnées avec l\'abonnement.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Les propriétés du site Web sont provisionnées avec l\'abonnement.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Les propriétés du site Web sont provisionnées avec l\'abonnement.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Créer un abonnement pour le client',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Décochez cette case si vous ne voulez pas créer d\'abonnement au service d\'hébergement ou configurer de site Web pour le client pour le moment. Sans abonnement, le client ne pourra pas se connecter au Panneau Client.',
    'admin-panel.form.domain-info-section.domainName' => 'Nom de domaine',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Indiquez un nom de domaine.',
    'admin-panel.form.domain-info-section.shared' => 'partagé',
    'admin-panel.form.domain-info-section.exclusive' => 'dédiée',
    'admin-panel.form.domain-info-section.userName' => 'Nom d\'utilisateur',
    'admin-panel.form.domain-info-section.userNameHint' => 'Le compte utilisateur système est utilisé pour gérer les fichiers et dossiers des sites Web créés dans l\'abonnement.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Indiquez un nom d\'utilisateur.',
    'admin-panel.form.domain-info-section.password' => 'Mot de passe',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Indiquez un mot de passe.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Confirmer le mot de passe',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "L'adresse IP sur laquelle le site web est hébergé est une adresse réseau de l'hôte virtuel du site web.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'Adresse IPv4',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "L'adresse IP sur laquelle le site web est hébergé est une adresse réseau de l'hôte virtuel du site web.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'Adresse IPv6',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Aucun(e)',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Paramètres supplémentaires de l\'abonnement ',
    'admin-panel.form.domain-info-section.credentials' => 'Identifiants d\'accès de l\'utilisateur système',
    'admin-panel.form.domain-info-section.credentialsHint' => 'Permet l\'accès aux fichiers hébergés via FTP et SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'pour accéder aux fichiers hébergés via FTP et RDP',

    'admin-panel.form.login-info.userName' => 'Nom d\'utilisateur',
    'admin-panel.form.login-info.emptyUserName' => 'Veuillez indiquer un nom d\'utilisateur.',
    'admin-panel.form.login-info.password' => 'Mot de passe',
    'admin-panel.form.login-info.emptyPassword' => 'Veuillez indiquer un mot de passe.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Confirmer le mot de passe',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'La modification du mot de passe entraîne la modification du mot de passe de l\'adresse e-mail interne.',
    'admin-panel.form.login-info.emailActivation' => 'Activer le compte par mail',
    'admin-panel.form.login-info.emailActivationHint' => 'Lorsqu\'un compte est créé, celui-ci est inactif jusqu\'à ce que l\'utilisateur l\'active à l\'aide du lien envoyé par mail ou jusqu\'à ce que l\'administrateur l\'active manuellement.',

    'admin-panel.form.subscription-info-section.subscription' => 'Abonnement',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Pack de services',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Actuel pack de services',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Nouveau pack de services',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Pack simple',
    'admin-panel.form.subscription-info-section.none' => 'Aucun(e)',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Add-ons',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Personnaliser les paramètres de l\'abonnement une fois l\'association du pack changée. Notez que cette procédure verrouillera l\'abonnement pour la synchronisation.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Poursuivez afin de personnaliser les paramètres de l\'abonnement une fois qu\'il est créé.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Commencez à personnaliser les paramètres de l'abonnement une fois le client créé.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Procédez à la personnalisation des paramètres de l\'abonnement une fois créé. Notez que cette procédure verrouillera l\'abonnement pour la synchronisation.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Notez que cette procédure verrouillera l\'abonnement pour la synchronisation.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Ajouter un abonnement',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Impossible de synchroniser l\'abonnement avec le pack de services. Les paramètres suivants de l\'abonnement sont en conflit avec le pack de services : %%problems%%.',

    'app.configure.otherSettings' => 'Autres',
    'app.configure.passwordConfirmation' => 'Confirmer le mot de passe',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Forcer les mises à jour pour toutes les applications installées',
    'app.update-settings.forceUpdatesHint' => 'Toutes les applications du client seront mises à jour automatiquement dès que les mises à jour seront disponibles. Les clients ne pourront pas désactiver les mises à jour automatiques pour leurs applications. Avertissement : attention, cette option doit être utilisée avec précaution, car elle peut affecter significativement le fonctionnement de l\'application. Par exemple, les extensions de l\'application peuvent cesser de fonctionner avec une autre version de l\'application.',
    'app.update-settings.suggestUpdates' => 'Activer par défaut l\'option "Mettre à jour automatiquement cette application"',
    'app.update-settings.suggestUpdatesHint' => 'Pour les applications installées récemment, l\'option "Mettre à jour automatiquement cette application" dans les paramètres de l\'application est déjà activée.',

    'backup.server-settings.rotation' => 'Nombre maximum de fichiers de sauvegardes intégrales à stocker (y compris les sauvegardes planifiées et manuelles)',
    'backup.server-settings.rotationDescription' => 'Les utilisateurs peuvent stocker ce nombre de sauvegardes dans le stockage du serveur. Si le nombre de sauvegardes intégrales dans le stockage dépasse la limite, seules les sauvegardes les plus récentes sont conservées. Les sauvegardes incrémentales ne sont pas affectées.',
    'backup.server-settings.maxProcesses' => 'Nombre maximum de sauvegardes planifiées, à exécuter simultanément',
    'backup.server-settings.niceScheduled' => 'Exécuter les sauvegardes planifiées avec une priorité faible',
    'backup.server-settings.niceScheduledPriority' => 'Priorité',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Saisissez une valeur comprise entre 1 et 19 (inclus). Le chiffre le plus élevé correspond à la priorité la plus basse.',
    'backup.server-settings.niceScheduledIoPriority' => 'Priorité E/S',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Saisissez une valeur comprise entre 0 et 7 (inclus). Le chiffre le plus élevé correspond à la priorité la plus basse.',
    'backup.server-settings.niceAlways' => 'Exécuter tous les processus de sauvegarde avec une priorité faible',
    'backup.server-settings.niceAlwaysPriority' => 'Priorité',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Saisissez une valeur comprise entre 1 et 19 (inclus). Le chiffre le plus élevé correspond à la priorité la plus basse.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Priorité E/S',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Saisissez une valeur comprise entre 0 et 7 (inclus). Le chiffre le plus élevé correspond à la priorité la plus basse.',
    'backup.server-settings.compressionLevel' => 'Niveau de compression',
    'backup.server-settings.compressionLevelNoCompression' => 'Aucune compression',
    'backup.server-settings.compressionLevelFastest' => 'Le plus rapide',
    'backup.server-settings.compressionLevelFast' => 'Rapide',
    'backup.server-settings.compressionLevelNormal' => 'Normal(e)',
    'backup.server-settings.compressionLevelMaximum' => 'Maximum',
    'backup.server-settings.freeSpaceRequired' => 'Lancer la sauvegarde uniquement si le serveur dispose du volume d\'espace disque libre spécifié (en mégaoctets)',
    'backup.server-settings.checkBackupDiskSpace' => 'Lancer la sauvegarde uniquement si le serveur dispose du volume d\'espace disque libre suffisant',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Utiliser la fonction de sauvegarde native de MS SQL (pour les bases de données distantes, vous devez d\'abord configurer le serveur de sauvegardes sur le serveur MS SQL distant sur la page Outils & Paramètres  >  Serveur de base de données, si vous ne l\'avez pas encore fait)',
    'backup.server-settings.localFtpRestriction' => 'Autoriser le stockage de sauvegardes FTP sur le serveur local',
    'backup.server-settings.backupSecuritySettings' => 'Paramètres de sécurité des sauvegardes',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Enregistrer les sauvegardes dans le stockage serveur si l\'envoi vers le stockage distant échoue',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Les sauvegardes manuelles et planifiées destinées au stockage distant seront sauvegardées dans le stockage du serveur local si l\'envoi vers le stockage distant échoue. Les utilisateurs doivent avoir le droit de stocker des sauvegardes dans le stockage du serveur.',
    'backup.server-settings.AllowScheduleHourly' => 'Autoriser les clients et les revendeurs à planifier des sauvegardes plusieurs fois par jour',

    'change-current-subscription.hint' => 'Sur cette page, vous pouvez changer l\'association avec les packs de services pour l\'abonnement. Notez que sélectionner \'aucun\' en tant que nouveau pack de services dissocie l\'abonnement du pack de services et le transforme en \'Personnalisé\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Impossible de synchroniser l\'abonnement avec le pack de services. Les paramètres suivants de l\'abonnement sont en conflit avec le pack de services : %%problems%%.',

    'change-password.oldPassword' => 'Ancien mot de passe',
    'change-password.password' => 'Nouveau mot de passe',
    'change-password.passwordConfirmation' => 'Confirmer le mot de passe',
    'change-password.oldPasswordIsIncorrect' => 'L\'ancien mot de passe est incorrect. Veuillez réessayer.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Impossible de trouver le compte administrateur supplémentaire.',
    'change-password.warningAboutAdminPasswordSyntax' => "Le mot de passe doit contenir entre %%min%% et %%max%% caractères et ne doit pas contenir de nom d'utilisateur.\nN'utilisez ni guillemets, ni espaces, ni caractères alphabétiques spéciaux dans le mot de passe.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "N'utilisez ni guillemets, ni espaces, ni point virgule, ni caractères alphabétiques spéciaux dans le mot de passe.\nLe mot de passe doit contenir entre %%min%% et %%max%% caractères et ne doit pas contenir de nom d'utilisateur.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Politique de survente',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'La survente est autorisée',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'La survente permet à un revendeur de vendre plus de ressources que celles qui lui sont actuellement allouées avec un pack. Si la survente est autorisée, un revendeur est soumis à l\'utilisation réelle des ressources au lieu de l\'affectation initiale des ressources',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'La survente n\'est pas autorisée',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Si la survente n\'est pas autorisée, un revendeur ne peut vendre que le nombre de ressources qui lui ont été allouées au début avec un pack, et ce sans tenir compte du nombre de ces ressources actuellement utilisées.',

    'change-reseller-subscription.hint' => 'Sur cette page, vous pouvez changer l\'association avec le pack de services pour l\'abonnement du revendeur. Notez que sélectionner \'aucun\' en tant que nouveau pack de services dissocie l\'abonnement des packs de services et le transforme en \'Personnalisé\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Impossible de synchroniser l\'abonnement avec le pack de services. Les paramètres suivants de l\'abonnement sont en conflit avec le pack de services : %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Nouveau pack',
    'change-reseller-subscription.oldSubscription' => 'Pack actuel',
    'change-reseller-subscription.none' => 'Aucun(e)',
    'change-reseller-subscription.infoSubscriptionChanged' => 'L\'association de l\'abonnement avec le pack de service a été mise à jour.',
    'change-reseller-subscription.customizeSubscription' => 'Procédez à la personnalisation des paramètres de l\'abonnement une fois que son association avec le pack de service est mise à jour. Notez que cette procédure verrouillera l\'abonnement pour la synchronisation.',

    'change-subscription.hint' => 'Sur cette page, vous pouvez changer l\'association avec les packs de services pour les abonnements sélectionnés.',
    'change-subscription.selectPlanLegend' => 'Pack de services',
    'change-subscription.selectPlanDescription' => 'Pour switcher vers un autre pack de services, choisissez le nouveau pack à partir de la liste. Notez que sélectionner \'aucun\' dissocie les abonnements du pack de services et les transforme en \'Personnalisé\'.',
    'change-subscription.servicePlan' => 'Nouveau pack de services',
    'change-subscription.selectAddonPlansLegend' => 'Packs d\'add-ons',
    'change-subscription.selectAddonPlansDescription' => 'Ajoutez ou supprimez des packs d\'add-ons.',
    'change-subscription.noChange' => 'Aucun changement',
    'change-subscription.none' => 'Aucun(e)',
    'change-subscription.add' => 'Ajouter',
    'change-subscription.del' => 'Supprimer',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Sous-réseau ou adresse IP',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Par exemple : 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Accès à Plesk avec les privilèges d\'administrateur',
    'control-panel-access.settings.policyAllow' => 'Autorisé, sauf pour les réseaux figurant dans la liste.',
    'control-panel-access.settings.policyDeny' => 'Interdit aux réseaux qui ne sont pas dans la liste.',

    'create-subscription.title' => 'Ajout d\'un abonnement',
    'create-subscription.titleOwn' => 'Ajout de votre propre abonnement',
    'create-subscription.poolIsEmpty' => 'Impossible de créer un abonnement : aucune adresse IP partagée et aucune adresse IP dédiée libre dans Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'L\'abonnement %%name%% a été créé.',
    'create-subscription.createBeforeAppInstall' => 'Vous devez avoir un abonnement pour installer l\'application.',

    'customer.hint' => 'Sur cette page, vous pouvez inscrire un nouveau client à vos services d\'hébergement. En l\'inscrivant, vous créez un compte client dans Plesk et un abonnement à l\'un de vos packs d\'hébergement plus, en option, des add-ons. L\'abonnement peut également offrir un jeu complètement personnalisé de ressources et de services, non associé à un pack. Pour ce faire, sélectionnez \'Aucun\' à côté du Pack de services.',
    'customer.contactInfoSection' => 'Informations sur le contact',
    'customer.additionalInfoSection' => 'Autres informations client',
    'customer.accessToPanelSection' => 'Accès à Plesk',
    'customer.contactInfoSectionHint' => 'Saisissez les informations de contact d\'un client.',
    'customer.accessToPanelSectionHint' => 'Identifiants que le client utilisera pour accéder à son Panneau Client.',
    'customer.unableCreateSubscription' => 'Impossible de créer l\'abonnement : %%reason%%',
    'customer.poolIsEmpty' => 'Le Pool d\'IP est vide',
    'customer.buttonOk' => 'Ajouter un client',

    'database-settings.dbPrefixRadio' => 'Ajouter un préfixe et un tiret bas avant le nom de la base de données',
    'database-settings.dbPrefixNone' => 'Aucun(e)',
    'database-settings.dbPrefixUsername' => 'Nom d\'utilisateur',
    'database-settings.dbPrefixExternalId' => 'ID externe d\'un abonnement',
    'database-settings.dbPrefixCustom' => 'Préfixe personnalisé',
    'database-settings.dbUserPrefixRadio' => 'Ajouter un préfixe et un tiret bas avant le nom d\'utilisateur de la base de données',
    'database-settings.dbUserPrefixHint' => 'Les noms d\'utilisateurs de la base de données auront le format suivant : <prefix>_<database_user_name>. En raison des restrictions liées à la longueur du nom d\'utilisateur, vous devrez peut-être raccourcir <prefix>.',
    'database-settings.grantAlterDatabase' => 'Accorder le droit ALTER DATABASE à tous les utilisateurs de la base de données Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Ce droit sera accordé aux utilisateurs existants et aux nouveaux utilisateurs.',
    'database-settings.aclRadio' => 'Paramètres par défaut pour l\'accès à distance des utilisateurs de la base de données MariaDB/MySQL',
    'database-settings.aclLocalhost' => 'Autoriser uniquement les connexions locales',
    'database-settings.aclAny' => 'Autoriser les connexions à distance depuis n\'importe quel hôte',
    'database-settings.aclCustom' => 'Autoriser les connexions à distance depuis',
    'database-settings.aclDescription' => 'Ce paramètre modifie uniquement les droits de l\'utilisateur. Pour activer l\'accès à distance du serveur MariaDB/MySQL local, sélectionnez l\'option correspondante dans %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Paramètres MariaDB/MySQL local',
    'database-settings.example' => "Par exemple :",
    'database-settings.aclExampleDescription' => "Les hôtes indiqués sont autorisés à accéder à la base de données au nom de cet utilisateur.",
    'database-settings.dbPrefixAlphaNumeric' => 'La valeur du préfixe peut contenir uniquement des caractères alphanumériques et un tiret bas.',

    'dns.add-acl-record.description' => 'Ajoutez une adresse IP d\'un serveur DNS autorisé à recevoir une copie de la zone DNS.',
    'dns.add-acl-record.ipAddress' => 'Adresse IP',
    'dns.add-acl-record.ipAddressWithMask' => 'Adresse IP/masque',

    'dns.settings.recursion' => 'Requêtes DNS récursives',
    'dns.settings.recursionOn' => 'Autoriser pour toutes les requêtes',
    'dns.settings.recursionLocal' => 'Autoriser pour les requêtes locales uniquement',
    'dns.settings.recursionLocalnets' => 'Autoriser les requêtes depuis le ou les réseaux locaux uniquement',
    'dns.settings.recursionOff' => 'Refuser toutes les requêtes',
    'dns.settings.customConfiguration' => 'Autres paramètres DNS',
    'dns.settings.customConfigurationPlaceholder' => 'Les paramètres que vous avez spécifiés ici écraseront les paramètres appliqués à l\'ensemble du serveur.',
    'dns.settings.customConfigurationHint' => 'Si vous ne trouvez pas certains paramètres spécifiques, ajoutez-les au champ ci-dessus en suivant la syntaxe named.conf.',
    'dns.settings.customConfigurationExample' => 'Par exemple, pour masquer le nom d\'hôte sur le service DNS, ajoutez la ligne suivante :',
    'dns.settings.restoreDefaultButton' => 'Utiliser les paramètres par défaut',

    'dns.template.synchronize-done' => 'Le template de la zone DNS zone a bien été appliqué.',
    'dns.template.synchronize-error' => 'Le template de la zone DNS zone n\'a pas été appliqué à certaines zones DNS.',
    'dns.template.synchronize-progress' => 'Application du template de la zone DNS.',

    'domain-restriction.name' => 'Nom de domaine',
    'domain-restriction.nameDescription' => 'Vous pouvez préciser un modèle de caractères génériques à l\'aide de l\'astérisque (*). Par exemple : *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Le nom de domaine indiqué est déjà dans la liste.',

    'event-handler.eventLabel' => 'Événement',
    'event-handler.priorityLabel' => 'Priorité',
    'event-handler.userLabel' => 'Utilisateur',
    'event-handler.commandLabel' => 'Commande',
    'event-handler.commandHint' => 'Pour obtenir de meilleurs résultats, saisissez le chemin complet vers un fichier de script dans le champ \'command\'. Nous vous recommandons de ne pas saisir de commandes système, car elles risquent de ne pas fonctionner. Par exemple, des commandes avec des opérateurs de redirection de sortie > ou < ne fonctionneront pas.',
    'event-handler.priorityHighestText' => 'la plus élevée',
    'event-handler.priorityHighText' => 'élevée',
    'event-handler.priorityNormalText' => 'normale',
    'event-handler.priorityLowText' => 'basse',
    'event-handler.priorityLowestText' => 'la plus basse',
    'event-handler.priorityCustomText' => 'personnalisé(e)',
    'event-handler.priorityHighestOption' => 'la plus élevée (%%value%%)',
    'event-handler.priorityHighOption' => 'élevée (%%value%%)',
    'event-handler.priorityNormalOption' => 'normale (%%value%%)',
    'event-handler.priorityLowOption' => 'basse (%%value%%)',
    'event-handler.priorityLowestOption' => 'la plus basse (%%value%%)',

    'extension.upload.fileUpload' => 'Chemin d\'accès au fichier du pack de l\'extension',

    'external-webmail.hint' => 'Une fois que vous aurez enregistré une messagerie Web supplémentaire dans Plesk, vos clients pourront y accéder : elle apparaîtra comme option dans les propriétés \'Mail\' des packs d\'hébergement et des abonnements. Le nom de la messagerie Web s\'affichera dans la liste des options de la messagerie Web et l\'URL s\'ouvrira lorsque vous cliquerez sur l\'icône de la messagerie Web à côté d\'une boîte mail dans le Panneau Client.',
    'external-webmail.name' => 'Nom du service de la messagerie Web',
    'external-webmail.url' => 'URL du service de la messagerie Web',
    'external-webmail.enabled' => 'Disponible',

    'ftp-settings.generalSection' => 'Général',
    'ftp-settings.portRange' => 'Port ou plage du port pour les connexions en mode FTP passif',
    'ftp-settings.hintPortRange' => '(valeur par défaut : %%defaultPortRange%%)',

    'health.upload.hint' => 'Envoyez votre configuration du moniteur de serveur de santé. La configuration sera appliquée dès qu\'elle sera envoyée.',
    'health.upload.selectFile' => 'Fichier de configuration',

    'install-local-package.selectUploadType' => 'Choisissez l\'une des options suivantes :',
    'install-local-package.uploadAsFile' => 'Envoyer un pack APS',
    'install-local-package.downloadFromCatalog' => 'Sélectionner une application à partir du catalogue d\'applications',
    'install-local-package.formInfo' => "Étendez la liste des applications disponibles en ajoutant une nouvelle application ou ajoutez une application à partir du Catalogue d'applications et poursuivez sa configuration ultérieurement.",
    'install-local-package.invalidFileExtension' => 'L\'application envoyée doit être une archive ZIP avec l\'extension .zip.',
    'install-local-package.packagesNotSelected' => 'Aucun des packs n\'est sélectionné.',
    'install-local-package.visible' => 'Mettre à la disposition des clients',
    'install-local-package.isCommercial' => 'Cette application est payante et requiert l\'achat d\'une clé de licence.',
    'install-local-package.visibleDescription' => 'Mettez l\'application à disposition des clients pour l\'installation.',

    'ip-address.addTitle' => 'Ajouter une adresse IP',
    'ip-address.editTitle' => 'Adresse IP %%address%% sur l\'interface %%interface%%',
    'ip-address.generalSection' => 'Général',
    'ip-address.interface' => 'Interface',
    'ip-address.addressAndSubnetPrefixLength' => 'Adresse IP et masque sous-réseau',
    'ip-address.addressHintIPv4' => 'Par exemple : 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Par exemple : 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Adresse IP publique',
    'ip-address.hintPublicIp' => 'Vous pouvez utiliser une adresse IP publique si votre serveur Plesk est derrière un NAT.',
    'ip-address.distributionType' => 'L\'adresse IP est distribuée comme',
    'ip-address.distributionTypeShared' => 'Partagée',
    'ip-address.distributionTypeExclusive' => 'Dédiée',
    'ip-address.certificate' => 'Certificat SSL/TLS',
    'ip-address.defaultSite' => 'Site par défaut',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Le serveur FTP installé ne prend pas en charge FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Le serveur FTP installé ne prend pas en charge d\'adresse IPv6.',
    'ip-address.interfaceDHCPEnabled' => 'Impossible d\'ajouter l\'adresse IP. Cette interface réseau récupère automatiquement les adresses IP.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Remarque : L&apos;URL personnalisée de Plesk est activée pour tous les domaines inconnus ; l&apos;interface de Plesk sera affichée à la place du site par défaut sur "https://%%ip%%".',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'L\'adaptateur réseau %%interface%% n\'existe pas. Migrez cette adresse IP vers un autre adaptateur réseau ou supprimez-la de la liste.',
    'ip-address.none' => 'Aucun(e)',

    'ip-ban.filter.name' => 'Nom',
    'ip-ban.filter.content' => 'Contenu',
    'ip-ban.filter.filterExistsError' => 'Un filtre portant ce nom existe déjà.',

    'ip-ban.jail.name' => 'Nom',
    'ip-ban.jail.filter' => 'Filtre',
    'ip-ban.jail.filterDescription' => 'Sélectionnez le filtre.',
    'ip-ban.jail.action' => 'Action',
    'ip-ban.jail.actionDescription' => 'Sélectionnez une action et cliquez sur le bouton pour l\'ajouter.',
    'ip-ban.jail.logPath' => 'Chemin d\'accès du fichier journal',
    'ip-ban.jail.banTime' => 'Période de bannissement de l\'adresse IP',
    'ip-ban.jail.maxRetry' => 'Nombre maximum de tentatives de connexion échouées',
    'ip-ban.jail.timeUnit' => 'secondes',
    'ip-ban.jail.addAction' => 'Ajouter',
    'ip-ban.jail.chooseAction' => 'Sélectionnez',
    'ip-ban.jail.apache-auth-filter-description' => 'Échecs d\'autorisation Apache (avec connexion fichier)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Échecs d\'autorisation Apache (toute connexion)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Échecs d\'autorisation Apache (avec connexion syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Spambots et robots d\'indexation malveillants',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Échecs d\'authentification Courier IMAP et POP3',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Échecs d\'authentification Dovecot IMAP, POP3 et Sieve',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Échecs d\'authentification Dovecot IMAP, POP3 et Sieve (mode agressif)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Échecs d\'authentification de la messagerie Web Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Violations de contrôle d\'accès et sécurité niveau pare-feu applicatif (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Échecs d\'authentification Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'Échecs d\'authentification SMTP Qmail',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Échecs d\'authentification de la messagerie Web Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Échecs d\'authentification WordPress',
    'ip-ban.jail.plesk-manual-filter-description' => 'Filtre factice pour bannir manuellement',
    'ip-ban.jail.postfix-filter-description' => 'Erreurs client SMTP Postfix (y compris RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Erreurs client SMTP Postfix, échecs d\'authentification et attaques DDoS',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Échecs d\'authentification SASL et SMTP Postifx',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Attaques Postfix SMTP DDoS',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Erreurs client SMTP Postfix et échecs d\'authentification',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Erreurs client SMTP Postfix (y compris RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Erreurs client Postfix SMTP (RBL uniquement)',
    'ip-ban.jail.proftpd-filter-description' => 'Échecs de connexion ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'Hôtes bannis de façon répétée par Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'Échec de connexion SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Échecs de connexion SSH, échecs de négociation et attaques DDoS',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Échecs de connexion SSH et attaques DDoS',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Échecs de négociation et de connexion SSH',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Bannir via le pare-feu firewalld sur tous les ports',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Bannir via le pare-feu firewalld sur plusieurs ports',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Bannir via le pare-feu firewalld sur un port',
    'ip-ban.jail.iptables-action-description' => 'Bannir via le pare-feu avec iptables sur un port unique',
    'ip-ban.jail.iptables-allports-action-description' => 'Bannir via le pare-feu avec iptables sur tous les ports',
    'ip-ban.jail.iptables-multiport-action-description' => 'Bannir via le pare-feu avec iptables sur plusieurs ports',
    'ip-ban.jail.sendmail-action-description' => 'Envoyer une notification par e-mail via Sendmail',
    'ip-ban.jail.jailExistsError' => 'Une jail portant ce nom existe déjà.',
    'ip-ban.jail.invalidInteger' => 'La valeur indiquée est invalide. Indiquez un nombre entier.',

    'ip-ban.settings.pageHint' => 'Sur cette page, vous pouvez configurer le bannissement d\'adresses IP afin de protéger votre serveur et les sites Web hébergés du trafic malveillant.',
    'ip-ban.settings.detectionEnabled' => 'Activer la détection d\'intrusion',
    'ip-ban.settings.banPeriod' => 'Période de bannissement de l\'adresse IP',
    'ip-ban.settings.banTimeWindow' => 'Intervalle de détection des attaques ultérieures',
    'ip-ban.settings.maxRetries' => 'Nombre d\'échecs avant le bannissement de l\'adresse IP',
    'ip-ban.settings.timeUnit' => 'secondes',
    'ip-ban.settings.invalidInteger' => 'Une valeur non valide a été saisie. Indiquez un nombre entier positif.',

    'ip-ban.trusted-ip.ipAddress' => 'Adresse IP',
    'ip-ban.trusted-ip.hintIpAddress' => 'Une adresse IP, un masque CIDR ou un nom d\'hôte DNS.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Description',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Explication indiquant pourquoi l\'adresse IP a été ajoutée à la liste de confiance.',

    'login-info.hint' => 'Sur cette page, vous pouvez changer le nom d\'utilisateur et le mot de passe que le client utilise pour accéder à son Panneau Client.',
    'login-info.resellerHint' => 'Sur cette page, vous pouvez changer le nom d\'utilisateur et/ou le mot de passe que le revendeur utilise pour accéder à Plesk.',
    'login-info.myProfileHint' => 'Sur cette page, vous pouvez changer le mot de passe utilisé pour accéder à Plesk.',

    'firewall-rule.titleEdit' => 'Modification d\'une règle de pare-feu',
    'firewall-rule.titleNew' => 'Ajouter une règle',
    'firewall-rule.isEnabled' => 'Activer cette règle',
    'firewall-rule.name' => 'Nom de la règle',
    'firewall-rule.profiles' => 'Profils',
    'firewall-rule.profilesHint' => 'Vous devez sélectionner au moins un profil.',
    'firewall-rule.profileDomain' => 'Domaine',
    'firewall-rule.profilePrivate' => 'Privé',
    'firewall-rule.profilePublic' => 'Public',
    'firewall-rule.action' => 'Action',
    'firewall-rule.actionAllow' => 'Autoriser',
    'firewall-rule.actionBlock' => 'Refuser',
    'firewall-rule.port' => 'Autoriser les connexions à un port ou à une plage d\'un port',
    'firewall-rule.portHint' => 'Par exemple : 1000 ou 1000-1051',
    'firewall-rule.protocolTcp' => 'Protocole TCP',
    'firewall-rule.protocolUdp' => 'Protocole UDP',
    'firewall-rule.remoteAddresses' => 'Adresses IP distantes',
    'firewall-rule.remoteAddressesHint' => 'Par exemple : 192.168.0.1 ou 192.168.0.0/16',
    'firewall-rule.newRule' => 'Nouvelle règle',
    'firewall-rule.successNew' => 'La règle du pare-feu a été ajoutée.',
    'firewall-rule.successEdit' => 'La règle du pare-feu a été mise à jour.',

    'mail.lists-server-settings.email' => "Adresse mail de l'administrateur de la liste de diffusion",
    'mail.lists-server-settings.emptyEmail' => 'Veuillez indiquer une adresse mail.',
    'mail.lists-server-settings.newPassword' => 'Nouveau mot de passe',
    'mail.lists-server-settings.emptyPassword' => 'Veuillez indiquer un mot de passe.',
    'mail.lists-server-settings.passwordConfirmation' => 'Confirmer le mot de passe',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Le logiciel de liste de diffusion a été configuré.',

    'mail.outgoing-messages.hint' => 'Sur cette page, vous pouvez préciser la limite des messages sortants depuis une boîte mail.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Nombre maximum de mails sortants',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Par défaut (%%domainOutgoingMessages%% messages par heure)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Valeur personnalisée pour cette boîte mail',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'messages par heure',

    'mail-gate-settings.host' => 'Nom de l\'hôte ou adresse IP',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Nom d\'utilisateur',
    'mail-gate-settings.password' => 'Mot de passe',
    'mail-gate-settings.encryption' => 'Le serveur SMTP requiert une connexion chiffrée',
    'mail-gate-settings.allowUsers' => 'Autoriser le script de l\'utilisateur à envoyer des mails via ce serveur SMTP (à l\'aide des nom d\'utilisateur et mot de passe indiqués)',
    'mail-gate-settings.useDefaultSettings' => 'Utiliser le serveur de messagerie installé avec Plesk et le compte mail par défaut créés par Plesk',

    'mail-gate.hint' => 'Sur cette page, vous pouvez préciser le serveur SMTP à utiliser lorsque le serveur de messagerie Plesk n\'est pas installé ou n\'a pas le droit d\'envoyer de mails sortants. Ce serveur sera utilisé en tant que relais SMTP par Plesk et les scripts utilisateurs pour envoyer des mails sortants comme les notifications par mail.',
    'mail-gate.enableMailGate' => 'Autoriser Plesk à envoyer des notifications par mail via ce serveur SMTP',
    'mail-gate.notifications' => 'Notifications par mail par les serveurs SMTP externes',
    'mail-gate.smtpSettings' => 'Paramètres du serveur SMTP externe',

    'optimization-settings.apacheModulesSection' => 'Modules Apache',
    'optimization-settings.apacheSettingsSection' => 'Paramètres généraux',
    'optimization-settings.additionalPageHint' => 'Activez les modules uniquement si vous appréhendez complètement les conséquences de vos actions. Notez que certaines modifications risquent de réduire les performances Apache ou de mener à l\'arrêt de son fonctionnement.',
    'optimization-settings.pageHint' => 'Sur cette page, vous pouvez optimiser Plesk en désactivant les modules Apache inutilisés. Cette optimisation améliore l\'utilisation de la mémoire et vous permet de servir plus de clients d\'hébergement. Notez que certains modules dépendent les uns des autres et peuvent être désactivés ou activés uniquement si les modules dont ils dépendent sont désactivés ou activés.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Cette fonction est réservée aux utilisateurs avancés.',
    'optimization-settings.apacheRestartInterval' => 'Intervalle de redémarrage d\'Apache (en secondes)',
    'optimization-settings.apacheRestartIntervalHint' => 'Une fois dans l\'intervalle indiqué, Plesk vérifie les changements appliqués aux domaines et sous-domaines. Dans le cas de changements qui requièrent le redémarrage du serveur Web, Plesk redémarre Apache.',
    'optimization-settings.gracefulRestart' => 'Redémarrage graceful Apache',
    'optimization-settings.gracefulRestartHint' => 'Permet d\'éviter l\'indisponibilité de tous les sites Web hébergés sur le serveur à chaque fois que vous modifiez les paramètres d\'hébergement.',
    'optimization-settings.pipedLog' => 'Journaux redirigés',
    'optimization-settings.mpmMode' => 'Mode MPM',
    'optimization-settings.moduleDeprecated' => '(Dépréciée)',

    'personal-info.contactInfoSection' => 'Informations sur le contact',
    'personal-info.hint' => 'Sur cette page, vous pouvez éditer les informations de contact de l\'utilisateur.',
    'personal-info.hintMyProfile' => 'Sur cette page, vous pouvez éditer vos informations de contact.',

    'php-handler.extension.title' => 'Installer le package PECL',
    'php-handler.extension.description' => "Vous pouvez installer une version bêta d'une extension en spécifiant d'autres paramètres avec le nom du package, par exemple : \"msgpack-beta\".",
    'php-handler.extension.name' => 'Nom du package',

    'php-handler.ini.formHint' => 'Le fichier php.ini est utilisé uniquement par le gestionnaire.',
    'php-handler.ini.formHintSharedIni' => 'Le fichier php.ini est également utilisé par les gestionnaires PHP suivants : %%handlers%%. Les paramètres s\'appliquent à tous les sites Web qui utilisent ces gestionnaires.',
    'php-handler.ini.incorrectTextForIniFile' => "Les paramètres indiqués ne sont pas corrects et ne peuvent pas être enregistrés dans le fichier php.ini. Erreur : %%message%%.",

    'plan-item-custom.planItemName' => 'Nom du service',
    'plan-item-custom.buttonLabel' => 'Ce nom sera également utilisé comme intitulé du bouton personnalisé.',
    'plan-item-custom.planItemDescription' => 'Description du service',
    'plan-item-custom.buttonTooltip' => 'Ce texte sera également utilisé comme une infobulle du bouton personnalisé.',
    'plan-item-custom.url' => 'URL associée au bouton personnalisé',
    'plan-item-custom.backgroundImage' => 'Image d\'arrière-plan pour le bouton personnalisé',
    'plan-item-custom.emptyItemName' => 'Veuillez indiquer un intitulé pour ce service.',
    'plan-item-custom.emptyItemDescription' => 'Veuillez indiquer un texte pour cette infobulle du service.',
    'plan-item-custom.emptyUrl' => 'Veuillez indiquer une URL.',
    'plan-item-custom.longItemName' => 'L\'intitulé de ce service est trop long. La longueur maximum autorisée est de %max% caractères.',
    'plan-item-custom.longItemDescription' => 'Le texte de ce service est trop long. La longueur maximum autorisée est de %max% caractères.',
    'plan-item-custom.longUrl' => 'Cette URL est trop longue. La longueur maximum autorisée est de %max% caractères.',
    'plan-item-custom.useCustomButton' => 'Utiliser le bouton personnalisé pour le service',
    'plan-item-custom.useCustomButtonHint' => 'Placez un bouton personnalisé sur la page d\'accueil de l\'utilisateur et les pages du site Web.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Ouvrir l\'URL dans Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Indiquez si l\'URL doit être ouverte dans une page de Plesk ou dans une nouvelle fenêtre de navigateur.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Ne pas utiliser de cadre',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Si vous ajoutez un bouton personnalisé qui mène à une extension ou une application de Plesk dans le Panneau Client, vous pouvez indiquer comment vous souhaitez afficher ce service / cette application : dans un cadre ou intégré à l\'interface de Plesk.',
    'plan-item-custom.includeDomId' => 'Inclure l\'ID de l\'abonnement',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Inclure le nom du domaine principal',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Inclure le nom d\'utilisateur FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Inclure le mot de passe FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Inclure l\'ID du client',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Inclure le nom de la raison sociale du client",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Inclure le nom du contact du client",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Inclure l'adresse mail du client",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Choisir le mode de prévisualisation des sites Web',
    'preview-domain-settings.previewQuick' => 'Prévisualisation rapide par défaut',
    'preview-domain-settings.previewDisabled' => 'Désactiver la prévisualisation rapide',
    'preview-domain-settings.previewQuickDescription' => 'Option recommandée prête à fonctionner.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Prévisualisation rapide dans un nom de domaine de Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Sélectionnez l\'un de vos sites Web géré par Plesk afin de l\'utiliser pour cet aperçu.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Pour utiliser cette fonction, %%link%% au moins un domaine.',
    'preview-domain-settings.subscriptionCreateLink' => 'créer',
    'preview-domain-settings.previewZoneTypeExternal' => 'Prévisualisation rapide dans un nom de domaine externe',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Utilisez un nom de domaine externe (zone DNS). Si vous utilisez cette option, ajoutez l\'enregistrement DNS suivant (type A) dans la zone de domaine externe : *.<Plesk_IP>.external.dom. Sur cette page <Plesk_IP> correspond à l\'IP du serveur Plesk. Les points (.) pour IPv4 ou les deux-points (:) pour IPv6 sont remplacés par des tirets (-). Par exemple : *.192-0-2-12.external.dom. Si plus d\'une adresse IP est enregistrée pour Plesk, ajoutez un enregistrement pour chaque adresse.',
    'preview-domain-settings.sitePreviewProtection' => 'Authentification requise',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Requiert le nom d\'utilisateur et le mot de passe FTP pour accéder à l\'aperçu.',
    'preview-domain-settings.nginxNotInstalled' => 'La Prévisualisation rapide par défaut n\'est pas disponible, car le serveur Web Nginx n\'est pas installé.',
    'preview-domain-settings.nginxDisabled' => 'La Prévisualisation rapide par défaut n\'est pas disponible, car le serveur Web Nginx est désactivé.',

    'reseller-preferences.settingsSection' => 'Paramètres',
    'reseller-preferences.multiLogin' => 'Accepter les sessions multiples',
    'reseller-preferences.language' => 'Langue de l\'interface',
    'reseller-preferences.interfaceView' => 'Sélectionner votre interface',
    'reseller-preferences.serviceProviderView' => 'Vue Fournisseur de services',
    'reseller-preferences.serviceProviderViewHint' => 'Cette vue est destinée aux administrateurs du serveur qui fournissent et vendent des services d\'hébergement web à leurs clients via des packs de services.',
    'reseller-preferences.powerUserView' => 'Vue Power User',
    'reseller-preferences.powerUserViewHint' => 'Cette vue est adaptée à la gestion des sites web, de leurs fichiers, de leurs bases de données, de leurs comptes e-mails, des applications web et d\'autres services.',

    'reseller.hint' => 'Sur cette page, vous pouvez inscrire un nouveau revendeur à vos services d\'hébergement.',
    'reseller.contactInfoSection' => 'Informations sur le contact',
    'reseller.contactInfoSectionHint' => 'Saisissez les coordonnées du revendeur.',
    'reseller.accessToPanelSection' => 'Accès à Plesk',
    'reseller.accessToPanelSectionHint' => 'Les identifiants que le revendeur utilisera pour accéder à Plesk afin de gérer les services auxquels il est inscrit.',
    'reseller.subscription' => 'Abonnement',
    'reseller.subscriptionSectionHint' => 'Sélectionnez un pack de services auquel le revendeur sera abonné.',
    'reseller.servicePlan' => 'Pack de services',
    'reseller.none' => 'Aucun(e)',
    'reseller.customizeSubscription' => 'Procéder à la personnalisation des paramètres de l\'abonnement une fois le revendeur créé. Notez que cette procédure verrouillera l\'abonnement pour la synchronisation.',
    'reseller.subscriptionNotSynchronized' => 'Impossible de synchroniser l\'abonnement avec le pack de services. Les paramètres suivants de l\'abonnement sont en conflit avec le pack de services : %%problems%%.',

    'security-policy.encryptionSection' => 'Mode Sécurité renforcée',
    'security-policy.encryptionSectionHint' => 'Le mode de sécurité renforcé introduit la protection avancée des données confidentielles dans Plesk. Dans ce mode, Plesk utilise plusieurs mécanismes de sécurité qui sont complètement transparents pour les utilisateurs de Plesk. Si vous souhaitez renforcer la sécurité de Plesk, nous vous conseillons d\'activer ce mode.',
    'security-policy.encryptionEnable' => 'Mode Sécurité renforcée',
    'security-policy.securePassword' => 'Mode Sécurité renforcée',
    'security-policy.strengthSection' => 'Niveau de sécurité du mot de passe',
    'security-policy.strengthSectionHint' => 'La plupart des mots de passe que les utilisateurs peuvent définir ou modifier dans Plesk sont validés pour vérifier s\'ils sont conformes au niveau de sévérité minimum des mots de passe tel qu\'il est défini ici. Les mots de passe forts comportent au moins 9-12 caractères, dont des chiffres, des caractères spéciaux, des minuscules et des majuscules. Ils ne contiennent pas de mots du dictionnaire. Ils sont plus difficiles à deviner, mais aussi à mémoriser. <a href="%%link%%" target="_blank">En savoir plus sur le niveau de sévérité des mots de passe</a>.',
    'security-policy.passwordStrength' => 'Niveau de sécurité min. du mot de passe',
    'security-policy.secureFtpSection' => 'FTP sécurisé',
    'security-policy.ftpOverSsl' => 'Règles d\'utilisation FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS permet de protéger la communication entre le serveur FTP et les clients FTP externes à l\'aide du protocole SSL/TLS. Vous pouvez sélectionner ici les types de connexions qui doivent être autorisés.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS permet de protéger la communication entre le serveur FTP et les clients FTP externes à l\'aide du protocole SSL/TLS. Vous pouvez sélectionner ici les types de connexions qui doivent être autorisés. L\'option sélectionnée sera appliquée à toutes les adresses IP sur le serveur. Pour utiliser des paramètres personnalisés par adresse IP, sélectionnez l\'option correspondante, puis modifiez la politique FTPS sous Outils & Paramètres > Adresses IP.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS permet de protéger la communication entre le serveur FTP et les clients FTP externes à l\'aide du protocole SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS permet de protéger la communication entre le serveur FTP et les clients FTP externes à l\'aide du protocole SSL/TLS. Si vous voulez ajuster les paramètres FTPS en fonction des adresses IP, sélectionnez d\'abord l\'option "Utiliser les paramètres FTPS personnalisés par adresse IP" sous Outils & Paramètres > Politique de sécurité > FTP sécurisé.',
    'security-policy.ftpOverSslOptionRequired' => 'Autoriser uniquement les connexions FTPS sécurisées',
    'security-policy.ftpOverSslOptionEnabled' => 'Autoriser les connexions FTPS sécurisées et les connexions FTP non sécurisées',
    'security-policy.ftpOverSslOptionDisabled' => 'Autorisez uniquement les connexions FTP non sécurisées. Ne pas utiliser FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Utiliser les paramètres FTPS personnalisés par adresse IP',
    'security-policy.prohibitWebConfigHandlersSection' => 'Personnaliser la politique des gestionnaires',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Activez cette option pour empêcher les clients d\'écraser les gestionnaires IIS définis niveau serveur via le fichier web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Interdire le remplacement des gestionnaires via web.config',

    'server-mail-antivirus.used' => 'Antivirus utilisé',
    'server-mail-antivirus.policy' => 'Utiliser les paramètres valables pour l\'ensemble du serveur',
    'server-mail-antivirus.policyOff' => 'Analyse désactivée',
    'server-mail-antivirus.policyAny' => 'Analyser les messages entrants et sortants',
    'server-mail-antivirus.policyFrom' => 'Analyser les messages sortants uniquement',
    'server-mail-antivirus.policyTo' => 'Analyser les messages entrants uniquement',
    'server-mail-antivirus.allowPersonalSettings' => 'Autoriser les paramètres personnels',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Autoriser l\'écrasement des paramètres au niveau du serveur dans chaque adresse mail',
    'server-mail-antivirus.incoming' => 'pour les messages entrants',
    'server-mail-antivirus.outgoing' => 'pour les messages sortants',
    'server-mail-antivirus.success' => 'Les paramètres antivirus ont été modifiés.',

    'server-mail-black-list.title' => 'Ajouter le domaine à la liste noire',
    'server-mail-black-list.domainName' => 'Nom de domaine',
    'server-mail-black-list.emailAddress' => 'Adresses mail',
    'server-mail-black-list.emailAddressHint' => 'La partie située à gauche du caractère @ ne doit pas comporter de caractères non ASCII. Les adresses peuvent contenir les caractères génériques "*" et "?" (par exemple : *@domain.com, utilisateur?@*.com). Les parties non ASCII des noms de domaines ne doivent pas contenir de caractères génériques.',
    'server-mail-black-list.action' => 'Que faire des mails répondant au critère :',
    'server-mail-black-list.actionDelete' => 'Retirer du serveur',
    'server-mail-black-list.actionSpam' => 'Marquer comme spam',
    'server-mail-black-list.success' => 'Le domaine a été ajouté à la liste noire.',

    'server-mail-white-list.title' => 'Ajouter le réseau à la liste blanche',
    'server-mail-white-list.descEmailAddress' => 'L\'adresse e-mail saisie ici ne sera pas traitée comme du spam par SpamAssassin.',
    'server-mail-white-list.descIpAddress' => 'Les entrées IP spécifiées ici seront ajoutées aux exceptions du serveur de messagerie.',
    'server-mail-white-list.ipAddress' => 'Adresse IP/masque',
    'server-mail-white-list.ipAddressHint' => 'L\'adresse IP peut contenir des caractères génériques ou un masque CIDR.',
    'server-mail-white-list.emailAddress' => 'Adresses mail',
    'server-mail-white-list.emailAddressHint' => 'La partie située à gauche du caractère @ ne doit pas comporter de caractères non ASCII. Les adresses peuvent contenir les caractères génériques "*" et "?" (par exemple : *@domain.com, utilisateur?@*.com). Les parties non ASCII des noms de domaines ne doivent pas contenir de caractères génériques.',
    'server-mail-white-list.emailAddressOrIp' => 'Adresses e-mail ou IP',
    'server-mail-white-list.wildcardPattern' => 'Les adresses IP peuvent contenir des caractères de substitution (par exemple : 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'Les adresses IP peuvent contenir des masques CIDR (par exemple : 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Le réseau a été ajouté à la liste blanche.',

    'server-mail-settings.general.title' => 'Options générales',
    'server-mail-settings.general.mailUiEnabled' => 'Activer les fonctions de gestion de messagerie dans Plesk',
    'server-mail-settings.general.serverName' => 'Serveur de messagerie installé',
    'server-mail-settings.general.changeServerName' => 'installer et utiliser un autre serveur de messagerie',
    'server-mail-settings.general.imapServerName' => 'Installer un serveur IMAP/POP3',
    'server-mail-settings.general.changeImapServerName' => 'installer et utiliser un autre serveur IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Vous pouvez %%serverChangeLink%%.',
    'server-mail-settings.general.maxMessageSize' => 'Taille maximum du message',
    'server-mail-settings.general.kbytes' => 'Koctets',
    'server-mail-settings.general.maxConnections' => 'Nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS).',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Nombre maximum de serveurs (IMAP ou POP3) démarrés.',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Nombre maximum d\'utilisateurs de messagerie pouvant être connectés en même temps.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Nombre maximum de connexions par adresse IP',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Nombre maximum de connexions pour un utilisateur par adresse IP',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS) à accepter depuis la même adresse IP.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Nombre maximal de connexions (IMAP, POP3, IMAP via SSL/TLS ou POP3 via SSL/TLS) autorisées pour un utilisateur de messagerie depuis chaque adresse IP.',
    'server-mail-settings.general.messageSubmission' => 'Activer le service SMTP sur le port 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Activer le service SMTP sur le port 587 sur toutes les adresses IP',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Activé',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'toutes les adresses IP',
    'server-mail-settings.general.outgoingEmailMode' => 'Mode pour les mails sortants',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Envoyer depuis une adresse IP de domaine',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Envoyer depuis les adresses IP du domaine et utiliser les noms de domaine dans le message d\'accueil SMTP',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Envoyer depuis une adresse IP spécifiée',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Aucun',
    'server-mail-settings.general.subaddressing' => 'Activer le sous-adressage mail',
    'server-mail-settings.general.subaddressingHint' => 'Cette option permet de configurer les adresses mail du type %%verpStyleLink%% pour les listes d&apos;adresses mail.',
    'server-mail-settings.general.verpStyleLink' => 'Type VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Activer l\'avertissement relatif au quota de la boîte mail',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Envoyer un mail de notification aux utilisateurs de la messagerie lorsque le quota d\'utilisation est supérieur à 95 %',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Personnaliser l\'avertissement par défaut du quota de la boîte mail',
    'server-mail-settings.general.fixSender' => 'Corriger les expéditeurs mal définis pour les mails sortants',
    'server-mail-settings.general.fixSenderHint' => 'Définir automatiquement des en-têtes de mails valides et des adresses de rebond pour les mails sortants depuis les domaines pour réduire les risques d\'être considéré comme du spam.',
    'server-mail-settings.general.maxMessageSizeHint' => 'Pour les e-mails avec une pièce jointe, la valeur devrait être supérieure de 35 à 40 % à la taille de la pièce jointe. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Pour en savoir plus, consultez l\'article de la base de connaissances.',

    'server-mail-settings.autodiscover.title' => 'Autodécouverte des mails',
    'server-mail-settings.autodiscover.description' => 'Pour en savoir plus sur le fonctionnement, consultez la %%link%%',
    'server-mail-settings.autodiscover.link' => 'base de connaissances',
    'server-mail-settings.autodiscover.enabled' => 'Activer la découverte automatique du courrier',
    'server-mail-settings.autodiscover.enabledHint' => 'Lorsque vous activez cette fonctionnalité, tous les domaines avec la découverte automatique du courrier activée sont reconfigurés.',
    'server-mail-settings.autodiscover.customServer' => 'Nom de domaine personnalisé',
    'server-mail-settings.autodiscover.customServerHint' => 'Spécifiez un nom de domaine personnalisé à utiliser pour les serveurs de messagerie entrant et sortant lors de la configuration de l\'autodécouverte des mails.',
    'server-mail-settings.autodiscover.customServerCertHint' => 'Remarque : Le nom de domaine doit être sécurisé à l\'aide d\'un certificat SSL/TLS valide.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Reconfigurer les enregistrements DNS de découverte automatique',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Lorsque vous activez cette fonctionnalité, tous les enregistrements DNS avec découverte automatique des domaines activée sont reconfigurés.',

    'server-mail-settings.relay.title' => 'Options de relais',
    'server-mail-settings.relay.type' => "Relais",
    'server-mail-settings.relay.open' => "ouvert",
    'server-mail-settings.relay.openSpamWarning' => "En ouvrant votre relais de messagerie vous exposez votre serveur au spam.",
    'server-mail-settings.relay.openSpamChange' => "Conservez ce paramètre uniquement si vous voulez temporairement tester le serveur de messagerie ou si votre serveur Plesk se trouve dans un réseau interne non accessible via Internet.",
    'server-mail-settings.relay.closed' => "Fermé(e)",
    'server-mail-settings.relay.auth' => "Authentification requise :",
    'server-mail-settings.relay.notSupported' => "non pris en charge par le serveur de messagerie",
    'server-mail-settings.relay.change' => 'Pour activer l\'envoi de notifications de Plesk lorsque le relais est fermé, vous pouvez %%changeLink%%.',
    'server-mail-settings.relay.changeLink' => 'changer les paramètres SMTP.',
    'server-mail-settings.relay.pop3' => "POP3 avant SMTP",
    'server-mail-settings.relay.lockTime' => "Blocage",
    'server-mail-settings.relay.min' => "min.",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Ne pas utiliser de restriction de relais pour les réseaux suivants :',
    'server-mail-settings.relay.noRelayNetworksHint' => "Adresse IP/masque",

    'server-mail-settings.outgoing.title' => 'Limitations des e-mails sortants',
    'server-mail-settings.outgoing.description' => 'Les limites suivantes sont les limites par défaut. Elles peuvent être redéfinies par chaque pack de services et abonnement. Les limites ne sont pas appliquées au niveau du serveur. Ce sont des modèles pour les packs et les abonnements pour lesquels aucune limite personnalisée n\'a été définie. Remarque : lorsque vous activez les limites des e-mails sortants, cela peut affecter les performances du serveur de messagerie.',
    'server-mail-settings.outgoing.learnMore' => 'En savoir plus sur la limitation pour les mails sortants',
    'server-mail-settings.outgoing.enabled' => 'Activer les limitations pour les mails sortants',
    'server-mail-settings.outgoing.countRecipients' => 'Compter le nombre de destinataires au lieu de compter les messages',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Active le mode qui comptabilise un nombre de destinataires plutôt que le nombre de messages lors de la limitation des mails sortants et de la comptabilisation pour les statistiques. Par exemple, lorsqu\'un message est envoyé à 10 destinataires, il est compté comme 10 messages.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Limite par défaut des mails sortants depuis une boîte mail (par heure)',
    'server-mail-settings.outgoing.domainLimit' => 'Limite par défaut des mails sortants depuis un domaine (par heure)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Limite par défaut des mails sortants depuis un abonnement (par heure)',
    'server-mail-settings.outgoing.unlimited' => 'Illimité',
    'server-mail-settings.outgoing.sendmail' => 'Autoriser les utilisateurs et les scripts à utiliser Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Les scripts et les utilisateurs pourront envoyer des mails (au nom de l\'utilisateur système de l\'abonnement) à l\'aide de Sendmail, même si les limites d\'une boîte mail et d\'un domaine sont dépassées. Le nombre maximum de mails qui peuvent être envoyés via Sendmail sera défini par la limite d\'un abonnement complet. Ce paramètre n\'autorise pas les scripts à utiliser Sendmail pour tout le serveur, mais il agit en tant que paramètre par défaut pour les packs de services et les abonnements.',
    'server-mail-settings.outgoing.reportPeriod' => 'Afficher les rapports basés sur les statistiques pour les derniers / les dernières',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Les rapports sont créés et l\'alerte affichée sur la page d\'accueil pour indiquer les tentatives de dépassement des limites des mails sortants pendant la période indiquée.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Envoyer une notification par mail toutes les / tous les',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Les notifications fournissent des statistiques sur les tentatives de dépassement des limites des mails sortants pour la période spécifiée.',
    'server-mail-settings.outgoing.periodP1D' => '1 jour',
    'server-mail-settings.outgoing.periodP1W' => '1 semaine',
    'server-mail-settings.outgoing.periodP2W' => '2 semaines',
    'server-mail-settings.outgoing.periodP1M' => '1 mois',
    'server-mail-settings.outgoing.periodPT15M' => '15 minutes',
    'server-mail-settings.outgoing.periodPT1H' => '1 heure',
    'server-mail-settings.outgoing.periodPT6H' => '6 heures',
    'server-mail-settings.outgoing.periodPT12H' => '12 heures',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Les limites des mails sortants ne fonctionneront pas pour les expéditeurs dont les adresses IP sont incluses dans la liste blanche du serveur de messagerie. Par exemple, s\'il y a un hôte local (127.0.0.0 / 8, ::1 / 128) dans la liste blanche, tous les mails du serveur local seront envoyés avec succès, quelles que soient les limitations. Les expéditeurs peuvent utiliser soit leurs adresses IP locales (sites Web et scripts personnalisés hébergés sur le serveur local) soit des adresses IP externes (clients qui expédient les mails depuis des clients de messagerie installés sur leurs ordinateurs ou périphériques mobiles). Pour que ces limites s\'appliquent à tous les expéditeurs (adresses IP locales et externes), supprimez toutes les adresses IP et tous les réseaux de la liste blanche. Remarque : si vous supprimez l\'hôte local (127.0.0.0 / 8, ::1 / 128) de la liste blanche, cela risque de compromettre le fonctionnement de sites Web et scripts qui envoient des mails depuis ce serveur. Pour en savoir plus sur les limitations des mails sortants, consultez le Guide de l\'administrateur, section Protéger contre les spams sortants.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Le relais de messagerie est ouvert : les limites de mails sortants ne fonctionneront pas.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'La limite des messages sortants d\'un domaine (%%value%%) ne peut pas être supérieure à celle d\'un abonnement (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'La limite des messages sortants d\'une adresse mail (%%value%%) ne peut pas être supérieure à celle d\'un domaine (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'La limite des messages sortants d\'une adresse mail (%%value%%) ne peut pas être supérieure à celle d\'un abonnement (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Paramètres Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Utiliser des liens sécurisés dans les listes de diffusion',
    'server-mail-settings.mailman.secureLinksHint' => 'Activez ou désactivez la génération de liens sécurisés (HTTPS) dans les listes de diffusion.',
    'server-mail-settings.mailman.noLocalhost' => 'Pour utiliser des listes de diffusion, vous devez avoir un hôte local (127.0.0.0/8, ::1/128) dans la liste blanche du serveur de messagerie. Toutefois, pour utiliser le contrôle des mails sortants, vous ne devez pas avoir d\'hôte local dans la liste blanche. Vous pouvez appliquer le compromis suivant : si vous avez activé le contrôle des mails sortants, utilisez le transfert de mails sur la boîte mail au lieu des listes de diffusion.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Pour utiliser les listes de diffusion, vous avez besoin d\'un hôte local dans la liste blanche du serveur de messagerie. Toutefois, pour utiliser le contrôle des mails sortants, vous ne devez pas avoir d\'hôte local dans la liste blanche. Vous pouvez appliquer le compromis suivant : si vous avez activé le contrôle des mails sortants, utilisez le transfert de mails sur la boîte mail au lieu des listes de diffusion. Remarque : il n\'y a aucune adresse d\'hôte local IPv4 (127.0.0.0/8) dans la liste blanche actuellement, le contrôle des mails sortants fonctionnera donc pour les adresses IPv4.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Pour utiliser les listes de diffusion, vous avez besoin d\'un hôte local dans la liste blanche du serveur de messagerie. Toutefois, pour utiliser le contrôle des mails sortants, vous ne devez pas avoir d\'hôte local dans la liste blanche. Vous pouvez appliquer le compromis suivant : si vous avez activé le contrôle des mails sortants, utilisez le transfert de mails sur la boîte mail au lieu des listes de diffusion. Remarque : il n\'y a aucune adresse d\'hôte local IPv6 (::1/128) dans la liste blanche actuellement, le contrôle des mails sortants fonctionnera donc pour les adresses IPv6.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Activer DMARC pour vérifier les mails entrants',
    'server-mail-settings.spam-filter.dmarcHint' => 'Cette option est disponible lorsque SPF et DKIM sont activés pour les mails entrants.',
    'server-mail-settings.spam-filter.dkim' => 'Protection anti-spam DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Autoriser la signature des mails sortants',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Vérifier les mails entrants',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Vous ne pouvez pas désactiver cette option tant que DMARC est activé pour les mails entrants.',
    'server-mail-settings.spam-filter.spf' => 'Protection anti-spam SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Activer la protection anti-spam SPF pour vérifier la messagerie entrante',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Vous ne pouvez pas désactiver cette option tant que DMARC est activé pour les mails entrants.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'Continuer la vérification SPF en cas de problèmes de recherche DNS',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'D\'abord, SPF procède à une recherche DNS. Sélectionnez cette option pour continuer la vérification si la recherche DNS échoue. Cette option n\'est pas sélectionnée si elle n\'a pas d\'impact sur le mode de vérification actuel.',
    'server-mail-settings.spam-filter.behavior' => 'Mode de contrôle du SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'Ensuite, SPF applique les règles locales et d\'évaluation. Le message peut être rejeté selon le mode de vérification sélectionné et le résultat de la vérification.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Créer seulement des en-têtes Received-SPF et ne jamais bloquer',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'En cas de problème lors de la recherche des DNS, utiliser les messages d\'erreur temporaires',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Rejeter le mail quand SPF se résout en "fail" (refus)',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Rejeter le mail quand SPF se résout en "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Rejeter le mail quand SPF se résout en "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Rejeter le mail quand SPF ne résout pas en "pass"',
    'server-mail-settings.spam-filter.localRules' => 'Règles SPF locales',
    'server-mail-settings.spam-filter.guessRules' => 'Règles d\'évaluation SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Explication du SPF',
    'server-mail-settings.spam-filter.rbl' => "Protection anti-spam basée sur les listes noires de DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Activer la protection anti-spam basée sur les listes noires de DNS",
    'server-mail-settings.spam-filter.rblServer' => "Zones DNS pour le service DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "Entrées séparées par un point-virgule, par exemple : 'zen.spamhaus.org;dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Titres de réponses automatiques supplémentaires',
    'server-mail-settings.auto-reply-headers.description' => 'Définissez des titres supplémentaires pour tous les messages de réponse automatique venant du serveur Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Titres supplémentaires',

    'server-mail-settings.pop3-names.title' => "Nom pour les comptes mail POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Seuls les noms complets de comptes mail POP3/IMAP peuvent être utilisés.",
    'server-mail-settings.pop3-names.enabled' => "Les noms courts (webmaster) et complets (webmaster@domain.com) de comptes mails POP3/IMAP peuvent être utilisés.",

    'server-mail-settings.success' => 'Les paramètres du serveur de messagerie ont été changés.',

    'server-mail-spam-filter.general' => 'Général',
    'server-mail-spam-filter.isEnabled' => 'Activer le filtrage du spam SpamAssassin pour tout le serveur',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin n\'est pas installé.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Activer la protection anti-spam Greylisting valable pour l\'ensemble du serveur',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Appliquer les paramètres individuels au filtre anti-spam',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "SpamAssassin est désactivé : le serveur de messagerie ne prend pas en charge les paramètres du filtre de spam au niveau de la boîte de messagerie.",
    'server-mail-spam-filter.settings' => 'Paramètres SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Nbr max de processus',
    'server-mail-spam-filter.maxChildrenDescription' => 'Nombre maximal de processus anti-spam à exécuter.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Score requis',
    'server-mail-spam-filter.requiredHitsDescription' => 'Nombre de points qu\'un message doit avoir pour être qualifié comme spam.',
    'server-mail-spam-filter.maxMailLimit' => 'Ne pas filtrer si la taille de l\'e-mail est supérieure à cette valeur',
    'server-mail-spam-filter.maxMailLimitText' => 'Taille maxi',
    'server-mail-spam-filter.kbytes' => "Koctets",
    'server-mail-spam-filter.maxThreadsLimit' => 'Nombre de fils que le filtre anti-spam peut créer',
    'server-mail-spam-filter.tagTitle' => 'Étiquette spam
',
    'server-mail-spam-filter.tagDescription' => 'Le texte suivant sera ajouté au début de l\'objet de chaque message suspecté comme spam.',
    'server-mail-spam-filter.alarmMessage' => 'Texte avertissant qu\'un spam a été détecté',
    'server-mail-spam-filter.languages' => 'Langues sûres',
    'server-mail-spam-filter.locales' => 'Fichiers de langue sûrs',
    'server-mail-spam-filter.success' => 'La configuration du filtre anti-spam a été modifiée.',
    'server-mail-spam-filter.personalSettingsWarning' => 'La possibilité d\'appliquer des paramètres de filtre anti-spam est désactivée par l\'administrateur de serveur. Les paramètres de filtre anti-spam indiqués ci-dessous ne seront pas appliqués.',

    'service-plan.admin-plan.subscription_section' => 'Commun',
    'service-plan.admin-plan.tools_section' => 'Outils & Ressources',
    'service-plan.admin-plan.apps_section' => 'Applications & Bases de données',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Apparence de Plesk',
    'service-plan.admin-plan.statistics_section' => 'Statistiques',
    'service-plan.admin-plan.general_section' => 'Général',
    'service-plan.admin-plan.mail_section' => 'Boîte mail',
    'service-plan.admin-plan.server_section' => 'Serveur',
    'service-plan.admin-plan.modules_section' => 'Extensions',
    'service-plan.admin-plan.troubleshooting_section' => 'Assistance et résolution des problèmes',
    'service-plan.admin-plan.simplePanel' => 'Mode Restreint',
    'service-plan.admin-plan.enabled' => 'Activer le mode Restreint',
    'service-plan.admin-plan.enabledDescription' => 'Cochez cette option pour limiter les actions autorisées à l\'administrateur dans Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Cochez cette option pour limiter les actions autorisées à l\'administrateur supplémentaire dans Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Fournir uniquement les programmes que je sélectionne',
    'service-plan.applications-subscription.useFilterDescription' => 'Utilisez cette option pour sélectionner les programmes auxquels l\'abonné doit pouvoir accéder.',
    'service-plan.applications-subscription.applications' => 'Applications',
    'service-plan.applications-subscription.isCommercial' => 'Cette application est payante et requiert l\'achat d\'une clé de licence.',

    'service-plan.applications.useFilterLabel' => 'Fournir uniquement les programmes que je sélectionne',
    'service-plan.applications.useFilterDescription' => 'Utilisez cette option pour sélectionner les programmes auxquels l\'abonné doit pouvoir accéder.',
    'service-plan.applications.applications' => 'Applications',
    'service-plan.applications.isCommercial' => 'Cette application est payante et requiert l\'achat d\'une clé de licence.',

    'service-plan.dns.dnsZoneType' => 'Zone DNS du domaine',
    'service-plan.dns.dnsZoneTypeMaster' => 'Principal',
    'service-plan.dns.dnsZoneTypeSlave' => 'Secondaire',

    'service-plan.extras.groupOtherServices' => 'Autres services',
    'service-plan.extras.none' => 'Aucun',

    'service-plan.hosting.enablePhysicalHosting' => 'Activer l\'hébergement',
    'service-plan.hosting.sectionCoreHosting' => 'Propriétés générales',
    'service-plan.hosting.sectionScripting' => 'Script',
    'service-plan.hosting.defaultDatabaseServer' => 'Serveur de bases de données par défaut',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avancé',
    'service-plan.hosting.phpSettingsHelpLink' => 'Découvrir comment choisir les paramètres PHP les plus appropriés',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Statut des sites Web si l\'abonnement est suspendu',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Statut des sites Web dans les abonnements suspendus',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Le statut sélectionné sera appliqué à tous les sites Web de l\'abonnement au pack lorsque l\'abonnement est suspendu (par exemple, s\'il arrive à expiration ou si sa période payée expire).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Le statut sélectionné sera appliqué à tous les sites Web de l\'abonnement lorsque l\'abonnement est suspendu (par exemple, s\'il arrive à expiration ou si sa période payée expire).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Désactivé',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Les visiteurs du site Web seront redirigés vers la page par défaut du serveur Web.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Suspendu',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Les visiteurs des sites Web seront redirigés vers la page de document d\'erreur personnalisée à l\'aide de la redirection permanente du moteur de recherche (code HTTP 503).',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Actif',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Les sites Web resteront accessibles à partir d\'Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Allouer les adresses IP partagées',
    'service-plan.ip.allocateExclusiveIp' => 'Allouer les adresses IP dédiées',
    'service-plan.ip.allocateExclusiveIpV4' => 'Allouer des adresses IPv4 dédiées',
    'service-plan.ip.allocateExclusiveIpV6' => 'Allouer des adresses IPv6 dédiées',

    'service-plan.mail.mailService' => 'Service de messagerie',
    'service-plan.mail.mailServiceDisabled' => 'Désactivé',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Désactivé pour les mails entrants',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk ne fournira aucun service de messagerie sur les domaines.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Les domaines peuvent uniquement envoyer des e-mails et uniquement avec Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Activé',
    'service-plan.mail.mailServiceEnabledHint' => 'Les domaines peuvent envoyer et recevoir des e-mails.',
    'service-plan.mail.mailServiceNotConfigured' => 'Non configuré',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk ne fournira aucun service de messagerie sur les domaines.',
    'service-plan.mail.webMail' => 'Messagerie Web',
    'service-plan.mail.mailingLists' => 'Activer les listes de diffusion',
    'service-plan.mail.mailToNonExistentUser' => 'Politique de mails pour les utilisateurs non existants',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Rejeter avec un message',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Transférer à l\'adresse',
    'service-plan.mail.mailToNonExistentUserReject' => 'Rejeter',
    'service-plan.mail.mailAutodiscovery' => 'Activer la découverte automatique du courrier',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Pour en savoir plus, consultez la <a href="%%link%%" target="_blank">base de connaissances</a>',
    'service-plan.mail.bounceMessage' => 'Cette adresse n\'accepte plus de mail.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Rediriger vers un serveur de messagerie externe avec l\'adresse IP :',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - désactivée',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Note : le paramètre **Conserver les statistiques du trafic et du Web** n\'est pas modifié dans les abonnements lorsque vous le mettez à jour pour un pack de services. La seule manière de mettre à jour ce paramètre pour chaque domaine consiste à le modifier dans la base de données de Plesk. Pour en savoir plus, consultez <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">cet article de la base de connaissances</a>.',
    'service-plan.misc.retainEnabled' => 'Conserver les statistiques du trafic et du Web pendant',
    'service-plan.misc.logRotation' => 'Rotation des journaux',
    'service-plan.misc.logRotationCondition' => 'Condition de rotation des journaux',
    'service-plan.misc.logRotationBySize' => 'par taille',
    'service-plan.misc.logRotationByTime' => 'par date',
    'service-plan.misc.logRotationDaily' => 'Quotidien',
    'service-plan.misc.logRotationWeekly' => 'Hebdomadaire',
    'service-plan.misc.logRotationMonthly' => 'Mensuel',
    'service-plan.misc.logRotationSizeDescription' => 'La valeur du volume doit être comprise entre %%min%% et %%max%% Ko.',
    'service-plan.misc.maximumNumberOfFiles' => 'Nombre maximum de fichiers journaux',
    'service-plan.misc.compress' => 'Compresser les fichiers journaux',
    'service-plan.misc.sendLogToEmail' => 'Une fois que Plesk a récupéré les données à partir des fichiers journaux des serveurs Web et FTP, envoyer les journaux par mail à cette adresse',
    'service-plan.misc.kb' => 'Ko',
    'service-plan.misc.months' => 'Mois',
    'service-plan.misc.logRotationPeriodGreater' => 'La période de rotation des journaux ne peut pas être supérieure à la limite valable pour l\'ensemble du serveur %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Si ces paramètres sont désactivés, tous les sites Web d\'un abonnement utilisent le même pool d\'applications IIS dédié pour l\'abonnement.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Sélectionnez les services et privilèges avec l\'abonnement.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Afficher plus de droits disponibles',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Afficher moins de droits',
    'service-plan.permissions-subscription.noShellManagement' => 'Non autorisé',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Gestion de l\'accès au serveur via SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Cela permet au client d\'activer SSH pour ses utilisateurs système. Le paramètre d\'hébergement "Accès SSH au shell du serveur sous l\'utilisateur système de l\'abonnement" agit comme paramètre prédéfini.',

    'service-plan.permissions.permissionsTabDescription' => 'Sélectionnez les services et les droits fournis avec le pack.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Sélectionnez les services et privilèges qui seront ajoutés aux abonnements avec ce pack d\'add-ons. Notez que les droits non sélectionnés dans l\'add-on ne modifieront en aucun cas les paramètres d\'abonnement.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Les droits permettent aux clients de modifier des paramètres spécifiques de leurs abonnements. Lorsqu\'un abonnement est créé, Plesk applique les valeurs prédéfinies du pack aux paramètres que le client peut modifier. Par la suite, si le pack est mis à jour ou si un pack supplémentaire est appliqué, les modifications réalisées par le client ne sont pas écrasées.',
    'service-plan.permissions.showMorePermissions' => 'Afficher plus de droits disponibles',
    'service-plan.permissions.hideMorePermissions' => 'Afficher moins de droits',
    'service-plan.permissions.noShellManagement' => 'Non autorisé',
    'service-plan.permissions.systemAccessLabel' => 'Gestion de l\'accès au serveur via SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Fait que le paramètre d\'hébergement "Accès SSH au shell du serveur sous l\'utilisateur système de l\'abonnement" agit comme un paramètre prédéfini.',

    'service-plan.resources-subscription.overusePolicy' => 'Politique de surutilisation',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'La surutilisation n\'est pas autorisée',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Interdisez la surutilisation des ressources. Un abonnement est automatiquement suspendu si l\'utilisation des ressources dépasse les valeurs limites.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'La surutilisation de l\'espace disque et du trafic est autorisée',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Autorisez la surutilisation de l\'espace disque et du trafic. Interdisez la surutilisation des autres ressources.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'La surutilisation est autorisée (déconseillé)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Autorisez l\'abonné à utiliser plus de ressources que l\'abonnement initial n\'en contient.',
    'service-plan.resources-subscription.overuseNotify' => 'Me notifier par mail en cas de surutilisation.',
    'service-plan.resources-subscription.oversellPolicy' => 'Politique de survente',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'La survente est autorisée',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'La survente permet à un revendeur de vendre plus de ressources que celles qui lui sont actuellement allouées avec un abonnement. Si la survente est autorisée, un revendeur est soumis à l\'utilisation réelle des ressources au lieu de l\'affectation initiale des ressources',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'La survente n\'est pas autorisée',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Si la survente n\'est pas autorisée, un revendeur ne peut vendre que le nombre de ressources qui lui ont été initialement allouées avec un abonnement, peu importe le nombre de ces ressources réellement utilisées.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Définissez les limites d\'utilisation des ressources fournies avec l\'abonnement.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Afficher plus de ressources disponibles',
    'service-plan.resources-subscription.hideMoreResources' => 'Afficher moins de ressources',

    'service-plan.resources.overusePolicy' => 'Politique de surutilisation',
    'service-plan.resources.overusePolicyNotAllowed' => 'La surutilisation n\'est pas autorisée',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Interdisez la surutilisation des ressources. Un abonnement est automatiquement suspendu si l\'utilisation des ressources dépasse les valeurs limites.',
    'service-plan.resources.overusePolicySoftAllowed' => 'La surutilisation de l\'espace disque et du trafic est autorisée',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Autorisez la surutilisation de l\'espace disque et du trafic. Interdisez la surutilisation des autres ressources.',
    'service-plan.resources.overusePolicyAllowed' => 'surutilisation autorisée (déconseillé)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Autorisez les clients à utiliser plus de ressources que le pack initial n\'en contient.',
    'service-plan.resources.overuseNotify' => 'Me notifier par mail en cas de surutilisation.',
    'service-plan.resources.oversellPolicy' => 'Politique de survente',
    'service-plan.resources.oversellPolicyAllowed' => 'La survente est autorisée',
    'service-plan.resources.oversellPolicyAllowedHint' => 'La survente permet à un revendeur de vendre plus de ressources que celles qui lui sont actuellement allouées avec un pack. Si la survente est autorisée, un revendeur est soumis à l\'utilisation réelle des ressources au lieu de l\'affectation initiale des ressources',
    'service-plan.resources.oversellPolicyNotAllowed' => 'La survente n\'est pas autorisée',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Si la survente n\'est pas autorisée, un revendeur ne peut vendre que le nombre de ressources qui lui ont été allouées au début avec un pack, et ce sans tenir compte du nombre de ces ressources actuellement utilisées.',
    'service-plan.resources.mainGroupTitle' => 'Définissez les ressources fournies avec le pack.',
    'service-plan.resources.additionalGroupTitle' => 'Afficher plus de ressources disponibles',
    'service-plan.resources.hideMoreResources' => 'Afficher moins de ressources',
    'service-plan.resources.allowSitebuilderUpsell' => 'Autoriser le client à créer des sites de test Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Ce paramètre autorise le client à créer plus de sites Presence Builder que le nombre autorisé par le pack de services. Le client devra acheter ces sites Web pour pouvoir les publier.',

    'service-plan.servicePlanName' => 'Nom du pack de services',
    'service-plan.resellerPlanName' => 'Nom du pack revendeur',
    'service-plan.addonPlanName' => 'Nom du pack d\'add-ons',
    'service-plan.adminPlanPermissionsTab' => 'Outils d\'administration',
    'service-plan.adminPlanPermissionsTabDescription' => 'Sélectionnez les fonctionnalités dont dispose l\'administrateur en mode Restreint.',
    'service-plan.hostingPermissionsTab' => 'Outils d\'hébergement',
    'service-plan.hostingPermissionsTabDescription' => 'Sélectionnez les paramètres et outils d\'hébergement Web dont dispose l\'administrateur dans la Vue Power User en mode Restreint.',
    'service-plan.resourcesTab' => 'Ressources',
    'service-plan.resourcesTabDescription' => 'Définissez les ressources fournies avec le pack et la politique sur l\'utilisation des ressources.',
    'service-plan.subscriptionResourcesTabDescription' => 'Définissez les ressources fournies avec l\'abonnement et la politique sur l\'utilisation des ressources.',
    'service-plan.hostingTab' => 'Paramètres d\'hébergement',
    'service-plan.hostingTabDescription' => 'Indiquez les paramètres du service d\'hébergement fourni avec le pack. Remarque : les paramètres indiqués dans le pack d\'add-on ne sont pas appliqués aux abonnements qui ont le droit "Gestion des paramètres d\'hébergement" accordé soit par le pack de services soit par le pack d\'add-on.',
    'service-plan.secureSettingsDescription' => 'Si vous voulez que l\'hébergement fourni soit le plus sûr, %%link%%. Notez que certains droits, s\'ils sont accordés, permettent aux abonnés de changer ces paramètres. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'appliquez le paramètre prédéfini de sécurité',
    'service-plan.secureSettingsHelpLink' => 'En savoir plus sur le paramètre d\'hébergement sécurisé',
    'service-plan.mailTab' => 'Boîte mail',
    'service-plan.mailTabDescription' => 'Indiquez les paramètres du service de messagerie fourni avec le pack.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Indiquez les paramètres du service DNS fourni avec le pack.',
    'service-plan.performanceTab' => 'Performances',
    'service-plan.performanceTabDescription' => 'Indiquez les paramètres du système affectant les performances de tous les services fournis avec le pack.',
    'service-plan.permissionsTab' => 'Droits',
    'service-plan.miscTab' => 'Journaux & Statistiques',
    'service-plan.miscTabDescription' => 'Indiquez comment les statistiques et journaux des abonnements du pack doivent être stockés. Remarque : ces paramètres ne se synchronisent pas au sein des abonnements.',
    'service-plan.miscTabAdminPlanDescription' => 'Indiquez les modalités de stockage des statistiques et journaux des abonnements.',
    'service-plan.extrasTab' => 'Autres services',
    'service-plan.extrasTabDescription' => 'Sélectionnez les services qui doivent être inclus dans le pack outre les services de messagerie, DNS et d\'hébergement Web.',
    'service-plan.ipTab' => 'Adresses IP',
    'service-plan.ipTabDescription' => 'Définissez les paramètres des ressources IP fournies avec le pack.',
    'service-plan.applicationsTab' => 'Applications',
    'service-plan.applicationsTabDescription' => 'Sélectionnez les programmes qui doivent être disponibles dans le pack. Vous pouvez choisir de fournir tous les programmes disponibles depuis le Catalogue d\'applications plus ceux que vous avez envoyés vers le serveur ou sélectionner les programmes manuellement. Si vous voulez fournir tous les programmes, ne faites rien dans cet onglet, allez simplement dans l\'onglet Droits et sélectionnez l\'option Accès au catalogue d\'applications. Si vous voulez sélectionner les programmes manuellement, vous pouvez le faire sur cet onglet.',
    'service-plan.applicationsTabDescription-addon' => 'Sélectionnez les applications qui doivent être disponibles dans l\'add-on.',
    'service-plan.applicationsTabDescription-subscription' => 'Sélectionnez les programmes qui doivent être disponibles dans l\'abonnement. Vous pouvez choisir de fournir tous les programmes disponibles depuis le Catalogue d\'applications plus ceux que vous avez envoyés vers le serveur ou sélectionner les programmes manuellement. Si vous voulez fournir tous les programmes, ne faites rien dans cet onglet, allez simplement dans l\'onglet Droits et sélectionnez l\'option Accès au catalogue d\'applications. Si vous voulez sélectionner les programmes manuellement, vous pouvez le faire sur cet onglet.',
    'service-plan.planSyncSubsriptionWarning' => 'Certains abonnements n\'ont pas été synchronisés avec le pack. Ils ont été signalés comme étant \'Non synchronisé\' dans la liste des abonnements. Pour retenter la synchronisation, allez sur la page de présentation des abonnements et cliquez sur le bouton Synchroniser.',
    'service-plan.planSyncResellerWarning' => 'Certains revendeurs n\'ont pas été synchronisés avec le pack. Ils ont été signalés comme étant \'Non synchronisé\' dans la liste des revendeurs. Pour retenter la synchronisation, allez sur la page de présentation des revendeurs et cliquez sur le bouton Synchroniser.',
    'service-plan.planSyncAdminWarning' => 'Impossible d\'appliquer les modifications dans les abonnements car Plesk ne fournit pas certaines ressources ou services affectés par ces changements. Cause : %%reason%%',
    'service-plan.duplicateName' => 'Un pack portant ce nom existe déjà.',
    'service-plan.phpSettingsTab' => 'Paramètres PHP',
    'service-plan.phpHandlerNotFound' => 'Impossible de récupérer les informations sur la version de PHP du pack. Réinstallez-la ou sélectionnez une version de PHP pour le pack de services.',
    'service-plan.phpHandlerNotRegistered' => "PHP version %%fullVersion%% n'est pas installé. Le script PHP pour les domaines avec ce pack de service ne sera pas disponible. Installez PHP <nobr>version %%fullVersion%%</nobr> ou sélectionnez une autre version de PHP pour ce pack de services.",

    'service-plan.phpSettingsTabDescription' => 'Sur cette page, vous pouvez indiquer les paramètres PHP par abonnement qui écrasent les paramètres définis par le fichier php.ini valable pour l\'ensemble du serveur. Cela peut être utile, par exemple, lorsque vous voulez limiter l\'utilisation des ressources du système par les scripts PHP des clients. Les clients (si autorisés) peuvent remplacer cette configuration PHP par leur propre configuration par domaine. Lorsque vous définissez un paramètre sur Valeur par défaut, PHP utilise la valeur du paramètre de la configuration PHP valable pour l\'ensemble du serveur. Notez que les variables suivantes sont prises en charge : {DOCROOT} et {WEBSPACEROOT} correspondent au répertoire root des documents d\'un domaine et au répertoire root d\'un abonnement avec configuration PHP personnalisée ; {TMP} correspond au répertoire de stockage des fichiers temporaires. Remarque : les paramètres ci-dessous peuvent être écrasés par les paramètres spécifiés dans les fichiers .htaccess, php.ini ou .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Ici, vous pouvez indiquer les paramètres PHP par abonnement qui remplacent les paramètres définis par le pack de services principal. Cela peut être utile, par exemple, lorsque vous voulez supprimer certaines limites PHP définies dans le pack de services principal. Lorsque vous configurez un paramètre sur Valeur par défaut, le PHP utilise la valeur du paramètre de la configuration PHP du pack de services. Notez que les variables suivantes sont prises en charge : {DOCROOT} et {WEBSPACEROOT} correspondent au répertoire root des documents d\'un domaine et au répertoire root d\'un abonnement avec configuration PHP personnalisée ; {TMP} correspond au répertoire de stockage des fichiers temporaires.',
    'service-plan.phpSettingsPhpVersion' => 'Votre version actuelle de PHP est : %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Sur cette page, vous pouvez indiquer les paramètres PHP par abonnement qui ne tiennent pas compte des paramètres définis par le fichier php.ini valable pour l\'ensemble du serveur. Lorsque vous configurez un paramètre sur Valeur par défaut, le PHP utilise la valeur du paramètre de la configuration PHP valable pour l\'ensemble du serveur.',
    'service-plan.webServerSettingsTab' => 'Serveur web',
    'service-plan.webServerSettingsTabDescription' => 'Sur cette page, vous pouvez indiquer les paramètres du serveur Web Apache pour ce pack de services. Si Apache est exécuté avec Nginx en tant que serveur frontal, vous pouvez également préciser les paramètres Nginx sur cette page. Tous les nouveaux domaines créés recevront les paramètres indiqués. Toutefois, lorsque vous modifiez ces paramètres, les domaines existants ne reçoivent pas ces modifications.',
    'service-plan.servicesTab' => 'Services',
    'service-plan.servicesTabDescription' => 'Vous pouvez préciser ici les services affectés au pack de services.',
    'service-plan.servicePropertiesTab' => 'Propriétés : %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Vous pouvez préciser ici les propriétés du service %%serviceName%% affecté au pack de services.',
    'service-plan.longTaskWarning' => 'Vous avez %%subscriptionsCount%% abonnements qui doivent être synchronisés avec ce pack. Remarque : la tâche risque de demander un certain temps et sera exécutée en arrière-plan.',
    'service-plan.hostingParametersTab' => 'Paramètres d\'hébergement',
    'service-plan.adminInfoSection' => 'Informations pour l\'administrateur',
    'service-plan.descriptionInPanel' => 'Description',
    'service-plan.longDescription' => 'La description indiquée est trop longue.',
    'service-plan.conflictPermissions' => 'Impossible d\'accorder les droits suivants, car ils sont en conflit avec le pack revendeur : %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Type de démarrage',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatique',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manuel(le)',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Désactivé',
    'services.change-startup-type.autoActionError' => 'Impossible de définir le type de démarrage sur \'auto\' : %%error%%',
    'services.change-startup-type.manualActionError' => 'Impossible de définir le type de démarrage sur \'manual\' : %%error%%',
    'services.change-startup-type.disableActionError' => 'Impossible de définir le type de démarrage sur \'disabled\' : %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Rétablir le paramétrage initial',
    'sessions.settings.restoreDefaultButtonDescription' => 'Restaurer les valeurs par défaut des paramètres de session.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Les valeurs par défaut sont appliquées aux paramètres de session.',
    'sessions.settings.idleTime' => 'Période d\'inactivité de la session',
    'sessions.settings.disableCheckSessionIp' => 'Autoriser les modifications d\'adresses IP pendant une même session',
    'sessions.settings.minuteShortTitle' => 'min.',

    'settings-ui.controls.title' => 'Contrôles',

    'settings-ui.interface-views.description' => "Diverses vues de l'interface utilisateur du produit sont à votre disposition. En fonction de la vue que vous utilisez, les fonctions et paramètres peuvent être situés dans différents endroits, voire activés/désactivés. Il est préférable d'avoir différentes vues pour différents types d'utilisateurs.",
    'settings-ui.interface-views.panelSimpleLink' => 'Outils & Paramètres > Paramètres du mode Restreint',
    'settings-ui.interface-views.useCustomView' => 'Activer le mode Restreint',
    'settings-ui.interface-views.useCustomViewHint' => 'Sélectionnez cette option pour limiter les actions autorisées à l\'administrateur dans Plesk Panel. Pour changer la disponibilité des actions, allez dans %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Cette vue est adaptée à la gestion des sites web, de leurs fichiers, de leurs bases de données, de leurs comptes e-mails, des applications web et d\'autres services.',
    'settings-ui.interface-views.selectUiModeTitle' => "Sélectionner votre interface",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Vue Power User (pour les développeurs et les agences Web)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Vue Fournisseur de services (pour les hébergeurs)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Cette vue est destinée aux administrateurs du serveur qui fournissent et vendent des services d\'hébergement web à leurs clients via des packs de services.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Masquer le contrôle des rebonds',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Masque le bouton qui permet de définir comment traiter les mails envoyés vers des adresses e-mail inexistantes.',

    'settings-ui.branding.description' => 'Personnalisez l\'interface de Plesk à l\'image de votre marque en modifiant l\'apparence de la page dans la barre de titre du navigateur et/ou en remplaçant le logo Plesk dans le coin supérieur gauche.',
    'settings-ui.branding.buttonDefault' => 'Logo par défaut',
    'settings-ui.branding.sectionTitle' => 'Titre personnalisé',
    'settings-ui.branding.enableCustomTitle' => 'Activer les titres personnalisés sur les pages Plesk',
    'settings-ui.branding.customTitle' => 'Texte du titre',
    'settings-ui.branding.sectionLogo' => 'Logo personnalisé',
    'settings-ui.branding.enableCustomLogo' => 'Activer le logo personnalisé sur le panneau',
    'settings-ui.branding.logo' => 'Fichier du logo',
    'settings-ui.branding.logoUrl' => 'URL du logo',
    'settings-ui.branding.logoUrlEnabled' => 'Personnalisé',
    'settings-ui.branding.logoUrlDisabled' => 'Par défaut',
    'settings-ui.branding.sectionFavicon' => 'Favicon personnalisée',
    'settings-ui.branding.enableCustomFavicon' => 'Activer la favicon personnalisée',
    'settings-ui.branding.sectionFaviconDesc' => 'Vous devez télécharger la même favicon dans les deux formats afin qu\'elle soit prise en charge correctement dans les différents navigateurs.',
    'settings-ui.branding.faviconSvg' => 'Fichier Favicon SVG',
    'settings-ui.branding.faviconSvgHint' => 'Format autorisé : SVG',
    'settings-ui.branding.faviconIco' => 'Fichier Favicon ICO',
    'settings-ui.branding.faviconIcoHint' => 'Format autorisé : ICO',
    'settings-ui.branding.show' => 'Afficher',
    'settings-ui.branding.updateSuccess' => 'Les propriétés de marque de Plesk ont été changées.',
    'settings-ui.branding.sectionBackground' => 'Arrière-plan personnalisé de l\'écran de connexion',
    'settings-ui.branding.enableCustomBackground' => 'Activer l\'image d\'arrière-plan',
    'settings-ui.branding.backgroundFile' => 'Image du fond d\'écran',
    'settings-ui.branding.backgroundColor' => 'Couleur de l\'arrière-plan',
    'settings-ui.branding.backgroundResetColor' => 'Réinitialiser',
    'settings-ui.branding.backgroundFit' => 'Ajustement de l\'arrière-plan',
    'settings-ui.branding.background.fit.fill' => 'Remplir',
    'settings-ui.branding.background.fit.fit' => 'Ajuster',
    'settings-ui.branding.background.fit.center' => 'Centrer',
    'settings-ui.branding.background.fit.tile' => 'Tuile',

    'sitebuilder.trial.description' => 'Sur cette page, vous pouvez configurer le mode Tester et Acheter (anciennement connu sous le nom de Scénario d\'acquisition des clients). Dans ce mode, le client peut créer un site Web avec toutes les fonctionnalités disponibles dans l\'application Presence Builder incluse. Cependant, la publication des sites Web de test n\'est pas disponible pour les clients jusqu\'à ce qu\'ils aient acheté un pack de services d\'hébergement ou un add-on de pack. Le mode Tester et Acheter peut également être accordé à vos clients existants via un pack d\'hébergement ou un add-on de pack. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Pour en savoir plus, reportez-vous à la documentation.',
    'sitebuilder.trial.lifetimeLabel' => 'Durée d\'existence du site Web de test',
    'sitebuilder.trial.lifetimeUnits' => 'jours',
    'sitebuilder.trial.lifetimeDescription' => 'Il s\'agit du délai avant la suppression du serveur de ces sites Web de test qui n\'ont pas été achetés par les clients.',
    'sitebuilder.trial.signupLabel' => 'Activer l\'accès public pour le mode de test',
    'sitebuilder.trial.signupDescription' => 'Pour attirer les clients vers l\'hébergement avec Presence Builder et leur mettre à disposition une démo du produit, activez l\'accès public à la version de test et publiez l\'URL d\'accès au mode de test sur votre site Web.',
    'sitebuilder.trial.signupLinkLabel' => 'URL d\'accès au mode de test',
    'sitebuilder.trial.signupLinkDescription' => 'Cette URL s\'ouvrira dans Presence Builder en mode de test. Postez cette URL sur votre site Web pour publier l\'hébergement avec Presence Builder et attirer des clients.',
    'sitebuilder.trial.promotionLabel' => 'Afficher la notification du mode de test dans l\'éditeur Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Utilisez cette option si vous voulez afficher des notifications supplémentaires sur le fonctionnement de Presence Builder en version de test.',

    'update-settings.policyHintForPum' => 'Sur cette page, vous pouvez configurer l\'installation automatique des mises à jour. Vous pouvez recevoir une notification par mail lorsque de nouvelles mises à jour sont disponibles pour l\'installation manuelle ou lorsqu\'elles ont été installées automatiquement.',
    'update-settings.policyHint' => 'Vous pouvez recevoir une notification par mail lorsque de nouvelles mises à jour sont disponibles pour l\'installation manuelle ou lorsqu\'elles ont été installées automatiquement.',
    'update-settings.branchDisabledDescription' => 'Ne pas me notifier des mises à niveau disponibles',
    'update-settings.automaticPatchesInstallation' => 'Installer automatiquement les mises à jour de Plesk (recommandé)',
    'update-settings.automaticPatchesThirdParty' => 'Installer automatiquement les mises à jour pour les composants tiers fournis par Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Installer automatiquement les mises à jour du pack système',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Remarque : cela installe aussi automatiquement les mises à jour des composants tiers fournis par Plesk.',
    'update-settings.installerProxyMode' => 'Accéder au programme d\'installation de Plesk via le nom d\'hôte de Plesk et le port',
    'update-settings.installerProxyModeHint' => 'Accéder à l\'interface web du Programme d\'installation de Plesk sans ouvrir de port TCP 8447 supplémentaire dans le pare-feu.',
    'update-settings.automaticPatchesNotification' => 'Envoyer une notification pour les mises à jour de packs système disponibles et installées',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Adresse mail',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Fréquence des notifications par mail',
    'update-settings.daily' => 'Tous les jours',
    'update-settings.weekly' => 'Toutes les semaines',
    'update-settings.generalSection' => 'Général',
    'update-settings.notificationsSection' => 'Notifications',
    'update-settings.safeUpdatesSection' => 'Mises à jour fiables',
    'update-settings.safeUpdatesSectionHint' => 'Plesk vérifie que les mises à jour des packs système sont installées depuis le même répertoire que celui à partir duquel les packs ont été installés. Les mises à jour de ce type sont considérées comme fiables. Si vous désactivez les mises à jour fiables, le gestionnaire de packs système peut installer des mises à jour depuis tout répertoire du système.',
    'update-settings.safeUpdatesSectionWarn' => 'Nous vous recommandons de ne pas désactiver les mises à jour fiables sauf si vous êtes un utilisateur avancé. Ne pas différencier les mises à jour des packs système des autres répertoires peut nuire au bon fonctionnement du serveur.',
    'update-settings.allowSafeUpdates' => 'Autoriser les mises à jour fiables des packs système',

    'requiredFields' => 'Champs obligatoires',

    'ip-ban.banned-ip.ipAddress' => 'Adresse IP',
    'ip-ban.banned-ip.hintIpAddress' => 'Ajoutez une adresse IP ou un masque CIDR.',
    'ip-ban.banned-ip.banType' => 'Bannir l\'adresse IP : ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'Pendant une semaine',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Définitivement',

    'server-mail-smarthost.settings.title' => 'Paramètres de l\'hôte intelligent',
    'server-mail-smarthost.settings.useSmarthost' => 'Envoyer les mails des utilisateurs via un hôte intelligent',
    'server-mail-smarthost.configuration.title' => 'Configuration de l\'hôte intelligent',
    'server-mail-smarthost.configuration.hostnameOrIP' => 'Nom d\'hôte ou adresse IP',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => 'Pour désactiver les recherches MX ou SRV, placez le nom d\'utilisateur ou l\'adresse IP entre des crochets, par exemple : [example.com].',
    'server-mail-smarthost.configuration.checkConnection' => 'Vérifier la connexion',
    'server-mail-smarthost.configuration.port' => 'Port',
    'server-mail-smarthost.configuration.username' => 'Nom d\'utilisateur',
    'server-mail-smarthost.configuration.password' => 'Mot de passe',
    'server-mail-smarthost.configuration.encryption' => 'Connexion chiffrée',
    'server-mail-smarthost.configuration.encryption.Unix.on' => 'Obligatoire',
    'server-mail-smarthost.configuration.encryption.Unix.off' => 'Non obligatoire',
    'server-mail-smarthost.configuration.encryption.Windows.off' => 'Aucun',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => 'Authentification obligatoire',
    'server-mail-smarthost.configuration.checkConnection.success' => 'La connexion à l\'hôte intelligent a été établie.',
    'server-mail-smarthost.success' => 'La configuration de l\'hôte intelligent a été modifiée.',
    'server-mail-smarthost.settings.noteTitle' => 'Remarque :',
    'server-mail-smarthost.settings.note' => '%%title%% si vous configurez l\'envoi de mails via un hôte intelligent, vous devez mettre à jour manuellement l\'enregistrement SPF et les autres enregistrements DNS dans le template DNS et dans les zones DNS des domaines existants. Cette action est nécessaire pour éviter les erreurs de vérification pour les mails envoyés via l\'hôte intelligent. %%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => 'En savoir plus',
];