<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Tinanggihan ang pag-access. Ang iyong account ay nasuspinde.",
    'login_up__login_has_been_locked' => "Ikaw ay sumubok na mag-log in gamit ang maling password nang maraming beses. Para sa kadahilanan sa seguridad, ikaw ay hindi makaka-log in sa ilalim ng username na ito sa ilang sandali.",
    'login_up__unable_to_check_pass' => "Hindi marepaso ang password: %1",
    'login_up__warning_limits_licence_key' => "Isa sa mga sumusunod na aytem ay lumapas sa itinakdang limitasyon ng iyong license key: bilang ng mga user account, domains, mail account o web user na naka-host sa iyong server.\nMangyaring makipag-ugnayan sa departamento ng sales ng Plesk upang makabili ng key na magpapahintulot sa iyo na maka-host ng gustong bilang ng mga gumagamit at domain. Mangyaring makipag-ugnayan sa teknikal na departamento ng suporta ng Plesk kung sa pakiramdam mo nakatanggap ka ng mensaheng ito nang hindi sinasadya.\nAng lisensyadong limitasyon para sa user account/domain/mail account/web user/language pack: %2.\nAng bilang ng mga user account/domain/mail account/web user/language pack ay kasalukuyang naka-host: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Ang dami ng mga pinagkukunan na iyong pinapagana ay lumampas sa mga limitasyon na tinukoy ng iyong kasalukuyang lisensya sa produkto. Mangyaring makipag-ugnayan sa departamento ng sales ng Plesk at bumili ng isang baging license key.",
    'login_up__grace_period' => 'Kasalukuyan kang gumagamit sa panahon ng palugit ng lisensya ng iyong produkto. Para i-update ang lisensya ng iyong produkto, piliin ang opsyong Kumuha ng mga Key sa %1page ng Impormasyon ng Lisensya%2.',
    'login_up__partner_license_message' => 'Kasalukuyan kang gumagamit nang may limitadong lisensya ng produkto na nangangailangan ng pagrerehistro bago i-activate ang kumpletong hanay ng mga feature. Para i-update ang lisensya ng iyong produkto, piliin ang opsyong Kumuha ng mga Key sa %1page ng Impormasyon ng Lisensya%2.',
    'login_up__system_admin_disabled' => 'Ang superuser (root o administrator account) ay mahigpit na ipinagbabawal na mag-log in sa Plesk para sa kadahilanang pangseguridad.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Gabay ng Plesk Administrator",
    'plesk_guide_reseller' => "Gabay ng Plesk Reseller",
    'plesk_guide_client' => "Gabay ng Plesk Customer",
    'plesk_guide_domain_admin' => "Gabay ng Plesk Domain Administrator",
    'plesk_guide_mailuser' => "Gabay ng Plesk Email User",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Hanapin', // multiple usage: TBI
    'nav__general' => 'Main Menu',
    '__home' => 'Home',
    '__applications' => 'Mga application',
    '__settings' => 'Mga setting',
    'nav__system' => 'System',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Itaas ng Antas',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Alisin',
    'bt_make_default' => 'Gawing Default',

    // common list object search keys
    'bt_show_all' => "I-reset ang paghahanap",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktibo',
    '__object_off' => 'Suspendido',

    '__home_description' => 'Bumalik sa Home page.',
    'indicator_title' => '%1% nagamit, %2% libre', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'Hiniling ang URL na hindi wasto',

    // business objects
    'mn_list__mail_names_for_client' => 'Mga mail account sa Ilalim ng Account ng User na %1',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'Pangalan',
    'domains_list__state__filter_title' => 'Ginamit na Resource',
    'domains_list__filter_state_any' => 'Anuman',
    'domains_list__filter_state_overuse' => 'Sobrang paggamit',
    'domains_list__filter_state_normal' => 'Sa loob ng mga limit',
    'domains_list__status__filter_title' => 'Estado',
    'domains_list__filter_status_any' => 'Anuman',
    'domains_list__filter_status_blocked' => 'Suspendido',
    'domains_list__filter_status_active' => 'Aktibo',
    'domains_list__subrows__filter_title' => 'Ipakita',
    'domains_list__subrows_off' => 'Mga domain lamang',
    'domains_list__subrows_subdomain_domainaliases' => 'May mga subdomain at mga alyas',
    'domains_list__subrows_subdomain' => 'May mga subdomain',
    'domains_list__subrows_domainaliases' => 'May mga alyas',

    // objects list
    'domains_list__owner__title' => 'May-ari',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Mag-browse ng mga application",
    'site_apps__promo_main_text' => "Ang Application Packaging Standard (APS) catalog ay naglalaman ng listahan ng mga application na maaring ilaan sa isang domain o webspace. Kung gusto mong maglaan ng application na kasalukuyang wala sa catalog, madali mo itong magagawa sa pamamagitan ng pagsunod sa mga panuto ng APS packaging sa www.apsstandard.com",
    'site_apps__promo_download_now' => "Mag-download ng mga Application:",
    'site_apps__promo_close' => "Isara ang block",
    'site_apps__promo_preset__mostused' => '%1 Pinaka Sikat',
    'site_apps__promo_preset__lessused' => 'Susunod %1 Pinaka Sikat',
    'site_apps__promo_preset__all' => "Lahat",
    'site_apps__promo_disclaimer_note' => 'Pakitandaan na ang mga application na naka-install mula sa Katalogo ng APS ay ibinibigay ng mga third party at hindi suportado ng Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Mga APS Application',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Nagdadagdag ng application...',

    // Errors
    'site_apps__no_applications_for_update' => 'Wala kang mga application na naka-install sa Application Vault.',
    'site_apps__incorrect_download_preset_configuration' => 'May mga error na natagpuan sa konpigurasyon ng APS Catalog download preset.',
    'site_apps__aps_catalog_url_is_invalid' => 'Ang tinukoy na URL ay hindi wasto.',
    'site_apps__no_updates_at_the_moment' => 'Walang mga magagamit na pag-update ng application sa ngayon.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Maling impormasyon ang natanggap galing sa APS applications catalog. Mangyaring subukang muli mamaya.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Ang setting ng APS catalog ay naipon na, ngunit ang Plesk ay hindi makagawa ng koneksyon sa tinukoy na APS catalog sa mga setting ng APS catalog (%1). Siguraduhing ang address ng APS catalog ay tumpak at ang APS catalog sa address na ito ay aktibo.',
    'site_apps__cannot_retrieve_updates' => 'Hindi maaring mag-download ng mga update ng mga application sa ngayon: hindi makagawa ng koneksyon sa APS catalog (%1). Siguraduhing ang address ng APS catalog ay tumpak at ang APS catalog sa address na ito ay aktibo.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Walang mga web application na magagamit para sa pag-install.',
    'site_apps__site_applications_already_installed_in_root' => 'Ang ibang mga application ay naka-install na sa root directories ng mga virtual na host na ito',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Ang .NET web application ay hindi suportado sa Unix/Linux na plataporma",
    'site_apps__server_wide_packages_not_supported' => 'Hindi suportado ang server-wide web applications',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 pang web application ang naka iskedyul para sa karagdagan sa Application Vault.",
    'site_apps__applications_all_in_vault' => "Ang mga napiling mga web application ay kasalukuyan nang nasa Application Vault.",
    'site_apps__applications_already_in_download_queue' => "%1 ang napiling web application ang kasalukuyang idinadagdag sa Application Vault.",
    'site_apps__applications_already_in_valut' => "Ang %1 napiling mga web application ay mayroon na sa Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Iba (hindi na-kategorya)',

    // Errors
    'site_apps__no_applications_in_category' => 'Walang makukuhang application sa kategorya na ito. Pumili ng ibang kategorya.',
    'site_apps__no_category_selected__please_specify' => 'Pumili ng kategorya sa kaliwang menu. Lahat ng application na magagamit ng mga napiling kategorya ay mapapasama sa listahan sa window na ito.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Account ng administrator',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Pangkalahatan',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Palitan ang hostname',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Seguridad',
    'bt_setup_firewall' => 'Maglagay ng firewall',
    'bt_manage_firewall_rules' => 'Pamahalaan ang mga patakaran ng firewall',
    'cu_firewall__rule' => 'Lumikha ng patakaran sa firewall',
    'cu_firewall__protocol' => 'Magtakda ng protokol para sa patakaran (\'tcp o \'udp\')',
    'cu_firewall__name' => "Magtakda ng pangalan ng patakaran",
    'cu_firewall__disabled' => 'Kung \'totoo\', ang patakaran ay nakapatay matapos ang paglikha',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Pumili ng DNS server', // PFW
    'bt_soa_records_template' => 'Template ng mga SOA na rekord',
    'bt_restrict_creation_of_subzones' => 'Pagbabawal sa paglikha ng subzones',

    'databases' => 'Mga database',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Mga application',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Mail',
    'bt_select_mailserver' => 'Pumili ng mail server', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Pumili ng antivirus', // PFW
    'bt_virus_protection_settings' => 'Mga setting sa proteksyon sa Virus',
    'bt_select_spamfilter' => 'Pumili ng spam filter', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Pumili ng Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Mga Log & Mga estatistika',
    'bt_server_statistics_settings' => 'Mga setting ng mga estatistika ng server',
    'bt_select_web_statistics' => 'Magagamit na software sa mga estatistika ng web', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interface ng Plesk',

    'components_and_modules' => 'Components & mga modyul',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'Maglagay ng VPN', // PFU
    'bt_setup_samba' => 'Maglagay ng samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'Account ng administrator ng domain',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Mga setting ng account',

    'domain' => 'Domain',
    'bt_dns_soa_records' => 'Mga DNS SOA record',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Mga setting ng Task scheduler',

    'website' => 'Website',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting para sa mga web user',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Pumili ng SSL/TLS certificate',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Mga estatistika ng Web',
    'bt_log_rotation_settings' => 'Mga setting ng log rotation',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Mga limitasyon", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Patakaran sa sobrang paggamit at sobrang pagbenta",
    'limits__overuse_policy_legend' => "Sobrang paggamit",
    'limits__oversell_policy_legend' => "Sobrang pagbenta",
    'limits__reseller_overuse_description' => "Ang patakaran ng sobrang paggamit ang nagsasabi sa Plesk kung ano ang gagawin kapag ang mga resources ay sobrang nagamit.",
    'limits__overuse_text' => "Patakaran sa sobrang paggamit",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Disk space at trapiko',
    'limit__disk_space' => 'Disk space',
    'limit__max_traffic' => 'Trapiko',
    'limit_group__client' => 'Mga kustomer',
    'limit__max_cl' => 'Mga kustomer',
    'limit_group__domain' => 'Mga domain',
    'limit__max_dom' => 'Mga domain',
    'limit__max_dom_powerUser' => 'Mga suskrisyon',
    'limit__max_subdom' => 'Mga subdomain',
    'limit__max_dom_aliases' => 'Mga alyas ng domain',
    'limit__max_wu' => 'Mga user ng Web',
    'limit__max_subftp_users' => 'Karagdagang mga FTP account', // PFW
    'limit_group__mail' => 'Mail',
    'limit__max_box' => 'Mga mailbox',
    'limit__mbox_quota' => 'Laki ng mailbox',
    'limit__total_mboxes_quota' => 'Kabuuang mga mailbox quota', // PFW
    'limit__max_maillists' => 'Listahan ng mailing',
    'limit_group__database' => 'Mga database',
    'limit__max_mssql_db' => 'Mga database ng Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Kabuuang quota ng MS SQL database', // PFW
    'limit__max_odbc' => 'Mga koneksyon ng ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MariaDB/MySQL databases quota', // PFW
    'limit__pgsql_dbase_space' => 'Quota ng mga PostgreSQL database', // PFW
    'limit_group__application' => 'Mga application',
    'limit__max_iis_app_pools' => 'Mga IIS application pool', // PFW
    'limit_group__security' => 'Seguridad',
    'limit_group__validity' => 'Petsa na walang-bisa',
    'limit__expiration' => 'Petsa na walang-bisa',
    'limit__validity' => 'Petsa ng pagkabisa',
    'limit__max_site_builder' => 'Mga inilathalang site gamit ang Presence Builder',
    'limit__max_site' => 'Mga domain',
    'limit__mssql_dbase_filesize' => 'Laki ng file ng database MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Laki ng log file ng database ng MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Ang pinakamalaki na laki ng file ng Microsoft SQL database.',
    'limit__mssql_dbase_log_filesize_hint' => 'Ang pinakamalaki na laki ng file ng talaan ng Microsoft SQL database.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Hindi wastong limitasyon ng mga domain Pinakamababang halaga ay 1.',

    'property__has_wrong_value' => 'Ang katangian na %1 ay may maling halaga.',
    'property__name_outgoing_messages_domain_limit' => 'Itakda ang limitasyon sa palabas na mensahe mula sa domain (kada oras) Upang maitakda ang Unlimited na halaga, tukuyin "-1". Tukuyin ang "default" para maitakda ang halaga na natukoy sa mga setting ng server-wide.',
    'property__name_outgoing_messages_mbox_limit' => 'Itakda ang limitasyon sa palabas na mensahe mula sa mailbox (kada oras) Upang maitakda ang Unlimited na halaga, tukuyin "-1". Tukuyin ang "default" para maitakda ang halaga na natukoy sa mga setting ng server-wide.',
    'property__name_outgoing_messages_subscription_limit' => 'Itakda ang limitasyon sa palabas na mensahe mula sa suskrisyon (kada oras) Upang maitakda ang Unlimited na halaga, tukuyin "-1". Tukuyin ang "default" para maitakda ang halaga na natukoy sa mga setting ng server-wide.',

    // for CLI report & email notifications
    '__resource_notify' => 'Ipagbigay-alam',
    '__general' => 'Pangkalahatan',
    '__template_shared' => 'Nakabahaging template',
    'limit__overuse' => 'Patakaran sa sobrang paggamit',
    'limit__max_traffic_soft' => 'Abisuhan ako kapag naabot na ang paggamit ng trapiko',
    'limit__disk_space_soft' => 'Mag-abiso kung umaabot na ang paggamit ng disk space',
    '__overuse' => 'Patakaran sa sobrang paggamit',
    'performance__title' => 'Pagganap',
    'performance__bandwidth' => 'Pinakamataas na paggamit ng bandwidth (KB/s)',
    'performance__max_connections' => 'Limitadong koneksyon sa',

    'gch__hosting_php_isapi' => 'Paganahin ang PHP bilang extensyon ng ISAPI',
    'gch__hosting_ssi_html' => 'Gamitin ang SSI para sa *.htm, *.html files',
    'gch__hosting_php_handler_type' => 'paganahin ang PHP bilang',
    'gch__hosting_php_handler_id' => 'paganahin ang PHP bilang',
    'gch__hosting_php_served_by_nginx' => 'Ang PHP ay pinapagana ng nginx',
    'gch__hosting_unpaid_website_status' => 'Ang estado ng mga website sa mga supendido na mga suskrisyon',
    'gch__mn_no_autoresponder' => 'Walang na set up na auto-replies para sa mail account.',
    'gch__no_clients_selected' => "Walang napiling account ng kustomer",
    'gch__no_domains_selected' => "Walang napiling mga domain",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/buwan",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Pangalan ng resource',
    '__resource_usage' => 'Ginamit',
    '__resource_limit' => 'Limitasyon',

    '__never_expires' => 'Hindi natatapos',
    '__resource_free' => '%1 libre ng %2',
    '__resource_unlimited' => '%1 ang ginamit nang Walang Limitasyon',

    '__unlimited' => 'Walang-limitasyon',
    '__increment' => "Dagdagan (+)",
    '__decrement' => "Bawasan (-)",
    '__pt' => 'Mga unit',
    '__procent' => '%',
    '__overused' => 'Sobrang ginamit',
    '__left' => 'kaliwa',
    '__available' => 'makukuha',
    '__not_available' => 'Hindi kasama',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Pangalan ng reseller', // reseller report
    'report__full_client_name' => 'Pangalan ng kustomer', // customer report
    'report__full_domain_name' => 'Pangalan ng domain', // domain report
    'report__full_owner' => 'May-ari', // customer & domain reports
    'report__full_creation_date' => 'Petsa na nilikha',
    'report__full_size' => 'Laki',
    'report__full_traffic' => 'Trapiko',
    'report__full_active_clients' => 'Aktibong mga kustomer', // reseller report
    'report__full_clients' => 'Mga kustomer', // reseller report
    'report__full_active_domains' => 'Aktibong mga domain', // reseller & customer reports
    'report__full_domains' => 'Mga domain', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mga Mbox',
    'report__full_disk_space' => 'Disk space',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MariaDB/MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'Pangkalahatan',
    'report__version' => 'Bersyon ng produkto',
    'report__build' => 'Build ng produkto',
    'report__status' => 'Estado',
    'report__company_name' => 'Pangalan ng kompanya',
    'report__personal_name' => 'Personal na pangalan',
    'report__login' => 'Username',
    'report__phone' => 'Telepono',
    'report__fax' => 'Fax',
    'report__email' => 'Email',
    'report__address' => 'Tirahan',
    'report__city' => 'Lungsod',
    'report__state' => 'Estado/probinsya',
    'report__zip_code' => 'Postal/ZIP code',
    'report__country' => 'Bansa',
    'report__creation_date' => 'Petsa na nilikha',
    'report__expiration_date' => 'Petsa na walang-bisa',
    'report__dumps_total_size' => 'Kabuuang sukat ng backup files',
    'report__section_resellers' => 'Mga Reseller',
    'report__active_resellers' => 'Mga reseller na merong aktibong suskrisyon',
    'report__resellers' => 'Mga Reseller',
    'report__section_full_resellers' => 'Mga Reseller',
    'report__section_clients' => 'Mga kustomer',
    'report__active_clients' => 'Mga kustomer na merong aktibong suskrisyon',
    'report__clients' => 'Mga kustomer',
    'report__section_full_clients' => 'Mga kustomer',
    'report__section_personal_clients' => 'Sariling mga kustomer',
    'report__active_personal_clients' => 'Iyong sariling mga kustomer na may aktibong mga suskrisyon',
    'report__personal_clients' => 'Sariling mga kustomer',
    'report__section_full_personal_clients' => 'Sariling mga kustomer',
    'report__section_domains' => 'Mga domain',
    'report__disk_usage' => 'Paggamit ng disk',
    'report__traffic' => 'Trapiko',
    'report__active_domains' => 'Aktibong mga domain',
    'report__domains' => 'Mga domain',
    'report__subdomains' => 'Mga subdomain',
    'report__mboxes' => 'Mga mailbox',
    'report__mail_groups' => 'Mga pagpapasa ng mail',
    'report__mail_autoresp' => 'Mga Auto-reply',
    'report__mail_lists' => 'Listahan ng mailing',
    'report__web_users' => 'Mga user ng Web',
    'report__mysql_databases' => 'MariaDB/MySQL database',
    'report__mssql_databases' => 'Mga MSSQL database',
    'report__pgsql_databases' => 'Mga PostgreSQL database',
    'report__section_full_domains' => 'Mga domain',
    'report__section_personal_domains' => 'Personal na mga domain',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Personal na mga domain',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Mga inilathalang site gamit ang Presence Builder',
    'report__invalid_email' => 'Tukuyin ang isang wastong email address.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Mga web user',
    'report__section_mailnames' => 'Mga Mail Account',
    'report__section_maillists' => 'Mga Mailing List',
    'report__section_databases' => 'Mga database',
    'report__section_siteapps' => 'Mga Web application',
    'report__section_aspnetapps' => 'Mga application ng ASP.NET', // PFW
    'report__owner_pname' => "Personal na pangalan ng provider",
    'report__owner_login' => "Username ng provider",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Ang tinukoy na language pack ay naka-install ngunit hindi nakabukas sa system.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'Nag-expire ang token ng session.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Ang mga sumusunod na account ng reseller ang iko-konbert sa account ng kustomer.',
    'downgradeResellers__downgrade' => 'Isasalin ang mga account ng reseller',
    // controls
    'downgradeResellers__submit_downgrade' => 'Isagawa ang pagsasalin ng account.',
    'downgradeResellers__cancel_downgrade' => 'Kanselahin ang pagsalin ng account.',
    'downgradeResellers__confirm' => 'Kumpirmahin ang pagsalin',
    'downgradeResellers__confirm_message' => 'Kumpirmahin ang pagsalin ng account para magpatuloy',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'Ang mga sumusunod na account ng kustomer ay isalin sa mga account ng reseller.',
    'upgradeClients__upgrade' => 'Isasalin ang mga account ng kustomer',
    // controls
    'upgradeClients__submit_upgrade' => 'Isagawa ang pagsasalin ng account.',
    'upgradeClients__cancel_upgrade' => 'Kanselahin ang pagsalin ng account.',
    'upgradeClients__confirm' => 'Kumpirmahin ang pagsalin',
    'upgradeClients__confirm_message' => 'Kumpirmahin ang pagsalin ng account para magpatuloy',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Hindi maisalin ang account na \'%1\' sa account ng reseller: \'%1\' ay reseller na.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Ang mga sumusunod na mga account ng administrator ng domain ay isasalin sa account ng mga kustomer:',
    'upgradeDomainUser__upgrade' => 'Ang account ng administrator ng domain ay isasalin.',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Isagawa ang pagsasalin ng account.',
    'upgradeDomainUser__cancel_upgrade' => 'Kanselahin ang pagsalin ng account.',
    'upgradeDomainUser__confirm' => 'Kumpirmahin ang pagsalin',
    'upgradeDomainUser__confirm_message' => 'Kumpirmahin ang pagsalin ng account para magpatuloy',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Ang account ng administrator ng domain ay hindi maisalin.',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Ang mga sumusunod na mga account ng administrator ng domain ay hindi maaring magsalin sa account ng kustomer:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Ang iba sa mga account ng administrator ng domain ay hindi maaring magsalin sa account ng kustomer: %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Ang account ng administrator ng domain ay hindi-umiiral.',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Ang domain ay dapat direktang galing sa administrador ng server o reseller.",
    'upgradeDomainUser__all_logins_already_used' => 'Hindi makagawa ng account para sa resulting na kustomer.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Ang account ng administrator ng domain ay naisalin na.',
    'upgradeDomainUser__upgrade_notification_body' => 'Ang account ng administrator ng domain ay isasalin sa account ng kustomer na may username na \'%%login%%\' at password na \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Ang mga napiling reseller ay walang pahintulot na \'%1\', ngunit ang ibang kustomer ay mayroong pahintulot na ito.',
    'clientOwnerChanger__application_not_allowed' => 'Hindi magagamit ang application \'%1\' ng napiling reseller, ngunit magagamit ito ng ibang mga kustomer.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Pinakamataas na paggamit ng bandwidth (%1)',
    'hosting_performance__max_connection_label' => 'Limitadong koneksyon sa',
    'performance__invalid_value' => "Ang halaga ay hindi wasto. Dapat ay nasa hanay mula sa %1 hanggang %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Mga magagamit na mga kliyente ng webmail',
    'webmail__none' => 'Wala',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'IP pool ng server',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Backup ng server.",
    '__default_backup_comment_reseller' => "Nagawa na ang backup account ng reseller ng %1.",
    '__default_backup_comment_client' => "Nagawa na ang backup account ng kustomer ng %1.",
    '__default_backup_comment_domain' => "Nagawa na ang backup suskrisyon ng %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "IP pool ng kustomer %1",
    'backup__ip_mapping__resellers_ip' => "IP pool ng reseller %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtual na host',
    'backup__restore__object_plesk_admin' => 'Administrador ng plesk',
    'backup__restore__object_ftpuser' => 'Account ng FTP',
    'backup__restore__object_frontpageuser' => 'Account ng frontpage',
    'backup__restore__object_webuser' => 'web user',
    'backup__restore__object_domain' => 'domain',
    'backup__restore__object_subdomain' => 'subdomain',
    'backup__restore__object_domainalias' => 'domain alias',
    'backup__restore__object_client' => 'kustomer',
    'backup__restore__object_reseller' => 'reseller',
    'backup__restore__object_autoresponder' => 'auto-reply',
    'backup__restore__object_mailalias' => 'mail alias',
    'backup__restore__object_database' => 'database',
    'backup__restore__object_mailname' => 'mail account',
    'backup__restore__object_db_user' => 'user ng database',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS certificate',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Ang mga sumusunod na mga reseller ay hindi maaaring ma-restore dahil sila ay napalitan bilang mga kustomer: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Ang mga sumusunod na mga kustomer ay hindi maaaring ma-restore dahil sila ay napalitan bilang mga reseller: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Ang mga sumusunod na mga kustomer ay hindi maaaring ma-restore dahil sila ay ilinipat sa ibang may-ari: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Kulang na disk space sa destination server para magawa ang pag-transfer ng lahat ng napiling suskrisyon. Magagamit: %1 MB. Kailangan: %2 MB. Tandaan na ang kailangang espasyo ay kalkulado bilang kabuuan ng web, mail, at nilalaman ng database ng domain. Ang kailangang espasyo ay kalkulado minsan sa isang araw at i-imbak sa cache, para ang aktwal na sukat ng domain ay maiba sa kalkuladong sukat. Kapag ang mga napiling domain ay nasiguro na hindi umuukopa nang mas maraming espasyo kaysa sa magagamit, maari ka nang magpatuloy sa pag-transfer.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Maglaan ng disk space sa destination server.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Hindi sapat ang disk space na nasa source server upang makapag-imbak ng mga temporary files para sa pag-transfer. Magagamit: %1 MB. Kailangan: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Maglaan ng disk space sa source server.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Impormasyon sa server',

    'backup__restore__capability_not_installed_component_text' => 'Ang bahagi na %1 ay hindi naka-instal sa destination server. %1 ang hindi magagamit para sa lahat ng naibalik na gamit.',
    'backup__restore__capability_not_installed_component_resolution' => 'I-install ang %1. Tandaang ito ay maaaring tumagal ng mga ilang minuto.',
    'backup__restore__capability_existing_sys_user_text' => 'Ang user ng system na may pangalan na %1 ay kasalukuyang umiiral sa destination server.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Baguhin ang pangalan ng kasalukuyang user ng system sa destination server.',
    'backup__restore__capability_license_usage_text' => 'Ang mga sumusunod na limitasyon ng resource (tinukoy ng license key) ay humigit sa destination server pagkatapos ng pag-transfer ng datos:',
    'backup__restore__capability_license_usage_resolution' => 'I-install ang isa pang license key sa destination server na magbibigay ng mga kinakailangan dami ng mga resources.',
    'backup__restore__capability_max_allowed_packet_text' => "Ang 'max_allowed_packet' parameter sa source database server ay %1, na mas malaki sa destination server, kung saan ito ay %2. Ang ibang mga bagay sa database para sa domain na tinutukoy sa ibaba ay maaaring hindi na maibalik.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Dagdagan ang halaga na 'max_allowed_packet' sa destination database server.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Hindi magawa ang pag-transfer ng mga PostgreSQL database dahil ang bersyon ng PostgreSQL sa destination server ay mas luma sa source server. Ang kasalukuyang bersyon ay %1, ang kailangang bersyon ay %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'I-install ang kailangang bersyon ng PostgreSQL sa destination server.',
    'backup__restore__capability_db_server_connection_problems' => 'Hindi maka-konekta sa destinasyon ng PostgreSQL database server. Ang mga databases ay hindi maililipat hanggang mai-restore ang koneksyon.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Paki-tignan ang mga koneksyon ng setting sa destinasyon ng database server.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Nakapatay ang component %1 sa destination server.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Buksan %1 sa destination server.',
    'backup__restore__capability_not_configured_component_text' => 'Hindi nakonpigura ang component %1 destination server.',
    'backup__restore__capability_not_configured_component_resolution' => 'Konpigurahin %1 sa Tools & Settings na pahina.',

    'backup__restore__capability_webmail_is_not_available' => 'Ang %1 webmail service ay hindi makita sa destination server. Sa halip, gagamitin ng Plesk ang sumusunod na serbisyo ng webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Para magamit ang parehong webmail na nasa source server, kailangan mong i-install ito sa server na ito.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Para magamit ang parehong webmail na nasa source server, kailangan mong i-install ito sa destination server.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Ang '%1' na webmail ay hindi makita sa destination server. Sa halip, sa mga sumusunod na mga suskrisyon: %3, gagamitin ng Plesk ang sumusunod na serbisyo ng webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'I-install ang kailangang webmail sa destination server.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Mga setting ng Webmail',

    'backup__restore__capability_shell_is_not_available' => 'Ang shell %1 ay hindi makita sa destination server. Sa halip, isa sa mga magagamit na mga shell ang gagamitin.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Para magamit ang parehong shell na nasa source server, kailangan mong buksan (in/etc/shells) o i-install ito sa destination server.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Hindi suportado ang mga network ng destination DNS server sa Transfer Restrictions Template. Hindi itatago ang mga tala na may network na IP addresses sa DNS transfer restrictions.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Hindi suportado ng destination DNS server ang mga network sa Transfer Restrictions Template, ngunit mayroong ibang suskrisyon na may network sa mga DNS transfer restriction. Hindi itatago ang mga tala na may network na IP addresses sa DNS transfer restrictions.',

    'backup__restore__capability_wrong_php_handler_text' => 'Ang PHP handler %1 ay hindi makita sa destination server. Sa halip, gagamitin ng Plesk ang sumusunod na PHP handler: %2.',
    'backup__restore__capability_no_php_handler_text' => 'The PHP handler %1 is unavailable on the destination server.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Para magamit ang parehong PHP handler na nasa source server, kailangan mong buksan o i-install ito sa destination server.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Hindi available ang handler ng PHP na %1. Sa halip, gagamitin ng Plesk ang %2 para sa mga sumusunod na plano ng serbisyo: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Hindi available ang handler ng PHP na %1. Sa halip, gagamitin ng Plesk ang %2 para sa mga sumusunod na website: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Hindi available ang handler ng PHP na %1. Hindi ito magiging available para sa mga sumusunod na website: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'Ang %1 %2 ay hindi makita sa destination server. SA halip, gagamitin na lang ang bersyon na default.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Para magamit ang parehong %1 na nasa source server, kailangan mong buksan o i-install ito sa destination server.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Ang patakaran sa paggamit ng antivirus sa destination server ay hindi nagpapahintulot sa personal (kada email address) na mga setting sa antivirus para sa papalabas na mail. Hindi maililipat ang mga setting na ito.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Ang patakaran sa paggamit ng antivirus sa destination server ay hindi nagpapahintulot sa personal (kada email address) na mga setting sa antivirus para sa paparating na mail. Hindi maililipat ang mga setting na ito.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Ang patakaran sa paggamit ng antivirus sa destination server ay hindi nagpapahintulot sa personal (kada email address) na mga setting sa antivirus. Hindi maililipat ang mga setting na ito.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Upang magawa ang pag-transfer ng personal (kada email address) na setting sa antivirus, buksan ang mga tugmang opyson sa Tools & Settings > Virus Protection Settings.",
    'backup__restore__capability_antivirus_not_active_text' => 'Walang nakabukas na software ng antivirus. Hindi gagana lahat ng mga setting ng antivirus sa source server hanggang pinili mo ang software ng antivirus sa destination server.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Pumili ng software ng antivirus sa Tools & Mga setting > Virus Protection Settings > seksyon ng Antivirus setting.',

    'backup__restore__capability_antivirus_another_active_text' => 'Ang software ng antivirus %2 ay hindi makita sa destination server. sa halip ay %1 ang gagamitin.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Para magamit ang kaparehong antivirus sa source server, i-install ito at piliin ito sa mga Tools & Settings > Virus Protection Settings > seksyon ng Antivirus settings.',
    'backup__restore__capability_not_available_sni_text' => 'Hindi available ang SNI sa patutunguhang server. Hindi makakagamit ang mga website na may iisang IP address ng mga indibidwal na SSL/TLS certificate.',
    'backup__restore__capability_not_available_sni_resolution' => "Pakitingnan kung sinusuportahan ng operating system sa patutunguhang server ang SNI at kung naka-on ang suporta para sa SNI sa Plesk (ang checkbox na 'I-on ang suporta sa SNI, na nagbibigay-daan sa paggamit ng mga indibidwal na SSL/TLS certificate sa mga website na may iisang IP address' sa Mga Tool at Setting > Mga Setting ng Server).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Mga setting sa server',

    'backup__restore__capability_vhost_already_exists_text' => 'Hindi magawa ang pag-transfer ng website na %1: ang website na may kaparehong pangalan ay kasalukuyang umiiral sa destination server.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Palitan ang pangalan o alisin ang website na may kaparehong pangalan mula sa server.',
    'backup__restore__capability_removed_vhosts' => 'Ang mga sumusunod na suskrisyon ay hindi maiimbak dahil sila ay naglalaman ng domain names na dati nang umiiral sa destination server. %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Sa source server mayroong %3 na ibat-ibang klase ng PHP handlers %1 at bersyon %2. Sa halip, isang handler ng akma na klase at bersyon ang magagamit ng destination server.  Tandaang ang mga setting ng PHP sa source at destination server ay maaring magkaiba.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Hindi sinusuportahan ng Plesk Installer ang Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Hindi sinusuportahan ng Plesk Installer ang Python. Manwal na i-instal ang Pyhton.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Mga setting sa mail server',

    'backup__restore__capability_ftps_disabled' => 'Pinahihintulutan ang paggamit ng ligtas na FTPS sa source server subalit ipinagbabawal sa target. Maaaring hindi maaayos na gumana ang user apps na gumagamit ng FTP.',
    'backup__restore__capability_ftps_required' => 'Pinahihintulutan ang paggamit ng hindi-ligtas na FTP sa source server subalit ipinagbabawal sa target. Maaaring hindi maaayos na gumana ang user apps na gumagamit ng FTP.',
    'backup__restore__capability_ftps_policy_resolution' => 'Palitan ang patakaran ng Secure FTP sa Tools & Settings > Security Policy.',

    'backup__restore__capability_too_much_download_time_text' => 'Ililipat ang %1 megabytes na mga datos mula sa source server patungo sa destinasyon sa loob ng %2 na oras.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Para sa mas mabilis na pag-transfer, tingnan ang koneksyon ng network sa pagitan ng source at destination servers at resolbahin ang mga isyu (kung mayroon).',
    'backup__restore__too_low_download_speed' => "mababa sa 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Para sa mas mabilis na pag-transfer, tingnan ang koneksyon ng network sa pagitan ng source at destination servers at resolbahin ang mga isyu (kung mayroon).',
    'backup__restore__capability_zero_download_speed_text' => 'Ang pinakamababang katanggap-tanggap na bilis sa pag-download ay %1 MBps. Ang bilis ng pag-download sa pagitan ng source at destination servers ay 0 MBps. Ito ay maaaring dulot ng mga isyu sa koneksyon ng network. Hindi maaari ang pag-transfer.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Tingnan ang koneksyon ng network sa pagitan ng source at destination servers at resolbahin ang mga isyu.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Ang pinakamababang katanggap-tanggap na bilis sa pag-download ay %2MBps. Ang bilis ng pag-download sa pagitan ng source at destination server ay %1MBps. Ito ay maaring makadagdag sa oras ng pag-transfer. Sa iyong kasalukuyang environment, ang paglilipat ng %3 MB ay umaabot ng %4 na oras.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Ang pinakamababang katanggap-tanggap na bilis sa pag-download ay %2MBps. Ang bilis ng pag-download sa pagitan ng source at destination server ay %1MBps. Ito ay maaring makadagdag sa oras ng pag-transfer.',

    'backup__restore__capability_remote_database_migration' => "Ang mga sumusunod na domains ay gumagamit ng mga remote database: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Huwag alisin ang mga domain na ito mula sa source server matapos ang pagsasagawa ng pag-transfer kung ang bersyon ng Plesk sa source server ay mas luma 11.5! Sa halip, suspindihin sila. Kung tinanggal mo ang mga domain, matatanggal ang mga database sa remote server. Tandaan: Ang dump files ng mga remote database ay maiimbak sa source server sa %1 na direktoryo.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Ang backup files ng mga MySQL database server na mas luma sa 5.1(%1) ay maaaring hindi na mai-restore sa MySQL 5.1.x dahil ang MySQL 5.1.x ay ang iba ang paggamit ng mga karakter na Unicode.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Basahin ang mga kaugnay na kaalaman ayon sa artikulo #136850',

    'backup__restore__capability_courier_not_installed_text' => 'Hindi naka-install ang Courier-IMAP sa destination server.',
    'backup__restore__capability_courier_not_installed_resolution' => 'I-instal ang Courier-IMAP gamit ang Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Hindi naka-install ang Dovecot sa destination server.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'I-instal ang Dovecot gamit ang Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Ang oras ng retensiyon sa mga estatistika ng trapiko sa konpigurasyon ng mga sumusunod na mga object ay mas mababa kaysa sa halaga ng server-wide sa destination server.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Palitan ang marka ng server-wide para sa oras sa retention ng mga estatistika sa destination server. Itakda ang oras na ito kapantay o mas mababa sa pinakamaliit na halaga sa mga konpigurasyon ng domain.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Ang oras sa paghawak ng mga estatistika sa trapiko sa ilang mga domain ay mas kaunti kaysa sa marka ng server-wide (%1). Papalitan ang marka ng %1 para sa mga domain na ito.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Ang oras para sa pagtago ng mga estatistika sa trapiko sa ilang mga plano ng serbisyo ay mas kaunti kaysa sa halaga ng server-wide (%1). Papalitan ang marka ng %1 para sa mga plano ng serbisyo na ito.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Ang mapping ng isang eksklusibong IP address sa isang shared na isa ay hindi mapapagana sa hindi kilalang FTP at HTTP (maliban kung bukas ang suporta na SNI)',

    'backup__restore__no_postgresql_commands_text' => 'Gumagamit ang suskrisyon ng remote PostgreSQL database, at ang pansamantalang backup file nito ay hindi mapagana dahil ang pg_dump at psql na mga command ay nawawala sa source server.',
    'backup__restore__no_postgresql_commands_resolution' => 'Mag-install ng anumang pakete ng kliyente sa PostgreSQL na sumusuporta ng mga command na ito.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Ang mga sumusunod na modyul ng Apache ay hindi pinapagana sa destination server: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Paganahin ang mga modyul na ito para maiwasan ang mga posibleng problema.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Ang mga sumusunod na modyul ng Apache ay hindi naka-install sa destination server: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'I-install at paganahin ang mga modyul na ito para maiwasan ang mga posibleng problema.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Ang limitasyon ng mga palabas na mensahe ay hindi suportado ng iyong lisensya. Ang mga katugmang konpigurasyon sa setting na ito ay hindi malilipat.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'I-install ang isa pang license key sa destination server na nagbibigay ng mga kinakailangan na katangian.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Nakapatay ang limitasyon ng mga papalabas na mga mensahe sa destination server. Ang mga katugmang konpigurasyon sa setting na ito ay hindi malilipat.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Paganahin ang limitasyon ng mga papalabas na mga mensahe sa destination server.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Mga Setting sa Server-Wide Mail',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Ang limitasyon ng mga palabas na mensahe na galing sa mailbox ay hindi suportado ng mail server na ginagamit sa destination server. Ang halaga ng limitasyon na ito ay hindi ililipat.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Palitan ang mail server na kapareho ng iyong ginagamit sa source server.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Mga Setting sa Server-Wide Mail',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Ang limitasyon ng mga palabas na mensahe na galing sa domain ay hindi suportado ng mail server na ginagamit sa destination server. Ang halaga ng limitasyon na ito ay hindi ililipat.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Palitan ang mail server na kapareho ng iyong ginagamit sa source server.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Mga Setting sa Server-Wide Mail',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Ang limitasyon ng mga palabas na mensahe na galing sa suskrisyon ay hindi suportado ng mail server na ginagamit sa destination server. Ang halaga ng limitasyon na ito ay hindi ililipat.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Palitan ang mail server na kapareho ng iyong ginagamit sa source server.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Mga Setting sa Server-Wide Mail',

    'bu_conflict_resolver_absent_phosting' => 'Hindi ma-restore ang tinukoy na mga file dahil ang physical hosting para sa pag-restore sa kanila ay hindi umiiral. Unahin muna ang paggawa ng domain na may physical hosting at matapos ay simulan muli ang restoration ng backup.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Hindi ibabalik ang data ng mga reseller dahil hindi sinusuportahan ang pamamahala ng mga reseller.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Ang component ng ModSecurity ay hindi naka-install sa destination server.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'I-install ang ModSecurity para mapanatiling gumagana ang web application na firewall para sa mga na-transfer na mga site. Tandaan na sa pag-install maaaring tumagal ito nang ilang minuto.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Mag-install ng ModSecurity kung gusto mo gawin ang pag-transfer ng mga setting ng web application na firewall. Tandaan na sa pag-install maaaring tumagal ito nang ilang minuto.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Ang ModSecurity component ay hindi na-konpigura sa destination server.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konpigurahin ang ModSecurity kung nais mong panatilihing gumagana ang web application na firewall para sa mga na-transfer na mga site.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Web Application na Firewall (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'Nakapatay ang ModSecurity sa destination server.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Paganahin ang ModSecurity kung gusto mong panatilihing gumagana ang web application na firewall para sa mga na-transfer na mga site.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Web Application na Firewall (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Ang ModSecurity component ay hindi naka-install. Hindi ma-restore ang mga setting ng web application na firewall sa mga sumusunod na mga object: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Hindi ma-restore ang mga website dahil sila ay kabilang sa suskrisyon %1 na hindi nakikita sa Plesk:",
    'backup__restore__capability_not_installed_dns_text' => 'Hindi naka-install ang component %1 sa destination server. Hindi magagamit ang serbisyo ng DNS at mawawala ang mga setting ng DNS. Hindi magagamit ang lahat ng mga website ng kustomer.',
    'bu_conflict_resolver_dns_not_installed' => 'Ang DNS service ay hindi na-install. Hindi ma-restore ang mga DNS setting para sa mga sumusunod na mga objects: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Ang mga sumusunod na mga suskrisyon ay hindi maaaring ma-restore dahil sila ay nailipat sa ibang mga may-ari: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Ang mga sumusunod na mga suskrisyon ay hindi maaaring ma-restore dahil sila ay nailipat sa ibang mga provider: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Hindi mahanap ang kagamitan sa pagpapanumbalik ng Web Presence Builder upang maibalik ang mga datos sa Web Presence Builder. Ang Web Presence Builder ay maaaring hindi naka-install.',
    'backup__restore__capability_renamed_db' => 'Ang database name na "%1" ay ginagamit na ng isang suskrisyon. Ang pangalan ng naibalik na database ay papalitan ng "%2".',
    'backup__restore__capability_renamed_db_user' => 'Ang user database name na "%1" ay ginagamit na ng isang suskrisyon. Ang pangalan ng naibalik na user ng database ay pinalitan sa "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Hindi sinusuportahan ng Plesk Installer ang Perl. Manwal na i-instal ang ActiveState Perl.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% pinapagana ng Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% pinapagana ng nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Salungat na Paggamit ng Resource',
    'backup__restore__hint_resource_usage_conflicts' => 'Nangyayari ang mga salungat sa resource usage kapag ang limitasyon sa paggamit ng resource ng naibalik na object ay sumobra matapos ang restoration.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Hayaang ang sobrang paggamit',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'I-restore ang mga object at hayaan ito na gumamit ng maraming mga resource kaysa sa unang inilaan.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Huwag i-restore',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Huwag i-restore ang mga object na mayroong salungat na resource usage.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Mga Salungat sa Konpigurasyon',
    'backup__restore__hint_configuration_conflicts' => 'Nangyayari ang mga salungat sa konpigurasyon kapag ang nai-restore na object ay may mga setting at mga web application na hindi magamit o ipinagbabawal ng kasalukuyang server o patakaran sa may-ari ng object. Halimbawa, ang mga salungat sa konpigurasyon ay maaring mangyari kapag ang na-restore na mga mail account ay may mga indibidwal setting sa pag-filter sa spam habang ang kasalukuyang patakaran sa server-wide ay ipinagbabawal ang mga mail accounts na magkaroon ng mga ganitong setting.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Awtomatiko',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'I-restore ang object at awtomatikong buksan ang lahat ng mga salungat na opsyon sa konpigurasyon na hinahayaan ng iyong pahintulot na pangasiwaan.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Huwag i-restore',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Huwag i-restore ang mga object na mayroong salungat na konpigurasyon.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Ang mga dedikadong mga IIS application pool ay hindi maaari sa mga setting sa IIS application pool.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Baguhin ang iyong mga setting sa IIS application pool sa Tools & Settings > IIS Application Pool> Global Settings.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Ang shared na mga IIS application pool ay hindi pinahihintulutan sa mga setting ng IIS application pool.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Baguhin ang iyong mga setting sa IIS application pool sa Tools & Settings > IIS Application Pool> Global Settings.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Hindi pinahihintulutan ang mga maikling pangalan ng mail account na POP3/IMAP sa destination server.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Hindi magagamit ang mga maikling pangalan para sa mga mail account matapos ang restoration ng datos.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Hindi nagawang buksan ang log file.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Hindi ma-restore ang mga suskrisyon na %1: ito ay inalis mula sa iyong account at wala kang pahintulot upang lumikha ng mga suskrisyon. Kung kailangan mong ibalik ito, mangyaring makipag-ugnay sa iyong service provider.',

    'backup__error11' => 'Hindi sapat na disk space para sa backup.',
    'backup__error3011' => 'Hindi pinayagan ang koneksyon: Walang nakikinig na programa sa tinukoy na address at port.',
    'backup__error3012' => 'Nag timeout ang koneksyon.',
    'backup__error3013' => 'Hindi ma-abot ang network.',
    'backup__error3014' => 'Walang daan tungo sa host.',
    'backup__error3015' => 'Nabigo ang koneksyon.',
    'backup__error3016' => 'Hindi maresolba ang host name.',
    'backup__error3017' => 'Maling user name o password.',
    'backup__error3018' => 'Hindi matagumpay ang pagkonekta ng SHH.',

    'backup__error3110' => 'Hindi makakonekta sa remote migration agent: Hindi makakonekta sa host.',
    'backup__error3111' => 'Nakasarado ang ahente ng paglilipat dahil sa nabigo ang gawain ng paglilipat o maaring ito ay ginagamit ng iba pang proseso ng paglilipat. Simulan muli na patakbuhin ang ahente ng paglilipat sa source server.',
    'backup__error3112' => 'Ang koneksyon sa host ay hindi pa magagamit o ang ahente ng paglilipat ay hindi gumagana sa source host.',
    'backup__error3113' => 'Hindi maipatupad ang ahente ng paglilipat sa Linux host. Tingnan ang koneksyon ng SSH sa source host.',
    'backup__error3114' => 'Hindi maipatupad ang ahente ng paglilipat sa Linux host: Hindi matagumpay ang pagkonekta ng SHH.',
    'backup__error3115' => 'Maling user name o password.',
    'backup__error3116' => 'Ang tinukoy na user ay walang mga pribilehiyong administratibo.',

    'dns_t__unable_to_remove_ns_record' => 'Hindi maalis ang NS na tala mula sa template ng DNS: Ang bawat isang DNS zone ay dapat mayroong kahit isang NS record.',
    'dns__unsupported_server_zone_transfer' => 'Hindi maaring gumawa ng pag-tansfer ng Transfer Restriction Template dahil sa konpigurasyon sa server-wide ng DNS: Maaari sa source server ang mga sumusunod na mga address ng network para sa pag-transfer ng zone, ngunit ang mga address na ito ay pinagbabawal ng Microsoft DNS Server. %1',
    'dns__unsupported_domain_zone_transfer' => 'Hindi maaring gumawa ng pag-transfer ng Transfer Restriction Template dahil sa konpigurasyon ng domain ng DNS: Maaari sa ibang domain ang mga sumusunod na mga address ng network para sa pag-transfer ng zone, ngunit ang mga address na ito ay ipinagbabawal ng Microsoft DNS Server. %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Hindi magawa ang pag-access sa direktoryo ng shared temporary network para sa mga backup file. Tingnan ang direktoryo ng network, username, at mga setting ng password. Error: %1',

    'dbbackup__temp_dir_wrong_value' => 'Ang hindi wasto na marka para pansamantalang direktoryo ay natukoy.',
    'dbbackup__network_temp_dir_wrong_value' => 'Ang hindi wasto na marka para pansamantalang direktoryo na network ay natukoy.',
    'dbbackup__server_backup_not_configured' => 'Ang settings ng database backup ay hindi nakonpigura sa server.',
    'dbbackup__temp_dir' => 'Pansamantalang direktoryo',
    'dbbackup__temp_dir_hint' => 'Ang daan sa isang pisikal na folder sa remote na server kung saan ang MS SQL server ay matatagpuan. Dapat magagawang i-access ng MS SQL server ang folder na ito para sa pagbabasa at pagsusulat ng pansamantalang backup na mga file. Halimbawa, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Ang daan sa bahagi ng network na nakamapa sa pisikal na folder na tinukoy sa itaas. Ia-access ng Plesk ang nakabahaging folder upang i-download at i-upload ang backup na mga file. Halimbawa, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Ang username ng isang user sa network na nalikha sa remote na server. Halimbawa, ServerName \\ username. Ang user ay dapat magkaroon ng pag-access sa nakabahaging folder na tinukoy sa itaas.',
    'dbbackup__network_password_hint' => 'Ang password ng user ng network',

    'dbbackup__success_import_without_dublicate_users' => 'Hindi na-import ang sumusunod na mga user: %1. Sila ay umiiral sa server ng ??database.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "I-compress ang mga log file",
    'log_rot__log_rot_status' => "Estado ng log rotation",
    'log_rot__log_rot_period' => "Kondisyon sa Log rotation",
    'log_rot__log_rot_size' => "gamit ang laki",
    'log_rot__log_rot_time' => "gamit ang oras",
    'log_rot__logrotation_enable' => "Buksan ang log rotation",
    'log_rot__mail' => "Ipadala ang mga naprosesong log file sa email",
    'log_rot__max_number_of_logfiles' => "Pinakamataas na bilang ng mga log file",
    'log_rot__time_period' => "yugto",
    'log_rot__unable_turn_off' => 'Hindi ma-off ang rotation ng log dahil sapilitan itong ipinapatupad sa antas ng server',
    'log_rot__unable_set_period' => 'Hindi makapagtakda ng panahon ng rotation ng log na iba sa \'daily\', dahil sapilitan itong ipinapatupad sa antas ng server',
    'log_rot__unable_set_max_log_files' => 'Hindi makapagtakda ng pinakamaraming bilang ng mga log file na lampas sa limitasyon ng buong server %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Ang inaasahang bilang: %1",
    'actionlog__incorrect_rotation' => "Natukoy ang hindi wastong log rotation parameter: %1",
    'actionlog__unknown_rot_period' => "Hindi kilalang rotation period: %1",
    'actionlog__unknown_rot_type' => "Hindi kilalang rotation type: %1",
    'actionlog__session_preferences' => 'Mga setting sa session',
    'actionlog__nis2_delete_prohibited' => 'Ipinagbabawal ang pag-aalis ng mga record ng log dahil sa mga nakatakdang paghihigpit ng direktiba sa NIS2.',
    'actionlog__nis2_forbidden_rot_type' => "Hindi magagamit ang uri ng rotation ng log na '%1' dahil sa mga nakatakdang paghihigpit ng direktiba sa NIS2.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Impormasyon ng administrador',
    'actionlog__admin_preferences' => "Mga kagustuhan ng administrator",
    'actionlog__service' => 'Serbisyo',
    'actionlog__ip_addr' => 'IP address',
    'actionlog__client' => 'Account ng kustomer',
    'actionlog__client_status' => 'Estado ng account ng kustomer',
    'actionlog__client_preferences' => "Mga pag-nais na interface ng kustomer",
    'actionlog__client_ip_pool' => "IP pool ng kustomer",
    'actionlog__client_siteapp' => "Web application pool ng kustomer",
    'actionlog__client_guid' => "GUID ng kustomer",
    'actionlog__domain' => 'Default na domain (ang unang domain na naidagdag sa subscription)',
    'actionlog__domain_owner' => 'May-ari ng suskrisyon',
    'actionlog__domain_plan' => 'Plano ng serbisyo ng suskripsyon',
    'actionlog__domain_status' => 'Default domain, estado',
    'actionlog__domain_dns' => 'Default na domain, DNS zone',
    'actionlog__subdomain' => 'Subdomain ng isang default domain',
    'actionlog__domain_alias' => 'Default domain, alyas',
    'actionlog__domain_alias_dns' => 'Default domain, alyas DNS zone',
    'actionlog__site' => 'Domain',
    'actionlog__site_status' => 'Estado ng domain',
    'actionlog__site_dns' => 'Domain DNS zone',
    'actionlog__site_guid' => 'Domain GUID',
    'actionlog__site_subdomain' => 'Subdomain',
    'actionlog__site_alias' => 'Domain alias',
    'actionlog__site_alias_dns' => 'Domain alias DNS zone',
    'actionlog__domain_limits' => 'Limitasyon ng suskrisyon',
    'actionlog__domain_limit_size' => 'Limitasyon ng disk space para sa suskrisyon',
    'actionlog__domain_limit_traffic' => 'Limitasyon ng trapiko para sa suskrisyon',
    'actionlog__domain_limits_powerUser' => 'Mga limitasyon ng subscription',
    'actionlog__domain_limit_size_powerUser' => 'Limitasyon ng disk space para sa subscription',
    'actionlog__domain_limit_traffic_powerUser' => 'Limitasyon ng trapiko para sa subscription',
    'actionlog__domain_guid' => "Default na domain, GUID",
    'actionlog__cp_user' => 'User ng Plesk',
    'actionlog__mailname' => 'Mail account',
    'actionlog__maillist' => 'Mailing list',
    'actionlog__phosting' => 'Mga setting ng Hosting',
    'actionlog__forwarding' => 'standard o frame forwarding hosting',
    'actionlog__webuser' => 'Account ng web user',
    'actionlog__site_application' => 'Web application',
    'actionlog__license' => 'Lisensya ng susi',
    'actionlog__additional_license' => 'Karagdagang license key',
    'actionlog__template_domain' => "Plano ng serbisyo ng reseller",
    'actionlog__template_admin' => "Plano ng serbisyo ng administrador",
    'actionlog__template_reseller' => 'Plano ng reseller',
    'actionlog__admin_alias' => 'Karagdagang account ng administrator', // PFW
    'actionlog__ftpuser' => 'Karagdagang FTP Account', // PFW
    'actionlog__db_server' => 'Server ng database',
    'actionlog__db' => 'Database',
    'actionlog__db_user' => 'Account ng user na database',
    'actionlog__client_sapppkg_pool' => "Web application ng user", // PFW, not used?
    'actionlog__remote_dns' => 'Estado ng Remote DNS server', // PFW
    'actionlog__reseller' => 'Account ng reseller',
    'actionlog__reseller_guid' => 'GUID ng reseller',
    'actionlog__reseller_ip_pool' => "IP pool ng reseller",
    'actionlog__reseller_limit_size' => 'Limitasyon sa disk space para sa account ng reseller',
    'actionlog__reseller_limit_traffic' => 'Limitasyon sa trapiko para sa account ng reseller',
    'actionlog__reseller_limits' => 'Limitasyon sa account ng reseller',
    'actionlog__reseller_permissions' => 'Pahintulot ng reseller',
    'actionlog__reseller_preferences' => "Mga pag-nais na interface ng reseller",
    'actionlog__reseller_siteapp' => "Mga web application sa pool ng reseller",
    'actionlog__reseller_status' => 'Estado ng account ng reseller',
    'actionlog__health_status' => 'Estado sa kalusugan ng server',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'Na-abot',
    'actionlog__added' => 'idinagdag',
    'actionlog__removed' => 'tinanggal',
    'actionlog__change' => 'binago',
    'actionlog__update' => 'pag-update',
    'actionlog__move' => 'inilipat',
    'actionlog__upgrade' => 'nagawa ang pag-upgrade', // PFU?
    'actionlog__update_or_add' => 'nagawa ang pag-update o nadagdag',
    'actionlog__expired' => 'tapos',
    'actionlog__create' => 'nalikha',
    'actionlog__delete' => 'nabura',
    'actionlog__service_stop' => 'tumigil',
    'actionlog__service_restart' => 'sinimulan muli',
    'actionlog__service_start' => 'nagsimula',
    'actionlog__login' => 'naka-log in',
    'actionlog__logout' => 'naka-log out',
    'actionlog__install' => 'naka-install',
    'actionlog__uninstall' => 'inalis',
    'actionlog__reconfigure' => 'muling kinumpigura',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Kahilingan sa pag-reset ng password',
    'actionlog__event_admin_update' => 'Nagawa ang pag-update sa impormasyon ng administrador',
    'actionlog__event_admin_preferences_update' => "Na-update ang mga kagustuhan ng administrator",
    'actionlog__event_service_restart' => 'Nagsimulang muli ang serbisyo',
    'actionlog__event_service_start' => 'Nag-simula ang serbisyo',
    'actionlog__event_service_stop' => 'Tumigil ang serbisyo',
    'actionlog__event_ip_address_create' => 'Nalikha ang IP address',
    'actionlog__event_ip_address_delete' => 'Nabura ang IP address',
    'actionlog__event_ip_address_update' => 'Nagawa ang pag-update sa IP address',
    'actionlog__event_client_create' => 'Nalikha ang account ng kustomer',
    'actionlog__event_client_delete' => 'Nabura ang account ng kustomer',
    'actionlog__event_client_update' => 'Nagawa ang pag-update sa account ng kustomer',
    'actionlog__event_client_status_update' => 'Nagawa ang pag-update sa estado ng account ng kustomer',
    'actionlog__event_client_preferences_update' => "Na-update ang mga pag-nais na interface ng kustomer",
    'actionlog__event_client_siteapp_added' => "Naidagdag ang web application sa application pool ng account ng kustomer",
    'actionlog__event_client_siteapp_removed' => "Naalis ang web application sa application pool ang account ng kustomer",
    'actionlog__event_domain_limit_size_reached' => 'Na-abot na ang limitasyon ng disk space para sa suskrisyon',
    'actionlog__event_domain_limit_traffic_reached' => 'Na-abot na ang limitasyon ng trapiko para sa suskrisyon',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Naabot na ang limitasyon ng disk space para sa subscription',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Naabot na ang limitasyon ng trapiko para sa subscription',

    'actionlog__domain_limit_database' => 'Quota ng mga database para sa suskrisyon',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Naabot na ang quota ng MariaDB/MySQL database para sa mga suskrisyon',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Naabot na ang soft quota ng MariaDB/MySQL database para sa mga suskrisyon',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Naabot na ang Microsoft SQL database server quota para sa mga suskrisyon',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Naabot na ang Microsoft SQL database server soft quota para sa mga suskrisyon',
    'actionlog__event_plesk_component_upgrade' => 'Na-update ang bahagi ng Plesk',
    'actionlog__event_plesk_component_install' => 'Na-install ang bahagi ng Plesk',
    'actionlog__event_plesk_component_uninstall' => 'Na-uninstall ang bahagi ng Plesk',
    'actionlog__event_domain_create' => 'Nagawa ang default na domain (ang unang domain na naidagdag sa subscription)',
    'actionlog__event_domain_delete' => 'Na-delete ang default na domain (ang unang domain na naidagdag sa subscription)',
    'actionlog__event_domain_update' => 'Na-update ang default na domain (ang unang domain na naidagdag sa subscription)',
    'actionlog__event_domain_owner_change' => 'Nabago ang may-ari ng suskrisyon',
    'actionlog__event_domain_plan_change' => 'Plano ng serbisyo ng suskripsyon ay nabago',
    'actionlog__event_domain_status_update' => 'Default domain, nagawa ang pag-update sa estado',
    'actionlog__event_domain_dns_update' => 'Default domain, nagawa ang pag-update sa DNS zone',
    'actionlog__event_subdomain_create' => 'Nalikha ang subdomain ng default domain',
    'actionlog__event_subdomain_delete' => 'Nabura ang subdomain ng default domain',
    'actionlog__event_subdomain_update' => 'Nagawa ang pag-update sa subdomain ng default domain',
    'actionlog__event_domain_alias_create' => 'Default domain, nalikha ang alyas',
    'actionlog__event_domain_alias_delete' => 'Default domain, nabura ang alyas',
    'actionlog__event_domain_alias_update' => 'Default domain, nagawa ang pag-update sa alyas',
    'actionlog__event_domain_limits_update' => 'Nagawa ang pag-update sa limit ng suskrisyon',
    'actionlog__event_cp_user_login' => 'Naka-log in ang user ng Plesk',
    'actionlog__event_cp_user_logout' => 'Nag-log out ang user ng Plesk',
    'actionlog__event_mailname_create' => 'Nalikha ang mail account',
    'actionlog__event_mailname_delete' => 'Nabura ang mail account',
    'actionlog__event_mailname_clear' => 'Mail account emptied',
    'actionlog__event_mailname_update' => 'Nagawa ang pag-update sa mail account',
    'actionlog__event_maillist_create' => 'Nalikha ang mailing list',
    'actionlog__event_maillist_delete' => 'Nabura ang mailing list',
    'actionlog__event_maillist_update' => 'Nagawa ang pag-update sa mailing list',
    'actionlog__event_phys_hosting_create' => 'Nalikha ang physical hosting',
    'actionlog__event_phys_hosting_delete' => 'Nabura ang physical hosting',
    'actionlog__event_phys_hosting_update' => 'Nagawa ang pag-update ng physical hosting',
    'actionlog__event_forwarding_create' => 'Nalikha ang standard o frame forwarding hosting',
    'actionlog__event_forwarding_delete' => 'Nabura ang standard o frame forwarding hosting',
    'actionlog__event_forwarding_update' => 'Nagawa ang pag-update sa standard o frame forwarding hosting',
    'actionlog__event_webuser_create' => 'Nalikha ang account ng web user',
    'actionlog__event_webuser_delete' => 'Nabura ang account ng web user',
    'actionlog__event_webuser_update' => 'Nagawa ang pag-update sa account ng web user',
    'actionlog__event_siteapp_install' => 'Naisalin ang web application',
    'actionlog__event_siteapp_reconfigure' => 'Muling kinumpigura ang web application',
    'actionlog__event_siteapp_uninstall' => 'Tinanggal ang web application',
    'actionlog__event_license_update' => 'Nagawa ang pag-update sa license key',
    'actionlog__event_admin_alias_create' => 'Nalikha ang karagdagang account ng administrator',
    'actionlog__event_admin_alias_delete' => 'Nabura ang karagdagang account ng administrator',
    'actionlog__event_admin_alias_update' => 'Nagawa ang pag-update sa karagdagang account ng administrator',
    'actionlog__event_ftpuser_create' => 'Nalikha ang karagdagang account ng FTP',
    'actionlog__event_ftpuser_update' => 'Nagawa ang pag-update sa karagdagang account ng FTP',
    'actionlog__event_ftpuser_delete' => 'Nabura ang karagdagang account ng FTP',
    'actionlog__event_template_domain_create' => "Nalikha ang plano ng serbisyo ng reseller",
    'actionlog__event_template_domain_update' => "Nagawa ang pag-update sa plano ng serbisyo ng reseller",
    'actionlog__event_template_domain_delete' => "Nabura ang plano ng serbisyo ng reseller",
    'actionlog__event_template_admin_create' => "Nalikha ang plano ng serbisyo ng administrador",
    'actionlog__event_template_admin_update' => "Nagawa ang pag-update sa plano ng serbisyo ng administrador",
    'actionlog__event_template_admin_delete' => "Nabura ang plano ng serbisyo ng administrador",
    'actionlog__event_database_server_create' => 'Nalikha ang database server',
    'actionlog__event_database_server_update' => 'Nagawa ang pag-update ang database server',
    'actionlog__event_database_server_delete' => 'Nabura ang database server',
    'actionlog__event_remote_dns_status_update' => 'Nagawa ang pag-update sa estado ng Remote DNS server',
    'actionlog__event_session_preferences_update' => 'Nagawa ang pag-update sa mga setting ng session',
    'actionlog__event_domain_alias_dns_update' => 'Default domain, nagawa ang pag-update sa DNS zone sa domain alias',
    'actionlog__event_domain_move' => 'Inilipat sa isang bagong subscription ang default na domain',
    'actionlog__event_site_move' => 'Inilipat sa isang bagong subscription ang domain',
    'actionlog__event_site_subdomain_move' => 'Inilipat sa isang bagong subscription ang subdomain',
    'actionlog__event_subdomain_move' => 'Inilipat sa isang bagong subscription ang subdomain ng isang domain',
    'actionlog__event_license_expired' => 'Tapos na ang lisensya ng Plesk',
    'actionlog__event_database_create' => 'Nalikha ang database',
    'actionlog__event_database_delete' => 'Naalis ang database',
    'actionlog__event_database_user_create' => 'Nalikha ang account ng user ng database',
    'actionlog__event_database_user_update' => 'Nagawa ang pag-update sa mga setting sa account ng user ng database',
    'actionlog__event_database_user_delete' => 'Naalis ang account ng user ng database',
    'actionlog__event_client_guid_update' => "Nagawa ang pag-update sa GUID ng kustomer",
    'actionlog__event_domain_guid_update' => 'Default domain, nagawa ang pag-update sa GUID',
    'actionlog__event_reseller_create' => 'Nalikha ang account ng reseller',
    'actionlog__event_reseller_delete' => 'Nabura ang account ng reseller',
    'actionlog__event_reseller_update' => 'Nagawa ang pag-update sa account ng reseller',
    'actionlog__event_reseller_guid_update' => 'Nagawa ang pag-update sa reseller GUID',
    'actionlog__event_reseller_ip_pool_update' => "Nagawa ang pag-update sa IP pool ng reseller",
    'actionlog__event_reseller_limit_size_reached' => 'Na-abot ang limitasyon ng disk space para sa account ng reseller',
    'actionlog__event_reseller_limit_traffic_reached' => 'Na-abot ang limitasyon sa trapiko para sa account ng reseller',
    'actionlog__event_reseller_limits_update' => 'Nagawa ang pag-update sa limit ng account ng reseller',
    'actionlog__event_reseller_permissions_update' => 'Nagawa ang pag-update sa mga pahintulot ng account ng reseller',
    'actionlog__event_reseller_preferences_update' => "Nagawa ang pag-update sa mga pag-nais na interface ng reseller",
    'actionlog__event_reseller_siteapp_added' => "Karagdagang application sa application pool account ng reseller",
    'actionlog__event_reseller_siteapp_removed' => "Natanggal ang application sa application pool sa account ng reseller",
    'actionlog__event_reseller_status_update' => 'Nagawa ang pag-update sa estado ng account ng reseller',
    'actionlog__event_template_reseller_create' => 'Nalikha ang plano ng reseller',
    'actionlog__event_template_reseller_delete' => 'Nabura na ang plano ng reseller',
    'actionlog__event_template_reseller_update' => 'Nagawa ang pag-update sa plano ng reseller',
    'actionlog__event_health_status_change' => 'Nagbago ang estado ng kalusugan ng server',
    'actionlog__event_siteapp_upgrade' => 'Nagawa ang pag-upgrade sa web app',
    'actionlog__event_extension_install' => 'Na-install ang extension',
    'actionlog__event_extension_uninstall' => 'Hindi na-uninstall ang extension',
    'actionlog__event_extension_upgrade' => 'Na-upgrade ang extension',
    'actionlog__event_extension_status_update' => 'Na-update ang status ng extension',
    'actionlog__event_additional_license_expired' => 'Nag-expire na ang karagdagang license',
    'actionlog__event_hostname_changed' => 'Nabago ang hostname ng server',
    'actionlog__event_smb_user_create' => 'Gumawa ng karagdagang user',
    'actionlog__event_smb_user_delete' => 'Na-delete ang karagdagang user',
    'actionlog__event_smb_user_update' => 'Na-update ang karagdagang user',
    'actionlog__dns_record' => 'DNS Record',
    'actionlog__dns_zone' => 'DNS Zone',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Ang Plesk API RPC ay hindi naka-install sa iyong remote host. Kontakin ang iyong service provider para sa tulong.",
    'rsession_no_account_errmsg' => "Hindi magawa ang pag-access sa remote service sa ilalim ng iyong account. Ang kadalasang dahilan ay ang serbisyo para sa iyong account ay hindi pa aktibo. Maghintay ng ilang minuto, at muling subukan. Kapag muling mararanasan ang error na ito, kontakin ang iyong administrador ng system.",
    'rsession_no_domain_errmsg' => "Hindi magawa ang pag-access sa remote service para sa domain na ito. Ang kadalasang dahilan ay ang serbisyo para sa domain na ito ay hindi pa aktibo. Maghintay ng ilang minuto, at muling subukan. Kapag muling mararanasan ang error na ito, kontakin ang iyong administrador ng system.",
    'rsession_unknown_errmsg' => "Tinanggihan ng remote server ang pagsubok sa paggawa ng session. Kontakin ang iyong administrador sa system para sa suporta. Ang naging error ay: %1",
    'rsession_unknown2_errmsg' => "Hindi kilalang error habang itinataguyod ang remote session. Marahil, ang remote server ay hindi tumutugon nang maayos o walang tugon. Tanungin ang iyong administrador ng system para marepaso ang mga detalye ng error sa web server error log.",
    'rsession_no_connect_errmsg' => "Hindi magawa ang pag-access sa remote service: nabigo ang pagkonekta sa remote session. Kontakin ang iyong administrador sa system para sa suporta.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Pahintulutan ang pag-upload sa incoming na direktoryo",
    'anonftp__allow_create_dirs' => 'Pahintulutan ang pagbuo ng mga direktoryo sa incoming na direktoryo',
    'anonftp__allow_download_incoming' => 'Pahintulutan ang pag-download munla sa incoming na direktoryo',
    'anonftp__display_login' => 'Display na mensahe sa login',
    'anonftp__login_text' => 'Mensahe na text',
    'anonftp__limit_incoming_disk_space' => "Limitahan ang disk space sa paparating na direktoryo",
    'anonftp__limit_maximum_bandwidth' => "Limitahan ang download bandwidth para sa virtual na FTP domain",
    'anonftp__limit_maximum_connections' => "Limitahan ang bilang ng mga sabay-sabay na koneksyon",
    'anonftp__unable_init' => "Hindi masimulan ang account ng hindi kilalang FTP: %1",
    'anonftp__unable_set_quota' => "Hindi maitakda ang limitasyon sa disk space ng paparating na direktoryo: %1",
    'anonftp__unable_update' => "Hindi magawa ang pag-update sa mga katangian ng account ng hindi kilalang FTP: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Mga SSL/TLS Certificate', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Hindi lalagdaan ng sertipiko ng CA ang sertipiko.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Hindi magkatugma na pribadong susi/pares na sertipiko.",
    'class_sslcertificate__invalid_cert_format' => "Di-wastong pormat ng sertipiko.",
    'class_sslcertificate__invalid_private_key_format' => "Di-wastong pormat ng pribadong susi.",
    'class_sslcertificate__prob_invalid_priv_key' => "Marahil, di-wasto ang pormat ng pribadong susi.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Walang i-upload na mga file.',
    'login_up__access_denied_no_permission' => "Tinanggihan ang pag-access. Ikaw ay walang pahintulot na mag-log in.",
    'mail__unable_remove_pattern' => "Hindi maalis ang address mula sa server black list: %1", // PFW
    'mail__incorrect_network_format' => 'Maling pormat ng network: %1', // PFW
    'initconf__unable_change_passwd' => "Hindi mapalitan ang password ng administrador: %1",
    'initconf__unable_get_passwd' => 'Hindi makuha ang kasalukuyang password ng administrador: Nabigo ang %1: %2',
    'initconf__invalid_hostname' => 'Error sa hostname na "%1”',
    'initconf__unable_reconfig' => 'Hindi ma-configure ang Plesk: nabigo ang re-config: %1',
    'initconf__unable_update_admin' => 'Hindi ma-update ang impormasyon sa pakikipag-ugnayan ng administrador: %1',
    '__refresh' => 'I-refresh',
    '__dalias_not_exist' => 'Ang domain alias ay hindi umiiral.',
    '__bug146523_explanation' => 'Naunang bersyon ng Plesk ay pinahihintulutan na gumamit ng hanggang sa 16 na karakter para sa mga FTP username. Ang bersyon na ito ng Plesk ay naglilimita sa pinakamataas na bilang ng mga karakter na pinahihintulutan sa mga username ng FTP hanggang sa 15. Upang maresolba ang isyu na ito, bawasan ang haba ng FTP username hanggang sa 15 karakter para sa apektadong mga FTP username at palitan nang hindi bababa sa isang karakter sa apektadong mga FTP username upang maiwasan ang pagbanggan ng mga isyu sa username. Kami ay humihingi ng paumahin para sa anumang posibleng pagkaantala na dulot ng pagbaago na ito.',
    'domain__cannot_change_webmail' => 'Hindi maaring palitan ang webmail para sa domain: %1',
    'sb_publish_disable_warning' => 'Kapag iyong pinatay ang paglikha ng website gamit ang Presence Builder, ang website na unang nagawa gamit ang Presence Builder ay maalis at lahat ng datos sa website ay mawawala. I-klik ang OK kung nais mong magpatuloy.',
    '__sbnet_client_use_sbnet' => "Lumikha ng akmang account ng user sa Presence Builder",
    'mail_resp_activate' => 'Paganahin ang auto-reply',
    'limitsManger__limit_available_error' => 'Hindi makapag-takda ng kinakailangan na dami ng resources ("%%limitName%%"): tanging ang %%available%% maaari para sa iyong account.',
    'limitsManger__limit_reserved_error' => 'Hindi makapag-takda ng mas mababang resources ("%%limitName%%") kaysa sa dating nagamit.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Hindi magawang palitan ang domain name: Ang virtual na direktoryo na may tinukoy na pangalan ay mayroon nang umiiral.',
    'domain_unable_to_rename' => 'Hindi nagawang palitan ang pangalan ng domain.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Pangkalahatan',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin pag-filter sa spam',
    'spamfilter__spamassassin_settings_legend' => 'Mga Setting ng SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Buksan ang server-wide SpamAssassin pag-filter sa spam",
    'spamfilter__spamassassin_user_status_legend' => 'Buksan ang SpamAssassin pag-filter sa spam',
    'spamfilter__greylisting_status_legend' => 'Buksan ang proteksyon sa spam ng server-wide greylisting.',
    'spamfilter__personal_settings_not_allowed' => 'Ang paggamit ng mga setting ng indibidwal na pag-filter sa spam ay hindi pinapayagan ng patakaran ng system.',
    'spamfilter__required_score' => 'Ang puntos na dapat na makuha ng isang mensahe para pumasa bilang spam',
    'spamfilter__rewrite_header_subject' => 'Idagdag ang mga sumusunod na teksto sa simula ng paksa ng bawat mensahe na kinikilala bilang spam',
    'spamfilter__use_mailuser_prefs' => 'Ipatupad ang indibidwal na setting sa pag-filter sa spam',
    'spamfilter__score_error' => 'Hindi dapat negatibo ang puntos, ang bahagi bago ang puntong decimal ay dapat na mas mababa ng 100, at maaring magsama ng hindi lalagpas sa dalawang numero matapos ang decimal point.',
    'spamfilter__rewrite_header_error' => 'Ang paksa ng mensahe ay maaring maglaman ng kahit na anong maaring ilathala na karakter maliban sa markang (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Tumalbog',
    'nonexistent_mail__mode_discard' => 'Tanggalin',
    'nonexistent_mail__mode_catch_addr' => 'I-forward sa email address',
    'nonexistent_mail__mode_catch_ip' => 'I-forward sa IP',
    'nonexistent_mail__bounce_not_supported' => 'Hindi suportado ang bounce mode.',
    'nonexistent_mail__discard_not_supported' => 'Ang discard mode ay hindi suportado.',
    'nonexistent_mail__catch_not_supported' => 'Ang forwarding sa email address ay hindi suportado',
    'nonexistent_mail__redirect_not_supported' => 'Ang forwarding sa IP ay hindi suportado',
    'nonexistent_mail__ip_used_on_this_host' => 'Ang IP address ay nareresolba sa localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Dahil ang mga papalabas na kontrol ng mail ay nakabukas, ang email address na %1 para sa hindi umiiral na mga tatanggap ay dapat na-uuri sa mga piniling domain. Kung hindi, pagkatapos ay ang "Reject" na patakaran ay ilalapat sa halip ng pagpapasa.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Dahil sa nakabukas ng kontrol sa palabas na mail, ang tinukoy na email address para sa forwarding ng mail (%1) ay dapat pagmamay-ari ng mga napiling domain. Kung hindi, pagkatapos ang mga mensaheng ipinadala sa address na ito ay hindi mabibilang sa Outgoing Mail Control.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'Ang suporta sa ASP.NET ay naka-off para sa website na ito.',
    'phosting__php_forced_by_site_isolation' => 'Hindi mapalitan ang mga setting ng PHP: ang pahintulot para patungan ang patakaran sa seguridad ng server-wide ay hindi pinahintulutan.',
    'phosting__option_forced_by_site_isolation' => 'Hindi mapalitan ang %1 na mga setting: ang pahintulot para patungan ang patakaran sa seguridad ng server-wide ay hindi pinahintulutan.',
    'phosting__php_handler_id_not_registered' => 'Hindi pinapayagan ang handler ng PHP sa mga setting ng site isolation. Ang default na PHP handler ang gagamitin.',
    'phosting__php_served_by_nginx_is_not_available' => 'Ang handler ng PHP (aplikasyon na FPM na pinagsisilbihan ng nginx) ay hindi pinahihintulutan sa mga setting ng site isolation.No more fuzzy matches. Gagamitin ang default na handler ng PHP.',

    // tooltips

    'b_get_password_cancel' => 'Bumalik sa nakaraang screen nang hindi ipinapadala ang email.',
    'b_get_password_send' => 'I-klik ang OK para mapadala ang mensahe sa pagkuha muli ng password patungo sa email address na rehistrado sa system.',

    'b_back' => 'Bumalik sa mga naunang pahina.',
    'b_next' => 'Pumunta sa susunod na pahina.',

    'b_dnsnstemplatelist_remove' => 'Burahin ang mga napiling pangalan ng server.',
    'b_dnsnstemplatelist_search' => 'Ipasok ang search pattern at i-klik para mahanap ang mga pangalan ng server.',
    'b_dnsnstemplatelist_show_all' => 'Ipakita lahat ng mga pangalan ng server.',

    'l_dnsnstemplatelist_ns' => 'Uriin ang tala ng template ayon sa pangalan ng server.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Gumawa ng mga ligtas na link sa mga file at folder',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Paganahin ang pampublikong file',
    'cu__serverfilesharing_fsPublicFolder' => 'Folder para sa pampublikong imbakan ng mga file',
    'cu__serverfilesharing_fsPublicUrl' => 'URL sa pag-access ng bisita sa mga pampublikong file',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Paganahin ang password-protection ng pampublikong mga file',
    'cu__serverfilesharing_fsPartnerFolder' => 'Folder para sa imbakan ng password-protected na file',
    'cu__serverfilesharing_fsPartnersLogin' => 'Username para sa pag-access ng file',
    'cu__serverfilesharing_fsPartnersPassword' => 'Password para sa pag-access ng file',
    'cu__serverfilesharing_fsDomain' => 'Web folder root URL. Domain name',
    'cu__serverfilesharing_fsPrefix' => 'Web folder root URL. Unlapi',
    'cu__serverfilesharing_commandUpdate' => 'Mga setting sa pag-update ng file sharing',
    'cu__serverfilesharing_commandInfo' => 'Ipakita ang kasalukuyang mga setting ng file sharing',
    'subscription_rename_is_forbidden' => 'Ang pagpapalit ng pangalan ng suskrisyon ay ipinagbabawal ng patakaran ng server-wide.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "Account ng FTP sa Ilalim ng domain na %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Mga account ng FTP",
    'ftp__user_name' => "Pangalan ng FTP account",
    'ftp__user_home' => "Direktoryo ng Home",
    'ftp__invalid_path' => "Hindi wastong path ang tinukoy",
    'i_ftp_ses_sub_user' => 'Sesyon ng FTP account.',
    '__new_passwd' => "Bagong %1 password",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Hindi ma-konpigura ang web server sa host na <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Hindi gumagana ang file sa konpigurasyon ng web server sa host na <%%host%%>dahil sa sumusunod na mga error:\n\n%%error%%\n\nResolbahin ang mga error sa mga template sa konpigurasyon ng web server at muling paganahin ang file.",

    'apacheConfigurationMessageAdminTitle' => 'Nabigo ang pagpapagana ng konpigurasyon ng web server',
    'apacheConfigurationMessageClientTitle' => 'Babala',

    'apacheConfigurationFailedAdminHomeMessage' => 'Ang bagong konpigurasyon file para sa domain ay hindi nalikha dahil sa mga error sa template ng konpigurasyon. Ang detalyadong mensahe ng error ay naipadala na sa iyong email, paki-tignan ng email, ayusin ang mga error, at pindutin ang %1 para muling paganahin ang konpigurasyon.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'dito', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Ang bagong konpigurasyon para sa domain %1 ay hindi nalikha dahil sa mga error sa mga template ng konpigurasyon. Ang detalyadong mensahe ng error ay naipadala na sa iyong email, paki-tignan ng email, ayusin ang mga error, at pindutin ang %2 para muling paganahin ang konpigurasyon.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'dito', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Maaring pabago-bago ang konpigurasyon ng web server para sa domain %1. Kontakin ang administrador ng server para resolbahin ang problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Ang iba sa mga bagong konpigurasyon para sa domain ay hindi nalikha dahil sa error sa template ng konpigurasyon. Ang detalyadong mensahe ng error ay naipadala na sa iyong email, paki-tignan ng email, ayusin ang mga error, at pindutin ang %1 para muling paganahin ang konpigurasyon.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'dito', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Ang konpigurasyon ng Web server para sa iba sa iyong mga domain ay pabago-bago. Kontakin ang administrador ng server para maayos ang problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Mga dokumento ng custom error",
    'dom_pref__webusers_script' => "Payagan ang mga gumagamit ng web upang magamit ang mga script",
    '__seoRedirect' => 'Konpigurahin ang ninais na domain bilang',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Wala',

    '__sites' => 'Mga domain',
    'domain_plan__perm_denied_manage_phosting' => 'Wala kang pahintulot upang pangasiwaan ang mga setting ng hosting.',
    '__owned_by_client' => 'pagmamay-ari ng kustomer',
    'backup__restore__object_client_template' => 'Template ng kustomer',
    '__template_name' => 'Pangalan ng plano ng serbisyo',
    'template__not_exists' => 'Walang ganitong plano ng serbisyo.',
    'template__exists' => 'Ang plano na may pangalan na %1 ay umiiral.',
    'clientOwnerChanger__ip_not_in_pool' => 'Ang tinukoy na IP address ay wala sa pool ng reseller.',
    '__owner_name' => 'Service plan owner',

    'chown__error_check' => 'May mga problemang nasalubong habang sinusubukan na itakda ang ilang mga suskrisyon sa bagong may-ari.',

    '__redirect_hint' => 'Ikaw ay mapupunta sa bagong address sa loob ng 15 segundo... kapag ikaw ay automatic na dinala sa bagong lokasyon, paki buksan ang javascript o i-klik ang hyperlink %%link%%.',

    'backup__restore__object_maillist' => 'Mailing list',
    'backup__restore__object_site' => 'Site',
    'backup__restore__object_user' => 'User',
    'backup__restore__object_role' => 'Tungkulin',

    'limit__name_max_site' => 'mga site',

    'iis_pool__unable_rename_client' => "Hindi maaring baguhin ang pangalan ng IIS application pool: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Suportado lamang ang serbisyo ng hindi kilalang FTP sa pangunahing domain ng isang suskrisyon.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Suportado lang ang serbisyo ng hindi kilalang FTP sa pangunahing domain ng isang subscription.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/Buwan',
    '__tb_month' => 'TB/buwan',

    '__customer_total' => 'Kabuuan ng Kustomer',
    '__site' => 'Site',
    '__def_site' => 'Site ng default',
    '__subscription_name' => 'Pangalan ng suskrisyon',
    '__subscription_name_powerUser' => 'Pangalan ng subscription',

    'limit__units_max_traffic_suffix' => '/buwan',

    'dom_pref__discard' => "Tanggihan",

    'mail__pattern_already_exists' => 'Ang pattern "%1" ay nasa black list.',

    '__not_supported' => 'Hindi suportado',

    'plesk_key__sitebuilder' => 'Mga inilathalang site gamit ang Presence Builder',
    'limit__name_max_site_builder' => 'Mga inilathalang site gamit ang Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Suporta para sa sari-saring wika na site sa Presence Builder',

    'login_up__access_denied_no_subscriptions' => "Tinanggihan ang pag-access. Walang magamit na suskrisyon sa account na ito.",

    'interval__day' => '%1 (mga) araw',
    'interval__hour' => '%1 (mga) oras',
    'interval__minute' => '%1 (mga) minuto',
    'interval__second' => '%1 (mga) segundo',

    ///License options
    'plesk_key__backward_incompatibility' => 'Ikaw ay sumusubok na gumamit ng isang license key na nilikha para sa ibang bersyon ng Plesk. Makipag-ugnayan sa mga kinatawan ng sales ng Plesk upang makakuha ng angkop na license key.',
    //Standalone or virtualization
    'virtualization_any' => "Pisikal na server o kahit anong virtualization solution",
    'virtualization_pvc' => "Mga container ng Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "Magagamit para sa mga sumusunod na mga paligid:",
    'plesk_key__virtualization_only_key' => 'Ang license key ay naglalayon lamang para sa paggamit ng Plesk na ginagamit sa loob ng isang %1 ng virtual environment:',
    'plesk_key__virtualizations_only_key' => 'Ang license key ay naglalayon lamang para sa paggamit ng Plesk na ginagamit sa loob ng mga sumusunod na virtual environment: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Ang paggamit ng custom na language pack ay ipinagbabawal.',
    'plesk_key__allowed-locales' => 'Mga makukuhang wika',
    'plesk_key__allowed-locales-any' => 'Anumang wika',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'Nakalagay sa cgi-bin na direktoryo',
    '_cgi_bin_mode_webspace' => 'ang root directory ng subscription',
    '_cgi_bin_mode_www_root' => 'Ang dokumento ng root ng domain na ito',

    /// Custom buttons
    'custom_button__sort_key' => 'Priyoridad',
    'custom_button__place' => 'Lokasyon',
    'custom_button__place_navigation' => 'Karaniwang Pag-Access',
    'custom_button__place_admin' => 'Home page ng administrador',
    'custom_button__place_admin-settings' => 'Mga Tools & Settings page ng administrador',
    'custom_button__place_reseller' => "Home page ng reseller",
    'custom_button__place_reseller-settings' => 'Tools Pahina ng mga utilities ng mga reseller',
    'custom_button__place_client' => 'Home page ng kustomer',
    'custom_button__place_domain' => "Mga Website at Mga domain na pahina ng Suskrisyon",
    'custom_button__place_domain_powerUser' => "Mga Website at Mga domain na pahina ng Suskrisyon",
    'custom_button__place_domain-properties' => 'Mga Tools ng website',
    'custom_button__private' => 'Ipakita lamang sa akin',
    'custom_button__image' => 'Imahe sa paligid',
    'custom_button__conhelp' => "Teksto ng Tooltip",
    'custom_button__edit' => "Mga setting ng link sa mga Karagdagang Serbisyo",
    'custom_button__include_client_cname' => "Isama ang pangalan ng kompanya ng kustomer",
    'custom_button__include_client_email' => "Isama ang email ng kustomer",
    'custom_button__include_client_id' => "Isama ang ID ng kustomer",
    'custom_button__include_client_pname' => "Isama ang pangalan sa pakikipag-ugnayan ng kustomer",
    'custom_button__include_domain_id' => "Isama ang ID ng suskrisyon, ID ng domain at palayaw ng ID ng domain",
    'custom_button__include_domain_id_powerUser' => "Isama ang ID ng suskrisyon, ID ng domain at palayaw ng ID ng domain",

    'custom_button__include_domain_name' => "Isama ang Pangunahing Domain name",
    'custom_button__include_ftp_user' => "Isama ang username ng FTP",
    'custom_button__include_ftp_pass' => "Isama ang FTP password",
    'custom_button__internal_open' => "Buksan ang URL sa Plesk",
    'custom_button__text' => "Tanda ng button",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Ang file ay hindi isang image file.',
    'custom_button__big_image' => 'Ang sukat ng file ay hindi dapat lumampas sa 100 KB.',
    'custom_button__failed_copy_image' => 'Hindi nakopya ang file: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Hindi maaaring i-restore ang isang non-Power-user backup sa Power User view.',
    '__unknown_network_interface' => 'Hindi kilalang interface ng network',

    'init_conf__ip_address' => 'IP address',

    //Confirmation page
    'bt_confirm' => 'Kumpirmahin',
    'b_confirm' => 'Kumpirmahin ang pagmamay-ari ng iyong mga site.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Ang mga setting ng dedikadong IIS application pool ay ayon sa mga patakaran sa seguridad ng server-wide (site isolation konpigurasyon).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Ang mga setting ng dedikadong IIS application pool ay ayon sa mga setting ng pagganap ng server-wide.',

    '__current' => 'Kasalukuyan',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Nagamit mo na halos ang lahat ng domains na inilaan sa iyo ng lisensya ng Plesk (90% o higit pa).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Halos nagamit mo na ang lahat ng mga domain.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Halos nagamit mo na ang lahat ng Presence Builder na mga site na inilaan sa iyo ng lisensya ng Plesk (90% o higit pa)',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Halos nagamit mo na ang lahat ng iyong Presence Builder na mga site.',
    'promo__button_hide' => 'Itago',
    'promo__button_next' => 'Susunod >>',
    'promo__button_prev' => '<< Nakaraan',
    'promo__button_license' => 'Pag-update ng lisensya',

    'promo__google_integration_title' => 'Integrasyon sa serbisyo ng Google',
    'promo__google_integration' => 'Konpigurahin ang integrasyon sa serbisyo ng Google, katulad ng AdSense, GoogleApps, Webmaster tools.',
    'promo__google_integration_button' => 'I-konpigura',

    'promo__button_learn_more' => 'Dagdagan ang Nalalaman',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Maari mong i-kustomize ang anyo ng iyong interface at mga setting ng branding sa pamamagitan ng tema ng custom. Para mga panuto sa pag-kustomize ng tema ng Plesk, sumangguni sa %1',
    'panel_branding__description_link' => 'sumusunod na dokumento',

    ///// File Manager new buttons
    'bt_extract_archive' => 'I-extract ang mga File',
    'filemanager_error_extracting_files' => 'May error na lumabas habang ini-extract ang mga archive file: %1',
    'filemanager_no_archive_files_specified' => 'Tukuyin ang mga archive na gusto mong i-extract.',
    'filemanager_not_zip_archive_specified' => '%1 ay hindi ma-extract, hindi ito isang ZIP archive.',
    'filemanager_files_successfully_extracted' => 'Ang archive files ay na-extract.',
    'filemanager_error_file_download' => 'Nabigo ang pag-download ng file: %1',
    'filemanager__user_poolgrp' => 'Grupo ng application pool',

    'loading' => 'Naglo-load...',
    'bt_create_archive' => 'Idagdag sa Archive',
    'filemanager__pack' => "Path sa archive: %1",
    'filemanager__archive_name' => 'I-archive ang pangalan ng file',
    'filemanager__empty_filename' => 'Ipasok ang pangalan ng archive file.',
    'filemanager_archive_created' => 'Ang archive ay matagumpay na nalikha.',
    'filemanager_error_creating_archive' => 'Hindi malikha ang archive: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Tala na ito ay sumasalungat sa tala na AAAA para sa zone.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Hindi sinusuportahan ng FTP server ang mga address ng IPv6)",
    'cmd_dns__glue_dns_record_conflict' => 'Ang tala na ito ay sasalungat sa glue record para sa zone \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Hindi sinusuportahan ng FTP server ang mga address ng IPv6)",
    '__ipv6_not_supported' => 'Hindi suportado ang IPv6.',
    'mail__ipv6_not_supported' => 'Ang IPv6 ay hindi suportado ng mail server.',
    'mail__relay_while_list_ipv6_not_supported' => 'Ang IPv6 relay whitelist ay hindi suportado ng mail server.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Ang mask value ay dapat multiple ng 16.',
    'mail__ip_or_mask_is_invalid' => 'Ang IP address o mask ay hindi wasto.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Ang forwarding sa IPv6 IP address ay hindi suportado.',
    'sa__invalid_trusted_networks' => 'Maling natukoy na mga trusted network: %1',
    'dns_add__enter_ipv6_address' => "IPv6 address",
    'license_trial_days_left' => 'Gumagana ang iyong Plesk gamit ang pagsubok na lisensya na mawawalan ng bisa sa loob ng %1 mga araw.',
    'excl_ipv6_num' => 'Dedikadong IPv6 Address',
    '__ip_mask' => "Subnet Mask",
    '__ipv4_addr' => 'IPv4 address',
    '__ipv6_addr' => 'IPv6 address',
    'template__num_excl_ipv6s' => 'Magtakda ng mga dedikadong IPv6 address sa reseller',
    'anonftp__exclusive_ipv4_required' => 'Ang itinalagang IPv4 address ay kailangan sa pag-set up at paggamit ng serbisyo ng hindi kilalang FTP.',
    'anonftp__ipv4_already_used' => 'Hindi ka pwedeng mag-set up ng serbisyo ng hindi kilalang FTP para sa site na ito dahil ito ay kasalukuyang nakumpigura sa ibang domain sa parehong IPv4 address.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'View ang log',

    'chown__error_ip_absent_in_ip_pool' => 'Ang IP address %1 ay wala sa IP pool ng target user.',
    'chown__error_ip_not_exist' => 'Walang IP address na mayroong ID \'%1\'.',
    'chown__error_domain_ip_not_selected' => 'Kailangan pumili ng kahit isang IP address para sa domain %1. View ang napiling marka para sa IP mapping.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'Ang IPv6 address o mask ay hindi wasto. Ang IP address ay dapat isang wastong unicast address.',

    '__subscriptions' => 'Mga suskrisyon',

    '__owned_by_reseller' => 'pagmamay-ari ng reseller',
    '__owned_by_provider' => 'pagmamay-ari ng provider',

    'service_plan__anonymous' => 'I-custom',
    'subscription_not_locked__change_limits_warning' => 'Ang suskrisyon ay hindi naka-lock: Ang limit ng paggamit ng resource ay mapapalitan sa oras ng synchronization ng plano ng serbisyo.',
    'subscription_not_locked__change_permissions_warning' => 'Ang suskrisyon ay hindi naka-lock: Ang mga pahintulot ay mapapalitan sa oras ng synchronization ng plano ng serbisyo.',

    'subscription__conflict_resolution_policy' => 'Patakaran ng conflicts resolution',
    'subscription__conflict_resolution_policy_lock' => "Lock na suskrisyon",

    'backup__list__backup_warnings' => 'Mga babala',
    'backup__list__backup_info' => 'Impormasyon',
    'backup__restore__object_reseller_template' => 'Template ng reseller',
    'backup__restore__object_domain_template' => 'Template ng domain',

    'subscription__unable_lock_anonymous' => 'Ang suskrisyon na ito ay hindi nakatali sa plano ng serbisyo, kaya\'t hindi ito ma-unlock.',
    'subscription__unable_sync_anonymous' => 'Ang suskrisyon na ito ay hindi nakatali sa plano ng serbisyo, kaya\'t hindi ito ma-synchronize.',
    'subscription__unable_sync_locked' => 'Ang suskrisyon na ito ay naka-lock kaya\'t hindi ito ma-synchronize.',
    'subscription__locked' => 'Ang suskrisyon ay naka-lock.',
    'component_name__urlrewrite' => "URL Rewrite",
    '__quantity' => 'Bilang',
    'hst__www_root_dir_absent' =>  'Babala: Ang tinukoy na direktoryo bilang document root ay hindi umiiral.',
    'object_creation__domain_is_not_a_webspace' => 'Maaari lang gawin ang object na ito sa isang subscription.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Naglalaman ng mga site ang subscription kaya hindi mo maaaring palitan ang uri ng hosting o i-delete ito.',
    'phosting__apache_error_docs_are_not_enabled' => 'Custom error documents are not enabled on the domain.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Error: Hindi na-update ang IP address. Hindi maaaring magtakda ng IP address na hindi nakatakda sa pangunahing domain ng subscription sa mga addon domain.',
    'domain_plan__unable_change' => 'Hindi maaring palitan ang plano ng serbisyo: %1.',
    'domain_plan__different_hosting_type' => 'Ang kasalukuyang uri ng hosting ay iba mula sa uri ng tinukoy sa plano ng serbisyo.',
    'domain_plan__addon_text' => 'Plano ng add-on',
    'domain_plan__addon_description' => 'Ang plano ng add-on ay ginagamit upang tumulong sa hosting plan.',
    'asp_net__managed_runtime_version' => 'Pinangasiwaan na runtime bersyon ng ASP.NET',
    'plan__can_not_change_hosting_type' => 'Imposible ang pagpalit ng uri hosting kapag nagbabago ng plano.',
    'plan__apply_problems' => 'Hindi nalapat ang plano dahil sa mga problema sa sumusunod na functionality: %1',
    'plan_save__subscription_update_problem' => 'Hindi maaring ipatupad ang mga pagbabago ng plano sa %1',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Ang suskrisyon ay pansamantalang natigil hanggang ang proseso ng pag-backup o pag-restore ay na kumpleto. Bumalik mamaya.",
    '__login_incorrect_plain_shadow_password' => 'Tinukoy mo ang maling password sa account ng administrator. Gamitin ang system ng administrador (root) na kredensyal, o kumuha ng tamang password. Para mas matuto sa pagkakaroon ng tamang password, basahin ang file /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Hindi mo maipapadala ang IP address na hindi mo pagmamay-ari',

    'dns__dns_zone_not_synchronized' => 'Ang DNS zone ay binago. Kung nais mo na ilagay ang mga pagbabago sa DNS template sa zone na ito, pindutin ang alin man sa \'Ipatupad ang mga Pagbabago sa Template ng DNS\' na button sa pahina na ito o piliin ang \'Apply changes to all zones\' na opsyon sa Server Administration Panel > Tools & Settings > DNS Template Settings > Apply DNS Template Changes.',
    'dns__dns_zone_synchronize_link' => 'I-klik',
    'dns__dns_zone_synchronize_done' => 'Ang DNS zone ay matagumpay na nai-sync',

    'dns__dns_zone_template_error' => 'Nagkaroon ng mga isyu sa pag-sync ng mga DNS zone sa DNS zone template.%1',

    'dns__soa_rname_type_owner' => 'Email address ng may-ari ng website',
    'dns__soa_rname_type_domain' => 'Email address ng domain',
    'dns__soa_rname_type_external' => 'External na email address',
    'dns__soa_rname_enforce_email' => 'Ipagbawal ang pagbabago sa RNAME email address kada domain',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'Ang email address ng taong nangangasiwa sa DNS zone ng domain. Ibinalik ng DNS server bilang tugon sa mga SOA query.',

    'dns__dns_zone_soa_sync_title' => 'I-override ang mga setting ng SOA para sa lahat ng kasalukuyang domain',
    'dns__dns_zone_soa_sync_legend' => 'Kinakailangang kumpirmahin',
    'dns__dns_zone_soa_sync_text' => 'I-update ang mga SOA record ng lahat ng hino-host na domain sa pamamagitan ng paglalapat sa mga pagbabagong ginawa sa SOA template?',

    'cu_db__repair_mysql_dbus' => "Ayusin ang password ng user MariaDB/MySQL. Kailangan ang operasyon na ito kung natapos na ang pag-upgrade patungo Plesk 11 mula sa lumang bersyon.",

    'cu_scheduled_backup_comment' => 'Itinakdang Backup',
    'cu_scheduled_backup_error' => 'Nagkaroon ng error sa proseso ng pag-back up: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Nagkaroon ng error sa nakaiskedyul na pag-back up.',
    'cu_scheduled_backup_mail_message' => "%1\nEntry point ng Plesk: %2\n\nNangyari ang mga sumusunod na error sa proseso ng nakaiskedyul na pag-back up:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Oras-oras na Pag-back Up',
    'cu_scheduled_backup_daily' => 'Araw-araw na Pag-back Up',
    'cu_scheduled_backup_weekly' => 'Lingguhang Pag-back Up',
    'cu_scheduled_backup_monthly' => 'Buwanang Pag-back Up',
    'cu_scheduled_backup_comment_backup_all' => '%1. Lahat ng configuration at content.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Lahat ng configuration at content maliban sa mga email message.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Configuration at mga email message lang.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Lahat ng configuration at content maliban sa mga database ng user.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Lahat ng configuration at content maliban sa mga file ng user.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Configuration at mga database ng user lang.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Configuration at mga file ng user lang',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Configuration ng domain.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Ang pag-iimbak ng mga naka-iskedyul na pag-backup sa isang remote cloud storage ay isang premium na tampok. Makipag-ugnayan sa iyong hosting provider upang ma-unlock ito.',

    'i_backup_invalid_file' => 'Ito ay hindi wastong backup. Ang datos ay hindi maaring ibalik mula sa file na ito. I-klik ang pangalan ng backup para sa mga detalye.',

    'filemanager_resulting_archive_exists' => 'Mayroon nang file na %1 sa target na direktoryo.',

    'agent_unable_to_connect' => 'Hindi makakonekta sa ahente sa \'%2\'. Siguraduhing ang ahente ay nakainstall at gumagana at walang problema sa koneksyon sa host \'%2\'.',
    'agent_test_connection_failed' => 'Nabigo ang koneksyon sa ahente sa \'%2\'.',

    'agent_unable_to_resolve_host' => 'Hindi kayang mahanap ang remote host \'%1\'. Siguraduhing walang problema ang koneksyon sa host.',
    'agent_unknown_curl_error' => 'Naganap ang error na \'%1\' habang nakakonekta sa ahente sa \'%2\'.',
    'agent_unexpected_htp_code' => 'Natanggap ang hindi inaasahang HTTP code na \'%1\' sa hiling ng HTTP sa ahente sa \'%2\'.',
    'agent_unable_to_auth' => 'Hindi mapatunayan sa host \'%1\'. Upang malutas ang isyu na ito, mangyaring sundin ang mga istruksiyon sa http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Isang panloob na error sa server ang nakita habang nagsasagawa command execution sa remote host \'%1\'.',
    'agent_response_is_empty' => 'Isang blankong tugon ang natanggap sa HTTP request galing sa ahente sa \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Hindi matagpuan ang Migration & Transfer Agent sa lokal na cache. Muling buksan Migration &Transfer Manager para maayos ang isyu.',

    '__hosting_webdeploy' => "Publishing ng Web Deploy",
    'cu_domain__webdeploy' => "Web Deploy publishing (default: %1)",
    'cu_dom_tpl__webdeploy' => "Web Deploy publishing (default: %1)",
    'cu_subdomain__webdeploy' => "Web Deploy publishing (default: %1)",
    'webdeploy__not_installed' => "Ang Microsoft Web Deploy ay hindi naka-install sa server",
    'webdeploy__forced_by_site_isolation' => "Hindi mapalitan ang mga setting ng Web Deploy publishing: Ikaw ay walang pahintulot na i-override ang patakaran ng seguridad ng server-wide. Kontakin ang iyong provider para sa mga detalye.",



    'backup__restore_options__admin__server_configuration_license' => 'Lisensya ng susi',
    'migration_start_migrate_server_license' => 'Gumawa ng pag-transfer ng license key',

    'defaultcomponents__delegation_rule_not_exist' => '(ang kailangan patakaran sa delegasyon \'appPoolPipeline, appPoolNetFx\' ay hindi umiiral)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Ang backup ay ginawa ng administrador.',
    'i_backup_created_by_reseller' => 'Ang backup ay ginawa ng reseller.',
    'i_backup_created_by_client' => 'Ang backup ay ginawa ng kustomer.',

    'migration__object_exists_on_target_host' => '(umiiral sa target host)',

    'cu_cl_pref__manage_website_maintenance' => 'Pag-access sa mga nangungunang operasyon: Pagkokopya ng Website',
    'cu_cl_pref__manage_protected_dirs' => 'Pangasiwaan sa Password-protected na mga direktoryo',
    'cu_cl_pref__manage_mail_settings' => 'Kakayahan sa pagpalit ng mga mail setting',


    'cu__command_update_php_settings' => 'Pag-update sa mga setting ng PHP.',
    'cu__php_settings_option' => 'Itinatakda ang path patungo sa file na may mga setting ng PHP.',

    'cu__additional_php_settings_option' => 'Itinatakda ang path patungo sa file na may karagdagang direktiba ng PHP.',
    'cu__command_show_php_settings' => 'Ipakita ang kasalukuyang mga setting ng PHP.',
    'cu__general_settings' => 'Mga pangkalahatang setting:',
    'cu__performance_settings' => 'Mga setting ng performance:',
    'cu__php_fpm_settings' => 'Mga setting ng PHP-FPM:',
    'cu__additional_directives' => 'Mga karagdagang direktiba:',

    'php_settings_permission_required' => 'Pangasiwaan sa karaniwang mga PHP setting',
    'php_settings_performance_permission_required' => 'Pangasiwaan sa mga setting sa pagganap ng hosting',
    'php_settings_customized' => 'Ang mga setting ng PHP ay na-kustomize.',
    'php_settings_synchronized_with_plan' => 'Ang mga setting ng PHP ay dapat naka-synchronize sa plano.',
    'phosting__unknown_shell_type' => 'Hindi magagamit na shell',

    'login_up__access_denied_subscription_deleted' => 'Tinanggihan ang pag-access: Ang iyong suskrisyon ay naalis.',

    'role_restricted_to_subscription' => '(nalipat na may suskrisyon: %1)',

    'filemanager__extract' => "I-extract ang mga file sa: %1",

    'cu__license_command_check_installed_license' => 'View ang bisa ng naka-install na license key (ibinabalik ang 0 na code para makalabas kapag ang key ay wasto at 1 kapag ito ay hindi-wasto)',

    'promo__mobile_manager_title' => 'Tagapamahala ng Plesk Server Mobile',
    'promo__mobile_manager' => "Palaguin ang gamit ng Plesk na makaka-kontrol at makakapag-matyag sa server mula sa mga mobile device (BlackBerry, iPhone, at Android).",
    'promo__mobile_monitor_title' => 'Tagapagmatyag ng Plesk Server Mobile',
    'promo__mobile_monitor' => 'Kumuha ng pinakamahalagang impormasyon tungkol sa Plesk server anumang oras at saanman gamit ang mobile device (BlackBerry, iPhone, at Android)',
    'promo__mobile_button' => 'Dagdagan ang Nalalaman',

    'subDomainNameHint' => 'Ilagay ang * bilang pangalan ng subdomain para makalikha ng isang wildcard subdomain. Ang mga bisita sa site ay idi-direkta sa subdomain walang bahala kung ano man ang ipinasok na pangalang ng subdomain sa browser.',
    'subdomains__wildcard_name_invalid' => "Ang pangalan ng subdomain ay hindi wasto. Tanging mga letra at numero lamang ang maaring gamitin, guhit (-) at isang asterisk * para sa mga wildcard ng mga pangalan ng subdomain.",
    'subdomains__name_invalid' => "Ang pangalan ng subdomain ay hindi wasto. Tanging mga letra at numero lamang ang maaring gamitin at guhit (-) para sa mga pangalan ng subdomain.",

    'domain__wildcard_no_www_prefix' => 'Hindi maaring magamit ang unlapi na www para sa wildcard subdomains.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix mail filter",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3 server",
    'restart__pop3s' => "Courier POP3 server na may suporta na SSL/TLS",
    'restart__imap' => "Courier IMAP server",
    'restart__imaps' => "Courier IMAP server na may suporta na SSL/TLS",
    'restart__authdaemon' => "Courier IMAP authentication daemon",
    'restart__imap-pop3' => "Dovecot IMAP at POP3 server",


    'addon_packages_not_supported' => 'Ang mga add-ons para sa nakapaketong web apps ng APS ay hindi suportado.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Hindi automatikong itatakda ang IP address sa domain. tukuyin ang IP address gamit ang -ip na opsyon.',

    'plesk_key__mb_accounts' => 'Account ng user (mga reseller at kustomer) sa Kustomer at Business Manager',

    'actionlog__subdomain_dns' => 'Subdomain DNS zone',
    'actionlog__site_subdomain_dns' => 'DNS zone ng subdomain sa ilalim ng karagdagang domain',

    // PfW only
    'actionlog__event_site_create' => 'Nalikha ang domain',
    'actionlog__event_site_delete' => 'Nabura ang domain',
    'actionlog__event_site_update' => 'Nagawa ang pag-update sa domain',

    'actionlog__event_site_status_update' => 'Nagawa ang pag-update sa estado ng domain',
    'actionlog__event_site_dns_update' => 'Nagawa ang pag-update sa domain DNS zone',
    'actionlog__event_site_guid_update' => 'Nagawa ang pag-update sa domain GUID',

    'actionlog__event_site_subdomain_create' => 'Nalikha ang subdomain',
    'actionlog__event_site_subdomain_delete' => 'Nabura ang subdomain',
    'actionlog__event_site_subdomain_update' => 'Nagawa ang pag-update sa subdomain',

    'actionlog__event_site_alias_create' => 'Nalikha ang domain alias',
    'actionlog__event_site_alias_delete' => 'Nabura ang domain alias',
    'actionlog__event_site_alias_update' => 'Nagawa ang pag-update sa domain alias',

    'actionlog__event_site_alias_dns_update' => 'Nagawa ang pag-update sa DNS zone ng domain alias',
    'actionlog__event_subdomain_dns_update' => 'Nagawa ang pag-update sa DNS zone ng subdomain sa ilalim ng default domain',
    'actionlog__event_site_subdomain_dns_update' => 'Nagawa ang pag-update sa DNS zone ng alyas ng subdomain',
    // End of PfW only

    'win_policy__bad_password' => 'Nabigo ang pagpapatotoo. Ang password ay hindi wasto',
    'win_policy__password_too_short' => 'Nabigo ang pagpapatotoo. Ang password ay hindi nasunod ang mga kailangan sa patakaran sa password dahil it ito ay masyadong maikli.',
    'win_policy__password_too_long' => 'Nabigo ang pagpapatotoo. Ang password ay hindi nasunod ang mga kailangan sa patakaran sa password dahil ito ay masyadong mahaba.',
    'win_policy__password_not_complex_enough' => 'Nabigo ang pagpapatunay. Hindi sapat ang pagiging kumplikado ng password at hindi natutugunan ang mga kinakailangan sa patakaran ng password. Ang malalakas na password ay dapat maglaman kahit man lang ng lahat ng mga sumusunod: walong character; isang upper- o lowercase character; tatlong numero at isang espesyal na character (!, @, #, $,%, ^, &, *,?, _, ~) o isang numero at dalawang espesyal na character.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Hindi ma-update ang lisensya ng produkto.',


    'filemanager__error_path_is_not_allowed' => 'Hindi pinapayagan ang path',
    'filemanager__error_path_is_invalid' => 'Hindi wasto ang path',
    'filemanager__error_path_not_found' => 'Walang natagpuang path',
    'filemanager__error_path_already_exists' => 'Mayroon nang umiiral na path',
    'filemanager__error_access_is_denied' => 'Tinanggihan ang pag-access',
    'filemanager__error_directory_not_empty' => 'May laman ang folder.',
    'filemanager__error_sharing_violation' => 'Paglabag sa sharing',
    'filemanager__error_not_same_device' => 'Ang destination path ay wala sa parehong kagamitan',
    'filemanager__unable_to_resolve_realpath' => "Hindi mahanap ang file na %1 sa nasabing lokasyon",
    'filemanager__access_to_realpath_denied' => "Hindi pinayagan ang access sa realpath: %1 sa %2.",
    'bt_exit' => 'Labas',

    'filemanager__copy_error__' => "Hindi makopya ang %1 sa %2: %3",
    'filemanager__copy_move' => "Kopyahin (ilipat) ang mga file mula sa %1",
    'filemanager__count_size__' => 'Pagpipilian na sukat: %1',
    'filemanager__count_size_error__' => 'Hindi makalkula ang sukat para sa %1: %2',
    'filemanager__create_dir_error__' => "Hindi makalikha ng direktoryo sa %1: %2",
    'filemanager__dir_not_exists' => "Walang direktoryo na %1 na umiiral.",
    'filemanager__dirname' => "Pangalan ng direktoryo",
    'filemanager__filename' => "Pangalan ng File",
    'filemanager__is_no_such' => "Walang file o direktoryo na may pangalan na %1",
    'filemanager__empty_selection' => "Hindi (mga) file pinili.",
    'filemanager__move_error__' => "Hindi malipat ang %1 sa %2: %3",
    'filemanager__not_allowed' => "Hindi ka pinapayagan na palitan ang mga pahintulot sa file na ito.",
    'filemanager__remove' => "Alisin ang file mula sa %1",
    'filemanager__remove_error__' => "Hindi maalis ang file sa %1: %2",
    'filemanager__set_win_permissions_dir' => "Maglagay ng pahintulot para sa %1 na folder",
    'filemanager__set_win_permissions_file' => "Maglagay ng pahintulot para sa %1 na file",
    'filemanager__touch_confirm' => "Nakasisiguro ka ba na gusto mong baguhin ang timestamp ng mga piniling file?",
    'filemanager__upload_error__' => "Hindi ma-upload ang %1 sa %2: %3",
    'filemanager__upload_file' => "Mag-upload ng file",
    'filemanager__upload_file_src' => "Path sa file",
    'filemanager__max_image_size_exceeded' => 'Hindi maipakita ang imahe. Ang sukat ng imahe ay hindi maaaring lumabis sa %2 bytes.',

    '__fastcgi_unix_support' => 'Suporta sa FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Ang DNS record nitong subdomain ay nakaimbak sa parent DNS zone. Maari mong baguhin ang parent zone %1 o gumawa ng magkahiwalay na zone para sa subdomain.',
    'dns__subdomain_dns_zone_parent_link' => 'dito',
    'dns__no_dns_zone' => 'Walang anumang DNS zone ang nakatakda sa domain. Upang pangasiwaan ang DNS zone para sa iyong domain kailangan mong pindutin ang \'Restore ang Default\' na button.',
    'dns__unable_turn_on_subdomain_zone' => 'Hindi mailipat sa zone ng subdomain dahil may CNAME record para sa subdomain na ito sa kanyang zone ng parent domain.',

    '__hosting_write_modify' => 'Karagdagang mga pahintulot ng write/modify',

    'aspdotnet__group_framework_version' => "Bersyon ng Framework",

    'bt_restore_default' => "Itakda sa Default",
    'b_autoinstaller' => 'Gumawa ng pag-update sa Plesk o kaya ang mga component nito.',
    'b_autoinstaller_configure' => 'Mga setting ng pag-update.',
    'b_autoinstaller_install' => 'Gumawa ng pag-install ng mga napiling mga component.',

    '__iis_app_pool__use_dedicated' => 'Nakalaang IIS application pool',
    '__iis_app_pool__use_dedicated_addons' => 'Tinalagang IIS Application Pool para sa bawat Website',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'I-enable ang 32-bit na application',
    '__iis_app_pool__load_user_profile' => 'I-load ang profile ng user',
    'bt_iis_app_pool' => "IIS application pool",

    'performance__cpu_usage' => 'Pinakamataas na paggamit ng CPU (%)',
    'performance__cpu_usage_action' => 'Limitahan ang aksyon',
    'performance__cpu_usage_interval' => 'Pagitan ng limitasyon (minuto)',
    'performance__cpu_usage_action_not_supported' => 'Ang tinutukoy na aksyon ay hindi suportado ng web server.',

    'performance__idle_timeout_action_not_supported' => 'Ang tinutukoy na aksyon na idle timeout ay hindi suportado ng web server.',
    'performance__max_worker_processes' => 'Ang pinakamataas na bilang ng proseso ng manggagawa',
    'performance__idle_timeout' => 'Idle timeout (minuto)',
    'performance__idle_timeout_action' => 'Aksyon ng idle timeout',
    'performance__recycling_by_time' => 'Nagre-resiklo sa karaniwang pagitan ng oras (minuto)',
    'performance__recycling_by_requests' => 'Mag-resiklo kapag ang pinakamataas na bilang ng kahilingan ay naabot',
    'performance__recycling_by_virtual_memory' => 'Mag-resiklo kapag ang pinakamataas na bilang ng virtual na memory ay nagamit.',
    'performance__recycling_by_private_memory' => 'Mag-resiklo kapag ang pinakamataas na bilang ng pribadong memorya ay nagamit.',
    'performance__managed_pipeline_mode' => 'Pinangasiwaang mode ng pipeline',
    'performance__managed_pipeline_mode_not_supported' => 'Ang tinukoy na mode ay hindi suportado ng web server.',

    'iis_app_pool' => 'Pangasiwaan ng IIS application pool.',
    'b_iis_app_pool' => 'Pangasiwaan ang IIS application pool.',
    'iis_app_pool_cl_dom' => 'Pangasiwaan ng IIS application pool.',

    'bt_protect' => 'Protektahan',
    'bt_unprotect' => 'Alisin ang Proteksyon',
    'bt_show_additional_users' => 'Ipakita ang mas maraming mga user',
    'bt_hide_additional_users' => 'Ipakita ang mas kaunting mga user',
    'error_doc__code_400' => 'Maling Request',
    'error_doc__code_401' => 'Hindi pinahihintulutan',
    'error_doc__code_401.1' => 'Hindi pinahihintulutan - Nabigo ang Login',
    'error_doc__code_401.2' => 'Hindi pinahihintulutan - Nabigo ang Login dahil sa konpigurasyon ng server',
    'error_doc__code_401.3' => 'Hindi pinahihintulutan - Hindi pinahihintulutan dahil sa ACL sa resource',
    'error_doc__code_401.4' => 'Hindi pinahihintulutan - Nabigo ang pahintulot dahil sa filter.',
    'error_doc__code_401.5' => 'Hindi pinahihintulutan - Nabigo ang pahintulot dahil sa ISAPI/CGI app',
    'error_doc__code_401.7' => 'Hindi pinahihintulutan - Nabigo ang pahintulot dahil sa patakaran sa pahintulot ng URL',
    'error_doc__code_403' => 'Ipinagbabawal',
    'error_doc__code_403.1' => 'Ipinagbabawal - Hindi pinayagan ang paggawa ng pag-access',
    'error_doc__code_403.2' => 'Ipinagbabawal - Hindi pinayagan ang pag-access ng Read',
    'error_doc__code_403.3' => 'Ipinagbabawal - Hindi pinayagan ang pag-access ng Write',
    'error_doc__code_403.4' => 'Ipinagbabawal - Kailangan ng SSL',
    'error_doc__code_403.5' => 'Ipinagbabawal - Kailangan ng SSL 128',
    'error_doc__code_403.6' => 'Ipinagbabawal - Hindi tinanggap ang IP address',
    'error_doc__code_403.7' => 'Ipinagbabawal - Kailangan ang sertipiko ng kliyente',
    'error_doc__code_403.8' => 'Ipinagbabawal - Hindi pinayagan ang pag-access sa site',
    'error_doc__code_403.9' => 'Ipinagbabawal - Masyadong maraming mga user',
    'error_doc__code_403.10' => 'Ipinagbabawal - Hindi wastong konpigurasyon',
    'error_doc__code_403.11' => 'Ipinagbabawal - Nagpalit ang password',
    'error_doc__code_403.12' => 'Ipinagbabawal - Hindi pinayagan ang pag-access ng Mapper',
    'error_doc__code_403.13' => 'Ipinagbabawal - Napawalang-bisa ang sertipiko ng kliyente',
    'error_doc__code_403.14' => 'Ipinagbabawal - Hindi pinayagan ang paglista ng direktoryo',
    'error_doc__code_403.15' => 'Ipinagbabawal - Lumampas ang lisensya sa pag-access ng kliyente',
    'error_doc__code_403.16' => 'Ipinagbabawal - walang tiwala sa o maling porma na sertipiko ng kliyente',
    'error_doc__code_403.17' => 'Ipinagbabawal - Wala nang bisa ang sertipiko ng kliyente o wala ng pang bisa',
    'error_doc__code_403.18' => 'Ipinagbabawal - Hindi maisagawa ang kahilingan mula sa application pool',
    'error_doc__code_403.19' => 'Ipinagbabawal - Hindi pinayagan ang pag-access ng CGI',
    'error_doc__code_403.20' => 'Ipinagbabawal - Nabigo ang pag-login ng passport',
    'error_doc__code_404' => 'Hindi nahanap',
    'error_doc__code_404.2' => 'Hindi nahanap - Hindi pinayagan dahil sa patakaran ng lockdown',
    'error_doc__code_404.3' => 'Hindi nahanap - Hindi pinayagan dahil sa patakaran ng MIMEMAP',
    'error_doc__code_405' => 'Hindi maaari ang paraan',
    'error_doc__code_406' => 'Hindi katanggap-tanggap',
    'error_doc__code_407' => 'Kailangan ang pagpapatunay sa proxy',
    'error_doc__code_408' => 'Request timeout',
    'error_doc__code_412' => 'Nabigo ang precondition',
    'error_doc__code_414' => 'Masyadong mahaba ang Hinihiling-URL',
    'error_doc__code_415' => 'Hindi suportadong uri ng media',
    'error_doc__code_431' => 'Request header fields too large',
    'error_doc__code_500' => 'Panloob na error ng server',
    'error_doc__code_500.12' => 'Panloob na error ng server - Simulang muli ang application',
    'error_doc__code_500.13' => 'Panloob na error ng server - Masyadong abala ang server',
    'error_doc__code_500.15' => 'Panloob na error ng server - Ipinagbabawal ang direktang mga kahilingan para sa GLOBAL.ASA',
    'error_doc__code_500.16' => 'Panloob na error ng server - error sa pag-access ng UNC',
    'error_doc__code_500.17' => 'Panloob na error ng server - Hindi mahanap ang URL authorization store',
    'error_doc__code_500.18' => 'Panloob na error ng server - Hindi mabuksan ang URL authorization store',
    'error_doc__code_500.19' => 'Panloob na error ng server - bad file ng metadata',
    'error_doc__code_500.100' => 'Panloob na error ng server - error sa ASP',
    'error_doc__code_501' => 'Hindi naipatupad',
    'error_doc__code_502' => 'Maling gateway',
    'error_doc__code_503' => 'Ang serbisyo ay pansamantalang hindi magagamit',

    'mimetype_edit__already_exists' => 'Tinukoy na ang uri ng MIME na para sa extensyon na ito.',
    'mimetype_edit__not_exists' => 'Ang uri ng MIME ay hindi umiiral.',

    'php__group_php_version' => "Bersyon ng PHP",

    'virtualdir__path' => 'Path',
    'virtualdir__read' => 'Basahin ang pahintulot',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Isulat ang pahintulot',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Pag-access sa source script',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Mag-browse sa direktoryo',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Gawin ang pahintulot',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Mga log visit',
    'virtualdir__app_create' => 'Lumikha ng application',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Mga switch sa hindi kilalang pagpapatunay.',
    'virtualdir__auth_windows' => 'Mga switch sa Windows na pagpapatunay.',
    'virtualdir__auth_not_enabled' => 'Hindi kilala o Windows na pagpapatunay ay kinakailangang nakabukas.',
    'virtualdir__require_ssl' => 'Kailangan ng SSL/TLS',
    'virtualdir__enable_default_doc' => 'Gumamit ng default na mga dokumento',
    'virtualdir__default_doc' => 'Search order ng mga default na dokumento',
    'virtualdir__enable_parent_paths' => 'Payagan na gumamit ng parent paths',
    'virtualdir__execute_in_mta' => 'Payagan ang pagtanggal ng application sa MTA (multi-threaded apartment)mode',
    'virtualdir_create__title' => 'Lumikha ng virtual na direktoryo sa %1',
    'virtualdir_edit__title' => 'Mga katangian ng virtual na direktoryo %1',
    'virtualdir_edit__legend' => 'Virtual na direktoryo',
    'virtualdir_edit__application_legend' => 'Mga setting ng application',
    'virtualdir_edit__security_legend' => 'Seguridad ng direktoryo',
    'virtualdir_edit__documents_legend' => 'Mga dokumento',
    'virtualdir_edit__list_legend' => 'Nested na virtual na direktoryo',
    'virtualdir_error__path_not_in__' => 'Hindi wastong path ang tinukoy',
    'virtualdir_root' => 'Virtual na mga direktoryo',
    'virtualdir_root__title' => 'Virtual na mga direktoryo',
    'virtualdir_root__list_legend' => 'Virtual na mga direktoryo',
    'virtualdir_se__none' => 'Wala',
    'virtualdir_se__script' => 'Mga script lamang',
    'virtualdir_se__script_execute' => 'Mga Script at mga Executable',
    'virtualdirs__title' => 'Virtual na mga direktoryo',
    'virtualdirs__path_not_exists' => 'Invalid na path.',
    'virtualdirs__select_for_remove' => "Piliin ang mga aalisin na virtual na mga direktoryo.",
    'virtualdirs_remove__title' => 'Alisin ang mga virtual na direktoryo',

    'asp_max_buffer_text' => 'Pinakamalaki na ASP buffer (KB)',
    'asp_max_body_text' => 'Pinakamalaki na entity body ng isang ASP request (KB)',
    'asp_buffers_legend' => 'Mga setting ng ASP',
    'asp_client_debug_text' => 'Paganahin ang ASP client-side script debugging',
    'asp_server_debug_text' => 'Paganahin ang ASP server-side script debugging',

    'permissions__group_or_user_name' => 'Pangalan ng grupo o mga user name',
    'permissions__FullControl' => 'Buong Kontrol',
    'permissions__Modify' => 'Baguhin',
    'permissions__ReadAndExecute' => 'Basahin & Ipatupad',
    'permissions__ListFolderContents' => 'Mga Nilalaman ng Listahan ng Folder',
    'permissions__Read' => 'Basahin:',
    'permissions__Write' => 'Magsulat',
    'permissions__ReadControl' => 'Basahin ang Kontrol',
    'permissions__WriteControl' => 'Isulat ang kontrol',
    'permissions__ExecuteControl' => 'Ipatupad ang Kontrol',
    'permissions__TraverseFolderOrExecuteFile' => 'Bagtasin ang Folder / Ipatupad ang file',
    'permissions__ListFolderOrRead' => 'Listahan ng Folder / Basahin ang Data',
    'permissions__CreateFilesOrWrite' => 'Lumikha ng mga File / Magsulat ng Data',
    'permissions__CreateFoldersOrAppend' => 'Lumikha ng mga folder / idugtong ng Data',
    'permissions__DeleteSubfoldersandFiles' => 'Burahin ang mga subfolder at mga file',
    'permissions__Delete' => 'Burahin (Delete)',
    'permissions__ChangePermissions' => 'Baguhin ang Mga Pahintulot',
    'permissions__TakeOwnership' => 'Gawain ang Pagmamay-ari',
    'permissions__inherited_from' => 'Minana mula',
    'permissions__not_inherited' => '<Hindi namana>',
    'permissions__apply_to' => 'Ipairal sa',
    'permissions__apply_onto' => 'Ipataw sa:',
    'permissions__apply_onto1' => 'Ang folder na ito lamang',
    'permissions__apply_onto2' => 'Subfolders lamang',
    'permissions__apply_onto3' => 'Itong folder at mga subfolder',
    'permissions__apply_onto4' => 'Mga file lamang',
    'permissions__apply_onto5' => 'Itong folder at mga file',
    'permissions__apply_onto6' => 'Mga subfolder at mga file lamang',
    'permissions__apply_onto7' => 'Itong folder at mga subfolder, at mga file',

    'filemanager__not_allowed_dir' => "Hindi ka pinapayagan na palitan ang pahintulot sa folder na ito.",

    'filemanager__allow' => "Payagan",
    'filemanager__deny' => "I-deny",
    'filemanager__user_domusr' => 'Administrador ng website',
    'filemanager__user_webusr' => 'Web user',
    'filemanager__user_admins' => 'Mga administrador',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'User ng ASP.NET',
    'filemanager__user_poolusr' => 'User ng application pool',
    'filemanager__user_sysaccount' => 'Karagdagang user ng system',

    'bt_permissions_advanced' => 'Nanguna',
    'b_permissions_advanced' => 'I-kli upang ma view at maitakda ang espesyal na mga pahintulot.',

    'hotlink-protection_invalid_friend_domain' => 'Invalid na pangalan para sa tinatanggap na domain.',
    'hotlink-protection_duplicate_friend_domain' => 'Duplicate na pangalan para sa tinatanggap na domain.',
    'hotlink-protection_invalid_extensions' => 'Naglalaman ng mga maling character ang mga extension ng file.',

    'i_domain_alias_status_on' => 'Ang domain alias ay may-bisa.',
    'i_domain_alias_status_off' => 'Ang domain alias ay pinawalang-bisa.',
    'i_domain_alias_status_with_parent' => 'Ang domain alias ay pinawalang-bisa dahil ang domain ay nakapatay.',
    'i_domain_alias_turn_off' => 'I-klik para ipawalang-bisa.',
    'i_domain_alias_turn_on' => 'I-klik para magka-bisa.',

    'domain_alias__control_title' => 'Domain alias %1',
    'domain_alias__control_info_legend' => 'Datos',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Pangalan ng serbisyo',
    'domain_alias__control_details_title' => 'Mga detalye',

    'domain_alias__invalid_values' => 'Ang domain name na iyong tinukoy ay hindi wasto. Ang mga domain name ay maaring maglaman ng mga letra, numero at mga gitling. Bawat bahagi ng domain name sa pagitan ng tuldok ay hindi dapat mas mahaba sa 63 na mga simbolo.',
    'domain_alias__domain_already_exists' => "Mali na pangalan ng domain alias na %1. Mayroon nang domain %1 na umiiral.",
    'domain_alias__www_prefix_domain_already_exists' => "Hindi wasto ang pangalan ng domain alias na www.%1. Ang alyas na ito ay mayroon nang nalikha para sa domain %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Hindi wasto ang pangalan ng domain alias na webmail.%1. Ang alyas na ito ay mayroon nang nalikha para sa domain %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Hindi wasto ang mga pangalan sa listahan ng domain alias.%1. Ang alyas na ito ay mayroon nang nalikha para sa domain %1.',
    'domain_alias__dns_record_already_exists' => 'Hindi magawa ang domain alias %1 dahil ang DNS record na nakaturo sa host %1 ay mayroon nang umiiral.',
    'domain_alias__domain_alias_already_exists' => "Mayroong nang umiiral domain alias na may nasabing pangalan.",
    'domain_aliases__mail_server_not_support_aliases' => 'Hindi sinusuportahan ng mail server ang mga katangian ng mga alyas ng domain. Maaring hindi gumagana ng maayos ang mga alyas ng domain.',
    'domain_alias__restrict_domain_creation' => 'Ang tinukoy na pangalan para sa domain alias ay ipinagbawal ng patakaran ng server-wide. Kung ikaw ang may-ari ng domain name alias na ito, makipag-ugnay sa iyong hosting provider.',
    'domain_alias__restrict_creation_with_www' => 'Mangyaring magpasok ng isang domain name na walang \'www\' na unlapi. Ang unlapi na www para sa domain ay awtomatikong idinagdag sa konpigurasyon ng web server.',
    'domain_unable_to_set_name' => 'Maling pangalan na %1.',

    'domain_alias__domain_service_dns_disabled' => 'Ang domain na ito ay pinagsisilbihan ng ibang DNS server.',
    'domain_alias__domain_service_dns_enabled_master' => 'Nagsisilbi ang DNS server na ito bilang pangunahing name server para sa DNS zone na ito.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Nagsisilbi ang DNS server na ito bilang pangalawang name server para sa DNS zone na ito.',
    'domain_alias__domain_service_mail_enabled' => 'Ang serbisyo ng mail ay binuhay para sa domain.',
    'domain_alias__domain_service_mail_disabled' => 'Ang serbisyo ng mail ay pinatay para sa domain.',
    'domain_alias__domain_service_mail_mx' => '%1 ang nagamit bilang mail server.',

    'domain_alias__service_seoRedirect_hint' => 'Kapag binuksan ng bisita ang alyas ng URL, sila ay na-redirect sa URL ng pangunahing domain. Ang Plesk ay gumagamit ng search engine-friendly HTTP 301 redirection, na nangangahulugan na ang ranking sa search engine ay hindi mahahati sa pagitan ng mga URL.',

    'bt_task_run_now' => 'Patakbuhin Ngayon',
    'ftp__read_perm' => "Basahin ang pahintulot",
    'ftp__write_perm' => "Isulat ang pahintulot",

    'filemanager__upload_backup_file_hint' => 'Dito maaari mong i-upload ang mga backup file sa imbakan ng Plesk. Ang pinakamataas na laki ng file ay limitado sa dalawang gigabytes.',

    '__default_for_mssql' => 'default para sa MS SQL',

    '__login_does_not_pass_validation' => "Ang username ay hindi tama. Siguraduhin na nasunod ang mga sumusunod na mga kailangan: %1",
    '__login_allowed_symbols' => 'Tanging alphanumeric na karakter kasama ang mga period, dash, at underscore ang pinapayagan. Ang unang karakter ay dapat na alphanumeric.',

    'restart__nginx' => 'Reverse Proxy Server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Gusto kong makatanggap ng pangkalahatang impormasyon sa produkto at mga anunsyo mula sa Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Gusto kong makatanggap ng impormasyon tungkol sa seguridad at ibang mga teknikal na mga abiso mula sa Plesk.",

    '__login_status_inactive' => 'Ang iyong account ay hindi-aktibo. Kontakin ang administrador ng Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Bumalik sa pahina ng mga setting ng Tools & Settings. Ang paglilipat ay ipagpapatuloy sa paligid.',

    'chk_js__warning_about_ftp_login_syntax' => "Maari kang gumamit ng alphanumeric, mga simbolo na patlang(dash) at underscore sa username.",
    'chk_js__warning_about_passwd_syntax' => "Huwag gumamit ng mga panipi, space, at pambansang character sa alpabeto sa password.\nMula %1 hanggang %2 (na) character dapat ang haba ng password, at hindi dapat nito nilalaman ang username.",
    'chk_js__warning_about_plesk_login_syntax' => "Maaari mong gamitin ang lowercase na mga simbolong alphanumeric, tuldok, gitling, at salungguhit sa username.",
    'chk_js__warning_about_admin_passwd_syntax' => "Huwag gumamit ng mga quote, espasyo, puntó't koma(semi colon) at karakter ng nasyonal na alpabeto sa password.\nAng password ay dapat nasa pagitan ng %1 at %2 na mga karakter ang kahabaan, at ito ay dapat hindi naglalaman ng username.",

    'cmd_server__admin_alias_not_found' => "Hindi mahanap ang karagdagang account ng administrator.",

    'panel_branding__skins_already_exists' => "Tandaan: Ang tema na '%1' ay umiiral. Ito ay mapapalitan ng tema na kasalukuyan mong ini-install.",
    'panel_branding__skins_file_exists' => "Hindi makagawa ng direktoryo para sa temang '%1': May umiiral nang file na may ganoong pangalan.",

    'actionlog__login_failed' => 'nabigong mag-log in',
    'actionlog__event_cp_user_login_failed' => 'Nabigong maka-log in ang user ng Plesk',
    'actionlog__api_login_failed' => 'hindi naka-log gamit ang API',
    'actionlog__event_cp_user_api_login_failed' => 'Nabigong maka-log in ang user ng Plesk gamit ang API',
    'actionlog__pw_reset' => 'hiniling na pag-reset ng password',
    'actionlog__pw_admin_force_reset' => 'humiling ng sapilitang pag-reset ng password ng admin',

    'ch_pass_admin__email_subject' => "Paalala sa password sa Plesk",
    'ch_pass_admin__email_body' => "Kumusta, %1.\n\nHindi puwedeng ipadala ang password ng administrator sa email dahil sa seguridad.\n\nPara mag-log in bilang 'admin', gamitin ang command na 'plesk login'.\n\nPara magtakda ng bagong password ng 'admin', gamitin ang command na 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Hindi maipadala ang email: %1',

    'ch_pass_by_secret__email_subject' => "Paalala sa password sa Plesk",
    'ch_pass_by_secret__email_body' => "Kumusta %2,\n\nPara mag-set up ng bagong password, sundin ang link: %1\n\nIyong login: %3",
    'ch_pass_by_secret__message_send_error' => 'Hindi maipadala ang sikretong code: %1',
    'ch_pass_by_secret__title' => 'Baguhin ang iyong password',
    'ch_pass_by_secret__secret' => 'Sikretong code',

    'custom_button__noframe' => "Huwag gumamit ng mga frame",

    'custom_button__internal_hint' => 'Tukuyin kung bubuksan ang URL sa pahina ng Plesk o sa isang bagong browser ng window.',
    'custom_button__noframe_hint' => 'Kung ikaw ay magdadagdag ng isang custom na buton na tutungo sa extensyon ng Plesk o isang app na nasa Customer Panel, maaari mong tukuyin kung paano ipapakita ang extensyon/app na ito: sa frame o sa bahagi ng GUI ng Plesk.',


    'actionlog__patch' => 'Pag-Update',
    'actionlog__patch_available' => 'makukuha',
    'actionlog__event_patch_available' => 'Makukuha na mga pag-update:',
    'actionlog__patch_installed' => 'naka-install',
    'actionlog__event_patch_installed' => 'Na-install ang pag-update',

    'actionlog__extension' => 'Extensyon',
    'actionlog__extension_status' => 'Status ng extension',
    'actionlog__cloning' => 'Pag-clone ng server',
    'actionlog__cloning_complete' => 'tapos na',
    'actionlog__event_cloning_complete' => 'Tapos na ang pag-clone ng server',

    'actionlog__ssl_web_binding' => 'SSL/TLS certificate sa domain',
    'actionlog__ssl_web_binding_update' => 'Itinalaga/inalis sa pagkakatalaga',
    'actionlog__event_ssl_web_binding_update' => 'Itinalaga/inalis sa pagkakatalaga ang SSL/TLS certificate sa domain',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS certificate sa webmail',
    'actionlog__ssl_web_mail_binding_update' => 'Itinalaga/inalis sa pagkakatalaga',
    'actionlog__event_ssl_web_mail_binding_update' => 'Itinalaga/inalis sa pagkakatalaga ang SSL/TLS certificate sa webmail',

    'actionlog__ssl_mail_binding' => 'SSL/TLS certificate sa mail server',
    'actionlog__ssl_mail_binding_update' => 'Itinalaga/inalis sa pagkakatalaga',
    'actionlog__event_ssl_mail_binding_update' => 'Itinalaga/inalis sa pagkakatalaga ang SSL/TLS certificate sa mail server',

    'actionlog__ssl_panel_binding' => 'SSL/TLS certificate sa Plesk',
    'actionlog__ssl_panel_binding_update' => 'Itinalaga/inalis sa pagkakatalaga',
    'actionlog__event_ssl_panel_binding_update' => 'Itinalaga/inalis sa pagkakatalaga ang SSL/TLS certificate sa Plesk',

    'actionlog__hostname' => 'Hostname ng server',
    'actionlog__hostname_changed' => 'binago',

    'actionlog__smb_user' => 'Karagdagang user',
    'actionlog__smb_user_create' => 'Gumawa ng karagdagang user',
    'actionlog__smb_user_delete' => 'Na-delete ang karagdagang user',
    'actionlog__smb_user_update' => 'Na-update ang karagdagang user',

    'actionlog__event_mail_management_status_update' => 'Update sa katayuan ng pamamahala ng mail',
    'actionlog__mail_management' => 'Status ng pamamahala ng mail',
    'actionlog__mail_management_status_update' => 'pag-update',

    'virtualization_openvz' => 'OpenVZ',

    'passwordSecurityLevelCheckFailed' => 'Ang iyong password ay hindi sapat na komplikado. Ayon sa patakaran ng server, ang pinakamaikli na lakas ng password ay %1. Para pabutihin ang lakas ng password, gumamit ng mga numero, malaki at maliliit sa titik na karakter, at espesyal na karakter katulad na !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Masyadong mahina',
    'passwordSecurityLevelCheckFailedWeak' => 'Mahina',
    'passwordSecurityLevelCheckFailedMediocre' => 'Katamtaman',
    'passwordSecurityLevelCheckFailedStrong' => 'Malakas',
    'passwordSecurityLevelCheckFailedStronger' => 'Napakalakas',

    'dns__dns_default_ipv4_modified' => 'Isasaalang-alang ang mga tala sa IP address na ito bilang user-modified at hindi isasabay sa server-wide DNS na template.',
    'dns__dns_default_ipv6_modified' => 'Isasaalang-alang ang mga tala sa IP address na ito bilang user-modified at hindi isasabay sa server-wide DNS na template.',

    'dns__view_dns_record_master_title' => 'Tinitingnan ang Resource Records',
    'dns__view_dns_record_off_title' => 'Tinitingnan ang Nameserver Records',
    'dns__view_dns_record_slave_title' => 'Tinitingnan ang Primary DNS Server Records',

    'dns_unable_to_resolve_hostname' => "Hindi maisaayos ang hostname \"%1\": %2Tiyakin na ang DNS resolver ng operating system ay maayos na naka-set up at gumagana.",

    'no_database_server_available' => 'Walang magamit na mga database server para sa suskrisyon na ito.',

    'database_used_by_application_can_not_be_moved' => 'Hindi nagawang ilipat ang database: Ginagamit ng isang application ng website ang database na ito.',
    'database_user_update_orphaned_is_restricted' => 'Ipinagbabawal ang pag-update ng naulila na mga user account ng database. Maaari ka lamang magbura o magkumpuni ng mga ito.',

    'database_unable_to_get_max_filesize_default_message' => 'Hindi matukoy ang pinakamataas na laki ng file ng database: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Hindi nagawang itakda ang pinakamataas na laki ng file ng database: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Hindi matukoy ang pinakamataas na laki ng log file ng database: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Hindi nagawang itakda ang pinakamataas na laki ng log file ng database: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Hindi matukoy ang kasalukuyang limitasyon sa sukat ng file na Microsoft SQL database \'%1\'. Imposible ang pagtatakda ng isang bagong limitasyon.',
    'database_unable_to_set_max_filesize' => 'Hindi maitakda ang limitasyon para sa laki ng file ng Microsoft SQL database na \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Hindi matukoy ang kasalukuyang limitasyon sa laki ng file ng talaan ng Microsoft SQL database \'%1\'. Imposible ang pagtatakda ng isang bagong limitasyon.',
    'database_unable_to_set_max_log_filesize' => 'Hindi maitakda ang limitasyon para sa laki ng file ng log ng Microsoft SQL database na \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Hindi malikha ang Microsoft SQL database na \'%1\': Ang laki nito na file ay mas malaki kaysa sa pinakamataas na pinapayagang laki.',
    'database_unable_to_move_because_max_filesize' => 'Hindi nagawang ilipat ang Microsoft SQL database na \'%1\': Ang laki nito na file ay mas malaki kaysa sa pinakamataas na pinapayagang laki. %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Hindi malikha ang Microsoft SQL database na \'%1\': Ang laki nito na log file ay mas malaki kaysa sa pinakamataas na pinapayagang laki.',
    'database_unable_to_move_because_max_log_filesize' => 'Hindi nagawang ilipat ang Microsoft SQL database na \'%1\': Ang laki nito na log file ay mas malaki kaysa sa pinakamataas na pinapayagang laki. %2.',
    'database_unable_to_restore_because_max_filesize' => 'Hindi magawang ibalik ang Microsoft SQL database na \'%1\': Ang laki nito na file ay mas malaki kaysa sa pinakamataas na pinapayagang laki.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Nakarehistro ang isang kaparehong MS SQL server sa Plesk. Mangyaring tukuyin ang isa pang MS SQL server bilang isang sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Nakarehistro na ang isang kaparehong sandbox MS SQL server sa Plesk. Mangyaring tukuyin ang isa pang MS SQL server bilang isang sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Hindi makakonekta sa server sa pamamagitan ng \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Ang katangian %1 ay hindi suportado ng sumusunod na service nodes: %2. Hindi papaganahin ang katangian na ito para sa lahat ng mga object na ginawa sa mga node na ito.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Ang katangian %1 ay hindi suportado ng server na ito: Hindi papaganahin ang katangian na ito para sa lahat ng mga na-restore na mga object.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Ang component na %1 ay hindi na-install. Hindi ito available para sa mga sumusunod na website: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Ang component na %1 ay hindi na-install. Ito ay mapapalitan ng %2 para sa mga sumusunod na mga website: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Hindi sinusuportahan ng mga kasalukuyang bersyon ng Plesk ang mga username na may tuldok (.) na karakter. Hindi mare-restore ang mga kustomer at mga reseller na may nasabing username.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Hindi mahanap ang backup file na may datos para sa %1 %2. Hindi mare-restore ang datos para sa %1 %2.',

    'bu_conflict_resolver_zone_master_removed' => "Hindi ma-restore ang pangunahing DNS record: Ang record sa pangalawang zone ay tumutukoy sa kasalukuyang IP address na %1. Aalisin ang pangunahing DNS record sa pangalawang zone.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Support for HTTPS DNS records is turned off. HTTPS records will not be restored for the following domains: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => 'Hindi suportado ang %1.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => 'Hindi suportado ang %1. Hindi ito available para sa mga sumusunod na website: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Ang component na %1 ay hindi na-install.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Hindi ito available para sa mga sumusunod na service node: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Hindi ito available para sa mga sumusunod na object: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Ang sumusunod na mga database server ay hindi maaring magamit sa server na ito: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'Smarthost management is not supported. The smarthost settings will not be restored.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Itatago ang MS SQL database backup file sa MS SQL native format, na maaring itago lamang sa lokal na MS SQL server o sa isang remote na MS SQL server na may ganap na nakonpigura na setting sa backup. Hindi naitago ang ilan sa iyong mga database dahil walang akmang MS SQL server na nakarehistro sa Plesk. Apektado ang mga sumusunod na domain: {{objects}}. Makipag-ugnayan sa iyong hosting provider.',

    'bu_conflict_resolver_not_available_webmail' => 'Ang webmail service %1 ay hindi magagamit. Ito ay mapapalitan ng %2 para sa mga sumusunod na mga object: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Ang webmail service %1 ay hindi magagamit. Ito ay mapapalitan ng %2 para sa mga sumusunod na mga plano ng serbisyo: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Hindi sinusuportahan ng mga databases ng '%1' na uri sa mga user name na tumutugma sa mga pangalan sa database. Papalitan ang pangalan ng user na '%2' bilang '%3' para sa database na '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Hindi nailagay ang limitasyon ng pagamit sa disk space sa konpigurasyon ng destination server. Ang marka ng setting na ito ay papalitan ng "Unlimited".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Hindi nailagay ang limitasyon sa bilang ng mga koneksyon sa konpigurasyon ng destination server. Ang marka ng setting na ito ay papalitan ng "Unlimited".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Hindi nailagay ang limitasyon sa pagamit ng trapiko sa konpigurasyon ng destination server. Ang marka ng setting na ito ay papalitan ng "Unlimited".',
    'cu__pleskrestore_backup_file_extracted' => 'Ang backup file ay na-extract sa "%1".',
    '__mod_bw_not_supported' => 'Ang modulo ng mod_bw para sa Apache web server ay hindi suportado dahil sa konpigurasyon ng file ng system. Ang limitasyon sa paggamit ng trapiko at pinakamataas na bilang ng koneksyon ay hindi gagana.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Hindi suportado ang POP3 authorization para sa mail relaying, sa halip ay gagamitin ang POP3 bago ang SMTP authorization. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Plano ng serbisyo \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => 'Hindi suportado ang %1. Ito ay mapapalitan ng %2 para sa mga sumusunod na mga plano ng serbisyo: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => 'Hindi suportado ang %1. Ito ay mapapalitan ng %2 para sa mga sumusunod na mga website: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Hindi nakita ang mga sumusunod na mga object sa backup file: %1',
    'bu_conflict_resolver_absent_domains' => 'Hindi ma-restore ang iba sa mga object dahil sila ay kabilang sa mga sumusunod na domain na hindi nakikita sa Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Hindi ma-restore ang iba sa mga website dahil sila ay kabilang sa mga sumusunod na mga parent domain na hindi nakikita sa Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Hindi ma-restore ang mga DNS zone: Nakapatay ang DNS service sa konpigurasyon ng server.',
    'bu_conflict_resolver_mail_not_supported' => 'Hindi ma-restore ang mga mailbox: Nakapatay ang serbisyo ng mail sa konpigurasyon ng server.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Ang tinutukoy na limit ng pag-aksyon ng CPU ay hindi suportado ng ISS web server. Ang marka ay muling itatakda sa %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'SSL/TLS certificate na %1 ng server',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS certificate na %2 ng domain na %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS certificate na %1',
    'bu_conflict_resolver_absent_objects' => 'Hindi ma-restore ang mga nilalaman ng mga sumusunod na bagay dahil ang mga object ay hindi makita sa Plesk. %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Hindi ma-restore ang mga nilalaman ng mga sumusunod na mga mailbox dahil ang mga mailbox ay hindi makita sa Plesk. %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Hindi ma-restore ang mga nilalaman ng mga sumusunod na mga mailing list dahil ang mga mailing list ay hindi makita sa Plesk. %1',
    'bu_conflict_resolver_absent_objects_database' => 'Hindi ma-restore ang mga nilalaman ng mga sumusunod na mga database dahil ang mga database ay hindi makita sa Plesk. %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Ang aplikasyon ng restorasyon na "%1" sa "%2" ay nabigo dahil mayroon nang isang aplikasyon na naka-install sa "%3". Maaari mong tanggalin ang naka-install na aplikasyon at muling subukan.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Hindi sinusuportahan ang function na awtomatikong pagtugon ng mail.',
    'bu_conflict_resolver_not_available_mail_content' => 'Hindi sinusuportahan ang pag-restore ng content ng mail.',
    'bu_conflict_resolver_invalid_mail_name' => 'Hindi na-restore ang mga sumusunod na mailbox dahil naka-enable ang email subaddressing at ang ilang partikular na email address ay may sign na "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Hindi na-restore ang mga sumusunod na user dahil naka-enable ang email subaddressing at ang ilang partikular na email address ay may sign na "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Ang mga sumusunod na lisensya ay nag-expire at hindi na maibabalik: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Hindi valid o nag-expire na at hindi mare-restore ang mga sumusunod na lisensya: {{objects}}',
    'expiration_unsupported' => "Hindi suportado ang limit 'pagkawalang-bisa'.",

    'component_name__dbconnector' => "Database Connector",
    'component_name__mysqlserver' => 'MariaDB/MySQL Server',
    'component_name__troubleshooting' => 'Pag-areglo',
    'component_name__savi' => 'Interface ng Sophos Anti-Virus',

    '__subscription_has_no_license_key' => 'Ang resource ng suskrisyon ay binigay mula sa service node na #%1 na walang associated license key.',
    '__subscription_has_expired_license_key' => 'Ang mga resource ng suskrisyon ay ibinigay galing sa service node na #%1 na ang license key %2 ay wala nang bisa.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%>Hindi maipon ang konpigurasyon ng mga file',
    '__cfgmonConfigurationFileSaveErrorBody' => "Hindi maipon ang ibang konpigurasyon ng mga file sa host na <%%host%%>: Ang mga sumusunod na error ay nangyari:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Nag-e-enable ang opsyong ito ng kakayahang mag-configure ng mga VERP-style email address para sa mga mail list',
    'mail__enter_right_ip_mask' => "Ilagay ang IP mask sa pagitan ng 1 at 32",
    'mail__enter_right_ip_mask_24' => "Ilagay ang IP mask sa pagitan ng 24 at 32",
    'mail__invalid_dom_name' => "Hindi valid ang domain name na %1.",
    'mail__invalid_pop_lock_time' => "POP3 lock time ay hindi wasto.",
    'mail__invalid_rbl_server' => "Hindi valid ang DNS zone name.",
    'mail__total_files_size' => "Kabuuang laki ng repository: %1",
    'mail__filename_already_in_repository' => "Mayroon nang file na may parehong pangalan sa repository",
    'mail__no_white_list_mask_feature_24' => "Gumamit ng mask value na 24 o mas mataas.\nAng iyong mail server ay hindi naka-suporta sa mga setting mask. Maari lamang natin gayahin ang setting mask para sa mga marka na hindi mababa sa 24.",
    'mail__unable_add_new_mail_name' => "Hindi maidagdag ang mail account: %1",
    'mail_server_is_not_installed' => 'Hindi naka-install ang mail server ng (Postfix o Qmail). I-install ito para ituloy ang trabaho.',
    'mail_server_not_available' => 'Walang suportadong server ng mail ang maaari sa service node.',
    '__not_installed' => '(Hindi naka-install)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Hindi pinagana ang pag-filter sa spam sa mga palabas na mga mensahe na email.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Ang service node ay hindi sumusuporta sa paglilimita ng mga bilang ng palabas na mensahe ng email na mula sa isang domain para sa domain %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Ang service node ay hindi sumusuporta sa paglilimita ng mga bilang ng palabas na mensahe ng email na mula sa isang mailbox para sa domain %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Tukuyin ang address ng kahit isang uri (IPv4 o IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Hindi wastong mode ng palabas na email ang tinukoy.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Hindi wasto ang tinukoy na IPv4 address.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Hindi wasto ang tinukoy na IPv6 address.',
    'mail__outgoing_email_mode_unavailable' => 'Hindi sinusuportahan ang pagpapalit ng mode ng palabas na mail marahil dahil ang Postfix mail server ay hindi naka-install sa server na ito.',

    'mail__autoresponder_attachment_not_supported' => 'Hindi sinusuportahan ng mail server na ginagamit sa kasalukuyan ang pamamahala ng attachment sa auto-responder.',

    'mail__smtp_white_list_not_supported' => 'Hindi sinusuportahan ng kasalukuyang ginagamit na mail ang pag-whitelist ng IP address.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Hindi sinusuportahan ng kasalukuyang napiling mail server ang mga CIDR mask. Tukuyin ang IP address sa format na \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Hindi sinusuportahan ng kasalukuyang napiling mail server ang mga wildcard na pattern ng IP. Tukuyin ang IP address sa format na \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Hindi mabago ang mga setting para sa DKIM verification service',

    'sfdk_domain__serverwide_disabled' => 'Patayin ayon sa patakaran ng server',
    'feature__domainkeys__serverwide_disabled' => 'Naka-off ang DKIM spam protection para sa buong server',

    'defaultcomponents__error_set_default' => 'Hindi maitakda ang %1 bilang default na %2: %3',
    'defaultcomponents__error_set_default_none' => 'Hindi maitakda sa walang default na component para sa %1: %2',
    'defaultcomponents__required_package_not_default' => 'Hindi default ang component %1 na kailangan para sa kanyang gawain.',

    '__percentage' => '%',
    '__seconds' => '(na) Segundo',
    '__resource_remain' => 'Natitira',

    '__not_registered' => '(hindi nakarehistro)',
    '__php_handler_id' => 'Bersyon ng PHP',
    '__php_handler_id_string' => 'PHP na %1 (%2)',
    '__php_handler_not_registered' => 'Ang handler ng PHP na "%1" ay hindi naka-rehistro. Ito ay marahil nabura na sa server. Irehistro ang handler ng may parehong mga katangian at muling subukan.',
    '__php_handler_not_registered_on_domain' => 'Domain "%1": Ang handler ng PHP na "%2" ay hindi naka-rehistro. ito ay marahil nabura na sa server. Irehistro ang handler ng may parehong mga katangian at muling subukan.',
    '__php_fpm_handler' => 'Aplikasyon ng FPM',
    '__php_fpm-dedicated_handler' => 'Nakatuon na FPM application',

    'mailname_create_assigned_user_dublicate_error' => 'Hindi makalikha ng user para sa mailbox. Ang user na may username na %1 ay umiiral at may iba pang mailbox.',
    'mailname_create_assigned_user_role_absent_error' => 'Hindi makalikha ng user para sa mailbox. Ang default role %1 ng user ay hindi umiiral.',

    'gphd__mime_types' => 'Mga uri ng MIME',
    'gphd__handlers' => 'Mga Apache handler',
    'gphd__ip_restrictions_allow' => 'Hayaan ang pag-access sa site para sa mga tinukoy na host at mga network (maliban sa mga hindi pinahintulutan)',
    'gphd__ip_restrictions_deny' => 'Hindi pinahintulutan ang pag-access sa site para sa mga tinukoy na mga host at network',
    'gphd__directory_index' => 'Mga index file',
    'gphd__nginx_transparent_mode' => 'Ang mode kapag hinahawakan ng Apache ang parehong static at dynamic na nilalaman, habang ang nginx ay pinoproseso ang mga kahilingan at mga tugon ng HTTP nang walang modipikasyon.',
    'gphd__nginx_serve_static' => 'Direktang nagbibigay ng mga file na static ng nginx',
    'gphd__nginx_static_extensions' => 'Mga extensyon ng static file na dapat ay hawakan ng nginx',
    'gphd__nginx_serve_php' => 'I-proseso ang mga file ng PHP gamit ang nginx',
    'gphd__www_root' => 'WWW Root Directory',

    'eol__none' => 'huwag baguhin',
    'eol__lf' => 'Isasalin sa istilo ng Unix',
    'eol__cr' => 'Isasalin sa istilo ng MacOS',
    'eol__crlf' => 'Isasalin sa istilo ng Windows',

    'ui__dns_bad_zone' => 'Magkasalungat na zone "%1".',
    'ui__dns_ns_has_no_address_records' => 'Ang tala ng NS "%1" ay walang mga talang address (A o AAAA).',
    '__dns_bad_zone' => 'Magkasalungat na zone "%1".',
    '__dns_ns_has_no_address_records' => 'Ang tala ng NS "%1" ay walang mga talang address (A o AAAA).',
    '__dns_ptr_is_wildcard' => 'Ang tala ng PTR "%1" ay hindi-valid: Ang tala ay nakaturo sa domain ng wildcard.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Hayaan ang pag-access ng remote para sa user ng database na \'%3\' ng kustomer na \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Hindi mapapayagan ang mga remote connection para sa user ng database na \'%1\': Hindi matukoy ang numero ng TCP port na gamit ng Microsoft SQL server na \'%2\'. Ang mga posibleng dahilan ay ang mga sumusunod: ang TCP/IP protokol ay hindi bukas sa konpigurasyon ng server network o ang server ay nakonpigura na gumamit ng mga dynamic TCP port. Konpigurahin ang server para makinig sa tinukoy na nakapirmang TCP port at hayaang muling subukan ng mga remote connection.',

    'command__convertResellerHasCustomer' => 'Ang account ng reseller na \'%1\' ay mayroong isa o higit pa na mga account ng kustomer. Para mabago itong account ng reseller patungo sa account ng kustomer, una gumawa muna ng pag-transfer ng mga account ng kustomer sa bagong may-ari o baguhin sila sa mga account ng reseller.',
    'command__convertResellerNotReseller' => 'Mga account ng reseller lamang ang maaring mabago patungo sa account ng kustomer. \'%1\' ay hindi reseller.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Hindi ma-sync ang subscription sa service plan. Sumasalungat sa service plan ang sumusunod na mga setting ng subscription: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Ang account na \'%1\' ay isang account ng reseller. Hindi maaaring ilipat ang mga account ng reseller sa bagong may-ari dahil sila ay pagmamay-ari ng administrador ng server.',
    'moveCustomer__wrong_owner_type' => "Ang account ng kustomer na '%1' ay maari lamang ilipat sa isang reseller o admin, hindi sa ibang kustomer.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Ang account ng kustomer na \'%1\' ay pagmamay-ari na ng ibang napiling may-ari.',
    'upgradeClient__user_is_admin' => 'Ang account na \'%1\' ay hindi maaring isalin sa account ng reseller dahil ito ay account ng administrator.',

    'mail__error_setting_max_connections_courier' => 'Hindi maitakda ang maximum na bilang ng mga koneksyon (IMAP, POP3, IMAP sa pamamagitan ng SSL/TLS, o POP3 sa pamamagitan ng SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Hindi maitakda ang maximum na bilang ng mga koneksyon (IMAP, POP3, IMAP sa pamamagitan ng SSL/TLS, o POP3 sa pamamagitan ng SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Hindi maitakda ang maximum na bilang ng mga koneksyon (IMAP, POP3, IMAP sa pamamagitan ng SSL/TLS, o POP3 sa pamamagitan ng SSL/TLS) para sa bawat IP address: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Hindi maitakda ang maximum na bilang ng mga koneksyon (IMAP, POP3, IMAP sa pamamagitan ng SSL/TLS, o POP3 sa pamamagitan ng SSL/TLS) para sa bawat IP address ng isang partikular na user ng mail: %1',
    'outgoing_messages_limit_value_invalid' => 'Ang halaga ay dapat nasa hanay na %%MIN%%..%%MAX%%. Ang administrador ng Plesk lamang ang maaaring mag-ayos ng setting na ito.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Ang mga sumusunod na mga domain ay gumagamit ng panlabas na email address para sa pagpapasa ng mail na ipinadala sa hindi umiiral address. Ang mga mensaheng ipinadala sa mga address na ito ay hindi mabibilang sa Outging Mail Control:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Ang limitasyon sa palabas na mail ay hindi gagana para sa mga nagpapadala ng mail na ang mga IP address ay nasa white list ng mail server. Halimbawa, kapag mayroong localhost (127.0.0.0 / 8, ::1 / 128) sa white list, lahat ng mail mula sa lokal na server ay matagumpay na maipapadala nang walang bahala sa limitasyon. Ang mga nagpapadala ng mail ay maaring gumamit ng mga local IP address (website at custom scripts sa lokal na server) o mga panlabas (mga kustomer na nagpapadala ng mail mula sa kliyente ng mail na naka-install sa kanilang mga computer o mobile device) Para gumana ang mga limit para sa mga nagpapadala ng mail (parehong lokal o panlabas), alisin ang lahat ng mga IP address at networks mula sa white list. Tandaang ang pag-alis ng localhost (127.0.0.0 / 8, ::1 / 128) mula sa white list ay maaring makasagabal sa operasyon ng website at script na nagpapadala ng mail mula sa server. Para sa mga detalye ng limitasyon sa palabas na mail, tignan ang Gabay ng Administrador, Proteksyon mula sa Outbound Spam.',
    'outgoing_messages_relay_open' => 'Nakabukas ang mail relay: Ang limitasyon sa palabas na mail ay hindi gagana.',

    'notification_aps_app_updates_available' => 'Ang pag-update ay maaari sa mga sumusunod na applications:',
    'notification_aps_app_updates_installed' => 'Awtomatikong na-install ang mga update para sa mga sumusunod na application:',
    'notification_aps_app_updates_requirements' => 'Ang pag-update ay maari para sa mga sumusunod na application ngunit hindi maaring ma-install dahil sa hosting setting na tugma sa mga website ay hindi tumutupad sa mga pangangailangan sa pag-install.',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" sa %%parentName%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" sa %%parentName%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" sa %%parentName%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" sa %%parentName%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Iyong bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" sa %%parentName%% (%%url%%). Iyong bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" sa %%parentName%% (%%url%%). Iyong bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Bagong bersyon: %%to%%. Naunang bersyon: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Bagong bersyon: %%to%%. Naunang bersyon: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Bagong bersyon: %%to%%. Naunang bersyon: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Naka-install na bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Iyong bersyon: %%from%%. Magagamit na bersyon: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'panlabas na app',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Mga domain',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Mga email address',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Mga suskrisyon',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 mensahe kada oras',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Walang-limitasyon',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, ang limitasyon ay %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 (mga) pagsubok sa lampas ng limitasyon mula %2 hanggang %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 (mga) pagsubok sa lampas ng limitasyon mula %2 hanggang ngayon',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Pag-ban ng IP Address(Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Hindi naka-install ang component ng Fail2ban sa destination server.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'I-install ang Fail2ban. Tandaang ito ay maaaring tumagal ng mga ilang minuto.',

    'plesk_key__no_reseller_support' => 'Hindi mo maaring pangasiwaan ang reseller dahil sa mga pagbabawal sa lisensya.',
    'plesk_key__no_customers_support' => 'Hindi mo maaring pangasiwaan ang kustomer dahil sa mga pagbabawal sa lisensya.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Hindi makalipat sa Service Provider view dahil sa restriksiyon ng lisensya.',
    'plesk_key__no_security_core_support' => 'Ang katangian ng security core (ModSecurity at Fail2Ban) ay hindi magagamit dahil sa mga pagbabawal sa lisensya.',
    'plesk_key__outgoing-antispam' => 'Kontrol sa Palabas na Mail',
    'plesk_key__security-core' => 'Security Core (ModSecurity at Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Pangasiwaan ng mga accounts',
    'plesk_key__can-manage-subscriptions' => 'Pangasiwaan ng suskrisyon',
    'plesk_key__can-manage-customers' => 'Pangasiwaan ng mga kustomer',
    'plesk_key__can-manage-resellers' => 'Pangasiwaan ng mga reseller',
    'plesk_key__can-manage-custom-view' => 'Availability ng Restricted Mode',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Ang pangasiwaan ng suskrisyon ay nakapatay ngunit mayroon kang ilan na suskrisyon (%1)',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Ang pangasiwaan ng reseller ay nakapatay ngunit mayroon kang ilan na reseller (%1)',
    'plesk_key__limits_exceeded_no_customers_management' => 'Ang pamamahala ng mga mamimili ay naka-off ngunit mayroon kang ilang mga mamimili (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Ang ilang partikular na resource ng subscription na hindi mo na mapapamahalaan sa interface ng Plesk (gaya ng mga limitasyon sa mga mailbox at disk space ng mga domain) ay nakatakda na ngayon sa walang limitasyon.',
    'plesk_key__no_subscriptions_support' => 'Hindi mo maaring pangasiwaan ang suskrisyon dahil sa mga pagbabawal sa lisensya.',
    'plesk_key__no_custom_view_support' => 'Hindi mo maaaring gamitin ang Restricted Mode dahil sa mga paghihigpit sa lisensya.',
    'plesk_key__trial_forbidden_region' => 'Paumanhin, kasalukuyang hindi available ang Plesk sa iyong rehiyon.',
    'additional_key__main_key' => 'Ang key ay ang pangunahing susi: Hindi ka maaaring gumawa ng pag-upload ng pangunahing key bilang karagdagang key.',

    'gch__hosting_waf_rule_engine' => 'Mode ng Web application na firewall',

    'backup__fieldset__restoration_options' => 'Mga opsyon sa restoration',
    'backup__restore_options__restore' => 'Ibalik',
    'backup__restore_options__domain__domain_configuration' => 'Konpigurasyon ng domain',
    'backup__restore_options__domain__virtual_host_content' => 'Nilalaman ng virtual na host',
    'backup__restore_options__domain__mail' => 'Mail',
    'backup__restore_options__domain__databases' => 'Mga database',
    'backup__restore_options__client__client_configuration' => 'Konpigurasyon sa account ng kustomer',
    'backup__restore_options__client__domains' => "Domain ng kustomer",
    'backup__restore_options__reseller__reseller_configuration' => 'Konpigurasyon sa account ng reseller',
    'backup__restore_options__reseller__personal_domains' => "Mga domain ng reseller",
    'backup__restore_options__reseller__clients' => "Kustomer ng reseller",
    'backup__restore_options__admin__server_configuration' => 'Mga setting sa server',
    'backup__restore_options__admin__administrator_configuration' => 'Konpigurasyon ng account ng administrator',
    'backup__restore_options__admin__personal_domains' => "Mga domain ng administrador",
    'backup__restore_options__admin__personal_clients' => "Mga kustomer ng administrador",
    'backup__restore_options__admin__resellers' => 'Mga Reseller',

    'badge_new' => 'Bago',
    'upgrade_php_on_subscription' => 'Gumawa ng pag-upgrade ng PHP sa iyong suskrisyon sa bersyon 5.3.0 o mamaya.',

    'pkey_notify__body_expiration_notification' => 'Ang license key ay wala nang bisa. Maaaring hindi magagamit ang ilang tampok. Kontakin ang iyong provider ng hosting.',

    'crontab__crontab_entry_exists' => "Ang naka-iskedyul na mga tungkulin ay umiiral.",
    'crontab__crontab_entry_not_exists' => "Ang naka-iskedyul na mga tungkulin ay hindi umiiral.",
    'crontab__invalid_values_found' => "Maling marka ng mga parameter.",
    'crontab__cmd_max_len' => "Ang command ay hindi maaring mas mahaba sa %1 na mga karakter.",

    'domain__domain_exists' => "May isang domain na may 'www' na prefix at parehong pangalan: %1.%2.",
    'domain__subdomain_exists' => "May isang subdomain sa 'www' na prefix at parehong pangalan: %1.%2.",
    'domain__dalias_exists' => "May isang domain alias na may 'www' na prefix at parehong pangalan: %1.%2.",
    'domain__record_exists' => "Mayroong DNS record na nagtuturo sa host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Sertipiko '%1' hindi maaaring itakda bilang isang default: pribadong key ay nawawala.",
    'ip_addr__update_dns_error' => 'Ang mga isyu ay naganap habang ina-update ang IP address sa mga DNS na sona. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Hindi maidagdag ang IP address. Awtomatikong kumukuha ng mga IP address ang interface ng network na ito.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Hindi maalis ang IP address %1. Awtomatikong kumukuha ng mga IP address ang interface ng network na ito.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Hindi maayos ang IP address %1. Awtomatikong kumukuha ng mga IP address ang interface ng network na ito.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Hindi mabago ang interface ng IP address %1 dahil ang interface ng network %2 ay awtomatikong kumukuha ng mga IP address.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Ang limistayon ng suskrisyon sa bilang ng %%type%% ay lumampas. Ang limitasyon ng %%limit%%, at %%usage%% ay kasalukuyang ginagamit.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Ang pagbuo ng %%type%% ay hindi pinapahintulutan para sa suskrisyon na ito.',
    'shm_lmsg__resource_title__db-mysql' => 'MariaDB/MySQL database',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL database',
    'shm_lmsg__resource_title__db-postgresql' => 'Mga PostgreSQL database',
    'shm_lmsg__resource_title__db-user' => 'mga user ng database',
    'shm_lmsg__resource_title__iis-application-pool' => 'Mga IIS application pool',
    'shm_lmsg__resource_title__additional-ftp-account' => 'karagdagang mga FTP account',

    'db_user_unable_remove_mysql_global_privileges' => 'Hindi maalis ang mga pandaigdigang pribilehiyo sa MariaDB/MySQL ng user na si %1 sa database. Dahilan: %2',
    'report__client_description' => 'Paglalarawan',

    'db__user_role_error' => 'Mali ang tinukoy na tungkulin ng user sa database: %1. Mangyaring pumili ng isa sa mga sumusunod na tungkulin: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Hindi maitakda ang limitasyon sa sukat ng file para sa sumusunod na Microsoft SQL Server na mga database dahil sila ay may mataas na sukat ng file: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Hindi maitakda ang limitasyon sa sukat ng log file para sa sumusunod na Microsoft SQL Server na mga database dahil sila ay may mataas na sukat ng log file: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Hindi mai-set up ang isang pampublikong IP address: kailangan ay may umiiral na isang pribadong IP address.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Hindi mai-set up ang pampublikong IPv4 address para sa IPv6 address.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Hindi mai-set up ang pampublikong IPv6 address para sa IPv4 address.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Hindi makapag-set up ng pampublikong IP address: invalid na IP address.',

    '__user_already_exists' => "User %1 ay umiiral.",
    '__user_name_is_empty' => "Tukuyin ang isang user name.",

    'upgrade_php_on_domain' => 'Hindi mahanap ang bersyon ng PHP na 5.3.0 o mas bago sa anumang iyong mga domain ng WordPress. Subukan na i-upgrade ang PHP.',

    'component_name__waf' => 'Web Application na Firewall',
    'component_name__vcs' => 'Sistema ng Kontrol ng Bersyon',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Nabatid ang posibleng pagtatangka na spoofing: Ang link ay nagtangka na ipakita ang walang kinalaman na nilalaman.',
    'forceResetPasswordUpdated' => 'Pinalitan ang iyong password. Gamitin ang bagong password para mag-log in sa Plesk.',

    'php_handlers_error_no_available_instance' => 'Hindi makalikha ng isang domain: walang mga magagamit na PHP handler.',
    'domain_error_unable_to_apply_hosting_settings' => 'Hindi makayang i-apply ang mga hosting setting: %1',

    'plesk_not_configured' => 'Ang Plesk ay hindi isinaayos. Pumunta sa control panel upang magsagawa ng matapos-mag-install na pagsasaayos.',
    'cmd_mail__mail_password_duplicated' => 'Ang tinukoy na pares ng email address at password ay umiiral na sa mail server. Mangyaring pakitukoy ng ibang email address o password.',

    'extensionRequirementOs' => 'Ang operating system (%1) ay hindi suportado ng pakete.',
    'extensionRequirementPleskMinVersion' => 'Ang Plesk %1 ang pinaunang version na suportado ng pakete.',
    'extensionRequirementPleskMaxVersion' => 'Ang mga version mula sa Plesk %1 ay hindi suportado ng pakete.',
    'extensionBlacklisted' => 'Ang extension %1 ay hindi pinapayagang maikabit.',
    'extensionDisabled' => 'Naka-disable ang extension.',


    'optimization_settings__unable_set_mpm_event' => 'Hindi mai- set ang mpm_event mode: Hinihingi nito na sarado ang Apache PHP5 module ngunit gamit ito ng ibang mga domain.',
    'optimization_settings__unable_turn_off_php' => 'Hindi nai-off ang Apache PHP5 module: Ginagamit ito ng ibang mga domain.',

    'hst_def__fp_admin_login' =>  'FTP Username',
    'hst_def__fp_admin_passwd' =>  'FTP Password',

    'database_user_orphaned_old_password_wrong' => "Hindi makayang kumpunihin ang naulilang gumagamit '%1': ang password ay hindi tama.",
    'cannot_load_partner_central_property_key_no_exist' => "Hindi makakuha ng mga pasadyang pag-aari: ang license key ay hindi umiiral.",
    'extensionScriptFailure' => "Hindi naisagawa ang %1 nang may sumusunod na mensahe:\n%3",
    '__ssl_redirect' => "Permanenteng pag-redirect ng SEO-safe 301 sa HTTPS mula sa HTTP",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Hindi sinusuportahan ang pamamahala sa DKIM.',
    'mail__dmarc_not_supported' => 'Hindi sinusuportahan ang pangangasiwa sa DMARC.',
    'mail__relay_white_list_not_supported' => 'Hindi sinusuportahan ang pamamahala sa relay whitelist.',
    'mail__black_list_not_supported' => 'Hindi sinusuportahan ang pamamahala sa blacklist.',
    'mail__autoresponder_not_supported' => 'Hindi sinusuportahan ang pamamahala sa auto-responder.',
    'defaultcomponents__not_supported_version' => '(hindi sinusuportahang bersyon)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Hindi nakita ang certificate na \'%1\'.',
    'certificate__unable_setup_certificate' => 'Hindi ma-install ang certificate: Nawawala ang mga nilalaman ng private key at certificate.',
    'certificate__used_by_panel' => 'Ang isa sa mga certificate na ide-delete mo ay ginagamit para sa pagse-secure sa Plesk.',
    'certificate__used_by_mail_server' => 'Ang isa sa mga certificate na ide-delete mo ay ginagamit para sa pagse-secure sa mail server.',
    'certificate__used_by_domain_service' => 'Ginagamit ng serbisyo ng domain ang isa sa mga certificate na ide-delete mo.',
    'mail_server__not_installed' => 'Hindi ma-install ang certificate para sa mail server dahil hindi naka-install ang mail server.',

    'email_activation_mail_subject' => 'Paki-activate ang iyong account sa Plesk',
    'email_activation_mail_body' => "May ginawang account sa Plesk server %1\n\nMga detalye ng account:\nPangalan: %2\nE-mail address: %3\n\nKung tama ang impormasyong ito at ginawa para sa iyo ang account, paki-activate ito gamit ang sumusunod na link:\n\n%4\n\nSa pamamagitan ng pag-activate sa account, pinapahintulutan mo ang server holder na kolektahin, i-store, iproseso, at gamitin ang iyong personal na data (pangalan at email) para sa paggawa at pagsuporta sa account mo, alinsunod sa mga nalalapat na batas ng proteksyon ng data na kasalukuyang umiiral, bilang bahagi ng isang kontrata.",

    'backup_transport_permission_name' => '%1 pamamahala',
    'backup_transport_permission_description' => 'Pinapayagan ang paggamit ng %1 para sa pag-store ng mga backup.',

    'domain_move_err_target_no_hosting' => 'HIndi malipat ang domain sa isang subscription na walang hosting.',
    'domain_move_err_already_in_target' => 'Nasa target na subscription na ang domain.',
    'domain_move_err_main_domain' => 'Hindi malilipat ang pangunahing domain.',
    'domain_move_err_subdomain_without_parent' => 'Hindi malipat ang subdomain na %1 nang wala ang parent na domain na %2.',
    'domain_move_err_root_exists' => 'Mayroon nang target na path para sa www_root na %1.',
    'domain_move_err_nested_roots' => 'Hindi malipat ang domain dahil kapareho nito ang document root ng isa pang domain: %1.',
    'domain_move_err_no_mail_service' => 'Hindi nalipat ang domain dahil naka-disable ang mail service sa target na subscription.',
    'domain_move_err_app' => "Ang application na na-installed sa %1 ay hindi nalipat sa subscription na '%2': %3",
    'domain_move_database_used_by_app' => "Ang database na '%1' sa %2 ay ginagamit ng inilipat na application. Para i-reassign ang database sa '%3', i-run ang `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Na-lock para sa pag-sync ang target na subscription na '%1'.",
    'domain_move_filesharing_disabled' => 'Na-disable ang file sharing.',
    'domain_move_website_preview_disabled' => 'Na-disable ang preview ng website.',
    'domain_move_additional_webserver_settings' => "I-review ang mga karagdagang directive ng web server ng domain para hadlangan ang sirang configuration.",
    'domain_move_no_permission' => "Hindi pinapayagan ang %1 para sa subscription '%2'.",
    'domain_move_no_access' => "Walang access sa subscription '%1'.",
    'domain_split_no_create_permission' => "Hindi pinapayagan ang paggawa ng domain.",
    'domain_split_empty_login' => 'Kinakailangan ang login ng user sa system.',
    'domain_split_empty_password' => 'Kinakailangan ang password ng user sa system.',
    'domain_split_err_home_exists' => 'Hindi maaaring ilipat ang domain na %1 dahil nasa %2 na ang target na home nito. I-rename ang domain para mailipat ito sa isang bagong subscription.',
    'domain_split_err_no_hosting_subdomains' => 'Hindi maililipat sa isang bagong subscription ang domain dahil walang pag-host ang system ngunit mayroon itong mga subdomain. Para mailipat ang domain, baguhin ang value ng "Uri ng pag-host” nito at gawing "Pag-host ng website" (sa Mga Setting ng Pag-host).',
    'domain_split_target_locked' => "Naka-lock para sa pag-sync ang target na subscription na '%1'.",
    'domain_split_target_unsynced' => "Hindi na-sync sa plan ang target na subscription na '%1' dahil: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Na-deactivate noong '%1\\’ ang nakaiskedyul na pag-back up.",
    'domain_merge_database_error' => "Hindi nailipat sa subscription na '%3\\’ ang database na '%1' sa %2 : %4",
    'domain_merge_anon_ftp_deactivated' => "Nag-off ng anonymous na FTP sa '%1'.",
    'domain_merge_smb_user_access' => "Ang karagdagang user na '%1' ay inilipat sa subscription na '%2' ngunit binawi ang access ng user sa subscription.",
    'domain_merge_scheduled_tasks' => "Inilipat sa target na subscription ang mga nakaiskedyul na gawain. Suriin ang configuration ng mga gawain.",
    'domain_merge_scheduled_tasks_deactivated' => "Inilipat sa target na subscription ang mga nakaiskedyul na gawain at na-deactivate ang mga ito. Suriin ang configuration ng mga gawain.",
    'domain_merge_no_remove_permission' => "Hindi pinapayagang mag-alis ng mga subscription.",
    'domain_merge_err_has_addons' => 'Hindi mailipat ang pangunahing domain kasama ng mga karagdagang domain nito; ilipat muna ang (mga) domain na %1.',
    'domain_merge_err_has_webusers' => 'Hindi mailipat ang pangunahing domain kasama ng mga user nito ng web.',
    'domain_merge_err_root_exists' => 'Mayroon nang target na path na %1.',

    'database_server_edit_used_for_psa' => 'Hindi pinapayagan ang pag-update ng lokal na database server ng MariaDB/MySQL.',
    'suggest_repair_main_suggestion_ui' => '<b>Maaayos mo ang error na ito</b> gamit ang utility na `plesk repair.`',
    'suggest_repair_main_suggestion_cli' =>  'Maaayos mo ang error na ito gamit ang utility na `plesk repair.`',
    'suggest_repair_repair_kit_link_title' => 'pumunta sa I-diagnose at Ayusin',
    'suggest_repair_using_cli_and_ui' => 'Para gawin iyon, paganahin ang command na `plesk repair %1` sa pamamagitan ng CLI o %2 at i-click ang Ayusin sa tabi ng “Plesk Database”',
    'suggest_repair_using_cli' => 'Para gawin iyon, paganahin ang command na `plesk repair %1` sa pamamagitan ng CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Hindi available ang serbisyo ng DNS noong ginawa ang backup. Gayunpaman, may mga aktibong DNS zone sa backup at mae-enable ang mga ito para sa mga sumusunod na object: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Pangkontrol ng Resource (Mga Cgroup)',
    'plesk_key__remote-smartermail-enabled' => 'Suporta ng remote na SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(hindi pinapayagan ng license key)',
    'plesk_key__validation_failed' => '%1 (Code ng error: %2)',
    'promo__button_details' => 'Mga detalye',
    'promo__extension_catalog_title' => 'Catalog ng Extension',
    'promo__extension_catalog_description' => 'Suriin ang bagong catalog ng extension at i-supercharge ang iyong Plesk sa pamamagitan ng iba’t ibang mahuhusay na extension!',
    'promo__button_open_catalog' => 'Buksan ang Catalog',

    'backup__repository_check_login' => "Hindi ma-access ang storage: %1 Tiyaking nailagay mo ang mga tamang kredensyal ng storage.",
    'backup__repository_check_error_list' => "Hindi ma-access ang storage: %1 Tiyaking nailagay mo ang mga tamang setting ng storage.",
    'backup__repository_check_error_mkdir' => "Hindi magawa ang directory: %1 Tingnan kung may mga pahintulot kang gumawa ng mga folder sa storage.",
    'backup__repository_check_error_upload' => "Hindi ma-upload ang file sa storage: %1 Tingnan kung may mga pahintulot kang mag-upload ng mga file sa storage.",
    'backup__repository_check_error_download' => "Hindi ma-download ang file mula sa storage: %1 Tingnan kung may mga pahintulot kang mag-upload at mag-download ng mga file mula sa storage.",
    'backup__repository_check_error_resume-upload' => "Hindi maipagpatuloy ang pag-upload ng file sa storage: %1 Tingnan kung may mga pahintulot kang ipagpatuloy ang mga pag-upload sa storage.",
    'backup__repository_check_error_resume-download' => "Hindi maipagpatuloy ang pag-download ng file mula sa storage: %1 Tingnan kung may mga pahintulot kang ipagpatuloy ang mga pag-download mula sa storage.",
    'backup__repository_check_error_enable-utf8' => "Hindi mapagana ang storage: %1 Tingnan kung sinusuportahan ng storage ang UTF8 encoding.",
    'backup__repository_check_error_rm' => "Hindi mapagana ang storage: %1 Tingnan kung may mga pahintulot kang mag-delete ng mga file sa storage.",
    'backup__repository_check_error_rmdir' => "Hindi mapagana ang storage: %1 Tingnan kung may mga pahintulot kang mag-delete ng mga folder sa storage.",

    'backup__ftp_repository_check_login' => "%1 Puwede mong tingnan ang mga ito nang hiwalay gamit ang command na: %2",
    'backup__ftp_repository_check_error_list' => "%1 Puwede mong tingnan ang mga ito nang hiwalay gamit ang command na: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang command na: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang mga command na: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang mga command na: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang mga command na: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang mga command na: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang command na: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang mga command na: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Puwede mo itong tingnan nang hiwalay gamit ang mga command na: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Hindi mabago ang mga setting para sa DMARC. Para i-enable ang opsyong ito, paki-on ang proteksyon sa spam ng DKIM at SPF.',
    'spf_server_wide_disable_failed' => 'Hindi mabago ang mga setting para sa proteksyon sa spam ng SPF. Para i-disable ang SPF, paki-off ang DMARC para sa papasok na mail.',
    'sfdk_server_wide_verify_disable_failed' => 'Hindi mabago ang mga setting para sa proteksyon sa spam ng DKIM. Para i-disable ang DKIM, paki-off ang DMARC para sa papasok na mail.',

    'ccs_not_supported' => 'Hindi naka-configure ang IIS Central Certificate Store sa system.',
    'ccs_not_enabled' => 'Hindi naka-enable ang pamamahala ng IIS Central Certificate Store sa Plesk.',
    'ad_not_supported' => 'Hindi nauugnay ang server sa isang domain.',

    'component_name__appinit' => "Pagsisimula ng Application",
    'component_name__cors' => "Cross-Origin Resource Sharing",
    'component_name__httpcompression' => 'Pag-compress ng Content ng HTTP',
    'common_feature_is_not_supported' => 'Hindi na sinusuportahan ang feature na ito.',
    'common_feature_is_not_supported_in_proto' => 'Hindi sinusuportahan ang feature na ito para sa bersyon %1 ng protocol.',
    'autoinstaller__plesk_component' => 'Bahagi ng Plesk',
    'plesk_key__key_expired' => 'Your license key has expired. To continue using Plesk, %1.',
    'plesk_key__key_purchase' => 'buy a new license',
    'plesk_key__key_expired_period' => 'Your license key expired more than %1 days ago.',

    'sa_action_move' => 'Ilipat ang spam sa folder na "Junk E-mail”',

    'bu_conflict_resolver_tomcat_not_supported' => 'Hindi na sinusuportahan ang mga Java application. Hindi magiging available ang mga ito para sa mga sumusunod na website: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Hindi na sinusuportahan ang mga pang-mobile na bersyon ng mga website na naka-host sa UNITY Mobile. Hindi magiging available ang mga ito para sa mga sumusunod na website: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Hindi pinapayagan ng patakaran sa paggamit sa buong server ang paggamit ng mga personal na setting ng antivirus. Hindi mare-restore nang buo ang mga ito para sa mga email account sa mga sumusunod na domain: {{objects}}',

    'module__not_installed' => "Hindi naka-install ang extension na %1",

    'mail__mail_autodiscovery_server_error' => 'Tumukoy ng custom na domain name para sa mail autodiscover',
    'mail__error_mail_autodiscovery_enable' => 'Hindi maitakda ang mail autodiscover: %1',
    'mail__error_mail_autodiscovery_server' => 'Hindi makapagtakda ng custom na domain name para sa mail autodiscover: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Hindi ma-reconfigure ang mga autodiscover DNS record ng mga domain: %1',

    'mail__smarthost_not_configured_error' => 'A smarthost is not configured.',
    'mail__smarthost_attach_domains_error' => 'Attaching domains to the smarthost finished with errors:',

    '__invalid_url' => 'Hindi valid ang URL na "%1"',
    'actionlog__cloning_start' => 'simulan',
    'actionlog__event_cloning_start' => 'Simula ng pag-clone ng server',

    '__UPLOAD_ERR_FORM_SIZE' => "Ang ginawang pag-upload ng file ang sumobra sa pinahintulutang laki",
    '__UPLOAD_ERR_INI_SIZE' => "Ang ginawang pag-upload ng file ang sumobra sa pinahintulutang laki",
    '__UPLOAD_ERR_NO_FILE' => "Walang file na natanggap",
    '__UPLOAD_ERR_OK' => "Matagumpay ginawang pag-upload sa file",
    '__UPLOAD_ERR_PARTIAL' => "Bahagyang nagawa ang pag-upload ng file, muling subukan mamaya",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Ang pansamantalang folder ay nawawala',
    '__UPLOAD_ERR_CANT_WRITE' => 'Nabigo ang pagsulat ng file sa disk',
    '__UPLOAD_ERR_UNKNOWN' => 'Ang hindi kilalang error ng pag-upload ng file ay nangyari',
    '__accounts' => "Mga account",
    '__access' => "Pag-access",
    '__address' => "Tirahan",
    '__addresses' => "Mga Address",
    '__acl_records' => 'Mga Records ng ACL',
    '__admin_repository' => "Repository ng administrador",
    '__all' => 'Lahat',
    '__allowed' => "Pinahintulutan",
    '__anonftp_status' => "Hindi kilalang FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 web-server ay restart, mangyaring maghintay...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Suporta sa Microsoft ASP.NET",
    '__asp_win_support' => "Suporta sa Microsoft ASP",
    '__attachments' => "Mga kalakip",
    '__attachments_list' => "Mga kalakip",
    '__author' => 'Akda',
    '__autoresp_name_already_exists' => "Ang auto-reply na mayroong pangalan na %1 ay umiiral.",
    '__autoresponder' => "Auto-reply",
    '__autoresponders' => "Mga Auto-reply",
    '__autoresponders_list' => "Mga Auto-reply",
    '__autoresponder_attachment_files' => "Mga Attachment File ng auto-reply",
    '__auto_updates_list' => 'Mga update na makukuha',
    '__backup_utilites' => "Mga Utility ng Backup",
    '__bind_status' => "Estado ng DNS Server",
    '__bu_is_not_installed' => "Ang serbisyo na ito ay kasalukuyang hindi magagamit: dahil ang mga backup utility ay hindi naka-install.",
    '__bu_not_support_in_key' => "Ang kapasidad ng backup ay hindi suportado ng license key.",
    '__notifications_not_support_in_key' => 'Ang mga abiso ay hindi suportado ng license key',
    'disabled_by_key' => 'Hindi suportado ng license key',
    '__bytes' => "mga byte",
    '__can_not_use_reserved_words' => "Ikaw hindi maaring gumamit ng reserba na mga salita.",
    '__certificate' => "Sertipiko",
    '__cgi_support' => "Suporta sa CGI",
    '__city' => "Lungsod",
    '__cl_not_exist' => "Ang account ng kustomer ay hindi umiiral.",
    '__client' => 'Customer',
    '__client_card' => "Kard ng kustomer",
    '__client_contact_name' => "Pangalan sa pakikipag-ugnayan ng kustomer",
    '__client_form' => "Personal na impormasyon",
    '__client_ip_pool' => "IP pool ng kustomer",
    '__client_limits' => "Mga limit ng account ng kustomer",
    '__client_permissions' => "Mga pahintulot ng kustomer",
    '__client_preferences' => "Mga pag-nais ng kustomer",
    '__client_status' => "Estado ng kustomer",
    '__client_total' => "Kabuuang Kustomer",
    '__client_with_login_name_already_exists' => "Umiiral na ang isang user na may username na \"%1\".",
    '__client_domuser_with_login_already_exists' => "Ang username '%1' ay ginagamit na ng administrador ng domain '%1'.",
    '__clients_global_changes' => "I-modify ang napiling mga account ng kustomer",
    '__cmd_not_found' => "Hindi kilalang command: %1",
    '__comments' => "Mga komentaryo",
    '__component_version' => "Bersyon ng component",
    '__component_not_installed' => "Ang component %1 ay hindi naka-install",
    '__confirm_overwrite' => "Kumpirmahin ang pagsapi.",
    '__confirm_stop' => "Dapat mong kumpirmahin ang proseso ng pagtigil.",
    '__confirm_passwd' => "Kumpirmahin %1 ang password",
    '__conhelp' => "Paglalarawan",
    '__contact_name' => "Pangalan ng contact",
    '__country' => "Bansa",
    '__countries' => 'Bansa',
    '__country_unknown' => 'Hindi malaman ang country subcode.',
    '__courier-imap' => 'Courier na server',
    '__create_domain' => 'Lumikha ng domain',
    '__crypted' => 'naka-encrypt',
    '__cp_access' => "Pag-access sa Plesk",
    '__cp_user' => "User ng Plesk",
    '__create' => "Gumawa",
    '__create_client_template_without_template' => "Lumikha ng account ng user ng walang template",
    '__create_domain_for' => "Lumikha ng domain para sa <b>%1</b>",
    '__create_domain_template_without_template' => "Lumikha ng domain nang walang template",
    '__creation_date' => "Petsa na nilikha",
    '__crontab_unix' => "Nag-iskedyul",
    '__crontab_win' => "Nag-iskedyul",
    '__ct_month_jan' => 'Enero',
    '__ct_month_feb' => 'Pebrero',
    '__ct_month_mar' => 'Marso',
    '__ct_month_apr' => 'Abril',
    '__ct_month_may' => 'Mayo',
    '__ct_month_jun' => 'Hunyo',
    '__ct_month_jul' => 'Hulyo',
    '__ct_month_aug' => 'Agosto',
    '__ct_month_sep' => 'Setyembre',
    '__ct_month_oct' => 'Oktubre',
    '__ct_month_nov' => 'Nobyembre',
    '__ct_month_dec' => 'Disyembre',
    '__custom_button' => "Buton ng custom",
    '__custom_buttons_list' => "Mga link sa karagdagang mga serbisyo",
    '__daily' => "Araw-araw",
    '__database_not_activated' => "%1 ay hindi napagana sa pahina ng administration ng server.",
    '__database_not_installed' => "Database %1 ay hindi naka-install.",
    '__database_not_run' => "Database %1 ay hindi tumatakbo.",
    '__database_is_corrupt' => "Ang database ng Plesk ay na-korupt. Ilunsad ang Reconfigurator utility upang ayusin ito.",
    '__databases' => "Mga database",
    '__databases_list' => "Mga database",
    '__database_type_not_supported_by_key' => 'Upang magamit ang %1 ng server, kailangan mo ng suportado para dito sa iyong license key. Mangyaring kumonsulta sa iyong Plesk sales na kinatawan.',
    '__date_immediately' => "ngayong araw",
    '__date_never' => "hindi kailanman",
    '__day(s)' => "(mga)Araw",
    '__day0' => "Linggo",
    '__day1' => "Lunes",
    '__day2' => "Martes",
    '__day3' => "Miyerkules",
    '__day4' => "Huwebes",
    '__day5' => "Biyernes",
    '__day6' => "Sabado",
    '__days' => "%1 (mga) araw",
    '__db_admin_login_empty' => "Ikaw ay naglagay ng walang laman na username, pagpatay ng control sa ibabaw ng %1 sa interface. Nais mo bang magpatuloy?",
    '__db_unable_to_unregister' => 'Hindi maalis ang mga parameter ng koneksyon ng database',
    '__db_db_exists' => 'Mayroong kahit isang database sa server',
    '__db_unable_to_change_server_name' => 'Pangalan para sa server ay hindi maaring palitan',
    '__db_unable_to_change_port' => 'Port para sa server ay hindi maaring palitan',
    '__db_already_exist' => "Ang database %1 ay umiiral.",
    '__db_credentials_invalid' => "Ang mga kredensyal ng database ay umiiral.",
    '__db_invalid_password_characters' => 'Naglalaman ng hindi wastong karakter ang password',
    '__db_engine' => "Engine ng Database", // indirect
    '__db_type' => "Uri ng database",
    '__db_user' => "User ng database",
    '__db_server' => 'Server ng database',
    '__def_domain' => "Default na domain",
    '__default_for_mysql' => 'default para sa MySQL',
    '__default_for_mariadb' => 'default para sa MariaDB',
    '__default_for_percona' => 'default para sa Percona',
    '__default_for_postgresql' => 'default para sa PostgreSQL',
    '__delete' => "Burahin (Delete)",
    '__demo' => "Ang function na ito ay hindi magagamit sa bersyon na demo.",
    '__directory' => "Direktoryo",
    '__disable_lock_screen' => 'Pigilan ang mga user mula sa pagtrabaho sa Plesk hanggang sa kumpletong mai-load ang interface screens',
    '__dismiss_news?' => "Sigurado ka bang nais mong kumpletong isara ang news block?\n\nHindi mo maaring makita ang news block hanggang sa may magagamit na maraming news.",
    '__description' => "Paglalarawan",
    '__disabled' => "pinatay",
    '__disk_space_limit' => "Limitasyon ng disk space",
    '__cgroups_cpu_usage_limit' => 'Limitasyon ng paggamit ng CPU',
    '__cgroups_ram_usage_limit' => 'Limitasyon ng paggamit ng RAM',
    '__cgroups_disk_read_usage_limit' => 'Limitasyon ng Bandwidth sa Pag-read ng Disk',
    '__cgroups_disk_write_usage_limit' => 'Limitasyon ng Bandwidth sa Pag-write ng Disk',
    '__disk_usage_by' => "Nagamit na disk space ng %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Umiiral na ang DNS record '%1'.",
    '__dns_master_should_be_remote' => "Kailangan mo ng dalawang magkaibang authoritative name servers sa magkahiwalay na mga hosts.",
    '__dns_record_not_exist' => "DNS record ay hindi umiiral.",
    '__dns_server' => "DNS Server", // indirect
    '__dom_id_is_undefined' => "Domain ID ay hindi natukoy.",
    '__dom_name' => "Pangalan ng domain",
    '__dom_name_is_invalid' => "Ang domain name ay hindi wasto. Siguraduhin nang iyong domain name ay bumubuo lamang ng alphanumeric, tuldok, at gitling na mga simbolo, at hindi malaki kaysa sa 255 na mga simbolo ang kahabaan. Bawat bahagi ng domain name sa pagitan ng mga tuldok ay hindi dapat sumobra sa 63 na mga simbolo.",
    '__dom_not_exist' => "Ang domain ay hindi umiiral.",
    '__domain' => "Domain",
    '__domain_' => 'Domain %1',
    '__domain_form' => "Pormularyo ng domain",
    '__domain_id' => "Domain ID",
    '__domain_is_turned_off_for_backup' => "Ang website %1 ay pansamantalang naka-off para sa pag-back up o pagpapanumbalik at ito ay kasalukuyang hindi makukuha.",
    '__domain_limits' => "Mga limit ng domain",
    '__domain_name' => "Pangalan ng domain",
    '__mail_name_in_ASCII_form' => "Pangalan ng mail account sa ASCII format",
    '__message_error' => 'Error',
    '__message_warning' => 'Babala',
    '__message_info' => 'Impormasyon',
    '__domain_name_in_ASCII_form' => "Domain name sa ASCII format",
    '__domain_repository' => "Repository ng domain %1",
    '__domain_status' => "Estado ng domain",
    '__domain_found_tech' => "May teknolohiyang nakita sa domain",
    '__domain_dns' => 'Domain DNS zone',
    '__domain_total_powerUser' => "Kabuuang dami para sa suskrisyon",
    '__domain_user' => "Administrador ng domain",
    '__domains_global_changes' => "I-modify ang napiling mga domain",
    '__mailnames_global_changes' => "I-modify ang napiling mga mail account",
    '__backup_manager' => 'Backup Manager',
    '__domains_list' => "Mga domain",
    'domains_list__list_header' => "mga domain",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Ang domain name ay nagsisimula sa www, kahit na ang WWW na unlapi ay ginamit.\nMagpatuloy pa rin?",
    '__dovecot' => 'Dovecot IMAP at POP3 server',
    '__dsmail' => "Serbisyo ng mail",
    '__dsmaillist' => "Serbisyo ng mailing list",
    '__dumps_tot_size' => "Kabuuang laki ng mga backup na mga file sa lokal na imbakan",
    '__email' => "Email",
    '__email_addr_is_invalid' => "Ang email address ay hindi wasto.",
    '__enabled' => "binuhay",
    '__enter_cert_text' => "Ilagay ang sertipiko ng teksto",
    '__enter_size' => "Ilagay ang laki",
    '__exclusive' => "Dedikado",
    '__expiration_date' => "Petsa na walang-bisa",
    '__fax' => "Fax",
    '__file' => "File",
    '__file_is_empty' => "Walang laman ang file.",
    '__file_name' => "Pangalan ng File",
    '__file_type' => 'Uri ng file',
    '__filemanager' => "Tagapangasiwa ng File",
    '__filepath_is_empty' => "Ang path para sa file ay walang laman",
    '__files_list' => "Mga File",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Mga setting sa FTP",
    '__ftp_serv' => "FTP server", // indirect
    '__ftp_server_parameters_are_empty' => "Dapat kang mag-set muna ng mga katangian ng FTP account!",
    '__ftp_status' => "Estado ng FTP Server",
    '__full_day0' => "Linggo",
    '__full_day1' => "Lunes",
    '__full_day2' => "Martes",
    '__full_day3' => "Miyerkules",
    '__full_day4' => "Huwebes",
    '__full_day5' => "Biyernes",
    '__full_day6' => "Sabado",
    '__full_month1' => "Enero",
    '__full_month10' => "Oktubre",
    '__full_month11' => "Nobyembre",
    '__full_month12' => "Disyembre",
    '__full_month2' => "Pebrero",
    '__full_month3' => "Marso",
    '__full_month4' => "Abril",
    '__full_month5' => "Mayo",
    '__full_month6' => "Hunyo",
    '__full_month7' => "Hulyo",
    '__full_month8' => "Agosto",
    '__full_month9' => "Setyembre",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Hard disk quota",
    '__hard_disk_quota_not_supported' => 'ang hard disk quota ay hindi suportado dahil sa konpigurasyon ng server file system',
    '__help_topic_not_found' => 'Ang help topic na iyong hinihingi (%1) ay hindi umiiral.',
    '__hosting_ip_dns_ip_not_equiv' => "Wala sa mga IP address na natukoy sa A DNS records ay tugma sa IP address na ginamit para sa hosting.",
    '__hosting_scripting' => "Suporta ng hosting scripting",
    '__hosting_setup_page_title' => "Web hosting setup para sa domain %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Uri Hosting",
    '__hostname_is_empty' => "Ang hostname ay walang laman.",
    '__hour(s)' => '(mga) Oras',
    '__hst_type_incorrect' => "Ang uri ng hosting ay hindi wasto.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Idle time",
    '__iface' => "Interface",
    '__image' => "Imahe",
    '__imap_status' => "Estado ng IMAP Server",
    '__incorrect_databases_login_pass' => "Ang mga kredensyal na iyong tinukoy para sa pag-access ng PostgreSQL ay hindi tama.",
    '__incorrect_ip_or_network_address' => 'Hindi tama ang IP address o network.',
    '__info' => 'Datos',
    '__install' => "Pag-install",
    '__install_prefix' => "I-install ang unlapi",
    '__invalid_cert_id' => "Hindi wastong ID ng sertipiko",
    '__invalid_context' => "Hindi wastong konteksto: %1",
    '__invalid_db_usr_name' => "Hindi wasto na Database user name.",
    '__invalid_dir_name' => "Hindi wasto na pangalan ng direktoryo",
    '__invalid_dom_name' => "Ang domain name ay hindi wasto.",
    '__invalid_filename' => "Hindi wastong file name. Huwag gumamit ng isang quote at/o \"../\" na kombinasyon.",
    '__invalid_id' => "Hindi wastong identifier.",
    '__invalid_lines_num' => "Hindi akmang mga marka para sa bilang ng mga linya, tanging mga digit ang pinahihintulutan.",
    '__invalid_max_letter_size' => "Pinakamalaking message size ay hindi wasto.",
    '__invalid_restart_apache_interval' => "Ang pagitan ng pag restart ng Apache ay hindi wasto.",
    '__invalid_tmpl_name' => "Ang pangalan ng template ay hindi wasto.",
    '__invalid_value' => "Maling marka.",
    '__ip_addr' => "IP Address",
    '__ip_address_and_mask' => "IP address at Subnet Mask",
    '__ip_alias__mask' => "IP address at Subnet Mask",
    '__ip_addr_is_invalid' => "Ang IP address ay hindi wasto.",
    '__ip_addr_list' => "Mga IP Address",
    '__ip_address_and_mask_hint' => 'Halimbawa, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Ang iyong license key na ito ay naglalayon para gamitin lamang sa mga Virtuozzo container.",
    '__key_limits_exceeding' => "Ang action na ito ay sumobra sa mga limitasyon na tinukoy ng iyong lisensya sa software. Kapag natanggap mo ang mensahe na ito maari mong kontakin ang iyong provider o ang manufacturer upang linawin o habaan ang mga limitasyon nitong lisensya.",
    '__kilo' => "K",
    '__keywords' => 'Mga Keyword',
    '__lang_unknown' => 'Hindi makilala ang wika.',
    '__languages' => 'Wika',
    '__learn_more' => 'Matuto pa',
    '__loading' => 'Naglo-load...',
    '__locales' => "Mga Language pack",
    '__lists' => "Listahan ng mailing",
    '__literal_bytes' => "B",
    '__processing' => "Maghintay.<br>Naglo-load...",
    '__locale' => "Lengguwahe ng interface",
    '__locale_is_not_defined' => "Ang wika ng interface ay hindi natukoy.",
    '__local_server_mysql' => 'Local MariaDB/MySQL server',
    '__local_server_postgresql' => 'Lokal na PostgreSQL server',
    '__local_server_mssql' => 'Lokal na MS SQL server',
    '__log_and_statistics_files' => 'Mag-log ng mga file at mga pang-estatistikang ulat',
    '__config_files' => 'Mga file ng konpigurasyon',
    '__chroot_files' => 'Chrooted environment',
    '__login' => "Login sa %1",
    '__login1' => "Mag-log in",
    '__login_disabled' => "Pinagbabawal ang pag-login",
    '__login_enabled' => "Pinahihintulutan ang pag-login",
    '__login_incorrect' => "Ikaw ay naglagay ng maling username o password.",
    '__login_name' => "Username sa %1",
    '__login_name_is_invalid' => "%1 username ay hindi wasto.",
    '__logon_time' => "Oras ng pag-logon",
    '__ma' => "Mga mail alias",
    '__mail' => "Mail",
    '__mail_alias_name' => "Pangalan ng mail alias",
    '__mail_autodiscovery' => 'Mail autodiscover',
    '__mail_exchanger_name_is_invalid' => "Ang pangalan ng mail exchanger ay hindi wasto.",
    '__mail_groups' => "Mga grupo ng mail",
    '__mail_list_engine' => "Software ng mailing list",
    '__mail_name' => "Mail account",
    '__mail_name_form' => "Mga katangian ng mail account",
    '__mail_names' => "Mga mail account",
    '__mail_serv' => "Server ng mail",
    '__mail_user' => 'User ng mail',
    '__mailgroup' => "Grupo ng mail",
    '__maillist' => "Mailing list",
    '__maillists' => "Listahan ng mailing",
    '__maillist_member' => 'Myembro ng mailing list',
    '__mailname' => "Mail account",
    '__mailname_redir_self' => "Ang mail account ay hindi maaring mag-forward ng mail sa sarili nito.",
    '__max_dom_num_reached_for_cl' => "Ang limitasyon ng bilang ng mga domain ay naabot para sa account ng kustomer na ito.",
    '__max_file_size_available' => "Pinakamataas na filesize na pinahihintulutan %1",
    '__max_subdom_num_reached_for_cl' => "Ang limitasyon ng bilang ng mga subdomain ay naabot para sa account ng kustomer na ito.",
    '__max_subdom_num_reached_for_dom' => "Ang limitasyon ng bilang ng mga subdomain ay naabot para sa domain na ito.",
    '__max_subdom_num_reached_for_key' => "Ang limitasyon ng bilang ng mga subdomain na pinahihintulutan ng license key ay naabot.",
    '__max_traffic_limit' => "Limitasyon ng trapiko",
    '__maximum_excl_ip_num' => "Mga mail account",
    '__mb' => "MB",
    '__mbytes' => "mga megabyte",
    '__mb_month' => "MB/buwan",
    '__mb_sec' => "MB/seg",
    '__gb_sec' => "GB/seg",
    '__tb_sec' => "TB/seg",
    '__mega' => "M",
    '__minute(s)' => '(mga)Minuto',
    '__mls_not_in_key' => "Ang product key ay hindi sumu-suporta sa multilingual interface.",
    '__modification_date' => "Petsa ng modipikasyon",
    '__module' => "Extensyon",
    '__month' => "Buwan",
    '__month(s)' => "(mga)Buwan",
    '__month1' => "Enero",
    '__month10' => "Oktubre",
    '__month11' => "Nobyembre",
    '__month12' => "Disyembre",
    '__month2' => "Pebrero",
    '__month3' => "Marso",
    '__month4' => "Abril",
    '__month5' => "Mayo",
    '__month6' => "Hunyo",
    '__month7' => "Hulyo",
    '__month8' => "Agosto",
    '__month9' => "Setyembre",
    '__monthly' => "Buwanan",
    '__months' => "Mga buwan",
    '__moved_permanently' => 'Nalipat ng permanente',
    '__mssql' => "Server ng Microsoft SQL",
    '__mssql__server' => "Server",
    'mssql__server' => "Pangalan ng Microsoft SQL server",
    'mssql__unable_to_change_server_name_db_exists' => "ang pangalan para sa server ay hindi maaring palitan: mayroon kahit isang database dito.",
    '__mssql_status' => "Estado ng Microsoft SQL server",
    '__multiply_login_deny' => "Hindi ka makapag-log sa. Isa pang user na may kaparehong username (%1) ay siya nang naka-log in sa Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Estado ng MySQL server",
    '__mysql_version' => "Bersyon ng MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "status ng MariaDB server",
    '__mariadb_version' => "bersyon ng MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "status ng Percona server",
    '__percona_version' => "bersyon ng Percona",
    '__name' => "Pangalan",
    '__name_invalid' => "Pangalan ay hindi wasto.",
    '__nameserver' => "nameserver",
    '__network' => "Network",
    '__networks' => "Mga network",
    '__no' => "Hindi",
    '__no_ip_address_with_properly_type_available' => "Hindi maibalik ang backed up data dahil walang akma na mga IP address na kinailangan para sa pagbalik.",
    '__no_clients_specified' => "Walang mga account ng kustomer ang natukoy.",
    '__no_comments' => "Walang komento.",
    '__nologin' => "Ipinagbabawal",
    '__none' => "Wala",
    '__not_configured' => "Hindi nakompigura",
    '__not_implemented_yet' => "Hindi pa nagagamit",
    '__not_supported_by_ftp' => "(hindi suportado ng FTP server)",
    '__notification' => "Abiso",
    '__num_displayed' => "%1 ng %2 ang pinapakita",
    '__num_is_invalid' => "Ang bilang ay hindi wasto.",
    '__object_not_found' => 'Ang object ay hindi nahanap: %1',
    '__off' => "I-off",
    '__ok' => "OK",
    '__old_passwd' => "Lumang %1 password",
    '__on' => "I-on",
    '__others' => "Iba",
    '__other_ip__will_be_added' => 'Ang ibang mga IP address (ay maidadagdag sa IP pool ng kustomer)',
    '__p' => "P",
    '__passwd' => "Password sa %1",
    '__passwd_is_invalid' => "%1 Password ay hindi wasto.",
    '__path' => "Path",
    '__perl_unix_support' => "Suporta sa Perl",
    '__perl_win_support' => "Suporta sa Perl",
    '__perm_denied' => "Ang pahintulot ay na-deny.",
    '__permissions' => "Mga permiso",
    '__personal_name' => "Personal na pangalan",
    '__pg_admin_not_activated' => "Ang PostgreSQL ay hindi nagawang aktibo sa pahina ng server administration.",
    '__pg_not_inst' => "Ang PostgreSQL ay hindi naka-install.",
    '__pg_not_run_or_inst' => "Ang PostgreSQL ay hindi naka-install o hindi tumatakbo.",
    '__pg_not_support_in_key' => "Ang PostgreSQL ay hindi suportado ng license key.",
    '__phone' => "Telepono",
    '__phosting' => "Pisikal na hosting",
    '__php_support' => "Tulong sa PHP",
    '__php_run_as_isapi' => "patakbuhin bilang extensyon ng ISAPI",
    '__php_safe_mode' => "Naka-on ang PHP 'safe_mode'",
    '__php_version' => "Bersyon ng PHP",
    '__physical' => "Pisikal na hosting",
    '__plesk_stat_pdir' => "Protektahan ang direktoryo '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Mga estatistika ng domain",
    '__plesk_stat_protect' => "Protektahan ang pag-access sa mga web na istatistika sa pamamagitan ng FTP username at password ng gumagamit",
    '__plesk_stat_protect_install' => "maaring gawin ang pag-access sa pamamagitan ng pinoprotektahan ng password na direktoryo '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Estado ng POP3 server",
    '__popen_error' => "Ang error ay nangyari habang tinatawag ang popen function.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Estado ng PostgreSQL",
    '__preferences' => "Mga setting",
    '__account_preferences' => "Mga Setting ng Account",
    '__interface_preferences_general' => 'Pangkalahatan',
    '__interface_preferences_default' => 'Kagustuhan sa Default Interface',
    '__interface_preferences_admin' => "Mga Pagnanais sa Interface ng Administrador",
    '__interface_template' => 'Template sa pag-customize ng interface',
    '__interface_preferences' => "Mga nais na Interface",
    '__proceed?' => "Nais mo bang magpatuloy?",
    '__provider_contact_name' => "Pangalan sa pakikipag-ugnayan ng mayari",
    '__python_unix_support' => "Suporta sa Python",
    '__python_win_support' => "Suporta sa Python",
    '__quota' => "Quota",
    '__r' => "R",
    '__reconfigure' => "Muling konpigurahin",
    '__record_type' => "Uri ng tala",
    '__release' => "Pagpapalabas",
    '__remote_db_not_supported_by_key' => 'Hindi suportado ng license key ang Remote database hosting.',
    '__remove_protection' => 'Alisin ang Proteksyon',
    '__report' => "Ulat",
    '__report_size_na' => "Hindi makukuha ang serbisyo",
    '__reports_list' => "Mga ulat",
    '__requested' => "Hiningi",
    '__required_fields' => "Mga kinailangang field",
    '__resp_name_invalid' => "Hindi wasto na pangalan ng Auto-Reply. Gamitin lamang ang mga alphanumeric, mga tuldok, salungguhit at mga simbolo puting espasyo.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Pangalan ng server ay hindi wasto.",
    '__screenshots' => 'Mga Screenshot',
    '__script_warning' => "Sa pag-alis ng kakayahan sa scripting mula sa domain na ito lahat ng influenced scripts ay ipapakita sa plain teksto kapag tinawag ng browser.  Ito ay makakabuti para sa administrador na alisin lahat ng dependent scripts mula sa binigay na domain.",
    '__sec' => "(na) Segundo",
    '__second(s)' => "Segundo",
    '__see_list_of_logged_in' => "Tignan ang listahan ng kasalukuyang nag-logged in na mga user.",
    '__select_certs_to_remove' => "Pumili ng mga sertipiko na aalisin.",
    '__select_files_to_remove' => "Pumili ng mga file na aalisin.",
    '__select_ip' => "Magtakda ng IP Address",
    '__select_ip_to_remove' => "Pumili ng IP address na aalisin.",
    '__select_domain_template' => "Gumamit ng mga setting ng domain template",
    '__select_templates_to_remove' => "Pumili ng mga template na aalisin.",
    '__server' => "Server",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Database server ng MariaDB/MySQL",
    '__service_description__mysql' => "Database server ng MariaDB/MySQL",
    '__service_title__web' => "Web server",
    '__service_description__web' => "Web server",
    '__service_title__smtp' => "SMTP server",
    '__service_description__smtp' => "SMTP server",
    '__service_title__mail' => "IMAP/POP3 server",
    '__service_description__mail' => "IMAP/POP3 server",
    '__service_title__dns' => "DNS Server",
    '__service_description__dns' => "DNS Server",
    '__service_title__postgresq' => "Database server ng PostgreSQL",
    '__service_description__postgresq' => "Database server ng PostgreSQL",
    '__service_title__spamassassin' => "Serbisyo ng pag-filter sa spam ng SpamAssassin",
    '__service_description__spamassassin' => "Serbisyo ng pag-filter sa spam ng SpamAssassin",
    '__all_services' => "Lahat ng mga serbisyo",
    '__sessions' => "Mga sesyon",
    'sessions__feature_ftp_session_manager_not_supported' => "Ang katangian ng mga sesyon ng FTP ay hindi suportado ng kasalukuyang FTP server",
    '__sessions_list' => "Mga sesyon",
    '__set' => "Buhayin",
    '__shared' => "Naibahagi",
    '__shell_access_warning' => "Pagpapahintulot ng pag-access sa shell ng system ay lubhang mapanganib para sa seguridad ng system. Payagan lamang ang pag-access sa system kung malinaw mong na maunawaan kung ano ang iyong ginagawa, at para lamang sa mga pinagkakatiwalaang mga user. Nais mo ba talagang payagan ang pag-access?",
    '__siteapp_not_support_in_key' => "Ang web application ay hindi suportado ng license key",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Ang konpigurasyon ng web application na ito ay manu-manong binago. Upang maprotektahan ang manu-manong pagbabago, reconfiguration sa pamamagitan ng Plesk ay ginawang hindi magagamit.',
    '__site_management' => "Web Publishing", // indirect
    '__size' => "Laki",
    '__skins' => 'Mga Balat',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Estado ng SMTP server",
    '__some_fields_are_empty_or_invalid' => "Ang ibang mga hanay ay walang laman o naglalaman ng hindi wastong marka.",
    '__no_email_addresses_selected' => 'No email addresses were selected.',
    '__unable_to_set_parameters' => "Hindi maitakda ang mga parameter ng component.",
    '__spamassassin' => "Spam Filter",
    '__spamassassin_status' => "Estado ng SpamAssassin",
    '__spamd_status' => 'Estado ng Spam Filter',
    '__splited_backup' => "(multivolume backup)",
    '__split_backup_file' => "Lumikha ng isang multivolume backup",
    '__split_backup_size' => "Dami ng laki",
    '__split_backup_less_than_500' => "Hindi suportado ang dami ng mga laki ng mas mababa sa 500 megabytes",
    '__ssi' => "SSI",
    '__ssi_support' => "Suporta sa SSI",
    '__ssi_with_html' => "Gumamit ng mga file na SSI for *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Suporta sa SSL/TLS",
    '__same_ssl' => "Gumamit ng iisang directory sa pagtatabi ng content na may at walang SSL/TLS",
    '__same_ssl_cu' => "Karaniwang content na may at walang SSL/TLS",
    '__state' => "Estado/Probinsya",

    '__status__Active' => 'Aktibo',
    '__status__active' => 'aktibo',
    '__status__Passive' => 'Inilipat sa off',
    '__status__passive' => 'pinatay',
    '__status__off' => 'pinatay',
    '__status__with_parent' => 'pinatay',
    '__status__backup_restore' => 'pansamantalang sinuspinde para sa pag-back up o pagpapanumbalik',
    '__status__admin' => 'sinuspinde ng administrador ng server',
    '__status__resseler' => 'sinuspinde ng reseller',
    '__status__client' => 'sinuspinde ng kustomer',
    '__status__unknown' => 'hindi alam ang estado',

    '__status_of' => "%1 estado",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel server", // indirect
    '__subdomain' => "Subdomain",
    '__subdomain_name' => "Pangalan ng Subdomain",
    '__subdomain_name_in_ASCII_form' => "Pangalan ng subdomain sa pormat na ASCII",
    '__subdomains' => "Mga subdomain",
    '__domainaliases' => "Mga alyas ng domain",
    '__subdomains_list' => "Mga subdomain",
    '__subdomains_not_support_in_key' => "Ang mga operasyon ng subdomain ay hindi suportado ng license key",
    '__sys_user_type' => "User ng FTP",
    '__sys_user_type_main' => "Gamitin ang account ng FTP user ng main domain",
    '__sys_user_type_native' => "Lumikha ng magkahiwalay na account ng FTP user para sa subdomain na ito",
    '__target_domain' => "Target na domain",
    '__template' => "Template",
    '__template_not_accepted' => "Hindi tinatanggap ang template: ang sumusunod na mga limitasyon ay sumobra.",
    '__templates' => "Mga template",
    '__templates_list' => "Mga template",
    '__tera' => "T",
    '__title' => "Titulo",
    '__total' => "Kabuuan %1",
    '__total_size' => "Kabuuang laki",
    '__total_used' => "Kabuuan Nagamit",
    '__traffic' => "Trapiko",
    '__traffic_by_client' => "Trapiko ng kustomer",
    '__traffic_by_domain' => "Trapiko ng domain",
    '__traffic_by_service' => "Trapiko ng serbisyo",
    '__traffic_history' => "Kasaysayan ng trapiko",
    '__unable_change_locale' => "Hindi mapalitan ang interface language: %1",
    '__unable_create_new_dom' => "Hindi makalikha ng isang domain: %1",
    '__unable_define_dom_name' => "Hindi matukoy ang domain name: %1",
    '__unable_define_necessary_properties' => "Hindi matukoy ang lahat na kailangan na mga katangian.",
    '__unable_define_properties' => "Hindi matukoy ang mga katangian: %1",
    '__unable_exec_util' => "Hindi maisagawa ang mga kagamitan: %1",
    '__unable_get_dns_a_recs' => "Hindi maibalik ang mga IP address para sa A DNS para sa hosting account na ito: %1",
    '__unable_get_mbox_quota' => "Hindi makuha ang impormasyon sa limitasyon ng laki ng mailbox.",
    '__unable_redirect_to_myself' => "Hindi ma-forward sa parehong account.",
    '__unable_redirect_to_my_alias' => "Hindi mai-forward ang mail sa mail alias.",
    '__default_domain_redirect_to_myself' => "Hindi ma-set ang domain bilang default para sa IP address:\n muling pag-direkta sa kanyang sarili ay nakita.",
    '__unable_remove_client' => "Hindi maalis ang kustomer: %1",
    '__unable_set_up_mbox_quota' => "Hindi maitakda ang limitasyon ng laki ng mailbox para sa domain: %1",
    '__unable_setup_pass' => "Hindi makapag takda ng password: %1",
    '__unable_to_create_new_account' => "Hindi makalikha ng isang account: %1",
    '__unable_to_define_db_size' => "Hindi matukoy ang laki ng database.",
    '__unable_to_enable_short_names' => "Hindi mapahintulutan ang paggamit ng maikling mga pangalan ng mail account para sa POP3/IMAP na mga account.",
    '__unable_to_fetch_data_from_submit' => "Hindi makuha ang ipinasang data: %1",
    '__unable_to_open_file' => "Hindi mabuksan ang file%1: %2",
    '__unable_to_update_subdomain' => "Hindi makagawa ng mga pagbabago sa subdomain: %1",
    '__unable_update_cl_data' => "Hindi mai-save ang mga pagbabago sa account ng user: %1",
    '__unable_update_db_params' => "Hindi magawa ang pag-update ng mga parameter ng database: %1",
    '__unable_update_dom_data' => "Hindi magawa ang pag-update ng domain data: %1",
    '__undefined' => "hindi natukoy",
    '__uninstall' => "I-uninstall",
    '__unknown_error' => "Hindi kilalang error",
    '__unlimited_lower' => "Walang-limitasyon",
    '__unset' => "Patayin",
    '__update' => "Pag-Update",
    '__uploaded_file_is_invalid' => "Ang ginawang pag-upload ng file ay hindi wasto: %1",
    '__url' => "URL",
    '__usage' => "Paggamit ng disk",
    '__user_already_logged' => "Ang isa pang user na mayroong parehong username (%1) ay naka-log in sa Plesk.",
    '__version' => "Bersyon",
    '__aps_license' => "Lisensya ng susi",
    '__vh_type' => "Uri ng virtual na host",
    '__vhosts_apache_status' => "Estado ng web user",
    '__wrong_charset_conversion' => 'Maling charset, pagsalin mula sa "%1" hanggang "%2" ay hindi pinayagan',
    '__warning_' => "Babala!",
    '__warning_excl_ip_num' => "Dedikadong IP address",
    '__warning_expiration' => "Petsa na walang-bisa",
    '__web_scripting' => "Web scripting", // indirect
    '__web_serv' => "Web server", // indirect
    '__web_statistic' => "Mga estatistika ng Web", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Ang webalizer ay hindi naka-install sa server. Kontakin ang iyong service provider para sa tulong kasama ang pag-install ng webalizer.",
    '__webstat_support' => "Mga estatistika ng Web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Kapag lumipat ka mula sa isang programa ng mga estatistika sa isa iba, ang lahat ng mga ulat na nilikha ng nakaraang ginamit na mga estatistika ng programa ay nabura at bagong ulat ay nilikha alinsunod sa mga impormasyon nabasa mula sa mga file ng log na pinananatili sa server. Nangangahulugan ito na kung na-konpigura ang system (sa Domains > domain name > Log Manager > Log Rotation) upang panatilihin lamang ang mga file ng log para sa nakaraang buwan, pagkatapos ay mga estatistika ng web ay makukuha lamang para sa nakaraang buwan. Gusto mo bang lumipat sa ibang mga estatistika ng pakete?",
    '__webstat_perm_denied' => 'Ikaw ay walang pahintulot upang mangasiwa ng mga estatistika ng web.',
    '__webuser' => "Web user",
    '__sysusers_list' => "Mga user ng system",
    '__sysuser' => "User ng system",
    '__weekly' => "Lingguhan",
    '__whats_new_in_version' => "Ano ang bago sa Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Ang operasyon na ito ay magagamit lamang para sa mga domain na mayroong web hosting.",
    '__wrong_hosting_type__none' => 'Walang nakonpigura na web hosting sa domain %1.',
    '__wrong_hosting_type__std_fwd' => 'Ang domain %1 ay mayroong nakonpigura na pamantayang forwarding. Ang operasyon na ito ay magagamit lamang para sa mga domain na mayroong web hosting.',
    '__wrong_hosting_type__frm_fwd' => 'Domain %1 ay mayroong nakonpigura na frame forwarding. Ang operasyon na ito ay magagamit lamang para sa mga domain na mayroong web hosting.',
    '__wu' => "Mga user ng Web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Napalitan na ang prefix na WWW. Tiyaking babaguhin mo ang SSL/TLS certificate nang alinsunod sa nararapat.",
    '__year' => "Taon",
    '__year(s)' => "(Mga)Taon",
    '__yes' => "Oo",
    '__you' => "Ikaw",
    '__zip_code' => "Postal/ZIP code",
    '__form_normal' => "Karaniwan",
    '__form_advanced' => "Advanced",

    'admin_ed__edit_administrator_info' => "Ini-edit ng Profile ng Administrator",
    'admin_ed__create_default_client' => "Nais kong lumikha ng default na account ng kustomer.",
    'admin_ed__unable_update' => "Hindi magawa ang pag-update ng impormasyon ng administrador: %1",

    'auth__update_admin_info' => "Paki-lagay ng impormasyon ng administrador. Ang impormasyon na ito ay kailangan na isagawa %1.",
    'auth__you_not_have_perm' => "Ikaw ay walang pahintulot para pangasiwaan ang domain na ito.",
    'auth__key_expired_admin' => 'Nag-expire ang iyong lisensya ng Plesk. Para patuloy na magamit ang Plesk, i-renew ang iyong lisensya o bumili ng bago.',
    'auth__key_expired_admin_restricted' => 'Nag-expire ang iyong lisensya ng Plesk. Makipag-ugnayan sa iyong service provider para patuloy na magamit ang Plesk.',
    'auth__key_expired_client' => 'Nag-expire ang lisensya ng Plesk. Makipag-ugnayan sa iyong hosting provider.',
    'autoinstaller__not_installed' => 'Ang component ng autoinstaller hindi naka-install.',
    'autoinstaller__release_action' => 'Magagamit na operasyon',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Pag-upgrade sa bagong bersyon ng Plesk',
    'autoinstaller__release_action_update' => 'Pag-update o pagdagdag ng bagong mga components',
    'autoinstaller__release_action_up2date' => 'Ikaw ay mayroong bagong bersyon(up-to-date version)',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Hindi naka-install',
    'autoinstaller__component_action_update' => 'Mayroong mga update',
    'autoinstaller__component_action_upgrade' => 'Ang pag-update ay magagamit',
    'autoinstaller__component_action_up2date' => 'Ikaw ay mayroong bagong bersyon(up-to-date version)',
    'autoinstaller__component_action_error' => 'walang magagamit na mga update',
    'autoinstaller__component_serverbuildtime' => 'Pinakabagong pagpapalabas',
    'autoinstaller__component_localbuildtime' => 'Ang iyong pagpapalabas',
    'autoinstaller__component_installed_version' => 'Iyong bersyon',
    'autoinstaller__component_available_version' => 'Pinakabagong bersyon',
    'autoinstaller__component' => 'Component',
    'autoinstaller__components' => 'Mga components',
    'autoinstaller__components_title' => '%1 Mga component',
    'autoinstaller__component_dependency_note' => 'kailangan para sa pag-install ng mga component na iyong napili',
    'autoinstaller__install_confirm' => 'Oo, Nais kong i-install ang mga components na ito',
    'autoinstaller__install_confirm_request' => 'Piliin ang check box upang kumpirmahin',
    'autoinstaller__install_title' => 'Kumpirmahin ang pag-install ng Napiling mga Components',
    'autoinstaller__key_update_confirm' => 'Kumpirmahin ang pag-laktaw sa pag-update ng key at pag-install ng default key',
    'autoinstaller__key_update_confirm_request' => 'Piliin ang check box upang kumpirmahin.',
    'autoinstaller__key_update_failed' => '<p>Hindi magawa ng Plesk na i-update ang iyong lisensya sa produkto.</p><p>%1</p><p>Sa pagpapatuloy ng pag-upgrade nang walang angkop na lisensya sa produkto ay magbubunga na instalasyon ng isang default na lisensya na mayroong limitadong paggamit. Pinapayuhan ang mga administrador na una munang kumuha ng angkop na license key bago magpatuloy sa pag-upgrade ng produkto.</p>',
    'autoinstaller__email' => 'Ipadala ang abiso sa',
    'autoinstaller__email_admin' => "Email ng administrador",
    'autoinstaller__email_email' => 'Email address ng custom...',
    'autoinstaller__release' => 'Pangalan ng pagpapalabas',
    'autoinstaller__releases' => 'Magagamit na pagpapalabas',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Piliin ang components nai-install',
    'autoinstaller__status_error' => 'Error: %1',
    'autoinstaller__status_install_error' => 'Ang pag-install ay hindi masimulan: %1',
    'autoinstaller__status_install_busy' => 'Ang pag-install ay hindi masimulan: may ibang proseso ng pag-install ang kasalukuyang tumatakbo.',
    'autoinstaller__status_install_ok' => 'Nasimulan ang pag-install. Ikaw ay ma-abisuhan ng pagsulong ng pag-install sa pamamagitan ng email (%1).',
    'autoinstaller__status_query_busy' => 'Ang pag-install ay nasa-pagsulong.',
    'autoinstaller__status_query_error' => 'Hindi maibalik ang estado ng pag-install: %1',
    'autoinstaller__status_unknown' => 'Hindi maibalik ang estado ng autoinstaller.',
    'autoinstaller__status_busy' => 'Autoinstaller ay abala, maghintay.',
    'autoinstaller__configure_title' => 'Mga Setting ng Updater',
    'autoinstaller__preferences_legend' => 'Mga setting',
    'autoinstaller__target' => 'Pansamantalang pag-download ng direktoryo',
    'autoinstaller__target_invalid' => "Tukuyin ang absolute path",
    'autoinstaller__check_updates' => 'Magrepaso para sa mga pag-update sa pag-login sa Plesk ng administrador',
    'autoinstaller__check_updates_warning' => 'Bago <a href="%1">mga pag-update</a>magagamit para sa %2',
    'autoinstaller__source_type' => 'Uri ng source',
    'autoinstaller__source' => 'Source URL',
    'autoinstaller_source__preferences_legend' => 'Mga setting',
    'autoinstaller_source__type' => 'Uri ng source',
    'autoinstaller_source__url_invalid' => 'Hindi wastong source',
    'autoinstaller_source__url_invalid_network' => 'Hindi wastong source ng URL (Halimbawa: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Source URL',
    'autoinstaller__source_invalid_network' => 'Iyong natukoy ang hindi wastong address ng network',
    'backup__repository' => 'Lokasyon ng mga imbakan ng mga na-bacvkup na mga file',
    'backup__error_notify_email' => 'Kapang mayroong error na nangyari habang ginagawa ang pag-back up, magpadala ng abiso sa email',
    'backup__dump_info' => "Impormasyon ng pag-backup",
    'backup__dump_file_name_not_defined' => "Ang backup file ay hindi natukoy",
    'backup__local_file' => 'Lokal na backup file',
    'backup__domain_ftp' => 'remote FTP server',
    'backup__wrong_path' => "Hindi tamang daan sa backup na imbakan ng mga file: Huwag gamitin ang pagkakasunud-sunod ng mga character ../../",
    'backup__unable_to_connect_to_ftp_server' => "Hindi maka-connect sa FTP server: %1",
    'backup__unable_to_read_file' => 'Hindi mabasa ng backup file.',
    'backup__backup_task_does_not_exist' => "Ang tungkulin ng pag-backup ay hindi umiiral, dapat mo itong gawin bago patayin.",
    'backup__restore_params' => "Parameters ng pagbalik",
    'backup__confirmation' => "Babala: ang domain ay hindi magagamit habang isinasagawa ang backup/restoration.",
    'backup__backup_method' => 'Paraan ng pag-backup',
    'backup__dumpfile_name' => "Pangalan ng backup file",
    'backup__dumpfile_name_is_invalid' => "Ang pangalan ng backup file ay hindi wasto: gumamit lamang ng alphanumeric, patlang, tuldok at underscore na mga simbolo, huwag gumamit ng pangalan tulad ng paglalarawan.* para sa pangalan ng backup file.",
    'backup__email_required' => "Ang iyong email address ay kailangan upang mapanatili na ikaw ay makaalam sa pag-backup at progreso sa pag-restore. Tukuyin ang iyong email sa mga detalye ng account.",
    'backup__error_during_backup' => "Hindi makalikha ng backup file: %1",
    'backup__input_email_warning' => "Kailangan mong tukuyin kung email para sa abiso o burahin ang check box.",
    'backup__make_download' => "huwag i-imbak ang backup na file sa imbakan, i-download lamang ito",
    'backup__make_dump' => 'Lumikha ng backup file at iimbak sa lokal na imbakan',
    'backup__makedump_to_ftp' => 'lumikha ng backup file at -itago sa remote FTP server',
    'backup__restore_ip' => "IP address para sa pagbalik",
    'backup__select_dumpfile' => "Pumili ng backup file.",
    'backup__time' => "Oras ng pag-backup",
    'backup__day' => 'Araw ng pag-backup',
    'backup__view_dump_info' => "View ang impormasyon ng pag-backup para sa domain %1",
    'backup__wrong_domain_name' => "Ang backup file ay naglalaman ng datos ng domain %1 at kaya hindi maaring ibalik sa domain %2",
    'backup__incorrect_ftp_user_or_passwd' => "Maling user o password ng FTP. Iwasto ang FTP Account Properties",
    'backup__access_denied' => "Ang pag-access ay na-deny. Iwasto ang FTP Account Properties",
    'backup__restore_from' => "Ibalik %1",
    'backup__domain_session_failed' => 'Ang domain %1 ay hindi na-back up',
    'backup__client_session_failed' => 'Ang account ng kustomer %1 ay hindi na-back up',
    'backup__domain_session_restore_failed' => 'Ang domain %1 hindi naibalik',
    'backup__client_session_restore_failed' => 'Hindi naibalik ang account ng kustomer %1',
    'backup__domain_session_complete' => 'Ang domain %1 ay na-back up',
    'backup__domain_session_backup' => 'Backup ng domain %1',
    'backup__client_session_backup' => 'Pag-backup ng kustomer %1',
    'backup__domain_stop_title' => 'Pagtigil ng pag-backup ng domain %1',
    'backup__client_stop_title' => 'Pagtigil ng pag-backup ng account ng kustomer %1',
    'backup__domain_restore_stop_title' => 'Pagtigil ng restoration ng domain %1',
    'backup__client_restore_stop_title' => 'Pagtigil ng Restoration ng account ng kustomer %1',
    'backup__domain_session_backup_stop' => 'Ikaw ay magpapatigil ng aktibong proseso ng backup. Ang backup file ay hindi malikha.',
    'backup__backup_stop_confirm' => 'Oo, Nais kong itigil ang proseso ng backup',
    'backup__restore_stop_confirm' => 'Oo, Nais kong itigil ang proseso ng restoration',
    'backup__domain_session_restore' => 'Restoration ng domain %1',
    'backup__domain_session_restore_stop' => 'Ikaw ay magpapatigil ng aktibong proseso ng restoration.',
    'backup__domain_backup_file_info' => 'Impormasyon ng Backup File ng Domain',
    'backup__domain_backup_file_list' => 'umiiral na mga backup file',
    'backup__domain_backup_progress' => 'Progreso ng Pag-back up ng website %1',
    'backup__domain_restore_progress' => 'Progreso ng pagbabalik up ng website %1',
    'backup__domain_backup_progress_elapsed_time' => 'Nakalipas na oras: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Nakalipas na oras: %1',
    'backup__domain_restore_session_complete' => 'Ang domain %1 ay naibalik.',
    'backup__domain_restore_session_complete_message' => 'Ang domain %1 naibalik.',
    'backup__domain_backup_file_delete' => 'Ang sumusunod na mga backup file ay matatanggal:',
    'backup__domain_backup_file_for_remove' => 'Pumili ng mga backup file na nais mong tanggalin',
    'backup__backup_overwrite_file_confirm' => 'Kumpirmasyon sa pagpapalit',
    'backup__backup_overwrite_file_confirm_text' => 'Ang backup file na mayroong pangalan na "%1" ay umiiral. Nais mo bang palitan ito?',
    'backup__backup_confirm_overwrite' => 'Kumpirmahin ang pagpalit ng file',
    'backup__backup_overwrite_legeng' => 'Ipalit',
    'backup__backup_not_contain_domain' => 'Ang mga backup file ay hindi naglalaman ng impormasyon tungkol sa domain %1',
    'backup__backup_not_contain_client' => 'Ang mga backup file ay hindi naglalaman ng impormasyon tungkol sa account ng kustomer %1',
    'backup__backup_client_info' => "Mga setting ng back up at mga detalye ng account ng kustomer",
    'backup__client_backup_progress' => 'Progreso ng Pag-back up ng Account ng Kustomer %1',
    'backup__client_session_complete' => 'Ang account ng kustomer %1 ay na-back up',
    'backup__client_backup_file_info' => 'Impormasyon ng Backup File ng Kustomer',
    'backup__restore_client_info' => "Ibalik ang mga setting at mga detalye ng account ng kustomer",
    'backup__client_session_restore' => 'Pag-restore ng Account ng Kustomer %1',
    'backup__client_db_server_map' => 'Pagmamapa ng Mga Server ng Database',
    'backup__domain_db_server_map' => 'Pagmamapa ng Mga Server ng Database',
    'backup__client_restore_session_complete_message' => 'Naibalik ang account ng kustomer %1.',
    'backup__client_restore_session_complete' => 'Naibalik ang account ng kustomer %1.',
    'backup__restore_select_some' => 'Pumili ng mga bagay na nais mong ibalik.',
    'backup__client_restore_progress' => 'Progreso ng Restoration para sa Account ng Kustomer %1',
    'backup__new_backup' => 'Paglikha ng Bagong Backup',
    'backup__done' => 'Tapos:',
    'backup__done_domains' => '%1 ng (mga)domain sa %2',
    'backup__done_clients' => '%1 ng (mga)kustomer sa %2',
    'backup__remaining' => 'Natitira:',
    'backup__remaining_domains' => '%1 (mga)domain',
    'backup__remaining_clients' => '%1 (mga)kustomer',
    'backup__overall_backup_progress' => 'Kabuuang progreso ng backup',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => 'Ang command "%1" ay hindi pinansin',
    'backup__no_objects' => 'walang mga bagay para sa backup',
    'backup__cli_warning_not_enough_ip' => 'BABALA: hindi sapat na mga IP address upang ganapin ang default na IP mapping:',
    'backup__local_repository' => "Imbakan ng Plesk",
    'backup__ftp_repository' => 'FTP storage',
    'backup__ftp_login' => 'Username',
    'backup__ftp_password' => 'Password',
    'backup__ftp_account_settings' => 'Mga Setting ng FTP Account',
    'backup__ftp_account_preferences' => 'Mga setting ng FTP account',
    'backup__repository_not_exist' => 'Ang direktoryo ay hindi umiiral',
    'backup__repository_not_readable' => 'Ang natukoy na direktoryo ay hindi nababasa',
    'backup__ftp_repository_not_configure' => 'Upang gamitin ang isang imbakan ng FTP na backup, <a href=\'%1\'> tukuyin ang FTP account</a> unang.',
    'backup__ftp_repository_list_not_configure' => 'Ang mga setting ng account ay hindi natukoy',
    'backup__repository_list_unable_listing' => 'Hindi maibalik ang listahan ng mga file',
    'backup__ftp_repository_unable_listing' => 'Hindi maibalik ang pag-lista ng direktoryo "%1":',
    'backup__repository_legend' => 'Imbakan ng mga na-backup na mga file',
    'backup__store_in_repository' => 'Mag-store ng mga file sa',
    'backup__local_repository_lable' => 'Lokal na imbakan',
    'backup__ftp_repository_lable' => 'FTP storage',
    'backup__ftp_repository_not_configure_hint' => '(Ang mga setting ng account ay hindi natukoy)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(ang FTP account ay hindi natukoy o hindi suportado)',
    'backup__other_user_process_modified' => 'Inihinto ng ibang user ang pagproseso ng backup o proseso ng paglilipat.',
    'backup__another_user_exist' => 'Ang operasyon na nasa progreso ay ginawa ng ibang user ng Plesk. Ang user na ito ay naka-log in parin sa Plesk.',
    'backup__ftp_repository_wait' => 'Mangyaring maghintay habang binabawi ang impormasyon tungkol sa FTP na imbakan',
    'backup__ftp_write_test_failed' => 'Nabigo sa pagsulat ng pagsubok ng datos sa FTP account %1:',
    'backup__ftp_storage' => 'FTP(S) storage',
    'bt_upload_to_repository' => 'Mag-upload ng mga File sa Lokal na Imbakan',
    'bt_new_restore' => "Ibalik",
    'bt_backup_schedule' => "Naka-iskedyul na Backup",
    'backup_exist_backups' => "Umiiral na mga backup file",
    'backup_dialog__page_title' => "Paglikha ng backup file",
    'backup_dialog__please_wait' => "Ang proseso ng pag-back up ay magsisimula. Ang operasyon na ito ay maaring magtagal. Maghintay...",
    'backup_conf__page_title' => 'Konpigurasyon ng backup',
    'bt_accept' => "Tanggapin",
    'bt_access' => "Pag-access",
    'bt_action_log' => "Action Log",
    'bt_add' => "Magdagdag",
    'bt_add_client' => "Itakda da mga Users",
    'bt_database_server_add' => 'Magdagdag ng Database Server',
    'bt_add_services' => "Magdagdag ng mga Serbisyo",
    'bt_anonftp_stats' => "Mga Istatisitka ng Anon.FTP",
    'bt_anonymous_ftp' => "Hindi kilalang FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Ilakip",
    'bt_autoinstaller' => 'Updater',
    'bt_auto-updates' => 'Updater',
    'bt_back' => "<< Bumalik",
    'bt_backup' => "Back up",
    'bt_backup_configure' => "Mga Setting ng Backup",
    'bt_buy_certs' => "Bumili ng mga Sertipiko",
    'bt_card' => "Kard",
    'bt_cert' => "Sertipiko",
    'bt_certificates' => "Mga sertipiko",
    'bt_change_passwd' => "Baguhin ang Password",
    'bt_clear' => "Linisin",
    'bt_client_templates' => "Mga Template ng Kustomer",
    'bt_clients' => "Mga kustomer",
    'bt_codepage_change' => 'Palitan ang Pag-encode',
    'bt_comp_info' => "Pangasiwaan ng mga Components",
    'bt_configure_maillists' => "Mag-set up ng Mailman",
    'bt_configure' => 'I-konpigura',
    'bt_copy' => "Kopya",
    'bt_copy_move' => "Kopyahin/Ilipat",
    'bt_create' => "Gumawa",
    'bt_create_account' => "Lumikha ng isang Account",
    'bt_create_dir' => "Magdagdag ng isang Directory",
    'bt_create_file' => "Magdagdag ng File",
    'bt_count_size' => "Kalkulahin ang Laki",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Nag-iskedyul ng Tungkulin",
    'bt_custom_button_new' => "Magdagdag ng isang Buton",
    'bt_custom_buttons' => "Mga buton ng custom",
    'bt_customize' => "I-customize",
    'bt_databases' => "Mga database",
    'bt_database_servers' => 'Mga Database Server',
    'bt_sqlservers' => "Mga Database Server",
    'bt_db_usr_new' => "Magdagdag ng User ng Database",
    'bt_db_new' => "Magdagdag ng Database",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Gumawa ng Default para sa Webadmin",
    'bt_decline' => "Tanggihan",
    'bt_default' => "Default",
    'bt_defaultcomponents' => "Mga Serbisyo ng Ikatlong partido",
    'bt_defaults' => "Mga Default",
    'bt_delete' => "Burahin (Delete)",
    'bt_directories' => "Protektadong mga Direktoryo",
    'bt_disable' => "Patayin",
    'bt_dns_zone_sync' => 'Ipatupad ang mga DNS Template Change',
    'bt_dnsrecord_add' => 'Magdagdag ng Record',
    'bt_do_backup' => "Back Up",
    'bt_do_restore' => "Ibalik",
    'bt_do_upload' => "Pag-upload",
    'bt_domain_aliases' => "Mga Domain Alyas",
    'bt_domain_templates' => "Mga Templates ng Domain",
    'bt_domain_user' => "Administrador ng Domain",
    'bt_domain_user_passwd' => "Password ng Administrador ng Domain",
    'bt_domains' => "Mga domain",
    'bt_domain_alias_add' => 'Magdagdag ng Domain Alias',
    'bt_download' => "I-download",
    'bt_edit' => "I-edit",
    'bt_enable' => "Buksan",
    'bt_export' => 'I-eksport',
    'bt_extras' => "Mga Ekstra",
    'bt_finish' => "Tapos",
    'bt_ftp_account' => "Mga Katangian ng FTP Account",
    'bt_forget_password' => "Nakalimutan ang Password?",
    'bt_fp_ssl_webadmin' => "Webadmin ng FP-SSL/TLS",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Mga Istatistika ng FTP",
    'bt_get_password' => "Kumuha ng Password",
    'bt_global_changes' => "Baguhin",
    'bt_help' => "Tulong",
    'bt_hide_aliases' => "Itago ang mga Alyas",
    'bt_hide_toolbar' => 'Itago ang Toolbar',
    'bt_hide_subdomains' => "Itago ang mga Subdomain",
    'bt_hide_domainaliases' => "Itago ang mga Domain Alias",
    'bt_home' => "Home",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Pag-install",
    'bt_ip_aliasing' => "Mga IP Address",
    'bt_ip_add' => "Magdagdag ng IP Address",
    'bt_ip_pool' => "IP Pool",
    'bt_key_info' => "Impormasyon ng Lisensya",
    'bt_key_buyonline_addons' => 'Mag-Order ng mga Plesk Add-on',
    'bt_key_buyonline_upgrades' => 'Mag-order ng mga Pag-upgrades ng Plesk',
    'bt_key_buyonline_new' => 'Mag-Order ng Bagong Key',
    'bt_limits' => "Mga limitasyon",
    'bt_locale_add' => 'Magdagdag ng Locale',
    'bt_locales' => 'Mga Locale',
    'bt_log_manager' => "Tagapangasiwa ng log",
    'bt_login' => "Mag-Log in",
    'bt_logo' => "Branding",
    'bt_logo_send_link' => "Ilakip ang Link",
    'bt_logo_send_logo' => "Ilakip ang Logo",
    'bt_logout' => "I-Log Out",
    'bt_logrotation' => "Log Rotation",
    'bt_mail' => "Mail",
    'bt_mail_alias_add' => "Magdagdag ng Mail Alias",
    'bt_mail_aliases' => "Mga Mail Alias",
    'bt_mail_group_add' => "Magdagdag ng Miyembro",
    'bt_mail_groups' => "Mga Grupo",
    'bt_mail_name_add' => "Magdagdag ng Mail Account",
    'bt_mail_preferences' => "Mga setting",
    'bt_mail_group' => "Grupo ng mail",
    'bt_mail_mailbox' => "Mailbox",
    'bt_mail_redirect' => "Forwarder",
    'bt_mail_resp_add' => "Magdagdag ng Auto-Reply",
    'bt_mail_resp_attach_add' => "Magdagdag ng Attachment",
    'bt_mail_resp_files' => "Mga Attachment File",
    'bt_mail_responders' => "Mga Auto-reply",
    'bt_mail_spamfilter' => "Spam Filter",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Magdagdag ng Mailing List",
    'bt_maillists' => "Mga Mailing List",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Lumikha ng Backup",
    'bt_manage' => "Tagapangasiwa",
    'bt_master' => "Master",
    'bt_migrate' => 'Ilipat',
    'bt_modules_add' => 'Magdagdag ng Extensyon',
    'bt_modules_manage' => 'Mangasiwa sa mga Extensyon',
    'bt_move' => "Ilipat",
    'bt_new_client' => "Magdagdag ng Customer Account",
    'bt_new_domain' => "Magdagdag ng Domain",
    'bt_next' => "Susunod >>",
    'bt_next_page' => "Susunod",
    'bt_network_add' => "Magdagdag ng Network",
    'bt_notifications' => "Mga Notification",
    'bt_off' => "I-off",
    'bt_on' => "I-on",
    'bt_on_off' => "Buksan/Patayin",
    'bt_performance' => 'Pagganap',
    'bt_permissions' => "Mga permiso",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Mga setting",
    'bt_prev_page' => "Nakaraan",
    'bt_preview' => 'Pagtingin ng Site',
    'bt_print' => "I-print",
    'bt_reboot' => "I-reboot",
    'bt_reload' => "I-reload",
    'bt_refresh' => "I-refresh",
    'bt_register' => "Irehistro",
    'bt_remove' => "Alisin",
    'bt_enable_selected' => 'Buksan',
    'bt_disable_selected' => 'Patayin',
    'bt_repair_ip' => "Ayusin ang IP",
    'bt_report' => "Ulat",
    'bt_report_new' => "Magdagdag ng Layout",
    'bt_reset' => "I-reset",
    'bt_restart_services' => "Pangasiwaan ng mga Serbisyo",
    'bt_save' => "I-save",
    'bt_send_by_email' => "Ipadala Sa pamamagitang ng Email",
    'bt_send_file' => "Ipadala ang File",
    'bt_send_mail' => "Ipadala ang Mail",
    'bt_send_passwd' => "Ipadala ang Password",
    'bt_send_text' => "Ipadala ang Text",
    'bt_server' => "Server",
    'bt_server_add' => "Magdagdag ng Server",
    'bt_server_preferences' => "Mga Setting ng Server",
    'bt_servers_list' => "Mga Servers",
    'bt_sessions' => "Mga sesyon",
    'bt_set' => "I-set",
    'bt_set_as_default' => "I-set Bilang Default",
    'bt_setup' => 'I-setup',
    'bt_show_aliases' => "Ipakita ang mga Alyas",
    'bt_show_subdomains' => "Ipakita ang mga Subdomain",
    'bt_show_domainaliases' => "Ipakita ang mga Domain Alias",
    'bt_shutdown' => "I-shut Down",
    'bt_site_apppkgs' => "Application Vault",
    'bt_site_apppool' => "Application Pool",
    'bt_application-pool' => "Mga Web application",
    'bt_site_apps' => "Mga Web application",
    'bt_site_app_add' => "I-install ang Application",
    'bt_site_builder' => "Suporta ng Presence Builder",
    'bt_skeleton' => 'Template ng Virtual na Host',
    'bt_skins' => 'Mga Balat',
    'bt_skin_add' => 'Magdagdag ng Balat',
    'bt_skin_manual' => 'Batayang ng mga Skins ng Custom Plesk', // not used
    'bt_skin_download' => 'Mag-download ng Skin',
    'bt_skin_replace' => 'Pag-update ng Skin',
    'bt_skip' => 'Laktawan',
    'bt_spamassassin' => "Spam Filter",
    'bt_spamassassin_train' => "Pagsasanay",
    'bt_spamfilter' => "Spam Filter",
    'bt_start' => "Simula",
    'bt_stop' => "Ihinto",
    'bt_recycle' => "I-recycle",
    'bt_statistics' => "Mga estatistika",
    'bt_subdomain_new' => "Magdagdag ng Subdomain",
    'bt_subdomains' => "Mga subdomain",
    'bt_submit' => "Ipasa",
    'bt_summary_report' => "Buod ng Ulat",
    'bt_support' => "Suporta",
    'bt_switch' => "Ilipat",
    'bt_system_time' => "Oras ng System",
    'bt_task_new' => "Magdagdag ng Gawain",
    'bt_dom_tmpl_add' => 'Magdagdag ng Template ng Domain',
    'bt_cl_tmpl_add' => 'Magdagdag ng Customer Template',
    'bt_cron_backup' => 'Mga Setting sa Naitakdang Pag-backup',
    'bt_test' => "Pagsubok sa Koneksyon",
    'bt_text' => "Teksto",
    'bt_touch' => "Baguhin ang Timestamp",
    'bt_traffic' => "Trapiko",
    'bt_traffic_history' => "Kasaysayan ng Trapiko",
    'bt_update' => "Pag-Update",
    'bt_upload' => "Pag-upload",
    'bt_upload_from_ftp' => "Pag-upload ng FTP",
    'bt_virtualdirs' => 'Direktoryo ng Virtual',
    'bt_virtualdir_new' => 'Magdagdag ng Virtual Directory',
    'bt_virtualdir_add' => 'Magdagdag ng Virtual Directory',
    'bt_web_app_new' => "I-install ng Java application",
    'bt_web_stats' => "Mga Istatistika sa Web",
    'bt_web_stats_ssl' => "SSL/TLS ng Mga Istatistika sa Web",
    'bt_web_user_add' => "Magdagdag ng Web User",
    'bt_web_users' => "Mga web user",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Tignan ang buong listahan ng mga pagbabago",
    'cert_add__unable_set_ca_cert' => "Hindi ma-set ang sertipiko ng CA: %1",
    'cert_add__unable_set_cert' => "Hindi ma-set ang sertipiko: %1",
    'cert_add__unable_set_private_key' => "Hindi ma-set ang private key: %1",
    'certificates_list__certificate_used_as_default' => "Ginamit ang isa sa mga certificate na ide-delete mo bilang Default na Certificate.",
    'certificates_list__certificates_assigned_on_ip' => "Isa o ilang mga sertipiko ang nakatakda sa mga IP address/domain.",
    'ch_pass__admin_pass' => "Pagpalit ng password ng administrador",
    'ch_pass__old_pass' => "Lumang password",
    'ch_pass__pass_confirm' => "Kumpirmahin",
    'ch_pass__unable_change_admin_pass' => "Hindi mapalitan ang password ng administrador: %1",
    'check_mail_cycle__aliases' => "Ang mail cycling ay natuklasan, ang address \"%1\" ay ang napapaloob sa mga alyas ng mail account na ito.",
    'check_mail_cycle__autoresponders' => "Ang Mail cycling ay nakita, ang address \"%1\" ay naglalaman ng mga auto-reply ng mail account na ito.",
    'check_mail_cycle__mail_groups' => "Ang mail cycling ay natuklasan, ang address \"%1\" ay ang napapaloob sa mga mail group ng mail account na ito.",
    'check_mail_cycle__mail_name' => "Ang mail cycling ay natuklasan, ang address \"%1\" ay tumutugma sa mail account na ito.",
    'check_mail_cycle__redirect' => "Ang Mail cycling ay nakita, ang address \"%1\" ay kasama sa forwarder ng mail account na ito.",
    'check_mail_dup__redirect' => "Ang Duplicate forwarding ay natuklasan, ang address \"%1\" ay napasama sa forwarding address ng mail account na ito.",
    'check_mail_dup__mail_groups' => "Ang Duplicate forwarding ay natuklasan, ang address \"%1\" ay ang nilalaman ng mga mail group ng mail account na ito.",
    'check_maillist_cycle__admin' => "Ang mail cycling ay natuklasan, ang email ng administrador \"%1\" ay tumutugma sa address ng mailing list.",
    'check_maillist_cycle__member' => "Ang mail cycling ay natuklasan, ang address \"%1\" ay tumutugma sa address ng mailing list.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1 ng mga detalye ng account",
    'cl_limits__cl' => "Limitasyon ng %1 ng kustomer",
    'cl_logo__setup_logo_pref' => "Mag-set ng katangian ng logo para sa kustomer %1",
    'cl_new__enter_new_cl_data' => "Ilagay ang impormasyon sa bagong kustomer",
    'cl_new__unable_to_sent_notification' => 'Ang account ng user ay nalikha, subalit, ang pagpapadala ng abiso sa kustomer ay nabigo: %1',
    'cl_perm__all_ip' => "Lahat ng magagamit na IPs",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Lahat ng batay sa IP na mga hosting account para sa kustomer ay mai-transfer sa Batay-sa-Pangalan.",
    'cl_perm__allow_client_create_domain' => "Ang hanay na sinusubukan mong piliin ay akma lamang sa mga kustomer na pinahihintulutang lumikha ng mga domain.",
    'cl_perm__allow_create_nb_w_ip' => "Ang kustomer ay maaring lumikha ng batay-sa-pangalan ng hosting gamit ang %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Pahintulutan ang paggawa ng batay sa IP na hosting",
    'cl_perm__available_ips' => "Magagamit na IPs",
    'cl_perm__change_limits' => "Pag-adjust ng limitasyon",
    'cl_perm__cl_disk_space' => "Kabuuang disk space na magagamit",
    'cl_perm__cl_expiration' => "Tagal ng bisa ng account ng kustomer",
    'cl_perm__cl_max_box' => "Mga mailbox",
    'cl_perm__cl_max_db' => "Mga database",
    'cl_perm__cl_max_dom' => "Mga domain",
    'cl_perm__cl_max_maillists' => "Listahan ng mailing",
    'cl_perm__cl_max_subdom' => "Mga subdomain",
    'cl_perm__cl_max_traffic' => "Kabuuang dami ng magagamit na trapiko",
    'cl_perm__cl_max_wu' => "Mga user ng Web",
    'cl_perm__cl_mbox_quota' => "Ang limitasyon ng laki ng mailbox para sa account ng user na ito",
    'cl_perm__current_maximum_exp_date' => "Ang kasalukuyang pinakamataas na marka ng tagal ng bisa ng domain ay %1; hinihingi %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Ang kasalukuyang naipaliwanag na limitasyon sa dami ng disk space na inilaan para sa mga housing mailbox sa ilalim na account ng user na ito ay %1; hiningi %2",
    'cl_perm__current_total_requested' => "Ang kasalukuyang kabuuang marka ng limitasyon ng domain para sa %1 ay %2; hinihingi %3.",
    'cl_perm__current_total_requested_dom' => "Kasalukuyang bilang ng %1 na kabilang sa kustomer na ito %2; hinihingi %3.",
    'cl_perm__disk_space' => "pinakamataas na marka ng disk space",
    'cl_perm__dashboard_stdgui' => 'Interface ng user',
    'cl_perm__dashboard' => 'View ng Home page',
    'cl_perm__stdgui' => 'Pamantayang view',
    'cl_perm__manage_dashboard' => 'Pangasiwaan ng Home page',
    'cl_perm__dashboard_and_stdgui' => 'Ang Home page view at standard view ay pinahihintulutan',
    'cl_perm__dashboard_only' => 'Tanging Home page view ang pinahihintulutan',
    'cl_perm__stdgui_only' => 'Tanging standard view ang pinahihintulutan',
    'cl_perm__edit_cl' => "Pahintulot ng %1 ng kustomer",
    'cl_perm__exp_date_exceeded' => "Ang tagal ng bisa na sinusubukan mong itakda ay sumobra sa natukoy na limitasyon sa loob ng mga indibidwal na mga domain na kaugnay sa kustomer na ito.",
    'cl_perm__invalid_value' => "Hindi wastong marka, tanging digit lamang ang pinahihintulutan.",
    'cl_perm__limit_disk_space' => "%1 Limitahan ang kabuuang dami ng disk space",
    'cl_perm__limit_expiration' => "%1 Limitahan ang tagal ng bisa para sa account ng kustomer",
    'cl_perm__limit_max_box' => "%1 Limitahan ang pinakamataas na bilang ng mga mailbox",
    'cl_perm__limit_max_db' => "%1 Limitahan ang pinakamataas na bilang ng mga database",
    'cl_perm__limit_max_dom' => "%1 Limitahan ang pinakamataas na bilang ng mga domain",
    'cl_perm__limit_max_maillists' => "%1 Limitahan ang pinakamataas na bilang ng mga mailing list",
    'cl_perm__limit_max_subdom' => "%1 Limitahan ang pinakamataas na bilang ng mga subdomain",
    'cl_perm__limit_max_traffic' => "%1 Limitahan ang kabuuang dami ng trapiko",
    'cl_perm__limit_max_wu' => "%1 Limitahan ang pinakamataas na bilang ng mga web user",
    'cl_perm__limit_mbox_quota' => "%1 itakda ang mailbox quota",
    'cl_perm__limits_exceeded' => "Isa o iilan na mga limitasyon na sinusubukan mong itakda ay sumobra sa limitasyon ng tinukoy sa loob ng mga indibidwal na mga domain na kabilang sa kustomer na ito.\nAng kabuuang limitasyon para sa kustomer ay dapat mas madami o sakto sa kabuuang dami ng limitasyon ng domain na tinukoy para sa account ng kustomer na ito.",
    'cl_perm__mailbox_quota_exceeded' => "Ang limitasyon ng dami ng disk space na ipinamahagi para mga mailbox na sinusubukan mong itakda ay sobra sa limitasyon na tinukoy sa loob ng mga indibidwal na mga domain na kaugnay sa kustomer na ito.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Ang limit ng dami ng disk space na ipinamahagi para mga mailbox na sinusubukan mong itakda ay sobra sa limitasyon na itinalaga sa server level.",
    'cl_perm__make_dumps' => "Gawan ng back up at ibalik ang datos",

    'cl_perm__max_box' => "pinakamataas na bilang ng mga mailbox",
    'cl_perm__max_db' => "pinakamataas na bilang ng mga database",
    'cl_perm__max_dom' => "mga domain",
    'cl_perm__max_maillists' => "pinakamataas na bilang ng mga mailing list",
    'cl_perm__max_subdom' => "mga subdomain",
    'cl_perm__max_traffic' => "pinakamataas na dami ng trapiko",
    'cl_perm__max_wu' => "pinakamataas na bilang ng mga web user",
    'cl_perm__max_dom_aliases' => "mga alyas ng domain",
    'cl_perm__mbox_quota' => "quota ng mailbox",
    'cl_perm__not_allow_create_nb_hst' => "Ang kustomer ay hindi maaring lumikha ng batay-sa-pangalan ng hosting.",
    'cl_perm__this_ip_used_vrt_hst' => "Ang IP address na ito ay ginamit ng virtual na hosting.\nUpang mabura ang IP address na ito, alisin ang serbisyo ng hosting o palitan ang uri nito ng batay-sa-pangalan.",
    'cl_perm__unable_off_ipb_creating' => "Ang kustomer ang mayroong naka-set up na serbisyo na batay sa IP na hosting. Upang ihinto ang paggana ng katangian na ito para sa kustomer, burahin ang \"Paglikha ng domain\" check box o alisin ang lahat ng mga account na batay sa IP na hosting.",
    'cl_perm__unable_off_nb_creating' => "Ang kustomer ang mayroong naka-set up na serbisyo na batay-sa-Pangalan na hosting. Upang ihinto ang paggana ng katangian na ito para sa kustomer, burahin ang \"Paglikha ng domain\" check box o alisin ang lahat ng mga account na batay-sa-pangalan na hosting.",
    'cl_perm__unable_set_domain_limit' => "Hindi malagyan ng limitasyon ang pinakamataas na bilang ng mga domain: ang kustomer ay mayroong %1 mga domain",
    'cl_perm__unable_update_client_limitations' => "Hindi mabago(modify) ang limitasyon ng account ng kustomer: %1",
    'cl_pref__edit_cl' => "Mga pag-nais ng kustomer na %1",
    'class_anonftp__create_ftp_domain' => "Walang virtual na FTP domain para sa dom_id, subukan muna itong likhain.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Ang disk space limit na sinusubukan mong itakda na (%1) ay hindi dapat lumagpas sa kabuuang limitasyon ng disk space na tinukoy sa domain level (%2).",
    'class_anonftp__invalid_input_only_digits' => "Natukoy na hindi wastong marka, tanging digit lamang ang pinahihintulutan.",
    'class_anonftp__unable_change_ownerships' => "Hindi mapalitan ang pagmamay-ari o ang pahintulot para sa quota file: %1",
    'class_anonftp__unable_copy_quota_file' => "Hindi makopya ng quota file: %1",
    'class_anonftp__unable_get_disk_usage' => "Hindi maibalik ang impormasyon ng paggamit ng disk sa parating na direktoryo: %1",
    'class_anonftp__unable_parse_quota_file' => "Hindi ma-parse ang quota file.",
    'class_anonftp__unable_read_quota_file' => "Hindi mabasa ang quota file: %1",
    'class_anonftp__unable_update_quota' => "Hindi magawa ang pag-update ng quota: ang mga file sa parating na direktoryo ay gumagamit ng %1 KBs ng disk space, kung saan sumobra sa bagong marka ng quota.",
    'class_anonftp__unable_write_temp_file' => "Hindi maisulat ang pansamantalang file: %1",
    'class_bsdomain__warn_max_date__' => "Ang petsa ng pag-expire ay na-set sa %1",
    'class_client__client_creation_notification' => "Abiso sa paglikha ng kustomer.",
    'class_client__client_with_contact_name_already_exists' => "Ang kustomer na mayroong pangalan %1 ay umiiral.",
    'class_client__disk_space' => "Disk space",
    'class_client__invalid_max_dom' => "Hindi wastong numero ng mga marka ng domain, tanging digits ang pinahihintulutan.",
    'class_client__limit_exceed' => "Ang hinihingi na dami ng %1 ay hindi maaring ilaan dahil ito ay maaring sumobra sa mga paglalaan para sa account %2 ng kustomer (%3). Kung nais mong ilaan ang mas maraming mga resource, pumunta sa Customers > customer name > Limits at baguhin ang mga paglalaan kung kailangan. Matapos ay bumalik sa iskrin na ito at muling subukan na ayusin ang mga allotment.",
    'class_client__limit_exceed_unlimited' => "Kung nais mong ilaan ang walang hanggang dami ng mga resource (%1), kailangan mo munang pumunta sa Customers > customer name > Limits, at piliin ang Unlimited check box na tumutugma sa kailangan na uri ng resource. Matapos ay bumalik sa iskrin na ito at muling subukan na ayusin ang mga allotment.",
    'class_client__max_box' => "Mga mailbox",
    'class_client__max_db' => "Mga database",
    'class_client__max_maillists' => "Listahan ng mailing",
    'class_client__max_subdom' => "Mga subdomain",
    'class_client__max_traffic' => "Pinakamataas na trapiko",
    'class_client__max_wu' => "Mga user ng Web",
    'class_client__max_dom_aliases' => "Mga alyas ng domain",
    'class_client__mbox_quota' => "Quota ng mailbox",
    'class_client__unable_define_cl_status' => "Hindi matukoy ang estado ng account ng kustomer: %1",
    'class_client__unable_define_inactive_dom' => "Hindi matukoy ang hindi-aktibong mga domain %1.",
    'class_client__unable_del_ip' => "Hindi maalis ang IPs: %1",
    'class_db__db_name_not_set' => "Ang pangalan ng database ay hindi natukoy.",
    'class_db__db_not_exist_for_curr_dom' => "Ang database ay hindi umiiral para sa domain na ito.",
    'class_db__invalid_db_or_dom_name' => "Ang domain o database ID ay hindi wasto o ang pangalan ng database ay hindi natukoy.",
    'class_db__invalid_pass' => "Ang password ay hindi wasto.",
    'class_db__mailgrp_member_exist' => "Ang miyembro ng mail group ay umiiral.",
    'class_db__access_hosts_notsupport' => 'Ang pag-access ng hosting setting ay hindi suportado para sa uri ng database na ito',
    'class_db__unable_add' => 'Hindi magawa ang pagdagdag sa pag-access sa host record: %1',
    'class_db__unable_del' => 'Hindi magawa ang pagbura sa pag-access sa host record: %1',
    'class_db__inc_user_not_exist' => 'Ang database user "%1" ay hindi umiiral',
    'class_db__inc_access_record_exist' => 'Ang pag-access ng tala na ito ay umiiral',
    'class_db__inc_access_record_not_exist' => 'Ang binigay na tala ng pag-access ay hindi umiral',
    'class_db__inc_unable_del_last_record' => 'Hindi mabura ang huling tala ng pag-access ng host',
    'class_domtmpleditform__dns_master' => "Pangunahin",
    'class_domtmpleditform__dns_slave' => "Pangalawa",
    'class_domtmpleditform__dns_type' => "Uri ng domain DNS zone",
    'cmd_dns__a_dns_record_already_exist' => "Tala na ito ay sumasalungat sa tala na A para sa zone.",
    'cmd_dns__domain_last_ns' => 'Hindi ma-delete ang huling NS DNS record para sa domain.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Hindi wasto ang pangalan ng canonical domain.",
    'cmd_dns__cname_dns_record_already_exist' => "Tala na ito ay sumasalungat sa mga tala ng CNAME para sa zone.",
    'cmd_dns__cname_in_rr_combination' => 'Maling kombinasyon ng mga DNS record ay makikita sa DNS zone',
    'cmd_dns__cname_coexist_with_data' => 'Ang tala ng CNAME DNS zone ay hindi maaring sumabay sa pag-iral kasama ng ibang DNS record sa parehong zone.',
    'cmd_dns__dns_record_type_is_invalid' => "Ang uri ng DNS record ay hindi wasto.",
    'cmd_dns__ext_host_is_not_resolved' => "Ang canonical name na %1 ay hindi nagre-resolve sa isang A o AAAA record.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Hindi maidagdag ang %1 (na) talaan sa zone %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Ang pangalan ng mail exchanger ay hindi wasto.",
    'cmd_dns__mx_priority_is_invalid' => "Ang priyoridad ng MX ay hindi wasto.",
    'cmd_dns__name_server_is_invalid' => "Ang pangalan ng server ay hindi wasto.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Ang marka ng network mask ay dapat 24, 16 o 8.",
    'cmd_dns__this_dns_record_already_exists' => "Ang nasabing DNS record ay umiiral.",
    'cmd_dns__unable_add_record' => "Hindi magawa ang pagdagdag ng '%1' record: %2",
    'cmd_dns__unable_add_a_record' => "Hindi makakadagdag ng A na tala: %1",
    'cmd_dns__unable_add_cname_record' => "Hindi makakadagdag ng CNAME na tala: %1",
    'cmd_dns__unable_add_dns_record' => "Hindi makakadagdag ng DNS na tala: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Hindi makakadagdag ng EXT_NS na tala: %1",
    'cmd_dns__unable_add_ns_record' => "Hindi makakadagdag ng NS na tala: %1",
    'cmd_dns__unable_add_ptr_record' => "Hindi makakadagdag ng PTR na tala: %1",
    'cmd_dns__unable_add_txt_record' => "Hindi magawa ang pagdagdag ng TXT record: %1",
    'cmd_dns__unable_create_dns_zone' => "Hindi makalikha ng DNS zone %1",
    'cmd_dns__unable_define_dns_record' => "Hindi matukoy ang DNS record %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Hindi maibalik ang default na estado ng DNS zone: %1",
    'cmd_dns__unable_insert_a_record' => "Hindi makapag lagay ng A na tala: %1",
    'cmd_dns__unable_insert_mx_record' => "Hindi makapag lagay ng MX na tala: %1",
    'cmd_dns__unable_insert_ns_record' => "Hindi makapag lagay ng NS na tala: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Hindi maitakda ang estado ng DNS zone: %1",
    'cmd_domains__dom_already_exists' => "Ang domain %1 ay umiiral.",
    'cmd_domains__dns_record_already_exists' => "Hindi makalikha ng domain %1 dahil ang DNS record na nagtuturo sa host %1 ay umiiral.",
    'cmd_domains__dom_already_exists1' => "Mayroong %2 na subdomain sa domain na ito. Ang domain %1 ay umiiral.",
    'cmd_domains__dom_already_exists2' => "ang subdomain %1 ay umiiral.",
    'cmd_domains__dalias_already_exists' => "Alyas ay umiiral.",
    'cmd_domains__domain_alias_already_exists' => 'Mayroong nang umiiral domain alias na may nasabing pangalan.',
    'cmd_domains__unable_del_mail_for_dom' => "Hindi mabura ang serbisyo ng mail para sa domain: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Hindi mabura ang hindi kilalang FTP account para sa domain: %1",
    'cmd_domains__unable_update_dom_param' => "Hindi magawa ang pag-update ng mga parameter ng domain: %1.",
    'cmd_domains__unable_rename_client_exist' => "ang username ng administrador ng domain ay mayroong gumagamit.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Ang uri ng hosting ay hindi pisikal.",
    'cmd_hosting__unable_create_user' => "Hindi makalikha ng user %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Hindi matukoy ang IP adress para sa batay-sa-pangalan na virtual na host: %1",
    'cmd_hosting__unable_del_old_hst' => "Hindi mabura ang nakaraang na-set up na hosting: %1",
    'cmd_hosting__unable_del_protected_directory' => "Hindi mabura ang protektadong direktoryo: %1.",
    'cmd_hosting__unable_del_web_user' => "Hindi mabura ang web user: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Hindi makalikha o maka pag-update ng Virtual na Host: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Hindi maitakda up ang frame forwarding hosting.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Hindi magawang muli ang konpigurasyon ng file: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Hindi ma-set up ang SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Hindi maalis ang proteksyon mula sa directory na May SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Hindi magawa ang pag-update sa destinasyon ng URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Hindi magawa ang pag-update sa DNS zone para sa domain: ang pagpapatupad ng utility ay nabigo.",
    'cmd_hosting__unable_update_ftp_passwd' => "Hindi magawa ang pag-update ng password ng FTP %1.",
    'cmd_hosting__unable_update_user' => "Hindi magawa ang pag-update ng user %2: %1",
    'cmd_hosting__unknown_hst_type' => "Hindi kilalang uri ng hosting.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Ikaw ay walang pahintulot para putulin ang serbisyo ng hosting.",
    'cmd_mail__autoresponder__not_configured' => "Ang auto-reply para sa mail account na ito ay hindi nakonpigura",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Ang address %1 ay nagamit para sa mail forwarding.",
    'cmd_mail__alias_already_exists' => "ang alyas ay umiiral.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Ang ID ng auto-reply at ID ng mail account ay hindi magkatugma.",
    'cmd_mail__autoresp_id_is_undefined' => "Ang Auto-Reply ID ay hindi natukoy.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Ang mail alias ng nasabing pangalan ay umiiral para sa mail account %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Ang mail account %1 ay naka-suskribe sa mailing list na ito.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Ang mail account %1 ay umiiral sa domain na ito.",
    'cmd_mail__mail_name_not_exist' => "Ang mail account ay hindi umiiral.",
    'cmd_mail__mail_name_passwd_part' => "Ang password ay hindi dapat naglalaman ng pangalan ng mail account bilang bahagi nito.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Ang mailing list %1 ay umiiral sa domain na ito.",
    'cmd_mail__mailname_already_exist_in_mg' => "Ang mail account %1 ay umiiral sa mail group.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Ang mail account %1 ay umiiral sa domain na ito.",
    'cmd_mail__mailname_already_exists' => "Ang mail account list ay umiiral.",
    'cmd_mail__mailname_is_invalid' => "Ang pangalan %1 ng mail account ay hindi wasto.",
    'cmd_mail__mailname_unable_update' => "Hindi magawa ang pag-update ng mga katangian ng mail account:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Pinakamataas na bilang ng auto-replies ay naabot para sa domain na ito.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Pinakamataas na bilang ng mga mail group ay naabot para sa domain na ito.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Pinakamataas na bilang ng mga forwarder ay naabot para sa domain na ito.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Pinakamataas na bilang ng mailbox ay naabot para sa domain na ito.",
    'cmd_mail__no_members_specified' => "walang miyembrong natukoy.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Ang password ay masyadong payak, pumili ng iba.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Ang email adress na ito ay ginagamit.",
    'cmd_mail__unable_define_autoresp_id' => "Hindi matukoy ang auto-reply ID %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Nabigo na baguhin ang mga setting ng serbisyo ng mail para sa domain %1",
    'cmd_mail__unable_del_mail_for_dom' => "Hindi maalis ang serbisyo ng mail mula sa domain %1.",
    'cmd_mail__unable_del_mail_redirection' => "Hindi maalis ang serbisyo ng mail forwarding %1.",
    'cmd_mail__unable_remove_autoresp' => "Hindi maalis ang auto-replies: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Hindi maalis ang mga myembro ng mail group: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Nabigo na i-switch off ang mail group: %1",
    'cmd_mail__unable_update_mail_redirect' => "Hindi konpigura muli ang serbisyo ng mail forwarding %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Ang na-upload na sukat ng file ay masyadong malaki.",
    'cmd_mail__additionally' => "Idinagdag:",
    'cmd_pd__invalid_login' => "Maling username.",
    'cmd_pd__this_user_already_exist' => "Ang nasabing user ay umiiral.",
    'cmd_pd__unable_define_hst_type' => "Hindi matukoy ang uri ng hosting.",
    'cmd_pd__unable_upd_pd_usr' => "Hindi magawa ang pag-update ng mga katangian ng user ng direktoryo: %1.",
    'cmd_pd__user_is_undefined' => "Ang user ay hindi natukoy.",
    'cmd_server__no_enough_free_disk_space' => "Hindi sapat ang disk space.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "ang lumang password ay hindi tama. Paki, subukan muli.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "ang pinakamataas na limitasyon ng mga web user ay naabot para sa domain na ito.",
    'cmd_web_usr__unable_create_user' => "hindi makalikha ng user ng system: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "hindi matukoy ang pinakamataas na limitasyon ng web user: %1",
    'cmd_web_usr__user_already_exists' => "ang user ay umiiral.",
    'cmd_web_usr__web_user_name_is_invalid' => "ang pangalan %1 ng user ay hindi wasto.",
    'cmd_web_usr__web_user_not_exist' => "ang web user ay hindi umiiral.",
    'common_func__exec_bad_argument' => "ang argumento na exec ay hindi dapat naglalaman ng nag-iisang simbolo ng quote.",
    '__eol' => 'Mga break ng linya',
    'eol__binary_file' => 'Hindi mabago ang line break style sa binary file.',
    'cp_access_admin_deny' => "Ang pag-access para sa administrador mula sa address '%1' ay hinigpitan sa pagkakasundo sa kasalukuyang na-aplay na patakaran sa restriksiyon sa pag-access ng IP.",
    'create_domain_warn__' => "Ang mga sumusunod na eksepsiyon ay ginawa habang ginagawa ang domain:",
    'create_domain__client_select' => 'Piliin ang kustomer na gagawan ng domain',

    'dashboard__nav_button_name' => "Home",
    'dalias__list_title' => 'Mga domain alias ng domain %1',
    'dalias__list_legend' => 'Mga alyas ng domain',
    'dalias__list_header' => 'Mga alyas ng domain',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Pangalan ng domain alias',
    'dalias__list_ascii_name' => 'Sa pormat ng ASCII',
    'dalias__remove_title' => 'Ang sumusunod na mga domain alias ng domain %1 ay maaalis:',
    'dalias__select_domain_aliases_to_remove' => 'Piliin ang mga domain aliases na aalisin.',
    'dalias__mail_turn_on_failed' => 'Hindi mabuksan ang serbisyo ng mail: %1',
    'dalias__web_turn_on_failed' => 'Hindi mabuksan ang serbisyo ng web: %1',
    'db_usr_edit__db_usr_name_old' => "Lumang pangalan ng user ng database",
    'database_server_edit_form__cannot_infer_type' => 'Hindi mahulaan ang paraan ng pagkonekta mula sa ibinigay na data. Tukuyin ang "127.0.0.1" bilang database server host name para kumonekta sa pamamagitan ng TCP/IP gamit ang ibinigay na port, o hayaang walang laman ang field ng port para gamitin ang Unix socket na "%1".',
    'database_server_edit_form__duplicate' => 'Ang database server na may ganitong kombinasyon ng host address at numero ng port ay rehistrado.',
    'database_server_edit_form__host_is_invalid' => 'Hindi valid ang tinukoy na host name.',
    'database_server_edit_form__port_is_invalid' => 'Hindi valid ang tinukoy na port number.',
    'database_server_error__consult_admin' => 'Kontakin ang administrador ng server.',
    'database_server_error__last__connection_failed' => 'Ang huling pagsubok nito sa pag-kontrol ng database server na ito ay nabigo dahil sa mga problema sa network.',
    'database_server_error__last__permission_denied' => 'Ang huling pagsubok nito sa pag-kontrol nitong database server ay nabigo dahil ang ibinigay na account ay walang taglay na pribilehiyo ng administratibo.',
    'database_server_error__last__credentials_not_set' => "Ang huling pagsubok nito sa pag-connect nitong server ay nabigo dahil walang wastong username ng administrador at password na tinukoy.",
    'database_server_error__last__other_error' => 'Ang huling pagsubok nito sa pag-kontrol nitong database server ay nabigo.',
    'database_server_error__real__connection_failed' => 'Ang koneksyon sa database server ay nabigo dahil sa mga problema sa network:',
    'database_server_error__real__permission_denied' => 'Ang koneksyon sa database server ay nabigo dahil ang na-suplay na account ay walang taglay na pribilehiyong administratibo:',
    'database_server_error__real__duplicate_object' => 'Ang koneksyon sa database server ay nabigo dahil sa salungat na pangalan:',
    'database_server_error__real__unacceptable_name' => 'Ang koneksyon sa database server ay nabigo dahil sa hindi wastong pangalan ng bagay:',
    'database_server_error__real__unacceptable_password' => 'Ang koneksyon sa database server ay nabigo dahil sa hindi tinatanggap na password:',
    'database_server_error__real__credentials_not_set' => "Ang Plesk ay hindi maka-konekta sa database server dahil walang natukoy na wastong username at password ng administrador.",
    'database_server_error__real__other_error' => 'Nabigo ang koneksyon sa database server ay:',
    'database_server_error__test__connection_failed' => 'Ang pagsusuri sa koneksyon sa database server ay nabigo dahil sa mga problema sa network:',
    'database_server_error__test__permission_denied' => 'Ang pagsusuri sa koneksyon sa database server ay nabigo dahil ang na-suplay na account ay walang taglay na pribilehiyong administratibo:',
    'database_server_error__test__duplicate_object' => 'Ang pagsusuri sa koneksyon sa database server ay nabigo dahil sa salungat na pangalan:',
    'database_server_error__test__unacceptable_name' => 'Ang pagsusuri sa koneksyon sa database server ay nabigo dahil sa hindi wastong pangalan ng bagay:',
    'database_server_error__test__unacceptable_password' => 'Ang pagsusuri sa koneksyon sa database server ay nabigo dahil sa hindi tinatanggap na password:',
    'database_server_error__test__credentials_not_set' => "Ang pagsusuri nito sa koneksyon nitong server ay nabigo dahil walang wastong username ng administrador at password na natukoy.",
    'database_server_error__test__other_error' => 'Ang pagsubok ng koneksyon sa database server ay nabigo:',

    'db__create_new_db' => "Magdagdag ng database",
    'db__db_add' => "Magdagdag ng Database",
    'db__db_for_dom' => "Ang mga database ng Website ay %1",
    'db__db_id_undefined' => "Ang database ID ay hindi natukoy.",
    'db__db_name' => "Pangalan ng database",
    'db__db_not_exist' => "Ang database ay hindi umiiral.",
    'db__db_type' => "Uri",
    'db__db_server' => "Server ng database",
    'db_server_not_exist' => "Ang database server ay hindi umiiral.",
    'db__db_user_not_exist' => "Ang user ng database ay hindi umiiral.",
    'db__domain_not_exist' => "Ang domain ay hindi umiiral.",
    'db__enter_db_name' => "Maglagay ng bagong pangalan ng database.",
    'db__invalid_db_id' => "Ang identifier ng database ay hindi wasto.",
    'db__invalid_db_name' => "Ang pangalan ng database ay hindi wasto. Ang pangalan ng database ay dapat naglalaman lamang ng simbolo ng alpabeto ng Latin, digit, underscore o patlang(dash). Hindi ito maaring mas humaba sa 63 na mga simbolo.",
    'db__max_db_reached_for_dom' => "Ang limitasyon sa bilang ng mga database ay naabot para sa domain na ito.",
    'db__max_mssql_db_reached_for_dom' => "Ang limitasyon sa bilang ng mga database ng Microsoft SQL Server ay naabot para sa domain na ito",
    'db__postgres_not_connect_for_admin' => "Hindi maka-connect sa PostgreSQL. Buhayin ang suporta ng PostgreSQL sa pahina ng administrasyon ng server.",
    'db__postgres_not_connect_for_client' => "Hindi maka-connect sa PostgreSQL. Kumunsulta sa iyong administrador ng system para sa tulong.",
    'db__remove_db_on_domain' => "Ang mga sumusunod na database sa ilalim ng website %2 na pagmamay-ari ng kustomer %1 ay maaalis:",
    'db__remove_db_on_domain_of_cl' => "Ang mga sumusunod na mga database para sa domain %2 na pagmamay-ari ng kustomer %1 ay maaalis:",
    'db__remove_db_linked_resource' => 'Ang database na ito ay ginagamit ng web application. Maari lamang itong tanggalin pagkatapos alisin sa pagkaka-install ang web application na ito.',
    'db__remove_db_users' => "Ang mga sumusunod na mga user ng database %3 sa ilalim ng website %2 na pagmamay-ari ng kustomer %1 ay maaalis:",
    'db__remove_db_users_of_cl' => "Ang mga sumusunod na mga user ng database %3 sa ilalim ng website %2 na pagmamay-ari ng kustomer %1 ay maaalis:",
    'db__select_db_for_remove' => "Piliin ang mga database na aalisin.",
    'db__select_db_users_for_remove' => "Piliin ang mga user ng database na aalisin.",
    'db__unable_create_db_user' => "Hindi makalikha ng database user: %1",
    'db__unable_define_db_name' => "Hindi matukoy ang pangalan ng database: %1",
    'db__unable_define_db_user' => "Hindi matukoy ang database user: %1",
    'db__unable_define_db_users' => "Hindi matukoy ang database user: %1",
    'db__unable_select_dom_name' => "Hindi makapili ng pangalan ng domain: %1",
    'db_edit__db_for_dom' => "Mga user para sa database %1 sa domain %2",
    'db_edit__invalid_db_name' => "Ang pangalan ng database ay hindi wasto.",
    'db_edit__no_users' => "Walang user na mayroong kredensyal para sa database na ito.",
    'db_edit__unable_define_db_usrs' => "Hindi matukoy ang mga database user: %1",
    'db_edit__unable_select_db_usr' => "Hindi mapili ang database user.",
    'db_edit__db_user_password_for_' => "I-type ang password upang maka-log in bilang user ng database %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Magdagdag ng database user",
    'db_usr_edit__db_usr_name' => "Pangalan ng user ng database",
    'db_usr_edit__edit_db_usr' => "Mag set-up ng mga kredensyal para sa account ng user ng database",
    'db_usr_edit__for_db' => "sa %1 database",
    'db_usr_edit__not_create_pass' => "Ang operasyon na ito ay magreresulta sa paglikha ng account ng user ng database ng walang password.\nNais mo bang lumikha ng user ng walang itinatakda na password?",
    'dbuser__only_one_user_can_be_default' => "Tanging isang user ang maaring i-set bilang default.",
    'db_server__cannot_delete_default' => "Ang default na server ng database ay hindi maaring burahin.",
    'db_server__cannot_delete_local' => "Ang lokal na database server ay hindi maaring burahin.",
    'db_server__cannot_delete_used' => 'Hindi mabura ang isang database server habang mayroong mga database o user ng database na naka-host dito.',
    'demo__disabled_in_demo' => "Ang operasyon na ito ay hindi suportado sa bersyon ng demo.",
    'defaultcomponents__title' => "Pagpili ng Default na mga Component",
    'defaultcomponents__select_default' => "Pumili ng default %1 na components", //to check
    'defaultcomponents__not_installed' => "(Hindi naka-install)",
    'defaultcomponents__not_configured' => "(hindi nakonpigura)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Ang ibang kategorya ng mga serbisyo ay naglalaman ng hindi wastong mga pagpili, o walang nagawang pagpili.",
    'defaultcomponents__depends_on' => "(kailangan ng %1)",
    'defaultcomponents__parameters' => "Parameters ng %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS Server",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "FTP Server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Mail Server",
    'component_name__local_mailserver' => "Local Mail Server",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web Scripting",
    'component_name__spamfilter' => "Spam Filter",
    'component_name__stats' => "Mga Estatistika ng Web",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Web Publishing",
    'component_name__webserver' => "Web Server",
    'dns__dns_record_invalid_values' => 'Maling mga value ng DNS record ang tinukoy: %1: %2',
    'dns__dns_record_not_found' => 'Hindi nakita ang DNS record',
    'dns__dns_zone_invalid_values' => 'Maling mga parameter ng DNS zone ay natukoy.',

    'dns__soa_mname_title' => 'Pangunahing Name Server',
    'dns__soa_mname_legend' => 'Name Server',
    'dns__soa_mname_autoselect' => '(Awtomatikong pumili)',

    'dns__dns_zone_off_remove_title' => "Ang mga sumusunod na mga tala ng resource ay maaalis mula sa ng zone %1:",
    'dns__dns_zone_master_remove_title' => "Pag-alis ng mga Rekord ng Resource mula sa DNS Zone %1",
    'dns__dns_zone_slave_remove_title' => "Aalisin ang mga sumusunod na record ng pangunahing name server para sa %1:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Ilagay ang record string',
    'dns_add__is_spf_syntax' => 'Rekord ng SPF',
    'dns_add__spf_value_is_invalid' => "Hindi tama ang marka ng tala ng SPF, ito ay dapat na nagsisimula sa 'v=spf'",
    'dns__dns_zone_status' => "Estado ng DNS zone.",
    'dns__invalid_ip_address' => "Invalid o walang laman ang IP address ng bagong pangunahing DNS server.",
    'dns__ip_address' => "IP Address",
    'dns__master_dns_type' => "ay isang pangunahing DNS server",
    'dns__masters' => "mga pangunahing DNS server",
    'dns__soa_minimum_too_large' => 'Negatibong mga kasagutan ng caching para sa higit sa tatlong oras ay hindi iminungkahi.',
    'dns__select_masters_to_remove' => "Pumili ng pangunahing DNS servers na aalisin.",
    'dns__select_template_record_to_remove' => 'Pumili ng mga DNS record template na aalisin.',
    'dns__nameservers_for_domain' => "Pangalan ng server para sa domain",
    'dns__remove_dns_zone_of_domain__' => "Pagtanggal ng mga DNS record mula sa domain %1",
    'dns__remove_dns_zone_template__' => "Ang mga sumusunod na mga DNS record ay maalis mula sa template:",
    'dns__remove_this_dns_record?' => "Sigurado ka bang nais mong alisin itong napiling DNS record?",
    'dns__restore_default' => "Pagbalik ng DNS zone gamit ang template",
    'dns__restore_default_confirm' => "Sa pag-restore ng DNS zone maaalis ang kasalukuyang konpigurasyon ng DNS zone. Magpatuloy ano pa man?",
    'dns__restore_default_error' => "Error sa pagbalik ng DNs zone:",
    'dns__slave_dns_type' => "ito ay pangalawang DNS server",
    'dns__subdomain_dns_rec_removed' => "Ang tala na A ay naalis mula sa subdomain zone %1.",
    'dns__zone_switched_off_no_ns' => "Ang zone ay pinatay dahil walang NS record %1, na dapat ay makikita sa zone. Upang makapag dagdag ng tala sa zone, i-klik ang Add Record na buton.",
    'dns__cant_switch_on_no_ns' => "Ang zone ay hindi maaring mabuksan dahil walang NS record %1, na dapat ay makikita sa zone. Upang makapag dagdag ng tala sa zone, i-klik ang Add Record na buton.",
    'dns__unable_activate/deactivate_dns' => "Hindi ma-activate/deactivate ang DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Hindi maidagdag ang pangunahing DNS server: duplicate na entry.",
    'dns__unable_add_dns_master_local_ip' => "Hindi maidagdag ang IP address para sa pangunahing DNS server: dapat gawin ang record na ito sa remote server.",
    'dns__unable_define_dns_record' => "Hindi matukoy ang DNS record: %1",
    'dns__unable_get_dns_template_status' => "Hindi maibalik ang estado ng DNS template.",
    'dns__unable_remove_dns_rec' => "Hindi maalis ang DNS record: %1",
    'dns__warnings__' => "Ang resulta ng modipikasyon ng DNS zone:",
    'dns__you_not_have_perm_manage_dns' => "Ikaw ay walang pahintulot para mangasiwa ng DNS zone para dito sa domain.",
    'dns__cant_create_record_with_server_ip' => "Hindi maidagdag ang IP address na ito dahil pareho ito sa IP address nitong Plesk-managed server.",

    'dns__tabs_acl' => "Mga Zone Transfer",
    'dns__acl_add_network_legend' => "Magdagdag ng Network",
    'dns__acl_add_ip_legend' => "Magdagdag ng IP Address",
    'dns__acl_network_not_allowed' => "Ang network address na ito ay hindi pinahintulutan ng DNS sa Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP address/maskara",
    'dns__acl_enter_ip_address' => "IP address",
    'dns__acl_list_network_legend' => "Ang mga network ay pinahintulutan na kumuha ng kopya ng DNS zone",
    'dns__acl_list_ip_legend' => "Ang mga IP address ay pinahintulutan na kumuha ng kopya ng DNS zone",
    'bt_dns_acl_add_network' => "Magdagdag ng Network",
    'bt_dns_acl_add_ip' => "Magdagdag ng IP Address",

    'dns_add__add_rec_for_zone' => "Magdagdag %1 para sa zone %2",
    'dns_add__canonical_dom_name_is_invalid' => "Hindi wasto ang pangalan ng canonical domain.",
    'dns_add__enter_canonical_name' => "Pangalan na canonical",
    'dns_add__enter_dom_name' => "Pangalan ng domain",
    'dns_add__enter_ip_address' => "IP address",
    'dns_add__enter_ip_mask' => "IP address at network mask",
    'dns_add__enter_mail_domain' => "Mail domain",
    'dns_add__enter_mail_exchanger' => "Server ng Mail exchange",
    'dns_add__enter_nameserver' => "Pangalan ng server",
    'dns_add__enter_txt_record' => "Tala ng TXT",
    'dns_add__enter_service_name' => "Pangalan ng serbisyo",
    'dns_add__hint_service_name' => "Halimbawa: SIP (walang salungguhit na simbolo)",
    'dns_add__enter_protocol' => "Protokol",
    'dns_add__hint_protocol_name' => "Halimbawa: TCP (walang salungguhit na simbolo)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priyoridad",
    'dns_add__specify_weight_of_service' => "Kaugnay na bigat para sa mga tala na mayroong kaparehong prayoridad",
    'dns_add__enter_target_host' => "Target na host",
    'dns_add__hint_target_host' => "Halimbawa: example.com",
    'dns_add__enter_target_port' => "Target na port",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Halaga",
    'dns_add-invalid-A_ip' => "Ang IP address ay hindi wasto.",
    'dns_add-invalid-AAAA_ip' => "Ang IP address ay hindi wasto.",
    'dns_add-invalid-PTR_ip_mask' => "Hindi wastong pares ng IP address/netmask.",
    'dns_add-invalid-SRV_service_name' => "Invalid na pangalan ng serbisyo",
    'dns_add-invalid-SRV_protocol_name' => "Invalid na protocol",
    'dns_add-invalid-SRV_target_port' => "Invalid na target na port",

    'dns_add__invalid_ip' => "Ang IP address ay hindi wasto.",
    'dns_add__low' => "mababa",
    'dns_add__mail_dom_name_is_invalid' => "Hindi wasto ang mail domain name.",
    'dns_add__nameserver_is_invalid' => "Ang pangalan ng server ay hindi wasto.",
    'dns_add__record' => "%1 tala",
    'dns_add__select_prefer_for_mail_exchange_server' => "Tukuyin ang priyoridad ng mail exchange server",
    'dns_add__unable_insert_new_dns_rec' => "Hindi makapag lagay ng bagong DNS record: %1",
    'dns_add__very_high' => "napakataas",
    'dom_ctrl__allowed' => "Pinahintulutan",
    'dom_ctrl__db' => "MariaDB/MySQL database",
    'dom_ctrl__mssql_db' => "MS SQL database",
    'dom_ctrl__disk_space' => "Disk space",
    'dom_ctrl__dom_adm' => "Domain %1 ng %2",
    'dom_ctrl__dom_cl' => "Domain %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Ang domain ay mayroong forwarding na nakatakda sa hindi natukoy na forwarding URL",
    'dom_ctrl__domain_has_frame_forwarding' => "Ang domain ay mayroong frame forwarding sa URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Ang domain ay walang nakonpigura sa hosting",
    'dom_ctrl__domain_has_physical_hosting' => "Ang web hosting ang nakonpigura para sa domain sa IP address %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Ang domain ay mayroong pamantayang forwarding sa URL %1",
    'dom_ctrl__maillists' => "Listahan ng mailing",
    'dom_ctrl__mboxes' => "Mga mailbox",
    'dom_ctrl__mg' => "Mga pagpapasa ng mail",
    'dom_ctrl__resource_name' => "Resource",
    'dom_ctrl__resp' => "Mga Auto-reply",
    'dom_ctrl__subdom' => "Mga subdomain",
    'dom_ctrl__dom_aliases' => "Mga alyas ng domain",
    'dom_ctrl__traffic' => "Trapiko",
    'dom_ctrl__unable_activate/deactivate_dom' => "Hindi ma-activate/deactivate ang domain: %1",
    'dom_ctrl__used' => "Ginamit",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Mga user ng Web",
    'dom_pref__bounce_with_phrase' => "Tumalbog sa message",
    'dom_pref__bounce' => "Tumalbog",
    'dom_pref__catch_addr' => "I-forward sa address",
    'dom_pref__reject' => 'Tanggihan',
    'dom_pref__confirm_domain_removing' => "Pakiusap, huwag ipaalam sa mga bisita ng domain ang pagpalit sa domain name. Sigurado ka bang nais mong palitan ang pangalan ng domain?",
    'dom_pref__db_inconsystency' => "salungat na database.",
    'dom_pref__dbs' => "mga database",
    'dom_pref__delete_traffic_stat' => "Panatiliin ang mga estatistika ng web at trapiko",
    'dom_pref__delete_traffic_stat_older' => "Panatiliin ang mga estatistika ng web at trapiko",
    'dom_pref__dom_level_name_conflict' => "Ang username ng administrador ng domain ay nagtatalo sa isang username ng isa sa mga kustomer.",
    'dom_pref__invalid_disk_space_limit' => "Hindi wastong limitasyon ng disk space. Pinakamataas na marka: %1",
    'dom_pref__invalid_expiration_date_limit' => "Hindi wastong tagal ng bisa.",
    'dom_pref__invalid_max_traffic_limit' => "Hindi wastong limitasyon ng trapiko. Pinakamataas na marka: %1",
    'dom_pref__limits_of_dom' => "Mga limit para sa domain %1",
    'dom_pref__mail_grps' => "mga grupo ng mail",
    'dom_pref__mail_nonexistent_user' => "Ano ang gagawin sa ipinadalang mail sa hindi umiiral na mga user",
    'dom_pref__mail_redirs' => "mga mail forwarder",
    'dom_pref__mail_resps' => "mga mail auto-reply",
    'dom_pref__max_limit_is_invalid' => "%1 ay hindi wasto.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Pinakamataas na bilang ng %1 hindi wasto.",
    'dom_pref__new_limit_less_currently_used' => "%1: hiniling - %2, kasalukuyang ginagamit - %3",
    'dom_pref__older_that' => "para sa",
    'dom_pref__postboxes' => "mga mailbox",
    'dom_pref__preferences_of_dom' => "Mga setting para sa domain %1",
    'dom_pref__redirect_to_itself' => "Ang domain ay magkakaroon ng forwarding na nakatakda sa kanyang sarili",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Iyong tinukoy ang oras ng mga estatistika ng pagpapabagal ng trapiko ng domain na mas mababa kaysa sa kabuuang marka na ipinaliwanag para sa server (%1 month(s)). Ang mga estatistika ng panahon ng pagpapabagal ay naitakda sa mga katumbas na default na marka para sa server (%1 month(s)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Hindi makapag dagdag ng www na unlapi sa domain: %1",
    'dom_pref__unable_define_physical_hst_param' => "Hindi matukoy ang mga parameter ng pisikal na hosting: %1",
    'dom_pref__unable_rename_domain' => "Hindi mapalitan ang pangalan ng domain na %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Hindi ma-set ang quota ng mail para sa domain na ito: %1",
    'dom_pref__unable_set_up_web_user_script' => "Hindi makapag setup ng scripting para sa web user: %1",
    'dom_pref__unlimited' => "Walang-limitasyon",
    'dom_pref__web_usrs' => "mga user ng Web",
    'dom_pref__you_already_have_%object' => "Ikaw ay mayroon ng %1",
    'cu_domain__error_unable_update_ftp_users' => 'HIndi na-update ang mga user ng FTP ng domain: %1',
    'dom_cli__warning_ignore_quota' => 'BABALA: Opsyon "-hard_quota" ay hindi pinansin: ang hard disk quota ay hindi suportado',
    'dom_user_client_login_exist' => "Hindi mapahintulutan ang administrador ng domain sa pag-access sa Plesk sa domain %1: ang username na ito ay ginagamit.",
    'domain__unable_to_turn_on_service' => "Nabigong buhayin ang %1 serbisyo.",
    'domains__change_the_status_of_domain?' => "Sigurado ka bang nais mong palitan ang estadong domain %1?",
    'domains__unable_to_change_client_status' => "Hindi mapalitan ang estado ng account ng kustomer: %1",
    'domains__unable_update_apache_settings' => "Hindi magawa ang pag-update ng mga setting ng Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Ikaw ay walang pahintulot para burahin ang mga domain.",
    'domains_list__unable_remove_doms' => "Hindi maalis ang mga domain: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Piliin ang mga domain aliases na aalisin.',
    'domain_aliases_remove__title' => 'Pag-alis ng mga domain alias',
    'domain_aliases__max_aliases_reached_for_dom' => "Ang limitasyon sa bilang ng mga alias ay naabot para sa domain na ito.",
    'domain_edit__edit_title' => 'I-edit ang pangalan ng domain alias',
    'domain_alias_edit__type' => 'Uri ng domain alias',
    'domain_aliases__list_header' => 'Mga alyas ng domain',
    'domain_aliases__name' => 'Pangalan',
    'domain_aliases__type' => 'Uri',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Mga alyas ng domain',
    'domain_aliases__legend' => 'Mga alyas ng domain',
    'domain_alias__domain_exists' => 'Ang domain na may parehong pangalan ay umiiral',
    'domain_alias__subdomain_exists' => 'Ang subdomain na may ganyang pangalan ay umiiral',
    'domain_alias__dns_record_exists' => 'Ang DNS record ng natukoy na pangalan ng domain alias ay umiiral',
    'domain_alias__domain_alias_exists' => "Ang domain alias na may nasabing pangalan ay umiiral",
    'domain_alias__invalid_type_full' => 'Ang mail server ay hindi sumusuporta sa mga domain alias',
    'domain_alias__redirect_exists' => 'Ang muling pag-direkta sa sarili ay nakita.',

    'ds__anonymous_ftp' => "Hindi kilalang FTP",
    'drweb__pagetitle' => 'Mga setting ng antivirus',
    'drweb__drweb' => 'Pag-check ng mail ng antivirus',
    'drweb__drweb_direction' => 'Pag-check ng mail para sa mga virus',
    'drweb__drweb_direction_off' => 'Huwag mag-check para sa viruses',
    'drweb__drweb_direction_any' => 'Parating at palabas na mail',
    'drweb__drweb_direction_from' => 'Palabas na mail lamang',
    'drweb__drweb_direction_to' => 'Parating na mail lamang',
    'drweb__disable_reason_key' => 'Ang antivirus ay hindi suportado ng license key.',
    'drweb__disable_reason_perm' => 'Ikaw ay may pahintulot para mangasiwa ng Antivirus.',
    'drweb__disable_reason_install' => 'Hindi naka-installed ang antivirus.',
    'drweb__filters' => 'Mga filter ng antivirus',
    'ds__dns' => "DNS Zone",
    'ds__mail' => "Mail",
    'dumps_list__deletion_page_title' => "Ang sumusunod na mga backup file ng domain %1 ay maaalis:",
    'dumps_list__dumpfile_is_invalid' => "Ang file %1 ay hindi wasto domain backup file.",
    'dumps_list__page_title' => "Imbakan ng mga na-backup na mga file",
    'dumps_upload__page_title' => "Ina-upload ang mga Backup na mga File sa Imbakan",
    'dumps_list__repository_is_not_exist' => "Walang umiiral na imbkan ng mga na-backup na mga file.",
    'dumps_list__unable_to_remove' => "Hindi maalis ang backup file: %1",
    'dumps_list__dumpfile_can_conflict' => "Ang pangalan ng file na iyong tinukoy ay nagkaka-problema sa file %1, tumukoy ng ibang pangalan ng file.",
    'dusr_ed__allow_dl_usr_access' => "Pahintulutan ang pag-access ng administrador ng domain",
    'dusr_ed__information' => "Mga katangian ng Administrador ng Domain %1",
    'dusr_ed__locale' => "Wika ng administrador ng domain",
    'dusr_ed__skin' => "Interface skin ng administrador ng domain",
    'dusr_ed__personal_information' => 'Personal na impormasyon',
    'ess__error' => "Error",
    'example__' => "Halimbawa: %1",
    'extras__allow_certificate_purchasing' => "Pahintulutan ang pag-bili ng sertipiko",
    'extras__allow_domain_registration' => "Pahintulutan ang pagpaparehistro ng domain",
    'extras__allow_extras' => "Pahintulutan ang ekstrang mga serbisyo",
    'extras__buy_new_key' => "Ang iyong kasalukuyang lisensya ay hindi nagpapahintulot na baguhin ng modipikasyon sa mga bagay na ito.",
    'extras__setup_services' => "Mag-set up ng karagdagang mga serbisyo",

    'ruleeditform__error' => 'Hindi ma-update ang panuntunan sa firewall.',
    'ruleeditform__name_is_required' => 'Tukuyin ang pangalan ng alituntunin.',
    'ruleeditform__profiles_is_required' => 'Pumili kahit isang profile.',
    'ruleeditform__invalid_ip' => 'Ang natukoy na IP address o network ay hindi wasto.',
    'ruleeditform__invalid_port' => 'Ang natukoy na port ay hindi wasto. Ang posibleng mga marka ay 1000 o 1000-1051',

    'get_password__encrypted_password' => "Hindi maipadala ang impormasyon ng password: ang password ay naka-stored bilang encrypted.",
    'get_password__mail_error' => "Ang error ay nangyari habang nagpapadala ng password sa email %1: %2",
    'get_password__mail_ok' => "Ang password ay matagumpay na naipadala sa email: %1",
    'get_password__message' => "Ang iyong username para sa pag-access ng system: %1\nAng iyong password ay %2",
    'get_password__subject' => "Ang password para sa pag-access ng system",
    'groups__available' => "Magagamit na mga mail group",
    'groups__groups_for_mailname' => "Mga mail group kung saan ang mail account %1 ay naka-suskribe",
    'groups__member_of' => "Myembro ng sumusunod na mga mail group",
    'help__help_area' => "Lugar sa tulong.",
    'hst_def__auth_disabled' => "ipinagbabawal",
    'hst_def__auth_enabled' => "pinahintulutan",
    'hst_def__change_curr_dns_ip' => "Ang kasalukuyang IP address ng A DNS record ay mapapalitan",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Wala sa mga IP address ng A DNS record ang tumugma sa IP address na nakatakda sa hosting account na nilikha",
    'hst_def__dest_url' => "Destination URL",
    'hst_def__disk_quota' => "Disk quota",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Ang disk space na iyong sinusubukan na itakda ay sumobra sa limitasyon ng disk space sa direktoryo na hindi kilalang FTP. Ang limitasyon ng disk space sa paparating na direktoryo nang hindi kilalang FTP ay hindi dapat sumobra sa limitasyon ng disk space ng domain.",
    'hst_def__frame_forwarding_definition' => "Pagtakda ng frame forwarding para sa domain %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Babala: Ang user ng FTP %1 ay nagamit sa mga setting ng hosting account ngunit hindi umiiral sa system.",
    'hst_def__hst_type_is_not_defined' => "Ang uri ng hosting ay hindi natukoy",
    'hst_def__ip_based' => "Batay sa IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Pag-transfer nitong hosting account sa shared IP address ay gagawin na hindi magagamit ang serbisyo ng hindi kilalang FTP sa domain. Magpatuloy pa rin?",
    'hst_def__password_is_invalid_password_syntax' => "Ang password ay hindi wasto.\nHuwag gumamit ng isang quote, at nasyonal na mga karakter ng alpabeto sa password.\nAng kahabaan ng password ay dapat mula sa 5 hanggang 14 na mga karakter. Ang password ay hindi dapat naglalaman ng pangalan ng user.",
    'hst_def__shell' => "Pag-access sa SSH sa server shell sa ilalim ng suskrisyon ng user ng system",
    'hst_def__shell_windows' => "Ang pag-access sa Remote Desktop sa server sa ilalim ng suskrisyon ng user ng system",
    'hst_def__standard_forwarding_definition' => "Pagtakda ng standard forwarding para sa domain %1",
    'hst_def__title_name_based' => "Batay-sa-pangalan",
    'hst_def__unable_create/update_physic_hst' => "Hindi makalikha o maka pag-update ng pisikal na hosting: %1",
    'hst_def__unable_create/update_std_fwd' => "Hindi makalikha o maka pag-update ng standard forwarding: %1",
    'hst_def__unable_create_forwarding_myself' => "Hindi makalikha ng forwarding sa sarili ng domain.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Hindi mapahintulutan ang paggamit ng iisang directory sa pag-iimbak ng content na may at walang SSL/TLS: Hindi naka-on ang suporta sa SSL/TLS.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Hindi ma-on ang suporta sa SSL/TLS: walang naka-install na SSL/TLS certificate.",
    'hst_def__url_is_invalid' => "Ang URL ay hindi wasto.",
    'hst_def__virtual_host_access' => "Pag-access ng virtual na host para sa domain %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "BABALA. Ang virtual na host ay gumagamit ng hindi umiiral na IP address para sa hosting.",
    'hst_def__you_have_no_ips' => "Ikaw ay walang mga IP address na magagamit at ikaw ay hindi pinahihintulutan na lumikha ng Batay-sa-pangalan na hosting.",
    'hst_sel__header' => "Upang makapag-host sa website sa server na ito, Piliin ang opsyon ng Pisikal na hosting.\n Upang ma-set up ang domain forwarding sa site sa ibang makina, piliin ang opsyon ng Frame forwarding o forwarding.\n Sa standard na forwarding, ang user ay muling idi-direkta sa site at ang aktwal na site ng URL ay ipapakita sa browser ng user, kaya ang user ay alam ang tungkol sa muling pag-direkta. Sa frame forwarding ang user ay muling idi-direkta sa site na hindi alam na ang site ay aktwal na nakalagay sa ibang lokasyon.",
    'hst_sel__physical_hst' => "Pisikal na hosting",
    'hst_sel__select_hst_type' => "Pumili ng uri ng hosting para sa domain",
    'hst_sel__select_hst_type_warning' => "Pumili ng uri ng hosting para sa domain",
    'hst_sel__hosting_exists' => "Hindi makalikha ng hosting, dahil ito ay naka-konpigura para sa domain na ito. Ikaw ay maililipat sa pahina ng pangasiwaan sa hosting.",
    'hst_sel__standard_frw' => "Standard forwarding",
    'hst_sel__frame_frw' => "Frame forwarding",
    '__frame_frw' => "Frame forwarding",
    '__hosting_exists' => "Hindi makalikha ng hosting, dahil ito ay naka-konpigura para sa domain na ito. Ikaw ay maililipat sa pahina ng pangasiwaan sa hosting.",
    '__choose_hst_type' => "Piliin ang kailangan na hosting type.",
    '__no_hst_conf' => "Walang nakonpigura na hosting para sa iyong domain.",
    '__physical_hst' => "Pisikal na hosting",
    '__select_hst_type' => "Pumili ng uri ng hosting para sa domain",
    '__standard_frw' => "Standard forwarding",
    '__warning' => "Babala! Lahat ng mga parameter na naitakda sa nakaraan ay matatanggal. Sigurado ka bang nais mong palitan ang hosting type?",
    'i_cl_off' => "Ang kustomer ay hindi aktibo.",
    'i_cl_off_by_admin' => "Ang account ng kustomer ay ginawang suspendido ng administrador ng server.",
    'i_cl_off_expired' => "Account ng kustomer nawalan ng bisa.",
    'i_cl_on' => "Ang kustomer ay aktibo.",

    'icf__title' => 'Firewall sa Koneksyon ng Internet',
    'icf__if_legend' => 'Mga Interface',
    'icf__mode' => 'Mode',

    'invalid_value' => 'Ang marka ay hindi wasto',

    'ip_addr__already_exists' => "Ang IP address %1 ay umiiral.",
    'ip_addr__cant_add' => "Ang IP %1 ay hindi umiiral o kabilang sa IP pool ng ibang kustomer",
    'ip_alias__interface' => "Interface",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 Ang IP address para sa batay-sa-pangalan na virtual na hosting ay hindi wasto.",
    'ip_alias__invalid_ip_or_netmask' => "Hindi wastong pares ng IP address/netmask.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Ang IP address %1 ay orihinal na server IP, kaya ito ay hindi maaring maalis.",
    'ip_alias__ip_is_invalid' => "%1 Ang IP address ay hindi wasto.",
    'ip_alias__ip_mask_is_invalid' => "%1 Ang IP mask ay hindi wasto.",
    'ip_alias__ip_not_exist' => "Ang IP address %1 ay hindi umiiral.",
    'ip_alias__ip_address_and_mask' => 'IP address at subnet mask',
    'ip_alias__mask' => "Subnet Mask",
    'ip_alias__remove_selected_ip_aliases?' => "Sigurado ka bang nais mong alisin ang napiling mga IP address?",
    'ip_alias__select_ip' => "Pumili ng kahit isang IP address mula sa listahan ng aalisin.",
    'ip_alias__this_ip_used_for_domain' => "(%1) ang IP address na ito ay ginamit para sa domain na %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) ang IP address na ito ay ginamit para sa batay-sa-pangalan na virtual na hosts.",
    'ip_alias__unable_add_ip' => "Hindi makakadagdag ng IP: %1",
    'ip_alias__unable_remove_ip' => "Hindi maalis ang IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Hindi mo maaring palitan ang uri ng IP address tungo sa shared, gagawin nito ang hindi kilalang FTP para sa domain '%1' na hindi magagamit.",
    'ip_ctrl__ip_addr' => "IP address %2 sa interface %1",
    'ip_ctrl__ip_exists_many_pools' => "Hindi mo maaring palitan ang uri ng IP. Ang IP address ay kabilang sa mga pool ng i-ilang mga user sa parehong oras.",
    'ip_ctrl__ssl_cert' => "SSL/TLS Certificate",
    'limit__date_in_past' => "Hindi wasto ang tagal ng bisa. %1 ay nasa nakaraan.",
    'limit__enter_date' => "Ilagay ang petsa",
    'limit__max_db' => "Mga database",
    'limit__name_disk_space' => "Disk space",
    'limit__name_max_box' => "mga mailbox",
    'limit__name_max_db' => "MariaDB/MySQL database",
    'limit__name_max_dom' => "mga domain",
    'limit__name_max_maillists' => "listahan ng mailing",
    'limit__name_max_subdom' => "mga subdomain",
    'limit__name_max_traffic' => "trapiko",
    'limit__name_max_wu' => "mga user ng Web",
    'limit__name_mbox_quota' => "quota ng mailbox",
    'limit__name_max_mn' => "mga mail account",
    'limit__name_max_cl' => 'mga kliyente',
    'limit__name_total_mboxes_quota' => "kabuuang quota ng mailbox",
    'limit__name_mysql_dbase_space' => "Espasyo sa database ng MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "MSSQL database space",
    'limit__name_pgsql_dbase_space' => "Space ng PostgreSQL database",
    'limit__name_expiration' => 'petsa na walang-bisa',

    'locale_upload__unable_to_install' => 'Hindi mai-install ang language pack file',
    'locale_upload__wrong_package' => 'Ang file na iyong na-upload ay hindi naglalaman ng language pack na may bisa para sa bersyon ng Plesk.',
    'locale_upload__wrong_locale' => 'Ang file na iyong na-upload ay hindi naglalaman ng wastong language pack.',

    'ma__create_title' => 'Paglikha ng alyas ng mail para sa %1',
    'ma__edit_title' => "Mag-edit ng mail alias %1",
    'ma__enter_new_alias' => "Maglagay ng bagong alyas.",
    'ma__invalid_alias' => "Hindi wastong mail alias.",
    'ma__mail_aliases_mailname' => "Mga mail alias para sa mail account %1",
    'ma__mailname_does_not_exist' => "Ang mail account ay hindi umiiral.",
    'ma__select_ma_for_remove' => "Piliin ang mga mail alias na aalisin.",
    'ma__unable_to_add_new_ma' => "Hindi maaaring magdagdag ng mail alias: %1",

    'mail_queue__not_allowed_by_license_key' => 'Ang pangasiwaan ng mail queue ay hindi pinahihintulutan ng license key.',
    'maillist__' => "Mailing list %1",
    'maillist__already_exists' => "Ang mailing list ay umiiral.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Ang mail alias %1 ay umiiral sa domain na ito",
    'maillists__' => "Mga mailing list na %1",
    'maillists__limit_cl_max_maillists' => "Ang limitasyon sa bilang ng mga mailing list ay naabot para sa kustomer (limitasyon: %1, ginamit: %2)",
    'maillists__limit_dom_max_maillists' => "Ang limitasyon sa bilang ng mga mailing list ay naabot para sa domain.",
    'maillists__list' => "Listahan ng mailing",
    'maillists__mailman_not_installed_or_conf' => "\nAng mga Mailman Server Extension ay hindi kasalukuyang naka-install o nakonpigura\nsa server. I-kontak ang administrator ng server upang magkaroon ng Mailman Server Extensions na naka-install o nakonpigura ng maayos.",
    'maillists__status' => "Ang serbisyo ng mailing list ay binuhay",
    'maillists__unable_to_delete__' => "Hindi mabura ang mailing list: %1",
    'maillists__disabled_text' => 'Hindi ka maaring mangasiwa ng mga mailing list dahil ang Mailman mailing lists server component ay hindi naka-install o na-konpigura.',
    'maillist_member__already_exists' => 'Ang suskritor ng mailing list ay umiiral.',
    'maillist_member__not_exists' => 'Walang nasabing na user sa mailing list.',
    'mailserver_switching_warning' => "Babala!\n\nAng pagpapalit ng mail server ay sinadya lamang para sa paunang setup at, kapag ang server ay ginagamit, dahilan ng mga sumusunod na ma: pagkawala ng mga setting at nilalaman ng mga mailbox, at, at nagkataon ang iyong server na nalipat ay nakonpigura, iba-ibang pagtatalo.\nKapag ang server na ito ay ginagamit ngayon at ikaw ay tiyak tungkol sa pag-switch sa iba, maari mong abisuhan ang iyong mga kustomer tungkol sa operasyon sa gayon sila ay maka-download at mai-save ang kanilang mail.",
    'manager__access_denied' => "Ang pag-access ay tinanggihan: %1",
    'manager__admin' => "Administrador",
    'manager__client' => 'Customer',
    'manager__domain' => "Domain",
    'manager__domain_cl_limit_exceeding' => "Ang limitasyon sa bilang ng mga domain ay naabot para sa account ng kustomer na ito.",
    'manager__domain_is_not_yours' => "Ang domain %1 ay hindi iyo.",
    'manager__domain_key_limit_exceeding' => "Ang limitasyon sa paggawa ng domain na tinukoy ng iyong license key ay naabot.",
    'manager__no_perm_to_call' => "Ikaw ay walang pahintulot para tumawag %1.",
    'manager__no_perm_to_create_domains' => "Ikaw ay walang pahintulot para lumikha ng mga domain.",
    'manager__no_perm_to_modify_domain' => "Ikaw ay walang pahintulot para i-modify ang domain %1.",
    'manager__no_perm_to_modify_domains' => "Ikaw ay walang pahintulot para i-modify ang mga domain.",
    'manager__no_perm_to_remove_domain' => "Ikaw ay walang pahintulot para alisin ang domain %1.",
    'manager__no_perm_to_remove_domains' => "Ikaw ay walang pahintulot para alisin ang mga domain.",
    'manager__node_doesnt_exist' => "%1 ay hindi umiiral.",
    'manager__user_disabled' => "Ang iyong account ay suspendido. Hindi ka maaring gumawa ng operasyon sa system.",
    'mail_quota_unsupported' => "hindi suportado ng mail server",
    'mbox_quota_unsupported' => "hindi suportado ng mail server",
    'mn__create_title' => "Lumikha ng mail account",
    'mn__edit_title' => "Mga setting",
    'mn__files_list_title' => "Mga Attachment File",
    'mn__files_remove' => "Alisin ang mga files mula sa kalakip na repository. Ang mga files na ito ay posibleng ginamit ng mga auto-reply. Sila ay maalis mula sa parehong repository at mga auto-reply na gumagamit sa kanila.",
    'mn__files_select_for_remove' => "Pumili ng mga file na aalisin.",
    'mn__mail_alias_form' => "Pormularyo ng mail alias",
    'mn__mail_aliases_list' => "Mga mail alias",
    'mn__mailbox' => "Pangasiwaan ng mailbox",
    'mn__unable_define_mn' => "Hindi maka-set up ng mga mail account: %1",
    'mn__unable_remove_mbox_quota' => "Hindi maalis ang mailbox quota: %1",
    'mn__upload_file' => "Mag-upload ng file",
    'mn_edit__attach_filename_changed' => 'Ang na-upload na file %1 ay binago ang pangalan sa %2 dahil ang pangalan ay naglalaman non-ASCII na mga karakter.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Ikaw ay dapat na magdagdag ng myembro ng mga mail group bago paganahin ang mga mail group.",
    'mn_edit__add_resp_or_turn_off_box' => "Kailangan mong magdagdag ng add auto-reply o linisin ang auto-reply check box.",
    'mn_edit__attachments' => "Mga kalakip",
    'mn_edit__dom_quota_less_then_quota' => "Ang laki ng mailbox na ito ay dapat hindi sobra sa limitasyon ng dami ng disk space na inilaan para sa mga mailbox sa domain na ito.",
    'mn_edit__enter_external_rcpnt_email' => "Maglagay ng eksternal na email ng myembro ng grupo",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "I-type ang address para sa mail forwarding o linisin ang check box.",
    'mn_edit__ext_rcpnt_email_invalid' => "Ang eksternal na email address ng tagatanggap ay hindi wasto.",
    'mn_edit__file_exists' => "Ang file ay umiiral. Patungan?",
    'mn_edit__files_deld_from_repository' => "Ang mga file na ito ay mabubura mula sa repository at sa mga auto-reply na naglalaman sa kanila. Nais mo bang magpatuloy?",
    'mn_edit__mail_name' => "Mail account",
    'mn_edit__mail_name_invalid' => "Ang pangalan ng mail account ay hindi wasto.",
    'mn_edit__mail_redir' => "Mga mail forwarder",
    'mn_edit__mail_redir_add' => "Magdagdag ng myembro sa mail group",
    'mn_edit__mail_resps' => "Mga mail auto-reply",
    'mn_edit__mailbox' => "Mailbox",
    'mn_edit__enable_mailbox' => "Mailbox",
    'mn_edit__mailgroup' => "Grupo ng mail",
    'mn_edit__mailgroup_addresses' => "Mga myembro ng mail group",
    'mn_edit__mailgroup_disabled' => "Magagamit lamang kapag ang mail account ay nadagdag.",
    'mn_edit__max_dom_quota' => "Default para sa domain (%1)",
    'mn_edit__mbox_quota_invalid' => "Natukoy ang laki ng mali na mailbox.",
    'mn_edit__new_resp_name' => "Bagong pangalan ng auto-reply",
    'mn_edit__no_autoresponders' => "Kailangan mong magdagdag ng kahit isang auto-reply bago ang pagpatay/bukas ng serbisyo ng auto-reply.",
    'mn_edit__no_file_sel' => "Walang napiling mga file.",
    'mn_edit__no_mail_addresses' => "Walang email address na natukoy o napili.",
    'mn_edit__none' => "Wala",
    'mn_edit__not_create_pass' => "Ito ay hindi lilikha ng password para sa account na ito.\nKung walang password, ang user ay hindi maaring view at magpadala ng mail.",
    'mn_edit__redir_email_invalid' => "Ang forwarding address ay hindi wasto.",
    'mn_edit__redirect_addr' => "Forwarding address",
    'mn_edit__remove_autoresp?' => "Sigurado ka bang nais mong alisin ang auto-reply?",
    'mn_edit__remove_rcpnts?' => "Sigurado ka bang nais mong alisin ang mga tagatanggap?",
    'mn_edit__repository' => "Taguan",
    'mn_edit__resps_attach' => "Mga attachment file ng auto-reply",
    'mn_edit__select_rcpnt_from_list' => "Pumili ng kahit isang tagatanggap mula sa listahan upang alisin ito.",
    'mn_edit__select_registered_users' => "Pumili ng mga rehistradong mga user",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Ikaw ay napili na magkaroon ng mailbox ngunit hindi naka-set up ang password para dito.",
    'mn_edit__unable_act_deact_mail_group' => "Hindi magawang aktibo o ipawalang bisa ang mail group: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Hindi magawang aktibo o ipawalang bisa ang mail forwarding: %1",
    'mn_edit__unable_act_deact_postbox' => "Hindi ma-activate/deactivate ang mailbox: %1",
    'mn_edit__unable_act_deact_resp' => "Hindi ma-activate/deactivate ang auto-replies: %1",
    'mn_edit__unable_add_attach' => "Hindi makapag dagdag ng kalakip na file: %1",
    'mn_edit__unable_add_mail_group_member' => "Hindi makapag dagdag ng myembro ng mail group: %1",
    'mn_edit__unable_add_resp' => "Hindi makapag dagdag ng auto-reply: %1",
    'mn_edit__unable_change_mail_name' => "Hindi mapalitan ang pangalan ng mail account: %1",
    'mn_edit__unable_deactivate_mail_group' => "Hindi maipa-walang bisa ang mail group: %1",
    'mn_edit__unable_deactivate_resp' => "Hindi maipa-walang bisa ang mga mail auto-reply: %1",
    'mn_edit__unable_define_resp_id' => "Hindi matukoy ang auto-reply ID: %1",
    'mn_edit__unable_remove_attach' => "Hindi maalis ang kalakip na (mga) file: %1",
    'mn_edit__unable_remove_autoresp' => "Hindi maalis ang auto-reply: %1",
    'mn_edit__unable_remove_mail_group_member' => "Hindi maalis ang mga myembro ng mail group: %1",
    'mn_edit__wrong_way' => 'Ang mga mensahe na naka-address sa %1 ay hindi maihahatid, sapagkat ang mail account na ito ay walang binuhay na mailbox o mail forwarder.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Ang mailbox sa address %1 ay pinatay. Ang mga mensahe sa mailbox ay hindi natanggal, ngunit hindi mo maaring maibalik ang mga ito sa IMAP o POP3 na protokol.',
    'mn_list__mail_names_for_domain' => "Mga Mail account sa ilalim ng domain %1",
    'mn_list__sa_cannot_unable' => "Hindi mabuksan ang pag-filter sa spam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Customer',
    'mn_list__tab_title_domain' => 'Domain',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Pangalan",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Hindi maalis ang mga mail account: %1",
    'module_upload__module_was_installed' => 'Ang modulo na ito ay naka-install. Kung nais mong mag-install ng mas bagong bersyon ng modulo na ito, alisin sa pagkaka-install ang modulo ng Plesk, at subukan ang pag-install.',
    'module_upload__unable_to_install' => 'Hindi mai-install ang file ng pakete ng modulo',
    'module_upload__wrong_package' => 'Ang na-upload na file ay hindi suportado ang pakete ng modulo.',
    'module_upload__wrong_module' => 'Ang na-upload na file ay hindi naglalaman ng pakete ng modulo.',

    'news_articles_title' => 'Balita ng Plesk',
    'notification_text__invalid_subject_length' => "Hindi wastong haba ng paksa ng abiso. Dapat ay mula 1 hanggang 255 character.",
    'notification_text__invalid_text_length' => "Hindi wastong kahabaan ng notice teksto. Dapat ay mula sa 1 hanggang 65533 na mga karakter.",
    'notification_text__subject' => "Paksa ng abiso",
    'notification_text__text' => "Abiso sa teksto",
    'notification_text__title' => "I-edit ang notice",
    'notification_text__unable_set_text' => "Hindi mai-modify ang notice teksto:",

    'odbc__cant_add_dsn' => "Hindi makakadagdag ng DSN %1: %2",
    'odbc__cant_connect' => "Hindi magawa ang pag-konekta sa data source gamit ang naipaliwanag na mga settings. Ang server ay bumalik: %1",
    'odbc__cant_delete_dsn' => "Hindi mabura ang DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Hindi makakuha ng impormasyon tungkol sa mga driver.",
    'odbc__cant_get_drivers' => "Hindi maibalik ang listahan ng ODBC drivers: %1",
    'odbc__cant_open_info_file' => "Hindi mabuksan ang file kasama ang impormasyon ng ODBC drivers.",
    'odbc__cant_parse_string' => "Hindi ma-parse ang connection string.",
    'odbc__driver_not_set' => "Ang driver ay hindi naka-set",
    'odbc__driver_or_name_not_set' => "Driver o pangalan ng ODBC connection ay hindi naka-set",
    'odbc__dsn_already_exists' => "DSN na mayroon nitong pangalan (%1) ay umiiral sa system",
    'odbc__dsn_not_exists' => "Ang DSN ay hindi umiiral",
    'odbc__enter_dsn_name' => "Maglagay ng pangalan ng DSN",
    'odbc__invalid_dsn_name' => "Maling syntax para sa pangalan ng ODBC connection (%1): gumamit lamang ng alphanumeric na mga simbolo.",
    'odbc__no_such_driver' => "Ang ODBC driver na mayroong ganyang pangalan (%1) ay hindi suportado.",
    'odbc__unknown_driver' => "Hindi kilalang pangalan ng driver (%1).",
    'odbc_dsn_system' => "System DSN",

    'pb__aliases' => "Mga alyas",
    'pb__anonftp' => "Hindi kilalang FTP",
    'pb__autoinstaller_releases' => 'Updater',
    'pb__cert' => "Mga sertipiko",
    'pb__cl_pool' => "IP address",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Mga setting",
    'pb__cl_rpt' => "Ulat",
    'pb__cl_rpt_list' => "I-customize",
    'pb__cl_templates' => "Mga template ng kustomer",
    'pb__cl_traffic' => "Trapiko",
    'pb__cl_traffic_history' => "Kasaysayan ng trapiko",
    'pb__cl_traffic_of' => "Trapiko ng %1",
    'pb__client' => "%1",
    'pb__clients' => "Mga kustomer",
    'pb__comp_info' => "Mga Components ng Server",
    'pb__common_acl' => 'Pahintulutan ang Pag-transfer ng ACL',
    'pb__cp_access' => "Pag-access",
    'pb__crontab' => "Nag-iskedyul",
    'pb__scheduler' => "Nag-iskedyul",
    'pb__custom_buttons' => "Mga buton ng custom",
    'pb__databases_db' => 'Mga database',
    'pb__sqlservers_db' => 'Mga SQL Server', //to check
    'pb__db' => "Mga database",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Mga database server',
    'pb__dl_usr_ed' => "Administrador ng domain",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Mga limit ng domain",
    'pb__dom_pref' => "Mga setting",
    'pb__dom_sum_report' => "Buod na Ulat ng Domain",
    'pb__dom_templates' => "Mga Templates ng Domain",
    'pb__dom_traffic' => "Trapiko ng %1",
    'pb__domains' => "Mga domain",
    'pb__domain_aliases' => 'Mga Domain Alyas',
    'pb__dumps_list' => "Imbakan ng mga Na-backup na mga File",
    'pb__forwarding_setup' => "Setup ng Forwarding",
    'pb__filemanager' => "Tagapangasiwa ng File",
    'pb__ip_aliasing' => "Mga IP Address",
    'pb__ip_clients' => "Pag-alis ng mga IP Address",
    'pb__license_management' => 'Impormasyon ng Lisensya',
    'pb__locales' => 'Mga Locale',
    'pb__log_files' => "Mga log file",
    'pb__mail' => 'Mail',
    'pb__mail_name_files' => "Mga attachment file",
    'pb__mail_name_redirects' => "Mga mail forwarder",
    'pb__mail_name_resp_attach_add' => "Bagong kalakip",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Mga mail auto-reply",
    'pb__mail_names' => "Mail",
    'pb__maillists' => "Listahan ng mailing",
    'pb__modules' => 'Mga modulo',
    'pb__modules_management' => 'Pangasiwaan ang mga Modulo',
    'pb__notifications' => "Mga Notification",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Setup ng pisikal na hosting",
    'pb__prtd_dirs' => "Protektadong mga Direktoryo",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "I-customize",
    'pb__server' => "Server",
    'pb__sessions' => "Mga sesyon",
    'pb__sapp_pool' => "Web Application Pool",
    'pb__siteapp_install' => 'Pag-install ng web application',
    'pb__site_app_pkgs' => 'Mga Web application',
    'pb__site_apps' => "Mga Web application",
    'pb__additional_key_info' => 'Mga Katangian ng Key',
    'pb__additional_key_properties' => 'Mga Katangian ng Key',
    'pb__skins' => 'Mga Balat',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Spam Filter",
    'pb__statistics' => "Mga estatistika",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Mga subdomain",
    'pb__templates' => "Mga template",
    'pb__virtualdirs' => 'Virtual na mga direktoryo',
    'pb__web_users' => "Mga user ng Web",
    'pdir__invalid_hst' => "Ang uri ng hosting ay hindi wasto. Dapat ay pisikal.",
    'pdir__pd_id_is_undefined' => "Ang protektadong ID ng direktoryo ay hindi natukoy.",
    'pdir__pdir_exist' => "Ang direktoryo na mayroong ganitong pangalan ay protektado.",
    'pdir__pdir_not_exist' => "Ang protektadong direktoryo ay hindi umiiral.",
    'pdir__pdir_usr_not_exist' => "Ang protektadong user ng direktoryo ay hindi umiiral.",
    'pdir__remove_pdir_usrs' => "Ang mga sumusunod na mga user ng protektadong direktoryo %2 sa ilalim ng website %1 ay maalis:",
    'pdir__remove_pdir_usrs_on_subdom' => "Ang mga sumusunod na mga user ng protektadong direktoryo %2 sa ilalim ng subdomain %1 ay maalis:",
    'pdir__select_pdir_usrs_for_remove' => "Piliin ang protektadong mga user ng direktoryo sa aalisin.",
    'pdir__select_pdirs_to_remove' => "Piliin ang mga direktoryo na aalisan ng proteksyon.",
    'pdir__unable_define_pdir_users' => "Hindi matukoy ang protektadong mga user ng direktoryo.",
    'pdir__unable_define_pdirs_properties' => "Hindi ma-set ang mga katangian ng mga protektadong direktoryo: %1",
    'pdir__unable_select_dom_param' => "Hindi makapili ng mga parameter ng domain: %1",
    'pdir_ed__dir_already_protect' => "Ang direktoryo ay protektado.",
    'pdir_ed__invalid_login' => "Tinukoy mo ang maling username.",
    'pdir_ed__login_exists' => "Ang user na ito ay umiiral. Subukan ang pagtukoy ng ibang username.",
    'pdir_ed__pdir_users' => "Protektadong mga user ng direktoryo",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Dapat ay may mapiling kahit isang check box lang mula sa mga check box na may at walang SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Hindi malikha ang protektadong user ng direktoryo: %1",
    'pdir_ed__unable_create_pdir' => "Hindi malikha ang mga protektadong direktoryo: %1",
    'pdir_ed__unable_define_hst_type' => "Hindi matukoy ang uri ng hosting.",
    'pdir_ed__unable_update_pdir' => "Hindi mai-save ang mga setting ng protektadong direktoryo: %1",
    'pdir_ed__wrong_symbol_in_header' => "Huwag gamitin ang karakter %1 sa titulo ng direktoryo.",
    'pdir_usr_ed__not_create_pass' => "Ito ay hindi lilikha ng password para sa bagong protektadong user ng direktoryo.\nKung walang password ang user ay hindi makakapag-log in.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Hindi mapili ang protektadong user ng direktoryo: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Hindi matukoy ang protektadong mga user ng direktoryo: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Hindi maalis ang protektadong mga user ng direktoryo: %1",
    'phosting__anonftp_encrypt' => 'Ang password ng FTP user ay encrypted, at kaya hindi maaaring magamit para sa pag-protekta ng direktoryo /plesk-stat/webstat/. Muling ipasok ang iyong FTP password, o alisin ang pagkaka-pili ng opsyon ng "maaring ma-access sa pamamagitan ng pinoprotektahan ng password na direktoryo \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Ang domain name %%domain_name%% ay inaayos sa IP address %%dns_ip_address%%. Ang iyong website ay itinakda sa IP address %%hosting_ip_address%%. Kung ang iyong website ay hindi nag-bubukas ng web browser kapag iyong inirekomenda ito sa sariling domain name, pumunta sa iskrin ng pangasiwaan ng DNS (Domains > Domain name > DNS) at baguhin ang mga katangian ng A tala ng resource: itakda ang IP address %%hosting_ip_address%% sa domain name %%domain_name%%.",
    'phosting__ip_change_warning' => "Napalitan ang IP address. Ang tumutugmang mga pagbabago ay ginawa din sa DNS zone ng domain.",
    'phosting__other_hosting_exists_on_ip' => "Hindi mapalitan ang sertipiko dahil ang IP address na ito ay ginagamit sa isa o i-ilang mga hosting account.",
    'phosting__unable_to_change_certificate' => "Hindi ma-install ang sertipiko: %1",
    'phosting__unable_to_change_ip_address' => "Hindi mapalitan ang IP address: %1",
    'phosting__unable_to_set_cert' => "Hindi maitakda ang SSL/TLS certificate: %1",
    'phosting__unable_update' => "Hindi magawa ang pag-update ng mga setting ng hosting: %1",
    'phosting__unable_manage' => "Hindi mapangasiwaan ang hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Hindi ma-configure ang fail2ban para subaybayan ang mga log ng domain. Awtomatikong susubaybayan ang mga log sa susunod na mag-restart ang serbisyo ng fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Pumili ng ACL record',
    'picker_autoresponder__title' => 'Pumili ng Auto-reply',
    'picker_black_list__domain_name' => 'Pumili ng Domain Name',
    'picker_certificate' => 'Pumili ng SSL/TLS Certificate',

    'picker_dns_zone_template__title' => 'Pumili ng isang Tala ng Resource',
    'picker_domain__title' => 'Pumili ng Website',
    'picker_domain_alias__title' => 'Pumili ng Domain Alias',
    'picker_resource_record__title' => 'Pumili ng isang Tala ng Resource',
    'picker_disabled_resource_record__title' => 'Pumili ng Pangalan ng Server',
    'picker_ip_address__title' => 'Pumili ng IP Address',
    'picker_ip_address_clients__title' => 'Pumili ng mga Kustomer Na Gumagamit Nitong IP Address',
    'picker_mail_queue' => 'Pumili ng Email Messages',
    'picker_site_application__title' => 'Pumili ng Web Application',
    'picker_subdomain__title' => 'Pumili ng Subdomain',
    'picker_web_user__title' => 'Pumili ng Web User',
    'picker_custom_button__title' => 'Pumili ng buton na custom',
    'picker_license_key__title' => "Pagpili ng license key",
    'picker_spamfilter_address__title' => 'Pumili ng Spam Filter Address',
    'picker_white_list__networks' => 'Pagpili ng mga Network',

    'plesk_key__action_logs' => "Pag-log ng mga action na ginampanan ng mga user ng Plesk",
    'plesk_key__app_vault' => "Application vault",
    'plesk_key__backup' => "Mga gamit ng backup at restoration",
    'plesk_key__client_templs' => "Pangasiwaan ng mga plano ng serbisyo",
    'plesk_key__clients' => "Mga account ng user (mga reseller at mga kustomer)",
    'plesk_key__resellers_only' => "Mga account ng user (mga reseller)",
    'plesk_key__customers_only' => "Mga account ng user (mga customer)",
    'plesk_key__domains' => "Mga domain",
    'plesk_key__domain_aliases' => "Mga alyas ng domain",
    'plesk_key__subdomains_limit' => "Mga subdomain",
    'plesk_key__databases' => "Mga database",
    'plesk_key__mssql_databases' => "MS SQL database",
    'plesk_key__manage_dashboard' => 'Home page customization',
    'plesk_key__drweb' => "Pangasiwaan sa antivirus",
    'plesk_key__event_manager' => "Tagapamahala ng event",
    'plesk_key__expirations' => "Pangasiwaan ng petsa ng pag-expire ng account",
    'plesk_key__group_ops' => "Modipikasyon ng maraming mga bagay ng nang minsan",
    'plesk_key__expiration' => "Petsa ng pag-expire ng key",
    'plesk_key__edition_name' => "Plesk Edition",
    'plesk_key__key_number' => "Numero ng key",
    'plesk_key__languages' => "Mga Language pack",
    'plesk_key__mailnames' => "Mga mail account",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Suporta ng Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Mga link para sa pagbili ng mga SSL/TLS certificate at serbisyo sa pagpaparehistro ng domain",
    'plesk_key__myplesk_server_id' => "MPC slave server identifier",
    'plesk_key__notifications' => "Pangasiwaan ng mga abiso",
    'plesk_key__postgresql' => "Suporta ng PostgreSQL database server",
    'plesk_key__qmail_queue' => 'Pangasiwaan ng mail queue',
    'plesk_key__remote_db' => 'Remote database hosting',
    'plesk_key__slave_servers' => "Mga slave server",
    'plesk_key__spamassassin' => "Pangasiwaan sa Spam filter",
    'plesk_key__subdomains' => "Pangasiwaan sa mga subdomain",
    'plesk_key__sys_access' => "Pamamahala ng access sa server",
    'plesk_key__traffic_reports' => "Ulat sa paggamit ng trapiko",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "May bisa para sa mga Virtuozzo container lamang",
    'plesk_key__webusers' => "Mga user ng Web",
    'plesk_key__cpu_cores' => 'CPU cores',
    'plesk_key__ram' => 'Memory',
    'plesk_key__license_update_date' => 'Susunod na pag-update ng license key',
    'plesk_key__autoinstaller_config' => 'Pangasiwaan ng mga setting ng updater',
    'plesk_key__check_wrong' => "Ang license key ay hindi wasto. Upang magamit ang Plesk, magkaroon at mag-install ng bagong balidong license key.",
    'plesk_key__upload_check_wrong' => 'Hindi wasto ang ginawang pag-load ng license key.',
    'plesk_key__revert_check_wrong' => 'Ang nakaraang na-install na license key ay hindi wasto.',
    'plesk_key__viruozzo_only_key' => 'Ang license key ay nilalayon lamang para gamitin sa Plesk na gumagana sa mga Virtuozzo container.',
    'plesk_key__ip_ranges_exceeded' => 'Maaari mo lamang gamitin ang lisensyadong kopya ng Plesk na ito sa mga sumusunod na mga IP address: %2. Ang mga sumusunod na IP address ay hindi sakop ng iyong lisensya: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Ang halaga ng mga kasalukuyang ginagamit na resource ay lampas sa mga limitasyong tinutukoy ng iyong lisensya.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Ang bilang ng mga website na hosted sa server ay sumobra sa mga limit na tinukoy ng iyong lisensya. Ikaw ay mayroong %2 mga site hosted; ang iyong lisensya ay nagpapahintulot lamang sa %1 na mga site.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Ang bilang ng domain alias sa server ay sumobra sa mga limitasyon na naipaliwanag ng iyong lisensya. Ikaw ay mayroong %2 mga domain alias; ang iyong lisensya ay nagpapahintulot sa hosting lamang ng %1 na mga domain alias.',
    'plesk_key__limits_exceeded_lim-subdom' => 'The number of subdomains on the server exceeds the limits defined by your license. You have %2 subdomains; your license allows hosting only %1 subdomains.',
    'plesk_key__limits_exceeded_lim-db' => 'The number of databases on the server exceeds the limits defined by your license. You have %2 databases; your license allows hosting only %1 databases.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'The number of MS SQL databases on the server exceeds the limits defined by your license. You have %2 databases; your license allows hosting only %1 databases.',
    'plesk_key__limits_exceeded_lim_cl' => 'Ang bilang ng na paglingkuran na mga account ng kustomer ay sumobra sa mga limitasyon na tinutukoy ng iyong lisensya. Ikaw ay mayroong %2 kasalukuyang napaglingkuran na mga account ng kustomer; ang iyong lisensya ay nagpapahintulot na maglingkod lamang sa %1 na mga account ng kustomer.',
    'plesk_key__limits_exceeded_lim_mn' => 'Ang bilang ng mapaglingkuran na mga account ng email ay sumobra sa mga limitasyon na tinukoy ng iyong lisensya. Ikaw ay mayroong %2 kasalukuyang napaglingkuran na mga account ng email; ang iyong lisensya ay nagpapahintulot na maglingkod lamang sa %1 na mga account ng email.',
    'plesk_key__limits_exceeded_lim_wu' => 'Ang bilang ng na paglingkuran na mga account ng web user ay sumobra sa mga limit na tinutukoy ng iyong lisensya. Ikaw ay mayroong %2 kasalukuyang napaglingkuran na mga account ng web user; ang iyong lisensya ay nagpapahintulot na maglingkod lamang sa %1 na mga account ng web user.',
    'plesk_key__limits_exceeded_MLS' => 'Ang bilang ng kasalukuyang naka-install na mga language pack ay sumobra sa mga limitasyon na tinukoy ng iyong lisensya. Mayroong %2 language packs na naka-install; ang iyong lisensya ay nagpapahintulot lamang na mag-install sa %1 na language packs.',
    'plesk_key__wrong_version' => 'Ikaw ay sumusubok na gumamit ng isang license key na nilikha para sa ibang bersyon ng Plesk. Kontakin ang mga kinatawan ng sales ng Plesk upang magkaroon ng tamang license key.',
    'plesk_key__other_product' => 'Ikaw ay sumusubok na gumamit ng isang license key na nalikha para sa ibang produkto. Kontakin ang mga kinatawan ng sales ng Plesk upang magkaroon ng tamang license key.',
    'plesk_key__invalid_machine_id_trial' => 'Hindi valid ang kasalukuyan mong lisensya dahil naka-activate na ito sa ibang server ng Plesk. Para patuloy na magamit ang Plesk, mag-install ng bagong lisensya o i-install ulit ang kasalukuyan mong lisensya sa pamamagitan ng paglalagay ng activation code nito (kung mayroon ka nito).',
    'plesk_key__invalid_machine_id_retail' => 'Hindi valid ang iyong kasalukuyang lisensya dahil naka-activate na ito sa ibang server ng Plesk. Ipinagbabawal ng EULA ng WebPros (https://www.plesk.com/legal/) ang paggamit ng isang lisensya sa dalawa o higit pang server nang sabay. Para patuloy na magamit ang Plesk, mag-install ng bagong lisensya o i-install ulit ang kasalukuyan mong lisensya sa pamamagitan ng paglalagay ng activation code nito. Ipinadala ito sa iyo sa email noong binili mo ang lisensya. <br>Hindi mo ba mahanap ang activation code? Puwede mo itong makuha gamit ang Plesk 360. Para magawa iyon, mag-log in sa https://platform360.io/ gamit ang email na ginamit mo para bilhin ang lisensya, pumunta sa tab na "Licenses" at tingnan ang activation code ng iyong lisensya. O puwede kang makipag-ugnayan sa Licensing and Purchase support ng Plesk gamit ang online na form (https://www.plesk.com/licensing-and-purchase-support/). Tandaang banggitin ang numero ng iyong lisensya sa seksyong "How can we help you?" sa form.',
    'plesk_key__limits_exceeded_error' => 'Hindi magawa ang pag-install ng license key: ang kasalukuyang nagamit na dami ng mga resource ay sumobra sa mga limitasyon na ipinaliwanag sa pag-load ng license key.',
    'plesk_key__limits_exceeded_note' => 'Ang kasalukuyang dami ng mga resource ay sumobra sa mga limitasyon na tinukoy sa pag-upload ng license key.',
    'plesk_key__hardware_limits_exceeded' => 'The hardware configuration exceeds the limits defined by your Plesk license.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'The server has %1 of memory installed, but your license allows not more than %2.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'The server has %1 CPU cores installed, but your license allows not more than %2.',
    'plesk_key__key_file_invalid' => 'Ang na-upload na key file ay hindi valid o hindi naglalaman ng license key.',
    'plesk_key__server_request_error' => 'Hindi ma-update ang lisensya. Tiyaking hindi bina-block ang mga koneksyon sa server ng lisensya na ka.plesk.com sa TCP port %1. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Tingnan kung paano gawin</a>.',
    'key__no_key_file_in_zip' => 'Ang ginawang pag-upload ng .zip file ay hindi naglalaman ng key file',
    'key__key_upload' => 'Pag-install ng License Key',
    'additional_key__prop_name' => 'Pagmamay-ari',
    'additional_key__prop_value' => 'Halaga',
    'additional_key__descr_name' => 'Pangalan ng key',
    'additional_key__descr_key_number' => 'Numero ng key',
    'additional_key__descr_key_vz' => "Ang license key na ito ay nilalayon para gamitin lamang sa mga Virtuozzo container.",
    'additional_key__descr_key_mailboxes' => 'Mga Mailbox',
    'additional_key__descr_lim_date' => 'Petsa na walang-bisa',
    'additional_key__descr_license_update_date' => 'Susunod na pag-update ng license key',
    'additional_key__file_invalid' => 'Ang na-upload na key file ay hindi valid o hindi naglalaman ng license key.',
    'additional_key__file_incompatible' => 'Ang na-upload na key file ay hindi valid para sa application na ito.',
    'additional_key__not_exists' => 'Walang naka-install na license key.',
    'additional_key_update__result_response' => 'Sagot ng Licensing server: %1',
    'additional_key_update__result_network' => 'Hindi maka-connect sa licensing server. Siguraduhin na ang iyong network ay nagpapahintulot sa komunikasyon sa %1: %2.',
    'additional_key_update__result_lock' => 'Ang pag-update ng key ay nasa progreso',
    'additional_key_update__result_internal_error' => 'Ang error ay nangyari habang isinasagawa ang pag-update ng license key: %1',

    'proceed_to_cl_pool' => "Magpatuloy sa pag-konpigura ng IP pool ng kustomer",
    'proceed_to_hosting_setup' => "Magpatuloy sa pag-setup ng hosting",
    'removeCerts__remove_certificates_cp' => "Ang mga sumusunod na mga sertipiko ay maaalis:",
    'removeCerts__remove_certificates_domain' => "Ang mga sumusunod na mga sertipiko na pagmamay-ari ng %1 ay maaalis:",
    'removeClientsIP_remove_clients_ip' => "Ang IP address na ito ay maaalis mula sa mga pool ng sumusunod na mga kustomer:",
    'removeMailAliases__remove_mail_aliases' => "Ang mga sumusunod na mga alyas para sa mail account %1 ay maaalis:",
    'removeMailNames__remove_mailnames' => "Ang sumusunod na mga mail account at mga alias ay maalis mula sa domain %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Ang sumusunod na mga mail account at mga alias ay maalis mula sa domain %2 na pagmamay-ari ng kustomer %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Ang mga mail account na ito ay mabubura.",
    'removeFtpSessions__remove_title' => "Ang mga sumusunod na mga sesyon ng FTP ay matatapos:",
    'removeTemplates__remove_templates' => "Ang mga sumusunod na mga template ay maaalis:",
    'resp_edit__always_respond' => "laging tumugon",
    'resp_edit__reply_subject' => "Sagutan ang paksa",
    'resp_edit__answer_subject' => "Sagutin gamit ang paksa",
    'resp_edit__answer_txt' => "Sumagot sa pamamagitan ng teksto",
    'resp_edit__attach' => "Ilakip ang mga file",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "para sa",
    'resp_edit__frw_rqst_email' => "Sa oras ng awtomatikong pagsagot, i-forward ang orihinal na mensahe sa natukoy na email",
    'resp_edit__fwd_email_invalid' => "Ang destination email address ay hindi wasto.",
    'resp_edit__in_body' => "kapag ang natukoy na mga salita ay nahanap sa katawan ng mensahe",
    'resp_edit__in_subject' => "kapag ang natukoy na mga salita ay nahanap sa paksa ng mensahe",
    'resp_edit__invalid_resp_freq' => "Ang Response frequency ay hindi wasto.",
    'resp_edit__invalid_rqst_txt' => "Hindi wastong request teksto.",
    'resp_edit__invalid_store_lim_num' => "Ang limit ng marka ay hindi wasto.",
    'resp_edit__limits_title' => "Mga limitasyon",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Ang bilang ng pinakamataas na pagtugon kada araw ay sumobra sa tinukoy ng rate. Pinahintulutan: %1, hiniling: %2",
    'resp_edit__no_files_sel' => "Walang napiling mga file.",
    'resp_edit__no_txt_supplied' => "Walang teksto na nai-suplay.",
    'resp_edit__reply_title' => "Sumagot",
    'resp_edit__reply_to_address' => "Pabalik na address",
    'resp_edit__reply_to_invalid' => "Ang pabalik na address ay hindi wasto.",
    'resp_edit__reply_uniq_email' => "Sumagot sa unique email address na hindi hihigit",
    'resp_edit__conditions_title' => "Mga kondisyon",
    'resp_edit__request_title' => "Kahilingan",
    'resp_edit__resp' => "Auto-reply",
    'resp_edit__resp_name' => "Pangalan ng auto-reply",
    'resp_edit__resp_not_exist' => "Ang auto-reply ay hindi umiiral.",
    'resp_edit__resp_status' => "Estado ng auto-reply",
    'resp_edit__rqst_txt' => 'Tukuyin ang kondisyon para sa automatic reply na ito',
    'resp_edit__select_files_on_server_for_attach' => "Piliin ang mga file na nais mong ilakip",
    'resp_edit__store_up_to' => "I-store sa",
    'resp_edit__subj_line_invalid' => "Ang linya ng paksa ay mali.",
    'resp_edit__text_too_big' => "Ang reply message teksto ay masyadong malaki.",
    'resp_edit__times_in_a_day' => "bilang kada araw.",
    'resp_edit__unable_define_resp_cond' => "Hindi matukoy ang kondisyon ng auto-reply: %1",
    'resp_edit__unable_define_resp_status' => "Hindi matukoy ang estado auto-reply: %1",
    'resp_edit__unable_turn_on_resp' => "Hindi mabuksan ang auto-reply: %1",
    'resp_edit__uniq_email' => "mga kakaibang email address",
    'resp_edit__content_type' => 'Format ng pagpapadala ng mail',
    'resp_edit__content_type_text' => 'Karaniwang teksto',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Pag-encode',
    'restart__dns' => 'DNS Server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 Server (%1)",
    'restart__mssql' => "Microsoft SQL server",
    'restart__mysql' => "MariaDB/MySQL server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Mga Serbisyo",
    'restart__smtp' => "SMTP Server (%1)",
    'restart__spamd' => "Spam Filter",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Web Server (%1)",
    'restart__ftp' => "FTP Server (%1)",
    'restart__service_start' => 'Pahintulutan sa sandaling panahon para sa pagsimula ng serbisyo.',
    'restart__service_stop' => 'Pahintulutan sa sandaling panahon para sa paghinto ng serbisyo.',
    'restart__service_restart' => 'Pahintulutan sa sandaling panahon para sa muling pagsisimula ng serbisyo.',
    'rm_domains__some_domains_are_not_exist' => "Ang iba sa natukoy mga domain ay hindi umiiral. Posibleng, ang mga iyon ay inalis ng ibang user.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Mga forwarder",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Ulat para sa administrador %1",
    'rpt_cl_report_for_reseller__' => "Ulat para sa reseller %1",
    'rpt_cl_report_for_cl__' => "Ulat tungkol sa mamimili %1",
    'rpt_cl_section_domains' => "Mga domain",
    'rpt_cl_section_full_domains' => "Mga domain",
    'rpt_cl_section_general' => "Pangkalahatan",
    'rpt_create' => "Lumikha ng ulat",
    'rpt_empty' => "Ang ulat ay dapat na naglalaman ng kahit isang seksyon",
    'rpt_dom_report_for_dom__' => "Ulat ng domain para sa %1",
    'rpt_dom_section_databases' => "Mga database",
    'rpt_dom_section_full_databases' => "Mga database",
    'rpt_dom_section_full_maillists' => "Listahan ng mailing",
    'rpt_dom_section_full_mailnames' => "Mga mail account",
    'rpt_dom_section_full_webusers' => "Mga user ng Web",
    'rpt_dom_section_full_siteapps' => 'Mga web application',
    'rpt_dom_section_full_aspnetapps' => 'Mga ASP.NET web application',
    'rpt_dom_section_general' => "Pangkalahatan",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Listahan ng mailing",
    'rpt_dom_section_mailnames' => "Mga mail account",
    'rpt_dom_section_siteapps' => 'Mga web application',
    'rpt_dom_section_aspnetapps' => 'Mga ASP.NET web application',
    'rpt_dom_section_webusers' => "Mga user ng Web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "I-edit ang ulat %1",
    'rpt_enter_email_address' => "Ilagay ang email address ang kung saan ang paghahatid ng ulat.",
    'rpt_list' => "Mga report layout ng custom",
    'rpt_section_full' => "Puno",
    'rpt_section_none' => "Wala",
    'rpt_section_summary' => "Buod",
    'rpt_default_full' => 'Buong Ulat',
    'rpt_default_summary' => 'Buod ng Ulat',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Error sa pagpapadala ng ulat: %1",
    'rpt_send_report_by_email_ok__' => "Ang ulat ay ipinadala kay %1",
    'sa_action' => "Aksyon",
    'sa_action_del' => "Burahin (Delete)",
    'sa_action_desc' => "Ano ang gagawin sa spam mail",
    'sa_action_save' => "Markahan bilang spam at i-store sa mailbox",
    'sa_admin_blacklist' => "Black list ng administrador",
    'sa_admin_whitelist' => "White list ng administrador",
    'sa_db_del_confirm' => "Sigurado ka bang nais mong linisin ang database ng Spam Filter?",
    'sa_eml_in_ignorelist' => "Ang email ay nasa ignore list",
    'sa_empty_email' => "Hindi maaring magdagdag ng walang laman na email pattern.",
    'sa_exists_email' => "Ang nasabing email pattern ay umiiral.",
    'sa_disabled__mailname_not_filtering' => "Ang kasalukuyang mga setting ng server ay hindi pinahihintulutan ang paggamit ng pag-filter ng mail para sa mail account na ito",
    'sa_disabled__filtering_is_disabled' => 'Ang pag-filter sa spam ay pinatay ng administrador ng server',
    'sa_disabled__hasnt_mailbox' => "Imposible na mabuhay ang pag-filter sa spam kung walang mailbox",
    'sa_enable_filter' => "Buhayin ang pag-filter sa spam",
    'sa_forget' => "kalimutan",
    'sa_from' => "Mula",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Ang pattern ay hindi wasto.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Pagsasanay ng pag-filter sa spam',
    'sa_trainer__tools_legend' => 'Mga Kagamitan',
    'sa_trainer__info_legend' => 'Datos',
    'sa_trainer__messages_list_legend' => 'Mga mensahe sa iyong mailbox',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Paksa',
    'sa_trainer__from' => 'Mula',
    'sa_trainer__date' => 'Petsa',
    'sa_trainer__info_text' => 'Natutunang mga mensahe: %1 bilang spam, %2 bilang hindi-spam, %3 kabuuan.',
    'sa_trainer__messages' => '(mga)mensahe',
    'sa_trainer__select__all' => 'Lahat',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Hindi-Spam',
    'sa_trainer__select__unknown_only' => 'Hindi kilala',
    'sa_trainer__cannot_remove_messages' => 'Hindi maalis ang napiling mga mensahe mula sa mailbox.',
    'sa_trainer__remove_messages_confirm' => 'Sigurado ka bang hinihiling mong alisin ang napiling mga mensahe mula sa mailbox?',
    'sa_subj' => "Paksa",
    'sa_training' => "Pagsasanay ng pag-filter sa spam",
    'sa_training_legend' => "Pagsasanay ng pag-filter sa bayesian",
    'sa_use_srv_settings' => "Gamitin ang mga setting ng Server-wide",
    'sa_user_blacklist' => "Black list ng user",
    'sa_user_whitelist' => "White list ng user",
    'sa_usr_disabled_by_srv' => "Ang indibidwal na mga setting sa pag-filter sa spam ay hindi pinahihintulutan ng administrador ng server",
    'sa_usr_no_postbox' => "Hindi ma-enable ang pag-filter sa spam dahil nakapatay ang mailbox para sa email na ito.",
    'sa_filters' => 'Mga spam filter',
    'spamfilter__tools_legend' => 'Mga Kagamitan',
    'spamfilter__prefs_legend' => 'Mga setting',
    'spamfilter__max_children' => 'Ang maximum na bilang ng mga worker spamd process na ira-run',
    'spamfilter__rewrite_header_subject_hint' => 'Iwanan ang puwang na ito na blanko kung ayaw mo magdagdag ng anumang teksto. I-type ang _SCORE_ kung nais mo isama ang puntos sa paksa ng mensahe.',
    'spamfilter__reject_spam' => 'Burahin ang spam mail kapag napunta ito sa mailbox',
    'spamfilter__enabled' => 'Inilipat sa on',
    'spamfilter_addresses_list__items' => 'mga address',
    'spamfilter_addresses__remove_title' => 'Ang mga sumusunod na mga address ay maaalis mula sa listahan:',
    'spamfilter_addresses__empty_selection' => 'Walang mga address na napili.',
    'server__admin_info' => "Impormasyon ng administrador",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Ilagay ang paglalarawan ng bug sa ibaba",
    'server__power_management' => "Pangasiwaan ng enerhiya",
    'server__services' => "Mga Serbisyo",
    'server__system' => "System",
    'server__title' => "Administrasyon ng Server",
    'server_preferences__admin_skin' => "Interface skin ng administrador",
    'server_preferences__default_language' => "Default na wika",
    'server_preferences__default_skin' => "Default na skin",
    'server_preferences__restart_apache_interval' => "Mga pagitan ng pag restart ng Apache",
    'server_preferences__system' => 'Mga setting ng System',
    'mail__tabs_preferences' => "Mga setting",
    'mail__tabs_white_list' => "White list",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Repasuhin ang mga password para sa mga mailbox sa diksyonaryo",
    'sessions__agreement' => "Oo, Nais kong tapusin ang mga sesyon na ito.",
    'sessions__select_sessions_for_remove' => "Piliin ang mga sesyon na tatapusin.",
    'sessions__tabs_cp_sessions' => 'Mga Sesyon ng Plesk',
    'sessions__tabs_ftp_sessions' => 'Mga Sesyon ng FTP',
    'sessions__ftp_sessions_login' => 'Username ng FTP account',
    'sessions__ftp_sessions_domain' => 'Pangalan ng domain',
    'sessions__ftp_sessions_path' => 'Kasalukuyang lokasyon',
    'sessions__ftp_sessions_file' => 'Pangalan ng File',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Speed, KB/S',
    'sessions__ftp_sessions_comp' => 'Pagsulong %',

    'site_apps__access_level' => 'Lebel ng pag-access',
    'site_apps__access_level_commercial' => 'Komersyal',
    'site_apps__access_level_free' => 'Walang-bayad',
    'site_apps__action_installer' => "Pag-install ng web application",
    'site_apps__action_reconfigure' => "Muling pag-konpigura ng web application",
    'site_apps__custom_button_level' => 'Gusto mo bang lumikha ng isang pasadyang buton para sa pag-access ang application na ito?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Hindi',
    'site_apps__custom_button_level_domain_user_only' => 'Oo',
    'site_apps__custom_button_level_false' => 'Hindi',
    'site_apps__custom_button_level_domain' => 'Oo, at gawin itong magagamit para lamang sa kasalukuyang domain',
    'site_apps__custom_button_level_client' => 'Oo, at gawin itong magagamit para sa lahat ng mga domain ng kustomer',
    'site_apps__custom_button_level_admin' => 'Oo, at gawin itong magagamit para sa lahat ng mga domain',
    'site_apps__description' => "Paglalarawan",
    'site_apps__dir_used_by_sapp__' => "Ang direktoryo \"%1\" ay ginamit ng ibang web application",
    'site_apps__dir_used_by_unknown__' => "Ang direktoryo \"%1\" ay umiiral. Ang mga nilalaman ay mapa patungan kapag ikaw ay nagpatuloy.",
    'site_apps__dir_invalid_name__' => "Ang pangalan %1 ng direktoryo ay mali",
    'site_apps__file_name' => 'Filename ng web application',
    'site_apps__invalid_install_prefix' => "Hindi wastong unlapi ng pag-install",
    'site_apps__invalid_package' => "Ang web application ay hindi wasto",
    'site_apps__key_status' => 'Pag-lisensya',
    'site_apps__key_status_free' => 'Malayang naibahagi. Hindi kailangan ng license key',
    'site_apps__key_status_ok' => 'Ang kailangang license key ay naka-install',
    'site_apps__key_status_problem' => 'Ang kailangang license key ay hindi naka-install',
    'site_apps__name' => "Pangalan",
    'site_apps__no_domains' => 'Ang mga web application ay hindi maaring ma-install. Mayroong nang ibang web application na naka-install sa root directory ng domain na ito. Ipagpalagay na lumilikha ng subdomain para sa web application.',
    'site_apps__package_info_' => "Impormasyon ng Web Application",
    'site_apps__package_integrated' => "built-in na application, hindi maaring alisin",
    'site_apps__pool_select_packages_to_add' => 'Piliin ang mga web application upang idagdag sa pool',
    'site_apps__release' => "Pagpapalabas",
    'site_apps__resource_used_by_sapp' => "Ang resource na ito ay ginamit ng naka-install na web application",
    'site_apps__root_used_by_sapp' => "Ang resource na ito ay ginamit ng isang naka-install na web application",
    'site_apps__these_domains_will_not_delete' => 'Ang mga (sub)domain na ito ay hindi mabubura',
    'site_apps__upload_site_app_pkg_title' => 'Gawin ang pag-upload ng bagong web application',
    'site_apps__version' => "Bersyon",
    'site_apps__access_to' => "Pag-access sa %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Hindi maalis sa pakete ang archive. Ang archiver ay posibleng hindi naka-install sa server. Kontakin ang {$PROD_NAME} administrador upang magkaroon ng naka-install na archiver software.",
    'skeleton__archive_corrupted' => "Ang archive check ay nadiskubre na ang archive file ay na-korupt o ito ang uri ng archive ay hindi suportado.",
    'skeleton__archive_too_large' => "Ang archive check ay nadiskubre na ang archive file ay masyadong malaki.",
    'skeleton__not_supported_archive_type' => "Ang uri ng archive na ito (file %1) ay hindi suportado.",
    'skin_download__title' => 'Mag-download ng Skin',
    'skin_download_now__title' => 'Ang pag-download ng skin ay nasa pagsulong',
    'skin_download_now__text' => 'Ang paggawa ng pakete ay na sa pagsulong.<br>Ang paraang ito ay maaring magtagal ng ilang sandali.<br> Kapag ang dialog window ay lumabas, maari kang magpatuloy sa pagtatrabaho sa Plesk.',
    'skin_file__help_for_using_types' => "Gamitin ang skin archives sa isa sa sumusunod na mga pormat:",
    'skin_info__title' => 'Mga Katangian ng Skin',
    'skin_mng_err__rpm_not_skin' => 'Ang RPM na ito ay hindi pakete ng skin ng Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Nabigo sa pag-install ng rpm-based skin sa natukoy na lokasyon.',
    'skin_mng_err__already_exists' => 'Ang direktoryo sa pag-install ng skin ay umiiral, at mayroong pakete ng skin ang naihatid.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Ang na-upload na file ay hindi wasto RPM na pakete ng skin.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Ang na-upload na file ay hindi wasto na pakete ng skin.',
    'skin_mng_err__rpm_upgrade_base' => "Ang na-upload na file ay hindi wasto {$PROD_NAME} na pakete ng skin.",
    'skin_mng_err__rpm_upgrade_other' => 'Hindi mai-install ang skin: hindi wastong format ng skin.',
    'skin_mng_err__no_a_skin' => "Ang na-upload na file ay hindi wasto {$PROD_NAME} na pakete ng skin.",
    'skin_upload__title' => 'Gawin ang Pag-upload ng Bagong Skin',
    'skin_upload__already_exists' => "Ang skin '%1' ay umiiral.",
    'skin_upload__unable_to_apply' => "Ang ginawang pag-upload ng file ay hindi naglalaman ng Plesk skin, o ang pormat ng archive ay hindi suportado.",
    'skin_upload__unable_to_rename__' => "Hindi mapalitan ang pangalan ng skin %2 hanggang %1: %3.",
    'skin_upload__file_name' => 'Path papunta sa skin ng pakete ng file',
    'skins_list__title' => 'Skins Repository',
    'skins_remove__title' => 'Pag-alis ng Skin',
    'skins_remove__select_skins_for_remove' => 'Piliin ang mga skin na aalisin',

    'spf__unable_update' => 'Hindi magawa ang pag-update ng mga parameter ng SPF',
    'statistics__active_domains' => "Aktibong mga domain",
    'statistics__clients' => "Mga kustomer",
    'statistics__subdomains' => "Mga subdomain",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Mga database",
    'statistics__db_users' => "Mga user ng database",
    'statistics__dirs' => "Protektadong mga direktoryo",
    'statistics__dom_active' => "Aktibo",
    'statistics__dom_passive' => "Passive",
    'statistics__dom_problem' => "Problema",
    'statistics__domains' => "Mga domain",
    'statistics__domains_with_host' => "Mga domain na mayroong hosting",
    'statistics__doms' => "Mga domain",
    'statistics__filesystem' => "File system",
    'statistics__general' => "Pangkalahatan",
    'statistics__hdd_available' => "Nagagamit",
    'statistics__hdd_capacity' => "Kapasidad",
    'statistics__hdd_total' => "Kabuuan",
    'statistics__hdd_usage' => "Paggamit ng Hard Disk",
    'statistics__hdd_used' => "Ginamit",
    'statistics__ip' => "IP address",
    'statistics__key_number' => "Numero ng key",
    'statistics__l1' => "Huling 1 minuto",
    'statistics__l15' => "Huling 15 minuto",
    'statistics__l5' => "Huling 5 minuto",
    'statistics__la' => "Paggamit CPU",
    'statistics__mail_autoresponders' => "Mga Auto-reply",
    'statistics__mail_boxes' => "Mga mailbox",
    'statistics__mail_groups' => "Mga grupo ng mail",
    'statistics__mail_lists' => "Listahan ng mailing",
    'statistics__mail_redirects' => "Mga mail forwarder",
    'statistics__mem' => "Paggamit ng Memory",
    'statistics__mem_usage' => "Paggamit",
    'statistics__memory_available' => "Nagagamit",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Cached",
    'statistics__memory_free' => "Walang-bayad",
    'statistics__memory_shared' => "Naibahagi",
    'statistics__memory_total' => "Kabuuan",
    'statistics__memory_used' => "Ginamit",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Mga kustomer na mayroong problema",
    'statistics__problem_domains' => "Mga domain na mayroong problema",
    'statistics__swap' => "Paggamit ng Swap",
    'statistics__swap_free' => "Walang-bayad",
    'statistics__swap_total' => "Kabuuan",
    'statistics__swap_usage' => "Paggamit",
    'statistics__swap_used' => "Ginamit",
    'statistics__system_stat' => "Impormasyon ng Server",
    'statistics__unable_define_active_doms' => "Hindi malaman ang bilang ng aktibong mga domain: %1",
    'statistics__unable_define_inactive_doms' => "Hindi malaman ang bilang ng hindi aktibong mga domain: %1",
    'statistics__failed_define_swap_usage' => 'Nabigong tukuyin ang Swap Usage',
    'statistics__failed_define_load_averages' => 'Nabigong tukuyin ang Load Averages',
    'statistics__up_time' => "System Uptime:",
    'statistics__ver' => "Bersyon",
    'statistics__web_users' => "Mga user ng Web",
    'statistics__mem_win' => "Paggamit sa Pisikal na Memory",
    'statistics__memory_total_win' => "Kabuuan",
    'statistics__memory_used_win' => "Ginamit",
    'statistics__memory_free_win' => "Nagagamit",
    'statistics__swap_win' => "Paggamit sa Virtual na Memory",
    'statistics__swap_total_win' => "Kabuuan",
    'statistics__swap_used_win' => "Ginamit",
    'statistics__swap_free_win' => "Nagagamit",
    'status__domain_has_reasons_to_be_off' => "Ang domain ay suspendido pa rin para sa mga sumusunod na dahilan: %1",
    'subdomain__create__' => "Lumikha ng subdomain sa domain %1",
    'subdomain__edit__' => "Pangasiwaan ang subdomain %1",
    'subdomain__invalid_name' => "Hindi wastong subdomain name: gumamit lamang ng alphanumeric at patlang na mga simbolo.",
    'subdomain__incorrect_name' => "Hindi wastong subdomain name.",
    'subdomains__maillists_enabled_in_domain' => "Maling pangalan ng listahan ng subdomain.%1: ang domain name na ito ay ginagamit ng mga mailing list sa ilalim ng domain %1.",
    'subdomains__dalias_exists' => 'Mayroong nang umiiral domain alias na may nasabing pangalan.',
    'subdomains__name_exists' => "Ang subdomain na may ganyang pangalan ay umiiral.",
    'subdomains__regular_domain_exists' => "Ang domain na may parehong pangalan ay umiiral.",
    'subdomains__domain_alias_exists' => 'Mayroong nang umiiral domain alias na may nasabing pangalan.',
    'subdomains__remove_subdomains_on_domain' => "Ang sumusunod na mga subdomain para sa domain %1 ay maaalis:",
    'subdomains__select_subdomains_for_remove' => "Piliin ang mga subdomain na aalisin.",
    'subdomains__webmail_enabled_in_domain' => "Maling subdomain name webmail.%1: itong domain name ay ginamit para sa pag-access sa webmail sa ilalim ng domain %1.",
    'subdomains__dns_record_already_exists' => 'Hindi makalikha ng subdomain %1 dahil mayroon ng DNS record na nagtuturo sa host %1.',
    'subdomains__www_prefix_in_domain' => "Maling subdomain name www.%1: ang domain %1 ay mayroon ng WWW na unlapi.",
    'subdomains__user_type_quota_exceeds' => 'Hindi mapalitan ang account ng user dahil maari itong mag-resulta sa pag-sobra sa inilaan na disk space.',
    'subdomains__creation_in_dns_slave' => "Nagsisilbi ang name server ng Plesk bilang pangalawang name server para sa domain na ito. Para maresolba nang maayos ang iyong subdomain, siguraduhing nilalaman ng zone file sa pangunahing DNS server ang record na %1.",
    'sys_user__attributes_not_changed' => "\nAng sumusunod na katangian ng user ng system ay hindi napalitan: %1",
    'sys_user__no_access_without_password' => "Ikaw ay hindi nag-set ng password. Ang user ng system ay lilikhain, ngunit hindi pwedeng mag-log in sa system, hanggang siya ay (he/she) ay mabigyan ng password. Nais mo bang magpatuloy?",
    'sys_user__no_hard_quota' => "hindi suportado",
    'sysuser__zero_quota_is_unlimited' => "0 para sa walang hanggan",
    'template__num_excl_ips' => "Ilaan ang itinalagang mga IP address sa kustomer",
    'template__sel_sh_ips' => "Napiling mga shared IP address",
    'template__av_sh_ips' => "Magagamit na mga shared IP address",
    'template__up_to_excl_ip' => "Hanggang sa %1 mga IP address",
    'templates__all_clients' => "lahat ng mga kustomer",
    'templates__cl_domain_templates' => "Mga template para sa %1",
    'templates__cl_templates' => "Mga template ng kustomer",
    'time__invalid_ip' => "Hindi wastong IP address o domain name.",
    '__please_select_country' => 'Piliin ng iyong bansa',
    'time__unable_set_time' => "Hindi ma-set ang oras ng system: %1",
    'time__sinchronization_setup_error' => 'Hindi ma-set up ang pag-synchronize ng oras: pumalya ang timemng: %1',
    'time__sinchronization_disable_error' => 'Hindi ma-disable ang pag-synchronize ng oras: pumalya ang timemng: %1',
    'tmpl__create' => "Lumikha ng Template",
    'tmpl__edit__' => 'Template %1',
    'tmpl__logrotation_warn' => "Log rotation sa domain na nilikha nitong template ay magaganap lamang sakaling may kasunod na paglikha ng pisikal na hosting account para dito.",
    'tmpl__name' => "Pangalan ng template",
    'tmpl__dom_exist' => "Ang template ng domain na mayroong pangalan ay umiiral sa mga template pool ng administrador o kustomer.",
    'tmpl__name_invalid' => "Pangalan ng template ay hindi wasto o walang laman.",
    'tmpl__use_next_ip_addr' => "Sunod na bakanteng IP address ay gagamitin",
    'tmpl_name_already_exists' => "Ang template na mayroong pangalan '%1' ay umiiral.",

    'vh_based__no_free_ip_for_vh' => "Walang bakanteng mga IP address para sa batay sa IP na virtual na hosting. Magdagdag ng isang IP address.",

    'wu__at_domains_text' => "Pahintulutan ang webuser@%1 sa pag-access ng format",
    'wu__unable_create' => "Hindi makalikha ng web user: %1",
    'wu_edit__disk_quota' => "Disk quota",
    'wu_edit__invalid_pass' => "Ang password ay hindi wasto.",
    'wu_edit__invalid_quota' => "Ang natukoy na disk space quota ay hindi wasto. Maglagay ng positive integer.",
    'wu_edit__invalid_quota_value' => "Ang natukoy na disk space quota ay mas mababa sa kasalukuyang nagamit (%1MB). Ang ibang mga functionality ay magiging hindi-magagamit. Sigurado ka ba na nais mo magpatuloy?",
    'wu_edit__not_create_pass' => "Ang action na ito ay hindi makakalikha ng password para sa bagong web user.\nKung walang password ang user ay hindi makakapag-log in.",
    'wu_edit__unable_update' => "Hindi magawa ang pag-update ng katangian ng web user: %1",

    'dns__tabs_general' => 'Mga settings ng zone',
    'dns__tabs_zone_settings' => 'Mga tala ng SOA',
    'soa__seconds' => 'mga segundo',
    'soa__minutes' => 'mga minuto',
    'soa__hours' => 'mga oras',
    'soa__days' => 'mga araw',

    'DomainSubdirectory' => 'Destinasyon ng Subdirectory',

    'filemanager__select_codepage' => 'Pumili ng Codepage:',

    'bt_server_app_add' => 'Magdagdag ng Server Application',
    'packages_list' => 'Mga Application ng Server',

    'bt_packages_management' => 'Pangasiwaan ng mga Pakete',
    'pb__packages_management' => 'Pangasiwaan ng application',
    'bt_package_new' => 'Magdagdag ng Aplikasyon',
    '__packages' => 'Mga Application ng Server',

    'dom_ctrl__mysql_dbase_space' => 'Kabuuang quota ng MariaDB/MySQL database',
    'dom_ctrl__mssql_dbase_space' => 'Kabuuang quota ng MS SQL database',

    'dns_add__enter_ixfr_path' => 'Ilagay ang IXFR Path',

    'cmd_dns__txt_dns_record_already_exist' => 'Umiiral na tala ng SPF TXT. Maaaring magkaroon lamang ng isang tala na SPF. Upang magdagdag ng tala, tanggalin ang mga nauna sa umiiral.',

    'component_name__network' => 'network',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'I-set ang Skin',
    'bt_set_skin' => 'I-set ang Skin',
    'firewall__rule_already_exists' => 'Ang Alituntunin na mayroong pangalan na "%1" ay umiiral',
    'firewall__rule_readonly' => 'Readonly ang panuntunang "%1"',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Proteksyon ng antivirus',
    'antivirus__antivirus_direction_off' => 'Inilipat sa off',
    'antivirus__antivirus_direction_any' => 'Parating at palabas na mail',
    'antivirus__antivirus_direction_from' => 'Palabas na mail lamang',
    'antivirus__antivirus_direction_to' => 'Parating na mail lamang',
    'antivirus__unable_to_update_settings' => 'Hindi mapalitan ang mga setting ng antivirus: %1',




    '__normal' => 'Karaniwan',
    '__low' => 'Mababa',
    '__high' => 'Mataas',

    'mail__antivirus' => "Antivus ng internal mailservers",
    'mail__use_internal_antivirus' => 'Gumamit ng internal antivirus',

    'sa__tabs_blacklist' => 'Black list',

    '__mysql_databases' => 'MariaDB/MySQL database',

    'cl_perm__mysql_dbase_space' => 'Kabuuang quota ng MariaDB/MySQL database',
    'cl_perm__mssql_dbase_space' => 'Kabuuang quota ng MS SQL database',
    'cl_perm__max_mssql_db' => 'Pinakamataas ng bilang ng mga Microsoft SQL Server database',
    'cl_perm__total_mboxes_quota' => 'Kabuuang mga mailbox quota',

    'i_i_cl_on' => 'Ang account ng kustomer ay aktibo.',
    'i_i_cl_off_by_admin' => 'Ang account ng kustomer ay ginawang suspendido ng administrador.',

    'sa_exists_tn' => 'Ang network ay nasa listahan.',

    'defaultcomponents__not_activated' => 'hindi aktibo',

    'bt_traffic_at_domains' => 'Trapiko',

    '__awstats_perl_warning' => 'Kung walang Perl na naka-install, hindi pahihintulutan ng AWStats ang mga user na repasuhin ang mga estatistika sa nakaraang mga taon.',

    'class_client__mysql_dbase_space' => 'Lampas ang value sa limitasyon ng customer.',
    'class_client__mssql_dbase_space' => 'Lampas ang value sa limitasyon ng customer.',
    'class_client__max_mssql_db' => 'Lampas ang value sa limitasyon ng customer.',

    'dns__remove_transfer_restrictions_list_items' => 'Ang mga sumusunod na mga network ay maaalis mula sa lisathan ng kontrol sa pag-access:',

    'bt_up' => "Itaas",
    'bt_down' => "Ibaba",

    'bt_install_selected' => 'I-install ang mga Napiling License Key', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Ang domain ay nareresolba sa ibang IP address: (%1). Itama ang mga setting ng DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Ang kasalukuyang ginagamit na mail server ay hindi sumusuporta sa parehong mailbox at mga mail group na sabayang binuhay. Pindutin ang OK upang buhayin ang mailbox kapalit ng pagpatay ng mga mail group. Pindutin ang Kanselahin upang pabayaan ang lahat ng bagay na kasama.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Ang kasalukuyang ginagamit na mail server ay hindi sumusuporta sa parehong mailbox at mga mail group na sabayang binuhay. Pindutin ang OK upang buhayin ang mailbox kapalit ng pagpatay ng mailbox. Pindutin ang Kanselahin upang pabayaan ang lahat ng bagay na kasama.',

    'mysql_dbase_space_limit' => 'Limitasyon ng espasyo ng MariaDB/MySQL database',
    'mysql_dbase_usage' => 'Paggamit ng espasyo ng MariaDB/MySQL database',
    'mssql_dbase_space_limit' => 'Limitasyon ng espasyo ng Microsoft SQL Server database',
    'mssql_dbase_usage' => 'Paggamit ng espasyo ng Microsoft SQL Server database',

    '__statistics' => "mga estatistika", //indirect

    'dns__soa_minimum_value_is_big' => 'Pag takda ng Pinakamababang marka ng TTL na lampas 3 oras ay maaring gawin na hindi ma-access ang iyong mga domain para sa ibang mga administrador ng domain. Ito ay iminumungkahi na itakda lamang sa nasabing marka kapag ang registrar ng iyong domain names ay ipinilit ito.',

    'virusfilter__interface_not_available' => 'Walang mga virus filter na makukuha.',
    'virusfilter__none_virus_filter' => 'Wala',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'pinatay',
    'virusfilter__status_any' => 'papasok at papalabas na mail',
    'virusfilter__status_outgoing' => 'papalabas na mail lamang',
    'virusfilter__status_incoming' => 'papasok na mail lamang',

    'visibility__root_override_parse_error' => 'Mayroong syntax error sa file %1 sa linya %2.',

    'sb__not_support_publishing_api' => "Ang pag lathala ng automation ay hindi suportado ng component",

    'component_name__cphosting' => "Plesk Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Ang pag-set up ng mga mail box quota ay hindi suportado ng kasalukuyang mail server.',
    '__unable_get_total_mboxes_quota' => 'Ang pag-set up ng mga mail box quota ay hindi suportado ng kasalukuyang mail server.',

    'install_prefix__parent_not_exists' => "Ang direktoryo ng Parent ay hindi umiiral.",

    'bt_change_version' => 'Baguhin ang Bersyon',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Piliin Lahat",
    '__uncheck_all' => "Linisin Lahat",

    'dns__editing_domain_controller_zone' => "Ang pag-edit ng mga DNS zone record para sa domain controller ay maaring maging dahilan ng mga problema sa pagganap ng domain",

    'pb__interface_management' => "Pangasiwaan ng Interface",
    'interface_management__tabs_skins' => "Mga Balat",
    'interface_management__tabs_interface_templates' => "Mga Template ng Interface",
    'interface_management__tabs_locales' => "Mga Locale",
    'locales_list__title' => "Language packs repository",
    'locales_list__legend' => "Mga makukuhang wika",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Language pack",
    'locales_list__lang_title' => "Wika",
    'locales_list__country_title' => "Bansa",
    'locales_list__used_title' => "Ginamit",

    'backup__suspend_warning_during_backup' => "Ang domain ay hindi magagamit habang isinasagawa ang proseso ng backup",
    'backup__suspend_warning_during_restore' => "Ang domain ay hindi magagamit habang isinasagawa ang proseso ng pagbalik",
    'backup__suspend_domain' => "Suspindihin ang domain",

    'locales_list__mls_limit' => "Ang iyong kasalukuyang Plesk license ay nagpapahintulot sa paggamit %2 ng mga wika. Sa kasalukuyan, ikaw ay mayroong %1 mga wika na naitakda bilang magagamit ng mga user, na sumobra sa bilang ng ibinigay kasama ang lisensya. Pumili %2 ng mga wika na nais mong gamitin, at gawin ang mga natira na hindi magagamit ng mga user sa pamamagitan ng pag-klik ng kanilang mga icon sa 'S' na hanay.",

    'bt_change_owner' => 'Magtakda ng bagong may-ari',
    'chown__limit_name' => 'Pangalan ng resource',
    'chown__error_limits' => "Hindi maipagpatuloy ang pag-transfer ng suskrisyon: ang suskrisyon na ito ay nangangailangan ng mas maraming resources kaysa sa inilaan ng provider ng bagong may-ari.",
    'chown__error_empty_ip_pool' => "Hindi makapag patuloy sa pag-transfer ng suskrisyon: Ang IP pool ng bagong provider ng may-ari ay walang laman. Paki-sigurado na ang provider ay mayroong kahit isang IP address sa pool.",

    'backup__backup_time' => 'Oras ng pag-backup',
    'backup__backup_time_hour' => 'mga oras',
    'backup__backup_time_minute' => 'mga minuto',
    'backup__every' => 'tuwing',
    'backup__day_of_month' => 'araw ng buwan',

    'subdomain__select_hst_type' => 'Pumili ng uri ng hosting para sa subdomain',
    'hst_sel__subdom_subfolder_hst' => 'Subdomain sa subfolder',
    'subdomain__www_root_folder_not_exists' => 'Site home directory %1 ay hindi umiiral',
    '__site_home_dir' => 'Site home directory',
    'subdomain__aspnet_disabled_domain' => 'pinatay ng domain',

    'domains__remove_description' => 'Made-delete ang lahat ng data ng domain, kasama ang content at mga setting ng domain at mga kaukulang subdomain, data ng mga web application, content ng mailbox, mail, antivirus at setting ng pagfi-filter ng spam, log file, data sa repository ng backup na domain at SSL/TLS certificate. Kung wala kang backup file sa iyong lokal na machine, permanenteng mawawala ang lahat ng data.',
    'subdomains__remove_description' => 'Lahat ng subdomain data, kasama ang nilalaman ng subdomain at mga setting, web applications data at mga log file ay mabubura. Kung ikaw ay walang backup file sa iyong lokal na makina, lahat ng data ay permanenteng mawawala.',

    'mail__tabs_spam_filtering' => 'Pag-filter sa Spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Gumamit ng mga setting na default ng server-wide (Gawin ang pag-scan)',
    'antivirus__use_server_settings_no_scan' => 'Gumamit ng mga setting na default ng server-wide (huwag mag-scan)',
    'antivirus__check_for_viruses' => 'I-scan para sa mga viruses',
    'antivirus__dont_check_for_viruses' => 'Huwag mag-scan para sa viruses',
    'antivirus__incoming_mail' => 'Parating na mail',
    'antivirus__outgoing_mail' => 'Palabas na mail',

    'domain_alias__CNAME_dns_record_exists' => 'Ang DNS record CNAME na may ganyang pangalan ay umiiral',
    'domain_alias__A_dns_record_exists' => 'Ang DNS record A na may ganyang pangalan ay umiiral',
    'domain_alias__bad_prefix' => 'Maling prefix para sa domain alias',
    'domain_alias__domain_doesnt_exist' => "Ang domain ay hindi umiiral",

    'dns__zone_ttl_message_info' => 'Kung ang value ng TTL ay hindi natukoy, ang value ng TTL sa SOA Record Template (% 1) ay gagamitin para sa DNS record na ito.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Ang file na pinangalanan ng index.html ay lilikhain para sa muling pag-direkta sa napiling web application. Kung ang file na pinangalanan ng index.html ay umiiral, ito ay gagawan ng back up bilang index.html.old at papalitan ng isang bago. Pindutin ang OK upang kumpirmahin",

    'bt_ftp_ctrl' => "Karagdagang mga FTP Account",
    'ftp_users_no_permission' => "Ikaw ay walang pahintulot para pangasiwaan ang mga account ng FTP para sa domain na ito",
    'ftp_users_limit_reached' => "Ang limitasyon ng mga account ng FTP ay naabot para sa domain na ito",
    'pb__ftp_ctrl' => "Pangasiwaan ng FTP",
    'class_client__max_subftp_users' => "Karagdagang mga FTP account",

    '__client_form_settings' => "Mga setting ng kustomer",
    '__sbnet_client_keep_sbnet' => "Panatiliin ang kaukulang account ng user sa Presence Builder",
    '__sbnet_cant_add_more_sites' => "Ang limitasyon ng dami ng mga site na maaring gumamit ng Presence Builder ay naabot para sa kustomer na ito",
    '__sbnet_legend_text' => "Pagsasama-sama ng Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Lumikha ng akmang account ng user sa Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Sinusubukan mong alisin ang account ng user ng Presence Builder kasama ang kustomer na ito. Buburahin nito lahat ng mga website ng user at lahat ng ibang kaugnay na mga setting mula sa Presence Builder system, aalisin ang abilidad upang makapag-edit ng umiiral na mga website sa pamamagitan ng Presence Builder, kahit na iyong buksan ulit ang opsyon na ito mamaya. Kapag ikaw ay lumikha ulit ng account ng user ng Presence Builder mamaya, kailangan mong lumikha at ihayag ang lahat ng iyong mga website mula sa scratch. Nais mo bang patayin ang iyong website creation at publishing sa pamamagitan ng Presence Builder?",
    'sb__build_site_with_subdomains' => "Lumikha ng Blog at mga Photo Gallery subdomain",
    '__sbnet_client_dont_have_sbuser' => "Hindi maaring makalikha at maghayag ng site gamit ang Presence Builder: Ang Presence Builder User ay hindi umiiral",

    '__component_disabled' => "Ang component ay nakapatay",

    'subdomains__physical_path_not_exist' => "Mayroong mga subdomain na naka-link sa hindi umiral na pisikal na mga folder",

    'dnsserver_bind_to_msdns_switching_warning' => "Babala: Tanging sa unang 254 IP address ng subnets na mayroong /8 at /16 masks na nakalagay sa Listahan ng Kontrol sa Pag-Access lamang ang maaaring magawaan ng pag-transfer. Ang mga ito ay magagawa ang pag-transfer bilang magkaibang mga IP address. Nais mo bang magpatuloy?",

    '__sbnet_net_framework_required_for_site' => "Ang site ng Presence Builder ay maaring mangailangan ng suporta ng ASP.NET 2.0 sa iyong domain. Aming iminumungkahi na paganahin ang suporta ng ASP.NET 2.0 kung ikaw ay gumagamit ng Presence Builder.",

    'subdomain_auto_create_dir' => "Lumikha ng pisikal na direktoryo para sa subdomain",

    'sa_trainer__unable_to_get_messages_list' => "Hindi makuha ang listahan ng mga mensahe sa mailbox: %1",
    'sa_trainer__pass_doesnt_exist' => "Ang password para sa mail account na ito ay nawawala",

    '__sitebuilder_error' => "Ang error ay nangyari habang sinusubukang kumunekta sa Presence Builder. Kontakin ang iyong service provider para sa suporta ng tulong.",
    'wsb_error_user_not_exist' => "Ang Presence Builder na account ng user na ito ay hindi umiiral.",
    'wsb_error_site_already_exist' => "Ang site na ito ay umiiral sa Presence Builder.",
    'wsb_error_site_limit_reached' => "Ang limitasyon sa bilang ng Presence Builder site ay naabot.",
    'wsb_error_internal_error' => "Error na nangyari sa Internal Presence Builder. Kontakin ang iyong service provider para sa suporta ng tulong.",
    'wsb_error_user_already_exist' => "Presence Builder user na may parehong pangalan ay umiiral sa Presence Builder.",
    'sb_error_user_not_exist' => "Ang user ng Presence Builder ay hindi umiiral.",
    'wsb_error_object_not_found' => "Ang Presence Builder ay hindi mahanap ang tamang host entry.",

    'mg_no_mail_groups' => "Walang mga mail group",

    'drweb__drweb_incoming' => 'Pag-check ng antivirus para sa parating na mail',
    'drweb__drweb_outgoing' => 'Pag-check ng antivirus para sa palabas na mail',
    'drweb__disable_reason_serv' => 'Ang mail server ay hindi naka-suporta sa mga setting ng filter ng antivirus sa lebel ng mailbox',

    'vz_sitebuilder3_client_cant_be_created' => "Hindi maaring makalikha ng account ng kustomer: SiteBuilder version 3.1 o mas bago ay hindi naka-install",

    // new limits

    'class_client__max_odbc' => "Mga koneksyon ng ODBC",
    'cl_perm__max_odbc' => "pinakamataas na bilang ng mga koneksyon ng ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Pangalan ng domain alias',
    'domain_alias__list_ascii_name' => 'Sa pormat ng ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Pangasiwaan ng Interface',
    'pb__interface_templates' => 'Pangasiwaan sa interface',
    'pb__interface_clients' => 'Ang mga kustomer ay gumagamit ng %1',

    // service management
    'bt_service_showall' => "Ipakita Lahat",
    'bt_service_hideall' => "Itago Lahat",
    'bt_service_start' => "Simula",
    'bt_service_stop' => "Ihinto",
    'bt_service_restart' => "I-restart",
    'bt_service_disable' => "Patayin",
    'bt_service_manual' => "Manwal",
    'bt_service_auto' => "Awtomatiko",
    'service_startup_auto' => 'Awtomatiko',
    'service_startup_manual' => 'Manwal',
    'service_startup_disabled' => 'Pinatay',
    'service_action_ok' => "Ang operasyon ng %1 serbisyo ay matagumpay na nakumpleto",
    'service_action_failed_disabled_service' => "Hindi makumpleto ang operasyon ng %1 serbisyo dahil ito ay nakapatay",
    'service_action_failed_error' => "Hindi makumpleto ang operasyon: %1",
    'service_group_action_ok' => "Ang operasyon ng sumusunod na serbisyo ay matagumpay na nakumpleto \n %1",
    'service_group_action_disabled' => "Hindi makumpleto ang operasyon ng sumusunod na mga serbisyo dahil ang mga ito ay nakapatay: \n %1",
    'service_group_action_failed' => "Hindi makumpleto ang operasyon ng sumusunod na mga serbisyo: \n %1. \n Upang makatanggap ng detalyadong impormasyon na error, ganapin ang operasyon ng bawat serbisyo ng magkahiwalay",

    // php 4vs5
    'bt_php' => "Mga Setting ng PHP",

    'bt_insert' => "Ipasok",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Error na nangyari sa Presence Builder. Kontakin ang iyong service provider para sa suporta ng tulong.",
    'wsb_error_sitebuilder_access_denied_error' => "Hindi magawa ang pag-access sa file: Ang Presence Builder ay walang karapatan sa pag-access para sa kailangan na file o folder. Kontakin ang iyong service provider para sa suporta ng tulong.",
    'wsb_error_sitebuilder_connection_failed' => "Hindi maka-connect sa Presence Builder dahil ang nawala ang koneksyon. Kontakin ang iyong service provider para sa suporta ng tulong.",
    'wsb_error_critical_during_operation' => "Error na nangyari sa Critical Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Error na nangyari sa lisensya ng Presence Builder:\n%1",
    'wsb_error_during_operation' => "Error na nangyari sa Presence Builder:\n%1",
    'wsb_error_license_error' => "Limitasyon ng lisensya ng Presence Builder ay natagpuan.",

    // Other
    '__confrim_service_stop' => "Babala! Kapag itinigil mo ang serbisyo %1 ang Plesk ay maaring huminto sa paggana. Sigurado ka bang nais mong ihinto ang serbisyo %1?",
    'index_redirect_help_text' => 'Ngayon ikaw ay awtomatikong muling idi-direkta sa kailangan na website. Kapag ang iyong browser ang hindi naka-suporta sa muling pag-direkta, paki-klik %1 dito %2',
    'bt_default_settings' => "Ibalik ang mga Default",
    'logfiles__remove_failed' => "Hindi mabura ang file %1: ang file ay ni-lock ng ibang application. Paki subukan muli mamaya",
    'subdomain__invalid_homedirectory' => "Natukoy na subdomain na home directory ay hindi wasto",
    'scheduler_item__empty_filename' => "Tukuyin ang executable file upang gumana",
    'subdomains__overlapped_domain_exists' => 'Ang subdomain ay napatungan ang DNS zone ng domain %1',
    'subdomains__overlapped_domain_alias_exists' => 'Ang subdomain ay napatungan ang DNS zone ng domain alias %1',
    'services_action_none_selected' => 'Hindi makumpleto ang operasyon: Pumili ng kailangang mga serbisyo',
    'cl_perm__max_subftp_users' => "pinakamataas na bilang ng karagdagang mga account ng FTP",
    'login_up__access_denied_no_cp_access' => 'Ang pag-access ay tinanggihan. Ikaw ay walang pahintulot para sa pag-access ng Plesk.',
    'drweb__disable_reason_admin' => "Ang mga setting ng filter ng antivirus sa mailbox ay hindi pinahihintulutan ng patakaran server.",

    '__use_default' => 'Gamitin ang default',

    'webalizer_hidden_referrer__already_exist' => 'Ang nasabing mga entry ay umiiral na.',
    'webalizer_group_referrer__already_exist' => 'Ang isang nagsasangguni ng pangkat na may tulad na isang pangalan ay umiiral na.',

    'pb__dashboard' => 'Home',

    'server_interface__page_title' => 'Mga Setting ng Server Interface',
    'server_interface__tabs_locales' => 'Mga Locale',
    'server_interface__tabs_skins' => 'Mga Balat',
    'server_interface__tabs_interface_templates' => 'Mga Template ng Interface',
    'bt_server_interface' => 'Mga Nais na Interface (Interface Preferences)',
    'pb__server_interface' => 'Mga Nais na Interface (Interface Preferences)',

    'bt_wizard_next' => 'Susunod >>',
    'bt_wizard_prev' => '<< Bumalik',

    '__limit_exceeded_max_dom_server' => 'Hindi ka maaring mag-host ng maraming mga domain sa server na ito dahil ang limitasyon sa bilang ng mga domain na pinahihintulutan sa server gamit ang iyong license key ay naabot. Kontakin ang iyong service provider upang maayos itong isyu.',
    '__limit_exceeded_max_subdom_server' => 'Hindi ka maaring mag host ng maraming subdomain sa server na ito. Kontakin ang iyong service provider.',
    '__limit_exceeded_max_dom_aliases_server' => 'Hindi ka maaaring mag-set up ng higit pang mga domain alias sa server na ito. Kontakin ang iyong service provider.',
    '__limit_exceeded_max_wu_server' => 'Hindi ka maaring makalikha ng mas maraming mga web user dahil ang limitasyon sa bilang ng mga web user na pinahihintulutan sa server gamit ang iyong license key ay naabot. Kontakin ang iyong service provider upang maayos itong isyu.',
    '__limit_exceeded_max_mn_server' => 'Hindi ka makakalikha ng mga mail account dahil ang limitasyon ng bilang ng mga mail account na pinahihintulutan sa server gamit ang license key ay naabot. Kontakin ang iyong service provider upang maayos itong isyu.',

    '__limit_exceeded_max_cl_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga account ng kustomer na tinukoy ng iyong license key (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga domain na tinukoy sa pamamagitan ng iyong license key (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga subdomain na tinukoy sa pamamagitan ng iyong license key (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Iyong naabot ang limitasyon ng bilang ng mga domain alias na ipinaliwanag ng iyong license key (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Wala kang natirang disk space',
    '__limit_exceeded_max_wu_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga account ng web user na tinukoy ng iyong license key (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga database na tinukoy ng iyong license key (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga mailbox na tinukoy ng iyong license key (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga email account na tinukoy sa pamamagitan ng iyong license key (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Naabot mo na ang limitasyon sa bilang ng mga mailing list na tinukoy sa pamamagitan ng iyong license key (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Naabot mo na ang limitasyon sa bilang ng mga domain (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Naabot mo na ang limitasyon sa bilang ng mga subdomain (%2) na pinahihintulutan ng iyong service provider',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Iyong naabot ang limitasyon ng bilang ng mga domain alias (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Naabot mo na ang limitasyon sa paggamit ng disk space (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Naabot mo na ang limitasyon sa halaga ng paggamit ng bandwidth sa bawat buwan (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Iyong naabot ang limitasyon ng bilang ng mga web user (%2) na pinahihintulutan ng iyong service provider.',
    '__limit_exceeded_max_db_userclient' => 'Naabot mo na ang limitasyon sa bilang ng mga database (%2)',
    '__limit_exceeded_max_box_userclient' => 'Naabot mo na ang limitasyon sa bilang ng mga mailbox (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Naabot mo na ang limitasyon sa bilang ng mga mailing list (%2)',
    '__limit_exceeded_expiration_userclient' => 'Ang iyong account ay nawalan ng bisa noong %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Naabot mo na ang limitasyon sa bilang ng mga subdomain (%2) na pinahihintulutan ng iyong service provider',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Iyong naabot ang limitasyon ng bilang ng mga domain alias (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Naabot mo na ang limitasyon sa paggamit ng disk space (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Naabot mo na ang limitasyon sa halaga ng ginamit ng bandwidth sa bawat buwan (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Naabot mo na ang limitasyon sa bilang ng mga account ng web user (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Naabot mo na ang limitasyon sa bilang ng mga database (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Naabot mo na ang limitasyon sa bilang ng mga mailbox (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Naabot mo na ang limitasyon sa bilang ng mga mailing list (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Ang iyong account ay nawalan ng bisa noong %2',

    'sapp_error_validation_not_found' => 'Hindi mabigyang-bisa ang web application dahil ang isa sa kailangan na mga file (%1) ay hindi nahanap. Kontakin ang iyong kinatawan ng teknikal na suporta para sa tulong.',
    'sapp_error_validation_spec_failed' => 'Ang ginawang pag-upload sa web application ay hindi sumunod sa espisipikasyon ng AppPacks: %1.',
    'sapp_error_validation_register' => 'Hindi magawa ang pagpaparehistro ng web application na nakalagay sa direktoryo "%1": %2 Dapat mong alisin ang web application mula sa server dahil ito ay hindi magpapagana nang maayos.',

    'sapp__install_failed' => 'Ang pag-install ng web application ay nabigo: %1',
    'sapp__install_res_failed' => 'Nabigo sa paglikha ng hininging resource.',

    'server_preferences__subdomains_blog_and_photo' => 'Lumikha ng Blog at Photo Gallery subdomain sa default',
    'plesk_key__blog_and_photo' => 'Abilidad upang mangasiwa ng default na estado ng check box ng Create Blog at mga subdomain ng Photo Gallery',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Hindi mapalitan ang uri ng IP address sa nakatalaga dahil ito ay nakatakda sa higit sa isang user.',

    // 8.1.1

    '__write_modify_warning' => 'Ang pagpili ng karagdagang write/modify na mga pahintulot ay gagawain ang ibang mga web application na gumana ng tama, pero ito ay magdadagdag panganib sa seguridad',
    '__write_modify_subdomain_warning' => 'Ang pagpili ng karagdagang write/modify na mga pahintulot ay gagawain ang ibang mga web application na gumana ng tama, pero ito ay magdadagdag panganib sa seguridad',

    'phosting__php_incorrect_version_used' => "Nakita ang mga problema sa bersyon ng PHP. Upang maayos ang mga problemang ito, piliin ang check box na mayroong kailangan ng bersyon ng PHP sa ibaba at i-klik ang OK. Upang patayin ang PHP sa domain na ito, i-klik ang OK na hindi pinipili ang bersyon ng PHP",
    'fp__mail_preferences' => 'Mga Setting ng Mail',

    'mail__invalid_white_pattern' => 'Invalid ang tinukoy na value. Gamitin ang mga sumusunod na format: mail@example.com para sa mga email address, example.com para sa mga domain.',
    'mail__invalid_black_pattern' => 'Ang natukoy na marka ay hindi wasto. Gamitin ang sumusunod na pormat: mail@example.com para sa mga email address, example.com para sa mga domain.',

    'resp_edit__reply_as_html' => 'Ipadala bilang HTML',
    'exception__path_very_long' => "Ang path ay masyadong mahaba. Siguraduhin na mayroong mas mababang %1 mga karakter sa path.",

    // 8.2


    //SAPP
    'sapp_on' => 'I-on',
    'sapp_off' => 'I-off',
    'sapp_directive_aspect' => 'Kailangan',
    'sapp_databases_num' => 'Mga database',
    'sapp_db_required' => 'Kailangan',
    'sapp_Required' => 'Kailangan',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'Database id',
    'sapp_db_id_type' => 'DB (id: %1) uri',
    'sapp_db_id_min_version' => 'DB (id: %1) min bersyon',
    'sapp_db_id_table_prefix' => 'DB (id: %1) unlapi ng table',
    'sapp_Default' => 'Itinakdang marka',
    'sapp_apache_mod_req' => 'Modulo na Apache',
    'sapp_dbtype_not_installed' => 'hindi naka-install',
    'sapp_apache_mod_not_installed' => 'hindi naka-install',
    'sapp_error_invalid_type' => 'Ang application na "%1" ay hindi naka-suporta sa hininging aksyon.',
    'sapp_error_unknown_app_type' => 'Hindi suportadong uri ng application: %1.',
    'sapp__ssl_text' => 'I-install ang application sa "http://" o "https://" virtual na host?',
    'sapp__app_to_upgrade' => 'Mga application na gagawan ng pag-upgrade',
    'sapp__upgrade_apps_title' => 'Pag-upgrade ng mga application',
    'sapp__upgrade_to_ver' => 'Gawin ang pag-upgrade sa bersyon',
    'sapp__choose_pkg_ver' => 'Pumili ng pakete...',
    'sapp__pkg_cant_upgrade_pkg' => 'Ang pakete "%1" ay hindi maaring magamit para sa pag-upgrade ng web application "%2".',
    'sapp__app_ugrade_error' => 'Hindi magawa ang pag-upgrade sa application: %1. Kontakin ang iyong administrador ng system.',
    'sapp__no_suitable_db_found' => 'Walang nahanap na akma na database.',
    'sapp__upgrade_success' =>  'Matagumpay ang pag-upgrade ng application.',
    'sapp__pkg_info_changelog' => 'Kasaysayan ng mga pagbabago',
    'sapp_requirement_legend' => 'Ang katangian ng hosting ay kailangan ng application',

    // other
    'bt_apply' => 'Ipatupad',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Upang makalikha ng mail alias, ang mailbox ay dapat binuhay sa mail account na ito. Buhayin ang mailbox?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Sa pagpatay ng mailbox ay maalis ang mga mail alias sapagkat sila ay hihinto sa pag trabaho. Patayin ang mailbox?',
    'antivirus__disable_reason_install' => 'Hindi ka maaring mangasiwa ng antivirus dahil hindi ito naka-install.',
    'antivirus__disable_reason_key' => 'Hindi ka maaring mangasiwa ng antivirus dahil hindi ito na-activate ng tamang license key.',
    'antivirus__disable_reason_deny_personal_settings' => 'Hindi ka maaring mangasiwa ng antivirus dahil ang patakaran ng server ay pinagbabawal ang indibidwal na mga setting ng antivirus.',
    'change_foreign_user_password' => 'Palitan ang password',
    'change_foreign_user_password_hint' => "Ang user ay hindi kabilang sa application na ito. I-klik ang link upang pumunta sa ibang application at palitan ang password ng user doon. Upang magawa ito, kailangan mong magkaroon ng appropriate rights sa application na ito.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Format ng String',
    'lang_unknown' => 'Hindi kilalang wika',
    'pb__cl_ed' => 'Mga detalye ng kustomer',
    'pb__actionlog' => 'Action log',
    'pb__cl_limits' => 'Mga limit ng kustomer',
    'pb__edit' => 'I-edit',
    'pb__subdom_edit' => 'Mga setting ng Hosting',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Gawaan ng backup ang nilalaman ng mga mailbox',

    'maillist_import_result' => "\nKabuuang dami ng mga email address sa file: %1\ndami ng imported na mga email address: %2\ndami ng umiiral na mga email address: %3\ndami ng duplikado na mga email address sa natukoy na file: %4\ndami ng hindi wastong mga email address sa file: %5",
    'maillist_import_error' => 'Hindi ma-import ang mga email address list',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Ang file na pinili mo ay alinman sa walang laman o hindi wastong HTML na dokumento sa napiling pag-encode. Mangyaring piliin ang tamang pagpasok o idagdag lamang ang nilalaman sa file.",

    'dom_pref__external_mail_srv' => "Muling idirekta sa external na mail server kasama ang IP address:",
    'mn_edit__store_messages' => 'Mailbox',

    // aps

    'sapp__before_upgrade_notice' => 'Ito ay iminumungkahi na gawan ng back up ang application at user data bago simulan ang proseso ng pag-upgrade.',
    'sapp__application_properties' => 'Mga katangian ng application',
    'sapp__application_root_descr' => 'Ang pangunahing pahina ng application',

    'sapp__aps_license_invalid_id' => 'Ang license key ay mayroong hindi wastong ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Ang license key na mayroong numero na %1 ay umiiral sa database.',
    'sapp__aps_lic_del_used' => 'Hindi mabura ang license key, ito ay ginagamit ng isa sa mga naka-install na mga application.',
    'sapp__aps_lic_del_unknown' => 'Hindi mabura ang license key: %1',
    'sapp__aps_cappi_duplicate' => "Ang application na ito ay nasa application pool ng kustomer",
    'sapp__appi_not_shared_no_install' => "Walang ganyan na application sa application pool ng kustomer. Kung nais mong mag-install ng application na ito sa site, kailangan mo munang idagdag ang application na ito sa application pool ng kustomer.",
    'sapp__appi_shared_not_client' => "Walang ganyan na application sa application pool ng kustomer. Kung nais mong gumawa ng pag-upgrade ng application sa natukoy na bersyon, kailangan mo munang idagdag ang bersyon ng application na ito sa application pool ng kustomer.",
    'sapp__apply_license_script_not_found' => 'Hindi mahanap ang "apply-license" script para sa web application na ito.',
    'sapp__unable_to_activate_key' => 'Ang error ay nangyayari habang isinasagawa ang pagsubok na gawing aktibo ang license key: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Mayroong mga naka-install na web applications sa kailangan ng presensya nitong web application na ito sa system.',
    'sapp__unable_to_delete_ai_in_pool' => 'Ang application na ito ay kasalukuyang nasa pool ng kustomer. Kapag inalis mo itong application na ito, kailangan mo munang alisin ito sa lahat ng mga application pool ng kustomer o gawin itong libre sa paniningil.',
    'sapp__unable_to_delete_app_template' => 'Hindi maalis ang application #%1: %2',
    'sapp__limit_exceeded_client' => 'Iyong naabot ang limitasyon sa bilang ng beses na maari kang mag-install nitong web application (%2).',


    // atis module

    '_week_on' => 'linggo sa',
    '__week_first' => 'una',
    '__week_second' => 'pangalawa',
    '__week_third' => 'pangatlo',
    '__week_fourth' => 'pag-apat',
    '__week_last' => 'huli',
    '__not_started' => 'Naghihintay',
    '__started' => 'Tumatakbo',
    '__cancel_pending' => 'Pag-kansel',
    '__canceled' => 'Nakansela',
    '__error' => 'Error',
    '__done' => 'Tapos na',

    '__php_cgi_handler' => 'CGI application',
    '__php_isapi_handler' => 'Extensyon sa ISAPI',
    '__php_fastcgi_handler' => 'FastCGI application',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'patakbuhin bilang',

    'cf_dbfolder_text' => 'Folder ng Database',
    'cf_isnewdb_text' => 'Lumikha ng Database',
    'cf_isnewdb_title' => 'Piliin ang check box kapag ang database ay lilikhain',

    'pb__site_apps_upgrade' => 'Pag-upgrade ng web application',

    'detach' => 'I-diskonekta',
    'preferences' => "Baguhin ang Password",

    'toolsbar__switch_user?' => "Sigurado ka bang nais mong mag-log in sa ibang account ng user?",
    '__aps_left' => 'Natirang mga pag-install',
    'aps__license_key' => 'Lisensya ng susi',
    'aps__download_code' => 'Pag-download ng license key at pag-activate ng code',
    'aps__license_key_hint' => 'Bumalik mula sa licensing server gamit ang activation code',
    'aps__database_not_available' => 'hindi magagamit, i-check ang domain o mga limitasyon ng kustomer',
    'aps__yes' => 'oo',
    'aps__no' => 'hindi',
    '__click_to_enlarge' => 'I-klik upang mapalaki',
    'site_apps__back_to_list' => 'Bumalik sa listahan',
    'sapp__pkg_info_installation_requirements' => 'Mga kailangan sa pag-install',
    '__close_window' => 'Isara',

    //SAPP END

    'skin_info__already_default' => 'Ang skin ay naitakda na bilang isang default.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus Settings para %1',
    'drweb:properties_legend' => 'Mga setting',
    'drweb:status' => 'Pag-check ng mail para sa mga virus',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder Wizard',
    'dom_site_builder' => 'I-klik upang buksan ang Presence Builder Wizard.',
    'sb_plesk_admin_url' => 'Presence Builder server URL. Siguruhin na ang address na ito ay akma ng tama sa DNS',
    'sb_plesk_admin_login' => 'Username para sa login ng administrador ng server sa Presence Builder server',
    'sb_plesk_admin_password' => 'Password ng administrador',
    'sb_sitebuilder_preferences' => 'Mga kredensyal ng administrador ng Presence Builder',
    'sb__server' => 'Mga pag-nais ng administrador ng Presence Builder System',
    'sb__sitebuilder_support' => 'Suporta ng Presence Builder',
    'sb_keep_sb_user' => 'Panatiliin ang kaukulang account ng user sa Presence Builder',
    'sb_create_sb_user' => 'Lumikha ng akmang account ng user sa Presence Builder',
    'sb__build_site_using_sitebuilder' => "Lumikha ng isang website gamit ang Presence Builder",
    'sb_no_current_sb_server_set' => 'Ang koneksyon sa Presence Builder ay hindi pa na-konpigura: kailangan mong magdagdag ng A record sa DNS zone template na ituturo sa Presence Builder server.',
    'sb_unable_update_sb_server_sb_return_message' => "Hindi maibalik ang impormasyon mula sa Presence Builder system:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Hindi maka-connect sa Presence Builder: maling username o password.",
    'sb_init_sb_manager' => "Pag-initialize ng tagapangasiwa ng Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Nabigo sa pag-konekta sa Presence Builder system.",
    'sb_err_client_dont_have_sbuser' => "Ang kustomer na ito ay walang account ng user sa Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Ang Presence Builder ay hindi nakonpigura.",
    'sb_err_you_dont_have_sbaccount' => "Nabigo na kilalanin ka sa Presence Builder.",
    'sb_error_critical_during_operation' => "Ang sumusunod na error ay nangyari sa Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Ang suporta ng single sign-on ay hindi nabuksan sa Plesk.",

    'warning__super_zone_exist' => "Ang zone %1 ay nalikha, subalit, ang zone name na ito ay subzone ng ibang umiiral na zone %2, na mga kabilang sa ibang user %3. Ito ay posible, ngunit siguraduhin na pinili mo ang tamang account ng user.",
    'error__super_zone_exist' => "Hindi malikha ang DNS zone dahil ang superzone nito ay kabilang sa ibang user.",

    'locales__files_not_exits' => 'Hindi mapalitan ang locale: ang natukoy na mga interface language pack file ay hindi umiiral sa system.',
    'locales__unavailable' => 'Hindi mapalitan ang locale: ang natukoy na interface language pack ay hindi magagamit.',

    // DB BU

    'pb__dbbackup_list' => 'Backup na mga file ng database',
    // server
    'dbbackup__server_backup_settings' => 'backup',
    'dbbackup__network_temp_dir' => 'Pansamantalang direktoryo ng network',
    'dbbackup__network_user' => 'Username',
    'dbbackup__network_pass' => 'Password',
    // domain
    'dbbackup__add_database_legend' => 'Ibalik ang na-backup na database',
    'dbbackup__add_database_restore' => 'Ibalik ang database mula sa backup file',
    'dbbackup__add_database_file' => 'Backup file ng database',
    'dbbackup__add_database_user' => 'Default na username',
    'dbbackup__add_database_pass' => 'Default na password ng user',
    'dbbackup__add_database_pass2' => 'Kumpirmasyon ng default na password ng user',

    'bt_dbbackup_now' => 'Back Up',

    'bt_repair' => 'Kumpunihin',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Ang pag-upload ng mga SqL Server database dump ay ipinagbabawal ng hosting provider.',

    // APS categories

    'cf_invalid_password' => 'Ang password ay hindi maaring mas mahaba sa 16 na mga karakter',
    'cf_invalid_description_length' => 'Ang paglalarawan ay hindi maaring mas mahaba sa 256 na mga simbolo',
    'ip_addr__ip_used_by_external_mail_server' => 'Ang IP address %1 ay ginamit ng eksternal na mail server',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Ang FTP account username o password ay hindi wasto. Tukuyin ang tamang mga kredensyal ng FTP user.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Ang limitasyon sa bilang ng pagbabago ng serial number ay naabot. Wala ng mga pagbabago sa DNS zone ba maaring madala palabas sa araw na ito.',
    'dns__zone_apply_changes' => 'Ang mga pagbabago na ginawa sa mga DNS record ay hindi pa naka-save. Ang mga pagbabagong ginawa ay naka-highlight sa ibaba. I-klik ang Pag-update upang ma-aplay ang mga pagbabago sa DNS zone o i-klik ang Ibalik upang pabayaan ang mga pagbabago.',
    'dns__update_dns_zone' => 'I-klik upang i-save ang mga pagbabago na ginawa sa mga tala ng DNs',
    'dns__revert_dns_zone' => 'I-klik upang kanselahin ang mga pagbabago na ginawa sa mga tala ng DNs',
    'bt_revert' => 'I-revert',
    'dns__dns_zone_has_beed_updated' => 'Ang mga pagbabagong ginawa sa DNS record ay nai-save.',
    'dns__dns_zone_has_beed_reverted' => 'Ang mga pagbabagong ginawa sa DNS record ay kanselado',
    'db__nondefault_server_not_allowed' => 'Paggamit ng non-default database server ay hindi pinahihintulutan',

    'site_apps__non_removable' => 'Mga item na hindi maaring alisin',
    'site_apps__non_removable_items' => 'Ang sumusunod na mga web applications ay hindi maaring alisin:',

    'rpt_reseller_section_general' => 'Pangkalahatan',
    'rpt_reseller_section_domains' => 'Mga domain',
    'rpt_reseller_section_clients' => 'Mga kustomer',
    'statistics__cl_active_domains' => "Aktibong mga domain",
    'rpt_reseller_cl_domains' => "Mga domain",
    'rpt_reseller_cl_subdomains' => "Mga subdomain",
    'by__cl_domains' => "mga domain ng mga kliyente",
    'dom_ctrl__cl_mboxes' => "Mga mailbox",
    'rpt_reseller_cl_redirects' => "Mga forwarder",
    'rpt_reseller_cl_mail_groups' => "Mga grupo ng mail",
    'rpt_reseller_cl_mail_resps' => "Mga Auto-reply",
    'rpt_reseller_cl_mail_lists' => "Listahan ng mailing",
    'rpt_reseller_cl_web_users' => "Mga user ng Web",
    'rpt_reseller_cl_data_bases' => "Mga database",

    'statistics__active_clients' => 'Mga kustomer na merong aktibong suskrisyon',
    'statistics__clients_active_domains' => 'Aktibong mga domain',
    'statistics__clients_doms' => 'Mga domain',
    'statistics__cl_doms' => 'Mga domain',
    '__clients_subdomains' => 'Mga subdomain',
    '__clients_domains' => 'Mga domain',
    'dom_ctrl__clients_mboxes' => 'Mga mailbox',
    'dom_ctrl__clients_redir' => 'Mga forwarder',
    'dom_ctrl__clients_mg' => 'Mga grupo ng mail',
    'dom_ctrl__clients_resp' => 'Mga Auto-reply',
    'dom_ctrl__clients_maillists' => 'Listahan ng mailing',
    'dom_ctrl__clients_wu' => 'Mga user ng Web',
    'dom_ctrl__clients_db' => 'Mga database',

    'dom_ctrl__cl_redir' => 'Mga forwarder', // to resolve!
    'dom_ctrl__cl_mg' => 'Mga grupo ng mail', // to resolve!
    'dom_ctrl__cl_resp' => 'Mga Auto-reply', // to resolve!
    'dom_ctrl__cl_maillists' => 'Listahan ng mailing', // to resolve!
    'dom_ctrl__cl_wu' => 'Mga user ng Web', // to resolve!
    'dom_ctrl__cl_db' => 'Mga database', // to resolve!

    'rpt_cl_section_clients' => 'Mga kustomer',

    'rpt_admin_section_general' => 'Pangkalahatan',
    'rpt_admin_section_resellers' => 'Mga Reseller',
    'rpt_admin_section_clients' => 'Mga kustomer',
    'rpt_admin_section_personal_clients' => 'Sariling mga kustomer',
    'rpt_admin_section_domains' => 'Mga domain',
    'rpt_admin_section_personal_domains' => 'Personal na mga domain',

    'rpt_reseller_section_personal_domains' => 'Personal na mga domain',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Pinahintulutang labis na pagbenta",
    'limits__reseller_oversell_description' => "Ang sobrang pagbebenta ay nagbibigay pahintulot sa reseller na magbenta ng maraming mga resource kaysa sa aktwal na inilaan sa kanya. Kapag ang sobrang-pagbebenta ay pinahihintulutan, ang reseller ay pinamamahalaan ng aktwal na paggamit ng resource sa halip ng paunang paglalaan ng resource",
    'limits__overuse_block_text' => "Patakaran sa sobrang paggamit",
    'limits__overuse_block_true_text' => "Hindi pinapayagan ang sobrang paggamit",
    'limits__reseller_overuse_block_true_description' => "Harangan ang sobrang paggamit ng mga resource. Ang aktwal na paggamit ng resource ay hindi maaring sumobra sa paunang inilaan ng resource",
    'limits__overuse_block_false_text' => "Pinapayagang ang sobrang paggamit",
    'limits__reseller_overuse_block_false_description' => "Huwag harangan ang sobrang paggamit ng mga resources, pinahihintulutan ang reseller na gumamit ng mas maraming mga resource kaysa sa paunang ibinigay. Ang aktwal na paggamit ng resource ay maaring sumobra sa paunang inilaan ng resource",
    'limits__reseller_overuse_notify_text' => "Abisuhan ang reseller tungkol sa pag-abot ng mga limitasyon ng resource",
    'reseller_perm__manage_sh_access_disabled' => "Ang reseller ay hindi maaring magbigay ng pahintulot o pagbawalan ang pag-access sa shell",
    'reseller_perm__manage_sh_access_chrooted' => "Ang reseller ay maaring magbigay pahintulot sa pag-access sa chrooted environment lamang",
    'reseller_perm__manage_sh_access_any' => "Ang reseller ay maaring magbigay pahintulot sa pag-access ng kahit anong uri ng shell",
    'template__reseller_num_excl_ips' => "Ilaan ang itinalagang mga IP address sa reseller",

    // Reseller's Home page
    'domains__reseller_info' => "%1 mga kustomer, %2 mga domain, %3 ng ginamit na disk space, %4 ng data na nagawa ang pag-transfer.",
    'domains__reseller_info_hiding_traffic' => "%1 mga kustomer, %2 mga domain, %3 ng ginamit na disk space.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Lahat ng web applications ay naka-uri ayon sa mga kategorya, na ginawang mas madali sa pagpili ng tamang application nai-install.",
    'feature__domainkeys__reseller' => "Maaari mong gamitin ang DKIM email sender authentication mechanism para bawasan ang dami ng spam at mga phishing email.",

    '__reseller_form' => "Pormularyo ng reseller",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Gawin ang template na magagamit ng ibang mga user",
    'template__shared_description' => "Piliin ang opsyon na ito kung nais mo ang iyong kustomer ay pwedeng gumamit ng template na ito.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Hindi maaaring payagan o ipagbawal ng administrador ng domain ang pag-access sa shell",
    'domain_perm__manage_sh_access_chrooted' => "Ang administrador ng domain ay maaring magbigay pahintulot sa pag-access sa chrooted environment lamang",
    'domain_perm__manage_sh_access_any' => "Ang administrador ng domain ay maaring magbigay ng pahintulot sa pag-access ng kahit anong uri ng shell",

    // APS Catalog
    'bt_add_to_vault' => "Idagdag sa Vault",
    'bt_hide_updates' => "Itago ang magagamit na mga pag-updates",
    'bt_show_updates' => "Ipakita ang magagamit na mga pag-update",

    '__site_apps__applications' => "Mga application",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Mga application napili upang idagdag sa vault",
    'site_apps__application_selected' => "Napili",
    'site_apps__currently_in_vault' => "Ibang mga bersyon ay nasa vault:",
    'site_apps__new_versions' => "Bagong mga bersyon:",
    'site_apps__patches' => "Mga Patch:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Bilang ng mga application na naka-iskedyul para sa pagdagdag sa vault: %1",
    'site_apps__applications_downloading_now' => "Ang sumusunod na mga application ay nagawa na mai-download: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Kasalukuyang nasa vault",

    // Server > Action Log
    'bt_skin_edit' => "I-edit ang Paglalarawan ng Skin",
    'limits__oversell_legend' => "Sobrang pagbebenta",
    'limitsManager__limit_available_error' => "Hindi mai-laan ang kailangang dami ng mga resource (%%quantity%% %%limitName%%). Tanging %%available%% %%limitName%% ay magagamit.",
    'limitsManager__limit_reserved_error' => "Hindi mai-set ang kailangan na limitasyon ng paggamit ng resource (%%quantity%% %%limitName%%) dahil ang bagong marka ay mas mababa kaysa sa dami ng mga resource na imbak para sa iyong mga kustomer o ginamit mo sa iyong sarili (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Hindi maitakda ang kailangan na limitasyon ng paggamit ng resource (%%quantity%% %%limitName%%) dahil ang bagong marka ay mas mababa kaysa sa aktwal na dami ng mga resource na nagamit ng iyong account at mga site (%%used%% %%limitName%%).",

    'domains_list__resource__filter_title' => "Ginamit na Resource",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catalog ng APS applications",
    'site_apps__applications_have_updates' => "Ang pag-update ng sumusunod na mga application ay magagamit:\n%1\nUpang ma view ang mga pag-update, siguraduhin na ang Search area ay nakikita, piliin <b>Ipakita lamang ang mga pag-update</b> check box at search para sa mga application na iyong kailangan.",
    'site_apps__progress_adding_to_vault' => "Idinadagdag sa vault:",
    'site_apps__progress_done_message' => "Pagsulong:",
    'site_apps__progress_applications_left' => "%1 ng %2 mga application ang natira",
    'site_apps__download_item_long_task_title' => "Mag-download ng APS application (%1)",
    'site_apps__download_transaction_long_task_title' => "Mag-download ng APS application mula sa APS Catalog",
    'site_apps__last_check_for_updates' => "huling pag-check para sa pag-update: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Lahat ng naka-iskedyul na mga application ay matagumpay na nadagdag sa Application Vault",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 ang naka-iskedyul na mga application ay matagumpay na nadagdag sa Application Vault.",
    'site_apps__no_search_results' => 'Walang nahanap na mga application. Subukan ang ibang search request o browse applications ayon sa mga kategorya.',
    'site_apps__search_results_title' => 'Resulta ng paghahanap',
    '__site_apps__search_by_application' => 'Pangalan ng application',
    '__site_apps__search_by_vendor' => 'Nagtitinda',
    '__site_apps__search_by_vendor__all' => 'Lahat mga vendor',
    '__site_apps__search_by_packager' => 'Taga-pakete',
    '__site_apps__search_by_certification_level' => 'Lebel ng sertipikasyon',
    '__site_apps__search_by_cert__any' => 'Anuman',
    '__site_apps__search_by_cert__silver_and_higher' => 'Pilak at mas mataas',
    '__site_apps__search_by_cert__gold_and_higher' => 'Ginto at mas mataas',
    '__retry' => 'Subukan muli',
    'site_apps__application_packager_site' => 'Taga-pakete',
    'site_apps__add_to_pool_message' => "Ang mga application na may markang \"available para sa lahat\" ay awtomatikong ipinapamahagi sa lahat ng reseller at customer na walang limitasyon ang mga pag-install. Manu-manong ipinapamahagi ang mga pinaghihigpitang application sa lahat ng reseller at customer nang paisa-isa, nang may malinaw na nakasaad na bilang ng mga available na pag-install.",
    'site_apps__make_available_for_all' => "Gawin ang napiling mga application na magagamit ng lahat ng mga user",

    'site_apps__broadcast_app_text' => "Ang mga application na may markang \"available para sa lahat\" ay awtomatikong ipinapamahagi sa lahat ng reseller at customer na walang limitasyon ang mga pag-install. Manu-manong ipinapamahagi ang mga pinaghihigpitang application sa lahat ng reseller at customer nang paisa-isa, nang may malinaw na nakasaad na bilang ng mga available na pag-install.",
    'site_apps__broadcast_app_name' => 'Gawin ang application na magagamit ng lahat ng mga user',

    // User Application Pool per application
    'site_apps__available_clients' => 'Magagamit na mga user',
    'site_apps__no_more_clients_to_add_to_pool' => 'Wala ng mga account ng user na maari mong bigyan nitong application',

    // Installed application instances
    'site_apps__installations' => 'Mga pag-install',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domain name at IP address",
    '__assign_ip_address' => "Magtakda ng IP Address",
    '__switch_on_service' => "Buhayin ang serbisyo",
    '__hosting_configuration' => "Konpigurasyon ng hosting",
    '__vrt_hst' => "Hosting ng Website",
    '__vrt_hst_hint' => "Mag-host ng website sa server na ito.",
    '__fwd' => "Forwarding",
    '__web_hosting_settings' => "Mga setting ng Hosting",
    '__fwd_hint' => "Muling idirekta ang mga bisita sa ibang website.",
    '__none_hint' => "Huwag mag host ng website sa sandaling ito.",
    '__login_hint' => "Ang username na ito ay ginagamit para sa pag-access ng iyong website sa pamamagitan ng FTP",
    '__password_hint' => "Ang password na ito ay ginagamit para sa pag-access ng iyong website sa pamamagitan ng FTP",
    '__advanced_hosting_setup' => "Konpigurahin ang mga setting ng makabagong website hosting",
    '__domain_creation_successful' => "Ang domain ay nalikha.",
    'bt_hosting_settings' => "Mga Setting ng Pagho-host",
    '__change_hosting_type' => "Palitan ang hosting type para sa domain %1",
    '__hosting_type_change_warning' => "Kapag iyong pinalitan ang hosting type a forwarding o no hosting, lahat ng mga file at mga direktoryo na kaugnay sa iyong site ay naalis mula sa server. Siguraduhin na mag-save ng lokal na kopya ng iyong site.",
    '__current_hosting_type' => "Kasalukuyang hosting type",
    '__new_hosting_type' => "Bagong uri ng hosting",
    '__fwd_settings' => "Mga setting ng forwarding",
    '__fwd_settings_legend' => "Mga setting ng forwarding",
    '__fwd_destination_url' => "Destination URL",
    '__fwd_type' => "Uri ng forwarding",
    '__fwd_type_standart' => "Standard forwarding",
    '__fwd_type_standart_hint' => "Muling idirekta ang mga bisita sa ibang site at ipakita sa kanila ang destination address, upang alam nila ang tungkol sa muling pag-direkta.",
    '__fwd_type_frame' => "Frame forwarding",
    '__fwd_type_frame_hint' => "Ilipat visitor ng website sa ibang site, subalit hindi ipakita sa kanila ang destination address, sa gayon hindi nila alam ang redirection.",
    '__hosting_type_template_warning' => "Ang uri ng hosting na iyong napili ay iba mula sa uri ng natukoy sa template. Kapag ikaw ay nagpatuloy, ang mga setting sa web hosting sa napiling template ay hindi mapapansin. Sigurado ka bang nais mong itakda ang napiling hosting type?",

    '__no_resellers_selected' => "Kailangan mong pumili kahit isang account ng reseller.",

    'ippool_Manager__no_available_ips' => "Walang bakanteng mga IP address sa IP pool.",
    'ippool_Manager__ip_shared' => "naibahagi",
    'ippool_Manager__ip_exclusive' => "dedikado",

    'ippoolManager__ip_shared' => "naibahagi",
    'ippoolManager__ip_exclusive' => "dedikado",

    '__users_list' => "Mga User",
    '__users' => "Mga User",
    '__user_name' => "Pangalan ng user",

    'limit__name_max_dom_aliases' => "mga alyas ng domain",
    'limit__name_max_subftp_users' => "karagdagang mga FTP account",
    'limit__name_max_mssql_db' => "Mga database ng Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Mga IIS application pool",
    'limit__name_max_odbc' => "Mga koneksyon ng ODBC",
    'total_mboxes_quota_unsupported' => 'hindi suportado ng mail server',
    'limit_soft__disk_space' => 'Abisuhan sa oras na na-abot ang disk space',
    'limit_soft__max_traffic' => 'Abisuhan sa oras na na-abot ang trapiko',
    'limitsManager__commit_failed' => "Hindi mapalitan ang mga limitasyon ng resource.",
    'limitsManager__date_in_past' => "Maling petsa ng pag-expire %1.",
    'limitsManager__limit_not_supported' => "Ang mga limitasyon para sa uri ng resource %1 ay hindi maaring maitakda.",
    'limitsManager__limit_oversell_inconsistency' => "Hindi mai-laan ang natukoy na dami ng mga resource kapag ang sobrang pagbebenta ay nakapatay.",
    'limitsManager__limit_overuse_inconsistency' => "Ang paggamit ng resource ay sumobra sa tinukoy na mga limitasyon.",
    'limitsManager__no_resource_available' => "Walang nang natitirang mga magagamit na resource sa ganitong uri ng (%%limitName%%). Hiniling: %%quantity%%; na makukuha: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Walang nang natitirang mga magagamit na resource sa ganitong uri ng (%%limitName%%) mula sa iyong service provider. Hiniling: %%quantity%%; na makukuha: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Ang petsa ng pag-expire ay dapat mas mababa o katumbas ng %1.",
    'limitsManager__invalid_disk_space_limit' => "Ang dami ng disk space ay dapat mas mababa o katumbas ng %1.",
    'limitsManager__invalid_max_traffic_limit' => "Ang dami ng trapiko ay dapat mas mababa o katumbas ng %1.",
    'ippoolManager__ip_has_suballocations' => "Hindi mapalitan ang uri ng IP address na inilaan sa user. Ang IP address %%ip%% ay nai-laan na sa (mga) user bilang %%reserved%% IP address.",
    'ippoolManager__ip_is_already_in_pool' => "Ang IP address na ito ay naitakda sa user.",
    'ippoolManager__ip_is_not_in_pool' => "Walang IP address %%ip%% sa pool.",
    'ippoolManager__can_not_allocate_ip' => "Ang IP address %%ip%% ay magagamit lamang bilang katulad ng %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Ang IP address %%ip%% ay hindi maaring mai-laan katulad ng itinalaga.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Ang IP address %%ip%% ay ginamit para sa hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "Ang pag-access sa hindi kilalang FTP ay binuhay na para sa IP adress %%ip%%",
    'ippoolManager__no_vacant_ips' => "Walang bakanteng mga IP address.",
    'ippoolManager__no_available_ips' => "Walang magagamit na mga IP address.",
    'templates__dublicate_name' => "Ang template na may parehong pangalan ay umiiral. Pumili ng ibang pangalan para sa template na ito.",
    'cl_perm__client_limits_exceeded' => "Ang natukoy na marka ng limitasyon ng resource ay sumobra sa mga marka na pinahihintulutan ng iyong hosting plan, o ang mga halagang ito ay nagbibigay ng mas konting resources kaysa sa kasalukuyang gamit ng iyong mga site.",
    'cl_perm__reseller_limits_exceeded' => "Ang natukoy na marka ng limitasyon ng resource ay sumobra sa marka na pinahihintulutan ng iyong plano sa hosting, o ang mga halagang ito ay nagbibigay ng mas kaunting mga resource kaysa sa kasalukuyang gamit ng iyong mga account ng user at mga site.",

    'site_apps__preferences_show_all_versions_title' => "Ipakita ang buong listahan ng mga bersyon para sa bawat application na ibinalik mula sa catalog",
    'site_apps__preferences_show_all_versions_hint' => "Kung ang opsyon na ito ay napili, ito ay maaring magtagal ng sandaling panahon upang maibalik ang lahat ng mga bersyon ng bawat application sa tuwing bubuksan mo ang catalog. Kung ang opsyon na ito ay hindi napili, tanging mga pinakabagong bersyon ang ipapakita.",
    '__select_user_template' => "Lumikha ng batay sa account ng user sa template",
    'ip_already_added_to_all_clients' => "Ang IP address na ito ay naitakda sa lahat ng mga user.",

    'site_apps__cancelled_apps' => "Ikaw ay kumansela ng idadagdag sa mga sumusunod na mga application: %2",

    'sb_url_is_not_resolved' => 'Ang URL ay hindi maayos: i-check ang iyong mga DNS setting. Ang URL %1 ay dapat na akma sa IP address ng server na mayroong naka-install na Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Hindi maaring maalis ang IP address %%ip%% dahil ito ay ang huling IP address na makikita sa network interface.',
    'ip_addr__used_for_current_session' => 'Hindi maaring maalis ang IP address %%ip%% dahil ito ay ginamit ng aktibong sesyon.',
    'ip_addr__used_for_hosting' => 'Hindi maaring maalis ang IP address %%ip%% dahil ito ay ginamit para sa pag-host ng website.',
    'ip_addr__is_main' => 'Hindi maaring maalis ang IP address %%ip%% dahil ito ay ang pangunahing IP address ng network interface.',
    'ip_addr__ip_used_by_message_submission' => 'Hindi maaring maalis ang IP address %%ip%% dahil ito ay ginamit para sa pag-pasa ng mail message',

    // RESELLER ACTION LOG

    '__cl_domains' => 'mga domain ng mga kustomer',
    'excl_ip_num' => 'Dedikadong IP address',

    'sb_err_sitebuilder_not_installed' => 'Hindi naka-install ang Presence Builder.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Ang pahintulot upang payagan sa sobrang pagbenta ay hindi maaring bawiin mula sa user sapagkat ang user ay may inilaan na mas madaming mga resource kaysa sa magagamit, papunta sa sobrang pagbenta na mode.',
    'limitsManager__invalid_limit_value' => 'Maling marka %%value%% na natukoy para sa limit %%limit_name%%',
    'limit__max_mn' => 'Pinakamataas na bilang ng mga mail account',

    'limits__client_overuse_description' => 'Ang patakaran ng sobrang paggamit ay nagsasabi sa Plesk kung ano ang gagawin kapag ang paggamit ng resource ay sumobra sa paunang paglalaan ng resource.',
    'limits__client_overuse_block_true_description' => 'Harangan ang sobrang paggamit ng mga resource. Ang aktwal na paggamit ng resource ay hindi maaring sumobra sa paunang inilaan ng resource',
    'limits__client_overuse_block_false_description' => 'Huwag harangan ang sobrang paggamit ng mga resources, pinahihintulutan ang kustomer na gumamit ng mas maraming mga resource kaysa sa paunang ibinigay. Ang aktwal na paggamit ng resource ay maaring sumobra sa paunang inilaan ng resource',
    'limits__client_overuse_notify_text' => 'Abisuhan ang kustomer tungkol sa pag-abot ng mga limitasyon ng resource',

    'limits__domain_overuse_description' => 'Ang patakaran ng sobrang paggamit ay nagsasabi sa Plesk kung ano ang gagawin kapag ang paggamit ng resource ay sumobra sa paunang paglalaan ng resource.',
    'limits__domain_overuse_block_true_description' => 'Ang patakaran ng sobrang paggamit ang nagsasabi sa Plesk kung ano ang gagawin kapag ang mga resources ay sobrang nagamit.',
    'limits__domain_overuse_block_false_description' => 'Huwag harangan ang sobrang paggamit ng mga resources, pinahihintulutan ang domain na gumamit ng mas maraming mga resource kaysa sa paunang ibinigay. Aktwal na paggamit ng resource ay maaaring lumampas sa pangunahing paglalaan ng resource',
    'limits__domain_overuse_notify_text' => 'Abisuhan ang may-ari domain tungkol sa pag-abot ng mga limitasyon ng resource',

    'dns__dns_rr_delete' => 'Mga item na maaalis',
    'dns__delete_rr' => 'Ang mga sumusunod na mga DNS record ay maaalis mula sa DNS zone:',
    'dns__dns_rr_delete_non_removable' => 'Mga item na hindi maaring alisin',
    'dns__non_delete_rr' => 'Ang mga sumusunod na mga DNS record ay maaalis:',
    'dns__dns_rr_delete_confirm_message' => 'Kumpirmahin ang pagtanggal ng mga DNS record',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Hindi kilalang pormat ng web application: ang web application ay maaring hindi magamit para sa pag-install at paggamit.',

    '__php_handler_type_desc' => 'Patakbuhin ang PHP bilang',
    'sfdk_domain_sign__failed' => 'Nagkaroon ng hindi makilalang error noong sinusubukang i-on ang pagsa-sign ng mail gamit ang DKIM sa domain. Sumangguni sa error log ng server para sa mas maraming impormasyon.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notipikasyon sa Plesk key update success',
    'pkey_notify__subj_update_deferral_notification' => 'Notipikasyon sa Plesk key update deferral',
    'pkey_notify__subj_update_error_notification' => 'Notipikasyon sa Plesk key update error',
    'pkey_notify__update_successful' => '%1 ang pag-update ay matagumpay na nakumpleto.',
    'pkey_notify__update_failed_no_more_try' => 'Hindi magawa ang pag-update %1. Ang key na sinusubukan mong ipadala ay hindi wasto. Huwag mo ng subukan ang pag-update ng key na ito.',
    'pkey_notify__update_failed_try_later' => 'Hindi ma-update ang %1: nagkaroon ng error habang pinoproseso ang iyong key. Puwede mong subukang kunin ang key nang manu-mano sa Plesk (Mga Tool at Setting > Impormasyon ng Lisensya) o hayaan ang Plesk na subukan itong i-update sa loob ng susunod na 24 na oras. Kung ayaw mo nang makatanggap ng ganitong notification, alisin ang key na ito sa Plesk.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Mga domain',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Mga forwarder',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'AntiSpam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Mga kustomer',
    '__cl_name' => 'Pangalan ng kustomer',
    '__cl_creation_date' => 'Petsa na nilikha',
    '__clients_traffic' => 'Trapiko ng kustomer',
    'rpt_reseller_cl_mail_antispam' => 'AntiSpam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Hindi naka-install ang Presence Builder.',
    'sitebuilder_disabled' => 'Ang Presence Builder ay nakapatay.',
    'b_sitebuilder_disabled' => 'Ang Presence Builder ay nakapatay.',
    'webmail_not_installed' => 'Ang Webmail software na ito ay hindi naka-install.',
    'webmail_disabled' => 'Nakapatay ang serbisyo ng Webmail.',
    'spamassassin_not_installed' => 'Ang SpamAssassin ay hindi naka-install.',
    // pfu:
    'anonymous_ftp_shared' => 'Hindi ma-set up ang hindi kilalang FTP: uri ng shared IP address.',
    'anonymous_ftp_used' => 'Hindi ma-set up ang hindi kilalang FTP: ang IP address ay ginamit ng ibang domain para sa serbisyo ng hindi kilalang FTP.',
    // pfw:
    'aspdotnet_not_installed' => 'Hindi naka-install ang ASP.NET',
    'site_builder_no_package' => 'Ang Presence Builder ay hindi magagamit. Repasuhin kung naka-install ang Presence Builder at napili bilang aktibong component.',
    'site_builder_not_configured' => 'Ang Presence Builder ay hindi nakonpigura.',

    // various

    'disabled_by_admin' => 'Pinawalang bisa ng administrador ng server',

    '__not_allowed' => 'Hindi-pinahihintulutan',

    '__ip_addr_state_unknown' => "Ang IP address ay gumagana sa ngayon dahil ang system ay kasalukuyan pa rin na piniproseso ang iyong kahilingan. Maghintay ng ilang minuto.",

    'ip_addr__repair_is_not_allowed' => 'Ang IP address ay hindi maaring ayusin sa ilalim ng Virtuozzo environment.',

    'ippoolManager__ip_used_by_nohost_domain' => "Hindi maalis ang IP address na %%ip%% dahil ginagamit ito ng isa o higit pang domain na walang hosting.",
    'ippoolManager__ip_used_for_mail_service' => "Hindi maalis ang IP address na %%ip%% sapagkat ginagamit ito ng isa o higit pang mga domain para sa kanilang mail service IP address.",
    'ippoolManager__ip_used_for_send_emails' => "Hindi maalis ang IP address na %%ip%% sapagkat ginagamit ito upang magpadala ng mga email mula sa tukoy na IP (tingnan ang Mga Setting ng Mail Server).",
    'ippoolManager__ip_used_in_dns_zone' => 'Ang IP address %%ip%% ay hindi maalis dahil ito ay ginamit ng DNS zone ng isa o ilang mga domain.',
    'ip_ctrl__cannot_manage_on_vz' => 'Ang instalasyon ng Plesk na ito ay gumagana sa ilalim ng mga Virtuozzo container. Ang mga bagong mga IP address ay maari lamang idagdag ng Virtuozzo containers node administrator.',

    'client_template__limits_auto_adjusted' => 'Ang mga limitasyon mula sa template ng kustomer ay awtomatikong na-adjust.',

    '__entries' => 'Mga entry',

    '__path_is_not_set' => 'Ang path ay hindi natukoy. Tumukoy ng wastong path.',

    'defaultcomponents__imap_required' => '(Ang kasalukuyang mail server ay hindi sumusuporta sa IMAP)',

    '__commercial_web_stats_not_installed' => 'Sumusuporta lamang ang Plesk sa mga komersyal na software sa estatiskta ng web para sa subdomain statistics calculation. Walang nasabing software ang naka-instal sa sistema.',


    'server_settings_invalid_traffic_statistics' => 'Invalid na parameter ng pagpapanatili ng mga istatistika ng trapiko.',
    'server_settings_invalid_logrotate_period' => 'Invalid na parameter ng panahon ng pag-rotate ng log.',

    'spam_filter/address/file_size' => 'Hindi ma-upload ang file. Ang maximum na laki ng file na ia-upload ay %1.',
    'spam_filter/address/file_empty_content' => 'Nagkaproblema sa pagbabasa ng mga email address mula sa file. Siguraduhing mag-a-upload ka ng file na nasa UTF-8 encoding na naglalaman ng isa o higit pang email address, at subukan ulit.',
    'spam_filter/address/addresses_empty_content' => 'Hindi magkakaroon ng mga email address sa listahan.',
    'spam_filter/address/addresses_available' => 'Ang %1 unang kakaibang mga email address lamang ang idadagdag.',
    'spam_filter/address/invalid_addresses' => 'Ang sumusunod na mga email address ay hindi wasto: %1.',

    'current_resources' => 'Current resources',
    'plan_limitations' => 'Plan limitations',
    'cannot_switch_plan' => 'Cannot switch to the selected plan, because the following current resources are exceeding the plan\'s limitations:',
];