<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'หากเว็บไซต์ของคุณได้รับการโฮสต์กับที่อยู่ IP เฉพาะ (ไม่มีการแชร์กับผู้ใช้หรือเว็บไซต์อื่น) คุณสามารถสร้างไดเร็กทอรี่ภายในเว็บไซต์ที่ผู้ใช้คนอื่นสามารถทำการอัพโหลดหรืืือดาวน์โหลดไฟล์ผ่าน FTP ได้โดยนิรนาม เมื่อเปิดใช้งาน FTP นิรนาม ผู้ใช้จะสามารถล็อกอินเข้าสู่ไดเร็กทอรี่ตามที่อยู่ เช่น ftp://ftp.your-domain.com โดยใช้ชื่อผู้ใช้แบบ "นิรนาม" และรหัสผ่านใดก็ได้',
    'anonymous-ftp.displayLogin' => 'แสดงข้อความการเข้าสู่ระบบ',
    'anonymous-ftp.loginText' => 'ข้อความตัวอักษร',
    'anonymous-ftp.incomingDir' => 'อนุญาตให้อัพโหลดไปยังไดเร็กทอรี่ที่กำลังนำเข้า',
    'anonymous-ftp.incomingSubDir' => 'อนุญาตให้สร้างไดเร็กทอรี่ในไดเร็กทอรี่ที่กำลังนำเข้า',
    'anonymous-ftp.incomingReadable' => 'อนุญาตให้ดาวน์โหลดจากไดเร็กทอรี่ที่กำลังนำเข้า',
    'anonymous-ftp.quota' => 'จำกัดพื้นที่ดิสก์ในไดเร็กทอรี่ที่กำลังนำเข้า',
    'anonymous-ftp.maxConnections' => 'จำกัดจำนวนของการเชื่อมต่อพร้อมกัน',
    'anonymous-ftp.bandwidth' => 'จำกัดการดาวน์โหลดแบนด์วิดธ์สำหรับโดเมน FTP เสมือนนี้',
    'anonymous-ftp.unlimited' => 'ไม่จำกัด',

    'aps.catalog.loading' => 'กำลังโหลด...',
    'aps.catalog.searchName' => 'การใช้งาน',
    'aps.catalog.searchVendor' => 'ผู้จัดจำหน่าย',
    'aps.catalog.searchPackager' => 'ผู้บรรจุ',
    'aps.catalog.searchLicenseType' => 'ประเภทลิขสิทธิ์',
    'aps.catalog.searchLicenseTypeAny' => 'ทั้งหมด',
    'aps.catalog.searchLicenseTypeFreeware' => 'ฟรี',
    'aps.catalog.searchLicenseTypeCommercial' => 'การค้า',
    'aps.catalog.showSearch' => 'แสดงการค้นหา',
    'aps.catalog.hideSearch' => 'ซ่อนการค้นหา',
    'aps.catalog.buttonSearch' => 'ค้นหา',
    'aps.catalog.buttonResetSearch' => 'ตั้งค่าการค้นหาใหม่',
    'aps.catalog.showCategories' => 'เลือกหมวดหมู่ที่ด้านล่างหรือค้นหาแอพพลิเคชั่นโดยใช้กล่องค้นหา',
    'aps.catalog.searchResults' => 'ผลการค้นหา',
    'aps.catalog.buttonInstall' => 'ติดตั้ง',
    'aps.catalog.buttonInstallTooltip' => 'ติดตั้งเวอร์ชั่นล่าสุดของแอพด้วยพารามิเตอร์เริ่มต้นที่ดีที่สุดแบบด่วน',
    'aps.catalog.buttonAdvancedInstall' => 'ติดตั้ง (กำหนดเอง)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'ติดตั้งเวอร์ชั่นล่าสุดของแอพ ปรับแต่งพารามิเตอร์ทั้งหมด',
    'aps.catalog.buttonInstallOldVersion' => 'ติดตั้งเวอร์ชั่น',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'ติดตั้งเวอร์ชั่นที่เลือกของแอพ ปรับแต่งพารามิเตอร์ทั้งหมด',
    'aps.catalog.buttonInstallDescription' => 'ติดตั้งแอพบนไซต์หากคุณมีรหัสเปิดใช้งานแล้ว หรือถ้าคุณต้องการทดลองใช้',
    'aps.catalog.buttonInstallDescriptionFree' => 'ติดตั้งแอพฟรีนี้บนไซต์',
    'aps.catalog.version' => 'เวอร์ชั่น',
    'aps.catalog.moreVersions' => 'เวอร์ชั่นอื่นๆ',
    'aps.catalog.release' => 'ออกวางจำหน่าย',
    'aps.catalog.overview' => 'ภาพรวม',
    'aps.catalog.noApplicationsInCategory' => 'ไม่มีแอพพลิเคชั่นที่สามารถใช้ได้ในหมวดหมู่นี้ เลือกหมวดหมู่อื่น',
    'aps.catalog.noCategoriesSelected' => 'เลือกประเภทหมวดหมู่เพื่อเรียกดูแอพพลิเคชั่นทั้งหมดที่มีอยู่ในหมวดหมู่นี้',
    'aps.catalog.noSearchResults' => 'การค้นหาของคุณไม่ตรงกับแอพใดๆ',
    'aps.catalog.connectionFailed' => 'การเชื่อมต่อกับแค็ตตาล็อกแอพพลิเคชั่นล้มเหลว %%retryLink%%',
    'aps.catalog.retry' => 'ลองใหม่',
    'aps.catalog.categoriesError' => 'ไม่สามารถโหลดรายการประเภทหมวดหมู่ได้ในขณะนี้',
    'aps.catalog.applicationsError' => 'ไม่สามารถโหลดรายการแอพพลิเคชั่นได้ในขณะนี้',
    'aps.catalog.detailsError' => 'ไม่สามารถโหลดรายละเอียดแอพพลิเคชั่นได้ในขณะนี้',
    'aps.catalog.searchError' => 'ไม่สามารถโหลดผลลัพธ์ในการค้นหาได้ในขณะนี้',
    'aps.catalog.changelogEntry' => 'v%%version%% (ออกวางจำหน่าย %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'ประวัติของการเปลี่ยน',
    'aps.catalog.officialApplicationSite' => 'ข้อมูลผู้จัดจำหน่าย',
    'aps.catalog.returnToCategories' => '<< ย้อนกลับไปที่รายการแอพพลิเคชั่น',
    'aps.catalog.buttonUninstall' => 'ลบ',
    'aps.catalog.gotoHome' => 'หน้าหลัก',
    'aps.catalog.all' => 'ทั้งหมด',
    'aps.catalog.buttonDetails' => 'เรียนรู้เพิ่มเติม',
    'aps.catalog.buttonBuy' => 'ซื้อตอนนี้',
    'aps.catalog.buttonBuyTooltip' => 'ซื้อแอพ',
    'aps.catalog.buttonBuyDescription' => 'เยี่ยมชมร้านของเราเพื่อซื้อรหัสเปิดใช้งานสำหรับแอพนี้',
    'aps.catalog.buttonDownload' => 'ดาวน์โหลด',
    'aps.catalog.buttonDownloadDescription' => 'ดาวน์โหลดแอพหากคุณมีรหัสเปิดใช้งานแล้ว หรือต้องการทดลองใช้',
    'aps.catalog.marketplaceMoreInfo' => 'สำหรับข้อมูลเพิ่มเติม เยี่ยมชมได้ที่ %%link%%',
    'aps.catalog.marketplaceMoreInfoLink' => 'เว็บไซต์ของผู้จัดจำหน่ายแอพ',

    'aps.configure.installedAt' => "ติดตั้งที่",
    'aps.configure.otherSettings' => "อื่นๆ",
    'aps.configure.globalSettings' => 'การตั้งค่าแพคเกจ',
    'aps.configure.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'aps.configure.databaseParams' => 'พารามิเตอร์ฐานข้อมูล',
    'aps.configure.noInstallationUrlAvailable' => 'ไม่มี (แอพภายนอก)',
    'aps.configure.updateSettingsSection' => 'อัพเดตการตั้งค่า',
    'aps.configure.forceUpdates' => 'อัพเดตแอพนี้โดยอัตโนมัติเมื่อมีการอัพเดต',
    'aps.configure.forceUpdatesHint' => 'แอพนี้จะได้รับการอัพเดตเป็นเวอร์ชั่นที่ใหม่กว่าโดยอัตโนมัติ คำเตือน: ใช้ตัวเลือกนี้ด้วยความระมัดระวังเพราะการอัพเดตมีผลกระทบต่อการทำงานของแอพพลิเคชั่น ตัวอย่างเช่น ส่วนขยายของแอพอาจหยุดการทำงานกับเวอร์ชั่นอื่นๆ ของแอพ',

    'aps.install.showAllSettings' => 'แสดงการตั้งค่าทั้งหมด',
    'aps.install.showLessSettings' => 'แสดงการตั้งค่าขั้นต่ำ',
    'aps.install.install' => 'ติดตั้ง',
    'aps.install.otherSettings' => 'การติดตั้งอื่นๆ',
    'aps.install.globalSettings' => 'การตั้งค่าแพคเกจ',
    'aps.install.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'aps.install.provisionsSectionLabel' => 'พาธการติดตั้ง',
    'aps.install.context' => 'ระบุพื้นที่ที่ต้องการติดตั้งแอพพลิเคชั่นเว็บนี้',
    'aps.install.registerAsWebmailSection' => 'การลงทะเบียนเว็บเมล',
    'aps.install.registerAsWebmailDescription' => "หากแอพเป็นเว็บเมลไคลเอนท์ให้เลือกตัวเลือกนี้ จะทำให้แอพปรากฏขึ้นมาในบริการเว็บเมลที่มีอยู่ในการตั้งค่าเมลของการสมัครสมาชิกและแผนการบริการ ผู้ดูแลระบบสามารถกำหนดค่าการเข้าถึง URL สาธารณะของเว็บเมลในการจัดการเซิร์ฟเวอร์> การตั้งค่า > เว็บเมลได้",
    'aps.install.registerAsWebmailLabel' => 'ลงทะเบียนเป็นบริการเว็บเมล์',
    'aps.install.addItem' => 'เพิ่ม',
    'aps.install.removeItem' => 'ลบ',
    'aps.install.updateSettingsSection' => 'อัพเดตการตั้งค่า',
    'aps.install.forceUpdates' => 'อัพเดตแอพนี้โดยอัตโนมัติเมื่อมีการอัพเดต',
    'aps.install.forceUpdatesHint' => 'แอพนี้จะได้รับการอัพเดตเป็นเวอร์ชั่นที่ใหม่กว่าโดยอัตโนมัติ คำเตือน: ใช้ตัวเลือกนี้ด้วยความระมัดระวังเพราะการอัพเดตมีผลกระทบต่อการทำงานของแอพพลิเคชั่น ตัวอย่างเช่น ส่วนขยายของแอพอาจหยุดการทำงานกับเวอร์ชั่นอื่นๆ ของแอพ',

    'aps.invalid-requirements.requirementsLegend' => 'ข้อกำหนด',
    'aps.invalid-requirements.domainLegend' => 'เว็บไซต์',
    'aps.invalid-requirements.context' => 'เลือกเว็บไซต์อื่น',
    'aps.invalid-requirements.backToApplicationList' => 'ย้อนกลับไปที่รายการแอพพลิเคชั่น',

    'aps.license.title' => 'การติดตั้ง %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'คุณต้องอ่านข้อตกลงอนุญาตใช้สิทธิผู้ใช้ขั้นปลายและยอมรับเงื่อนไขต่างๆ เพื่อทำการติดตั้งแอพพลิเคชั่นนี้',
    'aps.license.licenseAgree' => 'ฉันยอมรับเงื่อนไขของข้อตกลงอนุญาตใช้สิทธิ',

    'aps.services-list-customization.settings' => 'การตั้งค่า',

    'asp-dot-net.change-version.title' => 'การเลือกเวอร์ชั่นของ ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'เวอร์ชั่นโครงร่าง ASP.NET',
    'asp-dot-net.change-version.success' => 'เปลี่ยนเวอร์ชั่น ASP.NET แล้ว',

    'asp-dot-net.settings.casSettingsSection' => "รหัสรักษาความปลอดภัย",
    'asp-dot-net.settings.clientScriptsSection' => "การตั้งค่าไลบรารี่สคริปต์",
    'asp-dot-net.settings.connStringsSection' => "ตัวจัดการสายการเชื่อมต่อ",
    'asp-dot-net.settings.customErrorsSection' => "การตั้งค่าข้อผิดพลาดเอง",
    'asp-dot-net.settings.frameworkVersionSection' => "เวอร์ชั่นของโครงร่าง",
    'asp-dot-net.settings.globalizationSection' => "การตั้งค่าสากล",
    'asp-dot-net.settings.otherSection' => "การตั้งค่าช่วงเวลา",
    'asp-dot-net.settings.pageAndRuntimeSection' => "การคอมไพล์และการไขจุดบกพร่อง",
    'asp-dot-net.settings.authMode' => "โหมดการตรวจสอบ",
    'asp-dot-net.settings.connStrings' => "สายการเชื่อมต่อ",
    'asp-dot-net.settings.connStringsInvalid' => "มีบางช่องว่างหรือมีค่าที่ไม่เหมาะสม",
    'asp-dot-net.settings.connStringName' => "ชื่อ",
    'asp-dot-net.settings.connStringValue' => "ค่าพารามิเตอร์การเชื่อมต่อ",
    'asp-dot-net.settings.connStringsDescription' => "ชื่อ / พารามิเตอร์การเชื่อมต่อ",
    'asp-dot-net.settings.culture' => "วัฒนธรรม",
    'asp-dot-net.settings.customErrMode' => "โหมดข้อผิดพลาดที่ตั้งค่าเอง",
    'asp-dot-net.settings.customErrorRedirect' => "การเปลี่ยนเส้นทาง URL",
    'asp-dot-net.settings.customErrorStatus' => "สถานะรหัส",
    'asp-dot-net.settings.customErrorStatusInvalid' => "สถานะรหัสต้องเป็นจำนวนเต็ม",
    'asp-dot-net.settings.customErrors' => "ข้อผิดพลาดที่ตั้งค่าเอง",
    'asp-dot-net.settings.customErrorsDescription' => "โค้ดสถานะ / URL นำเส้นทาง",
    'asp-dot-net.settings.customErrorsInvalid' => "มีบางช่องว่างหรือมีค่าที่ไม่เหมาะสม",
    'asp-dot-net.settings.debugMode' => "เปิดการแก้ไขจุดบกพร่อง",
    'asp-dot-net.settings.defLanguage' => "ภาษาเว็บเพจตามค่าเริ่มต้น",
    'asp-dot-net.settings.tempDirectory' => "ไดเร็กทอรี่ชั่วคราว",
    'asp-dot-net.settings.fileEnc' => "การเข้ารหัสไฟล์",
    'asp-dot-net.settings.fileEncInvalid' => "ค่าที่ระบุไว้สำหรับพารามิเตอร์การเข้ารหัสไฟล์ไม่ถูกต้อง",
    'asp-dot-net.settings.pathToLib' => "พาธไปยังไลบรารี่สคริปต์ไมโครซอฟต์",
    'asp-dot-net.settings.pathToLibInstall' => "ติดตั้ง",
    'asp-dot-net.settings.reqEnc' => "ต้องทำการเข้ารหัส",
    'asp-dot-net.settings.reqEncInvalid' => "ค่าที่ระบุไว้สำหรับพารามิเตอร์การเข้ารหัสที่ร้องขอไม่ถูกต้อง",
    'asp-dot-net.settings.resEnc' => "ตอบสนองการเข้ารหัส",
    'asp-dot-net.settings.resEncInvalid' => "ค่าที่ระบุไว้สำหรับพารามิเตอร์การเข้ารหัสตอบสนองไม่ถูกต้อง",
    'asp-dot-net.settings.sessTimeout' => "หมดเวลาเซสชั่น (นาที)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "ค่าที่ระบุไว้สำหรับพารามิเตอร์การหมดเวลาของเซสชั่นไม่ถูกต้อง ใส่จำนวนเต็มบวกที่น้อยกว่าหรือเท่ากับ %%max%%",
    'asp-dot-net.settings.connStringDuplicate' => "ชื่อสตริงการเชื่อมต่อถูกใช้แล้ว",
    'asp-dot-net.settings.customErrorInvalidCode' => "รหัสสถานะต้องอยู่ระหว่าง 100 ถึง 999",
    'asp-dot-net.settings.customErrorDuplicate' => "โค้ดสถานะถูกใช้แล้ว",
    'asp-dot-net.settings.trustLevel' => "ระดับความน่าเชื่อถือของ CAS",
    'asp-dot-net.settings.uiCulture' => "วัฒนธรรม UI",
    'asp-dot-net.settings.version' => "เวอร์ชั่น",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'อนุญาตให้หักล้างระดับความน่าเชื่อถือของ CAS บนเว็บไซต์',
    'asp-dot-net.settings.updateSuccess' => 'การอัปเดตสำเร็จแล้ว',

    'database.clone.formDescription' => 'คัดลอกเนื้อหาฐานข้อมูลไปยังฐานข้อมูลใหม่หรือฐานข้อมูลที่มีอยู่แล้ว เมื่อคัดลอกไปยังฐานข้อมูลที่มีอยู่ ตารางของฐานข้อมูลต้นกำเนิดจะได้รับการเพิ่มไปยังรายการตารางในฐานข้อมูลปลายทาง คำเตือน: หากชื่อของตารางเหมือนกัน ตารางจากต้นกำเนิดจะเข้าไปแทนที่ตารางที่ปลายทาง',
    'database.clone.copyData' => 'สร้างสำเนาเต็มรูปแบบ',
    'database.clone.copyDataHint' => 'หากเลือก ระบบจะคัดลอกฐานข้อมูลทั้งหมด (รวมถึงโครงสร้างและข้อมูล) หากไม่เลือก ระบบจะคัดลอกเฉพาะโครงสร้างของตารางเท่านั้น',
    'database.clone.server' => 'เซิร์ฟเวอร์ฐานข้อมูลปลายทาง',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'อื่นๆ...',
    'database.clone.database' => 'ฐานข้อมูลปลายทาง',
    'database.clone.newDatabase' => 'สร้างฐานข้อมูลด้วยชื่อ',
    'database.clone.existingDatabase' => 'คัดลอกไปยังฐานข้อมูลที่มีอยู่',
    'database.clone.externalDbHost' => 'ชื่อโฮสต์หรือที่อยู่ IP',
    'database.clone.externalDbLogin' => 'ชื่อผู้ใช้',
    'database.clone.externalDbPassword' => 'รหัสผ่าน',
    'database.clone.subscription' => 'การสมัครปลายทาง',
    'database.clone.subscription_powerUser' => 'พื้นที่เว็บปลายทาง',
    'database.clone.cloneInProgress' => 'โคลนนิ่งฐานข้อมูล %%source%% ไปยังฐานข้อมูล %%destination%% จะมีการแจ้งความคืบหน้าให้คุณทราบทางอีเมล (%%email%%)',
    'database.clone.unableToClone' => 'ไม่สามารถคัดลอกฐานข้อมูล "%%source%%" ได้',
    'database.clone.unableToCreateExternalDatabase' => 'ไม่สามารถสร้างฐานข้อมูล "%%destination%%" บนเซิร์ฟเวอร์ที่ระบุได้',
    'database.clone.databaseCloned' => 'คัดลอกฐานข้อมูล "%%source%%" แล้ว',
    'database.clone.emailSubjSuccess' => 'คัดลอกฐานข้อมูล "%%sourceDatabase%%" แล้ว',
    'database.clone.emailSubjFailure' => 'การคัดลอกฐานข้อมูล "%%sourceDatabase%%" ล้มเหลว',
    'database.clone.emailBodySuccess' => 'คัดลอกฐานข้อมูล "%%sourceDatabase%%" (%%sourceHost%%) ไปยังฐานข้อมูล "%%destDatabase%%" (%%destHost%%) แล้ว',
    'database.clone.emailBodyFailure' => 'ไม่สามารถคัดลอกฐานข้อมูล "%%sourceDatabase%%" (%%sourceHost%%) ไปยังฐานข้อมูล "%%destDatabase%%" (%%destHost%%) ได้ ขั้นตอนในการคัดลอกล้มเหลว',
    'database.clone.localServer' => 'เซิร์ฟเวอร์ในระบบ',

    'database.repair-orphaned.formDescription' => 'ผู้ใช้นี้กลายเป็นผู้ใช้ที่ไม่สามารถใช้งานได้หลังจากกระบวนการซ่อมแซม โปรดใส่รหัสผ่านสำหรับผู้ใช้นี้เพื่อแก้ไขปัญหานี้ หากผู้ใช้นี้ควรจะเป็นผู้ใช้ sys ที่ไม่มีรหัสผ่าน ให้รันยูทิลิตี้การซ่อมแซมที่ไม่ต้องใส่รหัสผ่าน',
    'database.repair-orphaned.login' => 'ชื่อผู้ใช้งานฐานข้อมูล',
    'database.repair-orphaned.pass' => 'รหัสผ่าน',
    'database.repair-orphaned.pass2' => 'ยืนยันรหัสผ่าน',
    'database.repair-orphaned.users' => 'คุณต้องให้ความสนใจแก่ผู้ใช้บางคน มีผู้ใช้ที่ไม่สามารถใช้งานได้หลายคนที่ควรจะได้รับการซ่อมแซมเพื่อระบบสามารถทำงานได้อย่างถูกต้อง',
    'database.repair-orphaned.orphaned' => 'ผู้ใช้ไม่สามารถทำงานได้ %%gui begin:link%%ซ่อมแซมเดี๋ยวนี้%%gui end:link%%',
    'database.repair-orphaned.repair' => 'ซ่อมแซม',

    'database.repair.fixSelected' => 'ซ่อมแซมสิ่งที่เลือกไว้',
    'database.repair.fix' => 'ซ่อมแซม',

    'database.user.password' => 'รหัสผ่าน',
    'database.user.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'database.user.server' => 'เซิร์ฟเวอร์ฐานข้อมูล',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'ฐานข้อมูล',
    'database.user.anyDatabase' => 'ทั้งหมด',
    'database.user.dataAccess' => 'การเข้าถึงข้อมูล',
    'database.user.structureAccess' => 'การเข้าถึงโครงสร้าง',
    'database.user.globalAccess' => 'สิทธิประโยชน์ทั่วโลก',
    'database.user.globalAccessHint' => 'สิทธิประโยชน์ทั่วโลกทำงานให้กับฐานข้อมูลทั้งหมดภายในบัญชีโฮสติ้ง',
    'database.user.aclRadio' => 'ควบคุมการเข้าถึง',
    'database.user.aclLocalhost' => 'อนุญาตเฉพาะการเชื่อมต่อในระบบ',
    'database.user.aclAny' => 'อนุญาตให้เชื่อมต่อทางไกลจากโฮสต์ใดก็ได้',
    'database.user.aclCustom' => 'อนุญาตให้เชื่อมต่อทางไกลจาก',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nอนุญาตให้โฮสต์ที่ระบุไว้สามารถเข้าถึงฐานข้อมูลในนามของผู้ใช้นี้",
    'database.user.remoteAccess' => 'การเข้าถึงทางไกล',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nอนุญาตให้ที่อยู่ IPที่ระบุไว้สามารถเข้าถึงเซิร์ฟเวอร์ฐานข้อมูลผ่านกฎไฟร์วอลล์ได้ ผู้ให้บริการโฮสติ้งของคุณจะทำการตรวจสอบการเปลี่ยนแปลงของคุณในรายการนี้ก่อน",
    'database.user.example' => "ยกตัวอย่างเช่น:\n%%example%%",
    'database.user.denied' => 'ใช้กฎไฟร์วอลล์ของระบบ',
    'database.user.allowed' => 'อนุญาตให้เชื่อมต่อทางไกลจาก',
    'database.user.default' => 'ใช้หลักฐานอ้างอิงของผู้ใช้ตามการตั้งค่าเริ่มต้นเพื่อเข้าถึง %%webadmin%%',
    'database.user.remoteAccessHint' => 'กรุณาติดต่อผู้ให้บริการโฮสติ้งของคุณและตรวจสอบว่าตัวเลือกที่คุณระบุมาข้างต้นเป็นไปตามกฏไฟร์วอลล์ในปัจจุบันเพื่อการเข้าใช้งาน MariaDB/MySQL ขาเข้า',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'ผู้ดูแลระบบเว็บ',
    'database.user.role' => 'บทบาท',
    'database.user.roleReadWrite' => 'อ่านและเขียน',
    'database.user.roleWriteOnly' => 'เขียนเท่านั้น',
    'database.user.roleReadOnly' => 'อ่านอย่างเดียว',
    'database.user.roleCustom' => 'กำหนดเอง',

    'database.generalSection' => 'ทั่วไป',
    'database.name' => 'ชื่อฐานข้อมูล',
    'database.server' => 'เซิร์ฟเวอร์ฐานข้อมูล',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'ไซต์ที่เกี่ยวข้อง',
    'database.noDomainRelations' => 'ไม่มีไซต์ที่เกี่ยวข้อง',
    'database.userSection' => 'ผู้ใช้',
    'database.userSectionDescription' => 'สร้างผู้ใช้ฐานข้อมูลตามค่าเริ่มต้น Plesk จะเข้าถึงฐานข้อมูลในนามของผู้ใช้นี้ หากไม่มีการกำหนดผู้ใช้ฐานข้อมูลในฐานข้อมูลก็จะไม่สามารถเข้าใช้งานได้',
    'database.createUser' => 'สร้างผู้ใช้ฐานข้อมูล',
    'database.username' => 'ชื่อผู้ใช้ฐานข้อมูล',
    'database.password' => 'รหัสผ่าน',
    'database.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'database.allDbAccess' => 'ผู้ใช้สามารถเข้าถึงฐานข้อมูลทั้งหมดภายในการสมัครสมาชิกที่เลือกไว้ได้',
    'database.aclRadio' => 'ควบคุมการเข้าถึง',
    'database.aclLocalhost' => 'อนุญาตเฉพาะการเชื่อมต่อในระบบ',
    'database.aclAny' => 'อนุญาตให้เชื่อมต่อทางไกลจากโฮสต์ใดก็ได้',
    'database.aclCustom' => 'อนุญาตให้เชื่อมต่อทางไกลจาก',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nอนุญาตให้โฮสต์ที่ระบุไว้สามารถเข้าถึงฐานข้อมูลในนามของผู้ใช้นี้",
    'database.remoteAccess' => 'การเข้าถึงทางไกล',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nอนุญาตให้ที่อยู่ IPที่ระบุไว้สามารถเข้าถึงเซิร์ฟเวอร์ฐานข้อมูลผ่านกฎไฟร์วอลล์ได้ ผู้ให้บริการโฮสติ้งของคุณจะทำการตรวจสอบการเปลี่ยนแปลงของคุณในรายการนี้ก่อน",
    'database.example' => "ยกตัวอย่างเช่น:\n%%example%%",
    'database.denied' => 'ใช้กฎไฟร์วอลล์ของระบบ',
    'database.allowed' => 'อนุญาตให้เชื่อมต่อทางไกลจาก',

    'deployment-section.deploymentDisabledHint' => 'อัพโหลดไฟล์จากที่เก็บข้อมูล Git',
    'deployment-section.deploymentEnabledHint' => 'เปิดใช้งานการสนับสนุน Git',
    'deployment-section.deploymentSectionLegend' => 'ไฟล์สำหรับคัดลอกเพื่อการโฮสติ้งของคุณ',
    'deployment-section.deploymentSectionDescriptionHint' => 'หากคุณปิดใช้งานตัวสนับสนุน GIT จะมีการสร้างรูทไดเร็กทอรี่ (รูทของเว็บไซต์/แอพพลิเคชั่นและรูทของเอกสาร) ให้ว่างเปล่า และไซต์จะแสดงผลหน้าเริ่มต้นในเบราเซอร์ คุณจะต้องอัพโหลดไฟล์ในไซต์ของคุณไปยังรูทเอกสารโดยใ้ช้ตัวจัดการ FTP หรือไฟล์ นอกจากนี้ ให้เปิดใช้งาน Git ตอนนี้หรือในภายหลัง (ในเว็บไซต์และโดเมน) และอัพโหลดไฟล์จากที่เก็บข้อมูล GIT',

    'dns-zone.add-acl-record.description' => 'เพิ่มที่อยู่ IPของเซิร์ฟเวอร์ DNS ที่อนุญาตให้รับสำเนาของโซน DNS ได้',
    'dns-zone.add-acl-record.ipAddress' => 'ที่อยู่ IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'ที่อยู่ IP/มาสก์',

    'dns-zone.record.add-title' => "เพิ่มรายการทรัพยากรไปยังแม่แบบโซน",
    'dns-zone.record.add-ns-title' => "เพิ่ม nameserver",
    'dns-zone.record.edit-title' => "แก้ไขรายการทรัพยากร",
    'dns-zone.record.edit-success' => "อัปเดตบันทึก DNS แล้ว",
    'dns-zone.record.add-success' => "สร้างบันทึก DNS แล้ว",
    'dns-zone.record.type' => "ประเภทบันทึก",
    'dns-zone.record.domainName' => "ชื่อโดเมน",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "เนมเซิร์ฟเวอร์",
    'dns-zone.record.optionOff' => 'ปิด',
    'dns-zone.record.optionOn' => 'เปิด',
    'dns-zone.record.protocol' => "โปรโตคอล",
    'dns-zone.record.priority' => "ความสำคัญ",
    'dns-zone.record.priorityLow' => "ต่ำ (%%priority%%)",
    'dns-zone.record.priorityHigh' => "สูงมาก (%%priority%%)",
    'dns-zone.record.weightLow' => "ต่ำ (%%weight%%)",
    'dns-zone.record.weightHigh' => "สูงมาก (%%weight%%)",
    'dns-zone.record.ipAddress' => "ที่อยู่ IP",
    'dns-zone.record.ipAddressDescription' => "ตัวอย่างเช่น 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "ตัวอย่างเช่น <ip> 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "ที่อยู่ IPv6",
    'dns-zone.record.ipAddressV6Description' => "ตัวอย่างเช่น 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "ตัวอย่างเช่น <ipv6> 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "ตัวอย่างเช่น 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "ตัวอย่างเช่น <ipv6>, <ip> 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "ตัวอย่างเช่น 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "ชื่อบัญญัติ",
    'dns-zone.record.mailDomain' => "โดเมนเมล",
    'dns-zone.record.mxServer' => "เซิร์ฟเวอร์การแลกเปลี่ยนเมล",
    'dns-zone.record.mxServerPriority' => "ระบุลำดับความสำคัญของเซิร์ฟเวอร์การแลกเปลี่ยนเมล",
    'dns-zone.record.txtRecord' => "บันทึก TXT",
    'dns-zone.record.txtRecordString' => "ป้อนรายการ",
    'dns-zone.record.txtSpfSyntax' => "รายการ SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "มีการระบุค่าที่ไม่ถูกต้องสำหรับการบันทึก TXT",
    'dns-zone.record.quotedTxtRecord' => "ค่าของบันทึก TXT ต้องเป็นข้อความบรรทัดเดียวโดยไม่มีเครื่องหมายคำพูด",
    'dns-zone.record.dsRecord' => "บันทึก DS",
    'dns-zone.record.dsRecordDescription' => "ตัวอย่างเช่น 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "มีการระบุค่าที่ไม่ถูกต้องสำหรับการบันทึก DS",
    'dns-zone.record.serviceName' => "ชื่อบริการ",
    'dns-zone.record.serviceNameDescription' => 'ตัวอย่าง เช่น SIP (โดยไม่มีอักขระขีดล่าง)',
    'dns-zone.record.protocolNameDescription' => 'ตัวอย่าง เช่น tcp (โดยไม่มีอักขระขีดล่าง)',
    'dns-zone.record.portDescription' => 'ตัวอย่าง เช่น 25 (โดยไม่มีอักขระขีดล่าง)',
    'dns-zone.record.srvWeight' => "น้ำหนักสัมพัทธ์ของบันทึกที่มีลำดับความสำคัญเดียวกัน",
    'dns-zone.record.targetHost' => "โฮสต์เป้าหมาย",
    'dns-zone.record.targetHostDescription' => "เช่น example.com",
    'dns-zone.record.targetPort' => "พอร์ทเป้าหมาย",
    'dns-zone.record.targetPortDescription' => 'ตัวอย่างเช่น 8443.',
    'dns-zone.record.retrieveDataError' => "ไม่พบข้อมูลที่บันทึก",
    'dns-zone.record.unknownTypeError' => "ประเภทของบันทึก DNS ที่ไม่รู้จัก",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'ห้ามตั้งค่าระเบียน MX แบบ NULL ขณะที่มีระเบียน MX อื่นอยู่',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'ห้ามตั้งค่าระเบียน MX แบบ non-NULL ในขณะที่มีระเบียน MX แบบ NULL',
    'dns-zone.record.masterShouldBeRemote' => "คุณต้องมีเซิร์ฟเวอร์สำหรับบริหารจัดการชื่อที่น่าเชื่อถือจำนวนสองเครื่องบนโฮสต์ที่แยกจากกัน",
    'dns-zone.record.caaTag' => "แท็ก",
    'dns-zone.record.caaRecord' => "ค่า",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'พอร์ท',
    'dns-zone.record.tlsaProtocol' => 'โปรโตคอล',
    'dns-zone.record.tlsaUsage' => 'การใช้งาน',
    'dns-zone.record.tlsaSelector' => 'ตัวเลือก',
    'dns-zone.record.tlsaMatching' => 'ประเภทการจับคู่',
    'dns-zone.record.tlsaCertData' => 'ข้อมูลการเชื่อมโยงใบรับรอง',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'ดูรายละเอียดได้ที่ %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, ส่วน 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, ส่วน 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, ส่วน 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, ส่วน 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "นามแฝง (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'ตัวอย่าง เช่น example.com ค่าว่างหมายความว่าชื่อโฮสต์เหมือนกันกับชื่อโดเมน',
    'dns-zone.record.httpsProtocols' => 'โปรโตคอล',
    'dns-zone.record.httpsProtocolsDescription' => 'รายการโปรโตคอลที่คั่นด้วยเครื่องหมายจุลภาคที่เป้าหมายรองรับ ตัวอย่าง เช่น h3,h3-29,h2,http/1.1',
    'dns-zone.record.httpsForceProtocols' => 'บังคับให้ใช้เฉพาะโปรโตคอลที่ระบุ รายการโปรโตคอลที่ด้านบนจะต้องไม่ว่างเปล่า',
    'dns-zone.record.httpsIpv4hint' => 'คำแนะนำเกี่ยวกับที่อยู่ IPv4',
    'dns-zone.record.httpsIpv4hintDescription' => 'รายการที่อยู่ IPv4 คั่นด้วยเครื่องหมายจุลภาคซึ่งไคลเอ็นต์สามารถใช้เพื่อเข้าถึงเซอร์วิซได้',
    'dns-zone.record.httpsIpv6hint' => 'คำแนะนำเกี่ยวกับที่อยู่ IPv6',
    'dns-zone.record.httpsIpv6hintDescription' => 'รายการที่อยู่ IPv6 คั่นด้วยเครื่องหมายจุลภาคซึ่งไคลเอ็นต์สามารถใช้เพื่อเข้าถึงเซอร์วิซได้',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "วินาที",
    'dns-zone.record.invalidValue' => 'ค่าไม่ถูกต้อง สามารถตั้งค่าโดยเริ่มจาก 1 วินาทีจนถึง 2147483647 วินาที',
    'dns-zone.record.ttlDefaultValue' => 'ค่าเริ่มต้น: %%value%% วินาที',
    'dns-zone.record.invalidTTL' => 'ค่า TTL ที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidIpAddress' => 'ที่อยู่ IPที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidIpMaskPair' => 'คู่ที่อยู่ IP/เน็ตมาสก์ที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidCName' => 'ชื่อบัญญัติที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidPort' => 'การพอร์ธที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidTLSACertData' => 'ข้อมูลการเชื่อมโยงใบรับรองที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidTLSAProtocol' => 'โปรโตคอลที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidTLSAUsage' => 'การใช้งานที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidTLSASelector' => 'ตัวเลือกที่ระบุไม่ถูกต้อง',
    'dns-zone.record.invalidTLSAMatching' => 'ประเภทการจับคู่ที่ระบุไม่ถูกต้อง',

    'dns-zone.restore-default.formHint' => "ที่นี่คุณสามารถเรียกคืนการตั้งค่าโซนต้นฉบับให้สอดคล้องกับการตั้งค่าเริ่มต้นของแม่แบบ DNS ที่ใช้งานบนเซิร์ฟเวอร์ได้ เลือกที่อยู่ IPที่จะใช้เพื่อการเรียกคืนโซน และระบุนามแฝง www ที่โดเมนจำเป็นต้องใช้",
    'dns-zone.restore-default.ipv4' => "ที่อยู่ IPv4",
    'dns-zone.restore-default.ipv4Hint' => "ตัวอย่างเช่น 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "ที่อยู่ IPv6",
    'dns-zone.restore-default.ipv6Hint' => "ตัวอย่างเช่น 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'ที่อยู่ IPที่ระบุไม่ถูกต้อง',
    'dns-zone.restore-default.customIpHint' => "การบันทึกโดยใช้ที่อยู่ IPนี้จะได้รับการพิจารณาในฐานะผู้ใช้ที่มีการแก้ไข และจะไม่สามารถประสานงานกับแม่แบบ DNS ทั้งเซิร์ฟเวอร์ได้",
    'dns-zone.restore-default.wwwPrefix' => "คำนำหน้า www",
    'dns-zone.restore-default.previewRecords' => "กู้คืนบันทึกที่ใช้เพื่อการดูตัวอย่างไซต์",

    'dns-zone.soa-record.soaMnameSection' => 'เนมเซิร์ฟเวอร์หลัก',
    'dns-zone.soa-record.soaMname' => 'เนมเซิร์ฟเวอร์',
    'dns-zone.soa-record.soaMnameAutoselect' => '(เลือกโดยอัตโนมัติ)',
    'dns-zone.soa-record.soaRecordSection' => 'บันทึก SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'รีเฟรช',
    'dns-zone.soa-record.retry' => 'ลองใหม่',
    'dns-zone.soa-record.expire' => 'หมดอายุ',
    'dns-zone.soa-record.minimum' => 'ขั้นต่ำ',
    'dns-zone.soa-record.rnameType' => 'อีเมล (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'ที่อยู่อีเมลของบุคคลที่รับผิดชอบโซน DNS ของโดเมน ส่งคืนโดยเซิร์ฟเวอร์ DNS เพื่อตอบสนองต่อการค้นหา SOA',
    'dns-zone.soa-record.rnameTypeOwner' => 'ที่อยู่อีเมลของเจ้าของเว็บไซต์',
    'dns-zone.soa-record.rnameTypeDomain' => 'ที่อยู่อีเมลโดเมน',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'ป้อนเฉพาะส่วนภายใน (หน้า @<โดเมน>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'ที่อยู่อีเมลภายนอก',
    'dns-zone.soa-record.rnameEnforceEmail' => 'ไม่อนุญาตให้เปลี่ยนที่อยู่อีเมล RNAME บนพื้นฐานโดเมนแต่ละอัน',
    'dns-zone.soa-record.invalidValue' => 'ค่าไม่ถูกต้อง ค่าต้องเริ่มจาก 1 วินาที ถึง 68 ปี',
    'dns-zone.soa-record.advancedSection' => 'คุณสมบัติ DNS ขั้นสูง',
    'dns-zone.soa-record.serialNumberFormat' => 'ใช้รูปแบบหมายเลขซีเรียลที่แนะนำโดย IETF และ RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'เลือกตัวเลือกดังกล่าว หากโดเมนของคุณมีปัญหาในการผ่านการตรวจสอบ SOA ของผู้รับจดทะเบียน รูปแบบหมายเลขซีเรียลนี้จำเป็นสำหรับผู้รับจดทะเบียนโดเมนในหลายแห่ง',
    'dns-zone.soa-record.restoreDefaultButton' => 'ใช้งานการตั้งค่าเริ่มต้น',
    'dns-zone.soa-record.zoneDefaultsSection' => 'ค่าเริ่มต้นของโซน',
    'dns-zone.soa-record.unitSeconds' => 'วินาที',
    'dns-zone.soa-record.unitMinutes' => 'นาที',
    'dns-zone.soa-record.unitHours' => 'ชั่วโมง',
    'dns-zone.soa-record.unitDays' => 'วัน',
    'dns-zone.soa-record.unitWeeks' => 'สัปดาห์',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'การรีเฟรชค่าช่วงเวลาไว้น้อยกว่าหนึ่งชั่วโมง อาจทำให้การใช้ทรัพยากรและทราฟฟิคของเซิร์ฟเวอร์เพิ่มมากขึ้น',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'การตั้งค่าขั้นต่ำของ TTL ไว้มากกว่า 3 ชั่วโมงอาจส่งผลให้ผู้ดูแลระบบบางท่านไม่สามารถใช้งานโดเมนได้ แนะนำให้ใช้การตั้งค่าแบบนั้นในกรณีที่มีการลงทะเบียนชื่อโดเมน',
    'dns-zone.soa-record.success' => 'อัปเดตคุณสมบัติบันทึก SOA แล้ว',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'กู้คืนบันทึก SOA เริ่มต้นแล้ว',

    'domain-info-section.domainName' => 'ชื่อโดเมน',
    'domain-info-section.emptyDomainName' => 'โปรดระบุชื่อโดเมน',
    'domain-info-section.ipAddress' => 'ที่อยู่ IP',
    'domain-info-section.shared' => 'ใช้ร่วมกัน',
    'domain-info-section.exclusive' => 'เฉพาะ',
    'domain-info-section.ipAddressHint' => "ที่อยู่ IP ที่เป็นโฮสต์ของเว็บไซต์คือแอดเดรสเครือข่ายของโฮสต์เสมือนจริงเว็บไซต์ โดยจะใช้ที่อยู่ IP นี้กับทุกเว็บไซต์ที่สร้างขึ้นภายในการสมัครสมาชิกนี้",
    'domain-info-section.ipAddressHint_powerUser' => "ที่อยู่ IP ที่เป็นโฮสต์ของเว็บไซต์คือที่อยุ่เครือข่ายของโฮสต์เสมือนจริงของเว็บไซต์ โดยจะใช้ที่อยู่ IP นี้กับทุกเว็บไซต์ที่สร้างขึ้นภายในพื้นที่เว็บ",
    'domain-info-section.userName' => 'ชื่อผู้ใช้',
    'domain-info-section.userNameHint' => 'มีการใช้บัญชีผู้ใช้ระบบที่เกี่ยวข้องกับพื้นที่เว็บเพื่อเข้าถึงไฟล์โฮสต์ผ่านทาง FTP และ SSH',
    'domain-info-section.emptyLogin' => 'โปรดระบุชื่อผู้ใช้งาน',
    'domain-info-section.password' => 'รหัสผ่าน',
    'domain-info-section.emptyPassword' => 'โปรดระบุรหัสผ่าน',
    'domain-info-section.passwordConfirmation' => 'ใส่รหัสผ่านซ้ำ',

    'email-address.generalTab' => 'ทั่วไป',
    'email-address.generalHint' => 'หากบัญชีอีเมลนี้มีความเกี่ยวข้องกับผู้ใช้เสริม (สามารถเข้าถึงแผงการจัดการลูกค้าได้) การเปลี่ยนแปลงที่คุณทำในหน้านี้จะส่งผลต่อการตั้งค่าของผู้ใช้รายนี้ โดยเฉพาะถ้าคุณเปลี่ยนที่อยู่อีเมลหรือรหัสผ่าน ล็อกอินและรหัสผ่านของผู้ใช้เสริมจะได้รับการเปลี่ยนค่าใหม่ด้วยเช่นกัน',
    'email-address.redirectTab' => 'การส่งต่อ',
    'email-address.redirectHint' => 'ตั้งค่าการส่งต่อข้อความอีเมลไปยังหนึ่งที่อยู่อีเมลหรือมากกว่านั้น',
    'email-address.aliasesTab' => 'นามแฝงอีเมล',
    'email-address.autoResponderTab' => 'การตอบกลับอัตโนมัติ',
    'email-address.antispamTab' => 'ตัวกรองสแปม',
    'email-address.autoResponderHint' => 'ตั้งค่าการตอบสนองโดยอัตโนมัติเมื่อมีข้อความเมลเข้ามาในที่อยู่อีเมลของคุณ การตอบกลับอัตโนมัติเป็นวิธีที่ได้มาตรฐานในการแจ้งเตือนผู้ติดต่อทางจดหมายว่าคุณไม่ได้อยู่ในออฟฟิศหรืออยู่ระหว่างพักร้อน',
    'email-address.antivirusTab' => 'โปรแกรมป้องกันไวรัส',
    'email-address.name' => 'ที่อยู่อีเมล',
    'email-address.externalEmail' => 'ที่อยู่อีเมลภายนอก',
    'email-address.externalEmailHint' => 'จะใช้ในการรีเซตรหัสผ่านของคุณ หากคุณสูญเสียสิทธิในการเข้าถึงที่อยู่อีเมลหลัก',
    'email-address.user' => 'กำหนดให้กับ',
    'email-address.password' => 'รหัสผ่าน',
    'email-address.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'email-address.clientConfigurationLink' => 'ลิงก์ตัวกำหนดค่าเมล',
    'email-address.responderEnable' => 'เปิดการตอบกลับอัตโนมัติ',
    'email-address.responderSubject' => 'การตอบกลับหัวเรื่องของข้อความอัตโนมัติ',
    'email-address.responderContentType' => 'รูปแบบข้อความ',
    'email-address.responderContentTypeHint' => 'โปรแกรมไคลเอนท์เมลทั้งหมดรองรับรูปแบบของข้อความธรรมดาดังนั้นผู้รับทุกคนจึงสามารถเห็นข้อความได้ในแบบเดียวกับที่คุณเห็น ข้อความ HTML ใช้งานได้ดีกว่าเพราะช่วยให้คุณใส่ข้อความได้ด้วยรูปแบบตัวอักษรที่หลากหลาย อย่างไรก็ตาม ไคลเอนท์เมลบางรายการจะไม่รองรับข้อความ HTML ทำให้ผู้ใช้บางรายไม่สามารถเห็นรูปแบบข้อความดังกล่าวได้',
    'email-address.responderContentTypeTextPlain' => 'ข้อความธรรมดา',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'การเข้ารหัส',
    'email-address.responderCodepageHint' => 'การเข้ารหัสกำหนดวิธีการแสดงข้อความตัวอักษร การเข้ารหัสที่แนะนำคือ UTF-8',
    'email-address.responderReplyTo' => 'ส่งต่อไปยัง',
    'email-address.responderReplyToHint' => 'เมื่อส่งการตอบสนองอัตโนมัติแล้ว จะมีการส่งต่อข้อความต้นฉบับไปยังที่อยู่อีเมลตามที่ระบุไว้',
    'email-address.responderForwardAddress' => 'ส่งต่อไปยัง',
    'email-address.responderForwardAddressHint' => 'เมื่อส่งการตอบสนองอัตโนมัติแล้ว จะมีการส่งต่อข้อความต้นฉบับไปยังที่อยู่อีเมลตามที่ระบุไว้',
    'email-address.responderMessage' => 'การตอบกลับข้อความตัวอักษรอัตโนมัติ',
    'email-address.responderReplyToEqualsEmail' => 'แอดเดรสที่ระบุให้ส่งต่อข้อความเหมือนกันกับที่อยู่อีเมลนี้',
    'email-address.responderForwardAddressEqualsEmail' => 'แอดเดรสที่ระบุให้ส่งต่อข้อความเหมือนกันกับที่อยู่อีเมลนี้',
    'email-address.responderReplyLimit' => 'ห้ามส่งการตอบสนองอัตโนมัติไปยังที่อยู่อีเมลเฉพาะมากกว่า (ครั้งต่อวัน)',
    'email-address.buttonAddResponderAttachment' => 'เพิ่มเอกสารแนบ',
    'email-address.buttonRemoveResponderAttachment' => 'ลบ',
    'email-address.responderAttachment' => 'แนบไฟล์',
    'email-address.redirectEnable' => 'เปิดใช้งานการส่งต่อเมล',
    'email-address.redirectRemoveEnable' => 'อย่าส่งสำเนาของอีเมลที่ส่งต่อไปยังกล่องจดหมาย Plesk',
    'email-address.redirectAddress' => 'ส่งต่อข้อความขาเข้าไปยังที่อยู่อีเมลดังต่อไปนี้',
    'email-address.redirectAddressHint' => 'ระบุที่อยู่อีเมล คุณต้องพิมพ์ที่อยู่แต่ละที่บนบรรทัดใหม่ หรือแยกที่อยู่ด้วยการเว้นวรรค เครื่องหมายจุลภาค หรืออัฒภาค',
    'email-address.role' => 'บทบาทของผู้ใช้',
    'email-address.roleHint' => 'บทบาทของผู้ใช้ให้สิทธิ์ในการจัดการแก่ผู้ใช้และยังเข้าถึงแอพพลิเคชั่นที่คุณเลือกในบทบาทนั้นด้วย',
    'email-address.errorRedirectAddress' => 'คุณระบุที่อยู่อีเมลไม่ถูกต้อง: %value%',
    'email-address.errorRedirectAddressMultiple' => 'คุณระบุที่อยู่อีเมลไม่ถูกต้อง: %value%',
    'email-address.mailAlias' => "นามแฝงอีเมล",
    'email-address.mailAliasNone' => 'ไม่มี',
    'email-address.mailAliasHint' => "นามแฝงอีเมลคือที่อยู่อีเมลสำรองที่มีความเกี่ยวข้องกับที่อยู่อีเมลหลัก ที่อยู่อีเมลหลักจะได้รับเมลทั้งหมดที่ส่งไปยังนามแฝงอีเมลเช่นกัน",
    'email-address.buttonAddMailAlias' => 'เพิ่มนามแฝงอีเมล',
    'email-address.buttonRemoveMailAlias' => 'ลบ',
    'email-address.emptyEmail' => 'ระบุที่อยู่อีเมลที่จะทำการส่งต่อข้อความขาเข้าทั้งหมดไป',
    'email-address.emailsIsEqual' => 'ที่อยู่อีเมลภายนอกตรงกับอีเมลหลัก ระบุที่อยู่อีเมลภายนอกที่แตกต่างกัน',
    'email-address.emptyPassword' => 'คุณต้องระบุรหัสผ่าน',
    'email-address.emptyPasswordConfirmation' => 'คุณต้องยืนยันรหัสผ่าน',
    'email-address.emptyAlias' => "ระบุนามแฝงอีเมลสำหรับที่อยู่อีเมลนี้",
    'email-address.aliasEqualsEmail' => 'นามแฝงอีเมลที่กำหนดเหมือนกับที่อยู่อีเมล',
    'email-address.passwordHint' => 'จะใช้ในการเข้าถึงกล่องจดหมายและล็อกอินเข้าสู่ Plesk ได้ (หากเปิดใช้งานตัวเลือกที่สอดคล้องกัน)',
    'email-address.cyclicRedirect' => 'ไม่สามารถตั้งค่าที่อยู่อีเมลให้ส่งต่อข้อความอีเมลกลับมาที่ที่อยู่อีเมลของตนเองได้',
    'email-address.errorMailnameReserved' => 'มีการใช้งานที่อยู่อีเมลที่ระบุแล้ว',
    'email-address.antivirusEnable' => 'เปิดใช้งานการโปรแกรมป้องกันไวรัสสำหรับที่อยู่อีเมลนี้',
    'email-address.antivirusHint' => 'บริการโปรแกรมป้องกันไวรัสจะบล็อคข้อความที่มีไวรัสและแจ้งเตือนทั้งผู้ส่งและผู้รับเกี่ยวกับข้อความนั้น',
    'email-address.antivirusSettings' => 'ตรวจสอบไวรัส',
    'email-address.antivirusSettingOnlyIncomingMail' => 'จดหมายเข้าเท่านั้น',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'จดหมายออกเท่านั้น',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'จดหมายเข้าและออก',
    'email-address.antispamHint' => 'บริการตัวกรองสแปมจะตรวจจับข้อความสแปมที่ส่งมายังที่อยู่อีเมล คุณสามารถตั้งค่าตัวกรองสแปมให้ลบข้อความสแปมได้ ทำเครื่องหมายว่าเป็นสแปมโดยการเปลี่ยนหัวข้อเรื่อง หรือย้ายข้อความไปที่โฟลเดอร์สแปมพิเศษที่สามารถเข้าใช้งานได้ด้วยเมลไคลเอนท์ผ่าน IMAP ตัวกรองสแปมใช้ความหลากหลายของการทดสอบในระบบและเครือข่ายเพื่อระบุลายเซ็นของสแปม',
    'email-address.antispamEnable' => 'เปิดใช้งานตัวกรองสแปมสำหรับที่อยู่อีเมลนี้',
    'email-address.antispamSettings' => 'ควรทำอย่างไรกับข้อความที่เป็นสแปม',
    'email-address.antispamSettingsMark' => 'ทำเครื่องหมายข้อความสแปมโดยการเพิ่มข้อความดังต่อไปนี้ที่หัวเรื่องของข้อความ',
    'email-address.antispamSettingsMarkHint' => 'หากคุณไม่ต้องการเพิ่มข้อความใดๆ ควรปล่อยฟิลด์นี้ให้ว่างไว้ พิมพ์ _SCORE_ หากคุณต้องการเพิ่มคะแนนในหัวข้อของข้อความ',
    'email-address.antispamReportTextHint' => 'พิมพ์ข้อความที่คุณต้องการเพิ่มลงในเนื้อหาข้อความอีเมลสแปม',
    'email-address.antispamSettingsDelete' => 'ลบข้อความสแปมทั้งหมด',
    'email-address.antispamSettingsDeleteHint' => 'จะลบข้อความสแปมออกจากกล่องจดหมายของคุณ',
    'email-address.antispamSettingsMove' => 'ย้ายสแปมไปที่โฟลเดอร์สแปม',
    'email-address.antispamSettingsMoveHint' => 'ย้ายข้อความสแปมทั้งหมดไปยังโฟลเดอร์ที่เรียกว่าสแปม สามารถเข้าใช้งานโฟลเดอร์นี้ได้จากโปรแกรมไคลเอนท์เมลหรือเว็บเมลของคุณ คุณสามารถใช้โฟลเดอร์สแปมเพื่อฝึกการใช้งานตัวกรองสแปมได้หากคุณใช้บัญชีเมล IMAP',
    'email-address.antispamSettingsMoveWarning' => '"ย้ายสแปมไปยังโฟลเดอร์สแปม" ไม่ทำงานนอกจากคุณจะปิดใช้งานทางเลือก "อย่าส่งสำเนาของอีเมลที่ส่งต่อ" บนแท็บ "การส่งต่อ"',
    'email-address.antispamSettingsMoveJunk' => 'ย้ายสแปมไปที่โฟลเดอร์ “อีเมลขยะ”',
    'email-address.antispamSettingsMoveJunkHint' => 'ย้ายข้อความสแปมทั้งหมดไปยังโฟลเดอร์ที่เรียกว่า “อีเมลขยะ” สามารถเข้าใช้งานโฟลเดอร์นี้ได้จากโปรแกรมไคลเอนท์เมลหรือเว็บเมลของคุณ คุณสามารถใช้โฟลเดอร์อีเมลขยะเพื่อฝึกการใช้งานตัวกรองสแปมได้หากคุณใช้บัญชีเมล IMAP',
    'email-address.antispamShowAdvancedSection' => 'แสดงการตั้งค่าขั้นสูง',
    'email-address.antispamHideAdvancedSection' => 'ซ่อนการตั้งค่าขั้นสูง',
    'email-address.antispamLearnMore' => 'เรียนรู้วิธีการฝึกใช้ตัวกรองสแปม',
    'email-address.antispamFilterScoreTitle' => 'ความไวตัวกรอง',
    'email-address.antispamFilterScoreHint' => 'ตัวกรองสแปมจะแสดงหมายเลขจากการทดสอบที่หลากหลายเกี่ยวกับเนื้อหาและหัวข้อเรื่องของแต่ละข้อความ เป็นผลให้มีการคิดคะแนนให้กับแต่ละข้อความ ยิ่งหมายเลขสูงขึ้นก็มีแน้วโน้มที่ข้อความจะเป็นสแปมมากขึ้น ความไวตัวกรองไดรับการตั้งค่าเริ่มต้นที่ทุกๆ ข้อความที่ได้ 7 คะแนนหรือมากกว่าจะได้รับการจัดประเภทเป็นสแปม หากคุณตั้งค่านี้แล้วยังได้รับข้อความสแปมจะนวนมากลองตั้งค่าที่น้อยกว่าเช่น 6 เพื่อเพิ่มความไวตัวกรองให้มากขึ้น แต่หากคุณไม่ได้รับอีเมลเพราะตัวกรองสแปมคิดว่าเป็นอีเมลขยะลองตั้งค่าที่สูงขึ้นเช่น 8 เพื่อลดความไวของตัวกรองลง',
    'email-address.antispamFilterScore' => 'ความไวของตัวกรองสแปม',
    'email-address.antispamWhiteListTitle' => 'บัญชีที่ปลอดภัย',
    'email-address.antispamWhiteListHint' => 'ตัวกรองสแปมจะไม่ตรวจสอบอีเมลจากผู้ส่งที่อยู่ในบัญชีที่ปลอดภัย',
    'email-address.antispamWhiteListField' => 'บัญชีที่ปลอดภั',
    'email-address.antispamWhiteListFieldHint' => 'พิมพ์ชื่อโดเมน หนึ่งชื่อโดเมนต่อบรรทัด สามารถใส่อักขระตัวแทน "*" และ "?" ในแอดเดรสได้ ตัวอย่างเช่น *@domain.com, user?@*.com',
    'email-address.antispamBlackListTitle' => 'บัญชีดำ',
    'email-address.antispamBlackListHint' => 'อีเมลจากผู้ส่งในรายการบัญชีดำจะถูกจัดหมวดหมู่เป็นสแปม',
    'email-address.antispamBlackListField' => 'บัญชีดำ',
    'email-address.antispamBlackListFieldHint' => 'พิมพ์ชื่อโดเมนหนึ่งชื่อต่อบรรทัด สามารถใส่อักขระตัวแทน "*" และ "?" ในแอดเดรสได้ ตัวอย่างเช่น *@domain.com, user?@*.com',
    'email-address.antispamTrustedLanguagesTitle' => 'ภาษาที่น่าเชื่อถือ',
    'email-address.antispamTrustedLanguagesHint' => 'ข้อความอีเมลที่เขียนด้วยภาษาเหล่านี้สามารถผ่านการตรวจของตัวกรองได้เสมอ',
    'email-address.antispamTrustedLocalesTitle' => 'กลุ่มในระบบที่เชื่อถือได้',
    'email-address.antispamTrustedLocalesHint' => 'ข้อความอีเมลที่ใช้กลุ่มในระบบที่กำหนดไว้จะสามารถผ่านการตรวจของตัวกรองได้เสมอ กลุ่มในระบบนี้รวมไปถึงชุดตัวอักษรที่มีการใช้โดยทั่วไป ตัวอย่างเช่น ชุดตัวอักษรตะวันตกรวมถึงการเข้ารหัสสำหรับตัวอักษรที่ใช้ในภาษาอังกฤษและภาษายุโรปตะวันตก',
    'email-address.antispamTrustedNetworksTitle' => 'เครือข่ายที่เชื่อถือได้',
    'email-address.antispamTrustedNetworksHint' => 'การถ่ายทอดโฮสต์บนเครือข่ายที่น่าเชื่อถือจะได้รับการพิจารณาว่าไม่มีทางที่จะเป็นการดำเนินการโดยสแปมเมอร์ และจะไม่เปิดการถ่ายทอดหรือเปิดพร็อกซี่',
    'email-address.antispamIpAddressesField' => 'ที่อยู่ IP',
    'email-address.antispamIpAddressesFieldHint' => 'ระบุที่อยู่ IPเครือข่ายและมาสก์',
    'email-address.mailBoxQuotaDomainDefault' => 'ขนาดตามค่าเริ่มต้น (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'ขนาดตามค่าเริ่มต้น',
    'email-address.mailBoxOutgoingMessages' => 'จำนวนสูงสุดของของข้อความอีเมลขาออก',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'ค่าเริ่มต้น (%%domainOutgoingMessages%% ข้อความต่อชั่วโมง)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'ค่ากำหนดเองสำหรับกล่องจดหมายนี้',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'ข้อความ',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'ค่าเริ่มต้น',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'ขนาดตามค่าเริ่มต้น',
    'email-address.mailBoxQuotaDomainSpecific' => 'ขนาดอื่นๆ',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'ขนาดกล่องจดหมาย',
    'email-address.mailBoxQuotaUnlimited' => 'ไม่จำกัด',
    'email-address.mailBoxLimitReached' => 'จำนวนของกล่องจดหมายถึงขีดจำกัดแล้ว',
    'email-address.postboxEnabled' => 'กล่องจดหมาย',
    'email-address.postboxEnabledYes' => 'เปิด',
    'email-address.postboxEnabledNo' => 'ปิด',
    'email-address.description' => 'รายละเอียดของ Plesk',
    'email-address.descriptionHint' => 'ทุกคนที่เข้าถึงบัญชีอีเมลนี้สามารถดูรายละเอียดได้',
    'email-address.longDescription' => 'รายละเอียดที่กำหนดยาวเกินไป ไม่สามารถยาวกว่า %%max%% ได้',
    'email-address.loginAsUser' => 'สามารถใช้ในการล็อกอินเข้าสู่ Plesk',
    'email-address.loginAsUserDescription' => '(ชื่อผู้ใช้: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'ขนาดกล่องจดหมายต้องไม่เกินขนาดตามค่าเริ่มต้น',
    'email-address.endDateEnable' => 'ปิดการตอบกลับอัตโนมัติ',

    'failed-request.enable-tracing.description' => 'การร้องขอที่ล้มเหลวในการติดตามหมายถึงการใช้ทรัพยากรในปริมาณมาก การติดตามจะหยุดโดยอัตโนมัติใน %%days%% วัน คุณสามารถปิดใช้งานด้วยตนเองได้ทุกเมื่อที่คุณต้องการ',
    'failed-request.enable-tracing.statusCodes' => 'รหัสสถานะ',
    'failed-request.enable-tracing.statusCodesDescription' => 'ตัวอย่าง: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'ผู้ให้บริการ',

    'file-manager.show.buttonReload' => 'โหลดใหม่',
    'file-manager.show.buttonSave' => 'บันทึก',
    'file-manager.show.buttonSaveAs' => 'บันทึกเป็น',
    'file-manager.show.buttonReset' => 'รีเซ็ต',
    'file-manager.show.buttonTextCodeEditor' => 'แก้ไขในโปรแกรมแก้ไขรหัส',
    'file-manager.show.buttonTextEdit' => 'แก้ไขในโปรแกรมแก้ไขข้อความ',
    'file-manager.show.buttonWysiwygEdit' => 'แก้ไขในโปรแกรมแก้ไข HTML',
    'file-manager.show.eolLabel' => 'ประเภทของการพักบรรทัด:',
    'file-manager.show.saveAs' => 'บันทึกเป็น:',
    'file-manager.show.saveCodepage' => 'บันทึกในการเข้ารหัสดังต่อไปนี้:',
    'file-manager.show.loadCodepage' => 'ดูไฟล์ต้นฉบับได้ในการเข้ารหัสดังต่อไปนี้:',
    'file-manager.show.loadCodepageHint' => 'คำเตือน: การเปลี่ยนแปลงใดๆ ที่ไม่ได้บันทึกอาจสูญหายระหว่างการโหลดไฟล์ใหม่',
    'file-manager.show.fileExists' => "มีไฟล์หรือโฟลเดอร์ %%fileName%% อยู่แล้ว ไม่สามารถมีโฟลเดอร์และไฟล์ที่เป็นชื่อเดียวกันได้",
    'file-manager.show.popupTitle' => 'บันทึกเป็น',
    'file-manager.show.popupFilename' => 'ชื่อไฟล์:',

    'file-manager.permissions.filePermissions' => 'การอนุญาตการเข้าถึงไฟล์',
    'file-manager.permissions.directoryPermissions' => 'การอนุญาตการเข้าถึงข้อมูลไดเรกทอรี',
    'file-manager.permissions.buttonSubmit' => 'บันทึก',
    'file-manager.permissions.buttonApply' => 'บันทึกและดำเนินการต่อ',
    'file-manager.permissions.buttonCancel' => 'ยกเลิก',
    'file-manager.permissions.buttonAdvanced' => 'ขั้นสูง',

    'file-manager.unix-file-permissions.group' => 'กลุ่ม',
    'file-manager.unix-file-permissions.owner' => 'เจ้าของ',
    'file-manager.unix-file-permissions.others' => 'อื่นๆ',
    'file-manager.unix-file-permissions.readMode' => 'อ่าน',
    'file-manager.unix-file-permissions.writeMode' => 'เขียน',
    'file-manager.unix-file-permissions.execMode' => 'ดำเนินการ/ค้นหา',
    'file-manager.unix-file-permissions.changeRecursive' => 'เปลี่ยนค่าการอนุญาตการเรียกซ้ำ',

    'file-manager.windows-permissions.allow' => 'อนุญาต',
    'file-manager.windows-permissions.deny' => 'ปฏิเสธ',
    'file-manager.windows-permissions.inheritFromParent' => 'อนุญาตให้ใช้สิทธิ์ในการส่งต่อจากเครื่องหลักเพื่อเผยแพร่ไปยังเครื่องนี้และเครื่องรองทั้งหมดได้ รวมทั้งหมดนี้กับรายการที่กำหนดไว้แล้วที่นี่อย่างชัดเจน',
    'file-manager.windows-permissions.replaceOnChildren' => 'แทนที่รายการที่ได้รับอนุญาตบนเครื่องรองทั้งหมดด้วยรายการที่แสดงที่นี่',
    'file-manager.windows-permissions.buttonAdvanced' => 'ขั้นสูง',
    'file-manager.windows-permissions.applyTo' => 'นำไปใช้กับ:',
    'file-manager.windows-permissions.folderOnly' => 'โฟลเดอร์นี้เท่านั้น',
    'file-manager.windows-permissions.subfolderOnly' => 'ซับโฟลเดอร์เท่านั้น',
    'file-manager.windows-permissions.filesOnly' => 'ไฟล์เท่านั้น',
    'file-manager.windows-permissions.permissionsFor' => 'อนุญาตสำหรับ',
    'file-manager.windows-permissions.applyOnto1' => 'โฟลเดอร์นี้เท่านั้น',
    'file-manager.windows-permissions.applyOnto2' => 'ซับโฟลเดอร์เท่านั้น',
    'file-manager.windows-permissions.applyOnto3' => 'โฟลเดอร์และซับโฟลเดอร์นี้',
    'file-manager.windows-permissions.applyOnto4' => 'ไฟล์เท่านั้น',
    'file-manager.windows-permissions.applyOnto5' => 'โฟลเดอร์และไฟล์นี้',
    'file-manager.windows-permissions.applyOnto6' => 'ซับโฟลเดอร์และไฟล์เท่านั้น',
    'file-manager.windows-permissions.applyOnto7' => 'โฟลเดอร์ ซับโฟลเดอร์ และไฟล์นี้',
    'file-manager.windows-permissions.notInherited' => '<ไม่ได้รับช่วงต่อ>',

    'file-manager.editor.titleTextEditor' => 'โปรแกรมแก้ไขข้อความ',
    'file-manager.editor.titleCodeEditor' => 'โปรแกรมแก้ไขรหัส',
    'file-manager.editor.titleCodeViewer' => 'ดู',
    'file-manager.editor.buttonSubmit' => 'บันทึก',
    'file-manager.editor.buttonApply' => 'บันทึกและดำเนินการต่อ',
    'file-manager.editor.buttonSaveAs' => 'บันทึกเป็น...',
    'file-manager.editor.buttonCancel' => 'ยกเลิก',
    'file-manager.editor.exitConfirmationYes' => 'ใช่',
    'file-manager.editor.exitConfirmationNo' => 'ไม่',
    'file-manager.editor.fileOverwrite' => 'มีไฟล์อยู่แล้ว',
    'file-manager.editor.fileOverwriteDescription' => 'มีไดเร็กทอรี่ชื่อนี้อยู่แล้ว คุณต้องการเขียนทับหรือไม่่?',
    'file-manager.editor.exitConfirmation' => 'คุณแน่ใจว่าต้องการปิดไฟล์และยกเลิกการเปลี่ยนแปลงที่ยังไม่ได้บันทึกหรือไม่',
    'file-manager.editor.buttonCodeEditor' => 'แก้ไขในโปรแกรมแก้ไขรหัส',
    'file-manager.editor.buttonTextEditor' => 'แก้ไขในโปรแกรมแก้ไขข้อความ',
    'file-manager.editor.buttonHtmlEditor' => 'แก้ไขในโปรแกรมแก้ไข HTML',

    'file-manager.import-file.buttonSubmit' => 'นำเข้า',
    'file-manager.import-file.fieldUrl' => 'URL สำหรับไฟล์',
    'file-manager.import-file.fieldUrlDescription' => 'ระบุแหล่งข้อมูล URL ตัวอย่างเช่น, \'https://example.com/example.tgz\'',
    'file-manager.import-file.fieldUrlFullDescription' => 'รูปแบบเต็มของ URL คือ: \'https://user:password@example.com/example.tgz\' ชื่อและรหัสผ่านของผู้ใช้เป็นเพียงทางเลือก โปรโตคอลที่สนับสนุนคือ http, https, ftp, ftps ใช้การเข้ารหัส URL สำหรับส่วนของ URL ที่ประกอบด้วยตัวอักขระพิเศษหรือช่องว่าง',
    'file-manager.import-file.failure' => 'ไม่สามารถนำเข้าไฟล์ได้',

    'file-manager.rotation-settings.title' => 'การตั้งค่าการหมุนบันทึกรีไซเคิลบิน',
    'file-manager.rotation-settings.rotationBySize' => 'การหมุนบันทึกตามขนาด',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'ตัวเลือกลบไฟล์ใหม่เมื่อรีไซเคิลบินมีข้อมูลเกินขีดจำกัดที่ระบุไว้',
    'file-manager.rotation-settings.rotationByDate' => 'การหมุนบันทึกตามวันที่',
    'file-manager.rotation-settings.rotationByDateUnits' => 'วัน',
    'file-manager.rotation-settings.rotationByDateHint' => 'ตัวเลือกจะลบไฟล์ที่เก็บไว้ในรีไซเคิลบินนานเกินจำนวนวันที่ระบุไว้',
    'file-manager.rotation-settings.save' => 'บันทึก',
    'file-manager.rotation-settings.cancel' => 'ยกเลิก',

    'ftp-user.description' => 'หากคุณใช้งานเว็บไซต์ของคุณร่วมกับบุคคลอื่นหรือโดเมนย่อยโฮสต์ของผู้ใช้อื่น คุณต้องสร้างบัญชี FTP แยกสำหรับผู้ใช้อื่น',
    'ftp-user.generalSection' => 'ทั่วไป',
    'ftp-user.login' => 'ชื่อบัญชี FTP',
    'ftp-user.home' => 'ไดเร็กทอรี่หลัก',
    'ftp-user.systemArea' => 'สร้างบัญชี FTP ที่สามารถเข้าถึงไฟล์ที่อยู่ภายนอกไดเร็กทอรี่หลักได้',
    'ftp-user.password' => 'รหัสผ่าน',
    'ftp-user.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'ftp-user.hardQuotaSection' => 'โควต้าฮาร์ดดิสก์',
    'ftp-user.hardQuota' => 'โควต้าฮาร์ดดิสก์',
    'ftp-user.hardQuotaUnlimited' => 'ไม่จำกัด',
    'ftp-user.permissionsSection' => 'การอนุญาต',
    'ftp-user.permissionRead' => 'อ่านการอนุญาต',
    'ftp-user.permissionWrite' => 'เขียนการอนุญาต',
    'ftp-user.popupTitle' => 'เลือกไดเร็กทอรี่',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'ที่อยู่ในรายการส่งจดหมาย',
    'mail-list.enabled' => 'เปิด',
    'mail-list.administratorEmail' => 'อีเมลของผู้ดูแลรายชื่อผู้รับจดหมาย',
    'mail-list.password' => 'รหัสผ่าน',
    'mail-list.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'mail-list.subscribers' => 'สมาชิก',
    'mail-list.subscribersHint' => 'ระบุที่อยู่อีเมล คุณต้องพิมพ์ที่อยู่แต่ละที่บนบรรทัดใหม่ หรือแยกที่อยู่ด้วยการเว้นวรรค เครื่องหมายจุลภาค หรือเครื่องหมายอัฒภาค',
    'mail-list.notify' => 'แจ้งเตือนผู้ดูแลระบบเกี่ยวกับการสร้างรายชื่อผู้รับจดหมาย',
    'mail-list.emptyPassword' => 'ระบุรหัสผ่าน',
    'mail-list.emptyPasswordConfirmation' => 'กรุณายืนยันรหัสผ่าน',
    'mail-list.errorSubscribers' => 'ที่อยู่อีเมลไม่ถูกต้อง: %value%',
    'mail-list.errorMaillistReserved' => 'มีการใช้งานที่อยู่ในรายการส่งจดหมายที่ระบุแล้ว',

    'mail-settings.copyToClipboard' => 'คัดลอกเรคคอร์ด DNS ไปยังคลิปบอร์ด',
    'mail-settings.copySuccess' => 'คัดลอกเรคคอร์ด DNS ไปยังคลิปบอร์ดแล้ว',
    'mail-settings.hint' => 'คุณสามารถเปลี่ยนการตั้งค่าบริการเมลสำหรับโดเมนนี้ได้ที่นี่',
    'mail-settings.service' => 'บริการเมลบนโดเมนนี้',
    'mail-settings.nonExist' => 'ต้องทำอย่างไรกับเมลสำหรับผู้ใช้ที่ไม่มีอยู่จริง',
    'mail-settings.nonExistBounceWithMessage' => 'ตีกลับด้วยข้อความ',
    'mail-settings.nonExistBounce' => 'เด้งกลับ',
    'mail-settings.nonExistCatch' => 'ส่งต่อไปยังที่อยู่',
    'mail-settings.nonExistCatchDescription' => 'ที่อยู่จะต้องเป็นของโดเมนที่เลือกไว้ เฉพาะผู้ดูแลระบบเท่านั้นที่สามารถกำหนดที่อยู่ภายนอกหรือหนึ่งที่อยู่สำหรับหลายโดเมนได้',
    'mail-settings.nonExistExternal' => 'เปลี่ยนเส้นทางไปยังเซิร์ฟเวอร์เมลภายนอกโดยใช้ที่อยู่ IP',
    'mail-settings.nonExistReject' => 'ปฏิเสธ',
    'mail-settings.nonExistDiscard' => 'ปฏิเสธ',
    'mail-settings.webmail' => 'เว็บเมล',
    'mail-settings.webmailNone' => 'ไม่มี',
    'mail-settings.webmailComponentNotInstalled' => 'ไม่มีการติดตั้งส่วนประกอบเว็บเมล',
    'mail-settings.webmailSubdomainAlreadyExists' => 'มีโดเมนย่อยชื่อ %%subdomain%%',
    'mail-settings.webmailCertificate' => 'การรับรอง SSL/TLS สำหรับเว็บเมล',
    'mail-settings.webmailCertificateNone' => 'ไม่ได้เลือก',
    'mail-settings.mailCertificate' => 'การรับรอง SSL/TLS สำหรับเว็บเมล',
    'mail-settings.mailCertificateNone' => 'ไม่ได้เลือก',
    'mail-settings.serverCertificateNotSelected' => 'มอบหมายใบรับรองแล้วแต่เมลสำหรับโดเมนไม่มีความปลอดภัย หากต้องการรักษาความปลอดภัยของเมลสำหรับโดเมน %%certLink%%',
    'mail-settings.serverCertificatesList' => 'รักษาความปลอดภัยให้กับเมลเซิร์ฟเวอร์',
    'mail-settings.mailLists' => 'ใช้รายชื่อผู้รับจดหมาย',
    'mail-settings.mailAutodiscovery' => 'เปิดใช้งานการค้นหาเมลอัตโนมัติ',
    'mail-settings.mailAutodiscoveryDescription' => 'ดูวิธีการทำงานใน %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'ฐานความรู้',
    'mail-settings.domainKeys' => 'ใช้ระบบการป้องกันสแปม DKIM เพื่อทำเครื่องหมายในข้อความอีเมลขาออก',
    'mail-settings.activeDkimSelector' => 'ตัวเลือก DKIM ที่ใช้งานอยู่',
    'mail-settings.defaultDkimSelector' => ' (ค่าเริ่มต้น Plesk)',
    'mail-settings.dkimSelectorName' => 'ชื่อตัวเลือก',
    'mail-settings.buttonCreateSelector' => 'สร้างตัวเลือก DKIM ใหม่',
    'mail-settings.createSelectorDialogTitle' => 'สร้างตัวเลือก DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'ลบตัวเลือก DKIM',
    'mail-settings.removeSelectorConfirmation' => "ต้องการลบตัวเลือก '%%selector%%' รวมถึงรหัสและบันทึก DNS หรือไม่?",
    'mail-settings.buttonConfirm' => 'ตกลง',
    'mail-settings.buttonCreate' => 'สร้าง',
    'mail-settings.buttonCancel' => 'ยกเลิก',
    'mail-settings.labelRemoveSelector' => 'ลบ',
    'mail-settings.labelActiveSelector' => 'ใช้งานอยู่',
    'mail-settings.greyListing' => 'เปิดการป้องกันสแปมเกรย์ลิสติ้งสำหรับบัญชีเมลทั้งหมดในโดเมนนี้',
    'mail-settings.howToConfigureExternalDns' => 'วิธีกำหนดค่า DNS ภายนอก',
    'mail-settings.howToConfigureExternalDnsAlways' => 'เพื่อเปิดใช้งานโปรโตคอล DKIM หากคุณใช้เซิร์ฟเวอร์ DNS ภายนอก คุณจะต้องกำหนดค่า DKIM ในระเบียน DNS บนเซิร์ฟเวอร์ DNS ด้วยตนเอง',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'เพื่อดำเนินการนี้ โปรดใช้ DKIM ในระเบียน DNS ต่อไปนี้:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'หากคุณมีนามแฝงโดเมนที่ใช้ในการส่งเมล เพิ่ม DKIM ลงในระเบียน DNS สำหรับโดเมนเหล่านั้นด้วย ใช้ระเบียนเดียวกันกับโดเมนหลักแต่เป็นชื่อนามแฝงโดเมน',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'เพื่อดู DKIM ในระเบียน DNS คุณจะต้องทำการกำหนดค่า เลือก "%%option%%" กล่องเครื่องหมาย เปิดใช้งานและเปิด ป๊อปอัพนี้ใหม่อีกครั้ง',
    'mail-settings.mailServiceDisabled' => 'ปิดใช้งาน',
    'mail-settings.mailServiceDisabledIncoming' => 'ปิดใช้สำหรับจดหมายขาเข้า',
    'mail-settings.mailServiceDisabledHint' => 'Plesk จะไม่ให้บริการเมลใดๆ บนโดเมนนี้',
    'mail-settings.mailServiceDisabledIncomingHint' => 'โดเมนนี้ใช้ Sendmail เท่านั้นและใช้ Sendmail ได้อย่างเดียวเท่านั้น',
    'mail-settings.mailServiceEnabled' => 'เปิดใช้งาน',
    'mail-settings.mailServiceEnabledHint' => 'โดเมนนี้ใช้ส่งและรับอีเมลได้',
    'mail-settings.mailServiceNotConfigured' => 'ไม่ได้กำหนดค่า',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk จะไม่ให้บริการเมลใดๆ บนโดเมนนี้',
    'mail-settings.warning' => 'การดำเนินการนี้จะลบกล่องจดหมายของโดเมนพร้อมกับอีเมลที่ได้รับและส่งไปด้วย',
    'mail-settings.show.title' => 'ลบกล่องจดหมายและอีเมลทั้งหมดของโดเมน %%domain%%',
    'mail-settings.show.checkbox' => 'ลบกล่องจดหมายทั้งหมดของโดเมน <b>%%domain%%</b> แล้ว รวมถึงอีเมลที่ได้รับหรือส่งไปด้วย',

    'role.roleSection' => 'ทั่วไป',
    'role.name' => 'ชื่อบทบาทผู้ใช้',
    'role.description' => 'รายละเอียด',
    'role.generalPermissionsSection' => 'การเข้าถึงบริการของ Plesk',
    'role.applicationsAccessSection' => 'เข้าใช้งานแอพ',
    'role.permissionAllow' => 'ได้รับ',
    'role.permissionDeny' => 'ถูกปฏิเสธ',
    'role.emptyRoleName' => 'โปรดระบุชื่อบทบาท',
    'role.installedAt' => 'ติดตั้งที่',
    'role.noInstallationUrlAvailable' => 'แอพภายนอก',
    'role.invalidRoleName' => 'ชื่อบทบาทผู้ใช้ที่ระบุไม่ถูกต้อง ไม่สามารถใช้เครื่องหมายคำถามและเครื่องหมายคำพูดในชื่อบทบาทได้',
    'role.longRoleName' => 'ชื่อบทบาทผู้ใช้ที่ระบุยาวเกินไป',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'อาจไม่สามารถดำเนินการบางอย่างได้ด้วยเหตุผลดังต่อไปนี้: การอนุญาตให้ดำเนินการไม่ได้รับการยอมรับโดยการสมัครที่เลือกไว้ในขณะนี้ หรือปริมาณของทรัพยากรที่จัดสรรไว้มีไม่เพียงพอที่จะดำเนินการ',
    'role.servicesPermissionsDescription' => 'กำหนดการเข้าถึงแอพที่ติดตั้งไว้หรือบริการ Plesk สำหรับผู้ใช้ทุกคนด้วยบทบาทนี้ หากคุณยอมรับการเข้าถึงแอพของผู้ใช้ ผู้ใช้เหล่านั้นจะสามารถใช้งานแอพได้ที่แผงการจัดการลูกค้า',
    'role.emailActivation' => 'เปิดใช้งานบัญชีของบทบาทนี้ทางอีเมล',

    'service.admin-access.adminAccess' => 'การเข้าถึงการจัดการระบบ',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'จะใช้หลักฐานเหล่านี้เพื่อการเข้าถึงการจัดการระบบของแอพพลิเคชั่นนี้',
    'service.admin-access.login' => 'ชื่อผู้ใช้ในการจัดการระบบ',
    'service.admin-access.password' => 'รหัสผ่านการจัดการ',
    'service.admin-access.passwordConfirmation' => 'ยืนยันรหัสผ่าน',

    'service.info.service-entry-point.availableAt' => 'มีอยู่ที่',
    'service.info.service-entry-point.customize' => 'ปรับแต่งชอร์ทคัต',
    'service.info.service-entry-point.displayNameLabel' => 'ชื่อชอร์ทคัต',
    'service.info.service-entry-point.displayNameDescription' => 'ระบุชื่อของชอร์ทคัตนี้ ชื่อนี้จะแสดงอยู่ใต้ไอคอนชอร์ทคัต ชอร์ทคัตจะอยู่บนหน้า My Services ของผู้ใช้ที่ได้รับสิทธิ์ในการเข้าถึงแอพพลิเคชั่น',
    'service.info.service-entry-point.descriptionLabel' => 'รายละเอียดชอร์ทคัต',
    'service.info.service-entry-point.descriptionDescription' => 'ระบุรายละเอียดเกี่ยวกับชอร์ทคัตนี้ เมื่อเมาส์เคอร์เซอร์เลื่อนผ่านชอร์ทคัตจะมีการแสดงรายละเอียดในคำแนะนำ',
    'service.info.service-entry-point.iconLabel' => 'คลิกเพื่อเลือกไอคอนชอร์ทคัต',
    'service.info.service-entry-point.iconCurrent' => 'ไอคอนในปัจจุบัน',
    'service.info.service-entry-point.errorEmptyName' => 'คุณต้องระบุชื่อชอร์ทคัต',
    'service.info.service-entry-point.errorLongName' => 'ชื่อชอร์ทคัตควรมีอักขระระหว่าง 1 ถึง 255 ตัว',
    'service.info.service-entry-point.errorLongDescription' => 'รายละเอียดชอร์ทคัตควรมีอักขระระหว่าง 0 ถึง 255 ตัว',
    'service.info.service-entry-point.hiddenLabel' => 'ซ่อนชอร์ทคัต',
    'service.info.service-entry-point.hiddenDescription' => 'ห้ามแสดงชอร์ทคัตนี้แก่ผู้ใช้',

    'service.info.service-permission.assignedUser' => "ให้สิทธิ์การเข้าถึงของผู้ดูแลระบบแก่ผู้ใช้รายนี้",
    'service.info.service-permission.assignedUserNone' => 'ไม่มีการกำหนดผู้ใช้',

    'shared-ssl.master-ssl.switchedOn' => 'เปิด SSL/TLS ที่แบ่งปัน',
    'shared-ssl.master-ssl.domainName' => 'มีการแชร์ชื่อโดเมนของไซต์ที่มีการรับรอง SSL/TLS กับไซต์อื่นๆ',
    'shared-ssl.master-ssl.none' => 'ไม่มี',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'ไมสามารถเปิดแชร์ SSL/TLS ได้เพราะไม่มีโดเมนที่สามารถเปิดใช้งานการสนับสนุน SSL/TLS ได้',

    'user.email.email' => 'ที่อยู่อีเมล',
    'user.email.emptyEmail' => 'คุณต้องระบุที่อยู่อีเมล',
    'user.email.internalEmailHint' => 'สร้างที่อยู่อีเมลใหม่ใน Plesk หรือใช้ที่อยู่อีเมลภายนอก',
    'user.email.longInternalEmail' => 'ที่อยู่อีเมลยาวเกินไป',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'ส่วนของชื่อผู้ใช้ของที่อยู่อีเมลมีความยาวเกินไปสำหรับเซิร์ฟเวอร์เมลนี้ กรุณาระบุชื่อผู้ใช้ให้มีความยาวไม่เกิน %%max%% อักขระ',
    'user.email.longInternalEmailFullAddressMailServer' => 'ที่อยู่อีเมลยาวเกินไปสำหรับเซิร์ฟเวอร์เมลนี้ โปรดระบุที่อยู่ให้มีความยาวไม่เกิน %%max%% อักขระ',
    'user.email.externalEmail' => 'ที่อยู่อีเมลภายนอก',
    'user.email.externalEmailHint' => 'จะใช้ในการรีเซตรหัสผ่านของคุณ หากคุณสูญเสียสิทธิในการเข้าถึงที่อยู่อีเมลหลัก',
    'user.email.emailsIsEqual' => 'ที่อยู่อีเมลภายนอกตรงกับอีเมลหลัก ระบุที่อยู่อีเมลภายนอกที่แตกต่างกัน',
    'user.email.atLeastOneEmailShouldBeSet' => 'โปรดระบุที่อยู่อีเมลทั้งภายในและภายนอก',

    'user.profileSection' => 'ข้อมูลทั่วไป',
    'user.contactName' => 'ชื่อผู้ติดต่อ',
    'user.email' => 'ที่อยู่อีเมล',
    'user.role' => 'บทบาทของผู้ใช้',
    'user.accountSection' => 'การปรับตั้งค่า Plesk',
    'user.login' => 'ชื่อผู้ใช้',
    'user.password' => 'รหัสผ่าน',
    'user.oldPassword' => 'รหัสผ่านเก่า',
    'user.buttonBack' => 'กลับ',
    'user.generalTab' => 'ทั่วไป',
    'user.applicationsAccessSection' => 'บริการ',
    'user.generalPermissionsSection' => 'เอกสิทธิ์',
    'user.contactsTab' => 'รายละเอียดผู้ติดต่อ',
    'user.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'user.internalEmailPasswordChanged' => 'การเปลี่ยนรหัสผ่านจะทำให้รหัสผ่านของที่อยู่อีเมลภายในระบบเปลี่ยนด้วย',
    'user.emailName' => 'ที่อยู่อีเมล',
    'user.emailType' => 'ประเภทอีเมล',
    'user.companyName' => 'ชื่อบริษัท',
    'user.phone' => 'หมายเลขโทรศัพท์',
    'user.imNumber' => 'การส่งข้อความเร่งด่วน',
    'user.fax' => 'หมายเลขโทรสาร',
    'user.address' => 'ที่อยู่',
    'user.city' => 'เมือง',
    'user.state' => 'รัฐหรือจังหวัด',
    'user.zip' => 'ไปรษณีย์หรือรหัสไปรษณีย์',
    'user.country' => 'ประเทศ',
    'user.additionalInfo' => 'ข้อมูลเพิ่มเติม',
    'user.additionalInfoHint' => 'ข้อความตัวอักษรเท่านั้น: แท็ก HTML ทั้งหมดจะได้รับการเพิกเฉย',
    'user.language' => 'ภาษา Plesk',
    'user.buttonChangePassword' => 'เปลี่ยนรหัสผ่าน',
    'user.permissionAllow' => 'ได้รับ',
    'user.permissionDeny' => 'ถูกปฏิเสธ',
    'user.permissionInherited' => 'กำหนดโดยบทบาท',
    'user.emptyContactName' => 'คุณต้องระบุชื่อผู้ติดต่อ',
    'user.emptyLogin' => 'คุณต้องระบุชื่อผู้ใช้',
    'user.emptyPassword' => 'คุณต้องระบุรหัสผ่าน',
    'user.emptyPasswordConfirmation' => 'คุณต้องยืนยันรหัสผ่าน',
    'user.oldPasswordIsIncorrect' => 'รหัสผ่านเก่าไม่ถูกต้อง โปรดลองใหม่อีกครั้ง',
    'user.chooseDomainBoxTitle' => 'เลือกโดเมนอื่น:',
    'user.userIsActive' => 'ผู้ใช้ที่ใช้งานอยู่',
    'user.userIsActiveHint' => 'ผู้ใช้ที่ใช้งานอยู่สามารถเข้า Plesk ได้',
    'user.emailActivation' => 'เปิดใช้งานบัญชีทางอีเมล',
    'user.emailHint' => 'เพื่อจัดทำที่อยู่อีเมลของโฮสต์บนเซิร์ฟเวอร์นี้ให้แก่ผู้ใช้ ไปที่แท็บเมลแล้วสร้างที่อยู่อีเมลที่กำหนดและเชื่อมโยงที่อยู่อีเมลนั้นเข้ากับผู้ใช้รายนี้',
    'user.emailContactHint' => 'ติดต่อผู้ให้บริการของคุณหากคุณต้องการใช้ที่อยู่อีเมลที่โฮสต์บนเซิร์ฟเวอร์นี้',
    'user.personalEmailHint' => "สามารถเปลี่ยนที่อยู่อีเมลของผู้ใช้นี้ได้ที่แท็บเมล",
    'user.externalMailRedirectHint' => 'การส่งต่อสามารถใช้งานได้เฉพาะที่อยู่อีเมลที่โฮสต์บนเซิร์ฟเวอร์นี้เท่านั้น ไปที่แท็บเมลเพื่อสร้างที่อยู่อีเมล',
    'user.externalMailRedirectHint2' => 'การส่งต่อสามารถใช้งานได้เฉพาะที่อยู่อีเมลที่โฮสต์บนเซิร์ฟเวอร์นี้เท่านั้น',
    'user.externalMailAutoResponderHint' => 'การตอบกลับอัตโนมัติสามารถใช้งานได้เฉพาะที่อยู่อีเมลที่โฮสต์บนเซิร์ฟเวอร์นี้เท่านั้น ไปที่แท็บเมลเพื่อสร้างที่อยู่อีเมล',
    'user.externalMailAutoResponderHint2' => 'การตอบกลับอัตโนมัติสามารถใช้งานได้เฉพาะที่อยู่อีเมลที่โฮสต์บนเซิร์ฟเวอร์นี้เท่านั้น',
    'user.roleHint' => 'บทบาทของผู้ใช้ให้สิทธิ์ในการจัดการแก่ผู้ใช้และยังเข้าถึงแอพพลิเคชั่นที่คุณเลือกในบทบาทนั้นด้วย',
    'user.cannotManageMail' => "คุณไม่ได้รับอนุญาตให้จัดการกับการตั้งค่าเมลและบริการ",
    'user.longCompanyName' => 'ชื่อบริษัทที่ระบุยาวเกินไป',
    'user.longPhone' => 'หมายเลขโทรศัพท์ที่ระบุยาวเกินไป',
    'user.longFax' => 'หมายเลขโทรสารที่ระบุยาวเกินไป',
    'user.longAddress' => 'ที่อยู่ที่ระบุยาวเกินไป',
    'user.longCity' => 'ชื่อเมืองที่ระบุยาวเกินไป',
    'user.phoneRegexNotMatch' => 'หมายเลขโทรศัพท์ที่ระบุไม่ถูกต้อง',
    'user.faxRegexNotMatch' => 'หมายเลขโทรสารที่ระบุไม่ถูกต้อง',
    'user.shortCity' => 'ชื่อเมืองที่ระบุสั้นเกินไป',
    'user.limitSubscription' => 'เข้าถึงการสมัคร',
    'user.limitSubscriptionHint' => 'อนุญาตให้ผู้ใช้สามารถเข้าถึงได้เฉพาะการสมัครที่กำหนดไว้ ค่า "ทั้งหมด" ให้สิทธิ์ในการเข้าถึงทุกๆ การสมัครภายในบัญชีโฮสติ้งของคุณ',
    'user.limitSubscriptionAll' => 'ทั้งหมด',
    'user.deletedSubscription' => 'ลบการสมัคร',

    'web.add-domain-alias.title' => 'เพิ่มนามแฝงโดเมน',
    'web.add-domain-alias.createdSuccessfully' => "สร้างนามแฝงโดเมน %%name%%",
    'web.add-domain-alias.domainAliasName' => 'ชื่อนามแฝงโดเมน',
    'web.add-domain-alias.domainAliasNameHint' => 'เช่น example.net',
    'web.add-domain-alias.forDomain' => 'สำหรับโดเมน',
    'web.add-domain-alias.settingsSectionLegend' => 'การตั้งค่า',
    'web.add-domain-alias.settingsDns' => 'ประสานงาน โซน DNSกับโดเมนหลัก',
    'web.add-domain-alias.settingsMail' => 'บริการเมล',
    'web.add-domain-alias.settingsWeb' => 'บริการเว็บ',
    'web.add-domain-alias.settingsSeoRedirect' => 'เปลี่ยนเส้นทางโดยใช้รหัส HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'เมื่อผู้เข้าชมเปิด URL ของนามแฝงก็จะเปลี่ยนเส้นทางไปยัง URL ของโดเมนหลัก Plesk ใช้การเปลี่ยนเส้นทางเครื่องมือค้นหาอย่างง่าย HTTP 301 ซึ่งหมายความว่าการจัดอันดับเครื่องมือค้นหาไม่สามารถแบ่ง URL ได้',
    'web.add-domain-alias.settingsTomcat' => 'แอพพลิเคชั่นจาวาเว็บ',
    'web.add-domain-alias.invalidDomainGuid' => 'โดเมนไม่ถูกต้อง',

    'web.add-domain.formTitle' => 'กำลังเพิ่มโดเมนใหม่',
    'web.add-domain.portalLink' => 'บริการพอร์ทัล',
    'web.add-domain.domainName' => 'ชื่อโดเมน',
    'web.add-domain.domainNameHint' => "เช่น example.com",
    'web.add-domain.assignToCustomer' => 'กำหนดโดเมนนี้ไปยังลูกค้า',
    'web.add-domain.customer' => 'เลือกลูกค้า',
    'web.add-domain.createNewCustomer' => 'สร้างลูกค้าใหม่',
    'web.add-domain.selectExistingCustomer' => 'เลือกลูกค้าที่มีอยู่:',
    'web.add-domain.customerContactInfoHint' => 'ป้อนข้อมูลติดต่อของลูกค้า คุณสามารถระบุข้อมูลต่างๆ เช่น หมายเลขโทรศัพท์ และที่อยู่ได้ในภายหลัง',
    'web.add-domain.customerLoginInfoHint' => 'ข้อมูลประจำตัวสำหรับแผงข้อมูลลูกค้า',
    'web.add-domain.target' => 'พื้นที่เว็บ',
    'web.add-domain.createNewTarget' => 'สร้างการสมัครสมาชิกใหม่',
    'web.add-domain.createNewTarget_powerUser' => 'สร้างพื้นที่เว็บใหม่',
    'web.add-domain.selectExistingTarget' => 'เลือกการสมัครสมาชิกที่มีอยู่:',
    'web.add-domain.selectExistingTarget_powerUser' => 'เลือกกาพื้นที่เว็บที่มีอยู่:',
    'web.add-domain.dns' => 'เปิดใช้งานบริการ DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'เปิดใช้งานบริการเมล์',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'ใช้งานได้ หากการตั้งค่าของการตอบรับยินยอมให้จัดการเมลการขออนุมัติต่อโดเมน หากไม่ได้รับความยินยอม สถานะปัจจุบันของการบริการจะถูกนำมาจากข้อตกลงในการตอบรับการเป็นสมาชิก',
    'web.add-domain.hostingManagementOptions' => 'ประเภทการโฮสต์',
    'web.add-domain.websiteHosting' => 'การโฮสต์เว็บไซต์',
    'web.add-domain.websiteForwarding' => 'การส่งต่อ',
    'web.add-domain.websiteNoHosting' => 'ไม่มีโฮสติ้ง',
    'web.add-domain.hostingSettingsSectionLegend' => 'การตั้งค่าโฮสติ้ง',
    'web.add-domain.domainCreatedSuccessfully' => 'สร้างโดเมน %%domainName%% เสร็จสมบูรณ์แล้ว',
    'web.add-domain.webspaceLegend' => 'การตั้งค่าพื้นที่เว็บ',
    'web.add-domain.addWhmWebsiteTitle' => 'การเพิ่มเว็บไซต์ใหม่',
    'web.add-domain.addWhmWebsiteHint' => "คุณสามารถเลือกเพื่อโฮสต์เว็บไซต์บนเซิร์ฟเวอร์ได้",
    'web.add-domain.selectWhmDomain' => 'เลือกโดเมน',
    'web.add-domain.customerLegend' => 'ข้อมูลลูกค้า',
    'web.add-domain.credentials' => 'ข้อมูลประจำตัวของผู้ใช้ระบบ',
    'web.add-domain.credentialsHint' => 'เพื่อเข้าถึงไฟล์ที่โฮสต์แล้วผ่าน FTP และ SSH',
    'web.add-domain.credentialsHintWin' => 'เพื่อเข้าถึงไฟล์ที่โฮสต์ผ่าน FTP และ RDP',
    'web.add-domain.buttonAddDomain' => 'เพิ่มโดเมน',

    'web.add-subdomain.formTitle' => 'เพิ่มโดเมนย่อย',
    'web.add-subdomain.formGeneralHint' => 'โดเมนย่อยคือที่อยู่อินเตอร์เน็ตของส่วนที่ต่างกันบนเว็บไซต์ของคุณ ซึ่งใช้ชื่อโดเมนหลักและส่วนต้น ตัวอย่างเช่น หากชื่อโดเมนของคุณคือ domain.com ชื่อโดเมนย่อยของคุณอาจเป็น store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'คุณสามารถสร้างสัญลักษณ์แทนโดเมนย่อยได้โดยการป้อนสัญลักษณ์ * แทนชื่อ จะเปลี่ยนเส้นทางผู้เยี่ยมชมไซต์ไปที่โดเมนย่อยนี้แทนโดยไม่คำนึงถึงชื่อของโดเมนย่อยที่ป้อนลงในเบราเซอร์',
    'web.add-subdomain.subdomainName' => 'ชื่อโดเมนย่อย',
    'web.add-subdomain.subdomainNameHint' => 'ป้อน * เพื่อสร้างตัวแทนของโดเมนย่อย',
    'web.add-subdomain.forDomain' => 'โดเมนหลัก',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'สร้างโดเมนย่อยแล้ว',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'การตั้งค่าโฮสติ้ง',

    'web.setupService.formTitle' => 'บริการการตั้งค่า: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'อัพเดตบริการ \'%%serviceReference%%\' สำเร็จแล้ว',

    'web.site-copy.subdomainsGroup' => 'โดเมนย่อย %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'คัดลอกปลายทาง',
    'web.site-copy.destinationType' => 'เลือกว่าต้องการคัดลอกไฟล์ไซต์ไปที่ใด',
    'web.site-copy.destinationTypeSite' => 'เว็บไซต์ใน Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'คัดลอกไฟล์ไซต์ไปยังไซต์อื่นบนโฮสต์ของคุณที่อยู่ในบัญชีนี้ ใช้งานตัวเลือกพื้นที่จัดเก็บข้อมูล FTP หากคุณมีการเข้าถึง FTP ของบัญชีอื่นบนเซิร์ฟเวอร์นี้',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'คัดลอกไฟล์ไซต์ไปยังไซต์อื่นที่โฮสต์อยู่บนเซิร์ฟเวอร์นี้',
    'web.site-copy.destinationTypeSiteSelect' => 'ชื่อไซต์',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "ไม่สามารถคัดลอกไฟล์ %%source%% ไปยัง %%destination%% ได้เพราะว่า %%destination%% เป็นส่วนหนึ่งของไฟล์นั้นอยู่แล้ว — รูทของเอกสารนั้นคือซับไดเร็กทอรี่ของรูทเอกสาร %%source%%",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "ไม่สามารถลบไฟล์ของไซต์ %%destination%% ได้เพราะไฟล์ %%source%% เป็นส่วนหนึ่งของไซต์ปลายทาง — รูทเอกสาร %%source%% คือซับไดเร็กทอรี่ของ %%destination%%",
    'web.site-copy.destinationTypeFtp' => 'พื้นที่จัดเก็บข้อมูล FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'คัดลอกไฟล์เว็บไซต์ไปยังบัญชี FTP ที่นี่หรือที่เซิร์ฟเวอร์ภายนอก',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'คัดลอกไฟล์เว็บไซต์ไปยังบัญชี FTP ที่เซิร์ฟเวอร์ภายนอก',
    'web.site-copy.destinationTypeFtpHost' => "ชื่อโฮสต์เซิร์ฟเวอร์",
    'web.site-copy.destinationTypeFtpPort' => "พอร์ท",
    'web.site-copy.destinationTypeFtpFolder' => 'ไดเร็กทอรี่',
    'web.site-copy.destinationTypeFtpUser' => 'ชื่อผู้ใช้',
    'web.site-copy.destinationTypeFtpPassword' => 'รหัสผ่าน',
    'web.site-copy.destinationTypeFtpMode' => 'วิธีการเชื่อมต่อ FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'โหมดการใช้งาน',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'ในโหมดการใช้งาน Plesk จะส่งที่อยู่ IPและหมายเลขพอร์ทที่ยอมรับการทำงานของเซิร์ฟเวอร์ภายนอก จากนั้นเซิร์ฟเวอร์จะเริ่มต้นการเชื่อมต่อ TCP แนะนำให้ใช้งานโหมดนี้หากไฟร์วอลล์ไม่ป้องกันเซิร์ฟเวอร์การจัดการ Plesk',
    'web.site-copy.destinationTypeFtpModePassive' => 'โหมดพาสซีฟ',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'สามารถใช้พาสซีฟโหมดได้เมื่อเซิร์ฟเวอร์การจัดการ Plesk ทำงานอยู่เบื้องหลังไฟร์วอลล์และไม่รับการเชื่อมต่อ TCP ขาเข้า',
    'web.site-copy.existingFiles' => 'ต้องทำอย่างไรกับไฟล์ที่มีอยู่',
    'web.site-copy.existingFilesKeep' => 'เก็บไฟล์ที่มีอยู่ไว้ที่ไซต์ปลายทาง',
    'web.site-copy.existingFilesKeepDescription' => 'เขียนทับไฟล์ที่มีอยู่ด้วยชื่อไฟล์ที่สอดคล้องกันบนเว็บไซต์ปลายทาง',
    'web.site-copy.existingFilesDelete' => 'ลบไฟล์ที่มีทั้งหมด',
    'web.site-copy.existingFilesDeleteDescription' => 'ก่อนการคัดลอกต้องลบไฟล์ที่ไซต์่ปลายทางก่อน',
    'web.site-copy.emptyLogin' => 'ระบุชื่อผู้ใช้บัญชี FTP',
    'web.site-copy.emptyHost' => 'ระบุชื่อโฮสต์เซิร์ฟเวอร์',
    'web.site-copy.emptyPort' => 'ระบุพอร์ทโฮสต์เซิร์ฟเวอร์',
    'web.site-copy.copyInProgress' => 'คัดลอกเว็บไซต์ %%sourceName%% ไปยัง %%destinationName%% จะมีการแจ้งความคืบหน้าให้คุณทราบทางอีเมล (%%email%%)',
    'web.site-copy.unableToCopy' => 'การคัดลอกไฟล์เว็บไซต์ล้มเหลว',
    'web.site-copy.siteCopied' => 'คัดลอกไฟล์เว็บไซต์แล้ว',
    'web.site-copy.emailSubjSuccess' => 'คัดลอกไฟล์เว็บไซต์ "%%source%%"',
    'web.site-copy.emailSubjFailure' => 'การคัดลอกไฟล์เว็บไซต์ "%%source%%" ล้มเหลว',
    'web.site-copy.emailBodySuccess' => 'คัดลอกไฟล์เว็บไซต์ "%%source%%" ไปยัง "%%destination%%"',
    'web.site-copy.emailBodyFailure' => 'การคัดลอกไฟล์เว็บไซต์ "%%source%%" ไปยัง "%%destination%%" ล้มเหลว: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'การตั้งค่าการส่งต่อ',
    'web._shared.forwardDestination' => 'ที่อยู่ปลายทาง',
    'web._shared.forwardDestinationHint' => 'URL ของเว็บไซต์เป้าหมาย',
    'web._shared.forwardingTypeOptions' => 'ประเภทการส่งต่อ',
    'web._shared.forwardingFrame' => 'การส่งต่อเฟรม',
    'web._shared.forwardingFrameHint' => 'เปลี่ยนเส้นทางผู้เยี่ยมชมเว็บไซต์ไปยังไซต์อื่นๆ แต่จะไม่มีการแสดงที่อยู่ปลายทางดังนั้นผู้เยี่ยมชมจึงไม่รู้เกี่ยวกับการเปลี่ยนทิศทาง',
    'web._shared.forwardingHttpCode301' => 'ย้ายถาวร (รหัส 301)',
    'web._shared.forwardingHttpCode301Hint' => 'เปลี่ยนเส้นทางผู้เยี่ยมชมเว็บไซต์ไปยังไซต์อื่นๆ และแสดงให้ผู้เยี่ยมชมเห็นที่อยู่ปลายทาง การเปลี่ยนเส้นทางเช่นว่านั้นจะช่วยจัดอันดับเครื่องมือค้นหาเว็บไซต์',
    'web._shared.forwardingHttpCode302' => 'ย้ายชั่วคราว (รหัส 302)',
    'web._shared.forwardingHttpCode302Hint' => 'เปลี่ยนเส้นทางผู้เยี่ยมชมเว็บไซต์ไปยังการคัดลอดไซต์ชั่วคราวเมื่อคุณไม่ต้องการให้เครื่องมือค้นหาทำสารบัญเว็บไซต์ชั่วคราวนี้',
    'web._shared.documentRoot' => 'รูทเอกสาร',
    'web._shared.documentRootHint' => 'พาธไปยังไดเร็กทอรี่หลักของเว็บไซต์',
    'web._shared.documentRootHintDisabledDueApplications' => 'ไม่สามารถเปลี่ยนรูทเอกสารได้เพราะมีการติดตั้งแอพพลิเคชั่นเว็บบนเว็บไซต์นี้',
    'web._shared.ipAddress' => 'ที่อยู่ IP',
    'web._shared.shared' => 'ใช้ร่วมกัน',
    'web._shared.exclusive' => 'เฉพาะ',
    'web._shared.ipAddressHint' => "ที่อยู่ IP นี้ที่เป็นโฮสต์ของเว็บไซต์คือที่อยู่เครือข่ายของโฮสต์เสมือนจริงของเว็บไซต์",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (ที่จัดเก็บอื่น)',
    'web._shared.certificate' => 'การรับรอง',
    'web._shared.sameCertificatesHint' => 'ใช้การรับรองที่เลือกไว้กับไซต์อื่นทั้งหมดที่โฮสต์กับที่อยู่ IPเฉพาะเดียวกัน',
    'web._shared.differentCertificatesHint' => 'การสมัครนี้เกี่ยวข้องกับสองที่อยู่ IPเฉพาะด้วยสองการรับรองที่ต่างกัน การรับรองที่เลือกไว้จะเข้าไปแทนที่การรับรองที่ติดตั้งบนไซต์ที่โฮสต์กับทั้งสองที่อยู่ IP',
    'web._shared.differentIpTypesCertificateHint' => 'การสมัครนี้เกี่ยวข้องกับทั้งที่อยู่ IPแบบแชร์หนึ่งอันและแบบเฉพาะอีกหนึ่งอัน ยังมีการใช้การรับรองที่เลือกไว้กับไซต์อื่นทั้งหมดที่โฮสต์กับที่อยู่ IPเฉพาะด้วย',
    'web._shared.certificateNotSelected' => 'ไม่ได้เลือก',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'ไม่มีการรับรอง SSL/TLS ในที่จัดเก็บของคุณ เพื่อเพิ่มการรับรอง ไปที่ %%link%%',
    'web._shared.sslCertificatesRepositoryLink' => 'เพจนี้',
    'web._shared.seoRedirectDirection' => 'โดเมนที่แนะนำ',
    'web._shared.seoRedirectDirectionHint' => 'เลือก URL (ทั้งที่มีและไม่มี www. นำหน้า) ที่ผู้เยี่ยมชมเว็บจะถูกพาไปผ่านทาง SEO-safe HTTP 301 redirect',
    'web._shared.seoRedirectDirectionNone' => 'ไม่มี',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'อนุญาตให้ผู้ใช้เว็บใช้สคริปส์ได้',

    'web-user.name' => 'ชื่อผู้ใช้สำหรับการเชื่อมต่อกับเซิร์ฟเวอร์ผ่าน FTP',
    'web-user.longName' => 'ตั้งชื่อผู้ใช้ยาวเกินไป (อนุญาตความยาวสูงสุด %max% ตัว)',
    'web-user.password' => 'รหัสผ่าน',
    'web-user.passwordConfirmation' => 'ยืนยันรหัสผ่าน',
    'web-user.hardDiskQuota' => 'โควต้าฮาร์ดดิสก์',
    'web-user.hardDiskQuotaUnlimited' => 'ไม่จำกัด',
    'web-user.hardDiskQuotaIsNotSupported' => '(โควต้าฮาร์ดดิสก์ไม่รองรับ เนื่องจากการปรับตั้งค่าของระบบไฟล์เซิร์ฟเวอร์)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'รองรับ Microsoft ASP',
    'web-user.__asp_dot_net_support' => 'รองรับ Microsoft ASP.NET',
    'web-user.__ssi_support' => 'รองรับ SSI',
    'web-user.__php_support' => 'สนับสนุน PHP',
    'web-user.__cgi_support' => 'รองรับ CGI',
    'web-user.__perl_unix_support' => 'รองรับ Perl',
    'web-user.__perl_win_support' => 'รองรับ Perl',
    'web-user.__python_unix_support' => 'รองรับ Python',
    'web-user.__python_win_support' => 'รองรับ Python',
    'web-user.__fastcgi_unix_support' => 'รองรับการทำงาน FastCGI',
    'web-user.__webstat_support' => 'สถิติเว็บ',
    'web-user.__apache_errdocs' => 'เอกสารข้อผิดพลาดที่กำหนดเอง',
    'web-user.__hosting_write_modify' => 'เขียน/แก้ไขการอนุญาตเพิ่มเติม',
    'web-user.__hosting_webdeploy' => 'การเผยแพร่ Web Deploy',


    'requiredFields' => 'ช่องที่ต้องใส่ข้อมูล',
];