<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Akses ditolak. Akun Anda telah ditangguhkan.",
    'login_up__login_has_been_locked' => "Anda sudah mencoba log masuk menggunakan kata sandi yang salah terlalu sering. Untuk alasan keamanan, Anda tidak akan dapat log masuk menggunakan nama pengguna ini untuk beberapa saat.",
    'login_up__unable_to_check_pass' => "Tidak dapat mengecek kata sandi: %1",
    'login_up__warning_limits_licence_key' => "Salah satu unsur berikut ini telah melampaui batas yang ditentukan oleh kunci lisensi Anda: jumlah akun pengguna, domain, akun surat, atau pengguna web yang di-host di server Anda.\nHarap menghubungi departemen penjualan Plesk untuk membeli sandi yang memperkenankan Anda untuk meng-host jumlah pengguna dan domain yang diinginkan. Harap menghubungi departemen dukungan teknis Plesk bila Anda merasa Anda tidak seharusnya menerima pesan ini.\nBatas lisensi untuk akun pengguna/domain/akun surat/pengguna web/paket bahasa: %2.\nJumlah akun pengguna/domain/akun surat/pengguna web/paket bahasa yang di-host saat ini: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Jumlah sumber daya yang Anda operasikan sudah melampaui batas yang ditentukan oleh lisensi produk Anda saat ini. Silakan menghubungi departemen penjualan Plesk dan beli kunci lisensi yang baru.",
    'login_up__grace_period' => 'Anda sedang beroperasi dalam masa tenggang dari lisensi produk Anda. Untuk memperbarui lisensi produk Anda, pilih opsi Ambil Kunci di halaman %1 Informasi Lisensi %2.',
    'login_up__partner_license_message' => 'Anda sedang beroperasi dengan lisensi produk terbatas yang memerlukan registrasi sebelum mengaktifkan set fitur lengkap. Untuk memperbarui lisensi produk Anda, pilih opsi Ambil Kunci di halaman %1Informasi Lisensi %2.',
    'login_up__system_admin_disabled' => 'Superuser (akun root atau administrator) dilarang untuk log masuk ke dalam Plesk demi alasan keamanan.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Panduan Administrator Plesk",
    'plesk_guide_reseller' => "Panduan Penyalur Plesk",
    'plesk_guide_client' => "Panduan Pelanggan Plesk",
    'plesk_guide_domain_admin' => "Panduan Administrator Domain Plesk",
    'plesk_guide_mailuser' => "Panduan Pengguna Surel Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Cari', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Pelanggan',
    'ui__reseller_unknown__quick-search' => 'Penyalur',
    'ui__client/domain_unknown__quick-search' => 'Domain',
    'nav__general' => 'Menu Utama',
    '__home' => 'Beranda',
    '__resellers' => 'Penyalur',
    '__clients' => 'Pelanggan',
    '__domains' => 'Domain',
    '__applications' => 'Aplikasi',
    '__settings' => 'Pengaturan',
    'nav__system' => 'Sistem',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Tingkatkan Level',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Hapus',
    'bt_make_default' => 'Buat Menjadi Default',

    // common list object operation errors
    'class_cList__empty_selection' => 'Tidak ada objek dipilih.',

    // common list object search keys
    'clist__search_show' => 'Tunjukkan Pencarian',
    'clist__search_hide' => 'Sembunyikan pencarian',

    'bt_show_all' => "Atur Ulang Pencarian",

    // common object list info keys
    'clist__first' => 'Pertama',
    'clist__last' => 'Terakhir',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Halaman',
    'clist__page_size' => 'Entri per halaman',
    'clist__info' => 'Total %1: %4',
    'clist__info_empty' => 'No %1',
    'clist__info_filter' => '%5 %1 ditemukan (total %4)',
    'clist__info_paging' => '%2-%3 %1 dari total %4',
    'clist__info_paging_filter' => '%2-%3 %1 dari %5 ditemukan (total %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktif',
    '__object_off' => 'Ditangguhkan',

    '__home_description' => 'Kembali ke halman Beranda.',
    'indicator_title' => '%1% digunakan, %2% bebas', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'URL invalid telah diminta.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Akun Penyalur",
    'ui__reseller_unknown__title' => "Akun Penyalur",
    'ui__reseller_unknown__description' => "Kelola akun penyalur.",
    'ui__reseller/client_unknown__short-title' => 'Akun Pelanggan',
    'ui__reseller/client_unknown__title' => 'Akun Pelanggan',
    'ui__reseller/client_unknown__description' => 'Kelola akun pelanggan.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Akun administrator tambahan", // PFW
    'ui__admin-alias_unknown__short-title' => "Akun administrator tambahan", // PFW
    'ui__admin-alias_unknown__description' => "Lihat dan kelola akun administrator tambahan.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Pengaturan surat seluruh server",
    'ui__server/mail__title' => "Pengaturan surat seluruh server",
    'ui__server/mail__description' => "Menyiapkan server surat Anda dan mengonfigurasi pengaturan di seluruh server.",
    'ui__server/dns__short-title' => 'Pengaturan DNS',
    'ui__server/dns__title' => 'Pengaturan DNS',
    'ui__server/dns__description' => 'Tinjau dan perbarui pengaturan DNS di seluruh server.',
    'ui__server/services__title' => 'Pengelolaan Layanan',
    'ui__server/services__description' => 'Mulai, hentikan, atau mulai ulang layanan Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Tugas Terjadwal',
    'ui__server/crontab/task_unknown__title' => 'Tugas Terjadwal',
    'ui__server/crontab/task_unknown__description' => 'Tambah atau hapus tugas terjadwal di seluruh server.',
    'ui__server/ip-address_unknown__short-title' => 'Alamat IP',
    'ui__server/ip-address_unknown__title' => 'Alamat IP',
    'ui__server/ip-address_unknown__description' => 'Melihat, menambah dan menghapus alamat IP, memberi alamat IP untuk penyalur.',
    // dropdowns
    'ui__server/time__title' => 'Waktu sistem',
    'ui__server/time__short-title' => 'Waktu sistem',
    'ui__server/time__description' => 'Mengubah tanggal dan jam sistem, menyiapkan sinkronisasi dengan server NTP.',
    'ui__server/maillists__title' => 'Penyiapan server milis', // PFU
    'ui__server/maillists__short-title' => 'Penyiapan server milis', // PFU
    'ui__server/maillists__description' => 'Menyiapkan server milis Mailman.', // PFU
    'ui__server/spam-filter__title' => 'Pengaturan filter spam',
    'ui__server/spam-filter__short-title' => 'Pengaturan filter spam',
    'ui__server/spam-filter__description' => 'Menata filter spam seluruh server.',
    'ui__server/preferences__title' => "Pengaturan server",
    'ui__server/preferences__short-title' => "Pengaturan server",
    'ui__server/preferences__description' => "Menyiapkan perhitungan statistik seluruh server, mengubah nama host server, dan mengubah pengaturan server lainnya.",

    // help & support
    // icons
    'ui__support__short-title' => 'Dukungan',
    'ui__support__title' => 'Dukungan',
    'ui__support__description' => 'Ajukan permintaan dukungan teknis atau meninjau tiket dukungan yang dibuat pelanggan Anda.',
    'ui__license__short-title' => 'Informasi Lisensi',
    'ui__license__title' => 'Informasi Lisensi Plesk',
    'ui__license__description' => 'Lihat informasi mengenai lisensi Plesk Anda dan pesan kunci lisensi baru.',
    'ui__help__short-title' => 'Bantuan',
    'ui__help__title' => 'Bantuan online',
    'ui__help__description' => 'Lihat bantuan online.',
    'ui__news__short-title' => "Apa yang baru",
    'ui__news__title' => "Apa yang baru",
    'ui__news__description' => "Lihat daftar perubahan dalam versi Plesk ini.",
    'ui__server/autoinstaller__short-title' => 'Pembaruan',
    'ui__server/autoinstaller__title' => 'Pembaruan',
    'ui__server/autoinstaller__description' => 'Memperbarui Plesk dan komponennya.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domain',
    'ui__client/domain_unknown__title' => 'Domain',
    'ui__client/domain_unknown__description' => 'Kelola domain.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Tetapkan pemilik baru untuk langganan',
    'ui__client/domain/chowner_multi-select__short-title' => 'Tetapkan pemilik langganan baru',
    'ui__client/domain/chowner_multi-select__description' => 'Tetapkan pemilik baru untuk langganan terpilih',
    'ui__client/domain/disable_multi__title' => 'Tangguhkan domain',
    'ui__client/domain/disable_multi__short-title' => 'Tangguhkan domain',
    'ui__client/domain/disable_multi__description' => 'Tangguhkan domain terpilih',
    'ui__client/domain/enable_multi__title' => 'Aktifkan domain',
    'ui__client/domain/enable_multi__short-title' => 'Aktifkan domain',
    'ui__client/domain/enable_multi__description' => 'Aktifkan domain terpilih',

    // icons
    'ui__admin/extras-domain__short-title' => 'Alat dari MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Alat dari MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__server/sitebuilder__short-title' => 'Pengaturan Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Pengaturan Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Menyiapkan Presence Builder untuk menyunting situs web yang di-host di server ini.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Daftarkan Domain',
    'ui__admin/register-domain__short-title' => 'Daftarkan Domain',
    'ui__admin/register-domain__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Kelola Domain',
    'ui__admin/manage-domain__short-title' => 'Kelola Domain',
    'ui__admin/manage-domain__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',
    'ui__server/register__title' => 'Daftarkan server Anda',
    'ui__server/register__short-title' => 'Mendaftarkan server',
    'ui__server/register__description' => 'Daftarkan server Anda untuk bergabung dengan program afiliasi',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Log tindakan',
    'ui__actionlog__title' => 'Log tindakan',
    'ui__actionlog__description' => 'Unduh log tindakan dan membuat pengaturan log tindakan.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Informasi Server',
    'ui__server/statistics__title' => 'Informasi Server',
    'ui__server/statistics__description' => 'Statistik layanan yang dikelola Plesk.',
    'ui__admin/report__title' => 'Laporan Ringkas',
    'ui__admin/report__short-title' => 'Laporan Ringkas',
    'ui__admin/report__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya untuk penyalur, pelanggan, dan domain.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Waktu Diam Sesi',
    'ui__sessions/properties__title' => 'Waktu Diam Sesi',
    'ui__sessions/properties__description' => 'Mengatur sesi diam untuk sesi Plesk.',
    'ui__cp-access__short-title' => 'Akses ke Plesk',
    'ui__cp-access__title' => 'Akses ke Plesk',
    'ui__cp-access__description' => 'Batasi akses ke Plesk',
    'ui__sessions__short-title' => 'Sesi Aktif',
    'ui__sessions__title' => 'Sesi Aktif',
    'ui__sessions__description' => 'Lihat sesi Plesk yang aktif.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Sertifikat SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Sertifikat SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Daftar sertifikat SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Data Pribadi',
    'ui__admin-info__title' => 'Data Pribadi',
    'ui__admin-info__description' => 'Ubah data pribadi akun Anda.',
    'ui__admin-password__short-title' => 'Ubah kata sandi',
    'ui__admin-password__title' => 'Ubah kata sandi',
    'ui__admin-password__description' => 'Ubah kata sandi akun Anda.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits__title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits__description' => 'Lihat dan kelola penggunaan sumber daya penyalur %1.',
    'ui__reseller/limits_unknown__short-title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits_unknown__title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits_unknown__description' => 'Lihat dan kelola penggunaan sumber daya penyalur.',
    'ui__reseller/limits_self__short-title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits_self__title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits_self__description' => "Lihat dan kelola penggunaan sumber daya Anda.",
    'ui__reseller/limits_readonly-self__short-title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits_readonly-self__title' => 'Penggunaan Sumber Daya',
    'ui__reseller/limits_readonly-self__description' => "Lihat penggunaan sumber daya Anda.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Penggunaan Lalu-Lintas oleh Pelanggan',
    'ui__reseller/client/traffic_unknown__title' => 'Lihat Penggunaan Lalu-Lintas oleh Pelanggan',
    'ui__reseller/client/traffic_unknown__description' => 'Lihat laporan penggunaan lalu-lintas untuk akun pelanggan.',
    'ui__client/traffic_unknown__short-title' => "Penggunaan Lalu-Lintas oleh Pelanggan", // temporary for presets
    'ui__client/traffic_unknown__title' => "Lihat penggunaan lalu-lintas oleh pelanggan", // temporary for presets
    'ui__client/traffic_unknown__description' => "Lihat laporan penggunaan lalu-lintas untuk akun pelanggan.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Pengelola Log',
    'ui__client/domain/hosting/logs_unknown__title' => 'Pengelola Log',
    'ui__client/domain/hosting/logs_unknown__description' => 'Lihat log dan konfigurasi rotasi log.',
    // dropdowns
    'ui__reseller/report__title' => 'Laporan ringkas',
    'ui__reseller/report__short-title' => 'Laporan ringkas',
    'ui__reseller/report__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya untuk penyalur ini.',
    'ui__reseller/report_unknown__title' => 'Laporan ringkas',
    'ui__reseller/report_unknown__short-title' => 'Laporan ringkas',
    'ui__reseller/report_unknown__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya penyalur.',
    'ui__reseller/report_self__title' => 'Laporan ringkas',
    'ui__reseller/report_self__short-title' => 'Laporan ringkas',
    'ui__reseller/report_self__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya Anda.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Merek Plesk',
    'ui__client/logo_reseller__short-title' => 'Merek Plesk',
    'ui__client/logo_reseller__description' => 'Ganti merek Plesk untuk penyalur %1.',
    'ui__client/logo_unknown__title' => 'Merek Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Merek Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Ganti merek Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Merek Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Merek Plesk',
    'ui__client/logo_self-reseller__description' => 'Ganti merek Plesk Anda.',
    'ui__reseller/permissions__title' => 'Izin',
    'ui__reseller/permissions__short-title' => 'Izin',
    'ui__reseller/permissions__description' => "Lihat atau ubah tindakan yang dapat dilakukan penyalur %1 di Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Izin',
    'ui__reseller/permissions_unknown__title' => 'Izin',
    'ui__reseller/permissions_unknown__description' => "Lihat atau ubah tindakan yang dapat dilakukan penyalur di Plesk.",
    'ui__reseller/permissions_self__title' => 'Izin',
    'ui__reseller/permissions_self__short-title' => 'Izin',
    'ui__reseller/permissions_self__description' => 'Lihat daftar tindakan yang dapat Anda lakukan di Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Izin',
    'ui__reseller/permissions_readonly-self__short-title' => 'Izin',
    'ui__reseller/permissions_readonly-self__description' => 'Lihat daftar tindakan yang dapat Anda lakukan di Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Alias domain',
    'ui__client/domain/domain-alias_unknown__title' => 'Alias domain',
    'ui__client/domain/domain-alias_unknown__description' => 'Lihat daftar nama alternatif untuk domain Anda.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_unknown__description' => 'Kelola pengaturan zona DNS untuk suatu domain.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Lihat pengaturan zona DNS untuk suatu domain.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Alat dari MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Alat dari MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Alat dari MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Alat dari MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Alat dari MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Alat dari MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Daftarkan Domain',
    'ui__reseller/register-domain__title' => 'Daftarkan Domain',
    'ui__reseller/register-domain__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Daftarkan Domain',
    'ui__reseller/register-domain_unknown__title' => 'Daftarkan Domain',
    'ui__reseller/register-domain_unknown__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Daftarkan Domain',
    'ui__reseller/register-domain_self__title' => 'Daftarkan Domain',
    'ui__reseller/register-domain_self__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Kelola Domain',
    'ui__reseller/manage-domain__short-title' => 'Kelola Domain',
    'ui__reseller/manage-domain__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Kelola Domain',
    'ui__reseller/manage-domain_unknown__short-title' => 'Kelola Domain',
    'ui__reseller/manage-domain_unknown__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Kelola Domain',
    'ui__reseller/manage-domain_self__short-title' => 'Kelola Domain',
    'ui__reseller/manage-domain_self__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Alamat IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Alamat IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Kelola alamat IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Sertifikat SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Sertifikat SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Pasang dan kelola sertifikat SSL/TLS.',
    'ui__reseller/sessions__short-title' => 'Sesi Aktif',
    'ui__reseller/sessions__title' => 'Sesi Aktif',
    'ui__reseller/sessions__description' => 'Lihat sesi Plesk yang aktif.',
    'ui__reseller/sessions_unknown__short-title' => 'Sesi Aktif',
    'ui__reseller/sessions_unknown__title' => 'Sesi Aktif',
    'ui__reseller/sessions_unknown__description' => 'Lihat sesi Plesk yang aktif.',
    'ui__reseller/sessions_self__short-title' => 'Sesi Aktif',
    'ui__reseller/sessions_self__title' => 'Sesi Aktif',
    'ui__reseller/sessions_self__description' => 'Lihat sesi Plesk yang aktif.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Akun Surat di Bawah Akun Pengguna %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS

    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Penggunaan sumber daya',
    'ui__client/limits__title' => 'Penggunaan sumber daya',
    'ui__client/limits__description' => "Lihat dan kelola penggunaan sumber daya pelanggan %1.",
    'ui__client/limits_unknown__short-title' => 'Penggunaan sumber daya',
    'ui__client/limits_unknown__title' => 'Penggunaan sumber daya',
    'ui__client/limits_unknown__description' => 'Lihat dan kelola penggunaan sumber daya pelanggan.',
    'ui__client/limits_readonly__short-title' => 'Penggunaan sumber daya',
    'ui__client/limits_readonly__title' => 'Penggunaan sumber daya',
    'ui__client/limits_readonly__description' => 'Lihat penggunaan sumber daya pelanggan %1.',
    'ui__client/limits_self__short-title' => 'Penggunaan sumber daya',
    'ui__client/limits_self__title' => 'Penggunaan sumber daya',
    'ui__client/limits_self__description' => "Lihat dan kelola penggunaan sumber daya Anda.",
    'ui__client/limits_readonly-self__short-title' => 'Penggunaan sumber daya',
    'ui__client/limits_readonly-self__title' => 'Penggunaan sumber daya',
    'ui__client/limits_readonly-self__description' => "Lihat penggunaan sumber daya Anda.",
    'ui__client/domain/traffic_unknown__short-title' => "Penggunaan Lalu-Lintas oleh Domain %1",
    'ui__client/domain/traffic_unknown__title' => "Lihat penggunaan lalu-lintas oleh domain",
    'ui__client/domain/traffic_unknown__description' => "Lihat laporan penggunaan lalu-lintas untuk domain.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Laporan ringkas',
    'ui__client/report__short-title' => 'Laporan ringkas',
    'ui__client/report__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya untuk pelanggan ini.',
    'ui__client/report_unknown__short-title' => 'Laporan ringkas',
    'ui__client/report_unknown__title' => 'Laporan ringkas',
    'ui__client/report_unknown__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya untuk pelanggan.',
    'ui__client/report_self__short-title' => 'Laporan ringkas',
    'ui__client/report_self__title' => 'Laporan ringkas',
    'ui__client/report_self__description' => 'Lihat laporan penggunaan lalu-lintas dan sumber daya.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Preferensi antarmuka',
    'ui__client/preferences__title' => 'Preferensi antarmuka',
    'ui__client/preferences__description' => 'Mengatur preferensi antarmuka Plesk untuk pelanggan %1.',
    'ui__client/preferences_unknown__short-title' => 'Preferensi antarmuka',
    'ui__client/preferences_unknown__title' => 'Preferensi antarmuka',
    'ui__client/preferences_unknown__description' => "Mengatur preferensi antarmuka untuk Plesk pelanggan.",
    'ui__client/preferences_self__short-title' => 'Preferensi antarmuka',
    'ui__client/preferences_self__title' => 'Preferensi antarmuka',
    'ui__client/preferences_self__description' => 'Mengatur preferensi antarmuka untuk Plesk Anda.',
    'ui__client/logo__title' => 'Merek Plesk',
    'ui__client/logo__short-title' => 'Merek Plesk',
    'ui__client/logo__description' => "Ganti merek Plesk pelanggan %1",
    'ui__client/logo_self__title' => 'Merek Plesk',
    'ui__client/logo_self__short-title' => 'Merek Plesk',
    'ui__client/logo_self__description' => 'Mengganti merek Plesk, mengganti gambar logo dan bilah judul peramban.',
    'ui__client/permissions__title' => 'Izin',
    'ui__client/permissions__short-title' => 'Izin',
    'ui__client/permissions__description' => "Melihat atau mengubah tindakan yang dapat dilakukan pelanggan %1 di Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Izin',
    'ui__client/permissions_unknown__title' => 'Izin',
    'ui__client/permissions_unknown__description' => "Melihat atau mengubah tindakan yang dapat dilakukan pelanggan di Plesk.",
    'ui__client/permissions_self__title' => 'Izin',
    'ui__client/permissions_self__short-title' => 'Izin',
    'ui__client/permissions_self__description' => "Lihat daftar tindakan yang dapat Anda lakukan di Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Izin',
    'ui__client/permissions_readonly-self__short-title' => 'Izin',
    'ui__client/permissions_readonly-self__description' => "Lihat daftar tindakan yang dapat Anda lakukan di Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Alat dari MyPlesk.com',
    'ui__client/extras-domain__title' => 'Alat dari MyPlesk.com',
    'ui__client/extras-domain__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Alat dari MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Alat dari MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Alat dari MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Alat dari MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Daftarkan Domain',
    'ui__client/register-domain__short-title' => 'Daftarkan Domain',
    'ui__client/register-domain__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Daftarkan Domain',
    'ui__client/register-domain_unknown__short-title' => 'Daftarkan Domain',
    'ui__client/register-domain_unknown__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Daftarkan Domain',
    'ui__client/register-domain_self__short-title' => 'Daftarkan Domain',
    'ui__client/register-domain_self__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Kelola Domain',
    'ui__client/manage-domain__short-title' => 'Kelola Domain',
    'ui__client/manage-domain__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Kelola Domain',
    'ui__client/manage-domain_unknown__short-title' => 'Kelola Domain',
    'ui__client/manage-domain_unknown__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Kelola Domain',
    'ui__client/manage-domain_self__short-title' => 'Kelola Domain',
    'ui__client/manage-domain_self__description' => 'Kelola nama domain terdaftar melalui MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Alamat IP',
    'ui__client/ipaddress_unknown__short-title' => "Alamat IP",
    'ui__client/ipaddress_unknown__description' => "Kelola alamat IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Alias domain',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Alias domain',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Lihat daftar nama alternatif untuk domain Anda.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Sesi Aktif',
    'ui__client/sessions__title' => 'Sesi Aktif',
    'ui__client/sessions__description' => 'Lihat sesi Plesk yang aktif.',
    'ui__client/sessions_unknown__short-title' => 'Sesi Aktif',
    'ui__client/sessions_unknown__title' => 'Sesi Aktif',
    'ui__client/sessions_unknown__description' => 'Lihat sesi Plesk yang aktif.',
    'ui__client/sessions_self__short-title' => 'Sesi Aktif',
    'ui__client/sessions_self__title' => 'Sesi Aktif',
    'ui__client/sessions_self__description' => 'Lihat sesi Plesk yang aktif.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => 'Penggunaan lalu-lintas %1',
    'ui__client/domain/traffic__title' => 'Statistik Transfer Data untuk <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Lihat statistik transfer data untuk domain %1.',
    'ui__client/domain/traffic_self__short-title' => 'Penggunaan lalu-lintas',
    'ui__client/domain/traffic_self__title' => 'Lihat penggunaan lalu-lintas untuk domain Anda',
    'ui__client/domain/traffic_self__description' => 'Lihat laporan penggunaan lalu-lintas untuk domain Anda.',
    'ui__client/domain/hosting/logs__short-title' => 'Pengelola log',
    'ui__client/domain/hosting/logs__title' => 'Pengelola log',
    'ui__client/domain/hosting/logs__description' => 'Lihat log dan konfigurasi rotasi log.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Pengelola log',
    'ui__client/domain/hosting/logs_self__title' => 'Pengelola log',
    'ui__client/domain/hosting/logs_self__description' => 'Lihat log dan konfigurasi rotasi log.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Ganti nama domain',
    'ui__client/domain/rename__short-title' => 'Ganti nama domain',
    'ui__client/domain/rename__description' => 'Ganti nama domain %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Ganti nama domain',
    'ui__client/domain/rename_unknown__title' => 'Ganti nama domain',
    'ui__client/domain/rename_unknown__description' => 'Ganti nama domain',
    'ui__client/domain/chowner_select__title' => 'Tetapkan pemilik baru untuk domain',
    'ui__client/domain/chowner_select__short-title' => 'Tetapkan pemilik baru untuk langganan',
    'ui__client/domain/chowner_select__description' => 'Tetapkan pemilik baru untuk langganan',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Tetapkan Pemilik Baru untuk Langganan',
    'ui__client/domain/chowner_unknown-select__title' => 'Tetapkan Pemilik Baru untuk Langganan',
    'ui__client/domain/chowner_unknown-select__description' => 'Tetapkan pemilik baru untuk langganan.',
    'ui__client/domain/toggle__title' => 'Tangguhkan atau Aktifkan Domain', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Tangguhkan atau Aktifkan Domain', // for HP customization
    'ui__client/domain/toggle__description' => 'Tangguhkan atau aktifkan domain %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Tangguhkan atau Aktifkan Domain', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Tangguhkan atau Aktifkan Domain', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Tangguhkan atau aktifkan domain.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktifkan Domain',
    'ui__client/domain/toggle_enable__short-title' => 'Aktifkan Domain',
    'ui__client/domain/toggle_enable__description' => 'Aktifkan domain %1.',
    'ui__client/domain/toggle_disable__title' => 'Tangguhkan Domain',
    'ui__client/domain/toggle_disable__short-title' => 'Tangguhkan Domain',
    'ui__client/domain/toggle_disable__description' => 'Tangguhkan domain %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Pengaturan DNS',
    'ui__client/domain/dns__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns__description' => 'Kelola pengaturan zona DNS untuk domain %1.',
    'ui__client/domain/dns_self__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_self__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_self__description' => 'Kelola pengaturan zona DNS untuk domain Anda.',
    'ui__client/domain/dns_disabled__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_disabled__description' => 'Kelola pengaturan zona DNS untuk domain %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Kelola pengaturan zona DNS untuk domain Anda.',
    'ui__client/domain/dns_readonly__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly__description' => 'Lihat pengaturan zona DNS untuk domain %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Lihat pengaturan zona DNS untuk domain Anda.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Lihat pengaturan zona DNS untuk domain Anda.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Lihat pengaturan zona DNS untuk domain Anda.',
    'ui__client/domain/dns_slave__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_slave__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_slave__description' => 'Kelola pengaturan zona DNS untuk domain %1.',
    'ui__client/domain/dns_self-slave__title' => 'Pengaturan DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Pengaturan DNS',
    'ui__client/domain/dns_self-slave__description' => 'Kelola pengaturan zona DNS untuk domain Anda.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Alat dari MyPlesk.com',
    'ui__client/domain/extras__title' => 'Alat dari MyPlesk.com',
    'ui__client/domain/extras__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Alat dari MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Alat dari MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Alat dari MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Alat dari MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Dapatkan alat dan layanan tambahan dari MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Daftarkan domain',
    'ui__client/domain/register__title' => 'Daftarkan domain',
    'ui__client/domain/register__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Daftarkan domain',
    'ui__client/domain/register_unknown__title' => 'Daftarkan domain',
    'ui__client/domain/register_unknown__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Daftarkan domain',
    'ui__client/domain/register_self__title' => 'Daftarkan domain',
    'ui__client/domain/register_self__description' => 'Daftarkan nama domain melalui MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Alat",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Lihat statistik',
    'ui__client/domain-summary-report_unknown__title' => 'Lihat statistik',
    'ui__client/domain-summary-report_unknown__description' => 'Lihat informasi mengenai penggunaan sumber daya domain.',
    'ui__client/domain-summary-report__short-title' => "Lihat statistik",
    'ui__client/domain-summary-report__title' => "Lihat statistik",
    'ui__client/domain-summary-report__description' => "Lihat informasi mengenai penggunaan sumber daya domain.",
    'ui__client/domain-summary-report_self__short-title' => "Lihat statistik",
    'ui__client/domain-summary-report_self__title' => "Lihat statistik",
    'ui__client/domain-summary-report_self__description' => "Lihat informasi mengenai penggunaan sumber daya domain Anda.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domain", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Anda harus memilih domain yang akan Anda hapus',
    'ui__client/domain/chowner__empty_selection' => 'Anda harus memilih domain yang akan Anda tetapkan ke pemilik baru',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nama',
    'domains_list__state__filter_title' => 'Penggunaan Sumber Daya',
    'domains_list__filter_state_any' => 'Apa saja',
    'domains_list__filter_state_overuse' => 'Penggunaan berlebih',
    'domains_list__filter_state_normal' => 'Di dalam batas',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Apa saja',
    'domains_list__filter_status_blocked' => 'Ditangguhkan',
    'domains_list__filter_status_active' => 'Aktif',
    'domains_list__ownership__filter_title' => 'Kepemilikan',
    'domains_list__filter_ownership_all' => 'Seluruh domain',
    'domains_list__filter_ownership_personal' => 'Domain saya saja',
    'domains_list__filter_owner_pname__filter_title' => 'Nama Pemilik',
    'domains_list__subrows__filter_title' => 'Tunjukkan',
    'domains_list__subrows_off' => 'Hanya domain',
    'domains_list__subrows_subdomain_domainaliases' => 'Dengan subdomain dan alias',
    'domains_list__subrows_subdomain' => 'Dengan subdomain',
    'domains_list__subrows_domainaliases' => 'Dengan alias',

    // objects list
    'domains_list__owner__title' => 'Pemilik',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Cari aplikasi",
    'site_apps__promo_main_text' => "Katalog Application Packaging Standard (APS) berisi daftar aplikasi yang dapat diberikan ke satu domain atau webspace. Jika Anda ingin memberikan aplikasi yang saat ini tidak ada di katalog, Anda dapat dengan mudah melakukannya dengan mengikuti petunjuk pengemasan APS di www.apsstandard.com",
    'site_apps__promo_download_now' => "Unduh Aplikasi:",
    'site_apps__promo_close' => "Tutup blok ini",
    'site_apps__promo_preset__mostused' => '%1 Terpopuler',
    'site_apps__promo_preset__lessused' => '%1 Terpopuler Selanjutnya',
    'site_apps__promo_preset__all' => "Semua",
    'site_apps__promo_disclaimer_note' => 'Harap perhatikan bahwa aplikasi yang terpasang dari Katalog APS disediakan oleh pihak ketiga dan tidak didukung oleh Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Aplikasi APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Menambah aplikasi...',

    // Errors
    'site_apps__no_applications_for_update' => 'Anda tidak memiliki aplikasi yang terpasang pada Brankas Aplikasi.',
    'site_apps__incorrect_download_preset_configuration' => 'Galat ditemukan pada konfigurasi prasetelan pengunduhan Katalog APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'URL yang diberikan tidak valid.',
    'site_apps__no_updates_at_the_moment' => 'Tidak ada pembaruan aplikasi yang tersedia pada saat ini.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Informasi yang salah telah diterima dari katalog aplikasi APS. Silakan mencoba beberapa saat lagi.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Pengaturan katalog APS telah disimpan, namun Plesk tidak dapat terhubung ke katalog APS yang ditentukan dalam pengaturan katalog APS (%1). Pastikan alamat katalog APS sudah benar dan katalog APS di alamat ini aktif.',
    'site_apps__cannot_retrieve_updates' => 'Saat ini tidak dapat mengunduh pembaruan aplikasi: tidak dapat terhubung ke katalog APS (%1). Pastikan alamat katalog APS sudah benar dan katalog APS di alamat ini aktif.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Tidak ada aplikasi web yang tersedia untuk dipasang.',
    'site_apps__site_applications_already_installed_in_root' => 'Aplikasi web lainnya telah terpasang pada direktori root host virtual ini',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Aplikasi web .NET tidak didukung pada platform Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Aplikasi web seluruh server tidak didukung',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 lebih aplikasi web dijadwalkan untuk ditambahkan ke Brankas Aplikasi.",
    'site_apps__applications_all_in_vault' => "Aplikasi web terpilih telah ada di Brankas Aplikasi.",
    'site_apps__applications_already_in_download_queue' => "%1 aplikasi web terpilih saat ini telah ditambahkan ke Brankas Aplikasi.",
    'site_apps__applications_already_in_valut' => "%1 aplikasi web terpilih telah ada di Brankas Aplikasi.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Lainnya (tidak terkategori)',

    // Errors
    'site_apps__no_applications_in_category' => 'Tidak ada aplikasi tersedia dalam kategori ini. Harap pilih kategori lainnya.',
    'site_apps__no_category_selected__please_specify' => 'Pilih kategori pada menu di sebelah kiri. Seluruh aplikasi yang tersedia pada kategori yang dipilih akan terdaftar di jendela ini.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Akun administrator',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Umum',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Ubah nama host',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Keamanan',
    'bt_setup_firewall' => 'Atur firewall',
    'bt_manage_firewall_rules' => 'Kelola peraturan firewall',
    'cu_firewall__rule' => 'Buat aturan firewall',
    'cu_firewall__protocol' => 'Atur protokol untuk aturan (\'tcp\' atau \'udp\')',
    'cu_firewall__name' => "Atur nama aturan",
    'cu_firewall__disabled' => 'Jika \'true\', aturan ini dinonaktifkan setelah pembuatan',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Pilih server DNS', // PFW
    'bt_soa_records_template' => 'Template catatan SOA',
    'bt_restrict_creation_of_subzones' => 'Batasi pembuatan subzona',

    'databases' => 'Basis data',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplikasi',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Surat',
    'bt_select_mailserver' => 'Pilih server surat', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Pilih antivirus', // PFW
    'bt_virus_protection_settings' => 'Pengaturan perlindungan virus',
    'bt_select_spamfilter' => 'Pilih filter spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Pilih webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Log & statistik',
    'bt_server_statistics_settings' => 'Pengaturan statistik server',
    'bt_select_web_statistics' => 'Perangkat lunak statistik web yang tersedia', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Antarmuka Plesk',

    'components_and_modules' => 'Komponen & modul',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Atur Watchdog', // PFU
    'bt_setup_vpn' => 'Atur VPN', // PFU
    'bt_setup_samba' => 'Atur samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Pengaturan',
    'ui__client/domain/settings_self__short-title' => 'Pengaturan',
    'ui__client/domain/settings_self__description' => 'Lihat dan ubah pengaturan domain.',

    'domain_administrator_account' => 'Akun administrator domain',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Pengaturan akun',

    'domain' => 'Domain',
    'bt_dns_soa_records' => 'Catatan SOA DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Pengaturan penjadwal tugas',

    'website' => 'Situs Web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Pembuatan skrip untuk pengguna web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Pilih sertifikat SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Statistik web',
    'bt_log_rotation_settings' => 'Pengaturan rotasi log',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Batas", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Kebijakan Penggunaan dan Penjualan Berlebih",
    'limits__overuse_policy_legend' => "Penggunaan berlebih",
    'limits__oversell_policy_legend' => "Penjualan berlebih",
    'limits__reseller_overuse_description' => "Kebijakan penggunaan berlebih memberitahu apa yang harus dilakukan Plesk ketika sumber daya digunakan berlebih.",
    'limits__overuse_text' => "Kebijakan penggunaan berlebih",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Ruang disk dan lalu-lintas',
    'limit__disk_space' => 'Ruang disk',
    'limit__max_traffic' => 'Lalu-lintas',
    'limit_group__client' => 'Pelanggan',
    'limit__max_cl' => 'Pelanggan',
    'limit_group__domain' => 'Domain',
    'limit__max_dom' => 'Domain',
    'limit__max_dom_powerUser' => 'Langganan',
    'limit__max_subdom' => 'Subdomain',
    'limit__max_dom_aliases' => 'Alias domain',
    'limit__max_wu' => 'Pengguna web',
    'limit__max_subftp_users' => 'Akun FTP tambahan', // PFW
    'limit_group__mail' => 'Surat',
    'limit__max_box' => 'Kotak surat',
    'limit__mbox_quota' => 'Ukuran kotak surat',
    'limit__total_mboxes_quota' => 'Kuota total kotak surat', // PFW
    'limit__max_maillists' => 'Milis',
    'limit_group__database' => 'Basis data',
    'limit__max_mssql_db' => 'Basis data Server Microsoft SQL', // PFW
    'limit__mssql_dbase_space' => 'Kuota total basis data MS SQL', // PFW
    'limit__max_odbc' => 'Koneksi ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Kuota basis data MariaDB/MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Kuota basis data PostgreSQL', // PFW
    'limit_group__application' => 'Aplikasi',
    'limit__max_iis_app_pools' => 'Kumpulan aplikasi IIS', // PFW
    'limit_group__security' => 'Keamanan',
    'limit_group__validity' => 'Tanggal kedaluwarsa',
    'limit__expiration' => 'Tanggal kedaluwarsa',
    'limit__validity' => 'Periode validitas',
    'limit__max_site_builder' => 'Situs yang diterbitkan dengan Presence Builder',
    'limit__max_site' => 'Domain',
    'limit__mssql_dbase_filesize' => 'Ukuran berkas basis data MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Ukuran berkas log basis data MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Ukuran maksimum file basis data Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Ukuran maksimum file log basis data Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Batas domain tidak valid. Nilai minimum adalah 1.',

    'property__has_wrong_value' => 'Properti %1 mengandung nilai yang salah.',
    'property__name_outgoing_messages_domain_limit' => 'Tetapkan batas pesan keluar dari domain (per jam). Untuk menetapkan nilai Tidak Terbatas, tentukan sebagai " -1". Tentukan sebagai "default" untuk menetapkan nilai yang diberikan pada pengaturan seluruh server.',
    'property__name_outgoing_messages_mbox_limit' => 'Tetapkan batas pesan keluar dari kotak surat (per jam). Untuk menetapkan nilai Tidak Terbatas, tentukan sebagai " -1". Tentukan sebagai "default" untuk menetapkan nilai yang diberikan pada pengaturan seluruh server.',
    'property__name_outgoing_messages_subscription_limit' => 'Tetapkan batas pesan keluar dari langganan (per jam). Untuk menetapkan nilai Tidak Terbatas, tentukan sebagai " -1". Tentukan sebagai "default" untuk menetapkan nilai yang diberikan pada pengaturan seluruh server.',

    // for CLI report & email notifications
    '__resource_notify' => 'Beritahukan',
    '__general' => 'Umum',
    '__template_shared' => 'Template bersama',
    'limit__overuse' => 'Kebijakan penggunaan berlebih',
    'limit__max_traffic_soft' => 'Beri tahu jika penggunaan lalu-lintas sudah tercapai',
    'limit__disk_space_soft' => 'Beri tahu jika penggunaan ruang disk sudah tercapai',
    '__overuse' => 'Kebijakan penggunaan berlebih',
    'performance__title' => 'Kinerja',
    'performance__bandwidth' => 'Penggunaan lebar pita maksimum (KB/s)',
    'performance__max_connections' => 'Koneksi dibatasi pada',

    'gch__hosting_php_isapi' => 'jalankan PHP sebagai ekstensi ISAPI',
    'gch__hosting_ssi_html' => 'Gunakan SSI untuk file *.htm, *.html',
    'gch__hosting_php_handler_type' => 'jalankan PHP sebagai',
    'gch__hosting_php_handler_id' => 'jalankan PHP sebagai',
    'gch__hosting_php_served_by_nginx' => 'PHP dilayani oleh nginx',
    'gch__hosting_unpaid_website_status' => 'Status situs web dalam langganan yang ditangguhkan',
    'gch__mn_no_autoresponder' => 'Tidak ada balasan otomatis yang diatur untuk akun surat.',
    'gch__no_clients_selected' => "Tidak ada akun pelanggan yang dipilih",
    'gch__no_domains_selected' => "Tidak ada domain yang dipilih",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/bulan",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nama sumber daya',
    '__resource_usage' => 'Digunakan',
    '__resource_limit' => 'Batasan',

    '__used' => 'Digunakan',
    '__limit' => 'Batasan',

    '__never_expires' => 'Tidak pernah kedaluwarsa',
    '__resource_free' => '%1 bebas %2',
    '__resource_unlimited' => '%1 penggunaan dari Tidak Terbatas',

    '__unlimited' => 'Tidak terbatas',
    '__increment' => "Menambah (+)",
    '__decrement' => "Mengurangi (-)",
    '__pt' => 'unit',
    '__procent' => '%',
    '__overused' => 'Penggunaan berlebih',
    '__left' => 'tersisa',
    '__available' => 'tersedia',
    '__not_available' => 'Tidak disertakan',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Jadwal Pengantaran',
    'ui__admin/report/layout/auto_unknown__title' => 'Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto_unknown__description' => 'Pilih jadwal pengantaran laporan untuk tata letak laporan.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Tambah Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto/properties_new__title' => 'Tambah Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto/properties_new__description' => 'Tambah jadwal pengantaran laporan untuk laporan %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto/properties__title' => 'Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto/properties__description' => 'Lihat dan modifikasi properti jadwal pengantaran laporan.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Hapus Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Hapus Jadwal Pengantaran Laporan',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Hapus jadwal pengantaran laporan pilihan.',

    'ui__admin/report/layout_unknown__short-title' => 'Tata Letak Laporan',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Lihat Penggunaan Traffic untuk <b>%1</b>',
    'ui__reseller/traffic__description' => 'Lihat laporan penggunaan lalu-lintas akun penyalur %1.',
    'ui__reseller/traffic_self__short-title' => 'Saya',
    'ui__reseller/traffic_self__title' => 'Lihat Penggunaan Lalu-Lintas oleh Pelanggan',
    'ui__reseller/traffic_self__description' => 'Lihat laporan penggunaan lalu-lintas akun pelanggan Anda.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nama penyalur', // reseller report
    'report__full_client_name' => 'Nama pelanggan', // customer report
    'report__full_domain_name' => 'Nama domain', // domain report
    'report__full_owner' => 'Pemilik', // customer & domain reports
    'report__full_creation_date' => 'Tanggal pembuatan',
    'report__full_size' => 'Ukuran',
    'report__full_traffic' => 'Lalu-lintas',
    'report__full_active_clients' => 'Pelanggan aktif', // reseller report
    'report__full_clients' => 'Pelanggan', // reseller report
    'report__full_active_domains' => 'Domain aktif', // reseller & customer reports
    'report__full_domains' => 'Domain', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'Ruang disk',
    'report__full_mail_groups' => 'Mforw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'Aspam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MariaDB/MySQL',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'Umum',
    'report__version' => 'Versi produk',
    'report__build' => 'Build produk',
    'report__status' => 'Status',
    'report__company_name' => 'Nama perusahaan',
    'report__personal_name' => 'Nama pribadi',
    'report__login' => 'Nama pengguna',
    'report__phone' => 'Telepon',
    'report__fax' => 'Faks',
    'report__email' => 'Surel',
    'report__address' => 'Alamat',
    'report__city' => 'Kota',
    'report__state' => 'Negara Bagian/Provinsi',
    'report__zip_code' => 'Kode Pos',
    'report__country' => 'Negara',
    'report__creation_date' => 'Tanggal pembuatan',
    'report__expiration_date' => 'Tanggal kedaluwarsa',
    'report__dumps_total_size' => 'Ukuran file cadangan total',
    'report__section_resellers' => 'Penyalur',
    'report__active_resellers' => 'Penyalur dengan langganan aktif',
    'report__resellers' => 'Penyalur',
    'report__section_full_resellers' => 'Penyalur',
    'report__section_clients' => 'Pelanggan',
    'report__active_clients' => 'Pelanggan dengan langganan aktif',
    'report__clients' => 'Pelanggan',
    'report__section_full_clients' => 'Pelanggan',
    'report__section_personal_clients' => 'Pelanggan sendiri',
    'report__active_personal_clients' => 'Pelanggan Anda sendiri dengan langganan aktif',
    'report__personal_clients' => 'Pelanggan sendiri',
    'report__section_full_personal_clients' => 'Pelanggan sendiri',
    'report__section_domains' => 'Domain',
    'report__disk_usage' => 'Penggunaan disk',
    'report__traffic' => 'Lalu-lintas',
    'report__active_domains' => 'Domain aktif',
    'report__domains' => 'Domain',
    'report__subdomains' => 'Subdomain',
    'report__mboxes' => 'Kotak surat',
    'report__mail_groups' => 'Penerusan Surat',
    'report__mail_autoresp' => 'Balasan otomatis',
    'report__mail_lists' => 'Milis',
    'report__web_users' => 'Pengguna web',
    'report__mysql_databases' => 'Basis data MariaDB/MySQL',
    'report__mssql_databases' => 'Basis data MSSQL',
    'report__pgsql_databases' => 'Basis data PostgreSQL',
    'report__section_full_domains' => 'Domain',
    'report__section_personal_domains' => 'Domain pribadi',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domain pribadi',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Situs yang diterbitkan dengan Presence Builder',
    'report__invalid_email' => 'Harap tentukan alamat surel yang valid.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Pengguna Web',
    'report__section_mailnames' => 'Akun Surat',
    'report__section_maillists' => 'Milis',
    'report__section_databases' => 'Basis data',
    'report__section_siteapps' => 'Aplikasi Web',
    'report__section_aspnetapps' => 'Aplikasi ASP.NET', // PFW
    'report__owner_pname' => "Nama pribadi penyedia",
    'report__owner_login' => "Nama pengguna penyedia",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Jadwal Pengantaran',
    'ui__reseller/report/layout/auto_unknown__title' => 'Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto_unknown__description' => 'Pilih jadwal pengantaran laporan untuk tata letak laporan.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Tambah Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Tambah Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Tambah jadwal pengantaran laporan untuk laporan %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto/properties__title' => 'Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto/properties__description' => 'Lihat dan modifikasi properti jadwal pengantaran laporan.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Hapus Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Hapus Jadwal Pengantaran Laporan',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Hapus jadwal pengantaran laporan pilihan.',

    'ui__reseller/report/layout_unknown__short-title' => 'Tata Letak Laporan',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Lihat Penggunaan Traffic untuk <b>%1</b>',
    'ui__client/traffic__description' => 'Lihat laporan penggunaan lalu-lintas untuk akun pelanggan %1',
    'ui__client/traffic_self__short-title' => 'Penggunaan Lalu-Lintas',
    'ui__client/traffic_self__title' => 'Penggunaan Lalu-Lintas oleh Domain',
    'ui__client/traffic_self__description' => 'Lihat laporan penggunaan lalu-lintas untuk domain Anda.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Paket bahasa yang ditentukan telah dipasang tapi tidak diaktifkan di dalam sistem.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Hapus Sesi',
    'ui__sessions/delete__title' => 'Hapus Sesi',
    'ui__sessions/delete__description' => 'Hapus sesi terpilih.',
    'ui__ftp-sessions__short-title' => 'Sesi FTP',
    'ui__ftp-sessions__title' => 'Sesi FTP',
    'ui__ftp-sessions__description' => 'Lihat sesi FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Hapus Sesi FTP',
    'ui__ftp-sessions/delete__title' => 'Hapus Sesi FTP',
    'ui__ftp-sessions/delete__description' => 'Hapus sesi FTP terpilih.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Hapus Sesi',
    'ui__reseller/sessions/delete__title' => 'Hapus Sesi',
    'ui__reseller/sessions/delete__description' => 'Hapus sesi terpilih.',
    'ui__reseller/sessions/delete_self__short-title' => 'Hapus Sesi',
    'ui__reseller/sessions/delete_self__title' => 'Hapus Sesi',
    'ui__reseller/sessions/delete_self__description' => 'Hapus sesi terpilih.',
    'ui__reseller/ftp-sessions__short-title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions__title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions__description' => 'Lihat sesi FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sesi FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Lihat sesi FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Hapus Sesi FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Hapus Sesi FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Hapus sesi FTP terpilih.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Hapus Sesi FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Hapus Sesi FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Hapus sesi FTP terpilih.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Hapus Sesi',
    'ui__client/sessions/delete__title' => 'Hapus Sesi',
    'ui__client/sessions/delete__description' => 'Hapus sesi terpilih.',
    'ui__client/sessions/delete_self__short-title' => 'Hapus Sesi',
    'ui__client/sessions/delete_self__title' => 'Hapus Sesi',
    'ui__client/sessions/delete_self__description' => 'Hapus sesi terpilih.',

    // domain administrator

    'forgery_token_expired' => 'Token sesi telah kedaluwarsa.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Akun penyalur berikut ini akan dikonversi menjadi akun pelanggan',
    'downgradeResellers__downgrade' => 'Akun penyalur akan dikonversi',
    // controls
    'downgradeResellers__submit_downgrade' => 'Lakukan pengubahan akun.',
    'downgradeResellers__cancel_downgrade' => 'Batalkan konversi akun.',
    'downgradeResellers__confirm' => 'Konfirmasi konversi',
    'downgradeResellers__confirm_message' => 'Konfirmasi konversi akun agar dilanjutkan',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Pilih Akun Pelanggan',
    'upgradeClients__upgrade_clients' => 'Akun pelanggan berikut akan diubah menjadi akun penyalur',
    'upgradeClients__upgrade' => 'Akun pelanggan yang akan diubah',
    // controls
    'upgradeClients__submit_upgrade' => 'Lakukan pengubahan akun.',
    'upgradeClients__cancel_upgrade' => 'Batalkan konversi akun.',
    'upgradeClients__confirm' => 'Konfirmasi konversi',
    'upgradeClients__confirm_message' => 'Konfirmasi konversi akun agar dilanjutkan',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Tidak dapat mengubah akun \'%1\' menjadi akun penyalur: \'%1\' sudah menjadi penyalur.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Akun administrator domain berikut akan diubah menjadi akun pelanggan',
    'upgradeDomainUser__upgrade' => 'Akun administrator domain yang akan diubah',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Lakukan pengubahan akun.',
    'upgradeDomainUser__cancel_upgrade' => 'Batalkan konversi akun.',
    'upgradeDomainUser__confirm' => 'Konfirmasi konversi',
    'upgradeDomainUser__confirm_message' => 'Konfirmasi konversi akun agar dilanjutkan',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Akun administrator domain tidak dapat diubah.',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Akun administrator domain berikut ini tidak dapat diubah menjadi akun pelanggan:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Beberapa akun administrator domain tidak dapat diubah menjadi akun pelanggan. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Akun administrator domain tidak ada.',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domain seharusnya dimiliki oleh administrator server atau penyalur secara langsung.",
    'upgradeDomainUser__all_logins_already_used' => 'Tidak dapat membuat akun untuk pelanggan yang ada.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Akun administrator domain telah diubah.',
    'upgradeDomainUser__upgrade_notification_body' => 'Akun administrator domain Anda telah diubah menjadi akun pelanggan dengan nama pengguna \'%%login%%\' dan kata sandi \'%%password%%\'',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Pilih Akun Pelanggan',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Penyalur terpilih tidak memiliki izin \'%1\', tetapi beberapa pelanggan memiliki izin ini.',
    'clientOwnerChanger__application_not_allowed' => 'Aplikasi \'%1\' tidak tersedia untuk penyalur terpilih, tetapi tersedia untuk beberapa pelanggan.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Mengalihkan Langganan Terpilih',
    // errors
    'domain_chown__empty_selection' => 'Anda harus memilih pemilik baru dari domain yang dipilih',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Penggunaan lebar pita maksimum (%1)',
    'hosting_performance__max_connection_label' => 'Koneksi dibatasi pada',
    'performance__invalid_value' => "Nilai tidak valid. Harus berada di kisaran %1 sampai %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Klien webmail yang tersedia',
    'webmail__none' => 'Tidak ada',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Kumpulan IP Server',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Basis data tidak akan dipulihkan: tidak ada server basis data yang sesuai',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Cadangan server.",
    '__default_backup_comment_reseller' => "Cadangan akun penyalur dibuat oleh %1.",
    '__default_backup_comment_client' => "Cadangan akun pelanggan dibuat oleh %1.",
    '__default_backup_comment_domain' => "Cadangan langganan dibuat oleh %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Kumpulan IP pelanggan %1",
    'backup__ip_mapping__resellers_ip' => "Kumpulan IP penyalur %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Host virtual',
    'backup__restore__object_plesk_admin' => 'Administrator Plesk',
    'backup__restore__object_ftpuser' => 'Akun FTP',
    'backup__restore__object_frontpageuser' => 'Akun Frontpage',
    'backup__restore__object_webuser' => 'pengguna web',
    'backup__restore__object_domain' => 'domain',
    'backup__restore__object_subdomain' => 'subdomain',
    'backup__restore__object_domainalias' => 'alias domain',
    'backup__restore__object_client' => 'pelanggan',
    'backup__restore__object_reseller' => 'penyalur',
    'backup__restore__object_autoresponder' => 'Balasan otomatis',
    'backup__restore__object_mailalias' => 'alias surat',
    'backup__restore__object_database' => 'basis data',
    'backup__restore__object_mailname' => 'akun surat',
    'backup__restore__object_db_user' => 'pengguna basis data',
    'backup__restore__object_ssl_certificate' => 'Sertifikat SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Penyalur berikut tidak dapat dipulihkan karena mereka telah dikonversi menjadi pelanggan: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Pelanggan berikut tidak dapat dipulihkan karena mereka telah dikonversi menjadi penyalur: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Pelanggan berikut tidak dapat dipulihkan karena mereka telah dipindahkan ke pemilik lain: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Ruang disk di server tujuan tidak cukup untuk mentransfer semua langganan terpilih. Tersedia: %1 MB. Dibutuhkan: %2 MB. Perhatikan bahwa ruang disk yang dibutuhkan dihitung sebagai jumlah total isi web, surat, dan basis data domain. Ruang disk yang dibutuhkan dihitung sekali sehari dan disimpan di dalam cache, sehingga ukuran aktual domain mungkin berbeda dari ukuran terhitung. Jika Anda telah memastikan domain terpilih tidak menggunakan lebih dari ruang yang tersedia, lanjutkan proses transfer.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Harap bebaskan ruang disk di server tujuan.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Ruang disk di server sumber tidak mencukupi untuk menyimpan file sementara untuk transfer. Tersedia: %1 MB. Dibutuhkan: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Harap bebaskan ruang disk di server sumber.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informasi server',

    'backup__restore__capability_not_installed_component_text' => 'Komponen %1 tidak terpasang di server tujuan. %1 akan tidak tersedia untuk semua objek yang dipulihkan.',
    'backup__restore__capability_not_installed_component_resolution' => 'Harap pasang %1. Perhatikan bahwa proses ini memerlukan waktu beberapa menit.',
    'backup__restore__capability_existing_sys_user_text' => 'Pengguna sistem dengan nama %1 sudah ada di server tujuan.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Harap mengganti nama pengguna sistem yang sudah ada di server tujuan.',
    'backup__restore__capability_license_usage_text' => 'Batasan sumber daya berikut (ditentukan oleh kunci lisensi) akan terlampaui di server tujuan setelah transfer data:',
    'backup__restore__capability_license_usage_resolution' => 'Harap memasang kunci lisensi lain dengan fitur yang menyediakan jumlah sumber daya yang dibutuhkan di server tujuan.',
    'backup__restore__capability_max_allowed_packet_text' => "Parameter 'max_allowed_packet' di server basis data sumber adalah %1, lebih besar dari server tujuan, yang jumlahnya %2. Beberapa objek basis data untuk domain berikut ini mungkin tidak akan dipulihkan.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Tingkatkan nilai 'max_allowed_packet' di server basis data tujuan.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Tidak dapat mentransfer basis data PostgreSQL karena versi PostgreSQL di server tujuan lebih rendah dari yang digunakan di server sumber. Versi terkini adalah %1, versi yang diperlukan %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Pasang versi PostgreSQL yang dibutuhkan di server tujuan.',
    'backup__restore__capability_db_server_connection_problems' => 'Tidak dapat terhubung ke server basis data PostgreSQL tujuan. Basis data tidak akan ditransfer kecuali koneksi telah dipulihkan.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Periksa pengaturan koneksi di server basis data tujuan.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponen %1 dimatikan di server tujuan.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Harap hidupkan %1 pada server tujuan.',
    'backup__restore__capability_not_configured_component_text' => 'Komponen %1 tidak dikonfigurasi di server tujuan.',
    'backup__restore__capability_not_configured_component_resolution' => 'Harap lakukan konfigurasi %1 di halaman Alat & Pengaturan.',

    'backup__restore__capability_webmail_is_not_available' => 'Layanan webmail %1 tidak tersedia di server tujuan. Sebaliknya, Plesk akan menggunakan layanan webmail berikut: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Untuk menggunakan webmail yang sama seperti server sumber, Anda harus menginstalnya di server ini.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Untuk menggunakan webmail yang sama seperti di server sumber, Anda harus memasangnya di server tujuan.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Webmail '%1' tidak tersedia di server tujuan. Sebaliknya, pada langganan berikut: %3, Plesk akan menggunakan layanan webmail berikut: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Pasang webmail yang dibutuhkan di server tujuan.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Pengaturan webmail',

    'backup__restore__capability_shell_is_not_available' => 'Shell %1 tidak tersedia di server tujuan. Salah satu shell yang tersedia akan digunakan.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Untuk menggunakan shell yang sama di server sumber, hidupkan (in/etc/shells) atau pasang shell itu di server tujuan.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Server DNS tujuan tidak mendukung jaringan dalam Template Pembatasan Transfer. Catatan dengan alamat IP jaringan dalam batasan transfer DNS tidak akan dipulihkan.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Server DNS tujuan tidak mendukung jaringan dalam Template Pembatasan Transfer, tetapi beberapa langganan mempunyai jaringan dalam batasan transfer DNS. Catatan dengan alamat IP jaringan dalam batasan transfer DNS tidak akan dipulihkan.',

    'backup__restore__capability_wrong_php_handler_text' => 'Penangan PHP %1 tidak tersedia di server tujuan. Sebaliknya, Plesk akan menggunakan penangan PHP berikut: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Untuk menggunakan penangan PHP yang sama seperti di server sumber, Anda harus menghidupkan atau memasangnya di server tujuan.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Penangan PHP %1 tidak tersedia. Sebaliknya, Plesk akan menggunakan %2 untuk paket layanan berikut: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Penangan PHP %1 tidak tersedia. Sebaliknya, Plesk akan menggunakan %2 untuk situs web berikut: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Penangan PHP %1 tidak tersedia. Itu tidak akan tersedia untuk situs web berikut: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 tidak tersedia di server tujuan. Versi default akan digunakan.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Untuk menggunakan %1 yang sama seperti di server sumber, Anda harus menghidupkan atau memasangnya di server tujuan.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Kebijakan penggunaan antivirus pada server tujuan tidak mengizinkan pengaturan antivirus personal (per alamat surel) untuk surat keluar. Pengaturan ini tidak akan ditransfer.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Kebijakan penggunaan antivirus pada server tujuan tidak mengizinkan pengaturan antivirus personal (per alamat surel) untuk surat masuk. Pengaturan ini tidak akan ditransfer.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Kebijakan penggunaan antivirus pada server tujuan tidak mengizinkan pengaturan antivirus personal (per alamat surel). Pengaturan ini tidak akan ditransfer.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Untuk transfer pengaturan antivirus personal (per alamat surel), hidupkan opsi terkait di Alat & Pengaturan > Pengaturan Perlindungan Virus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Tidak ada perangkat lunak antivirus yang hidup. Semua pengaturan antivirus dari server sumber tidak akan bekerja hingga Anda memilih perangkat lunak antivirus pada server tujuan.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Pilih perangkat lunak anti virus di Perangkat & Pengaturan > Pengaturan Perlindungan Virus > Bagian pengaturan antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Perangkat lunak antivirus %2 tidak tersedia di server tujuan. Maka %1 yang akan digunakan.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Untuk dapat menggunakan antivirus yang sama dengan server sumber, Silakan pasang dan pilih di Alat & Pengaturan > Pengaturan Perlindungan Virus > Bagian pengaturan antivirus',
    'backup__restore__capability_not_available_sni_text' => 'SNI tidak tersedia di server tujuan. Situs web yang memiliki alamat IP yang sama tidak akan dapat menggunakan sertifikat SSL/TLS individual.',
    'backup__restore__capability_not_available_sni_resolution' => "Harap memastikan sistem operasi di server tujuan mendukung SNI dan dukungan SNI dihidupkan dalam Plesk (kotak centang 'Hidupkan bantuan SNI, yang mengizinkan penggunaan sertifikat SSL/TLS individual di situs web dengan alamat IP yang sama' dalam Alat & Pengaturan > Pengaturan Server).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Pengaturan server',

    'backup__restore__capability_vhost_already_exists_text' => 'Situs web %1 tidak dapat ditransfer: situs web dengan nama yang sama sudah ada di server tujuan.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Harap ganti nama atau hapus situs web dengan nama yang sama dari server.',
    'backup__restore__capability_removed_vhosts' => 'Langganan berikut tidak akan dipulihkan karena berisi nama domain yang sudah ada di server tujuan: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Pada server sumber terdapat %3 penangan PHP berbeda dari tipe %1 dan versi %2. Penangan dari tipe dan versi yang sesuai akan digunakan dalam server tujuan. Perhatikan bahwa pengaturan PHP dalam server sumber dan tujuan mungkin berbeda.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Pemasang Plesk tidak mendukung Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Pemasang Plesk tidak mendukung Python. Harap memasang Python secara manual.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Pengaturan server surat',

    'backup__restore__capability_ftps_disabled' => 'Penggunaan FTPS aman diizinkan di server sumber namun dilarang di target. Aplikasi pengguna yang memakai FTP mungkin tidak berfungsi dengan benar.',
    'backup__restore__capability_ftps_required' => 'Penggunaan FTP tidak aman diizinkan di server sumber namun dilarang di target. Aplikasi pengguna yang memakai FTP mungkin tidak berfungsi dengan benar.',
    'backup__restore__capability_ftps_policy_resolution' => 'Ubah kebijakan Secure FTP dalam Alat & Pengaturan > Kebijakan Keamanan.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte data akan dipindahkan dari server sumber ke tujuan dalam %2 jam.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Untuk transfer lebih cepat, periksa koneksi jaringan antara server sumber dan server tujuan dan atasi masalahnya (jika ada).',
    'backup__restore__too_low_download_speed' => "kurang dari 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Untuk transfer lebih cepat, periksa koneksi jaringan antara server sumber dan server tujuan dan atasi masalahnya (jika ada).',
    'backup__restore__capability_zero_download_speed_text' => 'Kecepatan unduh minimum yang dapat diterima adalah %1 MBps. Kecepatan unduh antara server sumber dan tujuan adalah 0 MBps. Keadaan ini mungkin disebabkan oleh masalah koneksi jaringan. Transfer tidak dimungkinkan.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Periksa koneksi jaringan antara server sumber dan tujuan dan atasi permasalahannya.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Kecepatan unduh minimum yang dapat diterima adalah %2 MBps. Kecepatan unduh antara server sumber dan tujuan adalah %1 MBps. Kecepatan ini dapat meningkatkan waktu transfer. Dalam lingkungan Anda sekarang, migrasi %3 MB membutuhkan %4 jam.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Kecepatan unduh minimum yang dapat diterima adalah %2 MBps. Kecepatan unduh antara server sumber dan tujuan adalah %1 MBps. Kecepatan ini dapat meningkatkan waktu transfer.',

    'backup__restore__capability_remote_database_migration' => "Domain berikut menggunakan basis data jauh: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Jangan menghapus domain ini dari server sumber setelah transfer jika versi Plesk di server sumber lebih rendah dari 11.5! Tangguhkan penghapusan. Jika domain dihapus, basis data akan dihapus dari server jauh. Perhatikan: File dump dari basis data jauh akan disimpan di server sumber dalam direktori %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'File cadangan server basis data MySQL yang lebih rendah dari 5.1 (%1) mungkin tidak dipulihkan dalam MySQL 5.1.x karena MySQL 5.1.x menangani karakter Unicode secara berbeda.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Harap baca artikel basis pengetahuan terkait no. 136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP tidak dipasang pada server tujuan.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Harap pasang Courier-IMAP menggunakan Pemasang Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot tidak dipasang pada server tujuan.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Harap pasang Dovecot menggunakan Pemasang Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Waktu retensi statistik lalu-lintas pada konfigurasi objek berikut ini kurang dari nilai seluruh server di server tujuan.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Ubah nilai seluruh server untuk waktu retensi statistik di server tujuan. Atur waktu ini agar sama dengan atau kurang dari nilai terkecil dalam konfigurasi domain.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Waktu retensi statistik lalu-lintas di beberapa domain kurang dari nilai seluruh server (%1). Nilai akan diubah menjadi %1 untuk domain ini.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Waktu penyimpanan statistik lalu-lintas dalam beberapa paket layanan kurang dari nilai seluruh server (%1). Nilai akan diubah menjadi %1 untuk paket layanan ini.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Pemetaan alamat IP eksklusif ke alamat IP bersama akan menonaktifkan FTP anonim dan HTTPS anonim (kecuali dukungan SNI dihidupkan).',

    'backup__restore__no_postgresql_commands_text' => 'Langganan menggunakan basis data PostgreSQL jauh, dan file cadangan sementaranya tidak dapat dibuat karena perintah pg_dump dan psql hilang di server sumber.',
    'backup__restore__no_postgresql_commands_resolution' => 'Pasang paket klien PostgreSQL apa pun yang mendukung perintah ini.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Modul Apache berikut tidak aktif pada server tujuan: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Silakan mengaktifkan modul ini untuk mencegah timbulnya masalah.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Modul Apache berikut belum dipasang pada server tujuan: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Silakan memasang dan mengaktifkan modul ini untuk mencegah timbulnya masalah.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Pembatasan pesan keluar tidak didukung oleh lisensi Anda. Pengaturan konfigurasi terkait tidak akan ditransfer.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Harap memasang kunci lisensi lain yang menyediakan fitur yang dibutuhkan di server tujuan.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Pembatasan pesan keluar dimatikan di server tujuan. Pengaturan konfigurasi terkait tidak akan ditransfer.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Harap matikan pembatasan pesan keluar di server tujuan.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Pengaturan Surat Seluruh Server',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Pembatasan pesan keluar dari kotak surat tidak didukung oleh server surat yang digunakan di server tujuan. Nilai batas ini tidak akan ditransfer.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Ubah server surat menjadi sama dengan yang digunakan di server sumber.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Pengaturan Surat Seluruh Server',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Pembatasan pesan keluar dari domain tidak didukung oleh server surat yang digunakan di server tujuan. Nilai batas ini tidak akan ditransfer.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Ubah server surat menjadi sama dengan yang digunakan di server sumber.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Pengaturan Surat Seluruh Server',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Pembatasan pesan keluar dari langganan tidak didukung oleh server surat yang digunakan di server tujuan. Nilai batas ini tidak akan ditransfer.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Ubah server surat menjadi sama dengan yang digunakan di server sumber.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Pengaturan Surat Seluruh Server',

    'bu_conflict_resolver_absent_phosting' => 'Tidak dapat memulihkan file yang dipilih karena hosting fisik untuk pemulihan tidak ada. Silakan buat domain dengan hosting fisik terlebih dahulu lalu ulangi pemulihan cadangan.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Data penjual kembali tidak akan dipilihkan karena pengelolaan penjual kembali tidak didukung.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Komponen ModSecurity tidak terpasang di server tujuan.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Harap pasang ModSecurity agar firewall aplikasi web tetap berfungsi untuk situs yang ditransfer. Perhatikan bahwa ini memerlukan waktu beberapa menit.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Pasang ModSecurity jika ingin mentransfer pengaturan firewall aplikasi web. Perhatikan bahwa ini memerlukan waktu beberapa menit.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Komponen ModSecurity tidak dikonfigurasi di server tujuan.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konfigurasikan ModSecurity jika ingin firewall aplikasi web tetap berfungsi untuk situs yang ditransfer.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall Aplikasi Web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity dimatikan di server tujuan.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktifkan ModSecurity jika ingin firewall aplikasi web tetap berfungsi untuk situs yang ditransfer.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall Aplikasi Web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Komponen ModSecurity belum terpasang. Pengaturan firewall aplikasi web tidak akan dipulihkan untuk beberapa objek berikut: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Situs web tidak dapat dipulihkan karena berasal dari langganan %1 yang tidak ditemukan di Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Komponen %1 tidak terpasang di server tujuan. Layanan DNS akan tidak tersedia dan pengaturan DNS akan hilang. Semua situs web pelanggan akan tidak berfungsi.',
    'bu_conflict_resolver_dns_not_installed' => 'Layanan DNS belum terpasang. Pengaturan DNS tidak akan dipulihkan untuk objek berikut: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Langganan berikut tidak dapat dipulihkan karena telah dipindahkan ke pemilik lain: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Langganan berikut tidak dapat dipulihkan karena telah dipindahkan ke penyedia lain: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Tidak dapat menemukan utilitas pemulihan Web Presence Builder untuk memulihkan data Web Presence Builder. Kemungkinan Web Presence Builder belum dipasang.',
    'backup__restore__capability_renamed_db' => 'Nama basis data "%1" telah digunakan oleh langganan lain. Nama basis data yang dipulihkan akan diubah menjadi "%2".',
    'backup__restore__capability_renamed_db_user' => 'Nama pengguna basis data "%1" telah digunakan oleh langganan lain. Nama pengguna basis data yang dipulihkan akan diubah menjadi "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Pemasang Plesk tidak mendukung Perl. Harap memasang ActiveState Perl secara manual.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% dilayani oleh Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% dilayani oleh nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Antivirus Kaspersky',
    '__drweb' => 'Antivirus Odin Premium',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Konflik Penggunaan Sumber Daya',
    'backup__restore__hint_resource_usage_conflicts' => 'Konflik penggunaan sumber daya terjadi ketika batas penggunaan sumber daya objek yang dipulihkan terlampaui setelah pemulihan.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Izinkan penggunaan lebih',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Pulihkan objek dan izinkan untuk menggunakan sumber daya melebihi yang disediakan di awal.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Jangan dipulihkan',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Jangan pulihkan objek yang mempunyai konflik penggunaan sumber daya.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konflik Konfigurasi',
    'backup__restore__hint_configuration_conflicts' => 'Konflik konfigurasi terjadi ketika objek yang dipulihkan memiliki pengaturan dan aplikasi web yang tidak tersedia atau dilarang oleh server berjalan atau kebijakan pemilik objek. Contohnya, konflik konfigurasi akan terjadi jika akun surat yang dipulihkan punya pengaturan filter spam individual sedangkan kebijakan yang berjalan di seluruh server melarang akun surat memiliki pengaturan semacam ini.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Otomatis',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Pulihkan objek dan hidupkan secara otomatis semua opsi konfigurasi yang berkonflik yang dapat dikelola di bawah izin Anda.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Jangan dipulihkan',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Jangan pulihkan objek dengan konflik konfigurasi.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Kumpulan aplikasi IIS khusus tidak diizinkan dalam pengaturan kumpulan aplikasi IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Harap ubah pengaturan kumpulan aplikasi IIS dalam Alat & Pengaturan > Kumpulan Aplikasi IIS > Pengaturan Global.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Kumpulan aplikasi IIS bersama tidak dibolehkan dalam pengaturan kumpulan aplikasi IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Harap ubah pengaturan kumpulan aplikasi IIS dalam Alat & Pengaturan > Kumpulan Aplikasi IIS > Pengaturan Global.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Nama pendek akun surat POP3/IMAP tidak diizinkan di server tujuan.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Nama pendek untuk akun surat akan tidak tersedia setelah pemulihan data.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Tidak dapat membuka file log.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Tidak dapat memulihkan langganan %1: karena telah dihapus dari akun Anda dan Anda tidak memiliki izin untuk membuat langganan. Jika ingin memulihkannya, silakan hubungi penyedia layanan.',

    'backup__error11' => 'Ruang disk tidak cukup untuk cadangan.',
    'backup__error3011' => 'Koneksi ditolak: Tidak ada program yang memantau di alamat dan port yang ditentukan.',
    'backup__error3012' => 'Timeout koneksi.',
    'backup__error3013' => 'Jaringan tidak terjangkau.',
    'backup__error3014' => 'Tidak ada rute ke host.',
    'backup__error3015' => 'Koneksi gagal.',
    'backup__error3016' => 'Tidak dapat menetapkan nama host.',
    'backup__error3017' => 'Nama pengguna atau kata sandi salah.',
    'backup__error3018' => 'Koneksi SSH gagal.',

    'backup__error3110' => 'Tidak dapat terhubung ke agen migrasi jauh: Koneksi ke host tidak tersedia.',
    'backup__error3111' => 'Agen migrasi terkunci oleh tugas migrasi yang gagal atau sedang digunakan oleh proses migrasi lain. Mulai ulang agen migrasi pada server sumber.',
    'backup__error3112' => 'Koneksi ke host tidak tersedia atau agen migrasi tidak berjalan pada host sumber.',
    'backup__error3113' => 'Tidak dapat meluncurkan agen migrasi ke host Linux. Mohon periksa koneksi SSH ke host sumber.',
    'backup__error3114' => 'Tidak dapat meluncurkan agen migrasi ke host Linux: Koneksi SSH gagal.',
    'backup__error3115' => 'Nama pengguna atau kata sandi salah.',
    'backup__error3116' => 'Pengguna yang dituju tidak punya hak administratif.',

    'dns_t__unable_to_remove_ns_record' => 'Tidak dapat menghapus catatan NS dari template DNS: Masing-masing zona DNS harus memiliki setidaknya satu catatan NS.',
    'dns__unsupported_server_zone_transfer' => 'Tidak dapat mentransfer Template Pembatasan Transfer karena konfigurasi DNS seluruh server: Pada beberapa server sumber alamat jaringan berikut diperkenankan untuk transfer zona, tetapi dilarang oleh Server DNS Microsoft: %1',
    'dns__unsupported_domain_zone_transfer' => 'Tidak dapat mentransfer Template Pembatasan Transfer karena konfigurasi DNS domain: Pada beberapa domain alamat jaringan berikut diperkenankan untuk transfer zona, tetapi dilarang oleh Server DNS Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Tidak dapat mengakses direktori jaringan sementara bersama untuk file cadangan. Harap memeriksa direktori jaringan, nama pengguna, dan pengaturan kata sandi. Galat: %1',

    'migration_select_exist_db_server' => 'Pilih server basis data tujuan',

    'dbbackup__temp_dir_wrong_value' => 'Nilai tidak valid untuk direktori sementara telah ditentukan.',
    'dbbackup__network_temp_dir_wrong_value' => 'Nilai tidak valid untuk direktori jaringan sementara telah ditentukan.',
    'dbbackup__server_backup_not_configured' => 'Pengaturan pencadangan basis data tidak dikonfigurasi di server.',
    'dbbackup__temp_dir' => 'Direktori sementara',
    'dbbackup__temp_dir_hint' => 'Jalur ke folder fisik pada server jauh di mana server MS SQL berada. Server MS SQL harus dapat mengakses folder ini untuk menulis dan membaca file cadangan sementara. Sebagai contoh, C:\\JalurDirektori',
    'dbbackup__network_temp_dir_hint' => 'Jalur ke jaringan bersama dipetakan ke folder fisik yang ditentukan di atas. Plesk akan mengakses folder bersama untuk mengunduh dan mengunggah file cadangan. Sebagai contoh, \\\\NamaServer\\JalurDirektori',
    'dbbackup__network_user_hint' => 'Nama pengguna dari pengguna jaringan dibuat di server jauh. Sebagai contoh, NamaServer\\NamaPengguna. Pengguna harus mempunyai akses ke folder bersama yang ditentukan di atas.',
    'dbbackup__network_password_hint' => 'Kata sandi pengguna jaringan',

    'dbbackup__success_import_without_dublicate_users' => 'Pengguna berikut tidak diimpor: %1. Mereka telah ada di server basis data.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Mampatkan file log",
    'log_rot__log_rot_status' => "Status rotasi log",
    'log_rot__log_rot_period' => "Kondisi rotasi log",
    'log_rot__log_rot_size' => "berdasarkan ukuran",
    'log_rot__log_rot_time' => "berdasarkan waktu",
    'log_rot__logrotation_enable' => "Aktifkan rotasi log",
    'log_rot__mail' => "Kirim file log yang sudah diproses ke surel",
    'log_rot__max_number_of_logfiles' => "Jumlah maksimum file log",
    'log_rot__time_period' => "periode",
    'log_rot__unable_turn_off' => 'Tidak dapat mematikan rotasi log karena itu diwajibkan di tingkat server',
    'log_rot__unable_set_period' => 'Tidak dapat menetapkan periode rotasi log berbeda dari \'harian\', karena itu diwajibkan di tingkat server',
    'log_rot__unable_set_max_log_files' => 'Tidak dapat menetapkan jumlah maksimum berkas log lebih besar daripada batas seluruh server %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Angka yang diharapkan: %1",
    'actionlog__incorrect_rotation' => "Parameter rotasi log yang ditentukan tidak valid: %1",
    'actionlog__unknown_rot_period' => "Periode rotasi tidak dikenal: %1",
    'actionlog__unknown_rot_type' => "Tipe rotasi tidak dikenal: %1",
    'actionlog__session_preferences' => 'Pengaturan sesi',
    'actionlog__nis2_delete_prohibited' => 'Menghapus catatan log dilarang karena adanya pembatasan direktif NIS2 yang berlaku.',
    'actionlog__nis2_forbidden_rot_type' => "Tipe rotasi log '%1' tidak dapat digunakan karena pembatasan direktif NIS2 berlaku.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Informasi administrator',
    'actionlog__admin_preferences' => "Preferensi administrator",
    'actionlog__service' => 'Layanan',
    'actionlog__ip_addr' => 'Alamat IP',
    'actionlog__client' => 'Akun pelanggan',
    'actionlog__client_status' => 'Status akun pelanggan',
    'actionlog__client_preferences' => "Antarmuka preferensi pelanggan",
    'actionlog__client_ip_pool' => "Kumpulan IP pelanggan",
    'actionlog__client_siteapp' => "Kumpulan aplikasi web pelanggan",
    'actionlog__client_guid' => "GUID pelanggan",
    'actionlog__domain' => 'Domain default (domain pertama yang ditambahkan ke langganan)',
    'actionlog__domain_owner' => 'Pemilik langganan',
    'actionlog__domain_plan' => 'Paket layanan berlangganan',
    'actionlog__domain_status' => 'Domain default, status',
    'actionlog__domain_dns' => 'Domain default, zona DNS',
    'actionlog__subdomain' => 'Subdomain dari domain default',
    'actionlog__domain_alias' => 'Domain default, alias',
    'actionlog__domain_alias_dns' => 'Domain default, zona DNS alias',
    'actionlog__site' => 'Domain',
    'actionlog__site_status' => 'Status domain',
    'actionlog__site_dns' => 'Zona DNS domain',
    'actionlog__site_guid' => 'GUID Domain',
    'actionlog__site_subdomain' => 'Subdomain',
    'actionlog__site_alias' => 'Alias domain',
    'actionlog__site_alias_dns' => 'Zona DNS alias domain',
    'actionlog__domain_limits' => 'Batas langganan',
    'actionlog__domain_limit_size' => 'Batas ruang disk untuk langganan',
    'actionlog__domain_limit_traffic' => 'Batas lalu-lintas langganan',
    'actionlog__domain_limits_powerUser' => 'Batas langganan',
    'actionlog__domain_limit_size_powerUser' => 'Batas ruang disk untuk langganan',
    'actionlog__domain_limit_traffic_powerUser' => 'Batas trafik untuk langganan',
    'actionlog__domain_guid' => "Domain default, GUID",
    'actionlog__cp_user' => 'Pengguna Plesk',
    'actionlog__mailname' => 'Akun surat',
    'actionlog__maillist' => 'Milis',
    'actionlog__phosting' => 'Pengaturan hosting',
    'actionlog__forwarding' => 'hosting default atau frame forwarding',
    'actionlog__webuser' => 'Akun pengguna web',
    'actionlog__site_application' => 'Aplikasi web',
    'actionlog__license' => 'Kunci lisensi',
    'actionlog__additional_license' => 'Kunci lisensi tambahan',
    'actionlog__template_domain' => "Paket layanan penyalur",
    'actionlog__template_admin' => "Paket layanan administrator",
    'actionlog__template_reseller' => 'Paket penyalur',
    'actionlog__admin_alias' => 'Akun administrator tambahan', // PFW
    'actionlog__ftpuser' => 'Akun FTP tambahan', // PFW
    'actionlog__db_server' => 'Server basis data',
    'actionlog__db' => 'Basis data',
    'actionlog__db_user' => 'Akun pengguna basis data',
    'actionlog__client_sapppkg_pool' => "Aplikasi web pengguna", // PFW, not used?
    'actionlog__remote_dns' => 'Status server DNS jauh', // PFW
    'actionlog__reseller' => 'Akun penyalur',
    'actionlog__reseller_guid' => 'GUID penyalur',
    'actionlog__reseller_ip_pool' => "Kumpulan IP penyalur",
    'actionlog__reseller_limit_size' => 'Batas ruang disk untuk akun penyalur',
    'actionlog__reseller_limit_traffic' => 'Batas lalu-lintas untuk akun penyalur',
    'actionlog__reseller_limits' => 'Batas akun penyalur',
    'actionlog__reseller_permissions' => 'Izin penyalur',
    'actionlog__reseller_preferences' => "Preferensi antarmuka penyalur",
    'actionlog__reseller_siteapp' => "Aplikasi web di kumpulan penyalur",
    'actionlog__reseller_status' => 'Status akun penyalur',
    'actionlog__health_status' => 'Status kesehatan server',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'tercapai',
    'actionlog__added' => 'ditambahkan',
    'actionlog__removed' => 'dihapus',
    'actionlog__change' => 'diubah',
    'actionlog__update' => 'diperbarui',
    'actionlog__move' => 'dipindahkan',
    'actionlog__upgrade' => 'ditingkatkan', // PFU?
    'actionlog__update_or_add' => 'diperbarui atau ditambahkan',
    'actionlog__expired' => 'kedaluwarsa',
    'actionlog__create' => 'dibuat',
    'actionlog__delete' => 'dihapus',
    'actionlog__service_stop' => 'dihentikan',
    'actionlog__service_restart' => 'dimulai ulang',
    'actionlog__service_start' => 'dimulai',
    'actionlog__login' => 'masuk',
    'actionlog__logout' => 'keluar',
    'actionlog__install' => 'terpasang',
    'actionlog__uninstall' => 'Pemasangan dihapus',
    'actionlog__reconfigure' => 'dikonfigurasi ulang',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Permintaan mengatur ulang kata sandi',
    'actionlog__event_admin_update' => 'Informasi administrator telah diperbarui',
    'actionlog__event_admin_preferences_update' => "Preferensi administrator diperbarui",
    'actionlog__event_service_restart' => 'Layanan telah dimulai ulang',
    'actionlog__event_service_start' => 'Layanan dimulai',
    'actionlog__event_service_stop' => 'Layanan dihentikan',
    'actionlog__event_ip_address_create' => 'Alamat IP telah dibuat',
    'actionlog__event_ip_address_delete' => 'Alamat IP telah dihapus',
    'actionlog__event_ip_address_update' => 'Alamat IP telah diperbarui',
    'actionlog__event_client_create' => 'Akun pelanggan telah dibuat',
    'actionlog__event_client_delete' => 'Akun pelanggan telah dihapus',
    'actionlog__event_client_update' => 'Akun pelanggan telah diperbarui',
    'actionlog__event_client_status_update' => 'Status akun pelanggan telah diperbarui',
    'actionlog__event_client_preferences_update' => "Preferensi antarmuka pelanggan telah diperbarui",
    'actionlog__event_client_siteapp_added' => "Aplikasi web ditambahkan ke kumpulan aplikasi akun pelanggan",
    'actionlog__event_client_siteapp_removed' => "Aplikasi web dihapus dari kumpulan aplikasi akun pelanggan",
    'actionlog__event_domain_limit_size_reached' => 'Telah mencapai batas ruang disk untuk langganan',
    'actionlog__event_domain_limit_traffic_reached' => 'Telah mencapai batas lalu-lintas untuk langganan',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Batas ruang disk untuk langganan tercapai',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Batas trafik untuk langganan tercapai',

    'actionlog__domain_limit_database' => 'Kuota basis data untuk langganan',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Telah mencapai kuota langganan basis data MariaDB/MySQL',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Telah mencapai kuota lunak langganan basis data MariaDB/MySQL',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Telah mencapai kuota langganan basis data server Microsoft SQL',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Telah mencapai kuota lunak langganan basis data server Microsoft SQL',
    'actionlog__event_plesk_component_upgrade' => 'Komponen Plesk diperbarui',
    'actionlog__event_plesk_component_install' => 'Komponen Plesk dipasang',
    'actionlog__event_plesk_component_uninstall' => 'Komponen Plesk dilepaskan',
    'actionlog__event_domain_create' => 'Domain default (domain pertama yang ditambahkan ke langganan) dibuat',
    'actionlog__event_domain_delete' => 'Domain default (domain pertama yang ditambahkan ke langganan) dihapus',
    'actionlog__event_domain_update' => 'Domain default (domain pertama yang ditambahkan ke langganan) diperbarui',
    'actionlog__event_domain_owner_change' => 'Kepemilikan langganan telah diubah',
    'actionlog__event_domain_plan_change' => 'Paket layanan berlangganan berubah',
    'actionlog__event_domain_status_update' => 'Domain default, status telah diperbarui',
    'actionlog__event_domain_dns_update' => 'Domain default, zona DNS telah diperbarui',
    'actionlog__event_subdomain_create' => 'Subdomain dari domain default telah dibuat',
    'actionlog__event_subdomain_delete' => 'Subdomain dari domain default telah dihapus',
    'actionlog__event_subdomain_update' => 'Subdomain dari domain default telah diperbarui',
    'actionlog__event_domain_alias_create' => 'Domain default, alias telah dibuat',
    'actionlog__event_domain_alias_delete' => 'Domain default, alias telah dihapus',
    'actionlog__event_domain_alias_update' => 'Domain default, alias telah diperbarui',
    'actionlog__event_domain_limits_update' => 'Batas langganan telah diperbarui',
    'actionlog__event_cp_user_login' => 'Pengguna Plesk telah masuk',
    'actionlog__event_cp_user_logout' => 'Pengguna Plesk telah keluar',
    'actionlog__event_mailname_create' => 'Akun surat telah dibuat',
    'actionlog__event_mailname_delete' => 'Akun surat telah dihapus',
    'actionlog__event_mailname_clear' => 'Akun surat dikosongkan',
    'actionlog__event_mailname_update' => 'Akun surat telah diperbarui',
    'actionlog__event_maillist_create' => 'Milis telah dibuat',
    'actionlog__event_maillist_delete' => 'Milis telah dihapus',
    'actionlog__event_maillist_update' => 'Milis telah diperbarui',
    'actionlog__event_phys_hosting_create' => 'Hosting fisik telah dibuat',
    'actionlog__event_phys_hosting_delete' => 'Hosting fisik telah dihapus',
    'actionlog__event_phys_hosting_update' => 'Hosting fisik telah diperbarui',
    'actionlog__event_forwarding_create' => 'hosting standar atau frame forwarding telah dibuat',
    'actionlog__event_forwarding_delete' => 'hosting standar atau frame forwarding telah dihapus',
    'actionlog__event_forwarding_update' => 'hosting standar atau frame forwarding telah diperbarui',
    'actionlog__event_webuser_create' => 'Akun pengguna web telah dibuat',
    'actionlog__event_webuser_delete' => 'Akun pengguna web telah dihapus',
    'actionlog__event_webuser_update' => 'Akun pengguna web telah diperbarui',
    'actionlog__event_siteapp_install' => 'Aplikasi web telah dipasang',
    'actionlog__event_siteapp_reconfigure' => 'Aplikasi web telah dikonfigurasi ulang',
    'actionlog__event_siteapp_uninstall' => 'Aplikasi web telah dihapus',
    'actionlog__event_license_update' => 'Kunci lisensi telah diperbarui',
    'actionlog__event_admin_alias_create' => 'Akun administrator tambahan telah dibuat',
    'actionlog__event_admin_alias_delete' => 'Akun administrator tambahan telah dihapus',
    'actionlog__event_admin_alias_update' => 'Akun administrator tambahan telah diperbarui',
    'actionlog__event_ftpuser_create' => 'Akun FTP tambahan telah dibuat',
    'actionlog__event_ftpuser_update' => 'Akun FTP tambahan telah diperbarui',
    'actionlog__event_ftpuser_delete' => 'Akun FTP tambahan telah dihapus',
    'actionlog__event_template_domain_create' => "Paket layanan penyalur telah dibuat",
    'actionlog__event_template_domain_update' => "Paket layanan penyalur telah diperbarui",
    'actionlog__event_template_domain_delete' => "Paket layanan penyalur telah dihapus",
    'actionlog__event_template_admin_create' => "Paket layanan administrator telah dibuat",
    'actionlog__event_template_admin_update' => "Paket layanan administrator telah diperbarui",
    'actionlog__event_template_admin_delete' => "Paket layanan administrator telah dihapus",
    'actionlog__event_database_server_create' => 'Server basis data telah dibuat',
    'actionlog__event_database_server_update' => 'Server basis data telah diperbarui',
    'actionlog__event_database_server_delete' => 'Server basis data telah dihapus',
    'actionlog__event_remote_dns_status_update' => 'Status server DNS jauh telah diperbarui',
    'actionlog__event_session_preferences_update' => 'Pengaturan sesi telah diperbarui',
    'actionlog__event_domain_alias_dns_update' => 'Domain default, alias domain zona DNS telah diperbarui',
    'actionlog__event_domain_move' => 'Domain default dipindahkan ke langganan baru',
    'actionlog__event_site_move' => 'Domain dipindahkan ke langganan baru',
    'actionlog__event_site_subdomain_move' => 'Subdomain dipindahkan ke langganan baru',
    'actionlog__event_subdomain_move' => 'Subdomain dari domain default dipindahkan ke langganan baru',
    'actionlog__event_license_expired' => 'Lisensi Plesk telah kedaluwarsa',
    'actionlog__event_database_create' => 'Basis data telah dibuat',
    'actionlog__event_database_delete' => 'Basis data telah dihapus',
    'actionlog__event_database_user_create' => 'Akun pengguna basis data telah dibuat',
    'actionlog__event_database_user_update' => 'Pengaturan akun pengguna basis data telah diperbarui',
    'actionlog__event_database_user_delete' => 'Akun pengguna basis data telah dihapus',
    'actionlog__event_client_guid_update' => "GUID pelanggan telah diperbarui",
    'actionlog__event_domain_guid_update' => 'Domain default, GUID telah diperbarui',
    'actionlog__event_reseller_create' => 'Akun penyalur telah dibuat',
    'actionlog__event_reseller_delete' => 'Akun penyalur telah dihapus',
    'actionlog__event_reseller_update' => 'Akun penyalur telah diperbarui',
    'actionlog__event_reseller_guid_update' => 'GUID penyalur telah diperbarui',
    'actionlog__event_reseller_ip_pool_update' => "Kumpulan IP penyalur telah diperbarui",
    'actionlog__event_reseller_limit_size_reached' => 'Telah mencapai batas ruang disk untuk akun penyalur',
    'actionlog__event_reseller_limit_traffic_reached' => 'Telah mencapai batas lalu-lintas akun penyalur',
    'actionlog__event_reseller_limits_update' => 'Batas akun penyalur telah diperbarui',
    'actionlog__event_reseller_permissions_update' => 'Perizinan akun penyalur telah diperbarui',
    'actionlog__event_reseller_preferences_update' => "Preferensi antarmuka penyalur telah diperbarui",
    'actionlog__event_reseller_siteapp_added' => "Aplikasi telah ditambahkan ke kumpulan aplikasi akun penyalur",
    'actionlog__event_reseller_siteapp_removed' => "Aplikasi telah dihapus dari kumpulan aplikasi akun penyalur",
    'actionlog__event_reseller_status_update' => 'Status akun penyalur telah diperbarui',
    'actionlog__event_template_reseller_create' => 'Paket penyalur telah dibuat',
    'actionlog__event_template_reseller_delete' => 'Paket penyalur telah dihapus',
    'actionlog__event_template_reseller_update' => 'Paket penyalur telah diperbarui',
    'actionlog__event_health_status_change' => 'Status kesehatan server telah berubah',
    'actionlog__event_siteapp_upgrade' => 'Aplikasi web telah ditingkatkan',
    'actionlog__event_extension_install' => 'Ekstensi terpasang',
    'actionlog__event_extension_uninstall' => 'Ekstensi terpasang dilepas',
    'actionlog__event_extension_upgrade' => 'Ekstensi ditingkatkan',
    'actionlog__event_extension_status_update' => 'Status ekstensi telah diperbarui',
    'actionlog__event_additional_license_expired' => 'Lisensi tambahan kedaluwarsa',
    'actionlog__event_hostname_changed' => 'Nama host server diubah',
    'actionlog__event_smb_user_create' => 'Pengguna tambahan dibuat',
    'actionlog__event_smb_user_delete' => 'Pengguna tambahan dihapus',
    'actionlog__event_smb_user_update' => 'Pengguna tambahan diperbarui',
    'actionlog__dns_record' => 'Catatan DNS',
    'actionlog__dns_zone' => 'Zona DNS',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC tidak terpasang pada host jauh. Hubungi penyedia layanan Anda untuk mendapatkan bantuan.",
    'rsession_no_account_errmsg' => "Tidak dapat mengakses layanan jauh di bawah akun Anda. Alasan paling umum adalah bahwa layanan untuk akun Anda belum diaktifkan. Harap tunggu beberapa saat, kemudian coba lagi. Jika kesalahan ini muncul lagi, hubungi administrator sistem Anda.",
    'rsession_no_domain_errmsg' => "Tidak dapat mengakses layanan jauh untuk domain ini. Alasan paling umum adalah bahwa layanan untuk domain ini belum diaktifkan. Harap tunggu beberapa saat, kemudian coba lagi. Jika kesalahan ini muncul lagi, hubungi administrator sistem Anda.",
    'rsession_unknown_errmsg' => "Server remote menolak percobaan untuk memulai sesi. Hubungi administrator sistem untuk mendapatkan bantuan. Kesalahannya adalah: %1",
    'rsession_unknown2_errmsg' => "Terjadi kesalahan tidak dikenal saat mengupayakan sesi jauh. Kemungkinan besar server jauh tidak menjawab secara benar atau tidak menjawab sama sekali. Minta administrator sistem Anda untuk memeriksa perincian galat pada log galat server web.",
    'rsession_no_connect_errmsg' => "Tidak dapat mengakses layanan jauh: gagal terhubung dengan sesi jauh. Hubungi administrator sistem untuk mendapatkan bantuan.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Izinkan mengunggah ke direktori masuk",
    'anonftp__allow_create_dirs' => 'Izinkan membuat direktori di dalam direktori masuk',
    'anonftp__allow_download_incoming' => 'Izinkan mengunduh dari direktori masuk',
    'anonftp__display_login' => 'Tampilkan pesan log masuk',
    'anonftp__login_text' => 'Teks pesan',
    'anonftp__limit_incoming_disk_space' => "Batasi kapasitas disk pada direktori incoming",
    'anonftp__limit_maximum_bandwidth' => "Batasi bandwidth pengunduhan domain FTP virtual ini",
    'anonftp__limit_maximum_connections' => "Batasi jumlah koneksi simultan",
    'anonftp__unable_init' => "Tidak dapat memulai akun FTP anonim: %1",
    'anonftp__unable_set_quota' => "Tidak dapat mengatur batas ruang disk direktori incoming: %1",
    'anonftp__unable_update' => "Tidak dapat memperbarui properti akun FTP anonim: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Sertifikat SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Sertifikat CA tidak menandai sertifikat.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Pasangan kunci/sertifikat pribadi tidak kompatibel.",
    'class_sslcertificate__invalid_cert_format' => "Format sertifikat tidak valid.",
    'class_sslcertificate__invalid_private_key_format' => "Format kunci pribadi tidak valid.",
    'class_sslcertificate__prob_invalid_priv_key' => "Ada kemungkinan, format kunci pribadi tidak valid.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Operasi berhasil diselesaikan.',
    'ui__admin/extras-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__admin/report/layout/delete_multi__done' => 'Tata letak laporan terpilih dihapus.',
    'ui__admin/report/traffic-history__done' => 'Operasi berhasil diselesaikan.',
    'ui__admin/report__done' => 'Operasi berhasil diselesaikan.',
    'ui__admin-alias/delete_multi__done' => "Akun administrator tambahan terpilih dihapus.",
    'ui__admin-alias/properties__done' => "Properti akun administrator tambahan diperbarui.",
    'ui__admin-alias/properties_new__done' => "Akun administrator tambahan dibuat.",
    'ui__admin-alias/properties_unknown__done' => "Properti akun administrator tambahan diperbarui.",
    'ui__admin-alias__done' => "Informasi akun administrator Tambahan berhasil diperbarui.",
    'ui__admin/manage-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__admin/register-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Jadwal pengantaran laporan terpilih dihapus.',
    'ui__admin/report/layout/auto/properties__done' => 'Jadwal pengantaran laporan diperbarui.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Jadwal Pengantaran laporan dibuat.',
    'ui__client/domain/certificate/properties__done' => 'Properti sertifikat SSL/TLS telah diperbarui.',
    'ui__client/domain/certificate/properties_new__done' => 'Sertifikat SSL/TLS yang baru ditambahkan. Agar dapat berfungsi, pastikan Anda telah memilihnya di dalam pengaturan hosting situs web (di Situs Web & Domain > nama domain).',
    'ui__client/domain/certificate__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/certificate_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/chowner__done' => 'Langganan %1 sekarang menjadi milik pengguna lainnya.',
    'ui__client/domain/chowner_multi__done' => 'Kepemilikan langganan diganti.',
    'ui__client/domain/chowner_multi-select__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/chowner_select__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/dbbackup/create__done' => "Basis data berhasil dicadangkan.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Basis data berhasil dicadangkan.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Pengguna Orphan berhasil diperbaiki.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "File cadangan berhasil dihapus.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Isi basis data berhasil dipulihkan.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operasi berhasil diselesaikan.", // PFW
    'ui__client/domain/dbbackup__done' => "Operasi berhasil diselesaikan.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operasi berhasil diselesaikan.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operasi berhasil diselesaikan.", // PFW
    'ui__client/domain/delete__done' => "Domain %1 dihapus.",
    'ui__client/domain/delete_multi__done' => "Domain dihapus.",
    'ui__client/domain/disable__done' => 'Domain %1 ditangguhkan.',
    'ui__client/domain/disable_multi__done' => 'Domain terpilih telah ditangguhkan.',
    'ui__client/domain/enable__done' => 'Situs web %1 telah diaktifkan.',
    'ui__client/domain/enable_multi__done' => 'Situs web terpilih telah diaktifkan.',
    'ui__client/domain/extras__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/domain/extras_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Pengaturan rotasi log telah diubah.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Pengaturan rotasi log telah diubah.',
    'ui__client/domain/hosting/logs__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/hosting/logs_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/hosting/setup__done' => 'Hosting untuk %1 telah dikonfigurasi.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operasi berhasil diselesaikan.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operasi berhasil diselesaikan.', // PFU
    'ui__client/domain/mpc-certificates__done' => 'Sertifikat SSL/TLS tersedia di toko online',
    'ui__client/domain/mpc-certificates_self__done' => 'Sertifikat SSL/TLS tersedia di toko online',
    'ui__client/domain/register__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/domain/register_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/domain/rename__done' => 'Nama domain telah diubah.',
    'ui__client/domain/rename_self__done' => "Nama domain telah diubah dengan sukses.",
    'ui__client/domain/settings_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/toggle_disable__done' => "Domain %1 telah ditangguhkan.",
    'ui__client/domain/toggle_enable__done' => "Domain %1 telah diaktifkan.",
    'ui__client/domain/traffic__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/traffic_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain/traffic_unknown__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain-summary-report__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain-summary-report_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/domain-summary-report_unknown__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/extras-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/extras-domain_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/ipaddress/delete_multi__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/ipaddress/properties__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/ipaddress/properties_new__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/ip-pool/properties__done' => "Kumpulan IP pelanggan %1 telah diperbaharui.",
    'ui__client/ip-pool/properties_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/limits__done' => "Pembatasan sumber daya untuk pelanggan %1 telah berubah.",
    'ui__client/limits_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/logo__done' => 'Pengaturan merek baru untuk pelanggan %1 telah berlaku.',
    'ui__client/logo_reseller__done' => 'Pengaturan merek panel baru telah berlaku.',
    'ui__client/logo_self__done' => 'Pengaturan merek telah berlaku.',
    'ui__client/logo_self-reseller__done' => 'Pengaturan merek panel Anda telah berlaku.',
    'ui__client/manage-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/manage-domain_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/permissions__done' => "Izin pelanggan %1 diubah.",
    'ui__client/permissions_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/preferences__done' => "Preferensi untuk pelanggan %1 berubah.",
    'ui__client/preferences_self__done' => "Preferensi Anda berubah.",
    'ui__client/register-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/register-domain_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__client/report/traffic-history__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/report/traffic-history_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/report__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/report_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/sessions/delete__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/sessions/delete_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/sessions__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/sessions_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__client/traffic__done' => "Operasi berhasil diselesaikan.",
    'ui__client/traffic_unknown__done' => 'Operasi berhasil diselesaikan.',
    'ui__cp-access__done' => 'Operasi berhasil diselesaikan.',
    'ui__cp-session/properties__done' => 'Operasi berhasil diselesaikan.',
    'ui__cp-session__done' => 'Operasi berhasil diselesaikan.',
    'ui__ftp-sessions__done' => 'Operasi berhasil diselesaikan.',
    'ui__license__done' => 'Operasi berhasil diselesaikan.',
    'ui__logo__done' => "Properti merek Plesk telah berubah.",
    'ui__longtasks/longtask/properties__done' => "Pengaturan tugas latar telah berhasil diubah.",
    'ui__modules/watchdog/disk/properties__done' => 'Pengaturan pemantauan disk baru telah diterapkan.', // PFU
    'ui__modules__done' => 'Operasi berhasil diselesaikan.',
    'ui__modules__short-title' => 'Ekstensi',
    'ui__modules__title' => 'Ekstensi',
    'ui__reseller/client/traffic_unknown__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/extras-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__reseller/extras-domain_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__reseller/ftp-sessions_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/limits__done' => "Batas sumber daya dan kebijakan penggunaan sumber daya penyalur telah berubah.",
    'ui__reseller/limits_readonly-self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/limits_self__done' => 'Batas sumber daya dan kebijakan penggunaan sumber daya Anda telah berubah.',
    'ui__reseller/manage-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__reseller/manage-domain_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__reseller/permissions__done' => 'Izin penyalur %1 telah diubah.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/register-domain__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__reseller/register-domain_self__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Jadwal pengantaran laporan terpilih dihapus.',
    'ui__reseller/report/layout/auto/properties__done' => 'Jadwal pengantaran laporan diperbarui.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Jadwal pengantaran laporan telah ditambahkan.',
    'ui__reseller/report/traffic-history__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/report/traffic-history_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/report__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/report_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/sessions/delete__done' => 'Operasi berhasil diselesaikan',
    'ui__reseller/sessions/delete_self__done' => 'Operasi berhasil diselesaikan',
    'ui__reseller/sessions__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/sessions_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/traffic__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/traffic_self__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/traffic_unknown__done' => 'Operasi berhasil diselesaikan.',
    'ui__reseller/logo_self__title' => 'Merek Plesk',
    'ui__reseller/logo_self__done' => 'Pengaturan merek Plesk Anda telah diterapkan.',
    'ui__server/certificate/default_multi__done' => 'Sertifikat SSL/TLS terpilih telah dibuat untuk mengamankan koneksi ke situs web yang baru di-host.',
    'ui__server/certificate/delete_multi__done' => 'Sertifikat SSL/TLS terpilih telah dihapus.',
    'ui__server/certificate/download__done' => 'Sertifikat SSL/TLS telah diunduh.',
    'ui__server/certificate/properties__done' => 'Properti sertifikat SSL/TLS telah diperbarui.',
    'ui__server/certificate/properties_new__done' => 'Sertifikat SSL/TLS %1 dibuat.',
    'ui__server/certificate/setup_multi__done' => 'Sertifikat SSL/TLS telah diatur untuk digunakan dalam mengamankan koneksi ke Plesk.',
    'ui__server/certificate__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/cp-certificate-download__done' => "Sertifikat SSL/TLS Plesk telah diunduh.",
    'ui__server/crontab/properties__done' => 'Tugas terjadwal %1 telah diubah.',
    'ui__server/crontab/task/delete__done' => 'Tugas telah dihapus.',
    'ui__server/crontab/task/delete_multi__done' => 'Tugas telah dihapus.',
    'ui__server/crontab/task/properties__done' => 'Tugas terjadwal telah diperbarui.',
    'ui__server/crontab/task/properties_new__done' => 'Tugas baru telah terjadwal.',
    'ui__server/crontab/task/toggle_disable__done' => 'Tugas terjadwal %1 telah dinonaktifkan.',
    'ui__server/crontab/task/toggle_enable__done' => 'Tugas terjadwal %1 telah aktif.',
    'ui__server/crontab__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/dns__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/ip-address/client/delete__done' => "Alamat IP telah dihapus dari kumpulan IP pengguna.",
    'ui__server/ip-address/client/delete_multi__done' => "Alamat IP telah dihapus dari kumpulan IP pengguna.",
    'ui__server/ip-address/client/properties_new__done' => 'Alamat IP telah diberikan untuk pengguna.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'Alamat IP %1 telah diberikan untuk pelanggan pilihan.',
    'ui__server/ip-addresses__done' => "Operasi berhasil diselesaikan.",
    'ui__server/mail__done' => 'Pengaturan server surat telah diubah.',
    'ui__server/maillists__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/mpc-certificates__done' => 'Halaman toko online yang mencantumkan sertifikat SSL/TLS yang tersedia telah dibuka.',
    'ui__server/pmm__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/preferences__done' => "Pengaturan server telah berubah.",
    'ui__server/register__done' => 'Halaman MyPlesk.com telah dibuka.',
    'ui__server/services__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/sitebuilder__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Alamat %1 ini telah dihapus dari daftar hitam seluruh server.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Alamat telah dihapus dari daftar hitam seluruh server.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Alamat telah ditambahkan ke daftar hitam.',
    'ui__server/spam-filter/black-list/address__done' => 'Alamat telah ditambahkan ke daftar hitam.',
    'ui__server/spam-filter/black-list__done' => 'Operasi berhasil diselesaikan.', // PFU
    'ui__server/spam-filter/properties__done' => 'Pengaturan filter spam telah diubah.',
    'ui__server/spam-filter/toggle_disable__done' => 'Filter spam telah dinonaktifkan di seluruh sistem.',
    'ui__server/spam-filter/toggle_enable__done' => 'Filter spam telah diaktifkan di seluruh sistem.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Alamat %1 telah dihapus dari daftar putih seluruh server.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Alamat telah dihapus dari daftar putih seluruh server.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Alamat telah ditambahkan ke daftar putih.',
    'ui__server/spam-filter/white-list/address__done' => 'Alamat telah ditambahkan ke daftar putih.',
    'ui__server/spam-filter/white-list__done' => 'Operasi berhasil diselesaikan.', // PFU
    'ui__server/spam-filter__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/statistics__done' => 'Operasi berhasil diselesaikan.',
    'ui__server/time__done' => "Tanggal dan jam sistem telah diubah.",
    'ui__server__done' => "Operasi berhasil diselesaikan.",
    'ui__sessions/properties__done' => 'Operasi berhasil diselesaikan.',
    'ui__sessions__done' => 'Operasi berhasil diselesaikan.',
    'ui__sessions/delete__done' => 'Sesi terpilih telah dihapus.',
    'ui__support__done' => 'Formulir permintaan bantuan telah dibuka di jendela atau tab peramban baru.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Tidak ada file untuk diunggah.',
    'login_up__access_denied_no_permission' => "Akses ditolak. Anda tidak memiliki izin untuk log masuk.",
    'mail__unable_remove_pattern' => "Tidak dapat menghapus alamat dari daftar hitam server: %1", // PFW
    'mail__incorrect_network_format' => 'Format jaringan salah: %1', // PFW
    'initconf__unable_change_passwd' => "Tidak dapat mengubah kata sandi administrator: %1",
    'initconf__unable_get_passwd' => 'Tidak bisa mendapatkan kata sandi administrator yang berlaku: %1 gagal: %2',
    'initconf__invalid_hostname' => 'Kesalahan dalam hostname "%1"',
    'initconf__unable_reconfig' => 'Tidak dapat mengonfigurasi Plesk: reconfig gagal: %1',
    'initconf__unable_update_admin' => 'Tidak dapat memperbarui info kontak administrator: %1',
    '__refresh' => 'Segarkan',
    '__dalias_not_exist' => 'Alias domain tidak ada.',
    '__bug146523_explanation' => 'Versi Plesk sebelumnya mengizinkan penggunaan nama pengguna FTP hingga 16 karakter. Versi Plesk ini membatasi nama pengguna hingga 15 karakter. Untuk mengatasi masalah ini, kurangi panjang nama pengguna FTP hingga 15 untuk nama pengguna terdampak dan ganti setidaknya satu karakter pada nama pengguna FTP terdampak untuk menghindari masalah nama yang sama. Kami mohon maaf atas ketidaknyamanan yang ditimbulkan.',
    'domain__cannot_change_webmail' => 'Tidak dapat mengubah webmail untuk domain: %1',
    'sb_publish_disable_warning' => 'Jika Anda mematikan pembuatan situs web dengan Presence Builder, situs web sebelumnya yang dibuat dengan Presence Builder akan terhapus dan seluruh data situs web akan hilang. Klik OK jika Anda ingin melanjutkan.',
    '__sbnet_client_use_sbnet' => "Buat akun pengguna yang sesuai pada Presence Builder",
    'mail_resp_activate' => 'Aktifkan balas otomatis.',
    'limitsManger__limit_available_error' => 'Tidak dapat mengalokasikan jumlah sumber daya yang dibutuhkan ("%%limitName%%"): hanya %%available%% yang tersedia untuk akun Anda.',
    'limitsManger__limit_reserved_error' => 'Tidak dapat mengalokasikan sumber daya lebih sedikit ("%%limitName%%") dari yang telah digunakan.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Tidak dapat mengubah nama domain: Direktori virtual dengan nama yang ditentukan sudah ada.',
    'domain_unable_to_rename' => 'Tidak dapat mengubah nama domain.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Umum',
    'spamfilter__spamassassin_status_legend' => 'Filter spam SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Pengaturan SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Hidupkan filter spam SpamAssassin pada seluruh server",
    'spamfilter__spamassassin_user_status_legend' => 'Hidupkan filter Spam SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Hidupkan perlindungan spam greylisting seluruh server',
    'spamfilter__personal_settings_not_allowed' => 'Penggunaan pengaturan filter spam individual tidak diperbolehkan berdasarkan kebijakan sistem.',
    'spamfilter__required_score' => 'Nilai yang harus diterima oleh suatu pesan untuk dianggap sebagai spam',
    'spamfilter__rewrite_header_subject' => 'Tambahkan teks berikut ini ke bagian awal subjek setiap pesan yang dianggap spam',
    'spamfilter__use_mailuser_prefs' => 'Terapkan pengaturan individual ke filter spam',
    'spamfilter__score_error' => 'Nilai tidak boleh negatif, bagian sebelum nilai desimal harus lebih kecil dari 100, dan tidak boleh mengandung lebih dari dua digit setelah titik desimal.',
    'spamfilter__rewrite_header_error' => 'Subjek pesan dapat mengandung karakter cetak apa pun kecuali simbol angka (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Pantulkan',
    'nonexistent_mail__mode_discard' => 'Buang',
    'nonexistent_mail__mode_catch_addr' => 'Teruskan ke alamat surel',
    'nonexistent_mail__mode_catch_ip' => 'Teruskan ke IP',
    'nonexistent_mail__bounce_not_supported' => 'Mode pantul tidak didukung',
    'nonexistent_mail__discard_not_supported' => 'Mode buang tidak didukung',
    'nonexistent_mail__catch_not_supported' => 'Penerusan ke alamat surel tidak didukung',
    'nonexistent_mail__redirect_not_supported' => 'Penerusan ke IP tidak didukung',
    'nonexistent_mail__ip_used_on_this_host' => 'Alamat IP diarahkan ke localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Kontrol surat keluar yang dihidupkan menyebabkan alamat surel %1 untuk penerima yang tidak ada menjadi milik domain terpilih. Jika tidak, maka kebijakan "Tolak" akan dilaksanakan dan bukan forwarding.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Kontrol surat keluar yang dihidupkan menyebabkan alamat surel yang ditentukan untuk penerusan surat (%1) menjadi milik domain pilihan. Jika tidak, maka pesan yang dikirim ke alamat ini tidak akan dihitung pada Kontrol Surat Keluar.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Akun administrator tambahan tidak tersedia.', // PFW
    'ui__client/domain/certificate__none-available' => 'Pelanggan tidak memiliki sertifikat SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Pelanggan tidak memiliki domain bersertifikat SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Domain tidak bersertifikat SSL/TLS.',
    'ui__reseller/client__none-available' => 'Tidak ada penyalur dengan pelanggan.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Anda harus memilih alamat IP yang ingin Anda hapus dari kumpulan IP',
    'ui__server/ip-address/client/delete__empty_selection' => 'Anda harus memilih alamat IP akun penyalur yang dari kumpulan IP-nya Anda ingin menarik alamat IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Anda harus memilih tugas yang ingin Anda batalkan.',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'Dukungan ASP.NET dimatikan untuk situs web ini.',
    'phosting__php_forced_by_site_isolation' => 'Tidak dapat mengubah pengaturan PHP: izin untuk menimpa kebijakan keamanan seluruh server tidak diberikan.',
    'phosting__option_forced_by_site_isolation' => 'Tidak dapat mengubah pengaturan %1: izin untuk menimpa kebijakan keamanan seluruh server tidak diberikan.',
    'phosting__php_handler_id_not_registered' => 'Penangan PHP tidak diizinkan dalam pengaturan isolasi situs. Penangan PHP default akan digunakan.',
    'phosting__php_served_by_nginx_is_not_available' => 'Penangan PHP (aplikasi FPM dilayani oleh nginx) tidak diizinkan dalam pengaturan isolasi situs. Penangan PHP default akan digunakan.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Lihat daftar alamat IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Lihat daftar alamat IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Lihat daftar alamat IP yang tersedia untuk pengguna ini.',
    'ui__server/certificate__short-title' => 'Sertifikat SSL/TLS',
    'ui__server/certificate__title' => 'Sertifikat SSL/TLS',
    'ui__server/certificate__description' => 'Lihat dan kelola sertifikat SSL/TLS.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Hapus Alamat IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Pilih alamat IP yang ingin Anda hapus dari kumpulan IP pelanggan %1',

    // mail

    'ui__client/ipaddress__short-title' => 'Alamat IP',
    'ui__client/ipaddress__title' => 'Alamat IP',
    'ui__client/ipaddress__description' => 'Lihat informasi mengenai alamat IP.',
    'ui__server/ip-address__short-title' => 'Alamat IP',
    'ui__server/ip-address__title' => 'Alamat IP',
    'ui__server/ip-address__description' => 'Lihat informasi mengenai alamat IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Pengaturan Hosting Web',
    'ui__client/domain/hosting/setup__title' => 'Pengaturan Hosting Web',
    'ui__client/domain/hosting/setup__description' => 'Atur pengaturan hosting web untuk situs web %1.',

    // tooltips

    'b_get_password_cancel' => 'Kembali ke layar sebelumnya tanpa mengirimkan surel.',
    'b_get_password_send' => 'Klik OK untuk mengirim pesan pemulihan kata sandi ke alamat surel yang terdaftar di sistem.',



    'b_personaltrafficlist_search' => 'Masukkan pola pencarian dan klik untuk menemukan domain.',
    'b_personaltrafficlist_show_all' => 'Tunjukkan semua domain.',

    'b_back' => 'Kembali ke halaman sebelumnya.',
    'b_next' => 'Pergi ke halaman berikutnya.',

    'b_dnsnstemplatelist_remove' => 'Hapus server nama terpilih.',
    'b_dnsnstemplatelist_search' => 'Masukkan pola pencarian dan klik untuk menemukan server nama.',
    'b_dnsnstemplatelist_show_all' => 'Tunjukkan semua server nama.',

    'l_dnsnstemplatelist_ns' => 'Urutkan catatan template DNS berdasarkan name server.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Buat tautan aman ke file dan folder',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Aktifkan file publik',
    'cu__serverfilesharing_fsPublicFolder' => 'Folder untuk penyimpanan file publik',
    'cu__serverfilesharing_fsPublicUrl' => 'URL untuk akses pengunjung ke file publik',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Aktifkan perlindungan kata sandi file publik',
    'cu__serverfilesharing_fsPartnerFolder' => 'Folder untuk penyimpanan file terlindung kata sandi',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nama pengguna untuk akses file',
    'cu__serverfilesharing_fsPartnersPassword' => 'Kata sandi untuk akses file',
    'cu__serverfilesharing_fsDomain' => 'URL root folder Web. Nama domain',
    'cu__serverfilesharing_fsPrefix' => 'URL root folder Web. Prefiks',
    'cu__serverfilesharing_commandUpdate' => 'Perbarui pengaturan berbagi file',
    'cu__serverfilesharing_commandInfo' => 'Tampilkan pengaturan berbagi file terkini',
    'subscription_rename_is_forbidden' => 'Mengganti nama langganan tidak boleh dilakukan atas dasar kebijakan seluruh server.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Kelola Tugas Terjadwal pada Server',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Pilih pengguna sistem yang tugas terjadwalnya ingin Anda kelola.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Tugas Terjadwal %1',
    'ui__server/crontab/task__description' => 'Lihat properti tugas terjadwal %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Pengguna Sistem',
    'ui__server/crontab_unknown__title' => 'Pengguna Sistem',
    'ui__server/crontab_unknown__description' => 'Pengguna sistem yang dapat menjadi pemilik tugas terjadwal.',


    'ui__server/crontab__none-available' => 'Anda tidak memiliki akun pengguna sistem.',
    'ui__server/crontab_readonly-unknown__description' => 'Lihat tugas terjadwal.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Tugas terjadwal',
    'ui__server/crontab_readonly-unknown__title' => 'Lihat tugas terjadwal',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Lihat tugas terjadwal.',
    'ui__server/crontab_readonly__description' => 'Lihat tugas terjadwal %1.',
    'ui__server/crontab_readonly__short-title' => 'Tugas Terjadwal %1',
    'ui__server/crontab_readonly__title' => 'Lihat tugas terjadwal %1',
    'ui__server/crontab_unknown__wizard-title' => 'Kelola tugas terjadwal.',

    'ui__server/crontab/properties__description' => 'Sunting tugas terjadwal %1.',

    'ui__server/crontab/properties__short-title' => 'Pengaturan',
    'ui__server/crontab/properties__title' => 'Sunting tugas terjadwal %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Lihat tugas terjadwal.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Pengaturan',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Lihat tugas terjadwal',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Lihat tugas terjadwal.',
    'ui__server/crontab/properties_readonly__description' => 'Lihat tugas terjadwal %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Pengaturan',
    'ui__server/crontab/properties_readonly__title' => 'Lihat tugas terjadwal %1',
    'ui__server/crontab/properties_unknown__description' => 'Sunting tugas terjadwal.',
    'ui__server/crontab/properties_unknown__short-title' => 'Properti',
    'ui__server/crontab/properties_unknown__title' => 'Sunting tugas terjadwal',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Sunting tugas terjadwal.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Pilih pengguna sistem yang tugasnya ingin Anda lihat.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Pilih pengguna sistem yang tugasnya ingin Anda ubah.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klik Selesai untuk keluar dari panduan.',

    'ui__server/crontab/task__none-available' => 'Anda tidak memiliki tugas terjadwal.',
    'ui__server/crontab/task__none-available__2' => 'Pengguna sistem %1 tidak memiliki tugas terjadwal.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Tugas terjadwal.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tugas',
    'ui__server/crontab/task_readonly-unknown__title' => 'Tugas terjadwal',

    'ui__server/crontab/task/delete__description' => 'Hapus tugas terjadwal %1',

    'ui__server/crontab/task/delete__short-title' => 'Hapus',
    'ui__server/crontab/task/delete__title' => 'Hapus tugas terjadwal %1',
    'ui__server/crontab/task/delete_multi__description' => 'Hapus tugas terjadwal.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Hapus',
    'ui__server/crontab/task/delete_multi__title' => 'Hapus tugas terjadwal',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Hapus tugas terjadwal.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Pilih pengguna sistem yang tugasnya ingin Anda hapus.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Pilih tugas yang ingin Anda hapus.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Konfirmasi penghapusan tugas dengan memilih kotak centang dan klik Selesai untuk menyelesaikan panduan.',
    'ui__server/crontab/task/delete_unknown__description' => 'Hapus tugas terjadwal.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Hapus',
    'ui__server/crontab/task/delete_unknown__title' => 'Hapus tugas terjadwal',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Hapus tugas terjadwal.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Pilih pengguna sistem yang tugasnya ingin Anda hapus.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Pilih tugas yang ingin Anda hapus.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Konfirmasi penghapusan tugas dengan memilih kotak centang dan klik Selesai untuk menyelesaikan panduan.',

    'ui__server/crontab/task/properties__description' => 'Sunting tugas terjadwal.',

    'ui__server/crontab/task/properties__short-title' => 'Sunting tugas %1.',
    'ui__server/crontab/task/properties__title' => 'Sunting tugas terjadwal',
    'ui__server/crontab/task/properties_new__description' => 'Buat tugas terjadwal untuk %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Tambah tugas',
    'ui__server/crontab/task/properties_new__title' => 'Buat tugas terjadwal untuk %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Buat tugas terjadwal.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Pilih pengguna sistem yang ingin Anda buatkan tugas terjadwal.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Lihat tugas terjadwal.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Properti',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Lihat tugas terjadwal',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Lihat tugas terjadwal.',
    'ui__server/crontab/task/properties_readonly__description' => 'Lihat tugas terjadwal.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Lihat tugas %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Lihat tugas terjadwal',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Buat tugas terjadwal.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Tambah tugas',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Buat tugas terjadwal',
    'ui__server/crontab/task/properties_unknown__description' => 'Sunting tugas terjadwal.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Properti',
    'ui__server/crontab/task/properties_unknown__title' => 'Sunting tugas terjadwal',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Sunting tugas terjadwal.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Pilih pengguna sistem yang tugasnya ingin Anda lihat.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Pilih pengguna sistem yang tugasnya ingin Anda ubah.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Pilih tugas terjadwal.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Pilih tugas terjadwal yang ingin Anda ubah.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klik Selesai untuk keluar dari panduan.',

    'ui__server/crontab/task/toggle_disable__description' => 'Nonaktifkan tugas terjadwal %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Nonaktifkan',
    'ui__server/crontab/task/toggle_disable__title' => 'Nonaktifkan tugas terjadwal %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Aktifkan tugas terjadwal %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Aktifkan',
    'ui__server/crontab/task/toggle_enable__title' => 'Aktifkan tugas terjadwal %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Aktifkan atau nonaktifkan tugas terjadwal.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Aktifkan atau nonaktifkan',
    'ui__server/crontab/task/toggle_unknown__title' => 'Aktifkan atau nonaktifkan tugas terjadwal',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Aktifkan atau nonaktifkan tugas terjadwal',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Pilih akun pengguna sistem yang tugasnya ingin Anda aktifkan atau nonaktifkan.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Pilih tugas yang ingin Anda aktifkan atau nonaktifkan.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Akun pelanggan', // not used on HP?
    'ui__client_unknown__title' => 'Akun pelanggan', // not used on HP?
    'ui__client_unknown__description' => 'Kelola akun pelanggan.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Tangguhkan domain', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Tangguhkan domain', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Tangguhkan domain.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktifkan domain', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktifkan domain', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktifkan domain', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Akun FTP Di bawah Domain %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Akun FTP",
    'ftp__user_name' => "Nama akun FTP",
    'ftp__user_home' => "Direktori beranda",
    'ftp__invalid_path' => "Jalur yang ditentukan tidak valid",
    'i_ftp_ses_sub_user' => 'Sesi akun FTP.',
    '__new_passwd' => "Kata sandi %1 baru",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Tidak dapat mengonfigurasi server web pada host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Tidak dapat membuat file konfigurasi server web pada host <%%host%%> karena adanya galat berikut:\n\n%%error%%\n\nHarap perbaiki galat pada template konfigurasi server web dan buat kembali file.",

    'apacheConfigurationMessageAdminTitle' => 'Pembuatan konfigurasi server web gagal',
    'apacheConfigurationMessageClientTitle' => 'Peringatan',

    'apacheConfigurationFailedAdminHomeMessage' => 'File konfigurasi baru tidak dapat dibuat karena terjadi galat pada template konfigurasi. Pesan yang berisi galat terperinci telah dikirim ke surel Anda. Mohon periksa surel, perbaiki galat, dan klik %1 untuk mencoba kembali membuat konfigurasi.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'di sini', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Konfigurasi baru untuk domain %1 tidak dapat dibuat karena terjadi galat pada template konfigurasi. Pesan yang berisi galat terperinci telah dikirim ke surel Anda. Mohon periksa surel, perbaiki galat, dan klik %2 untuk mencoba kembali membuat konfigurasi.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'di sini', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Konfigurasi server web untuk domain %1 mungkin tidak konsisten. Harap hubungi administrator server untuk mengatasi masalahnya.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Konfigurasi baru untuk beberapa domain tidak dapat dibuat karena terjadi galat pada template konfigurasi. Pesan yang berisi galat terperinci telah dikirim ke surel Anda. Mohon periksa surel, perbaiki galat, dan klik %1 untuk mencoba kembali membuat konfigurasi.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'di sini', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Konfigurasi server web untuk beberapa domain Anda mungkin tidak konsisten. Harap hubungi administrator server untuk mengatasi masalahnya.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Dokumen galat suai",
    'dom_pref__webusers_script' => "Izinkan pengguna web untuk menggunakan skrip",
    '__seoRedirect' => 'Buat konfigurasi domain yang dipilih sebagai',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Tidak ada',

    '__sites' => 'Domain',
    'domain_plan__perm_denied_manage_phosting' => 'Anda tidak memiliki izin untuk mengelola pengaturan hosting.',
    '__owned_by_client' => 'dimiliki oleh pelanggan',
    'ui__client/permissions_readonly__description' => "Lihat tindakan yang dapat dilakukan pelanggan %1 di Plesk.",
    'backup__restore__object_client_template' => 'Template pelanggan',
    '__template_name' => 'Nama paket layanan',
    'template__not_exists' => 'Paket layanan tidak tersedia',
    'template__exists' => 'Paket dengan nama %1 sudah ada.',
    'clientOwnerChanger__ip_not_in_pool' => 'Alamat IP yang dipilih tidak terdapat pada kumpulan penyalur.',

    //// Change owner of subscription
    'chown__select_title' => "Pilih Pemilik Langganan Baru",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Pilih pemilik baru untuk langganan terpilih dan klik Selanjutnya >>.',
    'domains__client_info' => "Langganan %1, langganan aktif %2, ruang disk digunakan %3, lalu-lintas digunakan %4",
    '__possible_owners' => 'Pemilik baru langganan yang mungkin',

    'clients_list__filter_owner__filter_title' => 'Penyedia',
    'clients_list__filter_owner_any' => 'Semua pengguna',
    'clients_list__filter_owner_my' => 'Hanya pemilik langganan saya',
    'clients_list__filter_owner_name__filter_title' => 'Nama penyedia',

    '__owner' => "Penyedia",
    'l_clientslist_owner' => 'Urutkan akun pengguna berdasarkan penyedia layanan.',
    'l_clientslist_date' => 'Urutkan akun pengguna berdasarkan tanggal pembuatan.',
    'l_clientslist_name' => 'Urutkan akun pengguna berdasarkan nama.',
    'l_clientslist_domains' => 'Urutkan akun pengguna berdasarkan domain.',
    'l_clientslist_cname' => 'Urutkan akun pengguna berdasarkan nama perusahaan.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Mengalihkan Langganan Terpilih',
    'chown__check_title' => 'Ubah Pemilik Langganan',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klik Selesai untuk mengakhiri penetapan ulang. Ketika telah selesai, langganan terpilih akan dialihkan kepada pemilik baru, penyedia layanannya akan diganti ke penyedia layanan pemilik baru, dan mereka akan terlepas dari paket layanannya dan menjadi 'Suai'.",

    'chown__error_check' => 'Beberapa masalah muncul ketika mencoba menetapkan beberapa langganan ke pemilik baru.',
    'domain_chown_subscription_will_be_anonymous' => "Langganan akan terlepas dari paket layanan mereka saat ini dan menjadi 'Suai'.",
    'chown__error_domains_exclude' => "Beberapa masalah muncul ketika mencoba menetapkan beberapa langganan ke pemilik baru. Langganan ini disorot.",
    'chown__ip_not_in_client_pool' => "Alamat IP terkait dengan langganan ini tidak ditambahkan ke kumpulan IP pemilik baru.",
    'chown__already_owned_by_client' => "Langganan berikut merupakan milik pengguna ini.",

    '__redirect_hint' => 'Anda akan diarahkan ke alamat baru dalam 15 detik... Jika Anda tidak diarahkan secara otomatis ke lokasi baru, silakan menghidupkan javascript atau klik hyperlink %%link%%.',

    'backup__restore__object_maillist' => 'Milis',
    'backup__restore__object_site' => 'Situs',
    'backup__restore__object_user' => 'Pengguna',
    'backup__restore__object_role' => 'Peran',

    'limit__name_max_site' => 'situs',

    'iis_pool__unable_rename_client' => "Tidak dapat mengganti nama Kumpulan Aplikasi IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Layanan FTP anonim hanya didukung pada domain utama langganan.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Layanan FTP anonim hanya didukung pada domain utama dari langganan.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/bulan',
    '__tb_month' => 'TB/bulan',

    '__customers' => 'Pelanggan',
    '__customer_name' => 'Nama pelanggan',
    '__customer_total' => 'Total pelanggan',
    '__site' => 'Situs',
    '__def_site' => 'Situs default',
    '__subscription_name' => 'Nama langganan',
    '__subscription_name_powerUser' => 'Nama langganan',

    'limit__units_max_traffic_suffix' => '/bulan',

    'dom_pref__discard' => "Tolak",

    'mail__pattern_already_exists' => 'Pola "%1" sudah ada dalam daftar hitam.',

    '__not_supported' => 'Tidak didukung',

    'plesk_key__sitebuilder' => 'Situs yang diterbitkan dengan Presence Builder',
    'limit__name_max_site_builder' => 'Situs yang diterbitkan dengan Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Mendukung situs multi-bahasa di Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statistik Transfer Data untuk <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statistik Transfer Data untuk <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Transfer data oleh layanan",

    'login_up__access_denied_no_subscriptions' => "Akses ditolak. Tidak ada langganan yang tersedia untuk akun ini.",

    'interval__day' => '%1 hari',
    'interval__hour' => '%1 jam',
    'interval__minute' => '%1 menit',
    'interval__second' => '%1 detik',

    ///License options
    'plesk_key__backward_incompatibility' => 'Anda sedang mencoba menggunakan kunci lisensi yang dibuat untuk versi Plesk lain. Hubungi perwakilan penjualan Plesk untuk mendapatkan kunci lisensi yang benar.',
    //Standalone or virtualization
    'virtualization_any' => "Server fisik atau solusi virtualisasi apa pun",
    'virtualization_pvc' => "Penampung Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Server Virtuozzo",
    'plesk_key__virtualization' => "Valid untuk kondisi sebagai berikut:",
    'plesk_key__virtualization_only_key' => 'Kunci lisensi hanya untuk penggunaan dengan Plesk yang beroperasi di dalam lingkungan virtual %1.',
    'plesk_key__virtualizations_only_key' => 'Kunci lisensi hanya untuk penggunaan Plesk yang beroperasi di dalam lingkungan virtual sebagai berikut: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Penggunakan paket bahasa suai tidak diperbolehkan.',
    'plesk_key__allowed-locales' => 'Bahasa yang tersedia',
    'plesk_key__allowed-locales-any' => 'Bahasa lainnya',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'direktori cgi-bin terletak di',
    '_cgi_bin_mode_webspace' => 'direktori root dari langganan',
    '_cgi_bin_mode_www_root' => 'root dokumen domain ini',

    /// Custom buttons
    'custom_button__sort_key' => 'Prioritas',
    'custom_button__place' => 'Lokasi',
    'custom_button__place_navigation' => 'Akses Umum',
    'custom_button__place_admin' => 'Halaman Beranda Administrator',
    'custom_button__place_admin-settings' => 'Halaman Perangkat & Pengaturan Administrator',
    'custom_button__place_reseller' => "Halaman beranda penyalur",
    'custom_button__place_reseller-settings' => 'Halaman Alat & Pengaturan penyalur',
    'custom_button__place_client' => 'Halaman Beranda Pelanggan',
    'custom_button__place_domain' => "Halaman Langganan Situs Web & Domain",
    'custom_button__place_domain_powerUser' => "Halaman Langganan Situs Web & Domain",
    'custom_button__place_domain-properties' => 'Alat Situs Web',
    'custom_button__private' => 'Tunjukkan hanya kepada saya',
    'custom_button__image' => 'Gambar latar',
    'custom_button__conhelp' => "Teks Tooltip",
    'custom_button__edit' => "Pengaturan Tautan ke Layanan Tambahan",
    'custom_button__include_client_cname' => "Sertakan nama perusahaan pelanggan",
    'custom_button__include_client_email' => "Sertakan surel pelanggan",
    'custom_button__include_client_id' => "Sertakan ID pelanggan",
    'custom_button__include_client_pname' => "Sertakan nama kontak pelanggan",
    'custom_button__include_domain_id' => "Sertakan ID langganan, ID domain, dan ID alias domain",
    'custom_button__include_domain_id_powerUser' => "Sertakan ID langganan, ID domain, dan ID alias domain",

    'custom_button__include_domain_name' => "Sertakan Nama Domain Utama",
    'custom_button__include_ftp_user' => "Sertakan nama pengguna FTP",
    'custom_button__include_ftp_pass' => "Sertakan kata sandi FTP",
    'custom_button__internal_open' => "Buka URL di Plesk",
    'custom_button__text' => "Label Tombol",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'File bukan file gambar.',
    'custom_button__big_image' => 'Ukuran file tidak boleh melebihi 100 KB.',
    'custom_button__failed_copy_image' => 'Tidak dapat menyalin file: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Tidak dapat memulihkan cadangan non-Power User dalam tampilan Power User.',
    '__unknown_network_interface' => 'Antarmuka jaringan tidak dikenal',

    'init_conf__ip_address' => 'Alamat IP',

    //Confirmation page
    'bt_confirm' => 'Konfirmasi',
    'b_confirm' => 'Konfirmasi kepemilikan atas situs Anda.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Pengaturan kumpulan aplikasi IIS khusus diatur berdasarkan kebijakan keamanan seluruh server (konfigurasi isolasi situs).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Pengaturan kumpulan aplikasi IIS khusus diatur berdasarkan pengaturan kinerja server keseluruhan',

    '__current' => 'Terkini',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Anda telah menggunakan hampir seluruh domain yang disediakan oleh lisensi Plesk Anda (90% atau bahkan lebih).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Anda telah menggunakan hampir seluruh domain.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Anda telah menggunakan hampir seluruh situs Presence Builder yang disediakan oleh lisensi Plesk Anda (90% atau bahkan lebih).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Anda telah menggunakan hampir seluruh situs Presence Builder.',
    'promo__button_hide' => 'Sembunyikan',
    'promo__button_next' => 'Berikutnya >>',
    'promo__button_prev' => '<< Sebelumnya',
    'promo__button_license' => 'Perbarui Lisensi',

    'promo__google_integration_title' => 'Integrasi dengan layanan Google',
    'promo__google_integration' => 'Konfigurasi integrasi dengan layanan Google, seperti perangkat AdSense, Google Apps, Webmaster.',
    'promo__google_integration_button' => 'Konfigurasi',

    'promo__button_learn_more' => 'Pelajari Lebih Jauh',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Anda dapat menyesuaikan tampilan antarmuka dan merek dengan menggunakan tema suai. Untuk petunjuk mengenai ubah suai tema Plesk, silakan mengacu ke %1.',
    'panel_branding__description_link' => 'Mengikuti dokumen',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Ekstrak File',
    'filemanager_error_extracting_files' => 'Galat terjadi ketika mengekstrak file arsip: %1',
    'filemanager_no_archive_files_specified' => 'Tentukan arsip yang akan Anda ekstrak.',
    'filemanager_not_zip_archive_specified' => '%1 tidak dapat diekstrak, file tersebut bukan arsip ZIP.',
    'filemanager_files_successfully_extracted' => 'File arsip telah diekstrak.',
    'filemanager_error_file_download' => 'Gagal mengunduh file: %1',
    'filemanager__user_poolgrp' => 'Kelompok kumpulan aplikasi',

    'loading' => 'Memuat...',
    'bt_create_archive' => 'Tambahkan ke Arsip',
    'filemanager__pack' => "Jalur ke arsip: %1",
    'filemanager__archive_name' => 'Nama file arsip',
    'filemanager__empty_filename' => 'Silakan masukkan nama file arsip.',
    'filemanager_archive_created' => 'Arsip berhasil dibuat.',
    'filemanager_error_creating_archive' => 'Tidak dapat membuat arsip: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Catatan ini akan bentrok dengan catatan AAAA untuk zona tersebut.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Server FTP tidak mendukung alamat IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Catatan ini akan bentrok dengan catatan lem untuk zona \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Server FTP tidak mendukung alamat IPv6.)",
    '__ipv6_not_supported' => 'Tidak mendukung IPv6',
    'mail__ipv6_not_supported' => 'IPv6 tidak didukung oleh server surat.',
    'mail__relay_while_list_ipv6_not_supported' => 'Daftar putih relai IPv6 tidak didukung oleh server surat.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Nilai masker harus berupa kelipatan 16.',
    'mail__ip_or_mask_is_invalid' => 'Alamat atau masker IP tidak valid.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Penerusan ke alamat IP IPv6 tidak didukung.',
    'sa__invalid_trusted_networks' => 'Jaringan terpercaya yang diberikan salah: %1',
    'dns_add__enter_ipv6_address' => "Alamat IPv6",
    'license_trial_days_left' => 'Plesk Anda beroperasi dengan lisensi percobaan yang akan kedaluwarsa dalam waktu %1 hari.',
    'excl_ipv6_num' => 'Alamat IPv6 khusus',
    '__ip_mask' => "Masker Subnet",
    '__ipv4_addr' => 'Alamat IPv4',
    '__ipv6_addr' => 'Alamat IPv6',
    'template__num_excl_ipv6s' => 'Alokasi alamat IPv6 khusus kepada penyalur',
    'anonftp__exclusive_ipv4_required' => 'Alamat IPv4 khusus dibutuhkan untuk mengatur dan menggunakan layanan FTP anonim.',
    'anonftp__ipv4_already_used' => 'Tidak dapat mengatur layanan FTP anonim untuk situs ini karena telah dikonfigurasi pada domain lain di alamat IPv4 yang sama.',


    'restart__kav' => "Antivirus Kaspersky",
    '__view_migration_log_detailed_info' => 'Lihat catatan',

    'chown__ip_address_warn' => 'Sebelum memindahkan langganan ke pemilik baru, pilih alamat IP baru untuk langganan tersebut terlebih dulu.',
    'chown__no_ip_address' => 'Tidak ada',
    'chown__no_ipv4_address' => 'Tidak ada alamat IPv4',
    'chown__no_ipv6_address' => 'Tidak ada alamat IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Langganan %1 sudah menjadi milik pengguna tersebut.',
    'chown__error_ip_absent_in_ip_pool' => 'Alamat IP %1 tidak ada dalam kumpulan IP pengguna sasaran.',
    'chown__error_ip_not_exist' => 'Alamat IP dengan ID \'%1\' tidak ada.',
    'chown__error_domain_ip_not_selected' => 'Setidaknya satu alamat IP untuk domain %1 harus dipilih. Periksa nilai yang dipilih untuk pemetaan IP.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'Alamat atau masker IPv6 tidak valid: alamat IP harus berupa alamat unicast yang valid.',

    '__subscriptions' => 'Langganan',

    '__owned_by_reseller' => 'dimiliki oleh penyalur',
    '__owned_by_provider' => 'dimiliki oleh penyedia',

    'service_plan__anonymous' => 'Suai',
    'subscription_not_locked__change_limits_warning' => 'Langganan ini tidak terkunci: Batasan penggunaan sumber daya akan berubah selama proses sinkronisasi dengan paket layanan.',
    'subscription_not_locked__change_permissions_warning' => 'Langganan ini tidak terkunci: Izinnya akan berubah selama proses sinkronisasi dengan paket layanan.',

    'subscription__conflict_resolution_policy' => 'Kebijakan konflik resolusi',
    'subscription__conflict_resolution_policy_lock' => "Kunci langganan",

    'backup__list__backup_warnings' => 'Peringatan',
    'backup__list__backup_info' => 'Informasi',
    'backup__restore__object_reseller_template' => 'Template penyalur',
    'backup__restore__object_domain_template' => 'Template domain',

    'ui__client/permissions_readonly__title' => 'Izin',
    'ui__client/permissions_readonly__short-title' => 'Izin',

    'subscription__unable_lock_anonymous' => 'Langganan ini tidak terikat pada paket layanan, dan tidak dapat dibuka kuncinya.',
    'subscription__unable_sync_anonymous' => 'Langganan ini tidak terikat pada paket layanan, sehingga tidak dapat disinkronkan.',
    'subscription__unable_sync_locked' => 'Langganan ini terkunci dan tidak dapat disinkronisasi.',
    'subscription__locked' => 'Langganan terkunci.',
    'component_name__urlrewrite' => "Tulis Ulang URL",
    '__quantity' => 'Kuantitas',
    'hst__www_root_dir_absent' =>  'Peringatan: direktori yang ditentukan sebagai root dokumen tidak ada.',
    'object_creation__domain_is_not_a_webspace' => 'Objek ini hanya dapat dibuat dalam langganan.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Langganan berisi situs, karenanya Anda tidak dapat mengubah tipe hosting atau menghapusnya.',
    'phosting__apache_error_docs_are_not_enabled' => 'Dokumen kesalahan suai tidak diaktifkan pada domain.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Kesalahan: Gagal memperbarui alamat IP. Domain addon tidak dapat ditugaskan dengan alamat IP yang tidak ditugaskan ke domain utama dari langganan.',
    'domain_plan__unable_change' => 'Tidak dapat mengubah paket layanan: %1.',
    'domain_plan__different_hosting_type' => 'Tipe hosting saat ini berbeda dengan tipe yang ditentukan di paket layanan.',
    'domain_plan__addon_text' => 'Paket add-on',
    'domain_plan__addon_description' => 'Paket Add-on digunakan untuk melengkapi paket hosting.',
    'asp_net__managed_runtime_version' => 'Versi runtime diatur ASP.NET',
    'plan__can_not_change_hosting_type' => 'Tipe hosting tidak mungkin dapat diubah ketika menyunting paket.',
    'plan__apply_problems' => 'Paket tidak diberlakukan karena ada masalah dengan fungsi berikut: %1',
    'plan_save__subscription_update_problem' => 'Tidak dapat menerapkan perubahan paket sampai %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Langganan ditangguhkan sementara sampai proses pencadangan atau pemulihan selesai. Harap kembali beberapa saat lagi.",
    '__login_incorrect_plain_shadow_password' => 'Anda memasukkan kata sandi yang salah ke akun administrator. Harap gunakan informasi akses administrator sistem (root), atau dapatkan kata sandi yang benar. Untuk mempelajari lebih jauh tentang cara mendapatkan kata sandi, baca /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Anda tidak dapat mengirim alamat IP yang tidak Anda miliki',

    'dns__dns_zone_not_synchronized' => 'Zona DNS telah dimodifikasi. Bila Anda ingin menerapkan perubahan template DNS ke zona ini, klik tombol \'Terapkan perubahan DNS Template\' di halaman ini atau pilih opsi \'Terapkan perubahan ke semua zona\' di Panel Administrasi Server > Alat & Pengaturan > Pengaturan Template DNS > Terapkan perubahan Template DNS.',
    'dns__dns_zone_synchronize_link' => 'Klik',
    'dns__dns_zone_synchronize_done' => 'Zona DNS berhasil disinkronkan.',

    'dns__dns_zone_template_error' => 'Ada masalah dalam menyinkronkan zona DNS dengan template zona DNS.%1',

    'dns__soa_rname_type_owner' => 'Alamat surel pemilik situs web',
    'dns__soa_rname_type_domain' => 'Alamat surel domain',
    'dns__soa_rname_type_external' => 'Alamat surel eksternal',
    'dns__soa_rname_enforce_email' => 'Larang perubahan alamat surel RNAME per domain',
    'dns__soa_rname_label' => 'Alamat surel (RNAME)',
    'dns__soa_rname_hint' => 'Alamat surel penanggung jawab zona DNS domain. Jawaban server DNS dalam merespons kueri SOA.',

    'dns__dns_zone_soa_sync_title' => 'Timpa pengaturan SOA untuk semua domain yang ada',
    'dns__dns_zone_soa_sync_legend' => 'Diperlukan konfirmasi',
    'dns__dns_zone_soa_sync_text' => 'Perbarui catatan SOA pada semua domain yang di-host dengan menerapkan perubahan yang dibuat pada template SOA?',

    'cu_db__repair_mysql_dbus' => "Perbaiki kata sandi pengguna MariaDB/MySQL. Tindakan ini diperlukan jika Anda meningkatkan versi sebelumnya ke Plesk 11.",

    'cu_scheduled_backup_comment' => 'Pencadangan Terjadwal',
    'cu_scheduled_backup_error' => 'Kesalahan terjadi selama proses pencadangan: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Kesalahan terjadi selama proses pencadangan terjadwal.',
    'cu_scheduled_backup_mail_message' => "%1\nTitik entri Plesk: %2\n\nKesalahan berikut terjadi selama proses pencadangan terjadwal:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Pencadangan Per Jam',
    'cu_scheduled_backup_daily' => 'Pencadangan Harian',
    'cu_scheduled_backup_weekly' => 'Pencadangan Mingguan',
    'cu_scheduled_backup_monthly' => 'Pencadangan Bulanan',
    'cu_scheduled_backup_comment_backup_all' => '%1. Semua konfigurasi dan isi.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Semua konfigurasi dan isi kecuali pesan surat.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Hanya konfigurasi dan pesan surat.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Semua konfigurasi dan isi kecuali basis data pengguna.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Semua konfigurasi dan isi kecuali basis file pengguna.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Hanya konfigurasi dan basis data pengguna.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Hanya konfigurasi dan file pengguna',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Konfigurasi domain.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Menyimpan cadangan yang dijadwalkan di penyimpanan awan jauh adalah fitur premium. Hubungi penyedia hosting Anda untuk mengaktifkannya.',

    'i_backup_invalid_file' => 'Cadangan ini tidak valid. Data tidak dapat dipulihkan dari cadangan ini. Klik nama cadangan untuk melihat perincian.',

    'ui__server/migration/download-agent__short-title' => 'Unduh Agen Migrasi & Transfer',
    'ui__server/migration/download-agent__title' => 'Unduh Agen Migrasi & Transfer',
    'ui__server/migration/download-agent__description' => 'Unduh versi terbaru Agen Migrasi & Transfer yang tersedia dari situs web Plesk.',

    'filemanager_resulting_archive_exists' => 'File %1 telah ada di direktori target.',

    'agent_unable_to_connect' => 'Tidak dapat terhubung ke agen di \'%2\'. Pastikan agen telah terpasang dan berfungsi serta tidak ada masalah koneksi dengan host \'%2\'.',
    'agent_test_connection_failed' => 'Koneksi ke agen pada \'%2\' gagal.',

    'agent_unable_to_resolve_host' => 'Tidak dapat menemukan host jauh \'%1\'. Harap pastikan bahwa tidak ada masalah koneksi dengan host tersebut.',
    'agent_unknown_curl_error' => 'Galat \'%1\' terjadi pada saat terhubung ke agen di \'%2\'.',
    'agent_unexpected_htp_code' => 'Kode HTTP \'%1\' yang tidak diharapkan telah diterima untuk permintaan HTTP ke agen pada \'%2\'.',
    'agent_unable_to_auth' => 'Tidak dapat melakukan autentikasi pada host \'%1\'. Untuk memecahkan masalah ini, ikuti petunjuk di http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Terjadi galat server internal pada saat mengeksekusi perintah host jauh \'%1\'.',
    'agent_response_is_empty' => 'Tanggapan kosong diterima atas permintaan HTTP ke agen pada \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Tidak dapat menemukan Agen Migrasi & Transfer di cache lokal. silakan membuka kembali Pengelola Migrasi & Transfer untuk mengatasi masalah ini.',

    '__hosting_webdeploy' => "Penerbitan Web Deploy",
    'cu_domain__webdeploy' => "Penerbitan Web Deploy (default: %1)",
    'cu_dom_tpl__webdeploy' => "Penerbitan Web Deploy (default: %1)",
    'cu_subdomain__webdeploy' => "Penerbitan Web Deploy (default: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy tidak terpasang di server",
    'webdeploy__forced_by_site_isolation' => "Tidak dapat mengubah pengaturan penerbitan Web Deploy: Anda tidak memiliki izin untuk membatalkan kebijakan keamanan di seluruh server. Hubungi penyedia layanan Anda untuk perinciannya.",



    'backup__restore_options__admin__server_configuration_license' => 'Kunci lisensi',
    'migration_start_migrate_server_license' => 'Kunci lisensi transfer',

    'defaultcomponents__delegation_rule_not_exist' => '(aturan delegasi yang diminta \'appPoolPipeline, appPoolNetFx\' tidak ada)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Cadangan telah dibuat oleh administrator.',
    'i_backup_created_by_reseller' => 'Cadangan telah dibuat oleh penyalur.',
    'i_backup_created_by_client' => 'Cadangan telah dibuat oleh pelanggan.',

    'migration__object_exists_on_target_host' => '(sudah ada di host target)',

    '__customers_total' => 'Total oleh pelanggan',
    '__resellers_total' => 'Total oleh penyalur',
    '__reseller_total' => 'Total penyalur',


    'cu_cl_pref__manage_website_maintenance' => 'Akses ke operasi lanjut: Menyalin Situs Web',
    'cu_cl_pref__manage_protected_dirs' => 'Pengelolaan direktori terlindung kata sandi',
    'cu_cl_pref__manage_mail_settings' => 'Kemampuan untuk mengubah pengaturan surat',


    'cu__command_update_php_settings' => 'Perbarui pengaturan PHP.',
    'cu__php_settings_option' => 'Atur jalur ke file dengan pengaturan PHP.',

    'cu__additional_php_settings_option' => 'Atur jalur ke file dengan arahan PHP tambahan.',
    'cu__command_show_php_settings' => 'Tampilan pengaturan PHP terkini.',
    'cu__general_settings' => 'Pengaturan umum:',
    'cu__performance_settings' => 'Pengaturan kinerja:',
    'cu__php_fpm_settings' => 'Pengaturan PHP-FPM:',
    'cu__additional_directives' => 'Arahan tambahan:',

    'php_settings_permission_required' => 'Pengelolaan pengaturan PHP umum',
    'php_settings_performance_permission_required' => 'Pengelolaan pengaturan kinerja hosting',
    'php_settings_customized' => 'Pengaturan PHP diubahsuaikan.',
    'php_settings_synchronized_with_plan' => 'Pengaturan PHP harus disinkronkan dengan paket.',
    'phosting__unknown_shell_type' => 'Shell yang tidak tersedia',

    'login_up__access_denied_subscription_deleted' => 'Akses ditolak: Langganan Anda telah dihapus.',

    'role_restricted_to_subscription' => '(ditransfer dengan langganan: %1)',

    'filemanager__extract' => "Ekstraksi file ke: %1",

    'cu__license_command_check_installed_license' => 'Periksa validitas kunci lisensi terpasang (mengembalikan kode keluar 0 jika kunci tidak valid dan 1 jika valid)',

    'promo__mobile_manager_title' => 'Pengelola Mobile Server Plesk',
    'promo__mobile_manager' => "Perluas fungsi Plesk agar dapat mengontrol dan memonitor server dengan menggunakan perangkat mobile (BlackBerry, iPhone, dan Android).",
    'promo__mobile_monitor_title' => 'Monitor Mobile Server Plesk',
    'promo__mobile_monitor' => 'Dapatkan informasi terpenting mengenai server Plesk kapan pun dan di mana pun dengan menggunakan perangkat mobile (BlackBerry, iPhone, dan Android).',
    'promo__mobile_button' => 'Pelajari Lebih Jauh',

    'ui__server/migration/video__short-title' => 'Video panduan',
    'ui__server/migration/video__title' => 'Lihat video panduan',
    'ui__server/migration/video__description' => 'Lihat video panduan.',

    'subDomainNameHint' => 'Masukkan * sebagai nama subdomain untuk membuat subdomain wildcard. Pengunjung situs akan dialihkan ke subdomain ini tanpa memperhatikan nama subdomain yang dimasukkan ke peramban.',
    'subdomains__wildcard_name_invalid' => "Nama subdomain invalid. Anda hanya dapat menggunakan karakter alfanumerik, tanda penghubung (-), dan bintang (*) untuk nama subdomain wildcard.",
    'subdomains__name_invalid' => "Nama subdomain invalid. Anda hanya dapat menggunakan karakter alfanumerik dan tanda penghubung (-) untuk nama subdomain.",

    'domain__wildcard_no_www_prefix' => 'Tidak dimungkinkan untuk menggunakan prefiks www untuk subdomain wildcard.',

    '__service_title__milter' => "Milter Plesk Postfix",
    '__service_description__milter' => "Filter surat Plesk Postfix",
    '__milter' => "Milter Postfix",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Server Courier POP3",
    'restart__pop3s' => "Server Courier POP3 dengan dukungan SSL/TLS",
    'restart__imap' => "Server Courier IMAP",
    'restart__imaps' => "Server Courier IMAP dengan dukungan SSL/TLS",
    'restart__authdaemon' => "Daemon autentikasi Courier IMAP",
    'restart__imap-pop3' => "Dovecot IMAP dan Server POP3",


    'addon_packages_not_supported' => 'Tidak mendukung add-on untuk aplikasi web paket APS.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Tidak dapat secara otomatis menetapkan alamat IP ke domain. Harap menetapkan alamat IP menggunakan opsi -ip.',

    'plesk_key__mb_accounts' => 'Akun pengguna (penyalur dan pelanggan) di Pengelola Pelanggan dan Bisnis',

    'actionlog__subdomain_dns' => 'Zona DNS subdomain',
    'actionlog__site_subdomain_dns' => 'Zona DNS subdomain di bawah domain tambahan',

    // PfW only
    'actionlog__event_site_create' => 'Domain telah dibuat',
    'actionlog__event_site_delete' => 'Domain telah dihapus',
    'actionlog__event_site_update' => 'Domain telah diperbarui',

    'actionlog__event_site_status_update' => 'Status domain telah diperbarui',
    'actionlog__event_site_dns_update' => 'Zona DNS domain telah diperbarui',
    'actionlog__event_site_guid_update' => 'GUID domain telah diperbarui',

    'actionlog__event_site_subdomain_create' => 'Subdomain telah dibuat',
    'actionlog__event_site_subdomain_delete' => 'Subdomain telah dihapus',
    'actionlog__event_site_subdomain_update' => 'Subdomain telah diperbarui',

    'actionlog__event_site_alias_create' => 'Alias domain telah dibuat',
    'actionlog__event_site_alias_delete' => 'Alias domain telah dihapus',
    'actionlog__event_site_alias_update' => 'Alias domain telah diperbarui',

    'actionlog__event_site_alias_dns_update' => 'Zona DNS alias domain telah diperbarui',
    'actionlog__event_subdomain_dns_update' => 'Zona DNS subdomain di bawah domain default telah diperbarui',
    'actionlog__event_site_subdomain_dns_update' => 'Zona DNS subdomain telah diperbarui',
    // End of PfW only

    'win_policy__bad_password' => 'Validasi gagal. Kata sandi tidak valid.',
    'win_policy__password_too_short' => 'Validasi gagal. Kata sandi tidak sesuai dengan persyaratan kebijakan kata sandi karena terlalu pendek.',
    'win_policy__password_too_long' => 'Validasi gagal. Kata sandi tidak sesuai dengan persyaratan kebijakan kata sandi karena terlalu panjang.',
    'win_policy__password_not_complex_enough' => 'Validasi gagal. Kata sandi tidak cukup rumit dan tidak memenuhi syarat kebijakan kata sandi. Kata sandi yang kuat harus mengandung setidaknya berikut: delapan karakter; satu karakter huruf besar atau huruf kecil; tiga angka dan satu karakter spesial (!, @, #, $, %, ^, &, *, ?, _, ~) atau satu angka dan dua karakter spesial.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Tidak dapat memperbarui lisensi produk.',


    'filemanager__error_path_is_not_allowed' => 'Jalur tidak diizinkan',
    'filemanager__error_path_is_invalid' => 'Jalur tidak valid',
    'filemanager__error_path_not_found' => 'Jalur tidak ditemukan',
    'filemanager__error_path_already_exists' => 'Jalur sudah ada',
    'filemanager__error_access_is_denied' => 'Akses ditolak',
    'filemanager__error_directory_not_empty' => 'Folder tidak kosong',
    'filemanager__error_sharing_violation' => 'Pelanggaran berbagi',
    'filemanager__error_not_same_device' => 'Jalur tujuan tidak berada di perangkat yang sama',
    'filemanager__unable_to_resolve_realpath' => "Tidak dapat menemukan file %1 di lokasi yang ditentukan",
    'filemanager__access_to_realpath_denied' => "Hindi pinayagan ang access sa realpath: %1 sa %2.",
    'bt_exit' => 'Keluar',

    'filemanager__copy_error__' => "Tidak dapat menyalin %1 ke %2: %3",
    'filemanager__copy_move' => "Salin (pindahkan) file dari %1",
    'filemanager__count_size__' => 'Ukuran pilihan: %1',
    'filemanager__count_size_error__' => 'Tidak dapat menghitung ukuran untuk %1: %2',
    'filemanager__create_dir_error__' => "Tidak dapat membuat direktori %1: %2",
    'filemanager__dir_not_exists' => "Direktori %1 tidak ada.",
    'filemanager__dirname' => "Nama direktori",
    'filemanager__filename' => "Nama file",
    'filemanager__is_no_such' => "Tidak ada file atau direktori dengan nama %1",
    'filemanager__empty_selection' => "Tidak ada file yang dipilih.",
    'filemanager__move_error__' => "Tidak dapat memindahkan %1 ke %2: %3",
    'filemanager__not_allowed' => "Anda tidak diizinkan untuk mengubah izin file ini.",
    'filemanager__remove' => "Hapus file dari %1",
    'filemanager__remove_error__' => "Tidak dapat menghapus file %1: %2",
    'filemanager__set_win_permissions_dir' => "Atur izin untuk folder %1",
    'filemanager__set_win_permissions_file' => "Atur izin untuk file %1",
    'filemanager__touch_confirm' => "Apakah Anda akan mengubah stempel waktu dari file terpilih?",
    'filemanager__upload_error__' => "Tidak dapat mengunggah %1 ke %2: %3",
    'filemanager__upload_file' => "Unggah file",
    'filemanager__upload_file_src' => "Jalur ke file",
    'filemanager__max_image_size_exceeded' => 'Tidak dapat menampilkan gambar. Ukuran gambar tidak boleh lebih besar dari %2 byte',

    '__fastcgi_unix_support' => 'Dukungan FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Catatan DNS dari subdomain ini disimpan di zona induk DNS. Anda dapat mengubah zona induk %1 atau membuat zona terpisah untuk subdomain itu.',
    'dns__subdomain_dns_zone_parent_link' => 'di sini',
    'dns__no_dns_zone' => 'Tidak ada zona DNS yang diterapkan dengan domain. Untuk mengelola zona DNS dari domain Anda, Anda harus menekan tombol \'Pulihkan Default\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Tidak dapat mengganti zona subdomain karena ada catatan CNAME untuk subdomain ini di zona domain induknya.',

    '__hosting_write_modify' => 'Izin untuk menulis/mengubah tambahan',

    'aspdotnet__group_framework_version' => "Versi Kerangka Kerja",

    'bt_restore_default' => "Atur ke Default",
    'b_autoinstaller' => 'Perbarui Plesk atau komponennya.',
    'b_autoinstaller_configure' => 'Perbarui pengaturan.',
    'b_autoinstaller_install' => 'Pasang komponen pilihan.',

    '__iis_app_pool__use_dedicated' => 'Kumpulan aplikasi IIS khusus',
    '__iis_app_pool__use_dedicated_addons' => 'Kumpulan aplikasi IIS khusus untuk masing-masing website',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Aktifkan aplikasi 32-bit',
    '__iis_app_pool__load_user_profile' => 'Muat profil pengguna',
    'bt_iis_app_pool' => "Kumpulan Aplikasi IIS",

    'performance__cpu_usage' => 'Penggunaan CPU maksimum (%)',
    'performance__cpu_usage_action' => 'Batasi tindakan',
    'performance__cpu_usage_interval' => 'Batasi interval (menit)',
    'performance__cpu_usage_action_not_supported' => 'Tindakan yang dipilih tidak didukung oleh server web.',

    'performance__idle_timeout_action_not_supported' => 'Tindakan timeout diam tidak didukung oleh server web.',
    'performance__max_worker_processes' => 'Jumlah maksimum proses pekerja',
    'performance__idle_timeout' => 'Timeout diam (menit)',
    'performance__idle_timeout_action' => 'Tindakan timeout diam',
    'performance__recycling_by_time' => 'Daur ulang pada interval waktu reguler (menit)',
    'performance__recycling_by_requests' => 'Daur ulang ketika jumlah maksimum permintaan tercapai',
    'performance__recycling_by_virtual_memory' => 'Daur ulang ketika jumlah maksimum memori virtual telah digunakan',
    'performance__recycling_by_private_memory' => 'Daur ulang ketika jumlah maksimum memori pribadi telah digunakan',
    'performance__managed_pipeline_mode' => 'Kelola mode pipeline',
    'performance__managed_pipeline_mode_not_supported' => 'Mode yang dipilih tidak didukung oleh server web.',

    'iis_app_pool' => 'Pengelolaan kumpulan aplikasi IIS.',
    'b_iis_app_pool' => 'Kelola kumpulan aplikasi IIS.',
    'iis_app_pool_cl_dom' => 'Pengelolaan kumpulan aplikasi IIS.',

    'bt_protect' => 'Lindungi',
    'bt_unprotect' => 'Hapus Perlindungan',
    'bt_show_additional_users' => 'Perlihatkan lebih banyak pengguna',
    'bt_hide_additional_users' => 'Tampilkan lebih sedikit pengguna',
    'error_doc__code_400' => 'Permintaan Salah',
    'error_doc__code_401' => 'Tidak sah',
    'error_doc__code_401.1' => 'Tidak sah - Log masuk gagal',
    'error_doc__code_401.2' => 'Tidak sah - Log masuk gagal akibat konfigurasi server',
    'error_doc__code_401.3' => 'Tidak sah - Tidak sah akibat ACL pada sumber daya',
    'error_doc__code_401.4' => 'Tidak sah - Otorisasi gagal karena filter',
    'error_doc__code_401.5' => 'Tidak sah - Otorisasi gagal karena aplikasi ISAPI/CGI',
    'error_doc__code_401.7' => 'Tidak sah - Ditolak akibat kebijakan otorisasi URL',
    'error_doc__code_403' => 'Terlarang',
    'error_doc__code_403.1' => 'Terlarang - Eksekusi akses ditolak',
    'error_doc__code_403.2' => 'Terlarang - Akses baca ditolak',
    'error_doc__code_403.3' => 'Terlarang - Akses tulis ditolak',
    'error_doc__code_403.4' => 'Terlarang - Dibutuhkan SSL',
    'error_doc__code_403.5' => 'Terlarang - Dibutuhkan SSL 128',
    'error_doc__code_403.6' => 'Terlarang - Alamat IP ditolak',
    'error_doc__code_403.7' => 'Terlarang - Dibutuhkan Sertifikat Klien',
    'error_doc__code_403.8' => 'Terlarang - Akses situs ditolak',
    'error_doc__code_403.9' => 'Terlarang - Terlalu banyak pengguna',
    'error_doc__code_403.10' => 'Terlarang - Konfigurasi tidak valid',
    'error_doc__code_403.11' => 'Terlarang - Kata sandi berubah',
    'error_doc__code_403.12' => 'Terlarang - Akses mapper ditolak',
    'error_doc__code_403.13' => 'Terlarang - Sertifikat klien dicabut',
    'error_doc__code_403.14' => 'Terlarang - Membuat daftar direktori ditolak',
    'error_doc__code_403.15' => 'Terlarang - Lisensi akses klien melebihi batas',
    'error_doc__code_403.16' => 'Terlarang - Sertifikat klien tidak terpercaya atau cacat',
    'error_doc__code_403.17' => 'Terlarang - Sertifikat klien telah kedaluwarsa atau belum valid',
    'error_doc__code_403.18' => 'Terlarang - Tidak dapat menjalankan permintaan dari kumpulan aplikasi ini',
    'error_doc__code_403.19' => 'Terlarang - Akses CGI ditolak',
    'error_doc__code_403.20' => 'Terlarang - Paspor masuk ditolak',
    'error_doc__code_404' => 'Tidak ditemukan',
    'error_doc__code_404.2' => 'Tidak ditemukan - Ditolak karena kebijakan lockdown',
    'error_doc__code_404.3' => 'Tidak ditemukan - Ditolak karena kebijakan MIMEMAP',
    'error_doc__code_405' => 'Metode tidak diizinkan',
    'error_doc__code_406' => 'Tidak dapat diterima',
    'error_doc__code_407' => 'Dibutuhkan pengesahan proxy',
    'error_doc__code_408' => 'Permintaan melebihi waktu',
    'error_doc__code_412' => 'Prakondisi gagal',
    'error_doc__code_414' => 'URI yang diminta terlalu panjang',
    'error_doc__code_415' => 'Tipe media tidak didukung',
    'error_doc__code_431' => 'Kolom header permintaan terlalu besar',
    'error_doc__code_500' => 'Galat server internal',
    'error_doc__code_500.12' => 'Galat server internal - Aplikasi dimulai ulang',
    'error_doc__code_500.13' => 'Galat server internal - Server sibuk',
    'error_doc__code_500.15' => 'Galat server internal - Permintaan langsung ke GLOBAL.ASA dilarang',
    'error_doc__code_500.16' => 'Galat server internal - Galat akses UNC',
    'error_doc__code_500.17' => 'Galat server internal - Simpanan otorisasi URL tidak ditemukan',
    'error_doc__code_500.18' => 'Galat server internal - Simpanan otorisasi URL tidak dapat dibuka',
    'error_doc__code_500.19' => 'Galat server internal - File metadata rusak',
    'error_doc__code_500.100' => 'Galat server internal - Galat ASP',
    'error_doc__code_501' => 'Tidak diterapkan',
    'error_doc__code_502' => 'Gerbang gagal',
    'error_doc__code_503' => 'Layanan untuk sementara tidak tersedia',

    'mimetype_edit__already_exists' => 'Tipe MIME telah ditentukan untuk ekstensi ini.',
    'mimetype_edit__not_exists' => 'Tipe MIME tidak ada.',

    'php__group_php_version' => "Versi PHP",

    'virtualdir__path' => 'Jalur',
    'virtualdir__read' => 'Baca izin',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Izin menulis',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Akses sumber skrip',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Meramban direktori',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Eksekusi izin',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Catat kunjungan',
    'virtualdir__app_create' => 'Buat Aplikasi',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Menghidupkan autentikasi anonim.',
    'virtualdir__auth_windows' => 'Menghidupkan autentikasi Windows.',
    'virtualdir__auth_not_enabled' => 'Autentikasi anonim atau Windows harus dihidupkan.',
    'virtualdir__require_ssl' => 'Minta SSL/TLS',
    'virtualdir__enable_default_doc' => 'Gunakan dokumen default',
    'virtualdir__default_doc' => 'Urutan pencarian dokumen default',
    'virtualdir__enable_parent_paths' => 'Izinkan menggunakan jalur induk',
    'virtualdir__execute_in_mta' => 'Izinkan mengeksekusi aplikasi dalam mode MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Membuat direktori virtual di %1',
    'virtualdir_edit__title' => 'Properti direktori virtual %1',
    'virtualdir_edit__legend' => 'Direktori virtual',
    'virtualdir_edit__application_legend' => 'Pengaturan aplikasi',
    'virtualdir_edit__security_legend' => 'Keamanan direktori',
    'virtualdir_edit__documents_legend' => 'Dokumen',
    'virtualdir_edit__list_legend' => 'Direktori virtual yang Bersarang',
    'virtualdir_error__path_not_in__' => 'Jalur yang ditentukan tidak valid',
    'virtualdir_root' => 'Direktori virtual',
    'virtualdir_root__title' => 'Direktori virtual',
    'virtualdir_root__list_legend' => 'Direktori virtual',
    'virtualdir_se__none' => 'Tidak ada',
    'virtualdir_se__script' => 'Hanya skrip',
    'virtualdir_se__script_execute' => 'Skrip dan File yang Dapat Dieksekusi',
    'virtualdirs__title' => 'Direktori virtual',
    'virtualdirs__path_not_exists' => 'Jalur invalid.',
    'virtualdirs__select_for_remove' => "Pilih direktori virtual yang akan dihapus.",
    'virtualdirs_remove__title' => 'Hapus direktori virtual',

    'asp_max_buffer_text' => 'Ukuran maksimum buffer ASP (KB)',
    'asp_max_body_text' => 'Ukuran maksimum badan entitas permintaan ASP (KB)',
    'asp_buffers_legend' => 'Pengaturan ASP',
    'asp_client_debug_text' => 'Aktifkan debugging skrip ASP sisi klien',
    'asp_server_debug_text' => 'Aktifkan debugging skrip ASP sisi server',

    'permissions__group_or_user_name' => 'Nama kelompok atau pengguna',
    'permissions__FullControl' => 'Kontrol Penuh',
    'permissions__Modify' => 'Modifikasi',
    'permissions__ReadAndExecute' => 'Baca dan Jalankan',
    'permissions__ListFolderContents' => 'Daftar Isi Folder',
    'permissions__Read' => 'Baca',
    'permissions__Write' => 'Tulis',
    'permissions__ReadControl' => 'Kontrol Baca',
    'permissions__WriteControl' => 'Kontrol Tulis',
    'permissions__ExecuteControl' => 'Jalankan Kontrol',
    'permissions__TraverseFolderOrExecuteFile' => 'Lintasi Folder / Jalankan File',
    'permissions__ListFolderOrRead' => 'Daftar Folder / Baca Data',
    'permissions__CreateFilesOrWrite' => 'Membuat File / Menulis Data',
    'permissions__CreateFoldersOrAppend' => 'Membuat Folder / Menambah Data',
    'permissions__DeleteSubfoldersandFiles' => 'Hapus Subfolder dan File',
    'permissions__Delete' => 'Hapus',
    'permissions__ChangePermissions' => 'Ubah izin',
    'permissions__TakeOwnership' => 'Ambil Kepemilikan',
    'permissions__inherited_from' => 'Diwarisi dari',
    'permissions__not_inherited' => '<not inherited>',
    'permissions__apply_to' => 'Terapkan pada',
    'permissions__apply_onto' => 'Terapkan pada:',
    'permissions__apply_onto1' => 'Hanya folder ini',
    'permissions__apply_onto2' => 'Hanya subfolder',
    'permissions__apply_onto3' => 'Folder dan subfolder ini',
    'permissions__apply_onto4' => 'Hanya file',
    'permissions__apply_onto5' => 'Folder dan file ini',
    'permissions__apply_onto6' => 'Hanya folder dan file',
    'permissions__apply_onto7' => 'Folder, subfolder, dan file ini',

    'filemanager__not_allowed_dir' => "Anda tidak diizinkan untuk mengubah izin folder ini.",

    'filemanager__allow' => "Izinkan",
    'filemanager__deny' => "Tolak",
    'filemanager__user_domusr' => 'Administrator situs web',
    'filemanager__user_webusr' => 'Pengguna web',
    'filemanager__user_admins' => 'Administrator',
    'filemanager__user_system' => 'SISTEM',
    'filemanager__user_aspnet' => 'Pengguna ASP.NET',
    'filemanager__user_poolusr' => 'Pengguna kumpulan aplikasi',
    'filemanager__user_sysaccount' => 'Pengguna sistem tambahan',

    'bt_permissions_advanced' => 'Lanjutan',
    'b_permissions_advanced' => 'Klik untuk melihat dan mengatur izin khusus.',

    'hotlink-protection_invalid_friend_domain' => 'Nama tidak valid untuk domain ramah.',
    'hotlink-protection_duplicate_friend_domain' => 'Nama duplikat untuk domain ramah.',
    'hotlink-protection_invalid_extensions' => 'Ekstensi file berisi karakter yang salah.',

    'i_domain_alias_status_on' => 'Alias domain diaktifkan.',
    'i_domain_alias_status_off' => 'Alias domain dinonaktifkan.',
    'i_domain_alias_status_with_parent' => 'Alias domain dinonaktifkan karena domain telah dimatikan.',
    'i_domain_alias_turn_off' => 'Klik untuk menonaktifkan.',
    'i_domain_alias_turn_on' => 'Klik untuk mengaktifkan.',

    'domain_alias__control_title' => 'Alias Domain %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nama layanan',
    'domain_alias__control_details_title' => 'Perincian',

    'domain_alias__invalid_values' => 'Nama domain yang anda tentukan tidak valid. Nama domain dapat mengandung huruf, angka dan tanda penghubung. Masing-masing bagian dari nama domain di antara titik tidak boleh lebih dari 63 simbol.',
    'domain_alias__domain_already_exists' => "Nama alias domain %1 salah. Domain %1 sudah ada.",
    'domain_alias__www_prefix_domain_already_exists' => "Nama alias domain www.%1 salah. Alias ini sudah dibuat untuk domain %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nama alias domain webmail.%1 salah. Alias ini sudah dibuat untuk domain %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nama alias domain lists.%1 salah. Alias ini sudah dibuat untuk domain %1.',
    'domain_alias__dns_record_already_exists' => 'Tidak dapat mengatur alias domain %1 karena catatan DNS menunjuk ke host %1 sudah ada.',
    'domain_alias__domain_alias_already_exists' => "Alias domain dengan nama tersebut sudah ada.",
    'domain_aliases__mail_server_not_support_aliases' => 'Server surat tidak mendukung fitur alias domain. Alias domain tidak dapat berfungsi dengan benar.',
    'domain_alias__restrict_domain_creation' => 'Nama alias domain yang ditentukan dilarang oleh kebijakan seluruh server. Jika nama alias domain ini milik Anda, harap hubungi penyedia hosting Anda.',
    'domain_alias__restrict_creation_with_www' => 'Harap masukkan nama domain tanpa prefiks \'www\'. Prefiks www untuk domain akan ditambahkan secara otomatis pada konfigurasi web server.',
    'domain_unable_to_set_name' => 'Nama %1 salah.',

    'domain_alias__domain_service_dns_disabled' => 'Domain ini dilayani oleh server DNS yang lain.',
    'domain_alias__domain_service_dns_enabled_master' => 'Server DNS ini bertindak sebagai server nama utama untuk zona DNS ini.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Server DNS ini bertindak sebagai server nama slave untuk zona DNS ini.',
    'domain_alias__domain_service_mail_enabled' => 'Layanan surat dihidupkan untuk domain ini.',
    'domain_alias__domain_service_mail_disabled' => 'Layanan surat dimatikan untuk domain ini.',
    'domain_alias__domain_service_mail_mx' => '%1 digunakan sebagai server surat.',

    'domain_alias__service_seoRedirect_hint' => 'Ketika pengunjung membuka URL alias, mereka akan diarahkan ke URL domain utama. Plesk menggunakan pengalihan HTTP 301 yang ramah mesin pencari, yang berarti peringkat mesin pencari tidak akan dipisah di antara URL.',

    'bt_task_run_now' => 'Jalankan Sekarang',
    'ftp__read_perm' => "Baca izin",
    'ftp__write_perm' => "Izin menulis",

    'filemanager__upload_backup_file_hint' => 'Di sini Anda dapat mengunggah berkas cadangan ke penyimpanan Plesk. Ukuran berkas maksimum dibatasi hingga dua gigabyte.',

    '__default_for_mssql' => 'default untuk MS SQL',

    '__login_does_not_pass_validation' => "Nama pengguna invalid. Pastikan nama pengguna memenuhi persyaratan berikut: %1",
    '__login_allowed_symbols' => 'Hanya karakter alfanumerik termasuk titik, tanda penghubung, dan garis bawah yang diperbolehkan. Karakter pertama harus alfanumerik.',

    'restart__nginx' => 'Server Proxy Balik (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Saya ingin menerima informasi produk umum dan pemberitahuan dari Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Saya ingin menerima informasi terkait keamanan dan notifikasi teknis lainnya dari Plesk.",

    '__login_status_inactive' => 'Akun Anda sudah tidak aktif. Silahkan menghubungi administrator Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Kembali ke halaman Alat & Pengaturan. Migrasi akan berlanjut di latar belakang.',

    'ui__admin-alias-info__description' => "Sunting informasi kontak akun administrator tambahan.",
    'ui__admin-alias-info__short-title' => "Informasi kontak",
    'ui__admin-alias-info__title' => "Informasi Akun Administrator Tambahan",
    'ui__admin-alias-password__description' => "Ubah kata sandi administrator tambahan.",

    'ui__admin-alias-password__short-title' => "Ubah kata sandi",
    'ui__admin-alias-password__title' => "Kata sandi administrator tambahan",
    'ui__admin-alias__description' => "Lihat dan ubah informasi akun administrator tambahan.",

    'chk_js__warning_about_ftp_login_syntax' => "Anda dapat menggunakan simbol alfanumerik, tanda penghubung, dan garis bawah di nama pengguna.",
    'chk_js__warning_about_passwd_syntax' => "Jangan menggunakan tanda kutip, spasi, dan karakter alfabet nasional dalam kata sandi.\nPanjang kata sandi harus di antara %1 hingga %2 karakter, dan tidak boleh berisi nama pengguna.",
    'chk_js__warning_about_plesk_login_syntax' => "Anda dapat menggunakan simbol huruf kecil dan angka, titik, garis penghubung, dan garis bawah di nama pengguna.",
    'chk_js__warning_about_admin_passwd_syntax' => "Jangan menggunakan tanda kutip, spasi, titik koma, dan karakter alfabet nasional dalam kata sandi.\nPanjang kata sandi harus antara %1 hingga %2 karakter, dan tidak boleh berisi nama pengguna.",

    'cmd_server__admin_alias_not_found' => "Tidak dapat menemukan akun administrator tambahan.",

    'panel_branding__skins_already_exists' => "Perhatikan: Tema '%1' sudah ada. Tema ini akan diganti dengan tema yang Anda pasang saat ini.",
    'panel_branding__skins_file_exists' => "Tidak dapat membuat direktori untuk tema '%1': Berkas dengan nama tersebut sudah ada.",

    'actionlog__login_failed' => 'gagal log masuk',
    'actionlog__event_cp_user_login_failed' => 'Pengguna Plesk gagal log masuk',
    'actionlog__api_login_failed' => 'gagal log masuk melalui API',
    'actionlog__event_cp_user_api_login_failed' => 'Pengguna Plesk gagal log masuk melalui API',
    'actionlog__pw_reset' => 'meminta pengaturan ulang kata sandi',
    'actionlog__pw_admin_force_reset' => 'meminta pengaturan ulang kata sandi admin paksa',

    'ch_pass_admin__email_subject' => "Pengingat kata sandi Plesk",
    'ch_pass_admin__email_body' => "Halo, %1.\n\nKata sandi administrator tidak dapat dikirim melalui email demi alasan keamanan.\n\nUntuk masuk sebagai 'admin', gunakan perintah 'plesk login'.\n\nUntuk mengatur kata sandi 'admin' baru, gunakan perintah 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Tidak dapat mengirim email: %1',

    'ch_pass_by_secret__email_subject' => "Pengingat kata sandi Plesk",
    'ch_pass_by_secret__email_body' => "Halo %2,\n\nUntuk mengatur kata sandi baru, ikuti tautan berikut: %1\n\nLogin Anda: %3",
    'ch_pass_by_secret__message_send_error' => 'Tidak dapat mengirim kode rahasia: %1',
    'ch_pass_by_secret__title' => 'Ubah Kata Sandi Anda',
    'ch_pass_by_secret__secret' => 'Kode rahasia',

    'custom_button__noframe' => "Jangan gunakan bingkai",

    'custom_button__internal_hint' => 'Tentukan apakah Anda akan membuka URL di halaman Plesk atau di jendela peramban baru.',
    'custom_button__noframe_hint' => 'Jika Anda menambahkan tombol suai yang mengarahkan ke ekstensi Plesk atau aplikasi di Panel Pelanggan, Anda dapat menentukan tampilan ekstensi/aplikasi: dalam bingkai atau sebagai bagian dari GUI Plesk.',


    'actionlog__patch' => 'Pembaruan',
    'actionlog__patch_available' => 'tersedia',
    'actionlog__event_patch_available' => 'Pembaruan tersedia',
    'actionlog__patch_installed' => 'terpasang',
    'actionlog__event_patch_installed' => 'Pembaruan telah dipasang',

    'actionlog__extension' => 'Ekstensi',
    'actionlog__extension_status' => 'Status ekstensi',
    'actionlog__cloning' => 'Pengklonaan server',
    'actionlog__cloning_complete' => 'selesai',
    'actionlog__event_cloning_complete' => 'Pengklonaan server selesai',

    'actionlog__ssl_web_binding' => 'Sertifikat SSL/TLS di domain',
    'actionlog__ssl_web_binding_update' => 'ditetapkan/tidak ditetapkan.',
    'actionlog__event_ssl_web_binding_update' => 'Sertifikat SSL/TLS untuk domain yang ditetapkan /tidak ditetapkan',

    'actionlog__ssl_web_mail_binding' => 'Sertifikat SSL/TLS pada webmail',
    'actionlog__ssl_web_mail_binding_update' => 'ditetapkan/tidak ditetapkan.',
    'actionlog__event_ssl_web_mail_binding_update' => 'Sertifikat SSL/TLS di webmail yang ditetapkan/tidak ditetapkan',

    'actionlog__ssl_mail_binding' => 'Sertifikat SSL/TLS di server email',
    'actionlog__ssl_mail_binding_update' => 'ditetapkan/tidak ditetapkan.',
    'actionlog__event_ssl_mail_binding_update' => 'Sertifikat SSL/TLS di server email yang ditetapkan/tidak ditetapkan',

    'actionlog__ssl_panel_binding' => 'Sertifikat SSL/TLS di Plesk',
    'actionlog__ssl_panel_binding_update' => 'ditetapkan/tidak ditetapkan.',
    'actionlog__event_ssl_panel_binding_update' => 'Sertifikat SSL/TLS pada Plesk yang ditetapkan/tidak ditetapkan',

    'actionlog__hostname' => 'Nama host server',
    'actionlog__hostname_changed' => 'diubah',

    'actionlog__smb_user' => 'Pengguna tambahan',
    'actionlog__smb_user_create' => 'Pengguna tambahan dibuat',
    'actionlog__smb_user_delete' => 'Pengguna tambahan dihapus',
    'actionlog__smb_user_update' => 'Pengguna tambahan diperbarui',

    'actionlog__event_mail_management_status_update' => 'Pembaruan status pengelolaan surat',
    'actionlog__mail_management' => 'Status pengelolaan surat',
    'actionlog__mail_management_status_update' => 'diperbarui',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Total dari domain',

    'passwordSecurityLevelCheckFailed' => 'Kata sandi Anda tidak cukup rumit. Sesuai dengan kebijakan server, kekuatan minimal kata sandi adalah %1. Untuk memperkuat kata sandi, gunakan angka, huruf besar dan huruf kecil, serta karakter khusus seperti !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Sangat lemah',
    'passwordSecurityLevelCheckFailedWeak' => 'Lemah',
    'passwordSecurityLevelCheckFailedMediocre' => 'Sedang',
    'passwordSecurityLevelCheckFailedStrong' => 'Kuat',
    'passwordSecurityLevelCheckFailedStronger' => 'Sangat kuat',

    'ui__client/domain/dns/sync__description' => 'Terapkan perubahan dari template DNS seluruh server ke zona.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Tidak dapat menerapkan perubahan template DNS ke zona karena zona dilayani oleh server DNS lain.',
    'ui__client/domain/dns/sync__short-title' => 'Terapkan Perubahan Template DNS',
    'ui__client/domain/dns/sync__done' => 'Perubahan dari template DNS berhasil diterapkan di zona.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Terapkan perubahan dari template DNS seluruh server ke zona.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Tidak dapat menerapkan perubahan template DNS ke zona karena zona dilayani oleh server DNS lain.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Terapkan Perubahan Template DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Perubahan dari template DNS berhasil diterapkan di zona.',
    'dns__dns_default_ipv4_modified' => 'Catatan dengan alamat IP ini akan dianggap sebagai modifikasi-pengguna dan tidak akan disinkronkan dengan template DNS seluruh server.',
    'dns__dns_default_ipv6_modified' => 'Catatan dengan alamat IP ini akan dianggap sebagai modifikasi-pengguna dan tidak akan disinkronkan dengan template DNS seluruh server.',

    'dns__view_dns_record_master_title' => 'Melihat Catatan Sumber Daya',
    'dns__view_dns_record_off_title' => 'Melihat Catatan Name Server',
    'dns__view_dns_record_slave_title' => 'Melihat Catatan Server Utama DNS',

    'dns_unable_to_resolve_hostname' => "Hindi maisaayos ang hostname \"%1\": %2 \nTiyakin na ang DNS resolver ng operating system ay maayos na naka-set up at gumagana.",

    'no_database_server_available' => 'Tidak ada server basis data yang tersedia untuk langganan ini.',

    'database_used_by_application_can_not_be_moved' => 'Tidak dapat memindahkan basis data: Ada aplikasi situs web yang menggunakan basis data ini.',
    'database_user_update_orphaned_is_restricted' => 'Dilarang membuat pembaruan akun pengguna basis data orphan. Anda hanya bisa menghapus atau memperbaikinya.',

    'database_unable_to_get_max_filesize_default_message' => 'Tidak dapat menentukan ukuran file maksimum basis data: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Tidak dapat menetapkan ukuran file maksimum basis data: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Tidak dapat menentukan ukuran file log maksimum basis data: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Tidak dapat menetapkan ukuran file log maksimum basis data: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Tidak dapat menentukan batas yang berlaku pada ukuran berkas basis data Microsoft SQL \'%1\'. Tidak mungkin menentukan batas baru.',
    'database_unable_to_set_max_filesize' => 'Tidak dapat mengatur batas untuk ukuran berkas basis data Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Tidak dapat menentukan batas yang berlaku pada ukuran berkas log basis data Microsoft SQL \'%1\'. Tidak mungkin menentukan batas baru.',
    'database_unable_to_set_max_log_filesize' => 'Tidak dapat mengatur batas untuk ukuran berkas log basis data Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Tidak dapat membuat basis data Microsoft SQL \'%1\': Ukuran file-nya lebih besar dari ukuran maksimum yang diizinkan.',
    'database_unable_to_move_because_max_filesize' => 'Tidak dapat memindahkan basis data Microsoft SQL \'%1\': Ukuran file-nya lebih besar dari ukuran maksimum yang diizinkan: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Tidak dapat membuat basis data Microsoft SQL \'%1\': Ukuran file log-nya lebih besar dari ukuran maksimum yang diizinkan.',
    'database_unable_to_move_because_max_log_filesize' => 'Tidak dapat memindahkan basis data Microsoft SQL \'%1\': Ukuran file log-nya lebih besar dari ukuran maksimum yang diizinkan: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Tidak dapat memulihkan basis data Microsoft SQL \'%1\': Ukuran file-nya lebih besar dari ukuran maksimum yang diizinkan.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Server MS SQL yang identik telah terdaftar di Plesk. Harap menentukan server MS SQL lain sebagai sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Sandbox server MS SQL identik telah terdaftar di Plesk. Harap menentukan server MS SQL lain sebagai sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Tidak dapat tersambung ke server melalui \'%1\':%2',

    'bu_conflict_resolver_feature_not_available' => 'Fitur %1 tidak didukung oleh simpul layanan berikut: %2. Fitur ini akan dinonaktifkan untuk semua objek yang dibuat dalam simpul ini.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Fitur %1 tidak didukung oleh server ini. Fitur ini akan tidak tersedia untuk semua objek yang dipulihkan.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Komponen %1 tidak terpasang. Itu tidak akan tersedia untuk situs web berikut: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Komponen %1 tidak terpasang. Akan digantikan dengan %2 untuk situs web berikut: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Versi Plesk terkini tidak mendukung nama pengguna dengan karakter titik (.). Pelanggan dan penyalur dengan nama pengguna demikian tidak akan dipulihkan.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Tidak dapat menemukan file cadangan dengan data untuk %1 %2. Data untuk %1 %2 tidak akan dipulihkan.',

    'bu_conflict_resolver_zone_master_removed' => "Tidak dapat memulihkan catatan DNS utama: Catatan dalam titik zona slave pada alamat IP yang ada %1. Catatan DNS utama akan dihapus dari zona slave.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Dukungan untuk catatan HTTPS DNS dinonaktifkan. Catatan HTTPS tidak akan disimpan untuk domain berikut: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 tidak didukung.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 tidak didukung. Itu tidak akan tersedia untuk situs web berikut: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Komponen %1 tidak terpasang.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Itu tidak akan tersedia untuk simpul layanan berikut: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Itu tidak akan tersedia untuk objek berikut: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Server basis data berikut tidak tersedia di server ini: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'Pengelolaan smarthost tidak didukung. Pengaturan smarthost tidak akan dipulihkan.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Berkas cadangan basis data MS SQL disimpan dalam format asli MS SQL, yang dapat dipulihkan hanya ke server MS SQL lokal atau server MS SQL jauh dengan pengaturan pencadangan yang terkonfigurasi sepenuhnya. Beberapa basis data Anda tidak dipulihkan karena tidak ada server MS SQL yang sesuai yang terdaftar di Plesk. Domain berikut terpengaruh: {{objects}}. Harap hubungi penyedia hosting Anda.',

    'bu_conflict_resolver_not_available_webmail' => 'Layanan webmail %1 tidak tersedia. Akan diganti %2 untuk objek berikut: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Layanan webmail %1 tidak tersedia. Akan diganti dengan %2 untuk paket layanan berikut: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Basis data tipe '%1' tidak mendukung nama pengguna yang serupa dengan nama basis data. Pengguna '%2' akan diganti namanya menjadi '%3' untuk basis data '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Batas penggunaan ruang disk tidak diatur dalam konfigurasi server tujuan. Nilai pengaturan ini akan diubah menjadi "Tidak Terbatas ".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Batas jumlah koneksi tidak diatur dalam konfigurasi server tujuan. Nilai pengaturan ini akan diubah menjadi "Tidak Terbatas ".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Batas penggunaan lalu-lintas tidak diatur dalam konfigurasi server tujuan. Nilai pengaturan ini akan diubah menjadi "Tidak Terbatas ".',
    'cu__pleskrestore_backup_file_extracted' => 'File cadangan diekstrak ke "%1".',
    '__mod_bw_not_supported' => 'Tidak mendukung mod_bw modul untuk server web Apache akibat konfigurasi sistem file. Batas penggunaan lalu-lintas dan jumlah koneksi maksimum tidak akan berfungsi.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Otorisasi POP3 untuk relai surat tidak didukung, POP3 sebelum otorisasi SMTP akan digunakan. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Paket layanan \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 tidak didukung. Akan diganti dengan %2 untuk paket layanan berikut: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 tidak didukung. Akan digantikan dengan %2 untuk situs web berikut: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Objek berikut tidak ditemukan dalam file cadangan: %1',
    'bu_conflict_resolver_absent_domains' => 'Beberapa objek tidak dapat dipulihkan karena berasal dari domain berikut yang tidak ditemukan di Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Beberapa situs web tidak dapat dipulihkan karena berasal dari domain induk berikut yang tidak ditemukan di Plesk: \n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Tidak dapat memulihkan zona DNS: Layanan DNS dimatikan pada konfigurasi server.',
    'bu_conflict_resolver_mail_not_supported' => 'Tidak dapat memulihkan kotak surat: Layanan surat dimatikan pada konfigurasi server.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Tindakan pembatasan CPU yang ditentukan tidak didukung oleh server web IIS. Nilai akan diset ulang ke %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Sertifikat SSL/TLS server %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Sertifikat SSL/TLS %2 domain %1',
    'bu_conflict_detector_ssl_cert_name' => 'Sertifikat SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Konten objek berikut tidak dapat dipulihkan karena objek tidak ditemukan di Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Konten kotak surat berikut tidak dapat dipulihkan karena kotak surat tidak ditemukan di Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Konten milis berikut tidak dapat dipulihkan karena milis tidak ditemukan di Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Konten basis data berikut tidak dapat dipulihkan karena basis data tidak ditemukan di Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Pemulihan aplikasi "%1" pada "%2" telah gagal karena aplikasi lain sudah terpasang di "%3". Anda dapat menghapus aplikasi yang terpasang dan coba lagi.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Fungsi balasan otomatis surat tidak didukung.',
    'bu_conflict_resolver_not_available_mail_content' => 'Pemulihan isi surat tidak didukung.',
    'bu_conflict_resolver_invalid_mail_name' => 'Kotak surat berikut ini belum disimpan karena subaddressing email diaktifkan dan alamat email tertentu mengandung tanda "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Pengguna berikut ini belum disimpan karena subaddressing email diaktifkan dan alamat email tertentu mengandung tanda "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Lisensi berikut ini kedaluwarsa dan tidak akan disimpan: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Lisensi berikut ini tidak valid atau kedaluwarsa dan tidak akan disimpan: {{objects}}',
    'expiration_unsupported' => "Batas 'expiration' tidak didukung.",

    'component_name__dbconnector' => "Konektor Basis Data",
    'component_name__mysqlserver' => 'Server MariaDB/MySQL',
    'component_name__troubleshooting' => 'Pemecahan Masalah',
    'component_name__savi' => 'Antarmuka Anti Virus Sophos',

    '__subscription_has_no_license_key' => 'Sumber daya langganan disediakan oleh simpul layanan #%1 dan tidak memiliki kunci lisensi yang berhubungan.',
    '__subscription_has_expired_license_key' => 'Sumber daya langganan disediakan oleh simpul layanan #%1 di mana kunci lisensi %2 telah kedaluwarsa.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%>Tidak dapat menyimpan file konfigurasi',
    '__cfgmonConfigurationFileSaveErrorBody' => "Tidak dapat menyimpan beberapa file konfigurasi pada host <%%host%%>: Terdapat galat berikut: \n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Pilihan ini bisa melakukan konfigurasi alamat email tipe VERP untuk daftar surat',
    'mail__enter_right_ip_mask' => "Masukkan masker IP di antara 1 dan 32",
    'mail__enter_right_ip_mask_24' => "Masukkan masker IP di antara 24 dan 32",
    'mail__invalid_dom_name' => "Nama subdomain %1 tidak valid.",
    'mail__invalid_pop_lock_time' => "Waktu kunci POP3 tidak valid.",
    'mail__invalid_rbl_server' => "Nama zona DNS tidak valid.",
    'mail__total_files_size' => "Ukuran total repositori: %1",
    'mail__filename_already_in_repository' => "File dengan nama yang sama sudah ada di repositori",
    'mail__no_white_list_mask_feature_24' => "Gunakan nilai mask 24 atau lebih tinggi.\nServer email Anda tidak mendukung mask pengaturan. Kami hanya dapat mengemulasi mask pengaturan untuk nilai yang tidak kurang dari 24.",
    'mail__unable_add_new_mail_name' => "Tidak dapat menambah akun email: %1",
    'mail_server_is_not_installed' => 'Server email (Postfix atau Qmail) tidak diinstal. Instal server email tersebut untuk melanjutkan pekerjaan.',
    'mail_server_not_available' => 'Tidak ada server dukungan surat yang tersedia di node layanan.',
    '__not_installed' => '(tidak terpasang)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Filter spam pada pesan surel keluar dinonaktifkan.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Simpul layanan tidak mendukung pembatasan jumlah pesan surel keluar dari domain untuk domain %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Simpul layanan tidak mendukung pembatasan jumlah pesan surel keluar dari kotak surat untuk domain %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Tentukan alamat dari setidaknya satu tipe (IPv4 atau IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Mode surat keluar invalid telah ditentukan.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Alamat IPv4 invalid telah ditetapkan.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Alamat IPv6 invalid telah ditetapkan.',
    'mail__outgoing_email_mode_unavailable' => 'Mengubah model email keluar tidak didukung, mungkin karena server email Postfix tidak dipasang di server ini.',

    'mail__autoresponder_attachment_not_supported' => 'Server surat yang sedang digunakan tidak mendukung pengelolaan lampiran perespons otomatis.',

    'mail__smtp_white_list_not_supported' => 'Server mail yang digunakan saat ini tidak mendukung daftar putih alamat IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Masker CIDR tidak didukung oleh server email yang saat ini dipilih. Tentukan alamat IP dalam format \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Pola IP Wildcard tidak didukung oleh server email yang dipilih saat ini. Tentukan alamat IP di format \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Tidak dapat mengganti pengaturan untuk layanan verifikasi DKIM',

    'sfdk_domain__serverwide_disabled' => 'Dimatikan sesuai dengan kebijakan server',
    'feature__domainkeys__serverwide_disabled' => 'Perlindungan spam seluruh server DKIM dimatikan',

    'defaultcomponents__error_set_default' => 'Tidak dapat mengatur %1 sebagai %2 default: %3',
    'defaultcomponents__error_set_default_none' => 'Tidak dapat mengatur tanpa komponen default untuk %1: %2',
    'defaultcomponents__required_package_not_default' => 'Komponen %1 yang dibutuhkan untuk fungsinya bukan default.',

    '__percentage' => '%',
    '__seconds' => 'Detik',
    '__resource_remain' => 'Sisa',

    '__not_registered' => '(tidak terdaftar)',
    '__php_handler_id' => 'Versi PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Penangan PHP "%1" tidak terdaftar. Kemungkinan penangan telah dihapus dari server. Daftarkan penangan dengan properti yang sama dan coba lagi.',
    '__php_handler_not_registered_on_domain' => 'Domain "%1": Penangan PHP "%2" tidak terdaftar. Kemungkinan penangan telah dihapus dari server. Daftarkan penangan dengan properti yang sama dan coba lagi.',
    '__php_fpm_handler' => 'Aplikasi FPM',
    '__php_fpm-dedicated_handler' => 'Kumpulan aplikasi FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Tidak dapat membuat pengguna untuk kotak surat. Pengguna dengan nama pengguna %1 sudah ada dan menggunakan kotak surat yang lain.',
    'mailname_create_assigned_user_role_absent_error' => 'Tidak dapat membuat pengguna untuk kotak surat. Peran default %1 dari pengguna tidak ada.',

    'gphd__mime_types' => 'Tipe MIME',
    'gphd__handlers' => 'Penangan Apache',
    'gphd__ip_restrictions_allow' => 'Izinkan akses ke situs untuk host dan jaringan tertentu (kecuali yang ditolak)',
    'gphd__ip_restrictions_deny' => 'Tolak akses ke situs untuk host dan jaringan tertentu',
    'gphd__directory_index' => 'File indeks',
    'gphd__nginx_transparent_mode' => 'Moda ketika Apache menangani konten statis dan dinamis sekaligus, sedangkan nginx hanya menyampaikan permintaan dan respons HTTP tanpa modifikasi.',
    'gphd__nginx_serve_static' => 'Layanan file statis secara langsung oleh nginx',
    'gphd__nginx_static_extensions' => 'Ekstensi file statis yang harus ditangani oleh nginx',
    'gphd__nginx_serve_php' => 'Proses file PHP menggunakan nginx',
    'gphd__www_root' => 'Direktori Root WWW',

    'eol__none' => 'Jangan diubah',
    'eol__lf' => 'Ubah ke bentuk Unix',
    'eol__cr' => 'Ubah ke bentuk MacOS',
    'eol__crlf' => 'Ubah ke bentuk Windows',

    'ui__dns_bad_zone' => 'Zona "%1" tidak konsisten:',
    'ui__dns_ns_has_no_address_records' => 'Catatan NS "%1" tidak memiliki catatan alamat (A atau AAAA).',
    '__dns_bad_zone' => 'Zona "%1" tidak konsisten:',
    '__dns_ns_has_no_address_records' => 'Catatan NS "%1" tidak memiliki catatan alamat (A atau AAAA).',
    '__dns_ptr_is_wildcard' => 'Catatan PTR "%1" invalid: Catatan mengarahkan ke domain wildcard.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Mengizinkan akses jauh untuk pengguna basis data \'%3\' dari pelanggan \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Tidak dapat mengizinkan koneksi jauh untuk pengguna basis data \'%1\': Tidak dapat menentukan nomor port TCP yang digunakan oleh server Microsoft SQL \'%2\'. Alasan yang mungkin adalah sebagai berikut: protokol TCP/IP tidak diaktifkan dalam konfigurasi jaringan server atau server dikonfigurasi untuk menggunakan port TCP dinamis. Konfigurasikan server untuk memantau port TCP tetap yang ditentukan dan coba lagi mengizinkan koneksi jauh.',

    'command__convertResellerHasCustomer' => 'Akun penyalur \'%1\' memiliki satu atau lebih akun pelanggan. Untuk mengonversi akun penyalur ini menjadi akun pelanggan, transfer akun pelanggan terlebih dulu ke pemilik baru atau konversi mereka menjadi akun penyalur.',
    'command__convertResellerNotReseller' => 'Hanya akun penyalur yang dapat dikonversi menjadi akun pelanggan. \'%1\' bukan penyalur.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Cloud tidak menyinkronkan langganan dengan paket layanan. Pengaturan langganan berikut berkonflik dengan paket layanan: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Akun \'%1\' adalah akun penyalur. Akun penyalur tidak dapat dipindahkan ke pemilik baru karena akun tersebut dimiliki oleh administrator server.',
    'moveCustomer__wrong_owner_type' => "Akun pelanggan '%1' hanya dapat dipindahkan ke penyalur atau admin, tidak ke pelanggan yang lain.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Akun pelanggan \'%1\' telah dimiliki oleh pemilik yang dipilih.',
    'upgradeClient__user_is_admin' => 'Akun \'%1\' tidak dapat diubah menjadi akun penyalur karena ini adalah akun administrator.',

    'mail__error_setting_max_connections_courier' => 'Tidak dapat mengatur jumlah koneksi maksimum (IMAP, POP3, IMAP melalui SSL/TLS, atau POP3 melalui SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Tidak dapat mengatur jumlah koneksi maksimum (IMAP, POP3, IMAP melalui SSL/TLS, atau POP3 melalui SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Tidak dapat mengatur jumlah koneksi maksimum (IMAP, POP3, IMAP melalui SSL/TLS, atau POP3 melalui SSL/TLS) per alamat IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Tidak dapat mengatur jumlah koneksi maksimum (IMAP, POP3, IMAP melalui SSL/TLS, atau POP3 melalui SSL/TLS) per alamat IP untuk pengguna surat tertentu: %1',
    'outgoing_messages_limit_value_invalid' => 'Nilai harus berada dalam rentang %%MIN%%..%%MAX%%. Hanya administrator Plesk yang boleh mengubah pengaturan ini.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Domain berikut menggunakan alamat surel eksternal untuk penerusan surat yang dikirimkan ke alamat yang tidak ada. Pesan yang terkirim ke alamat tersebut tidak akan dihitung di Kontrol Surat Keluar:\n%1",
    'outgoing_messages_white_list_not_empty' => 'Batas surat keluar tidak akan berlaku untuk pengirim dengan alamat IP yang ada dalam daftar putih server. Misalnya, jika localhost (127.0.0.0 / 8, ::1 / 128) ada dalam daftar putih, semua surat dari server lokal akan berhasil terkirim tanpa mengindahkan pembatasan. Pengirim surat dapat menggunakan alamat IP lokal (skrip situs web dan suai yang di-host di server lokal) atau eksternal (pelanggan yang mengirim surat dari klien surat yang terpasang di komputer atau perangkat bergerak mereka). Untuk membuat batasan berlaku untuk semua pengirim surat (lokal maupun eksternal), hapus semua alamat IP dan jaringan dari daftar putih. Perhatikan bahwa menghapus localhost (127.0.0.0 / 8, ::1 / 128) dari daftar putih dapat mengganggu operasi situs web dan skrip yang mengirimkan surat dari server ini. Untuk mendapatkan perincian mengenai pembatasan surat keluar, lihat Panduan Administrator, Proteksi dari Spam Outbound.',
    'outgoing_messages_relay_open' => 'Relai surat terbuka: Batas surat keluar tidak akan berfungsi.',

    'notification_aps_app_updates_available' => 'Pembaruan tersedia untuk aplikasi berikut:',
    'notification_aps_app_updates_installed' => 'Pembaruan dipasang secara otmatis untuk aplikasi berikut:',
    'notification_aps_app_updates_requirements' => 'Pembaruan tersedia untuk aplikasi berikut tetapi tidak dapat dipasang karena pengaturan hosting dari situs web yang berhubungan tidak memenuhi persyaratan pemasangan:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" di %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" di %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" di %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" di %%parentName%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Versi Anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" di %%parentName%% (%%url%%). Versi Anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" di %%parentName%% (%%url%%). Versi Anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versi baru: %%to%%. Versi sebelumnya: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versi baru: %%to%%. Versi sebelumnya: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Versi baru: %%to%%. Versi sebelumnya: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versi yang dipasang: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versi Anda: %%from%%. Versi yang tersedia: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'aplikasi eksternal',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domain',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Alamat Surel',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Langganan',
    'notification_outgoing_mail_exceeded_limits_limit_value' => 'Pesan %1 per jam',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Tidak terbatas',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, batas adalah %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 percobaan untuk melampaui batas dari %2 ke %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 percobaan untuk melampaui batas dari %2 sampai sekarang',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Pencekalan Alamat IP (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Komponen Fail2ban tidak terpasang di server tujuan.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Pasang Fail2ban. Perhatikan bahwa proses ini memerlukan waktu beberapa menit.',

    'plesk_key__no_reseller_support' => 'Anda tidak dapat mengelola penyalur karena pembatasan lisensi.',
    'plesk_key__no_customers_support' => 'Anda tidak dapat mengelola pelanggan karena pembatasan lisensi.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Tidak dapat beralih ke tampilan Penyedia Layanan karena pembatasan lisensi.',
    'plesk_key__no_security_core_support' => 'Fitur inti keamanan (ModSecurity dan Fail2Ban) tidak tersedia karena pembatasan lisensi.',
    'plesk_key__outgoing-antispam' => 'Kontrol Surat Keluar',
    'plesk_key__security-core' => 'Inti Keamanan (ModSecurity dan Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Pengelolaan akun',
    'plesk_key__can-manage-subscriptions' => 'Pengelolaan langganan',
    'plesk_key__can-manage-customers' => 'Pengelolaan pelanggan',
    'plesk_key__can-manage-resellers' => 'Pengelolaan Penyalur',
    'plesk_key__can-manage-custom-view' => 'Ketersediaan Mode Terlarang',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Pengelolaan langganan dimatikan tapi Anda memiliki beberapa langganan (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Pengelolaan Penyalur dimatikan tapi Anda memiliki beberapa penyalur (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Pengelolaan Pelanggan dimatikan tapi Anda memiliki beberapa pelanggan (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Sumber daya langganan tertentu yang tidak lagi dapat Anda kelola di antarmuka Plesk (seperti batas kotak surat dan ruang disk domain) kini ditetapkan menjadi tidak terbatas.',
    'plesk_key__no_subscriptions_support' => 'Anda tidak dapat mengelola langganan karena pembatasan lisensi.',
    'plesk_key__no_custom_view_support' => 'Anda tidak dapat menggunakan Mode Terlarang karena pembatasan lisensi.',
    'plesk_key__trial_forbidden_region' => 'Maaf, Plesk saat ini tidak tersedia di wilayah Anda.',
    'additional_key__main_key' => 'Kunci ini adalah kunci utama: Anda tidak dapat mengunggah kunci utama sebagai kunci tambahan.',

    'gch__hosting_waf_rule_engine' => 'Mode firewall aplikasi web',

    'backup__fieldset__restoration_options' => 'Opsi pemulihan',
    'backup__restore_options__restore' => 'Pulihkan',
    'backup__restore_options__domain__domain_configuration' => 'Konfigurasi domain',
    'backup__restore_options__domain__virtual_host_content' => 'Isi host virtual',
    'backup__restore_options__domain__mail' => 'Surat',
    'backup__restore_options__domain__databases' => 'Basis data',
    'backup__restore_options__client__client_configuration' => 'Konfigurasi akun pelanggan',
    'backup__restore_options__client__domains' => "Domain pelanggan",
    'backup__restore_options__reseller__reseller_configuration' => 'Konfigurasi akun penyalur',
    'backup__restore_options__reseller__personal_domains' => "Domain penyalur",
    'backup__restore_options__reseller__clients' => "Pelanggan penyalur",
    'backup__restore_options__admin__server_configuration' => 'Pengaturan server',
    'backup__restore_options__admin__administrator_configuration' => 'Konfigurasi akun administrator',
    'backup__restore_options__admin__personal_domains' => "Domain administrator",
    'backup__restore_options__admin__personal_clients' => "Pelanggan administrator",
    'backup__restore_options__admin__resellers' => 'Penyalur',

    'badge_new' => 'Baru',
    'upgrade_php_on_subscription' => 'Upgrade PHP untuk langganan Anda menjadi versi 5.3.0 atau yang lebih baru.',

    'pkey_notify__body_expiration_notification' => 'Kunci lisensi kedaluwarsa. Beberapa fitur menjadi tidak tersedia. Harap hubungi penyedia hosting Anda.',

    'crontab__crontab_entry_exists' => "Tugas terjadwal sudah ada.",
    'crontab__crontab_entry_not_exists' => "Tugas terjadwal tidak ada.",
    'crontab__invalid_values_found' => "Nilai parameter salah.",
    'crontab__cmd_max_len' => "Perintah tidak boleh lebih dari %1 karakter.",

    'domain__domain_exists' => "Terdapat domain dengan prefiks 'www' dan nama sama: %1.%2.",
    'domain__subdomain_exists' => "Terdapat bdomain dengan prefiks 'www' dan nama sama: %1.%2.",
    'domain__dalias_exists' => "Terdapat alias domain dengan prefiks 'www' dan nama sama: %1.%2.",
    'domain__record_exists' => "Terdapat catatan DNS yang menunjuk ke host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Sertifikat '%1' tidak dapat diatur sebagai yang default: kunci pribadi tidak ada.",
    'ip_addr__update_dns_error' => 'Masalah timbul ketika memperbarui alamat IP dalam zona DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Tidak dapat menambahkan alamat IP. Antarmuka jaringan ini mendapatkan alamat IP secara otomatis.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Tidak dapat menghapus alamat IP %1. Antarmuka jaringan ini mendapatkan alamat IP secara otomatis.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Tidak dapat memperbaiki alamat IP %1. Antarmuka jaringan ini mendapatkan alamat IP secara otomatis.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Tidak dapat mengubah antarmuka alamat IP %1 karena antarmuka jaringan %2 mendapatkan alamat IP secara otomatis.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Batas langganan sejumlah %%type%% telah terlampaui. Batas saat ini adalah %%limit%%, dan %%usage%% kini sedang terpakai.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Pembuatan %%type%% tidak diizinkan untuk langganan ini.',
    'shm_lmsg__resource_title__db-mysql' => 'Basis data MariaDB/MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Basis data MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Basis data PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'pengguna basis data',
    'shm_lmsg__resource_title__iis-application-pool' => 'Kumpulan aplikasi IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'akun FTP tambahan',

    'db_user_unable_remove_mysql_global_privileges' => 'Tidak dapat menghapus hak istimewa global MariaDB/MySQLdari basis data pengguna %1. Alasan: %2',
    'report__client_description' => 'Deskripsi',

    'db__user_role_error' => 'Peran pengguna basis data yang salah ditentukan: %1. Harap pilih salah satu di antara peran berikut: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Tidak dapat menetapkan batas ukuran berkas untuk basis data Server Microsoft SQL berikut karena mereka mempunyai ukuran berkas yang lebih besar: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Tidak dapat menetapkan batas ukuran berkas log untuk basis data Server Microsoft SQL berikut karena mereka mempunyai ukuran berkas log yang lebih besar: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Tidak dapat menetapkan alamat IP publik: harus ada alamat IP pribadi.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Tidak dapat menetapkan alamat IPv4 publik untuk alamat IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Tidak dapat menetapkan alamat IPv6 publik untuk alamat IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Tidak dapat menetapkan alamat IP publik: alamat IP tidak valid.',

    '__user_already_exists' => "Pengguna %1 sudah ada.",
    '__user_name_is_empty' => "Harap tentukan nama pengguna.",

    'upgrade_php_on_domain' => 'Tidak dapat menemukan PHP versi 5.3.0 atau lebih tinggi pada semua domain WordPress Anda. Coba tingkatkan PHP.',

    'component_name__waf' => 'Firewall Aplikasi Web',
    'component_name__vcs' => 'Sistem Kontrol Versi',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Kemungkinan upaya spoofing telah terdeteksi: Tautan tersebut mencoba menampilkan konten yang tidak relevan.',
    'forceResetPasswordUpdated' => 'Kata sandi Anda sudah diubah. Gunakan kata sandi baru untuk masuk ke Plesk.',

    'php_handlers_error_no_available_instance' => 'Tidak dapat membuat domain: tidak ada penangan PHP yang tersedia.',
    'domain_error_unable_to_apply_hosting_settings' => 'Tidak dapat menerapkan pengaturan hosting: %1',

    'plesk_not_configured' => 'Plesk belum dikonfigurasi. Pergi ke panel kontrol untuk melakukan konfigurasi pasca-pemasangan.',
    'cmd_mail__mail_password_duplicated' => 'Pasangan alamat surel dan kata sandi yang ditentukan sudah ada di server surat. Harap tentukan alamat surel dan kata sandi lain.',

    'extensionRequirementOs' => 'Sistem operasi (%1) tidak didukung oleh paket.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 adalah versi terlama yang didukung oleh paket.',
    'extensionRequirementPleskMaxVersion' => 'Versi dimulai dari Plesk %1 tidak didukung oleh paket.',
    'extensionBlacklisted' => 'Ekstensi %1 tidak diizinkan untuk pemasangan.',
    'extensionDisabled' => 'Ekstensi dinonaktifkan.',


    'optimization_settings__unable_set_mpm_event' => 'Tidak dapat menetapkan mode mpm_event: itu mengharuskan modul PHP5 Apache module dimatikan tetapi modul ini digunakan oleh domain.',
    'optimization_settings__unable_turn_off_php' => 'Gunakan untuk mematikan modul PHP5 Apache: itu digunakan oleh domain.',

    'hst_def__fp_admin_login' =>  'Nama Pengguna FTP',
    'hst_def__fp_admin_passwd' =>  'Kata Sandi FTP',

    'database_user_orphaned_old_password_wrong' => "Tidak dapat memperbaiki pengguna tanpa induk '%1': kata sandi tidak benar.",
    'cannot_load_partner_central_property_key_no_exist' => "Tidak dapat mengambil properti kustom global: kunci lisensi tidak ada.",
    'extensionScriptFailure' => "Pelaksanaan %1 telah gagal dengan pesan berikut:\n%3",
    '__ssl_redirect' => "Pengalihan SEO-safe 301 permanen dari HTTP menjadi HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Manajemen DKIM tidak didukung.',
    'mail__dmarc_not_supported' => 'Pengelolaan DMARC tidak didukung.',
    'mail__relay_white_list_not_supported' => 'Manajemen daftar putih relai tidak didukung.',
    'mail__black_list_not_supported' => 'Manajemen daftar hitam tidak didukung.',
    'mail__autoresponder_not_supported' => 'Manajemen responder otomatis tidak didukung.',
    'defaultcomponents__not_supported_version' => '(versi yang tidak didukung)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Sertifikat \\%1\' tidak ditemukan.',
    'certificate__unable_setup_certificate' => 'Tidak dapat memasang sertifikat: Kunci pribadi dan isi sertifikat hilang.',
    'certificate__used_by_panel' => 'Salah satu sertifikat yang akan Anda hapus digunakan untuk mengamankan Plesk.',
    'certificate__used_by_mail_server' => 'Salah satu sertifikat yang akan Anda hapus digunakan untuk mengamankan server surat.',
    'certificate__used_by_domain_service' => 'Salah satu sertifikat yang akan Anda hapus digunakan oleh layanan domain.',
    'mail_server__not_installed' => 'Tidak dapat memasang sertifikat untuk server surat karena server surat tidak terpasang.',

    'email_activation_mail_subject' => 'Harap aktivasi akun Anda di Plesk',
    'email_activation_mail_body' => "Akun dibuat server Plesk %1\n\nDetail akun:\nNama: %2\nAlamat surel: %3\n\nJika informasi ini benar dan akun dibuat untuk Anda, harap aktivasi dengan tautan berikut:\n\n%4\n\nDengan mengaktivasi akun, Anda mengizinkan pemegang server untuk mengambil, menyimpan, memproses, dan menggunakan data pribadi Anda (nama dan surel) untuk membuat dan mendukung akun Anda, sesuai dengan undang-undang perlindungan data yang berlaku saat ini, sebagai bagian dari kontrak.",

    'backup_transport_permission_name' => '%1 pengelolaan',
    'backup_transport_permission_description' => 'Mengizinkan penggunaan %1 untuk penyimpanan cadangan.',

    'domain_move_err_target_no_hosting' => 'Tidak dapat memindahkan domain ke suatu langganan tanpa hosting.',
    'domain_move_err_already_in_target' => 'Domain sudah jadi bagian dari langganan target.',
    'domain_move_err_main_domain' => 'Domain utama tidak dapat dipindahkan.',
    'domain_move_err_subdomain_without_parent' => 'Tidak dapat memindahkan subdomain %1 tanpa domain induk %2.',
    'domain_move_err_root_exists' => 'Jalur target untuk www_root %1 sudah ada.',
    'domain_move_err_nested_roots' => 'Tidak dapat memindahkan domain karena domain tersebut berbagi root dokumen dengan domain yang lain: %1.',
    'domain_move_err_no_mail_service' => 'Tidak dapat memindahkan domain karena layanan email dinonaktifkan di langganan target.',
    'domain_move_err_app' => "Aplikasi yang diinstal di %1 tidak dipindahkan ke langganan '%2': %3",
    'domain_move_database_used_by_app' => "Basis data '%1' di %2 digunakan oleh aplikasi yang dipindahkan. Untuk menetapkan ulang basis data ke '%3', jalankan `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Langganan target '%1' dikunci untuk sinkronisasi.",
    'domain_move_filesharing_disabled' => 'Berbagi file dinonaktifkan.',
    'domain_move_website_preview_disabled' => 'Pratinjau situs web telah dinonaktifkan.',
    'domain_move_additional_webserver_settings' => "Tinjau petunjuk server web tambahan dari domain tersebut untuk mencegah konfigurasi yang rusak.",
    'domain_move_no_permission' => "%1 tidak diizinkan untuk langganan '%2'.",
    'domain_move_no_access' => "Tidak ada akses ke langganan '%1'.",
    'domain_split_no_create_permission' => "Pembuatan domain tidak diizinkan.",
    'domain_split_empty_login' => 'Login pengguna sistem diperlukan.',
    'domain_split_empty_password' => 'Kata sandi pengguna sistem diperlukan.',
    'domain_split_err_home_exists' => 'Domain %1 tidak dapat dipindahkan karena jalur beranda targetnya sudah ada di %2. Ganti nama domain untuk memindahkannya ke langganan baru.',
    'domain_split_err_no_hosting_subdomains' => 'Domain tidak dapat dipindahkan ke langganan baru karena domain tidak memiliki hosting tetapi memiliki subdomain. Untuk memindahkan domain, ubah nilai "Hosting type" domain tersebut menjadi "Website hosting" (di Pengaturan Hosting).',
    'domain_split_target_locked' => "Langganan target '%1' dikunci untuk sinkronisasi.",
    'domain_split_target_unsynced' => "Langganan target '%1' tidak disinkronkan dengan rencana karena: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Pencadangan terjadwal telah dinonaktifkan di '%1'.",
    'domain_merge_database_error' => "Basis data '%1' pada %2 tidak dipindahkan ke langganan '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "FTP anonim di '%1' telah dimatikan.",
    'domain_merge_smb_user_access' => "Pengguna tambahan '%1' dipindahkan ke langganan '%2' tetapi akses pengguna ke langganan tersebut dicabut.",
    'domain_merge_scheduled_tasks' => "Tugas terjadwal dipindahkan ke langganan target. Tinjau konfigurasi tugas.",
    'domain_merge_scheduled_tasks_deactivated' => "Tugas terjadwal dipindahkan ke langganan target dan dinonaktifkan. Tinjau konfigurasi tugas.",
    'domain_merge_no_remove_permission' => "Menghapus langganan tidak diizinkan.",
    'domain_merge_err_has_addons' => 'Tidak dapat memindahkan domain utama dengan domain tambahannya; pindahkan domain %1 terlebih dahulu.',
    'domain_merge_err_has_webusers' => 'Tidak dapat memindahkan domain utama dengan pengguna webnya.',
    'domain_merge_err_root_exists' => 'Jalur target %1 sudah ada.',

    'database_server_edit_used_for_psa' => 'Memperbarui server basis data MariaDB/MySQL lokal tidak diizinkan.',
    'suggest_repair_main_suggestion_ui' => '<b>Anda dapat memperbaiki kesalahan</b> dengan menggunakan utilitas `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Anda dapat memperbaiki kesalahan dengan menggunakan utilitas `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'menuju ke Diagnosis & Perbaikan',
    'suggest_repair_using_cli_and_ui' => 'Untuk melakukannya, jalankan perintah `plesk repair %1` melalui CLI atau %2 dan klik Perbaiki di sebelah "Basis Data Plesk"',
    'suggest_repair_using_cli' => 'Untuk melakukannya, jalankan perintah `plesk repair %1` melalui CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Layanan DNS tidak tersedia ketika cadangan dibuat. Namun, ada zona DNS aktif di cadangan dan akan diaktifkan untuk objek-objek berikut ini: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Resource Controller (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Dukungan SmarterMail jauh',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(tidak diizinkan oleh kunci lisensi)',
    'plesk_key__validation_failed' => '%1 (Kode kesalahan: %2)',
    'promo__button_details' => 'Perincian',
    'promo__extension_catalog_title' => 'Katalog Ekstensi',
    'promo__extension_catalog_description' => 'Periksa katalog ekstensi baru dan perluas Plesk Anda dengan berbagai ekstensi yang berdaya guna!',
    'promo__button_open_catalog' => 'Buka Katalog',

    'backup__repository_check_login' => "Tidak dapat mengakses penyimpanan: %1 Pastikan Anda telah memasukkan kredensial penyimpanan yang benar.",
    'backup__repository_check_error_list' => "Tidak dapat mengakses penyimpanan: %1 Pastikan Anda telah memasukkan pengaturan penyimpanan yang benar.",
    'backup__repository_check_error_mkdir' => "Tidak dapat membuat direktori: %1 Periksa apakah Anda memiliki izin untuk membuat folder dalam penyimpanan.",
    'backup__repository_check_error_upload' => "Tidak dapat mengunggah file ke penyimpanan: %1 Periksa apakah Anda memiliki izin untuk mengunggah file ke penyimpanan.",
    'backup__repository_check_error_download' => "Tidak dapat mengunduh file dari penyimpanan: %1 Periksa apakah Anda memiliki izin untuk mengunggah dan mengunduh file dari penyimpanan.",
    'backup__repository_check_error_resume-upload' => "Tidak dapat melanjutkan mengunggah file ke penyimpanan: %1 Periksa apakah Anda memiliki izin untuk melanjutkan mengunggah ke penyimpanan.",
    'backup__repository_check_error_resume-download' => "Tidak dapat melanjutkan mengunduh file dari penyimpanan: %1 Periksa apakah Anda memiliki izin untuk melanjutkan mengunduh dari penyimpanan.",
    'backup__repository_check_error_enable-utf8' => "Tidak dapat mengoperasikan penyimpanan: %1 Periksa apakah penyimpanan tersebut mendukung penyandian UTF8.",
    'backup__repository_check_error_rm' => "Tidak dapat mengoperasikan penyimpanan: %1 Periksa apakah Anda memiliki izin untuk menghapus file dari penyimpanan.",
    'backup__repository_check_error_rmdir' => "Tidak dapat mengoperasikan penyimpanan: %1 Periksa apakah Anda memiliki izin untuk menghapus folder dari penyimpanan.",

    'backup__ftp_repository_check_login' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2",
    'backup__ftp_repository_check_error_list' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Anda dapat memeriksanya secara independen dengan perintah: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Tidak dapat mengubah pengaturan untuk DMARC. Untuk mengaktifkan opsi ini, harap aktifkan perlindungan spam DKIM dan SPF.',
    'spf_server_wide_disable_failed' => 'Tidak dapat mengubah pengaturan untuk perlindungan spam SPF. Untuk menonaktifkan SPF, silakan nonaktifkan DMARC untuk surat yang masuk.',
    'sfdk_server_wide_verify_disable_failed' => 'Tidak dapat mengubah pengaturan untuk perlindungan spam DKIM. Untuk menonaktifkan DKIM, matikan DMARC untuk surat yang masuk.',

    'ccs_not_supported' => 'Toko Sertifikat Pusat IIS tidak dikonfigurasikan di sistem.',
    'ccs_not_enabled' => 'Pengelolaan Toko Sertifikat Pusat IIS tidak diaktifkan di Plesk.',
    'ad_not_supported' => 'Server tidak tergabung dengan domain.',

    'component_name__appinit' => "Inisialisasi Aplikasi",
    'component_name__cors' => "Berbagi Sumber Daya Lintas Asal",
    'component_name__httpcompression' => 'Kompresi Konten HTTP',
    'common_feature_is_not_supported' => 'Fitur ini tidak lagi didukung.',
    'common_feature_is_not_supported_in_proto' => 'Fitur ini tidak didukung untuk versi protokol %1.',
    'autoinstaller__plesk_component' => 'Komponen Plesk',
    'plesk_key__key_expired' => 'Kunci lisensi Anda telah kedaluwarsa. Agar dapat terus menggunakan Plesk, beli komersial yang tidak kedaluwarsa %1.',
    'plesk_key__key_purchase' => 'kunci lisensi',

    'sa_action_move' => 'Pindahkan spam ke folder “Junk E-mail”',

    'bu_conflict_resolver_tomcat_not_supported' => 'Tidak lagi mendukung aplikasi Java dan tidak akan tersedia untuk situs web berikut ini: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Tidak lagi mendukung situs web versi seluler yang dihosting Seluler UNITY dan tidak akan tersedia untuk situs web berikut ini: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Kebijakan penggunaan seluruh server tidak mengizinkan menggunakan pengaturan antivirus pribadi. Pemulihan tidak akan sepenuhnya dilakukan bagi akun-akun email dari domain berikut ini: {{objects}}',

    'module__not_installed' => "Ekstensi %1 tidak terpasang",

    'mail__mail_autodiscovery_server_error' => 'Tentukan nama domain kustom untuk penemuan otomatis surat',
    'mail__error_mail_autodiscovery_enable' => 'Tidak dapat mengatur penemuan otomatis surat: %1',
    'mail__error_mail_autodiscovery_server' => 'Tidak dapat mengatur nama domain kustom untuk penemuan otomatis surat: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Tidak dapat mengonfigurasi ulang rekaman DNS penemuan otomatis domain: %1',

    'mail__smarthost_not_configured_error' => 'Smarthost tidak terkonfigurasi.',
    'mail__smarthost_attach_domains_error' => 'Melampirkan domain ke smarthost selesai dengan kesalahan:',

    '__invalid_url' => 'URL "%1" tidak valid.',
    'actionlog__cloning_start' => 'mulai',
    'actionlog__event_cloning_start' => 'Mulai kloning server',

    '__UPLOAD_ERR_FORM_SIZE' => "File yang diunggah melebihi ukuran yang dibolehkan",
    '__UPLOAD_ERR_INI_SIZE' => "File yang diunggah melebihi ukuran yang dibolehkan",
    '__UPLOAD_ERR_NO_FILE' => "Tidak ada file yang diterima",
    '__UPLOAD_ERR_OK' => "File berhasil terunggah",
    '__UPLOAD_ERR_PARTIAL' => "File terunggah sebagian, silakan coba lagi",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Folder sementara hilang',
    '__UPLOAD_ERR_CANT_WRITE' => 'Gagal menulis file ke disk',
    '__UPLOAD_ERR_UNKNOWN' => 'Terjadi kesalahan tidak dikenal pada penggunggahan file',
    '__accounts' => "Akun",
    '__access' => "Akses",
    '__address' => "Alamat",
    '__addresses' => "Alamat",
    '__acl_records' => 'Catatan ACL',
    '__admin_repository' => "Repositori administrator",
    '__all' => 'Semua',
    '__allowed' => "Diizinkan",
    '__anonftp_status' => "FTP Anonim",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...server web %1 sedang dimulai ulang, harap tunggu...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Dukungan Microsoft ASP.NET",
    '__asp_win_support' => "Dukungan Microsoft ASP",
    '__attachments' => "Lampiran",
    '__attachments_list' => "Lampiran",
    '__author' => 'Penulis',
    '__autoresp_name_already_exists' => "Balasan Otomatis dengan nama %1 sudah ada.",
    '__autoresponder' => "Balasan otomatis",
    '__autoresponders' => "Balasan otomatis",
    '__autoresponders_list' => "Balasan otomatis",
    '__autoresponder_attachment_files' => "File Lampiran Balasan Otomatis",
    '__auto_updates_list' => 'Pembaruan yang Tersedia',
    '__avail' => "Tersedia",
    '__backup_utilites' => "Utilitas Pencadangan",
    '__bind_status' => "Status Server DNS",
    '__bu_is_not_installed' => "Layanan tidak tersedia saat ini, karena utilitas pencadangan tidak terpasang.",
    '__bu_not_support_in_key' => "Kemampuan pencadangan tidak didukung oleh kunci lisensi.",
    '__notifications_not_support_in_key' => 'Notifikasi tidak didukung oleh kunci lisensi',
    'disabled_by_key' => 'Tidak didukung oleh kunci lisensi',
    '__bytes' => "byte",
    '__can_not_use_reserved_words' => "Anda tidak dapat menggunakan kata yang dicadangkan.",
    '__certificate' => "Sertifikat",
    '__cgi_support' => "Dukungan CGI",
    '__city' => "Kota",
    '__cl_not_exist' => "Akun pelanggan tidak ada.",
    '__client' => 'Pelanggan',
    '__client_card' => "Kartu pelanggan",
    '__client_contact_name' => "Nama kontak pelanggan",
    '__client_form' => "Informasi pribadi",
    '__client_ip_pool' => "Kumpulan IP pelanggan",
    '__client_limits' => "Batas akun pelanggan",
    '__client_permissions' => "Izin pelanggan",
    '__client_preferences' => "Preferensi pelanggan",
    '__client_status' => "Status pelanggan",
    '__client_name' => "Nama pelanggan",
    '__client_total' => "Total Pelanggan",
    '__client_with_login_name_already_exists' => "Pengguna dengan nama pengguna \"%1\" sudah ada.",
    '__client_domuser_with_login_already_exists' => "Nama pengguna '%1' sudah digunakan oleh administrator domain '%1'.",
    '__clients_global_changes' => "Ubah akun pelanggan pilihan",
    '__clients_list' => "Pelanggan",
    '__cmd_not_found' => "Perintah tidak dikenal: %1",
    '__comments' => "Komentar",
    '__company_name' => "Nama perusahaan",
    '__component_version' => "Versi komponen",
    '__component_not_installed' => "Komponen %1 tidak terpasang",
    '__confirm_overwrite' => "Konfirmasi penimpaan.",
    '__confirm_stop' => "Konfirmasi penghentian proses.",
    '__confirm_passwd' => "Konfirmasi %1 kata sandi",
    '__conhelp' => "Deskripsi",
    '__contact_name' => "Nama kontak",
    '__country' => "Negara",
    '__countries' => 'Negara',
    '__country_unknown' => 'Tidak dapat mengenali subcode negara.',
    '__courier-imap' => 'Server kurir',
    '__create_domain' => 'Buat domain',
    '__crypted' => 'Terenkripsi',
    '__cp_access' => "Akses ke Plesk",
    '__cp_user' => "Pengguna Plesk",
    '__create' => "Buat",
    '__create_client_template_without_template' => "Buat akun pengguna tanpa template",
    '__create_domain_for' => "Buat domain untuk <b>%1</b>",
    '__create_domain_template_without_template' => "Buat domain baru tanpa template",
    '__creation_date' => "Tanggal pembuatan",
    '__crontab_unix' => "Penjadwal",
    '__crontab_win' => "Penjadwal",
    '__ct_month_jan' => 'Januari',
    '__ct_month_feb' => 'Februari',
    '__ct_month_mar' => 'Maret',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Mei',
    '__ct_month_jun' => 'Juni',
    '__ct_month_jul' => 'Juli',
    '__ct_month_aug' => 'Agustus',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'Desember',
    '__custom_button' => "Tombol suai",
    '__custom_buttons_list' => "Tautan ke layanan tambahan",
    '__daily' => "Harian",
    '__database_not_activated' => "%1 tidak diaktifkan pada halaman administrasi server.",
    '__database_not_installed' => "Basis data %1 tidak terpasang.",
    '__database_not_run' => "Basis data %1 tidak berjalan.",
    '__database_is_corrupt' => "Basis data Plesk rusak. Silakan meluncurkan utilitas Reconfigurator untuk memperbaikinya.",
    '__databases' => "Basis data",
    '__databases_list' => "Basis data",
    '__database_type_not_supported_by_key' => 'Untuk menggunakan server %1, Anda perlu dukungan untuk itu pada kunci lisensi Anda. Silakan hubungi perwakilan penjualan Plesk Anda.',
    '__date_immediately' => "hari ini",
    '__date_never' => "tidak pernah",
    '__day(s)' => "Hari",
    '__day0' => "Min",
    '__day1' => "Sen",
    '__day2' => "Sel",
    '__day3' => "Rab",
    '__day4' => "Kam",
    '__day5' => "Jum",
    '__day6' => "Sab",
    '__days' => "%1 hari",
    '__db_admin_login_empty' => "Anda telah memasukkan nama pengguna kosong, mematikan kontrol atas %1 pada antarmuka. Apakah Anda ingin melanjutkan?",
    '__db_unable_to_unregister' => 'Tidak dapat menghapus parameter koneksi basis data',
    '__db_db_exists' => 'Minimal ada satu basis data di server',
    '__db_unable_to_change_server_name' => 'Nama server tidak bisa diubah',
    '__db_unable_to_change_port' => 'Port untuk server tidak bisa diubah',
    '__db_already_exist' => "Basis data %1 sudah ada.",
    '__db_credentials_invalid' => "Informasi akses basis data invalid.",
    '__db_invalid_password_characters' => 'Kata sandi berisi karakter tidak valid',
    '__db_engine' => "Mesin Basis Data", // indirect
    '__db_type' => "Jenis basis data",
    '__db_user' => "Pengguna basis data",
    '__db_server' => 'Server basis data',
    '__def_domain' => "Domain default",
    '__default_for_mysql' => 'default untuk MySQL',
    '__default_for_mariadb' => 'default ke MariaDB',
    '__default_for_percona' => 'default ke Percona',
    '__default_for_postgresql' => 'default untuk PostgreSQL',
    '__delete' => "Hapus",
    '__demo' => "Fungsi ini tidak tersedia pada versi demo.",
    '__directory' => "Direktori",
    '__disable_lock_screen' => 'Mencegah pengguna untuk bekerja menggunakan Plesk sampai layar antarmuka telah diunduh sepenuhnya',
    '__dismiss_news?' => "Apakah Anda yakin ingin menutup blok berita sepenuhnya? Anda tidak akan dapat melihat blok berita sampai tersedia berita lagi.",
    '__description' => "Deskripsi",
    '__disabled' => "dimatikan",
    '__disk_space_limit' => "Batas ruang disk",
    '__cgroups_cpu_usage_limit' => 'Batas penggunaan CPU',
    '__cgroups_ram_usage_limit' => 'Batas penggunaan RAM',
    '__cgroups_disk_read_usage_limit' => 'Batas Lebar Pita Baca Disk',
    '__cgroups_disk_write_usage_limit' => 'Batas Lebar Pita Tulis Disk',
    '__disk_usage_by' => "Ruang disk digunakan oleh %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Catatan DNS '%1' sudah ada.",
    '__dns_master_should_be_remote' => "Anda harus memiliki dua server nama otoritatif pada host yang terpisah.",
    '__dns_record_not_exist' => "Catatan DNS tidak ada.",
    '__dns_server' => "Server DNS", // indirect
    '__dom_id_is_undefined' => "ID domain tidak terdefinisi.",
    '__dom_name' => "Nama domain",
    '__dom_name_is_invalid' => "Nama domain invalid. Pastikan nama domain Anda hanya terdiri dari alfanumerik, titik, dan tanda garis penghubung, serta tidak lebih panjang dari 255 simbol. Masing-masing bagian dari nama domain di antara titik tidak boleh melampaui 63 simbol.",
    '__dom_not_exist' => "Domain tidak ada.",
    '__domain' => "Domain",
    '__domain_' => 'Domain %1',
    '__domain_form' => "Format domain",
    '__domain_id' => "ID Domain",
    '__domain_is_turned_off_for_backup' => "Situs web %1 dimatikan sementara untuk pencadangan atau pemulihan dan sedang tidak tersedia.",
    '__domain_limits' => "Batas domain",
    '__domain_name' => "Nama domain",
    '__mail_name_in_ASCII_form' => "Nama akun surat dalam format ASCII",
    '__message_error' => 'Galat',
    '__message_warning' => 'Peringatan',
    '__message_info' => 'Informasi',
    '__domain_name_in_ASCII_form' => "Nama domain dalam format ASCII",
    '__domain_repository' => "Repositori domain %1",
    '__domain_status' => "Status domain",
    '__domain_found_tech' => "Teknologi ditemukan di domain",
    '__domain_dns' => 'Zona DNS domain',
    '__domain_total' => "Jumlah total untuk langganan",
    '__domain_total_powerUser' => "Jumlah total untuk langganan",
    '__domain_user' => "Administrator domain",
    '__domains_global_changes' => "Ubah domain pilihan",
    '__mailnames_global_changes' => "Mengubah akun surat pilihan",
    '__backup_manager' => 'Pengelola Pencadangan',
    '__domains_list' => "Domain",
    'domains_list__list_header' => "domain",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Nama domain mulai dengan www, meskipun prefiks WWW sudah digunakan. Tetap lanjutkan?",
    '__dovecot' => 'Dovecot IMAP dan Server POP3',
    '__dsmail' => "Layanan surat",
    '__dsmaillist' => "Layanan milis",
    '__dumps_tot_size' => "Ukuran total berkas cadangan dalam penyimpanan lokal",
    '__email' => "Surel",
    '__email_addr_is_invalid' => "Alamat surel invalid.",
    '__enabled' => "dihidupkan",
    '__enter_cert_text' => "Masukkan teks sertifikat",
    '__enter_size' => "Masukkan ukuran",
    '__exclusive' => "Khusus",
    '__expiration_date' => "Tanggal kedaluwarsa",
    '__fax' => "Faks",
    '__file' => "File",
    '__file_is_empty' => "File kosong.",
    '__file_name' => "Nama file",
    '__file_type' => 'Jenis file',
    '__filemanager' => "Pengelola File",
    '__filepath_is_empty' => "Jalur ke file kosong",
    '__files_list' => "File",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Pengaturan FTP",
    '__ftp_serv' => "Server FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Atur properti akun FTP terlebih dahulu!",
    '__ftp_status' => "Status server FTP",
    '__full_day0' => "Minggu",
    '__full_day1' => "Senin",
    '__full_day2' => "Selasa",
    '__full_day3' => "Rabu",
    '__full_day4' => "Kamis",
    '__full_day5' => "Jumat",
    '__full_day6' => "Sabtu",
    '__full_month1' => "Januari",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "Desember",
    '__full_month2' => "Februari",
    '__full_month3' => "Maret",
    '__full_month4' => "April",
    '__full_month5' => "Mei",
    '__full_month6' => "Juni",
    '__full_month7' => "Juli",
    '__full_month8' => "Agustus",
    '__full_month9' => "September",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Kuota hard disk",
    '__hard_disk_quota_not_supported' => 'kuota hard disk tidak didukung akibat konfigurasi sistem file server',
    '__help_topic_not_found' => 'Topik bantuan yang Anda minta (%1) tidak ada.',
    '__hosting_ip_dns_ip_not_equiv' => "Alamat IP yang disebut pada catatan A DNS tidak ada yang sesuai dengan alamat IP untuk hosting.",
    '__hosting_scripting' => "Mendukung penulisan skrip hosting",
    '__hosting_setup_page_title' => "Penataan hosting web untuk domain %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Tipe hosting",
    '__hostname_is_empty' => "Hostname kosong.",
    '__hour(s)' => 'Jam',
    '__hst_type_incorrect' => "Tipe hosting salah.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Waktu diam",
    '__iface' => "Antarmuka",
    '__image' => "Gambar",
    '__imap_status' => "Status Server IMAP",
    '__in' => "Masuk",
    '__in_%' => "dalam %",
    '__incorrect_databases_login_pass' => "Informasi akses yang Anda tentukan untuk mengakses PostgreSQL salah.",
    '__incorrect_ip_or_network_address' => 'Alamat IP atau jaringan salah.',
    '__info' => 'Info',
    '__install' => "Pasang",
    '__install_prefix' => "Pasang prefiks",
    '__invalid_cert_id' => "ID sertifikat invalid",
    '__invalid_context' => "Konteks invalid: %1",
    '__invalid_db_usr_name' => "Nama pengguna basis data invalid.",
    '__invalid_dir_name' => "Nama direktori invalid",
    '__invalid_dom_name' => "Nama domain invalid.",
    '__invalid_filename' => "Nama file invalid. Jangan menggunakan kombinasi apostrof dan/atau \"../\".",
    '__invalid_id' => "Pengidentifikasi invalid.",
    '__invalid_lines_num' => "Nilai tidak tepat untuk jumlah baris, hanya angka yang dibolehkan.",
    '__invalid_max_letter_size' => "Ukuran pesan maksimum invalid.",
    '__invalid_restart_apache_interval' => "Interval mulai ulang Apache invalid.",
    '__invalid_tmpl_name' => "Nama template invalid.",
    '__invalid_value' => "Nilai tidak benar.",
    '__ip_addr' => "Alamat IP",
    '__ip_address_and_mask' => "Alamat IP dan Masker Subnet",
    '__ip_alias__mask' => "Alamat IP dan Masker Subnet",
    '__ip_addr_is_invalid' => "Alamat IP invalid.",
    '__ip_addr_list' => "Alamat IP",
    '__ip_address_and_mask_hint' => 'Sebagai contoh, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KByte",
    '__key_for_virtuozzo_only' => "Kunci lisensi Anda hanya ditujukan untuk penggunaan dalam penampung Virtuozzo.",
    '__key_limits_exceeding' => "Tindakan ini melebihi batas yang ditetapkan pada lisensi perangkat lunak Anda. Jika Anda menerima pesan ini silakan hubungi penyedia atau produsen Anda untuk mendapat penjelasan atau meningkatkan batas lisensi ini.",
    '__kilo' => "K",
    '__keywords' => 'Kata kunci',
    '__lang_unknown' => 'Tidak dapat mengenali bahasa.',
    '__languages' => 'Bahasa',
    '__learn_more' => 'Pelajari lebih jauh',
    '__loading' => 'Memuat...',
    '__locales' => "Paket bahasa",
    '__lists' => "Milis",
    '__literal_bytes' => "B",
    '__processing' => "Harap tunggu.<br>Memuat...",
    '__locale' => "Bahasa antarmuka",
    '__locale_is_not_defined' => "Bahasa antarmuka tidak ditentukan.",
    '__local_server_mysql' => 'Server MariaDB/MySQL Lokal',
    '__local_server_postgresql' => 'Server PostgreSQL lokal',
    '__local_server_mssql' => 'Server MS SQL lokal',
    '__log_and_statistics_files' => 'File log dan laporan statistik',
    '__config_files' => 'File konfigurasi',
    '__chroot_files' => 'Wilayah yang di-chroot',
    '__login' => "%1 Masuk",
    '__login1' => "Masuk",
    '__login_disabled' => "Masuk dilarang",
    '__login_enabled' => "Masuk dibolehkan",
    '__login_incorrect' => "Anda telah memasukkan nama pengguna atau kata sandi yang salah.",
    '__login_name' => "%1 nama pengguna",
    '__login_name_is_invalid' => "%1 nama pengguna invalid.",
    '__logon_time' => "Waktu masuk",
    '__ma' => "Alias surat",
    '__mail' => "Surat",
    '__mail_alias_name' => "Nama alias surat",
    '__mail_autodiscovery' => 'Penemuan otomatis surat',
    '__mail_exchanger_name_is_invalid' => "Nama penukar surat tidak valid.",
    '__mail_groups' => "Kelompok surat",
    '__mail_list_engine' => "Perangkat lunak milis",
    '__mail_name' => "Akun surat",
    '__mail_name_form' => "Properti akun surat",
    '__mail_names' => "Akun surat",
    '__mail_serv' => "Server surat",
    '__mail_user' => 'Pengguna surat',
    '__mailgroup' => "Kelompok surat",
    '__maillist' => "Milis",
    '__maillists' => "Milis",
    '__maillist_member' => 'Anggota milis',
    '__mailname' => "Akun surat",
    '__mailname_redir_self' => "Akun surat tidak bisa meneruskan surat ke diri sendiri.",
    '__max_dom_num_reached_for_cl' => "Batas jumlah domain untuk akun pelanggan ini telah tercapai.",
    '__max_file_size_available' => "Ukuran file maksimum yang diizinkan %1",
    '__max_subdom_num_reached_for_cl' => "Batas jumlah subdomain untuk akun pelanggan ini telah tercapai.",
    '__max_subdom_num_reached_for_dom' => "Batas jumlah subdomain untuk domain telah tercapai.",
    '__max_subdom_num_reached_for_key' => "Batas jumlah subdomain yang diizinkan oleh kunci lisensi telah tercapai.",
    '__max_traffic_limit' => "Batas lalu-lintas",
    '__maximum_excl_ip_num' => "Akun surat",
    '__mb' => "MB",
    '__mbytes' => "megabyte",
    '__mb_month' => "MB/bulan",
    '__mb_sec' => "MB/detik",
    '__gb_sec' => "GB/detik",
    '__tb_sec' => "TB/detik",
    '__mega' => "M",
    '__minute(s)' => 'Menit',
    '__mls_not_in_key' => "Kunci produk Anda tidak mendukung antarmuka multi-bahasa.",
    '__modification_date' => "Tanggal modifikasi",
    '__module' => "Ekstensi",
    '__month' => "Bulan",
    '__month(s)' => "Bulan",
    '__month1' => "Jan",
    '__month10' => "Okt",
    '__month11' => "Nov",
    '__month12' => "Des",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "April",
    '__month5' => "Mei",
    '__month6' => "Juni",
    '__month7' => "Juli",
    '__month8' => "Agu",
    '__month9' => "Sept",
    '__monthly' => "Bulanan",
    '__months' => "Bulan",
    '__moved_permanently' => 'Dipindahkan Secara Permanen',
    '__mssql' => "Server Microsoft SQL",
    '__mssql__server' => "Server",
    'mssql__server' => "Nama server Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "nama untuk server tidak dapat diubah: sedikitnya ada satu basis data di dalamnya.",
    '__mssql_status' => "Status server Microsoft SQL",
    '__multiply_login_deny' => "Anda tidak dapat masuk. Pengguna lain dengan nama pengguna yang sama (%1) sudah masuk ke Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Status server MySQL",
    '__mysql_version' => "Versi MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Status server MariaDB",
    '__mariadb_version' => "Versi MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Status server Percona",
    '__percona_version' => "Versi Percona",
    '__name' => "Nama",
    '__name_invalid' => "Nama invalid.",
    '__nameserver' => "nameserver",
    '__network' => "Jaringan",
    '__networks' => "Jaringan",
    '__no' => "Tidak",
    '__no_ip_address_with_properly_type_available' => "Tidak dapat memulihkan data yang dicadangkan karena tidak ada alamat IP yang cocok untuk pemulihan.",
    '__no_clients_specified' => "Tidak ada akun pelanggan yang ditentukan.",
    '__no_comments' => "Tidak ada komentar.",
    '__nologin' => "Terlarang",
    '__none' => "Tidak ada",
    '__not_configured' => "Tidak dikonfigurasi",
    '__not_implemented_yet' => "Belum diterapkan",
    '__not_supported_by_ftp' => "(tidak didukung oleh server FTP)",
    '__notification' => "Notifikasi",
    '__num_displayed' => "%1 dari %2 ditunjukkan",
    '__num_is_invalid' => "Jumlah invalid.",
    '__object_not_found' => 'Objek tidak ditemukan: %1',
    '__of_all' => "% dari Semua",
    '__off' => "Mati",
    '__ok' => "OK",
    '__old_passwd' => "Kata sandi %1 lama",
    '__on' => "Hidup",
    '__others' => "Lainnya",
    '__other_ip__will_be_added' => 'Alamat IP lain yang tersedia (akan ditambahkan ke kumpulan IP pelanggan)',
    '__out' => "Keluar",
    '__p' => "P",
    '__passwd' => "Kata sandi %1",
    '__passwd_is_invalid' => "Kata sandi %1 invalid.",
    '__path' => "Jalur",
    '__perl_unix_support' => "Dukungan Perl",
    '__perl_win_support' => "Dukungan Perl",
    '__perm_denied' => "Izin ditolak.",
    '__permissions' => "Izin",
    '__personal_name' => "Nama pribadi",
    '__pg_admin_not_activated' => "PostgreSQL tidak diaktifkan pada halaman administrasi server.",
    '__pg_not_inst' => "PostgreSQL tidak dipasang.",
    '__pg_not_run_or_inst' => "PostgreSQL tidak dipasang atau tidak berjalan.",
    '__pg_not_support_in_key' => "PostgreSQL tidak didukung oleh kunci lisensi.",
    '__phone' => "Telepon",
    '__phosting' => "Hosting fisik",
    '__php_support' => "Dukungan PHP",
    '__php_run_as_isapi' => "jalankan ISAPI sebagai ekstensi",
    '__php_safe_mode' => "PHP 'safe_mode' hidup",
    '__php_version' => "Versi PHP",
    '__physical' => "Hosting fisik",
    '__plesk_stat_pdir' => "Lindungi direktori '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Statistik domain",
    '__plesk_stat_protect' => "Lindungi akses ke statistik web dengan nama pengguna dan kata sandi FTP",
    '__plesk_stat_protect_install' => "bisa diakses melalui kata sandi direktori terlindung '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Status server POP3",
    '__popen_error' => "Kesalahan terjadi saat memanggil fungsi popen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Status PostgreSQL",
    '__preferences' => "Pengaturan",
    '__account_preferences' => "Pengaturan Akun",
    '__interface_preferences_general' => 'Umum',
    '__interface_preferences_default' => 'Preferensi Antarmuka Default',
    '__interface_preferences_admin' => "Preferensi Antarmuka Administrator",
    '__interface_template' => 'Antarmuka penyesuaian template',
    '__interface_preferences' => "Preferensi antarmuka",
    '__proceed?' => "Apakah Anda ingin melanjutkan?",
    '__provider_contact_name' => "Nama kontak pemilik",
    '__python_unix_support' => "Dukungan Python",
    '__python_win_support' => "Dukungan Python",
    '__quota' => "Kuota",
    '__r' => "R",
    '__reconfigure' => "Konfigurasi ulang",
    '__record_type' => "Jenis catatan",
    '__release' => "Rilis",
    '__remote_db_not_supported_by_key' => 'Hosting basis data jauh tidak didukung oleh kunci lisensi Anda.',
    '__remove_protection' => 'Hapus Perlindungan',
    '__report' => "Laporan",
    '__report_size_na' => "Layanan tidak tersedia",
    '__reports_list' => "Laporan",
    '__requested' => "Permintaan",
    '__required_fields' => "Kolom yang dibutuhkan",
    '__resp_name_invalid' => "Nama Balasan Otomatis invalid. Harap gunakan hanya simbol alfanumerik, titik, garis bawah, dan spasi.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Nama server invalid.",
    '__screenshots' => 'Tangkapan layar',
    '__script_warning' => "Dengan menghapus kemampuan menulis skrip dari domain ini, semua skrip yang terdampak akan ditampilkan di peramban dalam bentuk teks biasa. Disarankan bagi administrator untuk menghapus semua skrip dependen dari domain tersebut.",
    '__sec' => "Detik",
    '__second(s)' => "Detik",
    '__see_list_of_logged_in' => "Lihat daftar pengguna yang sedang masuk.",
    '__select_certs_to_remove' => "Pilih sertifikat yang akan dihapus.",
    '__select_files_to_remove' => "Pilih file untuk dihapus.",
    '__select_ip' => "Tunjuk alamat IP",
    '__select_ip_to_remove' => "Pilih alamat IP untuk dihapus.",
    '__select_domain_template' => "Gunakan pengaturan template domain",
    '__select_templates_to_remove' => "Pilih template untuk dihapus.",
    '__server' => "Server",
    '__server_total' => "Total Server",
    '__service' => "Layanan",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Server basis data MariaDB/MySQL",
    '__service_description__mysql' => "Server basis data MariaDB/MySQL",
    '__service_title__web' => "Server web",
    '__service_description__web' => "Server web",
    '__service_title__smtp' => "Server SMTP",
    '__service_description__smtp' => "Server SMTP",
    '__service_title__mail' => "Server IMAP/POP3",
    '__service_description__mail' => "Server IMAP/POP3",
    '__service_title__dns' => "Server DNS",
    '__service_description__dns' => "Server DNS",
    '__service_title__postgresq' => "Server basis data PostgreSQL",
    '__service_description__postgresq' => "Server basis data PostgreSQL",
    '__service_title__spamassassin' => "Layanan filter spam SpamAssassin",
    '__service_description__spamassassin' => "Layanan filter spam SpamAssassin",
    '__services' => "Layanan",
    '__all_services' => "Semua layanan",
    '__sessions' => "Sesi",
    'sessions__feature_ftp_session_manager_not_supported' => "Fitur Sesi FTP tidak didukung server FTP saat ini",
    '__sessions_list' => "Sesi",
    '__set' => "Hidupkan",
    '__shared' => "Berbagi",
    '__shell_access_warning' => "Membolehkan akses shell ke sistem akan sangat berbahaya bagi keamanan sistem. Akses sistem dibolehkan hanya jika Anda paham betul dengan apa yang Anda lakukan, dan hanya pada pengguna tepercaya. Apakah Anda yakin ingin membolehkan akses?",
    '__siteapp_not_support_in_key' => "Aplikasi web tidak didukung oleh kunci lisensi",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfigurasi aplikasi web ini diubah secara manual. Untuk melindungi modifikasi manual, konfigurasi ulang melalui Plesk ditiadakan.',
    '__site_management' => "Penerbitan Web", // indirect
    '__size' => "Ukuran",
    '__skins' => 'Skin',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Status server SMTP",
    '__some_fields_are_empty_or_invalid' => "Beberapa bidang kosong atau berisi nilai yang tidak tepat.",
    '__no_email_addresses_selected' => 'Tidak ada alamat surel yang dipilih.',
    '__unable_to_set_parameters' => "Tidak dapat mengatur parameter komponen.",
    '__spamassassin' => "Filter Spam",
    '__spamassassin_status' => "Status SpamAssassin",
    '__spamd_status' => 'Status Filter Spam',
    '__splited_backup' => "(cadangan multivolume)",
    '__split_backup_file' => "Membuat cadangan multivolume",
    '__split_backup_size' => "Ukuran volume",
    '__split_backup_less_than_500' => "Ukuran volume kurang dari 500 megabyte dan tidak didukung",
    '__ssi' => "SSI",
    '__ssi_support' => "Dukungan SSI",
    '__ssi_with_html' => "gunakan SSI untuk file *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Dukungan SSL/TLS",
    '__same_ssl' => "Gunakan direktori tunggal untuk menampung isi SSL/TLS dan non-SSL/TLS",
    '__same_ssl_cu' => "Isi SSL/TLS dan non-SSL/TLS bersama",
    '__state' => "Negara Bagian/Provinsi",

    '__status__Active' => 'Aktif',
    '__status__active' => 'aktif',
    '__status__Passive' => 'Dimatikan',
    '__status__passive' => 'dimatikan',
    '__status__off' => 'dimatikan',
    '__status__with_parent' => 'dimatikan',
    '__status__backup_restore' => 'ditangguhkan sementara untuk pencadangan atau pemulihan',
    '__status__admin' => 'ditangguhkan oleh administrator server',
    '__status__resseler' => 'ditangguhkan oleh penyalur',
    '__status__client' => 'ditangguhkan oleh pelanggan',
    '__status__unknown' => 'status tidak diketahui',

    '__status_of' => "Status %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Server stunnel", // indirect
    '__subdomain' => "Subdomain",
    '__subdomain_name' => "Nama subdomain",
    '__subdomain_name_in_ASCII_form' => "Nama subdomain dalam format ASCII",
    '__subdomains' => "Subdomain",
    '__domainaliases' => "Alias domain",
    '__subdomains_list' => "Subdomain",
    '__subdomains_not_support_in_key' => "Operasi subdomain tidak didukung oleh kunci lisensi",
    '__sys_user_type' => "Pengguna FTP",
    '__sys_user_type_main' => "Gunakan akun pengguna FTP untuk domain utama",
    '__sys_user_type_native' => "Buat akun pengguna FTP berbeda untuk subdomain ini",
    '__target_domain' => "Domain target",
    '__template' => "Template",
    '__template_not_accepted' => "Tidak dapat menerima template: telah melampaui batasan berikut.",
    '__templates' => "Template",
    '__templates_list' => "Template",
    '__tera' => "T",
    '__title' => "Judul",
    '__tools' => "Alat",
    '__total' => "Total %1",
    '__total_size' => "Ukuran total",
    '__total_used' => "Total digunakan",
    '__traffic' => "Lalu-lintas",
    '__traffic_by_client' => "Lalu-lintas oleh pelanggan",
    '__traffic_by_domain' => "Lalu-lintas oleh domain",
    '__traffic_by_service' => "Lalu-lintas oleh layanan",
    '__traffic_history' => "Riwayat lalu-lintas",
    '__unable_change_locale' => "Tidak dapat mengubah bahasa antarmuka: %1",
    '__unable_create_new_dom' => "Tidak dapat membuat domain: %1",
    '__unable_define_dom_name' => "Tidak dapat menentukan nama domain: %1",
    '__unable_define_necessary_properties' => "Tidak dapat menentukan semua properti yang diperlukan.",
    '__unable_define_properties' => "Tidak dapat menentukan properti: %1",
    '__unable_exec_util' => "Tidak dapat mengeksekusi utilitas: %1",
    '__unable_get_dns_a_recs' => "Tidak dapat menarik alamat IP untuk catatan A DNS akun hosting ini: %1",
    '__unable_get_mbox_quota' => "Tidak dapat menarik informasi batas ukuran kotak surat.",
    '__unable_redirect_to_myself' => "Tidak dapat meneruskan ke akun yang sama.",
    '__unable_redirect_to_my_alias' => "Tidak dapat meneruskan surat ke alias surat.",
    '__default_domain_redirect_to_myself' => "Tidak dapat mengatur domain sebagai default untuk alamat IP: terdeteksi pengalihan ke diri sendiri",
    '__unable_remove_client' => "Tidak dapat menghapus pelanggan: %1",
    '__unable_set_up_mbox_quota' => "Tidak dapat menetapkan batas ukuran kotak surat untuk domain: %1",
    '__unable_setup_pass' => "Tidak dapat mengatur kata sandi: %1",
    '__unable_to_create_new_account' => "Tidak dapat membuat akun: %1",
    '__unable_to_define_db_size' => "Tidak dapat menentukan ukuran basis data.",
    '__unable_to_enable_short_names' => "Tidak dapat membolehkan penggunaan nama akun surat pendek untuk akun POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Tidak dapat mengambil data yang diajukan: %1",
    '__unable_to_open_file' => "Tidak dapat membuka file %1: %2",
    '__unable_to_update_subdomain' => "Tidak dapat membuat perubahan ke subdomain: %1",
    '__unable_update_cl_data' => "Tidak dapat menyimpan perubahan ke akun pengguna: %1",
    '__unable_update_db_params' => "Tidak dapat memperbarui parameter basis data: %1",
    '__unable_update_dom_data' => "Tidak dapat memperbarui data domain: %1",
    '__undefined' => "tidak ditentukan",
    '__uninstall' => "Melepas Pemasangan",
    '__unknown_error' => "Kesalahan tidak diketahui",
    '__unlimited_lower' => "Tidak terbatas",
    '__unset' => "Matikan",
    '__update' => "Pembaruan",
    '__uploaded_file_is_invalid' => "File yang diunggah invalid: %1",
    '__url' => "URL",
    '__usage' => "Penggunaan disk",
    '__user_already_logged' => "Pengguna lain dengan nama pengguna yang sama (%1) sudah masuk ke Plesk.",
    '__version' => "Versi",
    '__aps_license' => "Kunci lisensi",
    '__vh_type' => "Jenis host virtual",
    '__vhosts_apache_status' => "Status server web",
    '__wrong_charset_conversion' => 'Charset salah, konversi dari "%1" menjadi "%2" tidak dibolehkan',
    '__warning_' => "Peringatan!",
    '__warning_excl_ip_num' => "Alamat IP khusus",
    '__warning_expiration' => "Tanggal kedaluwarsa",
    '__web_scripting' => "Pembuatan skrip web", // indirect
    '__web_serv' => "Server web", // indirect
    '__web_statistic' => "Statistik web", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer tidak terpasang di server. Hubungi penyedia layanan Anda untuk mendapatkan bantuan memasang Webalizer.",
    '__webstat_support' => "Statistik web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Ketika Anda berpindah antara program statistik, semua laporan yang dibuat oleh program statistik sebelumnya akan dihapus dan laporan baru akan dibuat sesuai dengan informasi dari file log yang tersimpan di server. Artinya, jika Anda membuat konfigurasi sistem (di Domain > Nama Domain > Pengelola Log > Rotasi Log) hanya untuk menyimpan file log bulan terakhir, maka statistik web hanya akan tersedia untuk bulan terakhir. Apakah Anda ingin berpindah ke paket statistik lainnya?",
    '__webstat_perm_denied' => 'Anda tidak memiliki izin untuk mengelola statistik web.',
    '__webuser' => "Pengguna web",
    '__sysusers_list' => "Pengguna sistem",
    '__sysuser' => "Pengguna sistem",
    '__weekly' => "Mingguan",
    '__whats_new_in_version' => "Apa yang baru di Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Operasi ini hanya tersedia untuk domain dengan hosting web.",
    '__wrong_hosting_type__none' => 'Tidak ada hosting web yang dikonfigurasi pada domain %1.',
    '__wrong_hosting_type__std_fwd' => 'Domain %1 telah memiliki konfigurasi penerusan standar. Operasi ini hanya tersedia untuk domain dengan hosting web.',
    '__wrong_hosting_type__frm_fwd' => 'Domain %1 telah memiliki konfigurasi penerusan bingkai. Operasi ini hanya tersedia untuk domain dengan hosting web.',
    '__wu' => "Pengguna web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Prefiks WWW telah diubah. Pastikan untuk mengubah sertifikat SSL/TLS yang sesuai.",
    '__year' => "Tahun",
    '__year(s)' => "Tahun",
    '__yes' => "Ya",
    '__you' => "Anda",
    '__zip_code' => "Kode Pos",
    '__form_normal' => "Normal",
    '__form_advanced' => "Lanjutan",

    'admin_ed__edit_administrator_info' => "Menyunting Profil Administrator",
    'admin_ed__create_default_client' => "Saya ingin membuat akun pelanggan default.",
    'admin_ed__unable_update' => "Tidak dapat memperbarui informasi administrator: %1",

    'auth__update_admin_info' => "Harap masukkan informasi administrator. Informasi ini dibutuhkan untuk menjalankan %1.",
    'auth__you_not_have_perm' => "Anda tidak memiliki izin untuk mengelola domain ini.",
    'auth__key_expired_admin' => 'Lisensi Plesk Anda telah kedaluwarsa. Untuk meneruskan menggunakan Plesk, perbarui lisensi Anda atau beli yang baru.',
    'auth__key_expired_admin_restricted' => 'Lisensi Plesk Anda telah kedaluwarsa. Hubungi penyedia layanan Anda untuk terus menggunakan Plesk.',
    'auth__key_expired_client' => 'Lisensi Plesk telah kedaluwarsa. Harap hubungi penyedia hosting Anda.',
    'autoinstaller__not_installed' => 'Komponen Autoinstaller tidak dipasang.',
    'autoinstaller__release_action' => 'Tindakan yang tersedia',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Tingkatkan ke versi Plesk baru',
    'autoinstaller__release_action_update' => 'Perbarui atau tambahkan komponen baru',
    'autoinstaller__release_action_up2date' => 'Anda menggunakan versi terbaru',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Tidak terpasang',
    'autoinstaller__component_action_update' => 'Pembaruan tersedia',
    'autoinstaller__component_action_upgrade' => 'Pembaruan tersedia',
    'autoinstaller__component_action_up2date' => 'Anda menggunakan versi terbaru',
    'autoinstaller__component_action_error' => 'Pembaruan tidak tersedia',
    'autoinstaller__component_serverbuildtime' => 'Rilis terbaru',
    'autoinstaller__component_localbuildtime' => 'Rilis Anda',
    'autoinstaller__component_installed_version' => 'Versi Anda',
    'autoinstaller__component_available_version' => 'Versi terbaru',
    'autoinstaller__component' => 'Komponen',
    'autoinstaller__components' => 'Komponen',
    'autoinstaller__components_title' => 'Komponen %1',
    'autoinstaller__component_dependency_note' => 'Dibutuhkan untuk memasang komponen yang Anda pilih',
    'autoinstaller__install_confirm' => 'Ya, saya akan memasang komponen ini',
    'autoinstaller__install_confirm_request' => 'Harap centang kotak pilih sebagai konfirmasi',
    'autoinstaller__install_title' => 'Konfirmasi Pemasangan Komponen Terpilih',
    'autoinstaller__key_update_confirm' => 'Konfirmasi melompati pembaruan kunci dan memasang kunci default',
    'autoinstaller__key_update_confirm_request' => 'Harap memilih kotak cek untuk konfirmasi.',
    'autoinstaller__key_update_failed' => '<p>Plesk tidak dapat memperbarui lisensi produk Anda.</p><p>%1</p><p> Meneruskan dengan peningkatan tanpa memiliki lisensi produk yang sesuai akan menghasilkan pemasangan lisensi default dengan fungsi yang terbatas. Administrator disarankan untuk mendapatkan kunci lisensi yang sesuai terlebih dahulu sebelum meneruskan dengan peningkatan produk.</p>',
    'autoinstaller__email' => 'Kirim pemberitahuan ke',
    'autoinstaller__email_admin' => "Surel administrator",
    'autoinstaller__email_email' => 'Alamat surel suai...',
    'autoinstaller__release' => 'Nama rilis',
    'autoinstaller__releases' => 'Rilis yang tersedia',
    'autoinstaller__releases_title' => 'Pembaru Plesk',
    'autoinstaller__select_components_to_install' => 'Pilih komponen yang akan Anda pasang',
    'autoinstaller__status_error' => 'Galat: %1',
    'autoinstaller__status_install_error' => 'Pemasangan tidak dapat dimulai: %1',
    'autoinstaller__status_install_busy' => 'Pemasangan tidak dapat dijalankan: Prosedur pemasangan lain sedang berjalan.',
    'autoinstaller__status_install_ok' => 'Pemasangan dijalankan. Pemberitahuan kemajuan pemasangan akan dikirimkan melalui surel (%1).',
    'autoinstaller__status_query_busy' => 'Pemasangan sedang berjalan.',
    'autoinstaller__status_query_error' => 'Tidak dapat menarik status pemasangan: %1',
    'autoinstaller__status_unknown' => 'Tidak dapat mengambil status pemasangan otomatis.',
    'autoinstaller__status_busy' => 'Autoinstaller sibuk, harap tunggu.',
    'autoinstaller__configure_title' => 'Pengaturan Pembaru',
    'autoinstaller__preferences_legend' => 'Pengaturan',
    'autoinstaller__target' => 'Direktori unduhan sementara',
    'autoinstaller__target_invalid' => "Tentukan jalur mutlak",
    'autoinstaller__check_updates' => 'Periksa pembaruan ketika administrator masuk ke Plesk',
    'autoinstaller__check_updates_warning' => 'Pembaruan <a href="%1">baru</a> tersedia untuk %2',
    'autoinstaller__source_type' => 'Tipe sumber',
    'autoinstaller__source' => 'URL sumber',
    'autoinstaller_source__preferences_legend' => 'Pengaturan',
    'autoinstaller_source__type' => 'Tipe sumber',
    'autoinstaller_source__url_invalid' => 'Sumber invalid',
    'autoinstaller_source__url_invalid_network' => 'URL sumber invalid (Contohnya: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL sumber',
    'autoinstaller__source_invalid_network' => 'Anda memasukkan alamat jaringan yang tidak valid',
    'backup__repository' => 'Lokasi penyimpanan berkas cadangan',
    'backup__error_notify_email' => 'Bila kesalahan terjadi selama pencadangan, kirimkan notifikasi melalui surel',
    'backup__dump_info' => "Informasi pencadangan",
    'backup__dump_file_name_not_defined' => "Nama file cadangan belum ditetapkan",
    'backup__local_file' => 'File cadangan lokal',
    'backup__domain_ftp' => 'Server FTP jarak jauh',
    'backup__wrong_path' => "Jalur yang salah menuju ke penyimpanan berkas cadangan: Jangan menggunakan urutan karakter ../../",
    'backup__unable_to_connect_to_ftp_server' => "Tidak dapat tersambung ke server FTP: %1",
    'backup__unable_to_read_file' => 'Tidak dapat membaca file cadangan.',
    'backup__backup_task_does_not_exist' => "Tugas pencadangan tidak ada, Anda harus membuatnya terlebih dahulu sebelum menghidupkan.",
    'backup__restore_params' => "Parameter pemulihan",
    'backup__confirmation' => "Peringatan: domain tidak akan tersedia selama backup/pemulihan.",
    'backup__backup_method' => 'Metode pencadangan',
    'backup__dumpfile_name' => "Nama file cadangan",
    'backup__dumpfile_name_is_invalid' => "Nama file cadangan tidak valid: Gunakan hanya alfanumerik, tanda penghubung, titik, simbol garis bawah, jangan menggunakan nama seperti deskripsi.* sebagai nama file cadangan.",
    'backup__email_required' => "Alamat surel Anda diperlukan untuk menjaga agar Anda mendapatkan informasi mengenai kemajuan pencadangan dan pemulihan. Harap tentukan surel Anda di detail akun.",
    'backup__error_during_backup' => "Tidak dapat membuat file cadangan: %1",
    'backup__input_email_warning' => "Anda harus memberikan surel untuk pengiriman notifikasi atau biarkan kotak pilih kosong.",
    'backup__make_download' => "tidak menyimpan berkas cadangan dalam penyimpanan, hanya mengunduhnya",
    'backup__make_dump' => 'buat berkas cadangan dan simpan dalam penyimpanan lokal',
    'backup__makedump_to_ftp' => 'buat file cadangan dan simpan di server FTP jauh',
    'backup__restore_ip' => "Alamat IP yang akan dipulihkan",
    'backup__select_dumpfile' => "Pilih file cadangan.",
    'backup__time' => "Waktu pencadangan",
    'backup__day' => 'Hari pencadangan',
    'backup__view_dump_info' => "Lihat informasi pencadangan untuk domain %1",
    'backup__wrong_domain_name' => "Terdapat file domain %1 pada file cadangan sehingga tidak dapat dipulihkan di domain %2",
    'backup__incorrect_ftp_user_or_passwd' => "Nama pengguna atau kata sandi FTP salah. Harap perbaiki Properti Akun FTP",
    'backup__access_denied' => "Akses ditolak. Harap perbaiki Properti Akun FTP",
    'backup__restore_from' => "Pulihkan %1",
    'backup__domain_session_failed' => 'Domain %1 tidak dicadangkan',
    'backup__client_session_failed' => 'Pelanggan %1 tidak dicadangkan',
    'backup__domain_session_restore_failed' => 'Domain %1 tidak dipulihkan',
    'backup__client_session_restore_failed' => 'Akun Pelanggan %1 tidak dipulihkan.',
    'backup__domain_session_complete' => 'Domain %1 dicadangkan',
    'backup__domain_session_backup' => 'Cadangkan domain %1',
    'backup__client_session_backup' => 'Cadangkan pelanggan %1',
    'backup__domain_stop_title' => 'Membatalkan pencadangan domain %1',
    'backup__client_stop_title' => 'Membatalkan pencadangan akun pelanggan %1',
    'backup__domain_restore_stop_title' => 'Membatalkan pemulihan domain %1',
    'backup__client_restore_stop_title' => 'Membatalkan pemulihan akun pelanggan %1',
    'backup__domain_session_backup_stop' => 'Anda hendak membatalkan proses pencadangan yang aktif. File cadangan tidak akan dibuat.',
    'backup__backup_stop_confirm' => 'Ya, saya ingin menghentikan proses pencadangan',
    'backup__restore_stop_confirm' => 'Ya, saya ingin menghentikan proses pemulihan',
    'backup__domain_session_restore' => 'Pemulihan domain %1',
    'backup__domain_session_restore_stop' => 'Anda hendak membatalkan proses pemulihan yang aktif.',
    'backup__domain_backup_file_info' => 'Informasi File Cadangan Domain',
    'backup__domain_backup_file_list' => 'file cadangan yang ada',
    'backup__domain_backup_progress' => 'Kemajuan pencadangan situs web %1',
    'backup__domain_restore_progress' => 'Kemajuan pemulihan situs web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Waktu berjalan: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Waktu berjalan: %1',
    'backup__domain_restore_session_complete' => 'Domain %1 dipulihkan.',
    'backup__domain_restore_session_complete_message' => 'Domain %1 telah dipulihkan.',
    'backup__domain_backup_file_delete' => 'File cadangan berikut akan dihapus:',
    'backup__domain_backup_file_for_remove' => 'Pilih file cadangan yang ingin Anda hapus',
    'backup__backup_overwrite_file_confirm' => 'Konfirmasi penggantian',
    'backup__backup_overwrite_file_confirm_text' => 'File cadangan dengan nama "%1" telah ada. Apakah Anda ingin menggantinya?',
    'backup__backup_confirm_overwrite' => 'Konfirmasi penggantian file',
    'backup__backup_overwrite_legeng' => 'Ganti',
    'backup__backup_not_contain_domain' => 'File cadangan tidak berisi informasi mengenai domain %1',
    'backup__backup_not_contain_client' => 'File cadangan tidak berisi informasi mengenai akun pelanggan %1',
    'backup__backup_client_info' => "Pengaturan pencadangan pelanggan dan detail akun",
    'backup__client_backup_progress' => 'Kemajuan Pencadangan Akun Pelanggan %1',
    'backup__client_session_complete' => 'Akun Pelanggan %1 dicadangkan',
    'backup__client_backup_file_info' => 'Informasi File Cadangan Pelanggan',
    'backup__restore_client_info' => "Pulihkan pengaturan pelanggan dan detail akun",
    'backup__client_session_restore' => 'Memulihkan Akun Pelanggan %1',
    'backup__client_db_server_map' => 'Pemetaan Server Basis data',
    'backup__domain_db_server_map' => 'Pemetaan Server Basis data',
    'backup__client_restore_session_complete_message' => 'Akun Pelanggan %1 dipulihkan.',
    'backup__client_restore_session_complete' => 'Akun Pelanggan %1 dipulihkan.',
    'backup__restore_select_some' => 'Harap memilih objek yang ingin Anda pulihkan.',
    'backup__client_restore_progress' => 'Kemajuan Pemulihan untuk Akun Pelanggan %1',
    'backup__new_backup' => 'Membuat Cadangan Baru',
    'backup__done' => 'Selesai:',
    'backup__done_domains' => '%1 domain dari %2',
    'backup__done_clients' => '%1 pelanggan dari %2',
    'backup__remaining' => 'Sisa:',
    'backup__remaining_domains' => '%1 domain',
    'backup__remaining_clients' => '%1 pelanggan',
    'backup__overall_backup_progress' => 'Kemajuan pencadangan keseluruhan',
    'backup__comment_n_a' => 'tidak ada',
    'backup__command_ignore' => 'Perintah "%1" diabaikan',
    'backup__no_objects' => 'tidak ada objek untuk dicadangkan',
    'backup__cli_warning_not_enough_ip' => 'PERINGATAN: alamat IP tidak cukup untuk menjalankan pemetaan IP default:',
    'backup__local_repository' => "Penyimpanan Plesk",
    'backup__ftp_repository' => 'Penyimpanan FTP',
    'backup__ftp_login' => 'Nama pengguna',
    'backup__ftp_password' => 'Kata sandi',
    'backup__ftp_account_settings' => 'Pengaturan Akun FTP',
    'backup__ftp_account_preferences' => 'Pengaturan akun FTP',
    'backup__repository_not_exist' => 'Direktori tidak ada',
    'backup__repository_not_readable' => 'Direktori yang ditentukan tidak terbaca',
    'backup__ftp_repository_not_configure' => 'Untuk menggunakan penyimpanan cadangan FTP, <a href="%1">tentukan akun FTP-nya</a> terlebih dulu.',
    'backup__ftp_repository_list_not_configure' => 'Pengaturan akun tidak ditentukan',
    'backup__repository_list_unable_listing' => 'Tidak dapat memulihkan daftar file',
    'backup__ftp_repository_unable_listing' => 'Tidak dapat memulihkan daftar direktori "%1":',
    'backup__repository_legend' => 'Penyimpanan berkas cadangan',
    'backup__store_in_repository' => 'Simpan file di',
    'backup__local_repository_lable' => 'Penyimpanan lokal',
    'backup__ftp_repository_lable' => 'Penyimpanan FTP',
    'backup__ftp_repository_not_configure_hint' => '(pengaturan akun tidak ditentukan)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(Akun FTP tidak ditentukan atau tidak didukung)',
    'backup__other_user_process_modified' => 'Pengguna lain telah menghentikan proses pencadangan atau perpindahan.',
    'backup__another_user_exist' => 'Operasi yang berlangsung dimulai oleh pengguna Plesk yang lain. Pengguna ini masih masuk di Plesk.',
    'backup__ftp_repository_wait' => 'Harap menunggu sementara informasi tentang penyimpanan FTP diambil',
    'backup__ftp_write_test_failed' => 'Gagal menulis data uji ke akun FTP %1:',
    'backup__ftp_storage' => 'Penyimpanan FTP(S)',
    'bt_upload_to_repository' => 'Unggah Berkas ke Penyimpanan Lokal',
    'bt_new_restore' => "Pulihkan",
    'bt_backup_schedule' => "Jadwal Pencadangan",
    'backup_exist_backups' => "File cadangan yang ada",
    'backup_dialog__page_title' => "Pembuatan file cadangan",
    'backup_dialog__please_wait' => "Proses pencadangan akan dimulai. Operasi ini akan membutuhkan beberapa saat. Harap tunggu...",
    'backup_conf__page_title' => 'Konfigurasi Pencadangan',
    'bt_accept' => "Terima",
    'bt_access' => "Akses",
    'bt_action_log' => "Log Tindakan",
    'bt_add' => "Tambah",
    'bt_add_client' => "Tunjuk kepada Pengguna",
    'bt_database_server_add' => 'Tambah Server Basis Data',
    'bt_add_services' => "Tambah Layanan",
    'bt_anonftp_stats' => "Stat FTP Anon.",
    'bt_anonymous_ftp' => "FTP Anonim",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Lampirkan",
    'bt_autoinstaller' => 'Pembaru',
    'bt_auto-updates' => 'Pembaru',
    'bt_back' => "<< Kembali",
    'bt_backup' => "Cadangan",
    'bt_backup_configure' => "Pengaturan Pencadangan",
    'bt_buy_certs' => "Beli Sertifikat",
    'bt_card' => "Kartu",
    'bt_cert' => "Sertifikat",
    'bt_certificates' => "Sertifikat",
    'bt_change_passwd' => "Ubah Kata Sandi",
    'bt_clear' => "Bersihkan",
    'bt_client_templates' => "Template Pelanggan",
    'bt_clients' => "Pelanggan",
    'bt_codepage_change' => 'Ubah Pengodean',
    'bt_comp_info' => "Pengelolaan Komponen",
    'bt_configure_maillists' => "Atur Mailman",
    'bt_configure' => 'Konfigurasi',
    'bt_copy' => "Salin",
    'bt_copy_move' => "Salin/Pindah",
    'bt_create' => "Buat",
    'bt_create_account' => "Buat Akun",
    'bt_create_dir' => "Tambah Direktori",
    'bt_create_file' => "Tambah File",
    'bt_count_size' => "Hitung Ukuran",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Penjadwal Tugas",
    'bt_custom_button_new' => "Tambah Tombol",
    'bt_custom_buttons' => "Tombol Suai",
    'bt_customize' => "Ubah suaikan",
    'bt_databases' => "Basis data",
    'bt_database_servers' => 'Server Basis Data',
    'bt_sqlservers' => "Server Basis Data",
    'bt_db_usr_new' => "Tambah Pengguna Basis Data",
    'bt_db_new' => "Tambah Basis Data",
    'bt_db_phpmyadmin' => "Admin MySQL",
    'bt_dbuser_default' => "Buat Default untuk Webadmin DB",
    'bt_decline' => "Tolak",
    'bt_default' => "Default",
    'bt_defaultcomponents' => "Layanan Pihak Ketiga",
    'bt_defaults' => "Default",
    'bt_delete' => "Hapus",
    'bt_directories' => "Direktori Terlindung",
    'bt_disable' => "Matikan",
    'bt_dns_zone_sync' => 'Terapkan Perubahan Template DNS',
    'bt_dnsrecord_add' => 'Tambah Catatan',
    'bt_do_backup' => "Cadangan",
    'bt_do_restore' => "Pulihkan",
    'bt_do_upload' => "Unggah",
    'bt_domain_aliases' => "Alias Domain",
    'bt_domain_templates' => "Template Domain",
    'bt_domain_user' => "Administrator Domain",
    'bt_domain_user_passwd' => "Kata Sandi Administrator Domain",
    'bt_domains' => "Domain",
    'bt_domain_alias_add' => 'Tambah Alias Domain',
    'bt_download' => "Unduh",
    'bt_edit' => "Sunting",
    'bt_enable' => "Hidupkan",
    'bt_export' => 'Ekspor',
    'bt_extras' => "Ekstra",
    'bt_finish' => "Selesai",
    'bt_ftp_account' => "Properti Akun FTP",
    'bt_forget_password' => "Lupa Kata Sandi?",
    'bt_fp_ssl_webadmin' => "Webadmin FP-SSL/TLS",
    'bt_fp_webadmin' => "Webadmin FP",
    'bt_ftp_stats' => "Statistik FTP",
    'bt_get_password' => "Dapatkan Kata Sandi",
    'bt_global_changes' => "Modifikasi",
    'bt_help' => "Bantuan",
    'bt_hide_aliases' => "Sembunyikan Alias",
    'bt_hide_toolbar' => 'Sembunyikan toolbar',
    'bt_hide_subdomains' => "Sembunyikan Subdomain",
    'bt_hide_domainaliases' => "Sembunyikan Alias Domain",
    'bt_home' => "Beranda",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Pasang",
    'bt_ip_aliasing' => "Alamat IP",
    'bt_ip_add' => "Tambah Alamat IP",
    'bt_ip_pool' => "Kumpulan IP",
    'bt_key_info' => "Informasi Lisensi",
    'bt_key_buyonline_addons' => 'Pesan Add-On Plesk',
    'bt_key_buyonline_upgrades' => 'Pesan Pembaruan Plesk',
    'bt_key_buyonline_new' => 'Pesan Kunci Baru',
    'bt_limits' => "Batas",
    'bt_locale_add' => 'Tambah Bahasa Lokal',
    'bt_locales' => 'Bahasa lokal',
    'bt_log_manager' => "Pengelola Log",
    'bt_login' => "Log Masuk",
    'bt_logo' => "Merek",
    'bt_logo_send_link' => "Lampirkan Tautan",
    'bt_logo_send_logo' => "Lampirkan Logo",
    'bt_logout' => "Log Keluar",
    'bt_logrotation' => "Rotasi Log",
    'bt_mail' => "Surat",
    'bt_mail_alias_add' => "Tambah Alias Surat",
    'bt_mail_aliases' => "Alias Surat",
    'bt_mail_group_add' => "Tambah Anggota",
    'bt_mail_groups' => "Kelompok",
    'bt_mail_name_add' => "Tambah Akun Surat",
    'bt_mail_preferences' => "Pengaturan",
    'bt_mail_group' => "Kelompok Surat",
    'bt_mail_mailbox' => "Kotak surat",
    'bt_mail_redirect' => "Penerus",
    'bt_mail_resp_add' => "Tambah Balasan Otomatis",
    'bt_mail_resp_attach_add' => "Tambah Lampiran",
    'bt_mail_resp_files' => "File Lampiran",
    'bt_mail_responders' => "Balasan otomatis",
    'bt_mail_spamfilter' => "Filter Spam",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Tambah Milis",
    'bt_maillists' => "Milis",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Buat Cadangan",
    'bt_manage' => "Kelola",
    'bt_master' => "Master",
    'bt_migrate' => 'Pindahkan',
    'bt_modules_add' => 'Tambah Ekstensi',
    'bt_modules_manage' => 'Kelola Ekstensi',
    'bt_move' => "Pindahkan",
    'bt_new_client' => "Tambah Akun Pelanggan",
    'bt_new_domain' => "Tambah Domain",
    'bt_next' => "Berikutnya >>",
    'bt_next_page' => "Berikutnya",
    'bt_network_add' => "Tambah Jaringan",
    'bt_notifications' => "Notifikasi",
    'bt_off' => "Mati",
    'bt_on' => "Hidup",
    'bt_on_off' => "Hidup/Mati",
    'bt_performance' => 'Kinerja',
    'bt_permissions' => "Izin",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Pengaturan",
    'bt_prev_page' => "Sebelumnya",
    'bt_preview' => 'Pratinjau Situs',
    'bt_print' => "Cetak",
    'bt_reboot' => "Boot ulang",
    'bt_reload' => "Muat ulang",
    'bt_refresh' => "Segarkan",
    'bt_register' => "Daftarkan",
    'bt_remove' => "Hapus",
    'bt_enable_selected' => 'Hidupkan',
    'bt_disable_selected' => 'Matikan',
    'bt_repair_ip' => "Perbaiki IP",
    'bt_report' => "Laporan",
    'bt_report_new' => "Tambah Tata Letak",
    'bt_reset' => "Atur ulang",
    'bt_restart_services' => "Pengelolaan Layanan",
    'bt_save' => "Simpan",
    'bt_send_by_email' => "Kirim Melalui Surel",
    'bt_send_file' => "Kirim File",
    'bt_send_mail' => "Kirim Surat",
    'bt_send_passwd' => "Kirim Kata Sandi",
    'bt_send_text' => "Kirim Teks",
    'bt_server' => "Server",
    'bt_server_add' => "Tambah Server",
    'bt_server_preferences' => "Pengaturan Server",
    'bt_servers_list' => "Server",
    'bt_sessions' => "Sesi",
    'bt_set' => "Atur",
    'bt_set_as_default' => "Tetapkan Sebagai Default",
    'bt_setup' => 'Penataan',
    'bt_show_aliases' => "Tunjukkan Alias",
    'bt_show_subdomains' => "Tunjukkan Subdomain",
    'bt_show_domainaliases' => "Tunjukkan Alias Domain",
    'bt_shutdown' => "Matikan",
    'bt_site_apppkgs' => "Brankas Aplikasi",
    'bt_site_apppool' => "Kumpulan Aplikasi",
    'bt_application-pool' => "Aplikasi Web",
    'bt_site_apps' => "Aplikasi Web",
    'bt_site_app_add' => "Pasang Aplikasi",
    'bt_site_builder' => "Dukungan Presence Builder",
    'bt_skeleton' => 'Template Host Virtual',
    'bt_skins' => 'Skin',
    'bt_skin_add' => 'Tambah Skin',
    'bt_skin_manual' => 'Referensi Skin Plesk Suai', // not used
    'bt_skin_download' => 'Unduh Skin',
    'bt_skin_replace' => 'Perbarui Skin',
    'bt_skip' => 'Lompati',
    'bt_spamassassin' => "Filter Spam",
    'bt_spamassassin_train' => "Pelatihan",
    'bt_spamfilter' => "Filter Spam",
    'bt_start' => "Mulai",
    'bt_stop' => "Berhenti",
    'bt_recycle' => "Daur ulang",
    'bt_statistics' => "Statistik",
    'bt_subdomain_new' => "Tambah Subdomain",
    'bt_subdomains' => "Subdomain",
    'bt_submit' => "Ajukan",
    'bt_summary_report' => "Laporan Ringkas",
    'bt_support' => "Dukungan",
    'bt_switch' => "Ganti",
    'bt_system_time' => "Waktu Sistem",
    'bt_task_new' => "Tambah Tugas",
    'bt_dom_tmpl_add' => 'Tambah Template Domain',
    'bt_cl_tmpl_add' => 'Tambah Template Pelanggan',
    'bt_cron_backup' => 'Pengaturan Pencadangan Terjadwal',
    'bt_test' => "Uji Koneksi",
    'bt_text' => "Teks",
    'bt_touch' => "Ubah Cap-waktu",
    'bt_traffic' => "Lalu-lintas",
    'bt_traffic_history' => "Riwayat Lalu-Lintas",
    'bt_update' => "Pembaruan",
    'bt_upload' => "Unggah",
    'bt_upload_from_ftp' => "Unggah FTP",
    'bt_virtualdirs' => 'Direktori Virtual',
    'bt_virtualdir_new' => 'Tambah Direktori Virtual',
    'bt_virtualdir_add' => 'Tambah Direktori Virtual',
    'bt_web_app_new' => "Pasang Aplikasi Java",
    'bt_web_stats' => "Statistik Web",
    'bt_web_stats_ssl' => "SSL/TLS Statistik Web",
    'bt_web_user_add' => "Tambah Pengguna Web",
    'bt_web_users' => "Pengguna Web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Lihat daftar lengkap perubahan",
    'cert_add__unable_set_ca_cert' => "Tidak dapat mengatur sertifikat CA: %1",
    'cert_add__unable_set_cert' => "Tidak dapat mengatur sertifikat: %1",
    'cert_add__unable_set_private_key' => "Tidak dapat mengatur kunci pribadi: %1",
    'certificates_list__certificate_used_as_default' => "Salah satu sertifikat yang akan Anda hapus digunakan sebagai Sertifikat Default.",
    'certificates_list__certificates_assigned_on_ip' => "Satu atau beberapa sertifikat telah ditetapkan untuk alamat IP/domain.",
    'ch_pass__admin_pass' => "Mengubah Kata Sandi Administrator",
    'ch_pass__old_pass' => "Kata sandi lama",
    'ch_pass__pass_confirm' => "Konfirmasi",
    'ch_pass__unable_change_admin_pass' => "Tidak dapat mengubah kata sandi administrator: %1",
    'check_mail_cycle__aliases' => "Siklus surat terdeteksi, alamat \"%1\" terdapat di dalam alias dari akun surat ini.",
    'check_mail_cycle__autoresponders' => "Siklus surat terdeteksi, alamat \"%1\" terdapat di balasan otomatis dari akun surat ini.",
    'check_mail_cycle__mail_groups' => "Siklus surat terdeteksi, alamat \"%1\" terdapat di dalam kelompok surat dari akun surat ini.",
    'check_mail_cycle__mail_name' => "Siklus surat terdeteksi, alamat \"%1\" serupa dengan akun surat ini.",
    'check_mail_cycle__redirect' => "Siklus surat terdeteksi, alamat \"%1\" serupa dengan penerus dari akun surat ini.",
    'check_mail_dup__redirect' => "Penerusan duplikat terdeteksi, alamat \"%1\" serupa dengan alamat pengirim dari akun surat ini.",
    'check_mail_dup__mail_groups' => "Penerusan duplikat terdeteksi, alamat \"%1\" terdapat di dalam kelompok surat dari akun surat ini.",
    'check_maillist_cycle__admin' => "Siklus surat terdeteksi, surel administrator \"%1\" serupa dengan alamat milis.",
    'check_maillist_cycle__member' => "Siklus surat terdeteksi, alamat \"%1\" serupa dengan alamat milis.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detail akun %1",
    'cl_limits__cl' => "Batas pelanggan %1",
    'cl_logo__setup_logo_pref' => "Atur properti logo untuk pelanggan %1",
    'cl_new__enter_new_cl_data' => "Masukkan informasi ke pelanggan baru",
    'cl_new__unable_to_sent_notification' => 'Akun pengguna telah dibuat, namun, gagal mengirimkan pemberitahuan ke pelanggan: %1',
    'cl_perm__all_ip' => "Semua IP yang tersedia",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Semua akun hosting berbasis-IP untuk pelanggan akan ditransfer ke berbasis-Nama.",
    'cl_perm__allow_client_create_domain' => "Bidang yang coba Anda pilih hanya berlaku ke pelanggan yang diperkenankan untuk membuat domain.",
    'cl_perm__allow_create_nb_w_ip' => "Pelanggan dapat membuat hosting berbasis-nama menggunakan %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Perkenankan pembuatan akun hosting berbasis-IP",
    'cl_perm__available_ips' => "IP yang tersedia",
    'cl_perm__change_limits' => "Penyesuaian batas",
    'cl_perm__cl_disk_space' => "Total ruang disk yang tersedia",
    'cl_perm__cl_expiration' => "Periode validitas akun pelanggan",
    'cl_perm__cl_max_box' => "Kotak surat",
    'cl_perm__cl_max_db' => "Basis data",
    'cl_perm__cl_max_dom' => "Domain",
    'cl_perm__cl_max_maillists' => "Milis",
    'cl_perm__cl_max_subdom' => "Subdomain",
    'cl_perm__cl_max_traffic' => "Jumlah lalu-lintas total yang tersedia",
    'cl_perm__cl_max_wu' => "Pengguna web",
    'cl_perm__cl_mbox_quota' => "Batas ukuran kotak surat untuk akun pengguna ini",
    'cl_perm__current_maximum_exp_date' => "Nilai maksimum periode validitas domain sekarang adalah %1; yang diminta %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Batas jumlah ruang disk yang saat ini dialokasikan untuk menyimpan kotak surat dibawah akun pengguna ini adalah %1; dibutuhkan %2.",
    'cl_perm__current_total_requested' => "Nilai total batas domain sekarang untuk %1 adalah %2; yang diminta %3.",
    'cl_perm__current_total_requested_dom' => "Jumlah %1 yang dimiliki oleh pelanggan ini sekarang adalah %2; yang diminta %3.",
    'cl_perm__disk_space' => "Jumlah ruang disk maksimum",
    'cl_perm__dashboard_stdgui' => 'Antarmuka pengguna',
    'cl_perm__dashboard' => 'Tampilan halaman beranda',
    'cl_perm__stdgui' => 'Tampilan standar',
    'cl_perm__manage_dashboard' => 'Pengelolaan halaman beranda',
    'cl_perm__dashboard_and_stdgui' => 'Tampilan halaman beranda dan tampilan standar diperkenankan',
    'cl_perm__dashboard_only' => 'Hanya tampilan halaman Beranda yang diperkenankan',
    'cl_perm__stdgui_only' => 'Hanya tampilan standar yang diperkenankan',
    'cl_perm__edit_cl' => "Izin pelanggan %1",
    'cl_perm__exp_date_exceeded' => "Periode validitas yang sedang coba Anda tetapkan melebihi batas yang ditentukan dalam domain individual yang berhubungan dengan pelanggan ini.",
    'cl_perm__invalid_value' => "Nilai salah, hanya angka yang diperkenankan.",
    'cl_perm__limit_disk_space' => "%1 Batas jumlah total ruang disk",
    'cl_perm__limit_expiration' => "%1 Batas periode validitas untuk akun pelanggan",
    'cl_perm__limit_max_box' => "%1 Batas jumlah maksimum kotak surat",
    'cl_perm__limit_max_db' => "%1 Batas jumlah maksimum basis data",
    'cl_perm__limit_max_dom' => "%1 Batas jumlah maksimum domain",
    'cl_perm__limit_max_maillists' => "%1 Batas jumlah maksimum milis",
    'cl_perm__limit_max_subdom' => "%1 Batas jumlah maksimum subdomain",
    'cl_perm__limit_max_traffic' => "%1 Batas jumlah total lalu-lintas",
    'cl_perm__limit_max_wu' => "%1 Batas jumlah maksimum pengguna web",
    'cl_perm__limit_mbox_quota' => "%1 Set kuota kotak surat",
    'cl_perm__limits_exceeded' => "Satu atau beberapa batas yang coba Anda tetapkan sudah dilampaui oleh batas yang ditentukan dalam domain individual yang dimiliki oleh pelanggan ini.\nBatas total untuk pelanggan harus lebih atau sama dengan jumlah total batas domain yang ditentukan untuk akun pelanggan ini.",
    'cl_perm__mailbox_quota_exceeded' => "Batas jumlah ruang disk yang dialokasikan untuk kotak surat yang coba Anda tetapkan melebihi batas yang ditentukan dalam domain individual yang berhubungan dengan akun pelanggan ini.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Batas jumlah ruang disk yang dialokasikan untuk kotak surat yang coba Anda set melebihi batas yang diterapkan di level server.",
    'cl_perm__make_dumps' => "Pencadangan dan pemulihan data",

    'cl_perm__max_box' => "Jumlah kotak surat maksimum",
    'cl_perm__max_db' => "Jumlah basis data maksimum",
    'cl_perm__max_dom' => "domain",
    'cl_perm__max_maillists' => "Jumlah milis maksimum",
    'cl_perm__max_subdom' => "Subdomain",
    'cl_perm__max_traffic' => "Jumlah lalu-lintas maksimum",
    'cl_perm__max_wu' => "Jumlah pengguna web maksimum",
    'cl_perm__max_dom_aliases' => "alias domain",
    'cl_perm__mbox_quota' => "kuota kotak surat",
    'cl_perm__not_allow_create_nb_hst' => "Pelanggan tidak dapat membuat hosting berbasis-Nama.",
    'cl_perm__this_ip_used_vrt_hst' => "Alamat IP ini digunakan oleh hosting virtual.\nUntuk menghapus alamat IP ini, hapus layanan hosting atau ubah jenisnya ke berbasis-Nama.",
    'cl_perm__unable_off_ipb_creating' => "Pelanggan telah memiliki tata layanan hosting berbasis-IP. Untuk menonaktifkan fitur ini untuk pelanggan, bersihkan kotak cek \"pembuatan Domain\" atau hapus semua akun hosting berbasis-IP.",
    'cl_perm__unable_off_nb_creating' => "Pelanggan telah memiliki setelan layanan hosting berbasis-Nama. Untuk menonaktifkan fitur ini untuk pelanggan, bersihkan kotak cek \"pembuatan Domain\" atau hapus semua akun hosting berbasis-Nama.",
    'cl_perm__unable_set_domain_limit' => "Tidak dapat membatasi jumlah domain maksimum: pelanggan telah memiliki %1 domain",
    'cl_perm__unable_update_client_limitations' => "Tidak dapat memodifikasi batas akun pelanggan: %1",
    'cl_pref__edit_cl' => "Preferensi pelanggan %1",
    'class_anonftp__create_ftp_domain' => "Tidak ada domain FTP virtual untuk dom_id ini, coba buat terlebih dahulu.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Batas ruang disk yang coba Anda tetapkan (%1) sebaiknya tidak melebihi batas ruang disk total yang ditentukan di level domain (%2).",
    'class_anonftp__invalid_input_only_digits' => "Nilai tidak valid ditentukan, hanya angka yang diperkenankan.",
    'class_anonftp__unable_change_ownerships' => "Tidak dapat mengubah kepemilikan atau izin untuk file kuota: %1",
    'class_anonftp__unable_copy_quota_file' => "Tidak dapat menyalin file kuota: %1",
    'class_anonftp__unable_get_disk_usage' => "Tidak dapat memulihkan informasi penggunaan disk di direktori masuk: %1",
    'class_anonftp__unable_parse_quota_file' => "Tidak dapat menguraikan file kuota.",
    'class_anonftp__unable_read_quota_file' => "Tidak dapat membaca file kuota: %1",
    'class_anonftp__unable_update_quota' => "Tidak dapat memperbarui kuota: file di direktori masuk menggunakan %1 KB di ruang disk, yang melebihi nilai kuota baru.",
    'class_anonftp__unable_write_temp_file' => "Tidak dapat menulis di file sementara: %1",
    'class_bsdomain__warn_max_date__' => "Tanggal kedaluwarsa ditetapkan menjadi %1",
    'class_cList__empty' => "Tidak ada item.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Tidak ditemukan kecocokan untuk <b>\"%1\"</b> pada %2 (%3 dari %4).",
    'class_cList__search_result' => "Hasil pencarian untuk <b>\"%1\"</b> pada %2 (%3 dari %4).",
    'class_client__client_creation_notification' => "Pemberitahuan pembuatan pelanggan.",
    'class_client__client_with_contact_name_already_exists' => "Pelanggan dengan nama %1 sudah ada.",
    'class_client__disk_space' => "Ruang disk",
    'class_client__invalid_max_dom' => "Nilai jumlah domain tidak valid, hanya angka yang diperkenankan.",
    'class_client__limit_exceed' => "Jumlah %1 yang diminta tidak dapat dialokasikan karena akan melampaui jatah untuk akun pelanggan %2 (%3). Bila Anda ingin mengalokasikan lebih banyak sumber daya, silakan ke Pelanggan > nama pelanggan > Batas dan ubah jatah sesuai permintaan. Kemudian kembali lagi ke layar ini dan coba sesuaikan jatah lagi.",
    'class_client__limit_exceed_unlimited' => "Bila Anda ingin mengalokasikan jumlah sumber tak terbatas (%1), pertama Anda harus ke Pelanggan > nama pelanggan > Batas, dan pilih kotak cek Tak Terbatas yang berhubungan dengan jenis sumber yang diminta. Kemudian kembali lagi ke layar ini dan coba sesuaikan jatah lagi.",
    'class_client__max_box' => "Kotak surat",
    'class_client__max_db' => "Basis data",
    'class_client__max_maillists' => "Milis",
    'class_client__max_subdom' => "Subdomain",
    'class_client__max_traffic' => "Lalu-lintas maksimum",
    'class_client__max_wu' => "Pengguna web",
    'class_client__max_dom_aliases' => "Alias domain",
    'class_client__mbox_quota' => "Kuota kotak surat",
    'class_client__unable_define_cl_status' => "Tidak dapat menentukan status akun pelanggan: %1",
    'class_client__unable_define_inactive_dom' => "Tidak dapat menentukan domain tidak aktif %1",
    'class_client__unable_del_ip' => "Tidak dapat menghapus IP: %1",
    'class_db__db_name_not_set' => "Nama basis data tidak ditentukan.",
    'class_db__db_not_exist_for_curr_dom' => "Basis data tidak ada di domain ini.",
    'class_db__invalid_db_or_dom_name' => "Domain atau ID basis data tidak valid atau nama basis data tidak ditentukan.",
    'class_db__invalid_pass' => "Kata sandi tidak valid.",
    'class_db__mailgrp_member_exist' => "Anggota kelompok surat sudah ada.",
    'class_db__access_hosts_notsupport' => 'Pengaturan akses host tidak didukung untuk jenis basis data ini',
    'class_db__unable_add' => 'Tidak dapat menambah catatan akses host: %1',
    'class_db__unable_del' => 'Tidak dapat menghapus rekaman akses host: %1',
    'class_db__inc_user_not_exist' => 'Pengguna basis data "%1" tidak ada',
    'class_db__inc_access_record_exist' => 'Catatan akses ini sudah ada',
    'class_db__inc_access_record_not_exist' => 'Catatan akses yang diberikan tidak ada',
    'class_db__inc_unable_del_last_record' => 'Tidak dapat menghapus catatan akses host terakhir',
    'class_domtmpleditform__dns_master' => "Utama",
    'class_domtmpleditform__dns_slave' => "Sekunder",
    'class_domtmpleditform__dns_type' => "Jenis domain zona DNS",
    'clienttrafficlist_header' => "Lalu-lintas di domain",
    'clienttrafficlist_header_of_client__' => "Lalu-lintas di domain pelanggan %1",
    'cmd_dns__a_dns_record_already_exist' => "Catatan ini akan berkonflik dengan catatan A untuk zona tersebut.",
    'cmd_dns__domain_last_ns' => 'Tidak dapat menghapus catatan DNS NS terakhir untuk domain.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Nama domain kanonis tidak valid.",
    'cmd_dns__cname_dns_record_already_exist' => "Catatan ini akan berkonflik dengan catatan CNAME untuk zona tersebut.",
    'cmd_dns__cname_in_rr_combination' => 'Terdapat kombinasi catatan DNS yang salah di zona DNS',
    'cmd_dns__cname_coexist_with_data' => 'Catatan zona CNAME DNS tidak dapat berdampingan dengan catatan DNS lain di zona yang sama.',
    'cmd_dns__dns_record_type_is_invalid' => "Jenis catatan DNS tidak valid.",
    'cmd_dns__ext_host_is_not_resolved' => "Nama kanonis %1 tidak terurai ke rekaman data A atau AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Tidak dapat menambah catatan %1 ke zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Nama penukar surat tidak valid.",
    'cmd_dns__mx_priority_is_invalid' => "Prioritas MX tidak valid.",
    'cmd_dns__name_server_is_invalid' => "Server nama tidak valid.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Nilai masker jaringan harus 24, 16, atau 8.",
    'cmd_dns__this_dns_record_already_exists' => "Catatan DNS tersebut sudah ada.",
    'cmd_dns__unable_add_record' => "Tidak dapat menambah catatan '%1': %2",
    'cmd_dns__unable_add_a_record' => "Tidak dapat menambah catatan A: %1",
    'cmd_dns__unable_add_cname_record' => "Tidak dapat menambah catatan CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Tidak dapat menambah catatan DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Tidak dapat menambah catatan EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Tidak dapat menambah catatan NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Tidak dapat menambah catatan PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Tidak dapat menambah catatan TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Tidak dapat membuat zona DNS %1",
    'cmd_dns__unable_define_dns_record' => "Tidak dapat menentukan catatan DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Tidak dapat memulihkan status zona DNS default: %1",
    'cmd_dns__unable_insert_a_record' => "Tidak dapat menyisipkan catatan A: %1",
    'cmd_dns__unable_insert_mx_record' => "Tidak dapat menyisipkan catatan MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Tidak dapat menyisipkan catatan NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Tidak dapat menetapkan status zona DNS: %1",
    'cmd_domains__dom_already_exists' => "Domain %1 sudah ada.",
    'cmd_domains__dns_record_already_exists' => "Tidak dapat membuat domain %1 karena catatan DNS yang menunjuk ke host %1 sudah ada.",
    'cmd_domains__dom_already_exists1' => "Terdapat %2 subdomain di domain ini. Domain %1 sudah ada.",
    'cmd_domains__dom_already_exists2' => "Subdomain %1 sudah ada.",
    'cmd_domains__dalias_already_exists' => "Alias ini sudah ada.",
    'cmd_domains__domain_alias_already_exists' => 'Alias domain dengan nama tersebut sudah ada.',
    'cmd_domains__unable_del_mail_for_dom' => "Tidak dapat menghapus layanan surat untuk domain: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Tidak dapat menghapus akun FTP anonim untuk domain: %1",
    'cmd_domains__unable_update_dom_param' => "Tidak dapat memperbarui parameter domain: %1.",
    'cmd_domains__unable_rename_client_exist' => "nama pengguna administrator domain sudah digunakan.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Jenis hosting bukan fisik.",
    'cmd_hosting__unable_create_user' => "Tidak dapat membuat pengguna %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Tidak dapat menentukan alamat IP untuk host virtual berbasis-nama: %1",
    'cmd_hosting__unable_del_old_hst' => "Tidak dapat menghapus hosting yang sudah ditata sebelumnya: %1",
    'cmd_hosting__unable_del_protected_directory' => "Tidak dapat menghapus direktori terlindung: %1.",
    'cmd_hosting__unable_del_web_user' => "Tidak dapat menghapus pengguna web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Tidak dapat membuat atau memperbarui Host Virtual: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Tidak dapat menata hosting penerusan bingkai.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Tidak dapat membangun ulang file konfigurasi proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Tidak dapat menata SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Tidak dapat menghapus perlindungan dari direktori SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Tidak dapat memperbarui URL tujuan %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Tidak dapat memperbarui zona DNS untuk domain: eksekusi utilitas gagal.",
    'cmd_hosting__unable_update_ftp_passwd' => "Tidak dapat memperbarui kata sandi FTP %1.",
    'cmd_hosting__unable_update_user' => "Tidak dapat memperbarui pengguna %2: %1",
    'cmd_hosting__unknown_hst_type' => "Jenis hosting tidak diketahui.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Anda tidak memiliki izin untuk menghentikan layanan hosting.",
    'cmd_mail__autoresponder__not_configured' => "Balasan otomatis untuk akun surat ini tidak dikonfigurasikan",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Alamat %1 sudah digunakan untuk penerusan surat.",
    'cmd_mail__alias_already_exists' => "alias sudah ada.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID balasan otomatis dan ID akun surat tidak cocok.",
    'cmd_mail__autoresp_id_is_undefined' => "ID balasan otomatis tidak terdefinisi.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Alias surat dengan nama tersebut sudah ada untuk akun surat %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Akun surat %1 sudah berlangganan milis ini.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Akun surat %1 sudah ada di domain ini.",
    'cmd_mail__mail_name_not_exist' => "Akun surat tidak ada.",
    'cmd_mail__mail_name_passwd_part' => "Kata sandi tidak boleh berisi nama akun surat di dalamnya.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Milis %1 sudah ada di domain ini.",
    'cmd_mail__mailname_already_exist_in_mg' => "Akun surat %1 sudah ada di kelompok surat.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Akun surat %1 sudah ada di domain ini.",
    'cmd_mail__mailname_already_exists' => "Akun surat sudah ada.",
    'cmd_mail__mailname_is_invalid' => "Nama akun surat %1 tidak valid.",
    'cmd_mail__mailname_unable_update' => "Tidak dapat memperbaharui properti akun surat:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Jumlah maksimum balasan otomatis untuk domain ini sudah tercapai.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Jumlah maksimum kelompok surat untuk domain ini sudah tercapai.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Jumlah penerus maksimum untuk domain ini sudah tercapai.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Jumlah maksimum kotak surat sudah tercapai.",
    'cmd_mail__no_members_specified' => "tidak ada anggota yang ditentukan.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Kata sandi terlalu mudah, harap pilih yang lain.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Alamat surat ini sudah digunakan.",
    'cmd_mail__unable_define_autoresp_id' => "Tidak dapat menentukan ID balasan otomatis %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Gagal mengubah pengaturan layanan surat untuk domain %1",
    'cmd_mail__unable_del_mail_for_dom' => "Tidak dapat menghapus layanan surat untuk domain %1",
    'cmd_mail__unable_del_mail_redirection' => "Tidak dapat menghapus layanan penerusan surat %1.",
    'cmd_mail__unable_remove_autoresp' => "Tidak dapat menghapus balasan otomatis: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Tidak dapat menghapus anggota kelompok surat: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Gagal mematikan kelompok surat: %1",
    'cmd_mail__unable_update_mail_redirect' => "Tidak dapat mengonfigurasi ulang layanan penerusan surat %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Ukuran file yang diunggah terlalu besar.",
    'cmd_mail__additionally' => "Tambahan:",
    'cmd_pd__invalid_login' => "Nama pengguna salah.",
    'cmd_pd__this_user_already_exist' => "Pengguna tersebut sudah ada.",
    'cmd_pd__unable_define_hst_type' => "Tidak dapat menentukan jenis hosting.",
    'cmd_pd__unable_upd_pd_usr' => "Tidak dapat memperbarui properti pengguna direktori terlindung: %1.",
    'cmd_pd__user_is_undefined' => "Pengguna tidak ditentukan.",
    'cmd_server__no_enough_free_disk_space' => "Ruang disk tidak cukup.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "kata sandi lama salah. Silakan coba lagi.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "batas maksimum pengguna web untuk domain ini sudah tercapai.",
    'cmd_web_usr__unable_create_user' => "tidak dapat membuat pengguna sistem: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "tidak dapat menentukan batas maksimum pengguna web: %1",
    'cmd_web_usr__user_already_exists' => "pengguna sudah ada.",
    'cmd_web_usr__web_user_name_is_invalid' => "nama pengguna web %1 tidak valid.",
    'cmd_web_usr__web_user_not_exist' => "pengguna web tidak ada.",
    'common_func__exec_bad_argument' => "argumen exec tidak boleh berisi simbol kutipan tunggal.",
    '__eol' => 'Baris baru',
    'eol__binary_file' => 'Tidak dapat mengubah gaya pemutusan baris di file biner.',
    'cp_access_admin_deny' => "Akses untuk administrator dari alamat '%1' dibatasi sesuai dengan kebijakan pembatasan Akses IP yang sedang diterapkan.",
    'create_domain_warn__' => "Pengecualian berikut dibuat saat pembuatan domain:",
    'create_domain__client_select' => 'Pilih pelanggan yang akan dibuatkan domain',

    'dashboard__nav_button_name' => "Beranda",
    'dalias__list_title' => 'Alias domain dari domain %1',
    'dalias__list_legend' => 'Alias domain',
    'dalias__list_header' => 'Alias domain',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Nama alias domain',
    'dalias__list_ascii_name' => 'Dalam format ASCII',
    'dalias__remove_title' => 'Alias domain dari domain %1 berikut akan dihapus:',
    'dalias__select_domain_aliases_to_remove' => 'Pilih alias domain yang akan dihapus.',
    'dalias__mail_turn_on_failed' => 'Tidak dapat menyalakan layanan surat: %1',
    'dalias__web_turn_on_failed' => 'Tidak dapat menyalakan layanan web: %1',
    'db_usr_edit__db_usr_name_old' => "Nama pengguna basis data lama",
    'database_server_edit_form__cannot_infer_type' => 'Tidak dapat menafsirkan metode koneksi dari data yang disediakan. Tentukan "127.0.0.1" sebagai nama host server database untuk terhubung melalui TCP/IP dengan port yang diberikan, atau biarkan kolom port kosong untuk menggunakan soket Unix "%1".',
    'database_server_edit_form__duplicate' => 'Server basis data dengan kombinasi alamat host dan nomor port ini sudah terdaftar.',
    'database_server_edit_form__host_is_invalid' => 'Nama host yang ditentukan tidak valid.',
    'database_server_edit_form__port_is_invalid' => 'Nomor port yang ditentukan tidak valid.',
    'database_server_error__consult_admin' => 'Harap hubungi administrator server',
    'database_server_error__last__connection_failed' => 'Percobaan terakhir untuk mengontrol server basis data ini gagal karena masalah jaringan.',
    'database_server_error__last__permission_denied' => 'Percobaan terakhir untuk mengontrol server basis data ini gagal karena akun yang diberikan tidak memiliki hak khusus administratif.',
    'database_server_error__last__credentials_not_set' => "Percobaan terakhir untuk menyambung ke server ini gagal karena tidak ada nama pengguna dan kata sandi administrator valid yang ditentukan.",
    'database_server_error__last__other_error' => 'Percobaan terakhir untuk mengontrol server basis data ini gagal.',
    'database_server_error__real__connection_failed' => 'Sambungan ke server basis data gagal karena masalah jaringan:',
    'database_server_error__real__permission_denied' => 'Sambungan ke server basis data gagal karena akun yang diberikan tidak memiliki hak khusus administratif:',
    'database_server_error__real__duplicate_object' => 'Sambungan ke server basis data gagal karena bentrokan nama:',
    'database_server_error__real__unacceptable_name' => 'Sambungan ke server basis data gagal karena nama objek tidak valid:',
    'database_server_error__real__unacceptable_password' => 'Sambungan ke server basis data gagal karena kata sandi tidak dapat diterima:',
    'database_server_error__real__credentials_not_set' => "Plesk tidak dapat tersambung ke server basis data karena tidak ada nama pengguna dan kata sandi administrator valid yang ditentukan.",
    'database_server_error__real__other_error' => 'Sambungan ke server basis data gagal:',
    'database_server_error__test__connection_failed' => 'Tes koneksi ke server basis data gagal karena masalah jaringan:',
    'database_server_error__test__permission_denied' => 'Tes koneksi ke server basis data gagal karena akun yang diberikan tidak memiliki hak khusus administratif:',
    'database_server_error__test__duplicate_object' => 'Tes koneksi ke server basis data gagal karena bentrokan nama:',
    'database_server_error__test__unacceptable_name' => 'Tes koneksi ke server basis data gagal karena nama objek tidak valid:',
    'database_server_error__test__unacceptable_password' => 'Tes koneksi ke server basis data gagal karena kata sandi tidak dapat diterima:',
    'database_server_error__test__credentials_not_set' => "Tes koneksi ke server ini gagal karena tidak ada nama pengguna dan kata sandi administrator valid yang ditentukan.",
    'database_server_error__test__other_error' => 'Tes sambungan ke server basis data gagal:',

    'db__create_new_db' => "Tambah basis data",
    'db__db_add' => "Tambah Basis Data",
    'db__db_for_dom' => "Basis Data Situs Web %1",
    'db__db_id_undefined' => "ID basis data tidak ditentukan.",
    'db__db_name' => "Nama basis data",
    'db__db_not_exist' => "Basis data tidak ada.",
    'db__db_type' => "Tipe",
    'db__db_server' => "Server basis data",
    'db_server_not_exist' => "Server basis data tidak ada.",
    'db__db_user_not_exist' => "Pengguna basis data tidak ada.",
    'db__domain_not_exist' => "Domain tidak ada.",
    'db__enter_db_name' => "Masukkan nama basis data baru.",
    'db__invalid_db_id' => "Pengenal basis data tidak valid.",
    'db__invalid_db_name' => "Nama basis data tidak valid. Nama basis data hanya dapat berisi simbol alfabet Latin, angka, garis bawah, atau garis penghubung. Nama tidak boleh lebih dari 63 simbol.",
    'db__max_db_reached_for_dom' => "Batas jumlah basis data untuk domain ini sudah tercapai.",
    'db__max_mssql_db_reached_for_dom' => "Batas jumlah basis data Server Microsoft SQL untuk domain ini telah tercapai",
    'db__postgres_not_connect_for_admin' => "Tidak dapat menyambung ke PostgreSQL. Hidupkan dukungan PostgreSQL di halaman administrasi server.",
    'db__postgres_not_connect_for_client' => "Tidak dapat menyambung ke PostgreSQL. Tanyakan kepada administrator sistem untuk mendapatkan bantuan.",
    'db__remove_db_on_domain' => "Basis data di bawah situs web %2 berikut yang dimiliki oleh pelanggan %1 akan dihapus:",
    'db__remove_db_on_domain_of_cl' => "Basis data untuk domain %2 berikut yang dimiliki oleh pelanggan %1 akan dihapus:",
    'db__remove_db_linked_resource' => 'Basis data ini digunakan oleh sebuah aplikasi web. Hanya dapat dihapus setelah pemasangan aplikasi web ini dilepas.',
    'db__remove_db_users' => "Pengguna basis data %3 berikut ini di bawah situs web %2 yang dimiliki oleh pelanggan %1 akan dihapus:",
    'db__remove_db_users_of_cl' => "Pengguna basis data %3 berikut ini di bawah situs web %2 yang dimiliki oleh pelanggan %1 akan dihapus:",
    'db__select_db_for_remove' => "Pilih basis data yang akan dihapus.",
    'db__select_db_users_for_remove' => "Pilih pengguna basis data yang akan dihapus.",
    'db__unable_create_db_user' => "Tidak dapat membuat pengguna basis data: %1",
    'db__unable_define_db_name' => "Tidak dapat menentukan nama basis data: %1",
    'db__unable_define_db_user' => "Tidak dapat menentukan pengguna basis data: %1",
    'db__unable_define_db_users' => "Tidak dapat menentukan pengguna basis data: %1",
    'db__unable_select_dom_name' => "Tidak dapat memilih nama domain: %1",
    'db_edit__db_for_dom' => "Pengguna untuk basis data %1 di domain %2",
    'db_edit__invalid_db_name' => "Nama basis data tidak valid.",
    'db_edit__no_users' => "Tidak ada pengguna dengan informasi akses untuk basis data ini.",
    'db_edit__unable_define_db_usrs' => "Tidak dapat menentukan pengguna basis data: %1",
    'db_edit__unable_select_db_usr' => "Tidak dapat memilih pengguna basis data.",
    'db_edit__db_user_password_for_' => "Harap ketik kata sandi untuk masuk sebagai pengguna basis data %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Tambah pengguna basis data",
    'db_usr_edit__db_usr_name' => "Nama pengguna basis data",
    'db_usr_edit__edit_db_usr' => "Tata informasi akses untuk akun pengguna basis data",
    'db_usr_edit__for_db' => "dalam basis data %1",
    'db_usr_edit__not_create_pass' => "Operasi ini akan menghasilkan pembuatan akun pengguna basis data tanpa kata sandi.\nApakah Anda ingin membuat pengguna tanpa memberikan kata sandi?",
    'dbuser__only_one_user_can_be_default' => "Hanya satu pengguna yang dapat ditetapkan sebagai default.",
    'db_server__cannot_delete_default' => "Server basis data default tidak dapat dihapus.",
    'db_server__cannot_delete_local' => "Server basis data lokal tidak dapat dihapus.",
    'db_server__cannot_delete_used' => 'Server basis data tidak dapat dihapus selama terdapat basis data atau pengguna basis data yang di-host di sana.',
    'demo__disabled_in_demo' => "Operasi ini tidak didukung di versi demo.",
    'defaultcomponents__title' => "Pemilihan Komponen Default",
    'defaultcomponents__select_default' => "Pilih komponen default %1", //to check
    'defaultcomponents__not_installed' => "(tidak terpasang)",
    'defaultcomponents__not_configured' => "(tidak dikonfigurasikan)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Beberapa kategori layanan berisi pilihan tidak valid, atau tidak ada pilihan yang dibuat.",
    'defaultcomponents__depends_on' => "(membutuhkan %1)",
    'defaultcomponents__parameters' => "Parameter %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "Server SQL",
    'component_name__sqladmin' => "Webadmin MySQL",
    'component_name__sqladminmysql' => "Webadmin MySQL",
    'component_name__dnsserver' => "Server DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Server FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Server Surat",
    'component_name__local_mailserver' => "Server Surat Lokal",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Pembuatan Skrip Web",
    'component_name__spamfilter' => "Filter Spam",
    'component_name__stats' => "Statistik Web",
    'component_name__stunnel' => "Pengemas SSL/TLS",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Penerbitan Web",
    'component_name__webserver' => "Server Web",
    'dns__dns_record_invalid_values' => 'Nilai rekaman data DNS yang salah ditentukan: %1: %2',
    'dns__dns_record_not_found' => 'Catatan DNS tidak ditemukan',
    'dns__dns_zone_invalid_values' => 'Parameter zona DNS yang salah diberikan.',

    'dns__soa_mname_title' => 'Server Nama Utama',
    'dns__soa_mname_legend' => 'Server Nama',
    'dns__soa_mname_autoselect' => '(Pilih otomatis)',

    'dns__dns_zone_off_remove_title' => "Catatan sumber daya berikut akan dihapus dari zona %1:",
    'dns__dns_zone_master_remove_title' => "Menghapus Catatan Sumber Daya dari Zona DNS %1",
    'dns__dns_zone_slave_remove_title' => "Catatan nameserver utama untuk %1 berikut akan dihapus:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Masukkan untai catatan',
    'dns_add__is_spf_syntax' => 'Catatan SPF',
    'dns_add__spf_value_is_invalid' => "Nilai catatan SPF salah, harus dimulai dengan 'v=spf'",
    'dns__dns_zone_status' => "Status zona DNS.",
    'dns__invalid_ip_address' => "Alamat IP server DNS utama baru tidak valid atau kosong.",
    'dns__ip_address' => "Alamat IP",
    'dns__master_dns_type' => "adalah Server DNS Utama",
    'dns__masters' => "server DNS utama",
    'dns__soa_minimum_too_large' => 'Respons negatif penembolokan lebih dari tiga jam tidak direkomendasikan.',
    'dns__select_masters_to_remove' => "Pilih server DNS primer yang akan dihapus.",
    'dns__select_template_record_to_remove' => 'Pilih catatan template DNS yang akan dihapus.',
    'dns__nameservers_for_domain' => "Nameserver untuk domain",
    'dns__remove_dns_zone_of_domain__' => "Penghapusan catatan DNS dari domain %1",
    'dns__remove_dns_zone_template__' => "Catatan DNS berikut akan dihapus dari template:",
    'dns__remove_this_dns_record?' => "Apakah Anda yakin Anda ingin menghapus catatan DNS ini?",
    'dns__restore_default' => "Memulihkan zona DNS berdasarkan template",
    'dns__restore_default_confirm' => "Pemulihan zona DNS akan menghilangkan konfigurasi zona DNS saat ini. Tetap lanjutkan?",
    'dns__restore_default_error' => "Gagal memulihkan zona DNS:",
    'dns__slave_dns_type' => "adalah server DNS sekunder",
    'dns__subdomain_dns_rec_removed' => "Catatan A dihapus dari subdomain zona %1",
    'dns__zone_switched_off_no_ns' => "Zona dimatikan karena tidak ada catatan NS %1, yang seharusnya ada di dalam zona. Untuk menambah catatan ke zona, klik tombol Tambah Catatan.",
    'dns__cant_switch_on_no_ns' => "Zona tidak dapat dinyalakan karena tidak ada rekaman NS %1, yang harus berada di dalam zona. Untuk menambah catatan ke zona, klik tombol Tambah Catatan.",
    'dns__unable_activate/deactivate_dns' => "Tidak dapat mengaktifkan/menonaktifkan DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Tidak dapat menambah server utama DNS: entri duplikat.",
    'dns__unable_add_dns_master_local_ip' => "Tidak dapat menambah alamat IP untuk server DNS utama: catatan ini harus dibuat di server jauh.",
    'dns__unable_define_dns_record' => "Tidak dapat menentukan catatan DNS: %1",
    'dns__unable_get_dns_template_status' => "Tidak dapat memulihkan status template DNS.",
    'dns__unable_remove_dns_rec' => "Tidak dapat menghapus catatan DNS: %1",
    'dns__warnings__' => "Hasil modifikasi zona DNS:",
    'dns__you_not_have_perm_manage_dns' => "Anda tidak memiliki izin untuk mengelola zona DNS untuk domain ini.",
    'dns__cant_create_record_with_server_ip' => "Tidak dapat menambah alamat IP ini karena sama dengan alamat IP dari server yang dikelola oleh Plesk ini.",

    'dns__tabs_acl' => "Transfer Zona",
    'dns__acl_add_network_legend' => "Tambah Jaringan",
    'dns__acl_add_ip_legend' => "Tambah Alamat IP",
    'dns__acl_network_not_allowed' => "Alamat jaringan ini tidak diizinkan oleh DNS di Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Alamat/masker IP",
    'dns__acl_enter_ip_address' => "Alamat IP",
    'dns__acl_list_network_legend' => "Jaringan yang diizinkan untuk mendapatkan salinan zona DNS",
    'dns__acl_list_ip_legend' => "Alamat IP yang diizinkan untuk mendapatkan salinan zona DNS",
    'bt_dns_acl_add_network' => "Tambah Jaringan",
    'bt_dns_acl_add_ip' => "Tambah Alamat IP",

    'dns_add__add_rec_for_zone' => "Tambah %1 untuk zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "Nama domain kanonis tidak valid.",
    'dns_add__enter_canonical_name' => "Nama kanonis",
    'dns_add__enter_dom_name' => "Nama domain",
    'dns_add__enter_ip_address' => "Alamat IP",
    'dns_add__enter_ip_mask' => "Alamat IP dan masker jaringan",
    'dns_add__enter_mail_domain' => "Domain surat",
    'dns_add__enter_mail_exchanger' => "Server pertukaran surat",
    'dns_add__enter_nameserver' => "Server nama",
    'dns_add__enter_txt_record' => "Catatan TXT",
    'dns_add__enter_service_name' => "Nama layanan",
    'dns_add__hint_service_name' => "Contoh: SIP (tanpa simbol garis bawah)",
    'dns_add__enter_protocol' => "Protokol",
    'dns_add__hint_protocol_name' => "Contoh: TCP (tanpa simbol garis bawah)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioritas",
    'dns_add__specify_weight_of_service' => "Bobot relatif untuk catatan dengan prioritas yang sama",
    'dns_add__enter_target_host' => "Host target",
    'dns_add__hint_target_host' => "Contoh: contoh.com",
    'dns_add__enter_target_port' => "Port target",
    'dns_add__caa_tag' => "Label",
    'dns_add__caa_value' => "Nilai",
    'dns_add-invalid-A_ip' => "Alamat IP invalid.",
    'dns_add-invalid-AAAA_ip' => "Alamat IP invalid.",
    'dns_add-invalid-PTR_ip_mask' => "Pasangan alamat IP/netmask jaringan tidak valid.",
    'dns_add-invalid-SRV_service_name' => "Nama server tidak valid",
    'dns_add-invalid-SRV_protocol_name' => "Protokol tidak valid",
    'dns_add-invalid-SRV_target_port' => "Port target tidak valid",

    'dns_add__invalid_ip' => "Alamat IP invalid.",
    'dns_add__low' => "rendah",
    'dns_add__mail_dom_name_is_invalid' => "Nama domain surat tidak valid.",
    'dns_add__nameserver_is_invalid' => "Server nama tidak valid.",
    'dns_add__record' => "Catatan %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Tentukan prioritas server pertukaran surat",
    'dns_add__unable_insert_new_dns_rec' => "Tidak dapat menyisipkan catatan DNS baru: %1",
    'dns_add__very_high' => "sangat tinggi",
    'dom_ctrl__allowed' => "Diizinkan",
    'dom_ctrl__db' => "Basis data MariaDB/MySQL",
    'dom_ctrl__mssql_db' => "Basis data MS SQL",
    'dom_ctrl__disk_space' => "Ruang disk",
    'dom_ctrl__dom_adm' => "Domain %1 dari %2",
    'dom_ctrl__dom_cl' => "Domain %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domain telah ditata untuk penerusan dengan URL penerusan yang tidak ditentukan",
    'dom_ctrl__domain_has_frame_forwarding' => "Domain memiliki penerusan bingkai ke URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Domain tidak memiliki hosting yang terkonfigurasi",
    'dom_ctrl__domain_has_physical_hosting' => "Hosting web dikonfigurasikan untuk domain ini di alamat IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domain memiliki penerusan standar ke URL %1",
    'dom_ctrl__maillists' => "Milis",
    'dom_ctrl__mboxes' => "Kotak surat",
    'dom_ctrl__mg' => "Penerusan Surat",
    'dom_ctrl__resource_name' => "Sumber daya",
    'dom_ctrl__resp' => "Balasan otomatis",
    'dom_ctrl__subdom' => "Subdomain",
    'dom_ctrl__dom_aliases' => "Alias domain",
    'dom_ctrl__traffic' => "Lalu-lintas",
    'dom_ctrl__unable_activate/deactivate_dom' => "Tidak dapat mengaktifkan/menonaktifkan domain: %1",
    'dom_ctrl__used' => "Digunakan",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Pengguna web",
    'dom_pref__bounce_with_phrase' => "Pantulkan dengan pesan",
    'dom_pref__bounce' => "Pantulkan",
    'dom_pref__catch_addr' => "Teruskan ke alamat",
    'dom_pref__reject' => 'Tolak',
    'dom_pref__confirm_domain_removing' => "Harap jangan lupa memberi tahu pengunjung domain mengenai perubahan nama domain. Apakah Anda yakin Anda ingin mengganti nama domain?",
    'dom_pref__db_inconsystency' => "ketidakkonsistenan basis data.",
    'dom_pref__dbs' => "basis data",
    'dom_pref__delete_traffic_stat' => "Simpan statistik web dan lalu-lintas",
    'dom_pref__delete_traffic_stat_older' => "Simpan statistik web dan lalu-lintas",
    'dom_pref__dom_level_name_conflict' => "Nama pengguna administrator domain bertentangan dengan nama pengguna salah satu pelanggan.",
    'dom_pref__invalid_disk_space_limit' => "Batas ruang disk tidak valid. Nilai maksimum: %1",
    'dom_pref__invalid_expiration_date_limit' => "Periode validitas tidak valid.",
    'dom_pref__invalid_max_traffic_limit' => "Batas lalu-lintas tidak valid. Nilai maksimum: %1",
    'dom_pref__limits_of_dom' => "Batas untuk domain %1",
    'dom_pref__mail_grps' => "kelompok surat",
    'dom_pref__mail_nonexistent_user' => "Apa yang harus dilakukan dengan surat yang dikirim ke pengguna yang tidak ada",
    'dom_pref__mail_redirs' => "penerus surat",
    'dom_pref__mail_resps' => "balasan otomatis surat",
    'dom_pref__max_limit_is_invalid' => "%1 tidak valid.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Angka maksimum dari %1 tidak valid.",
    'dom_pref__new_limit_less_currently_used' => "%1: diminta - %2, sedang digunakan saat ini - %3",
    'dom_pref__older_that' => "untuk",
    'dom_pref__postboxes' => "kotak surat",
    'dom_pref__preferences_of_dom' => "Pengaturan untuk domain %1",
    'dom_pref__redirect_to_itself' => "Domain akan memiliki penerusan ditetapkan ke dirinya sendiri",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Anda menentukan waktu penyimpanan statistik lalu-lintas domain kurang dari nilai total yang ditentukan untuk server (%1 bulan). Periode penyimpanan statistik ditetapkan sama dengan nilai default untuk server (%1 bulan).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Tidak dapat menambahkan awalan www ke domain: %1",
    'dom_pref__unable_define_physical_hst_param' => "Tidak dapat menentukan parameter hosting fisik: %1",
    'dom_pref__unable_rename_domain' => "Tidak dapat mengganti nama domain %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Tidak dapat menetapkan kuota kotak surat untuk domain ini: %1",
    'dom_pref__unable_set_up_web_user_script' => "Tidak dapat menata penulisan skrip untuk pengguna web: %1",
    'dom_pref__unlimited' => "Tidak terbatas",
    'dom_pref__web_usrs' => "pengguna web",
    'dom_pref__you_already_have_%object' => "Anda telah memiliki %1",
    'cu_domain__error_unable_update_ftp_users' => 'Gagal memperbarui pengguna FTP domain: %1',
    'dom_cli__warning_ignore_quota' => 'PERINGATAN: Opsi "-hard_quota" diabaikan: kuota hard disk tidak didukung',
    'dom_user_client_login_exist' => "Tidak dapat mengizinkan akses administrator domain ke Plesk di domain %1: nama pengguna ini sudah digunakan.",
    'domain__unable_to_turn_on_service' => "Gagal menghidupkan layanan %1.",
    'domains__change_the_status_of_domain?' => "Apakah Anda yakin Anda ingin mengubah status domain %1?",
    'domains__client_info_hiding_traffic' => "%1 domain, %2 domain aktif, %3 ruang disk yang digunakan",
    'domains__unable_to_change_client_status' => "Tidak dapat mengubah status akun pelanggan: %1",
    'domains__unable_update_apache_settings' => "Tidak dapat memperbarui pengaturan Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Anda tidak memiliki izin untuk menghapus domain ini.",
    'domains_list__unable_remove_doms' => "Tidak dapat menghapus domain: %1",
    'domaintrafficlist_header_of_domain__' => "Lalu-lintas di domain %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Pilih alias domain yang akan dihapus.',
    'domain_aliases_remove__title' => 'Menghapus alias domain',
    'domain_aliases__max_aliases_reached_for_dom' => "Mencapai batas jumlah alias untuk domain ini.",
    'domain_edit__edit_title' => 'Sunting nama alias domain',
    'domain_alias_edit__type' => 'Jenis alias domain',
    'domain_aliases__list_header' => 'Alias domain',
    'domain_aliases__name' => 'Nama',
    'domain_aliases__type' => 'Tipe',
    'domain_aliases__type_full' => 'Web+FTP+Surat',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Alias domain',
    'domain_aliases__legend' => 'Alias domain',
    'domain_alias__domain_exists' => 'Domain dengan nama tersebut sudah ada',
    'domain_alias__subdomain_exists' => 'Subdomain dengan nama tersebut sudah ada',
    'domain_alias__dns_record_exists' => 'Catatan DNS dengan nama alias domain yang ditentukan sudah ada',
    'domain_alias__domain_alias_exists' => "Alias domain dengan nama tersebut sudah ada",
    'domain_alias__invalid_type_full' => 'Server surat tidak mendukung alias domain',
    'domain_alias__redirect_exists' => 'Mendeteksi pengalihan ke diri sendiri.',

    'ds__anonymous_ftp' => "FTP Anonim",
    'drweb__pagetitle' => 'Pengaturan Antivirus',
    'drweb__drweb' => 'Pengecekan surat Antivirus',
    'drweb__drweb_direction' => 'Mengecek virus di surat',
    'drweb__drweb_direction_off' => 'Jangan mengecek virus',
    'drweb__drweb_direction_any' => 'Surat masuk dan keluar',
    'drweb__drweb_direction_from' => 'Surat keluar saja',
    'drweb__drweb_direction_to' => 'Surat masuk saja',
    'drweb__disable_reason_key' => 'Antivirus tidak didukung oleh kunci lisensi.',
    'drweb__disable_reason_perm' => 'Anda tidak memiliki izin untuk mengelola Antivirus.',
    'drweb__disable_reason_install' => 'Antivirus tidak dipasang.',
    'drweb__filters' => 'Filter Antivirus',
    'ds__dns' => "Zona DNS",
    'ds__mail' => "Surat",
    'dumps_list__deletion_page_title' => "File cadangan dari domain %1 berikut akan dihapus:",
    'dumps_list__dumpfile_is_invalid' => "File %1 bukan file cadangan domain yang valid.",
    'dumps_list__page_title' => "Penyimpanan berkas cadangan",
    'dumps_upload__page_title' => "Mengunggah Berkas Cadangan ke Penyimpanan",
    'dumps_list__repository_is_not_exist' => "Penyimpanan berkas cadangan tidak ada.",
    'dumps_list__unable_to_remove' => "Tidak dapat menghapus file cadangan: %1",
    'dumps_list__dumpfile_can_conflict' => "Nama file yang Anda tentukan bertentangan dengan file %1. Harap tentukan nama file yang lain.",
    'dusr_ed__allow_dl_usr_access' => "Izinkan akses administrator domain",
    'dusr_ed__information' => "Properti Administrator Domain %1",
    'dusr_ed__locale' => "Bahasa administrator domain",
    'dusr_ed__skin' => "Skin antarmuka administrator domain",
    'dusr_ed__personal_information' => 'Informasi pribadi',
    'ess__error' => "Galat",
    'example__' => "Contoh: %1",
    'extras__allow_certificate_purchasing' => "Izinkan pembelian sertifikat",
    'extras__allow_domain_registration' => "Izinkan registrasi domain",
    'extras__allow_extras' => "Izinkan layanan ekstra",
    'extras__buy_new_key' => "Lisensi Anda saat ini tidak mengizinkan Anda untuk mengubah objek ini.",
    'extras__setup_services' => "Tata layanan tambahan",

    'ruleeditform__error' => 'Tidak dapat memperbarui aturan firewall.',
    'ruleeditform__name_is_required' => 'Tetapkan nama aturan.',
    'ruleeditform__profiles_is_required' => 'Pilih paling tidak satu profil.',
    'ruleeditform__invalid_ip' => 'Alamat IP atau jaringan yang ditentukan invalid.',
    'ruleeditform__invalid_port' => 'Port yang ditentukan invalid. Nilai yang mungkin adalah 1000 atau 1000-1051',

    'get_password__encrypted_password' => "Tidak dapat mengirimkan informasi kata sandi: kata sandi disimpan dalam bentuk terenkripsi.",
    'get_password__mail_error' => "Galat terjadi ketika mencoba mengirimkan kata sandi ke surel %1: %2",
    'get_password__mail_ok' => "Kata sandi telah dikirim dengan sukses ke surel: %1",
    'get_password__message' => "Nama pengguna Anda untuk mengakses sistem: %1\nKata sandi Anda adalah %2",
    'get_password__subject' => "Kata sandi untuk mengakses sistem",
    'groups__available' => "Kelompok surat yang tersedia",
    'groups__groups_for_mailname' => "Kelompok surat di mana akun surat %1 berlangganan",
    'groups__member_of' => "Anggota dari kelompok surat berikut",
    'help__help_area' => "Area bantuan.",
    'hst_def__auth_disabled' => "dilarang",
    'hst_def__auth_enabled' => "diizinkan",
    'hst_def__change_curr_dns_ip' => "Alamat IP catatan A DNS saat ini akan diubah",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Tidak ada alamat IP catatan A DNS yang cocok dengan alamat IP yang ditugaskan ke akun hosting yang sedang dibuat",
    'hst_def__dest_url' => "URL tujuan",
    'hst_def__disk_quota' => "Kuota disk",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Batas ruang disk yang coba Anda tetapkan sudah terlampaui oleh batas ruang disk di FTP anonim direktori masuk. Batas ruang disk di FTP anonim direktori masuk tidak boleh melebihi batas ruang disk domain.",
    'hst_def__frame_forwarding_definition' => "Tugas penerusan bingkai untuk domain %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Peringatan: Pengguna FTP %1 digunakan di pengaturan akun hosting namun tidak ada di dalam sistem.",
    'hst_def__hst_type_is_not_defined' => "Jenis hosting tidak ditentukan",
    'hst_def__ip_based' => "Berbasis-IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Mentransfer akun hosting ini ke alamat IP bersama akan membuat layanan FTP anonim di domain ini jadi tidak tersedia. Tetap lanjutkan?",
    'hst_def__password_is_invalid_password_syntax' => "Kata sandi invalid.\nJangan menggunakan tanda kutip tunggal dan karakter alfabet nasional dalam kata sandi.\nPanjang kata sandi harus antara 5 sampai 14 karakter. Kata sandi tidak boleh berisi nama pengguna.",
    'hst_def__shell' => "Akses SSH ke shell server di bawah langganan pengguna sistem",
    'hst_def__shell_windows' => "Akses Desktop Jauh ke server di bawah pengguna sistem langganan",
    'hst_def__standard_forwarding_definition' => "Tugas penerusan standar untuk domain %1",
    'hst_def__title_name_based' => "Berbasis-nama",
    'hst_def__unable_create/update_physic_hst' => "Tidak dapat membuat/memperbarui hosting fisik: %1",
    'hst_def__unable_create/update_std_fwd' => "Tidak dapat membuat/memperbarui penerusan standar: %1",
    'hst_def__unable_create_forwarding_myself' => "Tidak dapat membuat penerusan ke domain itu sendiri.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Tidak dapat memperkenankan penggunaan direktori tunggal untuk menyimpan konten SSL/TLS dan non-SSL/TLS: Dukungan SSL/TLS tidak dihidupkan.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Tidak dapat menghidupkan dukungan SSL/TLS: tidak ada sertifikat SSL/TLS yang dipasang.",
    'hst_def__url_is_invalid' => "URL tidak valid.",
    'hst_def__virtual_host_access' => "Akses host virtual untuk domain %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "PERINGATAN. Host virtual ini menggunakan alamat IP yang tidak ada untuk hosting.",
    'hst_def__you_have_no_ips' => "Anda tidak memiliki alamat IP yang tersedia dan Anda tidak diperkenankan membuat hosting berbasis-Nama.",
    'hst_sel__header' => "Untuk meng-host situs web di server ini, pilih opsi hosting Fisik.\nUntuk menata penerusan domain ke situs di mesin yang lain, pilih opsi penerusan Bingkai atau penerusan Standar.\nDengan penerusan standar, pengguna dialihkan ke situs dan URL situs yang sebenarnya akan terlihat di peramban pengguna, sehingga pengguna tahu tentang pengalihan. Dengan penerusan bingkai, pengguna dialihkan ke situs tanpa mengetahui bahwa situs tersebut sebenarnya berada di lokasi yang lain.",
    'hst_sel__physical_hst' => "Hosting fisik",
    'hst_sel__select_hst_type' => "Pilih jenis hosting untuk domain",
    'hst_sel__select_hst_type_warning' => "Pilih jenis hosting untuk domain",
    'hst_sel__hosting_exists' => "Tidak dapat membuat hosting karena telah dikonfigurasi untuk domain ini. Anda akan dialihkan ke halaman pengelolaan hosting.",
    'hst_sel__standard_frw' => "Penerusan standar",
    'hst_sel__frame_frw' => "Penerusan bingkai",
    '__frame_frw' => "Penerusan bingkai",
    '__hosting_exists' => "Tidak dapat membuat hosting karena telah dikonfigurasi untuk domain ini. Anda akan dialihkan ke halaman pengelolaan hosting.",
    '__choose_hst_type' => "Pilih jenis hosting yang diminta.",
    '__no_hst_conf' => "Tidak ada hosting dikonfigurasi untuk domain Anda.",
    '__physical_hst' => "Hosting fisik",
    '__select_hst_type' => "Pilih jenis hosting untuk domain",
    '__standard_frw' => "Penerusan standar",
    '__warning' => "Peringatan! Semua parameter yang telah ditentukan sebelumnya akan dibuang. Apakah Anda yakin ingin mengubah jenis hosting?",
    'i_cl_off' => "Pelanggan tidak aktif.",
    'i_cl_off_by_admin' => "Akun pelanggan ditangguhkan oleh administrator server.",
    'i_cl_off_expired' => "Akun pelanggan sudah kedaluwarsa.",
    'i_cl_on' => "Pelanggan aktif.",

    'icf__title' => 'Firewall Sambungan Internet',
    'icf__if_legend' => 'Antarmuka',
    'icf__mode' => 'Mode',

    'invalid_value' => 'Nilai tidak valid',

    'ip_addr__already_exists' => "Alamat IP %1 sudah ada.",
    'ip_addr__cant_add' => "IP %1 tidak ada atau bagian dari kumpulan IP pelanggan yang lain",
    'ip_alias__interface' => "Antarmuka",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 alamat IP untuk hosting virtual berbasis-nama tidak valid.",
    'ip_alias__invalid_ip_or_netmask' => "Pasangan alamat IP/netmask jaringan tidak valid.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Alamat IP %1 adalah server IP asli, sehingga Anda tidak dapat menghapusnya.",
    'ip_alias__ip_is_invalid' => "Alamat IP %1 tidak valid.",
    'ip_alias__ip_mask_is_invalid' => "Masker IP %1 tidak valid.",
    'ip_alias__ip_not_exist' => "Alamat IP %1 tidak ada.",
    'ip_alias__ip_address_and_mask' => 'Alamat IP dan masker subnet',
    'ip_alias__mask' => "Masker Subnet",
    'ip_alias__remove_selected_ip_aliases?' => "Apakah Anda yakin Anda ingin menghapus alamat IP yang dipilih?",
    'ip_alias__select_ip' => "Pilih sedikitnya satu alamat IP dari daftar untuk dihapus.",
    'ip_alias__this_ip_used_for_domain' => "(%1) alamat IP ini digunakan untuk domain %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) alamat IP ini digunakan untuk host virtual berbasis-nama.",
    'ip_alias__unable_add_ip' => "Tidak dapat menambahkan IP: %1",
    'ip_alias__unable_remove_ip' => "Tidak dapat menghapus IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Anda tidak dapat mengubah jenis alamat IP menjadi bersama, karena hal ini akan membuat FTP Anonim untuk domain '%1' jadi tidak tersedia.",
    'ip_ctrl__ip_addr' => "Alamat IP %2 pada antarmuka %1",
    'ip_ctrl__ip_exists_many_pools' => "Anda tidak dapat mengubah jenis IP. Alamat IP ini bagian dari kumpulan beberapa pengguna di waktu yang sama.",
    'ip_ctrl__ssl_cert' => "Sertifikat SSL/TLS",
    'limit__date_in_past' => "Periode validitas tidak valid. %1 sudah lewat.",
    'limit__enter_date' => "Masukkan tanggal",
    'limit__max_db' => "Basis data",
    'limit__name_disk_space' => "ruang disk",
    'limit__name_max_box' => "kotak surat",
    'limit__name_max_db' => "Basis data MariaDB/MySQL",
    'limit__name_max_dom' => "domain",
    'limit__name_max_maillists' => "milis",
    'limit__name_max_subdom' => "Subdomain",
    'limit__name_max_traffic' => "lalu-lintas",
    'limit__name_max_wu' => "pengguna web",
    'limit__name_mbox_quota' => "kuota kotak surat",
    'limit__name_max_mn' => "akun surat",
    'limit__name_max_cl' => 'Klien',
    'limit__name_total_mboxes_quota' => "kuota total kotak surat",
    'limit__name_mysql_dbase_space' => "Ruang basis data MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "ruang basis data MSSQL",
    'limit__name_pgsql_dbase_space' => "Ruang basis data PostgreSQL",
    'limit__name_expiration' => 'tanggal kedaluwarsa',

    'locale_upload__unable_to_install' => 'Tidak dapat memasang file paket bahasa',
    'locale_upload__wrong_package' => 'File yang Anda unggah tidak berisi paket bahasa yang valid untuk Plesk versi ini.',
    'locale_upload__wrong_locale' => 'File yang Anda unggah tidak berisi paket bahasa yang valid.',

    'ma__create_title' => 'Membuat alias surat untuk %1',
    'ma__edit_title' => "Sunting alias surat %1",
    'ma__enter_new_alias' => "Masukkan alias baru.",
    'ma__invalid_alias' => "Alias surat tidak valid.",
    'ma__mail_aliases_mailname' => "Alias surat untuk akun surat %1",
    'ma__mailname_does_not_exist' => "Akun surat tidak ada.",
    'ma__select_ma_for_remove' => "Pilih alias surat yang akan dihapus.",
    'ma__unable_to_add_new_ma' => "Tidak dapat menambah alias surat: %1",

    'mail_queue__not_allowed_by_license_key' => 'Pengelolaan antrean surat tidak diperkenankan oleh kunci lisensi.',
    'maillist__' => "Milis %1",
    'maillist__already_exists' => "Milis sudah ada.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Alias surat %1 sudah ada di domain ini",
    'maillists__' => "Milis %1",
    'maillists__limit_cl_max_maillists' => "Mencapai batas jumlah milis untuk pelanggan (batas: %1, digunakan: %2)",
    'maillists__limit_dom_max_maillists' => "Mencapai batas jumlah milis untuk domain.",
    'maillists__list' => "Milis",
    'maillists__mailman_not_installed_or_conf' => "\nEkstensi Server Mailman saat ini belum dipasang atau dikonfigurasikan \ndi server. Hubungi administrator server untuk memasang atau mengonfigurasi Ekstensi Server Mailman dengan benar.",
    'maillists__status' => "Layanan milis dihidupkan",
    'maillists__unable_to_delete__' => "Tidak dapat menghapus milis: %1",
    'maillists__disabled_text' => 'Anda tidak dapat mengelola milis karena komponen server milis Mailman tidak dipasang atau dikonfigurasikan.',
    'maillist_member__already_exists' => 'Pelanggan milis sudah ada.',
    'maillist_member__not_exists' => 'Tidak ada pengguna tersebut di milis.',
    'mailserver_switching_warning' => "Peringatan!\n\nPengubahan server surat dimaksudkan hanya untuk penataan awal dan, bila server sudah digunakan, menyebabkan masalah berikut: hilangnya pengaturan dan isi kotak surat dan, pada kasus di mana server tempat Anda berpindah sudah dikonfigurasikan, berbagai konflik.\n\nBila server ini sedang digunakan saat ini dan Anda yakin mengenai perpindahan ke server yang lain, Anda dapat memberitahukan pelanggan Anda mengenai operasi ini sehingga mereka bisa mengunduh dan menyimpan surat mereka.",
    'manager__access_denied' => "Akses ditolak: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Pelanggan',
    'manager__domain' => "Domain",
    'manager__domain_cl_limit_exceeding' => "Batas jumlah domain untuk akun pelanggan ini sudah tercapai.",
    'manager__domain_is_not_yours' => "Domain %1 tidak Anda miliki.",
    'manager__domain_key_limit_exceeding' => "Batas pembuatan domain yang ditentukan oleh kunci lisensi Anda sudah tercapai.",
    'manager__no_perm_to_call' => "Anda tidak memiliki izin untuk memanggil %1.",
    'manager__no_perm_to_create_domains' => "Anda tidak memiliki izin untuk membuat domain.",
    'manager__no_perm_to_modify_domain' => "Anda tidak memiliki izin untuk memodifikasi domain %1.",
    'manager__no_perm_to_modify_domains' => "Anda tidak memiliki izin untuk memodifikasi domain.",
    'manager__no_perm_to_remove_domain' => "Anda tidak memiliki izin untuk menghapus domain %1.",
    'manager__no_perm_to_remove_domains' => "Anda tidak memiliki izin untuk menghapus domain.",
    'manager__node_doesnt_exist' => "%1 tidak ada.",
    'manager__user_disabled' => "Akun Anda ditangguhkan. Anda tidak dapat mengoperasikan sistem.",
    'mail_quota_unsupported' => "tidak didukung oleh server surat",
    'mbox_quota_unsupported' => "tidak didukung oleh server surat",
    'mn__create_title' => "Buat akun surat",
    'mn__edit_title' => "Pengaturan",
    'mn__files_list_title' => "File Lampiran",
    'mn__files_remove' => "Hapus file dari repositori lampiran. File ini kemungkinan akan digunakan oleh balasan otomatis. Mereka akan dihapus dari repositori dan balasan otomatis yang menggunakannya.",
    'mn__files_select_for_remove' => "Pilih file untuk dihapus.",
    'mn__mail_alias_form' => "Bentuk alias surat",
    'mn__mail_aliases_list' => "Alias surat",
    'mn__mailbox' => "Pengelolaan kotak surat",
    'mn__unable_define_mn' => "Tidak dapat menata akun surat: %1",
    'mn__unable_remove_mbox_quota' => "Tidak dapat menghapus kuota kotak surat: %1",
    'mn__upload_file' => "Unggah file",
    'mn_edit__attach_filename_changed' => 'File %1 yang diunggah telah diganti nama menjadi %2 karena nama tersebut berisi karakter non-ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Anda harus menambah satu anggota kelompok surat sebelum mengaktifkan kelompok surat.",
    'mn_edit__add_resp_or_turn_off_box' => "Anda harus menambah balasan otomatis atau mengosongkan kotak cek balasan otomatis.",
    'mn_edit__attachments' => "Lampiran",
    'mn_edit__dom_quota_less_then_quota' => "Ukuran kotak surat ini tidak boleh melebihi batas jumlah ruang disk yang dialokasikan untuk kotak surat di domain ini.",
    'mn_edit__enter_external_rcpnt_email' => "Masukkan surel anggota kelompok surat eksternal",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Ketik alamat untuk penerusan surat atau bersihkan kotak cek.",
    'mn_edit__ext_rcpnt_email_invalid' => "Alamat surel penerima eksternal tidak valid.",
    'mn_edit__file_exists' => "File sudah ada. Timpa?",
    'mn_edit__files_deld_from_repository' => "File ini akan dihapus dari repositori beserta balasan otomatis yang berisi file tersebut. Apakah Anda ingin melanjutkan?",
    'mn_edit__mail_name' => "Akun surat",
    'mn_edit__mail_name_invalid' => "Nama akun surat tidak valid.",
    'mn_edit__mail_redir' => "Penerus surat",
    'mn_edit__mail_redir_add' => "Tambah Anggota Kelompok Surat",
    'mn_edit__mail_resps' => "Balasan otomatis surat",
    'mn_edit__mailbox' => "Kotak surat",
    'mn_edit__enable_mailbox' => "Kotak surat",
    'mn_edit__mailgroup' => "Kelompok surat",
    'mn_edit__mailgroup_addresses' => "Anggota kelompok surat",
    'mn_edit__mailgroup_disabled' => "Tersedia hanya ketika akun surat sudah ditambahkan.",
    'mn_edit__max_dom_quota' => "Default untuk domain (%1)",
    'mn_edit__mbox_quota_invalid' => "Ukuran kotak surat yang salah ditentukan.",
    'mn_edit__new_resp_name' => "Nama balasan otomatis baru",
    'mn_edit__no_autoresponders' => "Anda harus menambah sedikitnya satu balasan otomatis sebelum menghidupkan/mematikan layanan balasan otomatis.",
    'mn_edit__no_file_sel' => "Tidak ada file yang dipilih.",
    'mn_edit__no_mail_addresses' => "Tidak ada alamat surel yang ditentukan atau dipilih.",
    'mn_edit__none' => "Tidak ada",
    'mn_edit__not_create_pass' => "Hal ini tidak akan membuat kata sandi untuk akun ini.\nTanpa kata sandi pengguna tidak akan dapat melihat dan mengirim surat.",
    'mn_edit__redir_email_invalid' => "Alamat penerusan tidak valid.",
    'mn_edit__redirect_addr' => "Alamat penerusan",
    'mn_edit__remove_autoresp?' => "Apakah Anda yakin Anda ingin menghapus balasan otomatis?",
    'mn_edit__remove_rcpnts?' => "Apakah Anda yakin Anda ingin menghapus penerima ini?",
    'mn_edit__repository' => "Repositori",
    'mn_edit__resps_attach' => "File lampiran balasan otomatis",
    'mn_edit__select_rcpnt_from_list' => "Pilih sedikitnya satu penerima dari daftar yang akan dihapus.",
    'mn_edit__select_registered_users' => "Pilih pengguna terdaftar",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Anda telah memilih untuk memiliki kotak surat tapi belum menetapkan kata sandinya.",
    'mn_edit__unable_act_deact_mail_group' => "Tidak dapat mengaktifkan atau menonaktifkan kelompok surat: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Tidak dapat mengaktifkan atau menonaktifkan penerusan surat: %1",
    'mn_edit__unable_act_deact_postbox' => "Tidak dapat mengaktifkan atau menonaktifkan kotak surat: %1",
    'mn_edit__unable_act_deact_resp' => "Tidak dapat mengaktifkan atau menonaktifkan balasan otomatis: %1",
    'mn_edit__unable_add_attach' => "Tidak dapat menambah file lampiran: %1",
    'mn_edit__unable_add_mail_group_member' => "Tidak dapat menambah anggota kelompok surat: %1",
    'mn_edit__unable_add_resp' => "Tidak dapat menambah balasan otomatis: %1",
    'mn_edit__unable_change_mail_name' => "Tidak dapat mengubah nama akun surat: %1",
    'mn_edit__unable_deactivate_mail_group' => "Tidak dapat menonaktifkan kelompok surat: %1",
    'mn_edit__unable_deactivate_resp' => "Tidak dapat menonaktifkan balasan otomatis surat: %1",
    'mn_edit__unable_define_resp_id' => "Tidak dapat menentukan ID balasan otomatis: %1",
    'mn_edit__unable_remove_attach' => "Tidak dapat menghapus file lampiran: %1",
    'mn_edit__unable_remove_autoresp' => "Tidak dapat menghapus balasan otomatis: %1",
    'mn_edit__unable_remove_mail_group_member' => "Tidak dapat menghapus anggota kelompok surat: %1",
    'mn_edit__wrong_way' => 'Pesan yang dialamatkan ke %1 tidak akan dikirimkan, karena akun surat ini tidak memiliki kotak surat atau penerus surat dihidupkan.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Kotak surat di alamat %1 telah dimatikan. Pesan di dalam kotak surat tidak dihapus, namun Anda tidak akan dapat memulihkannya melalui protokol IMAP atau POP3.',
    'mn_list__mail_names_for_domain' => "Akun surat di bawah domain %1",
    'mn_list__sa_cannot_unable' => "Tidak dapat menyalakan filter spam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Pelanggan',
    'mn_list__tab_title_domain' => 'Domain',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nama",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Tidak dapat menghapus akun surat: %1",
    'module_upload__module_was_installed' => 'Modul ini sudah dipasang. Bila Anda ingin memasang versi terbaru dari modul ini, harap mencopot modul melalui Plesk, dan kemudian mencoba memasang.',
    'module_upload__unable_to_install' => 'Tidak dapat memasang file paket modul',
    'module_upload__wrong_package' => 'File yang diunggah tidak didukung oleh paket modul.',
    'module_upload__wrong_module' => 'File yang diunggah tidak berisi paket modul.',

    'news_articles_title' => 'Berita Plesk',
    'notification_text__invalid_subject_length' => "Panjang subjek pemberitahuan tidak valid. Harus dari 1 hingga 255 karakter.",
    'notification_text__invalid_text_length' => "Panjang teks pemberitahuan tidak valid. Harus antara 1 sampai 65533 karakter.",
    'notification_text__subject' => "Subjek pemberitahuan",
    'notification_text__text' => "Teks pemberitahuan",
    'notification_text__title' => "Sunting pemberitahuan",
    'notification_text__unable_set_text' => "Tidak dapat memodifikasi teks notifikasi:",

    'odbc__cant_add_dsn' => "Tidak dapat menambahkan DSN %1: %2",
    'odbc__cant_connect' => "Tidak dapat menyambung ke sumber data menggunakan pengaturan yang ditentukan. Server telah kembali: %1",
    'odbc__cant_delete_dsn' => "Tidak dapat menghapus DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Tidak dapat mendapatkan data mengenai driver.",
    'odbc__cant_get_drivers' => "Tidak dapat menarik daftar driver ODBC: %1",
    'odbc__cant_open_info_file' => "Tidak dapat membuka file dengan informasi driver ODBC.",
    'odbc__cant_parse_string' => "Tidak dapat melakukan menguraikan untai koneksi.",
    'odbc__driver_not_set' => "Driver tidak ditetapkan",
    'odbc__driver_or_name_not_set' => "Driver atau nama sambungan ODBC tidak ditetapkan",
    'odbc__dsn_already_exists' => "DSN dengan nama ini (%1) sudah ada di sistem",
    'odbc__dsn_not_exists' => "DSN ini tidak ada",
    'odbc__enter_dsn_name' => "Masukkan nama DSN",
    'odbc__invalid_dsn_name' => "Kesalahan sintaksis dalam nama koneksi ODBC (%1): mohon hanya menggunakan simbol alfanumerik.",
    'odbc__no_such_driver' => "Nama driver ODBC yang demikian (%1) tidak didukung.",
    'odbc__unknown_driver' => "Nama driver tidak dikenal (%1).",
    'odbc_dsn_system' => "DSN Sistem",

    'pb__aliases' => "Alias",
    'pb__anonftp' => "FTP Anonim",
    'pb__autoinstaller_releases' => 'Pembaru',
    'pb__cert' => "Sertifikat",
    'pb__cl_pool' => "Alamat IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Pengaturan",
    'pb__cl_rpt' => "Laporan",
    'pb__cl_rpt_list' => "Ubah suaikan",
    'pb__cl_templates' => "Template Pelanggan",
    'pb__cl_traffic' => "Lalu-lintas",
    'pb__cl_traffic_history' => "Riwayat lalu-lintas",
    'pb__cl_traffic_of' => "Lalu-lintas %1",
    'pb__client' => "%1",
    'pb__clients' => "Pelanggan",
    'pb__comp_info' => "Komponen Server",
    'pb__common_acl' => 'Perkenankan Transfer ACL',
    'pb__cp_access' => "Akses",
    'pb__crontab' => "Penjadwal",
    'pb__scheduler' => "Penjadwal",
    'pb__custom_buttons' => "Tombol Suai",
    'pb__databases_db' => 'Basis data',
    'pb__sqlservers_db' => 'Server SQL', //to check
    'pb__db' => "Basis data",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Server basis data',
    'pb__dl_usr_ed' => "Administrator domain",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Batas domain",
    'pb__dom_pref' => "Pengaturan",
    'pb__dom_sum_report' => "Laporan Ringkas Domain",
    'pb__dom_templates' => "Template Domain",
    'pb__dom_traffic' => "Lalu-lintas %1",
    'pb__domains' => "Domain",
    'pb__domain_aliases' => 'Alias Domain',
    'pb__dumps_list' => "Penyimpanan Berkas Cadangan",
    'pb__forwarding_setup' => "Penataan Penerusan",
    'pb__filemanager' => "Pengelola File",
    'pb__ip_aliasing' => "Alamat IP",
    'pb__ip_clients' => "Penghapusan Alamat IP",
    'pb__license_management' => 'Informasi Lisensi',
    'pb__locales' => 'Bahasa lokal',
    'pb__log_files' => "File log",
    'pb__mail' => 'Surat',
    'pb__mail_name_files' => "File lampiran",
    'pb__mail_name_redirects' => "Penerus surat",
    'pb__mail_name_resp_attach_add' => "Lampiran baru",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Balasan otomatis surat",
    'pb__mail_names' => "Surat",
    'pb__maillists' => "Milis",
    'pb__modules' => 'Modul',
    'pb__modules_management' => 'Kelola Modul',
    'pb__notifications' => "Notifikasi",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Penataan hosting fisik",
    'pb__prtd_dirs' => "Direktori Terlindung",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Ubah suaikan",
    'pb__server' => "Server",
    'pb__sessions' => "Sesi",
    'pb__sapp_pool' => "Kumpulan Aplikasi Web",
    'pb__siteapp_install' => 'Pemasangan aplikasi web',
    'pb__site_app_pkgs' => 'Aplikasi Web',
    'pb__site_apps' => "Aplikasi Web",
    'pb__additional_key_info' => 'Properti Kunci',
    'pb__additional_key_properties' => 'Properti Kunci',
    'pb__skins' => 'Skin',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filter Spam",
    'pb__statistics' => "Statistik",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomain",
    'pb__templates' => "Template",
    'pb__virtualdirs' => 'Direktori virtual',
    'pb__web_users' => "Pengguna web",
    'pdir__invalid_hst' => "Tipe hosting tidak valid. Harus hosting fisik.",
    'pdir__pd_id_is_undefined' => "Direktori terlindung belum ditentukan.",
    'pdir__pdir_exist' => "Direktori dengan nama ini sudah dilindungi.",
    'pdir__pdir_not_exist' => "Direktori terlindung tidak ada.",
    'pdir__pdir_usr_not_exist' => "Pengguna direktori terlindung tidak ada.",
    'pdir__remove_pdir_usrs' => "Pengguna direktori terlindung %2 di bawah situs web %1 berikut akan dihapus:",
    'pdir__remove_pdir_usrs_on_subdom' => "Pengguna direktori terlindung %2 subdomain %1 akan dihapus:",
    'pdir__select_pdir_usrs_for_remove' => "Pilih pengguna direktori terlindung yang akan Anda hapus.",
    'pdir__select_pdirs_to_remove' => "Pilih direktori yang akan Anda hapus perlindungannya.",
    'pdir__unable_define_pdir_users' => "Tidak dapat menentukan pengguna direktori terlindung.",
    'pdir__unable_define_pdirs_properties' => "Tidak dapat mengatur properti direktori terlindung: %1",
    'pdir__unable_select_dom_param' => "Tidak dapat memilih parameter domain: %1",
    'pdir_ed__dir_already_protect' => "Direktori telah dilindungi.",
    'pdir_ed__invalid_login' => "Anda memasukkan nama pengguna yang salah.",
    'pdir_ed__login_exists' => "Pengguna ini sudah ada. Coba berikan nama pengguna lain.",
    'pdir_ed__pdir_users' => "Pengguna direktori terlindung",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Centanglah setidaknya satu kolom di kotak pilih SSL/TLS dan non-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Tidak dapat membuat pengguna direktori terlindung: %1",
    'pdir_ed__unable_create_pdir' => "Tidak dapat membuat direktori terlindung: %1",
    'pdir_ed__unable_define_hst_type' => "Tidak dapat menentukan tipe hosting.",
    'pdir_ed__unable_update_pdir' => "Tidak dapat menyimpan pengaturan direktori terlindung: %1",
    'pdir_ed__wrong_symbol_in_header' => "Penggunaan karakter %1 di judul direktori tidak diizinkan.",
    'pdir_usr_ed__not_create_pass' => "Tindakan ini tidak memberikan kata sandi untuk pengguna baru direktori terlindung. Pengguna tidak dapat masuk tanpa kata sandi.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Tidak dapat memilih pengguna direktori terlindung: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Tidak dapat menentukan pengguna direktori terlindung: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Tidak dapat menghapus pengguna direktori terlindung: %1",
    'phosting__anonftp_encrypt' => 'Kata sandi pengguna FTP terenkripsi, dan karena itu tidak dapat digunakan untuk melindungi direktori /plesk-stat/webstat/. Harap memasukkan kembali kata sandi FTP Anda, atau batalkan memilih opsi "dapat diakses melalui kata sandi direktori terlindungi \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Nama domain %%domain_name%% terungkap menjadi alamat IP %%dns_ip_address%%. Situs web Anda menugaskan alamat IP %%hosting_ip_address%%. Bila situs web Anda tidak terbuka di peramban web ketika Anda menuliskan nama domainnya, buka layar pengelolaan DNS (Domain > Nama Domain > DNS) dan ubah properti catatan sumber A: tugaskan alamat IP %%hosting_ip_address%% ke nama domain %%domain_name%%.",
    'phosting__ip_change_warning' => "Alamat IP telah diubah. Perubahan ini juga dilakukan di zona DNS domain.",
    'phosting__other_hosting_exists_on_ip' => "Tidak dapat mengubah sertifikat karena alamat IP telah digunakan di satu atau beberapa akun hosting lainnya.",
    'phosting__unable_to_change_certificate' => "Tidak dapat memasang sertifikat: %1",
    'phosting__unable_to_change_ip_address' => "Tidak dapat mengubah alamat IP: %1",
    'phosting__unable_to_set_cert' => "Tidak dapat mengatur sertifikat SSL/TLS: %1",
    'phosting__unable_update' => "Tidak dapat memperbarui pengaturan hosting: %1",
    'phosting__unable_manage' => "Tidak dapat mengelola hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Tidak dapat mengonfigurasi fail2ban untuk melacak log domain. Log akan secara otomatis dilacak lain kali saat layanan fail2ban dimulai lain.\n%1",

    'picker_acl_record__tittle' => 'Pilih catatan ACL',
    'picker_autoresponder__title' => 'Pilih Balasan Otomatis',
    'picker_black_list__domain_name' => 'Pilih Nama Domain',
    'picker_certificate' => 'Pilih sertifikat SSL/TLS',

    'picker_dns_zone_template__title' => 'Pilih Catatan Sumber',
    'picker_domain__title' => 'Pilih Situs Web',
    'picker_domain_alias__title' => 'Pilih Alias Domain',
    'picker_resource_record__title' => 'Pilih Catatan Sumber',
    'picker_disabled_resource_record__title' => 'Pilih Server Nama',
    'picker_ip_address__title' => 'Pilih Alamat IP',
    'picker_ip_address_clients__title' => 'Pilih Pelanggan yang Menggunakan Alamat IP Ini',
    'picker_mail_queue' => 'Pilih Pesan Surel',
    'picker_site_application__title' => 'Pilih Aplikasi Web',
    'picker_subdomain__title' => 'Pilih Subdomain',
    'picker_web_user__title' => 'Pilih Pengguna Web',
    'picker_custom_button__title' => 'Pilih Tombol Suai',
    'picker_license_key__title' => "Pilihan kunci lisensi",
    'picker_spamfilter_address__title' => 'Pilih Alamat Filter Spam',
    'picker_white_list__networks' => 'Pilihan jaringan',

    'plesk_key__action_logs' => "Pencatatan tindakan yang dilakukan pengguna Plesk",
    'plesk_key__app_vault' => "Brankas Aplikasi",
    'plesk_key__backup' => "Fungsi pencadangan dan pemulihan",
    'plesk_key__client_templs' => "Pengelolaan paket layanan",
    'plesk_key__clients' => "Akun pengguna (penyalur dan pelanggan)",
    'plesk_key__resellers_only' => "Akun pengguna (penjual kembali)",
    'plesk_key__customers_only' => "Akun pengguna (pelanggan)",
    'plesk_key__domains' => "Domain",
    'plesk_key__domain_aliases' => "Alias domain",
    'plesk_key__subdomains_limit' => "Subdomain",
    'plesk_key__databases' => "Basis data",
    'plesk_key__mssql_databases' => "Basis data MS SQL",
    'plesk_key__manage_dashboard' => 'Penyesuaian laman beranda',
    'plesk_key__drweb' => "Pengelolaan antivirus",
    'plesk_key__event_manager' => "Pengelola peristiwa",
    'plesk_key__expirations' => "Pengelolaan tanggal kedaluwarsa akun",
    'plesk_key__group_ops' => "Modifikasi beberapa objek sekaligus",
    'plesk_key__expiration' => "Tanggal kedaluwarsa kunci",
    'plesk_key__edition_name' => "Edisi Plesk",
    'plesk_key__key_number' => "Nomor kunci",
    'plesk_key__languages' => "Paket bahasa",
    'plesk_key__mailnames' => "Akun surat",
    'plesk_key__migration_manager' => "Pengelola Migrasi & Transfer",
    'plesk_key__mssql' => "Dukungan Server Microsoft SQL",
    'plesk_key__myplesk_func' => "Tautan pembelian sertifikat SSL/TLS dan layanan registrasi domain",
    'plesk_key__myplesk_server_id' => "Pengenal server slave MPC",
    'plesk_key__notifications' => "Pengelolaan notifikasi",
    'plesk_key__postgresql' => "Dukungan server basis data PostgreSQL",
    'plesk_key__qmail_queue' => 'Pengelolaan antrean surat',
    'plesk_key__remote_db' => 'Hosting basis data jauh',
    'plesk_key__slave_servers' => "Server slave",
    'plesk_key__spamassassin' => "Pengelolaan filter spam",
    'plesk_key__subdomains' => "Pengelolaan subdomain",
    'plesk_key__sys_access' => "Pengelolaan akses ke server",
    'plesk_key__traffic_reports' => "Laporan penggunaan lalu-lintas",
    'plesk_key__tts' => "Halaman Bantuan",
    'plesk_key__virtuozzo' => "Hanya valid untuk penggunaan penampung Virtuozzo",
    'plesk_key__webusers' => "Pengguna web",
    'plesk_key__cpu_cores' => 'Inti CPU',
    'plesk_key__ram' => 'Memori',
    'plesk_key__license_update_date' => 'Pembaruan kunci lisensi selanjutnya',
    'plesk_key__autoinstaller_config' => 'Pengelolaan perangkat pembaruan',
    'plesk_key__check_wrong' => "Kunci lisensi tidak valid. Untuk menggunakan Plesk, harap dapatkan dan pasang kunci lisensi yang valid.",
    'plesk_key__upload_check_wrong' => 'Kunci lisensi yang diunggah tidak valid.',
    'plesk_key__revert_check_wrong' => 'Kunci lisensi yang Anda pasang tidak valid.',
    'plesk_key__viruozzo_only_key' => 'Kunci lisensi hanya untuk penggunaan dengan Plesk yang dioperasikan di dalam penampung Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Anda dapat menggunakan salinan Plesk berlisensi ini hanya dengan alamat IP berikut: %2. Alamat IP berikut tidak tercakup oleh lisensi Anda: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Jumlah sumber daya yang digunakan saat ini melampaui batas yang ditentukan dalam lisensi Anda.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Jumlah situs web yang di-host di server melampaui batas yang telah ditetapkan di dalam lisensi Anda. Anda meng-host %2 situs; lisensi Anda hanya mengizinkan meng-host %1 situs.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Jumlah alias domain di server melampaui batas yang telah ditetapkan di dalam lisensi Anda. Anda mempunyai %2 alias domain; lisensi Anda hanya mengizinkan %1 alias domain.',
    'plesk_key__limits_exceeded_lim-subdom' => 'Jumlah subdomain di server melampaui batas yang telah ditetapkan di dalam lisensi Anda. Anda mempunyai %2 subdomain; lisensi Anda hanya mengizinkan %1 subdomain.',
    'plesk_key__limits_exceeded_lim-db' => 'Jumlah basis data di server melampaui batas yang telah ditetapkan di dalam lisensi Anda. Anda mempunyai %2 basis data; lisensi Anda hanya mengizinkan %1 basis data.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'Jumlah basis data MS SQL di server melampaui batas yang telah ditetapkan di dalam lisensi Anda. Anda mempunyai %2 basis data; lisensi Anda hanya mengizinkan %1 basis data.',
    'plesk_key__limits_exceeded_lim_cl' => 'Jumlah akun pelanggan yang dilayani melampaui batas yang ditetapkan di dalam lisensi Anda. Anda sedang melayani %2 akun pelanggan; lisensi Anda hanya mengizinkan melayani %1 akun pelanggan.',
    'plesk_key__limits_exceeded_lim_mn' => 'Jumlah akun surel yang dilayani melampaui batas yang ditetapkan di dalam lisensi Anda. Anda sedang melayani %2 akun surel; lisensi Anda hanya mengizinkan melayani %1 akun surel.',
    'plesk_key__limits_exceeded_lim_wu' => 'Jumlah akun pengguna web yang dilayani melampaui batas yang ditetapkan di dalam lisensi Anda. Anda sedang melayani %2 akun pengguna web; lisensi Anda hanya mengizinkan melayani %1 akun pengguna web.',
    'plesk_key__limits_exceeded_MLS' => 'Jumlah paket bahasa yang terpasang melampaui batas yang ditetapkan di dalam lisensi Anda. Ada %2 paket bahasa terpasang; lisensi Anda hanya mengizinkan memasang %1 paket bahasa.',
    'plesk_key__wrong_version' => 'Anda sedang mencoba menggunakan kunci lisensi yang dibuat untuk versi Plesk lain. Hubungi perwakilan penjualan Plesk untuk mendapatkan kunci lisensi yang benar.',
    'plesk_key__other_product' => 'Anda sedang mencoba menggunakan kunci lisensi yang dibuat untuk produk lain. Hubungi perwakilan penjualan Plesk untuk mendapatkan kunci lisensi yang benar.',
    'plesk_key__invalid_machine_id_trial' => 'Lisensi Anda saat ini tidak valid karena sudah diaktifkan di server Plesk lain. Untuk terus menggunakan Plesk, pasang lisensi baru atau pasang lisensi Anda saat ini sekali lagi dengan memasukkan kode aktivasi (jika ada).',
    'plesk_key__invalid_machine_id_retail' => 'Lisensi Anda saat ini tidak valid karena sudah diaktifkan di server Plesk lain. WebPros EULA (https://www.plesk.com/legal/) melarang penggunaan satu lisensi pada dua atau lebih server secara bersamaan. Untuk terus menggunakan Plesk, pasang lisensi baru atau pasang lisensi Anda saat ini sekali lagi dengan memasukkan kode aktivasi. Kode tersebut dikirimkan kepada Anda melalui email saat Anda membeli lisensi. <br>Tidak dapat menemukan kode aktivasi? Anda dapat mengambilnya menggunakan Plesk 360. Untuk melakukannya, masuk ke https://platform360.io/ dengan email yang Anda gunakan untuk membeli lisensi, buka tab "Licenses", dan lihat kode aktivasi lisensi Anda. Atau Anda dapat menghubungi dukungan Lisensi dan Pembelian Plesk menggunakan formulir online (https://www.plesk.com/licensing-and-purchase-support/). Ingatlah untuk menyebutkan nomor lisensi Anda di bagian "How can we help you?" bagian formulir.',
    'plesk_key__limits_exceeded_error' => 'Tidak dapat memasang kunci lisensi: Jumlah sumber daya yang digunakan melampaui batasan yang telah ditetapkan di dalam lisensi yang diunggah.',
    'plesk_key__limits_exceeded_note' => 'Jumlah sumber daya yang Anda gunakan melebihi batas yang telah ditetapkan di dalam kunci lisensi yang diunggah.',
    'plesk_key__hardware_limits_exceeded' => 'Konfigurasi perangkat keras melampaui batas yang ditentukan oleh lisensi Plesk Anda.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'Server memiliki memori terpasang %1, tetapi lisensi Anda mengizinkan tidak lebih dari %2.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'Server memiliki inti CPU terpasang %1, tetapi lisensi Anda mengizinkan tidak lebih dari %2.',
    'plesk_key__key_file_invalid' => 'File kunci yang diunggah tidak valid atau tidak berisi kunci lisensi.',
    'plesk_key__server_request_error' => 'Tidak dapat memperbarui lisensi. Pastikan koneksi ke server lisensi ka.plesk.com di port TCP %1 tidak diblokir. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Lihat cara melakukannya</a>.',
    'key__no_key_file_in_zip' => 'File .zip yang diunggah tidak berisi file kunci',
    'key__key_upload' => 'Pemasangan Kunci Lisensi',
    'additional_key__prop_name' => 'Properti',
    'additional_key__prop_value' => 'Nilai',
    'additional_key__descr_name' => 'Nama kunci',
    'additional_key__descr_key_number' => 'Nomor kunci',
    'additional_key__descr_key_vz' => "Kunci lisensi hanya untuk penggunaan penampung Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Kotak surat',
    'additional_key__descr_lim_date' => 'Tanggal kedaluwarsa',
    'additional_key__descr_license_update_date' => 'Pembaruan kunci lisensi selanjutnya',
    'additional_key__file_invalid' => 'File kunci yang diunggah tidak valid atau tidak berisi kunci lisensi.',
    'additional_key__file_incompatible' => 'File kunci yang diunggah tidak valid untuk aplikasi ini.',
    'additional_key__not_exists' => 'Kunci lisensi belum dipasang.',
    'additional_key_update__result_response' => 'Respons server lisensi: %1',
    'additional_key_update__result_network' => 'Tidak dapat terhubung ke server lisensi. Pastikan jaringan Anda membolehkan komunikasi ke %1: %2.',
    'additional_key_update__result_lock' => 'Pembaruan kunci sudah berlangsung',
    'additional_key_update__result_internal_error' => 'Galat terjadi ketika memperbarui kunci lisensi: %1',

    'proceed_to_cl_pool' => "Lanjutkan mengonfigurasi kumpulan IP pelanggan",
    'proceed_to_hosting_setup' => "Lanjutkan ke penataan hosting",
    'removeCerts__remove_certificates_cp' => "Sertifikat berikut akan dihapus:",
    'removeCerts__remove_certificates_domain' => "Sertifikat milik %1 berikut akan dihapus:",
    'removeClientsIP_remove_clients_ip' => "Alamat IP akan dihapus dari kumpulan pelanggan berikut:",
    'removeMailAliases__remove_mail_aliases' => "Alias surat untuk akun surat %1 berikut akan dihapus:",
    'removeMailNames__remove_mailnames' => "Akun dan alias surat berikut akan dihapus dari domain %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Akun dan alias surat berikut akan dihapus dari domain %2 milik pelanggan %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Akun surat berikut ini tidak akan dihapus.",
    'removeFtpSessions__remove_title' => "Sesi FTP berikut akan diakhiri:",
    'removeTemplates__remove_templates' => "Template berikut akan dihapus:",
    'resp_edit__always_respond' => "selalu merespons",
    'resp_edit__reply_subject' => "Subjek balasan",
    'resp_edit__answer_subject' => "Jawab dengan subjek",
    'resp_edit__answer_txt' => "Balas dengan teks",
    'resp_edit__attach' => "Lampirkan file",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "untuk",
    'resp_edit__frw_rqst_email' => "Pada mode balasan otomatis, teruskan pesan asli ke surel yang telah ditentukan",
    'resp_edit__fwd_email_invalid' => "Alamat surel tujuan tidak valid.",
    'resp_edit__in_body' => "ketika kata-kata tertentu ditemukan di dalam badan pesan",
    'resp_edit__in_subject' => "ketika kata-kata tertentu ditemukan di dalam subjek pesan",
    'resp_edit__invalid_resp_freq' => "Frekuensi respons tidak valid.",
    'resp_edit__invalid_rqst_txt' => "Teks permintaan tidak valid.",
    'resp_edit__invalid_store_lim_num' => "Nilai batas tidak valid.",
    'resp_edit__limits_title' => "Batas",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Jumlah respons maksimum per hari melampaui tingkat yang ditentukan. Yang diizinkan: %1, yang diminta: %2",
    'resp_edit__no_files_sel' => "Tidak ada file yang dipilih.",
    'resp_edit__no_txt_supplied' => "Teks belum diberikan.",
    'resp_edit__reply_title' => "Balas",
    'resp_edit__reply_to_address' => "Alamat balasan",
    'resp_edit__reply_to_invalid' => "Alamat balasan tidak valid.",
    'resp_edit__reply_uniq_email' => "Balas ke alamat surel unik tidak lebih dari",
    'resp_edit__conditions_title' => "Kondisi",
    'resp_edit__request_title' => "Permintaan",
    'resp_edit__resp' => "Balasan otomatis",
    'resp_edit__resp_name' => "Nama balasan otomatis",
    'resp_edit__resp_not_exist' => "Balasan otomatis tidak ada.",
    'resp_edit__resp_status' => "Status balasan otomatis",
    'resp_edit__rqst_txt' => 'Tetapkan kondisi untuk balasan otomatis ini',
    'resp_edit__select_files_on_server_for_attach' => "Pilih file yang akan Anda lampirkan",
    'resp_edit__store_up_to' => "Simpan sampai mencapai",
    'resp_edit__subj_line_invalid' => "Baris subjek salah.",
    'resp_edit__text_too_big' => "Teks pesan balasan terlalu besar.",
    'resp_edit__times_in_a_day' => "kali per hari.",
    'resp_edit__unable_define_resp_cond' => "Tidak dapat menentukan kondisi balasan otomatis: %1",
    'resp_edit__unable_define_resp_status' => "Tidak dapat menentukan status balasan otomatis: %1",
    'resp_edit__unable_turn_on_resp' => "Tidak dapat menghidupkan balasan otomatis: %1",
    'resp_edit__uniq_email' => "Alamat surel unik",
    'resp_edit__content_type' => 'Format pengiriman surat',
    'resp_edit__content_type_text' => 'Teks biasa',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Penyandian',
    'restart__dns' => 'Server DNS (%1)',
    'restart__drweb' => 'Antivirus Plesk Premium',
    'restart__mail' => "Server IMAP/POP3 (%1)",
    'restart__mssql' => "Server Microsoft SQL",
    'restart__mysql' => "Server MariaDB/MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Layanan",
    'restart__smtp' => "Server SMTP (%1)",
    'restart__spamd' => "Filter Spam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Server Web (%1)",
    'restart__ftp' => "Server FTP (%1)",
    'restart__service_start' => 'Berikan waktu bagi layanan untuk memulai.',
    'restart__service_stop' => 'Berikan waktu bagi layanan untuk berhenti.',
    'restart__service_restart' => 'Berikan waktu bagi layanan untuk mulai ulang.',
    'rm_domains__some_domains_are_not_exist' => "Beberapa domain yang diberikan tidak ada. Kemungkinan sudah dihapus oleh pengguna lain.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Penerus",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Laporan untuk administrator %1",
    'rpt_cl_report_for_reseller__' => "Laporan untuk penyalur %1",
    'rpt_cl_report_for_cl__' => "Laporan pelanggan %1",
    'rpt_cl_section_domains' => "Domain",
    'rpt_cl_section_full_domains' => "Domain",
    'rpt_cl_section_general' => "Umum",
    'rpt_create' => "Buat laporan",
    'rpt_empty' => "Laporan harus berisi paling tidak satu bagian",
    'rpt_dom_report_for_dom__' => "Laporan domain untuk %1",
    'rpt_dom_section_databases' => "Basis data",
    'rpt_dom_section_full_databases' => "Basis data",
    'rpt_dom_section_full_maillists' => "Milis",
    'rpt_dom_section_full_mailnames' => "Akun surat",
    'rpt_dom_section_full_webusers' => "Pengguna web",
    'rpt_dom_section_full_siteapps' => 'Aplikasi web',
    'rpt_dom_section_full_aspnetapps' => 'Aplikasi web ASP.NET',
    'rpt_dom_section_general' => "Umum",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Milis",
    'rpt_dom_section_mailnames' => "Akun surat",
    'rpt_dom_section_siteapps' => 'Aplikasi web',
    'rpt_dom_section_aspnetapps' => 'Aplikasi web ASP.NET',
    'rpt_dom_section_webusers' => "Pengguna web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Sunting laporan %1",
    'rpt_enter_email_address' => "Masukkan alamat surel tujuan pengantaran laporan.",
    'rpt_list' => "Tata letak laporan suai",
    'rpt_section_full' => "Penuh",
    'rpt_section_none' => "Tidak ada",
    'rpt_section_summary' => "Ringkasan",
    'rpt_default_full' => 'Laporan Lengkap',
    'rpt_default_summary' => 'Laporan Ringkas',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Kesalahan dalam pengiriman laporan: %1",
    'rpt_send_report_by_email_ok__' => "Laporan terkirim ke %1",
    'sa_action' => "Tindakan",
    'sa_action_del' => "Hapus",
    'sa_action_desc' => "Apa yang harus dilakukan dengan surat spam",
    'sa_action_save' => "Tandai sebagai spam dan simpan di kotak surat",
    'sa_admin_blacklist' => "Daftar hitam administrator",
    'sa_admin_whitelist' => "Daftar putih administrator",
    'sa_db_del_confirm' => "Apakah Anda yakin ingin membersihkan basis data Filter Spam?",
    'sa_eml_in_ignorelist' => "Surel termasuk di dalam daftar abai",
    'sa_empty_email' => "Pola surel kosong tidak dapat ditambahkan.",
    'sa_exists_email' => "Pola surel sudah ada.",
    'sa_disabled__mailname_not_filtering' => "Pengaturan server saat ini tidak membolehkan penggunaan filter surat untuk akun surat ini",
    'sa_disabled__filtering_is_disabled' => 'Filter spam dimatikan oleh administrator server',
    'sa_disabled__hasnt_mailbox' => "Mustahil menghidupkan filter spam tanpa kotak surat",
    'sa_enable_filter' => "Hidupkan filter spam",
    'sa_forget' => "lupakan",
    'sa_from' => "Dari",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Pola tidak valid.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Pelatihan filter spam',
    'sa_trainer__tools_legend' => 'Alat',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Pesan di dalam kotak surat Anda',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Subjek',
    'sa_trainer__from' => 'Dari',
    'sa_trainer__date' => 'Tanggal',
    'sa_trainer__info_text' => 'Pesan dipelajari: %1 sebagai spam, %2 sebagai non-spam, %3 total.',
    'sa_trainer__messages' => 'pesan',
    'sa_trainer__select__all' => 'Semua',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Non-Spam',
    'sa_trainer__select__unknown_only' => 'Tidak dikenal',
    'sa_trainer__cannot_remove_messages' => 'Pesan yang dipilih tidak dapat dihapus dari kotak surat.',
    'sa_trainer__remove_messages_confirm' => 'Apakah Anda akan menghapus pesan terpilih dari kotak surat?',
    'sa_subj' => "Subjek",
    'sa_training' => "Pelatihan filter spam",
    'sa_training_legend' => "Pelatihan filter Bayesian",
    'sa_use_srv_settings' => "Gunakan pengaturan seluruh server",
    'sa_user_blacklist' => "Daftar hitam pengguna",
    'sa_user_whitelist' => "Daftar putih pengguna",
    'sa_usr_disabled_by_srv' => "Pengaturan filter spam perorangan tidak diizinkan oleh administrator server",
    'sa_usr_no_postbox' => "Tidak dapat mengaktifkan filter spam karena kotak surat dimatikan untuk akun email ini.",
    'sa_filters' => 'Filter spam',
    'spamfilter__tools_legend' => 'Alat',
    'spamfilter__prefs_legend' => 'Pengaturan',
    'spamfilter__max_children' => 'Jumlah maksimum proses worker spamd yang dijalankan',
    'spamfilter__rewrite_header_subject_hint' => 'Biarkan kolom ini kosong jika Anda tidak ingin menambahkan teks. Ketik _SCORE_ jika Anda akan menyertakan nilai ke subjek pesan.',
    'spamfilter__reject_spam' => 'Hapus surat spam ketika masuk ke kotak surat',
    'spamfilter__enabled' => 'Dihidupkan',
    'spamfilter_addresses_list__items' => 'Alamat',
    'spamfilter_addresses__remove_title' => 'Alamat berikut akan dihapus dari daftar:',
    'spamfilter_addresses__empty_selection' => 'Tidak ada alamat dipilih.',
    'server__admin_info' => "Informasi administrator",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Masukkan deskripsi bug di bawah ini",
    'server__power_management' => "Pengelolaan daya",
    'server__services' => "Layanan",
    'server__system' => "Sistem",
    'server__title' => "Administrasi Server",
    'server_preferences__admin_skin' => "Skin antarmuka administrator",
    'server_preferences__default_language' => "Bahasa default",
    'server_preferences__default_skin' => "Skin default",
    'server_preferences__restart_apache_interval' => "Interval mulai ulang Apache",
    'server_preferences__system' => 'Pengaturan Sistem',
    'mail__tabs_preferences' => "Pengaturan",
    'mail__tabs_white_list' => "Daftar Putih",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Periksa kata sandi untuk kotak surat di dalam kamus",
    'sessions__agreement' => "Ya, saya ingin mengakhiri sesi ini.",
    'sessions__select_sessions_for_remove' => "Pilih sesi yang akan Anda akhiri.",
    'sessions__tabs_cp_sessions' => 'Sesi Plesk',
    'sessions__tabs_ftp_sessions' => 'Sesi FTP',
    'sessions__ftp_sessions_login' => 'Nama pengguna akun FTP',
    'sessions__ftp_sessions_domain' => 'Nama domain',
    'sessions__ftp_sessions_path' => 'Lokasi saat ini',
    'sessions__ftp_sessions_file' => 'Nama file',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Kecepatan, KB/s',
    'sessions__ftp_sessions_comp' => 'Kemajuan, %',

    'site_apps__access_level' => 'Level akses',
    'site_apps__access_level_commercial' => 'Komersial',
    'site_apps__access_level_free' => 'Gratis',
    'site_apps__action_installer' => "Pemasangan aplikasi web",
    'site_apps__action_reconfigure' => "Konfigurasi ulang aplikasi web",
    'site_apps__custom_button_level' => 'Apakah Anda akan membuat tombol suai untuk mengakses aplikasi ini?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Tidak',
    'site_apps__custom_button_level_domain_user_only' => 'Ya',
    'site_apps__custom_button_level_false' => 'Tidak',
    'site_apps__custom_button_level_domain' => 'Ya, dan sediakan untuk domain ini saja',
    'site_apps__custom_button_level_client' => 'Ya, dan sediakan untuk seluruh domain pelanggan',
    'site_apps__custom_button_level_admin' => 'Ya, dan sediakan untuk seluruh domain',
    'site_apps__description' => "Deskripsi",
    'site_apps__dir_used_by_sapp__' => "Direktori \"%1\" digunakan aplikasi web yang lain",
    'site_apps__dir_used_by_unknown__' => "Direktori \"%1\" sudah ada. Isi direktori akan ditimpa jika Anda lanjutkan.",
    'site_apps__dir_invalid_name__' => "Nama direktori %1 salah",
    'site_apps__file_name' => 'Nama file aplikasi web',
    'site_apps__invalid_install_prefix' => "Prefiks pemasangan tidak valid",
    'site_apps__invalid_package' => "Aplikasi web tidak valid",
    'site_apps__key_status' => 'Perizinan',
    'site_apps__key_status_free' => 'Didistribusikan dengan bebas. Tidak membutuhkan kunci lisensi',
    'site_apps__key_status_ok' => 'Kunci lisensi yang dibutuhkan telah dipasang',
    'site_apps__key_status_problem' => 'Kunci lisensi yang dibutuhkan belum dipasang',
    'site_apps__name' => "Nama",
    'site_apps__no_domains' => 'Aplikasi web tidak dapat dipasang. Ada aplikasi web lain yang sudah terpasang di direktori root domain ini. Disarankan untuk membuat subdomain untuk aplikasi web.',
    'site_apps__package_info_' => "Informasi Aplikasi Web",
    'site_apps__package_integrated' => "Aplikasi built-in, tidak dapat dihapus",
    'site_apps__pool_select_packages_to_add' => 'Pilih aplikasi web yang akan Anda tambahkan ke dalam kumpulan',
    'site_apps__release' => "Rilis",
    'site_apps__resource_used_by_sapp' => "Sumber daya ini digunakan oleh aplikasi web yang terpasang",
    'site_apps__root_used_by_sapp' => "Sumber daya ini digunakan oleh aplikasi web yang terpasang",
    'site_apps__these_domains_will_not_delete' => 'Subdomain berikut tidak diizinkan untuk dihapus',
    'site_apps__upload_site_app_pkg_title' => 'Unggah aplikasi web baru',
    'site_apps__version' => "Versi",
    'site_apps__access_to' => "Akses ke %1",
    'site_builder_requires' => '%1-%3',
    'skeleton__archiver_not_installed' => "Arsip tidak dapat dibongkar. Mungkin pengarsip belum dipasang di server. Hubungi administrator {$PROD_NAME} untuk memasang perangkat lunak pengarsip.",
    'skeleton__archive_corrupted' => "Pemeriksaan arsip menemukan kerusakan file arsip atau tipe arsip tidak didukung.",
    'skeleton__archive_too_large' => "Pemeriksaan arsip menemukan bahwa file arsip terlalu besar.",
    'skeleton__not_supported_archive_type' => "Tipe arsip (file %1) tidak didukung.",
    'skin_download__title' => 'Unduh Skin',
    'skin_download_now__title' => 'Pengunduhan skin sedang berlangsung.',
    'skin_download_now__text' => 'Proses pembuatan paket skin sedang berlangsung.<br>Prosedur ini membutuhkan waktu yang cukup lama.<br> Apabila jendela dialog telah muncul kembali, Anda dapat melanjutkan bekerja menggunakan Plesk.',
    'skin_file__help_for_using_types' => "Mohon gunakan format arsip skin berikut:",
    'skin_info__title' => 'Properti Skin',
    'skin_mng_err__rpm_not_skin' => 'RPM ini bukan paket skin Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Gagal memasang skin berbasis-rpm dalam lokasi tertentu.',
    'skin_mng_err__already_exists' => 'Direktori instalasi skin sudah ada, dan terdapat paket skin yang disebarkan.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'File yang diunggah bukan paket skin RPM yang valid.',
    'skin_mng_err__rpm_upgrade_noskin' => 'File yang diunggah bukan paket skin yang valid.',
    'skin_mng_err__rpm_upgrade_base' => "File yang diunggah bukan paket skin {$PROD_NAME} yang valid.",
    'skin_mng_err__rpm_upgrade_other' => 'Tidak dapat memasang skin: format skin invalid.',
    'skin_mng_err__no_a_skin' => "File yang diunggah bukan paket skin {$PROD_NAME} yang valid.",
    'skin_upload__title' => 'Unggah Skin Baru',
    'skin_upload__already_exists' => "Skin '%1' sudah ada.",
    'skin_upload__unable_to_apply' => "File yang diunggah tidak berisi skin Plesk, atau format tidak didukung.",
    'skin_upload__unable_to_rename__' => "Tidak dapat mengganti nama skin %2 ke %1: %3.",
    'skin_upload__file_name' => 'Jalur ke file paket skin',
    'skins_list__title' => 'Repositori Skin',
    'skins_remove__title' => 'Penghapusan Skin',
    'skins_remove__select_skins_for_remove' => 'Pilih skin yang akan dihapus',

    'spf__unable_update' => 'Tidak dapat memperbarui parameter SPF',
    'statistics__active_domains' => "Domain aktif",
    'statistics__clients' => "Pelanggan",
    'statistics__subdomains' => "Subdomain",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Basis data",
    'statistics__db_users' => "Pengguna basis data",
    'statistics__dirs' => "Direktori terlindung",
    'statistics__dom_active' => "Aktif",
    'statistics__dom_passive' => "Pasif",
    'statistics__dom_problem' => "Masalah",
    'statistics__domains' => "Domain",
    'statistics__domains_with_host' => "Domain dengan hosting",
    'statistics__doms' => "Domain",
    'statistics__filesystem' => "Sistem file",
    'statistics__general' => "Umum",
    'statistics__hdd_available' => "Tersedia",
    'statistics__hdd_capacity' => "Kapasitas",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Penggunaan Hard Disk",
    'statistics__hdd_used' => "Digunakan",
    'statistics__ip' => "Alamat IP",
    'statistics__key_number' => "Nomor kunci",
    'statistics__l1' => "1 menit terakhir",
    'statistics__l15' => "15 menit terakhir",
    'statistics__l5' => "5 menit terakhir",
    'statistics__la' => "Penggunaan CPU",
    'statistics__mail_autoresponders' => "Balasan otomatis",
    'statistics__mail_boxes' => "Kotak surat",
    'statistics__mail_groups' => "Kelompok surat",
    'statistics__mail_lists' => "Milis",
    'statistics__mail_redirects' => "Penerus surat",
    'statistics__mem' => "Penggunaan Memori",
    'statistics__mem_usage' => "Penggunaan",
    'statistics__memory_available' => "Tersedia",
    'statistics__memory_buffer' => "Penyangga",
    'statistics__memory_cached' => "Di-cache",
    'statistics__memory_free' => "Kosong",
    'statistics__memory_shared' => "Berbagi",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Digunakan",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Pelanggan bermasalah",
    'statistics__problem_domains' => "Domain bermasalah",
    'statistics__swap' => "Penggunaan Swap",
    'statistics__swap_free' => "Kosong",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Penggunaan",
    'statistics__swap_used' => "Digunakan",
    'statistics__system_stat' => "Informasi Server",
    'statistics__unable_define_active_doms' => "Tidak dapat menentukan jumlah domain aktif: %1",
    'statistics__unable_define_inactive_doms' => "Tidak dapat menentukan jumlah domain tidak aktif: %1",
    'statistics__failed_define_swap_usage' => 'Gagal untuk menentukan Penggunaan Swap',
    'statistics__failed_define_load_averages' => 'Gagal untuk menentukan Beban Rata-Rata',
    'statistics__up_time' => "Waktu Sistem Beroperasi:",
    'statistics__ver' => "Versi",
    'statistics__web_users' => "Pengguna web",
    'statistics__mem_win' => "Penggunaan Memori Fisik",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Digunakan",
    'statistics__memory_free_win' => "Tersedia",
    'statistics__swap_win' => "Penggunaan Memori Virtual",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Digunakan",
    'statistics__swap_free_win' => "Tersedia",
    'status__domain_has_reasons_to_be_off' => "Domain ditangguhkan karena alasan berikut: %1",
    'subdomain__create__' => "Buat subdomain di dalam domain %1",
    'subdomain__edit__' => "Kelola subdomain %1",
    'subdomain__invalid_name' => "Nama subdomain tidak valid: gunakan hanya alfanumerik dan tanda penghubung.",
    'subdomain__incorrect_name' => "Nama subdomain tidak valid.",
    'subdomains__maillists_enabled_in_domain' => "Nama subdomain list.%1 salah: nama domain ini telah digunakan oleh milis di bawah domain %1.",
    'subdomains__dalias_exists' => 'Alias domain dengan nama tersebut sudah ada.',
    'subdomains__name_exists' => "Subdomain dengan nama tersebut sudah ada.",
    'subdomains__regular_domain_exists' => "Domain dengan nama tersebut sudah ada.",
    'subdomains__domain_alias_exists' => 'Alias domain dengan nama tersebut sudah ada.',
    'subdomains__remove_subdomains_on_domain' => "Subdomain untuk domain %1 berikut akan dihapus:",
    'subdomains__select_subdomains_for_remove' => "Pilih subdomain yang akan Anda hapus.",
    'subdomains__webmail_enabled_in_domain' => "Nama subdomain webmail.%1 salah: Nama domain ini telah digunakan untuk mengakses webmail di bawah domain %1.",
    'subdomains__dns_record_already_exists' => 'Tidak dapat membuat subdomain %1 karena telah ada catatan DNS yang menunjuk pada host %1.',
    'subdomains__www_prefix_in_domain' => "Nama subdomain www.%1 salah: Domain %1 telah menggunakan prefiks WWW.",
    'subdomains__user_type_quota_exceeds' => 'Tidak dapat mengubah akun pengguna karena hasilnya akan melebihi alokasi ruang disk.',
    'subdomains__creation_in_dns_slave' => "Server nama Plesk hanya bertindak sebagai server nama sekunder untuk domain ini. Agar subdomain Anda dapat mengungkap dengan benar, pastikan file zona di dalam server utama mengandung catatan %1.",
    'sys_user__attributes_not_changed' => "\nAtribut pengguna sistem berikut tidak diubah: %1",
    'sys_user__no_access_without_password' => "Anda belum membuat kata sandi. Pengguna sistem akan dibuat, tapi tidak akan dapat masuk ke sistem, sebelum pengguna diberi kata sandi. Apakah Anda akan melanjutkan?",
    'sys_user__no_hard_quota' => "Tidak didukung",
    'sysuser__zero_quota_is_unlimited' => "0 untuk tak terbatas",
    'template__num_excl_ips' => "Alokasikan alamat IP khusus ke pelanggan",
    'template__sel_sh_ips' => "Alamat IP bersama yang dipilih",
    'template__av_sh_ips' => "Alamat IP bersama yang tersedia",
    'template__up_to_excl_ip' => "Sampai %1 alamat IP",
    'templates__all_clients' => "Semua pelanggan",
    'templates__cl_domain_templates' => "Template untuk %1",
    'templates__cl_templates' => "Template Pelanggan",
    'time__invalid_ip' => "Alamat IP atau nama domain tidak valid.",
    '__please_select_country' => 'Silakan memilih negara Anda',
    'time__unable_set_time' => "Tidak dapat mengatur waktu sistem: %1",
    'time__sinchronization_setup_error' => 'Tidak dapat mengatur sinkronisasi waktu: pengelolaan waktu gagal: %1',
    'time__sinchronization_disable_error' => 'Tidak dapat menonaktifkan sinkronisasi waktu: pengelolaan waktu gagal: %1',
    'tmpl__create' => "Buat template",
    'tmpl__edit__' => 'Template %1',
    'tmpl__logrotation_warn' => "Rotasi log pada domain yang dibuat menggunakan template ini hanya akan dilakukan jika ada pembuatan akun hosting fisik berikutnya pada domain.",
    'tmpl__name' => "Nama template",
    'tmpl__dom_exist' => "Template domain dengan nama itu sudah ada di kumpulan template administrator dan pelanggan.",
    'tmpl__name_invalid' => "Nama template tidak valid atau kosong.",
    'tmpl__use_next_ip_addr' => "Alamat IP kosong selanjutnya akan digunakan",
    'tmpl_name_already_exists' => "Template dengan nama '%1' sudah ada.",
    'traffic__no_periods_found' => "Tidak dapat menampilkan statistik web dan lalu-lintas. Fungsi ini hanya akan tersedia setelah kalkulasi statistik selanjutnya.",

    'vh_based__no_free_ip_for_vh' => "Tidak ada alamat IP yang kosong untuk hosting virtual berbasis-IP. Harap menambah alamat IP.",

    'wu__at_domains_text' => "Membolehkan format akses webuser@%1",
    'wu__unable_create' => "Tidak dapat membuat pengguna web: %1",
    'wu_edit__disk_quota' => "Kuota disk",
    'wu_edit__invalid_pass' => "Kata sandi invalid.",
    'wu_edit__invalid_quota' => "Nilai kuota ruang disk yang diberikan invalid. Harap memasukkan bilangan bulat positif.",
    'wu_edit__invalid_quota_value' => "Kuota ruang disk yang ditentukan kurang dari yang terpakai saat ini (%1MB). Beberapa fungsi mungkin tidak tersedia. Apakah Anda yakin ingin melanjutkan?",
    'wu_edit__not_create_pass' => "Tindakan ini tidak akan membuat kata sandi untuk pengguna baru. Pengguna tidak dapat masuk tanpa kata sandi.",
    'wu_edit__unable_update' => "Tidak dapat membuat pembaruan properti pengguna web: %1",

    'dns__tabs_general' => 'Pengaturan Zona',
    'dns__tabs_zone_settings' => 'Catatan SOA',
    'soa__seconds' => 'detik',
    'soa__minutes' => 'menit',
    'soa__hours' => 'jam',
    'soa__days' => 'hari',

    'DomainSubdirectory' => 'Subdirektori Tujuan',

    'filemanager__select_codepage' => 'Piliha Codepage:',

    'bt_server_app_add' => 'Tambah Aplikasi Server',
    'packages_list' => 'Aplikasi Server',

    'bt_packages_management' => 'Pengelolaan Paket',
    'pb__packages_management' => 'Pengelolaan Aplikasi',
    'bt_package_new' => 'Tambah Aplikasi Baru',
    '__packages' => 'Aplikasi Server',

    'dom_ctrl__mysql_dbase_space' => 'Kuota total basis data MariaDB/MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Kuota total basis data MS SQL',

    'dns_add__enter_ixfr_path' => 'Masukkan Jalur IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Catatan SPF TXT sudah ada. Hanya boleh ada satu rekaman SPF. Untuk menambahkan catatan baru, hapus catatan yang sudah ada sebelumnya.',

    'component_name__network' => 'Jaringan',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Atur Skin',
    'bt_set_skin' => 'Atur Skin',
    'firewall__rule_already_exists' => 'Aturan dengan nama "%1" sudah ada',
    'firewall__rule_readonly' => 'Aturan "%1" hanya untuk dibaca',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Perlindungan antivirus',
    'antivirus__antivirus_direction_off' => 'Dimatikan',
    'antivirus__antivirus_direction_any' => 'Surat masuk dan keluar',
    'antivirus__antivirus_direction_from' => 'Surat keluar saja',
    'antivirus__antivirus_direction_to' => 'Surat masuk saja',
    'antivirus__unable_to_update_settings' => 'Tidak dapat mengubah pengaturan antivirus: %1',




    '__normal' => 'Normal',
    '__low' => 'Rendah',
    '__high' => 'Tinggi',

    'mail__antivirus' => "Antivirus mailserver internal",
    'mail__use_internal_antivirus' => 'Gunakan antivirus internal',

    'sa__tabs_blacklist' => 'Daftar Hitam',

    '__mysql_databases' => 'Basis data MariaDB/MySQL',

    'cl_perm__mysql_dbase_space' => 'Kuota total basis data MariaDB/MySQL',
    'cl_perm__mssql_dbase_space' => 'Kuota total basis data MS SQL',
    'cl_perm__max_mssql_db' => 'Jumlah basis data Server Microsoft SQL maksimum',
    'cl_perm__total_mboxes_quota' => 'Kuota total kotak surat',

    'i_i_cl_on' => 'Akun pelanggan aktif.',
    'i_i_cl_off_by_admin' => 'Akun pelanggan ditangguhkan oleh administrator.',

    'sa_exists_tn' => 'Jaringan sudah ada di dalam daftar.',

    'defaultcomponents__not_activated' => 'tidak diaktifkan',

    'bt_traffic_at_domains' => 'Lalu-lintas',

    '__awstats_perl_warning' => 'Jika Perl tidak terpasang, AWStats tidak akan membolehkan pengguna mengecek statistik tahun sebelumnya.',

    'class_client__mysql_dbase_space' => 'Nilai melebihi batas pelanggan.',
    'class_client__mssql_dbase_space' => 'Nilai melebihi batas pelanggan.',
    'class_client__max_mssql_db' => 'Nilai melebihi batas pelanggan.',

    'dns__remove_transfer_restrictions_list_items' => 'Jaringan berikut akan dihapus dari daftar kontrol akses:',

    'bt_up' => "Naik",
    'bt_down' => "Turun",

    'bt_install_selected' => 'Pasang Kunci Lisensi Terpilih', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Domain terungkap ke alamat IP lain: (%1). Harap memperbaiki pengaturan DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Server surat yang sedang digunakan saat ini tidak mendukung kotak surat dan kelompok surat yang hidup secara bersamaan. Tekan OK untuk menghidupkan kotak namun akan mematikan kelompok surat. Tekan Batal untuk meninggalkan semuanya utuh.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Server surat yang sedang digunakan saat ini tidak mendukung kotak surat dan kelompok surat yang hidup secara bersamaan. Tekan OK untuk menghidupkan kelompok surat namun akan mematikan kotak surat. Tekan Batal untuk meninggalkan semuanya utuh.',

    'mysql_dbase_space_limit' => 'Batas ruang basis data MariaDB/MySQL',
    'mysql_dbase_usage' => 'Penggunaan ruang basis data MariaDB/MySQL',
    'mssql_dbase_space_limit' => 'Batas ruang basis data Server Microsoft SQL',
    'mssql_dbase_usage' => 'Penggunaan ruang basis data Server Microsoft SQL',

    '__statistics' => "statistik", //indirect

    'dns__soa_minimum_value_is_big' => 'Pengaturan nilai TTL Minimum yang lebih dari 3 jam dapat membuat domain Anda tidak dapat diakses oleh beberapa administrator domain. Direkomendasikan untuk menetapkan nilai tersebut hanya bila registrar nama domain Anda memaksa hal tersebut.',

    'virusfilter__interface_not_available' => 'Filter virus tidak tersedia.',
    'virusfilter__none_virus_filter' => 'Tidak ada',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'dimatikan',
    'virusfilter__status_any' => 'surat masuk dan keluar',
    'virusfilter__status_outgoing' => 'hanya surat keluar',
    'virusfilter__status_incoming' => 'hanya surat masuk',

    'visibility__root_override_parse_error' => 'Kesalahan sintaksis di file %1 baris %2.',

    'sb__not_support_publishing_api' => "Otomatisasi penerbitan tidak didukung oleh komponen",

    'component_name__cphosting' => "Hosting Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Pengaturan kuota kotak surat tidak didukung oleh server surat saat ini.',
    '__unable_get_total_mboxes_quota' => 'Pengaturan kuota kotak surat tidak didukung oleh server surat saat ini.',

    'install_prefix__parent_not_exists' => "Direktori induk tidak ada",

    'bt_change_version' => 'Ubah Versi',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Pilih Semua",
    '__uncheck_all' => "Kosongkan Semua",

    'dns__editing_domain_controller_zone' => "Penyuntingan catatan zona DNS untuk pengontrol domain dapat menyebabkan masalah dalam fungsi domain",

    'pb__interface_management' => "Pengelolaan Antarmuka",
    'interface_management__tabs_skins' => "Skin",
    'interface_management__tabs_interface_templates' => "Template Antarmuka",
    'interface_management__tabs_locales' => "Bahasa lokal",
    'locales_list__title' => "Repositori paket bahasa",
    'locales_list__legend' => "Bahasa yang tersedia",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Paket bahasa",
    'locales_list__lang_title' => "Bahasa",
    'locales_list__country_title' => "Negara",
    'locales_list__used_title' => "Digunakan",

    'backup__suspend_warning_during_backup' => "Domain tidak tersedia selama proses pencadangan",
    'backup__suspend_warning_during_restore' => "Domain tidak tersedia selama proses pemulihan",
    'backup__suspend_domain' => "Tangguhkan domain",

    'locales_list__mls_limit' => "Lisensi Plesk Anda saat ini mengizinkan penggunaan %2 bahasa. Saat ini, Anda memiliki %1 set bahasa yang tersedia untuk pengguna, yang melebihi jumlah yang disediakan oleh lisensi. Harap memilih %2 bahasa yang ingin Anda gunakan, dan jadikan sisanya tidak tersedia untuk pengguna dengan mengklik ikon mereka di kolom 'S'.",

    'bt_change_owner' => 'Tunjuk Pemilik Baru',
    'chown__new_owner' => 'Pemilik baru',
    'chown__selected_domains' => 'Langganan yang dipilih',
    'chown__limits_legend' => 'Sumber daya',
    'chown__limit_name' => 'Nama sumber daya',
    'chown__limit_value' => 'Sumber daya yang dialokasikan',
    'chown__limit_assigned_before' => 'Sebelum transfer',
    'chown__limit_assigned_after' => 'Sesudah transfer',
    'chown__error_limits' => "Tidak dapat meneruskan transfer langganan: langganan ini memerlukan sumber daya lebih banyak dari yang bisa disediakan oleh penyedia layanan pemilik baru.",
    'chown__error_no_domains' => 'Tidak dapat meneruskan transfer langganan: karena tidak ada langganan yang dipilih, atau langganan yang dipilih sudah dimiliki oleh pengguna target.',
    'chown__error_empty_ip_pool' => "Tidak dapat meneruskan transfer langganan: kumpulan IP dari penyedia layanan pemilik baru kosong. Harap memastikan penyedia layanan sedikitnya memiliki satu alamat IP dalam kumpulannya.",
    'chown__please_select_new_domain_owner' => 'Pilih pemilik baru untuk langganan ini',
    'chown__old_ip_address' => 'Alamat IP saat ini',
    'chown__new_ip_address' => 'Alamat IP baru',

    'chown__error_ssl_already_used' => "Dukungan SSL/TLS sudah digunakan di IP tujuan berikut: %1 Dengan demikian, domain dengan dukungan SSL/TLS berikut tidak dapat ditransfer: %2. Harap selesaikan masalah dan coba lagi",
    'chown__sitebuilder_not_installed' => 'Presence Builder tidak dipasang',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domain %1 tidak dapat ditransfer ke pemilik lain karena Presence Builder tidak dipasang.',

    'backup__backup_time' => 'Waktu pencadangan',
    'backup__backup_time_hour' => 'jam',
    'backup__backup_time_minute' => 'menit',
    'backup__every' => 'setiap',
    'backup__day_of_month' => 'Hari dalam bulan',

    'subdomain__select_hst_type' => 'Pilih tipe hosting subdomain',
    'hst_sel__subdom_subfolder_hst' => 'Subdomain di subfolder',
    'subdomain__www_root_folder_not_exists' => 'Direktori beranda situs %1 tidak ada',
    '__site_home_dir' => 'Direktori beranda situs',
    'subdomain__aspnet_disabled_domain' => 'Dimatikan oleh domain',

    'domains__remove_description' => 'Semua data domain, termasuk pengaturan dan isi domain dan subdomain yang berhubungan, data aplikasi web, isi kotak surat, antivirus dan pengaturan filter spam, berkas log, data repositori cadangan domain dan sertifikat SSL/TLS akan dihapus. Bila Anda tidak memiliki berkas cadangan di mesin lokal Anda, semua data akan hilang secara permanen.',
    'subdomains__remove_description' => 'Seluruh data subdomain, termasuk isi dan pengaturan subdomain, data aplikasi web, dan file log akan dihapus. Bila Anda tidak memiliki file cadangan di mesin lokal Anda, semua data akan hilang secara permanen.',

    'mail__tabs_spam_filtering' => 'Filter Spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Gunakan pengaturan default seluruh server (Pindai)',
    'antivirus__use_server_settings_no_scan' => 'Gunakan pengaturan default seluruh server (Jangan memindai)',
    'antivirus__check_for_viruses' => 'Pindai virus',
    'antivirus__dont_check_for_viruses' => 'Jangan pindai virus.',
    'antivirus__incoming_mail' => 'Surat masuk',
    'antivirus__outgoing_mail' => 'Surat keluar',

    'domain_alias__CNAME_dns_record_exists' => 'Catatan DNS CNAME dengan nama tersebut sudah ada',
    'domain_alias__A_dns_record_exists' => 'Catatan DNS A dengan nama tersebut sudah ada',
    'domain_alias__bad_prefix' => 'Awalan yang salah untuk alias domain',
    'domain_alias__domain_doesnt_exist' => "Domain tidak ada",

    'dns__zone_ttl_message_info' => 'Jika nilai TTL tidak ditentukan, nilai TTL di Template Rekaman data SOA (%1) akan digunakan untuk Rekaman data DNS ini.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "File dengan nama index.html akan dibuat untuk pengalihan ke beberapa aplikasi web. Jika file nama tersebut sudah ada, maka file tersebut akan menjadi file cadangan dengan nama index.html.old dan akan digantikan dengan file yang baru. Klik OK untuk melanjutkan",

    'bt_ftp_ctrl' => "Akun FTP Tambahan",
    'ftp_users_no_permission' => "Anda tidak memiliki izin untuk mengelola akun FTP untuk domain ini",
    'ftp_users_limit_reached' => "Batas akun FTP untuk domain ini telah tercapai",
    'pb__ftp_ctrl' => "Pengelolaan FTP",
    'class_client__max_subftp_users' => "Akun FTP tambahan",

    '__client_form_settings' => "Pengaturan pelanggan",
    '__sbnet_client_keep_sbnet' => "Simpan akun pengguna yang sesuai di Presence Builder",
    '__sbnet_cant_add_more_sites' => "Batas jumlah situs yang bisa menggunakan Presence Builder untuk pelanggan ini telah tercapai.",
    '__sbnet_legend_text' => "Integrasi Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Buat akun pengguna yang sesuai pada Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Anda mencoba menghapus akun pengguna Presence Builder yang berkaitan dengan pelanggan ini. Tindakan ini akan menghapus semua situs web pengguna dan semua pengaturan lain yang relevan dari sistem Presence Builder, menghapus kemampuan menyunting situs web yang ada melalui Presence Builder, bahkan jika nanti Anda menyalakan opsi ini kembali. Jika Anda nanti membuat akun pengguna Presence Builder lagi, Anda harus membuat dan menerbitkan semua situs web Anda dari awal. Apakah Anda ingin mematikan pembuatan dan penerbitan situs web melalui Presence Builder?",
    'sb__build_site_with_subdomains' => "Subdomain Buat Blog dan Galeri Foto",
    '__sbnet_client_dont_have_sbuser' => "Tidak dapat membuat dan menerbitkan situs menggunakan Presence Builder: Pengguna Presence Builder tidak ada",

    '__component_disabled' => "Komponen dimatikan",

    'subdomains__physical_path_not_exist' => "Tidak ada subdomain yang terhubung dengan folder",

    'dnsserver_bind_to_msdns_switching_warning' => "Peringatan: Hanya 254 alamat IP subnet pertama dengan masker /8 dan /16 yang berada dalam Daftar Kontrol Akses yang akan ditransfer. Mereka akan ditransfer sebagai alamat IP yang terpisah. Apakah Anda ingin melanjutkan?",

    '__sbnet_net_framework_required_for_site' => "Situs Presence Builder perlu dukungan ASP.NET 2.0 untuk domain Anda. Kami rekomendasikan untuk mengaktifkan dukungan ASP.NET 2.0 jika Anda menggunakan Presence Builder.",

    'subdomain_auto_create_dir' => "Buat direktori fisik untuk subdomain",

    'sa_trainer__unable_to_get_messages_list' => "Tidak dapat mengambil daftar pesan di dalam kotak surat: %1",
    'sa_trainer__pass_doesnt_exist' => "Kata sandi untuk akun surat ini hilang",

    '__sitebuilder_error' => "Kesalahan terjadi saat mencoba tersambung ke Presence Builder. Hubungi penyedia layanan Anda untuk mendapatkan bantuan.",
    'wsb_error_user_not_exist' => "Akun pengguna Presence Builder tidak ada.",
    'wsb_error_site_already_exist' => "Situs ini sudah ada di Presence Builder.",
    'wsb_error_site_limit_reached' => "Batas jumlah situs Presence Builder telah tercapai.",
    'wsb_error_internal_error' => "Terjadi galat internal pada Presence Builder: Hubungi penyedia layanan Anda untuk mendapatkan bantuan.",
    'wsb_error_user_already_exist' => "Pengguna Presence Builder dengan nama sama sudah ada pada Presence Builder.",
    'sb_error_user_not_exist' => "Pengguna Presence Builder tidak ada.",
    'wsb_error_object_not_found' => "Presence Builder tidak dapat menemukan entri host yang benar.",

    'mg_no_mail_groups' => "Tidak ada kelompok surat",

    'drweb__drweb_incoming' => 'Pengecekan Antivirus untuk surat masuk',
    'drweb__drweb_outgoing' => 'Pengecekan Antivirus untuk surat keluar',
    'drweb__disable_reason_serv' => 'Server surat tidak mendukung pengaturan filter antivirus di level kotak surat',

    'vz_sitebuilder3_client_cant_be_created' => "Tidak dapat membuat akun pelanggan: SiteBuilder versi 3.1 atau yang lebih baru tidak terpasang",

    'chown__client_without_sitebuilder_support' => "Tidak dapat meneruskan transfer langganan: layanan Presence Builder tidak disertakan dalam paket layanan pemilik baru atau penyedia layanan mereka.",

    // new limits

    'class_client__max_odbc' => "Koneksi ODBC",
    'cl_perm__max_odbc' => "Jumlah koneksi ODBC maksimum",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Nama alias domain',
    'domain_alias__list_ascii_name' => 'Dalam format ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Pengelolaan Antarmuka',
    'pb__interface_templates' => 'Pengelolaan antarmuka',
    'pb__interface_clients' => 'Pelanggan menggunakan %1',

    // service management
    'bt_service_showall' => "Tunjukkan Semua",
    'bt_service_hideall' => "Sembunyikan Semua",
    'bt_service_start' => "Mulai",
    'bt_service_stop' => "Berhenti",
    'bt_service_restart' => "Mulai Ulang",
    'bt_service_disable' => "Matikan",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Otomatis",
    'service_startup_auto' => 'Otomatis',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Dimatikan',
    'service_action_ok' => "Operasi dengan layanan %1 berhasil diselesaikan",
    'service_action_failed_disabled_service' => "Tidak dapat menyelesaikan operasi dengan layanan %1 karena layanan dimatikan",
    'service_action_failed_error' => "Tidak dapat menyelesaikan operasi: %1",
    'service_group_action_ok' => "Operasi dengan layanan berikut berhasil diselesaikan: %1",
    'service_group_action_disabled' => "Tidak dapat menyelesaikan operasi dengan layanan berikut karena layanan dimatikan: \n%1",
    'service_group_action_failed' => "Tidak dapat menyelesaikan operasi dengan layanan berikut: %1. Untuk mendapatkan informasi kesalahan terperinci, jalankan operasi dengan setiap layanan secara terpisah",

    // php 4vs5
    'bt_php' => "Pengaturan PHP",

    'bt_insert' => "Sisipkan",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Terjadi galat pada basis data Presence Builder. Hubungi penyedia layanan Anda untuk mendapatkan bantuan.",
    'wsb_error_sitebuilder_access_denied_error' => "Tidak dapat mengakses file: Presence Builder tidak memiliki hak akses untuk file atau folder yang diminta. Hubungi penyedia layanan Anda untuk mendapatkan bantuan.",
    'wsb_error_sitebuilder_connection_failed' => "Tidak dapat menyambungkan Presence Builder karena koneksi putus. Hubungi penyedia layanan Anda untuk mendapatkan bantuan.",
    'wsb_error_critical_during_operation' => "Terjadi galat kritis pada Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Terjadi galat pada lisensi Presence Builder: %1",
    'wsb_error_during_operation' => "Terjadi galat pada Presence Builder: %1",
    'wsb_error_license_error' => "Ditemukan pembatasan lisensi Presence Builder.",

    // Other
    '__confrim_service_stop' => "Peringatan! Jika Anda menghentikan layanan %1, Plesk akan berhenti bekerja. Apakah Anda yakin ingin menghentikan layanan %1?",
    'index_redirect_help_text' => 'Sekarang Anda akan dialihkan ke situs web yang diminta secara otomatis. Bila peramban Anda tidak mendukung pengalihan, silakan klik %1 di sini %2',
    'bt_default_settings' => "Pulihkan Default",
    'logfiles__remove_failed' => "Tidak dapat menghapus file %1: file dikunci oleh aplikasi lain. Silakan mencoba beberapa saat lagi",
    'subdomain__invalid_homedirectory' => "Direktori laman beranda subdomain tidak valid",
    'scheduler_item__empty_filename' => "Mohon tetapkan file yang akan dijalankan",
    'subdomains__overlapped_domain_exists' => 'Subdomain ditimpa oleh zona DNS domain %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdomain ditimpa oleh zona DNS alias domain %1',
    'services_action_none_selected' => 'Tidak dapat menyelesaikan operasi: harap pilih layanan yang dibutuhkan',
    'cl_perm__max_subftp_users' => "Jumlah akun FTP tambahan maksimum",
    'login_up__access_denied_no_cp_access' => 'Akses ditolak. Anda tidak memiliki izin untuk mengakses Plesk.',
    'drweb__disable_reason_admin' => "Pengaturan filter Antivirus di level kotak surat tidak diizinkan oleh kebijakan server.",

    '__use_default' => 'Gunakan default',

    'webalizer_hidden_referrer__already_exist' => 'Entri sudah ada.',
    'webalizer_group_referrer__already_exist' => 'Perujuk kelompok dengan nama tersebut sudah ada.',

    'pb__dashboard' => 'Beranda',

    'server_interface__page_title' => 'Pengaturan Antarmuka Server',
    'server_interface__tabs_locales' => 'Bahasa lokal',
    'server_interface__tabs_skins' => 'Skin',
    'server_interface__tabs_interface_templates' => 'Template Antarmuka',
    'bt_server_interface' => 'Preferensi Antarmuka',
    'pb__server_interface' => 'Preferensi Antarmuka',

    'bt_wizard_next' => 'Berikutnya >>',
    'bt_wizard_prev' => '<< Kembali',

    '__limit_exceeded_max_dom_server' => 'Anda tidak bisa membuat host domain lebih banyak pada server ini karena telah mencapai batas jumlah domain yang dibolehkan oleh kunci lisensi. Hubungi penyedia layanan Anda untuk menyelesaikan masalah ini.',
    '__limit_exceeded_max_subdom_server' => 'Anda tidak dapat meng-host subdomain tambahan pada server ini. Harap hubungi penyedia layanan Anda.',
    '__limit_exceeded_max_dom_aliases_server' => 'Anda tidak dapat membuat alias domain tambahan untuk server ini. Harap hubungi penyedia layanan Anda.',
    '__limit_exceeded_max_wu_server' => 'Anda tidak dapat membuat pengguna web lebih banyak karena telah mencapai batas jumlah pengguna web yang dibolehkan oleh kunci lisensi di server. Hubungi penyedia layanan Anda untuk menyelesaikan masalah ini.',
    '__limit_exceeded_max_mn_server' => 'Anda tidak dapat membuat akun surat lebih banyak karena telah mencapai batas jumlah akun surat yang dibolehkan oleh kunci lisensi di server. Hubungi penyedia layanan Anda untuk menyelesaikan masalah ini.',

    '__limit_exceeded_max_cl_useradmin' => 'Anda telah mencapai batas jumlah akun pelanggan yang ditentukan oleh kunci lisensi Anda (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Anda telah mencapai batas jumlah domain yang ditentukan oleh kunci lisensi Anda (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Anda telah mencapai batas jumlah subdomain yang ditentukan oleh kunci lisensi Anda (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Anda telah mencapai batas jumlah alias domain yang ditentukan oleh kunci lisensi Anda (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Anda tidak punya ruang disk tersisa',
    '__limit_exceeded_max_wu_useradmin' => 'Anda telah mencapai batas jumlah akun pengguna web yang ditentukan oleh kunci lisensi Anda (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Anda telah mencapai batas jumlah basis data yang ditentukan oleh kunci lisensi Anda (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Anda telah mencapai batas jumlah kotak surat yang ditentukan kunci lisensi Anda (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Anda telah mencapai batas jumlah akun surel yang ditentukan kunci lisensi Anda (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Anda telah mencapai batas jumlah milis yang ditentukan oleh kunci lisensi Anda (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Anda telah mencapai batas jumlah domain (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Anda telah mencapai batas jumlah subdomain (%2) yang diperbolehkan oleh penyedia layanan Anda',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Anda telah mencapai batas jumlah alias domain (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Anda telah mencapai batas penggunaan ruang disk (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Anda telah mencapai batas jumlah penggunaan lebar pita per bulan (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Anda telah mencapai batas jumlah akun pengguna web (%2) yang dibolehkan penyedia layanan Anda.',
    '__limit_exceeded_max_db_userclient' => 'Anda telah mencapai batas jumlah basis data (%2)',
    '__limit_exceeded_max_box_userclient' => 'Anda telah mencapai batas jumlah kotak surat (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Anda telah mencapai batas jumlah milis (%2)',
    '__limit_exceeded_expiration_userclient' => 'Akun Anda kedaluwarsa pada %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Anda telah mencapai batas jumlah subdomain (%2) yang diperbolehkan oleh penyedia layanan Anda',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Anda telah mencapai batas jumlah alias domain (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Anda telah mencapai batas penggunaan ruang disk (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Anda telah mencapai batas jumlah lebar pita yang digunakan per bulan (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Anda telah mencapai batas jumlah akun pengguna web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Anda telah mencapai batas jumlah basis data (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Anda telah mencapai batas jumlah kotak surat (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Anda telah mencapai batas jumlah milis (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Akun Anda kedaluwarsa pada %2',

    'sapp_error_validation_not_found' => 'Tidak dapat memvalidasi aplikasi web karena salah satu file yang dibutuhkan (%1) tidak ditemukan. Hubungi dukungan teknisi Anda untuk bantuan.',
    'sapp_error_validation_spec_failed' => 'Aplikasi web yang diunggah tidak sesuai dengan spesifikasi AppPacks: %1.',
    'sapp_error_validation_register' => 'Tidak dapat mendaftar aplikasi web di direktori "%1": %2 Anda harus menghapus aplikasi web dari server karena aplikasi tidak akan berfungsi dengan benar.',

    'sapp__install_failed' => 'Pemasangan aplikasi web gagal: %1',
    'sapp__install_res_failed' => 'Gagal membuat sumber daya yang diminta.',

    'server_preferences__subdomains_blog_and_photo' => 'Subdomain Buat Blog dan Galeri Foto secara default',
    'plesk_key__blog_and_photo' => 'Kotak pilih agar dapat mengelola status default untuk kotak cek subdomain Buat Blog dan Galeri Foto.',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Tidak dapat mengubah jenis alamat IP ke khusus karena sudah ditugaskan ke lebih dari satu pengguna.',

    // 8.1.1

    '__write_modify_warning' => 'Memilih tambahan izin menulis/mengubah akan membuat beberapa aplikasi web berjalan benar, namun juga akan meningkatkan risiko keamanan',
    '__write_modify_subdomain_warning' => 'Memilih tambahan izin menulis/mengubah akan membuat beberapa aplikasi web berjalan benar, namun juga akan meningkatkan risiko keamanan',

    'phosting__php_incorrect_version_used' => "Mendeteksi masalah pada versi PHP. Centang kotak pilih versi PHP yang dibutuhkan untuk menyelesaikan masalah ini. Untuk mematikan PHP domain ini, klik OK tanpa memilih versi PHP",
    'fp__mail_preferences' => 'Pengaturan Surat',

    'mail__invalid_white_pattern' => 'Nilai yang ditentukan tidak valid. Gunakan format berikut: surat@contoh.com untuk alamat surel, contoh.com untuk domain.',
    'mail__invalid_black_pattern' => 'Nilai yang ditentukan tidak valid. Gunakan format berikut: surat@contoh.com untuk alamat surel, contoh.com untuk domain.',

    'resp_edit__reply_as_html' => 'Kirim sebagai HTML',
    'exception__path_very_long' => "Jalur terlalu panjang. Harap pastikan bahwa terdapat kurang dari %1 karakter dalam jalur.",

    // 8.2


    //SAPP
    'sapp_on' => 'Hidup',
    'sapp_off' => 'Mati',
    'sapp_directive_aspect' => 'Dibutuhkan',
    'sapp_databases_num' => 'Basis data',
    'sapp_db_required' => 'Dibutuhkan',
    'sapp_Required' => 'Dibutuhkan',
    'sapp_Variant' => 'Varian',
    'sapp_db_id' => 'Id basis data',
    'sapp_db_id_type' => 'Tipe DB (id: %1)',
    'sapp_db_id_min_version' => 'Versi min DB (id: %1)',
    'sapp_db_id_table_prefix' => 'Prefiks tabel DB (id: %1)',
    'sapp_Default' => 'Nilai default',
    'sapp_apache_mod_req' => 'Modul Apache',
    'sapp_dbtype_not_installed' => 'tidak terpasang',
    'sapp_apache_mod_not_installed' => 'tidak terpasang',
    'sapp_error_invalid_type' => 'Aplikasi "%1" tidak mendukung tindakan yang diminta.',
    'sapp_error_unknown_app_type' => 'Tipe aplikasi yang tidak didukung: %1.',
    'sapp__ssl_text' => 'Pasang aplikasi pada host virtual "http://" atau "https://"?',
    'sapp__app_to_upgrade' => 'Aplikasi yang harus diperbarui',
    'sapp__upgrade_apps_title' => 'Tingkatkan aplikasi',
    'sapp__upgrade_to_ver' => 'Tingkatkan ke versi',
    'sapp__choose_pkg_ver' => 'Pilih paket...',
    'sapp__pkg_cant_upgrade_pkg' => 'Paket "%1" tidak dapat digunakan untuk memperbarui aplikasi web "%2".',
    'sapp__app_ugrade_error' => 'Tidak dapat meningkatkan aplikasi: %1. Harap hubungi administrator sistem Anda.',
    'sapp__no_suitable_db_found' => 'Basis data yang sesuai tidak ditemukan.',
    'sapp__upgrade_success' =>  'Aplikasi berhasil ditingkatkan.',
    'sapp__pkg_info_changelog' => 'Riwayat perubahan',
    'sapp_requirement_legend' => 'Fitur hosting yang dibutuhkan oleh aplikasi',

    // other
    'bt_apply' => 'Terapkan',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Untuk membuat alias surat, kotak surat harus dihidupkan di akun surat ini. Nyalakan kotak surat?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Mematikan kotak surat akan menghapus alias surat karena alias surat akan berhenti bekerja. Matikan kotak surat?',
    'antivirus__disable_reason_install' => 'Anda tidak dapat mengelola antivirus karena antivirus belum terpasang.',
    'antivirus__disable_reason_key' => 'Anda tidak dapat mengelola antivirus karena belum diaktifkan dengan kunci lisensi yang benar.',
    'antivirus__disable_reason_deny_personal_settings' => 'Anda tidak dapat mengelola antivirus karena pengaturan antivirus individual tidak diizinkan oleh kebijakan server.',
    'change_foreign_user_password' => 'Ubah kata sandi',
    'change_foreign_user_password_hint' => "Pengguna bukan bagian dari aplikasi ini. Klik tautan untuk membuka aplikasi lain dan ubah kata sandi pengguna di sana. Untuk melakukan ini, Anda harus memiliki hak yang sesuai dengan aplikasi.",
    'cf_url_text' => 'URL JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Format Untai',
    'lang_unknown' => 'Bahasa tidak dikenal',
    'pb__cl_ed' => 'Detail pelanggan',
    'pb__actionlog' => 'Log tindakan',
    'pb__cl_limits' => 'Batas pelanggan',
    'pb__edit' => 'Sunting',
    'pb__subdom_edit' => 'Pengaturan hosting',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Cadangkan isi kotak surat',

    'maillist_import_result' => "\nTotal jumlah alamat surel dalam file: %1\nJumlah alamat surel yang diimpor: %2\nJumlah alamat surel yang sudah ada: %3\nJumlah alamat surel yang diduplikasi dalam file yang ditentukan: %4\nJumlah alamat surel yang tidak valid dalam file: %5",
    'maillist_import_error' => 'Tidak dapat mengimpor daftar alamat surel',

    //  spaw

    'spaw__unable_to_edit_no_body' => "File yang Anda pilih kemungkinan kosong atau bukan merupakan dokumen HTML yang valid di dalam pengodean terpilih. Silahkan pilih pengodean yang benar atau tambahkan isi baru ke dalam file.",

    'dom_pref__external_mail_srv' => "Alihkan ke server surat eksternal dengan alamat IP:",
    'mn_edit__store_messages' => 'Kotak surat',

    // aps

    'sapp__before_upgrade_notice' => 'Disarankan untuk mencadangkan aplikasi dan data pengguna sebelum memulai proses peningkatan.',
    'sapp__application_properties' => 'Properti aplikasi',
    'sapp__application_root_descr' => 'Halaman utama aplikasi',

    'sapp__aps_license_invalid_id' => 'ID kunci lisensi tidak valid: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Lisensi dengan nomor kunci %1 sudah ada di dalam basis data.',
    'sapp__aps_lic_del_used' => 'Tidak dapat menghapus kunci lisensi, karena sedang digunakan oleh salah satu aplikasi terpasang.',
    'sapp__aps_lic_del_unknown' => 'Tidak dapat menghapus kunci lisensi: %1',
    'sapp__aps_cappi_duplicate' => "Aplikasi ini sudah ada di dalam kumpulan aplikasi pelanggan",
    'sapp__appi_not_shared_no_install' => "Aplikasi tidak ada di kumpulan aplikasi pelanggan. Tambahkan terlebih dahulu aplikasi ini ke kumpulan aplikasi pelanggan jika Anda ingin memasang aplikasi ini di situs Anda.",
    'sapp__appi_shared_not_client' => "Aplikasi tidak ada di kumpulan aplikasi pelanggan. Tambahkan terlebih dahulu versi aplikasi ini ke kumpulan aplikasi pelanggan jika Anda ingin memperbarui aplikasi ke versi tersebut.",
    'sapp__apply_license_script_not_found' => 'Tidak dapat menemukan skrip "apply-license" untuk aplikasi web ini.',
    'sapp__unable_to_activate_key' => 'Kesalahan terjadi ketika mencoba mengaktifkan kunci lisensi: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Ada aplikasi web terpasang yang membutuhkan adanya aplikasi web ini di dalam sistem.',
    'sapp__unable_to_delete_ai_in_pool' => 'Aplikasi ini masih ada di dalam kumpulan pelanggan. Jika Anda ingin menghapus aplikasi ini, Anda harus menghapusnya terlebih dahulu dari semua kumpulan aplikasi pelanggan atau gratiskan aplikasi tersebut.',
    'sapp__unable_to_delete_app_template' => 'Tidak dapat menghapus aplikasi #%1: %2',
    'sapp__limit_exceeded_client' => 'Anda telah mencapai batas jumlah pengulangan pemasangan aplikasi web ini (%2).',


    // atis module

    '_week_on' => 'minggu ke',
    '__week_first' => 'pertama',
    '__week_second' => 'kedua',
    '__week_third' => 'ketiga',
    '__week_fourth' => 'keempat',
    '__week_last' => 'terakhir',
    '__not_started' => 'Menunggu',
    '__started' => 'Berjalan',
    '__cancel_pending' => 'Membatalkan',
    '__canceled' => 'Dibatalkan',
    '__error' => 'Galat',
    '__done' => 'Selesai',

    '__php_cgi_handler' => 'Aplikasi CGI',
    '__php_isapi_handler' => 'Ekstensi ISAPI',
    '__php_fastcgi_handler' => 'Aplikasi FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'jalankan sebagai',

    'cf_dbfolder_text' => 'Folder Basis Data',
    'cf_isnewdb_text' => 'Buat Basis Data',
    'cf_isnewdb_title' => 'Pilih kotak cek bila basis data harus dibuat',

    'pb__site_apps_upgrade' => 'Peningkatan Aplikasi Web',

    'detach' => 'Putuskan',
    'preferences' => "Ubah Kata Sandi",

    'toolsbar__switch_user?' => "Apakah Anda yakin ingin log masuk dengan menggunakan akun pengguna yang lain?",
    '__aps_left' => 'Pemasangan tertinggal',
    'aps__license_key' => 'Kunci lisensi',
    'aps__download_code' => 'Mengunduh kunci lisensi dan kode aktivasi',
    'aps__license_key_hint' => 'Ambil dari server pelisensi dengan menggunakan kode aktivasi',
    'aps__database_not_available' => 'Tidak tersedia, harap periksa domain atau batasan pelanggan',
    'aps__yes' => 'ya',
    'aps__no' => 'tidak',
    '__click_to_enlarge' => 'Klik untuk memperbesar',
    'site_apps__back_to_list' => 'Kembali ke daftar',
    'sapp__pkg_info_installation_requirements' => 'Persyaratan pemasangan',
    '__close_window' => 'Tutup',

    //SAPP END

    'skin_info__already_default' => 'Skin telah ditetapkan sebagai skin default.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Antivirus Plesk Premium',
    'drweb:properties_page_title' => 'Pengaturan Antivirus Plesk Premium untuk %1',
    'drweb:properties_legend' => 'Pengaturan',
    'drweb:status' => 'Mengecek virus di surat',

    // sb integration
    'sitebuilder_wizard' => 'Panduan Presence Builder',
    'dom_site_builder' => 'Klik untuk membuka Panduan Presence Builder.',
    'sb_plesk_admin_url' => 'URL server Presence Builder. Pastikan alamat ini terungkap dengan baik di DNS',
    'sb_plesk_admin_login' => 'Nama pengguna administrator server untuk masuk ke Presence Builder',
    'sb_plesk_admin_password' => 'Kata sandi administrator',
    'sb_sitebuilder_preferences' => 'Informasi akses administrator Presence Builder',
    'sb__server' => 'Preferensi administrator sistem Presence Builder',
    'sb__sitebuilder_support' => 'Dukungan Presence Builder',
    'sb_keep_sb_user' => 'Simpan akun pengguna yang sesuai di Presence Builder',
    'sb_create_sb_user' => 'Buat akun pengguna yang sesuai pada Presence Builder',
    'sb__build_site_using_sitebuilder' => "Buat situs web dengan menggunakan Presence Builder",
    'sb_no_current_sb_server_set' => 'Koneksi ke Presence Builder belum dikonfigurasi: Anda harus menambahkan catatan A di template zona DNS yang akan merujuk ke server Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Tidak dapat mengambil informasi dari sistem Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Tidak dapat tersambung dengan Presence Builder: nama pengguna atau kata sandi salah.",
    'sb_init_sb_manager' => "Memulai pengelola Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Gagal tersambung dengan sistem Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Pelanggan ini tidak memiliki akun pengguna di Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder belum dikonfigurasi.",
    'sb_err_you_dont_have_sbaccount' => "Gagal untuk memberi Anda hak di dalam Presence Builder.",
    'sb_error_critical_during_operation' => "Kesalahan berikut terjadi di Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Dukungan sign-on tunggal belum diaktifkan di Plesk.",

    'warning__super_zone_exist' => "Zona %1 telah dibuat, namun nama zona ini adalah subzona dari zona lain %2 yang sudah ada, yang merupakan milik pengguna lain %3. Penamaan ini dapat dilakukan, tapi pastikan Anda telah memilih akun pengguna yang benar.",
    'error__super_zone_exist' => "Tidak dapat membuat zona DNS karena superzona-nya dimiliki oleh pengguna lain.",

    'locales__files_not_exits' => 'Tidak dapat mengubah bahasa lokal: file paket bahasa antarmuka yang ditentukan tidak ada di dalam sistem.',
    'locales__unavailable' => 'Tidak dapat mengubah bahasa lokal: paket bahasa antarmuka yang ditentukan tidak tersedia.',

    // DB BU

    'pb__dbbackup_list' => 'File cadangan basis data',
    // server
    'dbbackup__server_backup_settings' => 'Cadangan',
    'dbbackup__network_temp_dir' => 'Direktori jaringan sementara',
    'dbbackup__network_user' => 'Nama pengguna',
    'dbbackup__network_pass' => 'Kata sandi',
    // domain
    'dbbackup__add_database_legend' => 'Pulihkan basis data yang dicadangkan',
    'dbbackup__add_database_restore' => 'Pulihkan basis data dari file cadangan',
    'dbbackup__add_database_file' => 'File cadangan basis data',
    'dbbackup__add_database_user' => 'Nama pengguna default',
    'dbbackup__add_database_pass' => 'Kata sandi pengguna default',
    'dbbackup__add_database_pass2' => 'Konfirmasi kata sandi pengguna default',

    'bt_dbbackup_now' => 'Cadangan',

    'bt_repair' => 'Perbaiki',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Penyedia hosting melarang mengunggah dump basis data SQL Server.',

    // APS categories

    'cf_invalid_password' => 'Kata sandi tidak boleh lebih dari 16 karakter',
    'cf_invalid_description_length' => 'Deskripsi tidak boleh lebih dari 256 simbol',
    'ip_addr__ip_used_by_external_mail_server' => 'Alamat IP %1 sudah digunakan oleh server surat eksternal',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Nama pengguna dan kata sandi FTP invalid. Harap memasukkan informasi akses pengguna FTP yang benar.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Batas untuk perubahan nomor seri sudah tercapai. Tidak ada perubahan zona DNS lagi yang dapat dilakukan hari ini.',
    'dns__zone_apply_changes' => 'Perubahan yang Anda buat pada catatan DNS belum disimpan. Perubahan yang dibuat ditandai di bawah ini. Klik Perbarui untuk menerapkan perubahan ke zona DNS atau klik Kembali untuk membuang perubahan.',
    'dns__update_dns_zone' => 'Klik untuk menyimpan perubahan yang dibuat ke catatan DNS',
    'dns__revert_dns_zone' => 'Klik untuk membatalkan perubahan yang dibuat pada catatan DNS',
    'bt_revert' => 'Kembali',
    'dns__dns_zone_has_beed_updated' => 'Perubahan yang dibuat untuk catatan DNS disimpan.',
    'dns__dns_zone_has_beed_reverted' => 'Perubahan yang dibuat untuk catatan DNS dibatalkan',
    'db__nondefault_server_not_allowed' => 'Penggunaan server basis data non-default tidak diizinkan',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Akun dan domain pelanggan %1.',
    'ui__client__disabled-warning' => 'Akun pelanggan %1 ditangguhkan.',
    'ui__client__none-available' => 'Akun pelanggan belum dikonfigurasi.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Pelanggan %1',
    'ui__client_self__description' => 'Daftar domain saya.',
    'ui__client_self__short-title' => 'Domain saya',
    'ui__client_self__title' => 'Domain saya',


    'site_apps__non_removable' => 'Item yang tidak dapat dihapus',
    'site_apps__non_removable_items' => 'Aplikasi web berikut tidak dapat dihapus:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Tidak ada tombol suai.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Tidak ada tombol suai di Panel Pelanggan pelanggan %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Hapus tombol %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Hapus',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Hapus tombol %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Hapus tombol suai dari Panel Pelanggan pelanggan',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Hapus',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Hapus tombol suai',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Hapus tombol',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Pilih pelanggan yang tombol suainya ingin Anda hapus dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Pilih tombol yang ingin Anda hapus dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Konfirmasi penghapusan tombol suai dengan mencentang kotak pilih pada layar ini, dan kemudian klik Selesai.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Hapus tombol suai dari Panel Pelanggan pelanggan.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Hapus',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Hapus tombol suai',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Hapus tombol suai',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Pilih pelanggan yang tombol suainya ingin Anda hapus dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Pilih tombol suai yang ingin Anda hapus dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Konfirmasi penghapusan tombol suai dengan mencentang kotak pilih dan kemudian klik Selesai.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Sunting properti tombol level-pelanggan %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Pengaturan',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modifikasi tombol suai pelanggan %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Tambah tombol suai',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Pilih pelanggan yang Panel Pelanggannya ingin Anda tambahkan tombol suai dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik Selesai untuk membuat tombol.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Ubah properti tombol pada Panel Pelanggan pelanggan.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Properti',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Ubah properti tombol pada Panel Pelanggan pelanggan',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah properti tombol suai',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Pilih pelanggan yang tombol suainya ingin Anda modifikasi dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Pilih tombol suai yang ingin Anda modifikasi dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Ketika telah selesai menyunting properti tombol, klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Buat tombol %1 tidak tersedia untuk pelanggan Anda.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Buat tidak tersedia untuk pelanggan Anda',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Buat tombol %1 tidak tersedia untuk pelanggan Anda',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Buat tombol %1 terlihat untuk pengguna pelanggan.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Buat tersedia untuk pelanggan Anda',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Buat tombol %1 terlihat untuk pengguna pelanggan',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Buat tombol suai tersedia/tidak tersedia untuk pelanggan Anda.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia/tidak tersedia untuk pelanggan Anda',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Buat tombol suai tersedia atau tidak tersedia untuk pelanggan Anda',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat tombol suai tersedia/tidak tersedia untuk pelanggan Anda.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Pilih pelanggan yang tombol suainya ingin Anda buat tersedia untuk pengguna pelanggan dan klik Berikutnya >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Pilih tombol suai yang ingin Anda sediakan atau tidak sediakan untuk pelanggan Anda dan klik Berikutnya >>.',

    'ui__client/domain__description' => 'Kelola domain %1.',
    'ui__client/domain__disabled-warning' => 'Domain %1 ditangguhkan.',
    'ui__client/domain__none-available' => 'Anda tidak memiliki domain.',
    'ui__client/domain__none-available__1' => 'Akun %1 tidak memiliki domain.',
    'ui__client/domain__none-available__2' => 'Akun %1 tidak memiliki domain.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domain %1',
    'ui__client/domain_self__description' => 'Kelola domain Anda.',
    'ui__client/domain_self__disabled-warning' => 'Domain Anda ditangguhkan.',
    'ui__client/domain_self__quick-search' => 'Domain saya',
    'ui__client/domain_self__short-title' => 'Domain saya',
    'ui__client/domain_self__title' => 'Domain saya',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Tidak ada tombol suai yang ditempatkan di Panel Pelanggan pelanggan.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Pelanggan %1 tidak memiliki tombol suai di Panel Pelanggan.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Tidak ada tombol suai untuk domain %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Hapus tombol suai %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Hapus',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Hapus tombol suai %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Hapus tombol suai.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Hapus',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Hapus tombol suai',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Hapus tombol suai',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Pilih pelanggan yang panel administrasi domainnya ingin Anda hapus tombolnya dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Pilih domain yang panel administrasinya ingin Anda hapus tombolnya dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Pilih tombol yang ingin Anda hapus dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Konfirmasi penghapusan tombol suai dengan mencentang kotak pilih yang sesuai dan klik Selesai untuk menghapus tombol serta keluar dari panduan.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Hapus tombol suai.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Hapus',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Hapus tombol suai',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Hapus tombol suai',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Pilih pelanggan yang panel administrasi domainnya ingin Anda hapus tombol suainya dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Pilih domain yang panel administrasinya ingin Anda hapus tombolnya dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Pilih tombol suai yang ingin Anda hapus dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Konfirmasi penghapusan tombol suai dengan mencentang kotak pilih dan klik Selesai untuk menghapus tombol serta keluar dari panduan.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Ubah properti tombol suai %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Properti",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Ubah properti tombol suai %1 di dalam Panel Pelanggan.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Tambah tombol',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Pilih pelanggan yang Panel Pelanggannya ingin Anda tambahkan tombol dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Pilih langganan yang ingin Anda ubah tombolnya dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klik Selesai untuk membuat tombol dan keluar dari panduan.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Ubah properti tombol di Panel Pelanggan.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Properti',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Ubah properti tombol di Panel Pelanggan',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah properti tombol',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Pilih tombol suai yang ingin Anda ubah pengaturannya dan klik Berikutnya >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Ketika telah selesai mengubah properti tombol, klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Buat tombol %1 tidak tersedia untuk pengguna surat di bawah domain ini.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Tidak tersedia untuk pengguna surat',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Buat tombol %1 tidak tersedia untuk pengguna surat di bawah domain ini',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Buat tombol %1 terlihat untuk pengguna surat di bawah domain.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Dapat diakses oleh pengguna surat di bawah domain ini',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Buat tombol suai %1 terlihat oleh pengguna surat di bawah domain ini',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Buat tombol suai tersedia atau tidak tersedia untuk pengguna yang lain.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia/tidak tersedia untuk pengguna yang lain.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Buat tombol suai tersedia atau tidak tersedia untuk pengguna surat',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat tombol suai tersedia atau tidak tersedia untuk pengguna yang lain',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Pilih domain di mana tombol ditempatkan dan klik Berikutnya >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Pilih tombol yang akan Anda sediakan atau tidak sediakan untuk pengguna lain dan klik Berikutnya >>.',

    'ui__client/domain/delete__description' => 'Hapus domain %1.',
    'ui__client/domain/delete__short-title' => 'Hapus',
    'ui__client/domain/delete__title' => 'Hapus domain %1',
    'ui__client/domain/delete_multi__description' => 'Hapus domain.',

    'ui__client/domain/delete_multi__short-title' => 'Hapus',
    'ui__client/domain/delete_multi__title' => 'Hapus domain',
    'ui__client/domain/delete_multi__wizard-title' => 'Hapus domain',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Pilih domain yang akan Anda hapus dan klik berikutnya >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Konfirmasi penghapusan domain dengan mencentang kotak pilih dan klik Selesai untuk menghapusnya dan keluar dari panduan.',
    'ui__client/domain/delete_unknown__description' => 'Hapus domain.',
    'ui__client/domain/delete_unknown__short-title' => 'Hapus',
    'ui__client/domain/delete_unknown__title' => 'Hapus domain',
    'ui__client/domain/delete_unknown__wizard-title' => 'Hapus domain',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Pilih domain yang akan Anda hapus dan klik Berikutnya >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Konfirmasi penghapusan domain dengan mencentang kotak pilih dan klik Selesai untuk menghapus dan keluar dari panduan.',

    'ui__client/domain/hosting__none-available' => 'Tidak ada domain dengan hosting web yang telah dikonfigurasi. Buat domain dan konfigurasi hosting webnya agar dapat mengakses fungsi ini.',
    'ui__client/domain/hosting__none-available__1' => 'Akun pengguna ini tidak memiliki domain dengan hosting web yang telah dikonfigurasi. Konfigurasi hosting web pada domain yang dibutuhkan agar dapat mengakses fungsi ini.',
    'ui__client/domain/hosting__none-available__2' => 'Hosting web tidak dikonfigurasi untuk domain %1. Konfigurasi hosting web domain %1 untuk mengakses fungsi ini.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Pelanggan",
    'ui__client/domain/hosting/application#list_header__description__title' => "Deskripsi",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Item",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nama",
    'ui__client/domain/hosting/application#list_header__release__title' => "Rilis",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Urutkan berdasarkan pelanggan",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Urutkan berdasarkan deskripsi",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Urutkan berdasarkan item",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Urutkan berdasarkan nama",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Urutkan berdasarkan rilis",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Urutkan berdasarkan versi",
    'ui__client/domain/hosting/application#list_header__title' => "Aplikasi web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versi",

    'rpt_reseller_section_general' => 'Umum',
    'rpt_reseller_section_domains' => 'Domain',
    'rpt_reseller_section_clients' => 'Pelanggan',
    'statistics__cl_active_domains' => "Domain aktif",
    'rpt_reseller_cl_domains' => "Domain",
    'rpt_reseller_cl_subdomains' => "Subdomain",
    'by__cl_domains' => "domain klien",
    'dom_ctrl__cl_mboxes' => "Kotak surat",
    'rpt_reseller_cl_redirects' => "Penerus",
    'rpt_reseller_cl_mail_groups' => "Kelompok surat",
    'rpt_reseller_cl_mail_resps' => "Balasan otomatis",
    'rpt_reseller_cl_mail_lists' => "Milis",
    'rpt_reseller_cl_web_users' => "Pengguna web",
    'rpt_reseller_cl_data_bases' => "Basis data",

    'statistics__active_clients' => 'Pelanggan dengan langganan aktif',
    'statistics__clients_active_domains' => 'Domain aktif',
    'statistics__clients_doms' => 'Domain',
    'statistics__cl_doms' => 'Domain',
    '__clients_subdomains' => 'Subdomain',
    '__clients_domains' => 'Domain',
    'dom_ctrl__clients_mboxes' => 'Kotak surat',
    'dom_ctrl__clients_redir' => 'Penerus',
    'dom_ctrl__clients_mg' => 'Kelompok surat',
    'dom_ctrl__clients_resp' => 'Balasan otomatis',
    'dom_ctrl__clients_maillists' => 'Milis',
    'dom_ctrl__clients_wu' => 'Pengguna web',
    'dom_ctrl__clients_db' => 'Basis data',

    'dom_ctrl__cl_redir' => 'Penerus', // to resolve!
    'dom_ctrl__cl_mg' => 'Kelompok surat', // to resolve!
    'dom_ctrl__cl_resp' => 'Balasan otomatis', // to resolve!
    'dom_ctrl__cl_maillists' => 'Milis', // to resolve!
    'dom_ctrl__cl_wu' => 'Pengguna web', // to resolve!
    'dom_ctrl__cl_db' => 'Basis data', // to resolve!

    'rpt_cl_section_clients' => 'Pelanggan',

    'rpt_admin_section_general' => 'Umum',
    'rpt_admin_section_resellers' => 'Penyalur',
    'rpt_admin_section_clients' => 'Pelanggan',
    'rpt_admin_section_personal_clients' => 'Pelanggan sendiri',
    'rpt_admin_section_domains' => 'Domain',
    'rpt_admin_section_personal_domains' => 'Domain pribadi',

    'rpt_reseller_section_personal_domains' => 'Domain pribadi',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Pilih domain yang akan Anda tangguhkan atau aktifkan.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Tangguhkan atau aktifkan domain',

    'ui__client/ip-pool__description' => 'Tetapkan dan lepaskan penetapan alamat IP atau sertifikat SSL/TLS untuk pelanggan %1.',
    'ui__client/ip-pool__short-title' => 'Kumpulan IP',
    'ui__client/ip-pool__title' => 'Kumpulan IP Pelanggan %1',
    'ui__client/ip-pool_self__description' => 'Lihat kumpulan IP Anda.',
    'ui__client/ip-pool_self__short-title' => 'Kumpulan IP',
    'ui__client/ip-pool_self__title' => 'Kumpulan IP saya',
    'ui__client/ip-pool/properties__description' => 'Atur kumpulan IP untuk pelanggan %1.',

    'ui__client/ip-pool/properties__short-title' => 'Kumpulan IP',
    'ui__client/ip-pool/properties__title' => 'Atur kumpulan IP pelanggan %1',
    'ui__client/ip-pool/properties_self__description' => 'Lihat kumpulan IP Anda.',

    'ui__client/ip-pool/properties_self__short-title' => 'Kumpulan IP saya',
    'ui__client/ip-pool/properties_self__title' => 'Kumpulan IP saya',
    'ui__client/ip-pool/properties_unknown__description' => 'Tetapkan untuk atau lepaskan penetapan alamat IP dan sertifikat SSL/TLS dari pelanggan.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Kumpulan IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Atur kumpulan IP pelanggan',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Atur kumpulan IP pelanggan',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Pilih pelanggan yang kumpulan IP-nya akan Anda konfigurasi.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Ketika telah selesai mengonfigurasi kumpulan IP, klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',


    'ui__client/limits_readonly-unknown__description' => 'Lihat batas sumber daya pelanggan.',
    'ui__client/limits_readonly-unknown__short-title' => 'Batas sumber daya',
    'ui__client/limits_readonly-unknown__title' => 'Lihat batas sumber daya akun pelanggan',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Lihat atau ubah batas sumber daya pelanggan',

    'ui__client/limits_unknown__wizard-title' => 'Lihat atau ubah batas sumber daya pelanggan',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Pilih pelanggan yang Anda inginkan.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Pilih pelanggan yang Anda inginkan.',
    'ui__client/limits_unknown__wizard__2' => 'Klik Selesai untuk menerapkan perubahan.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Klik Selesai untuk keluar dari panduan.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Klik Selesai untuk keluar dari panduan.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Klik Selesai untuk keluar dari panduan.',

    'ui__client/permissions_unknown__wizard-title' => 'Lihat atau ubah izin pelanggan',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Ketika telah selesai melihat izin Anda, klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Pilih pelanggan yang akan Anda lihat atau ubah izinnya.',
    'ui__client/permissions_unknown__wizard__2' => 'Ketika telah selesai mengubah izin pelanggan, klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',

    'ui__client/preferences_unknown__wizard-title' => 'Sunting preferensi pelanggan',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Pilih pelanggan yang preferensi sesi dan antarmukanya akan Anda kelola.',
    'ui__client/preferences_unknown__wizard__2' => 'Ketika telah selesai mengubah preferensi pelanggan, klik Selesai.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Ketika telah selesai mengubah preferensi Anda, klik Selesai.',

    'ui__custom-buttons/custom-button__none-available' => 'Anda tidak memiliki tombol suai.',
    'ui__custom-buttons/custom-button/delete__description' => 'Hapus tombol suai %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Hapus',
    'ui__custom-buttons/custom-button/delete__title' => 'Hapus tombol suai %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Hapus tombol suai.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Hapus',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Hapus tombol suai',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Hapus tombol suai',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Pilih tombol yang akan Anda hapus.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Konfirmasi penghapusan tombol dengan mencentang kotak pilih dan klik Selesai untuk mengakhiri panduan.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Hapus tombol suai.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Hapus',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Hapus tombol suai',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Hapus tombol suai',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Pilih tombol suai yang akan Anda hapus.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Konfirmasi penghapusan tombol dengan mencentang kotak pilih dan klik Selesai untuk mengakhiri panduan.',
    'ui__custom-buttons/custom-button/properties__description' => 'Ubah properti tombol %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Properti',
    'ui__custom-buttons/custom-button/properties__title' => 'Ubah properti tombol %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Buat tombol',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klik Selesai untuk membuat tombol.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Ubah properti tombol suai.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Properti',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Ubah properti tombol suai',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah properti tombol suai',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Pilih tombol yang ingin Anda ubah propertinya.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Klik Selesai untuk menerapkan perubahan.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Buat tombol suai %1 tidak tersedia untuk pengguna lain.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Tidak tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Buat tombol suai %1 tidak tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Buat tombol suai %1 tersedia untuk pengguna lain.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Buat tombol suai %1 tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Buat tombol suai tersedia atau tidak tersedia untuk pengguna lain.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia atau tidak tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Buat tombol suai tersedia atau tidak tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat tombol suai tersedia atau tidak tersedia untuk pengguna lain',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Pilih tombol suai yang ingin Anda sediakan atau tidak sediakan untuk pengguna lain dan klik Berikutnya >>.',

    'ui__longtasks#list_header__name__title' => "Nama",
    'ui__longtasks#list_header__owner__title' => "Pemilik",
    'ui__longtasks#list_header__start_time__title' => "Waktu pembuatan",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Tugas",
    'ui__longtasks#list_header__finish_time__title' => "Waktu penyelesaian",
    'ui__longtasks#task_list_legend__title' => "Tugas",
    'ui__longtasks#tools_legend__title' => "Alat",
    'ui__longtasks__description' => "Kelola tugas latar belakang",
    'ui__longtasks__short-title' => "Tugas latar belakang",
    'ui__longtasks__title' => "Tugas latar belakang",
    'ui__longtasks/longtask/properties#current_operation__title' => "Operasi saat ini:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Perkiraan waktu penyelesaian:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Umum",
    'ui__longtasks/longtask/properties#owner__title' => "Tugas dimulai oleh:",
    'ui__longtasks/longtask/properties#progress__title' => "Kemajuan keseluruhan:",
    'ui__longtasks/longtask/properties#start_time__title' => "Tugas dimulai:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Status tugas",
    'ui__longtasks/longtask/properties__description' => "Status dan informasi tugas latar belakang",

    'ui__longtasks/properties__description' => "Pengaturan tugas latar belakang",
    'ui__longtasks/properties__short-title' => "Pengaturan",
    'ui__longtasks/properties__title' => "Tugas latar belakang",

    'ui__news/dismiss__description' => 'Klik untuk menutup bingkai berita. Plesk akan menampilkan bingkai kembali jika berita telah diperbarui.',

    'ui__news/dismiss__title' => 'Tutup berita',

    'ui__server__description' => 'Pengelolaan server.',
    'ui__server__short-title' => 'Kelola server Anda',
    'ui__server__title' => 'Pengelolaan server',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Alamat IP %1 tidak tersedia.',
    'ui__server/ip-address__none-available' => 'Tidak ada alamat IP.',
    'ui__server/ip-addresses/ip-address__title' => "Alamat IP",
    'ui__server/ip-address/client/properties_new__description' => "Tetapkan alamat IP %1 ke penyalur.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Tetapkan',
    'ui__server/ip-address/client/properties_new__title' => "Tetapkan alamat IP %1 ke penyalur",
    'ui__server/ip-address/client__none-available' => 'Tidak ada akun pengguna',
    'ui__server/ip-address/client_unknown__quick_search' => 'Pengguna',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Daftar pengguna yang menggunakan alamat IP ini.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Silahkan pilih alamat IP.',
    'ui__server/ip-address/client/delete__description' => 'Lepaskan alamat IP dari penyalur.',
    'ui__server/ip-address/client/delete__short-title' => 'Lepaskan',
    'ui__server/ip-address/client/delete__title' => 'Lepaskan alamat IP dari penyalur',
    'ui__server/ip-address/client/delete_multi__description' => "Lepaskan alamat IP dari kumpulan penyalur.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Lepaskan',
    'ui__server/ip-address/client/delete_multi__title' => 'Lepaskan alamat IP dari penyalur',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Hapus alamat IP dari kumpulan pengguna.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Pilih alamat IP yang akan Anda lepaskan dari pengguna dan klik Berikutnya >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Pilih pengguna yang darinya ingin Anda lepaskan alamat IP dan klik Berikutnya >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Konfirmasi pelepasan alamat IP pengguna dengan mencentang kotak pilih dan klik Selesai untuk mengakhiri panduan.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Lepaskan alamat IP dari penyalur.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Lepaskan',
    'ui__server/ip-address/client/delete_unknown__title' => 'Lepaskan alamat IP dari penyalur',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Lepaskan alamat IP dari pengguna',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Pilih alamat IP yang akan Anda lepaskan dari pengguna dan klik Berikutnya >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Pilih pengguna yang darinya Anda ingin melepaskan alamat IP dan klik Berikutnya >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Konfirmasi pelepasan alamat IP pengguna dengan mencentang kotak pilih dan klik Selesai untuk mengakhiri panduan.',

    'ui__server/ip-address/domain__description' => "Semua domain di alamat IP %1.",
    'ui__server/ip-address/domain__short-title' => "Domain",
    'ui__server/ip-address/domain__title' => "Domain di alamat IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Semua domain pada alamat IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domain",
    'ui__server/ip-address/domain_unknown__title' => "Domain pada alamat IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Pilih alamat IP yang Anda butuhkan dan klik Berikutnya >>.",

    'ui__server/ip-address/properties__description' => 'Ubah properti alamat IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Properti',
    'ui__server/ip-address/properties__title' => 'Ubah properti alamat IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Tambah alamat IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Ketika telah selesai mengubah properti alamat IP, klik Selesai untuk menerapkan perubahan.',
    'ui__server/ip-address/properties_unknown__description' => 'Ubah properti alamat IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Properti',
    'ui__server/ip-address/properties_unknown__title' => 'Ubah properti alamat IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Ubah properti alamat IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Pilih alamat IP yang akan Anda ubah propertinya.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Ketika telah selesai mengubah properti alamat IP, klik Selesai untuk menerapkan perubahan.',

    'ui__server/spam-filter/black-list__description' => 'Atur daftar hitam untuk filter spam seluruh server.',
    'ui__server/spam-filter/black-list__short-title' => 'Daftar hitam',
    'ui__server/spam-filter/black-list__title' => 'Daftar hitam untuk filter spam seluruh server',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Tambahkan hanya %1 alamat surel unik pertama.',
    'ui__server/spam-filter/black-list/address__description' => 'Alamat daftar hitam filter spam.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Tidak ada alamat surel dalam daftar.',
    'ui__server/spam-filter/black-list/address__file_size' => 'File yang diunggah kosong.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Alamat surel berikut tidak valid: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Tidak ada alamat di daftar hitam filter spam.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Alamat',
    'ui__server/spam-filter/black-list/address__title' => 'Alamat daftar hitam %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Tambah alamat ke daftar hitam.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Tambah alamat',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Tambah alamat ke daftar hitam',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Hapus alamat %1 dari daftar hitam seluruh server.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Hapus',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Hapus alamat %1 dari daftar hitam seluruh server',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Hapus alamat dari daftar hitam seluruh server.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Hapus',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Hapus alamat dari daftar hitam seluruh server',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Penghapusan alamat dari daftar hitam filter spam seluruh server',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Pilih alamat filter spam yang akan Anda hapus dan klik Berikutnya >>.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Konfirmasi penghapusan alamat filter spam dengan mencentang kotak pilih dan klik Selesai untuk menghapusnya dan keluar dari panduan.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Hapus alamat dari daftar hitam seluruh server.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Hapus',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Hapus alamat dari daftar hitam seluruh server',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Penghapusan alamat dari daftar hitam filter spam seluruh server',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Pilih alamat filter spam yang akan Anda hapus dan klik BerIkutnya >>.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Konfirmasi penghapusan alamat filter spam dengan mencentang kotak pilih dan klik Selesai untuk menghapusnya dan keluar dari panduan.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Tambahkan hanya %1 alamat surel unik pertama.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Tidak ada alamat surel dalam daftar.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Tidak dapat mengunggah berkas. Ukuran maksimum berkas untuk diunggah adalah %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Alamat surel berikut tidak valid: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Tambah alamat ke daftar hitam.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Tambah alamat',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Tambah alamat ke daftar hitam',

    'ui__server/spam-filter/properties__description' => 'Menata filter spam seluruh server.',

    'ui__server/spam-filter/properties__short-title' => 'Pengaturan',
    'ui__server/spam-filter/properties__title' => 'Pengaturan filter spam',

    'ui__server/spam-filter/toggle_disable__description' => 'Nonaktifkan filter spam untuk seluruh sistem.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Nonaktifkan',
    'ui__server/spam-filter/toggle_disable__title' => 'Nonaktifkan filter spam',
    'ui__server/spam-filter/toggle_enable__description' => 'Aktifkan filter spam untuk seluruh server.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Aktifkan',
    'ui__server/spam-filter/toggle_enable__title' => 'Aktifkan filter spam',
    'ui__server/spam-filter/toggle_unknown__description' => 'Aktifkan atau nonaktifkan filter spam untuk seluruh server.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Aktifkan atau nonaktifkan',
    'ui__server/spam-filter/toggle_unknown__title' => 'Aktifkan atau nonaktifkan filter spam',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Aktifkan atau nonaktifkan filter spam',

    'ui__server/spam-filter/white-list__description' => 'Atur daftar putih filter spam seluruh sistem.',
    'ui__server/spam-filter/white-list__short-title' => 'Daftar putih',
    'ui__server/spam-filter/white-list__title' => 'Daftar putih filter spam seluruh sistem',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Tambahkan hanya %1 alamat surel unik pertama.',
    'ui__server/spam-filter/white-list/address__description' => 'Alamat daftar putih filter spam.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Tidak ada alamat surel dalam daftar.',
    'ui__server/spam-filter/white-list/address__file_size' => 'File yang diunggah kosong.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Alamat surel berikut tidak valid: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Tidak ada alamat dalam daftar putih filter spam seluruh server.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Alamat',
    'ui__server/spam-filter/white-list/address__title' => 'Alamat daftar putih %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Tambah alamat ke daftar putih.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Tambah alamat',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Tambah alamat ke daftar putih',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Hapus alamat %1 dari daftar putih seluruh server.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Hapus',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Hapus alamat %1 dari daftar putih seluruh server',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Hapus alamat dari daftar putih seluruh server.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Hapus',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Hapus alamat dari daftar putih seluruh server',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Penghapusan alamat dari daftar putih filter spam seluruh server',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Pilih alamat filter spam yang akan Anda hapus dan klik Berikutnya >>.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Konfirmasi penghapusan alamat filter spam dengan mencentang kotak pilih dan klik Selesai untuk menghapusnya dan keluar dari panduan.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Hapus alamat dari daftar putih seluruh server.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Hapus',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Hapus alamat dari daftar putih seluruh server',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Penghapusan alamat dari daftar putih filter spam seluruh server',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Pilih alamat filter spam yang akan Anda hapus dan klik BerIkutnya >>.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Konfirmasi penghapusan alamat filter spam dengan mencentang kotak pilih dan klik Selesai untuk menghapusnya dan keluar dari panduan.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Tambahkan hanya %1 alamat surel unik pertama.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Tidak ada alamat surel dalam daftar.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Tidak dapat mengunggah berkas. Ukuran maksimum berkas untuk diunggah adalah %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Alamat surel berikut tidak valid: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Tambah alamat ke daftar putih.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Tambah alamat',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Tambah alamat ke daftar putih',

    'ui__support#param_company__title' => "Perusahaan",
    'ui__support#param_email__title' => "Surel",
    'ui__support#param_firstname__title' => "Nama depan",
    'ui__support#param_keynumber__title' => "Nomor kunci produk",
    'ui__support#param_operatingsystem__title' => "Sistem operasi",
    'ui__support#param_phone__title' => "Telepon",
    'ui__support#param_psabuild__title' => "build Plesk",
    'ui__support#param_psainsttype__title' => "Jenis pemasangan Plesk",
    'ui__support#param_psaversion__title' => "Versi Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Alat",

    'ui__reseller/traffic-history_unknown__short-title' => "Lihat Lalu-Lintas menurut Penyalur",
    'ui__reseller/traffic-history_unknown__title' => "Lihat Lalu-Lintas menurut Penyalur",
    'ui__reseller/traffic-history_unknown__description' => "Lihat lalu-lintas oleh akun penyalur.",
    'ui__reseller#list__title' => "Penyalur",
    'accounts_list__name__filter_title' => "Nama",
    'accounts_list__resource__filter_title' => "Penggunaan sumber daya",
    'resellers_list__filter_resource_usage_any' => "Apa saja",
    'resellers_list__filter_resource_usage_overuse' => "Penggunaan berlebih",
    'resellers_list__filter_resource_usage_normal' => "Di dalam batas",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Apa saja",
    'resellers_list__filter_status_blocked' => "Ditangguhkan",
    'resellers_list__filter_status_active' => "Aktif",
    'resellers_list__filter_clients__filter_title' => "Tunjukkan",
    'resellers_list__filter_clients_on' => "Penyalur dengan pelanggan mereka",
    'resellers_list__filter_clients_off' => "Penyalur saja",
    '__disk_usage' => "Penggunaan ruang disk",
    'ui__reseller/traffic_unknown__short-title' => "Lihat Lalu-Lintas menurut Penyalur",
    'ui__reseller/traffic_unknown__title' => "Lihat Lalu-Lintas menurut Penyalur",
    'ui__reseller/traffic#list__title' => "Lalu-lintas oleh penyalur",
    'ui__reseller/traffic_unknown__description' => "Lihat laporan penggunaan lalu-lintas.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Lalu-lintas oleh penyalur",

    '__reseller_name' => "Nama penyalur",
    '__reseller' => "Penyalur",
    'resellertrafficlist_header' => "Lihat Lalu-Lintas menurut Penyalur",
    '__reseller_personal' => "Lalu-lintas yang digunakan oleh domain penyalur",
    'ui__reseller/traffic-history__short-title' => "Lalu-lintas oleh penyalur",
    'ui__reseller/traffic-history__title' => "Lalu-lintas oleh penyalur",
    'ui__reseller/traffic-history__description' => "Lihat laporan penggunaan lalu-lintas.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Izinkan menjual berlebih",
    'limits__reseller_oversell_description' => "Penjualan berlebih mengizinkan penyalur untuk menjual lebih banyak sumber dari yang sesungguhnya dialokasikan untuknya. Bila penjualan berlebih diizinkan, penyalur diatur oleh penggunaan sumber daya aktual bukan oleh alokasi sumber daya awal",
    'limits__overuse_block_text' => "Kebijakan penggunaan berlebih",
    'limits__overuse_block_true_text' => "Penggunaan berlebih tidak diizinkan",
    'limits__reseller_overuse_block_true_description' => "Blokir penggunaan berlebih sumber daya. Penggunaan sumber daya aktual tidak boleh melebihi alokasi sumber daya di awal.",
    'limits__overuse_block_false_text' => "Penggunaan berlebih diizinkan",
    'limits__reseller_overuse_block_false_description' => "Jangan memblokir sumber daya yang penggunaannya berlebih, izinkan penyalur untuk menggunakan lebih banyak sumber daya daripada yang disediakan di awal. Penggunaan sumber daya aktual dapat melebihi alokasi sumber daya",
    'limits__reseller_overuse_notify_text' => "Beritahu penyalur bila hampir mencapai batas sumber daya",
    'reseller_perm__manage_sh_access_disabled' => "Penyalur tidak dapat memberi atau mencegah akses shell",
    'reseller_perm__manage_sh_access_chrooted' => "Penyalur dapat memberikan akses hanya ke wilayah yang di-chroot",
    'reseller_perm__manage_sh_access_any' => "Penyalur dapat memberikan akses ke tipe shell apa saja",
    'template__reseller_num_excl_ips' => "Alokasikan alamat IP khusus ke penyalur",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Akun",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Pelanggan",
    'ui__reseller#domainsTab__title' => "Domain",
    'ui__reseller__title' => "Kelola Akun Penyalur %1",
    'domains__reseller_info' => "%1 pelanggan, %2 domain, %3 ruang disk yang digunakan, %4 data yang ditransfer.",
    'domains__reseller_info_hiding_traffic' => "%1 pelanggan, %2 domain, %3 ruang disk yang digunakan.",
    'ui__reseller__description' => "Kelola akun penyalur.",

    'ui__reseller/limits_unknown__wizard-title' => 'Lihat atau ubah batas sumber daya penyalur',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Pilih penyalur yang Anda butuhkan.',
    'ui__reseller/limits_unknown__wizard__2' => 'Klik Selesai untuk menerapkan perubahan.',

    'ui__client/report_reseller__short-title' => "Laporan",
    'ui__client/report_reseller__title' => "Lihat Laporan Akun",
    'ui__client/report_reseller__description' => "Lihat laporan akun penyalur.",
    'ui__client/ip-pool_reseller__short-title' => "Kumpulan IP",
    'ui__client/ip-pool_reseller__description' => "Tetapkan alamat IP dan sertifikat SSL/TLS kepada akun penyalur.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Tetapkan pengaturan akun dan klik Selesai.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Lihat atau ubah izin penyalur',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Pilih penyalur yang izinnya ingin Anda lihat atau ubah.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Ketika telah selesai mengubah izin penyalur, Klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',

    // Customers > create customer account

    '__resellers_list' => 'Penyalur',
    'picker_reseller__title' => 'Pilih penyalur',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Alat",
    'ui__client#tools2__title' => "Akun",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Pelanggan",
    'ui__client#domainslist__title' => "Domain",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Semua aplikasi web sekarang diurutkan berdasarkan kategori, yang akan memudahkan untuk memilih aplikasi yang tepat untuk dipasang.",
    'feature__domainkeys__reseller' => "Anda dapat menggunakan mekanisme pembuktian keaslian pengirim surel DKIM untuk mengurangi jumlah surel spam dan phishing.",

    '__reseller_form' => "Format penyalur",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Pilih akun pelanggan yang akan Anda ubah pengaturannya.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Klik Batas Sumber Daya untuk mengubah batas penggunaan sumber daya.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Klik Izin untuk mengubah izin tindakan yang dapat dilakukan pelanggan di Plesk.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Buat template ini tersedia untuk pengguna yang lain",
    'template__shared_description' => "Pilih opsi ini agar pelanggan Anda dapat menggunakan template ini.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Alat',

    'ui__client/traffic-history_unknown__short-title' => 'Lihat Lalu-Lintas oleh Pelanggan',
    'ui__client/traffic-history_unknown__title' => 'Lalu-Lintas oleh Pelanggan',
    'ui__client/traffic-history_unknown__description' => 'Lihat laporan penggunaan lalu-lintas seluruh pelanggan',
    'ui__client/traffic-history__short-title' => 'Lalu-Lintas oleh Pelanggan',
    'ui__client/traffic-history__title' => 'Lihat Lalu-Lintas oleh Pelanggan',
    'ui__client/traffic-history__description' => 'Lihat laporan penggunaan lalu-lintas seluruh pelanggan',

    'ui__client/traffic#list__title' => 'Lalu-lintas oleh pelanggan',
    'ui__reseller/client/traffic#list__title' => 'Lalu-lintas oleh pelanggan',

    'clients_list__filter_type__filter_title' => 'Tunjukkan',
    'clients_list__filter_type_any' => 'Pelanggan dan penyalur',
    'clients_list__filter_type_clients' => 'Pelanggan saja',
    'clients_list__filter_type_resellers' => 'Penyalur saja',
    'ui__client/domain_unknown-new__short-title' => "Buat Domain",

    // Customers > View traffic by customers
    '__personal' => "Lalu-lintas digunakan untuk domain pengguna.",
    'PersonalTrafficList_header_of_client__' => "Lihat Laporan Penggunaan Lalu-Lintas Akun Anda",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Administrator domain tidak dapat mengizinkan atau melarang akses shell",
    'domain_perm__manage_sh_access_chrooted' => "Administrator domain dapat mengizinkan akses hanya ke lingkungan yang di-chroot",
    'domain_perm__manage_sh_access_any' => "Administrator domain dapat mengizinkan akses ke semua jenis shell",

    // APS Catalog
    'bt_add_to_vault' => "Tambah ke Brankas",
    'bt_hide_updates' => "Sembunyikan pembaruan yang tersedia",
    'bt_show_updates' => "Tunjukkan pembaruan yang tersedia",

    '__site_apps__applications' => "Aplikasi",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplikasi dipilih untuk ditambahkan ke brankas",
    'site_apps__application_selected' => "Dipilih",
    'site_apps__currently_in_vault' => "Versi yang lain sudah tersedia di brankas:",
    'site_apps__new_versions' => "Versi baru:",
    'site_apps__patches' => "Patch:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Jumlah aplikasi yang dijadwalkan untuk ditambahkan ke dalam brankas: %1",
    'site_apps__applications_downloading_now' => "Aplikasi berikut sedang diunduh: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Sudah tersedia di dalam brankas",

    // Server > Action Log
    'bt_skin_edit' => "Sunting Deskripsi Skin",
    'limits__oversell_legend' => "Menjual berlebih",
    'limitsManager__limit_available_error' => "Tidak dapat mengalokasikan jumlah sumber daya yang diminta (%%quantity%% %%limitName%%). Hanya %%available%% %%limitName%% yang tersedia.",
    'limitsManager__limit_reserved_error' => "Tidak dapat menetapkan batas penggunaan sumber daya yang diperlukan (%%quantity%% %%limitName%%) karena nilai yang baru kurang dari jumlah sumber daya yang dicadangkan untuk pelanggan Anda atau digunakan oleh Anda sendiri (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Tidak dapat menetapkan batas penggunaan sumber daya yang diminta (%%quantity%% %%limitName%%) karena nilai yang baru kurang dari jumlah sumber aktual yang telah digunakan oleh akun dan situs Anda (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Penggunaan lebar pita oleh layanan",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Lihat Laporan Penggunaan Lalu-Lintas",
    'ui__client/domain/traffic_unknown-reseller__title' => "Lihat Laporan Penggunaan Lalu-Lintas",

    'ui__client/domain_new__short-title' => "Buat Domain",

    'ui__client_reseller__description' => "Kelola akun penyalur %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Kelola akun penyalur",

    '__owner_name' => "Nama pemilik",
    'domains_list__resource__filter_title' => "Penggunaan Sumber Daya",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Katalog Aplikasi APS",
    'site_apps__applications_have_updates' => "Versi terkini dari aplikasi berikut telah tersedia: %1 Untuk melihat pembaruan, pastikan area Cari terlihat, pilih kotak cek <b>Tampilkan pembaruan saja</b> dan cari aplikasi yang Anda butuhkan.",
    'site_apps__progress_adding_to_vault' => "Ditambahkan ke brankas:",
    'site_apps__progress_done_message' => "Kemajuan:",
    'site_apps__progress_applications_left' => "%1 dari %2 aplikasi yang tersisa",
    'site_apps__download_item_long_task_title' => "Unduh aplikasi APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Unduh aplikasi APS dari Katalog APS",
    'site_apps__last_check_for_updates' => "pemeriksaan pembaruan terakhir: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Semua aplikasi terjadwal berhasil ditambahkan ke Brankas Aplikasi",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 aplikasi terjadwal berhasil ditambahkan ke Brankas Aplikasi.",
    'site_apps__no_search_results' => 'Aplikasi tidak ditemukan. Cobalah permintaan pencarian yang lain atau cari aplikasi berdasarkan kategori.',
    'site_apps__search_results_title' => 'Hasil pencarian',
    '__site_apps__search_by_application' => 'Nama aplikasi',
    '__site_apps__search_by_vendor' => 'Vendor',
    '__site_apps__search_by_vendor__all' => 'Semua vendor',
    '__site_apps__search_by_packager' => 'Pengemas',
    '__site_apps__search_by_certification_level' => 'Level sertifikasi',
    '__site_apps__search_by_cert__any' => 'Apa saja',
    '__site_apps__search_by_cert__silver_and_higher' => 'Perak dan yang lebih tinggi',
    '__site_apps__search_by_cert__gold_and_higher' => 'Emas dan yang lebih tinggi',
    '__retry' => 'Coba lagi',
    'site_apps__application_packager_site' => 'Pengemas',
    'site_apps__add_to_pool_message' => "Aplikasi yang ditandai sebagai \"tersedia untuk semua\" secara otomatis akan didistribusikan kepada seluruh penyalur dan pelanggan dan dengan jumlah pemasangan tidak terbatas. Aplikasi terbatas hanya akan didistribusikan kepada penyalur dan pelanggan secara manual dan individual dengan jumlah pemasangan yang telah ditentukan sebelumnya secara eksplisit.",
    'site_apps__make_available_for_all' => "Buat aplikasi terpilih tersedia untuk semua pengguna",

    'site_apps__broadcast_app_text' => "Aplikasi yang ditandai sebagai \"tersedia untuk semua\" secara otomatis akan didistribusikan kepada seluruh penyalur dan pelanggan dan dengan jumlah pemasangan tidak terbatas. Aplikasi terbatas hanya akan didistribusikan kepada penyalur dan pelanggan secara manual dan individual dengan jumlah pemasangan yang telah ditentukan sebelumnya secara eksplisit.",
    'site_apps__broadcast_app_name' => 'Buat aplikasi tersedia untuk semua pengguna',

    // User Application Pool per application
    'site_apps__available_clients' => 'Pengguna yang tersedia',
    'site_apps__no_more_clients_to_add_to_pool' => 'Tidak ada lagi akun pengguna yang dapat Anda sediakan aplikasi ini',

    // Installed application instances
    'site_apps__installations' => 'Pemasangan',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nama dan alamat IP domain",
    '__assign_ip_address' => "Tunjuk alamat IP",
    '__switch_on_service' => "Hidupkan layanan",
    '__hosting_configuration' => "Konfigurasi hosting",
    '__vrt_hst' => "Hosting situs web",
    '__vrt_hst_hint' => "Host situs web di server ini.",
    '__fwd' => "Penerusan",
    '__web_hosting_settings' => "Pengaturan hosting",
    '__fwd_hint' => "Alihkan pengunjung ke situs web lain.",
    '__none_hint' => "Jangan meng-host situs web saat ini.",
    '__login_hint' => "Nama pengguna ini digunakan untuk mengakses halaman web Anda melalui FTP",
    '__password_hint' => "Kata sandi ini digunakan untuk mengakses halaman web melalui FTP.",
    '__advanced_hosting_setup' => "Konfigurasi pengaturan lanjutan hosting situs web",
    '__domain_creation_successful' => "Domain telah dibuat.",
    'bt_hosting_settings' => "Pengaturan Hosting",
    '__change_hosting_type' => "Mengubah jenis hosting untuk domain %1",
    '__hosting_type_change_warning' => "Saat Anda mengubah tipe hosting menjadi penerusan atau tanpa hosting, semua file dan direktori yang berkaitan dengan situs Anda dihapus dari server. Pastikan memiliki salinan lokal situs Anda.",
    '__current_hosting_type' => "Jenis hosting saat ini",
    '__new_hosting_type' => "Jenis hosting baru",
    '__fwd_settings' => "Pengaturan penerusan",
    '__fwd_settings_legend' => "Pengaturan penerusan",
    '__fwd_destination_url' => "URL tujuan",
    '__fwd_type' => "Tipe penerusan",
    '__fwd_type_standart' => "Penerusan standar",
    '__fwd_type_standart_hint' => "Alihkan pengunjung ke situs web lain dan tunjukkan alamat tujuan agar mereka tahu tentang pengalihan tersebut.",
    '__fwd_type_frame' => "Penerusan bingkai",
    '__fwd_type_frame_hint' => "Alihkan pengunjung situs web ke situs lain, tetapi jangan menunjukkan alamat tujuan, agar mereka tidak tahu tentang pengalihan tersebut.",
    '__hosting_type_template_warning' => "Tipe hosting yang dipilih berbeda dari jenis yang ditentukan di template. Jika Anda teruskan, pengaturan hosting web di template terpilih akan diabaikan. Apakah Anda yakin ingin menetapkan jenis hosting pilihan?",

    '__no_resellers_selected' => "Anda harus memilih setidaknya satu akun penyalur.",

    'ui__client/logo_unknown__wizard-title' => 'Atur logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Silakan pilih pelanggan yang akan Anda ubah properti logonya.',
    'ui__client/logo_unknown__wizard__2' => 'Klik Selesai untuk menerapkan perubahan.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klik Selesai untuk menerapkan perubahan.',

    'ui__client/ipaddress/properties_new__short-title' => "Tambah Alamat IP",
    'ui__client/ipaddress/properties_new__title' => 'Tambah Alamat IP',
    'ui__client/ipaddress/properties_new__description' => "Tambah alamat IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Tambah Alamat IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Tambah Alamat IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Tambah Alamat IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Hapus Alamat IP",
    'ui__client/ipaddress/delete_multi__description' => "Hapus alamat IP.",
    'ippool_Manager__no_available_ips' => "Tidak ada alamat IP kosong di kumpulan IP.",
    'ippool_Manager__ip_shared' => "berbagi",
    'ippool_Manager__ip_exclusive' => "khusus",
    'ui__client/ipaddress/properties__title' => "Kelola Alamat IP",
    'ui__client/ipaddress/properties__description' => "Lihat atau ubah properti alamat IP.",
    'ui__client/ipaddress_unknown-new__title' => "Tambah Alamat IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Tambah Alamat IP",
    'ui__client/ipaddress_unknown-new__description' => "Tambah alamat IP.",

    'ui__mass-mail#to_resellers_text__title' => "Penyalur",
    'ui__mass-mail#to_domainusers_text__title' => "Administrator domain",
    'ui__mass-email#tools_legend__title' => "Alat",
    'ui__mass-email#list_legend__title' => 'Template pesan surel massal',
    'ui__mass-email#template_legend__title' => "Template",
    'ui__mass-email#from_email_text__title' => "Dari",
    'ui__mass-email#to_text__title' => 'Kepada',
    'ui__mass-email#to_resellers_text__title' => "Penyalur",
    'ui__mass-email#to_clients_text__title' => "Pelanggan",
    'ui__mass-email#to_domainusers_text__title' => "Administrator domain",
    'ui__mass-email#to_admin_text__title' => "Administrator Plesk",
    'ui__mass-email#option_mode_all__title' => "Semua",
    'ui__mass-email#option_mode_select__title' => "Hanya yang dipilih",
    'ui__mass-email#option_mode_except__title' => "Semua kecuali yang dipilih",
    'ui__mass-email#option_select_template__title' => '--Pilih template--',
    'ui__mass-email#subject_text__title' => "Subjek",
    'ui__mass-email#body_text__title' => "Teks pesan",
    'ui__mass-email#save_as_legend__title' => "Simpan sebagai template",
    'ui__mass-email#save_as_text__title' => "Simpan pesan yang dibuat ke dalam template baru bernama",
    'ui__reseller/preferences_unknown__wizard-title' => "Ubah Pengaturan Akun",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Pilih penyalur yang ingin Anda ubah pengaturan akunnya dan klik Berikutnya.",
    'ui__reseller/preferences_unknown__wizard__2' => "Tetapkan pengaturan akun dan klik OK.",
    'ippoolManager__ip_shared' => "berbagi",
    'ippoolManager__ip_exclusive' => "khusus",

    '__users_list' => "Pengguna",
    '__users' => "Pengguna",
    '__user_name' => "Nama pengguna",

    'limit__name_max_dom_aliases' => "alias domain",
    'limit__name_max_subftp_users' => "akun FTP tambahan",
    'limit__name_max_mssql_db' => "Basis data Server Microsoft SQL",
    'limit__name_max_iis_app_pools' => "Kumpulan aplikasi IIS",
    'limit__name_max_odbc' => "Koneksi ODBC",
    'total_mboxes_quota_unsupported' => 'tidak didukung oleh server surat',
    'limit_soft__disk_space' => 'Beritahu saat mencapai ruang disk',
    'limit_soft__max_traffic' => 'Beritahu saat mencapai lalu-lintas',
    'limitsManager__commit_failed' => "Tidak dapat mengubah batas sumber daya.",
    'limitsManager__date_in_past' => "Tanggal kedaluwarsa %1 salah.",
    'limitsManager__limit_not_supported' => "Batas untuk sumber daya jenis %1 tidak dapat ditetapkan.",
    'limitsManager__limit_oversell_inconsistency' => "Tidak dapat mengalokasikan jumlah sumber daya yang ditentukan dengan penjualan berlebih dimatikan.",
    'limitsManager__limit_overuse_inconsistency' => "Penggunaan sumber daya melebihi batas yang ditentukan.",
    'limitsManager__no_resource_available' => "Tidak ada lagi sumber daya yang tersisa untuk tipe ini (%%limitName%%). Permintaan: %%quantity%%; tersedia: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Tidak ada sumber daya untuk tipe ini (%%limitName%%) yang tersedia dari penyedia layanan Anda. Permintaan: %%quantity%%; tersedia: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Tanggal kedaluwarsa harus kurang dari atau sama dengan %1.",
    'limitsManager__invalid_disk_space_limit' => "Jumlah ruang disk harus kurang dari atau sama dengan %1.",
    'limitsManager__invalid_max_traffic_limit' => "Jumlah lalu-lintas harus kurang dari atau sama dengan %1.",
    'ippoolManager__ip_has_suballocations' => "Tidak dapat mengubah jenis alamat IP yang sudah dialokasikan ke pengguna. Alamat IP %%ip%% sudah dialokasikan ke pengguna sebagai alamat IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Alamat IP sudah ditugaskan ke pengguna.",
    'ippoolManager__ip_is_not_in_pool' => "Tidak ada alamat IP %%ip%% di kumpulan.",
    'ippoolManager__can_not_allocate_ip' => "Alamat IP %%ip%% tersedia hanya sebagai %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Alamat IP %%ip%% tidak dapat dialokasikan sebagai khusus.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Alamat IP %%ip%% sudah digunakan untuk hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "Akses FTP anonim sudah dihidupkan untuk alamat IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Tidak ada alamat IP kosong.",
    'ippoolManager__no_available_ips' => "Tidak ada alamat IP yang tersedia.",
    'templates__dublicate_name' => "Template dengan nama tersebut sudah ada. Harap pilih nama lain untuk template ini.",
    'cl_perm__client_limits_exceeded' => "Nilai batas sumber daya yang ditentukan melebihi nilai yang diperkenankan oleh paket hosting Anda, atau nilai ini memberikan lebih sedikit sumber daya daripada yang sedang digunakan oleh situs Anda.",
    'cl_perm__reseller_limits_exceeded' => "Nilai batas sumber yang ditentukan melebihi nilai yang diperkenankan oleh paket hosting Anda, atau nilai ini menyediakan sumber yang lebih sedikit daripada yang sedang digunakan oleh akun pengguna dan situs saat ini.",

    'site_apps__preferences_show_all_versions_title' => "Tunjukkan daftar lengkap versi untuk setiap aplikasi yang diambil dari katalog.",
    'site_apps__preferences_show_all_versions_hint' => "Jika Anda memilih opsi ini, maka sistem akan memerlukan waktu untuk mengumpulkan semua versi dari masing-masing aplikasi setiap kali Anda membuka katalog. Jika opsi ini tidak dipilih, maka hanya versi terbaru saja yang akan dimunculkan.",
    '__select_user_template' => "Buat akun pengguna berdasarkan template",
    'ip_already_added_to_all_clients' => "Alamat IP ini sudah ditugaskan ke semua pengguna.",
    'ui__server/ip-address/client/delete#legend__description' => "Alamat IP berikut akan dihapus dari sistem dan kumpulan IP pengguna:",

    'site_apps__cancelled_apps' => "Penambahan aplikasi berikut telah dibatalkan: %2",

    'sb_url_is_not_resolved' => 'URL tidak dapat diputuskan: periksa pengaturan DNS Anda. URL %1 harus terungkap menjadi alamat IP server dengan Presence Builder terpasang.',

    'ip_addr__is_last_on_interface' => 'Tidak dapat menghapus alamat IP %%ip%% karena alamat ini merupakan alamat IP terakhir yang ada di antarmuka jaringan.',
    'ip_addr__used_for_current_session' => 'Tidak dapat menghapus alamat IP %%ip%% karena alamat tersebut digunakan oleh sesi aktif.',
    'ip_addr__used_for_hosting' => 'Tidak dapat menghapus alamat IP %%ip%% karena alamat tersebut digunakan untuk meng-host situs web.',
    'ip_addr__is_main' => 'Tidak dapat menghapus alamat IP %%ip%% karena alamat ini merupakan alamat IP utama dari antarmuka jaringan.',
    'ip_addr__ip_used_by_message_submission' => 'Tidak dapat menghapus alamat IP %%ip%% karena alamat ini digunakan untuk pengajuan pesan surat',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domain pelanggan',
    'excl_ip_num' => 'Alamat IP khusus',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder belum dipasang.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Izin untuk membolehkan penjualan berlebih tidak bisa ditarik dari pengguna karena pengguna telah mengalokasikan lebih banyak sumber daya daripada yang tersedia, masuk ke dalam mode penjualan berlebih.',
    'limitsManager__invalid_limit_value' => 'Nilai salah %%value%% ditentukan untuk batas %%limit_name%%',
    'limit__max_mn' => 'Jumlah maksimum akun surat',

    'limits__client_overuse_description' => 'Kebijakan penggunaan berlebih memberitahu Plesk apa yang harus dilakukan ketika penggunaan sumber melebihi alokasi sumber daya pada awalnya.',
    'limits__client_overuse_block_true_description' => 'Blokir penggunaan berlebih sumber daya. Penggunaan sumber daya aktual tidak boleh melebihi alokasi sumber daya di awal.',
    'limits__client_overuse_block_false_description' => 'Jangan memblokir sumber daya yang penggunaannya berlebih, izinkan pelanggan untuk menggunakan lebih banyak sumber daripada yang disediakan di awal. Penggunaan sumber daya aktual dapat melebihi alokasi sumber daya',
    'limits__client_overuse_notify_text' => 'Beritahu pelanggan saat hampir mencapai batas sumber daya',

    'limits__domain_overuse_description' => 'Kebijakan penggunaan berlebih memberitahu Plesk apa yang harus dilakukan ketika penggunaan sumber melebihi alokasi sumber daya pada awalnya.',
    'limits__domain_overuse_block_true_description' => 'Kebijakan penggunaan berlebih memberitahu apa yang harus dilakukan Plesk ketika sumber daya digunakan berlebih.',
    'limits__domain_overuse_block_false_description' => 'Jangan memblokir sumber daya yang penggunaannya berlebih, izinkan domain untuk menggunakan lebih banyak sumber daya daripada yang disediakan di awal. Penggunaan sumber daya aktual dapat melebihi alokasi sumber daya',
    'limits__domain_overuse_notify_text' => 'Beritahu pemilik domain saat hampir mencapai batas sumber daya',

    'dns__dns_rr_delete' => 'Item yang akan dihapus',
    'dns__delete_rr' => 'Catatan DNS berikut ini akan dihapus dari zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Item yang tidak dapat dihapus',
    'dns__non_delete_rr' => 'Catatan DNS berikut tidak dapat dihapus:',
    'dns__dns_rr_delete_confirm_message' => 'Konfirmasi penghapusan catatan DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Format aplikasi web tidak diketahui: aplikasi web tidak tersedia untuk dipasang atau digunakan.',

    '__php_handler_type_desc' => 'Jalankan PHP sebagai',
    'sfdk_domain_sign__failed' => 'Kesalahan tidak teridentifikasi terjadi ketika menghidupkan penandaan surat dengan DKIM di domain. Lihat catatan galat server untuk informasi lebih jauh.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notifikasi keberhasilan pembaruan kunci Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notifikasi penundaan pembaruan kunci Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notifikasi kesalahan pembaruan kunci Plesk',
    'pkey_notify__update_successful' => 'Pembaruan %1 berhasil.',
    'pkey_notify__update_failed_no_more_try' => 'Tidak dapat memperbarui %1. Kunci yang coba Anda kirimkan tidak valid. Anda sebaiknya tidak mencoba memperbarui kunci ini lagi.',
    'pkey_notify__update_failed_try_later' => 'Tidak dapat memperbarui %1: kesalahan terjadi ketika memproses kunci Anda. Anda dapat mencoba mengambil kunci secara manual di Plesk (Perangkat & Pengaturan > Informasi Lisensi) atau biarkan Plesk mencoba memperbaruinya dalam waktu 24 jam. Jika Anda tidak ingin menerima notifikasi ini lagi, hapus kunci ini dari Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Tidak dapat mematikan filter spam seluruh server.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Tidak dapat mematikan filter spam seluruh server',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domain',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Penerus',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Pelanggan',
    '__cl_name' => 'Nama pelanggan',
    '__cl_creation_date' => 'Tanggal pembuatan',
    '__clients_traffic' => 'Lalu-lintas pelanggan',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder belum dipasang.',
    'sitebuilder_disabled' => 'Presence Builder dimatikan.',
    'b_sitebuilder_disabled' => 'Presence Builder dimatikan.',
    'webmail_not_installed' => 'Perangkat lunak webmail tidak terpasang.',
    'webmail_disabled' => 'Layanan webmail dimatikan.',
    'spamassassin_not_installed' => 'SpamAssassin belum terpasang.',
    // pfu:
    'anonymous_ftp_shared' => 'Tidak dapat membuat pengaturan FTP anonim: tipe alamat IP bersama.',
    'anonymous_ftp_used' => 'Tidak dapat membuat pengaturan FTP anonim: alamat IP digunakan oleh domain lain untuk layanan FTP anonim.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET belum dipasang.',
    'site_builder_no_package' => 'Presence Builder tidak tersedia. Harap periksa kembali apakah Presence Builder telah terpasang dengan benar dan telah dipilih sebagai komponen aktif.',
    'site_builder_not_configured' => 'Presence Builder belum dikonfigurasi.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Alat',
    'ui__reseller/client#clientslist__title' => 'Pelanggan',

    //reseller accounts removal

    // NEW HOME PAGE WIZARDS

    // PFW-only

    // COMMON WIZARDS

    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Atur FTP anonim pada domain',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Pilih domain yang akan Anda atur FTP anonimnya.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Atur pengelola log untuk domain dan lihat file log domain',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Pilih domain yang pengelola lognya akan Anda atur dan file lognya akan Anda lihat.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Kelola sertifikat SSL/TLS untuk domain',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Pilih domain yang sertifikat SSL/TLS-nya ingin Anda kelola.',

    'ui__client/domain/disable_multi__wizard-title' => 'Tangguhkan Domain',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Pilih domain yang akan Anda tangguhkan.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktifkan Domain',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Pilih domain yang akan Anda aktifkan.',

    'ui__client/domain_unknown__wizard-title' => 'Lihat Domain',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Pilih pelanggan yang akan Anda lihat domainnya.',

    'ui__client/domain/register_unknown__wizard-title' => 'Daftarkan Domain',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Pilih domain yang akan Anda daftarkan.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Gunakan Alat dari MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Pilih domain yang akan Anda kelola dengan menggunakan alat dari MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Pengguna Alamat IP',
    'ui__server/ip-address/client_unknown__title' => 'Pengguna Alamat IP',
    'ui__server/ip-address/client_unknown__description' => 'Pengguna alamat IP %1',

    'disabled_by_admin' => 'Dinonaktifkan oleh administrator server',






    'ui__client/domain/chowner_multi__short-title' => 'Ubah kepemilikan',
    'ui__client/domain/chowner_multi__title' => 'Ubah kepemilikan langganan',
    'ui__client/domain/chowner_multi__description' => 'Ubah kepemilikan langganan.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Pilih domain yang ingin Anda ubah kepemilikannya dan klik Berikutnya >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Ubah kepemilikan',
    'ui__client/domain/chowner_unknown__title' => 'Ubah kepemilikan langganan',
    'ui__client/domain/chowner_unknown__description' => 'Ubah kepemilikan langganan.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Ubah kepemilikan langganan',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Tidak ada tombol suai.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Tidak ada tombol suai di antarmuka penyalur %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Hapus tombol %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Hapus',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Hapus tombol %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Hapus tombol suai dari antarmuka penyalur',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Hapus',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Hapus tombol suai',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Hapus tombol',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Pilih penyalur yang tombol suainya ingin Anda hapus dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Pilih tombol yang ingin Anda hapus dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Konfirmasi penghapusan tombol suai dengan mencentang kotak pilih pada layar ini, dan kemudian klik Selesai.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Hapus tombol suai dari antarmuka penyalur.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Hapus',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Hapus tombol suai',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Hapus tombol suai',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Pilih penyalur yang tombol suainya ingin Anda hapus dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Pilih tombol suai yang ingin Anda hapus dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Konfirmasi penghapusan tombol suai dengan mencentang kotak pilih dan kemudian klik Selesai.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Sunting tombol suai level penyalur %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Pengaturan',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Ubah tombol suai penyalur %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Tambah tombol suai',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Pilih penyalur yang antarmukanya ingin Anda buatkan tombol suai dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik Selesai untuk membuat tombol.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Ubah properti tombol di antarmuka penyalur.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Properti',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Ubah properti tombol di antarmuka penyalur',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Ubah properti tombol suai',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Pilih penyalur yang tombol suainya ingin Anda ubah dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Pilih tombol suai yang ingin Anda modifikasi dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Ketika telah selesai menyunting properti tombol, klik Selesai untuk menerapkan perubahan dan keluar dari panduan.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Buat tombol %1 tidak tersedia untuk pelanggan Anda.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Buat tidak tersedia untuk pelanggan Anda',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Buat tombol %1 tidak tersedia untuk pelanggan Anda',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Buat tombol %1 terlihat untuk pelanggan penyalur.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Buat tersedia untuk pelanggan Anda',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Buat tombol %1 terlihat untuk pelanggan penyalur',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Buat tombol suai tersedia/tidak tersedia untuk pelanggan Anda.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tersedia/tidak tersedia untuk pelanggan Anda',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Buat tombol suai tersedia atau tidak tersedia untuk pelanggan Anda',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Buat tombol suai tersedia/tidak tersedia untuk pelanggan Anda.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Pilih penyalur yang tombol suainya ingin Anda buat tersedia bagi pelanggan penyalur dan klik Berikutnya >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Pilih tombol suai yang ingin Anda sediakan atau tidak sediakan untuk pelanggan Anda dan klik Berikutnya >>.',

    '__not_allowed' => 'Tidak diizinkan',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Pilih pemilik baru domain.',

    '__ip_addr_state_unknown' => "Alamat IP sedang tidak berfungsi karena sistem masih memproses permintaan Anda. Harap tunggu sebentar.",


    'resellers_list__accounts' => 'Pengguna',

    'ip_addr__repair_is_not_allowed' => 'Alamat IP tidak dapat diperbaiki di dalam lingkungan Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Penyalur %1 tidak memiliki pelanggan.',

    'ippoolManager__ip_used_by_nohost_domain' => "Alamat IP %%ip%% tidak dapat dihapus karena digunakan oleh satu atau lebih domian tanpa hosting.",
    'ippoolManager__ip_used_for_mail_service' => "Alamat IP %%ip%% tidak dapat dihapus karena digunakan oleh satu atau lebih domain untuk alamat IP layanan surat mereka.",
    'ippoolManager__ip_used_for_send_emails' => "Alamat IP %%ip%% tidak dapat dihapus karena digunakan untuk mengirimkan email dari IP spesifik (lihat Pengaturan Server Surat).",
    'ippoolManager__ip_used_in_dns_zone' => 'Alamat IP %%ip%% tidak dapat dihapus karena digunakan oleh zona DNS dari satu atau lebih domain.',
    'ip_ctrl__cannot_manage_on_vz' => 'Pemasangan Plesk ini bekerja di bawah penampung Virtuozzo. Alamat IP baru dapat ditambahkan hanya oleh administrator simpul penampung Virtuozzo.',

    'client_template__limits_auto_adjusted' => 'Batas dari template pelanggan disesuaikan secara otomatis.',

    '__entries' => 'Entri',

    '__path_is_not_set' => 'Jalur tidak diberikan. Harap berikan jalur yang valid.',

    'defaultcomponents__imap_required' => '(server surat saat ini tidak mendukung IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk hanya mendukung perangkat lunak statistik web komersial untuk kalkulasi statistik subdomain. Perangkat lunak yang dimaksud tidak terpasang pada sistem.',


    'server_settings_invalid_traffic_statistics' => 'Parameter statistik untuk mempertahankan lalu lintas tidak valid.',
    'server_settings_invalid_logrotate_period' => 'Parameter periode rotasi log tidak valid.',

    'spam_filter/address/file_size' => 'Tidak dapat mengunggah berkas. Ukuran maksimum berkas untuk diunggah adalah %1.',
    'spam_filter/address/file_empty_content' => 'Ada masalah membaca alamat mail dari file. Pastikan Anda mengunggah file dalam pengkodean UTF-8 yang berisi satu atau beberapa alamat email, lalu coba lagi.',
    'spam_filter/address/addresses_empty_content' => 'Tidak ada alamat surel dalam daftar.',
    'spam_filter/address/addresses_available' => 'Tambahkan hanya %1 alamat surel unik pertama.',
    'spam_filter/address/invalid_addresses' => 'Alamat surel berikut tidak valid: %1.',

    'current_resources' => 'Sumber daya saat ini',
    'plan_limitations' => 'Batas paket',
    'cannot_switch_plan' => 'Tidak dapat beralih ke rencana yang dipilih, karena sumber daya saat ini melebihi batas paket:',
];