<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => '설치된 응용 프로그램',
    'app.instances.buttonCheckForUpdates' => '업데이트 확인',
    'app.instances.buttonScan' => '스캔',
    'app.instances.hintButtonScan' => '응용 프로그램의 구독에서 파일을 스캔합니다.',
    'app.instances.taskScan' => '응용 프로그램 스캐닝 중...',
    'app.instances.undefinedApp' => '정의되지 않음',
    'app.instances.name' => '이름',
    'app.instances.installedTo' => '설치 경로',
    'app.instances.uninstall' => '제거',
    'app.instances.update' => '업데이트 가능',
    'app.instances.noUpdates' => '업데이트가 없습니다. 모든 응용 프로그램이 최신 상태입니다.',
    'app.instances.foundUpdates' => '업데이트 가능:',
    'app.instances.noInstallationUrlAvailable' => '없음',

    'app.packages.title' => '사용 가능한 응용 프로그램',
    'app.packages.name' => '이름',
    'app.packages.version' => '버전',
    'app.packages.summary' => '요약',
    'app.packages.install' => '설치',

    'app.services.title' => '사용 가능한 서비스',
    'app.services.serviceID' => '서비스 ID',
    'app.services.name' => '이름',
    'app.services.summary' => '요약',
    'app.services.instantiate' => '인스턴스 만들기',

    'app.subserviceinstances.remove' => '제거',
    'app.subserviceinstances.hintRemove' => '선택한 서비스 인스턴스를 제거합니다.',
    'app.subserviceinstances.confirmOnDelete' => '선택한 서비스 인스턴스를 제거하시겠습니까?',
    'app.subserviceinstances.serviceName' => '서비스 이름',
    'app.subserviceinstances.userName' => '사용자',

    'contentfiles.name' => '이름',
    'contentfiles.changeDate' => '수정됨',
    'contentfiles.size' => '크기',
    'contentfiles.permissions' => '권한',
    'contentfiles.user' => '사용자',
    'contentfiles.group' => '그룹',
    'contentfiles.buttonUploadFiles' => '파일 업로드',
    'contentfiles.buttonUploadDirectory' => '디렉터리 업로드',
    'contentfiles.buttonImportFileViaUrl' => 'URL을 통해 파일 임포트',
    'contentfiles.hintUploadFiles' => '현재 디렉터리에 파일을 업로드합니다.',
    'contentfiles.buttonDeleteFile' => '제거',
    'contentfiles.hintDeleteFile' => '선택한 파일을 제거합니다.',
    'contentfiles.buttonPurgeFile' => '제거',
    'contentfiles.hintPurgeFile' => '선택한 파일을 영구적으로 제거합니다.',
    'contentfiles.buttonPurgeAll' => '휴지통 비우기',
    'contentfiles.buttonRotationSettings' => '순환 설정',
    'contentfiles.hintRotationSettings' => '순환 설정 사용자 정의',
    'contentfiles.hintPurgeAll' => '휴지통에서 모든 파일과 디렉터리를 영구적으로 제거합니다.',
    'contentfiles.buttonCopyFiles' => '복사',
    'contentfiles.hintCopyFiles' => '선택한 파일을 다른 디렉터리에 복사합니다.',
    'contentfiles.buttonMoveFiles' => '이동',
    'contentfiles.hintMoveFiles' => '선택한 파일을 다른 디렉터리에 이동합니다.',
    'contentfiles.buttonMoreActions' => '기타',
    'contentfiles.buttonCalculateSize' => '크기 계산',
    'contentfiles.hintCalculateSize' => '선택한 파일의 총 크기를 계산합니다.',
    'contentfiles.buttonChangeTimestamp' => '타임스탬프 변경',
    'contentfiles.hintChangeTimestamp' => '선택한 파일의 타임스탬프를 변경합니다.',
    'contentfiles.buttonArchiveActions' => '압축 파일',
    'contentfiles.buttonExtractArchive' => '파일 압축 풀기',
    'contentfiles.hintExtractArchive' => '현재 디렉터리에 선택한 아카이브 파일의 압축을 풉니다.',
    'contentfiles.buttonCreateArchive' => '아카이브에 추가',
    'contentfiles.hintCreateArchive' => '선택한 파일을 아카이브에 추가합니다.',
    'contentfiles.buttonNewActions' => '새로 생성',
    'contentfiles.buttonNewFile' => '파일 만들기',
    'contentfiles.hintNewFile' => '파일을 생성합니다.',
    'contentfiles.buttonNewDirectory' => '디렉터리 만들기',
    'contentfiles.hintNewDirectory' => '디렉터리를 생성합니다.',
    'contentfiles.rootDirectory' => '홈 디렉터리',
    'contentfiles.buttonView' => '설정',
    'contentfiles.hintView' => '파일 관리자 설정을 변경합니다.',
    'contentfiles.confirmOnDelete' => '{count, plural, =1 {{name}을(를)} other {선택한 파일과 디렉터리 #개를}} 영구적으로 제거하시겠습니까?',
    'contentfiles.confirmOnDeleteToTrash' => '{count, plural, =1 {{name}을(를)} other {선택한 파일과 디렉터리 #개를}} 휴지통으로 이동하시겠습니까?',
    'contentfiles.deleteWithForce' => '휴지통을 건너뛰고 {count, plural, =1 {{name}을(를)} other {선택한 파일과 디렉터리 #개를}} 영구적으로 제거합니다.',
    'contentfiles.confirmOnPurge' => '{count, plural, =1 {{name}을(를)} other {선택한 파일과 디렉터리 #개를}} 영구적으로 제거하시겠습니까?',
    'contentfiles.confirmOnPurgeAll' => '휴지통에서 모든 파일과 디렉터리를 영구적으로 제거하시겠습니까?',
    'contentfiles.waitMessage' => '기다려 주십시오...',
    'contentfiles.readonlyHint' => '이 디렉터리는 읽기 전용입니다. 여기서 파일이나 디렉터리를 만들 수 없습니다.',
    'contentfiles.directoryNotFound' => '디렉터리 %%directory%%을(를) 생성할 수 없음: %%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => '웹 공간의 symlink는 금지된 %%symlink%%입니다. %%error%%',
    'contentfiles.dragAndDropArea' => '업로드하려면 여기에 디렉터리 또는 파일을 드롭하세요',
    'contentfiles.nonUTF8' => '파일 관리자는 이름에 UTF-8이 아닌 문자가 있는 파일과 디렉터리는 열 수 없습니다.',
    'contentfiles.non4ByteChar' => '파일 관리자는 이름에 4바이트 문자가 있는 파일과 디렉터리는 열 수 없습니다.',
    'contentfiles.searchInFilename' => '파일 이름 검색',
    'contentfiles.searchInFilenameAndContent' => '파일 이름 및 내용 검색',
    'contentfiles.searchInContent' => '내용 검색',
    'contentfiles.menuItemFilename' => '파일 이름만',
    'contentfiles.menuItemFilenameAndContent' => '파일 이름 및 내용',
    'contentfiles.menuItemContent' => '내용만',
    'contentfiles.noEntriesFound' => '항목을 찾을 수 없습니다.',
    'contentfiles.loadingTitle' => '검색 중...',
    'contentfiles.searchError' => '현재 디렉터리에서 파일을 검색할 수 없습니다.',
    'contentfiles.searchErrorTimeout' => '검색이 너무 오래 걸려서 취소되었습니다.',
    'contentfiles.item-action-view' => '보기',
    'contentfiles.item-action-textCodeEditor' => '코드 편집기에서 편집',
    'contentfiles.item-action-visualEdit' => 'HTML 편집기에서 편집',
    'contentfiles.item-action-textEdit' => '텍스트 편집기에서 편집',
    'contentfiles.item-action-browse' => '브라우저에서 열기',
    'contentfiles.item-action-logBrowser' => 'Log Browser에서 열기',
    'contentfiles.item-action-download' => '다운로드',
    'contentfiles.item-action-permissions' => '권한 변경',
    'contentfiles.item-action-rename' => '이름 바꾸기',
    'contentfiles.item-action-extractArchive' => '파일 압축 풀기',
    'contentfiles.item-action-imageView' => '보기',
    'contentfiles.imageViewer' => '이미지 뷰어',
    'contentfiles.tooltipReadOnly' => '현재 디렉터리는 읽기 전용입니다. 여기서 파일이나 디렉터리를 만들 수 없습니다.',

    'database.issues.type' => '유형',
    'database.issues.table' => '표',
    'database.issues.code' => '코드',
    'database.issues.problem' => '문제',
    'database.issues.icon-title-att' => '경고',
    'database.issues.icon-title-warning' => '오류',

    'database.users.login' => '이름',
    'database.users.server' => '데이터베이스 서버',
    'database.users.database' => '데이터베이스',
    'database.users.remove' => '제거',
    'database.users.hintRemove' => '선택한 데이터베이스 사용자를 제거합니다.',
    'database.users.confirmOnDelete' => '{count, plural, =1 {{login} 데이터베이스 사용자를} other {선택한 데이터베이스 사용자 #명을}} 제거하시겠습니까?',
    'database.users.disabledSelectHint' => '설치된 웹 응용 프로그램에 의해 사용됩니다',
    'database.users.orphanedHint' => '복원 프로세스 후 분리되었습니다. 사용자를 %%orphanedRepairLink%%하십시오.',
    'database.users.orphanedRepairLink' => '복구',
    'database.users.anyDatabase' => '임의의 데이터베이스',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => '구독으로 이동',
    'databases.assignToSubscription_powerUser' => '웹 공간으로 이동',
    'databases.assignToSubscriptionPopupTitle' => '다른 구독으로 데이터베이스 이동',
    'databases.assignToSubscriptionPopupTitle_powerUser' => '다른 웹 공간으로 데이터베이스 이동',
    'databases.assignToSubscriptionPopupDesc' => '선택한 데이터베이스는 선택한 구독으로 이동됩니다. 다른 데이터베이스에 액세스되지 않는 경우 데이터베이스 사용자도 이동됩니다.',
    'databases.assignToSubscriptionPopupDesc_powerUser' => '선택한 데이터베이스가 선택한 웹 공간으로 이동됩니다. 다른 데이터베이스에 액세스되지 않는 경우 데이터베이스 사용자도 이동됩니다. 이동한 다음 이전 사용자는 Plesk 링크를 사용하여 컨텐츠를 관리하기 위해 데이터베이스를 열 수 없으므로 주의하십시오.',
    'databases.loading' => '로딩',
    'databases.name' => '이름',
    'databases.type' => 'T',
    'databases.server' => '데이터베이스 서버',
    'databases.users' => '사용자',
    'databases.remove' => '제거',
    'databases.hintRemove' => '선택한 데이터베이스를 제거합니다.',
    'databases.confirmOnDelete' => '{count, plural, =1 {{name} 데이터베이스} other {선택한 데이터베이스 #개}}를 제거하시겠습니까?',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'MS SQL 서버',
    'databases.serverMysql' => '로컬 MariaDB/MySQL 서버',
    'databases.serverPostgresql' => '로컬 PostgreSQL 서버',
    'databases.serverMssql' => '로컬 MS SQL 서버',
    'databases.disabledSelectHint' => '설치된 웹 응용 프로그램에 의해 사용됩니다',
    'databases.buttonMakeCopy' => '복사',
    'databases.buttonMakeCopyHint' => '데이터베이스의 정확한 복사본을 생성하거나 그 내용을 기존 데이터베이스에 복사합니다.',
    'databases.buttonWebadmin' => 'Webadmin',
    'databases.buttonWebadminHint' => '웹 인터페이스를 사용하여 데이터베이스를 관리합니다.',
    'databases.buttonConnectionInfo' => '연결 정보',
    'databases.buttonConnectionInfoHint' => '이 데이터베이스에 연결하려면 호스트 이름 및 데이터베이스 사용자 자격 증명과 같은 정보가 필요합니다.',
    'databases.buttonPhpMyAdmin' => 'phpMyAdmin',
    'databases.buttonMSSQLClientInstruction' => '로컬 SQL 클라이언트 다운로드',
    'databases.buttonMSSQLClientInstructionHint' => '로컬 SQL 클라이언트 다운로드',
    'databases.buttonDownloadDump' => '덤프 내보내기',
    'databases.buttonDownloadDumpHint' => '이 데이터베이스의 사본을 내보냅니다.',
    'databases.buttonUploadDump' => '덤프 가져오기',
    'databases.buttonUploadDumpHint' => '이 데이터베이스의 사본을 가져옵니다.',
    'databases.buttonDelete' => '데이터베이스 제거',
    'databases.buttonDeleteHint' => '이 데이터베이스를 제거합니다.',
    'databases.buttonDeleteDisabledHint' => '데이터베이스를 제거할 수 없습니다. 설치된 웹 응용 프로그램에 의해 사용됩니다.',
    'databases.buttonDeleteConfirmationText' => '%%name%% 데이터베이스를 제거하시겠습니까?',
    'databases.buttonActiveList' => '활성 목록',
    'databases.buttonActiveListHint' => '보기 모드 전환',
    'databases.buttonCheckAndFix' => '검사 및 복구',
    'databases.buttonCheckAndFixHint' => '검사를 통해 파손된 표 구조와 같은 문제를 확인하고 해결합니다.',
    'databases.buttonAssignToSubscription' => '구독으로 이동',
    'databases.buttonAssignToSubscriptionHint' => '다른 구독으로 데이터베이스 이동',
    'databases.buttonAssignToSubscription_powerUser' => '웹 공간으로 이동',
    'databases.buttonAssignToSubscriptionHint_powerUser' => '다른 웹 공간으로 데이터베이스 이동',
    'databases.promptPassword' => '데이터베이스 사용자 %%login%%(으)로 로그인하는 데 필요한 암호를 입력합니다.',
    'databases.promptPasswordPopupTitle' => '암호 제공',
    'databases.taskCheckDatabase' => '데이터베이스 검사',
    'databases.taskRepairDatabase' => '데이터베이스 복구',
    'databases.downloadTask' => '%%database%%의 덤프 내보내기 준비 중…',
    'databases.downloadPopupTitle' => '덤프 내보내기',
    'databases.downloadHint' => '%%database%%의 덤프를 생성하고 다운로드하려고 합니다.',
    'databases.downloadRelativePath' => '다음 디렉토리에 덤프 저장',
    'databases.downloadDumpName' => '덤프 파일 이름',
    'databases.downloadDumpAutomatically' => '덤프 생성 후 자동으로 다운로드',
    'databases.errorDumpNameEmpty' => '덤프 이름을 입력하십시오.',
    'databases.errorDumpNameInvalid' => '덤프 이름에 포함될 수 없는 문자: %%chars%%.',
    'databases.errorDumpNameTooLong' => '덤프 파일 이름이 너무 깁니다. 전체 덤프 경로가 %%maxLength%%개 기호를 초과할 수 없습니다.',
    'databases.uploadTask' => '%%database%%의 덤프 가져오는 중…',
    'databases.uploadPopupTitle' => '데이터베이스 덤프 가져오기',
    'databases.uploadHint' => '로컬 컴퓨터에서 덤프를 로드하거나 호스팅 서버에 저장된 덤프를 가져옵니다.',
    'databases.uploadFromFile' => '업로드',
    'databases.uploadFromWebspace' => '가져오기',
    'databases.recreateDatabase' => '데이터베이스 다시 생성',
    'databases.uploading' => '가져오는 중…',
    'databases.waitMessage' => '기다려 주십시오…',
    'databases.rootDirectory' => '루트 디렉토리',
    'databases.connectionInfoTitle' => '%%database%%에 대한 연결 정보',
    'databases.connectionInfoDesc' => '웹 앱 설치 중에 지정하라는 명령이 내려지는 경우 이 데이터베이스 연결 세부 정보를 사용할 수 있습니다.',
    'databases.connectionInfoServerAddress' => '호스트',
    'databases.connectionInfoDatabaseName' => '데이터베이스 이름',
    'databases.connectionInfoUserLogin' => '사용자 이름',
    'databases.connectionInfoUserPassword' => '암호',
    'databases.connectionInfoNoUserLogin' => '기본 사용자 없음',
    'databases.buttonClose' => '종료',
    'databases.nothingFound' => "찾은 일치 항목 없음",
    'databases.moreObjectsAvailable' => '%%count%%개 이상 개체가 있습니다',

    'dnsaclrecords.value' => 'IP 주소',
    'dnsaclrecords.add' => 'IP 주소 추가',
    'dnsaclrecords.remove' => '제거',
    'dnsaclrecords.hintRemove' => '선택한 IP 주소를 제거합니다.',
    'dnsaclrecords.confirmOnDelete' => '선택한 IP 주소를 제거하시겠습니까?',
    'dnsaclrecords.emptyViewTitle' => '영역 전송은 허용되지 않습니다.',
    'dnsaclrecords.emptyViewDescription1' => '보안상의 이유로 해당 영역의 NS 레코드에 지정된 서버로만 DNS 영역 전송을 허용할 수 있습니다.',
    'dnsaclrecords.emptyViewDescription2' => '전송을 허용할 하나 이상의 서버를 지정하려면 "IP 주소 추가"를 클릭하십시오.',

    'dnsrecords.host' => '호스트',
    'dnsrecords.type' => '레코드 유형',
    'dnsrecords.value' => '값',
    'dnsrecords.nameServer' => '이름 서버',
    'dnsrecords.ipAddress' => 'IP 주소',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => '이름 서버에서 DNS 영역을 테스트합니다.',
    'dnsrecords.remove' => '제거',
    'dnsrecords.removeRecord' => '%%selectedRowTitle%%(을)를 제거하시겠습니까? 이 작업은 취소할 수 없습니다.',
    'dnsrecords.removeRecords' => '%%selectedRows%% 기록을 제거하시겠습니까? 이 작업은 취소할 수 없습니다.',
    'dnsrecords.hintRemove' => '선택한 DNS 레코드를 삭제합니다.',
    'dnsrecords.confirmOnDelete' => '{count, plural, =1 {{host} DNS 레코드} other {선택한 DNS 레코드 #개}}를 제거하시겠습니까?',
    'dnsrecords.turnOff' => '비활성화',
    'dnsrecords.hintTurnOff' => 'DNS 영역에 대한 로컬 DNS 서비스 해제 %%name%%',
    'dnsrecords.turnOn' => '활성화',
    'dnsrecords.hintTurnOn' => '영역에 대한 로컬 DNS 서비스 사용 %%name%%',
    'dnsrecords.toggleTypeToSlave' => '보조로 전환',
    'dnsrecords.toggleTypeToMaster' => '기본으로 전환',
    'dnsrecords.hintToggleTypeToMaster' => '이 서버를 %%name%% 영역의 기본 이름 서버로 사용합니다.',
    'dnsrecords.hintToggleTypeToSlave' => '이 서버를 %%name%% 영역의 보조 이름 서버로 사용합니다.',
    'dnsrecords.hintToggleTypeDisabled' => '%%name%% DNS 영역을 다른 서버에서 서비스하고 있어 DNS 영역의 서비스 모드를 전환할 수 없습니다.',
    'dnsrecords.addRecord' => '레코드 추가',
    'dnsrecords.hintSpecifyNameServer' => '%%name%%에 대해 새 이름 서버 지정',
    'dnsrecords.hintAddPrimaryDns' => '%%name%%에 대한 기본 DNS 서버 추가',
    'dnsrecords.hintAddRecord' => '%%name%%의 DNS 영역에서 리소스 레코드 만들기',
    'dnsrecords.restoreDefault' => '기본값으로 초기화',
    'dnsrecords.hintRestoreDefault' => '서버 전체 DNS 템플릿에 따라 DNS 영역을 다시 생성합니다. 모든 사용자 정의 리소스 기록이 제거되고 사용자가 영역에 가한 모든 변경 사항을 잃게 됩니다.',
    'dnsrecords.syncZone' => 'DNS 템플릿 적용',
    'dnsrecords.hintSyncZone' => '서버 전체 DNS 템플릿의 변경 사항을 영역에 적용합니다. 새 리소스 기록이 추가될 수 있으며, 기존 기록은 삭제될 수 있습니다. 사용자가 추가 또는 편집한 리소스 기록은 영향을 받지 않습니다.',
    'dnsrecords.applyChanges' => 'DNS 레코드에 이루어진 변경 내용이 아직 저장되지 않았습니다. 변경 내용은 레코드 목록에 표시되어 있습니다. DNS 영역에 변경 내용을 적용하려면 \'업데이트\'를 클릭하십시오. 변경을 취소하려면 \'되돌리기\'를 클릭하십시오.',
    'dnsrecords.updateButtonTitle' => '업데이트',
    'dnsrecords.updateButtonDescription' => 'DNS 레코드에 수행된 변경을 저장합니다.',
    'dnsrecords.revertButtonTitle' => '되돌리기',
    'dnsrecords.revertButtonDescription' => 'DNS 레코드에 수행된 변경을 취소합니다.',
    'dnsrecords.syncZoneFrom' => 'DNS 템플릿의 변경 사항을 적용합니다.',
    'dnsrecords.moreActions' => '더 많은 작업',
    'dnsrecords.search' => '검색...',
    'dnsrecords.templateNotSynchronized' => 'DNS 영역 템플릿이 변경되었으며 새로 생성된 모든 도메인에 적용됩니다. %%link%%도 할 수 있습니다',
    'dnsrecords.templateNotSynchronizedLinkText' => '변경 사항을 호스팅된 모든 도메인에 적용',
    'dnsrecords.soaTemplateNotSynchronized' => 'SOA 템플릿이 변경되었으며 새로 생성된 모든 도메인에 적용됩니다. %%link%%도 할 수 있습니다',

    'emails.actions' => '동작',
    'emails.name' => '이메일 주소',
    'emails.owner' => '연락처 이름',
    'emails.remove' => '제거',
    'emails.addNewEmail' => '이메일 주소 만들기',
    'emails.hintAddNewEmail' => '이메일 주소를 만들고 사용자에게 할당합니다.',
    'emails.recalculateUsage' => '사용 통계를 새로 고침',
    'emails.hintRecalculateUsage' => '사서함에 사용된 실제 디스크 공간을 다시 계산합니다.',
    'emails.outgoingSpamSettings' => '발신 메시지 제한',
    'emails.hintOutgoingSpamSettings' => '선택한 사서함의 발신 메시지 제한을 설정합니다. 각 사서함에서 지정하는 수 이상의 메시지는 보낼 수 없습니다.',
    'emails.searchByEmail' => '이메일 주소',
    'emails.hintRemove' => '선택한 이메일 주소를 제거합니다.',
    'emails.webMailDisabledHint' => '웹 메일 소프트웨어가 설치되지 않았습니다.',
    'emails.webMail' => '웹 메일',
    'emails.webMailHint' => '이 이메일 주소의 웹 메일을 새 브라우저 창에 엽니다.',
    'emails.edit' => '메일 클라이언트 구성하기',
    'emails.editHint' => 'Microsoft Outlook, Outlook Express, Thunderbird, Apple Mail 등 메일 클라이언트 프로그램에서 이메일 계정을 설정하는 방법을 알아봅니다.',
    'emails.confirmOnDelete' => '{count, plural, =1 {{name} 이메일 주소} other {선택한 이메일 주소 #개}}를 제거하시겠습니까?',
    'emails.redirectHint' => '다음 이메일 주소로 수신 메시지 전달',
    'emails.redirectDetailsMultiple' => '%%firstAddress%%(그리고 %%countLeft%% 추가)',
    'emails.autoresponderHint' => '이메일 주소로 들어오는 모든 메일 메시지에 대한 자동 답장 기능이 켜져 있습니다',
    'emails.autoresponderEnabled' => '자동 회신이 설정되었습니다.',
    'emails.autoresponderEnabledTill' => '자동 회신이 %%endDate%%까지 설정되었습니다.',
    'emails.spaceUsage' => '사용',
    'emails.noMailbox' => '사서함 없음',
    'emails.statusNotOperable' => '메일 서비스가 꺼져있습니다.',
    'emails.aliases' => '(%%aliases%%)',
    'emails.aliasesMore' => '(%%alias%% 외 %%count%%개)',
    'emails.clear' => '사서함 비우기',
    'emails.yesClear' => '네, 비웁니다',
    'emails.clearNoItems' => '먼저 비울 사서함을 한 개 이상 선택하십시오',
    'emails.hintClear' => '선택한 사서함을 비웁니다.',
    'emails.confirmOnClear' => '{count, plural, =1 {{name} 사서함} other {선택한 사서함 #개}}의 모든 메일을 지우시겠습니까? 이 동작은 취소할 수 없습니다.',

    'failedrequestfiles.downloadZip' => 'ZIP 다운로드',
    'failedrequestfiles.downloadZipHint' => 'ZIP 아카이브에서 선택한 파일을 다운로드합니다.',
    'failedrequestfiles.name' => '이름',
    'failedrequestfiles.modificationDate' => '수정 날짜',
    'failedrequestfiles.remove' => '제거',
    'failedrequestfiles.hintRemove' => '선택한 실패한 요청 파일을 제거합니다.',
    'failedrequestfiles.confirmOnDelete' => '선택한 실패한 요청 파일을 제거할까요?',
    'failedrequestfiles.viewHint' => '실패한 요청 파일을 보려면 클릭합니다.',
    'failedrequestfiles.buttonChangeTracing' => '추적 옵션 변경',
    'failedrequestfiles.buttonChangeTracingHint' => '현재 정의된 실패한 요청 추적 설정을 변경합니다.',
    'failedrequestfiles.buttonDisableTracing' => '추적 중지',
    'failedrequestfiles.buttonDisableTracingHint' => '추적을 중지합니다.',
    'failedrequestfiles.buttonEnableTracing' => '추적 시작',
    'failedrequestfiles.buttonEnableTracingHint' => '추적을 시작합니다.',
    'failedrequestfiles.buttonRefresh' => '새로 고침',
    'failedrequestfiles.buttonRefreshHint' => '지정된 기준과 일치하는 모든 실패한 요청을 표시하려면 여기를 클릭합니다. 새로 기록된 실패한 요청은 자동으로 표시되지 않습니다.',

    'files.name' => '이름',
    'files.modificationDate' => '수정됨',
    'files.size' => '크기',
    'files.share' => '공유',
    'files.shareHint' => 'Plesk에서 인증된 모든 직원이 액세스할 수 있도록 선택한 파일을 공용 파일 폴더로 이동합니다.',
    'files.publish' => '게시',
    'files.publishHint' => '고객과 웹 사이트 방문자가 공용 액세스할 수 있도록 선택한 파일을 공용 파일 폴더에 복사합니다. 이들 파일에 대한 액세스를 암호로 보호할 수 있습니다.',
    'files.email' => '이메일 링크',
    'files.emailHint' => '선택한 파일에 액세스할 수 있는 링크를 다른 직원 및 고객에게 이메일로 보냅니다.',
    'files.delete' => '삭제',
    'files.deleteHint' => '선택한 파일 삭제',
    'files.moreActions' => '기타',
    'files.createFolder' => '새 폴더',
    'files.createFolderHint' => '현재 폴더에 폴더 만들기',
    'files.copy' => '복사',
    'files.copyHint' => '선택한 파일 또는 폴더를 원하는 대상에 복사합니다.',
    'files.move' => '이동',
    'files.moveHint' => '선택한 파일 또는 폴더를 원하는 대상으로 이동합니다.',
    'files.protectedDescription' => '이 폴더의 파일에 대한 액세스가 암호로 보호됩니다. 사용자가 이러한 파일에 액세스하려고 하면 이 암호를 입력하라는 메시지가 표시됩니다.',
    'files.nothingSelected' => '파일 또는 폴더가 선택되지 않았습니다.',

    'gitrepositories.lastCommitInfo' => '마지막 커밋 정보:',
    'gitrepositories.deploymentActions' => '추가 배포 작업:',

    'logfiles.name' => '이름',
    'logfiles.path' => '경로',
    'logfiles.modificationDate' => '수정 날짜',
    'logfiles.fileSize' => '크기',
    'logfiles.logRotation' => '로그 순환',
    'logfiles.logRotationHint' => '웹 사이트의 로그 순환 설정을 구성합니다.',
    'logfiles.logRotationTitle' => '로그 순환 구성',
    'logfiles.remove' => '제거',
    'logfiles.hintRemove' => '선택한 로그 파일을 삭제합니다. 처리된 로그 파일만 삭제할 수 있습니다.',
    'logfiles.confirmOnDelete' => '선택한 로그 파일을 제거할까요?',
    'logfiles.viewHint' => '로그 파일을 보려면 클릭합니다.',
    'logfiles.buttonDownloadHint' => '로그 파일을 다운로드하려면 클릭합니다.',
    'logfiles.buttonViewHint' => '로그 파일을 새 창에서 보려면 클릭합니다.',
    'logfiles.addCustomLog' => '사용자 지정 로그 추가',
    'logfiles.addCustomLogHint' => 'Log Browser에서 파일을 엽니다.',
    'logfiles.customLogPopupTitle' => '사용자 지정 로그 추가',
    'logfiles.invalidLogFormat' => '로그 파일이 지원되지 않는 형식입니다.',
    'logfiles.buttonUnlinkHint' => 'Log Browser에서 이 파일의 업데이트 추적을 중단하려면 클릭합니다.',
    'logfiles.buttonUnlinkConfirmationDescription' => 'Log Browser에서 이 파일의 업데이트 추적을 중단하시겠습니까?',
    'logfiles.buttonUnlinkConfirmationYes' => '예',
    'logfiles.buttonUnlinkConfirmationNo' => '아니오',
    'logfiles.accessLog' => 'Apache 액세스',
    'logfiles.accessLogProcessed' => 'Apache 액세스(순환됨)',
    'logfiles.accessSslLog' => 'Apache SSL/TLS 액세스',
    'logfiles.accessSslLogProcessed' => 'Apache SSL/TLS 액세스(순환됨)',
    'logfiles.errorLog' => 'Apache 오류',
    'logfiles.proxyAccessLog' => 'nginx 액세스',
    'logfiles.proxyAccessSslLog' => 'nginx SSL/TLS 액세스',
    'logfiles.proxyErrorLog' => 'nginx 오류',
    'logfiles.phpErrorLog' => 'PHP 오류',
    'logfiles.iisAccessLog' => 'IIS 액세스',
    'logfiles.iisLog' => 'IIS(%%name%%)',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',
    'logfiles.laravel' => 'Laravel',
    'logfiles.dotnetcore' => '.NET Core',

    'maillists.title' => '메일링 리스트',
    'maillists.remove' => '제거',
    'maillists.name' => '주소',
    'maillists.subscribers' => '구독자',
    'maillists.hintRemove' => '선택한 메일링 리스트를 제거합니다.',
    'maillists.confirmOnDelete' => '선택한 메일링 리스트를 제거하시겠습니까?',
    'maillists.openWebPanel' => '목록 관리',
    'maillists.statusNotEnabled' => '해제됨.',
    'maillists.statusNotOperable' => '메일링 리스트 서비스가 해제되었습니다.',

    'mailsettings.name' => '도메인 이름',
    'mailsettings.mailService' => '메일 서비스',
    'mailsettings.webmail' => '웹 메일',
    'mailsettings.nonexist' => '존재하지 않는 사용자에게 보내진 메일',
    'mailsettings.webmailNone' => '없음',
    'mailsettings.nonExistBounce' => '메시지를 포함하여 바운스',
    'mailsettings.nonExistCatch' => '전달 대상 %%catchAddress%%',
    'mailsettings.nonExistCatchDescription' => '주소가 선택한 도메인에 속해야 합니다. 여러 도메인에 하나의 주소 또는 외부 주소를 지정하려면 관리자만 가능합니다.',
    'mailsettings.nonExistExternal' => '%%catchIp%%(으)로 리디렉션',
    'mailsettings.nonExistReject' => '거부',
    'mailsettings.nonExistDiscard' => '거부',
    'mailsettings.statusEnabled' => '켜기',
    'mailsettings.statusDisabled' => '끄기',
    'mailsettings.statusDisabledIncoming' => '수신 비활성화',
    'mailsettings.statusNotConfigured' => '구성되지 않음',
    'mailsettings.searchByName' => '도메인 이름',
    'mailsettings.editOutgoingSpamSettings' => '제한 편집',
    'mailsettings.numberOutgoingMessages' => '발신 메시지 수',

    'roles.title' => '사용자 역할',
    'roles.name' => '역할 이름',
    'roles.description' => '설명',
    'roles.remove' => '제거',
    'roles.numberOfUsers' => '사용자',
    'roles.hintRemove' => '선택한 사용자 역할을 제거합니다. 역할은 어떤 사용자 계정에도 할당되지 않았을 때만 제거할 수 있습니다.',
    'roles.disabledSelectHint' => '이 역할이 하나 이상의 사용자 계정에 할당되었습니다. 역할은 어떤 사용자 계정에도 할당되지 않았을 때만 제거할 수 있습니다.',
    'roles.builtInItemHint' => '이 역할을 편집하거나 제거할 수 없습니다.',
    'roles.confirmOnDelete' => '선택한 사용자 역할을 제거하시겠습니까?',

    'sites.selectstatistics.domain' => '도메인',
    'sites.selectstatistics.linkView' => '보기',

    'sites.selecttrafficstatistics.domain' => '도메인',
    'sites.selecttrafficstatistics.linkView' => '보기',

    'sites.filterDomainName' => '이름',
    'sites.filterStatus' => '상태',
    'sites.filterOptionStatusAny' => '모두',
    'sites.filterOptionStatusSuspended' => '일시 중단됨',
    'sites.filterOptionStatusDisabled' => '비활성화됨',
    'sites.filterOptionStatusActive' => '활성화됨',
    'sites.filterHostingType' => '호스팅 유형',
    'sites.filterOptionHostingTypeAny' => '모두',
    'sites.filterOptionHostingTypeNone' => '호스팅 없음',
    'sites.filterOptionHostingTypeForward' => '도메인 전달',
    'sites.filterOptionHostingTypeAlias' => '도메인 별칭',
    'sites.filterOptionHostingTypeVirtualHost' => '도메인 호스팅',
    'sites.filterOptionHostingTypeSubdomain' => '하위 도메인 호스팅',
    'sites.filterOptionPhpHandlerAny' => '모두',
    'sites.filterDescription' => '설명',

    'sslcertificates.name' => '이름',
    'sslcertificates.used' => '사용 중',
    'sslcertificates.csrHint' => 'CSR 파트가 제공됨.',
    'sslcertificates.noCsrHint' => 'CSR 파트가 제공되지 않음.',
    'sslcertificates.privateKeyHint' => '개인 키 파트가 제공됨.',
    'sslcertificates.noPrivateKeyHint' => '개인 키 파트가 제공되지 않음.',
    'sslcertificates.certificateHint' => '인증서 파트가 제공됨.',
    'sslcertificates.noCertificateHint' => '인증서 파트가 제공되지 않음.',
    'sslcertificates.caCertificateHint' => 'CA 인증서 파트가 제공됨.',
    'sslcertificates.noCaCertificateHint' => 'CA 인증서 파트가 제공되지 않음.',
    'sslcertificates.buttonDownloadHint' => '모든 인증서 구성 요소를 다운로드합니다.',
    'sslcertificates.webmail' => '웹 메일 보호',
    'sslcertificates.hintWebmail' => '선택한 SSL/TLS 인증서를 사용하여 도메인에서 웹 메일을 보호합니다.',
    'sslcertificates.remove' => '제거',
    'sslcertificates.hintRemove' => '선택한 SSL/TLS 인증서를 도메인 리포지토리에서 제거합니다.',
    'sslcertificates.confirmOnDelete' => '선택한 SSL/TLS 인증서를 제거하시겠습니까?',
    'sslcertificates.addCertificate' => 'SSL/TLS 인증서 추가',
    'sslcertificates.hintAddCertificate' => 'SSL/TLS 인증서를 추가합니다.',
    'sslcertificates.viewCertificates' => '인증서 보기',
    'sslcertificates.hintViewCertificates' => '공급자로부터 구입한 SSL/TLS 인증서 목록을 봅니다.',
    'sslcertificates.webmailCertificate' => '웹 메일 보호',
    'sslcertificates.mailCertificate' => '메일 보호',
    'sslcertificates.mailAndWebmailCertificate' => '메일 및 웹 메일 모두 보호',
    'sslcertificates.mail' => '보안 메일',
    'sslcertificates.hintMail' => '선택한 SSL/TLS 인증서를 사용하여 도메인에서 메일을 보호하십시오.',

    'subscriptions.subscription' => '구독',
    'subscriptions.price' => '요금',
    'subscriptions.renewalDate' => '만료 날짜',
    'subscriptions.setupDate' => '설정 날짜',
    'subscriptions.domains' => '웹 사이트',
    'subscriptions.systemUser' => '시스템 사용자',
    'subscriptions.ipAddress' => 'IP 주소',
    'subscriptions.addonDomains' => '추가 도메인',
    'subscriptions.diskSpace' => '디스크 공간',
    'subscriptions.moreDomains' => '...및 %%count%%개의 추가 도메인',
    'subscriptions.buy' => '새 구독 구입',
    'subscriptions.create' => '구독 만들기',
    'subscriptions.create_powerUser' => '웹 공간 만들기',
    'subscriptions.renew' => '갱신',
    'subscriptions.confirmOnCancel' => '구독을 취소할까요?',
    'subscriptions.subscriptionSuspended' => '일시 중단됨',
    'subscriptions.myResources' => '내 리소스',
    'subscriptions.planName' => '서비스 플랜',
    'subscriptions.switchToLink' => '구독으로 전환',
    'subscriptions.switchToLinkHint' => '이 구독으로 전환합니다.',
    'subscriptions.switchToLinkPowerUser' => '웹 공간으로 전환',
    'subscriptions.switchToLinkHintPowerUser' => '이 웹 공간으로 전환합니다.',
    'subscriptions.buttonRemove' => '제거',
    'subscriptions.buttonRemoveDescription' => '선택한 웹 공간 제거',
    'subscriptions.confirmOnDelete' => '선택한 웹 공간을 제거합니다?',
    'subscriptions.buttonAddNew' => '웹 공간 추가',
    'subscriptions.buttonAddNewDescription' => '웹 공간을 만듭니다.',
    'subscriptions.subscription_powerUser' => '웹 공간',
    'subscriptions.subscriptionPowerUser' => '웹 공간',
    'subscriptions.confirmOnCancel_powerUser' => '웹 공간을 취소할까요?',
    'subscriptions.subscriptionSuspended_powerUser' => '일시 중단됨',
    'subscriptions.switchToLink_powerUser' => '웹 공간으로 전환',
    'subscriptions.switchToLinkHint_powerUser' => '이 웹 공간으로 전환합니다.',
    'subscriptions.primaryDomain' => '기본 도메인',
    'subscriptions.ftpAccess' => 'FTP 계정',

    'users.contactName' => '연락처 이름',
    'users.email' => '이메일 주소',
    'users.role' => '역할',
    'users.contacts' => '연락처',
    'users.phone' => '전화번호',
    'users.roleFilter' => '사용자 역할',
    'users.filterAnyRole' => '모두',
    'users.activate' => '활성화',
    'users.deactivate' => '일시 중단',
    'users.remove' => '제거',
    'users.status' => '상태',
    'users.statusBlocked' => '비활성화됨',
    'users.buttonAddNewUser' => '사용자 계정 만들기',
    'users.hintAddNewUser' => '사용자 계정을 만듭니다.',
    'users.hintRemove' => '선택한 사용자 계정을 제거합니다.',
    'users.disabledSelectHint' => '기본 제공된 사용자 계정이나 자신의 사용자 계정이어서 이 사용자 계정을 제거할 수 없습니다.',
    'users.confirmOnDelete' => '선택한 사용자 계정을 제거하시겠습니까?',

    'webusers.name' => '이름',
    'webusers.add' => '웹 사용자 추가',
    'webusers.hintAdd' => '웹 사용자 계정을 추가합니다. %%resourceUsage%%',
    'webusers.settings' => '설정',
    'webusers.hintSettings' => "웹 사용자 설정.",
    'webusers.remove' => '제거',
    'webusers.hintRemove' => '선택한 웹 사용자를 제거합니다.',
    'webusers.confirmOnDelete' => '선택한 웹 사용자를 제거하시겠습니까?',
    'webusers.buttonOpenHomepageHint' => "웹 브라우저를 통해 웹 사용자 홈 페이지를 보려면 클릭합니다.",

    'virtualdirectories.protection' => 'P',
    'virtualdirectories.name' => '이름',
    'virtualdirectories.actionOpen' => '브라우저에서 열기',
    'virtualdirectories.actionEdit' => '설정 편집',
    'virtualdirectories.actionPermissions' => '권한 관리',
    'virtualdirectories.up_levelType' => '상위 레벨',
    'virtualdirectories.directoryType' => '실제 디렉터리',
    'virtualdirectories.virtual_directoryType' => '가상 디렉터리',
    'virtualdirectories.fileType' => '실제 파일',
    'virtualdirectories.protectionOn' => '이 디렉터리는 보호됩니다',
    'virtualdirectories.protectionOff' => '이 디렉터리는 보호되지 않습니다',
    'virtualdirectories.isMissing' => '이 가상 디렉터리는 존재하지 않는 실제 폴더에 연결되어 있습니다',
    'virtualdirectories.buttonRemove' => '제거',
    'virtualdirectories.noSelectionText' => '제거할 항목을 1개 이상 선택하십시오',
    'virtualdirectories.removeConfirmation' => '{count, plural, =1 {{name} 디렉터리를} other {#개의 항목을}} 제거할까요?',
    'virtualdirectories.removeSuccess' => '선택한 항목이 제거되었습니다.',
    'virtualdirectories.buttonCreateVirtualDir' => '가상 디렉터리 만들기',
    'virtualdirectories.buttonCreateVirtualDirHint' => '가상 디렉터리를 만듭니다',
    'virtualdirectories.buttonCreateDir' => '디렉터리 만들기',
    'virtualdirectories.buttonCreateDirHint' => '디렉터리를 만듭니다',
];