<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Ek Anahtar Özellikleri',
    'additional-key-info.update' => 'Ek Anahtarı Alın',
    'additional-key-info.updateDescription' => 'Ek anahtarı alın ve kurun.',
    'additional-key-info.download' => 'Anahtarı İndir',
    'additional-key-info.downloadDescription' => 'Geçerli lisans anahtarını indirin.',
    'additional-key-info.install' => 'Anahtarı Kurun',
    'additional-key-info.installDescription' => 'Mevcut lisans anahtarını kurun.',
    'additional-key-info.revert' => 'Lisansı eski haline getir',
    'additional-key-info.revertDescription' => 'Bir önceki lisansı geri kurun.',
    'additional-key-info.revertNotAvailableDescription' => 'Kurulu anahtar yok.',
    'additional-key-info.installSuccess' => 'Lisans anahtarı kurulumu başladı.',

    'additional-key-revert.title' => 'Ek Anahtarı Geri Alma',
    'additional-key-revert.success' => 'Ek anahtar geri döndürüldü.',

    'additional-key-upload.title' => 'Bir Lisans Anahtarı Kurun',
    'additional-key-upload.success' => 'Yeni ek anahtar yüklendi.',

    'additional-keys.title' => 'Ek Lisans Anahtarları',

    'change-subscriptions-owner.title' => 'Seçilen Abonelikleri Yeniden Atama',
    'change-subscriptions-owner.success' => 'Abonelik sahipliği değiştirildi',

    'customers.hint' => 'Bu, barındırma servisi müşterilerinizin hesaplarını yönettiğiniz yerdir. Servis abonelikleriyle hesaplar oluşturun, varolan müşterileri yönetin ve hesapları kaldırın. Web sitelerini, posta veya bir müşteriye sağlanan diğer tüm servisleri yönetmek için, listenin sağ sütunundaki bağlantıyı tıklatarak Müşteri Panelinde gidin.',

    'customer-domains.hint' => 'Bu, web sitelerini kurduğunuz ve yönettiğiniz yerdir.',

    'customer-subscriptions.hint' => 'Bu, müşterinizin aboneliklerini yönettiğiniz yerdir.',

    'domains.hint' => 'Bu, sistemde kayıtlı tüm alan adları hakkındaki bilgileri görüntüleyebileceğiniz veya barındırma hizmetlerini yönetmeye devam edebileceğiniz yerdir. Kendiniz veya barındırma müşterilerinize bir alan adı eklemek için Alan Adı Ekle seçeneğini tıklatmanız yeterlidir. Bir alan adı oluşturulurken yeni bir müşteri ve abonelik oluşturmanız veya varolanlardan seçmeniz istenecektir.',

    'database-servers.title' => 'Veritabanı Sunucuları',

    'database-server-create.title' => 'Yeni veritabanı sunucusu',

    'database-server-properties.title' => 'Veritabanı Sunucusu',

    'database-server-upgrade.drawerTitle' => 'MariaDB yükseltmesi',
    'database-server-upgrade.drawerTitle.completed' => 'Yükseltme tamamlandı',
    'database-server-upgrade.drawerSubTitle.line1' => 'Yükseltme devam ederken drawer kapatılamaz.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Yükseltme sırasında sorun çıkarsa şunu inceleyin: %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB veritabanı sunucusu %%releaseVersion%% sürümüne yükseltildi. Herhangi bir sorunla karşılaşırsanız şu yazıdaki talimatları uygulayın: %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'LTS sürümüne sahipsiniz.',
    'database-server-upgrade.troubleshootingArticle' => 'bu Bilgi Tabanı yazımızı',
    'database-server-upgrade.troubleshootingArticleDescription' => 'MariaDB yükseltme sorunlarını gidermek için %%troubleshootingArticle%% kullanın.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Yerel MariaDB veritabanı sunucunuzu güncel uzun süreli destek (LTS) sürümüne yükseltin.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Yükseltmeden önce sunucunuzu yedeklemeyi ve yükseltmeyi web sitesinin yoğun olmayan saatlerinde başlatmanızı kesinlikle öneriyoruz.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'MariaDB yükseltmesi sırasında Plesk sunucusu ve barındırılan web siteleri kullanılamaz. MariaDB yükseltmesi genellikle hatasız gerçekleşir ve yaklaşık 10 dakika sürer fakat yine de sunucunun tamamını etkileyebilir.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Not: Eğer MariaDB 5.5 kullanıyorsanız Plesk önce sürümünüzü MariaDB 10.5\'e yükseltir. Yükseltme tamamlandıktan sonra MariaDB\'nin güncel LTS sürümüne yükseltmek için tekrar bu sihirbazı başlatın.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Güncel sürüm',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Yükseltilecek sürümü seçin',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Ana sürüm yok',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Sürüm notları',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Sürüm tarihi: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Hizmet süresi sonu: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Yalnızca işletim sistemi satıcıları veya MariaDB satıcısı tarafından gönderilen MariaDB çatalları yükseltilebilir.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Yükseltme öncesi kontroller',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'MariaDB yapılandırma dosyaları ayrıştırılıyor',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Mysqlcheck ile veritabanları analiz ediliyor',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Paket yöneticisi yapılandırması analiz ediliyor',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Sistem uyumluluğu kontrol ediliyor',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket kontrol ediliyor',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Yükseltmeye devam etmek için tüm onay kutularını seçin. Yükseltmenin gerçekleştireceği yapılandırma değişikliklerini kabul ettiğinizden ve kurtarma seçeneklerine erişiminiz olduğunuzdan emin olmak için gereklidir.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Aşağıdaki değişkenler, yeni sürümle uyumluluk için kaldırılacak:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{count, plural, one {{files} dosyasından} other {# dosyadan ({files})}} {variable}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Kurtarma seçeneklerine erişin (sunucu komut satırı konsolu ve Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Sunucuya SSH erişimine sahip olduğumu onaylıyorum',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Bir SSH istemcisi kullanın veya yeni bir tarayıcı sekmesinde %%sshTerminalExtension%%\'nı açın (yükseltme tamamlanana kadar SSH Terminal uzantısı penceresini kapatmayın). Yükseltme başarısız olursa SSH erişimine sahip olmak kurtarmaya yardımcı olacaktır.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal uzantısı',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Repair Kit\'e erişime sahip olduğumu onaylıyorum',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Yeni bir tarayıcı sekmesinde %%repairKit%%\'i açın ve yönetici bilgileriyle oturum açın. Yükseltme tamamlanana kadar Repair Kit uzantısı penceresini kapatmayın.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Veritabanlarını yedekleyin',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Yükseltmeden önce sunucuda barındırılan tüm veritabanlarını yedekleyin',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk, veritabanlarının yedeğini %%path%% dizininde depolar.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'Plesk\'te WebSocket kullanılamıyor',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'WebSocket olmadan yükseltme işleminin gerçek zamanlı çıktısını göremezsiniz.',

    'database-server-upgrade.submitPopover.title' => 'Olası veri kayıplarını engellemek için devam etmeden önce barındırılan veritabanlarının bir dökümünü oluşturmanızı kesinlikle öneriyoruz. Döküm oluşturulmadan devam edilsin mi?',

    'database-server-databases.title' => 'Veritabanları',

    'database-server-change-password.title' => 'Yönetici Şifresi',

    'home.title' => 'Anasayfa',

    'license.title' => 'Lisans Bilgisi',

    'primary-key-info.title' => 'Plesk Lisans Anahtarı',
    'primary-key-info.update' => 'Anahtarların Alın',
    'primary-key-info.updateDescription' => 'Sipariş edilmiş lisansları görüntüle ve kur.',
    'primary-key-info.upload' => 'Anahtarı Kurun',
    'primary-key-info.uploadDescription' => 'Yeni bir lisans anahtarını karşıya yükleyin ve kurun.',
    'primary-key-info.revert' => 'Lisansı eski haline getir',
    'primary-key-info.revertDescription' => 'Bir önceki lisansı geri kurun.',

    'primary-key-revert.title' => 'Eski lisansa geri dön',
    'primary-key-revert.success' => 'Plesk anahtarı geri döndürüldü.',

    'primary-key-upload.title' => 'Bir Lisans Anahtarı Kurun',
    'primary-key-upload.success' => 'Yeni Plesk anahtarı yüklendi.',

    'resellers.hint' => 'Bu, satıcılarınızın, yani barındırma servislerini satan ve kendi web sitelerini barındıran müşterilerinizin hesaplarını yönettiğiniz yerdir. Burada servis abonelikleriyle hesaplar oluşturabilir, varolan satıcıları yönetebilir ve hesapları kaldırabilirsiniz.',

    'reseller-customers.hint' => 'Buradan müşterilerinizi organize edebilir ve yönetebilirsiniz.',

    'reseller-domains.hint' => 'Bu, web sitelerini kurduğunuz ve yönettiğiniz yerdir.',

    'reseller-subscriptions.hint' => 'Buradan satıcı aboneliklerini yönetebilirsiniz.',

    'subscriptions.hint' => 'Müşteriler, bir barındırma planına abone olarak sizden barındırma servisleri alır. Web sitelerinizi barındırmak için oluşturduğunuz kendi aboneliklerinizin yanında bu abonelikleri de buradan yönetebilirsiniz. Web sitelerini, postayı veya bir abonelikte sağlanan diğer tüm servisleri yönetmek için listenin sağ sütunundaki bağlantıyı tıklatarak abonenin Müşteri Panelinde gidin.',

    'server-mail-settings.title' => 'Ayarlar',
    'server-mail-spam-filter.title' => 'İstenmeyen Posta Filtreleri',
    'server-mail-antivirus.title' => 'Antivirüs',
    'server-mail-black-list.title' => 'Kara Liste',
    'server-mail-white-list.title' => 'Beyaz Liste',
    'server-mail-queue.title' => 'Posta Sırası',
    'server-mail-statistics.title' => 'İstatistikler',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Ayarlar',
    'server-spam-filter.black-list' => 'Kara Liste',
    'server-spam-filter.white-list' => 'Beyaz Liste',

    'firewall.title' => 'Güvenlik Duvarı Yönetimi',
    'firewall-general.title' => 'Genel',
    'firewall-general.toggleStatus' => 'Güvenlik duvarı koruması',
    'firewall-general.buttonDefault' => 'Varsayılana Sıfırla',
    'firewall-general.buttonPanic' => 'Panik Modu',
    'firewall-general.confirmationDefault' => 'Güvenlik duvarı ayarları varsayılanlarla sıfırlansın mı?',
    'firewall-general.confirmationPanic' => 'Panil Modu açılsın mı? Kullanıcılar alan adlarına erişemeyecek ve bazı ağ servisleri çalışmayabilir.',
    'firewall-general.successDefault' => 'Güvenlik duvarı ayarları varsayılanlara sıfırlandı.',
    'firewall-general.successPanic' => 'Panik modu etkinleştirildi.',
    'firewall-general.info' => 'Güvenlik nedenlerinden dolayı güvenlik duvarı, açıkça izin verilenlerin dışındaki tüm bağlantıları engeller. Bir kural oluşturarak bir bağlantıya izin verebilirsiniz. Daha ayrıntılı bilgiler için belgelere bakın',
    'firewall-general.interfaces' => 'Ağ arayüzleri',
    'firewall-icmp.title' => 'ICMP Protocol',
    'firewall-rules.title' => 'Güvenlik Duvarı Kuralları',

    'dns.title' => 'DNS Ayarları',
    'dns-records.title' => 'Alan Kayıtları Şablonu',
    'dns-soa-record.title' => 'Bölge Ayarları Şablonu',

    'php-handler.title' => '%%name%% ayarları',
    'php-handler.extensions.title' => 'Uzantılar',
    'php-handler.extensions.description' => 'Bu PHP uzantıları ayarları sadece bu işleyici içindir.',
    'php-handler.extensions.descriptionShared' => 'Bu ayarlar, aşağıdaki PHP işleyicileri için ortaktır: %%handlers%%. Ayarlar, bu işleyicileri kullanan tüm web siteleri için geçerlidir.',
    'php-handler.extensions.buttonManage' => 'PECL Paketlerini Yönet',
    'php-handler.extensions.manage.title' => 'PECL Paketlerini Yönet',
    'php-handler.extensions.manage.risks' => 'PHP uzantıları üçüncü taraf PECL paketleri tarafından sağlanır. Riski size ait olmak üzere kurun.',
    'php-handler.extensions.manage.description' => 'PECL paketlerini kurun, yükseltin ve kaldırın. Değişiklikler %%handlers%% üzerinde çalışan tüm web sitelerine uygulanır.',
    'php-handler.extensions.manage.notFound' => 'Neden istenen paket listede yok?',
    'php-handler.extensions.manage.limitations' => 'Kontrol paneli sağlayıcısı ve işletim sistemi satıcıları tarafından gönderilen PHP uzantıları listede gösterilmez.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Yenile",
    'ServerInformation.sectionGeneral' => "Genel",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versiyon",
    'ServerInformation.os' => "İşletim Sistemi",
    'ServerInformation.key' => "Plesk Lisans Anahtarı",
    'ServerInformation.uptime' => "Çalışma Süresi",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# gün} other {# gün}} {hours, plural, one {# saat} other {# saat}} {minutes, plural, one {# dakika} other {# dakika}}",
    'ServerInformation.sectionCpu' => "CPU Kullanımı",
    'ServerInformation.la1min' => "Son 1 dakika",
    'ServerInformation.la5min' => "Son 5 dakika",
    'ServerInformation.la15min' => "Son 15 dakika",
    'ServerInformation.sectionMemory' => "Memory kullanımı",
    'ServerInformation.memoryHardware' => "Donanım",
    'ServerInformation.memoryTotalNoKernel' => "Toplam (çekirdek hariç)",
    'ServerInformation.memoryTotal' => "Toplam",
    'ServerInformation.memoryUsed' => "Kullanımda",
    'ServerInformation.memoryFree' => "Boş",
    'ServerInformation.memoryShared' => "Paylaşılan",
    'ServerInformation.memoryBuffer' => "Ara bellek",
    'ServerInformation.memoryCached' => "Önbelleğe alınmış",
    'ServerInformation.memoryAvailable' => "Uygun",
    'ServerInformation.memoryUsage' => "Kullanım",
    'ServerInformation.sectionSwap' => "Kullanımı Değiştir",
    'ServerInformation.sectionVirtualMemory' => "Sanal Bellek Kullanımı",
    'ServerInformation.swapTotal' => "Toplam",
    'ServerInformation.swapUsed' => "Kullanımda",
    'ServerInformation.swapFree' => "Boş",
    'ServerInformation.swapUsage' => "Kullanım",
    'ServerInformation.sectionHarddisk' => "Hard Disk kullanımı",
    'ServerInformation.harddiskDirectory' => "Dosya sistemi",
    'ServerInformation.harddiskProtectedDir' => "Önemli dizinler",
    'ServerInformation.harddiskTotal' => "Toplam",
    'ServerInformation.harddiskUsed' => "Kullanımda",
    'ServerInformation.harddiskAvailable' => "Uygun",
    'ServerInformation.harddiskCapacity' => "Kapasite",
    'ServerInformation.sectionDomains' => "Alan Adları",
    'ServerInformation.activeDomains' => "Etkin",
    'ServerInformation.inactiveDomains' => "Etkin değil",
    'ServerInformation.problemDomains' => "Sorunlar",
    'ServerInformation.refreshed' => "Bilgi yenilendi.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Tüm hakları saklıdır.',
    'ServerAbout.linkLicenseManagement' => 'Lisans Bilgisine gidin',
    'ServerAbout.panelVersion' => 'Versiyon',
    'ServerAbout.installedPatchVersion' => '#%%patch%%\'yı güncelle',
    'ServerAbout.licenseKey' => 'Lisans anahtarı',
    'ServerAbout.productDescription' => 'Plesk, uygulamaları, web sitelerini ve barındırma şirketlerini çalıştırma, otomatikleştirme ve büyütmede önde gelen WebOps platformudur.',
    'ServerAbout.readEula' => '%%link%%\'yı okuyun.',
    'ServerAbout.linkEula' => 'Son Kullanıcı Lisans Sözleşmesi',
    'ServerAbout.visitForum' => '%%link%%\'yı ziyaret edin',
    'ServerAbout.linkForum' => 'Plesk forum',
    'ServerAbout.followUs' => 'Bizi takip edin',
    'ServerAbout.visitSite' => '%%link%%\'te daha fazla bilgi edinin',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => '%%link%%\'ten ilham alın',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Tebrikler!',
    'ServerAbout.darkThemePromoDescription' => 'Bir büyücü kedi buldunuz.',
    'ServerAbout.darkThemePromoButton' => 'Hokus pokus! Karanlık tarafa gel',
    'ServerAbout.darkThemeTourDescription' => 'Arayüzünüz için karanlık temayı etkinleştirmek veya devre dışı bırakmak için bu seçeneği kullanın.',
    'ServerAbout.darkThemeTourButton' => 'Anladım',

    'ts-sessions.title' => 'Terminal Sunucu Oturumları',
    'ts-sessions-properties.title' => 'Oturum özellikleri',

    'BandwidthLimiting.bandwidthThrottling' => 'QoS kurulu olmadığından, bant genişliği kısmasını kontrol edemezsiniz.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bant genişliği sınırlama, sadece web barındırmalı alan adları için kullanılabilir.',
    'BandwidthLimiting.bandwidthLabel' => 'Maksimum bant genişliği kullanımı',
    'BandwidthLimiting.bandwidthHint' => 'Bant genişliği kullanım sınırı, sadece HTTP protokolü aracılığıyla aktarılan verilere uygulanır.',
    'BandwidthLimiting.maxConnectionLabel' => 'Bağlantı sınırları',
    'BandwidthLimiting.maxConnectionHint' => 'Bant genişliğinizi sınırlarsanız web sitesine eşzamanlı bağlantıların sayısını da sınırlamanız önerilir. Aksi takdirde, web sitesine çok sık talep gelmesi durumunda, web sunucusu işlemleri sunucu yükünü artırır.',
    'BandwidthLimiting.kbps' => 'KB/saniye',
    'BandwidthLimiting.success' => 'Bant genişliği sınırlama ayarları değiştirildi.',
    'BandwidthLimiting.unlimited' => 'Sınırsız',

    'ip-address-domains.title' => '%%type%% IP adresi %%ipAddress%% kullanan web siteleri',
    'ip-address-domains.site' => 'Konum',
    'ip-address-domains.setAsDefault' => 'Varsayılan olarak ata',
    'ip-address-domains.type-SHARED' => 'paylaşılan',
    'ip-address-domains.type-EXCLUSIVE' => 'atanmış',

    'HotlinkProtection.virtualHostingRequired' => 'Bağlantı Kurma Koruması, sadece web barındırmalı alan adları için kullanılabilir.',
    'HotlinkProtection.enabledLabel' => 'Bağlantı kurma korumasını etkinleştirin',
    'HotlinkProtection.extensionsLabel' => 'Korunan dosya uzantıları',
    'HotlinkProtection.friendsLabel' => 'Dost web sitelerinin adresleri',
    'HotlinkProtection.success' => 'Bağlantı kurma koruma ayarları değiştirildi.',

    'Odbc.add' => 'ODBC DSN Ekle',
    'Odbc.resourceUsage' => '%%used%% oluşturuldu / %%allowed%% için izin verildi.',
    'Odbc.limitExceeded' => 'ODBC DSN Bağlantı sınırı aşıldı.',
    'Odbc.unlimited' => 'Sınırsız',
    'Odbc.addTooltip' => 'ODBC veri kaynağı ekleyin.',
    'Odbc.status' => 'Durum',
    'Odbc.name' => 'Bağlantı adı',
    'Odbc.driver' => 'Sürücü',
    'Odbc.description' => 'Bağlantı açıklaması',
    'Odbc.hostname' => 'İstemci adı',
    'Odbc.statusSystem' => 'Sistem DSN\'i.',
    'Odbc.statusConfigured' => 'DSN konfigüre edilmiş.',
    'Odbc.statusNotConfigured' => 'DSN konfigüre edilmemiş.',
    'Odbc.noSelectionText' => 'Kaldırmak için bir veya daha fazla öge seçin.',
    'Odbc.removeConfirmation' => '{count, plural, =1 {{name} bağlantısı} one {} other {Seçili # bağlantı}} kaldırılsın mı?',
    'Odbc.removeSuccess' => 'Seçilen bağlantılar kaldırıldı.',

    'DomainAliasSettings.title' => 'Takma Alan Adı Ayarları',
    'DomainAliasSettings.updateSuccess' => '%%name%% takma alan adının özellikleri değiştirildi. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Web sitesi ayarları %%restartInterval%% dakika sonra uygulanacak.',

    'Home.Backup.offStatus' => 'Bu geçerli bir yedekleme değil. Veriler bu yedeklemeden geri yüklenemez.',
    'Home.Backup.task-failedStatus' => 'Yedeklemesi başarısız oldu.',
    'Home.Backup.activeSchedule' => 'Plan: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Planlar: %%schedules%%',
    'Home.Backup.noSchedule' => "Yedeleme planı ayarlanmadı",
    'Home.Backup.period_hourly' => 'Saatlik, %%schedule%%',
    'Home.Backup.period_daily' => 'Günlük, %%schedule%%',
    'Home.Backup.period_weekly' => 'Haftalık, %%schedule%%',
    'Home.Backup.period_monthly' => 'Aylık, %%schedule%%',
    'Home.Backup.create' => 'Bir yedekleme oluştur',
    'Home.Backup.schedule' => 'Çizelge',
    'Home.ChangeLog.seeHistory' => 'Değiştirme Geçmişini Görün',
    'Home.CustomButtons.add' => 'Özel düğme ekleyin',
    'Home.CustomButtons.noButtons' => 'Hiçbir özel düğme yok',
    'Home.Customization.title' => 'Pano',
    'Home.Customization.description' => 'Görmek istediğiniz seçeneği seçin',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Sunucu',
    'Home.Customization.securitySection' => 'Güvenlik',
    'Home.Customization.backup' => 'Son Sunucu Yedeklemesi',
    'Home.Customization.ipBan' => 'IP Adresi Yasaklaması',
    'Home.Customization.mailQueue' => 'Posta Sırası',
    'Home.Customization.mySubscriptions' => 'Aboneliklerim',
    'Home.Customization.overusedSubscriptions' => 'Fazla Kullanımlı Abonelikler',
    'Home.Customization.serverInfo' => 'Sunucu Bilgileri',
    'Home.Customization.updates' => 'Plesk Güncellemeleri',
    'Home.Customization.promo' => 'Promosyon',
    'Home.Customization.changeLog' => 'Yenilikler',
    'Home.Customization.customButtons' => 'Özel Butonlar',
    'Home.EmptyView.title' => 'Hangi seçenekleri göreceğinizi tercih ederek kontrol panelinizden en iyi şekilde faydalanın.',
    'Home.EmptyView.titleLocked' => 'Kontrol paneli, servis sağlayıcınız tarafından kilitlendi.',
    'Home.EmptyView.customize' => 'Özelleştir',
    'Home.Extension.title' => 'Uzantı',
    'Home.IpBan.banned' => 'Yasaklanan',
    'Home.IpBan.trusted' => 'Güvenilen',
    'Home.IpBan.more' => 'Daha fazlası',
    'Home.MailQueue.total' => 'Toplam',
    'Home.MailQueue.deferred' => 'Ertelenen',
    'Home.MailQueue.held' => 'Beklemede',
    'Home.MailQueue.more' => 'Daha fazlası',
    'Home.MailQueue.clean' => 'Posta sırasını temizle',
    'Home.MailQueue.checkLogs' => 'Günlükleri kontrol et',
    'Home.MailQueue.repair' => 'Onarın',
    'Home.MailQueue.cleanConfirmQuestion' => 'Posta sırası silinsin mi?',
    'Home.MailQueue.cleanConfirmYes' => 'Evet',
    'Home.MailQueue.cleanConfirmNo' => 'Hayır',
    'Home.MailQueue.queueCleaned' => 'Posta sırası başarıyla temizlendi.',
    'Home.MailQueue.Promo.title' => 'Teslimat durumuna ve günlüklerine kolayca erişin',
    'Home.MailQueue.Promo.link' => 'Yeni posta sırasını şimdi deneyin',
    'Home.OverusedSubscriptions.empty' => 'Fazla kullanımlı abonelik bulunmadı',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% / %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Tüm fazla kullanımlıları gör: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Listede açın',
    'Home.PromoNewHomeView.title' => 'Yeni ana sayfaya hoş geldiniz!',
    'Home.PromoNewHomeView.description' => 'Herhangi bir sorunla karşılaşırsanız lütfen geri bildirim verin. İlerideki geliştirmelerimizde bize çok faydası olur.',
    'Home.PromoNewHomeView.feedback' => 'Geri bildirim paylaş',
    'Home.PromoNewHomeView.switch' => '"Ana Sayfaya" geri dön',
    'Home.ServerInfo.hostname' => 'İstemci adı',
    'Home.ServerInfo.ipAddress' => 'IP Adresi',
    'Home.ServerInfo.publicIpAddress' => 'Genel IP adresi',
    'Home.ServerInfo.os' => 'İşletim Sistemi',
    'Home.ServerInfo.uptime' => 'Çalışma Süresi',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# gün} other {# gün}} {hours, plural, one {# saat} other {# saat}} {minutes, plural, one {# dakika} other {# dakika}}",
    'Home.ServerInfo.more' => 'Daha fazlasını görün',
    'Home.Subscriptions.add' => 'Yeni ekleyin',
    'Home.Subscriptions.empty' => 'Sunucudaki yalıtılmış bir alanda birden fazla siteyi barındırmak için abonelikler oluşturun.%%link%%',
    'Home.Subscriptions.help' => 'Daha fazla bilgi',
    'Home.Updates.title' => 'Ürün Güncellemeleri',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Güncelle #%%patch%%',
    'Home.Updates.manageComponents' => 'Bileşenleri Ekleyin veya Kaldırın',
    'Home.Updates.lastUpdated' => 'Son güncelleme %%lastUpdateDate%% tarihinde',
    'Home.Updates.checkUpdates' => 'Güncelleştirmeleri kontrol edin',
    'Home.Updates.enableAutoupdate' => 'Otomatik Güncellemelere İzin Ver',
    'Home.Updates.lastChecked' => 'Son kontrol %%lastCheckDate%% tarihinde',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% kullanılabilir',
    'Home.Updates.installNewVersion' => 'Şimdi Yükle',
    'Home.Updates.patchAvailable' => 'Küçük güncellemeler kullanılabilir',
    'Home.Updates.patchAvailableVersion' => '%%currentVersion%% için küçük güncellemeler mevcut',
    'Home.Updates.installPatch' => 'Güncelleştir',
    'Home.Updates.pumUpdates' => '{total, select, 1 {{package} için güncelleme} other {{package} için güncellemeler}} mevcut',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# paket} other {# paket}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Şimdi Güncelle} other {Tümünü Güncelle}}',
    'Home.Promo.Customize.title' => 'Kontrol panelini kendinize özel hâle getirin!',
    'Home.Promo.Customize.content' => 'Yeni özelleştirilebilir kontrol paneliyle en sevdiğiniz özellikler elinizin altında',
    'Home.Promo.Customize.action' => 'Özelleştir',
    'Home.Promo.SwitchToPuv.title' => 'Plesk\'teki arayüz görüntülemelerini biliyor musunuz?',
    'Home.Promo.SwitchToPuv.content' => 'Hizmet planlarını kullanarak müşterilerinize barındırma hizmetleri sunmuyorsanız web sitelerini ve dosyalarını, veritabanlarını, e-posta hesaplarını ve web uygulamalarını yönetmek için daha uygun olan arayüzü denemek isteyebilirsiniz.',
    'Home.Promo.SwitchToPuv.action' => 'Hemen deneyin',
    'Home.Status.error' => 'Hata',
    'Home.Status.warning' => 'Uyarı',
    'Home.Status.info' => 'Bilgi',

    'HostingSettings.title' => 'Barındırma Ayarları',
    'HostingSettings.updateSuccess' => 'Ayarlar güncellendi.',
    'HostingSettings.emptyLogin' => 'Bir kullanıcı adı belirtmeniz gerekir.',
    'HostingSettings.emptyPassword' => 'Bir şifre belirtmeniz gerekir.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP sunucusu IPv6\'yı desteklemiyor. En az bir IPv4 adresi ayırın, aksi takdirde kullanıcı sunucuya FTP üzerinden dosya yükleyemeyecek.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Alan adı ayarları',
    'HostingSettings.domainSettingsSection.domainName' => 'Alan adı',
    'HostingSettings.domainSettingsSection.description' => 'Örneğin example.com ',

    'HostingSettings.submitPopover.title' => '%%website%% içeriğini silin',
    'HostingSettings.submitPopover.descriptionMainDomain' => '"Web Sitesi" barındırma tipini "%%type%%" olarak değiştirmek tüm web sitesi içeriğini siler, şu dizinler dâhil:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Web sitenizin barındırma tipini değiştirmek istiyor musunuz?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Daha fazla ayara erişmek için sistem kullanıcısı bilgilerini girin ve "Web Alanı Oluştur"a tıklayın.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Daha fazla ayara erişmek için "Sonraki" seçeneğine tıklayıp barındırma oluşturun.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Barındırma tipi',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tür',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Web Sitesi',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'İletim',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Web barındırması yok',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Bu alan adının altında posta kutuları kullanmak için alan adının DNS bölgesini kullanın',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Web sitesi giriş dizini yolu',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Tercih edilen alan adı',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Ziyaretçiler, bir SEO dostu HTTP 301 ile yeniden yönlendirilecek.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Ziyaretçileri şuraya yönlendir:',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'İletme tipi',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Kalıcı olarak taşındı (kod 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Web sitesi ziyaretçilerini başka bir siteye yönlendirin ve onlara hedef adresi gösterin. Böyle bir yönlendirmede sitenin arama sıralaması korunur',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Geçici olarak taşındı (kod 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Arama motorlarının bu geçici siteyi dizinlemesini istemiyorsanız, web sitesi ziyaretçilerini geçici bir site kopyasına yönlendirin.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame içinde yönlendirme',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Web sitesi ziyaretçilerini başka bir siteye yönlendirin, ancak yönlendirme hakkında bilgileri olmaması için onlara hedef adresi göstermeyin.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Tercih edilen alan adı',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Hiçbiri',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Belge kökü',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Bu web sitesinde kurulu ağı uygulamaları bulunduğundan, belge kökünü değiştirmek imkansızdır.',
    'HostingSettings.domainSettingsSection.save' => 'Kaydet',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Uyumluluk modu',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Web sitesini eski "Ayrı SSL/TLS ve SSL/TLS dışı içerik" seçeneği için uyumluluk modunda çalıştırın',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Bu web sitesi uyumluluk modunda çalışıyor ve Plesk arayüzü ile yönetilemez. Bunun sebebi, yükseltmeden önce kullanımdan kaldırılan "Ayrı SSL/TLS ve SSL/TLS dışı içerik" seçeneğini işaretlemiş olmanız. Plesk 11\'den itibaren web siteleri, HTTP ve HTTPS bağlantıları üzerinden erişilebilen içeriğini depolamak için aynı dizini kullanır. Tüm verileri "httpsdocs/" dizininden "httpdocs/" dizinine taşımanızı ve sonra uyumluluk modunu kapatmanızı öneriyoruz. Böylece "httpsdocs/" dizininde yüklü olan uygulamalar da internet üzerinden erişilebilir hâle gelir. Uyumluluk modunu tekrar açamayacağınızı lütfen unutmayın.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Bu ayarı değiştir?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Bu ayarı değiştirmek sunucunun güvenlik politikası ile çelişiyor ve performansı kötü etkileyebilir veya sunucuyu saldırılara karşı korunmasız hâle getirebilir.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Değiştir',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Geri Al',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Güvenli önceden tanımlı ayarlar uygulandı',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Geliştirilmiş güvenlik için önceden tanımlı güvenli ayarları uygulayın. Bazı izinler, abonelerin bu ayarları değiştirmesine müsaade eder.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Güvenli ön ayarları uygula',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Güvenli barındırma ayarları hakkında bilgi edin',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS destekli',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Etkin',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Web sitesi ile ziyaretçinin tarayıcısı arasındaki bağlantıları şifreleyin.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Sertifika',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'HTTPS etkinleştirmek için alan adının deposuna bir SSL/TLS sertifikası yükleyin ve sonra buradan sertifikayı seçin.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Ziyaretçileri bir SEO dostu HTTP 301 ile HTTP\'den HTTPS\'ye yeniden yönlendir',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Deponuzda hiçbir SSL/TLS sertifikası yok. Bir sertifika eklemek için, %%link%% bağlantısına gidin.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'bu sayfa',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (diğer depo)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Seçili değil',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web komut dosyası',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Web sunucusu tarafından yorumlanacak programlama ve komut dosyası dillerini seçin.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin dizini %%value%% konumunda bulunur',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => '*.htm, *.html dosyaları için SSI kullanın',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET sürümü',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Özel hata belgeleri',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin dizini burada bulunur',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'bu alan adının belge kökü',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'web alanının kök dizini',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'bu alan adının eski stil kökü',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Özel hata belgeleri',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Ek yazma/değiştirme izinleri',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Dağıtımını yayınlama',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Web istatistikleri',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Araç',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'FTP kullanıcı adınız ve şifrenizle web istatistiklerinize erişimi koruyun',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Devre Dışı Bırakıldı',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Web alanı ayarları',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP Adresleri',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Disk alanı kotası',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Etkin',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Abonelik ayarlarında belirtilen disk alanı kotası (eğer varsa) aşılırsa web sitesinin dosyalarında işlem yapmayı yasaklayın.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Sabit disk kotası, sunucunun dosya sistemi yapılandırmasından dolayı desteklenmiyor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Sistem kullanıcı bilgileri',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'FTP veya Dosya Yöneticisi ile web sitesi dosyalarını ve klasörlerini yönetin. İzin veriliyorsa sunucuya SSH ile erişin.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'FTP veya Dosya Yöneticisi ile web sitesi dosyalarını ve klasörlerini yönetin. İzin veriliyorsa sunucuya Uzak Masaüstü ile erişin.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Kullanıcı adı',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Şifre',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Sistem kullanıcısının şifresini değiştirmek için buraya yeni bir şifre girin.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH erişimi',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Uzak Masaüstü erişimi',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Etkin',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Sistem kullanıcısının kimlik bilgileriyle sunucuya erişin.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tür',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Devre Dışı Bırakıldı',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => '{count, plural, other {# Alan adı}} için',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Aşağıdaki ayarlar {count, plural, other {{name} web alanındaki tüm # alan adı}} için ortaktır:',

    'OdbcAdd.title' => 'ODBC DSN Ekle',
    'OdbcAdd.nameLabel' => 'Bağlantı adı',
    'OdbcAdd.descriptionLabel' => 'Bağlantı açıklaması',
    'OdbcAdd.driver' => 'Sürücü',
    'OdbcAdd.submit' => 'ODBC DSN Oluştur',

    'OdbcEdit.title' => 'Bir ODBC Bağlantısı Oluşturun',
    'OdbcEdit.saveSuccess' => 'Bağlantı ayarları kaydedildi.',
    'OdbcEdit.test' => 'Bağlantıyı test et',
    'OdbcEdit.connectSuccess' => 'Bağlantı başarılı.',

    'OdbcEdit.excel.driver.label' => 'Sürücü',
    'OdbcEdit.excel.dbq.label' => 'Veritabanı dosyası yolu',
    'OdbcEdit.excel.defaultdir.label' => 'Varsayılı data dizini',
    'OdbcEdit.excel.fil.label' => 'Veritabanı sürümü',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maksimum arabellek boyutu',
    'OdbcEdit.excel.pagetimeout.label' => 'Sayfa zamanaşımı',

    'OdbcEdit.access.driver.label' => 'Sürücü',
    'OdbcEdit.access.dbq.label' => 'Veritabanı dosyası yolu',
    'OdbcEdit.access.uid.label' => 'Oturum Açma Kimliği',
    'OdbcEdit.access.pwd.label' => 'Şifre',
    'OdbcEdit.access.pagetimeout.label' => 'Sayfa zamanaşımı',
    'OdbcEdit.access.pagetimeout.description' => 'Kullanılmamış bir sayfanın arabellekte kaldığı (saniyenin onda biri cinsinden) süre.  Bu seçenek, Microsoft Access sürücüsünü kullanan tüm veri kaynakları için geçerlidir.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maksimum arabellek boyutu',
    'OdbcEdit.access.maxbuffersize.description' => 'KB cinsinden iç arabelleğin boyutu 256 KB sınırına hizalanır.',
    'OdbcEdit.access.readonly.label' => 'Salt okunur',
    'OdbcEdit.access.readonly.description' => 'Veritabanını her türlü güncelleştirmeyi önlemek üzere salt okunur olarak atar.',
    'OdbcEdit.access.exclusive.label' => 'Özel',
    'OdbcEdit.access.exclusive.description' => 'Veritabanını paylaşılan güncelleştirmeleri önlemek üzere özel olarak atar.',
    'OdbcEdit.access.safetransactions.label' => 'Güvenli işlemler',
    'OdbcEdit.access.safetransactions.description' => '0 (varsayılan ayar) olarak ayarlandığında, tüm işlemler anında uygulanır.  1 olarak ayarlandığında, tüm işlemler diske ancak bir uygulama işleminden sonra kaydedilir, ancak performans biraz bozunur.',
    'OdbcEdit.access.threads.label' => 'İş Parçacıkları',
    'OdbcEdit.access.threads.description' => 'Kullanılacak altyapı için arka plan iş parçacıklarının sayısı.',
    'OdbcEdit.access.maxscanrows.label' => 'Taranacak maksimum satır',
    'OdbcEdit.access.maxscanrows.description' => 'Varolan verilere dayalı olarak sütunun veri türü ayarlanırken taranacak satır sayısı.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Bir işlemin dışında yapılan değişikliklerin veritabanına yazılma şeklini belirtir.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'MS Access sürücüsünün kullanıcı tanımlı açık işlemleri zaman uyumsuz olarak gerçekleştirip gerçekleştirmeyeceğini belirler.',

    'OdbcEdit.mssql.driver.label' => 'Sürücü',
    'OdbcEdit.mssql.server.label' => 'Sunucu',
    'OdbcEdit.mssql.uid.label' => 'Oturum Açma Kimliği',
    'OdbcEdit.mssql.pwd.label' => 'Şifre',
    'OdbcEdit.mssql.database.label' => 'Varsayılan veri tabanı',
    'OdbcEdit.mssql.app.label' => 'Uygulama adı',
    'OdbcEdit.mssql.wsid.label' => 'İş İstasyonu Kimliği',
    'OdbcEdit.mssql.language.label' => 'Varsayılan dil',
    'OdbcEdit.mssql.oemtoansi.label' => 'Uzatılmış karakterleri OEM değerlerine dönüştürme',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC sürücüsü',
    'OdbcEdit.mysql.server.label' => 'Sunucu',
    'OdbcEdit.mysql.server.description' => 'MariaDB/MySQL sunucusunun ana bilgisayar adı',
    'OdbcEdit.mysql.database.label' => 'Varsayılan veri tabanı',
    'OdbcEdit.mysql.user.label' => 'Kullanıcı adı',
    'OdbcEdit.mysql.user.description' => 'MariaDB/MySQL\'ye bağlanmak için kullanılan kullanıcı adı',
    'OdbcEdit.mysql.password.label' => 'Şifre',
    'OdbcEdit.mysql.password.description' => 'Sunucudaki kullanıcı hesabının şifresi',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Sunucu yerel ana bilgisayar olmadığında kullanılacak TCP/IP bağlantı noktası',
    'OdbcEdit.mysql.socket.label' => 'Yuva',
    'OdbcEdit.mysql.socket.description' => 'Windows, sunucu yerel ana bilgisayar olduğunda bağlanacak boruyu belirtti',
    'OdbcEdit.mysql.option.label' => 'Seçenek',
    'OdbcEdit.mysql.option.description' => 'MyODBC\'nin nasıl çalışacağını belirten seçenekler. <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">Belgeye</a> bakınız',

    'ProtectedDirectoryList.add' => 'Korunmuş Dizin Ekle',
    'ProtectedDirectoryList.addTooltip' => 'Korunmuş dizin oluşturun.',
    'ProtectedDirectoryList.name' => 'Adı',
    'ProtectedDirectoryList.realmTitle' => 'Korunmuş alan başlığı',
    'ProtectedDirectoryList.noSelectionText' => 'Kaldırmak için bir veya daha fazla öge seçin.',
    'ProtectedDirectoryList.edit' => 'Düzenle',
    'ProtectedDirectoryList.remove' => 'Şifre Korumasını Kaldır',
    'ProtectedDirectoryList.removeTooltip' => 'Seçili dizinlerden şifre sorgulamasını kaldır.',
    'ProtectedDirectoryList.removeConfirmation' => 'Bu işlem, {count, plural, =1 {{name} dizinindeki} one {{name} dizinindeki} other {seçili # dizindeki}} korumayı kaldırmaya neden olur. {count, plural, =1 {Bu dizin} one {Bu dizin} other {Dizinler}}, İnternet kullanıcıları için serbestçe erişilebilir hâle gelir.',
    'ProtectedDirectoryList.removeSuccess' => 'Seçili dizinler kaldırıldı.',

    'ProtectedDirectoryAdd.title' => 'Korunmuş Dizin oluşturun',
    'ProtectedDirectoryAdd.submit' => 'Oluştur',
    'ProtectedDirectoryAdd.success' => 'Korunmuş dizin %%path%% başarıyla oluşturuldu',

    'ProtectedDirectoryEdit.title' => 'Korunmuş Dizin ayarları',
    'ProtectedDirectoryEdit.success' => 'Korunmuş dizin ayarları değiştirildi',

    'ProtectedDirectoryUserAdd.title' => 'Korunmuş Dizin Kullanıcısı Oluşturun',
    'ProtectedDirectoryUserAdd.subtitle' => '%%directory%% Dizini',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Kullanıcı adı',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Şifre',
    'ProtectedDirectoryUserAdd.submit' => 'Oluştur',
    'ProtectedDirectoryUserAdd.success' => '%%login%% korunmuş dizin kullanıcı oluşturuldu.',

    'ProtectedDirectoryUserPassword.title' => 'Korumalı dizin kullanıcısı için şifre',
    'ProtectedDirectoryUserPassword.subtitle' => '%%login%% Kullanıcısı',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Şifre',
    'ProtectedDirectoryUserPassword.submit' => 'Kaydet',
    'ProtectedDirectoryUserPassword.success' => 'Kullanıcının kimlik bilgileri kaydedildi.',

    'SummaryReport.Layout.title' => 'Rapor Yerleşimi Özellikleri',
    'SummaryReport.Layout.success' => '%%name%% rapor yerleşimi güncellendi.',
    'SummaryReport.Layouts.title' => 'Rapor Yerleşimleri',

    'SummaryReport.Layout.Add.title' => 'Rapor Yerleşimi Oluşturun',
    'SummaryReport.Layout.Add.success' => '%%name%% rapor yerleşimi oluşturuldu.',

    'SummaryReport.Report.title' => 'Özet Rapor',
    'SummaryReport.Report.buttonLayouts' => 'Yerleşimler',
    'SummaryReport.Report.buttonSchedule' => 'Çizelge',
    'SummaryReport.Report.buttonProperties' => 'Özellikler',
    'SummaryReport.Report.buttonTrafficHistory' => 'Veri trafiği istatistikleri',
    'SummaryReport.Report.buttonPrint' => 'Yazdır',
    'SummaryReport.Report.buttonSend' => 'E-postayla Gönderin',
    'SummaryReport.Report.successSent' => 'Rapor %%email%% konumuna gönderildi',

    'SummaryReport.Schedule.title' => '%%name%% için Gönderim Planlamaları',
    'SummaryReport.Schedule.Properties.title' => '%%name%% için Gönderim Planlaması',
    'SummaryReport.Schedule.Properties.success' => 'Rapor teslimatı planlaması güncellendi.',

    'SummaryReport.Schedule.Add.title' => '%%name%% için Gönderim Planlamaları Oluşturun',
    'SummaryReport.Schedule.Add.success' => 'Rapor teslimatı planlaması oluşturuldu.',

    'SummaryReport.TrafficHistory.title' => 'Veri trafiği istatistikleri',

    'VirtualDirectory.errNotExist' => 'Bu sanal dizin var olmayan bir fiziksel klasöre bağlı.',
    'VirtualDirectory.errNoPermissions' => 'Bu dizinin içeriğini görüntüleme izniniz yok.',
    'VirtualDirectory.buttonProperties' => 'Dizin Özellikleri',
    'VirtualDirectory.buttonPropertiesHint' => 'Sanal dizin özelliklerini görüntüleyin ve değiştirin.',
    'VirtualDirectory.buttonPermissions' => 'Dizin Erişim İzinleri',
    'VirtualDirectory.buttonPermissionsHint' => 'Dizin erişim izinlerini ayarlayın.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'ASP.NET ayarlarını yapılandırın.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'PHP ayarlarını yapılandırın.',
    'VirtualDirectory.tabBrowse' => 'Dizinler',
    'VirtualDirectory.tabBrowseHint' => '%%site%% sitesindeki fiziksel ve sanal dosyalar ve dizinlerle çalışın.',
    'VirtualDirectory.tabMimeTypes' => 'MIME Türleri',
    'VirtualDirectory.tabMimeTypesHint' => 'Kayıtlı MIME tiplerini yönetin.',
    'VirtualDirectory.tabErrorDocs' => 'Hata Belgeleri',
    'VirtualDirectory.tabErrorDocsHint' => 'Hata belgelerini yönetin.',
    'VirtualDirectory.tabProtection' => 'Şifre Koruma',
    'VirtualDirectory.tabProtectionHint' => 'Dizine erişimi şifre korumasıyla sınırlayın.',

    'VirtualDirectory.errorDocType.default' => 'Varsayılan',
    'VirtualDirectory.errorDocType.file' => 'Dosya',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'Dizin Oluştur',
    'VirtualDirectory.CreateDirectory.name' => 'Dizin adı',
    'VirtualDirectory.CreateDirectory.success' => '%%name%% dizini oluşturuldu.',
    'VirtualDirectory.CreateDirectory.errExists' => '%%name%% dizini zaten mevcut.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Sanal Dizin Oluştur',
    'VirtualDirectory.CreateVirtualDirectory.success' => '%%name%% dizini oluşturuldu.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Sanal Dizin Özellikleri',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Sanal dizin düzenlendi.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Kapat',

    'VirtualDirectory.MimeTypeList.add' => 'MIME Türü Ekle',
    'VirtualDirectory.MimeTypeList.edit' => 'MIME tipini düzenle',
    'VirtualDirectory.MimeTypeList.addHint' => 'Yeni bir MIME tipi kaydedin.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Uzantı',
    'VirtualDirectory.MimeTypeList.columnContent' => 'İçerik',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Kaldırmak için bir veya daha fazla öge seçin.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => '{count, plural, =1 {Seçilen MIME tipi} one {Seçilen # MIME tipi} other {Seçilen # MIME tipi}} kaldırılsın mı?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Seçilen MIME tipleri kaldırıldı.',

    'VirtualDirectory.CreateMimeType.title' => 'MIME Türü Ekle',
    'VirtualDirectory.CreateMimeType.success' => 'Yeni MIME tipi kaydedildi.',

    'VirtualDirectory.EditMimeType.title' => 'MIME tipini düzenle',
    'VirtualDirectory.EditMimeType.success' => 'MIME tipi düzenlendi.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Hata',
    'VirtualDirectory.ErrorDocList.columnName' => 'Tanım',
    'VirtualDirectory.ErrorDocList.columnType' => 'Tür',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Konum',
    'VirtualDirectory.ErrorDocList.edit' => 'Düzenle',

    'VirtualDirectory.EditErrorDoc.title' => 'Hata Dökümanını Düzenleyin',
    'VirtualDirectory.EditErrorDoc.success' => 'Hata dokümanı düzenlendi.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Hata',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Tür',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Konum',

    'VirtualDirectory.Protection.notSupported' => 'Dizin adı 245 karakteri aştığı veya desteklenmeyen karakter içerdiğinden dolayı bu dizin için dizin koruma desteklenmiyor.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Sanal dizini koruma devre dışıdır',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Şifre Koruması',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => '%%path%% dizini korundu.',
    'VirtualDirectory.Protection.tools' => 'Araçlar',
    'VirtualDirectory.Protection.removeProtection' => 'Korumayı kaldırın',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Dizine tekabül eden URL\'nin herkes için erişilebilir olmasını sağlayın.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Sanal dizinden koruma kaldırılsın mı? Bu, tüm korunmuş dizin kullanıcılarını ve dizin koruma ayarlarını da kaldırır.',
    'VirtualDirectory.Protection.settings' => 'Ayarlar',
    'VirtualDirectory.Protection.settingsTooltip' => 'Dizin konumunu görüntüleyin ve korunmuş alan için bir başlık belirtin.',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET Ayarlarını Yapılandırın',

    'VirtualDirectory.Php.title' => 'PHP versiyonu',
    'VirtualDirectory.Php.version' => 'Versiyon',
    'VirtualDirectory.Php.success' => 'PHP sürümü güncellendi.',


    'MassMailPage.sendEmail' => 'Toplu E-Posta Gönderin',
    'MassMailPage.selectAtLeastOneTemplate' => 'En az bir şablon seçin',
    'MassMailPage.confirmRemoval' => 'Seçilen {count, select, 1 {şablonu} other {şablonları}} kaldırmak istediğinize emin misiniz?',
    'MassMailPage.remove' => 'Sil',
    'MassMailPage.filters' => 'Filtreler',
    'MassMailPage.name' => 'Şablon Adı',
    'MassMailPage.sender' => 'Gönderen',
    'MassMailPage.recipients' => 'Alıcılar',
    'MassMailPage.subject' => 'Konu',
    'MassMailPage.created' => 'Oluşturulma Tarihi',
    'MassMailPage.send' => 'Gönder',
    'MassMailPage.recipientsNone' => 'Hiçbiri',
    'MassMailPage.recipientsAdmins' => 'Yönetici',
    'MassMailPage.recipientsResellers' => 'Tüm satıcılar',
    'MassMailPage.recipientsResellersSelected' => 'Seçilen satıcılar',
    'MassMailPage.recipientsResellersExcept' => 'Seçilen dışındaki tüm satıcılar',
    'MassMailPage.recipientsClients' => 'Tüm müşteriler',
    'MassMailPage.recipientsClientsSelected' => 'Seçilen müşteriler',
    'MassMailPage.recipientsClientsExcept' => 'Seçilen dışındaki tüm müşteriler',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {Şablon} other {Şablonlar}} kaldırıldı.',
    'MassMailPage.emptyViewTitle' => 'Toplu e-posta mesajı şablonu yok',
    'MassMailPage.addNew' => 'Şanlon oluştur',
    'CreateMassMailTemplatePage.templateCreated' => 'Şablon oluşturuldu.',
    'EditMassMailTemplatePage.templateUpdated' => 'Şablon güncellendi.',
    'SendMassMailPage.emailSent' => 'E-posta gönderildi.',
    'SendMassMailPage.fieldIsRequired' => 'Alan boş olamaz',
    'SendMassMailPage.saveAsTemplate' => 'Oluşturulan mesajı yeni bir şablona kaydedin',
    'SendMassMailPage.newTemplateName' => 'Yeni şablon adı',
    'SendMassMailPage.selectedTemplate' => 'Seçilen şablon',
    'SendMassMailPage.send' => 'Gönder',
    'VirtualHostTemplatePage.name' => 'Adı',
    'VirtualHostTemplatePage.sizeInBytes' => 'Boyut',
    'VirtualHostTemplatePage.modified' => 'Değiştirme tarihi',
    'VirtualHostTemplatePage.permissions' => 'Yetkiler',
    'VirtualHostTemplatePage.user' => 'Kullanıcı',
    'VirtualHostTemplatePage.group' => 'Grup',
    'VirtualHostTemplatePage.uploadTemplate' => 'Yükle',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Şablon yüklendi.',
    'VirtualHostTemplatePage.root' => 'Sanal Şablon',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Şablonda dosya yok',
    'VirtualHostTemplatePage.total' => '{breadcrumbs} dizinindeki toplam öge: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Varsayılanı Kullan',
    'VirtualHostTemplatePage.successfullyReset' => 'Şablon varsayılana değiştirildi.',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Alan adı',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Sahibinin adı",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Kullanımda',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Sınır',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Uygun',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Kullanımda (% olarak)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Sadece alan adlarım',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Sahibin Adı',
];