<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Additional Key Properties',
    'additional-key-info.update' => 'Retrieve Additional Key',
    'additional-key-info.updateDescription' => 'Retrieve the additional key and install them.',
    'additional-key-info.download' => 'Download Key',
    'additional-key-info.downloadDescription' => 'Download the current license key.',
    'additional-key-info.install' => 'Install Key',
    'additional-key-info.installDescription' => 'Install the current license key.',
    'additional-key-info.revert' => 'Roll Back Key',
    'additional-key-info.revertDescription' => 'Revert to the previously installed license key.',
    'additional-key-info.revertNotAvailableDescription' => 'No key installed.',
    'additional-key-info.installSuccess' => 'License key installation has started.',

    'additional-key-revert.title' => 'Additional Key Rollback',
    'additional-key-revert.success' => 'The additional key was rolled back.',

    'additional-key-upload.title' => 'Install a License Key',
    'additional-key-upload.success' => 'The new additional key was uploaded.',

    'additional-keys.title' => 'Additional License Keys',

    'change-subscriptions-owner.title' => 'Reassigning Selected Subscriptions',
    'change-subscriptions-owner.success' => 'Subscription ownership was changed',

    'customers.hint' => 'This is where you manage accounts of your hosting service customers: create accounts along with service subscriptions, manage existing customers, and remove accounts. To administer websites, mail or any other services provided to a customer, go to their Customer Panel by clicking the link in the right column of the list.',

    'customer-domains.hint' => 'This is where you set up and manage websites.',

    'customer-subscriptions.hint' => 'This is where you manage the customer\'s subscriptions.',

    'domains.hint' => 'This is where you view information on all domain names registered in the system and can proceed to managing hosting services. To add a domain for yourself or for hosting customers, just click Add Domain. You will be prompted to create a new customer and subscription while creating a domain, or to select from existing ones.',

    'database-servers.title' => 'Database Servers',

    'database-server-create.title' => 'New database server',

    'database-server-properties.title' => 'Database server',

    'database-server-upgrade.drawerTitle' => 'MariaDB upgrade',
    'database-server-upgrade.drawerTitle.completed' => 'Upgrade complete',
    'database-server-upgrade.drawerSubTitle.line1' => 'The drawer cannot be closed while the upgrade is running.',
    'database-server-upgrade.drawerSubTitle.line2' => 'If issues occur during the upgrade, refer to %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'The MariaDB database server has been upgraded to version %%releaseVersion%%. If you face any issues, follow the instructions in %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'You already have the LTS version installed.',
    'database-server-upgrade.troubleshootingArticle' => 'this KB article',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Use %%troubleshootingArticle%% to troubleshoot MariaDB upgrade issues.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Upgrade your local MariaDB database server to the current long-term support (LTS) version.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'We strongly recommend that you back up your server before the upgrade and start the upgrade during websites\' off-peak hours.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'During the MariaDB upgrade, the Plesk server and hosted websites will be unavailable. The MariaDB upgrade is usually error-free and takes about 10 minutes, but it can still affect the whole server.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Note: If you are running MariaDB 5.5, Plesk will upgrade it to MariaDB 10.5 first. After the upgrade is completed, launch this wizard again to upgrade to the current LTS version of MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Current version',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Select the version to upgrade to',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'There are no major releases',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Release notes',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Release date: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End of life date: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Only MariaDB forks shipped by OS vendors or the MariaDB vendor can be upgraded.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Pre-upgrade checks',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Parsing MariaDB configuration files',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analyzing databases with mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analyzing the package manager configuration',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Checking system compatibility',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Checking WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'To proceed with the upgrade, select all the checkboxes. It is necessary to make sure that you agree with the configuration changes the upgrade will make and that you have access to recovery options.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'The following variables will be removed for compatibility with the new version:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} from {count, plural, one {the file {files}} other {the # files: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Access recovery options (the server command line console and Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'I confirm that I have SSH access to the server',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Use an SSH client or open the %%sshTerminalExtension%% in a new browser tab (do not close the SSH Terminal extension window until the upgrade is finished). If the upgrade fails, having SSH access will help with recovery.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal extension',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'I confirm that I have access to Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Open %%repairKit%% in a new browser tab and log in using the administrator credentials. Do not close the Repair Kit extension window until the upgrade is finished.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Back up databases',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Back up all databases hosted on the server before the upgrade',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk will store the backup of databases in the %%path%% directory.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket in Plesk is not available',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'You will not be able to see real-time output of the upgrade process without WebSocket.',

    'database-server-upgrade.submitPopover.title' => 'To prevent potential data loss, we strongly recommend that you create a dump of hosted databases before you proceed. Continue without creating a dump?',

    'database-server-databases.title' => 'Databases',

    'database-server-change-password.title' => 'Administrator\'s Password',

    'home.title' => 'Home',

    'license.title' => 'License Information',

    'primary-key-info.title' => 'Plesk License Key',
    'primary-key-info.update' => 'Retrieve Keys',
    'primary-key-info.updateDescription' => 'Retrieve the ordered license keys and install them.',
    'primary-key-info.upload' => 'Install Key',
    'primary-key-info.uploadDescription' => 'Upload and install a new license key.',
    'primary-key-info.revert' => 'Roll Back Key',
    'primary-key-info.revertDescription' => 'Revert to the previously installed license key.',

    'primary-key-revert.title' => 'License Key Rollback',
    'primary-key-revert.success' => 'The Plesk key was rolled back.',

    'primary-key-upload.title' => 'Install a License Key',
    'primary-key-upload.success' => 'The new Plesk key was uploaded.',

    'resellers.hint' => 'This is where you manage accounts of resellers — your customers who resell hosting services and host their own websites. Here you create accounts along with service subscriptions, manage existing resellers, and remove accounts.',

    'reseller-customers.hint' => 'This is where you set up and manage customers.',

    'reseller-domains.hint' => 'This is where you set up and manage websites.',

    'reseller-subscriptions.hint' => 'This is where you manage the reseller\'s subscriptions.',

    'subscriptions.hint' => 'Customers obtain hosting services from you by subscribing to a hosting plan. You can manage these subscriptions here, as well as your own subscriptions you create to host your websites. To administer websites, mail or any other services provided with a subscription, go to the subscriber\'s Customer Panel by clicking the link in the right column of the list.',

    'server-mail-settings.title' => 'Settings',
    'server-mail-spam-filter.title' => 'Spam Filtering',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Black List',
    'server-mail-white-list.title' => 'White List',
    'server-mail-queue.title' => 'Mail Queue',
    'server-mail-statistics.title' => 'Statistics',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Settings',
    'server-spam-filter.black-list' => 'Black list',
    'server-spam-filter.white-list' => 'White list',

    'firewall.title' => 'Firewall Management',
    'firewall-general.title' => 'General',
    'firewall-general.toggleStatus' => 'Firewall protection',
    'firewall-general.buttonDefault' => 'Reset to Default',
    'firewall-general.buttonPanic' => 'Panic Mode',
    'firewall-general.confirmationDefault' => 'Reset the firewall settings to the default ones?',
    'firewall-general.confirmationPanic' => 'Turn on Panic Mode? Users will not be able to access their domains and some network services may stop working.',
    'firewall-general.successDefault' => 'The firewall settings were reset to defaults.',
    'firewall-general.successPanic' => 'Panic mode was enabled.',
    'firewall-general.info' => 'For security reasons, the firewall blocks all connections except those explicitly allowed. You can allow a connection by creating a rule. Refer to the documentation for more information',
    'firewall-general.interfaces' => 'Network interfaces',
    'firewall-icmp.title' => 'ICMP Protocol',
    'firewall-rules.title' => 'Firewall Rules',

    'dns.title' => 'DNS Settings',
    'dns-records.title' => 'Zone Records Template',
    'dns-soa-record.title' => 'Zone Settings Template',

    'php-handler.title' => 'Settings for %%name%%',
    'php-handler.extensions.title' => 'Extensions',
    'php-handler.extensions.description' => 'These PHP extensions settings are for this handler only.',
    'php-handler.extensions.descriptionShared' => 'These settings are common to the following PHP handlers: %%handlers%%. The settings apply to all websites that use these handlers.',
    'php-handler.extensions.buttonManage' => 'Manage PECL Packages',
    'php-handler.extensions.manage.title' => 'Manage PECL Packages',
    'php-handler.extensions.manage.risks' => 'PHP extensions are supplied by third-party PECL packages. You are installing them at your own risk.',
    'php-handler.extensions.manage.description' => 'Install, upgrade and uninstall PECL packages. The changes will be applied to all websites running on %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Why is the desired package not on the list?',
    'php-handler.extensions.manage.limitations' => 'PHP extensions shipped by the control panel provider and OS vendors are not shown on the list.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Refresh",
    'ServerInformation.sectionGeneral' => "General",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Version",
    'ServerInformation.os' => "Operating System",
    'ServerInformation.key' => "Plesk license key",
    'ServerInformation.uptime' => "Uptime",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# day} other {# days}} {hours, plural, one {# hour} other {# hours}} {minutes, plural, one {# minute} other {# minutes}}",
    'ServerInformation.sectionCpu' => "CPU Usage",
    'ServerInformation.la1min' => "Last 1 minute",
    'ServerInformation.la5min' => "Last 5 minutes",
    'ServerInformation.la15min' => "Last 15 minutes",
    'ServerInformation.sectionMemory' => "Memory Usage",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Total (excluding kernel)",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Used",
    'ServerInformation.memoryFree' => "Free",
    'ServerInformation.memoryShared' => "Shared",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Cached",
    'ServerInformation.memoryAvailable' => "Available",
    'ServerInformation.memoryUsage' => "Usage",
    'ServerInformation.sectionSwap' => "Swap Usage",
    'ServerInformation.sectionVirtualMemory' => "Virtual Memory Usage",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Used",
    'ServerInformation.swapFree' => "Free",
    'ServerInformation.swapUsage' => "Usage",
    'ServerInformation.sectionHarddisk' => "Hard Disk Usage",
    'ServerInformation.harddiskDirectory' => "File system",
    'ServerInformation.harddiskProtectedDir' => "Important directories",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Used",
    'ServerInformation.harddiskAvailable' => "Available",
    'ServerInformation.harddiskCapacity' => "Capacity",
    'ServerInformation.sectionDomains' => "Domains",
    'ServerInformation.activeDomains' => "Active",
    'ServerInformation.inactiveDomains' => "Inactive",
    'ServerInformation.problemDomains' => "Problems",
    'ServerInformation.refreshed' => "Information refreshed.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. All rights reserved.',
    'ServerAbout.linkLicenseManagement' => 'Go to License Information',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Update #%%patch%%',
    'ServerAbout.licenseKey' => 'License key',
    'ServerAbout.productDescription' => 'Plesk is the leading WebOps platform to run, automate, and grow applications, websites, and hosting businesses.',
    'ServerAbout.readEula' => 'Read %%link%%.',
    'ServerAbout.linkEula' => 'End-User License Agreement',
    'ServerAbout.visitForum' => 'Visit %%link%%',
    'ServerAbout.linkForum' => 'Plesk forum',
    'ServerAbout.followUs' => 'Follow us',
    'ServerAbout.visitSite' => 'Learn more at %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Find inspiration at %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Congratulations!',
    'ServerAbout.darkThemePromoDescription' => 'You have found a magic kitty.',
    'ServerAbout.darkThemePromoButton' => 'Whoosh! Come to the dark side',
    'ServerAbout.darkThemeTourDescription' => 'Switch this option to enable or disable the dark theme for your interface.',
    'ServerAbout.darkThemeTourButton' => 'Got it',

    'ts-sessions.title' => 'Terminal Server Sessions',
    'ts-sessions-properties.title' => 'Session properties',

    'BandwidthLimiting.bandwidthThrottling' => 'You cannot control bandwidth throttling because QoS is not installed.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bandwidth limiting is available only for domains with web hosting.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximum bandwidth usage',
    'BandwidthLimiting.bandwidthHint' => 'The bandwidth usage limit is only applied to data transferred via the HTTP protocol.',
    'BandwidthLimiting.maxConnectionLabel' => 'Connections limited to',
    'BandwidthLimiting.maxConnectionHint' => 'If you limit bandwidth, we recommend that you also limit the number of simultaneous connections to the website. Otherwise, in case of frequent requests to the website, the web server processes will increase the server load.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Bandwidth limiting settings were changed.',
    'BandwidthLimiting.unlimited' => 'Unlimited',

    'ip-address-domains.title' => 'Websites that use %%type%% IP address %%ipAddress%%',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Set As Default',
    'ip-address-domains.type-SHARED' => 'shared',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicated',

    'HotlinkProtection.virtualHostingRequired' => 'The Hotlink Protection is available only for domains with web hosting.',
    'HotlinkProtection.enabledLabel' => 'Enable hotlink protection',
    'HotlinkProtection.extensionsLabel' => 'Protected files extensions',
    'HotlinkProtection.friendsLabel' => 'Addresses of friendly websites',
    'HotlinkProtection.success' => 'Hotlink protection settings were changed.',

    'Odbc.add' => 'Add ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% created / %%allowed%% allowed.',
    'Odbc.limitExceeded' => 'The ODBC DSN Connection limit exceeded.',
    'Odbc.unlimited' => 'Unlimited',
    'Odbc.addTooltip' => 'Add ODBC data source.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Connection name',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Connection description',
    'Odbc.hostname' => 'Hostname',
    'Odbc.statusSystem' => 'It is a system DSN.',
    'Odbc.statusConfigured' => 'DSN is configured.',
    'Odbc.statusNotConfigured' => 'DSN is not configured.',
    'Odbc.noSelectionText' => 'Select one or more items to remove.',
    'Odbc.removeConfirmation' => 'Remove {count, plural, =1 {the {name} connection} other {# selected connections}}?',
    'Odbc.removeSuccess' => 'The selected connections were removed.',

    'DomainAliasSettings.title' => 'Domain Alias Settings',
    'DomainAliasSettings.updateSuccess' => 'The properties of the domain alias %%name%% were changed. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'The website settings will be applied in %%restartInterval%% minutes.',

    'Home.Backup.offStatus' => 'This is not a valid backup. Data cannot be restored from this file.',
    'Home.Backup.task-failedStatus' => 'The backup task failed.',
    'Home.Backup.activeSchedule' => 'Schedule: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Schedules: %%schedules%%',
    'Home.Backup.noSchedule' => "Backup schedule is not set",
    'Home.Backup.period_hourly' => 'Hourly %%schedule%%',
    'Home.Backup.period_daily' => 'Daily %%schedule%%',
    'Home.Backup.period_weekly' => 'Weekly %%schedule%%',
    'Home.Backup.period_monthly' => 'Monthly %%schedule%%',
    'Home.Backup.create' => 'Create a backup',
    'Home.Backup.schedule' => 'Schedule',
    'Home.ChangeLog.seeHistory' => 'See the Change History',
    'Home.CustomButtons.add' => 'Add custom button',
    'Home.CustomButtons.noButtons' => 'There are no custom buttons',
    'Home.Customization.title' => 'Dashboard',
    'Home.Customization.description' => 'Choose which options you would like to see',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Security',
    'Home.Customization.backup' => 'Last Server Backup',
    'Home.Customization.ipBan' => 'IP Address Banning',
    'Home.Customization.mailQueue' => 'Mail Queue',
    'Home.Customization.mySubscriptions' => 'My Subscriptions',
    'Home.Customization.overusedSubscriptions' => 'Subscriptions with Overuse',
    'Home.Customization.serverInfo' => 'Server Information',
    'Home.Customization.updates' => 'Plesk Updates',
    'Home.Customization.promo' => 'Promo',
    'Home.Customization.changeLog' => 'What\'s New',
    'Home.Customization.customButtons' => 'Custom Buttons',
    'Home.EmptyView.title' => 'Get the most out of your dashboard by choosing what options to see.',
    'Home.EmptyView.titleLocked' => 'The dashboard is locked by your service provider.',
    'Home.EmptyView.customize' => 'Customize',
    'Home.Extension.title' => 'Extension',
    'Home.IpBan.banned' => 'Banned',
    'Home.IpBan.trusted' => 'Trusted',
    'Home.IpBan.more' => 'See more',
    'Home.MailQueue.total' => 'Total',
    'Home.MailQueue.deferred' => 'Deferred',
    'Home.MailQueue.held' => 'Held',
    'Home.MailQueue.more' => 'See more',
    'Home.MailQueue.clean' => 'Clear mail queue',
    'Home.MailQueue.checkLogs' => 'Check logs',
    'Home.MailQueue.repair' => 'Repair',
    'Home.MailQueue.cleanConfirmQuestion' => 'Clear the mail queue?',
    'Home.MailQueue.cleanConfirmYes' => 'Yes',
    'Home.MailQueue.cleanConfirmNo' => 'No',
    'Home.MailQueue.queueCleaned' => 'The mail queue was successfully cleared.',
    'Home.MailQueue.Promo.title' => 'Access the delivery status and logs easily',
    'Home.MailQueue.Promo.link' => 'Try the new mail queue now',
    'Home.OverusedSubscriptions.empty' => 'No subscriptions with overuse found',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% of %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'See all with overuse: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Open in the list',
    'Home.PromoNewHomeView.title' => 'Welcome to new home page!',
    'Home.PromoNewHomeView.description' => 'If you face any problems with it, please share your feedback. It will help us a lot with further improvements.',
    'Home.PromoNewHomeView.feedback' => 'Share feedback',
    'Home.PromoNewHomeView.switch' => 'Switch back to "Home"',
    'Home.ServerInfo.hostname' => 'Hostname',
    'Home.ServerInfo.ipAddress' => 'IP address',
    'Home.ServerInfo.publicIpAddress' => 'Public IP address',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'Uptime',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# day} other {# days}} {hours, plural, one {# hour} other {# hours}} {minutes, plural, one {# minute} other {# minutes}}",
    'Home.ServerInfo.more' => 'See more',
    'Home.Subscriptions.add' => 'Add new',
    'Home.Subscriptions.empty' => 'Create subscriptions to host multiple websites in an isolated space on the server. %%link%%',
    'Home.Subscriptions.help' => 'Learn more',
    'Home.Updates.title' => 'Product Updates',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Update #%%patch%%',
    'Home.Updates.manageComponents' => 'Add or Remove Components',
    'Home.Updates.lastUpdated' => 'Last updated on %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Check for updates',
    'Home.Updates.enableAutoupdate' => 'Allow Automatic Updates',
    'Home.Updates.lastChecked' => 'Last check on %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% is available',
    'Home.Updates.installNewVersion' => 'Install Now',
    'Home.Updates.patchAvailable' => 'Minor updates are available',
    'Home.Updates.patchAvailableVersion' => 'Minor updates for %%currentVersion%% are available',
    'Home.Updates.installPatch' => 'Update Now',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Update for {package} is} other {Updates for {package} are}} available',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# package} other {# packages}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Update Now} other {Update All}}',
    'Home.Promo.Customize.title' => 'Make the dashboard your own!',
    'Home.Promo.Customize.content' => 'Your favorite features at your fingertips with the new customizable dashboard',
    'Home.Promo.Customize.action' => 'Customize',
    'Home.Promo.SwitchToPuv.title' => 'Do you know about interface views in Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'If you don\'t provide hosting services to your customers using service plans, you may want to try the interface that is more convenient for managing websites, their files, databases, email accounts, and web applications.',
    'Home.Promo.SwitchToPuv.action' => 'Try now',
    'Home.Status.error' => 'Error',
    'Home.Status.warning' => 'Warning',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Hosting Settings',
    'HostingSettings.updateSuccess' => 'The settings were updated.',
    'HostingSettings.emptyLogin' => 'You need to specify a username.',
    'HostingSettings.emptyPassword' => 'You need to specify a password.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP server does not support IPv6. Allocate at least one IPv4 address, otherwise the user will not be able to upload files to the server over FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domain settings',
    'HostingSettings.domainSettingsSection.domainName' => 'Domain name',
    'HostingSettings.domainSettingsSection.description' => 'For example, example.com ',

    'HostingSettings.submitPopover.title' => 'Remove the content of %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Switching the "Website" hosting type to "%%type%%" will permanently remove the entire website\'s content, including the following directories:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Do you want to change the hosting type for your website?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'To access more settings, enter the system user credentials, and then click "Create Webspace".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'To access more settings, click "Next" to create hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hosting type',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Type',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Website',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Forwarding',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'No web hosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Use the domain\'s DNS zone for having mailboxes under this domain name',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'The path to the website home directory',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Preferred domain',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Visitors will be redirected here via a SEO friendly HTTP 301 redirect.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Forward visitors to',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Forwarding type',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Moved permanently (code 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirect website visitors to another site and show them the destination address. Such redirection will keep the site\'s search ranking',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Moved temporarily (code 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirect website visitors to a temporary site copy when you do not want search engines to index this temporary site.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame forwarding',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirect website visitors to another site, but do not show them the destination address, so they do not know about the redirection.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Preferred domain',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'None',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Document root',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'It is impossible to change document root because there are web applications installed on this website.',
    'HostingSettings.domainSettingsSection.save' => 'Save',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Compatibility mode',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Run the website in compatibility mode for the legacy "Separate SSL/TLS and non-SSL/TLS content" option',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'This website is working in compatibility mode and you cannot manage it using the Plesk interface. This is because you used the deprecated “Separate SSL/TLS and non-SSL/TLS content” option before the upgrade. Starting from Plesk 11, a website stores its content available over HTTP and HTTPS connections in the same directory. We do recommend that you move all the data from the `httpsdocs/` directory to `httpdocs/`, and then turn compatibility mode off. That will also make apps installed in the `httpsdocs/` directory accessible over the Internet. Pay attention that you will not be able to turn compatibility mode on again.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Change this setting?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Changing this setting contradicts the server\'s security policy, and may hurt performance or make the server vulnerable to attacks.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Change',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Revert',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Secure settings preset is applied',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'For improved security, apply the secure settings preset. Note that certain permissions allow subscribers to modify these settings.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Apply secure preset',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Learn about secure hosting settings',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS support',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Enabled',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Encrypt connections between the website and the visitor\'s browser.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificate',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'To enable HTTPS, upload an SSL/TLS certificate to the domain\'s repository, then select it here.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirect visitors from HTTP to HTTPS via a SEO friendly 301 redirect',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'There are no SSL/TLS certificates in your repository. To add a certificate, go to %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'this page',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (other repository)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Not selected',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Select which programming and scripting languages must be interpreted by the web server.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin directory is located in %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Use SSI for *.htm, *.html files',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET version',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Custom error documents',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin directory is located in',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'the document root of this domain',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'the root directory of webspace',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'the old-style root of this domain',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Custom error documents',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Additional write/modify permissions',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Web Deploy publishing',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Web statistics',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Tool',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Protect access to your web statistics with your FTP username and password',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Disabled',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webspace settings',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP addresses',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Disk space quota',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Enabled',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Forbid operations on website\'s files if the disk space quota set in subscription settings (if any) is exceeded.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'The hard disk quota is not supported because of the server\'s file system configuration.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'System user\'s credentials',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Manage website\'s files and folders via FTP or File Manager. Access the server via SSH if permitted.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Manage website\'s files and folders via FTP or File Manager. Access the server via Remote Desktop if permitted.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Username',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Password',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Specify a new password here to change the system user\'s password.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH access',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Remote Desktop access',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Enabled',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Access the server with the system user's credentials.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Type',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Disabled',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'For {count, plural, other {# domains}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'The following settings are mutual for all {count, plural, other {# domains in the {name} webspace}}:',

    'OdbcAdd.title' => 'Add an ODBC DSN',
    'OdbcAdd.nameLabel' => 'Connection name',
    'OdbcAdd.descriptionLabel' => 'Connection description',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Create ODBC DSN',

    'OdbcEdit.title' => 'Set Up an ODBC Connection',
    'OdbcEdit.saveSuccess' => 'Connection settings were saved.',
    'OdbcEdit.test' => 'Test connection',
    'OdbcEdit.connectSuccess' => 'Connection successful.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Database file path',
    'OdbcEdit.excel.defaultdir.label' => 'Default data directory',
    'OdbcEdit.excel.fil.label' => 'Database version',
    'OdbcEdit.excel.maxbuffersize.label' => 'Max buffer size',
    'OdbcEdit.excel.pagetimeout.label' => 'Page timeout',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Database file path',
    'OdbcEdit.access.uid.label' => 'Login ID',
    'OdbcEdit.access.pwd.label' => 'Password',
    'OdbcEdit.access.pagetimeout.label' => 'Page timeout',
    'OdbcEdit.access.pagetimeout.description' => 'The period of time, in tenths of a second, that an unused page remains in the buffer. This option applies to all data sources that use the Microsoft Access driver.',
    'OdbcEdit.access.maxbuffersize.label' => 'Max buffer size',
    'OdbcEdit.access.maxbuffersize.description' => 'The size of the internal buffer, in KB, aligned on 256 KB boundary.',
    'OdbcEdit.access.readonly.label' => 'Read-only',
    'OdbcEdit.access.readonly.description' => 'Designates the database as read-only to prohibit any updates.',
    'OdbcEdit.access.exclusive.label' => 'Exclusive',
    'OdbcEdit.access.exclusive.description' => 'Designates the database as exclusive to prohibit shared updates.',
    'OdbcEdit.access.safetransactions.label' => 'Safe transactions',
    'OdbcEdit.access.safetransactions.description' => 'If set to 0 (the default setting), all transactions are committed immediately. If set to 1, all transactions are saved to disk only upon a commit operation, but performance is slightly degraded.',
    'OdbcEdit.access.threads.label' => 'Threads',
    'OdbcEdit.access.threads.description' => 'The number of background threads for the engine to use.',
    'OdbcEdit.access.maxscanrows.label' => 'Max rows to scan',
    'OdbcEdit.access.maxscanrows.description' => 'The number of rows to be scanned when setting a column\'s data type based on existing data.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Specifies how changes made outside of a transaction are written to the database.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Specifies whether the MS Access driver will perform explicit user-defined transactions asynchronously.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Login ID',
    'OdbcEdit.mssql.pwd.label' => 'Password',
    'OdbcEdit.mssql.database.label' => 'Default database',
    'OdbcEdit.mssql.app.label' => 'Application name',
    'OdbcEdit.mssql.wsid.label' => 'Workstation ID',
    'OdbcEdit.mssql.language.label' => 'Default language',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversion of extended characters to OEM values',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC driver',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'The host name of the MariaDB/MySQL server',
    'OdbcEdit.mysql.database.label' => 'Default database',
    'OdbcEdit.mysql.user.label' => 'Username',
    'OdbcEdit.mysql.user.description' => 'The username used for connecting to MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Password',
    'OdbcEdit.mysql.password.description' => 'The password for the user account on the server',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'The TCP/IP port to use if the server is not the local host',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Windows named pipe to connect to if the server is the local host',
    'OdbcEdit.mysql.option.label' => 'Option',
    'OdbcEdit.mysql.option.description' => 'Options that specify how MyODBC should work. See <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentation</a>',

    'ProtectedDirectoryList.add' => 'Add Protected Directory',
    'ProtectedDirectoryList.addTooltip' => 'Create protected directory.',
    'ProtectedDirectoryList.name' => 'Name',
    'ProtectedDirectoryList.realmTitle' => 'Title of the protected area',
    'ProtectedDirectoryList.noSelectionText' => 'Select one or more items to remove.',
    'ProtectedDirectoryList.edit' => 'Edit',
    'ProtectedDirectoryList.remove' => 'Remove Protection',
    'ProtectedDirectoryList.removeTooltip' => 'Remove protection from the selected directories.',
    'ProtectedDirectoryList.removeConfirmation' => 'This operation will result in removing protection from {count, plural, =1 {the {name} directory} other {# selected directories}}. {count, plural, =1 {This directory} other {The directories}} will become freely accessible to the Internet users.',
    'ProtectedDirectoryList.removeSuccess' => 'The selected directories were removed.',

    'ProtectedDirectoryAdd.title' => 'Create Protected Directory',
    'ProtectedDirectoryAdd.submit' => 'Create',
    'ProtectedDirectoryAdd.success' => 'Protected directory %%path%% was successfully created',

    'ProtectedDirectoryEdit.title' => 'Protected Directory Settings',
    'ProtectedDirectoryEdit.success' => 'Protected directory settings were changed',

    'ProtectedDirectoryUserAdd.title' => 'Create Protected Directory User',
    'ProtectedDirectoryUserAdd.subtitle' => 'Directory %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Username',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Password',
    'ProtectedDirectoryUserAdd.submit' => 'Create',
    'ProtectedDirectoryUserAdd.success' => 'The protected directory user %%login%% was created.',

    'ProtectedDirectoryUserPassword.title' => 'Password for the Protected Directory User',
    'ProtectedDirectoryUserPassword.subtitle' => 'User %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Password',
    'ProtectedDirectoryUserPassword.submit' => 'Save',
    'ProtectedDirectoryUserPassword.success' => 'The user\'s credentials were saved.',

    'SummaryReport.Layout.title' => 'Report Layout Properties',
    'SummaryReport.Layout.success' => 'Report layout %%name%% was updated.',
    'SummaryReport.Layouts.title' => 'Report Layouts',

    'SummaryReport.Layout.Add.title' => 'Create Report Layout',
    'SummaryReport.Layout.Add.success' => 'Report layout %%name%% was created.',

    'SummaryReport.Report.title' => 'Summary Report',
    'SummaryReport.Report.buttonLayouts' => 'Layouts',
    'SummaryReport.Report.buttonSchedule' => 'Schedule',
    'SummaryReport.Report.buttonProperties' => 'Properties',
    'SummaryReport.Report.buttonTrafficHistory' => 'Traffic History',
    'SummaryReport.Report.buttonPrint' => 'Print',
    'SummaryReport.Report.buttonSend' => 'Send By Email',
    'SummaryReport.Report.successSent' => 'The report was sent to %%email%%',

    'SummaryReport.Schedule.title' => 'Delivery Schedules for %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Delivery Schedule for %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Report delivery schedule was updated.',

    'SummaryReport.Schedule.Add.title' => 'Create Delivery Schedules for %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Report delivery schedule was created.',

    'SummaryReport.TrafficHistory.title' => 'Traffic History',

    'VirtualDirectory.errNotExist' => 'This virtual directory is linked to a physical folder that does not exist.',
    'VirtualDirectory.errNoPermissions' => 'You do not have permissions to view the contents of this directory.',
    'VirtualDirectory.buttonProperties' => 'Directory Properties',
    'VirtualDirectory.buttonPropertiesHint' => 'View and change virtual directory properties.',
    'VirtualDirectory.buttonPermissions' => 'Directory Access Permissions',
    'VirtualDirectory.buttonPermissionsHint' => 'Set up directory access permissions.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Configure ASP.NET settings.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Configure PHP settings.',
    'VirtualDirectory.tabBrowse' => 'Directories',
    'VirtualDirectory.tabBrowseHint' => 'Work with physical and virtual files and directories under the site %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'MIME Types',
    'VirtualDirectory.tabMimeTypesHint' => 'Manage registered MIME types.',
    'VirtualDirectory.tabErrorDocs' => 'Error Documents',
    'VirtualDirectory.tabErrorDocsHint' => 'Manage error documents.',
    'VirtualDirectory.tabProtection' => 'Protection',
    'VirtualDirectory.tabProtectionHint' => 'Restrict access to the directory with password protection.',

    'VirtualDirectory.errorDocType.default' => 'Default',
    'VirtualDirectory.errorDocType.file' => 'File',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'Create Directory',
    'VirtualDirectory.CreateDirectory.name' => 'Directory name',
    'VirtualDirectory.CreateDirectory.success' => 'The %%name%% directory was created.',
    'VirtualDirectory.CreateDirectory.errExists' => 'The %%name%% directory already exists.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Create Virtual Directory',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'The %%name%% directory was created.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Virtual Directory Properties',
    'VirtualDirectory.EditVirtualDirectory.success' => 'The virtual directory was edited.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Close',

    'VirtualDirectory.MimeTypeList.add' => 'Add MIME Type',
    'VirtualDirectory.MimeTypeList.edit' => 'Edit MIME Type',
    'VirtualDirectory.MimeTypeList.addHint' => 'Register a new MIME type.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Extension',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Content',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Select one or more items to remove.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Remove {count, plural, =1 {the selected MIME type} one {# selected MIME type} other {# selected MIME types}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'The selected MIME types were removed.',

    'VirtualDirectory.CreateMimeType.title' => 'Add MIME Type',
    'VirtualDirectory.CreateMimeType.success' => 'The new MIME type was registered.',

    'VirtualDirectory.EditMimeType.title' => 'Edit MIME Type',
    'VirtualDirectory.EditMimeType.success' => 'The MIME type was edited.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Error',
    'VirtualDirectory.ErrorDocList.columnName' => 'Description',
    'VirtualDirectory.ErrorDocList.columnType' => 'Type',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Location',
    'VirtualDirectory.ErrorDocList.edit' => 'Edit',

    'VirtualDirectory.EditErrorDoc.title' => 'Edit Error Document',
    'VirtualDirectory.EditErrorDoc.success' => 'The error document was edited.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Error',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Type',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Location',

    'VirtualDirectory.Protection.notSupported' => 'Directory protection is not supported for this directory because its name exceeds 245 characters or contains unsupported ones.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Virtual directory protection is disabled',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Protect',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'The directory %%path%% was protected.',
    'VirtualDirectory.Protection.tools' => 'Tools',
    'VirtualDirectory.Protection.removeProtection' => 'Remove protection',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Make the URL that corresponds to the directory accessible to all.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Remove protection from the virtual directory? This will also remove all protected directory users and directory protection settings.',
    'VirtualDirectory.Protection.settings' => 'Settings',
    'VirtualDirectory.Protection.settingsTooltip' => 'View the directory location and specify a title for the protected area.',

    'VirtualDirectory.AspDotNet.title' => 'Configure ASP.NET Settings',

    'VirtualDirectory.Php.title' => 'PHP version',
    'VirtualDirectory.Php.version' => 'Version',
    'VirtualDirectory.Php.success' => 'PHP version was updated.',


    'MassMailPage.sendEmail' => 'Send Mass Email',
    'MassMailPage.selectAtLeastOneTemplate' => 'Select at least one template',
    'MassMailPage.confirmRemoval' => 'Are you sure you want to remove the selected {count, select, 1 {template} other {templates}}?',
    'MassMailPage.remove' => 'Remove',
    'MassMailPage.filters' => 'Filters',
    'MassMailPage.name' => 'Template Name',
    'MassMailPage.sender' => 'Sender',
    'MassMailPage.recipients' => 'Recipients',
    'MassMailPage.subject' => 'Subject',
    'MassMailPage.created' => 'Creation Date',
    'MassMailPage.send' => 'Send',
    'MassMailPage.recipientsNone' => 'None',
    'MassMailPage.recipientsAdmins' => 'Administrator',
    'MassMailPage.recipientsResellers' => 'All resellers',
    'MassMailPage.recipientsResellersSelected' => 'Selected resellers',
    'MassMailPage.recipientsResellersExcept' => 'All resellers except selected',
    'MassMailPage.recipientsClients' => 'All customers',
    'MassMailPage.recipientsClientsSelected' => 'Selected customers',
    'MassMailPage.recipientsClientsExcept' => 'All customers except selected',
    'MassMailPage.templatesRemoved' => 'Removed {count, select, 1 {Template} other {Templates}}.',
    'MassMailPage.emptyViewTitle' => 'No mass email message templates',
    'MassMailPage.addNew' => 'Create template',
    'CreateMassMailTemplatePage.templateCreated' => 'The template was created.',
    'EditMassMailTemplatePage.templateUpdated' => 'The template was updated.',
    'SendMassMailPage.emailSent' => 'The email was sent.',
    'SendMassMailPage.fieldIsRequired' => 'The field cannot be empty',
    'SendMassMailPage.saveAsTemplate' => 'Save the composed message to a new template',
    'SendMassMailPage.newTemplateName' => 'New template name',
    'SendMassMailPage.selectedTemplate' => 'Selected template',
    'SendMassMailPage.send' => 'Send',
    'VirtualHostTemplatePage.name' => 'Name',
    'VirtualHostTemplatePage.sizeInBytes' => 'Size',
    'VirtualHostTemplatePage.modified' => 'Modification date',
    'VirtualHostTemplatePage.permissions' => 'Permissions',
    'VirtualHostTemplatePage.user' => 'User',
    'VirtualHostTemplatePage.group' => 'Group',
    'VirtualHostTemplatePage.uploadTemplate' => 'Upload',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'The template was uploaded.',
    'VirtualHostTemplatePage.root' => 'Virtual Template directory',
    'VirtualHostTemplatePage.emptyViewTitle' => 'No files in template',
    'VirtualHostTemplatePage.total' => 'Total items in directory {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Set default',
    'VirtualHostTemplatePage.successfullyReset' => 'The template was changed to default.',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Domain name',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Owner's name",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Used',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Limit',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Available',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Used (in %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'My domains only',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Owner Name',
];
