<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Access denied. Your account was suspended.",
    'login_up__login_has_been_locked' => "You have attempted to log in using a wrong password too many times. For security reasons, you will not be able to log in under this username for some time.",
    'login_up__unable_to_check_pass' => "Unable to check password: %1",
    'login_up__warning_limits_licence_key' => "One of the following items has exceeded the limit defined by your license key: number of user accounts, domains, mail accounts or web users hosted on your server.\nPlease contact Plesk sales department in order to purchase a key that will allow you to host the desired number of users and domains. Please contact Plesk technical support department if you feel you have received this message by mistake.\nThe licensed limit for user accounts/domains/mail accounts/web users/language packs: %2.\nThe number of user accounts/domains/mail accounts/web users/language packs currently hosted: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "The amount of resources you operate with has exceeded the limits defined by your current product license. Please contact Plesk sales department and purchase a new license key.",
    'login_up__grace_period' => 'You are currently operating within the grace period of your product license. To update your product license, select the Retrieve Keys option on the %1License Information page%2.',
    'login_up__partner_license_message' => 'You are currently operating with a limited product license that requires registration prior to activating the full feature set. To update your product license, select the Retrieve Keys option on the %1License Information page%2.',
    'login_up__system_admin_disabled' => 'The superuser (root or administrator account) is forbidden to log in to Plesk for security reasons.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk Administrator's Guide",
    'plesk_guide_reseller' => "Plesk Reseller's Guide",
    'plesk_guide_client' => "Plesk Customer's Guide",
    'plesk_guide_domain_admin' => "Plesk Domain Administrator's Guide",
    'plesk_guide_mailuser' => "Plesk Email User's Guide",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Search', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Customers',
    'ui__reseller_unknown__quick-search' => 'Resellers',
    'ui__client/domain_unknown__quick-search' => 'Domains',
    'nav__general' => 'Main Menu',
    '__home' => 'Home',
    '__resellers' => 'Resellers',
    '__clients' => 'Customers',
    '__domains' => 'Domains',
    '__applications' => 'Applications',
    '__settings' => 'Settings',
    'nav__system' => 'System',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Up Level',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Remove',
    'bt_make_default' => 'Make Default',

    // common list object operation errors
    'class_cList__empty_selection' => 'No objects selected.',

    // common list object search keys
    'clist__search_show' => 'Show Search',
    'clist__search_hide' => 'Hide Search',

    'bt_show_all' => "Reset Search",

    // common object list info keys
    'clist__first' => 'First',
    'clist__last' => 'Last',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Pages',
    'clist__page_size' => 'Entries per page',
    'clist__info' => 'Total %1: %4',
    'clist__info_empty' => 'No %1',
    'clist__info_filter' => '%5 %1 found (%4 total)',
    'clist__info_paging' => '%2-%3 %1 of %4 total',
    'clist__info_paging_filter' => '%2-%3 %1 of %5 found (%4 total)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Active',
    '__object_off' => 'Suspended',

    '__home_description' => 'Back to Home page.',
    'indicator_title' => '%1% used, %2% free', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Invalid URL was requested.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Reseller Accounts",
    'ui__reseller_unknown__title' => "Reseller Accounts",
    'ui__reseller_unknown__description' => "Manage reseller accounts.",
    'ui__reseller/client_unknown__short-title' => 'Customer Accounts',
    'ui__reseller/client_unknown__title' => 'Customer Accounts',
    'ui__reseller/client_unknown__description' => 'Manage customer accounts.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Additional administrator accounts", // PFW
    'ui__admin-alias_unknown__short-title' => "Additional administrator accounts", // PFW
    'ui__admin-alias_unknown__description' => "View and manage additional administrator accounts.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Server-wide mail settings",
    'ui__server/mail__title' => "Server-wide mail settings",
    'ui__server/mail__description' => "Set up your mail server and configure server-wide mail settings.",
    'ui__server/dns__short-title' => 'DNS Settings',
    'ui__server/dns__title' => 'DNS Settings',
    'ui__server/dns__description' => 'Review and update server-wide DNS settings.',
    'ui__server/services__title' => 'Services Management',
    'ui__server/services__description' => 'Start, stop or restart Plesk services.',
    'ui__server/crontab/task_unknown__short-title' => 'Scheduled Tasks',
    'ui__server/crontab/task_unknown__title' => 'Scheduled Tasks',
    'ui__server/crontab/task_unknown__description' => 'Add and remove server-wide scheduled tasks.',
    'ui__server/ip-address_unknown__short-title' => 'IP addresses',
    'ui__server/ip-address_unknown__title' => 'IP addresses',
    'ui__server/ip-address_unknown__description' => 'View, add and remove IP addresses, assign IP addresses to resellers.',
    // dropdowns
    'ui__server/time__title' => 'System time',
    'ui__server/time__short-title' => 'System time',
    'ui__server/time__description' => 'Change system date and time, set up synchronization with an NTP server.',
    'ui__server/maillists__title' => 'Set up mailing lists server', // PFU
    'ui__server/maillists__short-title' => 'Set up mailing lists server', // PFU
    'ui__server/maillists__description' => 'Set up Mailman mailing lists server.', // PFU
    'ui__server/spam-filter__title' => 'Spam filter settings',
    'ui__server/spam-filter__short-title' => 'Spam filter settings',
    'ui__server/spam-filter__description' => 'Set up server-wide spam filter.',
    'ui__server/preferences__title' => "Server settings",
    'ui__server/preferences__short-title' => "Server settings",
    'ui__server/preferences__description' => "Set up server-wide statistics calculation, change server's host name and change other server settings.",

    // help & support
    // icons
    'ui__support__short-title' => 'Support',
    'ui__support__title' => 'Support',
    'ui__support__description' => 'Submit a request for technical support or review support tickets made by your customers.',
    'ui__license__short-title' => 'License Information',
    'ui__license__title' => 'Plesk License Information',
    'ui__license__description' => 'View information about your Plesk license and order new license keys.',
    'ui__help__short-title' => 'Help',
    'ui__help__title' => 'Online help',
    'ui__help__description' => 'View online help.',
    'ui__news__short-title' => "What's new",
    'ui__news__title' => "What's new",
    'ui__news__description' => "See the list of changes in this version of Plesk.",
    'ui__server/autoinstaller__short-title' => 'Updates',
    'ui__server/autoinstaller__title' => 'Updates',
    'ui__server/autoinstaller__description' => 'Update Plesk and its components.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domains',
    'ui__client/domain_unknown__title' => 'Domains',
    'ui__client/domain_unknown__description' => 'Manage domains.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Assign new owner for subscriptions',
    'ui__client/domain/chowner_multi-select__short-title' => 'Assign new subscription owner',
    'ui__client/domain/chowner_multi-select__description' => 'Assign new owner for selected subscriptions',
    'ui__client/domain/disable_multi__title' => 'Suspend domains',
    'ui__client/domain/disable_multi__short-title' => 'Suspend domains',
    'ui__client/domain/disable_multi__description' => 'Suspend selected domains',
    'ui__client/domain/enable_multi__title' => 'Activate domains',
    'ui__client/domain/enable_multi__short-title' => 'Activate domains',
    'ui__client/domain/enable_multi__description' => 'Activate selected domains',

    // icons
    'ui__admin/extras-domain__short-title' => 'Tools from MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Tools from MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__server/sitebuilder__short-title' => 'Presence Builder settings', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder settings', // PFU
    'ui__server/sitebuilder__description' => 'Set up Presence Builder for editing websites hosted on this server.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Register Domain',
    'ui__admin/register-domain__short-title' => 'Register Domain',
    'ui__admin/register-domain__description' => 'Register a domain name through MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Manage Domain',
    'ui__admin/manage-domain__short-title' => 'Manage Domain',
    'ui__admin/manage-domain__description' => 'Manage registered domain names through MyPlesk.com.',
    'ui__server/register__title' => 'Register your server',
    'ui__server/register__short-title' => 'Register server',
    'ui__server/register__description' => 'Register your server to join an affiliate program',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Action log',
    'ui__actionlog__title' => 'Action log',
    'ui__actionlog__description' => 'Download action log and manage action log settings.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Server Information',
    'ui__server/statistics__title' => 'Server Information',
    'ui__server/statistics__description' => 'Statistics on the services managed by Plesk.',
    'ui__admin/report__title' => 'Summary Report',
    'ui__admin/report__short-title' => 'Summary Report',
    'ui__admin/report__description' => 'View report on usage of traffic and resources for resellers, customers and domains.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Session Idle Time',
    'ui__sessions/properties__title' => 'Session Idle Time',
    'ui__sessions/properties__description' => 'Set session idle time for Plesk sessions.',
    'ui__cp-access__short-title' => 'Access to Plesk',
    'ui__cp-access__title' => 'Access to Plesk',
    'ui__cp-access__description' => 'Restrict access to Plesk.',
    'ui__sessions__short-title' => 'Active Sessions',
    'ui__sessions__title' => 'Active Sessions',
    'ui__sessions__description' => 'View active Plesk sessions.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS Certificates',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS Certificates',
    'ui__server/certificate_unknown__description' => 'The list of SSL/TLS certificates.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Personal Data',
    'ui__admin-info__title' => 'Personal Data',
    'ui__admin-info__description' => 'Change personal data for your account.',
    'ui__admin-password__short-title' => 'Change password',
    'ui__admin-password__title' => 'Change password',
    'ui__admin-password__description' => 'Change password for your account.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Resource Usage',
    'ui__reseller/limits__title' => 'Resource Usage',
    'ui__reseller/limits__description' => 'View and manage resource usage of reseller %1.',
    'ui__reseller/limits_unknown__short-title' => 'Resource Usage',
    'ui__reseller/limits_unknown__title' => 'Resource Usage',
    'ui__reseller/limits_unknown__description' => 'View and manage resource usage of reseller.',
    'ui__reseller/limits_self__short-title' => 'Resource Usage',
    'ui__reseller/limits_self__title' => 'Resource Usage',
    'ui__reseller/limits_self__description' => "View and manage your resource usage.",
    'ui__reseller/limits_readonly-self__short-title' => 'Resource Usage',
    'ui__reseller/limits_readonly-self__title' => 'Resource Usage',
    'ui__reseller/limits_readonly-self__description' => "View your resource usage.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Traffic Usage by Customers',
    'ui__reseller/client/traffic_unknown__title' => 'View Traffic Usage by Customers',
    'ui__reseller/client/traffic_unknown__description' => 'View traffic usage reports for customer accounts.',
    'ui__client/traffic_unknown__short-title' => "Traffic Usage by Customers", // temporary for presets
    'ui__client/traffic_unknown__title' => "View traffic usage by customers", // temporary for presets
    'ui__client/traffic_unknown__description' => "View traffic usage reports for customer accounts.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Log Manager',
    'ui__client/domain/hosting/logs_unknown__title' => 'Log Manager',
    'ui__client/domain/hosting/logs_unknown__description' => 'View logs and configure log rotation.',
    // dropdowns
    'ui__reseller/report__title' => 'Summary report',
    'ui__reseller/report__short-title' => 'Summary report',
    'ui__reseller/report__description' => 'View report on usage of traffic and resources for this reseller.',
    'ui__reseller/report_unknown__title' => 'Summary report',
    'ui__reseller/report_unknown__short-title' => 'Summary report',
    'ui__reseller/report_unknown__description' => 'View report on usage of traffic and resources for reseller.',
    'ui__reseller/report_self__title' => 'Summary report',
    'ui__reseller/report_self__short-title' => 'Summary report',
    'ui__reseller/report_self__description' => 'View report on your usage of traffic and resources.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk Branding',
    'ui__client/logo_reseller__short-title' => 'Plesk Branding',
    'ui__client/logo_reseller__description' => 'Rebrand Plesk for reseller %1.',
    'ui__client/logo_unknown__title' => 'Plesk Branding', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk Branding', // temporary for presets
    'ui__client/logo_unknown__description' => 'Rebrand Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk Branding',
    'ui__client/logo_self-reseller__short-title' => 'Plesk Branding',
    'ui__client/logo_self-reseller__description' => 'Rebrand your Plesk.',
    'ui__reseller/permissions__title' => 'Permissions',
    'ui__reseller/permissions__short-title' => 'Permissions',
    'ui__reseller/permissions__description' => "View or change the actions that reseller %1 can perform in Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Permissions',
    'ui__reseller/permissions_unknown__title' => 'Permissions',
    'ui__reseller/permissions_unknown__description' => "View or change the actions that reseller can perform in Plesk.",
    'ui__reseller/permissions_self__title' => 'Permissions',
    'ui__reseller/permissions_self__short-title' => 'Permissions',
    'ui__reseller/permissions_self__description' => 'View the list of actions you can perform in Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Permissions',
    'ui__reseller/permissions_readonly-self__short-title' => 'Permissions',
    'ui__reseller/permissions_readonly-self__description' => 'View the list of actions you can perform in Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Domain aliases',
    'ui__client/domain/domain-alias_unknown__title' => 'Domain aliases',
    'ui__client/domain/domain-alias_unknown__description' => 'View the list of alternative names for your domain.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS Settings',
    'ui__client/domain/dns_unknown__short-title' => 'DNS settings',
    'ui__client/domain/dns_unknown__description' => 'Manage DNS zone settings for a domain.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS settings',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS settings',
    'ui__client/domain/dns_readonly-unknown__description' => 'View DNS zone settings for a domain.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Tools from MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Tools from MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Tools from MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Tools from MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Tools from MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Tools from MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Register Domain',
    'ui__reseller/register-domain__title' => 'Register Domain',
    'ui__reseller/register-domain__description' => 'Register a domain name through MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Register Domain',
    'ui__reseller/register-domain_unknown__title' => 'Register Domain',
    'ui__reseller/register-domain_unknown__description' => 'Register a domain name through MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Register Domain',
    'ui__reseller/register-domain_self__title' => 'Register Domain',
    'ui__reseller/register-domain_self__description' => 'Register a domain name through MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Manage Domain',
    'ui__reseller/manage-domain__short-title' => 'Manage Domain',
    'ui__reseller/manage-domain__description' => 'Manage registered domain names through MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Manage Domain',
    'ui__reseller/manage-domain_unknown__short-title' => 'Manage Domain',
    'ui__reseller/manage-domain_unknown__description' => 'Manage registered domain names through MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Manage Domain',
    'ui__reseller/manage-domain_self__short-title' => 'Manage Domain',
    'ui__reseller/manage-domain_self__description' => 'Manage registered domain names through MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP addresses',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP addresses',
    'ui__client/ipaddress_unknown-reseller__description' => 'Manage IP addresses.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS certificates',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS certificates',
    'ui__client/domain/certificate_unknown__description' => 'Install and manage SSL/TLS certificates.',
    'ui__reseller/sessions__short-title' => 'Active Sessions',
    'ui__reseller/sessions__title' => 'Active Sessions',
    'ui__reseller/sessions__description' => 'View active Plesk sessions.',
    'ui__reseller/sessions_unknown__short-title' => 'Active Sessions',
    'ui__reseller/sessions_unknown__title' => 'Active Sessions',
    'ui__reseller/sessions_unknown__description' => 'View active Plesk sessions.',
    'ui__reseller/sessions_self__short-title' => 'Active Sessions',
    'ui__reseller/sessions_self__title' => 'Active Sessions',
    'ui__reseller/sessions_self__description' => 'View active Plesk sessions.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Mail Accounts Under the User Account %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS

    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Resource usage',
    'ui__client/limits__title' => 'Resource usage',
    'ui__client/limits__description' => "View and manage resource usage of customer %1.",
    'ui__client/limits_unknown__short-title' => 'Resource usage',
    'ui__client/limits_unknown__title' => 'Resource usage',
    'ui__client/limits_unknown__description' => 'View and manage resource usage of customer.',
    'ui__client/limits_readonly__short-title' => 'Resource usage',
    'ui__client/limits_readonly__title' => 'Resource usage',
    'ui__client/limits_readonly__description' => 'View resource usage of customer %1.',
    'ui__client/limits_self__short-title' => 'Resource usage',
    'ui__client/limits_self__title' => 'Resource usage',
    'ui__client/limits_self__description' => "View and manage your resource usage.",
    'ui__client/limits_readonly-self__short-title' => 'Resource usage',
    'ui__client/limits_readonly-self__title' => 'Resource usage',
    'ui__client/limits_readonly-self__description' => "View your resource usage.",
    'ui__client/domain/traffic_unknown__short-title' => "Traffic Usage by Domains %1",
    'ui__client/domain/traffic_unknown__title' => "View traffic usage by domains",
    'ui__client/domain/traffic_unknown__description' => "View traffic usage reports for domains.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Summary report',
    'ui__client/report__short-title' => 'Summary report',
    'ui__client/report__description' => 'View report on usage of traffic and resources for this customer.',
    'ui__client/report_unknown__short-title' => 'Summary report',
    'ui__client/report_unknown__title' => 'Summary report',
    'ui__client/report_unknown__description' => 'View report on usage of traffic and resources for customer.',
    'ui__client/report_self__short-title' => 'Summary report',
    'ui__client/report_self__title' => 'Summary report',
    'ui__client/report_self__description' => 'View report on usage of traffic and resources.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Interface preferences',
    'ui__client/preferences__title' => 'Interface preferences',
    'ui__client/preferences__description' => 'Set Plesk interface preferences for customer %1.',
    'ui__client/preferences_unknown__short-title' => 'Interface preferences',
    'ui__client/preferences_unknown__title' => 'Interface preferences',
    'ui__client/preferences_unknown__description' => "Set interface preferences for customer's Plesk.",
    'ui__client/preferences_self__short-title' => 'Interface preferences',
    'ui__client/preferences_self__title' => 'Interface preferences',
    'ui__client/preferences_self__description' => 'Set interface preferences for your Plesk.',
    'ui__client/logo__title' => 'Plesk Branding',
    'ui__client/logo__short-title' => 'Plesk Branding',
    'ui__client/logo__description' => "Rebrand the customer %1's Plesk.",
    'ui__client/logo_self__title' => 'Plesk Branding',
    'ui__client/logo_self__short-title' => 'Plesk Branding',
    'ui__client/logo_self__description' => 'Rebrand Plesk, changing the logo image and browser title bar.',
    'ui__client/permissions__title' => 'Permissions',
    'ui__client/permissions__short-title' => 'Permissions',
    'ui__client/permissions__description' => "View or change the actions that the customer %1 can perform in Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Permissions',
    'ui__client/permissions_unknown__title' => 'Permissions',
    'ui__client/permissions_unknown__description' => "View or change the actions that the customer can perform in Plesk.",
    'ui__client/permissions_self__title' => 'Permissions',
    'ui__client/permissions_self__short-title' => 'Permissions',
    'ui__client/permissions_self__description' => "View the list of actions you can perform in Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Permissions',
    'ui__client/permissions_readonly-self__short-title' => 'Permissions',
    'ui__client/permissions_readonly-self__description' => "View the list of actions you can perform in Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Tools from MyPlesk.com',
    'ui__client/extras-domain__title' => 'Tools from MyPlesk.com',
    'ui__client/extras-domain__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Tools from MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Tools from MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Tools from MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Tools from MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Get additional tools and services from MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Register Domain',
    'ui__client/register-domain__short-title' => 'Register Domain',
    'ui__client/register-domain__description' => 'Register a domain name through MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Register Domain',
    'ui__client/register-domain_unknown__short-title' => 'Register Domain',
    'ui__client/register-domain_unknown__description' => 'Register a domain name through MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Register Domain',
    'ui__client/register-domain_self__short-title' => 'Register Domain',
    'ui__client/register-domain_self__description' => 'Register a domain name through MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Manage Domain',
    'ui__client/manage-domain__short-title' => 'Manage Domain',
    'ui__client/manage-domain__description' => 'Manage registered domain names through MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Manage Domain',
    'ui__client/manage-domain_unknown__short-title' => 'Manage Domain',
    'ui__client/manage-domain_unknown__description' => 'Manage registered domain names through MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Manage Domain',
    'ui__client/manage-domain_self__short-title' => 'Manage Domain',
    'ui__client/manage-domain_self__description' => 'Manage registered domain names through MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP addresses',
    'ui__client/ipaddress_unknown__short-title' => "IP addresses",
    'ui__client/ipaddress_unknown__description' => "Manage IP addresses.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Domain aliases',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Domain aliases',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'View the list of alternative names for your domain.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Active Sessions',
    'ui__client/sessions__title' => 'Active Sessions',
    'ui__client/sessions__description' => 'View active Plesk sessions.',
    'ui__client/sessions_unknown__short-title' => 'Active Sessions',
    'ui__client/sessions_unknown__title' => 'Active Sessions',
    'ui__client/sessions_unknown__description' => 'View active Plesk sessions.',
    'ui__client/sessions_self__short-title' => 'Active Sessions',
    'ui__client/sessions_self__title' => 'Active Sessions',
    'ui__client/sessions_self__description' => 'View active Plesk sessions.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 Traffic usage',
    'ui__client/domain/traffic__title' => 'Data Transfer Statistics for <b>%1</b>',
    'ui__client/domain/traffic__description' => 'View data transfer statistics for the domain %1.',
    'ui__client/domain/traffic_self__short-title' => 'Traffic usage',
    'ui__client/domain/traffic_self__title' => 'View traffic usage for your domain',
    'ui__client/domain/traffic_self__description' => 'View traffic usage report for your domain.',
    'ui__client/domain/hosting/logs__short-title' => 'Log manager',
    'ui__client/domain/hosting/logs__title' => 'Log manager',
    'ui__client/domain/hosting/logs__description' => 'View logs and configure log rotation.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Log manager',
    'ui__client/domain/hosting/logs_self__title' => 'Log manager',
    'ui__client/domain/hosting/logs_self__description' => 'View logs and configure log rotation.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Rename domain',
    'ui__client/domain/rename__short-title' => 'Rename domain',
    'ui__client/domain/rename__description' => 'Rename domain %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Rename domain',
    'ui__client/domain/rename_unknown__title' => 'Rename domain',
    'ui__client/domain/rename_unknown__description' => 'Rename a domain',
    'ui__client/domain/chowner_select__title' => 'Assign new owner for domain',
    'ui__client/domain/chowner_select__short-title' => 'Assign new owner for subscription',
    'ui__client/domain/chowner_select__description' => 'Assign new owner for the subscription',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Assign New Owner for Subscription',
    'ui__client/domain/chowner_unknown-select__title' => 'Assign New Owner for Subscription',
    'ui__client/domain/chowner_unknown-select__description' => 'Assign new owner for a subscription.',
    'ui__client/domain/toggle__title' => 'Suspend or Activate Domain', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspend or Activate Domain', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspend or activate domain %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspend or Activate Domain', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspend or Activate Domain', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspend or activate a domain.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Activate Domain',
    'ui__client/domain/toggle_enable__short-title' => 'Activate Domain',
    'ui__client/domain/toggle_enable__description' => 'Activate domain %1.',
    'ui__client/domain/toggle_disable__title' => 'Suspend Domain',
    'ui__client/domain/toggle_disable__short-title' => 'Suspend Domain',
    'ui__client/domain/toggle_disable__description' => 'Suspend domain %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS Settings',
    'ui__client/domain/dns__short-title' => 'DNS Settings',
    'ui__client/domain/dns__description' => 'Manage DNS zone settings for domain %1.',
    'ui__client/domain/dns_self__title' => 'DNS Settings',
    'ui__client/domain/dns_self__short-title' => 'DNS Settings',
    'ui__client/domain/dns_self__description' => 'Manage DNS zone settings for your domain.',
    'ui__client/domain/dns_disabled__title' => 'DNS Settings',
    'ui__client/domain/dns_disabled__short-title' => 'DNS Settings',
    'ui__client/domain/dns_disabled__description' => 'Manage DNS zone settings for domain %1.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS Settings',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS Settings',
    'ui__client/domain/dns_self-disabled__description' => 'Manage DNS zone settings for your domain.',
    'ui__client/domain/dns_readonly__title' => 'DNS Settings',
    'ui__client/domain/dns_readonly__short-title' => 'DNS Settings',
    'ui__client/domain/dns_readonly__description' => 'View DNS zone settings for domain %1.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS Settings',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS Settings',
    'ui__client/domain/dns_readonly-self__description' => 'View DNS zone settings for your domain.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS Settings',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS Settings',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'View DNS zone settings for your domain.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS Settings',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS Settings',
    'ui__client/domain/dns_readonly-self-slave__description' => 'View DNS zone settings for your domain.',
    'ui__client/domain/dns_slave__title' => 'DNS Settings',
    'ui__client/domain/dns_slave__short-title' => 'DNS Settings',
    'ui__client/domain/dns_slave__description' => 'Manage DNS zone settings for domain %1.',
    'ui__client/domain/dns_self-slave__title' => 'DNS Settings',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS Settings',
    'ui__client/domain/dns_self-slave__description' => 'Manage DNS zone settings for your domain.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Tools from MyPlesk.com',
    'ui__client/domain/extras__title' => 'Tools from MyPlesk.com',
    'ui__client/domain/extras__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Tools from MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Tools from MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Get additional tools and services from MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Tools from MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Tools from MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Get additional tools and services from MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Register domain',
    'ui__client/domain/register__title' => 'Register domain',
    'ui__client/domain/register__description' => 'Register a domain name through MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Register domain',
    'ui__client/domain/register_unknown__title' => 'Register domain',
    'ui__client/domain/register_unknown__description' => 'Register a domain name through MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Register domain',
    'ui__client/domain/register_self__title' => 'Register domain',
    'ui__client/domain/register_self__description' => 'Register a domain name through MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Tools",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'View statistics',
    'ui__client/domain-summary-report_unknown__title' => 'View statistics',
    'ui__client/domain-summary-report_unknown__description' => 'View information about resource usage by domains.',
    'ui__client/domain-summary-report__short-title' => "View statistics",
    'ui__client/domain-summary-report__title' => "View statistics",
    'ui__client/domain-summary-report__description' => "View information about resource usage by domains.",
    'ui__client/domain-summary-report_self__short-title' => "View statistics",
    'ui__client/domain-summary-report_self__title' => "View statistics",
    'ui__client/domain-summary-report_self__description' => "View the information about resource usage by your domains.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domains", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'You have to select the domains which you want to remove',
    'ui__client/domain/chowner__empty_selection' => 'You have to select the domains which you want to assign to a new owner',

    // list objects filtering
    'domains_list__name__filter_title' => 'Name',
    'domains_list__state__filter_title' => 'Resource Usage',
    'domains_list__filter_state_any' => 'Any',
    'domains_list__filter_state_overuse' => 'Overuse',
    'domains_list__filter_state_normal' => 'Within limits',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Any',
    'domains_list__filter_status_blocked' => 'Suspended',
    'domains_list__filter_status_active' => 'Active',
    'domains_list__ownership__filter_title' => 'Ownership',
    'domains_list__filter_ownership_all' => 'All domains',
    'domains_list__filter_ownership_personal' => 'My domains only',
    'domains_list__filter_owner_pname__filter_title' => 'Owner Name',
    'domains_list__subrows__filter_title' => 'Show',
    'domains_list__subrows_off' => 'Domains only',
    'domains_list__subrows_subdomain_domainaliases' => 'With subdomains and aliases',
    'domains_list__subrows_subdomain' => 'With subdomains',
    'domains_list__subrows_domainaliases' => 'With aliases',

    // objects list
    'domains_list__owner__title' => 'Owner',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Browse for applications",
    'site_apps__promo_main_text' => "Application Packaging Standard (APS) catalog contains the list of applications that can be provisioned to a domain or web space. If you'd like to provision applications which are currently not in the catalog, you can easily do it by following APS packaging instructions on www.apsstandard.com",
    'site_apps__promo_download_now' => "Download Applications:",
    'site_apps__promo_close' => "Close this block",
    'site_apps__promo_preset__mostused' => '%1 Most Popular',
    'site_apps__promo_preset__lessused' => 'Next %1 Most Popular',
    'site_apps__promo_preset__all' => "All",
    'site_apps__promo_disclaimer_note' => 'Please note that applications installed from APS Catalog are provided by third parties and are not supported by Plesk.',
    'site_apps__promo_preset__page_title' => '%1 APS Applications',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Adding applications...',

    // Errors
    'site_apps__no_applications_for_update' => 'You have no applications installed in the Application Vault.',
    'site_apps__incorrect_download_preset_configuration' => 'Errors were found in the configuration of APS Catalog download preset.',
    'site_apps__aps_catalog_url_is_invalid' => 'Specified URL is not valid.',
    'site_apps__no_updates_at_the_moment' => 'There are no application updates available at the moment.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Incorrect information was received from the APS applications catalog. Please try again later.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS catalog settings were saved, but Plesk could not establish a connection to the APS catalog specified in APS catalog settings (%1). Make sure that APS catalog address is correct and APS catalog at this address is active.',
    'site_apps__cannot_retrieve_updates' => 'Cannot download application updates at the moment: unable to establish connection to the APS catalog (%1). Make sure that APS catalog address is correct and APS catalog at this address is active.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'There are no web applications available for installation.',
    'site_apps__site_applications_already_installed_in_root' => 'Other web applications are already installed in the root directories of these virtual hosts',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET web applications are not supported on Unix/Linux platform",
    'site_apps__server_wide_packages_not_supported' => 'Server-wide web applications are not supported',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 more web applications are scheduled for addition to the Application Vault.",
    'site_apps__applications_all_in_vault' => "Selected web applications are already present in the Application Vault.",
    'site_apps__applications_already_in_download_queue' => "%1 selected web applications are being added to the Application Vault at the moment.",
    'site_apps__applications_already_in_valut' => "%1 selected web applications are already in the Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Other (not categorized)',

    // Errors
    'site_apps__no_applications_in_category' => 'There are no available applications in this category. Please select another category.',
    'site_apps__no_category_selected__please_specify' => 'Select a category in the left menu. All applications available in the selected category will be listed in this window.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Administrator account',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'General',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Change hostname',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Security',
    'bt_setup_firewall' => 'Set up firewall',
    'bt_manage_firewall_rules' => 'Manage firewall rules',
    'cu_firewall__rule' => 'Create a firewall rule',
    'cu_firewall__protocol' => 'Set a protocol for the rule (\'tcp\' or \'udp\')',
    'cu_firewall__name' => "Set a rule name",
    'cu_firewall__disabled' => 'If \'true\', the rule is disabled after creation',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Select DNS server', // PFW
    'bt_soa_records_template' => 'SOA records template',
    'bt_restrict_creation_of_subzones' => 'Restrict creation of subzones',

    'databases' => 'Databases',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Applications',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Mail',
    'bt_select_mailserver' => 'Select mail server', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Select antivirus', // PFW
    'bt_virus_protection_settings' => 'Virus protection settings',
    'bt_select_spamfilter' => 'Select spam filter', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Select Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logs & statistics',
    'bt_server_statistics_settings' => 'Settings of server statistics',
    'bt_select_web_statistics' => 'Available web statistics software', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk interface',

    'components_and_modules' => 'Components & modules',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Set up Watchdog', // PFU
    'bt_setup_vpn' => 'Set up VPN', // PFU
    'bt_setup_samba' => 'Set up samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Settings',
    'ui__client/domain/settings_self__short-title' => 'Settings',
    'ui__client/domain/settings_self__description' => 'View and change domain settings.',

    'domain_administrator_account' => 'Domain administrator account',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Account settings',

    'domain' => 'Domain',
    'bt_dns_soa_records' => 'DNS SOA records',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Task scheduler settings',

    'website' => 'Website',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting for web users',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Select SSL/TLS certificate',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Web statistics',
    'bt_log_rotation_settings' => 'Log rotation settings',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limits", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Overuse and overselling policy",
    'limits__overuse_policy_legend' => "Overuse",
    'limits__oversell_policy_legend' => "Oversell",
    'limits__reseller_overuse_description' => "Overuse policy tells Plesk what to do when resources are overused.",
    'limits__overuse_text' => "Overuse policy",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Disk space and traffic',
    'limit__disk_space' => 'Disk space',
    'limit__max_traffic' => 'Traffic',
    'limit_group__client' => 'Customers',
    'limit__max_cl' => 'Customers',
    'limit_group__domain' => 'Domains',
    'limit__max_dom' => 'Domains',
    'limit__max_dom_powerUser' => 'Subscriptions',
    'limit__max_subdom' => 'Subdomains',
    'limit__max_dom_aliases' => 'Domain aliases',
    'limit__max_wu' => 'Web users',
    'limit__max_subftp_users' => 'Additional FTP accounts', // PFW
    'limit_group__mail' => 'Mail',
    'limit__max_box' => 'Mailboxes',
    'limit__mbox_quota' => 'Mailbox size',
    'limit__total_mboxes_quota' => 'Total mailboxes quota', // PFW
    'limit__max_maillists' => 'Mailing lists',
    'limit_group__database' => 'Databases',
    'limit__max_mssql_db' => 'Microsoft SQL Server databases', // PFW
    'limit__mssql_dbase_space' => 'Total MS SQL databases quota', // PFW
    'limit__max_odbc' => 'ODBC connections', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MariaDB/MySQL databases quota', // PFW
    'limit__pgsql_dbase_space' => 'PostgreSQL databases quota', // PFW
    'limit_group__application' => 'Applications',
    'limit__max_iis_app_pools' => 'IIS application pools', // PFW
    'limit_group__security' => 'Security',
    'limit_group__validity' => 'Expiration date',
    'limit__expiration' => 'Expiration date',
    'limit__validity' => 'Validity period',
    'limit__max_site_builder' => 'Sites published with Presence Builder',
    'limit__max_site' => 'Domains',
    'limit__mssql_dbase_filesize' => 'MS SQL database file size',
    'limit__mssql_dbase_log_filesize' => 'MS SQL database log file size',
    'limit__mssql_dbase_filesize_hint' => 'The maximum size of a file of a Microsoft SQL database.',
    'limit__mssql_dbase_log_filesize_hint' => 'The maximum size of a log file of a Microsoft SQL database.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Invalid domains limit. Minimum value is 1.',

    'property__has_wrong_value' => 'The property %1 has a wrong value.',
    'property__name_outgoing_messages_domain_limit' => 'Sets the limit on outgoing messages from a domain (per hour). To set the Unlimited value, specify "-1". Specify "default" to set the value specified in server-wide settings.',
    'property__name_outgoing_messages_mbox_limit' => 'Sets the limit on outgoing messages from a mailbox (per hour). To set the Unlimited value, specify "-1". Specify "default" to set the value specified in server-wide settings.',
    'property__name_outgoing_messages_subscription_limit' => 'Sets the limit on outgoing messages from a subscription (per hour). To set the Unlimited value, specify "-1". Specify "default" to set the value specified in server-wide settings.',

    // for CLI report & email notifications
    '__resource_notify' => 'Notify',
    '__general' => 'General',
    '__template_shared' => 'Shared template',
    'limit__overuse' => 'Overuse policy',
    'limit__max_traffic_soft' => 'Notify when traffic usage is reaching',
    'limit__disk_space_soft' => 'Notify when disk space usage is reaching',
    '__overuse' => 'Overuse policy',
    'performance__title' => 'Performance',
    'performance__bandwidth' => 'Maximum bandwidth usage (KB/s)',
    'performance__max_connections' => 'Connections limited to',

    'gch__hosting_php_isapi' => 'Run PHP as ISAPI extension',
    'gch__hosting_ssi_html' => 'Use SSI for *.htm, *.html files',
    'gch__hosting_php_handler_type' => 'run PHP as',
    'gch__hosting_php_handler_id' => 'run PHP as',
    'gch__hosting_php_served_by_nginx' => 'PHP served by nginx',
    'gch__hosting_unpaid_website_status' => 'Status of websites in suspended subscriptions',
    'gch__mn_no_autoresponder' => 'There are no auto-replies set up for the mail account.',
    'gch__no_clients_selected' => "No customer accounts selected",
    'gch__no_domains_selected' => "No domains selected",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/month",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Resource name',
    '__resource_usage' => 'Used',
    '__resource_limit' => 'Limit',

    '__used' => 'Used',
    '__limit' => 'Limit',

    '__never_expires' => 'Never expires',
    '__resource_free' => '%1 free of %2',
    '__resource_unlimited' => '%1 used of Unlimited',

    '__unlimited' => 'Unlimited',
    '__increment' => "Increase (+)",
    '__decrement' => "Decrease (-)",
    '__pt' => 'units',
    '__procent' => '%',
    '__overused' => 'Overused',
    '__left' => 'left',
    '__available' => 'available',
    '__not_available' => 'Not included',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Delivery Schedule',
    'ui__admin/report/layout/auto_unknown__title' => 'Report Delivery Schedule',
    'ui__admin/report/layout/auto_unknown__description' => 'Choose report delivery schedule for a report layout.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Add Report Delivery Schedule',
    'ui__admin/report/layout/auto/properties_new__title' => 'Add Report Delivery Schedule',
    'ui__admin/report/layout/auto/properties_new__description' => 'Add a report delivery schedule for report %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Report Delivery Schedule',
    'ui__admin/report/layout/auto/properties__title' => 'Report Delivery Schedule',
    'ui__admin/report/layout/auto/properties__description' => 'View and modify properties of report delivery schedule.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Remove Report Delivery Schedule',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Remove Report Delivery Schedule',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Remove selected report delivery schedules.',

    'ui__admin/report/layout_unknown__short-title' => 'Report Layouts',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'View Traffic Usage for <b>%1</b>',
    'ui__reseller/traffic__description' => 'View traffic usage reports for reseller account %1.',
    'ui__reseller/traffic_self__short-title' => 'My',
    'ui__reseller/traffic_self__title' => 'View Traffic Usage by Customers',
    'ui__reseller/traffic_self__description' => 'View traffic usage reports for your customer accounts.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Reseller name', // reseller report
    'report__full_client_name' => 'Customer name', // customer report
    'report__full_domain_name' => 'Domain name', // domain report
    'report__full_owner' => 'Owner', // customer & domain reports
    'report__full_creation_date' => 'Creation date',
    'report__full_size' => 'Size',
    'report__full_traffic' => 'Traffic',
    'report__full_active_clients' => 'Active customers', // reseller report
    'report__full_clients' => 'Customers', // reseller report
    'report__full_active_domains' => 'Active domains', // reseller & customer reports
    'report__full_domains' => 'Domains', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'Disk space',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MariaDB/MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'General',
    'report__version' => 'Product version',
    'report__build' => 'Product build',
    'report__status' => 'Status',
    'report__company_name' => 'Company name',
    'report__personal_name' => 'Personal name',
    'report__login' => 'Username',
    'report__phone' => 'Phone',
    'report__fax' => 'Fax',
    'report__email' => 'Email',
    'report__address' => 'Address',
    'report__city' => 'City',
    'report__state' => 'State/province',
    'report__zip_code' => 'Postal/ZIP code',
    'report__country' => 'Country',
    'report__creation_date' => 'Creation date',
    'report__expiration_date' => 'Expiration date',
    'report__dumps_total_size' => 'Total backup files size',
    'report__section_resellers' => 'Resellers',
    'report__active_resellers' => 'Resellers with active subscriptions',
    'report__resellers' => 'Resellers',
    'report__section_full_resellers' => 'Resellers',
    'report__section_clients' => 'Customers',
    'report__active_clients' => 'Customers with active subscriptions',
    'report__clients' => 'Customers',
    'report__section_full_clients' => 'Customers',
    'report__section_personal_clients' => 'Own customers',
    'report__active_personal_clients' => 'Your own customers with active subscriptions',
    'report__personal_clients' => 'Own customers',
    'report__section_full_personal_clients' => 'Own customers',
    'report__section_domains' => 'Domains',
    'report__disk_usage' => 'Disk usage',
    'report__traffic' => 'Traffic',
    'report__active_domains' => 'Active domains',
    'report__domains' => 'Domains',
    'report__subdomains' => 'Subdomains',
    'report__mboxes' => 'Mailboxes',
    'report__mail_groups' => 'Mail forwardings',
    'report__mail_autoresp' => 'Auto-replies',
    'report__mail_lists' => 'Mailing lists',
    'report__web_users' => 'Web users',
    'report__mysql_databases' => 'MariaDB/MySQL databases',
    'report__mssql_databases' => 'MSSQL databases',
    'report__pgsql_databases' => 'PostgreSQL databases',
    'report__section_full_domains' => 'Domains',
    'report__section_personal_domains' => 'Personal domains',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Personal domains',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Sites published with Presence Builder',
    'report__invalid_email' => 'Please specify a valid email address.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Web Users',
    'report__section_mailnames' => 'Mail Accounts',
    'report__section_maillists' => 'Mailing Lists',
    'report__section_databases' => 'Databases',
    'report__section_siteapps' => 'Web Applications',
    'report__section_aspnetapps' => 'ASP.NET Applications', // PFW
    'report__owner_pname' => "Provider's personal name",
    'report__owner_login' => "Provider's username",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Delivery Schedule',
    'ui__reseller/report/layout/auto_unknown__title' => 'Report Delivery Schedule',
    'ui__reseller/report/layout/auto_unknown__description' => 'Choose report delivery schedule for a report layout.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Add Report Delivery Schedule',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Add Report Delivery Schedule',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Add a report delivery schedule for report %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Report Delivery Schedule',
    'ui__reseller/report/layout/auto/properties__title' => 'Report Delivery Schedule',
    'ui__reseller/report/layout/auto/properties__description' => 'View and modify properties of report delivery schedule.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Remove Report Delivery Schedule',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Remove Report Delivery Schedule',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Remove selected report delivery schedules.',

    'ui__reseller/report/layout_unknown__short-title' => 'Report Layouts',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'View Traffic Usage for <b>%1</b>',
    'ui__client/traffic__description' => 'View traffic usage reports for customer account %1.',
    'ui__client/traffic_self__short-title' => 'Traffic Usage',
    'ui__client/traffic_self__title' => 'Traffic Usage by Domains',
    'ui__client/traffic_self__description' => 'View traffic usage reports for your domains.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'The specified language pack is installed but not enabled in the system.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Delete Sessions',
    'ui__sessions/delete__title' => 'Delete Sessions',
    'ui__sessions/delete__description' => 'Delete selected sessions.',
    'ui__ftp-sessions__short-title' => 'FTP Sessions',
    'ui__ftp-sessions__title' => 'FTP Sessions',
    'ui__ftp-sessions__description' => 'View FTP sessions.',
    'ui__ftp-sessions/delete__short-title' => 'Delete FTP Sessions',
    'ui__ftp-sessions/delete__title' => 'Delete FTP Sessions',
    'ui__ftp-sessions/delete__description' => 'Delete selected FTP sessions.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Delete Sessions',
    'ui__reseller/sessions/delete__title' => 'Delete Sessions',
    'ui__reseller/sessions/delete__description' => 'Delete selected sessions.',
    'ui__reseller/sessions/delete_self__short-title' => 'Delete Sessions',
    'ui__reseller/sessions/delete_self__title' => 'Delete Sessions',
    'ui__reseller/sessions/delete_self__description' => 'Delete selected sessions.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP Sessions',
    'ui__reseller/ftp-sessions__title' => 'FTP Sessions',
    'ui__reseller/ftp-sessions__description' => 'View FTP sessions.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP Sessions',
    'ui__reseller/ftp-sessions_self__title' => 'FTP Sessions',
    'ui__reseller/ftp-sessions_self__description' => 'View FTP sessions.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Delete FTP Sessions',
    'ui__reseller/ftp-sessions/delete__title' => 'Delete FTP Sessions',
    'ui__reseller/ftp-sessions/delete__description' => 'Delete selected FTP sessions.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Delete FTP Sessions',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Delete FTP Sessions',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Delete selected FTP sessions.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Delete Sessions',
    'ui__client/sessions/delete__title' => 'Delete Sessions',
    'ui__client/sessions/delete__description' => 'Delete selected sessions.',
    'ui__client/sessions/delete_self__short-title' => 'Delete Sessions',
    'ui__client/sessions/delete_self__title' => 'Delete Sessions',
    'ui__client/sessions/delete_self__description' => 'Delete selected sessions.',

    // domain administrator

    'forgery_token_expired' => 'Session token has expired.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'The following reseller accounts will be converted to customer accounts',
    'downgradeResellers__downgrade' => 'Reseller accounts that will be converted',
    // controls
    'downgradeResellers__submit_downgrade' => 'Perform account conversion.',
    'downgradeResellers__cancel_downgrade' => 'Cancel account conversion.',
    'downgradeResellers__confirm' => 'Confirm conversion',
    'downgradeResellers__confirm_message' => 'Confirm the account conversion to proceed',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Select Customer Accounts',
    'upgradeClients__upgrade_clients' => 'The following customer accounts will be converted to reseller accounts',
    'upgradeClients__upgrade' => 'Customer accounts that will be converted',
    // controls
    'upgradeClients__submit_upgrade' => 'Perform account conversion.',
    'upgradeClients__cancel_upgrade' => 'Cancel account conversion.',
    'upgradeClients__confirm' => 'Confirm conversion',
    'upgradeClients__confirm_message' => 'Confirm the account conversion to proceed',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Unable to convert the account \'%1\' to a reseller account: \'%1\' is already a reseller.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'The following domain administrator accounts will be converted to customer accounts',
    'upgradeDomainUser__upgrade' => 'Domain administrator accounts that will be converted',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Perform account conversion.',
    'upgradeDomainUser__cancel_upgrade' => 'Cancel account conversion.',
    'upgradeDomainUser__confirm' => 'Confirm conversion',
    'upgradeDomainUser__confirm_message' => 'Confirm the account conversion to proceed',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Domain administrator accounts that cannot be converted',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'The following domain administrator accounts could not be converted to customer accounts:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Several domain administrator accounts could not be converted to customer accounts. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Domain administrator account does not exist',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "The domain should belong directly to the server administrator or a reseller.",
    'upgradeDomainUser__all_logins_already_used' => 'Unable to create an account for the resulting customer.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Domain administrator account was converted',
    'upgradeDomainUser__upgrade_notification_body' => 'Your domain administrator account was converted to a customer account with username \'%%login%%\' and password \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Select Customer Accounts',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'The selected reseller does not have the permission \'%1\', but some of the customers have this permission.',
    'clientOwnerChanger__application_not_allowed' => 'The application \'%1\' is not available to the selected reseller, but it is available to some of the customers.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Reassigning Selected Subscriptions',
    // errors
    'domain_chown__empty_selection' => 'You have to choose a new owner of selected domains',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maximum bandwidth usage (%1)',
    'hosting_performance__max_connection_label' => 'Connections limited to',
    'performance__invalid_value' => "Value is invalid. Should be in the range from %1 to %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Available webmail clients',
    'webmail__none' => 'None',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Server IP Pool',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'The database will not be restored: there is no appropriate database server',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Server backup.",
    '__default_backup_comment_reseller' => "Reseller account backup created by %1.",
    '__default_backup_comment_client' => "Customer account backup created by %1.",
    '__default_backup_comment_domain' => "Subscription backup created by %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "IP pool of the customer %1",
    'backup__ip_mapping__resellers_ip' => "IP pool of the reseller %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtual host',
    'backup__restore__object_plesk_admin' => 'Plesk administrator',
    'backup__restore__object_ftpuser' => 'FTP account',
    'backup__restore__object_frontpageuser' => 'Frontpage account',
    'backup__restore__object_webuser' => 'web user',
    'backup__restore__object_domain' => 'domain',
    'backup__restore__object_subdomain' => 'subdomain',
    'backup__restore__object_domainalias' => 'domain alias',
    'backup__restore__object_client' => 'customer',
    'backup__restore__object_reseller' => 'reseller',
    'backup__restore__object_autoresponder' => 'auto-reply',
    'backup__restore__object_mailalias' => 'mail alias',
    'backup__restore__object_database' => 'database',
    'backup__restore__object_mailname' => 'mail account',
    'backup__restore__object_db_user' => 'database user',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS certificate',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'The following resellers cannot be restored because they are converted to customers: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'The following customers cannot be restored because they are converted to resellers: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'The following customers cannot be restored because they are moved to another owner: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Insufficient disk space on the destination server to transfer all the selected subscriptions. Available: %1 MB. Required: %2 MB. Note that the required space is calculated as a sum of web, mail, and database contents of domains. The required space is calculated once a day and stored in cache, so the actual size of domains might differ from the calculated size. If you make sure that the selected domains do not occupy more space than available, you can proceed with transfer.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Please free disk space on the destination server.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Insufficient disk space on the source server to store temporary files for transfer. Available: %1 MB. Required: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Please free disk space on the source server.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Server information',

    'backup__restore__capability_not_installed_component_text' => 'The component %1 is not installed on the destination server. %1 will be unavailable for all restored objects.',
    'backup__restore__capability_not_installed_component_resolution' => 'Please install %1. Note that this may take a few minutes.',
    'backup__restore__capability_existing_sys_user_text' => 'A system user with the name %1 already exists on the destination server.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Please rename the existing system user on the destination server.',
    'backup__restore__capability_license_usage_text' => 'The following resource limits (defined by the license key) will be exceeded on the destination server after data transfer:',
    'backup__restore__capability_license_usage_resolution' => 'Please install on the destination server another license key that will provide the required amount of resources.',
    'backup__restore__capability_max_allowed_packet_text' => "The 'max_allowed_packet' parameter on the source database server is %1, which is bigger than on the destination server, where it is %2. Some database objects for the domains specified below might not be restored.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Please increase the 'max_allowed_packet' value on the destination database server.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Unable to transfer the PostgreSQL databases because the PostgreSQL version on the destination server is earlier than on the source server. The current version is %1, the required version is %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Please install the required version of PostgreSQL on the destination server.',
    'backup__restore__capability_db_server_connection_problems' => 'Unable to connect to the destination PostgreSQL database server. Databases will not be transferred unless you restore the connection.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Please check the connection settings on the destination database server.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'The component %1 is turned off on the destination server.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Please turn on %1 on the destination server.',
    'backup__restore__capability_not_configured_component_text' => 'The component %1 is not configured on the destination server.',
    'backup__restore__capability_not_configured_component_resolution' => 'Please configure %1 on the Tools & Settings page.',

    'backup__restore__capability_webmail_is_not_available' => 'The %1 webmail service is not available on the destination server. Instead, Plesk will use the following webmail service: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'To use the same webmail as on the source server, you should install it on this server.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'To use the same webmail as on the source server, you should install it on the destination server.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "The '%1' webmail is not available on the destination server. Instead, on the following subscriptions: %3, Plesk will use the following webmail service: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Please install the required webmail on the destination server.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Webmail settings',

    'backup__restore__capability_shell_is_not_available' => 'The shell %1 is not available on the destination server. One of the available shells will be used instead.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'To use the same shell as on the source server, you should turn on (in /etc/shells) or install it on the destination server.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'The destination DNS server does not support networks in the Transfer Restrictions Template. The records with network IP addresses in the DNS transfer restrictions will not be restored.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'The destination DNS server does not support networks in the Transfer Restrictions Template, but some subscriptions have networks in DNS transfer restrictions. The records with network IP addresses in the DNS transfer restrictions will not be restored.',

    'backup__restore__capability_wrong_php_handler_text' => 'The PHP handler %1 is not available on the destination server. Instead, Plesk will use the following PHP handler: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'To use the same PHP handler as on the source server, you should turn on or install it on the destination server.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'The PHP handler %1 is not available. Instead, Plesk will use %2 for the following service plans: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'The PHP handler %1 is not available. Instead, Plesk will use %2 for the following websites: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'The PHP handler %1 is not available. It will be unavailable for the following websites: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'The %1 %2 is not available on the destination server. The default version will be used instead.',
    'backup__restore__capability_wrong_component_version_resolution' => 'To use the same %1 as on the source server, you should turn on or install it on the destination server.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'The antivirus usage policy on the destination server does not allow personal (per email address) antivirus settings for outgoing mail. These settings will not be transferred.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'The antivirus usage policy on the destination server does not allow personal (per email address) antivirus settings for incoming mail. These settings will not be transferred.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'The antivirus usage policy on the destination server does not allow personal (per email address) antivirus settings. These settings will not be transferred.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "To transfer personal (per email address) antivirus settings, please turn on the corresponding options in Tools & Settings > Virus Protection Settings.",
    'backup__restore__capability_antivirus_not_active_text' => 'No antivirus software turned on. All the antivirus settings from the source server will not work until you select the antivirus software on the destination server.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Please select the antivirus software in Tools & Settings > Virus Protection Settings > Antivirus settings section.',

    'backup__restore__capability_antivirus_another_active_text' => 'The antivirus software %2 is not available on the destination server. %1 will be used instead.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'To use the same antivirus as on the source server, please install it and select it in Tools & Settings > Virus Protection Settings > Antivirus settings section.',
    'backup__restore__capability_not_available_sni_text' => 'SNI is not available on the destination server. The websites that have the same IP address will be unable to use individual SSL/TLS certificates.',
    'backup__restore__capability_not_available_sni_resolution' => "Please check that the operating system on the destination server supports SNI and the support for SNI is turned on in Plesk (the checkbox 'Turn on SNI support, which allows using individual SSL/TLS certificates on websites with the same IP address' in Tools & Settings > Server Settings).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Server settings',

    'backup__restore__capability_vhost_already_exists_text' => 'The website %1 cannot be transferred: a website with the same name already exists on the destination server.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Please rename or remove the website with the same name from the server.',
    'backup__restore__capability_removed_vhosts' => 'The following subscriptions will not be restored because they contain the domain names that already exist on the destination server: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'On the source server there are %3 different PHP handlers of the type %1 and version %2. Instead of them, one handler of the appropriate type and version will be used on the destination server. Note that PHP settings on the source and destination server may be different.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer does not support Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer does not support Python. Please install Python manually.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Mail server settings',

    'backup__restore__capability_ftps_disabled' => 'Using secure FTPS is allowed on the source server but prohibited on the target. User apps that use FTP might not work correctly.',
    'backup__restore__capability_ftps_required' => 'Using non-secure FTP is allowed on the source server but prohibited on the target. User apps that use FTP might not work correctly.',
    'backup__restore__capability_ftps_policy_resolution' => 'Change the Secure FTP policy in Tools & Settings > Security Policy.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabytes of data will be moved from the source server to destination in %2 hours.',
    'backup__restore__capability_too_much_download_time_resolution' => 'For a faster transfer, please check your network connection between the source and destination servers and resolve issues (if any).',
    'backup__restore__too_low_download_speed' => "less than 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'For a faster transfer, please check your network connection between the source and destination servers and resolve issues (if any).',
    'backup__restore__capability_zero_download_speed_text' => 'The minimum acceptable download speed is %1 MBps. The download speed between the source and destination servers is 0 MBps. This might be caused by the network connection issues. Transfer is not possible.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Please check your network connection between the source and destination servers and resolve issues.',
    'backup__restore__capability_too_slow_download_speed_text' => 'The minimum acceptable download speed is %2 MBps. The download speed between the source and destination server is %1 MBps. This might increase the transfer time. In your current environment, migration of %3 MB will take %4 hours.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'The minimum acceptable download speed is %2 MBps. The download speed between the source and destination server is %1 MBps. This might increase the transfer time.',

    'backup__restore__capability_remote_database_migration' => "The following domains are using remote databases: %1 ",
    'backup__restore__capability_remote_database_migration_resolution' => "Do not remove these domains from the source server after the transfer if the Plesk version on the source server is earlier than 11.5! Suspend them instead. If you remove the domains, the databases will be removed from the remote server. Note: The dump files of remote databases will be stored on the source server in the %1 directory.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Backup files of MySQL database servers earlier than 5.1 (%1) might not be restored on MySQL 5.1.x because MySQL 5.1.x handles Unicode characters differently.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Please read the related knowledge base article #136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP is not installed on the destination server.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Please install Courier-IMAP by using Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot is not installed on the destination server.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Please install Dovecot by using Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'The traffic statistics retention time in configurations of the following objects is less than the server-wide value on the destination server.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Please change the server-wide value for the statistics retention time on the destination server. Set this time equal to or less than the smallest value in the domains\' configurations.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'The traffic statistics retention time on some domains is less than the server-wide value (%1). The value will be changed to %1 for these domains.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'The time for keeping traffic statistics on some service plans is less than the server-wide value (%1). The value will be changed to %1 for these service plans.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Mapping of an exclusive IP address to a shared one will disable anonymous FTP and HTTPS (unless the SNI support is turned on).',

    'backup__restore__no_postgresql_commands_text' => 'The subscription uses a remote PostgreSQL database, and the temporary backup file of it cannot be generated because the pg_dump and psql commands are missing on the source server.',
    'backup__restore__no_postgresql_commands_resolution' => 'Please install any PostgreSQL client package that supports these commands.',
    'backup__restore__capability_apache_modules_disabled_text' => 'The following Apache modules are disabled on the destination server: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Please turn on these modules in Plesk to prevent some possible problems.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'The following Apache modules are not installed on the destination server: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Please install and turn on these modules in Plesk to prevent some possible problems.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Limitation of outgoing messages is not supported by your license. The corresponding configuration settings will not be transferred.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Please install on the destination server another license key that provides the required features.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Limitation of outgoing messages is turned off on the destination server. The corresponding configuration settings will not be transferred.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Please turn on limitation of outgoing messages on the destination server.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Server-Wide Mail Settings',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'The limitation of outgoing messages from a mailbox is not supported by the mail server that is used on the destination server. The value of this limit will not be transferred.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Please change the mail server to the same as that you use on the source server.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Server-Wide Mail Settings',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'The limitation of outgoing messages from a domain is not supported by the mail server which is used on the destination server. The value of this limit will not be transferred.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Please change the mail server to the same as that you use on the source server.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Server-Wide Mail Settings',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'The limitation of outgoing messages from a subscription is not supported by the mail server which is used on the destination server. The value of this limit will not be transferred.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Please change the mail server to the same as that you use on the source server.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Server-Wide Mail Settings',

    'bu_conflict_resolver_absent_phosting' => 'Unable to restore the specified files because physical hosting for restoring them does not exist. Please create a domain with physical hosting first and then start restoration of the backup again.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'The resellers data will not be restored because the resellers management is not supported.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'The ModSecurity component is not installed on the destination server.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Please install ModSecurity to keep web application firewall working for the transferred sites. Note that installation might take a few minutes.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Install ModSecurity if you want to transfer the settings of the web application firewall. Note that installation might take a few minutes.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'The ModSecurity component is not configured on the destination server.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configure ModSecurity if you want to keep web application firewall working for the transferred sites.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Web Application Firewall (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'The ModSecurity is switched off on the destination server.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Activate ModSecurity if you want to keep web application firewall working for the transferred sites.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Web Application Firewall (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'The ModSecurity component is not installed. Web application firewall settings will not be restored for the following objects: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Websites cannot be restored because they belong to the subscription %1 that is not found in Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'The component %1 is not installed on the destination server. The DNS service will be unavailable and DNS settings will be lost. All customers\' websites will be down.',
    'bu_conflict_resolver_dns_not_installed' => 'The DNS service is not installed. The DNS settings will not be restored for the following objects: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'The following subscriptions cannot be restored because they were moved to other owners: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'The following subscriptions cannot be restored because they were moved to other providers: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Unable to find the Web Presence Builder restoration utility to restore Web Presence Builder data. Web Presence Builder is probably not installed.',
    'backup__restore__capability_renamed_db' => 'The database name "%1" is already used by another subscription. The name of the restored database will be changed to "%2".',
    'backup__restore__capability_renamed_db_user' => 'The database user name "%1" is already used by another subscription. The name of the restored database user will be changed to "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer does not support Perl. Please install ActiveState Perl manually.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% served by Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% served by nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Resource Usage Conflicts',
    'backup__restore__hint_resource_usage_conflicts' => 'Resource usage conflicts occur when resource usage limits of the restored object are exceeded upon the restoration.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Allow overuse',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Restore object and allow it to use more resources than initially provided.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Do not restore',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Do not restore objects that have resource usage conflicts.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Configuration Conflicts',
    'backup__restore__hint_configuration_conflicts' => 'Configuration conflicts occur when the restored object has settings and web applications that are not available or are prohibited by the current server or object owner policy. For example, configuration conflicts will occur if restored mail accounts have individual spam filtering settings while current server-wide policy forbids mail accounts from having these settings.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatic',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Restore object and automatically switch on all conflicting configuration options that your permissions allow to manage.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Do not restore',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Do not restore objects that have configuration conflicts.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Dedicated IIS application pools are not allowed in the IIS application pool settings.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Please change your IIS application pool settings in Tools & Settings > IIS Application Pool > Global Settings.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Shared IIS application pools are not allowed in the IIS application pool settings.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Please change your IIS application pool settings in Tools & Settings > IIS Application Pool > Global Settings.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Short POP3/IMAP mail account names are not allowed on the destination server.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Short names for mail accounts will be unavailable after restoration of data.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Unable to open the log file.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Unable to restore the subscription %1:  it was removed from your account and you do not have the permission to create subscriptions. If you need to restore it, please contact your service provider.',

    'backup__error11' => 'Insufficient disk space for backup.',
    'backup__error3011' => 'Connection was refused: No programs are listening on the specified address and port.',
    'backup__error3012' => 'Connection timeout.',
    'backup__error3013' => 'Network is unreachable.',
    'backup__error3014' => 'No route to host.',
    'backup__error3015' => 'Connection failed.',
    'backup__error3016' => 'Unable to resolve the host name.',
    'backup__error3017' => 'Incorrect user name or password.',
    'backup__error3018' => 'SSH connection failed.',

    'backup__error3110' => 'Unable to connect to the remote migration agent: Connection to the host is not available.',
    'backup__error3111' => 'The migration agent is locked by a failed migration task or is used by another migration process. Please restart the migration agent on the source server.',
    'backup__error3112' => 'Connection to the host is not available or the migration agent is not running on the source host.',
    'backup__error3113' => 'Unable to deploy the migration agent to a Linux host. Please check the SSH connection to the source host.',
    'backup__error3114' => 'Unable to deploy the migration agent to a Linux host: SSH connection failed.',
    'backup__error3115' => 'Incorrect user name or password.',
    'backup__error3116' => 'The specified user does not have administrative privileges.',

    'dns_t__unable_to_remove_ns_record' => 'Unable to remove the NS record from the DNS template: Each DNS zone must have at least one NS record.',
    'dns__unsupported_server_zone_transfer' => 'Unable to transfer the Transfer Restrictions Template because of the server-wide DNS configuration: On the source server the following network addresses are allowed for zone transfer, but these addresses are prohibited by Microsoft DNS Server: %1',
    'dns__unsupported_domain_zone_transfer' => 'Unable to transfer the Transfer Restrictions Template because of the domains\' DNS configuration: On some domains the following network addresses are allowed for zone transfer, but these addresses are prohibited by Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Unable to access the shared temporary network directory for backup files. Please check the network directory, username, and password settings. Error: %1',

    'migration_select_exist_db_server' => 'Select the destination database server',

    'dbbackup__temp_dir_wrong_value' => 'The invalid value for the temporary directory was specified.',
    'dbbackup__network_temp_dir_wrong_value' => 'The invalid value for the temporary network directory was specified.',
    'dbbackup__server_backup_not_configured' => 'The database backup settings are not configured on the server.',
    'dbbackup__temp_dir' => 'Temporary directory',
    'dbbackup__temp_dir_hint' => 'The path to a physical folder on the remote server where the MS SQL server is located. The MS SQL server must be able to access this folder for reading and writing temporary backup files. For example, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'The path to the network share mapped to the physical folder specified above. Plesk will access the shared folder to download and upload backup files. For example, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'The username of a network user created on the remote server. For example, ServerName\UserName. The user must have access to the shared folder specified above.',
    'dbbackup__network_password_hint' => 'The network user\'s password',

    'dbbackup__success_import_without_dublicate_users' => 'The following users were not imported: %1. They already exist on the database server.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Compress log files",
    'log_rot__log_rot_status' => "Log rotation status",
    'log_rot__log_rot_period' => "Log rotation condition",
    'log_rot__log_rot_size' => "by size",
    'log_rot__log_rot_time' => "by time",
    'log_rot__logrotation_enable' => "Switch on log rotation",
    'log_rot__mail' => "Send processed log files to email",
    'log_rot__max_number_of_logfiles' => "Maximum number of log files",
    'log_rot__time_period' => "period",
    'log_rot__unable_turn_off' => 'Unable to turn off log rotation because it is forced on the server level',
    'log_rot__unable_set_period' => 'Unable to set the log rotation period different from \'daily\', because it is forced on the server level',
    'log_rot__unable_set_max_log_files' => 'Unable to set a maximum number of log files greater than the server-wide limit %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "A number expected: %1",
    'actionlog__incorrect_rotation' => "Invalid log rotation parameters specified: %1",
    'actionlog__unknown_rot_period' => "Unknown rotation period: %1",
    'actionlog__unknown_rot_type' => "Unknown rotation type: %1",
    'actionlog__session_preferences' => 'Session settings',
    'actionlog__nis2_delete_prohibited' => 'Removing log records is prohibited because of the NIS2 directive restrictions in effect.',
    'actionlog__nis2_forbidden_rot_type' => "The '%1' log rotation type cannot be used because of the NIS2 directive restrictions in effect.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Administrator information',
    'actionlog__admin_preferences' => "Administrator's preferences",
    'actionlog__service' => 'Service',
    'actionlog__ip_addr' => 'IP address',
    'actionlog__client' => 'Customer account',
    'actionlog__client_status' => 'Customer account status',
    'actionlog__client_preferences' => "Customer's interface preferences",
    'actionlog__client_ip_pool' => "Customer's IP pool",
    'actionlog__client_siteapp' => "Customer's web application pool",
    'actionlog__client_guid' => "Customer GUID",
    'actionlog__domain' => 'Default domain (the first domain added to a subscription)',
    'actionlog__domain_owner' => 'Subscription owner',
    'actionlog__domain_plan' => 'Service plan of subscription',
    'actionlog__domain_status' => 'Default domain, status',
    'actionlog__domain_dns' => 'Default domain, DNS zone',
    'actionlog__subdomain' => 'Subdomain of a default domain',
    'actionlog__domain_alias' => 'Default domain, alias',
    'actionlog__domain_alias_dns' => 'Default domain, alias DNS zone',
    'actionlog__site' => 'Domain',
    'actionlog__site_status' => 'Domain status',
    'actionlog__site_dns' => 'Domain DNS zone',
    'actionlog__site_guid' => 'Domain GUID',
    'actionlog__site_subdomain' => 'Subdomain',
    'actionlog__site_alias' => 'Domain alias',
    'actionlog__site_alias_dns' => 'Domain alias DNS zone',
    'actionlog__domain_limits' => 'Subscription limits',
    'actionlog__domain_limit_size' => 'Disk space limit for subscription',
    'actionlog__domain_limit_traffic' => 'Traffic limit for subscription',
    'actionlog__domain_limits_powerUser' => 'Subscription limits',
    'actionlog__domain_limit_size_powerUser' => 'Disk space limit for subscription',
    'actionlog__domain_limit_traffic_powerUser' => 'Traffic limit for subscription',
    'actionlog__domain_guid' => "Default domain, GUID",
    'actionlog__cp_user' => 'Plesk user',
    'actionlog__mailname' => 'Mail account',
    'actionlog__maillist' => 'Mailing list',
    'actionlog__phosting' => 'Hosting settings',
    'actionlog__forwarding' => 'Standard or frame forwarding hosting',
    'actionlog__webuser' => 'Web user account',
    'actionlog__site_application' => 'Web application',
    'actionlog__license' => 'License key',
    'actionlog__additional_license' => 'Additional license key',
    'actionlog__template_domain' => "Service plan of reseller",
    'actionlog__template_admin' => "Service plan of administrator",
    'actionlog__template_reseller' => 'Reseller plan',
    'actionlog__admin_alias' => 'Additional administrator account', // PFW
    'actionlog__ftpuser' => 'Additional FTP account', // PFW
    'actionlog__db_server' => 'Database server',
    'actionlog__db' => 'Database',
    'actionlog__db_user' => 'Database user account',
    'actionlog__client_sapppkg_pool' => "User's web application", // PFW, not used?
    'actionlog__remote_dns' => 'Remote DNS server status', // PFW
    'actionlog__reseller' => 'Reseller account',
    'actionlog__reseller_guid' => 'Reseller GUID',
    'actionlog__reseller_ip_pool' => "Reseller's IP pool",
    'actionlog__reseller_limit_size' => 'Disk space limit for reseller account',
    'actionlog__reseller_limit_traffic' => 'Traffic limit for reseller account',
    'actionlog__reseller_limits' => 'Reseller account limits',
    'actionlog__reseller_permissions' => 'Reseller permissions',
    'actionlog__reseller_preferences' => "Reseller's interface preferences",
    'actionlog__reseller_siteapp' => "Web applications in reseller's pool",
    'actionlog__reseller_status' => 'Reseller account status',
    'actionlog__health_status' => 'Server health status',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'reached',
    'actionlog__added' => 'added',
    'actionlog__removed' => 'removed',
    'actionlog__change' => 'changed',
    'actionlog__update' => 'updated',
    'actionlog__move' => 'moved',
    'actionlog__upgrade' => 'upgraded', // PFU?
    'actionlog__update_or_add' => 'updated or added',
    'actionlog__expired' => 'expired',
    'actionlog__create' => 'created',
    'actionlog__delete' => 'deleted',
    'actionlog__service_stop' => 'stopped',
    'actionlog__service_restart' => 'restarted',
    'actionlog__service_start' => 'started',
    'actionlog__login' => 'logged in',
    'actionlog__logout' => 'logged out',
    'actionlog__install' => 'installed',
    'actionlog__uninstall' => 'uninstalled',
    'actionlog__reconfigure' => 'reconfigured',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Password reset request',
    'actionlog__event_admin_update' => 'Administrator information updated',
    'actionlog__event_admin_preferences_update' => "Administrator's preferences updated",
    'actionlog__event_service_restart' => 'Service restarted',
    'actionlog__event_service_start' => 'Service started',
    'actionlog__event_service_stop' => 'Service stopped',
    'actionlog__event_ip_address_create' => 'IP address created',
    'actionlog__event_ip_address_delete' => 'IP address deleted',
    'actionlog__event_ip_address_update' => 'IP address updated',
    'actionlog__event_client_create' => 'Customer account created',
    'actionlog__event_client_delete' => 'Customer account deleted',
    'actionlog__event_client_update' => 'Customer account updated',
    'actionlog__event_client_status_update' => 'Customer account status updated',
    'actionlog__event_client_preferences_update' => "Customer's interface preferences updated",
    'actionlog__event_client_siteapp_added' => "Web application added to customer account's application pool",
    'actionlog__event_client_siteapp_removed' => "Web application removed from customer account's application pool",
    'actionlog__event_domain_limit_size_reached' => 'Disk space limit for subscription reached',
    'actionlog__event_domain_limit_traffic_reached' => 'Traffic limit for subscription reached',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Disk space limit for subscription reached',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Traffic limit for subscription reached',

    'actionlog__domain_limit_database' => 'Databases quota for subscription',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'MariaDB/MySQL databases quota for subscription reached',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'MariaDB/MySQL databases soft quota for subscription reached',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Microsoft SQL server databases quota for subscription reached',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Microsoft SQL server databases soft quota for subscription reached',
    'actionlog__event_plesk_component_upgrade' => 'Plesk component updated',
    'actionlog__event_plesk_component_install' => 'Plesk component installed',
    'actionlog__event_plesk_component_uninstall' => 'Plesk component uninstalled',
    'actionlog__event_domain_create' => 'Default domain (the first domain added to a subscription) created',
    'actionlog__event_domain_delete' => 'Default domain (the first domain added to a subscription) deleted',
    'actionlog__event_domain_update' => 'Default domain (the first domain added to a subscription) updated',
    'actionlog__event_domain_owner_change' => 'Subscription owner changed',
    'actionlog__event_domain_plan_change' => 'Service plan of subscription changed',
    'actionlog__event_domain_status_update' => 'Default domain, status updated',
    'actionlog__event_domain_dns_update' => 'Default domain, DNS zone updated',
    'actionlog__event_subdomain_create' => 'Subdomain of a default domain created',
    'actionlog__event_subdomain_delete' => 'Subdomain of a default domain deleted',
    'actionlog__event_subdomain_update' => 'Subdomain of a default domain updated',
    'actionlog__event_domain_alias_create' => 'Default domain, alias created',
    'actionlog__event_domain_alias_delete' => 'Default domain, alias deleted',
    'actionlog__event_domain_alias_update' => 'Default domain, alias updated',
    'actionlog__event_domain_limits_update' => 'Subscription limits updated',
    'actionlog__event_cp_user_login' => 'Plesk user logged in',
    'actionlog__event_cp_user_logout' => 'Plesk user logged out',
    'actionlog__event_mailname_create' => 'Mail account created',
    'actionlog__event_mailname_delete' => 'Mail account deleted',
    'actionlog__event_mailname_update' => 'Mail account updated',
    'actionlog__event_maillist_create' => 'Mailing list created',
    'actionlog__event_maillist_delete' => 'Mailing list deleted',
    'actionlog__event_maillist_update' => 'Mailing list updated',
    'actionlog__event_phys_hosting_create' => 'Physical hosting created',
    'actionlog__event_phys_hosting_delete' => 'Physical hosting deleted',
    'actionlog__event_phys_hosting_update' => 'Physical hosting updated',
    'actionlog__event_forwarding_create' => 'Standard or frame forwarding hosting created',
    'actionlog__event_forwarding_delete' => 'Standard or frame forwarding hosting deleted',
    'actionlog__event_forwarding_update' => 'Standard or frame forwarding hosting updated',
    'actionlog__event_webuser_create' => 'Web user account created',
    'actionlog__event_webuser_delete' => 'Web user account deleted',
    'actionlog__event_webuser_update' => 'Web user account updated',
    'actionlog__event_siteapp_install' => 'Web application installed',
    'actionlog__event_siteapp_reconfigure' => 'Web application reconfigured',
    'actionlog__event_siteapp_uninstall' => 'Web application uninstalled',
    'actionlog__event_license_update' => 'License key updated',
    'actionlog__event_admin_alias_create' => 'Additional administrator account created',
    'actionlog__event_admin_alias_delete' => 'Additional administrator account deleted',
    'actionlog__event_admin_alias_update' => 'Additional administrator account updated',
    'actionlog__event_ftpuser_create' => 'Additional FTP account created',
    'actionlog__event_ftpuser_update' => 'Additional FTP account updated',
    'actionlog__event_ftpuser_delete' => 'Additional FTP account deleted',
    'actionlog__event_template_domain_create' => "Service plan of reseller created",
    'actionlog__event_template_domain_update' => "Service plan of reseller updated",
    'actionlog__event_template_domain_delete' => "Service plan of reseller deleted",
    'actionlog__event_template_admin_create' => "Service plan of administrator created",
    'actionlog__event_template_admin_update' => "Service plan of administrator updated",
    'actionlog__event_template_admin_delete' => "Service plan of administrator deleted",
    'actionlog__event_database_server_create' => 'Database server created',
    'actionlog__event_database_server_update' => 'Database server updated',
    'actionlog__event_database_server_delete' => 'Database server deleted',
    'actionlog__event_remote_dns_status_update' => 'Remote DNS server status updated',
    'actionlog__event_session_preferences_update' => 'Session settings updated',
    'actionlog__event_domain_alias_dns_update' => 'Default domain, DNS zone of domain alias updated',
    'actionlog__event_domain_move' => 'Default domain moved to a new subscription',
    'actionlog__event_site_move' => 'Domain moved to a new subscription',
    'actionlog__event_site_subdomain_move' => 'Subdomain moved to a new subscription',
    'actionlog__event_subdomain_move' => 'Subdomain of a default domain moved to a new subscription',
    'actionlog__event_license_expired' => 'The Plesk license has expired',
    'actionlog__event_database_create' => 'Database created',
    'actionlog__event_database_delete' => 'Database removed',
    'actionlog__event_database_user_create' => 'Database user account created',
    'actionlog__event_database_user_update' => 'Database user account settings updated',
    'actionlog__event_database_user_delete' => 'Database user account removed',
    'actionlog__event_client_guid_update' => "Customer GUID updated",
    'actionlog__event_domain_guid_update' => 'Default domain, GUID updated',
    'actionlog__event_reseller_create' => 'Reseller account created',
    'actionlog__event_reseller_delete' => 'Reseller account deleted',
    'actionlog__event_reseller_update' => 'Reseller account updated',
    'actionlog__event_reseller_guid_update' => 'Reseller GUID updated',
    'actionlog__event_reseller_ip_pool_update' => "Reseller's IP pool updated",
    'actionlog__event_reseller_limit_size_reached' => 'Disk space limit for reseller account reached',
    'actionlog__event_reseller_limit_traffic_reached' => 'Traffic limit for reseller account reached',
    'actionlog__event_reseller_limits_update' => 'Reseller account limits updated',
    'actionlog__event_reseller_permissions_update' => 'Reseller account permissions updated',
    'actionlog__event_reseller_preferences_update' => "Reseller's interface preferences updated",
    'actionlog__event_reseller_siteapp_added' => "Application added to reseller account's application pool",
    'actionlog__event_reseller_siteapp_removed' => "Application removed from reseller account's application pool",
    'actionlog__event_reseller_status_update' => 'Reseller account status updated',
    'actionlog__event_template_reseller_create' => 'Reseller plan created',
    'actionlog__event_template_reseller_delete' => 'Reseller plan deleted',
    'actionlog__event_template_reseller_update' => 'Reseller plan updated',
    'actionlog__event_health_status_change' => 'Server health status changed',
    'actionlog__event_siteapp_upgrade' => 'Web app upgraded',
    'actionlog__event_extension_install' => 'Extension installed',
    'actionlog__event_extension_uninstall' => 'Extension uninstalled',
    'actionlog__event_extension_upgrade' => 'Extension upgraded',
    'actionlog__event_extension_status_update' => 'Extension status updated',
    'actionlog__event_additional_license_expired' => 'Additional license has expired',
    'actionlog__event_hostname_changed' => 'Server hostname changed',
    'actionlog__event_smb_user_create' => 'Additional user created',
    'actionlog__event_smb_user_delete' => 'Additional user deleted',
    'actionlog__event_smb_user_update' => 'Additional user updated',
    'actionlog__dns_record' => 'DNS Record',
    'actionlog__dns_zone' => 'DNS Zone',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "The Plesk API RPC is not installed on the remote host. Contact your service provider for assistance.",
    'rsession_no_account_errmsg' => "Unable to access the remote service under your account. The most common reason is that the service for your account is not activated yet. Please, wait for several minutes, and then try again. If you encounter this error again, contact your system administrator.",
    'rsession_no_domain_errmsg' => "Unable to access the remote service for this domain. The most common reason is that the service for this domain is not activated yet. Please, wait for several minutes, and then try again. If you encounter this error again, contact your system administrator.",
    'rsession_unknown_errmsg' => "The remote server has rejected the attempt to establish a session. Contact your system administrator for support. The error was: %1",
    'rsession_unknown2_errmsg' => "Unknown error while establishing a remote session. Most probably, the remote server does not answer properly or does not answer at all. Ask your system administrator to check for error details in the web server error log.",
    'rsession_no_connect_errmsg' => "Unable to access the remote service: connecting to remote session failed. Contact your system administrator for support.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Allow uploading to incoming directory",
    'anonftp__allow_create_dirs' => 'Allow creation of directories in the incoming directory',
    'anonftp__allow_download_incoming' => 'Allow downloading from the incoming directory',
    'anonftp__display_login' => 'Display login message',
    'anonftp__login_text' => 'Message text',
    'anonftp__limit_incoming_disk_space' => "Limit disk space in the incoming directory",
    'anonftp__limit_maximum_bandwidth' => "Limit download bandwidth for this virtual FTP domain",
    'anonftp__limit_maximum_connections' => "Limit number of simultaneous connections",
    'anonftp__unable_init' => "Unable to initialize anonymous FTP account: %1",
    'anonftp__unable_set_quota' => "Unable to set the incoming directory disk space limit: %1",
    'anonftp__unable_update' => "Unable to update anonymous FTP account properties: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS Certificates', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => " The CA certificate does not sign the certificate.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Incompatible private key/certificate pair.",
    'class_sslcertificate__invalid_cert_format' => "Invalid certificate format.",
    'class_sslcertificate__invalid_private_key_format' => "Invalid private key format.",
    'class_sslcertificate__prob_invalid_priv_key' => "Probably, the private key format is invalid.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Operation completed successfully.',
    'ui__admin/extras-domain__done' => 'MyPlesk.com page was opened.',
    'ui__admin/report/layout/delete_multi__done' => 'Selected report layouts were removed.',
    'ui__admin/report/traffic-history__done' => 'Operation completed successfully.',
    'ui__admin/report__done' => 'Operation completed successfully.',
    'ui__admin-alias/delete_multi__done' => "Selected additional administrator accounts were removed.",
    'ui__admin-alias/properties__done' => "Additional administrator account properties were updated.",
    'ui__admin-alias/properties_new__done' => "Additional administrator account was created.",
    'ui__admin-alias/properties_unknown__done' => "Additional administrator account properties were updated.",
    'ui__admin-alias__done' => "Additional administrator account information was successfully updated.",
    'ui__admin/manage-domain__done' => 'MyPlesk.com page was opened.',
    'ui__admin/register-domain__done' => 'MyPlesk.com page was opened.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Selected report delivery schedules were removed.',
    'ui__admin/report/layout/auto/properties__done' => 'Report delivery schedule was updated.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Report delivery schedule was created.',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS certificate properties were updated.',
    'ui__client/domain/certificate/properties_new__done' => 'New SSL/TLS certificate was added. To make it work, be sure to select it in website hosting settings (at Websites & Domains tab > domain name).',
    'ui__client/domain/certificate__done' => 'Operation completed successfully.',
    'ui__client/domain/certificate_self__done' => 'Operation completed successfully.',
    'ui__client/domain/chowner__done' => 'Subscription %1 now belongs to another user.',
    'ui__client/domain/chowner_multi__done' => 'Subscription ownership was changed.',
    'ui__client/domain/chowner_multi-select__done' => 'Operation completed successfully.',
    'ui__client/domain/chowner_select__done' => 'Operation completed successfully.',
    'ui__client/domain/dbbackup/create__done' => "Database was successfully backed up.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Database was successfully backed up.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Orphaned user was repaired successfully.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Backup files were successfully removed.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Database content was successfully restored.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operation completed successfully.", // PFW
    'ui__client/domain/dbbackup__done' => "Operation completed successfully.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operation completed successfully.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operation completed successfully.", // PFW
    'ui__client/domain/delete__done' => "The domain %1 was removed.",
    'ui__client/domain/delete_multi__done' => "The domains were removed.",
    'ui__client/domain/disable__done' => 'Domain %1 was suspended.',
    'ui__client/domain/disable_multi__done' => 'Selected domains were suspended.',
    'ui__client/domain/enable__done' => 'The website %1 was activated.',
    'ui__client/domain/enable_multi__done' => 'Selected websites were activated.',
    'ui__client/domain/extras__done' => 'MyPlesk.com page was opened.',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com page was opened.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Log rotation settings were changed.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Log rotation settings were changed.',
    'ui__client/domain/hosting/logs__done' => 'Operation completed successfully.',
    'ui__client/domain/hosting/logs_self__done' => 'Operation completed successfully.',
    'ui__client/domain/hosting/setup__done' => 'Hosting for %1 was configured.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operation completed successfully.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operation completed successfully.', // PFU
    'ui__client/domain/mpc-certificates__done' => 'SSL/TLS certificates available in the online store',
    'ui__client/domain/mpc-certificates_self__done' => 'SSL/TLS certificates available in the online store',
    'ui__client/domain/register__done' => 'MyPlesk.com page was opened.',
    'ui__client/domain/register_self__done' => 'MyPlesk.com page was opened.',
    'ui__client/domain/rename__done' => 'The domain name was changed.',
    'ui__client/domain/rename_self__done' => "The domain name was successfully changed.",
    'ui__client/domain/settings_self__done' => 'Operation completed successfully.',
    'ui__client/domain/toggle_disable__done' => "The domain %1 was suspended.",
    'ui__client/domain/toggle_enable__done' => "The domain %1 was activated.",
    'ui__client/domain/traffic__done' => 'Operation completed successfully.',
    'ui__client/domain/traffic_self__done' => 'Operation completed successfully.',
    'ui__client/domain/traffic_unknown__done' => 'Operation completed successfully.',
    'ui__client/domain-summary-report__done' => 'Operation completed successfully.',
    'ui__client/domain-summary-report_self__done' => 'Operation completed successfully.',
    'ui__client/domain-summary-report_unknown__done' => 'Operation completed successfully.',
    'ui__client/extras-domain__done' => 'MyPlesk.com page was opened.',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com page was opened.',
    'ui__client/ipaddress/delete_multi__done' => 'Operation completed successfully.',
    'ui__client/ipaddress/properties__done' => 'Operation completed successfully.',
    'ui__client/ipaddress/properties_new__done' => 'Operation completed successfully.',
    'ui__client/ip-pool/properties__done' => "Customer %1's IP pool was updated.",
    'ui__client/ip-pool/properties_self__done' => 'Operation completed successfully.',
    'ui__client/limits__done' => "Resource limits for customer %1 were changed.",
    'ui__client/limits_self__done' => 'Operation completed successfully.',
    'ui__client/logo__done' => 'The new branding settings for the customer %1 were applied.',
    'ui__client/logo_reseller__done' => 'The new panel branding settings were applied.',
    'ui__client/logo_self__done' => 'Branding settings were applied.',
    'ui__client/logo_self-reseller__done' => 'Your panel branding settings were applied.',
    'ui__client/manage-domain__done' => 'MyPlesk.com page was opened.',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com page was opened.',
    'ui__client/permissions__done' => "Permissions of customer %1 were changed.",
    'ui__client/permissions_self__done' => 'Operation completed successfully.',
    'ui__client/preferences__done' => "Preferences for customer %1 were changed.",
    'ui__client/preferences_self__done' => "Your preferences were changed.",
    'ui__client/register-domain__done' => 'MyPlesk.com page was opened.',
    'ui__client/register-domain_self__done' => 'MyPlesk.com page was opened.',
    'ui__client/report/traffic-history__done' => 'Operation completed successfully.',
    'ui__client/report/traffic-history_self__done' => 'Operation completed successfully.',
    'ui__client/report__done' => 'Operation completed successfully.',
    'ui__client/report_self__done' => 'Operation completed successfully.',
    'ui__client/sessions/delete__done' => 'Operation completed successfully.',
    'ui__client/sessions/delete_self__done' => 'Operation completed successfully.',
    'ui__client/sessions__done' => 'Operation completed successfully.',
    'ui__client/sessions_self__done' => 'Operation completed successfully.',
    'ui__client/traffic__done' => "Operation completed successfully.",
    'ui__client/traffic_unknown__done' => 'Operation completed successfully.',
    'ui__cp-access__done' => 'Operation completed successfully.',
    'ui__cp-session/properties__done' => 'Operation completed successfully.',
    'ui__cp-session__done' => 'Operation completed successfully.',
    'ui__ftp-sessions__done' => 'Operation completed successfully.',
    'ui__license__done' => 'Operation completed successfully.',
    'ui__logo__done' => "Plesk branding properties were changed.",
    'ui__longtasks/longtask/properties__done' => "Background task settings were changed successfully.",
    'ui__modules/watchdog/disk/properties__done' => 'The new disk monitoring settings were applied.', // PFU
    'ui__modules__done' => 'Operation completed successfully.',
    'ui__modules__short-title' => 'Extensions',
    'ui__modules__title' => 'Extensions',
    'ui__reseller/client/traffic_unknown__done' => 'Operation completed successfully.',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com page was opened.',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com page was opened.',
    'ui__reseller/ftp-sessions_self__done' => 'Operation completed successfully.',
    'ui__reseller/limits__done' => "Reseller's resource limits and resource usage policies were changed.",
    'ui__reseller/limits_readonly-self__done' => 'Operation completed successfully.',
    'ui__reseller/limits_self__done' => 'Your resource limits and resource usage policies were changed.',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com page was opened.',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com page was opened.',
    'ui__reseller/permissions__done' => 'Permissions of reseller %1 were changed.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operation completed successfully.',
    'ui__reseller/register-domain__done' => 'MyPlesk.com page was opened.',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com page was opened.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Selected report delivery schedules were removed.',
    'ui__reseller/report/layout/auto/properties__done' => 'Report delivery schedule was updated.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Report delivery schedule was added.',
    'ui__reseller/report/traffic-history__done' => 'Operation completed successfully.',
    'ui__reseller/report/traffic-history_self__done' => 'Operation completed successfully.',
    'ui__reseller/report__done' => 'Operation completed successfully.',
    'ui__reseller/report_self__done' => 'Operation completed successfully.',
    'ui__reseller/sessions/delete__done' => 'Operation completed successfully',
    'ui__reseller/sessions/delete_self__done' => 'Operation completed successfully',
    'ui__reseller/sessions__done' => 'Operation completed successfully.',
    'ui__reseller/sessions_self__done' => 'Operation completed successfully.',
    'ui__reseller/traffic__done' => 'Operation completed successfully.',
    'ui__reseller/traffic_self__done' => 'Operation completed successfully.',
    'ui__reseller/traffic_unknown__done' => 'Operation completed successfully.',
    'ui__reseller/logo_self__title' => 'Plesk Branding',
    'ui__reseller/logo_self__done' => 'Your Plesk branding settings were applied.',
    'ui__server/certificate/default_multi__done' => 'Selected SSL/TLS certificate was set up to be used for securing connections to newly hosted websites.',
    'ui__server/certificate/delete_multi__done' => 'Selected SSL/TLS certificates were removed.',
    'ui__server/certificate/download__done' => 'SSL/TLS certificate was downloaded.',
    'ui__server/certificate/properties__done' => 'SSL/TLS certificate properties were updated.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS certificate %1 created.',
    'ui__server/certificate/setup_multi__done' => 'The selected SSL/TLS certificate was set up to be used for securing connections to Plesk.',
    'ui__server/certificate__done' => 'Operation completed successfully.',
    'ui__server/cp-certificate-download__done' => "The Plesk's SSL/TLS certificate was downloaded.",
    'ui__server/crontab/properties__done' => 'Scheduled tasks of %1 were changed.',
    'ui__server/crontab/task/delete__done' => 'The task was removed.',
    'ui__server/crontab/task/delete_multi__done' => 'The tasks were removed.',
    'ui__server/crontab/task/properties__done' => 'The scheduled tasks were updated.',
    'ui__server/crontab/task/properties_new__done' => 'The new task was scheduled.',
    'ui__server/crontab/task/toggle_disable__done' => 'The scheduled task %1 was disabled.',
    'ui__server/crontab/task/toggle_enable__done' => 'The scheduled task %1 was enabled.',
    'ui__server/crontab__done' => 'Operation completed successfully.',
    'ui__server/dns__done' => 'Operation completed successfully.',
    'ui__server/ip-address/client/delete__done' => "The IP address was removed from user's IP pool.",
    'ui__server/ip-address/client/delete_multi__done' => "The IP address was removed from users' IP pools.",
    'ui__server/ip-address/client/properties_new__done' => 'The IP address was assigned to users.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP address %1 was assigned to the selected customers.',
    'ui__server/ip-addresses__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/spam/summary__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/spam__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/virus/summary__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operation completed successfully.",
    'ui__server/mail/statistics/virus__done' => "Operation completed successfully.",
    'ui__server/mail/statistics__done' => "Operation completed successfully.",
    'ui__server/mail__done' => 'Mail server settings were changed.',
    'ui__server/maillists__done' => 'Operation completed successfully.',
    'ui__server/mpc-certificates__done' => 'The online store page listing available SSL/TLS certificates was opened.',
    'ui__server/pmm__done' => 'Operation completed successfully.',
    'ui__server/preferences__done' => "The server settings were changed.",
    'ui__server/register__done' => 'MyPlesk.com page was opened.',
    'ui__server/services__done' => 'Operation completed successfully.',
    'ui__server/sitebuilder__done' => 'Operation completed successfully.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'The address %1 was removed from server-wide black list.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'The addresses were removed from server-wide black list.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'The addresses were added to the black list.',
    'ui__server/spam-filter/black-list/address__done' => 'The addresses were added to the black list.',
    'ui__server/spam-filter/black-list__done' => 'Operation completed successfully.', // PFU
    'ui__server/spam-filter/properties__done' => 'Spam filter settings were changed.',
    'ui__server/spam-filter/toggle_disable__done' => 'Spam filtering was disabled system-wide.',
    'ui__server/spam-filter/toggle_enable__done' => 'Spam filtering was enabled system-wide.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'The address %1 was removed from server-wide white list.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'The addresses were removed from server-wide white list.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'The addresses were added to the white list.',
    'ui__server/spam-filter/white-list/address__done' => 'The addresses were added to the white list.',
    'ui__server/spam-filter/white-list__done' => 'Operation completed successfully.', // PFU
    'ui__server/spam-filter__done' => 'Operation completed successfully.',
    'ui__server/statistics__done' => 'Operation completed successfully.',
    'ui__server/time__done' => "The system date and time were changed.",
    'ui__server__done' => "Operation completed successfully.",
    'ui__sessions/properties__done' => 'Operation completed successfully.',
    'ui__sessions__done' => 'Operation completed successfully.',
    'ui__sessions/delete__done' => 'Selected sessions were deleted.',
    'ui__support__done' => 'Assistance request form was opened in a new browser window or tab.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'No files to upload.',
    'login_up__access_denied_no_permission' => "Access denied. You do not have the permission to log in.",
    'mail__unable_remove_pattern' => "Unable to remove address from the server black list: %1", // PFW
    'mail__incorrect_network_format' => 'Incorrect network format: %1', // PFW
    'initconf__unable_change_passwd' => "Unable to change the administrator's password: %1",
    'initconf__unable_get_passwd' => 'Unable to get the current administrator password: %1 failed: %2',
    'initconf__invalid_hostname' => 'Error in hostname "%1"',
    'initconf__unable_reconfig' => 'Unable to configure Plesk: reconfig failed: %1',
    'initconf__unable_update_admin' => 'Unable to update the administrator contact info: %1',
    '__refresh' => 'Refresh',
    '__dalias_not_exist' => 'Domain alias does not exist.',
    '__bug146523_explanation' => ' Previous versions of Plesk allowed using up to 16 characters for FTP usernames. This version of Plesk limits the maximum number of characters allowed in FTP usernames to 15. To resolve this issue, reduce FTP username length to 15 characters for affected FTP usernames and change at least one character in affected FTP usernames to avoid username collision issues. We are sorry for any possible inconvenience caused by this change.',
    'domain__cannot_change_webmail' => 'Unable to change webmail for the domain: %1',
    'sb_publish_disable_warning' => 'If you switch off website creation with Presence Builder, the website previously created in Presence Builder will be removed and all website data will be lost. Click OK if you want to continue.',
    '__sbnet_client_use_sbnet' => "Create a corresponding user account in Presence Builder",
    'mail_resp_activate' => 'Activate auto-reply',
    'limitsManger__limit_available_error' => 'Unable to allocate the required amount of resources ("%%limitName%%"): only %%available%% is available for your account.',
    'limitsManger__limit_reserved_error' => 'Unable to allocate less resources ("%%limitName%%") than already used.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Unable to rename the domain: A virtual directory with the specified name already exists.',
    'domain_unable_to_rename' => 'Unable to rename the domain.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'General',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin spam filtering',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin Settings',
    'spamfilter__spamassassin_server_status_legend' =>  "Switch on server-wide SpamAssassin spam filtering",
    'spamfilter__spamassassin_user_status_legend' => 'Switch on SpamAssassin spam filtering',
    'spamfilter__greylisting_status_legend' => 'Switch on server-wide greylisting spam protection',
    'spamfilter__personal_settings_not_allowed' => 'The use of individual spam filtering settings is not allowed by the system policy.',
    'spamfilter__required_score' => 'The score that a message must receive to qualify as spam',
    'spamfilter__rewrite_header_subject' => 'Add the following text to the beginning of subject of each message recognized as spam',
    'spamfilter__use_mailuser_prefs' => 'Apply individual settings to spam filtering',
    'spamfilter__score_error' => 'The score should not be negative, the part before the decimal point must be less than 100, and may include no more than two digits after the decimal point.',
    'spamfilter__rewrite_header_error' => 'The message subject can contain any printable characters except the number sign (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Bounce',
    'nonexistent_mail__mode_discard' => 'Discard',
    'nonexistent_mail__mode_catch_addr' => 'Forward to email address',
    'nonexistent_mail__mode_catch_ip' => 'Forward to IP',
    'nonexistent_mail__bounce_not_supported' => 'Bounce mode not supported',
    'nonexistent_mail__discard_not_supported' => 'Discard mode not supported',
    'nonexistent_mail__catch_not_supported' => 'Forwarding to email address not supported',
    'nonexistent_mail__redirect_not_supported' => 'Forwarding to IP not supported',
    'nonexistent_mail__ip_used_on_this_host' => 'IP address resolves to localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Because the outgoing mail control is turned on, the email address %1 for non-existent recipients should belong to the selected domain. If it does not, then the "Reject" policy will be applied instead of forwarding.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Because the outgoing mail control is switched on, the email address specified for mail forwarding (%1) should belong to the selected domain. If it does not, then the messages sent to this address will not be counted in Outgoing Mail Control.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'There are no additional administrator accounts available.', // PFW
    'ui__client/domain/certificate__none-available' => 'Customer does not have SSL/TLS certificates.',
    'ui__client/domain/certificate__none-available__1' => 'Customer does not have domains with SSL/TLS certificates.',
    'ui__client/domain/certificate__none-available__2' => 'Domain has no SSL/TLS certificates.',
    'ui__reseller/client__none-available' => 'There are no resellers with customers.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'You need to select the IP addresses that you want to remove from IP pool.',
    'ui__server/ip-address/client/delete__empty_selection' => 'You need to select the reseller accounts from whose IP pools you want to revoke an IP address.',
    'ui__server/crontab/task/delete__empty_selection' => 'You need to select the task that you want to cancel.',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'ASP.NET support is switched off for this website.',
    'phosting__php_forced_by_site_isolation' => 'Unable to change PHP settings: the permission to override the server-wide security policy is not granted.',
    'phosting__option_forced_by_site_isolation' => 'Unable to change %1 settings: the permission to override the server-wide security policy is not granted.',
    'phosting__php_handler_id_not_registered' => 'The PHP handler is not allowed in the site isolation settings. The default PHP handler will be used.',
    'phosting__php_served_by_nginx_is_not_available' => 'The PHP handler (FPM application served by nginx) is not allowed in the site isolation settings. The default PHP handler will be used.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'View the list of IP addresses',
    'ui__client/ipaddress/properties_readonly__title' => 'View the list of IP addresses',
    'ui__client/ipaddress/properties_readonly__description' => 'View the list of IP addresses available for this user.',
    'ui__server/certificate__short-title' => 'SSL/TLS Certificates',
    'ui__server/certificate__title' => 'SSL/TLS Certificates',
    'ui__server/certificate__description' => 'View and manage SSL/TLS certificates.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Remove IP Addresses',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Select the IP addresses that you want to remove from the IP pool of customer %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP address',
    'ui__client/ipaddress__title' => 'IP address',
    'ui__client/ipaddress__description' => 'View information about IP address.',
    'ui__server/ip-address__short-title' => 'IP address',
    'ui__server/ip-address__title' => 'IP address',
    'ui__server/ip-address__description' => 'View information about IP address.',
    'ui__client/domain/hosting/setup__short-title' => 'Web Hosting Settings',
    'ui__client/domain/hosting/setup__title' => 'Web Hosting Settings',
    'ui__client/domain/hosting/setup__description' => 'Set up web hosting settings for website %1.',

    // tooltips

    'b_get_password_cancel' => 'Return to the previous screen without sending the email.',
    'b_get_password_send' => 'Click OK to send a password recovery message to the email address registered in the system.',



    'b_personaltrafficlist_search' => 'Enter a search pattern and click to find domains.',
    'b_personaltrafficlist_show_all' => 'Show all domains.',

    'b_back' => 'Return to the previous page.',
    'b_next' => 'Go to the next page.',

    'b_dnsnstemplatelist_remove' => 'Delete the selected name servers.',
    'b_dnsnstemplatelist_search' => 'Enter a search pattern and click to find name servers.',
    'b_dnsnstemplatelist_show_all' => 'Show all name servers.',

    'l_dnsnstemplatelist_ns' => 'Sort DNS template records by name server.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Generate secure links to files and folders',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Enable public files',
    'cu__serverfilesharing_fsPublicFolder' => 'Folder for public files storage',
    'cu__serverfilesharing_fsPublicUrl' => 'URL for visitor access to public files',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Enable password-protection of public files',
    'cu__serverfilesharing_fsPartnerFolder' => 'Folder for password-protected files storage',
    'cu__serverfilesharing_fsPartnersLogin' => 'Username for file access',
    'cu__serverfilesharing_fsPartnersPassword' => 'Password for file access',
    'cu__serverfilesharing_fsDomain' => 'Web folder root URL. Domain name',
    'cu__serverfilesharing_fsPrefix' => 'Web folder root URL. Prefix',
    'cu__serverfilesharing_commandUpdate' => 'Update file sharing settings',
    'cu__serverfilesharing_commandInfo' => 'Display current file sharing settings',
    'subscription_rename_is_forbidden' => 'Renaming of subscriptions is forbidden by the server-wide policy.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Manage Scheduled Tasks on the Server',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Select the system user whose scheduled tasks you want to manage.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Scheduled Task %1',
    'ui__server/crontab/task__description' => 'View properties of scheduled task %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'System Users',
    'ui__server/crontab_unknown__title' => 'System Users',
    'ui__server/crontab_unknown__description' => 'System users who can be the owners of scheduled tasks.',


    'ui__server/crontab__none-available' => 'You have no system user accounts.',
    'ui__server/crontab_readonly-unknown__description' => 'View scheduled tasks.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Scheduled tasks',
    'ui__server/crontab_readonly-unknown__title' => 'View scheduled tasks',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'View scheduled tasks.',
    'ui__server/crontab_readonly__description' => 'View scheduled tasks of %1.',
    'ui__server/crontab_readonly__short-title' => 'Scheduled task of %1',
    'ui__server/crontab_readonly__title' => 'View scheduled tasks of %1',
    'ui__server/crontab_unknown__wizard-title' => 'Manage scheduled tasks.',

    'ui__server/crontab/properties__description' => 'Edit scheduled tasks of %1.',

    'ui__server/crontab/properties__short-title' => 'Settings',
    'ui__server/crontab/properties__title' => 'Edit scheduled tasks of %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'View scheduled tasks.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Settings',
    'ui__server/crontab/properties_readonly-unknown__title' => 'View scheduled tasks',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'View scheduled tasks.',
    'ui__server/crontab/properties_readonly__description' => 'View scheduled tasks of %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Settings',
    'ui__server/crontab/properties_readonly__title' => 'View scheduled tasks of %1',
    'ui__server/crontab/properties_unknown__description' => 'Edit scheduled tasks.',
    'ui__server/crontab/properties_unknown__short-title' => 'Properties',
    'ui__server/crontab/properties_unknown__title' => 'Edit scheduled tasks',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Edit scheduled tasks.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Select the system user whose tasks you want to see.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Select the system user whose tasks you want to change.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Click Finish to apply the changes and exit the wizard.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Click Finish to exit the wizard.',

    'ui__server/crontab/task__none-available' => 'You have no scheduled tasks.',
    'ui__server/crontab/task__none-available__2' => 'System user %1 does not have any scheduled tasks.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Scheduled tasks.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tasks',
    'ui__server/crontab/task_readonly-unknown__title' => 'Scheduled tasks',

    'ui__server/crontab/task/delete__description' => 'Remove the scheduled task %1',

    'ui__server/crontab/task/delete__short-title' => 'Remove',
    'ui__server/crontab/task/delete__title' => 'Remove the scheduled task %1',
    'ui__server/crontab/task/delete_multi__description' => 'Remove scheduled tasks.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Remove',
    'ui__server/crontab/task/delete_multi__title' => 'Remove scheduled tasks',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Remove scheduled tasks.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Select the system user whose tasks you want to remove.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Select the tasks you want to remove.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Confirm removing the task by selecting the check box and click Finish to complete the wizard.',
    'ui__server/crontab/task/delete_unknown__description' => 'Remove a scheduled task.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Remove',
    'ui__server/crontab/task/delete_unknown__title' => 'Remove a scheduled task',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Remove a scheduled task.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Select the system user whose task you want to remove.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Select the task you want to remove.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Confirm removing the task by selecting the check box and click Finish to complete the wizard.',

    'ui__server/crontab/task/properties__description' => 'Edit scheduled tasks.',

    'ui__server/crontab/task/properties__short-title' => 'Edit the task %1',
    'ui__server/crontab/task/properties__title' => 'Edit scheduled tasks',
    'ui__server/crontab/task/properties_new__description' => 'Create scheduled tasks for %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Add task',
    'ui__server/crontab/task/properties_new__title' => 'Create scheduled tasks for %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Create a scheduled task.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Select the system user for whom you want to create the scheduled task.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Click Finish to apply the changes and exit the wizard.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'View the scheduled tasks.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Properties',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'View the scheduled tasks',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'View the scheduled tasks.',
    'ui__server/crontab/task/properties_readonly__description' => 'View scheduled tasks.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'View task %1',
    'ui__server/crontab/task/properties_readonly__title' => 'View scheduled tasks',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Create scheduled tasks.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Add task',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Create scheduled tasks',
    'ui__server/crontab/task/properties_unknown__description' => 'Edit scheduled tasks.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Properties',
    'ui__server/crontab/task/properties_unknown__title' => 'Edit scheduled tasks',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Edit scheduled tasks.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Select the system user whose tasks you want to see.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Select the system user whose tasks you want to change.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Select the scheduled task.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Select the scheduled task you want to change.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Click Finish to apply the changes and exit the wizard.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Click Finish to exit the wizard.',

    'ui__server/crontab/task/toggle_disable__description' => 'Disable the scheduled task %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Disable',
    'ui__server/crontab/task/toggle_disable__title' => 'Disable the scheduled task %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Enable the scheduled task %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Enable',
    'ui__server/crontab/task/toggle_enable__title' => 'Enable the scheduled task %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Enable or disable scheduled tasks.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Enable or disable',
    'ui__server/crontab/task/toggle_unknown__title' => 'Enable or disable scheduled tasks',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Enable or disable scheduled tasks',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Select the system user account whose tasks you want to enable or disable.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Select the task that you want to enable or disable.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Customer accounts', // not used on HP?
    'ui__client_unknown__title' => 'Customer accounts', // not used on HP?
    'ui__client_unknown__description' => 'Manage customer accounts.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspend domain', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspend domain', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspend a domain.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Activate domain', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Activate domain', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Activate a domain.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "FTP Accounts Under the Domain %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP accounts",
    'ftp__user_name' => "FTP account name",
    'ftp__user_home' => "Home directory",
    'ftp__invalid_path' => "Invalid path specified",
    'i_ftp_ses_sub_user' => 'FTP account session.',
    '__new_passwd' => "New %1 password",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Unable to configure a web server on the host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Unable to generate the web server configuration file on the host <%%host%%> because of the following errors:\n\n%%error%%\n\nPlease resolve the errors in web server configuration templates and generate the file again.",

    'apacheConfigurationMessageAdminTitle' => 'Generation of web server configuration failed',
    'apacheConfigurationMessageClientTitle' => 'Warning',

    'apacheConfigurationFailedAdminHomeMessage' => 'New configuration file was not built due to errors in configuration templates. The detailed error message was sent to your email, so please check the email, fix the errors, and click %1 to retry generating configuration.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'here', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'New configuration for domain %1 was not built due to errors in configuration templates. The detailed error message was sent to your email, so please check the email, fix the errors, and click %2 to retry generating configuration.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'here', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Web server configuration for domain %1 may be inconsistent. Please contact server administrator to resolve the problem.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'New configuration for some of the domains was not built due to errors in configuration templates. The detailed error message was sent to your email, so please check the email, fix the errors, and click %1 to retry generating configuration.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'here', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Web server configuration for some of your domains may be inconsistent. Please contact server administrator to resolve the problem.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Custom error documents",
    'dom_pref__webusers_script' => "Allow web users to use scripts",
    '__seoRedirect' => 'Configure the preferred domain as ',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'None',

    '__sites' => 'Domains',
    'domain_plan__perm_denied_manage_phosting' => 'You do not have the permission to manage hosting settings.',
    '__owned_by_client' => 'owned by customer',
    'ui__client/permissions_readonly__description' => "View the actions that the customer %1 can perform in Plesk.",
    'backup__restore__object_client_template' => 'Customer template',
    '__template_name' => 'Service plan name',
    'template__not_exists' => 'There is no such a service plan',
    'template__exists' => 'A plan with the name %1 already exists.',
    'clientOwnerChanger__ip_not_in_pool' => 'The specified IP address is not in the reseller\'s pool.',

    //// Change owner of subscription
    'chown__select_title' => "Choose New Subscriber",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Choose a new owner for the selected subscriptions and click Next >>.',
    'domains__client_info' => "%1 subscriptions, %2 active subscriptions, %3 disk space used, %4 traffic used",
    '__possible_owners' => 'Possible new owners of subscriptions',

    'clients_list__filter_owner__filter_title' => 'Provider',
    'clients_list__filter_owner_any' => 'All users',
    'clients_list__filter_owner_my' => 'My subscribers only',
    'clients_list__filter_owner_name__filter_title' => 'Provider\'s name',

    '__owner' => "Provider",
    'l_clientslist_owner' => 'Sort user accounts by provider.',
    'l_clientslist_date' => 'Sort user accounts by creation date.',
    'l_clientslist_name' => 'Sort user accounts by name.',
    'l_clientslist_domains' => 'Sort user accounts by domains.',
    'l_clientslist_cname' => 'Sort user accounts by company name.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Reassigning Selected Subscriptions',
    'chown__check_title' => 'Change Subscriber',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Click Finish to complete the reassignment. When it is done, the selected subscriptions will be assigned to a new owner, their provider will be changed to the new owner's provider, and they will be unbound from their service plans and become 'Custom'.",

    'chown__error_check' => 'Some problems were encountered when attempting to assign some of the subscriptions to a new owner.',
    'domain_chown_subscription_will_be_anonymous' => "Subscriptions will be unbound from their current service plans and become 'Custom'.",
    'chown__error_domains_exclude' => "Some problems were encountered when attempting to assign some of the subscriptions to a new owner. These subscriptions are highlighted.",
    'chown__ip_not_in_client_pool' => "The IP address associated with this subscription was not added to IP pool of the new owner.",
    'chown__already_owned_by_client' => "This subscription already belongs to this user.",

    '__redirect_hint' => 'You will be redirected to the new address in 15 seconds... If you are not automatically taken to the new location, please enable javascript or click the hyperlink %%link%%.',

    'backup__restore__object_maillist' => 'Mailing list',
    'backup__restore__object_site' => 'Site',
    'backup__restore__object_user' => 'User',
    'backup__restore__object_role' => 'Role',

    'limit__name_max_site' => 'sites',

    'iis_pool__unable_rename_client' => "Unable to rename IIS Aplication Pool: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonymous FTP service is supported only for the main domain of a subscription.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Anonymous FTP service is supported only for the main domain of a subscription.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/month',
    '__tb_month' => 'TB/month',

    '__customers' => 'Customers',
    '__customer_name' => 'Customer name',
    '__customer_total' => 'Customer total',
    '__site' => 'Site',
    '__def_site' => 'Default site',
    '__subscription_name' => 'Subscription name',
    '__subscription_name_powerUser' => 'Subscription name',

    'limit__units_max_traffic_suffix' => '/month',

    'dom_pref__discard' => "Reject",

    'mail__pattern_already_exists' => 'Pattern "%1" is already in the black list.',

    '__not_supported' => 'Not supported',

    'plesk_key__sitebuilder' => 'Sites published with Presence Builder',
    'limit__name_max_site_builder' => 'Sites published with Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Support for multi-language sites in Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Data Transfer Statistics for <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Data Transfer Statistics for <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Data transfer by services",

    'login_up__access_denied_no_subscriptions' => "Access denied. There are no subscriptions available for this account.",

    'interval__day' => '%1 day(s)',
    'interval__hour' => '%1 hour(s)',
    'interval__minute' => '%1 minute(s)',
    'interval__second' => '%1 second(s)',

    ///License options
    'plesk_key__backward_incompatibility' => 'You are trying to use a license key created for another version of Plesk. Contact Plesk sales representatives to obtain a proper license key.',
    //Standalone or virtualization
    'virtualization_any' => "Physical server or any virtualization solution",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "Valid for the following environments:",
    'plesk_key__virtualization_only_key' => 'The license key is intended only for use with Plesk operating inside a %1 virtual environment.',
    'plesk_key__virtualizations_only_key' => 'The license key is intended only for use with Plesk operating inside the following virtual environments: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Using custom language packs is prohibited.',
    'plesk_key__allowed-locales' => 'Available languages',
    'plesk_key__allowed-locales-any' => 'Any language',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin directory is located in',
    '_cgi_bin_mode_webspace' => 'the root directory of subscription',
    '_cgi_bin_mode_www_root' => 'the document root of this domain',

    /// Custom buttons
    'custom_button__sort_key' => 'Priority',
    'custom_button__place' => 'Location',
    'custom_button__place_navigation' => 'Common Access',
    'custom_button__place_admin' => 'Administrator\'s Home page',
    'custom_button__place_admin-settings' => 'Administrator\'s Tools & Settings page',
    'custom_button__place_reseller' => "Reseller's Home page",
    'custom_button__place_reseller-settings' => 'Reseller\'s Tools & Utilities page',
    'custom_button__place_client' => 'Customer\'s Home page',
    'custom_button__place_domain' => "Websites & Domains page of Subscription",
    'custom_button__place_domain_powerUser' => "Websites & Domains page of Subscription",
    'custom_button__place_domain-properties' => 'Website Tools',
    'custom_button__private' => 'Show to me only',
    'custom_button__image' => 'Background image',
    'custom_button__conhelp' => "Tooltip text",
    'custom_button__edit' => "Settings of a Link to an Additional Service",
    'custom_button__include_client_cname' => "Include customer's company name",
    'custom_button__include_client_email' => "Include customer's email",
    'custom_button__include_client_id' => "Include customer ID",
    'custom_button__include_client_pname' => "Include customer's contact name",
    'custom_button__include_domain_id' => "Include subscription ID, domain ID and domain alias ID",
    'custom_button__include_domain_id_powerUser' => "Include subscription ID, domain ID and domain alias ID",

    'custom_button__include_domain_name' => "Include Primary Domain name",
    'custom_button__include_ftp_user' => "Include FTP username",
    'custom_button__include_ftp_pass' => "Include FTP password",
    'custom_button__internal_open' => "Open URL in Plesk",
    'custom_button__text' => "Button label",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'The file is not an image file.',
    'custom_button__big_image' => 'The file size must not exceed 100 KB.',
    'custom_button__failed_copy_image' => 'Unable to copy the file: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Cannot restore a non-Power-User backup in Power User view.',
    '__unknown_network_interface' => 'Unknown network interface',

    'init_conf__ip_address' => 'IP address',

    //Confirmation page
    'bt_confirm' => 'Confirm',
    'b_confirm' => 'Confirm ownership of your sites.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Settings of dedicated IIS application pool are set according to the server-wide security policy (site isolation configuration).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Settings of dedicated IIS application pool are set according to the server-wide performance settings.',

    '__current' => 'Current',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'You have used almost all domains provided with your Plesk license (90% or even more).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'You have used almost all domains.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'You have used almost all Presence Builder sites provided with your Plesk license (90% or even more).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'You have used almost all Presence Builder sites.',
    'promo__button_hide' => 'Hide',
    'promo__button_next' => 'Next >>',
    'promo__button_prev' => '<< Previous',
    'promo__button_license' => 'Update License',

    'promo__google_integration_title' => 'Integration with Google services',
    'promo__google_integration' => 'Configure integration with Google services, such as AdSense, Google Apps, Webmaster tools.',
    'promo__google_integration_button' => 'Configure',

    'promo__button_learn_more' => 'Learn More',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'You can customize interface appearance and branding settings by means of custom themes. For instructions on customizing Plesk themes, refer to the %1.',
    'panel_branding__description_link' => 'following document',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extract Files',
    'filemanager_error_extracting_files' => 'An error occurred when extracting the archive files: %1',
    'filemanager_no_archive_files_specified' => 'Specify the archives you want to extract.',
    'filemanager_not_zip_archive_specified' => '%1 cannot be extracted, it is not a ZIP archive.',
    'filemanager_files_successfully_extracted' => 'The archive files were extracted.',
    'filemanager_error_file_download' => 'Downloading the file failed: %1',
    'filemanager__user_poolgrp' => 'Application pool group',

    'loading' => 'Loading...',
    'bt_create_archive' => 'Add to Archive',
    'filemanager__pack' => "Path to the archive: %1",
    'filemanager__archive_name' => 'Archive file name',
    'filemanager__empty_filename' => 'Please enter the archive file name.',
    'filemanager_archive_created' => 'The archive was successfully created.',
    'filemanager_error_creating_archive' => 'Unable to create the archive: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "This record will conflict with the AAAA record for the zone.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP server does not support IPv6 addresses.)",
    'cmd_dns__glue_dns_record_conflict' => 'This record will conflict with the glue record for the zone \'%1\'.',
    '__ftp_ipv6_not_supported' => "(FTP server does not support IPv6 addresses.)",
    '__ipv6_not_supported' => 'IPv6 is not supported.',
    'mail__ipv6_not_supported' => 'IPv6 is not supported by mail server.',
    'mail__relay_while_list_ipv6_not_supported' => 'IPv6 relay whitelist is not supported by mail server.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Mask value must be a multiple of 16.',
    'mail__ip_or_mask_is_invalid' => 'IP address or mask is invalid.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Forwarding to IPv6 IP addresses is not supported.',
    'sa__invalid_trusted_networks' => 'Incorrectly specified trusted networks: %1',
    'dns_add__enter_ipv6_address' => "IPv6 address",
    'license_trial_days_left' => 'Your Plesk is operating with a trial license that will expire in %1 days.',
    'excl_ipv6_num' => 'Dedicated IPv6 address',
    '__ip_mask' => "Subnet Mask",
    '__ipv4_addr' => 'IPv4 address',
    '__ipv6_addr' => 'IPv6 address',
    'template__num_excl_ipv6s' => 'Allocate dedicated IPv6 addresses to the reseller',
    'anonftp__exclusive_ipv4_required' => 'A dedicated IPv4 address is required to set up and use anonymous FTP service.',
    'anonftp__ipv4_already_used' => 'You cannot set up anonymous FTP service for this site because it is already configured on another domain on the same IPv4 address.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'View the log',

    'chown__ip_address_warn' => 'Before moving the subscription to the new owner, you must select a new IP address for that subscription.',
    'chown__no_ip_address' => 'None',
    'chown__no_ipv4_address' => 'No IPv4 address',
    'chown__no_ipv6_address' => 'No IPv6 address',
    'chown__domain_exclude_already_owned_by_client' => 'The subscription %1 already belongs to that user.',
    'chown__error_ip_absent_in_ip_pool' => 'The IP address %1 is not present in the IP pool of the target user.',
    'chown__error_ip_not_exist' => 'The IP address with ID \'%1\' does not exist.',
    'chown__error_domain_ip_not_selected' => 'At least one IP address for the domain %1 should be selected. Check the values selected for IP mapping.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 address or mask is invalid: IP address should be a valid unicast address.',

    '__subscriptions' => 'Subscriptions',

    '__owned_by_reseller' => 'owned by reseller',
    '__owned_by_provider' => 'owned by provider',

    'service_plan__anonymous' => 'Custom',
    'subscription_not_locked__change_limits_warning' => 'This subscription is not locked: The resource usage limits will be changed during synchronization with the service plan.',
    'subscription_not_locked__change_permissions_warning' => 'This subscription is not locked: The permissions will be changed during synchronization with the service plan.',

    'subscription__conflict_resolution_policy' => 'Conflicts resolution policy',
    'subscription__conflict_resolution_policy_lock' => "Lock subscription",

    'backup__list__backup_warnings' => 'Warnings',
    'backup__list__backup_info' => 'Information',
    'backup__restore__object_reseller_template' => 'Reseller template',
    'backup__restore__object_domain_template' => 'Domain template',

    'ui__client/permissions_readonly__title' => 'Permissions',
    'ui__client/permissions_readonly__short-title' => 'Permissions',

    'subscription__unable_lock_anonymous' => 'This subscription is not tied to a service plan, and so it cannot be unlocked.',
    'subscription__unable_sync_anonymous' => 'This subscription is not tied to a service plan, and so it cannot be synchronized.',
    'subscription__unable_sync_locked' => 'This subscription is locked and so it cannot be synchronized.',
    'subscription__locked' => 'The subscription is locked.',
    'component_name__urlrewrite' => "URL Rewrite",
    '__quantity' => 'Quantity',
    'hst__www_root_dir_absent' =>  'Warning: The directory specified as a document root does not exist.',
    'object_creation__domain_is_not_a_webspace' => 'This object can be created only in a subscription.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Subscription contains sites, therefore, you cannot change hosting type or delete it.',
    'phosting__apache_error_docs_are_not_enabled' => 'Custom error documents are not enabled on the domain.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Error: Failed to update the IP address. Addon domains cannot be assigned an IP address not assigned to the main domain of the subscription.',
    'domain_plan__unable_change' => 'Unable to change service plan: %1.',
    'domain_plan__different_hosting_type' => 'The current type of hosting is different from the type specified in the service plan.',
    'domain_plan__addon_text' => 'Add-on plan',
    'domain_plan__addon_description' => 'Add-on plan is used to supplement a hosting plan.',
    'asp_net__managed_runtime_version' => 'ASP.NET managed runtime version',
    'plan__can_not_change_hosting_type' => 'It is impossible to change hosting type when editing a plan.',
    'plan__apply_problems' => 'The plan was not applied because of problems with the following functionality: %1',
    'plan_save__subscription_update_problem' => 'Unable to apply plan changes to %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "The subscription is temporarily suspended until the backup or restore process is complete. Please come back later.",
    '__login_incorrect_plain_shadow_password' => 'You specified an incorrect password to the administrator\'s account. Please use the system administrator (root) credentials, or obtain the correct password. To learn more about obtaining the password, read the file /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'You cannot send the IP address you do not own',

    'dns__dns_zone_not_synchronized' => 'The DNS zone was modified. If you would like to apply DNS template changes to this zone, either click the \'Apply DNS Template Changes\' button on this page or choose the \'Apply the changes to all zones\' option in Server Administration Panel > Tools & Settings > DNS Template Settings > Apply DNS Template Changes.',
    'dns__dns_zone_synchronize_link' => 'Click',
    'dns__dns_zone_synchronize_done' => 'The DNS zone was successfully synced.',

    'dns__dns_zone_template_error' => 'There were issues syncing DNS zones with the DNS zone template.%1',

    'dns__soa_rname_type_owner' => 'Website owner\'s email address',
    'dns__soa_rname_type_domain' => 'Domain email address',
    'dns__soa_rname_type_external' => 'External email address',
    'dns__soa_rname_enforce_email' => 'Prohibit changing the RNAME email address on a per domain basis',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'The email address of the person responsible for the domain\'s DNS zone. Returned by the DNS server in response to SOA queries.',

    'dns__dns_zone_soa_sync_title' => 'Override SOA settings for all existing domains',
    'dns__dns_zone_soa_sync_legend' => 'Confirmation required',
    'dns__dns_zone_soa_sync_text' => 'Update SOA records of all hosted domains by applying the changes made to the SOA template?',

    'cu_db__repair_mysql_dbus' => "Repair MariaDB/MySQL user passwords. This operation is necessary if you upgraded to Plesk 11 from earlier versions.",

    'cu_scheduled_backup_comment' => 'Scheduled Backup',
    'cu_scheduled_backup_error' => 'An error occurred during the backup process: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> An error occurred during the scheduled backup.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk entry point: %2\n\nThe following errors occurred during the scheduled backup process:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Hourly Backup',
    'cu_scheduled_backup_daily' => 'Daily Backup',
    'cu_scheduled_backup_weekly' => 'Weekly Backup',
    'cu_scheduled_backup_monthly' => 'Monthly Backup',
    'cu_scheduled_backup_comment_backup_all' => '%1. All configuration and content.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. All configuration and content except email messages.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Only configuration and email messages.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. All configuration and content except user databases.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. All configuration and content except user files.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Only configuration and user databases.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Only configuration and user files',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Domain configuration.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Storing scheduled backups in a remote cloud storage is a premium feature. Contact your hosting provider to unlock it.',

    'i_backup_invalid_file' => 'This is not a valid backup. Data cannot be restored from this file. Click on the backup name for details.',

    'ui__server/migration/download-agent__short-title' => 'Download Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Download Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Download the latest available version of Migration & Transfer Agent from the Plesk website.',

    'filemanager_resulting_archive_exists' => 'The file %1 already exists in the target directory.',

    'agent_unable_to_connect' => 'Unable to connect to the agent at \'%2\'. Please ensure that the agent is installed and running and there are no connection problems with the host \'%2\'.',
    'agent_test_connection_failed' => 'Connection to the agent at \'%2\' failed.',

    'agent_unable_to_resolve_host' => 'Unable to locate the remote host \'%1\'. Please ensure that there are no connection problems with the host.',
    'agent_unknown_curl_error' => 'The error \'%1\' occurred during the connection to the agent at \'%2\'.',
    'agent_unexpected_htp_code' => 'The unexpected HTTP code \'%1\' was received on the HTTP request to the agent at \'%2\'.',
    'agent_unable_to_auth' => 'Unable to authenticate at the host \'%1\'. To resolve this issue, please follow the instructions at http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'An internal server error was encountered during the command execution on the remote host \'%1\'.',
    'agent_response_is_empty' => 'An empty response was received on the HTTP request to the agent at \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Unable to find Migration & Transfer Agent in the local cache. Please reopen Migration &Transfer Manager to fix the issue.',

    '__hosting_webdeploy' => "Web Deploy publishing",
    'cu_domain__webdeploy' => "Web Deploy publishing (default: %1)",
    'cu_dom_tpl__webdeploy' => "Web Deploy publishing (default: %1)",
    'cu_subdomain__webdeploy' => "Web Deploy publishing (default: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy is not installed on the server",
    'webdeploy__forced_by_site_isolation' => "Unable to change Web Deploy publishing settings: You do not have the permission to override the server-wide security policy. Contact your provider for details.",



    'backup__restore_options__admin__server_configuration_license' => 'License key',
    'migration_start_migrate_server_license' => 'Transfer license key',

    'defaultcomponents__delegation_rule_not_exist' => '(the required delegation rule \'appPoolPipeline, appPoolNetFx\' does not exist)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'The backup was created by the administrator.',
    'i_backup_created_by_reseller' => 'The backup was created by a reseller.',
    'i_backup_created_by_client' => 'The backup was created by a customer.',

    'migration__object_exists_on_target_host' => '(already exists on the target host)',

    '__customers_total' => 'Total by customers',
    '__resellers_total' => 'Total by resellers',
    '__reseller_total' => 'Reseller total',


    'cu_cl_pref__manage_website_maintenance' => 'Access to advanced operations: Website Copying',
    'cu_cl_pref__manage_protected_dirs' => 'Password-protected directories management',
    'cu_cl_pref__manage_mail_settings' => 'Ability to change mail settings',


    'cu__command_update_php_settings' => 'Updates PHP settings.',
    'cu__php_settings_option' => 'Sets the path to the file with PHP settings.',

    'cu__additional_php_settings_option' => 'Sets the path to the file with additional PHP directives.',
    'cu__command_show_php_settings' => 'Displays the current PHP settings.',
    'cu__general_settings' => 'General settings:',
    'cu__performance_settings' => 'Performance settings:',
    'cu__php_fpm_settings' => 'PHP-FPM settings:',
    'cu__additional_directives' => 'Additional directives:',

    'php_settings_permission_required' => 'Common PHP settings management',
    'php_settings_performance_permission_required' => 'Hosting performance settings management',
    'php_settings_customized' => 'PHP settings were customized.',
    'php_settings_synchronized_with_plan' => 'PHP settings must be synchronized with the plan.',
    'phosting__unknown_shell_type' => 'Non-available shell',

    'login_up__access_denied_subscription_deleted' => 'Access denied: Your subscription was removed.',

    'role_restricted_to_subscription' => '(transferred with the subscription: %1)',

    'filemanager__extract' => "Extract files to: %1",

    'cu__license_command_check_installed_license' => 'Check the validity of the installed license key (returns the 0 exit code if the key is valid and 1 if it is invalid)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Extend Plesk functionality to be able to control and monitor the server from mobile devices (BlackBerry, iPhone, and Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor ',
    'promo__mobile_monitor' => 'Obtain the most important information about Plesk servers anytime and anywhere from a mobile device (BlackBerry, iPhone, and Android).',
    'promo__mobile_button' => 'Learn More',

    'ui__server/migration/video__short-title' => 'Video tutorials',
    'ui__server/migration/video__title' => 'Watch video tutorials',
    'ui__server/migration/video__description' => 'Watch video tutorials.',

    'subDomainNameHint' => 'Enter * as a subdomain name to create a wildcard subdomain. Site visitors will be redirected to this subdomain regardless of the subdomain name they enter in a browser.',
    'subdomains__wildcard_name_invalid' => "The subdomain name is invalid. You can use only alphanumeric characters, a hyphen (-), and an asterisk (*) for wildcard subdomain names.",
    'subdomains__name_invalid' => "The subdomain name is invalid. You can use only alphanumeric characters and a hyphen (-) for subdomain names.",

    'domain__wildcard_no_www_prefix' => 'It is not possible to use the www prefix for wildcard subdomains.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix mail filter",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3 server",
    'restart__pop3s' => "Courier POP3 server with SSL/TLS support",
    'restart__imap' => "Courier IMAP server",
    'restart__imaps' => "Courier IMAP server with SSL/TLS support",
    'restart__authdaemon' => "Courier IMAP authentication daemon",
    'restart__imap-pop3' => "Dovecot IMAP and POP3 server",


    'addon_packages_not_supported' => 'Add-ons for APS packaged web apps are not supported.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Unable to automatically assign an IP address to the domain. Please specify an IP address using the -ip option.',

    'plesk_key__mb_accounts' => 'User accounts (resellers and customers) in Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Subdomain DNS zone',
    'actionlog__site_subdomain_dns' => 'DNS zone of a subdomain under an additional domain',

    // PfW only
    'actionlog__event_site_create' => 'Domain created',
    'actionlog__event_site_delete' => 'Domain deleted',
    'actionlog__event_site_update' => 'Domain updated',

    'actionlog__event_site_status_update' => 'Domain status updated',
    'actionlog__event_site_dns_update' => 'Domain DNS zone updated',
    'actionlog__event_site_guid_update' => 'Domain GUID updated',

    'actionlog__event_site_subdomain_create' => 'Subdomain created',
    'actionlog__event_site_subdomain_delete' => 'Subdomain deleted',
    'actionlog__event_site_subdomain_update' => 'Subdomain updated ',

    'actionlog__event_site_alias_create' => 'Domain alias created',
    'actionlog__event_site_alias_delete' => 'Domain alias deleted',
    'actionlog__event_site_alias_update' => 'Domain alias updated',

    'actionlog__event_site_alias_dns_update' => 'DNS zone of a domain alias updated',
    'actionlog__event_subdomain_dns_update' => 'DNS zone of a subdomain under the default domain was updated',
    'actionlog__event_site_subdomain_dns_update' => 'DNS zone of a subdomain updated',
    // End of PfW only

    'win_policy__bad_password' => 'Validation failed. The password is invalid.',
    'win_policy__password_too_short' => 'Validation failed. The password does not meet password policy requirements because it is too short.',
    'win_policy__password_too_long' => 'Validation failed. The password does not meet password policy requirements because it is too long.',
    'win_policy__password_not_complex_enough' => 'Validation failed. The password is not complex enough and does not meet the password policy requirements. Strong passwords must contain at least all of the following: eight characters; one upper- or lowercase character; three numbers and one special character (!, @, #, $, %, ^, &, *, ?, _, ~) or one number and two special characters.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Unable to update the product license.',


    'filemanager__error_path_is_not_allowed' => 'Path is not allowed',
    'filemanager__error_path_is_invalid' => 'Path is invalid',
    'filemanager__error_path_not_found' => 'Path not found',
    'filemanager__error_path_already_exists' => 'Path already exists',
    'filemanager__error_access_is_denied' => 'Access denied',
    'filemanager__error_directory_not_empty' => 'Folder is not empty',
    'filemanager__error_sharing_violation' => 'Sharing violation',
    'filemanager__error_not_same_device' => 'Destination path is not on the same device',
    'filemanager__unable_to_resolve_realpath' => "Unable to find the file %1 at the specified location",
    'filemanager__access_to_realpath_denied' => "Access to realpath denied: %1 to %2.",
    'bt_exit' => 'Exit',

    'filemanager__copy_error__' => "Unable to copy %1 to %2: %3",
    'filemanager__copy_move' => "Copy (move) files from %1",
    'filemanager__count_size__' => 'Selection size: %1',
    'filemanager__count_size_error__' => 'Unable to calculate size for %1: %2',
    'filemanager__create_dir_error__' => "Unable to create directory %1: %2",
    'filemanager__dir_not_exists' => "Directory %1 does not exist.",
    'filemanager__dirname' => "Directory name",
    'filemanager__filename' => "File name",
    'filemanager__is_no_such' => "There is no file or directory with name %1",
    'filemanager__empty_selection' => "No file(s) selected.",
    'filemanager__move_error__' => "Unable to move %1 to %2: %3",
    'filemanager__not_allowed' => "You are not allowed to change permissions for this file.",
    'filemanager__remove' => "Remove files from %1",
    'filemanager__remove_error__' => "Unable to remove file %1: %2",
    'filemanager__set_win_permissions_dir' => "Set permissions for %1 folder",
    'filemanager__set_win_permissions_file' => "Set permissions for %1 file",
    'filemanager__touch_confirm' => "Are you sure you want to change the timestamp of the selected files?",
    'filemanager__upload_error__' => "Unable to upload %1 to %2: %3",
    'filemanager__upload_file' => "Upload file",
    'filemanager__upload_file_src' => "Path to file",
    'filemanager__max_image_size_exceeded' => 'Unable to display the image. The image size cannot be greater than %2 bytes',

    '__fastcgi_unix_support' => 'FastCGI support',

    'dns__subdomain_dns_zone_parent' => 'The DNS records of this subdomain are stored in the parent DNS zone. You can modify the parent zone %1 or create a separate zone for the subdomain.',
    'dns__subdomain_dns_zone_parent_link' => 'here',
    'dns__no_dns_zone' => 'No any DNS zone assigned with domain. To manage DNS zone for your domain you should press the \'Restore Defaults\' button.',
    'dns__unable_turn_on_subdomain_zone' => 'Unable to switch on the subdomain\'s zone because there is a CNAME record for this subdomain in its parent domain\'s zone.',

    '__hosting_write_modify' => 'Additional write/modify permissions',

    'aspdotnet__group_framework_version' => "Framework Version",

    'bt_restore_default' => "Set to Default",
    'b_autoinstaller' => 'Update Plesk or its components.',
    'b_autoinstaller_configure' => 'Update settings.',
    'b_autoinstaller_install' => 'Install selected components.',

    '__iis_app_pool__use_dedicated' => 'Dedicated IIS application pool',
    '__iis_app_pool__use_dedicated_addons' => 'Dedicated IIS application pool for each website',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Enable 32-bit applications',
    '__iis_app_pool__load_user_profile' => 'Load the user profile',
    'bt_iis_app_pool' => "IIS Application Pool",

    'performance__cpu_usage' => 'Maximum CPU usage (%)',
    'performance__cpu_usage_action' => 'Limit action',
    'performance__cpu_usage_interval' => 'Limit interval (minutes)',
    'performance__cpu_usage_action_not_supported' => 'The specified action is not supported by the web server.',

    'performance__idle_timeout_action_not_supported' => 'The specified idle timeout action is not supported by the web server.',
    'performance__max_worker_processes' => 'The maximum number of worker processes',
    'performance__idle_timeout' => 'Idle timeout (minutes)',
    'performance__idle_timeout_action' => 'Idle timeout action',
    'performance__recycling_by_time' => 'Recycling at regular time intervals (minutes)',
    'performance__recycling_by_requests' => 'Recycling when the maximum number of requests is reached',
    'performance__recycling_by_virtual_memory' => 'Recycling when the maximum amount of virtual memory is used',
    'performance__recycling_by_private_memory' => 'Recycling when the maximum amount of private memory is used',
    'performance__managed_pipeline_mode' => 'Managed pipeline mode',
    'performance__managed_pipeline_mode_not_supported' => 'The specified mode is not supported by the web server.',

    'iis_app_pool' => 'IIS application pool management.',
    'b_iis_app_pool' => 'Manage IIS application pool.',
    'iis_app_pool_cl_dom' => 'IIS application pool management.',

    'bt_protect' => 'Protect',
    'bt_unprotect' => 'Remove Protection',
    'bt_show_additional_users' => 'Show more users',
    'bt_hide_additional_users' => 'Show less users',
    'error_doc__code_400' => 'Bad Request',
    'error_doc__code_401' => 'Unauthorized',
    'error_doc__code_401.1' => 'Unauthorized - Login failed',
    'error_doc__code_401.2' => 'Unauthorized - Login failed due to server configuration',
    'error_doc__code_401.3' => 'Unauthorized - Unauthorized due to ACL on resource',
    'error_doc__code_401.4' => 'Unauthorized - Authorization failed by filter',
    'error_doc__code_401.5' => 'Unauthorized - Authorization failed by ISAPI/CGI app',
    'error_doc__code_401.7' => 'Unauthorized - Denied due to URL authorization policy',
    'error_doc__code_403' => 'Forbidden',
    'error_doc__code_403.1' => 'Forbidden - Execute access denied',
    'error_doc__code_403.2' => 'Forbidden - Read access denied',
    'error_doc__code_403.3' => 'Forbidden - Write access denied',
    'error_doc__code_403.4' => 'Forbidden - SSL required',
    'error_doc__code_403.5' => 'Forbidden - SSL 128 required',
    'error_doc__code_403.6' => 'Forbidden - IP address rejected',
    'error_doc__code_403.7' => 'Forbidden - Client certificate required',
    'error_doc__code_403.8' => 'Forbidden - Site access denied',
    'error_doc__code_403.9' => 'Forbidden - Too many users',
    'error_doc__code_403.10' => 'Forbidden - Invalid configuration',
    'error_doc__code_403.11' => 'Forbidden - Password change',
    'error_doc__code_403.12' => 'Forbidden - Mapper denied access',
    'error_doc__code_403.13' => 'Forbidden - Client certificate revoked',
    'error_doc__code_403.14' => 'Forbidden - Directory listing denied',
    'error_doc__code_403.15' => 'Forbidden - Client access licenses exceeded',
    'error_doc__code_403.16' => 'Forbidden - Client certificate untrusted or malformed',
    'error_doc__code_403.17' => 'Forbidden - Client certificate has expired or is not yet valid',
    'error_doc__code_403.18' => 'Forbidden - Cannot execute request from this application pool',
    'error_doc__code_403.19' => 'Forbidden - CGI access denied',
    'error_doc__code_403.20' => 'Forbidden - Passport login failed',
    'error_doc__code_404' => 'Not found',
    'error_doc__code_404.2' => 'Not Found - Denied due to lockdown policy',
    'error_doc__code_404.3' => 'Not Found - Denied due to MIMEMAP policy',
    'error_doc__code_405' => 'Method not allowed',
    'error_doc__code_406' => 'Not acceptable',
    'error_doc__code_407' => 'Proxy authentication required',
    'error_doc__code_408' => 'Request timeout',
    'error_doc__code_412' => 'Precondition failed',
    'error_doc__code_414' => 'Request-URI too long',
    'error_doc__code_415' => 'Unsupported media type',
    'error_doc__code_431' => 'Request header fields too large',
    'error_doc__code_500' => 'Internal server error',
    'error_doc__code_500.12' => 'Internal server error - Application restarting',
    'error_doc__code_500.13' => 'Internal server error - Server too busy',
    'error_doc__code_500.15' => 'Internal server error - Direct requests for GLOBAL.ASA forbidden',
    'error_doc__code_500.16' => 'Internal server error - UNC access error',
    'error_doc__code_500.17' => 'Internal server error - URL authorization store not found',
    'error_doc__code_500.18' => 'Internal server error - URL authorization store cannot be opened',
    'error_doc__code_500.19' => 'Internal server error - Bad file metadata',
    'error_doc__code_500.100' => 'Internal server error - ASP error',
    'error_doc__code_501' => 'Not implemented',
    'error_doc__code_502' => 'Bad gateway',
    'error_doc__code_503' => 'Service temporarily unavailable',

    'mimetype_edit__already_exists' => 'The MIME type is already defined for this extension.',
    'mimetype_edit__not_exists' => 'The MIME type does not exist.',

    'php__group_php_version' => "PHP Version",

    'virtualdir__path' => 'Path',
    'virtualdir__read' => 'Read permission',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Write permission',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Script source access',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Directory browsing',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Execute permissions',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Log visits',
    'virtualdir__app_create' => 'Create application',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Switches on anonymous authentication.',
    'virtualdir__auth_windows' => 'Switches on Windows authentication.',
    'virtualdir__auth_not_enabled' => 'Anonymous or Windows authentication must be switched on.',
    'virtualdir__require_ssl' => 'Require SSL/TLS',
    'virtualdir__enable_default_doc' => 'Use default documents',
    'virtualdir__default_doc' => 'Default documents search order',
    'virtualdir__enable_parent_paths' => 'Allow to use parent paths',
    'virtualdir__execute_in_mta' => 'Allow application execution in MTA (multi-threaded apartment) mode',
    'virtualdir_create__title' => 'Create virtual directory in %1',
    'virtualdir_edit__title' => 'Properties of virtual directory %1',
    'virtualdir_edit__legend' => 'Virtual directory',
    'virtualdir_edit__application_legend' => 'Application settings',
    'virtualdir_edit__security_legend' => 'Directory security',
    'virtualdir_edit__documents_legend' => 'Documents',
    'virtualdir_edit__list_legend' => 'Nested virtual directories',
    'virtualdir_error__path_not_in__' => 'Invalid path specified',
    'virtualdir_root' => 'Virtual directories',
    'virtualdir_root__title' => 'Virtual directories',
    'virtualdir_root__list_legend' => 'Virtual directories',
    'virtualdir_se__none' => 'None',
    'virtualdir_se__script' => 'Scripts only',
    'virtualdir_se__script_execute' => 'Scripts and Executables',
    'virtualdirs__title' => 'Virtual directories',
    'virtualdirs__path_not_exists' => 'Invalid path.',
    'virtualdirs__select_for_remove' => "Select the virtual directories to be removed.",
    'virtualdirs_remove__title' => 'Remove virtual directories',

    'asp_max_buffer_text' => 'Maximum size of the ASP buffer (KB)',
    'asp_max_body_text' => 'Maximum size of entity body of an ASP request (KB)',
    'asp_buffers_legend' => 'ASP Settings',
    'asp_client_debug_text' => 'Enable ASP client-side script debugging',
    'asp_server_debug_text' => 'Enable ASP server-side script debugging',

    'permissions__group_or_user_name' => 'Group or user names',
    'permissions__FullControl' => 'Full Control',
    'permissions__Modify' => 'Modify',
    'permissions__ReadAndExecute' => 'Read & Execute',
    'permissions__ListFolderContents' => 'List Folder Contents',
    'permissions__Read' => 'Read',
    'permissions__Write' => 'Write',
    'permissions__ReadControl' => 'Read Control',
    'permissions__WriteControl' => 'Write Control',
    'permissions__ExecuteControl' => 'Execute Control',
    'permissions__TraverseFolderOrExecuteFile' => 'Traverse Folder / Execute File',
    'permissions__ListFolderOrRead' => 'List Folder / Read Data',
    'permissions__CreateFilesOrWrite' => 'Create Files / Write Data',
    'permissions__CreateFoldersOrAppend' => 'Create Folders / Append Data',
    'permissions__DeleteSubfoldersandFiles' => 'Delete Subfolders and Files',
    'permissions__Delete' => 'Delete',
    'permissions__ChangePermissions' => 'Change Permissions',
    'permissions__TakeOwnership' => 'Take Ownership',
    'permissions__inherited_from' => 'Inherited from',
    'permissions__not_inherited' => '<not inherited>',
    'permissions__apply_to' => 'Apply to',
    'permissions__apply_onto' => 'Apply to:',
    'permissions__apply_onto1' => 'This folder only',
    'permissions__apply_onto2' => 'Subfolders only',
    'permissions__apply_onto3' => 'This folder and subfolders',
    'permissions__apply_onto4' => 'Files only',
    'permissions__apply_onto5' => 'This folder and files',
    'permissions__apply_onto6' => 'Subfolder and files only',
    'permissions__apply_onto7' => 'This folder, subfolders, and files',

    'filemanager__not_allowed_dir' => "You are not allowed to change permissions for this folder.",

    'filemanager__allow' => "Allow",
    'filemanager__deny' => "Deny",
    'filemanager__user_domusr' => 'Website administrator',
    'filemanager__user_webusr' => 'Web user',
    'filemanager__user_admins' => 'Administrators',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'ASP.NET user',
    'filemanager__user_poolusr' => 'Application pool user',
    'filemanager__user_sysaccount' => 'Additional system user',

    'bt_permissions_advanced' => 'Advanced',
    'b_permissions_advanced' => 'Click to view and set special permissions.',

    'hotlink-protection_invalid_friend_domain' => 'Invalid name for friendly domain.',
    'hotlink-protection_duplicate_friend_domain' => 'Duplicate name for friendly domain.',
    'hotlink-protection_invalid_extensions' => 'File extensions contain improper characters.',

    'i_domain_alias_status_on' => 'Domain alias is enabled.',
    'i_domain_alias_status_off' => 'Domain alias is disabled.',
    'i_domain_alias_status_with_parent' => 'Domain alias is disabled because the domain is turned off.',
    'i_domain_alias_turn_off' => 'Click to disable.',
    'i_domain_alias_turn_on' => 'Click to enable.',

    'domain_alias__control_title' => 'Domain alias %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Service name',
    'domain_alias__control_details_title' => 'Details',

    'domain_alias__invalid_values' => 'The domain name you specified is invalid. Domain names can comprise letters, digits and hyphens. Each part of the domain name between dots should not be longer than 63 symbols.',
    'domain_alias__domain_already_exists' => "Incorrect name of the domain alias %1. The domain %1 already exists.",
    'domain_alias__www_prefix_domain_already_exists' => "Incorrect name of the domain alias www.%1. This alias is already created for the domain %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Incorrect name of the domain alias webmail.%1. This alias is already created for the domain %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Incorrect name of the domain alias lists.%1. This alias is already created for the domain %1.',
    'domain_alias__dns_record_already_exists' => 'Unable to set up the domain alias %1 because a DNS record pointing to the host %1 already exists.',
    'domain_alias__domain_alias_already_exists' => "A domain alias with such a name already exists.",
    'domain_aliases__mail_server_not_support_aliases' => 'The mail server does not support the domain aliases feature. Domain aliases might not function correctly.',
    'domain_alias__restrict_domain_creation' => 'The specified name for a domain alias is prohibited by the server-wide policy. If this domain alias name belongs to you, please contact your hosting provider.',
    'domain_alias__restrict_creation_with_www' => 'Please enter a domain name without the \'www\' prefix. The www prefix for the domain will be automatically added to the web server configuration.',
    'domain_unable_to_set_name' => 'Incorrect name %1.',

    'domain_alias__domain_service_dns_disabled' => 'This domain is served by another DNS server.',
    'domain_alias__domain_service_dns_enabled_master' => 'This DNS server acts as the primary name server for this DNS zone.',
    'domain_alias__domain_service_dns_enabled_slave' => 'This DNS server acts as a secondary name server for this DNS zone.',
    'domain_alias__domain_service_mail_enabled' => 'Mail service is switched on for the domain.',
    'domain_alias__domain_service_mail_disabled' => 'Mail service is switched off for the domain.',
    'domain_alias__domain_service_mail_mx' => '%1 is used as the mail server.',

    'domain_alias__service_seoRedirect_hint' => 'When visitors open the alias\'s URL, they will be redirected to the URL of the primary domain. Plesk uses the search engine-friendly HTTP 301 redirection, which means the search engine ranking will not be split between the URLs.',

    'bt_task_run_now' => 'Run Now',
    'ftp__read_perm' => "Read permission",
    'ftp__write_perm' => "Write permission",

    'filemanager__upload_backup_file_hint' => 'Here you can upload backup files to the Plesk storage. The maximum file size is limited to two gigabytes.',

    '__default_for_mssql' => 'default for MS SQL',

    '__login_does_not_pass_validation' => "The username is invalid. Make sure it meets the following requirements: %1",
    '__login_allowed_symbols' => 'Only alphanumeric characters including periods, dashes, and underscores are allowed. The first character should be alphanumeric.',

    'restart__nginx' => 'Reverse Proxy Server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "I would like to receive general product information and announcements from Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "I would like to receive security-related information and other technical notifications from Plesk.",

    '__login_status_inactive' => 'Your account is inactive. Please contact the Plesk administrator.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Return to the Tools & Settings page. The migration will be continued in the background.',

    'ui__admin-alias-info__description' => "Edit contact information of the additional administrator account.",
    'ui__admin-alias-info__short-title' => "Contact information",
    'ui__admin-alias-info__title' => "Additional Administrator Account Information",
    'ui__admin-alias-password__description' => "Change the additional administrator's password.",

    'ui__admin-alias-password__short-title' => "Change password",
    'ui__admin-alias-password__title' => "Additional administrator's password",
    'ui__admin-alias__description' => "View and change additional administrator accounts information.",

    'chk_js__warning_about_ftp_login_syntax' => "You can use alphanumeric, dash and underscore symbols in the username.",
    'chk_js__warning_about_passwd_syntax' => "Do not use quotes, space and national alphabet characters in a password.\nThe password should be between %1 to %2 characters in length, and it should not contain the username.",
    'chk_js__warning_about_plesk_login_syntax' => "You can use lowercase alphanumeric, dot, dash and underscore symbols in the username.",
    'chk_js__warning_about_admin_passwd_syntax' => "Do not use quotes, space, semicolon, and national alphabet characters in a password.\nThe password must be between %1 and %2 characters long, and it must not contain the username.",

    'cmd_server__admin_alias_not_found' => "Unable to find the additional administrator account.",

    'panel_branding__skins_already_exists' => "Note: The theme '%1' already exists. It will be replaced with the theme you are currently installing.",
    'panel_branding__skins_file_exists' => "Unable to create a directory for the theme '%1': A file with such a name already exists.",

    'actionlog__login_failed' => 'failed to log in',
    'actionlog__event_cp_user_login_failed' => 'Plesk user failed to log in',
    'actionlog__api_login_failed' => 'failed to log in through API',
    'actionlog__event_cp_user_api_login_failed' => 'Plesk user failed to log in through API',
    'actionlog__pw_reset' => 'requested password reset',
    'actionlog__pw_admin_force_reset' => 'requested forced admin\'s password reset',

    'ch_pass_admin__email_subject' => "Plesk password reminder",
    'ch_pass_admin__email_body' => "Hello, %1.\n\nThe administrator password cannot be sent by email for security reasons.\n\nTo log in as 'admin', use the 'plesk login' command.\n\nTo set a new 'admin' password, use the 'plesk bin admin --set-password -passwd <new_password>' command\n\n",
    'ch_pass_admin__message_send_error' => 'Unable to send the email: %1',

    'ch_pass_by_secret__email_subject' => "Plesk password reminder",
    'ch_pass_by_secret__email_body' => "Hello %2,\n\nTo set up a new password, follow the link: %1\n\nYour login: %3",
    'ch_pass_by_secret__message_send_error' => 'Unable to send the secret code: %1',
    'ch_pass_by_secret__title' => 'Change Your Password',
    'ch_pass_by_secret__secret' => 'Secret code',

    'custom_button__noframe' => "Do not use frames",

    'custom_button__internal_hint' => 'Specify whether to open the URL on a Plesk page or in a new browser window.',
    'custom_button__noframe_hint' => 'If you add a custom button which leads to a Plesk extension or an app in the Customer Panel, you can specify how this extension/app should be displayed: in a frame or as a part of the Plesk GUI.',


    'actionlog__patch' => 'Update',
    'actionlog__patch_available' => 'available',
    'actionlog__event_patch_available' => 'Update available',
    'actionlog__patch_installed' => 'installed',
    'actionlog__event_patch_installed' => 'Update installed',

    'actionlog__extension' => 'Extension',
    'actionlog__extension_status' => 'Extension status',
    'actionlog__cloning' => 'Server cloning',
    'actionlog__cloning_complete' => 'complete',
    'actionlog__event_cloning_complete' => 'Server cloning complete',

    'actionlog__ssl_web_binding' => 'SSL/TLS certificate on domain',
    'actionlog__ssl_web_binding_update' => 'assigned/unassigned',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS certificate on domain assigned/unassigned',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS certificate on webmail',
    'actionlog__ssl_web_mail_binding_update' => 'assigned/unassigned',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS certificate on webmail assigned/unassigned',

    'actionlog__ssl_mail_binding' => 'SSL/TLS certificate on mail server',
    'actionlog__ssl_mail_binding_update' => 'assigned/unassigned',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS certificate on mail server assigned/unassigned',

    'actionlog__ssl_panel_binding' => 'SSL/TLS certificate on Plesk',
    'actionlog__ssl_panel_binding_update' => 'assigned/unassigned',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS certificate on Plesk assigned/unassigned',

    'actionlog__hostname' => 'Server hostname',
    'actionlog__hostname_changed' => 'changed',

    'actionlog__smb_user' => 'Additional user',
    'actionlog__smb_user_create' => 'Additional user created',
    'actionlog__smb_user_delete' => 'Additional user deleted',
    'actionlog__smb_user_update' => 'Additional user updated',

    'actionlog__event_mail_management_status_update' => 'Mail management status update',
    'actionlog__mail_management' => 'Mail management status',
    'actionlog__mail_management_status_update' => 'updated',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Total by domains',

    'passwordSecurityLevelCheckFailed' => 'Your password is not complex enough. According to the server policy, the minimal password strength is %1. To improve the password strength, use numbers, upper and lower-case characters, and special characters like !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Very weak',
    'passwordSecurityLevelCheckFailedWeak' => 'Weak',
    'passwordSecurityLevelCheckFailedMediocre' => 'Medium',
    'passwordSecurityLevelCheckFailedStrong' => 'Strong',
    'passwordSecurityLevelCheckFailedStronger' => 'Very strong',

    'ui__client/domain/dns/sync__description' => 'Apply changes from the server-wide DNS template to the zone.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Unable to apply DNS template changes to the zone because the zone is served by another DNS server.',
    'ui__client/domain/dns/sync__short-title' => 'Apply DNS Template Changes',
    'ui__client/domain/dns/sync__done' => 'The changes from the DNS template were successfully applied to the zone.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Apply changes from the server-wide DNS template to the zone.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Unable to apply DNS template changes to the zone because the zone is served by another DNS server.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Apply DNS Template Changes',
    'ui__client/domain/domain-alias/dns/sync__done' => 'The changes from the DNS template were successfully applied to the zone.',
    'dns__dns_default_ipv4_modified' => 'Records with this IP address will be considered as user-modified and will not synchronize with the server-wide DNS template.',
    'dns__dns_default_ipv6_modified' => 'Records with this IP address will be considered as user-modified and will not synchronize with the server-wide DNS template.',

    'dns__view_dns_record_master_title' => 'Viewing Resource Records',
    'dns__view_dns_record_off_title' => 'Viewing Nameserver Records',
    'dns__view_dns_record_slave_title' => 'Viewing Primary DNS Server Records',

    'dns_unable_to_resolve_hostname' => "Unable to resolve the hostname \"%1\": %2\nMake sure that the operating system`s DNS resolver is set up and works properly.",

    'no_database_server_available' => 'There are no database servers available for this subscription.',

    'database_used_by_application_can_not_be_moved' => 'Unable to move the database: A website application uses this database.',
    'database_user_update_orphaned_is_restricted' => 'Updating of orphaned database user accounts is prohibited. You can only delete or repair them.',

    'database_unable_to_get_max_filesize_default_message' => 'Unable to determine the maximum file size of the database: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Unable to set the maximum file size of the database: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Unable to determine the maximum log file size of the database: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Unable to set the maximum log file size of the database: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Unable to determine the current limit on the file size of the Microsoft SQL database \'%1\'. Setting a new limit is impossible.',
    'database_unable_to_set_max_filesize' => 'Unable to set the limit for the file size of the Microsoft SQL database \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Unable to determine the current limit on the log file size of the Microsoft SQL database \'%1\'. Setting a new limit is impossible.',
    'database_unable_to_set_max_log_filesize' => 'Unable to set the limit for the log file size of the Microsoft SQL database \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Unable to create the Microsoft SQL database \'%1\': Its file size is greater than the maximum allowed size.',
    'database_unable_to_move_because_max_filesize' => 'Unable to move the Microsoft SQL database \'%1\': Its file size is greater than the maximum allowed size: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Unable to create the Microsoft SQL database \'%1\': Its log file size is greater than the maximum allowed size.',
    'database_unable_to_move_because_max_log_filesize' => 'Unable to move the Microsoft SQL database \'%1\': Its log file size is greater than the maximum allowed size: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Unable to restore the Microsoft SQL database \'%1\': Its file size is greater than the maximum allowed size.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'An identical MS SQL server is already registered in Plesk. Please specify another MS SQL server as a sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'An identical sandbox MS SQL server is already registered in Plesk. Please specify another MS SQL server as a sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Unable to connect to the server via \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'The feature %1 is not supported by the following service nodes: %2. This feature will be disabled for all objects created on these nodes.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'The feature %1 is not supported by this server. This feature will be disabled for all restored objects.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'The component %1 is not installed. It will be unavailable for the following websites: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'The component %1 is not installed. It will be replaced with %2 for the following websites: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'The current Plesk version does not support usernames with the period (.) character. Customers and resellers with such usernames will not be restored.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Unable to find a backup file with the data for the %1 %2. The data for the %1 %2 will not be restored.',

    'bu_conflict_resolver_zone_master_removed' => "Unable to restore the primary DNS record: The record in the secondary zone points to the existing IP address %1. The primary DNS record will be removed from the secondary zone.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Support for HTTPS DNS records is turned off. HTTPS records will not be restored for the following domains: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 is not supported.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 is not supported. It will be unavailable for the following websites: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'The component %1 is not installed.',
    'bu_conflict_resolver_disabled_in_multi_server' => ' It will be unavailable for the following service nodes: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => ' It will be unavailable for the following objects: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'The following database servers are not available on this server: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'Smarthost management is not supported. The smarthost settings will not be restored.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL database backup file is stored in MS SQL native format, which can be restored only to the local MS SQL server or to a remote MS SQL server with fully configured backup settings. Some of your databases were not restored because there is no appropriate MS SQL server registered in Plesk. The following domains were affected: {{objects}}. Please contact your hosting provider.',

    'bu_conflict_resolver_not_available_webmail' => 'The webmail service %1 is unavailable. It will be replaced with %2 for the following objects: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'The webmail service %1 is unavailable. It will be replaced with %2 for the following service plans: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Databases of the '%1' type do not support user names coinciding with database names. The user '%2' will be renamed '%3' for the database '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'The limit on disk space usage is not set in the destination server configuration. The value of this setting will be changed to "Unlimited".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'The limit on the number of connections is not set in the destination server configuration. The value of this setting will be changed to "Unlimited".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'The limit on traffic usage is not set in the destination server configuration. The value of this setting will be changed to "Unlimited".',
    'cu__pleskrestore_backup_file_extracted' => 'The backup file was extracted to "%1".',
    '__mod_bw_not_supported' => 'The module mod_bw for the Apache web server is not supported due to the configuration of the file system. The limits on traffic usage and the maximum number of connections will not work.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'POP3 authorization for mail relaying is not supported, POP3 before SMTP authorization will be used instead. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Service plan \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 is not supported. It will be replaced with %2 for the following service plans: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 is not supported. It will be replaced with %2 for the following websites: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'The following objects were not found in the backup file: %1',
    'bu_conflict_resolver_absent_domains' => 'Some objects cannot be restored because they belong to the following domains that are not found in Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Some websites cannot be restored because they belong to the following parent domains that are not found in Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Unable to restore DNS zones: The DNS service is turned off in the server configuration.',
    'bu_conflict_resolver_mail_not_supported' => 'Unable to restore mailboxes: The mail service is turned off in the server configuration.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'The specified CPU limit action is not supported by the IIS web server. The value will be reset to %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'server SSL/TLS certificate %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS certificate %2 of the domain %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS certificate %1',
    'bu_conflict_resolver_absent_objects' => 'The contents of the following objects cannot be restored because the objects are not found in Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'The contents of the following mailboxes cannot be restored because the mailboxes are not found in Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'The contents of the following mailing lists cannot be restored because the mailing lists are not found in Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'The contents of the following databases cannot be restored because the databases are not found in Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'The restoration of application "%1" on "%2" has failed because another application is already installed to "%3". You can remove the installed application and try again.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'The mail auto-reply function is not supported.',
    'bu_conflict_resolver_not_available_mail_content' => 'The mail content restoration is not supported.',
    'bu_conflict_resolver_invalid_mail_name' => 'The following mailboxes have not been restored because email subaddressing is enabled and certain email addresses contain sign "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'The following users have not been restored because email subaddressing is enabled and certain email addresses contain sign "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'The following licenses are expired and will not be restored: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'The following licenses are not valid or expired and will not be restored: {{objects}}',
    'expiration_unsupported' => "The limit 'expiration' is not supported.",

    'component_name__dbconnector' => "Database Connector",
    'component_name__mysqlserver' => 'MariaDB/MySQL Server',
    'component_name__troubleshooting' => 'Troubleshooting',
    'component_name__savi' => 'Sophos Anti-Virus Interface',

    '__subscription_has_no_license_key' => 'The subscription resources are provided by the service node #%1 which does not have an associated license key.',
    '__subscription_has_expired_license_key' => 'The subscription resources are provided by the service node #%1 whose license key %2 has expired.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Unable to save configuration files',
    '__cfgmonConfigurationFileSaveErrorBody' => "Unable to save some configuration files on the host <%%host%%>: The following errors occurred:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'This option enables an ability to configure VERP-style email addresses for mail lists',
    'mail__enter_right_ip_mask' => "Enter the IP mask between 1 and 32",
    'mail__enter_right_ip_mask_24' => "Enter the IP mask between 24 and 32",
    'mail__invalid_dom_name' => "The domain name %1 is invalid.",
    'mail__invalid_pop_lock_time' => "POP3 lock time is invalid.",
    'mail__invalid_rbl_server' => "The DNS zone name is invalid.",
    'mail__total_files_size' => "Total repository size: %1",
    'mail__filename_already_in_repository' => "A file with the same name is already in the repository",
    'mail__no_white_list_mask_feature_24' => "Use a mask value of 24 or higher.\nYour mail server does not support setting masks. We can only emulate setting mask for values not less than 24.",
    'mail__unable_add_new_mail_name' => "Unable to add the mail account: %1",
    'mail_server_is_not_installed' => 'The mail server (Postfix or Qmail) is not installed. Install it to continue work.',
    'mail_server_not_available' => 'There are no supported mail servers available on the service node.',
    '__not_installed' => '(not installed)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Spam filtering on outgoing email messages is disabled.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'The service node does not support limiting the number of outgoing email messages from a domain for the domain %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'The service node does not support limiting the number of outgoing email messages from a mailbox for the domain %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Specify an address of at least one type (IPv4 or IPv6).',

    'mail__outgoing_email_mode_invalid' => 'An invalid outgoing mail mode was specified.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'An invalid IPv4 address was specified.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'An invalid IPv6 address was specified.',
    'mail__outgoing_email_mode_unavailable' => 'Changing the outgoing mail mode is not supported, probably because the Postfix mail server is not installed on this server.',

    'mail__autoresponder_attachment_not_supported' => 'The currently used mail server does not support auto-responder attachment management.',

    'mail__smtp_white_list_not_supported' => 'The currently used mail server does not support IP address whitelisting.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR masks are not supported by the currently selected mail server. Specify IP address in format \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'Wildcard IP patterns are not supported by the currently selected mail server. Specify IP address in format \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Unable to change the settings for the DKIM verification service',

    'sfdk_domain__serverwide_disabled' => 'Switched off according to the server policy',
    'feature__domainkeys__serverwide_disabled' => 'Server-wide DKIM spam protection is switched off',

    'defaultcomponents__error_set_default' => 'Unable to set %1 as the default %2: %3',
    'defaultcomponents__error_set_default_none' => 'Unable to set no default component for %1: %2',
    'defaultcomponents__required_package_not_default' => 'The component %1 required for its work is not default.',

    '__percentage' => '%',
    '__seconds' => 'Seconds',
    '__resource_remain' => 'Remaining',

    '__not_registered' => '(not registered)',
    '__php_handler_id' => 'PHP version',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'The PHP handler "%1" is not registered. It was probably deleted from the server. Register a handler with the same properties and try again.',
    '__php_handler_not_registered_on_domain' => 'Domain "%1": the PHP handler "%2" is not registered. It was probably deleted from the server. Register a handler with the same properties and try again.',
    '__php_fpm_handler' => 'FPM application',
    '__php_fpm-dedicated_handler' => 'Dedicated FPM application',

    'mailname_create_assigned_user_dublicate_error' => 'Unable to create a user for the mailbox. The user with the username %1 already exists and has another mailbox.',
    'mailname_create_assigned_user_role_absent_error' => 'Unable to create a user for the mailbox. The default role %1 of the user does not exist.',

    'gphd__mime_types' => 'MIME types',
    'gphd__handlers' => 'Apache handlers',
    'gphd__ip_restrictions_allow' => 'Allow access to the site for specified hosts and networks (excluding the denied ones)',
    'gphd__ip_restrictions_deny' => 'Deny access to the site for specified hosts and networks',
    'gphd__directory_index' => 'Index files',
    'gphd__nginx_transparent_mode' => 'The mode when Apache handles both static and dynamic content, while nginx only passes HTTP requests and responses without modification.',
    'gphd__nginx_serve_static' => 'Serve static files directly by nginx',
    'gphd__nginx_static_extensions' => 'Static files extensions which must be handled by nginx',
    'gphd__nginx_serve_php' => 'Process PHP files by nginx',
    'gphd__www_root' => 'WWW Root Directory',

    'eol__none' => 'do not modify',
    'eol__lf' => 'convert to Unix style',
    'eol__cr' => 'convert to MacOS style',
    'eol__crlf' => 'convert to Windows style',

    'ui__dns_bad_zone' => 'Inconsistent zone "%1": ',
    'ui__dns_ns_has_no_address_records' => 'The NS record "%1" has no address records (A or AAAA).',
    '__dns_bad_zone' => 'Inconsistent zone "%1": ',
    '__dns_ns_has_no_address_records' => 'The NS record "%1" has no address records (A or AAAA).',
    '__dns_ptr_is_wildcard' => 'The PTR record "%1" is invalid: The record points to a wildcard domain.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Allow remote access for the database user \'%3\' of the customer \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Unable to allow remote connections for the database user \'%1\': Unable to determine the TCP port number used by Microsoft SQL server \'%2\'. The possible reasons are the following: the TCP/IP protocol is not enabled in the server network configuration or the server is configured to use dynamic TCP ports. Configure the server to listen on a specific fixed TCP port and try to allow remote connections again.',

    'command__convertResellerHasCustomer' => 'The reseller account \'%1\' has one or several customer accounts. To convert this reseller account to a customer account, first transfer these customer accounts to a new owner or convert them to reseller accounts.',
    'command__convertResellerNotReseller' => 'Only reseller accounts can be converted to customer accounts. \'%1\' is not a reseller.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Could not sync the subscription with the service plan. The following settings of the subscription conflict with the service plan: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'The account \'%1\' is a reseller account. Reseller accounts cannot be moved to a new owner because they are owned by the server administrator.',
    'moveCustomer__wrong_owner_type' => "The customer account \'%1\' can be moved only to a reseller or admin, not to another customer.",
    'moveCustomer__customer_already_belongs_to_owner' => 'The customer account \'%1\' already belongs to the selected owner.',
    'upgradeClient__user_is_admin' => 'The account \'%1\' cannot be converted to a reseller account because this is an administrator account.',

    'mail__error_setting_max_connections_courier' => 'Unable to set the maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Unable to set the maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Unable to set the maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) per IP address: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Unable to set the maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) per IP address for a specific mail user: %1',
    'outgoing_messages_limit_value_invalid' => 'The value must be in the range %%MIN%%..%%MAX%%. Only the Plesk administrator can adjust this setting.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "The following domains use external email addresses for mail forwarding of mail sent to non-existed addresses. The messages sent to these addresses will not be counted in Outgoing Mail Control:\n %1",
    'outgoing_messages_white_list_not_empty' => 'The limits on outgoing mail will not work for mail senders whose IP addresses are in the mail server\'s white list. For example, if there is localhost (127.0.0.0 / 8, ::1 / 128) in the white list, all mail from the local server will be successfully sent regardless of the limitations. Mail senders can use either local IP addresses (websites and custom scripts hosted on the local server) or external ones (customers who send mail from mail clients installed on their computers or mobile devices). To make the limits work for all mail senders (both local and external), remove all IP addresses and networks from the white list. Note that removing localhost (127.0.0.0 / 8, ::1 / 128) from the white list might disrupt the operation of websites and scripts that send mail from this server. For details about limitations on outgoing mail, see the Administrator\'s Guide, Protection from Outbound Spam.',
    'outgoing_messages_relay_open' => 'The mail relay is open: The limits on outgoing mail will not work.',

    'notification_aps_app_updates_available' => 'Updates are available for the following applications:',
    'notification_aps_app_updates_installed' => 'Updates were automatically installed for the following applications:',
    'notification_aps_app_updates_requirements' => 'Updates are available for the following applications but cannot be installed because hosting settings of the corresponding websites do not meet installation requirements:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" on %%parentName%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Theme "%%name%%" on %%parentName%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" on %%parentName%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Theme "%%name%%" on %%parentName%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Your version: %%from%%. Available  version: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" on %%parentName%% (%%url%%). Your version: %%from%%. Available  version: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Theme "%%name%%" on %%parentName%% (%%url%%). Your version: %%from%%. Available  version: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). New version: %%to%%. Previous version: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). New version: %%to%%. Previous version: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). New version: %%to%%. Previous version: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installed version: %%from%%. Available  version: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Your version: %%from%%. Available  version: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'external app',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domains',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Email Addresses',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Subscriptions',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 messages per hour',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Unlimited',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, the limit is %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 attempt(s) to exceed limits from %2 to %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 attempt(s) to exceed limits from %2 until now',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP Address Banning (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'The Fail2ban component is not installed on the destination server.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Install Fail2ban. Note that this may take a few minutes.',

    'plesk_key__no_reseller_support' => 'You cannot manage resellers due to license restrictions.',
    'plesk_key__no_customers_support' => 'You cannot manage customers due to license restrictions.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Unable to switch to the Service Provider view due to license restrictions.',
    'plesk_key__no_security_core_support' => 'The security core features (ModSecurity and Fail2Ban) are not available due to license restrictions.',
    'plesk_key__outgoing-antispam' => 'Outgoing Mail Control',
    'plesk_key__security-core' => 'Security Core (ModSecurity and Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Accounts management',
    'plesk_key__can-manage-subscriptions' => 'Subscriptions management',
    'plesk_key__can-manage-customers' => 'Customers management',
    'plesk_key__can-manage-resellers' => 'Resellers management',
    'plesk_key__can-manage-custom-view' => 'Restricted Mode availability',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Subscriptions management is turned off but you have several subscriptions (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Resellers management is turned off but you have several resellers (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Customers management is turned off but you have several customers (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Certain subscription resources you can no longer manage in the Plesk interface (such as limits on mailboxes and domains\' disk space) are now set to unlimited.',
    'plesk_key__no_subscriptions_support' => 'You cannot manage subscriptions due to license restrictions.',
    'plesk_key__no_custom_view_support' => 'You cannot use Restricted Mode due to license restrictions.',
    'plesk_key__trial_forbidden_region' => 'Sorry, Plesk is currently not available in your region.',
    'additional_key__main_key' => 'The key is a main key: You cannot upload a main key as an additional key.',

    'gch__hosting_waf_rule_engine' => 'Web application firewall mode',

    'backup__fieldset__restoration_options' => 'Restoration options',
    'backup__restore_options__restore' => 'Restore',
    'backup__restore_options__domain__domain_configuration' => 'Domain configuration',
    'backup__restore_options__domain__virtual_host_content' => 'Virtual host content',
    'backup__restore_options__domain__mail' => 'Mail',
    'backup__restore_options__domain__databases' => 'Databases',
    'backup__restore_options__client__client_configuration' => 'Customer account configuration',
    'backup__restore_options__client__domains' => "Customer's domains",
    'backup__restore_options__reseller__reseller_configuration' => 'Reseller account configuration',
    'backup__restore_options__reseller__personal_domains' => "Reseller's domains",
    'backup__restore_options__reseller__clients' => "Reseller's customers",
    'backup__restore_options__admin__server_configuration' => 'Server settings',
    'backup__restore_options__admin__administrator_configuration' => 'Administrator account configuration',
    'backup__restore_options__admin__personal_domains' => "Administrator's domains",
    'backup__restore_options__admin__personal_clients' => "Administrator's customers",
    'backup__restore_options__admin__resellers' => 'Resellers',

    'badge_new' => 'New',
    'upgrade_php_on_subscription' => 'Upgrade PHP on your subscription to version 5.3.0 or later.',

    'pkey_notify__body_expiration_notification' => 'The license key is expired. Some features can be unavailable. Please contact your hosting provider.',

    'crontab__crontab_entry_exists' => "The scheduled task already exists.",
    'crontab__crontab_entry_not_exists' => "The scheduled task does not exist.",
    'crontab__invalid_values_found' => "Incorrect parameter values.",
    'crontab__cmd_max_len' => "The command cannot be longer than %1 characters.",

    'domain__domain_exists' => "There is a domain with the 'www' prefix and the same name: %1.%2.",
    'domain__subdomain_exists' => "There is a subdomain with the 'www' prefix and the same name: %1.%2.",
    'domain__dalias_exists' => "There is a domain alias with the 'www' prefix and the same name: %1.%2.",
    'domain__record_exists' => "There is a DNS record pointing to the host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certificate '%1' cannot be set as default one: private key is missing.",
    'ip_addr__update_dns_error' => 'Issues occurred while updating the IP address in DNS zones. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Cannot add the IP address. This network interface obtains IP addresses automatically.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Cannot remove the IP address %1. This network interface obtains IP addresses automatically.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Cannot repair the IP address %1. This network interface obtains IP addresses automatically.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Cannot change the interface of the IP address %1 because the network interface %2 obtains IP addresses automatically.',

    'shm_lmsg__limit_for_resource_exceeded' => 'The subscription\'s limit on the number of %%type%% is exceeded. The limit is %%limit%%, and %%usage%% is currently being used.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'The creation of %%type%% is not permitted for this subscription.',
    'shm_lmsg__resource_title__db-mysql' => 'MariaDB/MySQL databases',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL databases',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL databases',
    'shm_lmsg__resource_title__db-user' => 'database users',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS application pools',
    'shm_lmsg__resource_title__additional-ftp-account' => 'additional FTP accounts',

    'db_user_unable_remove_mysql_global_privileges' => 'Unable to remove MariaDB/MySQL global privileges of the database user %1. Reason: %2',
    'report__client_description' => 'Description',

    'db__user_role_error' => 'Incorrect database user\'s role was specified: %1. Please choose one of the following roles: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Unable to set the file size limit for the following Microsoft SQL Server databases because they have a greater file size: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Unable to set the log file size limit for the following Microsoft SQL Server databases because they have a greater log file size: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Unable to set up a public IP address: a private IP address must exist.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Unable to set up a public IPv4 address for the IPv6 address.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Unable to set up a public IPv6 address for the IPv4 address.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Unable to set up a public IP address: invalid IP address.',

    '__user_already_exists' => "The user %1 already exists.",
    '__user_name_is_empty' => "Please specify a user name.",

    'upgrade_php_on_domain' => 'Unable to find the PHP version 5.3.0 or later on any of your WordPress domains. Try to upgrade PHP.',

    'component_name__waf' => 'Web Application Firewall',
    'component_name__vcs' => 'Version Control System',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'A possible spoofing attempt was detected: The link attempted to display irrelevant content.',
    'forceResetPasswordUpdated' => 'Your password was changed. Use the new password to log in to Plesk.',

    'php_handlers_error_no_available_instance' => 'Unable to create a domain: there are no available PHP handlers.',
    'domain_error_unable_to_apply_hosting_settings' => 'Unable to apply hosting settings: %1',

    'plesk_not_configured' => 'Plesk is not configured. Go to the control panel to perform post-installation configuring.',
    'cmd_mail__mail_password_duplicated' => 'The specified pair of email address and password already exists on the mail server. Please specify another email address or password.',

    'extensionRequirementOs' => 'The operating system (%1) is not supported by the package.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 is the earliest version supported by the package.',
    'extensionRequirementPleskMaxVersion' => 'Versions starting from Plesk %1 are not supported by the package.',
    'extensionBlacklisted' => 'The extension %1 is not allowed for installation.',
    'extensionDisabled' => 'The extension is disabled.',


    'optimization_settings__unable_set_mpm_event' => 'Unable to set the mpm_event mode: it requires Apache PHP5 module turned off but this module is used by domains.',
    'optimization_settings__unable_turn_off_php' => 'Unable to turn off the Apache PHP5 module: it is used by domains.',

    'hst_def__fp_admin_login' =>  'FTP Username',
    'hst_def__fp_admin_passwd' =>  'FTP Password',

    'database_user_orphaned_old_password_wrong' => "Unable to repair the orphaned user '%1': the password is incorrect.",
    'cannot_load_partner_central_property_key_no_exist' => "Unable to retrieve custom properties: the license key does not exist.",
    'extensionScriptFailure' => "The execution of %1 has failed with the following message:\n%3",
    '__ssl_redirect' => "Permanent SEO-safe 301 redirect from HTTP to HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM management is not supported.',
    'mail__dmarc_not_supported' => 'DMARC management is not supported.',
    'mail__relay_white_list_not_supported' => 'Relay whitelist management is not supported.',
    'mail__black_list_not_supported' => 'Blacklist management is not supported.',
    'mail__autoresponder_not_supported' => 'Auto-responder management is not supported.',
    'defaultcomponents__not_supported_version' => '(not supported version)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'The certificate \'%1\' was not found.',
    'certificate__unable_setup_certificate' => 'Unable to install the certificate: The private key and certificate contents are missing.',
    'certificate__used_by_panel' => 'One of the certificates you are going to delete is used for securing Plesk.',
    'certificate__used_by_mail_server' => 'One of the certificates you are going to delete is used for securing the mail server.',
    'certificate__used_by_domain_service' => 'One of the certificates you are going to delete is used by domain service.',
    'mail_server__not_installed' => 'Unable to install the certificate for the mail server because the mail server is not installed.',

    'email_activation_mail_subject' => 'Please activate your account in Plesk',
    'email_activation_mail_body' => "An account was created on the Plesk server %1\n\nAccount's details:\nName: %2\nE-mail address: %3\n\nIf this information is correct and the account was created for you, please activate it with the following link:\n\n%4\n\nBy activating the account, you authorize the server holder to collect, store, process, and use your personal data (name and email) for creating and supporting your account, in accordance with the applicable data protection laws currently in effect, as a part of a contract.",

    'backup_transport_permission_name' => '%1 management',
    'backup_transport_permission_description' => 'Allows to use %1 for storing backups.',

    'domain_move_err_target_no_hosting' => 'Unable to move the domain to a subscription without hosting.',
    'domain_move_err_already_in_target' => 'The domain already belongs to the target subscription.',
    'domain_move_err_main_domain' => 'The main domain cannot be moved.',
    'domain_move_err_subdomain_without_parent' => 'Unable to move the subdomain %1 without the parent domain %2.',
    'domain_move_err_root_exists' => 'The target path for www_root %1 already exists.',
    'domain_move_err_nested_roots' => 'Unable to move the domain because it shares the document root with another domain: %1.',
    'domain_move_err_no_mail_service' => 'Unable to move the domain because the mail service is disabled on the target subscription.',
    'domain_move_err_app' => "The application installed on %1 was not moved to the subscription '%2': %3",
    'domain_move_database_used_by_app' => "The database '%1' on %2 is used by the moved application. To reassign the database to '%3', run `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "The target subscription '%1' was locked for sync.",
    'domain_move_filesharing_disabled' => 'File sharing was disabled.',
    'domain_move_website_preview_disabled' => 'Website preview was disabled.',
    'domain_move_additional_webserver_settings' => "Review the domain's additional web server directives to prevent broken configuration.",
    'domain_move_no_permission' => "%1 is not allowed for the subscription '%2'.",
    'domain_move_no_access' => "No access to the subscription '%1'.",
    'domain_split_no_create_permission' => "Domain creation is not allowed.",
    'domain_split_empty_login' => 'The system user login is required.',
    'domain_split_empty_password' => 'The system user password is required.',
    'domain_split_err_home_exists' => 'The domain %1 cannot be moved because its target home path already exists in %2. Rename the domain to move it to a new subscription.',
    'domain_split_err_no_hosting_subdomains' => 'The domain cannot be moved to a new subscription because the domain does not have hosting but has subdomains. To move the domain, change its "Hosting type" value to "Website hosting" (in Hosting Settings).',
    'domain_split_target_locked' => "The target subscription '%1' is locked for sync.",
    'domain_split_target_unsynced' => "The target subscription '%1' was not synced with the plan due to: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Scheduled backup was deactivated on '%1'.",
    'domain_merge_database_error' => "The database '%1' on %2 was not moved to the subscription '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Anonymous FTP on '%1' was switched off.",
    'domain_merge_smb_user_access' => "The additional user '%1' was moved to the subscription '%2' but the user's access to the subscription was revoked.",
    'domain_merge_scheduled_tasks' => "Scheduled tasks were moved to the target subscription. Review the tasks configuration.",
    'domain_merge_scheduled_tasks_deactivated' => "Scheduled tasks were moved to the target subscription and deactivated. Review the tasks configuration.",
    'domain_merge_no_remove_permission' => "Removing subscriptions is not allowed.",
    'domain_merge_err_has_addons' => 'Cannot move the main domain with its additional domains; move the domain(s) %1 first.',
    'domain_merge_err_has_webusers' => 'Cannot move the main domain with its web users.',
    'domain_merge_err_root_exists' => 'The target path %1 already exists.',

    'database_server_edit_used_for_psa' => 'Updating of local MariaDB/MySQL database server is not allowed.',
    'suggest_repair_main_suggestion_ui' => '<b>You can fix this error</b> using the `plesk repair` utility.',
    'suggest_repair_main_suggestion_cli' =>  'You can fix this error using the `plesk repair` utility.',
    'suggest_repair_repair_kit_link_title' => 'go to Diagnose & Repair',
    'suggest_repair_using_cli_and_ui' => 'To do so, either run the `plesk repair %1` command via the CLI or %2 and click Repair next to “Plesk Database”',
    'suggest_repair_using_cli' => 'To do so run the `plesk repair %1` command via the CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'The DNS service was unavailable when the backup was created. However, there are active DNS zones in the backup and they will be enabled for the following objects: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Resource Controller (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Support of remote SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(not allowed by license key)',
    'plesk_key__validation_failed' => '%1 (Error code: %2)',
    'promo__button_details' => 'Details',
    'promo__extension_catalog_title' => 'Extension Catalog',
    'promo__extension_catalog_description' => 'Check out the new extension catalog and supercharge your Plesk through a variety of powerful extensions!',
    'promo__button_open_catalog' => 'Open the Catalog',

    'backup__repository_check_login' => "Unable to access the storage: %1\nMake sure you have entered the correct storage credentials.",
    'backup__repository_check_error_list' => "Unable to access the storage: %1\nMake sure you have entered the correct storage settings.",
    'backup__repository_check_error_mkdir' => "Unable to create the directory: %1\nCheck if you have permissions to create folders in the storage.",
    'backup__repository_check_error_upload' => "Unable to upload the file to the storage: %1\nCheck if you have permissions to upload files to the storage.",
    'backup__repository_check_error_download' => "Unable to download the file from the storage: %1\nCheck if you have permissions to upload and download files from the storage.",
    'backup__repository_check_error_resume-upload' => "Unable to resume an upload of the file to the storage: %1\nCheck if you have permissions to resume uploads to the storage.",
    'backup__repository_check_error_resume-download' => "Unable to resume a download of the file from the storage: %1\nCheck if you have permissions to resume downloads from the storage.",
    'backup__repository_check_error_enable-utf8' => "Unable to operate the storage: %1\nCheck if the storage supports UTF8 encoding.",
    'backup__repository_check_error_rm' => "Unable to operate the storage: %1\nCheck if you have permissions to delete files from the storage.",
    'backup__repository_check_error_rmdir' => "Unable to operate the storage: %1\nCheck if you have permissions to delete folders from the storage.",

    'backup__ftp_repository_check_login' => "%1 You can check them independently with the command:\n  %2",
    'backup__ftp_repository_check_error_list' => "%1 You can check them independently with the command:\n  %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 You can check it independently with the command:\n  %2",
    'backup__ftp_repository_check_error_upload' => "%1 You can check it independently with the commands:\n  %2\n  %3",
    'backup__ftp_repository_check_error_download' => "%1 You can check it independently with the commands:\n  %2\n  %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 You can check it independently with the commands:\n  %2\n  %3\n  %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 You can check it independently with the commands:\n  %2\n  %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 You can check it independently with the command:\n  %2",
    'backup__ftp_repository_check_error_rm' => "%1 You can check it independently with the commands:\n  %2\n  %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 You can check it independently with the commands:\n  %2\n  %3",

    'sfdmarc_server_wide_enable_failed' => 'Unable to change settings for DMARC. To enable this option, please switch on DKIM and SPF spam protection.',
    'spf_server_wide_disable_failed' => 'Unable to change settings for SPF spam protection. To disable SPF, please switch off DMARC for incoming mail.',
    'sfdk_server_wide_verify_disable_failed' => 'Unable to change settings for DKIM spam protection. To disable DKIM, please switch off DMARC for incoming mail.',

    'ccs_not_supported' => 'IIS Central Certificate Store is not configured on system.',
    'ccs_not_enabled' => 'IIS Central Certificate Store management is not enabled in Plesk.',
    'ad_not_supported' => 'The server is not joined to a domain.',

    'component_name__appinit' => "Application Initialization",
    'component_name__cors' => "Cross-Origin Resource Sharing",
    'component_name__httpcompression' => 'HTTP Content Compression',
    'common_feature_is_not_supported' => 'This feature is no longer supported.',
    'common_feature_is_not_supported_in_proto' => 'This feature is not supported for protocol version %1.',
    'autoinstaller__plesk_component' => 'Plesk component',
    'plesk_key__key_expired' => 'Your license key has expired. To continue using Plesk, buy a non-expiring commercial %1.',
    'plesk_key__key_purchase' => 'license key',

    'sa_action_move' => 'Move spam to the "Junk E-mail" folder',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java applications are no longer supported. They will be unavailable for the following websites: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobile versions of websites hosted with UNITY Mobile are no longer supported. They will be unavailable for the following websites: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Server-wide usage policy does not allow using personal antivirus settings. They will be restored incompletely for email accounts on the following domains: {{objects}}',

    'module__not_installed' => "The extension %1 is not installed",

    'mail__mail_autodiscovery_server_error' => 'Specify a custom domain name for mail autodiscover',
    'mail__error_mail_autodiscovery_enable' => 'Unable to set mail autodiscover: %1',
    'mail__error_mail_autodiscovery_server' => 'Unable to set a custom domain name for mail autodiscover: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Unable to reconfigure domains autodiscover DNS records: %1',

    'mail__smarthost_not_configured_error' => 'A smarthost is not configured.',
    'mail__smarthost_attach_domains_error' => 'Attaching domains to the smarthost finished with errors:',

    '__invalid_url' => 'URL "%1" is invalid',
    'actionlog__cloning_start' => 'start',
    'actionlog__event_cloning_start' => 'Server cloning start',

    '__UPLOAD_ERR_FORM_SIZE' => "Uploaded file exceeds the allowed size",
    '__UPLOAD_ERR_INI_SIZE' => "Uploaded file exceeds the allowed size",
    '__UPLOAD_ERR_NO_FILE' => "No file received",
    '__UPLOAD_ERR_OK' => "File successfully uploaded",
    '__UPLOAD_ERR_PARTIAL' => "File was partially uploaded, please try again",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Temporary folder is missing',
    '__UPLOAD_ERR_CANT_WRITE' => 'Failed to write file to disk',
    '__UPLOAD_ERR_UNKNOWN' => 'An unknown file upload error occurred',
    '__accounts' => "Accounts",
    '__access' => "Access",
    '__address' => "Address",
    '__addresses' => "Addresses",
    '__acl_records' => 'ACL Records',
    '__admin_repository' => "Administrator's repository",
    '__all' => 'All',
    '__allowed' => "Allowed",
    '__anonftp_status' => "Anonymous FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 web-server is being restarted, please wait...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET support",
    '__asp_win_support' => "Microsoft ASP support",
    '__attachments' => "Attachments",
    '__attachments_list' => "Attachments",
    '__author' => 'Author',
    '__autoresp_name_already_exists' => "Auto-reply with name %1 already exists.",
    '__autoresponder' => "Auto-reply",
    '__autoresponders' => "Auto-replies",
    '__autoresponders_list' => "Auto-replies",
    '__autoresponder_attachment_files' => "Auto-reply Attachment Files",
    '__auto_updates_list' => 'Available Updates',
    '__avail' => "Available",
    '__backup_utilites' => "Backup Utilities",
    '__bind_status' => "DNS Server status",
    '__bu_is_not_installed' => "This service is not currently available, because the backup utilities were not installed.",
    '__bu_not_support_in_key' => "Backup capability is not supported by the license key.",
    '__notifications_not_support_in_key' => 'Notifications are not supported by the license key',
    'disabled_by_key' => 'Not supported by the license key',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "You cannot use the reserved words.",
    '__certificate' => "Certificate",
    '__cgi_support' => "CGI support",
    '__city' => "City",
    '__cl_not_exist' => "Customer account does not exist.",
    '__client' => 'Customer',
    '__client_card' => "Customer card",
    '__client_contact_name' => "Customer contact name",
    '__client_form' => "Personal information",
    '__client_ip_pool' => "Customer's IP pool",
    '__client_limits' => "Customer account limits",
    '__client_permissions' => "Customer's permissions",
    '__client_preferences' => "Customer's preferences",
    '__client_status' => "Customer status",
    '__client_name' => "Customers's name",
    '__client_total' => "Customer Total",
    '__client_with_login_name_already_exists' => "A user with username \"%1\" already exists.",
    '__client_domuser_with_login_already_exists' => "The username '%1' is already in use by the administrator of the domain '%1'.",
    '__clients_global_changes' => "Modify selected customer accounts",
    '__clients_list' => "Customers",
    '__cmd_not_found' => "Unknown command: %1",
    '__comments' => "Comments",
    '__company_name' => "Company name",
    '__component_version' => "Component version",
    '__component_not_installed' => "The component %1 was not installed",
    '__confirm_overwrite' => "Confirm overwriting.",
    '__confirm_stop' => "You must confirm process stopping.",
    '__confirm_passwd' => "Confirm %1 password",
    '__conhelp' => "Description",
    '__contact_name' => "Contact name",
    '__country' => "Country",
    '__countries' => 'Country',
    '__country_unknown' => 'Unable to recognize the country subcode.',
    '__courier-imap' => 'Courier server',
    '__create_domain' => 'Create a domain',
    '__crypted' => 'encrypted',
    '__cp_access' => "Access to Plesk",
    '__cp_user' => "Plesk User",
    '__create' => "Create",
    '__create_client_template_without_template' => "Create user account without template",
    '__create_domain_for' => "Create a domain for <b>%1</b>",
    '__create_domain_template_without_template' => "Create domain without template",
    '__creation_date' => "Creation date",
    '__crontab_unix' => "Scheduler",
    '__crontab_win' => "Scheduler",
    '__ct_month_jan' => 'January',
    '__ct_month_feb' => 'February',
    '__ct_month_mar' => 'March',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'May',
    '__ct_month_jun' => 'June',
    '__ct_month_jul' => 'July',
    '__ct_month_aug' => 'August',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'October',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'December',
    '__custom_button' => "Custom button",
    '__custom_buttons_list' => "Links to additional services",
    '__daily' => "Daily",
    '__database_not_activated' => "%1 was not activated on the server administration page.",
    '__database_not_installed' => "Database %1 is not installed.",
    '__database_not_run' => "Database %1 is not running.",
    '__database_is_corrupt' => "The Plesk's database is corrupted. Please launch the Reconfigurator utility to fix it.",
    '__databases' => "Databases",
    '__databases_list' => "Databases",
    '__database_type_not_supported_by_key' => 'To use %1 server, you need the support for it in your license key. Please consult your Plesk sales representative.',
    '__date_immediately' => "today",
    '__date_never' => "never",
    '__day(s)' => "Day(s)",
    '__day0' => "Sun",
    '__day1' => "Mon",
    '__day2' => "Tues",
    '__day3' => "Wed",
    '__day4' => "Thurs",
    '__day5' => "Fri",
    '__day6' => "Sat",
    '__days' => "%1 day(s)",
    '__db_admin_login_empty' => "You have entered an empty username, switching off control over %1 in the interface. Do you want to proceed?",
    '__db_unable_to_unregister' => 'Unable to remove parameters of database connection',
    '__db_db_exists' => 'There is at least one database on the server',
    '__db_unable_to_change_server_name' => 'Name for the server cannot be changed',
    '__db_unable_to_change_port' => 'Port for the server cannot be changed',
    '__db_already_exist' => "Database %1 already exists.",
    '__db_credentials_invalid' => "Database credentials are invalid.",
    '__db_invalid_password_characters' => 'The password contains invalid characters',
    '__db_engine' => "Database Engine", // indirect
    '__db_type' => "Database type",
    '__db_user' => "Database user",
    '__db_server' => 'Database server',
    '__def_domain' => "Default domain",
    '__default_for_mysql' => 'default for MySQL',
    '__default_for_mariadb' => 'default for MariaDB',
    '__default_for_percona' => 'default for Percona',
    '__default_for_postgresql' => 'default for PostgreSQL',
    '__delete' => "Delete",
    '__demo' => "This function is not available in the demo version.",
    '__directory' => "Directory",
    '__disable_lock_screen' => 'Prevent users from working with Plesk until interface screens are completely loaded',
    '__dismiss_news?' => "Are you sure you want to completely close the news block?\n\nYou will not be able to see the news block until more news is available.",
    '__description' => "Description",
    '__disabled' => "switched off",
    '__disk_space_limit' => "Disk space limit",
    '__cgroups_cpu_usage_limit' => 'CPU usage limit',
    '__cgroups_ram_usage_limit' => 'RAM usage limit',
    '__cgroups_disk_read_usage_limit' => 'Disk Read Bandwidth limit',
    '__cgroups_disk_write_usage_limit' => 'Disk Write Bandwidth limit',
    '__disk_usage_by' => "Disk space used by %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS record '%1' already exists.",
    '__dns_master_should_be_remote' => "You should have two different authoritative name servers on separate hosts.",
    '__dns_record_not_exist' => "DNS record does not exist.",
    '__dns_server' => "DNS server", // indirect
    '__dom_id_is_undefined' => "Domain ID is undefined.",
    '__dom_name' => "Domain name",
    '__dom_name_is_invalid' => "Domain name is invalid. Please make sure your domain name comprises only alphanumeric, dot and hyphen symbols, and is not greater than 255 symbols in length. Each part of the domain name between dots should not exceed 63 symbols.",
    '__dom_not_exist' => "Domain does not exist.",
    '__domain' => "Domain",
    '__domain_' => 'Domain %1',
    '__domain_form' => "Domain form",
    '__domain_id' => "Domain ID",
    '__domain_is_turned_off_for_backup' => "The website %1 is temporarily turned off for backing up or restoring and is not currently available.",
    '__domain_limits' => "Domain limits",
    '__domain_name' => "Domain name",
    '__mail_name_in_ASCII_form' => "Mail account name in ASCII format",
    '__message_error' => 'Error',
    '__message_warning' => 'Warning',
    '__message_info' => 'Information',
    '__domain_name_in_ASCII_form' => "Domain name in ASCII format",
    '__domain_repository' => "Repository of domain %1",
    '__domain_status' => "Domain status",
    '__domain_found_tech' => "Technology found on domain",
    '__domain_dns' => 'Domain DNS zone',
    '__domain_total' => "Total amount for the subscription",
    '__domain_total_powerUser' => "Total amount for the subscription",
    '__domain_user' => "Domain administrator",
    '__domains_global_changes' => "Modify selected domains",
    '__mailnames_global_changes' => "Modify selected mail accounts",
    '__backup_manager' => 'Backup Manager',
    '__domains_list' => "Domains",
    'domains_list__list_header' => "domains",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "The domain name begins with www, although the WWW prefix is used.\nProceed anyway?",
    '__dovecot' => 'Dovecot IMAP and POP3 server',
    '__dsmail' => "Mail service",
    '__dsmaillist' => "Mailing list service",
    '__dumps_tot_size' => "Total size of backup files in local storage",
    '__email' => "Email",
    '__email_addr_is_invalid' => "Email address is invalid.",
    '__enabled' => "switched on",
    '__enter_cert_text' => "Enter certificate text",
    '__enter_size' => "Enter size",
    '__exclusive' => "Dedicated",
    '__expiration_date' => "Expiration date",
    '__fax' => "Fax",
    '__file' => "File",
    '__file_is_empty' => "File is empty.",
    '__file_name' => "File name",
    '__file_type' => 'File type',
    '__filemanager' => "File Manager",
    '__filepath_is_empty' => "Path to file is empty",
    '__files_list' => "Files",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP settings",
    '__ftp_serv' => "FTP server", // indirect
    '__ftp_server_parameters_are_empty' => "You should set the FTP account properties first!",
    '__ftp_status' => "FTP server status",
    '__full_day0' => "Sunday",
    '__full_day1' => "Monday",
    '__full_day2' => "Tuesday",
    '__full_day3' => "Wednesday",
    '__full_day4' => "Thursday",
    '__full_day5' => "Friday",
    '__full_day6' => "Saturday",
    '__full_month1' => "January",
    '__full_month10' => "October",
    '__full_month11' => "November",
    '__full_month12' => "December",
    '__full_month2' => "February",
    '__full_month3' => "March",
    '__full_month4' => "April",
    '__full_month5' => "May",
    '__full_month6' => "June",
    '__full_month7' => "July",
    '__full_month8' => "August",
    '__full_month9' => "September",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Hard disk quota",
    '__hard_disk_quota_not_supported' => 'hard disk quota is not supported due to configuration of server file system',
    '__help_topic_not_found' => 'The help topic you requested (%1) does not exist.',
    '__hosting_ip_dns_ip_not_equiv' => "None of IP addresses specified in A DNS records match the IP address used for hosting.",
    '__hosting_scripting' => "Hosting scripting support",
    '__hosting_setup_page_title' => "Web hosting setup for domain %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Hosting type",
    '__hostname_is_empty' => "Hostname is empty.",
    '__hour(s)' => 'Hour(s)',
    '__hst_type_incorrect' => "Hosting type is incorrect.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Idle time",
    '__iface' => "Interface",
    '__image' => "Image",
    '__imap_status' => "IMAP Server status",
    '__in' => "In",
    '__in_%' => "in %",
    '__incorrect_databases_login_pass' => "The credentials that you specified for accessing PostgreSQL are incorrect.",
    '__incorrect_ip_or_network_address' => 'Incorrect IP address or network.',
    '__info' => 'Info',
    '__install' => "Install",
    '__install_prefix' => "Install prefix",
    '__invalid_cert_id' => "Invalid certificate ID",
    '__invalid_context' => "Invalid context: %1",
    '__invalid_db_usr_name' => "Database user name is invalid.",
    '__invalid_dir_name' => "Directory name is invalid",
    '__invalid_dom_name' => "Domain name is invalid.",
    '__invalid_filename' => "Invalid file name. Do not use single quotes and/or \"../\" combination.",
    '__invalid_id' => "Invalid identifier.",
    '__invalid_lines_num' => "Inappropriate value for number of lines, only digits are allowed.",
    '__invalid_max_letter_size' => "Maximum message size is invalid.",
    '__invalid_restart_apache_interval' => "Apache restart interval is invalid.",
    '__invalid_tmpl_name' => "Template name is invalid.",
    '__invalid_value' => "Improper value.",
    '__ip_addr' => "IP Address",
    '__ip_address_and_mask' => "IP Address and Subnet Mask",
    '__ip_alias__mask' => "IP Address and Subnet Mask",
    '__ip_addr_is_invalid' => "IP address is invalid.",
    '__ip_addr_list' => "IP Addresses",
    '__ip_address_and_mask_hint' => 'For example, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Your license key is intended for use in Virtuozzo containers only.",
    '__key_limits_exceeding' => "This action exceeds the limits defined by your software license. If you received this message you may contact your provider or the manufacturer to clarify or extend the limits of this license.",
    '__kilo' => "K",
    '__keywords' => 'Keywords',
    '__lang_unknown' => 'Unable to recognize the language.',
    '__languages' => 'Language',
    '__learn_more' => 'Learn more',
    '__loading' => 'Loading...',
    '__locales' => "Language packs",
    '__lists' => "Mailing lists",
    '__literal_bytes' => "B",
    '__processing' => "Please wait.<br>Loading...",
    '__locale' => "Interface language",
    '__locale_is_not_defined' => "Interface language is not defined.",
    '__local_server_mysql' => 'Local MariaDB/MySQL server',
    '__local_server_postgresql' => 'Local PostgreSQL server',
    '__local_server_mssql' => 'Local MS SQL server',
    '__log_and_statistics_files' => 'Log files and statistical reports',
    '__config_files' => 'Configuration files',
    '__chroot_files' => 'Chrooted environment',
    '__login' => "%1 Login",
    '__login1' => "Login",
    '__login_disabled' => "Login prohibited",
    '__login_enabled' => "Login allowed",
    '__login_incorrect' => "You have entered incorrect username or password.",
    '__login_name' => "%1 username",
    '__login_name_is_invalid' => "%1 username is invalid.",
    '__logon_time' => "Logon time",
    '__ma' => "Mail aliases",
    '__mail' => "Mail",
    '__mail_alias_name' => "Mail alias name",
    '__mail_autodiscovery' => 'Mail autodiscover',
    '__mail_exchanger_name_is_invalid' => "Mail exchanger name is invalid.",
    '__mail_groups' => "Mail groups",
    '__mail_list_engine' => "Mailing list software",
    '__mail_name' => "Mail account",
    '__mail_name_form' => "Mail account properties",
    '__mail_names' => "Mail accounts",
    '__mail_serv' => "Mail server",
    '__mail_user' => 'Mail user',
    '__mailgroup' => "Mail group",
    '__maillist' => "Mailing list",
    '__maillists' => "Mailing lists",
    '__maillist_member' => 'Mailing list member',
    '__mailname' => "Mail account",
    '__mailname_redir_self' => "Mail account cannot forward mail to itself.",
    '__max_dom_num_reached_for_cl' => "The limit on number of domains was reached for this customer account.",
    '__max_file_size_available' => "Maximum filesize allowed %1",
    '__max_subdom_num_reached_for_cl' => "The limit on number of subdomains was reached for this customer account.",
    '__max_subdom_num_reached_for_dom' => "The limit on number of subdomains was reached for the domain.",
    '__max_subdom_num_reached_for_key' => "The limit on number of subdomains allowed by the license key was reached.",
    '__max_traffic_limit' => "Traffic limit",
    '__maximum_excl_ip_num' => "Mail accounts",
    '__mb' => "MB",
    '__mbytes' => "megabytes",
    '__mb_month' => "MB/month",
    '__mb_sec' => "MB/sec",
    '__gb_sec' => "GB/sec",
    '__tb_sec' => "TB/sec",
    '__mega' => "M",
    '__minute(s)' => 'Minute(s)',
    '__mls_not_in_key' => "Your product key does not support multilingual interface.",
    '__modification_date' => "Modification date",
    '__module' => "Extension",
    '__month' => "Month",
    '__month(s)' => "Month(s)",
    '__month1' => "Jan",
    '__month10' => "Oct",
    '__month11' => "Nov",
    '__month12' => "Dec",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "April",
    '__month5' => "May",
    '__month6' => "June",
    '__month7' => "July",
    '__month8' => "Aug",
    '__month9' => "Sept",
    '__monthly' => "Monthly",
    '__months' => "Months",
    '__moved_permanently' => 'Moved Permanently',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Microsoft SQL server name",
    'mssql__unable_to_change_server_name_db_exists' => "name for the server cannot be changed: there is at least one database on it.",
    '__mssql_status' => "Microsoft SQL server status",
    '__multiply_login_deny' => "Unable to log you on. Another user with the same username (%1) is already logged in to Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL server status",
    '__mysql_version' => "MySQL version",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB server status",
    '__mariadb_version' => "MariaDB version",
    '__percona' => "Percona",
    '__percona_status' => "Percona server status",
    '__percona_version' => "Percona version",
    '__name' => "Name",
    '__name_invalid' => "Name is invalid.",
    '__nameserver' => "nameserver",
    '__network' => "Network",
    '__networks' => "Networks",
    '__no' => "No",
    '__no_ip_address_with_properly_type_available' => "Unable to restore the backed up data because there are no suitable IP addresses required for restoring.",
    '__no_clients_specified' => "No customer accounts specified.",
    '__no_comments' => "No comments.",
    '__nologin' => "Forbidden",
    '__none' => "None",
    '__not_configured' => "Not configured",
    '__not_implemented_yet' => "Not implemented yet",
    '__not_supported_by_ftp' => "(not supported by FTP server)",
    '__notification' => "Notification",
    '__num_displayed' => "%1 of %2 displayed",
    '__num_is_invalid' => "Number is invalid.",
    '__object_not_found' => 'Object not found: %1',
    '__of_all' => "% of All",
    '__off' => "Off",
    '__ok' => "OK",
    '__old_passwd' => "Old %1 password",
    '__on' => "On",
    '__others' => "Others",
    '__other_ip__will_be_added' => 'Other available IP addresses (will be added to the customer\'s IP pool)',
    '__out' => "Out",
    '__p' => "P",
    '__passwd' => "%1 Password",
    '__passwd_is_invalid' => "%1 Password is invalid.",
    '__path' => "Path",
    '__perl_unix_support' => "Perl support",
    '__perl_win_support' => "Perl support",
    '__perm_denied' => "Permission denied.",
    '__permissions' => "Permissions",
    '__personal_name' => "Personal name",
    '__pg_admin_not_activated' => "PostgreSQL was not activated on the server administration page.",
    '__pg_not_inst' => "PostgreSQL was not installed.",
    '__pg_not_run_or_inst' => "PostgreSQL was not installed or is not running.",
    '__pg_not_support_in_key' => "PostgreSQL is not supported by the license key.",
    '__phone' => "Phone",
    '__phosting' => "Physical hosting",
    '__php_support' => "PHP support",
    '__php_run_as_isapi' => "run as ISAPI extension",
    '__php_safe_mode' => "PHP 'safe_mode' on",
    '__php_version' => "PHP version",
    '__physical' => "Physical hosting",
    '__plesk_stat_pdir' => "Protect directory '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Domain statistics",
    '__plesk_stat_protect' => "Protect access to web statistics with the user's FTP username and password",
    '__plesk_stat_protect_install' => "accessible via password protected directory '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3 server status",
    '__popen_error' => "An error occurred while calling the popen function.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL status",
    '__preferences' => "Settings",
    '__account_preferences' => "Account Settings",
    '__interface_preferences_general' => 'General',
    '__interface_preferences_default' => 'Default Interface Preferences',
    '__interface_preferences_admin' => "Administrator's Interface Preferences",
    '__interface_template' => 'Interface customization template',
    '__interface_preferences' => "Interface preferences",
    '__proceed?' => "Do you want to proceed?",
    '__provider_contact_name' => "Owner's contact name",
    '__python_unix_support' => "Python support",
    '__python_win_support' => "Python support",
    '__quota' => "Quota",
    '__r' => "R",
    '__reconfigure' => "Reconfigure",
    '__record_type' => "Record type",
    '__release' => "Release",
    '__remote_db_not_supported_by_key' => 'Remote database hosting is not supported by your license key.',
    '__remove_protection' => 'Remove Protection',
    '__report' => "Report",
    '__report_size_na' => "Service is unavailable",
    '__reports_list' => "Reports",
    '__requested' => "Requested",
    '__required_fields' => "Required fields",
    '__resp_name_invalid' => "Auto-Reply name is invalid. Use only alphanumeric, dots, underscore and white spaces symbols.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Server name is invalid.",
    '__screenshots' => 'Screenshots',
    '__script_warning' => "By removing the scripting capability from this domain all influenced scripts will be displayed in plain text when called by a browser.  It is advisable for the administrator to remove all dependent scripts from the given domain.",
    '__sec' => "Seconds",
    '__second(s)' => "Second(s)",
    '__see_list_of_logged_in' => "See the list of currently logged in users.",
    '__select_certs_to_remove' => "Select certificates to be removed.",
    '__select_files_to_remove' => "Select files to be removed.",
    '__select_ip' => "Assign IP address",
    '__select_ip_to_remove' => "Select an IP address to be removed.",
    '__select_domain_template' => "Use domain template settings",
    '__select_templates_to_remove' => "Select templates to be removed.",
    '__server' => "Server",
    '__server_total' => "Server Total",
    '__service' => "Service",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MariaDB/MySQL database server",
    '__service_description__mysql' => "MariaDB/MySQL database server",
    '__service_title__web' => "Web server",
    '__service_description__web' => "Web server",
    '__service_title__smtp' => "SMTP server",
    '__service_description__smtp' => "SMTP server",
    '__service_title__mail' => "IMAP/POP3 server",
    '__service_description__mail' => "IMAP/POP3 server",
    '__service_title__dns' => "DNS server",
    '__service_description__dns' => "DNS server",
    '__service_title__postgresq' => "PostgreSQL database server",
    '__service_description__postgresq' => "PostgreSQL database server",
    '__service_title__spamassassin' => "SpamAssassin spam-filtering service",
    '__service_description__spamassassin' => "SpamAssassin spam-filtering service",
    '__services' => "Services",
    '__all_services' => "All services",
    '__sessions' => "Sessions",
    'sessions__feature_ftp_session_manager_not_supported' => "FTP Sessions feature is not supported by current FTP server",
    '__sessions_list' => "Sessions",
    '__set' => "Switch on",
    '__shared' => "Shared",
    '__shell_access_warning' => "Allowing shell access to the system is highly dangerous for the system security. Allow access to the system only if you clearly understand what you are doing, and only to trusted users. Do you really want to allow access?",
    '__siteapp_not_support_in_key' => "Web applications are not supported by the license key",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'The configuration of this web application was changed manually. In order to protect the manual modifications, reconfiguration through Plesk was made unavailable.',
    '__site_management' => "Web Publishing", // indirect
    '__size' => "Size",
    '__skins' => 'Skins',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP server status",
    '__some_fields_are_empty_or_invalid' => "Some fields are empty or contain an improper value.",
    '__no_email_addresses_selected' => 'No email addresses were selected.',
    '__unable_to_set_parameters' => "Unable to set parameters of the component.",
    '__spamassassin' => "Spam Filter",
    '__spamassassin_status' => "SpamAssassin status",
    '__spamd_status' => 'Spam Filter status',
    '__splited_backup' => "(multivolume backup)",
    '__split_backup_file' => "Create a multivolume backup",
    '__split_backup_size' => "Volume size",
    '__split_backup_less_than_500' => "Volume sizes less than 500 megabytes are not supported",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI support",
    '__ssi_with_html' => "use SSI for *.htm, *.html files",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS support",
    '__same_ssl' => "Use a single directory for housing SSL/TLS and non-SSL/TLS content",
    '__same_ssl_cu' => "Common SSL/TLS and non-SSL/TLS content",
    '__state' => "State/Province",

    '__status__Active' => 'Active',
    '__status__active' => 'active',
    '__status__Passive' => 'Switched off',
    '__status__passive' => 'switched off',
    '__status__off' => 'switched off',
    '__status__with_parent' => 'switched off',
    '__status__backup_restore' => 'temporarily suspended for backing up or restoring',
    '__status__admin' => 'suspended by server administrator',
    '__status__resseler' => 'suspended by reseller',
    '__status__client' => 'suspended by customer',
    '__status__unknown' => 'status is unknown',

    '__status_of' => "%1 status",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel server", // indirect
    '__subdomain' => "Subdomain",
    '__subdomain_name' => "Subdomain name",
    '__subdomain_name_in_ASCII_form' => "Subdomain name in ASCII format",
    '__subdomains' => "Subdomains",
    '__domainaliases' => "Domain aliases",
    '__subdomains_list' => "Subdomains",
    '__subdomains_not_support_in_key' => "Subdomain operations are not supported by the license key",
    '__sys_user_type' => "FTP user",
    '__sys_user_type_main' => "Use the FTP user account of the main domain",
    '__sys_user_type_native' => "Create a separate FTP user account for this subdomain",
    '__target_domain' => "Target domain",
    '__template' => "Template",
    '__template_not_accepted' => "Unable to accept the template: the following limitations are exceeded.",
    '__templates' => "Templates",
    '__templates_list' => "Templates",
    '__tera' => "T",
    '__title' => "Title",
    '__tools' => "Tools",
    '__total' => "Total %1",
    '__total_size' => "Total size",
    '__total_used' => "Total Used",
    '__traffic' => "Traffic",
    '__traffic_by_client' => "Traffic by customer",
    '__traffic_by_domain' => "Traffic by domain",
    '__traffic_by_service' => "Traffic by service",
    '__traffic_history' => "Traffic history",
    '__unable_change_locale' => "Unable to change the interface language: %1",
    '__unable_create_new_dom' => "Unable to create a domain: %1",
    '__unable_define_dom_name' => "Unable to define domain name: %1",
    '__unable_define_necessary_properties' => "Unable to define all required properties.",
    '__unable_define_properties' => "Unable to define properties: %1",
    '__unable_exec_util' => "Unable to execute utility: %1",
    '__unable_get_dns_a_recs' => "Unable to retrieve IP addresses for A DNS records for this hosting account: %1",
    '__unable_get_mbox_quota' => "Unable to retrieve the information on the mailbox size limit.",
    '__unable_redirect_to_myself' => "Unable to forward to the same account.",
    '__unable_redirect_to_my_alias' => "Unable to forward mail to a mail alias.",
    '__default_domain_redirect_to_myself' => "Unable to set domain as default for IP address:\n redirect to itself detected.",
    '__unable_remove_client' => "Unable to remove customer: %1",
    '__unable_set_up_mbox_quota' => "Unable to set the mailbox size limit for the domain: %1",
    '__unable_setup_pass' => "Unable to set password: %1",
    '__unable_to_create_new_account' => "Unable to create an account: %1",
    '__unable_to_define_db_size' => "Unable to define the database size.",
    '__unable_to_enable_short_names' => "Unable to allow the use of short mail account names for POP3/IMAP accounts.",
    '__unable_to_fetch_data_from_submit' => "Unable to fetch the submitted data: %1",
    '__unable_to_open_file' => "Unable to open the file %1: %2",
    '__unable_to_update_subdomain' => "Unable to make changes to the subdomain: %1",
    '__unable_update_cl_data' => "Unable to save changes to the user account: %1",
    '__unable_update_db_params' => "Unable to update database parameters: %1",
    '__unable_update_dom_data' => "Unable to update domain data: %1",
    '__undefined' => "undefined",
    '__uninstall' => "Uninstall",
    '__unknown_error' => "Unknown error",
    '__unlimited_lower' => "Unlimited",
    '__unset' => "Switch off",
    '__update' => "Update",
    '__uploaded_file_is_invalid' => "Uploaded file is invalid: %1",
    '__url' => "URL",
    '__usage' => "Disk usage",
    '__user_already_logged' => "Another user with the same username (%1) is already logged in to Plesk.",
    '__version' => "Version",
    '__aps_license' => "License key",
    '__vh_type' => "Virtual host type",
    '__vhosts_apache_status' => "Web server status",
    '__wrong_charset_conversion' => 'Wrong charset, conversion from "%1" to "%2" is not allowed',
    '__warning_' => "Warning!",
    '__warning_excl_ip_num' => "Dedicated IP address",
    '__warning_expiration' => "Expiration date",
    '__web_scripting' => "Web scripting", // indirect
    '__web_serv' => "Web server", // indirect
    '__web_statistic' => "Web statistics", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer is not installed on the server. Contact your service provider for assistance with Webalizer installation.",
    '__webstat_support' => "Web statistics",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "When you switch from one statistics program to another, all reports created by the previously used statistics program are deleted and new reports are created in accordance with the information read from log files kept on the server. This means that if you configured the system (at Domains > domain name > Log Manager > Log Rotation) so as to keep log files only for the last month, then web statistics will be available only for the last month. Do you want to switch to another statistics package?",
    '__webstat_perm_denied' => 'You do not have the permission to manage web statistics.',
    '__webuser' => "Web user",
    '__sysusers_list' => "System users",
    '__sysuser' => "System user",
    '__weekly' => "Weekly",
    '__whats_new_in_version' => "What's new in Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "This operation is available only for domains with web hosting.",
    '__wrong_hosting_type__none' => 'There is no web hosting configured on domain %1.',
    '__wrong_hosting_type__std_fwd' => 'Domain %1 has standard forwarding configured. This operation is available only for domains with web hosting.',
    '__wrong_hosting_type__frm_fwd' => 'Domain %1 has frame forwarding configured. This operation is available only for domains with web hosting.',
    '__wu' => "Web users",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW prefix was changed. Be sure to modify the SSL/TLS certificate accordingly.",
    '__year' => "Year",
    '__year(s)' => "Year(s)",
    '__yes' => "Yes",
    '__you' => "You",
    '__zip_code' => "Postal/ZIP code",
    '__form_normal' => "Normal",
    '__form_advanced' => "Advanced",

    'admin_ed__edit_administrator_info' => "Editing Administrator Profile",
    'admin_ed__create_default_client' => "I would like to create a default customer account.",
    'admin_ed__unable_update' => "Unable to update administrator information: %1",

    'auth__update_admin_info' => "Please enter administrator's information. This information is required to operate %1.",
    'auth__you_not_have_perm' => "You do not have permissions to manage this domain.",
    'auth__key_expired_admin' => 'Your Plesk license has expired. To continue using Plesk, renew your license or buy a new one.',
    'auth__key_expired_admin_restricted' => 'Your Plesk license has expired. Contact your service provider to continue using Plesk.',
    'auth__key_expired_client' => 'The Plesk license has expired. Please contact your hosting provider.',
    'autoinstaller__not_installed' => 'Autoinstaller component is not installed.',
    'autoinstaller__release_action' => 'Available operations',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Upgrading to the new Plesk version',
    'autoinstaller__release_action_update' => 'Updating or adding new components',
    'autoinstaller__release_action_up2date' => 'You have an up-to-date version',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Not installed',
    'autoinstaller__component_action_update' => 'Updates are available',
    'autoinstaller__component_action_upgrade' => 'An update is available',
    'autoinstaller__component_action_up2date' => 'You have an up-to-date version',
    'autoinstaller__component_action_error' => 'Updates are not available',
    'autoinstaller__component_serverbuildtime' => 'Latest release',
    'autoinstaller__component_localbuildtime' => 'Your release',
    'autoinstaller__component_installed_version' => 'Your version',
    'autoinstaller__component_available_version' => 'Latest version',
    'autoinstaller__component' => 'Component',
    'autoinstaller__components' => 'Components',
    'autoinstaller__components_title' => '%1 Components',
    'autoinstaller__component_dependency_note' => 'required for installation of the components you selected',
    'autoinstaller__install_confirm' => 'Yes, I wish to install these components',
    'autoinstaller__install_confirm_request' => 'Please select the check box to confirm',
    'autoinstaller__install_title' => 'Confirm Installation of the Selected Components',
    'autoinstaller__key_update_confirm' => 'Confirm skipping key update and installing the default key',
    'autoinstaller__key_update_confirm_request' => 'Please select the check box to confirm.',
    'autoinstaller__key_update_failed' => '<p>Plesk is unable to update your product license.</p><p>%1</p><p>Continuing with the upgrade without having an appropriate product license will result in the installation of a default license with limited functionality. Administrators are advised to first acquire the appropriate license key before continuing with the product upgrade.</p>',
    'autoinstaller__email' => 'Send notice to',
    'autoinstaller__email_admin' => "Administrator's email",
    'autoinstaller__email_email' => 'Custom email address...',
    'autoinstaller__release' => 'Release name',
    'autoinstaller__releases' => 'Available releases',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Select the components to be installed',
    'autoinstaller__status_error' => 'Error: %1',
    'autoinstaller__status_install_error' => 'Installation could not be started: %1',
    'autoinstaller__status_install_busy' => 'Installation could not be started: another installation procedure is currently running.',
    'autoinstaller__status_install_ok' => 'Installation started. You will be notified of installation progress by email (%1).',
    'autoinstaller__status_query_busy' => 'Installation is in progress.',
    'autoinstaller__status_query_error' => 'Unable to retrieve installation status: %1',
    'autoinstaller__status_unknown' => 'Unable to retrieve autoinstaller status.',
    'autoinstaller__status_busy' => 'Autoinstaller is busy, please wait.',
    'autoinstaller__configure_title' => 'Updater Settings',
    'autoinstaller__preferences_legend' => 'Settings',
    'autoinstaller__target' => 'Temporary download directory',
    'autoinstaller__target_invalid' => "Specify absolute path",
    'autoinstaller__check_updates' => 'Check for updates upon administrator\'s login to Plesk',
    'autoinstaller__check_updates_warning' => 'New <a href="%1">updates</a> are available for %2 ',
    'autoinstaller__source_type' => 'Source type',
    'autoinstaller__source' => 'Source URL',
    'autoinstaller_source__preferences_legend' => 'Settings',
    'autoinstaller_source__type' => 'Source type',
    'autoinstaller_source__url_invalid' => 'Invalid source',
    'autoinstaller_source__url_invalid_network' => 'Invalid source URL (Example: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Source URL',
    'autoinstaller__source_invalid_network' => 'You specified an invalid network address',
    'backup__repository' => 'Backup files storage location',
    'backup__error_notify_email' => 'If errors occur during backing up, send notification to email',
    'backup__dump_info' => "Backup information",
    'backup__dump_file_name_not_defined' => "Backup file name is not specified",
    'backup__local_file' => 'Local backup file',
    'backup__domain_ftp' => 'remote FTP server',
    'backup__wrong_path' => "Incorrect path to the backup files storage: Do not use the sequence of characters ../../",
    'backup__unable_to_connect_to_ftp_server' => "Unable to connect to FTP server: %1",
    'backup__unable_to_read_file' => 'Unable to read the backup file.',
    'backup__backup_task_does_not_exist' => "Backup task does not exist, you should create it before turning on.",
    'backup__restore_params' => "Restoration parameters",
    'backup__confirmation' => "Warning: the domain will not be available during backup/restoration.",
    'backup__backup_method' => 'Backup method',
    'backup__dumpfile_name' => "Backup file name",
    'backup__dumpfile_name_is_invalid' => "Backup file name is invalid: use only alphanumeric, dash, dot and underscore symbols, do not use names like description.* as backup file name.",
    'backup__email_required' => "Your email address is required to keep you informed of backing up and restoring progresses. Please specify your email in the account details.",
    'backup__error_during_backup' => "Unable to create the backup file: %1",
    'backup__input_email_warning' => "You should either specify email for notification or clear the check box.",
    'backup__make_download' => "do not store the backup file in storage, only download it",
    'backup__make_dump' => 'create backup file and store in local storage',
    'backup__makedump_to_ftp' => 'create backup file and store on remote FTP server',
    'backup__restore_ip' => "IP address for restoration",
    'backup__select_dumpfile' => "Select a backup file.",
    'backup__time' => "Backup time",
    'backup__day' => 'Backup day',
    'backup__view_dump_info' => "View the backup information for domain %1",
    'backup__wrong_domain_name' => "The backup file contains the data of domain %1 and therefore cannot be restored on domain %2",
    'backup__incorrect_ftp_user_or_passwd' => "Incorrect FTP user or password. Please correct FTP Account Properties",
    'backup__access_denied' => "Access denied. Please correct FTP Account Properties",
    'backup__restore_from' => "Restore %1",
    'backup__domain_session_failed' => 'Domain %1 was not backed up',
    'backup__client_session_failed' => 'Customer %1 was not backed up',
    'backup__domain_session_restore_failed' => 'Domain %1 was not restored',
    'backup__client_session_restore_failed' => 'Customer account %1 was not restored',
    'backup__domain_session_complete' => 'Domain %1 was backed up',
    'backup__domain_session_backup' => 'Backup of domain %1',
    'backup__client_session_backup' => 'Backup of customer %1',
    'backup__domain_stop_title' => 'Cancelling backup of domain %1',
    'backup__client_stop_title' => 'Cancelling backup of customer account %1',
    'backup__domain_restore_stop_title' => 'Cancelling restoration of domain %1',
    'backup__client_restore_stop_title' => 'Cancelling restoration of customer account %1',
    'backup__domain_session_backup_stop' => 'You are about to cancel the active backup process. Backup file will not be created.',
    'backup__backup_stop_confirm' => 'Yes, I want to stop the backup process',
    'backup__restore_stop_confirm' => 'Yes, I want to stop the restoration process',
    'backup__domain_session_restore' => 'Restoration of domain %1',
    'backup__domain_session_restore_stop' => 'You are about to cancel the active restoration process.',
    'backup__domain_backup_file_info' => 'Domain Backup File Information',
    'backup__domain_backup_file_list' => 'existing backup files',
    'backup__domain_backup_progress' => 'Progress of backing up website %1',
    'backup__domain_restore_progress' => 'Progress of restoring website %1',
    'backup__domain_backup_progress_elapsed_time' => 'Elapsed time: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Elapsed time: %1',
    'backup__domain_restore_session_complete' => 'Domain %1 is restored.',
    'backup__domain_restore_session_complete_message' => 'Domain %1 was restored.',
    'backup__domain_backup_file_delete' => 'The following backup files will be removed:',
    'backup__domain_backup_file_for_remove' => 'Select backup files you wish to remove',
    'backup__backup_overwrite_file_confirm' => 'Replacement confirmation',
    'backup__backup_overwrite_file_confirm_text' => 'Backup file with the name "%1" already exists. Do you want to replace it?',
    'backup__backup_confirm_overwrite' => 'Confirm file replacement',
    'backup__backup_overwrite_legeng' => 'Replace',
    'backup__backup_not_contain_domain' => 'Backup file does not contain information about domain %1',
    'backup__backup_not_contain_client' => 'Backup file does not contain information about customer account %1',
    'backup__backup_client_info' => "Back up customer's settings and account details",
    'backup__client_backup_progress' => 'Progress of Backing Up Customer Account %1',
    'backup__client_session_complete' => 'Customer account %1 is backed up',
    'backup__client_backup_file_info' => 'Customer Backup File Information',
    'backup__restore_client_info' => "Restore customer's settings and account details",
    'backup__client_session_restore' => 'Restoring Customer Account %1',
    'backup__client_db_server_map' => 'Database Servers Mapping',
    'backup__domain_db_server_map' => 'Database Servers Mapping',
    'backup__client_restore_session_complete_message' => 'Customer account %1 was restored.',
    'backup__client_restore_session_complete' => 'Customer account %1 was restored.',
    'backup__restore_select_some' => 'Please select objects you wish to restore.',
    'backup__client_restore_progress' => 'Restoration Progress for Customer Account %1',
    'backup__new_backup' => 'Creating New Backup',
    'backup__done' => 'Done:',
    'backup__done_domains' => '%1 domain(s) out of %2',
    'backup__done_clients' => '%1 customer(s) out of %2',
    'backup__remaining' => 'Remaining:',
    'backup__remaining_domains' => '%1 domain(s)',
    'backup__remaining_clients' => '%1 customer(s)',
    'backup__overall_backup_progress' => 'Overall backup progress',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => 'Command "%1" is ignored',
    'backup__no_objects' => 'there are no objects for backup',
    'backup__cli_warning_not_enough_ip' => 'WARNING: not enough IP addresses to perform default IP mapping: ',
    'backup__local_repository' => "Plesk's storage",
    'backup__ftp_repository' => 'FTP storage',
    'backup__ftp_login' => 'Username',
    'backup__ftp_password' => 'Password',
    'backup__ftp_account_settings' => 'FTP Account Settings',
    'backup__ftp_account_preferences' => 'FTP account settings',
    'backup__repository_not_exist' => 'Directory does not exist',
    'backup__repository_not_readable' => 'The specified directory is not readable',
    'backup__ftp_repository_not_configure' => 'To use an FTP backup storage, <a href="%1">specify  the FTP account</a> first.',
    'backup__ftp_repository_list_not_configure' => 'Account settings were not specified',
    'backup__repository_list_unable_listing' => 'Unable to retrieve list of files',
    'backup__ftp_repository_unable_listing' => 'Unable to retrieve listing of directory "%1": ',
    'backup__repository_legend' => 'Backup files storage',
    'backup__store_in_repository' => 'Store files in',
    'backup__local_repository_lable' => 'Local storage',
    'backup__ftp_repository_lable' => 'FTP storage',
    'backup__ftp_repository_not_configure_hint' => '(account settings are not specified)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP account is not specified or not supported)',
    'backup__other_user_process_modified' => 'Another user has stopped the backup or migration process.',
    'backup__another_user_exist' => 'The operation in progress was initiated by another Plesk user. This user is still logged in to Plesk.',
    'backup__ftp_repository_wait' => 'Please wait while retrieving information about FTP storage',
    'backup__ftp_write_test_failed' => 'Failed to write test data to the FTP account %1: ',
    'backup__ftp_storage' => 'FTP(S) storage',
    'bt_upload_to_repository' => 'Upload Files to Local Storage',
    'bt_new_restore' => "Restore",
    'bt_backup_schedule' => "Schedule Backup",
    'backup_exist_backups' => "Existing backup files",
    'backup_dialog__page_title' => "Backup file creation",
    'backup_dialog__please_wait' => "The backup process is about to begin. This operation might take some time. Please wait...",
    'backup_conf__page_title' => 'Backup Configuration',
    'bt_accept' => "Accept",
    'bt_access' => "Access",
    'bt_action_log' => "Action Log",
    'bt_add' => "Add",
    'bt_add_client' => "Assign to Users",
    'bt_database_server_add' => 'Add Database Server',
    'bt_add_services' => "Add Services",
    'bt_anonftp_stats' => "Anon.FTP Stats",
    'bt_anonymous_ftp' => "Anonymous FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Attach",
    'bt_autoinstaller' => 'Updater',
    'bt_auto-updates' => 'Updater',
    'bt_back' => "<< Back",
    'bt_backup' => "Back up",
    'bt_backup_configure' => "Backup Settings",
    'bt_buy_certs' => "Buy Certificates",
    'bt_card' => "Card",
    'bt_cert' => "Certificate",
    'bt_certificates' => "Certificates",
    'bt_change_passwd' => "Change Password",
    'bt_clear' => "Clear",
    'bt_client_templates' => "Customer Templates",
    'bt_clients' => "Customers",
    'bt_codepage_change' => 'Change Encoding',
    'bt_comp_info' => "Components Management",
    'bt_configure_maillists' => "Set Up Mailman",
    'bt_configure' => 'Configure',
    'bt_copy' => "Copy",
    'bt_copy_move' => "Copy/Move",
    'bt_create' => "Create",
    'bt_create_account' => "Create an Account",
    'bt_create_dir' => "Add a Directory",
    'bt_create_file' => "Add a File",
    'bt_count_size' => "Calculate Size",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Task Scheduler",
    'bt_custom_button_new' => "Add a Button",
    'bt_custom_buttons' => "Custom Buttons",
    'bt_customize' => "Customize",
    'bt_databases' => "Databases",
    'bt_database_servers' => 'Database Servers',
    'bt_sqlservers' => "Database Servers",
    'bt_db_usr_new' => "Add a Database User",
    'bt_db_new' => "Add a Database",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Make Default for DB Webadmin",
    'bt_decline' => "Decline",
    'bt_default' => "Default",
    'bt_defaultcomponents' => "Third-party Services",
    'bt_defaults' => "Defaults",
    'bt_delete' => "Delete",
    'bt_directories' => "Protected Directories",
    'bt_disable' => "Switch Off",
    'bt_dns_zone_sync' => 'Apply DNS Template Changes',
    'bt_dnsrecord_add' => 'Add Record',
    'bt_do_backup' => "Back Up",
    'bt_do_restore' => "Restore",
    'bt_do_upload' => "Upload",
    'bt_domain_aliases' => "Domain Aliases",
    'bt_domain_templates' => "Domain Templates",
    'bt_domain_user' => "Domain Administrator",
    'bt_domain_user_passwd' => "Domain Administrator Password",
    'bt_domains' => "Domains",
    'bt_domain_alias_add' => 'Add Domain Alias',
    'bt_download' => "Download",
    'bt_edit' => "Edit",
    'bt_enable' => "Switch On",
    'bt_export' => 'Export',
    'bt_extras' => "Extras",
    'bt_finish' => "Finish",
    'bt_ftp_account' => "FTP Account Properties",
    'bt_forget_password' => "Forgot Password?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP Stats",
    'bt_get_password' => "Get Password",
    'bt_global_changes' => "Modify",
    'bt_help' => "Help",
    'bt_hide_aliases' => "Hide Aliases",
    'bt_hide_toolbar' => 'Hide toolbar',
    'bt_hide_subdomains' => "Hide Subdomains",
    'bt_hide_domainaliases' => "Hide Domain Aliases",
    'bt_home' => "Home",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Install",
    'bt_ip_aliasing' => "IP Addresses",
    'bt_ip_add' => "Add IP Address",
    'bt_ip_pool' => "IP Pool",
    'bt_key_info' => "License Information",
    'bt_key_buyonline_addons' => 'Order Plesk Add-Ons',
    'bt_key_buyonline_upgrades' => 'Order Plesk Upgrades',
    'bt_key_buyonline_new' => 'Order New Key',
    'bt_limits' => "Limits",
    'bt_locale_add' => 'Add Locale',
    'bt_locales' => 'Locales',
    'bt_log_manager' => "Log Manager",
    'bt_login' => "Log In",
    'bt_logo' => "Branding",
    'bt_logo_send_link' => "Attach Link",
    'bt_logo_send_logo' => "Attach Logo",
    'bt_logout' => "Log Out",
    'bt_logrotation' => "Log Rotation",
    'bt_mail' => "Mail",
    'bt_mail_alias_add' => "Add Mail Alias",
    'bt_mail_aliases' => "Mail Aliases",
    'bt_mail_group_add' => "Add Member",
    'bt_mail_groups' => "Groups",
    'bt_mail_name_add' => "Add Mail Account",
    'bt_mail_preferences' => "Settings",
    'bt_mail_group' => "Mail Group",
    'bt_mail_mailbox' => "Mailbox",
    'bt_mail_redirect' => "Forwarder",
    'bt_mail_resp_add' => "Add Auto-Reply",
    'bt_mail_resp_attach_add' => "Add Attachment",
    'bt_mail_resp_files' => "Attachment Files",
    'bt_mail_responders' => "Auto-replies",
    'bt_mail_spamfilter' => "Spam Filter",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Add Mailing List",
    'bt_maillists' => "Mailing Lists",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Create Backup",
    'bt_manage' => "Manage",
    'bt_master' => "Master",
    'bt_migrate' => 'Migrate',
    'bt_modules_add' => 'Add Extension',
    'bt_modules_manage' => 'Manage Extensions',
    'bt_move' => "Move",
    'bt_new_client' => "Add Customer Account",
    'bt_new_domain' => "Add Domain",
    'bt_next' => "Next >>",
    'bt_next_page' => "Next",
    'bt_network_add' => "Add Network",
    'bt_notifications' => "Notifications",
    'bt_off' => "Off",
    'bt_on' => "On",
    'bt_on_off' => "On/Off",
    'bt_performance' => 'Performance',
    'bt_permissions' => "Permissions",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Settings",
    'bt_prev_page' => "Prev",
    'bt_preview' => 'Site Preview',
    'bt_print' => "Print",
    'bt_reboot' => "Reboot",
    'bt_reload' => "Reload",
    'bt_refresh' => "Refresh",
    'bt_register' => "Register",
    'bt_remove' => "Remove",
    'bt_enable_selected' => 'Switch On',
    'bt_disable_selected' => 'Switch Off',
    'bt_repair_ip' => "Repair IP",
    'bt_report' => "Report",
    'bt_report_new' => "Add Layout",
    'bt_reset' => "Reset",
    'bt_restart_services' => "Services Management",
    'bt_save' => "Save",
    'bt_send_by_email' => "Send By Email",
    'bt_send_file' => "Send File",
    'bt_send_mail' => "Send Mail",
    'bt_send_passwd' => "Send Password",
    'bt_send_text' => "Send Text",
    'bt_server' => "Server",
    'bt_server_add' => "Add Server",
    'bt_server_preferences' => "Server Settings",
    'bt_servers_list' => "Servers",
    'bt_sessions' => "Sessions",
    'bt_set' => "Set",
    'bt_set_as_default' => "Set As Default",
    'bt_setup' => 'Setup',
    'bt_show_aliases' => "Show Aliases",
    'bt_show_subdomains' => "Show Subdomains",
    'bt_show_domainaliases' => "Show Domain Aliases",
    'bt_shutdown' => "Shut Down",
    'bt_site_apppkgs' => "Application Vault",
    'bt_site_apppool' => "Application Pool",
    'bt_application-pool' => "Web Applications",
    'bt_site_apps' => "Web Applications",
    'bt_site_app_add' => "Install Application",
    'bt_site_builder' => "Presence Builder Support",
    'bt_skeleton' => 'Virtual Host Template',
    'bt_skins' => 'Skins',
    'bt_skin_add' => 'Add Skin',
    'bt_skin_manual' => 'Custom Plesk Skins Reference', // not used
    'bt_skin_download' => 'Download Skin',
    'bt_skin_replace' => 'Update Skin',
    'bt_skip' => 'Skip',
    'bt_spamassassin' => "Spam Filter",
    'bt_spamassassin_train' => "Training",
    'bt_spamfilter' => "Spam Filter",
    'bt_start' => "Start",
    'bt_stop' => "Stop",
    'bt_recycle' => "Recycle",
    'bt_statistics' => "Statistics",
    'bt_subdomain_new' => "Add Subdomain",
    'bt_subdomains' => "Subdomains",
    'bt_submit' => "Submit",
    'bt_summary_report' => "Summary Report",
    'bt_support' => "Support",
    'bt_switch' => "Switch",
    'bt_system_time' => "System Time",
    'bt_task_new' => "Add Task",
    'bt_dom_tmpl_add' => 'Add Domain Template',
    'bt_cl_tmpl_add' => 'Add Customer Template',
    'bt_cron_backup' => 'Scheduled Backup Settings',
    'bt_test' => "Test Connection",
    'bt_text' => "Text",
    'bt_touch' => "Change Timestamp",
    'bt_traffic' => "Traffic",
    'bt_traffic_history' => "Traffic History",
    'bt_update' => "Update",
    'bt_upload' => "Upload",
    'bt_upload_from_ftp' => "FTP Upload",
    'bt_virtualdirs' => 'Virtual Directories',
    'bt_virtualdir_new' => 'Add Virtual Directory',
    'bt_virtualdir_add' => 'Add Virtual Directory',
    'bt_web_app_new' => "Install Java Application",
    'bt_web_stats' => "Web Stats",
    'bt_web_stats_ssl' => "Web Stats SSL/TLS",
    'bt_web_user_add' => "Add Web User",
    'bt_web_users' => "Web Users",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "See the full list of changes",
    'cert_add__unable_set_ca_cert' => "Unable to set the CA certificate: %1",
    'cert_add__unable_set_cert' => "Unable to set the certificate: %1",
    'cert_add__unable_set_private_key' => "Unable to set the private key: %1",
    'certificates_list__certificate_used_as_default' => "One of the certificates you are going to delete is used as the Default Certificate.",
    'certificates_list__certificates_assigned_on_ip' => "One or several certificates are assigned to the IP addresses/domains.",
    'ch_pass__admin_pass' => "Changing Administrator's Password",
    'ch_pass__old_pass' => "Old password",
    'ch_pass__pass_confirm' => "Confirm",
    'ch_pass__unable_change_admin_pass' => "Unable to change the administrator's password: %1",
    'check_mail_cycle__aliases' => "Mail cycling is detected, the address \"%1\" is contained in the aliases of this mail account.",
    'check_mail_cycle__autoresponders' => "Mail cycling is detected, the address \"%1\" is contained in the auto-replies of this mail account.",
    'check_mail_cycle__mail_groups' => "Mail cycling is detected, the address \"%1\" is contained in the mail group of this mail account.",
    'check_mail_cycle__mail_name' => "Mail cycling is detected, the address \"%1\" coincides with this mail account.",
    'check_mail_cycle__redirect' => "Mail cycling is detected, the address \"%1\" coincides with the forwarder of this mail account.",
    'check_mail_dup__redirect' => "Duplicate forwarding is detected, the address \"%1\" coincides with the forwarding address of this mail account.",
    'check_mail_dup__mail_groups' => "Duplicate forwarding is detected, the address \"%1\" is contained in the mail group of this mail account.",
    'check_maillist_cycle__admin' => "Mail cycling is detected, the administrator's email \"%1\" coincides with the address of a mailing list.",
    'check_maillist_cycle__member' => "Mail cycling is detected, the address \"%1\" coincides with the address of mailing list.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1's account details",
    'cl_limits__cl' => "Customer %1's limits",
    'cl_logo__setup_logo_pref' => "Set logo properties for customer %1",
    'cl_new__enter_new_cl_data' => "Enter the information on new customer",
    'cl_new__unable_to_sent_notification' => 'The user account was created, however, sending a notice to the customer failed: %1',
    'cl_perm__all_ip' => "All available IPs",
    'cl_perm__all_ip_based_hst_will_be_nb' => "All IP-based hosting accounts for customer will be transferred to Name-based.",
    'cl_perm__allow_client_create_domain' => "The fields you are trying to select are only applicable to customers who are allowed to create domains.",
    'cl_perm__allow_create_nb_w_ip' => "Customer can create Name-based hosting using %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Allow IP-based hosting accounts creation",
    'cl_perm__available_ips' => "Available IPs",
    'cl_perm__change_limits' => "Limits adjustment",
    'cl_perm__cl_disk_space' => "Total disk space available",
    'cl_perm__cl_expiration' => "Customer account validity period",
    'cl_perm__cl_max_box' => "Mailboxes",
    'cl_perm__cl_max_db' => "Databases",
    'cl_perm__cl_max_dom' => "Domains",
    'cl_perm__cl_max_maillists' => "Mailing lists",
    'cl_perm__cl_max_subdom' => "Subdomains",
    'cl_perm__cl_max_traffic' => "Total amount of traffic available",
    'cl_perm__cl_max_wu' => "Web users",
    'cl_perm__cl_mbox_quota' => "The mailbox size limit for this user account",
    'cl_perm__current_maximum_exp_date' => "The current maximum value of domain validity period is %1; requested %2.\n",
    'cl_perm__current_maximum_mailbox_quota' => "The currently defined limit on amount of disk space allocated for housing mailboxes under this user account is %1; requested %2\n",
    'cl_perm__current_total_requested' => "The current total value of domain limits for %1 is %2; requested %3.\n",
    'cl_perm__current_total_requested_dom' => "Current number of %1 belonging to this customer is %2; requested %3.\n",
    'cl_perm__disk_space' => "maximum amount of disk space",
    'cl_perm__dashboard_stdgui' => 'User interface',
    'cl_perm__dashboard' => 'Home page view',
    'cl_perm__stdgui' => 'Standard view',
    'cl_perm__manage_dashboard' => 'Home page management',
    'cl_perm__dashboard_and_stdgui' => 'Home page view and standard view are allowed',
    'cl_perm__dashboard_only' => 'Only Home page view is allowed',
    'cl_perm__stdgui_only' => 'Only standard view is allowed',
    'cl_perm__edit_cl' => "Customer %1's permissions",
    'cl_perm__exp_date_exceeded' => "The validity period you are trying to set exceeds the limit specified within individual domains related to this customer.\n",
    'cl_perm__invalid_value' => "Invalid value, only digits are allowed.",
    'cl_perm__limit_disk_space' => "%1 Limit the total amount of disk space",
    'cl_perm__limit_expiration' => "%1 Limit the validity period for the customer account",
    'cl_perm__limit_max_box' => "%1 Limit the maximum number of mailboxes",
    'cl_perm__limit_max_db' => "%1 Limit the maximum number of databases",
    'cl_perm__limit_max_dom' => "%1 Limit the maximum number of domains",
    'cl_perm__limit_max_maillists' => "%1 Limit the maximum number of mailing lists",
    'cl_perm__limit_max_subdom' => "%1 Limit the maximum number of subdomains",
    'cl_perm__limit_max_traffic' => "%1 Limit the total amount of traffic",
    'cl_perm__limit_max_wu' => "%1 Limit the maximum number of web users",
    'cl_perm__limit_mbox_quota' => "%1 Set the mailbox quota",
    'cl_perm__limits_exceeded' => "One or several limits you are trying to set are already exceeded by the limits defined within individual domains belonging to this customer.\nThe total limit for the customer must be more or equal to the total sum of the domain limits defined for this customer account.\n",
    'cl_perm__mailbox_quota_exceeded' => "The limit on amount of disk space allocated for mailboxes you are trying to set exceeds the limit defined within individual domains related to this customer account.\n",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "The limit on amount of disk space allocated for mailboxes you are trying to set exceeds the limitation imposed at the server level.",
    'cl_perm__make_dumps' => "Back up and restore data",

    'cl_perm__max_box' => "maximum number of mailboxes",
    'cl_perm__max_db' => "maximum number of databases",
    'cl_perm__max_dom' => "domains",
    'cl_perm__max_maillists' => "maximum number of mailing lists",
    'cl_perm__max_subdom' => "subdomains",
    'cl_perm__max_traffic' => "maximum amount of traffic",
    'cl_perm__max_wu' => "maximum number of web users",
    'cl_perm__max_dom_aliases' => "domain aliases",
    'cl_perm__mbox_quota' => "mailbox quota",
    'cl_perm__not_allow_create_nb_hst' => "Customer cannot create Name-based hosting.",
    'cl_perm__this_ip_used_vrt_hst' => "This IP address is used by virtual hosting.\nTo delete this IP address, remove hosting service or change its type to Name-based.",
    'cl_perm__unable_off_ipb_creating' => "Customer already has IP-based hosting service set up. To deactivate this feature for the customer, clear the \"Domain creation\" check box or remove all IP-based hosting accounts.",
    'cl_perm__unable_off_nb_creating' => "Customer already has Name-based hosting service set-up. To deactivate this feature for the customer, clear the \"Domain creation\" check box or remove all Name-based hosting accounts.",
    'cl_perm__unable_set_domain_limit' => "Unable to limit the maximum number of domains: customer already has %1 domains",
    'cl_perm__unable_update_client_limitations' => "Unable to modify the limits of customer account: %1",
    'cl_pref__edit_cl' => "Customer %1's preferences",
    'class_anonftp__create_ftp_domain' => "No virtual FTP domain for this dom_id, try creating it first.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "The disk space limit you are trying to set (%1) should not exceed the total disk space limit defined at the domain level (%2).",
    'class_anonftp__invalid_input_only_digits' => "Invalid value specified, only digits are allowed.",
    'class_anonftp__unable_change_ownerships' => "Unable to change ownership or permissions for the quota file: %1",
    'class_anonftp__unable_copy_quota_file' => "Unable to copy the quota file: %1",
    'class_anonftp__unable_get_disk_usage' => "Unable to retrieve disk usage information on the incoming directory: %1",
    'class_anonftp__unable_parse_quota_file' => "Unable to parse the quota file.",
    'class_anonftp__unable_read_quota_file' => "Unable to read the quota file: %1",
    'class_anonftp__unable_update_quota' => "Unable to update quota: the files in the incoming directory use %1 KBs of disk space, which exceeds the new quota value.",
    'class_anonftp__unable_write_temp_file' => "Unable to write to the temporary file: %1",
    'class_bsdomain__warn_max_date__' => "The expiration date was set to %1",
    'class_cList__empty' => "No items.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "No matches found for <b>\"%1\"</b> in %2 (%3 of %4).",
    'class_cList__search_result' => "Search result for <b>\"%1\"</b> in %2 (%3 of %4).",
    'class_client__client_creation_notification' => "Customer creation notice.",
    'class_client__client_with_contact_name_already_exists' => "Customer with name %1 already exists.",
    'class_client__disk_space' => "Disk space",
    'class_client__invalid_max_dom' => "Invalid number of domains value, only digits are allowed.",
    'class_client__limit_exceed' => "The requested amount of %1 cannot be allocated because this would exceed the allotments for customer %2's account (%3). If you want to allocate more resources, go to Customers > customer name > Limits and change the allotments as required. Then return to this screen and try adjusting the allotments again.",
    'class_client__limit_exceed_unlimited' => "If you wish to allocate the unlimited amount of resources (%1), you should first go to Customers > customer name > Limits, and select the Unlimited check box corresponding to the required resource type. Then return to this screen and try adjusting the allotments again.",
    'class_client__max_box' => "Mailboxes",
    'class_client__max_db' => "Databases",
    'class_client__max_maillists' => "Mailing lists",
    'class_client__max_subdom' => "Subdomains",
    'class_client__max_traffic' => "Maximum traffic",
    'class_client__max_wu' => "Web users",
    'class_client__max_dom_aliases' => "Domain aliases",
    'class_client__mbox_quota' => "Mailbox quota",
    'class_client__unable_define_cl_status' => "Unable to define status of customer account: %1",
    'class_client__unable_define_inactive_dom' => "Unable to define inactive domains %1.",
    'class_client__unable_del_ip' => "Unable to remove IPs: %1",
    'class_db__db_name_not_set' => "Database name is not defined.",
    'class_db__db_not_exist_for_curr_dom' => "The database does not exist for this domain.",
    'class_db__invalid_db_or_dom_name' => "The domain or database ID is invalid or database name is not defined.",
    'class_db__invalid_pass' => "The password is invalid.",
    'class_db__mailgrp_member_exist' => "The mail group member already exists.",
    'class_db__access_hosts_notsupport' => 'Access hosts setting is not supported for this database type',
    'class_db__unable_add' => 'Unable to add access host record: %1',
    'class_db__unable_del' => 'Unable to delete access host record: %1',
    'class_db__inc_user_not_exist' => 'Database user "%1" does not exist',
    'class_db__inc_access_record_exist' => 'This access record already exists',
    'class_db__inc_access_record_not_exist' => 'Given access record does not exist',
    'class_db__inc_unable_del_last_record' => 'Unable to delete the last access host record',
    'class_domtmpleditform__dns_master' => "Primary",
    'class_domtmpleditform__dns_slave' => "Secondary",
    'class_domtmpleditform__dns_type' => "Type of domain DNS zone",
    'clienttrafficlist_header' => "Traffic at domains",
    'clienttrafficlist_header_of_client__' => "Traffic at the domains of customer %1",
    'cmd_dns__a_dns_record_already_exist' => "This record will conflict with the A record for the zone.",
    'cmd_dns__domain_last_ns' => 'Cannot delete the last NS DNS record for the domain.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Canonical domain name is invalid.",
    'cmd_dns__cname_dns_record_already_exist' => "This record will conflict with the CNAME record for the zone.",
    'cmd_dns__cname_in_rr_combination' => 'Incorrect combination of DNS records is present in the DNS zone',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS zone record cannot coexist with other DNS records in the same zone.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS record type is invalid.",
    'cmd_dns__ext_host_is_not_resolved' => "The canonical name %1 does not resolve to an A or AAAA record.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Unable to add the %1 record to zone %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Mail exchanger name is invalid.",
    'cmd_dns__mx_priority_is_invalid' => "MX priority is invalid.",
    'cmd_dns__name_server_is_invalid' => "Name server is invalid.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Network mask value should be 24, 16 or 8.",
    'cmd_dns__this_dns_record_already_exists' => "Such a DNS record already exists.",
    'cmd_dns__unable_add_record' => "Unable to add '%1' record: %2",
    'cmd_dns__unable_add_a_record' => "Unable to add A record: %1",
    'cmd_dns__unable_add_cname_record' => "Unable to add CNAME record: %1",
    'cmd_dns__unable_add_dns_record' => "Unable to add DNS record: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Unable to add EXT_NS record: %1",
    'cmd_dns__unable_add_ns_record' => "Unable to add NS record: %1",
    'cmd_dns__unable_add_ptr_record' => "Unable to add PTR record: %1",
    'cmd_dns__unable_add_txt_record' => "Unable to add TXT record: %1",
    'cmd_dns__unable_create_dns_zone' => "Unable to create the DNS zone %1",
    'cmd_dns__unable_define_dns_record' => "Unable to define the DNS record %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Unable to retrieve the default DNS zone status: %1",
    'cmd_dns__unable_insert_a_record' => "Unable to insert A record: %1",
    'cmd_dns__unable_insert_mx_record' => "Unable to insert MX record: %1",
    'cmd_dns__unable_insert_ns_record' => "Unable to insert NS record: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Unable to set the DNS zone status: %1",
    'cmd_domains__dom_already_exists' => "Domain %1 already exists.",
    'cmd_domains__dns_record_already_exists' => "Unable to create the domain %1 because a DNS record pointing to the host %1 already exists.",
    'cmd_domains__dom_already_exists1' => "There are %2 subdomains in this domain. Domain %1 already exists.",
    'cmd_domains__dom_already_exists2' => "the subdomain %1 already exists.",
    'cmd_domains__dalias_already_exists' => "This alias already exists.",
    'cmd_domains__domain_alias_already_exists' => 'A domain alias with such a name already exists.',
    'cmd_domains__unable_del_mail_for_dom' => "Unable to delete the mail services for domain: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Unable to delete anonymous FTP account for domain: %1",
    'cmd_domains__unable_update_dom_param' => "Unable to update the domain parameters: %1.",
    'cmd_domains__unable_rename_client_exist' => "domain administrator's username is already in use.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Hosting type is not physical.",
    'cmd_hosting__unable_create_user' => "Unable to create user %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Unable to define IP address for the name-based virtual hosts: %1",
    'cmd_hosting__unable_del_old_hst' => "Unable to delete the previously set up hosting: %1",
    'cmd_hosting__unable_del_protected_directory' => "Unable to delete protected directory: %1.",
    'cmd_hosting__unable_del_web_user' => "Unable to delete web user: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Unable to create or update the Virtual Host: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Unable to set up the frame forwarding hosting.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Unable to rebuild the proftpd configuration file: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Unable to set up SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Unable to remove protection from the SSL/TLS directory: %1",
    'cmd_hosting__unable_update_dest_url' => "Unable to update the destination URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Unable to update the DNS zone for the domain: utility execution failed.",
    'cmd_hosting__unable_update_ftp_passwd' => "Unable to update FTP password %1.",
    'cmd_hosting__unable_update_user' => "Unable to update user %2: %1",
    'cmd_hosting__unknown_hst_type' => "Unknown hosting type.",
    'cmd_hosting__you_not_have_permission_del_hst' => "You do not have the permission to terminate hosting service.",
    'cmd_mail__autoresponder__not_configured' => "Auto-reply for this mail account is not configured",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Address %1 is already being used for mail forwarding.",
    'cmd_mail__alias_already_exists' => "alias already exists.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Auto-reply's ID and mail account's ID do not match.",
    'cmd_mail__autoresp_id_is_undefined' => "Auto-Reply ID is undefined.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "A mail alias with such a name already exists for the mail account %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Mail account %1 is already subscribed to this mailing list.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Mail account %1 already exists in this domain.",
    'cmd_mail__mail_name_not_exist' => "The mail account does not exist.",
    'cmd_mail__mail_name_passwd_part' => "The password should not contain mail account name as its part.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Mailing list %1 already exists on this domain.",
    'cmd_mail__mailname_already_exist_in_mg' => "Mail account %1 is already in a mail group.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Mail account %1 already exists in this domain.",
    'cmd_mail__mailname_already_exists' => "Mail account already exists.",
    'cmd_mail__mailname_is_invalid' => "Mail account name %1 is invalid.",
    'cmd_mail__mailname_unable_update' => "Unable to update the mail account properties:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Maximum number of auto-replies was reached for this domain.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Maximum number of mail groups was reached for this domain.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Maximum number of forwarders was reached for this domain.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Maximum number of mailboxes was reached.",
    'cmd_mail__no_members_specified' => "no members specified.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "The password is too simple, please choose another one.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "This email address is already used.",
    'cmd_mail__unable_define_autoresp_id' => "Unable to define auto-reply ID %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Failed to change the mail service settings for domain %1",
    'cmd_mail__unable_del_mail_for_dom' => "Unable to remove the mail service from domain %1.",
    'cmd_mail__unable_del_mail_redirection' => "Unable to remove the mail forwarding service %1.",
    'cmd_mail__unable_remove_autoresp' => "Unable to remove auto-replies: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Unable to remove the mail group members: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Failed to switch off the mail group: %1",
    'cmd_mail__unable_update_mail_redirect' => "Unable to reconfigure the mail forwarding service %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Uploaded file size is too large.",
    'cmd_mail__additionally' => "Additionally: ",
    'cmd_pd__invalid_login' => "Incorrect username.",
    'cmd_pd__this_user_already_exist' => "Such a user already exists.",
    'cmd_pd__unable_define_hst_type' => "Unable to define hosting type.",
    'cmd_pd__unable_upd_pd_usr' => "Unable to update protected directory user properties: %1.",
    'cmd_pd__user_is_undefined' => "User is undefined.",
    'cmd_server__no_enough_free_disk_space' => "Not enough disk space.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "old password is incorrect. Please, try again.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "maximum web users limit is reached for this domain.",
    'cmd_web_usr__unable_create_user' => "unable to create system user: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "unable to define maximum web users limit: %1",
    'cmd_web_usr__user_already_exists' => "user already exists.",
    'cmd_web_usr__web_user_name_is_invalid' => "web user name %1 is invalid.",
    'cmd_web_usr__web_user_not_exist' => "web user does not exist.",
    'common_func__exec_bad_argument' => "exec argument should not contain single quote symbol.",
    '__eol' => 'Line breaks',
    'eol__binary_file' => 'Unable to change line break style in binary file.',
    'cp_access_admin_deny' => "Access for administrator from address '%1' is restricted in accordance with IP Access restriction policy currently applied.",
    'create_domain_warn__' => "The following exceptions were made during domain creation:",
    'create_domain__client_select' => 'Select the customer to create the domain for',

    'dashboard__nav_button_name' => "Home",
    'dalias__list_title' => 'Domain aliases of the domain %1',
    'dalias__list_legend' => 'Domain aliases',
    'dalias__list_header' => 'Domain aliases',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Domain alias name',
    'dalias__list_ascii_name' => 'In ASCII format',
    'dalias__remove_title' => 'The following domain aliases of the domain %1 will be removed:',
    'dalias__select_domain_aliases_to_remove' => 'Select the domain aliases to be removed.',
    'dalias__mail_turn_on_failed' => 'Unable to turn on mail service: %1',
    'dalias__web_turn_on_failed' => 'Unable to turn on web service: %1',
    'db_usr_edit__db_usr_name_old' => "Old database user name",
    'database_server_edit_form__cannot_infer_type' => 'Cannot infer connection method from the provided data. Specify "127.0.0.1" as the database server host name to connect over TCP/IP with the provided port, or leave the port field empty to use Unix socket "%1".',
    'database_server_edit_form__duplicate' => 'A database server with this combination of host address and port number is already registered.',
    'database_server_edit_form__host_is_invalid' => 'The specified host name is not valid.',
    'database_server_edit_form__port_is_invalid' => 'The specified port number is not valid.',
    'database_server_error__consult_admin' => 'Please contact the server administrator.',
    'database_server_error__last__connection_failed' => 'The last attempt to control this database server failed because of network problems.',
    'database_server_error__last__permission_denied' => 'The last attempt to control this database server failed because the supplied account does not possess administrative privileges.',
    'database_server_error__last__credentials_not_set' => "The last attempt to connect to this server failed because no valid administrator's username and password were specified.",
    'database_server_error__last__other_error' => 'The last attempt to control this database server failed.',
    'database_server_error__real__connection_failed' => 'Connection to the database server has failed because of network problems:',
    'database_server_error__real__permission_denied' => 'Connection to the database server has failed because the supplied account does not possess administrative privileges:',
    'database_server_error__real__duplicate_object' => 'Connection to the database server has failed because of a name clash:',
    'database_server_error__real__unacceptable_name' => 'Connection to the database server has failed because of an invalid object name:',
    'database_server_error__real__unacceptable_password' => 'Connection to the database server has failed because of an unacceptable password:',
    'database_server_error__real__credentials_not_set' => "Plesk cannot connect to the database server because no valid administrator's username and password were specified.",
    'database_server_error__real__other_error' => 'Connection to the database server failed:',
    'database_server_error__test__connection_failed' => 'The test connection to the database server has failed because of network problems:',
    'database_server_error__test__permission_denied' => 'The test connection to the database server has failed because the supplied account does not possess administrative privileges:',
    'database_server_error__test__duplicate_object' => 'The test connection to the database server has failed because of a name clash:',
    'database_server_error__test__unacceptable_name' => 'The test connection to the database server has failed because of an invalid object name:',
    'database_server_error__test__unacceptable_password' => 'The test connection to the database server has failed because of an unacceptable password:',
    'database_server_error__test__credentials_not_set' => "The test connection to this server has failed because no valid administrator's username and password were specified.",
    'database_server_error__test__other_error' => 'The test connection to the database server has failed:',

    'db__create_new_db' => "Add a database",
    'db__db_add' => "Add Database",
    'db__db_for_dom' => "Databases of Website %1",
    'db__db_id_undefined' => "Database ID is undefined.",
    'db__db_name' => "Database name",
    'db__db_not_exist' => "Database does not exist.",
    'db__db_type' => "Type",
    'db__db_server' => "Database server",
    'db_server_not_exist' => "Database server does not exist.",
    'db__db_user_not_exist' => "Database user does not exist.",
    'db__domain_not_exist' => "Domain does not exist.",
    'db__enter_db_name' => "Enter new database name.",
    'db__invalid_db_id' => "Database identifier is invalid.",
    'db__invalid_db_name' => "Database name is invalid. The database name should contain only Latin alphabet symbols, digits, underscore or dash. It cannot be longer than 63 symbols.",
    'db__max_db_reached_for_dom' => "The limit on number of databases is reached for this domain.",
    'db__max_mssql_db_reached_for_dom' => "The limit on number of Microsoft SQL Server databases is reached for this domain",
    'db__postgres_not_connect_for_admin' => "Unable to connect to PostgreSQL. Switch on PostgreSQL support on the server administration page.",
    'db__postgres_not_connect_for_client' => "Unable to connect to PostgreSQL. Consult your system administrator for help.",
    'db__remove_db_on_domain' => "The following databases under website %2 owned by customer %1 will be removed:",
    'db__remove_db_on_domain_of_cl' => "The following databases for domain %2 owned by customer %1 will be removed:",
    'db__remove_db_linked_resource' => 'This database is in use by a web application. It can be removed only after uninstalling this web application.',
    'db__remove_db_users' => "The following users of database %3 under the website %2 owned by the customer %1 will be removed:",
    'db__remove_db_users_of_cl' => "The following users of database %3 under the website %2 owned by the customer %1 will be removed:",
    'db__select_db_for_remove' => "Select the databases to be removed.",
    'db__select_db_users_for_remove' => "Select the database users to be removed.",
    'db__unable_create_db_user' => "Unable to create the database user: %1",
    'db__unable_define_db_name' => "Unable to define the database name: %1",
    'db__unable_define_db_user' => "Unable to define the database user: %1",
    'db__unable_define_db_users' => "Unable to define database users: %1",
    'db__unable_select_dom_name' => "Unable to select domain name: %1",
    'db_edit__db_for_dom' => "Users for database %1 on domain %2",
    'db_edit__invalid_db_name' => "The database name is invalid.",
    'db_edit__no_users' => "There are no users with credentials for this database.",
    'db_edit__unable_define_db_usrs' => "Unable to define the database users: %1",
    'db_edit__unable_select_db_usr' => "Unable to select the database user.",
    'db_edit__db_user_password_for_' => "Please type in the password to log in as the database user %1 ",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Add database user",
    'db_usr_edit__db_usr_name' => "Database user name",
    'db_usr_edit__edit_db_usr' => "Set up credentials for database user account",
    'db_usr_edit__for_db' => " in %1 database",
    'db_usr_edit__not_create_pass' => "This operation will result in creating a database user account without password.\nDo you wish to create a user without assigning a password?",
    'dbuser__only_one_user_can_be_default' => "Only one user can be set as default.",
    'db_server__cannot_delete_default' => "The default database server cannot be deleted.",
    'db_server__cannot_delete_local' => "The local database server cannot be deleted.",
    'db_server__cannot_delete_used' => 'A database server cannot be deleted while there are databases or database users hosted on it.',
    'demo__disabled_in_demo' => "This operation is not supported in the demo version.",
    'defaultcomponents__title' => "Selecting Default Components",
    'defaultcomponents__select_default' => "Select the default %1 component", //to check
    'defaultcomponents__not_installed' => "(not installed)",
    'defaultcomponents__not_configured' => "(not configured)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Some services categories contain invalid selections, or no selections were made.",
    'defaultcomponents__depends_on' => "(requires %1)",
    'defaultcomponents__parameters' => "Parameters of %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS Server",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "FTP Server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Mail Server",
    'component_name__local_mailserver' => "Local Mail Server",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web Scripting",
    'component_name__spamfilter' => "Spam Filter",
    'component_name__stats' => "Web Statistics",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Web Publishing",
    'component_name__webserver' => "Web Server",
    'dns__dns_record_invalid_values' => 'Incorrect DNS record values were specified: %1: %2',
    'dns__dns_record_not_found' => 'DNS record not found',
    'dns__dns_zone_invalid_values' => 'Incorrect DNS zone parameters were specified.',

    'dns__soa_mname_title' => 'Primary Name Server',
    'dns__soa_mname_legend' => 'Name Server',
    'dns__soa_mname_autoselect' => '(Autoselect)',

    'dns__dns_zone_off_remove_title' => "The following resource records will be removed from the zone %1:",
    'dns__dns_zone_master_remove_title' => "Removing Resource Records from the DNS Zone %1",
    'dns__dns_zone_slave_remove_title' => "The following primary name server records for %1 will be removed:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Enter record string',
    'dns_add__is_spf_syntax' => 'SPF record',
    'dns_add__spf_value_is_invalid' => "SPF record's value is incorrect, it must start with 'v=spf'",
    'dns__dns_zone_status' => "DNS zone status.",
    'dns__invalid_ip_address' => "IP address of new primary DNS server is invalid or empty.",
    'dns__ip_address' => "IP Address",
    'dns__master_dns_type' => "is a primary DNS server",
    'dns__masters' => "primary DNS servers",
    'dns__soa_minimum_too_large' => 'Caching negative responses for more than three hours is not recommended.',
    'dns__select_masters_to_remove' => "Select primary DNS servers to be removed.",
    'dns__select_template_record_to_remove' => 'Select DNS template records to be removed.',
    'dns__nameservers_for_domain' => "Nameservers for the domain",
    'dns__remove_dns_zone_of_domain__' => "DNS records removal from domain %1",
    'dns__remove_dns_zone_template__' => "The following DNS records will be removed from the template:",
    'dns__remove_this_dns_record?' => "Are you sure you wish to remove this DNS record?",
    'dns__restore_default' => "Restoring the DNS zone by the template",
    'dns__restore_default_confirm' => "Restoring the DNS zone will discard the current DNS zone configuration. Proceed anyway?",
    'dns__restore_default_error' => "Error restoring DNS zone:",
    'dns__slave_dns_type' => "is a secondary DNS server",
    'dns__subdomain_dns_rec_removed' => "The A record was removed from the subdomain zone %1.",
    'dns__zone_switched_off_no_ns' => "The zone was switched off because there is no NS record %1, which must be present in the zone. To add the record to the zone, click the Add Record button.",
    'dns__cant_switch_on_no_ns' => "The zone cannot be switched on because there is no NS record %1, which must be present in the zone. To add the record to the zone, click the Add Record button.",
    'dns__unable_activate/deactivate_dns' => "Unable to activate/deactivate DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Unable to add primary DNS server: duplicate entry.",
    'dns__unable_add_dns_master_local_ip' => "Unable to add IP address for primary DNS server: this record should be created on a remote server.",
    'dns__unable_define_dns_record' => "Unable to define the DNS record: %1",
    'dns__unable_get_dns_template_status' => "Unable to retrieve the DNS template status.",
    'dns__unable_remove_dns_rec' => "Unable to remove the DNS record: %1",
    'dns__warnings__' => "The result of DNS zone modification:",
    'dns__you_not_have_perm_manage_dns' => "You do not have permission to manage the DNS zone for this domain.",
    'dns__cant_create_record_with_server_ip' => "Unable to add this IP address because it matches the IP address of this Plesk-managed server.",

    'dns__tabs_acl' => "Zone Transfers",
    'dns__acl_add_network_legend' => "Add Network",
    'dns__acl_add_ip_legend' => "Add IP Address",
    'dns__acl_network_not_allowed' => "This network address is not allowed by DNS in Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP address/mask",
    'dns__acl_enter_ip_address' => "IP address",
    'dns__acl_list_network_legend' => "Networks allowed to get a copy of DNS zone",
    'dns__acl_list_ip_legend' => "IP addresses allowed to get a copy of DNS zone",
    'bt_dns_acl_add_network' => "Add Network",
    'bt_dns_acl_add_ip' => "Add IP Address",

    'dns_add__add_rec_for_zone' => "Add %1 for zone %2",
    'dns_add__canonical_dom_name_is_invalid' => "Canonical domain name is invalid.",
    'dns_add__enter_canonical_name' => "Canonical name",
    'dns_add__enter_dom_name' => "Domain name",
    'dns_add__enter_ip_address' => "IP address",
    'dns_add__enter_ip_mask' => "IP address and network mask",
    'dns_add__enter_mail_domain' => "Mail domain",
    'dns_add__enter_mail_exchanger' => "Mail exchange server",
    'dns_add__enter_nameserver' => "Name server",
    'dns_add__enter_txt_record' => "TXT record",
    'dns_add__enter_service_name' => "Service name",
    'dns_add__hint_service_name' => "Example: SIP (without underline symbol)",
    'dns_add__enter_protocol' => "Protocol",
    'dns_add__hint_protocol_name' => "Example: TCP (without underline symbol)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priority",
    'dns_add__specify_weight_of_service' => "Relative weight for records with the same priority",
    'dns_add__enter_target_host' => "Target host",
    'dns_add__hint_target_host' => "Example: example.com",
    'dns_add__enter_target_port' => "Target port",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Value",
    'dns_add-invalid-A_ip' => "IP address is invalid.",
    'dns_add-invalid-AAAA_ip' => "IP address is invalid.",
    'dns_add-invalid-PTR_ip_mask' => "Invalid IP address/netmask pair.",
    'dns_add-invalid-SRV_service_name' => "Invalid service name",
    'dns_add-invalid-SRV_protocol_name' => "Invalid protocol",
    'dns_add-invalid-SRV_target_port' => "Invalid target port",

    'dns_add__invalid_ip' => "IP address is invalid.",
    'dns_add__low' => "low",
    'dns_add__mail_dom_name_is_invalid' => "Mail domain name is invalid.",
    'dns_add__nameserver_is_invalid' => "Name server is invalid.",
    'dns_add__record' => "%1 record",
    'dns_add__select_prefer_for_mail_exchange_server' => "Specify priority of mail exchange server",
    'dns_add__unable_insert_new_dns_rec' => "Unable to insert new DNS record: %1",
    'dns_add__very_high' => "very high",
    'dom_ctrl__allowed' => "Allowed",
    'dom_ctrl__db' => "MariaDB/MySQL databases",
    'dom_ctrl__mssql_db' => "MS SQL databases",
    'dom_ctrl__disk_space' => "Disk space",
    'dom_ctrl__dom_adm' => "Domain %1 of %2",
    'dom_ctrl__dom_cl' => "Domain %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domain has forwarding set up with undefined forwarding URL",
    'dom_ctrl__domain_has_frame_forwarding' => "Domain has frame forwarding to the URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Domain has no hosting configured",
    'dom_ctrl__domain_has_physical_hosting' => "Web hosting is configured for this domain on IP address %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domain has standard forwarding to the URL %1",
    'dom_ctrl__maillists' => "Mailing lists",
    'dom_ctrl__mboxes' => "Mailboxes",
    'dom_ctrl__mg' => "Mail forwardings",
    'dom_ctrl__resource_name' => "Resource",
    'dom_ctrl__resp' => "Auto-replies",
    'dom_ctrl__subdom' => "Subdomains",
    'dom_ctrl__dom_aliases' => "Domain aliases",
    'dom_ctrl__traffic' => "Traffic",
    'dom_ctrl__unable_activate/deactivate_dom' => "Unable to activate/deactivate domain: %1",
    'dom_ctrl__used' => "Used",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Web users",
    'dom_pref__bounce_with_phrase' => "Bounce with message",
    'dom_pref__bounce' => "Bounce",
    'dom_pref__catch_addr' => "Forward to address",
    'dom_pref__reject' => 'Reject',
    'dom_pref__confirm_domain_removing' => "Please, do not forget to inform the domain visitors of the domain name change. Are you sure you want to rename the domain?",
    'dom_pref__db_inconsystency' => "database inconsistency.",
    'dom_pref__dbs' => "databases",
    'dom_pref__delete_traffic_stat' => "Retain web and traffic statistics",
    'dom_pref__delete_traffic_stat_older' => "Retain web and traffic statistics",
    'dom_pref__dom_level_name_conflict' => "The domain administrator's username conflicts with a username of one of the customers.",
    'dom_pref__invalid_disk_space_limit' => "Invalid disk space limit. Maximum value: %1",
    'dom_pref__invalid_expiration_date_limit' => "Invalid validity period.",
    'dom_pref__invalid_max_traffic_limit' => "Invalid traffic limit. Maximum value: %1",
    'dom_pref__limits_of_dom' => "Limits for domain %1",
    'dom_pref__mail_grps' => "mail groups",
    'dom_pref__mail_nonexistent_user' => "What to do with mail sent to non-existent users",
    'dom_pref__mail_redirs' => "mail forwarders",
    'dom_pref__mail_resps' => "mail auto-replies",
    'dom_pref__max_limit_is_invalid' => "%1 is invalid.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maximum number of %1 is invalid.",
    'dom_pref__new_limit_less_currently_used' => "%1: requested - %2, currently used - %3",
    'dom_pref__older_that' => " for ",
    'dom_pref__postboxes' => "mailboxes",
    'dom_pref__preferences_of_dom' => "Settings for domain %1",
    'dom_pref__redirect_to_itself' => "The domain will have the forwarding set to itself",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "You specified the domain traffic statistics retention time to be less than the total value defined for the server (%1 month(s)). The statistics retention period is set equal to the default value for the server (%1 month(s)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Unable to add a www prefix to domain: %1",
    'dom_pref__unable_define_physical_hst_param' => "Unable to define physical hosting parameters: %1",
    'dom_pref__unable_rename_domain' => "Unable to rename the domain %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Unable to set the mailbox quota for this domain: %1",
    'dom_pref__unable_set_up_web_user_script' => "Unable to set up scripting for web users: %1",
    'dom_pref__unlimited' => "Unlimited",
    'dom_pref__web_usrs' => "web users",
    'dom_pref__you_already_have_%object' => "You already have %1",
    'cu_domain__error_unable_update_ftp_users' => 'Failed to update the domain FTP users: %1',
    'dom_cli__warning_ignore_quota' => 'WARNING: Option "-hard_quota" is ignored: hard disk quota is not supported',
    'dom_user_client_login_exist' => "Unable to allow domain administrator's access to Plesk on the domain %1: this username is already in use.",
    'domain__unable_to_turn_on_service' => "Failed to switch on the %1 service.",
    'domains__change_the_status_of_domain?' => "Are you sure you want to change the status of domain %1?",
    'domains__client_info_hiding_traffic' => "%1 domains, %2 active domains, %3 disk space used",
    'domains__unable_to_change_client_status' => "Unable to change the customer account status: %1",
    'domains__unable_update_apache_settings' => "Unable to update Apache settings.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "You do not have permissions to delete domains.",
    'domains_list__unable_remove_doms' => "Unable to remove domains: %1",
    'domaintrafficlist_header_of_domain__' => "Traffic at domain %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Select the domain aliases to be removed.',
    'domain_aliases_remove__title' => 'Removing domain aliases',
    'domain_aliases__max_aliases_reached_for_dom' => "The limit on number of aliases is reached for this domain.",
    'domain_edit__edit_title' => 'Edit domain alias name',
    'domain_alias_edit__type' => 'Domain alias type',
    'domain_aliases__list_header' => 'Domain aliases',
    'domain_aliases__name' => 'Name',
    'domain_aliases__type' => 'Type',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Domain aliases',
    'domain_aliases__legend' => 'Domain aliases',
    'domain_alias__domain_exists' => 'A domain with such a name already exists',
    'domain_alias__subdomain_exists' => 'A subdomain with such a name already exists',
    'domain_alias__dns_record_exists' => 'A DNS record with the specified domain alias name already exists',
    'domain_alias__domain_alias_exists' => "A domain alias with such a name already exists",
    'domain_alias__invalid_type_full' => 'Mail server does not support domain aliases',
    'domain_alias__redirect_exists' => 'Redirection to itself was detected.',

    'ds__anonymous_ftp' => "Anonymous FTP",
    'drweb__pagetitle' => 'Antivirus Settings',
    'drweb__drweb' => 'Antivirus mail checking',
    'drweb__drweb_direction' => 'Checking mail for viruses',
    'drweb__drweb_direction_off' => 'Do not check for viruses',
    'drweb__drweb_direction_any' => 'Incoming and outgoing mail',
    'drweb__drweb_direction_from' => 'Outgoing mail only',
    'drweb__drweb_direction_to' => 'Incoming mail only',
    'drweb__disable_reason_key' => 'Antivirus is not supported by the license key.',
    'drweb__disable_reason_perm' => 'You have no permission to manage Antivirus.',
    'drweb__disable_reason_install' => 'Antivirus is not installed.',
    'drweb__filters' => 'Antivirus filters',
    'ds__dns' => "DNS Zone",
    'ds__mail' => "Mail",
    'dumps_list__deletion_page_title' => "The following backup files of domain %1 will be removed:",
    'dumps_list__dumpfile_is_invalid' => "The file %1 is not a valid domain backup file.",
    'dumps_list__page_title' => "Backup files storage",
    'dumps_upload__page_title' => "Uploading Backup Files to Storage",
    'dumps_list__repository_is_not_exist' => "Backup files storage does not exist.",
    'dumps_list__unable_to_remove' => "Unable to remove the backup file: %1",
    'dumps_list__dumpfile_can_conflict' => "The file name you specified conflicts with file %1 Please, specify another file name.",
    'dusr_ed__allow_dl_usr_access' => "Allow domain administrator access",
    'dusr_ed__information' => "Properties of Domain %1's Administrator",
    'dusr_ed__locale' => "Domain administrator's language",
    'dusr_ed__skin' => "Domain administrator's interface skin",
    'dusr_ed__personal_information' => 'Personal information',
    'ess__error' => "Error",
    'example__' => "Example: %1",
    'extras__allow_certificate_purchasing' => "Allow certificate purchasing",
    'extras__allow_domain_registration' => "Allow domain registration",
    'extras__allow_extras' => "Allow extra services",
    'extras__buy_new_key' => "Your current license does not allow you to modify these objects.",
    'extras__setup_services' => "Set up additional services",

    'ruleeditform__error' => 'Cannot update firewall rule.',
    'ruleeditform__name_is_required' => 'Specify the rule name.',
    'ruleeditform__profiles_is_required' => 'Select at least one profile.',
    'ruleeditform__invalid_ip' => 'The specified IP address or network is invalid.',
    'ruleeditform__invalid_port' => 'The specified port is invalid. The possible values are 1000 or 1000-1051',

    'get_password__encrypted_password' => "Unable to send the password information: the password is stored in the encrypted form.",
    'get_password__mail_error' => "An error occurred while attempting to send the password to email %1: %2",
    'get_password__mail_ok' => "The password was successfully sent to email: %1",
    'get_password__message' => "Your username for accessing the system: %1\nYour password is %2",
    'get_password__subject' => "Password for accessing the system",
    'groups__available' => "Available mail groups",
    'groups__groups_for_mailname' => "Mail groups to which the mail account %1 is subscribed",
    'groups__member_of' => "Member of the following mail groups",
    'help__help_area' => "Help area.",
    'hst_def__auth_disabled' => "prohibited",
    'hst_def__auth_enabled' => "allowed",
    'hst_def__change_curr_dns_ip' => "The current IP address of the A DNS record will be changed",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "None of the IP addresses of the A DNS record match with IP address assigned to the hosting account being created",
    'hst_def__dest_url' => "Destination URL",
    'hst_def__disk_quota' => "Disk quota",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "The disk space limit you are trying to set is exceeded by the disk space limit in the anonymous FTP incoming directory. The disk space limit in the anonymous FTP incoming directory must not exceed the domain disk space limit.",
    'hst_def__frame_forwarding_definition' => "Frame forwarding assignment for domain %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Warning: FTP user %1 is used in hosting account settings but does not exist in the system.",
    'hst_def__hst_type_is_not_defined' => "Hosting type is not defined",
    'hst_def__ip_based' => "IP-based",
    'hst_def__name_based_power_anonymous_ftp_down' => "Transferring this hosting account to shared IP address will make anonymous FTP service on this domain unavailable. Proceed anyway?",
    'hst_def__password_is_invalid_password_syntax' => "Password is invalid.\nDo not use single quote and national alphabet characters in a password.\nThe password length should be from 5 to 14 characters. The password should not contain the user name.",
    'hst_def__shell' => "SSH access to the server shell under the subscription's system user",
    'hst_def__shell_windows' => "Remote Desktop access to the server under the subscription's system user",
    'hst_def__standard_forwarding_definition' => "Standard forwarding assignment for domain %1",
    'hst_def__title_name_based' => "Name-based",
    'hst_def__unable_create/update_physic_hst' => "Unable to create/update physical hosting: %1",
    'hst_def__unable_create/update_std_fwd' => "Unable to create/update standard forwarding: %1",
    'hst_def__unable_create_forwarding_myself' => "Unable to create forwarding to the domain itself.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Unable to allow the use of a single directory for storing SSL/TLS and non-SSL/TLS content: SSL/TLS support is not switched on.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Unable to turn on SSL/TLS support: no SSL/TLS certificate installed.",
    'hst_def__url_is_invalid' => "URL is invalid.",
    'hst_def__virtual_host_access' => "Virtual host access for domain %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "WARNING. This virtual host is using a non-existent IP address for hosting.",
    'hst_def__you_have_no_ips' => "You have no IP addresses available and you are not allowed to create Name-based hosting.",
    'hst_sel__header' => "To host a website on this server, select the Physical hosting option.\n To set up domain forwarding to a site on another machine, select Frame forwarding or Standard forwarding option.\n With standard forwarding, a user is redirected to the site and the actual site's URL is shown in the user's browser, so the user knows about the redirection. With frame forwarding, a user is redirected to the site without knowing that the site actually resides at another location.",
    'hst_sel__physical_hst' => "Physical hosting",
    'hst_sel__select_hst_type' => "Select the type of hosting for the domain",
    'hst_sel__select_hst_type_warning' => "Select the type of hosting for the domain",
    'hst_sel__hosting_exists' => "Unable to create hosting, as it is already configured for this domain. You will be redirected to the hosting management page.",
    'hst_sel__standard_frw' => "Standard forwarding",
    'hst_sel__frame_frw' => "Frame forwarding",
    '__frame_frw' => "Frame forwarding",
    '__hosting_exists' => "Unable to create hosting, as it is already configured for this domain. You will be redirected to the hosting management page.",
    '__choose_hst_type' => "Select the required hosting type.",
    '__no_hst_conf' => "There is no hosting configured for your domain.",
    '__physical_hst' => "Physical hosting",
    '__select_hst_type' => "Select the type of hosting for the domain",
    '__standard_frw' => "Standard forwarding",
    '__warning' => "Warning! All of the previously set parameters will be discarded. Are you sure you want to change the hosting type?",
    'i_cl_off' => "Customer is inactive.",
    'i_cl_off_by_admin' => "Customer account is suspended by server administrator.",
    'i_cl_off_expired' => "Customer account is expired.",
    'i_cl_on' => "Customer is active.",

    'icf__title' => 'Internet Connection Firewall',
    'icf__if_legend' => 'Interfaces',
    'icf__mode' => 'Mode',

    'invalid_value' => 'Value is invalid',

    'ip_addr__already_exists' => "IP address %1 already exists.",
    'ip_addr__cant_add' => "IP %1 does not exist or belongs to IP pool of another customer",
    'ip_alias__interface' => "Interface ",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP address for name-based virtual hosting is invalid.",
    'ip_alias__invalid_ip_or_netmask' => "Invalid IP address/netmask pair.",
    'ip_alias__orig_ip_can_not_be_deleted' => "The IP address %1 is the original server IP, so you cannot remove it.",
    'ip_alias__ip_is_invalid' => "%1 IP address is invalid.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP mask is invalid.",
    'ip_alias__ip_not_exist' => "IP address %1 does not exist.",
    'ip_alias__ip_address_and_mask' => 'IP address and subnet mask',
    'ip_alias__mask' => "Subnet Mask",
    'ip_alias__remove_selected_ip_aliases?' => "Are you sure you want to remove the selected IP addresses?",
    'ip_alias__select_ip' => "Select at least one IP address from the list to remove it.",
    'ip_alias__this_ip_used_for_domain' => "(%1) this IP address is used for domain %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) this IP address is used for name-based virtual hosts.",
    'ip_alias__unable_add_ip' => "Unable to add IP: %1",
    'ip_alias__unable_remove_ip' => "Unable to remove IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "You cannot change the IP address type to shared, as it will make Anonymous FTP for domain '%1' unavailable.",
    'ip_ctrl__ip_addr' => "IP address %2 on the interface %1",
    'ip_ctrl__ip_exists_many_pools' => "You cannot change the IP type. This IP address belongs to the pools of several users at the same time.",
    'ip_ctrl__ssl_cert' => "SSL/TLS Certificate",
    'limit__date_in_past' => "Validity period is invalid. %1 is in the past.",
    'limit__enter_date' => "Enter date",
    'limit__max_db' => "Databases",
    'limit__name_disk_space' => "disk space",
    'limit__name_max_box' => "mailboxes",
    'limit__name_max_db' => "MariaDB/MySQL databases",
    'limit__name_max_dom' => "domains",
    'limit__name_max_maillists' => "mailing lists",
    'limit__name_max_subdom' => "subdomains",
    'limit__name_max_traffic' => "traffic",
    'limit__name_max_wu' => "web users",
    'limit__name_mbox_quota' => "mailbox quota",
    'limit__name_max_mn' => "mail accounts",
    'limit__name_max_cl' => 'clients',
    'limit__name_total_mboxes_quota' => "total mailbox quota",
    'limit__name_mysql_dbase_space' => "MariaDB/MySQL database space",
    'limit__name_mssql_dbase_space' => "MSSQL database space",
    'limit__name_pgsql_dbase_space' => "PostgreSQL database space",
    'limit__name_expiration' => 'expiration date',

    'locale_upload__unable_to_install' => 'Unable to install the language pack file',
    'locale_upload__wrong_package' => 'The file you uploaded does not contain a language pack valid for this Plesk version.',
    'locale_upload__wrong_locale' => 'The file you uploaded does not contain a valid language pack.',

    'ma__create_title' => 'Creating mail alias for %1',
    'ma__edit_title' => "Edit mail alias %1",
    'ma__enter_new_alias' => "Enter new alias.",
    'ma__invalid_alias' => "Invalid mail alias.",
    'ma__mail_aliases_mailname' => "Mail aliases for mail account %1",
    'ma__mailname_does_not_exist' => "Mail account does not exist.",
    'ma__select_ma_for_remove' => "Select mail aliases to be removed.",
    'ma__unable_to_add_new_ma' => "Unable to add a mail alias: %1",

    'mail_queue__not_allowed_by_license_key' => 'Mail queue management is not allowed by the license key.',
    'maillist__' => "Mailing list %1",
    'maillist__already_exists' => "Mailing list already exists.",
    'maillist__mail_alias_already_exists_in_this_domain' => "The mail alias %1 already exists in this domain",
    'maillists__' => "Mailing lists %1",
    'maillists__limit_cl_max_maillists' => "The limit on number of mailing lists was reached for the customer (limit: %1, used: %2)",
    'maillists__limit_dom_max_maillists' => "The limit on number of mailing lists was reached for the domain.",
    'maillists__list' => "Mailing lists",
    'maillists__mailman_not_installed_or_conf' => "\nMailman Server Extensions are not currently installed or configured\non the server. Contact the server administrator to have the Mailman Server Extensions installed or properly configured.",
    'maillists__status' => "Mailing list service is switched on",
    'maillists__unable_to_delete__' => "Unable to delete the mailing list: %1",
    'maillists__disabled_text' => 'You cannot manage mailing lists because Mailman mailing lists server component is not installed or configured.',
    'maillist_member__already_exists' => 'Mailing list subscriber already exists.',
    'maillist_member__not_exists' => 'There is no such user on the mailing list.',
    'mailserver_switching_warning' => "Warning!\n\nChanging mail server is intended only for initial setup and, if the server is already in use, causes the following problems: loss of settings and mailboxes content, and, in cases when the server you switch to is already configured, various conflicts.\nIf this server is in use now and you are certain about switching to another, you can notify your customers about the operation so that they could download and save their mail.",
    'manager__access_denied' => "Access denied: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Customer',
    'manager__domain' => "Domain",
    'manager__domain_cl_limit_exceeding' => "The limit on number of domains is reached for this customer account.",
    'manager__domain_is_not_yours' => "Domain %1 does not belong to you.",
    'manager__domain_key_limit_exceeding' => "The limit on domain creation defined by your license key is reached.",
    'manager__no_perm_to_call' => "You do not have the permission to call %1.",
    'manager__no_perm_to_create_domains' => "You do not have the permission to create domains.",
    'manager__no_perm_to_modify_domain' => "You do not have the permission to modify domain %1.",
    'manager__no_perm_to_modify_domains' => "You do not have the permission to modify domains.",
    'manager__no_perm_to_remove_domain' => "You do not have the permission to remove domain %1.",
    'manager__no_perm_to_remove_domains' => "You do not have the permission to remove domains.",
    'manager__node_doesnt_exist' => "%1 does not exist.",
    'manager__user_disabled' => "Your account is suspended. You cannot operate the system.",
    'mail_quota_unsupported' => "not supported by the mail server",
    'mbox_quota_unsupported' => "not supported by the mail server",
    'mn__create_title' => "Create mail account",
    'mn__edit_title' => "Settings",
    'mn__files_list_title' => "Attachment Files",
    'mn__files_remove' => "Remove files from attachments repository. This files are possibly used by auto-replies. They will be removed from both the repository and auto-replies using them.",
    'mn__files_select_for_remove' => "Select files to be removed.",
    'mn__mail_alias_form' => "Mail alias form",
    'mn__mail_aliases_list' => "Mail aliases",
    'mn__mailbox' => "Mailbox management",
    'mn__unable_define_mn' => "Unable to set up mail accounts: %1",
    'mn__unable_remove_mbox_quota' => "Unable to remove mailbox quota: %1",
    'mn__upload_file' => "Upload file",
    'mn_edit__attach_filename_changed' => 'The uploaded file %1 was renamed to %2 because its name contained non-ASCII characters.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "You should add a mail group member before enabling the mail group.",
    'mn_edit__add_resp_or_turn_off_box' => "You should add auto-reply or clear the auto-reply check box.",
    'mn_edit__attachments' => "Attachments",
    'mn_edit__dom_quota_less_then_quota' => "The size of this mailbox must not exceed the limit on amount of disk space allocated for mailboxes in this domain.",
    'mn_edit__enter_external_rcpnt_email' => "Enter external mail group member's email",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Type an address for mail forwarding or clear the check box.",
    'mn_edit__ext_rcpnt_email_invalid' => "External recipient's email address is invalid.",
    'mn_edit__file_exists' => "File exists. Overwrite?",
    'mn_edit__files_deld_from_repository' => "These files will be deleted from repository and auto-replies containing them. Do you want to proceed?",
    'mn_edit__mail_name' => "Mail account",
    'mn_edit__mail_name_invalid' => "Mail account name is invalid.",
    'mn_edit__mail_redir' => "Mail forwarders",
    'mn_edit__mail_redir_add' => "Add Mail Group Member",
    'mn_edit__mail_resps' => "Mail auto-replies",
    'mn_edit__mailbox' => "Mailbox",
    'mn_edit__enable_mailbox' => "Mailbox",
    'mn_edit__mailgroup' => "Mail group",
    'mn_edit__mailgroup_addresses' => "Mail group members",
    'mn_edit__mailgroup_disabled' => "Available only when mail account is already added.",
    'mn_edit__max_dom_quota' => "Default for the domain (%1)",
    'mn_edit__mbox_quota_invalid' => "Icorrect mailbox size specified.",
    'mn_edit__new_resp_name' => "New auto-reply name",
    'mn_edit__no_autoresponders' => "You should add at least one auto-reply before turning the auto-reply service on/off.",
    'mn_edit__no_file_sel' => "No files selected.",
    'mn_edit__no_mail_addresses' => "No email addresses were specified or selected.",
    'mn_edit__none' => "None",
    'mn_edit__not_create_pass' => "This will not create a password for this account.\nWithout password, user will not be able to view and send mail.",
    'mn_edit__redir_email_invalid' => "Forwarding address is invalid.",
    'mn_edit__redirect_addr' => "Forwarding address",
    'mn_edit__remove_autoresp?' => "Are you sure you want to remove the auto-reply?",
    'mn_edit__remove_rcpnts?' => "Are you sure you want to remove these recipients?",
    'mn_edit__repository' => "Repository",
    'mn_edit__resps_attach' => "Auto-reply attachment files",
    'mn_edit__select_rcpnt_from_list' => "Select at least one recipient from the list to remove it.",
    'mn_edit__select_registered_users' => "Select registered users",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "You have chosen to have a mailbox but have not set up the password for it.",
    'mn_edit__unable_act_deact_mail_group' => "Unable to activate or deactivate mail group: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Unable to activate or deactivate mail forwarding: %1",
    'mn_edit__unable_act_deact_postbox' => "Unable to activate or deactivate mailbox: %1",
    'mn_edit__unable_act_deact_resp' => "Unable to activate or deactivate auto-replies: %1",
    'mn_edit__unable_add_attach' => "Unable to add attachment file: %1",
    'mn_edit__unable_add_mail_group_member' => "Unable to add mail group member: %1",
    'mn_edit__unable_add_resp' => "Unable to add auto-reply: %1",
    'mn_edit__unable_change_mail_name' => "Unable to change mail account name: %1",
    'mn_edit__unable_deactivate_mail_group' => "Unable to deactivate mail group: %1",
    'mn_edit__unable_deactivate_resp' => "Unable to deactivate mail auto-replies: %1",
    'mn_edit__unable_define_resp_id' => "Unable to define auto-reply ID: %1",
    'mn_edit__unable_remove_attach' => "Unable to remove attachment file(s): %1",
    'mn_edit__unable_remove_autoresp' => "Unable to remove auto-reply: %1",
    'mn_edit__unable_remove_mail_group_member' => "Unable to remove mail group members: %1",
    'mn_edit__wrong_way' => 'The messages addressed to %1 will not be delivered, as this mail account does not have a mailbox or mail forwarder switched on.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'The mailbox at the address %1 was switched off. The messages in the mailbox were not removed, but you will not be able to retrieve them through IMAP or POP3 protocol.',
    'mn_list__mail_names_for_domain' => "Mail accounts under the domain %1",
    'mn_list__sa_cannot_unable' => "Unable to switch on spam filtering",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Customer',
    'mn_list__tab_title_domain' => 'Domain',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Name",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Unable to remove the mail accounts: %1",
    'module_upload__module_was_installed' => 'This module is already installed. If you wish to install a newer version of this module, please deinstall the module through Plesk, and then try installing.',
    'module_upload__unable_to_install' => 'Unable to install the module package file',
    'module_upload__wrong_package' => 'The uploaded file is not a supported module package.',
    'module_upload__wrong_module' => 'The uploaded file does not contain a module package.',

    'news_articles_title' => 'Plesk News',
    'notification_text__invalid_subject_length' => "Invalid notice subject length. Should be from 1 to 255 characters.",
    'notification_text__invalid_text_length' => "Invalid notice text length. Should be from 1 to 65533 characters.",
    'notification_text__subject' => "Notice subject",
    'notification_text__text' => "Notice text",
    'notification_text__title' => "Edit notice",
    'notification_text__unable_set_text' => "Unable to modify notice text: ",

    'odbc__cant_add_dsn' => "Unable to add DSN %1: %2",
    'odbc__cant_connect' => "Unable to connect to the data source using the defined settings. Server has returned: %1",
    'odbc__cant_delete_dsn' => "Unable to delete DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Unable to get information about drivers.",
    'odbc__cant_get_drivers' => "Unable to retrieve a list of ODBC drivers: %1",
    'odbc__cant_open_info_file' => "Unable to open the file with ODBC drivers information.",
    'odbc__cant_parse_string' => "Unable to parse the connection string.",
    'odbc__driver_not_set' => "Driver is not set",
    'odbc__driver_or_name_not_set' => "Driver or name of the ODBC connection were not set",
    'odbc__dsn_already_exists' => "DSN with this name (%1) already exists in the system",
    'odbc__dsn_not_exists' => "This DSN does not exist",
    'odbc__enter_dsn_name' => "Enter DSN name",
    'odbc__invalid_dsn_name' => "Wrong syntax for ODBC connection name (%1): please use only alphanumeric symbols.",
    'odbc__no_such_driver' => "An ODBC driver with such a name (%1) is not supported.",
    'odbc__unknown_driver' => "Unknown driver name (%1).",
    'odbc_dsn_system' => "System DSN",

    'pb__aliases' => "Aliases",
    'pb__anonftp' => "Anonymous FTP",
    'pb__autoinstaller_releases' => 'Updater',
    'pb__cert' => "Certificates",
    'pb__cl_pool' => "IP addresses",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Settings",
    'pb__cl_rpt' => "Report",
    'pb__cl_rpt_list' => "Customize",
    'pb__cl_templates' => "Customer templates",
    'pb__cl_traffic' => "Traffic",
    'pb__cl_traffic_history' => "Traffic history",
    'pb__cl_traffic_of' => "Traffic of %1",
    'pb__client' => "%1",
    'pb__clients' => "Customers",
    'pb__comp_info' => "Server Components",
    'pb__common_acl' => 'Allow Transfer ACL',
    'pb__cp_access' => "Access",
    'pb__crontab' => "Scheduler",
    'pb__scheduler' => "Scheduler",
    'pb__custom_buttons' => "Custom Buttons",
    'pb__databases_db' => 'Databases',
    'pb__sqlservers_db' => 'SQL Servers', //to check
    'pb__db' => "Databases",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Database servers',
    'pb__dl_usr_ed' => "Domain administrator",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domain limits",
    'pb__dom_pref' => "Settings",
    'pb__dom_sum_report' => "Domain Summary Report",
    'pb__dom_templates' => "Domain Templates",
    'pb__dom_traffic' => "Traffic of %1",
    'pb__domains' => "Domains",
    'pb__domain_aliases' => 'Domain Aliases',
    'pb__dumps_list' => "Backup Files Storage",
    'pb__forwarding_setup' => "Forwarding Setup",
    'pb__filemanager' => "File Manager",
    'pb__ip_aliasing' => "IP Addresses",
    'pb__ip_clients' => "IP Addresses removal",
    'pb__license_management' => 'License Information',
    'pb__locales' => 'Locales',
    'pb__log_files' => "Log files",
    'pb__mail' => 'Mail',
    'pb__mail_name_files' => "Attachment files",
    'pb__mail_name_redirects' => "Mail forwarders",
    'pb__mail_name_resp_attach_add' => "New attachment",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Mail auto-replies",
    'pb__mail_names' => "Mail",
    'pb__maillists' => "Mailing lists",
    'pb__modules' => 'Modules',
    'pb__modules_management' => 'Manage Modules',
    'pb__notifications' => "Notifications",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Physical hosting setup",
    'pb__prtd_dirs' => "Protected Directories",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Customize",
    'pb__server' => "Server",
    'pb__sessions' => "Sessions",
    'pb__sapp_pool' => "Web Application Pool",
    'pb__siteapp_install' => 'Web application installation',
    'pb__site_app_pkgs' => 'Web Applications',
    'pb__site_apps' => "Web Applications",
    'pb__additional_key_info' => 'Key Properties',
    'pb__additional_key_properties' => 'Key Properties',
    'pb__skins' => 'Skins',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Spam Filter",
    'pb__statistics' => "Statistics",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomains",
    'pb__templates' => "Templates",
    'pb__virtualdirs' => 'Virtual directories',
    'pb__web_users' => "Web users",
    'pdir__invalid_hst' => "Hosting type is invalid. Must be physical.",
    'pdir__pd_id_is_undefined' => "Protected directory ID is undefined.",
    'pdir__pdir_exist' => "Directory with this name is already protected.",
    'pdir__pdir_not_exist' => "Protected directory does not exist.",
    'pdir__pdir_usr_not_exist' => "Protected directory user does not exist.",
    'pdir__remove_pdir_usrs' => "The following users of protected directory %2 under the website %1 will be removed:",
    'pdir__remove_pdir_usrs_on_subdom' => "The following users of protected directory %2 under the subdomain %1 will be removed:",
    'pdir__select_pdir_usrs_for_remove' => "Select the protected directory users to be removed.",
    'pdir__select_pdirs_to_remove' => "Select the directories to remove protection from.",
    'pdir__unable_define_pdir_users' => "Unable to define the protected directory users.",
    'pdir__unable_define_pdirs_properties' => "Unable to set the properties of protected directories: %1",
    'pdir__unable_select_dom_param' => "Unable to select domain parameters: %1",
    'pdir_ed__dir_already_protect' => "This directory is already protected.",
    'pdir_ed__invalid_login' => "You specified incorrect username.",
    'pdir_ed__login_exists' => "This user already exists. Try specifying another username.",
    'pdir_ed__pdir_users' => "Protected directory users",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "At least one check box should be selected from SSL/TLS and non-SSL/TLS check boxes.",
    'pdir_ed__unable_cr_pdir_usr' => "Unable to create the protected directory user: %1",
    'pdir_ed__unable_create_pdir' => "Unable to create the protected directory: %1",
    'pdir_ed__unable_define_hst_type' => "Unable to define the hosting type.",
    'pdir_ed__unable_update_pdir' => "Unable to save settings of the protected directory: %1",
    'pdir_ed__wrong_symbol_in_header' => "Please do not use the character %1 in the directory title.",
    'pdir_usr_ed__not_create_pass' => "This will not create a password for the new protected directory user.\nWithout password the user will not be able to log in.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Unable to select the protected directory user: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Unable to define the protected directory users: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Unable to remove the protected directory users: %1",
    'phosting__anonftp_encrypt' => 'The password of FTP user is encrypted, and therefore cannot be used for protecting directory /plesk-stat/webstat/. Please reenter your FTP password, or deselect the option "accessible via password protected directory \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "The domain name %%domain_name%% resolves to the IP address %%dns_ip_address%%. Your website is assigned the IP address %%hosting_ip_address%%. If your website does not open in a web browser when you refer to it by its domain name, go to the DNS management screen (Domains > Domain name > DNS) and change the properties of the A resource record: assign the IP address %%hosting_ip_address%% to the domain name %%domain_name%%.",
    'phosting__ip_change_warning' => "IP address changed. The corresponding changes were also made in the domain's DNS zone.",
    'phosting__other_hosting_exists_on_ip' => "Unable to change the certificate because this IP address is being used in one or several hosting accounts.",
    'phosting__unable_to_change_certificate' => "Unable to install the certificate: %1",
    'phosting__unable_to_change_ip_address' => "Unable to change the IP address: %1",
    'phosting__unable_to_set_cert' => "Unable to set the SSL/TLS certificate: %1",
    'phosting__unable_update' => "Unable to update hosting settings: %1",
    'phosting__unable_manage' => "Unable to manage hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Could not configure fail2ban to track logs of the domain. Logs will be automatically tracked the next time fail2ban service restarts.\n%1",

    'picker_acl_record__tittle' => 'Select an ACL record',
    'picker_autoresponder__title' => 'Select an Auto-reply',
    'picker_black_list__domain_name' => 'Select a Domain Name',
    'picker_certificate' => 'Select an SSL/TLS Certificate',

    'picker_dns_zone_template__title' => 'Select a Resource Record',
    'picker_domain__title' => 'Select a Website',
    'picker_domain_alias__title' => 'Select a Domain Alias',
    'picker_resource_record__title' => 'Select a Resource Record',
    'picker_disabled_resource_record__title' => 'Select a Name Server',
    'picker_ip_address__title' => 'Select an IP Address',
    'picker_ip_address_clients__title' => 'Select Customers Who Use This IP Address',
    'picker_mail_queue' => 'Select Email Messages',
    'picker_site_application__title' => 'Select a Web Application',
    'picker_subdomain__title' => 'Select a Subdomain',
    'picker_web_user__title' => 'Select a Web User',
    'picker_custom_button__title' => 'Select a Custom Button',
    'picker_license_key__title' => "License key selection",
    'picker_spamfilter_address__title' => 'Select a Spam Filter Address',
    'picker_white_list__networks' => 'Networks selection',

    'plesk_key__action_logs' => "Logging of actions performed by Plesk users",
    'plesk_key__app_vault' => "Application vault",
    'plesk_key__backup' => "Backup and restoration functions",
    'plesk_key__client_templs' => "Service plans management",
    'plesk_key__clients' => "User accounts (resellers and customers)",
    'plesk_key__resellers_only' => "User accounts (resellers)",
    'plesk_key__customers_only' => "User accounts (customers)",
    'plesk_key__domains' => "Domains",
    'plesk_key__domain_aliases' => "Domain aliases",
    'plesk_key__subdomains_limit' => "Subdomains",
    'plesk_key__databases' => "Databases",
    'plesk_key__mssql_databases' => "MS SQL databases",
    'plesk_key__manage_dashboard' => 'Home page customization',
    'plesk_key__drweb' => "Antivirus management",
    'plesk_key__event_manager' => "Event manager",
    'plesk_key__expirations' => "Management of account expiration dates",
    'plesk_key__group_ops' => "Modification of multiple objects at once",
    'plesk_key__expiration' => "Key expiration date",
    'plesk_key__edition_name' => "Plesk Edition",
    'plesk_key__key_number' => "Key number",
    'plesk_key__languages' => "Language packs",
    'plesk_key__mailnames' => "Mail accounts",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL Server support",
    'plesk_key__myplesk_func' => "Links for purchasing SSL/TLS certificates and domain registration services",
    'plesk_key__myplesk_server_id' => "MPC slave server identifier",
    'plesk_key__notifications' => "Notifications management",
    'plesk_key__postgresql' => "PostgreSQL database server support",
    'plesk_key__qmail_queue' => 'Mail queue management',
    'plesk_key__remote_db' => 'Remote database hosting',
    'plesk_key__slave_servers' => "Slave servers",
    'plesk_key__spamassassin' => "Spam filter management",
    'plesk_key__subdomains' => "Subdomains management",
    'plesk_key__sys_access' => "Management of access to the server",
    'plesk_key__traffic_reports' => "Traffic usage reports",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Valid for Virtuozzo containers only",
    'plesk_key__webusers' => "Web users",
    'plesk_key__license_update_date' => 'Next license key update',
    'plesk_key__autoinstaller_config' => 'Updater settings management',
    'plesk_key__check_wrong' => "The license key is invalid. In order to use Plesk, please obtain and install a new valid license key.",
    'plesk_key__upload_check_wrong' => 'Uploaded license key is not valid.',
    'plesk_key__revert_check_wrong' => 'Previously installed license key is not valid.',
    'plesk_key__viruozzo_only_key' => 'The license key is intended only for use with Plesk operating inside Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'You can use this licensed Plesk copy only with the following IP addresses: %2. The following IP addresses are not covered by your license: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'The amount of currently used resources exceeds the limits defined by your license.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'The number of websites hosted on the server exceeds the limits defined by your license. You have %2 sites hosted; your license allows hosting only %1 sites.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'The number of domain aliases on the server exceeds the limits defined by your license. You have %2 domain aliases; your license allows hosting only %1 domain aliases.',
    'plesk_key__limits_exceeded_lim-subdom' => 'The number of subdomains on the server exceeds the limits defined by your license. You have %2 subdomains; your license allows hosting only %1 subdomains.',
    'plesk_key__limits_exceeded_lim-db' => 'The number of databases on the server exceeds the limits defined by your license. You have %2 databases; your license allows hosting only %1 databases.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'The number of MS SQL databases on the server exceeds the limits defined by your license. You have %2 databases; your license allows hosting only %1 databases.',
    'plesk_key__limits_exceeded_lim_cl' => 'The number of served customer accounts exceeds the limits defined by your license. You have %2 customer accounts currently served; your license allows serving only %1 customer accounts.',
    'plesk_key__limits_exceeded_lim_mn' => 'The number of served email accounts exceeds the limits defined by your license. You have %2 email accounts currently served; your license allows serving only %1 email accounts.',
    'plesk_key__limits_exceeded_lim_wu' => 'The number of served web user accounts exceeds the limits defined by your license. You have %2 web user accounts currently served; your license allows serving only %1 web user accounts.',
    'plesk_key__limits_exceeded_MLS' => 'The number of currently installed language packs exceeds the limits defined by your license. There are %2 language packs installed; your license allows installing only %1 language packs.',
    'plesk_key__wrong_version' => 'You are trying to use a license key created for another version of Plesk. Contact Plesk sales representatives to obtain the proper license key.',
    'plesk_key__other_product' => 'You are trying to use a license key created for another product. Contact Plesk sales representatives to obtain the proper license key.',
    'plesk_key__invalid_machine_id_trial' => 'Your current license is not valid because it is already activated on another Plesk server. To continue using Plesk, either install a new license or install your current license once again by entering its activation code (if you have one).',
    'plesk_key__invalid_machine_id_retail' => 'Your current license is not valid because it is already activated on another Plesk server. The WebPros EULA (https://www.plesk.com/legal/) prohibits the use of a single license on two or more servers at the same time. To continue using Plesk, either install a new license or install your current license once again by entering its activation code. It was sent to you by email when you purchased the license. <br>Cannot find the activation code? You can retrieve it using Plesk 360. To do so, log in to https://platform360.io/ with the email you used to purchase the license, go to the "Licenses" tab, and see your license\'s activation code. Or you can contact Plesk Licensing and Purchase support using the online form (https://www.plesk.com/licensing-and-purchase-support/). Remember to mention your license number in the "How can we help you?" section of the form.',
    'plesk_key__limits_exceeded_error' => 'Unable to install the license key: the currently used amounts of resources exceed the limits defined within the uploaded license key.',
    'plesk_key__limits_exceeded_note' => 'The currently used amounts of resources exceed the limits defined within the uploaded license key.',
    'plesk_key__key_file_invalid' => 'The uploaded key file is not valid or does not contain a license key.',
    'plesk_key__server_request_error' => 'Could not update the license. Make sure that connections to the license server ka.plesk.com on TCP port %1 are not blocked. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">See how to do so</a>.',
    'key__no_key_file_in_zip' => 'The uploaded .zip file does not contain key file',
    'key__key_upload' => 'License Key Installation',
    'additional_key__prop_name' => 'Property',
    'additional_key__prop_value' => 'Value',
    'additional_key__descr_name' => 'Key name',
    'additional_key__descr_key_number' => 'Key number',
    'additional_key__descr_key_vz' => "This license key is intended for use only in Virtuozzo containers.",
    'additional_key__descr_key_mailboxes' => 'Mailboxes',
    'additional_key__descr_lim_date' => 'Expiration date',
    'additional_key__descr_license_update_date' => 'Next license key update',
    'additional_key__file_invalid' => 'The uploaded key file is not valid or does not contain a license key.',
    'additional_key__file_incompatible' => 'The uploaded key file is not valid for this application.',
    'additional_key__not_exists' => 'No license key installed.',
    'additional_key_update__result_response' => 'Licensing server response: %1',
    'additional_key_update__result_network' => 'Unable to connect to the licensing server. Please make sure that your network allows communication to %1: %2.',
    'additional_key_update__result_lock' => 'Key update is already in progress',
    'additional_key_update__result_internal_error' => 'Error occurred while updating the license key: %1',

    'proceed_to_cl_pool' => "Proceed to configuring customer's IP pool",
    'proceed_to_hosting_setup' => "Proceed to hosting setup",
    'removeCerts__remove_certificates_cp' => "The following certificates will be removed: ",
    'removeCerts__remove_certificates_domain' => "The following certificates owned by %1 will be removed: ",
    'removeClientsIP_remove_clients_ip' => "This IP address will be removed from the pools of the following customers:",
    'removeMailAliases__remove_mail_aliases' => "The following mail aliases for the mail account %1 will be removed:",
    'removeMailNames__remove_mailnames' => "The following mail accounts and aliases will be removed from the domain %1:",
    'removeMailNames__remove_mailnames_of_cl' => "The following mail accounts and aliases will be removed from domain %2 owned by customer %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "These mail accounts will not be deleted.",
    'removeFtpSessions__remove_title' => "The following FTP sessions will be ended:",
    'removeTemplates__remove_templates' => "The following templates will be removed:",
    'resp_edit__always_respond' => "always respond",
    'resp_edit__reply_subject' => "Reply subject",
    'resp_edit__answer_subject' => "Answer with subject",
    'resp_edit__answer_txt' => "Reply with text",
    'resp_edit__attach' => "Attach files",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "for ",
    'resp_edit__frw_rqst_email' => "Upon automatic response, forward the original message to the specified email",
    'resp_edit__fwd_email_invalid' => "Destination email address is invalid.",
    'resp_edit__in_body' => "when specified words are found in the message body",
    'resp_edit__in_subject' => "when specified words are found in message subject",
    'resp_edit__invalid_resp_freq' => "Response frequency is invalid.",
    'resp_edit__invalid_rqst_txt' => "Invalid request text.",
    'resp_edit__invalid_store_lim_num' => "Limit value is invalid.",
    'resp_edit__limits_title' => "Limits",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Number of maximum responses per day exceeds the defined rate. Allowed: %1, requested: %2",
    'resp_edit__no_files_sel' => "No files selected.",
    'resp_edit__no_txt_supplied' => "No text supplied.",
    'resp_edit__reply_title' => "Reply",
    'resp_edit__reply_to_address' => "Return address",
    'resp_edit__reply_to_invalid' => "Return address is invalid.",
    'resp_edit__reply_uniq_email' => "Reply to the unique email address not more than",
    'resp_edit__conditions_title' => "Conditions",
    'resp_edit__request_title' => "Request",
    'resp_edit__resp' => "Auto-reply",
    'resp_edit__resp_name' => "Auto-reply name",
    'resp_edit__resp_not_exist' => "Auto-reply does not exist.",
    'resp_edit__resp_status' => "Auto-reply status",
    'resp_edit__rqst_txt' => 'Specify the condition for this automatic reply',
    'resp_edit__select_files_on_server_for_attach' => "Select the files you want to attach",
    'resp_edit__store_up_to' => "Store up to",
    'resp_edit__subj_line_invalid' => "Subject line is incorrect.",
    'resp_edit__text_too_big' => "The reply message text is too large.",
    'resp_edit__times_in_a_day' => "times a day.",
    'resp_edit__unable_define_resp_cond' => "Unable to define the auto-reply condition: %1",
    'resp_edit__unable_define_resp_status' => "Unable to define auto-reply status: %1",
    'resp_edit__unable_turn_on_resp' => "Unable to turn on the auto-reply: %1",
    'resp_edit__uniq_email' => "unique email addresses",
    'resp_edit__content_type' => 'Mail sending format',
    'resp_edit__content_type_text' => 'Plain text',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Encoding',
    'restart__dns' => 'DNS Server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 Server (%1)",
    'restart__mssql' => "Microsoft SQL server",
    'restart__mysql' => "MariaDB/MySQL server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Services",
    'restart__smtp' => "SMTP Server (%1)",
    'restart__spamd' => "Spam Filter",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Web Server (%1)",
    'restart__ftp' => "FTP Server (%1)",
    'restart__service_start' => 'Please allow for some time for the service to start.',
    'restart__service_stop' => 'Please allow for some time for the service to stop.',
    'restart__service_restart' => 'Please allow for some time for the service to restart.',
    'rm_domains__some_domains_are_not_exist' => "Some of the specified domains do not exist. Possibly, they were removed by another user.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Forwarders",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Report for the administrator %1",
    'rpt_cl_report_for_reseller__' => "Report for the reseller %1",
    'rpt_cl_report_for_cl__' => "Report on the customer %1",
    'rpt_cl_section_domains' => "Domains",
    'rpt_cl_section_full_domains' => "Domains",
    'rpt_cl_section_general' => "General",
    'rpt_create' => "Create report",
    'rpt_empty' => "The report should contain at least one section",
    'rpt_dom_report_for_dom__' => "Domain report for %1",
    'rpt_dom_section_databases' => "Databases",
    'rpt_dom_section_full_databases' => "Databases",
    'rpt_dom_section_full_maillists' => "Mailing lists",
    'rpt_dom_section_full_mailnames' => "Mail accounts",
    'rpt_dom_section_full_webusers' => "Web users",
    'rpt_dom_section_full_siteapps' => 'Web applications',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET web applications',
    'rpt_dom_section_general' => "General",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Mailing lists",
    'rpt_dom_section_mailnames' => "Mail accounts",
    'rpt_dom_section_siteapps' => 'Web applications',
    'rpt_dom_section_aspnetapps' => 'ASP.NET web applications',
    'rpt_dom_section_webusers' => "Web users",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Edit report %1",
    'rpt_enter_email_address' => "Enter the email address the report will be delivered to.",
    'rpt_list' => "Custom report layouts",
    'rpt_section_full' => "Full",
    'rpt_section_none' => "None",
    'rpt_section_summary' => "Summary",
    'rpt_default_full' => 'Full Report',
    'rpt_default_summary' => 'Summary Report',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Error sending the report: %1",
    'rpt_send_report_by_email_ok__' => "The report was sent to %1",
    'sa_action' => "Action",
    'sa_action_del' => "Delete",
    'sa_action_desc' => "What to do with spam mail",
    'sa_action_save' => "Mark as spam and store in mailbox",
    'sa_admin_blacklist' => "Administrator's black list",
    'sa_admin_whitelist' => "Administrator's white list",
    'sa_db_del_confirm' => "Are you sure you want to clear the Spam Filter database?",
    'sa_eml_in_ignorelist' => "Email is in the ignore list",
    'sa_empty_email' => "Cannot add empty email pattern.",
    'sa_exists_email' => "Such an email pattern already exists.",
    'sa_disabled__mailname_not_filtering' => "Current server settings do not allow to use mail filtering for this mail account",
    'sa_disabled__filtering_is_disabled' => 'Spam filtering was switched off by the server administrator',
    'sa_disabled__hasnt_mailbox' => "Impossible to switch on spam filtering without a mailbox",
    'sa_enable_filter' => "Switch on spam filtering",
    'sa_forget' => "forget",
    'sa_from' => "From",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Pattern is invalid.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Spam filter training',
    'sa_trainer__tools_legend' => 'Tools',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Messages in your mailbox',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Subject',
    'sa_trainer__from' => 'From',
    'sa_trainer__date' => 'Date',
    'sa_trainer__info_text' => 'Messages learned: %1 as spam, %2 as non-spam, %3 total.',
    'sa_trainer__messages' => 'message(s)',
    'sa_trainer__select__all' => 'All',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Non-Spam',
    'sa_trainer__select__unknown_only' => 'Unknown',
    'sa_trainer__cannot_remove_messages' => 'Cannot remove the selected messages from the mailbox.',
    'sa_trainer__remove_messages_confirm' => 'Are you sure that you wish to remove the selected messages from the mailbox?',
    'sa_subj' => "Subject",
    'sa_training' => "Spam filter training",
    'sa_training_legend' => "Bayesian filter training",
    'sa_use_srv_settings' => "Use server-wide settings",
    'sa_user_blacklist' => "User's black list",
    'sa_user_whitelist' => "User's white list",
    'sa_usr_disabled_by_srv' => "Individual spam filtering settings are not allowed by server administrator",
    'sa_usr_no_postbox' => "Cannot enable spam filtering because mailbox is switched off for this email account.",
    'sa_filters' => 'Spam filters',
    'spamfilter__tools_legend' => 'Tools',
    'spamfilter__prefs_legend' => 'Settings',
    'spamfilter__max_children' => 'The maximum number of worker spamd processes to run',
    'spamfilter__rewrite_header_subject_hint' => 'Leave this field blank if you do not want to add any text. Type _SCORE_ if you want to include the score in the message subject.',
    'spamfilter__reject_spam' => 'Delete spam mail when it comes to mailbox',
    'spamfilter__enabled' => 'Switched on',
    'spamfilter_addresses_list__items' => 'addresses',
    'spamfilter_addresses__remove_title' => 'The following addresses will be removed from the list:',
    'spamfilter_addresses__empty_selection' => 'No addresses selected.',
    'server__admin_info' => "Administrator information",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Enter the bug description below",
    'server__power_management' => "Power management",
    'server__services' => "Services",
    'server__system' => "System",
    'server__title' => "Server Administration",
    'server_preferences__admin_skin' => "Administrator's interface skin",
    'server_preferences__default_language' => "Default language",
    'server_preferences__default_skin' => "Default skin",
    'server_preferences__restart_apache_interval' => "Apache restart interval",
    'server_preferences__system' => 'System Settings',
    'mail__tabs_preferences' => "Settings",
    'mail__tabs_white_list' => "White List",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Check the passwords for mailboxes in the dictionary",
    'sessions__agreement' => "Yes, I wish to end these sessions.",
    'sessions__select_sessions_for_remove' => "Select the sessions to be ended.",
    'sessions__tabs_cp_sessions' => 'Plesk Sessions',
    'sessions__tabs_ftp_sessions' => 'FTP Sessions',
    'sessions__ftp_sessions_login' => 'FTP account username',
    'sessions__ftp_sessions_domain' => 'Domain name',
    'sessions__ftp_sessions_path' => 'Current location',
    'sessions__ftp_sessions_file' => 'File name',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Speed, KB/S',
    'sessions__ftp_sessions_comp' => 'Progress, %',

    'site_apps__access_level' => 'Access level',
    'site_apps__access_level_commercial' => 'Commercial',
    'site_apps__access_level_free' => 'Free',
    'site_apps__action_installer' => "Web application installation",
    'site_apps__action_reconfigure' => "Web application reconfiguring",
    'site_apps__custom_button_level' => 'Would you like to create a custom button for accessing this application?',
    'site_apps__custom_button_level_false_domain_user_only' => 'No',
    'site_apps__custom_button_level_domain_user_only' => 'Yes',
    'site_apps__custom_button_level_false' => 'No',
    'site_apps__custom_button_level_domain' => 'Yes, and make it available for the current domain only',
    'site_apps__custom_button_level_client' => 'Yes, and make it available for all domains of the customer',
    'site_apps__custom_button_level_admin' => 'Yes, and make it available for all domains',
    'site_apps__description' => "Description",
    'site_apps__dir_used_by_sapp__' => "The directory \"%1\" is used by another web application",
    'site_apps__dir_used_by_unknown__' => "The directory \"%1\" already exists. Its contents will be overwritten if you proceed.",
    'site_apps__dir_invalid_name__' => "The directory name %1 is incorrect",
    'site_apps__file_name' => 'Web application filename',
    'site_apps__invalid_install_prefix' => "Invalid installation prefix",
    'site_apps__invalid_package' => "Web application is invalid",
    'site_apps__key_status' => 'Licensing',
    'site_apps__key_status_free' => 'Distributed freely. No license key required',
    'site_apps__key_status_ok' => 'The required license key is installed',
    'site_apps__key_status_problem' => 'The required license key is not installed',
    'site_apps__name' => "Name",
    'site_apps__no_domains' => 'The web application cannot be installed. There is already another web application installed in the root directory of this domain. Consider creating a subdomain for the web application.',
    'site_apps__package_info_' => "Web Application Information",
    'site_apps__package_integrated' => "built-in application, cannot be removed",
    'site_apps__pool_select_packages_to_add' => 'Select the web applications to add to the pool',
    'site_apps__release' => "Release",
    'site_apps__resource_used_by_sapp' => "This resource is used by installed web application",
    'site_apps__root_used_by_sapp' => "This resource is used by an installed web application",
    'site_apps__these_domains_will_not_delete' => 'These (sub)domains will not be deleted',
    'site_apps__upload_site_app_pkg_title' => 'Upload new web application',
    'site_apps__version' => "Version",
    'site_apps__access_to' => "Access to %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Unable to unpack the archive. Archiver is possibly not installed on the server. Contact the {$PROD_NAME} administrator to have the archiver software installed.",
    'skeleton__archive_corrupted' => "Archive check discovered that the archive file is either corrupt or this archive type is not supported.",
    'skeleton__archive_too_large' => "Archive check discovered that the archive file is too large.",
    'skeleton__not_supported_archive_type' => "This type of archive (file %1) is not supported.",
    'skin_download__title' => 'Download Skin',
    'skin_download_now__title' => 'Skin download in progress',
    'skin_download_now__text' => 'The skin package creation is in progress.<br>This procedure may take some time.<br> Once the dialog window appears, you can continue working with Plesk.',
    'skin_file__help_for_using_types' => "Please, use the skin archives in one of the following formats:",
    'skin_info__title' => 'Skin Properties',
    'skin_mng_err__rpm_not_skin' => 'This RPM is not a Plesk skin package',
    'skin_mng_err__psa_install_noreloc' => 'Failed to install rpm-based skin in the specified location.',
    'skin_mng_err__already_exists' => 'The skin installation directory already exists, and there is a skin package deployed.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'The uploaded file is not a valid RPM skin package.',
    'skin_mng_err__rpm_upgrade_noskin' => 'The uploaded file is not a valid skin package.',
    'skin_mng_err__rpm_upgrade_base' => "The uploaded file is not a valid {$PROD_NAME} skin package.",
    'skin_mng_err__rpm_upgrade_other' => 'Unable to install the skin: invalid skin format.',
    'skin_mng_err__no_a_skin' => "The uploaded file is not a valid {$PROD_NAME} skin package.",
    'skin_upload__title' => 'Upload New Skin',
    'skin_upload__already_exists' => "The skin '%1' already exists.",
    'skin_upload__unable_to_apply' => "The uploaded file does not contain a Plesk skin, or the archive format is not supported.",
    'skin_upload__unable_to_rename__' => "Unable to rename skin %2 to %1: %3.",
    'skin_upload__file_name' => 'Path to the skin package file',
    'skins_list__title' => 'Skins Repository',
    'skins_remove__title' => 'Skin Removal',
    'skins_remove__select_skins_for_remove' => 'Select the skins to be removed',

    'spf__unable_update' => 'Unable to update SPF parameters',
    'statistics__active_domains' => "Active domains",
    'statistics__clients' => "Customers",
    'statistics__subdomains' => "Subdomains",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Databases",
    'statistics__db_users' => "Database users",
    'statistics__dirs' => "Protected directories",
    'statistics__dom_active' => "Active",
    'statistics__dom_passive' => "Passive",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Domains",
    'statistics__domains_with_host' => "Domains with hosting",
    'statistics__doms' => "Domains ",
    'statistics__filesystem' => "File system",
    'statistics__general' => "General",
    'statistics__hdd_available' => "Available",
    'statistics__hdd_capacity' => "Capacity",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Hard Disk Usage",
    'statistics__hdd_used' => "Used",
    'statistics__ip' => "IP address",
    'statistics__key_number' => "Key number",
    'statistics__l1' => "Last 1 minute",
    'statistics__l15' => "Last 15 minutes",
    'statistics__l5' => "Last 5 minutes",
    'statistics__la' => "CPU usage",
    'statistics__mail_autoresponders' => "Auto-replies",
    'statistics__mail_boxes' => "Mailboxes",
    'statistics__mail_groups' => "Mail groups",
    'statistics__mail_lists' => "Mailing lists",
    'statistics__mail_redirects' => "Mail forwarders",
    'statistics__mem' => "Memory Usage",
    'statistics__mem_usage' => "Usage",
    'statistics__memory_available' => "Available",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Cached",
    'statistics__memory_free' => "Free",
    'statistics__memory_shared' => "Shared",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Used",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Problem customers",
    'statistics__problem_domains' => "Problem domains",
    'statistics__swap' => "Swap Usage",
    'statistics__swap_free' => "Free",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Usage",
    'statistics__swap_used' => "Used",
    'statistics__system_stat' => "Server Information",
    'statistics__unable_define_active_doms' => "Unable to determine the number of active domains: %1",
    'statistics__unable_define_inactive_doms' => "Unable to determine the number of inactive domains: %1",
    'statistics__failed_define_swap_usage' => 'Failed to define Swap Usage',
    'statistics__failed_define_load_averages' => 'Failed to define Load Averages',
    'statistics__up_time' => "System Uptime: ",
    'statistics__ver' => "Version",
    'statistics__web_users' => "Web users",
    'statistics__mem_win' => "Physical Memory Usage",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Used",
    'statistics__memory_free_win' => "Available",
    'statistics__swap_win' => "Virtual Memory Usage",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Used",
    'statistics__swap_free_win' => "Available",
    'status__domain_has_reasons_to_be_off' => "The domain is still suspended for the following reason: %1",
    'subdomain__create__' => "Create a subdomain in the domain %1",
    'subdomain__edit__' => "Manage subdomain %1",
    'subdomain__invalid_name' => "Invalid subdomain name: use only alphanumeric and dash symbols.",
    'subdomain__incorrect_name' => "Invalid subdomain name.",
    'subdomains__maillists_enabled_in_domain' => "Incorrect subdomain name lists.%1: this domain name is already in use by mailing lists under the domain %1.",
    'subdomains__dalias_exists' => 'A domain alias with such a name already exists.',
    'subdomains__name_exists' => "A subdomain with such a name already exists.",
    'subdomains__regular_domain_exists' => "A domain with such a name already exists.",
    'subdomains__domain_alias_exists' => 'A domain alias with such a name already exists.',
    'subdomains__remove_subdomains_on_domain' => "The following subdomains for domain %1 will be removed:",
    'subdomains__select_subdomains_for_remove' => "Select the subdomains to be removed.",
    'subdomains__webmail_enabled_in_domain' => "Incorrect subdomain name webmail.%1: this domain name is used for accessing webmail under the domain %1.",
    'subdomains__dns_record_already_exists' => 'Unable to create the subdomain %1 because there is already a DNS record pointing to host %1.',
    'subdomains__www_prefix_in_domain' => "Incorrect subdomain name www.%1: the domain %1 already has the WWW prefix.",
    'subdomains__user_type_quota_exceeds' => 'Unable to change the user account because this would result in exceeding the allotted disk space.',
    'subdomains__creation_in_dns_slave' => "The Plesk's name server is acting as a secondary name server for this domain. For your subdomain to resolve properly, make sure that the zone file on the primary DNS server contains the record %1.",
    'sys_user__attributes_not_changed' => "\nThe following system user attributes were not changed: %1",
    'sys_user__no_access_without_password' => "You did not set a password. The system user will be created, but will not be able to log in to the system, until he/she is given a password. Would you like to proceed?",
    'sys_user__no_hard_quota' => "not supported",
    'sysuser__zero_quota_is_unlimited' => "0 for unlimited",
    'template__num_excl_ips' => "Allocate dedicated IP addresses to the customer",
    'template__sel_sh_ips' => "Selected shared IP addresses",
    'template__av_sh_ips' => "Available shared IP addresses",
    'template__up_to_excl_ip' => "Up to %1 IP addresses",
    'templates__all_clients' => "all customers",
    'templates__cl_domain_templates' => "Templates for %1",
    'templates__cl_templates' => "Customer templates",
    'time__invalid_ip' => "Invalid IP address or domain name.",
    '__please_select_country' => 'Please, select your country',
    'time__unable_set_time' => "Unable to set the system time: %1",
    'time__sinchronization_setup_error' => 'Unable to set up time synchronization: timemng failed: %1',
    'time__sinchronization_disable_error' => 'Unable to disable time sinchronization: timemng failed: %1',
    'tmpl__create' => "Create template",
    'tmpl__edit__' => 'Template %1',
    'tmpl__logrotation_warn' => "Log rotation on the domain created by this template will be performed only in case of subsequent physical hosting account creation for it.",
    'tmpl__name' => "Template name",
    'tmpl__dom_exist' => "A domain template with such a name already exists in administrator's or customer's templates pool.",
    'tmpl__name_invalid' => "Template name is invalid or empty.",
    'tmpl__use_next_ip_addr' => "Next vacant IP address will be used",
    'tmpl_name_already_exists' => "Template with name '%1' already exists.",
    'traffic__no_periods_found' => "Unable to display the web and traffic statistics. This function will be available only after the next statistics calculation.",

    'vh_based__no_free_ip_for_vh' => "There are no vacant IP addresses for the IP-based virtual hosting. Please, add an IP address.",

    'wu__at_domains_text' => "Allow webuser@%1 access format",
    'wu__unable_create' => "Unable to create web user: %1",
    'wu_edit__disk_quota' => "Disk quota",
    'wu_edit__invalid_pass' => "Password is invalid.",
    'wu_edit__invalid_quota' => "The specified disk space quota value is invalid. Please, enter a positive integer.",
    'wu_edit__invalid_quota_value' => "The specified disk space quota is less than currently used (%1MB). Some functionality may become unavailiable. Are you sure you want to continue?",
    'wu_edit__not_create_pass' => "This action will not create a password for the new web user.\nWithout password the user will not be able to log in.",
    'wu_edit__unable_update' => "Unable to update the web user property: %1",

    'dns__tabs_general' => 'Zone Settings',
    'dns__tabs_zone_settings' => 'SOA Records',
    'soa__seconds' => 'seconds',
    'soa__minutes' => 'minutes',
    'soa__hours' => 'hours',
    'soa__days' => 'days',

    'DomainSubdirectory' => 'Destination Subdirectory',

    'filemanager__select_codepage' => 'Select Codepage:',

    'bt_server_app_add' => 'Add Server Application',
    'packages_list' => 'Server Applications',

    'bt_packages_management' => 'Packages Management',
    'pb__packages_management' => 'Application Management',
    'bt_package_new' => 'Add Application',
    '__packages' => 'Server Applications',

    'dom_ctrl__mysql_dbase_space' => 'Total MariaDB/MySQL databases quota',
    'dom_ctrl__mssql_dbase_space' => 'Total MS SQL databases quota',

    'dns_add__enter_ixfr_path' => 'Enter IXFR Path',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT record already exists. There can be only one SPF record. To add a record, delete the existing one before.',

    'component_name__network' => 'Networking',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Set Skin',
    'bt_set_skin' => 'Set Skin',
    'firewall__rule_already_exists' => 'Rule with name "%1" already exists',
    'firewall__rule_readonly' => 'Rule "%1" is readonly',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Antivirus protection',
    'antivirus__antivirus_direction_off' => 'Switched off',
    'antivirus__antivirus_direction_any' => 'Incoming and outgoing mail',
    'antivirus__antivirus_direction_from' => 'Outgoing mail only',
    'antivirus__antivirus_direction_to' => 'Incoming mail only',
    'antivirus__unable_to_update_settings' => 'Unable to change antivirus settings: %1',




    '__normal' => 'Normal',
    '__low' => 'Low',
    '__high' => 'High',

    'mail__antivirus' => "Internal mailservers's antivirus",
    'mail__use_internal_antivirus' => 'Use internal antivirus',

    'sa__tabs_blacklist' => 'Black List',

    '__mysql_databases' => 'MariaDB/MySQL Databases',

    'cl_perm__mysql_dbase_space' => 'Total MariaDB/MySQL databases quota',
    'cl_perm__mssql_dbase_space' => 'Total MS SQL databases quota',
    'cl_perm__max_mssql_db' => 'Maximum number of Microsoft SQL Server databases',
    'cl_perm__total_mboxes_quota' => 'Total mailboxes quota',

    'i_i_cl_on' => 'Customer account is active.',
    'i_i_cl_off_by_admin' => 'Customer account is suspended by administrator.',

    'sa_exists_tn' => 'The network is already in the list.',

    'defaultcomponents__not_activated' => 'not activated',

    'bt_traffic_at_domains' => 'Traffic',

    '__awstats_perl_warning' => 'Without Perl installed, AWStats will not allow users to check statistics for previous years.',

    'class_client__mysql_dbase_space' => 'The value exceeds the customer\'s limit.',
    'class_client__mssql_dbase_space' => 'The value exceeds the customer\'s limit.',
    'class_client__max_mssql_db' => 'The value exceeds the customer\'s limit.',

    'dns__remove_transfer_restrictions_list_items' => 'The following networks will be removed from the access control list:',

    'bt_up' => "Up",
    'bt_down' => "Down",

    'bt_install_selected' => 'Install Selected License Keys', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'The domain resolves to another IP address: (%1). Please correct DNS settings.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'The mail server currently in use does not support both mailbox and mail groups switched on simultaneously. Press OK to switch on mailbox at the expense of switching off mail groups. Press Cancel to leave everything intact.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'The mail server currently in use does not support both mailbox and mail groups switched on simultaneously. Press OK to switch on mail groups at the expense of switching off mailbox. Press Cancel to leave everything intact.',

    'mysql_dbase_space_limit' => 'MariaDB/MySQL database space limit',
    'mysql_dbase_usage' => 'MariaDB/MySQL database space usage',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server database space limit',
    'mssql_dbase_usage' => 'Microsoft SQL Server database space usage',

    '__statistics' => "statistics", //indirect

    'dns__soa_minimum_value_is_big' => 'Setting the Minimum TTL value that is more than 3 hours can make your domains inaccessible for some of the domain administrators. It is recommended to set such value only if your domain names registrar insists on it.',

    'virusfilter__interface_not_available' => 'No virus filters are available.',
    'virusfilter__none_virus_filter' => 'None',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'switched off',
    'virusfilter__status_any' => 'incoming and outgoing mail',
    'virusfilter__status_outgoing' => 'only outgoing mail',
    'virusfilter__status_incoming' => 'only incoming mail',

    'visibility__root_override_parse_error' => 'There is a syntax error in file %1 in line %2.',

    'sb__not_support_publishing_api' => "Publishing automation is not supported by the component",

    'component_name__cphosting' => "Plesk Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Setting up mail boxes quota is not supported by current mail server.',
    '__unable_get_total_mboxes_quota' => 'Setting up mail boxes quota is not supported by current mail server.',

    'install_prefix__parent_not_exists' => "Parent directory does not exist.",

    'bt_change_version' => 'Change Version',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Select All",
    '__uncheck_all' => "Clear All",

    'dns__editing_domain_controller_zone' => "Editing DNS zone records for domain controller can cause problems in domain functioning",

    'pb__interface_management' => "Interface Management",
    'interface_management__tabs_skins' => "Skins",
    'interface_management__tabs_interface_templates' => "Interface Templates",
    'interface_management__tabs_locales' => "Locales",
    'locales_list__title' => "Language packs repository",
    'locales_list__legend' => "Available languages",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Language pack",
    'locales_list__lang_title' => "Language",
    'locales_list__country_title' => "Country",
    'locales_list__used_title' => "Used",

    'backup__suspend_warning_during_backup' => "The domain will be unavailable during the backup process",
    'backup__suspend_warning_during_restore' => "The domain will be unavailable during the restoration process",
    'backup__suspend_domain' => "Suspend domain",

    'locales_list__mls_limit' => "Your current Plesk license allows using %2 languages. At the moment, you have %1 languages set as available to users, which exceeds the number provided with the license. Please select %2 languages you want to use, and make the rest unavailable to users by clicking their icons in the 'S' column.",

    'bt_change_owner' => 'Assign New Owner',
    'chown__new_owner' => 'New owner',
    'chown__selected_domains' => 'Selected subscriptions',
    'chown__limits_legend' => 'Resources',
    'chown__limit_name' => 'Resource name',
    'chown__limit_value' => 'Allocated resources',
    'chown__limit_assigned_before' => 'Before transfer',
    'chown__limit_assigned_after' => 'After transfer',
    'chown__error_limits' => "Unable to continue subscription transfer: this subscription requires more resources than can be provided by the new owner's provider.",
    'chown__error_no_domains' => 'Unable to continue subscription transfer: either no subscriptions selected, or the selected subscriptions already belong to the target user.',
    'chown__error_empty_ip_pool' => "Unable to continue subscription transfer: IP pool of the new owner's provider is empty. Please make sure that the provider has at least one IP address in the pool.",
    'chown__please_select_new_domain_owner' => 'Select the new owner for this subscription',
    'chown__old_ip_address' => 'Current IP address',
    'chown__new_ip_address' => 'New IP address',

    'chown__error_ssl_already_used' => "SSL/TLS support is already used on the following destination IPs: %1 Therefore, the following domains with SSL/TLS support could not be transferred: %2. Please resolve the problem and try again",
    'chown__sitebuilder_not_installed' => 'Presence Builder is not installed',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domain %1 cannot be transferred to another owner because Presence Builder is not installed.',

    'backup__backup_time' => 'Backup time',
    'backup__backup_time_hour' => 'hours',
    'backup__backup_time_minute' => 'minutes',
    'backup__every' => 'every',
    'backup__day_of_month' => 'day of month',

    'subdomain__select_hst_type' => 'Select the type of hosting for the subdomain',
    'hst_sel__subdom_subfolder_hst' => 'Subdomain on subfolder',
    'subdomain__www_root_folder_not_exists' => 'Site home directory %1 does not exist',
    '__site_home_dir' => 'Site home directory',
    'subdomain__aspnet_disabled_domain' => 'switched off by domain',

    'domains__remove_description' => 'All domain data, including domain and respective subdomains content and settings, web applications data, mailbox contents, mail, antivirus and spam filtering settings, log files, domain backup repository data and SSL/TLS certificates will be deleted. If you do not have a backup file on your local machine, all data will be permanently lost.',
    'subdomains__remove_description' => 'All subdomain data, including subdomain content and settings, web applications data and log files will be deleted. If you do not have a backup file on your local machine, all data will be permanently lost.',

    'mail__tabs_spam_filtering' => 'Spam Filtering',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Use default server-wide settings (Scan)',
    'antivirus__use_server_settings_no_scan' => 'Use default server-wide settings (Do not scan)',
    'antivirus__check_for_viruses' => 'Scan for viruses',
    'antivirus__dont_check_for_viruses' => 'Do not scan for viruses',
    'antivirus__incoming_mail' => 'Incoming mail',
    'antivirus__outgoing_mail' => 'Outgoing mail',

    'domain_alias__CNAME_dns_record_exists' => 'A DNS CNAME record with such a name already exists',
    'domain_alias__A_dns_record_exists' => 'A DNS A record with such a name already exists',
    'domain_alias__bad_prefix' => 'Wrong prefix for domain alias',
    'domain_alias__domain_doesnt_exist' => "Domain does not exist",

    'dns__zone_ttl_message_info' => 'If the TTL value is not specified, the TTL value in the SOA Record Template (%1) will be used for this DNS record.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "A file named index.html will be created for redirection to the selected web application. If a file named index.html already exists, it will be backed up as index.html.old and replaced by the new one. Press OK to confirm",

    'bt_ftp_ctrl' => "Additional FTP Accounts",
    'ftp_users_no_permission' => "You do not have permission to manage FTP accounts for this domain",
    'ftp_users_limit_reached' => "FTP accounts limit is reached for this domain",
    'pb__ftp_ctrl' => "FTP management",
    'class_client__max_subftp_users' => "Additional FTP accounts",

    '__client_form_settings' => "Customer settings",
    '__sbnet_client_keep_sbnet' => "Keep the corresponding user account in Presence Builder",
    '__sbnet_cant_add_more_sites' => "The limit on the amount of sites that can use Presence Builder is reached for this customer",
    '__sbnet_legend_text' => "Presence Builder integration",
    '__sbnet_synchronize_user_with_sbnet' => "Create a corresponding user account in Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "You are trying to remove the Presence Builder user account associated with this customer. This will delete all user's websites and all other relevant settings from the Presence Builder system, removing the ability to edit existing websites through Presence Builder, even if you switch this option on again later. If you create a Presence Builder user account again later, you will have to create and publish all your websites from scratch. Do you wish to switch off website creation and publishing through Presence Builder?",
    'sb__build_site_with_subdomains' => "Create Blog and Photo Gallery subdomains",
    '__sbnet_client_dont_have_sbuser' => "Cannot create and publish site using Presence Builder: Presence Builder User does not exist",

    '__component_disabled' => "Component switched off",

    'subdomains__physical_path_not_exist' => "There are subdomains linked to non-existent physical folders",

    'dnsserver_bind_to_msdns_switching_warning' => "Warning: only the first 254 IP addresses of subnets with /8 and /16 masks located in the Access Control List will be transferred. They will be transferred as separate IP addresses. Do you wish to continue?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder sites might require ASP.NET 2.0 support on your domain. We recommend to enable ASP.NET 2.0 support if you are using Presence Builder.",

    'subdomain_auto_create_dir' => "Create physical directory for subdomain",

    'sa_trainer__unable_to_get_messages_list' => "Unable to get the list of messages in the mailbox: %1",
    'sa_trainer__pass_doesnt_exist' => "The password for this mail account is missing",

    '__sitebuilder_error' => "An error occurred while trying to connect to Presence Builder. Contact your service provider for assistance.",
    'wsb_error_user_not_exist' => "This Presence Builder user account does not exist.",
    'wsb_error_site_already_exist' => "This site already exists in Presence Builder.",
    'wsb_error_site_limit_reached' => "The limit on the number of Presence Builder sites is reached.",
    'wsb_error_internal_error' => "Internal Presence Builder error occurred. Contact your service provider for assistance.",
    'wsb_error_user_already_exist' => "Presence Builder user with such a name already exists in Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder user does not exist.",
    'wsb_error_object_not_found' => "Presence Builder was unable to find the correct host entry.",

    'mg_no_mail_groups' => "No mail groups",

    'drweb__drweb_incoming' => 'Antivirus check of incoming mail',
    'drweb__drweb_outgoing' => 'Antivirus check of outgoing mail',
    'drweb__disable_reason_serv' => 'The mail server does not support antivirus filter settings on mailbox level',

    'vz_sitebuilder3_client_cant_be_created' => "Cannot create customer account: SiteBuilder version 3.1 or later is not installed",

    'chown__client_without_sitebuilder_support' => "Unable to continue subscription transfer: Presence Builder service is not included in the new owner's or their provider's service plan.",

    // new limits

    'class_client__max_odbc' => "ODBC connections",
    'cl_perm__max_odbc' => "maximum number of ODBC connections",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Domain alias name',
    'domain_alias__list_ascii_name' => 'In ASCII format',


    // Interface Customization Templates
    'interface_preferences' => 'Interface Management',
    'pb__interface_templates' => 'Interface management',
    'pb__interface_clients' => 'Customers using %1',

    // service management
    'bt_service_showall' => "Show All",
    'bt_service_hideall' => "Hide All",
    'bt_service_start' => "Start",
    'bt_service_stop' => "Stop",
    'bt_service_restart' => "Restart",
    'bt_service_disable' => "Switch Off",
    'bt_service_manual' => "Manual",
    'bt_service_auto' => "Auto",
    'service_startup_auto' => 'Automatic',
    'service_startup_manual' => 'Manual',
    'service_startup_disabled' => 'Switched Off',
    'service_action_ok' => "The operation with %1 service completed successfully",
    'service_action_failed_disabled_service' => "Could not complete the operation with %1 service because it is switched off",
    'service_action_failed_error' => "Could not complete the operation: %1",
    'service_group_action_ok' => "The operation with the following services was completed successfully: \n %1",
    'service_group_action_disabled' => "Could not complete the operation with the following services because they are switched off: \n %1",
    'service_group_action_failed' => "Unable to complete the operation with the following services: \n %1. \n To receive detailed error information, perform the operation with each service separately",

    // php 4vs5
    'bt_php' => "PHP Settings",

    'bt_insert' => "Insert",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder database error occurred. Contact your service provider for assistance.",
    'wsb_error_sitebuilder_access_denied_error' => "Unable to access the file: Presence Builder has no access rights for the required file or folder. Contact your service provider for assistance.",
    'wsb_error_sitebuilder_connection_failed' => "Unable to connect to Presence Builder because the connection was lost. Contact your service provider for assistance.",
    'wsb_error_critical_during_operation' => "Critical Presence Builder error occurred:\n%1",
    'wsb_error_license_during_operation' => "Presence Builder license error occurred:\n%1",
    'wsb_error_during_operation' => "Presence Builder error occurred:\n%1",
    'wsb_error_license_error' => "Presence Builder license limitation was encountered.",

    // Other
    '__confrim_service_stop' => "Warning! If you stop the service %1, Plesk might stop working. Are you sure you want to stop the service %1?",
    'index_redirect_help_text' => 'Now you will be automatically redirected to the required website. If your browser does not support redirection, please click %1 here %2',
    'bt_default_settings' => "Restore Defaults",
    'logfiles__remove_failed' => "Unable to delete file %1: the file is locked by another application. Please try again later",
    'subdomain__invalid_homedirectory' => "Specified subdomain home directory is invalid",
    'scheduler_item__empty_filename' => "Please specify the executable file to run",
    'subdomains__overlapped_domain_exists' => 'Subdomain is overlapped by DNS zone of domain %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdomain is overlapped by DNS zone of domain alias %1',
    'services_action_none_selected' => 'Could not complete the operation: please select the required services',
    'cl_perm__max_subftp_users' => "maximum number of additional FTP accounts",
    'login_up__access_denied_no_cp_access' => 'Access denied. You do not have the permission to access Plesk.',
    'drweb__disable_reason_admin' => "Antivirus filter settings on mailbox level are not allowed by the server policy.",

    '__use_default' => 'Use default',

    'webalizer_hidden_referrer__already_exist' => 'Such an entry already exists.',
    'webalizer_group_referrer__already_exist' => 'A group referrer with such a name already exists.',

    'pb__dashboard' => 'Home',

    'server_interface__page_title' => 'Server Interface Settings',
    'server_interface__tabs_locales' => 'Locales',
    'server_interface__tabs_skins' => 'Skins',
    'server_interface__tabs_interface_templates' => 'Interface Templates',
    'bt_server_interface' => 'Interface Preferences',
    'pb__server_interface' => 'Interface Preferences',

    'bt_wizard_next' => 'Next >>',
    'bt_wizard_prev' => '<< Back',

    '__limit_exceeded_max_dom_server' => 'You cannot host more domains on this server because the limit on number of domains allowed on the server by the license key was reached. Contact your service provider to resolve this issue.',
    '__limit_exceeded_max_subdom_server' => 'You cannot host more subdomains on this server. Please contact your service provider.',
    '__limit_exceeded_max_dom_aliases_server' => 'You cannot set up more domain aliases on this server. Please contact your service provider.',
    '__limit_exceeded_max_wu_server' => 'You cannot create more web users because the limit on number of web users allowed on the server by the license key was reached. Contact your service provider to resolve this issue.',
    '__limit_exceeded_max_mn_server' => 'You cannot create more mail accounts because the limit on number of mail accounts allowed on the server by the license key was reached. Contact your service provider to resolve this issue.',

    '__limit_exceeded_max_cl_useradmin' => 'You have reached the limit on number of customer accounts defined by your license key (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'You have reached the limit on number of domains defined by your license key (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'You have reached the limit on number of subdomains defined by your license key (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'You have reached the limit on number of domain aliases defined by your license key (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'You have no free disk space left',
    '__limit_exceeded_max_wu_useradmin' => 'You have reached the limit on number of web user accounts defined by your license key (%2)',
    '__limit_exceeded_max_db_useradmin' => 'You have reached the limit on number of databases defined by your license key (%2)',
    '__limit_exceeded_max_box_useradmin' => 'You have reached the limit on number of mailboxes defined by your license key (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'You have reached the limit on number of email accounts defined by your license key (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'You have reached the limit on number of mailing lists  defined by your license key (%2)',

    '__limit_exceeded_max_dom_userclient' => 'You have reached the limit on number of domains (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'You have reached the limit on number of subdomains (%2) allowed by your service provider',
    '__limit_exceeded_max_dom_aliases_userclient' => 'You have reached the limit on number of domain aliases (%2)',
    '__limit_exceeded_disk_space_userclient' => 'You have reached the disk space usage limit (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'You have reached the limit on amount of bandwidth usage per month (%2)',
    '__limit_exceeded_max_wu_userclient' => 'You have reached the limit on number of web users (%2) allowed by your service provider.',
    '__limit_exceeded_max_db_userclient' => 'You have reached the limit on number of databases (%2)',
    '__limit_exceeded_max_box_userclient' => 'You have reached the limit on number of mailboxes (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'You have reached the limit on number of mailing lists (%2)',
    '__limit_exceeded_expiration_userclient' => 'Your account expired on %2',

    '__limit_exceeded_max_subdom_userdomain' => 'You have reached the limit on number of subdomains (%2) allowed by your service provider',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'You have reached the limit on number of domain aliases (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'You have reached the disk space usage limit (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'You have reached the limit on amount of bandwidth used per month (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'You have reached the limit on number of web user accounts (%2)',
    '__limit_exceeded_max_db_userdomain' => 'You have reached the limit on number of databases (%2)',
    '__limit_exceeded_max_box_userdomain' => 'You have reached the limit on number of mailboxes (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'You have reached the limit on number of mailing lists (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Your account expired on %2',

    'sapp_error_validation_not_found' => 'Unable to validate web application because one of required files (%1) was not found. Contact your technical support representative for assistance.',
    'sapp_error_validation_spec_failed' => 'The uploaded web application does not conform to the AppPacks specifications: %1.',
    'sapp_error_validation_register' => 'Unable to register the web application located in the directory "%1": %2 You should remove the web application from the server because it will not function properly.',

    'sapp__install_failed' => 'Web application installation failed: %1',
    'sapp__install_res_failed' => 'Failed to create the requested resource.',

    'server_preferences__subdomains_blog_and_photo' => 'Create Blog and Photo Gallery subdomains by default',
    'plesk_key__blog_and_photo' => 'Ability to manage the default state of Create Blog and Photo Gallery subdomains check box',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Unable to change the IP address type to dedicated because it is assigned to more than one user.',

    // 8.1.1

    '__write_modify_warning' => 'Selecting additional write/modify permissions will make some web applications work correctly, but it also will significantly increase the security risks',
    '__write_modify_subdomain_warning' => 'Selecting additional write/modify permissions will make some web applications work correctly, but it also will significantly increase the security risks',

    'phosting__php_incorrect_version_used' => "PHP version problems were detected. To resolve these problems, select the check box with required PHP version below and click OK. To switch off PHP on this domain, click OK without selecting the PHP version",
    'fp__mail_preferences' => 'Mail Settings',

    'mail__invalid_white_pattern' => 'The specified value is invalid. Use the following formats: mail@example.com for email addresses, example.com for domains.',
    'mail__invalid_black_pattern' => 'The specified value is invalid. Use the following format: mail@example.com for email addresses, example.com for domains.',

    'resp_edit__reply_as_html' => 'Send as HTML',
    'exception__path_very_long' => "The path is too long. Please make sure that there are less than %1 characters in the path.",

    // 8.2


    //SAPP
    'sapp_on' => 'On',
    'sapp_off' => 'Off',
    'sapp_directive_aspect' => 'Required',
    'sapp_databases_num' => 'Databases',
    'sapp_db_required' => 'Required',
    'sapp_Required' => 'Required',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'Database id',
    'sapp_db_id_type' => 'DB (id: %1) type',
    'sapp_db_id_min_version' => 'DB (id: %1) min version',
    'sapp_db_id_table_prefix' => 'DB (id: %1) table prefix',
    'sapp_Default' => 'Default value',
    'sapp_apache_mod_req' => 'Apache module',
    'sapp_dbtype_not_installed' => 'not installed',
    'sapp_apache_mod_not_installed' => 'not installed',
    'sapp_error_invalid_type' => 'The application "%1" does not support the requested action.',
    'sapp_error_unknown_app_type' => 'Unsupported type of application: %1.',
    'sapp__ssl_text' => 'Install application to "http://" or "https://" virtual host?',
    'sapp__app_to_upgrade' => 'Applications to be upgraded',
    'sapp__upgrade_apps_title' => 'Upgrade applications',
    'sapp__upgrade_to_ver' => 'Upgrade to version',
    'sapp__choose_pkg_ver' => 'Select a package...',
    'sapp__pkg_cant_upgrade_pkg' => 'The package "%1" cannot be used for upgrading the web application "%2".',
    'sapp__app_ugrade_error' => 'Unable to upgrade the application: %1. Please contact your system administrator.',
    'sapp__no_suitable_db_found' => 'No suitable database found.',
    'sapp__upgrade_success' =>  'The application was successfully upgraded.',
    'sapp__pkg_info_changelog' => 'History of changes',
    'sapp_requirement_legend' => 'Hosting features required by the application',

    // other
    'bt_apply' => 'Apply',
    'mn_edit__add_alias_if_mailbox_disabled' => 'To create a mail alias, the mailbox should be switched on on this mail account. Switch on the mailbox?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Switching off the mailbox will remove the mail aliases since they will stop working. Switch off the mailbox?',
    'antivirus__disable_reason_install' => 'You cannot manage antivirus because it is not installed.',
    'antivirus__disable_reason_key' => 'You cannot manage antivirus because it is not activated by a proper license key.',
    'antivirus__disable_reason_deny_personal_settings' => 'You cannot manage antivirus because server policy forbids individual antivirus settings.',
    'change_foreign_user_password' => 'Change password',
    'change_foreign_user_password_hint' => "The user does not belong to this application. Click the link to go to another application and change the user's password there. To do this, you must have the appropriate rights in the application.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'String Format',
    'lang_unknown' => 'Unknown language',
    'pb__cl_ed' => 'Customer details',
    'pb__actionlog' => 'Action log',
    'pb__cl_limits' => 'Customer limits',
    'pb__edit' => 'Edit',
    'pb__subdom_edit' => 'Hosting settings',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Backup the content of mailboxes',

    'maillist_import_result' => "\nTotal amount of email addresses in file: %1\namount of imported email addresses: %2\namount of already existing email addresses: %3\namount of duplicated email addresses in specified file: %4\namount of invalid email addresses in file: %5",
    'maillist_import_error' => 'Unable to import email addresses list',

    //  spaw

    'spaw__unable_to_edit_no_body' => "The file you selected is either empty or not a valid HTML document in the selected encoding. Please select the correct encoding or simply add content to the file.",

    'dom_pref__external_mail_srv' => "Redirect to an external mail server with the IP address:",
    'mn_edit__store_messages' => 'Mailbox',

    // aps

    'sapp__before_upgrade_notice' => 'It is recommended to back up the application and user data before starting the upgrade process.',
    'sapp__application_properties' => 'Application properties',
    'sapp__application_root_descr' => 'The main page of the application',

    'sapp__aps_license_invalid_id' => 'License key has invalid ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'License with the key number %1 already exists in the database.',
    'sapp__aps_lic_del_used' => 'Unable to delete the license key, it is being used by one of installed applications.',
    'sapp__aps_lic_del_unknown' => 'Unable to delete the license key: %1',
    'sapp__aps_cappi_duplicate' => "This application is already in this customer's application pool",
    'sapp__appi_not_shared_no_install' => "There is no such an application in the customer's application pool. If you want to install this application on a site, you should first add this application to the customer's application pool.",
    'sapp__appi_shared_not_client' => "There is no such an application in the customer's application pool. If you want to upgrade the application to the specified version, you should first add this application version to the customer's application pool .",
    'sapp__apply_license_script_not_found' => 'Unable to find the "apply-license" script for this web application.',
    'sapp__unable_to_activate_key' => 'An error occurred during an attempt to activate a license key: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'There are installed web applications that require the presence of this web application in the system.',
    'sapp__unable_to_delete_ai_in_pool' => 'This application is still in a customer\'s pool. If you want to remove this application, you first need to remove it from all customers\' application pools or make it free of charge.',
    'sapp__unable_to_delete_app_template' => 'Unable to remove the application #%1: %2',
    'sapp__limit_exceeded_client' => 'You have reached the limit on number of times you can install this web application (%2).',


    // atis module

    '_week_on' => 'week on',
    '__week_first' => 'first',
    '__week_second' => 'second',
    '__week_third' => 'third',
    '__week_fourth' => 'fourth',
    '__week_last' => 'last',
    '__not_started' => 'Waiting',
    '__started' => 'Running',
    '__cancel_pending' => 'Cancelling',
    '__canceled' => 'Cancelled',
    '__error' => 'Error',
    '__done' => 'Done',

    '__php_cgi_handler' => 'CGI application',
    '__php_isapi_handler' => 'ISAPI extension',
    '__php_fastcgi_handler' => 'FastCGI application',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'run as',

    'cf_dbfolder_text' => 'Database Folder',
    'cf_isnewdb_text' => 'Create Database',
    'cf_isnewdb_title' => 'Select the check box if the database has to be created',

    'pb__site_apps_upgrade' => 'Web application upgrade',

    'detach' => 'Disconnect',
    'preferences' => "Change Password",

    'toolsbar__switch_user?' => "Are you sure you want to log in under another user account?",
    '__aps_left' => 'Installations left',
    'aps__license_key' => 'License key',
    'aps__download_code' => 'License key download and activation code',
    'aps__license_key_hint' => 'Retrieve from the licensing server using the activation code',
    'aps__database_not_available' => 'not available, please check domain or customer limits',
    'aps__yes' => 'yes',
    'aps__no' => 'no',
    '__click_to_enlarge' => 'Click to enlarge',
    'site_apps__back_to_list' => 'Return to list',
    'sapp__pkg_info_installation_requirements' => 'Installation requirements',
    '__close_window' => 'Close',

    //SAPP END

    'skin_info__already_default' => 'The skin is already set as the default one.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus Settings for %1',
    'drweb:properties_legend' => 'Settings',
    'drweb:status' => 'Checking mail for viruses',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder Wizard',
    'dom_site_builder' => 'Click to open Presence Builder Wizard.',
    'sb_plesk_admin_url' => 'Presence Builder server URL. Ensure that this address resolves properly in DNS',
    'sb_plesk_admin_login' => 'Username for server administrator\'s login to Presence Builder',
    'sb_plesk_admin_password' => 'Administrator\'s password',
    'sb_sitebuilder_preferences' => 'Presence Builder administrator\'s credentials',
    'sb__server' => 'Presence Builder System Administrator\'s preferences',
    'sb__sitebuilder_support' => 'Presence Builder support',
    'sb_keep_sb_user' => 'Keep the corresponding user account in Presence Builder',
    'sb_create_sb_user' => 'Create a corresponding user account in Presence Builder',
    'sb__build_site_using_sitebuilder' => "Create a website using Presence Builder",
    'sb_no_current_sb_server_set' => 'The connection to Presence Builder is not configured yet: you need to add an A record in the DNS zone template that will point to the Presence Builder server.',
    'sb_unable_update_sb_server_sb_return_message' => "Unable to retrieve the information from the Presence Builder system:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Unable to connect to Presence Builder: wrong username or password.",
    'sb_init_sb_manager' => "Initializing Presence Builder manager: %1",
    'sb_err_couldnt_connect_sb' => "Failed to connect to the Presence Builder system.",
    'sb_err_client_dont_have_sbuser' => "This customer does not have a user account in Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder is not configured.",
    'sb_err_you_dont_have_sbaccount' => "Failed to authorize you in Presence Builder.",
    'sb_error_critical_during_operation' => "The following error occurred in Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Single sign-on support is not switched on in Plesk.",

    'warning__super_zone_exist' => "The zone %1 was created, however, this zone name is a subzone of another already existing zone %2, which belongs to another user %3. It is possible, but please make sure that you have chosen the correct user account.",
    'error__super_zone_exist' => "Unable to create the DNS zone because its superzone belongs to another user.",

    'locales__files_not_exits' => 'Unable to change locale: the specified interface language pack files do not exist in the system.',
    'locales__unavailable' => 'Unable to change locale: the specified interface language pack is unavailable.',

    // DB BU

    'pb__dbbackup_list' => 'Database backup files',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Temporary network directory',
    'dbbackup__network_user' => 'Username',
    'dbbackup__network_pass' => 'Password',
    // domain
    'dbbackup__add_database_legend' => 'Restore backed up database',
    'dbbackup__add_database_restore' => 'Restore database from backup file',
    'dbbackup__add_database_file' => 'Database backup file',
    'dbbackup__add_database_user' => 'Default username',
    'dbbackup__add_database_pass' => 'Default user password',
    'dbbackup__add_database_pass2' => 'Default user password confirmation',

    'bt_dbbackup_now' => 'Back Up',

    'bt_repair' => 'Repair',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Uploading of SQL Server database dumps is prohibited by the hosting provider.',

    // APS categories

    'cf_invalid_password' => 'Password cannot be longer than 16 characters',
    'cf_invalid_description_length' => 'Description cannot be longer than 256 symbols',
    'ip_addr__ip_used_by_external_mail_server' => 'IP address %1 is already used by external mail server',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP account username or password is invalid. Please specify correct FTP user credentials.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'The limit on serial number changes was reached. No more DNS zone changes can be carried out today.',
    'dns__zone_apply_changes' => 'Changes made to DNS records are not saved yet. The changes made are highlighted below. Click Update to apply the changes to DNS zone or click Revert to abandon the changes.',
    'dns__update_dns_zone' => 'Click to save the changes made to DNS records',
    'dns__revert_dns_zone' => 'Click to cancel the changes made to DNS records',
    'bt_revert' => 'Revert',
    'dns__dns_zone_has_beed_updated' => 'Changes made to DNS records were saved.',
    'dns__dns_zone_has_beed_reverted' => 'Changes made to DNS records were cancelled',
    'db__nondefault_server_not_allowed' => 'Usage of non-default database server is not allowed',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Customer %1\'s account and domains.',
    'ui__client__disabled-warning' => 'The account of customer %1 is suspended.',
    'ui__client__none-available' => 'There are no customer accounts configured.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Customer %1',
    'ui__client_self__description' => 'List of my domains.',
    'ui__client_self__short-title' => 'My domains',
    'ui__client_self__title' => 'My domains',


    'site_apps__non_removable' => 'Items that cannot be removed',
    'site_apps__non_removable_items' => 'The following web applications cannot be removed:',

    'ui__client/custom-buttons/custom-button__none-available' => 'There are no custom buttons.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'There are no custom buttons in customer %1\'s Customer Panel.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Remove the button %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Remove',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Remove the button %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Remove custom buttons from customer\'s Customer Panel',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Remove',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Remove custom buttons',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Remove buttons',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Select a customer whose custom buttons you want to remove and click Next >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Select the buttons you want to remove and click Next >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirm removing the buttons by selecting the check box on this screen, and then click Finish.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Remove a custom button from customer\'s Customer Panel.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Remove',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Remove a custom button',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remove custom button',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Select a customer whose custom button you want to remove and click Next >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Select a custom button you want to remove and click Next >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirm removing the custom button by selecting the check box on this screen, and then click Finish.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Edit properties of customer-level button %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Settings',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modify customer\'s custom button %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Add custom button',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Select a customer in whose Customer Panel you want to create a custom button and click Next >>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Click Finish to create the button.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Change properties of a button in customer\'s Customer Panel.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Properties',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Change properties of a button in customer\'s Customer Panel',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Change custom button properties',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Select a customer whose custom button you want to modify and click Next >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Select a custom button you want to modify and click Next >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'When done with editing the properties of the button, click Finish to apply changes and exit the wizard.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Make the button %1 unavailable to your customers.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Make unavailable to your customers',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Make the button %1 unavailable to your customers',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Make the button %1 visible to customer\'s users.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Make available to your customers',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Make the button %1 visible to customer\'s users',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Make a custom button available/unavailable to your customers.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Available/unavailable to your customers',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Make a custom button available or unavailable to your customers',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Make a custom button available/unavailable to your customers.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Select a customer whose custom button you want to make available to the customer\'s users and click Next >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Select a custom button that you want to make available or unavailable to your customers and click Next >>.',

    'ui__client/domain__description' => 'Manage domain %1.',
    'ui__client/domain__disabled-warning' => 'Domain %1 is suspended.',
    'ui__client/domain__none-available' => 'You do not have any domains.',
    'ui__client/domain__none-available__1' => 'The account of %1 does not have any domains.',
    'ui__client/domain__none-available__2' => 'The account of %1 does not have any domains.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domain %1',
    'ui__client/domain_self__description' => 'Manage your domain.',
    'ui__client/domain_self__disabled-warning' => 'Your domain is suspended.',
    'ui__client/domain_self__quick-search' => 'My domains',
    'ui__client/domain_self__short-title' => 'My domain',
    'ui__client/domain_self__title' => 'My domain',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'There are no custom buttons placed in the customer\'s Customer Panel.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Customer %1 has no custom buttons in the Customer Panel.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'There are no custom buttons for domain %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Remove the custom button %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Remove',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Remove the custom button %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Remove custom buttons.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Remove',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Remove custom buttons',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Remove custom buttons',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Select the customer from whose domain administration panel you want to remove the buttons and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Select the domain from whose administration panel you want to remove the buttons and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Select the buttons you want to remove and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Confirm removing the buttons by selecting the respective check boxes and click Finish to remove the buttons and exit the wizard.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Remove a custom button.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Remove',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Remove a custom button',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remove a custom button',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Select the customer from whose domain administration panel you want to remove the custom button and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Select the domain from whose administration panel you want to remove the button and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Select the custom button you want to remove and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Confirm removing the custom button by selecting the check box and click Finish to remove the button and exit the wizard.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Change the properties of the custom button %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Properties",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Change the properties of the custom button %1 in Customer Panel.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Add a button',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Select the customer in whose Customer Panel you want to place the button and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Select the subscription where you want to modify the button and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Click Finish to create the button and exit the wizard.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Change the properties of a button in Customer Panel.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Properties',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Change the properties of a button in Customer Panel',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Change button properties',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Select the custom button which settings you want to modify and click Next >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'When done with changing the properties of the button, click Finish to apply the changes and exit the wizard.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Make the button %1 unavailable to the mail users under this domain.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Unavailable to mail users',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Make the button %1 unavailable to the mail users under this domain',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Make the button %1 visible to mail users under the domain.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Accessible to mail users under this domain',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Make the custom button %1 visible to mail users under this domain',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Make a custom button available or unavailable to other users.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Available/unavailable to other users',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Make a custom button available or unavailable to mail users',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Make a custom button available or unavailable to other users',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Select a domain where the button is placed and click Next >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Select a button that you want to make available or unavailable to other users and click Next >>.',

    'ui__client/domain/delete__description' => 'Remove the domain %1.',
    'ui__client/domain/delete__short-title' => 'Remove',
    'ui__client/domain/delete__title' => 'Remove the domain %1',
    'ui__client/domain/delete_multi__description' => 'Remove domains.',

    'ui__client/domain/delete_multi__short-title' => 'Remove',
    'ui__client/domain/delete_multi__title' => 'Remove domains',
    'ui__client/domain/delete_multi__wizard-title' => 'Remove domains',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Select domains you want to remove and click Next >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Confirm removing the domains by selecting the check box, and then click Finish to remove them and exit the wizard.',
    'ui__client/domain/delete_unknown__description' => 'Remove a domain.',
    'ui__client/domain/delete_unknown__short-title' => 'Remove',
    'ui__client/domain/delete_unknown__title' => 'Remove domain',
    'ui__client/domain/delete_unknown__wizard-title' => 'Remove a domain',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Select a domain you want to remove and click Next >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Confirm removing the domain by selecting the check box, and then click Finish to remove it and exit the wizard.',

    'ui__client/domain/hosting__none-available' => 'There are no domains with configured web hosting. Create a domain and configure web hosting on it to access this functionality.',
    'ui__client/domain/hosting__none-available__1' => 'This user account does not have any domains with configured web hosting. Configure web hosting on the required domain to access this functionality.',
    'ui__client/domain/hosting__none-available__2' => 'Web hosting is not configured for domain %1. Configure web hosting on domain %1 to access this functionality.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Customers",
    'ui__client/domain/hosting/application#list_header__description__title' => "Description",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Items",
    'ui__client/domain/hosting/application#list_header__name__title' => "Name",
    'ui__client/domain/hosting/application#list_header__release__title' => "Release",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sort by customers",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sort by description",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sort by items",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sort by name",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sort by release",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sort by versions",
    'ui__client/domain/hosting/application#list_header__title' => "Web applications",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versions",

    'rpt_reseller_section_general' => 'General',
    'rpt_reseller_section_domains' => 'Domains',
    'rpt_reseller_section_clients' => 'Customers',
    'statistics__cl_active_domains' => "Active domains",
    'rpt_reseller_cl_domains' => "Domains",
    'rpt_reseller_cl_subdomains' => "Subdomains",
    'by__cl_domains' => "clients' domains",
    'dom_ctrl__cl_mboxes' => "Mailboxes",
    'rpt_reseller_cl_redirects' => "Forwarders",
    'rpt_reseller_cl_mail_groups' => "Mail groups",
    'rpt_reseller_cl_mail_resps' => "Auto-replies",
    'rpt_reseller_cl_mail_lists' => "Mailing lists",
    'rpt_reseller_cl_web_users' => "Web users",
    'rpt_reseller_cl_data_bases' => "Databases",

    'statistics__active_clients' => 'Customers with active subscriptions',
    'statistics__clients_active_domains' => 'Active domains',
    'statistics__clients_doms' => 'Domains',
    'statistics__cl_doms' => 'Domains',
    '__clients_subdomains' => 'Subdomains',
    '__clients_domains' => 'Domains',
    'dom_ctrl__clients_mboxes' => 'Mailboxes',
    'dom_ctrl__clients_redir' => 'Forwarders',
    'dom_ctrl__clients_mg' => 'Mail groups',
    'dom_ctrl__clients_resp' => 'Auto-replies',
    'dom_ctrl__clients_maillists' => 'Mailing lists',
    'dom_ctrl__clients_wu' => 'Web users',
    'dom_ctrl__clients_db' => 'Databases',

    'dom_ctrl__cl_redir' => 'Forwarders', // to resolve!
    'dom_ctrl__cl_mg' => 'Mail groups', // to resolve!
    'dom_ctrl__cl_resp' => 'Auto-replies', // to resolve!
    'dom_ctrl__cl_maillists' => 'Mailing lists', // to resolve!
    'dom_ctrl__cl_wu' => 'Web users', // to resolve!
    'dom_ctrl__cl_db' => 'Databases', // to resolve!

    'rpt_cl_section_clients' => 'Customers',

    'rpt_admin_section_general' => 'General',
    'rpt_admin_section_resellers' => 'Resellers',
    'rpt_admin_section_clients' => 'Customers',
    'rpt_admin_section_personal_clients' => 'Own customers',
    'rpt_admin_section_domains' => 'Domains',
    'rpt_admin_section_personal_domains' => 'Personal domains',

    'rpt_reseller_section_personal_domains' => 'Personal domains',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Select the domain you want to suspend or activate.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspend or activate a domain',

    'ui__client/ip-pool__description' => 'Assign and deassign IP addresses and SSL/TLS certificates to customer %1.',
    'ui__client/ip-pool__short-title' => 'IP pool',
    'ui__client/ip-pool__title' => 'Customer %1\'s IP pool',
    'ui__client/ip-pool_self__description' => 'View your IP pool.',
    'ui__client/ip-pool_self__short-title' => 'IP pool',
    'ui__client/ip-pool_self__title' => 'My IP pool',
    'ui__client/ip-pool/properties__description' => 'Set up IP pool for customer %1.',

    'ui__client/ip-pool/properties__short-title' => 'IP pool',
    'ui__client/ip-pool/properties__title' => 'Set up IP pool for customer %1',
    'ui__client/ip-pool/properties_self__description' => 'View your IP pool.',

    'ui__client/ip-pool/properties_self__short-title' => 'My IP pool',
    'ui__client/ip-pool/properties_self__title' => 'My IP pool',
    'ui__client/ip-pool/properties_unknown__description' => 'Assign to or deassign IP addresses and SSL/TLS certificates from the customer.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP pool',
    'ui__client/ip-pool/properties_unknown__title' => 'Set up customer\'s IP pool',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Set up customer\'s IP pool',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Select the customer whose IP pool you want to configure.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'When done with configuring the IP pool, click Finish to apply the changes and exit the wizard.',


    'ui__client/limits_readonly-unknown__description' => 'View resource limits for a customer.',
    'ui__client/limits_readonly-unknown__short-title' => 'Resource limits',
    'ui__client/limits_readonly-unknown__title' => 'View resource limits for a customer account',
    'ui__client/limits_readonly-unknown__wizard-title' => 'View or change resource limits for a customer',

    'ui__client/limits_unknown__wizard-title' => 'View or change resource limits for a customer',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Select the customer you need.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Select the customer you need.',
    'ui__client/limits_unknown__wizard__2' => 'To apply the changes, click Finish.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'To exit the wizard, click Finish.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'To exit the wizard, click Finish.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'To exit the wizard, click Finish.',

    'ui__client/permissions_unknown__wizard-title' => 'View or change permissions for a customer',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Select the customer whose permissions you want to view or change.',
    'ui__client/permissions_unknown__wizard__2' => 'When done with changing the customer\'s permissions, click Finish to apply the changes and exit the wizard.',

    'ui__client/preferences_unknown__wizard-title' => 'Edit customer\'s preferences',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Select the customer whose session and interface preferences you want to manage.',
    'ui__client/preferences_unknown__wizard__2' => 'When done with changing the customer\'s preferences, click Finish.',
    'ui__client/preferences_unknown__wizard__2_self' => 'When done with changing your preferences, click Finish.',

    'ui__custom-buttons/custom-button__none-available' => 'You have no custom buttons.',
    'ui__custom-buttons/custom-button/delete__description' => 'Remove the custom button %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Remove',
    'ui__custom-buttons/custom-button/delete__title' => 'Remove the custom button %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Remove the custom buttons.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Remove',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Remove custom buttons',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Remove custom buttons',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Select the buttons you want to remove.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Confirm removing the buttons by selecting the check box and click Finish to complete the wizard.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Remove custom buttons.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Remove',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Remove custom buttons',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remove custom buttons',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Select the custom button you want to remove.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Confirm the removal of the button by selecting the check box and click Finish to complete the wizard.',
    'ui__custom-buttons/custom-button/properties__description' => 'Change the properties of the button %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Properties',
    'ui__custom-buttons/custom-button/properties__title' => 'Change the properties of the button %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Create a button',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Click Finish to create the button.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Change the properties of a custom button.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Properties',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Change the properties of a custom button',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Change the properties of a custom button',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Select the custom button whose properties you want to change.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'To apply the changes, click Finish.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Make the custom button %1 unavailable to other users.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Unavailable to other users',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Make the custom button %1 unavailable to other users',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Make the custom button %1 available to other users.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Available to other users',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Make the custom button %1 available to other users',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Make the custom button available or unavailable to other users.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Available or unavailable to other users',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Make the custom button available or unavailable to other users',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Make the custom button available or unavailable to other users',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Select the custom button that you want to make available or unavailable to other users and click Next >>.',

    'ui__longtasks#list_header__name__title' => "Name",
    'ui__longtasks#list_header__owner__title' => "Owner",
    'ui__longtasks#list_header__start_time__title' => "Creation time",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Tasks",
    'ui__longtasks#list_header__finish_time__title' => "Completion time",
    'ui__longtasks#task_list_legend__title' => "Tasks",
    'ui__longtasks#tools_legend__title' => "Tools",
    'ui__longtasks__description' => "Manage background tasks",
    'ui__longtasks__short-title' => "Background Tasks",
    'ui__longtasks__title' => "Background Tasks",
    'ui__longtasks/longtask/properties#current_operation__title' => "Current operation:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Estimated completion time:",
    'ui__longtasks/longtask/properties#general_legend__title' => "General",
    'ui__longtasks/longtask/properties#owner__title' => "Task started by:",
    'ui__longtasks/longtask/properties#progress__title' => "Overall progress:",
    'ui__longtasks/longtask/properties#start_time__title' => "Task started:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Task Status",
    'ui__longtasks/longtask/properties__description' => "Background task status and information",

    'ui__longtasks/properties__description' => "Settings of background tasks",
    'ui__longtasks/properties__short-title' => "Settings",
    'ui__longtasks/properties__title' => "Background tasks",

    'ui__news/dismiss__description' => 'Click to close the news frame. Plesk will not show this frame until news articles are updated.',

    'ui__news/dismiss__title' => 'Close the news',

    'ui__server__description' => 'Server management.',
    'ui__server__short-title' => 'Manage your server',
    'ui__server__title' => 'Server management',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'The IP address %1 is unavailable.',
    'ui__server/ip-address__none-available' => 'There are no IP addresses.',
    'ui__server/ip-addresses/ip-address__title' => "IP addresses",
    'ui__server/ip-address/client/properties_new__description' => "Assign IP address %1 to resellers.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Assign',
    'ui__server/ip-address/client/properties_new__title' => "Assign IP address %1 to resellers",
    'ui__server/ip-address/client__none-available' => 'There are no user accounts',
    'ui__server/ip-address/client_unknown__quick_search' => 'Users',
    'ui__server/ip-address/client_unknown__wizard-title' => 'List of users who use this IP address.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Please select the IP address.',
    'ui__server/ip-address/client/delete__description' => 'Deassign IP address from the reseller.',
    'ui__server/ip-address/client/delete__short-title' => 'Deassign',
    'ui__server/ip-address/client/delete__title' => 'Deassign IP address from the reseller',
    'ui__server/ip-address/client/delete_multi__description' => "Deassign the IP address from resellers' pools.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Deassign',
    'ui__server/ip-address/client/delete_multi__title' => 'Deassign an IP address from a reseller',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Remove IP address from users' pools.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Select the IP address you want to deassign from users and click Next >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Select the users from whom you want to deassign the IP address and click Next >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Confirm the deassignment of the IP address from the users by selecting the check box and click Finish to complete the wizard.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Deassign an IP address from resellers.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Deassign',
    'ui__server/ip-address/client/delete_unknown__title' => 'Deassign IP address from resellers',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Deassign an IP address from users',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Select the IP address you want to deassign from users and click Next >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Select the user from whom you want to deassign the IP address and click Next >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Confirm the deassignment of the IP address from the users by selecting the check box and click Finish to complete the wizard.',

    'ui__server/ip-address/domain__description' => "All domains on the IP address %1.",
    'ui__server/ip-address/domain__short-title' => "Domains",
    'ui__server/ip-address/domain__title' => "Domains on the IP address %1",
    'ui__server/ip-address/domain_unknown__description' => "All domains on IP address.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domains",
    'ui__server/ip-address/domain_unknown__title' => "Domains on IP address",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Select the IP address you need and click Next >>.",

    'ui__server/ip-address/properties__description' => 'Change the properties of the IP address %1.',
    'ui__server/ip-address/properties__short-title' => 'Properties',
    'ui__server/ip-address/properties__title' => 'Change the properties of the IP address %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Add IP address',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'When done with changing the IP address properties, click Finish to apply the changes.',
    'ui__server/ip-address/properties_unknown__description' => 'Change the properties of the IP address.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Properties',
    'ui__server/ip-address/properties_unknown__title' => 'Change the properties of the IP address',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Change the properties of the IP address',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Select the IP address whose properties you want to change.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'When done with changing the IP address properties, click Finish to apply the changes.',

    'ui__server/spam-filter/black-list__description' => 'Set up black list for server-wide spam filter.',
    'ui__server/spam-filter/black-list__short-title' => 'Black list',
    'ui__server/spam-filter/black-list__title' => 'Black list for server-wide spam filter',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Only %1 first unique email addresses will be added.',
    'ui__server/spam-filter/black-list/address__description' => 'Spam filter\'s black list address.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'There are no email addresses in the list.',
    'ui__server/spam-filter/black-list/address__file_size' => 'The uploaded file is empty.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'The following email addresses are invalid: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'There are no addresses in the spam filter\'s black list.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Address',
    'ui__server/spam-filter/black-list/address__title' => 'Black list address %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Add addresses to the black list.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Add addresses',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Add addresses to the black list',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Remove %1 address from server-wide black list.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Remove',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Remove %1 address from server-wide black list',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Remove addresses from server-wide black list.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Remove',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Remove addresses from server-wide black list',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Removal of addresses from server-wide spam filter black list',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Select the spam filter addresses you want to remove and click Next >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Confirm removing the spam filter addresses by selecting the check box and click Finish to completely remove them and exit the wizard.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Remove address from server-wide black list.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Remove',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Remove address from server-wide black list',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Removal of addresses from server-wide spam filter black list',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Select the spam filter address you want to remove and click Next >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Confirm removing the spam filter address by selecting the check box and click Finish to completely remove it and exit the wizard.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Only %1 first unique email addresses will be added.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'There are no email addresses in the list.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Unable to upload the file. The maximum size of a file to upload is %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'The following email addresses are invalid: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Add addresses to the black list.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Add addresses',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Add addresses to the black list',

    'ui__server/spam-filter/properties__description' => 'Set up server-wide spam filter.',

    'ui__server/spam-filter/properties__short-title' => 'Settings',
    'ui__server/spam-filter/properties__title' => 'Spam filter settings',

    'ui__server/spam-filter/toggle_disable__description' => 'Disable spam filtering for the entire system.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Disable',
    'ui__server/spam-filter/toggle_disable__title' => 'Disable spam filtering',
    'ui__server/spam-filter/toggle_enable__description' => 'Enable spam filtering for the entire server.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Enable',
    'ui__server/spam-filter/toggle_enable__title' => 'Enable spam filtering',
    'ui__server/spam-filter/toggle_unknown__description' => 'Enable or disable spam filtering for the entire server.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Enable or disable',
    'ui__server/spam-filter/toggle_unknown__title' => 'Enable or disable spam filtering',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Enable or disable spam filter',

    'ui__server/spam-filter/white-list__description' => 'Set up system-wide spam filter\'s white list.',
    'ui__server/spam-filter/white-list__short-title' => 'White list',
    'ui__server/spam-filter/white-list__title' => 'System-wide spam filter\'s white list',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Only %1 first unique email addresses will be added.',
    'ui__server/spam-filter/white-list/address__description' => 'Spam filter\'s white list address.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'There are no email addresses in the list.',
    'ui__server/spam-filter/white-list/address__file_size' => 'The uploaded file is empty.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'The following email addresses are invalid: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'There are no addresses in the spam filter\'s server-wide white list.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Address',
    'ui__server/spam-filter/white-list/address__title' => 'White list address %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Add addresses to the white list.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Add addresses',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Add addresses to the white list',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Remove %1 address from server-wide white list.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Remove',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Remove %1 address from server-wide white list',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Remove addresses from server-wide white list.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Remove',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Remove addresses from server-wide white list',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Removal of addresses from server-wide spam filter white  list',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Select the spam filter addresses you want to remove and click Next >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Confirm removing the spam filter addresses by selecting the check box and click Finish to completely remove them and exit the wizard.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Remove address from server-wide white list.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Remove',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Remove address from server-wide white list',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Removal of addresses from server-wide spam filter white  list',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Select the spam filter address you want to remove and click Next >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Confirm removing the spam filter address by selecting the check box and click Finish to completely remove it and exit the wizard.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Only %1 first unique email addresses will be added.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'There are no email addresses in the list.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Unable to upload the file. The maximum size of a file to upload is %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'The following email addresses are invalid: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Add addresses to the white list.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Add addresses',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Add addresses to the white list',

    'ui__server/mail/statistics#apply__description' => "Apply filter",
    'ui__server/mail/statistics#apply__title' => "Apply",
    'ui__server/mail/statistics#custom_from__title' => "from",
    'ui__server/mail/statistics#custom_to__title' => "to",
    'ui__server/mail/statistics#period_all__title' => "All",
    'ui__server/mail/statistics#period_custom__title' => "Custom",
    'ui__server/mail/statistics#period_month__title' => "Current month",
    'ui__server/mail/statistics#period_prev_month__title' => "Previous month",
    'ui__server/mail/statistics#period_prev_week__title' => "Previous week",
    'ui__server/mail/statistics#period_today__title' => "Today",
    'ui__server/mail/statistics#period_week__title' => "Current week",
    'ui__server/mail/statistics#period_yesterday__title' => "Yesterday",
    'ui__server/mail/statistics#show_for_period__title' => "Show for period",
    'ui__server/mail/statistics#tools_legend__title' => "Tools",
    'ui__server/mail/statistics__description' => "View spam and virus statistics",

    'ui__server/mail/statistics__short-title' => "Statistics",
    'ui__server/mail/statistics__title' => "Statistics",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Spam statistics",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Tools",
    'ui__server/mail/statistics/spam__description' => "View spam statistics",

    'ui__server/mail/statistics/spam__short-title' => "Spam statistics",
    'ui__server/mail/statistics/spam__title' => "Spam statistics",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Mailname",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% of all",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sort by mail account",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sort by % of all",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sort by spam recived",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "mail accounts",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Spam recived",
    'ui__server/mail/statistics/spam/recipients__description' => "Recipients",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Recipients",
    'ui__server/mail/statistics/spam/recipients__title' => "Recipients",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Clean",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infected",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% of all",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Count",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Protected",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Not checked",
    'ui__server/mail/statistics/spam/summary__description' => "Summary",

    'ui__server/mail/statistics/spam/summary__short-title' => "Summary",
    'ui__server/mail/statistics/spam/summary__title' => "Summary",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virus statistics",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Tools",
    'ui__server/mail/statistics/virus__description' => "View virus statistics",

    'ui__server/mail/statistics/virus__short-title' => "Virus statistics",
    'ui__server/mail/statistics/virus__title' => "Virus statistics",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Mail account",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% of all",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sort by mailname",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sort by % of all",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sort by viruses recived",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Mail accounts",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Viruses recived",
    'ui__server/mail/statistics/virus/recipients__description' => "Recipients",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Recipients",
    'ui__server/mail/statistics/virus/recipients__title' => "Recipients",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Clean",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infected",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% of all",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Count",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Protected",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Not checked",
    'ui__server/mail/statistics/virus/summary__description' => "Summary",

    'ui__server/mail/statistics/virus/summary__short-title' => "Summary",
    'ui__server/mail/statistics/virus/summary__title' => "Summary",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Name",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% of all",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sort by name",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sort by % of all",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sort by infected objects",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Viruses",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Infected objects",
    'ui__server/mail/statistics/virus/viruses__description' => "Viruses",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Viruses",
    'ui__server/mail/statistics/virus/viruses__title' => "Viruses",

    'ui__support#param_company__title' => "Company",
    'ui__support#param_email__title' => "Email",
    'ui__support#param_firstname__title' => "First name",
    'ui__support#param_keynumber__title' => "Product key number",
    'ui__support#param_operatingsystem__title' => "Operating system",
    'ui__support#param_phone__title' => "Phone",
    'ui__support#param_psabuild__title' => "Plesk build",
    'ui__support#param_psainsttype__title' => "Plesk installation type",
    'ui__support#param_psaversion__title' => "Plesk version",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Tools",

    'ui__reseller/traffic-history_unknown__short-title' => "View Traffic by Resellers",
    'ui__reseller/traffic-history_unknown__title' => "View Traffic by Resellers",
    'ui__reseller/traffic-history_unknown__description' => "View traffic by reseller accounts.",
    'ui__reseller#list__title' => "Resellers",
    'accounts_list__name__filter_title' => "Name",
    'accounts_list__resource__filter_title' => "Resource usage",
    'resellers_list__filter_resource_usage_any' => "Any",
    'resellers_list__filter_resource_usage_overuse' => "Overuse",
    'resellers_list__filter_resource_usage_normal' => "Within limits",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Any",
    'resellers_list__filter_status_blocked' => "Suspended",
    'resellers_list__filter_status_active' => "Active",
    'resellers_list__filter_clients__filter_title' => "Show",
    'resellers_list__filter_clients_on' => "Resellers with their customers",
    'resellers_list__filter_clients_off' => "Resellers only",
    '__disk_usage' => "Disk space used",
    'ui__reseller/traffic_unknown__short-title' => "View Traffic by Resellers",
    'ui__reseller/traffic_unknown__title' => "View Traffic by Resellers",
    'ui__reseller/traffic#list__title' => "Traffic by reseller",
    'ui__reseller/traffic_unknown__description' => "View traffic usage reports.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Traffic by reseller",

    '__reseller_name' => "Reseller's name",
    '__reseller' => "Resellers",
    'resellertrafficlist_header' => "View Traffic by Resellers",
    '__reseller_personal' => "Traffic used by reseller's domains",
    'ui__reseller/traffic-history__short-title' => "Traffic by resellers",
    'ui__reseller/traffic-history__title' => "Traffic by resellers",
    'ui__reseller/traffic-history__description' => "View traffic usage reports.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Allow overselling",
    'limits__reseller_oversell_description' => "Overselling allows the reseller to sell more resources than was actually allocated to him or her. If overselling is allowed, the reseller is governed by actual resource usage instead of initial resource allocation",
    'limits__overuse_block_text' => "Overuse policy",
    'limits__overuse_block_true_text' => "Overuse is not allowed",
    'limits__reseller_overuse_block_true_description' => "Block the overuse of resources. Actual resource usage cannot exceed the initial resource allocation",
    'limits__overuse_block_false_text' => "Overuse is allowed",
    'limits__reseller_overuse_block_false_description' => "Do not block the overuse of resources, allowing the reseller to use more resources than initially provided. Actual resource usage can exceed the initial resource allocation",
    'limits__reseller_overuse_notify_text' => "Notify the reseller about reaching the resource limits",
    'reseller_perm__manage_sh_access_disabled' => "Reseller cannot allow or prohibit shell access",
    'reseller_perm__manage_sh_access_chrooted' => "Reseller can allow access only to a chrooted environment",
    'reseller_perm__manage_sh_access_any' => "Reseller can allow access to any type of shell",
    'template__reseller_num_excl_ips' => "Allocate dedicated IP addresses to the reseller",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Account",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Customers",
    'ui__reseller#domainsTab__title' => "Domains",
    'ui__reseller__title' => "Manage %1's Reseller Account",
    'domains__reseller_info' => "%1 customers, %2 domains, %3 of disk space used, %4 of data transferred.",
    'domains__reseller_info_hiding_traffic' => "%1 customers, %2 domains, %3 of disk space used.",
    'ui__reseller__description' => "Manage reseller's account.",

    'ui__reseller/limits_unknown__wizard-title' => 'View or change resource limits for a reseller',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Select the reseller you need.',
    'ui__reseller/limits_unknown__wizard__2' => 'To apply the changes, click Finish.',

    'ui__client/report_reseller__short-title' => "Report",
    'ui__client/report_reseller__title' => "View Account Report",
    'ui__client/report_reseller__description' => "View reseller account report.",
    'ui__client/ip-pool_reseller__short-title' => "IP pool",
    'ui__client/ip-pool_reseller__description' => "Assign IP addresses and SSL/TLS certificates to the reseller account.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Specify the account settings and click Finish.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'View or change permissions for a reseller',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Select the reseller whose permissions you want to view or change.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'When done with changing the reseller\'s permissions, click Finish to apply the changes and exit the wizard.',

    // Customers > create customer account

    '__resellers_list' => 'Resellers',
    'picker_reseller__title' => 'Select the reseller',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Tools",
    'ui__client#tools2__title' => "Account",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Customers",
    'ui__client#domainslist__title' => "Domains",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "All web applications are now sorted by categories, which makes it easier to choose the right application to install.",
    'feature__domainkeys__reseller' => "You can use DKIM email sender authentication mechanism to reduce the amount of spam and phishing emails.",

    '__reseller_form' => "Reseller form",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Select the customer account whose settings you want to change.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "To change the resource usage limits, click Resource limits.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "To change permissions for operations the customer can perform in Plesk, click Permissions.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Make this template available to other users",
    'template__shared_description' => "Select this option if you want your customers to be able to use this template.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Tools',

    'ui__client/traffic-history_unknown__short-title' => 'View Traffic by Customers',
    'ui__client/traffic-history_unknown__title' => 'Traffic by Customers',
    'ui__client/traffic-history_unknown__description' => 'View traffic usage report for all customers',
    'ui__client/traffic-history__short-title' => 'Traffic by Customers',
    'ui__client/traffic-history__title' => 'View Traffic by Customers',
    'ui__client/traffic-history__description' => 'View traffic usage report for all customers',

    'ui__client/traffic#list__title' => 'Traffic by customers',
    'ui__reseller/client/traffic#list__title' => 'Traffic by customers',

    'clients_list__filter_type__filter_title' => 'Show',
    'clients_list__filter_type_any' => 'Customers and resellers',
    'clients_list__filter_type_clients' => 'Customers only',
    'clients_list__filter_type_resellers' => 'Resellers only',
    'ui__client/domain_unknown-new__short-title' => "Create Domain",

    // Customers > View traffic by customers
    '__personal' => "Traffic used by user's domains",
    'PersonalTrafficList_header_of_client__' => "View Traffic Usage Report for Your Account",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Domain administrator cannot allow or prohibit shell access",
    'domain_perm__manage_sh_access_chrooted' => "Domain administrator can allow access only to a chrooted environment",
    'domain_perm__manage_sh_access_any' => "Domain administrator can allow access to any type of shell",

    // APS Catalog
    'bt_add_to_vault' => "Add to Vault",
    'bt_hide_updates' => "Hide available updates",
    'bt_show_updates' => "Show available updates",

    '__site_apps__applications' => "Applications",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Applications selected for addition to the vault",
    'site_apps__application_selected' => "Selected",
    'site_apps__currently_in_vault' => "Other versions already in the vault:",
    'site_apps__new_versions' => "New versions:",
    'site_apps__patches' => "Patches:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Number of applications scheduled for addition to the vault: %1",
    'site_apps__applications_downloading_now' => "The following applications are now being downloaded: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Already in the vault",

    // Server > Action Log
    'bt_skin_edit' => "Edit Skin Description",
    'limits__oversell_legend' => "Overselling",
    'limitsManager__limit_available_error' => "Unable to allocate the required amount of resources (%%quantity%% %%limitName%%). Only %%available%% %%limitName%% are available.",
    'limitsManager__limit_reserved_error' => "Unable to set the required resource usage limit (%%quantity%% %%limitName%%) because the new value is less than the amount of resources reserved for your customers or used by yourself (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Unable to set the required resource usage limit (%%quantity%% %%limitName%%) because the new value is less than the actual amount of resource already used by your account and sites (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Bandwidth usage by services",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "View Traffic Usage Report",
    'ui__client/domain/traffic_unknown-reseller__title' => "View Traffic Usage Report",

    'ui__client/domain_new__short-title' => "Create Domain",

    'ui__client_reseller__description' => "Manage reseller account %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Manage reseller account",

    '__owner_name' => "Owner's name",
    'domains_list__resource__filter_title' => "Resource Usage",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS applications catalog",
    'site_apps__applications_have_updates' => "Updated versions of the following applications are available:\n%1\nTo view the updates, make sure the Search area is visible, select <b>Show updates only</b> check box and search for the applications you need.",
    'site_apps__progress_adding_to_vault' => "Adding to the vault: ",
    'site_apps__progress_done_message' => "Progress:",
    'site_apps__progress_applications_left' => "%1 of %2 applications left",
    'site_apps__download_item_long_task_title' => "Download APS application (%1)",
    'site_apps__download_transaction_long_task_title' => "Download APS applications from APS Catalog",
    'site_apps__last_check_for_updates' => "last check for updates: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "All scheduled applications are successfully added to the Application Vault",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 scheduled applications are successfully added to the Application Vault.",
    'site_apps__no_search_results' => 'No applications found. Try different search request or browse applications by categories.',
    'site_apps__search_results_title' => 'Search results',
    '__site_apps__search_by_application' => 'Application name',
    '__site_apps__search_by_vendor' => 'Vendor',
    '__site_apps__search_by_vendor__all' => 'All vendors',
    '__site_apps__search_by_packager' => 'Packager',
    '__site_apps__search_by_certification_level' => 'Certification level',
    '__site_apps__search_by_cert__any' => 'Any',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver and higher',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold and higher',
    '__retry' => 'Retry',
    'site_apps__application_packager_site' => 'Packager',
    'site_apps__add_to_pool_message' => "Applications marked as \"available for all\" are automatically distributed to all resellers and customers with unlimited amount of installations. Restricted applications are distributed to all resellers and customers manually on an individual basis with explicitly specified number of available installations.",
    'site_apps__make_available_for_all' => "Make selected applications available to all users",

    'site_apps__broadcast_app_text' => "Applications marked as \"available for all\" are automatically distributed to all resellers and customers with unlimited amount of installations. Restricted applications are distributed to all resellers and customers manually on an individual basis with explicitly specified number of available installations.",
    'site_apps__broadcast_app_name' => 'Make application available to all users',

    // User Application Pool per application
    'site_apps__available_clients' => 'Available users',
    'site_apps__no_more_clients_to_add_to_pool' => 'There are no more user accounts that you can provide this application to',

    // Installed application instances
    'site_apps__installations' => 'Installations',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domain name and IP address",
    '__assign_ip_address' => "Assign IP address",
    '__switch_on_service' => "Switch on service",
    '__hosting_configuration' => "Hosting configuration",
    '__vrt_hst' => "Website hosting",
    '__vrt_hst_hint' => "Host a website on this server.",
    '__fwd' => "Forwarding",
    '__web_hosting_settings' => "Hosting settings",
    '__fwd_hint' => "Redirect visitors to another website.",
    '__none_hint' => "Do not host a website at the moment.",
    '__login_hint' => "This username is used for accessing your website through FTP",
    '__password_hint' => "This password is used for accessing your website through FTP",
    '__advanced_hosting_setup' => "Configure advanced website hosting settings",
    '__domain_creation_successful' => "The domain was created.",
    'bt_hosting_settings' => "Hosting Settings",
    '__change_hosting_type' => "Change hosting type for domain %1",
    '__hosting_type_change_warning' => "When you change hosting type to forwarding or no hosting, all files and directories related to your site are removed from the server. Be sure to save a local copy of your site.",
    '__current_hosting_type' => "Current hosting type",
    '__new_hosting_type' => "New hosting type",
    '__fwd_settings' => "Forwarding settings",
    '__fwd_settings_legend' => "Forwarding settings",
    '__fwd_destination_url' => "Destination URL",
    '__fwd_type' => "Forwarding type",
    '__fwd_type_standart' => "Standard forwarding",
    '__fwd_type_standart_hint' => "Redirect website visitors to another site and show them the destination address, so they know about the redirection.",
    '__fwd_type_frame' => "Frame forwarding",
    '__fwd_type_frame_hint' => "Redirect website visitors to another site, but do not show them the destination address, so they do not know about the redirection.",
    '__hosting_type_template_warning' => "The type of hosting you selected is different from the type specified in the template. If you continue, web hosting settings in the selected template will be ignored. Are you sure you want to set the selected hosting type?",

    '__no_resellers_selected' => "You must select at least one reseller account.",

    'ui__client/logo_unknown__wizard-title' => 'Set up a logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Please select the customer whose logo properties you want to change.',
    'ui__client/logo_unknown__wizard__2' => 'Click Finish to apply the changes.',
    'ui__client/logo_unknown__wizard__2_self' => 'Click Finish to apply the changes.',

    'ui__client/ipaddress/properties_new__short-title' => "Add IP Address",
    'ui__client/ipaddress/properties_new__title' => 'Add IP Address',
    'ui__client/ipaddress/properties_new__description' => "Add IP address.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Add IP Address",
    'ui__client/ipaddress/properties_unknown-new__title' => "Add IP Address",
    'ui__client/ipaddress/properties_unknown-new__description' => "Add IP Address",
    'ui__client/ipaddress/delete_multi__short-title' => "Remove IP Address",
    'ui__client/ipaddress/delete_multi__description' => "Remove IP addresses.",
    'ippool_Manager__no_available_ips' => "There are no vacant IP addresses in the IP pool.",
    'ippool_Manager__ip_shared' => "shared",
    'ippool_Manager__ip_exclusive' => "dedicated",
    'ui__client/ipaddress/properties__title' => "Manage IP Addresses",
    'ui__client/ipaddress/properties__description' => "View or change IP address properties.",
    'ui__client/ipaddress_unknown-new__title' => "Add IP Address",
    'ui__client/ipaddress_unknown-new__short-title' => "Add IP Address",
    'ui__client/ipaddress_unknown-new__description' => "Add IP addresses.",

    'ui__mass-mail#to_resellers_text__title' => "Resellers",
    'ui__mass-mail#to_domainusers_text__title' => "Domain administrators",
    'ui__mass-email#tools_legend__title' => "Tools",
    'ui__mass-email#list_legend__title' => 'Mass email message templates',
    'ui__mass-email#template_legend__title' => "Template",
    'ui__mass-email#from_email_text__title' => "From",
    'ui__mass-email#to_text__title' => 'To',
    'ui__mass-email#to_resellers_text__title' => "Resellers",
    'ui__mass-email#to_clients_text__title' => "Customers",
    'ui__mass-email#to_domainusers_text__title' => "Domain administrators",
    'ui__mass-email#to_admin_text__title' => "Plesk administrator",
    'ui__mass-email#option_mode_all__title' => "All",
    'ui__mass-email#option_mode_select__title' => "Selected only",
    'ui__mass-email#option_mode_except__title' => "All except selected",
    'ui__mass-email#option_select_template__title' => '---Select a template---',
    'ui__mass-email#subject_text__title' => "Subject",
    'ui__mass-email#body_text__title' => "Message text",
    'ui__mass-email#save_as_legend__title' => "Save as template",
    'ui__mass-email#save_as_text__title' => "Save the composed message to a new template named",
    'ui__reseller/preferences_unknown__wizard-title' => "Change Account Settings",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Select the reseller whose account settings you want to change and click Next.",
    'ui__reseller/preferences_unknown__wizard__2' => "Specify the account settings and click OK.",
    'ippoolManager__ip_shared' => "shared",
    'ippoolManager__ip_exclusive' => "dedicated",

    '__users_list' => "Users",
    '__users' => "Users",
    '__user_name' => "User's name",

    'limit__name_max_dom_aliases' => "domain aliases",
    'limit__name_max_subftp_users' => "additional FTP accounts",
    'limit__name_max_mssql_db' => "Microsoft SQL Server databases",
    'limit__name_max_iis_app_pools' => "IIS application pools",
    'limit__name_max_odbc' => "ODBC connections",
    'total_mboxes_quota_unsupported' => 'not supported by the mail server',
    'limit_soft__disk_space' => 'Notify upon reaching disk space',
    'limit_soft__max_traffic' => 'Notify upon reaching traffic',
    'limitsManager__commit_failed' => "Unable to change resource limits.",
    'limitsManager__date_in_past' => "Incorrect expiration date %1.",
    'limitsManager__limit_not_supported' => "Limits for the resource type %1 cannot be set.",
    'limitsManager__limit_oversell_inconsistency' => "Unable to allocate the specified amounts of resources with overselling switched off.",
    'limitsManager__limit_overuse_inconsistency' => "Resource usage exceeds the defined limits.",
    'limitsManager__no_resource_available' => "There are no available resources of this type (%%limitName%%) left. Requested: %%quantity%%; available: %%unused%%.",
    'limitsManager__no_total_resource_available' => "There are no resources of this type (%%limitName%%) available from your service provider. Requested: %%quantity%%; available: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "The expiration date must be less than or equal to %1.",
    'limitsManager__invalid_disk_space_limit' => "The amount of disk space must be less than or equal to %1.",
    'limitsManager__invalid_max_traffic_limit' => "The amount of traffic must be less than or equal to %1.",
    'ippoolManager__ip_has_suballocations' => "Cannot change the type of IP address already allocated to a user. IP address %%ip%% is already allocated to user(s) as %%reserved%% IP address.",
    'ippoolManager__ip_is_already_in_pool' => "This IP address is already assigned to the user.",
    'ippoolManager__ip_is_not_in_pool' => "There is no IP address %%ip%% in the pool.",
    'ippoolManager__can_not_allocate_ip' => "The IP address %%ip%% is available only as %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "The IP address %%ip%% cannot be allocated as dedicated.",
    'ippoolManager__ip_used_by_hst_or_frw' => "The IP address %%ip%% is already used for hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "Anonymous FTP access is already switched on for the IP address %%ip%%",
    'ippoolManager__no_vacant_ips' => "There are no vacant IP addresses.",
    'ippoolManager__no_available_ips' => "There are no available IP addresses.",
    'templates__dublicate_name' => "A template with such a name already exists. Please select another name for this template.",
    'cl_perm__client_limits_exceeded' => "The specified resource limit values exceed the values allowed by your hosting plan, or these values provide less resources than currently used by your sites.",
    'cl_perm__reseller_limits_exceeded' => "The specified resource limit values exceed the values allowed by your hosting plan, or these values provide less resources than currently used by user accounts and sites.",

    'site_apps__preferences_show_all_versions_title' => "Show the full list of versions for every application retrieved from the catalog",
    'site_apps__preferences_show_all_versions_hint' => "If this option is selected, it may take considerable time to retrieve all versions of each application every time you open the catalog. If this option is not selected, only latest versions are shown.",
    '__select_user_template' => "Create user account based on a template",
    'ip_already_added_to_all_clients' => "This IP address is already assigned to all users.",
    'ui__server/ip-address/client/delete#legend__description' => "The following IP addresses will be removed from the system and users' IP pools:",

    'site_apps__cancelled_apps' => "You have cancelled the addition of the following applications: %2",

    'sb_url_is_not_resolved' => 'URL cannot be resolved: check your DNS settings. URL %1 must resolve in IP address of the server with installed Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Cannot remove the IP address %%ip%% because it is the last IP address present on a network interface.',
    'ip_addr__used_for_current_session' => 'Cannot remove the IP address %%ip%% because it is used by an active session.',
    'ip_addr__used_for_hosting' => 'Cannot remove the IP address %%ip%% because it is used for hosting a website.',
    'ip_addr__is_main' => 'Cannot remove the IP address %%ip%% because it is the primary IP address of a network interface.',
    'ip_addr__ip_used_by_message_submission' => 'Cannot remove the IP address %%ip%% because it is used for the mail message submission',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domains of customers',
    'excl_ip_num' => 'Dedicated IP address',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder is not installed.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Permission to allow oversell cannot be revoked from user since the user has already allocated more resources than available, going into oversell mode.',
    'limitsManager__invalid_limit_value' => 'Incorrect value %%value%% specified for limit %%limit_name%%',
    'limit__max_mn' => 'Maximum number of mail accounts',

    'limits__client_overuse_description' => 'Overuse policy tells Plesk what to do when resource usage exceeds the initial resource allocation.',
    'limits__client_overuse_block_true_description' => 'Block the overuse of resources. Actual resource usage cannot exceed the initial resource allocation',
    'limits__client_overuse_block_false_description' => 'Do not block the overuse of resources, allowing the customer to use more resources than initially provided. Actual resource usage can exceed the initial resource allocation',
    'limits__client_overuse_notify_text' => 'Notify the customer about reaching the resource limits',

    'limits__domain_overuse_description' => 'Overuse policy tells Plesk what to do when resource usage exceeds the initial resource allocation.',
    'limits__domain_overuse_block_true_description' => 'Overuse policy tells Plesk what to do when resources are overused.',
    'limits__domain_overuse_block_false_description' => 'Do not block the overuse of resources, allowing the domain to use more resources than initially provided. Actual resource usage can exceed the initial resource allocation',
    'limits__domain_overuse_notify_text' => 'Notify the domain owner about reaching the resource limits',

    'dns__dns_rr_delete' => 'Items that will be removed',
    'dns__delete_rr' => 'The following DNS records will be removed from the DNS zone:',
    'dns__dns_rr_delete_non_removable' => 'Items that cannot be removed',
    'dns__non_delete_rr' => 'The following DNS records cannot be removed:',
    'dns__dns_rr_delete_confirm_message' => 'Confirm the removal of DNS records',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Unknown web application format: web application might be unavailable for installation and usage.',

    '__php_handler_type_desc' => 'Run PHP as',
    'sfdk_domain_sign__failed' => 'Unidentified error has occurred when trying to switch on signing of mail with DKIM on domain. Refer to server error log for more information.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Plesk key update success notification',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk key update deferral notification',
    'pkey_notify__subj_update_error_notification' => 'Plesk key update error notification',
    'pkey_notify__update_successful' => '%1 update completed successfully.',
    'pkey_notify__update_failed_no_more_try' => 'Unable to update %1. The key you are trying to send is invalid. You should not try updating this key anymore.',
    'pkey_notify__update_failed_try_later' => 'Unable to update %1: an error occurred while processing your key. You can try to retrieve the key manually in Plesk (Tools & Settings > License Information) or let Plesk try to update it in the next 24 hours. If you do not want to receive this notification any more, remove this key from Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Unable to switch off server-wide spam filtering.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Unable to switch on server-wide spam filtering',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domains',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Forwarders',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Customers',
    '__cl_name' => 'Customer name',
    '__cl_creation_date' => 'Creation date',
    '__clients_traffic' => 'Customer traffic',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder is not installed.',
    'sitebuilder_disabled' => 'Presence Builder is switched off.',
    'b_sitebuilder_disabled' => 'Presence Builder is switched off.',
    'webmail_not_installed' => 'Webmail software is not installed.',
    'webmail_disabled' => 'Webmail service is switched off.',
    'spamassassin_not_installed' => 'SpamAssassin is not installed.',
    // pfu:
    'anonymous_ftp_shared' => 'Unable to set up anonymous FTP: shared IP address type.',
    'anonymous_ftp_used' => 'Unable to set up anonymous FTP: the IP address is used by another domain for anonymous FTP service.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET is not installed.',
    'site_builder_no_package' => 'Presence Builder is not available. Please check that Presence Builder is installed and selected as an active component.',
    'site_builder_not_configured' => 'Presence Builder is not configured.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Tools',
    'ui__reseller/client#clientslist__title' => 'Customers',

    //reseller accounts removal

    // NEW HOME PAGE WIZARDS

    // PFW-only

    // COMMON WIZARDS

    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Set up anonymous FTP on domain',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Select the domain for which you want to set up anonymous FTP on.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Set up log manager for domain and view domain log files',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Select the domain which log manager you want to set up and which logs files you want to view.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Manage SSL/TLS certificates for domain',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Select the domain which SSL/TLS certificates you want to manage.',

    'ui__client/domain/disable_multi__wizard-title' => 'Suspend Domains',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Select the domains which you want to suspend.',

    'ui__client/domain/enable_multi__wizard-title' => 'Activate Domains',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Select the domains that you want to activate.',

    'ui__client/domain_unknown__wizard-title' => 'View Domains',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Select a customer whose domains you want to view.',

    'ui__client/domain/register_unknown__wizard-title' => 'Register Domains',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Select the domain which you want to register.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Use Tools from MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Select the domain which you want to manage with tools from MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP Address Users',
    'ui__server/ip-address/client_unknown__title' => 'IP Address Users',
    'ui__server/ip-address/client_unknown__description' => 'Users of IP address %1',

    'disabled_by_admin' => 'Disabled by server administrator',






    'ui__client/domain/chowner_multi__short-title' => 'Change ownership',
    'ui__client/domain/chowner_multi__title' => 'Change subscription ownership',
    'ui__client/domain/chowner_multi__description' => 'Change subscription ownership.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Select the domains for which you want to change ownership and click Next >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Change ownership',
    'ui__client/domain/chowner_unknown__title' => 'Change subscription ownership',
    'ui__client/domain/chowner_unknown__description' => 'Change subscription ownership.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Change subscription ownership',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'There are no custom buttons.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'There are no custom buttons in reseller %1\'s interface.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Remove the button %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Remove',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Remove the button %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Remove custom buttons from reseller\'s interface',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Remove',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Remove custom buttons',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Remove buttons',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Select a reseller whose custom buttons you want to remove and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Select the buttons you want to remove and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Confirm removing the buttons by selecting the check box on this screen, and then click Finish.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Remove a custom button from reseller\'s interface.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Remove',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Remove a custom button',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Remove custom button',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Select a reseller whose custom button you want to remove and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Select a custom button you want to remove and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Confirm removing the custom button by selecting the check box on this screen, and then click Finish.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Edit properties of reseller-level custom button %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Settings',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modify reseller\'s custom button %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Add custom button',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Select a reseller in whose interface you want to create a custom button and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Click Finish to create the button.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Change properties of a button in reseller\'s interface.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Properties',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Change properties of a button in reseller\'s interface',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Change custom button properties',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Select a reseller whose custom button you want to modify and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Select a custom button you want to modify and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'When done with editing the properties of the button, click Finish to apply changes and exit the wizard.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Make the button %1 unavailable to your customers.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Make unavailable to your customers',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Make the button %1 unavailable to your customers',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Make the button %1 visible to reseller\'s customers.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Make available to your customers',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Make the button %1 visible to reseller\'s customers',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Make a custom button available/unavailable to your customers.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Available/unavailable to your customers',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Make a custom button available or unavailable to your customers',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Make a custom button available/unavailable to your customers.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Select a reseller whose custom button you want to make available to the reseller\'s customers and click Next >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Select a custom button that you want to make available or unavailable to your customers and click Next >>.',

    '__not_allowed' => 'Not allowed',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Select new owner of the domain.',

    '__ip_addr_state_unknown' => "IP address is not operational now due to the system still processing your request. Please wait a minute.",


    'resellers_list__accounts' => 'Users',

    'ip_addr__repair_is_not_allowed' => 'IP address cannot be repaired under Virtuozzo environment.',

    'ui__reseller/client__none-available__1' => 'Reseller %1 does not have customers.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP address %%ip%% cannot be removed because it is used by one or more domains with no hosting.",
    'ippoolManager__ip_used_for_mail_service' => "IP address %%ip%% cannot be removed because it is used by one or more domains for their mail service IP address.",
    'ippoolManager__ip_used_for_send_emails' => "IP address %%ip%% cannot be removed because it is used to send emails from specific IP (see Mail Server Settings).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP address %%ip%% cannot be removed because it is used by DNS zone of one or more domains.',
    'ip_ctrl__cannot_manage_on_vz' => 'This installation of Plesk is working under Virtuozzo containers. New IP addresses can be added only by the Virtuozzo containers node administrator.',

    'client_template__limits_auto_adjusted' => 'Limits from customer template were automatically adjusted.',

    '__entries' => 'Entries',

    '__path_is_not_set' => 'The path is not specified. Please specify a valid path.',

    'defaultcomponents__imap_required' => '(Current mail server does not support IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk supports only commercial web statistics software for subdomain statistics calculation. No such software is currently installed in the system.',


    'server_settings_invalid_traffic_statistics' => 'Invalid retain traffic statistics parameter.',
    'server_settings_invalid_logrotate_period' => 'Invalid log rotation period parameter.',

    'spam_filter/address/file_size' => 'Unable to upload the file. The maximum size of a file to upload is %1.',
    'spam_filter/address/file_empty_content' => 'There was trouble reading email addresses from the file. Make sure that you are uploading a file in UTF-8 encoding containing one or more email addresses, and try again.',
    'spam_filter/address/addresses_empty_content' => 'There are no email addresses in the list.',
    'spam_filter/address/addresses_available' => 'Only %1 first unique email addresses will be added.',
    'spam_filter/address/invalid_addresses' => 'The following email addresses are invalid: %1.',

    'current_resources' => 'Current resources',
    'plan_limitations' => 'Plan limitations',
    'cannot_switch_plan' => 'Cannot switch to the selected plan, because the following current resources are exceeding the plan\'s limitations:',
];
