<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Geçersiz Ağ Geçidi: yanıt başlığı okunurken yukarı akış çok büyük başlık gönderdi"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Yakında hazır olacaktır.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Dahili Sunucu Hatası: FollowSymLinks seçeneğine burada izin verilmez"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Yakında hazır olacaktır.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "sunucu max_children ayarına ulaştı"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Belirtiler</h4><ul><li><p>PHP işleyicisinin <strong>Apache tarafından sunulan FPM uygulaması</strong> veya <strong>nginx tarafından sunulan FPM uygulaması</strong> olarak <strong>Alan adları</strong> &gt; <strong>örnek.com</strong> olan &gt; <strong>PHP Ayarları</strong> aşağıdaki sorunlardan biriyle karşılaştı:</p><ul><li><p>yavaş yüklenme</p></li><li><p>bir web tarayıcısında 50x hatasıyla erişilemiyor (kalıcı veya geçici olarak):</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>PHP-FPM hata günlüğü dosyasında şu mesaj görünüyor <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (<em>XX</em>, web siteleri tarafından kullanılan bir PHP sürümüdür):</p><pre>DİKKAT:[pool example.com] sunucusu max_children ayarına ulaştı (*), artırmayı bir düşünün</pre><ul><li><p>Yukarıdaki mesaj genelde bu hatayla birlikte görünür:</p><pre>alt nesnede yazan okunamıyor: Bozuk dosya tanımlayıcısı (9)</pre></li></ul></li><li><p>Sunucuda nginx etkinse alan adının hata günlüğü dosyasında aşağıdaki mesajlardan biri görünebilir <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock yukarı akışa bağlanırken başarısız oldu (11: Kaynak geçici olarak kullanılamaz), istemci: 203.0.113.2, sunucu: örnek.com, talep: "GET / HTTP/1.1" üst akış: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", barındıran: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 yukarı akıştan yanıt başlığı okunurken bağlantı, yukarı akış zamanından önce kapandı, istemci 203.0.113.2, sunucu: örnek.com, talep: "POST /path/to/some/file HTTP/2.0", yukarı akış:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM<code>pm.max_children</code>\'a web siteleri tarafından ulaşıldı.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'pm.max_children sınırını artırın',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Etkilenen alan adları için <code>pm.max_children</code> limitini artırın:</p><ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a> ile Plesk sunucusuna bağlanın.</p></li><li><p>Aşağıdaki kodu kullanarak etkilenen alan adlarını bulun:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Not:</strong> Soldaki kod, <code>pm.max_children</code> limitine web sitesinin kaç kez ulaşıldığını gösterir.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 örnek.com<br>50 örnek.net<br>25 örnek.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Plesk\'e giriş yapın</a>.</p></li><li><p><strong>Alan adlarına</strong> gidin &gt;<strong>örnek.com</strong> &gt; <strong>PHP Ayarları</strong> &gt; <strong>PHP-FPM Ayarları</strong>.</p></li><li><p>Alan adı için <code>pm.max_children</code> değerini artırın ve değişiklikleri uygulayın. 2. adımdaysa bu değeri tüm alan adları için artırın.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Çok fazla açık dosya var"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Bir Plesk sunucusunda nginx başlatılamadı/yeniden yüklenemedi: Çok fazla açık dosya var</p><h4>Belirtiler</h4><ul><li><p>nginx hizmeti, aşağıdaki hatadan dolayı başlatılamadı/yeniden yüklenemedi <code>/var/log/nginx/error.log</code> dosya:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: çok fazla dosya)</pre></li><li><p>Web sitelerinin bazılarına veya tümüne erişilemiyor</p></li><li><p>Uyarı, <strong>Araçlar &amp; Ayarlar &gt; Tanı &amp; tamir et</strong> seçenekleriyle görülebilir:</p><pre style="white-space: pre-wrap;">Nginx ULIMIT değeri kontrol ediliyor Sunucuda N alan adı bulundu. Açık dosyalar için nginx varsayılan sınırıyla ilgili sorun olabilir</pre></li><li><p>NodeJS ve Ruby web uygulamaları, alan adları, abonelikler, Apache veya Nginx\'te değişiklikler vb. gibi bazı Plesk görevlerini gerçekleştirirken 502 Bad Gateway hatası gösteriyor:</p><pre style="white-space: pre-wrap;">Sunucu Hatası<br>502 Bad Gateway <br>Web sunucusu, gateway veya proxy sunucusu gibi davranırken geçersiz bir cevap aldı.</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">Alan adı için yeni bir sertifika kurduktan sonra</a> eski sertifika web tarayıcısında gösterilse de doğru sertifika <strong>Alan adları &gt; örnek.com &gt; Barındırma Ayarları</strong> sayfasında gösterilir.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx\'in sanal ana bilgisayarı, fiziksel barındırma ile her sanal ana bilgisayar için 4 günlük dosyası açar:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Bu durumun bir sonucu olarak, çok sayıda alan alanı nedeniyle (genellikle 100\'den fazla) nginx sunucusu tarafından maksimum açık dosya sayısı aşılır.</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Açık dosya sınırını artırın',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Dikkat:</strong> <code>websrv_ulimits</code> yardımcı programının <strong>--no-restart</strong> seçeneği olmadan yürütülmesi, tüm alan adları için web yapılandırma dosyalarının yeniden oluşturulmasını başlatır ve çok sayıda barındırılan web sitesi olması durumunda önemli kesinti sürelerine neden olabilir.<br><br>Komutu, bakım zamanı çerçevesinde yürütün.</div><p>Açık dosya sınır değerini <strong>Plesk\'te alan sayısından (en az 16)</strong> daha fazla ayarlamak iyi bir uygulamadır. Aşağıdaki örnek, sınırın 4096\'ya nasıl ayarlanacağını gösterir:</p><ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p> ile sunucuya bağlanın. Hem Apache hem de Nginx için açık dosya limitini 4096 olarak ayarlayın:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p><strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> üzerinden Apache ve nginx hizmetlerini yeniden başlatın Değişiklikleri uygulamak için <strong>Araçlar &amp; Ayarlar &gt; Hizmet Yönetimi</strong> seçeneklerine gidin.</p></li><li><p>Web hizmetleri yeniden başlatıldıktan sonra "Maks. açık dosya limitinin" doğru şekilde uygulanıp uygulanmadığını kontrol edin:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Yukarıdaki çözüm yardımcı olmazsa <code>ulimit</code> yardımcı programını kullanarak limiti ayarlayın:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Yanıt gövdesi çok büyük"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Yakında hazır olacaktır.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "403 koduyla erişim reddedildi"',
    'problem-detail.modsec-access-denied.description' => '<h4>Belirtiler:</h4><ul><li><p>ModSecurity, <strong>Araçlar ve Ayarlar > Web Uygulaması Güvenlik Duvarı (ModSecurity) > Web uygulaması güvenlik duvarı modu > Açık</strong> olarak yüklenir ve etkinleştirilir.</p></li><li>Plesk\'te barındırılan bir websitesi yüklenemiyor. Web sitesinde WordPress yönetme, webmail\'e erişim, <code>robots.txt</code> dosyasına erişim gibi işlemler yapılamaz. Tarayıcı aşağıdaki hatalardan birini gösterebilir: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Yasaklı</pre><hr><pre>500 Dahili Sunucu Hatası</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Aşağıdaki gibi bir ModSecurity hata mesajı <code>/var/log/modsec_audit.log</code> günlük dosyasında veya Plesk\'teki Günlükler sayfasında (<strong>Alan Adları</strong> &gt; <strong>example.com</strong> &gt; <strong>Günlükleri</strong>) görünür:<pre>ModSecurity: 403 koduyla erişim reddedildi (faz 2). Operatör GE, TX:anomaly_score\'da 5 ile eşleşti. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [satır "57"] [id "949110"] [msg "Gelen Anomali Puanı Aşıldı (Toplam Puan: 5)"] [önem derecesi "KRİTİK"] ["application-multi" etiketi] ["language-multi" etiketi] ["platform-multi" etiketi] ["attack-generic" etiketi] [ana bilgisayar adı "example.com "] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Uygulaması Güvenlik Duvarı; OWASP, Comodo gibi çok kısıtlayıcı bir kural seti veya Imunify360 gibi özel bir kural seti ile etkinleştirilir. Kısıtlayıcı kural setleri, web sitesinde bazı operasyonları engelleyebilir.</p><p><Strong>Not:</strong>ModSecurity hatası, sunucunuza bir saldırı olduğunu gösterebilir. ModSecurity\'nin web sitenizde geçerli bir kullanımı engellediğinden eminseniz aşağıdaki çözümleri kullanın.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'ModSecurity kural setini kimlik veya etikete göre devre dışı bırakın',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Web sitenizin meşru kullanımını engelleyen kuralın kimliğini bulun. Hata mesajlarının içindeki kimlikleri <code>/var/log/modsec_audit.log</code> günlük dosyasında bulabilirsiniz. Kimlik, tırnak içinde, köşeli parantez içinde <code>id</code> önekiyle birlikte bir tam sayıdır, örneğin, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Plesk\'te belirli kural setlerini devre dışı bırakır</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Başka bir ModSecurity kural kümesine geçin',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Daha az kısıtlayıcı bir ModSecurity kural setine geçin. Örneğin: "Atomic ModSecurity Kural Seti". Bunu yapmak için <strong>Araçlar ve Ayarlar</strong> > <strong>Web Uygulaması Güvenlik Duvarı (ModSecurity)</strong> > <strong>Ayarlar</strong>\'a gidin, <strong>Atomic Standard</strong>\'ı seçin ve ardından değişiklikleri uygulamak için <strong>Tamam</strong>\'ı tıklayın.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Dahili Sunucu hatası 500: İzin verilen bellek boyutunun XXX kadarı tükendi"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Belirtiler:</h4><ul><li><p>Plesk\'te barındırılan bir web sitesine erişilemiyor:</p><pre>500 Dahili Sunucu Hatası</pre></li><li><p>Web sitesi günlüğünde aşağıdaki hata gösteriliyor:</p><pre>Hata "PHP mesajı: PHP Önemli hata: 3. satırda /var/www/vhosts/example.com/httpdocs/somethingBig.php\'de 4194304 baytlık izin verilen bellek boyutu tükendi (4000032 bayt ayırmaya çalıştı)"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Web sitesinde işlenmek için ayrılan yeterli bellek yok.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Web sitesinin bellek_sınırını arttırın',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir kısıtlaması yürülükte"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Belirtiler:</h4><ul><li><p>Web tarayıcısında bulunan aşağıdaki hatalardan biri olduğunda bir web sitesine ulaşılamaz:</p><pre>404 dosya bulunamadı</pre><hr><pre>500 Dahili Sunucu Hatası</pre><hr><pre>Hata 500 move_uploaded_file(): open_basedir kısıtlaması etkindir. Dosya(/path/to/the/directory) izin verilen yolda değil: (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Alan adının Günlükler sayfasında aşağıdaki hata mesajı görünüyor (<strong>Alan adları</strong> > <strong>example.com</strong> > <strong>Günlükler</strong>):</p><pre><...> open_basedir kısıtlaması yürürlükte. Dosya(/path/to/the/directory) izin verilen yol(lar) içinde değil <...></pre><hr><pre>Gözden Kaçan İstisna: Oturum: Yapılandırılmış kaydetme yolu "/path/to/the /directory" bir dizin değil, mevcut değil veya oluşturulamıyor.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP komutu, erişime izin verilmeyen dizine ulaşıyor. Bu kısıtlama, her alan adı için ayrı ayrı PHP <code>open_basedir</code> yönergesi tarafından tanımlanır. Varsayılan olarak <code>open_basedir</code>, sistemin varsayılan oturum yolunun yanı sıra <code>tmp</code> ve alan adının belge kök dizinlerine erişime izin verir.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Ek yolu open_basedir yönergesine ekleyin',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Open_basedir yönergesini devre dışı bırakın',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p><strong>Alan adları &gt example.com &gt PHP Ayarları</strong> sayfasına gidin ve <code>open_basedir</code> yönergesini "hiçbiri" olarak ayarlayın.</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: Sunucu yapılandırması tarafından istemci reddedildi"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Belirtiler:</h4><ul><li><p>Web sitesi, aşağıdakine benzer biir hata gösteriyor:</p><pre>Sunucu Hatası 403<br>Yasaklı</pre></li><li><p><code>/var/www/vhosts/system/example.com/logs/error_log</code> günlük dosyası şuna benzer hatalar barındırıyor:</p><pre>AH01797: istemci sunucu yapılandırması tarafından reddedildi: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Mevcut Apache yapılandırması web sitesine erişime izin vermiyor.</p><p>.htaccess ve .htpasswd gibi dosyalar için normaldir çünkü bu dosyalar web sunucusu üzerinden erişilebilir olmamalıdır.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Sürücü konfigürasyonunu ve .htaccess dosyalarını denetleyin',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Plesk\'teki bir web sitesinin dizinine ulaşılamıyor: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Belirtiler:</h4><ul><li><p>Bir web sitesinin belirli konumuna erişilemiyorsa, mesela: <code>http://example.com/some_folder</code>. Şu hata ortaya çıkar:</p><pre>Sunucu Hatası 403<br>Yasaklı</pre></li><li><p><code>/var/www/vhosts/example.com/logs/error_log<code/> dosyasında aşağıdaki hata ortaya çıkar:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [istemci 203.0.113.2:55714] AH01276: /var/www/vhosts/example.com/httpdocs/some_folder/ dizini sunulamıyor: Eşleşen DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) bulunamadı ve sunucunun oluşturduğu dizin indeksi Seçenekler yönergesiyle yasaklanmış</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>İstenen dizin, dizin dosyalarını içermiyor veya dizin taraması etkin değil.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Dizine bir dizin dosyası ekleyin',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Dizinde gezinmeyi etkinleşirin',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Plesk\'teki bir web sitesinin dizinine ulaşılamıyor: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Belirtiler:</h4><ul><li><p>Bir web sitesinin belirli konumuna erişilemiyorsa, mesela: <code>http://example.com/some_folder</code>. Şu hata ortaya çıkar:</p><pre>Sunucu Hatası 403<br>Yasaklı</pre></li><li><p><code>/var/www/vhosts/example.com/logs/error_log dosyasında</code>aşağıdaki hata ortaya çıkar:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [istemci 203.0.113.2:55714] AH01276: /var/www/vhosts/example.com/httpdocs/some_folder/ dizini sunulamıyor: Eşleşen DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) bulunamadı ve sunucunun oluşturduğu dizin indeksi Seçenekler yönergesiyle yasaklanmış</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>İstenen dizin, dizin dosyalarını içermiyor veya dizin taraması etkin değil.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'İndekse bir dizin dosyası ekleyin',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Dizinde gezinmeyi etkinleştirin',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "sunucu MaxRequestWorkers ayarına ulaştı"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Yakında hazır olacaktır.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP istek gövdesi sınırı "istemci çok büyük gövde göndermeyi amaçlıyor"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Yakında hazır olacaktır.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP istek gövdesi sınırı "istemci çok büyük gövde göndermeyi amaçlıyor"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Yakında hazır olacaktır.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP oturumları "503 Dahili Sunucu Hatası" veya "Oturum verisini okuma başarısız"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Yakında hazır olacaktır.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfb_openfile: htaccess dosyası kontrol edilemiyor, okunabilir olduğuna emin olun"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Belirtiler</h4><ul><li><p>Plesk\'te barındırılan bir web sitesi çalışmıyor:</p><pre>Bu sunucuda/sunucuya erişim izniniz yok. <br> Ayrıca, isteği işlemek için bir ErrorDocument kullanmaya çalışırken 403 Yasaklı hatasıyla karşılaşıldı.</pre><p>Yukarıdaki hata yerine boş bir sayfa da görebilirsiniz.</p></li><li><p><strong>Alan adları &gt example.com &gt Günlükler</strong>\'de bulunan alan adı hata günlüğü şunları içerir:</p><pre>(13)İzin reddedildi: [istemci 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: htaccess dosyası kontrol edilemiyor. Okunabilir olduğuna ve "/var/www/vhosts/example.com/httpdocs/" dizininin yürütülebilir olduğuna emin olun</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Alan adı dosyaları veya klasörleri için yanlış izinler.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Web sitesinin içeriği için izinleri onarın',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Bilgi Tabanı yazısını okuyun ve talimatlara uyun</a>.</p></li></ol>',
];