<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Jika tapak web anda dihoskan pada alamat IP yang khusus (tidak dikongsi dengan pengguna atau tapak web lain) anda boleh menyediakan direktori dalam tapak di mana pengguna lain akan dapat memuat naik atau memuat turun fail awanama melalui FTP. Apabila FTP awanama dihidupkan, pengguna akan dapat untuk log masuk ke direktori di alamat seperti ftp://ftp.your-domain.com dengan "awanama" nama pengguna dan mana-mana kata laluan.',
    'anonymous-ftp.displayLogin' => 'Paparkan mesej log masuk',
    'anonymous-ftp.loginText' => 'Teks mesej',
    'anonymous-ftp.incomingDir' => 'Membenarkan memuat naik ke direktori masuk',
    'anonymous-ftp.incomingSubDir' => 'Membenarkan penciptaan direktori di dalam direktori masuk',
    'anonymous-ftp.incomingReadable' => 'Membenarkan memuat turun dari direktori masuk',
    'anonymous-ftp.quota' => 'Hadkan ruang cakera dalam direktori masuk',
    'anonymous-ftp.maxConnections' => 'Hadkan bilangan sambungan serentak',
    'anonymous-ftp.bandwidth' => 'Hadkan muat turun lebar jalur untuk domain maya FTP ini',
    'anonymous-ftp.unlimited' => 'Tidak terhad',

    'aps.catalog.loading' => 'Memuatkan...',
    'aps.catalog.searchName' => 'Permohonan',
    'aps.catalog.searchVendor' => 'Vendor',
    'aps.catalog.searchPackager' => 'Dipakej',
    'aps.catalog.searchLicenseType' => 'Jenis lesen',
    'aps.catalog.searchLicenseTypeAny' => 'Mana-mana',
    'aps.catalog.searchLicenseTypeFreeware' => 'Percuma',
    'aps.catalog.searchLicenseTypeCommercial' => 'Komersil',
    'aps.catalog.showSearch' => 'Tunjukkan Carian',
    'aps.catalog.hideSearch' => 'Sembunyikan Carian',
    'aps.catalog.buttonSearch' => 'Cari',
    'aps.catalog.buttonResetSearch' => 'Tetapkan Semula Carian',
    'aps.catalog.showCategories' => 'Pilik kategori di bawah atau cari apl yang menggunakan kotak carian',
    'aps.catalog.searchResults' => 'Hasil carian',
    'aps.catalog.buttonInstall' => 'Pasang',
    'aps.catalog.buttonInstallTooltip' => 'Pasang versi terkini aplikasi dengan cepat dengan parameter lalai optimum.',
    'aps.catalog.buttonAdvancedInstall' => 'Pasang (Tersuai)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Pasang versi terkini aplikasi dengan menyesuaikan semua parameter.',
    'aps.catalog.buttonInstallOldVersion' => 'Versi Pemasangan',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Pasang versi aplikasi yang dipilih dengan menyesuaikan semua parameter.',
    'aps.catalog.buttonInstallDescription' => 'Memasang aplikasi tersebut pada tapak jika anda sudah mempunyai kod pengaktifan atau jika anda hanya mahu untuk mencubanya.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Pasang aplikasi percuma ini pada tapak.',
    'aps.catalog.version' => 'Versi',
    'aps.catalog.moreVersions' => 'Lebih banyak versi',
    'aps.catalog.release' => 'Keluaran',
    'aps.catalog.overview' => 'Gambaran keseluruhan',
    'aps.catalog.noApplicationsInCategory' => 'Tiada permohonan tersedia dalam kategori ini. Pilih kategori yang lain.',
    'aps.catalog.noCategoriesSelected' => 'Pilih kategori untuk menyemak imbas semua permohonan yang tersedia dalam kategori ini.',
    'aps.catalog.noSearchResults' => 'Carian anda tidak sepadan dengan mana-mana permohonan.',
    'aps.catalog.connectionFailed' => 'Sambungan ke Katalog Aplikasi telah gagal. %%retryLink%%.',
    'aps.catalog.retry' => 'Cuba Semula',
    'aps.catalog.categoriesError' => 'Senarai kategori tidak dapat dimuatkan pada masa ini.',
    'aps.catalog.applicationsError' => 'Senarai aplikasi yang tidak dapat dimuatkan pada masa ini.',
    'aps.catalog.detailsError' => 'Butiran permohonan tidak dapat dimuatkan pada masa ini.',
    'aps.catalog.searchError' => 'Keputusan carian tidak dapat dimuatkan pada masa ini.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Release %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Sejarah bagi perubahan',
    'aps.catalog.officialApplicationSite' => 'Maklumat Vendor',
    'aps.catalog.returnToCategories' => '<< Kembali ke senarai aplikasi',
    'aps.catalog.buttonUninstall' => 'Alih keluar',
    'aps.catalog.gotoHome' => 'Laman Utama',
    'aps.catalog.all' => 'Semua',
    'aps.catalog.buttonDetails' => 'Ketahui lebih lanjut',
    'aps.catalog.buttonBuy' => 'Beli sekarang',
    'aps.catalog.buttonBuyTooltip' => 'Beli aplikasi',
    'aps.catalog.buttonBuyDescription' => 'Kunjungi kedai kami bagi membeli kod pengaktifan untuk aplikasi.',
    'aps.catalog.buttonDownload' => 'Muat turun',
    'aps.catalog.buttonDownloadDescription' => 'Muat turun aplikasi jika anda sudah mempunyai kod pengaktifan atau hanya mahu mencubanya.',
    'aps.catalog.marketplaceMoreInfo' => 'Untuk keterangan lanjut, kunjungi %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'tapak web aplikasi vendor',

    'aps.configure.installedAt' => "Dipasang pada",
    'aps.configure.otherSettings' => "Lain-lain",
    'aps.configure.globalSettings' => 'Tetapan pakej',
    'aps.configure.passwordConfirmation' => 'Sahkan kata laluan',
    'aps.configure.databaseParams' => 'Parameter pangkalan data',
    'aps.configure.noInstallationUrlAvailable' => 'Tiada (aplikasi luaran)',
    'aps.configure.updateSettingsSection' => 'Tetapan Kemas Kini',
    'aps.configure.forceUpdates' => 'Mengemas kini aplikasi ini secara automatik apabila kemas kini tersedia',
    'aps.configure.forceUpdatesHint' => 'Aplikasi ini akan menerima kemas kini automatik kepada versi lebih baru. Amaran: Gunakan pilihan ini dengan berhati-hati kerana kemas kini boleh menjejaskan fungsi aplikasi dengan ketara. Contohnya, sambungan aplikasi boleh berhenti berfungsi dengan versi lain aplikasi tersebut.',

    'aps.install.showAllSettings' => 'Tunjukkan Semua Tetapan',
    'aps.install.showLessSettings' => 'Tunjukkan Tetapan Minimum',
    'aps.install.install' => 'Pasang',
    'aps.install.otherSettings' => 'Tetapan lain',
    'aps.install.globalSettings' => 'Tetapan pakej',
    'aps.install.passwordConfirmation' => 'Sahkan kata laluan',
    'aps.install.provisionsSectionLabel' => 'Laluan pemasangan',
    'aps.install.context' => 'Tentukan lokasi di mana permohonan web ini perlu dipasang',
    'aps.install.registerAsWebmailSection' => 'Pendaftaran mel web',
    'aps.install.registerAsWebmailDescription' => "Pilih pilihan ini jika aplikasi adalah klien mel web. Ini akan membuat aplikasi muncul antara perkhidmatan mel web tersedia dalam tetapan Mel bagi langganan dan pelan perkhidmatan. Pentadbir boleh mengkonfigurasi URL mel web yang boleh diakses secara terbuka dalam Pengurusan Pelayan > Tetapan > Mel Web.",
    'aps.install.registerAsWebmailLabel' => 'Daftar sebagai perkhidmatan mel web',
    'aps.install.addItem' => 'Tambah',
    'aps.install.removeItem' => 'Alih keluar',
    'aps.install.updateSettingsSection' => 'Tetapan Kemas Kini',
    'aps.install.forceUpdates' => 'Mengemas kini aplikasi ini secara automatik apabila kemas kini tersedia',
    'aps.install.forceUpdatesHint' => 'Aplikasi ini akan menerima kemas kini automatik kepada versi lebih baru. Amaran: Gunakan pilihan ini dengan berhati-hati kerana kemas kini boleh menjejaskan fungsi aplikasi dengan ketara. Contohnya, sambungan aplikasi boleh berhenti berfungsi dengan versi lain aplikasi tersebut.',

    'aps.invalid-requirements.requirementsLegend' => 'Keperluan',
    'aps.invalid-requirements.domainLegend' => 'Tapak web',
    'aps.invalid-requirements.context' => 'Pilih tapak web yang lain',
    'aps.invalid-requirements.backToApplicationList' => 'Kembali ke senarai aplikasi',

    'aps.license.title' => 'Pemasangan bagi %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Untuk memasang aplikasi ini, anda perlu membaca perjanjian pengguna lesen akhir dan bersetuju dengan terma-termanya.',
    'aps.license.licenseAgree' => 'Saya menerima terma bagi Perjanjian Lesen',

    'aps.services-list-customization.settings' => 'Tetapan',

    'asp-dot-net.change-version.title' => 'Memilih Versi ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'Versi rangka kerja ASP.NET',
    'asp-dot-net.change-version.success' => 'Versi ASP.NET ditukar.',

    'asp-dot-net.settings.casSettingsSection' => "Kod keselamatan akses",
    'asp-dot-net.settings.clientScriptsSection' => "Tetapan pustaka skrip",
    'asp-dot-net.settings.connStringsSection' => "Pengurus rentetan sambungan",
    'asp-dot-net.settings.customErrorsSection' => "Tetapan ralat tersuai",
    'asp-dot-net.settings.frameworkVersionSection' => "Versi Rangka kerja",
    'asp-dot-net.settings.globalizationSection' => "Tetapan globalisasi",
    'asp-dot-net.settings.otherSection' => "Tetapan sesi",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Penyusunan dan penyahpepijatan",
    'asp-dot-net.settings.authMode' => "Mod pengesahan",
    'asp-dot-net.settings.connStrings' => "Rentetan sambungan",
    'asp-dot-net.settings.connStringsInvalid' => "Beberapa medan adalah kosong atau mengandungi nilai yang tidak wajar",
    'asp-dot-net.settings.connStringName' => "Nama",
    'asp-dot-net.settings.connStringValue' => "Parameter Sambungan",
    'asp-dot-net.settings.connStringsDescription' => "Nama / Parameter Sambungan",
    'asp-dot-net.settings.culture' => "Budaya",
    'asp-dot-net.settings.customErrMode' => "Mod ralat tersuai",
    'asp-dot-net.settings.customErrorRedirect' => "Ubah Hala URL",
    'asp-dot-net.settings.customErrorStatus' => "Kod Status",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Kod status mestilah nombor integer.",
    'asp-dot-net.settings.customErrors' => "Ralat tersuai",
    'asp-dot-net.settings.customErrorsDescription' => "Kod Status / URL Ubah hala",
    'asp-dot-net.settings.customErrorsInvalid' => "Beberapa medan adalah kosong atau mengandungi nilai yang tidak wajar",
    'asp-dot-net.settings.debugMode' => "Hidupkan penyahpepijatan",
    'asp-dot-net.settings.defLanguage' => "Bahasa tapak web lalai",
    'asp-dot-net.settings.tempDirectory' => "Direktori sementara",
    'asp-dot-net.settings.fileEnc' => "Pengekodan fail",
    'asp-dot-net.settings.fileEncInvalid' => "Nilai yang ditentukan bagi parameter pengekodan fail adalah tidak sah.",
    'asp-dot-net.settings.pathToLib' => "Laluan ke pustaka skrip Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Pasang",
    'asp-dot-net.settings.reqEnc' => "Permintaan pengekodan",
    'asp-dot-net.settings.reqEncInvalid' => "Nilai yang ditentukan bagi parameter pengekodan Permintaan adalah tidak sah.",
    'asp-dot-net.settings.resEnc' => "Pengekodan respons",
    'asp-dot-net.settings.resEncInvalid' => "Nilai yang ditentukan bagi parameter pengekodan Respons adalah tidak sah.",
    'asp-dot-net.settings.sessTimeout' => "Sesi tamat masa (minit)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Nilai yang ditentukan bagi parameter Sesi tamat adalah tidak sah. Masukkan nombor integer positif kurang daripada atau sama dengan %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Nama rentetan sambungan sudah digunakan.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Kod status perlulah antara 100 dan 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Kod status sudah digunakan.",
    'asp-dot-net.settings.trustLevel' => "Tahap kepercayaan CAS",
    'asp-dot-net.settings.uiCulture' => "Budaya UI",
    'asp-dot-net.settings.version' => "Versi",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Benarkan mengatasi tahap kepercayaan CAS pada tapak web',
    'asp-dot-net.settings.updateSuccess' => 'Kemaskini berjaya',

    'database.clone.formDescription' => 'Salin kandungan pangkalan data ke dalam pangkalan data baharu atau sedia ada. Semasa disalin ke pangkalan data yang sedia ada, jadual pangkalan data sumber ditambahkan kepada senarai jadual dalam pangkalan data destinasi. Amaran: Jika nama jadual bertembung, maka jadual daripada sumber akan menggantikan jadual daripada destinasi.',
    'database.clone.copyData' => 'Cipta salinan penuh',
    'database.clone.copyDataHint' => 'Jika di pilih, pangkalan data keseluruhan akan disalin (termasuk struktur dan data). Jika dikosongkan, hanya jadual struktur akan disalin.',
    'database.clone.server' => 'Pelayan pangkalan data destinasi',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Lain...',
    'database.clone.database' => 'Pangkalan data destinasi',
    'database.clone.newDatabase' => 'Cipta pangkalan data dengan nama',
    'database.clone.existingDatabase' => 'Salin ke pangkalan data yang sedia ada',
    'database.clone.externalDbHost' => 'Nama hos atau alamat IP',
    'database.clone.externalDbLogin' => 'Nama pengguna',
    'database.clone.externalDbPassword' => 'Kata laluan',
    'database.clone.subscription' => 'Langganan destinasi',
    'database.clone.subscription_powerUser' => 'Ruang web destinasi',
    'database.clone.cloneInProgress' => 'Pengklonan pangkalan data %%source%% ke %%destination%% pangkalan data. Anda akan dimaklumkan mengenai kemajuan melalui e-mel (%%email%%).',
    'database.clone.unableToClone' => 'Tidak dapat menyalin pangkalan data: %%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Tidak dapat mencipta %%destination%% pangkalan data pada pelayan yang dinyatakan.',
    'database.clone.databaseCloned' => 'Pangkalan data "%%source%%" telah disalin.',
    'database.clone.emailSubjSuccess' => 'Pangkalan data "%%sourceDatabase%%" telah disalin.',
    'database.clone.emailSubjFailure' => 'Penyalinan pangkalan data "%%sourceDatabase%%" gagal.',
    'database.clone.emailBodySuccess' => 'Pangkalan data "%%sourceDatabase%%" (%%sourceHost%%) telah disalin ke pangkalan data "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Tidak dapat menyalin pangkalan data "%%sourceDatabase%%" (%%sourceHost%%) ke pangkalan data "%%destDatabase%%" (%%destHost%%). Prosedur penyalinan gagal.',
    'database.clone.localServer' => 'pelayan setempat',

    'database.repair-orphaned.formDescription' => 'Pengguna ini menjadi yatim selepas proses pemulihan. Sila berikan kata laluan untuk pengguna ini bagi menyelesaikan isu ini. Jika pengguna ini sepatutnya menjadi pengguna sistem tanpa kata laluan, jalankan utiliti pembaikan dengan medan kata laluan yang kosong.',
    'database.repair-orphaned.login' => 'Nama pengguna pangkalan data',
    'database.repair-orphaned.pass' => 'Kata laluan',
    'database.repair-orphaned.pass2' => 'Sahkan kata laluan',
    'database.repair-orphaned.users' => 'Sesetengah pengguna memerlukan perhatian anda. Terdapat beberapa pengguna yatim yang perlu dibaiki untuk berfungsi dengan betul.',
    'database.repair-orphaned.orphaned' => 'Pengguna adalah yatim. %%gui begin:link%%Repair now%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Baiki',

    'database.repair.fixSelected' => 'Pembaikan yang Dipilih',
    'database.repair.fix' => 'Baiki',

    'database.user.password' => 'Kata laluan',
    'database.user.passwordConfirmation' => 'Sahkan kata laluan',
    'database.user.server' => 'Pelayan pangkalan data',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Pangkalan Data',
    'database.user.anyDatabase' => 'Mana-mana',
    'database.user.dataAccess' => 'Akses Data',
    'database.user.structureAccess' => 'Akses Struktur',
    'database.user.globalAccess' => 'Keistimewaan Global',
    'database.user.globalAccessHint' => 'Kerja keistimewaan global untuk semua pangkalan data dalam akaun pengehosan ini.',
    'database.user.aclRadio' => 'Kawalan akses',
    'database.user.aclLocalhost' => 'Benarkan sambungan setempat sahaja',
    'database.user.aclAny' => 'Benarkan sambungan jauh dari mana-mana hos',
    'database.user.aclCustom' => 'Benarkan sambungan jauh dari',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nHos yang dinyatakan dibenarkan mengakses pangkalan data bagi pihak pengguna ini.",
    'database.user.remoteAccess' => 'Akses jauh',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nAlamat IP yang dinyatakan dibenarkan untuk mengakses pelayan pangkalan data melalui peraturan firewall. Perubahan anda dalam senarai ini akan menjadi pradisederhanakan oleh penyedia pengehosan anda.",
    'database.user.example' => "Sebagai contoh:\n%%example%%",
    'database.user.denied' => 'Gunakan peraturan sistem tembok api',
    'database.user.allowed' => 'Benarkan sambungan jauh dari',
    'database.user.default' => 'Guna kelayakan pengguna ini secara lalai untuk mengakses %%webadmin%%',
    'database.user.remoteAccessHint' => 'Sila hubungi penyedia pengehosan anda dan pastikan bahawa pilihan yang anda nyatakan di atas akan mematuhi peraturan tembok api terkini untuk akses masuk ke MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Pentadbir Web',
    'database.user.role' => 'Peranan',
    'database.user.roleReadWrite' => 'Baca dan Tulis',
    'database.user.roleWriteOnly' => 'Tulis Sahaja',
    'database.user.roleReadOnly' => 'Baca Sahaja',
    'database.user.roleCustom' => 'Tersuai',

    'database.generalSection' => 'Umum',
    'database.name' => 'Nama pangkalan data',
    'database.server' => 'Pelayan pangkalan data',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Tapak berkaitan',
    'database.noDomainRelations' => 'Tiada tapak berkaitan',
    'database.userSection' => 'Pengguna',
    'database.userSectionDescription' => 'Cipta pengguna pangkalan data lalai. Plesk akan mengakses pangkalan data bagi pihak pengguna ini. Sekiranya tiada pengguna pangkalan data yang ditugaskan kepada pangkalan data, ia tidak boleh diakses.',
    'database.createUser' => 'Cipta pengguna pangkalan data',
    'database.username' => 'Nama pengguna pangkalan data',
    'database.password' => 'Kata laluan',
    'database.passwordConfirmation' => 'Sahkan kata laluan',
    'database.allDbAccess' => 'Pengguna mempunyai akses kepada semua pangkalan data dalam langganan terpilih',
    'database.aclRadio' => 'Kawalan akses',
    'database.aclLocalhost' => 'Benarkan sambungan setempat sahaja',
    'database.aclAny' => 'Benarkan sambungan jauh dari mana-mana hos',
    'database.aclCustom' => 'Benarkan sambungan jauh dari',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nHos yang dinyatakan dibenarkan mengakses pangkalan data bagi pihak pengguna ini.",
    'database.remoteAccess' => 'Akses jauh',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nAlamat IP yang dinyatakan dibenarkan untuk mengakses pelayan pangkalan data melalui peraturan firewall. Perubahan anda dalam senarai ini akan menjadi pradisederhanakan oleh penyedia pengehosan anda.",
    'database.example' => "Sebagai contoh:\n%%example%%",
    'database.denied' => 'Gunakan peraturan sistem tembok api',
    'database.allowed' => 'Benarkan sambungan jauh dari',

    'deployment-section.deploymentDisabledHint' => 'Muat naik fail daripada repositori Git',
    'deployment-section.deploymentEnabledHint' => 'Dayakan sokongan Git',
    'deployment-section.deploymentSectionLegend' => 'Fail Anda yang Akan Disalin ke Pengehosan',
    'deployment-section.deploymentSectionDescriptionHint' => 'Jika anda biarkan sokongan Git dinyahdayakan, direktori akar (akar tapak web/aplikasi dan akar dokumen) akan dicipta kosong dan tapak akan memaparkan halaman lalai dalam pelayar. Anda perlu memuat naik fail tapak anda ke akar dokumen menggunakan FTP atau Pengurus Fail. Secara alternatifnya, dayakan Git sekarang atau kemudian (dalam Tapak web & Domain) dan muat naik fail daripada repositori Git.',

    'dns-zone.add-acl-record.description' => 'Tambah alamat IP pelayan DNS yang dibenarkan untuk menerima salinan zon DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Alamat IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'alamat IP/topeng',

    'dns-zone.record.add-title' => "Tambah rekod sumber pada templat zon.",
    'dns-zone.record.add-ns-title' => "Tambah pelayan nama",
    'dns-zone.record.edit-title' => "Edit rekod sumber",
    'dns-zone.record.edit-success' => "Rekod DNS telah dikemas kini.",
    'dns-zone.record.add-success' => "Rekod DNS telah dibuat.",
    'dns-zone.record.type' => "Jenis rekod",
    'dns-zone.record.domainName' => "Nama domain",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Namakan pelayan",
    'dns-zone.record.protocol' => "Protokol",
    'dns-zone.record.priority' => "Keutamaan",
    'dns-zone.record.priorityLow' => "rendah (%%priority%%)",
    'dns-zone.record.priorityHigh' => "sangat tinggi (%%priority%%)",
    'dns-zone.record.weightLow' => "rendah (%%weight%%)",
    'dns-zone.record.weightHigh' => "sangat tinggi (%%weight%%)",
    'dns-zone.record.ipAddress' => "Alamat IP",
    'dns-zone.record.ipAddressDescription' => "Sebagai contoh, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Sebagai contoh, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Alamat IPv6",
    'dns-zone.record.ipAddressV6Description' => "Sebagai contoh, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Sebagai contoh, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Sebagai contoh, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Sebagai contoh, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Sebagai contoh, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nama canonical",
    'dns-zone.record.mailDomain' => "Domain mel",
    'dns-zone.record.mxServer' => "Pelayan pertukaran mel",
    'dns-zone.record.mxServerPriority' => "Menentukan keutamaan pelayan pertukaran mel",
    'dns-zone.record.txtRecord' => "Rekod TXT",
    'dns-zone.record.txtRecordString' => "Masukkan rentetan rekod",
    'dns-zone.record.txtSpfSyntax' => "Rekod SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Nilai-nilai yang salah untuk rekod TXT telah dinyatakan.",
    'dns-zone.record.quotedTxtRecord' => "Nilai rekod TXT mestilah rentetan tunggal tanpa tanda petikan.",
    'dns-zone.record.dsRecord' => "Rekod DS",
    'dns-zone.record.dsRecordDescription' => "Contohnya, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Nilai yang salah untuk rekod DS telah dinyatakan.",
    'dns-zone.record.serviceName' => "Nama perkhidmatan",
    'dns-zone.record.serviceNameDescription' => 'Contohnya, SIP (tanpa aksara garis bawah).',
    'dns-zone.record.protocolNameDescription' => 'Contohnya, tcp (tanpa aksara garis bawah).',
    'dns-zone.record.portDescription' => 'Contohnya, 25 (tanpa aksara garis bawah).',
    'dns-zone.record.srvWeight' => "Berat relatif bagi rekod dengan keutamaan yang sama",
    'dns-zone.record.targetHost' => "Hos sasaran",
    'dns-zone.record.targetHostDescription' => "Sebagai contoh, contoh.com",
    'dns-zone.record.targetPort' => "Port sasaran",
    'dns-zone.record.targetPortDescription' => 'Sebagai contoh, 8443.',
    'dns-zone.record.retrieveDataError' => "Data rekod tidak ditemui.",
    'dns-zone.record.unknownTypeError' => "Tidak diketahui jenis rekod DNS.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Tidak boleh menyediakan rekod NULL MX sementara rekod NULL MX lain masih wujud.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Tidak boleh menyediakan rekod bukan-NULL MX sementara rekod NULL MX masih wujud.',
    'dns-zone.record.masterShouldBeRemote' => "Anda hendaklah mempunyai dua pelayan nama berwibawa yang berbeza pada hos yang berasingan.",
    'dns-zone.record.caaTag' => "Tag",
    'dns-zone.record.caaRecord' => "Nilai",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokol',
    'dns-zone.record.tlsaUsage' => 'Penggunaan',
    'dns-zone.record.tlsaSelector' => 'Pemilih',
    'dns-zone.record.tlsaMatching' => 'Jenis yang sepadan',
    'dns-zone.record.tlsaCertData' => 'Data persatuan sijil',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Lihat %%link%% untuk butiran',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, bahagian 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, bahagian 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, bahagian 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, bahagian 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "alias (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'For example, example.com. An empty value means the host is the same as the domain name.',
    'dns-zone.record.httpsProtocols' => 'Protocols',
    'dns-zone.record.httpsProtocolsDescription' => 'A comma-separated list of protocols supported by the target. For example, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Force using only the specified protocols. The protocols list above must not be empty.',
    'dns-zone.record.httpsIpv4hint' => 'IPv4 addresses hint',
    'dns-zone.record.httpsIpv4hintDescription' => 'A comma-separated list of IPv4 addresses that can be used by a client to reach the service.',
    'dns-zone.record.httpsIpv6hint' => 'IPv6 addresses hint',
    'dns-zone.record.httpsIpv6hintDescription' => 'A comma-separated list of IPv6 addresses that can be used by a client to reach the service.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Saat",
    'dns-zone.record.invalidValue' => 'Nilai tidak sah. Ia boleh terdiri daripada 1 saat hingga 2147483647 saat.',
    'dns-zone.record.ttlDefaultValue' => 'Nilai lalai: %%value%% saat',
    'dns-zone.record.invalidTTL' => 'Nilai TTL yang ditentukan adalah tidak sah.',
    'dns-zone.record.invalidIpAddress' => 'Alamat IP yang dinyatakan adalah tidak sah.',
    'dns-zone.record.invalidIpMaskPair' => 'Pasangan alamat IP/netmask yang ditentukan adalah tidak sah.',
    'dns-zone.record.invalidCName' => 'Nama kanonik yang ditentukan adalah tidak sah.',
    'dns-zone.record.invalidPort' => 'Port yang ditentukan tidak sah.',
    'dns-zone.record.invalidTLSACertData' => 'Data perkaitan sijil yang ditentukan adalah tidak sah.',
    'dns-zone.record.invalidTLSAProtocol' => 'Protokol yang ditentukan tidak sah.',
    'dns-zone.record.invalidTLSAUsage' => 'Penggunaan yang dinyatakan adalah tidak sah.',
    'dns-zone.record.invalidTLSASelector' => 'Pemilih yang ditentukan adalah tidak sah.',
    'dns-zone.record.invalidTLSAMatching' => 'Jenis padanan yang ditentukan adalah tidak sah.',

    'dns-zone.restore-default.formHint' => "Di sini anda boleh memulihkan zon asal konfigurasi mengikut tetapan templat DNS lalai yang digunakan pada pelayan. Pilih alamat IP yang digunakan untuk memulihkan zon itu dan menentukan sama ada sesuatu alias www diperlukan untuk domain.",
    'dns-zone.restore-default.ipv4' => "Alamat IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Sebagai contoh, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Alamat IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Sebagai contoh, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Alamat IP yang dinyatakan adalah tidak sah.',
    'dns-zone.restore-default.customIpHint' => "Rekod dengan alamat IP ini akan dianggap sebagai 'diubahsuai pengguna' dan tidak akan disegerakkan dengan templat lebar pelayan DNS.",
    'dns-zone.restore-default.wwwPrefix' => "Awalan www",
    'dns-zone.restore-default.previewRecords' => "Pulihkan rekod yang digunakan untuk pratonton tapak",

    'dns-zone.soa-record.soaMnameSection' => 'Pelayan Nama Utama',
    'dns-zone.soa-record.soaMname' => 'Pelayan Nama',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Auto pilih)',
    'dns-zone.soa-record.soaRecordSection' => 'Rekod SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Muat semula',
    'dns-zone.soa-record.retry' => 'Cuba Semula',
    'dns-zone.soa-record.expire' => 'Tamat tempoh',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E-mel (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Alamat e-mel orang yang bertanggungjawab untuk zon DNS domain. Dikembalikan oleh pelayan DNS sebagai tindak balas kepada pertanyaan SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Alamat e-mel pemilik laman web',
    'dns-zone.soa-record.rnameTypeDomain' => 'Alamat e-mel domain',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Masukkan bahagian local sahaja (sebelum @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Alamat e-mel luaran',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Melarang perubahan terhadap RNAME alamat e-mel pada setiap domain',
    'dns-zone.soa-record.invalidValue' => 'Nilai tidak sah. Ia boleh jadi daripada 1 saat hingga 68 tahun.',
    'dns-zone.soa-record.advancedSection' => 'Ciri DNS lanjutan',
    'dns-zone.soa-record.serialNumberFormat' => 'Gunakan format nombor siri yang disarankan oleh IETF dan RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Pilih pilihan jika domain anda menghadapi masalah dengan lulus pemeriksaan SOA pendaftar. Banyak pendaftar domain memerlukan format nombor siri ini.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Gunakan Tetapan Lalai',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Lalai zon',
    'dns-zone.soa-record.unitSeconds' => 'saat',
    'dns-zone.soa-record.unitMinutes' => 'minit',
    'dns-zone.soa-record.unitHours' => 'jam',
    'dns-zone.soa-record.unitDays' => 'hari',
    'dns-zone.soa-record.unitWeeks' => 'minggu',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Segar semula nilai Selang masa adalah kurang dari satu jam, yang boleh meningkatkan secara kritikal oleh trafik pelayan dan penggunaan sumber.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Menetapkan nilai Minimum TTL yang lebih daripada 3 jam boleh membuat domain anda tidak boleh diakses untuk beberapa pentadbir domain. Ia adalah disarankan untuk menetapkan apa-apa nilai hanya jika pendaftar nama domain anda menegaskan padanya.',
    'dns-zone.soa-record.success' => 'Sifat rekod SOA telah dikemas kini.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Rekod SOA lalai telah dipulihkan.',

    'domain-info-section.domainName' => 'Nama domain',
    'domain-info-section.emptyDomainName' => 'Sila berikan nama domain.',
    'domain-info-section.ipAddress' => 'Alamat IP',
    'domain-info-section.shared' => 'kongsi',
    'domain-info-section.exclusive' => 'khusus',
    'domain-info-section.ipAddressHint' => "Alamat IP tempat tapak web dihoskan adalah alamat rangkaian bagi hos maya tapak web. Alamat IP akan digunakan untuk semua tapak web yang dicipta dalam tempoh langganan.",
    'domain-info-section.ipAddressHint_powerUser' => "Alamat IP tempat tapak web dihoskan adalah alamat rangkaian bagi hos maya tapak web. Alamat IP akan digunakan untuk semua tapak web yang dicipta dalam ruang web itu.",
    'domain-info-section.userName' => 'Nama pengguna',
    'domain-info-section.userNameHint' => 'Sistem akaun pengguna yang dikaitkan dengan ruang web, digunakan untuk mengakses fail yang dihoskan melalui FTP dan SSH.',
    'domain-info-section.emptyLogin' => 'Sila berikan nama pengguna.',
    'domain-info-section.password' => 'Kata laluan',
    'domain-info-section.emptyPassword' => 'Sila berikan kata laluan.',
    'domain-info-section.passwordConfirmation' => 'Ulang kata laluan',

    'email-address.generalTab' => 'Umum',
    'email-address.generalHint' => 'Jika akaun e-mel ini dikaitkan dengan pengguna tambahan (Akses kepada Panel Pelanggan didayakan), perubahan yang anda buat pada halaman ini menjejaskan tetapan pengguna ini. Terutama sekali, sekiranya anda menukar alamat e-mel dan kata laluan, log masuk dan kata laluan pengguna tambahan turut akan ditukar kepada nilai baru.',
    'email-address.redirectTab' => 'Pemajuan',
    'email-address.redirectHint' => 'Sediakan penghantaran mesej e-mel ke satu atau lebih alamat e-mel.',
    'email-address.aliasesTab' => 'Alias E-mel',
    'email-address.autoResponderTab' => 'Autobalas',
    'email-address.antispamTab' => 'Penapis Spam',
    'email-address.autoResponderHint' => 'Sediakan respons automatik kepada mana-mana mesej e-mel yang akan masuk ke alamat e-mel anda. Autobalas adalah standard yang bermakna untuk memberitahu pewarta anda bahawa anda berada di luar pejabat atau bercuti.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Alamat e-mel',
    'email-address.externalEmail' => 'Alamat e-mel luaran',
    'email-address.externalEmailHint' => 'Akan digunakan untuk menetapkan semula kata laluan jika anda hilang akses ke alamat e-mel utama.',
    'email-address.user' => 'Ditugaskan untuk',
    'email-address.password' => 'Kata laluan',
    'email-address.passwordConfirmation' => 'Sahkan kata laluan',
    'email-address.responderEnable' => 'Hidupkan autobalas',
    'email-address.responderSubject' => 'Subjek mesej autobalas',
    'email-address.responderContentType' => 'Format mesej',
    'email-address.responderContentTypeHint' => 'Format teks biasa yang disokong oleh semua program klien mel, oleh itu, semua penerima akan melihat mesej dengan cara yang sama seperti yang anda lihatnya. Mesej HTML kelihatan lebih baik kerana mereka benarkan anda memasukkan teks yang diformatkan dengan gaya fon yang berbeza. Walau bagaimanapun, sesetengah klien mel tidak menyokong mesej HTML dan beberapa penerima tidak boleh melihat teks yang diformat.',
    'email-address.responderContentTypeTextPlain' => 'Teks biasa',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Pengekodan',
    'email-address.responderCodepageHint' => 'Pengekodan mentakrifkan bagaimana aksara teks dipaparkan. Pengekodan yang disarankan adalah UTF-8.',
    'email-address.responderReplyTo' => 'Majukan kepada',
    'email-address.responderReplyToHint' => 'Apabila tindak balas respons automatik yang dihantar, mesej yang asal akan dimajukan ke alamat e-mel yang dinyatakan.',
    'email-address.responderForwardAddress' => 'Majukan kepada',
    'email-address.responderForwardAddressHint' => 'Apabila tindak balas respons automatik yang dihantar, mesej yang asal akan dimajukan ke alamat e-mel yang dinyatakan.',
    'email-address.responderMessage' => 'Mesej teks autobalas',
    'email-address.responderReplyToEqualsEmail' => 'Alamat pemajuan yang dinyatakan adalah sama seperti alamat e-mel ini.',
    'email-address.responderForwardAddressEqualsEmail' => 'Alamat pemajuan yang dinyatakan adalah sama seperti alamat e-mel ini.',
    'email-address.responderReplyLimit' => 'Hantar respons automatik kepada alamat e-mel yang unik tidak lebih daripada (kali sehari)',
    'email-address.buttonAddResponderAttachment' => 'Tambahkan lampiran',
    'email-address.buttonRemoveResponderAttachment' => 'Alih keluar',
    'email-address.responderAttachment' => 'Lampirkan fail',
    'email-address.redirectEnable' => 'Hidupkan mel pemajuan',
    'email-address.redirectRemoveEnable' => 'Jangan menghantar salinan e-mel yang dihantar ke peti mel Plesk',
    'email-address.redirectAddress' => 'Majukan mesej masuk ke alamat e-mel berikut',
    'email-address.redirectAddressHint' => 'Nyatakan alamat e-mel. Anda boleh menaip setiap alamat pada baris baru, atau alamat berasingan dengan ruangan putih, koma atau koma bertitik.',
    'email-address.role' => 'Peranan pengguna',
    'email-address.roleHint' => 'Peranan pengguna memberikan pengguna keistimewaan pentadbiran dan akses ke aplikasi yang dipilih anda untuk peranannya.',
    'email-address.errorRedirectAddress' => 'Anda menyatakan alamat e-mel yang tidak sah: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Anda menyatakan alamat e-mel yang tidak sah: %value%.',
    'email-address.mailAlias' => "Alias e-mel",
    'email-address.mailAliasNone' => 'Tiada',
    'email-address.mailAliasHint' => "Alias e-mel adalah alamat e-mel alternatif yang berkaitan dengan alamat e-mel utama. Semua mel yang dihantar kepada alias e-mel akan diterima oleh alamat e-mel utama.",
    'email-address.buttonAddMailAlias' => 'Tambah alias e-mel',
    'email-address.buttonRemoveMailAlias' => 'Alih keluar',
    'email-address.emptyEmail' => 'Nyatakan alamat e-mel yang semua mesej masuk hendaklah dimajukan.',
    'email-address.emailsIsEqual' => 'Alamat e-mel luaran sepadan dengan yang utama. Nyatakan alamat e-mel luaran yang lain.',
    'email-address.emptyPassword' => 'Anda perlu menyediakan kata laluan.',
    'email-address.emptyPasswordConfirmation' => 'Anda perlu mengesahkan kata laluan.',
    'email-address.emptyAlias' => "Nyatakan alias e-mel untuk alamat e-mel ini.",
    'email-address.aliasEqualsEmail' => 'Alias e-mel yang dinyatakan adalah sama seperti alamat e-mel.',
    'email-address.passwordHint' => 'Akan digunakan untuk mengakses peti mel dan untuk log masuk ke dalam Plesk (sekiranya pilihan berkaitan didayakan).',
    'email-address.cyclicRedirect' => 'Alamat e-mel tidak boleh disediakan untuk majukan mesej e-mel kepada dirinya.',
    'email-address.errorMailnameReserved' => 'Alamat e-mel yang dinyatakan telah pun digunakan.',
    'email-address.antivirusEnable' => 'Hidupkan perlindungan antivirus untuk alamat e-mel ini',
    'email-address.antivirusHint' => 'Perkhidmatan antivirus menyekat e-mel mesej yang mengandungi virus dan memberitahu kedua-dua penghantar dan penerima mengenainya.',
    'email-address.antivirusSettings' => 'Semak untuk virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'hanya mel masuk',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'hanya mel keluar',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'mel masuk dan keluar',
    'email-address.antispamHint' => 'Perkhidmatan penapisan spam mengesan mesej spam yang dihantar ke alamat e-mel. Anda boleh menetapkan penapis spam untuk memadam mesej spam, menandakannya sebagai spam dengan mengubah subjeknya, atau mengalihkannya ke capaian folder spam khas oleh klien mel melalui IMAP. Penapis spam menggunakan pelbagai jenis ujian setempat dan rangkaian untuk mengenalpasti tandatangan spam.',
    'email-address.antispamEnable' => 'Hidupkan penapisan spam untuk alamat e-mel ini',
    'email-address.antispamSettings' => 'Apa yang perlu dilakukan dengan mesej yang dikelaskan sebagai spam',
    'email-address.antispamSettingsMark' => 'Tandakan mesej spam dengan menambah teks berikut ke subjek mesej',
    'email-address.antispamSettingsMarkHint' => 'Tinggalkan medan ini kosong jika anda tidak mahu menambah apa-apa teks. Taipkan _SCORE_ jika anda ingin memasukkan skor dalam subjek mesej.',
    'email-address.antispamReportTextHint' => 'Taipkan teks yang anda mahu untuk menambah ke kandungan mesej e-mel spam.',
    'email-address.antispamSettingsDelete' => 'Padam semua mesej spam',
    'email-address.antispamSettingsDeleteHint' => 'Mesej Spam akan dipadam dari peti mel anda.',
    'email-address.antispamSettingsMove' => 'Alih spam ke folder Spam',
    'email-address.antispamSettingsMoveHint' => 'Alihkan semua mesej spam ke folder yang dipanggil Spam. Folder ini boleh dicapai dari program klien mel atau mel web. Jika anda menggunakan akaun mel IMAP, maka anda boleh menggunakan folder Spam untuk melatih penapis spam.',
    'email-address.antispamSettingsMoveWarning' => '"Pindahkan spam ke folder Spam" tidak akan berfungsi melainkan anda menyahdayakan pilihan "Jangan hantar salinan e-mel yang diteruskan" pada tab "Pemajuan".',
    'email-address.antispamSettingsMoveJunk' => 'Alih spam ke folder "E-mel Sarap"',
    'email-address.antispamSettingsMoveJunkHint' => 'Alihkan semua mesej spam ke folder yang dipanggil "E-mel Sarap". Folder ini boleh dicapai dari program klien mel atau mel web. Jika anda menggunakan akaun mel IMAP, maka anda boleh menggunakan folder "E-mel Sarap" untuk melatih penapis spam.',
    'email-address.antispamShowAdvancedSection' => 'Tunjukkan Tetapan Lanjutan',
    'email-address.antispamHideAdvancedSection' => 'Sembunyikan Tetapan Lanjutan',
    'email-address.antispamLearnMore' => 'Ketahui bagaimana untuk melatih penapis spam.',
    'email-address.antispamFilterScoreTitle' => 'Kepekaan Penapis',
    'email-address.antispamFilterScoreHint' => 'Penapis spam melakukan beberapa ujian yang berbeza pada kandungan dan baris subjek bagi setiap mesej. Akibatnya, setiap mesej mendapat beberapa mata. Semakin tinggi nombor mesej, semakin berkemungkinan adalah spam. Secara lalai, kepekaan penapis ditetapkan supaya semua mesej yang mendapat 7 atau lebih mata dikelaskan sebagai spam. Jika anda menerima banyak mesej spam dengan tetapan semasa untuk membuatkan penapis lebih peka, cuba tetapkan nilai yang lebih kecil, sebagai contoh, 6. Jika e-mel anda hilang kerana penapis spam anda fikir ia adalah remeh, cuba kurangkan kepekaan penapis dengan tetapan nilai yang lebih tinggi, sebagai contoh, 8.',
    'email-address.antispamFilterScore' => 'Kepekaan penapis spam',
    'email-address.antispamWhiteListTitle' => 'Senarai Putih',
    'email-address.antispamWhiteListHint' => 'E-mel daripada penghantar dalam senarai putih tidak akan diperiksa oleh penapis spam.',
    'email-address.antispamWhiteListField' => 'Senarai putih',
    'email-address.antispamWhiteListFieldHint' => 'Taip nama domain, satu nama domain setiap baris. Alamat boleh mengandungi "*" dan "?" aksara kad bebas, sebagai contoh, *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Senarai Hitam',
    'email-address.antispamBlackListHint' => 'E-mel daripada penghantar dalam senarai hitam akan diklasifikasikan sebagai spam.',
    'email-address.antispamBlackListField' => 'Senarai hitam',
    'email-address.antispamBlackListFieldHint' => 'Taip nama domain, satu domain bagi setiap baris. Alamat boleh mengandungi "*" dan "?" aksara kad bebas, sebagai contoh, *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Bahasa yang Dipercayai',
    'email-address.antispamTrustedLanguagesHint' => 'Mesej e-mel yang ditulis dalam bahasa ini akan sentiasa melepasi penapis.',
    'email-address.antispamTrustedLocalesTitle' => 'Penempatan yang Dipercayai',
    'email-address.antispamTrustedLocalesHint' => 'Mesej e-mel yang menggunakan kumpulan setempat yang dinyatakan akan sentiasa melepasi penapis. Kumpulan setempat termasuklah yang paling biasa menggunakan tetapkan aksara. Sebagai contoh, set aksara Barat termasuklah pengekodan bagi surat yang digunakan dalam bahasa Inggeris dan bahasa Eropah Barat.',
    'email-address.antispamTrustedNetworksTitle' => 'Rangkaian yang Dipercayai',
    'email-address.antispamTrustedNetworksHint' => 'Hos geganti pada rangkaian yang dipercayai dianggap tidak akan berpotensi untuk dikendalikan oleh penghantar spam, dan mereka bukan geganti terbuka atau proksi terbuka.',
    'email-address.antispamIpAddressesField' => 'Alamat IP',
    'email-address.antispamIpAddressesFieldHint' => 'Tentukan rangkaian alamat IP dan topeng.',
    'email-address.mailBoxQuotaDomainDefault' => 'Saiz lalai (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Saiz lalai',
    'email-address.mailBoxOutgoingMessages' => 'Bilangan maksimum mesej e-mel keluar',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Lalai (%%domainOutgoingMessages%% mesej sejam)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Nilai tersuai untuk peti mel',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'mesej',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Lalai',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Saiz lalai',
    'email-address.mailBoxQuotaDomainSpecific' => 'Saiz yang lain',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Saiz peti mel',
    'email-address.mailBoxQuotaUnlimited' => 'Tidak terhad',
    'email-address.mailBoxLimitReached' => 'Had pada bilangan peti mel telah dicapai.',
    'email-address.postboxEnabled' => 'Peti Mel',
    'email-address.postboxEnabledYes' => 'Hidup',
    'email-address.postboxEnabledNo' => 'Mati',
    'email-address.description' => 'Perihalan dalam Plesk',
    'email-address.descriptionHint' => 'Perihalan boleh dilihat oleh semua orang yang mempunyai akses kepada akaun e-mel ini.',
    'email-address.longDescription' => 'Perihalan yang dinyatakan terlalu panjang. Ia tidak boleh lebih panjang daripada simbol %%max%%.',
    'email-address.loginAsUser' => 'Boleh digunakan untuk log masuk ke Plesk',
    'email-address.loginAsUserDescription' => '(nama pengguna: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Saiz peti mel tidak boleh melebihi saiz lalai.',
    'email-address.endDateEnable' => 'Matikan auto balas pada',

    'failed-request.enable-tracing.description' => 'Penyurihan permintaan yang gagal adalah operasi intensif-sumber. Penyurihan akan dihentikan secara automatik dalam %%days%% hari. Anda boleh menghentikannya secara manual pada bila-bila masa.',
    'failed-request.enable-tracing.statusCodes' => 'Kod status',
    'failed-request.enable-tracing.statusCodesDescription' => 'Contoh: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Pembekal',

    'file-manager.show.buttonReload' => 'Muat semula',
    'file-manager.show.buttonSave' => 'Simpan',
    'file-manager.show.buttonSaveAs' => 'Simpan sebagai',
    'file-manager.show.buttonReset' => 'Tetapkan Semula',
    'file-manager.show.buttonTextCodeEditor' => 'Edit dalam Editor Kod',
    'file-manager.show.buttonTextEdit' => 'Edit dalam Editor Teks',
    'file-manager.show.buttonWysiwygEdit' => 'Edit dalam Editor HTML',
    'file-manager.show.eolLabel' => 'Jenis garis pemisah:',
    'file-manager.show.saveAs' => 'Simpan sebagai:',
    'file-manager.show.saveCodepage' => 'Simpan di dalam pengekodan berikut:',
    'file-manager.show.loadCodepage' => 'Paparkan fail asal dalam pengekodan yang berikut:',
    'file-manager.show.loadCodepageHint' => 'Amaran: Mana-mana perubahan yang tidak disimpan akan hilang apabila memuatkan semula fail.',
    'file-manager.show.fileExists' => "Fail atau folder %%fileName%% telah wujud. Anda tidak boleh mempunyai satu folder dan satu fail dengan nama yang sama.",
    'file-manager.show.popupTitle' => 'Simpan sebagai',
    'file-manager.show.popupFilename' => 'Nama fail:',

    'file-manager.permissions.filePermissions' => 'Kebenaran fail',
    'file-manager.permissions.directoryPermissions' => 'Kebenaran direktori',
    'file-manager.permissions.buttonSubmit' => 'Simpan',
    'file-manager.permissions.buttonApply' => 'Simpan dan sambung semula',
    'file-manager.permissions.buttonCancel' => 'Batal',
    'file-manager.permissions.buttonAdvanced' => 'Lanjutan',

    'file-manager.unix-file-permissions.group' => 'Kumpulan',
    'file-manager.unix-file-permissions.owner' => 'Pemilik',
    'file-manager.unix-file-permissions.others' => 'Lain',
    'file-manager.unix-file-permissions.readMode' => 'Baca',
    'file-manager.unix-file-permissions.writeMode' => 'Tulis',
    'file-manager.unix-file-permissions.execMode' => 'Laksanakan/carian',
    'file-manager.unix-file-permissions.changeRecursive' => 'Tukar kebenaran secara berulang',

    'file-manager.windows-permissions.allow' => 'Benarkan',
    'file-manager.windows-permissions.deny' => 'Tolak',
    'file-manager.windows-permissions.inheritFromParent' => 'Benarkan kebenaran diwarisi daripada ibu atau bapa untuk merambat kepada objek ini dan semua objek anak. Sertakan dengan entri secara jelas yang ditakrifkan di sini',
    'file-manager.windows-permissions.replaceOnChildren' => 'Gantikan penyertaan kebenaran pada semua objek anak dengan entri yang dipaparkan di sini',
    'file-manager.windows-permissions.buttonAdvanced' => 'Lanjutan',
    'file-manager.windows-permissions.applyTo' => 'Memohon kepada:',
    'file-manager.windows-permissions.folderOnly' => 'Hanya folder ini',
    'file-manager.windows-permissions.subfolderOnly' => 'Subfolder sahaja',
    'file-manager.windows-permissions.filesOnly' => 'Hanya fail',
    'file-manager.windows-permissions.permissionsFor' => 'Kebenaran untuk',
    'file-manager.windows-permissions.applyOnto1' => 'Hanya folder ini',
    'file-manager.windows-permissions.applyOnto2' => 'Subfolder sahaja',
    'file-manager.windows-permissions.applyOnto3' => 'Folder dan subfolder ini',
    'file-manager.windows-permissions.applyOnto4' => 'Hanya fail',
    'file-manager.windows-permissions.applyOnto5' => 'Folder dan fail ini',
    'file-manager.windows-permissions.applyOnto6' => 'Subfolder dan fail sahaja',
    'file-manager.windows-permissions.applyOnto7' => 'Folder, subfolder dan fail ini',
    'file-manager.windows-permissions.notInherited' => '<tiada warisan>',

    'file-manager.editor.titleTextEditor' => 'Editor Teks',
    'file-manager.editor.titleCodeEditor' => 'Editor Kod',
    'file-manager.editor.titleCodeViewer' => 'Lihat',
    'file-manager.editor.buttonSubmit' => 'Simpan',
    'file-manager.editor.buttonApply' => 'Simpan dan sambung semula',
    'file-manager.editor.buttonSaveAs' => 'Simpan sebagai ...',
    'file-manager.editor.buttonCancel' => 'Batal',
    'file-manager.editor.exitConfirmationYes' => 'Ya',
    'file-manager.editor.exitConfirmationNo' => 'Tidak',
    'file-manager.editor.fileOverwrite' => 'Fail sudah wujud.',
    'file-manager.editor.fileOverwriteDescription' => 'Fail dengan nama yang sama telah wujud. Anda ingin untuk menulis gantinya?',
    'file-manager.editor.exitConfirmation' => 'Adakah anda pasti ingin menutup fail dan membuang perubahan yang belum disimpan?',
    'file-manager.editor.buttonCodeEditor' => 'Edit dalam Editor Kod',
    'file-manager.editor.buttonTextEditor' => 'Edit dalam Editor Teks',
    'file-manager.editor.buttonHtmlEditor' => 'Edit dalam Editor HTML',

    'file-manager.import-file.buttonSubmit' => 'Import',
    'file-manager.import-file.fieldUrl' => 'URL untuk fail',
    'file-manager.import-file.fieldUrlDescription' => 'Tentukan URL sumber, contohnya, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Corak URL lengkap adalah seperti berikut: \'https://user:password@example.com/example.tgz\'. Nama pengguna dan kata laluan adalah pilihan. Protokol yang disokong adalah http, https, ftp, ftps. Gunakan pengekodan URL untuk bahagian URL yang mengandungi aksara khas atau ruang.',
    'file-manager.import-file.failure' => 'Tidak dapat mengimport fail.',

    'file-manager.rotation-settings.title' => 'Tetapan Putaran Tong Kitar Semula',
    'file-manager.rotation-settings.rotationBySize' => 'Putaran mengikut saiz',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Pilihan memadam fail baharu selagi had yang ditentukan untuk tong kitar semula melebihi.',
    'file-manager.rotation-settings.rotationByDate' => 'Putaran mengikut tarikh',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Hari',
    'file-manager.rotation-settings.rotationByDateHint' => 'Pilihan ini memadamkan fail yang disimpan di tong kitar semula selama lebih dari jumlah hari yang ditentukan.',
    'file-manager.rotation-settings.save' => 'Simpan',
    'file-manager.rotation-settings.cancel' => 'Batal',

    'ftp-user.description' => 'Jika anda bekerja di tapak web anda bersama-sama dengan orang lain atau subdomain hos untuk pengguna lain, anda mungkin mahu mencipta akaun FTP berasingan untuk mereka.',
    'ftp-user.generalSection' => 'Umum',
    'ftp-user.login' => 'Nama akaun FTP',
    'ftp-user.home' => 'Direktori rumah',
    'ftp-user.systemArea' => 'Cipta akaun FTP dengan akses ke fail luar direktori rumah',
    'ftp-user.password' => 'Kata laluan',
    'ftp-user.passwordConfirmation' => 'Sahkan kata laluan',
    'ftp-user.hardQuotaSection' => 'Kuota cakera keras',
    'ftp-user.hardQuota' => 'Kuota cakera keras',
    'ftp-user.hardQuotaUnlimited' => 'Tidak terhad',
    'ftp-user.permissionsSection' => 'Kebenaran',
    'ftp-user.permissionRead' => 'Baca kebenaran',
    'ftp-user.permissionWrite' => 'Tulis kebenaran',
    'ftp-user.popupTitle' => 'Pilih Direktori',

    'mail-list.listName' => 'Senarai alamat mel',
    'mail-list.enabled' => 'Dihidupkan',
    'mail-list.administratorEmail' => 'Senarai mel, e-mel pentadbir',
    'mail-list.password' => 'Kata laluan',
    'mail-list.passwordConfirmation' => 'Sahkan kata laluan',
    'mail-list.subscribers' => 'Pelanggan',
    'mail-list.subscribersHint' => 'Nyatakan alamat e-mel. Anda boleh menaip setiap alamat pada baris baru atau alamat berasingan dengan simbol ruang, koma, atau koma bertitik.',
    'mail-list.notify' => 'Beritahu pentadbir tentang penciptaan senarai mel',
    'mail-list.emptyPassword' => 'Sediakan kata laluan.',
    'mail-list.emptyPasswordConfirmation' => 'Sila sahkan kata laluan.',
    'mail-list.errorSubscribers' => 'Alamat e-mel tidak sah: %value%.',
    'mail-list.errorMaillistReserved' => 'Senarai alamat mel yang dinyatakan sedang digunakan.',

    'mail-settings.hint' => 'Ini adalah di mana anda boleh mengubah tetapan perkhidmatan mel untuk domain ini.',
    'mail-settings.service' => 'Perkhidmatan mel pada domain ini',
    'mail-settings.nonExist' => 'Apa yang perlu dilakukan dengan mel untuk pengguna yang tidak wujud',
    'mail-settings.nonExistBounceWithMessage' => 'Lantun dengan mesej',
    'mail-settings.nonExistBounce' => 'Lantunan',
    'mail-settings.nonExistCatch' => 'Majukan ke alamat',
    'mail-settings.nonExistCatchDescription' => 'Alamat yang harus dimiliki oleh domain yang dipilih. Hanya pentadbir boleh menentukan alamat luaran atau satu alamat untuk beberapa domain.',
    'mail-settings.nonExistExternal' => 'Halakan semula ke pelayan mel luaran dengan alamat IP',
    'mail-settings.nonExistReject' => 'Tolak',
    'mail-settings.nonExistDiscard' => 'Tolak',
    'mail-settings.webmail' => 'Mel web',
    'mail-settings.webmailNone' => 'Tiada',
    'mail-settings.webmailComponentNotInstalled' => 'Komponen mel web tidak dipasang.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Terdapat subdomain dengan nama %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Sijil SSL/TLS untuk mel web',
    'mail-settings.webmailCertificateNone' => 'Tidak dipilih',
    'mail-settings.mailCertificate' => 'Sijil SSL/TLS untuk mel',
    'mail-settings.mailCertificateNone' => 'Tidak dipilih',
    'mail-settings.serverCertificateNotSelected' => 'Sijil telah diberikan, tetapi mel untuk domain tidak dilindungi. Bagi menyelesaikan perlindungan mel untuk domain, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'lindungi pelayan mel',
    'mail-settings.mailLists' => 'Mendayakan senarai mel',
    'mail-settings.mailAutodiscovery' => 'Dayakan auto-penemuan mel',
    'mail-settings.mailAutodiscoveryDescription' => 'Lihat bagaimana ia berfungsi dalam %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'pangkalan pengetahuan',
    'mail-settings.domainKeys' => 'Gunakan sistem perlindungan spam DKIM untuk menandatangani mesej e-mel keluar',
    'mail-settings.activeDkimSelector' => 'Pemilih DKIM aktif',
    'mail-settings.defaultDkimSelector' => ' (Plesk Lalai)',
    'mail-settings.dkimSelectorName' => 'Nama pemilih',
    'mail-settings.buttonCreateSelector' => 'Buat Pemilih DKIM Baharu',
    'mail-settings.createSelectorDialogTitle' => 'Buat Pemilih DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Alih keluar Pemilih DKIM',
    'mail-settings.removeSelectorConfirmation' => "Alih keluar pemilih '%%selector%%' bersama kunci yang berkaitan dan rekod DNS?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Cipta',
    'mail-settings.buttonCancel' => 'Batal',
    'mail-settings.labelRemoveSelector' => 'Alih keluar',
    'mail-settings.labelActiveSelector' => 'Aktif',
    'mail-settings.greyListing' => 'Hidupkan perlindungan spam greylisting untuk semua akaun mel di bawah domain ini',
    'mail-settings.howToConfigureExternalDns' => 'Cara mengkonfigurasi DNS luaran',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Untuk mendayakan penandatanganan DKIM jika anda menggunakan pelayan DNS luaran, anda perlu mengkonfigurasi sendiri rekod DNS DKIM pada pelayan DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Untuk melakukannya, gunakan rekod DNS DKIM di bawah:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Sekiranya anda mempunyai alias domain yang anda gunakan untuk menghantar mel, tambahkan rekod DNS DKIM untuk mereka juga. Gunakan rekod yang sama seperti domain utama tetapi dengan nama alias domain.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Untuk melihat rekod DNS DKIM yang perlu anda konfigurasi, pilih kotak semak "%%option%%", gunakannya dan buka mesej timbul ini sekali lagi.',
    'mail-settings.mailServiceDisabled' => 'Dinyahdayakan',
    'mail-settings.mailServiceDisabledIncoming' => 'Dilumpuhkan untuk mel masuk',
    'mail-settings.mailServiceDisabledHint' => 'Plesk tidak akan menyediakan sebarang perkhidmatan mel pada domain ini.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Domain ini hanya boleh menghantar mel dan hanya menggunakan Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Didayakan',
    'mail-settings.mailServiceEnabledHint' => 'Domain ini boleh menghantar dan menerima mel.',
    'mail-settings.mailServiceNotConfigured' => 'Tidak dikonfigurasikan',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk tidak akan menyediakan sebarang perkhidmatan mel pada domain ini.',
    'mail-settings.warning' => 'Ini akan mengalih keluar peti mel domain dengan semua e-mel yang diterima dan dihantar secara kekal.',
    'mail-settings.show.title' => 'Alih keluar semua peti mel dan e-mel %%domain%%',
    'mail-settings.show.checkbox' => 'Alih keluar semua peti mel <b>%%domain%%</b> secara kekal, termasuk e-mel yang diterima dan dihantar.',

    'role.roleSection' => 'Umum',
    'role.name' => 'Nama peranan pengguna',
    'role.description' => 'Perihalan',
    'role.generalPermissionsSection' => 'Akses ke perkhidmatan Plesk',
    'role.applicationsAccessSection' => 'Akses ke aplikasi',
    'role.permissionAllow' => 'Diberikan',
    'role.permissionDeny' => 'Ditolak',
    'role.emptyRoleName' => 'Sila berikan nama peranan.',
    'role.installedAt' => 'Dipasang pada',
    'role.noInstallationUrlAvailable' => 'Aplikasi luaran',
    'role.invalidRoleName' => 'Nama peranan pengguna yang dinyatakan tidak sah. Tanda tanya dan tanda petikan tidak boleh digunakan dalam nama peranan.',
    'role.longRoleName' => 'Nama peranan pengguna yang dinyatakan terlalu panjang.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Sesetengah operasi mungkin tidak tersedia atas sebab-sebab berikut: kebenaran untuk operasi tidak diberikan dengan langganan yang dipilih, atau jumlah sumber yang diperuntukkan adalah tidak cukup untuk melaksanakan operasi.',
    'role.servicesPermissionsDescription' => 'Takrifkan akses kepada aplikasi yang dipasang atau perkhidmatan Plesk untuk semua pengguna dengan peranan ini. Jika anda memberikan akses pengguna kepada apl, apl itu akan tersedia untuk mereka di Panel Pelanggan.',
    'role.emailActivation' => 'Aktifkan peranan ini akaun ini melalui e-mel',

    'service.admin-access.adminAccess' => 'Akses Pentadbiran',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Kelayakan ini akan digunakan untuk akses pentadbiran bagi permohonan ini.',
    'service.admin-access.login' => 'Nama pengguna pentadbiran',
    'service.admin-access.password' => 'Kata laluan pentadbiran',
    'service.admin-access.passwordConfirmation' => 'Sahkan kata laluan',

    'service.info.service-entry-point.availableAt' => 'Boleh didapati di',
    'service.info.service-entry-point.customize' => 'Suaikan pintasan',
    'service.info.service-entry-point.displayNameLabel' => 'Nama pintasan',
    'service.info.service-entry-point.displayNameDescription' => 'Berikan nama untuk pintasan ini. Nama ini ditunjukkan di bawah ikon pintasan. Pintasan diletakkan pada halaman Perkhidmatan Saya bagi pengguna yang telah diberikan akses untuk permohonan ini.',
    'service.info.service-entry-point.descriptionLabel' => 'Perihalan pintasan',
    'service.info.service-entry-point.descriptionDescription' => 'Sediakan perihalan bagi pintasan ini. Perihalan ditunjukkan sebagai petua alat apabila hover kursor tetikus melalui pintasan.',
    'service.info.service-entry-point.iconLabel' => 'Klik untuk pilih ikon pintasan',
    'service.info.service-entry-point.iconCurrent' => 'Arca Semasa',
    'service.info.service-entry-point.errorEmptyName' => 'Anda perlu memberikan nama pintasan',
    'service.info.service-entry-point.errorLongName' => 'Nama pintasan haruslah antara 1 dan 255 aksara.',
    'service.info.service-entry-point.errorLongDescription' => 'Perihalan pintasan harus antara 0 dan 255 aksara.',
    'service.info.service-entry-point.hiddenLabel' => 'Sembunyikan pintasan',
    'service.info.service-entry-point.hiddenDescription' => 'Jangan tunjukkan pintasan ini kepada pengguna.',

    'service.info.service-permission.assignedUser' => "Berikan akses pentadbir untuk pengguna ini",
    'service.info.service-permission.assignedUserNone' => 'Tiada pengguna ditugaskan',

    'shared-ssl.master-ssl.switchedOn' => 'Hidupkan SSL/TLS yang dikongsi',
    'shared-ssl.master-ssl.domainName' => 'Nama domain tapak yang akan berkongsi sijil SSL/TLS di kalangan laman lain',
    'shared-ssl.master-ssl.none' => 'Tiada',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'SSL/TLS yang dikongsi tidak boleh dihidupkan kerana tiada domain dengan sokongan SSL/TLS yang didayakan.',

    'user.email.email' => 'Alamat e-mel',
    'user.email.emptyEmail' => 'Anda perlu berikan alamat e-mel.',
    'user.email.internalEmailHint' => 'Mencipta alamat e-mel baharu dalam Plesk atau gunakan alamat e-mel luaran.',
    'user.email.longInternalEmail' => 'Alamat emel terlalu panjang.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Bahagian nama pengguna bagi alamat emel terlalu panjang untuk pelayan mel ini. Sila tentukan nama pengguna yang panjangnya tidak lebih dari simbol %%max%%.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Alamat emel terlalu panjang untuk pelayan mel ini. Sila tentukan alamat yang panjangnya tidak lebih dari simbol %%max%%.',
    'user.email.externalEmail' => 'Alamat e-mel luaran',
    'user.email.externalEmailHint' => 'Akan digunakan untuk menetapkan semula kata laluan jika anda hilang akses ke alamat e-mel utama.',
    'user.email.emailsIsEqual' => 'Alamat e-mel luaran sepadan dengan yang utama. Nyatakan alamat e-mel luaran yang lain.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Sila nyatakan sama ada alamat e-mel dalaman atau luaran.',

    'user.profileSection' => 'Maklumat Umum',
    'user.contactName' => 'Nama kenalan',
    'user.email' => 'Alamat e-mel',
    'user.role' => 'Peranan pengguna',
    'user.accountSection' => 'Keutamaan Plesk',
    'user.login' => 'Nama pengguna',
    'user.password' => 'Kata laluan',
    'user.oldPassword' => 'Kata laluan lama',
    'user.buttonBack' => 'Kembali',
    'user.generalTab' => 'Umum',
    'user.applicationsAccessSection' => 'Perkhidmatan',
    'user.generalPermissionsSection' => 'Keistimewaan',
    'user.contactsTab' => 'Butiran Kenalan',
    'user.passwordConfirmation' => 'Sahkan kata laluan',
    'user.internalEmailPasswordChanged' => 'Mengubah kata laluan juga akan mengubah kata laluan alamat e-mel dalaman.',
    'user.emailName' => 'Alamat e-mel',
    'user.emailType' => 'Jenis e-mel',
    'user.companyName' => 'Nama syarikat',
    'user.phone' => 'Nombor telefon',
    'user.imNumber' => 'Mesej segera',
    'user.fax' => 'Nombor faks',
    'user.address' => 'Alamat',
    'user.city' => 'Bandar',
    'user.state' => 'Negeri atau wilayah',
    'user.zip' => 'Poskod atau kod ZIP',
    'user.country' => 'Negara',
    'user.additionalInfo' => 'Maklumat tambahan',
    'user.additionalInfoHint' => 'Teks biasa sahaja: Semua tag HTML akan diabaikan.',
    'user.language' => 'Bahasa Plesk',
    'user.buttonChangePassword' => 'Tukar Kata Laluan',
    'user.permissionAllow' => 'Diberikan',
    'user.permissionDeny' => 'Ditolak',
    'user.permissionInherited' => 'Ditakrifkan melalui peranan',
    'user.emptyContactName' => 'Anda perlu berikan nama kenalan.',
    'user.emptyLogin' => 'Anda perlu berikan nama pengguna.',
    'user.emptyPassword' => 'Anda perlu menyediakan kata laluan.',
    'user.emptyPasswordConfirmation' => 'Anda perlu mengesahkan kata laluan.',
    'user.oldPasswordIsIncorrect' => 'Kata laluan lama tidak betul. Sila cuba lagi.',
    'user.chooseDomainBoxTitle' => 'Pilih domain yang lain:',
    'user.userIsActive' => 'Pengguna adalah aktif',
    'user.userIsActiveHint' => 'Pengguna yang aktif boleh mengakses Plesk.',
    'user.emailActivation' => 'Aktifkan akaun melalui e-mel',
    'user.emailHint' => 'Untuk menyediakan pengguna dengan alamat e-mel yang dihoskan pada pelayan ini, pergi ke tab Mel, cipta alamat e-mel tertentu dan mengaitkannya dengan pengguna ini.',
    'user.emailContactHint' => 'Hubungi pembekal perkhidmatan anda sekiranya anda mahu menggunakan alamat e-mel yang dihoskan pada pelayan ini.',
    'user.personalEmailHint' => "Alamat e-mel pengguna ini boleh diubah pada tab Mel.",
    'user.externalMailRedirectHint' => 'Pemajuan boleh diaktifkan hanya untuk alamat e-mel yang dihoskan pada pelayan ini. Untuk mencipta alamat e-mel, pergi ke tab Mel.',
    'user.externalMailRedirectHint2' => 'Pemajuan boleh diaktifkan hanya untuk alamat e-mel yang dihoskan pada pelayan ini.',
    'user.externalMailAutoResponderHint' => 'Autobalas boleh diaktifkan hanya untuk alamat e-mel yang dihoskan pada pelayan ini. Untuk mencipta alamat e-mel, pergi ke tab Mel.',
    'user.externalMailAutoResponderHint2' => 'Autobalas boleh diaktifkan hanya untuk alamat e-mel yang dihoskan pada pelayan ini.',
    'user.roleHint' => 'Peranan pengguna memberikan pengguna keistimewaan pentadbiran dan akses ke aplikasi yang dipilih anda untuk peranannya.',
    'user.cannotManageMail' => "Anda tidak mempunyai kebenaran untuk mengurus tetapan dan perkhidmatan mel.",
    'user.longCompanyName' => 'Nama syarikat yang dinyatakan terlalu panjang.',
    'user.longPhone' => 'Nombor telefon yang dinyatakan terlalu panjang.',
    'user.longFax' => 'Nombor faks yang dinyatakan terlalu panjang.',
    'user.longAddress' => 'Alamat yang dinyatakan terlalu panjang.',
    'user.longCity' => 'Nama bandar yang dinyatakan terlalu panjang.',
    'user.phoneRegexNotMatch' => 'Nombor yang dinyatakan adalah tidak sah.',
    'user.faxRegexNotMatch' => 'Nombor faks yang dinyatakan adalah tidak sah.',
    'user.shortCity' => 'Nama bandar yang dinyatakan adalah terlalu pendek.',
    'user.limitSubscription' => 'Akses ke langganan',
    'user.limitSubscriptionHint' => 'Benarkan pengguna untuk mengakses hanya langganan tertentu. "Semua" nilai memberikan mereka akses kepada semua langganan dalam akaun pengehosan anda.',
    'user.limitSubscriptionAll' => 'Semua',
    'user.deletedSubscription' => 'Langganan dialihkan keluar',

    'web.add-domain-alias.title' => 'Tambah Alias Domain',
    'web.add-domain-alias.createdSuccessfully' => "%%name%% alias domain telah dicipta.",
    'web.add-domain-alias.domainAliasName' => 'Nama alias domain',
    'web.add-domain-alias.domainAliasNameHint' => 'Sebagai contoh, contoh.net',
    'web.add-domain-alias.forDomain' => 'untuk domain',
    'web.add-domain-alias.settingsSectionLegend' => 'Tetapan',
    'web.add-domain-alias.settingsDns' => 'Segerakkan zon DNS dengan domain utama',
    'web.add-domain-alias.settingsMail' => 'Perkhidmatan mel',
    'web.add-domain-alias.settingsWeb' => 'Perkhidmatan web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Ubah hala dengan kod HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Apabila pengunjung membuka URL alias, mereka akan dihalakan semula ke URL domain utama. Plesk menggunakan carian enjin mesra HTTP 301 yang dihalakan semula, bermakna kedudukan enjin carian tidak akan berpecah antara URL.',
    'web.add-domain-alias.settingsTomcat' => 'Aplikasi web Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Domain Tidak Sah',

    'web.add-domain.formTitle' => 'Menambah Domain Baharu',
    'web.add-domain.portalLink' => 'Portal perkhidmatan',
    'web.add-domain.domainName' => 'Nama domain',
    'web.add-domain.domainNameHint' => "Sebagai contoh, contoh.com",
    'web.add-domain.assignToCustomer' => 'Peruntukkan domain ini kepada pelanggan',
    'web.add-domain.customer' => 'Pilih pelanggan',
    'web.add-domain.createNewCustomer' => 'Cipta pelanggan baharu',
    'web.add-domain.selectExistingCustomer' => 'Pilih pelanggan sedia ada:',
    'web.add-domain.customerContactInfoHint' => 'Masukkan maklumat hubungan pelanggan. Anda boleh menentukan semua maklumat lain seperti nombor telefon dan alamat kemudian.',
    'web.add-domain.customerLoginInfoHint' => 'Kelayakan untuk panel pelanggan',
    'web.add-domain.target' => 'Ruang web',
    'web.add-domain.createNewTarget' => 'Cipta langganan baharu',
    'web.add-domain.createNewTarget_powerUser' => 'Cipta ruang web baharu',
    'web.add-domain.selectExistingTarget' => 'Pilih langganan sedia ada:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Pilih ruang web sedia ada:',
    'web.add-domain.dns' => 'Aktifkan perkhidmatan DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Aktifkan perkhidmatan mel',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Berfungsi jika tetapan langganan membenarkan pengurusan kebenaran mel setiap domain. Sekiranya tetapan tidak membenarkan, status sebenar perkhidmatan mel akan diambil daripada langganan.',
    'web.add-domain.hostingManagementOptions' => 'Jenis pengehosan',
    'web.add-domain.websiteHosting' => 'Pengehosan tapak web',
    'web.add-domain.websiteForwarding' => 'Pemajuan',
    'web.add-domain.websiteNoHosting' => 'Tiada pengehosan',
    'web.add-domain.hostingSettingsSectionLegend' => 'Tetapan Pengehosan',
    'web.add-domain.domainCreatedSuccessfully' => 'Domain %%domainName%% telah berjaya dicipta.',
    'web.add-domain.webspaceLegend' => 'Tetapan ruang web',
    'web.add-domain.addWhmWebsiteTitle' => 'Menambah Tapak Web Baru',
    'web.add-domain.addWhmWebsiteHint' => "Anda boleh memilih untuk menghoskan tapak web pada pelayan.",
    'web.add-domain.selectWhmDomain' => 'Pilih domain',
    'web.add-domain.customerLegend' => 'Maklumat Pelanggan',
    'web.add-domain.credentials' => 'Bukti kelayakan pengguna sistem',
    'web.add-domain.credentialsHint' => 'untuk mengakses fail yang dihoskan melalui FTP dan SSH',
    'web.add-domain.credentialsHintWin' => 'untuk mengakses fail yang dihoskan melalui FTP dan RDP',
    'web.add-domain.buttonAddDomain' => 'Tambah Domain',

    'web.add-subdomain.formTitle' => 'Tambah Subdomain',
    'web.add-subdomain.formGeneralHint' => 'Subdomain adalah alamat Internet untuk seksyen lain bagi tapak web anda. Ia menggunakan nama domain utama dan awalan anda. Sebagai contoh, sekiranya domain anda adalah domain.com, subdomain nya mungkin juga stor.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Anda juga boleh membuat subdomain kad bebas dengan memasukkan simbol * daripada namanya. Pengunjung tapak akan dihalakan semula ke subdomain ini tanpa mengira nama subdomain yang mereka masukkan ke dalam pelayar.',
    'web.add-subdomain.subdomainName' => 'Nama subdomain',
    'web.add-subdomain.subdomainNameHint' => 'Masukkan * untuk mencipta subdomain kad bebas.',
    'web.add-subdomain.forDomain' => 'Domain induk',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Subdomain yang telah dicipta.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Tetapan Pengehosan',

    'web.settings.phpSettingsDescription' => 'Halaman ini memaparkan konfigurasi PHP untuk tapak web ini. Tetapan ini khusus untuk tapak web ini dan tidak memberi kesan kepada tapak web lain pada langganan. Anda boleh menukar konfigurasi PHP jika penyedia pengehosan memberikan kebenaran yang berkaitan. Konfigurasi PHP tersuai boleh digunakan, contohnya, untuk menghadkan penggunaan sumber sistem dengan skrip PHP atau memenuhi keperluan aplikasi web tertentu. Apabila anda menetapkan nilai parameter kepada Lalai, PHP menggunakan nilai parameter daripada konfigurasi PHP lebar pelayan.',
    'web.settings.phpSettingsAvailableVariables' => 'Anda boleh menggunakan tempat letak berikut dalam nilai parameter:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} untuk direktori akar dokumen bagi tapak web ini. Nilai semasa ialah %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'Direktori akar dokumen HTTPS adalah sama seperti http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'Direktori akar dokumen HTTPS ialah %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} untuk direktori akar dokumen bagi tapak web utama langganan.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} untuk direktori yang menyimpan fail sementara.',
    'web.settings.phpSettingsNote' => 'Note: The settings below can be overwritten by parameters specified in the .htaccess, php.ini, or .user.ini files.',

    'web.change-status.changed' => 'The website status for %%domainName%% was changed.',

    'web.setupService.formTitle' => 'Perkhidmatan persediaan: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Perkhidmatan \'%%serviceReference%%\' telah berjaya dikemas kini.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% subdomain:',
    'web.site-copy.destinationTypeSection' => 'Salin Destinasi',
    'web.site-copy.destinationType' => 'Pilih di mana fail tapak web perlu disalin',
    'web.site-copy.destinationTypeSite' => 'Tapak web dalam Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Salin fail tapak ke tapak yang lain bagi dihoskan milik anda di bawah akaun ini. Sekiranya anda mempunyai akses FTP ke akaun yang lain pada pelayan ini, gunakan pilihan Storan FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Salin fail tapak ke tapak yang lain bagi dihoskan pada pelayan ini.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nama tapak',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Fail bagi tapak %%source%% tidak boleh disalin ke %%destination%% kerana %%destination%% juga merupakan sebahagian daripada fail--- akar dokumen itu adalah satu subdirektori bagi dokumen akar %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Fail bagi tapak %%destinasi%% tidak boleh dialih keluar kerana fail %%source%% adalah sebahagian daripadanya - akar dokumen %%source%% adalah subdirektori bagi %%destination%%",
    'web.site-copy.destinationTypeFtp' => 'Storan FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Salinkan fail tapak web ke akaun FTP pada ini atau pelayan luaran.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Salinan fail laman web ke akaun FTP pada pelayan luaran.',
    'web.site-copy.destinationTypeFtpHost' => "Nama hos pelayan",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Direktori',
    'web.site-copy.destinationTypeFtpUser' => 'Nama pengguna',
    'web.site-copy.destinationTypeFtpPassword' => 'Kata laluan',
    'web.site-copy.destinationTypeFtpMode' => 'Kaedah sambungan FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Mod aktif',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'Dalam mod aktif, Plesk menghantar alamat IP dan nombor port di mana ia akan mendengar pelayan luaran dan pelayan memulakan sambungan TCP. Mod ini disarankan apabila pelayan mengurus Plesk tidak dilindungi oleh tembok api.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Mod pasif',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Mod pasif boleh digunakan apabila pelayan diuruskan Plesk di belakang tembok api dan tidak dapat menerima sambungan TCP masuk.',
    'web.site-copy.existingFiles' => 'Apa yang perlu dilakukan dengan fail yang sedia ada',
    'web.site-copy.existingFilesKeep' => 'Kekalkan fail yang sedia ada pada tapak destinasi',
    'web.site-copy.existingFilesKeepDescription' => 'Menulis ganti fail sedia ada dengan nama fail serentak pada tapak destinasi.',
    'web.site-copy.existingFilesDelete' => 'Padam semua fail yang sedia ada',
    'web.site-copy.existingFilesDeleteDescription' => 'Padam semua fail pada tapak destinasi sebelum penyalinan.',
    'web.site-copy.emptyLogin' => 'Tentukan nama pengguna akaun FTP.',
    'web.site-copy.emptyHost' => 'Tentukan nama hos pelayan.',
    'web.site-copy.emptyPort' => 'Tentukan port hos pelayan.',
    'web.site-copy.copyInProgress' => 'Menyalin tapak web %%sourceName%% ke %%destinationName%%. Anda akan dimaklumkan mengenai kemajuan melalui e-mel (%%email%%).',
    'web.site-copy.unableToCopy' => 'Menyalin fail tapak web telah gagal.',
    'web.site-copy.siteCopied' => 'Fail tapak web telah disalin.',
    'web.site-copy.emailSubjSuccess' => 'Tapak web fail "%%source%%" telah disalin',
    'web.site-copy.emailSubjFailure' => 'Menyalin tapak web fail "%%source%%" telah gagal.',
    'web.site-copy.emailBodySuccess' => 'Tapak web fail "%%source%%" telah disalin ke "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Salin tapak web fail "%%source%%" ke "%%destination%%" telah gagal: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Tetapan Pemajuan',
    'web._shared.forwardDestination' => 'Alamat destinasi',
    'web._shared.forwardDestinationHint' => 'Tapak web sasaran bagi URL',
    'web._shared.forwardingTypeOptions' => 'Jenis pemajuan',
    'web._shared.forwardingFrame' => 'Pemajuan bingkai',
    'web._shared.forwardingFrameHint' => 'Mengubah hala tapak web pengunjung ke tapak lain, tetapi jangan tunjukkan mereka alamat destinasi, oleh itu, mereka tidak tahu tentang penghalaan semula.',
    'web._shared.forwardingHttpCode301' => 'Dialihkan secara kekal (kod 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Mengubah hala pengunjung tapak web ke tapak web yang lain dan menunjukkan kepada mereka alamat destinasi. Pengubahan hala sedemikian akan memastikan enjin carian tapak diberi ranking.',
    'web._shared.forwardingHttpCode302' => 'Dialihkan buat sementara waktu (kod 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Ubah hala pelawat tapak web ke salinan tapak sementara apabila anda tidak mahu enjin carian mengindeks tapak sementara ini.',
    'web._shared.documentRoot' => 'Akar dokumen',
    'web._shared.documentRootHint' => 'Laluan ke direktori rumah tapak web.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Ia adalah mustahil untuk mengubah akar dokumen kerana terdapat aplikasi web yang dipasang pada tapak web ini.',
    'web._shared.ipAddress' => 'Alamat IP',
    'web._shared.shared' => 'kongsi',
    'web._shared.exclusive' => 'khusus',
    'web._shared.ipAddressHint' => "Alamat IP di mana tapak web yang dihoskan adalah alamat rangkaian bagi hos maya tapak web.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (lain repository)',
    'web._shared.certificate' => 'Sijil',
    'web._shared.sameCertificatesHint' => 'Sijil yang dipilih akan digunakan untuk semua tapak yang dihoskan pada alamat IP khusus yang sama.',
    'web._shared.differentCertificatesHint' => 'Langganan ini dikaitkan dengan dua alamat IP khusus dengan dua sijil yang berbeza. Sijil dipilih akan menggantikan mana-mana sijil yang dipasang pada tapak yang dihoskan pada kedua-dua alamat IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Langganan ini dikaitkan dengan satu perkongsian dan satu alamat IP yang khusus. Sijil dipilih juga akan digunakan untuk semua tapak yang dihoskan dalam alamat IP yang khusus.',
    'web._shared.certificateNotSelected' => 'Tidak dipilih',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Tidak ada sijil SSL/TLS di dalam repositori anda. Untuk menambah sijil, pergi ke %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'halaman ini',

    'web-user.settings.allowScripts' => 'Benarkan pengguna web menggunakan skrip',

    'web-user.name' => 'Nama pengguna untuk menyambung ke pelayan melalui FTP',
    'web-user.longName' => 'Nama pengguna terlalu panjang (simbol maksimum %max% dibenarkan)',
    'web-user.password' => 'Kata laluan',
    'web-user.passwordConfirmation' => 'Sahkan kata laluan',
    'web-user.hardDiskQuota' => 'Kuota cakera keras',
    'web-user.hardDiskQuotaUnlimited' => 'Tidak terhad',
    'web-user.hardDiskQuotaIsNotSupported' => '(kuota cakera keras tidak disokong kerana konfigurasi sistem fail pelayan)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Medan yang diperlukan',
];