<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Adgang nægtet. Din konto blev suspenderet.",
    'login_up__login_has_been_locked' => "Du har forsøgt at logge på med en forkert adgangskode for mange gange. Af sikkerhedsgrunde vil du ikke kunne logge på med dette brugernavn i et stykke tid.",
    'login_up__unable_to_check_pass' => "Kan ikke kontrollere adgangskoden %1.",
    'login_up__warning_limits_licence_key' => "Et af følgende objekter har overskredet den grænse, der er defineret af din licensnøgle: antalæ brugerkonti, domæner, e-mailkonti webbrugere, som din server er host for.\nKontakt Plesk' salgsafdeling for at købe en nøgle, der vil tillade dig at være host for det ønskede antal brugere og domæner. Kontakt Teknisk Support hos Plesk, hvis du mener, at du har modtaget denne besked ved en fejltagelse.\nDen licenserede grænse for brugerkonti/domæner/emailkonti/webbrugere/sprogpakker: %2.Antallet af brugerkonti/domæner/emailkonti/webbrugere/sprogpakker: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Mængden af ressourcer, du bruger, har overskredet den grænse, der er defineret i din nuværende produktlicens. Kontakt Plesk' salgsafdeling og køb en ny licensnøgle.",
    'login_up__grace_period' => 'Du arbejder i øjeblikket indenfor din produktlicens\' kulanceperiode. Du kan opdatere din produktlicens ved at vælge Hent nøgler på siden %1Information om licens%2.',
    'login_up__partner_license_message' => 'Du arbejder i øjeblikket under en begrænset produktlicens, der kræver registrering inden det fulde sæt funktioner aktiveres. Du kan opdatere din produktlicens ved at vælge Hen nøgler på siden %1Information om licens%2.',
    'login_up__system_admin_disabled' => 'Superbrugeren (rod- eller administratorkonto) må ikke logge ind på Plesk af sikkerhedsgrunde.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Administratorvejledning for Plesk",
    'plesk_guide_reseller' => "Forhandlervejledning for Plesk",
    'plesk_guide_client' => "Kundevejledning for Plesk",
    'plesk_guide_domain_admin' => "Administratorvejledning for Plesk-domæne",
    'plesk_guide_mailuser' => "Brugervejledning for Plesk e-mail",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Søg', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Kunder',
    'ui__reseller_unknown__quick-search' => 'Forhandlere',
    'ui__client/domain_unknown__quick-search' => 'Domæner',
    'nav__general' => 'Hovedmenu',
    '__home' => 'Forside',
    '__resellers' => 'Forhandlere',
    '__clients' => 'Kunder',
    '__domains' => 'Domæner',
    '__applications' => 'Applikationer',
    '__settings' => 'Indstillinger',
    'nav__system' => 'System',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Niveau op',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Fjern',
    'bt_make_default' => 'Angiv som standard',

    // common list object operation errors
    'class_cList__empty_selection' => 'Der er ikke valgt et objekt.',

    // common list object search keys
    'clist__search_show' => 'Vis søgning',
    'clist__search_hide' => 'Skjul søgning',

    'bt_show_all' => "Nulstil søgning",

    // common object list info keys
    'clist__first' => 'Første',
    'clist__last' => 'Sidste',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Sider',
    'clist__page_size' => 'Emner pr. side',
    'clist__info' => 'Total %1: %4',
    'clist__info_empty' => 'Nr %1',
    'clist__info_filter' => '%5 %1 fundet (%4 i alt)',
    'clist__info_paging' => '%2-%3 %1 af %4 i alt',
    'clist__info_paging_filter' => '%2-%3 %1 af %5 fundet (%4 i alt)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktiv',
    '__object_off' => 'Suspenderet',

    '__home_description' => 'Tilbage til startside.',
    'indicator_title' => '%1% anvendt, %2% fri', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Der blev anmodet om en ugyldig URL.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Forhandlerkonti",
    'ui__reseller_unknown__title' => "Forhandlerkonti",
    'ui__reseller_unknown__description' => "Administrér forhandlerkonti.",
    'ui__reseller/client_unknown__short-title' => 'Kunde Konti',
    'ui__reseller/client_unknown__title' => 'Kunde Konti',
    'ui__reseller/client_unknown__description' => 'Administrér kundekonti',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Ekstra administratorkonti", // PFW
    'ui__admin-alias_unknown__short-title' => "Ekstra administratorkonti", // PFW
    'ui__admin-alias_unknown__description' => "Se og administrer ekstra administratorkonti.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Server-brede e-mail indstillinger",
    'ui__server/mail__title' => "Server-brede e-mail indstillinger",
    'ui__server/mail__description' => "Opsæt din e-mailserver og konfigurér server-brede e-mailindstillinger.",
    'ui__server/dns__short-title' => 'DNS-indstillinger',
    'ui__server/dns__title' => 'DNS-indstillinger',
    'ui__server/dns__description' => 'Gennemse og opdatér server-brede DNS-indstillinger.',
    'ui__server/services__title' => 'Serviceadministration',
    'ui__server/services__description' => 'Start, stop eller genstart Plesk-services.',
    'ui__server/crontab/task_unknown__short-title' => 'Planlagte opgaver',
    'ui__server/crontab/task_unknown__title' => 'Planlagte opgaver',
    'ui__server/crontab/task_unknown__description' => 'Tilføj eller fjern server-overordnede planlagte opgaver.',
    'ui__server/ip-address_unknown__short-title' => 'IP-adresser',
    'ui__server/ip-address_unknown__title' => 'IP-adresser',
    'ui__server/ip-address_unknown__description' => 'Vis, tilføj og fjern IP-adresser, tilknyt IP-adresser til forhandlere.',
    // dropdowns
    'ui__server/time__title' => 'Systemklokkeslæt',
    'ui__server/time__short-title' => 'Systemklokkeslæt',
    'ui__server/time__description' => 'Rediger systemdato og klokkeslæt, opsæt synkronisering med en NTP-server.',
    'ui__server/maillists__title' => 'Opsæt mailinglisteserver.', // PFU
    'ui__server/maillists__short-title' => 'Opsæt mailinglisteserver.', // PFU
    'ui__server/maillists__description' => 'Opsæt Mailman-mailingliste server.', // PFU
    'ui__mass-email__short-title' => "Masse e-mail-meddelelser", // PFW
    'ui__mass-email__title' => "Masse e-mail-meddelelser", // PFW
    'ui__mass-email__description' => "Send e-mailmeddelelser til flere brugere på en gang.", // PFW
    'ui__mass-mail__title' => 'Masse e-mail-meddelelser', // PFU
    'ui__mass-mail__short-title' => 'Masse e-mail-meddelelser', // PFU
    'ui__mass-mail__description' => 'Send e-mailmeddelelser til flere brugere på en gang.', // PFU
    'ui__server/spam-filter__title' => 'Spamfilter-indstillinger',
    'ui__server/spam-filter__short-title' => 'Spamfilter-indstillinger',
    'ui__server/spam-filter__description' => 'Opsæt server-bredt spamfilter.',
    'ui__server/preferences__title' => "Serverindstillinger",
    'ui__server/preferences__short-title' => "Serverindstillinger",
    'ui__server/preferences__description' => "Opsæt server-brede statistikberegninger, redigér serverens host navn og rediger andre serverindstillinger.",

    // help & support
    // icons
    'ui__support__short-title' => 'Support',
    'ui__support__title' => 'Support',
    'ui__support__description' => 'Indsend en anmodning om tekniske support biletter, der er indsendt af dine kunder.',
    'ui__license__short-title' => 'Information om licens',
    'ui__license__title' => 'Information om Plesk-licens',
    'ui__license__description' => 'Vis information om din Plesk-licens og bestil nye licensnøgler.',
    'ui__help__short-title' => 'Hjælp',
    'ui__help__title' => 'Onlinehjælp',
    'ui__help__description' => 'Se online hjælp',
    'ui__news__short-title' => "Nyheder",
    'ui__news__title' => "Nyheder",
    'ui__news__description' => "Se listen over ændringer i denne version af Plesk.",
    'ui__server/autoinstaller__short-title' => 'Opdateringer',
    'ui__server/autoinstaller__title' => 'Opdateringer',
    'ui__server/autoinstaller__description' => 'Opdater Plesk eller dets komponenter.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domæner',
    'ui__client/domain_unknown__title' => 'Domæner',
    'ui__client/domain_unknown__description' => 'Administrér domæner',
    'ui__server/skeleton__short-title' => 'Skabelon til Virtuel host',
    'ui__server/skeleton__title' => 'Skabelon til Virtuel host',
    'ui__server/skeleton__description' => 'Angiv hvilke filer og mapper der skal placeres i mapperne på nyoprettede domæner.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Knyt en ny ejer til abonnementer',
    'ui__client/domain/chowner_multi-select__short-title' => 'Tilknyt ny abonnementsejer',
    'ui__client/domain/chowner_multi-select__description' => 'Knyt en ny ejer til markerede abonnementer',
    'ui__client/domain/disable_multi__title' => 'Suspendér domæner',
    'ui__client/domain/disable_multi__short-title' => 'Suspendér domæner',
    'ui__client/domain/disable_multi__description' => 'Suspendér markerede domæner',
    'ui__client/domain/enable_multi__title' => 'Aktivér domæner',
    'ui__client/domain/enable_multi__short-title' => 'Aktivér domæner',
    'ui__client/domain/enable_multi__description' => 'Aktivér markerede domæner',

    // icons
    'ui__admin/extras-domain__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Værktøjer fra MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__server/sitebuilder__short-title' => 'Indstillinger for Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Indstillinger for Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Opsæt Presence Builder til redigering af websteder, der hostes på denne server.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Registrer domæne',
    'ui__admin/register-domain__short-title' => 'Registrer domæne',
    'ui__admin/register-domain__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Administrer domæne',
    'ui__admin/manage-domain__short-title' => 'Administrer domæne',
    'ui__admin/manage-domain__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',
    'ui__server/register__title' => 'Registrer din server',
    'ui__server/register__short-title' => 'Registrer server',
    'ui__server/register__description' => 'Registrér din server for at deltage i et samarbejdspartner-program',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Handlingslog',
    'ui__actionlog__title' => 'Handlingslog',
    'ui__actionlog__description' => 'Download handlingslog og administrér handlingslog-indstillinger.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Serveroplysninger',
    'ui__server/statistics__title' => 'Serveroplysninger',
    'ui__server/statistics__description' => 'Statistik for de services der administreres af Plesk.',
    'ui__admin/report__title' => 'Oversigtsrapport',
    'ui__admin/report__short-title' => 'Oversigtsrapport',
    'ui__admin/report__description' => 'Vis rapport om trafik- og ressourceforbrug for forhandlere, kunder og domæner.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Sessions inaktive periode',
    'ui__sessions/properties__title' => 'Sessions inaktive periode',
    'ui__sessions/properties__description' => 'Indstil inaktiv sessionstid for Plesk­sessioner.',
    'ui__cp-access__short-title' => 'Adgang til Plesk',
    'ui__cp-access__title' => 'Adgang til Plesk',
    'ui__cp-access__description' => 'Begræns adgang til Plesk.',
    'ui__sessions__short-title' => 'Aktive sessioner',
    'ui__sessions__title' => 'Aktive sessioner',
    'ui__sessions__description' => 'Vis aktive Plesk-sessioner.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-certifikater',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-certifikater',
    'ui__server/certificate_unknown__description' => 'Listen med SSL/TLS-certifikater',

    // account
    // icons
    'ui__admin-info__short-title' => 'Personlige data',
    'ui__admin-info__title' => 'Personlige data',
    'ui__admin-info__description' => 'Rediger personlige data for din konto.',
    'ui__admin-password__short-title' => 'Skift adgangskode',
    'ui__admin-password__title' => 'Skift adgangskode',
    'ui__admin-password__description' => 'Skift adgangskoden til din konto.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Arbejd med fysiske og virtuelle filer og mapper på et websted.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Resurseforbrug',
    'ui__reseller/limits__title' => 'Resurseforbrug',
    'ui__reseller/limits__description' => 'Vis og administrer forhandler %1\'s ressourceforbrug.',
    'ui__reseller/limits_unknown__short-title' => 'Resurseforbrug',
    'ui__reseller/limits_unknown__title' => 'Resurseforbrug',
    'ui__reseller/limits_unknown__description' => 'Vis og administrer forhandlers ressourceforbrug.',
    'ui__reseller/limits_self__short-title' => 'Resurseforbrug',
    'ui__reseller/limits_self__title' => 'Resurseforbrug',
    'ui__reseller/limits_self__description' => "Vis og administrer dit ressourceforbrug",
    'ui__reseller/limits_readonly-self__short-title' => 'Resurseforbrug',
    'ui__reseller/limits_readonly-self__title' => 'Resurseforbrug',
    'ui__reseller/limits_readonly-self__description' => "Vis dit ressourceforbrug.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Trafikforbrug efter kunder',
    'ui__reseller/client/traffic_unknown__title' => 'Se trafikforbrug sorteret efter kunder',
    'ui__reseller/client/traffic_unknown__description' => 'Vis trafikforbrugsrapport for kundekonti.',
    'ui__client/traffic_unknown__short-title' => "Trafikforbrug efter kunder", // temporary for presets
    'ui__client/traffic_unknown__title' => "Se trafikforbrug sorteret efter kunder", // temporary for presets
    'ui__client/traffic_unknown__description' => "Vis trafikforbrugsrapport for kundekonti.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Log-administrator',
    'ui__client/domain/hosting/logs_unknown__title' => 'Log-administrator',
    'ui__client/domain/hosting/logs_unknown__description' => 'Vis logge og konfigurer logrotation.',
    // dropdowns
    'ui__reseller/report__title' => 'Oversigtsrapport',
    'ui__reseller/report__short-title' => 'Oversigtsrapport',
    'ui__reseller/report__description' => 'Vis rapport om denne forhandlers brug af trafik og ressourcer.',
    'ui__reseller/report_unknown__title' => 'Oversigtsrapport',
    'ui__reseller/report_unknown__short-title' => 'Oversigtsrapport',
    'ui__reseller/report_unknown__description' => 'Vis rapport om forhandlerens brug af trafik og ressourcer.',
    'ui__reseller/report_self__title' => 'Oversigtsrapport',
    'ui__reseller/report_self__short-title' => 'Oversigtsrapport',
    'ui__reseller/report_self__description' => 'Vis rapport om din brug af trafik og ressourcer.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk-branding',
    'ui__client/logo_reseller__short-title' => 'Plesk-branding',
    'ui__client/logo_reseller__description' => 'Rebrand Plesk til forhandlere %1.',
    'ui__client/logo_unknown__title' => 'Plesk-branding', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk-branding', // temporary for presets
    'ui__client/logo_unknown__description' => 'Rebrand Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk-branding',
    'ui__client/logo_self-reseller__short-title' => 'Plesk-branding',
    'ui__client/logo_self-reseller__description' => 'Rebrand din Plesk.',
    'ui__reseller/permissions__title' => 'Rettigheder',
    'ui__reseller/permissions__short-title' => 'Rettigheder',
    'ui__reseller/permissions__description' => "Vis eller rediger listen over de handlinger, som forhandleren %1 kan udføre i Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Rettigheder',
    'ui__reseller/permissions_unknown__title' => 'Rettigheder',
    'ui__reseller/permissions_unknown__description' => "Vis eller rediger listen over de handlinger, som forhandleren %1 kan udføre i Plesk.",
    'ui__reseller/permissions_self__title' => 'Rettigheder',
    'ui__reseller/permissions_self__short-title' => 'Rettigheder',
    'ui__reseller/permissions_self__description' => 'Vis listen over de handlinger, du kan udføre i Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Rettigheder',
    'ui__reseller/permissions_readonly-self__short-title' => 'Rettigheder',
    'ui__reseller/permissions_readonly-self__description' => 'Vis listen over de handlinger, du kan udføre i Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Skabelon til Virtuel host',
    'ui__client/skeleton__short-title' => 'Skabelon til Virtuel host',
    'ui__client/skeleton__description' => 'Angiv hvilke filer og mapper der skal placeres i mapperne på nyoprettede domæner.',
    'ui__client/skeleton_unknown__short-title' => 'Skabelon til Virtuel host',
    'ui__client/skeleton_unknown__title' => 'Skabelon til Virtuel host',
    'ui__client/skeleton_unknown__description' => 'Angiv hvilke filer og mapper der skal placeres i mapperne på nyoprettede domæner.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Domænealiasser',
    'ui__client/domain/domain-alias_unknown__title' => 'Domænealiasser',
    'ui__client/domain/domain-alias_unknown__description' => 'Gennemse listen over alternative navne til dit domæne.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_unknown__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_unknown__description' => 'Administrér DNS-zone indstillinger for et domæne.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-unknown__description' => 'Gennemse DNS-zone indstillinger for et domæne.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Værktøjer fra MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Værktøjer fra MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Værktøjer fra MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Registrer domæne',
    'ui__reseller/register-domain__title' => 'Registrer domæne',
    'ui__reseller/register-domain__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Registrer domæne',
    'ui__reseller/register-domain_unknown__title' => 'Registrer domæne',
    'ui__reseller/register-domain_unknown__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Registrer domæne',
    'ui__reseller/register-domain_self__title' => 'Registrer domæne',
    'ui__reseller/register-domain_self__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Administrer domæne',
    'ui__reseller/manage-domain__short-title' => 'Administrer domæne',
    'ui__reseller/manage-domain__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Administrer domæne',
    'ui__reseller/manage-domain_unknown__short-title' => 'Administrer domæne',
    'ui__reseller/manage-domain_unknown__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Administrer domæne',
    'ui__reseller/manage-domain_self__short-title' => 'Administrer domæne',
    'ui__reseller/manage-domain_self__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-adresser',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-adresser',
    'ui__client/ipaddress_unknown-reseller__description' => 'Administrér IP-adresser',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-certifikater',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-certifikater',
    'ui__client/domain/certificate_unknown__description' => 'Installer og administrer SSL/TLS-certifikater.',
    'ui__reseller/sessions__short-title' => 'Aktive sessioner',
    'ui__reseller/sessions__title' => 'Aktive sessioner',
    'ui__reseller/sessions__description' => 'Vis aktive Plesk-sessioner.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktive sessioner',
    'ui__reseller/sessions_unknown__title' => 'Aktive sessioner',
    'ui__reseller/sessions_unknown__description' => 'Vis aktive Plesk-sessioner.',
    'ui__reseller/sessions_self__short-title' => 'Aktive sessioner',
    'ui__reseller/sessions_self__title' => 'Aktive sessioner',
    'ui__reseller/sessions_self__description' => 'Vis aktive Plesk-sessioner.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Mailkonti under brugerkonto %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Skabelon til Virtuel host',
    'ui__client/skeleton_self__title' => 'Skabelon til Virtuel host',
    'ui__client/skeleton_self__description' => 'Angiv hvilke filer og mapper der skal placeres i mapperne på nyoprettede domæner.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Resurseforbrug',
    'ui__client/limits__title' => 'Resurseforbrug',
    'ui__client/limits__description' => "Vis og administrer ressourceforbrug for kunden %1",
    'ui__client/limits_unknown__short-title' => 'Resurseforbrug',
    'ui__client/limits_unknown__title' => 'Resurseforbrug',
    'ui__client/limits_unknown__description' => 'Vis og administrer ressourceforbrug for kunden',
    'ui__client/limits_readonly__short-title' => 'Resurseforbrug',
    'ui__client/limits_readonly__title' => 'Resurseforbrug',
    'ui__client/limits_readonly__description' => 'Vis ressourceforbrug for kunden %1.',
    'ui__client/limits_self__short-title' => 'Resurseforbrug',
    'ui__client/limits_self__title' => 'Resurseforbrug',
    'ui__client/limits_self__description' => "Vis og administrer dit ressourceforbrug",
    'ui__client/limits_readonly-self__short-title' => 'Resurseforbrug',
    'ui__client/limits_readonly-self__title' => 'Resurseforbrug',
    'ui__client/limits_readonly-self__description' => "Vis dit ressourceforbrug.",
    'ui__client/domain/traffic_unknown__short-title' => "Trafikforbrug for domæner %1",
    'ui__client/domain/traffic_unknown__title' => "Vis trafikforbrug for domæner.",
    'ui__client/domain/traffic_unknown__description' => "Vis trafikforbrugsrapport for domæner.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Oversigtsrapport',
    'ui__client/report__short-title' => 'Oversigtsrapport',
    'ui__client/report__description' => 'Vis rapport om brug af trafik og ressourcer for denne kunde.',
    'ui__client/report_unknown__short-title' => 'Oversigtsrapport',
    'ui__client/report_unknown__title' => 'Oversigtsrapport',
    'ui__client/report_unknown__description' => 'Vis rapport om brug af trafik og ressourcer for kunder.',
    'ui__client/report_self__short-title' => 'Oversigtsrapport',
    'ui__client/report_self__title' => 'Oversigtsrapport',
    'ui__client/report_self__description' => 'Vis rapport om brug af trafik og ressourcer.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Grænsefladeindstillinger',
    'ui__client/preferences__title' => 'Grænsefladeindstillinger',
    'ui__client/preferences__description' => 'Indstil Plesk grænsefladeindstillinger for kunden %1.',
    'ui__client/preferences_unknown__short-title' => 'Grænsefladeindstillinger',
    'ui__client/preferences_unknown__title' => 'Grænsefladeindstillinger',
    'ui__client/preferences_unknown__description' => "Indstil grænsefladeindstillinger til kundens Plesk.",
    'ui__client/preferences_self__short-title' => 'Grænsefladeindstillinger',
    'ui__client/preferences_self__title' => 'Grænsefladeindstillinger',
    'ui__client/preferences_self__description' => 'Indstil grænsefladeindstillinger til dit Plesk.',
    'ui__client/logo__title' => 'Plesk-branding',
    'ui__client/logo__short-title' => 'Plesk-branding',
    'ui__client/logo__description' => "Rebrand kunden %1's Plesk.",
    'ui__client/logo_self__title' => 'Plesk-branding',
    'ui__client/logo_self__short-title' => 'Plesk-branding',
    'ui__client/logo_self__description' => 'Rebrand Plesk ved at udskifte logo og tekst i browserens titellinje.',
    'ui__client/permissions__title' => 'Rettigheder',
    'ui__client/permissions__short-title' => 'Rettigheder',
    'ui__client/permissions__description' => "Vis eller rediger listen over de handlinger, som kunden %1 kan udføre i Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Rettigheder',
    'ui__client/permissions_unknown__title' => 'Rettigheder',
    'ui__client/permissions_unknown__description' => "Vis eller rediger listen over de handlinger, som kunden kan udføre i Plesk.",
    'ui__client/permissions_self__title' => 'Rettigheder',
    'ui__client/permissions_self__short-title' => 'Rettigheder',
    'ui__client/permissions_self__description' => "Vis listen over de handlinger, du kan udføre i Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Rettigheder',
    'ui__client/permissions_readonly-self__short-title' => 'Rettigheder',
    'ui__client/permissions_readonly-self__description' => "Vis listen over de handlinger, du kan udføre i Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/extras-domain__title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/extras-domain__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Registrer domæne',
    'ui__client/register-domain__short-title' => 'Registrer domæne',
    'ui__client/register-domain__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Registrer domæne',
    'ui__client/register-domain_unknown__short-title' => 'Registrer domæne',
    'ui__client/register-domain_unknown__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Registrer domæne',
    'ui__client/register-domain_self__short-title' => 'Registrer domæne',
    'ui__client/register-domain_self__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Administrer domæne',
    'ui__client/manage-domain__short-title' => 'Administrer domæne',
    'ui__client/manage-domain__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Administrer domæne',
    'ui__client/manage-domain_unknown__short-title' => 'Administrer domæne',
    'ui__client/manage-domain_unknown__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Administrer domæne',
    'ui__client/manage-domain_self__short-title' => 'Administrer domæne',
    'ui__client/manage-domain_self__description' => 'Administrér registrerede domænenavne gennem MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-adresser',
    'ui__client/ipaddress_unknown__short-title' => "IP-adresser",
    'ui__client/ipaddress_unknown__description' => "Administrér IP-adresser",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Domænealiasser',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Domænealiasser',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Gennemse listen over alternative navne til dit domæne.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Aktive sessioner',
    'ui__client/sessions__title' => 'Aktive sessioner',
    'ui__client/sessions__description' => 'Vis aktive Plesk-sessioner.',
    'ui__client/sessions_unknown__short-title' => 'Aktive sessioner',
    'ui__client/sessions_unknown__title' => 'Aktive sessioner',
    'ui__client/sessions_unknown__description' => 'Vis aktive Plesk-sessioner.',
    'ui__client/sessions_self__short-title' => 'Aktive sessioner',
    'ui__client/sessions_self__title' => 'Aktive sessioner',
    'ui__client/sessions_self__description' => 'Vis aktive Plesk-sessioner.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Arbejd med fysiske og virtuelle filer og mapper på webstedet %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Arbejd med fysiske og virtuelle filer og mapper på dit websted.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 trafikforbrug',
    'ui__client/domain/traffic__title' => 'Dataoverførselsstatistik for <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Vis dataoverførselsstatistik domænet %1.',
    'ui__client/domain/traffic_self__short-title' => 'Trafikforbrug',
    'ui__client/domain/traffic_self__title' => 'Vis trafikforbrug for dit domæne.',
    'ui__client/domain/traffic_self__description' => 'Vis trafikforbrugsrapport for dit domæne.',
    'ui__client/domain/hosting/logs__short-title' => 'Log-administrator',
    'ui__client/domain/hosting/logs__title' => 'Log-administrator',
    'ui__client/domain/hosting/logs__description' => 'Vis logge og konfigurer logrotation.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Log-administrator',
    'ui__client/domain/hosting/logs_self__title' => 'Log-administrator',
    'ui__client/domain/hosting/logs_self__description' => 'Vis logge og konfigurer logrotation.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Omdøb domæne',
    'ui__client/domain/rename__short-title' => 'Omdøb domæne',
    'ui__client/domain/rename__description' => 'Omdøb domænet %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Omdøb domæne',
    'ui__client/domain/rename_unknown__title' => 'Omdøb domæne',
    'ui__client/domain/rename_unknown__description' => 'Omdøb et domæne',
    'ui__client/domain/chowner_select__title' => 'Knyt en ny ejer til domænet',
    'ui__client/domain/chowner_select__short-title' => 'Knyt en ny ejer til abonnement',
    'ui__client/domain/chowner_select__description' => 'Knyt en ny ejer til abonnementet',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Knyt en ny ejer til abonnement',
    'ui__client/domain/chowner_unknown-select__title' => 'Knyt en ny ejer til abonnement',
    'ui__client/domain/chowner_unknown-select__description' => 'Knyt en ny ejer til et abonnement',
    'ui__client/domain/toggle__title' => 'Suspendér eller aktivér domæne.', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspendér eller aktivér domæne.', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspendér eller aktivér domænet %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspendér eller aktivér domæne.', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspendér eller aktivér domæne.', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspendér eller aktivér et domæne.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktivér domæne.',
    'ui__client/domain/toggle_enable__short-title' => 'Aktivér domæne.',
    'ui__client/domain/toggle_enable__description' => 'Aktivér domænet: %1',
    'ui__client/domain/toggle_disable__title' => 'Suspendér domænet',
    'ui__client/domain/toggle_disable__short-title' => 'Suspendér domænet',
    'ui__client/domain/toggle_disable__description' => 'Suspendér domænet: %1',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS-indstillinger',
    'ui__client/domain/dns__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns__description' => 'Administrér DNS-zone indstillinger for domænet %1.',
    'ui__client/domain/dns_self__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_self__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_self__description' => 'Administrér DNS-zone indstillinger for dit domæne.',
    'ui__client/domain/dns_disabled__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_disabled__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_disabled__description' => 'Administrér DNS-zone indstillinger for domænet %1.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_self-disabled__description' => 'Administrér DNS-zone indstillinger for dit domæne.',
    'ui__client/domain/dns_readonly__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly__description' => 'Gennemse DNS-zone indstillinger for domænet %1.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-self__description' => 'Gennemse DNS-zone indstillinger for dit domæne.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Gennemse DNS-zone indstillinger for dit domæne.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Gennemse DNS-zone indstillinger for dit domæne.',
    'ui__client/domain/dns_slave__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_slave__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_slave__description' => 'Administrér DNS-zone indstillinger for domænet %1.',
    'ui__client/domain/dns_self-slave__title' => 'DNS-indstillinger',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS-indstillinger',
    'ui__client/domain/dns_self-slave__description' => 'Administrér DNS-zone indstillinger for dit domæne.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras__title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Få yderligere værktøjer og services fra MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Registrer domæne',
    'ui__client/domain/register__title' => 'Registrer domæne',
    'ui__client/domain/register__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Registrer domæne',
    'ui__client/domain/register_unknown__title' => 'Registrer domæne',
    'ui__client/domain/register_unknown__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Registrer domæne',
    'ui__client/domain/register_self__title' => 'Registrer domæne',
    'ui__client/domain/register_self__description' => 'Registrér et domænenavn gennem MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Værktøjer",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Vis statistik',
    'ui__client/domain-summary-report_unknown__title' => 'Vis statistik',
    'ui__client/domain-summary-report_unknown__description' => 'Vis informationen om domæners ressourceforbrug.',
    'ui__client/domain-summary-report__short-title' => "Vis statistik",
    'ui__client/domain-summary-report__title' => "Vis statistik",
    'ui__client/domain-summary-report__description' => "Vis informationen om domæners ressourceforbrug.",
    'ui__client/domain-summary-report_self__short-title' => "Vis statistik",
    'ui__client/domain-summary-report_self__title' => "Vis statistik",
    'ui__client/domain-summary-report_self__description' => "Vis informationen om dine domæners ressourceforbrug.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domæner", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Du skal vælge de sikkerhedskopier, du vil fjerne',
    'ui__client/domain/chowner__empty_selection' => 'Du har markeret de domæner, hvortil du vil knytte en ny ejer',

    // list objects filtering
    'domains_list__name__filter_title' => 'Navn',
    'domains_list__state__filter_title' => 'Resurseforbrug',
    'domains_list__filter_state_any' => 'Alle',
    'domains_list__filter_state_overuse' => 'Overforbrug',
    'domains_list__filter_state_normal' => 'Indenfor grænserne',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Alle',
    'domains_list__filter_status_blocked' => 'Suspenderet',
    'domains_list__filter_status_active' => 'Aktiv',
    'domains_list__ownership__filter_title' => 'Ejerskab',
    'domains_list__filter_ownership_all' => 'Alle domæner',
    'domains_list__filter_ownership_personal' => 'Kun mine domæner',
    'domains_list__filter_owner_pname__filter_title' => 'Ejers navn',
    'domains_list__subrows__filter_title' => 'Vis',
    'domains_list__subrows_off' => 'Kun domæner',
    'domains_list__subrows_subdomain_domainaliases' => 'Med underdomæner aliasser',
    'domains_list__subrows_subdomain' => 'Med underdomæner',
    'domains_list__subrows_domainaliases' => 'Med aliasser',

    // objects list
    'domains_list__owner__title' => 'Ejer',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Søg efter programmer",
    'site_apps__promo_main_text' => "Application Packaging Standard (APS) katalog indeholder listen over programmer, der kan provisioneres til et domæne eller webspace. Hvis du vil provisionere programmer, der ikke er i kataloget i øjeblikket, kan du nemt gøre dette ved at følge APS-pakkeinstruktionerne på www.apsstandard.com",
    'site_apps__promo_download_now' => "Download programmer:",
    'site_apps__promo_close' => "Luk denne blok",
    'site_apps__promo_preset__mostused' => '%1 mest populære',
    'site_apps__promo_preset__lessused' => 'Næste %1 mest populære',
    'site_apps__promo_preset__all' => "Alle",
    'site_apps__promo_disclaimer_note' => 'Bemærk, at programmer, der installeres fra APS-kataloget, leveres af tredjeparter, og disse supporteres ikke af Plesk.',
    'site_apps__promo_preset__page_title' => '%1 APS-programmer',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Tilføjer programmer...',

    // Errors
    'site_apps__no_applications_for_update' => 'Du har ikke programmer installeret i programbanken.',
    'site_apps__incorrect_download_preset_configuration' => 'Der blev fundet fejl i konfigurationen af forudindstillingen til APS-katalog-download.',
    'site_apps__aps_catalog_url_is_invalid' => 'Den angivne URL er ikke gyldig.',
    'site_apps__no_updates_at_the_moment' => 'Der findes ingen tilgængelige programopdateringer i øjeblikket.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Forkert information blev modtaget fra APS-programkataloget. Prøv igen senere.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS-katalogindstillingerne blev gemt, men Plesk kunne ikke etablere en forbindelse til det APS-katalog, der er specificeret i APS-katalogindstillingerne (%1). Sørg for, at APS-katalogadressen er korrekt, og at APS-kataloget på denne adresse er aktivt.',
    'site_apps__cannot_retrieve_updates' => 'Kan ikke downloade programopdateringer i øjeblikket: kan ikke etablere forbindelse til APS-kataloget (%1). Sørg for, at APS-katalogadressen er korrekt, og at APS-kataloget på denne adresse er aktivt.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Der findes ingen webprogrammer der kan kopieres.',
    'site_apps__site_applications_already_installed_in_root' => 'Andre webprogrammer er allerede installeret i rodmapperne på disse virtuelle hosts',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET webprogrammer understøttes ikke på Unix/Linux-platformen",
    'site_apps__server_wide_packages_not_supported' => 'Server-brede webprogrammer understøttes ikke',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 flere webprogrammer er planlagr til tilføjelse i programbanken.",
    'site_apps__applications_all_in_vault' => "De markerede webprogrammer findes allerede i programbanken.",
    'site_apps__applications_already_in_download_queue' => "%1 markerede webprogrammer føjes til programbanken i øjeblikket.",
    'site_apps__applications_already_in_valut' => "%1 markerede webprogrammer findes allerede i programbanken.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Andet (ikke kategoriseret)',

    // Errors
    'site_apps__no_applications_in_category' => 'Der er ingen programmer i denne kategori. Vælg en anden kategori.',
    'site_apps__no_category_selected__please_specify' => 'Vælg en kategori i den venstre menu. Alle de programmer, der er til rådighed i den valgte kategori, vil blive vist i dette vindue.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Administratorkonto',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Generelt',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Rediger host-navn',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Sikkerhed',
    'bt_setup_firewall' => 'Konfigurér firewall',
    'bt_manage_firewall_rules' => 'Administrér firewall-regler',
    'cu_firewall__rule' => 'Opret en firewall-regel',
    'cu_firewall__protocol' => 'Indstil en protokol til reglen (\'tcp\' eller \'udp\')',
    'cu_firewall__name' => "Indtast et regelnavn",
    'cu_firewall__disabled' => 'Hvis \'sand\', deaktiveres reglen efter oprettelsen',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Vælg DNS-server', // PFW
    'bt_soa_records_template' => 'SOA-post skabelon',
    'bt_restrict_creation_of_subzones' => 'Begræns oprettelse af underzoner',

    'databases' => 'Databaser',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Applikationer',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-mail',
    'bt_select_mailserver' => 'Ekstern e-mailserver', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Vælg antivirus', // PFW
    'bt_virus_protection_settings' => 'Virusbeskyttelsesindstillinger',
    'bt_select_spamfilter' => 'Vælg spamfilter', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Vælg webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logge og statistik',
    'bt_server_statistics_settings' => 'Indstillinger for server-statistik',
    'bt_select_web_statistics' => 'Tilgængeligt web-statistik software', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk-brugerflade',

    'components_and_modules' => 'Komponenter og moduler',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Konfigurér watchdog', // PFU
    'bt_setup_vpn' => 'konfigurer VPN', // PFU
    'bt_setup_samba' => 'Konfigurér samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Indstillinger',
    'ui__client/domain/settings_self__short-title' => 'Indstillinger',
    'ui__client/domain/settings_self__description' => 'Vis og skift domæneindstillinger.',

    'domain_administrator_account' => 'Domæneadministratorkonto',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Kontoindstillinger',

    'domain' => 'Domæne',
    'bt_dns_soa_records' => 'Rediger SOA-post',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Indstilling af opgaveplanlægning',

    'website' => 'Websted',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting for webbrugere',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Vælg SSL/TLS-certifikat',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Webstatistik',
    'bt_log_rotation_settings' => 'Log-rotationsindstillinger',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Begrænsninger", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Overforbrugs- og oversalgspolitik",
    'limits__overuse_policy_legend' => "Overforbrug",
    'limits__oversell_policy_legend' => "Oversalg",
    'limits__reseller_overuse_description' => "Overforbrugspolitikken fortæller Plesk hvad der skal gøres, hvis ressourcer overforbruges.",
    'limits__overuse_text' => "Overforbrugspolitik",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Diskplads og trafik',
    'limit__disk_space' => 'Diskplads',
    'limit__max_traffic' => 'Trafik',
    'limit_group__client' => 'Kunder',
    'limit__max_cl' => 'Kunder',
    'limit_group__domain' => 'Domæner',
    'limit__max_dom' => 'Domæner',
    'limit__max_dom_powerUser' => 'Abonnementer',
    'limit__max_subdom' => 'Subdomæner',
    'limit__max_dom_aliases' => 'Domænealiasser',
    'limit__max_wu' => 'Webbrugere',
    'limit__max_subftp_users' => 'Ekstra FTP-konti', // PFW
    'limit_group__mail' => 'E-mail',
    'limit__max_box' => 'Mailbokse',
    'limit__mbox_quota' => 'Størrelse på mailboks:',
    'limit__total_mboxes_quota' => 'Total mailbokse-kvote', // PFW
    'limit__max_maillists' => 'Mailing Lists',
    'limit_group__database' => 'Databaser',
    'limit__max_mssql_db' => 'Microsoft SQL Server-databaser', // PFW
    'limit__mssql_dbase_space' => 'Total MS SQL database-kvote', // PFW
    'limit__max_odbc' => 'ODBC-tilslutninger', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MariaDB/MySQL databasekvote', // PFW
    'limit__pgsql_dbase_space' => 'PostgreSQL-databasekvote', // PFW
    'limit_group__application' => 'Applikationer',
    'limit__max_iis_app_pools' => 'IIS-programgrupper', // PFW
    'limit_group__security' => 'Sikkerhed',
    'limit_group__validity' => 'Udløbsdato',
    'limit__expiration' => 'Udløbsdato',
    'limit__validity' => 'Gyldighedsperiode',
    'limit__max_site_builder' => 'Websteder, udgivet med Presence Builder',
    'limit__max_site' => 'Domæner',
    'limit__mssql_dbase_filesize' => 'MS SQL-database filstørrelse',
    'limit__mssql_dbase_log_filesize' => 'MS SQL database logfilstørrelse',
    'limit__mssql_dbase_filesize_hint' => 'En fil\'s maksimale størrelse i en Microsoft SQL-database.',
    'limit__mssql_dbase_log_filesize_hint' => 'En logfil\'s maksimale størrelse i en Microsoft SQL-database.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Ugyldig domænegrænse Minimumværdien er 1.',

    'property__has_wrong_value' => 'Egenskaben %1 har en forkert værdi.',
    'property__name_outgoing_messages_domain_limit' => 'Indstiller begrænsning af udgående e-mails fra et domæne (pr. time).  Hvis du vil indstille en ubegrænset værdi, skal du skrive "-1". Skriv "default" for at indstille den værdi, der er angivet i de overordnede serverindstillinger.',
    'property__name_outgoing_messages_mbox_limit' => 'Indstiller begrænsning af udgående e-mails fra en mailboks (pr. time). Hvis du vil indstille en ubegrænset værdi, skal du skrive "-1". Skriv "default" for at indstille den værdi, der er angivet i de overordnede serverindstillinger.',
    'property__name_outgoing_messages_subscription_limit' => 'Indstiller begrænsning af udgående e-mails fra et abonnement (pr. time). Hvis du vil indstille en ubegrænset værdi, skal du skrive "-1". Skriv "default" for at indstille den værdi, der er angivet i de overordnede serverindstillinger.',

    // for CLI report & email notifications
    '__resource_notify' => 'Give besked',
    '__general' => 'Generelt',
    '__template_shared' => 'Delte skabelon',
    'limit__overuse' => 'Overforbrugspolitik',
    'limit__max_traffic_soft' => 'Adviser når trafik-forbrugsgrænsen når',
    'limit__disk_space_soft' => 'Adviser når diskplads-forbrugsgrænsen når',
    '__overuse' => 'Overforbrugspolitik',
    'performance__title' => 'Ydelse',
    'performance__bandwidth' => 'Maksimal båndbredde-anvendelse (KB/s)',
    'performance__max_connections' => 'Tilslutninger begrænset til',

    'gch__hosting_php_isapi' => 'Kør PHP som et JSAPI-udvidelse',
    'gch__hosting_ssi_html' => 'Brug SSI til *.htm, *.html filer',
    'gch__hosting_php_handler_type' => 'Kør PHP som',
    'gch__hosting_php_handler_id' => 'Kør PHP som',
    'gch__hosting_php_served_by_nginx' => 'PHP betjent af nginx',
    'gch__hosting_unpaid_website_status' => 'Status for websteder i suspenderede abonnementer',
    'gch__mn_no_autoresponder' => 'Der er ingen auto-svar oprettet til e-mailkontoen.',
    'gch__no_clients_selected' => "Der er ikke valgt nogen kundekonti.",
    'gch__no_domains_selected' => "Ingen domæner valgt",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/måned",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Resursenavn',
    '__resource_usage' => 'Forbrugt',
    '__resource_limit' => 'Begrænsning',

    '__used' => 'Forbrugt',
    '__limit' => 'Begrænsning',

    '__never_expires' => 'Udløber aldrig',
    '__resource_free' => '%1 ledig af %2',
    '__resource_unlimited' => '%1 brugt af Ubegrænset',

    '__unlimited' => 'Ubegrænset',
    '__increment' => "Forøg (+)",
    '__decrement' => "Formindsk (-)",
    '__pt' => 'enheder',
    '__procent' => '%',
    '__overused' => 'Overforbrugt',
    '__left' => 'venstre',
    '__available' => 'til rådighed',
    '__not_available' => 'Ikke inkluderet',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Leveringsplan',
    'ui__admin/report/layout/auto_unknown__title' => 'Rapportleveringsplan',
    'ui__admin/report/layout/auto_unknown__description' => 'Vælg rapportleveringsplan for et rapportlayout.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Tilføj rapportleveringsplan.',
    'ui__admin/report/layout/auto/properties_new__title' => 'Tilføj rapportleveringsplan.',
    'ui__admin/report/layout/auto/properties_new__description' => 'Tilføj en rapportleveringsplan for rapporten %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Rapportleveringsplan',
    'ui__admin/report/layout/auto/properties__title' => 'Rapportleveringsplan',
    'ui__admin/report/layout/auto/properties__description' => 'Se og rediger egenskaber for rapportleveringsplan.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Fjern rapportleveringsplan.',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Fjern rapportleveringsplan.',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Fjern valgte rapportleveringsplaner.',

    'ui__admin/report/layout_unknown__short-title' => 'Rapportlayouts',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Vis trafikforbrug for <b>%1</b>',
    'ui__reseller/traffic__description' => 'Vis trafikforbrugsrapport for forhandlerkonto %1.',
    'ui__reseller/traffic_self__short-title' => 'Min',
    'ui__reseller/traffic_self__title' => 'Se trafikforbrug sorteret efter kunder',
    'ui__reseller/traffic_self__description' => 'Vis trafikforbrugsrapport for dine kunders konti.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Forhandlernavn', // reseller report
    'report__full_client_name' => 'Kundenavn', // customer report
    'report__full_domain_name' => 'Domænenavn', // domain report
    'report__full_owner' => 'Ejer', // customer & domain reports
    'report__full_creation_date' => 'Oprettelsesdato',
    'report__full_size' => 'Størrelse',
    'report__full_traffic' => 'Trafik',
    'report__full_active_clients' => 'Aktive kunder', // reseller report
    'report__full_clients' => 'Kunder', // reseller report
    'report__full_active_domains' => 'Aktive domæner', // reseller & customer reports
    'report__full_domains' => 'Domæner', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'MBoxes',
    'report__full_disk_space' => 'Diskplads',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MariaDB/MySQL-DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'Generelt',
    'report__version' => 'Produktversion',
    'report__build' => 'Produktbuild',
    'report__status' => 'Status',
    'report__company_name' => 'Firmanavn',
    'report__personal_name' => 'Personligt navn',
    'report__login' => 'Brugernavn',
    'report__phone' => 'Telefon',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Adresse',
    'report__city' => 'By',
    'report__state' => 'Stat/region',
    'report__zip_code' => 'Postnummer.',
    'report__country' => 'Land',
    'report__creation_date' => 'Oprettelsesdato',
    'report__expiration_date' => 'Udløbsdato',
    'report__dumps_total_size' => 'Samlet sikkerhedskopifilstørrelse',
    'report__section_resellers' => 'Forhandlere',
    'report__active_resellers' => 'Forhandlere med aktive abonnementer',
    'report__resellers' => 'Forhandlere',
    'report__section_full_resellers' => 'Forhandlere',
    'report__section_clients' => 'Kunder',
    'report__active_clients' => 'kunder med aktive abonnementer',
    'report__clients' => 'Kunder',
    'report__section_full_clients' => 'Kunder',
    'report__section_personal_clients' => 'Egne kunder',
    'report__active_personal_clients' => 'Dine egne kunder med aktive abonnementer',
    'report__personal_clients' => 'Egne kunder',
    'report__section_full_personal_clients' => 'Egne kunder',
    'report__section_domains' => 'Domæner',
    'report__disk_usage' => 'Diskforbrug',
    'report__traffic' => 'Trafik',
    'report__active_domains' => 'Aktive domæner',
    'report__domains' => 'Domæner',
    'report__subdomains' => 'Subdomæner',
    'report__mboxes' => 'Mailbokse',
    'report__mail_groups' => 'Mail-videresendelser',
    'report__mail_autoresp' => 'Autosvar',
    'report__mail_lists' => 'Mailing Lists',
    'report__web_users' => 'Webbrugere',
    'report__mysql_databases' => 'MariaDB/MySQL-databaser',
    'report__mssql_databases' => 'MSSQL-databaser',
    'report__pgsql_databases' => 'PostgreSQL-databaser',
    'report__section_full_domains' => 'Domæner',
    'report__section_personal_domains' => 'Personlige domæner',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Personlige domæner',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Websteder, udgivet med Presence Builder',
    'report__invalid_email' => 'Angiv en gyldig e-mail-adresse.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Webbrugere',
    'report__section_mailnames' => 'Mailkonti',
    'report__section_maillists' => 'Mailinglister',
    'report__section_databases' => 'Databaser',
    'report__section_siteapps' => 'Web-applikationer',
    'report__section_aspnetapps' => 'ASP.NET-programmer', // PFW
    'report__owner_pname' => "Udbyderens personlige navn",
    'report__owner_login' => "Udbyderens brugernavn",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Leveringsplan',
    'ui__reseller/report/layout/auto_unknown__title' => 'Rapportleveringsplan',
    'ui__reseller/report/layout/auto_unknown__description' => 'Vælg rapportleveringsplan for et rapportlayout.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Tilføj rapportleveringsplan.',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Tilføj rapportleveringsplan.',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Tilføj en rapportleveringsplan for rapporten %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Rapportleveringsplan',
    'ui__reseller/report/layout/auto/properties__title' => 'Rapportleveringsplan',
    'ui__reseller/report/layout/auto/properties__description' => 'Se og rediger egenskaber for rapportleveringsplan.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Fjern rapportleveringsplan.',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Fjern rapportleveringsplan.',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Fjern valgte rapportleveringsplaner.',

    'ui__reseller/report/layout_unknown__short-title' => 'Rapportlayouts',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Vis trafikforbrug for <b>%1</b>',
    'ui__client/traffic__description' => 'Vis trafikforbrugsrapport for kundekonto %1.',
    'ui__client/traffic_self__short-title' => 'Trafikforbrug',
    'ui__client/traffic_self__title' => 'Trafikforbrug efter domæner',
    'ui__client/traffic_self__description' => 'Vis trafikforbrugsrapport for dine domæner.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Den ønskede sprogpakke er installeret, men ikke aktiveret i systemet.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Slet sessioner',
    'ui__sessions/delete__title' => 'Slet sessioner',
    'ui__sessions/delete__description' => 'Slet de markerede sessioner.',
    'ui__ftp-sessions__short-title' => 'FTP--sessioner',
    'ui__ftp-sessions__title' => 'FTP--sessioner',
    'ui__ftp-sessions__description' => 'Vis FTP-sessioner',
    'ui__ftp-sessions/delete__short-title' => 'Slet FTP-sessioner',
    'ui__ftp-sessions/delete__title' => 'Slet FTP-sessioner',
    'ui__ftp-sessions/delete__description' => 'Slet markerede FTP-sessioner',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Slet sessioner',
    'ui__reseller/sessions/delete__title' => 'Slet sessioner',
    'ui__reseller/sessions/delete__description' => 'Slet de markerede sessioner.',
    'ui__reseller/sessions/delete_self__short-title' => 'Slet sessioner',
    'ui__reseller/sessions/delete_self__title' => 'Slet sessioner',
    'ui__reseller/sessions/delete_self__description' => 'Slet de markerede sessioner.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP--sessioner',
    'ui__reseller/ftp-sessions__title' => 'FTP--sessioner',
    'ui__reseller/ftp-sessions__description' => 'Vis FTP-sessioner',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP--sessioner',
    'ui__reseller/ftp-sessions_self__title' => 'FTP--sessioner',
    'ui__reseller/ftp-sessions_self__description' => 'Vis FTP-sessioner',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Slet FTP-sessioner',
    'ui__reseller/ftp-sessions/delete__title' => 'Slet FTP-sessioner',
    'ui__reseller/ftp-sessions/delete__description' => 'Slet markerede FTP-sessioner',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Slet FTP-sessioner',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Slet FTP-sessioner.',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Slet markerede FTP-sessioner',

    // customer
    'ui__client/sessions/delete__short-title' => 'Slet sessioner',
    'ui__client/sessions/delete__title' => 'Slet sessioner',
    'ui__client/sessions/delete__description' => 'Slet de markerede sessioner.',
    'ui__client/sessions/delete_self__short-title' => 'Slet sessioner',
    'ui__client/sessions/delete_self__title' => 'Slet sessioner',
    'ui__client/sessions/delete_self__description' => 'Slet de markerede sessioner.',

    // domain administrator

    'forgery_token_expired' => 'Sessionstoken er udløbet.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Følgende forhandlerkonti vil blive konverteret til kundekonti',
    'downgradeResellers__downgrade' => 'Forhandlerkonti der vil blive konverteret',
    // controls
    'downgradeResellers__submit_downgrade' => 'Udfør kontokonvertering.',
    'downgradeResellers__cancel_downgrade' => 'Annuller kontokonvertering.',
    'downgradeResellers__confirm' => 'Bekræft konvertering',
    'downgradeResellers__confirm_message' => 'Bekræft fortsættelse af kontokonvertering',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Vælg kundekonti',
    'upgradeClients__upgrade_clients' => 'Følgende kundekonti vil blive konverteret til forhandlerkonti',
    'upgradeClients__upgrade' => 'Kundekonti der vil blive konverteret',
    // controls
    'upgradeClients__submit_upgrade' => 'Udfør kontokonvertering.',
    'upgradeClients__cancel_upgrade' => 'Annuller kontokonvertering.',
    'upgradeClients__confirm' => 'Bekræft konvertering',
    'upgradeClients__confirm_message' => 'Bekræft fortsættelse af kontokonvertering',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Kan ikke konvertere kontoen \'%1\' til en forhandlerkonto: \'%1\' er allerede en forhandler.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Følgende domæneadministratorkonti vil blive konverteret til kundekonti:',
    'upgradeDomainUser__upgrade' => 'Domæneadministratorkonti der vil blive konverteret',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Udfør kontokonvertering.',
    'upgradeDomainUser__cancel_upgrade' => 'Annuller kontokonvertering.',
    'upgradeDomainUser__confirm' => 'Bekræft konvertering',
    'upgradeDomainUser__confirm_message' => 'Bekræft fortsættelse af kontokonvertering',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Domæneadministratorkonti der ikke kan konverteres',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Følgende domæneadministratorkonti kunne ikke konverteres til kundekonti:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Flere domæneadministratorkonti kunne ikke konverteres til kundekonti: %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Domæneadministratorkontoen findes ikke.',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domænet skal høre direkte under server-administratoren eller en forhandler.",
    'upgradeDomainUser__all_logins_already_used' => 'Kan ikke oprette en konto for den resulterende kunde.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Domæneadministratorkonto blev konverteret',
    'upgradeDomainUser__upgrade_notification_body' => 'Din domæneadministratorkonto blev konverteret til en kundekonto med brugernavnet \'%%login%%\' og adgangskoden \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Vælg kundekonti',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Den valgte forhandler har ikke tilladelsen \'%1\', men nogle af kunderne har denne tilladelse.',
    'clientOwnerChanger__application_not_allowed' => 'Programmet \'%1\' er ikke til rådighed for den valgte forhandler, men det er til rådighed for nogle af kunderne.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Omtilknytter markerede abonnementer.',
    // errors
    'domain_chown__empty_selection' => 'Du skal vælge en ny ejer af de markerede domæner',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maksimal båndbredde-anvendelse (%1)',
    'hosting_performance__max_connection_label' => 'Tilslutninger begrænset til',
    'performance__invalid_value' => "Værdien er ugyldig Skal være i intervallet mellem %1 og %2",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Webmail-klienter til rådighed',
    'webmail__none' => 'Ingen',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Server IP-pulje',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Databasen vil ikke blive gendannet: der er ingen passende databaseserver',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Server-sikkerhedskopi.",
    '__default_backup_comment_reseller' => "Forhandlerkonto-sikkerhedskopi oprettet af %1.",
    '__default_backup_comment_client' => "Kundekonto-sikkerhedskopi oprettet af %1.",
    '__default_backup_comment_domain' => "Abonnements-sikkerhedskopi oprettet af %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "IP-pulje for kunden %1",
    'backup__ip_mapping__resellers_ip' => "IP-pulje for forhandleren %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtuel vært',
    'backup__restore__object_plesk_admin' => 'Plesk-administrator',
    'backup__restore__object_ftpuser' => 'FTP-konto',
    'backup__restore__object_frontpageuser' => 'FrontPage-konto',
    'backup__restore__object_webuser' => 'webbruger',
    'backup__restore__object_domain' => 'domæne',
    'backup__restore__object_subdomain' => 'subdomæne',
    'backup__restore__object_domainalias' => 'domænealias',
    'backup__restore__object_client' => 'kunde',
    'backup__restore__object_reseller' => 'forhandler',
    'backup__restore__object_autoresponder' => 'Autosvar',
    'backup__restore__object_mailalias' => 'mail-alias',
    'backup__restore__object_database' => 'database',
    'backup__restore__object_mailname' => 'mailkonto',
    'backup__restore__object_db_user' => 'databasebruger',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-certifikat',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Følgende forhandlere kan ikke gendannes, da de er konverteret til kunder: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Følgende kunder kan ikke gendannes, da de er konverteret til forhandlere: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Følgende kunder kan ikke gendannes, da de er flyttet til en anden server: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Utilstrækkelig diskplads på destinationsserveren til overførsel af alle de valgte abonnementer. Tilgængeligt: %1 MB. Påkrævet: %2 MB.  Bemærk, at den nødvendige plads beregnes som en sum af domænernes web, mail og databaseindhold.  Den nødvendige plads beregnes én gang dagligt og lagres i cache, så den faktiske domænestørrelse kan afvige fra den beregnede størrelse.  Hvis du sikrer dig, at de valgte domæner ikke optager mere plads end der er til rådighed, kan du fortsætte overførslen.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Frigør diskplads på destinationsserveren.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Utilstrækkelig diskplads på kildeserveren til lagring af midlertidige filer til overførsel. Tilgængeligt: %1 MB. Påkrævet: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Frigør diskplads på kildeserveren.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Serveroplysninger',

    'backup__restore__capability_not_installed_component_text' => 'Komponenten %1 er ikke installeret på destinationsserveren. %1 vil være utilgængelig for alle gendannede objekter.',
    'backup__restore__capability_not_installed_component_resolution' => 'Installer %1. Bemærk, at dette kan vare nogle minutter.',
    'backup__restore__capability_existing_sys_user_text' => 'En systembruger med navnet %1 findes allerede på destinationsserveren.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Omdøb venligst den eksisterende systembruger på destinationsserveren.',
    'backup__restore__capability_license_usage_text' => 'Følgende ressourcegrænser (defineret vha. licensnøglen) vil blive overskredet på destinationsserveren efter dataoverførsel:',
    'backup__restore__capability_license_usage_resolution' => 'Installer venligst på destinationsserveren en anden licensnøgle, der kan levere den nødvendige mængde ressourcer.',
    'backup__restore__capability_max_allowed_packet_text' => "Parameteret 'max_allowed_packet' på kilde-databaseserveren er %1, der er større end på destinationsserveren, hvor det er %2. Nogle databaseobjekter for de domæner, der er angivet herunder, gendannes muligvis ikke.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Forøg værdien 'max_allowed_packet' på destinations-databaseserveren.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Kunne ikke overføre PostgreSQL-databaserne, da PostgreSQL-versionen på destinationsserveren er ældre end på kildeserveren. Den nuværende version er %1, den nødvendige version er %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Installer den ønskede version af PostgreSQL på destinationsserveren.',
    'backup__restore__capability_db_server_connection_problems' => 'Det kunne ikke oprettes forbindelse til PostgreSQL-databaseserveren. Databaser overføres ikke, medmindre du gendanner forbindelsen.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Kontroller forbindelsesindstillingerne på destinations-databaseserveren.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponenten %1 er deaktiveret på destinationsserveren.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Aktivér %1 på destinationsserveren.',
    'backup__restore__capability_not_configured_component_text' => 'Komponenten %1 er ikke konfigureret på destinationsserveren.',
    'backup__restore__capability_not_configured_component_resolution' => 'Konfigurér %1 på siden Funktioner og indstillinger.',

    'backup__restore__capability_webmail_is_not_available' => 'Webmail-servicen %1 er ikke til rådighed på destinationsserveren. I stedet vil Plesk bruge denne webmail-service: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Hvis du vil bruge den samme webmail som kildeserveren, skal du installere den på denne server.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Hvis du vil bruge den samme webmail som kildeserveren, skal du installere den på destinationsserveren.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Webmail-servicen '%1' er ikke til rådighed på destinationsserveren. I stedet vil Plesk for følgende abonnementer: %3, bruge denne webmail-service: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Installer den nødvendige webmail på destinationsserveren.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Webmail-indstillinger',

    'backup__restore__capability_shell_is_not_available' => 'Det er ikke muligt at finde dokumentet %1 på serveren. Shell %1 bruges i stedet.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Hvis du vil bruge den samme shell som kildeserveren, skal du aktivere den (i /etc/shells) eller installere den på destinationsserveren.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Destinations-DNS-server understøtter ikke netværk i skabelonen Overførselsbegrænsninger. Posterne med netværks-IP-adresser i DNS-overførselsbegrænsninger gendannes ikke.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Destinations-DNS-serveren understøtter ikke netværk i skabelonen Overførselsbegrænsninger, men nogle abonnementer har netværk i DNS-overførselsrestriktioner. Posterne med netværks-IP-adresser i DNS-overførselsbegrænsninger gendannes ikke.',

    'backup__restore__capability_wrong_php_handler_text' => 'PHP-handleren %1 er ikke til rådighed på destinationsserveren. I stedet vil Plesk bruge denne PHP-handler: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Hvis du vil bruge den samme PHP-handler som på kildeserveren, skal du aktivere eller installere den på destinationsserveren.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP-handleren %1 er ikke til rådighed. I stedet vil Plesk bruge %2 til følgende serviceplaner: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP-handleren %1 er ikke til rådighed. I stedet vil Plesk bruge %2 til følgende websteder: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP handleren %1 er ikke til rådighed. Den vil være utilgængelig for følgende websteder: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 og %2 er ikke til rådighed på destinationsserveren. Standardversionen bruges i stedet.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Hvis du vil bruge den samme %1 som kildeserveren, skal du aktivere eller installere den på destinationsserveren.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Antivirus-brugspolitikken på destinationsserveren tillader ikke personlige (pr. e-mailadresse) antivirus indstillinger for indkommende post. Disse indstillinger bliver ikke overført.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Antivirus-brugspolitikken på destinationsserveren tillader ikke personlige (pr. e-mailadresse) antivirus indstillinger for indkommende post. Disse indstillinger bliver ikke overført.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Antivirus-brugspolitikken på destinationsserveren tillader ikke personlige (pr. e-mailadresse) antivirus indstillinger. Disse indstillinger bliver ikke overført.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Du kan overføre personlige (pr. e-mailadresse) antivirus indstillinger ved at aktivere de korresponderende indstillinger i sektionen Funktioner og indstillinger > indstillinger for virusbeskyttelse.",
    'backup__restore__capability_antivirus_not_active_text' => 'Ingen antivirus software aktiveret. Alle antivirus indstillingerne fra kildeserveren vil først fungere, når du vælger antivirus softwaren på destinationsserveren.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Vælg antivirus-softwaren i sektionen Funktioner og indstillinger > Indstillinger for virusbeskyttelse > Antivirus indstillinger.',

    'backup__restore__capability_antivirus_another_active_text' => 'Antivirus-softwaren %2 er ikke til rådighed på destinationsserveren. %1 bruges i stedet for.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Du kan bruge samme antivirus som på kildeserveren ved at installere det og vælge det i sektionen Funktioner og indstillinger > Indstillinger for virusbeskyttelse > Antivirus indstillinger.',
    'backup__restore__capability_not_available_sni_text' => 'SNI er ikke tilgængelig på destinationsserveren. Websteder, der har samme IP-adresse, vil ikke kunne bruge individuelle SSL/TLS- certifikater.',
    'backup__restore__capability_not_available_sni_resolution' => "Kontroller, at operativsystemet på destinationsserveren understøtter SNI og at understøttelse af SNI er aktiveret i Plesk (afkrydsningsfeltet 'Aktivér SNI-understøttelse, der tillader brug af individuelle SSL/TLS-certifikater på websteder med samme IP adresse' i Funktioner og indstillinger> Serverindstillinger).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Serverindstillinger',

    'backup__restore__capability_vhost_already_exists_text' => 'Webstedet %1 kan ikke overføres: der findes allerede et websted med det samme navn på destinationsserveren.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Omdøb eller fjern webstedet med samme navn på serveren.',
    'backup__restore__capability_removed_vhosts' => 'Følgende abonnementer vil ikke blive gendannet, da de indeholder de domænenavne der allerede findes på destinationsserveren: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'På kildeserveren er der %3 forskellige PHP-handlere af typen %1 og version %2. I stedet for disse vil en handler af passende type og version blive anvendt på destinationsserveren. Bemærk, at PHP-indstillingerne på kilde- og destinationsserveren kan være forskellige.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer understøtter ikke Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer understøtter ikke Python. Installer Python manuelt.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Mailserverindstillinger',

    'backup__restore__capability_ftps_disabled' => 'Brug af den sikre FTPS er tilladt på kildeserveren, men forbudt på målet.  Brugerprogrammer der bruger FTP fungerer muligvis ikke korrekt.',
    'backup__restore__capability_ftps_required' => 'Brug af ikke-sikker FTP er tilladt på kildeserveren, men forbudt på målet. Brugerprogrammer der bruger FTP fungerer muligvis ikke korrekt.',
    'backup__restore__capability_ftps_policy_resolution' => 'Rediger den sikre FTP-politik i Funktioner og indstillinger > Sikkerhedspolitik.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabytes data vil blive flyttet fra kildeserveren til destinationen om %2 timer.',
    'backup__restore__capability_too_much_download_time_resolution' => 'For en hurtigere overførsel bedes du tjekke din netværksforbindelse mellem kilde- og destinationsserverne og løse eventuelle problemer.',
    'backup__restore__too_low_download_speed' => "mindre end 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'For en hurtigere overførsel bedes du tjekke din netværksforbindelse mellem kilde- og destinationsserverne og løse eventuelle problemer.',
    'backup__restore__capability_zero_download_speed_text' => 'Den mindste acceptable downloadhastighed er %1 MBps. Downloadhastigheden mellem kilde- og destinationsserver er 0 MBps. Dette kan skyldes netværksforbindelsesproblemer. Overførsel er ikke mulig.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Tjek venligst din netværksforbindelse mellem kilde- og destinationsserverne og løse eventuelle problemer.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Den mindste acceptable downloadhastighed er %2 MBps. Downloadhastigheden mellem kilde- og destinationsserver er %1 MBps. Dette kan forøge overførselstiden.  I dit aktuelle miljø vil migrering af %3 MB tage %4 timer.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Den mindste acceptable downloadhastighed er %2 MBps. Downloadhastigheden mellem kilde- og destinationsserver er %1 MBps. Dette kan forøge overførselstiden.',

    'backup__restore__capability_remote_database_migration' => "Følgende domæner bruger eksterne databaser: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Fjern ikke disse domæner fra kildeserveren efter overførslen, hvis Plesk-versionen op kildeserveren er tidligere end 11.5! Suspendér dem i stedet. Hvis du fjerner domænerne, vil databaserne blive fjernet fra den eksterne server. Bemærk: De eksterne databasers dump-filer vil blive lagret på kildeserveren i mappen %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Sikkerhesskopifiler af MySQL databaseservere tidligere end 5.1 (%1) gendannes muligvis ikke på MySQL 5.1.x, fordi MySQL 5.1.x håndterer Unicode-tegn anderledes.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Læs den relaterede "knowledge base" artikel nr. 136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP er ikke installeret på destinationsserveren.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Installér Courier-IMAP vha. Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot er ikke installeret på destinationsserveren.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Installér Dovecot vha. Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Trafikstatistik tilbageholdelsestid i konfigurationer af de efterfølgende objekter er mindre end den overordnede serverværdi på destinationsserveren.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Rediger den overordnede serverværdi for statistisk tilbageholdelsestid på destinationsserveren. Sæt denne tid til at være lig med eller mindre end den mindste værdi i domænernes konfigurationer.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Trafikstatistik tilbageholdelsestid på visse domæner er mindre end den overordnede serverværdi (%1). Værdien vil blive ændret til %1 for disse domæner.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Tidsperioden for opbevaring af trafikstatistik i nogle serviceplaner er mindre end den overordnede serverværdi (%1). Værdien vil blive ændret til %1 for disse serviceplaner.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Tilknytning af en eksklusiv IP-adresse til en delt adresse vil deaktivere anonym FTP og HTTPS (medmindre SNI-understøttelse er aktiveret).',

    'backup__restore__no_postgresql_commands_text' => 'Abonnementet anvender en ekstern PostgreSQL database, og den midlertidige sikkerhedskopifil af denne kan ikke genereres, da pg_dump og psql kommandoerne mangler på kildeserveren.',
    'backup__restore__no_postgresql_commands_resolution' => 'Installér en PostgreSQL klientpakke, der understøtter disse kommandoer.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Følgende Apache-moduler er deaktiverede på destinationsserveren: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Aktivér venligst disse moduler for at forhindre mulige problemer.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Følgende Apache-moduler er ikke installerede på destinationsserveren: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Installer og aktiver venligst disse moduler for at forhindre mulige problemer.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Begrænsning af udgående meddelelser understøttes ikke af din licens. De korresponderende konfigurationsindstillinger vil ikke blive overført.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Installér en anden licensnøgle på serveren, der indeholder de nødvendige funktioner.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Begrænsningen af udgående meddelelser er deaktiveret på destinationsserveren.  De korresponderende konfigurationsindstillinger vil ikke blive overført.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Aktivér begrænsning af udgående meddelelser på destinationsserveren.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Server-brede e-mail indstillinger',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Begrænsningen af udgående meddelelser fra en mailboks der ikke understøttes af den mailserver der anvendes på destinationsserveren. Værdien af denne grænse vil ikke blive overført.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Redigér mailserveren til det samme som du bruger på kildeserveren.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Server-brede e-mail indstillinger',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Begrænsningen af udgående meddelelser fra et domæne, der ikke understøttes af den mailserver der anvendes på destinationsserveren.  Værdien af denne grænse vil ikke blive overført.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Redigér mailserveren til det samme som du bruger på kildeserveren.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Server-brede e-mail indstillinger',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Begrænsningen af udgående meddelelser fra et domæne der ikke understøttes af den mailserver der anvendes på destinationsserveren. Værdien af denne grænse vil ikke blive overført.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Redigér mailserveren til det samme som du bruger på kildeserveren.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Server-brede e-mail indstillinger',

    'bu_conflict_resolver_absent_phosting' => 'Kan ikke gendanne de specificerede filer, da fysisk hosting til gendannelse af dem ikke findes.  Opret et domæne med fysisk hosting først, og start derefter gendannelsen af sikkerhedskopien igen.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Forhandlerens data vil ikke blive gendannede, da forhandleradministration ikke er understøttet.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'ModSecurity-komponenten er ikke installeret på destinationsserveren.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Installér ModSecurity for at bevare webprogram-firewall fungerende for de overførte websteder. Bemærk, at installationen kan vare nogle få minutter.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installér ModSecurity hvis du vil overføre programfirewall-indstillingerne. Bemærk, at installationen kan vare nogle få minutter.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'ModSecurity-komponenten er ikke konfigureret på destinationsserveren.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Aktivér ModSecurity hvis du vil bevare en fungerende programfirewall for de overførte websteder.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Webprogram firewall (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity er deaktiveret på destinationsserveren.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktivér ModSecurity hvis du vil bevare en fungerende programfirewall for de overførte websteder.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Webprogram firewall (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Komponenten ModSecurity er ikke installeret.  Webprogram-firewallindstillingerne vil ikke blive gendannet for følgende objekter: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Websteder kan ikke gendannes, da de hører til abonnementet %1, der ikke findes i Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Komponenten %1 er ikke installeret på destinationsserveren. DNS-service vil ikke være til rådighed, og DNS-indstillingerne vil gå tabt. Alle kunders websteder vil være nede.',
    'bu_conflict_resolver_dns_not_installed' => 'DNS-service er ikke installeret. DNS-indstillingerne vil ikke blive gendannet for følgende objekter: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Følgende abonnementer kan ikke gendannes, da de er flyttet til andre ejere: \'%1\'.',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Følgende abonnementer kan ikke gendannes, da de er flyttet til andre udbydere: \'%1\'.',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Kunne ikke finde Web Presence Builder gendannelsesværktøjet til gendannelse af Web Presence Builder data. Presence Builder er sandsynligvis ikke installeret.',
    'backup__restore__capability_renamed_db' => 'Databasenavnet "%1" bruges allerede af et andet abonnement. Navnet på den gendannede database ændres til "%2".',
    'backup__restore__capability_renamed_db_user' => 'Database-brugernavnet "%1" bruges allerede af et andet abonnement. Navnet på den gendannede databasebruger ændres til "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer understøtter ikke Perl. Installer ActiveState Perl manuelt.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% betjent af Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% betjent af nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Ressourceforbrugskonflikter',
    'backup__restore__hint_resource_usage_conflicts' => 'Ressourceforbrugskonflikter opstår, når ressourceforbrugsgrænserne for det gendannede objekt overskrides under gendannelsen.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Tillad overforbrug',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Gendan objekt og lad det bruge flere ressourcer end oprindeligt tildelt.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Gendan ikke',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Gendan ikke objekter, der har ressourceforbrugskonflikter.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konfigurationskonflikter',
    'backup__restore__hint_configuration_conflicts' => 'Der opstod en konfigurationskonflikt, da det gendannede objekt har indstilling og webprogrammer, der ikke er til rådighed eller som er forbudt på den nuværende server eller iht objektejerens politik. Eksempelvis vil der opstå konfigurationskonflikter, hvis overførte e-mailkonti har individuelle spamfilter-indstillinger, mens den overordnede serverpolitik forbyder at e-mailkonti har sådanne indstillinger.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatisk',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Gendan objekt og aktiver automatisk alle konfliktende konfigurationsindstillinger, som dine tilladelser giver dig lov til at administrere.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Gendan ikke',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Gendan ikke objekter, der har konfigurationskonflikter.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Dedikerede IIS-programgrupper er ikke tilladt i IIS-programgruppeindstillingerne.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Rediger dine IIS-programgruppeindstillinger under Funktioner og indstillinger > IIS programgruppe > Globale indstillinger.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Delte IIS-programgrupper er ikke tilladt i IIS-programgruppeindstillingerne.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Rediger dine IIS-programgruppeindstillinger under Funktioner og indstillinger > IIS programgruppe > Globale indstillinger.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Korte POP3/IMAP e-mailkontonavne er ikke tilladt på destinationsserveren.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Korte navne for e-mailkonti, der ikke vil være til rådighed efter gendannelse af data.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Det er ikke muligt at åbne logfilen.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Kan ikke gendanne abonnementet %1: det blev fjernet fra din konto, og du har ikke tilladelse til at oprette abonnementer. Hvis du har brug for at gendanne det, bedes du kontakte din serviceudbyder.',

    'backup__error11' => 'Utilstrækkelig diskplads til sikkerhedskopiering.',
    'backup__error3011' => 'Forbindelsen blev afvist: Ingen programmer lytter på den specificerede adresse og port.',
    'backup__error3012' => 'Forbindelsestimeout.',
    'backup__error3013' => 'Netværket kan ikke nås.',
    'backup__error3014' => 'Inge rute til host.',
    'backup__error3015' => 'Tilslutning mislykkedes.',
    'backup__error3016' => 'Kan ikke fortolke hostnavnet.',
    'backup__error3017' => 'Forkert brugernavn og adgangskode.',
    'backup__error3018' => 'SSH-forbindelse mislykkedes.',

    'backup__error3110' => 'kan ikke forbinde til ekstern migreringsagent: Forbindelse til host ikke til rådighed.',
    'backup__error3111' => 'Migrationsagenten er låst af en mislykket migreringsopgave eller bruges af en anden migreringsproces.  Genstart migreringsagenten på kildeserveren.',
    'backup__error3112' => 'Forbindelse til hosten er ikke til rådighed, eller migreringsagenten kører ikke på kildehost.',
    'backup__error3113' => 'Kan ikke deployere migreringsagenten til en Linux host.  Kontrollér SSH-forbindelsen til kilde-hosten.',
    'backup__error3114' => 'Kan ikke deployere migreringsagenten til en Linux host: SSH-forbindelsen mislykkedes.',
    'backup__error3115' => 'Forkert brugernavn og adgangskode.',
    'backup__error3116' => 'Den angivne bruger har ikke administrative tilladelser.',

    'dns_t__unable_to_remove_ns_record' => 'Kunne ikke fjerne NS-posten fra DNS-skabelonen: Hver DNS-zone skal indeholde mindst én NS-post.',
    'dns__unsupported_server_zone_transfer' => 'Kunne ikke overføre skabelonen Overførselsrestriktioner, på grund af domænernes DNS-konfiguration: På kildeserveren er de følgende netværksadresser tilladt til zone-overførsel, men disse adresser er forbudt af Microsoft DNS Server: %1',
    'dns__unsupported_domain_zone_transfer' => 'Kunne ikke overføre skabelonen Overførselsrestriktioner, på grund af domænernes DNS-konfiguration: På nogle domæner er de følgende netværksadresser tilladt til zone-overførsel, men disse adresser er forbudt af Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Kan ikke få adgang til den delte midlertidige netværksmappe til sikkerhedskopieringsfiler.  Kontrollér netværksmappen, brugernavnet og adgangskodeindstillingerne. Fejl: %1',

    'migration_select_exist_db_server' => 'Vælg destinations-databaseserver',

    'dbbackup__temp_dir_wrong_value' => 'En ugyldig værdi den midlertidige mappe blev angivet.',
    'dbbackup__network_temp_dir_wrong_value' => 'En ugyldig værdi den midlertidige netværksmappe blev angivet.',
    'dbbackup__server_backup_not_configured' => 'Database-sikkerhedskopiindstillingerne er ikke konfigurerede på serveren.',
    'dbbackup__temp_dir' => 'Midlertidigt bibliotek',
    'dbbackup__temp_dir_hint' => 'Stien til den fysiske mappe på den eksterne server, hvor MS SQL-serveren er placeret. MS SQL-serveren skal kunne få adgang til denne mappe til læsning og skrivning af midlertidige sikkerhedskopifiler. F.eks. C:\\MappeSti',
    'dbbackup__network_temp_dir_hint' => 'Stien til netværksshare for den ovenfor angivne fysiske mappe. Plesk vil tilgå den delte mappe ved op- og download af sikkerhedskopifiler. Eksempelvis \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Brugernavnet på en netværksbruger, oprettet på den eksterne server. Eksempelvis ServerName\\UserName. Brugeren skal have adgang til den ovenfor angivne delte mappe.',
    'dbbackup__network_password_hint' => 'Netværksbrugerens adgangskode',

    'dbbackup__success_import_without_dublicate_users' => 'Følgende brugere blev ikke importeret: %1. De findes allerede på databaseserveren.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Komprimer logfiler",
    'log_rot__log_rot_status' => "Logrotationsstatus",
    'log_rot__log_rot_period' => "Logrotationstilstand",
    'log_rot__log_rot_size' => "efter størrelse",
    'log_rot__log_rot_time' => "efter tidspunkt",
    'log_rot__logrotation_enable' => "Aktivér logrotation",
    'log_rot__mail' => "Send behandlede logfiler til e-mailadressen",
    'log_rot__max_number_of_logfiles' => "Maksimalt antal logfiler",
    'log_rot__time_period' => "periode",
    'log_rot__unable_turn_off' => 'Kan ikke deaktivere en logrotation, da denne er påtvunget af serveren',
    'log_rot__unable_set_period' => 'Kan ikke indstille en logrotationsperiode, der er anderledes end \'daglig\', da denne er påtvunget af serveren',
    'log_rot__unable_set_max_log_files' => 'Kan ikke indstille et maksimalt antal logfiler, der er større end den serverbrede grænse på %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Der forventedes et tal: %1",
    'actionlog__incorrect_rotation' => "Ugyldig logrotationsparametre angivet: %1",
    'actionlog__unknown_rot_period' => "Ukendt rotationsperiode: %1",
    'actionlog__unknown_rot_type' => "Ukendt rotationstype: %1",
    'actionlog__session_preferences' => 'Indstillinger for session',
    'actionlog__nis2_delete_prohibited' => 'Det er ikke tilladt at fjerne logposter på grund af de gældende begrænsninger i NIS2-direktivet.',
    'actionlog__nis2_forbidden_rot_type' => "Logrotationstypen '%1' kan ikke anvendes på grund af de gældende begrænsninger i NIS2-direktivet.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Administratorinformation',
    'actionlog__admin_preferences' => "Administrators indstillinger",
    'actionlog__service' => 'Service',
    'actionlog__ip_addr' => 'IP-adresse',
    'actionlog__client' => 'Debitorkonto',
    'actionlog__client_status' => 'Kundekontostatus',
    'actionlog__client_preferences' => "Kundens grænsefladepræferencer",
    'actionlog__client_ip_pool' => "Kundens IP-pulje",
    'actionlog__client_siteapp' => "Kundens webprogram gruppe",
    'actionlog__client_guid' => "Debitor-GUID",
    'actionlog__domain' => 'Standarddomæne (det første domæne, der føjes til et abonnement)',
    'actionlog__domain_owner' => 'Abonnementsejer',
    'actionlog__domain_plan' => 'Serviceplan for abonnement',
    'actionlog__domain_status' => 'Standarddomæne, status',
    'actionlog__domain_dns' => 'Standarddomæne, DNS-zone',
    'actionlog__subdomain' => 'Underdomæne til et standarddomæne',
    'actionlog__domain_alias' => 'Standarddomæne, alias',
    'actionlog__domain_alias_dns' => 'Standarddomæne, alias DNS-zone',
    'actionlog__site' => 'Domæne',
    'actionlog__site_status' => 'Domænestatus',
    'actionlog__site_dns' => 'Domænets DNS-zone',
    'actionlog__site_guid' => 'Domæne-GUID',
    'actionlog__site_subdomain' => 'Subdomæne',
    'actionlog__site_alias' => 'Domænealias',
    'actionlog__site_alias_dns' => 'Domænealias DNS-zone',
    'actionlog__domain_limits' => 'Abonnementsbegrænsninger',
    'actionlog__domain_limit_size' => 'Diskpladsgrænse for abonnement',
    'actionlog__domain_limit_traffic' => 'Abonnementets trafikgrænse',
    'actionlog__domain_limits_powerUser' => 'Abonnementsbegrænsninger',
    'actionlog__domain_limit_size_powerUser' => 'Diskpladsgrænse for abonnement',
    'actionlog__domain_limit_traffic_powerUser' => 'Abonnementets trafikgrænse',
    'actionlog__domain_guid' => "Standarddomæne, GUID",
    'actionlog__cp_user' => 'Plesk-bruger',
    'actionlog__mailname' => 'Mailkonto',
    'actionlog__maillist' => 'Maillister',
    'actionlog__phosting' => 'Hosting-indstillinger',
    'actionlog__forwarding' => 'Standard eller ramme-videresendelseshosting',
    'actionlog__webuser' => 'Webbrugerkonto',
    'actionlog__site_application' => 'Webprogram',
    'actionlog__license' => 'Licensnøgle',
    'actionlog__additional_license' => 'Ekstra licensnøgle',
    'actionlog__template_domain' => "Serviceplan for forhandler",
    'actionlog__template_admin' => "Serviceplan for administrator",
    'actionlog__template_reseller' => 'Forhandlerplan',
    'actionlog__admin_alias' => 'Ekstra administratorkonto', // PFW
    'actionlog__ftpuser' => 'Ekstra FTP-konto', // PFW
    'actionlog__db_server' => 'Databaseserver',
    'actionlog__db' => 'Database',
    'actionlog__db_user' => 'Databasebruger-konto',
    'actionlog__client_sapppkg_pool' => "Brugerens webprogram", // PFW, not used?
    'actionlog__remote_dns' => 'Ekstern DNS-server status', // PFW
    'actionlog__reseller' => 'Forhandlerkonto',
    'actionlog__reseller_guid' => 'Forhandler-GUID',
    'actionlog__reseller_ip_pool' => "Forhandlers IP-pulje",
    'actionlog__reseller_limit_size' => 'Diskpladsgrænse for forhandlerkonto',
    'actionlog__reseller_limit_traffic' => 'Trafikgrænse for forhandlerkonto',
    'actionlog__reseller_limits' => 'Forhandlerkontogrænser',
    'actionlog__reseller_permissions' => 'Forhandlertilladelser',
    'actionlog__reseller_preferences' => "Forhandlerens grænsefladepræferencer",
    'actionlog__reseller_siteapp' => "Webprogrammer i forhandlerens pulje",
    'actionlog__reseller_status' => 'Forhandlerkontostatus',
    'actionlog__health_status' => 'Server-sundhedsstatus',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'nået',
    'actionlog__added' => 'tilføjet',
    'actionlog__removed' => 'fjernet',
    'actionlog__change' => 'ændret',
    'actionlog__update' => 'opdateret',
    'actionlog__move' => 'flyttet',
    'actionlog__upgrade' => 'opgraderet', // PFU?
    'actionlog__update_or_add' => 'opdateret eller tilføjet',
    'actionlog__expired' => 'udløbet',
    'actionlog__create' => 'oprettet',
    'actionlog__delete' => 'slettet',
    'actionlog__service_stop' => 'stoppet',
    'actionlog__service_restart' => 'genstartet',
    'actionlog__service_start' => 'startet',
    'actionlog__login' => 'logget ind',
    'actionlog__logout' => 'Logget ud',
    'actionlog__install' => 'installeret',
    'actionlog__uninstall' => 'opgraderet',
    'actionlog__reconfigure' => 'omkonfigureret',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Anmodninger om nulstilling af adgangskode',
    'actionlog__event_admin_update' => 'Administratoroplysninger opdaterede',
    'actionlog__event_admin_preferences_update' => "Administrators præferencer opdateret",
    'actionlog__event_service_restart' => 'Service er genstartet',
    'actionlog__event_service_start' => 'Tjenesten er startet',
    'actionlog__event_service_stop' => 'Tjenesten stoppede',
    'actionlog__event_ip_address_create' => 'IP-adresse oprettet',
    'actionlog__event_ip_address_delete' => 'IP-adresse slettet.',
    'actionlog__event_ip_address_update' => 'IP-adresse opdateret',
    'actionlog__event_client_create' => 'Kundekonto er oprettet',
    'actionlog__event_client_delete' => 'Kundekonto er slettet',
    'actionlog__event_client_update' => 'Kundekonto opdateret',
    'actionlog__event_client_status_update' => 'Kundekontostatus opdateret',
    'actionlog__event_client_preferences_update' => "Kundens grænsefladepræferencer er opdateret",
    'actionlog__event_client_siteapp_added' => "Webprogrammet er føjet til kundekontoens programgruppe",
    'actionlog__event_client_siteapp_removed' => "Webprogrammet er fjernet fra kundekontoens programgruppe",
    'actionlog__event_domain_limit_size_reached' => 'Diskpladsgrænse for abonnement er nået',
    'actionlog__event_domain_limit_traffic_reached' => 'Trafikgrænse for abonnement er nået',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Diskpladsgrænse for abonnement er nået',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Trafikgrænse for abonnement er nået',

    'actionlog__domain_limit_database' => 'Databasekvota for abonnement',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'MariaDB/MySQL databasekvote for abonnement nået',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'MariaDB/MySQL database-softkvote for abonnement nået',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Microsoft SQL serverdatabase-kvote for abonnement nået',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Microsoft SQL serverdatabase-softkvote for abonnement nået',
    'actionlog__event_plesk_component_upgrade' => 'Plesk-komponent opdateret',
    'actionlog__event_plesk_component_install' => 'Plesk-komponent installeret',
    'actionlog__event_plesk_component_uninstall' => 'Plesk-komponent afinstalleret',
    'actionlog__event_domain_create' => 'Standarddomæne (det første domæne føjet til et abonnement) oprettet',
    'actionlog__event_domain_delete' => 'Standarddomæne (det første domæne føjet til et abonnement) slettet',
    'actionlog__event_domain_update' => 'Standarddomæne (det første domæne føjet til et abonnement) opdateret',
    'actionlog__event_domain_owner_change' => 'Abonnementsejeren ændret',
    'actionlog__event_domain_plan_change' => 'Serviceplan for abonnement ændret',
    'actionlog__event_domain_status_update' => 'Standarddomæne, status opdateret',
    'actionlog__event_domain_dns_update' => 'Standarddomæne , DNS-zone opdateret',
    'actionlog__event_subdomain_create' => 'Underdomæne til standarddomæne oprettet',
    'actionlog__event_subdomain_delete' => 'Underdomæne til standarddomæne slettet',
    'actionlog__event_subdomain_update' => 'Underdomæne til et standarddomæne opdateret',
    'actionlog__event_domain_alias_create' => 'Standarddomæne, alias er oprettet',
    'actionlog__event_domain_alias_delete' => 'Standarddomæne, alias er slettet',
    'actionlog__event_domain_alias_update' => 'Standarddomæne, alias er opdateret',
    'actionlog__event_domain_limits_update' => 'Abonnementsgrænser opdateret',
    'actionlog__event_cp_user_login' => 'Pleskbruger logget ind',
    'actionlog__event_cp_user_logout' => 'Pleskbruger logget ud',
    'actionlog__event_mailname_create' => 'Mailkonto oprettet',
    'actionlog__event_mailname_delete' => 'Mailkonto slettet',
    'actionlog__event_mailname_update' => 'Mailkonto opdateret',
    'actionlog__event_maillist_create' => 'Mailliste er oprettet',
    'actionlog__event_maillist_delete' => 'Mailliste slettet',
    'actionlog__event_maillist_update' => 'Mailliste opdateret',
    'actionlog__event_phys_hosting_create' => 'Fysisk hosting er oprettet',
    'actionlog__event_phys_hosting_delete' => 'Fysisk hosting slettet',
    'actionlog__event_phys_hosting_update' => 'Fysisk hosting opdateret',
    'actionlog__event_forwarding_create' => 'Standard eller ramme-videresendelses hosting er oprettet',
    'actionlog__event_forwarding_delete' => 'Standard eller ramme-videresendelses hosting er slettet',
    'actionlog__event_forwarding_update' => 'Standard eller ramme-videresendelseshosting er opdateret',
    'actionlog__event_webuser_create' => 'Webbrugerkonto oprettet',
    'actionlog__event_webuser_delete' => 'Webbrugerkonto slettet',
    'actionlog__event_webuser_update' => 'Webbrugerkonto opdateret',
    'actionlog__event_siteapp_install' => 'Webprogram er installeret',
    'actionlog__event_siteapp_reconfigure' => 'Webprogram er omkonfigureret',
    'actionlog__event_siteapp_uninstall' => 'Webprogrammappe',
    'actionlog__event_license_update' => 'Licensnøgler er opdaterede',
    'actionlog__event_admin_alias_create' => 'Ekstra administratorkonto oprettet',
    'actionlog__event_admin_alias_delete' => 'Ekstra administratorkonto er slettet',
    'actionlog__event_admin_alias_update' => 'Ekstra administratorkonto opdateret',
    'actionlog__event_ftpuser_create' => 'Ekstra FTP-konto er oprettet',
    'actionlog__event_ftpuser_update' => 'Ekstra FTP-konto er opdateret',
    'actionlog__event_ftpuser_delete' => 'Ekstra FTP-konto er slettet',
    'actionlog__event_template_domain_create' => "Serviceplan for forhandler oprettet",
    'actionlog__event_template_domain_update' => "Serviceplan for forhandler opdateret",
    'actionlog__event_template_domain_delete' => "Serviceplan for forhandler slettet",
    'actionlog__event_template_admin_create' => "Serviceplan for administrator oprettet",
    'actionlog__event_template_admin_update' => "Serviceplan for administrator opdateret",
    'actionlog__event_template_admin_delete' => "Serviceplan for administrator slettet",
    'actionlog__event_database_server_create' => 'Databaseserver oprettet',
    'actionlog__event_database_server_update' => 'Databaseserver opdateret',
    'actionlog__event_database_server_delete' => 'Databaseserver slettet',
    'actionlog__event_remote_dns_status_update' => 'Ekstern DNS-server status opdateret',
    'actionlog__event_session_preferences_update' => 'Sessionsindstillinger er blevet opdateret.',
    'actionlog__event_domain_alias_dns_update' => 'Standarddomæne, DNS-zone for domænealias opdateret',
    'actionlog__event_domain_move' => 'Standarddomæne flyttet til et nyt abonnement',
    'actionlog__event_site_move' => 'Domæne flyttet til et nyt abonnement',
    'actionlog__event_site_subdomain_move' => 'Underdomæne flyttet til et nyt abonnement',
    'actionlog__event_subdomain_move' => 'Underdomæne på standarddomæne flyttet til et nyt abonnement',
    'actionlog__event_license_expired' => 'Plesklicensen er udløbet',
    'actionlog__event_database_create' => 'Database oprettet',
    'actionlog__event_database_delete' => 'Database fjernet',
    'actionlog__event_database_user_create' => 'Databasebrugerkonto oprettet',
    'actionlog__event_database_user_update' => 'Databasebrugerkonto-indstillinger er opdaterede',
    'actionlog__event_database_user_delete' => 'Databasebrugerkonto fjernet',
    'actionlog__event_client_guid_update' => "Kunde-GUID, opdateret",
    'actionlog__event_domain_guid_update' => 'Standarddomæne , GUID opdateret',
    'actionlog__event_reseller_create' => 'Forhandlerkonto oprettet',
    'actionlog__event_reseller_delete' => 'Forhandlerkonto slettet',
    'actionlog__event_reseller_update' => 'Forhandlerkonto opdateret',
    'actionlog__event_reseller_guid_update' => 'Forhandler-GUID, opdateret',
    'actionlog__event_reseller_ip_pool_update' => "Forhandlerens IP-pulje opdateret",
    'actionlog__event_reseller_limit_size_reached' => 'Diskpladsgrænse for forhandlerkonto er nået',
    'actionlog__event_reseller_limit_traffic_reached' => 'Trafikgrænse for forhandlerkonto er nået',
    'actionlog__event_reseller_limits_update' => 'Forhandlerkontogrænser opdaterede',
    'actionlog__event_reseller_permissions_update' => 'Forhandlerkontotilladelser er opdaterede',
    'actionlog__event_reseller_preferences_update' => "Forhandlerens grænsefladepræferencer er opdaterede",
    'actionlog__event_reseller_siteapp_added' => "Programmet er føjet til forhandlerkontoens programgruppe",
    'actionlog__event_reseller_siteapp_removed' => "Programmet er fjernet fra forhandlerkontoens programgruppe",
    'actionlog__event_reseller_status_update' => 'Forhandlerkontostatus opdateret',
    'actionlog__event_template_reseller_create' => 'Forhandlerplan oprettet',
    'actionlog__event_template_reseller_delete' => 'Forhandlerplan slettet',
    'actionlog__event_template_reseller_update' => 'Forhandlerplan opdateret',
    'actionlog__event_health_status_change' => 'Serverens sundhedsstatus er ændret',
    'actionlog__event_siteapp_upgrade' => 'Webprogram er opgraderet',
    'actionlog__event_extension_install' => 'Udvidelse installeret',
    'actionlog__event_extension_uninstall' => 'Udvidelse afinstalleret',
    'actionlog__event_extension_upgrade' => 'Udvidelse opgraderet',
    'actionlog__event_extension_status_update' => 'Udvidelsesstatus opdateret',
    'actionlog__event_additional_license_expired' => 'Ekstra licens er udløbet',
    'actionlog__event_hostname_changed' => 'Hostnavn for server ændret',
    'actionlog__event_smb_user_create' => 'Ekstra bruger oprettet',
    'actionlog__event_smb_user_delete' => 'Ekstra bruger slettet',
    'actionlog__event_smb_user_update' => 'Ekstra bruger opdateret',
    'actionlog__dns_record' => 'DNS-post',
    'actionlog__dns_zone' => 'DNS-zone',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesks API RPC er ikke installeret på fjernserveren. Kontakt serviceudbyderen for at få hjælp.",
    'rsession_no_account_errmsg' => "Kunne ikke få adgang til den eksterne service under din konto. Den mest almindelige årsag er, at servicen ikke er aktiveret på din konto endnu. Vent nogle minutter og prøv igen. Hvis fejlen opstår igen, skal du kontakte din systemadministrator.",
    'rsession_no_domain_errmsg' => "Kan ikke få adgang til den eksterne service for dette domæne. Den mest almindelige årsag er, at servicen for domænet endnu ikke er aktiveret. Vent nogle minutter og prøv igen. Hvis fejlen opstår igen, skal du kontakte din systemadministrator.",
    'rsession_unknown_errmsg' => "Den eksterne server har afvist forsøg på at etablere en session. Kontakt din systemadministrator for at få hjælp. Fejlen var: %1",
    'rsession_unknown2_errmsg' => "Ukendt fejl ved etablering af ekstern session. Sandsynligvis svarer den eksterne server ikke korrekt, eller den svarer slet ikke. Bed din systemadministrator om at tjekke webserverens log om der er fejlmeddelelser.",
    'rsession_no_connect_errmsg' => "Kunne ikke får adgang til den eksterne service: tilslutning til ekstern session mislykkedes. Kontakt din systemadministrator for at få hjælp.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Tillad upload til den indgående mappe",
    'anonftp__allow_create_dirs' => 'Tillad oprettelse af mapper i den indgående mappe',
    'anonftp__allow_download_incoming' => 'Tillad download fra den indgående mappe',
    'anonftp__display_login' => 'Vis login-meddelelse',
    'anonftp__login_text' => 'Beskedtekst',
    'anonftp__limit_incoming_disk_space' => "Begræns diskplads i indgående mappe",
    'anonftp__limit_maximum_bandwidth' => "Begræns download-båndbredden for dette virtuelle FTP-domæne",
    'anonftp__limit_maximum_connections' => "Begræns antallet af samtidige forbindelser",
    'anonftp__unable_init' => "Kunne ikke initialisere en anonym FTP-konto: %1",
    'anonftp__unable_set_quota' => "Kunne ikke indstille indgående mappes diskpladsgrænse: %1",
    'anonftp__unable_update' => "Kunne ikke opdatere anonym FTP-kontos egenskaber: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-certifikater', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA-certifikatet signerer ikke certifikatet",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Inkompatibel privat nøgle/certifikatpar.",
    'class_sslcertificate__invalid_cert_format' => "Ugyldigt certifikatformat",
    'class_sslcertificate__invalid_private_key_format' => "Ugyldigt privat nøgle-format",
    'class_sslcertificate__prob_invalid_priv_key' => "Sandsynligvis er den private nøgle ugyldig.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Opret virtuel mappe.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Opret virtuel mappe',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Opret en virtuel mappe.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Opret virtuel mappe.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Opret virtuel mappe',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Opret en virtuel mappe.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Mappeegenskaber',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Egenskaber for virtuel mappe',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Vis og rediger egenskaber for virtuel mappe.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Mappeegenskaber',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Egenskaber for virtuel mappe',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Vis og rediger egenskaber for virtuel mappe.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Vis listen over registrerede MIME-typer.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Tilføj MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Tilføj en MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Registrér en ny MIME-type.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Fejldokumenter',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Fejldokumenter',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Gennemse og rediger fejldokumenter.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Beskyttelse',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Mappebeskyttelse',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Begræns adgang til mappen med adgangskodebeskyttelse.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Beskyttelse',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Mappebeskyttelse',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Begræns adgang til mappen med adgangskodebeskyttelse.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Indstillinger',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Vis mappeplacering og angiv en titel til det beskyttede område.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Brugerindstillinger',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Tilføj bruger',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Tilføj bruger',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Tilføj en brugerkonto der tillader adgang til den beskyttede mappe.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'De nye indstillinger blev overført.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Brugerkontoen blev tilføjet.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Fjern',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Fjern brugere af den beskyttede mappe.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Fjern brugerkonti',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Bekræft fjernelse af brugerkonti.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Brugerkontiene blev fjernet.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Handling udført korrekt.',
    'ui__admin/extras-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__admin/report/layout/delete_multi__done' => 'De markerede rapportleveringsplaner blev fjernet.',
    'ui__admin/report/traffic-history__done' => 'Handling udført korrekt.',
    'ui__admin/report__done' => 'Handling udført korrekt.',
    'ui__admin-alias/delete_multi__done' => "Valgte ekstra-administratorers konti blev fjernet.",
    'ui__admin-alias/properties__done' => "Ekstra administratorkontoegenskaber blev opdateret",
    'ui__admin-alias/properties_new__done' => "Ekstra administratorkonto blev oprettet",
    'ui__admin-alias/properties_unknown__done' => "Ekstra administratorkontoegenskaber blev opdateret",
    'ui__admin-alias__done' => "Ekstraadministrators kontoinformation blev korrekt opdateret.",
    'ui__admin/manage-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__admin/register-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'De valgte rapportleveringsplaner blev fjernet.',
    'ui__admin/report/layout/auto/properties__done' => 'Rapportleveringsplanen blev opdateret.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Rapportleveringsplanen blev oprettet.',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS-certifikatets egenskaber blev opdateret.',
    'ui__client/domain/certificate/properties_new__done' => 'Nyt SSL/TLS-certifikat blev tilføjet. For at få det til at fungere, skal du huske at vælge det i webstedets hosting-indstillinger (under fanen Websteder og domæner> domænenavn).',
    'ui__client/domain/certificate__done' => 'Handling udført korrekt.',
    'ui__client/domain/certificate_self__done' => 'Handling udført korrekt.',
    'ui__client/domain/chowner__done' => 'Abonnementet %1 tilhører nu en anden bruger.',
    'ui__client/domain/chowner_multi__done' => 'Abonnements-ejerskabet blev ændret.',
    'ui__client/domain/chowner_multi-select__done' => 'Handling udført korrekt.',
    'ui__client/domain/chowner_select__done' => 'Handling udført korrekt.',
    'ui__client/domain/dbbackup/create__done' => "Databasen blev sikkerhedskopieret korrekt.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Databasen blev sikkerhedskopieret korrekt.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Uafhængig bruger blev repareret korrekt.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Sikkerhedskopifiler blev fjernet korrekt.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Databaseindholdet blev gendannet korrekt.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Handling udført korrekt.", // PFW
    'ui__client/domain/dbbackup__done' => "Handling udført korrekt.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Handling udført korrekt.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Handling udført korrekt.", // PFW
    'ui__client/domain/delete__done' => "Domænet %1 blev fjernet.",
    'ui__client/domain/delete_multi__done' => "Domænerne blev fjernet.",
    'ui__client/domain/disable__done' => 'Domænet %1 blev suspenderet.',
    'ui__client/domain/disable_multi__done' => 'De markerede domæner blev suspenderet.',
    'ui__client/domain/enable__done' => 'Webstedet %1 blev aktiveret.',
    'ui__client/domain/enable_multi__done' => 'De markerede websteder blev aktiveret.',
    'ui__client/domain/extras__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/domain/extras_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Logrotationsindstillingerne blev ændret.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Logrotationsindstillingerne blev ændret.',
    'ui__client/domain/hosting/logs__done' => 'Handling udført korrekt.',
    'ui__client/domain/hosting/logs_self__done' => 'Handling udført korrekt.',
    'ui__client/domain/hosting/setup__done' => 'Hosting for %1 blev konfigureret.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Handling udført korrekt.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Handling udført korrekt.', // PFU
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Virtuel mappe blev oprettet på webstedet %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Virtuel mappe blev oprettet.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'De markerede mapper blev fjernet.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'De markerede mapper blev fjernet.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Brugerdefinerede fejldokumenter blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Markerede MIME-typer blev fjernet', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Ny MIME-type blev registreret.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Handling udført korrekt.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Mappens adgangstilladelser blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Mappens adgangstilladelser blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP-indstillingerne for %1 blev ændret.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'PHP-indstillingerne for %1 blev ændret.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Mappeegenskaberne blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Mappeegenskaberne blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Mappebeskyttelsesindstillingerne blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Mappebeskyttelsesindstillingerne blev opdateret.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Handling udført korrekt.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Handling udført korrekt.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'SSL/TLS-certifikater til rådighed i online-butikken',
    'ui__client/domain/mpc-certificates_self__done' => 'SSL/TLS-certifikater til rådighed i online-butikken',
    'ui__client/domain/register__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/domain/register_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/domain/rename__done' => 'Domænenavnet blev ændret.',
    'ui__client/domain/rename_self__done' => "Domænenavnet blev ændret.",
    'ui__client/domain/settings_self__done' => 'Handling udført korrekt.',
    'ui__client/domain/toggle_disable__done' => "Domænet %1 blev suspenderet.",
    'ui__client/domain/toggle_enable__done' => "Domænet %1 blev aktiveret.",
    'ui__client/domain/traffic__done' => 'Handling udført korrekt.',
    'ui__client/domain/traffic_self__done' => 'Handling udført korrekt.',
    'ui__client/domain/traffic_unknown__done' => 'Handling udført korrekt.',
    'ui__client/domain-summary-report__done' => 'Handling udført korrekt.',
    'ui__client/domain-summary-report_self__done' => 'Handling udført korrekt.',
    'ui__client/domain-summary-report_unknown__done' => 'Handling udført korrekt.',
    'ui__client/extras-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/extras-domain_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/ipaddress/delete_multi__done' => 'Handling udført korrekt.',
    'ui__client/ipaddress/properties__done' => 'Handling udført korrekt.',
    'ui__client/ipaddress/properties_new__done' => 'Handling udført korrekt.',
    'ui__client/ip-pool/properties__done' => "Kunde %1's IP-gruppe blev opdateret.",
    'ui__client/ip-pool/properties_self__done' => 'Handling udført korrekt.',
    'ui__client/limits__done' => "Ressourcegrænser for kunden %1 blev ændret.",
    'ui__client/limits_self__done' => 'Handling udført korrekt.',
    'ui__client/logo__done' => 'De nye branding-indstillinger for kunden %1 blev overført.',
    'ui__client/logo_reseller__done' => 'De nye panelindstillinger blev overført.',
    'ui__client/logo_self__done' => 'Branding-indstillingerne blev overført.',
    'ui__client/logo_self-reseller__done' => 'De nye brandingindstillinger blev overført.',
    'ui__client/manage-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/manage-domain_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/permissions__done' => "Tilladelserne for kunden %1 blev ændret.",
    'ui__client/permissions_self__done' => 'Handling udført korrekt.',
    'ui__client/preferences__done' => "Indstillingerne for kunden %1 blev ændret.",
    'ui__client/preferences_self__done' => "Indstillingerne blev ændret.",
    'ui__client/register-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/register-domain_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__client/report/traffic-history__done' => 'Handling udført korrekt.',
    'ui__client/report/traffic-history_self__done' => 'Handling udført korrekt.',
    'ui__client/report__done' => 'Handling udført korrekt.',
    'ui__client/report_self__done' => 'Handling udført korrekt.',
    'ui__client/sessions/delete__done' => 'Handling udført korrekt.',
    'ui__client/sessions/delete_self__done' => 'Handling udført korrekt.',
    'ui__client/sessions__done' => 'Handling udført korrekt.',
    'ui__client/sessions_self__done' => 'Handling udført korrekt.',
    'ui__client/skeleton__done' => 'Handling udført korrekt.',
    'ui__client/skeleton_self__done' => 'Handling udført korrekt.',
    'ui__client/traffic__done' => "Handling udført korrekt.",
    'ui__client/traffic_unknown__done' => 'Handling udført korrekt.',
    'ui__cp-access__done' => 'Handling udført korrekt.',
    'ui__cp-session/properties__done' => 'Handling udført korrekt.',
    'ui__cp-session__done' => 'Handling udført korrekt.',
    'ui__ftp-sessions__done' => 'Handling udført korrekt.',
    'ui__license__done' => 'Handling udført korrekt.',
    'ui__logo__done' => "Plesk-branding egenskaberne blev ændret.",
    'ui__longtasks/longtask/properties__done' => "Indstillingerne for baggrundsopgaver blev korrekt ændrede.",
    'ui__mass-email/delete__done' => "Meddelelsesskabelon %1 blev fjernet.", // PFW
    'ui__mass-email/delete_multi__done' => "Meddelelsesskabeloner blev fjernet.",  // PFW
    'ui__mass-email/send_main__done' => "Handling udført korrekt.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Kundekonto blev korrekt valgt.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Domæneadministratorkonti blev korrekt valgt.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Forhandlerkonto blev korrekt valgt.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Ændringer af masse e-mail-meddelelsesskabelon blev gemt.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Masse e-mail-meddelelsesskabelon blev oprettet.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Kundekonti til masse e-mail-meddelelsesskabelon blev valgt.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Domæneadministratorkonti til masse e-mail-meddelelsesskabelon blev valgt.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Kundekonti til masse e-mail-meddelelsesskabelon blev valgt.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Masse e-mail-meddelelsesskabelon blev ændret.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Ugyldige værdier blev angivet.', // PFW
    'ui__mass-email__done' => "Handling udført korrekt.", // PFW
    'ui__mass-mail__done' => "Handling udført korrekt.", // PFU
    'ui__mass-mail/delete__done' => 'Meddelelsesskabelon %1 blev fjernet.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Meddelelsesskabeloner blev fjernet.', // PFU
    'ui__mass-mail/properties__done' => 'Skabelonen %1 blev ændret.', // PFU
    'ui__mass-mail/properties_new__done' => 'Skabelonen %1 blev oprettet.', // PFU
    'ui__mass-mail/send__done' => 'Meddelelserne blev sendt.', // PFU
    'ui__mass-mail/send_new__done' => 'Meddelelserne blev sendt.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Meddelelserne blev sendt.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Meddelelserne blev sendt.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Ny meddelelse skabelon blev oprettet.', // PFU
    'ui__mass-mail/template/properties__done' => 'Meddelelsesskabelonen blev ændret.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'De nye diskovervågningsindstillinger blev overført.', // PFU
    'ui__modules__done' => 'Handling udført korrekt.',
    'ui__modules__short-title' => 'Filtypenavne',
    'ui__modules__title' => 'Filtypenavne',
    'ui__reseller/client/traffic_unknown__done' => 'Handling udført korrekt.',
    'ui__reseller/extras-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__reseller/extras-domain_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__reseller/ftp-sessions_self__done' => 'Handling udført korrekt.',
    'ui__reseller/limits__done' => "Forhandlerens ressourcegrænser og ressourceforbrugspolitikker blev ændret.",
    'ui__reseller/limits_readonly-self__done' => 'Handling udført korrekt.',
    'ui__reseller/limits_self__done' => 'Dine ressourcegrænser og ressourceforbrugspolitikker blev ændret.',
    'ui__reseller/manage-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__reseller/manage-domain_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__reseller/permissions__done' => 'Tilladelserne for forhandleren %1 blev ændret.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Handling udført korrekt.',
    'ui__reseller/register-domain__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__reseller/register-domain_self__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'De valgte rapportleveringsplaner blev fjernet.',
    'ui__reseller/report/layout/auto/properties__done' => 'Rapportleveringsplanen blev opdateret.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Rapportleveringsplanen blev tilføjet.',
    'ui__reseller/report/traffic-history__done' => 'Handling udført korrekt.',
    'ui__reseller/report/traffic-history_self__done' => 'Handling udført korrekt.',
    'ui__reseller/report__done' => 'Handling udført korrekt.',
    'ui__reseller/report_self__done' => 'Handling udført korrekt.',
    'ui__reseller/sessions/delete__done' => 'Handling udført korrekt',
    'ui__reseller/sessions/delete_self__done' => 'Handling udført korrekt',
    'ui__reseller/sessions__done' => 'Handling udført korrekt.',
    'ui__reseller/sessions_self__done' => 'Handling udført korrekt.',
    'ui__reseller/traffic__done' => 'Handling udført korrekt.',
    'ui__reseller/traffic_self__done' => 'Handling udført korrekt.',
    'ui__reseller/traffic_unknown__done' => 'Handling udført korrekt.',
    'ui__reseller/logo_self__title' => 'Plesk-branding',
    'ui__reseller/logo_self__done' => 'De nye Plesk-brandingindstillinger blev overført.',
    'ui__server/certificate/default_multi__done' => 'Markeret SSL/TLS-certifikat blev opsat til sikre forbindelser til nye websteder.',
    'ui__server/certificate/delete_multi__done' => 'Markerede SSL/TLS-certifikater blev fjernet',
    'ui__server/certificate/download__done' => 'SSL/TLS-certifikatet blev downloadet.',
    'ui__server/certificate/properties__done' => 'SSL/TLS-certifikatets egenskaber blev opdateret.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-certifikatet %1 blev oprettet.',
    'ui__server/certificate/setup_multi__done' => 'Det valgte SSL/TLS-certifikat blev opsat til at blive anvendt til sikring af forbindelser til Plesk.',
    'ui__server/certificate__done' => 'Handling udført korrekt.',
    'ui__server/cp-certificate-download__done' => "Plesks SSL/TLS-certifikat blev downloadet.",
    'ui__server/crontab/properties__done' => 'Planlagte opgaver for %1 blev ændret.',
    'ui__server/crontab/task/delete__done' => 'Opgaven blev fjernet.',
    'ui__server/crontab/task/delete_multi__done' => 'Opgaverne blev fjernet.',
    'ui__server/crontab/task/properties__done' => 'De planlagte opgaver blev opdateret.',
    'ui__server/crontab/task/properties_new__done' => 'Den nye opgave blev planlagt.',
    'ui__server/crontab/task/toggle_disable__done' => 'Den planlagte opgave %1 blev deaktiveret.',
    'ui__server/crontab/task/toggle_enable__done' => 'Den planlagte opgave %1 blev aktiveret.',
    'ui__server/crontab__done' => 'Handling udført korrekt.',
    'ui__server/dns__done' => 'Handling udført korrekt.',
    'ui__server/ip-address/client/delete__done' => "IP-adressen blev fjernet fra brugerens IP-pulje.",
    'ui__server/ip-address/client/delete_multi__done' => "IP-adressen blev fjernet fra brugernes IP-puljer.",
    'ui__server/ip-address/client/properties_new__done' => 'IP-adressen blev knyttet til brugere.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-adressen %1 blev knyttet til de markerede brugere.',
    'ui__server/ip-addresses__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/spam/recipients__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/spam/summary__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/spam__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/virus/recipients__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/virus/summary__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/virus/viruses__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics/virus__done' => "Handling udført korrekt.",
    'ui__server/mail/statistics__done' => "Handling udført korrekt.",
    'ui__server/mail__done' => 'Mailserver-indstillingerne blev ændret.',
    'ui__server/maillists__done' => 'Handling udført korrekt.',
    'ui__server/mpc-certificates__done' => 'Online butik-siden der viser de SSL/TLS-certifikater , der er til rådighed, blev åbnet.',
    'ui__server/pmm__done' => 'Handling udført korrekt.',
    'ui__server/preferences__done' => "Server-indstillingerne blev ændret.",
    'ui__server/register__done' => 'Siden MyPlesk.com blev åbnet.',
    'ui__server/services__done' => 'Handling udført korrekt.',
    'ui__server/sitebuilder__done' => 'Handling udført korrekt.',
    'ui__server/skeleton__done' => 'Handling udført korrekt.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Adressen %1 blev fjernet fra den server-brede sortliste.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Adresserne blev fjernet fra den server-brede sortliste.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adresserne blev føjet til sortlisten.',
    'ui__server/spam-filter/black-list/address__done' => 'Adresserne blev føjet til sortlisten.',
    'ui__server/spam-filter/black-list__done' => 'Handling udført korrekt.', // PFU
    'ui__server/spam-filter/properties__done' => 'Spamfilter-indstillingerne blev ændret.',
    'ui__server/spam-filter/toggle_disable__done' => 'Spamfiltrering blev deaktiveret i hele systemet.',
    'ui__server/spam-filter/toggle_enable__done' => 'Spamfiltrering blev aktiveret i hele systemet.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Adressen %1 blev fjernet fra den server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Adresserne blev fjernet fra den server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adresserne blev føjet til hvidlisten.',
    'ui__server/spam-filter/white-list/address__done' => 'Adresserne blev føjet til hvidlisten.',
    'ui__server/spam-filter/white-list__done' => 'Handling udført korrekt.', // PFU
    'ui__server/spam-filter__done' => 'Handling udført korrekt.',
    'ui__server/statistics__done' => 'Handling udført korrekt.',
    'ui__server/time__done' => "Systemdato og klokkeslæt blev ændret.",
    'ui__server__done' => "Handling udført korrekt.",
    'ui__sessions/properties__done' => 'Handling udført korrekt.',
    'ui__sessions__done' => 'Handling udført korrekt.',
    'ui__sessions/delete__done' => 'Markerede sessioner blev slettet.',
    'ui__support__done' => 'Assistanceanmodningsformular blev åbnet i et nyt browservindue eller fane.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Ingen filer til upload',
    'login_up__access_denied_no_permission' => "Adgang nægtet. Du har ikke tilladelse til at logge på.",
    'mail__unable_remove_pattern' => "Kan ikke fjerne adresse fra serverens blackliste: %1", // PFW
    'mail__incorrect_network_format' => 'Forkert netværks6ormat: %1', // PFW
    'initconf__unable_change_passwd' => "Kunne ikke ændre administratorens adgangskode: %1",
    'initconf__unable_get_passwd' => 'Kunne ikke hente den aktuelle administrator-adgangskode : %1 mislykkedes: %2',
    'initconf__invalid_hostname' => 'Fejl i hostnavnet "%1"',
    'initconf__unable_reconfig' => 'Kunne ikke konfigurere Plesk: reconfig mislykkedes: %1',
    'initconf__unable_update_admin' => 'Kunne ikke opdatere administrator kontaktinfo: %1',
    '__refresh' => 'Opdater',
    '__dalias_not_exist' => 'Domænealias findes ikke.',
    '__bug146523_explanation' => 'Tidligere versioner af Plesk tillod brug af op til 16 tegn i FTP-brugernavne. I denne version af Plesk er det maksimalt tilladte antal tegn til FTP-brugernavne begrænset til 15. Du kan løse dette problem ved at reducere FTP-brugernavne til 15 tegn for påvirkede brugernavne, og ændre mindst ét tegn i de påvirkede FTP-brugernavne for at undgå at de bliver ens. Beklager de eventuelle besværligheder denne ændring måtte medføre.',
    'domain__cannot_change_webmail' => 'Det var ikke muligt at ændre webmail for domænet: %1',
    'sb_publish_disable_warning' => 'Hvis du deaktiverer webstedoprettelse med Presence Builder, vil de websteder, der tidligere er blevet oprettet i Presence Builder blive fjernet, og alle webstedsdata går tabt. Klik på OK, hvis du vil fortsætte.',
    '__sbnet_client_use_sbnet' => "Opret en korresponderende brugerkonto i Presence Builder",
    'mail_resp_activate' => 'Aktivér auto-svar',
    'limitsManger__limit_available_error' => 'Kan ikke allokere den nødvendige mængde ressourcer ("%%limitName%%"): kun %%available%% er til rådighed for din konto.',
    'limitsManger__limit_reserved_error' => 'Kan ikke allokere færre ressourcer ("%%limitName%%") end allerede anvendt.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Det var ikke muligt at omdøbe domænet: En virtuel mappe med det angivne navn findes allerede.',
    'domain_unable_to_rename' => 'Kunne ikke omdøbe domæne.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Generelt',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin spamfiltrering',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin-indstillinger',
    'spamfilter__spamassassin_server_status_legend' =>  "Aktivér overordnet server SpamAssassin spamfiltrering",
    'spamfilter__spamassassin_user_status_legend' => 'Aktivér SpamAssassin spamfiltrering',
    'spamfilter__greylisting_status_legend' => 'Aktivér overordnet server-gråliste spambeskyttelse',
    'spamfilter__personal_settings_not_allowed' => 'Brugen af individuelle spamfiltreringsindstillinger er ikke tilladt af systempolitikken.',
    'spamfilter__required_score' => 'Den score en meddelelse skal have, for at blive bedømt som spam',
    'spamfilter__rewrite_header_subject' => 'Føj følgende tekst til emnets start på de meddelelser, der genkendes som spam',
    'spamfilter__use_mailuser_prefs' => 'Brug individuelle indstillinger til filtrering af spam',
    'spamfilter__score_error' => 'Score\'n må ikke være negativ, delen inden decimalpunktet skal være mindre end 100, og kan højst inkludere to cifre efter decimalpunktet.',
    'spamfilter__rewrite_header_error' => 'Meddelelsens emne kan indehold ethvert udskriftsbart tegn, bortset fra nummertegnet (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Bounce',
    'nonexistent_mail__mode_discard' => 'Kassér',
    'nonexistent_mail__mode_catch_addr' => 'Videresend til e-mail adresse',
    'nonexistent_mail__mode_catch_ip' => 'Videresend til IP',
    'nonexistent_mail__bounce_not_supported' => 'Bounce-tilstand understøttes ikke',
    'nonexistent_mail__discard_not_supported' => 'Kasseringstilstand understøttes ikke',
    'nonexistent_mail__catch_not_supported' => 'Videresendelse til e-mail-adresse understøttes ikke',
    'nonexistent_mail__redirect_not_supported' => 'Videresendelse til IP understøttes ikke',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-adresse oversættes til localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Da kontrol af udgående post er aktiveret, skal e-mail adressen %1 for ikke-eksisterende modtagere høre til det valgte domæne. Hvis ikke, vil "Afvis" politikken blive anvendt i stedet for videreendelse.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Da udgående e-mail kontrol er aktiveret, skal den e-mail adresse, der specificeres til e-mail videresendelse (%1) høre til det valgte domæne. Hvis den ikke gør det, vil meddelelser, der sendes til denne adresse, ikke blive optalt i Udgående e-mail kontrollen.',
    // mail acc extras
    '__antivirus' => "Antivirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Der er ingen ekstraadministrator-konti til rådighed.', // PFW
    'ui__client/domain/certificate__none-available' => 'Kunden har ikke SSL/TLS-certifikater.',
    'ui__client/domain/certificate__none-available__1' => 'Kunden har ikke domæner med SSL/TLS-certifikater.',
    'ui__client/domain/certificate__none-available__2' => 'Domænet har ingen SSL/TLS-certifikater.',
    'ui__reseller/client__none-available' => 'Der er ingen forhandlere med kunder.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Du skal vælge de IP-adresser, du vil fjerne fra IP-gruppen.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Du skal vælge de forhandlerkonti, for hvis IP-grupper du vil tilbagekalde en IP-adresse.',
    'ui__server/crontab/task/delete__empty_selection' => 'Du skal vælge de opgaver, du vil fjerne',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'ASP.NET-understøttelse er deaktiveret for dette websted.',
    'phosting__php_forced_by_site_isolation' => 'Kan ikke ændre PHP-indstillinger: tilladelse til tilsidesættelse af den overordnede sikkerhedspolitik for serveren er ikke givet.',
    'phosting__option_forced_by_site_isolation' => 'Kan ikke ændre %1-indstillinger: tilladelse til tilsidesættelse af den overordnede sikkerhedspolitik for serveren er ikke givet.',
    'phosting__php_handler_id_not_registered' => 'PHP-handler er ikke tilladt i websteds-isolationsindstillingerne. Standard PHP-handleren vil blive anvendt.',
    'phosting__php_served_by_nginx_is_not_available' => 'PHP-handler (FPM-applikation leveret af nginx) er ikke tilladt i websteds-isolationsindstillingerne. Standard PHP-handleren vil blive anvendt.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Vis listen med IP-adresser',
    'ui__client/ipaddress/properties_readonly__title' => 'Vis listen med IP-adresser',
    'ui__client/ipaddress/properties_readonly__description' => 'Vis listen med IP-adresser til rådighed for denne kunde.',
    'ui__server/certificate__short-title' => 'SSL/TLS-certifikater',
    'ui__server/certificate__title' => 'SSL/TLS-certifikater',
    'ui__server/certificate__description' => 'Vis og administrer SSL/TLS-certifikater.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Fjern MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Fjern MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Fjern markerede MIME-typer.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Tilføj MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Tilføj MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registrér en MIME-type.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Fjern IP-adresser',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Vælg de IP-adresser du vil fjerne fra IP-gruppen for kunden %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP-adresse',
    'ui__client/ipaddress__title' => 'IP-adresse',
    'ui__client/ipaddress__description' => 'Vis oplysninger om denne IP-adresser',
    'ui__server/ip-address__short-title' => 'IP-adresse',
    'ui__server/ip-address__title' => 'IP-adresse',
    'ui__server/ip-address__description' => 'Vis oplysninger om denne IP-adresser',
    'ui__client/domain/hosting/setup__short-title' => 'Webhotelindstillinger',
    'ui__client/domain/hosting/setup__title' => 'Webhotelindstillinger',
    'ui__client/domain/hosting/setup__description' => 'Opsæt webhosting indstillinger for webstedet %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Mime-type', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME-type egenskaber', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Vis egenskaberne for MIME-typen.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Fejldokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Fejldokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Fejldokumentegenskaben', // PFW

    // tooltips

    'b_get_password_cancel' => 'Returnér til foregående skærmbillede uden at sende e-mailen.',
    'b_get_password_send' => 'Klik på OK for at sende en adgangskode-gendannelsesbesked til den e-mailadresse, der er registreret i systemet.',



    'b_personaltrafficlist_search' => 'Angiv et søgemønster og klik for at finde domæner.',
    'b_personaltrafficlist_show_all' => 'Vis alle domæner',

    'b_back' => 'Vend tilbage til den forrige side.',
    'b_next' => 'Gå til næste side',

    'b_dnsnstemplatelist_remove' => 'Slet de markerede navneservere.',
    'b_dnsnstemplatelist_search' => 'Angiv et søgemønster og klik for at finde navneservere.',
    'b_dnsnstemplatelist_show_all' => 'Vis alle navneservere',

    'l_dnsnstemplatelist_ns' => 'Sortér DNS-skabelon efter navneserver.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'generer sikre links til filer og mapper',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Aktivér offentlige filer',
    'cu__serverfilesharing_fsPublicFolder' => 'Mappe til lagring af offentlige filer',
    'cu__serverfilesharing_fsPublicUrl' => 'URL til besøgendes adgang til offentlige filer',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Aktivér adgangskodebeskyttelse af offentlige filer',
    'cu__serverfilesharing_fsPartnerFolder' => 'Mappe til adgangskodebeskyttet fillagring',
    'cu__serverfilesharing_fsPartnersLogin' => 'Brugernavn for filadgang',
    'cu__serverfilesharing_fsPartnersPassword' => 'Adgangskode for filadgang',
    'cu__serverfilesharing_fsDomain' => 'Webmappens rod-URL. Domænenavn',
    'cu__serverfilesharing_fsPrefix' => 'Webmappens rod-URL. Præfiks',
    'cu__serverfilesharing_commandUpdate' => 'Opdater fildelingsindstillinger',
    'cu__serverfilesharing_commandInfo' => 'Vis nuværende fildelingsindstillinger',
    'subscription_rename_is_forbidden' => 'Omdøbning af abonnementer er forbudt iht.. den overordnede serverpolitik .',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Administrér planlagte opgaver på serveren',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Vælg den systembruger, hvis planlagte opgaver, du vil se.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Planlagt opgave %1',
    'ui__server/crontab/task__description' => 'Vis egenskaberne for den planlagte opgave %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Systembrugere',
    'ui__server/crontab_unknown__title' => 'Systembrugere',
    'ui__server/crontab_unknown__description' => 'Systembrugere der kan være ejere af planlagte opgaver.',


    'ui__server/crontab__none-available' => 'Du har ingen systembrugerkonti.',
    'ui__server/crontab_readonly-unknown__description' => 'Vis planlagte opgaver',
    'ui__server/crontab_readonly-unknown__short-title' => 'Planlagte opgaver',
    'ui__server/crontab_readonly-unknown__title' => 'Vis planlagte opgaver',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Vis planlagte opgaver',
    'ui__server/crontab_readonly__description' => 'Vis planlagte opgaver for %1.',
    'ui__server/crontab_readonly__short-title' => 'Planlagt opgave for %1',
    'ui__server/crontab_readonly__title' => 'Vis planlagte opgaver for %1.',
    'ui__server/crontab_unknown__wizard-title' => 'Administrer planlagte opgaver',

    'ui__server/crontab/properties__description' => 'Redigér planlagte opgaver for %1.',

    'ui__server/crontab/properties__short-title' => 'Indstillinger',
    'ui__server/crontab/properties__title' => 'Redigér planlagte opgaver for %1.',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Vis planlagte opgaver',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Indstillinger',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Vis planlagte opgaver',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Vis planlagte opgaver',
    'ui__server/crontab/properties_readonly__description' => 'Vis planlagte opgaver for %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Indstillinger',
    'ui__server/crontab/properties_readonly__title' => 'Vis planlagte opgaver for %1.',
    'ui__server/crontab/properties_unknown__description' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/properties_unknown__short-title' => 'Egenskaber',
    'ui__server/crontab/properties_unknown__title' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Vælg den systembruger, hvis opgaver, du vil se.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Vælg den systembruger, hvis opgaver, du vil se.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Klik på Færdig for at overføre ændringerne og forlade guiden.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klik på Udfør for at afslutte guiden.',

    'ui__server/crontab/task__none-available' => 'Du har ingen planlagte opgaver.',
    'ui__server/crontab/task__none-available__2' => 'Systembrugeren %1 har ikke nogen planlagte opgaver.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Planlagte opgaver',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Opgaver',
    'ui__server/crontab/task_readonly-unknown__title' => 'Planlagte opgaver',

    'ui__server/crontab/task/delete__description' => 'Fjern den planlagte opgave %1.',

    'ui__server/crontab/task/delete__short-title' => 'Fjern',
    'ui__server/crontab/task/delete__title' => 'Fjern den planlagte opgave %1.',
    'ui__server/crontab/task/delete_multi__description' => 'Fjern planlagte opgaver',

    'ui__server/crontab/task/delete_multi__short-title' => 'Fjern',
    'ui__server/crontab/task/delete_multi__title' => 'Fjern planlagte opgaver',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Fjern planlagte opgaver',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Vælg den systembruger, hvis opgaver, du vil se.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Vælg de opgaver, du vil fjerne.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Bekræft fjernelsen af de planlagte opgaver ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',
    'ui__server/crontab/task/delete_unknown__description' => 'Fjern en planlagt opgave',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Fjern',
    'ui__server/crontab/task/delete_unknown__title' => 'Fjern en planlagt opgave',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Fjern en planlagt opgave',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Vælg den systembruger, hvis opgaver, du vil se.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Vælg de opgaver, du vil fjerne.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Bekræft fjernelsen af de planlagte opgaver ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',

    'ui__server/crontab/task/properties__description' => 'Redigér planlagte opgaver.',

    'ui__server/crontab/task/properties__short-title' => 'Rediger opgaven %1',
    'ui__server/crontab/task/properties__title' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/task/properties_new__description' => 'Opret en planlagt opgave for %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Tilføj opgave',
    'ui__server/crontab/task/properties_new__title' => 'Opret en planlagt opgave for %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Opret en planlagt opgave.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Vælg den systembruger, for hvem du vil oprette en planlagt opgave.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Klik på Færdig for at overføre ændringerne og forlade guiden.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Vis de planlagte opgaver',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Egenskaber',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Vis de planlagte opgaver',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Vis de planlagte opgaver',
    'ui__server/crontab/task/properties_readonly__description' => 'Vis planlagte opgaver',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Vis opgave %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Vis planlagte opgaver',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Opret planlagte opgaver.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Tilføj opgave',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Opret planlagte opgaver',
    'ui__server/crontab/task/properties_unknown__description' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Egenskaber',
    'ui__server/crontab/task/properties_unknown__title' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Redigér planlagte opgaver.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Vælg den systembruger, hvis opgaver, du vil se.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Vælg den systembruger, hvis opgaver, du vil se.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Vælg de planlagte opgaver',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Vælg den planlagte opgave, du vil redigere.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Klik på Færdig for at overføre ændringerne og forlade guiden.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klik på Udfør for at afslutte guiden.',

    'ui__server/crontab/task/toggle_disable__description' => 'Deaktivér den planlagte opgave %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Deaktiver',
    'ui__server/crontab/task/toggle_disable__title' => 'Deaktivér den planlagte opgave %1.',
    'ui__server/crontab/task/toggle_enable__description' => 'Aktivér den planlagte opgave %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Aktiver',
    'ui__server/crontab/task/toggle_enable__title' => 'Aktivér den planlagte opgave %1.',
    'ui__server/crontab/task/toggle_unknown__description' => 'Aktivér eller deaktivér planlagte opgaver.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Aktivér eller deaktivér',
    'ui__server/crontab/task/toggle_unknown__title' => 'Aktivér eller deaktivér planlagte opgaver.',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Aktivér eller deaktivér planlagte opgaver.',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Vælg den systembrugerkonto, hvis planlagte opgaver, du vil aktivere eller deaktivere.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Vælg den planlagte opgave, du vil aktivere eller deaktivere.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Kunde Konti', // not used on HP?
    'ui__client_unknown__title' => 'Kunde Konti', // not used on HP?
    'ui__client_unknown__description' => 'Administrér kundekonti', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspendér domænet', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspendér domænet', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspendér et domæne', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktivér domæne', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktivér domæne', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktivér et domæne.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "FTP-konti under domænet %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-konti",
    'ftp__user_name' => "FTP-kontonavn",
    'ftp__user_home' => "Hjemmebibliotek",
    'ftp__invalid_path' => "Der er angivet en ugyldig sti",
    'i_ftp_ses_sub_user' => 'FTP-kontosession',
    '__new_passwd' => "Ny %1 adgangskode",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Kan ikke konfigurere en webserver på verden <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Kan ikke generere webserver-konfigurationsfil på værten <%%host%%> på grund af følgende fejl: \n \n%%error%% \n \nLøs problemerne i webserverkonfigurationsskabelonerne og generér filen igen.",

    'apacheConfigurationMessageAdminTitle' => 'Generering af webserverkonfiguration mislykkedes',
    'apacheConfigurationMessageClientTitle' => 'Advarsel',

    'apacheConfigurationFailedAdminHomeMessage' => 'Ny konfigurationsfil blev ikke opbygget pga. fejl i konfigurationsskabelonerne. Den detaljerede fejlmeddelelse blev sendt til din e-mailadresse, så tjek din e-mail, ret fejlene og klik på %1 for at forsøge at generere konfigurationen igen.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'her', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Ny konfiguration af domænet %1 blev ikke opbygget pga. fejl i konfigurationsskabelonerne. Den detaljerede fejlmeddelelse blev sendt til din e-mailadresse, så tjek din e-mail, ret fejlene og klik på %2 for at forsøge at generere konfigurationen igen.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'her', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Webserverkonfigurationen for domænet %1 kan være selvmodsigende. Kontakt serveradministratoren for at få dette problem løst.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Ny konfiguration af nogle af domænerne blev ikke opbygget pga. fejl i konfigurationsskabelonerne. Den detaljerede fejlmeddelelse blev sendt til din e-mailadresse, så tjek din e-mail, ret fejlene og klik på %1 for at forsøge at generere konfigurationen igen.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'her', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Webserverkonfigurationen for nogle af dine domæner kan være selvmodsigende. Kontakt serveradministratoren for at få dette problem løst.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Brugerdefinerede fejldokumenter",
    'dom_pref__webusers_script' => "Tillad webbrugere at anvende scripts",
    '__seoRedirect' => 'Konfigurér det foretrukne domæne som',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Ingen',

    '__sites' => 'Domæner',
    'domain_plan__perm_denied_manage_phosting' => 'Du har ikke tilladelse til at administrere hosting-indstillingerne.',
    '__owned_by_client' => 'ejet af kunde',
    'ui__client/permissions_readonly__description' => "Vis listen over de handlinger, som kunden %1 kan udføre i Plesk.",
    'backup__restore__object_client_template' => 'Kundeskabelon',
    '__template_name' => 'Serviceplannavn',
    'template__not_exists' => 'Der findes ikke sådan en serviceplan',
    'template__exists' => 'En plan med navnet %1 findes allerede.',
    'clientOwnerChanger__ip_not_in_pool' => 'Den angivne IP-adresse findes ikke i forhandlerens pulje.',

    //// Change owner of subscription
    'chown__select_title' => "Vælg en abonnent",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Vælg en ny ejer af de markerede abonnementer og klik på Næste >>.',
    'domains__client_info' => "%1 abonnementer, %2 aktive abonnementer, %3 diskplads anvendt, %4 trafik anvendt",
    '__possible_owners' => 'Mulige nye abonnementsejere',

    'clients_list__filter_owner__filter_title' => 'Udbyder',
    'clients_list__filter_owner_any' => 'Alle brugere',
    'clients_list__filter_owner_my' => 'Kun mine abonnenter',
    'clients_list__filter_owner_name__filter_title' => 'Udbyders navn',

    '__owner' => "Udbyder",
    'l_clientslist_owner' => 'Sortér brugerkonti efter udbyder.',
    'l_clientslist_date' => 'Sortér brugerkonti efter oprettelsesdato.',
    'l_clientslist_name' => 'Sortér brugerkonti efter navn.',
    'l_clientslist_domains' => 'Sortér brugerkonti efter domæner.',
    'l_clientslist_cname' => 'Sortér brugerkonti efter firmanavn.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Omtilknytter markerede abonnementer.',
    'chown__check_title' => 'Skifte abonnent',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klik på Udfør for at afslutte omtilknytningen. Når dette er sket, vil de markerede abonnementer blive tilknyttet en ny ejer, deres udbyder ændres til den nye ejers udbyder og de vil blive frigjort fra deres serviceplaner og blive 'Brugerdefinerede'.",

    'chown__error_check' => 'Der opstod problemer ved forsøg på tilknytning af nogle af abonnementerne til en ny ejer.',
    'domain_chown_subscription_will_be_anonymous' => "Abonnenter vil få ophævet binding til deres nuværende serviceplaner og blive 'Brugerdefinerede'.",
    'chown__error_domains_exclude' => "Der opstod problemer ved forsøg på tilknytning af nogle af abonnementerne til en ny ejer. Disse abonnementer er fremhævet.",
    'chown__ip_not_in_client_pool' => "Den IP-adresse, der er knyttet til dette abonnement, blev ikke føjet tilden nye ejers IP-gruppe.",
    'chown__already_owned_by_client' => "Dette abonnement tilhører allerede denne bruger.",

    '__redirect_hint' => 'Du vil blive omdirigeret til den nye adresse om 15 sekunder... Hvis du ikke automatisk bringes til det nye sted, bedes du aktivere JavaScript eller klikke på hyperlinket %%link%%.',

    'backup__restore__object_maillist' => 'Maillister',
    'backup__restore__object_site' => 'Websted',
    'backup__restore__object_user' => 'Bruger',
    'backup__restore__object_role' => 'Rolle',

    'limit__name_max_site' => 'websteder',

    'iis_pool__unable_rename_client' => "Kan ikke omdøbe IIS-programgruppe: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonym FTP-service understøttes kun for et abonnements hoveddomæne.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Anonym FTP-service understøttes kun for et abonnements hoveddomæne.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/Måned',
    '__tb_month' => 'TB/måned',

    '__customers' => 'Kunder',
    '__customer_name' => 'Kundenavn',
    '__customer_total' => 'Kundetotal',
    '__site' => 'Websted',
    '__def_site' => 'Standardlokation',
    '__subscription_name' => 'Abonnementsnavn',
    '__subscription_name_powerUser' => 'Abonnementsnavn',

    'limit__units_max_traffic_suffix' => '/måned',

    'dom_pref__discard' => "Afvis",

    'mail__pattern_already_exists' => 'Mønstret "%1" findes allerede på sortlisten.',

    '__not_supported' => 'Ikke supporteret',

    'plesk_key__sitebuilder' => 'Websteder, udgivet med Presence Builder',
    'limit__name_max_site_builder' => 'Websteder, udgivet med Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Understøttelse af fleresprogede websteder i Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Dataoverførselsstatistik for <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Dataoverførselsstatistik for <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Dataoverførsel vha. services",

    'login_up__access_denied_no_subscriptions' => "Adgang nægtet. Der er ikke nogen ledige abonnementer til denne konto.",

    'interval__day' => '%1 dag(e)',
    'interval__hour' => '%1 time(r)',
    'interval__minute' => '%1 minut(ter)',
    'interval__second' => '%1 sekund(er)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Du forsøger at bruge en licensnøgle, der er oprettet til en anden version af Plesk. Kontakt en Plesk-sælger for at få den rette licensnøgle.',
    //Standalone or virtualization
    'virtualization_any' => "Fysisk server eller enhver virtualiseringsløsning",
    'virtualization_pvc' => "Virtuozzo-containere",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo-server",
    'plesk_key__virtualization' => "Gyldig for følgende miljøer:",
    'plesk_key__virtualization_only_key' => 'Licensnøglen er udelukkende beregnet til brug sammen med Plesk, når dette fungerer inde i et %1 virtuelt miljø.',
    'plesk_key__virtualizations_only_key' => 'Licensnøglen er udelukkende beregnet til brug sammen med Plesk, når dette fungerer inde i følgende virtuelle miljø: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Anvendelse af en brugerdefineret sprogpakke er ikke tilladt.',
    'plesk_key__allowed-locales' => 'Tilgængelige sprog',
    'plesk_key__allowed-locales-any' => 'Et hvilket som helst sprog',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin mappen findes i',
    '_cgi_bin_mode_webspace' => 'abonnementets rod-mappe',
    '_cgi_bin_mode_www_root' => 'dette domænes dokument-rod',

    /// Custom buttons
    'custom_button__sort_key' => 'Prioritet',
    'custom_button__place' => 'Placering',
    'custom_button__place_navigation' => 'Fælles adgang',
    'custom_button__place_admin' => 'Administrators startside',
    'custom_button__place_admin-settings' => 'Administrator\'s Funktioner og indstillinger side',
    'custom_button__place_reseller' => "Forhandlerens startside",
    'custom_button__place_reseller-settings' => 'Forhandlers \'s Væktøjer og tilbehør side',
    'custom_button__place_client' => 'Kundens Hjem-side',
    'custom_button__place_domain' => "Websteder og domæner side for abonnement",
    'custom_button__place_domain_powerUser' => "Websteder og domæner side for abonnement",
    'custom_button__place_domain-properties' => 'Webstedsværktøjer',
    'custom_button__private' => 'Vis kun for mig',
    'custom_button__image' => 'Baggrundsbillede',
    'custom_button__conhelp' => "Værktøjstip-tekst:",
    'custom_button__edit' => "Indstilling af et link til en ekstra service",
    'custom_button__include_client_cname' => "Inkludér kundens firmanavn",
    'custom_button__include_client_email' => "Inkludér kundens e-mailadresse",
    'custom_button__include_client_id' => "Inkludér kunde-ID",
    'custom_button__include_client_pname' => "Inkludér kundens kontaktnavn",
    'custom_button__include_domain_id' => "Medtag abonnements-ID, domæne-ID og domænealias-ID",
    'custom_button__include_domain_id_powerUser' => "Medtag abonnements-ID, domæne-ID og domænealias-ID",

    'custom_button__include_domain_name' => "Inkludér primært domænenavn",
    'custom_button__include_ftp_user' => "Inkludér FTP-brugernavn",
    'custom_button__include_ftp_pass' => "Inkludér FTP-adgangskode",
    'custom_button__internal_open' => "Åbn URL i Plesk",
    'custom_button__text' => "Knapmærke",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Filen er ikke en billedfil.',
    'custom_button__big_image' => 'Filstørrelsen må ikke overskride 100 KB.',
    'custom_button__failed_copy_image' => 'Kunne ikke kopiere filen: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Kan ikke gendanne en ikke-Power User i Power User-visning.',
    '__unknown_network_interface' => 'Ukendt netværksgrænseflade.',

    'init_conf__ip_address' => 'IP-adresse',

    //Confirmation page
    'bt_confirm' => 'Bekræft',
    'b_confirm' => 'Bekræft ejerskab af dine websteder.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Indstillingen af dedikeret IIS-programgruppe er fastlagt i henhold til de overordnede serverydelsesindstillinger (websteds-isoleringskonfiguration).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Indstillingen af dedikeret IIS-programgruppe er fastlagt i henhold til de overordnede serverydelsesindstillinger.',

    '__current' => 'Aktuel',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Brugeregenskaberne blev opdateret.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Du har næsten brugt alle de domæner, der er leveret med din Plesk-licens (90% eller mere).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Du har næsten brugt alle domænerne.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Du har næsten brugt alle de Presence Builder-domæner, der er leveret med din Plesk-licens (90% eller mere).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Du har næsten brugt alle Presence Builder-webstederne.',
    'promo__button_hide' => 'Skjul',
    'promo__button_next' => 'Næste >>',
    'promo__button_prev' => '<< Forrige',
    'promo__button_license' => 'Opdater licens',

    'promo__google_integration_title' => 'Integration med Google services',
    'promo__google_integration' => 'Konfigurér integration med Google services, f.eks. AdSense, Google Apps, Webmaster-værktøjer.',
    'promo__google_integration_button' => 'Konfigurer',

    'promo__button_learn_more' => 'Få flere oplysninger',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Du kan tilpasse grænsefladens udseende og varemærke-indstillinger vha. brugerdefinerede temaer. For instruktioner om tilpasning af Plesk-temaer, se %1.',
    'panel_branding__description_link' => 'følgende dokument',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Udpakning af filer',
    'b_filemanager__extract' => 'Udtræk filer fra de markerede arkiver til den aktuelle mappe. Bemærk, at filnavnene muligvis vises forkert efter udtrækningen, hvis de indeholder nationale tegn.',
    'filemanager_error_extracting_files' => 'Der opstod fejl under udpakning af arkivfilerne: %1',
    'filemanager_no_archive_files_specified' => 'Angiv hvilke filer du vil udpakke.',
    'filemanager_not_zip_archive_specified' => '%1 kan ikke udpakkes. Den er ikke et ZIP-arkiv.',
    'filemanager_files_successfully_extracted' => 'Arkivfiler blev udpakket.',
    'filemanager_error_file_download' => 'Download af filen mislykkedes: %1',
    'filemanager__user_poolgrp' => 'Programpuljegruppe',

    'loading' => 'Indlæser…',
    'bt_create_archive' => 'Føj til arkiv',
    'filemanager__pack' => "Sti til arkivet: %1",
    'filemanager__archive_name' => 'Arkivfilnavn',
    'filemanager__empty_filename' => 'Angiv arkivfilens navn.',
    'filemanager_archive_created' => 'Arkivet blev oprettet.',
    'filemanager_error_creating_archive' => 'Kunne ikke oprette arkivet: %1.',

    'cmd_dns__aaaa_dns_record_already_exist' => "Denne post vil konflikte med AAAA-posten for zonen.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-serveren understøtter ikke IPv6-adresser).",
    'cmd_dns__glue_dns_record_conflict' => 'Denne post vil konflikte med glue-posten for zonen \'%1\'.',
    '__ftp_ipv6_not_supported' => "(FTP-serveren understøtter ikke IPv6-adresser).",
    '__ipv6_not_supported' => 'IPv6 understøttes ikke',
    'mail__ipv6_not_supported' => 'IPv6 understøttes ikke af e-mailserver.',
    'mail__relay_while_list_ipv6_not_supported' => 'IPv6-relæ hvidlisten understøttes ikke af e-mailserver.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Maskeværdien skal være et multiplum af 16.',
    'mail__ip_or_mask_is_invalid' => 'Den angivne IP-adresse eller maske er ugyldig',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Videresendelse til IPv6 IP-adresser understøttes ikke.',
    'sa__invalid_trusted_networks' => 'Forkert specificerede netværk der er tillid til: %1',
    'dns_add__enter_ipv6_address' => "IPv6 adresse",
    'license_trial_days_left' => 'Dit Plesk fungerer med en prøvelicens, der udløber om %1 dage.',
    'excl_ipv6_num' => 'Dedikeret IPv6-adresse',
    '__ip_mask' => "Undernetsmaske",
    '__ipv4_addr' => 'IPv4-adresse',
    '__ipv6_addr' => 'IPv6 adresse',
    'template__num_excl_ipv6s' => 'Reservér dedikerede IPv6-adresser til forhandleren',
    'anonftp__exclusive_ipv4_required' => 'En dedikeret IPv4-adresse kræves for opsætning og brug af anonym FTP-service.',
    'anonftp__ipv4_already_used' => 'Du kan ikke opsætte en anonym FTP-service for dette websted, fordi dette allerede er konfigureret på et andet domæne på samme IPv4-adresse.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'Vis logfilen.',

    'chown__ip_address_warn' => 'Inden abonnementet flyttes til den nye ejer, skal du vælge en ny IP-adresse for abonnementet.',
    'chown__no_ip_address' => 'Ingen',
    'chown__no_ipv4_address' => 'Ingen IPv4-adresse:',
    'chown__no_ipv6_address' => 'Ingen IPv6 adresse',
    'chown__domain_exclude_already_owned_by_client' => 'Abonnementet %1 tilhører allerede denne bruger.',
    'chown__error_ip_absent_in_ip_pool' => 'IP-adressen %1 findes ikke i målbrugerens IP-gruppe.',
    'chown__error_ip_not_exist' => 'IP-adressen med ID \'%1\' findes ikke',
    'chown__error_domain_ip_not_selected' => 'Mindst en IP-adresse for domænet %1 skal vælges. Kontroller de værdier, der er valgt til IP-tilknytning.',

    '__new_passwd_single' => "Adgangskode",
    '__confirm_passwd_single' => "Bekræft adgangskode",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 adressen eller masken er ugyldig: IP-adressen skal være en gyldig unicast-adresse.',

    '__subscriptions' => 'Abonnementer',

    '__owned_by_reseller' => 'ejet af forhandler',
    '__owned_by_provider' => 'ejet af udbyder',

    'service_plan__anonymous' => 'Valgfri',
    'subscription_not_locked__change_limits_warning' => 'Dette abonnement er ikke låst: Ressourceforbrugsgrænserne vil blive ændrede under synkronisering med serviceplanen.',
    'subscription_not_locked__change_permissions_warning' => 'Dette abonnement er ikke låst: Tilladelserne vil blive ændrede under synkronisering med serviceplanen.',

    'subscription__conflict_resolution_policy' => 'Konfliktløsningspolitik',
    'subscription__conflict_resolution_policy_lock' => "Lås abonnement",

    'backup__list__backup_warnings' => 'Advarsler',
    'backup__list__backup_info' => 'Information',
    'backup__restore__object_reseller_template' => 'Forhandlerskabelon',
    'backup__restore__object_domain_template' => 'Domæneskabelon',

    'ui__client/permissions_readonly__title' => 'Rettigheder',
    'ui__client/permissions_readonly__short-title' => 'Rettigheder',

    'subscription__unable_lock_anonymous' => 'Dette abonnement er ikke bundet til en serviceplan, og dermed kan det ikke låses op.',
    'subscription__unable_sync_anonymous' => 'Dette abonnement er ikke bundet til en serviceplan, og dermed kan det ikke synkroniseres.',
    'subscription__unable_sync_locked' => 'Dette abonnement er låst, og dermed kan det ikke synkroniseres.',
    'subscription__locked' => 'Abonnementet er låst.',
    'component_name__urlrewrite' => "Omskrivning af URL-adresser",
    '__quantity' => 'Mængde',
    'hst__www_root_dir_absent' =>  'Advarsel: Den mappe, der er angivet som dokumentrod, findes ikke.',
    'object_creation__domain_is_not_a_webspace' => 'Dette objekt kan kun oprettes i et abonnement.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Abonnementet indeholder websteder, derfor kan du ikke skifte hosting-type eller slette det.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Fejl: Kunne ikke opdatere IP-adresse. Addon-domæner kan ikke tilknyttes en  IP-adresse, der ikke er knyttet til abonnementets hoveddomæne.',
    'domain_plan__unable_change' => 'Det var ikke muligt at ændre serviceplanen: %1',
    'domain_plan__different_hosting_type' => 'Den nuværende type hosting er anderledes end den type, der er angivet i serviceplanen.',
    'domain_plan__addon_text' => 'Tilføjelsesplan',
    'domain_plan__addon_description' => 'Tilføjelsesplan bruges som supplement til en hosting-plan.',
    'asp_net__managed_runtime_version' => 'ASP.NET-administreret runtime-version',
    'plan__can_not_change_hosting_type' => 'Det er ikke muligt at skifte hosting-type ved redigering af en plan.',
    'plan__apply_problems' => 'Planen blev ikke anvendt på grund af problemer med følgende funktionalitet: %1',
    'plan_save__subscription_update_problem' => 'Kan ikke overføre planændringer til %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Abonnementet er midlertidigt suspenderet, indtil sikkerhedskopierings- eller gendannelsesprocessen er færdig. Kom tilbage senere",
    '__login_incorrect_plain_shadow_password' => 'Du angav en forkert adgangskode til administratorens konto. Brug systemadministratorens (rod) akkreditiver, eller få fat i den rigtige adgangskode. Du kan få mere at vide om, hvordan du får fat i adgangskoden, ved at læse filen /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Du kan ikke sende en IP-adresse, du ikke ejer',

    'dns__dns_zone_not_synchronized' => 'DNS-zonen blev ændret. Hvis du vil overføre DNS-skabelonændringerne til denne zone, skal du enten klikke på knappen \'Anvend DNS-skabelonændringer\' på denne side eller vælge kommandoen \'Anvend DNS-skabelonændringer til alle zoner\' i Serveradministration Panel > Funktioner og indstillinger > DNS skabelonindstillinger > Anvend DNS-skabelonændringer.',
    'dns__dns_zone_synchronize_link' => 'Klik på',
    'dns__dns_zone_synchronize_done' => 'DNS-zonen blev synkroniseret korrekt.',

    'dns__dns_zone_template_error' => 'Der var problemer med synkronisering af DNS-zoner med DNS-zone skabelon .%1',

    'dns__soa_rname_type_owner' => 'Webstedsejerens e-mail adresse.',
    'dns__soa_rname_type_domain' => 'Domæne email-adresser',
    'dns__soa_rname_type_external' => 'Ekstern email-adresse',
    'dns__soa_rname_enforce_email' => 'Forbyd ændring af RNAME email-adresse på en pr. domæne-basis',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'Email-adressen til den person, der har ansvaret for domænets DNS-zone. Returneret af DNS-serveren som respons på SOA-forespørgsler.',

    'dns__dns_zone_soa_sync_title' => 'Tilsidesæt SOA-indstillingerne for alle eksisterende domæner',
    'dns__dns_zone_soa_sync_legend' => 'Bekræftelse kræves',
    'dns__dns_zone_soa_sync_text' => 'Opdatere SOA-poster for alle hostede domæner ved at anvende de ændringer, der af foretaget i SOA-skabelon?',

    'cu_db__repair_mysql_dbus' => "Reparer MariaDB/MySQL-brugeradgangskoder. Denne handling er påkrævet, hvis du opgraderede til Plesk 11 fra tidligere versioner.",

    'cu_scheduled_backup_comment' => 'Planlagt sikkerhedskopiering',
    'cu_scheduled_backup_error' => 'Der opstod en fejl under sikkerhedskopieringsprocessen: %1',
    'cu_scheduled_backup_mail_subject' => 'Der opstod en fejl under den planlagte sikkerhedskopieringsproces: %1',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk adgangspunkt: %2 \n\nFølgende fejl opstod under planlagt sikkerhedskopieringsproces: \n\n%3",

    'cu_scheduled_backup_hourly' => 'Timebaseret sikkerhedskopiering',
    'cu_scheduled_backup_daily' => 'Daglig sikkerhedskopiering',
    'cu_scheduled_backup_weekly' => 'Ugentlig sikkerhedskopiering',
    'cu_scheduled_backup_monthly' => 'Månedlig sikkerhedskopiering',
    'cu_scheduled_backup_comment_backup_all' => '%1. Al konfiguration og alt indhold.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Al konfiguration og indhold undtagen e-mailbeskeder.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Kun konfiguration og e-mailbeskeder.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Al konfiguration og indhold undtagen brugerdatabaser.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Al konfiguration og indhold undtagen brugerfiler.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Kun konfiguration og brugerdatabaser.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Kun konfiguration og brugerfiler',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Konfiguration af domæne.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Lagring af planlagte sikkerhedskopier på et eksternt cloud-lager er en premium-funktion Kontakt din hostingudbyder for at låse den op.',

    'i_backup_invalid_file' => 'Dette er ikke en gyldig sikkerhedskopi. Data kan ikke gendannes fra denne fil. Klik på sikkerhedskopiens navn for at få flere oplysninger.',

    'ui__server/migration/download-agent__short-title' => 'Download Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Download Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Download den seneste version af Migration & Transfer Agenten fra Plesk-webstedet.',

    'filemanager_resulting_archive_exists' => 'Filen %1 findes allerede i målmappen.',

    'agent_unable_to_connect' => 'Der kan ikke oprettes forbindelse agenten på \'%2\'. Kontroller at agenten er installeret og kører, og at der ikke er tilslutningsproblemer til hosten \'%2\'.',
    'agent_test_connection_failed' => 'Forbindelse til agenten på \'%2\' mislykkedes.',

    'agent_unable_to_resolve_host' => 'Kunne ikke finde den eksterne vært \'%1\'. Kontroller at der ikke er tilslutningsproblemer til host-computeren.',
    'agent_unknown_curl_error' => 'Fejlen \'%1\' opstod under tilslutning til agenten på \'%2\'.',
    'agent_unexpected_htp_code' => 'Der blev modtaget en uventet HTTP-kode \'%1\' på HTTP-anmodningen til agenten på \'%2\'.',
    'agent_unable_to_auth' => 'Kunne ikke blive godkendt på host\'en \'%1\'. Du kan løse dette ved at følge instruktionerne på http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Der opstod en intern serverfejl under kommandoafviklingen på den eksterne host \'%1\'.',
    'agent_response_is_empty' => 'Der blev modtaget en tom respons på HTTP-forespørgslen til agenten på \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Kunne ikke finde Migration & Transfer Agent i den lokale cache. Genåbn Migration &Transfer Manager for at løse problemet.',

    '__hosting_webdeploy' => "Webdeployeringspublicering",
    'cu_domain__webdeploy' => "Publicering af webdeployering (standard: %1)",
    'cu_dom_tpl__webdeploy' => "Publicering af webdeployering (standard: %1)",
    'cu_subdomain__webdeploy' => "Publicering af webdeployering (standard: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy er ikke installeret på serveren.",
    'webdeploy__forced_by_site_isolation' => "Kunne ikke ændre webdeployerings-udgiverindstillingerne: Du har ikke rettigheder til at tilsidesætte serverens overordnede sikkerhedspolitik. Kontakt din udbyder for flere oplysninger.",



    'backup__restore_options__admin__server_configuration_license' => 'Licensnøgle',
    'migration_start_migrate_server_license' => 'Licensnøgle til overførsel.',

    'defaultcomponents__delegation_rule_not_exist' => '(den nødvendige delegeringsregel \'appPoolPipeline, appPoolNetFx\' findes ikke)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Sikkerhedskopien blev oprettet af administratoren.',
    'i_backup_created_by_reseller' => 'Sikkerhedskopien blev oprettet af en forhandler.',
    'i_backup_created_by_client' => 'Sikkerhedskopien blev oprettet af en kunde.',

    'migration__object_exists_on_target_host' => '(findes allerede på mål-host\'en)',

    '__customers_total' => 'I alt efter kunder',
    '__resellers_total' => 'Total efter forhandlere',
    '__reseller_total' => 'Forhandlertotal',


    'cu_cl_pref__manage_website_maintenance' => 'Adgang til avancerede handlinger: Webstedskopiering',
    'cu_cl_pref__manage_protected_dirs' => 'Administration af adgangskodebeskyttede mapper',
    'cu_cl_pref__manage_mail_settings' => 'Mulighed for at ændre e-mail-indstillinger',


    'cu__command_update_php_settings' => 'Opdaterer PHP-indstillinger.',
    'cu__php_settings_option' => 'Indstiller stien til filen med PHP-índstillinger.',

    'cu__additional_php_settings_option' => 'Indstiller stien til filen med yderligere PHP-direktiver.',
    'cu__command_show_php_settings' => 'Viser de nuværende PHP-indstillinger.',
    'cu__general_settings' => 'Generelle indstillinger:',
    'cu__performance_settings' => 'Ydelsesindstillinger:',
    'cu__php_fpm_settings' => 'PHP-FPM-indstillinger',
    'cu__additional_directives' => 'Yderligere direktiver:',

    'php_settings_permission_required' => 'Administration af fælles PHP-indstillinger',
    'php_settings_performance_permission_required' => 'Administration af hosting-ydelsesindstillinger',
    'php_settings_customized' => 'PHP-indstillingerne blev tilpasset.',
    'php_settings_synchronized_with_plan' => 'PHP-indstillingerne skal være synkroniserede med planen.',
    'phosting__unknown_shell_type' => 'Shell ikke til rådighed',

    'login_up__access_denied_subscription_deleted' => 'Adgang nægtet: Dit abonnement er fjernet.',

    'role_restricted_to_subscription' => '(overført med abonnementet: %1)',

    'filemanager__extract' => "Pak filer ud i: %1",

    'cu__license_command_check_installed_license' => 'Kontroller validiteten af den installerede licensnøgle (returnerer exit-koden 0 hvis nøglen er gyldig og 1 hvis den er ugyldig)',

    'promo__mobile_manager_title' => 'Plesk Mobile Server Manager',
    'promo__mobile_manager' => "Udvid Plesks funktionalitet til at kontrollere og overvåge serveren fra mobile enheder (BlackBerry, iPhone og Android).",
    'promo__mobile_monitor_title' => 'Plesk Mobile Server Monitor',
    'promo__mobile_monitor' => 'Få de vigtigste oplysninger om Plesks servere uanset tid og sted fra en mobil enhed (BlackBerry, iPhone og Android).',
    'promo__mobile_button' => 'Få flere oplysninger',

    'ui__server/migration/video__short-title' => 'Videoøvelser',
    'ui__server/migration/video__title' => 'Se videoøvelser',
    'ui__server/migration/video__description' => 'Se video-eksempler.',

    'subDomainNameHint' => 'Indtast * som et underdomænenavn for at oprette et jokertegn-underdomæne. Webstedsbesøgende omdirigeres til dette underdomæne, uanset hvilket underdomænenavn de indtaster i en browser.',
    'subdomains__wildcard_name_invalid' => "Underdomænets navn er ugyldigt. Du kan kun bruge alfanumerisk tegn, bindestreger (-) og stjerner (*) til joker-underdomænenavne.",
    'subdomains__name_invalid' => "Underdomænets navn er ugyldigt. Du kan kun bruge alfanumerisk tegn og bindestreg (-) til underdomænenavne.",

    'domain__wildcard_no_www_prefix' => 'Det er ikke muligt at bruge præfikset www præfiks til jokertegn-underdomæner.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix e-mailfilter",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3-server:",
    'restart__pop3s' => "Courier POP3-server med SSL/TLS-understøttelse",
    'restart__imap' => "Courier IMAP-server:",
    'restart__imaps' => "Courier IMAP-server med SSL/TLS-understøttelse",
    'restart__authdaemon' => "Courier IMAP godkendelses-daemon",
    'restart__imap-pop3' => "Dovecot IMAP og POP3 server",


    'addon_packages_not_supported' => 'Tilføjelser til APS-pakkede web-programmer understøttes ikke.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Kan ikke automatisk knytte en IP-adresse til domænet. Angiv en IP-adresse vha. muligheden -ip.',

    'plesk_key__mb_accounts' => 'Brugerkonti (forhandlere og kunder) i Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Underdomænets DNS-zone',
    'actionlog__site_subdomain_dns' => 'DNS-zone for et underdomæne under et ekstra domæne',

    // PfW only
    'actionlog__event_site_create' => 'Domæne oprettet',
    'actionlog__event_site_delete' => 'Domæne slettet',
    'actionlog__event_site_update' => 'Domæne opdateret',

    'actionlog__event_site_status_update' => 'Domænestatus opdateret',
    'actionlog__event_site_dns_update' => 'Domænets DNS-zone er opdateret',
    'actionlog__event_site_guid_update' => 'Domæne-GUID opdateret',

    'actionlog__event_site_subdomain_create' => 'Underdomæne oprettet',
    'actionlog__event_site_subdomain_delete' => 'Underdomæne slettet',
    'actionlog__event_site_subdomain_update' => 'Underdomæne opdateret',

    'actionlog__event_site_alias_create' => 'Domænealias oprettet',
    'actionlog__event_site_alias_delete' => 'Domænealias slettet',
    'actionlog__event_site_alias_update' => 'Domænealias opdateret',

    'actionlog__event_site_alias_dns_update' => 'DNS-zone for et domænealias opdateret',
    'actionlog__event_subdomain_dns_update' => 'Et underdomænes DNS-zone under standarddomænet blev opdateret',
    'actionlog__event_site_subdomain_dns_update' => 'DNS-zone for domænealias opdateret',
    // End of PfW only

    'win_policy__bad_password' => 'Validering mislykkedes Adgangskoden er ugyldig.',
    'win_policy__password_too_short' => 'Validering mislykkedes Adgangskoden opfylder ikke kravene i adgangskodepolitikken, fordi den er for kort.',
    'win_policy__password_too_long' => 'Validering mislykkedes Adgangskoden opfylder ikke kravene i adgangskodepolitikken, fordi den er for lang.',
    'win_policy__password_not_complex_enough' => 'Validering mislykkedes. Adgangskoden er ikke kompleks nok, og den opfylder ikke kravene i adgangskodepolitikken. Stærke adgangskoder skal indeholde mindet alle af følgende otte tegn; et stort eller et lille bogstav; tre tal og et specialtegn (!, @, #, $, %, ^, &, *, ?, _, ~) eller et tal og tom specialtegn.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Kan ikke opdatere produktlicens.',


    'filemanager__error_path_is_not_allowed' => 'Stien er ugyldig',
    'filemanager__error_path_is_invalid' => 'Stien er ugyldig.',
    'filemanager__error_path_not_found' => 'Stien findes ikke',
    'filemanager__error_path_already_exists' => 'Stien findes allerede',
    'filemanager__error_access_is_denied' => 'Adgang nægtet',
    'filemanager__error_directory_not_empty' => 'Mappen er ikke tom',
    'filemanager__error_sharing_violation' => 'Delingsovertrædelse',
    'filemanager__error_not_same_device' => 'Destinationstien findes ikke på samme enhed',
    'filemanager__binary_data_access' => 'Denne fil er muligvis en binær fil. Vil du åbne den?',
    'filemanager__unable_to_resolve_realpath' => "Kan ikke finde filen %1 på det angivne sted",
    'filemanager__access_to_realpath_denied' => "Adgang til realpath nægtet: %1 til %2.",
    'bt_exit' => 'Slut',

    'filemanager__chdir_error__' => "Kunne ikke skifte mappe til %1: %2",
    'filemanager__chmod_dir' => "Rediger tilladelser for mappen %1",
    'filemanager__chmod_error__' => "Kunne ikke ændre tilladelser for filen %1 %2",
    'filemanager__chmod_file' => "Rediger tilladelser for filen %1",
    'filemanager__copy_error__' => "Kunne ikke kopiere %1 til %2: %3",
    'filemanager__copy_move' => "Kopier (flyt) filer fra %1",
    'filemanager__count_size__' => 'Markeringsstørrelse: %1',
    'filemanager__count_size_error__' => 'Kunne ikke beregne størrelsen af %1: %2',
    'filemanager__create_dir_error__' => "Kunne ikke oprette mappen %1, %2.",
    'filemanager__dir_not_exists' => "Mappen %1 findes ikke",
    'filemanager__dirname' => "Mappenavn",
    'filemanager__filename' => "Filnavn",
    'filemanager__is_no_such' => "Der er ingen fil eller mappe med navnet %1.",
    'filemanager__empty_selection' => "Der er ikke valgt fil(er).",
    'filemanager__move_error__' => "Kan ikke flytte %1 til %2: %3",
    'filemanager__not_allowed' => "Det er ikke tilladt at ændre tilladelser for denne fil.",
    'filemanager__remove' => "Fjern filer fra %1",
    'filemanager__remove_error__' => "Kan ikke fjerne filen %1, %2",
    'filemanager__rename_dir' => "Omdøb mappen %1",
    'filemanager__rename_error__' => "Kan ikke omdøbe %1 til %2: %3",
    'filemanager__rename_file' => "Omdøb filen %1.",
    'filemanager__set_win_permissions_dir' => "Indstil tilladelser for mappen %1",
    'filemanager__set_win_permissions_file' => "Indstil tilladelser for filen %1",
    'filemanager__touch_confirm' => "Er du sikker på, at du vil ændre tidsmærket på de markerede filer?",
    'filemanager__upload_error__' => "Kunne ikke uploade %1 til %2: %3",
    'filemanager__upload_file' => "Overfør fil",
    'filemanager__upload_file_src' => "Sti til fil",
    'filemanager__max_image_size_exceeded' => 'Billedet kan ikke vises. Billedstørrelsen må ikke væres større %2 bytes.',

    '__fastcgi_unix_support' => 'FastCGI-understøttelse',

    'dns__subdomain_dns_zone_parent' => 'DNS-posterne for dette underdomæne lagres i den overordnede DNS-zone. Du kan ændre den overordnede zone %1 eller oprette en separat zone for underdomænet.',
    'dns__subdomain_dns_zone_parent_link' => 'her',
    'dns__no_dns_zone' => 'Ingen DNS-zoner knyttet til domænet. Du kan administrere DNS-zoner for dit domæne ved at klikke på knappen \'Gendan standarder\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Kan ikke skifte til underdomænets zone, da der er en CNAME-post for dette underdomæne i det overordnede domænes zone.',

    '__hosting_write_modify' => 'Yderligere skrive/ændringstilladelser',

    'aspdotnet__group_framework_version' => "Framework-version",

    'bt_restore_default' => "Sæt til standard",
    'b_autoinstaller' => 'Opdater Plesk eller dets komponenter.',
    'b_autoinstaller_configure' => 'Opdater indstillinger.',
    'b_autoinstaller_install' => 'Installer de valgte komponenter.',

    '__iis_app_pool__use_dedicated' => 'Dedikeret IIS-programgruppe.',
    '__iis_app_pool__use_dedicated_addons' => 'Dedikeret IIS-applikationspulje for hvert websted',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Aktiver 32-bit programmer',
    '__iis_app_pool__load_user_profile' => 'Indlæs brugerprofilen',
    'bt_iis_app_pool' => "IIS-applikationspulje",

    'performance__cpu_usage' => 'Maksimal CPU-anvendelse (%)',
    'performance__cpu_usage_action' => 'Begræns handling',
    'performance__cpu_usage_interval' => 'Begræns interval (minutter)',
    'performance__cpu_usage_action_not_supported' => 'Den angivne handling understøttes ikke af webserveren.',

    'performance__idle_timeout_action_not_supported' => 'Den angivne timeout for ledig tid understøttes ikke af webserveren.',
    'performance__max_worker_processes' => 'Det maksimale antal arbejder-processer',
    'performance__idle_timeout' => 'Ledig-timeout (minutter)',
    'performance__idle_timeout_action' => 'Ledig-timeout handling',
    'performance__recycling_by_time' => 'Genbruger efter regelmæssige tidsintervaller (minutter)',
    'performance__recycling_by_requests' => 'Genbruger når det maksimale antal anmodninger er nået',
    'performance__recycling_by_virtual_memory' => 'Genbruger når den maksimale mængde virtuel hukommelse er brugt',
    'performance__recycling_by_private_memory' => 'Genbruger når den maksimale mængde privat hukommelse er brugt',
    'performance__managed_pipeline_mode' => 'Administreret pipelinetilstand',
    'performance__managed_pipeline_mode_not_supported' => 'Den angivne tilstand understøttes ikke af webserveren.',

    'iis_app_pool' => 'Administration af IIS-programgruppe',
    'b_iis_app_pool' => 'Administrér IIS-programgruppe',
    'iis_app_pool_cl_dom' => 'Administration af IIS-programgruppe',

    'l_webdirerrordocslist_code' => 'Sortér fejldokumenter efter fejlkodenummer.',
    'l_webdirerrordocslist_name' => 'Sortér fejldokumenter efter fejlbeskrivelse.',
    'l_webdirerrordocslist_type' => 'Sortér fejldokumenter efter fejldokumenttype.',
    'l_webdirerrordocslist_location' => 'Sortér fejldokumenter efter dokumentplacering.',

    'b_webdirerrordocslist_search' => 'Angiv et søgemønster og klik for at finde fejldokumenter.',
    'b_webdirerrordocslist_remove' => 'Slet markerede fejldokumenter.',
    'b_webdirerrordocslist_show_all' => 'Vis alle fejldokumenter',

    'l_webdirmimetypeslist_name' => 'Sortér MIME-typer efter filnavnsudvidelse.',
    'l_webdirmimetypeslist_content' => 'Sortér MIME-typer efter indhold.',

    'b_webdirmimetypeslist_remove' => 'Slet markerede MIME-typer.',
    'b_webdirmimetypeslist_search' => 'Angiv et søgemønster og klik for at finde MIME-typer.',
    'b_webdirmimetypeslist_show_all' => 'Vis alle typer MIME-typer.',

    'b_webdir_preferences' => "Indstillinger for virtuel mappe.",
    'b_webdir_permissions' => "Tilladelser til virtuelle mapper.",
    'b_webdir_permissions_disabled' => "Administration af mappetilladelser er ikke tilgængelig.",
    'b_to_webdirs' => 'Returnér til administration af mapper.',
    'b_to_webdir_mime_types' => 'Tilbage til administration af MIME-types.',
    'b_to_webdir_error_docs' => 'Returnér til administration af fejldokumenter.',
    'b_to_webdir_protection' => 'Returnér til administration af beskyttelse af virtuel mappe.',

    'webdirs__title' => 'Virtuel mappe %1',
    'webdirs__preferences_title' => 'Indstillinger af virtuel mappe',
    'webdirs__tabs_general' => 'Generelt',
    'webdirs__tabs_mime_types' => 'MIME-typer',
    'webdirs__tabs_error_docs' => 'Fejldokumenter',

    'webdirs__tabs_permissions' => 'Rettigheder',
    'webdir__remove_vdirs' => 'Følgende virtuelle mapper vil blive slettet:',
    'webdir__remove_mime_types' => 'Følgende MIME-typer vil blive slettet:',
    'webdir__mime_types_title' => 'MIME-typer',
    'webdir__protection_disable_confirm' => 'Vil du virkelig fjerne beskyttelsen af mappen?',
    'webdir__protect_title' => 'Beskyttet URL-brugere',
    'webdirs__permissions_title' => 'Rettigheder til virtuel mappe',
    'error_doc__list_code' => 'Fejl',
    'error_doc__list_code_description' => 'Beskrivelse',
    'error_doc__list_type' => 'Type',
    'error_doc__list_location' => 'Placering',
    'error_doc__code' => 'Fejl',
    'error_doc__type' => 'Type',
    'error_doc__type_file' => 'Fil',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Placering',
    'error_doc__legend' => 'Fejldokument',
    'error_doc__edit_title' => 'Rediger fejldokumenter',
    'error_doc_erorr_invalid_url_location' => 'Den angivne URL er ugyldig. Angiv den korrekte URL.',
    'error_doc_erorr_invalid_file_location' => 'Filstien er ugyldig Angiv den korrekte fil-sti.',
    'error_doc__type_default' => 'Standard',

    'webdirs__tabs_protection' => 'Beskyttelse',
    'pb_webdirs' => 'Virtuelle mapper',

    'webdirs_mime_types_remove_title' => 'Følgende MIME-typer fjernes:',
    'webdirs_preferences_title' => 'Indstillinger af virtuel mappe',
    'webdirs_permissions_title' => 'Specialrettigheder for filer og mapper',
    'webdi_protection_disable_confirm' => 'Er du sikker på, at du vil fjerne beskyttelsen af den virtuelle mappe? Dette vil også fjerne alle beskyttede mappebrugere og mappebeskyttelsesindstillinger.',
    'bt_protect' => 'Beskyt',
    'bt_unprotect' => 'Fjern beskyttelse',
    'bt_show_additional_users' => 'Vis flere brugere',
    'bt_hide_additional_users' => 'Vis færre brugere',
    'error_doc__list_title' => 'Fejldokumenter',
    'error_doc__list_header' => 'Fejldokumenter',
    'error_doc__code_400' => 'Anmodningen er ugyldig',
    'error_doc__code_401' => 'Uautoriseret',
    'error_doc__code_401.1' => 'Uautoriseret - Indlogning mislykkedes',
    'error_doc__code_401.2' => 'Uautoriseret - Indlogning mislykkedes pga. serverkonfigurationen',
    'error_doc__code_401.3' => 'Uautoriseret - Uautoriseret pga. ACL på ressource',
    'error_doc__code_401.4' => 'Uautoriseret - Autorisation mislykkedes pga. filter',
    'error_doc__code_401.5' => 'Uautoriseret - Godkendelse mislykkedes pga. et ISAPI/CGI-program.',
    'error_doc__code_401.7' => 'Uautoriseret - Afvist pga. URL-godkendelsespolitik',
    'error_doc__code_403' => 'Forbudt',
    'error_doc__code_403.1' => 'Forbudt - Execute-adgang nægtet',
    'error_doc__code_403.2' => 'Forbudt - Læseadgang nægtet',
    'error_doc__code_403.3' => 'Forbudt - Skriveadgang nægtet',
    'error_doc__code_403.4' => 'Forbudt - SSL 128 kræves',
    'error_doc__code_403.5' => 'Forbudt - SSL 128 kræves',
    'error_doc__code_403.6' => 'Forbudt - IP-adresse afvist',
    'error_doc__code_403.7' => 'Forbudt - Klientcertifikat kræves',
    'error_doc__code_403.8' => 'Forbudt - Webstedsadgang nægtet',
    'error_doc__code_403.9' => 'Forbudt - For mange brugere',
    'error_doc__code_403.10' => 'Forbudt - Ugyldig konfiguration',
    'error_doc__code_403.11' => 'Forbudt - Ændring af adgangskode',
    'error_doc__code_403.12' => 'Forbudt - Mapper nægtet adgang',
    'error_doc__code_403.13' => 'Forbudt - Klientcertifikat tilbagekaldt',
    'error_doc__code_403.14' => 'Forbudt - Mappe-listning nægtet',
    'error_doc__code_403.15' => 'Forbudt - Klientadgangslicens overskredet',
    'error_doc__code_403.16' => 'Forbudt - Klientcertifikat forkert formet eller ikke-tillidsvækkende',
    'error_doc__code_403.17' => 'Forbudt - Klientcertifikat udløbet eller ikke gyldigt endnu.',
    'error_doc__code_403.18' => 'Forbudt - Kan ikke udføre anmodning fra denne programpulje',
    'error_doc__code_403.19' => 'Forbudt - CGI-adgang nægtet',
    'error_doc__code_403.20' => 'Forbudt - Passport-indlogning mislykkedes',
    'error_doc__code_404' => 'Ikke fundet',
    'error_doc__code_404.2' => 'Ikke fundet - Nægtet pga. nedlukningspolitik',
    'error_doc__code_404.3' => 'Ikke fundet - Nægtet pga. MIMEMAP-politik',
    'error_doc__code_405' => 'Metode ikke tilladt',
    'error_doc__code_406' => 'ikke acceptabelt',
    'error_doc__code_407' => 'Proxygodkendelse kræves.',
    'error_doc__code_412' => 'Precondition mislykkedes.',
    'error_doc__code_414' => 'Anmodnings-URI var for lang',
    'error_doc__code_415' => 'Medietypen understøttes ikke.',
    'error_doc__code_500' => 'Intern serverfejl',
    'error_doc__code_500.12' => 'Intern serverfejl - Program genstarter',
    'error_doc__code_500.13' => 'Intern serverfejl - Server for travl',
    'error_doc__code_500.15' => 'Intern serverfejl - Direkte anmodninger om GLOBAL.ASA forbudt',
    'error_doc__code_500.16' => 'Intern serverfejl - UNC-adgangsfejl',
    'error_doc__code_500.17' => 'Intern serverfejl - URL-godkendelsessted ikke fundet',
    'error_doc__code_500.18' => 'Intern serverfejl - URL-godkendelsessted kan ikke åbnes',
    'error_doc__code_500.19' => 'Intern serverfejl - Forkerte fil-metadata',
    'error_doc__code_500.100' => 'Intern serverfejl - ASP-fejl',
    'error_doc__code_501' => 'Ikke implementeret',
    'error_doc__code_502' => 'Ugyldig gateway',
    'error_doc__code_503' => 'Service midlertidigt utilgængelig',

    'mimetype__extension' => 'Lokalnummer',
    'mimetype__content' => 'Indhold',
    'mimetypeslist__title' => 'MIME-typer',
    'mimetypes__title' => 'MIME-typer',
    'mimetypes__select_to_remove' => 'Marker de MIME-typer du vil fjerne.',
    'mimetypes__select_for_remove' => "Vælg de MIME-typer der skal fjernes.",
    'mimetypes_remove__title' => 'Fjern -MIME-type',
    'mimetype__legend' => 'Mime-type',
    'mimetype_edit__title' => 'Rediger MIME-type',
    'mimetype_edit__already_exists' => 'MIME-type er allerede defineret for denne udvidelse.',
    'mimetype_edit__not_exists' => 'MIME-typen findes ikke.',
    'mimetype__content_type_other' => 'Valgfri...',

    'b_webdir_protection_enable' => 'Gør URL der korresponderer med mappen adgangskodebeskyttet.',
    'b_webdir_protection_disable' => 'Gør URL der korresponderer med mappen tilgængelig for alle.',
    'b_webdir_protection_disabled' => 'Beskyttelse af virtuel mappe er deaktiveret.',

    'b_pd_usr_create' => 'Klik for at oprette denne beskyttede URL-bruger.',
    'php__group_php_version' => "PHP-version",

    'virtualdir__name' => 'Navn',
    'virtualdir__path' => 'Sti',
    'virtualdir__read' => 'Læserettigheder',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Skrivetilladelse',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Script-kildeadgang',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Biblioteksgennemsyn',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Udfør tilladelser',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Før logfil over besøg',
    'virtualdir__app_create' => 'Opret program',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Aktiverer anonym godkendelse.',
    'virtualdir__auth_windows' => 'Aktiverer Windows-godkendelse.',
    'virtualdir__auth_not_enabled' => 'Anonym- eller  Windows-godkendelse skal være aktiveret.',
    'virtualdir__require_ssl' => 'Kræver -SSL/TLS',
    'virtualdir__enable_default_doc' => 'Brug standarddokumenter',
    'virtualdir__default_doc' => 'Standard dokument-søgerorden',
    'virtualdir__enable_parent_paths' => 'Tillad brug af overordnede stier',
    'virtualdir__execute_in_mta' => 'Tillad programafvikling i MTA (multi-threaded apartment) tilstand',
    'virtualdir_create__title' => 'Opret virtuel mappe i %1',
    'virtualdir_edit__title' => 'Egenskaber for den virtuelle mappe %1',
    'virtualdir_edit__legend' => 'Virtuel mappe',
    'virtualdir_edit__application_legend' => 'Programindstillinger',
    'virtualdir_edit__security_legend' => 'Mappesikkerhed',
    'virtualdir_edit__documents_legend' => 'Dokumenter',
    'virtualdir_edit__list_legend' => 'Indlejrede virtuelle mapper.',
    'virtualdir_error__path_not_in__' => 'Der er angivet en ugyldig sti',
    'virtualdir_error__already_exists' => 'Der findes allerede en mappe med et sådant navn.',
    'virtualdir_root' => 'Virtuelle mapper',
    'virtualdir_root__title' => 'Virtuelle mapper',
    'virtualdir_root__list_legend' => 'Virtuelle mapper',
    'virtualdir_se__none' => 'Ingen',
    'virtualdir_se__script' => 'Kun scripts',
    'virtualdir_se__script_execute' => 'Scripts og eksekverbare filer',
    'virtualdirs__title' => 'Virtuelle mapper',
    'virtualdirs__path_not_exists' => 'Stien er ugyldig',
    'virtualdirs__select_for_remove' => "Vælg de virtuelle mapper, der skal fjernes.",
    'virtualdirs_remove__title' => 'Fjern virtuelle mapper',
    'virtualdirs_phys_dir_exist' => 'En fysisk mappe med et sådant navn findes allerede. Hvis du fortsætter, vil det blive utilgængeligt. Vil du fortsætte?',
    'virtualdir_auto_create_dir' => "Opret fysisk mappe med det samme navn som virtuel mappe",

    'asp_max_default_text' => 'Defineret af overordnet mappe (%1 KB)',
    'asp_max_default_text_site' => 'Defineret af IIS (%1 KB)',
    'asp_max_buffer_text' =>'ASP-bufferens maksimumsstørrelse (KB)',
    'asp_max_body_text' => 'Maksimumstørrelse for hele indholdet af en ASP-anmodning (KB)',
    'asp_buffers_legend' =>'ASP-indstillinger',

    'asp_debug_default_text' =>'Defineret af overordnet mappe',
    'asp_debug_default_text_site' =>'Defineret af IIS',
    'asp_client_debug_text' =>'Aktiver fejlfinding af ASP-scripts på klientsiden',
    'asp_server_debug_text' =>'Aktiver fejlfinding af ASP-scripts på serversiden',

    'webdirs__physical_path_not_exist' => "Den angivne sti findes ikke.",

    'permissions__group_or_user_name' => 'Gruppe- eller brugernavne:',
    'permissions__FullControl' => 'Fuld kontrol',
    'permissions__Modify' => 'Ret',
    'permissions__ReadAndExecute' => 'Læs og kør',
    'permissions__ListFolderContents' => 'Visning af mappeindhold',
    'permissions__Read' => 'Læs',
    'permissions__Write' => 'Skriv',
    'permissions__ReadControl' => 'Læsningskontrol',
    'permissions__WriteControl' => 'Skrivekontrol',
    'permissions__ExecuteControl' => 'Udførelseskontrol',
    'permissions__TraverseFolderOrExecuteFile' => 'Gennemgang af mappe/kør fil',
    'permissions__ListFolderOrRead' => 'Vis mappe/læs data',
    'permissions__CreateFilesOrWrite' => 'Oprettelse af filer/skrivning af data',
    'permissions__CreateFoldersOrAppend' => 'Oprettelse af mapper/tilføjelse af data',
    'permissions__DeleteSubfoldersandFiles' => 'Sletning filer og undermapper',
    'permissions__Delete' => 'Slet',
    'permissions__ChangePermissions' => 'Ret tilladelser',
    'permissions__TakeOwnership' => 'Overtag ejerskab',
    'permissions__inherited_from' => 'Arvet fra',
    'permissions__not_inherited' => '<ikke nedarvet>',
    'permissions__apply_to' => 'Gælder for',
    'permissions__apply_onto' => 'Anvend på:',
    'permissions__apply_onto1' => 'Kun denne mappe',
    'permissions__apply_onto2' => 'Kun undermapper',
    'permissions__apply_onto3' => 'Denne mappe og undermapper',
    'permissions__apply_onto4' => 'Kun filer',
    'permissions__apply_onto5' => 'Denne mappe og filer',
    'permissions__apply_onto6' => 'Kun filer og undermapper',
    'permissions__apply_onto7' => 'Denne mappe, undermapper, og filer',

    'filemanager__not_allowed_dir' => "Det er ikke tilladt at ændre tilladelser for denne mappe.",

    'filemanager__allow' => "Tillad",
    'filemanager__deny' => "Afvis",
    'filemanager__user_domusr' => 'Webstedsadministrator',
    'filemanager__user_webusr' => 'Webbruger',
    'filemanager__user_admins' => 'Administratorer',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'ASP.NET-bruger',
    'filemanager__user_poolusr' => 'Programgruppebruger',
    'filemanager__user_sysaccount' => 'Ekstra systembruger',

    'bt_permissions_advanced' => 'Avanceret',
    'b_permissions_advanced' => 'Klik for at vise og oprette specielle tilladelser.',

    'hotlink-protection_invalid_friend_domain' => 'Ugyldigt navn for hvidlistet domæne.',
    'hotlink-protection_duplicate_friend_domain' => 'Dubleret navn for hvidlistet domæne.',
    'hotlink-protection_invalid_extensions' => 'Filnavnsudvidelser indeholder ugyldige tegn.',

    'i_domain_alias_status_on' => 'Domænealias er aktiveret.',
    'i_domain_alias_status_off' => 'Domænealias er deaktiveret.',
    'i_domain_alias_status_with_parent' => 'Mailservice er deaktiveret, fordi domænet er deaktiveret.',
    'i_domain_alias_turn_off' => 'Klik for at deaktivere.',
    'i_domain_alias_turn_on' => 'Klik for at aktivere.',
    'i_domain_alias_mail_on' => 'Mailservice er aktiveret for dette domænealias.',
    'i_domain_alias_mail_off' => 'Mailservice er deaktiveret for dette domænealias.',
    'i_domain_alias_mail_with_parent' => 'Mailservice er deaktiveret, fordi domænealiasset er deaktiveret.',
    'i_domain_alias_web_on' => 'Webservice er aktiveret for dette domænealias.',
    'i_domain_alias_web_off' => 'Webservice er deaktiveret for dette domænealias.',
    'i_domain_alias_web_with_parent' => 'Mail service er deaktiveret, fordi domænealiasset er deaktiveret.',
    'i_domain_alias_dns_on' => 'DNS alias-service er aktiveret for dette domænealias.',
    'i_domain_alias_dns_off' => 'DNS alias-service er deaktiveret for dette domænealias.',
    'i_domain_alias_dns_with_parent' => 'DNS-synkronisering med det overordnede domæne er deaktiveret, fordi domænealiasset er deaktiveret.',
    'i_domain_alias_seoRedirect_on' => 'Omdirigering vha. HTTP-kode 301 er aktiveret for dette domænealias.',
    'i_domain_alias_seoRedirect_off' => 'Omdirigering vha. HTTP-kode 301 er deaktiveret for dette domænealias.',
    'i_domain_alias_seoRedirect_with_parent' => 'Omdirigering vha. HTTP-kode 301 er deaktiveret, da domænealias er deaktiveret.',

    'domain_alias__control_title' => 'Domænealias %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Servicenavn',
    'domain_alias__control_details_title' => 'Detaljer',

    'domain_alias__invalid_values' => 'Det angivne domænenavn er ugyldigt. Domænenavne kan bestå af bogstaver, cifre og bindestreger. Hver enkelt del af domænenavnet mellem punktummerne må ikke være længere end 63 tegn.',
    'domain_alias__domain_already_exists' => "Forkert navn på domænealias %1. Domænet %1 findes allerede.",
    'domain_alias__www_prefix_domain_already_exists' => "Forkert navn på domænealias www .%1. Dette alias er allerede oprettet til domænet %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Forkert navn på domænealias-webmail.%1. Dette alias er allerede oprettet til domænet %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Forkert navn på domænealias-lister.%1. Dette alias er allerede oprettet til domænet %1.',
    'domain_alias__dns_record_already_exists' => 'Kunne ikke oprette domænealiasset %1, fordi en DNS-post, som peger på værten %1 allerede findes.',
    'domain_alias__domain_alias_already_exists' => "Et domænealias med et sådant navn findes allerede.",
    'domain_aliases__mail_server_not_support_aliases' => 'Mailserveren understøtter ikke funktionen Domænealias. Domænesaliasser fungerer muligvis ikke korrekt.',
    'domain_alias__restrict_domain_creation' => 'Det angivne navn for et domænealias er ikke tilladt iht.. den overordnede serverpolitik.  Hvis dette domænealias navn tilhører dig, skal du kontakte din hosting-udbyder.',
    'domain_alias__restrict_creation_with_www' => 'Indtast et domænenavn uden præfikset \'www\'. Præfikset www for domænet vil automatisk blive føjet til webserver konfigurationen.',
    'domain_unable_to_set_name' => 'Forkert navn %1.',

    'domain_alias__domain_service_dns_disabled' => 'Dette domæne leveres af en anden DNS-server.',
    'domain_alias__domain_service_dns_enabled_master' => 'Denne DNS-server fungerer som den primære navneserver for denne DNS-zone.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Denne DNS-server fungerer som en sekundær navneserver for denne DNS-zone.',
    'domain_alias__domain_service_mail_enabled' => 'Mailservice er aktiveret for domænet.',
    'domain_alias__domain_service_mail_disabled' => 'Mailservice er deaktiveret for domænet.',
    'domain_alias__domain_service_mail_mx' => '%1 bruges som e-mailserver.',

    'domain_alias__service_seoRedirect_hint' => 'Når besøgende åbner aliasets URL, bliver de omdirigeret til det primære domænes URL. Plesk bruger den søgemaskinevenlige HTTP 301-omdirigering, hvilket betyder, at søgemaskine-ranking ikke vil blive delt mellem URL\'erne.',

    'bt_task_run_now' => 'Kør nu',
    'ftp__read_perm' => "Læserettigheder",
    'ftp__write_perm' => "Skrivetilladelse",

    'filemanager__upload_backup_file_hint' => 'Her kan du uploade sikkerhedskopifiler til Plesk-opbevaringsområdet. Den maksimale filstørrelse er begrænset til to gigabyte.',

    '__default_for_mssql' => 'standard for MS SQL',

    '__login_does_not_pass_validation' => "Brugernavnet er ugyldigt. Kontrollér, at det opfylder følgende krav: %1",
    '__login_allowed_symbols' => 'Kun alfanumeriske tegn, inklusive punktum, bindestreg og understregning, er tilladt. Det første tegn skal være alfanumerisk.',

    'restart__nginx' => 'Reverse Proxy-server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Jeg vil gerne modtage generelle produktoplysninger og materialer fra Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Jeg vil gerne modtage sikkerhedsrelaterede oplysninger og andre tekniske adviseringer fra Plesk.",

    '__login_status_inactive' => 'Din konto er inaktiv Kontakt Pleskadministratoren.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Tilbage til den siden Funktioner og indstillinger. Migreringen fortsættes i baggrunden.',

    'ui__admin-alias-info__description' => "Rediger kontaktinformation for den ekstra administratorkonto.",
    'ui__admin-alias-info__short-title' => "Kontaktinformation",
    'ui__admin-alias-info__title' => "Ekstra administratorkonto-information",
    'ui__admin-alias-password__description' => "Rediger den ekstra administrators adgangskode.",

    'ui__admin-alias-password__short-title' => "Skift adgangskode",
    'ui__admin-alias-password__title' => "Ekstra-administrators adgangskode",
    'ui__admin-alias__description' => "Se og rediger ekstra administratorkonti-informationer.",

    'chk_js__warning_about_login_syntax' => "Du kan bruge små alfanumeriske tegn, bindestreger og understregningssymboler i brugernavnet. Brugernavnet skal begynde med enten et bogstav eller et tal. Adgangskoden må ikke indeholde brugernavnet eller citationstegn.",
    'chk_js__warning_about_ftp_login_syntax' => "Du kan bruge alfanumeriske tegn, bindestreger og understregningssymboler i brugernavnet.",
    'chk_js__warning_about_login_syntax_win' => "Du kan bruge små alfanumeriske tegn, bindestreger og understregningssymboler i brugernavnet. Brugernavnet skal begynde med enten et bogstav eller et tal. Adgangskoden må ikke indeholde brugernavnet eller citationstegn.",
    'chk_js__warning_about_passwd_syntax' => "Brug ikke anførselstegn, mellemrum og nationale alfabetiske tegn i en adgangskode. \nAdgangskoden skal være på mellem %1 og %2 tegn og den bør ikke indeholde brugernavnet.",
    'chk_js__warning_about_plesk_login_syntax' => "Du kan bruge små alfanumeriske tegn, bindestreger og understregningssymboler i brugernavnet.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Du kan bruge små alfanumeriske tegn, bindestreger og understregningssymboler i brugernavnet. Brugernavnet skal begynde med enten et bogstav eller et tal.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Brug ikke anførselstegn, mellemrum og nationale alfabetiske tegn i en adgangskode. \nAdgangskoden skal være på mellem %1 og %2 tegn og den bør ikke indeholde brugernavnet.",
    'chk_js__warning_about_pam_passwd_error' => "Forkert systembruger konto blev angivet: %1",

    'cmd_server__admin_alias_not_found' => "Kan ikke finde den yderligere administrator-konto.",

    'panel_branding__skins_already_exists' => "Bemærk: Temaet '%1' findes allerede. Det vil blive erstattet med det tema, du nu installerer.",
    'panel_branding__skins_file_exists' => "Kunne ikke oprette mappe til temaet '%1': Der findes allerede en fil af dette navn.",

    'actionlog__login_failed' => 'kunne ikke logge ind',
    'actionlog__event_cp_user_login_failed' => 'Pleskbruger kunne ikke logge ind',
    'actionlog__api_login_failed' => 'kunne ikke logge ind via API',
    'actionlog__event_cp_user_api_login_failed' => 'Pleskbruger kunne ikke logge ind via API',
    'actionlog__pw_reset' => 'anmodning om nulstilling af adgangskode',
    'actionlog__pw_admin_force_reset' => 'anmodede om tvungen nulstilling af administratorens adgangskode',

    'ch_pass_admin__email_subject' => "Plesk adgangskodepåmindelse",
    'ch_pass_admin__email_body' => "Hej, %1.\n\nAdministratorens adgangskode kan ikke sendes via e-mail af sikkerhedsgrunde.\n\nDu skal bruge kommandoen 'plesk login' for at logge på som administrator.\n\nDu kan indstille en ny 'admin'-adgangskode ved at bruge kommandoen 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Kan ikke sende e-mailen: %1',

    'ch_pass_by_secret__email_subject' => "Plesk adgangskodepåmindelse",
    'ch_pass_by_secret__email_body' => "Hej %2,\n\nDu kan oprette en ny adgangskode ved at følge linket: %1\n\nDit login: %3",
    'ch_pass_by_secret__message_send_error' => 'Kunne ikke sende den hemmelige kode: %1!s!',
    'ch_pass_by_secret__title' => 'Skift din adgangskode',
    'ch_pass_by_secret__secret' => 'Hemmelig kode',

    'custom_button__noframe' => "Brug ikke rammer",

    'custom_button__internal_hint' => 'Angiv om URL skal åbnes på en Plesk-side eller i et nyt browservindue.',
    'custom_button__noframe_hint' => 'Hvis du tilføjer en brugerdefineret knap, der fører til en Plesk-udvidelse i Kundepanelet, kan du angive, hvordan denne udvidelse/dette program skal vises: i en ramme eller som del af Plesk GUI.',


    'actionlog__patch' => 'Opdatering',
    'actionlog__patch_available' => 'til rådighed',
    'actionlog__event_patch_available' => 'Der findes en opdatering',
    'actionlog__patch_installed' => 'installeret',
    'actionlog__event_patch_installed' => 'Opdatering installeret',

    'actionlog__extension' => 'Lokalnummer',
    'actionlog__extension_status' => 'Udvidelsesstatus',
    'actionlog__cloning' => 'Serverkloning',
    'actionlog__cloning_complete' => 'komplet',
    'actionlog__event_cloning_complete' => 'Serverkloning afsluttet',

    'actionlog__ssl_web_binding' => 'SSL/TLS-certifikat på domæne',
    'actionlog__ssl_web_binding_update' => 'tilknyttet/af-tilknyttet',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS-certifikat på domæne tilknyttet/af-tilknyttet',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-certifikat på webmail',
    'actionlog__ssl_web_mail_binding_update' => 'tilknyttet/af-tilknyttet',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS-certifikat på webmail tilknyttet/af-tilknyttet',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-certifikat på mailserver',
    'actionlog__ssl_mail_binding_update' => 'tilknyttet/af-tilknyttet',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-certifikat på mailserver tilknyttet/af-tilknyttet',

    'actionlog__ssl_panel_binding' => 'SSL/TLS-certifikat på Plesk',
    'actionlog__ssl_panel_binding_update' => 'tilknyttet/af-tilknyttet',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-certifikat på Plesk tilknyttet/af-tilknyttet',

    'actionlog__hostname' => 'Hostnavn for server',
    'actionlog__hostname_changed' => 'ændret',

    'actionlog__smb_user' => 'Ekstra bruger',
    'actionlog__smb_user_create' => 'Ekstra bruger oprettet',
    'actionlog__smb_user_delete' => 'Ekstra bruger slettet',
    'actionlog__smb_user_update' => 'Ekstra bruger opdateret',

    'actionlog__event_mail_management_status_update' => 'Opdatering af status for e-mailadministration',
    'actionlog__mail_management' => 'Status for e-mailadministration',
    'actionlog__mail_management_status_update' => 'opdateret',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'I alt efter domæner',

    'chk_js__warning_about_admin_passwd_syntax' => "Brug ikke anførselstegn, mellemrum, semikolon og nationale alfabetiske tegn i en adgangskode. \nAdgangskoden skal være på mellem %1 og %2 tegn og den bør ikke indeholde brugernavnet.",

    'passwordSecurityLevelCheckFailed' => 'Din adgangskode er ikke kompleks nok. I henhold til serverpolitikken er den minimale adgangskodestyrke %1. For at forbedre adgangskodestyrken skal du bruge tal, små og store bogstaver samt specialtegn som f.eks. !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Meget svag',
    'passwordSecurityLevelCheckFailedWeak' => 'Svagt',
    'passwordSecurityLevelCheckFailedMediocre' => 'Mellem',
    'passwordSecurityLevelCheckFailedStrong' => 'Stærkt',
    'passwordSecurityLevelCheckFailedStronger' => 'meget stærk',

    'ui__client/domain/dns/sync__description' => 'Overfør ændringer fra den overordnede server-DNS-skabelon til zonen.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Kan ikke overføre DNS-skabelonændringer til zonen, da denne betjenes af en anden DNS-server.',
    'ui__client/domain/dns/sync__short-title' => 'Anvend DNS-skabelonændringer',
    'ui__client/domain/dns/sync__done' => 'Ændringerne fra DNS-skabelonen blev korrekt overført til zonen',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Overfør ændringer fra den overordnede server-DNS-skabelon til zonen.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Kan ikke overføre DNS-skabelonændringer til zonen, da denne betjenes af en anden DNS-server.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Anvend DNS-skabelonændringer',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Ændringerne fra DNS-skabelonen blev korrekt overført til zonen',
    'dns__dns_default_ipv4_modified' => 'Poster med denne IP-adresse betragtes som bruger-modificerede, og de vil ikke blive synkroniserede med den overordnede server-DNS-skabelon.',
    'dns__dns_default_ipv6_modified' => 'Poster med denne IP-adresse betragtes som bruger-modificerede, og de vil ikke blive synkroniserede med den overordnede server-DNS-skabelon.',

    'dns__view_dns_record_master_title' => 'Viser ressourceposter',
    'dns__view_dns_record_off_title' => 'Viser navneserver-poster',
    'dns__view_dns_record_slave_title' => 'Viser primære DNS-server poster',

    'dns_unable_to_resolve_hostname' => "Kan ikke resolvere værten \"%1\": %2\nKontroller at operativsystemets DNS-resolver er korrekt opsat og fungerer korrekt.",

    'no_database_server_available' => 'Der er ingen databaseservere til rådighed for dette abonnement.',

    'database_used_by_application_can_not_be_moved' => 'Kan ikke flytte databasen: En webstedsapplikation bruger denne database.',
    'database_user_update_orphaned_is_restricted' => 'Opdatering af forældreløse databasebrugerkonti er forbudt. Du kan kun slette eller reparere dem.',

    'database_unable_to_get_max_filesize_default_message' => 'Kunne ikke fastlægge den maksimale filstørrelse for databasen: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Kunne ikke indstille den maksimale filstørrelse for databasen: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Kunne ikke fastlægge den maksimale logfilstørrelse for databasen: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Kunne ikke fastlægge den maksimale logfilstørrelse for databasen: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Kunne ikke bestemme den aktuelle grænse for filstørrelsen for Microsoft SQL database \'%1\'. Indstilling af en ny grænse er ikke mulig.',
    'database_unable_to_set_max_filesize' => 'Kunne ikke indstille grænse for filstørrelsen i Microsoft SQL-databasen \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Kunne ikke bestemme den aktuelle grænse for logfil-størrelsen for Microsoft SQL database \'%1\'. Indstilling af en ny grænse er ikke mulig.',
    'database_unable_to_set_max_log_filesize' => 'Kunne ikke indstille grænse for logfilstørrelsen i Microsoft SQL-databasen \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Kan ikke oprette Microsoft SQL-databasen \'%1\': Dens filstørrelse er større end den maksimalt tilladte størrelse.',
    'database_unable_to_move_because_max_filesize' => 'Kunne ikke flytte Microsoft SQL-databasen \'%1\': Dens filstørrelse er større end den maksimalt tilladte størrelse: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Kan ikke oprette Microsoft SQL-databasen \'%1\': Logfilstørrelsen er større end den maksimalt tilladte størrelse.',
    'database_unable_to_move_because_max_log_filesize' => 'Kunne ikke flytte Microsoft SQL-databasen \'%1\': Logfilstørrelsen er større end den maksimalt tilladte størrelse.: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Kunne ikke gendanne Microsoft SQL-databasen \'%1\': Dens filstørrelse er større end den maksimalt tilladte størrelse.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'En identisk MS SQL-server er allerede registreret i Plesk. Angiv en anden MS SQL server som sandkasse.',
    'database_server__mssql_server_registered_as_sandbox' => 'En sandkasse MS SQL-server er allerede registreret i Plesk. Angiv en anden MS SQL server som sandkasse.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Ude af stand til at tilslutte til server via \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Funktionen %1 understøttes ikke af følgende servicenoder: %2. Denne funktion vil være deaktiveret for alle de objekter, der oprettes på disse noder.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Funktionen %1 understøttes ikke af denne server. Denne funktion vil være deaktiveret for alle gendannede objekter.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Komponenten %1 er ikke installeret. Den vil ikke være til rådighed for følgende websteder: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Komponenten %1 er ikke installeret. Den vil blive erstattet med %2 for følgende websteder: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Den nuværende Plesk-version understøtter ikke brugernavne med punktum (.) tegn Kunder og forhandlere med sådanne brugernavne vil ikke blive gendannede.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Kunne ikke finde en sikkerhedskopifil med data for %1 %2. Data for %1 %2 bliver ikke gendannet.',

    'bu_conflict_resolver_zone_master_removed' => "Kunne ikke gendanne den primære DNS-post: posten i den sekundære zone peger på den eksisterende IP-adresse %1. Master DNS-posten vil blive fjernet fra den sekundære zone.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Support for HTTPS DNS records is turned off. HTTPS records will not be restored for the following domains: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 understøttes ikke.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 understøttes ikke. Den vil ikke være til rådighed for følgende websteder: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Komponenten %1 er ikke installeret.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Den vil ikke være til rådighed for følgende servicenoder: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Den vil ikke være til rådighed for følgende objekter: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Følgende databaseservere findes ikke på denne server %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL database sikkerhedskopifilen er lagret i MS SQL native format, som kun kan gendannes til den lokale MS SQL server eller til den eksterne MS SQL server med fuldt konfigurerede sikkerhedskopiindstillinger. Nogle af dine databaser blev ikke gendannet, da der ikke er en passende MS SQL-server registreret i Plesk. Følgende domæner blev påvirket: {{objects}}. Kontakt din hosting-udbyder.',

    'bu_conflict_resolver_not_available_webmail' => 'Web-mail servicen %1 er ikke tilgængelig. Den vil blive erstattet med %2 for følgende objekter: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Web-mail servicen %1 er ikke tilgængelig. Den vil blive erstattet med %2 for følgende serviceplaner: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Databaser af typen '%1' understøtter ikke, at brugernavne falder sammen med databasenavne. Brugeren '%2' vil blive omdøbt til '%3' for databasen '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Begrænsningen for diskpladsanvendelse er ikke indstillet i konfigurationen af destinationsserveren. Værdien af denne indstilling vil blive ændret til "Ubegrænset".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Begrænsningen for antallet af forbindelser var ikke indstillet i konfigurationen af destinationsserveren. Værdien af denne indstilling vil blive ændret til "Ubegrænset".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Begrænsningen for trafikanvendelse er ikke indstillet i konfigurationen af destinationsserveren. Værdien af denne indstilling vil blive ændret til "Ubegrænset".',
    'cu__pleskrestore_backup_file_extracted' => 'Sikkerhedskopifilen blev udpakket til "%1".',
    '__mod_bw_not_supported' => 'Modulet mod_bw til Apache webserver understøttes ikke pga. filsystemets konfiguration. Grænserne for trafikforbrug og det maksimal antal forbindelser vil ikke fungere.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'POP3-godkendelse af e-mail-videresendelse understøttes ikke, POP3 før SMTP-godkendelse bruges i stedet for. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Serviceplan \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 understøttes ikke. Den vil blive erstattet med %2 for følgende serviceplaner: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 understøttes ikke. Den vil blive erstattet med %2 for følgende websteder: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Følgende objekter blev ikke fundet i sikkerhedskopifilen: %1',
    'bu_conflict_resolver_absent_domains' => 'Nogle objekter kan ikke gendannes, da de hører til følgende domæner, der ikke findes i Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Nogle websteder kan ikke gendannes, da de hører til følgende overordnede domæner, der ikke findes i Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Kan ikke gendanne DNS-zoner: DNS-service er deaktiveret i serverkonfigurationen.',
    'bu_conflict_resolver_mail_not_supported' => 'Kan ikke gendanne mailbokse: E-mail service er deaktiveret i serverkonfigurationen.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Den specificerede CPU-grænse handling understøttes ikke af IIS-webserveren.  Værdien vil blive nulstillet til %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'server SSL/TLS-certifikat %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-certifikat %2 til domænet %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-certifikat %1',
    'bu_conflict_resolver_absent_objects' => 'Indholdet af følgende objekter kan ikke gendannes, da objekterne ikke findes i Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Indholdet af følgende mailbokse kan ikke gendannes, da objekterne ikke findes i Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Indholdet af følgende mailinglister kan ikke gendannes, da mailinglisterne ikke findes i Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Indholdet af følgende databaser kan ikke gendannes, da objekterne ikke findes i Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Gendannelsen af applikationen "%1" på "%2" mislykkedes, da en anden applikation allerede er installeret på "%3". Du kan fjerne den installerede applikation og prøve igen.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'E-mail autosvar funktion er ikke understøttet.',
    'bu_conflict_resolver_not_available_mail_content' => 'E-mail indholdsgendannelsesfunktion er ikke understøttet.',
    'bu_conflict_resolver_invalid_mail_name' => 'Følgende mailbokse er ikke blevet gendannede, da email-underadressering er aktiveret og visse email-adresser indeholder tegnet "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Følgende brugere er ikke blevet gendannet, da  email underadressering er aktiveret, og visse email-adresser indeholder tegnet "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Følgende licenser er udløbet og gendannes ikke: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Følgende licenser er udløbet og gendannes ikke: {{objects}}',
    'expiration_unsupported' => "Grænsen 'udløb' er ikke understøttet.",

    'component_name__dbconnector' => "Databaseforbindelse",
    'component_name__mysqlserver' => 'MariaDB/MySQL-server',
    'component_name__troubleshooting' => 'Fejlfinding',
    'component_name__savi' => 'Sophos Antivirus-grænseflade',

    '__subscription_has_no_license_key' => 'Abonnementsressourcerne leveres af servicenoden #%1 der ikke har en tilknyttet licensnøgle.',
    '__subscription_has_expired_license_key' => 'Abonnementsressourcerne leveres af servicenoden #%1 hvis licensnøgle %2 er udløbet.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Kunne ikke gemme konfigurationsfiler',
    '__cfgmonConfigurationFileSaveErrorBody' => "Kunne ikke gemme et antal konfigurationsfiler på hosten <%%host%%>: Følgende fejl opstod: \n \n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Denne indstilling gør det muligt at konfigurere VERP-type email-adresser for emaillister',
    'mail__enter_right_ip_mask' => "Indtast en IP-maske mellem 1 og 32",
    'mail__enter_right_ip_mask_24' => "Indtast en IP-maske mellem 24 og 32",
    'mail__invalid_dom_name' => "Domænenavnet %1 er ugyldigt.",
    'mail__invalid_pop_lock_time' => "POP3-låsetid er ugyldig.",
    'mail__invalid_rbl_server' => "DNS-zonenavnet er ugyldigt.",
    'mail__total_files_size' => "Samlet opbevaringssted-størrelse: %1",
    'mail__filename_already_in_repository' => "En fil med samme navn findes allerede i opbevaringsområdet.",
    'mail__no_white_list_mask_feature_24' => "Brug en maskeværdi på 24 eller højere.\nDin e-mail server understøtter ikke indstilling af masker. Vi kan kun emulere indstilling af maske for værdier under 24.",
    'mail__unable_add_new_mail_name' => "Kunne ikke tilføje e-mail kontoen: %1",
    'mail_server_is_not_installed' => 'Mailserver (Postfix eller Qmail) er ikke installeret. Installer den for at fortsætte arbejdet.',
    'mail_server_not_available' => 'Der er ingen understøttede e-mailserverer til rådighed på servicenoden.',
    '__not_installed' => '(ikke installeret)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Spamfiltrering af udgående e-mails er deaktiveret.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Servicenoden understøtter ikke begrænsning af antallet af udgående e-mails fra et domæne for domænet %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Servicenoden understøtter ikke begrænsning af antallet af udgående e-mails fra en mailboks for domænet %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Angiv mindst en adresse af typen IPv4 eller IPv6.',

    'mail__outgoing_email_mode_invalid' => 'En ugyldig udgående e-mail tilstand blev angivet.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'En ugyldig IPv4-adresse blev angivet.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'En ugyldig IPv6-adresse blev angivet.',
    'mail__outgoing_email_mode_unavailable' => 'Ændring af udgående post-tilstand understøttes ikke, sandsynligvis fordi Postfix mailserveren ikke er installeret på denne server.',

    'mail__autoresponder_attachment_not_supported' => 'Den aktuelt valgte mailserver understøtter ikke administration af auto-responder bilag.',

    'mail__smtp_white_list_not_supported' => 'Den aktuelt anvendte mailserver understøtter ikke hvidlistning af IP-adresser.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR-masker understøttes ikke af den aktuelt valgte mailserver. Angiv IP-adresse i formatet \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'IP-mønstre med wildcard understøttes ikke af den aktuelt valgte mailserver. Angiv IP-adresse i formatet \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Kunne ikke ændre indstillingerne for DKIM verifikationsservice',

    'sfdk_domain__serverwide_disabled' => 'Deaktiveret i henhold til serverpolitikken',
    'feature__domainkeys__serverwide_disabled' => 'Server-bred DKIM spambeskyttelse er deaktiveret',

    'defaultcomponents__error_set_default' => 'Kunne ikke indstille %1 som standard-%2: %3',
    'defaultcomponents__error_set_default_none' => 'Kunne ikke indstille nogen standardkomponent for %1: %2',
    'defaultcomponents__required_package_not_default' => 'Komponenten %1 er påkrævet for dens arbejde er ikke standard.',

    '__percentage' => '%',
    '__seconds' => 'Sekunder',
    '__resource_remain' => 'Resterende',

    '__not_registered' => '(ikke registreret)',
    '__php_handler_id' => 'PHP-version',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP handleren "%1" er ikke registreret. Den er sandsynligvis slettet fra serveren. Registrér en handler med de samme egenskaber og prøv igen.',
    '__php_handler_not_registered_on_domain' => 'Domænet "%1": PHP-handleren "%2" er ikke registreret. Den er sandsynligvis slettet fra serveren. Registrér en handler med de samme egenskaber og prøv igen.',
    '__php_fpm_handler' => 'FPM-applikation',
    '__php_fpm-dedicated_handler' => 'Dedikeret FPM-applikation',

    'mailname_create_assigned_user_dublicate_error' => 'Der kan ikke oprettes en bruger af denne postkasse. Den bruger, hvis brugernavn er %1 findes allerede, og vedkommende har en anden postkasse.',
    'mailname_create_assigned_user_role_absent_error' => 'Der kan ikke oprettes en bruger af denne postkasse. Standardrollen %1 for brugeren findes ikke.',

    'gphd__mime_types' => 'MIME typer',
    'gphd__handlers' => 'Apache-handlere',
    'gphd__ip_restrictions_allow' => 'Tillad adgang til webstedet for specifikke hosts og netværk (bortset fra de udelukkede)',
    'gphd__ip_restrictions_deny' => 'Nægt adgang til webstedet for specifikke hosts og netværk',
    'gphd__directory_index' => 'Indeksfiler',
    'gphd__nginx_transparent_mode' => 'Tilstanden hvor Apache håndterer både statisk og dynamisk indhold, mens nginx kun videregiver HTTP-forespørgsler og svar uden modifikation.',
    'gphd__nginx_serve_static' => 'Levér statiske filer direkte vha. nginx',
    'gphd__nginx_static_extensions' => 'Statiske filers filnavnsudvidelser, der skal behandles af nginx',
    'gphd__nginx_serve_php' => 'Behandl PHP-filer vha. nginx',
    'gphd__www_root' => 'WWW-rodbibliotek',

    'eol__none' => 'må ikke ændres',
    'eol__lf' => 'konvertér til Unix-type',
    'eol__cr' => 'konvertér til MacOS-type',
    'eol__crlf' => 'konvertér til Windows-type',

    'ui__dns_bad_zone' => 'Inkonsistent zone "%1":',
    'ui__dns_ns_has_no_address_records' => 'NS-posten "%1" indeholder ikke adresseposter (A eller AAAA).',
    '__dns_bad_zone' => 'Inkonsistent zone "%1":',
    '__dns_ns_has_no_address_records' => 'NS-posten "%1" indeholder ikke adresseposter (A eller AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR-posten "%1" er ugyldig: Posten peger på et jokertegn-domæne.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Tillad ekstern adgang for databasebrugeren \'%3\' fra kunden \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Kunne ikke tillade eksterne forbindelser for databasebrugeren \'%1\': Kunne ikke bestemme TCP-portnummeret der anvendes af Microsoft SQL server \'%2\'.  Mulige årsager er følgende: TCP/IP-protokollen er ikke aktiveret i servernetværkskonfigurationen eller serveren er konfigureret til at bruge dynamiske TCP-porte.  Konfigurér serveren til at lytte på en specifik fast TCP-port og forsøg at tillade eksterne forbindelser igen.',

    'command__convertResellerHasCustomer' => 'Denne forhandlerkonto \'%1\' indeholder en eller flere kundekonti. For at konvertere denne forhandlerkonto til en kundekonto, skal du først overføre disse kundekonti til en ny ejer, eller konvertere dem til forhandlerkonti.',
    'command__convertResellerNotReseller' => 'Kun forhandlerkonti kan konverteres til kundekonti. \'%1\' er ikke en forhandler.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Kunne ikke synkronisere abonnementet med serviceplanen. Følgende abonnementsindstillinger er i konflikt med serviceplanen: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Kontoen \'%1\' er en forhandlerkonto.  Forhandlerkonti kan ikke flyttes til en ny ejer, da de ejes af server-administratoren.',
    'moveCustomer__wrong_owner_type' => "Kundekontoen '%1' kan kun flyttes til en forhandler eller en administrator, ikke til en anden kunde.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Kundekontoen \'%1\' hører allerede til den valgte ejer.',
    'upgradeClient__user_is_admin' => 'Kontoen \'%1\' kan ikke konverteres til en forhandlerkonto, da det er en administratorkonto.',

    'mail__error_setting_max_connections_courier' => 'Kunne ikke indstille det maksimale antal forbindelser (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Kunne ikke indstille det maksimale antal forbindelser (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Kunne ikke indstille det maksimale antal forbindelser (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS) pr. IP-adresse: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Kunne ikke indstille det maksimale antal forbindelser (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) pr. IP adresse for en specifik e-mail bruger: %1',
    'outgoing_messages_limit_value_invalid' => 'Værdien skal ligge i intervallet %%MIN%%..%%MAX%%.  Kun Plesk-administratoren kan justere denne indstilling.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Følgende domæner anvender eksterne e-mail adresser til e-mail videresendelse af e-mails der er sendt til ikke-eksisterende adresser. Meddelelserne der sendes til disse adresser optælles ikke u Udgående e-mails kontrollen:\n%1",
    'outgoing_messages_white_list_not_empty' => 'Begrænsningerne for udgående e-mails vil ikke fungere for e-mail afsendere hvis IP-adresserne findes på e-mail serverens hvidliste. Hvis f.eks. der er en localhost (127.0.0.0 / 8, ::1 / 128) på hvidlisten, vil alle e-mails fra den lokale server blive sendt, uanset begrænsningerne. E-mail afsendere kan enten bruge lokale IP-adresser (websteder og brugerdefinerede scripts der ligger på den lokale server) eller eksterne (kunder der sender e-mail fra e-mail klienter der er installeret på deres computere eller mobile enheder). Du kan få begrænsningerne til at fungere for alle e-mail afsendere (både lokale og eksterne) ved at fjerne alle IP-adresser og netværk fra hvidlisten. Bemærk, at fjernelse af localhost (127.0.0.0 / 8, ::1 / 128) fra hvidlisten kan forstyrre funktionen af websteder og scripts som sender e-mails fra denne server. Der findes oplysninger om begrænsninger for udgående e-mails i Administrator\'s Guide, Protection from Outbound Spam.',
    'outgoing_messages_relay_open' => 'E-mail relæet er åbent: Grænserne for udgående e-mails vil ikke fungere.',

    'notification_aps_app_updates_available' => 'Opdateringer er til rådighed for følgende programmer:',
    'notification_aps_app_updates_installed' => 'Opdateringer af følgende programmer blev automatisk installeret:',
    'notification_aps_app_updates_requirements' => 'Opdateringer er til rådighed for følgende programmer, men kan ikke installeres, da hosting-indstillingerne for de korresponderende websteder ikke opfylder installationskravene:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%).  Installeret version: %%from%%.  Version til rådighed: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Installeret version: %%from%%. Version til rådighed: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Installeret version: %%from%%. Version til rådighed: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Installeret version: %%from%%.  Version til rådighed: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Installeret version: %%from%%. Version til rådighed: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Installeret version: %%from%%. Version til rådighed: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%).  Din version: %%from%%. Version til rådighed: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Din version: %%from%%. Version til rådighed: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Din version: %%from%%. Version til rådighed: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%).  Ny version: %%to%%.  Foregående version: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny version: %%to%%. Foregående version: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny version: %%to%%. Foregående version: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installeret version: %%from%%. Version til rådighed: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installeret version: %%from%%. Version til rådighed: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Din version: %%from%%. Version til rådighed: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'eksternt program',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domæner',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-mail-adresser',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonnementer',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 meddelelser pr. time',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Ubegrænset',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, grænsen er %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 forsøg på at overskride begrænsningerne fra %2 til %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 forsøg på at overskride grænserne fra %2 indtil nu',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP-adresse bandlysning (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Fail2ban-komponenten er ikke installeret på destinationsserveren.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installér Fail2ban.  Bemærk, at dette kan vare nogle få minutter.',

    'plesk_key__no_reseller_support' => 'Du kan ikke administrere forhandlere pga. licensrestriktioner.',
    'plesk_key__no_customers_support' => 'Du kan ikke administrere kunder pga. licensrestriktioner.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Kan ikke skifte til Serviceudbyder-visning pga. licensbegrænsninger.',
    'plesk_key__no_security_core_support' => 'Sikkerheds-kernefunktionerne (ModSecurity og Fail2Ban) er ikke til rådighed pga. licensrestriktioner.',
    'plesk_key__outgoing-antispam' => 'Udgående mail-kontrol',
    'plesk_key__security-core' => 'Sikkerhedskerne (ModSecurity og Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Kontoadministration',
    'plesk_key__can-manage-subscriptions' => 'Abonnementsadministration',
    'plesk_key__can-manage-customers' => 'Kundeadministration',
    'plesk_key__can-manage-resellers' => 'Forhandleradministration',
    'plesk_key__can-manage-custom-view' => 'Begrænset tilstand-rådighed',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Abonnementsadministration er deaktiveret, men du har adskillige abonnementer (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Forhandleradministration er deaktiveret, men du har adskillige forhandlere (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Kundeadministration er deaktiveret, men du har adskillige kunder (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Visse abonnementsressourcer, som du ikke længere kan administrere i Plesk-grænsefladen (f. eks. begrænsninger på mailbokse og domæners diskplads), er nu indstillet til ubegrænset.',
    'plesk_key__no_subscriptions_support' => 'Du kan ikke administrere abonnementer pga. licensrestriktioner.',
    'plesk_key__no_custom_view_support' => 'Du kan ikke anvende Begrænset tilstand pga. licensrestriktioner.',
    'plesk_key__trial_forbidden_region' => 'Beklager, Plesk er i øjeblikkeligt ikke til rådighed i din region.',
    'additional_key__main_key' => 'Denne nøgle er en hovenøgle. Du kan ikke uploade en hovednøgle som en ekstra nøgle.',

    'gch__hosting_waf_rule_engine' => 'Webprogram firewall-tilstand',

    'backup__fieldset__restoration_options' => 'Gendannelsesindstillinger',
    'backup__restore_options__restore' => 'Gendan',
    'backup__restore_options__domain__domain_configuration' => 'Domænekonfiguration',
    'backup__restore_options__domain__virtual_host_content' => 'Indhold af virtuel host',
    'backup__restore_options__domain__mail' => 'E-mail',
    'backup__restore_options__domain__databases' => 'Databaser',
    'backup__restore_options__client__client_configuration' => 'Kundekonto-konfiguration',
    'backup__restore_options__client__domains' => "Kundens domæner",
    'backup__restore_options__reseller__reseller_configuration' => 'Forhandlerkonto-konfiguration',
    'backup__restore_options__reseller__personal_domains' => "Forhandlers domæner",
    'backup__restore_options__reseller__clients' => "Forhandlers kunder",
    'backup__restore_options__admin__server_configuration' => 'Serverindstillinger',
    'backup__restore_options__admin__administrator_configuration' => 'Administrator kontokonfiguration',
    'backup__restore_options__admin__personal_domains' => "Administrators domæner",
    'backup__restore_options__admin__personal_clients' => "Administrators kunder",
    'backup__restore_options__admin__resellers' => 'Forhandlere',

    'badge_new' => 'Ny',
    'upgrade_php_on_subscription' => 'Opgradér PHP på dit abonnement til version 5.3.0 eller senere.',

    'pkey_notify__body_expiration_notification' => 'Licensnøglen er udløbet. Visse funktioner kan være utilgængelige. Kontakt din hosting-udbyder.',

    'crontab__crontab_entry_exists' => "Den planlagte opgave findes allerede.",
    'crontab__crontab_entry_not_exists' => "Den planlagte opgave findes ikke.",
    'crontab__invalid_values_found' => "Forkerte parameterværdier.",
    'crontab__cmd_max_len' => "Kommandoen kan højst være på %1 tegn.",

    'domain__domain_exists' => "Der er et domæne med 'www' præfiks og samme navn: %1.%2.",
    'domain__subdomain_exists' => "Der er et underdomæne med 'www' præfiks og samme navn: %1.%2.",
    'domain__dalias_exists' => "Der er et domænealias med 'www' præfiks og samme navn: %1.%2.",
    'domain__record_exists' => "Der er en DNS-post der peger på hosten %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certifikatet '%1' kan ikke indstilles som standard. Der mangler en privat nøgle.",
    'ip_addr__update_dns_error' => 'Der opstod problemer under opdatering af IP-adressen i DNS-zoner. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Kan ikke tilføje IP-adressen. Denne netværksgrænseflade henter automatisk IP-adresser.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Kan ikke fjerne IP-adressen %1. Denne netværksgrænseflade henter automatisk IP-adresser.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Kan ikke reparere IP-adressen %1. Denne netværksgrænseflade henter automatisk IP-adresser.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Kan ikke ændre grænsefladen for IP-adressen %1, da netværksgrænsefladen automatisk %2 henter IP-adresser.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Abonnementets grænse for antallet af %%type%% er overskredet. Grænsen er på %%limit%%, og der anvendes i øjeblikket %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Oprettelsen af %%type%% er ikke tilladt for dette abonnement.',
    'shm_lmsg__resource_title__db-mysql' => 'MariaDB/MySQL-databaser',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL-databaser',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL-databaser',
    'shm_lmsg__resource_title__db-user' => 'Databasebrugere',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS-programgrupper',
    'shm_lmsg__resource_title__additional-ftp-account' => 'Ekstra FTP-konti',

    'db_user_unable_remove_mysql_global_privileges' => 'Kan ikke fjerne MariaDB/MySQL globale tilladelser for databasebrugeren%1. Årsag: %2',
    'report__client_description' => 'Beskrivelse',

    'db__user_role_error' => 'Forkert databasebrugers rolle blev angivet: %1. Vælg en af følgende roller: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Kan ikke indstille grænsen for følgende Microsoft SQL-databasers størrelse da de har en større filstørrelse: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Kan ikke indstille grænsen for følgende Microsoft SQL-databasers logstørrelse da de har en større logfilstørrelse: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Kan ikke opsætte en offentlig IP-adresse: der skal findes en privat IP-adresse.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Kan ikke opsætte en offentlig IPv4-adresse til IPv6-adressen.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Kan ikke opsætte en offentlig IPv6-adresse til IPv4-adressen.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Kan ikke opsætte en offentlig IP-adresse: ugyldig IP-adresse.',

    '__user_already_exists' => "Brugeren %1 findes i forvejen.",
    '__user_name_is_empty' => "Angiv venligst en brugernavn.",

    'upgrade_php_on_domain' => 'Kan ikke finde PHP-version 5.3.0 eller senere på nogen af dine WordPress-domæner. Prøv at opgradere PHP.',

    'component_name__waf' => 'Webprogram firewall',
    'component_name__vcs' => 'Versionskontrol system',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Et muligt spoofing-forsøg blev detekteret. Linket forsøger at vise irrelevant indhold.',
    'forceResetPasswordUpdated' => 'Din adgangskode er blevet ændret. Brug den nye adgangskode til at logge ind på Plesk.',

    'php_handlers_error_no_available_instance' => 'Kan ikke oprette et domæne: Der er ingen ledige PHP-handlere.',
    'domain_error_unable_to_apply_hosting_settings' => 'Kunne ikke overføre hosting-indstillingerne: %1',

    'plesk_not_configured' => 'Plesk er ikke konfigureret. Gå til Kontrolpanel og udfør efter-installations konfiguration.',
    'cmd_mail__mail_password_duplicated' => 'Det angivne par med email-adresse og adgangskode findes allerede på mailserveren. Angiv en anden email-adresse eller en anden adgangskode.',

    'extensionRequirementOs' => 'Operativsystemet (%1) understøttes ikke af pakken.',
    'extensionRequirementPleskMinVersion' => 'Operativsystemet (%1) er den tidligste version der understøttes af pakken.',
    'extensionRequirementPleskMaxVersion' => 'Versioner startende fra Plesk %1 understøttes ikke af pakken.',
    'extensionBlacklisted' => 'Udvidelsen %1 må ikke installeres.',
    'extensionDisabled' => 'Udvidelsen er deaktiveret.',


    'optimization_settings__unable_set_mpm_event' => 'Kunne ikke indstille mpm_event tilstand: Det kræver at Apache PHP5-modulet er deaktiveret, men dette modul bruges af domæner.',
    'optimization_settings__unable_turn_off_php' => 'Kunne ikke deaktivere Apache PHP5-modulet: Det bruges af domæner.',

    'hst_def__fp_admin_login' =>  'FTP-brugernavn',
    'hst_def__fp_admin_passwd' =>  'FTP-adgangskode',

    'database_user_orphaned_old_password_wrong' => "Kunne ikke reparere forældreløs bruger '%1': adgangskoden er forkert.",
    'cannot_load_partner_central_property_key_no_exist' => "Kan ikke hente brugerdefinerede egenskaber: Licensnøgle findes ikke.",
    'extensionScriptFailure' => "Udførelsen af %1 mislykkedes med følgende besked:\n%3",
    '__ssl_redirect' => "Permanent SEO-sikker301 omdirigering fra HTTP til HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM-administration understøttes ikke.',
    'mail__dmarc_not_supported' => 'DMARC-administration understøttes ikke.',
    'mail__relay_white_list_not_supported' => 'Administration af videresendelseshvidliste understøttes ikke.',
    'mail__black_list_not_supported' => 'Sortlisteadministration understøttes ikke.',
    'mail__autoresponder_not_supported' => 'Auto-responder-administration understøttes ikke.',
    'defaultcomponents__not_supported_version' => '(ikke-understøttet version)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Certifikatet \'%1\' blev ikke fundet.',
    'certificate__unable_setup_certificate' => 'Kunne ikke installere certifikatet: Den private nøgle og certifikatindholdet mangler.',
    'certificate__used_by_panel' => 'Et af de certifikater, du er ved at slette, bruges til sikring af Plesk.',
    'certificate__used_by_mail_server' => 'Et af de certifikater, du er ved at slette, bruges til sikring af mailserveren.',
    'certificate__used_by_domain_service' => 'Et af de certifikater, du er ved at slette, bruges af domæneservice',
    'mail_server__not_installed' => 'Kan ikke installere certifikatet til mailserveren, fordi mailserveren ikke er installeret.',

    'email_activation_mail_subject' => 'Aktiver venligst din konto i Plesk',
    'email_activation_mail_body' => "Der blev oprettet en konto på Plesk-serveren %1 \n\nKontooplysninger: \nNavn: %2 \nE-mail adresse: %3 \n\nHvis denne information er korrekt og kontoen blev oprettet for dig, bedes du aktivere den vha. følgende link: \n\n%4 \n\nVed at aktivere kontoen godkender du, at server-ejeren må indsamle, lagre, behandle og bruge dine and personlige data (navn og e-mail adresse) til oprettelse og support af din konto, i overensstemmelse med gældende databeskyttelseslovgivning, som del af en kontrakt.",

    'backup_transport_permission_name' => '%1 administration',
    'backup_transport_permission_description' => 'Tillader at anvende %1 til lagring af sikkerhedskopier.',

    'domain_move_err_target_no_hosting' => 'Kan ikke flytte domænet til et abonnement uden hosting.',
    'domain_move_err_already_in_target' => 'Domænet tilhører allerede mål-abonnementet.',
    'domain_move_err_main_domain' => 'Hoveddomænet kan ikke flyttes.',
    'domain_move_err_subdomain_without_parent' => 'Kan ikke flytte underdomænet %1 uden dette overordnede domæne %2.',
    'domain_move_err_root_exists' => 'Målstien til www_root %1 findes allerede.',
    'domain_move_err_nested_roots' => 'Kan ikke flytte domænet, da det deler dokumentroden med et andet domæne: %1.',
    'domain_move_err_no_mail_service' => 'Kan ikke flytte domænet, da mailservicen er deaktiveret på målabonnementet.',
    'domain_move_err_app' => "Applikationen installeret på %1 blev ikke flyttet til abonnementet '%2': %3",
    'domain_move_database_used_by_app' => "Databasen '%1' på %2 bruges af den flyttede applikation. Du kan gentilknytte databasen til '%3' ved at køre `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Målabonnementet '%1' blev låst for synkronisering.",
    'domain_move_filesharing_disabled' => 'Fildeling blev deaktiveret.',
    'domain_move_website_preview_disabled' => 'Websteds-preview var deaktiveret.',
    'domain_move_additional_webserver_settings' => "Gennemgå domænets yderligere webserver-direktiver for at forhindre en brudt konfiguration.",
    'domain_move_no_permission' => "%1 er ikke tilladt for abonnementet '%2'.",
    'domain_move_no_access' => "Ingen adgang til abonnementet '%1'.",
    'domain_split_no_create_permission' => "Domæneoprettelser er ikke tilladt.",
    'domain_split_empty_login' => 'Systembruger-login kræves.',
    'domain_split_empty_password' => 'Systembruger-adgangskode kræves.',
    'domain_split_err_home_exists' => 'Domænet %1 kan ikke flyttes, da dets mål-hjemmesti allerede findes på %2. Omdøb domæne der skal flyttes til et nyt abonnement',
    'domain_split_err_no_hosting_subdomains' => 'Domænet kan ikke flyttes til et nyt abonnement, da domænet ikke har hosting, men indeholder underdomæner. Hvis du vil flytte domænet skal du ændre dets "Hosting type" værdi til "Webstedshosting" (i Hostingindstillinger).',
    'domain_split_target_locked' => "Målabonnementet '%1' er låst for synkronisering.",
    'domain_split_target_unsynced' => "Målabonnementet '%1' blev ikke synkroniseret med planen på grund af: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Planlagt backup blev deaktiveret på '%1'.",
    'domain_merge_database_error' => "Databasen '%1' på %2 blev ikke flyttet til abonnementet '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Anonym FTP på '%1' blev slukket.",
    'domain_merge_smb_user_access' => "Den ekstra bruger '%1' blev flyttet til abonnement '%2' men brugerens adgang til abonnementet blev tilbagekaldt.",
    'domain_merge_scheduled_tasks' => "Planlagte opgaver blev flyttet til målabonnement. Gennemgå opgavekonfiguration.",
    'domain_merge_scheduled_tasks_deactivated' => "Planlagte opgaver blev flyttet til målabonnement og deaktiveret. Gennemgå opgavekonfiguration.",
    'domain_merge_no_remove_permission' => "Fjernelse af abonnementer er ikke tilladt.",
    'domain_merge_err_has_addons' => 'Kan ikke flytte hoveddomæne med ekstradomæner; flyt domæne(r) %1 først.',
    'domain_merge_err_has_webusers' => 'Kan ikke flytte hoveddomænet med dets webbrugere..',
    'domain_merge_err_root_exists' => 'Målstien %1 findes allerede.',

    'database_server_edit_used_for_psa' => 'Opdatering af lokal MariaDB/MySQL database´server er ikke tilladt.',
    'suggest_repair_main_suggestion_ui' => '<b>Du kan rette denne fejl</b> ved hjælp af værktøjet `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Du kan rette denne fejl ved art bruge værktøjet `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'skift til  Diagnose & Reparation',
    'suggest_repair_using_cli_and_ui' => 'Det gør du ved enten at køre kommandoen `plesk repair %1` via CLI eller %2 og klik på Reparer ud for “Plesk Database”',
    'suggest_repair_using_cli' => 'Det gør du ved at køre kommandoen `plesk repair %1` via CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'DNS-service var utilgængelig, da backup\'en blev oprettet.  Der er imidlertid aktive DNS-zoner i backup\'en, og de aktiveres for følgende objekter: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Ressource-controller (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Understøttelse af ekstern SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(ikke tilladt af licensnøgle)',
    'plesk_key__validation_failed' => '%1 (fejlkode: %2)',
    'promo__button_details' => 'Detaljer',
    'promo__extension_catalog_title' => 'Udvidelseskatalog',
    'promo__extension_catalog_description' => 'Tag et  kig i det nye udvidelseskatalog og supercharge din Plesk vha. et udvalg af stærke udvidelser!',
    'promo__button_open_catalog' => 'Åbn kataloget',

    'backup__repository_check_login' => "Har ikke adgang til lagringsenheden: %1 Sørg for, at du jar angivet de korrekte lagringsakkreditiver.",
    'backup__repository_check_error_list' => "Har ikke adgang til lagringsenheden: %1 Sørg for, at du har angivet de korrekte lagringsindstillinger.",
    'backup__repository_check_error_mkdir' => "Kan ikke oprette biblioteket: %1 Kontroller om du har tilladelse til at oprette mapper på lagringsenheden.",
    'backup__repository_check_error_upload' => "Kan ikke uploade filen til lagringsenheden: %1 Kontroller om du har tilladelse til at uploade filer til lagringsenheden.",
    'backup__repository_check_error_download' => "Kan ikke downloade filen fra lagringsenheden: %1 Kontroller om du har tilladelse til at uploade og downloade filer fra lagringsenheden.",
    'backup__repository_check_error_resume-upload' => "Kan ikke genoptage upload af filen til lagringsenheden: %1 Kontroller om du har tilladelse til at genoptage uploads til lagringsenheden.",
    'backup__repository_check_error_resume-download' => "Kan ikke genoptage download af filen fra lagringsenheden: %1 Kontroller om du har tilladelse til at genoptage downloads fra lagringsenheden.",
    'backup__repository_check_error_enable-utf8' => "Kan ikke betjene lagringsenheden: %1 Kontroller om lagringsenheden understøtter UTF8-kodning.",
    'backup__repository_check_error_rm' => "Kan ikke betjene lagringsenheden: %1 Kontroller om du har tilladelse til at slette filer fra lagringsenheden.",
    'backup__repository_check_error_rmdir' => "Kan ikke betjene lagringsenheden: %1 Kontroller om du har tilladelse til at slette mapper fra lagringsenheden.",

    'backup__ftp_repository_check_login' => "%1 Du kan tjekke dem individuelt med kommandoen: %2",
    'backup__ftp_repository_check_error_list' => "%1 Du kan tjekke dem individuelt med kommandoen: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Du kan tjekke det individuelt med kommandoen: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Du kan tjekke dette individuelt med kommandoerne: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Du kan tjekke dette individuelt med kommandoerne: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Du kan tjekke dette individuelt med kommandoerne: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Du kan tjekke dette individuelt med kommandoerne: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Du kan tjekke det individuelt med kommandoen: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Du kan tjekke dette individuelt med kommandoerne: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Du kan tjekke dette individuelt med kommandoerne: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Kan ikke ændre indstillingerne for DMARC. Hvis du vil aktivere denne indstilling, skal du aktivere DKIM og SPF spambeskyttelse.',
    'spf_server_wide_disable_failed' => 'Kan ikke ændre indstillinger  for SPF spambeskyttelse. Hvis du vil deaktivere SPF, skal du deaktivere DMARC for indkommende emails.',
    'sfdk_server_wide_verify_disable_failed' => 'Kan ikke ændre indstillingerne for DKIM-spambeskyttelse. Hvis du vil deaktivere DKIM, skal du deaktivere DMARC for indkommende emails.',

    'ccs_not_supported' => 'IIS Central Certificate Store er ikke konfigureret på systemet.',
    'ccs_not_enabled' => 'IIS Central Certificate Store-administration er ikke aktiveret i Plesk.',
    'ad_not_supported' => 'Serveren er ikke kædet til et domæne.',

    'component_name__appinit' => "Applikationsinitialisering",
    'component_name__cors' => "Deling af ressourcer på tværs af oprindelse",
    'component_name__httpcompression' => 'HTTP indholdskompression',
    'common_feature_is_not_supported' => 'Denne funktion understøttes ikke længere.',
    'common_feature_is_not_supported_in_proto' => 'Denne funktion understøttes ikke for protokolversion %1.',
    'autoinstaller__plesk_component' => 'Plesk-komponent',
    'plesk_key__key_expired' => 'Din licensnøgle er udløbet. For at fortsætte med at bruge Plesk, skal du købe en ikke-udløbende kommerciel %1.',
    'plesk_key__key_purchase' => 'licensnøgle',

    'sa_action_move' => 'Flyt spam til mappen Spam',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-applikationer understøttes ikke længere. De vil være utilgængelige for følgende websteder: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobile versioner af websteder, der hostes med UNITY Mobile understøttes ikke længere. De vil være utilgængelige for følgende websteder: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Server-bred anvendelsespolitik tillader ikke personlige antivirusindstillinger. De gendannes ukomplette for email-konti på følgende domæner: {{objects}}',

    'module__not_installed' => "Udvidelsen %1 er ikke installeret",

    'mail__mail_autodiscovery_server_error' => 'Angiv et brugerdefineret domænenavn til email autoopdagelse',
    'mail__error_mail_autodiscovery_enable' => 'Kan ikke indstille email-autoopdagelse: %1',
    'mail__error_mail_autodiscovery_server' => 'Kan ikke indstille et brugerdefineret domænenavn for email-autoopdagelse: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Kan ikke omkonfigurere domæne-autoopdagelses DNS-poster: %1',

    '__invalid_url' => 'URL "%1" er ugyldig',
    'actionlog__cloning_start' => 'start',
    'actionlog__event_cloning_start' => 'Serverkloningsstart',

    '__UPLOAD_ERR_FORM_SIZE' => "Uploadet fil overskrider den tilladte størrelse",
    '__UPLOAD_ERR_INI_SIZE' => "Uploadet fil overskrider den tilladte størrelse",
    '__UPLOAD_ERR_NO_FILE' => "Ingen filer modtaget:",
    '__UPLOAD_ERR_OK' => "Filen blev uploadet korrekt.",
    '__UPLOAD_ERR_PARTIAL' => "Filen blev kun delvist uploadet, prøv venligst igen",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Midlertidig mappe mangler',
    '__UPLOAD_ERR_CANT_WRITE' => 'Kunne ikke skrive til disk',
    '__UPLOAD_ERR_UNKNOWN' => 'Der opstod en ukendt upload fejl.',
    '__accounts' => "Konti",
    '__access' => "Adgang",
    '__address' => "Adresse",
    '__addresses' => "Adresser",
    '__acl_records' => 'ACL-poster',
    '__admin_repository' => "Administrators opbevaringsområde",
    '__all' => 'Alle',
    '__allowed' => "Tilladt",
    '__anonftp_status' => "Anonym FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 webserver genstartes, vent venligst...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET-understøttelse",
    '__asp_win_support' => "Microsoft ASP-understøttelse",
    '__attachments' => "Vedhæftninger",
    '__attachments_list' => "Vedhæftninger",
    '__author' => 'Forfatter',
    '__autoresp_name_already_exists' => "Der findes allerede et autosvar med navnet %1.",
    '__autoresponder' => "Autosvar",
    '__autoresponders' => "Autosvar",
    '__autoresponders_list' => "Autosvar",
    '__autoresponder_attachment_files' => "Autosvar bilagsfiler",
    '__auto_updates_list' => 'Tilgængelige opdateringer',
    '__avail' => "Tilgængeligt",
    '__backup_utilites' => "Værktøjer til sikkerhedskopiering",
    '__bind_status' => "DNS-serverstatus",
    '__bu_is_not_installed' => "Denne service er ikke til rådighed i øjeblikket, da sikkerhedskopieringsværktøjer er ikke installeret.",
    '__bu_not_support_in_key' => "Sikkerhedskopieringsfunktionerne understøttes ikke af licensnøglen.",
    '__notifications_not_support_in_key' => 'Adviseringer understøttes ikke af licensnøglen.',
    'disabled_by_key' => 'Ikke understøttet af licensnøglen.',
    '__bytes' => "bytes",
    '__can_not_use_reserved_words' => "Du kan ikke bruge de reserverede ord.",
    '__certificate' => "Certifikat",
    '__cgi_support' => "CGI-understøttelse",
    '__change_date' => "Ændringsdato",
    '__city' => "By",
    '__cl_not_exist' => "Kundekonto findes ikke.",
    '__client' => 'Kunder',
    '__client_card' => "Kundekort",
    '__client_contact_name' => "Kunde-kontaktnavn",
    '__client_form' => "Personlig information",
    '__client_ip_pool' => "Kundens IP-pulje",
    '__client_limits' => "Kundekontogrænser",
    '__client_permissions' => "Kundens tilladelser",
    '__client_preferences' => "Kundens præferencer",
    '__client_status' => "Kundens status",
    '__client_name' => "Kundens navn",
    '__client_total' => "Kundetotal",
    '__client_with_login_name_already_exists' => "Der findes allerede en bruger med brugernavnet \"%1\"",
    '__client_domuser_with_login_already_exists' => "Brugernavnet: '%1' anvendes allerede ad administratoren på domænet '%1'.",
    '__clients_global_changes' => "Redigér udvalgte kundekonti.",
    '__clients_list' => "Kunder",
    '__cmd_not_found' => "Ukendt kommando: %1",
    '__comments' => "Kommentarer",
    '__company_name' => "Firmanavn",
    '__component_version' => "Komponentversion",
    '__component_not_installed' => "Komponenten %1 blev ikke installeret.",
    '__confirm_del' => "Du skal bekræfte sletning.",
    '__confirm_overwrite' => "Bekræft overskrivning",
    '__confirm_stop' => "Du skal bekræfte proces-standsning.",
    '__confirm_passwd' => "Bekræft %1 adgangskode",
    '__confirm_removal' => "Bekræft fjernelse",
    '__conhelp' => "Beskrivelse",
    '__contact_name' => "Kontakt navn",
    '__country' => "Land",
    '__countries' => 'Land',
    '__country_unknown' => 'Kunne ikke genkende lande-underkoden.',
    '__courier-imap' => 'Courier-server',
    '__create_domain' => 'Opret et domæne',
    '__crypted' => 'krypteret',
    '__cp_access' => "Adgang til Plesk",
    '__cp_user' => "Plesk-bruger",
    '__create' => "Opret",
    '__create_client_template_without_template' => "Opret brugerkonto uden skabelon",
    '__create_domain_for' => "Opret et domæne til <b>%1</b>",
    '__create_domain_template_without_template' => "Opret domæne uden skabelon",
    '__creation_date' => "Oprettelsesdato",
    '__crontab_unix' => "Planlægger",
    '__crontab_win' => "Planlægger",
    '__ct_month_jan' => 'Januar',
    '__ct_month_feb' => 'Februar',
    '__ct_month_mar' => 'Marts',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Maj',
    '__ct_month_jun' => 'Juni',
    '__ct_month_jul' => 'Juli',
    '__ct_month_aug' => 'August',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'December',
    '__custom_button' => "Brugerdefineret knap",
    '__custom_buttons_list' => "Links til yderligere services",
    '__daily' => "Dagligt",
    '__database_not_activated' => "%1 var ikke aktiveret på server-administrationssiden.",
    '__database_not_installed' => "Databasen %1 er ikke installeret.",
    '__database_not_run' => "Databasen %1 kører ikke",
    '__database_is_corrupt' => "Plesks database er beskadiget. Start værktøjet Omkonfigurator for at reparere den.",
    '__databases' => "Databaser",
    '__databases_list' => "Databaser",
    '__database_type_not_supported_by_key' => 'For at kunne bruge %1 server, skal din licensnøgle understøtte dette. Kontakt din Plesk-salgsrepræsentant.',
    '__date_immediately' => "i dag",
    '__date_never' => "aldrig",
    '__day(s)' => "Dag(e)",
    '__day0' => "Sun",
    '__day1' => "Man",
    '__day2' => "Tirs",
    '__day3' => "Ons",
    '__day4' => "Tors",
    '__day5' => "Fre",
    '__day6' => "Lør",
    '__days' => "%1 dag(e)",
    '__db_admin_login_empty' => "Du har angivet et tomt brugernavn, hvilket deaktiverer kontrol over %1 i grænsefladen. Vil du fortsætte?",
    '__db_unable_to_unregister' => 'Kunne ikke fjerne parametre for databasetilslutning',
    '__db_db_exists' => 'Der er mindst én database på serveren.',
    '__db_unable_to_change_server_name' => 'Navn på serveren kan ikke ændres',
    '__db_unable_to_change_port' => 'Port til serveren kan ikke ændres',
    '__db_already_exist' => "Databasen %1 findes allerede.",
    '__db_credentials_invalid' => "Brugerens legitimationsoplysninger er ugyldige.",
    '__db_invalid_password_characters' => 'Adgangskoden indeholder ugyldige tegn',
    '__db_engine' => "Databasekerne", // indirect
    '__db_type' => "Databasetype",
    '__db_user' => "Databasebruger",
    '__db_server' => 'Databaseserver',
    '__def_domain' => "Standarddomæne",
    '__default_for_mysql' => 'standard for MySQL',
    '__default_for_mariadb' => 'standard for MariaDB',
    '__default_for_percona' => 'standard for Percona',
    '__default_for_postgresql' => 'standard for PostgreSQL',
    '__delete' => "Slet",
    '__demo' => "Denne funktion er ikke tilgængelig i demoversionen.",
    '__directory' => "Bibliotek",
    '__disable_lock_screen' => 'Afhold brugere fra at arbejde med Plesk, indtil grænsefladeskærmene er helt indlæste',
    '__dismiss_news?' => "Er du sikker på, at du helt vil lukke nyhedsblokken? \n \nDu vil ikke kunne se nyhedsblokken før der er flere nyheder til rådighed.",
    '__description' => "Beskrivelse",
    '__disabled' => "deaktiveret",
    '__disk_space_limit' => "Diskpladsgrænse",
    '__cgroups_cpu_usage_limit' => 'CPU-forbrugsgrænse',
    '__cgroups_ram_usage_limit' => 'RAM-forbrugsgrænse',
    '__cgroups_disk_read_usage_limit' => 'Grænse for disklæsningsbåndbredde',
    '__cgroups_disk_write_usage_limit' => 'Grænse for diskskrivningsbåndbredde',
    '__disk_usage_by' => "Diskplads anvendt af %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS-posten '%1' findes allerede.",
    '__dns_master_should_be_remote' => "Du bør have to forskellige autoritative navneservere på separate hosts.",
    '__dns_record_not_exist' => "DNS-posten findes ikke.",
    '__dns_server' => "DNS-server", // indirect
    '__dom_id_is_undefined' => "Domæne-ID er ikke defineret",
    '__dom_name' => "Domænenavn",
    '__dom_name_is_invalid' => "Domænenavnet er ugyldigt. Kontrollér, at dit domænenavn kun består af alfanumeriske tegn samt punktum og bindestreger, og at det højst er 255 tegn langt. Hver enkelt del af domænenavnet mellem punktummerne må ikke være længere end 63 tegn.",
    '__dom_not_exist' => "Domænet findes ikke.",
    '__domain' => "Domæne",
    '__domain_' => 'Domæne %1',
    '__domain_form' => "Domæneformular",
    '__domain_id' => "Domæne-ID",
    '__domain_is_turned_off_for_backup' => "Webstedet %1 er midlertidigt deaktiveret på grund af sikkerhedskopiering/gendannelse, og det er ikke til rådighed i øjeblikket.",
    '__domain_limits' => "Domænebegrænsninger.",
    '__domain_name' => "Domænenavn",
    '__mail_name_in_ASCII_form' => "E-mailkonto navn i ASCII-format",
    '__message_error' => 'Fejl',
    '__message_warning' => 'Advarsel',
    '__message_info' => 'Information',
    '__domain_name_in_ASCII_form' => "Domænenavn i ASCII-format",
    '__domain_repository' => "Opbevaringsområde for domænet %1",
    '__domain_status' => "Domænestatus",
    '__domain_found_tech' => "Teknologi fundet på domænet",
    '__domain_dns' => 'Domænets DNS-zone',
    '__domain_total' => "Totalbeløb for abonnementet.",
    '__domain_total_powerUser' => "Totalbeløb for abonnementet.",
    '__domain_user' => "Domæneadministrator",
    '__domains_global_changes' => "Rediger udvalgte domæner",
    '__mailnames_global_changes' => "Redigér udvalgte e-mailkonti.",
    '__backup_manager' => 'Sikkerhedskopi-administrator',
    '__domains_list' => "Domæner",
    'domains_list__list_header' => "domæner",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Domænenavnet starter med www, selvom præfikset WWW bruges. \nFortsætte alligevel?",
    '__dovecot' => 'Dovecot IMAP og POP3 server',
    '__dsmail' => "Posttjeneste",
    '__dsmaillist' => "Maillisteservice",
    '__dumps_tot_size' => "Den totale størrelse af sikkerhedskopifilerne i det lokale oipbevaringsområde",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "E-mail-adressen er ugyldig.",
    '__enabled' => "aktiveret",
    '__enter_cert_text' => "Indtast certifikattekst:",
    '__enter_size' => "Indtast størrelse",
    '__exclusive' => "Dedikeret",
    '__expiration_date' => "Udløbsdato",
    '__fax' => "Fax",
    '__file' => "Fil",
    '__file_is_empty' => "Fil er tom.",
    '__file_name' => "Filnavn",
    '__file_type' => 'Filtype',
    '__filemanager' => "Fil-administrator",
    '__filepath_is_empty' => "Stien til filen er tom",
    '__files_list' => "Filer",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-indstillinger",
    '__ftp_serv' => "FTP-server", // indirect
    '__ftp_server_parameters_are_empty' => "Du skal først indstille FTP-konto egenskaber!",
    '__ftp_status' => "FTP-server status",
    '__full_day0' => "Søndag",
    '__full_day1' => "Mandag",
    '__full_day2' => "Tirsdag",
    '__full_day3' => "Onsdag",
    '__full_day4' => "Torsdag",
    '__full_day5' => "Fredag",
    '__full_day6' => "Lørdag",
    '__full_month1' => "Januar",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "December",
    '__full_month2' => "Februar",
    '__full_month3' => "Marts",
    '__full_month4' => "April",
    '__full_month5' => "Maj",
    '__full_month6' => "Juni",
    '__full_month7' => "Juli",
    '__full_month8' => "August",
    '__full_month9' => "September",
    '__giga' => "G",
    '__group' => "Gruppe",
    '__h' => "H",
    '__hard_disk_quota' => "Harddiskkvote",
    '__hard_disk_quota_not_supported' => 'harddiskkvote understøttes ikke på grund af server-filsystemets konfiguration',
    '__header_text_is_invalid' => "Titel på det beskyttede område er ugyldig",
    '__help_topic_not_found' => 'Det omspurgte hjælpeemne (%1) findes ikke.',
    '__hosting_ip_dns_ip_not_equiv' => "Ingen af de angivne IP-adresser i A DNS-posterne matcher den IP-adresse der bruges til hosting.",
    '__hosting_scripting' => "Hosting-scripting understøttelse",
    '__hosting_setup_page_title' => "Web-hosting opsætning for domænet %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Hostingtype",
    '__hostname_is_empty' => "Host-navnet er tomt.",
    '__hour(s)' => 'Time(r)',
    '__hst_type_incorrect' => "Hostingtypen er forkert.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Ledig tid",
    '__iface' => "Grænseflade",
    '__image' => "Billede",
    '__imap_status' => "IMAP-serverstatus",
    '__in' => "Ind",
    '__in_%' => "I %",
    '__incorrect_databases_login_pass' => "De akkreditiver, du har anvendt til adgang til PostgreSQL er forkerte.",
    '__incorrect_ip_or_network_address' => 'Forkert IP-adresse eller netværk.',
    '__info' => 'Info',
    '__install' => "Installer",
    '__install_prefix' => "Installér præfiks",
    '__invalid_cert_id' => "Ugyldigt certifikat-ID.",
    '__invalid_context' => "Ugyldig kontekst: %1",
    '__invalid_db_usr_name' => "Database-brugernavnet er ugyldigt.",
    '__invalid_dir_name' => "Mappenavnet er ugyldigt",
    '__invalid_dom_name' => "Domænenavnet er ugyldigt.",
    '__invalid_filename' => "Ugyldigt filnavn. Brug ikke enkelt-anførselstegn og/eller \"../\" kombination.",
    '__invalid_id' => "Ugyldigt id.",
    '__invalid_lines_num' => "Forkert værdi for antal linjer - kun cifre er tilladt.",
    '__invalid_max_letter_size' => "Maksimal meddelelsesstørrelse er ugyldig.",
    '__invalid_pdir_name' => "Navnet på beskyttet mappe er ugyldigt.",
    '__invalid_restart_apache_interval' => "Apache-genstartsinterval er ugyldigt.",
    '__invalid_tmpl_name' => "Skabelonnavnet er ugyldigt.",
    '__invalid_value' => "Forkert værdi.",
    '__ip_addr' => "IP-adresse",
    '__ip_address_and_mask' => "IP-adresse og undernetmaske",
    '__ip_alias__mask' => "IP-adresse og undernetmaske",
    '__ip_addr_is_invalid' => "IP-adressen er ugyldig",
    '__ip_addr_list' => "IP-adresser",
    '__ip_address_and_mask_hint' => 'For eksempel %1.',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBytes",
    '__key_for_virtuozzo_only' => "Din licensnøgle er udelukkende beregnet til brug i Virtuozzo-containere.",
    '__key_limits_exceeding' => "Denne handling overskrider de grænser, der er defineret i din softwarelicens. Hvis du har modtaget denne meddelelse, kan du kontakte din udbyder eller producenten, for at få klarhed over eller udvide grænserne i denne licens.",
    '__kilo' => "K",
    '__keywords' => 'Nøgleord',
    '__lang_unknown' => 'Sproget kunne ikke genkendes.',
    '__languages' => 'Sprog',
    '__learn_more' => 'Få flere oplysninger',
    '__loading' => 'Indlæser…',
    '__locales' => "Sprogpakker",
    '__lists' => "Mailing Lists",
    '__literal_bytes' => "B",
    '__processing' => "Vent et øjeblik.<br>Indlæser...",
    '__locale' => "Interface sprog",
    '__locale_is_not_defined' => "Grænsefladesprog ikke defineret.",
    '__local_server_mysql' => 'Lokal MariaDB/MySQL-server',
    '__local_server_postgresql' => 'Lokal PostgreSQL-server',
    '__local_server_mssql' => 'Lokal MS SQL-server',
    '__log_and_statistics_files' => 'Logfiler og statistikrapporter',
    '__config_files' => 'Konfigurationsfiler',
    '__chroot_files' => 'Chrooted miljø',
    '__login' => "%1 Log på",
    '__login1' => "Log på",
    '__login_disabled' => "Login forbudt",
    '__login_enabled' => "Login tilladt",
    '__login_incorrect' => "Du har indtastet forkert brugernavn eller adgangskode.",
    '__login_name' => "%1 brugernavn:",
    '__login_name_is_invalid' => "%1 brugernavnet er ugyldigt.",
    '__logon_time' => "Log på-tid",
    '__ma' => "E-mail aliasser",
    '__mail' => "E-mail",
    '__mail_alias_name' => "E-mailalias navn",
    '__mail_autodiscovery' => 'Email autoopdagelse',
    '__mail_exchanger_name_is_invalid' => "E-mail Exchange navnet er ugyldigt.",
    '__mail_groups' => "Mailgrupper",
    '__mail_list_engine' => "Maillistesoftware",
    '__mail_name' => "Mailkonto",
    '__mail_name_form' => "Egenskaber for e-mail konto",
    '__mail_names' => "Mailkonti",
    '__mail_serv' => "Mailserver",
    '__mail_user' => 'E-mail bruger',
    '__mailgroup' => "Mailgruppe",
    '__maillist' => "Maillister",
    '__maillists' => "Mailing Lists",
    '__maillist_member' => 'Maillistemedlem',
    '__mailname' => "Mailkonto",
    '__mailname_redir_self' => "E-mail konto kan ikke videresende til sig selv.",
    '__max_dom_num_reached_for_cl' => "Grænsen for antal domæner er nået for denne kundekonto.",
    '__max_file_size_available' => "Maksimal tilladt filstørrelse er %1",
    '__max_subdom_num_reached_for_cl' => "Grænsen for antal underdomæner er nået for denne kundekonto.",
    '__max_subdom_num_reached_for_dom' => "Begrænsningen for antal underdomæner blev nået for domænet.",
    '__max_subdom_num_reached_for_key' => "Begrænsningen for antal underdomæner der tillades af licensnøglen blev nået.",
    '__max_traffic_limit' => "Trafikbegrænsning",
    '__maximum_excl_ip_num' => "Mailkonti",
    '__mb' => "MB",
    '__mbytes' => "megabyte",
    '__mb_month' => "MB/måned",
    '__mb_sec' => "MB/sek.",
    '__gb_sec' => "GB/sek.",
    '__tb_sec' => "TB/sek.",
    '__mega' => "M",
    '__minute(s)' => 'Minut(ter)',
    '__mls_not_in_key' => "Din produktnøgle understøtter ikke en flersproget brugerflade.",
    '__modification_date' => "Ændringsdato",
    '__module' => "Lokalnummer",
    '__month' => "Måned",
    '__month(s)' => "Måned(er)",
    '__month1' => "Jan",
    '__month10' => "Okt",
    '__month11' => "Nov",
    '__month12' => "Dec",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "April",
    '__month5' => "Maj",
    '__month6' => "Juni",
    '__month7' => "Juli",
    '__month8' => "Aug",
    '__month9' => "Sept",
    '__monthly' => "Hver måned",
    '__months' => "måneder",
    '__moved_permanently' => 'Flyttet permanent',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Microsoft SQL-servernavn",
    'mssql__unable_to_change_server_name_db_exists' => "servernavnet kan ikke ændres: der er mindst én database på serveren.",
    '__mssql_status' => "Microsoft SQL-serverstatus",
    '__multiply_login_deny' => "Kan ikke logge dig på. En anden bruger med samme brugernavn (%1) er allerede logget på Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL-server status",
    '__mysql_version' => "MySQL-version",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB-serverstatus",
    '__mariadb_version' => "MariaDB version",
    '__percona' => "Percona",
    '__percona_status' => "Percola-serverstatus",
    '__percona_version' => "Percona version",
    '__name' => "Navn",
    '__name_invalid' => "Navnet er ugyldigt.",
    '__nameserver' => "navneserver",
    '__network' => "Netmaske",
    '__networks' => "Netværk",
    '__no' => "Nej",
    '__no_ip_address_with_properly_type_available' => "Kunne ikke gendanne de sikkerhedskopierede data, da der ikke er nogle egnede IP-adresser til gendannelsen.",
    '__no_clients_specified' => "Der er ikke angivet nogen kundekonti.",
    '__no_comments' => "Ingen kommentarer.",
    '__nologin' => "Forbudt",
    '__none' => "Ingen",
    '__not_configured' => "Ikke konfigureret",
    '__not_implemented_yet' => "Endnu ikke implementeret",
    '__not_supported_by_ftp' => "(ikke understøttet af FTP-server)",
    '__notification' => "Advisering",
    '__num_displayed' => "%1 af %2 vist",
    '__num_is_invalid' => "Nummeret er ugyldigt.",
    '__object_not_found' => 'Objektet blev ikke fundet: %1',
    '__of_all' => "% af alle",
    '__off' => "Deaktiveret",
    '__ok' => "OK",
    '__old_passwd' => "Gammel %1 adgangskode",
    '__on' => "Aktiveret",
    '__others' => "Andre",
    '__other_ip__will_be_added' => 'Andre ledige IP-adresser (vil blive føjet til kundens IP-gruppe)',
    '__out' => "Ud",
    '__p' => "P",
    '__passwd' => "%1 adgangskode:",
    '__passwd_is_invalid' => "%1 adgangskoden er ugyldig:",
    '__passwd_not_match' => "Adgangskoderne stemmer ikke overens!",
    '__path' => "Sti",
    '__perl_unix_support' => "Perl-understøttelse",
    '__perl_win_support' => "Perl-understøttelse",
    '__perm_denied' => "Tilladelse nægtet",
    '__permissions' => "Rettigheder",
    '__personal_name' => "Personligt navn",
    '__pg_admin_not_activated' => "PostgreSQL var ikke aktiveret på server-administrationssiden.",
    '__pg_not_inst' => "PostgreSQL var ikke installeret",
    '__pg_not_run_or_inst' => "PostgreSQL var ikke installeret eller kører ikke.",
    '__pg_not_support_in_key' => "PostgreSQL understøttes ikke af licensnøglen.",
    '__phone' => "Telefon",
    '__phosting' => "Fysisk hosting",
    '__php_support' => "PHP-understøttelse",
    '__php_run_as_isapi' => "kør som et ISAPI-udvidelse",
    '__php_safe_mode' => "PHP 'safe_mode' aktiveret",
    '__php_version' => "PHP-version",
    '__physical' => "Fysisk hosting",
    '__plesk_stat_pdir' => "Beskyt mappen '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Domænestatistik",
    '__plesk_stat_protect' => "Beskyt adgang til webstatistik med brugerens FTP-brugernavn og adgangskode",
    '__plesk_stat_protect_install' => "tilgængelig via adgangskodebeskyttet mappe '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3-serverstatus",
    '__popen_error' => "Der opstod en fejl under kald af popen-funktionen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL status",
    '__preferences' => "Indstillinger",
    '__account_preferences' => "Kontoindstillinger",
    '__interface_preferences_general' => 'Generelt',
    '__interface_preferences_default' => 'Standard brugerfladeindstillinger',
    '__interface_preferences_admin' => "Præferencer for administrator-brugerflade",
    '__interface_template' => 'Grænseflade-tilpasningsskabelon',
    '__interface_preferences' => "Grænsefladeindstillinger",
    '__proceed?' => "Vil du fortsætte?",
    '__protect_dir_user' => "Bruger af beskyttet mappe",
    '__protect_dir_users' => "Brugere af beskyttet mappe",
    '__provider_contact_name' => "Ejers kontaktnavn",
    '__python_unix_support' => "Python-understøttelse",
    '__python_win_support' => "Python-understøttelse",
    '__quota' => "Kvota",
    '__r' => "R",
    '__reconfigure' => "Omkonfigurer",
    '__record_type' => "Post-type",
    '__release' => "Frigiv",
    '__remote_db_not_supported_by_key' => 'Ekstern databasehosting understøttes ikke af din licensnøgle.',
    '__remove' => "Fjern",
    '__remove_confirmation' => "Bekræft fjernelse",
    '__remove_protection' => 'Fjern beskyttelse',
    '__report' => "Rapport",
    '__report_size_na' => "Service er ikke tilgængelig.",
    '__reports_list' => "Rapporter",
    '__requested' => "Er blevet anmodet",
    '__required_fields' => "Obligatoriske felter",
    '__resp_name_invalid' => "Autosvar-navn er ugyldigt. Brug kun alfanumeriske tegn, punktum, understregning og mellemrumssymboler.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Servernavnet er ugyldigt.",
    '__screenshots' => 'Skærmbilleder',
    '__script_warning' => "Ved at fjerne scripting-muligheden fra dette domæne vil alle påvirkede scripts blive vist som almindelig tekst, når de kaldes af en browser. Det tillades administratoren at fjerne alle afhængige scripts fra det påvirkede domæne.",
    '__sec' => "Sekunder",
    '__second(s)' => "Sekund(er)",
    '__see_list_of_logged_in' => "Se listen over brugere der er logget på i øjeblikket.",
    '__select_certs_to_remove' => "Vælg certifikater der skal fjernes-",
    '__select_files_to_remove' => "Vælg de filer, der skal fjernes.",
    '__select_ip' => "Tildel IP-adresse",
    '__select_ip_to_remove' => "Vælg en IP-adresse der skal fjernes.",
    '__select_domain_template' => "Brug domæneskabelon-indstillinger",
    '__select_templates_to_remove' => "Vælg skabeloner der skal fjernes.",
    '__server' => "Server",
    '__server_total' => "Servertotaler",
    '__service' => "Service",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MariaDB/MySQL databaseserver",
    '__service_description__mysql' => "MariaDB/MySQL databaseserver",
    '__service_title__web' => "Web-server",
    '__service_description__web' => "Web-server",
    '__service_title__smtp' => "SMTP-server",
    '__service_description__smtp' => "SMTP-server",
    '__service_title__mail' => "IMAP/POP3 Server",
    '__service_description__mail' => "IMAP/POP3 Server",
    '__service_title__dns' => "DNS-server",
    '__service_description__dns' => "DNS-server",
    '__service_title__postgresq' => "PostgreSQL-databaseserver:",
    '__service_description__postgresq' => "PostgreSQL-databaseserver:",
    '__service_title__spamassassin' => "SpamAssassin spamfiltreringsservice",
    '__service_description__spamassassin' => "SpamAssassin spamfiltreringsservice",
    '__services' => "Tjenester",
    '__all_services' => "Alle tjenester",
    '__sessions' => "Sessioner",
    'sessions__feature_ftp_session_manager_not_supported' => "FTP-sessioner er understøttes ikke af den nuværende FTP-server.",
    '__sessions_list' => "Sessioner",
    '__set' => "Slå til",
    '__shared' => "Delt",
    '__shell_access_warning' => "Tilladelse af shell-adgang til systemet er yderst betænkeligt for systemsikkerheden. Tillad kun adgang til systemet, hvis du er helt klar over hvad du gør - og i så fald kun til brugere, der er fuld tillid til. Vil du virkelig tillade adgang?",
    '__siteapp_not_support_in_key' => "Webprogrammer understøttes ikke af licensnøglen.",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfigurationen af dette webprogram blev ændret manuelt. For at beskytte de manuelle ændringer blev omkonfigurering via Plesk gjort utilgængelig.',
    '__site_management' => "Webpublicering", // indirect
    '__size' => "Størrelse",
    '__skeleton' => 'Skabelon til Virtuel host',
    '__skins' => 'Tema',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP-server status",
    '__some_fields_are_empty_or_invalid' => "Nogle felter er tomme, eller indeholder en ugyldig værdi.",
    '__unable_to_set_parameters' => "Kan ikke indstille parametre for komponenten.",
    '__spamassassin' => "Spamfilter",
    '__spamassassin_status' => "SpamAssassin-status",
    '__spamd_status' => 'Spamfilterstatus',
    '__splited_backup' => "(multivolume sikkerhedskopi)",
    '__split_backup_file' => "Opret en mulitvolume sikkerhedskopi",
    '__split_backup_size' => "Størrelse på diskenhed",
    '__split_backup_less_than_500' => "Volume-størrelse mindre end 500 megabytes understøttes ikke",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI-understøttelse",
    '__ssi_with_html' => "Brug SSI til *.htm, *.html filer",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-understøttelse",
    '__same_ssl' => "Brug en enkelt mappe til opbevaring af SSL/TLS og ikke-SSL/TLS indhold",
    '__same_ssl_cu' => "Fælles SSL/TLS og ikke-SSL/TLS indhold",
    '__state' => "Stat/region",

    '__status__Active' => 'Aktiv',
    '__status__active' => 'aktiv',
    '__status__Passive' => 'Deaktiveret',
    '__status__passive' => 'deaktiveret',
    '__status__off' => 'deaktiveret',
    '__status__with_parent' => 'deaktiveret',
    '__status__backup_restore' => 'midlertidigt suspenderet pga. sikkerhedskopiering/gendannelse.',
    '__status__admin' => 'suspenderet af serveradministrator',
    '__status__resseler' => 'suspenderet af forhandler',
    '__status__client' => 'suspenderet af bruger',
    '__status__unknown' => 'status er ukendt',

    '__status_of' => "Status for %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel-server", // indirect
    '__subdomain' => "Subdomæne",
    '__subdomain_name' => "Underdomænenavn",
    '__subdomain_name_in_ASCII_form' => "Underdomænenavn i ASCII-format",
    '__subdomains' => "Subdomæner",
    '__domainaliases' => "Domænealiasser",
    '__subdomains_list' => "Subdomæner",
    '__subdomains_not_support_in_key' => "Underdomænehandlinger understøttes ikke af licensnøglen.",
    '__sys_user_type' => "FTP-bruger",
    '__sys_user_type_main' => "Anvend hoveddomænets FTP-brugerkonto",
    '__sys_user_type_native' => "Opret en separat FTP-brugerkonto for dette underdomæne",
    '__t' => "S",
    '__target_domain' => "Måldomæne",
    '__template' => "Skabelon",
    '__template_not_accepted' => "Kunne ikke acceptere skabelonen: følgende begrænsninger er overskredet.",
    '__templates' => "Skabeloner",
    '__templates_list' => "Skabeloner",
    '__tera' => "S",
    '__title' => "Titel",
    '__tools' => "Værktøjer",
    '__total' => "Total %1",
    '__total_size' => "Størrelse i alt",
    '__total_used' => "Brugt i alt",
    '__traffic' => "Trafik",
    '__traffic_by_client' => "Trafikforbrug efter kunde",
    '__traffic_by_domain' => "Trafik efter domæne",
    '__traffic_by_service' => "Trafik efter service",
    '__traffic_history' => "Trafikhistorik",
    '__unable_change_locale' => "Kunne ikke ændre brugerfladesproget: %1",
    '__unable_create_new_dom' => "Kunne ikke oprette nyt domæne: %1",
    '__unable_define_dom_name' => "Kunne ikke definere domænenavn: %1",
    '__unable_define_necessary_properties' => "Kunne ikke definere alle nødvendige egenskaber.",
    '__unable_define_properties' => "Kunne ikke definere egenskaber: %1",
    '__unable_exec_util' => "Kunne ikke udføre værktøjsfunktion: %1",
    '__unable_get_dns_a_recs' => "Kunne ikke hente IP-adresser for A DNS-poster for denne hosting-konto: %1",
    '__unable_get_mbox_quota' => "Kunne ikke hente informationen om mailboks-størrelsesgrænse.",
    '__unable_redirect_to_myself' => "Kunne ikke videresende til den samme konto.",
    '__unable_redirect_to_my_alias' => "Kunne ikke videresende e-mail til et e-mail alias.",
    '__default_domain_redirect_to_myself' => "Kunne ikke indstille domæne som standard for IP-adressen: \n omdirigering til sig selv detekteret.",
    '__unable_remove_client' => "Kunne ikke fjerne kunden: %1",
    '__unable_set_up_mbox_quota' => "Kunne ikke indstille mailboks størrelsesgrænse for domænet: %1",
    '__unable_setup_pass' => "Kunne ikke indstille adgangskoden: %1.",
    '__unable_to_create_new_account' => "Kunne ikke oprette ny konto: %1",
    '__unable_to_define_db_size' => "Kunne ikke definere databasestørrelse.",
    '__unable_to_enable_short_names' => "Kunne ikke tillade brug af korte e-mail kontonavne til POP3/IMAP-konti.",
    '__unable_to_fetch_data_from_submit' => "Kunne ikke hente indsendte data: %1",
    '__unable_to_open_file' => "Kunne ikke åbne filen %1: %2",
    '__unable_to_update_subdomain' => "Kunne ikke foretage ændringer af underdomænet: %1",
    '__unable_update_cl_data' => "Kunne ikke foretage ændringer af brugerkontoen: %1",
    '__unable_update_db_params' => "Kunne ikke opdatere databaseparametre: %1",
    '__unable_update_dom_data' => "Kunne ikke opdatere domænedata: %1.",
    '__undefined' => "udefineret",
    '__uninstall' => "Afinstaller",
    '__unknown_error' => "Der opstod en ukendt fejl",
    '__unlimited_lower' => "Ubegrænset",
    '__unset' => "Slå fra",
    '__update' => "Opdatering",
    '__uploaded_file_is_invalid' => "Uploadet fil er ugyldig: %1",
    '__url' => "URL",
    '__usage' => "Diskforbrug",
    '__user' => 'Bruger',
    '__user_already_logged' => "En anden bruger med samme brugernavn (%1) er allerede logget på Plesk.",
    '__version' => "Version",
    '__aps_license' => "Licensnøgle",
    '__vh_type' => "Virtuel host-type",
    '__vhosts_apache_status' => "Webserver status",
    '__wrong_charset_conversion' => 'Forkert tegnsæt, konvertering fra "%1" til "%2" er ikke tilladt',
    '__warning_' => "Advarsel!",
    '__warning_excl_ip_num' => "Dedikeret IP-adresse.",
    '__warning_expiration' => "Udløbsdato",
    '__web_scripting' => "Webscripting", // indirect
    '__web_serv' => "Web-server", // indirect
    '__web_statistic' => "Webstatistik", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer er ikke installeret på serveren. Kontakt serviceudbyderen for at få hjælp til Webalizer-installationen.",
    '__webstat_support' => "Webstatistik",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Når du skifter fra ét statistikprogram til et andet, slettes alle rapporter, der er oprettet vha. det tidligere anvendte statistikprogram, og nye rapporter oprettes i overensstemmelse med den information der læses fra logfiler, opbevaret på serveren. Det betyder, at hvis du konfigurerede systemet (vha. Domæner > domænenavn > Logadministrator > Logrotation), så logfilerne kun opbevares i en måned, så vil webstatistik kun være til rådighed for den seneste måned. Vil du skifte til en anden statistikpakke?",
    '__webstat_perm_denied' => 'Du har ikke tilladelse til at administrere webstatistik.',
    '__webuser' => "Webbruger",
    '__sysusers_list' => "Systembrugere",
    '__sysuser' => "Systembruger",
    '__weekly' => "Hver uge",
    '__whats_new_in_version' => "Nyheder i Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Denne handling er kun til rådighed på websteder med webhosting.",
    '__wrong_hosting_type__none' => 'Der er ikke konfigureret webhosting på domænet %1.',
    '__wrong_hosting_type__std_fwd' => 'Domænet %1 har standard frame-videresendelse konfigureret. Denne handling er kun til rådighed på websteder med webhosting.',
    '__wrong_hosting_type__frm_fwd' => 'Domænet %1 har frame-videresendelse konfigureret. Denne handling er kun til rådighed på websteder med webhosting.',
    '__wu' => "Webbrugere",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW-præfiks blev ændret. Sørg for at ændre SSL/TLS-certifikatet i henhold hertil.",
    '__year' => "År",
    '__year(s)' => "År",
    '__yes' => "Ja",
    '__you' => "Dig",
    '__zip_code' => "Postnummer.",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avanceret",

    'admin_ed__edit_administrator_info' => "Rediger administratorprofilen.",
    'admin_ed__create_default_client' => "Jeg vil oprette en standard kundekonto.",
    'admin_ed__unable_update' => "Kunne ikke opdatere administratorinformation: %1",

    'auth__update_admin_info' => "Indtast administratorens oplysninger. Disse oplysninger er nødvendige for at betjene %1.",
    'auth__you_not_have_perm' => "Du har ikke tilladelse til at administrere dette domæne.",
    'auth__key_expired_admin' => 'Din Plesk-licens er udløbet. Forny din licens nu, eller køb en ny licens, for at fortsætte med at bruge Plesk.',
    'auth__key_expired_admin_restricted' => 'Din Plesk-licens er udløbet. Kontakt din serviceudbyder for at fortsætte med at bruge Plesk.',
    'auth__key_expired_client' => 'Plesklicensen er udløbet. Kontakt din hosting-udbyder.',
    'autoinstaller__not_installed' => 'Autoinstallér komponent, er ikke installeret.',
    'autoinstaller__release_action' => 'Tilgængelige handlinger',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Opgradering til den nye Plesk-version',
    'autoinstaller__release_action_update' => 'Opdatering eller tilføjelse af nye komponenter',
    'autoinstaller__release_action_up2date' => 'Du har en opdateret version',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Ikke installeret',
    'autoinstaller__component_action_update' => 'Opdateringer er til rådighed',
    'autoinstaller__component_action_upgrade' => 'Der findes en opdatering.',
    'autoinstaller__component_action_up2date' => 'Du har en opdateret version',
    'autoinstaller__component_action_error' => 'Opdateringer er ikke til rådighed',
    'autoinstaller__component_serverbuildtime' => 'Seneste udgave',
    'autoinstaller__component_localbuildtime' => 'Din udgave',
    'autoinstaller__component_installed_version' => 'Din version',
    'autoinstaller__component_available_version' => 'Seneste tilgængelige version',
    'autoinstaller__component' => 'Komponent',
    'autoinstaller__components' => 'Komponenter',
    'autoinstaller__components_title' => '%1 Komponenter',
    'autoinstaller__component_dependency_note' => 'kræves for installation af de komponenter, du valgte',
    'autoinstaller__install_confirm' => 'Ja, jeg vil installere disse komponenter',
    'autoinstaller__install_confirm_request' => 'Bekræft ved at vælge afkrydsningsfeltet',
    'autoinstaller__install_title' => 'Bekræft installation af de valgte komponenter',
    'autoinstaller__key_update_confirm' => 'Bekræft, at du vil springe over nøgleopdatering og installation af standardnøgle',
    'autoinstaller__key_update_confirm_request' => 'Bekræft ved at markere afkrydsningsfeltet',
    'autoinstaller__key_update_failed' => '<p>Plesk kan ikke opdatere din produktlicens.</p><p>%1</p><p>Fortsættelse af opgraderingen uden af have den tilhørende produktlicens vil medføre installation af en standardlicens med begrænset funktionalitet. Det tilrådes administratorer først at få fat i den relevante licensnøgle inden produktopgraderingen fortsættes.</p>',
    'autoinstaller__email' => 'Send advisering til',
    'autoinstaller__email_admin' => "Administrators e-mail-adresse",
    'autoinstaller__email_email' => 'Brugerdefineret e-mail adresse.',
    'autoinstaller__release' => 'Udgavenavn',
    'autoinstaller__releases' => 'udgaver til rådighed',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Vælg de komponenter, der skal installeres.',
    'autoinstaller__status_error' => 'Fejl: %1',
    'autoinstaller__status_install_error' => 'Installationen kunne ikke startes: %1',
    'autoinstaller__status_install_busy' => 'Installationen kunne ikke startes: En anden installationsprocedure kører i øjeblikket.',
    'autoinstaller__status_install_ok' => 'Installationen er påbegyndt. Du bliver adviseret om installationsforløbet via e-mail (%1).',
    'autoinstaller__status_query_busy' => 'Installationen er i gang.',
    'autoinstaller__status_query_error' => 'Kunne ikke hente installationsstatus: %1.',
    'autoinstaller__status_unknown' => 'Kunne ikke hente autoinstallations-status.',
    'autoinstaller__status_busy' => 'Autoinstallering er optaget - vent.',
    'autoinstaller__configure_title' => 'Opdatér indstillinger',
    'autoinstaller__preferences_legend' => 'Indstillinger',
    'autoinstaller__target' => 'Midlertidig downloadmappe.',
    'autoinstaller__target_invalid' => "Angiv absolut sti",
    'autoinstaller__check_updates' => 'Tjek om der er opdateringer når administrator logger på Plesk',
    'autoinstaller__check_updates_warning' => 'Nye <a href="%1">opdateringer</a> er til rådighed for %2',
    'autoinstaller__source_type' => 'Kildetype',
    'autoinstaller__source' => 'Kilde-URL',
    'autoinstaller_source__preferences_legend' => 'Indstillinger',
    'autoinstaller_source__type' => 'Kildetype',
    'autoinstaller_source__url_invalid' => 'Ugyldig kilde',
    'autoinstaller_source__url_invalid_network' => 'Ugyldig kilde-URL (f.eks.: http://kilde, ftp://kilde)',
    'autoinstaller_source__url' => 'Kilde-URL',
    'autoinstaller__source_invalid_network' => 'Du har angivet en ugyldig netværksadresse.',
    'backup__repository' => 'Sikkerhedskopifil-opbevaringsområde',
    'backup__error_notify_email' => 'Send advisering til e-mail adresse hvis der opstår fejl under sikkerhedskopieringen',
    'backup__dump_info' => "Oplysninger om sikkerhedskopi",
    'backup__dump_file_name_not_defined' => "Sikkerhedskopifilnavn er ikke angivet.",
    'backup__local_file' => 'Lokal sikkerhedskopifil:',
    'backup__domain_ftp' => 'ekstern FTP-server',
    'backup__wrong_path' => "Forkert sti til sikkerhedskopi-opbevaringsområdet: Brug ikke tegnsekvensen ../../",
    'backup__unable_to_connect_to_ftp_server' => "Kunne ikke oprette forbindelse til FTP-serveren: %1.",
    'backup__unable_to_read_file' => 'Kunne ikke læse sikkerhedskopifilen.',
    'backup__backup_task_does_not_exist' => "Sikkerhedskopieringsopgave findes ikke - du skal oprette den inden den aktiveres.",
    'backup__restore_params' => "Gendannelsesparametre",
    'backup__confirmation' => "Advarsel: Domænet vil ikke være til rådighed under sikkerhedskopiering eller gendannelse.",
    'backup__backup_method' => 'Sikkerhedskopieringsmetode',
    'backup__dumpfile_name' => "Navn på sikkerhedskopieringsfilen",
    'backup__dumpfile_name_is_invalid' => "Sikkerhedskopinavnet er ugyldigt: brug kun alfanumeriske tegn, bindestreger, punktum og understregningstegn - brug ikke navne som beskrivelse.* som sikkerhedskopieringsfilnavn",
    'backup__email_required' => "Din e-mail adresse kræves for at holde dig informeret om sikkerhedskopierings- og gendannelsesforløb. Indtast din e-mail adresse under kontooplysningerne.",
    'backup__error_during_backup' => "Kunne ikke oprette sikkerhedskopifilen: %1",
    'backup__input_email_warning' => "Du skal enten angive en e-mail adresse til advisering eller rydde afkrydsningsfeltet.",
    'backup__make_download' => "gem ikke sikkerhedskopifilen i opbevaringsområdet, download den kun",
    'backup__make_dump' => 'opret sikkerhedskopifil og gem i lokalt opbevaringsområde',
    'backup__makedump_to_ftp' => 'opret sikkerhedskopifil og gem den på ekstern FTP-server',
    'backup__restore_ip' => "IP-adresse til gendannelse",
    'backup__select_dumpfile' => "Vælg en sikkerhedskopifil.",
    'backup__time' => "Sikkerhedskopieringstid",
    'backup__day' => 'Sikkerhedskopieringsdag',
    'backup__view_dump_info' => "Vis sikkerhedskopiinformation for domænet %1",
    'backup__wrong_domain_name' => "Sikkerhedskopifilen indeholder dataene fra domænet %1 og de kan derfor ikke gendannes på domænet %2",
    'backup__incorrect_ftp_user_or_passwd' => "Forkert FTP-bruger eller adgangskode. Ret venligst FTP-konto egenskaberne",
    'backup__access_denied' => "Adgang nægtet. Ret venligst FTP-konto egenskaberne",
    'backup__restore_from' => "Gendan %1",
    'backup__domain_session_failed' => 'Domænet %1 blev ikke sikkerhedskopieret',
    'backup__client_session_failed' => 'Kunden %1 blev ikke sikkerhedskopieret',
    'backup__domain_session_restore_failed' => 'Domænet %1 blev ikke gendannet.',
    'backup__client_session_restore_failed' => 'Kundekontoen %1 blev ikke gendannet.',
    'backup__domain_session_complete' => 'Domænet %1 blev sikkerhedskopieret',
    'backup__domain_session_backup' => 'Sikkerhedskopiering af domænet %1',
    'backup__client_session_backup' => 'Sikkerhedskopiering af kunden %1',
    'backup__domain_stop_title' => 'Annullerer sikkerhedskopiering af domænet %1',
    'backup__client_stop_title' => 'Annullerer sikkerhedskopiering af kundekontoen %1',
    'backup__domain_restore_stop_title' => 'Annullerer gendannelse af domænet %1',
    'backup__client_restore_stop_title' => 'Annullerer gendannelse af kundekontoen %1',
    'backup__domain_session_backup_stop' => 'Du er ved at annullere den aktive sikkerhedskopieringsproces. Der kunne ikke oprettes en sikkerhedskopifil.',
    'backup__backup_stop_confirm' => 'Ja, jeg vil stoppe sikkerhedskopieringsprocessen.',
    'backup__restore_stop_confirm' => 'Ja, jeg vil stoppe gendannelsesprocessen.',
    'backup__domain_session_restore' => 'Gendannelse af domænet %1',
    'backup__domain_session_restore_stop' => 'Du er ved at annullere den aktive gendannelsesproces.',
    'backup__domain_backup_file_info' => 'Domæne-sikkerhedskopifil information',
    'backup__domain_backup_file_list' => 'eksisterende sikkerhedskopifiler',
    'backup__domain_backup_progress' => 'Forløb af sikkerhedskopiering af webstedet %1',
    'backup__domain_restore_progress' => 'Forløb af gendannelse af webstedet %1',
    'backup__domain_backup_progress_elapsed_time' => 'Tidsforbrug: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Tidsforbrug: %1',
    'backup__domain_restore_session_complete' => 'Domænet %1 er gendannet.',
    'backup__domain_restore_session_complete_message' => 'Domænet %1 blev gendannet.',
    'backup__domain_backup_file_delete' => 'Følgende sikkerhedskopifiler vil blive fjernet:',
    'backup__domain_backup_file_for_remove' => 'Vælg de sikkerhedskopifiler du vil fjerne.',
    'backup__backup_overwrite_file_confirm' => 'Udskiftningsbekræftelse',
    'backup__backup_overwrite_file_confirm_text' => 'Der findes allerede en sikkerhedskopi-fil med navnet "%1". Vil du erstatte den?',
    'backup__backup_confirm_overwrite' => 'Bekræft fil-download',
    'backup__backup_overwrite_legeng' => 'Erstat',
    'backup__backup_not_contain_domain' => 'Sikkerhedskopi-filen indeholder ikke oplysninger om domænet %1',
    'backup__backup_not_contain_client' => 'Sikkerhedskopi-filen indeholder ikke oplysninger om kundekontoen %1',
    'backup__backup_client_info' => "Sikkerhedskopiér kundens indstillinger og kontooplysninger",
    'backup__client_backup_progress' => 'Forløb af sikkerhedskopiering af kundekonto %1',
    'backup__client_session_complete' => 'Kundekontoen %1 bliver sikkerhedskopieret',
    'backup__client_backup_file_info' => 'Kunde-sikkerhedskopifil information',
    'backup__restore_client_info' => "Gendan kundens indstillinger og kontooplysninger",
    'backup__client_session_restore' => 'Gendanner kundekonto %1',
    'backup__client_db_server_map' => 'Databaseserver-tilknytning',
    'backup__domain_db_server_map' => 'Databaseserver-tilknytning',
    'backup__client_restore_session_complete_message' => 'Kundekontoen %1 blev gendannet.',
    'backup__client_restore_session_complete' => 'Kundekontoen %1 blev gendannet.',
    'backup__restore_select_some' => 'Vælg de objekter, du vil gendanne.',
    'backup__client_restore_progress' => 'Gendannelsesforløb for kundekonto %1',
    'backup__new_backup' => 'Opretter ny sikkerhedskopi',
    'backup__done' => 'Færdig:',
    'backup__done_domains' => '%1 domæne(r) af %2',
    'backup__done_clients' => '%1 kunde(r) af %2',
    'backup__remaining' => 'Resterende:',
    'backup__remaining_domains' => '%1 domæne(r)',
    'backup__remaining_clients' => '%1 kunde(r)',
    'backup__overall_backup_progress' => 'Samlet sikkerhedskopieringsstatus',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => 'Kommandoen "%1" ignoreres',
    'backup__no_objects' => 'Der er ingen objekter til sikkerhedskopiering.',
    'backup__cli_warning_not_enough_ip' => 'ADVARSEL: Ikke IP-adresser nok til at udføre standard IP-tilknytning:',
    'backup__local_repository' => "Plesk's opbevaringsområde",
    'backup__ftp_repository' => 'FTP-lagring',
    'backup__ftp_login' => 'Brugernavn',
    'backup__ftp_password' => 'Adgangskode',
    'backup__ftp_account_settings' => 'FTP-konto indstillinger',
    'backup__ftp_account_preferences' => 'FTP-konto indstillinger',
    'backup__repository_not_exist' => 'Mappen findes ikke.',
    'backup__repository_not_readable' => 'Den angivne mappe kan ikke læses.',
    'backup__ftp_repository_not_configure' => 'For at kunne bruge et FTP sikkerhedskopi-opbevaringsområde, <a href="%1">skal du først angive FTP-kontoen. </a>',
    'backup__ftp_repository_list_not_configure' => 'Kontoindstillinger blev ikke angivet',
    'backup__repository_list_unable_listing' => 'Kunne ikke hente filliste',
    'backup__ftp_repository_unable_listing' => 'Kunne ikke hente en liste over mappen "%1".',
    'backup__repository_legend' => 'Sikkerhedsfil-opbevaringsområde',
    'backup__store_in_repository' => 'Gem filer i',
    'backup__local_repository_lable' => 'Lokalt opbevaringsområde',
    'backup__ftp_repository_lable' => 'FTP-lagring',
    'backup__ftp_repository_not_configure_hint' => '(kontoindstillinger er ikke angivet)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-konto er ikke angivet eller ikke understøttet)',
    'backup__other_user_process_modified' => 'En anden bruger har standset sikkerhedskopierings- eller migreringsprocessen.',
    'backup__another_user_exist' => 'Den igangværende handling blev igangsat af en anden Plesk-bruger. Denne bruger er stadig logget på Plesk.',
    'backup__ftp_repository_wait' => 'Vent mens information om FTP-opbevaringsområdet hentes',
    'backup__ftp_write_test_failed' => 'Kunne ikke skrive testdata til FTP-kontoen %1:',
    'backup__ftp_storage' => 'FTP(S)-lagring',
    'bt_upload_to_repository' => 'Upload filer til lokalt opbevaringsområde',
    'bt_new_restore' => "Gendan",
    'bt_backup_schedule' => "Planlæg sikkerhedskopiering",
    'backup_exist_backups' => "Eksisterende sikkerhedskopifiler",
    'backup_dialog__page_title' => "Oprettelse af sikkerhedskopifil",
    'backup_dialog__please_wait' => "Sikkerhedskopieringsprocessen skal til at begynde. Denne handling kan tage et stykke tid. Vent venligst...",
    'backup_conf__page_title' => 'Konfiguration af sikkerhedskopiering',
    'bt_accept' => "Acceptere",
    'bt_access' => "Adgang",
    'bt_action_log' => "Handlingslog",
    'bt_add' => "Tilføj",
    'bt_add_client' => "Knyt til brugere",
    'bt_database_server_add' => 'Tilføj databaseserver',
    'bt_add_services' => "Tilføj ydelser",
    'bt_anonftp_stats' => "Anon.FTP Stat",
    'bt_anonymous_ftp' => "Anonym FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Vedhæft",
    'bt_autoinstaller' => 'Opdater',
    'bt_auto-updates' => 'Opdater',
    'bt_back' => "<< Tilbage",
    'bt_backup' => "Sikkerhedskopier",
    'bt_backup_configure' => "Indstillinger for sikkerhedskopiering",
    'bt_buy_certs' => "Køb certifikater",
    'bt_card' => "Kort",
    'bt_cert' => "Certifikat",
    'bt_certificates' => "Certifikater",
    'bt_change_passwd' => "Skift adgangskode",
    'bt_clear' => "Ryd",
    'bt_client_templates' => "Debitorskabeloner",
    'bt_clients' => "Kunder",
    'bt_codepage_change' => 'Skift kodning',
    'bt_comp_info' => "Administration af komponenter",
    'bt_configure_maillists' => "Sæt Mailman op",
    'bt_configure' => 'Konfigurer',
    'bt_copy' => "Kopier",
    'bt_copy_move' => "Kopiér/Flyt",
    'bt_create' => "Opret",
    'bt_create_account' => "Opret en konto",
    'bt_create_dir' => "Tilføj et bibliotek",
    'bt_create_file' => "Tilføj en fil",
    'bt_count_size' => "Beregn størrelse",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Opgavestyring",
    'bt_custom_button_new' => "Tilføje en knap",
    'bt_custom_buttons' => "Brugerdefinerede knapper",
    'bt_customize' => "Tilpas",
    'bt_databases' => "Databaser",
    'bt_database_servers' => 'Databaseservere',
    'bt_sqlservers' => "Databaseservere",
    'bt_db_usr_new' => "Tilføj en databasebruger",
    'bt_db_new' => "Tilføj en database",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Gør til standard for DB webadmin",
    'bt_decline' => "Afvis",
    'bt_default' => "Standard",
    'bt_defaultcomponents' => "Tredjeparts-services",
    'bt_defaults' => "Standarder",
    'bt_delete' => "Slet",
    'bt_directories' => "Beskyttede biblioteker",
    'bt_disable' => "Slå fra",
    'bt_dns_zone_sync' => 'Anvend DNS-skabelonændringer',
    'bt_dnsrecord_add' => 'Tilføj post',
    'bt_do_backup' => "Sikkerhedskopier",
    'bt_do_restore' => "Gendan",
    'bt_do_upload' => "Overfør",
    'bt_domain_aliases' => "Domænealiasser",
    'bt_domain_templates' => "Domæneskabeloner",
    'bt_domain_user' => "Domæneadministrator",
    'bt_domain_user_passwd' => "Domæneadministrator-adgangskode",
    'bt_domains' => "Domæner",
    'bt_domain_alias_add' => 'Tilføj domænealias',
    'bt_download' => "Download",
    'bt_edit' => "Rediger",
    'bt_enable' => "Slå til",
    'bt_export' => 'Eksporter',
    'bt_extras' => "Ekstra",
    'bt_finish' => "Afslut",
    'bt_ftp_account' => "Egenskaber for FTP-konto",
    'bt_forget_password' => "Glemt adgangskode?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP-statistik",
    'bt_get_password' => "Hent adgangskode",
    'bt_global_changes' => "Ret",
    'bt_help' => "Hjælp",
    'bt_hide_aliases' => "Skjul aliasser.",
    'bt_hide_toolbar' => 'Skjul værktøjslinje',
    'bt_hide_subdomains' => "Skjul subdomæner",
    'bt_hide_domainaliases' => "Skjul domænealiasser",
    'bt_home' => "Forside",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Installer",
    'bt_ip_aliasing' => "IP-adresser",
    'bt_ip_add' => "Tilføj IP-adresse",
    'bt_ip_pool' => "IP-pulje",
    'bt_key_info' => "Information om licens",
    'bt_key_buyonline_addons' => 'Bestil Plesk-tilføjelser.',
    'bt_key_buyonline_upgrades' => 'Bestil Plesk-opgraderinger.',
    'bt_key_buyonline_new' => 'Bestil ny nøgle',
    'bt_limits' => "Begrænsninger",
    'bt_locale_add' => 'Tilføj Locale',
    'bt_locales' => 'Localer',
    'bt_log_manager' => "Log-administrator",
    'bt_login' => "Log på",
    'bt_logo' => "Branding",
    'bt_logo_send_link' => "Tilknyt link",
    'bt_logo_send_logo' => "Tilknyt logo",
    'bt_logout' => "Log af",
    'bt_logrotation' => "Log-rotation",
    'bt_mail' => "E-mail",
    'bt_mail_alias_add' => "Tilføj e-mail alias",
    'bt_mail_aliases' => "E-mail aliasser",
    'bt_mail_group_add' => "Tilføj medlem",
    'bt_mail_groups' => "Grupper",
    'bt_mail_name_add' => "Tilføj e-mail-konto",
    'bt_mail_preferences' => "Indstillinger",
    'bt_mail_group' => "Mailgruppe",
    'bt_mail_mailbox' => "Mailboks",
    'bt_mail_redirect' => "Videresendelse",
    'bt_mail_resp_add' => "Tilføj autosvar",
    'bt_mail_resp_attach_add' => "Tilføj vedhæftet fil",
    'bt_mail_resp_files' => "Bilagsfiler",
    'bt_mail_responders' => "Autosvar",
    'bt_mail_spamfilter' => "Spamfilter",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Tilføj mailingliste",
    'bt_maillists' => "Mailinglister",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Sikkerhedskopiering",
    'bt_manage' => "Administrer",
    'bt_master' => "Master",
    'bt_migrate' => 'Migrer',
    'bt_modules_add' => 'Tilføj filtypenavne',
    'bt_modules_manage' => 'Administrér udvidelser',
    'bt_move' => "Flyt",
    'bt_mimetypes' => 'MIME-typer',
    'bt_mimetype_new' => 'Tilføj MIME-type',
    'bt_new_client' => "Tilføj kundekonto",
    'bt_new_domain' => "Tilføj domæne",
    'bt_next' => "Næste >>",
    'bt_next_page' => "Næste",
    'bt_network_add' => "Tilføj netværk",
    'bt_notifications' => "Notificeringer",
    'bt_off' => "Deaktiveret",
    'bt_on' => "Aktiveret",
    'bt_on_off' => "Aktiveret/Deaktiveret",
    'bt_pd_new' => "Tilføj beskyttet bibliotek",
    'bt_pd_user_new' => "Tilføj bruger",
    'bt_performance' => 'Ydelse',
    'bt_permissions' => "Rettigheder",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Indstillinger",
    'bt_prev_page' => "Forr",
    'bt_preview' => 'Webstedseksempel',
    'bt_print' => "Udskriv",
    'bt_reboot' => "Genstart",
    'bt_reload' => "Indlæs igen",
    'bt_refresh' => "Opdater",
    'bt_register' => "Registrer",
    'bt_remove' => "Fjern",
    'bt_enable_selected' => 'Slå til',
    'bt_disable_selected' => 'Slå fra',
    'bt_repair_ip' => "Reparations-IP",
    'bt_report' => "Rapport",
    'bt_report_new' => "Tilføj layout",
    'bt_reset' => "Nulstil",
    'bt_restart_services' => "Serviceadministration",
    'bt_save' => "Gem",
    'bt_send_by_email' => "Send via e-mail",
    'bt_send_file' => "Send fil",
    'bt_send_mail' => "Send e-mail",
    'bt_send_passwd' => "Send adgangskode",
    'bt_send_text' => "Send tekst",
    'bt_server' => "Server",
    'bt_server_add' => "Tilføj server",
    'bt_server_preferences' => "Serverindstillinger",
    'bt_servers_list' => "Servere",
    'bt_sessions' => "Sessioner",
    'bt_set' => "Indstil",
    'bt_set_as_default' => "Angiv som standard",
    'bt_setup' => 'Opsætning',
    'bt_show_aliases' => "Vis aliasser.",
    'bt_show_subdomains' => "Vis underdomæner",
    'bt_show_domainaliases' => "Vis domænealiasser",
    'bt_shutdown' => "Luk ned",
    'bt_site_apppkgs' => "Applikations-vault",
    'bt_site_apppool' => "Applikationspulje",
    'bt_application-pool' => "Web-applikationer",
    'bt_site_apps' => "Web-applikationer",
    'bt_site_app_add' => "Installer applikation",
    'bt_site_builder' => "Understøttelse af Presence Builder",
    'bt_skeleton' => 'Skabelon til Virtuel host',
    'bt_skins' => 'Tema',
    'bt_skin_add' => 'Tilføj tema',
    'bt_skin_manual' => 'Brugerdefineret Plesk-tema reference', // not used
    'bt_skin_download' => 'Download tema',
    'bt_skin_replace' => 'Opdatér tema',
    'bt_skip' => 'Spring over',
    'bt_spamassassin' => "Spamfilter",
    'bt_spamassassin_train' => "Undervisning",
    'bt_spamfilter' => "Spamfilter",
    'bt_start' => "Start",
    'bt_stop' => "Stop",
    'bt_recycle' => "Genbrug",
    'bt_statistics' => "Statistik",
    'bt_subdomain_new' => "Tilføj underdomæne",
    'bt_subdomains' => "Subdomæner",
    'bt_submit' => "Gem",
    'bt_summary_report' => "Oversigtsrapport",
    'bt_support' => "Support",
    'bt_switch' => "Skift",
    'bt_system_time' => "Systemklokkeslæt",
    'bt_task_new' => "Tilføj opgave",
    'bt_dom_tmpl_add' => 'Tilføj domæneskabelon',
    'bt_cl_tmpl_add' => 'Tilføj kundeskabelon',
    'bt_cron_backup' => 'Planlagte sikkerhedskopieringsindstillinger',
    'bt_test' => "Testforbindelse",
    'bt_text' => "Tekst",
    'bt_touch' => "Redigér tidsmærke",
    'bt_traffic' => "Trafik",
    'bt_traffic_history' => "Trafikhistorik",
    'bt_update' => "Opdatering",
    'bt_upload' => "Overfør",
    'bt_upload_from_ftp' => "FTP-upload",
    'bt_virtualdirs' => 'Virtuelle mapper',
    'bt_virtualdir_new' => 'Tilføj virtuel mappe',
    'bt_virtualdir_add' => 'Tilføj virtuel mappe',
    'bt_web_app_new' => "Installer Java-program",
    'bt_web_stats' => "Web Stat",
    'bt_web_stats_ssl' => "Web Stat SSL/TLS",
    'bt_web_user_add' => "Tilføj webbruger",
    'bt_web_users' => "Webbrugere",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Se den fulde liste over ændringer",
    'cert_add__unable_set_ca_cert' => "Kunne ikke opsætte CA-certifikatet: %1",
    'cert_add__unable_set_cert' => "Kunne ikke opsætte certifikatet: %1",
    'cert_add__unable_set_private_key' => "Kunne ikke opsætte den private nøgle: %1",
    'certificates_list__certificate_used_as_default' => "et af de certifikater, du er ved at slette, bruges som standardcertifikat.",
    'certificates_list__certificates_assigned_on_ip' => "et eller flere certifikater er knyttet til IP-adresser/domæner.",
    'ch_pass__admin_pass' => "Skift administrators adgangskode",
    'ch_pass__old_pass' => "Gammel adgangskode",
    'ch_pass__pass_confirm' => "Bekræft",
    'ch_pass__unable_change_admin_pass' => "Kunne ikke ændre administratorens adgangskode: %1",
    'check_mail_cycle__aliases' => "E-mail-cycling blev fundet. Adressen \"%1\" er indeholdt i autosvar for denne e-mailkonto.",
    'check_mail_cycle__autoresponders' => "E-mail-cycling blev fundet. Adressen \"%1\" er indeholdt i autosvar for denne e-mailkonto.",
    'check_mail_cycle__mail_groups' => "E-mail-cycling blev fundet. Adressen \"%1\" er indeholdt i mailgruppen for denne e-mailkonto.",
    'check_mail_cycle__mail_name' => "E-mail-cycling blev fundet. Adressen \"%1\" er den samme som denne e-mailkonto.",
    'check_mail_cycle__redirect' => "E-mail-cycling blev fundet. Adressen \"%1\" er den samme som videresendelsesadressen for denne e-mailkonto.",
    'check_mail_dup__redirect' => "Dublet-.videresendelse blev fundet. Adressen \"%1\" er den samme som videresendelsesadressen for denne e-mailkonto.",
    'check_mail_dup__mail_groups' => "Dublet-videresendelse blev fundet. Adressen \"%1\" er indeholdt i mailgruppen for denne e-mailkonto.",
    'check_maillist_cycle__admin' => "E-mail-cycling blev fundet. Administratorens e-mail \"%1\" er den samme som adressen på en mailingliste.",
    'check_maillist_cycle__member' => "E-mail-cycling blev fundet. Adressen \"%1\" er den samme som adressen på en mailingliste.",
    'chk_js__enter_login_and_passwd' => "Indtast et brugernavn og en adgangskode",
    'chk_js__enter_login_name' => "Indtast brugernavn.",
    'chk_js__enter_passwd' => "Skriv adgangskoden",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1's kontooplysninger",
    'cl_limits__cl' => "Kunden %1's grænser",
    'cl_logo__setup_logo_pref' => "Indstil logo-egenskaber for kunden %1",
    'cl_new__enter_new_cl_data' => "Indtast information om ny kunde",
    'cl_new__unable_to_sent_notification' => 'Brugerkontoen blev oprettet, men afsendelse af en besked til kunden mislykkedes: %1',
    'cl_perm__all_ip' => "All IP'er til rådighed",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Alle IP-baserede hostingkonti for kunder vil blive overført til at være navnebaserede.",
    'cl_perm__allow_client_create_domain' => "De felter, du prøver at markere, er kun gældende for kunder, der har tilladelse til at oprette domæner.",
    'cl_perm__allow_create_nb_w_ip' => "Kunder kan oprette navnebaseret hosting vha. %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Tillad oprettelse af IP-baserede hostingkonti",
    'cl_perm__available_ips' => "IP'er til rådighed",
    'cl_perm__change_limits' => "Justering af grænser",
    'cl_perm__cl_disk_space' => "Total diskplads til rådighed",
    'cl_perm__cl_expiration' => "Kundekonto-validitetsperiode",
    'cl_perm__cl_max_box' => "Mailbokse",
    'cl_perm__cl_max_db' => "Databaser",
    'cl_perm__cl_max_dom' => "Domæner",
    'cl_perm__cl_max_maillists' => "Mailing Lists",
    'cl_perm__cl_max_subdom' => "Subdomæner",
    'cl_perm__cl_max_traffic' => "Total mængde trafik til rådighed",
    'cl_perm__cl_max_wu' => "Webbrugere",
    'cl_perm__cl_mbox_quota' => "Mailboks-størrelsesbegrænsning for denne brugerkonto",
    'cl_perm__current_maximum_exp_date' => "Den nuværende maksimumværdi for domæne-validitetsperioden er %1; der er anmodet om %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Den nuværende definerede grænse for mængden af reserveret diskplads til mailbokse under denne brugerkonto er %1; der er anmodet om %2",
    'cl_perm__current_total_requested' => "Den nuværende maksimumværdi for %1 er %2; der er anmodet om %3.",
    'cl_perm__current_total_requested_dom' => "Antallet af %1 der hører til denne kunde er %2; der er anmodet om %3.",
    'cl_perm__disk_space' => "maksimal mængde diskplads",
    'cl_perm__dashboard_stdgui' => 'Brugergrænseflade',
    'cl_perm__dashboard' => 'Startsidevisning',
    'cl_perm__stdgui' => 'Standardvisning',
    'cl_perm__manage_dashboard' => 'Administration af startside',
    'cl_perm__dashboard_and_stdgui' => 'Startsidevisning og standardvisning er tilladt',
    'cl_perm__dashboard_only' => 'Kun Startsidevisning er tilladt',
    'cl_perm__stdgui_only' => 'Kun standardvisning er tilladt',
    'cl_perm__edit_cl' => "Kunden %1's tilladelser",
    'cl_perm__exp_date_exceeded' => "Validitetsperioden du prøver at indstille overskrider den grænse, der er angivet for de individuelle domæner der relaterer til denne kunde.",
    'cl_perm__invalid_value' => "Ugyldig værdi. Kun cifre er tilladt.",
    'cl_perm__limit_disk_space' => "%1 Begræns den totale mængde diskplads",
    'cl_perm__limit_expiration' => "%1 Begræns validitetsperioden for kundekontoen",
    'cl_perm__limit_max_box' => "%1 Begræns det maksimale antal mailbokse",
    'cl_perm__limit_max_db' => "%1 Begræns det maksimale antal databaser",
    'cl_perm__limit_max_dom' => "%1 Begræns det maksimale antal domæner",
    'cl_perm__limit_max_maillists' => "%1 Begræns det maksimale antal maillister",
    'cl_perm__limit_max_subdom' => "%1 Begræns det maksimale antal underdomæner",
    'cl_perm__limit_max_traffic' => "%1 Begræns den totale mængde trafik",
    'cl_perm__limit_max_wu' => "%1 Begræns det maksimale antal webbrugere",
    'cl_perm__limit_mbox_quota' => "%1 Indstil mailbokskvoten",
    'cl_perm__limits_exceeded' => "Validitetsperioden du prøver at indstille overskrider den grænse, der er angivet for de individuelle domæner der hører til denne kunde. \nDen totale grænse for kunden skal være mere end eller lig med den totale sum af de domænegrænser, der er defineret for denne kundekonto.",
    'cl_perm__mailbox_quota_exceeded' => "Den grænse for mængden af diskplads der reserveres til mailbokse, som du forsøger at indstille, overstiger den grænse der er defineret i de individuelle domæner der relaterer til denne kundekonto.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Den grænse for mængden af diskplads der reserveres til mailbokse, som du forsøger at indstille, overstiger den grænse der er pålagt på serverniveau.",
    'cl_perm__make_dumps' => "Sikkerhedskopiér og gendan data",

    'cl_perm__max_box' => "maksimalt antal mailbokse",
    'cl_perm__max_db' => "maksimalt antal databaser",
    'cl_perm__max_dom' => "domæner",
    'cl_perm__max_maillists' => "maksimalt antal mailinglister",
    'cl_perm__max_subdom' => "subdomæner",
    'cl_perm__max_traffic' => "maksimal trafikmængde",
    'cl_perm__max_wu' => "maksimalt antal web-brugere",
    'cl_perm__max_dom_aliases' => "domænealiasser",
    'cl_perm__mbox_quota' => "mailbokskvote",
    'cl_perm__not_allow_create_nb_hst' => "Kunden kan oprette navnebaseret hosting",
    'cl_perm__this_ip_used_vrt_hst' => "Denne IP-adresse bruges af virtuel hosting. \nhvis du vil slette denne IP-adresse, skal du fjerne hostingservice eller ændre dens type til navnebaseret.",
    'cl_perm__unable_off_ipb_creating' => "Kunden har allerede IP-baseret hostingservice sat op. Du kan deaktivere denne funktion for kunden ved at rydde afkrydsningsfeltet \"Domæneoprettelse\" eller fjerne alle IP-baserede hostingkonti.",
    'cl_perm__unable_off_nb_creating' => "Kunden har allerede navnebaseret hostingservice sat op. Du kan deaktivere denne funktion for kunden ved at rydde afkrydsningsfeltet \"Domæneoprettelse\" eller fjerne alle navnebaserede hostingkonti.",
    'cl_perm__unable_set_domain_limit' => "Kunne ikke begrænse det maksimale antal domæner: Kunden har allerede %1 domæner",
    'cl_perm__unable_update_client_limitations' => "Kunne ikke definere grænserne for kundekontoen: %1",
    'cl_pref__edit_cl' => "Kunde %1's indstillinger",
    'class_anonftp__create_ftp_domain' => "Intet virtuelt FTP-domæne for dette dom_id, prøv at oprette det først.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Den diskpladsgrænse, du prøver at indstille (%1), bør ikke overskride den totale diskpladsgrænse, defineret på domæneniveauet (%2).",
    'class_anonftp__invalid_input_only_digits' => "Ugyldig værdi. Kun cifre er tilladt.",
    'class_anonftp__unable_change_ownerships' => "Kunne ikke ændre ejerskab eller rettigheder for kvotefilen: %1",
    'class_anonftp__unable_copy_quota_file' => "Kunne ikke kopiere kvotefilen: %1",
    'class_anonftp__unable_get_disk_usage' => "Kunne ikke hente diskforbrugs-information for den indkommende mappe: %1",
    'class_anonftp__unable_parse_quota_file' => "Kunne ikke fortolke kvotefilen.",
    'class_anonftp__unable_read_quota_file' => "Kunne ikke læse kvotefilen: %1",
    'class_anonftp__unable_update_quota' => "Kunne ikke opdatere kvoten: Filerne i den indkommende mappe bruger %1 KB diskplads, hvilket overskrider den nye kvoteværdi.",
    'class_anonftp__unable_write_temp_file' => "Kunne ikke skrive til den midlertidige fil: %1",
    'class_bsdomain__warn_max_date__' => "Udløbsdatoen blev indstillet til %1",
    'class_cList__empty' => "Ingen elementer.",
    'class_cList__header' => "%1 [%2]",
    'class_cList__not_found' => "ingen matches fundet for <b>\"%1\"</b> i %2 (%3 af %4).",
    'class_cList__search_result' => "Søgeresultater for <b>\"%1\"</b> in %2 (%3 af %4).",
    'class_client__client_creation_notification' => "Kundeoprettelsesadvisering.",
    'class_client__client_with_contact_name_already_exists' => "Der findes allerede en kunde med navnet %1.",
    'class_client__disk_space' => "Diskplads",
    'class_client__invalid_max_dom' => "Ugyldig værdi for antal domæner. Kun cifre er tilladt.",
    'class_client__limit_exceed' => "Den anmodede mængde på %1 kan ikke reserveres, da dette ville overskride tildelingen til kunden %2's konto (%3). Hvis du vil tildele flere ressourcer, kan dette ske via Kunder > Kundenavn > Grænser, hvor du kan ændre tildelingen efter behov. Ved derefter tilbage til dette skærmbillede og prøv at justere tildelingen igen.",
    'class_client__limit_exceed_unlimited' => "Hvis du vil tildele en ubegrænset mængde ressourcer (%1), skal du først åbne Kunde > Kundenavn > Grænser, og markere afkrydsningsfeltet Ubegrænset ud for den ønskede ressourcetype. Ved derefter tilbage til dette skærmbillede og prøv at justere tildelingen igen.",
    'class_client__max_box' => "Mailbokse",
    'class_client__max_db' => "Databaser",
    'class_client__max_maillists' => "Mailing Lists",
    'class_client__max_subdom' => "Subdomæner",
    'class_client__max_traffic' => "Maksimal trafik",
    'class_client__max_wu' => "Webbrugere",
    'class_client__max_dom_aliases' => "Domænealiasser",
    'class_client__mbox_quota' => "Mailbokskvote",
    'class_client__unable_define_cl_status' => "Kunne ikke definere status for kundekontoen: %1",
    'class_client__unable_define_inactive_dom' => "Kunne ikke definere inaktive domæner %1.",
    'class_client__unable_del_ip' => "Kunne ikke fjerne IP'er: %1",
    'class_db__db_name_not_set' => "Databasenavnet er ikke defineret.",
    'class_db__db_not_exist_for_curr_dom' => "Databasen findes ikke for dette domæne.",
    'class_db__invalid_db_or_dom_name' => "Domænet eller database-ID er ugyldigt, eller databasenavnet er ikke defineret.",
    'class_db__invalid_pass' => "Adgangskoden er ugyldig.",
    'class_db__mailgrp_member_exist' => "E-mailgruppemedlem findes allerede",
    'class_db__access_hosts_notsupport' => 'Adgang til host-indstillinger understøttes ikke for denne databasetype.',
    'class_db__unable_add' => 'Kunne ikke tilføje adgangs-host post: %1',
    'class_db__unable_del' => 'Kunne ikke slette adgangs-host post: %1',
    'class_db__inc_user_not_exist' => 'Databasebrugeren "%1" findes ikke.',
    'class_db__inc_access_record_exist' => 'Denne adgangspost findes allerede',
    'class_db__inc_access_record_not_exist' => 'Given adgangspost findes ikke.',
    'class_db__inc_unable_del_last_record' => 'Kunne ikke slette den seneste adgangspost.',
    'class_domtmpleditform__dns_master' => "Primær",
    'class_domtmpleditform__dns_slave' => "Sekundær",
    'class_domtmpleditform__dns_type' => "Domænets DNS-zonetype",
    'clienttrafficlist_header' => "Trafik på domæner",
    'clienttrafficlist_header_of_client__' => "Trafik på domænerne tilhørende kunden %1",
    'cmd_dns__a_dns_record_already_exist' => "Denne post vil konflikte med A-posten for zonen.",
    'cmd_dns__domain_last_ns' => 'Kan ikke slette den seneste NS DNS-post for domænet.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kanonisk domænenavn er ugyldigt.",
    'cmd_dns__cname_dns_record_already_exist' => "Denne post vil konflikte med CNAME-posten for zonen.",
    'cmd_dns__cname_in_rr_combination' => 'Forkert kombination af DNS-poster findes i DNS-zonen',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS-zone post kan ikke sameksistere med andre DNS-poster i den samme zone.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS-posttypen er ugyldig.",
    'cmd_dns__ext_host_is_not_resolved' => "Det kanoniske navn %1 er ikke bundet til A eller AAAA post.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Kunne ikke føje %1 posten til zone %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "E-mail Exchange navnet er ugyldigt.",
    'cmd_dns__mx_priority_is_invalid' => "MX-prioriteten er ugyldig.",
    'cmd_dns__name_server_is_invalid' => "Navneserveren er ugyldig.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Netværksmaskeværdien skal være 24, 16 eller 8.",
    'cmd_dns__this_dns_record_already_exists' => "DNS-posten findes allerede.",
    'cmd_dns__unable_add_record' => "Kunne ikke tilføje '%1' post: %2",
    'cmd_dns__unable_add_a_record' => "Kunne ikke tilføje en A-post: %1",
    'cmd_dns__unable_add_cname_record' => "Kunne ikke tilføje en CNAME-post: %1",
    'cmd_dns__unable_add_dns_record' => "Kunne ikke tilføje en DNS-post: %1",
    'cmd_dns__unable_add_ext_ns_record' => "Kunne ikke tilføje en EXT_NS-post: %1",
    'cmd_dns__unable_add_ns_record' => "Kunne ikke tilføje en NS-post: %1",
    'cmd_dns__unable_add_ptr_record' => "Kunne ikke tilføje en PTR-post: %1",
    'cmd_dns__unable_add_txt_record' => "Kunne ikke tilføje en TXT-post: %1",
    'cmd_dns__unable_create_dns_zone' => "Kunne ikke oprette DNS-zonen: %1",
    'cmd_dns__unable_define_dns_record' => "Kunne ikke definere DNS-posten: %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Kunne ikke hente standard DNS-zonestatus: %1",
    'cmd_dns__unable_insert_a_record' => "Kunne ikke indsætte A-post: %1",
    'cmd_dns__unable_insert_mx_record' => "Kunne ikke indsætte MX-post: %1",
    'cmd_dns__unable_insert_ns_record' => "Kunne ikke indsætte NS-post: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Kunne ikke indstille DNS-zonestatus: %1",
    'cmd_domains__dom_already_exists' => "Domænet %1 findes allerede.",
    'cmd_domains__dns_record_already_exists' => "Kunne ikke oprette domænet %1, fordi en DNS-post, som peger på host'en %1 allerede findes.",
    'cmd_domains__dom_already_exists1' => "Der er %2 underdomæner på dette domæne. Domænet %1 findes allerede.",
    'cmd_domains__dom_already_exists2' => "underdomænet %1 findes allerede.",
    'cmd_domains__dalias_already_exists' => "Dette alias findes allerede",
    'cmd_domains__domain_alias_already_exists' => 'Et domænealias med et sådant navn findes allerede.',
    'cmd_domains__unable_del_mail_for_dom' => "Kunne ikke slette e-mail services for domænet: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Kunne ikke slette anonym FTP-konto for domænet: %1",
    'cmd_domains__unable_update_dom_param' => "Kunne ikke opdatere domæneparametrene: %1.",
    'cmd_domains__unable_rename_client_exist' => "domæneadministratorens brugernavn er allerede i brug.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Hostingtypen er ikke fysisk.",
    'cmd_hosting__unable_create_user' => "Kunne ikke oprette bruger %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Kunne ikke definere IP-adresser til de navnebaserede virtuelle hosts: %1",
    'cmd_hosting__unable_del_old_hst' => "Kunne ikke slette den tidligere opsatte hosting: %1",
    'cmd_hosting__unable_del_protected_directory' => "Kunne ikke slette den beskytte mappe: %1",
    'cmd_hosting__unable_del_web_user' => "Kunne ikke slette den webbrugeren: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Kunne ikke oprette eller opdatere den virtuelle host: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Kunne ikke opsætte ramme-videresendelseshosting.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Kunne ikke genopbygge proftpd-konfigurationsfilen: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Kunne ikke opsætte SSL/TLS: %1",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Kunne ikke fjerne beskyttelse fra SSL/TLS-mappen: %1",
    'cmd_hosting__unable_update_dest_url' => "Kunne ikke opdatere destinations-URL: %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Kunne ikke opdatere DNS-zone for domænet: værktøjsafvikling mislykkedes.",
    'cmd_hosting__unable_update_ftp_passwd' => "Kunne ikke opdatere FTP-adgangskode: %1",
    'cmd_hosting__unable_update_user' => "Kunne ikke opdatere bruger %2: %1",
    'cmd_hosting__unknown_hst_type' => "Ukendt hostingtype",
    'cmd_hosting__you_not_have_permission_del_hst' => "Du har ikke tilladelse til at afslutte hosting-service.",
    'cmd_mail__autoresponder__not_configured' => "Autosvar for denne e-mail konto er ikke konfigureret",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adresse %1 bruges allerede til videresendelse af e-mail.",
    'cmd_mail__alias_already_exists' => "alias findes allerede",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Autosvar ID og e-mail konto-ID stemmer ikke overens.",
    'cmd_mail__autoresp_id_is_undefined' => "Autosvar-ID er ikke defineret",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Et e-mail alias med dette navn findes allerede på e-mail kontoen %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "E-mailkontoen %1 abonnerer allerede på denne mailingliste.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "E-mailkontoen %1 findes allerede i domænet.",
    'cmd_mail__mail_name_not_exist' => "E-mail kontoen findes ikke.",
    'cmd_mail__mail_name_passwd_part' => "Adgangskoden bør ikke indeholde e-mail kontoens navn som en del.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Mailinglisten %1 findes allerede på dette domæne.",
    'cmd_mail__mailname_already_exist_in_mg' => "E-mailkontoen %1 er allerede i en e-mail gruppe.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "E-mailkontoen %1 findes allerede i domænet.",
    'cmd_mail__mailname_already_exists' => "E-mailkontoen findes allerede.",
    'cmd_mail__mailname_is_invalid' => "E-mailkontonavnet %1 er ugyldigt.",
    'cmd_mail__mailname_unable_update' => "Kunne ikke opdatere e-mail kontoen egenskaber.",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Det maksimale antal autosvar blev nået for dette domæne.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Det maksimale antal e-mail grupper blev nået for dette domæne.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Det maksimale antal videresendelser blev nået for dette domæne.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Det maksimale antal mailbokse blev nået.",
    'cmd_mail__no_members_specified' => "ingen medlemmer angivet.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Adgangskoden er for simpelt. Vælg et andet.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "E-mail-adressen bruges allerede.",
    'cmd_mail__unable_define_autoresp_id' => "Kunne ikke definere autosvar ID %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Kunne ikke ændre e-mail service fra domænet: %1",
    'cmd_mail__unable_del_mail_for_dom' => "Kunne ikke fjerne e-mail service fra domænet: %1",
    'cmd_mail__unable_del_mail_redirection' => "Kunne ikke fjerne e-mail videresendelsesservice %1.",
    'cmd_mail__unable_remove_autoresp' => "Kunne ikke fjerne autosvar: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Kunne ikke fjerne e-mailgruppe medlemmer: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Kunne ikke deaktivere e-mail gruppen: %1",
    'cmd_mail__unable_update_mail_redirect' => "Kunne ikke omkonfigurere e-mail videresendelsesservice %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Størrelsen på den uploadede fil er for stor.",
    'cmd_mail__additionally' => "Yderligere:",
    'cmd_pd__invalid_login' => "Forkert brugernavn.",
    'cmd_pd__this_user_already_exist' => "En sådan bruger findes allerede.",
    'cmd_pd__unable_define_hst_type' => "Kunne ikke definere hostingtype.",
    'cmd_pd__unable_upd_pd_usr' => "Kunne ikke opdatere egenskaber for beskyttet mappe-bruger: %1.",
    'cmd_pd__user_is_undefined' => "Bruger er udefineret.",
    'cmd_server__no_enough_free_disk_space' => "Der er ikke nok diskplads.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "den gamle adgangskode er forkert. Forsøg venligst igen.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "grænsen for det maksimale antal webbrugere er nået for dette domæne",
    'cmd_web_usr__unable_create_user' => "kunne ikke oprettes systembruger: %1.",
    'cmd_web_usr__unable_define_max_web_users_limit' => "kunne ikke definere grænse for maksimalt antal webbrugere: %1",
    'cmd_web_usr__user_already_exists' => "brugeren findes allerede.",
    'cmd_web_usr__web_user_name_is_invalid' => "webbrugernavnet %1 er ugyldigt.",
    'cmd_web_usr__web_user_not_exist' => "webbruger findes ikke.",
    'common_func__exec_bad_argument' => "exec-argument bør ikke indeholde enkelt-anførselstegn.",
    '__eol' => 'Linjeskift',
    'eol__binary_file' => 'Kunne ikke ændre linjeskifttype i binær fil.',
    'cp_access_admin_deny' => "Adgang for administrator fra adressen '%1' er begrænset i overensstemmelse med den i øjeblikket anvendte IP-adgangsbegrænsningspolitik.",
    'create_domain_warn__' => "Følgende undtagelser blev foretaget under domæneoprettelsen:",
    'create_domain__client_select' => 'Vælg den kunde, du vil oprette domænet til',

    'dashboard__nav_button_name' => "Forside",
    'dalias__list_title' => 'Domænealiasser for domænet %1',
    'dalias__list_legend' => 'Domænealiasser',
    'dalias__list_header' => 'Domænealiasser',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Domænets aliasnavn',
    'dalias__list_ascii_name' => 'I ASCII-format',
    'dalias__remove_title' => 'Følgende domænealiasser for domænet %1 vil blive fjernet:',
    'dalias__select_domain_aliases_to_remove' => 'Vælg de domænealiasser der skal fjernes.',
    'dalias__mail_turn_on_failed' => 'Kunne ikke aktivere e-mail service: %1',
    'dalias__web_turn_on_failed' => 'Kunne ikke aktivere webservice: %1',
    'db_usr_edit__db_usr_name_old' => "Gammelt database-brugernavn",
    'database_server_edit_form__cannot_infer_type' => 'Kan ikke udlede forbindelsesmetode fra de angivne data. Angiv "127.0.0.1" som databaseserverværtsnavn for at oprette forbindelse via TCP/IP med den angivne port, eller lad portfeltet være tomt for at bruge Unix-stikket "%1".',
    'database_server_edit_form__duplicate' => 'En databaseserver med denne kombination af host adresse og portnummer er allerede registreret.',
    'database_server_edit_form__host_is_invalid' => 'Det angivne hostnavn er ugyldigt.',
    'database_server_edit_form__port_is_invalid' => 'Det angivne portnummer er ikke gyldigt.',
    'database_server_error__consult_admin' => 'Kontakt serveradministratoren.',
    'database_server_error__last__connection_failed' => 'Det seneste forsøg på at kontrollere denne databaseserver mislykkedes på grund af netværksproblemer.',
    'database_server_error__last__permission_denied' => 'Det seneste forsøg på at kontrollere denne databaseserver mislykkedes fordi en leverede konto ikke har administrative rettigheder.',
    'database_server_error__last__credentials_not_set' => "Det seneste forsøg på forbindelse til denne server mislykkedes, da der ikke blev angivet et gyldigt administrator-brugernavn og adgangskode.",
    'database_server_error__last__other_error' => 'Det seneste forsøg på at kontrollere denne databaseserver mislykkedes.',
    'database_server_error__real__connection_failed' => 'Forbindelse til databaseserveren mislykkedes på grund af netværksproblemer:',
    'database_server_error__real__permission_denied' => 'Forbindelse til databaseserveren mislykkedes fordi en leverede konto ikke har administrative rettigheder.',
    'database_server_error__real__duplicate_object' => 'Forbindelse til databaseserveren mislykkedes på grund af navnesammenfald:',
    'database_server_error__real__unacceptable_name' => 'Forbindelse til databaseserveren mislykkedes på grund af et ugyldigt objektnavn:',
    'database_server_error__real__unacceptable_password' => 'Forbindelse til databaseserveren mislykkedes på grund af en uacceptabel adgangskode:',
    'database_server_error__real__credentials_not_set' => "Plesk kan ikke tilslutte sig databaseserveren fordi gyldigt administrator-brugernavn og adgangskode ikke blev indtastet.",
    'database_server_error__real__other_error' => 'Forbindelsen til databaseserveren mislykkedes.',
    'database_server_error__test__connection_failed' => 'Testforbindelse til databaseserveren mislykkedes på grund af netværksproblemer:',
    'database_server_error__test__permission_denied' => 'Forbindelse til databaseserveren mislykkedes fordi en leverede konto ikke har administrative rettigheder.',
    'database_server_error__test__duplicate_object' => 'Testforbindelse til databaseserveren mislykkedes på grund af navnesammenfald:',
    'database_server_error__test__unacceptable_name' => 'Testforbindelse til databaseserveren mislykkedes på grund af et ugyldigt objektnavn:',
    'database_server_error__test__unacceptable_password' => 'Testforbindelse til databaseserveren mislykkedes på grund af en uacceptabel adgangskode:',
    'database_server_error__test__credentials_not_set' => "Testforbindelsen til denne server mislykkedes, da intet gyldigt administrator-brugernavn og adgangskode blev angivet.",
    'database_server_error__test__other_error' => 'Test af forbindelse til databaseserver mislykkedes:',

    'db__create_new_db' => "Tilføj en database",
    'db__db_add' => "Tilføj database",
    'db__db_for_dom' => "Databaser til webstedet %1",
    'db__db_id_undefined' => "Database-ID er udefineret.",
    'db__db_name' => "Databasenavn",
    'db__db_not_exist' => "Databasen findes ikke.",
    'db__db_type' => "Type",
    'db__db_server' => "Databaseserver",
    'db_server_not_exist' => "Databaseserveren findes ikke.",
    'db__db_user_not_exist' => "Databasebrugeren findes ikke.",
    'db__domain_not_exist' => "Domænet findes ikke.",
    'db__enter_db_name' => "Indtast et nyt databasenavn.",
    'db__invalid_db_id' => "Databaseidentifikator er ugyldig.",
    'db__invalid_db_name' => "Databasenavnet er ugyldigt. Databasenavnet må kun indeholde latinske bogstaver, cifre, understregningssymboler og bindestreger. Det kan ikke være længere end 63 tegn og symboler.",
    'db__max_db_reached_for_dom' => "Grænsen for antal databaser er nået for dette domæne.",
    'db__max_mssql_db_reached_for_dom' => "Grænsen for antal Microsoft SQL-server databaser er nået for dette domæne.",
    'db__postgres_not_connect_for_admin' => "Kunne ikke oprette forbindelse til PostgreSQL. Aktivér PostgreSQL-understøttelse på server-administrationssiden.",
    'db__postgres_not_connect_for_client' => "Kunne ikke oprette forbindelse til PostgreSQL. Bed systemadministratoren om hjælp.",
    'db__remove_db_on_domain' => "Følgende databaser på domænet %2, der ejes af kunden %1, vil blive fjernet:",
    'db__remove_db_on_domain_of_cl' => "Følgende databaser på domænet %2, der ejes af kunden %1, vil blive fjernet:",
    'db__remove_db_linked_resource' => 'Denne database bruges af et webprogram. Den kan kun fjernes efter afinstallering af dette webprogram.',
    'db__remove_db_users' => "Følgende brugere af databasen %3 på domænet %2, der ejes af kunden %1, vil blive fjernet:",
    'db__remove_db_users_of_cl' => "Følgende brugere af databasen %3 på domænet %2, der ejes af kunden %1, vil blive fjernet:",
    'db__select_db_for_remove' => "Vælg de databaser, der skal fjernes.",
    'db__select_db_users_for_remove' => "Vælg de databasebrugere, der skal fjernes.",
    'db__unable_create_db_user' => "Kunne ikke oprette databasebruger: %1.",
    'db__unable_define_db_name' => "Kunne ikke definere databasenavnet: %1.",
    'db__unable_define_db_user' => "Kunne ikke definere databasebruger: %1.",
    'db__unable_define_db_users' => "Kunne ikke definere databasebrugere %1.",
    'db__unable_select_dom_name' => "Kunne ikke vælge domænenavnet: %1",
    'db_edit__db_for_dom' => "Brugere af databasen %1 på domænet %2",
    'db_edit__invalid_db_name' => "Databasens navn er ugyldigt.",
    'db_edit__no_users' => "Der er ingen brugere med akkreditiver til denne database.",
    'db_edit__unable_define_db_usrs' => "Kunne ikke definere databasebrugere: %1.",
    'db_edit__unable_select_db_usr' => "Kunne ikke vælge databasebrugeren.",
    'db_edit__db_user_password_for_' => "Indtast adgangskoden for at logge på som databasebrugeren %1",
    'db_list__tab_title_db_type' => "S",
    'db_usr_edit__add_db_usr' => "Tilføj databasebruger",
    'db_usr_edit__db_usr_name' => "Database brugernavn",
    'db_usr_edit__edit_db_usr' => "Opsæt akkreditiver for database-brugerkonto",
    'db_usr_edit__for_db' => "i %1-database",
    'db_usr_edit__not_create_pass' => "Denne handling vil resultere i oprettelse af en database-brugerkonto uden adgangskode. \nVil du oprette en bruger uden at tildele en adgangskode?",
    'dbuser__only_one_user_can_be_default' => "Kun én bruger kan indstilles som standard.",
    'db_server__cannot_delete_default' => "Standard databaseserveren kan ikke slettes.",
    'db_server__cannot_delete_local' => "Den lokale databaseserver kan ikke slettes.",
    'db_server__cannot_delete_used' => 'En databaseserver kan ikke slettes mens der er databaser eller databasebrugere på den.',
    'demo__disabled_in_demo' => "Denne handling understøttes ikke i demoversionen.",
    'defaultcomponents__title' => "Valg af standardkomponenter",
    'defaultcomponents__select_default' => "Vælg standard %1 komponent",//to check
    'defaultcomponents__not_installed' => "(ikke installeret)",
    'defaultcomponents__not_configured' => "(ikke konfigureret).", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Nogle servicekategorier indeholdt ugyldige valg, eller der blev ikke foretaget valg.",
    'defaultcomponents__depends_on' => "(kræver %1)",
    'defaultcomponents__parameters' => "Parametre for %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL Server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS-server",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "FTP-server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Mailserver",
    'component_name__local_mailserver' => "Lokal mail-server",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Webscripting",
    'component_name__spamfilter' => "Spamfilter",
    'component_name__stats' => "Webstatistikker",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Webpublicering",
    'component_name__webserver' => "Web-server",
    'dns__dns_record_invalid_values' => 'Forkerte DNS-post værdier blev angivet: %1: %2',
    'dns__dns_record_not_found' => 'DNS-post blev ikke fundet',
    'dns__dns_zone_invalid_values' => 'Forkerte DNS-post parametre blev angivet.',

    'dns__soa_mname_title' => 'Primær navneserver',
    'dns__soa_mname_legend' => 'Navneserver',
    'dns__soa_mname_autoselect' => '(Autovælg)',

    'dns__dns_zone_off_remove_title' => "Følgende ressourceposter vil blive fjerner fra zonen %1:",
    'dns__dns_zone_master_remove_title' => "Fjerner ressourceposter fr DNS-zonen %1",
    'dns__dns_zone_slave_remove_title' => "Følgende primære navneserverposter for %1 vil blive fjernet:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Angiv poststreng.',
    'dns_add__is_spf_syntax' => 'SPF-post:',
    'dns_add__spf_value_is_invalid' => "SPF postens værdi er forkert. Den skal starte med 'v=spf'",
    'dns__dns_zone_status' => "DNS-zone status.",
    'dns__invalid_ip_address' => "IP-adresse på den nye primære DNS-server er ugyldig eller tom.",
    'dns__ip_address' => "IP-adresse",
    'dns__master_dns_type' => "er en primær DNS-server",
    'dns__masters' => "primære DNS-servere",
    'dns__soa_minimum_too_large' => 'Caching af negativ svar i mere end tre timer frarådes.',
    'dns__select_masters_to_remove' => "Vælg de DNS-servere der skal fjernes.",
    'dns__select_template_record_to_remove' => 'Vælg de DNS-skabelonposter der skal fjernes.',
    'dns__nameservers_for_domain' => "Navneservere for domænet",
    'dns__remove_dns_zone_of_domain__' => "DNS-postfjernelse fra domænet %1",
    'dns__remove_dns_zone_template__' => "Følgende DNS-poster vil blive fjerner fra skabelonen:",
    'dns__remove_this_dns_record?' => "Er du sikker på, at du vil fjerne denne DNS-post?",
    'dns__restore_default' => "Gendanner DNS-zonen efter skabelonen.",
    'dns__restore_default_confirm' => "Gendannelse af DNS-zonen vil kassere den nuværende DNS-zone konfiguration. Fortsætte alligevel?",
    'dns__restore_default_error' => "Fejl under gendannelse af DNS-zone:",
    'dns__slave_dns_type' => "er en sekundær DNS-server",
    'dns__subdomain_dns_rec_removed' => "A-posten blev fjernet fra underdomæne-zonen %1.",
    'dns__zone_switched_off_no_ns' => "Zonen blev deaktiveret, da der ikke er en NS-post %1, som skal være tilstede i zonen. Du kan føje posten til zonen ved at klikke på knappen Tilføj post.",
    'dns__cant_switch_on_no_ns' => "Zonen kan ikke aktiveres, da der ikke er en NS-post %1, som skal være tilstede i zonen. Du kan føje posten til zonen ved at klikke på knappen Tilføj post.",
    'dns__unable_activate/deactivate_dns' => "Kunne ikke aktivere/deaktivere DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Kunne ikke tilføje primær DNS­-server: Dubletpost.",
    'dns__unable_add_dns_master_local_ip' => "Kunne ikke tilføje IP-adresse for primær DNS-server: Denne post skal oprettes på en ekstern server.",
    'dns__unable_define_dns_record' => "Kunne ikke definere DNS-posten: %1",
    'dns__unable_get_dns_template_status' => "Kunne ikke hente DNS-skabelonstatus.",
    'dns__unable_remove_dns_rec' => "Kunne ikke fjerne DNS-posten: %1",
    'dns__warnings__' => "Resultatet af DNS-zone modifikationen:",
    'dns__you_not_have_perm_manage_dns' => "Du har ikke rettigheder til at administrere DNS-zonen for dette domæne.",
    'dns__cant_create_record_with_server_ip' => "Kunne ikke tilføje denne IP-adresse, da den matcher IP-adressen af denne Plesk-administrerede server.",

    'dns__tabs_acl' => "Zoneoverførsler",
    'dns__acl_add_network_legend' => "Tilføj netværk",
    'dns__acl_add_ip_legend' => "Tilføj IP-adresse",
    'dns__acl_network_not_allowed' => "Denne netværksadresse er ikke tilladt af DNS i Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP-adresse/maske",
    'dns__acl_enter_ip_address' => "IP-adresse",
    'dns__acl_list_network_legend' => "Netværk der må få en kopi af DNS-zonen",
    'dns__acl_list_ip_legend' => "IP-adresser der må få en kopi af DNS-zonen",
    'bt_dns_acl_add_network' => "Tilføj netværk",
    'bt_dns_acl_add_ip' => "Tilføj IP-adresse",

    'dns_add__add_rec_for_zone' => "Føj %1 til zone %2",
    'dns_add__canonical_dom_name_is_invalid' => "Kanonisk domænenavn er ugyldigt.",
    'dns_add__enter_canonical_name' => "Kanonisk navn",
    'dns_add__enter_dom_name' => "Domænenavn",
    'dns_add__enter_ip_address' => "IP-adresse",
    'dns_add__enter_ip_mask' => "IP-adresse og netværksmaske",
    'dns_add__enter_mail_domain' => "E-mail-domæne",
    'dns_add__enter_mail_exchanger' => "E-mail udvekslingsserver",
    'dns_add__enter_nameserver' => "Navneserver",
    'dns_add__enter_txt_record' => "TXT-post:",
    'dns_add__enter_service_name' => "Servicenavn",
    'dns_add__hint_service_name' => "Eksempel: SIP (uden understregningssymbol)",
    'dns_add__enter_protocol' => "Protokol",
    'dns_add__hint_protocol_name' => "Eksempel: TCP (uden understregningssymbol)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioritet",
    'dns_add__specify_weight_of_service' => "Relativ vægt for poster med samme prioritet",
    'dns_add__enter_target_host' => "Mål-host",
    'dns_add__hint_target_host' => "Eksempel: eksempel.com",
    'dns_add__enter_target_port' => "Destinationsport:",
    'dns_add__caa_tag' => "Mærke",
    'dns_add__caa_value' => "Værdi",
    'dns_add-invalid-A_ip' => "IP-adressen er ugyldig",
    'dns_add-invalid-AAAA_ip' => "IP-adressen er ugyldig",
    'dns_add-invalid-PTR_ip_mask' => "Ugyldig IP-adresse/netmaske-par",
    'dns_add-invalid-SRV_service_name' => "Ugyldigt servicenavn",
    'dns_add-invalid-SRV_protocol_name' => "Ugyldig protokol",
    'dns_add-invalid-SRV_target_port' => "Ugyldig destinationsport",

    'dns_add__invalid_ip' => "IP-adressen er ugyldig",
    'dns_add__low' => "lav",
    'dns_add__mail_dom_name_is_invalid' => "E-mail-domænenavnet er ugyldigt",
    'dns_add__nameserver_is_invalid' => "Navneserveren er ugyldig.",
    'dns_add__record' => "%1 post",
    'dns_add__select_prefer_for_mail_exchange_server' => "Angiv prioritet for e-mail udvekslingsserver",
    'dns_add__unable_insert_new_dns_rec' => "Kunne ikke indsætte DNS-post: %1",
    'dns_add__very_high' => "meget høj",
    'dom_ctrl__allowed' => "Tilladt",
    'dom_ctrl__db' => "MariaDB/MySQL-databaser",
    'dom_ctrl__mssql_db' => "MS SQL-databaser",
    'dom_ctrl__disk_space' => "Diskplads",
    'dom_ctrl__dom_adm' => "Domæne %1 af %2",
    'dom_ctrl__dom_cl' => "Domæne %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domænet har opsat videresendelse med udefineret videresendelses-URL",
    'dom_ctrl__domain_has_frame_forwarding' => "Domænet har frame-videresendelse til URL'en %1",
    'dom_ctrl__domain_has_no_hosting' => "Domænet har ingen hosting konfigureret.",
    'dom_ctrl__domain_has_physical_hosting' => "Webhosting er konfigureret for dette domæne på IP-adressen %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domænet har frame-videresendelse til URL'en %1",
    'dom_ctrl__maillists' => "Mailing Lists",
    'dom_ctrl__mboxes' => "Mailbokse",
    'dom_ctrl__mg' => "Mail-videresendelser",
    'dom_ctrl__resource_name' => "Resurse",
    'dom_ctrl__resp' => "Autosvar",
    'dom_ctrl__subdom' => "Subdomæner",
    'dom_ctrl__dom_aliases' => "Domænealiasser",
    'dom_ctrl__traffic' => "Trafik",
    'dom_ctrl__unable_activate/deactivate_dom' => "Kunne ikke aktivere/deaktivere domæne: %1",
    'dom_ctrl__used' => "Forbrugt",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Webbrugere",
    'dom_pref__bounce_with_phrase' => "Bounce med meddelelse",
    'dom_pref__bounce' => "Bounce",
    'dom_pref__catch_addr' => "Videresend til-adresse",
    'dom_pref__reject' => 'Afvis',
    'dom_pref__confirm_domain_removing' => "Husk at informere domænebesøgende om ændringen af domænenavnet. Er du sikker på, at du vil omdøbe domænet?",
    'dom_pref__db_inconsystency' => "databasen er inkonsistent",
    'dom_pref__dbs' => "databaser",
    'dom_pref__delete_traffic_stat' => "Bevar web- og trafikstatistik",
    'dom_pref__delete_traffic_stat_older' => "Bevar web- og trafikstatistik",
    'dom_pref__dom_level_name_conflict' => "Domæneadministratorens brugernavn er i konflikt med én af kundernes brugernavn.",
    'dom_pref__invalid_disk_space_limit' => "Ugyldig diskpladsgrænse. Maksimumværdi: %1.",
    'dom_pref__invalid_expiration_date_limit' => "Ugyldig validitetsperiode",
    'dom_pref__invalid_max_traffic_limit' => "Ugyldig trafikgrænse Maksimumværdi: %1.",
    'dom_pref__limits_of_dom' => "Begrænsninger for domænet %1",
    'dom_pref__mail_grps' => "mailgrupper",
    'dom_pref__mail_nonexistent_user' => "hvad skal der gøres med e-mails der sendes til ikke-eksisterende brugere",
    'dom_pref__mail_redirs' => "e-mail videresendelse",
    'dom_pref__mail_resps' => "e-mail autosvar",
    'dom_pref__max_limit_is_invalid' => "%1 er ugyldig.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maksimumværdien på %1 er ugyldig.",
    'dom_pref__new_limit_less_currently_used' => "%1: anmodninger - %2 aktuelt anvendt - %3",
    'dom_pref__older_that' => "for",
    'dom_pref__postboxes' => "mailbokse",
    'dom_pref__preferences_of_dom' => "Indstillinger for domænet %1",
    'dom_pref__redirect_to_itself' => "Domænet vil have videresendelse til sig selv",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Du angav, at trafikstatistik-tilbageholdelsestiden skal være mindre end den totale værdi, der er defineret for serveren (%1 måned(er)). Statistik-tilbageholdelsesperioden er indstillet til at være lig med standardværdien for serveren (%1 måned(er)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Kunne ikke tilføje et www-præfiks til domænet: %1",
    'dom_pref__unable_define_physical_hst_param' => "Kunne ikke definere fysisk hosting-parametre: %1",
    'dom_pref__unable_rename_domain' => "Kunne ikke omdøbe domænet %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Kunne ikke indstille mailbokskvoten for dette domæne: %1",
    'dom_pref__unable_set_up_web_user_script' => "Kunne ikke opsætte scripting for webbrugere: %1",
    'dom_pref__unlimited' => "Ubegrænset",
    'dom_pref__web_usrs' => "webbrugere",
    'dom_pref__you_already_have_%object' => "Du har allerede %1",
    'cu_domain__error_unable_update_ftp_users' => 'Kunne ikke opdateres FTP-brugere af domænet: %1',
    'dom_cli__warning_ignore_quota' => 'ADVARSEL: Indstillingen "-hard_quota" ignoreres: harddisk kvote er ikke understøttet',
    'dom_user_client_login_exist' => "Kunne ikke tillade domæneadministrators adgang til Plesk på domænet %1: Dette brugernavn er allerede i brug.",
    'domain__unable_to_turn_on_service' => "Kunne ikke aktivere servicen %1.",
    'domains__change_the_status_of_domain?' => "Er du sikker på, at du vil ændre status for domænet. %1?",
    'domains__client_info_hiding_traffic' => "%1 domæner, %2 aktive domæner, %3 anvendt diskplads.",
    'domains__unable_to_change_client_status' => "Kunne ikke ændre kundens kontostatus: %1.",
    'domains__unable_update_apache_settings' => "Apache-indstillingerne kunne ikke opdateres.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Du har ikke tilladelse til at slette domæner",
    'domains_list__unable_remove_doms' => "Kunne ikke fjerne domæner: %1",
    'domaintrafficlist_header_of_domain__' => "Trafik på domænet %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Vælg de domænealiasser der skal fjernes.',
    'domain_aliases_remove__title' => 'Fjern domænealiasser.',
    'domain_aliases__max_aliases_reached_for_dom' => "Grænsen for antal aliasser er nået for dette domæne.",
    'domain_edit__edit_title' => 'Redigér domænealiasnavn',
    'domain_alias_edit__type' => 'Domænealiastype',
    'domain_aliases__list_header' => 'Domænealiasser',
    'domain_aliases__name' => 'Navn',
    'domain_aliases__type' => 'Type',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Domænealiasser',
    'domain_aliases__legend' => 'Domænealiasser',
    'domain_alias__domain_exists' => 'Der findes allerede et domæne med et sådant navn.',
    'domain_alias__subdomain_exists' => 'Underdomæne med dette navn findes allerede',
    'domain_alias__dns_record_exists' => 'En DNS-post med det angivne domænealiasnavn findes allerede',
    'domain_alias__domain_alias_exists' => "Et domænealias med et sådant navn findes allerede",
    'domain_alias__invalid_type_full' => 'E-mail serveren understøtter ikke domænealias.',
    'domain_alias__redirect_exists' => 'Omdirigering til sig selv detekteret.',

    'ds__anonymous_ftp' => "Anonym FTP",
    'drweb__pagetitle' => 'Antivirus-indstillinger',
    'drweb__drweb' => 'Antivirus e-mail kontrol',
    'drweb__drweb_direction' => 'Scanner e-mail for vira',
    'drweb__drweb_direction_off' => 'Scan ikke efter vira.',
    'drweb__drweb_direction_any' => 'Indkommende og udgående e-mail',
    'drweb__drweb_direction_from' => 'Kun Udgående e-mail',
    'drweb__drweb_direction_to' => 'Kun Indgående e-mail:',
    'drweb__disable_reason_key' => 'Antivirus understøttes ikke af licensnøglen.',
    'drweb__disable_reason_perm' => 'Du har ikke tilladelse til at administrere antivirus.',
    'drweb__disable_reason_install' => 'Antivirus er ikke installeret.',
    'drweb__filters' => 'Antivirusfiltre',
    'ds__dns' => "DNS-zone",
    'ds__mail' => "E-mail",
    'dumps_list__deletion_page_title' => "Følgende sikkerhedskopifiler for domænet %1 vil blive fjernet:",
    'dumps_list__dumpfile_is_invalid' => "Filen %1 er ikke en gyldig domæne-sikkerhedskopifil.",
    'dumps_list__page_title' => "Sikkerhedsfil-opbevaringsområde",
    'dumps_upload__page_title' => "Uploader sikkerhedskopifiler til opbevaringsområdet",
    'dumps_list__repository_is_not_exist' => "Sikkerhedsfil-opbevaringsområde findes ikke.",
    'dumps_list__unable_to_remove' => "Kunne ikke fjerne sikkerhedskopifilen: %1.",
    'dumps_list__dumpfile_can_conflict' => "Det angivne filnavn er i konflikt med filen %1. Angiv et andet filnavn.",
    'dusr_ed__allow_dl_usr_access' => "Tillad domæneadministrator adgang.",
    'dusr_ed__information' => "Egenskaber for domænet %1's administrator",
    'dusr_ed__locale' => "Domæneadministratorens sprog",
    'dusr_ed__skin' => "Domæneadministratorens brugerfladetema",
    'dusr_ed__personal_information' => 'Personlig information',
    'ess__error' => "Fejl",
    'example__' => "Eksempel: %1",
    'extras__allow_certificate_purchasing' => "Tillad certifikatkøb",
    'extras__allow_domain_registration' => "Tillad domæneregistrering",
    'extras__allow_extras' => "Tillad ekstra services",
    'extras__buy_new_key' => "Din nuværende licens tillader ikke, at du ændrer disse objekter.",
    'extras__setup_services' => "Opsæt yderligere services",

    'ruleeditform__error' => 'Firewallregel kan ikke opdateres.',
    'ruleeditform__name_is_required' => 'Angiv regelnavnet.',
    'ruleeditform__profiles_is_required' => 'Vælg mindst én profil.',
    'ruleeditform__invalid_ip' => 'Den angivne IP-adresse eller netværket er ugyldigt.',
    'ruleeditform__invalid_port' => 'Den angivne port er ugyldig.  De mulige værdier er 1000 eller 1000-1051',

    'filemanager__items' => 'emner i mappen %1',
    'filemanager__items_paging' => 'emner i mappen %1',

    'get_password__encrypted_password' => "Kunne ikke sende adgangskodeinformation: Adgangskoden er lagret krypteret.",
    'get_password__mail_error' => "Der opstod en fejl under forsøget på at sende adgangskoden til e-mail adressen %1: %2",
    'get_password__mail_ok' => "Adgangskoden blev sendt til e-mail adressen %1.",
    'get_password__message' => "Dit brugernavn til adgang til systemet: %1 \nDin adgangskode er %2",
    'get_password__subject' => "Adgangskode til adgang til systemet",
    'groups__available' => "E-mailgrupper til rådighed",
    'groups__groups_for_mailname' => "E-mailgrupper hvorpå e-mail kontoen %1 abonnerer",
    'groups__member_of' => "Medlem af følgende e-mailgrupper:",
    'help__help_area' => "Hjælp-område",
    'hst_def__auth_disabled' => "forbudt",
    'hst_def__auth_enabled' => "tilladt",
    'hst_def__change_curr_dns_ip' => "Den nuværende IP-adresse på A DNS-posten vil blive ændret",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Ingen af IP-adresserne til A DNS-posten matcher med IP-adressen til den hosting-konto der oprettes",
    'hst_def__dest_url' => "Destinations-URL",
    'hst_def__disk_quota' => "Diskkvote",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Den diskpladsgrænse, du forsøger at indstille, overskrides af diskpladsgrænsen i anonym FTP indkommende-mappen. Diskpladsgrænsen i anonym FTP indkommende mappen må ikke overstige domænets diskpladsgrænse.",
    'hst_def__frame_forwarding_definition' => "Frame-videresendelses-tilknytning for domænet %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Advarsel: FTP-bruger %1 er angivet i hosting-konto indstillingerne, men findes ikke i systemet.",
    'hst_def__hst_type_is_not_defined' => "Hostingtype er ikke defineret.",
    'hst_def__ip_based' => "IP-baseret",
    'hst_def__name_based_power_anonymous_ftp_down' => "Overførsel af denne hosting-konto til en delt IP-adresse vil gøre anonym FTP-service på dette domæne utilgængeligt. Fortsætte alligevel?",
    'hst_def__password_is_invalid_password_syntax' => "Adgangskoden er ugyldig: \nBrug ikke anførselstegn, mellemrum og nationale alfabetiske tegn i en adgangskode \nAdgangskodelængden skal være på mellem 5 og 14 tegn. Adgangskoden må ikke indeholde brugernavnet.",
    'hst_def__shell' => "SSH-adgang til server-shell under abonnementets systembruger",
    'hst_def__shell_windows' => "Eksternt Skrivebord-adgang til serveren under abonnementets systembruger",
    'hst_def__standard_forwarding_definition' => "Standard videresendelses-tilknytning for domænet %1",
    'hst_def__title_name_based' => "Navnebaseret",
    'hst_def__unable_create/update_physic_hst' => "Kunne ikke oprette/opdatere fysisk hosting: %1",
    'hst_def__unable_create/update_std_fwd' => "Kunne ikke oprette/opdatere standard videresendelse: %1",
    'hst_def__unable_create_forwarding_myself' => "Kunne ikke oprette videresendelse til domænet selv.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Kan ikke tillade brug af en enkelt mappe til lagring af SSL/TLS og ikke-SSL/TLS indhold: SSL/TLS-understøttelse er ikke aktiveret.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Kunne ikke aktivere SSL/TLS-understøttelse: Intet SSL/TLS-certifikat installeret.",
    'hst_def__url_is_invalid' => "URL er ugyldig",
    'hst_def__virtual_host_access' => "Virtuel host-adgang til domænet %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ADVARSEL  Denne virtuelle host bruger en ikke-eksisterende IP-adresse til hosting.",
    'hst_def__you_have_no_ips' => "Du har ingen ledige IP-adresser, og du må ikke oprette navnebaseret hosting.",
    'hst_sel__header' => "Hvis du vil være host for et websted på denne maskine, skal du vælge indstillingen Fysisk hosting. \n Hvis du vil opsætte domæne-videresendelse til et websted på en anden maskine, skal du enten vælge Frame-videresendelse eller Standard videresendelse. \n Med standard videresendelse omdirigeres en bruger til webstedet og det faktiske websteds URL vises i brugerens browser, så vedkommende ikke ved, at der er foretaget en videresendelse. Med frame-videresendelse omdirigeres en bruger til webstedet uden at vide, at webstedet rent faktisk befinder sig et andet sted.",
    'hst_sel__physical_hst' => "Fysisk hosting",
    'hst_sel__select_hst_type' => "Vælg hostingtype for domænet",
    'hst_sel__select_hst_type_warning' => "Vælg hostingtype for domænet",
    'hst_sel__hosting_exists' => "Kunne ikke oprette hosting, da dette allerede er konfigureret for dette domæne. Du vil blive omdirigeret til hosting-administrationssiden.",
    'hst_sel__standard_frw' => "Standard-videresendelse",
    'hst_sel__frame_frw' => "Frame-videresendelse",
    '__frame_frw' => "Frame-videresendelse",
    '__hosting_exists' => "Kunne ikke oprette hosting, da dette allerede er konfigureret for dette domæne. Du vil blive omdirigeret til hosting-administrationssiden.",
    '__choose_hst_type' => "Vælg den ønskede hostingtype.",
    '__no_hst_conf' => "Der er ikke konfigureret hosting for dette websted.",
    '__physical_hst' => "Fysisk hosting",
    '__select_hst_type' => "Vælg hostingtype for domænet",
    '__standard_frw' => "Standard-videresendelse",
    '__warning' => "Advarsel! Alle de tidligere indstillede parametre vil blive kasseret. Er du sikker på, at du vil skifte hosting-type?",
    'i_cl_off' => "Kunden er inaktiv.",
    'i_cl_off_by_admin' => "Kundens konto er suspenderet af serveradministratoren.",
    'i_cl_off_expired' => "Kundekontoen er udløbet.",
    'i_cl_on' => "Kunden er aktiv.",

    'icf__title' => 'Internetforbindelses-firewall',
    'icf__if_legend' => 'Grænseflader',
    'icf__mode' => 'Tilstand',

    'invalid_value' => 'Værdien er ugyldig',

    'ip_addr__already_exists' => "IP-adressen %1 findes allerede.",
    'ip_addr__cant_add' => "IP %1 findes ikke eller hører til en anden kundes IP-gruppe",
    'ip_alias__interface' => "Grænseflade",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP-adresse til navnebaseret virtuel hosting er ugyldig.",
    'ip_alias__invalid_ip_or_netmask' => "Ugyldig IP-adresse/netmaske-par",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP-adressen %1 er den originale server-IP, så du kan ikke fjerne den.",
    'ip_alias__ip_is_invalid' => "%1 IP-adressen er ugyldig",
    'ip_alias__ip_mask_is_invalid' => "%1 IP-masken er ugyldig",
    'ip_alias__ip_not_exist' => "IP-adressen %1 findes ikke.",
    'ip_alias__ip_address_and_mask' => 'IP-adresse og undernetmaske',
    'ip_alias__mask' => "Undernetsmaske",
    'ip_alias__remove_selected_ip_aliases?' => "Er du sikker på, at du vil fjerne de valgte IP-adresser?",
    'ip_alias__select_ip' => "Vælg mindst én IP-adresse på listen for at fjerne den.",
    'ip_alias__this_ip_used_for_domain' => "(%1) denne IP-adresse bruges til domænet %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) denne IP-adresse bruges til navnebaseret virtuel hosting.",
    'ip_alias__unable_add_ip' => "Kunne ikke tilføje IP: %1",
    'ip_alias__unable_remove_ip' => "Kunne ikke fjerne IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Du kan ikke ændre IP-adressetypen til delt, da dette vil gøre anonym FTP for domænet '%1' ugyldigt.",
    'ip_ctrl__ip_addr' => "IP-adressen %2 på grænsefladen %1",
    'ip_ctrl__ip_exists_many_pools' => "Du kan ikke ændre IP-typen. Denne IP-adresse hørere til grupperne for flere brugere på én gang.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-certifikat",
    'limit__date_in_past' => "Validitetsperioden er ugyldig. %1 er i fortiden.",
    'limit__enter_date' => "Indtast dato",
    'limit__max_db' => "Databaser",
    'limit__name_disk_space' => "Diskplads",
    'limit__name_max_box' => "mailbokse",
    'limit__name_max_db' => "MariaDB/MySQL-databaser",
    'limit__name_max_dom' => "domæner",
    'limit__name_max_maillists' => "mailing Lists",
    'limit__name_max_subdom' => "subdomæner",
    'limit__name_max_traffic' => "trafik",
    'limit__name_max_wu' => "webbrugere",
    'limit__name_mbox_quota' => "mailbokskvote",
    'limit__name_max_mn' => "mailkonti",
    'limit__name_max_cl' => 'klienter',
    'limit__name_total_mboxes_quota' => "total mailbokse-kvote",
    'limit__name_mysql_dbase_space' => "MariaDB/MySQL databaseplads",
    'limit__name_mssql_dbase_space' => "MSSQL databaseplads",
    'limit__name_pgsql_dbase_space' => "PostgreSQL-databaselagerplads",
    'limit__name_expiration' => 'udløbsdato',

    'locale_upload__unable_to_install' => 'Kunne ikke installere sprogpakkefil',
    'locale_upload__wrong_package' => 'Den uploadede fil indeholder ikke en sprogpakke, der er gyldig til denne Plesk-version.',
    'locale_upload__wrong_locale' => 'Den uploadede fil indeholder ikke en gyldig sprogpakke.',

    'ma__create_title' => 'Opretter e-mail alias for %1',
    'ma__edit_title' => "Redigér e-mail alias %1",
    'ma__enter_new_alias' => "Indtast en ny værdi.",
    'ma__invalid_alias' => "Ugyldigt e-mail alias",
    'ma__mail_aliases_mailname' => "E-mail aliasser for e-mail kontoen %1",
    'ma__mailname_does_not_exist' => "E-mail kontoen findes ikke.",
    'ma__select_ma_for_remove' => "Markerede e-mail aliasser bliver fjernet.",
    'ma__unable_to_add_new_ma' => "Kunne ikke tilføje et e-mail alias: %1",

    'mail_queue__not_allowed_by_license_key' => 'E-mail kø-administration er ikke tilladt af licensnøglen.',
    'maillist__' => "Mailingliste %1",
    'maillist__already_exists' => "Mailinglisten findes allerede.",
    'maillist__mail_alias_already_exists_in_this_domain' => "E-mailaliasset %1 findes allerede på dette domæne.",
    'maillists__' => "Mailinglister %1",
    'maillists__limit_cl_max_maillists' => "Begrænsningen for antal mailinglister blev nået for kunden (grænse: %1, brugt: %2)",
    'maillists__limit_dom_max_maillists' => "Begrænsningen for antal mailinglister blev nået for domænet.",
    'maillists__list' => "Mailing Lists",
    'maillists__mailman_not_installed_or_conf' => "\nMailman-serverudvidelser er ikke installeret i øjeblikket eller ikke konfigurerede \npå serveren. Kontakt serveradministratoren og få Mailman-serverudvidelserne installeret eller korrekt konfigureret.",
    'maillists__status' => "Mailinglisteservice er aktiveret",
    'maillists__unable_to_delete__' => "Kunne ikke slette mailinglisten %1.",
    'maillists__disabled_text' => 'Du kan ikke administrere mailinglister fordi Mailman mailingliste-serverkomponenten ikke er installeret eller konfigureret.',
    'maillist_member__already_exists' => 'Mailingliste-abonnenten findes allerede.',
    'maillist_member__not_exists' => 'Der er ingen sådan bruger på mailinglisten.',
    'mailserver_switching_warning' => "Advarsel! \n \nÆndring af mailserver er udelukkende beregnet til førstegangsopsætningen, og hvis serveren allerede er i brug, vil det kunne medføre følgende problemer: tab af indstillinger om mailboksindhold samt - i tilfælde hvor den server du skifter til allerede er konfigureret - diverse konflikter. \nHvis denne server er i brug nu, og du er sikker på at du vil skifte til en anden server, bør du advisere dine kunder om handlingen, så de kan downloade og gemme deres e-mails.",
    'manager__access_denied' => "Adgang nægtet: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Kunder',
    'manager__domain' => "Domæne",
    'manager__domain_cl_limit_exceeding' => "Grænsen for antal domæner er nået for denne kundekonto.",
    'manager__domain_is_not_yours' => "Domænet %1 tilhører ikke dig.",
    'manager__domain_key_limit_exceeding' => "Grænsen for domæneoprettelse, der er defineret i din licensnøgle, er nået.",
    'manager__no_perm_to_call' => "Du har ikke tilladelse til at kalde %1.",
    'manager__no_perm_to_create_domains' => "Du har ikke tilladelse til at oprette domæner.",
    'manager__no_perm_to_modify_domain' => "Du har ikke tilladelse til at ændre domænet %1.",
    'manager__no_perm_to_modify_domains' => "Du har ikke tilladelse til at ændre domæner.",
    'manager__no_perm_to_remove_domain' => "Du har ikke tilladelse til at fjerne domænet %1.",
    'manager__no_perm_to_remove_domains' => "Du har ikke tilladelse til at fjerne domæner.",
    'manager__node_doesnt_exist' => "%1 eksisterer ikke.",
    'manager__user_disabled' => "Din konto er suspenderet. Du kan ikke betjene systemet.",
    'mail_quota_unsupported' => "ikke understøttet af mailserveren.",
    'mbox_quota_unsupported' => "ikke understøttet af mailserveren.",
    'mn__create_title' => "Opret e-mail konto",
    'mn__edit_title' => "Indstillinger",
    'mn__files_list_title' => "Bilagsfiler",
    'mn__files_remove' => "Fjern filer fra opbevaringsområdet for bilag. Disse filer bruges muligvis af autosvar. De vil blive fjernet fra både opbevaringsområdet og de autosvar der bruger dem.",
    'mn__files_select_for_remove' => "Vælg de filer, der skal fjernes.",
    'mn__mail_alias_form' => "E-mail alias formular",
    'mn__mail_aliases_list' => "E-mail aliasser",
    'mn__mailbox' => "Mailboks-administration.",
    'mn__unable_define_mn' => "Kunne ikke opsætte e-mail konti: %1",
    'mn__unable_remove_mbox_quota' => "Kunne ikke fjerne mailboks-kvote: %1.",
    'mn__upload_file' => "Overfør fil",
    'mn_edit__attach_filename_changed' => 'Den uploadede fil %1 blev omdøbt til %2, da dens navn indeholdt ikke-ASCII tegn.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Du skal tilføje et e-mail gruppe medlem inden du aktiverer e-mail gruppen.",
    'mn_edit__add_resp_or_turn_off_box' => "Du skal tilføje autosvar eller rydde afkrydsningsfeltet Autosvar.",
    'mn_edit__attachments' => "Vedhæftninger",
    'mn_edit__dom_quota_less_then_quota' => "Størrelsen på denne mailboks må ikke overstige grænsen for mængden af reserveret diskplads til mailbokse på dette domæne.",
    'mn_edit__enter_external_rcpnt_email' => "Indtast eksternt e-mail gruppe medlems e-mail adresse",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Indtast en adresse til e-mail videresendelse eller fjern krydset i afkrydsningsfeltet.",
    'mn_edit__ext_rcpnt_email_invalid' => "Ekstern modtagers e-mailadresse er ugyldig.",
    'mn_edit__file_exists' => "Filen findes allerede. Overskriv?",
    'mn_edit__files_deld_from_repository' => "Disse filer vil blive slettet fra opbevaringsområdet sammen med de autosvar, der indeholder dem. Vil du fortsætte?",
    'mn_edit__mail_name' => "Mailkonto",
    'mn_edit__mail_name_invalid' => "E-mailkontonavnet er ugyldigt.",
    'mn_edit__mail_redir' => "E-mail videresendelse.",
    'mn_edit__mail_redir_add' => "Tilføj e-mail gruppemedlem.",
    'mn_edit__mail_resps' => "E-mail autosvar.",
    'mn_edit__mailbox' => "Mailboks",
    'mn_edit__enable_mailbox' => "Mailboks",
    'mn_edit__mailgroup' => "Mailgruppe",
    'mn_edit__mailgroup_addresses' => "Medlemmer af e-mail gruppe",
    'mn_edit__mailgroup_disabled' => "Kun til rådighed hvis en e-mail konto allerede er tilføjet.",
    'mn_edit__max_dom_quota' => "Standard for domænet (%1)",
    'mn_edit__mbox_quota_invalid' => "Korrekt mailboksstørrelse angivet.",
    'mn_edit__new_resp_name' => "Nyt autosvar-navn",
    'mn_edit__no_autoresponders' => "Du bør mindst tilføje ét autosvar inden du deaktiverer eller aktiverer autosvar-servicen.",
    'mn_edit__no_file_sel' => "Der er ikke valgt filer.",
    'mn_edit__no_mail_addresses' => "Ingen e-mail adresser blev angivet eller valgt.",
    'mn_edit__none' => "Ingen",
    'mn_edit__not_create_pass' => "Dette vil ikke oprette en adgangskode til denne konto. \nUden adgangskode vil brugeren ikke kunne se og sende e-mails.",
    'mn_edit__redir_email_invalid' => "Videresendelsesadressen er ugyldig",
    'mn_edit__redirect_addr' => "Videresendelsesadresser",
    'mn_edit__remove_autoresp?' => "Er du sikker på, at du vil fjerne autosvaret?",
    'mn_edit__remove_rcpnts?' => "Er du sikker på, at du vil fjerne disse modtagere?",
    'mn_edit__repository' => "Opbevaringsområde",
    'mn_edit__resps_attach' => "Autosvar bilagsfiler",
    'mn_edit__select_rcpnt_from_list' => "Vælg mindst én IP-adresse på listen for at fjerne den.",
    'mn_edit__select_registered_users' => "Vælg registrerede brugere",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Du har valgt at have en mailboks, men du har ikke oprettet en adgangskode til den.",
    'mn_edit__unable_act_deact_mail_group' => "Kunne ikke aktivere/deaktivere e-mail gruppe: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Kunne ikke aktivere/deaktivere e-mail videresendelse: %1",
    'mn_edit__unable_act_deact_postbox' => "Kunne ikke aktivere/deaktivere mailboks: %1",
    'mn_edit__unable_act_deact_resp' => "Kunne ikke aktivere/deaktivere autosvar: %1",
    'mn_edit__unable_add_attach' => "Kunne ikke tilføje bilagsfil: %1",
    'mn_edit__unable_add_mail_group_member' => "Kunne ikke tilføje e-mail gruppe medlem: %1",
    'mn_edit__unable_add_resp' => "Kunne ikke tilføje autosvar: %1",
    'mn_edit__unable_change_mail_name' => "Kunne ikke ændre kundens e-mailkontoens status: %1.",
    'mn_edit__unable_deactivate_mail_group' => "Kunne ikke deaktivere e-mail gruppe: %1",
    'mn_edit__unable_deactivate_resp' => "Kunne ikke deaktivere e-mail autosvar: %1",
    'mn_edit__unable_define_resp_id' => "Kunne ikke definere autosvar ID %1.",
    'mn_edit__unable_remove_attach' => "Kunne ikke fjerne bilagsfil(er): %1",
    'mn_edit__unable_remove_autoresp' => "Kunne ikke fjerne autosvar: %1",
    'mn_edit__unable_remove_mail_group_member' => "Kunne ikke fjerne e-mail gruppe medlemmer: %1",
    'mn_edit__wrong_way' => 'Meddelelser, der er adresserede til %1 vil ikke blive leveret, da denne e-mail konto ikke har en mailboks eller e-mail videresendelse er aktiveret.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Mailboksen på adressen %1 var deaktiveret. Meddelelserne i mailboksen blev ikke fjernet, men du vil ikke kunne hente dem via protokollerne IMAP eller POP3.',
    'mn_list__mail_names_for_domain' => "E-mail konti under domænet %1",
    'mn_list__sa_cannot_unable' => "Kunne ikke aktivere spamfiltrering.",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Kunder',
    'mn_list__tab_title_domain' => 'Domæne',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Navn",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Kunne ikke fjerne e-mail konto: %1",
    'module_upload__module_was_installed' => 'Dette modul er allerede installeret. Hvis du vil installere en nyere version af dette modul, skal du først afinstallere modulet gennem Plesk, og derefter forsøge at installere det.',
    'module_upload__unable_to_install' => 'Kunne ikke afinstallere modulpakkefil',
    'module_upload__wrong_package' => 'Den uploadede fil er ikke en understøttet modulpakke.',
    'module_upload__wrong_module' => 'Den uploadede fil indeholder ikke en modulpakke.',

    'news_articles_title' => 'Plesk-nyheder',
    'notification_text__invalid_subject_length' => "Ugyldig adviseringsemne-længde. Længden skal være på mellem 1 og 255 tegn.",
    'notification_text__invalid_text_length' => "Ugyldig adviseringstekst-længde. Længden skal være på mellem 1 og 65533 tegn.",
    'notification_text__subject' => "Adviseringsemne",
    'notification_text__text' => "Adviseringstekst",
    'notification_text__title' => "Redigér advisering",
    'notification_text__unable_set_text' => "Kunne ikke ændre adviseringstekst:",

    'odbc__cant_add_dsn' => "Kunne ikke tilføje DSN: %1: %2.",
    'odbc__cant_connect' => "Kunne ikke tilslutte til datakilde med de definerede indstillinger. Serveren har returneret: %1",
    'odbc__cant_delete_dsn' => "Kunne ikke slette DSN %1: %2.",
    'odbc__cant_get_drivers_info' => "Kunne ikke hente information om drivere.",
    'odbc__cant_get_drivers' => "Kunne ikke hente en liste over ODBC-drivere: %1..",
    'odbc__cant_open_info_file' => "Kunne ikke åbne filen med ODBC-driveroplysninger.",
    'odbc__cant_parse_string' => "Kunne ikke fortolke forbindelsesstrengen.",
    'odbc__driver_not_set' => "Driver er ikke angivet.",
    'odbc__driver_or_name_not_set' => "Driver eller navn på ODBC-forbindelsen var ikke indstillet.",
    'odbc__dsn_already_exists' => "Der findes en DSN med dette navn (%1) i systemet.",
    'odbc__dsn_not_exists' => "Denne DSN findes ikke.",
    'odbc__enter_dsn_name' => "Indtast DSN-navn",
    'odbc__invalid_dsn_name' => "Forkert syntaks for ODBC forbindelsesnavn (%1): Brug kun alfanumeriske tegn.",
    'odbc__no_such_driver' => "En ODBC-driver med dette navn (%1) understøttes ikke.",
    'odbc__unknown_driver' => "Ukendt drivernavn (%1)",
    'odbc_dsn_system' => "System-DSN",

    'pb__aliases' => "Aliaser",
    'pb__anonftp' => "Anonym FTP",
    'pb__autoinstaller_releases' => 'Opdater',
    'pb__cert' => "Certifikater",
    'pb__cl_pool' => "IP-adresser",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Indstillinger",
    'pb__cl_rpt' => "Rapport",
    'pb__cl_rpt_list' => "Tilpas",
    'pb__cl_templates' => "Debitorskabeloner",
    'pb__cl_traffic' => "Trafik",
    'pb__cl_traffic_history' => "Trafikhistorik",
    'pb__cl_traffic_of' => "Trafik på %1",
    'pb__client' => "%1",
    'pb__clients' => "Kunder",
    'pb__comp_info' => "Serverkomponenter",
    'pb__common_acl' => 'Tillad overførsels-ACL',
    'pb__cp_access' => "Adgang",
    'pb__crontab' => "Planlægger",
    'pb__scheduler' => "Planlægger",
    'pb__custom_buttons' => "Brugerdefinerede knapper",
    'pb__databases_db' => 'Databaser',
    'pb__sqlservers_db' => 'SQL-servere',//to check
    'pb__db' => "Databaser",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Databaseservere',
    'pb__dl_usr_ed' => "Domæneadministrator",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domænebegrænsninger.",
    'pb__dom_pref' => "Indstillinger",
    'pb__dom_sum_report' => "Domæneoversigtsrapport",
    'pb__dom_templates' => "Domæneskabeloner",
    'pb__dom_traffic' => "Trafik på %1",
    'pb__domains' => "Domæner",
    'pb__domain_aliases' => 'Domænealiasser',
    'pb__dumps_list' => "Sikkerhedsfil-opbevaringsområde",
    'pb__forwarding_setup' => "Opsætning af videresendelse",
    'pb__filemanager' => "Fil-administrator",
    'pb__ip_aliasing' => "IP-adresser",
    'pb__ip_clients' => "IP-adresse fjernelse",
    'pb__license_management' => 'Information om licens',
    'pb__locales' => 'Localer',
    'pb__log_files' => "Logfiler",
    'pb__mail' => 'E-mail',
    'pb__mail_name_files' => "Bilagsfiler",
    'pb__mail_name_redirects' => "E-mail videresendelse.",
    'pb__mail_name_resp_attach_add' => "Nyt bilag",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "E-mail autosvar.",
    'pb__mail_names' => "E-mail",
    'pb__maillists' => "Mailing Lists",
    'pb__mimetypes' => 'MIME-typer',
    'pb__modules' => 'Moduler',
    'pb__modules_management' => 'Administrér moduler',
    'pb__notifications' => "Notificeringer",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Opsætning af fysisk hosting",
    'pb__prtd_dirs' => "Beskyttede biblioteker",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Tilpas",
    'pb__server' => "Server",
    'pb__sessions' => "Sessioner",
    'pb__sapp_pool' => "Webprogramgruppe",
    'pb__siteapp_install' => 'Installation af webprogram',
    'pb__site_app_pkgs' => 'Web-applikationer',
    'pb__site_apps' => "Web-applikationer",
    'pb__additional_key_info' => 'Nøgleegenskaber',
    'pb__additional_key_properties' => 'Nøgleegenskaber',
    'pb__skeleton' => 'Skabelon til Virtuel host',
    'pb__skins' => 'Tema',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Spamfilter",
    'pb__statistics' => "Statistik",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomæner",
    'pb__templates' => "Skabeloner",
    'pb__virtualdirs' => 'Virtuelle mapper',
    'pb__web_users' => "Webbrugere",
    'pdir__enter_dir_name' => "Indtast mappenavnet.",
    'pdir__invalid_hst' => "Hostingtypen er ugyldig. Skal være fysisk.",
    'pdir__pd_id_is_undefined' => "Beskyttet mappe-ID er ikke defineret.",
    'pdir__pdir_exist' => "Mappe med dette navn er allerede beskyttet.",
    'pdir__pdir_not_exist' => "Beskyttet mappe findes ikke.",
    'pdir__pdir_usr_not_exist' => "Beskyttet mappe-bruger findes ikke.",
    'pdir__remove_pdir_usrs' => "Følgende brugere af den beskyttet mappe %2 under underdomænet %1 bliver fjernet:",
    'pdir__remove_pdir_usrs_on_subdom' => "Følgende brugere af den beskyttet mappe %2 under underdomænet %1 bliver fjernet:",
    'pdir__select_pdir_usrs_for_remove' => "Vælg de beskyttet mappe-brugere, der skal fjernes.",
    'pdir__select_pdirs_to_remove' => "Vælg de mapper, som beskyttelsen skal fjernes fra.",
    'pdir__unable_define_pdir_users' => "Kunne ikke definere de beskyttede mappe-brugere.",
    'pdir__unable_define_pdirs_properties' => "Kunne ikke indstille egenskaberne for beskyttede mapper: %1",
    'pdir__unable_select_dom_param' => "Kunne ikke vælge domæneparametre: %1",
    'pdir_ed__create_pdir_for_domain' => "Opret en beskyttet mappe under %1",
    'pdir_ed__create_pdir_for_subdomain' => "Opret en beskyttet mappe under underdomænet %1",
    'pdir_ed__dir_already_protect' => "Denne mappe er allerede beskyttet",
    'pdir_ed__head_txt' => "Titel på det beskyttede område",
    'pdir_ed__invalid_login' => "Du angav et forkert brugernavn.",
    'pdir_ed__login_exists' => "Denne bruger findes allerede Prøv at indtaste et andet brugernavn.",
    'pdir_ed__new_usr' => "Brugernavn",
    'pdir_ed__non_ssl' => "ikke-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Mappenavn",
    'pdir_ed__pdir_for_domain' => "Beskyttet mappe %1 på domænet %2",
    'pdir_ed__pdir_for_subdomain' => "Beskyttet mappe %1 under underdomænet %2",
    'pdir_ed__pdir_location' => "Mappeplacering",
    'pdir_ed__pdir_users' => "Brugere af beskyttet mappe",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Mindst ét af afkrydsningsfelterne SSL/TLS eller Ikke-SSL/TLS skal markeres.",
    'pdir_ed__unable_cr_pdir_usr' => "Kunne ikke oprette den beskyttede mappe-bruger: %1",
    'pdir_ed__unable_create_pdir' => "Kunne ikke oprette den beskyttede mappe: %1",
    'pdir_ed__unable_define_hst_type' => "Kunne ikke definere hostingtype.",
    'pdir_ed__unable_update_pdir' => "Kunne ikke gemme indstillinger for den beskyttede mappe: %1",
    'pdir_ed__wrong_symbol_in_header' => "Brug venligst ikke tegnet %1 i mappetitlen.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Opret brugere af den beskyttede mappe %1",
    'pdir_usr_ed__not_create_pass' => "Dette vil ikke oprette en adgangskode til den nye beskyttet mappe-bruger. \nUden adgangskode vil brugeren ikke kunne logge på.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Adgangskode for den beskyttede mappe-bruger: %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Kunne ikke vælge den beskyttede mappe-bruger: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Kunne ikke definere de beskyttede mappe-brugere: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Kunne ikke fjerne de beskyttede mappe-brugere: %1",
    'phosting__anonftp_encrypt' => 'FTP-brugerens adgangskode er krypteret, og den kan derfor ikke bruges til beskyttelse af mappen /plesk-stat/webstat/. Genindtast din FTP-adgangskode eller fravælg indstillingen "tilgængelig via adgangskodebeskyttet mappe \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Domænenavnet %%domain_name%% oversættes til IP-adressen %%dns_ip_address%%. Dit websted er knyttet til IP-adressen %%hosting_ip_address%%. Hvis dit websted ikke åbner i en webbrowser når du refererer til det med dets domænenavn, skal du skifte til DNS-administrationsskærmen (Domæner > Domænenavn > DNS) og ændre egenskaberne for A ressourceposten: Tilknyt IP-adressen %%hosting_ip_address%% til domænenavnet %%domain_name%%.",
    'phosting__ip_change_warning' => "IP-adressen er ændret. De korresponderende ændringer blev også foretaget i domænets DNS-zone.",
    'phosting__other_hosting_exists_on_ip' => "Kunne ikke ændre certifikatet, fordi denne IP-adresse bruges af én eller flere hosting-konti.",
    'phosting__unable_to_change_certificate' => "Kunne ikke installere certifikatet: %1",
    'phosting__unable_to_change_ip_address' => "Kunne ikke ændre IP-adressen: %1",
    'phosting__unable_to_set_cert' => "Kunne ikke indstille SSL/TLS-certifikatet: %1",
    'phosting__unable_update' => "Kunne ikke opdatere hosting-indstillingerne: %1",
    'phosting__unable_manage' => "Kunne ikke administrere hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Kunne ikke konfigurere fail2ban for at spore domænets logge. Logge spores automatisk næste gang fail2ban-servicen genstartes.\n%1",

    'picker_acl_record__tittle' => 'Vælg en ACL-post',
    'picker_autoresponder__title' => 'Vælg et autosvar',
    'picker_black_list__domain_name' => 'Vælg et domænenavn',
    'picker_certificate' => 'Vælg et SSL/TLS-certifikat',

    'picker_dns_zone_template__title' => 'Vælg en ressourcepost',
    'picker_domain__title' => 'Vælg et websted',
    'picker_domain_alias__title' => 'Vælg et domænealias',
    'picker_resource_record__title' => 'Vælg en ressourcepost',
    'picker_disabled_resource_record__title' => 'Vælg en navneserver',
    'picker_ip_address__title' => 'Vælg en IP-adresse',
    'picker_ip_address_clients__title' => 'Vælg de kunder der bruger denne IP-adresse',
    'picker_mail_queue' => 'Vælg e-mail-meddelelser',
    'picker_site_application__title' => 'Vælg et webprogram.',
    'picker_subdomain__title' => 'Vælg et underdomæne',
    'picker_web_user__title' => 'Vælg en webbruger',
    'picker_custom_button__title' => 'Vælg en brugerdefineret knap',
    'picker_license_key__title' => "Valg af licensnøgle",
    'picker_spamfilter_address__title' => 'Vælg en spamfilter adresse',
    'picker_white_list__networks' => 'Valg af netværk',

    'plesk_key__action_logs' => "Logning af handlinger udført af Plesk-brugere",
    'plesk_key__app_vault' => "Applikations-vault",
    'plesk_key__backup' => "Sikkerhedskopierings- og gendannelsesfunktioner",
    'plesk_key__client_templs' => "Administration af serviceplaner",
    'plesk_key__clients' => "Brugerkonti (forhandlere og kunder)",
    'plesk_key__resellers_only' => "Brugerkonti (forhandlere)",
    'plesk_key__customers_only' => "Brugerkonti (kunder)",
    'plesk_key__domains' => "Domæner",
    'plesk_key__domain_aliases' => "Domænealiasser",
    'plesk_key__manage_dashboard' => 'Tilpasning af startside',
    'plesk_key__drweb' => "Antivirus-administration",
    'plesk_key__event_manager' => "Hændelsesadministrator",
    'plesk_key__expirations' => "Administration af kontoudløbsdatoer",
    'plesk_key__group_ops' => "Ændring af flere objekter på én gang",
    'plesk_key__expiration' => "Nøgleudløbsdato",
    'plesk_key__edition_name' => "Plesk-udgave",
    'plesk_key__key_number' => "Nøglenummer",
    'plesk_key__languages' => "Sprogpakker",
    'plesk_key__mailnames' => "Mailkonti",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL Server-understøttelse",
    'plesk_key__myplesk_func' => "Links til køb af SSL/TLS-certifikater og domæneregistreringsservices",
    'plesk_key__myplesk_server_id' => "Identifikator for MPC-slaveserver",
    'plesk_key__notifications' => "Administration af adviseringer",
    'plesk_key__postgresql' => "PostgreSQL databaseserver-understøttelse",
    'plesk_key__qmail_queue' => 'Administration af e-mail kø.',
    'plesk_key__remote_db' => 'Ekstern database-hosting',
    'plesk_key__slave_servers' => "Slaveservere",
    'plesk_key__spamassassin' => "Administration af spamfilter:",
    'plesk_key__subdomains' => "Administration af underdomæner.",
    'plesk_key__sys_access' => "Administration af serveradgang",
    'plesk_key__traffic_reports' => "Trafikanvendelsesrapporter",
    'plesk_key__tts' => "Help Desk",
    'plesk_key__virtuozzo' => "Kun gyldig til Virtuozzo-containere",
    'plesk_key__webusers' => "Webbrugere",
    'plesk_key__license_update_date' => 'Opdatering af næste licensnøgle.',
    'plesk_key__autoinstaller_config' => 'Administration af opdateringsindstillinger',
    'plesk_key__check_wrong' => "Licensnøglen er ugyldig. For at kunne bruge Plesk skal du få fat i og installere en ny, gyldig licensnøgle.",
    'plesk_key__upload_check_wrong' => 'Den uploadede licensnøgle er ugyldig.',
    'plesk_key__revert_check_wrong' => 'Den tidligere installerede licensnøgle er ugyldig.',
    'plesk_key__viruozzo_only_key' => 'Licensnøglen er udelukkende beregnet til brug sammen med Plesk inde i Virtuozzo-containere.',
    'plesk_key__ip_ranges_exceeded' => 'Du kan kun bruge denne licenserede Plesk-kopi sammen med følgende IP-adresser: %2. Følgende IP-adresser er ikke dækket af din licens: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Mængden af aktuelt anvendte ressourcer overskrider de grænser der er fastlagt i din licens.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Antallet af websteder på serveren overskrider de grænser, der er defineret i din licens. Du har %2 websteder; din licens tillader kun hosting af %1 websteder.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Antallet af domænealiasser på serveren overskrider de grænser, der er defineret i din licens. Du har %2 domænealiasser; din licens tillader kun hosting af %1 domænealiasser.',
    'plesk_key__limits_exceeded_lim_cl' => 'Antallet af betjente kundekonti overskrider de grænser, der er defineret i din licens. Du har %2 kundekonti, som du pt. betjener - din licens tillader kun betjening af %1 kundekonti.',
    'plesk_key__limits_exceeded_lim_mn' => 'Antallet af betjente e-mail konti overskrider de grænser, der er defineret i din licens. Du har %2 e-mail konti, som du pt. betjener - din licens tillader kun betjening af %1 e-mail konti.',
    'plesk_key__limits_exceeded_lim_wu' => 'Antallet af betjente webbruger-konti overskrider de grænser, der er defineret i din licens. Du har %2 webbruger-konti, som du pt. betjener - din licens tillader kun betjening af %1 webbruger-konti.',
    'plesk_key__limits_exceeded_MLS' => 'Antallet af aktuelt installerede sprogpakker overskrider de grænser, der er defineret i din licens. Der er installeret %2 sprogpakker - din licens tillader kun installation af %1 sprogpakker.',
    'plesk_key__wrong_version' => 'Du forsøger at bruge en licensnøgle, der er oprettet til en anden version af Plesk. Kontakt en Plesk-sælger for at få den rette licensnøgle.',
    'plesk_key__other_product' => 'Du forsøger at bruge en licensnøgle, der er oprettet til et andet produkt. Kontakt en Plesk-sælger for at få den rette licensnøgle.',
    'plesk_key__invalid_machine_id_trial' => 'Din nuværende licens er ikke gyldig, fordi den allerede er aktiveret på en anden Plesk-server. Hvis du vil fortsætte med at bruge Plesk, skal du enten installere en ny licens eller installere din nuværende licens igen ved at indtaste dens aktiveringskode (hvis du har en).',
    'plesk_key__invalid_machine_id_retail' => 'Din nuværende licens er ikke gyldig, fordi den allerede er aktiveret på en anden Plesk-server. WebPros EULA (https://www.plesk.com/legal/) forbyder brugen af ​​en enkelt licens på to eller flere servere på samme tid. For at fortsætte med at bruge Plesk skal du enten installere en ny licens eller geninstallere din nuværende licens ved at indtaste din aktiveringskode. Den blev sendt til dig, da du købte licensen. <br>Kan du ikke finde aktiveringskoden? Du kan gendanne den ved hjælp af Plesk 360. For at gøre dette skal du logge ind på https://platform360.io/ med den e-mailadresse, du brugte til at købe licensen, gå til fanen "Licenses" og her finde din licensaktiveringskode. Du kan også kontakte Plesk licens- og købssupport via onlineformularen (https://www.plesk.com/licensing-and-purchase-support/). Sørg for at angive dit licensnummer i afsnittet "How can we help you?" i formularen.',
    'plesk_key__limits_exceeded_error' => 'Kunne ikke installere licensnøglen: Den aktuelt anvendte mængde ressourcer overskrider de grænser, der er defineret i den uploadede licensnøgle.',
    'plesk_key__limits_exceeded_note' => 'Den aktuelt anvendte mængde ressourcer overskrider de grænser, der er defineret i den uploadede licensnøgle.',
    'plesk_key__key_file_invalid' => 'Den uploadede nøglefil er ikke gyldig, eller indeholder ikke en licensnøgle.',
    'plesk_key__server_request_error' => 'Kunne ikke opdatere licensen. Sørg for, at forbindelser til licensserveren ka.plesk.com på TCP port %1 ikke er blokerede. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Se hvordan du gør det </a>.',
    'key__no_key_file_in_zip' => 'Den uploadede .zip-fil indeholder ikke en nøglefil',
    'key__key_upload' => 'Licensnøgleinstallation',
    'additional_key__prop_name' => 'Egenskaber',
    'additional_key__prop_value' => 'Værdi',
    'additional_key__descr_name' => 'Nøglenavn',
    'additional_key__descr_key_number' => 'Nøglenummer',
    'additional_key__descr_key_vz' => "Denne licensnøgle er udelukkende beregnet til brug i Virtuozzo-containere.",
    'additional_key__descr_key_mailboxes' => 'Mailbokse',
    'additional_key__descr_lim_date' => 'Udløbsdato',
    'additional_key__descr_license_update_date' => 'Opdatering af næste licensnøgle.',
    'additional_key__file_invalid' => 'Den uploadede nøglefil er ikke gyldig, eller indeholder ikke en licensnøgle.',
    'additional_key__file_incompatible' => 'Den uploadede nøglefil er ikke gyldig til dette program.',
    'additional_key__not_exists' => 'Der er ikke installeret en licensnøgle.',
    'additional_key_update__result_response' => 'Licensserversvar: %1.',
    'additional_key_update__result_network' => 'Det kunne ikke oprettes forbindelse til licensserveren. Kontrollér, at dit netværk tillader kommunikation med %1: %2.',
    'additional_key_update__result_lock' => 'Nøgleopdatering er allerede i gang.',
    'additional_key_update__result_internal_error' => 'Der opstod en fejl under opdatering af licensnøglen: %1',

    'proceed_to_cl_pool' => "Fortsæt til konfiguration af kundens IP-gruppe",
    'proceed_to_hosting_setup' => "Fortsæt til hosting-opsætning",
    'removeCerts__remove_certificates_cp' => "Følgende certifikater vil blive fjernet:",
    'removeCerts__remove_certificates_domain' => "Følgende certifikater, der ejes af %1, vil blive fjernet:",
    'removeClientsIP_remove_clients_ip' => "Denne IP-adresse vil blive fjernet fra grupperne for følgende kunder:",
    'removeMailAliases__remove_mail_aliases' => "Følgende e-mail aliasser for e-mail kontoen %1 vil blive fjernet:",
    'removeMailNames__remove_mailnames' => "Følgende e-mail konti og aliasser vil blive fjernet fra domænet %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Følgende e-mail konti og aliasser vil blive fjernet fra domænet %2, der ejes af kunden %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Disse e-mail konti vil ikke blive slettet.",
    'removeFtpSessions__remove_title' => "Følgende FTP-sessioner vil blive afsluttet:",
    'removeTemplates__remove_templates' => "Følgende skabeloner fjernes:",
    'resp_edit__always_respond' => "svar altid",
    'resp_edit__reply_subject' => "Svaremne",
    'resp_edit__answer_subject' => "Svar med emne",
    'resp_edit__answer_txt' => "Svar med tekst",
    'resp_edit__attach' => "Vedhæft filer",
    'resp_edit__default_subject' => "Sv:%1",
    'resp_edit__for' => "for",
    'resp_edit__frw_rqst_email' => "Videresend den originale meddelelse til den angivne e-mail adresse ved automatisk respons.",
    'resp_edit__fwd_email_invalid' => "Destinations-e-mail adressen er ugyldig.",
    'resp_edit__in_body' => "når de specificerede ord findes i meddelelsens brødtekst",
    'resp_edit__in_subject' => "når de specificerede ord findes i meddelelsens emne",
    'resp_edit__invalid_resp_freq' => "Responsfrekvensen er ugyldig.",
    'resp_edit__invalid_rqst_txt' => "Ugyldig anmodningstekst.",
    'resp_edit__invalid_store_lim_num' => "Begrænsningsværdien er ikke gyldig.",
    'resp_edit__limits_title' => "Begrænsninger",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Maksimalt antal svar pr. dag overskrider den definerede rate. Tilladt: %1, anmodet om: %2",
    'resp_edit__no_files_sel' => "Der er ikke valgt filer.",
    'resp_edit__no_txt_supplied' => "Ingen tekst leveret.",
    'resp_edit__reply_title' => "Svar",
    'resp_edit__reply_to_address' => "Returadresse",
    'resp_edit__reply_to_invalid' => "Returadressen er ugyldig",
    'resp_edit__reply_uniq_email' => "Svar højst til den unikke e-mail adresse",
    'resp_edit__conditions_title' => "Betingelser",
    'resp_edit__request_title' => "Anmodning",
    'resp_edit__resp' => "Autosvar",
    'resp_edit__resp_name' => "Autosvarnavn",
    'resp_edit__resp_not_exist' => "Autosvar findes ikke.",
    'resp_edit__resp_status' => "Autosvar status",
    'resp_edit__rqst_txt' => 'Angiv betingelse for dette autosvar',
    'resp_edit__select_files_on_server_for_attach' => "Vælg de filer, du vil tilknytte.",
    'resp_edit__store_up_to' => "Gem op til",
    'resp_edit__subj_line_invalid' => "Emnelinjen er forkert.",
    'resp_edit__text_too_big' => "Teksten i svarmeddelelsen er for lang.",
    'resp_edit__times_in_a_day' => "gange pr. dag",
    'resp_edit__unable_define_resp_cond' => "Kunne ikke definere autosvar-betingelsen: %1.",
    'resp_edit__unable_define_resp_status' => "Kunne ikke definere autosvar status: %1.",
    'resp_edit__unable_turn_on_resp' => "Kunne ikke aktivere autosvar: %1",
    'resp_edit__uniq_email' => "unikke e-mailadresser",
    'resp_edit__content_type' => 'Format for afsendelse af e-mail',
    'resp_edit__content_type_text' => 'Almindelig tekst',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kodning',
    'restart__dns' => 'DNS-server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 Server (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "MariaDB/MySQL-server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Tjenester",
    'restart__smtp' => "SMTP Server (%1)",
    'restart__spamd' => "Spamfilter",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Webserver (%1)",
    'restart__ftp' => "FTP-server (%1)",
    'restart__service_start' => 'Det varer et øjeblik at starte servicen.',
    'restart__service_stop' => 'Det varer et øjeblik at stoppe servicen.',
    'restart__service_restart' => 'Det varer et øjeblik at genstarte servicen.',
    'rm_domains__some_domains_are_not_exist' => "Nogle af de angivne domæner findes ikke. Muligvis blev de fjernet af en anden bruger.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Videresendelse",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Rapport til administratoren %1",
    'rpt_cl_report_for_reseller__' => "Rapport vedrørende forhandleren %1",
    'rpt_cl_report_for_cl__' => "Rapport vedrørende kunden %1",
    'rpt_cl_section_domains' => "Domæner",
    'rpt_cl_section_full_domains' => "Domæner",
    'rpt_cl_section_general' => "Generelt",
    'rpt_create' => "Opret rapport",
    'rpt_empty' => "Rapporten skal indeholde mindst én sektion.",
    'rpt_dom_report_for_dom__' => "Domænerapport for %1",
    'rpt_dom_section_databases' => "Databaser",
    'rpt_dom_section_full_databases' => "Databaser",
    'rpt_dom_section_full_maillists' => "Mailing Lists",
    'rpt_dom_section_full_mailnames' => "Mailkonti",
    'rpt_dom_section_full_webusers' => "Webbrugere",
    'rpt_dom_section_full_siteapps' => 'Web-applikationer',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET-webprogrammer',
    'rpt_dom_section_general' => "Generelt",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Mailing Lists",
    'rpt_dom_section_mailnames' => "Mailkonti",
    'rpt_dom_section_siteapps' => 'Web-applikationer',
    'rpt_dom_section_aspnetapps' => 'ASP.NET-webprogrammer',
    'rpt_dom_section_webusers' => "Webbrugere",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Rediger rapport %1.",
    'rpt_enter_email_address' => "Indtast den e-mail adresse som rapporten skal leveres til.",
    'rpt_list' => "Brugerdefinerede rapportlayouts.",
    'rpt_section_full' => "Fuld",
    'rpt_section_none' => "Ingen",
    'rpt_section_summary' => "Oversigt",
    'rpt_default_full' => 'Fuld rapport',
    'rpt_default_summary' => 'Oversigtsrapport',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Fejl ved afsendelse af rapporten: %1",
    'rpt_send_report_by_email_ok__' => "Rapporten blev sendt til %1",
    'sa_action' => "Handling",
    'sa_action_del' => "Slet",
    'sa_action_desc' => "Hvad skal der ske med spam mail",
    'sa_action_save' => "Vælg som spam og gem i mailboks",
    'sa_admin_blacklist' => "Administrators sortliste.",
    'sa_admin_whitelist' => "Administrators hvidliste.",
    'sa_db_del_confirm' => "Er du sikker på, at du vil rydde spamfilter-databasen?",
    'sa_eml_in_ignorelist' => "E-mail er på ignoreringslisten",
    'sa_empty_email' => "Kan ikke tilføje tomt e-mail mønster.",
    'sa_exists_email' => "Et sådant e-mail mønster findes allerede.",
    'sa_disabled__mailname_not_filtering' => "De nuværende serverindstillinger tillader ikke brug af e-mail filtrering for denne e-mail konto",
    'sa_disabled__filtering_is_disabled' => 'Spamfiltrering blev deaktiveret af server-administratoren',
    'sa_disabled__hasnt_mailbox' => "Umuligt at aktivere spamfiltrering uden en mailboks",
    'sa_enable_filter' => "Aktivér spamfiltrering",
    'sa_forget' => "glem",
    'sa_from' => "Fra",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Mønstret er ugyldigt.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Spamfilter-træning:',
    'sa_trainer__tools_legend' => 'Værktøjer',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Meddelelser i din mailboks',
    'sa_trainer__c' => 'S',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Emne',
    'sa_trainer__from' => 'Fra',
    'sa_trainer__date' => 'Dato',
    'sa_trainer__info_text' => 'Indlærte meddelelser: %1 som spam, %2 som ikk3e-spam, %3 i alt.',
    'sa_trainer__messages' => 'Besked(er)',
    'sa_trainer__select__all' => 'Alle',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Ikke-spam',
    'sa_trainer__select__unknown_only' => 'Ukendt',
    'sa_trainer__cannot_remove_messages' => 'Kan ikke fjerne de markerede meddelelser fra mailboksen.',
    'sa_trainer__remove_messages_confirm' => 'Er du sikker på, at du vil fjerne de markerede meddelelser fra mailboksen?',
    'sa_subj' => "Emne",
    'sa_training' => "Spamfilter-træning:",
    'sa_training_legend' => "Bayesisk filtertræning:",
    'sa_use_srv_settings' => "Brug overordnede serverindstillinger",
    'sa_user_blacklist' => "Brugerens sortliste",
    'sa_user_whitelist' => "Brugerens hvidliste",
    'sa_usr_disabled_by_srv' => "Individuelle spamfiltreringsindstillinger er ikke tilladt af server-administratoren",
    'sa_usr_no_postbox' => "Kan ikke aktivere spamfiltreing fordi mailboks er deaktiveret for denne konto.",
    'sa_filters' => 'Spamfiltre',
    'spamfilter__tools_legend' => 'Værktøjer',
    'spamfilter__prefs_legend' => 'Indstillinger',
    'spamfilter__max_children' => 'Det maksimale antal arbejder-spamd processer, der skal køres',
    'spamfilter__rewrite_header_subject_hint' => 'Lad dette felt være tomt, hvis du ikke vil tilføje tekst. Indtast _SCORE_ hvis du vil inkludere score i meddelelsens emne.',
    'spamfilter__reject_spam' => 'Slet spam-e-mail når den ankommer til mailboks',
    'spamfilter__enabled' => 'Aktiveret',
    'spamfilter_addresses_list__items' => 'adresser',
    'spamfilter_addresses__remove_title' => 'Følgende adresser fjernes fra listen',
    'spamfilter_addresses__empty_selection' => 'Ingen adresser valgt',
    'server__admin_info' => "Administratorinformation",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Indtast problembeskrivelsen herunder",
    'server__power_management' => "Strømstyring",
    'server__services' => "Tjenester",
    'server__system' => "System",
    'server__title' => "Serveradministration",
    'server_preferences__admin_skin' => "Administrators grænsefladetema",
    'server_preferences__default_language' => "Standardsprog",
    'server_preferences__default_skin' => "Standardtema",
    'server_preferences__restart_apache_interval' => "Apache-genstartsinterval",
    'server_preferences__system' => 'Systemindstillinger',
    'mail__tabs_preferences' => "Indstillinger",
    'mail__tabs_white_list' => "Hvidliste",
    'server_preferences__use_vocabulary' => "Kontrollér adgangskoder for mailbokse i ordbog",
    'sessions__agreement' => "Ja, jeg vil afslutte disse sessioner.",
    'sessions__select_sessions_for_remove' => "Vælg de sessioner der skal afsluttes.",
    'sessions__tabs_cp_sessions' => 'Plesk-sessioner',
    'sessions__tabs_ftp_sessions' => 'FTP--sessioner',
    'sessions__ftp_sessions_login' => 'FTP-konto brugernavn.',
    'sessions__ftp_sessions_domain' => 'Domænenavn',
    'sessions__ftp_sessions_path' => 'Nuværende placering',
    'sessions__ftp_sessions_file' => 'Filnavn',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Hastighed: KB/s',
    'sessions__ftp_sessions_comp' => 'Forløb, %',

    'site_apps__access_level' => 'Adgangsniveau',
    'site_apps__access_level_commercial' => 'Kommerciel',
    'site_apps__access_level_free' => 'Gratis',
    'site_apps__action_installer' => "Installation af webprogram",
    'site_apps__action_reconfigure' => "Omkonfiguration af webprogram.",
    'site_apps__custom_button_level' => 'Vil du oprette en brugerdefineret knap til adgang til dette program?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nej',
    'site_apps__custom_button_level_domain_user_only' => 'Ja',
    'site_apps__custom_button_level_false' => 'Nej',
    'site_apps__custom_button_level_domain' => 'Ja - men stil den kun til rådighed for det aktuelle domæne',
    'site_apps__custom_button_level_client' => 'Ja - og stil den til rådighed for alle kundens domæner',
    'site_apps__custom_button_level_admin' => 'Ja - og stil den til rådighed for alle domæner',
    'site_apps__description' => "Beskrivelse",
    'site_apps__dir_used_by_sapp__' => "Mappen \"%1\" bruges af et andet webprogram",
    'site_apps__dir_used_by_unknown__' => "Mappen \"%1\" findes allerede. Dens indhold overskrives, hvis du fortsætter.",
    'site_apps__dir_invalid_name__' => "Mappenavnet %1 er forkert.",
    'site_apps__file_name' => 'Webprogram-filnavn',
    'site_apps__invalid_install_prefix' => "Ugyldigt installationspræfiks",
    'site_apps__invalid_package' => "Webprogrammet er ugyldigt",
    'site_apps__key_status' => 'Licensering',
    'site_apps__key_status_free' => 'Frit distribueret. Der kræves ingen licensnøgle',
    'site_apps__key_status_ok' => 'Den obligatoriske licensnøgle er installeret.',
    'site_apps__key_status_problem' => 'Den obligatoriske licensnøgle er ikke installeret.',
    'site_apps__name' => "Navn",
    'site_apps__no_domains' => 'Webprogrammet kan ikke installeres: Der er allerede installeret et andet webprogram i roden på dette domæne. Overvej at oprette et underdomæne til dette webprogram.',
    'site_apps__package_info_' => "Information om webprogram",
    'site_apps__package_integrated' => "indbygget program, kan ikke fjernes",
    'site_apps__pool_select_packages_to_add' => 'Marker de webprogrammer der skal føjes til gruppen.',
    'site_apps__release' => "Frigiv",
    'site_apps__resource_used_by_sapp' => "Denne ressource bruges af et installeret webprogram",
    'site_apps__root_used_by_sapp' => "Denne ressource bruges af et installeret webprogram",
    'site_apps__these_domains_will_not_delete' => 'Disse (under)domæner vil ikke blive slettet.',
    'site_apps__upload_site_app_pkg_title' => 'Upload nyt webprogram',
    'site_apps__version' => "Version",
    'site_apps__access_to' => "Adgang til %1.",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Skabelon til Virtuel host",
    'skeleton__client_label' => "%1 skabelon til virtuel host",
    'skeleton__admin_page' => "Administrér skabelon til virtuel host",
    'skeleton__files_list' => "Stier og mapper",
    'skeleton__archiver_not_installed' => "Kunne ikke udpakke arkivet. Archiver er muligvis ikke installeret på serveren. Kontakt {$PROD_NAME}-administratoren of gå Archiver-softwaren installeret.",
    'skeleton__client_page' => "Administrér skabelon til virtuel host",
    'skeleton__archive_corrupted' => "Arkivkontrollen fandt at arkivfilen enten er ødelagt eller at denne arkivtype ikke understøttes.",
    'skeleton__archive_too_large' => "Arkivkontrollen fandt at arkivfilen er for stor.",
    'skeleton__not_supported_archive_type' => "Denne arkivfiltype (filen %1) er ikke tilladt.",
    'skeleton__upload_archive_file' => "Overfør arkivfil",
    'skin_download__title' => 'Download tema',
    'skin_download_now__title' => 'Tema-download er i gang',
    'skin_download_now__text' => 'Temapakke-oprettelse er i gang.<br>Denne procedure kan vare et stykke tid.<br> Når dialogboksen forsvinder, kan du fortsætte arbejdet med Plesk.',
    'skin_file__help_for_using_types' => "Brug tema-arkiverne i et af følgende formater:",
    'skin_info__title' => 'Temaegenskaber',
    'skin_mng_err__rpm_not_skin' => 'Denne RPM er ikke en Plesk temapakke',
    'skin_mng_err__psa_install_noreloc' => 'Kunne ikke installere rpm-baseret tema det angivne sted.',
    'skin_mng_err__already_exists' => 'Tema-installationsmappen findes allerede, og der er deployeret en tema-pakke.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Den uploadede fil er ikke en gyldig RPM temapakke.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Den uploadede fil er ikke en gyldig temapakke.',
    'skin_mng_err__rpm_upgrade_base' => "Den uploadede fil er ikke en gyldig {$PROD_NAME} temapakke.",
    'skin_mng_err__rpm_upgrade_other' => 'Kunne ikke installere temaet: Ugyldigt temaformat.',
    'skin_mng_err__no_a_skin' => "Den uploadede fil er ikke en gyldig {$PROD_NAME} temapakke.",
    'skin_upload__title' => 'Upload nyt tema',
    'skin_upload__already_exists' => "Temaet '%1' findes allerede.",
    'skin_upload__unable_to_apply' => "Den uploadede fil indeholder ikke et Plesk-tema, eller arkivformatet understøttes ikke.",
    'skin_upload__unable_to_rename__' => "Kunne ikke omdøbe tema %2 to %1: %3.",
    'skin_upload__file_name' => 'Sti til tema-pakkefilen',
    'skins_list__title' => 'Tema-opbevaringsområde',
    'skins_remove__title' => 'Fjernelse af tema',
    'skins_remove__select_skins_for_remove' => 'Vælg de temaer der skal fjernes.',

    'spf__unable_update' => 'Kunne ikke opdatere SPF-parametre',
    'statistics__active_domains' => "Aktive domæner",
    'statistics__clients' => "Kunder",
    'statistics__subdomains' => "Subdomæner",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Databaser",
    'statistics__db_users' => "Databasebrugere",
    'statistics__dirs' => "Beskyttede biblioteker",
    'statistics__dom_active' => "Aktiv",
    'statistics__dom_passive' => "Passiv",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Domæner",
    'statistics__domains_with_host' => "Domæner med hosting",
    'statistics__doms' => "Domæner",
    'statistics__filesystem' => "Filsystem:",
    'statistics__general' => "Generelt",
    'statistics__hdd_available' => "Tilgængeligt",
    'statistics__hdd_capacity' => "Kapacitet",
    'statistics__hdd_total' => "Total",
    'statistics__hdd_usage' => "Harddiskforbrug",
    'statistics__hdd_used' => "Forbrugt",
    'statistics__ip' => "IP-adresse",
    'statistics__key_number' => "Nøglenummer",
    'statistics__l1' => "Seneste 1 minut",
    'statistics__l15' => "Seneste 15 minutter",
    'statistics__l5' => "Seneste 5 minutter",
    'statistics__la' => "CPU-forbrug",
    'statistics__mail_autoresponders' => "Autosvar",
    'statistics__mail_boxes' => "Mailbokse",
    'statistics__mail_groups' => "Mailgrupper",
    'statistics__mail_lists' => "Mailing Lists",
    'statistics__mail_redirects' => "E-mail videresendelse.",
    'statistics__mem' => "Brug af hukommelse",
    'statistics__mem_usage' => "Forbrug",
    'statistics__memory_available' => "Tilgængeligt",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Cachelagret",
    'statistics__memory_free' => "Ledig",
    'statistics__memory_shared' => "Delt",
    'statistics__memory_total' => "Total",
    'statistics__memory_used' => "Forbrugt",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Problemkunder",
    'statistics__problem_domains' => "Problemdomæner",
    'statistics__swap' => "Swap-brug",
    'statistics__swap_free' => "Ledig",
    'statistics__swap_total' => "Total",
    'statistics__swap_usage' => "Forbrug",
    'statistics__swap_used' => "Forbrugt",
    'statistics__system_stat' => "Serveroplysninger",
    'statistics__unable_define_active_doms' => "Antallet af aktive domæner kan ikke bestemmes: %1",
    'statistics__unable_define_inactive_doms' => "Antallet af inaktive domæner kan ikke bestemmes: %1",
    'statistics__failed_define_swap_usage' => 'Kunne ikke definere swap-forbrug',
    'statistics__failed_define_load_averages' => 'Belastningsgennemsnit kunne ikke defineres',
    'statistics__up_time' => "Systemets oppetid:",
    'statistics__ver' => "Version",
    'statistics__web_users' => "Webbrugere",
    'statistics__mem_win' => "Fysisk hukommelsesforbrug",
    'statistics__memory_total_win' => "Total",
    'statistics__memory_used_win' => "Forbrugt",
    'statistics__memory_free_win' => "Tilgængeligt",
    'statistics__swap_win' => "Brug af virtuel hukommelse",
    'statistics__swap_total_win' => "Total",
    'statistics__swap_used_win' => "Forbrugt",
    'statistics__swap_free_win' => "Tilgængeligt",
    'status__domain_has_reasons_to_be_off' => "Domænet er stadig suspenderet af følgende årsag: %1",
    'subdomain__create__' => "Opret et underdomæne under domænet %1",
    'subdomain__edit__' => "Administrér underdomæne : %1",
    'subdomain__invalid_name' => "Ugyldigt underdomænenavn: Brug kun alfanumeriske tegn og bindestreger.",
    'subdomain__incorrect_name' => "Underdomænenavnet er ugyldigt.",
    'subdomains__maillists_enabled_in_domain' => "Forkerte underdomæne-navnelister.%1: Dette domænenavn bruges allerede af mailinglister på domænet %1.",
    'subdomains__dalias_exists' => 'Et domænealias med et sådant navn findes allerede.',
    'subdomains__name_exists' => "Underdomæne med dette navn findes allerede.",
    'subdomains__regular_domain_exists' => "Der findes allerede et domæne med et sådant navn.",
    'subdomains__domain_alias_exists' => 'Et domænealias med et sådant navn findes allerede.',
    'subdomains__remove_subdomains_on_domain' => "Følgende underdomæner på domænet %1 vil blive fjernet:",
    'subdomains__select_subdomains_for_remove' => "Vælg de underdomæner der skal fjernes.",
    'subdomains__webmail_enabled_in_domain' => "Forkert underdomænenavn webmail.%1: Dette domænenavn bruges allerede til adgang til webmail på domænet %1.",
    'subdomains__dns_record_already_exists' => 'Kunne ikke oprette underdomænet %1, da der allerede er en DNS-post der peger på host\'en %1.',
    'subdomains__www_prefix_in_domain' => "Forkert underdomænenavn www.%1: Domænet %1 har allerede WWW-præfiks.",
    'subdomains__user_type_quota_exceeds' => 'Kunne ikke ændre brugerkontoen, fordi dette ville medføre overskridelse af den tildelte diskplads.',
    'subdomains__creation_in_dns_slave' => "Plesks navneserver fungerer som sekundær navneserver for dette domæne. For at dit underdomæne kan oversættes korrekt skal du sikre dig, at zone-filen på den primære DNS-server indeholder posten %1.",
    'sys_user__attributes_not_changed' => "\nFølgende systembruger-attributter blev ikke ændret: %1",
    'sys_user__no_access_without_password' => "Du oprettede ikke en adgangskode. Systembruger vil blive oprettet, men vil ikke kunne logge på systemet før vedkommende har fået en adgangskode. Hvordan vil du fortsætte?",
    'sys_user__no_hard_quota' => "ikke supporteret",
    'sysuser__zero_quota_is_unlimited' => "0 for ubegrænset",
    'template__num_excl_ips' => "Reservér dedikerede IP-adresser til kunden.",
    'template__sel_sh_ips' => "Valgte delte IP-adresser",
    'template__av_sh_ips' => "Delte IP-adresser til rådighed",
    'template__up_to_excl_ip' => "Op til %1 IP-adresser",
    'templates__all_clients' => "alle kunder",
    'templates__cl_domain_templates' => "Skabeloner til %1.",
    'templates__cl_templates' => "Debitorskabeloner",
    'time__invalid_ip' => "Ugyldig IP-adresse eller domænenavn",
    '__please_select_country' => 'Vælg dit land',
    'time__unable_set_time' => "Kunne ikke indstille systemtid: %1",
    'time__sinchronization_setup_error' => 'Kan ikke konfigurere tidssynkronisering: timemng mislykkedes: %1',
    'time__sinchronization_disable_error' => 'Kan ikke deaktivere tidssynkronisering: timemng mislykkedes: %1',
    'tmpl__create' => "Opret skabelon",
    'tmpl__edit__' => 'Skabelon: %1',
    'tmpl__logrotation_warn' => "Logrotation på domænet der er oprettet vha. denne skabelon vil kun blive udført i tilfælde af at der efterfølgende oprettes fysisk hostingkonto for det.",
    'tmpl__name' => "Skabelonnavn",
    'tmpl__dom_exist' => "En domæneskabelon med et sådant navn findes allerede i administratorens eller kundens skabelonpulje.",
    'tmpl__name_invalid' => "Skabelonnavnet er ugyldigt eller tomt.",
    'tmpl__use_next_ip_addr' => "Næste ledige IP-adresse vil blive anvendt",
    'tmpl_name_already_exists' => "Der findes allerede en komponent med navnet '%1'.",
    'traffic__no_periods_found' => "Kunne ikke vise web- og trafikstatistik. Denne funktion vil kun være til rådighed efter næste statistikberegning.",

    'vh_based__no_free_ip_for_vh' => "Der er ingen ledige IP-adresser til IP-baseret virtuel hosting. Tilføj venligst en IP-adresse.",

    'wu__at_domains_text' => "Tillad adgangsformatet webbruger@%1",
    'wu__unable_create' => "Kunne ikke oprette webbruger: %1.",
    'wu_edit__disk_quota' => "Diskkvote",
    'wu_edit__invalid_pass' => "Adgangskoden er ugyldig:",
    'wu_edit__invalid_quota' => "Den angivne diskpladskvote er ugyldig. Skriv et positivt heltal.",
    'wu_edit__invalid_quota_value' => "Den angivne diskpladskvote er mindre end den aktuelt anvendte (%1MB). Nogen funktionalitet kan blive utilgængelig. Er du sikker på, at du vil fortsætte?",
    'wu_edit__not_create_pass' => "Denne handling vil ikke oprette en adgangskode til den nye webbruger. \nUden adgangskode vil brugeren ikke kunne logge på.",
    'wu_edit__unable_update' => "Kunne ikke opdatere egenskaber for webbruger: %1.",

    'bt_webdirs' => 'Virtuelle mapper',

    'dns__tabs_general' => 'Zoneindstillinger',
    'dns__tabs_zone_settings' => 'SOA-poster',
    'soa__seconds' => 'sekunder',
    'soa__minutes' => 'minutter',
    'soa__hours' => 'timer',
    'soa__days' => 'dage',

    'DomainSubdirectory' => 'Destinations-undermappe',

    'filemanager__select_codepage' => 'Vælg codepage:',

    'bt_server_app_add' => 'Tilføj serverprogram',
    'packages_list' => 'Serverprogrammer',

    'bt_packages_management' => 'Administration af pakker',
    'pb__packages_management' => 'Applikationsadministration',
    'bt_package_new' => 'Tilføj program',
    '__packages' => 'Serverprogrammer',

    'dom_ctrl__mysql_dbase_space' => 'Total MariaDB/MySQL databasekvote',
    'dom_ctrl__mssql_dbase_space' => 'Total MS SQL database-kvote',

    'dns_add__enter_ixfr_path' => 'Angiv IXFR-sti',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT-posten findes allerede. Der kan kun være én SPF-post. Du kan tilføje en post ved at slette den eksisterende post først.',

    'component_name__network' => 'Networking',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Indstil tema',
    'bt_set_skin' => 'Indstil tema',
    'firewall__rule_already_exists' => 'Regel med navnet "%1" findes allerede',
    'firewall__rule_readonly' => 'Reglen "%1" er skrivebeskyttet',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Filplaceringen er ugyldigt.',

    'error_doc__erorr_invalid_url_location' =>  'Forkert URL-format Indtast en absolut URL-adresse på den virtuelle host (webstedet).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Antivirusbeskyttelse',
    'antivirus__antivirus_direction_off' => 'Deaktiveret',
    'antivirus__antivirus_direction_any' => 'Indkommende og udgående e-mail',
    'antivirus__antivirus_direction_from' => 'Kun Udgående e-mail',
    'antivirus__antivirus_direction_to' => 'Kun Indgående e-mail:',
    'antivirus__unable_to_update_settings' => 'Kunne ikke ændre antivírus-indstillinger: %1.',




    '__normal' => 'Normal',
    '__low' => 'Lav',
    '__high' => 'Høj',

    'mail__antivirus' => "Interne e-mail serveres antivirus",
    'mail__use_internal_antivirus' => 'Brug intern antivirus',

    'sa__tabs_blacklist' => 'Sortlist',

    '__mysql_databases' => 'MariaDB/MySQL-databaser',

    'cl_perm__mysql_dbase_space' => 'Total MariaDB/MySQL databasekvote',
    'cl_perm__mssql_dbase_space' => 'Total MS SQL database-kvote',
    'cl_perm__max_mssql_db' => 'Maksimalt antal Microsoft SQL Server-database',
    'cl_perm__total_mboxes_quota' => 'Total mailbokse-kvote',

    'i_i_cl_on' => 'Kundekontoen er aktiv.',
    'i_i_cl_off_by_admin' => 'Kundens konto er suspenderet af administrator.',

    'sa_exists_tn' => 'netværket findes allerede på listen.',

    'webdir__select_mime_types_to_remove' => 'Vælg de MIME-typer du vil fjerne.',

    'defaultcomponents__not_activated' => 'ikke aktiveret',

    'bt_traffic_at_domains' => 'Trafik',

    '__awstats_perl_warning' => 'Uden Perl installeret vil AWStats ikke tillade brugerne at kontrollere statistik for tidligere år.',

    'class_client__mysql_dbase_space' => 'Værdien overskrider kundens begrænsning.',
    'class_client__mssql_dbase_space' => 'Værdien overskrider kundens begrænsning.',
    'class_client__max_mssql_db' => 'Værdien overskrider kundens begrænsning.',

    'dns__remove_transfer_restrictions_list_items' => 'Følgende netværk vil blive fjernet fra adgangskontrollisten:',

    'bt_up' => "Op",
    'bt_down' => "Ned",
    'virtualdir__type_default_doc_name_to_add' => 'Indtast et filnavn for at føje det til listen',
    'virtualdir__select_default_doc_to_remove' => 'Vælg de filer der skal fjernes fra listen.',
    'virtualdir__select_directory' => 'Vælg et bibliotek',

    'bt_install_selected' => 'Installer markerede licensnøgler.', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Domænet oversættes til en anden IP-adresse (%1). Ret venligst DNS-indstillingerne.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Den e-mail server der i øjeblikket anvendes understøtter ikke at både mailboks og e-mail grupper er aktiveret samtidig. Klik på OK for at aktivere mailboksen på bekostning af, at e-mail grupper deaktiveres. Klik på Annuller for at efterlade alt intakt.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Den e-mail server der i øjeblikket anvendes understøtter ikke at både mailboks og e-mail grupper er aktiveret samtidig. Klik på OK for at aktivere e-mail grupper på bekostning af, at mailboksen deaktiveres. Klik på Annuller for at efterlade alt intakt.',

    'mysql_dbase_space_limit' => 'MariaDB/MySQL databasepladsgrænse',
    'mysql_dbase_usage' => 'MariaDB/MySQL databasepladsanvendelse',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server Database pladsgrænse',
    'mssql_dbase_usage' => 'Microsoft SQL Server Database pladsgrænseanvendelse',

    '__statistics' => "statistik", //indirect

    'dns__soa_minimum_value_is_big' => 'Indstilling af Minimum TTL-værdien til mere end 3 timer kan gøre dine domæner utilgængelige for nogle af domæneadministratorerne. Det anbefales kun at indstille en sådan værdi, hvis din domænenavns-registrator insisterer på det.',

    'virusfilter__interface_not_available' => 'Ingen virusfiltre er til rådighed.',
    'virusfilter__none_virus_filter' => 'Ingen',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'deaktiveret',
    'virusfilter__status_any' => 'indkommende og udgående e-mail',
    'virusfilter__status_outgoing' => 'Kun udgående e-mails',
    'virusfilter__status_incoming' => 'kun indkommende e-mails',

    'visibility__root_override_parse_error' => 'Der er en syntaksfejl i filen %1 på linje %2.',

    'sb__not_support_publishing_api' => "Udgivelsesautomatisering er ikke understøttet af komponenten",

    'component_name__cphosting' => "Plesk Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Indstilling af mailbokskvote understøttes ikke af den nuværende e-mail server.',
    '__unable_get_total_mboxes_quota' => 'Indstilling af mailbokskvote understøttes ikke af den nuværende e-mail server.',

    'install_prefix__parent_not_exists' => "Den overordnede mappe findes ikke.",

    'bt_change_version' => 'Skift version',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Vælg alle",
    '__uncheck_all' => "Ryd alle",

    'dns__editing_domain_controller_zone' => "Redigering af DNS-zone poster for domænecontroller kan medføre problemer med domænets funktion",

    'pb__interface_management' => "Administration af grænseflade",
    'interface_management__tabs_skins' => "Tema",
    'interface_management__tabs_interface_templates' => "Grænsefladeskabeloner",
    'interface_management__tabs_locales' => "Localer",
    'locales_list__title' => "Opbevaringsområde for sprogpakke",
    'locales_list__legend' => "Tilgængelige sprog",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Sprogpakke",
    'locales_list__lang_title' => "Sprog",
    'locales_list__country_title' => "Land",
    'locales_list__used_title' => "Forbrugt",

    'backup__suspend_warning_during_backup' => "Domænet vil ikke være til rådighed under sikkerhedskopieringsprocessen",
    'backup__suspend_warning_during_restore' => "Domænet vil ikke være til rådighed under gendannelsesprocessen",
    'backup__suspend_domain' => "Suspendér domænet",

    'locales_list__mls_limit' => "Din nuværende Plesk-licens tillader brug af %2 sprog. I øjeblikket har du %1 sprog indstillet som til rådighed for brugerne. Dette antal overstiger det antal, der er givet i licensen. Vælg %2 sprog, du vil bruge, og gør resten utilgængelig for brugerne ved at klikke på deres ikoner i kolonnen 'S'.",

    'bt_change_owner' => 'Tilknyt en ny ejer',
    'chown__new_owner' => 'Ny ejer',
    'chown__selected_domains' => 'Valgte abonnementer',
    'chown__limits_legend' => 'Resurser',
    'chown__limit_name' => 'Resursenavn',
    'chown__limit_value' => 'Allokerede ressourcer',
    'chown__limit_assigned_before' => 'Inden overførsel',
    'chown__limit_assigned_after' => 'Efter overførsel',
    'chown__error_limits' => "Kunne ikke fortsætte abonnementsoverførslen: Dette abonnement kræver flere ressourcer end der kan leveres af den nye ejers udbyder.",
    'chown__error_no_domains' => 'Kunne ikke fortsætte abonnementsoverførslen: Enten var der ikke valgt et abonnement, eller de valgte abonnementer hører allerede til mål-brugeren.',
    'chown__error_empty_ip_pool' => "Kunne ikke fortsætte abonnementsoverførslen: IP-gruppen hos den nye ejers udbyder er tom. Kontrollér, at udbyderen mindst har én IP-adresse i puljen.",
    'chown__please_select_new_domain_owner' => 'Vælg ny ejer af dette abonnement',
    'chown__old_ip_address' => 'Nuværende IP-adresse:',
    'chown__new_ip_address' => 'Ny IP-adresse',

    'chown__error_ssl_already_used' => "SSL/TLS-understøttelse bruges allerede på følgende destination IP 'er: %1 Derfor kunne følgende domæner med SSL/TLS-understøttelse ikke overføres: %2. Løs problemet og prøv igen",
    'chown__sitebuilder_not_installed' => 'Presence Builder er ikke installeret',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domænet %1 kan ikke overføres til en anden ejer, fordi Presence Builder ikke er installeret.',

    'backup__backup_time' => 'Sikkerhedskopieringstid',
    'backup__backup_time_hour' => 'timer',
    'backup__backup_time_minute' => 'minutter',
    'backup__every' => 'hver',
    'backup__day_of_month' => 'dag i måneden',

    'subdomain__select_hst_type' => 'Vælg hostingtype for underdomænet',
    'hst_sel__subdom_subfolder_hst' => 'Underdomæne i undermappe.',
    'subdomain__www_root_folder_not_exists' => 'Webstedets startmappe %1 findes ikke.',
    '__site_home_dir' => 'Startmappe for websted',
    'subdomain__aspnet_disabled_domain' => 'deaktiveret af domæne',

    'domains__remove_description' => 'Alle domænedata, inklusive domænet og respektive underdomæner, indhold og indstillinger, webprogramdata, mailboksindhold, e-mail-, antivirus- og spamfilter indstillinger, logfiler, domæne-sikkerhedskopi opbevaringsområdedata og SSL/TLS-certifikater vil blive slettet. Hvis du ikke har en sikkerhedkopi fil på din lokale maskine, vil alle data permanent gå tabt.',
    'subdomains__remove_description' => 'Alle underdomænedata, inklusive underdomæneindhold og indstillinger, webprogramdata og logfiler vil blive slettet. Hvis du ikke har en sikkerhedkopi fil på din lokale maskine, vil alle data permanent gå tabt.',

    'mail__tabs_spam_filtering' => 'Spamfiltrering',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Brug standard server-brede indstillinger (scan)',
    'antivirus__use_server_settings_no_scan' => 'Brug standard server-brede indstillinger (scan ikke)',
    'antivirus__check_for_viruses' => 'Scan efter vira.',
    'antivirus__dont_check_for_viruses' => 'Scan ikke efter vira.',
    'antivirus__incoming_mail' => 'Indkommende e-mail',
    'antivirus__outgoing_mail' => 'Udgående mail',

    'domain_alias__CNAME_dns_record_exists' => 'En DNS CNAME-post med dette navn findes allerede',
    'domain_alias__A_dns_record_exists' => 'En DNS A-post med dette navn findes allerede',
    'domain_alias__bad_prefix' => 'Forkert præfiks for domænealias',
    'domain_alias__domain_doesnt_exist' => "Domænet findes ikke",

    'dns__zone_ttl_message_info' => 'Hvis TTL-værdien ikke er angivet, vil TTL-værdien i SOA Record skabelonen (%1) blive brugt for denne DNS-post.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "En fil med navnet index.html oprettes til omdirigering til det markerede webprogram. Hvis der allerede findes en fil ved navn index.html, vil den blive sikkerhedskopieret som index.html.old og erstattet med den nye. Tryk på OK for at bekræfte.",

    'bt_ftp_ctrl' => "Ekstra FTP-konti",
    'ftp_users_no_permission' => "Du har ikke rettigheder til at administrere FTP-konto for dette domæne.",
    'ftp_users_limit_reached' => "FTP-kontogrænsen er nået for dette domæne",
    'pb__ftp_ctrl' => "FTP-administration",
    'class_client__max_subftp_users' => "Ekstra FTP-konti",

    '__client_form_settings' => "Brugerdefinerede indstillinger",
    '__sbnet_client_keep_sbnet' => "Bevar den korresponderende brugerkonto i Presence Builder",
    '__sbnet_cant_add_more_sites' => "Grænsen for mængden af websteder der kan bruge Presence Builder er nået for denne kunde",
    '__sbnet_legend_text' => "Integration af Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Opret en korresponderende brugerkonto i Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Du forsøger at fjerne den Presence Builder-brugerkonto der er knyttet til denne kunde. Dette vil slette alle brugerens websteder og alle andre relevante indstillinger fra Presence Builder-systemet, fjerne muligheden for at redigere eksisterende websteder gennem Presence Builder, også selvom du senere atter aktiverer denne mulighed. Hvis du opretter en Presence Builder-brugerkonto igen senere, skal du oprette og udgive alle dine websteder helt fra bunden. Vil du deaktivere webstedsoprettelse og -udgivelse gennem Presence Builder?",
    'sb__build_site_with_subdomains' => "Opret Blog og Fotogalleri underdomæner",
    '__sbnet_client_dont_have_sbuser' => "Kan ikke oprette og udgive websted vha. Presence Builder: Presence Builder-bruger findes ikke",

    '__component_disabled' => "Komponent er deaktiveret",

    'subdomains__physical_path_not_exist' => "Der er underdomæner mapper som er kædet sammen med ikke-eksisterende fysiske mapper.",

    'dnsserver_bind_to_msdns_switching_warning' => "Advarsel: Kun de første 254 IP-adresser på undernet med /8 og /16 masker, placeret på listen Adgangskontrol vil blive overført. De vil blive overført som separate IP-adresser. Vil du fortsætte?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder-websteder kan kræve ASP.NET 2.0-understøttelse på dit domæne. Det anbefales, at du aktiverer ASP.NET 2.0-understøttelse, hvis du bruger Presence Builder.",

    'subdomain_auto_create_dir' => "Opret fysisk mappe til underdomæne",

    'sa_trainer__unable_to_get_messages_list' => "Kunne ikke hente listen over meddelelser i mailboksen: %1",
    'sa_trainer__pass_doesnt_exist' => "Adgangskoden til denne e-mail konto er mangler.",

    '__sitebuilder_error' => "Der opstod fejl under forsøg på at oprette forbindelse til Presence Builder. Kontakt serviceudbyderen for at få hjælp.",
    'wsb_error_user_not_exist' => "Presence Builder-brugerkonto findes ikke.",
    'wsb_error_site_already_exist' => "Dette websted findes allerede i Presence Builder.",
    'wsb_error_site_limit_reached' => "Grænsen for antallet af Presence Builder websteder blev nået.",
    'wsb_error_internal_error' => "Intern Presence Builder-fejl opstod: \n%1 Kontakt serviceudbyderen for at få hjælp.",
    'wsb_error_user_already_exist' => "Presence Builder-bruger med dette navn findes allerede i Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder-bruger findes ikke.",
    'wsb_error_object_not_found' => "Presence Builder kunne ikke finde den korrekte host-henvisning.",

    'mg_no_mail_groups' => "Ingen e-mail grupper",

    'drweb__drweb_incoming' => 'Antivirus kontrol af indkommende e-mail',
    'drweb__drweb_outgoing' => 'Antivirus kontrol af udgående e-mail',
    'drweb__disable_reason_serv' => 'E-mail serveren understøtter ikke antivirus-filterindstillinger på mailboksniveau',

    'vz_sitebuilder3_client_cant_be_created' => "Kan ikke oprette kundekonto: SiteBuilder version 3.1 eller senere er ikke installeret",

    'chown__client_without_sitebuilder_support' => "Kunne ikke fortsætte abonnementsoverførsel: Presence Builder-service er ikke inkluderet i den nye ejers eller udbyders serviceplan.",

    // new limits

    'class_client__max_odbc' => "ODBC-tilslutninger",
    'cl_perm__max_odbc' => "Maksimalt antal af ODBC-forbindelser.",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Domænets aliasnavn',
    'domain_alias__list_ascii_name' => 'I ASCII-format',


    // Interface Customization Templates
    'interface_preferences' => 'Administration af grænseflade',
    'pb__interface_templates' => 'Administration af grænseflade',
    'pb__interface_clients' => 'Kunder bruger %1',

    // service management
    'bt_service_showall' => "Vis alle",
    'bt_service_hideall' => "Skjul alle",
    'bt_service_start' => "Start",
    'bt_service_stop' => "Stop",
    'bt_service_restart' => "Genstart",
    'bt_service_disable' => "Slå fra",
    'bt_service_manual' => "Manuel",
    'bt_service_auto' => "Auto",
    'service_startup_auto' => 'Automatisk',
    'service_startup_manual' => 'Manuel',
    'service_startup_disabled' => 'Deaktiveret',
    'service_action_ok' => "Handlingen med %1 service blev korrekt gennemført",
    'service_action_failed_disabled_service' => "Kunne ikke gennemføre handlingen med %1 service fordi den er deaktiveret",
    'service_action_failed_error' => "Kunne ikke gennemføre handlingen: %1.",
    'service_group_action_ok' => "Handlingen med følgende services blev korrekt gennemført: \n %1",
    'service_group_action_disabled' => "Kunne ikke gennemføre handlingen med følgende services fordi de er deaktiverede. \n %1",
    'service_group_action_failed' => "Kunne ikke gennemføre handlingen med følgende services: \n %1. \n Du kan få detaljerede oplysninger om fejlen ved at udføre handlingen med de enkelte service separat",

    // php 4vs5
    'bt_php' => "PHP-indstillinger",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Forhandlere til rådighed',
    'massmail__resellers_list_selected' => 'Udvalgte forhandlere',
    'massmail__clients_list_available_for_select' => 'Kunder til rådighed',
    'massmail__clients_list_selected' => 'Udvalgte kunder',
    'massmail__advanced' => 'Avanceret',
    'bt_massmail_send' => 'Send',
    'massmail__save_template_name' => 'Gem tekst i en ny skabelon ved navn',
    'massmail__template' => 'Skabelon',
    'massmail__compose_mail' => 'Besked',
    'massmail__from' => 'Fra',
    'massmail__to' => 'Til',
    'massmail__subject' => 'Emne',
    'massmail__body' => 'Beskedtekst',
    'massmail__body_hint' => 'Brug variablen <name> til automatisk at indsætte brugerens navn i din meddelelse.',
    'massmail__send_to_clients' => "Kunder",
    'massmail__send_to_domainusers' => "Domæneadministratorer",
    'massmail__send_to_admins' => "Plesk-administratorer",
    'massmail_select' => 'Vælg adresser',
    'massmail_showhide_selected' => "Vis/skjul markerede",
    'massmail_send_all' => "Alle",
    'massmail_send_selected' => "Kun markerede",
    'massmail_send_except' => "Alle bortset fra markerede",
    'bt_new_mass_mail_template' => "Tilføj masse-e-mail skabelon",
    '__mass_mail_templates_list' => "Liste over masse e-mail meddelelsesskabeloner",
    'massmail__template_name' => 'Skabelonnavn',
    'massmail__receivers' => 'Modtagere',
    'massmail__created' => 'Afsender',
    'massmail__date_created' => 'Oprettelsesdato',
    'massmail__compose' => 'Send',
    'mass_mail__resellers_all' => 'Alle forhandlere',
    'mass_mail__clients_all' => 'Alle kunder',
    'mass_mail__domainusers_all' => 'Alle domæneadministratorer',
    'mass_mail__resellers_selected' => 'Udvalgte forhandlere',
    'mass_mail__clients_selected' => 'Udvalgte kunder',
    'mass_mail__domainusers_selected' => 'Udvalgte domæneadministratorer',
    'mass_mail__resellers_except' => 'Alle forhandlere bortset fra de markerede',
    'mass_mail__clients_except' => 'Alle kunder bortset fra de markerede',
    'mass_mail__domainusers_except' => 'All domæneadministratorer bortset fra de markerede',
    'mass_mail__admins_all' => 'Alle administratorer',
    'massmailtemplateslist__title' => 'Masse e-mail meddelelses-skabeloner',
    'massmail__insert_from_template' => "Indsæt data fra skabelon",
    'massmail__select_template' => "Vælg skabelon",
    'massmail__body_short_hint' => "(kun almindelig tekst)",
    'massmail__from_short_hint' => "(e-mail eller navn)",
    'bt_insert' => "Indsæt",
    'massmail__mail_send_successfully' => "Meddelelsen blev udsendt korrekt.",
    'massmail__mail_send_successfully_with_some_errors' => "Meddelelsen blev udsendt, men der opstod flere fejl. Nogle af modtagerne har muligvis ikke modtaget meddelelsen. For yderligere information, se følgende logfil: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Meddelelsen blev ikke udsendt. Sørg for at mindst én modtager er valgt, og at Plesks e-mail server fungerer korrekt. For yderligere information, se følgende logfil: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Data fra skabelonen %1 blev korrekt indsat.",
    'massmail__template_added_successfully' => "Meddelelsesskabelonen blev gemt under navnet %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder-databasefejl opstod. Kontakt serviceudbyderen for at få hjælp.",
    'wsb_error_sitebuilder_access_denied_error' => "Kunne ikke få adgang til filen: Presence Builder har ikke adgangsrettigheder til den nødvendige fil eller mappe. Kontakt serviceudbyderen for at få hjælp.",
    'wsb_error_sitebuilder_connection_failed' => "Kunne ikke tilslutte til Presence Builder, da forbindelsen blev afbrudt. Kontakt serviceudbyderen for at få hjælp.",
    'wsb_error_critical_during_operation' => "Der opstod en kritisk Presence Builder-fejl: \n%1",
    'wsb_error_license_during_operation' => "Presence Builder-licensfejl opstod: \n%1",
    'wsb_error_during_operation' => "Presence Builder-fejl opstod: \n%1",
    'wsb_error_license_error' => "Der opstod en Presence Builder licensbegrænsning.",

    // Other
    '__confrim_service_stop' => "Advarsel! Hvis du stopper servicen %1, kan Plesk holde op med at fungere. Er du sikker på, at du vil stoppe servicen %1?",
    'virtualdir__name_is_reserved' => "Dette navn er reserveret",
    'index_redirect_help_text' => 'Du vil nu automatisk blive omdirigeret til det nødvendige websted. Hvis din browser ikke understøtter omdirigering, bedes du klikke %1 her %2',
    'bt_default_settings' => "Gendan standardindstillinger",
    'logfiles__remove_failed' => "Kunne ikke slette filen %1: Filen er låst af et andet program. Forsøg igen senere.",
    'subdomain__invalid_homedirectory' => "Start-mappen for det angivne underdomæne er ugyldig",
    'scheduler_item__empty_filename' => "Angiv den exe-fil der skal køres",
    'subdomains__overlapped_domain_exists' => 'Underdomæne overlappes af DNS-zone for domænet %1',
    'subdomains__overlapped_domain_alias_exists' => 'Underdomæne overlappes af DNS-zone for domænealias %1',
    'services_action_none_selected' => 'Kunne ikke gennemføre handlingen: Vælg de ønskede services',
    'cl_perm__max_subftp_users' => "maksimalt antal ekstra FTP-konti",
    'login_up__access_denied_no_cp_access' => 'Adgang nægtet. Du har ikke tilladelse til at tilgå Plesk.',
    'drweb__disable_reason_admin' => "Antivirus-filterindstillinger på mailboks-niveau er ikke tilladt pga. serverpolitikken.",

    'webdirs__name_is_invalid' => 'Brug kun alfanumeriske tegn, understregninger og bindestreger i mappenavnet.',
    'webdirs__physical_path_is_invalid' => 'Den fysiske sti er ugyldig eller findes ikke',
    '__use_default' => 'Benyt standard',

    'webalizer_hidden_referrer__already_exist' => 'En sådan post findes allerede.',
    'webalizer_group_referrer__already_exist' => 'Der findes allerede en gruppehenviser med dette navn.',

    'pb__dashboard' => 'Forside',

    'server_interface__page_title' => 'Indstillinger for server-brugergrænseflade',
    'server_interface__tabs_locales' => 'Localer',
    'server_interface__tabs_skins' => 'Tema',
    'server_interface__tabs_interface_templates' => 'Grænsefladeskabeloner',
    'bt_server_interface' => 'Grænsefladeindstillinger',
    'pb__server_interface' => 'Grænsefladeindstillinger',

    'bt_wizard_next' => 'Næste >>',
    'bt_wizard_prev' => '<< Tilbage',

    '__limit_exceeded_max_dom_server' => 'Du kan ikke være host for flere domæner på denne server, fordi licensnøglens grænse for antal domæner på serveren blev nået. Kontakt din serviceudbyder for at løse dette problem.',
    '__limit_exceeded_max_subdom_server' => 'Du kan ikke være host for flere underdomæner på denne server. Kontakt din udbyder.',
    '__limit_exceeded_max_dom_aliases_server' => 'Du kan ikke opsætte flere domænealiasser på denne server. Kontakt din udbyder.',
    '__limit_exceeded_max_wu_server' => 'Du kan ikke oprette flere webbrugere, fordi licensnøglens begrænsning af antallet af webbrugere på serveren blev nået. Kontakt din serviceudbyder for at løse dette problem.',
    '__limit_exceeded_max_mn_server' => 'Du kan ikke oprette flere e-mail konti, fordi licensnøglens begrænsning af antallet af e-mail konto på serveren blev nået. Kontakt din serviceudbyder for at løse dette problem.',

    '__limit_exceeded_max_cl_useradmin' => 'Du har nået grænsen for det antal kundekonti, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_dom_useradmin' => 'Du har nået grænsen for det antal domæner, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_subdom_useradmin' => 'Du har nået grænsen for det antal underdomæner, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Du har nået grænsen for det antal domænealias ser, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_disk_space_useradmin' => 'Der er ikke mere ledig diskplads',
    '__limit_exceeded_max_wu_useradmin' => 'Du har nået grænsen for det antal webbrugerkonti, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_db_useradmin' => 'Du har nået grænsen for det antal databaser, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_box_useradmin' => 'Du har nået grænsen for det antal mailbokse, ser, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_mn_useradmin' => 'Du har nået grænsen for det antal e-mail konti, der er defineret i din licensnøgle (%2).',
    '__limit_exceeded_max_maillists_useradmin' => 'Du har nået grænsen for det antal mailinglister, der er defineret i din licensnøgle (%2).',

    '__limit_exceeded_max_dom_userclient' => 'Du har nået grænsen for antal domæner (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Du har nået grænsen for antal underdomæner (%2) der tillades af din serviceudbyder.',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Du har nået grænsen for antallet af domænealiasser (%2).',
    '__limit_exceeded_disk_space_userclient' => 'Du har nået grænsen for det tilladte diskpladsforbrug (%2).',
    '__limit_exceeded_max_traffic_userclient' => 'Du har nået grænsen for båndbreddeanvendelse pr. måned (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Du har nået grænsen for antal webbrugere (%2) der tillades af din serviceudbyder.',
    '__limit_exceeded_max_db_userclient' => 'Du har nået grænsen for antal databaser (%2)',
    '__limit_exceeded_max_box_userclient' => 'Du har nået grænsen for antal mailbokse (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Du har nået grænsen for antal mailinglister (%2)',
    '__limit_exceeded_expiration_userclient' => 'Din konto udløber d. %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Du har nået grænsen for antal underdomæner (%2) der tillades af din serviceudbyder.',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Du har nået grænsen for antallet af domænealiasser (%2).',
    '__limit_exceeded_disk_space_userdomain' => 'Du har nået grænsen for det tilladte diskpladsforbrug (%2).',
    '__limit_exceeded_max_traffic_userdomain' => 'Du har nået grænsen for båndbreddeanvendelse pr. måned (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Du har nået grænsen for antal webbrugerkonti (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Du har nået grænsen for antal databaser (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Du har nået grænsen for antal mailbokse (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Du har nået grænsen for antal mailinglister (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Din konto udløber d. %2',

    'mmt__to_none' => 'Ingen',
    'mmt__to_admin' => 'Administrator',
    'mmt__to_resellers_all' => 'Alle forhandlere',
    'mmt__to_resellers_select' => 'Udvalgte forhandlere',
    'mmt__to_resellers_select__available' => 'Forhandlere til rådighed',
    'mmt__to_resellers_except' => 'Alle forhandlere bortset fra de markerede',
    'mmt__to_clients_all' => 'Alle kunder',
    'mmt__to_clients_select' => 'Udvalgte kunder',
    'mmt__to_clients_select__available' => 'Kunder til rådighed',
    'mmt__to_clients_except' => 'Alle kunder bortset fra de markerede',

    'mmt__unable_send_empty_selection' => 'Kunne ikke sende masse e-mail: Ingen e-mailadresser valgt.',
    'mmt__unable_send_to__' => 'Kunne ikke sende masse e-mail til:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Kunne ikke validere webprogrammet fordi én af de nødvendige filer (%1) ikke blev fundet. Kontakt den tekniske supportafdeling for at få hjælp.',
    'sapp_error_validation_spec_failed' => 'Det uploadede webprogram er ikke i overensstemmelse med AppPacks-specifikationerne: %1.',
    'sapp_error_validation_register' => 'Kunne ikke registrere webprogrammet der er placeret i mappen "%1": %2. Du bør fjerne webprogrammet fra serveren, da det ikke vil fungere korrekt.',

    'sapp__install_failed' => 'Webprogram-installationen mislykkedes: %1',
    'sapp__install_res_failed' => 'Kunne ikke oprette den omhandlede ressource.',

    'server_preferences__subdomains_blog_and_photo' => 'Opret Blog og Fotogalleri underdomæner som standard',
    'plesk_key__blog_and_photo' => 'Afkrydsningsfeltet Mulighed for at administrere standardtilstand for Opret blog og Fotogalleri underdomænerne',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Kunne ikke ændre IP-adressetypen til dedikeret, da den er knyttet til mere end én bruger.',

    // 8.1.1

    '__write_modify_warning' => 'Valg af yderligere skrive/ændringstilladelser vil få nogle webprogrammer til at fungere korrekt, men det vil også væsentligt øge sikkerhedsrisikoen',
    '__write_modify_subdomain_warning' => 'Valg af yderligere skrive/ændringstilladelser vil få nogle webprogrammer til at fungere korrekt, men det vil også væsentligt øge sikkerhedsrisikoen',

    'phosting__php_incorrect_version_used' => "PHP-versionsproblemer blev fundet. Du kan løse disse problemer ved at markere afkrydsningsfeltet med en ønskede PHP-version herunder og klikke på OK. Du kan deaktivere PHP på dette domæne ved at klikke på OK uden at vælge PHP-version",
    'fp__mail_preferences' => 'E-mail indstillinger',

    'mail__invalid_white_pattern' => 'Den angivet værdi er ugyldig. Brug følgende formater: mail@eksempel.com til e-mailadresser, eksempel.com for domæner.',
    'mail__invalid_black_pattern' => 'Den angivet værdi er ugyldig. Brug følgende format: mail@eksempel.com til e-mail adresser, eksempel.com for domæner.',

    'resp_edit__reply_as_html' => 'Send som HTML',
    'exception__path_very_long' => "Stien er for lang. Sørg for, at der er færre end %1 tegn i stien.",

    // 8.2


    //SAPP
    'sapp_on' => 'Aktiveret',
    'sapp_off' => 'Deaktiveret',
    'sapp_directive_aspect' => 'Obligatorisk',
    'sapp_databases_num' => 'Databaser',
    'sapp_db_required' => 'Obligatorisk',
    'sapp_Required' => 'Obligatorisk',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'Database-ID',
    'sapp_db_id_type' => 'DB (id: %1) type',
    'sapp_db_id_min_version' => 'DB (id: %1) min version',
    'sapp_db_id_table_prefix' => 'DB (id: %1) tabelpræfiks',
    'sapp_Default' => 'Standardværdi',
    'sapp_apache_mod_req' => 'Apache-modul',
    'sapp_dbtype_not_installed' => 'ikke installeret',
    'sapp_apache_mod_not_installed' => 'ikke installeret',
    'sapp__value_error_empty' => 'Tom værdi er ikke tilladt.',
    'sapp_error_invalid_type' => 'Programmet "%1" understøtter ikke den ønskede handling.',
    'sapp_error_unknown_app_type' => 'Ikke-understøttet programtype: %1',
    'sapp__ssl_text' => 'Installér programmet på "http://" or "https://" virtuel host?',
    'sapp__app_to_upgrade' => 'Programmer der skal opgraderes',
    'sapp__upgrade_apps_title' => 'Opgradér programmer',
    'sapp__upgrade_to_ver' => 'Opgrader til version',
    'sapp__choose_pkg_ver' => 'Vælg en pakke...',
    'sapp__pkg_cant_upgrade_pkg' => 'Pakken "%1" kan ikke bruges til opgradering af webprogrammet "%2".',
    'sapp__app_ugrade_error' => 'Kunne ikke opgradere programmet %1. Kontakt systemadministratoren.',
    'sapp__no_suitable_db_found' => 'Ingen egnet database fundet.',
    'sapp__upgrade_success' =>  'Programmet blev opgraderet korrekt.',
    'sapp__pkg_info_changelog' => 'Ændringshistorik',
    'sapp_requirement_legend' => 'Hosting-funktioner der kræves af programmet',

    // other
    'bt_apply' => 'Anvend',
    'mn_edit__add_alias_if_mailbox_disabled' => 'For at kunne oprette et e-mail alias skal mailboksen aktiveres for denne e-mail konto. Vil du aktivere mailboksen?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Deaktivering af mailboksen vil fjerne e-mail aliasser, da de vil holde op med at fungere. Vil du deaktivere mailboksen?',
    'antivirus__disable_reason_install' => 'Du kan ikke administrere antivirus, fordi dette ikke er installeret.',
    'antivirus__disable_reason_key' => 'Du kan ikke administrere antivirus, da dette ikke er aktiveret vha. en korrekt licensnøgle.',
    'antivirus__disable_reason_deny_personal_settings' => 'Du kan ikke administrere antivirus, da serverpolitikken forbyder individuelle antivirus-indstillinger.',
    'change_foreign_user_password' => 'Skift adgangskode',
    'change_foreign_user_password_hint' => "Brugeren tilhører ikke dette program. Klik på linket for at skifte til et andet program og redigér brugerens adgangskode der. For at kunne gøre dette skal du have de relevante rettigheder i programmet.",
    'cf_url_text' => 'JDBC-URL',
    'cf_sendStringParametersAsUnicode_text' => 'Strengformat',
    'lang_unknown' => 'Ukendt sprog',
    'pb__cl_ed' => 'Kundeoplysninger',
    'pb__actionlog' => 'Handlingslog',
    'pb__cl_limits' => 'Kundegrænser',
    'pb__edit' => 'Rediger',
    'pb__subdom_edit' => 'Hosting-indstillinger',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Sikkerhedskopiér mailboksenes indhold',

    'maillist_import_result' => "\nDen totale mængde e-mail adresser i filen: %1 \nmængden af importerede e-mail adresser: %2 \nmængden af allerede eksisterende e-mail adresser: %3 \nmængden af dublerede e-mail adresser i angiven fil: %4 \nmængden af ugyldige e-mail adresser i filen: %5",
    'maillist_import_error' => 'Kunne ikke importere e-mail adresselisten',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Den fil, du valgte, er enten tom eller ikke et gyldigt HTML-dokument i den valgte kodning. Væld den korrekte kodning eller føj ganske enkelt indhold til filen.",

    'dom_pref__external_mail_srv' => "Omdirigér til en ekstern mailserver med IP-adressen:",
    'mn_edit__store_messages' => 'Mailboks',

    // aps

    'sapp__before_upgrade_notice' => 'Det anbefales at sikkerhedskopiere programmet og brugerdataene inden du påbegynder opgraderingen.',
    'sapp__application_properties' => 'Programegenskaber',
    'sapp__application_root_descr' => 'Programmets hovedside',

    'sapp__aps_license_invalid_id' => 'Licensnøglen har et ugyldigt ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Der findes allerede en licensnøgle %1 i databasen.',
    'sapp__aps_lic_del_used' => 'Kunne ikke slette licensnøglen. Den bruges af et af de installerede programmer.',
    'sapp__aps_lic_del_unknown' => 'Kunne ikke slette licensnøglen %1.',
    'sapp__aps_cappi_duplicate' => "Dette program ligger allerede i kundens programgruppe",
    'sapp__appi_not_shared_no_install' => "Der er intet sådant program i kundens programgruppe. Hvis du vil installere dette program på et websted, skal du først føje programmet til kundens programgruppe.",
    'sapp__appi_shared_not_client' => "Der er intet sådant program i kundens programgruppe. Hvis du vil opgradere dette program til den specificerede version, skal du først føje denne programversion til kundens programgruppe.",
    'sapp__apply_license_script_not_found' => 'Kunne ikke finde scriptet "apply-license" til dette webprogram.',
    'sapp__unable_to_activate_key' => 'Der opstod en fejl under forsøg på at aktivere en licensnøgle: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Der er installeret webprogrammer der kræver tilstedeværelse af dette webprogram i systemet.',
    'sapp__unable_to_delete_ai_in_pool' => 'Dette program er stadig i kundens programgruppe Hvis du vil fjerne dette program skal du først fjerne det fra alle kunde-programgrupper eller gøre det gratis.',
    'sapp__unable_to_delete_app_template' => 'Kunne ikke fjerne programmet #%1: %2',
    'sapp__limit_exceeded_client' => 'Du har nået det antal gange du kan installere webprogrammet (%2).',


    // atis module

    '_week_on' => 'uge på',
    '__week_first' => 'første',
    '__week_second' => 'anden',
    '__week_third' => 'tredje',
    '__week_fourth' => 'fjerde',
    '__week_last' => 'sidste',
    '__not_started' => 'Venter',
    '__started' => 'Kører',
    '__cancel_pending' => 'Annullerer',
    '__canceled' => 'Annulleret',
    '__error' => 'Fejl',
    '__done' => 'Færdig',

    '__php_cgi_handler' => 'CGI-program',
    '__php_isapi_handler' => 'ISAPI-udvidelse',
    '__php_fastcgi_handler' => 'FastCGI-program',
    '__php_module_handler' => 'Moderup',
    '__php_run_as' => 'kør som:',

    'cf_dbfolder_text' =>'Databasemappe',
    'cf_isnewdb_text' => 'Opret database',
    'cf_isnewdb_title' => 'Vælg afkrydsningsfeltet, hvis databasen skal oprettes',

    'pb__site_apps_upgrade' => 'Webprogramopgradering',

    'detach' => 'Afbryd',
    'preferences' => "Skift adgangskode",

    'toolsbar__switch_user?' => "Er du sikker på, du vil logge på under en anden brugerkonto?",
    '__aps_left' => 'Resterende installationer',
    'aps__license_key' => 'Licensnøgle',
    'aps__download_code' => 'Licensnøgledownload og aktiveringskode.',
    'aps__license_key_hint' => 'Hent fra licensserveren vha. aktiveringskoden',
    'aps__database_not_available' => 'ikke til rådighed, Kontrollér domæne- eller kundebegrænsninger',
    'aps__yes' => 'ja',
    'aps__no' => 'nej',
    '__click_to_enlarge' => 'Klik for at forstørre',
    'site_apps__back_to_list' => 'Returner til liste',
    'sapp__pkg_info_installation_requirements' => 'Installationskrav:',
    '__close_window' => 'Luk',

    //SAPP END

    'skin_info__already_default' => 'Temaet er allerede indstillet som standardtema.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus indstillinger for %1',
    'drweb:properties_legend' => 'Indstillinger',
    'drweb:status' => 'Scanner e-mail for vira',

    // sb integration
    'sitebuilder_wizard' => 'Guide til Presence Builder',
    'dom_site_builder' => 'Klik for at åbne guiden Presence Builder.',
    'sb_plesk_admin_url' => 'Presence Builder server-URL. Kontrollér, at denne adresse oversættes korrekt i DNS',
    'sb_plesk_admin_login' => 'Brugernavnet til serveradministrators login på Presence Builder',
    'sb_plesk_admin_password' => 'Administrators adgangskode',
    'sb_sitebuilder_preferences' => 'Presence Builder-administrators akkreditiver',
    'sb__server' => 'Presence Builder-systemadministrators indstillinger',
    'sb__sitebuilder_support' => 'Understøttelse af Presence Builder',
    'sb_keep_sb_user' => 'Bevar den korresponderende brugerkonto i Presence Builder',
    'sb_create_sb_user' => 'Opret en korresponderende brugerkonto i Presence Builder',
    'sb__build_site_using_sitebuilder' => "Opret et websted ved hjælp af Presence Builder",
    'sb_no_current_sb_server_set' => 'Forbindelsen til Presence Builder er ikke konfigureret endnu: Du kan tilføje en A-post i DNS-zone skabelonen, der peger på Presence Builder-serveren.',
    'sb_unable_update_sb_server_sb_return_message' => "Kunne ikke hente informationerne fra Presence Builder-systemet: \n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Kunne ikke forbinde til Presence Builder: Forkert brugernavn eller adgangskode.",
    'sb_init_sb_manager' => "Initialiserer Presence Builder administrator: %1",
    'sb_err_couldnt_connect_sb' => "Det mislykkedes at oprette forbindelse til Presence Builder-systemet.",
    'sb_err_client_dont_have_sbuser' => "Denne kunde har ikke en brugerkonto i Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder er ikke konfigureret",
    'sb_err_you_dont_have_sbaccount' => "Kunne ikke autorisere dig i Presence Builder.",
    'sb_error_critical_during_operation' => "Følgende fejl opstod i Presence Builder: \n%1",
    'sb_err_sso_is_not_enabled' => "Enkelt-sign-on understøttelse er ikke aktiveret i Plesk.",

    'warning__super_zone_exist' => "Zonen %1 blev oprettet, men dette zonenavn er imidlertid en underzone på en allerede eksisterende zone %2, som hører til en anden bruger %3. Dette er muligt, men kontrollér venligst, at du har valgt den korrekte brugerkonto.",
    'error__super_zone_exist' => "Kunne ikke oprette DNS-zonen, fordi dens superzone hører til en anden bruger.",

    'locales__files_not_exits' => 'Kunne ikke skifte locale: Den angivne grænseflade-sprogpakke findes ikke i systemet.',
    'locales__unavailable' => 'Kunne ikke skifte locale: Den angivne grænseflade-sprogpakke er ikke til rådighed.',

    // DB BU

    'pb__dbbackup_list' => 'Database-sikkerhedskopifiler',
    // server
    'dbbackup__server_backup_settings' => 'Sikkerhedskopiering',
    'dbbackup__network_temp_dir' => 'Midlertidig netværksmappe.',
    'dbbackup__network_user' => 'Brugernavn',
    'dbbackup__network_pass' => 'Adgangskode',
    // domain
    'dbbackup__add_database_legend' => 'Gendannet sikkerhedskopi af databasen',
    'dbbackup__add_database_restore' => 'Gendan databasen fra sikkerhedskopifilen.',
    'dbbackup__add_database_file' => 'Database-sikkerhedskopifil',
    'dbbackup__add_database_user' => 'Standard brugernavn',
    'dbbackup__add_database_pass' => 'Standard brugeradgangskode',
    'dbbackup__add_database_pass2' => 'Bekræftelse af standard brugeradgangskode',

    'bt_dbbackup_now' => 'Sikkerhedskopier',

    'bt_repair' => 'Reparer',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Hosting-udbyderen har forbudt upload af SQL Server databasedumps.',

    // APS categories

    'cf_invalid_password' => 'Adgangskoden må højst være på 16 tegn',
    'cf_invalid_description_length' => 'Beskrivelsen kan ikke være længere end på 256 symboler',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-adressen %1 bruges allerede af ekstern e-mail server',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP-konto brugernavn eller adgangskode er ugyldig. Angiv venligst korrekte FTP-bruger akkreditiver.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Grænsen for serienummerændringer blev nået. Der kan ikke udføres flere DNS-zone ændringer i dag.',
    'dns__zone_apply_changes' => 'De foretagne ændringer af DNS-posterne blev gemt De foretagne ændringer er fremhævet herunder. Klik på Opdater for at overføre ændringer til DNS-zonen eller klik på Tilbage for at kassere ændringerne.',
    'dns__update_dns_zone' => 'Klik for at gemme de ændringer der er lavet i DNS-posterne',
    'dns__revert_dns_zone' => 'Klik for at annullere de ændringer der er lavet af DNS-posterne',
    'bt_revert' => 'Tilbage',
    'dns__dns_zone_has_beed_updated' => 'De foretagne ændringer af DNS-posterne blev gemt',
    'dns__dns_zone_has_beed_reverted' => 'De foretagne ændringer af DNS-posterne blev annulleret',
    'db__nondefault_server_not_allowed' => 'Brug af ikke-standard databaseserver er ikke tilladt',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Kunden %1\'s konto og domæner.',
    'ui__client__disabled-warning' => 'Kontoen for kunden %1 er suspenderet.',
    'ui__client__none-available' => 'Der findes ingen konfigurerede kundekonti.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Debitor %1',
    'ui__client_self__description' => 'Liste over mine domæner',
    'ui__client_self__short-title' => 'Mine domæner',
    'ui__client_self__title' => 'Mine domæner',


    'site_apps__non_removable' => 'Elementer der ikke kan fjernes',
    'site_apps__non_removable_items' => 'Følgende webprogrammer kan ikke fjernes:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Der er ikke nogen brugerdefinerede knapper.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Der er ingen brugerdefinerede knapper i kunden %1\'s Kundepanel.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Fjern knappen %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Fjern knappen %1.',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Fjern brugerdefinerede knapper fra kundens Kundepanel',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Fjern brugerdefinerede knapper',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern knapper',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Vælg en kunde hvis knapper du vil fjerne, og klik på Næste >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Vælg de knapper, du vil fjerne, og klik på Næste >>',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bekræft fjernelse af knapperne ved at markere afkrydsningsfeltet på dette skærmbillede og derefter klikke på Færdig.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Fjern en brugerdefineret knap fra kundens Kundepanel.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Fjern en brugerdefineret knap',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern brugerdefineret knap',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis brugerdefinerede knap du vil fjerne, og klik på Næste >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Vælg den brugerdefinerede knap, du vil fjerne, og klik på Næste >>',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bekræft fjernelse af de brugerdefinerede knapper ved at markere afkrydsningsfeltet på dette skærmbillede og derefter klikke på Færdig.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Redigér egenskaberne for knap %1 på brugerniveau.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Indstillinger',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Redigér kundens brugerdefinerede knap %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Tilføj brugerdefineret knap',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Vælg den kunde, i hvis Kundepanel du vil oprette en brugerdefineret knap du vil fjerne, og klik på Næste>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik på Færdig for at oprette knappen.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Redigér egenskaberne for en knap i kundens Kundepanel.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaber',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Redigér egenskaberne for en knap i kundens Kundepanel',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Rediger brugerdefineret knaps egenskaber',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis brugerdefinerede knap du vil fjerne, og klik på Næste >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Vælg den brugerdefinerede knap, du vil fjerne, og klik på Næste >>',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Når du er færdig med at ændre egenskaberne for knappen, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Gør knappen %1 utilgængelig for dine kunder.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Gør den utilgængelig for alle dine kunder',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Gør knappen %1 utilgængelig for dine kunder.',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Gør knappen %1 synlig for kunders brugere.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Gør knappen tilgængelig for dine kunder',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Gør knappen %1 synlig for kunders brugere.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Gør en brugerdefineret knap tilgængelig/utilgængelig for dine kunder.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgængelig/utilgængelig for dine kunder',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Gør en brugerdefineret knap tilgængelig eller utilgængelig for dine kunder.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gør en brugerdefineret knap tilgængelig/utilgængelig for dine kunder.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis brugerdefinerede knap du vil gøre tilgængelig for kundens brugere, og klik på Næste >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Vælg en brugerdefineret knap, du vil gøre tilgængelig eller utilgængelig for dine kunder, og klik på Næste >>.',

    'ui__client/domain__description' => 'Administrér domæne %1.',
    'ui__client/domain__disabled-warning' => 'Domænet %1 er suspenderet.',
    'ui__client/domain__none-available' => 'Du har ikke nogen domæner',
    'ui__client/domain__none-available__1' => 'Kontoen for %1 har ikke nogen domæner.',
    'ui__client/domain__none-available__2' => 'Kontoen for %1 har ikke nogen domæner.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domæne %1',
    'ui__client/domain_self__description' => 'Administrér dit domæne.',
    'ui__client/domain_self__disabled-warning' => 'Dit domæne er suspenderet.',
    'ui__client/domain_self__quick-search' => 'Mine domæner',
    'ui__client/domain_self__short-title' => 'Mit domæne',
    'ui__client/domain_self__title' => 'Mit domæne',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Der er ingen brugerdefinerede knapper i kundens Kundepanel.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Kunden %1 har ingen brugerdefinerede knapper i Kundepanelet.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Der er ingen brugerdefinerede knapper på domænet %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Fjern den brugerdefinerede knap %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Fjern den brugerdefinerede knap %1.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Fjern brugerdefinerede knapper',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Fjern brugerdefinerede knapper',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern brugerdefinerede knapper',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Vælg den kunde, fra hvis Kontrolpanel du vil fjerne knapperne, og klik på Næste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Vælg den kunde, fra hvis Kontrolpanel du vil fjerne knapperne, og klik på Næste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Vælg de knapper, du vil fjerne, og klik på Næste >>',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Bekræft fjernelsen af knapperne ved at sætte kryds i de respektive afkrydsningsfeltet og klikke på Færdig for at fjerne knapperne og afslutte guiden.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Fjern en brugerdefineret knap',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Fjern en brugerdefineret knap',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern en brugerdefineret knap',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Vælg den kunde, fra hvis Kontrolpanel du vil fjerne knapperne, og klik på Næste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Vælg den kunde, fra hvis Kontrolpanel du vil fjerne knapperne, og klik på Næste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Vælg den brugerdefinerede knap, du vil fjerne, og klik på Næste >>',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Bekræft fjernelsen af den brugerdefinerede knap ved at sætte kryds afkrydsningsfeltet, klik på Færdig for at fjerne knappen og afslutte guiden.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Rediger egenskaberne for den brugerdefinerede knap %1.",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Egenskaber",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Redigér egenskaberne for den brugerdefinerede knap %1 i Kundepanel.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Tilføje en knap',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Vælg den kunde, i hvis Kundepanel du vil placere knappen, og klik på Næste>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Vælg det abonnement, hvori du vil ændre knappen, og klik på Næste >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klik på Færdig for at oprette knappen og forlade guiden.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Redigér egenskaberne for en knap i Kundepanelet.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaber',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Redigér egenskaberne for en knap i Kundepanelet',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Rediger knapegenskaber',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Vælg den brugerdefinerede knap, hvis indstillinger du vil ændre, og klik på Næste >>",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Når du er færdig med at ændre egenskaberne for knappen, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Gør knappen %1 utilgængelig for e-mail brugere på dette domæne.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Utilgængelig for e-mail brugere',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Gør knappen %1 utilgængelig for e-mail brugere på dette domæne.',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Gør knappen %1 tilgængelig for e-mail brugere på dette domæne.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Tilgængelig for e-mail brugere på dette domæne',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Gør den brugerdefinerede knap %1 tilgængelig for e-mail brugere på dette domæne.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Gør en brugerdefineret knap tilgængelig eller utilgængelig for andre brugere.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgængelig/utilgængelig for andre brugere',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Gør en brugerdefineret knap tilgængelig eller utilgængelig for e-mail brugere.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gør en brugerdefineret knap tilgængelig eller utilgængelig for andre brugere.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Vælg det domæne, hvor knappen er placeret, og klik på Næste >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Vælg en knap, du vil gøre tilgængelig eller utilgængelig for andre kunder, og klik på Næste >>.',

    'ui__client/domain/delete__description' => 'Fjern domænet %1.',
    'ui__client/domain/delete__short-title' => 'Fjern',
    'ui__client/domain/delete__title' => 'Fjern domænet %1.',
    'ui__client/domain/delete_multi__description' => 'Fjern domæner',

    'ui__client/domain/delete_multi__short-title' => 'Fjern',
    'ui__client/domain/delete_multi__title' => 'Fjern domæner',
    'ui__client/domain/delete_multi__wizard-title' => 'Fjern domæner',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Vælg de domæner, du vil fjerne, og klik på Næste >>',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Bekræft fjernelsen af domænerne ved at sætte kryds afkrydsningsfeltet. Klik på Færdig for at fjerne dem og afslutte guiden.',
    'ui__client/domain/delete_unknown__description' => 'Fjern et domæne',
    'ui__client/domain/delete_unknown__short-title' => 'Fjern',
    'ui__client/domain/delete_unknown__title' => 'Fjern domæne',
    'ui__client/domain/delete_unknown__wizard-title' => 'Fjern et domæne',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Vælg de domæner, du vil fjerne, og klik på Næste >>',
    'ui__client/domain/delete_unknown__wizard__3' => 'Bekræft fjernelsen af domænet ved at sætte kryds afkrydsningsfeltet, klik på Færdig for at fjerne det og afslutte guiden.',

    'ui__client/domain/hosting__none-available' => 'Der er ingen domæner med konfigureret webhosting. Opret et domæne og konfigurér webhosting på det, for at få adgang til denne funktionalitet.',
    'ui__client/domain/hosting__none-available__1' => 'Denne brugerkonto har ingen domæner med konfigureret webhosting. Konfigurér webhosting på det nødvendige domæne for at få adgang til denne funktionalitet.',
    'ui__client/domain/hosting__none-available__2' => 'Webhosting er ikke konfigureret for domænet %1. Konfigurér webhosting på domænet %1 for at få adgang til denne funktionalitet.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Kunder",
    'ui__client/domain/hosting/application#list_header__description__title' => "Beskrivelse",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Elementer",
    'ui__client/domain/hosting/application#list_header__name__title' => "Navn",
    'ui__client/domain/hosting/application#list_header__release__title' => "Frigiv",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sortér efter kunder",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sortér efter beskrivelse",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sortér efter emner",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sortér efter navn",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sortér efter udgave",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sortér efter versioner",
    'ui__client/domain/hosting/application#list_header__title' => "Web-applikationer",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versioner",

    'rpt_reseller_section_general' => 'Generelt',
    'rpt_reseller_section_domains' => 'Domæner',
    'rpt_reseller_section_clients' => 'Kunder',
    'statistics__cl_active_domains' => "Aktive domæner",
    'rpt_reseller_cl_domains' => "Domæner",
    'rpt_reseller_cl_subdomains' => "Subdomæner",
    'by__cl_domains' => "klients' domæner",
    'dom_ctrl__cl_mboxes' => "Mailbokse",
    'rpt_reseller_cl_redirects' => "Videresendelse",
    'rpt_reseller_cl_mail_groups' => "Mailgrupper",
    'rpt_reseller_cl_mail_resps' => "Autosvar",
    'rpt_reseller_cl_mail_lists' => "Mailing Lists",
    'rpt_reseller_cl_web_users' => "Webbrugere",
    'rpt_reseller_cl_data_bases' => "Databaser",

    'statistics__active_clients' => 'kunder med aktive abonnementer',
    'statistics__clients_active_domains' => 'Aktive domæner',
    'statistics__clients_doms' => 'Domæner',
    'statistics__cl_doms' => 'Domæner',
    '__clients_subdomains' => 'Subdomæner',
    '__clients_domains' => 'Domæner',
    'dom_ctrl__clients_mboxes' => 'Mailbokse',
    'dom_ctrl__clients_redir' => 'Videresendelse',
    'dom_ctrl__clients_mg' => 'Mailgrupper',
    'dom_ctrl__clients_resp' => 'Autosvar',
    'dom_ctrl__clients_maillists' => 'Mailing Lists',
    'dom_ctrl__clients_wu' => 'Webbrugere',
    'dom_ctrl__clients_db' => 'Databaser',

    'dom_ctrl__cl_redir' => 'Videresendelse', // to resolve!
    'dom_ctrl__cl_mg' => 'Mailgrupper', // to resolve!
    'dom_ctrl__cl_resp' => 'Autosvar', // to resolve!
    'dom_ctrl__cl_maillists' => 'Mailing Lists', // to resolve!
    'dom_ctrl__cl_wu' => 'Webbrugere', // to resolve!
    'dom_ctrl__cl_db' => 'Databaser', // to resolve!

    'rpt_cl_section_clients' => 'Kunder',

    'rpt_admin_section_general' => 'Generelt',
    'rpt_admin_section_resellers' => 'Forhandlere',
    'rpt_admin_section_clients' => 'Kunder',
    'rpt_admin_section_personal_clients' => 'Egne kunder',
    'rpt_admin_section_domains' => 'Domæner',
    'rpt_admin_section_personal_domains' => 'Personlige domæner',

    'rpt_reseller_section_personal_domains' => 'Personlige domæner',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Vælg det domæne, du vil suspendere eller aktivere.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspendér eller aktivér et domæne.',

    'ui__client/ip-pool__description' => 'Tildel eller afbryd IP-adresser og SSL/TLS-certifikater for kunden %1.',
    'ui__client/ip-pool__short-title' => 'IP-pulje',
    'ui__client/ip-pool__title' => 'Kunde %1\'s IP-gruppe',
    'ui__client/ip-pool_self__description' => 'Vis din IP-pulje.',
    'ui__client/ip-pool_self__short-title' => 'IP-pulje',
    'ui__client/ip-pool_self__title' => 'Min IP-pulje',
    'ui__client/ip-pool/properties__description' => 'Opsæt IP-gruppe for kunden %1.',

    'ui__client/ip-pool/properties__short-title' => 'IP-pulje',
    'ui__client/ip-pool/properties__title' => 'Opsæt IP-gruppe for kunden %1.',
    'ui__client/ip-pool/properties_self__description' => 'Vis din IP-pulje.',

    'ui__client/ip-pool/properties_self__short-title' => 'Min IP-pulje',
    'ui__client/ip-pool/properties_self__title' => 'Min IP-pulje',
    'ui__client/ip-pool/properties_unknown__description' => 'Tilknyt eller afbryd IP-adresser og SSL/TLS-certifikater fra kunden.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP-pulje',
    'ui__client/ip-pool/properties_unknown__title' => 'Opsæt kundens IP-pulje',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Opsæt kundens IP-pulje',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Vælg den kunde hvis IP-gruppe du vil konfigurere.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Når du er færdig med at konfigurere IP-puljen, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',


    'ui__client/limits_readonly-unknown__description' => 'Vis ressourcegrænser for en kunde.',
    'ui__client/limits_readonly-unknown__short-title' => 'Resursebegrænsninger',
    'ui__client/limits_readonly-unknown__title' => 'Vis ressourcegrænser for en kundekonto.',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Vis eller redigér ressourcegrænser for en kunde',

    'ui__client/limits_unknown__wizard-title' => 'Vis eller redigér ressourcegrænser for en kunde',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Vælg den ønskede kunde.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Vælg den ønskede kunde.',
    'ui__client/limits_unknown__wizard__2' => 'Klik på Færdig for at afslutte guiden.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Klik på Afslut, hvis du vil afslutte guiden.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Klik på Afslut, hvis du vil afslutte guiden.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Klik på Afslut, hvis du vil afslutte guiden.',

    'ui__client/permissions_unknown__wizard-title' => 'Vis eller redigér tilladelser for en kunde',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Når du er færdig med at redigere tilladelserne, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis tilladelser du vil se eller ændre.',
    'ui__client/permissions_unknown__wizard__2' => 'Når du er færdig med at konfigurere kundens tilladelser, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__client/preferences_unknown__wizard-title' => 'Redigér kundens præferencer',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis sessions- og grænsefladeindstillinger du vil administrere.',
    'ui__client/preferences_unknown__wizard__2' => 'Klik på Færdig, når du er færdig med at ændre kundens præferencer.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Klik på Færdig, når du er færdig med at ændre kundens præferencer.',

    'ui__custom-buttons/custom-button__none-available' => 'Du har ingen brugerdefinerede knapper.',
    'ui__custom-buttons/custom-button/delete__description' => 'Fjern den brugerdefinerede knap %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__custom-buttons/custom-button/delete__title' => 'Fjern den brugerdefinerede knap %1.',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Fjern de brugerdefinerede knapper.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Fjern brugerdefinerede knapper',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern brugerdefinerede knapper',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Vælg de opgaver, du vil fjerne.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Bekræft fjernelsen af knapperne ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Fjern brugerdefinerede knapper',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Fjern brugerdefinerede knapper',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern brugerdefinerede knapper',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Vælg de opgaver, du vil fjerne.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Bekræft fjernelsen af knappen ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',
    'ui__custom-buttons/custom-button/properties__description' => 'Redigér egenskaberne knappen %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Egenskaber',
    'ui__custom-buttons/custom-button/properties__title' => 'Redigér egenskaberne knappen %1.',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Opret en knap',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klik på Færdig for at oprette knappen.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Rediger egenskaberne for en brugerdefineret knap.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaber',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Rediger egenskaberne for en brugerdefineret knap.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Rediger egenskaberne for en brugerdefineret knap.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Vælg den brugedefinerede knap, hvis egenskaber du vil ændre.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Klik på Færdig for at afslutte guiden.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Gør den brugerdefinerede knap %1 utilgængelig for andre brugere.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Utilgængelig for andre brugere',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Gør den brugerdefinerede knap %1 utilgængelig for andre brugere.',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Gør den brugerdefinerede knap %1 tilgængelig for andre brugere.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Tilgængelig for andre brugere',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Gør den brugerdefinerede knap %1 tilgængelig for andre brugere.',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Gør den brugerdefinerede knap tilgængelig eller utilgængelig for andre brugere.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgængelig eller utilgængelig for andre brugere',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Gør den brugerdefinerede knap tilgængelig eller utilgængelig for andre brugere.',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gør den brugerdefinerede knap tilgængelig eller utilgængelig for andre brugere.',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Vælg en knap, du vil gøre tilgængelig eller utilgængelig for andre kunder, og klik på Næste >>.',

    'ui__longtasks#list_header__name__title' => "Navn",
    'ui__longtasks#list_header__owner__title' => "Ejer",
    'ui__longtasks#list_header__start_time__title' => "Oprettelstidspunkt",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Opgaver",
    'ui__longtasks#list_header__finish_time__title' => "Gennemførelsestid",
    'ui__longtasks#task_list_legend__title' => "Opgaver",
    'ui__longtasks#tools_legend__title' => "Værktøjer",
    'ui__longtasks__description' => "Administrér baggrundsopgaver",
    'ui__longtasks__short-title' => "Baggrundshandlinger",
    'ui__longtasks__title' => "Baggrundshandlinger",
    'ui__longtasks/longtask/properties#current_operation__title' => "Aktuel handling:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Anslået gennemførelsestid:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Generelt",
    'ui__longtasks/longtask/properties#owner__title' => "Opgave startet af",
    'ui__longtasks/longtask/properties#progress__title' => "Generel status:",
    'ui__longtasks/longtask/properties#start_time__title' => "Opgave startet",
    'ui__longtasks/longtask/properties#status_legend__title' => "Opgavestatus",
    'ui__longtasks/longtask/properties__description' => "Baggrundsopgavestatus og information",

    'ui__longtasks/properties__description' => "Indstilling af baggrundsopgaver",
    'ui__longtasks/properties__short-title' => "Indstillinger",
    'ui__longtasks/properties__title' => "Baggrundshandlinger",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Masse e-mail meddelelses-skabeloner',
    'ui__mass-mail/template#list_header__name__title' => 'Skabelonnavn',
    'ui__mass-mail/template#list_header__from_email__title' => 'Afsender',
    'ui__mass-mail/template#list_header__to__title' => 'Modtagere',
    'ui__mass-mail/template#list_header__subject__title' => 'Emne',
    'ui__mass-mail/template#list_header__cdate__title' => 'Oprettelsesdato',
    'ui__mass-mail/template#list_header__send__title' => 'Send',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Redigér masse-e-mail meddelelsesskabelon.',
    'ui__mass-mail/template/properties__description' => 'Redigér denne masse-e-mail meddelelsesskabelon.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Tilføj masse-e-mail skabelon',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Tilføj masse-e-mail skabelon',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Tilføj en masse-e-mail meddelelsesskabelon.',
    'ui__mass-mail/send__short-title' => 'Send masse-e-mail',
    'ui__mass-mail/send__title' => 'Send masse-e-mail meddelelse',
    'ui__mass-mail/send__description' => 'Send masse e-mail til udvalgte modtagere',
    'ui__mass-mail/template/delete_multi__short-title' => 'Fjern masse-e-mail skabeloner',
    'ui__mass-mail/template/delete_multi__title' => 'Fjern disse masse e-mail meddelelsesskabeloner',
    'ui__mass-mail/template/delete_multi__description' => 'Fjern de valgte masse e-mail meddelelsesskabeloner',
    'ui__mass-mail/template/delete_multi__done' => 'De valgte meddelelsesskabeloner blev fjernet.',
    'ui__mass-mail/template/properties__invalid_values' => 'Ugyldige værdier angivet',


    // old
    'ui__mass-mail#body_text__description' => 'Du kan bruge <name>variablen i meddelelsesteksten (men ikke i headeren). Den vil blive erstattet med kundens eller forhandlerens kontaktnavn.',
    'ui__mass-mail#body_text__title' => 'Beskedtekst',
    'ui__mass-mail#compose_legend__title' => 'Besked',
    'ui__mass-mail#from_email_text__title' => 'Fra (e-mailadresse)',
    'ui__mass-mail#list_header__cdate__title' => 'Oprettet',
    'ui__mass-mail#list_header__from_email__title' => 'Fra',
    'ui__mass-mail#list_header__name__title' => 'Navn',
    'ui__mass-mail#list_header__send__title' => 'Opret meddelelse',
    'ui__mass-mail#list_header__subject__title' => 'Emne',
    'ui__mass-mail#list_header__title' => 'Masse e-mail meddelelses-skabeloner',
    'ui__mass-mail#list_header__to__title' => 'Til',
    'ui__mass-mail#list_legend__title' => 'Masse e-mail meddelelses-skabeloner',
    'ui__mass-mail#load_template_text__title' => 'Indlæs',
    'ui__mass-mail#name_text__title' => 'Skabelonnavn',
    'ui__mass-mail#option_mode_all__title' => 'Alle',
    'ui__mass-mail#option_mode_except__title' => 'Alle bortset fra markerede',
    'ui__mass-mail#option_mode_select__title' => 'Kun markerede',
    'ui__mass-mail#option_select_template__title' => '---Vælg en skabelon---',
    'ui__mass-mail#picker_legend__title' => 'E-mail meddelelses-skabeloner',
    'ui__mass-mail#picker_title__title' => 'Vælg en skabelon',
    'ui__mass-mail#save_as_legend__title' => 'Gem som skabelon',
    'ui__mass-mail#save_as_text__title' => 'Gem sammensat meddelelse i en ny skabelon ved navn',
    'ui__mass-mail#subject_text__title' => 'Emne',
    'ui__mass-mail#template_legend__title' => 'Skabelon',
    'ui__mass-mail#to_admin_text__title' => 'Plesk-administrator',
    'ui__mass-mail#to_clients_text__title' => 'Kunder',
    'ui__mass-mail#to_domains_text__title' => 'Domæneadministratorer',
    'ui__mass-mail#to_select_text__title' => 'Vælg adresser',
    'ui__mass-mail#to_show_hide_text__title' => 'Vis/skjul markerede',
    'ui__mass-mail#to_text__title' => 'Til',
    'ui__mass-mail#tools_legend__title' => 'Værktøjer',
    'ui__mass-mail__already_exists' => 'Der findes allerede en skabelon med navnet %1.',
    'ui__mass-mail__none-available' => 'Du har ingen meddelelsesskabeloner.',

    'ui__mass-mail/delete__description' => 'Fjern masse e-mail meddelelsesskabelonen %1',

    'ui__mass-mail/delete__empty_selection' => 'Vælg den skabelon, du vil fjerne.',
    'ui__mass-mail/delete__short-title' => 'Fjern %1',
    'ui__mass-mail/delete__title' => 'Fjern masse e-mail meddelelsesskabelonen %1',
    'ui__mass-mail/delete_multi__description' => 'Fjern masse e-mail meddelelsesskabeloner',

    'ui__mass-mail/delete_multi__short-title' => 'Fjern',
    'ui__mass-mail/delete_multi__title' => 'Fjern masse e-mail meddelelsesskabeloner',
    'ui__mass-mail/delete_multi__wizard-title' => 'Fjernelse af masse- e-mail meddelelsesskabeloner.',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Vælg de masse-e-mail meddelelsesskabeloner, du vil fjerne.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Bekræft fjernelsen af skabelonerne ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',
    'ui__mass-mail/delete_unknown__description' => 'Fjern masse e-mail meddelelsesskabeloner',
    'ui__mass-mail/delete_unknown__short-title' => 'Fjern',
    'ui__mass-mail/delete_unknown__title' => 'Fjern masse e-mail meddelelsesskabeloner',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Fjernelse af masse- e-mail meddelelsesskabeloner.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Vælg den masse-e-mail meddelelsesskabelon, du vil fjerne.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Bekræft fjernelsen af skabelonen ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',

    'ui__mass-mail/properties__description' => 'Redigér e-mail meddelelsesskabelonen %1',

    'ui__mass-mail/properties__invalid_values' => 'De angivne værdier er forkerte',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Redigér e-mail meddelelsesskabelonen %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Opret masse e-mail meddelelsesskabelon',
    'ui__mass-mail/properties_unknown-new__description' => 'Opret en masse e-mail meddelelsesskabelon',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Tilføj en e-mail meddelelsesskabelon',
    'ui__mass-mail/properties_unknown-new__title' => 'Opret en e-mail meddelelsesskabelon',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Redigér masse-e-mail meddelelsesskabelon.',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Vælg den skabelon, du vil ændre, og klik på Næste >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Når du er færdig med at redigere skabelonen, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__mass-mail/send__invalid_values' => 'Du angav forkerte værdier.',

    'ui__mass-mail/send_new__wizard-title' => 'Opret en meddelelsesskabelon og send e-mail',
    'ui__mass-mail/send_unknown-new__description' => 'Send e-mail til alle udvalgte modtagere.',

    'ui__mass-mail/send_unknown-new__short-title' => 'Send masse-e-mail',
    'ui__mass-mail/send_unknown-new__title' => 'Send masse-e-mail meddelelse',
    'ui__mass-mail/send_unknown__description' => 'Send e-mail til alle udvalgte modtagere.',

    'ui__mass-mail/send_unknown__short-title' => 'Send masse-e-mail',
    'ui__mass-mail/send_unknown__title' => 'Send masse-e-mail meddelelse',
    'ui__mass-mail/send_unknown__wizard-title' => 'Send masse-e-mail meddelelse',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Vælg den skabelon, du har brug for, og klik på Næste >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Når du er færdig med at ændre skabelonens egenskaber, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__mass-email/delete__description' => 'Fjern de valgte masse e-mail meddelelsesskabeloner',

    'ui__mass-email/delete__empty_selection' => "Vælg de skabeloner, du vil fjerne.",
    'ui__mass-email/delete__short-title' => "Fjern %1",
    'ui__mass-email/delete__title' => "Fjern masse e-mail meddelelsesskabelonen %1",
    'ui__mass-email/delete_multi__description' => "Fjern masse e-mail meddelelsesskabeloner",

    'ui__mass-email/delete_multi__short-title' => "Fjern",
    'ui__mass-email/delete_multi__title' => "Fjern masse e-mail meddelelsesskabeloner",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Bekræft fjernelsen af skabelonerne ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Vælg de masse-e-mail meddelelsesskabeloner, du vil fjerne.",
    'ui__mass-email/delete_multi__wizard-title' => "Fjernelse af masse- e-mail meddelelsesskabeloner.",
    'ui__mass-email/delete_unknown__description' => "Fjern masse e-mail meddelelsesskabeloner",
    'ui__mass-email/delete_unknown__short-title' => "Fjern",
    'ui__mass-email/delete_unknown__title' => "Fjern masse e-mail meddelelsesskabeloner",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Bekræft fjernelsen af skabelonen ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Vælg den masse-e-mail meddelelsesskabelon, du vil fjerne.",
    'ui__mass-email/delete_unknown__wizard-title' => "Fjernelse af masse- e-mail meddelelsesskabeloner.",
    'ui__mass-email/send__description' => "Send e-mail til alle udvalgte modtagere.",
    'ui__mass-email/send__short-title' => "Send masse-e-mail",
    'ui__mass-email/send__title' => "Send masse-e-mail meddelelse",
    'ui__mass-email/send_main__description' => "Send e-mail til alle udvalgte modtagere.",

    'ui__mass-email/send_main__short-title' => "Send masse-e-mail",
    'ui__mass-email/send_main__title' => "Send masse-e-mail meddelelse",
    'ui__mass-email/send_selectresellers__title' => 'Vælg forhandlere',
    'ui__mass-email/send_selectresellers__short-title' => 'Forhandlere',
    'ui__mass-email/send_selectresellers__description' => 'Vælg forhandlerkonti.',

    'ui__mass-email/send_selectclients__description' => "Vælg kundekonti",

    'ui__mass-email/send_selectclients__short-title' => "Kunder",
    'ui__mass-email/send_selectclients__title' => "Vælg kunder",
    'ui__mass-email/send_selectdomainusers__description' => "Vælg domæneadministratorkonti",

    'ui__mass-email/send_selectdomainusers__short-title' => "Domæneadministratorer",
    'ui__mass-email/send_selectdomainusers__title' => "Vælg domæneadministratorer",
    'ui__mass-email/template/properties_main__description' => "Opret masse e-mail meddelelsesskabelon",
    'ui__mass-email/template/properties_main__short-title' => "Rediger skabelon",
    'ui__mass-email/template/properties_main__title' => "Redigér masse-e-mail meddelelsesskabelon.",
    'ui__mass-email/template/properties_new-main__description' => "Opret en skabelon til masse-e-mail meddelelser.",
    'ui__mass-email/template/properties_new-main__short-title' => "Opret masse e-mail meddelelsesskabelon",
    'ui__mass-email/template/properties_new-main__title' => "Opret masse e-mail meddelelsesskabelon",
    'ui__mass-email/template/properties_new-selectclients__description' => "Vælg de kunde der skal modtage masse-e-mail meddelelser baseret på denne skabelon",
    'ui__mass-email/template/properties_new-selectclients__title' => "Vælg de kunde der skal modtage masse-e-mail meddelelser baseret på denne skabelon",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Vælg de domæneadministratorer der skal modtage masse-e-mail meddelelser baseret på denne skabelon",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Vælg de domæneadministratorer der skal modtage masse-e-mail meddelelser baseret på denne skabelon",
    'ui__mass-email/template/properties_selectclients__title' => "Vælg de kunde der skal modtage masse-e-mail meddelelser baseret på denne skabelon",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Vælg de domæneadministratorer der skal modtage masse-e-mail meddelelser baseret på denne skabelon",

    'ui__mass-email/template/properties_unknown-new__description' => "Opret en masse e-mail meddelelsesskabelon",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Opret skabelon",
    'ui__mass-email/template/properties_unknown-new__title' => "Oprettelse af masse e-mail meddelelses-skabelon",
    'ui__news/dismiss__description' => 'Klik for at lukke nyhedsrammen. Plesk vil ikke vise denne ramme før nyhedsartiklerne opdateres.',

    'ui__news/dismiss__title' => 'Luk nyhederne',

    'ui__server__description' => 'Serveradministration',
    'ui__server__short-title' => 'Administrér din server',
    'ui__server__title' => 'Serveradministration',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP-adressen %1 er ikke til rådighed.',
    'ui__server/ip-address__none-available' => 'Der er ingen IP-adresser.',
    'ui__server/ip-addresses/ip-address__title' => "IP-adresser",
    'ui__server/ip-address/client/properties_new__description' => "Tilknyt IP-adressen %1 til forhandlere.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Tildel',
    'ui__server/ip-address/client/properties_new__title' => "Tilknyt IP-adressen %1 til forhandlere.",
    'ui__server/ip-address/client__none-available' => 'Der er ikke nogle sådanne brugerkonti',
    'ui__server/ip-address/client_unknown__quick_search' => 'Brugere',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Liste over brugere der anvender denne IP-adresse.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Vælg IP-adressen.',
    'ui__server/ip-address/client/delete__description' => 'Fjern tilknytningen af en IP-adresse fra forhandleren.',
    'ui__server/ip-address/client/delete__short-title' => 'Fjern tilknytning',
    'ui__server/ip-address/client/delete__title' => 'Fjern tilknytningen af en IP-adresse fra forhandleren.',
    'ui__server/ip-address/client/delete_multi__description' => "Fjern tilknytningen af IP-adressen fra forhandlers grupper.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Fjern tilknytning',
    'ui__server/ip-address/client/delete_multi__title' => 'Fjern tilknytningen af en IP-adresse fra en forhandler.',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Fjern IP-adresse fra brugers grupper.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Vælg den IP-adresse du vil fjerne tilknytningen for, og klik på Næste >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Vælg de brugere du vil fjerne IP-adressetilknytningen fra, og klik på Næste >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Bekræft fjernelsen af tilknytningen af IP-adresse ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Fjern tilknytningen af en IP-adresse fra forhandlere.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Fjern tilknytning',
    'ui__server/ip-address/client/delete_unknown__title' => 'Fjern tilknytningen af IP-adresse fra forhandlere.',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Fjern tilknytningen af en IP-adresse fra brugere.',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Vælg den IP-adresse du vil fjerne tilknytningen for, og klik på Næste >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Vælg den bruger du vil fjerne IP-adressetilknytningen fra, og klik på Næste >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Bekræft fjernelsen af tilknytningen af IP-adresse ved at sætte kryds i afkrydsningsfeltet og klikke på Færdig for at afslutte guiden.',

    'ui__server/ip-address/domain__description' => "Alle domæner på IP-adressen %1.",
    'ui__server/ip-address/domain__short-title' => "Domæner",
    'ui__server/ip-address/domain__title' => "Domæner på IP-adressen %1.",
    'ui__server/ip-address/domain_unknown__description' => "Alle domæner på IP-adresse.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domæner",
    'ui__server/ip-address/domain_unknown__title' => "Domæner på IP-adresse.",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Vælg den IP-adresse, du har brug for, og klik på Næste >>.",

    'ui__server/ip-address/properties__description' => 'Redigér egenskaber for IP-adressen %1.',
    'ui__server/ip-address/properties__short-title' => 'Egenskaber',
    'ui__server/ip-address/properties__title' => 'Redigér egenskaber for IP-adressen %1.',

    'ui__server/ip-address/properties_new__wizard-title' => 'Tilføj IP-adresse',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Når du er færdig med at redigere IP-adresse egenskaberne, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',
    'ui__server/ip-address/properties_unknown__description' => 'Redigér IP-adresse egenskaber.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Egenskaber',
    'ui__server/ip-address/properties_unknown__title' => 'Redigér IP-adresse egenskaber.',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Redigér IP-adresse egenskaber.',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Vælg den IP-adresse, hvis egenskaber du vil ændre,.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Når du er færdig med at redigere IP-adresse egenskaberne, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__server/spam-filter/black-list__description' => 'Opret sortliste til server-bredt spamfilter.',
    'ui__server/spam-filter/black-list__short-title' => 'Sortlist',
    'ui__server/spam-filter/black-list__title' => 'Opret sortliste til server-bredt spamfilter.',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Kun %1 første unikke e-mailadresser vil blive tilføjet.',
    'ui__server/spam-filter/black-list/address__description' => 'Spamfiltrets sortliste-adresse.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Der er ingen e-mailadresser på listen.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Den overførte video er tom.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Følgende e-mailadresser er ugyldige: %1',
    'ui__server/spam-filter/black-list/address__none-available' => 'Der er ingen adresser på spamfiltrets sortliste.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/black-list/address__title' => 'Sortlist adresse %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Føj adresser til sortlisten.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Tilføj adresser',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Føj adresser til sortlisten.',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Fjern %1 adresse fra den server-brede sortliste.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Fjern',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Fjern %1 adresse fra den server-brede sortliste.',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Fjern adresser fra den server-brede sortliste.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Fjern',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Fjern adresser fra den server-brede sortliste.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Fjernelse af adresser fra den server-brede spamfilter sortliste',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Vælg de spamfilter-adresser, du vil fjerne, og klik på Næste >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Bekræft fjernelsen af spamfilter-adresserne ved at sætte kryds afkrydsningsfeltet, klik på Færdig for at fjerne knappen og afslutte guiden.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Fjern adresse fra den server-brede sortliste.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Fjern',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Fjern adresse fra den server-brede sortliste.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Fjernelse af adresser fra den server-brede spamfilter sortliste',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Vælg den spamfilter-adresse, du vil fjerne, og klik på Næste >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Bekræft fjernelsen af spamfilter-adressen ved at sætte kryds afkrydsningsfeltet, klik på Færdig for at fjerne knappen og afslutte guiden.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Kun %1 første unikke e-mailadresser vil blive tilføjet.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Der er ingen e-mailadresser på listen.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Kan ikke uploade filen. Den maksimale uploadstørrelse for en fil er %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Følgende e-mailadresser er ugyldige: %1',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Føj adresser til sortlisten.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Tilføj adresser',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Føj adresser til sortlisten.',

    'ui__server/spam-filter/properties__description' => 'Opsæt server-bredt spamfilter.',

    'ui__server/spam-filter/properties__short-title' => 'Indstillinger',
    'ui__server/spam-filter/properties__title' => 'Spamfilter-indstillinger',

    'ui__server/spam-filter/toggle_disable__description' => 'Deaktivér spamfiltrering for hele systemet.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Deaktiver',
    'ui__server/spam-filter/toggle_disable__title' => 'Deaktivér spamfiltrering',
    'ui__server/spam-filter/toggle_enable__description' => 'Aktivér spamfiltrering for hele serveren.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Aktiver',
    'ui__server/spam-filter/toggle_enable__title' => 'Aktivér spamfiltrering',
    'ui__server/spam-filter/toggle_unknown__description' => 'Aktivér eller deaktivér spamfiltrering for hele serveren.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Aktivér eller deaktivér',
    'ui__server/spam-filter/toggle_unknown__title' => 'Aktivér eller deaktivér spamfiltrering',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Aktivér eller deaktivér spamfilter',

    'ui__server/spam-filter/white-list__description' => 'Indstil system-bred spamfilter hvidliste.',
    'ui__server/spam-filter/white-list__short-title' => 'Hvidliste',
    'ui__server/spam-filter/white-list__title' => 'System-bred spamfilter hvidliste.',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Kun %1 første unikke e-mailadresser vil blive tilføjet.',
    'ui__server/spam-filter/white-list/address__description' => 'Spamfiltrets hvidliste-adresse.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Der er ingen e-mailadresser på listen.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Den overførte video er tom.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Følgende e-mailadresser er ugyldige: %1',
    'ui__server/spam-filter/white-list/address__none-available' => 'Der er ingen adresser på spamfiltrets server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/white-list/address__title' => 'Hvidlist adresse %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Føj adresser til hvidlisten.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Tilføj adresser',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Føj adresser til hvidlisten.',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Fjern %1 adresse fra den server-brede hvidliste.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Fjern',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Fjern %1 adresse fra den server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Fjern adresser fra den server-brede hvidliste.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Fjern',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Fjern adresser fra den server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Fjernelse af adresser fra den server-brede spamfilter hvidliste',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Vælg de spamfilter-adresser, du vil fjerne, og klik på Næste >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Bekræft fjernelsen af spamfilter-adresserne ved at sætte kryds afkrydsningsfeltet, klik på Færdig for at fjerne knappen og afslutte guiden.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Fjern adresse fra den server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Fjern',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Fjern adresse fra den server-brede hvidliste.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Fjernelse af adresser fra den server-brede spamfilter hvidliste',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Vælg den spamfilter-adresse, du vil fjerne, og klik på Næste >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Bekræft fjernelsen af spamfilter-adressen ved at sætte kryds afkrydsningsfeltet, klik på Færdig for at fjerne knappen og afslutte guiden.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Kun %1 første unikke e-mailadresser vil blive tilføjet.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Der er ingen e-mailadresser på listen.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Kan ikke uploade filen. Den maksimale uploadstørrelse for en fil er %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Følgende e-mailadresser er ugyldige: %1',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Føj adresser til hvidlisten.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Tilføj adresser',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Føj adresser til hvidlisten.',

    'ui__server/mail/statistics#apply__description' => "Anvend filter",
    'ui__server/mail/statistics#apply__title' => "Anvend",
    'ui__server/mail/statistics#custom_from__title' => "fra",
    'ui__server/mail/statistics#custom_to__title' => "til",
    'ui__server/mail/statistics#period_all__title' => "Alle",
    'ui__server/mail/statistics#period_custom__title' => "Valgfri",
    'ui__server/mail/statistics#period_month__title' => "Denne måned",
    'ui__server/mail/statistics#period_prev_month__title' => "Foregående måned",
    'ui__server/mail/statistics#period_prev_week__title' => "Foregående uge",
    'ui__server/mail/statistics#period_today__title' => "I dag",
    'ui__server/mail/statistics#period_week__title' => "Aktuel uge",
    'ui__server/mail/statistics#period_yesterday__title' => "I går",
    'ui__server/mail/statistics#show_for_period__title' => "Vis for perioden",
    'ui__server/mail/statistics#tools_legend__title' => "Værktøjer",
    'ui__server/mail/statistics__description' => "Vis statistik for spam og virus",

    'ui__server/mail/statistics__short-title' => "Statistik",
    'ui__server/mail/statistics__title' => "Statistik",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Spam-statistik",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Værktøjer",
    'ui__server/mail/statistics/spam__description' => "Vis spamstatistik",

    'ui__server/mail/statistics/spam__short-title' => "Spam-statistik",
    'ui__server/mail/statistics/spam__title' => "Spam-statistik",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Mailnavn",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% af alle",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sortér efter e-mail konto",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sortér efter % af alle",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sortér efter modtaget spam",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "mailkonti",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Modtaget spam",
    'ui__server/mail/statistics/spam/recipients__description' => "Modtagere",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Modtagere",
    'ui__server/mail/statistics/spam/recipients__title' => "Modtagere",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Rens",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Inficeret",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% af alle",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Optællinger",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Beskyttet",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Ikke kontrolleret",
    'ui__server/mail/statistics/spam/summary__description' => "Oversigt",

    'ui__server/mail/statistics/spam/summary__short-title' => "Oversigt",
    'ui__server/mail/statistics/spam/summary__title' => "Oversigt",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virus-statistik",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Værktøjer",
    'ui__server/mail/statistics/virus__description' => "Vis virusstatistik",

    'ui__server/mail/statistics/virus__short-title' => "Virus-statistik",
    'ui__server/mail/statistics/virus__title' => "Virus-statistik",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Mailkonto",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% af alle",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sortér efter mailnavn",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sortér efter % af alle",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sortér efter modtagne vira",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Mailkonti",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Modtagne vira",
    'ui__server/mail/statistics/virus/recipients__description' => "Modtagere",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Modtagere",
    'ui__server/mail/statistics/virus/recipients__title' => "Modtagere",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Rens",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Inficeret",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% af alle",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Optællinger",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Beskyttet",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Ikke kontrolleret",
    'ui__server/mail/statistics/virus/summary__description' => "Oversigt",

    'ui__server/mail/statistics/virus/summary__short-title' => "Oversigt",
    'ui__server/mail/statistics/virus/summary__title' => "Oversigt",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Navn",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% af alle",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sortér efter navn",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sortér efter % af alle",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sortér efter inficerede objekter",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Vira",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Inficerede objekter",
    'ui__server/mail/statistics/virus/viruses__description' => "Vira",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Vira",
    'ui__server/mail/statistics/virus/viruses__title' => "Vira",

    'ui__support#param_company__title' => "Firma",
    'ui__support#param_email__title' => "E-mail",
    'ui__support#param_firstname__title' => "Fornavn",
    'ui__support#param_keynumber__title' => "Produktnøglenummer",
    'ui__support#param_operatingsystem__title' => "Operativsystem",
    'ui__support#param_phone__title' => "Telefon",
    'ui__support#param_psabuild__title' => "Plesk build",
    'ui__support#param_psainsttype__title' => "Plesk installationstype",
    'ui__support#param_psaversion__title' => "Plesk version",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Værktøjer",

    'ui__reseller/traffic-history_unknown__short-title' => "Vis trafik efter forhandler",
    'ui__reseller/traffic-history_unknown__title' => "Vis trafik efter forhandler",
    'ui__reseller/traffic-history_unknown__description' => "Vis trafik efter forhandlerkonti.",
    'ui__reseller#list__title' => "Forhandlere",
    'accounts_list__name__filter_title' => "Navn",
    'accounts_list__resource__filter_title' => "Resurseforbrug",
    'resellers_list__filter_resource_usage_any' => "Alle",
    'resellers_list__filter_resource_usage_overuse' => "Overforbrug",
    'resellers_list__filter_resource_usage_normal' => "Indenfor grænserne",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Alle",
    'resellers_list__filter_status_blocked' => "Suspenderet",
    'resellers_list__filter_status_active' => "Aktiv",
    'resellers_list__filter_clients__filter_title' => "Vis",
    'resellers_list__filter_clients_on' => "Forhandlere og deres kunder",
    'resellers_list__filter_clients_off' => "Kun forhandlere",
    '__disk_usage' => "Anvendt diskplads",
    'ui__reseller/traffic_unknown__short-title' => "Vis trafik efter forhandler",
    'ui__reseller/traffic_unknown__title' => "Vis trafik efter forhandler",
    'ui__reseller/traffic#list__title' => "Trafik efter forhandler",
    'ui__reseller/traffic_unknown__description' => "Vis trafikforbrugsrapporter",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Trafik efter forhandler",

    '__reseller_name' => "Forhandlerens navn",
    '__reseller' => "Forhandlere",
    'resellertrafficlist_header' => "Vis trafik efter forhandler",
    '__reseller_personal' => "Trafik anvendt af forhandlerens domæner",
    'ui__reseller/traffic-history__short-title' => "Trafik efter forhandlere",
    'ui__reseller/traffic-history__title' => "Trafik efter forhandlere",
    'ui__reseller/traffic-history__description' => "Vis trafikforbrugsrapporter",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Tillad oversalg",
    'limits__reseller_oversell_description' => "Oversalg tillader forhandleren at sælge flere ressourcer end der faktisk blev reserveret til vedkommende. Hvis oversalg er tilladt, styres forhandleren af det faktiske ressourceforbrug i stedet for af den oprindelige ressourcereservering",
    'limits__overuse_block_text' => "Overforbrugspolitik",
    'limits__overuse_block_true_text' => "Overforbrug er ikke tilladt",
    'limits__reseller_overuse_block_true_description' => "Blokér overforbrug af ressourcer. Aktuelt ressourceforbrug kan ikke overstige start-ressourcereserveringen",
    'limits__overuse_block_false_text' => "Overforbrug er tilladt",
    'limits__reseller_overuse_block_false_description' => "Blokér ikke for overforbrug af ressourcer, men tillad at forhandleren bruger flere ressourcer end oprindelig leveret. Aktuelt ressourceforbrug kan overstige start-ressourcereserveringen",
    'limits__reseller_overuse_notify_text' => "Advisér kunden når ressourcegrænserne nås",
    'reseller_perm__manage_sh_access_disabled' => "Forhandler kan ikke tillade eller forbyde shell-adgang",
    'reseller_perm__manage_sh_access_chrooted' => "Forhandler kan begrænse adgang til kun et chrooted-miljø",
    'reseller_perm__manage_sh_access_any' => "Forhandler kan tillade adgang til alle typer shell",
    'template__reseller_num_excl_ips' => "Reservér dedikerede IP-adresser til forhandleren.",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Konto",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Kunder",
    'ui__reseller#domainsTab__title' => "Domæner",
    'ui__reseller__title' => "Administrér %1's forhandlerkonto.",
    'domains__reseller_info' => "%1 kunder, %2 domæner, %3 anvendt diskplads, %4 data overført.",
    'domains__reseller_info_hiding_traffic' => "%1 kunder, %2 domæner, %3 anvendt diskplads.",
    'ui__reseller__description' => "Administrér forhandlers konto",

    'ui__reseller/limits_unknown__wizard-title' => 'Vis eller redigér ressourcegrænser for en forhandler',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Vælg den ønskede forhandler.',
    'ui__reseller/limits_unknown__wizard__2' => 'Klik på Færdig for at afslutte guiden.',

    'ui__client/report_reseller__short-title' => "Rapport",
    'ui__client/report_reseller__title' => "Vis forhandlerrapport",
    'ui__client/report_reseller__description' => "Vis forhandlerkontorapport.",
    'ui__client/ip-pool_reseller__short-title' => "IP-pulje",
    'ui__client/ip-pool_reseller__description' => "Tildel IP-adresser og SSL/TLS-certifikater til forhandlerkontoen.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Angiv kontoindstillingerne og klik på Færdig.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Vis eller redigér tilladelser for en forhandler',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Vælg den forhandler, hvis tilladelser du vil se eller ændre.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Når du er færdig med at ændre forhandlerens tilladelser, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    // Customers > create customer account

    '__resellers_list' => 'Forhandlere',
    'picker_reseller__title' => 'Vælg forhandleren',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Værktøjer",
    'ui__client#tools2__title' => "Konto",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Kunder",
    'ui__client#domainslist__title' => "Domæner",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Alle webprogrammer sorteres nu efter kategori, hvilket gør det nemmere at vælge det rette program til installation.",
    'feature__domainkeys__reseller' => "Du kan bruge DKIM e-mail afsender-godkendelsesmekanismen til at reducere mængden af spam og phishing e- mails.",

    '__reseller_form' => "Forhandlerformular",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Vælg den kundekonto, hvis indstillinger du vil ændre.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Du kan ændre ressourcegrænserne ved at klikke på Ressourcegrænser.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Du kan ændre tilladelser til handlinger, som kunden kan udføre i Plesk, ved at klikke på Tilladelser.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Gør denne skabelon tilgængelig for andre brugere.",
    'template__shared_description' => "Vælg denne indstilling hvis du ønsker at kunderne skal kunne bruge denne skabelon.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Værktøjer',

    'ui__client/traffic-history_unknown__short-title' => 'Vis trafikforbrug sorteret efter kunder',
    'ui__client/traffic-history_unknown__title' => 'Trafikforbrug efter kunder',
    'ui__client/traffic-history_unknown__description' => 'Vis trafikforbrugsrapport for alle kunder.',
    'ui__client/traffic-history__short-title' => 'Trafikforbrug efter kunder',
    'ui__client/traffic-history__title' => 'Vis trafikforbrug sorteret efter kunder',
    'ui__client/traffic-history__description' => 'Vis trafikforbrugsrapport for alle kunder.',

    'ui__client/traffic#list__title' => 'Trafikforbrug efter kunder',
    'ui__reseller/client/traffic#list__title' => 'Trafikforbrug efter kunder',

    'clients_list__filter_type__filter_title' => 'Vis',
    'clients_list__filter_type_any' => 'Kunder og forhandlere',
    'clients_list__filter_type_clients' => 'Kun kunder',
    'clients_list__filter_type_resellers' => 'Kun forhandlere',
    'ui__client/domain_unknown-new__short-title' => "Opret domæne",

    // Customers > View traffic by customers
    '__personal' => "Trafik anvendt af brugerens domæner",
    'PersonalTrafficList_header_of_client__' => "Vis trafikforbrugsrapport for din konto.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Domæneadministrator kan ikke tillade eller forbyde shell-adgang",
    'domain_perm__manage_sh_access_chrooted' => "Domæneadministrator kan begrænse adgang til kun et chrooted-miljø",
    'domain_perm__manage_sh_access_any' => "Domæneadministrator kan tillade adgang til alle typer shell",

    // APS Catalog
    'bt_add_to_vault' => "Føj til programbanken",
    'bt_hide_updates' => "Skjul opdateringer til rådighed",
    'bt_show_updates' => "Vis opdateringer til rådighed",

    '__site_apps__applications' => "Applikationer",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Antal programmer der er planlagt tilføjet programgruppen",
    'site_apps__application_selected' => "Valgt",
    'site_apps__currently_in_vault' => "Der ligger allerede andre versioner i programgruppen:",
    'site_apps__new_versions' => "Nye versioner:",
    'site_apps__patches' => "Rettelser:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Antal programmer der er planlagt tilføjet programgruppen: %1",
    'site_apps__applications_downloading_now' => "Følgende programmer downloades nu: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Allerede i programgruppen",

    // Server > Action Log
    'bt_skin_edit' => "Rediger temabeskrivelse",
    'limits__oversell_legend' => "Oversalg",
    'limitsManager__limit_available_error' => "Kunne ikke reservere den nødvendige mængde ressourcer (%%quantity%% %%limitName%%). Kun %%available%% %%limitName%% er til rådighed.",
    'limitsManager__limit_reserved_error' => "Kunne ikke indstille de påkrævede ressourceforbrugsgrænser (%%quantity%% %%limitName%%) fordi den nye værdi er mindre end mængden af ressourcer der er reserveret til dine kunder eller som du selv anvender (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Kunne ikke indstille de påkrævede ressourceforbrugsgrænser (%%quantity%% %%limitName%%) fordi den nye værdi er mindre end den faktiske mængde af ressourcer der allerede anvendes af din konto og dine websteder (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Båndbreddeforbrug efter services",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Vis anvendelsesrapporter trafik",
    'ui__client/domain/traffic_unknown-reseller__title' => "Vis anvendelsesrapporter trafik",

    'ui__client/domain_new__short-title' => "Opret domæne",

    'ui__client_reseller__description' => "Administrér forhandlerkonto %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Administrér forhandlerkonti.",

    '__owner_name' => "Ejers navn",
    'domains_list__resource__filter_title' => "Resurseforbrug",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS-programkatalog",
    'site_apps__applications_have_updates' => "Opdaterede versioner af følgende programmer er til rådighed: \n%1 \nFor at kunne se opdateringerne skal du sørge for at området Søg er synligt, markér afkrydsningsfeltet <b>Vis kun opdateringer</b> og søg efter de programmere, du har brug for.",
    'site_apps__progress_adding_to_vault' => "Føjer til programgruppen:",
    'site_apps__progress_done_message' => "Forløb:",
    'site_apps__progress_applications_left' => "%1 af %2 programmer tilbage",
    'site_apps__download_item_long_task_title' => "Download APS-program (%1)",
    'site_apps__download_transaction_long_task_title' => "Download APS-programmer fra APS-katalog",
    'site_apps__last_check_for_updates' => "seneste tjek om der er opdateringer %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Alle planlagte programmer er korrekt føjet til programgruppen",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 planlagte programmer er korrekt føjet til programgruppen",
    'site_apps__no_search_results' => 'Ingen applikationer fundet Prøv en anden søgeanmodning eller gennemse programmerne efter kategori.',
    'site_apps__search_results_title' => 'Søgeresultater',
    '__site_apps__search_by_application' => 'Applikationsnavn',
    '__site_apps__search_by_vendor' => 'Leverandør',
    '__site_apps__search_by_vendor__all' => 'Alle leverandører',
    '__site_apps__search_by_packager' => 'Objektpakning',
    '__site_apps__search_by_certification_level' => 'Certificeringsniveau',
    '__site_apps__search_by_cert__any' => 'Alle',
    '__site_apps__search_by_cert__silver_and_higher' => 'Sølv og højere',
    '__site_apps__search_by_cert__gold_and_higher' => 'Guld og højere',
    '__retry' => 'Prøv igen',
    'site_apps__application_packager_site' => 'Objektpakning',
    'site_apps__add_to_pool_message' => "Programmer, der er markeret som \"til rådighed for alle\" distribueres automatisk til alle forhandlere og kunder med ubegrænset mængde installationer. Begrænsede programmer distribueres til alle forhandlere og kunder manuelt på individuel basis, med et udtrykkeligt angivet antal installationer til rådighed.",
    'site_apps__make_available_for_all' => "Stil de markerede programmer til rådighed for alle brugere",

    'site_apps__broadcast_app_text' => "Programmer, der er markeret som \"til rådighed for alle\" distribueres automatisk til alle forhandlere og kunder med ubegrænset mængde installationer. Begrænsede programmer distribueres til alle forhandlere og kunder manuelt på individuel basis, med et udtrykkeligt angivet antal installationer til rådighed.",
    'site_apps__broadcast_app_name' => 'Stil programmet til rådighed for alle brugere',

    // User Application Pool per application
    'site_apps__available_clients' => 'Tilgængelige brugere',
    'site_apps__no_more_clients_to_add_to_pool' => 'Der er ikke flere brugerkonti, du kan levere dette program til',

    // Installed application instances
    'site_apps__installations' => 'Installationer',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Host-navn eller IP-adresse",
    '__assign_ip_address' => "Tildel IP-adresse",
    '__switch_on_service' => "Aktivér service",
    '__hosting_configuration' => "Hosting-konfiguration",
    '__vrt_hst' => "Webstedshosting",
    '__vrt_hst_hint' => "Vær host for et websted på denne server",
    '__fwd' => "Videresender",
    '__web_hosting_settings' => "Hosting-indstillinger",
    '__fwd_hint' => "Omdirigér besøgende til et andet websted",
    '__none_hint' => "Vær ikke host for et websted i øjeblikket",
    '__login_hint' => "Dette brugernavn anvendes til at få adgang til dit websted via FTP.",
    '__password_hint' => "Denne adgangskode anvendes til at få adgang til dit websted via FTP.",
    '__advanced_hosting_setup' => "Konfigurér avancerede websteds-hosting indstillinger.",
    '__domain_creation_successful' => "Domænet blev oprettet.",
    'bt_hosting_settings' => "Hosting-indstillinger",
    '__change_hosting_type' => "Ændring af host-type for domænet %1",
    '__hosting_type_change_warning' => "Når du ændrer hostingtypen til videresendelse eller ingen hosting, vil alle filer og mapper, der relaterer til dit websted, blive fjernet fra serveren. Sørg for at gemme en lokal kopi af webstedet.",
    '__current_hosting_type' => "Nuværende hosting-type",
    '__new_hosting_type' => "Ny hosting-type.",
    '__fwd_settings' => "Indstillinger for viderestilling",
    '__fwd_settings_legend' => "Indstillinger for viderestilling",
    '__fwd_destination_url' => "Destinations-URL",
    '__fwd_type' => "Videresendelsestype",
    '__fwd_type_standart' => "Standard-videresendelse",
    '__fwd_type_standart_hint' => "Omdirigér webstedsbesøgende til et andet websted og vis dem destinationsadressen, så de kender til omdirigeringen.",
    '__fwd_type_frame' => "Frame-videresendelse",
    '__fwd_type_frame_hint' => "Omdirigér webstedsbesøgende til et andet websted, men vis dem ikke destinationsadressen, så de er uvidende om omdirigeringen.",
    '__hosting_type_template_warning' => "Den valgte type hosting er forskellig fra den type, der er specificeret i skabelonen. Hvis du fortsætter, vil webhosting-indstillingerne i den valgte skabelon blive ignoreret. Er du sikker på, at du vil fjerne den markerede hostingtype?",

    '__no_resellers_selected' => "Du skal vælge mindst én forhandlerkonto.",

    'ui__client/logo_unknown__wizard-title' => 'Opsætning af logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis logo-egenskaber du vil ændre.',
    'ui__client/logo_unknown__wizard__2' => 'Klik på Færdig for at overføre ændringerne.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klik på Færdig for at overføre ændringerne.',

    'ui__client/ipaddress/properties_new__short-title' => "Tilføj IP-adresse",
    'ui__client/ipaddress/properties_new__title' => 'Tilføj IP-adresse',
    'ui__client/ipaddress/properties_new__description' => "Tilføj IP-adresse",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Tilføj IP-adresse",
    'ui__client/ipaddress/properties_unknown-new__title' => "Tilføj IP-adresse",
    'ui__client/ipaddress/properties_unknown-new__description' => "Tilføj IP-adresse",
    'ui__client/ipaddress/delete_multi__short-title' => "Fjern IP-adresse",
    'ui__client/ipaddress/delete_multi__description' => "Fjern IP-adresser",
    'ippool_Manager__no_available_ips' => "Der er ingen ledige IP-adresser i IP-gruppen.",
    'ippool_Manager__ip_shared' => "delt",
    'ippool_Manager__ip_exclusive' => "dedikeret",
    'ui__client/ipaddress/properties__title' => "Administrér IP-adresser",
    'ui__client/ipaddress/properties__description' => "Vis eller redigér IP-adresse egenskaber.",
    'ui__client/ipaddress_unknown-new__title' => "Tilføj IP-adresse",
    'ui__client/ipaddress_unknown-new__short-title' => "Tilføj IP-adresse",
    'ui__client/ipaddress_unknown-new__description' => "Tilføj IP-adresser.",

    'ui__mass-mail#to_resellers_text__title' => "Forhandlere",
    'ui__mass-mail#to_domainusers_text__title' => "Domæneadministratorer",
    'ui__mass-email#tools_legend__title' => "Værktøjer",
    'ui__mass-email#list_legend__title' => 'Masse e-mail meddelelses-skabeloner',
    'ui__mass-email#template_legend__title' => "Skabelon",
    'ui__mass-email#from_email_text__title' => "Fra",
    'ui__mass-email#to_text__title' => 'Til',
    'ui__mass-email#to_resellers_text__title' => "Forhandlere",
    'ui__mass-email#to_clients_text__title' => "Kunder",
    'ui__mass-email#to_domainusers_text__title' => "Domæneadministratorer",
    'ui__mass-email#to_admin_text__title' => "Plesk-administrator",
    'ui__mass-email#option_mode_all__title' => "Alle",
    'ui__mass-email#option_mode_select__title' => "Kun markerede",
    'ui__mass-email#option_mode_except__title' => "Alle bortset fra markerede",
    'ui__mass-email#option_select_template__title' => '---Vælg en skabelon---',
    'ui__mass-email#subject_text__title' => "Emne",
    'ui__mass-email#body_text__title' => "Beskedtekst",
    'ui__mass-email#save_as_legend__title' => "Gem som skabelon",
    'ui__mass-email#save_as_text__title' => "Gem sammensat meddelelse i en ny skabelon ved navn",
    'ui__reseller/preferences_unknown__wizard-title' => "Skift kontoindstillinger",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Vælg en forhandler hvis kontoindstillinger du vil ændre, og klik på Næste >>.",
    'ui__reseller/preferences_unknown__wizard__2' => "Angiv kontoindstillingerne og klik på OK.",
    'ippoolManager__ip_shared' => "delt",
    'ippoolManager__ip_exclusive' => "dedikeret",

    '__users_list' => "Brugere",
    '__users' => "Brugere",
    '__user_name' => "Brugerens navn",

    'limit__name_max_dom_aliases' => "domænealiasser",
    'limit__name_max_subftp_users' => "Ekstra FTP-konti",
    'limit__name_max_mssql_db' => "Microsoft SQL Server-databaser",
    'limit__name_max_iis_app_pools' => "IIS-programgrupper",
    'limit__name_max_odbc' => "ODBC-tilslutninger",
    'total_mboxes_quota_unsupported' => 'ikke understøttet af mailserveren.',
    'limit_soft__disk_space' => 'Advisér når diskpladsgrænsen nås',
    'limit_soft__max_traffic' => 'Advisér når trafikgrænsen nås',
    'limitsManager__commit_failed' => "Kunne ikke redigere resursebegrænsninger",
    'limitsManager__date_in_past' => "Forkert udløbsdato %1",
    'limitsManager__limit_not_supported' => "Begrænsninger af ressourcetypen %1 kan ikke indstilles.",
    'limitsManager__limit_oversell_inconsistency' => "Kunne ikke reservere de angivne ressourcemængder når oversalg er deaktiveret.",
    'limitsManager__limit_overuse_inconsistency' => "Ressourceanvendelsen overstiger de definerede grænser.",
    'limitsManager__no_resource_available' => "Der er ingen ressourcer af denne type til rådighed (%%limitName%%) tilbage. Anmodet om: %%quantity%%; available: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Der er ingen ressourcer af denne type (%%limitName%%) til rådighed hos din serviceudbyder. Anmodet om: %%quantity%%; available: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Udløbsdatoen skal være mindre end eller lig med %1",
    'limitsManager__invalid_disk_space_limit' => "Mængden af diskplads skal være mindre end eller lig med %1.",
    'limitsManager__invalid_max_traffic_limit' => "Mængden af trafik skal være mindre end eller lig med %1.",
    'ippoolManager__ip_has_suballocations' => "Kan ikke ændre typen af IP-adresse, der allerede er reserveret til en bruger. IP-adressen %%ip%% er allerede reserveret til bruger(e) som %%reserved%% IP-adresse.",
    'ippoolManager__ip_is_already_in_pool' => "Denne IP-adresse er allerede i knyttet til brugeren.",
    'ippoolManager__ip_is_not_in_pool' => "IP-adressen %%ip%% findes ikke i gruppen.",
    'ippoolManager__can_not_allocate_ip' => "IP-adressen %%ip%% er kun til rådighed som %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "IP-adressen %%ip%% kan ikke reserveres som dedikeret.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP-adressen %%ip%% bruges allerede til hosting",
    'ippoolManager__active_anon_ftp_on_ip' => "Anonym FTP-adgang er allerede aktiveret for IP-adressen %%ip%%",
    'ippoolManager__no_vacant_ips' => "Der er ingen ledige IP-adresser.",
    'ippoolManager__no_available_ips' => "Der er ingen IP-adresser til rådighed.",
    'templates__dublicate_name' => "Der findes allerede en skabelon med et sådant navn. Vælg et andet navn til denne skabelon.",
    'cl_perm__client_limits_exceeded' => "De angivne ressourcegrænseværdier overstiger de værdier, der er tilladt i din hostingplan, eller disse værdier giver færre ressourcer end aktuelt anvendt af dine websteder.",
    'cl_perm__reseller_limits_exceeded' => "De angivne ressourcegrænseværdier overstiger de værdier, der er tilladt i din hostingplan, eller disse værdier giver færre ressourcer end aktuelt anvendt af brugerkonti og websteder.",

    'site_apps__preferences_show_all_versions_title' => "Vis den fulde versionsliste for alle de programmer der hentes i kataloget",
    'site_apps__preferences_show_all_versions_hint' => "Hvis denne indstilling er valgt, kan det tage en betragtelig tid at hente alle versioner af hvert program, hver gang du åbner kataloget. Hvis denne indstilling ikke er valgt, vises kun de seneste versioner.",
    '__select_user_template' => "Opret brugerkonto på basis af en skabelon.",
    'ip_already_added_to_all_clients' => "Denne IP-adresse er allerede i knyttet til alle brugerne.",
    'ui__server/ip-address/client/delete#legend__description' => "Følgende IP-adresser vil blive fjernet fra systemet og brugerens IP-gruppe:",

    'site_apps__cancelled_apps' => "Du har annulleret tilføjelsen af følgende programmer: %2",

    'sb_url_is_not_resolved' => 'URL kan ikke oversættes: Kontrollér dine DNS-indstillinger. URL %1 skal oversættes i IP-adressen til den server, hvor Presence Builder er installeret.',

    'ip_addr__is_last_on_interface' => 'Kan ikke fjerne IP-adressen %%ip%% fordi det er den sidste IP-adresse der findes i en netværksgrænseflade.',
    'ip_addr__used_for_current_session' => 'Kan ikke fjerne IP-adressen %%ip%% fordi den bruges til afsendelse af en aktiv session.',
    'ip_addr__used_for_hosting' => 'Kan ikke fjerne IP-adressen %%ip%% fordi den bruges til hosting af et websted.',
    'ip_addr__is_main' => 'Kan ikke fjerne IP-adressen %%ip%% fordi det er den primære IP-adresse der findes i en netværksgrænseflade.',
    'ip_addr__ip_used_by_message_submission' => 'Kan ikke fjerne IP-adressen %%ip%% fordi den bruges til afsendelse af e-mail meddelelse',

    // RESELLER ACTION LOG

    '__cl_domains' => 'kundedomæner',
    'excl_ip_num' => 'Dedikeret IP-adresse.',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder er ikke installeret',

    '__perm_allow_oversell_can_not_be_revoked' => 'Tilladelse til oversalg kan ikke tilbagekaldes fra brugeren, da brugeren allerede har reserveret flere ressourcer end der er til rådighed, ved at gå i oversalgs-tilstand.',
    'limitsManager__invalid_limit_value' => 'Forkert værdi %%value%% angivet for begrænsningen %%limit_name%%',
    'confirmationForm_default_agreement_text' => 'Bekræft handlingen',
    'confirmationForm_default_confirm_message' => 'Bekræft handlingen.',
    'limit__max_mn' => 'Maksimalt antal e-mail konti',

    'limits__client_overuse_description' => 'Overforbrugspolitikken fortæller Plesk hvad der skal ske, hvis ressourceforbruget overstiger start-ressourcereserveringen.',
    'limits__client_overuse_block_true_description' => 'Blokér overforbrug af ressourcer. Aktuelt ressourceforbrug kan ikke overstige start-ressourcereserveringen',
    'limits__client_overuse_block_false_description' => 'Blokér ikke for overforbrug af ressourcer, men tillad at kunden bruger flere ressourcer end oprindelig leveret. Aktuelt ressourceforbrug kan overstige start-ressourcereserveringen',
    'limits__client_overuse_notify_text' => 'Advisér kunden når ressourcegrænserne nås',

    'limits__domain_overuse_description' => 'Overforbrugspolitikken fortæller Plesk hvad der skal ske, hvis ressourceforbruget overstiger start-ressourcereserveringen.',
    'limits__domain_overuse_block_true_description' => 'Overforbrugspolitikken fortæller Plesk hvad der skal gøres, hvis ressourcer overforbruges.',
    'limits__domain_overuse_block_false_description' => 'Blokér ikke for overforbrug af ressourcer, men tillad at domænet bruger flere ressourcer end oprindelig leveret. Aktuelt ressourceforbrug kan overstige start-ressourcereserveringen',
    'limits__domain_overuse_notify_text' => 'Advisér domæneejeren når ressourcegrænserne nås',


    'cancel_remove' => 'Kassér eventuelle ændringer og vend tilbage til foregående side.',

    'dns__dns_rr_delete' => 'Elementer der vil blive fjernet:',
    'dns__delete_rr' => 'Følgende DNS-poster vil blive fjerner fra DNS-zonen:',
    'dns__dns_rr_delete_non_removable' => 'Elementer der ikke kan fjernes',
    'dns__non_delete_rr' => 'Følgende DNS-poster kan ikke fjernes:',
    'dns__dns_rr_delete_confirm_message' => 'Bekræft fjernelsen af DNS-poster',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Ukendt webprogramformat: Webapplikationen er muligvis ikke til rådighed for installation og brug.',

    '__php_handler_type_desc' => 'Kør PHP som',
    'sfdk_domain_sign__failed' => 'Uidentificeret fejl opstod ved forsøg på at aktivere signering af e-mail med DKIM på domænet. Se serverens fejllog for yderligere information.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Advisering om Plesk nøgleopdateringssucces',
    'pkey_notify__subj_update_deferral_notification' => 'Advisering om Plesk nøgleopdateringsudsættelse',
    'pkey_notify__subj_update_error_notification' => 'Advisering om Plesk nøgleopdateringsfejl',
    'pkey_notify__update_successful' => '%1 opdateringen er korrekt gennemført.',
    'pkey_notify__update_failed_no_more_try' => 'Kunne ikke opdatere %1. Den nøgle, du prøver at sende, er ugyldig. Du bør ikke prøve at opdatere denne nøgle mere.',
    'pkey_notify__update_failed_try_later' => 'Kunne ikke opdatere %1: Der opstod en fejl under behandling af nøglen. Du kan prøve at hente nøglen manuelt i Plesk (Funktioner & Indstillinger>Information om licens) eller lade Plesk forsøge at opdatere den i løbet af de næste 24 timer. Hvis du ikke ønsker at modtage denne advisering mere, skal du fjerne denne nøgle fra Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Kunne ikke deaktivere server-bred spamfiltrering.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Kunne ikke aktivere server-bred spamfiltrering.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domæner',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Videresendelse',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'AntiSpam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Kunder',
    '__cl_name' => 'Kundenavn',
    '__cl_creation_date' => 'Oprettelsesdato',
    '__clients_traffic' => 'Kundetrafik.',
    'rpt_reseller_cl_mail_antispam' => 'AntiSpam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder er ikke installeret',
    'sitebuilder_disabled' => 'Presence Builder er deaktiveret.',
    'b_sitebuilder_disabled' => 'Presence Builder er deaktiveret.',
    'webmail_not_installed' => 'Webmail-software er ikke installeret.',
    'webmail_disabled' => 'Webmail-service er deaktiveret.',
    'spamassassin_not_installed' => 'SpamAssassin er ikke installeret.',
    // pfu:
    'anonymous_ftp_shared' => 'Kunne ikke oprette anonym FTP: Delt IP-adressetype.',
    'anonymous_ftp_used' => 'Kunne ikke oprette anonym FTP: IP-adressen bruges af et andet domæne til anonym FTP-service.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET er ikke installeret',
    'site_builder_no_package' => 'Presence Builder er ikke til rådighed Kontrollér at Presence Builder er installeret og valgt som en aktiv komponent.',
    'site_builder_not_configured' => 'Presence Builder er ikke konfigureret',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Værktøjer',
    'ui__reseller/client#clientslist__title' => 'Kunder',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Administrér virtuelle mapper på et websted',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Vælg det websted, hvis mapper du vil administrere.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Opsæt anonym FTP på domæne.',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Vælg det domæne, du vil opsætte anonym FTP på.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Opsæt logmanager for domæne og se domæne-logfiler',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Vælg det domæne, hvis log-manager du vil opsætte og hvilke logfiler du vil se.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Administrér SSL/TLS-certifikater for domænet',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Vælg det domæne, hvis SSL/TLS-certifikater, du vil administrere.',

    'ui__client/domain/disable_multi__wizard-title' => 'Suspendér domæner',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Vælg de domæner, du vil suspendere.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktivér domæner.',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Vælg de domæner, du vil aktivere.',

    'ui__client/domain_unknown__wizard-title' => 'Vis domæner',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Vælg den kunde, hvis domæner du vil se.',

    'ui__client/domain/register_unknown__wizard-title' => 'Registrér domæne',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Vælg de domæner, du vil registrere.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Brug Værktøjer fra MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Vælg det domæne, du vil administrere med værktøjer fra MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP-adresse brugere',
    'ui__server/ip-address/client_unknown__title' => 'IP-adresse brugere',
    'ui__server/ip-address/client_unknown__description' => 'Brugere af IP-adressen %1',

    'disabled_by_admin' => 'Deaktiveret af serveradministrator',






    'ui__client/domain/chowner_multi__short-title' => 'Skifter ejerskabet',
    'ui__client/domain/chowner_multi__title' => 'Skift abonnements-ejerskab',
    'ui__client/domain/chowner_multi__description' => 'Skift abonnements-ejerskab',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Vælg de domæner, du vil skifte ejerskab for, og klik på Næste.',
    'ui__client/domain/chowner_unknown__short-title' => 'Skifter ejerskabet',
    'ui__client/domain/chowner_unknown__title' => 'Skift abonnements-ejerskab',
    'ui__client/domain/chowner_unknown__description' => 'Skift abonnements-ejerskab',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Skift abonnements-ejerskab',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Der er ikke nogen brugerdefinerede knapper.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Der er ingen brugerdefinerede knapper i forhandleren %1\'s brugerflade.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Fjern knappen %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Fjern knappen %1.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Fjern brugerdefinerede knapper fra forhandlerens brugerflade',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Fjern brugerdefinerede knapper',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern knapper',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Vælg en forhandler hvis brugerdefinerede knapper du vil fjerne, og klik på Næste >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Vælg de knapper, du vil fjerne, og klik på Næste >>',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bekræft fjernelse af knapperne ved at markere afkrydsningsfeltet på dette skærmbillede og derefter klikke på Færdig.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Fjern en brugerdefineret knap fra forhandlerens brugerflade',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Fjern en brugerdefineret knap',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern brugerdefineret knap',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Vælg en forhandler hvis brugerdefinerede knap du vil fjerne, og klik på Næste >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Vælg den brugerdefinerede knap, du vil fjerne, og klik på Næste >>',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bekræft fjernelse af de brugerdefinerede knapper ved at markere afkrydsningsfeltet på dette skærmbillede og derefter klikke på Færdig.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Redigér egenskaberne for brugerdefineret knap på forhandlerniveau %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Indstillinger',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Redigér forhandlerens brugerdefinerede knap %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Tilføj brugerdefineret knap',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Vælg en forhandler i hvis du vil oprette en brugerdefineret knap, og klik på Næste >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klik på Færdig for at oprette knappen.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Redigér egenskaber for en knap i forhandlerens brugerflade.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaber',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Redigér egenskaber for en knap i forhandlerens brugerflade',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Rediger brugerdefineret knaps egenskaber',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Vælg en forhandler hvis brugerdefinerede knap du vil ændre, og klik på Næste >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Vælg den brugerdefinerede knap, du vil fjerne, og klik på Næste >>',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Når du er færdig med at ændre egenskaberne for knappen, kan du overføre ændringerne og forlade guiden ved at klikke på Færdig.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Gør knappen %1 utilgængelig for dine kunder.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Gør den utilgængelig for alle dine kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Gør knappen %1 utilgængelig for dine kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Gør knappen %1 synlig for forhandlerens kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Gør knappen tilgængelig for dine kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Gør knappen %1 synlig for forhandlerens kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Gør en brugerdefineret knap tilgængelig/utilgængelig for dine kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgængelig/utilgængelig for dine kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Gør en brugerdefineret knap tilgængelig eller utilgængelig for dine kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gør en brugerdefineret knap tilgængelig/utilgængelig for dine kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Vælg en forhandler, hvis brugerdefinerede knap du vil gøre tilgængelig for forhandlerens brugere, og klik på Næste >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Vælg en brugerdefineret knap, du vil gøre tilgængelig eller utilgængelig for dine kunder, og klik på Næste >>.',

    '__not_allowed' => 'Ikke tilladt',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Vælg en ny ejer til domænet',

    '__ip_addr_state_unknown' => "IP-adressen er ikke i drift endnu, da systemet stadig behandler din anmodning. Vent et øjeblik",


    'resellers_list__accounts' => 'Brugere',

    'ip_addr__repair_is_not_allowed' => 'IP-adressen kan ikke repareres i Virtuozzo-miljøet.',

    'ui__reseller/client__none-available__1' => 'Forhandleren %1 har ingen kunder.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP- adressen %%ip%% kan ikke fjernes, da den bruges af et eller flere domæner uden hosting.",
    'ippoolManager__ip_used_for_mail_service' => "I- adressen %%ip%% kan ikke fjernes, da den anvendes af et eller flere domæner til deres mailservice IP-adresse.",
    'ippoolManager__ip_used_for_send_emails' => "IP-adressen %%ip%% kan ikke fjernes, da den anvendes til afsendelse af emails fra en specifik IP (se Mailserver indstillinger).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP-adressen %%ip%% kan ikke fjernes, da den bruges af en DNS-zone for et eller flere domæner.',
    'ip_ctrl__cannot_manage_on_vz' => 'Denne installation af Plesk arbejder inde i Virtuozzo-containere. Nye IP-adresser kan kun tilføjes af Virtuozzo-containere nodeadministratoren.',

    'client_template__limits_auto_adjusted' => 'Grænser fra kundeskabelonen blev automatisk justerede.',

    '__entries' => 'Indlæg',

    '__path_is_not_set' => 'Stien er ikke angivet. Angiv en gyldig sti.',

    'defaultcomponents__imap_required' => '(Nuværende mailserver understøtter ikke IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk understøtter kun kommerciel webstatistik-software til underdomæne-statistikberegning. Der er ingen sådan software installeret i systemet i øjeblikket.',


    'server_settings_invalid_traffic_statistics' => 'Ugyldigt parameter for bevarelse af trafikstatistik.',
    'server_settings_invalid_logrotate_period' => 'Ugyldig parameter for logrotationsperiode.',

    'spam_filter/address/file_size' => 'Kan ikke uploade filen. Den maksimale uploadstørrelse for en fil er %1.',
    'spam_filter/address/file_empty_content' => 'Der var problemer med at læse e-mailadresser fra filen. Sørg for, at du uploader en fil i UTF-8-kodning, der indeholder en eller flere e-mailadresser, og prøv igen.',
    'spam_filter/address/addresses_empty_content' => 'Der er ingen e-mailadresser på listen.',
    'spam_filter/address/addresses_available' => 'Kun %1 første unikke e-mailadresser vil blive tilføjet.',
    'spam_filter/address/invalid_addresses' => 'Følgende e-mailadresser er ugyldige: %1',
];