<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => 'Applications installées',
    'app.instances.buttonCheckForUpdates' => 'Vérifier les mises à jour',
    'app.instances.buttonScan' => 'Analyser',
    'app.instances.hintButtonScan' => 'Analysez les fichiers de votre abonnement pour détecter les applications.',
    'app.instances.taskScan' => 'Analyse des applications en cours...',
    'app.instances.undefinedApp' => 'Non défini',
    'app.instances.name' => 'Nom',
    'app.instances.installedTo' => 'Chemin d\'installation',
    'app.instances.uninstall' => 'Supprimer',
    'app.instances.update' => 'Mise à jour disponible',
    'app.instances.noUpdates' => 'Aucune mise à jour n\'a été trouvée. Toutes les applications sont mises à jour.',
    'app.instances.foundUpdates' => 'Mises à jour disponibles :',
    'app.instances.noInstallationUrlAvailable' => 'Aucun(e)',

    'app.packages.title' => 'Applications disponibles',
    'app.packages.name' => 'Nom',
    'app.packages.version' => 'Version',
    'app.packages.summary' => 'Récapitulatif',
    'app.packages.install' => 'Installer',

    'app.services.title' => 'Services disponibles',
    'app.services.serviceID' => 'ID du service',
    'app.services.name' => 'Nom',
    'app.services.summary' => 'Récapitulatif',
    'app.services.instantiate' => 'Créer une instance',

    'app.subserviceinstances.remove' => 'Supprimer',
    'app.subserviceinstances.hintRemove' => 'Supprimez les instances du service sélectionnées.',
    'app.subserviceinstances.confirmOnDelete' => 'Voulez-vous vraiment supprimer les instances du service sélectionnées ?',
    'app.subserviceinstances.serviceName' => 'Nom du service',
    'app.subserviceinstances.userName' => 'Utilisateur',

    'contentfiles.name' => 'Nom',
    'contentfiles.changeDate' => 'Modifié',
    'contentfiles.size' => 'Taille',
    'contentfiles.permissions' => 'Droits',
    'contentfiles.user' => 'Utilisateur',
    'contentfiles.group' => 'Groupe',
    'contentfiles.buttonUploadFiles' => 'Téléverser le fichier',
    'contentfiles.buttonUploadDirectory' => 'Téléverser le répertoire',
    'contentfiles.buttonImportFileViaUrl' => 'Importer le fichier via l\'URL',
    'contentfiles.hintUploadFiles' => 'Envoyez les fichiers vers le répertoire actuel.',
    'contentfiles.buttonDeleteFile' => 'Supprimer',
    'contentfiles.hintDeleteFile' => 'Supprimez les fichiers sélectionnés.',
    'contentfiles.buttonPurgeFile' => 'Supprimer',
    'contentfiles.hintPurgeFile' => 'Supprimez définitivement les fichiers sélectionnés.',
    'contentfiles.buttonPurgeAll' => 'Vider la corbeille',
    'contentfiles.buttonRotationSettings' => 'Paramètres de rotation',
    'contentfiles.hintRotationSettings' => 'Personnaliser les paramètres de rotation',
    'contentfiles.hintPurgeAll' => 'Supprimez définitivement tous les fichiers et les répertoires de la corbeille.',
    'contentfiles.buttonCopyFiles' => 'Copier',
    'contentfiles.hintCopyFiles' => 'Copiez les fichiers sélectionnés vers un autre répertoire.',
    'contentfiles.buttonMoveFiles' => 'Déplacer',
    'contentfiles.hintMoveFiles' => 'Migrez les fichiers sélectionnés vers un autre répertoire.',
    'contentfiles.buttonMoreActions' => 'Plus',
    'contentfiles.buttonCalculateSize' => 'Calculer la taille',
    'contentfiles.hintCalculateSize' => 'Calculez la taille totale des fichiers sélectionnés.',
    'contentfiles.buttonChangeTimestamp' => 'Changer le Timestamp (horodatage)',
    'contentfiles.hintChangeTimestamp' => 'Changez le timestamp des fichiers sélectionnés.',
    'contentfiles.buttonArchiveActions' => 'Archive',
    'contentfiles.buttonExtractArchive' => 'Extraire les fichiers',
    'contentfiles.hintExtractArchive' => 'Extrayez les fichiers des archives sélectionnées dans le répertoire actuel.',
    'contentfiles.buttonCreateArchive' => 'Ajouter à l\'archive',
    'contentfiles.hintCreateArchive' => 'Ajoutez les fichiers sélectionnés à une archive.',
    'contentfiles.buttonNewActions' => 'Nouveau',
    'contentfiles.buttonNewFile' => 'Créer un fichier',
    'contentfiles.hintNewFile' => 'Créez un fichier.',
    'contentfiles.buttonNewDirectory' => 'Créer un répertoire',
    'contentfiles.hintNewDirectory' => 'Créez un répertoire.',
    'contentfiles.rootDirectory' => 'Répertoire principal',
    'contentfiles.buttonView' => 'Paramètres',
    'contentfiles.hintView' => 'Modifiez les paramètres du Gestionnaire de fichiers.',
    'contentfiles.confirmOnDelete' => 'Voulez-vous vraiment supprimer de manière permanente {count, plural, =1 {{name}} one {le fichier et le répertoire # sélectionné} other {les # fichiers et répertoires sélectionnés}} ?',
    'contentfiles.confirmOnDeleteToTrash' => 'Voulez-vous déplacer {count, plural, =1 {{name}} one {le fichier ou le répertoire {name} sélectionné} other {les # fichiers ou répertoires sélectionnés}} vers la poubelle ?',
    'contentfiles.deleteWithForce' => 'Ignorer la poubelle et supprimer de manière permanente {count, plural, =1 {{name}} one {le fichier ou le répertoire {name} sélectionné} other {les # fichiers ou répertoires sélectionnés}}.',
    'contentfiles.confirmOnPurge' => 'Voulez-vous vraiment supprimer de manière permanente {count, plural, =1 {{name}} one {le fichier et le répertoire {name} sélectionné} other {les # fichiers et répertoires sélectionnés}} ?',
    'contentfiles.confirmOnPurgeAll' => 'Voulez-vous supprimer définitivement tous les fichiers et les répertoires de la corbeille ?',
    'contentfiles.waitMessage' => 'Veuillez patienter...',
    'contentfiles.readonlyHint' => 'Ce répertoire est en lecture seule : vous ne pouvez pas créer de fichiers ou de répertoires dedans.',
    'contentfiles.directoryNotFound' => 'Impossible de créer le répertoire %%directory%% : %%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => 'Les liens symboliques hors de l\'espace Web sont interdits %%symlink%% : %%error%%',
    'contentfiles.dragAndDropArea' => 'Glisser/déposer les répertoires ou les fichiers ici pour les téléverser',
    'contentfiles.nonUTF8' => 'Le Gestionnaire de fichiers ne peut pas ouvrir les fichiers et les répertoires dont les noms contiennent des caractères non UTF-8.',
    'contentfiles.non4ByteChar' => 'Le Gestionnaire de fichiers ne peut pas ouvrir les fichiers et les répertoires dont les noms contiennent des caractères de 4 octets.',
    'contentfiles.searchInFilename' => 'Chercher dans le nom du fichier',
    'contentfiles.searchInFilenameAndContent' => 'Chercher dans le nom du fichier et dans le contenu',
    'contentfiles.searchInContent' => 'Chercher dans le contenu',
    'contentfiles.menuItemFilename' => 'Nom de fichier uniquement',
    'contentfiles.menuItemFilenameAndContent' => 'Nom de fichier et contenu',
    'contentfiles.menuItemContent' => 'Contenu uniquement',
    'contentfiles.noEntriesFound' => 'Aucun élément trouvé.',
    'contentfiles.loadingTitle' => 'Recherche...',
    'contentfiles.searchError' => 'Impossible de rechercher des fichiers dans le répertoire actuel.',
    'contentfiles.searchErrorTimeout' => 'La recherche a mis trop de temps et a été annulée.',
    'contentfiles.item-action-view' => 'Afficher',
    'contentfiles.item-action-textCodeEditor' => 'Éditer dans l\'éditeur de code',
    'contentfiles.item-action-visualEdit' => 'Éditer dans l\'éditeur HTML',
    'contentfiles.item-action-textEdit' => 'Éditer dans l\'éditeur de texte',
    'contentfiles.item-action-browse' => 'Ouvrir dans le navigateur',
    'contentfiles.item-action-logBrowser' => 'Ouvrir dans l\'Explorateur de journaux',
    'contentfiles.item-action-download' => 'Télécharger',
    'contentfiles.item-action-permissions' => 'Modifier les droits',
    'contentfiles.item-action-rename' => 'Renommer',
    'contentfiles.item-action-extractArchive' => 'Extraire les fichiers',
    'contentfiles.item-action-imageView' => 'Afficher',
    'contentfiles.imageViewer' => 'Visionneuse d\'images',
    'contentfiles.tooltipReadOnly' => 'Le répertoire actuel est en lecture seule : vous ne pouvez pas y créer de fichier ou de répertoire.',

    'database.issues.type' => 'Type',
    'database.issues.table' => 'Table',
    'database.issues.code' => 'Code',
    'database.issues.problem' => 'Problème',
    'database.issues.icon-title-att' => 'Avertissement',
    'database.issues.icon-title-warning' => 'Erreur',

    'database.users.login' => 'Nom',
    'database.users.server' => 'Serveur de bases de données',
    'database.users.database' => 'Base de données',
    'database.users.remove' => 'Supprimer',
    'database.users.hintRemove' => 'Supprimez les utilisateurs de la base de données sélectionnés.',
    'database.users.confirmOnDelete' => 'Voulez-vous vraiment supprimer {count, plural, =1 {l\'utilisateur de la base de données {login}} one {l\'utilisateur de la base de données sélectionné} other {les # utilisateurs de la base de données sélectionnés}}?',
    'database.users.disabledSelectHint' => 'Utilisé par une application Web installée',
    'database.users.orphanedHint' => 'Orphelin après le processus de restauration. Veuillez %%orphanedRepairLink%% le compte de l\'utilisateur.',
    'database.users.orphanedRepairLink' => 'réparer',
    'database.users.anyDatabase' => 'Toute base de données',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => 'Déplacer vers l\'abonnement',
    'databases.assignToSubscription_powerUser' => 'Déplacer vers l\'espace Web',
    'databases.assignToSubscriptionPopupTitle' => 'Déplacer les bases de données vers un autre abonnement',
    'databases.assignToSubscriptionPopupTitle_powerUser' => 'Déplacer les bases de données vers un autre espace Web',
    'databases.assignToSubscriptionPopupDesc' => 'Les bases de données sélectionnées seront déplacées vers l\'abonnement sélectionné. Les utilisateurs de bases de données seront déplacés également, sauf s\'ils ont accès à d\'autres bases de données.',
    'databases.assignToSubscriptionPopupDesc_powerUser' => 'Les bases de données seront déplacées vers l\'espace Web sélectionné. Les utilisateurs de bases de données seront également déplacés sauf s\'ils ont accès à d\'autres bases de données. Remarque : une fois déplacés, les anciens utilisateurs ne pourront pas ouvrir de base de données pour gérer ses contenus à l\'aide du lien dans Plesk.',
    'databases.loading' => 'chargement',
    'databases.name' => 'Nom',
    'databases.type' => 'T',
    'databases.server' => 'Serveur de bases de données',
    'databases.users' => 'Utilisateurs',
    'databases.remove' => 'Supprimer',
    'databases.hintRemove' => 'Supprimez les bases de données sélectionnées.',
    'databases.confirmOnDelete' => 'Voulez-vous vraiment supprimer {count, plural, =1 {la base de données {name}} one {la base de données sélectionnée} other {les # bases de données sélectionnées}} ?',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'Serveur MS SQL',
    'databases.serverMysql' => 'Serveur local MariaDB/MySQL',
    'databases.serverPostgresql' => 'Serveur local PostgreSQL',
    'databases.serverMssql' => 'Serveur MS SQL local',
    'databases.disabledSelectHint' => 'Utilisé par une application Web installée',
    'databases.buttonMakeCopy' => 'Copier',
    'databases.buttonMakeCopyHint' => 'Créez une copie exacte de la base de données ou copiez son contenu dans une base de données existante.',
    'databases.buttonWebadmin' => 'Admin Web',
    'databases.buttonWebadminHint' => 'Gérez les bases de données à l\'aide d\'une interface Web.',
    'databases.buttonConnectionInfo' => 'Infos de connexion',
    'databases.buttonConnectionInfoHint' => 'Consultez des informations comme le nom d\'hôte et les identifiants d\'accès de l\'utilisateur de bases de données. Ces informations sont requises pour se connecter à cette base de données.',
    'databases.buttonPhpMyAdmin' => 'phpMyAdmin',
    'databases.buttonMSSQLClientInstruction' => 'Télécharger un client SQL local',
    'databases.buttonMSSQLClientInstructionHint' => 'Télécharger un client SQL local',
    'databases.buttonDownloadDump' => 'Exporter le dump',
    'databases.buttonDownloadDumpHint' => 'Exportez une copie de cette base de données.',
    'databases.buttonUploadDump' => 'Importer le dump',
    'databases.buttonUploadDumpHint' => 'Importez votre copie de cette base de données.',
    'databases.buttonDelete' => 'Supprimer la base de données',
    'databases.buttonDeleteHint' => 'Supprimez cette base de données.',
    'databases.buttonDeleteDisabledHint' => 'Impossible de supprimer la base de données. Elle est utilisée par une application Web installée.',
    'databases.buttonDeleteConfirmationText' => 'Voulez-vous vraiment supprimer la base de données %%name%% ?',
    'databases.buttonActiveList' => 'Liste active',
    'databases.buttonActiveListHint' => 'Basculer entre les deux modes d\'affichage',
    'databases.buttonCheckAndFix' => 'Vérifier et réparer',
    'databases.buttonCheckAndFixHint' => 'Vérifiez s\'il y a des problèmes, comme une structure de table défaillante et résolvez les problèmes.',
    'databases.buttonAssignToSubscription' => 'Déplacer vers l\'abonnement',
    'databases.buttonAssignToSubscriptionHint' => 'Déplacez les bases de données vers un autre abonnement.',
    'databases.buttonAssignToSubscription_powerUser' => 'Déplacer vers l\'espace Web',
    'databases.buttonAssignToSubscriptionHint_powerUser' => 'Déplacez les bases de données vers un autre espace Web.',
    'databases.promptPassword' => 'Entrez le mot de passe pour vous connecter en tant qu\'utilisateur de base de données %%login%%.',
    'databases.promptPasswordPopupTitle' => 'Indiquer le mot de passe',
    'databases.taskCheckDatabase' => 'Vérifier la base de données',
    'databases.taskRepairDatabase' => 'Réparer la base de données',
    'databases.downloadTask' => 'Préparation d\'un dump de %%database%% pour l\'export...',
    'databases.downloadPopupTitle' => 'Exporter le dump',
    'databases.downloadHint' => 'Vous êtes sur le point de créer un dump de %%database%% et de le télécharger.',
    'databases.downloadRelativePath' => 'Enregistrer le dump dans le répertoire suivant',
    'databases.downloadDumpName' => 'Nom du fichier dump',
    'databases.downloadDumpAutomatically' => 'Télécharger automatiquement le dump après sa création',
    'databases.errorDumpNameEmpty' => 'Veuillez fournir un nom de dump.',
    'databases.errorDumpNameInvalid' => 'Un nom de dump ne doit pas contenir les caractères : %%chars%%.',
    'databases.errorDumpNameTooLong' => 'Le nom du fichier dump est trop long. Le chemin d\'accès vers un dump doit comporter moins de %%maxLength%% caractères.',
    'databases.uploadTask' => 'Importation d\'un dump de %%database%%...',
    'databases.uploadPopupTitle' => 'Importer le dump de la base de données',
    'databases.uploadHint' => 'Envoyez un dump depuis votre ordinateur local ou importez un dump enregistré sur votre serveur d\'hébergement.',
    'databases.uploadFromFile' => 'Envoyer',
    'databases.uploadFromWebspace' => 'Importer',
    'databases.recreateDatabase' => 'Recréer la base de données',
    'databases.uploading' => 'Importation...',
    'databases.waitMessage' => 'Veuillez patienter...',
    'databases.rootDirectory' => 'Répertoire root',
    'databases.connectionInfoTitle' => 'Informations de connexion pour %%database%%',
    'databases.connectionInfoDesc' => 'Vous pouvez utiliser les détails de connexion de cette base de données, par exemple, si vous devez les préciser pendant l\'installation d\'une app Web.',
    'databases.connectionInfoServerAddress' => 'Hôte',
    'databases.connectionInfoDatabaseName' => 'Nom de la base de données',
    'databases.connectionInfoUserLogin' => 'Nom de l\'utilisateur',
    'databases.connectionInfoUserPassword' => 'Mot de passe',
    'databases.connectionInfoNoUserLogin' => 'Aucun utilisateur par défaut',
    'databases.buttonClose' => 'Fermer',
    'databases.nothingFound' => "Aucune occurrence trouvée",
    'databases.moreObjectsAvailable' => 'Il y a %%count%% objets en plus disponibles.',

    'dnsaclrecords.value' => 'Adresse IP',
    'dnsaclrecords.add' => 'Ajouter une adresse IP',
    'dnsaclrecords.remove' => 'Supprimer',
    'dnsaclrecords.hintRemove' => 'Supprimez les adresses IP sélectionnées.',
    'dnsaclrecords.confirmOnDelete' => 'Voulez-vous supprimer les adresses IP sélectionnées ?',
    'dnsaclrecords.emptyViewTitle' => 'Zone de transfert non autorisée',
    'dnsaclrecords.emptyViewDescription1' => 'Pour des raisons de sécurité, vous pouvez autoriser le transfert de la zone DNS uniquement vers les serveurs spécifiés dans les enregistrements NS de la zone.',
    'dnsaclrecords.emptyViewDescription2' => 'Pour spécifier un ou plusieurs serveurs vers lesquels vous autorisez le transfert, cliquez sur "Ajouter une adresse IP".',

    'dnsrecords.host' => 'Hôte',
    'dnsrecords.type' => 'Type d\'enregistrement',
    'dnsrecords.value' => 'Valeur',
    'dnsrecords.nameServer' => 'Serveur de noms',
    'dnsrecords.ipAddress' => 'Adresse IP',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => 'Testez la zone DNS sur le serveur de nom.',
    'dnsrecords.remove' => 'Supprimer',
    'dnsrecords.removeRecord' => 'Voulez-vous supprimer %%selectedRowTitle%% ? Vous ne pourrez pas annuler cette action.',
    'dnsrecords.removeRecords' => 'Voulez-vous supprimer les enregistrements %%selectedRows%% ? Vous ne pourrez pas annuler cette action.',
    'dnsrecords.hintRemove' => 'Supprimez les enregistrements DNS sélectionnés.',
    'dnsrecords.confirmOnDelete' => 'Voulez-vous vraiment supprimer {count, plural, =1 {l\'enregistrement DNS {host}} one {l\'enregistrement DNS sélectionné} other {les # enregistrements DNS sélectionnés}}?',
    'dnsrecords.turnOff' => 'Désactiver',
    'dnsrecords.hintTurnOff' => 'Désactivez le service DNS local de la zone DNS %%name%%.',
    'dnsrecords.turnOn' => 'Activer',
    'dnsrecords.hintTurnOn' => 'Activer le service DNS local de la zone DNS % %%name%%',
    'dnsrecords.toggleTypeToSlave' => 'Passer au serveur secondaire',
    'dnsrecords.toggleTypeToMaster' => 'Passer au serveur principal',
    'dnsrecords.hintToggleTypeToMaster' => 'Cliquez pour que ce serveur se comporte comme serveur de noms principal pour la zone %%name%%.',
    'dnsrecords.hintToggleTypeToSlave' => 'Cliquez pour que ce serveur se comporte comme serveur de noms secondaire pour la zone %%name%%.',
    'dnsrecords.hintToggleTypeDisabled' => 'Impossible de changer le mode de fonctionnement de la zone DNS %%name%%, car c\'est un autre serveur qui la gère.',
    'dnsrecords.addRecord' => 'Ajouter un enregistrement',
    'dnsrecords.hintSpecifyNameServer' => 'Spécifiez un serveur de noms pour %%name%%.',
    'dnsrecords.hintAddPrimaryDns' => 'Ajouter un serveur DNS primaire pour %%name%%',
    'dnsrecords.hintAddRecord' => 'Créez une ressource dans la zone DNS %%name%%.',
    'dnsrecords.restoreDefault' => 'Rétablir le paramétrage initial',
    'dnsrecords.hintRestoreDefault' => 'Recréez la zone DNS conformément au template DNS valable pour tout le serveur. Tous les enregistrements de ressources personnalisés seront supprimés. Toutes les modifications appliquées par l\'utilisateur à la zone seront perdues.',
    'dnsrecords.syncZone' => 'Appliquer le template DNS',
    'dnsrecords.hintSyncZone' => 'Appliquez les modifications du template DNS valable pour tout le serveur à la zone. De nouveaux enregistrements de ressources pourront être ajoutés et les existants supprimés. Les enregistrements de ressources ajoutés ou modifiés par l\'utilisateur ne seront pas affectés.',
    'dnsrecords.applyChanges' => 'Les modifications que vous avez appliquées aux enregistrements DNS ne sont pas encore enregistrées. Les modifications sont marquées dans la liste des enregistrements. Cliquez sur Mettre à jour pour appliquer les changements à la zone DNS. Cliquez sur Annuler pour annuler les modifications.',
    'dnsrecords.updateButtonTitle' => 'Mettre à jour',
    'dnsrecords.updateButtonDescription' => 'Enregistrez les modifications des enregistrements DNS.',
    'dnsrecords.revertButtonTitle' => 'Annuler',
    'dnsrecords.revertButtonDescription' => 'Annulez les changements appliqués aux enregistrements DNS.',
    'dnsrecords.syncZoneFrom' => 'Appliquer les modifications du template DNS',
    'dnsrecords.moreActions' => 'Plus d\'actions',
    'dnsrecords.search' => 'Rechercher...',
    'dnsrecords.templateNotSynchronized' => 'Le template de zone DNS a été modifié et sera appliqué à tous les domaines créés récemment. Vous pouvez aussi %%link%%',
    'dnsrecords.templateNotSynchronizedLinkText' => 'appliquer les modifications à tous les domaines hébergés',
    'dnsrecords.soaTemplateNotSynchronized' => 'Le template SOA a été modifié et sera appliqué à tous les domaines créés récemment. Vous pouvez aussi %%link%%',

    'emails.name' => 'Adresse mail',
    'emails.owner' => 'Utilisateur',
    'emails.remove' => 'Supprimer',
    'emails.addNewEmail' => 'Créer une adresse mail',
    'emails.hintAddNewEmail' => 'Créez une adresse mail et affectez-la à un utilisateur.',
    'emails.recalculateUsage' => 'Actualiser les statistiques d\'utilisation',
    'emails.hintRecalculateUsage' => 'Recalculez l\'espace disque réel utilisé par les boîtes mail.',
    'emails.outgoingSpamSettings' => 'Limiter les messages sortants',
    'emails.hintOutgoingSpamSettings' => 'Définissez une limite des mails sortants pour les boîtes mail sélectionnées. Les boîtes mail sont chacune limitées au nombre de messages que vous avez spécifié.',
    'emails.searchByEmail' => 'Adresse mail',
    'emails.hintRemove' => 'Supprimez les adresses mail sélectionnées.',
    'emails.webMailDisabledHint' => 'Le logiciel de Messagerie Web n\'est pas installé.',
    'emails.webMailHint' => 'Ouvrez la messagerie Web pour cette adresse mail dans une nouvelle fenêtre de navigateur.',
    'emails.editHint' => 'Découvrez comment configurer votre compte mail dans un programme client de messagerie tel que Microsoft Outlook, Outlook Express, Thunderbird et Apple Mail.',
    'emails.confirmOnDelete' => 'Voulez-vous supprimer {count, plural, =1 {l\'adresse e-mail {name}} one {l\'adresse e-mail sélectionnée} other {les # adresses e-mail sélectionnées}} ?',
    'emails.redirectDetailsSingle' => '%%firstAddress%%',
    'emails.redirectDetailsMultiple' => '%%firstAddress%% (et %%countLeft%% plus)',
    'emails.autoresponderEnabled' => 'La réponse automatique est activée.',
    'emails.autoresponderEnabledTill' => 'La réponse automatique est activée jusqu\'au %%endDate%%.',
    'emails.spaceUsage' => 'Utilisation',
    'emails.noMailbox' => 'Aucune boîte mail',
    'emails.statusNotOperable' => 'Le service de messagerie est désactivé.',
    'emails.aliases' => '(%%aliases%%)',
    'emails.aliasesMore' => '(%%alias%% et %%count%% de plus)',

    'failedrequestfiles.downloadZip' => 'Télécharger le ZIP',
    'failedrequestfiles.downloadZipHint' => 'Téléchargez les fichiers sélectionnés dans une archive ZIP.',
    'failedrequestfiles.name' => 'Nom',
    'failedrequestfiles.modificationDate' => 'Date de modification',
    'failedrequestfiles.remove' => 'Supprimer',
    'failedrequestfiles.hintRemove' => 'Supprimez les fichiers sélectionnés de demandes ayant échoué.',
    'failedrequestfiles.confirmOnDelete' => 'Supprimer les fichiers sélectionnés de demandes ayant échoué ?',
    'failedrequestfiles.viewHint' => 'Cliquez pour afficher le fichier de demande ayant échoué.',
    'failedrequestfiles.buttonChangeTracing' => 'Changer les options du suivi',
    'failedrequestfiles.buttonChangeTracingHint' => 'Modifiez les paramètres définis actuellement pour le suivi des demandes ayant échoué.',
    'failedrequestfiles.buttonDisableTracing' => 'Arrêter le suivi',
    'failedrequestfiles.buttonDisableTracingHint' => 'Arrêtez le suivi.',
    'failedrequestfiles.buttonEnableTracing' => 'Démarrer le suivi',
    'failedrequestfiles.buttonEnableTracingHint' => 'Démarrez le suivi.',
    'failedrequestfiles.buttonRefresh' => 'Actualiser',
    'failedrequestfiles.buttonRefreshHint' => 'Cliquez ici pour afficher toutes les demandes ayant échoué en fonction des critères définis. Remarque : les demandes ayant échoué récemment loguées ne sont pas affichées automatiquement.',

    'files.name' => 'Nom',
    'files.modificationDate' => 'Modifié',
    'files.size' => 'Volume',
    'files.share' => 'Partager',
    'files.shareHint' => 'Migrez les fichiers sélectionnés vers le dossier Fichiers partagés et mettez-les à disposition de tous les employés autorisés dans Plesk.',
    'files.publish' => 'Publier',
    'files.publishHint' => 'Copiez les fichiers publics dans le dossier Fichiers publics, les rendant accessibles à vos clients et visiteurs de site Web. Vous pouvez protéger l\'accès à ces fichiers par un mot de passe.',
    'files.email' => 'Envoyer par mail un lien',
    'files.emailHint' => 'Envoyez un lien par mail pour accéder aux fichiers sélectionnés pour d\'autres employés et clients.',
    'files.delete' => 'Supprimer',
    'files.deleteHint' => 'Supprimez les fichiers sélectionnés.',
    'files.moreActions' => 'Plus',
    'files.createFolder' => 'Nouveau dossier',
    'files.createFolderHint' => 'Créer un dossier dans le dossier actuel',
    'files.copy' => 'Copier',
    'files.copyHint' => 'Copiez les dossiers ou fichiers sélectionnés vers la destination de votre choix.',
    'files.move' => 'Déplacer',
    'files.moveHint' => 'Migrez les dossiers ou fichiers sélectionnés vers la destination de votre choix.',
    'files.protectedDescription' => 'L\'accès aux fichiers dans ce dossier est protégé par un mot de passe. Les utilisateurs seront invités à fournir ce mot de passe lorsqu\'ils essaieront d\'accéder à ces fichiers.',
    'files.nothingSelected' => 'Aucun dossier ou fichier n\'a été sélectionné.',

    'gitrepositories.lastCommitInfo' => 'Infos du dernier commit :',
    'gitrepositories.deploymentActions' => 'Actions de déploiement supplémentaires :',

    'logfiles.name' => 'Nom',
    'logfiles.path' => 'Chemin d\'accès',
    'logfiles.modificationDate' => 'Date de modification',
    'logfiles.fileSize' => 'Taille',
    'logfiles.logRotation' => 'Rotation des journaux',
    'logfiles.logRotationHint' => 'Configurez les paramètres de rotation des journaux pour le site Web.',
    'logfiles.logRotationTitle' => 'Configurer la rotation des journaux',
    'logfiles.remove' => 'Supprimer',
    'logfiles.hintRemove' => 'Supprimez les fichiers journaux sélectionnés. Vous ne pouvez supprimer que les fichiers journaux traités.',
    'logfiles.confirmOnDelete' => 'Supprimer les fichiers journaux sélectionnés ?',
    'logfiles.viewHint' => 'Cliquez pour voir le fichier journal.',
    'logfiles.buttonDownloadHint' => 'Cliquez ici pour télécharger le fichier journal.',
    'logfiles.buttonViewHint' => 'Cliquez ici pour afficher le fichier journal dans une nouvelle fenêtre.',
    'logfiles.addCustomLog' => 'Ajouter un fichier journal personnalisé',
    'logfiles.addCustomLogHint' => 'Ouvrez tout fichier dans l\'Explorateur de journaux.',
    'logfiles.customLogPopupTitle' => 'Ajouter un fichier journal personnalisé',
    'logfiles.invalidLogFormat' => 'Le fichier journal a un format non pris en charge.',
    'logfiles.buttonUnlinkHint' => 'Cliquez pour arrêter de suivre les mises à jour dans ce fichier dans l\'Explorateur de journaux.',
    'logfiles.buttonUnlinkConfirmationDescription' => 'Êtes-vous sûr de vouloir arrêter de suivre les mises à jour dans ce fichier dans l\'Explorateur de journaux ?',
    'logfiles.buttonUnlinkConfirmationYes' => 'Oui',
    'logfiles.buttonUnlinkConfirmationNo' => 'Non',
    'logfiles.accessLog' => 'Accès Apache',
    'logfiles.accessLogProcessed' => 'Accès Apache (rotated)',
    'logfiles.accessSslLog' => 'Accès SSL/TLS Apache',
    'logfiles.accessSslLogProcessed' => 'Accès SSL/TLS Apache (rotation)',
    'logfiles.errorLog' => 'Erreur Apache',
    'logfiles.proxyAccessLog' => 'Accès Nginx',
    'logfiles.proxyAccessSslLog' => 'Accès SSL/TLS Nginx',
    'logfiles.proxyErrorLog' => 'Erreur Nginx',
    'logfiles.phpErrorLog' => 'Erreur PHP',
    'logfiles.iisAccessLog' => 'Accès IIS',
    'logfiles.iisLog' => 'IIS (%%name%%)',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',
    'logfiles.laravel' => 'Laravel',
    'logfiles.dotnetcore' => '.NET Core',

    'maillists.title' => 'Listes de diffusion',
    'maillists.remove' => 'Supprimer',
    'maillists.name' => 'Adresse',
    'maillists.subscribers' => 'Abonnés',
    'maillists.hintRemove' => 'Supprimez les listes de diffusion sélectionnées.',
    'maillists.confirmOnDelete' => 'Supprimer les listes de diffusion sélectionnées ?',
    'maillists.openWebPanel' => 'Gérer la liste',
    'maillists.statusNotEnabled' => 'Désactivé.',
    'maillists.statusNotOperable' => 'Le service des listes de diffusion est désactivé.',

    'mailsettings.name' => 'Nom de domaine',
    'mailsettings.mailService' => 'Service de messagerie',
    'mailsettings.webmail' => 'Messagerie Web',
    'mailsettings.nonexist' => 'Mails envoyés à des utilisateurs inexistants',
    'mailsettings.webmailNone' => 'Aucun(e)',
    'mailsettings.nonExistBounce' => 'Rejeter avec un message',
    'mailsettings.nonExistCatch' => 'Transférer vers %%catchAddress%%',
    'mailsettings.nonExistCatchDescription' => 'Cette adresse doit appartenir au domaine sélectionné. Seul l\'administrateur peut indiquer une adresse externe ou une adresse pour plusieurs domaines.',
    'mailsettings.nonExistExternal' => 'Rediriger vers %%catchIp%%',
    'mailsettings.nonExistReject' => 'Rejeter',
    'mailsettings.nonExistDiscard' => 'Rejeter',
    'mailsettings.statusEnabled' => 'Activé',
    'mailsettings.statusDisabled' => 'Désactivé',
    'mailsettings.statusDisabledIncoming' => 'Entrants désactivés',
    'mailsettings.statusNotConfigured' => 'Non configuré',
    'mailsettings.searchByName' => 'Nom de domaine',
    'mailsettings.editOutgoingSpamSettings' => 'Éditer la limite',
    'mailsettings.numberOutgoingMessages' => 'Nombre de messages sortants',

    'roles.title' => 'Rôle de l\'utilisateur',
    'roles.name' => 'Nom du rôle',
    'roles.description' => 'Description',
    'roles.remove' => 'Supprimer',
    'roles.numberOfUsers' => 'Utilisateurs',
    'roles.hintRemove' => 'Supprimez les rôles d\'utilisateurs sélectionnés. Les rôles peuvent être supprimés uniquement s\'ils ne sont affectés à aucun compte utilisateur.',
    'roles.disabledSelectHint' => 'Ce rôle est affecté à un ou plusieurs comptes utilisateur. Les rôles peuvent être supprimés uniquement s\'ils ne sont affectés à aucun compte utilisateur.',
    'roles.builtInItemHint' => 'Impossible d\'éditer ou de supprimer ce rôle.',
    'roles.confirmOnDelete' => 'Supprimer les rôles d\'utilisateurs sélectionnés ?',

    'sites.selectfrontpage.domain' => 'Domaine',
    'sites.selectfrontpage.linkManage' => 'Gérer',

    'sites.selectstatistics.domain' => 'Domaine',
    'sites.selectstatistics.linkView' => 'Voir',

    'sites.selecttrafficstatistics.domain' => 'Domaine',
    'sites.selecttrafficstatistics.linkView' => 'Afficher',

    'sites.unitymobile.website' => 'Site Web',
    'sites.unitymobile.mobileSite' => 'Nom du site mobile',
    'sites.unitymobile.createSite' => 'Créer le site mobile',
    'sites.unitymobile.launchEditor' => 'Éditer le contenu du site',
    'sites.unitymobile.changeSiteName' => 'Changer le nom du site',
    'sites.unitymobile.delete' => 'Supprimer',
    'sites.unitymobile.confirmDeleteTitle' => 'Voulez-vous vraiment supprimer ce site mobile ?',
    'sites.unitymobile.confirmDeleteDescription' => 'Tout le contenu du site sera perdu.',

    'sites.domainHeader' => 'Domaine',
    'sites.hostingHeader' => 'Hébergement',
    'sites.diskUsage' => 'Utilisation du disque',
    'sites.traffic' => 'Trafic',
    'sites.buttonAddDomain' => 'Ajouter un domaine',
    'sites.buttonAddDomainHint' => 'Hébergez un nouveau site Web sur ce serveur, configurez la redirection Web vers un autre site Web ou configurez une zone DNS de domaine si vous voulez avoir uniquement des adresses mail sous un domaine.',
    'sites.buttonAddSubdomain' => 'Ajouter un sous-domaine',
    'sites.buttonAddSubdomainHint' => 'Créez un site dont l\'adresse est celle d\'un nom de domaine tiers comme "shop.exemple.com".',
    'sites.buttonAddDomainAlias' => 'Ajouter un alias de domaine',
    'sites.buttonAddDomainAliasHint' => 'Configurez un autre nom de domaine pour votre site.',
    'sites.buttonRemove' => 'Supprimer',
    'sites.buttonRemoveHint' => 'Supprimez les sites sélectionnés et tout leur contenu Web, dont les applications et les données de messagerie.',
    'sites.buttonActivate' => 'Activer',
    'sites.buttonSuspend' => 'Suspendre',
    'sites.buttonClassicList' => 'Liste classique',
    'sites.buttonClassicListHint' => 'Basculer entre les deux modes d\'affichage',
    'sites.buttonActiveList' => 'Liste active',
    'sites.buttonActiveListHint' => 'Basculer entre les deux modes d\'affichage',
    'sites.buttonDynamicList' => 'Liste dynamique',
    'sites.buttonDynamicListHint' => 'Basculer entre les deux modes d\'affichage',
    'sites.buttonFileManager' => 'Gestionnaire de fichiers',
    'sites.buttonMail' => 'Boîte mail',
    'sites.buttonDatabases' => 'Bases de données',
    'sites.buttonDatabasesCreate' => 'Ajouter une base de données',
    'sites.buttonDatabasesTogglerText' => 'ou',
    'sites.buttonDatabasesToggle' => 'Sélectionner une base de données existante',
    'sites.buttonDatabasesEdit' => 'Ouvrir',
    'sites.buttonDatabasesPromptPassword' => 'Entrez le mot de passe pour vous connecter en tant qu\'utilisateur de base de données %%login%%.',
    'sites.removeConfirmation' => 'Voulez-vous supprimer {count, plural, =1 {le site {name}} one {le site sélectionné} other {les # sites sélectionnés}} ?',
    'sites.removeConfirmationSubscription' => "Les sites suivants seront également supprimés : \n%%domains%%",
    'sites.manageFilesHint' => 'Allez dans le dossier du site Web pour gérer les fichiers du site Web.',
    'sites.sitebuilderHint' => 'Modifiez le site dans Presence Builder.',
    'sites.webstatisticsHint' => 'Affichez les statistiques de visiteurs du site Web.',
    'sites.webstatisticsSslHint' => 'Consultez les rapports de visite de vos sites Web via SSL/TLS.',
    'sites.certificatesHint' => 'Gérez les certificats SSL/TLS.',
    'sites.logsHint' => 'Affichez les journaux.',
    'sites.previewHint' => 'Prévisualisez le site Web dans votre navigateur.',
    'sites.dnsHint' => 'Changez les paramètres de la zone DNS.',
    'sites.disabledSelectHint' => 'Impossible de supprimer le domaine.',
    'sites.websiteAt' => 'Site Web sur',
    'sites.noHosting' => 'Aucun hébergement Web',
    'sites.forwardingTo' => 'Transférer à',
    'sites.add' => 'Ajouter',
    'sites.name' => 'Nom de domaine',
    'sites.inactive' => 'Inactif',
    'sites.disabled' => 'Désactivé',
    'sites.suspended' => 'Suspendu',
    'sites.moreActions' => 'Plus d\'actions',
    'sites.domainAliasDescription' => 'Alias de %%siteDisplayName%% %%servicesDescription%%',
    'sites.domainAliasServiceDescription' => '(Services activés : %%service%%)',
    'sites.domainAliasServicesDescription' => '(Services activés : %%services%%)',
    'sites.web' => 'Web',
    'sites.mail' => 'Boîte mail',
    'sites.dns' => 'DNS',
    'sites.tomcat' => 'Apps Java',
    'sites.seoRedirect' => 'Redirection',
    'sites.sitebuilder' => 'Presence Builder',
    'sites.sitebuilderLink' => 'Éditer le site Web',
    'sites.error503PageLink' => 'Modifier la page d\'erreur',
    'sites.modeTitle' => 'Mode d\'affichage',
    'sites.quickStart' => 'Utilisez l\'une de ces méthodes pour créer votre site Web :',
    'sites.quickStartSitebuilderName' => 'Presence Builder.',
    'sites.quickStartSitebuilderDescription' => 'Créez votre site avec notre outil de création de site Web pro.',
    'sites.quickStartSitebuilderLink' => 'Créer un site',
    'sites.quickStartSiteJetBuilderName' => 'Utiliser Sitejet Builder',
    'sites.quickStartSiteJetBuilderDescription' => 'Créez votre site avec notre outil de création de site Web pro.',
    'sites.quickStartSiteJetBuilderLink' => 'Créer un site',
    'sites.quickStartApplicationsName' => 'Installer une application',
    'sites.quickStartApplicationsDescription' => 'Créez votre site en installant une application Web comme Joomla! ou Drupal.',
    'sites.quickStartApplicationsLink' => 'Installer les applications',
    'sites.quickStartCustomName' => 'Créer un site Web personnalisé',
    'sites.quickStartCustomDescription' => 'Envoyer votre contenu Web ou ajouter des bases de données',
    'sites.quickStartCustomFilesLink' => 'Fichiers',
    'sites.quickStartCustomDatabasesLink' => 'Bases de données',
    'sites.resellerDescription' => 'Revendeur',
    'sites.ownerDescription' => 'Client',

    'sites.filterDomainName' => 'Nom',
    'sites.filterStatus' => 'Statut',
    'sites.filterOptionStatusAny' => 'Aucun(e)',
    'sites.filterOptionStatusSuspended' => 'Suspendu',
    'sites.filterOptionStatusDisabled' => 'Désactivé',
    'sites.filterOptionStatusActive' => 'Actif',
    'sites.filterHostingType' => 'Type d\'hébergement',
    'sites.filterOptionHostingTypeAny' => 'Tou(te)s',
    'sites.filterOptionHostingTypeNone' => 'Aucun hébergement',
    'sites.filterOptionHostingTypeForward' => 'Redirection du domaine',
    'sites.filterOptionHostingTypeAlias' => 'Alias de domaine',
    'sites.filterOptionHostingTypeVirtualHost' => 'Hébergement du domaine',
    'sites.filterOptionHostingTypeSubdomain' => 'Hébergement du sous-domaine',
    'sites.filterOptionPhpHandlerAny' => 'Tou(te)s',
    'sites.filterDescription' => 'Description',

    'sslcertificates.name' => 'Nom',
    'sslcertificates.used' => 'Utilisé',
    'sslcertificates.csrHint' => 'Partie de CSR disponible.',
    'sslcertificates.noCsrHint' => 'Partie CSR non disponible.',
    'sslcertificates.privateKeyHint' => 'Partie de clé privée fournie.',
    'sslcertificates.noPrivateKeyHint' => 'Partie de clé privée NON fournie.',
    'sslcertificates.certificateHint' => 'Partie Certificat fournie.',
    'sslcertificates.noCertificateHint' => 'Partie du certificat non fournie.',
    'sslcertificates.caCertificateHint' => 'Partie CA Certificat fournie.',
    'sslcertificates.noCaCertificateHint' => 'Partie CA du Certificat NON fournie.',
    'sslcertificates.buttonDownloadHint' => 'Téléchargez tous les composants du certificat.',
    'sslcertificates.webmail' => 'Protéger la messagerie Web',
    'sslcertificates.hintWebmail' => 'Utilisez le certificat SSL/TLS pour protéger la messagerie Web sur le domaine.',
    'sslcertificates.remove' => 'Supprimer',
    'sslcertificates.hintRemove' => 'Supprimez les certificats SSL/TLS sélectionnés du répertoire de domaines.',
    'sslcertificates.confirmOnDelete' => 'Supprimer les certificats SSL/TLS sélectionnés ?',
    'sslcertificates.addCertificate' => 'Ajouter un certificat SSL/TLS',
    'sslcertificates.hintAddCertificate' => 'Ajoutez un certificat SSL/TLS.',
    'sslcertificates.viewCertificates' => 'Voir les certificats',
    'sslcertificates.hintViewCertificates' => 'Affichez la liste des certificats SSL/TLS achetés chez votre fournisseur.',
    'sslcertificates.webmailCertificate' => 'Protège la messagerie Web',
    'sslcertificates.mailCertificate' => 'Protège la messagerie',
    'sslcertificates.mailAndWebmailCertificate' => 'Protège la messagerie et la messagerie Web',
    'sslcertificates.mail' => 'Protéger la messagerie',
    'sslcertificates.hintMail' => 'Utilisez le certificat SSL/TLS sélectionné pour protéger la messagerie du domaine.',

    'subscriptions.subscription' => 'Abonnement',
    'subscriptions.price' => 'Frais',
    'subscriptions.renewalDate' => 'Date d\'expiration',
    'subscriptions.setupDate' => 'Date de configuration',
    'subscriptions.domains' => 'Sites Web',
    'subscriptions.systemUser' => 'Utilisateur système',
    'subscriptions.ipAddress' => 'Adresse IP',
    'subscriptions.addonDomains' => 'Domaines compagnons',
    'subscriptions.diskSpace' => 'Espace disque',
    'subscriptions.moreDomains' => '... et %%count%% domaines de plus',
    'subscriptions.buy' => 'Commander un nouveau service',
    'subscriptions.create' => 'Créer un abonnement',
    'subscriptions.create_powerUser' => 'Créer un espace Web',
    'subscriptions.renew' => 'Renouveler',
    'subscriptions.confirmOnCancel' => 'Annuler l\'abonnement ?',
    'subscriptions.subscriptionSuspended' => 'Suspendu',
    'subscriptions.myResources' => 'Mes ressources',
    'subscriptions.planName' => 'Pack de services',
    'subscriptions.switchToLink' => 'Switcher vers cet abonnement',
    'subscriptions.switchToLinkHint' => 'Switchez vers cet abonnement.',
    'subscriptions.switchToLinkPowerUser' => 'Switchez vers l\'espace Web.',
    'subscriptions.switchToLinkHintPowerUser' => 'Switchez vers cet espace Web.',
    'subscriptions.buttonRemove' => 'Supprimer',
    'subscriptions.buttonRemoveDescription' => 'Supprimer les espaces Web sélectionnés',
    'subscriptions.confirmOnDelete' => 'Supprimez les espaces Web sélectionnés?',
    'subscriptions.buttonAddNew' => 'Ajouter un espace Web',
    'subscriptions.buttonAddNewDescription' => 'Créez un espace Web.',
    'subscriptions.subscription_powerUser' => 'Espace Web',
    'subscriptions.subscriptionPowerUser' => 'Espace Web',
    'subscriptions.confirmOnCancel_powerUser' => 'Annuler l\'espace Web ?',
    'subscriptions.subscriptionSuspended_powerUser' => 'Suspendu',
    'subscriptions.switchToLink_powerUser' => 'Switchez vers l\'espace Web.',
    'subscriptions.switchToLinkHint_powerUser' => 'Switchez vers cet espace Web.',
    'subscriptions.primaryDomain' => 'Domaine primaire',
    'subscriptions.ftpAccess' => 'Accès FTP',

    'users.contactName' => 'Nom du contact',
    'users.email' => 'Adresse mail',
    'users.role' => 'Rôle',
    'users.contacts' => 'Contacts',
    'users.phone' => 'Téléphone',
    'users.roleFilter' => 'Rôle de l\'utilisateur',
    'users.filterAnyRole' => 'Tou(te)s',
    'users.activate' => 'Activer',
    'users.deactivate' => 'Suspendre',
    'users.remove' => 'Supprimer',
    'users.status' => 'Statut',
    'users.statusBlocked' => 'Inactif',
    'users.buttonAddNewUser' => 'Créer un compte utilisateur',
    'users.hintAddNewUser' => 'Créez un compte utilisateur.',
    'users.hintRemove' => 'Supprimez les comptes utilisateur sélectionnés.',
    'users.disabledSelectHint' => 'Ce compte utilisateur ne peut pas être supprimé car il s\'agit soit d\'un compte utilisateur pré-intégré soit de votre propre compte utilisateur.',
    'users.confirmOnDelete' => 'Supprimer les comptes utilisateur sélectionnés ?',

    'webusers.name' => 'Nom',
    'webusers.add' => 'Ajouter un utilisateur Web',
    'webusers.hintAdd' => 'Ajoutez un compte d\'utilisateur Web. %%resourceUsage%%',
    'webusers.settings' => 'Paramètres',
    'webusers.hintSettings' => "Paramètres de l'utilisateur Web.",
    'webusers.remove' => 'Supprimer',
    'webusers.hintRemove' => 'Supprimez les utilisateurs Web sélectionnés.',
    'webusers.confirmOnDelete' => 'Supprimer les utilisateurs Web sélectionnés ?',
    'webusers.buttonOpenHomepageHint' => "Cliquez pour visualiser la page d'accueil de l'utilisateur Web avec votre navigateur Web.",

    'virtualdirectories.protection' => 'P',
    'virtualdirectories.name' => 'Nom',
    'virtualdirectories.actionOpen' => 'Ouvrir dans le navigateur',
    'virtualdirectories.actionEdit' => 'Modifier les paramètres',
    'virtualdirectories.actionPermissions' => 'Gérer les droits',
    'virtualdirectories.up_levelType' => 'Niveau sup',
    'virtualdirectories.directoryType' => 'Répertoire physique',
    'virtualdirectories.virtual_directoryType' => 'Répertoire virtuel',
    'virtualdirectories.fileType' => 'Fichier physique',
    'virtualdirectories.protectionOn' => 'Ce répertoire est protégé.',
    'virtualdirectories.protectionOff' => 'Ce répertoire n\'est pas protégé.',
    'virtualdirectories.isMissing' => 'Ce répertoire virtuel est associé à un dossier physique inexistant.',
    'virtualdirectories.buttonRemove' => 'Supprimer',
    'virtualdirectories.noSelectionText' => 'Sélectionnez un ou plusieurs éléments à supprimer',
    'virtualdirectories.removeConfirmation' => 'Voulez-vous supprimer {count, plural, =1 {{name}} one {l\'élément sélectionné} other {# éléments}} ?',
    'virtualdirectories.removeSuccess' => 'Les éléments sélectionnés ont été supprimés.',
    'virtualdirectories.buttonCreateVirtualDir' => 'Créer un répertoire virtuel',
    'virtualdirectories.buttonCreateVirtualDirHint' => 'Créer un répertoire virtuel',
    'virtualdirectories.buttonCreateDir' => 'Créer un répertoire',
    'virtualdirectories.buttonCreateDirHint' => 'Créer un répertoire',
];