<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Zugriff verweigert. Ihr Konto wurde gesperrt.",
    'login_up__login_has_been_locked' => "Sie haben zu oft versucht, sich mit einem falschen Passwort anzumelden. Aus Sicherheitsgründen werden Sie für einige Zeit nicht in der Lage sein, sich unter diesem Benutzernamen anzumelden.",
    'login_up__unable_to_check_pass' => "Passwort kann nicht geprüft werden: %1",
    'login_up__warning_limits_licence_key' => "Eines der folgenden Objekte hat die Begrenzungen Ihres Lizenzschlüssels überschritten: auf Ihrem Server gehostete Benutzerkonten, Domains, E-Mail-Konten oder Webbenutzer.\nBitte wenden Sie sich an das Vertriebsteam von Plesk, um einen Schlüssel zu erwerben, mit dem Sie die gewünschte Anzahl von Benutzern und Domains hosten können. Falls Sie diese Nachricht irrtümlicherweise erhalten haben, wenden Sie sich bitte an den technischen Support von Plesk.\nDie Lizenzbegrenzung für Benutzerkonten/Domains/E-Mail-Konten/Webbenutzer/Sprachpakete beträgt: %2.\nDie Anzahl aktuell gehosteter Benutzerkonten/Domains/E-Mail-Konten/Webbenutzer/Sprachpakete beträgt: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Sie haben die in Ihrer aktuellen Produktlizenz festgelegten Grenzen für die Verwendung der Ressourcen überschritten. Bitte wenden Sie sich an das Vertriebsteam von Plesk, um einen neuen Lizenzschlüssel zu erwerben.",
    'login_up__grace_period' => 'Sie befinden sich zur Zeit in der Toleranzzeit Ihrer Produktlizenz. Um Ihre Produktlizenz zu erweitern, wählen Sie die Option Schlüssel abrufen auf der %1Lizenzinformationsseite%2.',
    'login_up__partner_license_message' => 'Sie arbeiten zur Zeit mit einer eingeschränkten Produktlizenz, die eine Registrierung erfordert, bevor Sie alle Features benutzen können. Um Ihre Produktlizenz zu erweitern, wählen Sie die Option Schlüssel abrufen auf der %1Lizenzinformationsseite%2.',
    'login_up__system_admin_disabled' => 'Aus Sicherheitsgründen ist es dem Superuser (Root- oder Administratorkonto) nicht gestattet, sich bei Plesk anzumelden.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk Administratorhandbuch",
    'plesk_guide_reseller' => "Plesk Reseller-Handbuch",
    'plesk_guide_client' => "Plesk Kundenhandbuch",
    'plesk_guide_domain_admin' => "Plesk Domainadministratorhandbuch",
    'plesk_guide_mailuser' => "Plesk E-Mail-Benutzerhandbuch",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Suchen', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Kunden',
    'ui__reseller_unknown__quick-search' => 'Reseller',
    'ui__client/domain_unknown__quick-search' => 'Domains',
    'nav__general' => 'Hauptmenü',
    '__home' => 'Start',
    '__resellers' => 'Reseller',
    '__clients' => 'Kunden',
    '__domains' => 'Domains',
    '__applications' => 'Anwendungen',
    '__settings' => 'Einstellungen',
    'nav__system' => 'System',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Eine Ebene höher',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Entfernen',
    'bt_make_default' => 'Als Standard verwenden',

    // common list object operation errors
    'class_cList__empty_selection' => 'Keine Objekte ausgewählt.',

    // common list object search keys
    'clist__search_show' => 'Suche anzeigen',
    'clist__search_hide' => 'Suche ausblenden',

    'bt_show_all' => "Suche zurücksetzen",

    // common object list info keys
    'clist__first' => 'Erste',
    'clist__last' => 'Letzte',
    'clist__prev' => '<<',
    'clist__next' => '>>',
    'clist__page' => 'Seiten',
    'clist__page_size' => 'Einträge pro Seite',
    'clist__info' => '%1 gesamt: %4',
    'clist__info_empty' => 'Keine %1',
    'clist__info_filter' => '%5 %1 gefunden (%4 gesamt)',
    'clist__info_paging' => '%2-%3 %1 von %4 insgesamt',
    'clist__info_paging_filter' => '%2-%3 %1 von %5 gefunden (%4 gesamt)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktiv',
    '__object_off' => 'Gesperrt',

    '__home_description' => 'Zurück zur Startseite.',
    'indicator_title' => '%1% verwendet, %2% frei', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Ungültiger URL angefordert.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Reseller-Konten",
    'ui__reseller_unknown__title' => "Reseller-Konten",
    'ui__reseller_unknown__description' => "Verwalten Sie die Reseller-Konten.",
    'ui__reseller/client_unknown__short-title' => 'Kundenkonten',
    'ui__reseller/client_unknown__title' => 'Kundenkonten',
    'ui__reseller/client_unknown__description' => 'Verwalten Sie die Kundenkonten.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Zusätzliche Administratorkonten", // PFW
    'ui__admin-alias_unknown__short-title' => "Zusätzliche Administratorkonten", // PFW
    'ui__admin-alias_unknown__description' => "Zusätzliche Administratorkonten anzeigen und verwalten.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Serverweite E-Mail-Einstellungen",
    'ui__server/mail__title' => "Serverweite E-Mail-Einstellungen",
    'ui__server/mail__description' => "Ihren Mailserver einrichten und serverweite E-Mail-Einstellungen konfigurieren.",
    'ui__server/dns__short-title' => 'DNS-Einstellungen',
    'ui__server/dns__title' => 'DNS-Einstellungen',
    'ui__server/dns__description' => 'Serverweite DNS-Einstellungen überprüfen und aktualisieren.',
    'ui__server/services__title' => 'Service-Verwaltung',
    'ui__server/services__description' => 'Hier können Sie Plesk Services starten, beenden oder neu starten.',
    'ui__server/crontab/task_unknown__short-title' => 'Geplante Aufgaben',
    'ui__server/crontab/task_unknown__title' => 'Geplante Aufgaben',
    'ui__server/crontab/task_unknown__description' => 'Serverweite geplante Aufgaben hinzufügen und entfernen.',
    'ui__server/ip-address_unknown__short-title' => 'IP-Adressen',
    'ui__server/ip-address_unknown__title' => 'IP-Adressen',
    'ui__server/ip-address_unknown__description' => 'Sehen Sie die IP-Adressen ein, fügen Sie IPs hinzu und entfernen Sie sie; weisen Sie Resellern IP-Adressen zu.',
    // dropdowns
    'ui__server/time__title' => 'Systemzeit',
    'ui__server/time__short-title' => 'Systemzeit',
    'ui__server/time__description' => 'Systemdatum und -zeit ändern, Synchronisierung mit einem NTP-Server einrichten.',
    'ui__server/maillists__title' => 'Mailinglistenserver einrichten', // PFU
    'ui__server/maillists__short-title' => 'Mailinglistenserver einrichten', // PFU
    'ui__server/maillists__description' => 'Richten Sie den Mailman-Mailinglistenserver ein.', // PFU
    'ui__mass-email__short-title' => "Massen-E-Mail-Nachrichten", // PFW
    'ui__mass-email__title' => "Massen-E-Mail-Nachrichten", // PFW
    'ui__mass-email__description' => "Senden Sie E-Mail-Nachrichten an mehrere Nutzer gleichzeitig.", // PFW
    'ui__mass-mail__title' => 'Massen-E-Mail-Nachrichten', // PFU
    'ui__mass-mail__short-title' => 'Massen-E-Mail-Nachrichten', // PFU
    'ui__mass-mail__description' => 'Senden Sie E-Mail-Nachrichten an mehrere Nutzer gleichzeitig.', // PFU
    'ui__server/spam-filter__title' => 'Spamfilter-Einstellungen',
    'ui__server/spam-filter__short-title' => 'Spamfilter-Einstellungen',
    'ui__server/spam-filter__description' => 'Serverweiten Spamfilter einrichten.',
    'ui__server/preferences__title' => "Servereinstellungen",
    'ui__server/preferences__short-title' => "Servereinstellungen",
    'ui__server/preferences__description' => "Serverweite Statistikberechnung einrichten, Hostname des Servers einrichten und andere Servereinstellungen ändern.",

    // help & support
    // icons
    'ui__support__short-title' => 'Unterstützung',
    'ui__support__title' => 'Unterstützung',
    'ui__support__description' => 'Reichen Sie eine Anfrage an den technischen Support ein oder sehen Sie die von Ihren Kunden erstellten Support-Tickets durch.',
    'ui__license__short-title' => 'Lizenzinformationen',
    'ui__license__title' => 'Plesk-Lizenzinformationen',
    'ui__license__description' => 'Lassen Sie sich Informationen über Ihre Plesk Lizenz anzeigen und bestellen Sie neue Lizenzschlüssel.',
    'ui__help__short-title' => 'Hilfe',
    'ui__help__title' => 'Online-Hilfe',
    'ui__help__description' => 'Online-Hilfe anzeigen.',
    'ui__news__short-title' => "Neuigkeiten",
    'ui__news__title' => "Neuigkeiten",
    'ui__news__description' => "Sehen Sie sich die Liste der Änderungen in dieser Version von Plesk an.",
    'ui__server/autoinstaller__short-title' => 'Updates',
    'ui__server/autoinstaller__title' => 'Updates',
    'ui__server/autoinstaller__description' => 'Aktualisieren Sie Plesk und dessen Komponenten.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domains',
    'ui__client/domain_unknown__title' => 'Domains',
    'ui__client/domain_unknown__description' => 'Domains verwalten.',
    'ui__server/skeleton__short-title' => 'Template für virtuelle Hosts',
    'ui__server/skeleton__title' => 'Template für virtuelle Hosts',
    'ui__server/skeleton__description' => 'Geben Sie Dateien und Ordner an, die in die Verzeichnisse neu erstellter Domains eingefügt werden sollen.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Abonnements einen neuen Besitzer zuweisen',
    'ui__client/domain/chowner_multi-select__short-title' => 'Neuen Abonnement-Besitzer zuweisen',
    'ui__client/domain/chowner_multi-select__description' => 'Ausgewählten Domains einen neuen Besitzer zuweisen',
    'ui__client/domain/disable_multi__title' => 'Domains sperren',
    'ui__client/domain/disable_multi__short-title' => 'Domains sperren',
    'ui__client/domain/disable_multi__description' => 'Ausgewählte Domains sperren',
    'ui__client/domain/enable_multi__title' => 'Domains aktivieren',
    'ui__client/domain/enable_multi__short-title' => 'Domains aktivieren',
    'ui__client/domain/enable_multi__description' => 'Ausgewählte Domains aktivieren',

    // icons
    'ui__admin/extras-domain__short-title' => 'Tools von MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Tools von MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__server/sitebuilder__short-title' => 'Presence Builder Einstellungen', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder Einstellungen', // PFU
    'ui__server/sitebuilder__description' => 'Richten Sie Presence Builder zum Bearbeiten von Websites ein, die auf diesem Server gehostet werden.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Domain registrieren',
    'ui__admin/register-domain__short-title' => 'Domain registrieren',
    'ui__admin/register-domain__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__admin/manage-domain__title' => 'Domain verwalten',
    'ui__admin/manage-domain__short-title' => 'Domain verwalten',
    'ui__admin/manage-domain__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',
    'ui__server/register__title' => 'Ihren Server registrieren',
    'ui__server/register__short-title' => 'Server registrieren',
    'ui__server/register__description' => 'Registrieren Sie Ihren Server, um an einem Affiliate-Programm teilzunehmen',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Aktionsprotokoll',
    'ui__actionlog__title' => 'Aktionsprotokoll',
    'ui__actionlog__description' => 'Aktionsprotokoll herunterladen und Einstellungen für Aktionsprotokoll verwalten.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Serverinformationen',
    'ui__server/statistics__title' => 'Serverinformationen',
    'ui__server/statistics__description' => 'Statistiken zu den Services, die über Plesk verwaltet werden.',
    'ui__admin/report__title' => 'Zusammenfassender Bericht',
    'ui__admin/report__short-title' => 'Zusammenfassender Bericht',
    'ui__admin/report__description' => 'Bericht über Traffic- und Ressourcenauslastung für Reseller, Kunden und Domains anzeigen.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Sitzungs-Leerlaufzeit',
    'ui__sessions/properties__title' => 'Sitzungs-Leerlaufzeit',
    'ui__sessions/properties__description' => 'Legen Sie eine Leerlaufzeit für Plesk Sitzungen fest.',
    'ui__cp-access__short-title' => 'Zugang zu Plesk',
    'ui__cp-access__title' => 'Zugang zu Plesk',
    'ui__cp-access__description' => 'Schränken Sie den Zugriff auf Plesk ein.',
    'ui__sessions__short-title' => 'Aktive Sitzungen',
    'ui__sessions__title' => 'Aktive Sitzungen',
    'ui__sessions__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-Zertifikate',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-Zertifikate',
    'ui__server/certificate_unknown__description' => 'Liste der SSL/TLS-Zertifikate',

    // account
    // icons
    'ui__admin-info__short-title' => 'Persönliche Daten',
    'ui__admin-info__title' => 'Persönliche Daten',
    'ui__admin-info__description' => 'Persönliche Daten Ihres Kontos ändern.',
    'ui__admin-password__short-title' => 'Passwort ändern',
    'ui__admin-password__title' => 'Passwort ändern',
    'ui__admin-password__description' => 'Passwort für Ihr Konto ändern.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Virtuelle Verzeichnisse', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Virtuelle Verzeichnisse', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Für eine Website mit physischen und virtuellen Dateien und Verzeichnissen arbeiten.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Ressourcenverbrauch',
    'ui__reseller/limits__title' => 'Ressourcenverbrauch',
    'ui__reseller/limits__description' => 'Ressourcenverbrauch von Reseller %1 anzeigen und verwalten.',
    'ui__reseller/limits_unknown__short-title' => 'Ressourcenverbrauch',
    'ui__reseller/limits_unknown__title' => 'Ressourcenverbrauch',
    'ui__reseller/limits_unknown__description' => 'Ressourcenverbrauch von Reseller anzeigen und verwalten.',
    'ui__reseller/limits_self__short-title' => 'Ressourcenverbrauch',
    'ui__reseller/limits_self__title' => 'Ressourcenverbrauch',
    'ui__reseller/limits_self__description' => "Ihren Ressourcenverbrauch anzeigen und verwalten.",
    'ui__reseller/limits_readonly-self__short-title' => 'Ressourcenverbrauch',
    'ui__reseller/limits_readonly-self__title' => 'Ressourcenverbrauch',
    'ui__reseller/limits_readonly-self__description' => "Sehen Sie sich Ihren Ressourcenverbrauch an.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Traffic-Verbrauch nach Kunden',
    'ui__reseller/client/traffic_unknown__title' => 'Traffic-Nutzung nach Kunden anzeigen',
    'ui__reseller/client/traffic_unknown__description' => 'Traffic-Nutzungsberichte für Kundenkonten anzeigen.',
    'ui__client/traffic_unknown__short-title' => "Traffic-Verbrauch nach Kunden", // temporary for presets
    'ui__client/traffic_unknown__title' => "Traffic-Nutzung nach Kunden anzeigen", // temporary for presets
    'ui__client/traffic_unknown__description' => "Traffic-Nutzungsberichte für Kundenkonten anzeigen.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Protokollverwaltung',
    'ui__client/domain/hosting/logs_unknown__title' => 'Protokollverwaltung',
    'ui__client/domain/hosting/logs_unknown__description' => 'Protokolle anzeigen und Protokollrotation konfigurieren.',
    // dropdowns
    'ui__reseller/report__title' => 'Zusammenfassender Bericht',
    'ui__reseller/report__short-title' => 'Zusammenfassender Bericht',
    'ui__reseller/report__description' => 'Bericht über Traffic- und Ressourcenverbrauch für diesen Reseller anzeigen.',
    'ui__reseller/report_unknown__title' => 'Zusammenfassender Bericht',
    'ui__reseller/report_unknown__short-title' => 'Zusammenfassender Bericht',
    'ui__reseller/report_unknown__description' => 'Bericht über Traffic- und Ressourcenverbrauch für Reseller anzeigen.',
    'ui__reseller/report_self__title' => 'Zusammenfassender Bericht',
    'ui__reseller/report_self__short-title' => 'Zusammenfassender Bericht',
    'ui__reseller/report_self__description' => 'Bericht über Ihre Traffic- und Ressourcenverbrauch anzeigen.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk Branding',
    'ui__client/logo_reseller__short-title' => 'Plesk Branding',
    'ui__client/logo_reseller__description' => 'Überarbeiten Sie das Erscheinungsbild von Plesk für den Reseller %1.',
    'ui__client/logo_unknown__title' => 'Plesk Branding', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk Branding', // temporary for presets
    'ui__client/logo_unknown__description' => 'Überarbeiten Sie das Erscheinungsbild von Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk Branding',
    'ui__client/logo_self-reseller__short-title' => 'Plesk Branding',
    'ui__client/logo_self-reseller__description' => 'Überarbeiten Sie das Erscheinungsbild Ihres Plesk.',
    'ui__reseller/permissions__title' => 'Berechtigungen',
    'ui__reseller/permissions__short-title' => 'Berechtigungen',
    'ui__reseller/permissions__description' => "Hier können Sie die Liste der Aktionen, die der Reseller %1 in Plesk ausführen kann, ansehen oder ändern.",
    'ui__reseller/permissions_unknown__short-title' => 'Berechtigungen',
    'ui__reseller/permissions_unknown__title' => 'Berechtigungen',
    'ui__reseller/permissions_unknown__description' => "Hier können Sie die Liste der Aktionen, die der Reseller in Plesk ausführen kann, ansehen oder ändern.",
    'ui__reseller/permissions_self__title' => 'Berechtigungen',
    'ui__reseller/permissions_self__short-title' => 'Berechtigungen',
    'ui__reseller/permissions_self__description' => 'Lassen Sie sich die Liste der Aktionen anzeigen, die Sie in Plesk ausführen können.',
    'ui__reseller/permissions_readonly-self__title' => 'Berechtigungen',
    'ui__reseller/permissions_readonly-self__short-title' => 'Berechtigungen',
    'ui__reseller/permissions_readonly-self__description' => 'Lassen Sie sich die Liste der Aktionen anzeigen, die Sie in Plesk ausführen können.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Template für virtuelle Hosts',
    'ui__client/skeleton__short-title' => 'Template für virtuelle Hosts',
    'ui__client/skeleton__description' => 'Geben Sie Dateien und Ordner an, die in die Verzeichnisse neu erstellter Domains eingefügt werden sollen.',
    'ui__client/skeleton_unknown__short-title' => 'Template für virtuelle Hosts',
    'ui__client/skeleton_unknown__title' => 'Template für virtuelle Hosts',
    'ui__client/skeleton_unknown__description' => 'Geben Sie Dateien und Ordner an, die in die Verzeichnisse neu erstellter Domains eingefügt werden sollen.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Domain-Aliase',
    'ui__client/domain/domain-alias_unknown__title' => 'Domain-Aliase',
    'ui__client/domain/domain-alias_unknown__description' => 'Liste der alternativen Namen für Ihre Domain anzeigen.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_unknown__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_unknown__description' => 'DNS-Zoneneinstellungen für eine Domain verwalten.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-unknown__description' => 'DNS-Zoneneinstellungen für eine Domain anzeigen.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Tools von MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Tools von MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Tools von MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Tools von MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Tools von MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Tools von MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Domain registrieren',
    'ui__reseller/register-domain__title' => 'Domain registrieren',
    'ui__reseller/register-domain__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__reseller/register-domain_unknown__short-title' => 'Domain registrieren',
    'ui__reseller/register-domain_unknown__title' => 'Domain registrieren',
    'ui__reseller/register-domain_unknown__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__reseller/register-domain_self__short-title' => 'Domain registrieren',
    'ui__reseller/register-domain_self__title' => 'Domain registrieren',
    'ui__reseller/register-domain_self__description' => 'Domainname über MyPlesk.com registrieren.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Domain verwalten',
    'ui__reseller/manage-domain__short-title' => 'Domain verwalten',
    'ui__reseller/manage-domain__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',
    'ui__reseller/manage-domain_unknown__title' => 'Domain verwalten',
    'ui__reseller/manage-domain_unknown__short-title' => 'Domain verwalten',
    'ui__reseller/manage-domain_unknown__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',
    'ui__reseller/manage-domain_self__title' => 'Domain verwalten',
    'ui__reseller/manage-domain_self__short-title' => 'Domain verwalten',
    'ui__reseller/manage-domain_self__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-Adressen',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-Adressen',
    'ui__client/ipaddress_unknown-reseller__description' => 'IP-Adressen verwalten.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-Zertifikate',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-Zertifikate',
    'ui__client/domain/certificate_unknown__description' => 'SSL/TLS-Zertifikate installieren und verwalten',
    'ui__reseller/sessions__short-title' => 'Aktive Sitzungen',
    'ui__reseller/sessions__title' => 'Aktive Sitzungen',
    'ui__reseller/sessions__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktive Sitzungen',
    'ui__reseller/sessions_unknown__title' => 'Aktive Sitzungen',
    'ui__reseller/sessions_unknown__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',
    'ui__reseller/sessions_self__short-title' => 'Aktive Sitzungen',
    'ui__reseller/sessions_self__title' => 'Aktive Sitzungen',
    'ui__reseller/sessions_self__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'E-Mail-Konten unter Benutzerkonto %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Template für virtuelle Hosts',
    'ui__client/skeleton_self__title' => 'Template für virtuelle Hosts',
    'ui__client/skeleton_self__description' => 'Geben Sie Dateien und Ordner an, die in die Verzeichnisse neu erstellter Domains eingefügt werden sollen.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Ressourcenverbrauch',
    'ui__client/limits__title' => 'Ressourcenverbrauch',
    'ui__client/limits__description' => "Ressourcenverbrauch des Kunden %1 anzeigen und verwalten.",
    'ui__client/limits_unknown__short-title' => 'Ressourcenverbrauch',
    'ui__client/limits_unknown__title' => 'Ressourcenverbrauch',
    'ui__client/limits_unknown__description' => 'Ressourcenverbrauch des Kunden anzeigen und verwalten.',
    'ui__client/limits_readonly__short-title' => 'Ressourcenverbrauch',
    'ui__client/limits_readonly__title' => 'Ressourcenverbrauch',
    'ui__client/limits_readonly__description' => 'Lassen Sie den Ressourcenverbrauch des Kunden %1 anzeigen.',
    'ui__client/limits_self__short-title' => 'Ressourcenverbrauch',
    'ui__client/limits_self__title' => 'Ressourcenverbrauch',
    'ui__client/limits_self__description' => "Ihren Ressourcenverbrauch anzeigen und verwalten.",
    'ui__client/limits_readonly-self__short-title' => 'Ressourcenverbrauch',
    'ui__client/limits_readonly-self__title' => 'Ressourcenverbrauch',
    'ui__client/limits_readonly-self__description' => "Sehen Sie sich Ihren Ressourcenverbrauch an.",
    'ui__client/domain/traffic_unknown__short-title' => "Traffic-Nutzung nach Domains %1",
    'ui__client/domain/traffic_unknown__title' => "Traffic-Nutzung nach Domains anzeigen",
    'ui__client/domain/traffic_unknown__description' => "Traffic-Nutzungsberichte für Domains anzeigen.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Zusammenfassender Bericht',
    'ui__client/report__short-title' => 'Zusammenfassender Bericht',
    'ui__client/report__description' => 'Bericht über Traffic- und Ressourcenverbrauch für diesen Kunden anzeigen.',
    'ui__client/report_unknown__short-title' => 'Zusammenfassender Bericht',
    'ui__client/report_unknown__title' => 'Zusammenfassender Bericht',
    'ui__client/report_unknown__description' => 'Bericht über Traffic- und Ressourcenverbrauch für Kunden anzeigen.',
    'ui__client/report_self__short-title' => 'Zusammenfassender Bericht',
    'ui__client/report_self__title' => 'Zusammenfassender Bericht',
    'ui__client/report_self__description' => 'Bericht über Traffic- und Ressourcenverbrauch anzeigen.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Oberflächeneinstellungen',
    'ui__client/preferences__title' => 'Oberflächeneinstellungen',
    'ui__client/preferences__description' => 'Konfigurieren Sie die Einstellungen zur Plesk Benutzeroberfläche für den Kunden %1.',
    'ui__client/preferences_unknown__short-title' => 'Oberflächeneinstellungen',
    'ui__client/preferences_unknown__title' => 'Oberflächeneinstellungen',
    'ui__client/preferences_unknown__description' => "Konfigurieren Sie die Einstellungen zur Benutzeroberfläche für das Plesk des Kunden.",
    'ui__client/preferences_self__short-title' => 'Oberflächeneinstellungen',
    'ui__client/preferences_self__title' => 'Oberflächeneinstellungen',
    'ui__client/preferences_self__description' => 'Konfigurieren Sie die Einstellungen zur Benutzeroberfläche Ihres Plesk.',
    'ui__client/logo__title' => 'Plesk Branding',
    'ui__client/logo__short-title' => 'Plesk Branding',
    'ui__client/logo__description' => "Überarbeiten Sie das Erscheinungsbild vom Plesk des Kunden %1.",
    'ui__client/logo_self__title' => 'Plesk Branding',
    'ui__client/logo_self__short-title' => 'Plesk Branding',
    'ui__client/logo_self__description' => 'Überarbeiten Sie das Erscheinungsbild von Plesk, indem Sie das Logobild und die Browser-Titelleiste ändern.',
    'ui__client/permissions__title' => 'Berechtigungen',
    'ui__client/permissions__short-title' => 'Berechtigungen',
    'ui__client/permissions__description' => "Hier können Sie die Liste der Aktionen, die der Kunde %1 in Plesk ausführen kann, ansehen oder ändern.",
    'ui__client/permissions_unknown__short-title' => 'Berechtigungen',
    'ui__client/permissions_unknown__title' => 'Berechtigungen',
    'ui__client/permissions_unknown__description' => "Hier können Sie die Liste der Aktionen, die der Kunde in Plesk ausführen kann, ansehen oder ändern.",
    'ui__client/permissions_self__title' => 'Berechtigungen',
    'ui__client/permissions_self__short-title' => 'Berechtigungen',
    'ui__client/permissions_self__description' => "Lassen Sie sich die Liste der Aktionen anzeigen, die Sie in Plesk ausführen können.",
    'ui__client/permissions_readonly-self__title' => 'Berechtigungen',
    'ui__client/permissions_readonly-self__short-title' => 'Berechtigungen',
    'ui__client/permissions_readonly-self__description' => "Lassen Sie sich die Liste der Aktionen anzeigen, die Sie in Plesk ausführen können.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Tools von MyPlesk.com',
    'ui__client/extras-domain__title' => 'Tools von MyPlesk.com',
    'ui__client/extras-domain__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Tools von MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Tools von MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Tools von MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Tools von MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Domain registrieren',
    'ui__client/register-domain__short-title' => 'Domain registrieren',
    'ui__client/register-domain__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__client/register-domain_unknown__title' => 'Domain registrieren',
    'ui__client/register-domain_unknown__short-title' => 'Domain registrieren',
    'ui__client/register-domain_unknown__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__client/register-domain_self__title' => 'Domain registrieren',
    'ui__client/register-domain_self__short-title' => 'Domain registrieren',
    'ui__client/register-domain_self__description' => 'Domainname über MyPlesk.com registrieren.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Domain verwalten',
    'ui__client/manage-domain__short-title' => 'Domain verwalten',
    'ui__client/manage-domain__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',
    'ui__client/manage-domain_unknown__title' => 'Domain verwalten',
    'ui__client/manage-domain_unknown__short-title' => 'Domain verwalten',
    'ui__client/manage-domain_unknown__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',
    'ui__client/manage-domain_self__title' => 'Domain verwalten',
    'ui__client/manage-domain_self__short-title' => 'Domain verwalten',
    'ui__client/manage-domain_self__description' => 'Registrierte Domainnamen über MyPlesk.com verwalten.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-Adressen',
    'ui__client/ipaddress_unknown__short-title' => "IP-Adressen",
    'ui__client/ipaddress_unknown__description' => "IP-Adressen verwalten.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Domain-Aliase',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Domain-Aliase',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Liste der alternativen Namen für Ihre Domain anzeigen.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Aktive Sitzungen',
    'ui__client/sessions__title' => 'Aktive Sitzungen',
    'ui__client/sessions__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',
    'ui__client/sessions_unknown__short-title' => 'Aktive Sitzungen',
    'ui__client/sessions_unknown__title' => 'Aktive Sitzungen',
    'ui__client/sessions_unknown__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',
    'ui__client/sessions_self__short-title' => 'Aktive Sitzungen',
    'ui__client/sessions_self__title' => 'Aktive Sitzungen',
    'ui__client/sessions_self__description' => 'Lassen Sie sich die aktiven Plesk Sitzungen anzeigen.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'Virtuelle Verzeichnisse', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Virtuelle Verzeichnisse', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Arbeiten Sie mit physischen und virtuellen Dateien und Verzeichnissen unter der Website %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Virtuelle Verzeichnisse', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Virtuelle Verzeichnisse', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Für Ihre Website mit physischen und virtuellen Dateien und Verzeichnissen für Ihre Website arbeiten.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 Traffic-Nutzung',
    'ui__client/domain/traffic__title' => 'Datenübertragungsstatistik für <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Datenübertragungsstatistiken für die Domain %1 anzeigen',
    'ui__client/domain/traffic_self__short-title' => 'Traffic-Nutzung',
    'ui__client/domain/traffic_self__title' => 'Traffic-Nutzung für Ihre Domain anzeigen',
    'ui__client/domain/traffic_self__description' => 'Traffic-Nutzungsbericht für Ihre Domain anzeigen.',
    'ui__client/domain/hosting/logs__short-title' => 'Protokollverwaltung',
    'ui__client/domain/hosting/logs__title' => 'Protokollverwaltung',
    'ui__client/domain/hosting/logs__description' => 'Protokolle anzeigen und Protokollrotation konfigurieren.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Protokollverwaltung',
    'ui__client/domain/hosting/logs_self__title' => 'Protokollverwaltung',
    'ui__client/domain/hosting/logs_self__description' => 'Protokolle anzeigen und Protokollrotation konfigurieren.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Domain umbenennen',
    'ui__client/domain/rename__short-title' => 'Domain umbenennen',
    'ui__client/domain/rename__description' => 'Domain %1 umbenennen.',
    'ui__client/domain/rename_unknown__short-title' => 'Domain umbenennen',
    'ui__client/domain/rename_unknown__title' => 'Domain umbenennen',
    'ui__client/domain/rename_unknown__description' => 'Domain umbenennen',
    'ui__client/domain/chowner_select__title' => 'Neuen Besitzer für Domain zuweisen',
    'ui__client/domain/chowner_select__short-title' => 'Dem Abonnement einen neuen Besitzer zuweisen',
    'ui__client/domain/chowner_select__description' => 'Dem Abonnement einen neuen Besitzer zuweisen',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Dem Abonnement einen neuen Besitzer zuweisen',
    'ui__client/domain/chowner_unknown-select__title' => 'Dem Abonnement einen neuen Besitzer zuweisen',
    'ui__client/domain/chowner_unknown-select__description' => 'Dem Abonnement einen neuen Besitzer zuweisen.',
    'ui__client/domain/toggle__title' => 'Domain sperren oder aktivieren', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Domain sperren oder aktivieren', // for HP customization
    'ui__client/domain/toggle__description' => 'Sperren oder aktivieren Sie die Domain %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Domain sperren oder aktivieren', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Domain sperren oder aktivieren', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Sperren oder aktivieren Sie eine Domain.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Domain aktivieren.',
    'ui__client/domain/toggle_enable__short-title' => 'Domain aktivieren.',
    'ui__client/domain/toggle_enable__description' => 'Domain %1 aktivieren.',
    'ui__client/domain/toggle_disable__title' => 'Domain sperren',
    'ui__client/domain/toggle_disable__short-title' => 'Domain sperren',
    'ui__client/domain/toggle_disable__description' => 'Sperren Sie die Domain %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns__description' => 'DNS-Zoneneinstellungen für Domain %1 verwalten.',
    'ui__client/domain/dns_self__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_self__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_self__description' => 'DNS-Zoneneinstellungen für Ihre Domain verwalten.',
    'ui__client/domain/dns_disabled__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_disabled__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_disabled__description' => 'DNS-Zoneneinstellungen für Domain %1 verwalten.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_self-disabled__description' => 'DNS-Zoneneinstellungen für Ihre Domain verwalten.',
    'ui__client/domain/dns_readonly__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly__description' => 'DNS-Zoneneinstellungen für Domain %1 anzeigen.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-self__description' => 'DNS-Zoneneinstellungen für Ihre Domain anzeigen.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'DNS-Zoneneinstellungen für Ihre Domain anzeigen.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_readonly-self-slave__description' => 'DNS-Zoneneinstellungen für Ihre Domain anzeigen.',
    'ui__client/domain/dns_slave__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_slave__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_slave__description' => 'DNS-Zoneneinstellungen für Domain %1 verwalten.',
    'ui__client/domain/dns_self-slave__title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS-Einstellungen',
    'ui__client/domain/dns_self-slave__description' => 'DNS-Zoneneinstellungen für Ihre Domain verwalten.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Tools von MyPlesk.com',
    'ui__client/domain/extras__title' => 'Tools von MyPlesk.com',
    'ui__client/domain/extras__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Tools von MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Tools von MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Tools von MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Tools von MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Erwerben Sie zusätzliche Tools und Services von MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Domain registrieren',
    'ui__client/domain/register__title' => 'Domain registrieren',
    'ui__client/domain/register__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__client/domain/register_unknown__short-title' => 'Domain registrieren',
    'ui__client/domain/register_unknown__title' => 'Domain registrieren',
    'ui__client/domain/register_unknown__description' => 'Domainname über MyPlesk.com registrieren.',
    'ui__client/domain/register_self__short-title' => 'Domain registrieren',
    'ui__client/domain/register_self__title' => 'Domain registrieren',
    'ui__client/domain/register_self__description' => 'Domainname über MyPlesk.com registrieren.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Tools",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Statistiken anzeigen',
    'ui__client/domain-summary-report_unknown__title' => 'Statistiken anzeigen',
    'ui__client/domain-summary-report_unknown__description' => 'Informationen über den Ressourcenverbrauch nach Domains anzeigen.',
    'ui__client/domain-summary-report__short-title' => "Statistiken anzeigen",
    'ui__client/domain-summary-report__title' => "Statistiken anzeigen",
    'ui__client/domain-summary-report__description' => "Informationen über den Ressourcenverbrauch von Domains anzeigen.",
    'ui__client/domain-summary-report_self__short-title' => "Statistiken anzeigen",
    'ui__client/domain-summary-report_self__title' => "Statistiken anzeigen",
    'ui__client/domain-summary-report_self__description' => "Informationen über den Ressourcenverbrauch Ihrer Domains anzeigen.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domains", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Sie müssen die Domains auswählen, die Sie entfernen möchten',
    'ui__client/domain/chowner__empty_selection' => 'Sie müssen die Domains auswählen, die Sie einem neuen Besitzer zuweisen möchten',

    // list objects filtering
    'domains_list__name__filter_title' => 'Name',
    'domains_list__state__filter_title' => 'Ressourcenverbrauch',
    'domains_list__filter_state_any' => 'Beliebig',
    'domains_list__filter_state_overuse' => 'Überbuchung',
    'domains_list__filter_state_normal' => 'Innerhalb der Grenzen',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Beliebig',
    'domains_list__filter_status_blocked' => 'Gesperrt',
    'domains_list__filter_status_active' => 'Aktiv',
    'domains_list__ownership__filter_title' => 'Besitz',
    'domains_list__filter_ownership_all' => 'Alle Domains',
    'domains_list__filter_ownership_personal' => 'Nur meine Domains',
    'domains_list__filter_owner_pname__filter_title' => 'Besitzername',
    'domains_list__subrows__filter_title' => 'Anzeigen',
    'domains_list__subrows_off' => 'Nur Domains',
    'domains_list__subrows_subdomain_domainaliases' => 'Mit Subdomains und Aliasen',
    'domains_list__subrows_subdomain' => 'Mit Subdomains',
    'domains_list__subrows_domainaliases' => 'Mit Aliasen',

    // objects list
    'domains_list__owner__title' => 'Inhaber',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Anwendungen suchen",
    'site_apps__promo_main_text' => "Der APS-Katalog (Application Packaging Standard) enthält die Liste von Anwendungen, die für eine Domain oder einen Webspace bereitgestellt werden können. Wenn Sie Anwendungen bereitstellen möchten, die sich momentan nicht im Katalog befinden, können Sie dies ganz einfach tun, indem Sie den APS-Paketanweisungen unter www.apsstandard.com folgen.",
    'site_apps__promo_download_now' => "Anwendungen herunterladen:",
    'site_apps__promo_close' => "Diesen Block schließen",
    'site_apps__promo_preset__mostused' => '%1 am häufigsten verwendete',
    'site_apps__promo_preset__lessused' => 'Nächste %1 am häufigsten verwendete',
    'site_apps__promo_preset__all' => "Alle",
    'site_apps__promo_disclaimer_note' => 'Bitte beachten Sie, dass aus dem APS-Katalog installierte Anwendungen von Drittanbietern zur Verfügung gestellt werden und Plesk dafür keinen Support anbietet.',
    'site_apps__promo_preset__page_title' => '%1 APS-Anwendungen',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Anwendungen werden hinzugefügt...',

    // Errors
    'site_apps__no_applications_for_update' => 'Im Application Vault sind keine Anwendungen installiert.',
    'site_apps__incorrect_download_preset_configuration' => 'Bei der Konfiguration der Download-Einstellungen für den APS-Katalog wurden Fehler festgestellt.',
    'site_apps__aps_catalog_url_is_invalid' => 'Angegebene URL ist ungültig.',
    'site_apps__no_updates_at_the_moment' => 'Im Moment sind keine Anwendungs-Updates verfügbar.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Es wurden falsche Informationen vom APS-Anwendungskatalog empfangen. Bitte versuchen Sie es später erneut.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Die APS-Katalog-Einstellungen wurden gespeichert, doch Plesk konnte keine Verbindung zu dem APS-Katalog herstellen, der in den APS-Katalog-Einstellungen (%1) angegeben ist. Stellen Sie sicher, dass die Adresse des APS-Katalogs korrekt und der APS-Katalog unter dieser Adresse aktiv ist.',
    'site_apps__cannot_retrieve_updates' => 'Anwendungs-Updates können im Moment nicht heruntergeladen werden, da keine Verbindung zum APS-Katalog (%1) hergestellt werden kann. Stellen Sie sicher, dass die Adresse des APS-Katalogs korrekt und der APS-Katalog unter dieser Adresse aktiv ist.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Es stehen keine Webanwendungen zur Installation zur Verfügung.',
    'site_apps__site_applications_already_installed_in_root' => 'In den Root-Verzeichnissen dieser virtuellen Hosts sind bereits andere Webanwendungen installiert',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET-Webanwendungen werden auf der Unix-/Linux-Plattform nicht unterstützt",
    'site_apps__server_wide_packages_not_supported' => 'Serverweite Webanwendungen werden nicht unterstützt',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "Es sind %1 weitere Webanwendungen zum Hinzufügen zum Application Vault vorgemerkt.",
    'site_apps__applications_all_in_vault' => "Ausgewählte Webanwendungen befinden sich bereits im Application Vault.",
    'site_apps__applications_already_in_download_queue' => "%1 ausgewählte Webanwendungen werden im Moment zum Application Vault hinzugefügt.",
    'site_apps__applications_already_in_valut' => "%1 ausgewählte Webanwendungen befinden sich bereits im Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Sonstiges (nicht kategorisiert)',

    // Errors
    'site_apps__no_applications_in_category' => 'In dieser Kategorie sind keine Anwendungen verfügbar. Bitte wählen Sie eine andere Kategorie aus.',
    'site_apps__no_category_selected__please_specify' => 'Wählen Sie im linken Menü eine Kategorie aus. Alle in der ausgewählten Kategorie verfügbaren Anwendungen werden in diesem Fenster aufgelistet.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Administratorkonto',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Allgemein',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Hostname ändern',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Sicherheit',
    'bt_setup_firewall' => 'Firewall einrichten',
    'bt_manage_firewall_rules' => 'Firewall-Regeln verwalten',
    'cu_firewall__rule' => 'Firewall-Regel erstellen',
    'cu_firewall__protocol' => 'Protokoll für die Regel einrichten (\'tcp\' oder \'udp\')',
    'cu_firewall__name' => "Regelname einrichten",
    'cu_firewall__disabled' => 'Falls \'wahr\', wird die Regel nach Erstellung deaktiviert.',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'DNS-Server auswählen', // PFW
    'bt_soa_records_template' => 'SOA-Eintrags-Template',
    'bt_restrict_creation_of_subzones' => 'Erstellung von Subzonen einschränken',

    'databases' => 'Datenbanken',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Anwendungen',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-Mail',
    'bt_select_mailserver' => 'Mailserver auswählen', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Antivirus auswählen', // PFW
    'bt_virus_protection_settings' => 'Virenschutzeinstellungen',
    'bt_select_spamfilter' => 'Spamfilter auswählen', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Webmail auswählen',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Protokolle & Statistiken',
    'bt_server_statistics_settings' => 'Einstellungen für Serverstatistiken',
    'bt_select_web_statistics' => 'Verfügbare Webstatistiksoftware', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk Benutzeroberfläche',

    'components_and_modules' => 'Komponenten & Module',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Watchdog einrichten', // PFU
    'bt_setup_vpn' => 'VPN einrichten', // PFU
    'bt_setup_samba' => 'Samba einrichten',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Einstellungen',
    'ui__client/domain/settings_self__short-title' => 'Einstellungen',
    'ui__client/domain/settings_self__description' => 'Domain-Einstellungen anzeigen und ändern.',

    'domain_administrator_account' => 'Domainadministratorkonto',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Kontoeinstellungen',

    'domain' => 'Domain',
    'bt_dns_soa_records' => 'DNS-SOA-Einträge',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Einstellungen zum Aufgabenplaner',

    'website' => 'Webseite',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Skripting für Webbenutzer',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'SSL/TLS-Zertifikat auswählen',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Webstatistiken',
    'bt_log_rotation_settings' => 'Einstellungen für die Protokollrotation',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Grenzen", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Überbeanspruchungs- und Overselling-Richtlinien",
    'limits__overuse_policy_legend' => "Überbuchung",
    'limits__oversell_policy_legend' => "Overselling",
    'limits__reseller_overuse_description' => "Die Richtlinien zur Überbeanspruchung geben Plesk vor, wie vorzugehen ist, wenn Ressourcen über ihre Grenze hinaus genutzt werden.",
    'limits__overuse_text' => "Überbeanspruchungsrichtlinien",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Speicherplatz und Traffic',
    'limit__disk_space' => 'Speicherplatz',
    'limit__max_traffic' => 'Verkehr',
    'limit_group__client' => 'Kunden',
    'limit__max_cl' => 'Kunden',
    'limit_group__domain' => 'Domains',
    'limit__max_dom' => 'Domains',
    'limit__max_dom_powerUser' => 'Abonnements',
    'limit__max_subdom' => 'Subdomains',
    'limit__max_dom_aliases' => 'Domain-Aliase',
    'limit__max_wu' => 'Webbenutzer',
    'limit__max_subftp_users' => 'Zusätzliche FTP-Konten', // PFW
    'limit_group__mail' => 'E-Mail',
    'limit__max_box' => 'E-Mail-Postfächer',
    'limit__mbox_quota' => 'Postfachgröße',
    'limit__total_mboxes_quota' => 'Postfachkontingent gesamt', // PFW
    'limit__max_maillists' => 'Mailinglisten',
    'limit_group__database' => 'Datenbanken',
    'limit__max_mssql_db' => 'Microsoft SQL Server-Datenbanken', // PFW
    'limit__mssql_dbase_space' => 'MS SQL-Datenbankkontingent gesamt', // PFW
    'limit__max_odbc' => 'ODBC-Verbindungen', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MariaDB/MySQL-Datenbankkontingent', // PFW
    'limit__pgsql_dbase_space' => 'PostgreSQL-Datenbankkontingent', // PFW
    'limit_group__application' => 'Anwendungen',
    'limit__max_iis_app_pools' => 'IIS-Anwendungspools', // PFW
    'limit_group__security' => 'Sicherheit',
    'limit_group__validity' => 'Ablaufdatum',
    'limit__expiration' => 'Ablaufdatum',
    'limit__validity' => 'Gültigkeitsdauer',
    'limit__max_site_builder' => 'Mit Presence Builder veröffentlichte Websites',
    'limit__max_site' => 'Domains',
    'limit__mssql_dbase_filesize' => 'Dateigröße der MS-SQL-Datenbank',
    'limit__mssql_dbase_log_filesize' => 'Protokolldateigröße der MS-SQL-Datenbank',
    'limit__mssql_dbase_filesize_hint' => 'Die maximale Größe einer Datei von einer Microsoft SQL Datenbank.',
    'limit__mssql_dbase_log_filesize_hint' => 'Die maximale Größe einer Protokolldatei von einer Microsoft SQL Datenbank.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Ungültige Domaingrenze. Der Minimalwert ist 1.',

    'property__has_wrong_value' => 'Die Eigenschaft %1 hat einen falschen Wert.',
    'property__name_outgoing_messages_domain_limit' => 'Legt fest, wie viele Nachrichten maximal pro Stunde von einer Domain ausgehen dürfen. Den Wert "Unbegrenzt" legen Sie durch Eingabe von "-1" fest. Wenn Sie "default" angeben, wird der Wert verwendet, der in den serverweiten Einstellungen angegeben ist.',
    'property__name_outgoing_messages_mbox_limit' => 'Legt fest, wie viele Nachrichten maximal pro Stunde von einem Postfach ausgehen dürfen. Den Wert "Unbegrenzt" stellen Sie durch Eingabe von "-1" ein. Wenn Sie "default" angeben, wird der Wert verwendet, der in den serverweiten Einstellungen angegeben ist.',
    'property__name_outgoing_messages_subscription_limit' => 'Legt fest, wie viele Nachrichten maximal pro Stunde von einem Abonnement ausgehen dürfen. Den Wert "Unbegrenzt" stellen Sie durch Eingabe von "-1" ein. Wenn Sie "default" angeben, wird der Wert verwendet, der in den serverweiten Einstellungen angegeben ist.',

    // for CLI report & email notifications
    '__resource_notify' => 'Benachrichtigen',
    '__general' => 'Allgemein',
    '__template_shared' => 'Gemeinsames Template',
    'limit__overuse' => 'Überbeanspruchungsrichtlinien',
    'limit__max_traffic_soft' => 'Benachrichtigen, wenn die Traffic-Nutzung folgenden Wert erreicht:',
    'limit__disk_space_soft' => 'Benachrichtigen, wenn die Speicherplatzbelegung folgenden Wert erreicht:',
    '__overuse' => 'Überbeanspruchungsrichtlinien',
    'performance__title' => 'Leistung',
    'performance__bandwidth' => 'Maximale Bandbreitenauslastung (KB/s)',
    'performance__max_connections' => 'Verbindungen begrenzt auf',

    'gch__hosting_php_isapi' => 'Starte PHP als ISAPI-Erweiterung',
    'gch__hosting_ssi_html' => 'SSI für *.htm- und *.html-Dateien verwenden',
    'gch__hosting_php_handler_type' => 'PHP ausführen als',
    'gch__hosting_php_handler_id' => 'PHP ausführen als',
    'gch__hosting_php_served_by_nginx' => 'PHP von nginx bedient',
    'gch__hosting_unpaid_website_status' => 'Status von Websites in gesperrten Abonnements',
    'gch__mn_no_autoresponder' => 'Für dieses E-Mail-Konto wurden keine Autoresponder-Nachrichten eingerichtet.',
    'gch__no_clients_selected' => "Es wurden keine Kundenkonten ausgewählt",
    'gch__no_domains_selected' => "Keine Domains ausgewählt",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/Monat",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Ressourcenname',
    '__resource_usage' => 'Verwendet',
    '__resource_limit' => 'Grenzwert',

    '__used' => 'Verwendet',
    '__limit' => 'Grenzwert',

    '__never_expires' => 'Läuft nie ab',
    '__resource_free' => '%1 von %2 frei',
    '__resource_unlimited' => '%1 von unbegrenzt verwendet',

    '__unlimited' => 'Unbegrenzt',
    '__increment' => "Vergrößern (+)",
    '__decrement' => "Verringern (-)",
    '__pt' => 'Einheiten',
    '__procent' => '%',
    '__overused' => 'Überbeansprucht',
    '__left' => 'verbleibend',
    '__available' => 'verfügbar',
    '__not_available' => 'Nicht enthalten',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Zustellungsplan',
    'ui__admin/report/layout/auto_unknown__title' => 'Berichtzustellungsplan',
    'ui__admin/report/layout/auto_unknown__description' => 'Berichtzustellungsplan für ein Berichtlayout auswählen.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Berichtzustellungsplan hinzufügen',
    'ui__admin/report/layout/auto/properties_new__title' => 'Berichtzustellungsplan hinzufügen',
    'ui__admin/report/layout/auto/properties_new__description' => 'Fügen Sie einen Berichtzustellungsplan für den Bericht %1 hinzu.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Berichtzustellungsplan',
    'ui__admin/report/layout/auto/properties__title' => 'Berichtzustellungsplan',
    'ui__admin/report/layout/auto/properties__description' => 'Eigenschaften des Berichtzustellungsplans anzeigen und ändern.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Berichtzustellungsplan entfernen',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Berichtzustellungsplan entfernen',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Ausgewählte Berichtzustellungspläne entfernen.',

    'ui__admin/report/layout_unknown__short-title' => 'Berichtlayouts',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Traffic-Nutzung für <b>%1</b> anzeigen',
    'ui__reseller/traffic__description' => 'Traffic-Nutzungsberichte für Reseller-Konto %1 anzeigen.',
    'ui__reseller/traffic_self__short-title' => 'Mein',
    'ui__reseller/traffic_self__title' => 'Traffic-Nutzung nach Kunden anzeigen',
    'ui__reseller/traffic_self__description' => 'Traffic-Nutzungsberichte für Ihr Kundenkonto anzeigen.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Reseller-Name', // reseller report
    'report__full_client_name' => 'Kundenname', // customer report
    'report__full_domain_name' => 'Domainname', // domain report
    'report__full_owner' => 'Inhaber', // customer & domain reports
    'report__full_creation_date' => 'Erstellungsdatum',
    'report__full_size' => 'Größe',
    'report__full_traffic' => 'Verkehr',
    'report__full_active_clients' => 'Aktive Kunden', // reseller report
    'report__full_clients' => 'Kunden', // reseller report
    'report__full_active_domains' => 'Aktive Domains', // reseller & customer reports
    'report__full_domains' => 'Domains', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'Mboxen',
    'report__full_disk_space' => 'Speicherplatz',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Antw',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Mailingliste',
    'report__full_web_users' => 'Webben',
    'report__full_mysql_databases' => 'MariaDB/MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL-DB',

    // common summary report
    'report__section_general' => 'Allgemein',
    'report__version' => 'Produktversion',
    'report__build' => 'Produkt-Build',
    'report__status' => 'Status',
    'report__company_name' => 'Firmenname',
    'report__personal_name' => 'Persönlicher Name',
    'report__login' => 'Benutzername',
    'report__phone' => 'Telefonnummer',
    'report__fax' => 'Fax',
    'report__email' => 'E-Mail-Adresse',
    'report__address' => 'Adresse',
    'report__city' => 'Stadt',
    'report__state' => 'US-Staat/Provinz/Region',
    'report__zip_code' => 'Postleitzahl',
    'report__country' => 'Land',
    'report__creation_date' => 'Erstellungsdatum',
    'report__expiration_date' => 'Ablaufdatum',
    'report__dumps_total_size' => 'Gesamtgröße Backupdateien',
    'report__section_resellers' => 'Reseller',
    'report__active_resellers' => 'Reseller mit aktiven Abonnements',
    'report__resellers' => 'Reseller',
    'report__section_full_resellers' => 'Reseller',
    'report__section_clients' => 'Kunden',
    'report__active_clients' => 'Kunden mit aktiven Abonnements',
    'report__clients' => 'Kunden',
    'report__section_full_clients' => 'Kunden',
    'report__section_personal_clients' => 'Eigene Kunden',
    'report__active_personal_clients' => 'Ihre eigenen Kunden mit aktiven Abonnements',
    'report__personal_clients' => 'Eigene Kunden',
    'report__section_full_personal_clients' => 'Eigene Kunden',
    'report__section_domains' => 'Domains',
    'report__disk_usage' => 'Speicherplatzbelegung',
    'report__traffic' => 'Verkehr',
    'report__active_domains' => 'Aktive Domains',
    'report__domains' => 'Domains',
    'report__subdomains' => 'Subdomains',
    'report__mboxes' => 'E-Mail-Postfächer',
    'report__mail_groups' => 'E-Mail-Weiterleitungen',
    'report__mail_autoresp' => 'Autoresponder',
    'report__mail_lists' => 'Mailinglisten',
    'report__web_users' => 'Webbenutzer',
    'report__mysql_databases' => 'MariaDB/MySQL-Datenbanken',
    'report__mssql_databases' => 'MSSQL-Datenbanken',
    'report__pgsql_databases' => 'PostgreSQL-Datenbanken',
    'report__section_full_domains' => 'Domains',
    'report__section_personal_domains' => 'Persönliche Domains',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Persönliche Domains',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Mit Presence Builder veröffentlichte Websites',
    'report__invalid_email' => 'Bitte geben Sie eine gültige E-Mail-Adresse an.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Webbenutzer',
    'report__section_mailnames' => 'E-Mail-Konten',
    'report__section_maillists' => 'Mailinglisten',
    'report__section_databases' => 'Datenbanken',
    'report__section_siteapps' => 'Webanwendungen',
    'report__section_aspnetapps' => 'ASP.NET-Anwendungen', // PFW
    'report__owner_pname' => "Name des Providers",
    'report__owner_login' => "Benutzername des Providers",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Zustellungsplan',
    'ui__reseller/report/layout/auto_unknown__title' => 'Berichtzustellungsplan',
    'ui__reseller/report/layout/auto_unknown__description' => 'Berichtzustellungsplan für ein Berichtlayout auswählen.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Berichtzustellungsplan hinzufügen',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Berichtzustellungsplan hinzufügen',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Fügen Sie einen Berichtzustellungsplan für den Bericht %1 hinzu.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Berichtzustellungsplan',
    'ui__reseller/report/layout/auto/properties__title' => 'Berichtzustellungsplan',
    'ui__reseller/report/layout/auto/properties__description' => 'Eigenschaften des Berichtzustellungsplans anzeigen und ändern.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Berichtzustellungsplan entfernen',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Berichtzustellungsplan entfernen',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Ausgewählte Berichtzustellungspläne entfernen.',

    'ui__reseller/report/layout_unknown__short-title' => 'Berichtlayouts',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Traffic-Nutzung für <b>%1</b> anzeigen',
    'ui__client/traffic__description' => 'Traffic-Nutzungsberichte für Kundenkonto %1 anzeigen.',
    'ui__client/traffic_self__short-title' => 'Traffic-Nutzung',
    'ui__client/traffic_self__title' => 'Traffic-Verbrauch nach Domains',
    'ui__client/traffic_self__description' => 'Traffic-Nutzungsberichte für Ihre Domains anzeigen.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Das angegebene Sprachpaket ist installiert, aber nicht im System aktiviert.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Sitzungen löschen',
    'ui__sessions/delete__title' => 'Sitzungen löschen',
    'ui__sessions/delete__description' => 'Ausgewählte Sitzungen löschen.',
    'ui__ftp-sessions__short-title' => 'FTP-Sitzungen',
    'ui__ftp-sessions__title' => 'FTP-Sitzungen',
    'ui__ftp-sessions__description' => 'FTP-Sitzungen anzeigen.',
    'ui__ftp-sessions/delete__short-title' => 'FTP-Sitzungen löschen',
    'ui__ftp-sessions/delete__title' => 'FTP-Sitzungen löschen',
    'ui__ftp-sessions/delete__description' => 'Ausgewählte FTP-Sitzungen löschen.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Sitzungen löschen',
    'ui__reseller/sessions/delete__title' => 'Sitzungen löschen',
    'ui__reseller/sessions/delete__description' => 'Ausgewählte Sitzungen löschen.',
    'ui__reseller/sessions/delete_self__short-title' => 'Sitzungen löschen',
    'ui__reseller/sessions/delete_self__title' => 'Sitzungen löschen',
    'ui__reseller/sessions/delete_self__description' => 'Ausgewählte Sitzungen löschen.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP-Sitzungen',
    'ui__reseller/ftp-sessions__title' => 'FTP-Sitzungen',
    'ui__reseller/ftp-sessions__description' => 'FTP-Sitzungen anzeigen.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP-Sitzungen',
    'ui__reseller/ftp-sessions_self__title' => 'FTP-Sitzungen',
    'ui__reseller/ftp-sessions_self__description' => 'FTP-Sitzungen anzeigen.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'FTP-Sitzungen löschen',
    'ui__reseller/ftp-sessions/delete__title' => 'FTP-Sitzungen löschen',
    'ui__reseller/ftp-sessions/delete__description' => 'Ausgewählte FTP-Sitzungen löschen.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'FTP-Sitzungen löschen',
    'ui__reseller/ftp-sessions/delete_self__title' => 'FTP-Sitzungen löschen',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Ausgewählte FTP-Sitzungen löschen.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Sitzungen löschen',
    'ui__client/sessions/delete__title' => 'Sitzungen löschen',
    'ui__client/sessions/delete__description' => 'Ausgewählte Sitzungen löschen.',
    'ui__client/sessions/delete_self__short-title' => 'Sitzungen löschen',
    'ui__client/sessions/delete_self__title' => 'Sitzungen löschen',
    'ui__client/sessions/delete_self__description' => 'Ausgewählte Sitzungen löschen.',

    // domain administrator

    'forgery_token_expired' => 'Sitzungstoken ist abgelaufen.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Die folgenden Reseller-Konten werden in Kundenkonten umgewandelt',
    'downgradeResellers__downgrade' => 'Reseller-Konten, die umgewandelt werden',
    // controls
    'downgradeResellers__submit_downgrade' => 'Kontoumwandlung ausführen.',
    'downgradeResellers__cancel_downgrade' => 'Kontoumwandlung abbrechen.',
    'downgradeResellers__confirm' => 'Umwandlung bestätigen',
    'downgradeResellers__confirm_message' => 'Bestätigen Sie die Kontoumwandlung, um fortzufahren',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Kundenkonten auswählen',
    'upgradeClients__upgrade_clients' => 'Die folgenden Kundenkonten werden in Reseller-Konten umgewandelt',
    'upgradeClients__upgrade' => 'Kundenkonten, die umgewandelt werden können',
    // controls
    'upgradeClients__submit_upgrade' => 'Kontoumwandlung ausführen.',
    'upgradeClients__cancel_upgrade' => 'Kontoumwandlung abbrechen.',
    'upgradeClients__confirm' => 'Umwandlung bestätigen',
    'upgradeClients__confirm_message' => 'Bestätigen Sie die Kontoumwandlung, um fortzufahren',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Das Konto \'%1\' kann nicht in ein Reseller-Konto umgewandelt werden: \'%1\' ist bereits ein Reseller.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Die folgenden Domainadministratorkonten werden in Kundenkonten umgewandelt',
    'upgradeDomainUser__upgrade' => 'Domainadministratorkonten, die umgewandelt werden',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Kontoumwandlung ausführen.',
    'upgradeDomainUser__cancel_upgrade' => 'Kontoumwandlung abbrechen.',
    'upgradeDomainUser__confirm' => 'Umwandlung bestätigen',
    'upgradeDomainUser__confirm_message' => 'Bestätigen Sie die Kontoumwandlung, um fortzufahren',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Domainadministratorkonten, die nicht umgewandelt werden können',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Die folgenden Domainadministratorkonten konnten nicht in Kundenkonten umgewandelt werden:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Mehrere Domainadministratorkonten konnten nicht in Kundenkonten umgewandelt werden. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Domainadministratorkonto existiert nicht',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Die Domain sollte direkt einem Serveradministrator oder einem Reseller gehören.",
    'upgradeDomainUser__all_logins_already_used' => 'Es konnte kein Konto für den Kunden erstellt werden.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Das Domainadministratorkonto wurde umgewandelt',
    'upgradeDomainUser__upgrade_notification_body' => 'Ihr Domainadministratorkonto wurde in ein Kundenkonto mit dem Benutzernamen \'%%login%%\' und dem Passwort \'%%password%%\' umgewandelt.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Kundenkonten auswählen',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Der ausgewählte Reseller besitzt nicht die Berechtigung \'%1\', aber einige der Kunden besitzen sie.',
    'clientOwnerChanger__application_not_allowed' => 'Die Anwendung \'%1\' steht dem ausgewählten Reseller nicht zur Verfügung, aber einigen der Kunden.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Ausgewählte Abonnements neu zuweisen',
    // errors
    'domain_chown__empty_selection' => 'Sie müssen einen neuen Besitzer für die ausgewählten Domains auswählen',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maximale Bandbreitenauslastung (%1)',
    'hosting_performance__max_connection_label' => 'Verbindungen begrenzt auf',
    'performance__invalid_value' => "Wert ist ungültig. Der Wert muss zwischen %1 und %2 sein.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'WebMail',
    'webmail__server_text' => 'Verfügbare Webmail-Clients',
    'webmail__none' => 'Ohne',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Server-IP-Pool',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Die Datenbank wird nicht wiederhergestellt: kein entsprechender Datenbankserver vorhanden',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Server-Backup.",
    '__default_backup_comment_reseller' => "Reseller-Konto-Backup, das von %1 erstellt wurde.",
    '__default_backup_comment_client' => "Kundenkonto-Backup, das von %1 erstellt wurde.",
    '__default_backup_comment_domain' => "Abonnement-Backup, das von %1 erstellt wurde.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "IP-Pool des Kunden %1",
    'backup__ip_mapping__resellers_ip' => "IP-Pool des Resellers %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtueller Host',
    'backup__restore__object_plesk_admin' => 'Plesk Administrator',
    'backup__restore__object_ftpuser' => 'FTP-Konto',
    'backup__restore__object_frontpageuser' => 'FrontPage-Konto',
    'backup__restore__object_webuser' => 'Webbenutzer',
    'backup__restore__object_domain' => 'Domain',
    'backup__restore__object_subdomain' => 'Subdomain',
    'backup__restore__object_domainalias' => 'Domain-Alias',
    'backup__restore__object_client' => 'Kunde',
    'backup__restore__object_reseller' => 'Reseller',
    'backup__restore__object_autoresponder' => 'Autoresponder',
    'backup__restore__object_mailalias' => 'E-Mail-Alias',
    'backup__restore__object_database' => 'Datenbank',
    'backup__restore__object_mailname' => 'E-Mail-Konto',
    'backup__restore__object_db_user' => 'Datenbankbenutzer',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-Zertifikat',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Folgende Reseller können nicht wiederhergestellt werden, da sie zu Kunden umgewandelt wurden: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Folgende Kunden können nicht wiederhergestellt werden, da sie zu Resellern umgewandelt wurden: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Folgende Kundenkonten können nicht wiederhergestellt werden, da sie zu einem anderen Eigentümer verschoben wurden: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Auf dem Zielserver ist nicht genügend Speicherplatz vorhanden, um alle ausgewählten Abonnements zu transferieren. Verfügbar: %1 MB. Benötigt: %2 MB. Beachten Sie, dass der Speicherplatz berechnet wird aus der Summe der Web-, E-Mail- und Datenbankinhalte der Domains. Der erforderliche Speicherplatz wird einmal täglich berechnet und im Cache gespeichert. Daher kann sich die tatsächliche Größe der Domains von der berechneten Größe unterscheiden. Wenn Sie dafür sorgen, dass die ausgewählten Domains nicht mehr Speicherplatz beanspruchen als verfügbar, dann können Sie mit dem Transfer fortfahren.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Bitte geben Sie Speicherplatz auf dem Zielserver frei.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Nicht genügend Speicherplatz auf dem Quellserver vorhanden, um temporäre Dateien für die Übertragung zu speichern. Verfügbar: %1 MB. Benötigt: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Bitte geben Sie Speicherplatz auf dem Quellserver frei.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Server-Informationen',

    'backup__restore__capability_not_installed_component_text' => 'Die Komponente %1 ist auf dem Zielserver nicht installiert. %1 wird für alle wiederhergestellten Objekte nicht verfügbar sein.',
    'backup__restore__capability_not_installed_component_resolution' => 'Bitte installieren Sie %1. Beachten Sie, dass dies einige Minuten dauern kann.',
    'backup__restore__capability_existing_sys_user_text' => 'Es existiert bereits ein Systemnutzer mit dem Namen %1 auf dem Zielserver.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Bitte benennen Sie den vorhandenen Systemnutzer auf dem Zielserver um.',
    'backup__restore__capability_license_usage_text' => 'Folgende Ressourcengrenzen (definiert durch den Lizenzschlüssel) werden nach der Datenübertragung auf dem Zielserver überschritten:',
    'backup__restore__capability_license_usage_resolution' => 'Bitte installieren Sie auf dem Zielserver einen weiteren Lizenzschlüssel, der die erforderliche Menge an Ressourcen bereitstellt.',
    'backup__restore__capability_max_allowed_packet_text' => "Der Parameter 'max_allowed_packet' auf dem Quelldatenbankserver beträgt %1. Dies ist jedoch größer als auf dem Zielserver, auf dem er %2 beträgt. Möglicherweise werden einige Datenbankobjekte für die unten aufgeführten Domains nicht wiederhergestellt.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Bitte erhöhen Sie den Wert 'max_allowed_packet' auf dem Zieldatenbankserver.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Die PostgreSQL-Datenbanken können nicht übertragen werden, da die PostgreSQL-Version auf dem Zielserver eine ältere Version als auf dem Quellserver ist. Die aktuell installierte Version ist %1, die erforderliche Version ist %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Bitte installieren Sie die erforderliche Version von PostgreSQL auf dem Zielserver.',
    'backup__restore__capability_db_server_connection_problems' => 'Verbindungsaufbau zum PostgreSQL-Zieldatenbankserver nicht möglich. Datenbanken werden nicht übertragen, bis Sie die Verbindung wiederherstellen.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Bitte überprüfen Sie die Verbindungseinstellungen auf dem Zieldatenbankserver.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Die Komponente %1 ist auf dem Zielserver ausgeschaltet.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Bitte schalten Sie die Komponente %1 auf dem Zielserver ein.',
    'backup__restore__capability_not_configured_component_text' => 'Die Komponente %1 ist auf dem Zielserver nicht konfiguriert.',
    'backup__restore__capability_not_configured_component_resolution' => 'Bitte konfigurieren Sie %1 auf der Seite Tools & Einstellungen.',

    'backup__restore__capability_webmail_is_not_available' => 'Der Webmail-Service %1 ist auf dem Zielserver nicht verfügbar. Plesk wird stattdessen folgenden Webmail-Service verwenden: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Wenn Sie denselben Webmail-Dienst wie auf dem Quellserver verwenden wollen, müssen Sie ihn auf diesem Server installieren.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Wenn Sie denselben Webmail-Service wie auf dem Quellserver verwenden wollen, müssen Sie ihn auf dem Zielserver installieren.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Der Webmail-Service '%1' ist auf dem Zielserver nicht verfügbar. Plesk wird stattdessen in den Abonnements: %3 den folgenden Webmail-Service verwenden: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Bitte installieren Sie den erforderlichen Webmail-Service auf dem Zielserver.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Webmail-Einstellungen',

    'backup__restore__capability_shell_is_not_available' => 'Die Shell %1 ist auf dem Zielserver nicht verfügbar. Es wird stattdessen eine der verfügbaren Shells verwendet.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Wenn Sie dieselbe Shell auf dem Quellserver verwenden wollen, müssen Sie sie auf dem Zielserver einschalten (in /etc/shells) oder installieren.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Der Ziel-DNS-Server unterstützt keine Netzwerke im Transferbeschränkungs-Template. Die Einträge mit Netzwerk-IP-Adressen in den DNS-Transferbeschränkungen werden nicht wiederhergestellt.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Der Ziel-DNS-Server unterstützt keine Netzwerke im Transferbeschränkungs-Template, jedoch haben einige Abonnements Netzwerke in den DNS-Transferbeschränkungen. Die Einträge mit Netzwerk-IP-Adressen in den DNS-Transferbeschränkungen werden nicht wiederhergestellt.',

    'backup__restore__capability_wrong_php_handler_text' => 'Der PHP Handler %1 ist auf dem Zielserver nicht verfügbar. Plesk wird stattdessen folgenden PHP Handler verwenden: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Wenn Sie denselben PHP-Handler wie auf dem Quellserver verwenden wollen, müssen Sie ihn auf dem Zielserver einschalten oder installieren.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Der PHP-Handler %1 ist nicht verfügbar. Plesk wird stattdessen %2 für folgende Service-Paket verwenden: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Der PHP-Handler %1 ist nicht verfügbar. Plesk wird stattdessen %2 für folgende Websites verwenden: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Der PHP-Handler %1 ist nicht verfügbar. Gilt für folgende Websites: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 ist auf dem Zielserver nicht verfügbar. Es wird stattdessen die Standardversion verwendet.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Wenn Sie dieselbe Komponente %1 wie auf dem Quellserver verwenden wollen, müssen Sie sie auf dem Zielserver einschalten oder installieren.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Die Richtlinie zur Antivirennutzung auf dem Zielserver erlaubt keine persönlichen Antiviren-Einstellungen (d.h. pro E-Mail-Adresse) für ausgehende E-Mails. Diese Einstellungen werden nicht übertragen.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Die Richtlinie zur Antivirennutzung auf dem Zielserver erlaubt keine persönlichen Antiviren-Einstellungen (d.h. pro E-Mail-Adresse) für eingehende E-Mails. Diese Einstellungen werden nicht übertragen.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Die Richtlinie zur Antivirennutzung auf dem Zielserver erlaubt keine persönlichen Antiviren-Einstellungen (d.h. pro E-Mail-Adresse). Diese Einstellungen werden nicht übertragen.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Wenn Sie persönliche (pro E-Mail-Adresse geltende) Antiviren-Einstellungen übertragen wollen, schalten Sie bitte die entsprechenden Optionen unter Tools & Einstellungen > Virenschutzeinstellungen ein.",
    'backup__restore__capability_antivirus_not_active_text' => 'Keine Antivirensoftware eingeschaltet. Alle Antiviren-Einstellungen vom Quellserver werden erst funktionieren, wenn Sie die Antivirensoftware auf dem Zielserver auswählen.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Bitte wählen Sie die Antivirensoftware unter Tools & Einstellungen > Virenschutzeinstellungen > Abschnitt Antiviren-Einstellungen aus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Die Antivirensoftware %2 ist auf dem Zielserver nicht verfügbar. Es wird stattdessen %1 verwendet.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Wenn Sie dieselbe Antivirensoftware wie auf dem Quellserver verwenden wollen, installieren Sie sie bitte und wählen Sie sie unter Tools & Einstellungen > Virenschutzeinstellungen > Abschnitt Antiviren-Einstellungen aus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI ist auf dem Zielserver nicht verfügbar. Für Websites mit derselben IP-Adresse können keine individuellen SSL/TLS-Zertifikate verwendet werden.',
    'backup__restore__capability_not_available_sni_resolution' => "Überprüfen Sie, ob das Betriebssystem auf dem Zielserver SNI unterstützt, und vergewissern Sie sich, dass die Unterstützung von SNI in Plesk aktiviert ist (Kontrollkästchen 'SNI-Unterstützung einschalten, wodurch die Verwendung individueller SSL/TLS-Zertifikate auf Websites mit denselben IP-Adressen ermöglicht wird' unter Tools & Einstellungen > Servereinstellungen).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Servereinstellungen',

    'backup__restore__capability_vhost_already_exists_text' => 'Die Website %1 kann nicht übertragen werden: Es existiert bereits eine Website mit demselben Namen auf dem Zielserver.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Bitte benennen Sie die Website mit demselben Namen um oder entfernen Sie sie von dem Server.',
    'backup__restore__capability_removed_vhosts' => 'Folgende Abonnements werden nicht wiederhergestellt, da sie Domainnamen enthalten, die bereits auf dem Zielserver vorhanden sind: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Auf dem Quellserver gibt es %3 unterschiedliche PHP Handler des Typs %1 und der Version %2. Anstatt dieser wird ein Handler passenden Typs und passender Version auf dem Zielserver verwendet. Beachten Sie, dass die PHP-Einstellungen auf dem Quell- und Zielserver unterschiedlich sein könnten.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Der Plesk Installer unterstützt Microsoft Frontpage nicht.',
    'backup__restore__capability_not_installed_python_resolution' => 'Der Plesk Installer unterstützt Python nicht. Bitte installieren Sie Python manuell.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Mailserver-Einstellungen',

    'backup__restore__capability_ftps_disabled' => 'Die Verwendung des sicheren FTPS ist auf dem Quellserver zugelassen, auf dem Zielserver jedoch nicht. Benutzer-Apps, die FTP nutzen, funktionieren möglicherweise nicht korrekt.',
    'backup__restore__capability_ftps_required' => 'Die Verwendung des nicht sicheren FTP ist auf dem Quellserver zugelassen, auf dem Zielserver jedoch nicht. Benutzer-Apps, die FTP nutzen, funktionieren möglicherweise nicht korrekt.',
    'backup__restore__capability_ftps_policy_resolution' => 'Ändern Sie die Richtlinien für Sicheres FTP in Tools & Einstellungen > Sicherheitsrichtlinien.',

    'backup__restore__capability_too_much_download_time_text' => '%1 Megabyte Daten werden in %2 Stunden vom Quellserver auf den Zielserver verschoben.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Wenn Sie eine schnellere Übertragungsgeschwindigkeit erreichen möchten, überprüfen Sie bitte die Netzwerkverbindung zwischen dem Quell- und Zielserver und beheben Sie ggf. die Probleme.',
    'backup__restore__too_low_download_speed' => "weniger als 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Wenn Sie eine schnellere Übertragungsgeschwindigkeit erreichen möchten, überprüfen Sie bitte die Netzwerkverbindung zwischen dem Quell- und Zielserver und beheben Sie ggf. die Probleme.',
    'backup__restore__capability_zero_download_speed_text' => 'Die mindeste vertretbare Downloadrate ist %1 MBps. Die Downloadrate zwischen dem Quell- und Zielserver beträgt 0 MBps. Dies kann von Netzwerkverbindungsproblemen hervorgerufen werden. Die Übertragung ist zum aktuellen Zeitpunkt nicht möglich.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Überprüfen Sie bitte die Netzwerkverbindung zwischen dem Quell- und Zielserver und beheben Sie die Probleme.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Die mindeste vertretbare Downloadrate ist %2 MBps. Die Downloadrate zwischen dem Quell- und Zielserver beträgt %1 MBps. Dies kann die Dauer des Transfers erhöhen. In Ihrer aktuellen Umgebung wird die Migration von %3 MB %4 Stunden dauern.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Die mindeste vertretbare Downloadrate ist %2 MBps. Die Downloadrate zwischen dem Quell- und Zielserver beträgt %1 MBps. Dies kann die Dauer des Transfers erhöhen.',

    'backup__restore__capability_remote_database_migration' => "Folgende Domains verwenden Remote-Datenbanken: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Entfernen Sie diese Domains nach dem Transfer nicht vom Quellserver, wenn die Plesk Version auf dem Quellserver eine Version vor 11.5 ist! Sperren Sie sie stattdessen. Wenn Sie die Domains entfernen, werden die Datenbanken vom Remoteserver entfernt. Hinweis: Die Dump-Dateien von Remote-Datenbanken werden auf dem Quellserver im Verzeichnis %1 gespeichert.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Backupdateien von MySQL-Datenbankservern in Versionen vor 5.1 (%1) können wahrscheinlich unter MySQL 5.1.x nicht wiederhergestellt werden, da MySQL 5.1.x Zeichen im Unicode-Format anders handhabt.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Bitte lesen Sie dazu den Wissensdatenbank-Artikel Nr. 136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP ist nicht auf dem Zielserver installiert.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Bitte installieren Sie Courier-IMAP über den Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot ist nicht auf dem Zielserver installiert.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Bitte installieren Sie Dovecot über den Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'In den Konfigurationseinstellungen der nachfolgenden Objekte ist die Aufbewahrungszeit für Traffic-Statistiken kleiner als der serverweit gültige Wert auf dem Zielserver.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Bitte ändern Sie den serverweit gültigen Wert für die Aufbewahrungszeit für Statistiken auf dem Zielserver. Stellen Sie diese Zeit auf einen Wert ein, der gleich oder kleiner ist als der kleinste Wert in den Konfigurationen der Domains.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Die Aufbewahrungszeit für Traffic-Statistiken ist bei einigen Domains kleiner als der serverweit gültige Wert (%1). Der Wert wird für diese Domains in %1 geändert.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Die Aufbewahrungszeit für Traffic-Statistiken ist bei einigen Service-Paketen kleiner als der serverweit gültige Wert (%1). Der Wert wird für diese Service-Pakete in %1 geändert.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Durch Zuordnung einer exklusiven IP-Adresse zu einer gemeinsamen wird Anonymous-FTP und HTTPS deaktiviert (sofern SNI-Unterstützung nicht eingeschaltet ist).',

    'backup__restore__no_postgresql_commands_text' => 'Das Abonnement verwendet eine Remote-PostgreSQL-Datenbank und die temporäre Backupdatei von dieser Datenbank kann nicht generiert werden, da die Befehle pg_dump und psql auf dem Quellserver fehlen.',
    'backup__restore__no_postgresql_commands_resolution' => 'Bitte installieren Sie ein beliebiges PostgreSQL-Clientpaket, das diese Befehle unterstützt.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Folgende Apache-Module sind auf dem Zielserver deaktiviert: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Bitte aktivieren Sie diese Module, um mögliche Probleme zu verhindern.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Folgende Apache-Module sind auf dem Zielserver nicht installiert: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Bitte installieren und aktivieren Sie diese Module, um mögliche Probleme zu verhindern.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Die Begrenzung von ausgehenden Nachrichten wird von Ihrem Lizenzschlüssel nicht unterstützt. Die zugehörigen Konfigurationseinstellungen werden nicht übertragen.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Bitte installieren Sie auf dem Zielserver einen weiteren Lizenzschlüssel, der die erforderlichen Features bereitstellt.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Die Begrenzung der ausgehenden Nachrichten ist auf dem Zielserver ausgeschaltet. Die zugehörigen Konfigurationseinstellungen werden nicht übertragen.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Bitte schalten Sie die Begrenzung der ausgehenden Nachrichten auf dem Zielserver ein.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Serverweite E-Mail-Einstellungen',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Die Begrenzung der von einem Postfach abgehenden Nachrichten wird vom Mailserver, der auf dem Zielserver genutzt wird, nicht unterstützt. Der Wert dieser Grenze wird nicht transferiert.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Bitte ändern Sie den Mailserver, sodass er mit jenem auf dem Quellserver übereinstimmt.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Serverweite E-Mail-Einstellungen',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Die Begrenzung der von einer Domain abgehenden Nachrichten wird vom Mailserver, der auf dem Zielserver genutzt wird, nicht unterstützt. Der Wert dieser Grenze wird nicht transferiert.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Bitte ändern Sie den Mailserver, sodass er mit jenem auf dem Quellserver übereinstimmt.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Serverweite E-Mail-Einstellungen',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Die Begrenzung der von einem Abonnement abgehenden Nachrichten wird vom Mailserver, der auf dem Zielserver genutzt wird, nicht unterstützt. Der Wert dieser Grenze wird nicht transferiert.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Bitte ändern Sie den Mailserver, sodass er mit jenem auf dem Quellserver übereinstimmt.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Serverweite E-Mail-Einstellungen',

    'bu_conflict_resolver_absent_phosting' => 'Die angegebenen Dateien können nicht wiederhergestellt werden, da das physische Hosting für die Wiederherstellung der Dateien nicht vorhanden ist. Erstellen Sie zuerst eine Domain mit physischem Hosting und starten Sie die Wiederherstellung des Backups anschließend erneut.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Die Daten des Resellers werden nicht wiederhergestellt, da die Reseller-Verwaltung nicht unterstützt wird.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Die Komponente ModSecurity ist nicht auf dem Zielserver installiert.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Bitte installieren Sie ModSecurity, damit die Web Application Firewall für die transferierten Websites weiterhin funktioniert. Beachten Sie, dass die Installation einige Minuten dauern kann.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installieren Sie ModSecurity, wenn Sie die Einstellungen der Web Application Firewall transferieren wollen. Beachten Sie, dass die Installation einige Minuten dauern kann.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Die Komponente ModSecurity ist nicht auf dem Zielserver konfiguriert.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konfigurieren Sie ModSecurity, wenn Sie erreichen wollen, dass die Web Application Firewall für die transferierten Websites weiterhin funktioniert.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Web Application Firewall (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity ist auf dem Zielserver ausgeschaltet.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktivieren Sie ModSecurity, wenn Sie erreichen wollen, dass die Web Application Firewall für die transferierten Websites weiterhin funktioniert.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Web Application Firewall (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Die Komponente ModSecurity ist nicht installiert. Für folgende Objekte werden die Einstellungen zur Web Application Firewall nicht wiederhergestellt: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Die Websites können nicht wiederhergestellt werden, da sie zum Abonnement %1 gehören, das in Plesk nicht gefunden werden kann.",
    'backup__restore__capability_not_installed_dns_text' => 'Die Komponente %1 ist auf dem Zielserver nicht installiert. Der DNS-Service wird nicht verfügbar sein und die DNS-Einstellungen werden verloren gehen. Die Websites aller Kunden werden nicht erreichbar sein.',
    'bu_conflict_resolver_dns_not_installed' => 'Der DNS-Service ist nicht installiert. Die DNS-Einstellungen für die folgenden Objekte werden nicht wiederhergestellt: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Folgende Abonnements können nicht wiederhergestellt werden, da sie zu anderen Eigentümern verschoben wurden: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Folgende Abonnements können nicht wiederhergestellt werden, da sie zu anderen Providern verschoben wurden: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Das Web Presence Builder Wiederherstellungsdienstprogramm kann nicht gefunden werden, um Web Presence Builder Daten wiederherzustellen. Web Presence Builder ist möglicherweise nicht installiert.',
    'backup__restore__capability_renamed_db' => 'Der Datenbankname "%1" wird bereits von einem anderen Abonnement verwendet. Der Name der wiederhergestellten Datenbank wird in "%2" umgeändert.',
    'backup__restore__capability_renamed_db_user' => 'Der Datenbankbenutzername "%1" wird bereits von einem anderen Abonnement verwendet. Der Name des wiederhergestellten Datenbankbenutzers wird in "%2" umgeändert.',
    'backup__restore__capability_not_installed_perl_resolution' => 'Der Plesk Installer unterstützt Perl nicht. Bitte installieren Sie ActiveState Perl manuell.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (ID=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% (Apache) (ID=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% (nginx) (ID=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Ressourcenverbrauchskonflikte',
    'backup__restore__hint_resource_usage_conflicts' => 'Ressourcenverbrauchskonflikte treten auf, wenn die Ressourcenverbrauchsgrenzen des wiederhergestellten Objekts nach der Wiederherstellung überschritten werden.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Überbeanspruchung zulassen',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Objekt wiederherstellen und zulassen, dass es mehr Ressourcen nutzt als ursprünglich bereitgestellt wurden.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Nicht wiederherstellen',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Lassen Sie Objekte mit Ressourcenverbrauchskonflikten nicht wiederherstellen.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konfigurationskonflikte',
    'backup__restore__hint_configuration_conflicts' => 'Konfigurationskonflikte treten auf, wenn die Einstellungen oder Webanwendungen des wiederhergestellten Objekts nicht verfügbar oder von den aktuellen Server- oder Objektbesitzerrichtlinien nicht zugelassen sind. Es treten beispielsweise Konfigurationskonflikte auf, wenn ein wiederhergestelltes E-Mail-Konto über individuelle Spamfiltereinstellungen verfügt, während solche Einstellungen von den aktuellen serverweiten Richtlinien nicht zugelassen sind.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatisch',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Objekt wiederherstellen und alle Optionen zu widersprüchlichen Konfigurationen, zu deren Verwaltung Sie berechtigt sind, automatisch aktivieren.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Nicht wiederherstellen',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Objekte mit Konfigurationskonflikten nicht wiederherstellen.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Dedizierte IIS-Anwendungspools sind in den IIS-Anwendungspool-Einstellungen nicht erlaubt.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Bitte ändern Sie Ihre IIS-Anwendungspool-Einstellungen unter Tools & Einstellungen > IIS-Anwendungspool > Globale Einstellungen.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Freigegebene IIS-Anwendungspools sind in den IIS-Anwendungspool-Einstellungen nicht erlaubt.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Bitte ändern Sie Ihre IIS-Anwendungspool-Einstellungen unter Tools & Einstellungen > IIS-Anwendungspool > Globale Einstellungen.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Kurznamen für POP3/IMAP-E-Mail-Konten sind auf dem Zielserver nicht zulässig.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Kurznamen für E-Mail-Konten werden nach Wiederherstellung der Daten nicht verfügbar sein.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Die Protokolldatei kann nicht geöffnet werden.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Das Abonnement %1 kann nicht wiederhergestellt werden: Es wurde aus Ihrem Konto entfernt und Sie haben keine Berechtigung, Abonnements zu erstellen. Wenden Sie sich bitte an Ihren Service-Provider, wenn Sie es wiederherstellen wollen.',

    'backup__error11' => 'Nicht genügend Speicherplatz für das Backup.',
    'backup__error3011' => 'Die Verbindung wurde abgelehnt: Auf der angegebenen Adresse und dem Port warten keine Programme auf Kommunikation.',
    'backup__error3012' => 'Zeitüberschreitung beim Verbindungsaufbau.',
    'backup__error3013' => 'Das Netzwerk ist nicht erreichbar.',
    'backup__error3014' => 'Keine Route zum Host.',
    'backup__error3015' => 'Verbindung fehlgeschlagen.',
    'backup__error3016' => 'Der Hostname kann nicht aufgelöst werden.',
    'backup__error3017' => 'Der Benutzername oder das Passwort ist ungültig.',
    'backup__error3018' => 'Die SSH-Verbindung ist fehlgeschlagen.',

    'backup__error3110' => 'Es kann keine Verbindung zum Remote-Migrationsassistenten hergestellt werden: Die Verbindung zum Host ist nicht verfügbar.',
    'backup__error3111' => 'Der Migrationsassistent ist durch eine fehlgeschlagene Aufgabe gesperrt oder wird von einem anderen Migrationsprozess verwendet. Bitte starten Sie den Migrationsassistent auf dem Quellserver neu.',
    'backup__error3112' => 'Die Verbindung zum Host ist nicht verfügbar oder der Migrationsassistent wird auf dem Quellhost gerade nicht ausgeführt.',
    'backup__error3113' => 'Der Migrationsassistent konnte nicht in einem Linux Host bereitgestellt werden. Bitte überprüfen Sie die SSH-Verbindung zum Quellhost.',
    'backup__error3114' => 'Der Migrationsassistent konnte nicht in einem Linux Host bereitgestellt werden: Die SSH-Verbindung ist fehlgeschlagen.',
    'backup__error3115' => 'Der Benutzername oder das Passwort ist ungültig.',
    'backup__error3116' => 'Der angegebene Benutzer besitzt keine Administrationsrechte.',

    'dns_t__unable_to_remove_ns_record' => 'Der NS-Eintrag aus dem DNS-Template kann nicht entfernt werden: Jede DNS-Zone muss mindestens einen NS-Eintrag haben.',
    'dns__unsupported_server_zone_transfer' => 'Das Transferbeschränkungs-Template kann aufgrund der serverweiten DNS-Konfiguration nicht übertragen werden: Auf dem Quellserver werden die folgenden Netzwerkadressen zum Zonentransfer zugelassen, jedoch vom Microsoft DNS-Server unterbunden: %1',
    'dns__unsupported_domain_zone_transfer' => 'Das Transferbeschränkungs-Template kann aufgrund der DNS-Konfiguration der Domains nicht übertragen werden: Auf einigen Domains werden die folgenden Netzwerkadressen zum Zonentransfer zugelassen, jedoch vom Microsoft DNS-Server unterbunden: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Der Zugriff auf das freigegebene temporäre Netzwerkverzeichnis für Backupdateien ist nicht möglich. Bitte überprüfen Sie die Einstellungen zum Netzwerkverzeichnis, Benutzernamen und Passwort. Fehler: %1',

    'migration_select_exist_db_server' => 'Wählen Sie den Zieldatenbankserver aus',

    'dbbackup__temp_dir_wrong_value' => 'Der angegebene Wert für das temporäre Verzeichnis ist ungültig.',
    'dbbackup__network_temp_dir_wrong_value' => 'Der angegebene Wert für das temporäre Netzwerkverzeichnis ist ungültig.',
    'dbbackup__server_backup_not_configured' => 'Die Datenbank-Backup-Einstellungen sind auf dem Server nicht konfiguriert.',
    'dbbackup__temp_dir' => 'Temporäres Verzeichnis',
    'dbbackup__temp_dir_hint' => 'Der Pfad zu einem physischen Ordner auf dem Remoteserver, in dem sich der MS SQL-Server befindet. Der MS SQL-Server muss zum Zwecke des Lesens und Schreibens temporärer Backupdateien auf diesen Ordner zugreifen können. Zum Beispiel: C:\\Verzeichnispfad',
    'dbbackup__network_temp_dir_hint' => 'Der Pfad zur Netzwerkfreigabe wurde dem oben angegebenen physischen Ordner zugewiesen. Plesk wird auf den freigegebenen Ordner zugreifen, um Backupdateien herunter- und hochzuladen. Zum Beispiel: \\\\Servername\\Verzeichnispfad',
    'dbbackup__network_user_hint' => 'Der Benutzername eines auf dem Remoteserver erstellten Netzwerkbenutzers. Zum Beispiel: Servername\\Benutzername. Der Benutzer muss Zugriff auf den oben angegebenen freigegebenen Ordner haben.',
    'dbbackup__network_password_hint' => 'Das Passwort des Netzwerkbenutzers',

    'dbbackup__success_import_without_dublicate_users' => 'Folgende Benutzer wurden nicht importiert: %1. Sie existieren bereits auf dem Datenbankserver.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Protokolldateien komprimieren",
    'log_rot__log_rot_status' => "Protokollrotationsstatus",
    'log_rot__log_rot_period' => "Bedingung für Protokollrotation",
    'log_rot__log_rot_size' => "nach Größe",
    'log_rot__log_rot_time' => "nach Zeit",
    'log_rot__logrotation_enable' => "Logrotation aktivieren",
    'log_rot__mail' => "Verarbeitete Logdateien an E-Mail-Adresse senden",
    'log_rot__max_number_of_logfiles' => "Maximale Anzahl an Protokolldateien",
    'log_rot__time_period' => "Zeitraum",
    'log_rot__unable_turn_off' => 'Die Protokollrotation kann nicht deaktiviert werden, da sie auf Serverebene erzwungen wird',
    'log_rot__unable_set_period' => 'Die Häufigkeit der Protokollrotation muss auf "täglich" festgelegt werden, da dies auf Serverebene erzwungen wird',
    'log_rot__unable_set_max_log_files' => 'Höchstanzahl der Protokolldateien kann nicht über dem serverweiten Grenzwert von %1 liegen',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Erwartete Anzahl: %1",
    'actionlog__incorrect_rotation' => "Ungültige Parameter für die Protokollrotation definiert: %1",
    'actionlog__unknown_rot_period' => "Unbekannte Rotationsperiode: %1",
    'actionlog__unknown_rot_type' => "Unbekannter Rotationstyp: %1",
    'actionlog__session_preferences' => 'Sitzungseinstellungen',
    'actionlog__nis2_delete_prohibited' => 'Das Entfernen von Protokolleinträgen ist aufgrund der geltenden Einschränkungen der NIS2-Richtlinie nicht zulässig.',
    'actionlog__nis2_forbidden_rot_type' => "Der Protokollrotationstyp \"%1\" kann aufgrund der geltenden Einschränkungen der NIS2-Richtlinie nicht verwendet werden.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Administrator-Informationen',
    'actionlog__admin_preferences' => "Administratoreinstellungen",
    'actionlog__service' => 'Dienst',
    'actionlog__ip_addr' => 'IP-Adresse',
    'actionlog__client' => 'Kundenkonto',
    'actionlog__client_status' => 'Kundenkonto-Status',
    'actionlog__client_preferences' => "Oberflächeneinstellungen des Kunden",
    'actionlog__client_ip_pool' => "IP-Pool des Kunden",
    'actionlog__client_siteapp' => "Webanwendungspool des Kunden",
    'actionlog__client_guid' => "Kunden-GUID",
    'actionlog__domain' => 'Standarddomain (erste Domain, die einem Abonnement hinzugefügt wurde)',
    'actionlog__domain_owner' => 'Abonnement-Besitzer',
    'actionlog__domain_plan' => 'Service-Paket des Abonnements',
    'actionlog__domain_status' => 'Standarddomain, Status',
    'actionlog__domain_dns' => 'Standarddomain, DNS-Zone',
    'actionlog__subdomain' => 'Subdomain einer Standarddomain',
    'actionlog__domain_alias' => 'Standarddomain, Alias',
    'actionlog__domain_alias_dns' => 'Standarddomain, Alias-DNS-Zone',
    'actionlog__site' => 'Domain',
    'actionlog__site_status' => 'Domainstatus',
    'actionlog__site_dns' => 'Domain-DNS-Zone',
    'actionlog__site_guid' => 'Domain-GUID',
    'actionlog__site_subdomain' => 'Subdomain',
    'actionlog__site_alias' => 'Domain-Alias',
    'actionlog__site_alias_dns' => 'DNS-Zone des Domain-Alias',
    'actionlog__domain_limits' => 'Abonnement-Grenzen',
    'actionlog__domain_limit_size' => 'Speicherplatzlimit für Abonnement',
    'actionlog__domain_limit_traffic' => 'Traffic-Grenze für Abonnement',
    'actionlog__domain_limits_powerUser' => 'Abonnementlimits',
    'actionlog__domain_limit_size_powerUser' => 'Speicherplatzlimit für Abonnement',
    'actionlog__domain_limit_traffic_powerUser' => 'Traffic-Limit für Abonnement',
    'actionlog__domain_guid' => "Standarddomain, GUID",
    'actionlog__cp_user' => 'Plesk Benutzer',
    'actionlog__mailname' => 'E-Mail-Konto',
    'actionlog__maillist' => 'Mailingliste',
    'actionlog__phosting' => 'Hosting-Einstellungen',
    'actionlog__forwarding' => 'Standard- oder Frame-Weiterleitungs-Hosting',
    'actionlog__webuser' => 'Webbenutzerkonto',
    'actionlog__site_application' => 'Webanwendung',
    'actionlog__license' => 'Lizenzschlüssel',
    'actionlog__additional_license' => 'Zusätzlicher Lizenzschlüssel',
    'actionlog__template_domain' => "Service-Paket eines Resellers",
    'actionlog__template_admin' => "Service-Paket des Administrators",
    'actionlog__template_reseller' => 'Reseller-Paket',
    'actionlog__admin_alias' => 'Zusätzliches Administratorkonto', // PFW
    'actionlog__ftpuser' => 'Zusätzliches FTP-Konto', // PFW
    'actionlog__db_server' => 'Datenbankserver',
    'actionlog__db' => 'Datenbank',
    'actionlog__db_user' => 'Datenbankbenutzerkonto',
    'actionlog__client_sapppkg_pool' => "Webanwendung des Benutzers", // PFW, not used?
    'actionlog__remote_dns' => 'Remote-DNS-Serverstatus', // PFW
    'actionlog__reseller' => 'Reseller-Konto',
    'actionlog__reseller_guid' => 'Reseller-GUID',
    'actionlog__reseller_ip_pool' => "Reseller-IP-Pool",
    'actionlog__reseller_limit_size' => 'Speicherplatzlimit für Reseller-Konto',
    'actionlog__reseller_limit_traffic' => 'Traffic-Grenze für Reseller-Konto',
    'actionlog__reseller_limits' => 'Reseller-Konto-Grenzen',
    'actionlog__reseller_permissions' => 'Reseller-Berechtigungen',
    'actionlog__reseller_preferences' => "Oberflächeneinstellungen des Resellers",
    'actionlog__reseller_siteapp' => "Webanwendungen im Reseller-Pool",
    'actionlog__reseller_status' => 'Reseller-Konto-Status',
    'actionlog__health_status' => 'Serverzustand',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'erreicht',
    'actionlog__added' => 'hinzugefügt',
    'actionlog__removed' => 'entfernt',
    'actionlog__change' => 'geändert',
    'actionlog__update' => 'aktualisiert',
    'actionlog__move' => 'verschoben',
    'actionlog__upgrade' => 'aktualisiert', // PFU?
    'actionlog__update_or_add' => 'aktualisiert oder hinzugefügt',
    'actionlog__expired' => 'abgelaufen',
    'actionlog__create' => 'erstellt',
    'actionlog__delete' => 'gelöscht',
    'actionlog__service_stop' => 'angehalten',
    'actionlog__service_restart' => 'neu gestartet',
    'actionlog__service_start' => 'gestartet',
    'actionlog__login' => 'angemeldet',
    'actionlog__logout' => 'abgemeldet',
    'actionlog__install' => 'installiert',
    'actionlog__uninstall' => 'deinstalliert',
    'actionlog__reconfigure' => 'neu konfiguriert',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Anfrage zum Zurücksetzen des Passworts',
    'actionlog__event_admin_update' => 'Administratordaten aktualisiert',
    'actionlog__event_admin_preferences_update' => "Administratoreinstellungen aktualisiert",
    'actionlog__event_service_restart' => 'Service neu gestartet',
    'actionlog__event_service_start' => 'Service gestartet',
    'actionlog__event_service_stop' => 'Service beendet',
    'actionlog__event_ip_address_create' => 'IP-Adresse erstellt',
    'actionlog__event_ip_address_delete' => 'IP-Adresse gelöscht',
    'actionlog__event_ip_address_update' => 'IP-Adresse aktualisiert',
    'actionlog__event_client_create' => 'Kundenkonto erstellt',
    'actionlog__event_client_delete' => 'Kundenkonto gelöscht',
    'actionlog__event_client_update' => 'Kundenkonto aktualisiert',
    'actionlog__event_client_status_update' => 'Status des Kundenkontos aktualisiert',
    'actionlog__event_client_preferences_update' => "Einstellungen zur Oberfläche eines Kunden aktualisiert",
    'actionlog__event_client_siteapp_added' => "Webanwendung zum Anwendungspool des Kunden hinzugefügt",
    'actionlog__event_client_siteapp_removed' => "Webanwendung vom Anwendungspool des Kunden entfernt",
    'actionlog__event_domain_limit_size_reached' => 'Speicherplatzgrenze für Abonnement erreicht',
    'actionlog__event_domain_limit_traffic_reached' => 'Traffic-Grenze für Abonnement erreicht',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Speicherplatzlimit für Abonnement erreicht',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Traffic-Limit für Abonnement erreicht',

    'actionlog__domain_limit_database' => 'Datenbankkontingent für Abonnement',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'MariaDB/MySQL-Datenbankkontingent für das Abonnement erreicht',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'MariaDB/MySQL-Datenbank-Soft-Quota für das Abonnement erreicht',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Datenbankkontingent des Microsoft SQL Servers für das Abonnement erreicht',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Datenbank-Soft-Quota des Microsoft SQL Servers für das Abonnement erreicht',
    'actionlog__event_plesk_component_upgrade' => 'Plesk Komponente aktualisiert',
    'actionlog__event_plesk_component_install' => 'Plesk Komponente installiert',
    'actionlog__event_plesk_component_uninstall' => 'Plesk Komponente deinstalliert',
    'actionlog__event_domain_create' => 'Standarddomain erstellt (erste Domain, die einem Abonnement hinzugefügt wurde)',
    'actionlog__event_domain_delete' => 'Standarddomain gelöscht (erste Domain, die einem Abonnement hinzugefügt wurde)',
    'actionlog__event_domain_update' => 'Standarddomain aktualisiert (erste Domain, die einem Abonnement hinzugefügt wurde)',
    'actionlog__event_domain_owner_change' => 'Abonnement-Inhaber geändert',
    'actionlog__event_domain_plan_change' => 'Service-Paket des Abonnements geändert',
    'actionlog__event_domain_status_update' => 'Standarddomain, Status aktualisiert',
    'actionlog__event_domain_dns_update' => 'Standarddomain, DNS-Zone aktualisiert',
    'actionlog__event_subdomain_create' => 'Subdomain zu einer Standarddomain erstellt',
    'actionlog__event_subdomain_delete' => 'Subdomain einer Standarddomain gelöscht',
    'actionlog__event_subdomain_update' => 'Subdomain einer Standarddomain aktualisiert',
    'actionlog__event_domain_alias_create' => 'Standarddomain, Alias erstellt',
    'actionlog__event_domain_alias_delete' => 'Standarddomain, Alias gelöscht',
    'actionlog__event_domain_alias_update' => 'Standarddomain, Alias aktualisiert',
    'actionlog__event_domain_limits_update' => 'Abonnementgrenzen aktualisiert',
    'actionlog__event_cp_user_login' => 'Plesk Benutzer hat sich angemeldet',
    'actionlog__event_cp_user_logout' => 'Plesk Benutzer hat sich abgemeldet',
    'actionlog__event_mailname_create' => 'E-Mail-Konto erstellt',
    'actionlog__event_mailname_delete' => 'E-Mail-Konto gelöscht',
    'actionlog__event_mailname_update' => 'E-Mail-Konto aktualisiert',
    'actionlog__event_maillist_create' => 'Mailingliste erstellt',
    'actionlog__event_maillist_delete' => 'Mailingliste gelöscht',
    'actionlog__event_maillist_update' => 'Mailingliste aktualisiert',
    'actionlog__event_phys_hosting_create' => 'Physisches Hosting erstellt',
    'actionlog__event_phys_hosting_delete' => 'Physisches Hosting gelöscht',
    'actionlog__event_phys_hosting_update' => 'Physisches Hosting aktualisiert',
    'actionlog__event_forwarding_create' => 'Hosting mit Standard- oder Frame-Weiterleitung erstellt',
    'actionlog__event_forwarding_delete' => 'Hosting mit Standard- oder Frame-Weiterleitung gelöscht',
    'actionlog__event_forwarding_update' => 'Hosting mit Standard- oder Frame-Weiterleitung aktualisiert',
    'actionlog__event_webuser_create' => 'Webbenutzerkonto erstellt',
    'actionlog__event_webuser_delete' => 'Webbenutzerkonto gelöscht',
    'actionlog__event_webuser_update' => 'Webbenutzerkonto aktualisiert',
    'actionlog__event_siteapp_install' => 'Webanwendung installiert',
    'actionlog__event_siteapp_reconfigure' => 'Webanwendung neu konfiguriert',
    'actionlog__event_siteapp_uninstall' => 'Webanwendung deinstalliert',
    'actionlog__event_license_update' => 'Lizenzschlüssel aktualisiert',
    'actionlog__event_admin_alias_create' => 'Zusätzliches Administratorkonto erstellt',
    'actionlog__event_admin_alias_delete' => 'Zusätzliches Administratorkonto gelöscht',
    'actionlog__event_admin_alias_update' => 'Zusätzliches Administratorkonto aktualisiert',
    'actionlog__event_ftpuser_create' => 'Zusätzliches FTP-Konto erstellt',
    'actionlog__event_ftpuser_update' => 'Zusätzliches FTP-Konto aktualisiert',
    'actionlog__event_ftpuser_delete' => 'Zusätzliches FTP-Konto gelöscht',
    'actionlog__event_template_domain_create' => "Service-Paket eines Resellers erstellt",
    'actionlog__event_template_domain_update' => "Service-Paket eines Resellers aktualisiert",
    'actionlog__event_template_domain_delete' => "Service-Paket eines Resellers gelöscht",
    'actionlog__event_template_admin_create' => "Service-Paket des Administrators erstellt",
    'actionlog__event_template_admin_update' => "Service-Paket des Administrators aktualisiert",
    'actionlog__event_template_admin_delete' => "Service-Paket des Administrators gelöscht",
    'actionlog__event_database_server_create' => 'Datenbankserver erstellt',
    'actionlog__event_database_server_update' => 'Datenbankserver aktualisiert',
    'actionlog__event_database_server_delete' => 'Datenbankserver gelöscht',
    'actionlog__event_remote_dns_status_update' => 'Remote-DNS-Serverstatus aktualisiert',
    'actionlog__event_session_preferences_update' => 'Sitzungseinstellungen aktualisiert',
    'actionlog__event_domain_alias_dns_update' => 'Standarddomain, DNS-Zone eines Domain-Alias aktualisiert',
    'actionlog__event_domain_move' => 'Standarddomain in ein neues Abonnement verschoben',
    'actionlog__event_site_move' => 'Domain in ein neues Abonnement verschoben',
    'actionlog__event_site_subdomain_move' => 'Subdomain in ein neues Abonnement verschoben',
    'actionlog__event_subdomain_move' => 'Subdomain einer Standarddomain in ein neues Abonnement verschoben',
    'actionlog__event_license_expired' => 'Plesk Lizenz abgelaufen',
    'actionlog__event_database_create' => 'Datenbank erstellt',
    'actionlog__event_database_delete' => 'Datenbank entfernt',
    'actionlog__event_database_user_create' => 'Datenbankbenutzerkonto erstellt',
    'actionlog__event_database_user_update' => 'Einstellungen für Datenbankbenutzerkonto aktualisiert',
    'actionlog__event_database_user_delete' => 'Datenbankbenutzerkonto entfernt',
    'actionlog__event_client_guid_update' => "Kunden-GUID aktualisiert",
    'actionlog__event_domain_guid_update' => 'Standarddomain, GUID aktualisiert',
    'actionlog__event_reseller_create' => 'Reseller-Konto erstellt',
    'actionlog__event_reseller_delete' => 'Reseller-Konto gelöscht',
    'actionlog__event_reseller_update' => 'Reseller-Konto aktualisiert',
    'actionlog__event_reseller_guid_update' => 'Reseller-GUID aktualisiert',
    'actionlog__event_reseller_ip_pool_update' => "Reseller-IP-Pool aktualisiert",
    'actionlog__event_reseller_limit_size_reached' => 'Speicherplatzgrenze für Reseller-Konto erreicht',
    'actionlog__event_reseller_limit_traffic_reached' => 'Traffic-Grenze für Reseller-Konto erreicht',
    'actionlog__event_reseller_limits_update' => 'Grenzen des Reseller-Kontos aktualisiert',
    'actionlog__event_reseller_permissions_update' => 'Berechtigungen eines Reseller-Kontos aktualisiert',
    'actionlog__event_reseller_preferences_update' => "Einstellungen zur Oberfläche eines Resellers aktualisiert",
    'actionlog__event_reseller_siteapp_added' => "Anwendung zum Anwendungspool eines Reseller-Kontos hinzugefügt",
    'actionlog__event_reseller_siteapp_removed' => "Anwendung aus dem Anwendungspool eines Reseller-Kontos entfernt",
    'actionlog__event_reseller_status_update' => 'Status eines Reseller-Kontos aktualisiert',
    'actionlog__event_template_reseller_create' => 'Reseller-Paket erstellt',
    'actionlog__event_template_reseller_delete' => 'Reseller-Paket gelöscht',
    'actionlog__event_template_reseller_update' => 'Reseller-Paket aktualisiert',
    'actionlog__event_health_status_change' => 'Serverzustand geändert',
    'actionlog__event_siteapp_upgrade' => 'Webanwendung upgegradet',
    'actionlog__event_extension_install' => 'Erweiterung wurde installiert',
    'actionlog__event_extension_uninstall' => 'Erweiterung wurde deinstalliert',
    'actionlog__event_extension_upgrade' => 'Upgrade der Erweiterung abgeschlossen',
    'actionlog__event_extension_status_update' => 'Erweiterungsstatus wurde aktualisiert',
    'actionlog__event_additional_license_expired' => 'Die zusätzliche Lizenz ist abgelaufen.',
    'actionlog__event_hostname_changed' => 'Hostname des Servers geändert',
    'actionlog__event_smb_user_create' => 'Zusätzlicher Benutzer erstellt',
    'actionlog__event_smb_user_delete' => 'Zusätzlicher Benutzer gelöscht',
    'actionlog__event_smb_user_update' => 'Zusätzlicher Benutzer aktualisiert',
    'actionlog__dns_record' => 'DNS-Eintrag',
    'actionlog__dns_zone' => 'DNS-Zone',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Das Plesk API RPC ist nicht auf dem Remote-Host installiert. Wenden Sie sich zur weiteren Unterstützung an Ihren Service-Provider.",
    'rsession_no_account_errmsg' => "Der Zugriff auf den Remote-Service ist unter Ihrem Konto nicht möglich. Der wahrscheinlichste Grund hierfür ist, dass der Service für Ihr Konto noch nicht aktiviert ist. Bitte warten Sie einige Minuten und versuchen Sie es anschließend erneut. Sollte dieser Fehler erneut vorkommen, kontaktieren Sie Ihren Systemadministrator.",
    'rsession_no_domain_errmsg' => "Der Zugriff auf den Remote-Service ist für diese Domain nicht möglich. Der wahrscheinlichste Grund hierfür ist, dass der Service für diese Domain noch nicht aktiviert ist. Bitte warten Sie einige Minuten und versuchen Sie es anschließend erneut. Sollte dieser Fehler erneut vorkommen, kontaktieren Sie Ihren Systemadministrator.",
    'rsession_unknown_errmsg' => "Der Remote-Server hat den Versuch, eine Sitzung aufzubauen, zurückgewiesen. Wenden Sie sich an Ihren Systemadministrator, um Hilfe zu erhalten. Folgender Fehler ist aufgetreten: %1",
    'rsession_unknown2_errmsg' => "Unbekannter Fehler während des Aufbaus einer Remote-Sitzung. Höchstwahrscheinlich antwortet der Remote-Server nicht richtig oder gar nicht. Wenden Sie sich an Ihren Systemadministrator, um das Webserver-Fehlerprotokoll nach Fehlerhinweisen zu überprüfen.",
    'rsession_no_connect_errmsg' => "Der Zugriff auf den Remote-Service ist nicht möglich: Verbindung zur Remote-Sitzung fehlgeschlagen. Wenden Sie sich an Ihren Systemadministrator, um Hilfe zu erhalten.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Upload in das Eingangsverzeichnis zulassen",
    'anonftp__allow_create_dirs' => 'Erstellen von Ordnern im Eingangsverzeichnis zulassen',
    'anonftp__allow_download_incoming' => 'Download aus dem Eingangsverzeichnis zulassen',
    'anonftp__display_login' => 'Anmeldenachricht anzeigen',
    'anonftp__login_text' => 'Nachrichtentext',
    'anonftp__limit_incoming_disk_space' => "Speicherplatz im Eingangsverzeichnis beschränken",
    'anonftp__limit_maximum_bandwidth' => "Download-Bandbreite für diese virtuelle FTP-Domain beschränken",
    'anonftp__limit_maximum_connections' => "Anzahl gleichzeitiger Verbindungen beschränken",
    'anonftp__unable_init' => "Anonymous-FTP-Konto kann nicht initialisiert werden: %1",
    'anonftp__unable_set_quota' => "Speicherplatzlimit für das Eingangsverzeichnis kann nicht konfiguriert werden: %1",
    'anonftp__unable_update' => "Eigenschaften von Anonymous-FTP-Konto können nicht aktualisiert werden: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-Zertifikate', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Das CA-Zertifikat signiert das Zertifikat nicht.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Inkompatibles Paar von privatem Schlüssel und Zertifikat",
    'class_sslcertificate__invalid_cert_format' => "Ungültiges Zertifikatsformat.",
    'class_sslcertificate__invalid_private_key_format' => "Das Format des privaten Schlüssels ist ungültig.",
    'class_sslcertificate__prob_invalid_priv_key' => "Wahrscheinlich ist das Format des privaten Schlüssels ungültig.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Virtuelles Verzeichnis erstellen',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Virtuelles Verzeichnis erstellen',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Erstellen Sie ein virtuelles Verzeichnis.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Virtuelles Verzeichnis erstellen',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Virtuelles Verzeichnis erstellen',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Erstellen Sie ein virtuelles Verzeichnis.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Verzeichnis-eigenschaften',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Eigenschaften von virtuellem Verzeichnis',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Eigenschaften von virtuellem Verzeichnis anzeigen und ändern.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Verzeichnis-eigenschaften',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Eigenschaften von virtuellem Verzeichnis',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Eigenschaften von virtuellem Verzeichnis anzeigen und ändern.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME-Typen',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME-Typen',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Liste der registrierten MIME-Typen anzeigen.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'MIME-Typ hinzufügen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'MIME-Typ hinzufügen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Neuen MIME-Typ registrieren.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Fehlerdokumente',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Fehlerdokumente',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Fehlerdokumente anzeigen und ändern.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Schutz',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Verzeichnisschutz',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Schränken Sie den Zugriff auf das Verzeichnis durch einen Passwortschutz ein.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Schutz',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Verzeichnisschutz',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Schränken Sie den Zugriff auf das Verzeichnis durch einen Passwortschutz ein.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Einstellungen',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Speicherort des Verzeichnisses anzeigen und einen Titel für den geschützten Bereich angeben.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Benutzereinstellungen',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Benutzer hinzufügen',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Benutzer hinzufügen',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Fügen Sie ein Benutzerkonto hinzu, um Zugriff auf das geschützte Verzeichnis zu ermöglichen.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Die neuen Einstellungen wurden übernommen.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Das Benutzerkonto wurde hinzugefügt.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Entfernen',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Benutzer aus dem geschützten Verzeichnis entfernen.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Benutzerkonten entfernen',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Entfernen von Benutzerkonten bestätigen.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Die Benutzerkonten wurden entfernt.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Vorgang abgeschlossen.',
    'ui__admin/extras-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__admin/report/layout/delete_multi__done' => 'Ausgewählte Berichtlayouts wurden entfernt.',
    'ui__admin/report/traffic-history__done' => 'Vorgang abgeschlossen.',
    'ui__admin/report__done' => 'Vorgang abgeschlossen.',
    'ui__admin-alias/delete_multi__done' => "Ausgewählte zusätzliche Administratorkonten wurden entfernt.",
    'ui__admin-alias/properties__done' => "Eigenschaften von zusätzlichem Administratorkonto wurden aktualisiert.",
    'ui__admin-alias/properties_new__done' => "Zusätzliches Administratorkonto wurde erstellt.",
    'ui__admin-alias/properties_unknown__done' => "Eigenschaften von zusätzlichem Administratorkonto wurden aktualisiert.",
    'ui__admin-alias__done' => "Informationen des zusätzlichen Administratorkontos wurden aktualisiert.",
    'ui__admin/manage-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__admin/register-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Ausgewählte Berichtzustellungspläne wurden entfernt.',
    'ui__admin/report/layout/auto/properties__done' => 'Berichtzustellungsplan wurde aktualisiert.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Berichtzustellungsplan wurde erstellt.',
    'ui__client/domain/certificate/properties__done' => 'Die Eigenschaften des SSL/TLS-Zertifikats wurden aktualisiert.',
    'ui__client/domain/certificate/properties_new__done' => 'Es wurde ein neues SSL/TLS-Zertifikat hinzugefügt. Damit es funktioniert, müssen Sie es in den Hosting-Einstellungen der Website auswählen (auf der Registerkarte "Websites & Domains" > "Domainname").',
    'ui__client/domain/certificate__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/certificate_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/chowner__done' => 'Abonnement %1 gehört nun einem anderen Benutzer.',
    'ui__client/domain/chowner_multi__done' => 'Der Besitzer des Abonnements wurde geändert.',
    'ui__client/domain/chowner_multi-select__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/chowner_select__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/dbbackup/create__done' => "Backup der Datenbank wurde erfolgreich erstellt.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Backup der Datenbank wurde erfolgreich erstellt.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Verwaister Benutzer wurde repariert.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Backupdateien wurden entfernt.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Datenbankinhalt wurde erfolgreich wiederhergestellt.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Vorgang abgeschlossen.", // PFW
    'ui__client/domain/dbbackup__done' => "Vorgang abgeschlossen.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Vorgang abgeschlossen.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Vorgang abgeschlossen.", // PFW
    'ui__client/domain/delete__done' => "Die Domain %1 wurde entfernt.",
    'ui__client/domain/delete_multi__done' => "Die Domains wurden entfernt.",
    'ui__client/domain/disable__done' => 'Die Domain %1 wurde gesperrt.',
    'ui__client/domain/disable_multi__done' => 'Die ausgewählten Domains wurden gesperrt.',
    'ui__client/domain/enable__done' => 'Die Website %1 wurde aktiviert.',
    'ui__client/domain/enable_multi__done' => 'Ausgewählte Websites wurden aktiviert.',
    'ui__client/domain/extras__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/domain/extras_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Einstellungen für die Protokollrotation wurden geändert.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Einstellungen für die Protokollrotation wurden geändert.',
    'ui__client/domain/hosting/logs__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/hosting/logs_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/hosting/setup__done' => 'Hosting für %1 wurde konfiguriert.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Vorgang erfolgreich abgeschlossen.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Vorgang erfolgreich abgeschlossen.', // PFU
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Das virtuelle Verzeichnis unter der Website %1 wurde erstellt.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Virtuelles Verzeichnis wurde erstellt', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Ausgewählte Verzeichnisse wurden entfernt.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Ausgewählte Verzeichnisse wurden entfernt.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Benutzerdefinierte Fehlerdokumente wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Ausgewählte MIME-Typen wurden entfernt', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Neuer MIME-Typ wurde registriert.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Vorgang abgeschlossen.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Die Verzeichniszugriffsberechtigungen wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Die Verzeichniszugriffsberechtigungen wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP-Einstellungen für %1 wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'PHP-Einstellungen für %1 wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Verzeichnis-Eigenschaften wurden aktualisiert', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Verzeichnis-Eigenschaften wurden aktualisiert', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Verzeichnisschutz-Einstellungen wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Verzeichnisschutz-Einstellungen wurden aktualisiert.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Vorgang abgeschlossen.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Vorgang abgeschlossen.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Im Online-Shop verfügbare SSL/TLS-Zertifikate',
    'ui__client/domain/mpc-certificates_self__done' => 'Im Online-Shop verfügbare SSL/TLS-Zertifikate',
    'ui__client/domain/register__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/domain/register_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/domain/rename__done' => 'Der Domainname wurde geändert.',
    'ui__client/domain/rename_self__done' => "Der Domainname wurde erfolgreich geändert.",
    'ui__client/domain/settings_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/toggle_disable__done' => "Die Domain %1 wurde gesperrt.",
    'ui__client/domain/toggle_enable__done' => "Die Domain %1 wurde aktiviert.",
    'ui__client/domain/traffic__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/traffic_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain/traffic_unknown__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain-summary-report__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain-summary-report_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/domain-summary-report_unknown__done' => 'Vorgang abgeschlossen.',
    'ui__client/extras-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/extras-domain_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/ipaddress/delete_multi__done' => 'Vorgang abgeschlossen.',
    'ui__client/ipaddress/properties__done' => 'Vorgang abgeschlossen.',
    'ui__client/ipaddress/properties_new__done' => 'Vorgang abgeschlossen.',
    'ui__client/ip-pool/properties__done' => "IP-Pool von Kunde %1 wurde aktualisiert.",
    'ui__client/ip-pool/properties_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/limits__done' => "Ressourcengrenzen für Kunde %1 wurden geändert.",
    'ui__client/limits_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/logo__done' => 'Die Einstellungen für das neue Panel-Branding des Kunden %1 wurden übernommen.',
    'ui__client/logo_reseller__done' => 'Die Einstellungen für das neue Panel-Branding wurden übernommen.',
    'ui__client/logo_self__done' => 'Branding-Einstellungen wurden übernommen.',
    'ui__client/logo_self-reseller__done' => 'Ihre Einstellungen für das neue Panel-Branding wurden übernommen.',
    'ui__client/manage-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/manage-domain_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/permissions__done' => "Berechtigungen von Kunde %1 wurden geändert.",
    'ui__client/permissions_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/preferences__done' => "Die Einstellungen des Kunden %1 wurden geändert.",
    'ui__client/preferences_self__done' => "Ihre Einstellungen wurden gespeichert.",
    'ui__client/register-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/register-domain_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__client/report/traffic-history__done' => 'Vorgang abgeschlossen.',
    'ui__client/report/traffic-history_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/report__done' => 'Vorgang abgeschlossen.',
    'ui__client/report_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/sessions/delete__done' => 'Vorgang abgeschlossen.',
    'ui__client/sessions/delete_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/sessions__done' => 'Vorgang abgeschlossen.',
    'ui__client/sessions_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/skeleton__done' => 'Vorgang abgeschlossen.',
    'ui__client/skeleton_self__done' => 'Vorgang abgeschlossen.',
    'ui__client/traffic__done' => "Vorgang abgeschlossen.",
    'ui__client/traffic_unknown__done' => 'Vorgang abgeschlossen.',
    'ui__cp-access__done' => 'Vorgang abgeschlossen.',
    'ui__cp-session/properties__done' => 'Vorgang abgeschlossen.',
    'ui__cp-session__done' => 'Vorgang abgeschlossen.',
    'ui__ftp-sessions__done' => 'Vorgang abgeschlossen.',
    'ui__license__done' => 'Vorgang abgeschlossen.',
    'ui__logo__done' => "Die Branding-Eigenschaften von Plesk wurden geändert.",
    'ui__longtasks/longtask/properties__done' => "Die Einstellungen für Hintergrundaufgaben wurden geändert.",
    'ui__mass-email/delete__done' => "Nachrichten-Template %1 wurde entfernt.", // PFW
    'ui__mass-email/delete_multi__done' => "Nachrichten-Templates wurden entfernt.",  // PFW
    'ui__mass-email/send_main__done' => "Vorgang abgeschlossen.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Die Kundenkonten wurden erfolgreich ausgewählt.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Domainadministratorkonten wurden erfolgreich ausgewählt.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Reseller-Konten wurden erfolgreich ausgewählt.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Die Änderungen am Template für Massen-E-Mails wurden gespeichert.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Massen-E-Mail-Template wurde erstellt.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Kundenkonten für das Massen-E-Mail-Template wurden ausgewählt.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Domainadministratorkonten für das Massen-E-Mail-Template wurden ausgewählt.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Reseller-Konten für das Massen-E-Mail-Template wurden ausgewählt.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Massen-E-Mail-Template wurde geändert.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Ungültige Werte wurden angegeben.', // PFW
    'ui__mass-email__done' => "Operation erfolgreich abgeschlossen", // PFW
    'ui__mass-mail__done' => "Vorgang abgeschlossen", // PFU
    'ui__mass-mail/delete__done' => 'Nachrichten-Template %1 wurde entfernt.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Nachrichten-Templates wurden entfernt.', // PFU
    'ui__mass-mail/properties__done' => 'Template %1 wurde geändert.', // PFU
    'ui__mass-mail/properties_new__done' => 'Template %1 wurde erstellt.', // PFU
    'ui__mass-mail/send__done' => 'Die Nachrichten wurden gesendet.', // PFU
    'ui__mass-mail/send_new__done' => 'Die Nachrichten wurden gesendet.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Die Nachrichten wurden gesendet.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Die Nachrichten wurden gesendet.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Neues Nachrichten-Template wurde erstellt', // PFU
    'ui__mass-mail/template/properties__done' => 'Nachrichten-Template wurde geändert.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Die neuen Einstellungen zur Speicherplatzüberwachungen wurden übernommen.', // PFU
    'ui__modules__done' => 'Vorgang abgeschlossen.',
    'ui__modules__short-title' => 'Erweiterungen',
    'ui__modules__title' => 'Erweiterungen',
    'ui__reseller/client/traffic_unknown__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/extras-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__reseller/extras-domain_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__reseller/ftp-sessions_self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/limits__done' => "Ressourcengrenzen und Ressourcenverbrauchs-Richtlinien des Resellers wurden geändert.",
    'ui__reseller/limits_readonly-self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/limits_self__done' => 'Ihre Ressourcengrenzen und Ressourcenverbrauchs-Richtlinien wurden geändert.',
    'ui__reseller/manage-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__reseller/manage-domain_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__reseller/permissions__done' => 'Berechtigungen von Reseller %1 wurden geändert.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/register-domain__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__reseller/register-domain_self__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Ausgewählte Berichtzustellungslayouts wurden entfernt.',
    'ui__reseller/report/layout/auto/properties__done' => 'Berichtzustellungsplan wurde aktualisiert.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Der Berichtzustellungsplan wurde geändert.',
    'ui__reseller/report/traffic-history__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/report/traffic-history_self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/report__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/report_self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/sessions/delete__done' => 'Vorgang abgeschlossen',
    'ui__reseller/sessions/delete_self__done' => 'Vorgang abgeschlossen',
    'ui__reseller/sessions__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/sessions_self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/traffic__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/traffic_self__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/traffic_unknown__done' => 'Vorgang abgeschlossen.',
    'ui__reseller/logo_self__title' => 'Plesk Branding',
    'ui__reseller/logo_self__done' => 'Ihre Plesk Branding-Einstellungen wurden übernommen.',
    'ui__server/certificate/default_multi__done' => 'Das ausgewählte SSL/TLS-Zertifikat wurde zum Schutz der Verbindungen zu neu gehosteten Websites eingerichtet.',
    'ui__server/certificate/delete_multi__done' => 'Die ausgewählten SSL/TLS-Zertifikate wurden entfernt.',
    'ui__server/certificate/download__done' => 'SSL/TLS-Zertifikat wurde heruntergeladen.',
    'ui__server/certificate/properties__done' => 'Die Eigenschaften des SSL/TLS-Zertifikats wurden aktualisiert.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-Zertifikat %1 wurde erstellt.',
    'ui__server/certificate/setup_multi__done' => 'Das ausgewählte SSL/TLS-Zertifikat wurde zum Schutz der Verbindungen zu Plesk eingerichtet.',
    'ui__server/certificate__done' => 'Vorgang abgeschlossen.',
    'ui__server/cp-certificate-download__done' => "Das SSL/TLS-Zertifikat von Plesk wurde heruntergeladen.",
    'ui__server/crontab/properties__done' => 'Geplante Aufgaben von %1 wurden geändert.',
    'ui__server/crontab/task/delete__done' => 'Die Aufgabe wurde entfernt.',
    'ui__server/crontab/task/delete_multi__done' => 'Die Aufgaben wurden entfernt.',
    'ui__server/crontab/task/properties__done' => 'Die geplanten Aufgaben wurden aktualisiert.',
    'ui__server/crontab/task/properties_new__done' => 'Die neue Aufgabe wurde geplant.',
    'ui__server/crontab/task/toggle_disable__done' => 'Geplante Aufgabe %1 wurde deaktiviert.',
    'ui__server/crontab/task/toggle_enable__done' => 'Geplante Aufgabe %1 wurde aktiviert.',
    'ui__server/crontab__done' => 'Vorgang abgeschlossen.',
    'ui__server/dns__done' => 'Vorgang abgeschlossen.',
    'ui__server/ip-address/client/delete__done' => "Die IP-Adresse wurde aus dem IP-Pool des Benutzers entfernt.",
    'ui__server/ip-address/client/delete_multi__done' => "Die IP-Adresse wurde aus den IP-Pools der Benutzer entfernt.",
    'ui__server/ip-address/client/properties_new__done' => 'Die IP-Adresse wurde Benutzern zugewiesen.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-Adresse %1 wurde den ausgewählten Kunden zugewiesen.',
    'ui__server/ip-addresses__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/spam/recipients__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/spam/summary__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/spam__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/virus/recipients__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/virus/summary__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/virus/viruses__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics/virus__done' => "Vorgang abgeschlossen.",
    'ui__server/mail/statistics__done' => "Vorgang abgeschlossen.",
    'ui__server/mail__done' => 'Die Mailserver-Einstellungen wurden geändert.',
    'ui__server/maillists__done' => 'Vorgang abgeschlossen.',
    'ui__server/mpc-certificates__done' => 'Die Seite im Online-Shop, die alle verfügbaren SSL/TLS-Zertifikate enthält, wurde geöffnet.',
    'ui__server/pmm__done' => 'Vorgang abgeschlossen.',
    'ui__server/preferences__done' => "Die Servereinstellungen wurden geändert.",
    'ui__server/register__done' => 'Seite MyPlesk.com wurde geöffnet.',
    'ui__server/services__done' => 'Vorgang abgeschlossen.',
    'ui__server/sitebuilder__done' => 'Vorgang abgeschlossen.',
    'ui__server/skeleton__done' => 'Vorgang abgeschlossen.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Die Adresse %1 wurde aus der serverweiten Blacklist entfernt.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Die Adressen wurden aus der serverweiten Blacklist entfernt.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adressen wurden zur Blacklist hinzugefügt.',
    'ui__server/spam-filter/black-list/address__done' => 'Adressen wurden zur Blacklist hinzugefügt.',
    'ui__server/spam-filter/black-list__done' => 'Vorgang abgeschlossen.', // PFU
    'ui__server/spam-filter/properties__done' => 'Die Spamfilter-Einstellungen wurden geändert.',
    'ui__server/spam-filter/toggle_disable__done' => 'Der Spamfilter wurde systemweit deaktiviert.',
    'ui__server/spam-filter/toggle_enable__done' => 'Der Spamfilter wurde systemweit aktiviert.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Die Adresse %1 wurde aus der serverweiten Whitelist entfernt.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Die Adressen wurden aus der serverweiten Whitelist entfernt.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adressen wurden zur Whitelist hinzugefügt.',
    'ui__server/spam-filter/white-list/address__done' => 'Adressen wurden zur Whitelist hinzugefügt.',
    'ui__server/spam-filter/white-list__done' => 'Vorgang abgeschlossen.', // PFU
    'ui__server/spam-filter__done' => 'Vorgang abgeschlossen.',
    'ui__server/statistics__done' => 'Vorgang abgeschlossen.',
    'ui__server/time__done' => "Systemdatum und -zeit wurden geändert.",
    'ui__server__done' => "Vorgang abgeschlossen.",
    'ui__sessions/properties__done' => 'Vorgang abgeschlossen.',
    'ui__sessions__done' => 'Vorgang abgeschlossen.',
    'ui__sessions/delete__done' => 'Ausgewählte Sitzungen wurden gelöscht.',
    'ui__support__done' => 'Support-Anfrage wurde in einem neuen Browser-Fenster oder in einer neuen Registerkarte geöffnet.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Keine Dateien zum Hochladen vorhanden.',
    'login_up__access_denied_no_permission' => "Zugriff verweigert. Sie sind zur Anmeldung nicht berechtigt.",
    'mail__unable_remove_pattern' => "Entfernen der Adresse aus der Server-Blacklist nicht möglich: %1", // PFW
    'mail__incorrect_network_format' => 'Ungültiges Netzwerkformat: %1', // PFW
    'initconf__unable_change_passwd' => "Administratorpasswort kann nicht geändert werden: %1",
    'initconf__unable_get_passwd' => 'Aktuelles Administratorpasswort kann nicht abgerufen werden: %1 fehlgeschlagen: %2',
    'initconf__invalid_hostname' => 'Fehler im Hostnamen "%1"',
    'initconf__unable_reconfig' => 'Plesk kann nicht konfiguriert werden. reconfig fehlgeschlagen: %1',
    'initconf__unable_update_admin' => 'Kontaktdaten des Administrators können nicht aktualisiert werden: %1',
    '__refresh' => 'Aktualisieren',
    '__dalias_not_exist' => 'Domain-Alias existiert nicht.',
    '__bug146523_explanation' => 'In vorherigen Plesk Versionen durften FTP-Benutzernamen bis zu 16 Zeichen lang sein. In dieser Plesk Version dürfen FTP-Benutzernamen maximal 15 Zeichen lang sein. Um dieses Problem zu beheben, verringern Sie bei betroffenen FTP-Benutzernamen die Länge auf 15 Zeichen und ändern Sie bei betroffenen FTP-Benutzernamen mindestens ein Zeichen, um Konflikte zwischen Benutzernamen zu vermeiden. Wir entschuldigen uns für eventuelle Unannehmlichkeiten, die Ihnen durch diese Änderung entstanden sind.',
    'domain__cannot_change_webmail' => 'Webmail kann für die Domain nicht geändert werden%1',
    'sb_publish_disable_warning' => 'Wenn Sie die Website-Erstellung mit Presence Builder deaktivieren, wird die zuvor in Presence Builder erstellte Website entfernt und alle Website-Daten gehen verloren. Klicken Sie auf OK, wenn Sie fortfahren wollen.',
    '__sbnet_client_use_sbnet' => "Entsprechendes Nutzerkonto in Presence Builder erstellen",
    'mail_resp_activate' => 'Autoresponder aktivieren',
    'limitsManger__limit_available_error' => 'Zuweisen der erforderlichen Ressourcen ("%%limitName%%") nicht möglich: Für Ihr Konto ist nur %%available%% verfügbar.',
    'limitsManger__limit_reserved_error' => 'Es können nicht weniger Ressourcen ("%%limitName%%") zugewiesen werden als bereits genutzt.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Domain kann nicht umbenannt werden: Es existiert bereits ein virtuelles Verzeichnis mit angegebenen Namen.',
    'domain_unable_to_rename' => 'Die Domain kann nicht umbenannt werden.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Allgemein',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin-Spamfilterung',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin-Einstellungen',
    'spamfilter__spamassassin_server_status_legend' =>  "Serverweiten SpamAssassin-Filter aktivieren",
    'spamfilter__spamassassin_user_status_legend' => 'Individuellen SpamAssassin-Filter aktivieren',
    'spamfilter__greylisting_status_legend' => 'Serverweiten Greylisting-Spamschutz aktivieren',
    'spamfilter__personal_settings_not_allowed' => 'Die Verwendung individueller Spamfilter-Einstellungen wird durch die Systemrichtlinie untersagt.',
    'spamfilter__required_score' => 'Die Bewertung, die einer Nachricht zugewiesen werden muss, um als Spam angesehen zu werden',
    'spamfilter__rewrite_header_subject' => 'Den folgenden Text an den Anfang des Betreffs jeder als Spam erkannten Nachricht stellen',
    'spamfilter__use_mailuser_prefs' => 'Individuelle Einstellungen für Spamfilter anwenden',
    'spamfilter__score_error' => 'Die Punktzahl darf nicht negativ sein, der Vorkommawert muss kleiner als 100 sein und es dürfen nicht mehr als 2 Nachkommastellen angegeben werden.',
    'spamfilter__rewrite_header_error' => 'Der Nachrichtenbetreff darf alle druckbaren Zeichen bis auf das Nummernsymbol (#) enthalten.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Bounce (Zurücksenden)',
    'nonexistent_mail__mode_discard' => 'Verwerfen',
    'nonexistent_mail__mode_catch_addr' => 'Weiterleitung an E-Mail-Adresse',
    'nonexistent_mail__mode_catch_ip' => 'An IP weiterleiten',
    'nonexistent_mail__bounce_not_supported' => 'Bounce-Modus nicht unterstützt',
    'nonexistent_mail__discard_not_supported' => 'Verwerfen-Modus nicht unterstützt',
    'nonexistent_mail__catch_not_supported' => 'Weiterleitung an E-Mail-Adresse nicht unterstützt',
    'nonexistent_mail__redirect_not_supported' => 'Weiterleitung zu IP nicht unterstützt',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-Adresse wird zu Localhost aufgelöst',
    'nonexistent_mail_address_should_be_local_domain' => 'Da die Postausgangskontrolle aktiviert ist, sollte die E-Mail-Adresse %1 für nicht existierende Empfänger zur ausgewählten Domain gehören. Ist dies nicht der Fall, wird die Richtlinie "Abweisen" anstatt der Weiterleitung angewendet.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Da die Postausgangskontrolle aktiviert ist, sollte die E-Mail-Adresse, die für die E-Mail-Weiterleitung angegeben ist (%1), zur ausgewählten Domain gehören. Ist dies nicht der Fall, werden Nachrichten, die an diese Adresse gesendet werden, in der Postausgangskontrolle nicht gezählt.',
    // mail acc extras
    '__antivirus' => "Virenschutz",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Es sind keine zusätzlichen Administratorkonten verfügbar.', // PFW
    'ui__client/domain/certificate__none-available' => 'Der Kunde hat keine SSL/TLS-Zertifikate.',
    'ui__client/domain/certificate__none-available__1' => 'Der Kunde hat keine Domains mit SSL/TLS-Zertifikaten.',
    'ui__client/domain/certificate__none-available__2' => 'Die Domain hat keine SSL/TLS-Zertifikate.',
    'ui__reseller/client__none-available' => 'Es sind keine Reseller mit Kunden vorhanden.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Sie müssen die IP-Adressen auswählen, die Sie aus dem IP-Pool entfernen möchten',
    'ui__server/ip-address/client/delete__empty_selection' => 'Sie müssen die Reseller-Konten auswählen, in deren IP-Pool Sie eine IP-Adresse sperren möchten.',
    'ui__server/crontab/task/delete__empty_selection' => 'Sie müssen die Aufgabe auswählen, die Sie abbrechen möchten.',

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'ASP.NET-Unterstützung ist für diese Website deaktiviert.',
    'phosting__php_forced_by_site_isolation' => 'Änderung der PHP-Einstellungen nicht möglich: Es besteht keine Berechtigung zum Überschreiben der serverweiten Sicherheitsrichtlinien.',
    'phosting__option_forced_by_site_isolation' => 'Änderung der %1 Einstellungen nicht möglich: Es besteht keine Berechtigung zum Überschreiben der serverweiten Sicherheitsrichtlinien.',
    'phosting__php_handler_id_not_registered' => 'Der PHP Handler ist in den Website-Isolierungseinstellungen nicht zugelassen. Es wird der Standard-PHP-Handler verwendet.',
    'phosting__php_served_by_nginx_is_not_available' => 'Der PHP Handler (FPM-Anwendung bedient von nginx) ist in den Website-Isolierungseinstellungen nicht zugelassen. Es wird der Standard-PHP-Handler verwendet.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Liste der IP-Adressen anzeigen',
    'ui__client/ipaddress/properties_readonly__title' => 'Liste der IP-Adressen anzeigen',
    'ui__client/ipaddress/properties_readonly__description' => 'Liste der für diesen Benutzer verfügbaren IP-Adressen anzeigen.',
    'ui__server/certificate__short-title' => 'SSL/TLS-Zertifikate',
    'ui__server/certificate__title' => 'SSL/TLS-Zertifikate',
    'ui__server/certificate__description' => 'SSL/TLS-Zertifikate anzeigen und verwalten',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'MIME-Typen entfernen',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'MIME-Typen entfernen',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Bestätigung der Entfernung von MIME-Typen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'MIME-Typ hinzufügen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'MIME-Typ hinzufügen',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registrieren Sie einen MIME-Typ.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'IP-Adressen entfernen',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Wählen Sie die IP-Adressen aus, die Sie aus dem IP-Pool von Kunde %1 entfernen möchten',

    // mail

    'ui__client/ipaddress__short-title' => 'IP-Adresse',
    'ui__client/ipaddress__title' => 'IP-Adresse',
    'ui__client/ipaddress__description' => 'Informationen über die IP-Adresse anzeigen.',
    'ui__server/ip-address__short-title' => 'IP-Adresse',
    'ui__server/ip-address__title' => 'IP-Adresse',
    'ui__server/ip-address__description' => 'Informationen über die IP-Adresse anzeigen.',
    'ui__client/domain/hosting/setup__short-title' => 'Webhosting-Einstellungen',
    'ui__client/domain/hosting/setup__title' => 'Webhosting-Einstellungen',
    'ui__client/domain/hosting/setup__description' => 'Webhosting-Einstellungen für Website %1 einrichten.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME-Typ', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Eigenschaften des MIME-Typs', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Zeigen Sie die Eigenschaften des MIME-Typs an.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Fehlerdokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Fehlerdokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Eigenschaften des Fehlerdokuments.', // PFW

    // tooltips

    'b_get_password_cancel' => 'Kehren Sie zur letzten Seite zurück, ohne die E-Mail zu versenden.',
    'b_get_password_send' => 'Klicken Sie auf OK, um die Nachricht zur Passwortwiederherstellung an die im System registrierte E-Mail-Adresse zu senden.',



    'b_personaltrafficlist_search' => 'Geben Sie ein Suchmuster ein und klicken Sie hier, um nach Domains zu suchen.',
    'b_personaltrafficlist_show_all' => 'Alle Domains anzeigen.',

    'b_back' => 'Zur vorherigen Seite',
    'b_next' => 'Zur nächsten Seite.',

    'b_dnsnstemplatelist_remove' => 'Ausgewählte Nameserver löschen.',
    'b_dnsnstemplatelist_search' => 'Geben Sie ein Suchmuster ein und klicken Sie hier, um nach Nameservern zu suchen.',
    'b_dnsnstemplatelist_show_all' => 'Alle Nameserver anzeigen.',

    'l_dnsnstemplatelist_ns' => 'DNS-Template-Einträge nach Nameserver sortieren.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Sichere Links zu Dateien und Ordnern erstellen',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Öffentliche Dateien freischalten',
    'cu__serverfilesharing_fsPublicFolder' => 'Speicherort für öffentliche Dateien',
    'cu__serverfilesharing_fsPublicUrl' => 'URL für Benutzerzugriff auf öffentliche Dateien',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Passwortschutz für öffentliche Dateien aktivieren',
    'cu__serverfilesharing_fsPartnerFolder' => 'Speicherort für die passwortgeschützten Dateien',
    'cu__serverfilesharing_fsPartnersLogin' => 'Benutzername für Dateizugriff',
    'cu__serverfilesharing_fsPartnersPassword' => 'Passwort für Dateizugriff',
    'cu__serverfilesharing_fsDomain' => 'Root-URL des Web-Ordners. Domainname',
    'cu__serverfilesharing_fsPrefix' => 'Root-URL des Web-Ordners. Präfix',
    'cu__serverfilesharing_commandUpdate' => 'Filesharing-Einstellungen aktualisieren',
    'cu__serverfilesharing_commandInfo' => 'Aktuelle Filesharing-Einstellungen anzeigen',
    'subscription_rename_is_forbidden' => 'Die Umbenennung von Abonnements wird durch die serverweite Richtlinie untersagt.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Geplante Aufgaben auf Server verwalten',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Wählen Sie den Systembenutzer aus, dessen geplante Aufgaben Sie verwalten möchten.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Geplante Aufgabe %1',
    'ui__server/crontab/task__description' => 'Zeigen Sie die Eigenschaften der geplanten Aufgabe %1 an.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Systembenutzer',
    'ui__server/crontab_unknown__title' => 'Systembenutzer',
    'ui__server/crontab_unknown__description' => 'Systembenutzer, die Besitzer von geplanten Aufgaben sein können.',


    'ui__server/crontab__none-available' => 'Sie haben keine Systembenutzerkonten.',
    'ui__server/crontab_readonly-unknown__description' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Geplante Aufgaben',
    'ui__server/crontab_readonly-unknown__title' => 'Geplante Aufgaben anzeigen',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab_readonly__description' => 'Geplante Aufgaben von %1 anzeigen.',
    'ui__server/crontab_readonly__short-title' => 'Geplante Aufgabe von %1',
    'ui__server/crontab_readonly__title' => 'Geplante Aufgaben von %1 anzeigen',
    'ui__server/crontab_unknown__wizard-title' => 'Geplante Aufgaben verwalten.',

    'ui__server/crontab/properties__description' => 'Geplante Aufgaben von %1 bearbeiten.',

    'ui__server/crontab/properties__short-title' => 'Einstellungen',
    'ui__server/crontab/properties__title' => 'Geplante Aufgaben von %1 bearbeiten',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Einstellungen',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Geplante Aufgaben anzeigen',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab/properties_readonly__description' => 'Geplante Aufgaben von %1 anzeigen.',
    'ui__server/crontab/properties_readonly__short-title' => 'Einstellungen',
    'ui__server/crontab/properties_readonly__title' => 'Geplante Aufgaben von %1 anzeigen',
    'ui__server/crontab/properties_unknown__description' => 'Geplante Aufgaben bearbeiten.',
    'ui__server/crontab/properties_unknown__short-title' => 'Eigenschaften',
    'ui__server/crontab/properties_unknown__title' => 'Geplante Aufgaben bearbeiten',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Geplante Aufgaben bearbeiten.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Wählen Sie den Systembenutzer aus, dessen Aufgaben Sie anzeigen möchten.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Wählen Sie den Systembenutzer aus, dessen Aufgaben Sie ändern möchten.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klicken Sie auf "Fertigstellen", um den Assistenten zu beenden.',

    'ui__server/crontab/task__none-available' => 'Sie haben keine geplanten Aufgaben.',
    'ui__server/crontab/task__none-available__2' => 'Für Systembenutzer %1 sind keine geplanten Aufgaben vorhanden.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Geplante Aufgaben.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Aufgaben',
    'ui__server/crontab/task_readonly-unknown__title' => 'Geplante Aufgaben',

    'ui__server/crontab/task/delete__description' => 'Geplante Aufgabe %1 entfernen',

    'ui__server/crontab/task/delete__short-title' => 'Entfernen',
    'ui__server/crontab/task/delete__title' => 'Geplante Aufgabe %1 entfernen',
    'ui__server/crontab/task/delete_multi__description' => 'Geplante Aufgaben entfernen.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Entfernen',
    'ui__server/crontab/task/delete_multi__title' => 'Geplante Aufgaben entfernen',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Geplante Aufgaben entfernen.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Wählen Sie den Systembenutzer aus, dessen Aufgaben Sie entfernen möchten.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Wählen Sie die Aufgaben aus, die Sie entfernen möchten.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Bestätigen Sie das Entfernen der Aufgabe, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__server/crontab/task/delete_unknown__description' => 'Geplante Aufgabe entfernen.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Entfernen',
    'ui__server/crontab/task/delete_unknown__title' => 'Geplante Aufgabe entfernen',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Geplante Aufgabe entfernen.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Wählen Sie den Systembenutzer aus, dessen Aufgabe Sie entfernen möchten.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Wählen Sie die Aufgabe aus, die Sie entfernen möchten.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Bestätigen Sie das Entfernen der Aufgabe, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',

    'ui__server/crontab/task/properties__description' => 'Geplante Aufgaben bearbeiten.',

    'ui__server/crontab/task/properties__short-title' => 'Aufgabe %1 bearbeiten',
    'ui__server/crontab/task/properties__title' => 'Geplante Aufgaben bearbeiten',
    'ui__server/crontab/task/properties_new__description' => 'Erstellen Sie geplante Aufgaben für %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Aufgabe hinzufügen',
    'ui__server/crontab/task/properties_new__title' => 'Geplante Aufgaben für %1 erstellen',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Erstellen eine geplante Aufgabe.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Wählen Sie den Systembenutzer aus, für den Sie die geplante Aufgabe erstellen möchten.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Eigenschaften',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Geplante Aufgaben anzeigen',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab/task/properties_readonly__description' => 'Geplante Aufgaben anzeigen.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Aufgabe %1 anzeigen',
    'ui__server/crontab/task/properties_readonly__title' => 'Geplante Aufgaben anzeigen',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Erstellen Sie geplante Aufgaben.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Aufgabe hinzufügen',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Geplante Aufgaben erstellen',
    'ui__server/crontab/task/properties_unknown__description' => 'Geplante Aufgaben bearbeiten.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Eigenschaften',
    'ui__server/crontab/task/properties_unknown__title' => 'Geplante Aufgaben bearbeiten',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Geplante Aufgaben bearbeiten.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Wählen Sie den Systembenutzer aus, dessen Aufgaben Sie anzeigen möchten.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Wählen Sie den Systembenutzer aus, dessen Aufgaben Sie ändern möchten.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Wählen Sie die geplante Aufgabe aus.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Wählen Sie die geplante Aufgabe aus, die Sie ändern möchten.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klicken Sie auf "Fertigstellen", um den Assistenten zu beenden.',

    'ui__server/crontab/task/toggle_disable__description' => 'Geplante Aufgabe %1 deaktivieren.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Deaktivieren',
    'ui__server/crontab/task/toggle_disable__title' => 'Geplante Aufgabe %1 deaktivieren',
    'ui__server/crontab/task/toggle_enable__description' => 'Geplante Aufgabe %1 aktivieren.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Aktivieren',
    'ui__server/crontab/task/toggle_enable__title' => 'Geplante Aufgabe %1 aktivieren',
    'ui__server/crontab/task/toggle_unknown__description' => 'Geplante Aufgaben aktivieren bzw. deaktivieren.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Aktivieren bzw. deaktivieren',
    'ui__server/crontab/task/toggle_unknown__title' => 'Geplante Aufgaben aktivieren bzw. deaktivieren',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Geplante Aufgaben aktivieren bzw. deaktivieren',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Wählen Sie das Systembenutzerkonto aus, dessen Aufgaben Sie aktivieren bzw. deaktivieren möchten.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Wählen Sie die Aufgabe aus, die Sie aktivieren bzw. deaktivieren möchten.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Kundenkonten', // not used on HP?
    'ui__client_unknown__title' => 'Kundenkonten', // not used on HP?
    'ui__client_unknown__description' => 'Verwalten Sie die Kundenkonten.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Domain sperren', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Domain sperren', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Sperren Sie eine Domain.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Domain aktivieren.', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Domain aktivieren.', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Eine Domain aktivieren.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "FTP-Konten unter der Domain %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-Konten",
    'ftp__user_name' => "FTP-Kontoname",
    'ftp__user_home' => "Basisverzeichnis",
    'ftp__invalid_path' => "Ungültiger Pfad angegeben",
    'i_ftp_ses_sub_user' => 'FTP-Konto-Sitzung.',
    '__new_passwd' => "Neues %1-Passwort",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Es kann kein Webserver auf dem Host <%%host%%> konfiguriert werden',
    'apacheConfigurationFailedMessageBody' => "Die Webserver-Konfigurationsdatei kann nicht auf dem Host <%%host%%> erzeugt werden. Es liegen folgende Fehler vor:\n\n%%error%%\n\nBitte lösen Sie die Probleme in den Konfigurations-Templates des Webservers und erstellen Sie die Datei erneut.",

    'apacheConfigurationMessageAdminTitle' => 'Generieren der Webserver-Konfiguration fehlgeschlagen',
    'apacheConfigurationMessageClientTitle' => 'Warnung',

    'apacheConfigurationFailedAdminHomeMessage' => 'Aufgrund von Fehlern in den Konfigurations-Templates konnte keine neue Konfigurationsdatei erstellt werden. Die detaillierte Fehlermeldung wurde Ihnen per E-Mail zugesendet. Beheben Sie die Fehler und klicken Sie %1, um die Konfiguration neu zu generieren.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'hier', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Aufgrund von Fehlern in den Konfigurations-Templates konnte keine Konfiguration für die Domain %1 erstellt werden. Die detaillierte Fehlermeldung wurde Ihnen per E-Mail zugesendet. Beheben Sie die Fehler und klicken Sie %2, um die Konfiguration neu zu generieren.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'hier', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Webserver-Konfiguration für Domain %1 ist eventuell inkonsistent. Bitte kontaktieren Sie den Serveradministrator, um das Problem zu lösen.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Aufgrund von Fehlern in den Konfigurations-Templates konnte keine Konfiguration für einige Domains erstellt werden. Die detaillierte Fehlermeldung wurde Ihnen per E-Mail zugesendet. Beheben Sie die Fehler und klicken Sie %1, um die Konfiguration neu zu generieren.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'hier', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Die Webserver-Konfiguration ist eventuell inkonsistent für einige Ihrer Domains. Bitte wenden Sie sich an den Server-Administrator, um das Problem zu lösen.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Benutzerdefinierte Fehlerdokumente",
    'dom_pref__webusers_script' => "Webbenutzer dürfen Skripte nutzen",
    '__seoRedirect' => 'Bevorzugte Domain konfigurieren als',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Ohne',

    '__sites' => 'Domains',
    'domain_plan__perm_denied_manage_phosting' => 'Sie haben nicht die Berechtigung, Hosting-Einstellungen zu verwalten.',
    '__owned_by_client' => 'gehört dem Kunden',
    'ui__client/permissions_readonly__description' => "Lassen Sie sich die Liste der Aktionen anzeigen, die der Kunde %1 in Plesk ausführen kann.",
    'backup__restore__object_client_template' => 'Kunden-Template',
    '__template_name' => 'Name des Service-Pakets',
    'template__not_exists' => 'Solche ein Service-Paket existiert nicht',
    'template__exists' => 'Es existiert bereits ein Paket mit dem Namen "%1".',
    'clientOwnerChanger__ip_not_in_pool' => 'Die angegebene IP-Adresse ist nicht im Reseller-Pool vorhanden.',

    //// Change owner of subscription
    'chown__select_title' => "Wählen Sie einen neuen Abonnenten",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Wählen Sie für die ausgewählten Kundenkonten einen neuen Besitzer aus und klicken Sie auf Weiter >>.',
    'domains__client_info' => "%1 Abonnements, %2 aktive Abonnements, %3 Speicherplatz belegt, %4 Traffic belegt",
    '__possible_owners' => 'Mögliche neue Besitzer von Abonnements',

    'clients_list__filter_owner__filter_title' => 'Anbieter',
    'clients_list__filter_owner_any' => 'Alle Benutzer',
    'clients_list__filter_owner_my' => 'Nur meine Abonnenten',
    'clients_list__filter_owner_name__filter_title' => 'Name des Providers',

    '__owner' => "Anbieter",
    'l_clientslist_owner' => 'Benutzerkonten nach Provider sortieren.',
    'l_clientslist_date' => 'Benutzerkonten nach Erstellungsdatum sortieren.',
    'l_clientslist_name' => 'Benutzerkonten nach Name sortieren.',
    'l_clientslist_domains' => 'Benutzerkonten nach Domains sortieren.',
    'l_clientslist_cname' => 'Benutzerkonten nach Firmenname sortieren.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Ausgewählte Abonnements neu zuweisen',
    'chown__check_title' => 'Abonnent ändern',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klicken Sie auf Fertigstellen, um die Neuzuweisung zu beenden. Anschließend werden die ausgewählten Abonnements einem neuen Besitzer zugewiesen. Der Provider wird auf den Provider des Besitzers geändert und die Abonnements werden von ihren Service-Paketen getrennt und als 'Benutzerdefiniert' gespeichert.",

    'chown__error_check' => 'Bei dem Versuch, einige der Abonnements einem neuen Besitzer zu zuweisen, sind Probleme aufgetreten.',
    'domain_chown_subscription_will_be_anonymous' => "Abonnements werden aus den aktuellen Service-Paketen entfernt und werden zu 'Benutzerdefiniert'.",
    'chown__error_domains_exclude' => "Bei dem Versuch, einige der Abonnements einem neuen Besitzer zu zuweisen, sind Probleme aufgetreten. Die betreffenden Abonnements sind hervorgehoben",
    'chown__ip_not_in_client_pool' => "Die diesem Abonnement zugewiesene IP-Adresse wurde nicht dem IP-Pool des neuen Domainbesitzers hinzugefügt:",
    'chown__already_owned_by_client' => "Dieses Abonnement gehört diesem Benutzer bereits.",

    '__redirect_hint' => 'Sie werden in 15 Sekunden an die neue Adresse weitergeleitet... Wenn Sie nicht automatisch weitergeleitet werden, aktivieren Sie bitte Javascript oder klicken Sie auf den Hyperlink %%link%%.',

    'backup__restore__object_maillist' => 'Mailingliste',
    'backup__restore__object_site' => 'Website',
    'backup__restore__object_user' => 'Benutzer',
    'backup__restore__object_role' => 'Rolle',

    'limit__name_max_site' => 'Websites',

    'iis_pool__unable_rename_client' => "IIS-Anwendungspool konnte nicht umbenannt: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonymous FTP-Service wird nur für die Hauptdomain eines Abonnements unterstützt.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Der Anonymous FTP-Dienst wird nur für die Hauptdomain eines Abonnements unterstützt.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/Monat',
    '__tb_month' => 'TB/Monat',

    '__customers' => 'Kunden',
    '__customer_name' => 'Kundenname',
    '__customer_total' => 'Kunden insgesamt',
    '__site' => 'Website',
    '__def_site' => 'Standard-Site',
    '__subscription_name' => 'Abonnement-Name',
    '__subscription_name_powerUser' => 'Abonnementname',

    'limit__units_max_traffic_suffix' => '/Monat',

    'dom_pref__discard' => "Abweisen",

    'mail__pattern_already_exists' => 'Das Muster "%1" ist bereits in der Blackliste vorhanden.',

    '__not_supported' => 'Nicht unterstützt',

    'plesk_key__sitebuilder' => 'Mit Presence Builder veröffentlichte Websites',
    'limit__name_max_site_builder' => 'Mit Presence Builder veröffentlichte Websites',
    'plesk_key__wpb-multi-language-sites-support' => 'Unterstützung mehrsprachiger Websites in Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Datenübertragungsstatistik für <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Datenübertragungsstatistik für <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Datenübertragung nach Services",

    'login_up__access_denied_no_subscriptions' => "Zugriff verweigert. Für Ihr Konto sind keine Abonnements verfügbar.",

    'interval__day' => '%1 Tag(e)',
    'interval__hour' => '%1 Stunde(n)',
    'interval__minute' => '%1 Minute(n)',
    'interval__second' => '%1 Sekunde(n)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Sie versuchen, einen Lizenzschlüssel zu verwenden, der für eine andere Version von Plesk erstellt wurde. Wenden Sie sich an Ihren Plesk Vertriebsmitarbeiter, um einen passenden Lizenzschlüssel zu erhalten.',
    //Standalone or virtualization
    'virtualization_any' => "Physischer Server oder jede beliebige Virtualisierungslösung",
    'virtualization_pvc' => "Container von Virtuozzo",
    'virtualization_vmware' => "VMware",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo-Server",
    'plesk_key__virtualization' => "Gültig für die folgenden Umgebungen:",
    'plesk_key__virtualization_only_key' => 'Der Lizenzschlüssel ist nur zur Verwendung mit Plesk innerhalb einer virtuellen Umgebung von %1 gedacht.',
    'plesk_key__virtualizations_only_key' => 'Der Lizenzschlüssel ist nur zur Verwendung für Plesk innerhalb der folgenden virtuellen Umgebungen gedacht: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Das Verwenden von benutzerdefinierten Sprachpaketen ist verboten.',
    'plesk_key__allowed-locales' => 'Verfügbare Sprachen',
    'plesk_key__allowed-locales-any' => 'Beliebige Sprache',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin-Verzeichnis befindet sich in',
    '_cgi_bin_mode_webspace' => 'Stammverzeichnis des Abonnements',
    '_cgi_bin_mode_www_root' => 'Dokumentstamm dieser Domain',

    /// Custom buttons
    'custom_button__sort_key' => 'Priorität',
    'custom_button__place' => 'Ort',
    'custom_button__place_navigation' => 'Für alle zugänglich',
    'custom_button__place_admin' => 'Administrator-Startseite',
    'custom_button__place_admin-settings' => 'Seite "Tools & Einstellungen" des Administrators',
    'custom_button__place_reseller' => "Startseite des Resellers",
    'custom_button__place_reseller-settings' => 'Seite "Tools & Dienstprogramme" für Reseller',
    'custom_button__place_client' => 'Startseite des Kunden',
    'custom_button__place_domain' => "Seite \"Websites & Domains\" des Abonnements",
    'custom_button__place_domain_powerUser' => "Seite \"Websites & Domains\" des Abonnements",
    'custom_button__place_domain-properties' => 'Website-Tools',
    'custom_button__private' => 'Nur mir anzeigen',
    'custom_button__image' => 'Hintergrundbild',
    'custom_button__conhelp' => "Tooltip-Text",
    'custom_button__edit' => "Einstellungen eines Links zu einem weiteren Service",
    'custom_button__include_client_cname' => "Firmennamen des Kunden einfügen",
    'custom_button__include_client_email' => "E-Mail-Adresse des Kunden einfügen",
    'custom_button__include_client_id' => "Kunden-ID einfügen",
    'custom_button__include_client_pname' => "Name des Kundenkontakts einfügen",
    'custom_button__include_domain_id' => "Abonnement-ID, Domain-ID und Domain-Alias-ID einschließen",
    'custom_button__include_domain_id_powerUser' => "Abonnement-ID, Domain-ID und Domain-Alias-ID einschließen",

    'custom_button__include_domain_name' => "Primären Domainnamen einfügen",
    'custom_button__include_ftp_user' => "FTP-Benutzername einfügen",
    'custom_button__include_ftp_pass' => "FTP-Passwort einschließen",
    'custom_button__internal_open' => "URL in Plesk öffnen",
    'custom_button__text' => "Schaltflächenbeschriftung",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Die Datei ist keine Imagedatei.',
    'custom_button__big_image' => 'Die Datei darf nicht größer als 100 KB sein.',
    'custom_button__failed_copy_image' => 'Die Datei konnte nicht kopiert werden: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Ein Nicht-Power-User-Backup kann nicht im Power-User-Modus wiederhergestellt werden.',
    '__unknown_network_interface' => 'Unbekannte Netzwerkschnittstelle',

    'init_conf__ip_address' => 'IP-Adresse',

    //Confirmation page
    'bt_confirm' => 'Bestätigen',
    'b_confirm' => 'Bestätigen Sie die Inhaberschaft Ihrer Sites.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Die Einstellungen des Dedizierten IIS-Anwendungspools werden gemäß den serverweiten Sicherheitsregeln (Konfiguration zur Website-Isolierung) festgelegt.',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Die Einstellungen des Dedizierten IIS-Anwendungspools werden gemäß den serverweiten Leistungseinstellungen festgelegt.',

    '__current' => 'Aktuell',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Die Benutzereigenschaften wurden aktualisiert.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Sie haben fast alle Domains verwendet, die mit Ihrer Plesk Lizenz zur Verfügung gestellt wird (90% oder sogar mehr).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Sie haben fast alle Domains verwendet.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Sie haben fast alle Presence Builder Websites verwendet, die mit Ihrer Plesk Lizenz zur Verfügung gestellt werden (90% oder sogar mehr).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Sie haben fast alle Presence Builder Websites verwendet.',
    'promo__button_hide' => 'Ausblenden',
    'promo__button_next' => 'Weiter >>',
    'promo__button_prev' => '<< Zurück',
    'promo__button_license' => 'Lizenz upgraden',

    'promo__google_integration_title' => 'Integration mit Google Services',
    'promo__google_integration' => 'Konfigurieren Sie die Integration mit den Google Services, wie z.B. AdSense, Google Apps, Webmaster-Tools.',
    'promo__google_integration_button' => 'Konfigurieren',

    'promo__button_learn_more' => 'Mehr erfahren',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Mithilfe der benutzerdefinierten Designvorlagen können Sie die Erscheinung der Oberfläche und die Branding-Einstellungen anpassen. Für Anleitungen zum Anpassen der Plesk Designvorlagen lesen Sie bitte das %1.',
    'panel_branding__description_link' => 'das folgende Dokument',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Dateien extrahieren',
    'b_filemanager__extract' => 'Dateien aus den ausgewählten Archiven in das aktuelle Verzeichnis extrahieren. Bitte beachten Sie, dass die Dateinamen, die vor dem Entpacken Sonderzeichen enthielten, eventuell nicht richtig angezeigt werden.',
    'filemanager_error_extracting_files' => 'Beim Extrahieren der Archivdateien ist ein Fehler aufgetreten: %1',
    'filemanager_no_archive_files_specified' => 'Geben Sie die Archive an, die Sie extrahieren wollen.',
    'filemanager_not_zip_archive_specified' => '%1 kann nicht extrahiert werden, da es kein ZIP-Archiv ist.',
    'filemanager_files_successfully_extracted' => 'Die Archivdateien wurden extrahiert.',
    'filemanager_error_file_download' => 'Das Herunterladen der Datei ist fehlgeschlagen: %1',
    'filemanager__user_poolgrp' => 'Anwendungspool-Gruppe',

    'loading' => 'Lade...',
    'bt_create_archive' => 'In Archiv packen',
    'filemanager__pack' => "Pfad zum Archiv: %1",
    'filemanager__archive_name' => 'Name der Archivdatei',
    'filemanager__empty_filename' => 'Bitte geben Sie einen Namen für die Archivdatei ein.',
    'filemanager_archive_created' => 'Das Archiv wurde erfolgreich erstellt.',
    'filemanager_error_creating_archive' => 'Das Archiv kann nicht erstellt werden: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Dieser Eintrag wird in Konflikt mit dem AAAA-Eintrag für die Zone stehen.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Der FTP-Server unterstützt keine IPv6-Adressen.)",
    'cmd_dns__glue_dns_record_conflict' => 'Dieser Eintrag wird in Konflikt stehen mit dem Verbindungseintrag für die Zone "%1".',
    '__ftp_ipv6_not_supported' => "(Der FTP-Server unterstützt keine IPv6-Adressen.)",
    '__ipv6_not_supported' => 'IPv6 wird nicht unterstützt.',
    'mail__ipv6_not_supported' => 'IPv6 wird nicht von dem Mailserver unterstützt.',
    'mail__relay_while_list_ipv6_not_supported' => 'Die IPv6-Relay-Whiteliste wird nicht von dem Mailserver unterstützt.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Der Wert der Maske muss ein Vielfaches von 16 sein.',
    'mail__ip_or_mask_is_invalid' => 'Die IP-Adresse oder Maske ist ungültig.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Die Weiterleitung an IPv6 IP-Adressen wird nicht unterstützt.',
    'sa__invalid_trusted_networks' => 'Vertrauenswürdige Netzwerke wurden falsch angegeben%1',
    'dns_add__enter_ipv6_address' => "IPv6-Adresse",
    'license_trial_days_left' => 'Ihr Plesk wird mit einer Testlizenz verwendet, die in %1 Tagen abläuft.',
    'excl_ipv6_num' => 'Dedizierte IPv6-Adresse',
    '__ip_mask' => "Subnetzmaske",
    '__ipv4_addr' => 'IPv4-Adresse',
    '__ipv6_addr' => 'IPv6-Adresse',
    'template__num_excl_ipv6s' => 'Dem Reseller dedizierte IPv6-Adressen zuweisen',
    'anonftp__exclusive_ipv4_required' => 'Für das Einrichten und Verwenden des Anonymous FTP-Services ist eine dedizierte IPv4-Adresse erforderlich.',
    'anonftp__ipv4_already_used' => 'Sie können keinen Anonymous FTP-Service für diesen Site einrichten, da er bereits auf einer anderen Domain auf derselben IPv4-Adresse konfiguriert wurde.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'Protokoll anzeigen',

    'chown__ip_address_warn' => 'Bevor Sie das Abonnement einem neuen Benutzer zuweisen, müssen Sie eine neue IP-Adresse für das Abonnement auswählen.',
    'chown__no_ip_address' => 'Ohne',
    'chown__no_ipv4_address' => 'Keine IPv4-Adresse',
    'chown__no_ipv6_address' => 'Keine IPv6-Adresse',
    'chown__domain_exclude_already_owned_by_client' => 'Das Abonnement %1 gehört bereits zu diesem Benutzer.',
    'chown__error_ip_absent_in_ip_pool' => 'Die IP-Adresse %1 ist nicht in dem IP-Pool des Zielbenutzers vorhanden.',
    'chown__error_ip_not_exist' => 'Die IP-Adresse mit der ID \'%1\' existiert nicht.',
    'chown__error_domain_ip_not_selected' => 'Es muss mindestens eine Website für die Domain %1 ausgewählt werden. Werte überprüfen, die für das IP-Mapping ausgewählt wurden.',

    '__new_passwd_single' => "Passwort",
    '__confirm_passwd_single' => "Passwort bestätigen",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6-Adresse oder -Maske ist ungültig: Die IP-Adresse sollte eine gültige Unicastadresse sein.',

    '__subscriptions' => 'Abonnements',

    '__owned_by_reseller' => 'gehört dem Reseller',
    '__owned_by_provider' => 'gehört dem Provider',

    'service_plan__anonymous' => 'Benutzerdefiniert',
    'subscription_not_locked__change_limits_warning' => 'Dieses Abonnement ist nicht gesperrt: Die Ressourcenverbrauchsgrenzen werden während der Synchronisierung mit dem Service-Paket geändert.',
    'subscription_not_locked__change_permissions_warning' => 'Dieses Abonnement ist nicht gesperrt: Die Berechtigungen werden während der Synchronisierung mit dem Service-Paket geändert.',

    'subscription__conflict_resolution_policy' => 'Konfliktlösungsrichtlinie',
    'subscription__conflict_resolution_policy_lock' => "Abonnement sperren",

    'backup__list__backup_warnings' => 'Warnungen',
    'backup__list__backup_info' => 'Information',
    'backup__restore__object_reseller_template' => 'Reseller-Template',
    'backup__restore__object_domain_template' => 'Domain-Template',

    'ui__client/permissions_readonly__title' => 'Berechtigungen',
    'ui__client/permissions_readonly__short-title' => 'Berechtigungen',

    'subscription__unable_lock_anonymous' => 'Dieses Abonnement ist nicht mit einem Service-Paket verknüpft und kann daher nicht entsperrt werden.',
    'subscription__unable_sync_anonymous' => 'Dieses Abonnement ist nicht mit einem Service-Paket verknüpft und kann daher nicht synchronisiert werden.',
    'subscription__unable_sync_locked' => 'Dieses Abonnement ist gesperrt und kann daher nicht synchronisiert werden.',
    'subscription__locked' => 'Das Abonnement ist gesperrt.',
    'component_name__urlrewrite' => "URL neu schreiben",
    '__quantity' => 'Menge',
    'hst__www_root_dir_absent' =>  'Warnung: Das als Dokumentstamm angegebene Verzeichnis ist nicht vorhanden.',
    'object_creation__domain_is_not_a_webspace' => 'Dieses Objekt kann nur in einem Abonnement erstellt werden.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Das Abonnement beinhaltet Websites, daher können Sie den Hosting-Typ nicht ändern oder löschen.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Fehler: IP-Adresse konnte nicht aktualisiert werden. Add-on-Domains können keiner IP-Adresse zugewiesen werden, die nicht zur Hauptdomain des Abonnements gehört.',
    'domain_plan__unable_change' => 'Service-Paket kann nicht geändert werden: %1.',
    'domain_plan__different_hosting_type' => 'Der aktuelle Hosting-Typ unterscheidet sich von dem Typ, der in dem Service-Paket angegeben wurde.',
    'domain_plan__addon_text' => 'Add-on-Paket',
    'domain_plan__addon_description' => 'Ein Add-on-Paket wird verwendet, um ein Hosting-Paket zu verwenden.',
    'asp_net__managed_runtime_version' => 'ASP.NET Managed Runtime Version',
    'plan__can_not_change_hosting_type' => 'Beim Bearbeiten eines Pakets kann der Hosting-Typ nicht geändert werden.',
    'plan__apply_problems' => 'Das Paket wurde nicht angewendet, da Probleme mit der folgenden Funktion vorliegen: %1',
    'plan_save__subscription_update_problem' => 'Paketänderungen können nicht für %1 übernommen werden.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Das Abonnement ist zeitweise gesperrt bis der Backup- oder Wiederherstellungsprozess abgeschlossen wurde. Bitte versuchen Sie es später erneut.",
    '__login_incorrect_plain_shadow_password' => 'Sie haben ein falsches Passwort für das Konto des Administrators eingegeben. Bitte verwenden Sie die Zugangsdaten des Systemadministrators (root) oder fragen Sie das richtige Passwort an. Weitere Infos zum Anfordern des Passworts finden Sie in der Datei /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Sie können keine IP-Adresse senden, die nicht Ihnen gehört',

    'dns__dns_zone_not_synchronized' => 'Die DNS-Zone wurde modifiziert. Wenn Sie Änderungen am DNS-Template auf diese Zone anwenden möchten, klicken Sie entweder auf die Schaltfläche \'Änderungen des DNS-Templates anwenden\' auf dieser Seite oder markieren Sie die Option \' Änderungen für alle Zonen übernehmen\' unter Server-Administrations-Panel > Tools & Einstellungen > DNS-Template-Einstellungen > Änderungen des DNS-Templates anwenden.',
    'dns__dns_zone_synchronize_link' => 'Klicken Sie auf',
    'dns__dns_zone_synchronize_done' => 'Die DNS-Zone wurde erfolgreich synchronisiert.',

    'dns__dns_zone_template_error' => 'Bei der Synchronisierung der DNS-Zonen mit dem DNS-Zonen-Template sind Probleme aufgetreten.%1',

    'dns__soa_rname_type_owner' => 'E-Mail-Adresse des Website-Betreibers',
    'dns__soa_rname_type_domain' => 'E-Mail-Adresse der Domain',
    'dns__soa_rname_type_external' => 'Externe E-Mail-Adresse',
    'dns__soa_rname_enforce_email' => 'Ändern der RNAME-E-Mail-Adresse auf Domainbasis verbieten',
    'dns__soa_rname_label' => 'E-Mail (RNAME)',
    'dns__soa_rname_hint' => 'E-Mail-Adresse des Verantwortlichen für die DNS-Zone der Domain. Vom DNS-Server als Antwort auf SOA-Abfragen zurückgegeben.',

    'dns__dns_zone_soa_sync_title' => 'SOA-Einstellungen für alle vorhandenen Domains überschreiben',
    'dns__dns_zone_soa_sync_legend' => 'Bestätigung erforderlich',
    'dns__dns_zone_soa_sync_text' => 'Sollen die SOA-Einträge aller gehosteten Domains aktualisiert werden, indem die Änderungen aus dem SOA-Template übernommen werden?',

    'cu_db__repair_mysql_dbus' => "Reparieren Sie MariaDB/MySQL-Benutzerpasswörter. Dieser Vorgang ist erforderlich, wenn Sie ein Upgrade von früheren Plesk Versionen auf Plesk 11 durchgeführt haben.",

    'cu_scheduled_backup_comment' => 'Geplantes Backup',
    'cu_scheduled_backup_error' => 'Während des Backupvorgangs ist ein Fehler aufgetreten: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Beim geplanten Backup ist ein Fehler aufgetreten.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk Einstiegspunkt: %2\n\nBeim geplanten Backup sind die folgenden Fehler aufgetreten:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Mehrmals täglich ausgeführtes Backup',
    'cu_scheduled_backup_daily' => 'Tägliches Backup',
    'cu_scheduled_backup_weekly' => 'Wöchentliches Backup',
    'cu_scheduled_backup_monthly' => 'Monatliches Backup',
    'cu_scheduled_backup_comment_backup_all' => '%1. Gesamte Konfiguration und gesamter Inhalt.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Gesamte Konfiguration und gesamter Inhalt außer E-Mail-Nachrichten.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Nur Konfiguration und E-Mail-Nachrichten.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Gesamte Konfiguration und gesamter Inhalt außer Benutzerdatenbanken.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Gesamte Konfiguration und gesamter Inhalt außer Benutzerdateien.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Nur Konfiguration und Benutzerdatenbanken.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Nur Konfiguration und Benutzerdateien',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Domainkonfiguration.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Das Speichern von geplanten Backups in einem Remote-Cloud-Speicher ist eine Premium-Funktion. Wenden Sie sich an Ihren Hosting-Provider, um die Funktion freischalten zu lassen.',

    'i_backup_invalid_file' => 'Dies ist kein gültiges Backup. Es können keine Daten von dieser Datei wiederhergestellt werden. Klicken Sie auf den Backup-Namen, um Einzelheiten zu erfahren.',

    'ui__server/migration/download-agent__short-title' => 'Migrations- & Transfer-Assistenten herunterladen',
    'ui__server/migration/download-agent__title' => 'Migrations- & Transfer-Assistenten herunterladen',
    'ui__server/migration/download-agent__description' => 'Laden Sie die aktuellste Version des Migrations- & Transfer-Assistenten von der Plesk Website herunter.',

    'filemanager_resulting_archive_exists' => 'Die Datei %1 ist im Zielverzeichnis bereits vorhanden.',

    'agent_unable_to_connect' => 'Verbindung zum Agenten auf \'%2\' kann nicht hergestellt werden. Bitte vergewissern Sie sich, dass der Agent installiert ist und ausgeführt wird und dass keine Verbindungsprobleme beim Host \'%2\' vorliegen.',
    'agent_test_connection_failed' => 'Verbindung zum Agenten auf \'%2\' fehlgeschlagen.',

    'agent_unable_to_resolve_host' => 'Entfernter Host \'%1\' kann nicht lokalisiert werden. Bitte vergewissern Sie sich, dass keine Verbindungsprobleme beim Host vorliegen.',
    'agent_unknown_curl_error' => 'Während der Verbindung zum Agenten auf \'%2\' ist der Fehler \'%1\' aufgetreten.',
    'agent_unexpected_htp_code' => 'Auf die HTTP-Anfrage an den Agenten auf \'%2\' wurde der unerwartete HTTP-Code \'%1\' empfangen.',
    'agent_unable_to_auth' => 'Die Authentifizierung am Host \'%1\' kann nicht durchgeführt werden. Eine Anleitung zur Lösung des Problems finden Sie unter http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Während der Ausführung des Befehls auf dem entfernten Host \'%1\' ist ein interner Serverfehler aufgetreten.',
    'agent_response_is_empty' => 'Auf die HTTP-Anfrage an den Agenten auf \'%1\' wurde eine leere Antwort empfangen.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Der Migrations- & Transfer-Assistent kann im lokalen Cache nicht gefunden werden. Bitte öffnen Sie den Migrations- & Transfer-Manager erneut, um das Problem zu beheben.',

    '__hosting_webdeploy' => "Veröffentlichen mit Web Deploy",
    'cu_domain__webdeploy' => "Veröffentlichen mit Web Deploy (Standard: %1)",
    'cu_dom_tpl__webdeploy' => "Veröffentlichen mit Web Deploy (Standard: %1)",
    'cu_subdomain__webdeploy' => "Veröffentlichen mit Web Deploy (Standard: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy ist nicht auf dem Server installiert",
    'webdeploy__forced_by_site_isolation' => "Die Einstellungen für das Publizieren mit Web Deploy können nicht geändert werden: Sie haben nicht die Berechtigung, die serverweiten Sicherheitsrichtlinien zu überschreiben. Bitte wenden Sie sich an Ihren Provider, um Einzelheiten zu erfahren.",



    'backup__restore_options__admin__server_configuration_license' => 'Lizenzschlüssel',
    'migration_start_migrate_server_license' => 'Lizenzschlüssel übertragen',

    'defaultcomponents__delegation_rule_not_exist' => '(die erforderliche Delegationsregel \'appPoolPipeline, appPoolNetFx\' existiert nicht)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Das Backup wurde vom Administrator erstellt.',
    'i_backup_created_by_reseller' => 'Das Backup wurde von einem Reseller erstellt.',
    'i_backup_created_by_client' => 'Das Backup wurde von einem Kunden erstellt.',

    'migration__object_exists_on_target_host' => '(existiert bereits auf dem Ziel-Host)',

    '__customers_total' => 'Gesamt nach Kunden',
    '__resellers_total' => 'Gesamt nach Reseller',
    '__reseller_total' => 'Reseller gesamt',


    'cu_cl_pref__manage_website_maintenance' => 'Zugriff auf erweiterte Operationen: Website kopieren',
    'cu_cl_pref__manage_protected_dirs' => 'Verwaltung passwortgeschützter Verzeichnisse',
    'cu_cl_pref__manage_mail_settings' => 'Änderung von E-Mail-Einstellungen',


    'cu__command_update_php_settings' => 'Aktualisiert die PHP-Einstellungen.',
    'cu__php_settings_option' => 'Stellt den Pfad zu der Datei mit PHP-Einstellungen ein.',

    'cu__additional_php_settings_option' => 'Richtet den Pfad zu der Datei mit zusätzlichen PHP-Anweisungen ein.',
    'cu__command_show_php_settings' => 'Zeigt die aktuellen PHP-Einstellungen an.',
    'cu__general_settings' => 'Allgemeine Einstellungen:',
    'cu__performance_settings' => 'Leistungseinstellungen:',
    'cu__php_fpm_settings' => 'PHP-FPM-Einstellungen:',
    'cu__additional_directives' => 'Zusätzliche Anweisungen:',

    'php_settings_permission_required' => 'Verwaltung der allgemeinen PHP-Einstellungen',
    'php_settings_performance_permission_required' => 'Verwaltung der Hosting-Performance-Einstellungen',
    'php_settings_customized' => 'PHP-Einstellungen wurden angepasst.',
    'php_settings_synchronized_with_plan' => 'Die PHP-Einstellungen müssen mit dem Plan synchronisiert werden.',
    'phosting__unknown_shell_type' => 'Nicht verfügbare Shell',

    'login_up__access_denied_subscription_deleted' => 'Zugriff verweigert: Ihr Abonnement wurde entfernt.',

    'role_restricted_to_subscription' => '(Mit dem Abonnement übertragen: %1)',

    'filemanager__extract' => "Dateien extrahieren nach: %1",

    'cu__license_command_check_installed_license' => 'Überprüfen Sie die Gültigkeit des installierten Lizenzschlüssels (wird 0 ausgegeben, ist der Schlüssel gültig und bei 1 ist er ungültig)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Erweitern Sie die Plesk Funktionalität, sodass Sie den Server via Mobilgeräten (BlackBerry, iPhone und Android) überwachen und steuern können.",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Erhalten Sie überall und jederzeit die wichtigsten Informationen über Plesk Server von einem Mobilgerät aus (BlackBerry, iPhone und Android).',
    'promo__mobile_button' => 'Mehr erfahren',

    'ui__server/migration/video__short-title' => 'Video-Tutorials',
    'ui__server/migration/video__title' => 'Video-Tutorials ansehen',
    'ui__server/migration/video__description' => 'Sehen Sie sich die Video-Tutorials an.',

    'subDomainNameHint' => 'Geben Sie * als einen Subdomainnamen ein, um eine Wildcard Subdomain zu erstellen. Besucher der Site werden auf diese Subdomain weitergeleitet, ungeachtet des Subdomainnamens, den sie in den Browser eingeben.',
    'subdomains__wildcard_name_invalid' => "Der Subdomainname ist ungültig. Für Wildcard-Subdomainnamen können Sie nur alphanumerische Zeichen, Bindestriche (-) und Sternchen (*) verwenden.",
    'subdomains__name_invalid' => "Der Subdomainname ist ungültig. Für Subdomainnamen können Sie nur alphanumerische Zeichen und Bindestriche (-) verwenden.",

    'domain__wildcard_no_www_prefix' => 'Es ist nicht möglich, das Präfix www für Wildcard Subdomains zu verwenden.',

    '__service_title__milter' => "Plesk Postfix Milter",
    '__service_description__milter' => "Plesk Postfix Mailfilter",
    '__milter' => "Postfix Milter",
    'restart__milter' => "Plesk Milter (%1)",
    'restart__pop3' => "Courier-POP3-Server",
    'restart__pop3s' => "Courier-POP3-Server mit Unterstützung von SSL/TLS",
    'restart__imap' => "Courier-IMAP-Server",
    'restart__imaps' => "Courier-IMAP-Server mit Unterstützung von SSL/TLS",
    'restart__authdaemon' => "Courier-IMAP-Authentifizierungsprogramm",
    'restart__imap-pop3' => "Dovecot IMAP- und POP3-Server",


    'addon_packages_not_supported' => 'Add-ons für im APS-Format verpackte Web-Apps werden nicht unterstützt.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Der Domain kann nicht automatisch eine IP-Adresse zugewiesen werden. Bitte geben Sie eine IP-Adresse mithilfe der Option -ip an.',

    'plesk_key__mb_accounts' => 'Benutzerkonten (Reseller und Kunden) in Customer and Business Manager',

    'actionlog__subdomain_dns' => 'DNS-Zone der Subdomain',
    'actionlog__site_subdomain_dns' => 'DNS-Zone einer Subdomain unter einer zusätzlichen Domain',

    // PfW only
    'actionlog__event_site_create' => 'Domain erstellt',
    'actionlog__event_site_delete' => 'Domain gelöscht',
    'actionlog__event_site_update' => 'Domain aktualisiert',

    'actionlog__event_site_status_update' => 'Domain-Status aktualisiert',
    'actionlog__event_site_dns_update' => 'Domain-DNS-Zone aktualisiert',
    'actionlog__event_site_guid_update' => 'Domain-GUID aktualisiert',

    'actionlog__event_site_subdomain_create' => 'Subdomain erstellt',
    'actionlog__event_site_subdomain_delete' => 'Subdomain gelöscht',
    'actionlog__event_site_subdomain_update' => 'Subdomain aktualisiert',

    'actionlog__event_site_alias_create' => 'Domain-Alias erstellt',
    'actionlog__event_site_alias_delete' => 'Domain-Alias gelöscht',
    'actionlog__event_site_alias_update' => 'Domain-Alias aktualisiert',

    'actionlog__event_site_alias_dns_update' => 'DNS-Zone eines Domain-Alias aktualisiert',
    'actionlog__event_subdomain_dns_update' => 'DNS-Zone einer Subdomain unter der Standarddomain aktualisiert',
    'actionlog__event_site_subdomain_dns_update' => 'DNS-Zone einer Subdomain aktualisiert',
    // End of PfW only

    'win_policy__bad_password' => 'Überprüfung fehlgeschlagen. Das Passwort ist ungültig.',
    'win_policy__password_too_short' => 'Überprüfung fehlgeschlagen. Das Passwort entspricht nicht den Anforderungen der Passwortrichtlinien, da es zu kurz ist.',
    'win_policy__password_too_long' => 'Überprüfung fehlgeschlagen. Das Passwort entspricht nicht den Anforderungen der Passwortrichtlinien, da es zu lang ist.',
    'win_policy__password_not_complex_enough' => 'Die Validierung ist fehlgeschlagen. Ihr Passwort ist nicht komplex genug und entspricht nicht den Anforderungen der Passwortrichtlinien. Starke Passwörter müssen mindestens folgende Anforderungen erfüllen: acht Zeichen, ein Groß- oder Kleinbuchstabe, drei Ziffern und ein Sonderzeichen (!, @, #, $, %, ^, &, *, ?, _, ~) oder eine Ziffer und zwei Sonderzeichen.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Fehler beim Aktualisieren der Produktlizenz.',


    'filemanager__error_path_is_not_allowed' => 'Pfad ist nicht zugelassen',
    'filemanager__error_path_is_invalid' => 'Pfad ist ungültig',
    'filemanager__error_path_not_found' => 'Pfad nicht gefunden',
    'filemanager__error_path_already_exists' => 'Pfad existiert bereits',
    'filemanager__error_access_is_denied' => 'Zugriff verweigert',
    'filemanager__error_directory_not_empty' => 'Ordner ist nicht leer',
    'filemanager__error_sharing_violation' => 'Verletzung der gemeinsamen Nutzungsrechte',
    'filemanager__error_not_same_device' => 'Zielpfad befindet sich nicht auf demselben Gerät',
    'filemanager__binary_data_access' => 'Diese Datei ist möglicherweise eine Binärdatei. Möchten Sie sie öffnen?',
    'filemanager__unable_to_resolve_realpath' => "Datei %1 wurde nicht am angegebenen Speicherort gefunden",
    'filemanager__access_to_realpath_denied' => "Zugriff auf realpath verweigert: %1 zu %2.",
    'bt_exit' => 'Beenden',

    'filemanager__chdir_error__' => "Verzeichnis kann nicht zu %1 geändert werden: %2",
    'filemanager__chmod_dir' => "Berechtigungen für Verzeichnis %1 ändern",
    'filemanager__chmod_error__' => "Berechtigungen für Datei %1 können nicht geändert werden: %2",
    'filemanager__chmod_file' => "Berechtigungen für Datei %1 ändern",
    'filemanager__copy_error__' => "%1 kann nicht zu %2 kopiert werden: %3",
    'filemanager__copy_move' => "Kopiere (verschiebe) Dateien von %1",
    'filemanager__count_size__' => 'Größe der Auswahl: %1',
    'filemanager__count_size_error__' => 'Größe für %1 kann nicht ermittelt werden: %2',
    'filemanager__create_dir_error__' => "Verzeichnis %1 kann nicht erstellt werden: %2",
    'filemanager__dir_not_exists' => "Verzeichnis %1 existiert nicht.",
    'filemanager__dirname' => "Verzeichnisname",
    'filemanager__filename' => "Dateiname",
    'filemanager__is_no_such' => "Datei oder Verzeichnis mit dem Namen %1 nicht vorhanden",
    'filemanager__empty_selection' => "Keine Datei(en) ausgewählt.",
    'filemanager__move_error__' => "%1 kann nicht nach %2 verschoben werden: %3",
    'filemanager__not_allowed' => "Sie sind zum Ändern der Berechtigungen für diese Datei nicht berechtigt.",
    'filemanager__remove' => "Dateien aus %1 entfernen",
    'filemanager__remove_error__' => "Datei %1 kann nicht entfernt werden: %2",
    'filemanager__rename_dir' => "Verzeichnis %1 umbenennen",
    'filemanager__rename_error__' => "%1 kann nicht in %2 umbenannt werden: %3",
    'filemanager__rename_file' => "Datei %1 umbenennen",
    'filemanager__set_win_permissions_dir' => "Berechtigungen für %1-Verzeichnis konfigurieren",
    'filemanager__set_win_permissions_file' => "Berechtigungen für %1-Datei konfigurieren",
    'filemanager__touch_confirm' => "Möchten Sie den Zeitstempel der ausgewählten Dateien wirklich ändern?",
    'filemanager__upload_error__' => "Hochladen von %1 auf %2 fehlgeschlagen: %3",
    'filemanager__upload_file' => "Datei hochladen",
    'filemanager__upload_file_src' => "Pfad zu Datei",
    'filemanager__max_image_size_exceeded' => 'Bild kann nicht angezeigt werden. Das Bild darf nicht größer als %2 Byte sein',

    '__fastcgi_unix_support' => 'FastCGI-Unterstützung',

    'dns__subdomain_dns_zone_parent' => 'Die DNS-Einträge dieser Subdomain werden in der übergeordneten DNS-Zone gespeichert. Sie können die übergeordnete Zone %1 modifizieren oder eine separate Zone für die Subdomain erstellen.',
    'dns__subdomain_dns_zone_parent_link' => 'hier',
    'dns__no_dns_zone' => 'Der Domain ist keine DNS-Zone zugewiesen. Wenn Sie die DNS-Zone für Ihre Domain verwalten wollen, müssen Sie auf die Schaltfläche \'Standardeinstellungen wiederherstellen\' klicken.',
    'dns__unable_turn_on_subdomain_zone' => 'Die Zone der Subdomain kann nicht aktiviert werden, da es in der Zone ihrer übergeordneten Domain einen CNAME-Eintrag für die Subdomain gibt.',

    '__hosting_write_modify' => 'Zusätzliche Schreib-/ Änderungsrechte',

    'aspdotnet__group_framework_version' => "Framework-Version",

    'bt_restore_default' => "Auf Standardeinstellungen zurücksetzen",
    'b_autoinstaller' => 'Aktualisieren Sie Plesk oder dessen Komponenten.',
    'b_autoinstaller_configure' => 'Einstellungen aktualisieren.',
    'b_autoinstaller_install' => 'Ausgewählte Komponenten installieren.',

    '__iis_app_pool__use_dedicated' => 'Dedizierter IIS-Anwendungspool',
    '__iis_app_pool__use_dedicated_addons' => 'Dedizierter IIS-Anwendungspool für jede Website',
    '__iis_app_pool__enable_32bit_app_on_win64' => '32-Bit-Anwendungen aktivieren',
    '__iis_app_pool__load_user_profile' => 'Laden des Benutzerprofils',
    'bt_iis_app_pool' => "IIS-Anwendungspool",

    'performance__cpu_usage' => 'Maximale CPU-Auslastung (%)',
    'performance__cpu_usage_action' => 'Aktion für Grenze',
    'performance__cpu_usage_interval' => 'Limitintervall (Minuten)',
    'performance__cpu_usage_action_not_supported' => 'Die angegebene Aktion wird vom Webserver nicht unterstützt.',

    'performance__idle_timeout_action_not_supported' => 'Die angegebene Aktion bei Leerlauftimeout wird nicht vom Webserver unterstützt.',
    'performance__max_worker_processes' => 'Die maximale Anzahl an Arbeitsprozessen',
    'performance__idle_timeout' => 'Leerlauftimeout (Minuten)',
    'performance__idle_timeout_action' => 'Aktion bei Leerlauftimeout',
    'performance__recycling_by_time' => 'Wiederverwendung in regelmäßigen Zeitabständen (Minuten)',
    'performance__recycling_by_requests' => 'Wiederverwendung, wenn die maximale Anzahl an Anfragen erreicht ist',
    'performance__recycling_by_virtual_memory' => 'Wiederverwendung, wenn die maximale Menge an virtuellem Speicher genutzt wird',
    'performance__recycling_by_private_memory' => 'Wiederverwendung, wenn die maximale Menge an Arbeitsspeicher genutzt wird',
    'performance__managed_pipeline_mode' => 'Verwalteter Pipelinemodus',
    'performance__managed_pipeline_mode_not_supported' => 'Der angegebene Modus wird vom Webserver nicht unterstützt.',

    'iis_app_pool' => 'Verwaltung des IIS-Anwendungspools.',
    'b_iis_app_pool' => 'IIS-Anwendungspool verwalten.',
    'iis_app_pool_cl_dom' => 'Verwaltung des IIS-Anwendungspools.',

    'l_webdirerrordocslist_code' => 'Fehlerdokumente nach Fehlernummer sortieren.',
    'l_webdirerrordocslist_name' => 'Fehlerdokumente nach Beschreibung sortieren.',
    'l_webdirerrordocslist_type' => 'Fehlerdokumente nach Typ sortieren.',
    'l_webdirerrordocslist_location' => 'Fehlerdokumente nach Ort sortieren.',

    'b_webdirerrordocslist_search' => 'Geben Sie ein Suchmuster ein und klicken Sie hier, um nach Fehlerdokumenten zu suchen.',
    'b_webdirerrordocslist_remove' => 'Ausgewählte Fehlerdokumente löschen.',
    'b_webdirerrordocslist_show_all' => 'Alle Fehlerdokumente anzeigen.',

    'l_webdirmimetypeslist_name' => 'MIME-Typen nach Erweiterung sortieren.',
    'l_webdirmimetypeslist_content' => 'MIME-Typen nach Inhalt sortieren.',

    'b_webdirmimetypeslist_remove' => 'Ausgewählte MIME-Typen löschen.',
    'b_webdirmimetypeslist_search' => 'Geben Sie ein Suchmuster ein und klicken Sie hier, um nach MIME-Typen zu suchen.',
    'b_webdirmimetypeslist_show_all' => 'Alle MIME-Typen anzeigen.',

    'b_webdir_preferences' => "Einstellungen für virtuelle Verzeichnisse.",
    'b_webdir_permissions' => "Berechtigungen für virtuelle Verzeichnisse.",
    'b_webdir_permissions_disabled' => "Die Verzeichnis-Freigabenverwaltung ist nicht verfügbar.",
    'b_to_webdirs' => 'Zurück zur Verwaltung von Verzeichnissen.',
    'b_to_webdir_mime_types' => 'Zurück zur Verwaltung der MIME-Typen.',
    'b_to_webdir_error_docs' => 'Zurück zur Verwaltung von Fehlerdokumenten.',
    'b_to_webdir_protection' => 'Zurück zur Verwaltung von geschützten virtuellen Verzeichnissen.',

    'webdirs__title' => 'Virtuelles Verzeichnis %1',
    'webdirs__preferences_title' => 'Einstellungen für virtuelle Verzeichnisse.',
    'webdirs__tabs_general' => 'Allgemein',
    'webdirs__tabs_mime_types' => 'MIME-Typen',
    'webdirs__tabs_error_docs' => 'Fehlerdokumente',

    'webdirs__tabs_permissions' => 'Berechtigungen',
    'webdir__remove_vdirs' => 'Die folgenden virtuelle Verzeichnisse werden entfernt:',
    'webdir__remove_mime_types' => 'Folgende MIME-Typen werden gelöscht:',
    'webdir__mime_types_title' => 'MIME-Typen',
    'webdir__protection_disable_confirm' => 'Möchten Sie den Verzeichnisschutz wirklich entfernen?',
    'webdir__protect_title' => 'Benutzer der geschützten URL',
    'webdirs__permissions_title' => 'Berechtigungen für virtuelle Verzeichnisse.',
    'error_doc__list_code' => 'Fehler',
    'error_doc__list_code_description' => 'Beschreibung',
    'error_doc__list_type' => 'Typ',
    'error_doc__list_location' => 'Ort',
    'error_doc__code' => 'Fehler',
    'error_doc__type' => 'Typ',
    'error_doc__type_file' => 'Datei',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Ort',
    'error_doc__legend' => 'Fehlerdokument',
    'error_doc__edit_title' => 'Fehlerdokument bearbeiten',
    'error_doc_erorr_invalid_url_location' => 'Die URL ist ungültig. Bitte geben Sie die korrekte URL an.',
    'error_doc_erorr_invalid_file_location' => 'Der Dateipfad ist ungültig. Bitte geben Sie den korrekten Pfad an.',
    'error_doc__type_default' => 'Standard',

    'webdirs__tabs_protection' => 'Schutz',
    'pb_webdirs' => 'Virtuelle Verzeichnisse',

    'webdirs_mime_types_remove_title' => 'Folgende MIME-Typen werden entfernt:',
    'webdirs_preferences_title' => 'Einstellungen für virtuelle Verzeichnisse.',
    'webdirs_permissions_title' => 'Besondere Berechtigungen für Dateien und Ordner',
    'webdi_protection_disable_confirm' => 'Möchten Sie den Schutz für das virtuelle Verzeichnis wirklich entfernen? Dadurch werden alle Benutzer des geschützten Verzeichnisses sowie die Einstellungen für den Verzeichnisschutz entfernt.',
    'bt_protect' => 'Schützen',
    'bt_unprotect' => 'Schutz entfernen',
    'bt_show_additional_users' => 'Mehr Benutzer anzeigen',
    'bt_hide_additional_users' => 'Weniger Benutzer anzeigen',
    'error_doc__list_title' => 'Fehlerdokumente',
    'error_doc__list_header' => 'Fehlerdokumente',
    'error_doc__code_400' => 'Ungültige Anfrage',
    'error_doc__code_401' => 'Nicht autorisiert',
    'error_doc__code_401.1' => 'Nicht autorisiert - Login fehlgeschlagen',
    'error_doc__code_401.2' => 'Nicht autorisiert - Login aufgrund der Serverkonfiguration fehlgeschlagen',
    'error_doc__code_401.3' => 'Nicht autorisiert - Nicht autorisiert aufgrund ACL auf der Ressource',
    'error_doc__code_401.4' => 'Nicht autorisiert - Autorisation durch Filter fehlgeschlagen',
    'error_doc__code_401.5' => 'Nicht autorisiert - Autorisierung durch ISAPI/CGI app fehlgeschlagen',
    'error_doc__code_401.7' => 'Nicht autorisiert - Abgelehnt aufgrund der URL-Autorisierungsregeln',
    'error_doc__code_403' => 'Verboten',
    'error_doc__code_403.1' => 'Verboten - Ausführungszugriff verweigert',
    'error_doc__code_403.2' => 'Verboten - Lesezugriff verweigert',
    'error_doc__code_403.3' => 'Verboten - Schreibzugriff verweigert',
    'error_doc__code_403.4' => 'Verboten - SSL erforderlich',
    'error_doc__code_403.5' => 'Verboten - SSL 128 erforderlich',
    'error_doc__code_403.6' => 'Verboten - IP-Adresse zurückgewiesen',
    'error_doc__code_403.7' => 'Verboten - Clientzertifikat erforderlich',
    'error_doc__code_403.8' => 'Verboten - Websitezugriff verweigert',
    'error_doc__code_403.9' => 'Verboten - Zu viele Benutzer',
    'error_doc__code_403.10' => 'Verboten - Ungültige Konfiguration',
    'error_doc__code_403.11' => 'Verboten - Passwortänderung',
    'error_doc__code_403.12' => 'Verboten - Mapper hat den Zugriff verweigert',
    'error_doc__code_403.13' => 'Verboten - Clientzertifikat widerrufen',
    'error_doc__code_403.14' => 'Verboten - Auflistung in Verzeichnis verweigert',
    'error_doc__code_403.15' => 'Verboten - Clientzugriffslizenzen überschritten',
    'error_doc__code_403.16' => 'Verboten - Clientzertifikat nicht als vertrauenswürdig eingestuft oder beschädigt',
    'error_doc__code_403.17' => 'Verboten - Clientzertifikat ist abgelaufen oder noch nicht gültig',
    'error_doc__code_403.18' => 'Verboten - Kann Anfrage von diesem Anwendungspool nicht ausführen',
    'error_doc__code_403.19' => 'Verboten - Zugriff auf CGI verweigert',
    'error_doc__code_403.20' => 'Verboten - Passwort-Login fehlgeschlagen',
    'error_doc__code_404' => 'Nicht gefunden',
    'error_doc__code_404.2' => 'Nicht gefunden - Aufgrund der Sperrregeln verweigert',
    'error_doc__code_404.3' => 'Nicht gefunden - Verweigert aufgrund der MIMEMAP-Regeln',
    'error_doc__code_405' => 'Methode nicht erlaubt',
    'error_doc__code_406' => 'Nicht annehmbar',
    'error_doc__code_407' => 'Proxy-Authentifizierung nötig',
    'error_doc__code_412' => 'Vorbedingung nicht erfüllt',
    'error_doc__code_414' => 'Anfrage-URI ist zu lang',
    'error_doc__code_415' => 'Nicht unterstützter Medientyp',
    'error_doc__code_500' => 'Interner Serverfehler',
    'error_doc__code_500.12' => 'Interner Serverfehler - Anwendung wird neu gestartet',
    'error_doc__code_500.13' => 'Interner Serverfehler - Server überlastet',
    'error_doc__code_500.15' => 'Interner Serverfehler - Direkte Anfragen für GLOBAL.ASA verboten',
    'error_doc__code_500.16' => 'Interner Serverfehler - UNC-Zugriffsfehler',
    'error_doc__code_500.17' => 'Interner Serverfehler - URL-Autorisierungsspeicher nicht gefunden',
    'error_doc__code_500.18' => 'Interner Serverfehler - URL-Autorisierungsspeicher kann nicht geöffnet werden',
    'error_doc__code_500.19' => 'Interner Serverfehler - Ungültige Dateimetadaten',
    'error_doc__code_500.100' => 'Interner Serverfehler - ASP-Fehler',
    'error_doc__code_501' => 'Nicht implementiert',
    'error_doc__code_502' => 'Ungültiges Gateway',
    'error_doc__code_503' => 'Service momentan nicht verfügbar',

    'mimetype__extension' => 'Erweiterung',
    'mimetype__content' => 'Inhalt',
    'mimetypeslist__title' => 'MIME-Typen',
    'mimetypes__title' => 'MIME-Typen',
    'mimetypes__select_to_remove' => 'Wählen Sie die MIME-Typen aus, die Sie entfernen möchten.',
    'mimetypes__select_for_remove' => "Wählen Sie die MIME-Typen, die sie entfernen wollen.",
    'mimetypes_remove__title' => 'MIME-Typen entfernen',
    'mimetype__legend' => 'MIME-Typ',
    'mimetype_edit__title' => 'MIME-Typ bearbeiten',
    'mimetype_edit__already_exists' => 'Der MIME-Typ ist bereits für diese Erweiterung definiert.',
    'mimetype_edit__not_exists' => 'Der MIME-Typ existiert nicht.',
    'mimetype__content_type_other' => 'Benutzerdefiniert...',

    'b_webdir_protection_enable' => 'URL erstellen, die dem passwortgeschützten Verzeichnis entspricht.',
    'b_webdir_protection_disable' => 'URL erstellen, die dem für alle zugänglichen Verzeichnis entspricht.',
    'b_webdir_protection_disabled' => 'Schutz für virtuelle Verzeichnisse ist deaktiviert.',

    'b_pd_usr_create' => 'Klicken Sie hier, um den Benutzer der geschützten URL zu erstellen.',
    'php__group_php_version' => "PHP-Version",

    'virtualdir__name' => 'Name',
    'virtualdir__path' => 'Pfad',
    'virtualdir__read' => 'Leseberechtigung',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Schreibberechtigung',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Zugriff auf Skriptcode',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Verzeichnissuche',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Ausführungsberechtigungen',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Besuche protokollieren',
    'virtualdir__app_create' => 'Anwendung erstellen',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Aktiviert die anonyme Authentifizierung.',
    'virtualdir__auth_windows' => 'Aktiviert die Windows Authentifizierung.',
    'virtualdir__auth_not_enabled' => 'Die anonyme oder die Windows Authentifizierung muss aktiviert werden.',
    'virtualdir__require_ssl' => 'SSL/TLS erforderlich',
    'virtualdir__enable_default_doc' => 'Standarddokumente verwenden',
    'virtualdir__default_doc' => 'Suchreihenfolge für Standarddokumente',
    'virtualdir__enable_parent_paths' => 'Übergeordnete Pfade dürfen verwendet werden',
    'virtualdir__execute_in_mta' => 'Anwendung darf im MTA-Modus (Multi-Threaded Apartment) ausgeführt werden',
    'virtualdir_create__title' => 'Virtuelles Verzeichnis in %1 erstellen',
    'virtualdir_edit__title' => 'Eigenschaften des virtuellen Verzeichnisses in %1',
    'virtualdir_edit__legend' => 'Virtuelles Verzeichnis',
    'virtualdir_edit__application_legend' => 'Anwendungseinstellungen',
    'virtualdir_edit__security_legend' => 'Verzeichnissicherheit',
    'virtualdir_edit__documents_legend' => 'Dokumente',
    'virtualdir_edit__list_legend' => 'Verschachtelte virtuelle Verzeichnisse',
    'virtualdir_error__path_not_in__' => 'Ungültiger Pfad angegeben',
    'virtualdir_error__already_exists' => 'Ein Verzeichnis mit diesem Namen ist bereits vorhanden.',
    'virtualdir_root' => 'Virtuelle Verzeichnisse',
    'virtualdir_root__title' => 'Virtuelle Verzeichnisse',
    'virtualdir_root__list_legend' => 'Virtuelle Verzeichnisse',
    'virtualdir_se__none' => 'Ohne',
    'virtualdir_se__script' => 'Nur Skripte',
    'virtualdir_se__script_execute' => 'Skripte und ausführbare Dateien',
    'virtualdirs__title' => 'Virtuelle Verzeichnisse',
    'virtualdirs__path_not_exists' => 'Ungültiger Pfad.',
    'virtualdirs__select_for_remove' => "Wählen Sie die virtuellen Verzeichnisse, die entfernt werden sollen.",
    'virtualdirs_remove__title' => 'Virtuelle Verzeichnisse entfernen',
    'virtualdirs_phys_dir_exist' => 'Ein physisches Verzeichnis mit diesem Namen ist bereits vorhanden. Wenn Sie fortfahren, wird es nicht mehr zugänglich sein. Möchten Sie fortfahren?',
    'virtualdir_auto_create_dir' => "Physisches Verzeichnis mit dem gleichen Namen wie das virtuelle Verzeichnis erstellen",

    'asp_max_default_text' => 'Durch übergeordnetes Verzeichnis definiert (%1 KB)',
    'asp_max_default_text_site' => 'Durch IIS definiert (%1 KB)',
    'asp_max_buffer_text' =>'Maximale Größe des ASP-Puffers (KB)',
    'asp_max_body_text' => 'Maximale Größe des Entity-Body einer ASP-Anfrage (KB)',
    'asp_buffers_legend' =>'ASP-Einstellungen',

    'asp_debug_default_text' =>'Durch übergeordnetes Verzeichnis definiert',
    'asp_debug_default_text_site' =>'Durch IIS definiert',
    'asp_client_debug_text' =>'ASP-Skript-Debugging auf Clientseite aktivieren',
    'asp_server_debug_text' =>'ASP-Skript-Debugging auf Serverseite aktivieren',

    'webdirs__physical_path_not_exist' => "Der angegebene Pfad existiert nicht.",

    'permissions__group_or_user_name' => 'Gruppen- oder Benutzernamen',
    'permissions__FullControl' => 'Volle Kontrolle',
    'permissions__Modify' => 'Bearbeiten',
    'permissions__ReadAndExecute' => 'Lesen und ausführen',
    'permissions__ListFolderContents' => 'Ordnerinhalt auflisten',
    'permissions__Read' => 'Lesen',
    'permissions__Write' => 'Schreiben',
    'permissions__ReadControl' => 'Lesen-Kontrolle',
    'permissions__WriteControl' => 'Schreiben-Kontrolle',
    'permissions__ExecuteControl' => 'Ausführungssteuerung',
    'permissions__TraverseFolderOrExecuteFile' => 'Ordnerübergreifend / Datei ausführen',
    'permissions__ListFolderOrRead' => 'Ordner auflisten / Daten lesen',
    'permissions__CreateFilesOrWrite' => 'Dateien erstellen / Daten schreiben',
    'permissions__CreateFoldersOrAppend' => 'Ordner erstellen / Daten hinzufügen',
    'permissions__DeleteSubfoldersandFiles' => 'Unterordner und Dateien löschen',
    'permissions__Delete' => 'Löschen',
    'permissions__ChangePermissions' => 'Berechtigungen ändern',
    'permissions__TakeOwnership' => 'Besitz übernehmen',
    'permissions__inherited_from' => 'Geerbt von',
    'permissions__not_inherited' => '<nicht vererbt>',
    'permissions__apply_to' => 'Anwenden auf',
    'permissions__apply_onto' => 'Anwenden auf:',
    'permissions__apply_onto1' => 'Nur dieser Ordner',
    'permissions__apply_onto2' => 'Nur Unterordner',
    'permissions__apply_onto3' => 'Dieser Ordner und Unterordner',
    'permissions__apply_onto4' => 'Nur Dateien',
    'permissions__apply_onto5' => 'Dieser Ordner und Dateien',
    'permissions__apply_onto6' => 'Nur Unterordner und Dateien',
    'permissions__apply_onto7' => 'Dieser Ordner, Unterordner und Dateien',

    'filemanager__not_allowed_dir' => "Sie dürfen die Berechtigungen für diesen Ordner nicht ändern.",

    'filemanager__allow' => "Zulassen",
    'filemanager__deny' => "Verweigern",
    'filemanager__user_domusr' => 'Website-Administrator',
    'filemanager__user_webusr' => 'Webbenutzer',
    'filemanager__user_admins' => 'Administratoren',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'ASP.NET-Benutzer',
    'filemanager__user_poolusr' => 'Anwendungspool-Benutzer',
    'filemanager__user_sysaccount' => 'Zusätzlicher Systembenutzer',

    'bt_permissions_advanced' => 'Erweitert',
    'b_permissions_advanced' => 'Klicken Sie hier, um spezielle Berechtigungen anzuzeigen und einzurichten.',

    'hotlink-protection_invalid_friend_domain' => 'Ungültiger Name für zugelassene Domain.',
    'hotlink-protection_duplicate_friend_domain' => 'Duplizierter Name für zugelassene Domain.',
    'hotlink-protection_invalid_extensions' => 'Dateierweiterungen enthalten unzulässige Zeichen.',

    'i_domain_alias_status_on' => 'Domain-Alias ist aktiviert.',
    'i_domain_alias_status_off' => 'Domain-Alias ist deaktiviert.',
    'i_domain_alias_status_with_parent' => 'Domain-Alias ist deaktiviert, da die Domain deaktiviert ist.',
    'i_domain_alias_turn_off' => 'Zum Deaktivieren hier klicken.',
    'i_domain_alias_turn_on' => 'Zum Aktivieren hier klicken.',
    'i_domain_alias_mail_on' => 'E-Mail-Service ist für diesen Domain-Alias aktiviert.',
    'i_domain_alias_mail_off' => 'E-Mail-Service ist für diesen Domain-Alias deaktiviert.',
    'i_domain_alias_mail_with_parent' => 'E-Mail-Service ist deaktiviert, da der Domain-Alias ausgeschaltet ist.',
    'i_domain_alias_web_on' => 'Webservice ist für diesen Domain-Alias aktiviert.',
    'i_domain_alias_web_off' => 'Webservice ist für diesen Domain-Alias deaktiviert.',
    'i_domain_alias_web_with_parent' => 'Webservice ist deaktiviert, da der Domain-Alias ausgeschaltet ist.',
    'i_domain_alias_dns_on' => 'Der DNS-Aliasing-Dienst für diesen Domain-Alias ist aktiviert.',
    'i_domain_alias_dns_off' => 'Der DNS-Aliasing-Dienst für diesen Domain-Alias ist deaktiviert.',
    'i_domain_alias_dns_with_parent' => 'Die DNS-Synchronisierung mit der übergeordneten Domain ist deaktiviert, da der Domain-Alias deaktiviert ist.',
    'i_domain_alias_seoRedirect_on' => 'Die Weiterleitung mit dem HTTP-Code 301 ist für diesen Domain-Alias aktiviert.',
    'i_domain_alias_seoRedirect_off' => 'Die Weiterleitung mit dem HTTP-Code 301 ist für diesen Domain-Alias deaktiviert.',
    'i_domain_alias_seoRedirect_with_parent' => 'Die Weiterleitung mit dem HTTP-Code 301 ist deaktiviert, weil der Domain-Alias deaktiviert ist.',

    'domain_alias__control_title' => 'Domain-Alias %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Service-Name',
    'domain_alias__control_details_title' => 'Details',

    'domain_alias__invalid_values' => 'Der angegebene Domainname ist ungültig. Domainnamen können Buchstaben, Ziffern und Bindestriche enthalten. Jeder Teil des Domainnamens (zwischen Punkten) darf höchstens 63 Zeichen enthalten.',
    'domain_alias__domain_already_exists' => "Ungültiger Name des Domain-Alias %1. Die Domain %1 existiert bereits.",
    'domain_alias__www_prefix_domain_already_exists' => "Ungültiger Name des Domain-Alias www.%1. Dieser Alias wurde bereits für die Domain %1 erstellt.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Ungültiger Name der Domain-Alias webmail.%1. Dieser Alias wurde bereits für die Domain %1 erstellt.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Ungültiger Name des Domain-Alias lists.%1. Dieser Alias wurde bereits für die Domain %1 erstellt.',
    'domain_alias__dns_record_already_exists' => 'Domain-Alias %1 kann nicht eingerichtet werden, da bereits ein DNS-Eintrag existiert, der auf Host %1 verweist.',
    'domain_alias__domain_alias_already_exists' => "Ein Domain-Alias mit diesem Namen ist bereits vorhanden.",
    'domain_aliases__mail_server_not_support_aliases' => 'Der Mail-Server unterstützt das Domain-Alias-Feature nicht. Domain-Aliase funktionieren möglicherweise nicht einwandfrei.',
    'domain_alias__restrict_domain_creation' => 'Der angegebene Name für einen Domain-Alias ist aufgrund der serverweiten Richtlinie nicht zulässig. Kontaktieren Sie Ihren Hosting-Provider, falls der Domain-Alias-Name zu Ihnen gehört.',
    'domain_alias__restrict_creation_with_www' => 'Bitte geben Sie einen Domainnamen ohne das Präfix \'www\' ein. Das www-Präfix für die Domain wird automatisch zur Webserver-Konfiguration hinzugefügt.',
    'domain_unable_to_set_name' => 'Falscher Name %1.',

    'domain_alias__domain_service_dns_disabled' => 'Diese Domain wird von einem anderen DNS-Server bedient.',
    'domain_alias__domain_service_dns_enabled_master' => 'Dieser DNS-Server wird als primärer Nameserver für diese DNS-Zone eingesetzt.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Dieser DNS-Server wird als sekundärer Nameserver für diese DNS-Zone eingesetzt.',
    'domain_alias__domain_service_mail_enabled' => 'E-Mail-Service für die Domain ist aktiviert.',
    'domain_alias__domain_service_mail_disabled' => 'E-Mail-Service für die Domain ist deaktiviert.',
    'domain_alias__domain_service_mail_mx' => '%1 wird bereits von dem Mailserver verwendet.',

    'domain_alias__service_seoRedirect_hint' => 'Wenn Besucher die URL des Alias öffnen, werden sie zur URL der primären Domain weitergeleitet. Plesk verwendet die suchmaschinenfreundliche HTTP-301-Weiterleitung, d. h. das Suchmaschinen-Ranking wird nicht zwischen den URLs aufgeteilt.',

    'bt_task_run_now' => 'Jetzt ausführen',
    'ftp__read_perm' => "Leseberechtigung",
    'ftp__write_perm' => "Schreibberechtigung",

    'filemanager__upload_backup_file_hint' => 'Hier können Sie Backupdateien zum Plesk Speicher hochladen. Die maximale Größe einer Datei ist auf zwei Gigabyte begrenzt.',

    '__default_for_mssql' => 'Standard für MS SQL',

    '__login_does_not_pass_validation' => "Der Nutzername ist ungültig. Stellen Sie sicher, dass er folgende Anforderungen erfüllt: %1",
    '__login_allowed_symbols' => 'Es sind nur alphanumerische Zeichen, einschließlich Punkten, Bindestrichen und Unterstrichen, erlaubt. Das erste Zeichen sollte ein alphanumerisches sein.',

    'restart__nginx' => 'Reverse-Proxy-Server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Ich möchte allgemeine Produktinformationen und Ankündigungen von Plesk erhalten.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Ich möchte sicherheitsbezogene Produktinformationen und andere technische Benachrichtigungen von Plesk erhalten.",

    '__login_status_inactive' => 'Ihr Konto ist inaktiv. Bitte kontaktieren Sie den Plesk Administrator.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Kehren Sie zurück zu den Tools & Einstellungen. Die Migration wird im Hintergrund fortgesetzt.',

    'ui__admin-alias-info__description' => "Bearbeiten Sie die Kontaktdaten des zusätzlichen Administratorkontos.",
    'ui__admin-alias-info__short-title' => "Kontaktdaten",
    'ui__admin-alias-info__title' => "Informationen zum zusätzlichen Administratorkonto",
    'ui__admin-alias-password__description' => "Ändern Sie das Passwort des zusätzlichen Administrators.",

    'ui__admin-alias-password__short-title' => "Passwort ändern",
    'ui__admin-alias-password__title' => "Passwort des zusätzlichen Administrators",
    'ui__admin-alias__description' => "Lassen Sie Informationen über zusätzliche Administratorkonten anzeigen und ändern Sie sie.",

    'chk_js__warning_about_login_syntax' => "Für den Nutzernamen sind nur alphanumerische Zeichen, Kleinbuchstaben, Bindestriche und Unterstriche erlaubt. Der Nutzername muss mit einem Buchstaben beginnen. Das Passwort darf nicht den Nutzernamen sowie Anführungszeichen enthalten.",
    'chk_js__warning_about_ftp_login_syntax' => "Für den Benutzernamen sind nur alphanumerische Zeichen, Bindestriche und Unterstriche erlaubt.",
    'chk_js__warning_about_login_syntax_win' => "Für den Nutzernamen sind nur kleingeschriebene alphanumerische Zeichen, Bindestriche, Punkte und Unterstriche erlaubt. Der Nutzername muss mit einem Buchstaben oder einer Zahl beginnen. Das Passwort darf nicht den Nutzernamen sowie Anführungszeichen enthalten.",
    'chk_js__warning_about_passwd_syntax' => "Verwenden Sie keine Anführungszeichen, Leerzeichen oder sprachspezifischen Zeichen (z. B. ä, ß) in einem Passwort.\nDas Passwort muss zwischen %1 und %2 Zeichen lang sein und sollte nicht den Benutzernamen enthalten.",
    'chk_js__warning_about_plesk_login_syntax' => "Für den Benutzernamen sind nur alphanumerische Zeichen, Kleinbuchstaben, Punkt, Geviertstriche und Unterstriche erlaubt.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Für den Benutzernamen sind nur alphanumerische Zeichen, Kleinbuchstaben, Geviertstriche und Unterstriche erlaubt. Der Benutzername muss mit einem Buchstaben beginnen",
    'chk_js__warning_about_plesk_passwd_syntax' => "Verwenden Sie keine Anführungszeichen, Leerzeichen oder sprachspezifischen Zeichen (z. B. ä, ß) in einem Passwort.\nDas Passwort muss zwischen %1 und %2 Zeichen lang sein und sollte nicht den Benutzernamen enthalten.",
    'chk_js__warning_about_pam_passwd_error' => "Das angegebene Systembenutzerkonto ist falsch: %1",

    'cmd_server__admin_alias_not_found' => "Das zusätzliche Administratorkonto konnte nicht gefunden werden.",

    'panel_branding__skins_already_exists' => "Hinweis: Die Desginvorlage '%1' existiert bereits. Sie wird mit der Designvorlage, die Sie gerade installieren, ersetzt.",
    'panel_branding__skins_file_exists' => "Das Verzeichnis für das Theme '%1' kann nicht erstellt werden: Eine Datei mit diesem Namen existiert bereits.",

    'actionlog__login_failed' => 'konnte sich nicht anmelden',
    'actionlog__event_cp_user_login_failed' => 'Anmeldung eines Plesk Benutzers fehlgeschlagen',
    'actionlog__api_login_failed' => 'konnte sich nicht über API einloggen',
    'actionlog__event_cp_user_api_login_failed' => 'Anmeldung eines Plesk Benutzers über API fehlgeschlagen',
    'actionlog__pw_reset' => 'Zurücksetzen des Passworts angefordert',
    'actionlog__pw_admin_force_reset' => 'erzwungenes Zurücksetzen des Administrator-Passworts angefordert',

    'ch_pass_admin__email_subject' => "Passwort-Erinnerung von Plesk",
    'ch_pass_admin__email_body' => "Guten Tag %1.\n\nDas Administratorpasswort kann aus Sicherheitsgründen nicht per E-Mail verschickt werden.\n\nUm sich als 'admin' anzumelden, verwenden Sie den Befehl 'plesk login'.\n\nUm ein neues 'admin'-Passwort zu erstellen, verwenden Sie den Befehl 'plesk bin admin --set-password -passwd <new_password>'.\n\n",
    'ch_pass_admin__message_send_error' => 'Die E-Mail kann nicht gesendet werden: %1',

    'ch_pass_by_secret__email_subject' => "Passwort-Erinnerung von Plesk",
    'ch_pass_by_secret__email_body' => "Hallo %2, \n\nUm ein neues Passwort einzurichten, folgen Sie bitte diesem Link: %1 \n\nIhr Benutzername: %3",
    'ch_pass_by_secret__message_send_error' => 'Senden des Geheimcodes nicht möglich: %1',
    'ch_pass_by_secret__title' => 'Passwort ändern',
    'ch_pass_by_secret__secret' => 'Geheimcode',

    'custom_button__noframe' => "Keinen Rahmen verwenden",

    'custom_button__internal_hint' => 'Geben Sie an, ob die URL auf einer Plesk Seite geöffnet werden soll oder in einem neuen Browserfenster.',
    'custom_button__noframe_hint' => 'Wenn Sie eine benutzerdefinierte Schaltfläche hinzufügen, die zu einer Plesk Erweiterung oder einer App im Kunden-Panel führt, können Sie angeben, wie diese Erweiterung/App angezeigt werden soll: in einem Frame oder als Teil der Plesk Benutzeroberfläche.',


    'actionlog__patch' => 'Aktualisieren',
    'actionlog__patch_available' => 'verfügbar',
    'actionlog__event_patch_available' => 'Update verfügbar',
    'actionlog__patch_installed' => 'installiert',
    'actionlog__event_patch_installed' => 'Update installiert',

    'actionlog__extension' => 'Erweiterung',
    'actionlog__extension_status' => 'Erweiterungsstatus',
    'actionlog__cloning' => 'Klonen des Servers',
    'actionlog__cloning_complete' => 'abgeschlossen',
    'actionlog__event_cloning_complete' => 'Klonen des Servers abgeschlossen',

    'actionlog__ssl_web_binding' => 'SSL/TLS-Zertifikat auf der Domain',
    'actionlog__ssl_web_binding_update' => 'zugewiesen/nicht mehr zugewiesen',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS-Zertifikat auf der Domain zugewiesen/nicht mehr zugewiesen',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-Zertifikat für Webmail',
    'actionlog__ssl_web_mail_binding_update' => 'zugewiesen/nicht mehr zugewiesen',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS-Zertifikat auf Webmail zugewiesen/nicht mehr zugewiesen',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-Zertifikat auf dem Mailserver',
    'actionlog__ssl_mail_binding_update' => 'zugewiesen/nicht mehr zugewiesen',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-Zertifikat auf dem Mailserver zugewiesen/nicht mehr zugewiesen',

    'actionlog__ssl_panel_binding' => 'SSL/TLS-Zertifikat in Plesk',
    'actionlog__ssl_panel_binding_update' => 'zugewiesen/nicht mehr zugewiesen',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-Zertifikat in Plesk zugewiesen/nicht mehr zugewiesen',

    'actionlog__hostname' => 'Hostname des Servers',
    'actionlog__hostname_changed' => 'geändert',

    'actionlog__smb_user' => 'Zusätzlicher Benutzer',
    'actionlog__smb_user_create' => 'Zusätzlicher Benutzer erstellt',
    'actionlog__smb_user_delete' => 'Zusätzlicher Benutzer gelöscht',
    'actionlog__smb_user_update' => 'Zusätzlicher Benutzer aktualisiert',

    'actionlog__event_mail_management_status_update' => 'Update des E-Mail-Verwaltungsstatus',
    'actionlog__mail_management' => 'E-Mail-Verwaltungsstatus',
    'actionlog__mail_management_status_update' => 'aktualisiert',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Gesamt nach Domains',

    'chk_js__warning_about_admin_passwd_syntax' => "Verwenden Sie keine Anführungszeichen, Leerzeichen, Strichpunkte oder sprachspezifischen Zeichen (z.B. ä, ß) in einem Passwort.\nDas Passwort darf nur zwischen %1 und %2 Zeichen lang sein und sollte nicht den Benutzernamen enthalten.",

    'passwordSecurityLevelCheckFailed' => 'Ihr Passwort ist nicht komplex, d. h. nicht sicher, genug. Gemäß der Serverrichtlinien ist die Mindestpasswortsicherheit %1. Um die Passwortsicherheit zu verbessern, verwenden Sie Zahlen, Klein-, Großbuchstaben und/oder Sonderzeichen wie !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Sehr schwach',
    'passwordSecurityLevelCheckFailedWeak' => 'Schwach',
    'passwordSecurityLevelCheckFailedMediocre' => 'Mittel',
    'passwordSecurityLevelCheckFailedStrong' => 'Stark',
    'passwordSecurityLevelCheckFailedStronger' => 'Sehr sicher',

    'ui__client/domain/dns/sync__description' => 'Wenden Sie Änderungen aus dem serverweiten DNS-Template auf die Zone an.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Die Änderungen am DNS-Template können nicht auf die Zone angewendet werden, da die Zone von einem anderen DNS-Server bedient wird.',
    'ui__client/domain/dns/sync__short-title' => 'Änderungen des DNS-Templates anwenden',
    'ui__client/domain/dns/sync__done' => 'Die Änderungen aus dem DNS-Template wurden erfolgreich auf die Zone angewendet.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Wenden Sie Änderungen aus dem serverweiten DNS-Template auf die Zone an.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Die Änderungen am DNS-Template können nicht auf die Zone angewendet werden, da die Zone von einem anderen DNS-Server bedient wird.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Änderungen des DNS-Templates anwenden',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Die Änderungen aus dem DNS-Template wurden erfolgreich auf die Zone angewendet.',
    'dns__dns_default_ipv4_modified' => 'Einträge mit dieser IP-Adresse werden als vom Benutzer modifiziert angesehen und nicht mit dem serverweiten DNS-Template synchronisiert.',
    'dns__dns_default_ipv6_modified' => 'Einträge mit dieser IP-Adresse werden als vom Benutzer modifiziert angesehen und nicht mit dem serverweiten DNS-Template synchronisiert.',

    'dns__view_dns_record_master_title' => 'Einsicht in Ressourceneinträge',
    'dns__view_dns_record_off_title' => 'Einsicht in Nameserver-Einträge',
    'dns__view_dns_record_slave_title' => 'Einsicht in Einträge des primären DNS-Servers',

    'dns_unable_to_resolve_hostname' => "Der Hostname \"%1\" kann nicht aufgelöst werden: %2\nStellen Sie sicher, dass der DNS Resolver des Betriebssystems eingerichtet ist und korrekt funktioniert.",

    'no_database_server_available' => 'Für dieses Abonnement sind keine Datenbankserver verfügbar.',

    'database_used_by_application_can_not_be_moved' => 'Die Datenbank kann nicht verschoben werden: Die Datenbank wird von einer Website-Anwendung verwendet.',
    'database_user_update_orphaned_is_restricted' => 'Das Aktualisieren von verwaisten Datenbankbenutzerkonten ist nicht zulässig. Sie können sie lediglich löschen oder reparieren.',

    'database_unable_to_get_max_filesize_default_message' => 'Die maximale Dateigröße der Datenbank kann nicht bestimmt werden: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Die maximale Dateigröße der Datenbank kann nicht festgelegt werden: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Die maximale Protokolldateigröße der Datenbank kann nicht bestimmt werden: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Die maximale Protokolldateigröße der Datenbank kann nicht festgelegt werden: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Die aktuelle Grenze für die Dateigröße der Microsoft SQL Datenbank \'%1\' kann nicht bestimmt werden. Die Festlegung einer neuen Grenze ist nicht möglich.',
    'database_unable_to_set_max_filesize' => 'Die Grenze für die Dateigröße der Microsoft SQL Datenbank \'%1\' kann nicht festgelegt werden.',
    'database_unable_to_get_max_log_filesize' => 'Die aktuelle Grenze für die Protokolldateigröße der Microsoft SQL Datenbank \'%1\' kann nicht bestimmt werden. Die Festlegung einer neuen Grenze ist nicht möglich.',
    'database_unable_to_set_max_log_filesize' => 'Die Grenze für die Protokolldateigröße der Microsoft SQL Datenbank \'%1\' kann nicht festgelegt werden.',

    'database_unable_to_create_because_max_filesize' => 'Die Microsoft SQL Datenbank \'%1\' kann nicht erstellt werden: Ihre Datei ist größer als die maximal zulässige Dateigröße.',
    'database_unable_to_move_because_max_filesize' => 'Die Microsoft SQL Datenbank \'%1\' kann nicht verschoben werden: Ihre Datei ist größer als die maximal zulässige Dateigröße: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Die Microsoft SQL Datenbank \'%1\' kann nicht erstellt werden: Ihre Protokolldatei ist größer als die maximal zulässige Dateigröße.',
    'database_unable_to_move_because_max_log_filesize' => 'Die Microsoft SQL Datenbank \'%1\' kann nicht verschoben werden: Ihre Protokolldatei ist größer als die maximal zulässige Dateigröße: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Die Microsoft SQL Datenbank \'%1\' kann nicht wiederhergestellt werden: Ihre Datei ist größer als die maximal zulässige Dateigröße.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'In Plesk ist bereits ein als Sandbox dienender MS SQL Server registriert. Bitte geben Sie einen anderen MS SQL Server als Sandbox an.',
    'database_server__mssql_server_registered_as_sandbox' => 'In Plesk ist bereits ein identischer als Sandbox dienender MS SQL Server registriert. Bitte geben Sie einen anderen MS SQL Server als Sandbox an.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Verbindung mit dem Server über "%1" nicht möglich: %2',

    'bu_conflict_resolver_feature_not_available' => 'Das Feature %1 wird von folgenden Service Nodes nicht unterstützt: %2. Dieses Features wird für alle auf diesen Nodes erstellten Objekte deaktiviert.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Das Feature %1 wird von diesem Server nicht unterstützt. Dieses Features wird für alle wiederhergestellten Objekte deaktiviert.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Die Komponente %1 ist nicht installiert. Sie wird für folgende Websites nicht verfügbar sein: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Die Komponente %1 ist nicht installiert. Er wird für folgende Websites durch %2 ersetzt: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Die aktuelle Plesk Version unterstützt keine Benutzernamen mit dem Zeichen Punkt (.). Kunden und Reseller mit derartigen Benutzernamen werden nicht wiederhergestellt.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Es kann keine Backupdatei mit Daten für die/den %1 %2 gefunden werden. Die Daten für die/den %1 %2 werden nicht wiederhergestellt.',

    'bu_conflict_resolver_zone_master_removed' => "Der primäre DNS-Eintrag kann nicht wiederhergestellt werden: Der Eintrag in der sekundären Zone verweist auf die existierende IP-Adresse %1. Der primäre DNS-Eintrag wird aus der sekundären Zone entfernt.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Support for HTTPS DNS records is turned off. HTTPS records will not be restored for the following domains: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 wird nicht unterstützt.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 wird nicht unterstützt. Sie wird für folgende Websites nicht verfügbar sein: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Die Komponente %1 ist nicht installiert.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Sie wird für folgende Service-Nodes nicht verfügbar sein: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Sie wird für folgende Objekte nicht verfügbar sein: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Folgende Datenbankserver sind auf diesem Server nicht verfügbar: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Die Backupdatei der MS-SQL-Datenbank ist im nativen Format von MS SQL gespeichert. Dieses kann nur auf dem lokalen MS-SQL-Server oder auf einem Remote-MS-SQL-Server mit vollständig konfigurierten Backup-Einstellungen wiederhergestellt werden. Einige Ihrer Datenbanken wurden nicht wiederhergestellt, da kein passender MS-SQL-Server in Plesk registriert ist. Folgende Domains sind betroffen: {{objects}}. Bitte wenden Sie sich an Ihren Hosting-Provider.',

    'bu_conflict_resolver_not_available_webmail' => 'Der Webmail-Service %1 ist nicht verfügbar. Er wird für folgende Objekte durch %2 ersetzt: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Der Webmail-Service %1 ist nicht verfügbar. Er wird in folgenden Service-Paketen durch %2 ersetzt: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Datenbanken des Typs '%1' unterstützen keine Nutzernamen, die mit Datenbanknamen übereinstimmen. Der Nutzer '%2' wird für die Datenbank '%4' in '%3' umbenannt.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Die Grenze für die Speicherplatzbelegung ist nicht in der Konfiguration des Zielservers festgelegt. Der Wert dieser Einstellung wird in "Unbegrenzt" geändert.',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Die Grenze für die Anzahl an Verbindungen ist nicht in der Konfiguration des Zielservers festgelegt. Der Wert dieser Einstellung wird in "Unbegrenzt" geändert.',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Die Grenze für den Traffic-Verbrauch ist nicht in der Konfiguration des Zielservers festgelegt. Der Wert dieser Einstellung wird in "Unbegrenzt" geändert.',
    'cu__pleskrestore_backup_file_extracted' => 'Die Backupdatei wurde in "%1" extrahiert.',
    '__mod_bw_not_supported' => 'Das Modul mod_bw für den Apache Webserver wird aufgrund der Konfiguration des Dateisystems nicht unterstützt. Daher werden die Grenzen für den Traffic-Verbrauch und die maximale Anzahl an Verbindungen nicht greifen.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Die POP3-Autorisierung für das Mail-Relaying wird nicht unterstützt, stattdessen wird die POP3-before-SMTP-Autorisierung verwendet. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Service-Paket \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 wird nicht unterstützt. Er wird in folgenden Service-Paketen durch %2 ersetzt: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 wird nicht unterstützt. Er wird für folgende Websites durch %2 ersetzt: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Folgende Objekte konnten in der Backupdatei nicht gefunden werden: %1',
    'bu_conflict_resolver_absent_domains' => 'Einige Objekte können nicht wiederhergestellt werden, da sie zu folgenden in Plesk nicht auffindbaren Domains gehören: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Einige Websites können nicht wiederhergestellt werden, da sie zu folgenden in Plesk nicht auffindbaren übergeordneten Domains gehören: \n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Die DNS-Zonen können nicht wiederhergestellt werden: Der DNS-Service ist in der Serverkonfiguration ausgeschaltet.',
    'bu_conflict_resolver_mail_not_supported' => 'Die Postfächer können nicht wiederhergestellt werden: Der E-Mail-Service ist in der Serverkonfiguration ausgeschaltet.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Die angegebene Aktion bei Erreichen der CPU-Grenze wird nicht vom IIS-Webserver unterstützt. Der wird auf %1 zurückgesetzt.',
    'bu_conflict_detector_server_ssl_cert_name' => 'SSL/TLS-Serverzertifikat %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-Zertifikat %2 der Domain %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-Zertifikat %1',
    'bu_conflict_resolver_absent_objects' => 'Die Inhalte folgender Objekte können nicht wiederhergestellt werden, da die Objekte nicht in Plesk gefunden werden können: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Die Inhalte folgender Postfächer können nicht wiederhergestellt werden, da die Postfächer nicht in Plesk gefunden werden können: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Die Inhalte folgender Mailinglisten können nicht wiederhergestellt werden, da die Mailinglisten nicht in Plesk gefunden werden können: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Die Inhalte folgender Datenbanken können nicht wiederhergestellt werden, da die Datenbanken nicht in Plesk gefunden werden können: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Die Wiederherstellung der Anwendung "%1" unter "%2" ist fehlgeschlagen, da eine andere Anwendung bereits in "%3" installiert ist. Sie können die installierte Anwendung entfernen und den Vorgang erneut versuchen.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Die Funktion für automatische E-Mail-Antworten wird nicht unterstützt.',
    'bu_conflict_resolver_not_available_mail_content' => 'Die Wiederherstellung von E-Mail-Inhalt wird nicht unterstützt.',
    'bu_conflict_resolver_invalid_mail_name' => 'Die folgenden Postfächer wurden nicht wiederhergestellt, weil die Verwendung von E-Mail-Unteradressen aktiviert ist und bestimmte E-Mail-Adressen das Symbol "%1" enthalten: %2',
    'bu_conflict_resolver_invalid_user_name' => 'Die folgenden Benutzer wurden nicht wiederhergestellt, weil die Verwendung von E-Mail-Unteradressen aktiviert ist und bestimmte E-Mail-Adressen das Symbol "%1" enthalten: %2',
    'bu_conflict_resolver_licenses_expired' => 'Die folgenden Lizenzen sind abgelaufen und werden nicht wiederhergestellt: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Die folgenden Lizenzen sind nicht gültig oder abgelaufen und werden nicht wiederhergestellt: {{objects}}',
    'expiration_unsupported' => "Die Grenze 'Ablauf' wird nicht unterstützt.",

    'component_name__dbconnector' => "Datenbank-Connector",
    'component_name__mysqlserver' => 'MariaDB/MySQL-Server',
    'component_name__troubleshooting' => 'Problembehandlung',
    'component_name__savi' => 'Benutzeroberfläche der Antivirensoftware Sophos',

    '__subscription_has_no_license_key' => 'Die Ressourcen des Abonnements werden vom Service Node Nr. %1 bereitgestellt, der jedoch nicht über einen zugehörigen Lizenzschlüssel verfügt.',
    '__subscription_has_expired_license_key' => 'Die Ressourcen des Abonnements werden vom Service Node Nr. %1 bereitgestellt, dessen Lizenzschlüssel %2 abgelaufen ist.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Speichern der Konfigurationsdateien nicht möglich',
    '__cfgmonConfigurationFileSaveErrorBody' => "Einige Konfigurationsdateien können nicht auf dem Host <%%host%%> gespeichert werden: Die folgenden Fehler sind aufgetreten:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Wenn Sie diese Option aktivieren, können Sie VERP-kompatible E-Mail-Adressen für Mailinglisten konfigurieren.',
    'mail__enter_right_ip_mask' => "Geben Sie die IP-Maske zwischen 1 und 32 ein",
    'mail__enter_right_ip_mask_24' => "Geben Sie die IP-Maske zwischen 24 und 32 ein",
    'mail__invalid_dom_name' => "Der Domainname %1 ist ungültig.",
    'mail__invalid_pop_lock_time' => "POP3-Sperrzeit ist ungültig.",
    'mail__invalid_rbl_server' => "Der DNS-Zonenname ist ungültig.",
    'mail__total_files_size' => "Gesamtgröße Repository: %1",
    'mail__filename_already_in_repository' => "Eine Datei mit diesem Namen ist bereits im Repository vorhanden",
    'mail__no_white_list_mask_feature_24' => "Verwenden Sie als Maskenwert 24 oder höher. Ihr Mailserver unterstützt das Einrichten von Masken nicht. Wir können das Einrichten der Maske für Werte unter 24 nur emulieren.",
    'mail__unable_add_new_mail_name' => "E-Mail-Konto kann nicht hinzugefügt werden: %1",
    'mail_server_is_not_installed' => 'Der Mailserver (Postfix oder qmail) ist nicht installiert. Installieren Sie ihn, um fortfahren zu können.',
    'mail_server_not_available' => 'Auf dem Service Node sind keine unterstützten Mailserver verfügbar.',
    '__not_installed' => '(nicht installiert)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Der Spamfilter für ausgehende E-Mail-Nachrichten ist deaktiviert.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Für die Domain %1 unterstützt der Service Node nicht die Begrenzung der Anzahl der von einer Domain abgehenden E-Mail-Nachrichten.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Für die Domain %1 unterstützt der Service Node nicht die Begrenzung der Anzahl der von einem Postfach abgehenden E-Mail-Nachrichten.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Geben Sie mindestens eine Adresse eines Typs an (IPv4 oder IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Der angegebene Postausgangsmodus ist ungültig.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Die angegebene IPv4-Adresse ist ungültig.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Die angegebene IPv6-Adresse ist ungültig.',
    'mail__outgoing_email_mode_unavailable' => 'Die Änderung des Postausgangsmodus wird nicht unterstützt, möglicherweise weil der Postfix-Mailserver nicht auf diesem Server installiert ist.',

    'mail__autoresponder_attachment_not_supported' => 'Der derzeit verwendete Mailserver unterstützt die Verwaltung von Anhängen in automatischen Antworten nicht.',

    'mail__smtp_white_list_not_supported' => 'Für den derzeit verwendeten Mailserver können keine IP-Adressen auf die Zulassungsliste gesetzt werden.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR-Masken werden vom ausgewählten Mailserver nicht unterstützt. Geben Sie die IP-Adresse im Format \'192.*.0.*\' ein.',
    'mail__smtp_whitelist_mask_not_supported' => 'Platzerhalter-ID-Muster werden vom ausgewählten Mailserver nicht unterstützt. Geben Sie die IP-Adresse im Format \'192.0.0.0/8\' ein.',

    'sfdk_server_wide_verify_failed' => 'Die Einstellungen für den DKIM-Verifizierungsdienst können nicht geändert werden.',

    'sfdk_domain__serverwide_disabled' => 'Deaktiviert gemäß den Vorgaben des Servers',
    'feature__domainkeys__serverwide_disabled' => 'Serverweiter DKIM-Spamschutz ist deaktiviert.',

    'defaultcomponents__error_set_default' => '%1 kann nicht als Standard %2 festgelegt werden: %3',
    'defaultcomponents__error_set_default_none' => 'Es konnte keine Standardkomponente für %1 festgelegt werden: %2',
    'defaultcomponents__required_package_not_default' => 'Die Komponente %1, die für die Funktion von Ersterem erforderlich ist, ist nicht Standard.',

    '__percentage' => '%',
    '__seconds' => 'Sekunden',
    '__resource_remain' => 'Verbleibend',

    '__not_registered' => '(nicht registriert)',
    '__php_handler_id' => 'PHP-Version',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Der PHP-Handler "%1" ist nicht registriert. Er wurde möglicherweise vom Server gelöscht. Registrieren Sie einen Handler mit denselben Eigenschaften und versuchen Sie es erneut.',
    '__php_handler_not_registered_on_domain' => 'Domain "%1": Der PHP-Handler "%2" ist nicht registriert. Er wurde möglicherweise vom Server gelöscht. Registrieren Sie einen Handler mit denselben Eigenschaften und versuchen Sie es erneut.',
    '__php_fpm_handler' => 'FPM-Anwendung',
    '__php_fpm-dedicated_handler' => 'Dedizierte FPM-Anwendung',

    'mailname_create_assigned_user_dublicate_error' => 'Es ist nicht möglich, einen Nutzer für das Postfach zu erstellen. Der Nutzer mit dem Nutzernamen %1 existiert bereits und besitzt ein anderes Postfach.',
    'mailname_create_assigned_user_role_absent_error' => 'Es ist nicht möglich, einen Nutzer für das Postfach zu erstellen. Die Standardrolle %1 des Nutzers existiert nicht.',

    'gphd__mime_types' => 'MIME-Typen',
    'gphd__handlers' => 'Apache Handler',
    'gphd__ip_restrictions_allow' => 'Zugriff auf die Website für die angegebenen Hosts und Netzwerke erlauben (mit Ausnahme der nicht zugelassenen)',
    'gphd__ip_restrictions_deny' => 'Zugriff auf die Website für die angegebenen Hosts und Netzwerke verweigern',
    'gphd__directory_index' => 'Indexdateien',
    'gphd__nginx_transparent_mode' => 'Der Modus, in dem Apache sowohl statischen als auch dynamischen Content handhabt, während nginx nur HTTP-Abfragen und Antworten ohne Modifikation weitergibt.',
    'gphd__nginx_serve_static' => 'Statische Dateien direkt durch nginx bedienen',
    'gphd__nginx_static_extensions' => 'Statische Dateierweiterungen, die von nginx gehandhabt werden müssen',
    'gphd__nginx_serve_php' => 'PHP-Dateien von nginx verarbeiten lassen',
    'gphd__www_root' => 'WWW-Stammverzeichnis',

    'eol__none' => 'nicht ändern',
    'eol__lf' => 'in Unix-Stil umwandeln',
    'eol__cr' => 'in MacOS-Stil umwandeln',
    'eol__crlf' => 'in Windows-Stil umwandeln',

    'ui__dns_bad_zone' => 'Widersprüchliche Zone "%1":',
    'ui__dns_ns_has_no_address_records' => 'Der Nameserver-Eintrag "%1" hat keine Adresseinträge (A oder AAAA).',
    '__dns_bad_zone' => 'Widersprüchliche Zone "%1":',
    '__dns_ns_has_no_address_records' => 'Der Nameserver-Eintrag "%1" hat keine Adresseinträge (A oder AAAA).',
    '__dns_ptr_is_wildcard' => 'Der PTR-Eintrag "%1" ist ungültig: Der Eintrag verweist auf eine Wildcard Domain.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Remotezugriff für Datenbankbenutzer \'%3\' des Kunden \'%4\' zulassen',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Für den Datenbankbenutzer \'%1\' können keine Remoteverbindungen zugelassen werden: Die vom Microsoft SQL Server \'%2\' genutzte TCP-Portnummer kann nicht bestimmt werden. Dies kann folgende Gründe haben: In der Netzwerkkonfiguration des Servers ist das TCP/IP-Protokoll nicht aktiviert oder der Server ist für die Nutzung von dynamischen TCP-Ports konfiguriert. Konfigurieren Sie den SQL-Server manuell so, dass er über einen bestimmten festen TCP-Port kommuniziert und versuchen Sie erneut, Remoteverbindungen zuzulassen.',

    'command__convertResellerHasCustomer' => 'Das Reseller-Konto \'%1\' besitzt ein oder mehrere Kundenkonten. Um dieses Reseller-Konto in ein Kundenkonto umzuwandeln, müssen Sie zuerst dessen Kundenkonten an einen neuen Besitzer übertragen oder sie in Reseller-Konten umwandeln.',
    'command__convertResellerNotReseller' => 'Nur Reseller-Konten können in Kundenkonten umgewandelt werden. \'%1\' ist kein Reseller.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Das Abonnement konnte nicht mit dem Service-Paket synchronisiert werden. Die folgenden Einstellungen stehen in Konflikt mit dem Service-Paket: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Das Konto \'%1\' ist ein Reseller-Konto. Reseller-Konten können nicht zu einem neuen Besitzer verschoben werden, da sie dem Serveradministrator gehören.',
    'moveCustomer__wrong_owner_type' => "Das Kundenkonto '%1' kann nur zu einem Reseller oder Administrator verschoben, nicht aber zu einem anderen Kunden.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Das Kundenkonto \'%1\' gehört bereits zum ausgewählten Besitzer.',
    'upgradeClient__user_is_admin' => 'Das Konto \'%1\' kann nicht in ein Reseller-Konto umgewandelt werden, da es ein Administratorkonto ist.',

    'mail__error_setting_max_connections_courier' => 'Die maximale Anzahl der Verbindungen (IMAP, POP3, IMAP über SSL/TLS oder POP3 über SSL/TLS) kann nicht festgelegt werden: %1',
    'mail__error_setting_max_connections_dovecot' => 'Die maximale Anzahl der Verbindungen (IMAP, POP3, IMAP über SSL/TLS oder POP3 über SSL/TLS) kann nicht festgelegt werden: %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Die maximale Anzahl der Verbindungen (IMAP, POP3, IMAP über SSL/TLS oder POP3 über SSL/TLS) pro IP-Adresse kann nicht festgelegt werden: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Die maximale Anzahl der Verbindungen (IMAP, POP3, IMAP über SSL/TLS oder POP3 über SSL/TLS) pro IP-Adresse kann für einen bestimmten E-Mail-Benutzer nicht festgelegt werden: %1',
    'outgoing_messages_limit_value_invalid' => 'Der Wert muss sich im Bereich %%MIN%%..%%MAX%% befinden. Nur der Plesk Administrator kann diese Einstellung anpassen.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Die nachfolgenden Domains verwenden bei E-Mails, die an nicht existierende Adressen gesendet werden, externe E-Mail-Adressen für die E-Mail-Weiterleitung. Nachrichten, die an diese Adressen gesendet werden, werden in der Postausgangskontrolle nicht gezählt:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Die Grenzen für ausgehende E-Mails greifen nicht für E-Mail-Absender, deren IP-Adressen sich in der Whitelist des Mailservers befinden. Wenn sich zum Beispiel localhost (127.0.0.0 / 8, ::1 / 128) in der Whitelist befindet, werden alle E-Mails vom lokalen Server ungeachtet etwaiger Begrenzungen gesendet. E-Mail-Sender können entweder lokale IP-Adressen verwenden (Websites und benutzerdefinierte Skripte, die auf dem lokalen Server gehostet werden) oder externe IP-Adressen (Kunden, die E-Mails von Mailclients senden, die auf ihrem Computer oder Mobilgerät installiert sind). Wenn die Grenzen für alle E-Mail-Sender (sowohl lokal als auch extern) greifen sollen, müssen Sie alle IP-Adressen und Netzwerke aus der Whitelist entfernen. Beachten Sie, dass das Entfernen von localhost (127.0.0.0 / 8, ::1 / 128) aus der Whitelist die Funktion von Websites und Skripten, die E-Mails von diesem Server senden, stören kann. Einzelheiten zu Begrenzungen für ausgehende E-Mails finden Sie im Administrator-Handbuch, Abschnitt "Schutz vor ausgehendem Spam".',
    'outgoing_messages_relay_open' => 'Das E-Mail-Relay ist offen: Die Grenzen für ausgehende E-Mails werden nicht greifen.',

    'notification_aps_app_updates_available' => 'Für folgende Anwendungen sind Updates verfügbar:',
    'notification_aps_app_updates_installed' => 'Für folgende Anwendungen wurden automatisch Updates installiert:',
    'notification_aps_app_updates_requirements' => 'Für folgende Anwendungen sind Updates verfügbar, die jedoch nicht installiert werden können, da die Hosting-Einstellungen der zugehörigen Websites nicht die Installationsanforderungen erfüllen:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plug-in "%%name%%" in %%parentName%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Theme "%%name%%" in %%parentName%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plug-in "%%name%%" auf %%parentName%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Theme "%%name%%" auf %%parentName%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Ihre Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plug-in "%%name%%" auf %%parentName%% (%%url%%). Ihre Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Theme "%%name%%" auf %%parentName%% (%%url%%). Ihre Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Neue Version: %%to%%. Vorherige Version: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Neue Version: %%to%%. Vorherige Version: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Neue Version: %%to%%. Vorherige Version: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installierte Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Ihre Version: %%from%%. Verfügbare Version: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'externe Anwendung',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domains',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-Mail-Adressen',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonnements',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 Nachrichten pro Stunde',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Unbegrenzt',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, Grenze: %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 Versuch(e), die Grenzen zu überschreiten von %2 bis %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 Versuch(e), die Grenzen zu überschreiten von %2 bis jetzt',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Sperren von IP-Adressen (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Die Komponente Fail2Ban ist nicht auf dem Zielserver installiert.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installieren Sie Fail2Ban. Beachten Sie, dass dies einige Minuten dauern kann.',

    'plesk_key__no_reseller_support' => 'Aufgrund von Lizenzbeschränkungen können Sie keine Reseller verwalten.',
    'plesk_key__no_customers_support' => 'Aufgrund von Lizenzbeschränkungen können Sie keine Kunden verwalten.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Aufgrund der Lizenzbeschränkungen kann nicht in die Service-Provider-Ansicht gewechselt werden.',
    'plesk_key__no_security_core_support' => 'Aufgrund von Lizenzbeschränkungen sind die Security Core Features (ModSecurity und Fail2Ban) nicht verfügbar.',
    'plesk_key__outgoing-antispam' => 'Postausgangskontrolle',
    'plesk_key__security-core' => 'Security Core (ModSecurity und Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Kontenverwaltung',
    'plesk_key__can-manage-subscriptions' => 'Abonnement-Verwaltung',
    'plesk_key__can-manage-customers' => 'Kundenverwaltung',
    'plesk_key__can-manage-resellers' => 'Reseller-Verwaltung',
    'plesk_key__can-manage-custom-view' => 'Verfügbarkeit des eingeschränkten Modus',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Die Abonnement-Verwaltung ist ausgeschaltet, aber Sie haben mehrere Abonnements (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Die Reseller-Verwaltung ist ausgeschaltet, aber Sie haben mehrere Reseller (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Die Kundenverwaltung ist deaktiviert, Sie haben jedoch mehrere Kunden (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Bestimmte Abonnement-Ressourcen, die Sie nicht mehr über die Plesk Benutzeroberfläche verwalten können (z. B. die Begrenzung des Speicherplatzes für Postfächer und Domains), sind jetzt als unbegrenzt festgelegt.',
    'plesk_key__no_subscriptions_support' => 'Aufgrund von Lizenzbeschränkungen können Sie keine Abonnements verwalten.',
    'plesk_key__no_custom_view_support' => 'Aufgrund von Lizenzbeschränkungen können Sie den eingeschränkten Modus nicht verwenden.',
    'plesk_key__trial_forbidden_region' => 'Plesk ist derzeit in Ihrer Region nicht verfügbar.',
    'additional_key__main_key' => 'Der Schlüssel ist ein Hauptschlüssel: Sie können einen Hauptschlüssel nicht als einen zusätzlichen Schlüssel hochladen.',

    'gch__hosting_waf_rule_engine' => 'Modus der Web Application Firewall',

    'backup__fieldset__restoration_options' => 'Wiederherstellungsoptionen',
    'backup__restore_options__restore' => 'Wiederherstellen',
    'backup__restore_options__domain__domain_configuration' => 'Domainkonfiguration',
    'backup__restore_options__domain__virtual_host_content' => 'Inhalt des virtuellen Hosts',
    'backup__restore_options__domain__mail' => 'E-Mail',
    'backup__restore_options__domain__databases' => 'Datenbanken',
    'backup__restore_options__client__client_configuration' => 'Konfiguration des Kundenkontos',
    'backup__restore_options__client__domains' => "Domains des Kunden",
    'backup__restore_options__reseller__reseller_configuration' => 'Konfiguration des Reseller-Kontos',
    'backup__restore_options__reseller__personal_domains' => "Domains des Resellers",
    'backup__restore_options__reseller__clients' => "Kunden des Resellers",
    'backup__restore_options__admin__server_configuration' => 'Servereinstellungen',
    'backup__restore_options__admin__administrator_configuration' => 'Konfiguration des Administratorkontos',
    'backup__restore_options__admin__personal_domains' => "Domains des Administrators",
    'backup__restore_options__admin__personal_clients' => "Kunden des Administrators",
    'backup__restore_options__admin__resellers' => 'Reseller',

    'badge_new' => 'Neu',
    'upgrade_php_on_subscription' => 'Führen Sie ein Upgrade von PHP in Ihrem Abonnement auf die Version 5.3.0 oder höher durch.',

    'pkey_notify__body_expiration_notification' => 'Der Lizenzschlüssel ist abgelaufen. Einige Features sind möglicherweise nicht verfügbar. Bitte wenden Sie sich an Ihren Hosting-Provider.',

    'crontab__crontab_entry_exists' => "Die geplante Aufgabe existiert bereits.",
    'crontab__crontab_entry_not_exists' => "Die geplante Aufgabe existiert nicht.",
    'crontab__invalid_values_found' => "Falsche Parameterwerte",
    'crontab__cmd_max_len' => "Der Befehl darf aus höchstens %1 Zeichen bestehen.",

    'domain__domain_exists' => "Folgende Domain mit dem Präfix 'www' und demselben Namen existiert bereits: %1.%2.",
    'domain__subdomain_exists' => "Folgende Subdomain mit dem Präfix 'www' und demselben Namen existiert bereits: %1.%2.",
    'domain__dalias_exists' => "Folgender Domain-Alias mit dem Präfix 'www' und demselben Namen existiert bereits: %1.%2.",
    'domain__record_exists' => "Es existiert ein DNS-Eintrag, der auf Host %1.%2 verweist.",

    'ip_addr__cannot_assign_certificate' => "Das Zertifikat '%1' kann nicht als das Standardzertifikat festgelegt werden: Der private Schlüssel fehlt.",
    'ip_addr__update_dns_error' => 'Probleme beim Aktualisieren der IP-Adresse in DNS-Zonen. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Die IP-Adresse kann nicht hinzugefügt werden. In dieser Netzwerkschnittstelle werden IP-Adressen automatisch abgerufen.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Die IP-Adresse %1 kann nicht entfernt werden. In dieser Netzwerkschnittstelle werden IP-Adressen automatisch abgerufen.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Die IP-Adresse %1 kann nicht repariert werden. In dieser Netzwerkschnittstelle werden IP-Adressen automatisch abgerufen.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Die Oberfläche der IP-Adresse %1 kann nicht geändert werden, da in der Netzwerkschnittstelle %2 IP-Adressen automatisch abgerufen werden.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Die für das Abonnement geltende Grenze für die Anzahl %%type%% wurde überschritten. Die Grenze liegt bei %%limit%% und aktuell werden %%usage%% genutzt.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Die Erstellung von %%type%% ist für dieses Abonnement nicht erlaubt.',
    'shm_lmsg__resource_title__db-mysql' => 'MariaDB/MySQL-Datenbanken',
    'shm_lmsg__resource_title__db-mssql' => 'MS-SQL-Datenbank',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL-Datenbanken',
    'shm_lmsg__resource_title__db-user' => 'Datenbankbenutzer',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS-Anwendungspools',
    'shm_lmsg__resource_title__additional-ftp-account' => 'zusätzliche FTP-Konten',

    'db_user_unable_remove_mysql_global_privileges' => 'Globale MariaDB/MySQL Berechtigungen des Datenbankbenutzers %1 können nicht entfernt werden. Grund: %2',
    'report__client_description' => 'Beschreibung',

    'db__user_role_error' => 'Eine falsche Rolle für den Datenbankbenutzer wurde angegeben: %1. Bitte wählen Sie eine der folgenden Rollen: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Das Festlegen der Dateigrößengrenze für die folgenden Microsoft SQL Server Datenbanken ist nicht möglich, da ihre Dateien größer sind: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Das Festlegen der Größengrenze für Protokolldateien der folgenden Microsoft SQL Server Datenbanken ist nicht möglich, da ihre Protokolldateien größer sind: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Eine öffentliche IP-Adresse kann nicht eingerichtet werden: Eine private IP-Adresse muss vorhanden sein.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Das Einrichten einer öffentlichen IPv4-Adresse für die IPv6-Adresse ist nicht möglich.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Das Einrichten einer öffentlichen IPv6-Adresse für die IPv4-Adresse ist nicht möglich.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Eine öffentliche IP-Adresse kann nicht eingerichtet werden: ungültige IP-Adresse.',

    '__user_already_exists' => "Der Benutzer %1 existiert bereits.",
    '__user_name_is_empty' => "Bitte geben Sie einen Benutzernamen an.",

    'upgrade_php_on_domain' => 'Die PHP-Version 5.3.0 oder neuer kann auf keiner Ihrer WordPress Domains gefunden werden. Versuchen Sie, PHP upzugraden.',

    'component_name__waf' => 'Web Application Firewall',
    'component_name__vcs' => 'Versionskontrollsystem',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Ein möglicher Spoofing-Versuch wurde erkannt: Der Link hat versucht, irrelevanten Content anzuzeigen.',
    'forceResetPasswordUpdated' => 'Ihr Passwort wurde geändert. Verwenden Sie das neue Passwort, um sich bei Plesk anzumelden.',

    'php_handlers_error_no_available_instance' => 'Domain kann nicht erstellt werden: Es sind keine PHP-Handler verfügbar.',
    'domain_error_unable_to_apply_hosting_settings' => 'Hosting-Einstellungen können nicht angewendet werden: %1',

    'plesk_not_configured' => 'Plesk ist nicht konfiguriert. Rufen Sie das Control Panel auf, um die Konfiguration nach der Installation durchzuführen.',
    'cmd_mail__mail_password_duplicated' => 'Die angegebene Kombination von E-Mail-Adresse und Passwort ist bereits auf dem Mailserver vorhanden. Geben Sie eine andere E-Mail-Adresse und ein anderes Passwort an.',

    'extensionRequirementOs' => 'Das Betriebssystem (%1) wird vom Paket nicht unterstützt.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 ist die älteste Version, die vom Paket unterstützt wird.',
    'extensionRequirementPleskMaxVersion' => 'Versionen ab Plesk %1 werden vom Paket nicht unterstützt.',
    'extensionBlacklisted' => 'Die Erweiterung %1 ist nicht für die Installation zugelassen.',
    'extensionDisabled' => 'Die Erweiterung ist deaktiviert.',


    'optimization_settings__unable_set_mpm_event' => 'Der mpm_event-Modus kann nicht eingestellt werden: Dafür muss das Apache-PHP5-Modul ausgeschaltet sein, aber das Modul wird von Domains verwendet.',
    'optimization_settings__unable_turn_off_php' => 'Das Apache-PHP5-Modul kann nicht ausgeschaltet werden: es wird von Domains verwendet.',

    'hst_def__fp_admin_login' =>  'FTP-Benutzername',
    'hst_def__fp_admin_passwd' =>  'FTP-Passwort',

    'database_user_orphaned_old_password_wrong' => "Verwaister Benutzer \"%1\" konnte nicht repariert werden: Das Password ist nicht korrekt.",
    'cannot_load_partner_central_property_key_no_exist' => "Benutzerdefinierte Eigenschaften können nicht abgerufen werden: Der Lizenzschlüssel ist nicht vorhanden.",
    'extensionScriptFailure' => "Die Ausführung von %1 ist fehlgeschlagen. Fehlermeldung: %3",
    '__ssl_redirect' => "Dauerhafte, für SEO geeignete 301-Weiterleitung von HTTP zu HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'DKIM-Verwaltung wird nicht unterstützt.',
    'mail__dmarc_not_supported' => 'DMARC-Verwaltung wird nicht unterstützt.',
    'mail__relay_white_list_not_supported' => 'Die Relay-Whitelist-Verwaltung wird nicht unterstützt.',
    'mail__black_list_not_supported' => 'Blacklist-Verwaltung wird nicht unterstützt.',
    'mail__autoresponder_not_supported' => 'Die Verwaltung automatischer Antworten wird nicht unterstützt.',
    'defaultcomponents__not_supported_version' => '(nicht unterstützte Version)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Das Zertifikat "%1" wurde nicht gefunden.',
    'certificate__unable_setup_certificate' => 'Zertifikat kann nicht installiert werden: Der private Schlüssel und der Zertifikatsinhalt fehlen.',
    'certificate__used_by_panel' => 'Eines der Zertifikate, die Sie löschen möchten, wird zum Schutz von Plesk verwendet.',
    'certificate__used_by_mail_server' => 'Eines der Zertifikate, die Sie löschen möchten, wird zum Schutz des Mailservers verwendet.',
    'certificate__used_by_domain_service' => 'Eines der Zertifikate, die Sie löschen möchten, wird vom Domain-Dienst verwendet.',
    'mail_server__not_installed' => 'Das Zertifikat für den Mailserver kann nicht installiert werden, da der Mailserver nicht installiert ist.',

    'email_activation_mail_subject' => 'Aktivieren Sie Ihren Account bei Plesk',
    'email_activation_mail_body' => "Es wurde ein Account auf dem Plesk Server erstellt %1 Account-Details: Name: %2 E-Mail-Adresse: %3 Falls diese Information korrekt ist und der Account für Sie erstellt wurde, aktivieren Sie ihn über folgenden Link: %4 Indem Sie den Account aktivieren, autorisieren Sie den Inhaber des Servers dazu, Ihre persönlichen Daten (Namen und E-Mail) in Übereinstimmung mit den derzeit geltenden Datenschutzgesetzen als Teil eines Vertrags erfassen, speichern, verarbeiten und zum Erstellen und Erhalten Ihres Accounts verwenden zu dürfen.",

    'backup_transport_permission_name' => 'Verwaltung von %1',
    'backup_transport_permission_description' => 'Ermöglicht das Speichern von Backups in %1.',

    'domain_move_err_target_no_hosting' => 'Die Domain kann nicht in ein Abonnement ohne Hosting verschoben werden.',
    'domain_move_err_already_in_target' => 'Die Domain gehört bereits zum Zielabonnement.',
    'domain_move_err_main_domain' => 'Die Hauptdomain kann nicht verschoben werden.',
    'domain_move_err_subdomain_without_parent' => 'Die Subdomain "%1" kann nicht ohne die übergeordnete Domain "%2" verschoben werden.',
    'domain_move_err_root_exists' => 'Der Zielpfad für www_root %1 ist bereits vorhanden.',
    'domain_move_err_nested_roots' => 'Die Domain kann nicht verschoben werden, da sie den Dokumentstamm mit einer anderen Domain teilt: %1.',
    'domain_move_err_no_mail_service' => 'Die Domain kann nicht verschoben werden, da der E-Mail-Service im Zielabonnement deaktiviert ist.',
    'domain_move_err_app' => "Die Anwendung, die auf \"%1\" installiert ist, wurde nicht in das Abonnement \"%2\" verschoben: %3",
    'domain_move_database_used_by_app' => "Die Datenbank \"%1\" auf \"%2\" wird von der verschobenen Anwendung verwendet. Um die Datenbank erneut \"%3\" zuzuweisen, führen Sie `plesk bin database --assign-to-subscription` aus.",
    'domain_move_target_locked' => "Die Synchronisierung des Zielabonnements \"%1\" wurde gesperrt.",
    'domain_move_filesharing_disabled' => 'Die Dateifreigabe wurde deaktiviert.',
    'domain_move_website_preview_disabled' => 'Website-Vorschau wurde deaktiviert.',
    'domain_move_additional_webserver_settings' => "Überprüfen Sie die zusätzlichen Webserver-Anweisungen der Domain, um eine fehlerhafte Konfiguration zu verhindern.",
    'domain_move_no_permission' => "\"%1\" ist für das Abonnement \"%2\" nicht zulässig.",
    'domain_move_no_access' => "Kein Zugriff auf das Abonnement \"%1\".",
    'domain_split_no_create_permission' => "Das Erstellen von Domains ist nicht zulässig.",
    'domain_split_empty_login' => 'Der Benutzername des Systembenutzers muss angegeben werden.',
    'domain_split_empty_password' => 'Das Passwort des Systembenutzers muss angegeben werden.',
    'domain_split_err_home_exists' => 'Die Domain "%1" kann nicht verschoben werden, da der Zielpfad für das Stammverzeichnis bereits in "%2" vorhanden ist. Ändern Sie den Namen der Domain, um sie in ein neues Abonnement zu verschieben.',
    'domain_split_err_no_hosting_subdomains' => 'Die Domain kann nicht in ein neues Abonnement verschoben werden, weil die Domain kein Hosting, aber Subdomains enthält. Wenn Sie die Domain verschieben möchten, legen Sie in den Hosting-Einstellungen als Hosting-Typ "Website-Hosting" fest.',
    'domain_split_target_locked' => "Die Synchronisierung des Zielabonnements \"%1\" ist gesperrt.",
    'domain_split_target_unsynced' => "Das Zielabonnement \"%1\" wurde nicht mit dem Paket synchronisiert. Grund: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Das geplante Backup auf \"%1\" wurde deaktiviert.",
    'domain_merge_database_error' => "Die Datenbank \"%1\" auf \"%2\" wurde nicht in das Abonnement \"%3\" verschoben: %4",
    'domain_merge_anon_ftp_deactivated' => "Anonymous FTP auf \"%1\" wurde deaktiviert.",
    'domain_merge_smb_user_access' => "Der zusätzliche Benutzer \"%1\" wurde in das Abonnement \"%2\" verschoben, aber sein Zugriff auf das Abonnement wurde gesperrt.",
    'domain_merge_scheduled_tasks' => "Geplante Aufgaben wurden in das Zielabonnement verschoben. Überprüfen Sie die Aufgabenkonfiguration.",
    'domain_merge_scheduled_tasks_deactivated' => "Geplante Aufgaben wurden in das Zielabonnement verschoben und deaktiviert. Überprüfen Sie die Aufgabenkonfiguration.",
    'domain_merge_no_remove_permission' => "Abonnements können nicht entfernt werden.",
    'domain_merge_err_has_addons' => 'Die Hauptdomain kann nicht zusammen mit den zusätzlichen Domains verschoben werden. Verschieben Sie zuerst die Domain(s) "%1".',
    'domain_merge_err_has_webusers' => 'Die Hauptdomain kann nicht mit den Webbenutzern verschoben werden.',
    'domain_merge_err_root_exists' => 'Der Zielpfad "%1" ist bereits vorhanden.',

    'database_server_edit_used_for_psa' => 'Aktualisieren des lokalen MariaDB/MySQL-Datenbankservers ist nicht zulässig.',
    'suggest_repair_main_suggestion_ui' => '<b>Sie können diesen Fehler</b> mithilfe des Dienstprogramms `plesk repair` beheben.',
    'suggest_repair_main_suggestion_cli' =>  'Sie können diesen Fehler mithilfe des Dienstprogramms `plesk repair` beheben.',
    'suggest_repair_repair_kit_link_title' => 'gehen Sie zu "Diagnose und Reparatur"',
    'suggest_repair_using_cli_and_ui' => 'Führen Sie dazu entweder den Befehl `plesk repair %1` über die Befehlszeilenschnittstelle aus oder %2 und klicken Sie neben "Plesk Datenbank" auf "Reparieren".',
    'suggest_repair_using_cli' => 'Führen Sie dazu den Befehl `plesk repair %1`über die Befehlszeilenschnittstelle aus.',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Der DNS-Dienst war nicht verfügbar, als das Backup erstellt wurde. Es sind jedoch aktive DNS-Zonen im Backup vorhanden. Sie werden für die folgenden Objekte aktiviert: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Ressourcenkontrolle (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Unterstützung von SmarterMail-Remoteservern',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(aufgrund des Lizenzschlüssels nicht zulässig)',
    'plesk_key__validation_failed' => '%1 (Fehlercode: %2)',
    'promo__button_details' => 'Details',
    'promo__extension_catalog_title' => 'Katalog der Erweiterungen',
    'promo__extension_catalog_description' => 'Sehen Sie sich den neuen Katalog der Erweiterungen an und halten Sie Plesk mit einer Vielzahl leistungsstarker Erweiterungen auf dem neuesten Stand.',
    'promo__button_open_catalog' => 'Katalog öffnen',

    'backup__repository_check_login' => "Zugriff auf Speicher nicht möglich: %1 Vergewissern Sie sich, dass Sie die korrekten Anmeldedaten für den Speicher eingegeben haben.",
    'backup__repository_check_error_list' => "Zugriff auf Speicher nicht möglich: %1 Vergewissern Sie sich, dass Sie die korrekten Speichereinstellungen eingegeben haben.",
    'backup__repository_check_error_mkdir' => "Das Verzeichnis kann nicht erstellt werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Erstellen von Ordnern im Speicher haben.",
    'backup__repository_check_error_upload' => "Datei kann nicht in den Speicher hochgeladen werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Hochladen von Dateien im Speicher haben.",
    'backup__repository_check_error_download' => "Datei kann nicht aus dem Speicher heruntergeladen werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Hoch- und Herunterladen von Dateien im Speicher haben.",
    'backup__repository_check_error_resume-upload' => "Hochladen der Datei in den Speicher kann nicht fortgesetzt werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Fortsetzen von Uploads im Speicher haben.",
    'backup__repository_check_error_resume-download' => "Download der Datei aus dem Speicher kann nicht fortgesetzt werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Fortsetzen von Downloads im Speicher haben.",
    'backup__repository_check_error_enable-utf8' => "Speicher kann nicht verarbeitet werden: %1 Überprüfen Sie, ob der Speicher die UTF-8-Kodierung unterstützt.",
    'backup__repository_check_error_rm' => "Speicher kann nicht verarbeitet werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Löschen von Dateien im Speicher haben.",
    'backup__repository_check_error_rmdir' => "Speicher kann nicht verarbeitet werden: %1 Überprüfen Sie, ob Sie Berechtigungen zum Löschen von Ordnern im Speicher haben.",

    'backup__ftp_repository_check_login' => "%1 Sie können dies unabhängig mit dem folgenden Befehl überprüfen: %2",
    'backup__ftp_repository_check_error_list' => "%1 Sie können dies unabhängig mit dem folgenden Befehl überprüfen: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Sie können dies unabhängig mit dem folgenden Befehl überprüfen: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Sie können dies unabhängig mit den folgenden Befehlen überprüfen: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Sie können dies unabhängig mit den folgenden Befehlen überprüfen: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Sie können dies unabhängig mit den folgenden Befehlen überprüfen: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Sie können dies unabhängig mit den folgenden Befehlen überprüfen: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Sie können dies unabhängig mit dem folgenden Befehl überprüfen: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Sie können dies unabhängig mit den folgenden Befehlen überprüfen: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Sie können dies unabhängig mit den folgenden Befehlen überprüfen: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Einstellungen für DMARC können nicht geändert werden. Um diese Option zu aktivieren, aktivieren Sie den DKIM- und SPF-Spamschutz.',
    'spf_server_wide_disable_failed' => 'Die Einstellungen für den SPF-Spamschutz können nicht geändert werden. Um SPF zu deaktivieren, deaktivieren Sie DMARC für eingehende E-Mails.',
    'sfdk_server_wide_verify_disable_failed' => 'Die Einstellungen für den DKIM-Spamschutz können nicht geändert werden. Um DKIM zu deaktivieren, deaktivieren Sie DMARC für eingehende E-Mails.',

    'ccs_not_supported' => 'Der zentrale Zertifikatspeicher von IIS ist nicht auf dem System konfiguriert.',
    'ccs_not_enabled' => 'Die Verwaltung des zentralen Zertifikatspeichers von IIS ist nicht aktiviert in Plesk.',
    'ad_not_supported' => 'Der Server ist nicht mit einer Domain verknüpft.',

    'component_name__appinit' => "Anwendungsinitialisierung",
    'component_name__cors' => "Cross-Origin Resource Sharing",
    'component_name__httpcompression' => 'Komprimierung von HTTP-Inhalt',
    'common_feature_is_not_supported' => 'Die Funktion wird nicht mehr unterstützt.',
    'common_feature_is_not_supported_in_proto' => 'Diese Funktion wird nicht für die Protokollversion %1 unterstützt.',
    'autoinstaller__plesk_component' => 'Plesk Komponente',
    'plesk_key__key_expired' => 'Ihr Lizenzschlüssel ist abgelaufen. Um Plesk weiterhin verwenden zu können, müssen Sie einen nicht ablaufenden kommerziellen %1 erwerben.',
    'plesk_key__key_purchase' => 'Lizenzschlüssel',

    'sa_action_move' => 'Spam in den Junk-E-Mail-Ordner verschieben',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-Anwendung werden nicht mehr unterstützt. Sie sind für die folgenden Websites nicht verfügbar: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobile Versionen von Websites, die mit UNITY Mobile gehostet werden, werden nicht mehr unterstützt. Sie sind für die folgenden Websites nicht verfügbar: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Die Richtlinie zur serverweiten Nutzung erlaubt keine persönlichen Antiviren-Einstellungen. Sie werden nicht vollständig für E-Mail-Konten auf den folgenden Domains wiederhergestellt: {{objects}}',

    'module__not_installed' => "Die Erweiterung %1 ist nicht installiert",

    'mail__mail_autodiscovery_server_error' => 'Geben Sie einen benutzerdefinierten Domainnamen für E-Mail-Erkennung an:',
    'mail__error_mail_autodiscovery_enable' => 'Automatische E-Mail-Erkennung kann nicht eingerichtet werden: %1',
    'mail__error_mail_autodiscovery_server' => 'Benutzerdefinierter Domainname für E-Mail-Erkennung kann nicht festgelegt werden: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'DNS-Einträge für die automatische Erkennung von Domains kann nicht erneut konfiguriert werden: %1',

    '__invalid_url' => 'URL "%1" ist ungültig',
    'actionlog__cloning_start' => 'Start',
    'actionlog__event_cloning_start' => 'Klonen des Servers beginnt',

    '__UPLOAD_ERR_FORM_SIZE' => "Hochgeladene Datei übersteigt die zugelassene Größe",
    '__UPLOAD_ERR_INI_SIZE' => "Hochgeladene Datei übersteigt die zugelassene Größe",
    '__UPLOAD_ERR_NO_FILE' => "Keine Datei empfangen",
    '__UPLOAD_ERR_OK' => "Datei erfolgreich hochgeladen",
    '__UPLOAD_ERR_PARTIAL' => "Die Datei wurde nur teilweise hochgeladen, bitte versuchen Sie es erneut.",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Temporärer Ordner fehlt',
    '__UPLOAD_ERR_CANT_WRITE' => 'Datei konnte nicht auf Datenträger geschrieben werden',
    '__UPLOAD_ERR_UNKNOWN' => 'Ein unbekannter Datei-Upload-Fehler ist aufgetreten',
    '__accounts' => "Konten",
    '__access' => "Zugriff",
    '__address' => "Adresse",
    '__addresses' => "Adressen",
    '__acl_records' => 'ACL-Einträge',
    '__admin_repository' => "Administrator-Repository",
    '__all' => 'Alle',
    '__allowed' => "Erlaubt",
    '__anonftp_status' => "Anonymous FTP",
    '__antispam' => "Antispam",
    '__apache_restart' => "...%1 Webserver wird neu gestartet, bitte warten...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET-Unterstützung",
    '__asp_win_support' => "Microsoft ASP-Unterstützung",
    '__attachments' => "Anhänge",
    '__attachments_list' => "Anhänge",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Ein Autoresponder mit dem Namen %1 existiert bereits.",
    '__autoresponder' => "Autoresponder",
    '__autoresponders' => "Autoresponder",
    '__autoresponders_list' => "Autoresponder",
    '__autoresponder_attachment_files' => "Anhangdateien zur automatischen Antwort",
    '__auto_updates_list' => 'Verfügbare Updates',
    '__avail' => "Verfügbar",
    '__backup_utilites' => "Backup-Dienstprogramme",
    '__bind_status' => "DNS-Serverstatus",
    '__bu_is_not_installed' => "Dieser Service ist im Moment nicht verfügbar, da die Backup-Serviceprogramme nicht installiert sind.",
    '__bu_not_support_in_key' => "Der Lizenzschlüssel unterstützt keine Backups.",
    '__notifications_not_support_in_key' => 'Der Lizenzschlüssel unterstützt keine Benachrichtigungen',
    'disabled_by_key' => 'Von Ihrem Lizenzschlüssel nicht unterstützt',
    '__bytes' => "Bytes",
    '__can_not_use_reserved_words' => "Sie können die reservierten Wörter nicht verwenden.",
    '__certificate' => "Zertifikat",
    '__cgi_support' => "CGI-Unterstützung",
    '__change_date' => "Änderungsdatum",
    '__city' => "Stadt",
    '__cl_not_exist' => "Das Kundenkonto existiert nicht.",
    '__client' => 'Kunde',
    '__client_card' => "Kundenkarte",
    '__client_contact_name' => "Name des Kontakts",
    '__client_form' => "Persönliche Daten",
    '__client_ip_pool' => "IP-Pool des Kunden",
    '__client_limits' => "Grenzen des Kundenkontos",
    '__client_permissions' => "Kundenberechtigungen",
    '__client_preferences' => "Einstellungen des Kunden",
    '__client_status' => "Kundenstatus",
    '__client_name' => "Kundenname",
    '__client_total' => "Kunden insgesamt",
    '__client_with_login_name_already_exists' => "Ein Benutzer mit dem Benutzernamen \"%1\" existiert bereits.",
    '__client_domuser_with_login_already_exists' => "Der Benutzername \"%1\" wird bereits vom Administrator der Domain \"%1\" verwendet.",
    '__clients_global_changes' => "Ausgewählte Kundenkonten bearbeiten",
    '__clients_list' => "Kunden",
    '__cmd_not_found' => "Unbekannter Befehl: %1",
    '__comments' => "Anmerkungen",
    '__company_name' => "Firmenname",
    '__component_version' => "Komponentenversion",
    '__component_not_installed' => "Komponente %1 wurde nicht installiert",
    '__confirm_del' => "Sie müssen das Löschen bestätigen.",
    '__confirm_overwrite' => "Überschreiben bestätigen.",
    '__confirm_stop' => "Sie müssen das Stoppen des Prozesses bestätigen.",
    '__confirm_passwd' => "%1 Passwort bestätigen",
    '__confirm_removal' => "Entfernen bestätigen",
    '__conhelp' => "Beschreibung",
    '__contact_name' => "Name des Kontakts",
    '__country' => "Land",
    '__countries' => 'Land',
    '__country_unknown' => 'Ländercode für Spracheinstellung kann nicht erkannt werden.',
    '__courier-imap' => 'Courier-Server',
    '__create_domain' => 'Domain erstellen',
    '__crypted' => 'verschlüsselt',
    '__cp_access' => "Zugang zu Plesk",
    '__cp_user' => "Plesk Benutzer",
    '__create' => "Erstellen",
    '__create_client_template_without_template' => "Benutzerkonto ohne Template erstellen",
    '__create_domain_for' => "Domain erstellen für <b>%1</b>",
    '__create_domain_template_without_template' => "Domain ohne Vorlage erstellen",
    '__creation_date' => "Erstellungsdatum",
    '__crontab_unix' => "Planer",
    '__crontab_win' => "Planer",
    '__ct_month_jan' => 'Januar',
    '__ct_month_feb' => 'Februar',
    '__ct_month_mar' => 'März',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Mai',
    '__ct_month_jun' => 'Juni',
    '__ct_month_jul' => 'Juli',
    '__ct_month_aug' => 'August',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'Dezember',
    '__custom_button' => "Benutzerdefinierte Schaltfläche",
    '__custom_buttons_list' => "Links zu zusätzlichen Services",
    '__daily' => "Täglich",
    '__database_not_activated' => "%1 wurde auf der Server Administrationsseite nicht aktiviert.",
    '__database_not_installed' => "Datenbank %1 ist nicht installiert.",
    '__database_not_run' => "Datenbank %1 läuft nicht.",
    '__database_is_corrupt' => "Die Plesk Datenbank ist beschädigt. Bitte starten Sie das Dienstprogramm Reconfigurator, um sie zu reparieren.",
    '__databases' => "Datenbanken",
    '__databases_list' => "Datenbanken",
    '__database_type_not_supported_by_key' => 'In Ihrem Lizenzschlüssel muss die Unterstützung von %1 Servern enthalten sein, um einen solchen Server nutzen zu können. Wenden Sie sich an Ihren Plesk Vertriebsmitarbeiter.',
    '__date_immediately' => "heute",
    '__date_never' => "nie",
    '__day(s)' => "Tag(e)",
    '__day0' => "So",
    '__day1' => "Mo",
    '__day2' => "Di",
    '__day3' => "Mi",
    '__day4' => "Don",
    '__day5' => "Fr",
    '__day6' => "Sa",
    '__days' => "%1 Tag(e)",
    '__db_admin_login_empty' => "Sie haben keinen Benutzernamen angegeben. Steuerung über %1 wird in der Oberfläche deaktiviert. Wollen Sie trotzdem fortfahren?",
    '__db_unable_to_unregister' => 'Entfernen der Parameter der Datenbankverbindung nicht möglich',
    '__db_db_exists' => 'Es ist mindestens eine Datenbank auf dem Server vorhanden.',
    '__db_unable_to_change_server_name' => 'Name des Servers kann nicht geändert werden.',
    '__db_unable_to_change_port' => 'Port für den Server kann nicht geändert werden.',
    '__db_already_exist' => "Datenbank %1 existiert bereits.",
    '__db_credentials_invalid' => "Zugangsdaten für Datenbank sind ungültig.",
    '__db_invalid_password_characters' => 'Das Passwort enthält ungültige Zeichen',
    '__db_engine' => "Datenbank-Engine", // indirect
    '__db_type' => "Datenbanktyp",
    '__db_user' => "Datenbankbenutzer",
    '__db_server' => 'Datenbankserver',
    '__def_domain' => "Standarddomain",
    '__default_for_mysql' => 'Standard für MySQL',
    '__default_for_mariadb' => 'Standard für MariaDB',
    '__default_for_percona' => 'Standard für Percona',
    '__default_for_postgresql' => 'Standard für PostgreSQL',
    '__delete' => "Löschen",
    '__demo' => "Diese Funktion ist in der Demoversion nicht verfügbar.",
    '__directory' => "Verzeichnis",
    '__disable_lock_screen' => 'Benutzer dürfen erst mit Plesk arbeiten, wenn die Oberfläche vollständig geladen ist',
    '__dismiss_news?' => "Möchten Sie den News-Block wirklich schließen?\n\nDer News-Block wird nicht mehr angezeigt, bis neue Nachrichten eintreffen.",
    '__description' => "Beschreibung",
    '__disabled' => "deaktiviert",
    '__disk_space_limit' => "Speicherplatzlimit",
    '__cgroups_cpu_usage_limit' => 'Grenzwert für CPU-Nutzung',
    '__cgroups_ram_usage_limit' => 'Grenzwert für RAM-Nutzung',
    '__cgroups_disk_read_usage_limit' => 'Grenzwert der Bandbreite zum Lesen auf dem Datenträger',
    '__cgroups_disk_write_usage_limit' => 'Grenzwert der Bandbreite zum Schreiben auf dem Datenträger',
    '__disk_usage_by' => "Speicherplatz-Auslastung für %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS-Eintrag '%1' ist bereits vorhanden.",
    '__dns_master_should_be_remote' => "Sie sollten zwei unterschiedliche Autorisierungs-Nameserver auf separaten Hosts haben.",
    '__dns_record_not_exist' => "DNS-Eintrag existiert nicht.",
    '__dns_server' => "DNS-Server", // indirect
    '__dom_id_is_undefined' => "Domain-ID ist nicht definiert.",
    '__dom_name' => "Domainname",
    '__dom_name_is_invalid' => "Domainname ist ungültig. Stellen Sie bitte sicher, dass Ihr Domainname nur alphanumerische Zeichen, Punkte und Bindestriche enthält und eine maximale Länge von 255 Zeichen hat. Jeder Teil des Domainnamens zwischen Punkten darf nicht länger als 63 Zeichen sein.",
    '__dom_not_exist' => "Domain existiert nicht.",
    '__domain' => "Domain",
    '__domain_' => 'Domain %1',
    '__domain_form' => "Domain-Formular",
    '__domain_id' => "Domain-ID",
    '__domain_is_turned_off_for_backup' => "Die Website %1 ist für Backup/Wiederherstellung vorübergehend deaktiviert und nicht verfügbar.",
    '__domain_limits' => "Domaingrenzen",
    '__domain_name' => "Domainname",
    '__mail_name_in_ASCII_form' => "Name des E-Mail-Kontos im ASCII-Format",
    '__message_error' => 'Fehler',
    '__message_warning' => 'Warnung',
    '__message_info' => 'Information',
    '__domain_name_in_ASCII_form' => "Domainname im ASCII-Format",
    '__domain_repository' => "Repository von Domain %1",
    '__domain_status' => "Domainstatus",
    '__domain_found_tech' => "Technologie auf der Domain gefunden",
    '__domain_dns' => 'Domain-DNS-Zone',
    '__domain_total' => "Gesamtmenge für das Abonnement",
    '__domain_total_powerUser' => "Gesamtmenge für das Abonnement",
    '__domain_user' => "Domainbenutzer",
    '__domains_global_changes' => "Gruppenvorgänge bei Domains",
    '__mailnames_global_changes' => "Ausgewählte E-Mail-Konten modifizieren",
    '__backup_manager' => 'Backup-Manager',
    '__domains_list' => "Domains",
    'domains_list__list_header' => "Domains",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Die Domain beginnt mit www, obwohl der Präfix WWW verwendet wird. \nTrotzdem fortfahren?",
    '__dovecot' => 'Dovecot IMAP- und POP3-Server',
    '__dsmail' => "E-Mail-Service",
    '__dsmaillist' => "Mailinglisten-Service",
    '__dumps_tot_size' => "Gesamtgröße der Backupdateien im lokalen Speicher",
    '__email' => "E-Mail-Adresse",
    '__email_addr_is_invalid' => "E-Mail-Adresse ist ungültig.",
    '__enabled' => "aktiviert",
    '__enter_cert_text' => "Geben Sie den Zertifikatstext ein",
    '__enter_size' => "Geben Sie die Größe an",
    '__exclusive' => "Dediziert",
    '__expiration_date' => "Ablaufdatum",
    '__fax' => "Fax",
    '__file' => "Datei",
    '__file_is_empty' => "Die Datei ist leer.",
    '__file_name' => "Dateiname",
    '__file_type' => 'Dateityp',
    '__filemanager' => "Dateimanager",
    '__filepath_is_empty' => "Pfad zu Datei ist leer",
    '__files_list' => "Dateien",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-Einstellungen",
    '__ftp_serv' => "FTP-Server", // indirect
    '__ftp_server_parameters_are_empty' => "Zuerst müssen Sie die Eigenschaften des FTP-Kontos konfigurieren!",
    '__ftp_status' => "FTP-Serverstatus",
    '__full_day0' => "Sonntag",
    '__full_day1' => "Montag",
    '__full_day2' => "Dienstag",
    '__full_day3' => "Mittwoch",
    '__full_day4' => "Donnerstag",
    '__full_day5' => "Freitag",
    '__full_day6' => "Samstag",
    '__full_month1' => "Januar",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "Dezember",
    '__full_month2' => "Februar",
    '__full_month3' => "März",
    '__full_month4' => "April",
    '__full_month5' => "Mai",
    '__full_month6' => "Juni",
    '__full_month7' => "Juli",
    '__full_month8' => "August",
    '__full_month9' => "September",
    '__giga' => "G",
    '__group' => "Gruppe",
    '__h' => "H",
    '__hard_disk_quota' => "Speicherplatzkontingent",
    '__hard_disk_quota_not_supported' => 'Speicherkontingent wird aufgrund der Einstellungen im Server-Dateisystem nicht unterstützt',
    '__header_text_is_invalid' => "Der Titel des geschützten Bereichs ist ungültig.",
    '__help_topic_not_found' => 'Das angeforderte Hilfethema (%1) existiert nicht.',
    '__hosting_ip_dns_ip_not_equiv' => "Keine der IP-Adressen, die in den A-DNS-Einträgen angegeben sind, passt zu der IP-Adresse, die für das Hosting genutzt wird",
    '__hosting_scripting' => "Hosting-Scripting-Unterstützung",
    '__hosting_setup_page_title' => "Erstellungsseite für physisches Hosting für die Domain %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Hosting-Typ",
    '__hostname_is_empty' => "Hostname ist leer.",
    '__hour(s)' => 'Stunde(n)',
    '__hst_type_incorrect' => "Hosting-Typ nicht korrekt.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Ruhezeit",
    '__iface' => "Schnittstelle",
    '__image' => "Bild",
    '__imap_status' => "IMAP-Serverstatus",
    '__in' => "In",
    '__in_%' => "in %",
    '__incorrect_databases_login_pass' => "Sie haben bei der Datenbankkonfiguration falsche Angaben für Login und/oder Passwort gemacht.",
    '__incorrect_ip_or_network_address' => 'IP- oder Netzwerkadresse ungültig.',
    '__info' => 'Info',
    '__install' => "Installieren",
    '__install_prefix' => "Installationspräfix",
    '__invalid_cert_id' => "Ungültige Zertifikats-ID",
    '__invalid_context' => "Ungültiger Kontext: %1",
    '__invalid_db_usr_name' => "Datenbankbenutzername ist ungültig.",
    '__invalid_dir_name' => "Verzeichnisname ist ungültig.",
    '__invalid_dom_name' => "Domainname ist ungültig.",
    '__invalid_filename' => "Ungültiger Dateiname. Verwenden Sie keine einzelnen Anführungszeichen und/oder keine \"../\"-Kombination.",
    '__invalid_id' => "Ungültige ID.",
    '__invalid_lines_num' => "Ungültiger Wert für die Anzahl an Zeilen. Es sind nur Zahlen zulässig.",
    '__invalid_max_letter_size' => "Maximale Nachrichtengröße ist ungültig.",
    '__invalid_pdir_name' => "Name des geschützten Verzeichnisses ist ungültig.",
    '__invalid_restart_apache_interval' => "Apache-Neustartintervall ist ungültig.",
    '__invalid_tmpl_name' => "Template-Name ist ungültig.",
    '__invalid_value' => "Wert ist ungültig.",
    '__ip_addr' => "IP-Adresse",
    '__ip_address_and_mask' => "IP-Adresse und Subnetzmaske",
    '__ip_alias__mask' => "IP-Adresse und Subnetzmaske",
    '__ip_addr_is_invalid' => "IP-Adresse ist ungültig.",
    '__ip_addr_list' => "IP-Adressen",
    '__ip_address_and_mask_hint' => 'Zum Beispiel %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KB",
    '__key_for_virtuozzo_only' => "Ihr Lizenzschlüssel eignet sich nur zur Verwendung in Virtuozzo Containern.",
    '__key_limits_exceeding' => "Diese Aktion überschreitet die Grenzen Ihres Software-Lizenzschlüssel. Wenn Sie diese Meldung erhalten, kontaktieren Sie Ihren Provider oder den Hersteller, um die Grenzen der Lizenz zu abzuklären oder zu erhöhen.",
    '__kilo' => "K",
    '__keywords' => 'Schlüsselwörter',
    '__lang_unknown' => 'Sprache kann nicht erkannt werden.',
    '__languages' => 'Sprache',
    '__learn_more' => 'Mehr erfahren',
    '__loading' => 'Lade...',
    '__locales' => "Sprachpakete",
    '__lists' => "Mailinglisten",
    '__literal_bytes' => "B",
    '__processing' => "Bitte haben Sie Geduld.<br>Laden...",
    '__locale' => "Sprache der Oberfläche",
    '__locale_is_not_defined' => "Sprache der Benutzeroberfläche ist nicht definiert.",
    '__local_server_mysql' => 'Lokaler MariaDB/MySQL-Server',
    '__local_server_postgresql' => 'Lokaler PostgreSQL Server',
    '__local_server_mssql' => 'Lokaler MS SQL-Server',
    '__log_and_statistics_files' => 'Protokolldateien und statistische Berichte',
    '__config_files' => 'Konfigurationsdateien',
    '__chroot_files' => 'chrooted-Umgebung',
    '__login' => "%1 Login",
    '__login1' => "Benutzername",
    '__login_disabled' => "Login nicht erlaubt",
    '__login_enabled' => "Login erlaubt",
    '__login_incorrect' => "Sie haben einen falschen Benutzernamen oder ein falsches Passwort eingegeben.",
    '__login_name' => "%1 Benutzername",
    '__login_name_is_invalid' => "%1 Benutzername ist ungültig.",
    '__logon_time' => "Anmeldezeit",
    '__ma' => "E-Mail-Aliase",
    '__mail' => "E-Mail",
    '__mail_alias_name' => "E-Mail-Alias-Name",
    '__mail_autodiscovery' => 'Automatische E-Mail-Erkennung',
    '__mail_exchanger_name_is_invalid' => "Mail-Exchanger-Name ist ungültig.",
    '__mail_groups' => "Mailgruppen",
    '__mail_list_engine' => "Mailinglistensoftware",
    '__mail_name' => "E-Mail-Konto",
    '__mail_name_form' => "Eigenschaften des E-Mail-Kontos",
    '__mail_names' => "E-Mail-Konten",
    '__mail_serv' => "Mailserver",
    '__mail_user' => 'E-Mail-Benutzer',
    '__mailgroup' => "Mailgruppe",
    '__maillist' => "Mailingliste",
    '__maillists' => "Mailinglisten",
    '__maillist_member' => 'Mailinglisten-Mitglied',
    '__mailname' => "E-Mail-Konto",
    '__mailname_redir_self' => "Das E-Mail-Konto kann keine E-Mails an die eigene Adresse weiterleiten.",
    '__max_dom_num_reached_for_cl' => "Die Grenze für die Anzahl an Domains für dieses Kundenkonto wurde erreicht",
    '__max_file_size_available' => "Die maximale Dateigröße beträgt %1",
    '__max_subdom_num_reached_for_cl' => "Die Grenze für die Anzahl an Subdomains für dieses Kundenkonto wurde erreicht",
    '__max_subdom_num_reached_for_dom' => "Die Grenze für die Anzahl an Subdomains wurde für diese Domain erreicht.",
    '__max_subdom_num_reached_for_key' => "Die im Lizenzschlüssel festgelegte Grenze für die Anzahl an Subdomains wurde erreicht.",
    '__max_traffic_limit' => "Traffic-Grenze",
    '__maximum_excl_ip_num' => "E-Mail-Konten",
    '__mb' => "MB",
    '__mbytes' => "Megabytes",
    '__mb_month' => "MB/Monat",
    '__mb_sec' => "MB/s",
    '__gb_sec' => "GB/s",
    '__tb_sec' => "TB/s",
    '__mega' => "M",
    '__minute(s)' => 'Minute(n)',
    '__mls_not_in_key' => "Ihr Produktschlüssel unterstützt nicht mehrere Sprachen.",
    '__modification_date' => "Änderungsdatum",
    '__module' => "Erweiterung",
    '__month' => "Monat",
    '__month(s)' => "Monat(e)",
    '__month1' => "Jan.",
    '__month10' => "Okt.",
    '__month11' => "Nov.",
    '__month12' => "Dez.",
    '__month2' => "Febr.",
    '__month3' => "März",
    '__month4' => "April",
    '__month5' => "Mai",
    '__month6' => "Juni",
    '__month7' => "Juli",
    '__month8' => "Aug.",
    '__month9' => "Sept.",
    '__monthly' => "Monatlich",
    '__months' => "Monate",
    '__moved_permanently' => 'Dauerhaft verschoben',
    '__mssql' => "Microsoft SQL-Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Name des Microsoft SQL-Servers",
    'mssql__unable_to_change_server_name_db_exists' => "Name des Servers kann nicht geändert werden: es befindet sich dort mindestens eine Datenbank.",
    '__mssql_status' => "Microsoft SQL-Serverstatus",
    '__multiply_login_deny' => "Sie konnten nicht angemeldet werden. Ein anderer Benutzer mit demselben Benutzernamen (%1) ist bereits bei Plesk angemeldet.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL-Serverstatus",
    '__mysql_version' => "MySQL-Version",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB-Serverstatus",
    '__mariadb_version' => "MariaDB-Version",
    '__percona' => "Percona",
    '__percona_status' => "Percona-Serverstatus",
    '__percona_version' => "Percona-Version",
    '__name' => "Name",
    '__name_invalid' => "Name ist ungültig.",
    '__nameserver' => "Nameserver",
    '__network' => "Netzwerk",
    '__networks' => "Netzwerke",
    '__no' => "Nein",
    '__no_ip_address_with_properly_type_available' => "Die gesicherten Daten können nicht wiederhergestellt werden, da die für die Wiederherstellung erforderlichen IP-Adressen nicht vorhanden sind.",
    '__no_clients_specified' => "Keine Kundenkonten angegeben.",
    '__no_comments' => "Keine Kommentare.",
    '__nologin' => "Verboten",
    '__none' => "Ohne",
    '__not_configured' => "Nicht konfiguriert",
    '__not_implemented_yet' => "Noch nicht implementiert",
    '__not_supported_by_ftp' => "(wird vom FTP-Server nicht unterstützt)",
    '__notification' => "Benachrichtigung",
    '__num_displayed' => "%1 von %2 angezeigt",
    '__num_is_invalid' => "Anzahl ist ungültig.",
    '__object_not_found' => 'Objekt nicht gefunden: %1',
    '__of_all' => "% von allen",
    '__off' => "Aus",
    '__ok' => "OK",
    '__old_passwd' => "Altes %1 Passwort",
    '__on' => "An",
    '__others' => "Andere",
    '__other_ip__will_be_added' => 'Andere verfügbare IP-Adressen (werden zum IP-Pool des Kunden hinzugefügt)',
    '__out' => "Aus",
    '__p' => "P",
    '__passwd' => "%1 Passwort",
    '__passwd_is_invalid' => "%1 Passwort ist ungültig.",
    '__passwd_not_match' => "Passwörter stimmen nicht überein!",
    '__path' => "Pfad",
    '__perl_unix_support' => "Perl-Unterstützung",
    '__perl_win_support' => "Perl-Unterstützung",
    '__perm_denied' => "Zugriff verweigert.",
    '__permissions' => "Berechtigungen",
    '__personal_name' => "Persönlicher Name",
    '__pg_admin_not_activated' => "PostgreSQL wurde in der Serveradministration nicht aktiviert.",
    '__pg_not_inst' => "PostgreSQL wurde nicht installiert.",
    '__pg_not_run_or_inst' => "PostgreSQL wurde nicht installiert oder läuft nicht.",
    '__pg_not_support_in_key' => "PostgreSQL wird vom Lizenzschlüssel nicht unterstützt",
    '__phone' => "Telefonnummer",
    '__phosting' => "Physisches Hosting",
    '__php_support' => "PHP-Unterstützung",
    '__php_run_as_isapi' => "läuft als ISAPI-Erweiterung",
    '__php_safe_mode' => "PHP 'safe_mode' aktiviert",
    '__php_version' => "PHP-Version",
    '__physical' => "Physisches Hosting",
    '__plesk_stat_pdir' => "Verzeichnis '/plesk-stat/webstat/' schützen",
    '__plesk_stat_dir_name' => "Domainstatistiken",
    '__plesk_stat_protect' => "Zugriff auf Webstatistiken mit meinem FTP-Benutzernamen und Passwort schützen",
    '__plesk_stat_protect_install' => "zugänglich über das geschützte Verzeichnis '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3-Serverstatus",
    '__popen_error' => "Beim Aufruf der Funktion 'popen' ist ein Fehler aufgetreten.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL-Status",
    '__preferences' => "Einstellungen",
    '__account_preferences' => "Kontoeinstellungen",
    '__interface_preferences_general' => 'Allgemein',
    '__interface_preferences_default' => 'Standard-Oberflächeneinstellungen',
    '__interface_preferences_admin' => "Einstellungen für Administratoroberfläche",
    '__interface_template' => 'Template zur Oberflächenanpassung',
    '__interface_preferences' => "Oberflächeneinstellungen",
    '__proceed?' => "Fortfahren?",
    '__protect_dir_user' => "Benutzer des geschützten Verzeichnisses",
    '__protect_dir_users' => "Benutzer des geschützten Verzeichnisses",
    '__provider_contact_name' => "Name des Besitzers",
    '__python_unix_support' => "Python-Unterstützung",
    '__python_win_support' => "Python-Unterstützung",
    '__quota' => "Kontingent",
    '__r' => "R",
    '__reconfigure' => "Neu konfigurieren",
    '__record_type' => "Eintragstyp",
    '__release' => "Release",
    '__remote_db_not_supported_by_key' => 'Remote-Datenbankhosting wird von Ihrem Lizenzschlüssel nicht unterstützt.',
    '__remove' => "Entfernen",
    '__remove_confirmation' => "Entfernen bestätigen",
    '__remove_protection' => 'Schutz entfernen',
    '__report' => "Bericht",
    '__report_size_na' => "Service ist nicht verfügbar",
    '__reports_list' => "Berichte",
    '__requested' => "Angefordert",
    '__required_fields' => "Erforderliche Felder",
    '__resp_name_invalid' => "Der Autoresponder ist ungültig. Verwenden Sie nur alphanumerische Zeichen, Punkte, Unterstriche und Leerzeichen als Zeichen.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Servername ist ungültig.",
    '__screenshots' => 'Screenshots',
    '__script_warning' => "Wenn die Skriptfunktionalität aus dieser Domain entfernt wird, werden alle betroffenen Skripte beim Aufruf als Text im Browser angezeigt. Es empfiehlt sich für den Administrator, alle betroffenen Skripte von dieser Domain zu entfernen.",
    '__sec' => "Sekunden",
    '__second(s)' => "Sekunde(n)",
    '__see_list_of_logged_in' => "Liste der momentan angemeldeten Benutzer anzeigen.",
    '__select_certs_to_remove' => "Wählen Sie die Zertifikate aus, die entfernt werden sollen.",
    '__select_files_to_remove' => "Wählen Sie die Dateien aus, die entfernt werden sollen.",
    '__select_ip' => "IP-Adresse zuweisen",
    '__select_ip_to_remove' => "Wählen Sie eine IP-Adresse aus, die entfernt werden soll.",
    '__select_domain_template' => "Domain-Template-Einstellungen verwenden",
    '__select_templates_to_remove' => "Wählen Sie die Templates aus, die entfernt werden sollen.",
    '__server' => "Server",
    '__server_total' => "Server gesamt",
    '__service' => "Dienst",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MariaDB/MySQL-Datenbankserver",
    '__service_description__mysql' => "MariaDB/MySQL-Datenbankserver",
    '__service_title__web' => "Webserver",
    '__service_description__web' => "Webserver",
    '__service_title__smtp' => "SMTP-Server",
    '__service_description__smtp' => "SMTP-Server",
    '__service_title__mail' => "IMAP-/POP3-Server",
    '__service_description__mail' => "IMAP-/POP3-Server",
    '__service_title__dns' => "DNS-Server",
    '__service_description__dns' => "DNS-Server",
    '__service_title__postgresq' => "PostgreSQL-Datenbankserver",
    '__service_description__postgresq' => "PostgreSQL-Datenbankserver",
    '__service_title__spamassassin' => "SpamAssassin-Spamfilter-Service",
    '__service_description__spamassassin' => "SpamAssassin-Spamfilter-Service",
    '__services' => "Dienstleistungen",
    '__all_services' => "Alle Services",
    '__sessions' => "Sitzungen",
    'sessions__feature_ftp_session_manager_not_supported' => "Feature für FTP-Sitzungen wird vom aktuellen FTP-Server nicht unterstützt",
    '__sessions_list' => "Sitzungen",
    '__set' => "Aktivieren",
    '__shared' => "Gemeinsam genutzt",
    '__shell_access_warning' => "Das Zulassen von Shellzugriff ist gefährlich für die Systemsicherheit. Erlauben Sie Shellzugriff nur, wenn Sie genau wissen was Sie tun. Geben Sie den Zugriff nur vertrauten Benutzern. Möchten Sie den Shellzugriff wirklich erlauben?",
    '__siteapp_not_support_in_key' => "Der Lizenzschlüssel unterstützt keine Webanwendungen",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Die Konfiguration dieser Webanwendung wurde manuell geändert. Zum Schutz der manuellen Modifizierungen ist eine Neukonfiguration durch Plesk nicht möglich.',
    '__site_management' => "Web-Publishing", // indirect
    '__size' => "Größe",
    '__skeleton' => 'Template für virtuelle Hosts',
    '__skins' => 'Oberflächen',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP-Serverstatus",
    '__some_fields_are_empty_or_invalid' => "Einige Felder sind leer oder enthalten einen ungültigen Wert.",
    '__unable_to_set_parameters' => "Die Parameter der Komponente können nicht eingestellt werden.",
    '__spamassassin' => "Spamfilter",
    '__spamassassin_status' => "SpamAssassin-Status",
    '__spamd_status' => 'SpamAssassin-Status',
    '__splited_backup' => "(aufgeteiltes Backup)",
    '__split_backup_file' => "Backup über mehrere Datenträger erstellen",
    '__split_backup_size' => "Datenträgergröße",
    '__split_backup_less_than_500' => "Volumengrößen unter 500 MB werden nicht unterstützt",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI-Unterstützung",
    '__ssi_with_html' => "SSI verwenden für *.htm-, *.html-Dateien",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-Unterstützung",
    '__same_ssl' => "Ein einziges Verzeichnis für Inhalte mit und ohne SSL/TLS verwenden",
    '__same_ssl_cu' => "Gemeinsamer Inhalt mit und ohne SSL/TLS",
    '__state' => "US-Staat/Provinz/Region",

    '__status__Active' => 'Aktiv',
    '__status__active' => 'aktiv',
    '__status__Passive' => 'Ausgeschaltet',
    '__status__passive' => 'deaktiviert',
    '__status__off' => 'deaktiviert',
    '__status__with_parent' => 'deaktiviert',
    '__status__backup_restore' => 'vorübergehend gesperrt zu Backup- oder Wiederherstellungszwecken',
    '__status__admin' => 'vom Serveradministrator gesperrt',
    '__status__resseler' => 'vom Reseller gesperrt',
    '__status__client' => 'vom Kunden gesperrt',
    '__status__unknown' => 'Status ist unbekannt',

    '__status_of' => "%1 Status",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel-Server", // indirect
    '__subdomain' => "Subdomain",
    '__subdomain_name' => "Name der Subdomain",
    '__subdomain_name_in_ASCII_form' => "Subdomainname im ASCII-Format",
    '__subdomains' => "Subdomains",
    '__domainaliases' => "Domain-Aliase",
    '__subdomains_list' => "Subdomains",
    '__subdomains_not_support_in_key' => "Subdomains werden vom Lizenzschlüssel nicht unterstützt",
    '__sys_user_type' => "FTP-Benutzer",
    '__sys_user_type_main' => "FTP-Benutzerkonto der Haupt-Domain verwenden",
    '__sys_user_type_native' => "Separates FTP-Benutzerkonto für diese Subdomain erstellen",
    '__t' => "T",
    '__target_domain' => "Zieldomain",
    '__template' => "Vorlage",
    '__template_not_accepted' => "Das Template wurde nicht akzeptiert. Die folgenden Grenzen wurden überschritten.",
    '__templates' => "Vorlagen",
    '__templates_list' => "Vorlagen",
    '__tera' => "T",
    '__title' => "Titel",
    '__tools' => "Tools",
    '__total' => "%1 gesamt",
    '__total_size' => "Gesamtgröße",
    '__total_used' => "Gesamt verwendet",
    '__traffic' => "Verkehr",
    '__traffic_by_client' => "Traffic nach Kunde",
    '__traffic_by_domain' => "Traffic nach Domain",
    '__traffic_by_service' => "Traffic nach Service",
    '__traffic_history' => "Traffic-Verlauf",
    '__unable_change_locale' => "Sprache der Benutzeroberfläche kann nicht geändert werden: %1",
    '__unable_create_new_dom' => "Eine Domain kann nicht erstellt werden: %1",
    '__unable_define_dom_name' => "Domainname kann nicht definiert werden: %1",
    '__unable_define_necessary_properties' => "Definieren aller erforderlichen Eigenschaften nicht möglich.",
    '__unable_define_properties' => "Eigenschaften können nicht definiert werden: %1",
    '__unable_exec_util' => "Dienstprogramm kann nicht ausgeführt werden: %1",
    '__unable_get_dns_a_recs' => "Für dieses Hosting-Konto können keine IP-Adressen für A-DNS-Einträge abgerufen werden: %1.",
    '__unable_get_mbox_quota' => "Informationen zum Postfachkontingent können nicht abgefragt werden.",
    '__unable_redirect_to_myself' => "Weiterleitung an dasselbe Konto ist nicht möglich.",
    '__unable_redirect_to_my_alias' => "Weiterleitung von E-Mails an E-Mail-Alias nicht möglich.",
    '__default_domain_redirect_to_myself' => "Domain kann nicht als Standard für die IP-Adresse festgelegt werden:\n Umleitung zu sich selbst festgestellt.",
    '__unable_remove_client' => "Kunde kann nicht entfernt werden: %1",
    '__unable_set_up_mbox_quota' => "Postfachkontingent für die Domain kann nicht eingerichtet werden: %1",
    '__unable_setup_pass' => "Passwort kann nicht eingerichtet werden: %1",
    '__unable_to_create_new_account' => "Ein Konto kann nicht erstellt werden: %1",
    '__unable_to_define_db_size' => "Datenbankgröße konnte nicht definiert werden",
    '__unable_to_enable_short_names' => "Die Verwendung kurzer E-Mail-Kontonamen für POP3/IMAP-Konten kann nicht zugelassen werden.",
    '__unable_to_fetch_data_from_submit' => "Übermittelte Daten können nicht abgerufen werden: %1",
    '__unable_to_open_file' => "Datei konnte nicht geöffnet werden: %1: %2.",
    '__unable_to_update_subdomain' => "Ändern der Subdomain nicht möglich: %1",
    '__unable_update_cl_data' => "Speichern der Änderungen an Benutzerkonto nicht möglich: %1",
    '__unable_update_db_params' => "Aktualisieren der Datenbank-Parameter nicht möglich: %1",
    '__unable_update_dom_data' => "Domaindaten können nicht aktualisiert werden: %1",
    '__undefined' => "nicht definiert",
    '__uninstall' => "Deinstallieren",
    '__unknown_error' => "Unbekannter Fehler",
    '__unlimited_lower' => "Unbegrenzt",
    '__unset' => "Deaktivieren",
    '__update' => "Aktualisieren",
    '__uploaded_file_is_invalid' => "Hochgeladene Datei ist ungültig: %1",
    '__url' => "URL",
    '__usage' => "Speicherplatzbelegung",
    '__user' => 'Benutzer',
    '__user_already_logged' => "Ein anderer Benutzer mit demselben Benutzernamen (%1) ist bereits bei Plesk angemeldet.",
    '__version' => "Version",
    '__aps_license' => "Lizenzschlüssel",
    '__vh_type' => "Virtual Host-Typ",
    '__vhosts_apache_status' => "Webserverstatus",
    '__wrong_charset_conversion' => 'Falscher Zeichensatz. Konvertierung von "%1" nach "%2" ist nicht erlaubt',
    '__warning_' => "Warnung!",
    '__warning_excl_ip_num' => "Dedizierte IP-Adresse",
    '__warning_expiration' => "Ablaufdatum",
    '__web_scripting' => "Web-Scripting", // indirect
    '__web_serv' => "Webserver", // indirect
    '__web_statistic' => "Webstatistiken", // indirect
    '__webmail' => "WebMail", // +indirect
    '__webstat_not_installed' => "Webalizer ist nicht auf dem Server installiert. Bitte wenden Sie sich für Unterstützung bei der Webalizer-Installation an Ihren Service-Provider.",
    '__webstat_support' => "Webstatistiken",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Wenn Sie von einem Statistikprogramm auf ein anderes wechseln, werden alle Berichte, die mit dem vorherigen Statistikprogramm erstellt wurden, gelöscht und neue Berichte werden anhand der Informationen aus den Protokolldateien auf diesem Server erstellt. Wenn Sie Ihr System so konfiguriert haben (unter Domains > Domainname > Protokollverwaltung > Protokollrotation), dass Protokolldateien nur für den jeweils letzten Monat gespeichert werden, dann sind auch die Webstatistiken nur für den letzten Monat verfügbar. Wollen Sie auf ein anderes Statistikpaket wechseln?",
    '__webstat_perm_denied' => 'Sie haben nicht die Berechtigung zur Verwaltung der Webstatistiken.',
    '__webuser' => "Webbenutzer",
    '__sysusers_list' => "Systembenutzer",
    '__sysuser' => "Systembenutzer",
    '__weekly' => "Wöchentlich",
    '__whats_new_in_version' => "Neue Features in Plesk %1",
    '__wrong_hosting_type__virtual_required' => "Diese Aktion ist nur für Domains mit Webhosting verfügbar.",
    '__wrong_hosting_type__none' => 'Auf Domain %1 ist kein Webhosting konfiguriert.',
    '__wrong_hosting_type__std_fwd' => 'Für die Domain %1 wurde die Standardweiterleitung konfiguriert. Diese Aktion ist nur für Domains mit Webhosting verfügbar.',
    '__wrong_hosting_type__frm_fwd' => 'Für die Domain %1 wurde Frame-Weiterleitung konfiguriert. Diese Aktion ist nur für Domains mit Webhosting verfügbar.',
    '__wu' => "Webbenutzer",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Das www-Präfix wurde geändert. Vergewissern Sie sich, dass auch das SSL/TLS-Zertifikat entsprechend angepasst wird.",
    '__year' => "Jahr",
    '__year(s)' => "Jahr(e)",
    '__yes' => "Ja",
    '__you' => "Sie",
    '__zip_code' => "Postleitzahl",
    '__form_normal' => "Normal",
    '__form_advanced' => "Erweitert",

    'admin_ed__edit_administrator_info' => "Administrator-Profile bearbeiten",
    'admin_ed__create_default_client' => "Ich möchte ein Standardkundenkonto erstellen.",
    'admin_ed__unable_update' => "Administratorinformationen können nicht aktualisiert werden: %1",

    'auth__update_admin_info' => "Bitte geben Sie die Administratorinformationen ein. Diese Informationen sind für den Betrieb von %1 erforderlich.",
    'auth__you_not_have_perm' => "Sie sind zum Verwalten dieser Domain nicht berechtigt.",
    'auth__key_expired_admin' => 'Die Plesk Lizenz ist abgelaufen. Wenn Sie Plesk weiter verwenden möchten, verlängern Sie Ihre Lizenz oder kaufen Sie eine neue.',
    'auth__key_expired_admin_restricted' => 'Die Plesk Lizenz ist abgelaufen. Wenden Sie sich an Ihren Service-Provider, um Plesk weiter zu verwenden.',
    'auth__key_expired_client' => 'Die Plesk Lizenz ist abgelaufen. Bitte wenden Sie sich an Ihren Hosting-Provider.',
    'autoinstaller__not_installed' => 'Autoinstaller-Komponente ist nicht installiert.',
    'autoinstaller__release_action' => 'Verfügbare Aktionen',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Upgrade auf die neue Plesk Version',
    'autoinstaller__release_action_update' => 'Aktualisieren oder Hinzufügen neuer Komponenten',
    'autoinstaller__release_action_up2date' => 'Sie haben eine aktuelle Version',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Nicht installiert',
    'autoinstaller__component_action_update' => 'Updates sind verfügbar',
    'autoinstaller__component_action_upgrade' => 'Ein Update ist verfügbar',
    'autoinstaller__component_action_up2date' => 'Sie haben eine aktuelle Version',
    'autoinstaller__component_action_error' => 'Updates nicht verfügbar',
    'autoinstaller__component_serverbuildtime' => 'Aktuelles Release',
    'autoinstaller__component_localbuildtime' => 'Ihr Release',
    'autoinstaller__component_installed_version' => 'Ihre Version',
    'autoinstaller__component_available_version' => 'Aktuelle Version',
    'autoinstaller__component' => 'Komponente',
    'autoinstaller__components' => 'Komponenten',
    'autoinstaller__components_title' => '%1 Komponente(n)',
    'autoinstaller__component_dependency_note' => 'für die Installation der von Ihnen ausgewählten Komponenten erforderlich',
    'autoinstaller__install_confirm' => 'Ja, ich möchte diese Komponenten installieren',
    'autoinstaller__install_confirm_request' => 'Bitte aktivieren Sie zum Bestätigen das Kontrollkästchen',
    'autoinstaller__install_title' => 'Installation der ausgewählten Komponenten bestätigen',
    'autoinstaller__key_update_confirm' => 'Bitte bestätigen Sie das Überspringen der Schlüsselaktualisierung und installieren Sie den Standardschlüssel.',
    'autoinstaller__key_update_confirm_request' => 'Bitte aktivieren Sie zum Bestätigen das Kontrollkästchen.',
    'autoinstaller__key_update_failed' => '<p>Plesk kann Ihre Produktlizenz nicht aktualisieren.</p><p>%1</p><p> Wenn Sie ohne geeignete Produktlizenz mit dem Upgrade fortfahren, wird eine Standardlizenz mit begrenzter Funktionalität installiert. Für Administratoren empfiehlt sich, zuerst die entsprechende Lizenz zu erwerben, bevor sie mit dem Upgrade fortfahren.</p>',
    'autoinstaller__email' => 'Benachrichtigung senden an',
    'autoinstaller__email_admin' => "E-Mail-Adresse des Administrators",
    'autoinstaller__email_email' => 'Benutzerdefinierte E-Mail-Adresse...',
    'autoinstaller__release' => 'Release-Name',
    'autoinstaller__releases' => 'Verfügbare Releases',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Wählen Sie die Komponenten aus, die installiert werden sollen',
    'autoinstaller__status_error' => 'Fehler: %1.',
    'autoinstaller__status_install_error' => 'Installation konnte nicht gestartet werden: %1.',
    'autoinstaller__status_install_busy' => 'Installation konnte nicht gestartet werden: Es läuft gerade ein weiterer Installationsprozess.',
    'autoinstaller__status_install_ok' => 'Installation wurde gestartet. Sie werden per E-Mail (%1) über den Status der Installation benachrichtigt.',
    'autoinstaller__status_query_busy' => 'Installation läuft.',
    'autoinstaller__status_query_error' => 'Installationsstatus kann nicht abgefragt werden: %1',
    'autoinstaller__status_unknown' => 'Autoinstaller-Status kann nicht abgerufen werden.',
    'autoinstaller__status_busy' => 'Autoinstaller ist ausgelastet, bitte warten.',
    'autoinstaller__configure_title' => 'Updater-Einstellungen',
    'autoinstaller__preferences_legend' => 'Einstellungen',
    'autoinstaller__target' => 'Temporäres Download-Verzeichnis',
    'autoinstaller__target_invalid' => "Geben Sie den absoluten Pfad an",
    'autoinstaller__check_updates' => 'Nach Updates suchen, sobald sich der Administrator bei Plesk angemeldet hat',
    'autoinstaller__check_updates_warning' => 'Für %2 sind neue <a href="%1">Updates</a> verfügbar',
    'autoinstaller__source_type' => 'Quelltyp',
    'autoinstaller__source' => 'Quell-URL',
    'autoinstaller_source__preferences_legend' => 'Einstellungen',
    'autoinstaller_source__type' => 'Quelltyp',
    'autoinstaller_source__url_invalid' => 'Ungültige Quelle',
    'autoinstaller_source__url_invalid_network' => 'Ungültige Quell-URL (Beispiel: http://Quelle, ftp://Quelle)',
    'autoinstaller_source__url' => 'Quell-URL',
    'autoinstaller__source_invalid_network' => 'Sie haben eine ungültige Netzwerkadresse angegeben',
    'backup__repository' => 'Speicherort für Backupdateien',
    'backup__error_notify_email' => 'Bei Fehlern während des Backups Benachrichtigung an folgende E-Mail-Adresse versenden:',
    'backup__dump_info' => "Backup-Informationen",
    'backup__dump_file_name_not_defined' => "Backupdateiname ist nicht definiert",
    'backup__local_file' => 'Lokale Backupdatei',
    'backup__domain_ftp' => 'Remote-FTP-Server',
    'backup__wrong_path' => "Falscher Pfad zum Backupdateispeicher: Verwenden Sie nicht die Zeichenfolge ../../",
    'backup__unable_to_connect_to_ftp_server' => "Verbindungsaufbau zu FTP-Server nicht möglich: %1",
    'backup__unable_to_read_file' => 'Die Backupdatei kann nicht gelesen werden.',
    'backup__backup_task_does_not_exist' => "Backup-Aufgabe existiert nicht. Sie müssen sie erstellen, bevor Sie sie aktivieren.",
    'backup__restore_params' => "Wiederherstellungsparameter",
    'backup__confirmation' => "Warnung: Die Domain wird während des Backups/der Wiederherstellung deaktiviert.",
    'backup__backup_method' => 'Backupmethode',
    'backup__dumpfile_name' => "Backupdateiname",
    'backup__dumpfile_name_is_invalid' => "Backupdateiname ist ungültig: Verwenden Sie nur alphanumerische Zeichen, Bindestriche, Punkte und Unterstriche und keine Namen wie 'beschreibung.*' als Backupdateiname.",
    'backup__email_required' => "Ihre E-Mail-Adresse wird benötigt, um Sie über den Fortschritt des Backup-/Wiederherstellungsvorgangs zu informieren. Bitte geben Sie Ihre E-Mail-Adresse in den Kontoinformationen ein.",
    'backup__error_during_backup' => "Backupdatei kann nicht erstellt werden: %1",
    'backup__input_email_warning' => "Sie müssen entweder eine E-Mail-Adresse für die Benachrichtigung eingeben oder das Kontrollkästchen deaktivieren.",
    'backup__make_download' => "Backupdatei nicht im Speicher ablegen, nur herunterladen",
    'backup__make_dump' => 'Backupdatei erstellen und im lokalen Speicher speichern',
    'backup__makedump_to_ftp' => 'Backupdatei erstellen und auf dem Remote-FTP-Server speichern',
    'backup__restore_ip' => "IP-Adresse für Wiederherstellung",
    'backup__select_dumpfile' => "Wählen Sie eine Backupdatei aus.",
    'backup__time' => "Backupzeit",
    'backup__day' => 'Tag des Backups',
    'backup__view_dump_info' => "Backup-Informationen für Domain %1 anzeigen.",
    'backup__wrong_domain_name' => "Die Backupdatei enthält die Daten von Domain %1 und kann deshalb nicht in Domain %2 wiederhergestellt werden",
    'backup__incorrect_ftp_user_or_passwd' => "FTP-Benutzername oder -Passwort ungültig. Bitte korrigieren Sie die FTP-Konto-Eigenschaften.",
    'backup__access_denied' => "Zugriff verweigert. Bitte FTP-Konto-Eigenschaften korrigieren.",
    'backup__restore_from' => "%1 wiederherstellen",
    'backup__domain_session_failed' => 'Von Domain %1 wurde kein Backup erstellt',
    'backup__client_session_failed' => 'Kunde %1 wurde nicht gesichert',
    'backup__domain_session_restore_failed' => 'Domain %1 wurde nicht wiederhergestellt',
    'backup__client_session_restore_failed' => 'Kundenkonto %1 wurde nicht wiederhergestellt',
    'backup__domain_session_complete' => 'Backup von Domain %1 wurde erstellt',
    'backup__domain_session_backup' => 'Backup von Domain %1',
    'backup__client_session_backup' => 'Backup des Kunden %1',
    'backup__domain_stop_title' => 'Backup von Domain %1 wird abgebrochen',
    'backup__client_stop_title' => 'Backup des Kundenkontos %1 wird abgebrochen',
    'backup__domain_restore_stop_title' => 'Wiederherstellung der Domain %1 wird abgebrochen',
    'backup__client_restore_stop_title' => 'Wiederherstellung des Kundenkontos %1 wird abgebrochen',
    'backup__domain_session_backup_stop' => 'Sie sind dabei, den aktiven Backup-Vorgangs abzubrechen. Es wird keine Backupdatei erstellt.',
    'backup__backup_stop_confirm' => 'Ja, ich möchte den Backupvorgang anhalten',
    'backup__restore_stop_confirm' => 'Ja, ich will den Wiederherstellungsvorgang abstoppen',
    'backup__domain_session_restore' => 'Wiederherstellung der Domain %1',
    'backup__domain_session_restore_stop' => 'Sie sind dabei, den aktiven Wiederherstellungsvorgang abzubrechen.',
    'backup__domain_backup_file_info' => 'Informationen zur Domain-Backupdatei',
    'backup__domain_backup_file_list' => 'Vorhandene Backupdateien',
    'backup__domain_backup_progress' => 'Fortschritt: Backup der Website %1',
    'backup__domain_restore_progress' => 'Fortschritt: Wiederherstellen der Website %1',
    'backup__domain_backup_progress_elapsed_time' => 'Vergangene Zeit: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Vergangene Zeit: %1',
    'backup__domain_restore_session_complete' => 'Domain %1 wurde wiederhergestellt.',
    'backup__domain_restore_session_complete_message' => 'Domain %1 wurde wiederhergestellt.',
    'backup__domain_backup_file_delete' => 'Die folgenden Backupdateien werden entfernt:',
    'backup__domain_backup_file_for_remove' => 'Wählen Sie die Backupdateien aus, die entfernt werden sollen.',
    'backup__backup_overwrite_file_confirm' => 'Bestätigung für Ersetzen',
    'backup__backup_overwrite_file_confirm_text' => 'Backupdatei mit Name "%1" existiert bereits. Möchten Sie sie ersetzen?',
    'backup__backup_confirm_overwrite' => 'Dateiersetzung bestätigen',
    'backup__backup_overwrite_legeng' => 'Ersetzen',
    'backup__backup_not_contain_domain' => 'Backupdatei enthält keine Informationen über Domain %1',
    'backup__backup_not_contain_client' => 'Backupdatei enthält keine Informationen zum Kundenkonto %1',
    'backup__backup_client_info' => "Kunden-Einstellungen und Kontodetails sichern",
    'backup__client_backup_progress' => 'Fortschritt: Backup des Kundenkontos %1',
    'backup__client_session_complete' => 'Kundenkonto %1 wird gesichert',
    'backup__client_backup_file_info' => 'Informationen zur Backupdatei des Kunden',
    'backup__restore_client_info' => "Kunden-Einstellungen und Kontodetails wiederherstellen",
    'backup__client_session_restore' => 'Kundenkonto %1 wird wiederhergestellt',
    'backup__client_db_server_map' => 'Datenbankserver-Mapping',
    'backup__domain_db_server_map' => 'Datenbankserver-Mapping',
    'backup__client_restore_session_complete_message' => 'Kundenkonto %1 wurde wiederhergestellt.',
    'backup__client_restore_session_complete' => 'Kundenkonto %1 wurde wiederhergestellt.',
    'backup__restore_select_some' => 'Bitte wählen Sie die Objekte aus, die Sie wiederherstellen möchten.',
    'backup__client_restore_progress' => 'Fortschritt: Wiederherstellung des Kundenkontos %1',
    'backup__new_backup' => 'Neues Backup erstellen',
    'backup__done' => 'Abgeschlossen:',
    'backup__done_domains' => '%1 Domain(s) von %2',
    'backup__done_clients' => '%1 Kunde(n) von %2',
    'backup__remaining' => 'Verbleibend:',
    'backup__remaining_domains' => '%1 Domain(s)',
    'backup__remaining_clients' => '%1 Kunde(n)',
    'backup__overall_backup_progress' => 'Backup-Gesamtfortschritt',
    'backup__comment_n_a' => 'n/v',
    'backup__command_ignore' => 'Befehl "%1" wird ignoriert',
    'backup__no_objects' => 'keine Objekte für Backup vorhanden',
    'backup__cli_warning_not_enough_ip' => 'WARNUNG: nicht genügend IP-Adressen, um Standard-IP-Mapping durchzuführen:',
    'backup__local_repository' => "Plesk Speicher",
    'backup__ftp_repository' => 'FTP-Speicher',
    'backup__ftp_login' => 'Benutzername',
    'backup__ftp_password' => 'Passwort',
    'backup__ftp_account_settings' => 'FTP-Konto-Einstellungen',
    'backup__ftp_account_preferences' => 'FTP-Konto-Einstellungen',
    'backup__repository_not_exist' => 'Das Verzeichnis existiert nicht',
    'backup__repository_not_readable' => 'Das angegebene Verzeichnis ist nicht lesbar',
    'backup__ftp_repository_not_configure' => 'Wenn Sie einen FTP-Backupspeicher verwenden wollen, müssen Sie <a href="%1">zuerst das FTP-Konto angeben</a>.',
    'backup__ftp_repository_list_not_configure' => 'Kontoeinstellungen wurden nicht angegeben',
    'backup__repository_list_unable_listing' => 'Dateiliste kann nicht abgerufen werden',
    'backup__ftp_repository_unable_listing' => 'Liste von Verzeichnis "%1" kann nicht abgerufen werden:',
    'backup__repository_legend' => 'Backupdateispeicher',
    'backup__store_in_repository' => 'Dateien speichern in',
    'backup__local_repository_lable' => 'Lokaler Speicher',
    'backup__ftp_repository_lable' => 'FTP-Speicher',
    'backup__ftp_repository_not_configure_hint' => '(Kontoeinstellungen sind nicht angegeben)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-Konto ist nicht angegeben oder wird nicht unterstützt)',
    'backup__other_user_process_modified' => 'Ein anderer Benutzer hat den Backup- oder Migrationsprozess gestoppt.',
    'backup__another_user_exist' => 'Der aktuell ausgeführte Vorgang wurde von einem anderen Plesk Benutzer initiiert. Der Benutzer ist noch bei Plesk angemeldet.',
    'backup__ftp_repository_wait' => 'Bitte warten Sie, während die Informationen über den FTP-Speicher abgerufen werden',
    'backup__ftp_write_test_failed' => 'Schreiben der Testdaten auf FTP-Konto %1 fehlgeschlagen:',
    'backup__ftp_storage' => 'FTP(S)-Speicher',
    'bt_upload_to_repository' => 'Dateien in lokalen Speicher hochladen',
    'bt_new_restore' => "Wiederherstellen",
    'bt_backup_schedule' => "Backup planen",
    'backup_exist_backups' => "Vorhandene Backupdateien",
    'backup_dialog__page_title' => "Backupdatei-Erstellung",
    'backup_dialog__please_wait' => "Der Backupprozess beginnt. Diese Operation kann einige Minuten in Anspruch nehmen. Bitte warten...",
    'backup_conf__page_title' => 'Backup-Konfiguration',
    'bt_accept' => "Akzeptieren",
    'bt_access' => "Zugriff",
    'bt_action_log' => "Aktionsprotokoll",
    'bt_add' => "Hinzufügen",
    'bt_add_client' => "Benutzern zuweisen",
    'bt_database_server_add' => 'Datenbankserver hinzufügen',
    'bt_add_services' => "Services hinzufügen",
    'bt_anonftp_stats' => "Anon. FTP-Stat.",
    'bt_anonymous_ftp' => "Anonymous FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Anhängen",
    'bt_autoinstaller' => 'Updater',
    'bt_auto-updates' => 'Updater',
    'bt_back' => "<< Zurück",
    'bt_backup' => "In Backup aufnehmen",
    'bt_backup_configure' => "Backup-Einstellungen",
    'bt_buy_certs' => "Zertifikate kaufen",
    'bt_card' => "Karte",
    'bt_cert' => "Zertifikat",
    'bt_certificates' => "Zertifikate",
    'bt_change_passwd' => "Passwort ändern",
    'bt_clear' => "Auswahl aufheben",
    'bt_client_templates' => "Kunden-Templates",
    'bt_clients' => "Kunden",
    'bt_codepage_change' => 'Kodierung ändern',
    'bt_comp_info' => "Komponentenverwaltung",
    'bt_configure_maillists' => "Mailman einrichten",
    'bt_configure' => 'Konfigurieren',
    'bt_copy' => "Kopieren",
    'bt_copy_move' => "Kopieren/verschieben",
    'bt_create' => "Erstellen",
    'bt_create_account' => "Konto erstellen",
    'bt_create_dir' => "Verzeichnis hinzufügen",
    'bt_create_file' => "Datei hinzufügen",
    'bt_count_size' => "Größe berechnen",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Aufgabenplaner",
    'bt_custom_button_new' => "Schaltfläche hinzufügen",
    'bt_custom_buttons' => "Benutzerdefinierte Schaltflächen",
    'bt_customize' => "Anpassen",
    'bt_databases' => "Datenbanken",
    'bt_database_servers' => 'Datenbankserver',
    'bt_sqlservers' => "Datenbankserver",
    'bt_db_usr_new' => "Datenbankbenutzer hinzufügen",
    'bt_db_new' => "Datenbank hinzufügen",
    'bt_db_phpmyadmin' => "MySQL-Administrator",
    'bt_dbuser_default' => "Als Standard für DB-Webadmin definieren",
    'bt_decline' => "Ablehnen",
    'bt_default' => "Standard",
    'bt_defaultcomponents' => "Drittanbieterservices",
    'bt_defaults' => "Standardwerte",
    'bt_delete' => "Löschen",
    'bt_directories' => "Geschützte Verzeichnisse",
    'bt_disable' => "Deaktivieren",
    'bt_dns_zone_sync' => 'Änderungen des DNS-Templates anwenden',
    'bt_dnsrecord_add' => 'Eintrag hinzufügen',
    'bt_do_backup' => "Backup erstellen",
    'bt_do_restore' => "Wiederherstellen",
    'bt_do_upload' => "Hochladen",
    'bt_domain_aliases' => "Domain-Aliase",
    'bt_domain_templates' => "Domain-Templates",
    'bt_domain_user' => "Domainbenutzer",
    'bt_domain_user_passwd' => "Domainadministrator-Passwort",
    'bt_domains' => "Domains",
    'bt_domain_alias_add' => 'Domain-Alias hinzufügen',
    'bt_download' => "Herunterladen",
    'bt_edit' => "Bearbeiten",
    'bt_enable' => "Aktivieren",
    'bt_export' => 'Exportieren',
    'bt_extras' => "Extras",
    'bt_finish' => "Fertigstellen",
    'bt_ftp_account' => "FTP-Konto-Eigenschaften",
    'bt_forget_password' => "Passwort vergessen?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS-Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP-Statistiken",
    'bt_get_password' => "Passwort abrufen",
    'bt_global_changes' => "Bearbeiten",
    'bt_help' => "Hilfe",
    'bt_hide_aliases' => "Aliase ausblenden",
    'bt_hide_toolbar' => 'Toolbar ausblenden',
    'bt_hide_subdomains' => "Subdomains ausblenden",
    'bt_hide_domainaliases' => "Domain-Aliase ausblenden",
    'bt_home' => "Start",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Installieren",
    'bt_ip_aliasing' => "IP-Adressen",
    'bt_ip_add' => "IP-Adresse hinzufügen",
    'bt_ip_pool' => "IP-Pool",
    'bt_key_info' => "Lizenzinformationen",
    'bt_key_buyonline_addons' => 'Plesk Add-ons bestellen',
    'bt_key_buyonline_upgrades' => 'Plesk Upgrades bestellen',
    'bt_key_buyonline_new' => 'Neuen Schlüssel bestellen',
    'bt_limits' => "Grenzen",
    'bt_locale_add' => 'Sprachdatei hinzufügen',
    'bt_locales' => 'Sprachdateien',
    'bt_log_manager' => "Protokollverwaltung",
    'bt_login' => "Anmelden",
    'bt_logo' => "Markenidentität (Branding)",
    'bt_logo_send_link' => "Link beifügen",
    'bt_logo_send_logo' => "Logo beifügen",
    'bt_logout' => "Abmelden",
    'bt_logrotation' => "Protokollrotation",
    'bt_mail' => "E-Mail",
    'bt_mail_alias_add' => "E-Mail-Alias hinzufügen",
    'bt_mail_aliases' => "E-Mail-Aliase",
    'bt_mail_group_add' => "Mitglied hinzufügen",
    'bt_mail_groups' => "Gruppen",
    'bt_mail_name_add' => "E-Mail-Konto hinzufügen",
    'bt_mail_preferences' => "Einstellungen",
    'bt_mail_group' => "Mailgruppe",
    'bt_mail_mailbox' => "E-Mail-Postfach",
    'bt_mail_redirect' => "Weiterleiter",
    'bt_mail_resp_add' => "Automatische Antwort hinzufügen",
    'bt_mail_resp_attach_add' => "Anhang hinzufügen",
    'bt_mail_resp_files' => "Attachment-Dateien",
    'bt_mail_responders' => "Autoresponder",
    'bt_mail_spamfilter' => "Spamfilter",
    'bt_mail_webmail' => "WebMail",
    'bt_maillist_new' => "Mailingliste hinzufügen",
    'bt_maillists' => "Mailinglisten",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Backup erstellen",
    'bt_manage' => "Verwalten",
    'bt_master' => "Master",
    'bt_migrate' => 'Migrieren',
    'bt_modules_add' => 'Erweiterung hinzufügen',
    'bt_modules_manage' => 'Erweiterungen verwalten',
    'bt_move' => "Verschieben",
    'bt_mimetypes' => 'MIME-Typen',
    'bt_mimetype_new' => 'MIME-Typ hinzufügen',
    'bt_new_client' => "Kundenkonto hinzufügen",
    'bt_new_domain' => "Domain hinzufügen",
    'bt_next' => "Weiter >>",
    'bt_next_page' => "Weiter",
    'bt_network_add' => "Hinzufügen",
    'bt_notifications' => "Benachrichtigungen",
    'bt_off' => "Aus",
    'bt_on' => "An",
    'bt_on_off' => "An/Aus",
    'bt_pd_new' => "Geschütztes Verzeichnis hinzufügen",
    'bt_pd_user_new' => "Benutzer hinzufügen",
    'bt_performance' => 'Leistung',
    'bt_permissions' => "Berechtigungen",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Einstellungen",
    'bt_prev_page' => "Zurück",
    'bt_preview' => 'Site-Vorschau',
    'bt_print' => "Drucken",
    'bt_reboot' => "Neu starten",
    'bt_reload' => "Neu laden",
    'bt_refresh' => "Aktualisieren",
    'bt_register' => "Registrieren",
    'bt_remove' => "Entfernen",
    'bt_enable_selected' => 'Aktivieren',
    'bt_disable_selected' => 'Deaktivieren',
    'bt_repair_ip' => "IP reparieren",
    'bt_report' => "Bericht",
    'bt_report_new' => "Layout hinzufügen",
    'bt_reset' => "Zurücksetzen",
    'bt_restart_services' => "Service-Verwaltung",
    'bt_save' => "Speichern",
    'bt_send_by_email' => "Per E-Mail senden",
    'bt_send_file' => "Datei senden",
    'bt_send_mail' => "E-Mail senden",
    'bt_send_passwd' => "Passwort senden",
    'bt_send_text' => "Text senden",
    'bt_server' => "Server",
    'bt_server_add' => "Server hinzufügen",
    'bt_server_preferences' => "Servereinstellungen",
    'bt_servers_list' => "Server",
    'bt_sessions' => "Sitzungen",
    'bt_set' => "Einrichten",
    'bt_set_as_default' => "Als Standard festlegen",
    'bt_setup' => 'Konfiguration',
    'bt_show_aliases' => "Aliase anzeigen",
    'bt_show_subdomains' => "Subdomains anzeigen",
    'bt_show_domainaliases' => "Domain-Aliase anzeigen",
    'bt_shutdown' => "Herunterfahren",
    'bt_site_apppkgs' => "Application Vault",
    'bt_site_apppool' => "Anwendungspool",
    'bt_application-pool' => "Webanwendungen",
    'bt_site_apps' => "Webanwendungen",
    'bt_site_app_add' => "Anwendung installieren",
    'bt_site_builder' => "Unterstützung von Presence Builder",
    'bt_skeleton' => 'Template für virtuelle Hosts',
    'bt_skins' => 'Oberflächen',
    'bt_skin_add' => 'Skin hinzufügen',
    'bt_skin_manual' => 'Referenz für benutzerdefinierte Plesk Skins', // not used
    'bt_skin_download' => 'Skin herunterladen',
    'bt_skin_replace' => 'Skin aktualisieren',
    'bt_skip' => 'Überspringen',
    'bt_spamassassin' => "Spamfilter",
    'bt_spamassassin_train' => "Training",
    'bt_spamfilter' => "Spamfilter",
    'bt_start' => "Starten",
    'bt_stop' => "Anhalten",
    'bt_recycle' => "Wiederverwenden",
    'bt_statistics' => "Statistiken",
    'bt_subdomain_new' => "Subdomain hinzufügen",
    'bt_subdomains' => "Subdomains",
    'bt_submit' => "Übertragen",
    'bt_summary_report' => "Zusammenfassender Bericht",
    'bt_support' => "Unterstützung",
    'bt_switch' => "Umschalten",
    'bt_system_time' => "Systemzeit",
    'bt_task_new' => "Aufgabe hinzufügen",
    'bt_dom_tmpl_add' => 'Domain-Template hinzufügen',
    'bt_cl_tmpl_add' => 'Kunden-Template hinzufügen',
    'bt_cron_backup' => 'Einstellungen für geplantes Backup',
    'bt_test' => "Verbindung testen",
    'bt_text' => "Text",
    'bt_touch' => "Zeitstempel ändern",
    'bt_traffic' => "Verkehr",
    'bt_traffic_history' => "Traffic-Verlauf",
    'bt_update' => "Aktualisieren",
    'bt_upload' => "Hochladen",
    'bt_upload_from_ftp' => "FTP-Upload",
    'bt_virtualdirs' => 'Virtuelle Verzeichnisse',
    'bt_virtualdir_new' => 'Virtuelles Verzeichnis hinzufügen',
    'bt_virtualdir_add' => 'Virtuelles Verzeichnis hinzufügen',
    'bt_web_app_new' => "Java-Anwendung installieren",
    'bt_web_stats' => "Webstatistiken",
    'bt_web_stats_ssl' => "Webstatistik für SSL/TLS",
    'bt_web_user_add' => "Webbenutzer hinzufügen",
    'bt_web_users' => "Webbenutzer",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Gesamte Änderungsliste anzeigen",
    'cert_add__unable_set_ca_cert' => "CA-Zertifikat kann nicht konfiguriert werden: %1",
    'cert_add__unable_set_cert' => "Zertifikat kann nicht konfiguriert werden: %1",
    'cert_add__unable_set_private_key' => "Der private Schlüssel kann nicht eingerichtet werden: %1",
    'certificates_list__certificate_used_as_default' => "Eines der Zertifikate, die Sie löschen möchten, wird als Standardzertifikat verwendet.",
    'certificates_list__certificates_assigned_on_ip' => "Eines oder mehrere Zertifikate sind den IP-Adressen/Domains zugewiesen.",
    'ch_pass__admin_pass' => "Administratorpasswort ändern",
    'ch_pass__old_pass' => "Altes Passwort",
    'ch_pass__pass_confirm' => "Bestätigen",
    'ch_pass__unable_change_admin_pass' => "Administratorpasswort kann nicht geändert werden: %1",
    'check_mail_cycle__aliases' => "E-Mail-Schleife gefunden. Adresse \"%1\" ist in den Aliasen dieses E-Mail-Kontos enthalten.",
    'check_mail_cycle__autoresponders' => "E-Mail-Schleife gefunden. Adresse \"%1\" ist in den Autorespondern dieses E-Mail-Kontos enthalten.",
    'check_mail_cycle__mail_groups' => "E-Mail-Schleife gefunden. Adresse \"%1\" ist in den Mailgruppen dieses E-Mail-Kontos enthalten.",
    'check_mail_cycle__mail_name' => "E-Mail-Schleife gefunden. Adresse \"%1\" und dieses E-Mail-Konto sind identisch.",
    'check_mail_cycle__redirect' => "E-Mail-Schleife gefunden. Adresse \"%1\" und Umleitungsadresse dieses E-Mail-Kontos sind identisch.",
    'check_mail_dup__redirect' => "Doppelte Weiterleitung festgestellt. Die Adresse \"%1\" und Weiterleitungsadresse dieses E-Mail-Kontos sind identisch.",
    'check_mail_dup__mail_groups' => "Doppelte Weiterleitung festgestellt. Die Adresse \"%1\" ist in der Mailgruppe dieses E-Mail-Kontos enthalten.",
    'check_maillist_cycle__admin' => "E-Mail-Schleife festgestellt. Die Administrator-E-Mail-Adresse \"%1\" stimmt mit der Adresse einer Mailingliste überein.",
    'check_maillist_cycle__member' => "E-Mail-Schleife festgestellt: Adresse \"%1\" ist mit der Adresse der Mailingliste identisch.",
    'chk_js__enter_login_and_passwd' => "Benutzername und Passwort eingeben.",
    'chk_js__enter_login_name' => "Benutzernamen eingeben.",
    'chk_js__enter_passwd' => "Geben Sie das Passwort ein.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Kontodetails für %1",
    'cl_limits__cl' => "Grenzen von Kunde %1",
    'cl_logo__setup_logo_pref' => "Logoeinstellungen für Kunde %1 konfigurieren",
    'cl_new__enter_new_cl_data' => "Geben Sie Informationen über den neuen Kunden ein",
    'cl_new__unable_to_sent_notification' => 'Das Benutzerkonto wurde erstellt. Das Versenden einer Benachrichtigung an den Kunden ist jedoch fehlgeschlagen:%1',
    'cl_perm__all_ip' => "Alle verfügbaren IP-Adressen",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Alle IP-basierten Hosting-Konten des Kunden werden auf namensbasiert geändert.",
    'cl_perm__allow_client_create_domain' => "Die Felder, die Sie auswählen möchten, sind nur gültig für Kunden, die zur Erstellung von Domains berechtigt sind.",
    'cl_perm__allow_create_nb_w_ip' => "Kunde kann namensbasiertes Hosting mit %1 verwenden",
    'cl_perm__allow_creation_ip_based_hosting' => "Erstellung von IP-basierten Hosting-Konten zulassen",
    'cl_perm__available_ips' => "Verfügbare IP-Adressen",
    'cl_perm__change_limits' => "Anpassung der Grenzen",
    'cl_perm__cl_disk_space' => "Gesamter verfügbarer Speicherplatz",
    'cl_perm__cl_expiration' => "Gültigkeitsdauer des Kundenkontos",
    'cl_perm__cl_max_box' => "E-Mail-Postfächer",
    'cl_perm__cl_max_db' => "Datenbanken",
    'cl_perm__cl_max_dom' => "Domains",
    'cl_perm__cl_max_maillists' => "Mailinglisten",
    'cl_perm__cl_max_subdom' => "Subdomains",
    'cl_perm__cl_max_traffic' => "Gesamter verfügbarer Traffic",
    'cl_perm__cl_max_wu' => "Webbenutzer",
    'cl_perm__cl_mbox_quota' => "Postfachspeicherplatzgrenze für dieses Benutzerkonto",
    'cl_perm__current_maximum_exp_date' => "Der aktuelle maximale Wert für die Gültigkeit einer Domain ist %1; beantragt %2",
    'cl_perm__current_maximum_mailbox_quota' => "Die momentan definierte Grenze für Speicherplatz, die für Postfächer unter diesem Benutzerkonto zugewiesen werden kann, ist %1; angefordert %2",
    'cl_perm__current_total_requested' => "Der aktuelle Gesamtwert der Domaingrenzen für %1 ist %2; angefordert %3.",
    'cl_perm__current_total_requested_dom' => "Aktuelle Anzahl der diesem Kunden zugehörigen %1 ist %2; %3 angefordert.",
    'cl_perm__disk_space' => "maximaler Speicherplatz",
    'cl_perm__dashboard_stdgui' => 'Benutzeroberfläche',
    'cl_perm__dashboard' => 'Startseitenansicht',
    'cl_perm__stdgui' => 'Standardansicht',
    'cl_perm__manage_dashboard' => 'Startseitenverwaltung',
    'cl_perm__dashboard_and_stdgui' => 'Startseitenansicht und Standardansicht sind erlaubt',
    'cl_perm__dashboard_only' => 'Nur Startseitenansicht erlaubt',
    'cl_perm__stdgui_only' => 'Nur Standardansicht erlaubt',
    'cl_perm__edit_cl' => "Berechtigungen von Kunde %1",
    'cl_perm__exp_date_exceeded' => "Der Gültigkeitsdauer, die Sie festlegen möchten, überschreitet die Grenze für einzelne Domains dieses Kunden.",
    'cl_perm__invalid_value' => "Wert ungültig. Es sind nur Ziffern erlaubt.",
    'cl_perm__limit_disk_space' => "%1 Beschränkt die maximale Menge an Speicherplatz",
    'cl_perm__limit_expiration' => "%1 beschränkt die Gültigkeitsdauer für das Kundenkonto",
    'cl_perm__limit_max_box' => "%1 Beschränkt die maximale Anzahl Postfächer",
    'cl_perm__limit_max_db' => "%1 Maximale Anzahl Datenbanken beschränken",
    'cl_perm__limit_max_dom' => "%1 Maximale Anzahl Domains beschränken",
    'cl_perm__limit_max_maillists' => "%1 Beschränkt die maximale Anzahl Mailinglisten",
    'cl_perm__limit_max_subdom' => "%1 Beschränkt die maximale Anzahl Subdomains",
    'cl_perm__limit_max_traffic' => "%1 Beschränkt die maximale Menge Traffic",
    'cl_perm__limit_max_wu' => "%1 Beschränkt die maximale Anzahl Webbenutzer",
    'cl_perm__limit_mbox_quota' => "%1 Postfachkontingent einrichten",
    'cl_perm__limits_exceeded' => "Eine oder mehrere Grenzen, die Sie festlegen möchten, werden bereits von den innerhalb individueller Domains dieses Kunden festgelegten Grenzen überschritten.\nDas Gesamtlimit für den Kunden muss höher sein als die Gesamtsumme der für dieses Kundenkonto festgelegten Domaingrenzen bzw. dieser entsprechen.",
    'cl_perm__mailbox_quota_exceeded' => "Die Grenze, das Sie für Speicherplatz der Postfächer setzen möchten, überschreitet die in einzelnen Domains dieses Kundenkontos definierte Grenze.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Das Postfachkontingent, die Sie festlegen möchten, übersteigt die auf Server-Ebene gesetzten Grenzen.",
    'cl_perm__make_dumps' => "Daten sichern und wiederherstellen",

    'cl_perm__max_box' => "maximale Anzahl Postfächer",
    'cl_perm__max_db' => "maximale Anzahl Datenbanken",
    'cl_perm__max_dom' => "Domains",
    'cl_perm__max_maillists' => "maximale Anzahl Mailinglisten",
    'cl_perm__max_subdom' => "Subdomains",
    'cl_perm__max_traffic' => "maximaler Traffic",
    'cl_perm__max_wu' => "maximale Anzahl Webbenutzer",
    'cl_perm__max_dom_aliases' => "Domain-Aliase",
    'cl_perm__mbox_quota' => "Postfachkontingent",
    'cl_perm__not_allow_create_nb_hst' => "Kunde kann kein namensbasiertes Hosting erstellen.",
    'cl_perm__this_ip_used_vrt_hst' => "Diese IP-Adresse wird für virtuelles Hosting verwendet. Um diese IP-Adresse zu löschen, entfernen Sie den Hosting-Service oder ändern Sie ihn auf namensbasiert.",
    'cl_perm__unable_off_ipb_creating' => "Für den Kunden ist bereits IP-basiertes Hosting eingerichtet. Um dieses Feature bei diesem Kunden zu deaktivieren, deaktivieren Sie das Kontrollkästchen \"Domainerstellung\" oder entfernen Sie alle IP-basierten Hosting-Konten.",
    'cl_perm__unable_off_nb_creating' => "Für den Kunden ist bereits namensbasiertes Hosting eingerichtet. Um dieses Feature bei diesem Kunden zu deaktivieren, deaktivieren Sie das Kontrollkästchen \"Domainerstellung\" oder entfernen Sie alle IP-basierten Hosting-Konten.",
    'cl_perm__unable_set_domain_limit' => "Grenze für Anzahl an Domains kann nicht gesetzt werden: Kunde besitzt bereits %1 Domains",
    'cl_perm__unable_update_client_limitations' => "Grenzen von Kundenkonto können nicht geändert werden: %1",
    'cl_pref__edit_cl' => "Einstellungen von Kunde %1",
    'class_anonftp__create_ftp_domain' => "Keine virtuelle FTP-Domain für diese Domain-ID. Versuchen Sie zuerst, sie zu erstellen.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Das Speicherplatzlimit, das Sie für das incoming-Verzeichnis zu setzen versuchen (%1), darf den Speicherplatz auf Domainebene nicht übersteigen (%2)",
    'class_anonftp__invalid_input_only_digits' => "Wert ungültig. Es sind nur Ziffern erlaubt.",
    'class_anonftp__unable_change_ownerships' => "Berechtigungen oder Besitzer der Kontingentdatei können nicht geändert werden: %1",
    'class_anonftp__unable_copy_quota_file' => "Kontingentdatei kann nicht kopiert werden: %1",
    'class_anonftp__unable_get_disk_usage' => "Informationen über die Speicherplatzbelegung des Eingangsverzeichnisses können nicht abgerufen werden: %1",
    'class_anonftp__unable_parse_quota_file' => "Kontingentdatei kann nicht analysiert werden.",
    'class_anonftp__unable_read_quota_file' => "Kontingentdatei kann nicht gelesen werden: %1",
    'class_anonftp__unable_update_quota' => "Quota konnte nicht aktualisiert werden: die Dateien im Eingangsverzeichnis nutzen %1 KB Speicherplatz, was den neuen Quotawert übersteigt",
    'class_anonftp__unable_write_temp_file' => "In temporäre Datei konnte nicht geschrieben werden: %1",
    'class_bsdomain__warn_max_date__' => "Das Ablaufdatum wurde als %1 definiert",
    'class_cList__empty' => "Keine Elemente.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Nichts gefunden für <b>\"%1\"</b> in %2 (%3 von %4)",
    'class_cList__search_result' => "Suchresultate für <b>\"%1\"</b> in %2 (%3 von %4)",
    'class_client__client_creation_notification' => "Benachrichtigung über Kundenerstellung.",
    'class_client__client_with_contact_name_already_exists' => "Es existiert bereits ein Kunde mit dem Namen %1.",
    'class_client__disk_space' => "Speicherplatz",
    'class_client__invalid_max_dom' => "Wert für Domainanzahl ungültig. Es sind nur Ziffern erlaubt.",
    'class_client__limit_exceed' => "Der angeforderte Wert von %1 kann nicht zugewiesen werden, da die Ressourcenzuteilungen für das Konto von Kunde %2 (%3) nicht ausreichen. Wenn Sie mehr Ressourcen zuteilen möchten, gehen Sie zu Kunden > Kundenname > Grenzen und ändern Sie die Ressourcenzuteilungen entsprechend. Anschließend können Sie die Ressourcenzuteilungen auf dieser Seite erneut anpassen.",
    'class_client__limit_exceed_unlimited' => "Wenn Sie unbegrenzte Ressourcen (%1) zuweisen möchten, gehen Sie zunächst zu Kunden > Kundenname > Grenzen und aktivieren Sie das Kontrollkästchen Unbegrenzt der entsprechenden Ressource. Anschließend können Sie die Ressourcenzuteilungen auf dieser Seite erneut anpassen.",
    'class_client__max_box' => "E-Mail-Postfächer",
    'class_client__max_db' => "Datenbanken",
    'class_client__max_maillists' => "Mailinglisten",
    'class_client__max_subdom' => "Subdomains",
    'class_client__max_traffic' => "Maximaler Traffic",
    'class_client__max_wu' => "Webbenutzer",
    'class_client__max_dom_aliases' => "Domain-Aliase",
    'class_client__mbox_quota' => "Postfachkontingent",
    'class_client__unable_define_cl_status' => "Der Status des Kundenkontos kann nicht definiert werden: %1",
    'class_client__unable_define_inactive_dom' => "Inaktive Domain konnte nicht erstellt werden %1",
    'class_client__unable_del_ip' => "IP-Adressen können nicht entfernt werden: %1",
    'class_db__db_name_not_set' => "Datenbankname nicht definiert.",
    'class_db__db_not_exist_for_curr_dom' => "Die Datenbank existiert nicht für diese Domain.",
    'class_db__invalid_db_or_dom_name' => "Die Domain- oder Datenbank-ID ist ungültig, oder der Datenbankname ist nicht definiert.",
    'class_db__invalid_pass' => "Das Passwort ist ungültig.",
    'class_db__mailgrp_member_exist' => "Das Mailgruppen-Mitglied existiert bereits.",
    'class_db__access_hosts_notsupport' => 'Zugriff auf Host-Einstellungen wird für diesen Datenbanktyp nicht unterstützt',
    'class_db__unable_add' => 'Hinzufügen von Zugriffshosteintrag nicht möglich: %1',
    'class_db__unable_del' => 'Löschen des Zugriffshosteintrags nicht möglich: %1',
    'class_db__inc_user_not_exist' => 'Datenbankbenutzer "%1" existiert nicht',
    'class_db__inc_access_record_exist' => 'Dieser Zugriffseintrag existiert bereits',
    'class_db__inc_access_record_not_exist' => 'Der eingegebene Zugriffseintrag existiert nicht',
    'class_db__inc_unable_del_last_record' => 'Löschen des letzten Zugriffshosteintrags nicht möglich',
    'class_domtmpleditform__dns_master' => "Primär",
    'class_domtmpleditform__dns_slave' => "Sekundär",
    'class_domtmpleditform__dns_type' => "Typ der Domain-DNS-Zone",
    'clienttrafficlist_header' => "Traffic auf Domains",
    'clienttrafficlist_header_of_client__' => "Traffic auf Domains von Kunde %1",
    'cmd_dns__a_dns_record_already_exist' => "Dieser Eintrag wird in Konflikt mit dem A-Eintrag für die Zone stehen.",
    'cmd_dns__domain_last_ns' => 'Der letzte DNS-Eintrag "NS" für die Domain kann nicht gelöscht werden.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kanonischer Domainname ist ungültig.",
    'cmd_dns__cname_dns_record_already_exist' => "Dieser Eintrag wird in Konflikt mit dem CNAME-Eintrag für die Zone stehen.",
    'cmd_dns__cname_in_rr_combination' => 'Falsche Kombination von DNS-Einträgen in der DNS-Zone',
    'cmd_dns__cname_coexist_with_data' => 'Ein CNAME-DNS-Zoneneintrag darf nicht mit anderen DNS-Einträgen in derselben Zone koexistieren.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS-Eintragstyp ist ungültig.",
    'cmd_dns__ext_host_is_not_resolved' => "Der kanonische Name %1 wird nicht in den A- oder AAAA-Eintrag aufgelöst.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Der %1-Eintrag kann nicht zur Zone %2 hinzugefügt werden: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Mail-Exchanger-Name ist ungültig.",
    'cmd_dns__mx_priority_is_invalid' => "MX-Priorität ist ungültig.",
    'cmd_dns__name_server_is_invalid' => "Nameserver ist ungültig.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Netzwerkmaske muss 24, 16 oder 8 sein.",
    'cmd_dns__this_dns_record_already_exists' => "Dieser DNS-Eintrag ist bereits vorhanden.",
    'cmd_dns__unable_add_record' => "Hinzufügen von Eintrag '%1' nicht möglich: %2",
    'cmd_dns__unable_add_a_record' => "Hinzufügen von A-Eintrag nicht möglich: %1",
    'cmd_dns__unable_add_cname_record' => "Hinzufügen von CNAME-Eintrag nicht möglich: %1",
    'cmd_dns__unable_add_dns_record' => "DNS-Eintrag kann nicht hinzugefügt werden: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "EXT_NS-Eintrag konnte nicht hinzugefügt werden: %1",
    'cmd_dns__unable_add_ns_record' => "NS-Eintrag kann nicht hinzugefügt werden: %1",
    'cmd_dns__unable_add_ptr_record' => "PTR-Eintrag kann nicht hinzugefügt werden: %1",
    'cmd_dns__unable_add_txt_record' => "TXT-Eintrag kann nicht hinzugefügt werden: %1",
    'cmd_dns__unable_create_dns_zone' => "DNS-Zone %1 kann nicht erstellt werden",
    'cmd_dns__unable_define_dns_record' => "DNS-Eintrag %1 kann nicht definiert werden.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Standardstatus der DNS-Zone kann nicht abgerufen werden: %1",
    'cmd_dns__unable_insert_a_record' => "A-Eintrag kann nicht eingefügt werden: %1",
    'cmd_dns__unable_insert_mx_record' => "MX-Eintrag kann nicht eingefügt werden: %1",
    'cmd_dns__unable_insert_ns_record' => "NS-Eintrag kann nicht eingefügt werden: %1",
    'cmd_dns__unable_set_dns_zone_status' => "DNS-Zonenstatus kann nicht konfiguriert werden: %1",
    'cmd_domains__dom_already_exists' => "Domain %1 existiert bereits.",
    'cmd_domains__dns_record_already_exists' => "Domain %1 kann nicht erstellt werden, da bereits ein DNS-Eintrag existiert, der auf Host %1 verweist.",
    'cmd_domains__dom_already_exists1' => "Es gibt %2 Subdomains in dieser Domain. Domain %1 existiert bereits.",
    'cmd_domains__dom_already_exists2' => "Subdomain %1 existiert bereits.",
    'cmd_domains__dalias_already_exists' => "Dieser Alias existiert bereits.",
    'cmd_domains__domain_alias_already_exists' => 'Ein Domain-Alias mit diesem Namen ist bereits vorhanden.',
    'cmd_domains__unable_del_mail_for_dom' => "E-Mail-Services für Domain %1 können nicht gelöscht werden",
    'cmd_domains__unable_delete_anonymous_ftp' => "Anonymous-FTP-Konto für Domain %1 kann nicht gelöscht werden",
    'cmd_domains__unable_update_dom_param' => "Domainparameter können nicht aktualisiert werden: %1",
    'cmd_domains__unable_rename_client_exist' => "Der Benutzername des Domainadministrators wird bereits verwendet.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Hosting-Typ ist nicht physisch.",
    'cmd_hosting__unable_create_user' => "Benutzer %2 kann nicht erstellt werden: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "IP-Adresse für namensbasierte virtuelle Hosts kann nicht definiert werden: %1",
    'cmd_hosting__unable_del_old_hst' => "Vorher eingerichtetes Hosting kann nicht gelöscht werden: %1",
    'cmd_hosting__unable_del_protected_directory' => "Geschütztes Verzeichnis kann nicht gelöscht werden: %1.",
    'cmd_hosting__unable_del_web_user' => "Webbenutzer kann nicht gelöscht werden: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Virtueller Host kann nicht erstellt bzw. aktualisiert werden: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Frame-Weiterleitungs-Hosting kann nicht eingerichtet werden.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Konfigurationsdatei von proftpd kann nicht neu erstellt werden: %1.",
    'cmd_hosting__unable_set_up_ssl' => "SSL/TLS konnte nicht eingerichtet werden: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Schutz des SSL/TLS-Verzeichnisses konnte nicht entfernt werden: %1",
    'cmd_hosting__unable_update_dest_url' => "Ziel-URL konnte nicht aktualisiert werden %1",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "DNS-Zone für die Domain kann nicht aktualisiert werden: Ausführung des Dienstprogramms fehlgeschlagen.",
    'cmd_hosting__unable_update_ftp_passwd' => "FTP-Passwort konnte nicht aktualisiert werden: %1",
    'cmd_hosting__unable_update_user' => "Benutzer %2 kann nicht aktualisiert werden: %1",
    'cmd_hosting__unknown_hst_type' => "Unbekannter Hosting-Typ.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Sie sind zum Beenden des Hosting-Services nicht berechtigt.",
    'cmd_mail__autoresponder__not_configured' => "Die automatische Antwort für dieses E-Mail-Konto ist nicht konfiguriert",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adresse %1 wird bereits für die E-Mail-Weiterleitung verwendet.",
    'cmd_mail__alias_already_exists' => "Alias existiert bereits.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Die Autoresponder-ID und E-Mail-Konto-ID stimmen nicht überein.",
    'cmd_mail__autoresp_id_is_undefined' => "Die Autoresponder-ID ist nicht angegeben.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Dieser E-Mail-Alias ist bereits für das E-Mail-Konto %1 vorhanden.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "E-Mail-Konto %1 hat diese Mailingliste bereits abonniert.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "E-Mail-Konto %1 existiert bereits in dieser Domain.",
    'cmd_mail__mail_name_not_exist' => "Das E-Mail-Konto existiert nicht.",
    'cmd_mail__mail_name_passwd_part' => "Der Name des E-Mail-Kontos sollte nicht im Passwort enthalten sein.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Mailingliste %1 existiert bereits auf dieser Domain.",
    'cmd_mail__mailname_already_exist_in_mg' => "E-Mail-Konto %1 befindet sich bereits in einer Mailgruppe.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "E-Mail-Konto %1 existiert bereits in dieser Domain.",
    'cmd_mail__mailname_already_exists' => "E-Mail-Konto existiert bereits.",
    'cmd_mail__mailname_is_invalid' => "Name von E-Mail-Konto %1 ist ungültig.",
    'cmd_mail__mailname_unable_update' => "Eigenschaften des E-Mail-Kontos können nicht aktualisiert werden:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Die maximale Anzahl an Autorespondern für diese Domain wurde erreicht.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Die maximale Anzahl an Mailgruppen für diese Domain wurde erreicht.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Die maximale Anzahl an Weiterleitern für diese Domain wurde erreicht.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Die maximale Anzahl an Postfächern wurde erreicht.",
    'cmd_mail__no_members_specified' => "keine Mitglieder angegeben.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Das Passwort ist zu einfach, bitte ein anderes wählen.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Diese E-Mail-Adresse wird bereits verwendet.",
    'cmd_mail__unable_define_autoresp_id' => "Die Autoresponder-ID %1 konnte nicht festgelegt werden.",
    'cmd_mail__unable_update_mail_for_dom' => "Ändern der E-Mail-Service-Einstellungen für Domain %1 fehlgeschlagen",
    'cmd_mail__unable_del_mail_for_dom' => "E-Mail-Service konnte für die Domain nicht entfernt werden %1",
    'cmd_mail__unable_del_mail_redirection' => "Weiterleitungsservice %1 konnte nicht entfernt werden.",
    'cmd_mail__unable_remove_autoresp' => "Autoresponder konnte nicht entfernt werden.%1",
    'cmd_mail__unable_remove_mail_group_members' => "Mailgruppenmitglieder können nicht entfernt werden: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Deaktivieren der Mailgruppe fehlgeschlagen: %1",
    'cmd_mail__unable_update_mail_redirect' => "Weiterleitungsservice %1 konnte nicht neu konfiguriert werden.",
    'cmd_mail__uploaded_file_is_too_big' => "Hochgeladene Datei ist zu groß.",
    'cmd_mail__additionally' => "Zusätzlich:",
    'cmd_pd__invalid_login' => "Falscher Benutzername.",
    'cmd_pd__this_user_already_exist' => "Dieser Benutzer ist bereits vorhanden.",
    'cmd_pd__unable_define_hst_type' => "Hosting-Typ kann nicht definiert werden.",
    'cmd_pd__unable_upd_pd_usr' => "Eigenschaften von Benutzer des geschützten Verzeichnisses können nicht aktualisiert werden: %1.",
    'cmd_pd__user_is_undefined' => "Benutzer ist nicht definiert.",
    'cmd_server__no_enough_free_disk_space' => "Nicht genügend Speicherplatz!",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "Das alte Passwort ist falsch. Bitte nochmals versuchen.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "Maximale Anzahl Webbenutzer für diese Domain wurde erreicht.",
    'cmd_web_usr__unable_create_user' => "Systembenutzer kann nicht erstellt werden: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Grenze für Anzahl an Webbenutzern kann nicht definiert werden: %1",
    'cmd_web_usr__user_already_exists' => "Benutzer existiert bereits.",
    'cmd_web_usr__web_user_name_is_invalid' => "Name von Webbenutzer %1 ist ungültig.",
    'cmd_web_usr__web_user_not_exist' => "Webbenutzer existiert nicht.",
    'common_func__exec_bad_argument' => "exec-Argument darf keine einfachen Anführungszeichen enthalten.",
    '__eol' => 'Zeilenumbrüche',
    'eol__binary_file' => 'Änderung des Zeilenumbruchstils in der binären Datei nicht möglich.',
    'cp_access_admin_deny' => "Der Zugriff für den Administrator mit der Adresse '%1' ist nach den IP-Zugriffsrichtlinien beschränkt.",
    'create_domain_warn__' => "Während der Domainerstellung wurden folgende Ausnahmen definiert:",
    'create_domain__client_select' => 'Wählen Sie den Kunden aus, für den Sie die Domain erstellen möchten.',

    'dashboard__nav_button_name' => "Start",
    'dalias__list_title' => 'Domain-Aliase von Domain %1',
    'dalias__list_legend' => 'Domain-Aliase',
    'dalias__list_header' => 'Domain-Aliase',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Domain-Alias-Name',
    'dalias__list_ascii_name' => 'Im ASCII-Format',
    'dalias__remove_title' => 'Die folgenden Domain-Aliase von Domain %1 werden entfernt:',
    'dalias__select_domain_aliases_to_remove' => 'Wählen Sie die Domain-Aliase aus, die entfernt werden sollen.',
    'dalias__mail_turn_on_failed' => 'E-Mail-Service kann nicht aktiviert werden: %1',
    'dalias__web_turn_on_failed' => 'Webservice kann nicht aktiviert werden: %1',
    'db_usr_edit__db_usr_name_old' => "Alter Datenbank-Benutzername",
    'database_server_edit_form__cannot_infer_type' => 'Aus den angegebenen Daten kann keine Verbindungsmethode abgeleitet werden. Geben Sie "127.0.0.1" als Hostname des Datenbankservers an, um eine Verbindung über TCP/IP mit dem angegebenen Port herzustellen, oder lassen Sie das Feld Port leer, um den Unix-Socket "%1" zu verwenden.',
    'database_server_edit_form__duplicate' => 'Ein Datenbankserver mit dieser Kombination von Hostadresse und Portnummer ist bereits registriert.',
    'database_server_edit_form__host_is_invalid' => 'Der angegebene Hostname ist ungültig.',
    'database_server_edit_form__port_is_invalid' => 'Die angegebene Portnummer ist ungültig.',
    'database_server_error__consult_admin' => 'Bitte kontaktieren Sie den Serveradministrator.',
    'database_server_error__last__connection_failed' => 'Der letzte Versuch, diesen Datenbankserver zu steuern, schlug aufgrund von Netzwerkproblemen fehl.',
    'database_server_error__last__permission_denied' => 'Der letzte Versuch, diesen Datenbankserver zu steuern, schlug fehl, da das angegebene Konto keine Administratorrechte besitzt.',
    'database_server_error__last__credentials_not_set' => "Der letzte Versuch, eine Verbindung zu diesem Server herzustellen, ist fehlgeschlagen, da kein gültiger Administratorbenutzername und -passwort angegeben wurde.",
    'database_server_error__last__other_error' => 'Der letzte Versuch, diese Datenbank zu steuern, ist fehlgeschlagen.',
    'database_server_error__real__connection_failed' => 'Verbindung zum Datenbankserver aufgrund von Netzwerkproblemen fehlgeschlagen:',
    'database_server_error__real__permission_denied' => 'Verbindung zum Datenbankserver fehlgeschlagen, da das angegebene Konto keine Administratorrechte besitzt:',
    'database_server_error__real__duplicate_object' => 'Verbindung zum Datenbankserver aufgrund eines Namenskonflikt fehlgeschlagen:',
    'database_server_error__real__unacceptable_name' => 'Verbindung zum Datenbankserver aufgrund eines ungültigen Objektnamens fehlgeschlagen:',
    'database_server_error__real__unacceptable_password' => 'Verbindung zum Datenbankserver aufgrund eines ungültigen Passworts fehlgeschlagen:',
    'database_server_error__real__credentials_not_set' => "Plesk kann keine Verbindung zum Datenbankserver herstellen, da kein gültiger Administratorbenutzername und -passwort angegeben wurde.",
    'database_server_error__real__other_error' => 'Verbindung zum Datenbankserver fehlgeschlagen:',
    'database_server_error__test__connection_failed' => 'Die Testverbindung zum Datenbankserver ist aufgrund von Netzwerkproblemen fehlgeschlagen:',
    'database_server_error__test__permission_denied' => 'Die Testverbindung zum Datenbankserver ist fehlgeschlagen, da das angegebene Konto keine Administratorrechte besitzt:',
    'database_server_error__test__duplicate_object' => 'Die Testverbindung zum Datenbankserver ist aufgrund eines Namenskonflikts fehlgeschlagen:',
    'database_server_error__test__unacceptable_name' => 'Die Testverbindung zum Datenbankserver ist aufgrund eines ungültigen Objektnamens fehlgeschlagen:',
    'database_server_error__test__unacceptable_password' => 'Die Testverbindung zum Datenbankserver ist aufgrund eines ungültigen Passworts fehlgeschlagen:',
    'database_server_error__test__credentials_not_set' => "Die Testverbindung zu diesem Server ist fehlgeschlagen, da kein gültiger Administratorbenutzername und -passwort angegeben wurde.",
    'database_server_error__test__other_error' => 'Die Testverbindung zum Datenbankserver ist fehlgeschlagen:',

    'db__create_new_db' => "Datenbank hinzufügen",
    'db__db_add' => "Datenbank hinzufügen",
    'db__db_for_dom' => "Datenbanken der Website %1",
    'db__db_id_undefined' => "Datenbank-ID ist nicht definiert.",
    'db__db_name' => "Datenbankname",
    'db__db_not_exist' => "Datenbank existiert nicht.",
    'db__db_type' => "Typ",
    'db__db_server' => "Datenbankserver",
    'db_server_not_exist' => "Datenbankserver existiert nicht.",
    'db__db_user_not_exist' => "Datenbankbenutzer existiert nicht.",
    'db__domain_not_exist' => "Domain existiert nicht.",
    'db__enter_db_name' => "Geben Sie einen neuen Datenbanknamen ein.",
    'db__invalid_db_id' => "Datenbank-ID ist ungültig.",
    'db__invalid_db_name' => "Der Datenbankname ist ungültig. Der Datenbankname darf nur Zeichen des Latin-Zeichensatzes, Ziffern, Unterstriche oder Bindestriche enthalten. Er darf aus höchstens 63 Zeichen bestehen.",
    'db__max_db_reached_for_dom' => "Die Grenze für die Anzahl an Datenbanken für diese Domain wurde erreicht.",
    'db__max_mssql_db_reached_for_dom' => "Die maximale Anzahl der Microsoft SQL-Serverdatenbanken wurde für diese Domain erreicht",
    'db__postgres_not_connect_for_admin' => "Verbindung zu PostgreSQL nicht möglich. Aktivieren Sie die Unterstützung von PostgreSQL auf der Server-Administrationsseite.",
    'db__postgres_not_connect_for_client' => "Verbindung zu PostgreSQL nicht möglich. Bitte wenden Sie sich an Ihren Systemadministrator.",
    'db__remove_db_on_domain' => "Die folgenden Datenbanken für die Website %2 des Kunden %1 werden entfernt:",
    'db__remove_db_on_domain_of_cl' => "Die folgenden Datenbanken für Domain %2 im Besitz des Kunden %1 werden entfernt:",
    'db__remove_db_linked_resource' => 'Diese Datenbank wird von einer Webanwendung verwendet. Sie kann nur nach Deinstallation der Webanwendung entfernt werden.',
    'db__remove_db_users' => "Die folgenden Benutzer der Datenbank %3 der Website %2 im Besitz des Kunden %1 werden entfernt:",
    'db__remove_db_users_of_cl' => "Die folgenden Benutzer der Datenbank %3 der Website %2 im Besitz des Kunden %1 werden entfernt:",
    'db__select_db_for_remove' => "Wählen Sie die Datenbanken aus, die entfernt werden sollen.",
    'db__select_db_users_for_remove' => "Wählen Sie die Datenbankbenutzer aus, die entfernt werden sollen.",
    'db__unable_create_db_user' => "Datenbankbenutzer kann nicht erstellt werden: %1",
    'db__unable_define_db_name' => "Datenbankname kann nicht definiert werden: %1",
    'db__unable_define_db_user' => "Datenbankbenutzer kann nicht definiert werden: %1",
    'db__unable_define_db_users' => "Datenbankbenutzer können nicht definiert werden: %1",
    'db__unable_select_dom_name' => "Domainname kann nicht ausgewählt werden: %1",
    'db_edit__db_for_dom' => "Benutzer von Datenbank %1 auf Domain %2",
    'db_edit__invalid_db_name' => "Der Datenbankname ist ungültig.",
    'db_edit__no_users' => "Es sind keine Benutzer mit Zugangsdaten für diese Datenbank vorhanden.",
    'db_edit__unable_define_db_usrs' => "Datenbankbenutzer können nicht definiert werden: %1",
    'db_edit__unable_select_db_usr' => "Datenbankbenutzer kann nicht ausgewählt werden.",
    'db_edit__db_user_password_for_' => "Bitte geben Sie das Passwort ein, um sich als Datenbankbenutzer %1 anzumelden",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Datenbankbenutzer hinzufügen",
    'db_usr_edit__db_usr_name' => "Datenbankbenutzername",
    'db_usr_edit__edit_db_usr' => "Zugangsdaten für Datenbankbenutzerkonto festlegen",
    'db_usr_edit__for_db' => "in Datenbank %1",
    'db_usr_edit__not_create_pass' => "Bei diesem Vorgang wird ein Datenbankbenutzerkonto ohne Passwort erstellt. Möchten Sie einen Benutzer anlegen, ohne ein Passwort zuzuweisen?",
    'dbuser__only_one_user_can_be_default' => "Es kann nur ein Benutzer als Standard festgelegt werden.",
    'db_server__cannot_delete_default' => "Der Standard-Datenbankserver kann nicht gelöscht werden.",
    'db_server__cannot_delete_local' => "Der lokale Datenbankserver kann nicht gelöscht werden.",
    'db_server__cannot_delete_used' => 'Ein Datenbankserver kann nicht gelöscht werden, wenn auf ihm Datenbanken oder Datenbankbenutzer gehostet werden.',
    'demo__disabled_in_demo' => "Diese Aktion ist in der Demoversion nicht verfügbar.",
    'defaultcomponents__title' => "Drittanbieterservices auswählen",
    'defaultcomponents__select_default' => "Standard-%1-Komponente auswählen",//to check
    'defaultcomponents__not_installed' => "(nicht installiert)",
    'defaultcomponents__not_configured' => "(nicht konfiguriert)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Manche Service-Kategorien enthalten ungültige Abschnitte oder es wurde keine Auswahl getroffen.",
    'defaultcomponents__depends_on' => "(erfordert %1)",
    'defaultcomponents__parameters' => "Parameter von %1",
    'component_name__antivirus' => "Virenschutz",
    'component_name__database' => "SQL-Server",
    'component_name__sqladmin' => "MySQL-Webadmin",
    'component_name__sqladminmysql' => "MySQL-Webadmin",
    'component_name__dnsserver' => "DNS-Server",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "FTP-Server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Mailserver",
    'component_name__local_mailserver' => "Lokaler Mailserver",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web-Scripting",
    'component_name__spamfilter' => "Spamfilter",
    'component_name__stats' => "Webstatistiken",
    'component_name__stunnel' => "SSL/TLS-Wrapper",
    'component_name__webmail' => "WebMail",
    'component_name__webpublish' => "Web-Publishing",
    'component_name__webserver' => "Webserver",
    'dns__dns_record_invalid_values' => 'Es wurden fehlerhafte Werte für den DNS-Eintrag angegeben: %1: %2',
    'dns__dns_record_not_found' => 'DNS-Eintrag nicht gefunden',
    'dns__dns_zone_invalid_values' => 'Es wurden fehlerhafte DNS-Zonenparameter angegeben.',

    'dns__soa_mname_title' => 'Primärer Nameserver',
    'dns__soa_mname_legend' => 'Nameserver',
    'dns__soa_mname_autoselect' => '(Automatische Auswahl)',

    'dns__dns_zone_off_remove_title' => "Die folgenden Ressourceneinträge werden aus Zone %1 entfernt:",
    'dns__dns_zone_master_remove_title' => "Ressourcen-Einträge wurden von der DNS-Zone %1 entfernt",
    'dns__dns_zone_slave_remove_title' => "Die folgenden primären Nameserver-Einträge für %1 werden entfernt:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Geben Sie die Eintragszeichenfolge ein',
    'dns_add__is_spf_syntax' => 'SPF-Eintrag',
    'dns_add__spf_value_is_invalid' => "Der Wert des SPF-Eintrags ist nicht korrekt, er muss mit 'v=spf' beginnen'",
    'dns__dns_zone_status' => "DNS-Zonenstatus.",
    'dns__invalid_ip_address' => "IP-Adresse des neuen primären DNS-Servers ist ungültig oder leer.",
    'dns__ip_address' => "IP-Adresse",
    'dns__master_dns_type' => "ist ein primärer DNS-Server",
    'dns__masters' => "primäre DNS-Server",
    'dns__soa_minimum_too_large' => 'Es wird nicht empfohlen, abgelehnte Anfragen für mehr als drei Stunden im Cache-Speicher abzulegen.',
    'dns__select_masters_to_remove' => "Wählen Sie die primären DNS-Server aus, die entfernt werden sollen.",
    'dns__select_template_record_to_remove' => 'Wählen Sie die DNS-Template-Einträge aus, die entfernt werden sollen.',
    'dns__nameservers_for_domain' => "Nameserver für die Domain",
    'dns__remove_dns_zone_of_domain__' => "Löschen von DNS-Einträgen aus Domain %1",
    'dns__remove_dns_zone_template__' => "Die folgenden DNS-Einträge werden aus dem Template entfernt:",
    'dns__remove_this_dns_record?' => "Möchten Sie diesen DNS-Eintrag wirklich entfernen?",
    'dns__restore_default' => "Wiederherstellen der DNS-Zone mittels Template",
    'dns__restore_default_confirm' => "Durch das Wiederherstellen der DNS-Zone wird die aktuelle DNS-Zonen-Konfiguration verworfen. Trotzdem fortfahren?",
    'dns__restore_default_error' => "Fehler bei der Wiederherstellung der DNS-Zone:",
    'dns__slave_dns_type' => "ist ein sekundärer DNS-Server",
    'dns__subdomain_dns_rec_removed' => "Der A-Eintrag wurde von der Subdomain %1 entfernt",
    'dns__zone_switched_off_no_ns' => "Die Zone wurde deaktiviert, da kein NS-Eintrag %1 besteht. Es muss ein NS-Eintrag in der Zone vorhanden sein. Klicken Sie zum Hinzufügen des Eintrags zur Zone auf die Schaltfläche 'Eintrag hinzufügen'.",
    'dns__cant_switch_on_no_ns' => "Die Zone kann nicht aktiviert werden, da kein NS-Eintrag %1 besteht. Es muss ein NS-Eintrag in der Zone vorhanden sein. Klicken Sie zum Hinzufügen des Eintrags zur Zone auf die Schaltfläche 'Eintrag hinzufügen'.",
    'dns__unable_activate/deactivate_dns' => "DNS konnte nicht aktiviert/deaktiviert werden: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Hinzufügen von primärem DNS-Server nicht möglich: doppelter Eintrag.",
    'dns__unable_add_dns_master_local_ip' => "IP-Adresse konnte nicht zum primären DNS-Server hinzugefügt werden: Dieser Eintrag muss auf einem Remote-Server erstellt werden.",
    'dns__unable_define_dns_record' => "DNS-Eintrag kann nicht definiert werden: %1",
    'dns__unable_get_dns_template_status' => "DNS-Template-Status kann nicht abgefragt werden.",
    'dns__unable_remove_dns_rec' => "DNS-Eintrag kann nicht entfernt werden: %1",
    'dns__warnings__' => "Ergebnis der DNS-Zonenänderung:",
    'dns__you_not_have_perm_manage_dns' => "Sie sind zum Verwalten der DNS-Zone für diese Domain nicht berechtigt.",
    'dns__cant_create_record_with_server_ip' => "Diese IP-Adresse kann nicht hinzugefügt werden, da sie mit der IP-Adresse dieses von Plesk verwalteten Servers übereinstimmt.",

    'dns__tabs_acl' => "Zonentransfers",
    'dns__acl_add_network_legend' => "Hinzufügen",
    'dns__acl_add_ip_legend' => "IP-Adresse hinzufügen",
    'dns__acl_network_not_allowed' => "Diese Netzwerkadresse ist nicht durch das DNS in Windows zugelassen.",
    'dns__acl_enter_ip_address_with_mask' => "IP-Adresse/Netzwerkmaske",
    'dns__acl_enter_ip_address' => "IP-Adresse",
    'dns__acl_list_network_legend' => "Zugelassene Netzwerkadressen von Servern, die eine Kopie der DNS-Zone erhalten können",
    'dns__acl_list_ip_legend' => "Zugelassene IP-Adressen von Servern, die eine Kopie der DNS-Zone erhalten können",
    'bt_dns_acl_add_network' => "Hinzufügen",
    'bt_dns_acl_add_ip' => "IP-Adresse hinzufügen",

    'dns_add__add_rec_for_zone' => "%1 für Zone %2 hinzufügen",
    'dns_add__canonical_dom_name_is_invalid' => "Kanonischer Domainname ist ungültig.",
    'dns_add__enter_canonical_name' => "Kanonischer Name",
    'dns_add__enter_dom_name' => "Domainname",
    'dns_add__enter_ip_address' => "IP-Adresse",
    'dns_add__enter_ip_mask' => "IP-Adresse und Netzwerkmaske",
    'dns_add__enter_mail_domain' => "E-Mail-Domain",
    'dns_add__enter_mail_exchanger' => "Mail-Exchange-Server",
    'dns_add__enter_nameserver' => "Nameserver",
    'dns_add__enter_txt_record' => "TXT-Eintrag",
    'dns_add__enter_service_name' => "Service-Name",
    'dns_add__hint_service_name' => "Beispiel: SIP (ohne Unterstrich)",
    'dns_add__enter_protocol' => "Protokoll",
    'dns_add__hint_protocol_name' => "Beispiel: TCP (ohne Unterstrich)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priorität",
    'dns_add__specify_weight_of_service' => "Relative Gewichtung für Einträge mit gleicher Priorität",
    'dns_add__enter_target_host' => "Zielhost",
    'dns_add__hint_target_host' => "Beispiel: beispiel.com",
    'dns_add__enter_target_port' => "Zielport",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Wert",
    'dns_add-invalid-A_ip' => "IP-Adresse ist ungültig.",
    'dns_add-invalid-AAAA_ip' => "IP-Adresse ist ungültig.",
    'dns_add-invalid-PTR_ip_mask' => "Ungültige IP-Adresse/Netzwerkmaske.",
    'dns_add-invalid-SRV_service_name' => "Ungültiger Dienstname",
    'dns_add-invalid-SRV_protocol_name' => "Ungültiges Protokoll",
    'dns_add-invalid-SRV_target_port' => "Ungültiger Zielport",

    'dns_add__invalid_ip' => "IP-Adresse ist ungültig.",
    'dns_add__low' => "gering",
    'dns_add__mail_dom_name_is_invalid' => "E-Mail-Domainname ist ungültig.",
    'dns_add__nameserver_is_invalid' => "Nameserver ist ungültig.",
    'dns_add__record' => "%1-Eintrag",
    'dns_add__select_prefer_for_mail_exchange_server' => "Bitte geben Sie die Priorität des E-Mail-Exchange-Servers an",
    'dns_add__unable_insert_new_dns_rec' => "DNS-Eintrag kann nicht eingefügt werden: %1",
    'dns_add__very_high' => "sehr hoch",
    'dom_ctrl__allowed' => "Erlaubt",
    'dom_ctrl__db' => "MariaDB/MySQL-Datenbanken",
    'dom_ctrl__mssql_db' => "MS-SQL-Datenbank",
    'dom_ctrl__disk_space' => "Speicherplatz",
    'dom_ctrl__dom_adm' => "Domain %1 von %2",
    'dom_ctrl__dom_cl' => "Domain %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "In der Domain ist Weiterleitung ohne Angabe der Weiterleitungs-URL aktiviert",
    'dom_ctrl__domain_has_frame_forwarding' => "In der Domain ist Frame-Weiterleitung zu URL %1 aktiviert",
    'dom_ctrl__domain_has_no_hosting' => "In der Domain ist Hosting nicht konfiguriert",
    'dom_ctrl__domain_has_physical_hosting' => "Webhosting ist für diese Domain auf IP-Adresse %1 konfiguriert",
    'dom_ctrl__domain_has_standard_forwarding' => "Domain hat eine Standardweiterleitung zu URL %1",
    'dom_ctrl__maillists' => "Mailinglisten",
    'dom_ctrl__mboxes' => "E-Mail-Postfächer",
    'dom_ctrl__mg' => "E-Mail-Weiterleitungen",
    'dom_ctrl__resource_name' => "Ressource",
    'dom_ctrl__resp' => "Autoresponder",
    'dom_ctrl__subdom' => "Subdomains",
    'dom_ctrl__dom_aliases' => "Domain-Aliase",
    'dom_ctrl__traffic' => "Verkehr",
    'dom_ctrl__unable_activate/deactivate_dom' => "Domain konnte nicht aktiviert/deaktiviert werden: %1",
    'dom_ctrl__used' => "Verwendet",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Webbenutzer",
    'dom_pref__bounce_with_phrase' => "Zurücksenden mit Nachricht",
    'dom_pref__bounce' => "Bounce (Zurücksenden)",
    'dom_pref__catch_addr' => "Weiterleitung an Adresse",
    'dom_pref__reject' => 'Abweisen',
    'dom_pref__confirm_domain_removing' => "Bitte vergessen Sie nicht, die Domainbesucher über die Änderung des Domainnamens zu benachrichtigen. Möchten Sie die Domain wirklich umbenennen?",
    'dom_pref__db_inconsystency' => "Datenbank-Inkonsistenz.",
    'dom_pref__dbs' => "Datenbanken",
    'dom_pref__delete_traffic_stat' => "Web- und Traffic-Statistiken aufbewahren",
    'dom_pref__delete_traffic_stat_older' => "Web- und Traffic-Statistiken aufbewahren",
    'dom_pref__dom_level_name_conflict' => "Der Benutzername des Domainadministrators steht in Konflikt mit dem Benutzernamen eines Kunden.",
    'dom_pref__invalid_disk_space_limit' => "Speicherplatzlimit ist ungültig. Maximalwert: %1",
    'dom_pref__invalid_expiration_date_limit' => "Gültigkeitsdauer ungültig.",
    'dom_pref__invalid_max_traffic_limit' => "Traffic-Grenze ungültig. Maximalwert: %1",
    'dom_pref__limits_of_dom' => "Grenzen für Domain %1",
    'dom_pref__mail_grps' => "Mailgruppen",
    'dom_pref__mail_nonexistent_user' => "Vorgehensweise bei E-Mails an nicht vorhandene Benutzer",
    'dom_pref__mail_redirs' => "E-Mail-Weiterleitungen",
    'dom_pref__mail_resps' => "E-Mail-Autoresponder.",
    'dom_pref__max_limit_is_invalid' => "%1 ist ungültig.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maximale Anzahl %1 ist ungültig.",
    'dom_pref__new_limit_less_currently_used' => "%1: angefordert - %2, momentan verwendet - %3",
    'dom_pref__older_that' => "für",
    'dom_pref__postboxes' => "E-Mail-Postfächer",
    'dom_pref__preferences_of_dom' => "Einstellungen für Domain %1",
    'dom_pref__redirect_to_itself' => "Die Domain wird an sich selbst weitergeleitet",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Die von Ihnen angegebene Aufbewahrungszeit für Domain-Traffic-Statistiken ist kürzer als die des Servers (%1 Monat(e)). Die Aufbewahrungszeit für Statistiken wird auf den Standardwert des Servers gesetzt (%1 Monat(e)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Hinzufügen von Präfix 'www' zu Domain nicht möglich: %1",
    'dom_pref__unable_define_physical_hst_param' => "Parameter für physisches Hosting können nicht definiert werden: %1",
    'dom_pref__unable_rename_domain' => "Die Domain %1 kann nicht umbenannt werden: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Postfachkontingnent für diese Domain kann nicht eingerichtet werden: %1",
    'dom_pref__unable_set_up_web_user_script' => "Scripting für Webbenutzer kann nicht eingerichtet werden: %1",
    'dom_pref__unlimited' => "Unbegrenzt",
    'dom_pref__web_usrs' => "Webbenutzer",
    'dom_pref__you_already_have_%object' => "Sie haben bereits %1",
    'cu_domain__error_unable_update_ftp_users' => 'Aktualisierung der Domain-FTP-Benutzer fehlgeschlagen: %1',
    'dom_cli__warning_ignore_quota' => 'WARNUNG: Die Option "-hard_quota" wird ignoriert: Speicherkontingent wird nicht unterstützt',
    'dom_user_client_login_exist' => "Auf der Domain %1 kann kein Plesk Zugang für den Domain-Administrator gewährt werden: Der Benutzername wird bereits verwendet.",
    'domain__unable_to_turn_on_service' => "Der %1-Service konnte nicht aktiviert werden.",
    'domains__change_the_status_of_domain?' => "Möchten Sie den Status der Domain %1 wirklich ändern?",
    'domains__client_info_hiding_traffic' => "%1 Domains, %2 aktive Domains, %3 Speicherplatz belegt",
    'domains__unable_to_change_client_status' => "Status des Kundenkontos kann nicht geändert werden: %1",
    'domains__unable_update_apache_settings' => "Einstellungen des Apache-Webservers konnten nicht aktualisiert werden",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Sie sind zum Entfernen von Domains nicht berechtigt.",
    'domains_list__unable_remove_doms' => "Domains können nicht entfernt werden: %1",
    'domaintrafficlist_header_of_domain__' => "Traffic auf Domain %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Wählen Sie die Domain-Aliase aus, die entfernt werden sollen.',
    'domain_aliases_remove__title' => 'Domain-Aliase werden entfernt',
    'domain_aliases__max_aliases_reached_for_dom' => "Die maximale Anzahl an Aliasen wurde für diese Domain erreicht.",
    'domain_edit__edit_title' => 'Domain-Alias-Name bearbeiten',
    'domain_alias_edit__type' => 'Domain-Alias-Typ',
    'domain_aliases__list_header' => 'Domain-Aliase',
    'domain_aliases__name' => 'Name',
    'domain_aliases__type' => 'Typ',
    'domain_aliases__type_full' => 'Web+FTP+E-Mail',
    'domain_aliases__type_web_ftp' => 'Web & FTP',
    'domain_aliases__page_title' => 'Domain-Aliase',
    'domain_aliases__legend' => 'Domain-Aliase',
    'domain_alias__domain_exists' => 'Eine Domain mit diesem Namen ist bereits vorhanden',
    'domain_alias__subdomain_exists' => 'Eine Subdomain mit diesem Namen ist bereits vorhanden',
    'domain_alias__dns_record_exists' => 'Ein DNS-Eintrag mit dem angegebenen Domain-Alias-Namen ist bereits vorhanden',
    'domain_alias__domain_alias_exists' => "Ein Domain-Alias mit diesem Namen ist bereits vorhanden",
    'domain_alias__invalid_type_full' => 'Der Mailserver unterstützt Domain-Aliase nicht.',
    'domain_alias__redirect_exists' => 'Weiterleitung zu sich selbst festgestellt.',

    'ds__anonymous_ftp' => "Anonymous FTP",
    'drweb__pagetitle' => 'Antiviren-Einstellungen',
    'drweb__drweb' => 'Antivirus E-Mail-Prüfung',
    'drweb__drweb_direction' => 'E-Mail-Nachrichten werden auf Viren überprüft',
    'drweb__drweb_direction_off' => 'Nicht auf Viren überprüfen',
    'drweb__drweb_direction_any' => 'Eingehende und ausgehende E-Mails',
    'drweb__drweb_direction_from' => 'Nur ausgehende E-Mails',
    'drweb__drweb_direction_to' => 'Nur eingehende E-Mails',
    'drweb__disable_reason_key' => 'Antivirus wird vom Lizenzschlüssel nicht unterstützt.',
    'drweb__disable_reason_perm' => 'Sie haben keine Berechtigung, Dr.Web zu verwalten.',
    'drweb__disable_reason_install' => 'Antivirus ist nicht installiert.',
    'drweb__filters' => 'Antivirus-Filter',
    'ds__dns' => "DNS-Zone",
    'ds__mail' => "E-Mail",
    'dumps_list__deletion_page_title' => "Die folgenden Backupdateien von Domain %1 werden entfernt:",
    'dumps_list__dumpfile_is_invalid' => "Datei %1 ist keine gültige Domain-Backupdatei.",
    'dumps_list__page_title' => "Backupdateispeicher",
    'dumps_upload__page_title' => "Backupdateien in Speicher hochladen",
    'dumps_list__repository_is_not_exist' => "Der Backupdateispeicher existiert nicht.",
    'dumps_list__unable_to_remove' => "Backupdatei kann nicht entfernt werden: %1",
    'dumps_list__dumpfile_can_conflict' => "Der angegebene Dateiname steht in Konflikt mit der Datei %1. Bitte geben Sie einen anderen Dateinamen an.",
    'dusr_ed__allow_dl_usr_access' => "Domainadministrator-Zugriff zulassen",
    'dusr_ed__information' => "Eigenschaften des Administrators von Domain %1",
    'dusr_ed__locale' => "Sprache des Domainadministrators",
    'dusr_ed__skin' => "Oberflächen-Skin des Domainadministrators",
    'dusr_ed__personal_information' => 'Persönliche Daten',
    'ess__error' => "Fehler",
    'example__' => "Beispiel: %1",
    'extras__allow_certificate_purchasing' => "Kauf von Zertifikaten zulassen",
    'extras__allow_domain_registration' => "Registrierung von Domains zulassen",
    'extras__allow_extras' => "Weitere Services zulassen",
    'extras__buy_new_key' => "Ihre aktuelle Lizenz erlaubt es Ihnen nicht, diese Objekte zu verändern.",
    'extras__setup_services' => "Zusätzliche Services einrichten",

    'ruleeditform__error' => 'Die Firewall-Regel kann nicht aktualisiert werden.',
    'ruleeditform__name_is_required' => 'Geben Sie den Namen der Regel an.',
    'ruleeditform__profiles_is_required' => 'Wählen Sie mindestens ein Profil aus.',
    'ruleeditform__invalid_ip' => 'Die angegebene IP-Adresse oder das Netzwerk ist ungültig.',
    'ruleeditform__invalid_port' => 'Der angegebene Port ist ungültig. Die möglichen Werte sind 1000 oder 1000-1051',

    'filemanager__items' => 'Elemente im Verzeichnis %1',
    'filemanager__items_paging' => 'Elemente im Verzeichnis %1',

    'get_password__encrypted_password' => "Informationen zum Passwort können nicht versendet werden: Das Passwort wird in verschlüsselter Form gespeichert.",
    'get_password__mail_error' => "Bei dem Versuch, das Passwort an die E-Mail-Adresse %1 zu senden, ist ein Fehler aufgetreten: %2",
    'get_password__mail_ok' => "Das Passwort wurde erfolgreich an folgende E-Mail-Adresse versendet: %1",
    'get_password__message' => "Ihr Benutzername für Zugriff auf das System:%1\nIhr Passwort ist %2",
    'get_password__subject' => "Passwort für den Shellzugriff",
    'groups__available' => "Verfügbare Mailgruppen",
    'groups__groups_for_mailname' => "Mailgruppen, die vom E-Mail-Konto %1 abonniert wurden",
    'groups__member_of' => "Mitglied der folgenden Mailgruppen",
    'help__help_area' => "Hilfebereich.",
    'hst_def__auth_disabled' => "verboten",
    'hst_def__auth_enabled' => "erlaubt",
    'hst_def__change_curr_dns_ip' => "Die aktuelle IP-Adresse des A-DNS-Eintrags wird geändert",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Keine der IP-Adressen des A-Eintrags passt zur IP-Adresse des Hosting-Kontos, der erstellt wird",
    'hst_def__dest_url' => "Ziel-URL",
    'hst_def__disk_quota' => "Speicherplatzkontingent",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Das Speicherplatzlimit, das Sie setzen möchten, liegt unter dem Speicherplatzlimit des Anonymous-FTP-Eingangsverzeichnisses. Die Grenze des Anonymous-FTP-Eingangsverzeichnisses darf das Speicherplatzlimit der Domain nicht überschreiten.",
    'hst_def__frame_forwarding_definition' => "Zugewiesene Frame-Weiterleitung für Domain %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Warnung: Der FTP-Benutzer %1 wird in einem Hosting-Konto verwendet, existiert jedoch nicht im System.",
    'hst_def__hst_type_is_not_defined' => "Hosting-Typ ist nicht definiert",
    'hst_def__ip_based' => "IP-basiert",
    'hst_def__name_based_power_anonymous_ftp_down' => "Wenn dieses Hosting-Konto auf eine gemeinsam verwendete IP-Adresse umgestellt wird, ist der Anonymous-FTP-Service nicht mehr verfügbar. Trotzdem fortfahren?",
    'hst_def__password_is_invalid_password_syntax' => "Das Passwort ist ungültig. Verwenden Sie keine einfachen Anführungszeichen oder Zeichen des nationalen Alphabets (z. B. ä, ö, ü, ß) in Ihrem Passwort. Die Passwort muss zwischen 5 und 14 Zeichen lang sein und darf den Benutzernamen nicht enthalten.",
    'hst_def__shell' => "SSH-Zugriff auf Server-Shell unter dem Systembenutzer des Abonnements",
    'hst_def__shell_windows' => "Remotedesktop-Zugriff auf den Server über das Abonnement des Systembenutzers",
    'hst_def__standard_forwarding_definition' => "Zuweisen der Standardweiterleitung für Domain %1",
    'hst_def__title_name_based' => "Namensbasiert",
    'hst_def__unable_create/update_physic_hst' => "Physisches Hosting kann nicht erstellt/aktualisiert werden: %1",
    'hst_def__unable_create/update_std_fwd' => "Standard-Weiterleitung kann nicht erstellt/aktualisiert werden: %1",
    'hst_def__unable_create_forwarding_myself' => "Die Weiterleitung kann nicht zur Domain selbst erstellt werden.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Die Verwendung eines einzigen Verzeichnisses zum Speichern von Inhalten mit und ohne SSL/TLS ist nicht zugelassen: SSL/TLS-Unterstützung ist nicht aktiviert.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "SSL/TLS-Unterstützung kann nicht aktiviert werden: Kein SSL/TLS-Zertifikat wurde installiert.",
    'hst_def__url_is_invalid' => "URL ist ungültig.",
    'hst_def__virtual_host_access' => "Virtual Host-Zugang für Domain %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "WARNUNG. Dieser virtuelle Host verwendet für das Hosting eine IP-Adresse, die nicht existiert.",
    'hst_def__you_have_no_ips' => "Es sind keine IP-Adressen verfügbar, und Sie sind nicht berechtigt, namensbasiertes Hosting zu erstellen.",
    'hst_sel__header' => "Um eine Website auf diesem Server zu hosten, wählen Sie die Option Physisches Hosting aus. Um eine Domain-Weiterleitung zu einer Site auf einem anderen Rechner einzurichten, wählen Sie die Option Frame-Weiterleitung oder Standardweiterleitung aus.\n Bei der Standardweiterleitung wird der Benutzer zu der Site umgeleitet, wobei die URL der Site im Browser des Benutzers angezeigt wird, so dass der Benutzer die Weiterleitung bemerkt. Bei der Frame-Weiterleitung wird der Benutzer zu der Site umgeleitet, ohne zu bemerken, dass sich die Website eigentlich an einem anderen Ort befindet.",
    'hst_sel__physical_hst' => "Physisches Hosting",
    'hst_sel__select_hst_type' => "Wählen Sie den Hosting-Typ für die Domain aus",
    'hst_sel__select_hst_type_warning' => "Wählen Sie den Hosting-Typ für die Domain aus",
    'hst_sel__hosting_exists' => "Hosting kann nicht erstellt werden, da es für diese Domain bereits eingerichtet ist. Sie werden zur Hosting-Verwaltungsseite umgeleitet.",
    'hst_sel__standard_frw' => "Standardweiterleitung",
    'hst_sel__frame_frw' => "Frame-Weiterleitung",
    '__frame_frw' => "Frame-Weiterleitung",
    '__hosting_exists' => "Hosting kann nicht erstellt werden, da es für diese Domain bereits eingerichtet ist. Sie werden zur Hosting-Verwaltungsseite umgeleitet.",
    '__choose_hst_type' => "Wählen Sie den gewünschten Hosting-Typ aus.",
    '__no_hst_conf' => "Für Ihre Domain ist kein Hosting eingerichtet.",
    '__physical_hst' => "Physisches Hosting",
    '__select_hst_type' => "Wählen Sie den Hosting-Typ für die Domain aus",
    '__standard_frw' => "Standardweiterleitung",
    '__warning' => "Warnung! Alle vorher gesetzten Parameter werden verworfen. Möchten Sie den Hosting-Typ wirklich ändern?",
    'i_cl_off' => "Kunde ist inaktiv.",
    'i_cl_off_by_admin' => "Das Kundenkonto wurde vom Serveradministrator gesperrt.",
    'i_cl_off_expired' => "Das Kundenkonto ist abgelaufen.",
    'i_cl_on' => "Der Kunde ist inaktiv.",

    'icf__title' => 'Internetverbindungs-Firewall',
    'icf__if_legend' => 'Schnittstellen',
    'icf__mode' => 'Modus',

    'invalid_value' => 'Wert ist ungültig',

    'ip_addr__already_exists' => "IP-Adresse %1 existiert bereits.",
    'ip_addr__cant_add' => "IP %1 existiert nicht oder gehört zum IP-Pool eines anderen Kunden",
    'ip_alias__interface' => "Schnittstelle",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP-Adresse für virtuelles Hosting ist ungültig.",
    'ip_alias__invalid_ip_or_netmask' => "Ungültige IP-Adresse/Netzwerkmaske.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Die IP-Adresse %1 ist die ursprüngliche Server-IP, daher kann sie nicht entfernt werden.",
    'ip_alias__ip_is_invalid' => "%1 IP-Adresse ist ungültig.",
    'ip_alias__ip_mask_is_invalid' => "IP-Maske %1 ist ungültig.",
    'ip_alias__ip_not_exist' => "IP-Adresse %1 existiert nicht.",
    'ip_alias__ip_address_and_mask' => 'IP-Adresse und Subnetzmaske',
    'ip_alias__mask' => "Subnetzmaske",
    'ip_alias__remove_selected_ip_aliases?' => "Möchten Sie die ausgewählten IP-Adressen wirklich entfernen?",
    'ip_alias__select_ip' => "Wählen Sie mindestens eine IP-Adresse aus der Liste aus, die entfernt werden soll.",
    'ip_alias__this_ip_used_for_domain' => "(%1) diese IP-Adresse wird für Domain %2 verwendet.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) diese IP-Adresse wird für namensbasierte virtuelle Hosts verwendet.",
    'ip_alias__unable_add_ip' => "Hinzufügen von IP-Adresse nicht möglich: %1",
    'ip_alias__unable_remove_ip' => "IP-Adresse kann nicht entfernt werden: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Sie können den IP-Adresstyp nicht auf 'gemeinsam verwendet' ändern, da Anonymous FTP dadurch für Domain '%1' nicht mehr verfügbar wäre.",
    'ip_ctrl__ip_addr' => "IP-Adresse %2 auf Schnittstelle %1",
    'ip_ctrl__ip_exists_many_pools' => "Der IP-Typ kann nicht geändert werden. Diese IP-Adresse gehört zu mehreren IP-Pools von Benutzern.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-Zertifikat",
    'limit__date_in_past' => "Gültigkeitsdauer ist ungültig. %1 liegt in der Vergangenheit.",
    'limit__enter_date' => "Geben Sie das Datum ein",
    'limit__max_db' => "Datenbanken",
    'limit__name_disk_space' => "Speicherplatz",
    'limit__name_max_box' => "E-Mail-Postfächer",
    'limit__name_max_db' => "MariaDB/MySQL-Datenbanken",
    'limit__name_max_dom' => "Domains",
    'limit__name_max_maillists' => "Mailinglisten",
    'limit__name_max_subdom' => "Subdomains",
    'limit__name_max_traffic' => "Traffic",
    'limit__name_max_wu' => "Webbenutzer",
    'limit__name_mbox_quota' => "Postfachkontingent",
    'limit__name_max_mn' => "E-Mail-Konten",
    'limit__name_max_cl' => 'Kunden',
    'limit__name_total_mboxes_quota' => "Postfachkontingent gesamt",
    'limit__name_mysql_dbase_space' => "MariaDB/MySQL-Datenbankspeicherplatz",
    'limit__name_mssql_dbase_space' => "MSSQL-Datenbank-Speicherplatz",
    'limit__name_pgsql_dbase_space' => "PostgreSQL-Datenbank-Speicherplatz",
    'limit__name_expiration' => 'Ablaufdatum',

    'locale_upload__unable_to_install' => 'Sprachpaketdatei kann nicht installiert werden',
    'locale_upload__wrong_package' => 'Die von ihnen hochgeladene Datei enthält kein für diese Plesk Version gültiges Sprachpaket.',
    'locale_upload__wrong_locale' => 'Die hochgeladene Datei enthält kein gültiges Sprachpaket.',

    'ma__create_title' => 'E-Mail-Alias für %1 erstellen',
    'ma__edit_title' => "E-Mail-Alias %1 bearbeiten",
    'ma__enter_new_alias' => "Geben Sie den neuen Alias ein.",
    'ma__invalid_alias' => "Ungültiger E-Mail-Alias.",
    'ma__mail_aliases_mailname' => "E-Mail-Aliase für E-Mail-Konto %1",
    'ma__mailname_does_not_exist' => "E-Mail-Konto existiert nicht.",
    'ma__select_ma_for_remove' => "Wählen Sie die E-Mail-Aliase aus, die entfernt werden sollen.",
    'ma__unable_to_add_new_ma' => "Ein E-Mail-Alias kann nicht hinzugefügt werden: %1",

    'mail_queue__not_allowed_by_license_key' => 'Verwaltung der E-Mail-Warteschlange von Lizenzschlüssel nicht zugelassen.',
    'maillist__' => "Mailingliste %1",
    'maillist__already_exists' => "Mailingliste existiert bereits.",
    'maillist__mail_alias_already_exists_in_this_domain' => "E-Mail-Alias %1 existiert bereits für diese Domain",
    'maillists__' => "Mailinglisten %1",
    'maillists__limit_cl_max_maillists' => "Die Grenze für die Anzahl an Mailinglisten für diesen Kunden wurde erreicht (Grenze:%1, verwendet: %2)",
    'maillists__limit_dom_max_maillists' => "Die Grenze für die Anzahl an Mailinglisten für diese Domain wurde erreicht.",
    'maillists__list' => "Mailinglisten",
    'maillists__mailman_not_installed_or_conf' => "\nMailman-Server-Erweiterungen sind momentan nicht auf dem Server installiert oder konfiguriert. Bitte kontaktieren Sie den Serveradministrator, um die Mailman-Server-Erweiterungen zu installieren oder richtig zu konfigurieren.",
    'maillists__status' => "Mailinglisten-Service ist aktiviert",
    'maillists__unable_to_delete__' => "Mailingliste kann nicht gelöscht werden: %1",
    'maillists__disabled_text' => 'Sie können die Mailinglisten nicht verwalten, da die Serverkomponente für Mailman-Mailinglisten nicht installiert oder konfiguriert ist.',
    'maillist_member__already_exists' => 'Mailinglisten-Mitglied existiert bereits.',
    'maillist_member__not_exists' => 'Mailinglisten-Mitglied existiert nicht.',
    'mailserver_switching_warning' => "Warnung!\n\nDie Änderung des Mailservers ist nur für die Erstkonfiguration vorgesehen. Wenn der Server bereits verwendet wird, verursacht dies die folgenden Probleme: Verlust der Einstellungen und des Postfachinhalts sowie verschiedene Konflikte in Fällen, in denen der Server, auf den Sie wechseln, bereits konfiguriert ist.\nWenn dieser Server gerade verwendet wird und Sie zu einem anderen Server wechseln möchten, können Sie Ihre Kunden über den Vorgang informieren, so dass sie ihre E-Mails herunterladen und speichern können.",
    'manager__access_denied' => "Zugriff verweigert: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Kunde',
    'manager__domain' => "Domain",
    'manager__domain_cl_limit_exceeding' => "Die Grenze für die Anzahl an Domains für dieses Kundenkonto wurde erreicht",
    'manager__domain_is_not_yours' => "Domain %1 ist Ihnen nicht zugeordnet.",
    'manager__domain_key_limit_exceeding' => "Die maximale Anzahl an Domains laut Ihrem Lizenzschlüssel wurde erreicht",
    'manager__no_perm_to_call' => "Die haben keine Berechtigung zum Aufruf von %1",
    'manager__no_perm_to_create_domains' => "Sie haben keine Berechtigung, Domains zu erstellen",
    'manager__no_perm_to_modify_domain' => "Sie haben keine Berechtigung, die Domain %1 zu verändern",
    'manager__no_perm_to_modify_domains' => "Sie haben keine Berechtigung, Domains zu verändern",
    'manager__no_perm_to_remove_domain' => "Sie haben keine Berechtigung, die Domain %1 zu entfernen",
    'manager__no_perm_to_remove_domains' => "Sie haben keine Berechtigung, Domains zu entfernen",
    'manager__node_doesnt_exist' => "%1 existiert nicht.",
    'manager__user_disabled' => "Ihr Konto ist gesperrt. Sie können keine Aktionen auf dem Server durchführen.",
    'mail_quota_unsupported' => "wird vom Mailserver nicht unterstützt",
    'mbox_quota_unsupported' => "wird vom Mailserver nicht unterstützt",
    'mn__create_title' => "E-Mail-Konto erstellen",
    'mn__edit_title' => "Einstellungen",
    'mn__files_list_title' => "Attachment-Dateien",
    'mn__files_remove' => "Dateien aus den Anhang-Archiv entfernen. Diese Dateien werden möglicherweise von Autorespondern verwendet. Sie werden sowohl aus dem Repository entfernt als auch von den Autorespondern, die sie verwenden.",
    'mn__files_select_for_remove' => "Wählen Sie die Dateien aus, die entfernt werden sollen.",
    'mn__mail_alias_form' => "E-Mail-Alias-Formular",
    'mn__mail_aliases_list' => "E-Mail-Aliase",
    'mn__mailbox' => "Postfachverwaltung",
    'mn__unable_define_mn' => "E-Mail-Konten können nicht eingerichtet werden: %1",
    'mn__unable_remove_mbox_quota' => "Postfachkontingent konnte nicht entfernt werden: %1",
    'mn__upload_file' => "Datei hochladen",
    'mn_edit__attach_filename_changed' => 'Die hochgeladene Datei %1 wurde in %2 umbenannt, der Name beinhaltet nicht-ASCII-Zeichen.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Sie müssen ein Mailgruppenmitglied hinzufügen, bevor Sie die Mailgruppe aktivieren.",
    'mn_edit__add_resp_or_turn_off_box' => "Sie sollten einen Autoresponder hinzufügen oder das Kontrollkästchen deaktivieren.",
    'mn_edit__attachments' => "Anhänge",
    'mn_edit__dom_quota_less_then_quota' => "Der Wert des Postfachkontingents darf die gesetzten Begrenzungen der gesamten Domain nicht überschreiten.",
    'mn_edit__enter_external_rcpnt_email' => "Geben Sie die E-Mail-Adresse des externen Mitglieds der Mailgruppe ein",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Geben Sie die IP-Adresse an, die als Haupt-IP-Adresse des Servers verwendet wird.",
    'mn_edit__ext_rcpnt_email_invalid' => "E-Mail-Adresse des externen Empfängers ist ungültig.",
    'mn_edit__file_exists' => "Datei existiert. Überschreiben?",
    'mn_edit__files_deld_from_repository' => "Diese Dateien werden aus dem Repository und aus den Autorespondern, die sie enthalten, entfernt. Wollen Sie trotzdem fortfahren?",
    'mn_edit__mail_name' => "E-Mail-Konto",
    'mn_edit__mail_name_invalid' => "Der Name des E-Mail-Kontos ist ungültig.",
    'mn_edit__mail_redir' => "E-Mail-Weiterleitungen",
    'mn_edit__mail_redir_add' => "Mailgrupppen-Mitglied hinzufügen",
    'mn_edit__mail_resps' => "E-Mail-Autoresponder.",
    'mn_edit__mailbox' => "E-Mail-Postfach",
    'mn_edit__enable_mailbox' => "E-Mail-Postfach",
    'mn_edit__mailgroup' => "Mailgruppe",
    'mn_edit__mailgroup_addresses' => "Mailgruppen-Mitglieder",
    'mn_edit__mailgroup_disabled' => "Nur verfügbar, wenn das E-Mail-Konto bereits hinzugefügt wurde.",
    'mn_edit__max_dom_quota' => "Standard für die Domain (%1)",
    'mn_edit__mbox_quota_invalid' => "Angegebene Postfachgröße ungültig.",
    'mn_edit__new_resp_name' => "Neuer Autoresponder-Name",
    'mn_edit__no_autoresponders' => "Sie sollten mindestens einen Autoresponder hinzufügen bevor Sie den Autoresponder-Service ein/aus schalten.",
    'mn_edit__no_file_sel' => "Keine Dateien ausgewählt.",
    'mn_edit__no_mail_addresses' => "Es wurden keine E-Mail-Adressen angegeben oder ausgewählt.",
    'mn_edit__none' => "Ohne",
    'mn_edit__not_create_pass' => "Dadurch wird kein Passwort für dieses Konto erstellt.\nOhne Passwort kann der Benutzer keine E-Mails anzeigen und empfangen.",
    'mn_edit__redir_email_invalid' => "E-Mail-Weiterleitungsadresse ist ungültig.",
    'mn_edit__redirect_addr' => "Weiterleitungsadresse",
    'mn_edit__remove_autoresp?' => "Wollen Sie die automatische Antwort wirklich entfernen?",
    'mn_edit__remove_rcpnts?' => "Möchten Sie diese Empfänger wirklich entfernen?",
    'mn_edit__repository' => "Repository",
    'mn_edit__resps_attach' => "Anhangdateien zur automatischen Antwort",
    'mn_edit__select_rcpnt_from_list' => "Wählen Sie mindestens einen Empfänger aus der Liste aus, der entfernt werden soll.",
    'mn_edit__select_registered_users' => "Wählen Sie die registrierten Benutzer aus",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Sie haben ein Postfach eingerichtet, jedoch kein Passwort dafür definiert.",
    'mn_edit__unable_act_deact_mail_group' => "Mailgruppe kann nicht aktiviert oder deaktiviert werden: %1",
    'mn_edit__unable_act_deact_mail_redir' => "E-Mail-Weiterleitung kann nicht aktiviert oder deaktiviert werden: %1",
    'mn_edit__unable_act_deact_postbox' => "Postfach kann nicht aktiviert oder deaktiviert werden: %1",
    'mn_edit__unable_act_deact_resp' => "Autoresponder kann nicht aktiviert oder deaktiviert werden: %1",
    'mn_edit__unable_add_attach' => "Hinzufügen von Attachment-Datei nicht möglich: %1",
    'mn_edit__unable_add_mail_group_member' => "Hinzufügen von Mailgruppenmitglied nicht möglich: %1",
    'mn_edit__unable_add_resp' => "Der Autoresponder kann nicht hinzugefügt werden: %1",
    'mn_edit__unable_change_mail_name' => "Name des E-Mail-Kontos kann nicht geändert werden: %1",
    'mn_edit__unable_deactivate_mail_group' => "Mailgruppe kann nicht deaktiviert werden: %1",
    'mn_edit__unable_deactivate_resp' => "Autoresponder können nicht deaktiviert werden: %1",
    'mn_edit__unable_define_resp_id' => "Die Autoresponder-ID konnte nicht definiert werden: %1",
    'mn_edit__unable_remove_attach' => "Attachment-Datei(en) konnte(n) nicht entfernt werden: %1",
    'mn_edit__unable_remove_autoresp' => "Der Autoresponder kann nicht entfernt werden: %1",
    'mn_edit__unable_remove_mail_group_member' => "Mailgruppenmitglieder können nicht entfernt werden: %1",
    'mn_edit__wrong_way' => 'Die Nachrichten an Empfänger %1 werden nicht zugestellt, da für dieses E-Mail-Konto weder ein Postfach noch eine Weiterleitung aktiviert ist.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Das Postfach unter der Adresse %1 wurde deaktiviert. Die Nachrichten in dem Postfach wurden nicht entfernt. Sie können sie jedoch nicht über das IMAP- oder POP3-Protokoll abrufen.',
    'mn_list__mail_names_for_domain' => "E-Mail-Konten unter Domain %1",
    'mn_list__sa_cannot_unable' => "Spamfilter kann nicht aktiviert werden",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Kunde',
    'mn_list__tab_title_domain' => 'Domain',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Name",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Die E-Mail-Konten können nicht entfernt werden: %1",
    'module_upload__module_was_installed' => 'Das Modul ist bereits installiert. Wenn Sie eine neuere Version des Moduls installieren möchten, deinstallieren Sie bitte das Modul über Plesk und versuchen Sie dann erneut, das Modul zu installieren.',
    'module_upload__unable_to_install' => 'Modulpaketdatei kann nicht installiert werden',
    'module_upload__wrong_package' => 'Die hochgeladene Datei ist kein unterstütztes Modulpaket.',
    'module_upload__wrong_module' => 'Die hochgeladene Datei enthält kein Modulpaket.',

    'news_articles_title' => 'Neuigkeiten von Plesk',
    'notification_text__invalid_subject_length' => "Ungültige Länge des Betreffs der Benachrichtigung. Muss zwischen 1 und 255 Zeichen lang sein.",
    'notification_text__invalid_text_length' => "Länge des Benachrichtigungstexts ungültig. Muss zwischen 1 und 65533 Zeichen lang sein.",
    'notification_text__subject' => "Betreff der Benachrichtigung",
    'notification_text__text' => "Benachrichtigungstext",
    'notification_text__title' => "Notiz bearbeiten",
    'notification_text__unable_set_text' => "Benachrichtigungstext kann nicht geändert werden:",

    'odbc__cant_add_dsn' => "DSN %1 konnte nicht hinzugefügt werden: %2",
    'odbc__cant_connect' => "Mit den definierten Einstellungen kann keine Verbindung zur Datenquelle aufgebaut werden. Serverantwort: %1",
    'odbc__cant_delete_dsn' => "Löschen von DSN %1 nicht möglich: %2",
    'odbc__cant_get_drivers_info' => "Informationen über Treiber können nicht abgerufen werden.",
    'odbc__cant_get_drivers' => "Liste der ODBC-Treiber kann nicht abgerufen werden: %1",
    'odbc__cant_open_info_file' => "Datei mit ODBC-Treiberinformationen kann nicht geöffnet werden.",
    'odbc__cant_parse_string' => "Verbindungstext kann nicht verarbeitet werden",
    'odbc__driver_not_set' => "Treiber ist nicht eingerichtet",
    'odbc__driver_or_name_not_set' => "Treiber oder Name der ODBC-Verbindung nicht eingerichtet",
    'odbc__dsn_already_exists' => "DSN mit diesem Namen (%1) existiert bereits im System",
    'odbc__dsn_not_exists' => "Diese DSN existiert nicht",
    'odbc__enter_dsn_name' => "Geben Sie den DSN-Namen ein",
    'odbc__invalid_dsn_name' => "Falsche Syntax für ODBC-Verbindungsname (%1): verwenden Sie nur alphanumerische Zeichen.",
    'odbc__no_such_driver' => "Ein ODBC-Treiber mit diesem Namen (%1) wird nicht unterstützt.",
    'odbc__unknown_driver' => "Unbekannter Treibername (%1)",
    'odbc_dsn_system' => "System-DSN",

    'pb__aliases' => "Aliase",
    'pb__anonftp' => "Anonymous FTP",
    'pb__autoinstaller_releases' => 'Updater',
    'pb__cert' => "Zertifikate",
    'pb__cl_pool' => "IP-Adressen",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Einstellungen",
    'pb__cl_rpt' => "Bericht",
    'pb__cl_rpt_list' => "Anpassen",
    'pb__cl_templates' => "Kunden-Templates",
    'pb__cl_traffic' => "Verkehr",
    'pb__cl_traffic_history' => "Traffic-Verlauf",
    'pb__cl_traffic_of' => "Traffic von %1",
    'pb__client' => "%1",
    'pb__clients' => "Kunden",
    'pb__comp_info' => "Serverkomponenten",
    'pb__common_acl' => 'Transfer-ACL zulassen',
    'pb__cp_access' => "Zugriff",
    'pb__crontab' => "Planer",
    'pb__scheduler' => "Planer",
    'pb__custom_buttons' => "Benutzerdefinierte Schaltflächen",
    'pb__databases_db' => 'Datenbanken',
    'pb__sqlservers_db' => 'SQL-Server',//to check
    'pb__db' => "Datenbanken",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Datenbankserver',
    'pb__dl_usr_ed' => "Domainbenutzer",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domaingrenzen",
    'pb__dom_pref' => "Einstellungen",
    'pb__dom_sum_report' => "Zusammenfassender Domainbericht",
    'pb__dom_templates' => "Domain-Templates",
    'pb__dom_traffic' => "Traffic von %1",
    'pb__domains' => "Domains",
    'pb__domain_aliases' => 'Domain-Aliase',
    'pb__dumps_list' => "Backupdateispeicher",
    'pb__forwarding_setup' => "Weiterleitungen konfigurieren",
    'pb__filemanager' => "Dateimanager",
    'pb__ip_aliasing' => "IP-Adressen",
    'pb__ip_clients' => "Entfernen von IP-Adressen",
    'pb__license_management' => 'Lizenzinformationen',
    'pb__locales' => 'Sprachdateien',
    'pb__log_files' => "Protokolldateien",
    'pb__mail' => 'E-Mail',
    'pb__mail_name_files' => "Attachment-Dateien",
    'pb__mail_name_redirects' => "E-Mail-Weiterleitungen",
    'pb__mail_name_resp_attach_add' => "Neues Attachment",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "E-Mail-Autoresponder.",
    'pb__mail_names' => "E-Mail",
    'pb__maillists' => "Mailinglisten",
    'pb__mimetypes' => 'MIME-Typen',
    'pb__modules' => 'Module',
    'pb__modules_management' => 'Module verwalten',
    'pb__notifications' => "Benachrichtigungen",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Einrichtung physisches Hosting",
    'pb__prtd_dirs' => "Geschützte Verzeichnisse",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Anpassen",
    'pb__server' => "Server",
    'pb__sessions' => "Sitzungen",
    'pb__sapp_pool' => "WebAnwendungspool",
    'pb__siteapp_install' => 'Webanwendungs-Installation',
    'pb__site_app_pkgs' => 'Webanwendungen',
    'pb__site_apps' => "Webanwendungen",
    'pb__additional_key_info' => 'Schlüssel-Eigenschaften',
    'pb__additional_key_properties' => 'Schlüssel-Eigenschaften',
    'pb__skeleton' => 'Template für virtuelle Hosts',
    'pb__skins' => 'Oberflächen',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Spamfilter",
    'pb__statistics' => "Statistiken",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomains",
    'pb__templates' => "Templates",
    'pb__virtualdirs' => 'Virtuelle Verzeichnisse',
    'pb__web_users' => "Webbenutzer",
    'pdir__enter_dir_name' => "Geben Sie den Verzeichnisnamen ein.",
    'pdir__invalid_hst' => "Hosting-Typ ungültig - muss physisch sein.",
    'pdir__pd_id_is_undefined' => "ID des geschützten Verzeichnisses ist nicht definiert.",
    'pdir__pdir_exist' => "Verzeichnis mit diesem Namen ist bereits geschützt.",
    'pdir__pdir_not_exist' => "Geschütztes Verzeichnis existiert nicht.",
    'pdir__pdir_usr_not_exist' => "Benutzer des geschützten Verzeichnisses existiert nicht.",
    'pdir__remove_pdir_usrs' => "Die folgenden Benutzer des geschützten Verzeichnisses %2 der Website %1 werden entfernt:",
    'pdir__remove_pdir_usrs_on_subdom' => "Die folgenden Benutzer des geschützten Verzeichnisse %2 der Subdomain %1 werden entfernt:",
    'pdir__select_pdir_usrs_for_remove' => "Wählen Sie die Benutzer des geschützten Verzeichnisses aus, die entfernt werden sollen.",
    'pdir__select_pdirs_to_remove' => "Wählen Sie die Verzeichnisse aus, deren Schutz Sie entfernen möchten.",
    'pdir__unable_define_pdir_users' => "Die Benutzer des geschützten Verzeichnisses können nicht definiert werden.",
    'pdir__unable_define_pdirs_properties' => "Konfigurieren der Eigenschaften von geschützten Verzeichnissen nicht möglich: %1",
    'pdir__unable_select_dom_param' => "Domainparameter können nicht ausgewählt werden: %1",
    'pdir_ed__create_pdir_for_domain' => "Erstellen Sie ein geschütztes Verzeichnis unter %1",
    'pdir_ed__create_pdir_for_subdomain' => "Geschütztes Verzeichnis unter der Subdomain %1 erstellen",
    'pdir_ed__dir_already_protect' => "Das Verzeichnis ist bereits geschützt.",
    'pdir_ed__head_txt' => "Titel des geschützten Bereichs",
    'pdir_ed__invalid_login' => "Sie haben einen falschen Benutzernamen eingegeben.",
    'pdir_ed__login_exists' => "Dieser Benutzer existiert bereits. Versuchen Sie einen anderen Benutzernamen einzugeben.",
    'pdir_ed__new_usr' => "Benutzername",
    'pdir_ed__non_ssl' => "Kein SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Verzeichnisname",
    'pdir_ed__pdir_for_domain' => "Geschütztes Verzeichnis %1 auf Domain %2",
    'pdir_ed__pdir_for_subdomain' => "Geschütztes Verzeichnis %1 für die Subdomain %2",
    'pdir_ed__pdir_location' => "Verzeichnis-Speicherort",
    'pdir_ed__pdir_users' => "Benutzer des geschützten Verzeichnisses",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Wählen Sie mindestens ein Kontrollkästchen aus, um sich für oder gegen die Verwendung von SSL/TLS zu entscheiden.",
    'pdir_ed__unable_cr_pdir_usr' => "Benutzer des geschützten Verzeichnisses kann nicht erstellt werden: %1",
    'pdir_ed__unable_create_pdir' => "Geschütztes Verzeichnis kann nicht erstellt werden: %1",
    'pdir_ed__unable_define_hst_type' => "Hosting-Typ kann nicht definiert werden.",
    'pdir_ed__unable_update_pdir' => "Die Einstellungen für das geschützte Verzeichnis konnten nicht gespeichert werden: %1",
    'pdir_ed__wrong_symbol_in_header' => "Bitte verwenden Sie im Verzeichnistitel nicht das Zeichen %1.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Benutzer erstellen für geschütztes Verzeichnis %1",
    'pdir_usr_ed__not_create_pass' => "Dadurch wird kein Passwort für den neuen Benutzer des geschützten Verzeichnisses erstellt. \nOhne Passwort kann sich der Benutzer nicht anmelden.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Passwort für den Benutzer des geschützten Verzeichnisses %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Benutzer des geschützten Verzeichnisses kann nicht ausgewählt werden: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Die Benutzer des geschützten Verzeichnisses können nicht definiert werden: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Benutzer des geschützten Verzeichnisses können nicht entfernt werden: %1",
    'phosting__anonftp_encrypt' => 'Das Passwort des FTP-Benutzers ist verschlüsselt und kann deshalb nicht zum Schutz von Verzeichnis /plesk-stat/webstat/ verwendet werden. Bitte geben Sie Ihr FTP-Passwort erneut ein oder deaktivieren Sie die Option "zugänglich über das geschützte Verzeichnis \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Der Domainname %%domain_name%% wird zur IP-Adresse %%dns_ip_address%% aufgelöst. Ihrer Website ist der IP-Adresse %%hosting_ip_address%% zugewiesen. Falls Ihre Website sich nicht in einem Webbrowser öffnet, wenn Sie den Domainnamen eingeben, gehen Sie zur Seite DNS-Verwaltung (Domains > Domainname > DNS) und ändern Sie die Einstellungen des A-Ressourceneintrags: Weisen Sie die IP-Adresse %%hosting_ip_address%% dem Domainnamen %%domain_name%% zu.",
    'phosting__ip_change_warning' => "IP-Adresse geändert. Die entsprechenden Änderungen wurden auch in der DNS-Zone der Domain vorgenommen.",
    'phosting__other_hosting_exists_on_ip' => "Das Zertifikat kann nicht geändert werden, da diese IP-Adresse gerade in einem oder mehreren Hosting-Konten verwendet wird.",
    'phosting__unable_to_change_certificate' => "Zertifikat kann nicht installiert werden: %1",
    'phosting__unable_to_change_ip_address' => "IP-Adresse kann nicht geändert werden: %1",
    'phosting__unable_to_set_cert' => "Das SSL/TLS-Zertifikat konnte nicht eingerichtet werden: %1",
    'phosting__unable_update' => "Aktualisierung der Hosting-Einstellungen nicht möglich: %1",
    'phosting__unable_manage' => "Hostingverwaltung nicht möglich: %1",
    'phosting__failed_to_add_logs_fail2ban' => "fail2ban konnte nicht konfiguriert werden, um Protokolle der Domain zu verfolgen. Die Protokolle werden beim nächsten Neustart des fail2ban-Diensts automatisch verfolgt.\n%1",

    'picker_acl_record__tittle' => 'ACL-Eintrag auswählen',
    'picker_autoresponder__title' => 'Auswahl einer automatischen Antwort',
    'picker_black_list__domain_name' => 'Wählen Sie einen Domainnamen aus',
    'picker_certificate' => 'SSL/TLS-Zertifikat auswählen',

    'picker_dns_zone_template__title' => 'Ressourceneintrag auswählen',
    'picker_domain__title' => 'Wählen Sie eine Website aus',
    'picker_domain_alias__title' => 'Wählen Sie einen Domain-Alias aus',
    'picker_resource_record__title' => 'Ressourceneintrag auswählen',
    'picker_disabled_resource_record__title' => 'Wählen Sie einen Nameserver aus',
    'picker_ip_address__title' => 'IP-Adresse auswählen',
    'picker_ip_address_clients__title' => 'Wählen Sie Kunden aus, die diese IP-Adresse verwenden',
    'picker_mail_queue' => 'E-Mail-Nachrichten auswählen',
    'picker_site_application__title' => 'Webanwendung auswählen',
    'picker_subdomain__title' => 'Subdomain auswählen',
    'picker_web_user__title' => 'Webbenutzer auswählen',
    'picker_custom_button__title' => 'Benutzerdefinierte Schaltfläche auswählen',
    'picker_license_key__title' => "Lizenzschlüsselauswahl",
    'picker_spamfilter_address__title' => 'Spamfilter-Adresse auswählen',
    'picker_white_list__networks' => 'Auswählen der Netzwerke',

    'plesk_key__action_logs' => "Protokollierung von Aktionen, die von Plesk Benutzern durchgeführt werden",
    'plesk_key__app_vault' => "Application Vault",
    'plesk_key__backup' => "Backup- und Wiederherstellungsfunktionen",
    'plesk_key__client_templs' => "Verwaltung von Service-Paketen",
    'plesk_key__clients' => "Benutzerkonten (Reseller und Kunden)",
    'plesk_key__resellers_only' => "Benutzerkonten (Reseller)",
    'plesk_key__customers_only' => "Benutzerkonten (Kunden)",
    'plesk_key__domains' => "Domains",
    'plesk_key__domain_aliases' => "Domain-Aliase",
    'plesk_key__manage_dashboard' => 'Anpassung der Homepage',
    'plesk_key__drweb' => "Verwaltung des Virenschutzes",
    'plesk_key__event_manager' => "Ereignis-Manager",
    'plesk_key__expirations' => "Verwaltung der Ablaufdaten von Konten",
    'plesk_key__group_ops' => "Änderungen von mehreren Objekten gleichzeitig",
    'plesk_key__expiration' => "Schlüsselablaufdatum",
    'plesk_key__edition_name' => "Plesk Edition",
    'plesk_key__key_number' => "Lizenznummer",
    'plesk_key__languages' => "Sprachpakete",
    'plesk_key__mailnames' => "E-Mail-Konten",
    'plesk_key__migration_manager' => "Migrations- & Transfer-Manager",
    'plesk_key__mssql' => "Microsoft SQL Server-Support",
    'plesk_key__myplesk_func' => "Links zum Kauf von SSL/TLS-Zertifikaten und Diensten zur Domainregistrierung",
    'plesk_key__myplesk_server_id' => "MPC-Slaveserver-Identifikation",
    'plesk_key__notifications' => "Verwaltung von Benachrichtigungen",
    'plesk_key__postgresql' => "PostgreSQL-Datenbankserver",
    'plesk_key__qmail_queue' => 'Verwaltung der E-Mail-Warteschlange',
    'plesk_key__remote_db' => 'Remote Datenbank-Hosting',
    'plesk_key__slave_servers' => "Slave-Server",
    'plesk_key__spamassassin' => "Verwaltung des Spamfilters",
    'plesk_key__subdomains' => "Verwaltung von Subdomains",
    'plesk_key__sys_access' => "Verwaltung des Zugriffs auf den Server",
    'plesk_key__traffic_reports' => "Berichte zur Traffic-Auslastung",
    'plesk_key__tts' => "Helpdesk",
    'plesk_key__virtuozzo' => "Nur für Virtuozzo Container gültig",
    'plesk_key__webusers' => "Webbenutzer",
    'plesk_key__license_update_date' => 'Nächste Lizenzschlüsselaktualisierung',
    'plesk_key__autoinstaller_config' => 'Verwaltung von Updater-Einstellungen',
    'plesk_key__check_wrong' => "Der Lizenzschlüssel ist ungültig. Um Plesk verwenden zu können, müssen Sie einen neuen, gültigen Lizenzschlüssel anfordern und installieren.",
    'plesk_key__upload_check_wrong' => 'Der hochgeladene Lizenzschlüssel ist nicht gültig.',
    'plesk_key__revert_check_wrong' => 'Der vorher installierte Lizenzschlüssel ist nicht gültig.',
    'plesk_key__viruozzo_only_key' => 'Der Lizenzschlüssel ist nur zur Verwendung mit Plesk innerhalb von Virtuozzo Containern vorgesehen.',
    'plesk_key__ip_ranges_exceeded' => 'Sie können diese lizenzierte Plesk Kopie nur mit den folgenden IP-Adressen verwenden: %2. Die folgenden IP-Adressen werden nicht von Ihrer Lizenz unterstützt: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Die Anzahl der aktuell verwendeten Ressourcen überschreitet die in Ihrer Lizenz definierten Grenzwerte.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Die Anzahl der auf dem Server gehosteten Websites überschreitet die durch Ihre Lizenz definierten Grenzen. Sie hosten %2 Sites; Ihre Lizenz erlaubt jedoch nur %1 Sites.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Die Anzahl der Domain-Aliase auf dem Server überschreitet die von Ihrer Lizenz definierten Grenzen. Sie haben %2 Domain-Aliase, Ihre Lizenz erlaubt jedoch nur %1 Domain-Aliase.',
    'plesk_key__limits_exceeded_lim_cl' => 'Die Anzahl der verwalteten Kundenkonten überschreitet die durch Ihre Lizenz definierten Grenzen. Sie verwalten derzeit %2 Kundenkonten, Ihre Lizenz erlaubt jedoch nur %1 Kundenkonten.',
    'plesk_key__limits_exceeded_lim_mn' => 'Die Anzahl der verwalteten E-Mail-Konten überschreitet die von Ihrer Lizenz definierten Grenzen. Sie verwalten derzeit %2 E-Mail-Konten, Ihre Lizenz erlaubt jedoch nur %1 E-Mail-Konten.',
    'plesk_key__limits_exceeded_lim_wu' => 'Die Anzahl der verwalteten Webbenutzerkonten überschreitet die durch Ihre Lizenz definierten Grenzen. Sie verwalten derzeit %2 Webbenutzerkonten, Ihre Lizenz erlaubt jedoch nur %1 Webbenutzerkonten.',
    'plesk_key__limits_exceeded_MLS' => 'Die Anzahl der aktuell installierten Sprachpakete überschreitet die durch Ihre Lizenz definierten Grenzen. Es sind %2 Sprachpakete installiert, Ihre Lizenz erlaubt jedoch nur %1 Sprachpakete.',
    'plesk_key__wrong_version' => 'Sie versuchen, einen Lizenzschlüssel zu verwenden, der für eine andere Version von Plesk erstellt wurde. Wenden Sie sich an Ihren Plesk Vertriebsmitarbeiter, um den passenden Lizenzschlüssel zu erhalten.',
    'plesk_key__other_product' => 'Sie versuchen, den Lizenzschlüssel eines anderen Produkts zu verwenden. Wenden Sie sich an Ihren Plesk Vertriebsmitarbeiter, um den passenden Lizenzschlüssel zu erhalten.',
    'plesk_key__invalid_machine_id_trial' => 'Ihre aktuelle Lizenz ist nicht gültig, da sie bereits auf einem anderen Plesk Server aktiviert ist. Um Plesk weiterhin zu verwenden, installieren Sie entweder eine neue Lizenz oder installieren Sie Ihre aktuelle Lizenz erneut, indem Sie den Aktivierungscode eingeben (falls Sie einen haben).',
    'plesk_key__invalid_machine_id_retail' => 'Ihre aktuelle Lizenz ist nicht gültig, da sie bereits auf einem anderen Plesk Server aktiviert ist. Die Lizenzbedingungen von WebPros (https://www.plesk.com/legal/) untersagen die gleichzeitige Nutzung einer einzelnen Lizenz auf zwei oder mehr Servern. Um Plesk weiterhin zu nutzen, installieren Sie entweder eine neue Lizenz oder installieren Sie Ihre aktuelle Lizenz erneut, indem Sie den Aktivierungscode eingeben. Dieser wurde Ihnen per E-Mail zugesandt, als Sie die Lizenz erworben haben. <br>Sie können den Aktivierungscode nicht finden? Sie können ihn über Plesk 360 abrufen. Melden Sie sich dazu auf https://platform360.io/ mit der E-Mail an, die Sie beim Kauf der Lizenz verwendet haben. Auf dem Tab "Lizenzen" finden Sie den Aktivierungscode Ihrer Lizenz. Oder Sie können das Supportteam von Plesk für Lizenz- und Vertriebsangelegenheiten über das Onlineformular (https://www.plesk.com/licensing-and-purchase-support/) kontaktieren. Vergessen Sie nicht, Ihre Lizenznummer im Abschnitt "How can we help you?" des Formulars anzugeben.',
    'plesk_key__limits_exceeded_error' => 'Der Lizenzschlüssel kann nicht installiert werden: Die aktuelle Auslastung der Ressourcen überschreitet die im hochgeladenen Lizenzschlüssel definierten Grenzen.',
    'plesk_key__limits_exceeded_note' => 'Die aktuelle Auslastung der Ressourcen überschreitet die im hochgeladenen Lizenzschlüssel definierten Grenzen.',
    'plesk_key__key_file_invalid' => 'Die hochgeladene Schlüsseldatei ist ungültig oder enthält keinen Lizenzschlüssel.',
    'plesk_key__server_request_error' => 'Lizenz konnte nicht aktualisiert werden. Vergewissern Sie sich, dass Verbindungen zum Lizenzserver ka.plesk.com auf dem TCP-Port %1 nicht blockiert sind. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Hier erfahren Sie, wie Sie dies überprüfen können.</a>',
    'key__no_key_file_in_zip' => 'Die hochgeladene .zip-Datei enthält keine Schlüsseldatei',
    'key__key_upload' => 'Lizenzschlüsselinstallation',
    'additional_key__prop_name' => 'Eigenschaft',
    'additional_key__prop_value' => 'Wert',
    'additional_key__descr_name' => 'Name des Schlüssels',
    'additional_key__descr_key_number' => 'Lizenznummer',
    'additional_key__descr_key_vz' => "Dieser Lizenzschlüssel eignet sich nur zur Verwendung in Virtuozzo Containern.",
    'additional_key__descr_key_mailboxes' => 'Postfächer',
    'additional_key__descr_lim_date' => 'Ablaufdatum',
    'additional_key__descr_license_update_date' => 'Nächste Lizenzschlüsselaktualisierung',
    'additional_key__file_invalid' => 'Die hochgeladene Schlüsseldatei ist ungültig oder enthält keinen Lizenzschlüssel.',
    'additional_key__file_incompatible' => 'Die hochgeladene Schlüsseldatei ist für diese Anwendung nicht gültig.',
    'additional_key__not_exists' => 'Kein Lizenzschlüssel installiert.',
    'additional_key_update__result_response' => 'Antwort des Lizenzservers: %1',
    'additional_key_update__result_network' => 'Verbindung zum Lizenzserver nicht möglich. Bitte stellen Sie sicher, dass ihr Netzwerk die Kommunikation mit %1 erlaubt: %2.',
    'additional_key_update__result_lock' => 'Schlüsselaktualisierung wird bereits ausgeführt',
    'additional_key_update__result_internal_error' => 'Beim Aktualisieren des Lizenzschlüssels ist ein Fehler aufgetreten: %1',

    'proceed_to_cl_pool' => "Weiter zu den Einstellungen des IP-Pools des Kunden",
    'proceed_to_hosting_setup' => "Weiter zur Hosting-Einrichtung",
    'removeCerts__remove_certificates_cp' => "Die folgenden Zertifikate werden entfernt:",
    'removeCerts__remove_certificates_domain' => "Die folgenden Zertifikate in Besitz von %1 werden entfernt:",
    'removeClientsIP_remove_clients_ip' => "Diese IP-Adresse wird aus den IP-Pools der folgenden Kunden entfernt:",
    'removeMailAliases__remove_mail_aliases' => "Die folgenden E-Mail-Aliase für E-Mail-Konto %1 werden entfernt:",
    'removeMailNames__remove_mailnames' => "Die folgenden E-Mail-Konten und -Aliase werden aus Domain %1 entfernt:",
    'removeMailNames__remove_mailnames_of_cl' => "Die folgenden E-Mail-Konten und Aliase für die Domain %2 in Besitz von Kunde %1 werden entfernt:",
    'removeMailNames__these_mailnames_will_not_delete' => "Diese E-Mail-Konten werden nicht gelöscht.",
    'removeFtpSessions__remove_title' => "Die folgenden FTP-Sitzungen werden beendet:",
    'removeTemplates__remove_templates' => "Die folgenden Templates werden entfernt:",
    'resp_edit__always_respond' => "immer antworten",
    'resp_edit__reply_subject' => "Antwortbetreff",
    'resp_edit__answer_subject' => "Mit Betreff antworten",
    'resp_edit__answer_txt' => "Mit Text antworten",
    'resp_edit__attach' => "Dateien anhängen",
    'resp_edit__default_subject' => "AW: %1",
    'resp_edit__for' => "für",
    'resp_edit__frw_rqst_email' => "Bei automatischer Antwort die Originalnachricht an die angegebene E-Mail-Adresse weiterleiten",
    'resp_edit__fwd_email_invalid' => "Ziel-E-Mail-Adresse ist ungültig.",
    'resp_edit__in_body' => "wenn sich die angegebenen Wörter im Nachrichtentext befinden",
    'resp_edit__in_subject' => "wenn sich die angegebenen Wörter im Nachrichtenbetreff befinden",
    'resp_edit__invalid_resp_freq' => "Antwortfrequenz ist ungültig.",
    'resp_edit__invalid_rqst_txt' => "Ungültiger Anfragetext.",
    'resp_edit__invalid_store_lim_num' => "Grenzwert ist ungültig.",
    'resp_edit__limits_title' => "Grenzen",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Die Anzahl maximaler Antworten pro Tag übersteigt die definierte Menge. Erlaubt: %1, angefordert: %2",
    'resp_edit__no_files_sel' => "Keine Dateien ausgewählt.",
    'resp_edit__no_txt_supplied' => "Kein Text eingegeben.",
    'resp_edit__reply_title' => "Antwort",
    'resp_edit__reply_to_address' => "Absenderadresse",
    'resp_edit__reply_to_invalid' => "Absenderadresse ist ungültig.",
    'resp_edit__reply_uniq_email' => "Maximale Anzahl an Antworten an eindeutige E-Mail-Adresse:",
    'resp_edit__conditions_title' => "Bedingungen",
    'resp_edit__request_title' => "Anfordern",
    'resp_edit__resp' => "Autoresponder",
    'resp_edit__resp_name' => "Autoresponder-Name",
    'resp_edit__resp_not_exist' => "Der Autoresponder existiert nicht.",
    'resp_edit__resp_status' => "Autoresponder-Status",
    'resp_edit__rqst_txt' => 'Geben Sie die Bedingung für diese automatische Antwort an',
    'resp_edit__select_files_on_server_for_attach' => "Wählen Sie die Dateien aus, die Sie anhängen möchten",
    'resp_edit__store_up_to' => "Speichere bis zu",
    'resp_edit__subj_line_invalid' => "Betreffzeile ist falsch.",
    'resp_edit__text_too_big' => "Der Antworttext ist zu groß.",
    'resp_edit__times_in_a_day' => "Mal am Tag.",
    'resp_edit__unable_define_resp_cond' => "Die Bedingung für die automatische Antwort konnte nicht festgelegt werden: %1",
    'resp_edit__unable_define_resp_status' => "Der Autoresponder-Status konnte nicht festgelegt werden: %1",
    'resp_edit__unable_turn_on_resp' => "Der Autoresponder konnte nicht eingeschaltet werden: %1",
    'resp_edit__uniq_email' => "eindeutige E-Mail-Adressen",
    'resp_edit__content_type' => 'E-Mail-Sendeformat',
    'resp_edit__content_type_text' => 'Nur-Text-Format',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kodierung',
    'restart__dns' => 'DNS-Server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP-/POP3-Server (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "MariaDB/MySQL-Server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Dienstleistungen",
    'restart__smtp' => "SMTP-Server (%1)",
    'restart__spamd' => "Spamfilter",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Webserver (%1)",
    'restart__ftp' => "FTP-Server (%1)",
    'restart__service_start' => 'Der Neustart des Dienstes kann einige Zeit in Anspruch nehmen.',
    'restart__service_stop' => 'Das Anhalten des Dienstes kann einige Zeit in Anspruch nehmen.',
    'restart__service_restart' => 'Der Neustart des Dienstes kann einige Zeit in Anspruch nehmen.',
    'rm_domains__some_domains_are_not_exist' => "Einige der eingegebenen Domains existieren nicht. Möglicherweise wurden Sie von einem anderen Benutzer entfernt.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "Mgruppen",
    'rpt_cl_dom_mail_lists' => "Mlisten",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "Antispam",
    'rpt_cl_dom_mail_antivirus' => "Virenschutz",
    'rpt_cl_dom_postboxes' => "Mboxen",
    'rpt_cl_dom_redirects' => "Weiterleitungen",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliase",
    'rpt_cl_dom_web_users' => "Wbenutzer",
    'rpt_cl_report_for_admin__' => "Bericht für den Administrator %1",
    'rpt_cl_report_for_reseller__' => "Bericht für den Reseller %1",
    'rpt_cl_report_for_cl__' => "Bericht über den Kunden %1",
    'rpt_cl_section_domains' => "Domains",
    'rpt_cl_section_full_domains' => "Domains",
    'rpt_cl_section_general' => "Allgemein",
    'rpt_create' => "Bericht erstellen",
    'rpt_empty' => "Der Bericht muss mindestens einen Abschnitt enthalten",
    'rpt_dom_report_for_dom__' => "Domainbericht für %1",
    'rpt_dom_section_databases' => "Datenbanken",
    'rpt_dom_section_full_databases' => "Datenbanken",
    'rpt_dom_section_full_maillists' => "Mailinglisten",
    'rpt_dom_section_full_mailnames' => "E-Mail-Konten",
    'rpt_dom_section_full_webusers' => "Webbenutzer",
    'rpt_dom_section_full_siteapps' => 'Webanwendungen',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET-Webanwendungen',
    'rpt_dom_section_general' => "Allgemein",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Mailinglisten",
    'rpt_dom_section_mailnames' => "E-Mail-Konten",
    'rpt_dom_section_siteapps' => 'Webanwendungen',
    'rpt_dom_section_aspnetapps' => 'ASP.NET-Webanwendungen',
    'rpt_dom_section_webusers' => "Webbenutzer",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Bericht %1 bearbeiten",
    'rpt_enter_email_address' => "Geben Sie eine E-Mail-Adresse ein, an die der Bericht gesendet werden soll.",
    'rpt_list' => "Benutzerdefinierte Berichtlayouts",
    'rpt_section_full' => "Vollständig",
    'rpt_section_none' => "Ohne",
    'rpt_section_summary' => "Zusammenfassender Bericht",
    'rpt_default_full' => 'Vollständiger Bericht',
    'rpt_default_summary' => 'Zusammenfassender Bericht',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Fehler beim Versenden des Berichts: %1",
    'rpt_send_report_by_email_ok__' => "Der Bericht wurde versendet an %1",
    'sa_action' => "Aktion",
    'sa_action_del' => "Löschen",
    'sa_action_desc' => "Was soll mit Spam-E-Mails geschehen?",
    'sa_action_save' => "Als Spam kennzeichnen und in Postfach speichern",
    'sa_admin_blacklist' => "Administrator-Blacklist",
    'sa_admin_whitelist' => "Administrator-Whitelist",
    'sa_db_del_confirm' => "Sind Sie sicher, dass Sie den Inhalt der Spamfilter-Datenbank löschen möchten?",
    'sa_eml_in_ignorelist' => "E-Mail-Adresse ist in der Liste der zu ignorierenden Adressen",
    'sa_empty_email' => "Es kann kein leeres E-Mail-Muster hinzugefügt werden.",
    'sa_exists_email' => "Dieses E-Mail-Muster ist bereits vorhanden.",
    'sa_disabled__mailname_not_filtering' => "Die aktuellen Servereinstellungen erlauben keine E-Mail-Filterung für dieses E-Mail-Konto",
    'sa_disabled__filtering_is_disabled' => 'Der Spamfilter wurde vom Serveradministrator deaktiviert',
    'sa_disabled__hasnt_mailbox' => "Aktivieren des Spamfilters ohne Postfach nicht möglich",
    'sa_enable_filter' => "Spamfilter aktivieren",
    'sa_forget' => "vergessen",
    'sa_from' => "Ab",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Muster ist ungültig.",
    'sa_spam' => "SPAM",
    'sa_trainer__page_title' => 'Spamfiltertraining',
    'sa_trainer__tools_legend' => 'Tools',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Nachrichten in Ihrem Postfach',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Betreff',
    'sa_trainer__from' => 'Ab',
    'sa_trainer__date' => 'Datum',
    'sa_trainer__info_text' => 'Gelernte Nachrichten: %1 als Spam, %2 als Nicht-Spam, %3 gesamt.',
    'sa_trainer__messages' => 'Nachricht(en)',
    'sa_trainer__select__all' => 'Alle',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Nicht-Spam',
    'sa_trainer__select__unknown_only' => 'Unbekannt',
    'sa_trainer__cannot_remove_messages' => 'Die ausgewählten Nachrichten können nicht aus dem Postfach entfernt werden.',
    'sa_trainer__remove_messages_confirm' => 'Möchten Sie die ausgewählten Nachrichten wirklich aus dem Postfach entfernen?',
    'sa_subj' => "Betreff",
    'sa_training' => "Spamfiltertraining",
    'sa_training_legend' => "Bayes-Filtertraining",
    'sa_use_srv_settings' => "Serverweite Einstellungen verwenden",
    'sa_user_blacklist' => "Benutzer-Blacklist",
    'sa_user_whitelist' => "Benutzer-Whitelist",
    'sa_usr_disabled_by_srv' => "Der Serveradministrator erlaubt keine individuellen Spamfilter-Einstellungen",
    'sa_usr_no_postbox' => "Der Spamfilter kann nicht aktiviert werden, weil das Postfach für dieses E-Mail-Konto deaktiviert ist.",
    'sa_filters' => 'Spamfilter',
    'spamfilter__tools_legend' => 'Tools',
    'spamfilter__prefs_legend' => 'Einstellungen',
    'spamfilter__max_children' => 'Maximale Anzahl der \'worker spamd\'-Prozesse, die ausgeführt werden sollen',
    'spamfilter__rewrite_header_subject_hint' => 'Lassen Sie dieses Feld leer, wenn Sie keinen Text hinzufügen möchten. Geben Sie "_SCORE_" ein, wenn die Punktzahl im Nachrichtenbetreff enthalten sein soll.',
    'spamfilter__reject_spam' => 'Spam-E-Mails beim Eingehen in das Postfach löschen',
    'spamfilter__enabled' => 'Eingeschaltet',
    'spamfilter_addresses_list__items' => 'Adressen',
    'spamfilter_addresses__remove_title' => 'Die folgenden Adressen werden aus der Liste entfernt:',
    'spamfilter_addresses__empty_selection' => 'Keine Adressen ausgewählt.',
    'server__admin_info' => "Administrator-Informationen",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Geben Sie unten die Fehlerbeschreibung ein",
    'server__power_management' => "Energieverwaltung",
    'server__services' => "Dienstleistungen",
    'server__system' => "System",
    'server__title' => "Serveradministration",
    'server_preferences__admin_skin' => "Skin der Administratoroberfläche",
    'server_preferences__default_language' => "Standardsprache",
    'server_preferences__default_skin' => "Standard-Skin",
    'server_preferences__restart_apache_interval' => "Apache Neustartintervall",
    'server_preferences__system' => 'Systemeinstellungen',
    'mail__tabs_preferences' => "Einstellungen",
    'mail__tabs_white_list' => "Whitelist",
    'server_preferences__use_vocabulary' => "Passwörter für Postfächer im Wörterbuch überprüfen",
    'sessions__agreement' => "Ja, ich möchte diese Sitzungen beenden.",
    'sessions__select_sessions_for_remove' => "Wählen Sie die Sitzungen aus, die beendet werden sollen.",
    'sessions__tabs_cp_sessions' => 'Plesk Sitzungen',
    'sessions__tabs_ftp_sessions' => 'FTP-Sitzungen',
    'sessions__ftp_sessions_login' => 'Benutzername des FTP-Kontos',
    'sessions__ftp_sessions_domain' => 'Domainname',
    'sessions__ftp_sessions_path' => 'Aktueller Speicherort',
    'sessions__ftp_sessions_file' => 'Dateiname',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Geschwindigkeit (KB/s)',
    'sessions__ftp_sessions_comp' => 'Fortschritt (%)',

    'site_apps__access_level' => 'Zugriffslevel',
    'site_apps__access_level_commercial' => 'Kommerziell',
    'site_apps__access_level_free' => 'Kostenlos',
    'site_apps__action_installer' => "Webanwendungs-Installation",
    'site_apps__action_reconfigure' => "Neukonfiguration von Webanwendungen",
    'site_apps__custom_button_level' => 'Möchten Sie eine benutzerdefinierte Schaltfläche zum Aufrufen dieser Anwendung erstellen?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nein',
    'site_apps__custom_button_level_domain_user_only' => 'Ja',
    'site_apps__custom_button_level_false' => 'Nein',
    'site_apps__custom_button_level_domain' => 'Ja, nur für die aktuelle Domain verfügbar machen',
    'site_apps__custom_button_level_client' => 'Ja und für alle Domains des Kunden verfügbar machen',
    'site_apps__custom_button_level_admin' => 'Ja, für alle Domains verfügbar machen',
    'site_apps__description' => "Beschreibung",
    'site_apps__dir_used_by_sapp__' => "Verzeichnis \"%1\" wird von einer anderen Webanwendung verwendet",
    'site_apps__dir_used_by_unknown__' => "Das Verzeichnis \"%1\" existiert bereits. Wenn Sie fortfahren, wird sein Inhalt überschrieben.",
    'site_apps__dir_invalid_name__' => "Der Verzeichnisname %1 ist falsch",
    'site_apps__file_name' => 'Webanwendungs-Dateiname',
    'site_apps__invalid_install_prefix' => "Ungültiger Installationspräfix",
    'site_apps__invalid_package' => "Webanwendung ist ungültig",
    'site_apps__key_status' => 'Lizenzierung',
    'site_apps__key_status_free' => 'Frei verfügbar. Kein Lizenzschlüssel erforderlich',
    'site_apps__key_status_ok' => 'Der erforderliche Lizenzschlüssel ist installiert',
    'site_apps__key_status_problem' => 'Der erforderliche Lizenzschlüssel ist nicht installiert',
    'site_apps__name' => "Name",
    'site_apps__no_domains' => 'Die Webanwendung kann nicht installiert werden. Im Root-Verzeichnis dieser Domain ist bereits eine andere Webanwendung installiert. Es besteht die Möglichkeit, eine Subdomain für die Webanwendung zu erstellen.',
    'site_apps__package_info_' => "Webanwendungs-Informationen",
    'site_apps__package_integrated' => "integrierte Anwendung, kann nicht entfernt werden",
    'site_apps__pool_select_packages_to_add' => 'Wählen Sie die Webanwendungen aus, die zum Pool hinzugefügt werden sollen',
    'site_apps__release' => "Release",
    'site_apps__resource_used_by_sapp' => "Diese Ressource wird von der installierten Webanwendung verwendet",
    'site_apps__root_used_by_sapp' => "Diese Ressource wird von einer installierten Webanwendung verwendet",
    'site_apps__these_domains_will_not_delete' => 'Diese (Sub-) Domains werden nicht gelöscht',
    'site_apps__upload_site_app_pkg_title' => 'Neue Webanwendung hochladen',
    'site_apps__version' => "Version",
    'site_apps__access_to' => "Zugriff auf %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Template für virtuelle Hosts",
    'skeleton__client_label' => "Template für virtuelle Hosts von %1",
    'skeleton__admin_page' => "Template für virtuelle Hosts verwalten",
    'skeleton__files_list' => "Dateien und Verzeichnisse",
    'skeleton__archiver_not_installed' => "Archiv konnte nicht entpackt werden. Wahrscheinlich ist der Archivierer nicht auf dem Server installiert. Kontaktieren Sie den {$PROD_NAME}-Administrator, um die Archivierungssoftware zu installieren.",
    'skeleton__client_page' => "Template für virtuelle Hosts verwalten",
    'skeleton__archive_corrupted' => "Die Überprüfung des Archivs hat ergeben, dass das Archiv entweder beschädigt ist oder der Archivtyp nicht unterstützt wird.",
    'skeleton__archive_too_large' => "Die Überprüfung des Archivs hat ergeben, dass die Archivdatei zu groß ist.",
    'skeleton__not_supported_archive_type' => "Dieser Archivtyp (Datei %1) wird nicht unterstützt",
    'skeleton__upload_archive_file' => "Archivdatei hochladen",
    'skin_download__title' => 'Skin herunterladen',
    'skin_download_now__title' => 'Skin-Download läuft',
    'skin_download_now__text' => 'Die Erstellung des Skin-Pakets ist in Bearbeitung.<br>Dieser Vorgang kann einige Zeit dauern.<br> Sobald das Dialogfenster erscheint, können Sie Ihre Arbeit in Plesk fortsetzen.',
    'skin_file__help_for_using_types' => "Bitte benutzen Sie das Skin-Archiv in einem der folgenden Formate",
    'skin_info__title' => 'Skin-Eigenschaften',
    'skin_mng_err__rpm_not_skin' => 'Dieses RPM ist kein Plesk Skin-Paket',
    'skin_mng_err__psa_install_noreloc' => 'Installation von rpm-basiertem Skin am angegebenen Orten fehlgeschlagen.',
    'skin_mng_err__already_exists' => 'Das Skin-Installationsverzeichnis existiert bereits und es wird ein Skin-Paket eingesetzt.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Die hochgeladene Datei ist kein gültiges RPM-Skinpaket.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Die hochgeladene Datei ist kein gültiges Skinpaket.',
    'skin_mng_err__rpm_upgrade_base' => "Die hochgeladene Datei ist kein gültiges {$PROD_NAME} Skinpaket.",
    'skin_mng_err__rpm_upgrade_other' => 'Skin kann nicht installiert werden: Skinformat ungültig.',
    'skin_mng_err__no_a_skin' => "Die hochgeladene Datei ist kein gültiges {$PROD_NAME} Skinpaket.",
    'skin_upload__title' => 'Neuen Skin hochladen',
    'skin_upload__already_exists' => "Das Skin '%1' existiert bereits",
    'skin_upload__unable_to_apply' => "Die hochgeladene Datei enthält kein Plesk Skin oder das Archivformat wird nicht unterstützt.",
    'skin_upload__unable_to_rename__' => "Skin %2 kann nicht in %1 umbenannt werden: %3.",
    'skin_upload__file_name' => 'Pfad zur Skin-Paketdatei',
    'skins_list__title' => 'Skin-Verzeichnis',
    'skins_remove__title' => 'Skin entfernen',
    'skins_remove__select_skins_for_remove' => 'Wählen Sie die Skins aus, die gelöscht werden sollen',

    'spf__unable_update' => 'Aktualisieren der SPF-Parameter nicht möglich',
    'statistics__active_domains' => "Aktive Domains",
    'statistics__clients' => "Kunden",
    'statistics__subdomains' => "Subdomains",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Datenbanken",
    'statistics__db_users' => "Datenbankbenutzer",
    'statistics__dirs' => "Geschützte Verzeichnisse",
    'statistics__dom_active' => "Aktiv",
    'statistics__dom_passive' => "Passiv",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Domains",
    'statistics__domains_with_host' => "Domains mit Hosting",
    'statistics__doms' => "Domains",
    'statistics__filesystem' => "Dateisystem",
    'statistics__general' => "Allgemein",
    'statistics__hdd_available' => "Verfügbar",
    'statistics__hdd_capacity' => "Kapazität",
    'statistics__hdd_total' => "Gesamt",
    'statistics__hdd_usage' => "Festplattenauslastung",
    'statistics__hdd_used' => "Verwendet",
    'statistics__ip' => "IP-Adresse",
    'statistics__key_number' => "Lizenznummer",
    'statistics__l1' => "Letzte Minute",
    'statistics__l15' => "Letzte 15 Minuten",
    'statistics__l5' => "Letzte 5 Minuten",
    'statistics__la' => "CPU-Auslastung",
    'statistics__mail_autoresponders' => "Autoresponder",
    'statistics__mail_boxes' => "E-Mail-Postfächer",
    'statistics__mail_groups' => "Mailgruppen",
    'statistics__mail_lists' => "Mailinglisten",
    'statistics__mail_redirects' => "E-Mail-Weiterleitungen",
    'statistics__mem' => "Speicherauslastung",
    'statistics__mem_usage' => "Belegung",
    'statistics__memory_available' => "Verfügbar",
    'statistics__memory_buffer' => "Puffer",
    'statistics__memory_cached' => "Im Zwischenspeicher",
    'statistics__memory_free' => "Frei",
    'statistics__memory_shared' => "Gemeinsam genutzt",
    'statistics__memory_total' => "Gesamt",
    'statistics__memory_used' => "Verwendet",
    'statistics__os' => "Betriebssystem",
    'statistics__problem_clients' => "Problemkunden",
    'statistics__problem_domains' => "Domains mit Problemen",
    'statistics__swap' => "Swap-Nutzung",
    'statistics__swap_free' => "Frei",
    'statistics__swap_total' => "Gesamt",
    'statistics__swap_usage' => "Belegung",
    'statistics__swap_used' => "Verwendet",
    'statistics__system_stat' => "Serverinformationen",
    'statistics__unable_define_active_doms' => "Anzahl aktiver Domains kann nicht ermittelt werden: %1",
    'statistics__unable_define_inactive_doms' => "Anzahl inaktiver Domains kann nicht ermittelt werden: %1",
    'statistics__failed_define_swap_usage' => 'Auslastung der Auslagerung konnte nicht definiert werden',
    'statistics__failed_define_load_averages' => 'Durchschnittliche Auslastung konnte nicht definiert werden',
    'statistics__up_time' => "Systembetriebszeit:",
    'statistics__ver' => "Version",
    'statistics__web_users' => "Webbenutzer",
    'statistics__mem_win' => "Ausnutzung des physischen Speichers",
    'statistics__memory_total_win' => "Gesamt",
    'statistics__memory_used_win' => "Verwendet",
    'statistics__memory_free_win' => "Verfügbar",
    'statistics__swap_win' => "Ausnutzung des virtuellen Speichers",
    'statistics__swap_total_win' => "Gesamt",
    'statistics__swap_used_win' => "Verwendet",
    'statistics__swap_free_win' => "Verfügbar",
    'status__domain_has_reasons_to_be_off' => "Die Domain ist aus dem folgenden Grund noch gesperrt: %1",
    'subdomain__create__' => "Subdomain in Domain %1 erstellen",
    'subdomain__edit__' => "Subdomain %1 bearbeiten",
    'subdomain__invalid_name' => "Ungültiger Subdomainname: Verwenden Sie nur alphanumerische Zeichen und Bindestriche.",
    'subdomain__incorrect_name' => "Ungültiger Subdomainname.",
    'subdomains__maillists_enabled_in_domain' => "Falscher Name für Subdomain lists.%1: Dieser Domainname wird bereits von Mailinglisten unter Domain %1 verwendet.",
    'subdomains__dalias_exists' => 'Ein Domain-Alias mit diesem Namen ist bereits vorhanden.',
    'subdomains__name_exists' => "Eine Subdomain mit diesem Namen ist bereits vorhanden.",
    'subdomains__regular_domain_exists' => "Eine Domain mit diesem Namen ist bereits vorhanden.",
    'subdomains__domain_alias_exists' => 'Ein Domain-Alias mit diesem Namen ist bereits vorhanden.',
    'subdomains__remove_subdomains_on_domain' => "Die folgenden Subdomains für Domain %1 werden entfernt:",
    'subdomains__select_subdomains_for_remove' => "Wählen Sie die Subdomains aus, die entfernt werden sollen.",
    'subdomains__webmail_enabled_in_domain' => "Name für Subdomain webmail.%1 falsch: Dieser Domainname wird für den Zugang zu Webmail unter Domain %1 verwendet",
    'subdomains__dns_record_already_exists' => 'Subdomain %1 kann nicht erstellt werden, da bereits ein DNS-Eintrag auf Host %1 verweist.',
    'subdomains__www_prefix_in_domain' => "Ungültiger Subdomainname www.%1: Domain %1 hat bereits das Präfix WWW.",
    'subdomains__user_type_quota_exceeds' => 'Das Benutzerkonto kann nicht geändert werden, weil dadurch der zugewiesene Speicherplatz überschritten würde.',
    'subdomains__creation_in_dns_slave' => "Der Nameserver von Plesk fungiert als sekundärer Nameserver für diese Domain. Damit Ihre Subdomain korrekt aufgelöst wird, sollten Sie sichergehen, dass die Zonendatei auf dem primären DNS-Server den Eintrag %1 enthält.",
    'sys_user__attributes_not_changed' => "\nDie folgenden Systembenutzerattribute wurden nicht geändert: %1",
    'sys_user__no_access_without_password' => "Sie haben kein Passwort konfiguriert. Der Systembenutzer wird erstellt, kann sich jedoch erst am System anmelden, wenn ein Passwort vergeben wird. Fortfahren?",
    'sys_user__no_hard_quota' => "nicht unterstützt",
    'sysuser__zero_quota_is_unlimited' => "0 für unbegrenzt",
    'template__num_excl_ips' => "Dem Kunden dedizierte IP-Adressen zuweisen",
    'template__sel_sh_ips' => "Wählen Sie gemeinsam genutzte IP-Adressen für den Kunden",
    'template__av_sh_ips' => "Verfügbare gemeinsam verwendete IP-Adressen",
    'template__up_to_excl_ip' => "Bis zu %1 IP-Adressen",
    'templates__all_clients' => "Alle Kunden",
    'templates__cl_domain_templates' => "Templates für %1",
    'templates__cl_templates' => "Kunden-Templates",
    'time__invalid_ip' => "Ungültige IP-Adresse oder Domainname.",
    '__please_select_country' => 'Wählen Sie Ihr Land aus',
    'time__unable_set_time' => "Systemzeit kann nicht konfiguriert werden: %1",
    'time__sinchronization_setup_error' => 'Zeitsynchronisierung kann nicht eingerichtet werden: timemng fehlgeschlagen: %1',
    'time__sinchronization_disable_error' => 'Zeitsynchronisierung kann nicht deaktiviert werden: Zeitverwaltung fehlgeschlagen: %1',
    'tmpl__create' => "Template erstellen",
    'tmpl__edit__' => 'Template %1',
    'tmpl__logrotation_warn' => "Die durch dieses Template auf der Domain eingerichtete Protokollrotation wird nur ausgeführt, wenn Sie anschließend ein physisches Hosting-Konto erstellen.",
    'tmpl__name' => "Template-Name",
    'tmpl__dom_exist' => "Im Template-Pool des Administrators oder des Kunden ist bereits ein Domain-Template mit diesem Namen vorhanden.",
    'tmpl__name_invalid' => "Template-Name ist ungültig oder leer.",
    'tmpl__use_next_ip_addr' => "Nächste freie IP-Adresse wird verwendet",
    'tmpl_name_already_exists' => "Template mit Name '%1' existiert bereits.",
    'traffic__no_periods_found' => "Web- und Traffic-Statistiken können nicht angezeigt werden. Diese Funktion wird erst nach der nächsten Statistikberechnung aktiv.",

    'vh_based__no_free_ip_for_vh' => "Es gibt keine freien IP-Adressen mehr, um ein IP-basiertes Virtual Hosting zu erstellen. Bitte fügen Sie eine IP-Adresse hinzu.",

    'wu__at_domains_text' => "Zugriffsformat webbenutzer@%1 zulassen",
    'wu__unable_create' => "Webbenutzer kann nicht erstellt werden: %1",
    'wu_edit__disk_quota' => "Speicherplatzkontingent",
    'wu_edit__invalid_pass' => "Passwort ist ungültig.",
    'wu_edit__invalid_quota' => "Der angegebene Wert für das Speicherkontingent ist ungültig. Geben Sie eine positive Ganzzahl ein.",
    'wu_edit__invalid_quota_value' => "Die angegebene Festplatten-Quota ist geringer als die derzeitig verwendete (%1MB). Einige Funktionen könnten nicht verfügbar sein. Möchten Sie wirklich fortfahren?",
    'wu_edit__not_create_pass' => "Bei diesem Vorgang wird kein Passwort für den neuen Webbenutzer angelegt. \nOhne Passwort kann sich der Webbenutzer nicht anmelden.",
    'wu_edit__unable_update' => "Webbenutzer-Eigenschaft kann nicht aktualisiert werden: %1",

    'bt_webdirs' => 'Virtuelle Verzeichnisse',

    'dns__tabs_general' => 'Zoneneinstellungen',
    'dns__tabs_zone_settings' => 'SOA-Einträge',
    'soa__seconds' => 'Sekunden',
    'soa__minutes' => 'Minuten',
    'soa__hours' => 'Stunden',
    'soa__days' => 'Tage',

    'DomainSubdirectory' => 'Zielunterverzeichnis',

    'filemanager__select_codepage' => 'Codepage auswählen:',

    'bt_server_app_add' => 'Serveranwendung hinzufügen',
    'packages_list' => 'Serveranwendungen',

    'bt_packages_management' => 'Paketverwaltung',
    'pb__packages_management' => 'Anwendungsverwaltung',
    'bt_package_new' => 'Anwendung hinzufügen',
    '__packages' => 'Serveranwendungen',

    'dom_ctrl__mysql_dbase_space' => 'MariaDB/MySQL-Datenbankkontingent gesamt',
    'dom_ctrl__mssql_dbase_space' => 'MS SQL-Datenbankkontingent gesamt',

    'dns_add__enter_ixfr_path' => 'Geben Sie den IXFR-Pfad ein',

    'cmd_dns__txt_dns_record_already_exist' => 'Solch ein SPF-TXT-Eintrag existiert bereits. Es kann nur ein SPF-Eintrag eingegeben werden. Wenn Sie einen Eintrag hinzufügen wollen, müssen Sie zuerst den vorhandenen löschen.',

    'component_name__network' => 'IP-Verwaltung',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Skin einrichten',
    'bt_set_skin' => 'Skin einrichten',
    'firewall__rule_already_exists' => 'Die Regel mit dem Namen "%1" ist bereits vorhanden',
    'firewall__rule_readonly' => 'Regel "%1" ist schreibgeschützt',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Dateispeicherort ist ungültig.',

    'error_doc__erorr_invalid_url_location' =>  'Falsches URL-Format. Bitte geben Sie nur eine URL innerhalb der Site ein.',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Virenschutz',
    'antivirus__antivirus' => 'Virenschutz',
    'antivirus__antivirus_direction_off' => 'Ausgeschaltet',
    'antivirus__antivirus_direction_any' => 'Eingehende und ausgehende E-Mails',
    'antivirus__antivirus_direction_from' => 'Nur ausgehende E-Mails',
    'antivirus__antivirus_direction_to' => 'Nur eingehende E-Mails',
    'antivirus__unable_to_update_settings' => 'Aktualisierung der Antivirus-Einstellungen von %1 nicht möglich.',




    '__normal' => 'Normal',
    '__low' => 'Niedrig',
    '__high' => 'Hoch',

    'mail__antivirus' => "Antivirus-Software von internem Mailserver",
    'mail__use_internal_antivirus' => 'Internes Antivirus benutzen',

    'sa__tabs_blacklist' => 'Blacklist',

    '__mysql_databases' => 'MariaDB/MySQL-Datenbanken',

    'cl_perm__mysql_dbase_space' => 'MariaDB/MySQL-Datenbankkontingent gesamt',
    'cl_perm__mssql_dbase_space' => 'MS SQL-Datenbankkontingent gesamt',
    'cl_perm__max_mssql_db' => 'Maximale Anzahl der Microsoft SQL-Serverdatenbanken',
    'cl_perm__total_mboxes_quota' => 'Postfachkontingent gesamt',

    'i_i_cl_on' => 'Das Kundenkonto ist aktiv.',
    'i_i_cl_off_by_admin' => 'Das Kundenkonto wurde vom Administrator gesperrt.',

    'sa_exists_tn' => 'Das Netwerk ist bereits in der Liste.',

    'webdir__select_mime_types_to_remove' => 'Wählen Sie die MIME-Typen aus, die Sie löschen möchten',

    'defaultcomponents__not_activated' => 'nicht aktiviert',

    'bt_traffic_at_domains' => 'Verkehr',

    '__awstats_perl_warning' => 'Ohne Perl installiert zu haben, wird AWStats es Benutzern nicht erlauben, die Statistiken vorheriger Jahre zu prüfen.',

    'class_client__mysql_dbase_space' => 'Der Wert übersteigt das Kundenlimit.',
    'class_client__mssql_dbase_space' => 'Der Wert übersteigt das Kundenlimit.',
    'class_client__max_mssql_db' => 'Der Wert übersteigt das Kundenlimit.',

    'dns__remove_transfer_restrictions_list_items' => 'Die folgenden Netzwerke werden aus der Zugriffskontrollliste entfernt:',

    'bt_up' => "Aufsteigend",
    'bt_down' => "Nach unten",
    'virtualdir__type_default_doc_name_to_add' => 'Geben Sie einen Dateinamen ein, der zur Liste hinzugefügt werden soll',
    'virtualdir__select_default_doc_to_remove' => 'Von der Liste zu entfernende Dateien auswählen',
    'virtualdir__select_directory' => 'Verzeichnis auswählen',

    'bt_install_selected' => 'Ausgewählte Lizenzschlüssel installieren', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Die Domain wird auf eine andere IP-Adresse aufgelöst: (%1). Bitte korrigieren Sie die DNS-Einstellungen.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Der momentan verwendete Server unterstützt nicht die gleichzeitige Aktivierung von Postfach und Mailgruppen. Klicken Sie auf OK, um das Postfach zu aktivieren und die Mailgruppen zu deaktivieren. Klicken Sie auf Abbrechen, um die aktuellen Einstellungen beizubehalten.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Der momentan verwendete Server unterstützt nicht die gleichzeitige Aktivierung von Postfach und Mailgruppen. Klicken Sie auf OK, um die Mailgruppen zu aktivieren und das Postfach zu deaktivieren. Klicken Sie auf Abbrechen, um die aktuellen Einstellungen beizubehalten.',

    'mysql_dbase_space_limit' => 'Speicherlimit der MariaDB/MySQL-Datenbank',
    'mysql_dbase_usage' => 'Speicherbelegung durch MariaDB/MySQL-Datenbank',
    'mssql_dbase_space_limit' => 'Speicherlimit der Microsoft SQL Server-Datenbank',
    'mssql_dbase_usage' => 'Speicherbelegung durch Microsoft SQL Server-Datenbank',

    '__statistics' => "Statistiken", //indirect

    'dns__soa_minimum_value_is_big' => 'Wenn Sie den Minimum-TTL-Wert auf über 3 Stunden einstellen, können möglicherweise einige Domainadministratoren nicht auf Ihre Domains zugreifen. Es wird empfohlen, diesen Wert nur dann zu einzustellen, wenn Ihr Domain-Registrar darauf besteht.',

    'virusfilter__interface_not_available' => 'Keine Virenfilter verfügbar.',
    'virusfilter__none_virus_filter' => 'Ohne',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'deaktiviert',
    'virusfilter__status_any' => 'Eingehende und ausgehende E-Mails',
    'virusfilter__status_outgoing' => 'nur ausgehende E-Mails',
    'virusfilter__status_incoming' => 'nur eingehende E-Mails',

    'visibility__root_override_parse_error' => 'Es gibt einen Syntaxfehler in der Datei %1 in Zeile %2!',

    'sb__not_support_publishing_api' => "Komponente unterstützt Veröffentlichen-Automatisierung nicht",

    'component_name__cphosting' => "Plesk-Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Das Einrichten von Postfachkontingentens wird von diesem Mailserver nicht unterstützt.',
    '__unable_get_total_mboxes_quota' => 'Das Einrichten von Postfachkontingentens wird von diesem Mailserver nicht unterstützt.',

    'install_prefix__parent_not_exists' => "Oberverzeichnis existiert nicht.",

    'bt_change_version' => 'Version ändern',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Alle auswählen",
    '__uncheck_all' => "Alle abwählen",

    'dns__editing_domain_controller_zone' => "Das Bearbeiten von DNS-Zoneneinträgen für Domain-Controller kann die Funktion der Domain beeinträchtigen",

    'pb__interface_management' => "Verwaltung der Oberfläche",
    'interface_management__tabs_skins' => "Oberflächen",
    'interface_management__tabs_interface_templates' => "Oberflächen-Templates",
    'interface_management__tabs_locales' => "Sprachdateien",
    'locales_list__title' => "Sprachpaket-Repository",
    'locales_list__legend' => "Verfügbare Sprachen",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Sprachpaket",
    'locales_list__lang_title' => "Sprache",
    'locales_list__country_title' => "Land",
    'locales_list__used_title' => "Verwendet",

    'backup__suspend_warning_during_backup' => "Die Domain wird während des Backups nicht verfügbar sein",
    'backup__suspend_warning_during_restore' => "Die Domain wird während der Wiederherstellung nicht verfügbar sein",
    'backup__suspend_domain' => "Domain sperren",

    'locales_list__mls_limit' => "Ihre aktuelle Plesk Lizenz erlaubt nur die Verwendung von %2 Sprachen. Im Moment sind für Ihre Benutzer %1 Sprachen verfügbar. Diese Zahl übersteigt die mit der Lizenz zulässige Zahl. Bitte wählen Sie %2 zu verwendende Sprachen aus und deaktivieren Sie die restlichen für Benutzer, indem Sie auf ihre Symbole in der Spalte 'S' klicken.",

    'bt_change_owner' => 'Neuen Besitzer zuweisen',
    'chown__new_owner' => 'Neuer Besitzer',
    'chown__selected_domains' => 'Ausgewählte Abonnements',
    'chown__limits_legend' => 'Ressourcen',
    'chown__limit_name' => 'Ressourcenname',
    'chown__limit_value' => 'Zugewiesene Ressourcen',
    'chown__limit_assigned_before' => 'Vor dem Transfer',
    'chown__limit_assigned_after' => 'Nach dem Transfer',
    'chown__error_limits' => "Abonnement-Transfer kann nicht fortgesetzt werden: Dieses Abonnement erfordert mehr Ressourcen als von dem Provider des neuen Besitzers zur Verfügung gestellt werden.",
    'chown__error_no_domains' => 'Abonnement-Transfer kann nicht fortgesetzt werden: entweder wurden keine Abonnements ausgewählt oder die ausgewählten Abonnements gehören bereits zum Ziel-Benutzer.',
    'chown__error_empty_ip_pool' => "Abonnement-Transfer kann nicht fortgesetzt werden: IP-Pool des neuen Besitzer-Providers ist leer. Bitte überprüfen Sie, dass der Provider über mindestens eine IP-Adresse in dem Pool verfügt.",
    'chown__please_select_new_domain_owner' => 'Wählen Sie den neuen Besitzer für dieses Abonnement aus.',
    'chown__old_ip_address' => 'Aktuelle IP-Adresse',
    'chown__new_ip_address' => 'Neue IP-Adresse',

    'chown__error_ssl_already_used' => "SSL/TLS-Unterstützung wird bereits auf den folgenden Ziel-IPs verwendet: %1. Daher konnten die folgenden Domains mit SSL/TLS-Unterstützung nicht übertragen werden: %2. Beheben Sie das Problem und versuchen Sie es erneut.",
    'chown__sitebuilder_not_installed' => 'Presence Builder ist nicht installiert',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Die Domain %1 kann nicht auf einen anderen Besitzer übertragen werden, da Presence Builder nicht installiert ist.',

    'backup__backup_time' => 'Backupzeit',
    'backup__backup_time_hour' => 'Stunden',
    'backup__backup_time_minute' => 'Minuten',
    'backup__every' => 'alle',
    'backup__day_of_month' => 'Tag des Monats',

    'subdomain__select_hst_type' => 'Wählen Sie den Hosting-Typ für die Subdomain aus',
    'hst_sel__subdom_subfolder_hst' => 'Subdomain auf Unterordner',
    'subdomain__www_root_folder_not_exists' => 'Site-Hauptverzeichnis %1 existiert nicht',
    '__site_home_dir' => 'Site-Hauptverzeichnis',
    'subdomain__aspnet_disabled_domain' => 'von Domain deaktiviert',

    'domains__remove_description' => 'Alle Domain-Daten, einschließlich Inhalt und Einstellungen der Domain und der dazugehörigen Subdomains, Daten von Webanwendungen, Postfachinhalte, E-Mail-, Antivirus- und Spamfilter-Einstellungen, Protokolldateien, Domain-Backup-Repository-Daten und SSL/TLS-Zertifikate werden gelöscht. Wenn auf Ihrem lokalen Computer keine Backupdatei vorhanden ist, gehen alle Daten unwiederbringlich verloren.',
    'subdomains__remove_description' => 'Alle Subdomain-Daten, einschließlich Inhalt und Einstellungen der Subdomain, Daten von Webanwendungen und Protokolldateien werden gelöscht. Wenn auf Ihrem lokalen Computer keine Backup-Datei vorhanden ist, gehen alle Daten unwiederbringlich verloren.',

    'mail__tabs_spam_filtering' => 'Spamfilterung',
    'mail__tabs_antivirus' => 'Virenschutz',
    'antivirus__use_server_settings_scan' => 'Standardmäßige serverweite Einstellungen verwenden (Durchsuchen)',
    'antivirus__use_server_settings_no_scan' => 'Standardmäßige serverweite Einstellungen verwenden (Nicht durchsuchen)',
    'antivirus__check_for_viruses' => 'Nach Viren suchen',
    'antivirus__dont_check_for_viruses' => 'Nicht auf Viren überprüfen',
    'antivirus__incoming_mail' => 'Eingehende E-Mails',
    'antivirus__outgoing_mail' => 'Ausgehende E-Mails',

    'domain_alias__CNAME_dns_record_exists' => 'Ein DNS-CNAME-Eintrag mit diesem Namen ist bereits vorhanden',
    'domain_alias__A_dns_record_exists' => 'Ein DNS-A-Eintrag mit diesem Namen ist bereits vorhanden',
    'domain_alias__bad_prefix' => 'Falsches Präfix für Domain-Alias',
    'domain_alias__domain_doesnt_exist' => "Domain existiert nicht",

    'dns__zone_ttl_message_info' => 'Wenn der TTL-Wert nicht angegeben wurde, wird der TTL-Wert im SOA-Eintrags-Template (%1) für diesen DNS-Eintrag verwendet.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Es wird eine Datei mit dem Namen index.html zur Umleitung an die ausgewählte Webanwendung erstellt. Falls bereits eine Datei mit dem Namen index.html existiert, wird sie als index.html.old gesichert und durch die neue Datei ersetzt. Klicken Sie zum Bestätigen auf OK",

    'bt_ftp_ctrl' => "Zusätzliche FTP-Konten",
    'ftp_users_no_permission' => "Sie haben keine Berechtigung zum Verwalten von FTP-Konten für diese Domain",
    'ftp_users_limit_reached' => "Grenze für FTP-Konten für diese Domain wurde erreicht",
    'pb__ftp_ctrl' => "FTP-Verwaltung",
    'class_client__max_subftp_users' => "Zusätzliche FTP-Konten",

    '__client_form_settings' => "Kundeneinstellungen",
    '__sbnet_client_keep_sbnet' => "Entsprechendes Benutzerkonto in Presence Builder behalten",
    '__sbnet_cant_add_more_sites' => "Die Grenze für die Anzahl an Websites, die den Presence Builder verwenden können, ist für diesen Kunden erreicht",
    '__sbnet_legend_text' => "Presence Builder Integration",
    '__sbnet_synchronize_user_with_sbnet' => "Entsprechendes Nutzerkonto in Presence Builder erstellen",
    '__sbnet_client_warning_delete_sb_user' => "Sie versuchen gerade, ein mit diesem Kunden verbundenes Benutzerkonto aus Presence Builder zu entfernen. Dadurch werden alle Websites des Nutzers und alle anderen relevanten Einstellungen vom Presence Builder System gelöscht und damit die Möglichkeit zum Bearbeiten vorhandener Websites über Presence Builder deaktiviert, selbst wenn Sie diese Option später wieder aktivieren. Wenn Sie später wieder einen Nutzerkonto für Presence Builder erstellen, müssen Sie alle Ihre Websites neu erstellen und veröffentlichen. Möchten Sie die Website-Erstellung und Veröffentlichung mit Presence Builder trotzdem deaktivieren?",
    'sb__build_site_with_subdomains' => "Blog- und Fotogalerie-Subdomains erstellen",
    '__sbnet_client_dont_have_sbuser' => "Website kann nicht mit Presence Builder erstellt und publiziert werden: Presence Builder Nutzer existiert nicht",

    '__component_disabled' => "Komponente deaktiviert",

    'subdomains__physical_path_not_exist' => "Es sind Subdomains mit nicht existierenden physischen Ordnern verknüpft",

    'dnsserver_bind_to_msdns_switching_warning' => "Warnung: Es werden nur die ersten 254 IP-Adressen von Subnetzen mit /8- und /16-Masken, die sich in der Zugriffskontrollliste befinden, übertragen. Sie werden als separate IP-Adressen übertragen. Möchten Sie fortfahren?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder Websites erfordern möglicherweise ASP.NET 2.0-Unterstützung auf Ihrer Domain. Wir empfehlen für die Verwendung von Presence Builder die Aktivierung der ASP.NET 2.0-Unterstützung.",

    'subdomain_auto_create_dir' => "Physisches Verzeichnis für Subdomain erstellen",

    'sa_trainer__unable_to_get_messages_list' => "Die Liste von Nachrichten in dem Postfach kann nicht abgerufen werden: %1",
    'sa_trainer__pass_doesnt_exist' => "Das Passwort für dieses Mail-Konto fehlt",

    '__sitebuilder_error' => "Beim Versuch, eine Verbindung zu Presence Builder herzustellen, ist ein Fehler aufgetreten. Bitte wenden Sie sich zur weiteren Unterstützung an Ihren Service-Provider.",
    'wsb_error_user_not_exist' => "Dieses Presence Builder Benutzerkonto existiert nicht.",
    'wsb_error_site_already_exist' => "Diese Website existiert bereits in Presence Builder.",
    'wsb_error_site_limit_reached' => "Die maximale Anzahl an Presence Builder Websites wurde erreicht.",
    'wsb_error_internal_error' => "Interner Fehler bei Presence Builder aufgetreten. Bitte wenden Sie sich zur weiteren Unterstützung an Ihren Service-Provider.",
    'wsb_error_user_already_exist' => "In Presence Builder ist bereits ein Presence Builder Benutzer mit diesem Namen vorhanden.",
    'sb_error_user_not_exist' => "Presence Builder Nutzer existiert nicht.",
    'wsb_error_object_not_found' => "Presence Builder konnte nicht den korrekten Host-Eintrag finden.",

    'mg_no_mail_groups' => "Keine Mail-Gruppen",

    'drweb__drweb_incoming' => 'Virenüberprüfung von eingehenden E-Mails',
    'drweb__drweb_outgoing' => 'Virenüberprüfung von ausgehenden E-Mails',
    'drweb__disable_reason_serv' => 'Der Mailserver unterstützt keine Antivirus-Filtereinstellungen auf Postfachebene',

    'vz_sitebuilder3_client_cant_be_created' => "Kundenkonto kann nicht erstellt werden: SiteBuilder Version 3.1 oder höher ist nicht installiert",

    'chown__client_without_sitebuilder_support' => "Abonnement-Transfer kann nicht fortgesetzt werden: Der Presence Builder Service ist nicht im Service-Paket des neuen Besitzers oder dessen Providers enthalten.",

    // new limits

    'class_client__max_odbc' => "ODBC-Verbindungen",
    'cl_perm__max_odbc' => "maximale Anzahl an ODBC-Verbindungen",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Domain-Alias-Name',
    'domain_alias__list_ascii_name' => 'Im ASCII-Format',


    // Interface Customization Templates
    'interface_preferences' => 'Verwaltung der Oberfläche',
    'pb__interface_templates' => 'Verwaltung der Oberfläche',
    'pb__interface_clients' => 'Kunden verwenden %1',

    // service management
    'bt_service_showall' => "Alle anzeigen",
    'bt_service_hideall' => "Alle ausblenden",
    'bt_service_start' => "Starten",
    'bt_service_stop' => "Anhalten",
    'bt_service_restart' => "Neu starten",
    'bt_service_disable' => "Deaktivieren",
    'bt_service_manual' => "Manuell",
    'bt_service_auto' => "Autom.",
    'service_startup_auto' => 'Automatisch',
    'service_startup_manual' => 'Manuell',
    'service_startup_disabled' => 'Deaktiviert',
    'service_action_ok' => "Die Operation mit dem Service %1 wurde erfolgreich abgeschlossen",
    'service_action_failed_disabled_service' => "Die Operation mit dem Service %1 konnte nicht abgeschlossen werden, da der Service deaktiviert ist",
    'service_action_failed_error' => "Operation konnte nicht abgeschlossen werden: %1",
    'service_group_action_ok' => "Die Operation mit den folgenden Services wurde erfolgreich abgeschlossen: \n %1",
    'service_group_action_disabled' => "Die Operation mit den folgenden Services konnte nicht abgeschlossen werden, da diese deaktiviert sind: \n %1",
    'service_group_action_failed' => "Die Operation konnte mit den folgenden Services nicht abgeschlossen werden: \n %1. \nUm detaillierte Fehlerinformationen zu erhalten, führen Sie die Operation mit jedem Service einzeln aus",

    // php 4vs5
    'bt_php' => "PHP-Einstellungen",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Verfügbare Reseller',
    'massmail__resellers_list_selected' => 'Ausgewählte Reseller',
    'massmail__clients_list_available_for_select' => 'Verfügbare Kunden',
    'massmail__clients_list_selected' => 'Ausgewählte Kunden',
    'massmail__advanced' => 'Erweitert',
    'bt_massmail_send' => 'Senden',
    'massmail__save_template_name' => 'Text unter einem neuen Template-Namen speichern',
    'massmail__template' => 'Vorlage',
    'massmail__compose_mail' => 'Nachricht',
    'massmail__from' => 'Ab',
    'massmail__to' => 'An',
    'massmail__subject' => 'Betreff',
    'massmail__body' => 'Nachrichtentext',
    'massmail__body_hint' => 'Verwenden Sie die Variable <name>, um automatisch den Benutzernamen in Ihre Nachricht einzufügen',
    'massmail__send_to_clients' => "Kunden",
    'massmail__send_to_domainusers' => "Domainadministratoren",
    'massmail__send_to_admins' => "Plesk Administratoren",
    'massmail_select' => 'Adressen auswählen',
    'massmail_showhide_selected' => "Ausgewählte anzeigen/verbergen",
    'massmail_send_all' => "Alle",
    'massmail_send_selected' => "Nur ausgewählte",
    'massmail_send_except' => "Alle außer den ausgewählten",
    'bt_new_mass_mail_template' => "Massen-E-Mail-Template hinzufügen",
    '__mass_mail_templates_list' => "Liste der Massen-E-Mail-Templates",
    'massmail__template_name' => 'Template-Name',
    'massmail__receivers' => 'Empfänger',
    'massmail__created' => 'Absender',
    'massmail__date_created' => 'Erstellungsdatum',
    'massmail__compose' => 'Senden',
    'mass_mail__resellers_all' => 'Alle Reseller',
    'mass_mail__clients_all' => 'Alle Kunden',
    'mass_mail__domainusers_all' => 'Alle Domainadministratoren',
    'mass_mail__resellers_selected' => 'Ausgewählte Reseller',
    'mass_mail__clients_selected' => 'Ausgewählte Kunden',
    'mass_mail__domainusers_selected' => 'Ausgewählte Domainadministratoren',
    'mass_mail__resellers_except' => 'Alle Reseller außer den ausgewählten',
    'mass_mail__clients_except' => 'Alle Kunden außer den ausgewählten',
    'mass_mail__domainusers_except' => 'Alle Domainadministratoren außer den ausgewählten',
    'mass_mail__admins_all' => 'Alle Administratoren',
    'massmailtemplateslist__title' => 'Massen-E-Mail-Templates',
    'massmail__insert_from_template' => "Daten aus Template einfügen",
    'massmail__select_template' => "Wählen Sie das Template aus",
    'massmail__body_short_hint' => "(nur Klartext)",
    'massmail__from_short_hint' => "(E-Mail-Adresse oder Name)",
    'bt_insert' => "Einfügen",
    'massmail__mail_send_successfully' => "Die Nachricht wurde erfolgreich hinausgeschickt",
    'massmail__mail_send_successfully_with_some_errors' => "Die Nachricht wurde versendet, es sind jedoch mehrere Fehler aufgetreten. Einige Empfänger erhalten die Nachricht möglicherweise nicht. Weitere Informationen finden Sie in der folgenden Protokolldatei: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Die Nachricht wurde nicht versendet. Bitte stellen Sie sicher, dass mindestens ein Empfänger ausgewählt ist und dass der Plesk Mailserver einwandfrei funktioniert. Weitere Informationen finden Sie in folgender Protokolldatei: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Die Daten aus Template %1 wurden erfolgreich eingefügt.",
    'massmail__template_added_successfully' => "Das Nachrichten-Template wurde unter dem Namen %1 gespeichert.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Fehler bei Presence Builder Datenbank aufgetreten. Bitte wenden Sie sich zur weiteren Unterstützung an Ihren Service-Provider.",
    'wsb_error_sitebuilder_access_denied_error' => "Zugriff auf Datei nicht möglich: Presence Builder hat keine Zugriffsrechte für die erforderliche Datei bzw. den Ordner. Bitte wenden Sie sich zur weiteren Unterstützung an Ihren Service-Provider.",
    'wsb_error_sitebuilder_connection_failed' => "Verbindungsaufbau mit Presence Builder nicht möglich, da die Verbindung unterbrochen wurde. Bitte wenden Sie sich zur weiteren Unterstützung an Ihren Service-Provider.",
    'wsb_error_critical_during_operation' => "Kritischer Fehler bei Presence Builder aufgetreten:\n%1",
    'wsb_error_license_during_operation' => "Fehler mit der Lizenz für Presence Builder aufgetreten:\n%1",
    'wsb_error_during_operation' => "Fehler bei Presence Builder aufgetreten:\n%1",
    'wsb_error_license_error' => "Es wurde eine Einschränkung der Presence Builder Lizenz festgestellt.",

    // Other
    '__confrim_service_stop' => "Warnung! Wenn Sie den Service %1 stoppen, funktioniert Plesk möglicherweise nicht mehr. Möchten Sie den Service %1 wirklich stoppen?",
    'virtualdir__name_is_reserved' => "Dieser Name ist reserviert",
    'index_redirect_help_text' => 'Sie werden jetzt automatisch auf die entsprechende Website umgeleitet. Falls Ihr Browser Weiterleitung nicht unterstützt, klicken Sie bitte %1 hier %2',
    'bt_default_settings' => "Standardeinstellungen wiederherstellen",
    'logfiles__remove_failed' => "Datei %1 konnte nicht gelöscht werden: Die Datei wird von einer anderen Anwendung gesperrt. Bitte versuchen Sie es später erneut",
    'subdomain__invalid_homedirectory' => "Angegebenes Hauptverzeichnis der Subdomain ist ungültig",
    'scheduler_item__empty_filename' => "Bitte geben Sie die ausführbare Datei an, die ausgeführt werden soll",
    'subdomains__overlapped_domain_exists' => 'Die Subdomain wird von der DNS-Zone der Domain %1 überdeckt',
    'subdomains__overlapped_domain_alias_exists' => 'Die Subdomain wird von der DNS-Zone des Domain-Alias %1 überdeckt',
    'services_action_none_selected' => 'Operation konnte nicht abgeschlossen werden: Bitte wählen Sie die erforderlichen Services aus',
    'cl_perm__max_subftp_users' => "maximale Anzahl zusätzlicher FTP-Konten",
    'login_up__access_denied_no_cp_access' => 'Zugriff verweigert. Sie haben keine Berechtigung zum Zugriff auf Plesk.',
    'drweb__disable_reason_admin' => "Die Serverrichtlinien lassen keine Antivirus-Filtereinstellungen auf Postfachebene zu.",

    'webdirs__name_is_invalid' => 'Verwenden Sie nur alphanumerische Zeichen, Unterstriche oder Bindestriche im Verzeichnisnamen.',
    'webdirs__physical_path_is_invalid' => 'Physischer Pfad ist ungütig oder nicht vorhanden',
    '__use_default' => 'Standard verwenden',

    'webalizer_hidden_referrer__already_exist' => 'Ein solcher Eintrag ist bereits vorhanden.',
    'webalizer_group_referrer__already_exist' => 'Ein Gruppen-Referrer mit diesem Namen ist bereits vorhanden.',

    'pb__dashboard' => 'Start',

    'server_interface__page_title' => 'Einstellungen für die Server-Oberfläche',
    'server_interface__tabs_locales' => 'Sprachdateien',
    'server_interface__tabs_skins' => 'Oberflächen',
    'server_interface__tabs_interface_templates' => 'Oberflächen-Templates',
    'bt_server_interface' => 'Einstellungen zur Benutzeroberfläche',
    'pb__server_interface' => 'Einstellungen zur Benutzeroberfläche',

    'bt_wizard_next' => 'Weiter >>',
    'bt_wizard_prev' => '<< Zurück',

    '__limit_exceeded_max_dom_server' => 'Sie können keine weiteren Domains auf diesem Server hosten, da die Grenze der vom Lizenzschlüssel erlaubten Domains erreicht wurde. Kontaktieren Sie Ihren Service-Provider, um dieses Problem zu lösen.',
    '__limit_exceeded_max_subdom_server' => 'Sie können keine weiteren Subdomains auf diesem Server hosten. Bitte wenden Sie sich an Ihren Service-Provider.',
    '__limit_exceeded_max_dom_aliases_server' => 'Sie können kein weiteren Domain-Aliase auf diesem Server einrichten. Bitte wenden Sie sich an Ihren Service-Provider.',
    '__limit_exceeded_max_wu_server' => 'Sie können keine weiteren Webbenutzer erstellen, da die Grenze der vom Lizenzschlüssel auf dem Server erlaubten Webbenutzer erreicht wurde. Kontaktieren Sie Ihren Service-Provider, um dieses Problem zu lösen.',
    '__limit_exceeded_max_mn_server' => 'Sie können keine weiteren E-Mail-Konten erstellen, da die Grenze der vom Lizenzschlüssel auf dem Server erlaubten E-Mail-Konten erreicht wurde. Kontaktieren Sie Ihren Service-Provider, um dieses Problem zu lösen.',

    '__limit_exceeded_max_cl_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel (%2) festgelegte Grenze für die Anzahl an Kundenkonten erreicht',
    '__limit_exceeded_max_dom_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Domains (%2) erreicht',
    '__limit_exceeded_max_subdom_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Subdomains (%2) erreicht',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Domain-Aliasen (%2) erreicht',
    '__limit_exceeded_disk_space_useradmin' => 'Sie haben keinen freien Speicherplatz mehr',
    '__limit_exceeded_max_wu_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Webbenutzerkonten (%2) erreicht',
    '__limit_exceeded_max_db_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Datenbanken (%2) erreicht',
    '__limit_exceeded_max_box_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Postfächern (%2) erreicht',
    '__limit_exceeded_max_mn_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel (%2) festgelegte Grenze für die Anzahl an E-Mail-Konten erreicht',
    '__limit_exceeded_max_maillists_useradmin' => 'Sie haben die durch Ihren Lizenzschlüssel festgelegte Grenze für die Anzahl an Mailinglisten (%2) erreicht',

    '__limit_exceeded_max_dom_userclient' => 'Sie haben die Grenze für die Anzahl an Domains (%2) erreicht',
    '__limit_exceeded_max_subdom_userclient' => 'Sie haben die von Ihrem Service-Provider erlaubte Anzahl an Subdomains (%2) erreicht',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Sie haben die Grenze für die Anzahl an Domain-Aliasen erreicht (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Sie haben die Grenze für den Speicherplatzverbrauch (%2) erreicht',
    '__limit_exceeded_max_traffic_userclient' => 'Sie haben die Grenze für die Bandbreitennutzung pro Monat (%2) erreicht',
    '__limit_exceeded_max_wu_userclient' => 'Sie haben die von Ihrem Service-Provider erlaubte Anzahl an Webbenutzern (%2) erreicht.',
    '__limit_exceeded_max_db_userclient' => 'Sie haben die Grenze für die Anzahl an Datenbanken (%2) erreicht',
    '__limit_exceeded_max_box_userclient' => 'Sie haben die Grenze für die Anzahl an Postfächern (%2) erreicht',
    '__limit_exceeded_max_maillists_userclient' => 'Sie haben die Grenze für die Anzahl an Mailinglisten (%2) erreicht',
    '__limit_exceeded_expiration_userclient' => 'Ihr Konto ist am %2 abgelaufen',

    '__limit_exceeded_max_subdom_userdomain' => 'Sie haben die von Ihrem Service-Provider erlaubte Anzahl an Subdomains (%2) erreicht',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Sie haben die Grenze für die Anzahl an Domain-Aliasen erreicht (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Sie haben die Grenze für den Speicherplatzverbrauch (%2) erreicht',
    '__limit_exceeded_max_traffic_userdomain' => 'Sie haben die Grenze für die Bandbreitennutzung pro Monat (%2) erreicht',
    '__limit_exceeded_max_wu_userdomain' => 'Sie haben die Grenze für die Anzahl an Webbenutzerkonten erreicht (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Sie haben die Grenze für die Anzahl an Datenbanken (%2) erreicht',
    '__limit_exceeded_max_box_userdomain' => 'Sie haben die Grenze für die Anzahl an Postfächern (%2) erreicht',
    '__limit_exceeded_max_maillists_userdomain' => 'Sie haben die Grenze für die Anzahl an Mailinglisten (%2) erreicht',
    '__limit_exceeded_expiration_userdomain' => 'Ihr Konto ist am %2 abgelaufen',

    'mmt__to_none' => 'Ohne',
    'mmt__to_admin' => 'Administrator',
    'mmt__to_resellers_all' => 'Alle Reseller',
    'mmt__to_resellers_select' => 'Ausgewählte Reseller',
    'mmt__to_resellers_select__available' => 'Verfügbare Reseller',
    'mmt__to_resellers_except' => 'Alle Reseller außer den ausgewählten',
    'mmt__to_clients_all' => 'Alle Kunden',
    'mmt__to_clients_select' => 'Ausgewählte Kunden',
    'mmt__to_clients_select__available' => 'Verfügbare Kunden',
    'mmt__to_clients_except' => 'Alle Kunden außer den ausgewählten',

    'mmt__unable_send_empty_selection' => 'Massen-E-Mail kann nicht versendet werden, da keine E-Mail-Adressen ausgewählt wurden.',
    'mmt__unable_send_to__' => 'Massen-E-Mail kann nicht versendet werden an:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Validieren der Webanwendung nicht möglich, da eine erforderliche Datei (%1) nicht gefunden wurde. Setzen Sie sich mit dem technischen Supportteam in Verbindung.',
    'sapp_error_validation_spec_failed' => 'Die hochgeladene Webanwendung entspricht nicht den AppPacks-Anforderungen: %1.',
    'sapp_error_validation_register' => 'Registrieren der Webanwendung im Verzeichnis "%1" nicht möglich: %2. Entfernen Sie die Webanwendung vom Server, da sie nicht ordnungsgemäß funktioniert.',

    'sapp__install_failed' => 'Installation der Webanwendung fehlgeschlagen: %1',
    'sapp__install_res_failed' => 'Erstellen der angeforderten Ressource fehlgeschlagen.',

    'server_preferences__subdomains_blog_and_photo' => 'Standardmäßig Blog- und Fotogalerie-Subdomains erstellen',
    'plesk_key__blog_and_photo' => 'Verwaltung des Standardstatus des Kontrollkästchens \'Blog- und Fotogalerie-Subdomains erstellen\'',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'IP-Adresse kann nicht exklusiv sein, wenn sie mehreren Kunden zugewiesen ist',

    // 8.1.1

    '__write_modify_warning' => 'Durch das Auswählen zusätzlicher Schreib-/Änderungsberechtigungen werden einige Webanwendungen korrekt funktionieren, allerdings entstehen dadurch auch erheblich größere Sicherheitsrisiken',
    '__write_modify_subdomain_warning' => 'Durch das Auswählen zusätzlicher Schreib-/Änderungsberechtigungen werden einige Webanwendungen korrekt funktionieren, allerdings entstehen dadurch auch erheblich größere Sicherheitsrisiken',

    'phosting__php_incorrect_version_used' => "Es wurden Probleme mit der PHP-Version festgestellt. Zum Lösen dieser Probleme aktivieren Sie unten das Kontrollkästchen mit der erforderlichen PHP-Version und klicken Sie auf OK. Um PHP auf dieser Domain zu deaktivieren, klicken Sie auf OK, ohne die PHP-Version auszuwählen",
    'fp__mail_preferences' => 'E-Mail-Einstellungen',

    'mail__invalid_white_pattern' => 'Der angegebene Wert ist ungültig. Verwenden Sie das Format "mail@example.com" für E-Mail-Adressen und "example.com" für Domains.',
    'mail__invalid_black_pattern' => 'Der angegebene Wert ist ungültig. Verwenden Sie folgendes Format: mail@example.com für E-Mail-Adressen, example.com für Domains.',

    'resp_edit__reply_as_html' => 'Als HTML senden',
    'exception__path_very_long' => "Der Pfad ist zu lang. Bitte stellen Sie sicher, dass der Pfad aus weniger als %1 Zeichen besteht.",

    // 8.2


    //SAPP
    'sapp_on' => 'An',
    'sapp_off' => 'Aus',
    'sapp_directive_aspect' => 'Erforderlich',
    'sapp_databases_num' => 'Datenbanken',
    'sapp_db_required' => 'Erforderlich',
    'sapp_Required' => 'Erforderlich',
    'sapp_Variant' => 'Variante',
    'sapp_db_id' => 'Datenbank-ID',
    'sapp_db_id_type' => 'DB (ID: %1) Typ',
    'sapp_db_id_min_version' => 'DB (ID: %1) min. Version',
    'sapp_db_id_table_prefix' => 'DB (ID: %1) Tabellenpräfix',
    'sapp_Default' => 'Standardwert',
    'sapp_apache_mod_req' => 'Apache-Modul',
    'sapp_dbtype_not_installed' => 'nicht installiert',
    'sapp_apache_mod_not_installed' => 'nicht installiert',
    'sapp__value_error_empty' => 'Der Wert darf nicht leer sein.',
    'sapp_error_invalid_type' => 'Die Anwendung "%1" unterstützt die angeforderte Aktion nicht.',
    'sapp_error_unknown_app_type' => 'Nicht unterstützter Anwendungstyp: %1.',
    'sapp__ssl_text' => 'Anwendung auf virtuellem Host "http://" oder "https://" installieren?',
    'sapp__app_to_upgrade' => 'Anwendungen, für die ein Upgrade durchgeführt werden soll',
    'sapp__upgrade_apps_title' => 'Anwendungen aktualisieren',
    'sapp__upgrade_to_ver' => 'Upgrade auf Version',
    'sapp__choose_pkg_ver' => 'Paket auswählen...',
    'sapp__pkg_cant_upgrade_pkg' => 'Paket "%1" kann nicht zum Upgrade von Webanwendung "%2" verwendet werden.',
    'sapp__app_ugrade_error' => 'Die Anwendung kann nicht aktualisiert werden: %1. Bitte setzen Sie sich mit Ihrem Systemadministrator in Verbindung.',
    'sapp__no_suitable_db_found' => 'Keine entsprechende Datenbank gefunden.',
    'sapp__upgrade_success' =>  'Die Anwendung wurde aktualisiert.',
    'sapp__pkg_info_changelog' => 'Changelog',
    'sapp_requirement_legend' => 'Für die Anwendung erforderliche Hosting-Features',

    // other
    'bt_apply' => 'Übernehmen',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Zum Erstellen eines E-Mail-Alias sollte das Postfach für dieses E-Mail-Konto aktiviert sein. Postfach aktivieren?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Beim Deaktivieren des Postfachs werden die E-Mail-Aliase entfernt, da sie nicht mehr funktionieren. Postfach deaktivieren?',
    'antivirus__disable_reason_install' => 'Sie können Antivirus nicht verwalten, da es nicht installiert ist',
    'antivirus__disable_reason_key' => 'Sie können Antivirus nicht verwalten, da es nicht mit dem richtigen Lizenzschlüssel aktiviert wurde.',
    'antivirus__disable_reason_deny_personal_settings' => 'Sie können Antivirus nicht verwalten, da die Serverregel individuelle Antivireneinstellungen nicht zulässt.',
    'change_foreign_user_password' => 'Passwort ändern',
    'change_foreign_user_password_hint' => "Der Benutzer gehört nicht zu dieser Anwendung. Klicken Sie auf den Link, um zu einer andern Anwendung zu wechseln und das Passwort des Benutzers dort zu ändern. Dafür benötigen Sie die entsprechenden Berechtigungen für die Anwendung.",
    'cf_url_text' => 'JDBC-URL',
    'cf_sendStringParametersAsUnicode_text' => 'Format für Zeichenfolge',
    'lang_unknown' => 'Unbekannte Sprache',
    'pb__cl_ed' => 'Kundendetails',
    'pb__actionlog' => 'Aktionsprotokoll',
    'pb__cl_limits' => 'Kundengrenzen',
    'pb__edit' => 'Bearbeiten',
    'pb__subdom_edit' => 'Hosting-Einstellungen',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Backup für Postfach-Inhalte erstellen',

    'maillist_import_result' => "\nGesamtanzahl der E-Mail-Adressen in Datei: %1\nAnzahl importierter E-Mail-Adressen: %2\nAnzahl bereits bestehender E-Mail-Adressen: %3\nAnzahl duplizierter E-Mail-Adressen in der angegebenen Datei: %4\nAnzahl ungültiger E-Mail-Adressen in Datei: %5",
    'maillist_import_error' => 'Liste der E-Mail-Adressen kann nicht importiert werden',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Die von Ihnen ausgewählte Datei ist entweder leer oder kein gültiges HTML-Dokument der ausgewählten Kodierung. Bitte wählen Sie die richtige Kodierung aus oder füllen Sie die Datei mit Inhalt.",

    'dom_pref__external_mail_srv' => "An externen Mailserver mit der folgenden IP-Adresse weiterleiten:",
    'mn_edit__store_messages' => 'E-Mail-Postfach',

    // aps

    'sapp__before_upgrade_notice' => 'Es wird empfohlen, ein Backup der Anwendung und der Benutzerdaten durchzuführen, bevor Sie den Upgrade-Prozess starten.',
    'sapp__application_properties' => 'Anwendungseigenschaften',
    'sapp__application_root_descr' => 'Die Hauptseite der Anwendung',

    'sapp__aps_license_invalid_id' => 'Ungültige Lizenzschlüssel-ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Es existiert bereits eine Lizenz mit der Lizenznummer %1 in der Datenbank.',
    'sapp__aps_lic_del_used' => 'Lizenzschlüssel kann nicht gelöscht werden. Er wird von einer der installierten Anwendungen verwendet.',
    'sapp__aps_lic_del_unknown' => 'Lizenzschlüssel kann nicht gelöscht werden: %1',
    'sapp__aps_cappi_duplicate' => "Diese Anwendung befindet sich bereits im Anwendungspool des Kunden",
    'sapp__appi_not_shared_no_install' => "Im Anwendungspool des Kunden ist keine Anwendung dieser Art vorhanden. Wenn Sie diese Anwendung auf einer Site installieren möchten, sollten Sie diese Anwendung zuerst zum Anwendungspool des Kunden hinzufügen.",
    'sapp__appi_shared_not_client' => "Im Anwendungspool des Kunden ist keine Anwendung dieser Art vorhanden. Wenn Sie ein Upgrade der Anwendung auf die angegebene Version vornehmen möchten, sollten Sie diese Anwendungsversion zuerst zum Anwendungspool des Kunden hinzufügen.",
    'sapp__apply_license_script_not_found' => '"apply-license"-Skript für diese Webanwendung wurde nicht gefunden.',
    'sapp__unable_to_activate_key' => 'Bei der Aktivierung des Lizenzschlüssels ist ein Fehler aufgetreten: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Für einige installierte Webanwendungen ist diese Webanwendung im System erforderlich.',
    'sapp__unable_to_delete_ai_in_pool' => 'Diese Anwendung befindet sich noch im Anwendungspool eines Kunden. Wenn Sie diese Anwendung entfernen möchten, müssen Sie sie zuerst aus allen Kunden-Anwendungspools entfernen oder sie kostenlos zur Verfügung stellen.',
    'sapp__unable_to_delete_app_template' => 'Anwendung Nr. %1 kann nicht entfernt werden: %2',
    'sapp__limit_exceeded_client' => 'Die Grenze für die Anzahl der Installationen dieser Webanwendung wurde erreicht (%2).',


    // atis module

    '_week_on' => 'Woche am',
    '__week_first' => 'erster',
    '__week_second' => 'zweite',
    '__week_third' => 'dritte',
    '__week_fourth' => 'vierte',
    '__week_last' => 'letzter',
    '__not_started' => 'Wartet',
    '__started' => 'Wird ausgeführt',
    '__cancel_pending' => 'Wird abgebrochen',
    '__canceled' => 'Abgebrochen',
    '__error' => 'Fehler',
    '__done' => 'Fertig',

    '__php_cgi_handler' => 'CGI-Anwendung',
    '__php_isapi_handler' => 'ISAPI-Erweiterung',
    '__php_fastcgi_handler' => 'FastCGI-Anwendung',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'ausführen als',

    'cf_dbfolder_text' =>'Datenbankordner',
    'cf_isnewdb_text' => 'Datenbank erstellen',
    'cf_isnewdb_title' => 'Aktivieren Sie das Kontrollkästchen, wenn die Datenbank erstellt werden soll',

    'pb__site_apps_upgrade' => 'Webanwendungs-Upgrade',

    'detach' => 'Trennen',
    'preferences' => "Passwort ändern",

    'toolsbar__switch_user?' => "Möchten Sie sich wirklich unter einem anderen Benutzerkonto anmelden?",
    '__aps_left' => 'Anzahl verbleibende Installationen',
    'aps__license_key' => 'Lizenzschlüssel',
    'aps__download_code' => 'Lizenzschlüssel und Aktivierungscode herunterladen',
    'aps__license_key_hint' => 'Vom Lizenzserver mithilfe des Aktivierungscodes abrufen',
    'aps__database_not_available' => 'nicht verfügbar, bitte überprüfen Sie die Domain- oder Kundengrenzen',
    'aps__yes' => 'ja',
    'aps__no' => 'nein',
    '__click_to_enlarge' => 'Zum Vergrößern hier klicken',
    'site_apps__back_to_list' => 'Zurück zur Liste',
    'sapp__pkg_info_installation_requirements' => 'Installationsanforderungen',
    '__close_window' => 'Schließen',

    //SAPP END

    'skin_info__already_default' => 'Der Skin wird bereits als Standard-Skin verwendet.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus Einstellungen für %1',
    'drweb:properties_legend' => 'Einstellungen',
    'drweb:status' => 'E-Mail-Nachrichten werden auf Viren überprüft',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder Assistent',
    'dom_site_builder' => 'Anklicken, um den Presence Builder Assistenten zu öffnen.',
    'sb_plesk_admin_url' => 'Server-URL von Presence Builder. Stellen Sie sicher, dass diese Adresse im DNS ordnungsgemäß aufgelöst wird',
    'sb_plesk_admin_login' => 'Nutzername für die Anmeldung des Serveradministrators bei Presence Builder',
    'sb_plesk_admin_password' => 'Administratorpasswort',
    'sb_sitebuilder_preferences' => 'Administratorzugangsdaten für Presence Builder',
    'sb__server' => 'Einstellungen des Presence Builder Systemadministrators',
    'sb__sitebuilder_support' => 'Unterstützung von Presence Builder',
    'sb_keep_sb_user' => 'Entsprechendes Benutzerkonto in Presence Builder behalten',
    'sb_create_sb_user' => 'Entsprechendes Nutzerkonto in Presence Builder erstellen',
    'sb__build_site_using_sitebuilder' => "Eine Website mit Presence Builder erstellen",
    'sb_no_current_sb_server_set' => 'Die Verbindung zu Presence Builder ist noch nicht konfiguriert: Sie müssen einen A-Eintrag in das DNS-Zonen-Template hinzufügen, der auf den Presence Builder Server verweist.',
    'sb_unable_update_sb_server_sb_return_message' => "Die Informationen können nicht vom Presence Builder System abgefragt werden:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Verbindung zu Presence Builder nicht möglich: Nutzername oder Passwort falsch.",
    'sb_init_sb_manager' => "Initialisierung des Presence Builder Managers: %1",
    'sb_err_couldnt_connect_sb' => "Verbindung zum Presence Builder System fehlgeschlagen.",
    'sb_err_client_dont_have_sbuser' => "Dieser Kunde hat kein Benutzerkonto in Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder ist nicht konfiguriert.",
    'sb_err_you_dont_have_sbaccount' => "Autorisierung in Presence Builder fehlgeschlagen.",
    'sb_error_critical_during_operation' => "Folgender Fehler ist in Presence Builder aufgetreten:\n%1",
    'sb_err_sso_is_not_enabled' => "Die Single-Sign-On-Unterstützung ist nicht in Plesk eingeschaltet.",

    'warning__super_zone_exist' => "Zone %1 wurde erstellt, allerdings ist dieser Zonenname eine Subzone der bereits existierenden Zone %2, die einem anderen Benutzer gehört (%3). Dies ist zwar möglich, stellen Sie jedoch sicher, dass Sie das richtige Benutzerkonto ausgewählt haben.",
    'error__super_zone_exist' => "Erstellen der DNS-Zone nicht möglich, da ihre Superzone einem anderen Benutzer gehört.",

    'locales__files_not_exits' => 'Sprache kann nicht geändert werden: Die angegebenen Sprachpaketdateien existieren nicht im System.',
    'locales__unavailable' => 'Sprache kann nicht geändert werden: Das angegebene Sprachpaket ist nicht verfügbar.',

    // DB BU

    'pb__dbbackup_list' => 'Datenbank-Backupdateien',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Temporäres Netzwerkverzeichnis',
    'dbbackup__network_user' => 'Benutzername',
    'dbbackup__network_pass' => 'Passwort',
    // domain
    'dbbackup__add_database_legend' => 'Gesicherte Datenbank wiederherstellen',
    'dbbackup__add_database_restore' => 'Datenbank aus Backupdatei wiederherstellen',
    'dbbackup__add_database_file' => 'Datenbank-Backupdatei',
    'dbbackup__add_database_user' => 'Standard-Benutzername',
    'dbbackup__add_database_pass' => 'Standard-Benutzerpasswort',
    'dbbackup__add_database_pass2' => 'Bestätigung des Standard-Benutzerpassworts',

    'bt_dbbackup_now' => 'Backup erstellen',

    'bt_repair' => 'Reparieren',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Das Hochladen von SQL-Datenbankabbildern wird vom Hosting-Provider nicht zugelassen.',

    // APS categories

    'cf_invalid_password' => 'Passwort darf aus höchstens 16 Zeichen bestehen',
    'cf_invalid_description_length' => 'Beschreibung darf höchstens 256 Zeichen enthalten',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-Adresse %1 wird bereits von einem externen Mailserver verwendet',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP-Benutzername oder Passwort ist ungültig. Bitte geben Sie die korrekten FTP-Anmeldedaten ein.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Die Grenze für die Änderungen bei Seriennummern wurde erreicht. Heute können keine Änderungen mehr an der DNS-Zone vorgenommen werden.',
    'dns__zone_apply_changes' => 'An DNS-Einträgen vorgenommene Änderungen wurden noch nicht gespeichert. Die vorgenommenen Änderungen werden unten hervorgehoben. Klicken Sie auf "Aktualisieren", um die Änderungen an der DNS-Zone zu übernehmen, oder klicken Sie auf "Zurücksetzen", um die Änderungen zu verwerfen.',
    'dns__update_dns_zone' => 'Klicken Sie hier, um die Änderungen an den DNS-Einträgen zu speichern',
    'dns__revert_dns_zone' => 'Klicken Sie hier, um die Änderungen an den DNS-Einträgen zu verwerfen',
    'bt_revert' => 'Zurücksetzen',
    'dns__dns_zone_has_beed_updated' => 'An DNS-Einträgen vorgenommene Änderungen wurden gespeichert.',
    'dns__dns_zone_has_beed_reverted' => 'An DNS-Einträgen vorgenommene Änderungen wurden verworfen',
    'db__nondefault_server_not_allowed' => 'Verwendung von Nicht-Standarddatenbanken ist nicht zulässig',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Konto und Domains des Kunden %1.',
    'ui__client__disabled-warning' => 'Das Konto des Kunden %1 ist gesperrt.',
    'ui__client__none-available' => 'Es sind keine Kundenkonten konfiguriert.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Kunde %1',
    'ui__client_self__description' => 'Liste meiner Domains.',
    'ui__client_self__short-title' => 'Meine Domains',
    'ui__client_self__title' => 'Meine Domains',


    'site_apps__non_removable' => 'Elemente, die nicht entfernt werden können',
    'site_apps__non_removable_items' => 'Die folgenden Webanwendungen können nicht entfernt werden:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Es sind keine benutzerdefinierten Schaltflächen vorhanden.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Im Kunden-Panel des Kunden %1 existieren keine benutzerdefinierten Schaltflächen.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Entfernen Sie die Schaltfläche \'%1\'.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Entfernen',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Schaltfläche %1 entfernen',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Entfernen Sie die benutzerdefinierten Schaltflächen vom Kunden-Panel des Kunden',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Entfernen',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Schaltflächen entfernen',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Wählen Sie einen Kunden aus, dessen benutzerdefinierte Schaltflächen Sie entfernen möchten, und klicken Sie auf "Weiter >>".',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Wählen Sie die Schaltflächen aus, die Sie entfernen möchten und klicken Sie auf \'Weiter >>\'.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bestätigen Sie das Entfernen der Schaltflächen, indem Sie das Kontrollkästchen auf dieser Seite aktivieren, und klicken Sie auf \'Fertigstellen\'.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Entfernen Sie eine benutzerdefinierte Schaltfläche vom Kunden-Panel des Kunden.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Entfernen',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Benutzerdefinierte Schaltfläche entfernen',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Benutzerdefinierte Schaltfläche entfernen',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Wählen Sie einen Kunden aus, dessen benutzerdefinierte Schaltfläche Sie entfernen möchten, und klicken Sie auf "Weiter >>".',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Wählen Sie eine benutzerdefinierte Schaltfläche aus, die Sie entfernen wollen, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bestätigen Sie das Entfernen der benutzerdefinierten Schaltfläche, indem Sie das Kontrollkästchen auf dieser Seite aktivieren, und klicken Sie anschließend auf \'Fertigstellen\'.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Bearbeiten Sie die Eigenschaften der benutzerdefinierten Schaltfläche %1 auf Kundenebene.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Einstellungen',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Benutzerdefinierte Schaltfläche %1 des Kunden ändern',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Benutzerdefinierte Schaltfläche hinzufügen',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Wählen Sie einen Kunden aus, in dessen Kunden-Panel Sie eine benutzerdefinierte Schaltfläche erstellen wollen und klicken Sie auf Weiter >>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klicken Sie auf \'Fertigstellen\', um die Schaltfläche zu erstellen.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Ändern Sie die Eigenschaften einer benutzerdefinierten Schaltfläche im Kunden-Panel des Kunden.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschaften',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Eigenschaften einer Schaltfläche im Kunden-Panel des Kunden ändern',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Eigenschaften benutzerdefinierter Schaltflächen ändern',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Wählen Sie einen Kunden aus, dessen benutzerdefinierte Schaltflächen Sie ändern möchten, und klicken Sie auf "Weiter >>".',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Wählen Sie eine benutzerdefinierte Schaltfläche aus, die Sie ändern möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Wenn Sie die Eigenschaften der Schaltfläche bearbeitet haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Schaltfläche %1 für Ihre Kunden nicht verfügbar machen.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Für Ihre Kunden nicht verfügbar machen',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Schaltfläche %1 für Ihre Kunden nicht verfügbar machen',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Schaltfläche %1 für Kunden Ihres Kunden einblenden.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Für ihre Kunden verfügbar machen',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Schaltfläche %1 für Kunden Ihres Kunden einblenden.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Machen Sie eine benutzerdefinierte Schaltfläche für Ihre Kunden verfügbar oder heben Sie ihre Verfügbarkeit auf.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Verfügbar/nicht verfügbar für Ihre Kunden',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Benutzerdefinierte Schaltfläche für Ihre Kunden verfügbar bzw. nicht verfügbar machen',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Machen Sie eine benutzerdefinierte Schaltfläche für Ihre Kunden verfügbar oder heben Sie ihre Verfügbarkeit auf.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Wählen Sie einen Kunden aus, für dessen Benutzer Sie eine benutzerdefinierte Schaltfläche verfügbar machen möchten und klicken Sie auf \'Weiter >>\'.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Wählen Sie eine benutzerdefinierte Schaltfläche aus, die Sie für Ihre Kunden verfügbar bzw. nicht verfügbar machen möchten, und klicken Sie auf \'Weiter >>\'.',

    'ui__client/domain__description' => 'Domain %1 verwalten.',
    'ui__client/domain__disabled-warning' => 'Die Domain %1 ist gesperrt.',
    'ui__client/domain__none-available' => 'Sie haben keine Domains.',
    'ui__client/domain__none-available__1' => 'Das Konto von %1 hat keine Domains.',
    'ui__client/domain__none-available__2' => 'Das Konto von %1 hat keine Domains.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domain %1',
    'ui__client/domain_self__description' => 'Ihre Domain verwalten.',
    'ui__client/domain_self__disabled-warning' => 'Ihre Domain ist gesperrt.',
    'ui__client/domain_self__quick-search' => 'Meine Domains',
    'ui__client/domain_self__short-title' => 'Meine Domain',
    'ui__client/domain_self__title' => 'Meine Domain',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Im Kunden-Panel des Kunden sind keine benutzerdefinierten Schaltflächen platziert.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Der Kunde %1 hat keine benutzerdefinierten Schaltflächen im Kunden-Panel.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Für die Domain %1 sind keine benutzerdefinierten Schaltflächen vorhanden.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Entfernen Sie eine benutzerdefinierte Schaltfläche %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Benutzerdefinierte Schaltfläche %1 entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Entfernen Sie benutzerdefinierte Schaltflächen.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Wählen Sie den Kunden aus, aus dessen Domain-Administrations-Panel Sie die Schaltflächen entfernen möchten und klicken Sie auf Weiter >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Wählen Sie die Domain aus, aus deren Administrations-Panel Sie die Schaltflächen entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Wählen Sie die Schaltflächen aus, die Sie entfernen möchten und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Bestätigen Sie das Entfernen der Schaltflächen, indem Sie die entsprechenden Kontrollkästchen anklicken. Klicken Sie dann auf "Fertigstellen", um die Schaltflächen zu entfernen und den Assistenten zu beenden.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Entfernen Sie eine benutzerdefinierte Schaltfläche.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Benutzerdefinierte Schaltfläche entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Benutzerdefinierte Schaltfläche entfernen',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Wählen Sie den Kunden aus, aus dessen Domain-Administrations-Panel Sie die benutzerdefinierte Schaltfläche entfernen möchten und klicken Sie auf Weiter >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, aus deren Administrations-Panel Sie die Schaltfläche entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Wählen Sie die benutzerdefinierte Schaltfläche aus, die Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Bestätigen Sie das Entfernen der benutzerdefinierten Schaltfläche, indem Sie das Kontrollkästchen anklicken. Klicken Sie dann auf "Fertigstellen", um die Schaltfläche zu entfernen und den Assistenten zu beenden.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Eigenschaften der benutzerdefinierten Schaltfläche %1 ändern",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Eigenschaften",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Ändern Sie die Eigenschaften der benutzerdefinierten Schaltfläche %1 im Kunden-Panel.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Schaltfläche hinzufügen',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Wählen Sie den Kunden aus, in dessen Kunden-Panel Sie die Schaltfläche platzieren wollen und klicken Sie auf Weiter >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Wählen Sie das Abonnement aus, in dem Sie eine Schaltfläche ändern wollen und klicken Sie auf Weiter >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klicken Sie auf "Fertigstellen", um die Schaltfläche zu erstellen und den Assistenten zu beenden.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Ändern Sie die Eigenschaften einer Schaltfläche im Kunden-Panel.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschaften',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Eigenschaften einer Schaltfläche im Kunden-Panel ändern',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Schaltflächen-Eigenschaften ändern',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Wählen Sie eine benutzerdefinierte Schaltfläche aus, deren Einstellungen Sie ändern möchten, und klicken Sie auf 'Weiter>>'.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Wenn Sie die Eigenschaften der Schaltfläche geändert haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Schaltfläche %1 für die E-Mail-Benutzer in dieser Domain nicht verfügbar machen.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Nicht verfügbar für E-Mail-Benutzer',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Schaltfläche %1 für die E-Mail-Benutzer in dieser Domain nicht verfügbar machen',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Schaltfläche %1 für E-Mail-Benutzer in der Domain einblenden.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Für E-Mail-Benutzer in dieser Domain zugänglich',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Benutzerdefinierte Schaltfläche %1 für E-Mail-Benutzer in dieser Domain einblenden',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Benutzerdefinierte Schaltfläche für andere Benutzer verfügbar bzw. nicht verfügbar machen.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Verfügbar/nicht verfügbar für andere Benutzer',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Benutzerdefinierte Schaltfläche für E-Mail-Benutzer verfügbar bzw. nicht verfügbar machen',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Benutzerdefinierte Schaltfläche für andere Benutzer verfügbar bzw. nicht verfügbar machen',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Wählen Sie eine Domain aus, in der die Schaltfläche platziert werden soll, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Wählen Sie eine Schaltfläche aus, die Sie für andere Benutzer verfügbar bzw. nicht verfügbar machen möchten, und klicken Sie auf \'Weiter >>\'.',

    'ui__client/domain/delete__description' => 'Domain %1 entfernen.',
    'ui__client/domain/delete__short-title' => 'Entfernen',
    'ui__client/domain/delete__title' => 'Domain %1 entfernen',
    'ui__client/domain/delete_multi__description' => 'Domains entfernen.',

    'ui__client/domain/delete_multi__short-title' => 'Entfernen',
    'ui__client/domain/delete_multi__title' => 'Domains entfernen',
    'ui__client/domain/delete_multi__wizard-title' => 'Domains entfernen',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Wählen Sie die Domains aus, die Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Bestätigen Sie, dass Sie die Domains entfernen möchten, indem Sie das Kontrollkästchen auswählen. Klicken Sie anschließend auf "Fertigstellen", um die Domains zu entfernen und den Assistenten zu beenden.',
    'ui__client/domain/delete_unknown__description' => 'Domain entfernen.',
    'ui__client/domain/delete_unknown__short-title' => 'Entfernen',
    'ui__client/domain/delete_unknown__title' => 'Domain entfernen',
    'ui__client/domain/delete_unknown__wizard-title' => 'Domain entfernen',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Wählen Sie eine Domain aus, die Sie entfernen möchten, und klicken auf \'Weiter >>\'.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Bestätigen Sie das Entfernen der Domain, indem Sie das Kontrollkästchen aktivieren, und klicken Sie anschließend auf "Fertigstellen", um sie zu entfernen und den Assistenten zu beenden.',

    'ui__client/domain/hosting__none-available' => 'Es sind keine Domains mit konfiguriertem Webhosting vorhanden. Erstellen Sie eine Domain und konfigurieren Sie Webhosting für die Domain, um diese Funktion zu nutzen.',
    'ui__client/domain/hosting__none-available__1' => 'Dieses Benutzerkonto enthält keine Domains mit konfiguriertem Webhosting. Konfigurieren Sie Webhosting für die gewünschte Domain, um diese Funktion zu nutzen.',
    'ui__client/domain/hosting__none-available__2' => 'Webhosting ist für Domain %1 nicht konfiguriert. Konfigurieren Sie Webhosting auf Domain %1, um diese Funktion zu nutzen.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Kunden",
    'ui__client/domain/hosting/application#list_header__description__title' => "Beschreibung",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Elemente",
    'ui__client/domain/hosting/application#list_header__name__title' => "Name",
    'ui__client/domain/hosting/application#list_header__release__title' => "Release",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Kunden sortieren.",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Nach Beschreibung sortieren",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Nach Elementen sortieren",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Nach Name sortieren",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Nach Freigabe sortieren",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Nach Versionen sortieren",
    'ui__client/domain/hosting/application#list_header__title' => "Webanwendungen",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versionen",

    'rpt_reseller_section_general' => 'Allgemein',
    'rpt_reseller_section_domains' => 'Domains',
    'rpt_reseller_section_clients' => 'Kunden',
    'statistics__cl_active_domains' => "Aktive Domains",
    'rpt_reseller_cl_domains' => "Domains",
    'rpt_reseller_cl_subdomains' => "Subdomains",
    'by__cl_domains' => "Domains des Kunden",
    'dom_ctrl__cl_mboxes' => "E-Mail-Postfächer",
    'rpt_reseller_cl_redirects' => "Weiterleitungen",
    'rpt_reseller_cl_mail_groups' => "Mailgruppen",
    'rpt_reseller_cl_mail_resps' => "Autoresponder",
    'rpt_reseller_cl_mail_lists' => "Mailinglisten",
    'rpt_reseller_cl_web_users' => "Webbenutzer",
    'rpt_reseller_cl_data_bases' => "Datenbanken",

    'statistics__active_clients' => 'Kunden mit aktiven Abonnements',
    'statistics__clients_active_domains' => 'Aktive Domains',
    'statistics__clients_doms' => 'Domains',
    'statistics__cl_doms' => 'Domains',
    '__clients_subdomains' => 'Subdomains',
    '__clients_domains' => 'Domains',
    'dom_ctrl__clients_mboxes' => 'E-Mail-Postfächer',
    'dom_ctrl__clients_redir' => 'Weiterleitungen',
    'dom_ctrl__clients_mg' => 'Mailgruppen',
    'dom_ctrl__clients_resp' => 'Autoresponder',
    'dom_ctrl__clients_maillists' => 'Mailinglisten',
    'dom_ctrl__clients_wu' => 'Webbenutzer',
    'dom_ctrl__clients_db' => 'Datenbanken',

    'dom_ctrl__cl_redir' => 'Weiterleitungen', // to resolve!
    'dom_ctrl__cl_mg' => 'Mailgruppen', // to resolve!
    'dom_ctrl__cl_resp' => 'Autoresponder', // to resolve!
    'dom_ctrl__cl_maillists' => 'Mailinglisten', // to resolve!
    'dom_ctrl__cl_wu' => 'Webbenutzer', // to resolve!
    'dom_ctrl__cl_db' => 'Datenbanken', // to resolve!

    'rpt_cl_section_clients' => 'Kunden',

    'rpt_admin_section_general' => 'Allgemein',
    'rpt_admin_section_resellers' => 'Reseller',
    'rpt_admin_section_clients' => 'Kunden',
    'rpt_admin_section_personal_clients' => 'Eigene Kunden',
    'rpt_admin_section_domains' => 'Domains',
    'rpt_admin_section_personal_domains' => 'Persönliche Domains',

    'rpt_reseller_section_personal_domains' => 'Persönliche Domains',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, die Sie sperren oder aktivieren wollen.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Domain sperren oder aktivieren',

    'ui__client/ip-pool__description' => 'IP-Adressen und SSL/TLS-Zertifikate dem Kunden %1 zuweisen und entfernen',
    'ui__client/ip-pool__short-title' => 'IP-Pool',
    'ui__client/ip-pool__title' => 'IP-Pool des Kunden %1',
    'ui__client/ip-pool_self__description' => 'Ihren IP-Pool anzeigen.',
    'ui__client/ip-pool_self__short-title' => 'IP-Pool',
    'ui__client/ip-pool_self__title' => 'Mein IP-Pool',
    'ui__client/ip-pool/properties__description' => 'IP-Pool für Kunde %1 einrichten.',

    'ui__client/ip-pool/properties__short-title' => 'IP-Pool',
    'ui__client/ip-pool/properties__title' => 'IP-Pool für Kunde %1 einrichten',
    'ui__client/ip-pool/properties_self__description' => 'Ihren IP-Pool anzeigen.',

    'ui__client/ip-pool/properties_self__short-title' => 'Mein IP-Pool',
    'ui__client/ip-pool/properties_self__title' => 'Mein IP-Pool',
    'ui__client/ip-pool/properties_unknown__description' => 'IP-Adressen und SSL/TLS-Zertifikate zuweisen oder vom Kunden entfernen',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP-Pool',
    'ui__client/ip-pool/properties_unknown__title' => 'Einrichten des IP-Pools des Kunden',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Einrichten des IP-Pools des Kunden',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Wählen Sie den Kunden, dessen IP-Pool Sie konfigurieren wollen.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Wenn Sie den IP-Pool konfiguriert haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',


    'ui__client/limits_readonly-unknown__description' => 'Ressourcengrenzen für einen Kunden anzeigen.',
    'ui__client/limits_readonly-unknown__short-title' => 'Ressourcengrenzen',
    'ui__client/limits_readonly-unknown__title' => 'Ressourcengrenzen für ein Kundenkonto anzeigen.',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Ressourcengrenzen für einen Kunden anzeigen und ändern.',

    'ui__client/limits_unknown__wizard-title' => 'Ressourcengrenzen für einen Kunden anzeigen und ändern.',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Wählen Sie den gewünschten Kunden aus.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Wählen Sie den gewünschten Kunden aus.',
    'ui__client/limits_unknown__wizard__2' => 'Um die Änderungen zu übernehmen, klicken Sie auf \'Fertigstellen\'.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',

    'ui__client/permissions_unknown__wizard-title' => 'Berechtigungen eines Kunden anzeigen oder ändern',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Wenn Sie Ihre Berechtigungen angezeigt haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Wählen Sie den Kunden aus, dessen Berechtigungen Sie anzeigen oder bearbeiten möchten.',
    'ui__client/permissions_unknown__wizard__2' => 'Wenn Sie die Berechtigungen des Kunden geändert haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu verlassen.',

    'ui__client/preferences_unknown__wizard-title' => 'Kundeneinstellungen bearbeiten',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Wählen Sie den Kunden aus, dessen Sitzungs- und Oberflächeneinstellungen Sie verwalten möchten.',
    'ui__client/preferences_unknown__wizard__2' => 'Wenn Sie die Einstellungen des Kunden geändert haben, klicken Sie auf Fertigstellen.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Wenn Sie Ihre Einstellungen bearbeitet haben, klicken Sie auf Fertigstellen.',

    'ui__custom-buttons/custom-button__none-available' => 'Sie haben keine benutzerdefinierten Schaltflächen.',
    'ui__custom-buttons/custom-button/delete__description' => 'Entfernen Sie eine benutzerdefinierte Schaltfläche %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Entfernen',
    'ui__custom-buttons/custom-button/delete__title' => 'Benutzerdefinierte Schaltfläche %1 entfernen',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Entfernen Sie benutzerdefinierte Schaltflächen.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Entfernen',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Wählen Sie die Schaltflächen aus, die Sie entfernen möchten.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Bestätigen Sie das Entfernen der Schaltflächen, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Entfernen Sie benutzerdefinierte Schaltflächen.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Entfernen',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Wählen Sie die benutzerdefinierte Schaltfläche aus, die Sie entfernen möchten.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Bestätigen Sie das Entfernen der Schaltfläche, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__custom-buttons/custom-button/properties__description' => 'Eigenschaften von Schaltfläche "%1" ändern.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Eigenschaften',
    'ui__custom-buttons/custom-button/properties__title' => 'Eigenschaften von Schaltfläche "%1" ändern',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Schaltfläche erstellen',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klicken Sie auf \'Fertigstellen\', um die Schaltfläche zu erstellen.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Ändern Sie die Eigenschaften einer benutzerdefinierten Schaltfläche.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschaften',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Eigenschaften einer benutzerdefinierten Schaltfläche ändern',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Eigenschaften einer benutzerdefinierten Schaltfläche ändern',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Wählen Sie die benutzerdefinierte Schaltfläche aus, deren Eigenschaften Sie bearbeiten möchten.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Um die Änderungen zu übernehmen, klicken Sie auf \'Fertigstellen\'.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Benutzerdefinierte Schaltfläche %1 für andere Benutzer nicht verfügbar machen.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Für andere Benutzer nicht verfügbar',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Benutzerdefinierte Schaltfläche %1 für andere Benutzer nicht verfügbar machen',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Benutzerdefinierte Schaltfläche %1 für andere Benutzer verfügbar machen.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Für andere Benutzer verfügbar',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Benutzerdefinierte Schaltfläche %1 für andere Benutzer verfügbar machen',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Benutzerdefinierte Schaltfläche für andere Benutzer verfügbar bzw. nicht verfügbar machen.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Verfügbar/nicht verfügbar für andere Benutzer',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Benutzerdefinierte Schaltfläche für andere Benutzer verfügbar bzw. nicht verfügbar machen',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Benutzerdefinierte Schaltfläche für andere Benutzer verfügbar bzw. nicht verfügbar machen',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Wählen Sie die benutzerdefinierte Schaltfläche aus, die Sie für andere Benutzer verfügbar bzw. nicht verfügbar machen möchten, und klicken Sie auf \'Weiter >>\'.',

    'ui__longtasks#list_header__name__title' => "Name",
    'ui__longtasks#list_header__owner__title' => "Inhaber",
    'ui__longtasks#list_header__start_time__title' => "Erstellungszeit",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Aufgaben",
    'ui__longtasks#list_header__finish_time__title' => "Abschlusszeit",
    'ui__longtasks#task_list_legend__title' => "Aufgaben",
    'ui__longtasks#tools_legend__title' => "Tools",
    'ui__longtasks__description' => "Hintergrundaufgaben verwalten",
    'ui__longtasks__short-title' => "Hintergrundaufgaben",
    'ui__longtasks__title' => "Hintergrundaufgaben",
    'ui__longtasks/longtask/properties#current_operation__title' => "Aktueller Vorgang:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Geschätzte Dauer:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Allgemein",
    'ui__longtasks/longtask/properties#owner__title' => "Aufgabe gestartet von:",
    'ui__longtasks/longtask/properties#progress__title' => "Gesamtfortschritt:",
    'ui__longtasks/longtask/properties#start_time__title' => "Aufgabe gestartet:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Aufgabenstatus",
    'ui__longtasks/longtask/properties__description' => "Hintergrundaufgaben-Status und -Informationen",

    'ui__longtasks/properties__description' => "Einstellungen für Hintergrundaufgaben",
    'ui__longtasks/properties__short-title' => "Einstellungen",
    'ui__longtasks/properties__title' => "Hintergrundaufgaben",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Massen-E-Mail-Templates',
    'ui__mass-mail/template#list_header__name__title' => 'Template-Name',
    'ui__mass-mail/template#list_header__from_email__title' => 'Absender',
    'ui__mass-mail/template#list_header__to__title' => 'Empfänger',
    'ui__mass-mail/template#list_header__subject__title' => 'Betreff',
    'ui__mass-mail/template#list_header__cdate__title' => 'Erstellungsdatum',
    'ui__mass-mail/template#list_header__send__title' => 'Senden',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Massen-E-Mail-Template bearbeiten',
    'ui__mass-mail/template/properties__description' => 'Bearbeiten Sie dieses Massen-E-Mail-Template.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Massen-E-Mail-Template hinzufügen',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Massen-E-Mail-Template hinzufügen',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Fügen Sie ein Massen-E-Mail-Template hinzu.',
    'ui__mass-mail/send__short-title' => 'Massen-E-Mail senden',
    'ui__mass-mail/send__title' => 'Massen-E-Mail-Nachricht senden',
    'ui__mass-mail/send__description' => 'Senden Sie eine Massen-E-Mail an die ausgewählten Empfänger.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Massen-E-Mail-Templates entfernen',
    'ui__mass-mail/template/delete_multi__title' => 'Diese Massen-E-Mail-Templates entfernen:',
    'ui__mass-mail/template/delete_multi__description' => 'Entfernen Sie die ausgewählten Massen-E-Mail-Templates.',
    'ui__mass-mail/template/delete_multi__done' => 'Die ausgewählten Nachrichten-Templates wurden entfernt.',
    'ui__mass-mail/template/properties__invalid_values' => 'Ungültige Werte angegeben',


    // old
    'ui__mass-mail#body_text__description' => 'Sie können die Variable <name> im Text der Nachricht verwenden (jedoch nicht im Header). Sie wird dann durch den Namen des Kunden- oder Reseller-Kontakts ersetzt.',
    'ui__mass-mail#body_text__title' => 'Nachrichtentext',
    'ui__mass-mail#compose_legend__title' => 'Nachricht',
    'ui__mass-mail#from_email_text__title' => 'Von (E-Mail-Adresse)',
    'ui__mass-mail#list_header__cdate__title' => 'Erstellt',
    'ui__mass-mail#list_header__from_email__title' => 'Ab',
    'ui__mass-mail#list_header__name__title' => 'Name',
    'ui__mass-mail#list_header__send__title' => 'Nachricht erstellen',
    'ui__mass-mail#list_header__subject__title' => 'Betreff',
    'ui__mass-mail#list_header__title' => 'Massen-E-Mail-Templates',
    'ui__mass-mail#list_header__to__title' => 'An',
    'ui__mass-mail#list_legend__title' => 'Massen-E-Mail-Templates',
    'ui__mass-mail#load_template_text__title' => 'Laden',
    'ui__mass-mail#name_text__title' => 'Template-Name',
    'ui__mass-mail#option_mode_all__title' => 'Alle',
    'ui__mass-mail#option_mode_except__title' => 'Alle außer den ausgewählten',
    'ui__mass-mail#option_mode_select__title' => 'Nur ausgewählte',
    'ui__mass-mail#option_select_template__title' => '---Template auswählen---',
    'ui__mass-mail#picker_legend__title' => 'E-Mail-Templates',
    'ui__mass-mail#picker_title__title' => 'Template auswählen',
    'ui__mass-mail#save_as_legend__title' => 'Als Template speichern',
    'ui__mass-mail#save_as_text__title' => 'Verfasste Nachricht speichern als neues Template mit dem Namen',
    'ui__mass-mail#subject_text__title' => 'Betreff',
    'ui__mass-mail#template_legend__title' => 'Vorlage',
    'ui__mass-mail#to_admin_text__title' => 'Plesk Administrator',
    'ui__mass-mail#to_clients_text__title' => 'Kunden',
    'ui__mass-mail#to_domains_text__title' => 'Domainadministratoren',
    'ui__mass-mail#to_select_text__title' => 'Adressen auswählen',
    'ui__mass-mail#to_show_hide_text__title' => 'Ausgewählte ein-/ausblenden',
    'ui__mass-mail#to_text__title' => 'An',
    'ui__mass-mail#tools_legend__title' => 'Tools',
    'ui__mass-mail__already_exists' => 'Template mit Name "%1" existiert bereits',
    'ui__mass-mail__none-available' => 'Sie haben keine Nachrichten-Templates.',

    'ui__mass-mail/delete__description' => 'Massen-E-Mail-Template %1 entfernen',

    'ui__mass-mail/delete__empty_selection' => 'Wählen Sie die Templates aus, die Sie entfernen möchten',
    'ui__mass-mail/delete__short-title' => '%1 entfernen',
    'ui__mass-mail/delete__title' => 'Massen-E-Mail-Template %1 entfernen',
    'ui__mass-mail/delete_multi__description' => 'Entfernen Sie Massen-E-Mail-Templates.',

    'ui__mass-mail/delete_multi__short-title' => 'Entfernen',
    'ui__mass-mail/delete_multi__title' => 'Massen-E-Mail-Templates entfernen',
    'ui__mass-mail/delete_multi__wizard-title' => 'Entfernen der Massen-E-Mail-Templates',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Wählen Sie die Massen-E-Mail-Templates aus, die Sie entfernen möchten.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Bestätigen Sie das Entfernen der Templates, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__mass-mail/delete_unknown__description' => 'Entfernen Sie Massen-E-Mail-Templates.',
    'ui__mass-mail/delete_unknown__short-title' => 'Entfernen',
    'ui__mass-mail/delete_unknown__title' => 'Massen-E-Mail-Templates entfernen',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Entfernen der Massen-E-Mail-Templates.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Wählen Sie das Massen-E-Mail-Template aus, das Sie entfernen möchten.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Bestätigen Sie das Entfernen des Templates, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',

    'ui__mass-mail/properties__description' => 'Bearbeiten Sie das E-Mail-Template %1.',

    'ui__mass-mail/properties__invalid_values' => 'Die eingegebenen Werte sind ungültig',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'E-Mail-Template %1 bearbeiten',

    'ui__mass-mail/properties_new__wizard-title' => 'Massen-E-Mail-Template erstellen',
    'ui__mass-mail/properties_unknown-new__description' => 'Erstellen Sie ein E-Mail-Template.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'E-Mail-Template hinzufügen',
    'ui__mass-mail/properties_unknown-new__title' => 'E-Mail-Template erstellen',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Massen-E-Mail-Template bearbeiten',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Wählen Sie das Template aus, das Sie ändern möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Wenn Sie das Template bearbeitet haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',

    'ui__mass-mail/send__invalid_values' => 'Sie haben ungültige Werte eingegeben',

    'ui__mass-mail/send_new__wizard-title' => 'Nachrichten-Template erstellen und E-Mail versenden',
    'ui__mass-mail/send_unknown-new__description' => 'E-Mail an die ausgewählten Empfänger senden',

    'ui__mass-mail/send_unknown-new__short-title' => 'Massen-E-Mail senden',
    'ui__mass-mail/send_unknown-new__title' => 'Massen-E-Mail-Nachricht senden',
    'ui__mass-mail/send_unknown__description' => 'E-Mail an die ausgewählten Empfänger senden',

    'ui__mass-mail/send_unknown__short-title' => 'Massen-E-Mail senden',
    'ui__mass-mail/send_unknown__title' => 'Massen-E-Mail-Nachricht senden',
    'ui__mass-mail/send_unknown__wizard-title' => 'Massen-E-Mail-Nachricht senden',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Wählen Sie das gewünschte Template aus und klicken Sie auf \'Weiter >>\'.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Wenn Sie die Eigenschaften des Templates bearbeitet haben, klicken Sie auf "Fertigstellen", um die Nachricht zu senden und den Assistenten zu beenden.',

    'ui__mass-email/delete__description' => 'Entfernen Sie die ausgewählten Massen-E-Mail-Templates.',

    'ui__mass-email/delete__empty_selection' => "Wählen Sie die Templates aus, die entfernt werden sollen.",
    'ui__mass-email/delete__short-title' => "%1 entfernen",
    'ui__mass-email/delete__title' => "Massen-E-Mail-Template %1 entfernen",
    'ui__mass-email/delete_multi__description' => "Entfernen Sie Massen-E-Mail-Templates.",

    'ui__mass-email/delete_multi__short-title' => "Entfernen",
    'ui__mass-email/delete_multi__title' => "Massen-E-Mail-Templates entfernen",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Bestätigen Sie das Entfernen der Templates, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf 'Fertigstellen', um den Assistenten zu beenden.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Wählen Sie die Massen-E-Mail-Templates aus, die Sie entfernen möchten.",
    'ui__mass-email/delete_multi__wizard-title' => "Entfernen der Massen-E-Mail-Templates",
    'ui__mass-email/delete_unknown__description' => "Entfernen Sie Massen-E-Mail-Templates.",
    'ui__mass-email/delete_unknown__short-title' => "Entfernen",
    'ui__mass-email/delete_unknown__title' => "Massen-E-Mail-Templates entfernen",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Bestätigen Sie das Entfernen des Templates, indem Sie das Kontrollkästchen aktivieren, und klicken Sie auf 'Fertigstellen', um den Assistenten zu beenden.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Wählen Sie das Massen-E-Mail-Template aus, das Sie entfernen möchten.",
    'ui__mass-email/delete_unknown__wizard-title' => "Entfernen der Massen-E-Mail-Templates.",
    'ui__mass-email/send__description' => "E-Mail an die ausgewählten Empfänger senden",
    'ui__mass-email/send__short-title' => "Massen-E-Mail senden",
    'ui__mass-email/send__title' => "Massen-E-Mail-Nachricht senden",
    'ui__mass-email/send_main__description' => "E-Mail an die ausgewählten Empfänger senden",

    'ui__mass-email/send_main__short-title' => "Massen-E-Mail senden",
    'ui__mass-email/send_main__title' => "Massen-E-Mail-Nachricht senden",
    'ui__mass-email/send_selectresellers__title' => 'Reseller auswählen',
    'ui__mass-email/send_selectresellers__short-title' => 'Reseller',
    'ui__mass-email/send_selectresellers__description' => 'Reseller-Konten auswählen',

    'ui__mass-email/send_selectclients__description' => "Kundenkonten auswählen",

    'ui__mass-email/send_selectclients__short-title' => "Kunden",
    'ui__mass-email/send_selectclients__title' => "Kunden auswählen",
    'ui__mass-email/send_selectdomainusers__description' => "Domainadministratorkonten auswählen",

    'ui__mass-email/send_selectdomainusers__short-title' => "Domainadministratoren",
    'ui__mass-email/send_selectdomainusers__title' => "Domainadministratoren auswählen",
    'ui__mass-email/template/properties_main__description' => "Massen-E-Mail-Template erstellen",
    'ui__mass-email/template/properties_main__short-title' => "Template bearbeiten",
    'ui__mass-email/template/properties_main__title' => "Massen-E-Mail-Template bearbeiten",
    'ui__mass-email/template/properties_new-main__description' => "Erstellen Sie ein Template für Massen-E-Mail-Nachrichten.",
    'ui__mass-email/template/properties_new-main__short-title' => "Massen-E-Mail-Template erstellen",
    'ui__mass-email/template/properties_new-main__title' => "Massen-E-Mail-Template erstellen",
    'ui__mass-email/template/properties_new-selectclients__description' => "Wählen Sie die Kunden aus, die auf diesem Template basierende Massen-E-Mails erhalten sollen",
    'ui__mass-email/template/properties_new-selectclients__title' => "Wählen Sie die Kunden aus, die auf diesem Template basierende Massen-E-Mails erhalten sollen",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Wählen Sie die Domainadministratoren aus, die auf diesem Template basierende Massen-E-Mails erhalten sollen.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Wählen Sie die Domainadministratoren aus, die auf diesem Template basierende Massen-E-Mails erhalten sollen.",
    'ui__mass-email/template/properties_selectclients__title' => "Wählen Sie die Kunden aus, die auf diesem Template basierende Massen-E-Mails erhalten sollen",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Wählen Sie die Domainadministratoren aus, die auf diesem Template basierende Massen-E-Mails erhalten sollen.",

    'ui__mass-email/template/properties_unknown-new__description' => "Erstellen Sie ein Massen-E-Mail-Template",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Template erstellen",
    'ui__mass-email/template/properties_unknown-new__title' => "Erstellung von Massen-E-Mail-Template",
    'ui__news/dismiss__description' => 'Klicken Sie hier, um den News-Frame zu schließen. Plesk wird diesen Frame nicht anzeigen bis die News-Artikel aktualisiert wurden.',

    'ui__news/dismiss__title' => 'News schließen',

    'ui__server__description' => 'Serververwaltung.',
    'ui__server__short-title' => 'Ihren Server verwalten',
    'ui__server__title' => 'Serververwaltung',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP-Adresse %1 ist nicht verfügbar.',
    'ui__server/ip-address__none-available' => 'Es sind keine IP-Adressen vorhanden.',
    'ui__server/ip-addresses/ip-address__title' => "IP-Adressen",
    'ui__server/ip-address/client/properties_new__description' => "IP-Adresse %1 den Resellern zuweisen",
    'ui__server/ip-address/client/properties_new__short-title' => 'Zuweisen',
    'ui__server/ip-address/client/properties_new__title' => "IP-Adresse %1 den Resellern zuweisen",
    'ui__server/ip-address/client__none-available' => 'Keine Benutzerkonten vorhanden',
    'ui__server/ip-address/client_unknown__quick_search' => 'Benutzer',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Liste der Benutzer, die diese IP-Adresse verwenden.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Bitte wählen Sie die IP-Adresse aus.',
    'ui__server/ip-address/client/delete__description' => 'Zuweisung einer IP-Adresse von dem Reseller aufheben.',
    'ui__server/ip-address/client/delete__short-title' => 'Zuweisung aufheben',
    'ui__server/ip-address/client/delete__title' => 'Zuweisung einer IP-Adresse von dem Reseller aufheben',
    'ui__server/ip-address/client/delete_multi__description' => "Zuweisung der IP-Adresse von den Reseller-Pools aufheben.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Zuweisung aufheben',
    'ui__server/ip-address/client/delete_multi__title' => 'Zuweisung einer IP-Adresse von einem Reseller aufheben.',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "IP-Adresse aus Benutzer-Pools entfernen.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Wählen Sie die IP-Adresse aus, deren Zuweisung zu Benutzern Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Wählen Sie die Benutzer aus, für die Sie die Zuweisung der IP-Adresse entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Bestätigen Sie das Entfernen der IP-Adresse aus den Benutzer-IP-Pools, indem Sie das Kontrollkästchen aktivieren. Klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Zuweisung einer IP-Adresse von Resellern aufheben.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Zuweisung aufheben',
    'ui__server/ip-address/client/delete_unknown__title' => 'Zuweisung einer IP-Adresse von Resellern aufheben',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Zuweisung einer IP-Adresse zu Benutzern aufheben',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Wählen Sie die IP-Adresse aus, deren Zuweisung zu Benutzern Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Wählen Sie den Benutzer aus, für den Sie die Zuweisung der IP-Adresse entfernen möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Bestätigen Sie das Entfernen der IP-Adresse aus den Benutzer-IP-Pools, indem Sie das Kontrollkästchen aktivieren. Klicken Sie auf \'Fertigstellen\', um den Assistenten zu beenden.',

    'ui__server/ip-address/domain__description' => "Alle Domains auf IP-Adresse %1.",
    'ui__server/ip-address/domain__short-title' => "Domains",
    'ui__server/ip-address/domain__title' => "Domains auf IP-Adresse %1",
    'ui__server/ip-address/domain_unknown__description' => "Alle Domains auf der IP-Adresse.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domains",
    'ui__server/ip-address/domain_unknown__title' => "Domains auf der IP-Adresse",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Wählen Sie die gewünschte IP-Adresse aus und klicken Sie auf 'Weiter >>'.",

    'ui__server/ip-address/properties__description' => 'Eigenschaften von IP-Adresse %1 ändern.',
    'ui__server/ip-address/properties__short-title' => 'Eigenschaften',
    'ui__server/ip-address/properties__title' => 'Eigenschaften von IP-Adresse %1 ändern',

    'ui__server/ip-address/properties_new__wizard-title' => 'IP-Adresse hinzufügen',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Wenn Sie die Eigenschaften der IP-Adresse geändert haben, klicken Sie auf \'Fertigstellen\'',
    'ui__server/ip-address/properties_unknown__description' => 'Eigenschaften der IP-Adresse ändern.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Eigenschaften',
    'ui__server/ip-address/properties_unknown__title' => 'Eigenschaften der IP-Adresse ändern',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Eigenschaften der IP-Adresse ändern',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Wählen Sie die IP-Adresse aus, deren Eigenschaften Sie ändern möchten.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Wenn Sie die Eigenschaften der IP-Adresse geändert haben, klicken Sie auf \'Fertigstellen\'',

    'ui__server/spam-filter/black-list__description' => 'Blacklist für serverweiten Spamfilter einrichten.',
    'ui__server/spam-filter/black-list__short-title' => 'Schwarze Liste',
    'ui__server/spam-filter/black-list__title' => 'Blacklist für serverweiten Spamfilter',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Nur die ersten %1 eindeutigen E-Mail-Adressen werden hinzugefügt.',
    'ui__server/spam-filter/black-list/address__description' => 'Blacklist-Adresse des Spamfilters.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Es befinden sich keine E-Mail-Adressen in der Liste.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Die hochgeladene Datei ist leer.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Die folgenden E-Mail-Adressen sind ungültig: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Es befinden sich keine Adressen in der Spamfilter-Blacklist.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/black-list/address__title' => 'Adresse %1 zur Blacklist hinzufügen',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Fügen Sie Adressen zur Blacklist hinzu.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Adressen hinzufügen',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Adressen zur Blacklist hinzufügen',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Adresse %1 aus der serverweiten Blacklist entfernen.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Entfernen',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Adresse %1 aus der serverweiten Blacklist entfernen',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Adressen aus der serverweiten Blacklist entfernen.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Entfernen',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Adressen aus der serverweiten Blacklist entfernen',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Entfernen von Adressen aus der serverweiten Spamfilter-Blacklist',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Wählen Sie die Spamfilteradressen aus, die Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Bestätigen Sie das Entfernen der Spamfilteradressen, indem Sie das Kontrollkästchen auswählen, und klicken Sie auf "Fertigstellen", um sie vollständig zu entfernen und den Assistenten zu beenden.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Adresse aus der serverweiten Blacklist entfernen.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Entfernen',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Adresse aus der serverweiten Blacklist entfernen',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Entfernen von Adressen aus der serverweiten Spamfilter-Blacklist',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Wählen Sie die Spamfilteradresse aus, die Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Bestätigen Sie das Entfernen der Spamfilteradresse, indem Sie das Kontrollkästchen auswählen, und klicken Sie auf "Fertigstellen", um die IP-Adresse vollständig zu entfernen und den Assistenten zu beenden.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Nur die ersten %1 eindeutigen E-Mail-Adressen werden hinzugefügt.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Es befinden sich keine E-Mail-Adressen in der Liste.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Die Datei kann nicht hochgeladen werden. Die Größe einer Datei für den Upload darf maximal %1 betragen.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Die folgenden E-Mail-Adressen sind ungültig: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Fügen Sie Adressen zur Blacklist hinzu.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Adressen hinzufügen',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Adressen zur Blacklist hinzufügen',

    'ui__server/spam-filter/properties__description' => 'Serverweiten Spamfilter einrichten.',

    'ui__server/spam-filter/properties__short-title' => 'Einstellungen',
    'ui__server/spam-filter/properties__title' => 'Spamfilter-Einstellungen',

    'ui__server/spam-filter/toggle_disable__description' => 'Spamfilter für das gesamte System deaktivieren.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Deaktivieren',
    'ui__server/spam-filter/toggle_disable__title' => 'Spamfilterung deaktivieren',
    'ui__server/spam-filter/toggle_enable__description' => 'Spamfilter für den gesamten Server aktivieren.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Aktivieren',
    'ui__server/spam-filter/toggle_enable__title' => 'Spamfilter aktivieren',
    'ui__server/spam-filter/toggle_unknown__description' => 'Spamfilter für den gesamten Server aktivieren bzw. deaktivieren.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Aktivieren bzw. deaktivieren',
    'ui__server/spam-filter/toggle_unknown__title' => 'Spamfilter aktivieren bzw. deaktivieren',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Spamfilter aktivieren bzw. deaktivieren',

    'ui__server/spam-filter/white-list__description' => 'Systemweite Spamfilter-Whitelist einrichten.',
    'ui__server/spam-filter/white-list__short-title' => 'Whitelist',
    'ui__server/spam-filter/white-list__title' => 'Systemweite Spamfilter-Whitelist',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Nur die ersten %1 eindeutigen E-Mail-Adressen werden hinzugefügt.',
    'ui__server/spam-filter/white-list/address__description' => 'Whitelist-Adresse des Spamfilters.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Es befinden sich keine E-Mail-Adressen in der Liste.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Die hochgeladene Datei ist leer.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Die folgenden E-Mail-Adressen sind ungültig: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Es befinden sich keine Adressen in der serverweiten Spamfilter-Whitelist.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/white-list/address__title' => 'Whitelist-Adresse %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Fügen Sie Adressen zur Whitelist hinzu.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Adressen hinzufügen',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Adressen zur Whitelist hinzufügen',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Adresse %1 aus der serverweiten Whitelist entfernen.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Entfernen',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Adresse %1 aus der serverweiten Whitelist entfernen',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Adressen aus der serverweiten Whitelist entfernen.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Entfernen',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Adressen aus der serverweiten Whitelist entfernen',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Entfernen von Adressen aus der serverweiten Spamfilter-Whitelist',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Wählen Sie die Spamfilteradressen aus, die Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Bestätigen Sie das Entfernen der Spamfilteradressen, indem Sie das Kontrollkästchen auswählen, und klicken Sie auf "Fertigstellen", um sie vollständig zu entfernen und den Assistenten zu beenden.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Adresse aus der serverweiten Whitelist entfernen.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Entfernen',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Adresse aus der serverweiten Whitelist entfernen',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Entfernen von Adressen aus der serverweiten Spamfilter-Whitelist',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Wählen Sie die Spamfilteradresse aus, die Sie entfernen möchten, und klicken Sie auf \'Weiter >>\'',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Bestätigen Sie das Entfernen der Spamfilteradresse, indem Sie das Kontrollkästchen auswählen, und klicken Sie auf "Fertigstellen", um die IP-Adresse vollständig zu entfernen und den Assistenten zu beenden.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Nur die ersten %1 eindeutigen E-Mail-Adressen werden hinzugefügt.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Es befinden sich keine E-Mail-Adressen in der Liste.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Die Datei kann nicht hochgeladen werden. Die Größe einer Datei für den Upload darf maximal %1 betragen.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Die folgenden E-Mail-Adressen sind ungültig: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Fügen Sie Adressen zur Whitelist hinzu.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Adressen hinzufügen',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Adressen zur Whitelist hinzufügen',

    'ui__server/mail/statistics#apply__description' => "Filter anwenden",
    'ui__server/mail/statistics#apply__title' => "Übernehmen",
    'ui__server/mail/statistics#custom_from__title' => "von",
    'ui__server/mail/statistics#custom_to__title' => "an",
    'ui__server/mail/statistics#period_all__title' => "Alle",
    'ui__server/mail/statistics#period_custom__title' => "Benutzerdefiniert",
    'ui__server/mail/statistics#period_month__title' => "Aktueller Monat",
    'ui__server/mail/statistics#period_prev_month__title' => "Letzter Monat",
    'ui__server/mail/statistics#period_prev_week__title' => "Letzte Woche",
    'ui__server/mail/statistics#period_today__title' => "Heute",
    'ui__server/mail/statistics#period_week__title' => "Aktuelle Woche",
    'ui__server/mail/statistics#period_yesterday__title' => "Gestern",
    'ui__server/mail/statistics#show_for_period__title' => "Anzeigezeitraum",
    'ui__server/mail/statistics#tools_legend__title' => "Tools",
    'ui__server/mail/statistics__description' => "Spam- und Virenstatistiken anzeigen",

    'ui__server/mail/statistics__short-title' => "Statistiken",
    'ui__server/mail/statistics__title' => "Statistiken",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Spamstatistiken",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Tools",
    'ui__server/mail/statistics/spam__description' => "Spamstatistiken anzeigen",

    'ui__server/mail/statistics/spam__short-title' => "Spamstatistiken",
    'ui__server/mail/statistics/spam__title' => "Spamstatistiken",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "E-Mail-Name",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% von allen",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Nach E-Mail-Konto sortieren",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Nach % von allen sortieren",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Nach empfangenem Spam sortieren",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "E-Mail-Konten",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Empfangener Spam",
    'ui__server/mail/statistics/spam/recipients__description' => "Empfänger",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Empfänger",
    'ui__server/mail/statistics/spam/recipients__title' => "Empfänger",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Löschen",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infiziert",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% von allen",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Zählung",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Geschützt",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Nicht überprüft",
    'ui__server/mail/statistics/spam/summary__description' => "Zusammenfassender Bericht",

    'ui__server/mail/statistics/spam/summary__short-title' => "Zusammenfassender Bericht",
    'ui__server/mail/statistics/spam/summary__title' => "Zusammenfassender Bericht",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virenstatistiken",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Tools",
    'ui__server/mail/statistics/virus__description' => "Virenstatistiken anzeigen",

    'ui__server/mail/statistics/virus__short-title' => "Virenstatistiken",
    'ui__server/mail/statistics/virus__title' => "Virenstatistiken",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "E-Mail-Konto",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% von allen",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Nach E-Mail-Name sortieren",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Nach % von allen sortieren",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Nach empfangenen Viren sortieren",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "E-Mail-Konten",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Empfangene Viren",
    'ui__server/mail/statistics/virus/recipients__description' => "Empfänger",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Empfänger",
    'ui__server/mail/statistics/virus/recipients__title' => "Empfänger",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Löschen",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infiziert",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% von allen",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Zählung",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Geschützt",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Nicht überprüft",
    'ui__server/mail/statistics/virus/summary__description' => "Zusammenfassender Bericht",

    'ui__server/mail/statistics/virus/summary__short-title' => "Zusammenfassender Bericht",
    'ui__server/mail/statistics/virus/summary__title' => "Zusammenfassender Bericht",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Name",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% von allen",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Nach Name sortieren",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Nach % von allen sortieren",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Nach infizierten Objekten sortieren",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Viren",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Infizierte Objekte",
    'ui__server/mail/statistics/virus/viruses__description' => "Viren",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Viren",
    'ui__server/mail/statistics/virus/viruses__title' => "Viren",

    'ui__support#param_company__title' => "Firma",
    'ui__support#param_email__title' => "E-Mail-Adresse",
    'ui__support#param_firstname__title' => "Vorname",
    'ui__support#param_keynumber__title' => "Produkt-Lizenznummer",
    'ui__support#param_operatingsystem__title' => "Betriebssystem",
    'ui__support#param_phone__title' => "Telefonnummer",
    'ui__support#param_psabuild__title' => "Plesk Build",
    'ui__support#param_psainsttype__title' => "Plesk Installationstyp",
    'ui__support#param_psaversion__title' => "Plesk Version",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Tools",

    'ui__reseller/traffic-history_unknown__short-title' => "Traffic nach Reseller anzeigen",
    'ui__reseller/traffic-history_unknown__title' => "Traffic nach Reseller anzeigen",
    'ui__reseller/traffic-history_unknown__description' => "Traffic nach Reseller-Konten anzeigen.",
    'ui__reseller#list__title' => "Reseller",
    'accounts_list__name__filter_title' => "Name",
    'accounts_list__resource__filter_title' => "Ressourcenverbrauch",
    'resellers_list__filter_resource_usage_any' => "Beliebig",
    'resellers_list__filter_resource_usage_overuse' => "Überbuchung",
    'resellers_list__filter_resource_usage_normal' => "Innerhalb der Grenzen",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Beliebig",
    'resellers_list__filter_status_blocked' => "Gesperrt",
    'resellers_list__filter_status_active' => "Aktiv",
    'resellers_list__filter_clients__filter_title' => "Anzeigen",
    'resellers_list__filter_clients_on' => "Reseller mit Ihren Kunden",
    'resellers_list__filter_clients_off' => "Nur Reseller",
    '__disk_usage' => "Genutzter Speicherplatz",
    'ui__reseller/traffic_unknown__short-title' => "Traffic nach Reseller anzeigen",
    'ui__reseller/traffic_unknown__title' => "Traffic nach Reseller anzeigen",
    'ui__reseller/traffic#list__title' => "Traffic nach Reseller",
    'ui__reseller/traffic_unknown__description' => "Traffic-Nutzungsberichte anzeigen.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Traffic nach Reseller",

    '__reseller_name' => "Name des Resellers",
    '__reseller' => "Reseller",
    'resellertrafficlist_header' => "Traffic nach Reseller anzeigen",
    '__reseller_personal' => "Traffic-Nutzung durch Domain des Resellers",
    'ui__reseller/traffic-history__short-title' => "Traffic nach Reseller",
    'ui__reseller/traffic-history__title' => "Traffic nach Reseller",
    'ui__reseller/traffic-history__description' => "Traffic-Nutzungsberichte anzeigen.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Überbuchung zulassen",
    'limits__reseller_oversell_description' => "Die Überbuchung (Overselling) ermöglicht dem Reseller, mehr Ressourcen zu verkaufen als ihm zugewiesen wurden. Wenn die Überbuchung zugelassen ist, wird die Abrechnung für den Reseller nach tatsächlichem Ressourcenverbrauch anstatt nach der ursprünglichen Ressourcenzuteilung vorgenommen.",
    'limits__overuse_block_text' => "Überbeanspruchungsrichtlinien",
    'limits__overuse_block_true_text' => "Überbeanspruchung ist nicht zulässig",
    'limits__reseller_overuse_block_true_description' => "Lassen Sie die Überbeanspruchung von Ressourcen nicht zu. Der tatsächliche Ressourcenverbrauch darf in dem Fall die ursprüngliche Ressourcenzuweisung nicht überschreiten",
    'limits__overuse_block_false_text' => "Überbeanspruchung ist zulässig",
    'limits__reseller_overuse_block_false_description' => "Überbeanspruchung von Ressourcen zulassen. Der Reseller kann mehr Ressourcen nutzen als ihm ursprünglich zur Verfügung gestellt wurden. Der tatsächliche Ressourcenverbrauch kann die ursprünglich zugewiesenen Ressourcen überschreiten.",
    'limits__reseller_overuse_notify_text' => "Reseller bei Erreichen der Ressourcengrenzen benachrichtigen",
    'reseller_perm__manage_sh_access_disabled' => "Reseller kann Shell-Zugriff weder erlauben noch verbieten",
    'reseller_perm__manage_sh_access_chrooted' => "Reseller kann nur Zugriff auf eine chrooted-Umgebung zulassen",
    'reseller_perm__manage_sh_access_any' => "Reseller kann Zugriff auf jeden Shell-Typ erlauben",
    'template__reseller_num_excl_ips' => "Dem Reseller dedizierte IP-Adressen zuweisen",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Konto",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Kunden",
    'ui__reseller#domainsTab__title' => "Domains",
    'ui__reseller__title' => "Konto von Reseller %1 verwalten",
    'domains__reseller_info' => "%1 Kunden, %2 Domains, %3 der verwendeten Festplatte, %4 der übertragenen Daten.",
    'domains__reseller_info_hiding_traffic' => "%1 Kunden, %2 Domains, %3 der verwendeten Festplatte.",
    'ui__reseller__description' => "Reseller-Konto verwalten.",

    'ui__reseller/limits_unknown__wizard-title' => 'Ressourcengrenzen für einen Reseller anzeigen oder ändern',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Wählen Sie den entsprechenden Reseller aus.',
    'ui__reseller/limits_unknown__wizard__2' => 'Um die Änderungen zu übernehmen, klicken Sie auf \'Fertigstellen\'.',

    'ui__client/report_reseller__short-title' => "Bericht",
    'ui__client/report_reseller__title' => "Bericht zum Konto anzeigen",
    'ui__client/report_reseller__description' => "Reseller-Konto-Bericht anzeigen.",
    'ui__client/ip-pool_reseller__short-title' => "IP-Pool",
    'ui__client/ip-pool_reseller__description' => "IP-Adressen und SSL/TLS-Zertifikate dem Reseller-Konto zuweisen",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Geben Sie die Kontoeinstellungen an und klicken Sie auf Fertigstellen.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Berechtigungen für einen Reseller anzeigen oder ändern',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Wählen Sie den Reseller aus, dessen Berechtigungen Sie anzeigen oder ändern möchten.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Wenn Sie die Berechtigungen des Resellers geändert haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',

    // Customers > create customer account

    '__resellers_list' => 'Reseller',
    'picker_reseller__title' => 'Reseller auswählen',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Tools",
    'ui__client#tools2__title' => "Konto",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Kunden",
    'ui__client#domainslist__title' => "Domains",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Alle Webanwendungen sind nach Kategorien sortiert, was die Installation der gewünschten Anwendung erleichtert.",
    'feature__domainkeys__reseller' => "Sie können den DKIM-Mechanismus zur E-Mail-Absender-Authentifizierung verwenden, um die Anzahl der Spam- und Phishing-E-Mails zu verringern.",

    '__reseller_form' => "Reseller-Formular",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Wählen Sie das Kundenkonto, dessen Einstellungen Sie ändern wollen.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Zum Ändern der Ressourcenverbrauchsgrenzen klicken Sie auf 'Ressourcengrenzen'.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Klicken Sie auf \"Berechtigungen\", um die Berechtigungen für Aktionen zu ändern, die ein Kunde in Plesk ausführen kann.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Dieses Template für andere Benutzer verfügbar machen",
    'template__shared_description' => "Wählen Sie diese Option aus, wenn Sie Ihren Kunden das Verwenden dieses Templates erlauben möchten.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Tools',

    'ui__client/traffic-history_unknown__short-title' => 'Traffic nach Kunden anzeigen',
    'ui__client/traffic-history_unknown__title' => 'Traffic nach Kunden',
    'ui__client/traffic-history_unknown__description' => 'Traffic-Bericht für alle Kunden anzeigen',
    'ui__client/traffic-history__short-title' => 'Traffic nach Kunden',
    'ui__client/traffic-history__title' => 'Traffic nach Kunden anzeigen',
    'ui__client/traffic-history__description' => 'Traffic-Bericht für alle Kunden anzeigen',

    'ui__client/traffic#list__title' => 'Traffic nach Kunden',
    'ui__reseller/client/traffic#list__title' => 'Traffic nach Kunden',

    'clients_list__filter_type__filter_title' => 'Anzeigen',
    'clients_list__filter_type_any' => 'Kunden und Reseller',
    'clients_list__filter_type_clients' => 'Nur Kunden',
    'clients_list__filter_type_resellers' => 'Nur Reseller',
    'ui__client/domain_unknown-new__short-title' => "Domain erstellen",

    // Customers > View traffic by customers
    '__personal' => "Traffic-Nutzung durch Domain des Benutzers",
    'PersonalTrafficList_header_of_client__' => "Traffic-Nutzungsbericht für Ihr Konto anzeigen",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Domainadministrator kann Shell-Zugriff nicht zulassen oder verbieten",
    'domain_perm__manage_sh_access_chrooted' => "Domainadministrator kann nur Zugriff auf eine chrooted-Umgebung zulassen",
    'domain_perm__manage_sh_access_any' => "Domainadministrator kann Zugriff auf jeden Shell-Typ zulassen",

    // APS Catalog
    'bt_add_to_vault' => "Zum Vault hinzufügen",
    'bt_hide_updates' => "Verfügbare Updates ausblenden",
    'bt_show_updates' => "Verfügbare Updates anzeigen",

    '__site_apps__applications' => "Anwendungen",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Für das Hinzufügen zum Vault ausgewählte Anwendungen",
    'site_apps__application_selected' => "Ausgewählt",
    'site_apps__currently_in_vault' => "Andere Versionen im Vault:",
    'site_apps__new_versions' => "Neue Versionen:",
    'site_apps__patches' => "Patches:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Anzahl an Anwendungen, deren Hinzufügung zum Vault geplant ist: %1",
    'site_apps__applications_downloading_now' => "Die folgenden Anwendungen werden jetzt heruntergeladen: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Bereits im Vault",

    // Server > Action Log
    'bt_skin_edit' => "Skin-Beschreibung bearbeiten",
    'limits__oversell_legend' => "Overselling",
    'limitsManager__limit_available_error' => "Zuweisen der erforderlichen Ressourcen (%%quantity%% %%limitName%%) nicht möglich. Es sind nur %%available%% %%limitName%% verfügbar.",
    'limitsManager__limit_reserved_error' => "Die erforderliche Ressourcenverbrauchsgrenze (%%quantity%% %%limitName%%) kann nicht festgelegt werden, da der neue Wert geringer ist als der Wert der Ressourcen, die für Ihre Kunden reserviert sind oder von Ihnen verwendet werden (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Die erforderliche Ressourcenverbrauchsgrenze (%%quantity%% %%limitName%%) kann nicht festgelegt werden, da der neue Wert geringer ist als der tatsächliche Wert der Ressourcen, die von Ihrem Konto und Ihren Websites verwendet werden (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Bandbreitenauslastung nach Services",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Traffic-Nutzungsbericht anzeigen",
    'ui__client/domain/traffic_unknown-reseller__title' => "Traffic-Nutzungsbericht anzeigen",

    'ui__client/domain_new__short-title' => "Domain erstellen",

    'ui__client_reseller__description' => "Reseller-Konto %1 verwalten.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Reseller-Konto verwalten",

    '__owner_name' => "Name des Besitzers",
    'domains_list__resource__filter_title' => "Ressourcenverbrauch",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS-Anwendungskatalog",
    'site_apps__applications_have_updates' => "Für die folgenden Anwendungen sind aktualisierte Versionen verfügbar:\n%1\nZum Anzeigen der Updates stellen Sie sicher, dass der Suchbereich sichtbar ist, aktivieren Sie das Kontrollkästchen <b>Nur Updates anzeigen</b>, und suchen Sie die erforderlichen Anwendungen.",
    'site_apps__progress_adding_to_vault' => "Hinzufügen zum Vault:",
    'site_apps__progress_done_message' => "Fortschritt:",
    'site_apps__progress_applications_left' => "%1 von %2 Anwendungen verbleibend",
    'site_apps__download_item_long_task_title' => "APS-Anwendung (%1) herunterladen",
    'site_apps__download_transaction_long_task_title' => "APS-Anwendungen aus APS-Katalog herunterladen",
    'site_apps__last_check_for_updates' => "letzte Überprüfung auf Updates: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Alle geplanten Anwendungen wurden zum Application Vault hinzugefügt",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 geplante Anwendungen werden zum Application Vault hinzugefügt.",
    'site_apps__no_search_results' => 'Keine Anwendungen gefunden. Versuchen Sie es mit einer anderen Suchanfrage oder durchsuchen Sie die Anwendungen nach Kategorien.',
    'site_apps__search_results_title' => 'Suchergebnisse',
    '__site_apps__search_by_application' => 'Anwendungsname',
    '__site_apps__search_by_vendor' => 'Verkäufer',
    '__site_apps__search_by_vendor__all' => 'Alle Händler',
    '__site_apps__search_by_packager' => 'Packager',
    '__site_apps__search_by_certification_level' => 'Zertifizierungsebene',
    '__site_apps__search_by_cert__any' => 'Beliebig',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silber und höher',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold und höher',
    '__retry' => 'Erneut versuchen',
    'site_apps__application_packager_site' => 'Packager',
    'site_apps__add_to_pool_message' => "Anwendungen, die als \"für alle verfügbar\" markiert sind, werden automatisch für alle Reseller und Kunden mit unbegrenzten Installationen bereitgestellt. Anwendungen mit eingeschränktem Zugriff werden manuell und auf individueller Basis für alle Reseller und Kunden unter Angabe der Anzahl der verfügbaren Installationen bereitgestellt.",
    'site_apps__make_available_for_all' => "Ausgewählte Anwendungen für alle Benutzer verfügbar machen",

    'site_apps__broadcast_app_text' => "Anwendungen, die als \"für alle verfügbar\" markiert sind, werden automatisch für alle Reseller und Kunden mit unbegrenzten Installationen bereitgestellt. Anwendungen mit eingeschränktem Zugriff werden manuell und auf individueller Basis für alle Reseller und Kunden unter Angabe der Anzahl der verfügbaren Installationen bereitgestellt.",
    'site_apps__broadcast_app_name' => 'Anwendung allen Benutzern zur Verfügung stellen',

    // User Application Pool per application
    'site_apps__available_clients' => 'Verfügbare Benutzer',
    'site_apps__no_more_clients_to_add_to_pool' => 'Es verbleiben keine Benutzerkonten, denen Sie diese Anwendung zur Verfügung stellen können',

    // Installed application instances
    'site_apps__installations' => 'Anzahl der Installationen',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domainname und IP-Adresse",
    '__assign_ip_address' => "IP-Adresse zuweisen",
    '__switch_on_service' => "Service aktivieren",
    '__hosting_configuration' => "Hosting-Konfiguration",
    '__vrt_hst' => "Website-Hosting",
    '__vrt_hst_hint' => "Eine Website auf diesem Server hosten.",
    '__fwd' => "Weiterleitung",
    '__web_hosting_settings' => "Hosting-Einstellungen",
    '__fwd_hint' => "Besucher auf eine andere Website weiterleiten",
    '__none_hint' => "Hosten Sie momentan keine Website.",
    '__login_hint' => "Dieser Benutzername wird verwendet, um über FTP auf Ihre Website zu zugreifen",
    '__password_hint' => "Dieses Passwort wird verwendet, um über FTP auf Ihre Website zu zugreifen",
    '__advanced_hosting_setup' => "Erweiterte Website-Hosting-Einstellungen konfigurieren",
    '__domain_creation_successful' => "Die Domain wurde erstellt.",
    'bt_hosting_settings' => "Hosting-Einstellungen",
    '__change_hosting_type' => "Hosting-Typ für Domain %1 ändern",
    '__hosting_type_change_warning' => "Wenn Sie den Hosting-Typ auf Weiterleitung ändern, werden alle Dateien und Verzeichnisse Ihrer Site vom Server entfernt. Stellen Sie sicher, dass Sie eine Kopie Ihrer Site lokal speichern.",
    '__current_hosting_type' => "Aktueller Hosting-Typ",
    '__new_hosting_type' => "Neuer Hosting-Typ",
    '__fwd_settings' => "Weiterleitungseinstellungen",
    '__fwd_settings_legend' => "Weiterleitungseinstellungen",
    '__fwd_destination_url' => "Ziel-URL",
    '__fwd_type' => "Weiterleitungsart",
    '__fwd_type_standart' => "Standardweiterleitung",
    '__fwd_type_standart_hint' => "Besucher auf eine andere Website weiterleiten und Ihnen die Zieladresse anzeigen, damit Sie über die Weiterleitung informiert sind.",
    '__fwd_type_frame' => "Frame-Weiterleitung",
    '__fwd_type_frame_hint' => "Leiten Sie Besucher auf eine andere Website weiter, aber lassen Sie ihnen nicht die Zieladresse anzeigen, damit sie die Weiterleitung nicht bemerken.",
    '__hosting_type_template_warning' => "Der von Ihnen ausgewählte Hosting-Typ ist anders als der Typ, der im Template angegeben wurde. Wenn Sie fortfahren, werden die Hosting-Einstellungen in dem ausgewählten Template ignoriert. Sind Sie sicher, dass Sie den ausgewählten Hosting-Typ einrichten möchten?",

    '__no_resellers_selected' => "Sie müssen mindestens ein Reseller-Konto auswählen.",

    'ui__client/logo_unknown__wizard-title' => 'Logo einrichten',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Bitte wählen Sie den Kunden aus, dessen Logo-Einstellungen Sie ändern wollen.',
    'ui__client/logo_unknown__wizard__2' => 'Klicken Sie auf \'Fertigstellen\', um die Änderungen zu übernehmen.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klicken Sie auf \'Fertigstellen\', um die Änderungen zu übernehmen.',

    'ui__client/ipaddress/properties_new__short-title' => "IP-Adresse hinzufügen",
    'ui__client/ipaddress/properties_new__title' => 'IP-Adresse hinzufügen',
    'ui__client/ipaddress/properties_new__description' => "Fügen Sie eine IP-Adresse hinzu.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "IP-Adresse hinzufügen",
    'ui__client/ipaddress/properties_unknown-new__title' => "IP-Adresse hinzufügen",
    'ui__client/ipaddress/properties_unknown-new__description' => "IP-Adresse hinzufügen",
    'ui__client/ipaddress/delete_multi__short-title' => "IP-Adresse entfernen",
    'ui__client/ipaddress/delete_multi__description' => "IP-Adressen entfernen.",
    'ippool_Manager__no_available_ips' => "Der IP-Pool enthält keine freien IP-Adressen.",
    'ippool_Manager__ip_shared' => "gemeinsam genutzt",
    'ippool_Manager__ip_exclusive' => "dediziert",
    'ui__client/ipaddress/properties__title' => "IP-Adressen verwalten",
    'ui__client/ipaddress/properties__description' => "IP-Adresseigenschaften anzeigen oder ändern.",
    'ui__client/ipaddress_unknown-new__title' => "IP-Adresse hinzufügen",
    'ui__client/ipaddress_unknown-new__short-title' => "IP-Adresse hinzufügen",
    'ui__client/ipaddress_unknown-new__description' => "Fügen Sie IP-Adressen hinzu.",

    'ui__mass-mail#to_resellers_text__title' => "Reseller",
    'ui__mass-mail#to_domainusers_text__title' => "Domainadministratoren",
    'ui__mass-email#tools_legend__title' => "Tools",
    'ui__mass-email#list_legend__title' => 'Massen-E-Mail-Templates',
    'ui__mass-email#template_legend__title' => "Vorlage",
    'ui__mass-email#from_email_text__title' => "Ab",
    'ui__mass-email#to_text__title' => 'An',
    'ui__mass-email#to_resellers_text__title' => "Reseller",
    'ui__mass-email#to_clients_text__title' => "Kunden",
    'ui__mass-email#to_domainusers_text__title' => "Domainadministratoren",
    'ui__mass-email#to_admin_text__title' => "Plesk Administrator",
    'ui__mass-email#option_mode_all__title' => "Alle",
    'ui__mass-email#option_mode_select__title' => "Nur ausgewählte",
    'ui__mass-email#option_mode_except__title' => "Alle außer den ausgewählten",
    'ui__mass-email#option_select_template__title' => '---Template auswählen---',
    'ui__mass-email#subject_text__title' => "Betreff",
    'ui__mass-email#body_text__title' => "Nachrichtentext",
    'ui__mass-email#save_as_legend__title' => "Als Template speichern",
    'ui__mass-email#save_as_text__title' => "Verfasste Nachricht speichern als neues Template mit dem Namen",
    'ui__reseller/preferences_unknown__wizard-title' => "Kontoeinstellungen ändern",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Wählen Sie den Reseller aus, dessen Kontoeinstellungen Sie ändern wollen und klicken Sie auf Weiter.",
    'ui__reseller/preferences_unknown__wizard__2' => "Geben Sie die Kontoeinstellungen an und klicken Sie auf OK.",
    'ippoolManager__ip_shared' => "gemeinsam genutzt",
    'ippoolManager__ip_exclusive' => "dediziert",

    '__users_list' => "Benutzer",
    '__users' => "Benutzer",
    '__user_name' => "Name des Benutzers",

    'limit__name_max_dom_aliases' => "Domain-Aliase",
    'limit__name_max_subftp_users' => "zusätzliche FTP-Konten",
    'limit__name_max_mssql_db' => "Microsoft SQL Server-Datenbanken",
    'limit__name_max_iis_app_pools' => "IIS-Anwendungspools",
    'limit__name_max_odbc' => "ODBC-Verbindungen",
    'total_mboxes_quota_unsupported' => 'wird vom Mailserver nicht unterstützt',
    'limit_soft__disk_space' => 'Benachrichtigung bei Erreichen des Speicherplatzmaximums',
    'limit_soft__max_traffic' => 'Benachrichtigung bei Erreichen des Verkehrsmaximums',
    'limitsManager__commit_failed' => "Ändern der Ressourcengrenzen nicht möglich.",
    'limitsManager__date_in_past' => "Ungültiges Ablaufdatum %1.",
    'limitsManager__limit_not_supported' => "Einrichten der Grenzen für Ressourcentyp %1 nicht möglich.",
    'limitsManager__limit_oversell_inconsistency' => "Die angegebenen Ressourcen können nicht zugewiesen werden, wenn Overselling deaktiviert ist.",
    'limitsManager__limit_overuse_inconsistency' => "Der Ressourcenverbrauch überschreitet die definierten Grenzen.",
    'limitsManager__no_resource_available' => "Keine Ressourcen dieses Typs (%%limitName%%) mehr vorhanden. Angefordert: %%quantity%%; verfügbar: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Ihr Service-Provider stellt diese Ressourcentypen (%%limitName%%) nicht zur Verfügung. Angefordert: %%quantity%%; verfügbar: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Das Ablaufdatum darf höchstens %1 sein.",
    'limitsManager__invalid_disk_space_limit' => "Der Speicherplatz darf höchstens %1 betragen.",
    'limitsManager__invalid_max_traffic_limit' => "Der Traffic darf höchstens %1 betragen.",
    'ippoolManager__ip_has_suballocations' => "Der Typ bereits zugewiesener IP-Adressen kann nicht geändert werden. IP-Adresse %%ip%% ist Benutzern bereits als %%reserved%% IP-Adresse zugewiesen.",
    'ippoolManager__ip_is_already_in_pool' => "Diese IP-Adresse ist dem Benutzer bereits zugewiesen.",
    'ippoolManager__ip_is_not_in_pool' => "IP-Adresse %%ip%% befindet sich nicht im Pool.",
    'ippoolManager__can_not_allocate_ip' => "IP-Adresse %%ip%% ist nur als %%available%% verfügbar.",
    'ippoolManager__unable_to_set_default_type' => "Die IP-Adresse %%ip%% kann nicht als dediziert verwendet werden.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Die IP-Adresse %%ip%% wird bereits für das Hosting verwendet.",
    'ippoolManager__active_anon_ftp_on_ip' => "Anonymous FTP-Zugriff ist für IP-Adresse %%ip%% bereits aktiviert",
    'ippoolManager__no_vacant_ips' => "Es sind keine freien IP-Adressen vorhanden.",
    'ippoolManager__no_available_ips' => "Es sind keine IP-Adressen verfügbar.",
    'templates__dublicate_name' => "Ein Template mit diesem Namen ist bereits vorhanden. Bitte wählen Sie einen anderen Namen für dieses Template aus.",
    'cl_perm__client_limits_exceeded' => "Die angegebenen Ressourcenlimitwerte überschreiten die von Ihrem Hostingplan zugelassenen Werte, oder diese Werte stellen weniger Ressourcen zur Verfügung als momentan von Ihren Sites benötigt werden.",
    'cl_perm__reseller_limits_exceeded' => "Die angegebenen Ressourcenlimitwerte überschreiten die von Ihrem Hosting-Paket zugelassenen Werte, oder diese Werte stellen weniger Ressourcen zur Verfügung als momentan von Ihren Benutzerkonten und Sites benötigt werden.",

    'site_apps__preferences_show_all_versions_title' => "Vollständige Liste der Versionen aller vom Katalog abgerufenen Anwendungen anzeigen",
    'site_apps__preferences_show_all_versions_hint' => "Wenn diese Option aktiviert ist, kann es möglicherweise einige Zeit dauern, bis alle Versionen jeder Anwendung bei jedem Öffnen des Katalogs abgerufen werden. Wenn diese Option nicht aktiviert ist, werden nur die aktuellen Versionen angezeigt.",
    '__select_user_template' => "Benutzerkonto auf Basis eines Template erstellen",
    'ip_already_added_to_all_clients' => "Diese IP-Adresse ist bereits allen Benutzern zugewiesen.",
    'ui__server/ip-address/client/delete#legend__description' => "Die folgenden IP-Adressen werden aus dem System und aus den Benutzer-IP-Pools entfernt:",

    'site_apps__cancelled_apps' => "Sie haben das Hinzufügen der folgenden Anwendungen abgebrochen: %2",

    'sb_url_is_not_resolved' => 'URL kann nicht aufgelöst werden: Überprüfen Sie Ihre DNS-Einstellungen. Die URL %1 muss in die IP-Adresse des Servers, auf dem Presence Builder installiert ist, aufgelöst werden.',

    'ip_addr__is_last_on_interface' => 'IP-Adresse %%ip%% kann nicht entfernt werden, da sie die letzte verbleibende IP-Adresse auf einer Netzwerkschnittstelle ist.',
    'ip_addr__used_for_current_session' => 'IP-Adresse %%ip%% kann nicht entfernt werden, da sie bei einer aktiven Sitzung verwendet wird.',
    'ip_addr__used_for_hosting' => 'Die IP-Adresse %%ip%% kann nicht entfernt werden, da Sie für das Hosting einer Website verwendet wird.',
    'ip_addr__is_main' => 'IP-Adresse %%ip%% kann nicht entfernt werden, da sie die primäre IP-Adresse einer Netzwerkschnittstelle ist.',
    'ip_addr__ip_used_by_message_submission' => 'IP-Adresse %%ip%% kann nicht entfernt werden, da sie für die Übertragung von E-Mails verwendet wird',

    // RESELLER ACTION LOG

    '__cl_domains' => 'Domains von Kunden',
    'excl_ip_num' => 'Dedizierte IP-Adresse',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder ist nicht installiert.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Die Berechtigung zum Overselling kann nicht aufgehoben werden, da der Benutzer bereits mehr Ressourcen zugeteilt hat als zur Verfügung stehen und sich somit bereits im Overselling-Modus befindet.',
    'limitsManager__invalid_limit_value' => 'Ungültiger Wert %%value%% für Grenze %%limit_name%% angegeben',
    'confirmationForm_default_agreement_text' => 'Vorgang bestätigen',
    'confirmationForm_default_confirm_message' => 'Bitte bestätigen Sie die Operation.',
    'limit__max_mn' => 'Maximale Anzahl E-Mail-Konten',

    'limits__client_overuse_description' => 'In den Richtlinien zur Überbeanspruchung ist festgelegt, wie Plesk verfahren soll, wenn der Ressourcenverbrauch die ursprüngliche Ressourcenzuweisung überschreitet.',
    'limits__client_overuse_block_true_description' => 'Lassen Sie die Überbeanspruchung von Ressourcen nicht zu. Der tatsächliche Ressourcenverbrauch darf in dem Fall die ursprüngliche Ressourcenzuweisung nicht überschreiten',
    'limits__client_overuse_block_false_description' => 'Lassen Sie die Überbeanspruchung von Ressourcen nicht blockieren, so kann der Kunde mehr Ressourcen nutzen als ihm ursprünglich zur Verfügung gestellt wurden. Der tatsächliche Ressourcenverbrauch kann die ursprünglich zugewiesenen Ressourcen überschreiten',
    'limits__client_overuse_notify_text' => 'Kunden darüber benachrichtigen, dass die Ressourcengrenzen erreicht wurden',

    'limits__domain_overuse_description' => 'In den Richtlinien zur Überbeanspruchung ist festgelegt, wie Plesk verfahren soll, wenn der Ressourcenverbrauch die ursprüngliche Ressourcenzuweisung überschreitet.',
    'limits__domain_overuse_block_true_description' => 'Die Richtlinien zur Überbeanspruchung geben Plesk vor, wie vorzugehen ist, wenn Ressourcen über ihre Grenze hinaus genutzt werden.',
    'limits__domain_overuse_block_false_description' => 'Lassen Sie die Überbeanspruchung von Ressourcen zu. Die Domain kann dann mehr Ressourcen nutzen als ihr ursprünglich zur Verfügung gestellt wurden. Der tatsächliche Ressourcenverbrauch kann die ursprünglich zugewiesenen Ressourcen überschreiten.',
    'limits__domain_overuse_notify_text' => 'Domainbesitzer bei Erreichen der Ressourcengrenzen benachrichtigen',


    'cancel_remove' => 'Verwerfen Sie alle Änderungen und kehren Sie zur vorherigen Seite zurück.',

    'dns__dns_rr_delete' => 'Elemente, die entfernt werden',
    'dns__delete_rr' => 'Die folgenden DNS-Einträge werden aus der DNS-Zone entfernt:',
    'dns__dns_rr_delete_non_removable' => 'Elemente, die nicht entfernt werden können',
    'dns__non_delete_rr' => 'Die folgenden DNS-Einträge können nicht entfernt werden:',
    'dns__dns_rr_delete_confirm_message' => 'Entfernen von DNS-Einträgen bestätigen',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Unbekanntes Webanwendungsformat: Die Webanwendung kann möglicherweise nicht installiert und verwendet werden.',

    '__php_handler_type_desc' => 'PHP ausführen als',
    'sfdk_domain_sign__failed' => 'Beim Wechseln zum Signieren von E-Mails mit DKIM in der Domain ist ein nicht identifizierter Fehler aufgetreten. Weitere Informationen erhalten Sie im Server-Fehlerprotokoll.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Benachrichtigung über erfolgreiche Plesk Lizenzschlüsselaktualisierung',
    'pkey_notify__subj_update_deferral_notification' => 'Benachrichtigung über die Verzögerung der Plesk Lizenzschlüsselaktualisierung',
    'pkey_notify__subj_update_error_notification' => 'Benachrichtigung über Fehler bei der Plesk Lizenzschlüsselaktualisierung',
    'pkey_notify__update_successful' => '%1-Update abgeschlossen.',
    'pkey_notify__update_failed_no_more_try' => '%1 kann nicht aktualisiert werden. Der Schlüssel, den Sie versuchen zu versenden, ist ungültig. Sie sollten nicht versuchen, diesen Schlüssel erneut zu aktualisieren.',
    'pkey_notify__update_failed_try_later' => '%1 kann nicht aktualisiert werden: Während der Verarbeitung Ihres Schlüssels ist ein Fehler aufgetreten. Sie können versuchen, den Schlüssel manuell in Plesk abzurufen (Tools & Einstellungen > Lizenzinformationen) oder Plesk versuchen lassen, ihn in den nächsten 24 Stunden zu aktualisieren. Wenn Sie diese Benachrichtigung nicht mehr erhalten wollen, sollten Sie den Schlüssel aus Plesk entfernen.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Deaktivieren der serverweiten Spamfilterung nicht möglich.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Aktivieren der serverweiten Spamfilterung nicht möglich',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domains',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliase',
    'rpt_reseller_dom_postboxes' => 'Mboxen',
    'rpt_reseller_dom_redirects' => 'Weiterleitungen',
    'rpt_reseller_dom_mail_groups' => 'Mgruppen',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Virenschutz',
    'rpt_reseller_dom_mail_lists' => 'Mlisten',
    'rpt_reseller_dom_web_users' => 'Wbenutzer',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Kunden',
    '__cl_name' => 'Kundenname',
    '__cl_creation_date' => 'Erstellungsdatum',
    '__clients_traffic' => 'Kunden-Traffic',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Virenschutz',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder ist nicht installiert.',
    'sitebuilder_disabled' => 'Presence Builder ist deaktiviert.',
    'b_sitebuilder_disabled' => 'Presence Builder ist deaktiviert.',
    'webmail_not_installed' => 'WebMail-Software ist nicht installiert.',
    'webmail_disabled' => 'Webmail-Service ausgeschaltet.',
    'spamassassin_not_installed' => 'SpamAssassin ist nicht installiert.',
    // pfu:
    'anonymous_ftp_shared' => 'Anonymous FTP kann nicht aktiviert werden: IP-Adresse wird gemeinsam genutzt.',
    'anonymous_ftp_used' => 'Anonymous FTP kann nicht aktiviert werden: Die IP-Adresse wird von einer anderen Domain für Anonymous FTP verwendet.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET ist nicht installiert.',
    'site_builder_no_package' => 'Presence Builder ist nicht verfügbar. Bitte überprüfen Sie, ob Presence Builder installiert und als aktive Komponente ausgewählt ist.',
    'site_builder_not_configured' => 'Presence Builder ist nicht konfiguriert.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Tools',
    'ui__reseller/client#clientslist__title' => 'Kunden',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Virtuelle Verzeichnisse für eine Website verwalten.',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Wählen Sie eine Website aus, deren Verzeichnisse Sie verwalten möchten.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Anonymous FTP auf Domain einrichten',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, für die Sie Anonymous FTP einrichten möchten.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Protokoll Manager für Domain einrichten und Domain-Protokolldateien anzeigen',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, deren Protokoll Manager Sie einrichten und deren Protokolldateien Sie anzeigen möchten.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'SSL/TLS-Zertifikate für Domain verwalten',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, deren SSL/TLS-Zertifikate Sie verwalten möchten.',

    'ui__client/domain/disable_multi__wizard-title' => 'Domains sperren',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Wählen Sie die Domains aus, die Sie sperren möchten.',

    'ui__client/domain/enable_multi__wizard-title' => 'Domains aktivieren',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Wählen Sie die Domains aus, die Sie aktivieren wollen.',

    'ui__client/domain_unknown__wizard-title' => 'Domains anzeigen',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Wählen Sie den Kunden aus, dessen Domains, die anzeigen wollen.',

    'ui__client/domain/register_unknown__wizard-title' => 'Domains registrieren',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, die Sie registrieren möchten.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Tools von MyPlesk.com verwenden',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Wählen Sie die Domain aus, die Sie mit Tools von MyPlesk.com verwalten möchten.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Benutzer von IP-Adresse',
    'ui__server/ip-address/client_unknown__title' => 'Benutzer von IP-Adresse',
    'ui__server/ip-address/client_unknown__description' => 'Benutzer von IP-Adresse %1',

    'disabled_by_admin' => 'Von Serveradministrator deaktiviert',






    'ui__client/domain/chowner_multi__short-title' => 'Besitzer ändern',
    'ui__client/domain/chowner_multi__title' => 'Abonnement-Besitzer ändern',
    'ui__client/domain/chowner_multi__description' => 'Abonnement-Besitzer ändern.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Wählen Sie die Domains aus, deren Besitzer Sie ändern möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__client/domain/chowner_unknown__short-title' => 'Besitzer ändern',
    'ui__client/domain/chowner_unknown__title' => 'Abonnement-Besitzer ändern',
    'ui__client/domain/chowner_unknown__description' => 'Abonnement-Besitzer ändern.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Abonnement-Besitzer ändern',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Es sind keine benutzerdefinierten Schaltflächen vorhanden.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'In der Oberfläche des Resellers %1 gibt es keine benutzerdefinierten Schaltflächen.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Entfernen Sie die Schaltfläche \'%1\'.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Entfernen',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Schaltfläche %1 entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Entfernen Sie benutzerdefinierte Schaltflächen von der Reseller-Oberfläche',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Benutzerdefinierte Schaltflächen entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Schaltflächen entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Wählen Sie einen Reseller aus, dessen benutzerdefinierte Schaltflächen Sie entfernen möchten, und klicken Sie auf Weiter >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Wählen Sie die Schaltflächen aus, die Sie entfernen möchten und klicken Sie auf \'Weiter >>\'.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bestätigen Sie das Entfernen der Schaltflächen, indem Sie das Kontrollkästchen auf dieser Seite aktivieren, und klicken Sie auf \'Fertigstellen\'.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Entfernen Sie eine benutzerdefinierte Schaltfläche von der Benutzeroberfläche eines Resellers.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Benutzerdefinierte Schaltfläche entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Benutzerdefinierte Schaltfläche entfernen',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Wählen Sie einen Reseller aus, dessen benutzerdefinierte Schaltfläche Sie entfernen möchten, und klicken Sie auf Weiter >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Wählen Sie eine benutzerdefinierte Schaltfläche aus, die Sie entfernen wollen, und klicken Sie auf \'Weiter >>\'.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bestätigen Sie das Entfernen der benutzerdefinierten Schaltfläche, indem Sie das Kontrollkästchen auf dieser Seite aktivieren, und klicken Sie anschließend auf \'Fertigstellen\'.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Eigenschaften der benutzerdefinierten Schaltfläche %1 auf Reseller-Ebene bearbeiten.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Einstellungen',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Benutzerdefinierte Schaltfläche %1 des Resellers ändern',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Benutzerdefinierte Schaltfläche hinzufügen',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Wählen Sie einen Reseller aus, in dessen Benutzeroberfläche Sie eine benutzerdefinierte Schaltfläche erstellen wollen und klicken Sie auf "Weiter >>".',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klicken Sie auf \'Fertigstellen\', um die Schaltfläche zu erstellen.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Ändern Sie die Eigenschaften einer Schaltfläche in der Benutzeroberfläche eines Resellers.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Eigenschaften',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Eigenschaften einer Schaltfläche in Reseller-Oberfläche ändern',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Eigenschaften benutzerdefinierter Schaltflächen ändern',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Wählen Sie einen Reseller aus, dessen benutzerdefinierte Schaltfläche Sie ändern möchten, und klicken Sie auf Weiter >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Wählen Sie eine benutzerdefinierte Schaltfläche aus, die Sie ändern möchten, und klicken Sie auf \'Weiter >>\'.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Wenn Sie die Eigenschaften der Schaltfläche bearbeitet haben, klicken Sie auf "Fertigstellen", um die Änderungen zu übernehmen und den Assistenten zu beenden.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Schaltfläche %1 für Ihre Kunden nicht verfügbar machen.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Für Ihre Kunden nicht verfügbar machen',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Schaltfläche %1 für Ihre Kunden nicht verfügbar machen',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Schaltfläche %1 für Kunden des Resellers sichtbar machen.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Für ihre Kunden verfügbar machen',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Schaltfläche %1 für Kunden des Resellers sichtbar machen',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Machen Sie eine benutzerdefinierte Schaltfläche für Ihre Kunden verfügbar oder heben Sie ihre Verfügbarkeit auf.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Verfügbar/nicht verfügbar für Ihre Kunden',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Benutzerdefinierte Schaltfläche für Ihre Kunden verfügbar bzw. nicht verfügbar machen',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Machen Sie eine benutzerdefinierte Schaltfläche für Ihre Kunden verfügbar oder heben Sie ihre Verfügbarkeit auf.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Wählen Sie einen Reseller aus, für dessen Kunden Sie eine benutzerdefinierte Schaltfläche verfügbar machen möchten, und klicken Sie auf Weiter >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Wählen Sie eine benutzerdefinierte Schaltfläche aus, die Sie für Ihre Kunden verfügbar bzw. nicht verfügbar machen möchten, und klicken Sie auf \'Weiter >>\'.',

    '__not_allowed' => 'Nicht zulässig',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Wählen Sie einen neuen Besitzer für die Domain aus.',

    '__ip_addr_state_unknown' => "Die IP-Adresse ist nicht betriebsbereit, da Ihre Anfrage immer noch vom System bearbeitet wird. Bitte warten.",


    'resellers_list__accounts' => 'Benutzer',

    'ip_addr__repair_is_not_allowed' => 'IP-Adresse kann in der Virtuozzo-Umgebung nicht repariert werden.',

    'ui__reseller/client__none-available__1' => 'Reseller %1 hat keine Kunden',

    'ippoolManager__ip_used_by_nohost_domain' => "Die IP-Adresse %%ip%% kann nicht entfernt werden, da sie von mindestens einer Domain ohne Hosting verwendet wird.",
    'ippoolManager__ip_used_for_mail_service' => "Die IP-Adresse %%ip%% kann nicht entfernt werden, da sie von mindestens einer Domain für den E-Mail-Dienst verwendet wird.",
    'ippoolManager__ip_used_for_send_emails' => "Die IP-Adresse %%ip%% kann nicht entfernt werden, da sie für das Senden von E-Mails von einer bestimmten IP verwendet wird (siehe Mailserver-Einstellungen).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP-Adresse %%ip%% kann nicht entfernt werden, da sie von der DNS-Zone einer oder mehrerer Domains verwendet wird.',
    'ip_ctrl__cannot_manage_on_vz' => 'Diese Installation von Plesk arbeitet in Virtuozzo Containern. Neue IP-Adressen können nur vom Administrator der Virtuozzo Container-Nodes hinzugefügt werden.',

    'client_template__limits_auto_adjusted' => 'Grenzen vom Kunden-Template wurden automatisch angepasst.',

    '__entries' => 'Einträge',

    '__path_is_not_set' => 'Pfad ist nicht angegeben. Bitte geben Sie einen gültigen Pfad an.',

    'defaultcomponents__imap_required' => '(Aktueller Mailserver unterstützt IMAP nicht)',

    '__commercial_web_stats_not_installed' => 'Plesk unterstützt nur kommerzielle Webstatistiksoftware für die Berechnung der Subdomain-Statistiken. Momentan ist keine solche Software in dem System installiert.',


    'server_settings_invalid_traffic_statistics' => 'Ungültiger Parameter für die Aufbewahrung von Traffic-Statistiken.',
    'server_settings_invalid_logrotate_period' => 'Ungültiger Parameter für den Zeitraum der Protokollrotation.',

    'spam_filter/address/file_size' => 'Die Datei kann nicht hochgeladen werden. Die Größe einer Datei für den Upload darf maximal %1 betragen.',
    'spam_filter/address/file_empty_content' => 'Fehler beim Lesen der E-Mail-Adressen in der Datei. Vergewissern Sie sich, dass die Datei in UTF-8-Kodierung gespeichert ist und eine oder mehrere E-Mail-Adressen enthält. Versuchen Sie es dann erneut.',
    'spam_filter/address/addresses_empty_content' => 'Es befinden sich keine E-Mail-Adressen in der Liste.',
    'spam_filter/address/addresses_available' => 'Nur die ersten %1 eindeutigen E-Mail-Adressen werden hinzugefügt.',
    'spam_filter/address/invalid_addresses' => 'Die folgenden E-Mail-Adressen sind ungültig: %1.',
];