<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'title' => 'ウェブサイトのログチェック',

    'regularCheck' => '自動チェック',
    'manualCheck' => '手動チェック',

    'promoTitle' => 'ウェブサイトが利用不可であることや正常に機能していないことを迅速にチェック',
    'promoDescription' => 'ウェブサイトの問題は、多くの場合訪問者には明らかですが、ウェブサイトログを定期的にチェックしていない管理者は見落としがちです。弊社の最新のウェブサイトのログチェック機能はこのルーチンを自動化するため、問題の効率的な解決に役立ちます。',
    'promoMore' => 'さらに詳しく',
    'promoButton' => '了解です！',
    'checkEnabledTitle' => '自動チェックがオン',
    'checkDisabledTitle' => '自動チェックがオフ',
    'disabledDescription' => 'オンにすると、ウェブサイトを利用不能にする問題や誤動作の原因となる問題が自動的に検出されます。',
    'websitesAllChecked' => '毎日 {count, plural, other {# 件のウェブサイト}} をチェックする',
    'websitesAllCheckedAt' => '毎日 %%time%% に {count, plural, other {# 件のウェブサイト}}をチェックする',
    'websitesChecked' => '%%count%% / %%totalCount%% 件のウェブサイトを毎日チェックする',
    'websitesCheckedAt' => '%%count%% / %%totalCount%% 件のウェブサイトを毎日 %%time%% にチェックする',
    'checkedWebsites' => 'チェックされたウェブサイトのリスト',
    'lastCheckDescription' => '前回のチェックの所要時間は %%duration%% 分でした。',
    'durationLess' => '0.1 未満',
    'month0' => '1 月 %%date%% 日',
    'month1' => '2 月 %%date%% 日',
    'month2' => '3 月 %%date%% 日',
    'month3' => '4 月 %%date%% 日',
    'month4' => '5 月 %%date%% 日',
    'month5' => '6 月 %%date%% 日',
    'month6' => '7 月 %%date%% 日',
    'month7' => '8 月 %%date%% 日',
    'month8' => '9 月 %%date%% 日',
    'month9' => '10 月 %%date%% 日',
    'month10' => '11 月 %%date%% 日',
    'month11' => '12 月 %%date%% 日',
    'export' => 'レポートを CSV 形式でエクスポート',
    'buttonRun' => '手動チェックを実行',
    'buttonRunDescription' => '修正したウェブサイトを再チェックするか、前回のチェック中に検出されなかった問題を検出します。',

    'websites.title' => 'チェック対象のウェブサイト',
    'websites.description' => '%%selected%% / %%total%% 件のウェブサイトが選択されています',
    'websites.search' => 'ウェブサイトを探す...',
    'websites.new' => '新規作成されたウェブサイトすべて',
    'websites.newHint' => 'すべての新規ウェブサイトのチェックを自動的に開始することを選択します。',
    'websites.existing' => '既存のウェブサイトすべて',
    'websites.buttonSave' => '保存',
    'websites.buttonCancel' => 'キャンセル',
    'websites.updateSuccess' => '設定が更新されました',

    'tabs.problemDetails' => '問題の詳細',
    'tabs.affectedWebsites' => '影響を受けるウェブサイト',

    'chart.requests' => 'リクエスト',
    'chart.errors' => 'エラー',

    'affected-websites.selected' => '%%selectedCount%% / %%totalCount%% 件のウェブサイトが選択されました',
    'affected-websites.none' => 'なし',
    'affected-websites.all' => 'すべて',
    'affected-websites.searchForWebsite' => 'ウェブサイトを検索',
    'affected-websites.websites' => 'ウェブサイト',
    'affected-websites.showProblemDetails' => '問題の詳細を表示',

    'problem-report.domainTitle' => '%%domain%% で報告された問題',
    'problem-report.cumulativeTitle' => '{count, plural, other {# 件のウェブサイト}}で報告された問題',
    'problem-report.serverwideTitle' => 'サーバ全体で検出された問題',
    'problem-report.problemAppearsOn' => '合計 {count, plural, other {# 件のウェブサイト}}で問題が検出されました',
    'problem-report.seeTheConsolidatedReport' => '総合レポートを表示',
    'problem-report.cause' => '根本原因',
    'problem-report.possibleSolutions' => '考えられる解決策',
    'problem-report.useAnOption' => 'オプションを使用して自動的に解決',
    'problem-report.repairTheWebsite' => 'ウェブサイトを修復',
    'problem-report.selectAndRepair' => '複数のウェブサイトを選択して修復',
    'problem-report.distributionOfTheProblem' => '問題の経時的な分布',
    'problem-report.serverTimezone' => 'サーバのタイムゾーン（UTC%%utcShift%%）',
    'problem-report.yourTimezone' => 'あなたのタイムゾーン（UTC%%utcShift%%）',
    'problem-report.logEntries' => '問題を示すログエントリの例',
    'problem-report.pleaseKeepInMind' => '注：Plesk は定期的にログをローテーションし、言及されたログエントリを最終的にはアーカイブまたは削除します。',
    'problem-report.weRecommendToRecheck' => '%%recheckWebsite%%—修正を試みた後で毎回行うことを推奨します。',
    'problem-report.recheckWebsite' => 'ウェブサイトを手動で再チェック',
    'problem-report.option' => 'オプション %%number%%：',
    'problem-report.recommended' => '推奨',
    'problem-report.numberOfEntries' => 'エントリ数',
    'problem-report.logEntry' => 'ログエントリ',
    'problem-report.logFile' => 'ログファイル',
    'problem-report.openWebsiteLogs' => 'ウェブサイトのログを開く',
    'problem-report.thisIsServerWideProblem' => 'これはホストされるすべてのウェブサイトに影響を与えるサーバ全体の問題です',
    'problem-report.serverWideTitle' => 'サーバ全体で検出された問題',
    'problem-report.checkDetectedIssue' => 'チェックにより問題が検出されました（サーバのタイムゾーン - UTC%%timezone%%）：',
    'problem-report.todayAt' => '今日 %%time%%',
    'problem-report.yesterdayAt' => '昨日 %%time%%',
    'problem-report.dateAt' => '%%date%% %%time%%',
    'problem-report.firstProblemTime' => '初回 - %%info%%',
    'problem-report.lastProblemTime' => '前回 - %%info%%',

    'distribution-over-time.title' => '問題の経時的な分布',
    'distribution-over-time.titleYesterday' => '問題の経時的な分布（昨日）',
    'distribution-over-time.titleToday' => '問題の経時的な分布（今日）',
    'distribution-over-time.serverTimezone' => 'サーバのタイムゾーン（UTC%%utcShift%%）',
    'distribution-over-time.yourTimezone' => 'あなたのタイムゾーン（UTC%%utcShift%%）',
    'distribution-over-time.weRecomendComparing' => 'モニタリングの %%link%% で、エラーの分布図を比較することをお勧めします。',
    'distribution-over-time.resourceUsageCharts' => 'リソース使用状況チャート',
    'distribution-over-time.noDataForRecentTime' => '最近のデータはありません。%%suggestion%%',
    'distribution-over-time.pleseEnableRegularCheck' => '自動チェックを有効にするか、ウェブサイトを手動でチェックしてください',
    'distribution-over-time.pleseIncludeWebsiteForCheck' => '自動チェックの対象のリストにウェブサイトを追加するか、ウェブサイトを手動でチェックしてください',
    'distribution-over-time.pleaseWaitUntilRegularCheckWillBeStarted' => '自動チェックが開始されるまで待つか、ウェブサイトを手動でチェックしてください',
    'distribution-over-time.enableRegularCheck' => '自動チェックを有効にします',
    'distribution-over-time.addWebsiteToRegularCheckList' => '自動チェックの対象のリストにウェブサイトを追加',
    'distribution-over-time.runManualCheck' => '手動チェックを実行',

    'report.title' => '前回のチェックのレポート',
    'report.groupByWebsites' => 'ウェブサイト別のグループ化',
    'report.groupByProblems' => '問題別',
    'report.columnWebsite' => 'ウェブサイト',
    'report.columnStatus' => '問題',
    'report.columnProblem' => '問題',
    'report.columnAppearedOn' => '検出日',
    'report.serverWideName' => 'サーバ全体の問題',
    'report.serverWideDescription' => 'これらの問題はサーバ全体とホストされるウェブサイトに影響を与えます。',
    'report.statusProblemsFound' => '%%count%% 件が見つかりました',
    'report.statusProblemsFoundFull' => '{count, plural, other {# 件の問題}}が見つかりました',
    'report.statusProblemsSolved' => '%%count%% 件が解消されました',
    'report.statusProblemsSolvedFull' => '{count, plural, other {# 件の問題}}が解消されました',
    'report.statusSuccess' => '問題なし',
    'report.serverWide' => 'サーバ全体',
    'report.appearedOn' => '{count, plural, other {# 件のウェブサイト}}',
    'report.recheckWebsite' => 'ウェブサイトを再チェック',
    'report.actionOpen' => '開く',
    'report.actionManage' => '管理',
    'report.actionLogs' => 'ログを表示',
    'report.searchWebsite' => 'ウェブサイトを探す...',
    'report.searchProblem' => '問題を検出...',
    'report.groupByProblemsTotal' => ' {websitesCount, plural, other {# 件のウェブサイト}}に {totalRows, plural, other {# 件の問題}}',
    'report.noProblemsTitle' => '{websitesCount, plural, other {# 件のウェブサイト}}で問題が見つかりませんでした',
    'report.noProblemsDescription' => 'ウェブサイトは適切に管理されています。',

    'problems.columnTitle' => '問題',
    'problems.columnRegular' => '自動チェック',
    'problems.columnManual' => '手動チェック',
    'problems.run' => '%%fromTime%% %%fromDate%% - %%toTime%% %%toDate%%',
    'problems.runSameDay' => '%%fromTime%% - %%toTime%% at %%toDate%%',
    'problems.notRun' => '未実行',
    'problems.resultDetected' => '検出済',
    'problems.resultNotDetected' => '未検出',
    'problems.resultNoProblems' => '問題なし',

    'new-check.title' => '手動チェック',
    'new-check.titleForWebsite' => '%%website%% の手動チェック',
    'new-check.titleRunning' => '{count, plural, other {# 件のウェブサイト}}の手動チェック',
    'new-check.description' => '%%selected%% / %%total%% 件のウェブサイトが選択されています',
    'new-check.depth' => 'チェック期間',
    'new-check.checkTheLast' => 'チェック：最後の',
    'new-check.selectHours' => '時間',
    'new-check.selectMinutes' => '分',
    'new-check.ifYouHaveAnyProblemActivities' => 'ウェブサイトの問題を修正した場合、その後で期間を設定してください。設定しないと、既に解決した問題を Plesk が検出してしまう可能性があります。',
    'new-check.weAlsoRecommendVisiting' => '手動チェックを実行する前に、%%visitingTheWebsite%% して問題の再現を試みることをお勧めします。',
    'new-check.visitingTheWebsite' => 'ウェブサイトを訪問',
    'new-check.hours' => '直近数時間',
    'new-check.websites' => 'チェック対象のウェブサイト',
    'new-check.buttonSave' => 'チェック',
    'new-check.buttonCancel' => 'キャンセル',
    'new-check.search' => 'ウェブサイトを探す...',
    'new-check.checkProblems' => '前回のチェックで問題が見つかったウェブサイト',
    'new-check.allWebsites' => 'すべてのウェブサイト',
];