<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Se o seu site está hospedado em um endereço IP dedicado (sem compartilhamento com outros usuários ou sites), você pode configurar um diretório dentro do site, onde outros usuários poderão anonimamente fazer upload ou download de arquivos através do FTP. Uma vez que o FTP anônimo é ativado, os usuários serão capazes de efetuar login no endereço ftp://ftp.seu-dominio.com como usuário "anônimo" e qualquer senha.',
    'anonymous-ftp.displayLogin' => 'A mensagem de login de exibição',
    'anonymous-ftp.loginText' => 'Texto da mensagem',
    'anonymous-ftp.incomingDir' => 'Permitir o upload a partir do diretório de entrada',
    'anonymous-ftp.incomingSubDir' => 'Permitir a criação de diretórios no diretório de entrada',
    'anonymous-ftp.incomingReadable' => 'Permitir o download a partir do diretório de entrada',
    'anonymous-ftp.quota' => 'Espaço de disco limite no diretório de entrada',
    'anonymous-ftp.maxConnections' => 'Número limite de conexões simultâneas',
    'anonymous-ftp.bandwidth' => 'Largura de banda para download limite para este domínio FTP virtual',
    'anonymous-ftp.unlimited' => 'Ilimitado',

    'aps.catalog.loading' => 'Carregando...',
    'aps.catalog.searchName' => 'Aplicativo',
    'aps.catalog.searchVendor' => 'Fornecedor',
    'aps.catalog.searchPackager' => 'Empacotador',
    'aps.catalog.searchLicenseType' => 'Tipo de Licença',
    'aps.catalog.searchLicenseTypeAny' => 'Qualquer',
    'aps.catalog.searchLicenseTypeFreeware' => 'Grátis',
    'aps.catalog.searchLicenseTypeCommercial' => 'Comercial',
    'aps.catalog.showSearch' => 'Mostrar busca',
    'aps.catalog.hideSearch' => 'Ocultar busca',
    'aps.catalog.buttonSearch' => 'Buscar',
    'aps.catalog.buttonResetSearch' => 'Reinicializar a busca',
    'aps.catalog.showCategories' => 'Selecione uma categoria abaixo ou busque os aplicativos utilizando a caixa de busca',
    'aps.catalog.searchResults' => 'Resultados da busca',
    'aps.catalog.buttonInstall' => 'Instalar',
    'aps.catalog.buttonInstallTooltip' => 'Instale rapidamente a versão mais recente do aplicativo com parâmetros padrões ideais.',
    'aps.catalog.buttonAdvancedInstall' => 'Instalação (Personalizada)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Instale a versão mais recente do aplicativo, personalizando todos os parâmetros.',
    'aps.catalog.buttonInstallOldVersion' => 'Instalar Versão',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Instale a versão selecionada do aplicativo, personalizando todos os parâmetros.',
    'aps.catalog.buttonInstallDescription' => 'Instale o aplicativo em um site, caso você já possua um código de ativação ou deseje apenas avaliá-lo.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Instalar este aplicativo gratuito em um site.',
    'aps.catalog.version' => 'Versão',
    'aps.catalog.moreVersions' => 'Mais versões',
    'aps.catalog.release' => 'Versão',
    'aps.catalog.overview' => 'Visão geral',
    'aps.catalog.noApplicationsInCategory' => 'Nenhum aplicativo disponível nessa categoria. Selecione outra categoria.',
    'aps.catalog.noCategoriesSelected' => 'Selecionar uma categoria para navegar por todos os aplicativos nela disponíveis.',
    'aps.catalog.noSearchResults' => 'Sua busca não corresponde a nenhum aplicativo.',
    'aps.catalog.connectionFailed' => 'A conexão ao catálogo de aplicativos falhou. %%retryLink%%.',
    'aps.catalog.retry' => 'Tentar novamente',
    'aps.catalog.categoriesError' => 'No momento, não é possível carregar a lista de categorias.',
    'aps.catalog.applicationsError' => 'No momento, não é possível carregar a lista de aplicativos.',
    'aps.catalog.detailsError' => 'No momento, não é possível carregar os detalhes do aplicativo.',
    'aps.catalog.searchError' => 'No momento, não é possível carregar os resultados da busca.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Lançamento %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Histórico de alterações',
    'aps.catalog.officialApplicationSite' => 'Informações do fornecedor',
    'aps.catalog.returnToCategories' => '<< Voltar à lista de aplicativos',
    'aps.catalog.buttonUninstall' => 'Remover',
    'aps.catalog.gotoHome' => 'Página inicial',
    'aps.catalog.all' => 'Todos',
    'aps.catalog.buttonDetails' => 'Saiba mais',
    'aps.catalog.buttonBuy' => 'Compre agora',
    'aps.catalog.buttonBuyTooltip' => 'Comprar o aplicativo',
    'aps.catalog.buttonBuyDescription' => 'Viste a loja mais próxima para comprar um código de ativação para o aplicativo.',
    'aps.catalog.buttonDownload' => 'Download',
    'aps.catalog.buttonDownloadDescription' => 'Efetue o download do aplicativo, caso você já possua um código de ativação ou deseje apenas avaliá-lo.',
    'aps.catalog.marketplaceMoreInfo' => 'Para obter mais informações, visite %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'O website do fornecedor do aplicativo.',

    'aps.configure.installedAt' => "Instalado em",
    'aps.configure.otherSettings' => "Outros",
    'aps.configure.globalSettings' => 'Configurações do pacote',
    'aps.configure.passwordConfirmation' => 'Confirmar senha',
    'aps.configure.databaseParams' => 'Parâmetros do banco de dados',
    'aps.configure.noInstallationUrlAvailable' => 'Nenhum (aplicativo externo)',
    'aps.configure.updateSettingsSection' => 'Configurações de Atualização',
    'aps.configure.forceUpdates' => 'Atualização automática deste app quando novas atualizações estiverem disponíveis',
    'aps.configure.forceUpdatesHint' => 'O app receberá as atualizações automáticas para as novas versões. Alerta: Utilize esta opção com cuidado porque as atualizações podem afetar significantemente a funcionalidade do app. Por exemplo, as extensões de app podem parar de trabalhar com outra versão do app.',

    'aps.install.showAllSettings' => 'Exibir todas as configurações',
    'aps.install.showLessSettings' => 'Exibir as configurações mínimas',
    'aps.install.install' => 'Instalar',
    'aps.install.otherSettings' => 'Outras configurações',
    'aps.install.globalSettings' => 'Configurações do pacote',
    'aps.install.passwordConfirmation' => 'Confirmar senha',
    'aps.install.provisionsSectionLabel' => 'Caminho de instalação',
    'aps.install.context' => 'Especifique o local em que o aplicativo web deve ser instalado.',
    'aps.install.registerAsWebmailSection' => 'Registro de webmail',
    'aps.install.registerAsWebmailDescription' => "Selecione esta opção se o aplicativo for um cliente de webmail. Isso fará com que o aplicativo seja exibido entre os serviços de webmail disponíveis nas configurações de correio de assinaturas e planos de serviço. O administrador pode configurar o URL de acesso público do webmail em Gestão de servidores > Configurações > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registrar como serviço de webmail.',
    'aps.install.addItem' => 'Adicionar',
    'aps.install.removeItem' => 'Remover',
    'aps.install.updateSettingsSection' => 'Configurações de Atualização',
    'aps.install.forceUpdates' => 'Atualização automática deste app quando novas atualizações estiverem disponíveis',
    'aps.install.forceUpdatesHint' => 'O app receberá as atualizações automáticas para as novas versões. Alerta: Utilize esta opção com cuidado porque as atualizações podem afetar significantemente a funcionalidade do app. Por exemplo, as extensões de app podem parar de trabalhar com outra versão do app.',

    'aps.invalid-requirements.requirementsLegend' => 'Requisitos',
    'aps.invalid-requirements.domainLegend' => 'Site',
    'aps.invalid-requirements.context' => 'Escolha outro website.',
    'aps.invalid-requirements.backToApplicationList' => 'Voltar à lista de aplicativos',

    'aps.license.title' => 'Instalação do %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Para instalar este aplicativo, você tem de ler o acordo de licença do usuário final e concordar com seus termos.',
    'aps.license.licenseAgree' => 'Aceito os termos do Acordo de Licença.',

    'aps.services-list-customization.settings' => 'Configurações',

    'asp-dot-net.change-version.title' => 'Selecionar a versão do ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'Versão do framework ASP.NET',
    'asp-dot-net.change-version.success' => 'A versão do ASP.NET foi alterada.',

    'asp-dot-net.settings.casSettingsSection' => "Segurança de acesso do código",
    'asp-dot-net.settings.clientScriptsSection' => "Configurações da biblioteca de scripts",
    'asp-dot-net.settings.connStringsSection' => "Gerenciador de string de conexão",
    'asp-dot-net.settings.customErrorsSection' => "Configurações de erro customizado",
    'asp-dot-net.settings.frameworkVersionSection' => "Versão do framework",
    'asp-dot-net.settings.globalizationSection' => "Configurações de globalização",
    'asp-dot-net.settings.otherSection' => "Configurações de sessão",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilação e depuração",
    'asp-dot-net.settings.authMode' => "Modo de autenticação",
    'asp-dot-net.settings.connStrings' => "Strings de conexão",
    'asp-dot-net.settings.connStringsInvalid' => "Alguns campos estão vazios ou contêm um valor incorreto.",
    'asp-dot-net.settings.connStringName' => "Nome",
    'asp-dot-net.settings.connStringValue' => "Parâmetros de conexão",
    'asp-dot-net.settings.connStringsDescription' => "Nome / Parâmetros de Conexão",
    'asp-dot-net.settings.culture' => "Cultura",
    'asp-dot-net.settings.customErrMode' => "Modo de erro customizado",
    'asp-dot-net.settings.customErrorRedirect' => "URL de redirecionamento",
    'asp-dot-net.settings.customErrorStatus' => "Código de status",
    'asp-dot-net.settings.customErrorStatusInvalid' => "O código de status deve ser um número inteiro.",
    'asp-dot-net.settings.customErrors' => "Erros customizados",
    'asp-dot-net.settings.customErrorsDescription' => "Código de Status / URL de redirecionamento",
    'asp-dot-net.settings.customErrorsInvalid' => "Alguns campos estão vazios ou contêm um valor incorreto.",
    'asp-dot-net.settings.debugMode' => "Ativar a depuração",
    'asp-dot-net.settings.defLanguage' => "Idioma padrão da página da web",
    'asp-dot-net.settings.tempDirectory' => "Diretório temporário",
    'asp-dot-net.settings.fileEnc' => "Codificação de arquivos",
    'asp-dot-net.settings.fileEncInvalid' => "O valor especificado para o parâmetro de codificação do arquivo é inválido.",
    'asp-dot-net.settings.pathToLib' => "Caminho para a biblioteca de scripts da Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Instalar",
    'asp-dot-net.settings.reqEnc' => "Codificação do pedido",
    'asp-dot-net.settings.reqEncInvalid' => "O valor especificado para o parâmetro de codificação da requisição é inválido.",
    'asp-dot-net.settings.resEnc' => "Codificação de resposta",
    'asp-dot-net.settings.resEncInvalid' => "O valor especificado para o parâmetro de codificação da resposta é inválido.",
    'asp-dot-net.settings.sessTimeout' => "Timeout de sessão (minutos)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "O valor especificado para o parâmetro de codificação do tempo limite da sessão é inválido. Inserir um número inteiro positivo inferior ou igual a %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "O nome da string de conexão já está em uso.",
    'asp-dot-net.settings.customErrorInvalidCode' => "O código de status deve estar entre 100 e 999",
    'asp-dot-net.settings.customErrorDuplicate' => "O código de status já está em uso.",
    'asp-dot-net.settings.trustLevel' => "Nível de confiança do CAS",
    'asp-dot-net.settings.uiCulture' => "Cultura de IU",
    'asp-dot-net.settings.version' => "Versão",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Permitir substituir o nível de confiança CAS no web site',
    'asp-dot-net.settings.updateSuccess' => 'Atualização bem sucedida',

    'database.clone.formDescription' => 'Copiar os conteúdos da base de dados em uma nova ou existente base de dados. Quando copiadas para uma base de dados existente, as tabelas da base de dados-fonte são adicionadas à lista de tabelas na base de dados-destino. Aviso: Se os nomes da tabela coincidirem, então a tabela da fonte substituirá aquela no destino.',
    'database.clone.copyData' => 'Criar uma cópia completa',
    'database.clone.copyDataHint' => 'Se selecionada, toda a base de dados (incluindo a estrutura e os dados) será copiada. Se não estiver selecionada, somente a estrutura das tabelas será copiada.',
    'database.clone.server' => 'Servidor de banco de dados de destino',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Outros...',
    'database.clone.database' => 'Banco de dados de destino',
    'database.clone.newDatabase' => 'Criar banco de dados com nome',
    'database.clone.existingDatabase' => 'Copiar para o banco de dados existente',
    'database.clone.externalDbHost' => 'Nome do host ou endereço IP',
    'database.clone.externalDbLogin' => 'Nome do usuário',
    'database.clone.externalDbPassword' => 'Senha',
    'database.clone.subscription' => 'Assinatura de destino',
    'database.clone.subscription_powerUser' => 'Espaço web de destino',
    'database.clone.cloneInProgress' => 'Clonagem do banco de dados %%source%% para o banco de dados %%destination%%.  Você será notificado sobre o andamento via e-mail (%%email%%).',
    'database.clone.unableToClone' => 'Não foi possível copiar o banco de dados "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Não foi possível criar um banco de dados no servidor especificado em "%%destination%%".',
    'database.clone.databaseCloned' => 'O banco de dados "%%source%%" foi copiado.',
    'database.clone.emailSubjSuccess' => 'O banco de dados "%%sourceDatabase%%" foi copiado.',
    'database.clone.emailSubjFailure' => 'Falha na cópia do banco de dados "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'O banco de dados "%%sourceDatabase%%" (%%sourceHost%%) foi copiado para o banco de dados "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Não foi possível copiar o banco de dados "%%sourceDatabase%%" (%%sourceHost%%) para o banco de dados "%%destDatabase%%" (%%destHost%%). O procedimento de cópia falhou.',
    'database.clone.localServer' => 'servidor local',

    'database.repair-orphaned.formDescription' => 'Este usuário torna-se "órfão" após o processo de restauração. Forneça uma senha para este usuário e corrija o problema. Se este usuário tiver que ser um usuário do sistema sem senha, execute o utilitário de reparo com o campo de senha vazio.',
    'database.repair-orphaned.login' => 'Nome de usuário do banco de dados',
    'database.repair-orphaned.pass' => 'Senha',
    'database.repair-orphaned.pass2' => 'Confirmar senha',
    'database.repair-orphaned.users' => 'Alguns usuários exigem sua atenção. Há vários usuários "órfãos" que devem ser reparados para funcionar adequadamente.',
    'database.repair-orphaned.orphaned' => 'O usuário está "órfão". %%gui begin:link%%Reparar agora%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparar',

    'database.repair.fixSelected' => 'Reparo Selecionado',
    'database.repair.fix' => 'Reparar',

    'database.user.password' => 'Senha',
    'database.user.passwordConfirmation' => 'Confirmar senha',
    'database.user.server' => 'Servidor do banco de dados',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Banco de dados',
    'database.user.anyDatabase' => 'Qualquer',
    'database.user.dataAccess' => 'Acesso aos Dados',
    'database.user.structureAccess' => 'Acesso à Estrutura',
    'database.user.globalAccess' => 'Privilégios Globais',
    'database.user.globalAccessHint' => 'Os privilégios globais funcionam para todas as bases de dados nesta conta de hospedagem.',
    'database.user.aclRadio' => 'Controle de acesso',
    'database.user.aclLocalhost' => 'Permitir somente conexões locais',
    'database.user.aclAny' => 'Permitir conexões remotas de qualquer host',
    'database.user.aclCustom' => 'Permitir conexões remotas de',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados têm permissão para acessar o banco de dados em nome deste usuário.",
    'database.user.remoteAccess' => 'Acesso remoto',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nOs endereços IP especificados têm permissão para acessar o servidor de banco de dados por meio de uma regra de firewall. Suas alterações nesta lista serão pré-moderadas pelo seu provedor de hospedagem.",
    'database.user.example' => "Por exemplo:\n%%example%%",
    'database.user.denied' => 'Use as regras de firewall do sistema',
    'database.user.allowed' => 'Permitir conexões remotas de',
    'database.user.default' => 'Utilizar as credenciais do usuário por padrão para avaliar o %%webadmin%%',
    'database.user.remoteAccessHint' => 'Por favor, entre em contato com seu provedor de hospedagem e certifique-se que a opção especificada acima esteja em conformidade com as atuais regras de firewall, para o acesso da entrada ao MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Administração de Web',
    'database.user.role' => 'Função',
    'database.user.roleReadWrite' => 'Ler e Gravar',
    'database.user.roleWriteOnly' => 'Apenas Gravar',
    'database.user.roleReadOnly' => 'Somente leitura',
    'database.user.roleCustom' => 'Customizar',

    'database.generalSection' => 'Geral',
    'database.name' => 'Nome do banco de dados',
    'database.server' => 'Servidor do banco de dados',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Site relacionado',
    'database.noDomainRelations' => 'Nenhum site relacionado',
    'database.userSection' => 'Usuários',
    'database.userSectionDescription' => 'Criar um usuário do banco de dados padrão. O Plesk acessará o banco de dados em nome desse usuário. Se nenhum usuário de banco de dados estiver atribuído no banco de dados, ele não será acessível.',
    'database.createUser' => 'Criar um usuário das bases de dados',
    'database.username' => 'Nome do usuário do banco de dados',
    'database.password' => 'Senha',
    'database.passwordConfirmation' => 'Confirmar senha',
    'database.allDbAccess' => 'O usuário tem acesso a todas as bases de dados na assinatura selecionada',
    'database.aclRadio' => 'Controle de acesso',
    'database.aclLocalhost' => 'Permitir somente conexões locais',
    'database.aclAny' => 'Permitir conexões remotas de qualquer host',
    'database.aclCustom' => 'Permitir conexões remotas de',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nOs hosts especificados têm permissão para acessar o banco de dados em nome deste usuário.",
    'database.remoteAccess' => 'Acesso remoto',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nOs endereços IP especificados têm permissão para acessar o servidor de banco de dados por meio de uma regra de firewall. Suas alterações nesta lista serão pré-moderadas pelo seu provedor de hospedagem.",
    'database.example' => "Por exemplo:\n%%example%%",
    'database.denied' => 'Use as regras de firewall do sistema',
    'database.allowed' => 'Permitir conexões remotas de',

    'deployment-section.deploymentDisabledHint' => 'Fazer o upload dos arquivos de um repositório Git.',
    'deployment-section.deploymentEnabledHint' => 'Ativar suporte Git',
    'deployment-section.deploymentSectionLegend' => 'Seus arquivos para copiar para hospedagem',
    'deployment-section.deploymentSectionDescriptionHint' => 'Se você deixar o suporte Git desabilitado, os diretórios root (website/aplicativo root e documento root) serão criados vazios, e o site exibirá a página padrão no navegador. Você precisará fazer o upload dos arquivos do seu site para o documento root usando FTP ou Gerenciador de arquivo. Alternativamente, habilite o Git agora ou depois (em Websites e Domínios) e faça o upload os arquivos de um repositório Git.',

    'dns-zone.add-acl-record.description' => 'Adicionar um endereço de IP de um servidor DNS permitido para receber uma cópia da zona DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Endereço IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Máscara/endereço IP',

    'dns-zone.record.add-title' => "Adicionar registro de recursos ao modelo de zona",
    'dns-zone.record.add-ns-title' => "Adicionar servidor de nomes",
    'dns-zone.record.edit-title' => "Editar registro de recursos",
    'dns-zone.record.edit-success' => "O registro DNS foi atualizado.",
    'dns-zone.record.add-success' => "O registro DNS foi criado.",
    'dns-zone.record.type' => "Tipo de registro",
    'dns-zone.record.domainName' => "Nome do domínio",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Servidor de nomes",
    'dns-zone.record.protocol' => "Protocolo",
    'dns-zone.record.priority' => "Prioridade",
    'dns-zone.record.priorityLow' => "baixa (%%priority%%)",
    'dns-zone.record.priorityHigh' => "muito alta (%%priority%%)",
    'dns-zone.record.weightLow' => "baixa (%%weight%%)",
    'dns-zone.record.weightHigh' => "muito alta (%%weight%%)",
    'dns-zone.record.ipAddress' => "Endereço IP",
    'dns-zone.record.ipAddressDescription' => "Por exemplo, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Por exemplo, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Endereço IPv6",
    'dns-zone.record.ipAddressV6Description' => "Por exemplo, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Por exemplo, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Por exemplo, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Por exemplo, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Por exemplo, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nome canônico",
    'dns-zone.record.mailDomain' => "Domínio de e-mail",
    'dns-zone.record.mxServer' => "Servidor de troca de e-mails",
    'dns-zone.record.mxServerPriority' => "Especifique a prioridade do servidor de troca de e-mails",
    'dns-zone.record.txtRecord' => "Registro TXT",
    'dns-zone.record.txtRecordString' => "Inserir uma string de registro",
    'dns-zone.record.txtSpfSyntax' => "Registro de SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Valores incorretos para o registro de TXT foram especificados.",
    'dns-zone.record.quotedTxtRecord' => "O valor do registro TXT deve ser uma string única sem aspas.",
    'dns-zone.record.dsRecord' => "Registro DS",
    'dns-zone.record.dsRecordDescription' => "Por exemplo, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Um valor incorreto para o registro DS foi especificado.",
    'dns-zone.record.serviceName' => "Nome do serviço",
    'dns-zone.record.serviceNameDescription' => 'Por exemplo, SIP (sem o caractere sublinhado).',
    'dns-zone.record.protocolNameDescription' => 'Por exemplo, tcp (sem o caractere sublinhado).',
    'dns-zone.record.portDescription' => 'Por exemplo, 25 (sem o caractere sublinhado).',
    'dns-zone.record.srvWeight' => "Peso relativo para registros com a mesma prioridade",
    'dns-zone.record.targetHost' => "Host de destino",
    'dns-zone.record.targetHostDescription' => "Por exemplo, exemplo.com",
    'dns-zone.record.targetPort' => "Porta de destino",
    'dns-zone.record.retrieveDataError' => "Os dados do registro não foram encontrados.",
    'dns-zone.record.unknownTypeError' => "Tipo de registro de DNS desconhecido.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Não é possível configurar o registro MX NULL enquanto outros registros MX estiverem presentes.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Não é possível configurar o registro MX que não seja NULL enquanto o registro NULL MX estiver presente.',
    'dns-zone.record.masterShouldBeRemote' => "Você deve ter dois servidores de nomes diferentes autoritativos em hosts separados.",
    'dns-zone.record.caaTag' => "Marcar",
    'dns-zone.record.caaRecord' => "Valor",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Porta',
    'dns-zone.record.tlsaProtocol' => 'Protocolo',
    'dns-zone.record.tlsaUsage' => 'Uso',
    'dns-zone.record.tlsaSelector' => 'Seletor',
    'dns-zone.record.tlsaMatching' => 'Tipo de correspondência',
    'dns-zone.record.tlsaCertData' => 'Dados de associação do certificado',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Consulte %%link%% para obter mais detalhes',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, seção 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, seção 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, seção 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, seção 2.1.4',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Segundos",
    'dns-zone.record.invalidValue' => 'O valor é inválido. Pode ser de 1 segundo a 2147483647 segundos.',
    'dns-zone.record.ttlDefaultValue' => 'Valor padrão: %%value%% segundos',
    'dns-zone.record.invalidTTL' => 'O valor TTL especificado é inválido.',
    'dns-zone.record.invalidIpAddress' => 'O endereço IP especificado é inválido.',
    'dns-zone.record.invalidIpMaskPair' => 'O par de endereço IP/máscara de rede especificado é inválido.',
    'dns-zone.record.invalidCName' => 'O nome canônico especificado é inválido.',
    'dns-zone.record.invalidPort' => 'A porta especificada é inválida.',
    'dns-zone.record.invalidTLSACertData' => 'Os dados especificados de associação do certificado são inválidos.',
    'dns-zone.record.invalidTLSAProtocol' => 'O protocolo especificado é inválido.',
    'dns-zone.record.invalidTLSAUsage' => 'O uso especificado é inválido.',
    'dns-zone.record.invalidTLSASelector' => 'O seletor especificado é inválido.',
    'dns-zone.record.invalidTLSAMatching' => 'O tipo de correspondência especificado é inválido.',

    'dns-zone.restore-default.formHint' => "Aqui você pode restaurar a configuração da zona original, em conformidade com as configurações do modelo DNS padrão utilizado no servidor. Selecione os endereços IP a serem utilizados para restaurar a zona e especificar se um alias de www é necessário para o domínio.",
    'dns-zone.restore-default.ipv4' => "Endereço IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Por exemplo, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Endereço IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Por exemplo, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'O endereço IP especificado é inválido.',
    'dns-zone.restore-default.customIpHint' => "Os registros com este endereço de IP serão considerados como um usuário modificado e não sincronizará com o modelo DNS no tamanho do servidor.",
    'dns-zone.restore-default.wwwPrefix' => "Prefixo WWW",
    'dns-zone.restore-default.previewRecords' => "Restaurar os registros utilizados para a pré-visualização do site",

    'dns-zone.soa-record.soaMnameSection' => 'Servidor de nomes principal',
    'dns-zone.soa-record.soaMname' => 'Servidor de nomes',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Auto seleção)',
    'dns-zone.soa-record.soaRecordSection' => 'Registro SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Atualizar',
    'dns-zone.soa-record.retry' => 'Tentar novamente',
    'dns-zone.soa-record.expire' => 'Expirar',
    'dns-zone.soa-record.minimum' => 'Mínimo',
    'dns-zone.soa-record.rnameType' => 'E-mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'O endereço de e-mail da pessoa responsável pela zona DNS do domínio. Retornado pelo servidor DNS em resposta a consultas SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Endereço de e-mail do proprietário do site',
    'dns-zone.soa-record.rnameTypeDomain' => 'Endereço de e-mail do domínio',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Insira apenas a parte local (antes de @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Endereço de e-mail externo',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Proíbe a alteração do endereço de e-mail RNAME por domínio',
    'dns-zone.soa-record.invalidValue' => 'O valor é inválido. Ele pode ser de 1 segundo a 68 anos.',
    'dns-zone.soa-record.advancedSection' => 'Recursos avançados de DNS',
    'dns-zone.soa-record.serialNumberFormat' => 'Use o formato de número de série recomendado pela IETF e RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Selecione a opção caso seu domínio esteja com problemas para passar na verificação SOA do registrador. Muitos registradores de domínio exigem esse formato de número de série.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Use as configurações padrão',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Padrões de zona',
    'dns-zone.soa-record.unitSeconds' => 'segundos',
    'dns-zone.soa-record.unitMinutes' => 'minutos',
    'dns-zone.soa-record.unitHours' => 'horas',
    'dns-zone.soa-record.unitDays' => 'dias',
    'dns-zone.soa-record.unitWeeks' => 'semanas',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'O valor do intervalo de atualização é inferior a uma hora, o que pode aumentar criticamente o tráfego do servidor e o uso de recursos.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'A definição do valor TTL mínimo, que é superior a 3 horas, pode tornar os domínios inacessíveis para alguns dos administradores de domínios. Recomenda-se definir este valor somente se seu registrador de nomes de domínios insistir.',
    'dns-zone.soa-record.success' => 'As propriedades do registro SOA foram atualizadas.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'O registro SOA padrão foi restaurado.',

    'domain-info-section.domainName' => 'Nome do domínio',
    'domain-info-section.emptyDomainName' => 'Forneça um nome de domínio.',
    'domain-info-section.ipAddress' => 'Endereço IP',
    'domain-info-section.shared' => 'compartilhado',
    'domain-info-section.exclusive' => 'dedicado',
    'domain-info-section.ipAddressHint' => "O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website. Esse endereço IP será utilizado para todos os websites criados para a assinatura.",
    'domain-info-section.ipAddressHint_powerUser' => "O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website. Esse endereço IP será utilizado para todos os websites criados no espaço web.",
    'domain-info-section.userName' => 'Nome do usuário',
    'domain-info-section.userNameHint' => 'Conta do usuário do sistema associada ao espaço web, usada para acessar arquivos hospedados em FTP e SSH.',
    'domain-info-section.emptyLogin' => 'Forneça um nome de usuário.',
    'domain-info-section.password' => 'Senha',
    'domain-info-section.emptyPassword' => 'Forneça uma senha.',
    'domain-info-section.passwordConfirmation' => 'Repita a senha',

    'email-address.generalTab' => 'Geral',
    'email-address.generalHint' => 'Se esta conta de e-mail está associada a um usuário adicional (Acesso ao Painel de Controle está habilitado), as mudanças feitas nesta página afetarão as configurações do usuário. Particularmente, se você mudar o endereço de e-mail e a senha, o login e a senha do usuário auxiliar serão modificados também com os novos valores.',
    'email-address.redirectTab' => 'Redirecionamento',
    'email-address.redirectHint' => 'Configure o encaminhamento de mensagens de e-mail para um ou mais endereços de e-mail.',
    'email-address.aliasesTab' => 'E-mail alternativo',
    'email-address.autoResponderTab' => 'Resposta automática',
    'email-address.antispamTab' => 'Filtro de spam',
    'email-address.autoResponderHint' => 'Configure uma resposta automática para qualquer mensagem de e-mail destinada ao seu endereço de e-mail. A resposta automática é um modo-padrão para notificar seus correspondentes sobre sua ausência ou período de férias.',
    'email-address.antivirusTab' => 'Antivírus',
    'email-address.name' => 'Endereço de e-mail',
    'email-address.externalEmail' => 'Endereço de e-mail externo',
    'email-address.externalEmailHint' => 'Será usado para redefinir sua senha caso perca o acesso ao endereço de e-mail principal.',
    'email-address.user' => 'Atribuído a',
    'email-address.password' => 'Senha',
    'email-address.passwordConfirmation' => 'Confirmar senha',
    'email-address.responderEnable' => 'Ativar a resposta automática',
    'email-address.responderSubject' => 'Assunto da mensagem de resposta automática',
    'email-address.responderContentType' => 'Formato da mensagem',
    'email-address.responderContentTypeHint' => 'O formato de texto simples é suportado por todos os programas cliente de e-mail. Desse modo, todos os destinatários visualizarão a mensagem no mesmo formato que lhe é apresentado. As mensagens em HTML têm uma aparência melhor, pois permitem a digitação de textos formatados com diferentes estilos de fonte. No entanto, alguns clientes de e-mail não suportam mensagens em HTML, e alguns dos destinatários podem não visualizar o texto formatado.',
    'email-address.responderContentTypeTextPlain' => 'Texto sem formatação',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codificação',
    'email-address.responderCodepageHint' => 'A codificação define como os caracteres do texto são exibidos. É recomendada a codificação UTF-8.',
    'email-address.responderReplyTo' => 'Redirecionar para',
    'email-address.responderReplyToHint' => 'Quando a resposta automática for enviada, a mensagem original será redirecionada para o endereço de e-mail especificado.',
    'email-address.responderForwardAddress' => 'Redirecionar para',
    'email-address.responderForwardAddressHint' => 'Quando a resposta automática for enviada, a mensagem original será redirecionada para o endereço de e-mail especificado.',
    'email-address.responderMessage' => 'Texto da mensagem de resposta automática',
    'email-address.responderReplyToEqualsEmail' => 'O endereço de redirecionamento especificado é igual a este endereço de e-mail.',
    'email-address.responderForwardAddressEqualsEmail' => 'O endereço de redirecionamento especificado é igual a este endereço de e-mail.',
    'email-address.responderReplyLimit' => 'Envie uma resposta automática para um endereço de e-mail exclusivo não mais que (vezes em um dia)',
    'email-address.buttonAddResponderAttachment' => 'Adicionar Anexo',
    'email-address.buttonRemoveResponderAttachment' => 'Remover',
    'email-address.responderAttachment' => 'Anexar um arquivo',
    'email-address.redirectEnable' => 'Ativar o redirecionamento de e-mail',
    'email-address.redirectRemoveEnable' => 'Não entregue cópias de e-mails encaminhados para a caixa de correio do Plesk',
    'email-address.redirectAddress' => 'Mensagens de entrada direta para o seguinte endereço de e-mail',
    'email-address.redirectAddressHint' => 'Especifique os endereços de e-mail. Você pode digitar cada endereço em uma nova linha ou separar os endereços por espaço em branco, vírgula ou ponto e vírgula.',
    'email-address.role' => 'Função do usuário',
    'email-address.roleHint' => 'As funções de usuário concedem aos usuários privilégios administrativos e acesso a aplicativos que você seleciona para a função.',
    'email-address.errorRedirectAddress' => 'Você especificou um endereço de e-mail inválido: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Você especificou endereços de e-mail inválidos. %value%.',
    'email-address.mailAlias' => "E-mail alternativo",
    'email-address.mailAliasNone' => 'Nenhum',
    'email-address.mailAliasHint' => "Os nomes alternativos de e-mail são endereços associados a um endereço de e-mail primário. Todos os e-mails enviados aos nomes alternativos serão recebidos pelo endereço de e-mail primário.",
    'email-address.buttonAddMailAlias' => 'Adicionar e-mail alternativo',
    'email-address.buttonRemoveMailAlias' => 'Remover',
    'email-address.emptyEmail' => 'Especifique o endereço de e-mail para o qual todas as mensagens de entrada devem ser redirecionadas.',
    'email-address.emailsIsEqual' => 'O endereço de e-mail externo corresponde ao principal. Especifique um endereço de e-mail externo diferente.',
    'email-address.emptyPassword' => 'Você precisa fornecer uma senha.',
    'email-address.emptyPasswordConfirmation' => 'Você precisa confirmar a senha.',
    'email-address.emptyAlias' => "Especifique um nome alternativo de e-mail para este endereço de e-mail.",
    'email-address.aliasEqualsEmail' => 'O nome alternativo de e-mail especificado é o mesmo do endereço de e-mail.',
    'email-address.passwordHint' => 'Será usado para acessar a caixa de correio e para efetuar login no Plesk (caso a opção correspondente estiver ativada).',
    'email-address.cyclicRedirect' => 'O endereço de e-mail não pode ser configurado para redirecionar mensagens de e-mail para o mesmo endereço.',
    'email-address.errorMailnameReserved' => 'O endereço de e-mail especificado já está sendo utilizado.',
    'email-address.antivirusEnable' => 'Troque a proteção do antivírus para este endereço de e-mail',
    'email-address.antivirusHint' => 'O serviço antivírus bloqueia mensagens de e-mail que contêm vírus e notifica o remetente e o destinatário sobre o ocorrido.',
    'email-address.antivirusSettings' => 'Verificar se há vírus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'apenas e-mail de entrada',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'apenas e-mail de saída',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'e-mail de entrada e saída',
    'email-address.antispamHint' => 'O serviço de filtragem de spam detecta mensagens de spam enviadas ao endereço de e-mail.  Você pode ajustar o filtro de spam para excluir as mensagens de spam, marcá-las como spam, alterando seu assunto, ou movê-las para a pasta especial de spam, que pode ser acessada por clientes de e-mail por meio do IMAP. O filtro de spam aplica uma grande variedade de testes locais e de rede para identificar assinaturas de spam.',
    'email-address.antispamEnable' => 'Trocar o filtro de spam para este endereço de e-mail',
    'email-address.antispamSettings' => 'O que fazer com mensagens classificadas como spam',
    'email-address.antispamSettingsMark' => 'Marque as mensagens de spam, adicionando o seguinte texto ao assunto da mensagem.',
    'email-address.antispamSettingsMarkHint' => 'As mensagens de spam serão colocadas em sua caixa de entrada e você será capaz de reconhecê-las facilmente pelo assunto. Você também pode configurar seu programa cliente de e-mail para filtrar mensagens por assunto.',
    'email-address.antispamReportTextHint' => 'Digite o texto a ser adicionado ao corpo das mensagens de e-mail de spam.',
    'email-address.antispamSettingsDelete' => 'Excluir todas as mensagens de spam',
    'email-address.antispamSettingsDeleteHint' => 'As mensagens de spam serão excluídas de sua caixa postal.',
    'email-address.antispamSettingsMove' => 'Mover spam para a pasta Spam',
    'email-address.antispamSettingsMoveHint' => 'Todas as mensagens de spam serão movidas para a pasta chamada Spam. Essa pasta pode ser acessada de seu programa cliente de e-mail ou webmail. Se estiver utilizando uma conta de e-mail IMAP, você poderá utilizar a pasta Spam para treinar o filtro de spam.',
    'email-address.antispamSettingsMoveWarning' => '"Mover spam para a pasta Spam" não funciona a menos que você desative a opção "Não entregar cópias de e-mails encaminhados" na guia "Encaminhamento".',
    'email-address.antispamSettingsMoveJunk' => 'Mover spam para a pasta “Lixo Eletrônico”',
    'email-address.antispamSettingsMoveJunkHint' => 'Todas as mensagens de spam serão movidas para a pasta chamada “Lixo Eletrônico”. Essa pasta pode ser acessada do seu programa de cliente de e-mail ou webmail. Se estiver utilizando uma conta de e-mail IMAP, você poderá utilizar a pasta “Lixo Eletrônico” para treinar o filtro de spam.',
    'email-address.antispamShowAdvancedSection' => 'Exibir configurações avançadas',
    'email-address.antispamHideAdvancedSection' => 'Ocultar configurações avançadas',
    'email-address.antispamLearnMore' => 'Saiba como treinar o filtro de spam.',
    'email-address.antispamFilterScoreTitle' => 'Sensibilidade do filtro',
    'email-address.antispamFilterScoreHint' => 'O filtro de spam executa vários testes diferentes no conteúdo e na linha de assunto de cada mensagem.  Como resultado, para cada mensagem, uma pontuação é registrada. Quanto maior a pontuação, maior a chance da mensagem ser um spam. Como padrão, a sensibilidade do filtro é ajustada de modo que todas as mensagens com uma pontuação igual a sete ou superior sejam classificadas como spam. Caso receba várias mensagens de spam com a configuração atual, aumente a sensibilidade do filtro, definindo um valor menor  por exemplo, seis. Se estiver perdendo e-mails, porque o filtro de spam os considera lixo, reduza a sensibilidade do filtro, definindo um valor maior  por exemplo, oito.',
    'email-address.antispamFilterScore' => 'Sensibilidade do filtro de spam',
    'email-address.antispamWhiteListTitle' => 'Lista branca',
    'email-address.antispamWhiteListHint' => 'E-mails de remetentes na lista branca não são verificados pelo filtro de spam.',
    'email-address.antispamWhiteListField' => 'Lista branca',
    'email-address.antispamWhiteListFieldHint' => 'Digite nomes de domínio, um nome de domínio por linha. Os endereços podem conter os caracteres curinga "*" e "?", por exemplo, *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Lista negra',
    'email-address.antispamBlackListHint' => 'E-mails de remetentes na lista de bloqueios são classificados como spam.',
    'email-address.antispamBlackListField' => 'Lista negra',
    'email-address.antispamBlackListFieldHint' => 'Digite nomes de domínio, um domínio por linha. Os endereços podem conter os caracteres curinga "*" e "?", por exemplo, *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Idiomas confiáveis',
    'email-address.antispamTrustedLanguagesHint' => 'As mensagens de e-mail escritas nesses idiomas sempre passarão pelo filtro.',
    'email-address.antispamTrustedLocalesTitle' => 'Localidades confiáveis',
    'email-address.antispamTrustedLocalesHint' => 'As mensagens de e-mail que utilizam os grupos de localidade especificados sempre passarão pelo filtro.  Os grupos de localidade incluem os conjuntos de caracteres mais comumente utilizados. Por exemplo, o conjunto de caracteres ocidentais inclui codificações para letras utilizadas no inglês e em idiomas da Europa Ocidental.',
    'email-address.antispamTrustedNetworksTitle' => 'Redes confiáveis',
    'email-address.antispamTrustedNetworksHint' => 'Os relayhosts em redes confiáveis não são considerados potencialmente operados por spammers e não são relays abertos ou proxies abertos.',
    'email-address.antispamIpAddressesField' => 'Endereços IP',
    'email-address.antispamIpAddressesFieldHint' => 'Especifique o endereço IP e a máscara da rede.',
    'email-address.mailBoxQuotaDomainDefault' => 'Tamanho-padrão (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Tamanho-padrão',
    'email-address.mailBoxOutgoingMessages' => 'Número máximo de mensagens de e-mail de saída',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Padrão (%%domainOutgoingMessages%% mensagens por hora)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valor customizado para a caixa de e-mail',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'mensagens',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Padrão',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Tamanho-padrão',
    'email-address.mailBoxQuotaDomainSpecific' => 'Outro tamanho',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Tamanho da caixa postal',
    'email-address.mailBoxQuotaUnlimited' => 'Ilimitado',
    'email-address.mailBoxLimitReached' => 'O limite no número de caixas de e-mail foi atingido.',
    'email-address.postboxEnabled' => 'Caixa postal',
    'email-address.postboxEnabledYes' => 'Liga',
    'email-address.postboxEnabledNo' => 'Desliga',
    'email-address.description' => 'Descrição no Plesk',
    'email-address.descriptionHint' => 'A descrição é visível a todos que tiverem acesso a esta conta de e-mail.',
    'email-address.longDescription' => 'A descrição especificada é muito longo. Ele não pode ter mais que %%max%% símbolos.',
    'email-address.loginAsUser' => 'Pode ser usado para efetuar login no Plesk',
    'email-address.loginAsUserDescription' => '(nome de usuário: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'O tamanho da caixa de correio não pode ultrapassar o tamanho padrão.',
    'email-address.endDateEnable' => 'Desativar a resposta automática em',

    'failed-request.enable-tracing.description' => 'O rastreamento das solicitações falhas é uma operação intensiva de recursos. O rastreamento será interrompido automaticamente em %%days%% dias. Você pode desligá-lo manualmente a qualquer momento.',
    'failed-request.enable-tracing.statusCodes' => 'Códigos de status',
    'failed-request.enable-tracing.statusCodesDescription' => 'Por exemplo: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Provedor',

    'file-manager.show.buttonReload' => 'Recarregar',
    'file-manager.show.buttonSave' => 'Salvar',
    'file-manager.show.buttonSaveAs' => 'Salvar como',
    'file-manager.show.buttonReset' => 'Reinicializar',
    'file-manager.show.buttonTextCodeEditor' => 'Editar no Editor de Código',
    'file-manager.show.buttonTextEdit' => 'Editar no Editor de Texto',
    'file-manager.show.buttonWysiwygEdit' => 'Editar no Editor de HTML',
    'file-manager.show.eolLabel' => 'Tipo de quebra de linha:',
    'file-manager.show.saveAs' => 'Salvar como:',
    'file-manager.show.saveCodepage' => 'Salvar na seguinte codificação:',
    'file-manager.show.loadCodepage' => 'Ver o arquivo original na seguinte codificação:',
    'file-manager.show.loadCodepageHint' => 'Alerta: Ao recarregar o arquivo todas as alterações não salvas serão perdidas.',
    'file-manager.show.fileExists' => "Já existe o arquivo ou a pasta %%fileName%%. Você não pode ter uma pasta e um arquivo com o mesmo nome.",
    'file-manager.show.popupTitle' => 'Salvar como',
    'file-manager.show.popupFilename' => 'Nome do arquivo:',

    'file-manager.permissions.filePermissions' => 'Permissões de arquivo',
    'file-manager.permissions.directoryPermissions' => 'Permissões de diretório',
    'file-manager.permissions.buttonSubmit' => 'Salvar',
    'file-manager.permissions.buttonApply' => 'Salvar e retomar',
    'file-manager.permissions.buttonCancel' => 'Cancelar',
    'file-manager.permissions.buttonAdvanced' => 'Avançado',

    'file-manager.unix-file-permissions.group' => 'Grupo',
    'file-manager.unix-file-permissions.owner' => 'Proprietário',
    'file-manager.unix-file-permissions.others' => 'Outros',
    'file-manager.unix-file-permissions.readMode' => 'Ler',
    'file-manager.unix-file-permissions.writeMode' => 'Gravar',
    'file-manager.unix-file-permissions.execMode' => 'Busca/execução',
    'file-manager.unix-file-permissions.changeRecursive' => 'Alterar permissões recursivamente',

    'file-manager.windows-permissions.allow' => 'Permitir',
    'file-manager.windows-permissions.deny' => 'Negar',
    'file-manager.windows-permissions.inheritFromParent' => 'Permitir que as permissões herdáveis do pai sejam propagadas a este objeto e a todos os objetos filho. Incluí-las nas entradas explicitamente definidas aqui',
    'file-manager.windows-permissions.replaceOnChildren' => 'Substituir as entradas de permissão em todos os objetos filho com as entradas mostradas aqui',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avançado',
    'file-manager.windows-permissions.applyTo' => 'Aplicar a:',
    'file-manager.windows-permissions.folderOnly' => 'Somente esta pasta',
    'file-manager.windows-permissions.subfolderOnly' => 'Somente subpastas',
    'file-manager.windows-permissions.filesOnly' => 'Somente arquivos',
    'file-manager.windows-permissions.permissionsFor' => 'Permissões para',
    'file-manager.windows-permissions.applyOnto1' => 'Somente esta pasta',
    'file-manager.windows-permissions.applyOnto2' => 'Somente subpastas',
    'file-manager.windows-permissions.applyOnto3' => 'Esta pasta e subpastas',
    'file-manager.windows-permissions.applyOnto4' => 'Somente arquivos',
    'file-manager.windows-permissions.applyOnto5' => 'Esta pasta e arquivos',
    'file-manager.windows-permissions.applyOnto6' => 'Somente subpasta e arquivos',
    'file-manager.windows-permissions.applyOnto7' => 'Esta pasta, subpastas e arquivos',
    'file-manager.windows-permissions.notInherited' => '<não herdado>',

    'file-manager.editor.titleTextEditor' => 'Editor de texto',
    'file-manager.editor.titleCodeEditor' => 'Editor de Código',
    'file-manager.editor.titleCodeViewer' => 'Exibir',
    'file-manager.editor.buttonSubmit' => 'Salvar',
    'file-manager.editor.buttonApply' => 'Salvar e retomar',
    'file-manager.editor.buttonSaveAs' => 'Salvar como ...',
    'file-manager.editor.buttonCancel' => 'Cancelar',
    'file-manager.editor.exitConfirmationYes' => 'Sim',
    'file-manager.editor.exitConfirmationNo' => 'Não',
    'file-manager.editor.fileOverwrite' => 'O arquivo já existe.',
    'file-manager.editor.fileOverwriteDescription' => 'Um arquivo com o mesmo nome já existe. Você deseja atribuí-la?',
    'file-manager.editor.exitConfirmation' => 'Tem certeza de que deseja fechar o arquivo e descartar as alterações não salvas?',
    'file-manager.editor.buttonCodeEditor' => 'Editar no Editor de Código',
    'file-manager.editor.buttonTextEditor' => 'Editar no Editor de Texto',
    'file-manager.editor.buttonHtmlEditor' => 'Editar no Editor de HTML',

    'file-manager.import-file.buttonSubmit' => 'Importar',
    'file-manager.import-file.fieldUrl' => 'URL para o arquivo',
    'file-manager.import-file.fieldUrlDescription' => 'Especifique a URL de origem, por exemplo, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'O padrão de URL completo é o seguinte: \'https://user:password@example.com/example.tgz\'. O nome de usuário e a senha são opcionais. Os protocolos suportados são http, https, ftp, ftps. Use a codificação de URL para partes de URL que contêm caracteres especiais ou espaços.',
    'file-manager.import-file.failure' => 'Não foi possível importar o arquivo.',

    'file-manager.rotation-settings.title' => 'Configurações de Rotação da Lixeira',
    'file-manager.rotation-settings.rotationBySize' => 'Rotação por tamanho',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'A opção exclui novos arquivos, desde que o limite especificado para a lixeira seja excedido.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotação por data',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dias',
    'file-manager.rotation-settings.rotationByDateHint' => 'A opção exclui arquivos armazenados na lixeira por mais de um determinado número de dias.',
    'file-manager.rotation-settings.save' => 'Salvar',
    'file-manager.rotation-settings.cancel' => 'Cancelar',

    'ftp-user.description' => 'Se você estiver trabalhando em seu site juntamente com outra pessoa ou com subdomínios de um host para outros usuários, você pode querer criar contas de FTP separadas para essas pessoas.',
    'ftp-user.generalSection' => 'Geral',
    'ftp-user.login' => 'Nome da conta de FTP',
    'ftp-user.home' => 'Diretório Home',
    'ftp-user.systemArea' => 'Crie uma conta FTP com acesso aos arquivos fora do diretório principal',
    'ftp-user.password' => 'Senha',
    'ftp-user.passwordConfirmation' => 'Confirmar senha',
    'ftp-user.hardQuotaSection' => 'Cota do disco rígido',
    'ftp-user.hardQuota' => 'Cota do disco rígido',
    'ftp-user.hardQuotaUnlimited' => 'Ilimitado',
    'ftp-user.permissionsSection' => 'Permissões',
    'ftp-user.permissionRead' => 'Permissão de leitura',
    'ftp-user.permissionWrite' => 'Permissão de gravação',
    'ftp-user.popupTitle' => 'Selecione um diretório',

    'mail-list.listName' => 'Endereço de mala direta',
    'mail-list.enabled' => 'Ativado',
    'mail-list.administratorEmail' => 'E-mail do administrador de lista de mala direta',
    'mail-list.password' => 'Senha',
    'mail-list.passwordConfirmation' => 'Confirmar senha',
    'mail-list.subscribers' => 'Assinantes',
    'mail-list.subscribersHint' => 'Especifique os endereços de e-mail. Você pode digitar cada endereço em uma nova linha ou separar os endereços por espaço em branco, vírgula ou ponto e vírgula.',
    'mail-list.notify' => 'Notificar o administrador sobre a criação da mala direta',
    'mail-list.emptyPassword' => 'Fornecer senha.',
    'mail-list.emptyPasswordConfirmation' => 'Confirme a senha.',
    'mail-list.errorSubscribers' => 'Endereços de e-mail inválidos: %value%.',
    'mail-list.errorMaillistReserved' => 'O endereço de mala direta especificado já é utilizado.',

    'mail-settings.hint' => 'Aqui é onde você pode alterar as configurações de serviço de e-mail para este domínio.',
    'mail-settings.service' => 'Serviço de e-mail neste domínio',
    'mail-settings.nonExist' => 'O que fazer com mensagens enviadas para usuários inexistentes',
    'mail-settings.nonExistBounceWithMessage' => 'Devolução com mensagem',
    'mail-settings.nonExistBounce' => 'Devolução',
    'mail-settings.nonExistCatch' => 'Redirecionar para endereço',
    'mail-settings.nonExistCatchDescription' => 'O endereço de e-mail deve pertencer ao domínio selecionado. Somente o administrador pode especificar um endereço externo ou um endereço para diversos domínios.',
    'mail-settings.nonExistExternal' => 'Redirecione um servidor de e-mail externo com o endereço de IP',
    'mail-settings.nonExistReject' => 'Rejeitar',
    'mail-settings.nonExistDiscard' => 'Rejeitar',
    'mail-settings.webmail' => 'WebMail',
    'mail-settings.webmailNone' => 'Nenhum',
    'mail-settings.webmailComponentNotInstalled' => 'O componente de webmail não foi instalado.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Existe um subdomínio com o nome %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificado SSL/TLS para o webmail.',
    'mail-settings.webmailCertificateNone' => 'Não selecionado',
    'mail-settings.mailCertificate' => 'certificado para e-mail SSL/TLS',
    'mail-settings.mailCertificateNone' => 'Não selecionado',
    'mail-settings.serverCertificateNotSelected' => 'O certificado foi atribuído, mas o correio do domínio não foi protegido. Para concluir a proteção de email para o domínio, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'proteger o servidor de email',
    'mail-settings.mailLists' => 'Habilitar malas diretas',
    'mail-settings.mailAutodiscovery' => 'Ativar descoberta automática de e-mail',
    'mail-settings.mailAutodiscoveryDescription' => 'Veja como ele funciona em %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'base de Conhecimento',
    'mail-settings.domainKeys' => 'Utilize o sistema de proteção contra spam DKIM para sinalizar as mensagens de e-mail de saída',
    'mail-settings.activeDkimSelector' => 'Seletor DKIM ativo',
    'mail-settings.defaultDkimSelector' => ' (Padrão Plesk)',
    'mail-settings.dkimSelectorName' => 'Nome do seletor',
    'mail-settings.buttonCreateSelector' => 'Criar novo seletor DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Criar novo seletor DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Remover seletor DKIM',
    'mail-settings.removeSelectorConfirmation' => "Remover o seletor '%%selector%%' junto com suas chaves e registros DNS associados?",
    'mail-settings.buttonConfirm' => 'OK',
    'mail-settings.buttonCreate' => 'Criar',
    'mail-settings.buttonCancel' => 'Cancelar',
    'mail-settings.labelRemoveSelector' => 'Remover',
    'mail-settings.labelActiveSelector' => 'Ativo',
    'mail-settings.greyListing' => 'Ative a proteção greylisting contra spam para suas contas de e-mail sob este domínio',
    'mail-settings.howToConfigureExternalDns' => 'Como configurar DNS externo',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Para habilitar a assinatura DKIM, caso use um servidor DNS externo, será necessário você configurar os registros DNS DKIM no servidor DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Para fazer isso, use os registros DKIM DNS abaixo:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Se você tiver aliases de domínio para enviar e-mail, adicione os registros DKIM DNS para eles também. Use os mesmos registros do domínio principal, mas com o nome alternativo do domínio.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Para ver os registros DKIM DNS que você precisa configurar, marque a caixa de seleção "%%option%%", aplique-a e abra este pop-up novamente.',
    'mail-settings.mailServiceDisabled' => 'Desabilitado',
    'mail-settings.mailServiceDisabledIncoming' => 'Desativado para e-mail recebido',
    'mail-settings.mailServiceDisabledHint' => 'O Plesk não fornecerá nenhum serviço de e-mail neste domínio.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Este domínio só pode enviar e-mail e somente usando o Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Habilitado',
    'mail-settings.mailServiceEnabledHint' => 'Este domínio pode enviar e receber e-mails.',
    'mail-settings.mailServiceNotConfigured' => 'Não configurado',
    'mail-settings.mailServiceNotConfiguredHint' => 'O Plesk não fornecerá nenhum serviço de e-mail neste domínio.',
    'mail-settings.warning' => 'Isso removerá permanentemente as caixas de e-mail do domínio com todos os emails recebidos e enviados.',
    'mail-settings.show.title' => 'Remova todas as caixas de e-mail e e-mails de %%domain%%',
    'mail-settings.show.checkbox' => 'Remova permanentemente todas as caixas de e-mail de <b>%%domain%%</b>, incluindo e-mails recebidos e enviados.',

    'role.roleSection' => 'Geral',
    'role.name' => 'Nome de função do usuário',
    'role.description' => 'Descrição',
    'role.generalPermissionsSection' => 'Acesso a serviços do Plesk',
    'role.applicationsAccessSection' => 'Acesso a aplicativos',
    'role.permissionAllow' => 'Concedido',
    'role.permissionDeny' => 'Negado',
    'role.emptyRoleName' => 'Forneça um nome de função.',
    'role.installedAt' => 'Instalado em',
    'role.noInstallationUrlAvailable' => 'Aplicativo externo',
    'role.invalidRoleName' => 'O nome de função do usuário especificado não é válido. Pontos de interrogação e aspas não podem ser utilizados no nome de função.',
    'role.longRoleName' => 'O nome de função do usuário especificado é muito longo.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Algumas operações podem não estar disponíveis pelos seguintes motivos: Nenhuma permissão para operação foi concedida para a assinatura selecionada ou a quantidade de recursos alocados não é suficiente para a execução da operação.',
    'role.servicesPermissionsDescription' => 'Defina o acesso a aplicativos instalados ou serviços do Plesk para todos os usuários com essa função. Se você conceder acesso a um aplicativo para um usuário, o aplicativo se tornará disponível para ele no Painel do Cliente.',
    'role.emailActivation' => 'Ativar as contas da função por e-mail',

    'service.admin-access.adminAccess' => 'Acesso administrativo',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Essas credenciais serão utilizadas para acesso administrativo ao aplicativo.',
    'service.admin-access.login' => 'Nome de usuário administrativo',
    'service.admin-access.password' => 'Senha administrativa',
    'service.admin-access.passwordConfirmation' => 'Confirmar senha',

    'service.info.service-entry-point.availableAt' => 'Disponível em',
    'service.info.service-entry-point.customize' => 'Customizar atalho',
    'service.info.service-entry-point.displayNameLabel' => 'Nome do atalho',
    'service.info.service-entry-point.displayNameDescription' => 'Forneça um nome para o atalho. O nome é exibido sob o ícone do atalho. Os atalhos são colocados na página Meus serviços dos usuários ao quais o acesso ao aplicativo foi concedido.',
    'service.info.service-entry-point.descriptionLabel' => 'Descrição do atalho',
    'service.info.service-entry-point.descriptionDescription' => 'Forneça uma descrição para o atalho. A descrição é exibida como uma dica de ferramenta que aparece quando o cursor do mouse é posicionado sobre o atalho.',
    'service.info.service-entry-point.iconLabel' => 'Clique para selecionar o ícone do atalho',
    'service.info.service-entry-point.iconCurrent' => 'Ícone atual',
    'service.info.service-entry-point.errorEmptyName' => 'Você precisa fornecer um nome de atalho.',
    'service.info.service-entry-point.errorLongName' => 'O nome do atalho deve ter de 1 a 255 caracteres.',
    'service.info.service-entry-point.errorLongDescription' => 'A descrição do atalho deve ter de 0 a 255 caracteres.',
    'service.info.service-entry-point.hiddenLabel' => 'Ocultar atalho',
    'service.info.service-entry-point.hiddenDescription' => 'Não exiba esse atalho aos usuários.',

    'service.info.service-permission.assignedUser' => "Conceder acesso de administrador a esse usuário",
    'service.info.service-permission.assignedUserNone' => 'Nenhum usuário atribuído',

    'shared-ssl.master-ssl.switchedOn' => 'Ativar o SSL/TLS compartilhado.',
    'shared-ssl.master-ssl.domainName' => 'Nome do domínio de um site cujo certificado SSL/TLS será compartilhado entre outros sites.',
    'shared-ssl.master-ssl.none' => 'Nenhum',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'O SSL/TLS compartilhado não pode ser ativado porque não há domínios com o suporte SSL/TLS ativado.',

    'user.email.email' => 'Endereço de e-mail',
    'user.email.emptyEmail' => 'Você precisa fornecer um endereço de e-mail.',
    'user.email.internalEmailHint' => 'Crie um novo endereço de e-mail no Plesk ou use um endereço de e-mail externo.',
    'user.email.longInternalEmail' => 'O endereço de e-mail é muito longo.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'A parte do nome de usuário do endereço de e-mail é muito longa para este servidor de e-mail. Especifique um nome de usuário com até %%max%% símbolos.',
    'user.email.longInternalEmailFullAddressMailServer' => 'O endereço de e-mail é muito longo para este servidor do e-mail. Especifique um endereço com até %%max%% símbolos.',
    'user.email.externalEmail' => 'Endereço de e-mail externo',
    'user.email.externalEmailHint' => 'Será usado para redefinir sua senha caso perca o acesso ao endereço de e-mail principal.',
    'user.email.emailsIsEqual' => 'O endereço de e-mail externo corresponde ao principal. Especifique um endereço de e-mail externo diferente.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Especifique um endereço de e-mail interno ou externo.',

    'user.profileSection' => 'Informações gerais',
    'user.contactName' => 'Nome de contato',
    'user.email' => 'Endereço de e-mail',
    'user.role' => 'Função do usuário',
    'user.accountSection' => 'Preferências do Plesk',
    'user.login' => 'Nome do usuário',
    'user.password' => 'Senha',
    'user.oldPassword' => 'Senha antiga',
    'user.buttonBack' => 'Voltar',
    'user.generalTab' => 'Geral',
    'user.applicationsAccessSection' => 'Serviços',
    'user.generalPermissionsSection' => 'Privilégios',
    'user.contactsTab' => 'Detalhes de contato',
    'user.passwordConfirmation' => 'Confirmar senha',
    'user.internalEmailPasswordChanged' => 'Alterar a senha também alterará a senha do endereço de e-mail interno.',
    'user.emailName' => 'Endereço de e-mail',
    'user.emailType' => 'Tipo de e-mail',
    'user.companyName' => 'Nome da empresa',
    'user.phone' => 'Telefone',
    'user.imNumber' => 'Mensageiro instantâneo',
    'user.fax' => 'Número de fax',
    'user.address' => 'Endereço',
    'user.city' => 'Cidade',
    'user.state' => 'Estado ou província',
    'user.zip' => 'Código postal ou CEP',
    'user.country' => 'País',
    'user.additionalInfo' => 'Informações adicionais',
    'user.additionalInfoHint' => 'Apenas texto simples: Todas as tags de HTML serão ignoradas.',
    'user.language' => 'Idioma do Plesk',
    'user.buttonChangePassword' => 'Alterar senha',
    'user.permissionAllow' => 'Concedido',
    'user.permissionDeny' => 'Negado',
    'user.permissionInherited' => 'Definido por função',
    'user.emptyContactName' => 'Você precisa fornecer um nome de contato.',
    'user.emptyLogin' => 'Você precisa fornecer um nome de usuário.',
    'user.emptyPassword' => 'Você precisa fornecer uma senha.',
    'user.emptyPasswordConfirmation' => 'Você precisa confirmar a senha.',
    'user.oldPasswordIsIncorrect' => 'A senha antiga está incorreta. Tente novamente.',
    'user.chooseDomainBoxTitle' => 'Selecione outro domínio:',
    'user.userIsActive' => 'O usuário está ativo',
    'user.userIsActiveHint' => 'Ativar os usuários que podem acessar o Plesk.',
    'user.emailActivation' => 'Ativar conta por e-mail',
    'user.emailHint' => 'Para fornecer ao usuário um endereço de e-mail hospedado neste servidor, acesse a guia Correio, crie o endereço de e-mail especificado e associe-o ao usuário.',
    'user.emailContactHint' => 'Contate o seu provedor de serviços caso queira utilizar um endereço de e-mail hospedado neste servidor.',
    'user.personalEmailHint' => "Este endereço de e-mail do usuário pode ser alterado na guia Correio.",
    'user.externalMailRedirectHint' => 'O redirecionamento pode ser ativado apenas para endereços de e-mail hospedados neste servidor. Para criar um endereço de e-mail, acesse a guia Correio.',
    'user.externalMailRedirectHint2' => 'O redirecionamento pode ser ativado apenas para endereços de e-mail hospedados neste servidor.',
    'user.externalMailAutoResponderHint' => 'A resposta automática pode ser ativada apenas para endereços de e-mail hospedados neste servidor. Para criar um endereço de e-mail, acesse a guia Correio.',
    'user.externalMailAutoResponderHint2' => 'A resposta automática pode ser ativada apenas para endereços de e-mail hospedados neste servidor.',
    'user.roleHint' => 'As funções de usuário concedem aos usuários privilégios administrativos e acesso a aplicativos que você seleciona para a função.',
    'user.cannotManageMail' => "Você não tem permissão para gerir configurações e serviços de e-mail.",
    'user.longCompanyName' => 'O nome da empresa especificado é muito longo.',
    'user.longPhone' => 'O número de telefone especificado é muito longo.',
    'user.longFax' => 'O número de fax especificado é muito longo.',
    'user.longAddress' => 'O endereço especificado é muito longo.',
    'user.longCity' => 'O nome de cidade especificado é muito longo.',
    'user.phoneRegexNotMatch' => 'O número de telefone especificado não é válido.',
    'user.faxRegexNotMatch' => 'O número de fax especificado não é válido.',
    'user.shortCity' => 'O nome de cidade especificado é muito curto.',
    'user.limitSubscription' => 'Acesso às assinaturas',
    'user.limitSubscriptionHint' => 'Permite aos usuários acessarem somente a assinatura especificada. O valor "Todas" lhes concede acesso a todas as assinaturas dentro da sua conta de hospedagem.',
    'user.limitSubscriptionAll' => 'Todos',
    'user.deletedSubscription' => 'Assinatura removida',

    'web.add-domain-alias.title' => 'Adicionar um alias do domínio',
    'web.add-domain-alias.createdSuccessfully' => "O nome alternativo do domínio %%name%% foi criado.",
    'web.add-domain-alias.domainAliasName' => 'Nome alternativo do domínio',
    'web.add-domain-alias.domainAliasNameHint' => 'Por exemplo, exemplo.net',
    'web.add-domain-alias.forDomain' => 'para o domínio',
    'web.add-domain-alias.settingsSectionLegend' => 'Configurações',
    'web.add-domain-alias.settingsDns' => 'Sincronizar a zona DNS com o domínio primário',
    'web.add-domain-alias.settingsMail' => 'Serviço de e-mail',
    'web.add-domain-alias.settingsWeb' => 'Serviço da web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Redirecione o código HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Quando os visitantes abrirem a URL alias, eles serão direcionados para a URL de domínio primário. O Plesk usa o redirecionamento HTTP 301 fácil de usar do mecanismo de busca, o que significa que a classificação do mecanismo de busca não será dividido entre as URLs.',
    'web.add-domain-alias.settingsTomcat' => 'Aplicativos da web em Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Domínio inválido',

    'web.add-domain.formTitle' => 'Adicionando Novo Domínio',
    'web.add-domain.portalLink' => 'Portal de serviços',
    'web.add-domain.domainName' => 'Nome do domínio',
    'web.add-domain.domainNameHint' => "Por exemplo, exemplo.com",
    'web.add-domain.assignToCustomer' => 'Atribuir este domínio a um cliente',
    'web.add-domain.customer' => 'Selecionar um cliente',
    'web.add-domain.createNewCustomer' => 'Criar um Novo Cliente',
    'web.add-domain.selectExistingCustomer' => 'Selecione um cliente existente:',
    'web.add-domain.customerContactInfoHint' => 'Insira as informações de contato do cliente. É possível especificar todas as outras informações, como número de telefone e endereço, posteriormente.',
    'web.add-domain.customerLoginInfoHint' => 'Credenciais para o painel do cliente',
    'web.add-domain.target' => 'Espaço web',
    'web.add-domain.createNewTarget' => 'Criar uma Nova Assinatura',
    'web.add-domain.createNewTarget_powerUser' => 'Criar um novo web-espaço',
    'web.add-domain.selectExistingTarget' => 'Selecione uma assinatura existente:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Selecione um espaço web existente:',
    'web.add-domain.dns' => 'Ativar o serviço DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Ativar o serviço de e-mail',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funciona se as configurações da assinatura permitirem gerenciar a permissão de e-mail por domínio. Se eles não permitirem, o status real do serviço de e-mail será obtido da assinatura.',
    'web.add-domain.hostingManagementOptions' => 'Tipo de hospedagem',
    'web.add-domain.websiteHosting' => 'Hospedagem de site',
    'web.add-domain.websiteForwarding' => 'Redirecionamento',
    'web.add-domain.websiteNoHosting' => 'Sem hospedagem',
    'web.add-domain.hostingSettingsSectionLegend' => 'Configurações de hospedagem',
    'web.add-domain.domainCreatedSuccessfully' => 'O domínio %%domainName%% foi criado com sucesso.',
    'web.add-domain.webspaceLegend' => 'Configurações de espaço web',
    'web.add-domain.addWhmWebsiteTitle' => 'Adicionar novo web site',
    'web.add-domain.addWhmWebsiteHint' => "Você pode hospedar um site neste servidor.",
    'web.add-domain.selectWhmDomain' => 'Selecione um domínio',
    'web.add-domain.customerLegend' => 'Informações do Cliente',
    'web.add-domain.credentials' => 'Credenciais de usuário do sistema',
    'web.add-domain.credentialsHint' => 'para acessar arquivos hospedados por FTP e SSH',
    'web.add-domain.credentialsHintWin' => 'para acessar arquivos hospedados por FTP e RDP',
    'web.add-domain.buttonAddDomain' => 'Adicionar Domínio',

    'web.add-subdomain.formTitle' => 'Adicionar um Subdomínio',
    'web.add-subdomain.formGeneralHint' => 'Os subdomínios são endereços da internet para diferentes seções de seu website. Tais subdomínios utilizam seu nome de domínio principal e um prefixo. Por exemplo, se seu domínio for domain.com, um subdomínio poderá ser store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'Também é possível criar um subdomínio coringa inserindo o símbolo * em vez do nome. Os visitantes do site serão redirecionados para esse subdomínio, independentemente do nome do subdomínio que eles inserirem em um navegador.',
    'web.add-subdomain.subdomainName' => 'Nome do subdomínio',
    'web.add-subdomain.subdomainNameHint' => 'Insira * para criar um subdomínio coringa.',
    'web.add-subdomain.forDomain' => 'Domínio principal',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'O subdomínio foi criado.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Configurações de hospedagem',

    'web.change-hosting.formGeneralHint' => 'Você pode optar por hospedar o site neste servidor, configurar o redirecionamento de internet para outro site ou configurar uma zona de DNS de domínio (por meio da opção Sem hospedagem), se desejar ter apenas endereços de e-mail em um nome de domínio.',
    'web.change-hosting.changed' => 'O tipo de hospedagem de %%domainName%% foi alterado.',
    'web.change-hosting.hostingManagementOptions' => 'Tipo de hospedagem',
    'web.change-hosting.websiteHosting' => 'Hospedagem de site',
    'web.change-hosting.websiteForwarding' => 'Redirecionamento',
    'web.change-hosting.websiteNoHosting' => 'Sem hospedagem web',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Configurações de hospedagem',
    'web.change-hosting.userName' => 'Nome do usuário',
    'web.change-hosting.userNameHint' => 'Conta de usuário do sistema utilizada para gerenciar arquivos e pastas da assinatura.',
    'web.change-hosting.userNameHint_powerUser' => 'Conta de usuário do sistema utilizada para gerenciar arquivos e pastas do espaço web.',
    'web.change-hosting.emptyLogin' => 'Você precisa especificar um nome de usuário.',
    'web.change-hosting.password' => 'Senha',
    'web.change-hosting.emptyPassword' => 'Você precisa especificar uma senha.',
    'web.change-hosting.passwordConfirmation' => 'Confirmar senha',
    'web.change-hosting.warningInstalledApplications' => 'Existem aplicativos de internet instalados no site. Se você alterar o tipo de hospedagem, os aplicativos não permanecerão acessíveis.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Advertência: O conteúdo do site será excluído.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Você deseja mudar o tipo de hospedagem para seu site?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'As pastas subsequentes e todo o seu conteúdo serão excluídos:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Todos os conteúdos da pasta raiz do espaço web serão excluídos.',

    'web.change-status.changed' => 'O status do site de %%domainName%% foi alterado com êxito.',
    'web.change-status.statusManagementOptions' => 'Status do site',
    'web.change-status.statusDisabled' => 'Desabilitado (formalmente conhecido como Suspenso)',
    'web.change-status.statusSuspended' => 'Suspenso',
    'web.change-status.statusActive' => 'Ativo',
    'web.change-status.statusDisabledHint' => 'O website não será mais hospedado no servidor e não estará disponível exceto por clientes FTP e gerenciador de arquivos. Os visitantes verão a página padrão do servidor. O serviço de e-mail ficará indisponível.',
    'web.change-status.statusSuspendedHint' => 'O site ficará hospedado no servidor, mas os visitantes serão redirecionados com o código 503 HTTP para a página do documento de erro personalizada. O serviço de e-mail ficará indisponível. Aqui você pode %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Os visitantes serão redirecionados com o código 503 HTTP do mecanismo de busca auxiliar para a página personalizada de erro do documento, embora o site continue hospedado no servidor. O serviço de e-mail ficará indisponível.',
    'web.change-status.error503PageLink' => 'editar o documento de erro personalizado',
    'web.change-status.statusActiveHint' => 'O site irá operar como de costume.',
    'web.change-status.notActivatedSuspended' => 'O domínio ou site %%domainName%% não pode ser ativado por que foi suspenso por seu provedor de hospedagem.',
    'web.change-status.notActivatedDisabled' => 'O domínio ou site %%domainName%% não pode ser ativado por que foi desabilitado por seu provedor de hospedagem.',

    'web.edit.formTitle' => 'Acesso à Hospedagem da Web para %%name%%',
    'web.edit.formGeneralHint' => 'Esta é a área em que os endereços IP associados à sua assinatura podem ser visualizados e o nome de usuário e a senha relacionados com sua assinatura podem ser alterados.',
    'web.edit.formGeneralHint_powerUser' => 'Esta é a área em que os endereços de IP associados a este espaço de internet podem ser visualizados e o nome de usuário e a senha podem ser alterados.',
    'web.edit.ipAddressesLegend' => 'Endereços IP',
    'web.edit.ipAddresses' => 'Endereços IP',
    'web.edit.certificateLegend' => 'Certificado',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (pertencente a outro usuário)',
    'web.edit.userAccountLegend' => 'Usuário do sistema',
    'web.edit.systemUserHint' => 'Aqui você pode especificar o usuário do sistema operacional para gerenciar arquivos e pastas dentro da assinatura por FTP ou o Gerenciador de Arquivo. Se as permissões correspondentes forem concedidas, o usuário de sistema também é utilizado para acessar o Plesk por SSH (em Linux) ou RDP (em Windows).',
    'web.edit.systemUserHint_powerUser' => 'Aqui você pode especificar o usuário do sistema operacional para gerenciar arquivos e pastas no espaço web por FTP ou o Gerenciador de Arquivo. Se as permissões correspondentes forem concedidas, o usuário de sistema também é utilizado para acessar o Plesk por SSH (em Linux) ou RDP (em Windows).',
    'web.edit.login' => 'Nome do usuário',
    'web.edit.emptyLogin' => 'Especifique um nome de usuário.',
    'web.edit.password' => 'Senha',
    'web.edit.passwordConfirmation' => 'Confirmar senha',
    'web.edit.emptyPassword' => 'Especifique uma senha.',
    'web.edit.emptyPasswordConfirmation' => 'Confirme a senha.',
    'web.edit.shellUnix' => "Acesso ao servidor pelo SSH",
    'web.edit.shellHintUnix' => "Acesso ao servidor pelo SSH com as credenciais do usuário do sistema.",
    'web.edit.shellWin' => 'Acesso ao servidor pela área de trabalho remota',
    'web.edit.shellHintWin' => "Acesso ao servidor pela área de trabalho remota com as credenciais do usuário do sistema.",
    'web.edit.diskQuotaLegend' => 'Cota rígida em espaço de disco',
    'web.edit.diskQuotaHint' => 'A cota fixa no espaço em disco é o limite de quantidade de espaço em disco que pode ser utilizada. Se a cota fixa for definida, e todo o espaço em disco alocado estiver em uso, nenhuma outra operação poderá ser executada nos arquivos.',
    'web.edit.diskQuota' => 'Cota rígida em espaço de disco',
    'web.edit.diskQuotaUnlimited' => 'Ilimitado',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Ilimitado. A cota de disco rígido não é suportada por causa da configuração do sistema de arquivos do servidor.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'As configurações de hospedagem foram atualizadas com sucesso.',
    'web.edit.affectedDomainsLegend' => 'Websites para os quais suas configurações se aplicam',
    'web.edit.affectedDomainsHint' => 'Os seguintes sites estão associados com o usuário atual do sistema. As mudanças nas configurações de acesso a hospedagem feitas nesta página, serão aplicada a todos estes sites.',

    'web.mobile.create.formTitle' => 'Criar site móvel',
    'web.mobile.create.formGeneralHint' => 'Especifique um nome de site móvel e um URL por meio do qual o site móvel será acessado. Em geral, prefixos como "m", "mob", "mobi", "mobile", etc. são utilizados (por exemplo: mobile.example.com). Você pode utilizar esse URL e, depois, um link como "Versão móvel" em seu site normal, de modo que os visitantes possam alternar entre as versões móvel e normal.',
    'web.mobile.create.prefix' => 'Nome do site',
    'web.mobile.create.emptySiteName' => 'O nome do site móvel não pode estar vazio. Caso contrário, ocorrerá um conflito com seu website normal.',

    'web.security-section.securitySectionLegend' => 'Segurança',
    'web.security-section.securitySectionHint' => 'Para transações seguras com seu site, utilize o protocolo SSL/TLS, que codifica todos os dados e os transfere por uma conexão segura. Para empregar o SSL/TLS, mova este site para um endereço de IP dedicado, instale um certificado SSL/TLS no local e depois selecione-o abaixo.',
    'web.security-section.securitySectionSniHint' => 'Para transações seguras com seu site, utilize o protocolo SSL/TLS, que codifica todos os dados e os transfere por uma conexão segura. Para empregar SSL/TLS, instale um certificado SSL/TLS no site e depois selecione-o abaixo.',
    'web.security-section.enableSslSupport' => 'Suporte SSL/TLS',
    'web.security-section.enableSslRedirect' => 'Redirecionamento 301 SEO seguro permanente do HTTP para o HTTPS.',

    'web.seo-settings.seoRedirectDirection' => 'Domínio preferido',
    'web.seo-settings.seoRedirectDirectionHint' => 'Selecione a URL (com ou sem o prefixo www.) para a qual os visitantes do site serão redirecionados por meio de um redirecionamento HTTP 301 seguro pelo SEO.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Nenhum',

    'web.settings.formGeneralHint' => 'É aqui que você configura as definições de hospedagem do site e seleciona os recursos disponíveis para o seu site.',
    'web.settings.hostingType' => 'Tipo de hospedagem',
    'web.settings.websiteHosting' => 'Site',
    'web.settings.forwardingHosting' => 'Redirecionamento',
    'web.settings.noHosting' => 'Sem hospedagem',
    'web.settings.changeHosting' => 'Alterar',
    'web.settings.websiteStatus' => 'Status do site',
    'web.settings.changeStatus' => 'Alterar',
    'web.settings.active' => 'Ativo',
    'web.settings.suspended' => 'Suspenso',
    'web.settings.disabled' => 'Desabilitado',
    'web.settings.webScriptingSectionLegend' => 'Criação de scripts e estatísticas web',
    'web.settings.webScriptingSectionHint' => 'Especifique quais das seguintes linguagens de programação e criação de scripts devem ser interpretadas, executadas ou de outra forma processadas pelo servidor web.',
    'web.settings.__asp_win_support' => 'Suporte a Microsoft ASP',
    'web.settings.__asp_dot_net_support' => 'Suporte a Microsoft ASP.NET',
    'web.settings.__asp_dot_net_version' => 'Versão',
    'web.settings.__asp_dot_net_version_readonly' => 'versão %%value%%',
    'web.settings.__ssi_support' => 'Suporte a SSI',
    'web.settings.__ssi_with_html' => 'utilizar o SSI para arquivos *.htm, *.html',
    'web.settings.__php_support' => 'Suporte a PHP',
    'web.settings.__php_run_as' => 'executar o PHP como',
    'web.settings.__php_served_by_apache' => 'servido por Apache',
    'web.settings.__php_served_by_nginx' => 'servido por nginx',
    'web.settings.__cgi_support' => 'Suporte a CGI',
    'web.settings.__cgi_bin_mode' => 'o diretório cgi-bin está localizado em',
    'web.settings.__cgi_bin_mode_webspace' => 'o diretório raiz do espaço web',
    'web.settings.__cgi_bin_mode_www_root' => 'o documento raiz deste domínio',
    'web.settings.__cgi_bin_mode_old_style' => 'o documento raiz de estilo antigo deste domínio',
    'web.settings.__cgi_bin_mode_readonly' => 'o diretório cgi-bin está localizado em %%value%%.',
    'web.settings.__perl_unix_support' => 'Suporte a Perl',
    'web.settings.__perl_win_support' => 'Suporte a Perl',
    'web.settings.__python_unix_support' => 'Suporte a Python',
    'web.settings.__python_win_support' => 'Suporte a Python',
    'web.settings.__fastcgi_unix_support' => 'Suporte FastCGI',
    'web.settings.__webstat_support' => 'Estatísticas da web',
    'web.settings.__plesk_stat_protect' => 'Proteger o acesso às suas estatísticas da web com seu nome de usuário e senha FTP',
    'web.settings.__plesk_stat_protected' => 'O acesso às suas estatísticas da web está protegido com seu nome de usuário e senha de FTP',
    'web.settings.__apache_errdocs' => 'Documentos de erro customizados',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'Aplicativo FastCGI',
    'web.settings.__php_cgi_handler' => 'Aplicativo CGI',
    'web.settings.__php_isapi_handler' => 'Extensão ISAPI',
    'web.settings.__php_version' => 'Versão do PHP',
    'web.settings.__hosting_write_modify' => 'Permissões adicionais de gravação/modificação',
    'web.settings.__hosting_webdeploy' => 'Publicação do Web Deploy',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Nenhum',
    'web.settings.activate' => 'Ativar',
    'web.settings.deactivate' => 'Suspender',
    'web.settings.__php_support_readonly' => 'versão: %%version%%; handler: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'não registrado',
    'web.settings.domainName' => 'Nome do domínio',
    'web.settings.domainNameHint' => "Por exemplo, exemplo.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Modo de compatibilidade para a opção legada "Separar conteúdos SSL/TLS e não SSL/TLS".',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Executar o website em modo de compatibilidade para a opção legada "Separar conteúdos SSL/TLS e não SSL/TLS".',
    'web.settings.sameSslCompatibilityHint' => 'Este website está funcionando em modo de compatibilidade e você não pode gerenciá-lo usando a interface do Plesk. Isso ocorre porque você usou a opção obsoleta “Separar conteúdo SSL/TLS e não-SSL/TLS” antes da atualização. A partir do Plesk 11, um website armazena seu conteúdo disponível em conexões HTTP e HTTPS no mesmo diretório. Recomendamos que você mova todos os dados do diretório `httspdocs/` para `httpdocs/` e, em seguida, desative o modo de compatibilidade. Isso também tornará os aplicativos instalados no diretório `httpsdocs/` acessíveis pela Internet. Fique atento, pois você não conseguirá ativar o modo de compatibilidade novamente.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'As configurações de website serão aplicadas em %%restartInterval%% minutos.',
    'web.settings.phpSettingsDescription' => 'Esta página exibe a configuração do PHP para o site. Estas configurações são específicas para o site e não afetam outros sites da assinatura. É possível alterar a configuração do PHP se o provedor de hospedagem conceder a permissão correspondente. A configuração personalizada do PHP pode ser utilizada, por exemplo, para limitar o consumo de recursos do sistema por scripts do PHP ou para atender aos requisitos de um determinado aplicativo da web. Ao estabelecer um parâmetro para o valor Padrão, o PHP irá usar o valor do parâmetro da configuração PHP de todo o servidor.',
    'web.settings.phpSettingsAvailableVariables' => 'Você pode utilizar as seguintes variáveis em valores de parâmetro:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} - o caminho absoluto para o diretório raiz do documento desse website. O valor atual é %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'O diretório raiz do documento HTTPS é o mesmo para o http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'O diretório raiz do documento HTTPS é %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} para o diretório raiz do documento do site primário da assinatura.',
    'web.settings.phpSettingsVariableTmp' => '{TMP}  - o caminho absoluto para o diretório utilizado para arquivos temporários.',
    'web.settings.phpSettingsPhpVersion' => 'Sua versão PHP é %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP está desativado.',
    'web.settings.phpHandlerTypeHint' => 'Observe que alterar o tipo de manipulador PHP pode interromper a funcionalidade de scripts PHP existentes neste site.',
    'web.settings.fpmDedicatedHandlerHint' => 'O uso desse manipulador aumenta a estabilidade de um website, mas também causa um consumo adicional de memória.',
    'web.settings.phpHandlerChangeHint' => 'Você alterou as configurações do manipulador PHP. Se você salvar essas alterações, os scripts PHP no seu site poderão parar por %%interval%% segundos devido à configuração do servidor.',
    'web.settings.phpHandlerTypeHelpLink' => 'Saiba como escolher as configurações de PHP mais adequadas',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'O suporte a PHP não pode ser ativado porque a configuração atual de hospedagem não inclui nenhuma versão de PHP disponível para este domínio.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Descubra como habilitar outras versões do PHP.',
    'web.settings.phpHandlerBroken' => 'O manipulador do PHP selecionado atualmente está corrompido. Selecione um manipulador diferente.',
    'web.settings.phpHandlerOutdated' => '(Desatualizada)',
    'web.settings.phpHandlerDeprecated' => '(Descontinuada)',

    'web.setupService.formTitle' => 'Configuração de serviço: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'O serviço \'%%serviceReference%%\' foi atualizado com êxito.',

    'web.site-copy.subdomainsGroup' => 'Subdomínios do %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Destino da cópia',
    'web.site-copy.destinationType' => 'Selecione o local em que os arquivos do site serão copiados.',
    'web.site-copy.destinationTypeSite' => 'Website no Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copie os arquivos do site em outro de seus sites hospedado nessa conta. Se você tiver acesso de FTP a outra conta neste servidor, utilize a opção Armazenamento FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copie os arquivos do site em outro site hospedado neste servidor.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nome do site',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Os arquivos do site %%source%% não podem ser copiados para %%destination%% porque %%destination%% também é parte dos arquivos, e seu diretório raiz de documentos é um subdiretório do diretório raiz de documentos %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Os arquivos do site %%destination%% não podem ser removidos porque os arquivos %%source%% são parte desses arquivos, e o diretório raiz de documentos %%source%% é um subdiretório do %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Armazenamento FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copiar arquivos de website para uma conta de FTP neste servidor ou em um servidor externo.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copiar arquivos de website para uma conta de FTP em um servidor externo.',
    'web.site-copy.destinationTypeFtpHost' => "Nome do host do servidor",
    'web.site-copy.destinationTypeFtpPort' => "Porta",
    'web.site-copy.destinationTypeFtpFolder' => 'Diretório',
    'web.site-copy.destinationTypeFtpUser' => 'Nome do usuário',
    'web.site-copy.destinationTypeFtpPassword' => 'Senha',
    'web.site-copy.destinationTypeFtpMode' => 'Método de conexão de FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Modo ativo',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'No modo ativo, o Plesk envia seu endereço IP e número de porta na qual um servidor externo se comunicará, e o servidor inicia a conexão TCP. Esse modo é recomendado, se o servidor gerenciado pelo Plesk não for protegido por um firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Modo passivo',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'O modo passivo pode ser utilizado, se o servidor gerenciado pelo Plesk for protegido por um firewall e incapaz de aceitar as conexões de TCP de entrada.',
    'web.site-copy.existingFiles' => 'O que fazer com os arquivos existentes',
    'web.site-copy.existingFilesKeep' => 'Manter os arquivos existentes no site de destino.',
    'web.site-copy.existingFilesKeepDescription' => 'Substituir os arquivos existentes por nomes de arquivo coincidentes no site de destino.',
    'web.site-copy.existingFilesDelete' => 'Excluir todos os arquivos existentes',
    'web.site-copy.existingFilesDeleteDescription' => 'Excluir todos os arquivos no site de destino antes de iniciar a cópia.',
    'web.site-copy.emptyLogin' => 'Especifique um nome de usuário de conta de FTP.',
    'web.site-copy.emptyHost' => 'Especifique um nome de host de servidor.',
    'web.site-copy.emptyPort' => 'Especifique uma porta de host de servidor.',
    'web.site-copy.copyInProgress' => 'Copiando o site %%sourceName%% para %%destinationName%%. Você será notificado sobre o andamento via e-mail (%%email%%).',
    'web.site-copy.unableToCopy' => 'A cópia dos arquivos do website falhou.',
    'web.site-copy.siteCopied' => 'Os arquivos do website foram copiados.',
    'web.site-copy.emailSubjSuccess' => 'Os arquivos do website "%%source%%" foram copiados.',
    'web.site-copy.emailSubjFailure' => 'A cópia dos arquivos do website "%%source%%" falhou.',
    'web.site-copy.emailBodySuccess' => 'Os arquivos do website "%%source%%" foram copiados no "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'A cópia dos arquivos do website "%%source%%" para "%%destination%%" falhou: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Configurações de encaminhamento',
    'web._shared.forwardDestination' => 'Endereço de destino',
    'web._shared.forwardDestinationHint' => 'URL do site de destino.',
    'web._shared.forwardingTypeOptions' => 'Tipo de redirecionamento',
    'web._shared.forwardingFrame' => 'Redirecionamento de quadro',
    'web._shared.forwardingFrameHint' => 'Redirecionar os visitantes do site para outro site, mas não mostrar-lhes o endereço de destino, para que não saibam sobre o redirecionamento.',
    'web._shared.forwardingHttpCode301' => 'Movido permanentemente (código 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Redirecione os vistantes do site para outro site e mostre o endereço de destino. Tal redirecionamento manterá a classificação de mecanismo de busca do site.',
    'web._shared.forwardingHttpCode302' => 'Movido permanentemente (código 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Redirecione os visitantes do site para uma cópia temporária do site quando você não quiser buscar os mecanismos para indexar este site temporário.',
    'web._shared.documentRoot' => 'Documento raiz',
    'web._shared.documentRootHint' => 'Especifique o caminho para o diretório home do site.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Não é possível alterar o documento raiz, porque existem aplicativos web instalados neste website.',
    'web._shared.ipAddress' => 'Endereço IP',
    'web._shared.shared' => 'compartilhado',
    'web._shared.exclusive' => 'dedicado',
    'web._shared.ipAddressHint' => "O endereço IP no qual o website está hospedado é um endereço de rede do host virtual do website.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (outro repositório)',
    'web._shared.certificate' => 'Certificado',
    'web._shared.sameCertificatesHint' => 'O certificado selecionado será utilizado em todos os sites hospedados no mesmo endereço IP dedicado.',
    'web._shared.differentCertificatesHint' => 'Essa assinatura está associada a dois endereços IP dedicados com dois certificados diferentes. O certificado selecionado substituirá quaisquer certificados instalados nos sites hospedados nesses dois endereços IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Essa assinatura está associada a um endereço compartilhado e um endereço IP dedicado. O certificado selecionado também será utilizado em todos os outros sites hospedados no endereço IP dedicado.',
    'web._shared.certificateNotSelected' => 'Não selecionado',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Não há certificados SSL/TLS no seu repositório. Para adicionar um certificado, vá em %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'esta página',

    'web-user.settings.allowScripts' => 'Permite aos usuários de internet utilizar os scripts',

    'web-user.name' => 'Nome de usuário para a conexão com o servidor por FTP',
    'web-user.longName' => 'Este nome de usuário é muito extenso (símbolos máximos %max% são permitidos).',
    'web-user.password' => 'Senha',
    'web-user.passwordConfirmation' => 'Confirmar senha',
    'web-user.hardDiskQuota' => 'Cota do disco rígido',
    'web-user.hardDiskQuotaUnlimited' => 'Ilimitado',
    'web-user.hardDiskQuotaIsNotSupported' => '(A cota de disco rígido não é suportada em razão da configuração do sistema de arquivo do servidor)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Campos obrigatórios',
];