<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Vlastnosti dalšího klíče',
    'additional-key-info.update' => 'Získat další klíč',
    'additional-key-info.updateDescription' => 'Obnovit další klíč a nainstalovat ho.',
    'additional-key-info.download' => 'Stáhnout klíč',
    'additional-key-info.downloadDescription' => 'Stáhnout aktuální licenční klíč.',
    'additional-key-info.install' => 'Instalovat klíč',
    'additional-key-info.installDescription' => 'Instalovat aktuální licenční klíč.',
    'additional-key-info.revert' => 'Vrátit zpět klíč',
    'additional-key-info.revertDescription' => 'Vrátit se k dříve nainstalovanému licenčnímu klíč.',
    'additional-key-info.revertNotAvailableDescription' => 'Žádný klíč nebyl nainstalován.',
    'additional-key-info.installSuccess' => 'Instalace licenčního klíče byla zahájena.',

    'additional-key-revert.title' => 'Vrácení dodatečného klíče',
    'additional-key-revert.success' => 'Dodatečný klíč byl vrácen.',

    'additional-key-upload.title' => 'Nainstalovat licenční klíč',
    'additional-key-upload.success' => 'Nový další klíč byl nahrán.',

    'additional-keys.title' => 'Další licenční klíče',

    'change-owner.title' => 'Změna přiřazení vybraných předplacených služeb',

    'customers.hint' => 'Zde budete spravovat účty zákazníků vašich hostitelských služeb: vytvářet účty s předplatným služeb, spravovat stávající zákazníky a odebírat účty. Chcete-li spravovat weby, poštu, nebo jiné služby poskytované zákazníkovi, kliknutím na odkaz v pravém sloupci seznamu přejděte na jejich Panel zákazníka.',

    'customer-domains.hint' => 'Zde budete nastavovat a spravovat weby.',

    'customer-subscriptions.hint' => 'Zde budete spravovat předplacené služby zákazníků.',

    'domains.hint' => 'Zde můžete zobrazit informace o všech názvech domén zaregistrovaných v systému a pokračovat ve správě hostitelských služeb. Chcete-li přidat doménu pro sebe nebo pro hostující zákazníky, stačí kliknout na položku Přidat doménu. Při vytváření domény budete vyzváni k vytvoření nového zákazníka a předplatného, nebo k výběru z již existujících.',

    'database-servers.title' => 'Databázové servery',

    'database-server-create.title' => 'Nový databázový server',

    'database-server-properties.title' => 'Databázový server',

    'database-server-upgrade.drawerTitle' => 'Aktualizace MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Aktualizace je dokončená',
    'database-server-upgrade.drawerSubTitle.line1' => 'Komponentu drawer není možné zavřit, dokud probíhá aktualizace.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Pokud dojde během aktualizace k potížím, pomůže vám %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Databázový server MariaDB byl aktualizován na verzi %%releaseVersion%%. Pokud narazíte na potíže, jděte na %%troubleshootingArticle%% a řiďte se pokyny.',
    'database-server-upgrade.upToDate' => 'Verze LTS už nainstalovaná je.',
    'database-server-upgrade.troubleshootingArticle' => 'tento článek ve znalostní bázi',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Přečtěte si %%troubleshootingArticle%% pro pomoc s řešením problémů s aktualizací MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Aktualizujte si místní databázový server MariaDB na aktuální verzi vydání s dlouhodobou podporou (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Důrazně doporučujeme udělat si před aktualizací zálohu serveru a aktualizaci provádět v době, kdy je provoz na webu malý, mimo špičku.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Během aktualizace MariaDB budou server Plesk a na něm hostované weby nedostupné. Aktualizace MariaDB většinou probíhá bez chyb a trvá kolem 10 minut, i přesto ale může mít vliv na celý server.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Poznámka: pokud používáte verzi MariaDB 5.5, Plesk ji nejprve aktualizuje na verzi 10.5. Po této aktualizaci znovu spusťte průvodce a pokračujte aktualizací na aktuální LTS verzi MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Aktuální verze',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'Verze MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Vyberte, na jakou verzi chcete aktualizovat',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Žádná velká vydání',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Poznámky k vydání',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Datum vydání: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Datum ukončení životního cyklu: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Aktualizovat je možné jen fork operace MariaDB dodávané prodejci operačního systému nebo samotné MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontroly před aktualizací',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Analýza konfiguračních soborů MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analýza databází pomocí mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analýza konfigurace správce balíčků',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Kontrola WebSocketu',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Zaškrtněte všechna políčka, abyste mohli pokračovat v aktualizaci. Je to nezbytné abychom se přesvědčili, že souhlasíte se změnami v konfiguraci, které aktualizace provede, a že máte možnost provést případnou obnovu.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Tyto proměnné budou z důvodů kompatibility s novou verzí odstraněny:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} ze {count, plural,one {souboru {files}} other {# souborů: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Přístup k možnostem obnovy (příkazový řádek serveru a nástroj Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Potvrzuji, že mám SSH přístup k serveru',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => '%%sshTerminalExtension%% můžete otevířt v nové záložce prohlížeče pomocí SSH klienta (nezavírejte přitom okno rozšíření terminálu SSH, dokud aktualizace neskončí). Pokud aktualizace selže, pomůže vám přístup přes SSH s obnovou.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'rozšíření terminálu SSH',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Potvrzuji, že mám přístup k nástroji Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Otevřete %%repairKit%% v nové záložce v prohlížeči a přihlaste se pomocí údajů administrátora. Nezavírejte okno rozšíření Repair Kit, dokud nebude aktualizace dokončena.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Sada Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Zálohovat databáze',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Před aktualizací zálohovat všechny dabatáze hostované na serveru',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk uloží zálohy databází do adresáře %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket není v Plesku dostupný',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Bez WebSocketu neuvidíte v reálném čase výstup procesu aktualizace.',

    'database-server-upgrade.submitPopover.title' => 'Abyste zabránili případné ztrátě dat, důrazně doporučujeme před pokračováním vytvořit si výpis hostovaných databází. Určitě chcete pokračovat bez vytvoření výpisu?',

    'database-server-databases.title' => 'Databáze',

    'database-server-change-password.title' => 'Heslo správce',

    'home.title' => 'Domů',

    'license.title' => 'Informace o licencích',

    'primary-key-info.title' => 'Licenční klíč Plesk',
    'primary-key-info.update' => 'Obnovit klíče',
    'primary-key-info.updateDescription' => 'Obnovit objednané licenční klíče a nainstalovat je.',
    'primary-key-info.upload' => 'Instalovat klíč',
    'primary-key-info.uploadDescription' => 'Nahrát a nainstalovat nový licenční klíč.',
    'primary-key-info.revert' => 'Vrátit zpět klíč',
    'primary-key-info.revertDescription' => 'Vrátit se k dříve nainstalovanému licenčnímu klíč.',

    'primary-key-revert.title' => 'Vrácení licenčního klíče',
    'primary-key-revert.success' => 'U klíče platformy Plesk bylo provedeno vrácení.',

    'primary-key-upload.title' => 'Nainstalovat licenční klíč',
    'primary-key-upload.success' => 'Nový klíč Plesk byl nahrán.',

    'resellers.hint' => 'Toto je místo, kde můžete spravovat účty prodejců – vaši zákazníci, kteří prodávají hostitelské služby a hostí své vlastní weby. Zde můžete vytvářet účty společně s předplatným služeb, spravovat stávající zákazníky a odebírat účty.',

    'reseller-customers.hint' => 'Zde budete nastavovat a spravovat zákazníky.',

    'reseller-domains.hint' => 'Zde budete nastavovat a spravovat weby.',

    'reseller-subscriptions.hint' => 'Zde budete spravovat předplacené služby prodejce.',

    'subscriptions.hint' => 'Předplacením plánu hostování od vás odběratelé získají služby hostování. Tyto předplacené služby můžete spravovat zde, stejně jako své vlastní předplacené služby, které jste vytvořili, abyste hostili své weby. Chcete-li spravovat weby, poštu, nebo jiné služby poskytované s předplatným, kliknutím na odkaz v pravém sloupci seznamu přejděte na Panel zákazníka.',

    'server-mail-settings.title' => 'Nastavení',
    'server-mail-spam-filter.title' => 'Filtrování nevyžádané pošty',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Černá listina',
    'server-mail-white-list.title' => 'Bílá listina',
    'server-mail-queue.title' => 'Fronta e-mailů',
    'server-mail-statistics.title' => 'Statistiky',

    'server-spam-filter.settings' => 'Nastavení',
    'server-spam-filter.black-list' => 'Černá listina',
    'server-spam-filter.white-list' => 'Bílá listina',

    'firewall.title' => 'Správa brány firewall',
    'firewall-general.title' => 'Obecné',
    'firewall-general.toggleStatus' => 'Ochrana branou firewall',
    'firewall-general.buttonDefault' => 'Obnovit výchozí',
    'firewall-general.buttonPanic' => 'Nouzový režim (Panic)',
    'firewall-general.confirmationDefault' => 'Obnovit výchozí nastavení brány firewall?',
    'firewall-general.confirmationPanic' => 'Zapnout Režim paniky? Uživatelé nebudou mít přístup ke svým doménám a některé síťové služby mohou přestat fungovat.',
    'firewall-general.successDefault' => 'Bylo obnoveno výchozí nastavení brány firewall.',
    'firewall-general.successPanic' => 'Režim paniky byl povolen.',
    'firewall-general.info' => 'Brána firewall blokuje z bezpečnostních důvodů veškerá připojení kromě výslovně povolených připojení. Připojení můžete povolit tím, že vytvoříte pravidlo. Další informace naleznete v dokumentaci',
    'firewall-general.interfaces' => 'Síťová rozhraní',
    'firewall-icmp.title' => 'Protokol ICMP',
    'firewall-rules.title' => 'Pravidla brány firewall',

    'dns.title' => 'Nastavení DNS',
    'dns-records.title' => 'Šablona záznamů zón',
    'dns-soa-record.title' => 'Šablona nastavení zóny',

    'php-handler.title' => 'Nastavení pro %%name%%',
    'php-handler.extensions.title' => 'Rozšíření',
    'php-handler.extensions.description' => 'Tato nastavení rozšíření PHP jsou pouze pro tuto obslužnou rutinu.',
    'php-handler.extensions.descriptionShared' => 'Tato nastavení jsou společná pro následující obslužné rutiny PHP: %%handlers%%. Nastavení platí pro všechny weby, které používají tyto obslužné rutiny.',
    'php-handler.extensions.buttonManage' => 'Spravovat balíčky PECL',
    'php-handler.extensions.manage.title' => 'Spravovat balíčky PECL',
    'php-handler.extensions.manage.risks' => 'Rozšíření PHP jsou zajišťována balíčky PECL třetích stran. Instalujete je na vlastní riziko.',
    'php-handler.extensions.manage.description' => 'Instalujte, upgradujte a odinstalujte balíčky PECL. Změny budou použity na všechny weby běžící na rutinách %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Proč v seznamu není požadovaný balíček?',
    'php-handler.extensions.manage.limitations' => 'Rozšíření PHP dodaná poskytovatelem řídicího panelu a distributorem OS v seznamu nejsou.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Obnovit",
    'ServerInformation.sectionGeneral' => "Obecné",
    'ServerInformation.cpu' => "Procesor (CPU)",
    'ServerInformation.version' => "Verze",
    'ServerInformation.os' => "Operační systém",
    'ServerInformation.key' => "Licenční klíč Plesk",
    'ServerInformation.uptime' => "Doba od spuštění",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# den} few {# dny} other {# dnů}} {hours, plural, one {# hodina} few {# hodiny} other {# hodin}} {minutes, plural, one {# minuta} few {# minuty} other {# minut}}",
    'ServerInformation.sectionCpu' => "Využití CPU",
    'ServerInformation.la1min' => "Poslední 1 minuta",
    'ServerInformation.la5min' => "Posledních 5 minut",
    'ServerInformation.la15min' => "Posledních 15 minut",
    'ServerInformation.sectionMemory' => "Využití paměti",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Celkem (kromě kernelu)",
    'ServerInformation.memoryTotal' => "Celkem",
    'ServerInformation.memoryUsed' => "Využito",
    'ServerInformation.memoryFree' => "Volná",
    'ServerInformation.memoryShared' => "Sdílené",
    'ServerInformation.memoryBuffer' => "Vyrovnávací paměť",
    'ServerInformation.memoryCached' => "Využitá vyrovnávací paměť (Cached)",
    'ServerInformation.memoryAvailable' => "Dostupná",
    'ServerInformation.memoryUsage' => "Využití",
    'ServerInformation.sectionSwap' => "Využití odkládacího souboru",
    'ServerInformation.sectionVirtualMemory' => "Využití virtuální paměti",
    'ServerInformation.swapTotal' => "Celkem",
    'ServerInformation.swapUsed' => "Využito",
    'ServerInformation.swapFree' => "Volná",
    'ServerInformation.swapUsage' => "Využití",
    'ServerInformation.sectionHarddisk' => "Využití pevného disku",
    'ServerInformation.harddiskDirectory' => "Systém souborů",
    'ServerInformation.harddiskProtectedDir' => "Chráněné adresáře",
    'ServerInformation.harddiskTotal' => "Celkem",
    'ServerInformation.harddiskUsed' => "Využito",
    'ServerInformation.harddiskAvailable' => "Dostupná",
    'ServerInformation.harddiskCapacity' => "Kapacita",
    'ServerInformation.sectionDomains' => "Domény",
    'ServerInformation.activeDomains' => "Aktivní",
    'ServerInformation.inactiveDomains' => "Neaktivní",
    'ServerInformation.problemDomains' => "Problémy",
    'ServerInformation.refreshed' => "Informace aktualizovány.",

    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Všechna práva vyhrazena.',
    'ServerAbout.linkLicenseManagement' => 'Přejít k informacím o licenci',
    'ServerAbout.panelVersion' => 'Verze',
    'ServerAbout.installedPatchVersion' => 'Aktualizovat #%%patch%%',
    'ServerAbout.licenseKey' => 'Licenční klíč',
    'ServerAbout.productDescription' => 'Plesk je vedoucí platforma WebOps ke spouštění, automatizaci a vývoji aplikací, webů a podnikání v hostování.',
    'ServerAbout.readEula' => 'Přečíst odkaz %%link%%.',
    'ServerAbout.linkEula' => 'Licenční smlouva s koncovým uživatelem (EULA)',
    'ServerAbout.visitForum' => 'Navštívit %%link%%',
    'ServerAbout.linkForum' => 'Fórum Plesk',
    'ServerAbout.followUs' => 'Sledujte nás',
    'ServerAbout.visitSite' => 'Další informace na %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Najít inspiraci na %%link%%',
    'ServerAbout.linkBlog' => 'Blog Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Gratulujeme!',
    'ServerAbout.darkThemePromoDescription' => 'Našli jste kouzelné koťátko, které jsme přidali do výroční verze platformy Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Abrakadabra! Přejděte na temnou stranu',
    'ServerAbout.darkThemeTourDescription' => 'Přepnutím této možnosti můžete povolit nebo zakázat tmavý motiv vašeho rozhraní.',
    'ServerAbout.darkThemeTourButton' => 'Hotovo',

    'ts-sessions.title' => 'Relace terminálového serveru',
    'ts-sessions-properties.title' => 'Vlastnosti relace',

    'BandwidthLimiting.bandwidthThrottling' => 'Nelze ovládat omezování šířky pásma, protože není nainstalován systém QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Omezování šířky pásma je k dispozici pouze pro domény s webhostingem.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximální využití šířky pásma',
    'BandwidthLimiting.bandwidthHint' => 'Omezení využití šířky pásma se vztahuje pouze na data přenášená prostřednictvím protokolu HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Připojení omezena na',
    'BandwidthLimiting.maxConnectionHint' => 'Pokud omezujete šířku pásma, doporučujeme omezit také počet současných připojení k webu. V případě četných požadavků na web by jinak mohlo dojít ke zvýšení procesní zátěže webového.',
    'BandwidthLimiting.kbps' => 'kB/s',
    'BandwidthLimiting.success' => 'Nastavení omezení šířky pásma bylo změněno.',
    'BandwidthLimiting.unlimited' => 'Neomezeno',

    'ip-address-domains.title' => 'Webové stránky, které používají IP adresu %%ipAddress%% typu %%type%%',
    'ip-address-domains.site' => 'Web',
    'ip-address-domains.setAsDefault' => 'Nastavit jako výchozí',
    'ip-address-domains.type-SHARED' => 'Sdílený',
    'ip-address-domains.type-EXCLUSIVE' => 'vyhrazený',

    'HotlinkProtection.virtualHostingRequired' => 'Ochrana HotLink je k dispozici pouze pro domény s webhostingem.',
    'HotlinkProtection.enabledLabel' => 'Zapnout ochranu HotLink',
    'HotlinkProtection.extensionsLabel' => 'Přípony chráněných souborů',
    'HotlinkProtection.friendsLabel' => 'Adresy schválených webů',
    'HotlinkProtection.success' => 'Nastavení ochrany HotLink bylo změněno.',

    'Odbc.add' => 'Přidat ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% vytvořeno / %%allowed%% povoleno.',
    'Odbc.limitExceeded' => 'Překročen limit připojení ODBC DSN.',
    'Odbc.unlimited' => 'Neomezeno',
    'Odbc.addTooltip' => 'Přidat datový zdroj ODBC.',
    'Odbc.status' => 'Stav',
    'Odbc.name' => 'Název připojení',
    'Odbc.driver' => 'Ovladač',
    'Odbc.description' => 'Popis připojení',
    'Odbc.hostname' => 'Název hostitele',
    'Odbc.statusSystem' => 'Toto je systémový DSN.',
    'Odbc.statusConfigured' => 'DSN je nakonfigurován.',
    'Odbc.statusNotConfigured' => 'DSN není nakonfigurován.',
    'Odbc.noSelectionText' => 'Vyberte jednu nebo několik položek k odebrání.',
    'Odbc.removeConfirmation' => 'Odstranit {count, plural, one {} few {# vybraná připojení} many {# vybraných připojení}=1 {připojení {name}} other {# vybraných připojení}}?',
    'Odbc.removeSuccess' => 'Vybraná připojení byla odstraněna.',

    'DomainAliasSettings.title' => 'Nastavení aliasu domény',
    'DomainAliasSettings.updateSuccess' => 'Vlastnosti aliasu domény %%name%% byly změněny. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Nastavení webu se použije během %%restartInterval%% minut.',

    'Home.Backup.title' => 'Poslední záloha serveru',
    'Home.Backup.offStatus' => 'Záloha není platná. Obnovit data ze souboru není možné.',
    'Home.Backup.task-failedStatus' => 'Úloha zálohování se nezdařila.',
    'Home.Backup.activeSchedule' => 'Plán: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Plány: %%schedules%%',
    'Home.Backup.noSchedule' => "Není nastavený plán záloh",
    'Home.Backup.period_hourly' => 'Po hodinách %%schedule%%',
    'Home.Backup.period_daily' => 'Denně %%schedule%%',
    'Home.Backup.period_weekly' => 'Týdně %%schedule%%',
    'Home.Backup.period_monthly' => 'Měsíčně %%schedule%%',
    'Home.Backup.create' => 'Vytvořit zálohu',
    'Home.Backup.schedule' => 'Rozvrh',
    'Home.ChangeLog.title' => 'Co je nového',
    'Home.ChangeLog.seeHistory' => 'Zobrazit historii změn',
    'Home.CustomButtons.title' => 'Zákaznická tlačítka',
    'Home.CustomButtons.add' => 'Přidat uživatelské tlačítko',
    'Home.CustomButtons.noButtons' => 'Neexistují žádná uživatelská tlačítka',
    'Home.Customization.title' => 'Řídicí panel',
    'Home.Customization.description' => 'Vyberte, které možnosti chcete vidět',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Zabezpečení',
    'Home.Customization.backup' => 'Poslední záloha',
    'Home.Customization.ipBan' => 'Blokování IP adresy',
    'Home.Customization.mailQueue' => 'Fronta e-mailů',
    'Home.Customization.mySubscriptions' => 'Moje předplacené služby',
    'Home.Customization.overusedSubscriptions' => 'Předplatná s překročeným limitem',
    'Home.Customization.serverInfo' => 'Informace o serveru',
    'Home.Customization.updates' => 'Aktualizace Plesk',
    'Home.Customization.promo' => 'Akce',
    'Home.Customization.changeLog' => 'Co je nového',
    'Home.Customization.customButtons' => 'Zákaznická tlačítka',
    'Home.EmptyView.title' => 'Vyberte možnosti, které se mají zobrazovat, ať využíváte potenciál řídicího panelu na maximum.',
    'Home.EmptyView.titleLocked' => 'Váš poskytovatel služeb řídicí panel zamknul.',
    'Home.EmptyView.customize' => 'Přizpůsobit',
    'Home.Extension.title' => 'Rozšíření',
    'Home.IpBan.title' => 'Blokování IP adresy',
    'Home.IpBan.banned' => 'Zabanovaných',
    'Home.IpBan.trusted' => 'Důvěryhodných',
    'Home.IpBan.more' => 'Více',
    'Home.MailQueue.title' => 'Fronta e-mailů',
    'Home.MailQueue.total' => 'Celkem',
    'Home.MailQueue.deferred' => 'Odložené',
    'Home.MailQueue.held' => 'Pozdržené',
    'Home.MailQueue.more' => 'Více',
    'Home.MailQueue.clean' => 'Vyčistit frontu e-mailů',
    'Home.MailQueue.checkLogs' => 'Zkontrolovat protokoly',
    'Home.MailQueue.repair' => 'Opravit',
    'Home.MailQueue.cleanConfirmQuestion' => 'Vyčistit frontu e-mailů?',
    'Home.MailQueue.cleanConfirmYes' => 'Ano',
    'Home.MailQueue.cleanConfirmNo' => 'Ne',
    'Home.MailQueue.queueCleaned' => 'Fronta e-mailů byla úspěšně vymazána.',
    'Home.OverusedSubscriptions.title' => 'Předplatná s překročeným limitem',
    'Home.OverusedSubscriptions.empty' => 'Nenašla se žádná předplatná s překročeným limitem',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% z %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Ukázat vše s překročeným limitem: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Otevřít jako seznam',
    'Home.PromoNewHomeView.title' => 'Vítá vás nová domovská stránka!',
    'Home.PromoNewHomeView.description' => 'Pokud narazíte na potíže, dejte nám vědět. Hodně nám to pomůže s dalším zlepšováním.',
    'Home.PromoNewHomeView.feedback' => 'Sdílet zpětnou vazbu',
    'Home.PromoNewHomeView.switch' => 'Přepnout zpátky na „Domů“',
    'Home.ServerInfo.title' => 'Informace o serveru',
    'Home.ServerInfo.hostname' => 'Název hostitele',
    'Home.ServerInfo.ipAddress' => 'IP adresa',
    'Home.ServerInfo.publicIpAddress' => 'Veřejná IP adresa',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'Doba od spuštění',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# den} few {# dny} other {# dnů}} {hours, plural, one {# hodina} few {# hodiny} other {# hodin}} {minutes, plural, one {# minuta} few {# minuty} other {# minut}}",
    'Home.ServerInfo.more' => 'Více',
    'Home.Subscriptions.title' => 'Moje předplacené služby',
    'Home.Subscriptions.add' => 'Přidat nové',
    'Home.Subscriptions.empty' => 'Vytvořit předplatná pro hostování několika webů v izolovaném prostředí na serveru. %%link%%',
    'Home.Subscriptions.help' => 'Další informace',
    'Home.Updates.title' => 'Aktualizace produktu',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% aktualizace #%%patch%%',
    'Home.Updates.manageComponents' => 'Přidat nebo odebrat součásti',
    'Home.Updates.lastUpdated' => 'Poslední aktualizace: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Zjišťovat aktualizace',
    'Home.Updates.enableAutoupdate' => 'Povolit automatické aktualizace',
    'Home.Updates.lastChecked' => 'Poslední kontrola: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => 'verze %%availableVersion%% už je k dispozici',
    'Home.Updates.installNewVersion' => 'Nainstalovat',
    'Home.Updates.patchAvailable' => 'Jsou k dispozici malé aktualizace',
    'Home.Updates.patchAvailableVersion' => 'Jsou k dispozici menší aktualizaci pro verzi %%currentVersion%%',
    'Home.Updates.installPatch' => 'Aktualizovat nyní',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Dostupná aktualizace pro {package}} other {Dostupných aktualizací pro {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural,one {# balíček} few {# balíčky} other {# balíčků}}',
    'Home.Updates.installUpdates' => '{total, select,1 {Aktualizovat} other {Aktualizovat vše}}',
    'Home.Promo.Customize.title' => 'Přizpůsobte si řídicí panel podle svého!',
    'Home.Promo.Customize.content' => 'S novým řídicím panelem na míru máte oblíbené funkce doslova na dosah klepnutí',
    'Home.Promo.Customize.action' => 'Přizpůsobit',
    'Home.Promo.SwitchToPuv.title' => 'Máte informace o zobrazeních rozhraní v platformě Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Pokud svým zákazníkům neposkujete hostingové služby v podobě balíčků, můžete vyzkoušet rozhraní, které je pro správu webů, souborů, databází, e-mailových účtů a webových aplikací pohodlnější.',
    'Home.Promo.SwitchToPuv.action' => 'Vyzkoušet',
    'Home.Status.error' => 'Chyba',
    'Home.Status.warning' => 'Varování',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Nastavení hostování',
    'HostingSettings.updateSuccess' => 'Nastavení bylo aktualizováno.',
    'HostingSettings.emptyLogin' => 'Musíte zadat přihlašovací jméno.',
    'HostingSettings.emptyPassword' => 'Musíte zadat heslo.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Server FTP nepodporuje adresy IPv6. Přidělte alespoň jednu adresu IPv4, jinak uživatel nebude moci nahrát soubory na server prostřednictvím FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Nastavení domény',
    'HostingSettings.domainSettingsSection.domainName' => 'Název domény',
    'HostingSettings.domainSettingsSection.description' => 'Například priklad.com ',

    'HostingSettings.submitPopover.title' => 'Odstranit obsah %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Změna typu hostingu webové stránky na "%%type%%" trvale odstraní veškerý obsah na webu, včetně následujících adresářů:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Chcete změnit typ hostování pro váš web?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Pro přístup k dalším nastavením zadejte jméno a heslo uživatele systému a pak klikněte na „vytvořit webový prostor“.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Pro přístup k dalším nastavením klikněte na „Další“ pro vytvoření hostingu.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Typ hostingu',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Předávání',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Žádný webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Použijte zónu DNS domény pro poštovní schránky pod tímto názvem domény',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Cesta k domovskému adresáři webu',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Upřednostňovaná doména',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Návštěvníky sem přesměruje pro SEO optimalizovaný stavový kód HTTP 301.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Přesměrovat návštěvníky na',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Typ přesměrování',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Přesunuto trvale (kód 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Přesměruje návštěvníky webových stránek na jiný web a zobrazí jim cílovou adresu. Takové přesměrování udrží pozici webu ve vyhledávání',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Přesunuto dočasně (kód 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Pokud nechcete, aby vyhledávače indexovaly tyto dočasné stránky, přesměrujte návštěvníky webu na kopii dočasného webu.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Rámcové přesměrování',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Přesměrujte návštěvníky webu na jiný web, ale neukazujte jim cílovou adresu, aby o přesměrování nevěděli.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Upřednostňovaná doména',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Žádné',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Kořen dokumentu',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Kořen dokumentu nelze změnit, protože jsou na tomto webu nainstalovány webové aplikace.',
    'HostingSettings.domainSettingsSection.save' => 'Uložit',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Režim kompatibility',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Spustit web v režimu kompatibility pro starší verze "Oddělit obsah SSL/TLS a obsah bez SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Tento web běží v režimu kompatibility a není možné spravovat ho přes rozhraní Plesk. Je to proto, že jste před aktualizací používali zastaralou možnost „Oddělit obsah s SLL/TLS od obsahu bez SSL/TLS“. Od verze Plesk 11 už weby ukládají svůj obsah, který je dostupný přes HTTP a HTTPS spojení ve stejném adresáři. Doporučujeme přesunout všechna data z adresáře httpsdocs/ do adresáře httpdocs/ a pak režim kompatibility vypnout. Aplikace nainstalované v adresáři httpsdocs/ díky tomu budou dostupné i přes internet. Myslete ale na to, že znovu zapnout režim kompatibility už pak nebude možné.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Provést změnu nastavení?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Taková změna nastavení je v rozporu s bezpečnostními pravidly serveru a může negativně ovlivnit jeho výkon nebo ho udělat zranitelnějším vůči útokům.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Změnit',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Vrátit uložený',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Bude použita předvolba bezpečných nastavení',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Pro vyšší bezpečnost použijte přednastavené volby, které jsou bezpečné. Nezapomíntejte, že některá oprávnění umožňují odběratelům tato nastavení upravovat.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Použít bezpečné předvolby',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Další informace o nastavení zabezpečeného hostingu',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Podpora SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Povoleno',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Šifrujte spojení mezi webem a prohlížečem návštěvníka.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certifikát',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Pro povolení HTTPS nahrajte SSL/TLS certifikát do repozitáře domény a pak ho tady vyberte.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Přesměrujte návštěvníky z HTTP na HTTPS pomocí SEO optimalizovaného stavového kódu 301',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Ve vašem úložišti nejsou žádné certifikáty SSL/TLS. Chcete-li přidat certifikát, přejděte na %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'tato stránka',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (jiné úložiště)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nevybráno',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Skriptování pro web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Vyberte, které programovací a skriptovací jazyky má webový server interpretovat.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'adresář cgi-bin je umístěn v %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Použít SSI na soubory *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET verze',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Vlastní chybové dokumenty',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'adresář cgi-bin je umístěn v',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'kořen dokumentu této domény',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'kořenový adresář webového prostoru',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'kořen této domény ve starodávném stylu',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Vlastní chybové dokumenty',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Další oprávnění pro zápis/úpravy',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Nástroj pro publikování na webu Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webová statistika',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Nástroj',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Chránit přístup k webovým statistikám prostřednictvím vašeho přihlašovacího jména FTP a hesla',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Zakázáno',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Nastavení webového prostoru',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP adresy',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Disková kvóta',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Povoleno',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Zakáže operace se soubory webu pokud bude překročena kvóta pro místo na disku zadaná v nastaveních předplatného (pokud existuje).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Kvóta pevného disku není podporována kvůli způsobu konfigurace souborového systému serveru.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Pověření uživatele systému',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Spravujte soubory a složky webu přes FTP nebo správce souborů. Pro přístup k serveru můžete využít SSH, pokud je povoleno.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Spravujte soubory a složky webu přes FTP nebo správce souborů. Pro přístup k serveru můžete využít vzdálenou plochu, pokud je povolena.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Uživatelské jméno',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Heslo',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Pro změnu hesla uživatele systému zadejte nové heslo.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Přístup SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Přístup přes vzdálenou plochu',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Povoleno',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Přihlaste se na server pomocí přihlašovacích údajů uživatele systému.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Zakázáno',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Pro {count, plural, one {# doménu} few {# domény} many {# domén} other {# domén}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Následující nastavení je vzájemné pro {count, plural, one {# doménu ve webovém prostoru {name}} few {všechny # domény ve webovém prostoru {name}} many {všech # domén ve webovém prostoru {name}} other {všech # domén ve webovém prostoru {name}}}:',

    'OdbcAdd.title' => 'Přidat ODBC DSN',
    'OdbcAdd.nameLabel' => 'Název připojení',
    'OdbcAdd.descriptionLabel' => 'Popis připojení',
    'OdbcAdd.driver' => 'Ovladač',
    'OdbcAdd.submit' => 'Vytvořit ODBC DSN',

    'OdbcEdit.title' => 'Nastavit připojení ODBC',
    'OdbcEdit.saveSuccess' => 'Nastavení připojení byla uložena.',
    'OdbcEdit.test' => 'Otestovat připojení',
    'OdbcEdit.connectSuccess' => 'Připojení proběhlo úspěšně.',

    'OdbcEdit.excel.driver.label' => 'Ovladač',
    'OdbcEdit.excel.dbq.label' => 'Cesta k souboru databáze',
    'OdbcEdit.excel.defaultdir.label' => 'Výchozí datový adresář',
    'OdbcEdit.excel.fil.label' => 'Verze databáze',
    'OdbcEdit.excel.maxbuffersize.label' => 'Max. velikost vyrovnávací paměti',
    'OdbcEdit.excel.pagetimeout.label' => 'Časový limit stránky',

    'OdbcEdit.access.driver.label' => 'Ovladač',
    'OdbcEdit.access.dbq.label' => 'Cesta k souboru databáze',
    'OdbcEdit.access.uid.label' => 'ID přihlášení',
    'OdbcEdit.access.pwd.label' => 'Heslo',
    'OdbcEdit.access.pagetimeout.label' => 'Časový limit stránky',
    'OdbcEdit.access.pagetimeout.description' => 'Časové období v desetinách sekundy, po které nepoužitá stránka zůstává v mezipaměti. Tato možnost platí pro všechny zdroje dat, které používají ovladač Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Max. velikost vyrovnávací paměti',
    'OdbcEdit.access.maxbuffersize.description' => 'Velikost vnitřní vyrovnávací paměti, v kB, zarovnáno na hranici 256 kB.',
    'OdbcEdit.access.readonly.label' => 'Pouze ke čtení',
    'OdbcEdit.access.readonly.description' => 'Označí databázi jako pouze ke čtení, čímž zakáže všechny aktualizace.',
    'OdbcEdit.access.exclusive.label' => 'Výhradní',
    'OdbcEdit.access.exclusive.description' => 'Označí databázi jako výhradní, čímž zakáže sdílené aktualizace.',
    'OdbcEdit.access.safetransactions.label' => 'Bezpečné transakce',
    'OdbcEdit.access.safetransactions.description' => 'Při nastavení na 0 (výchozí nastavení), budou všechny transakce potvrzeny okamžitě. Při nastavení na 1 se všechny transakce uloží na disk pouze při operaci potvrzení, ale výkon se lehce sníží.',
    'OdbcEdit.access.threads.label' => 'Vlákna',
    'OdbcEdit.access.threads.description' => 'Počet vláken běžících na pozadí pro používaný modul.',
    'OdbcEdit.access.maxscanrows.label' => 'Max. počet řádků ke kontrole',
    'OdbcEdit.access.maxscanrows.description' => 'Počet řádků, které je nutno naskenovat při nastavení datového typu sloupce na základě stávajících dat.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Určuje, jak se změny provedené mimo transakci zapíší do databáze.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Určuje, zda bude ovladač MS Access provádět explicitní uživatelsky definované transakce asynchronně.',

    'OdbcEdit.mssql.driver.label' => 'Ovladač',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'ID přihlášení',
    'OdbcEdit.mssql.pwd.label' => 'Heslo',
    'OdbcEdit.mssql.database.label' => 'Výchozí databáze',
    'OdbcEdit.mssql.app.label' => 'Název aplikace',
    'OdbcEdit.mssql.wsid.label' => 'ID pracovní stanice',
    'OdbcEdit.mssql.language.label' => 'Výchozí jazyk',
    'OdbcEdit.mssql.oemtoansi.label' => 'Převod rozšířených znaků na hodnoty OEM',

    'OdbcEdit.mysql.driver.label' => 'Ovladač MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Název hostitele serveru MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Výchozí databáze',
    'OdbcEdit.mysql.user.label' => 'Uživatelské jméno',
    'OdbcEdit.mysql.user.description' => 'Uživatelské jméno použité k připojení do MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Heslo',
    'OdbcEdit.mysql.password.description' => 'Heslo pro uživatelský účet na serveru',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Port TCP/IP, který se má použít, pokud není server místním hostitelem',
    'OdbcEdit.mysql.socket.label' => 'Soket',
    'OdbcEdit.mysql.socket.description' => 'Pojmenovaný kanál systému Windows, s nímž se má propojit, pokud je server místním hostitelem',
    'OdbcEdit.mysql.option.label' => 'Možnost',
    'OdbcEdit.mysql.option.description' => 'Nastavení, která určují, jak by MyODBC mělo fungovat. Viz <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentace</a>',

    'ProtectedDirectoryList.add' => 'Přidat chráněný adresář',
    'ProtectedDirectoryList.addTooltip' => 'Vytvořit chráněný adresář.',
    'ProtectedDirectoryList.name' => 'Jméno',
    'ProtectedDirectoryList.realmTitle' => 'Název chráněné oblasti',
    'ProtectedDirectoryList.noSelectionText' => 'Vyberte jednu nebo několik položek k odebrání.',
    'ProtectedDirectoryList.edit' => 'Upravit',
    'ProtectedDirectoryList.remove' => 'Odstranit ochranu',
    'ProtectedDirectoryList.removeTooltip' => 'Odstranit ochranu z vybraných adresářů.',
    'ProtectedDirectoryList.removeConfirmation' => 'Tento proces odstraní ochranu z {count, plural, =1 {adresáře {name}} few {# zvolených adresářů} other {# zvolených adresářů}}. {count, plural,=1 {Tento adresář bude volně dostupný} few {Tyto adresáře budou volně dostupné} other {Tyto adresáře budou volně dostupné}} užvatelům na Internetu.',
    'ProtectedDirectoryList.removeSuccess' => 'Vybrané adresáře byly odstraněny.',

    'ProtectedDirectoryAdd.title' => 'Vytvořit chráněný adresář',
    'ProtectedDirectoryAdd.submit' => 'Vytvořit',
    'ProtectedDirectoryAdd.success' => 'Chráněný adresář %%path%% byl úspěšně vytvořen',

    'ProtectedDirectoryEdit.title' => 'Nastavení chráněného adresáře',
    'ProtectedDirectoryEdit.success' => 'Nastavení chráněného adresáře se změnilo',

    'ProtectedDirectoryUserList.add' => 'Přidat uživatele',
    'ProtectedDirectoryUserList.addTooltip' => 'Vytvořte uživatelské účty s přístupem do chráněného adresáře %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Jméno',
    'ProtectedDirectoryUserList.changePassword' => 'Změnit heslo',
    'ProtectedDirectoryUserList.noSelectionText' => 'Vyberte jednoho nebo víc uživatelů k odstranění.',
    'ProtectedDirectoryUserList.remove' => 'Odebrat',
    'ProtectedDirectoryUserList.removeTooltip' => 'Odstranit vybrané uživatele.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Odstranit {count, plural, =1 {uživatele {login}} few {# vybrané uživatele} other {# vybraných uživatelů}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Vybraní uživatelé byli odstraněni.',

    'ProtectedDirectoryUserAdd.title' => 'Vytvořit uživatele chráněného adresáře',
    'ProtectedDirectoryUserAdd.subtitle' => 'Adresář %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Uživatelské jméno',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Heslo',
    'ProtectedDirectoryUserAdd.submit' => 'Vytvořit',
    'ProtectedDirectoryUserAdd.success' => 'Pro chráněný adresář byl vytvořen uživatel %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Heslo pro uživatele chráněného adresáře',
    'ProtectedDirectoryUserPassword.subtitle' => 'Uživatel %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Heslo',
    'ProtectedDirectoryUserPassword.submit' => 'Uložit',
    'ProtectedDirectoryUserPassword.success' => 'Pověření uživatele byl uložena.',

    'SummaryReport.Layout.title' => 'Vlastnosti rozvržení sestav',
    'SummaryReport.Layout.success' => 'Rozvržení reportu %%name%% bylo aktualizováno.',
    'SummaryReport.Layouts.title' => 'Rozvržení sestav',

    'SummaryReport.Layout.Add.title' => 'Vytvořit rozvržení sestavy',
    'SummaryReport.Layout.Add.success' => 'Rozvržení reportu %%name%% bylo vytvořeno.',

    'SummaryReport.Report.title' => 'Souhrnné hlášení',
    'SummaryReport.Report.buttonLayouts' => 'Rozvržení',
    'SummaryReport.Report.buttonSchedule' => 'Rozvrh',
    'SummaryReport.Report.buttonProperties' => 'Vlastnosti',
    'SummaryReport.Report.buttonTrafficHistory' => 'Historie přenosu dat',
    'SummaryReport.Report.buttonPrint' => 'Vytisknout',
    'SummaryReport.Report.buttonSend' => 'Odeslat e‑mailem',
    'SummaryReport.Report.successSent' => 'Zpráva byla odeslána na %%email%%',

    'SummaryReport.Schedule.title' => 'Plány doručení pro %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Plán doručení pro %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Plán doručení sestavy bylo aktualizován.',

    'SummaryReport.Schedule.Add.title' => 'Vytvořte plány doručení pro %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Byl vytvořen plán doručení sestavy.',

    'SummaryReport.TrafficHistory.title' => 'Historie přenosu dat',

    'VirtualDirectory.errNotExist' => 'Virtuální adresář je nasměrován na fyzickou složku, která neexistuje.',
    'VirtualDirectory.errNoPermissions' => 'Nemáte oprávnění prohlížet obsah tohoto adresáře.',
    'VirtualDirectory.buttonProperties' => 'Vlastnosti adresáře',
    'VirtualDirectory.buttonPropertiesHint' => 'Zobrazit a změnit vlastnosti virtuálního adresáře.',
    'VirtualDirectory.buttonPermissions' => 'Přístupová oprávnění k adresáři',
    'VirtualDirectory.buttonPermissionsHint' => 'Nastavit přístupová oprávnění k adresáři.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Konfigurovat nastavení ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Konfigurovat nastavení PHP.',
    'VirtualDirectory.buttonMimeTypes' => 'Typy MIME',
    'VirtualDirectory.buttonMimeTypesHint' => 'Spravovat registrované typy MIME.',
    'VirtualDirectory.buttonErrorDocs' => 'Chybové dokumenty',
    'VirtualDirectory.buttonErrorDocsHint' => 'Spravovat chybové dokumenty.',
    'VirtualDirectory.buttonProtection' => 'Ochrana',
    'VirtualDirectory.buttonProtectionHint' => 'Omezit práva pro přístup k adresáři ochranou heslem.',

    'VirtualDirectory.CreateDirectory.title' => 'Vytvořit adresář',
    'VirtualDirectory.CreateDirectory.name' => 'Název adresáře',
    'VirtualDirectory.CreateDirectory.success' => 'Byl vytvořen adresář %%name%%.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Adresář %%name%% už existuje.',

    'VirtualDirectory.AspDotNet.title' => 'Konfigurovat nastavení ASP.NET',

    'VirtualDirectory.Php.title' => 'Verze PHP',
    'VirtualDirectory.Php.version' => 'Verze',
    'VirtualDirectory.Php.success' => 'Verze PHP byla aktualizována.',
];