<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Snart klart.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Snart klart.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptomer</h4><ul><li><p>Nettsider som har PHP-behandler angitt som <strong>FPM-applikasjon betjent av Apache</strong> eller <strong>FPM-applikasjon betjent av nginx</strong> på <strong>domener</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP -innstillinger</strong> opplever ett av følgende problemer:</p><ul><li><p>laster inn langsomt</p></li><li><p>ikke tilgjengelig (permanent eller periodisk) med en 50x-feil i en nettleser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>Følgende melding vises i PHP-FPM-feilloggfilen <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (der <em>XX</em> er en PHP-versjon brukt av nettsidene):</p><pre>ADVARSEL: [pool example.com]-serveren nådde max_children setting (*). Vurder å øke den</pre><ul><li><p>Meldingen ovenfor er vanligvis ledsaget med denne feilen:</p><pre>kunne ikke lese det barnet sa: Bad file descriptor (9)</pre></li></ul></li><li><p>Hvis nginx er aktivert på serveren, kan det være at en av følgende feilmeldinger vises i feilloggfilen for domenet <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM-en <code>pm.max_children</code> er nådd av nettsiden(e).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Øk grensen for pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Øk grensen for <code>pm.max_children</code> for de berørte domenene:</p><ol><li><p>Koble til Plesk-serveren via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Finn berørte domener ved hjelp av kommandoen nedenfor:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Merk:</strong> Tallet til venstre indikerer hvor mange ganger grensen for <code>pm.max_children</code> er nådd av nettsiden.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Logg på Plesk</a>.</p></li><li><p>Gå til <strong>Domener</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP-innstillinger</strong> &gt; <strong>PHP-FPM-innstillinger</strong>.</p></li><li><p>Øk verdien for <code>pm.max_children</code> for domenet, og ta i bruk endringene. Øk denne verdien for alle domener oppført i trinn 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx fails to start/reload on a Plesk server: Too many open files</p><h4>Symptomer</h4><ul><li><p>nginx-tjenesten kan ikke starte / laste inn på nytt med følgende feil i <code>/var/log/nginx/error.log</code>-filen:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Noen av eller alle nettsidene er ikke tilgjengelig</p></li><li><p>Advarselen vises i <strong>Verktøy og innstillinger &gt; Diagnosereperasjon</strong>:</p><pre style="white-space: pre-wrap;">Sjekker om nginx ULIMIT value N-domener er funnet på serveren. Problem med nginx default limit for åpne filer er mulig</pre></li><li><p>NodeJS- og Ruby-nettapplikasjoner viser 502 Bad Gateway-feil under utførelse av noen Plesk-oppgaver som å opprette domener, abonnementer, endringer på Apache eller Nginx etc.:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Nettserveren mottok et ugyldig svar under funksjonen som en gateway eller proxy-server.</pre></li><li><p>Etter <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">å ha installert et nytt sertifikat for domenet,</a>, vises fortsatt det gamle i en nettleser, men det riktige sertifikatet er imidlertid valgt på siden <strong>Domener &gt; example.com &gt; Innstillinger for hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Nginx sin virtuelle vert åpner 4 loggfiler for hver virtuelle vert med fysisk hosting:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Som et resultat av dette, er det maksimale antallet åpnet filer overskredet av nginx-serveren på grunn av et høyt antall domener (vanligvis mer enn 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Øk grensen for åpne filer',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Advarsel:</strong> Gjennomføring av <code>websrv_ulimits</code>-verktøyet uten <strong>--no-restart</strong>-alternativet påbegynner gjenoppbygging av nettkonfigurasjonsfilene for alle domener, og kan forårsake betydelig nedetid ved hosting av et stort antall nettsider.<br><br>Utfør kommandoen under vedlikeholdstidsrammen.</div><p>En anbefalt fremgangsmåte er å angi verdien for grensen for åpne filer til mer enn <strong>antallet domener i Plesk * 16</strong> som et minimum. I eksemplet nedenfor ser du hvordan tilgjengelige handlinger settes til grense på 4096:</p><ol><li><p>Koble til serveren via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Angi grensen for åpne filer til 4096 for både Apache og Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Staert Apache- og nginx-tjenestene på nytt på <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Verktøy og innstillinger &gt; Administrasjon av tjenester</strong> for å ta i bruk endringene.</p></li><li><p>Sjekk at «Maksgrensen for åpne filer» ble tatt i bruk på riktig måte etter at nettjenestene starter på nytt:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Hvis løsningen ovenfor ikke hjalp, kan du angi grrensen ved hjelp av <code>ulimit</code>-verktøyet:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Snart klart.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Symptomer</h4><ul><li><p>ModSecurity installeres og aktiveres i <strong>Verktøy og innstillinger > Web Application Firewall (ModSecurity) > Web application firewall mode > På</strong>.</p></li><li>Et nettsted der Plesk er vert kan ikke laste inn. Det er ikke mulig å utføre operasjoner på nettstedet, som administrering av WordPress, få tilgang til webmail eller få tilgang til <code>robots.txt</code>-filen. Nettleseren kan vise en av følgende feilmeldinger: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>En ModSecurity-feilmelding som nedenfor vises i loggfilen <code>/var/log/modsec_audit.log</code> eller på loggsiden i Plesk (<strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>ModSecurity Web Application Firewall er aktivert med et svært restriktivt regelsett, som OWASP, Comodo eller et egentilpasset regelsett som Imunify360. Restriktige regeloppsett kan blokkere visse operasjoner på nettstedet.</p><p><Strong>Merk:</strong> ModSecurity-feilen kan indikere et angrep på serveren din. Bruk løsningene nedenfor kun hvis du er sikker på at ModSecurity blokkerer gyldig bruk av nettstedet ditt.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Deaktiver ModSecurity-regeloppsettet etter ID eller tagg',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Finn ID-en for regelen som blokkerer legitim bruk av nettstedet ditt. Du finner ID-ene i feilmeldingene i loggfilen <code>/var/log/modsec_audit.log</code>. ID-en er et heltall i hermetegn, med prefikset <code>id</code> i hakeparantes, for eksempel <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Deaktiver spesifikke regelsett i Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Bytt til et annet regelsett for ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Bytt til et mindre restriktivt ModSecurity-regelsett, for eksempel «Atomic ModSecurity Ruleset». For å gjøre dette, går du til <strong>Verktøy og innstillinger</strong> > <strong>Webapp brannmur (ModSecurity)</strong> > <strong>Innstillinger</strong>. Velg <strong>Atomic Standard</strong> og klikk deretter på <strong>OK</strong> for å aktivere endringene.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Symptomer</h4><ul><li><p>Et nettsted med Plesk som vert er ikke tilgjengelig:</p><pre>500 intern serverfeil</pre></li><li><p>Følgende feil vises i nettstedsloggen:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Nettstedet har ikke tilstrekkelig allokert minne til å bli behandlet.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Øk memory_limit for nettstedet',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Symptomer</h4><ul><li><p>Et nettsted er ikke tilgjengelig med en av følgende feilmeldinger i nettleseren:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Følgende feilmelding vises på domenets loggside (<strong>Domains</strong> > <strong>example.com</strong> > <strong>Logs</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'PHP-skriptet prøver å få tilgang til en katalog der tilgang ikke er tillatt. Denne begrensningen er individuelt definert av PHP <code>open_basedir</code>-direktivet for hvert domene. Som standard tillater <code>open_basedir</code> tilgang til <code>tmp</code> og domenets rotkataloger, samt systemets standard øktsti.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Legg til ekstrastien til open_basedir-direktivet',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Deaktiver direktivet open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Gå til <strong>Domener &gt example.com &gt PHP-innstillinger</strong>, og angi <code>open_basedir</code>-direktivet til «ingen».</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Symptomer</h4><ul><li><p>Nettstedet viser en feil som ligner på følgende:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>The <code>/var/www/vhosts/system/example.com/logs/error_log</code> log file contains errors like the following one:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Gjeldende Apache-konfigurasjon tillatter ikke tilgang til nettstedet.</p><p>Det er forventet for filer som .htaccess og .htpasswd , da disse ikke skal være tilgjengelige via nettserveren.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Sjekk serverkonfigurasjon og .htaccess-filer',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Symptomer</h4><ul><li><p>Får ikke tilgang til en spesifikk nettsidelokasjon, for eksempel <code>http://example.com/some_folder</code>. Følgende feilmelding vises:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Følgende feil vises i <code>/var/www/vhosts/example.com/logs/error_log<code/> file:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Den forespurte mappen inneholder ingen indeksfil, eller mappevisning er ikke aktivert.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Legg til en indeksfil i mappen',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Aktiver mappevisning',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Symptomer</h4><ul><li><p>Får ikke tilgang til en spesifikk nettstedlokasjon, for eksempel <code>http://example.com/some_folder</code>. Følgende feilmelding vises:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Følgende feil vises i <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Den forespurte mappen inneholder ingen indeksfil, eller mappevisning er ikke aktivert.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Legg til en indeksfil i mappen',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Aktiver mappevisning',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Snart klart.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Snart klart.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Snart klart.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP sessions "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Snart klart.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Symptomer</h4><ul><li><p>Et nettsted med Plesk som vert fungerer ikke:</p><pre>You don\'t have permission to access / on this server. <br> I tillegg vises en 403 Forbidden-feil ved forsøk på å bruke et EttorDocument til å håndtere forespørselen.</pre><p>Istedet for ovennevnte feil, kan du også se en tom side.</p></li><li><p>Domenets feillogg i <strong>Domener &gt example.com &gt logger</strong> inneholder følgende:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Feil tillatelser for domenets filer eller mapper.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Reparer tillatelser for nettsideinnholdet',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Les KB-artikkelen og følg instruksjonene</a>.</p></li></ol>',
];