<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propriedades da Chave Adicional',
    'additional-key-info.update' => 'Obter a Chave Adicional',
    'additional-key-info.updateDescription' => 'Recupere a chave adicional e instale-a.',
    'additional-key-info.download' => 'Descarregar Chave',
    'additional-key-info.downloadDescription' => 'Transferir a chave de licença atual.',
    'additional-key-info.install' => 'Instalar Chave',
    'additional-key-info.installDescription' => 'Instalar a chave de licença atual.',
    'additional-key-info.revert' => 'Reverter a Chave',
    'additional-key-info.revertDescription' => 'Reverter para a chave de licença instalada anteriormente.',
    'additional-key-info.revertNotAvailableDescription' => 'Nenhuma chave instalada.',
    'additional-key-info.installSuccess' => 'Começou a instalação da chave de licença.',

    'additional-key-revert.title' => 'Reverter chave adicional',
    'additional-key-revert.success' => 'A chave adicional foi revertida.',

    'additional-key-upload.title' => 'Instalar uma Chave de Licença',
    'additional-key-upload.success' => 'Foi enviada uma nova chave adicional.',

    'additional-keys.title' => 'Chaves de Licença Adicionais',

    'change-owner.title' => 'Reatribuir as assinaturas selecionadas',

    'customers.hint' => 'Aqui, pode gerir as contas dos seus clientes do serviço de alojamento, criar contas em conjunto com assinaturas de serviço, gerir clientes já existentes e remover contas. Para administrar websites, correio ou outros serviços fornecidos a um cliente, vá ao respetivo Painel de Cliente, clicando na ligação da coluna à direita da lista.',

    'customer-domains.hint' => 'Aqui, configura e gere os websites.',

    'customer-subscriptions.hint' => 'Aqui pode gerir as assinaturas do cliente.',

    'domains.hint' => 'Aqui, poderá visualizar as informações sobre todos os nomes de domínios registados no sistema e continuar a gerir os serviços de hospedagem. Para adicionar um domínio para si ou para os clientes de hospedagem, basta clicar em Adicionar Domínio. Poderá criar um novo cliente e subscrição quando cria um domínio ou selecionar a partir de domínios existentes.',

    'database-servers.title' => 'Servidores de Base de Dados',

    'database-server-create.title' => 'Novo servidor de base de dados',

    'database-server-properties.title' => 'Servidor da base de dados',

    'database-server-upgrade.drawerTitle' => 'Atualização de MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Atualização concluída',
    'database-server-upgrade.drawerSubTitle.line1' => 'A gaveta não pode ser fechada enquanto a atualização está a ser executada.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Se ocorrerem problemas durante a atualização consulte %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'O servidor de base de dados MariaDB foi atualizado para a versão %%releaseVersion%%. Se deparar com qualquer problema, siga as instruções %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Já tem a versão LTS instalada.',
    'database-server-upgrade.troubleshootingArticle' => 'neste artigo da KB',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Utilize %%troubleshootingArticle%% para resolver quasiquer problemas na atualização de MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Atualize o seu servidor local de base de dados MariaDB para a atual versão de suporte (LTS) de longo-prazo.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Recomendamos vivamente que efetue uma cópia de segurança do seu servidor antes da atualização e que inicie a atualização durante as horas de menos tráfego dos websites.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Durante a atualização de MariaDB, o servidor Plesk e os websites alojados ficarão indisponíveis. A atualização de MariaDB é habitualmente ausente de erros e demora cerca de 10 minutos, mas mesmo assim pode afetar todo o servidor.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Atenção: se estiver a executar MariaDB 5.5, o Pleask atualiza primeiro para MariaDB 10.5. Depois da atualização estar concluída, volte a iniciar este assistente para atualizar para a versão LTS atual de MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Versão atual',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Selecione a versão para a qual atualizar',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Não há lançamentos maiores',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Notas da versão',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Data de lançamento: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Data do fim de vida: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Só forks MariaDB expedidos pelos fornecedores do sistema operativo ou pelo fornecedor de MariaDB podem ser atualizados.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Verificações pré-atualização',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'A interpretar os ficheiros de configuração de MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'A analisar bases de dados com mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'A analisar a configuração do gestor de pacotes',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'A verificar WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Para continaur a atualização, selecione todas as caixas de verificação. É necessário certificar-se de que aconcorda com as alterações à configuração que serão feitas pela atualização e que tem acesso a opções de recuperação.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'As seguintes variáveis serão removidas para compatibilidade com a nova versão:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} {count, plural, one {do ficheiro {files}} other {dos # ficheiros: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Acesso a opções de recuperação (a consola de linhas de comandos do servidor e Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Confirmo que tenho acesso SSH ao servidor',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Utilize um cliente SSH ou abra %%sshTerminalExtension%% num novo separador do browser (não feche a janela da extensão SSH Terminal até a atualização estar concluída). Se a atualização falhar, ter acesso a SSH ajudará na recuperação.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Extensão SSH Terminal',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Confirmo que tenho acesso ao Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Abra o %%repairKit%% num novo separador do browser e inicie sessão utilizando as credenciais de administrador. Não feche a janela da extensão Repair Kit até a atualização estar concluída.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Efetuar cópias de segurança das bases de dados',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Antes da atualização, faça cópias de segurança de todas as bases de dados alojadas no servidor',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'O Plesk guardará a cópia de segurança das bases de dados no diretório %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket no Plesk não está disponível',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Sem WebSocket, não será possível ver resultados em tempo real do processo de atualização.',

    'database-server-upgrade.submitPopover.title' => 'Para prevenir potencial perda de dados, recomendamos vivamente que crie um dump das bases de dados alojadas antes de avançar. Continuar sem criar um dump?',

    'database-server-databases.title' => 'Bases de dados',

    'database-server-change-password.title' => 'Palavra-passe do Administrador',

    'home.title' => 'Início',

    'license.title' => 'Informações acerca da Licença',

    'primary-key-info.title' => 'Chave de Licença Plesk',
    'primary-key-info.update' => 'Obter Chaves',
    'primary-key-info.updateDescription' => 'Obter as chaves de licença encomendadas e instalá-las.',
    'primary-key-info.upload' => 'Instalar Chave',
    'primary-key-info.uploadDescription' => 'Faça o upload e instale uma nova chave de licença.',
    'primary-key-info.revert' => 'Reverter a Chave',
    'primary-key-info.revertDescription' => 'Reverter para a chave de licença instalada anteriormente.',

    'primary-key-revert.title' => 'Reverter a Chave de Licença',
    'primary-key-revert.success' => 'A chave Plesk foi revertida.',

    'primary-key-upload.title' => 'Instalar uma Chave de Licença',
    'primary-key-upload.success' => 'Foi enviada uma nova chave Plesk.',

    'resellers.hint' => 'Aqui é possível gerir as contas dos revendedores - os seus clientes que revendem serviços de alojamento e alojam os seus próprios sites. Aqui é possível criar contas juntamente com as subscrições de serviços, gerir revendedores já existentes e remover contas.',

    'reseller-customers.hint' => 'Aqui, define e gere os clientes.',

    'reseller-domains.hint' => 'Aqui, configura e gere os websites.',

    'reseller-subscriptions.hint' => 'Aqui, gere as subscrições do revendedor.',

    'subscriptions.hint' => 'Os clientes obtêm serviços de alojamento de si, subscrevendo um plano de alojamento. Pode gerir aqui estas subscrições, bem como as suas próprias subscrições que criou para alojar os seus sites. Para administrar os websites, correio ou qualquer outro serviço fornecido com uma subscrição, vá para o Painel de Cliente do subscritor, clicando na ligação na coluna à direita da lista.',

    'server-mail-settings.title' => 'Configurações',
    'server-mail-spam-filter.title' => 'Filtro Spam',
    'server-mail-antivirus.title' => 'Antivírus',
    'server-mail-black-list.title' => 'Lista Negra',
    'server-mail-white-list.title' => 'Lista Branca',
    'server-mail-queue.title' => 'Fila do Correio',
    'server-mail-statistics.title' => 'Estatísticas',

    'server-spam-filter.title' => 'Definições do filtro de Spam',
    'server-spam-filter.settings' => 'Configurações',
    'server-spam-filter.black-list' => 'Lista negra',
    'server-spam-filter.white-list' => 'Lista branca',

    'firewall.title' => 'Gestão da Firewall',
    'firewall-general.title' => 'Geral',
    'firewall-general.toggleStatus' => 'Proteção por firewall',
    'firewall-general.buttonDefault' => 'Repor predefinição',
    'firewall-general.buttonPanic' => 'Modo de Pânico',
    'firewall-general.confirmationDefault' => 'Repor a configuração da firewall nos seus valores predefinidos?',
    'firewall-general.confirmationPanic' => 'Ativar o Modo de Pânico? Os utilizadores não poderão aceder aos seus domínios e alguns serviços de rede poderão parar de funcionar.',
    'firewall-general.successDefault' => 'As definições da firewall foram repostas nas suas predefinições.',
    'firewall-general.successPanic' => 'O modo de pânico foi ativado.',
    'firewall-general.info' => 'Por motivos de segurança, a firewall bloqueia todas as ligações, exceto as que tenham sido explicitamente autorizadas. Pode permitir uma ligação criando uma regra. Para mais informações consulte a documentação',
    'firewall-general.interfaces' => 'Interfaces de rede',
    'firewall-icmp.title' => 'Protocolo ICMP',
    'firewall-rules.title' => 'Regras da Firewall',

    'dns.title' => 'Definições de DNS',
    'dns-records.title' => 'Modelo de Registos de Zona',
    'dns-soa-record.title' => 'Modelo das Definições da Zona',

    'php-handler.title' => 'Definições para %%name%%',
    'php-handler.extensions.title' => 'Extensões',
    'php-handler.extensions.description' => 'Estas configurações das extensões do PHP são apenas para este manipulador.',
    'php-handler.extensions.descriptionShared' => 'Estas configurações são comuns para os seguintes manipuladores PHP: %%handlers%%. As configurações aplicam-se a todos os sites que utilizam estes manipuladores.',
    'php-handler.extensions.buttonManage' => 'Gerir pacotes PECL',
    'php-handler.extensions.manage.title' => 'Gerir pacotes PECL',
    'php-handler.extensions.manage.risks' => 'As extensões PHP são facultadas por pacotes PECL de terceiros. Está a instalá-las por sua própria conta e risco.',
    'php-handler.extensions.manage.description' => 'Instalar, melhorar e desinstalar pacotes PECL. As alterações serão aplicadas a todos os websites que sejam executados em %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Porque é que o pacote desejado não está na lista?',
    'php-handler.extensions.manage.limitations' => 'As extensões PHP expedidas pelo fornecedor do painel de controlo e vendedores de SO não aparecem na lista.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Informação do Servidor",
    'ServerInformation.refresh' => "Atualizar",
    'ServerInformation.sectionGeneral' => "Geral",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Versão",
    'ServerInformation.os' => "Sistema operativo",
    'ServerInformation.key' => "Chave licença do Plesk",
    'ServerInformation.uptime' => "Tempo de atividade",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dias}} {hours, plural, one {# hora} other {# horas}} {minutes, plural, one {# minuto} other {# minutos}}",
    'ServerInformation.sectionCpu' => "Utilização do CPU",
    'ServerInformation.la1min' => "Último 1 minuto",
    'ServerInformation.la5min' => "Últimos 5 minutos",
    'ServerInformation.la15min' => "Últimos 15 minutos",
    'ServerInformation.sectionMemory' => "Uso de memória",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Total (excluindo o kernel)",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Usada",
    'ServerInformation.memoryFree' => "Livre",
    'ServerInformation.memoryShared' => "Partilhado",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Cached",
    'ServerInformation.memoryAvailable' => "Disponível",
    'ServerInformation.memoryUsage' => "Utilização",
    'ServerInformation.sectionSwap' => "Uso de Swap",
    'ServerInformation.sectionVirtualMemory' => "Utilização da Memória Virtual",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Usada",
    'ServerInformation.swapFree' => "Livre",
    'ServerInformation.swapUsage' => "Utilização",
    'ServerInformation.sectionHarddisk' => "Uso de disco rígido",
    'ServerInformation.harddiskDirectory' => "Sistema de arquivos",
    'ServerInformation.harddiskProtectedDir' => "Directórios protegidos",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Usada",
    'ServerInformation.harddiskAvailable' => "Disponível",
    'ServerInformation.harddiskCapacity' => "Utilização",
    'ServerInformation.sectionDomains' => "Domínios",
    'ServerInformation.activeDomains' => "Ativo",
    'ServerInformation.inactiveDomains' => "Inativo",
    'ServerInformation.problemDomains' => "Problemas",
    'ServerInformation.refreshed' => "Informação atualizada.",

    'ServerAbout.title' => 'Sobre o Plesk',
    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Todos os direitos reservados.',
    'ServerAbout.linkLicenseManagement' => 'Ir para Informações acerca da Licença',
    'ServerAbout.panelVersion' => 'Versão',
    'ServerAbout.installedPatchVersion' => 'Atualizar #%%patch%%',
    'ServerAbout.licenseKey' => 'Chave de licença',
    'ServerAbout.productDescription' => 'Plesk é a principal plataforma WebOps para executar, automatizar e acrescentar aplicações, websites e alojamento.',
    'ServerAbout.readEula' => 'Ler %%link%%.',
    'ServerAbout.linkEula' => 'Acordo de Licença do Utilizador Final',
    'ServerAbout.visitForum' => 'Visitar %%link%%',
    'ServerAbout.linkForum' => 'Fуrum Plesk',
    'ServerAbout.followUs' => 'Siga-nos',
    'ServerAbout.visitSite' => 'Saiba mais em %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Encontre inspiração em %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Parabéns!',
    'ServerAbout.darkThemePromoDescription' => 'Encontrou um gatinho mágico dentro do Plesk Obsidian versão 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Plim! Venha para o lado das trevas',
    'ServerAbout.darkThemeTourDescription' => 'Alterne esta opção para ativar ou desativar o tema escuro para o seu interface.',
    'ServerAbout.darkThemeTourButton' => 'Percebi',

    'ts-sessions.title' => 'Terminal Server Sessions',
    'ts-sessions-properties.title' => 'Propriedades da sessão',

    'BandwidthLimiting.title' => 'Limitação de largura de banda para %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Não pode controlar a largura de banda porque o QoS não está instalado.',
    'BandwidthLimiting.virtualHostingRequired' => 'A limitação de largura de banda só está disponível para domínios com alojamento Web.',
    'BandwidthLimiting.bandwidthLabel' => 'Utilização máxima da largura de banda',
    'BandwidthLimiting.bandwidthHint' => 'O limite de utilização da largura de banda só é aplicado aos dados transferidos através do protocolo HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Ligações limitadas a',
    'BandwidthLimiting.maxConnectionHint' => 'Se limitar a largura de banda, recomendamos que também limite o número de ligações simultâneas ao website. Caso contrário, os processos do servidor web aumentarão a carga do servidor em caso de pedidos frequentes ao website.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'As definições de limitação de largura de banda foram alteradas.',
    'BandwidthLimiting.unlimited' => 'Ilimitado',

    'ip-address-domains.title' => 'Websites que utilizam o endereço IP %%ipAddress%% %%type%%',
    'ip-address-domains.site' => 'Site',
    'ip-address-domains.setAsDefault' => 'Configurar Como Predefinido',
    'ip-address-domains.type-SHARED' => 'partilhado',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicado',

    'HotlinkProtection.title' => 'Proteção Hotlink para %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'A Proteção Hotlink só está disponível em domínios com alojamento Web.',
    'HotlinkProtection.enabledLabel' => 'Ativar proteção Hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensões de ficheiros protegidas',
    'HotlinkProtection.friendsLabel' => 'Endereços de websites amigáveis',
    'HotlinkProtection.success' => 'As definições da proteção Hotlink foram alteradas.',

    'Odbc.serverTitle' => 'Ligações ODBC DSN',
    'Odbc.domainTitle' => 'Ligações ODBC DSN para %%domainName%%',
    'Odbc.add' => 'Adicionar ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% criado / %%allowed%% permitido.',
    'Odbc.limitExceeded' => 'O limite de ligações ODBC DSN foi ultrapassado.',
    'Odbc.unlimited' => 'Ilimitado',
    'Odbc.addTooltip' => 'Adicionar fonte de dados ODBC.',
    'Odbc.status' => 'Estado',
    'Odbc.name' => 'Nome da conexão',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Descrição da conexão',
    'Odbc.hostname' => 'Nome de anfitrião',
    'Odbc.statusSystem' => 'é um DSN de sistema.',
    'Odbc.statusConfigured' => 'DSN configurado.',
    'Odbc.statusNotConfigured' => 'DSN não configurado.',
    'Odbc.noSelectionText' => 'Selecione um ou mais artigos para remover.',
    'Odbc.removeConfirmation' => 'Remover {count, plural, =1 {a ligação {name}} other {as # ligações selecionadas}}?',
    'Odbc.removeSuccess' => 'As ligações selecionadas foram removidas.',

    'DomainAliasSettings.title' => 'Definições do nome alternativo do domínio',
    'DomainAliasSettings.updateSuccess' => 'As propriedades do nome alternativo do domínio %%name%% foram modificadas. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'As configurações do site serão aplicadas em %%restartInterval%% minutos.',

    'Home.Backup.title' => 'Último backup do servidor',
    'Home.Backup.offStatus' => 'Este backup não é válido. Não é possível restaurar dados a partir deste ficheiro.',
    'Home.Backup.task-failedStatus' => 'Ocorreu uma tarefa de cópia de segurança.',
    'Home.Backup.activeSchedule' => 'Agenda: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Agendas: %%schedules%%',
    'Home.Backup.noSchedule' => "A agenda de backup não está definida",
    'Home.Backup.period_hourly' => 'A cada hora %%schedule%%',
    'Home.Backup.period_daily' => 'Diariamente %%schedule%%',
    'Home.Backup.period_weekly' => 'Semanalmente %%schedule%%',
    'Home.Backup.period_monthly' => 'Mensalmente %%schedule%%',
    'Home.Backup.create' => 'Criar um backup',
    'Home.Backup.schedule' => 'Agenda',
    'Home.Customization.title' => 'Painel de controlo',
    'Home.Customization.description' => 'Escolha as opções que gostaria de ver',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Servidor',
    'Home.Customization.securitySection' => 'Segurança',
    'Home.Customization.backup' => 'Último backup',
    'Home.Customization.ipBan' => 'Exclusão de endereços IP',
    'Home.Customization.mailQueue' => 'Fila do Correio',
    'Home.Customization.mySubscriptions' => 'As minhas assinaturas',
    'Home.Customization.overusedSubscriptions' => 'Assinaturas utilizadas em excesso',
    'Home.Customization.serverInfo' => 'Informação do Servidor',
    'Home.Customization.updates' => 'Atualizações do Plesk',
    'Home.Customization.promo' => 'Promoção',
    'Home.Extension.title' => 'Extensão',
    'Home.IpBan.title' => 'Exclusão de endereços IP',
    'Home.IpBan.banned' => 'Banidos',
    'Home.IpBan.trusted' => 'Fiáveis',
    'Home.IpBan.more' => 'Ver mais',
    'Home.MailQueue.title' => 'Fila do correio',
    'Home.MailQueue.total' => 'Total',
    'Home.MailQueue.deferred' => 'Deferido',
    'Home.MailQueue.held' => 'Retido',
    'Home.MailQueue.more' => 'Ver mais',
    'Home.MailQueue.clean' => 'Limpar fila do correio',
    'Home.MailQueue.checkLogs' => 'Verificar registos',
    'Home.MailQueue.repair' => 'Reparar',
    'Home.MailQueue.cleanConfirmQuestion' => 'Limpar a fila do correio?',
    'Home.MailQueue.cleanConfirmYes' => 'Sim',
    'Home.MailQueue.cleanConfirmNo' => 'Não',
    'Home.MailQueue.queueCleaned' => 'A fila de correio foi limpa com sucesso.',
    'Home.OverusedSubscriptions.title' => 'Assinaturas em utilização excessiva',
    'Home.OverusedSubscriptions.empty' => 'Não foram encontradas assinaturas em utilização excessiva',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% de %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Ver todas em utilização excessiva: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Abrir na lista',
    'Home.ServerInfo.title' => 'Informação do Servidor',
    'Home.ServerInfo.hostname' => 'Nome de anfitrião',
    'Home.ServerInfo.ipAddress' => 'Endereço IP',
    'Home.ServerInfo.publicIpAddress' => 'Endereço IP público',
    'Home.ServerInfo.os' => 'SO',
    'Home.ServerInfo.uptime' => 'Tempo de atividade',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dia} other {# dias}} {hours, plural, one {# hora} other {# horas}} {minutes, plural, one {# minuto} other {# minutos}}",
    'Home.ServerInfo.more' => 'Ver mais',
    'Home.Subscriptions.title' => 'As minhas assinaturas',
    'Home.Subscriptions.add' => 'Adicionar nova',
    'Home.Subscriptions.empty' => 'Crie assinaturas para hospedar vários websites num espaço isolado no servidor. %%link%%',
    'Home.Subscriptions.help' => 'Saber mais',
    'Home.Updates.title' => 'Atualizações de produto',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => 'Atualização %%version%%, n.º %%patch%%',
    'Home.Updates.manageComponents' => 'Adicionar ou Remover Componentes',
    'Home.Updates.lastUpdated' => 'Última atualização a %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Verificar atualizações',
    'Home.Updates.enableAutoupdate' => 'Permitir atualizações automáticas',
    'Home.Updates.lastChecked' => 'Última verificação a %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% está disponível',
    'Home.Updates.installNewVersion' => 'Instalar Agora',
    'Home.Updates.patchAvailable' => 'Estão disponíveis atualizações pequenas',
    'Home.Updates.patchAvailableVersion' => 'Estão disponíveis atualizações pequenas para %%currentVersion%%',
    'Home.Updates.installPatch' => 'Atualizar Agora',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Está disponível uma atualização para {package}} other {Estão disponíveis atualizações para {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# pacote} other {# pacotes}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Atualizar agora} other {Atualizar tudo}}',
    'Home.Promo.Customize.title' => 'Iniciar a renovação da página!',
    'Home.Promo.Customize.content' => 'O painel de controlo personalizado combina as suas funcionalidades favoritas num único lugar',
    'Home.Promo.Customize.action' => 'Personalizar',
    'Home.Promo.SwitchToPuv.title' => 'Conhece as visualizações da interface do Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Se não fornecer serviços de alojamento aos seus clientes utilizando os planos de serviço, talvez queira experimentar a interface mais conveniente para gerir páginas web, os seus ficheiros, bases de dados, contas de e-mail e aplicações web.',
    'Home.Promo.SwitchToPuv.action' => 'Experimentar agora',

    'HostingSettings.title' => 'Configurações de alojamento',
    'HostingSettings.updateSuccess' => 'As definições foram atualizadas.',
    'HostingSettings.emptyLogin' => 'É necessário especificar um nome de utilizador.',
    'HostingSettings.emptyPassword' => 'É necessário especificar uma palavra-passe.',
    'HostingSettings.ipV6OnlyNotSupported' => 'O servidor de FTP não suporta IPv6. Alocar pelo menos um endereço IPv4, caso contrário, o utilizador não conseguirá carregar ficheiros para o servidor via FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Preferências de domínio',
    'HostingSettings.domainSettingsSection.domainName' => 'Nome do domínio',
    'HostingSettings.domainSettingsSection.description' => 'Por exemplo, example.com ',

    'HostingSettings.submitPopover.title' => 'Remover o conteúdo de %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Mudar o tipo de alojamento de "Website" para "%%type%%" permitirá remover todo o conteúdo do website, incluindo os seguintes diretórios:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Gostaria de alterar o tipo de alojamento para o seu site?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Para aceder a mais definições, introduza as credenciais de utilizador do sistema e, em seguida, clique em "Criar espaço na rede".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Para aceder a mais definições, clique em "Seguinte" para criar alojamento.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipo de alojamento',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipo',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Página web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redirecionamento',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Sem alojamento web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Utilize a zona DNS do domínio para ter caixas de correio sob este nome de domínio',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'O caminho para o diretório inicial do website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Os visitantes serão redirecionados para aqui através de um redirecionamento SEO amigável HTTP 301.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Reencaminhar visitantes para',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipo de re-endereçamento',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Movido permanentemente (código 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redirecionar os visitantes do website para outro site e mostrar o endereço de destino. Este redirecionamento irá manter a classificação de pesquisa do site',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Movido temporariamente (código 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redirecione os visitantes do site para uma cópia temporária do site se não quiser que os motores de busca indexem este site temporário.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Re-endereçamento em Janela',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redirecionar as visitas do web site para outro site e não exibir o endereço de destino, de modo a que não se apercebam do redirecionamento.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Domínio preferido',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Nenhum',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Raiz do documento',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'É impossível mudar a raiz do documento porque há aplicações da web instaladas neste site.',
    'HostingSettings.domainSettingsSection.save' => 'Gravar',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Modo de compatibilidade',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Deixe o site a funcionar no modo de compatibilidade para a opção de legado "Separar conteúdo SSL/TLS e não SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Este website está a funcionar no modo de compatibilidade, pelo que não pode ser gerido através da interface do Plesk. Isto deve-se ao facto de ter utilizado a opção descontinuada "Separar conteúdo SSL/TLS e não SSL/TLS" antes da atualização. A partir do Plesk 11, o website passará a armazenar o conteúdo disponível por meio de ligações HTTP e HTTPS no mesmo diretório. Recomendamos que mova todos os dados do diretório "httpsdocs/" para "httpdocs/" e que, em seguida, desative o modo de compatibilidade. Isso também fará com que as aplicações instaladas no diretório "httpsdocs/" sejam acessíveis pela Internet. Atenção: não poderá voltar a ativar o modo de compatibilidade.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Mudar esta definição?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Mudar esta definição contradiz a política de segurança do servidor, podendo prejudicar o desempenho ou tornar o servidor vulnerável a ataques.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Alterar',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Reverter',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'As predefinições da política de segurança foram aplicadas',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Parta maior segurança, aplique os valores predefinmidos de segurança. Tenha em conta que certas permissões permitem que os subscritores modifiquem estas definições.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicar predefinição segura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Mais informações acerca das definições de alojamento seguro',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Suporte SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Ativado',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Encriptar ligações entre o website e o browser do visitante.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificado',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Para ativar HTTPS, envie um certificado SSL/TLS para o repositório do domínio e depois selecione-o a partir daí.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redirecionar visitantges de HTTP para HTTPS através de um redirecionamento SEO amigável 301',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Não existem certificados SSL/TLS no seu repositório. Para adicionar um certificado, vá até %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'esta página',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (outro repositório)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Não selecionado',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Selecione a linguagem de programação e scripting a ser interpretada pelo servidor web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'o diretório cgi-bin está localizado em %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Utilização adicional de SSI para *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versão Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documentos personalizados de erro',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'o diretório cgi-bin está localizado em',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'o documento raiz deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'o diretório raiz do espaço na rede',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'a raiz anterior deste domínio',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documentos personalizados de erro',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permissões adicionais de escrita/modificação',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicação do Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Estatísticas de rede',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Ferramenta',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Proteger o acesso às suas estatísticas da web com o seu nome de utilizador e palavra-passe FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Desativado',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Configurações do espaço de rede',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Endereços IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Quota de espaço no disco',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Ativado',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Proibir operações nos ficheiros do website se a quota de espaço em disco definida nas definições da subscrição (caso existam) forem ultrapassadas.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'A quota de espaço no disco não é suportada devido à configuração do sistema de ficheiros do servidor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credenciais de sistema do utilizador',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gerir os ficheiros e pastas do website através de FTP ou File Manager. É permitido o acesso ao servidor através de SSH.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gerir os ficheiros e pastas do website através de FTP ou File Manager. É permitido o acesso ao servidor através de Remote Desktop.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nome de utilizador',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Senha',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Especifique aqui uma nova palavra-passe para mudar a palavra-passe do utilizador do sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Acesso SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Acesso ao Remote Desktop',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Ativado',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Aceder ao servidor com credenciais do utilizador do sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipo',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Desativado',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Para {count, plural, other {# domínios}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'As seguintes definições são mútuas para os {count, plural, other {# domínios do webspace {name}}}:',

    'OdbcAdd.title' => 'Adicionar um ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nome da conexão',
    'OdbcAdd.descriptionLabel' => 'Descrição da conexão',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Criar ODBC DSN',

    'OdbcEdit.title' => 'Configure uma Conexão ODBC',
    'OdbcEdit.saveSuccess' => 'As definições de ligação foram guardadas.',
    'OdbcEdit.test' => 'Testar a conexão',
    'OdbcEdit.connectSuccess' => 'Conexão bem sucedida.',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Caminho do ficheiro da base de dados',
    'OdbcEdit.excel.defaultdir.label' => 'Directório de dados predefinido',
    'OdbcEdit.excel.fil.label' => 'Versão da Base de Dados',
    'OdbcEdit.excel.maxbuffersize.label' => 'Tamanho máximo do buffer',
    'OdbcEdit.excel.pagetimeout.label' => 'Tempo de ócio da página',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Caminho do ficheiro da base de dados',
    'OdbcEdit.access.uid.label' => 'ID de Login',
    'OdbcEdit.access.pwd.label' => 'Senha',
    'OdbcEdit.access.pagetimeout.label' => 'Tempo de ócio da página',
    'OdbcEdit.access.pagetimeout.description' => 'O período de tempo, em decimas de segundo, que uma página não utilizada fica na buffer. Esta opção é aplicada a todas as fontes de dados que utilizam o driver do Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Tamanho máximo do buffer',
    'OdbcEdit.access.maxbuffersize.description' => 'O tamanho da buffer interna, em KB, alinhados ao limite de 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Apenas leitura',
    'OdbcEdit.access.readonly.description' => 'Marca a base de dados como só de leitura para não permitir actualizações.',
    'OdbcEdit.access.exclusive.label' => 'Exclusivo',
    'OdbcEdit.access.exclusive.description' => 'Marca a base de dados como exclusiva para não permitir a partilha de actualizações.',
    'OdbcEdit.access.safetransactions.label' => 'Transações seguras',
    'OdbcEdit.access.safetransactions.description' => 'Caso 0, predefinido, todas as transações são efetuadas imediatamente. Caso 1, todas as transações só são gravadas no disco após uma operação de escrita (commit operation), mas o desempenho é ligeiramente reduzido.',
    'OdbcEdit.access.threads.label' => 'Operações',
    'OdbcEdit.access.threads.description' => 'O número de operações em background que o motor irá utilizar.',
    'OdbcEdit.access.maxscanrows.label' => 'Máximo de linhas a examinar',
    'OdbcEdit.access.maxscanrows.description' => 'O número de linhas a serem varridas quando definir o tipo de dados de uma coluna baseado nos dados existentes.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Especifica como as modificações efectuadas fora de uma transacção são escritas na base de dados.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Especifica se o driver do MS Access executará as transacções explícitas, definidas pelo utilizador, assincronamente.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Servidor',
    'OdbcEdit.mssql.uid.label' => 'ID de Login',
    'OdbcEdit.mssql.pwd.label' => 'Senha',
    'OdbcEdit.mssql.database.label' => 'Base de dados predefinida',
    'OdbcEdit.mssql.app.label' => 'Nome da aplicação',
    'OdbcEdit.mssql.wsid.label' => 'ID da estação de trabalho',
    'OdbcEdit.mssql.language.label' => 'Linguagem predefinida',
    'OdbcEdit.mssql.oemtoansi.label' => 'Este parâmetro especifica se deve converter os carateres ANSI em valores OEM',

    'OdbcEdit.mysql.driver.label' => 'Driver MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Servidor',
    'OdbcEdit.mysql.server.description' => 'O nome de host do servidor de MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Base de dados predefinida',
    'OdbcEdit.mysql.user.label' => 'Nome de utilizador',
    'OdbcEdit.mysql.user.description' => 'O nome de utilizador utilizado para ligar ao MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Senha',
    'OdbcEdit.mysql.password.description' => 'A palavra-passe da conta de utilizador no servidor',
    'OdbcEdit.mysql.port.label' => 'Porta',
    'OdbcEdit.mysql.port.description' => 'A porta TCP/IP a utilizar se o servidor não for o localhost',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'O \'Windows named pipe\' ao qual ligar se o servidor for localhost',
    'OdbcEdit.mysql.option.label' => 'Opção',
    'OdbcEdit.mysql.option.description' => 'Opções que especificam como é que MyODBC deve funcionar. Consulte a <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentação</a>',

    'ProtectedDirectoryList.title' => 'Diretórios Protegidos de %%domainName%%',
    'ProtectedDirectoryList.add' => 'Adicionar Diretório Protegido',
    'ProtectedDirectoryList.addTooltip' => 'Criar diretório protegido.',
    'ProtectedDirectoryList.name' => 'Nome',
    'ProtectedDirectoryList.realmTitle' => 'Título da área protegida',
    'ProtectedDirectoryList.noSelectionText' => 'Selecione um ou mais artigos para remover.',
    'ProtectedDirectoryList.edit' => 'Editar',
    'ProtectedDirectoryList.remove' => 'Remover Proteção',
    'ProtectedDirectoryList.removeTooltip' => 'Remover a proteção dos diretórios selecionados.',
    'ProtectedDirectoryList.removeConfirmation' => 'Esta operação resultará na remoção de proteção {count, plural, =1 {do diretório {name}} other {dos # diretórios selecionados}}. {count, plural, =1 {Este diretório tornar-se-á livremente acessível} other {Os diretórios tornar-se-ão livremente acessíveis}} aos utilizadores da Internet.',
    'ProtectedDirectoryList.removeSuccess' => 'Os diretórios selecionados foram removidos.',

    'ProtectedDirectoryAdd.title' => 'Criar Diretório Protegido',
    'ProtectedDirectoryAdd.submit' => 'Criar',
    'ProtectedDirectoryAdd.success' => 'O diretório protegido %%path%% foi criado com sucesso',

    'ProtectedDirectoryEdit.title' => 'Definições de Diretórios Protegidos',
    'ProtectedDirectoryEdit.success' => 'As configurações do diretório protegido foram alteradas',

    'ProtectedDirectoryUserList.title' => 'Utilizadores do diretório protegido %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Adicionar Utilizador',
    'ProtectedDirectoryUserList.addTooltip' => 'Criar contas de utilizador capazes de aceder ao diretório protegido %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Nome',
    'ProtectedDirectoryUserList.changePassword' => 'Alterar senha',
    'ProtectedDirectoryUserList.noSelectionText' => 'Selecione um ou mais utilizadores a remover.',
    'ProtectedDirectoryUserList.remove' => 'Eliminar',
    'ProtectedDirectoryUserList.removeTooltip' => 'Remover os utilizadores selecionados.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Remover {count, plural, =1 {o utilizador {login}} other {os # utilizadores selecionados}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Os utilizadores selecionados foram removidos.',

    'ProtectedDirectoryUserAdd.title' => 'Criar utilizador do diretório protegido',
    'ProtectedDirectoryUserAdd.subtitle' => 'Diretório %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nome de utilizador',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Senha',
    'ProtectedDirectoryUserAdd.submit' => 'Criar',
    'ProtectedDirectoryUserAdd.success' => 'Foi criado o utilizador do diretório protegido %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Senha para o utilizador de directório protegido',
    'ProtectedDirectoryUserPassword.subtitle' => 'Utilizador %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Senha',
    'ProtectedDirectoryUserPassword.submit' => 'Gravar',
    'ProtectedDirectoryUserPassword.success' => 'As credenciais do utilizador foram guardadas.',

    'SummaryReport.Layout.title' => 'Propriedades do Formato de Relatório',
    'SummaryReport.Layout.success' => 'O formato do relatório %%name%% foi atualizado.',
    'SummaryReport.Layouts.title' => 'Formatos de Relatórios',

    'SummaryReport.Layout.Add.title' => 'Criar Formato de Relatório',
    'SummaryReport.Layout.Add.success' => 'Foi criado o formato de relatório %%name%%.',

    'SummaryReport.Report.title' => 'Relatório resumido',
    'SummaryReport.Report.buttonLayouts' => 'Esquemas',
    'SummaryReport.Report.buttonSchedule' => 'Agenda',
    'SummaryReport.Report.buttonProperties' => 'Propriedades',
    'SummaryReport.Report.buttonTrafficHistory' => 'Histórico do Tráfego',
    'SummaryReport.Report.buttonPrint' => 'Imprimir',
    'SummaryReport.Report.buttonSend' => 'Enviar Por E-mail',
    'SummaryReport.Report.successSent' => 'O relatório foi enviado para %%email%%',

    'SummaryReport.Schedule.title' => 'Agendamentos de entregas para %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Agendamento de entrega para %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Foi actualizada a agenda uma entrega de relatório.',

    'SummaryReport.Schedule.Add.title' => 'Criar agendamentos de entrega para %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Foi agendado uma entrega de relatório.',

    'SummaryReport.TrafficHistory.title' => 'Histórico do Tráfego',

    'VirtualDirectory.title' => 'Diretório Virtual %%path%% de %%domainName%%',
    'VirtualDirectory.errNotExist' => 'Este diretório virtual está ligado a uma pasta física inexistente.',
    'VirtualDirectory.errNoPermissions' => 'Não tem permissão para ver os conteúdos deste diretório.',
    'VirtualDirectory.buttonProperties' => 'Propriedades do Directório',
    'VirtualDirectory.buttonPropertiesHint' => 'Ver e mudar as propriedades do directório virtual.',
    'VirtualDirectory.buttonPermissions' => 'Permissões de Acesso de Directório',
    'VirtualDirectory.buttonPermissionsHint' => 'Configurar as permissões de acesso a um directório.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Configurar definições de ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Configurar definições de PHP.',
    'VirtualDirectory.buttonMimeTypes' => 'MIME Type',
    'VirtualDirectory.buttonMimeTypesHint' => 'Gerir tipos de MIME registados.',
    'VirtualDirectory.buttonErrorDocs' => 'Documentos de Erros',
    'VirtualDirectory.buttonErrorDocsHint' => 'Gerir documentos de erros.',
    'VirtualDirectory.buttonProtection' => 'Protecção',
    'VirtualDirectory.buttonProtectionHint' => 'Restringir o acesso ao diretório com proteção por palavra-passe.',

    'VirtualDirectory.CreateDirectory.title' => 'Criar diretório',
    'VirtualDirectory.CreateDirectory.name' => 'Nome do diretório',
    'VirtualDirectory.CreateDirectory.success' => 'O diretório %%name%% foi criado.',
    'VirtualDirectory.CreateDirectory.errExists' => 'O diretório %%name%% já existe.',

    'VirtualDirectory.AspDotNet.title' => 'Configurar definições de ASP.NET',

    'VirtualDirectory.Php.title' => 'Versão de PHP',
    'VirtualDirectory.Php.version' => 'Versão',
    'VirtualDirectory.Php.success' => 'A versão do PHP foi atualizada.',
];