<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Dodatkowe właściwości klucza',
    'additional-key-info.update' => 'Pobierz dodatkowy klucz',
    'additional-key-info.updateDescription' => 'Pobierz dodatkowe klucze i zainstaluj je.',
    'additional-key-info.download' => 'Pobierz klucz',
    'additional-key-info.downloadDescription' => 'Kliknij, aby pobrać aktualny klucz licencyjny.',
    'additional-key-info.install' => 'Zainstaluj klucz',
    'additional-key-info.installDescription' => 'Zainstaluj aktualny klucz licencyjny.',
    'additional-key-info.revert' => 'Przywróć klucz',
    'additional-key-info.revertDescription' => 'Przywróć poprzednio zainstalowany klucz licencyjny.',
    'additional-key-info.revertNotAvailableDescription' => 'Nie znaleziono żadnego starego klucza.',
    'additional-key-info.installSuccess' => 'Rozpoczęto instalację klucza licencyjnego.',

    'additional-key-revert.title' => 'Dodatkowe cofanie klucza',
    'additional-key-revert.success' => 'Dodatkowy klucz został wycofany.',

    'additional-key-upload.title' => 'Zainstaluj klucz licencyjny',
    'additional-key-upload.success' => 'Nowy klucz dodatkowy został załadowany.',

    'additional-keys.title' => 'Dodatkowe klucze licencji',

    'change-owner.title' => 'Zmiana przypisania wybranych subskrypcji',

    'customers.hint' => 'Tutaj możesz zarządzać serwerem, konfigurować panel, usługi systemowe i zasoby: tutaj możesz tworzyć konta wraz z subskrypcjami usług, zarządzać istniejącymi klientami oraz usuwać konta. Aby administrować stronami WWW, pocztą lub innymi usługami dostępnymi dla klienta, idź do Panelu klienta, klikając link w prawej kolumnie listy.',

    'customer-domains.hint' => 'Tutaj należy konfigurować serwisy WWW oraz zarządzać nimi.',

    'customer-subscriptions.hint' => 'Tutaj możesz zarządzać subskrypcjami klienta.',

    'domains.hint' => 'Tutaj możesz zobaczyć informacje o wszystkich nazwach domen zarejestrowanych w systemie i możesz przejść do zarządzania usługami hostingowymi. Aby dodać domenę dla siebie lub do klientów hostingu, kliknij Dodaj domenę. Otrzymasz podpowiedź utworzenia nowego klienta oraz subskrypcji podczas tworzenia domeny lub wybrania istniejącej.',

    'database-servers.title' => 'Serwery baz danych',

    'database-server-create.title' => 'Nowy serwer baz danych',

    'database-server-properties.title' => 'Serwer bazy danych',

    'database-server-upgrade.drawerTitle' => 'Aktualizacja MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Aktualizacja zakończona',
    'database-server-upgrade.drawerSubTitle.line1' => 'Nie można zamknąć tego okna podczas aktualizacji.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Jeśli podczas aktualizacji wystąpią problemy, wykorzystaj %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Serwer bazy danych MariaDB został zaktualizowany do wersji %%releaseVersion%%. Jeśli napotkasz jakiekolwiek problemy, postępuj zgodnie z instrukcjami, które zawiera %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Masz już zainstalowaną wersję LTS.',
    'database-server-upgrade.troubleshootingArticle' => 'ten artykuł z bazy wiedzy',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Wykorzystaj %%troubleshootingArticle%%, aby rozwiązać problemy z aktualizacją MariaDB.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Zaktualizuj lokalny serwer bazy danych MariaDB do aktualnej wersji z długoterminowym wsparciem (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Zdecydowanie zalecamy utworzenie kopii zapasowej serwera przed aktualizacją i rozpoczęcie aktualizacji poza godzinami szczytu działania witryn internetowych.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Podczas aktualizacji MariaDB serwer Plesk i hostowane strony internetowe będą niedostępne. Aktualizacja MariaDB jest zwykle bezbłędna i zajmuje około 10 minut, ale nadal może mieć wpływ na cały serwer.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Uwaga: jeśli korzystasz z MariaDB 5.5, Plesk najpierw zaktualizuje ją do MariaDB 10.5. Po zakończeniu aktualizacji uruchom ponownie tego kreatora, aby zaktualizować MariaDB do bieżącej wersji LTS.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Obecna wersja',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Wybierz wersję, do której chcesz dokonać aktualizacji',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Nie ma żadnych większych wydań',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Informacje o wydaniu',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Data wydania: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Data końca życia: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Aktualizować można wyłącznie wersje MariaDB dostarczane przez dostawców systemów operacyjnych lub dostawców MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontrole przed aktualizacją',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Analizowanie plików konfiguracyjnych MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analiza baz danych za pomocą mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analizowanie konfiguracji menedżera pakietów',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Sprawdzanie protokołu WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Aby kontynuować aktualizację, zaznacz wszystkie pola wyboru. Konieczne jest upewnienie się, że zgadzasz się ze zmianami konfiguracji, jakie spowoduje aktualizacja i że masz dostęp do opcji odzyskiwania.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Następujące zmienne zostaną usunięte w celu zapewnienia zgodności z nową wersją:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} z {count, plural, one {pliku: {files}} few {# plików: {files}} many {# plików: {files}} other {# plików: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Dostęp do opcji odzyskiwania (konsola wiersza poleceń serwera i Zestaw Naprawczy)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Potwierdzam, że mam dostęp SSH do serwera',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Użyj klienta SSH lub otwórz %%sshTerminalExtension%% w nowej karcie przeglądarki (nie zamykaj okna rozszerzenia SSH Terminal do czasu zakończenia aktualizacji). Jeśli aktualizacja się nie powiedzie, dostęp do SSH pomoże w odzyskaniu danych.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Rozszerzenie terminala SSH',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Potwierdzam, że mam dostęp do Zestawu Naprawczego',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Otwórz %%repairKit%% w nowej karcie przeglądarki i zaloguj się przy użyciu danych administratora. Nie zamykaj karty Repair Kit, dopóki aktualizacja nie będzie ukończona.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Stwórz kopie zapasowe baz danych',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Przed aktualizacją wykonaj kopię zapasową wszystkich baz danych hostowanych na serwerze',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk będzie przechowywać kopię zapasową baz danych w katalogu %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket w Plesku nie jest dostępny',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Bez protokołu WebSocket nie będzie można zobaczyć wyników procesu aktualizacji w czasie rzeczywistym.',

    'database-server-upgrade.submitPopover.title' => 'Aby zapobiec potencjalnej utracie danych, zdecydowanie zalecamy utworzenie zrzutu hostowanych baz danych przed kontynuowaniem. Kontynuować bez tworzenia zrzutu?',

    'database-server-databases.title' => 'Bazy danych',

    'database-server-change-password.title' => 'Hasło administratora',

    'home.title' => 'Start',

    'license.title' => 'Informacje na temat licencji',

    'primary-key-info.title' => 'Klucz licencji Plesk',
    'primary-key-info.update' => 'Odzyskaj klucze',
    'primary-key-info.updateDescription' => 'Pobierz i zainstaluj zamówiony klucz licencji.',
    'primary-key-info.upload' => 'Zainstaluj klucz',
    'primary-key-info.uploadDescription' => 'Kliknij, aby wgrać i zainstalować nowy klucz licencji.',
    'primary-key-info.revert' => 'Przywróć klucz',
    'primary-key-info.revertDescription' => 'Przywróć poprzednio zainstalowany klucz licencyjny.',

    'primary-key-revert.title' => 'Przywrócenie klucza',
    'primary-key-revert.success' => 'Klucz Pleska został wycofany.',

    'primary-key-upload.title' => 'Zainstaluj klucz licencyjny',
    'primary-key-upload.success' => 'Nowy klucz Plesk został załadowany.',

    'resellers.hint' => 'Tutaj możesz zarządzać kontami sprzedawców – twoich klientów, którzy sprzedają usługi hostingowe i hostują swoje własne strony WWW. Tutaj możesz tworzyć konta wraz z subskrypcjami usług, zarządzać istniejącymi sprzedawcami oraz usuwać konta.',

    'reseller-customers.hint' => 'Tutaj konfigurujesz klientów i zarządzasz nimi.',

    'reseller-domains.hint' => 'Tutaj należy konfigurować serwisy WWW oraz zarządzać nimi.',

    'reseller-subscriptions.hint' => 'Tutaj możesz zarządzać subskrypcjami sprzedawcy.',

    'subscriptions.hint' => 'Klienci otrzymują od ciebie usługi hostingowe poprzez subskrypcję planów hostingowych. Tutaj możesz zarządzać tymi subskrypcjami, jak i tymi, które stworzysz, aby hostować swoje własne strony WWW. Aby administrować serwisy, pocztę lub inne usługi dostępne w tej subskrypcji, przejdź do Panelu klienta subskrybenta, klikając link w prawej kolumnie listy.',

    'server-mail-settings.title' => 'Ustawienia',
    'server-mail-spam-filter.title' => 'Filtrowanie spamu',
    'server-mail-antivirus.title' => 'Antywirus',
    'server-mail-black-list.title' => 'Czarna lista',
    'server-mail-white-list.title' => 'Biała lista',
    'server-mail-queue.title' => 'Kolejka poczty',
    'server-mail-statistics.title' => 'Statystyki',

    'server-spam-filter.title' => 'Ustawienia filtru antyspamowego',
    'server-spam-filter.settings' => 'Ustawienia',
    'server-spam-filter.black-list' => 'Czarna lista',
    'server-spam-filter.white-list' => 'Biała lista',

    'firewall.title' => 'Zarządzanie Zaporą Ogniową',
    'firewall-general.title' => 'Ogólny',
    'firewall-general.toggleStatus' => 'Ochrona firewall',
    'firewall-general.buttonDefault' => 'Przywróć ustawienia domyślne',
    'firewall-general.buttonPanic' => 'Tryb Paniki',
    'firewall-general.confirmationDefault' => 'Czy na pewno chcesz przywrócić domyślne ustawienia zapory ogniowej?',
    'firewall-general.confirmationPanic' => 'Włączyć tryb paniki? Użytkownicy nie będą mogli uzyskać dostępu do swoich domen, a niektóre usługi sieciowe mogą przestać działać.',
    'firewall-general.successDefault' => 'Ustawienia zapory zostały zresetowane do wartości domyślnych.',
    'firewall-general.successPanic' => 'Włączono tryb paniki.',
    'firewall-general.info' => 'Ze względów bezpieczeństwa zapora blokuje wszystkie połączenia z wyjątkiem tych wyraźnie dozwolonych. Możesz zezwolić na połączenie, tworząc regułę. Więcej informacji można znaleźć w dokumentacji',
    'firewall-general.interfaces' => 'Interfejsy sieciowe',
    'firewall-icmp.title' => 'Protokołów ICMP',
    'firewall-rules.title' => 'Reguły zapory ogniowej',

    'dns.title' => 'Ustawienia DNS',
    'dns-records.title' => 'Szablon rekordów strefy',
    'dns-soa-record.title' => 'Szablon ustawień strefy',

    'php-handler.title' => 'Ustawienia dla %%name%%',
    'php-handler.extensions.title' => 'Rozszerzenia',
    'php-handler.extensions.description' => 'Te ustawienia rozszerzeń PHP są tylko dla tego uchwytu.',
    'php-handler.extensions.descriptionShared' => 'Te ustawienia są wspólne dla następujących uchwytów PHP: %%handlers%%. Ustawienia mają zastosowanie do wszystkich serwisów WWW, które używają tych uchwytów.',
    'php-handler.extensions.buttonManage' => 'Zarządzaj pakietami PECL',
    'php-handler.extensions.manage.title' => 'Zarządzaj pakietami PECL',
    'php-handler.extensions.manage.risks' => 'Rozszerzenia PHP są dostarczane przez pakiety PECL innych firm. Instalujesz je na własne ryzyko.',
    'php-handler.extensions.manage.description' => 'Instaluj, aktualizuj i odinstaluj pakiety PECL. Zmiany zostaną zastosowane do wszystkich witryn działających na %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Dlaczego żądanego pakietu nie ma na liście?',
    'php-handler.extensions.manage.limitations' => 'Rozszerzenia PHP dostarczane przez dostawcę panelu sterowania i dostawców systemu operacyjnego nie są wyświetlane na liście.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Informacje o serwerze",
    'ServerInformation.refresh' => "Odśwież",
    'ServerInformation.sectionGeneral' => "Ogólny",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Wersja",
    'ServerInformation.os' => "System operacyjny",
    'ServerInformation.key' => "Klucz licencji Plesk",
    'ServerInformation.uptime' => "Czas działania",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dzień} few {# dni} many {# dni} other {# dni}} {hours, plural, one {# godzina} few {# godziny} many {# godzin} other {# godzin}} {minutes, plural, one {# minuta} few {# minuty} many {# minut} other {# minut}}",
    'ServerInformation.sectionCpu' => "Użycie CPU",
    'ServerInformation.la1min' => "Ostatnia 1 minuta",
    'ServerInformation.la5min' => "Ostatnie 5 minut",
    'ServerInformation.la15min' => "Ostatnie 15 minut",
    'ServerInformation.sectionMemory' => "Użycie pamięci",
    'ServerInformation.memoryHardware' => "Sprzęt",
    'ServerInformation.memoryTotalNoKernel' => "Razem (bez jądra)",
    'ServerInformation.memoryTotal' => "Suma",
    'ServerInformation.memoryUsed' => "Zużyto",
    'ServerInformation.memoryFree' => "Pusty",
    'ServerInformation.memoryShared' => "Współdzielony",
    'ServerInformation.memoryBuffer' => "Bufor",
    'ServerInformation.memoryCached' => "W pamięci podręcznej",
    'ServerInformation.memoryAvailable' => "Dostępne",
    'ServerInformation.memoryUsage' => "Użycie",
    'ServerInformation.sectionSwap' => "Użycie swapu",
    'ServerInformation.sectionVirtualMemory' => "Użycie Pamięci Wirtualnej",
    'ServerInformation.swapTotal' => "Suma",
    'ServerInformation.swapUsed' => "Zużyto",
    'ServerInformation.swapFree' => "Pusty",
    'ServerInformation.swapUsage' => "Użycie",
    'ServerInformation.sectionHarddisk' => "Użycie dysku",
    'ServerInformation.harddiskDirectory' => "System plików",
    'ServerInformation.harddiskProtectedDir' => "Chronione katalogi",
    'ServerInformation.harddiskTotal' => "Suma",
    'ServerInformation.harddiskUsed' => "Zużyto",
    'ServerInformation.harddiskAvailable' => "Dostępne",
    'ServerInformation.harddiskCapacity' => "Pojemność",
    'ServerInformation.sectionDomains' => "Domeny",
    'ServerInformation.activeDomains' => "Aktywna",
    'ServerInformation.inactiveDomains' => "Nieaktywna",
    'ServerInformation.problemDomains' => "Problemy",
    'ServerInformation.refreshed' => "Dane odświeżone.",

    'ServerAbout.title' => 'O Plesk',
    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Wszelkie prawa zastrzeżone.',
    'ServerAbout.linkLicenseManagement' => 'Przejdź do informacje na temat licencji',
    'ServerAbout.panelVersion' => 'Wersja',
    'ServerAbout.installedPatchVersion' => 'Zaktualizuj #%%patch%%',
    'ServerAbout.licenseKey' => 'Klucz licencji',
    'ServerAbout.productDescription' => 'Plesk jest wiodącą platformą WebOps do uruchamiania, automatyzacji i rozwoju aplikacji, stron www i hostingu firm.',
    'ServerAbout.readEula' => 'Przeczytaj %%link%%.',
    'ServerAbout.linkEula' => 'Umowa licencyjna użytkownika końcowego',
    'ServerAbout.visitForum' => 'Odwiedź %%link%%',
    'ServerAbout.linkForum' => 'Forum Plesk',
    'ServerAbout.followUs' => 'Śledź nas',
    'ServerAbout.visitSite' => 'Dowiedz się więcej tu: %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Znajdź inspiracje tu %%link%%',
    'ServerAbout.linkBlog' => 'Blog Plesk',

    'ServerAbout.darkThemePromoTitle' => 'Gratulacje!',
    'ServerAbout.darkThemePromoDescription' => 'Znalazłeś magicznego kotka dodanego w rocznicowej wersji Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => 'Abrakadabra! Przejdź na ciemną stronę',
    'ServerAbout.darkThemeTourDescription' => 'Przełącz tę opcję, aby włączyć lub wyłączyć ciemny motyw interfejsu.',
    'ServerAbout.darkThemeTourButton' => 'Rozumiem',

    'ts-sessions.title' => 'Sesje serwera terminali',
    'ts-sessions-properties.title' => 'Właściwości sesji ',

    'BandwidthLimiting.title' => 'Ograniczenie przepustowości dla %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Nie możesz kontrolować ograniczeń łącza ponieważ QoS nie jest zainstalowany.',
    'BandwidthLimiting.virtualHostingRequired' => 'Ograniczenie przepustowości jest dostępne tylko dla domen z hostingiem.',
    'BandwidthLimiting.bandwidthLabel' => 'Ogranicz prędkość połączenia do',
    'BandwidthLimiting.bandwidthHint' => 'Limit wykorzystania przepustowości dotyczy tylko danych przesyłanych przez protokół HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Liczba połączeń ograniczona do',
    'BandwidthLimiting.maxConnectionHint' => 'W przypadku ograniczenia przepustowości zalecamy również ograniczenie liczby jednoczesnych połączeń z witryną. W przeciwnym razie, w przypadku częstych zapytań do witryny, procesy serwera WWW zwiększą obciążenie serwera.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Ustawienia ograniczenia przepustowości zostały zmienione.',
    'BandwidthLimiting.unlimited' => 'Nieograniczone',

    'ip-address-domains.title' => 'Serwisy używające adresu IP %%type%% - %%ipAddress%%',
    'ip-address-domains.site' => 'Strona',
    'ip-address-domains.setAsDefault' => 'Ustaw jako domyślny',
    'ip-address-domains.type-SHARED' => 'współdzielony',
    'ip-address-domains.type-EXCLUSIVE' => 'dedykowany',

    'HotlinkProtection.title' => 'Ochrona przed hotlinkowaniem dla %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'Ochrona przed hotlinkowaniem jest dostępna tylko dla domen z hostingiem.',
    'HotlinkProtection.enabledLabel' => 'Włącz ochronę przed hotlinkowaniem',
    'HotlinkProtection.extensionsLabel' => 'Rozszerzenia plików chronionych',
    'HotlinkProtection.friendsLabel' => 'Przyjazne domeny',
    'HotlinkProtection.success' => 'Ustawienia ochrony przed hotlinkowaniem zostały zmienione.',

    'Odbc.serverTitle' => 'Połączenia ODBC DSN',
    'Odbc.domainTitle' => 'Połączenia ODBC DSN %%domainName%%',
    'Odbc.add' => 'Dodaj ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% utworzony / %%allowed%% dozwolony.',
    'Odbc.limitExceeded' => 'Przekroczono limit połączenia ODBC DSN.',
    'Odbc.unlimited' => 'Nieograniczone',
    'Odbc.addTooltip' => 'Dodaj źródło danych ODBC.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Nazwa połączenia',
    'Odbc.driver' => 'Sterownik',
    'Odbc.description' => 'Opis połączenia',
    'Odbc.hostname' => 'Nazwa hosta',
    'Odbc.statusSystem' => 'To jest DSN systemowy.',
    'Odbc.statusConfigured' => 'DSN jest skonfigurowany.',
    'Odbc.statusNotConfigured' => 'DSN jest nieskonfigurowany.',
    'Odbc.noSelectionText' => 'Wybierz jeden lub więcej elementów do usunięcia.',
    'Odbc.removeConfirmation' => 'Usunąć {count, plural, =1 {połączenie {name}} other {# wybrane połączenia}}?',
    'Odbc.removeSuccess' => 'Wybrane połączenia zostały usunięte.',

    'DomainAliasSettings.title' => 'Ustawienia aliasu domeny',
    'DomainAliasSettings.updateSuccess' => 'Właściwości aliasu domeny %%name%% zostały zmienione. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Ustawienia strony będą zastosowane za %%restartInterval%% minut.',

    'Home.Backup.title' => 'Ostatnia kopia zapasowa serwera',
    'Home.Backup.offStatus' => 'To nie jest prawidłowa kopia zapasowa. Nie można przywrócić danych z tego pliku.',
    'Home.Backup.task-failedStatus' => 'Zadanie kopii zapasowej nie powiodło się.',
    'Home.Backup.activeSchedule' => 'Zaplanuj: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Zaplanowane: %%schedules%%',
    'Home.Backup.noSchedule' => "Harmonogram tworzenia kopii zapasowych nie jest ustawiony",
    'Home.Backup.period_hourly' => 'Godzinowy %%schedule%%',
    'Home.Backup.period_daily' => 'Dzienny %%schedule%%',
    'Home.Backup.period_weekly' => 'Tygodniowy %%schedule%%',
    'Home.Backup.period_monthly' => 'Miesięczny %%schedule%%',
    'Home.Backup.create' => 'Utwórz kopię zapasową',
    'Home.Backup.schedule' => 'Plan zajęć',
    'Home.Customization.title' => 'Dashboard',
    'Home.Customization.description' => 'Wybierz, które opcje chcesz zobaczyć',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Serwer',
    'Home.Customization.securitySection' => 'Bezpieczeństwo',
    'Home.Customization.backup' => 'Ostatnia kopia zapasowa',
    'Home.Customization.ipBan' => 'Blokowanie adresu IP',
    'Home.Customization.mailQueue' => 'Kolejka poczty',
    'Home.Customization.mySubscriptions' => 'Moje subskrypcje',
    'Home.Customization.overusedSubscriptions' => 'Nadużywane subskrypcje',
    'Home.Customization.serverInfo' => 'Informacje o serwerze',
    'Home.Customization.updates' => 'Aktualizacje Plesk',
    'Home.Customization.promo' => 'Promocja',
    'Home.Extension.title' => 'Rozszerzenie',
    'Home.IpBan.title' => 'Blokowanie adresu IP',
    'Home.IpBan.banned' => 'Zabronione',
    'Home.IpBan.trusted' => 'Zaufane',
    'Home.IpBan.more' => 'Pokaż więcej',
    'Home.MailQueue.title' => 'Kolejka poczty',
    'Home.MailQueue.total' => 'Suma',
    'Home.MailQueue.deferred' => 'Odroczone',
    'Home.MailQueue.held' => 'Wstrzymane',
    'Home.MailQueue.more' => 'Pokaż więcej',
    'Home.MailQueue.clean' => 'Wyczyść kolejkę poczty',
    'Home.MailQueue.checkLogs' => 'Sprawdź logi',
    'Home.MailQueue.repair' => 'Naprawa',
    'Home.MailQueue.cleanConfirmQuestion' => 'Wyczyścić kolejkę poczty?',
    'Home.MailQueue.cleanConfirmYes' => 'Tak',
    'Home.MailQueue.cleanConfirmNo' => 'Nie',
    'Home.MailQueue.queueCleaned' => 'Wyszyszczono kolejkę maili.',
    'Home.OverusedSubscriptions.title' => 'Subskrypcje z nadużyciem',
    'Home.OverusedSubscriptions.empty' => 'Nie znaleziono subskrypcji z nadużyciem',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% z %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Zobacz wszystkie z nadużyciem: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Otwórz na liście',
    'Home.ServerInfo.title' => 'Informacje o serwerze',
    'Home.ServerInfo.hostname' => 'Nazwa hosta',
    'Home.ServerInfo.ipAddress' => 'Adres IP',
    'Home.ServerInfo.publicIpAddress' => 'Publiczny adres IP',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'Czas działania',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dzień} few {# dni} many {# dni} other {# dni}} {hours, plural, one {# godzina} few {# godziny} many {# godzin} other {# godzin}} {minutes, plural, one {# minuta} few {# minuty} many {# minut} other {# minut}}",
    'Home.ServerInfo.more' => 'Pokaż więcej',
    'Home.Subscriptions.title' => 'Moje subskrypcje',
    'Home.Subscriptions.add' => 'Dodaj nowy',
    'Home.Subscriptions.empty' => 'Twórz subskrypcje, aby hostować wiele witryn internetowych w izolowanej przestrzeni na serwerze. %%link%%',
    'Home.Subscriptions.help' => 'Dowiedz się więcej',
    'Home.Updates.title' => 'Aktualizacje produktów',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Aktualizacja #%%patch%%',
    'Home.Updates.manageComponents' => 'Dodaj lub usuń komponenty',
    'Home.Updates.lastUpdated' => 'Ostatnio zaktualizowano w dniu %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Sprawdź aktualizacje',
    'Home.Updates.enableAutoupdate' => 'Zezwalaj na automatyczne aktualizacje',
    'Home.Updates.lastChecked' => 'Ostatnio sprawdzone w dniu %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% jest dostępna',
    'Home.Updates.installNewVersion' => 'Zainstaluj teraz',
    'Home.Updates.patchAvailable' => 'Dostępne są drobne aktualizacje',
    'Home.Updates.patchAvailableVersion' => 'Dostępne są drobne aktualizacje dla %%currentVersion%%',
    'Home.Updates.installPatch' => 'Aktualizuj teraz',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Aktualizacja dla {package} jest dostępna} other {Aktualizacje dla {package} są dostępne}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# paczka} few {# paczki} many {# paczek} other {# paczek}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Zaktualizuj teraz} other {Zaktualizuj wszystko}}',
    'Home.Promo.Customize.title' => 'Przeorganizuj stronę!',
    'Home.Promo.Customize.content' => 'Dostosowany pulpit łączy Twoje ulubione funkcje w jednym miejscu',
    'Home.Promo.Customize.action' => 'Dostosuj',
    'Home.Promo.SwitchToPuv.title' => 'Czy znasz widoki interfejsu w Plesku?',
    'Home.Promo.SwitchToPuv.content' => 'Jeśli nie świadczysz usług hostingowych swoim klientom, korzystając z planów usług, możesz wypróbować interfejs, który jest wygodniejszy do zarządzania witrynami internetowymi, ich plikami, bazami danych, kontami e-mail i aplikacjami internetowymi.',
    'Home.Promo.SwitchToPuv.action' => 'Spróbuj teraz',

    'HostingSettings.title' => 'Ustawienia hostingu',
    'HostingSettings.updateSuccess' => 'Zaktualizowano ustawienia.',
    'HostingSettings.emptyLogin' => 'Musisz podać nazwę użytkownika.',
    'HostingSettings.emptyPassword' => 'Musisz podać hasło.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Serwer FTP nie obsługuje IPv6. Przydziel co najmniej jeden adres IPv4, ponieważ użytkownik nie będzie mógł wgrywać plików na serwer poprzez FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Ustawienia domeny',
    'HostingSettings.domainSettingsSection.domainName' => 'Nazwa domeny',
    'HostingSettings.domainSettingsSection.description' => 'Na przykład example.com ',

    'HostingSettings.submitPopover.title' => 'Usuń zawartość %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Zmiana typu hostingu dla "Witryny" na "%%type%%" spowoduje trwałe usunięcie całej zawartości witryny, w tym następujących katalogów:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Czy chcesz zmienić typ hostingu dla swojego serwisu WWW?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Aby uzyskać dostęp do większej liczby ustawień, wprowadź poświadczenia użytkownika systemu, a następnie kliknij "Utwórz przestrzeń".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Aby uzyskać dostęp do większej liczby ustawień, kliknij "Dalej", aby utworzyć hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Typ hostingu',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Strona WWW',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Przekierowanie',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Brak hostingu',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Użyj strefy DNS domeny, aby mieć skrzynki pocztowe pod tą nazwą domeny',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Ścieżka do katalogu głównego serwisu WWW',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Preferowana domena',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Odwiedzający zostaną przekierowani tutaj za pośrednictwem przyjaznego dla SEO przekierowania HTTP 301.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Przekieruj odwiedzających do',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Typ przekierowania',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Przeniesiony na stałe (kod 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Przekieruj odwiedzających witrynę do innej witryny i pokaż im adres docelowy. Takie przekierowanie utrzyma ranking wyszukiwania witryny',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Przeniesiony tymczasowo (kod 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Przekieruj odwiedzających serwis WWW na tymczasową kopię serwisu, jeśli nie chcesz, żeby wyszukiwarki indeksowały ten tymczasowy serwis.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Przekierowanie przez ramkę',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Przekieruj odwiedzających stronę na inną stronę, ale nie pokazuj im adresu docelowego tak, żeby nie wiedzieli o przekierowaniu.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Preferowana domena',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Żaden',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Root dokumentu',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Nie można zmienić roota dokumentu, ponieważ na tej stronie zainstalowane są aplikacje.',
    'HostingSettings.domainSettingsSection.save' => 'Zapisz',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Tryb zgodności',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Uruchom serwis WWW w trybie kompatybilności, aby skorzystać z archiwalnej opcji "Rozdziel treści SSL/TLS od nie-SSL/TLS"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Ta strona internetowa działa w trybie zgodności i nie można nią zarządzać za pomocą interfejsu Plesk. Dzieje się tak, ponieważ przed aktualizacją użyłeś przestarzałej opcji „Oddziel zawartość SSL/TLS i inną niż SSL/TLS”. Począwszy od Plesk 11 strona internetowa przechowuje swoją zawartość dostępną poprzez połączenia HTTP i HTTPS w tym samym katalogu. Zalecamy przeniesienie wszystkich danych z katalogu `httpsdocs/` do `httpdocs/`, a następnie wyłączenie trybu zgodności. Dzięki temu aplikacje zainstalowane w katalogu `httpsdocs/` będą dostępne przez Internet. Zwróć uwagę, że nie będzie można ponownie włączyć trybu zgodności.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Zmienić to ustawienie?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Zmiana tego ustawienia jest sprzeczna z zasadami bezpieczeństwa serwera i może pogorszyć wydajność lub narazić serwer na ataki.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Zmień',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Odwróć',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Zabezpieczone ustawienia wstępne są stosowane',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Aby zwiększyć bezpieczeństwo, zastosuj wstępne ustawienia bezpieczeństwa. Należy pamiętać, że niektóre uprawnienia umożliwiają subskrybentom modyfikowanie tych ustawień.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Zastosuj bezpieczne ustawienia wstępne',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Dowiedz się o bezpiecznych ustawieniach hostingu',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Obsługa SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Włączona',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Szyfruj połączenia między witryną a przeglądarką odwiedzającego.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certyfikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Aby włączyć HTTPS, prześlij certyfikat SSL/TLS do repozytorium domeny, a następnie wybierz go tutaj.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Przekieruj odwiedzających z HTTP na HTTPS za pomocą przyjaznego dla SEO przekierowania 301',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'W twoim repozytorium nie ma certyfikatów SSL/TLS. Jeśli chcesz dodać certyfikat, idź %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'ta strona',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (inne repozytorium)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nie zaznaczone',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Skrypty strony',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Wybierz, które języki programowania i skryptów mają być interpretowane przez serwer WWW.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'Katalog cgi-bin jest umieszczony w %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Używaj SSI dla plików *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Wersja Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Spersonalizowane dokumenty błędów',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'Katalog cgi-bin jest umieszczony w',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'dokument root tej domeny',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'Katalog root Przestrzeni WWW',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'old-style root tej domeny',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Spersonalizowane dokumenty błędów',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Dodatkowe uprawnienia zapisu/modyfikacji',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publikacja Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Statystyki WWW',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Narzędzie',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Chroń dostęp do statystyk sieci nazwą użytkownika i hasłem FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Wyłączone',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Ustawienia przestrzeni WWW',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Adresy IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Limit miejsca na dysku',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Włączona',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Zabroń operacji na plikach witryny, jeśli limit miejsca na dysku ustawiony w ustawieniach subskrypcji (jeśli istnieje) zostanie przekroczony.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Przydział dysku twardego nie jest obsługiwany ze względu na konfigurację systemu plików serwera.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Dane dostępowe użytkownika',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Zarządzaj plikami i folderami witryny za pośrednictwem FTP lub Menedżera plików. Uzyskaj dostęp do serwera przez SSH, jeśli jest to dozwolone.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Zarządzaj plikami i folderami witryny za pośrednictwem FTP lub Menedżera plików. Uzyskaj dostęp do serwera za pośrednictwem Pulpitu zdalnego, jeśli jest to dozwolone.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nazwa użytkownika',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Hasło',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Podaj tutaj nowe hasło, aby zmienić hasło użytkownika systemu.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Dostęp SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Dostęp do pulpitu zdalnego',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Włączona',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Uzyskaj dostęp do serwera za pomocą poświadczeń użytkownika systemu.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Wyłączony',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Dla {count, plural, other {# domen}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Następujące ustawienia są wspólne dla wszystkich {count, plural, other {# domen w przestrzeni {name}}}:',

    'OdbcAdd.title' => 'Dodaj ODBC DSN',
    'OdbcAdd.nameLabel' => 'Nazwa połączenia',
    'OdbcAdd.descriptionLabel' => 'Opis połączenia',
    'OdbcAdd.driver' => 'Sterownik',
    'OdbcAdd.submit' => 'Utwórz DSN ODBC',

    'OdbcEdit.title' => 'Skonfiguruj połączenie ODBC',
    'OdbcEdit.saveSuccess' => 'Ustawienia połączenia zostały zapisane.',
    'OdbcEdit.test' => 'Test połączenia',
    'OdbcEdit.connectSuccess' => 'Połączenie udane.',

    'OdbcEdit.excel.driver.label' => 'Sterownik',
    'OdbcEdit.excel.dbq.label' => 'Ścieżka do Pliku Bazy Danych',
    'OdbcEdit.excel.defaultdir.label' => 'Domyślny katalog danych',
    'OdbcEdit.excel.fil.label' => 'Wersja bazy danych',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maksymalny rozmiar bufora',
    'OdbcEdit.excel.pagetimeout.label' => 'Wygaśnięcie strony',

    'OdbcEdit.access.driver.label' => 'Sterownik',
    'OdbcEdit.access.dbq.label' => 'Ścieżka do Pliku Bazy Danych',
    'OdbcEdit.access.uid.label' => 'Login ID',
    'OdbcEdit.access.pwd.label' => 'Hasło',
    'OdbcEdit.access.pagetimeout.label' => 'Wygaśnięcie strony',
    'OdbcEdit.access.pagetimeout.description' => 'Okres czasu, w dziesiątych częściach sekundy, w którym nieużywana strona pozostaje w buforze. Ta opcja odnosi się do wszystkich źródeł, które korzystają ze sterownika Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maksymalny rozmiar bufora',
    'OdbcEdit.access.maxbuffersize.description' => 'Rozmiar wewnętrznego buforu, w KB, ustawiony jest na 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Tylko do odczytu',
    'OdbcEdit.access.readonly.description' => 'Przełącza bazę danych w tryb tylko do odczytu aby zapobiec jakimkolwiek aktualizacjom.',
    'OdbcEdit.access.exclusive.label' => 'Ekskluzywny',
    'OdbcEdit.access.exclusive.description' => 'Przełącza bazę danych w tryb wyłączony aby zapobiec współdzielonym aktualizacjom.',
    'OdbcEdit.access.safetransactions.label' => 'Bezpieczne transakcje',
    'OdbcEdit.access.safetransactions.description' => 'Jeśli 0, domyślnie, wszystkie transakcje są zatwierdzane natychmiastowo. Jeśli 1, wszystkie transakcje są zapisywane na wyłącznie po wykonaniu operacji commit, ale wydajność jest delikatnie mniejsza.',
    'OdbcEdit.access.threads.label' => 'Wątki',
    'OdbcEdit.access.threads.description' => 'Liczba wątków w tle do wykorzystania przez silnik.',
    'OdbcEdit.access.maxscanrows.label' => 'Maksymalna liczba wierszy do przeskanowania',
    'OdbcEdit.access.maxscanrows.description' => 'Liczba wierszy, które będą skanowane, gdy będzie ustawiany typ danych dla kolumny w już istniejącej bazie danych.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Określa jak zmiany poczynione poza transakcją są zapisywane do bazy danych.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Określa czy sterownik MS Access będzie wykonywał w sposób asynchronicznie jawnie zdefiniowane przez użytkownika transakcje.',

    'OdbcEdit.mssql.driver.label' => 'Sterownik',
    'OdbcEdit.mssql.server.label' => 'Serwer',
    'OdbcEdit.mssql.uid.label' => 'Login ID',
    'OdbcEdit.mssql.pwd.label' => 'Hasło',
    'OdbcEdit.mssql.database.label' => 'Domyślna baza danych',
    'OdbcEdit.mssql.app.label' => 'Nazwa aplikacji',
    'OdbcEdit.mssql.wsid.label' => 'Identyfikator stacji roboczej',
    'OdbcEdit.mssql.language.label' => 'Domyślny język',
    'OdbcEdit.mssql.oemtoansi.label' => 'Ten parametr określa czy konwertować rozszerzone znaki do wartości OEM',

    'OdbcEdit.mysql.driver.label' => 'Sterownik MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Serwer',
    'OdbcEdit.mysql.server.description' => 'Nazwa maszyny serwera MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'Domyślna baza danych',
    'OdbcEdit.mysql.user.label' => 'Nazwa użytkownika',
    'OdbcEdit.mysql.user.description' => 'Nazwa użytkownika wykorzystywana podczas połączenia do MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Hasło',
    'OdbcEdit.mysql.password.description' => 'Hasło do konta użytkownika na serwerze',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Port TCP/IP używany gdy serwer nie jest lokalną maszyną',
    'OdbcEdit.mysql.socket.label' => 'Gniazdo',
    'OdbcEdit.mysql.socket.description' => 'Nazwany pipe windowsowy w przypadku lokalnych połączeń do serwera',
    'OdbcEdit.mysql.option.label' => 'Opcja',
    'OdbcEdit.mysql.option.description' => 'Opcje określające sposób działania MyODBC. Zobacz <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentację</a>',

    'ProtectedDirectoryList.title' => 'Chronione katalogi %%domainName%%',
    'ProtectedDirectoryList.add' => 'Dodaj katalog chroniony',
    'ProtectedDirectoryList.addTooltip' => 'Utwórz chroniony katalog.',
    'ProtectedDirectoryList.name' => 'Nazwa',
    'ProtectedDirectoryList.realmTitle' => 'Nagłówek tekstowy',
    'ProtectedDirectoryList.noSelectionText' => 'Wybierz jeden lub więcej elementów do usunięcia.',
    'ProtectedDirectoryList.edit' => 'Edytuj',
    'ProtectedDirectoryList.remove' => 'Usuń zabezpieczenie',
    'ProtectedDirectoryList.removeTooltip' => 'Usuń ochronę z wybranych katalogów.',
    'ProtectedDirectoryList.removeConfirmation' => 'Ta operacja spowoduje usunięcie ochrony z {count, plural, =1 {katalogu {name}} few {# wybranych katalogów} many {# wybranych katalogów} other {# wybranych katalogów}}. {count, plural, =1 {Ten katalog będzie w pełni dostępny} few {Te katalogi będą w pełni dostępne} many {Te katalogi będą w pełni dostępne} other {Te katalogi będą w pełni dostępne}} dla wszystkich użytkowników Internetu.',
    'ProtectedDirectoryList.removeSuccess' => 'Wybrane katalogi zostały usunięte.',

    'ProtectedDirectoryAdd.title' => 'Utwórz chroniony katalog',
    'ProtectedDirectoryAdd.submit' => 'Utwórz',
    'ProtectedDirectoryAdd.success' => 'Chroniony katalog %%path%% został pomyślnie usunięty',

    'ProtectedDirectoryEdit.title' => 'Strona ustawień chronionego katalogu',
    'ProtectedDirectoryEdit.success' => 'Ustawienia chronionego katalogu zostały zmienione',

    'ProtectedDirectoryUserList.title' => 'Użytkownicy katalogu chronionego %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Dodaj użytkownika',
    'ProtectedDirectoryUserList.addTooltip' => 'Utwórz konta użytkowników z dostępem do chronionego katalogu %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Nazwa',
    'ProtectedDirectoryUserList.changePassword' => 'Zmień hasło',
    'ProtectedDirectoryUserList.noSelectionText' => 'Wybierz jednego lub więcej użytkowników do usunięcia.',
    'ProtectedDirectoryUserList.remove' => 'Usuń',
    'ProtectedDirectoryUserList.removeTooltip' => 'Usuń wybranych użytkowników.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Usunąć {count, plural, one {} few {# wybranych użytkowników} many {# wybranych użytkowników}=1 {użytkownika {login}} other {# wybranych użytkowników}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'Wybrani użytkownicy zostali usunięci.',

    'ProtectedDirectoryUserAdd.title' => 'Utwórz użytkownika katalogu chronionego',
    'ProtectedDirectoryUserAdd.subtitle' => 'Katalog %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Nazwa użytkownika',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Hasło',
    'ProtectedDirectoryUserAdd.submit' => 'Utwórz',
    'ProtectedDirectoryUserAdd.success' => 'Utworzono użytkownika chronionego katalogu %%login%%.',

    'ProtectedDirectoryUserPassword.title' => 'Hasło dla użytkownika chronionego katalogu',
    'ProtectedDirectoryUserPassword.subtitle' => 'Użytkownik %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Hasło',
    'ProtectedDirectoryUserPassword.submit' => 'Zapisz',
    'ProtectedDirectoryUserPassword.success' => 'Dane uwierzytelniające użytkownika zostały zapisane.',

    'SummaryReport.Layout.title' => 'Właściwości layoutu raportu',
    'SummaryReport.Layout.success' => 'Zaktualizowano układ raportu %%name%%.',
    'SummaryReport.Layouts.title' => 'Layouty raportu',

    'SummaryReport.Layout.Add.title' => 'Stwórz layout raportu',
    'SummaryReport.Layout.Add.success' => 'Układ raportu %%name%% został utworzony.',

    'SummaryReport.Report.title' => 'Raport zbiorczy',
    'SummaryReport.Report.buttonLayouts' => 'Layouty',
    'SummaryReport.Report.buttonSchedule' => 'Plan zajęć',
    'SummaryReport.Report.buttonProperties' => 'Właściwości',
    'SummaryReport.Report.buttonTrafficHistory' => 'Historia transferu',
    'SummaryReport.Report.buttonPrint' => 'Drukuj',
    'SummaryReport.Report.buttonSend' => 'Wyślij e-mailem',
    'SummaryReport.Report.successSent' => 'Raport został wysłany do %%email%%',

    'SummaryReport.Schedule.title' => 'Harmonogram wysyłek dla %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Harmonogram wysyłki dla %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Raport Harmonogramu Dostawy został zaktualizowany.',

    'SummaryReport.Schedule.Add.title' => 'Utwórz harmonogramy dostarczania dla %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Utworzony nowy plan dostawy raportu.',

    'SummaryReport.TrafficHistory.title' => 'Historia transferu',

    'VirtualDirectory.title' => 'Katalog wirtualny %%path%% witryny %%domainName%%',
    'VirtualDirectory.errNotExist' => 'Ten katalog wirtualny jest powiązany z folderem fizycznym, który nie istnieje.',
    'VirtualDirectory.errNoPermissions' => 'Nie masz uprawnień do przeglądania zawartości tego katalogu.',
    'VirtualDirectory.buttonProperties' => 'Właściwości katalogu',
    'VirtualDirectory.buttonPropertiesHint' => 'Zobacz i zmień właściwości wirtualnego katalogu.',
    'VirtualDirectory.buttonPermissions' => 'Uprawnienia dostępu do katalogu',
    'VirtualDirectory.buttonPermissionsHint' => 'Ustaw uprawnienia dostępu do katalogu.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Skonfiguruj ustawienia ASP.NET.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Skonfiguruj ustawienia PHP.',
    'VirtualDirectory.buttonMimeTypes' => 'Typy MIME',
    'VirtualDirectory.buttonMimeTypesHint' => 'Zarządzaj zarejestrowanymi typami MIME.',
    'VirtualDirectory.buttonErrorDocs' => 'Dokumenty błędów',
    'VirtualDirectory.buttonErrorDocsHint' => 'Zarządzaj dokumentami błędów.',
    'VirtualDirectory.buttonProtection' => 'Ochrona',
    'VirtualDirectory.buttonProtectionHint' => 'Ogranicz dostęp do katalogu za pomocą hasła.',

    'VirtualDirectory.CreateDirectory.title' => 'Utwórz katalog',
    'VirtualDirectory.CreateDirectory.name' => 'Nazwa katalogu',
    'VirtualDirectory.CreateDirectory.success' => 'Katalog %%name%% został utworzony.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Katalog %%name%% już istnieje.',

    'VirtualDirectory.AspDotNet.title' => 'Skonfiguruj ustawienia ASP.NET',

    'VirtualDirectory.Php.title' => 'Wersja PHP',
    'VirtualDirectory.Php.version' => 'Wersja',
    'VirtualDirectory.Php.success' => 'Wersja PHP została zaktualizowana.',
];