<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Yderligere nøgleegenskaber',
    'additional-key-info.update' => 'Hent ekstra nøgle',
    'additional-key-info.updateDescription' => 'Hent de ekstra licensnøgler og installér dem.',
    'additional-key-info.download' => 'Download nøgle',
    'additional-key-info.downloadDescription' => 'Download den aktuelle licensnøgle.',
    'additional-key-info.install' => 'Installer nøgle',
    'additional-key-info.installDescription' => 'Installer den aktuelle licensnøgle.',
    'additional-key-info.revert' => 'Rul installationen tilbage',
    'additional-key-info.revertDescription' => 'Gendan den tidligere installerede licensnøgle.',
    'additional-key-info.revertNotAvailableDescription' => 'Der er ikke installeret en licensnøgle.',
    'additional-key-info.installSuccess' => 'Installation af licensnøgle er påbegyndt.',

    'additional-key-revert.title' => 'Tilbagerulning af ekstra nøgle',
    'additional-key-revert.success' => 'Tilbagerulning af ekstra nøgle udført.',

    'additional-key-upload.title' => 'Installer en licensnøgle.',
    'additional-key-upload.success' => 'Den nye ekstranøgle blev uploadet.',

    'additional-keys.title' => 'Ekstra licensnøgler',

    'change-owner.title' => 'Omtilknytter markerede abonnementer.',

    'customers.hint' => 'Her administrerer du konti for dine hostingservice-kunder: Opret konti sammen med serviceabonnementer, administrér eksisterende kunder og fjern konti. Du kan administrere websteder, e-mail og andre services der leveres til en kunde ved at åbne deres Kundepanel ved at klikke på linket i listens højre kolonne.',

    'customer-domains.hint' => 'Her opsætter og administrerer du websteder.',

    'customer-subscriptions.hint' => 'Her administrerer du kundens abonnementer.',

    'domains.hint' => 'Her kan du se oplysninger om alle de domænenavne, der er registreret i systemet, og du kan fortsætte til administration af hosting-servicer. Du kan tilføje et domæne til dig selv eller til hosting af kunder ved blot at klikke på Tilføj domæne. Du vil blive bedt om at oprette en ny kunde og et abonnement under oprettelsen af et domæne, eller om at vælge et af de eksisterende.',

    'database-servers.title' => 'Databaseservere',

    'database-server-create.title' => 'Ny databaseserver.',

    'database-server-properties.title' => 'Databaseserver',

    'database-server-upgrade.drawerTitle' => 'MariaDB-opdatering',
    'database-server-upgrade.drawerTitle.completed' => 'Opgraderingen er fuldført',
    'database-server-upgrade.drawerSubTitle.line1' => 'Skuffen kan ikke lukkes, mens opgraderingen udføres.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Hvis der opstår problemer under opgraderingen, kan du finde nyttige oplysninger i %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'MariaDB-databaseserveren er blevet opgraderet til version %%releaseVersion%%. Hvis der opstår problemer, kan du finde nyttige oplysninger i %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'LTS-versionen er allerede installeret.',
    'database-server-upgrade.troubleshootingArticle' => 'denne KB-artikel',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Du kan finde flere oplysninger om, hvordan du foretager fejlfinding af MariaDB-opgraderingsproblemer, i %%troubleshootingArticle%%.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Du kan opgradere din lokale MariaDB-databaseserver til den aktuelle LTS-version (langsigtet support).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Vi anbefaler kraftigt, at du sikkerhedskopierer din server, før du opgraderer, og starter opgraderingen, når webstedet har få besøgende.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Under MariaDB-opgraderingen vil Plesk-serveren og de hostede websteder ikke være tilgængelige. MariaDB-opgraderingen er normalt fejlfri og tager ca. 10 minutter, men den kan stadig påvirke hele serveren.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Bemærk: Hvis du kører MariaDB 5.5, vil Plesk først opgradere den til MariaDB 10.5. Når opgraderingen er færdig, skal du starte denne guide igen for at opgradere til den seneste LTS-version af MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Nuværende version',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Vælg den version, der skal opgraderes til',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Der er ingen større versioner',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Produktbemærkninger',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Dato for udgivelse: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End of life-dato: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Kun MariaDB-forgreninger, der leveres af OS-leverandører eller MariaDB-leverandøren, kan opgraderes.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Kontrol før opgradering',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Parsing MariaDB-konfigurationsfiler',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Analyserer databaser med mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analyserer konfigurationen for administration af pakker',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Kontrollerer WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'For at fortsætte med opgraderingen skal du markere alle afkrydsningsfelterne. Det er nødvendigt at sikre, at du er indforstået med de konfigurationsændringer, opgraderingen vil medføre, og at du har adgang til gendannelsesmuligheder.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Følgende variabler fjernes for kompatibilitet med den nye version:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} fra {count, plural, one {filen {files}} other {de # filer: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Genoprettelsesmuligheder (serverens kommandolinjekonsol og Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Jeg har SSH-adgang til serveren',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Brug en SSH-klient, eller åbn %%sshTerminalExtension%% i en ny browserfane (luk ikke SSH Terminal-udvidelsesvinduet, før opgraderingen er fuldført). Hvis opgraderingen mislykkes, vil SSH-adgang hjælpe med gendannelse.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal-udvidelse',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Jeg har SSH-adgang til Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Åbn %%repairKit%% i en ny browserfane, og log på med dine administrator-legitimationsoplysninger. Luk ikke tilføjelsesvinduet til Repair Kit, før opgraderingen er fuldført.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Sikkerhedskopier databaser',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Sikkerhedskopier alle databaser på serveren før opgraderingen',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk gemmer sikkerhedskopien af databaserne i mappen %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket i Plesk er ikke tilgængelig',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Du vil ikke kunne se opgraderingsprocessens fremgang i realtid uden WebSocket.',

    'database-server-upgrade.submitPopover.title' => 'For at forhindre potentielt datatab anbefaler vi kraftigt, at du opretter en sikkerhedskopifil med hostede databaser, før du fortsætter. Fortsæt uden oprettelse af en sikkerhedskopifil?',

    'database-server-databases.title' => 'Databaser',

    'database-server-change-password.title' => 'Administrators adgangskode',

    'home.title' => 'Forside',

    'license.title' => 'Information om licens',

    'primary-key-info.title' => 'Plesk-licensnøgle',
    'primary-key-info.update' => 'Hent nøgler',
    'primary-key-info.updateDescription' => 'Hent de bestilte licensnøgler og installér dem.',
    'primary-key-info.upload' => 'Installer nøgle',
    'primary-key-info.uploadDescription' => 'Upload og installér en ny licensnøgle.',
    'primary-key-info.revert' => 'Rul installationen tilbage',
    'primary-key-info.revertDescription' => 'Gendan den tidligere installerede licensnøgle.',

    'primary-key-revert.title' => 'Tilbagerulning af licensnøgle',
    'primary-key-revert.success' => 'Tilbagerulning af Plesk-nøglen udført.',

    'primary-key-upload.title' => 'Installer en licensnøgle.',
    'primary-key-upload.success' => 'Den nye Plesk-nøgle blev uploadet.',

    'resellers.hint' => 'Her kan du administrere forhandleres konti — dine kunder, der videresælger hosting services og er host for deres egne websteder. Her kan du oprette konti sammen med serviceabonnementer, administrere eksisterende forhandlere og fjerne konti.',

    'reseller-customers.hint' => 'Det er her du opsætter og administrerer kunder.',

    'reseller-domains.hint' => 'Her opsætter og administrerer du websteder.',

    'reseller-subscriptions.hint' => 'Her administrerer du forhandlerens abonnementer.',

    'subscriptions.hint' => 'Kunder får hostingtjenester fra dig ved at abonnere på en hostingplan. Du kan administrere disse abonnementer her, ligesom du kan administrere dine egne abonnementer, som du opretter som host for dine egne websteder. For at administrere websteder, e-mail eller andre tjenester, der leveres med et abonnement, skal du åbne abonnentens Kundepanel og klikke på linket i listens højre kolonne.',

    'server-mail-settings.title' => 'Indstillinger',
    'server-mail-spam-filter.title' => 'Spamfiltrering',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Sortlist',
    'server-mail-white-list.title' => 'Hvidliste',
    'server-mail-queue.title' => 'E-mail kø',
    'server-mail-statistics.title' => 'Statistik',

    'server-spam-filter.title' => 'Spamfilter-indstillinger',
    'server-spam-filter.settings' => 'Indstillinger',
    'server-spam-filter.black-list' => 'Sortlist',
    'server-spam-filter.white-list' => 'Hvidliste',

    'firewall.title' => 'Administration af firewall.',
    'firewall-general.title' => 'Generelt',
    'firewall-general.toggleStatus' => 'Firewallbeskyttelse',
    'firewall-general.buttonDefault' => 'Nulstil til standard',
    'firewall-general.buttonPanic' => 'Panik-tilstand',
    'firewall-general.confirmationDefault' => 'Nulstil firewall-indstillingerne til standardindstillingerne?',
    'firewall-general.confirmationPanic' => 'Aktivér Paniktilstand? Brugerne vil ikke kunne få adgang til deres domæner, og nogle netværkstjenester kan stoppe med at fungere.',
    'firewall-general.successDefault' => 'Firewall-indstillingerne blev tilbageført til standardindstillingerne.',
    'firewall-general.successPanic' => 'Panik-tilstand blev aktiveret.',
    'firewall-general.info' => 'Af sikkerhedsmæssige årsager blokerer firewall\'en alle forbindelser, undtagen dem, der udtrykkeligt er tilladt. Du kan tillade en forbindelse ved at oprette en regel. Se dokumentationen for at få flere oplysninger',
    'firewall-general.interfaces' => 'Netværksgrænseflader:',
    'firewall-icmp.title' => 'ICMP-protokol',
    'firewall-rules.title' => 'Firewallregel',

    'dns.title' => 'DNS-indstillinger',
    'dns-records.title' => 'Zonepost-skabelon',
    'dns-soa-record.title' => 'Zoneindstillingsskabelon',

    'php-handler.title' => 'Indstillinger for %%name%%',
    'php-handler.extensions.title' => 'Filtypenavne',
    'php-handler.extensions.description' => 'Disse PHP-udvidelser er kun for denne handler.',
    'php-handler.extensions.descriptionShared' => 'Denne php.ini file bruges også af følgende PHP-handlere: %%handlers%%. Indstillingerne anvendes på alle websteder, der bruger disse handlere.',
    'php-handler.extensions.buttonManage' => 'Administrer PECL-pakker',
    'php-handler.extensions.manage.title' => 'Administrer PECL-pakker',
    'php-handler.extensions.manage.risks' => 'PHP-udvidelser leveres af tredjeparts PECL-pakker. De installeres på eget ansvar.',
    'php-handler.extensions.manage.description' => 'Installer, opgrader og afinstaller PECL-pakker. Ændringerne anvendes på alle websteder, der kører på %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Hvorfor er den ønskede pakke ikke på listen?',
    'php-handler.extensions.manage.limitations' => 'PHP-udvidelser, der leveres af kontrolpaneludbyderen og OS-leverandører, vises ikke på listen.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.title' => "Serveroplysninger",
    'ServerInformation.refresh' => "Opdater",
    'ServerInformation.sectionGeneral' => "Generelt",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Version",
    'ServerInformation.os' => "Operativsystem",
    'ServerInformation.key' => "Plesk-licensnøgle",
    'ServerInformation.uptime' => "Oppetid",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dage}} {hours, plural, one {# time} other {# timer}} {minutes, plural, one {# minut} other {# minutter}}",
    'ServerInformation.sectionCpu' => "CPU-forbrug",
    'ServerInformation.la1min' => "Seneste 1 minut",
    'ServerInformation.la5min' => "Seneste 5 minutter",
    'ServerInformation.la15min' => "Seneste 15 minutter",
    'ServerInformation.sectionMemory' => "Brug af hukommelse",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "I alt (uden kernel)",
    'ServerInformation.memoryTotal' => "Total",
    'ServerInformation.memoryUsed' => "Forbrugt",
    'ServerInformation.memoryFree' => "Ledig",
    'ServerInformation.memoryShared' => "Delt",
    'ServerInformation.memoryBuffer' => "Buffer",
    'ServerInformation.memoryCached' => "Cachelagret",
    'ServerInformation.memoryAvailable' => "Tilgængeligt",
    'ServerInformation.memoryUsage' => "Forbrug",
    'ServerInformation.sectionSwap' => "Swap-brug",
    'ServerInformation.sectionVirtualMemory' => "Brug af virtuel hukommelse",
    'ServerInformation.swapTotal' => "Total",
    'ServerInformation.swapUsed' => "Forbrugt",
    'ServerInformation.swapFree' => "Ledig",
    'ServerInformation.swapUsage' => "Forbrug",
    'ServerInformation.sectionHarddisk' => "Harddiskforbrug",
    'ServerInformation.harddiskDirectory' => "Filsystem:",
    'ServerInformation.harddiskProtectedDir' => "Beskyttede biblioteker",
    'ServerInformation.harddiskTotal' => "Total",
    'ServerInformation.harddiskUsed' => "Forbrugt",
    'ServerInformation.harddiskAvailable' => "Tilgængeligt",
    'ServerInformation.harddiskCapacity' => "Kapacitet",
    'ServerInformation.sectionDomains' => "Domæner",
    'ServerInformation.activeDomains' => "Aktiv",
    'ServerInformation.inactiveDomains' => "Inaktiv",
    'ServerInformation.problemDomains' => "Problemer",
    'ServerInformation.refreshed' => "Oplysninger opdateret.",

    'ServerAbout.title' => 'Om Plesk',
    'ServerAbout.copyright' => '© 2024 WebPros International GmbH. Alle rettigheder forbeholdes.',
    'ServerAbout.linkLicenseManagement' => 'Gå til Information om licens',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Opdater #%%patch%%',
    'ServerAbout.licenseKey' => 'Licensnøgle',
    'ServerAbout.productDescription' => 'Plesk er den førende WebOps platform for kørsel, automatisering og vækst af applikationer, websteder og hosting virksomheder.',
    'ServerAbout.readEula' => 'Læs %%link%%.',
    'ServerAbout.linkEula' => 'Slutbrugerlicensaftale (EULA)',
    'ServerAbout.visitForum' => 'Besøg %%link%%',
    'ServerAbout.linkForum' => 'Plesk forum',
    'ServerAbout.followUs' => 'Følg os',
    'ServerAbout.visitSite' => 'Lær mere på %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Find inspiration på %%link%%',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Tillykke!',
    'ServerAbout.darkThemePromoDescription' => 'Du har fundet en magisk kat, der er tilføjet i Plesk Obsidian 18.0.50 jubilæumsversionen.',
    'ServerAbout.darkThemePromoButton' => 'Pfft! Kom over til den mørke side',
    'ServerAbout.darkThemeTourDescription' => 'Slå denne indstilling til/fra for at aktivere eller deaktivere det mørke tema for din grænseflade.',
    'ServerAbout.darkThemeTourButton' => 'Forstået',

    'ts-sessions.title' => 'Terminalserver-sessioner',
    'ts-sessions-properties.title' => 'Egenskaber for session',

    'BandwidthLimiting.title' => 'Båndbreddebegrænsning for %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'Du kan ikke kontrollere båndbredde-throttling, fordi QoS ikke er installeret.',
    'BandwidthLimiting.virtualHostingRequired' => 'Båndviddebegrænsning er kun tilgængelig for domæner med webhosting.',
    'BandwidthLimiting.bandwidthLabel' => 'Maksimal båndbredde-anvendelse',
    'BandwidthLimiting.bandwidthHint' => 'Forbrugsbegrænsningen for båndbredde gælder kun data, der overføres via HTTP-protokollen.',
    'BandwidthLimiting.maxConnectionLabel' => 'Tilslutninger begrænset til',
    'BandwidthLimiting.maxConnectionHint' => 'Hvis du begrænser båndbredden, anbefaler vi, at du også begrænser antallet af samtidige forbindelser til webstedet. Ellers vil webserverprocesserne i tilfælde af hyppige anmodninger til webstedet øge serverbelastningen.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Indstillingerne for begrænsning af båndbredde blev ændret.',
    'BandwidthLimiting.unlimited' => 'Ubegrænset',

    'ip-address-domains.title' => 'Websteder der bruger %%type%% IP-adresse %%ipAddress%%',
    'ip-address-domains.site' => 'Websted',
    'ip-address-domains.setAsDefault' => 'Angiv som standard',
    'ip-address-domains.type-SHARED' => 'delt',
    'ip-address-domains.type-EXCLUSIVE' => 'dedikeret',

    'HotlinkProtection.title' => 'Hotlink-beskyttelse til %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'Hotlink-beskyttelsen er kun tilgængelig for domæner med webhosting.',
    'HotlinkProtection.enabledLabel' => 'Aktiver hotlink-beskyttelse',
    'HotlinkProtection.extensionsLabel' => 'Filtypenavne for beskyttede filer',
    'HotlinkProtection.friendsLabel' => 'Adresser på venlige websteder',
    'HotlinkProtection.success' => 'Indstillingerne for Hotlink-beskyttelse blev ændret.',

    'Odbc.serverTitle' => 'ODBC DSN-forbindelser',
    'Odbc.domainTitle' => 'ODBC DSN-forbindelser til %%domainName%%',
    'Odbc.add' => 'Tilføj ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% oprettet / %%allowed%% tilladt.',
    'Odbc.limitExceeded' => 'Grænsen for ODBC DSN-forbindelser er overskredet.',
    'Odbc.unlimited' => 'Ubegrænset',
    'Odbc.addTooltip' => 'Tilføj ODBC-datakilde',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Navn på forbindelsen',
    'Odbc.driver' => 'Driver',
    'Odbc.description' => 'Forbindelsesbeskrivelse',
    'Odbc.hostname' => 'Værtsnavn',
    'Odbc.statusSystem' => 'Det er en system-DSN.',
    'Odbc.statusConfigured' => 'DSN er konfigureret.',
    'Odbc.statusNotConfigured' => 'DSN er ikke konfigureret.',
    'Odbc.noSelectionText' => 'Vælg et eller flere emner, der skal fjernes.',
    'Odbc.removeConfirmation' => 'Fjern {count, plural, =1 {forbindelsen {name}} other {de # valgte forbindelser}}?',
    'Odbc.removeSuccess' => 'De valgte forbindelser blev fjernet.',

    'DomainAliasSettings.title' => 'Indstillinger for domænealias',
    'DomainAliasSettings.updateSuccess' => 'Egenskaberne for domænealiaset %%name%% blev ændret. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Webstedsindstillingerne vil blive anvendt om %%restartInterval%% minutter.',

    'Home.Backup.title' => 'Seneste sikkerhedskopiering af serveren',
    'Home.Backup.offStatus' => 'Dette er ikke en gyldig sikkerhedskopi. Data kan ikke gendannes fra denne fil.',
    'Home.Backup.task-failedStatus' => 'Sikkerhedskopieringsopgaven mislykkedes.',
    'Home.Backup.activeSchedule' => 'Planlagt opgave: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Planlagte opgaver: %%schedules%%',
    'Home.Backup.noSchedule' => "Planlagt sikkerhedskopiering er ikke indstillet",
    'Home.Backup.period_hourly' => 'Timebaseret %%schedule%%',
    'Home.Backup.period_daily' => 'Dagligt %%schedule%%',
    'Home.Backup.period_weekly' => 'Ugentligt %%schedule%%',
    'Home.Backup.period_monthly' => 'Månedligt %%schedule%%',
    'Home.Backup.create' => 'Opret en sikkerhedskopi',
    'Home.Backup.schedule' => 'Planlægning',
    'Home.Customization.title' => 'Instrumentpanel',
    'Home.Customization.description' => 'Vælg de indstillinger, du vil have vist',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Sikkerhed',
    'Home.Customization.backup' => 'Seneste sikkerhedskopi',
    'Home.Customization.ipBan' => 'IP-adressebandlysning',
    'Home.Customization.mailQueue' => 'E-mail kø',
    'Home.Customization.mySubscriptions' => 'Mine abonnementer',
    'Home.Customization.overusedSubscriptions' => 'Abonnementer med overforbrug',
    'Home.Customization.serverInfo' => 'Serveroplysninger',
    'Home.Customization.updates' => 'Plesk-opdateringer',
    'Home.Customization.promo' => 'Kampagne',
    'Home.Extension.title' => 'Lokalnummer',
    'Home.IpBan.title' => 'IP-adressebandlysning',
    'Home.IpBan.banned' => 'Bandlyst',
    'Home.IpBan.trusted' => 'Pålidelige',
    'Home.IpBan.more' => 'Se mere',
    'Home.MailQueue.title' => 'E-mail-kø',
    'Home.MailQueue.total' => 'Total',
    'Home.MailQueue.deferred' => 'Udsat',
    'Home.MailQueue.held' => 'På hold',
    'Home.MailQueue.more' => 'Se mere',
    'Home.MailQueue.clean' => 'Ryd e-mail-kø',
    'Home.MailQueue.checkLogs' => 'Tjek logfiler',
    'Home.MailQueue.repair' => 'Reparer',
    'Home.MailQueue.cleanConfirmQuestion' => 'Ryd e-mail-køen?',
    'Home.MailQueue.cleanConfirmYes' => 'Ja',
    'Home.MailQueue.cleanConfirmNo' => 'Nej',
    'Home.MailQueue.queueCleaned' => 'E-mail køen blev ryddet.',
    'Home.OverusedSubscriptions.title' => 'Abonnementer med overforbrug',
    'Home.OverusedSubscriptions.empty' => 'Ingen abonnementer med overforbrug fundet',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% af %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Se alle med overforbrug: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Åbn i listen',
    'Home.ServerInfo.title' => 'Serveroplysninger',
    'Home.ServerInfo.hostname' => 'Værtsnavn',
    'Home.ServerInfo.ipAddress' => 'IP-adresse',
    'Home.ServerInfo.publicIpAddress' => 'Offentlig IP-adresse',
    'Home.ServerInfo.os' => 'OS',
    'Home.ServerInfo.uptime' => 'Oppetid',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# dag} other {# dage}} {hours, plural, one {# time} other {# timer}} {minutes, plural, one {# minut} other {# minutter}}",
    'Home.ServerInfo.more' => 'Se mere',
    'Home.Subscriptions.title' => 'Mine abonnementer',
    'Home.Subscriptions.add' => 'Tilføj ny',
    'Home.Subscriptions.empty' => 'Opret abonnementer til at hoste flere websteder i et isoleret område på serveren. %%link%%',
    'Home.Subscriptions.help' => 'Få flere oplysninger',
    'Home.Updates.title' => 'Produktopdateringer',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% opdatering #%%patch%%',
    'Home.Updates.manageComponents' => 'Tilføj eller fjern komponenter',
    'Home.Updates.lastUpdated' => 'Sidst opdateret d. %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Kontrollér om der er opdateringer',
    'Home.Updates.enableAutoupdate' => 'Tillad automatiske opdateringer',
    'Home.Updates.lastChecked' => 'Senest kontrolleret d. %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% er tilgængelig',
    'Home.Updates.installNewVersion' => 'Installér nu',
    'Home.Updates.patchAvailable' => 'Mindre opdateringer er tilgængelige',
    'Home.Updates.patchAvailableVersion' => 'Mindre opdateringer til %%currentVersion%% er tilgængelige',
    'Home.Updates.installPatch' => 'Opdatér nu',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Opdatering til {package} er} other {Opdateringer til {package} er}} tilgængelige',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# pakke} other {# pakker}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Opdater nu} other {Opdater alle}}',
    'Home.Promo.Customize.title' => 'Start renovering af siden!',
    'Home.Promo.Customize.content' => 'Det brugertilpassede kontrolpanel samler alle dine yndlingsfunktioner på ét sted',
    'Home.Promo.Customize.action' => 'Tilpas',
    'Home.Promo.SwitchToPuv.title' => 'Kender du til grænsefladevisninger i Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Hvis du ikke tilbyder hosting-tjenester til dine kunder ved hjælp af serviceplaner, kan du prøve den grænseflade, der er mere hensigtsmæssig til at administrere websteder, deres filer, databaser, e-mailkonti og webapplikationer.',
    'Home.Promo.SwitchToPuv.action' => 'Prøv nu',

    'HostingSettings.title' => 'Hosting-indstillinger',
    'HostingSettings.updateSuccess' => 'Indstillingerne blev opdateret.',
    'HostingSettings.emptyLogin' => 'Du skal angive et brugernavn.',
    'HostingSettings.emptyPassword' => 'Du skal angive en adgangskode.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP-serveren understøtter ikke IPv6. Reservér mindst én IPv4 adresse, eller vil brugeren ikke kunne uploade filer til serveren over FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domæneindstillinger',
    'HostingSettings.domainSettingsSection.domainName' => 'Domænenavn',
    'HostingSettings.domainSettingsSection.description' => 'For eksempel eksempel.com ',

    'HostingSettings.submitPopover.title' => 'Fjern indholdet fra %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Hvis hostingtypen "Websted" ændres til "%%type%%", fjernes hele webstedets indhold permanent, herunder følgende mapper:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Vil du ændre hostingtypen for dit websted?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'For at få adgang til flere indstillinger skal du indtaste systemets brugeroplysninger og derefter klikke på "Opret webspace".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'For at få adgang til flere indstillinger skal du klikke på "Næste" for at oprette hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hostingtype',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Type',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Websted',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Videresender',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Ingen webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Brug domænets DNS-zone til at have mailbokse under dette domænenavn',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Stien til webstedets startmappe',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Foretrukket domæne',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Besøgende vil blive omdirigeret hertil via en SEO-venlig HTTP 301-omdirigering.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Videresend besøgende til',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Videresendelsestype',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Flyttet permanent (kode 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Omdirigér webstedsbesøgende til et andet websted og vis dem destinationsadressen. En sådan omdirigering vil bevare webstedets søgerelevans',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Flyttet midlertidigt (kode 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Omdirigér webstedsbesøgende til et midlertidig websted, når du ikke ønsker at søgemaskiner skal indeksere dette midlertidige websted.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame-videresendelse',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Omdirigér webstedsbesøgende til et andet websted, men vis dem ikke destinationsadressen, så de er uvidende om omdirigeringen.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Foretrukket domæne',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Ingen',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Dokumentrod',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Det er umuligt at ændre dokumentroden, da der er installeret webprogrammer på dette websted.',
    'HostingSettings.domainSettingsSection.save' => 'Gem',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Kompatibilitetstilstand',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Kør webstedet i kompatibilitetstilstand for legacy-muligheden "Adskil SSL/TLS og ikke-SSL/TLS indhold"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Dette websted kører i kompatibilitetstilstand. Den kan derfor ikke administreres via Plesk-grænsefladen. Det skyldes, at du anvendte den forældede mulighed for at adskille SSL/TLS-indhold fra indhold uden SSL/TLS før opgraderingen. Fra og med Plesk 11 gemmes webstedsindhold, der er tilgængeligt via HTTP- og HTTPS-forbindelser, i den samme mappe. Vi anbefaler at flytte alle data fra \'httpsdocs/\'-mappen til \'httpdocs/\' og derefter deaktivere kompatibilitetstilstand. Dette vil også bevirke, at de applikationer, der er installeret i `httpsdocs/`-mappen, bliver tilgængelige via internettet. Bemærk, at du ikke kan genaktivere kompatibilitetstilstanden.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Vil du ændre denne indstilling?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Ændring af denne indstilling overtræder serverens sikkerhedspolitik og kan forringe ydeevnen eller gøre serveren sårbar over for angreb.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Rediger',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Tilbage',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Standardsikkerhedsindstillinger anvendes',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'For bedre sikkerhed skal du bruge standardsikkerhedsindstillingerne. Bemærk, nogle tilladelser giver abonnenter mulighed for at ændre disse indstillinger.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Brug foruddefinerede sikkerhedsindstillinger',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Få mere at vide om sikre hostingindstillinger',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-understøttelse',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Aktiveret',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Krypter forbindelser mellem webstedet og den besøgendes browser.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certifikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'For at aktivere HTTPS skal du uploade et SSL/TLS-certifikat til domænets lager og derefter vælge det her.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Omdiriger besøgende fra HTTP til HTTPS via en SEO-venlig 301-omdirigering',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Der er ingen SSL/TLS-certifikater i dit opbevaringsområde. Du kan tilføje et certifikat ved at gå til %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'denne side',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (andet opbevaringsområde)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Ikke valgt',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Webscripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Vælg hvilke programmerings- og scriptsprog der skal tolkes af webserveren.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin mappen findes i %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Brug SSI til *.htm, *.html filer',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET-version',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Brugerdefinerede fejldokumenter',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin mappen findes i',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'dette domænes dokument-rod',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'webspacens rod-mappe',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'gammel rod-type for dette domæne',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Brugerdefinerede fejldokumenter',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Yderligere skrive/ændringstilladelser',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Webdeployeringspublicering',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webstatistik',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Værktøj',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Beskyt adgangen til din web-statistik med dit FTP-brugernavn og din adgangskode',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Deaktiveret',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webspace-indstillinger',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-adresser',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Diskpladskvote',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Aktiveret',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Forbyd handlinger på webstedets filer, hvis den diskpladskvote, der er angivet i abonnementsindstillingerne (hvis nogen), overskrides.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Harddiskkvoten understøttes ikke på grund af serverens filsystemkonfiguration.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Systembruger-akkreditiver',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Administrer webstedets filer og mapper via FTP eller Filadministrator. Få adgang til serveren via SSH, hvis det er tilladt.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Administrer webstedets filer og mapper via FTP eller Filadministrator. Få adgang til serveren via fjernskrivebord, hvis det er tilladt.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Brugernavn',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Adgangskode',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Angiv en ny adgangskode her for at ændre systembrugerens adgangskode.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-adgang',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Adgang til fjernskrivebord',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Aktiveret',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Tilgå serveren med systembrugerens legitimationsoplysninger.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Type',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Deaktiveret',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'For {count, plural, other {# domæner}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Følgende indstillinger er fælles for {count, plural, other {# domæner i {name}-webspacen}}:',

    'OdbcAdd.title' => 'Tilføj en ODBC DSN',
    'OdbcAdd.nameLabel' => 'Navn på forbindelsen',
    'OdbcAdd.descriptionLabel' => 'Forbindelsesbeskrivelse',
    'OdbcAdd.driver' => 'Driver',
    'OdbcAdd.submit' => 'Opret ODBC DSN',

    'OdbcEdit.title' => 'Konfigurér en ODBC-forbindelse',
    'OdbcEdit.saveSuccess' => 'Forbindelsesindstillinger gemt.',
    'OdbcEdit.test' => 'Test forbindelsen',
    'OdbcEdit.connectSuccess' => 'Forbindelsen lykkedes',

    'OdbcEdit.excel.driver.label' => 'Driver',
    'OdbcEdit.excel.dbq.label' => 'Database-fil sti',
    'OdbcEdit.excel.defaultdir.label' => 'Standard datamappe',
    'OdbcEdit.excel.fil.label' => 'Databaseversion',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maks. bufferstørrelse',
    'OdbcEdit.excel.pagetimeout.label' => 'Side-timeout',

    'OdbcEdit.access.driver.label' => 'Driver',
    'OdbcEdit.access.dbq.label' => 'Database-fil sti',
    'OdbcEdit.access.uid.label' => 'Login-ID',
    'OdbcEdit.access.pwd.label' => 'Adgangskode',
    'OdbcEdit.access.pagetimeout.label' => 'Side-timeout',
    'OdbcEdit.access.pagetimeout.description' => 'Den tidsperiode, i tiendedele af et sekund, en ubrugt side forbliver i bufferen. Denne indstilling gælder for alle datakilder, der bruger Microsoft Access-driveren.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maks. bufferstørrelse',
    'OdbcEdit.access.maxbuffersize.description' => 'Størrelsen af den interne buffer, i KB, justeret efter en 256 KB grænse.',
    'OdbcEdit.access.readonly.label' => 'Skrivebeskyttet',
    'OdbcEdit.access.readonly.description' => 'Betegner databasen som skrivebeskyttet for at forhindre opdateringer.',
    'OdbcEdit.access.exclusive.label' => 'Eksklusivt',
    'OdbcEdit.access.exclusive.description' => 'Betegner databasen som eksklusiv for at forhindre delte opdateringer.',
    'OdbcEdit.access.safetransactions.label' => 'Sikre transaktioner',
    'OdbcEdit.access.safetransactions.description' => 'Hvis indstillet til 0 (standardindstillingen), commit\'es alle tranaktioner øjeblikkeligt. Hvis indstillet til 1, bliver alle transaktioner kun gemt på ved en commit-handling, men ydelsen er en smule nedsat.',
    'OdbcEdit.access.threads.label' => 'Tråde',
    'OdbcEdit.access.threads.description' => 'Antallet af baggrundstråde som kernen må bruge.',
    'OdbcEdit.access.maxscanrows.label' => 'Maks. antal rækker, der skal scannes',
    'OdbcEdit.access.maxscanrows.description' => 'Antallet af rækker der skal scannes ved fastlæggelse af en kolonnes datatype, baseret på eksisterende data.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Angiver hvordan ændringer, der foretages udenfor en transaktion, skrives i databasen.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Angiver om MS Access-driveren vil udføre eksplicitte brugerdefinerede transaktioner asynkront.',

    'OdbcEdit.mssql.driver.label' => 'Driver',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Login-ID',
    'OdbcEdit.mssql.pwd.label' => 'Adgangskode',
    'OdbcEdit.mssql.database.label' => 'Standarddatabase',
    'OdbcEdit.mssql.app.label' => 'Applikationsnavn',
    'OdbcEdit.mssql.wsid.label' => 'Arbejdsstation-ID',
    'OdbcEdit.mssql.language.label' => 'Standardsprog',
    'OdbcEdit.mssql.oemtoansi.label' => 'Konvertering af udvidede tegn til OEM-værdier',

    'OdbcEdit.mysql.driver.label' => 'MySQL ODBC-driver.',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Angiv host-navnet for MariaDB/MySQL-serveren',
    'OdbcEdit.mysql.database.label' => 'Standarddatabase',
    'OdbcEdit.mysql.user.label' => 'Brugernavn',
    'OdbcEdit.mysql.user.description' => 'Brugernavnet der skal bruges til tilslutning til MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Adgangskode',
    'OdbcEdit.mysql.password.description' => 'Adgangskoden til brugerkontoen på serveren',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Den TCP/IP-port der skal bruges hvis serveren ikke er localhost',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Windows-navngiven pipe til forbindelse, hvis servereb er localhost',
    'OdbcEdit.mysql.option.label' => 'Valgmuligheder',
    'OdbcEdit.mysql.option.description' => 'Indstillinger der specificerer hvordan MyODBC skal fungere. Se <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">dokumentation</a>',

    'ProtectedDirectoryList.title' => 'Beskyttede biblioteker for %%domainName%%',
    'ProtectedDirectoryList.add' => 'Tilføj beskyttet bibliotek',
    'ProtectedDirectoryList.addTooltip' => 'Opret en beskyttet mappe.',
    'ProtectedDirectoryList.name' => 'Navn',
    'ProtectedDirectoryList.realmTitle' => 'Titel på det beskyttede område',
    'ProtectedDirectoryList.noSelectionText' => 'Vælg et eller flere emner, der skal fjernes.',
    'ProtectedDirectoryList.edit' => 'Rediger',
    'ProtectedDirectoryList.remove' => 'Fjern beskyttelse',
    'ProtectedDirectoryList.removeTooltip' => 'Fjern egenskaber fra de markerede mapper.',
    'ProtectedDirectoryList.removeConfirmation' => 'Denne handling vil fjerne beskyttelsen fra {count, plural, =1 {mappen {name}} other {# valgte mapper}}. {count, plural, =1 {Denne mappe vil blive gjort frit tilgængelig} other {Mapperne vil blive gjort frit tilgængelige}} for internetbrugere.',
    'ProtectedDirectoryList.removeSuccess' => 'De markerede mapper blev fjernet.',

    'ProtectedDirectoryAdd.title' => 'Opret en beskyttet mappe',
    'ProtectedDirectoryAdd.submit' => 'Opret',
    'ProtectedDirectoryAdd.success' => 'Den beskyttede mappe %%path%% blev oprettet',

    'ProtectedDirectoryEdit.title' => 'Beskyttet mappe-indstillinger',
    'ProtectedDirectoryEdit.success' => 'Indstillingerne for beskyttet mappe blev ændret',

    'ProtectedDirectoryUserList.title' => 'Brugere af den beskyttede mappe %%directory%%',
    'ProtectedDirectoryUserList.add' => 'Tilføj bruger',
    'ProtectedDirectoryUserList.addTooltip' => 'Opret brugerkonti der kan få adgang til den beskyttede mappe %%directory%%',
    'ProtectedDirectoryUserList.login' => 'Navn',
    'ProtectedDirectoryUserList.changePassword' => 'Skift adgangskode',
    'ProtectedDirectoryUserList.noSelectionText' => 'Vælg en eller flere brugere, der skal fjernes.',
    'ProtectedDirectoryUserList.remove' => 'Fjern',
    'ProtectedDirectoryUserList.removeTooltip' => 'Fjern de markerede brugere.',
    'ProtectedDirectoryUserList.removeConfirmation' => 'Fjern {count, plural, =1 {brugeren {login}} other {de # valgte brugere}}?',
    'ProtectedDirectoryUserList.removeSuccess' => 'De valgte brugere blev fjernet.',

    'ProtectedDirectoryUserAdd.title' => 'Opret en bruger til en beskyttet mappe',
    'ProtectedDirectoryUserAdd.subtitle' => 'Mappen %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Brugernavn',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Adgangskode',
    'ProtectedDirectoryUserAdd.submit' => 'Opret',
    'ProtectedDirectoryUserAdd.success' => 'Brugeren %%login%% af den beskyttede mappe er blevet oprettet.',

    'ProtectedDirectoryUserPassword.title' => 'Adgangskode for den beskyttede mappe-bruger',
    'ProtectedDirectoryUserPassword.subtitle' => 'Bruger %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Adgangskode',
    'ProtectedDirectoryUserPassword.submit' => 'Gem',
    'ProtectedDirectoryUserPassword.success' => 'Brugerens akkreditiver blev gemt.',

    'SummaryReport.Layout.title' => 'Egenskaber for rapportlayout',
    'SummaryReport.Layout.success' => 'Rapportlayout %%name%% blev opdateret.',
    'SummaryReport.Layouts.title' => 'Rapportlayouts',

    'SummaryReport.Layout.Add.title' => 'Opret rapportlayout',
    'SummaryReport.Layout.Add.success' => 'Rapportlayout %%name%% blev oprettet.',

    'SummaryReport.Report.title' => 'Oversigtsrapport',
    'SummaryReport.Report.buttonLayouts' => 'Layouts',
    'SummaryReport.Report.buttonSchedule' => 'Planlægning',
    'SummaryReport.Report.buttonProperties' => 'Egenskaber',
    'SummaryReport.Report.buttonTrafficHistory' => 'Trafikhistorik',
    'SummaryReport.Report.buttonPrint' => 'Udskriv',
    'SummaryReport.Report.buttonSend' => 'Send via e-mail',
    'SummaryReport.Report.successSent' => 'Rapporten blev sendt til %%email%%',

    'SummaryReport.Schedule.title' => 'Leveringsplaner for %%name%%',
    'SummaryReport.Schedule.Properties.title' => 'Leveringsplan for %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Rapportleveringsplanen blev opdateret.',

    'SummaryReport.Schedule.Add.title' => 'Opret leveringsplaner for %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Rapportleveringsplanen blev oprettet.',

    'SummaryReport.TrafficHistory.title' => 'Trafikhistorik',

    'VirtualDirectory.title' => 'Virtuel mappe %%path%% for %%domainName%%',
    'VirtualDirectory.errNotExist' => 'Denne virtuelle mappe er knyttet til en fysisk mappe, der ikke findes.',
    'VirtualDirectory.errNoPermissions' => 'Du har ikke tilladelse til at se indholdet af denne mappe.',
    'VirtualDirectory.buttonProperties' => 'Mappeegenskaber',
    'VirtualDirectory.buttonPropertiesHint' => 'Vis og rediger egenskaber for virtuel mappe.',
    'VirtualDirectory.buttonPermissions' => 'Adgangstilladelser for mappe',
    'VirtualDirectory.buttonPermissionsHint' => 'Konfigurér mappe-adgangstilladelser',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'Konfigurer ASP.NET-indstillinger.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'Konfigurer PHP-indstillinger.',
    'VirtualDirectory.buttonMimeTypes' => 'MIME-typer',
    'VirtualDirectory.buttonMimeTypesHint' => 'Administrer registrerede MIME-typer.',
    'VirtualDirectory.buttonErrorDocs' => 'Fejldokumenter',
    'VirtualDirectory.buttonErrorDocsHint' => 'Administrer fejldokumenter.',
    'VirtualDirectory.buttonProtection' => 'Beskyttelse',
    'VirtualDirectory.buttonProtectionHint' => 'Begræns adgang til mappen med adgangskodebeskyttelse.',

    'VirtualDirectory.CreateDirectory.title' => 'Opret mappe',
    'VirtualDirectory.CreateDirectory.name' => 'Mappenavn',
    'VirtualDirectory.CreateDirectory.success' => 'Mappen %%name%% blev oprettet.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Mappen %%name%% findes allerede.',

    'VirtualDirectory.AspDotNet.title' => 'Konfigurer ASP.NET-indstillinger',

    'VirtualDirectory.Php.title' => 'PHP-version',
    'VirtualDirectory.Php.version' => 'Version',
    'VirtualDirectory.Php.success' => 'PHP-versionen blev opdateret.',
];