<?php
// Copyright 1999-2024. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'サブネットまたは IP アドレス',
    'access-network.subnetOrIpAddressHint' => '例えば、2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'ニュースレター',
    'admin.announcement-settings.getConsentLoading' => 'ニュースレターに関する情報を取得中...',
    'admin.announcement-settings.getConsentWarning' => '契約のステータスを取得できませんでした。',
    'admin.announcement-settings.sendAnnounceConsent' => 'Plesk からニュースレターを受信します。ニュースレターにはセキュリティ関連の情報や、製品に関する技術情報、一般情報が含まれます。Plesk がニュースレターの直接送信またはサードパーティサービス経由での送信を目的として、現在有効なデータ保護法に従い、国境を越える処理を含め、私の個人データ（メールアドレス）を収集、処理、使用することに同意し、これを許可します。このチェックボックスをオフにすると、同意が取り消され、Plesk はメールの送信を停止し、私の個人データはシステムから恒久的に削除されます。',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'はい、Plesk のパーソナライズ版ニュースレターを受け取ることに同意します。Plesk International GmbH およびその子会社は、%%privacyPolicy%%に従い、ニュースレターの配信を目的として、私が提供したデータを保管、処理することができます。また、Plesk は、私に対するメッセージや提案内容を調整するために、使用状況や行動に関するデータなどの追加情報をプロファイリングに使用することもできます。メーリングリストの登録はいつでも解除できるものとします。',
    'admin.announcement-settings.privacyPolicy' => 'Plesk プライバシーポリシー',
    'admin.announcement-settings.noConsent' => 'Plesk ニュースレターの登録を解除してください。',
    'admin.announcement-settings.reportConsentError' => 'Plesk から情報を受信するための設定を保存できませんでした。%%error%%。',
    'admin.announcement-settings.profileUpdateError' => '申し訳ありません。現在、プロファイルの更新はできません。後でやり直してください。',
    'admin.announcement-settings.invalidConsentType' => "同意タイプが不明です： '%%type%%'",
    'admin.announcement-settings.retry' => '再試行',
    'admin.announcement-settings.consentGivenInfo' => 'Plesk の一般ニュースレターをお楽しみいただいておりますでしょうか。このたび、よりお役立ていただける新たな選択肢として、パーソナライズ版ニュースレターを開始いたしました。お客様のニーズを考慮して便利な情報や役に立つヒントをお届けします。パーソナライズ版ニュースレターを受け取るには、以下の最初の文を選び［OK］をクリックしてください。',
    'admin.announcement-settings.consentNotGivenInfo' => '一般ニュースレターを購読されていないようです。Plesk では、お客様のニーズを考慮して便利な情報やヒントをお届けするパーソナライズ版ニュースレターもご用意しています。',

    'admin.personal-info.title' => '管理者プロファイルの編集',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 設定',
    'admin.personal-info.settingsSectionLegend' => '設定',

    'admin-alias.login' => 'ユーザ名',
    'admin-alias.password' => 'パスワード',
    'admin-alias.passwordConfirmation' => 'パスワードの確認',
    'admin-alias.email' => 'メール',
    'admin-alias.contact' => '担当者名',
    'admin-alias.comments' => 'コメント',
    'admin-alias.emptyLogin' => 'ユーザ名を入力してください。',
    'admin-alias.loginTooLong' => 'ユーザ名の長さが 20 文字を超えています。',
    'admin-alias.emptyEmail' => 'メールアドレスを入力してください。',
    'admin-alias.emptyContactName' => '担当者名を入力してください。',
    'admin-alias.contactNameTooLong' => '担当者名の長さが 255 文字を超えています。',
    'admin-alias.emptyPassword' => 'パスワードを入力してください。',
    'admin-alias.commentsTooLong' => 'コメントの長さが 255 文字を超えています。',
    'admin-alias.emailActivation' => 'アカウントをメールでアクティブ化',
    'admin-alias.simplePanel' => '制限モードを有効にする',
    'admin-alias.simplePanelHint' => '追加管理者が Plesk で実行できるアクションを制限するには、このオプションを選択します。使用可能なアクションを変更するには、%%link%%にアクセスします。',
    'admin-alias.simplePanelLink' => '［ツールと設定］/>［制限モードの設定］',
    'admin-alias.lockPowerUser' => '追加の管理者にパワーユーザービューを強制的に適用',
    'admin-alias.lockPowerUserHint' => '追加の Plesk 管理者のビューを制限できます（顧客、リセラー、サービスプランへのアクセス不可）。',

    'admin-info.plesk-settings.multiplyLogin' => 'このアカウントの下で複数セッションを許可',
    'admin-info.plesk-settings.adminLanguage' => '管理者のインターフェース言語',
    'admin-info.plesk-settings.password' => 'パスワード',
    'admin-info.plesk-settings.passwordConfirmation' => 'パスワードの確認',
    'admin-info.plesk-settings.oldPassword' => '旧パスワード',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => '旧パスワードが正しくありません。入力し直してください。',

    'admin-panel.form.contact-info.login' => 'ログイン名',
    'admin-panel.form.contact-info.contactName' => '担当者名',
    'admin-panel.form.contact-info.emptyLogin' => 'ログイン名を入力してください。',
    'admin-panel.form.contact-info.emptyContactName' => '担当者名を入力してください。',
    'admin-panel.form.contact-info.loginTooLong' => 'このログイン名は長すぎます（許可される最大長は %max% 文字です）。',
    'admin-panel.form.contact-info.contactNameTooLong' => 'この担当者名は長すぎます（%max% 文字以内にしてください）。',
    'admin-panel.form.contact-info.email' => 'メールアドレス',
    'admin-panel.form.contact-info.emptyEmail' => 'メールアドレスを入力してください。',
    'admin-panel.form.contact-info.companyName' => '会社名',
    'admin-panel.form.contact-info.longCompanyName' => 'この会社名は長すぎます（%max% 文字以内にしてください）。',
    'admin-panel.form.contact-info.phone' => '電話番号',
    'admin-panel.form.contact-info.longPhone' => 'この電話番号は長すぎます（許可される最大長は %max% 文字です）',
    'admin-panel.form.contact-info.fax' => 'ファックス番号',
    'admin-panel.form.contact-info.imNumber' => 'インスタントメッセンジャー',
    'admin-panel.form.contact-info.longFax' => 'このファックス番号は長すぎます（許可される最大長は %max% 文字です）',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '入力した電話番号は無効です。',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'この FAX 番号は正しくありません',
    'admin-panel.form.contact-info.address' => '住所',
    'admin-panel.form.contact-info.longAddress' => 'この住所は長すぎます（許可される最大長は %max% 文字です）',
    'admin-panel.form.contact-info.city' => '市区町村',
    'admin-panel.form.contact-info.longCity' => 'この市区町村名は長すぎます。',
    'admin-panel.form.contact-info.shortCity' => 'この市区町村名は短すぎます。',
    'admin-panel.form.contact-info.state' => '都道府県',
    'admin-panel.form.contact-info.postalCode' => '郵便番号',
    'admin-panel.form.contact-info.country' => '国',
    'admin-panel.form.contact-info.additionalInfo' => '追加情報',
    'admin-panel.form.contact-info.additionalInfoHint' => 'テキスト形式：HTML タグはすべて無視されます。',
    'admin-panel.form.contact-info.duplicateEmail' => '同じメールアドレスのユーザがシステムに既に登録されています。',

    'admin-panel.form.domain-info-section.domainInfoSection' => '契約',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '契約でプロビジョニングされるウェブサイトのプロパティを指定します。',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '契約でプロビジョニングされるウェブサイトのプロパティを指定します。',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '契約でプロビジョニングされるウェブサイトのプロパティを指定します。',
    'admin-panel.form.domain-info-section.createSubscription' => '顧客に契約を作成',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '現時点ではホスティングサービス契約を作成しない場合や、顧客用にウェブサイトをセットアップしない場合には、このチェックボックスをオフにしてください。契約がなければ、顧客は顧客パネルにログインできません。',
    'admin-panel.form.domain-info-section.domainName' => 'ドメイン名',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'ドメイン名を指定する必要があります。',
    'admin-panel.form.domain-info-section.shared' => '共用',
    'admin-panel.form.domain-info-section.exclusive' => '専用',
    'admin-panel.form.domain-info-section.userName' => 'ユーザ名',
    'admin-panel.form.domain-info-section.userNameHint' => '契約内で作成されたウェブサイトのファイルとフォルダの管理に使用するシステムユーザアカウントです。',
    'admin-panel.form.domain-info-section.emptyLogin' => 'ユーザ名を指定する必要があります。',
    'admin-panel.form.domain-info-section.password' => 'パスワード',
    'admin-panel.form.domain-info-section.emptyPassword' => 'パスワードを指定する必要があります。',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'パスワードの確認',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 アドレス',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "ウェブサイトのホストに使用されている IP アドレスは、ウェブサイトの仮想ホストのネットワークアドレスです。",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 アドレス',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'なし',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '追加の契約の設定',
    'admin-panel.form.domain-info-section.credentials' => 'システムユーザのクレデンシャル',
    'admin-panel.form.domain-info-section.credentialsHint' => 'ホストされているファイルに FTP または SSH 経由でアクセスするために使用されます',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'ホストされているファイルに FTP または RDP 経由でアクセスするために使用されます',

    'admin-panel.form.login-info.userName' => 'ユーザ名',
    'admin-panel.form.login-info.emptyUserName' => 'ユーザ名を入力してください。',
    'admin-panel.form.login-info.password' => 'パスワード',
    'admin-panel.form.login-info.emptyPassword' => 'パスワードを入力してください。',
    'admin-panel.form.login-info.passwordConfirmation' => 'パスワード再入力',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'パスワードを変更すると、内部メールアドレスのパスワードも変更されます。',
    'admin-panel.form.login-info.emailActivation' => 'アカウントをメールでアクティブ化',
    'admin-panel.form.login-info.emailActivationHint' => '作成されたアカウントは、メールで送信されたリンクを使用してユーザがアクティブ化するか、管理者がアカウントを手動でアクティブ化するまで、アクティブではありません。',

    'admin-panel.form.subscription-info-section.subscription' => '契約',
    'admin-panel.form.subscription-info-section.servicePlan' => 'サービスプラン',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '現行サービスプラン',
    'admin-panel.form.subscription-info-section.newServicePlan' => '新しいサービスプラン',
    'admin-panel.form.subscription-info-section.adminPlan' => 'シンプルプラン',
    'admin-panel.form.subscription-info-section.none' => 'なし',
    'admin-panel.form.subscription-info-section.addonPlans' => 'アドオン',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'プランの関連付けを変更した後に、契約のパラメータのカスタマイズを行います。 これを行うと、同期のため契約がロックされることにご注意ください。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '契約パラメータの作成後にカスタマイズに進みます。',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "顧客の作成後に、契約パラメータのカスタマイズに進みます。",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '作成後、契約パラメータのカスタマイズに進む（注：これにより、この契約は同期に対してロックされます）',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'これにより、契約が同期されないようロックされます。',
    'admin-panel.form.subscription-info-section.buttonOk' => '契約を追加',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '契約をサービスプランと同期できませんでした。次の契約設定がサービスプランと相反しています：%%problems%%。',

    'app.configure.otherSettings' => 'その他',
    'app.configure.passwordConfirmation' => 'パスワードの確認',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'インストールされたすべてのアプリケーションを強制的に更新',
    'app.update-settings.forceUpdatesHint' => 'アップデートが公開されると、すべての顧客のアプリケーションが自動更新されます。顧客が自動更新を無効化することはできません。注意：このオプションを使用する場合、更新によってアプリケーションの機能が著しく影響を受ける可能性があるため、注意が必要です。例えば、異なるバージョンのアプリケーションではアプリケーション拡張が機能しない場合があります。',
    'app.update-settings.suggestUpdates' => '「アップデートの公開後、このアプリケーションを自動更新」オプションをデフォルトでオンにする',
    'app.update-settings.suggestUpdatesHint' => '新規インストールされたアプリケーションに対し、アプリケーションの設定で「このアプリケーションを自動更新」オプションはオンに設定されます。',

    'backup.server-settings.rotation' => '保存するフルバックアップファイルの最大数（スケジュール済みバックアップと手動バックアップの両方を含む）',
    'backup.server-settings.rotationDescription' => 'ユーザはサーバストレージにこの数までフルバックアップを保存できます。ストレージに既にあるフルバックアップ数が上限を超えている場合、日付の新しいバックアップのみが保持されます。増分バックアップに影響はありません。',
    'backup.server-settings.maxProcesses' => '同時に実行できる定期バックアッププロセスの最大数',
    'backup.server-settings.niceScheduled' => '優先度の低いスケジュール済みバックアッププロセスを実行',
    'backup.server-settings.niceScheduledPriority' => '優先度',
    'backup.server-settings.niceScheduledPriorityDescription' => '1 ～ 19 の間で値を入力してください。値が大きいほど優先度は低くなります。',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 優先度',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '0 ～ 7 の間で値を入力してください。値が大きいほど優先度は低くなります。',
    'backup.server-settings.niceAlways' => 'すべてのバックアッププロセスを優先度「低」で実行',
    'backup.server-settings.niceAlwaysPriority' => '優先度',
    'backup.server-settings.niceAlwaysPriorityDescription' => '1 ～ 19 の間で値を入力してください。値が大きいほど優先度は低くなります。',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 優先度',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '0 ～ 7 の間で値を入力してください。値が大きいほど優先度は低くなります。',
    'backup.server-settings.compressionLevel' => '圧縮レベル',
    'backup.server-settings.compressionLevelNoCompression' => '圧縮なし',
    'backup.server-settings.compressionLevelFastest' => '最速',
    'backup.server-settings.compressionLevelFast' => '高速',
    'backup.server-settings.compressionLevelNormal' => '中',
    'backup.server-settings.compressionLevelMaximum' => '最高',
    'backup.server-settings.freeSpaceRequired' => '指定した空きディスクスペースがサーバにある場合のみ、バックアップを開始する（メガバイト単位）',
    'backup.server-settings.checkBackupDiskSpace' => 'サーバの空きディスク容量が十分にある場合にのみ、バックアップを開始',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'ネイティブ MS SQL バックアップ機能を使用（リモートデータベースの場合、［ツールと設定］ >  ［データベースサーバ］でリモート MS SQL サーバのバックアップ設定を構成したことを確認してください）',
    'backup.server-settings.localFtpRestriction' => 'ローカルサーバで FTP バックアップストレージのセットアップを許可',
    'backup.server-settings.backupSecuritySettings' => 'バックアップのセキュリティ設定',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'リモートストレージへのアップロードが失敗した場合、サーバストレージにバックアップを保存',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'リモートストレージへのアップロードが失敗した場合、リモートストレージに保存すべき手動バックアップとスケジュールバックアップは、ローカルサーバストレージに保存されます。サーバストレージにバックアップを保存するパーミッションがユーザに必要です。',
    'backup.server-settings.AllowScheduleHourly' => '時間単位バックアップのスケジュールを顧客およびリセラーに許可する',

    'change-current-subscription.hint' => '契約とサービスプランの関連付けを変更します。新しいサービスプランを「なし」にすると、サービスプランから契約が切り離され、「カスタム」になります。',
    'change-current-subscription.subscriptionNotSynchronized' => '契約をサービスプランと同期できませんでした。次の契約設定がサービスプランと相反しています：%%problems%%。',

    'change-password.oldPassword' => '旧パスワード',
    'change-password.password' => '新規パスワード',
    'change-password.passwordConfirmation' => 'パスワードの確認',
    'change-password.oldPasswordIsIncorrect' => '旧パスワードが正しくありません。入力し直してください。',
    'change-password.unableToFindAdditionalAdminAccount' => '追加の管理者アカウントが見つかりません。',
    'change-password.warningAboutAdminPasswordSyntax' => "パスワードの長さは %%min%%～%%max%% 文字にしてください。パスワードにユーザ名を含めないでください。\n引用符、スペース、国別文字をパスワードに使用しないでください。",
    'change-password.warningAboutWinAdminPasswordSyntax' => "引用符、スペース、セミコロン、国別文字をパスワードに使用しないでください。\nパスワードの長さは %%min%%～%%max%% 文字にしてください。ユーザ名をパスワードに含めることはできません。",

    'change-reseller-oversell-policy.oversellPolicy' => '販売超過ポリシー',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '販売超過を許可する',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '販売超過によって、リセラーはプランで割り当てられた量よりも多くのリソースを販売できます。 販売超過が許可されると、リセラーは初期リソース割り当ての代わりに実際のリソース使用量で管理されます。',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '販売超過を許可しない',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '販売超過を許可しない場合、リセラーは実際のリソース使用量に関係なく、最初にプランで割り当てられた量のリソースしか販売できません。',

    'change-reseller-subscription.hint' => 'リセラー契約とサービスプランの関連付けを変更します。新しいサービスプランに「なし」を選択すると、サービスプランから契約が切り離され、「カスタム」になります。',
    'change-reseller-subscription.subscriptionNotSynchronized' => '契約をサービスプランと同期できませんでした。次の契約設定がサービスプランと相反しています：%%problems%%。',
    'change-reseller-subscription.servicePlan' => '新しいプラン',
    'change-reseller-subscription.oldSubscription' => '現在のプラン',
    'change-reseller-subscription.none' => 'なし',
    'change-reseller-subscription.infoSubscriptionChanged' => 'サービスプランとの契約の関連付けが更新されました',
    'change-reseller-subscription.customizeSubscription' => 'サービスプランとの紐付けを更新後、契約パラメータのカスタマイズに進む（注：これにより、この契約は同期に対してロックされます）',

    'change-subscription.hint' => '選択した契約とサービスプランとの紐付けを変更します。',
    'change-subscription.selectPlanLegend' => 'サービスプラン',
    'change-subscription.selectPlanDescription' => '別のサービスプランに切り替える場合は、リストから新しいプランを選択してください。「なし」を選択するとサービスプランから契約が切り離され、「カスタム」になります。',
    'change-subscription.servicePlan' => '新しいサービスプラン',
    'change-subscription.selectAddonPlansLegend' => 'アドオンプラン',
    'change-subscription.selectAddonPlansDescription' => 'アドオンプランを追加または削除します。',
    'change-subscription.noChange' => '変更なし',
    'change-subscription.none' => 'なし',
    'change-subscription.add' => '追加',
    'change-subscription.del' => '削除',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'サブネットまたは IP アドレス',
    'control-panel-access.network.subnetOrIpAddressHint' => '例えば、2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '管理者権限で Plesk にアクセスします。',
    'control-panel-access.settings.policyAllow' => 'リストに含まれるネットワークを除き、アクセスを許可する',
    'control-panel-access.settings.policyDeny' => 'リストに含まれないネットワークからのアクセスを拒否する',

    'create-subscription.title' => '契約を追加',
    'create-subscription.titleOwn' => '自社用の契約を追加',
    'create-subscription.poolIsEmpty' => '契約を作成できません。Plesk に共用 IP アドレスがなく、専用 IP アドレスの空きがありません。',
    'create-subscription.infoNewSubscriptionCreated' => '契約 %%name%% を作成しました',
    'create-subscription.createBeforeAppInstall' => 'アプリケーションをインストールするには、契約が必要です。',

    'customer.hint' => 'ホスティングサービスに新しい顧客を登録します。この登録によって、Plesk で顧客アカウントを作成し、いずれかのホスティングプランへの契約および（オプションで）アドオンを作成することになります。また、この契約は、いずれのプランにも紐付けられないリソースおよびサービスのカスタムセットを提供することもできます。これには、サービスプランの横で［なし］を選択します。',
    'customer.contactInfoSection' => '連絡先情報',
    'customer.additionalInfoSection' => '追加の顧客情報',
    'customer.accessToPanelSection' => 'Plesk へのアクセス',
    'customer.contactInfoSectionHint' => '顧客の連絡先情報を入力します。',
    'customer.accessToPanelSectionHint' => '顧客が顧客パネルへのアクセスに使用するクレデンシャル',
    'customer.unableCreateSubscription' => '契約を作成できません。 %%reason%%',
    'customer.poolIsEmpty' => 'IP プールが空です',
    'customer.buttonOk' => '顧客の追加',

    'database-settings.dbPrefixRadio' => 'データベース名の先頭にプレフィックスおよびアンダーライン（_）を追加',
    'database-settings.dbPrefixNone' => 'なし',
    'database-settings.dbPrefixUsername' => 'ユーザ名',
    'database-settings.dbPrefixExternalId' => '契約の外部 ID',
    'database-settings.dbPrefixCustom' => 'カスタムプレフィックス',
    'database-settings.dbUserPrefixRadio' => 'データベースユーザ名の先頭にプレフィックスおよびアンダーラインを追加',
    'database-settings.dbUserPrefixHint' => 'データベースユーザ名は、<prefix>_<database_user_name> のようになります。データベースではユーザ名の長さに制限があるため、<prefix> は短縮される場合があります。',
    'database-settings.grantAlterDatabase' => 'ALTER DATABASE パーミッションをすべての Microsoft SQL Server データベースユーザに付与',
    'database-settings.grantAlterDatabaseHint' => '新規ユーザおよび既存ユーザに対し、このパーミッションが付与されます。',
    'database-settings.aclRadio' => 'MySQL データベースユーザのリモートアクセス用のデフォルト設定',
    'database-settings.aclLocalhost' => 'ローカル接続のみを許可',
    'database-settings.aclAny' => '任意のホストからのリモート接続を許可',
    'database-settings.aclCustom' => '以下からのリモート接続を許可',
    'database-settings.aclDescription' => 'この設定は、ユーザのパーミッションのみ変更します。ローカル MySQL サーバへのリモートアクセスを有効にするには、%%serverLink%% で該当オプションを選択してください',
    'database-settings.aclDescriptionLink' => 'ローカル MySQL 設定',
    'database-settings.example' => "例：",
    'database-settings.aclExampleDescription' => "指定されたホストは、このユーザの代理としてデータベースにアクセスすることが許可されます。",
    'database-settings.dbPrefixAlphaNumeric' => 'プレフィックスの値には英数字とアンダーラインのみを使用できます。',

    'dns.add-acl-record.description' => '当該 DNS ゾーンのコピーの受け入れが許可される DNS サーバの IP アドレスを追加します。',
    'dns.add-acl-record.ipAddress' => 'IP アドレス',
    'dns.add-acl-record.ipAddressWithMask' => 'IP アドレス/マスク',

    'dns.settings.recursion' => 'DNS 再帰問い合わせ',
    'dns.settings.recursionOn' => 'すべての要求を許可',
    'dns.settings.recursionLocal' => 'ローカル要求のみ許可',
    'dns.settings.recursionLocalnets' => 'ローカルネットワークからの要求のみを許可',
    'dns.settings.recursionOff' => 'すべての要求を拒否',
    'dns.settings.customConfiguration' => '追加の DNS 設定',
    'dns.settings.customConfigurationPlaceholder' => 'ここで指定する設定により、サーバ全体の設定が上書きされます。',
    'dns.settings.customConfigurationHint' => '特定の設定が見つからない場合、named.conf の構文を使用して上のフィールドに追加してください。',
    'dns.settings.customConfigurationExample' => 'たとえば、DNS サーバのホスト名を非表示にするには、次の行を追加します： ',
    'dns.settings.restoreDefaultButton' => 'デフォルト設定を使用',

    'dns.template.synchronize-done' => 'DNS ゾーンテンプレートが正常に適用されました。',
    'dns.template.synchronize-error' => 'DNS ゾーンテンプレートが一部の DNS ゾーンに適用されませんでした。',
    'dns.template.synchronize-progress' => 'DNS ゾーンテンプレートを適用しています。',

    'domain-restriction.name' => 'ドメイン名',
    'domain-restriction.nameDescription' => 'アスタリスク（*）を使用して、ワイルドカードパターンを指定することができます。例えば「*.example.com」のように入力します。',
    'domain-restriction.domainAlreadyExists' => '指定したドメイン名は既にリストに含まれています。',

    'event-handler.eventLabel' => 'イベント',
    'event-handler.priorityLabel' => '優先度',
    'event-handler.userLabel' => 'ユーザ',
    'event-handler.commandLabel' => 'コマンド',
    'event-handler.commandHint' => '最高の結果を得るために、スクリプトファイルの \'command\' フィールドにフルパスを入力してください。機能しない可能性があるため、システムコマンドを入力しないでください。例えば、出力リダイレクト演算子 > または < の含まれるコマンドは機能しません。',
    'event-handler.priorityHighestText' => '最高',
    'event-handler.priorityHighText' => '高',
    'event-handler.priorityNormalText' => '中',
    'event-handler.priorityLowText' => '低',
    'event-handler.priorityLowestText' => '最低',
    'event-handler.priorityCustomText' => 'カスタム',
    'event-handler.priorityHighestOption' => '最高（%%value%%）',
    'event-handler.priorityHighOption' => '高（%%value%%）',
    'event-handler.priorityNormalOption' => '中（%%value%%）',
    'event-handler.priorityLowOption' => '低（%%value%%）',
    'event-handler.priorityLowestOption' => '最低（%%value%%）',

    'extension.upload.fileUpload' => '拡張パッケージファイルのパス',

    'external-webmail.hint' => 'Plesk に追加ウェブメールを登録すると、顧客がこれらを使用できるようになります。追加ウェブメールはホスティングプランと契約の \'メール\' プロパティにオプションとして表示されます。ウェブメール名はウェブメールオプションのリストに表示され、顧客パネルでメールボックスの横のウェブメールアイコンをクリックすると URL が開きます。',
    'external-webmail.name' => 'ウェブメールのサービス名',
    'external-webmail.url' => 'ウェブメールサービスの URL',
    'external-webmail.enabled' => '使用可能',

    'ftp-settings.generalSection' => '全般',
    'ftp-settings.portRange' => 'パッシブ FTP モードでの接続用のポートまたはポート範囲',
    'ftp-settings.hintPortRange' => '（デフォルト値：%%defaultPortRange%%）',

    'health.upload.hint' => 'サーバヘルスモニタの構成をアップロードします。構成はアップロード後すぐに適用されます。',
    'health.upload.selectFile' => '構成ファイル',

    'install-local-package.selectUploadType' => '以下のいずれかを選択：',
    'install-local-package.uploadAsFile' => 'APS パッケージをアップロード',
    'install-local-package.downloadFromCatalog' => 'アプリケーションカタログからアプリケーションを選択',
    'install-local-package.formInfo' => "新規アプリケーションをアップロードして選択可能なアプリケーションのリストを拡張したり、アプリケーションカタログからアプリケーションを追加してさらに構成することができます。",
    'install-local-package.invalidFileExtension' => 'アップロードしたアプリケーションは、拡張子が .zip の ZIP アーカイブでなければいけません',
    'install-local-package.packagesNotSelected' => 'パッケージが選択されていません。',
    'install-local-package.visible' => '顧客に対して使用可能にする',
    'install-local-package.isCommercial' => 'このアプリケーションは有償であり、ライセンスキーの購入が必要です。',
    'install-local-package.visibleDescription' => 'アプリケーションを顧客がインストールできるようにします。',

    'ip-address.addTitle' => 'IP アドレスを追加',
    'ip-address.editTitle' => 'インターフェース %%interface%% の IP アドレス %%address%%',
    'ip-address.generalSection' => '全般',
    'ip-address.interface' => 'インターフェース',
    'ip-address.addressAndSubnetPrefixLength' => 'IP アドレスとサブネットマスク',
    'ip-address.addressHintIPv4' => '例：123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => '例：2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'パブリック IP アドレス',
    'ip-address.hintPublicIp' => 'Plesk サーバが NAT 環境内にある場合、パブリック IP アドレスを使用できます。',
    'ip-address.distributionType' => 'この IP アドレスは次のように分散されます：',
    'ip-address.distributionTypeShared' => '共有',
    'ip-address.distributionTypeExclusive' => '専用',
    'ip-address.certificate' => 'SSL/TLS 証明書',
    'ip-address.defaultSite' => 'デフォルトサイト',
    'ip-address.ftpOverSslNotSupportedByServer' => 'インストールされた FTP サーバは FTPS に対応していません。',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'インストールされた FTP サーバは IPv6 アドレスに対応していません。',
    'ip-address.interfaceDHCPEnabled' => 'IP アドレスを追加できません。このネットワークインターフェースは IP アドレスを自動的に取得します。',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '注：カスタム Plesk URL がすべての不明なドメインに対して有効になっています。https://%%ip%%/ ではデフォルトサイトの代わりに Plesk インターフェースが表示されます。',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'ネットワークアダプタ %%interface%% は存在しません。この IP アドレスを他のネットワークアダプタに移動するか、一覧から削除してください。',
    'ip-address.none' => 'なし',

    'ip-ban.filter.name' => '名前',
    'ip-ban.filter.content' => 'コンテンツ',
    'ip-ban.filter.filterExistsError' => 'この名前のフィルタは既に存在します。',

    'ip-ban.jail.name' => '名前',
    'ip-ban.jail.filter' => 'フィルタ',
    'ip-ban.jail.filterDescription' => 'フィルタを選択します。',
    'ip-ban.jail.action' => 'アクション',
    'ip-ban.jail.actionDescription' => 'アクションを選択し、ボタンをクリックして追加します。',
    'ip-ban.jail.logPath' => 'ログパス',
    'ip-ban.jail.banTime' => 'IP アドレスのアクセス制限期間',
    'ip-ban.jail.maxRetry' => 'ログイン試行の最大失敗回数',
    'ip-ban.jail.timeUnit' => '秒',
    'ip-ban.jail.addAction' => '追加',
    'ip-ban.jail.chooseAction' => '選択：',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 認証の失敗（ファイルへのログイン時）',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 認証の失敗（すべてのログイン）',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 認証の失敗（syslog へのログイン時）',
    'ip-ban.jail.apache-badbots-filter-description' => 'スパムボットおよび不正なウェブクローラ',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP および POP3 認証の失敗',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP、POP3、Sieve 認証の失敗',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP、POP3、Sieve 認証の失敗（アグレッシブモード）',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde ウェブメール認証の失敗',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'ウェブアプリケーションファイアウォール（ModSecurity）セキュリティとアクセス制御の違反',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 認証の失敗',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 認証の失敗',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube ウェブメール認証の失敗',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 認証の失敗',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP クライアントエラー（RBL を含む）',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP クライアントエラー、認証の失敗、および DDoS 攻撃',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP および SASL 認証の失敗',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 攻撃',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP クライアントエラーおよび認証の失敗',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP クライアントエラー（RBL を含む）',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP クライアントエラー（RBL のみ）',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD ログインの失敗',
    'ip-ban.jail.recidive-filter-description' => 'Fail2ban によって繰り返し禁止されたホスト',
    'ip-ban.jail.sshd-filter-description' => 'SSH ログインの失敗',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH ログインの失敗、ネゴシエーションの失敗、DDoS 攻撃',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH ログインの失敗および DDoS 攻撃',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH ログインとネゴシエーションの失敗',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'firewalld ファイアウォール経由で禁止、すべてのポート',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'firewalld ファイアウォール経由で禁止、複数のポート',
    'ip-ban.jail.firewallcmd-new-action-description' => 'firewalld ファイアウォール経由で禁止、1 つのポート',
    'ip-ban.jail.iptables-action-description' => 'iptables ファイアウォール経由で禁止、1 つのポート',
    'ip-ban.jail.iptables-allports-action-description' => 'iptables ファイアウォール経由で禁止、すべてのポート',
    'ip-ban.jail.iptables-multiport-action-description' => 'iptables ファイアウォール経由で禁止、複数のポート',
    'ip-ban.jail.sendmail-action-description' => 'Sendmail 経由でメール通知を送信',
    'ip-ban.jail.jailExistsError' => 'この名前の jail は既に存在します。',
    'ip-ban.jail.invalidInteger' => '指定した値が無効です。整数を指定してください。',

    'ip-ban.settings.pageHint' => 'IP アドレスによるアクセス制限の設定をセットアップして、サーバおよびウェブサイトを悪意あるトラフィックから保護できます。',
    'ip-ban.settings.detectionEnabled' => '侵入検知を有効化',
    'ip-ban.settings.banPeriod' => 'IP アドレスのアクセス制限期間',
    'ip-ban.settings.banTimeWindow' => '攻撃を検知する期間',
    'ip-ban.settings.maxRetries' => 'IP アドレスがアクセス制限される失敗回数',
    'ip-ban.settings.timeUnit' => '秒',
    'ip-ban.settings.invalidInteger' => '無効な値が指定されました。正の整数を指定してください。',

    'ip-ban.trusted-ip.ipAddress' => 'IP アドレス',
    'ip-ban.trusted-ip.hintIpAddress' => 'IP アドレス、CIDR マスク、または DNS ホスト名。',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => '入力された IP アドレス、ネットワークアドレス、またはホスト名が正しくありません。',
    'ip-ban.trusted-ip.ipAddressIsTooLong' => 'IP アドレスは %max% 文字以内にする必要があります。',
    'ip-ban.trusted-ip.ipAddressDescription' => '説明',
    'ip-ban.trusted-ip.hintIpAddressDescription' => '信頼できるリストに IP アドレスが追加された理由。',
    'ip-ban.trusted-ip.ipAddressDescriptionTooLong' => '説明は %max% 文字以内にする必要があります。',

    'login-info.hint' => '顧客が顧客パネルへのアクセスに使用するユーザ名とパスワードを変更します。',
    'login-info.resellerHint' => 'リセラーが Plesk へのアクセスに使用するユーザ名とパスワードを変更します。',
    'login-info.myProfileHint' => 'Plesk へのアクセスに使用するパスワードを変更します。',

    'firewall-rule.titleEdit' => 'ファイアウォールルールの編集',
    'firewall-rule.titleNew' => 'ルールを追加',
    'firewall-rule.isEnabled' => 'ルールをオンにする',
    'firewall-rule.name' => 'ルール名',
    'firewall-rule.profiles' => 'プロファイル',
    'firewall-rule.profilesHint' => 'プロファイルを少なくとも 1 つ選択する必要があります。',
    'firewall-rule.profileDomain' => 'ドメイン',
    'firewall-rule.profilePrivate' => 'プライベート',
    'firewall-rule.profilePublic' => 'パブリック',
    'firewall-rule.action' => 'アクション',
    'firewall-rule.actionAllow' => '許可',
    'firewall-rule.actionBlock' => '拒否',
    'firewall-rule.port' => '以下のポートまたはポート範囲にて接続を許可する',
    'firewall-rule.portHint' => '例：1000 または 1000-1051',
    'firewall-rule.protocolTcp' => 'TCPプロトコル',
    'firewall-rule.protocolUdp' => 'UDPプロトコル',
    'firewall-rule.remoteAddresses' => 'リモートアドレス',
    'firewall-rule.remoteAddressesHint' => '例：192.168.0.1 または 192.168.0.0/16',
    'firewall-rule.newRule' => '新規ルール',
    'firewall-rule.successNew' => 'ファイアウォールルールが追加されました。',
    'firewall-rule.successEdit' => 'ファイアウォールルールが更新されました。',

    'mail.lists-server-settings.email' => "メーリングリスト管理者のメールアドレス",
    'mail.lists-server-settings.emptyEmail' => 'メールアドレスを入力してください。',
    'mail.lists-server-settings.newPassword' => '新規パスワード',
    'mail.lists-server-settings.emptyPassword' => 'パスワードを入力してください。',
    'mail.lists-server-settings.passwordConfirmation' => 'パスワードの確認',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'メーリングリストソフトウェアが構成されました',

    'mail.outgoing-messages.hint' => 'メールボックスからの送信メッセージ数の上限を指定します。',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '送信メールメッセージ数の上限',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'デフォルト（%%domainOutgoingMessages%% 通/時間）',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'このメールボックスのカスタム値',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '通/時間',

    'mail-gate-settings.host' => 'ホスト名または IP アドレス',
    'mail-gate-settings.port' => 'ポート',
    'mail-gate-settings.login' => 'ユーザ名',
    'mail-gate-settings.password' => 'パスワード',
    'mail-gate-settings.encryption' => 'SMTP サーバには暗号化接続が必要',
    'mail-gate-settings.allowUsers' => 'ユーザのスクリプトによる SMTP サーバ経由のメール送信を許可（指定したユーザ名とパスワードを使用）',
    'mail-gate-settings.useDefaultSettings' => 'Plesk にインストールされたメールサーバおよび Plesk で作成されたデフォルトメールアカウントを使用',

    'mail-gate.hint' => 'Plesk メールサーバがインストールである場合やメール送信が禁止されている場合に使用する SMTP サーバを指定します。このサーバは Plesk とユーザスクリプトによって、メール通知などの送信時の SMTP リレーとして使用されます。',
    'mail-gate.enableMailGate' => 'Plesk に対して SMTP サーバ経由でのメール通知送信を許可する',
    'mail-gate.notifications' => '外部 SMTP サーバによるメール通知',
    'mail-gate.smtpSettings' => '外部 SMTP サーバ設定',

    'optimization-settings.apacheModulesSection' => 'Apache モジュール',
    'optimization-settings.apacheSettingsSection' => '一般設定',
    'optimization-settings.additionalPageHint' => 'どのような結果が生じるかを熟知している場合に限り、モジュールのオン/オフを切り替えてください。変更内容によっては、Apache のパフォーマンスが低下したり、機能しなくなる可能性があります。',
    'optimization-settings.pageHint' => '使用していない Apache モジュールをオフにして Plesk を最適化します。この最適化により、メモリ使用量が向上し、より多くのホスティング顧客にサービスを提供できるようになります。一部のモジュールは相互に依存しており、このようなモジュールをオフ（またはオン）にするには、連携先のモジュールもオフ（またはオン）にする必要があります。',
    'optimization-settings.advancedUsersOnlyWarning' => 'これは上級ユーザ用の機能です。',
    'optimization-settings.apacheRestartInterval' => 'Apache 再起動間隔（秒）',
    'optimization-settings.apacheRestartIntervalHint' => '指定した間隔で、Plesk がドメインおよびサブドメインに加えられた変更をチェックします。ウェブサーバの再起動が必要な変更があった場合、Plesk は Apache を再起動します。',
    'optimization-settings.gracefulRestart' => 'Apache グレースフルリスタート',
    'optimization-settings.gracefulRestartHint' => '選択すると、ホスティング設定を変更するたびに、サーバでホストされているすべてのウェブサイトにダウンタイムが発生するのを回避できます。',
    'optimization-settings.pipedLog' => 'パイプログ',
    'optimization-settings.mpmMode' => 'MPM モード',
    'optimization-settings.moduleDeprecated' => '（非推奨）',

    'personal-info.contactInfoSection' => '連絡先情報',
    'personal-info.hint' => 'ユーザの連絡先情報を変更します。',
    'personal-info.hintMyProfile' => '自分の連絡先情報を変更します。',

    'php-handler.extension.title' => 'PECL パッケージをインストール',
    'php-handler.extension.description' => "パッケージ名に追加パラメータを指定することで、拡張のベータ版をインストールできます（例：「msgpack-beta」）。",
    'php-handler.extension.name' => 'パッケージ名',

    'php-handler.ini.formHint' => 'この php.ini ファイルは、このハンドラにのみ使用されます。',
    'php-handler.ini.formHintSharedIni' => 'この php.ini ファイルは、次の PHP ハンドラにも使用されます。 %%handlers%%この設定は、これらのハンドラを使用するすべてのウェブサイトに適用されます。',
    'php-handler.ini.incorrectTextForIniFile' => "指定された設定が正しくなく、php.ini ファイルに保存できません。エラー：%%message%%",

    'plan-item-custom.planItemName' => 'サービス名',
    'plan-item-custom.buttonLabel' => 'この名前は、カスタムボタンのラベルとしても使用されます。',
    'plan-item-custom.planItemDescription' => 'サービスの説明',
    'plan-item-custom.buttonTooltip' => 'この名前は、カスタムボタンのヒントとしても使用されます。',
    'plan-item-custom.url' => 'カスタムボタンに設定する URL',
    'plan-item-custom.backgroundImage' => 'カスタムボタンの背景イメージ',
    'plan-item-custom.emptyItemName' => 'サービスにラベルを指定してください。',
    'plan-item-custom.emptyItemDescription' => 'サービスのヒントにテキストを入力してください。',
    'plan-item-custom.emptyUrl' => 'URL を指定してください。',
    'plan-item-custom.longItemName' => 'このサービスラベルは長すぎます。 許可される最大長は %max% 文字です。',
    'plan-item-custom.longItemDescription' => 'このサービステキストは長すぎます。 許可される最大長は %max% 文字です。',
    'plan-item-custom.longUrl' => 'この住所は長すぎます。 許可される最大長は %max% 文字です。',
    'plan-item-custom.useCustomButton' => 'このサービス用のカスタムボタンを使用',
    'plan-item-custom.useCustomButtonHint' => 'ユーザのホームページとウェブサイトページにカスタムボタンを追加します。',
    'plan-item-custom.openCustomButtonInSameWindow' => 'URL を Plesk で開く',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'URL を Plesk 内のページで開くか、新しいブラウザウィンドウで開くかを指定してください。',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'フレームを使用しない',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Plesk 拡張やアプリケーションにリンクするカスタムボタンを顧客パネルに追加する場合、この拡張/アプリケーションの表示形態（フレーム内に表示、Plesk GUI の一部として表示）を指定できます。',
    'plan-item-custom.includeDomId' => '契約 ID を含める',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'メインドメイン名を含める',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'FTP ユーザ名を含める',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'FTP パスワードを含める',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '顧客 ID を含める',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "顧客の会社名を含める",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "顧客の担当者名を含める",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "顧客のメールアドレスを含める",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'ウェブサイトのプレビュー方法を選択',
    'preview-domain-settings.previewQuick' => 'デフォルトのクイックプレビュー',
    'preview-domain-settings.previewDisabled' => 'クイックプレビューを無効にする',
    'preview-domain-settings.previewQuickDescription' => '推奨されるオプション - 設定なしで機能します。',
    'preview-domain-settings.previewZoneTypeInternal' => 'Plesk ドメイン名のクイックプレビュー',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Plesk で管理しているウェブサイトの中から、プレビューに使用するものを選びます。',
    'preview-domain-settings.previewZoneDomainCreate' => 'この機能を使用するには、1 つ以上のドメインを%%link%%してください。',
    'preview-domain-settings.subscriptionCreateLink' => '作成',
    'preview-domain-settings.previewZoneTypeExternal' => '外部ドメイン名のクイックプレビュー',
    'preview-domain-settings.previewZoneDomainNameDescription' => '外部ドメイン名（DNS ゾーン）を使用します。このオプションを使用する場合、外部ドメインゾーンにタイプ A の DNS レコード（*.<Plesk_IP>.external.dom）を追加してください。 ここで <Plesk_IP> とは Plesk サーバの IP アドレスであり、IPv4 の場合はドット（.）、IPv6 の場合はコロン（:）をダッシュ（-）に置き換えて、「*.192-0-2-12.external.dom」のように入力します。Plesk に複数の IP アドレスが登録されている場合、アドレスごとにレコードを 1 つ追加してください。',
    'preview-domain-settings.sitePreviewProtection' => '認証が必要',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'プレビューに FTP ログイン名とパスワードが必要です。',
    'preview-domain-settings.nginxNotInstalled' => 'nginx ウェブサーバがインストールされていないため、デフォルトクイックプレビューを使用できません。',
    'preview-domain-settings.nginxDisabled' => 'nginx ウェブサーバが無効であるため、デフォルトクイックプレビューを使用できません。',

    'reseller-preferences.settingsSection' => '設定',
    'reseller-preferences.multiLogin' => '複数のセッションを許可',
    'reseller-preferences.language' => 'インターフェース言語',
    'reseller-preferences.interfaceView' => 'インターフェースを選択',
    'reseller-preferences.serviceProviderView' => 'サービスプロバイダビュー',
    'reseller-preferences.serviceProviderViewHint' => 'このビューは、サービスプランを使用して顧客にウェブホスティングサービスを提供および販売するサービス管理者向けです。',
    'reseller-preferences.powerUserView' => 'パワーユーザビュー',
    'reseller-preferences.powerUserViewHint' => 'このビューは、ウェブサイトおよびウェブサイトのファイル、データベース、メールアカウント、ウェブアプリケーション、その他のサービスの管理に最適です。',

    'reseller.hint' => 'ホスティングサービスに新しいリセラーを登録します。',
    'reseller.contactInfoSection' => '連絡先情報',
    'reseller.contactInfoSectionHint' => 'リセラーの連絡先情報を入力します。',
    'reseller.accessToPanelSection' => 'Plesk へのアクセス',
    'reseller.accessToPanelSectionHint' => 'リセラーが Plesk にアクセスして登録サービスを管理するために使用するクレデンシャルです。',
    'reseller.subscription' => '契約',
    'reseller.subscriptionSectionHint' => 'リセラーが契約するサービスプランを選択してください。',
    'reseller.servicePlan' => 'サービスプラン',
    'reseller.none' => 'なし',
    'reseller.customizeSubscription' => 'リセラーの作成後、契約パラメータのカスタマイズに進む（注：これにより、この契約は同期に対してロックされます）',
    'reseller.subscriptionNotSynchronized' => '契約をサービスプランと同期できませんでした。次の契約設定がサービスプランと相反しています：%%problems%%。',

    'security-policy.encryptionSection' => '拡張セキュリティモード',
    'security-policy.encryptionSectionHint' => '拡張セキュリティモードによって、Plesk 内の機密情報の保護を強化することができます。このモードでは、複数のセキュリティメカニズムがユーザに対して透過的に実行されます。Plesk のセキュリティを強化するために、このモードをオンにすることをお勧めします。',
    'security-policy.encryptionEnable' => '拡張セキュリティモード',
    'security-policy.securePassword' => '拡張セキュリティモード',
    'security-policy.strengthSection' => 'パスワード強度',
    'security-policy.strengthSectionHint' => 'Plesk でユーザが設定または変更するほとんどのパスワードは、ここで設定された最低限のパスワード強度の要件を満たしているかどうかが検証されます。強いパスワードは、9 ～ 12 文字以上で、数字、大文字と小文字のアルファベット、および特殊文字が含まれ、辞書に登録された言葉は含まれません。こうしたパスワードは推測しにくい一方、記憶するのも困難です。 <a href="%%link%%" target="_blank">パスワードの強度についてさらに詳しく</a>',
    'security-policy.passwordStrength' => 'パスワードの最低限の長さ',
    'security-policy.secureFtpSection' => 'セキュア FTP',
    'security-policy.ftpOverSsl' => 'FTPS 使用ポリシー',
    'security-policy.ftpOverSslHint' => 'FTPS は、FTP サーバと外部 FTP クライアントの間の SSL/TLS プロトコルを保護するために使用されます。ここで、許可する接続の種類を選択できます。',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS は、FTP サーバと外部 FTP クライアントの間の SSL/TLS プロトコルを保護するために使用されます。ここで、許可する接続の種類を選択できます。選択したオプションは、このサーバのすべての IP アドレスに適用されます。IP アドレスごとにカスタム設定を使用するには、該当するオプションをオンにして［ツールと設定］/>［IP アドレス］で FTPS ポリシーを変更してください。',
    'security-policy.ftpOverSslCustomHint' => 'FTPS は、FTP サーバと外部 FTP クライアントの間の SSL/TLS プロトコルを保護するために使用されます。',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS は、FTP サーバと外部 FTP クライアントの間の SSL/TLS プロトコルを保護するために使用されます。IP アドレスごとに FTPS 設定を調整したい場合、まず［ツールと設定］/>［セキュリティポリシー］/>［セキュア FTP］で［IP アドレスごとのカスタム FTPS 設定を使用］オプションをオンにしてください。',
    'security-policy.ftpOverSslOptionRequired' => 'セキュア FTPS 接続のみを許可する',
    'security-policy.ftpOverSslOptionEnabled' => 'セキュア FTPS 接続と非セキュア FTP 接続の両方を許可する',
    'security-policy.ftpOverSslOptionDisabled' => '非セキュア FTP 接続のみを許可します。FTPS を使用しない',
    'security-policy.ftpOverSslOptionCustom' => 'IP アドレスごとにカスタム FTPS ポリシーを使用する',
    'security-policy.prohibitWebConfigHandlersSection' => 'カスタムハンドラポリシー',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'このオプションを有効化すると、顧客が web.config ファイルを使用してサーバレベルで定義された IIS ハンドラをオーバーライドすることはできなくなります。',
    'security-policy.prohibitWebConfigHandlers' => 'web.config 経由でのハンドラのオーバーライドを禁止する',

    'server-mail-antivirus.used' => '使用アンチウイルスソフト',
    'server-mail-antivirus.policy' => 'サーバ全体の設定を使用',
    'server-mail-antivirus.policyOff' => 'スキャンがオフになりました',
    'server-mail-antivirus.policyAny' => '受信および送信メールをスキャンする',
    'server-mail-antivirus.policyFrom' => '送信メールのみスキャンする',
    'server-mail-antivirus.policyTo' => '受信メールのみスキャンする',
    'server-mail-antivirus.allowPersonalSettings' => '個人設定を許可',
    'server-mail-antivirus.allowPersonalSettingsDesc' => '各メールアドレスでサーバ全体の設定をオーバーライドすることを許可する',
    'server-mail-antivirus.incoming' => '受信メール用',
    'server-mail-antivirus.outgoing' => '送信メール用',
    'server-mail-antivirus.success' => 'アンチウイルス設定が変更されました。',

    'server-mail-black-list.title' => 'ドメインをブラックリストに追加',
    'server-mail-black-list.domainName' => 'ドメイン名',
    'server-mail-black-list.emailAddress' => 'メールアドレス',
    'server-mail-black-list.emailAddressHint' => '非 ASCII 文字を @ の左側のアドレス部分に含めることはできません。アドレスを指定する際は、「*」と「?」をワイルドカードとして使用できます（*@domain.com、user?@*.com など）。ドメイン名の非 ASCII 文字の部分にはワイルドカードを使用しないでください。',
    'server-mail-black-list.action' => '条件と一致するメールに対してどのような操作を行いますか？',
    'server-mail-black-list.actionDelete' => 'サーバから削除する',
    'server-mail-black-list.actionSpam' => 'スパムとしてマークする',
    'server-mail-black-list.success' => 'ドメインがブラックリストに追加されました。',

    'server-mail-white-list.title' => 'ネットワークをホワイトリストに追加',
    'server-mail-white-list.descEmailAddress' => 'ここで指定したメールアドレスは、SpamAssassin でスパムとして認識されなくなります。',
    'server-mail-white-list.descIpAddress' => 'ここで指定した IP エントリは、メールサーバの例外に追加されます。',
    'server-mail-white-list.ipAddress' => 'IP アドレス/マスク',
    'server-mail-white-list.ipAddressHint' => 'IP アドレスにはワイルドカードまたは CIDR マスクを含めることができます。',
    'server-mail-white-list.emailAddress' => 'メールアドレス',
    'server-mail-white-list.emailAddressHint' => '非 ASCII 文字を @ の左側のアドレス部分に含めることはできません。アドレスを指定する際は、「*」と「?」をワイルドカードとして使用できます（*@domain.com、user?@*.com など）。ドメイン名の非 ASCII 文字の部分にはワイルドカードを使用しないでください。',
    'server-mail-white-list.emailAddressOrIp' => 'メールアドレスまたは IP アドレス',
    'server-mail-white-list.wildcardPattern' => 'IP アドレスにワイルドカードを使用できます（例：123.123.*.123）。',
    'server-mail-white-list.cidrPattern' => 'IP アドレスに CIDR マスクを使用できます（例：10.0.0.0/8）。',
    'server-mail-white-list.success' => 'ネットワークがホワイトリストに追加されました。',

    'server-mail-settings.general.title' => '一般オプション',
    'server-mail-settings.general.mailUiEnabled' => 'Plesk のメール管理機能を有効にする',
    'server-mail-settings.general.serverName' => 'インストール済みメールサーバ',
    'server-mail-settings.general.changeServerName' => '他のメールサーバをインストールして使用',
    'server-mail-settings.general.imapServerName' => 'インストール済み IMAP/POP3 サーバ',
    'server-mail-settings.general.changeImapServerName' => '他の IMAP/POP3 サーバをインストールして使用',
    'server-mail-settings.general.changeServerHint' => '%%serverChangeLink%%できます',
    'server-mail-settings.general.maxMessageSize' => '最大メッセージサイズ',
    'server-mail-settings.general.kbytes' => 'KB',
    'server-mail-settings.general.maxConnections' => '最大接続数（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => '最大数のサーバ（IMAP または POP3）が起動しました。',
    'server-mail-settings.general.maxConnectionsHintDovecot' => '一度にログインできるメールユーザの最大数です。',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'IP アドレスあたりの最大接続数',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'IP アドレスあたりの 1 ユーザの最大接続数',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => '同じ IP アドレスから受信できる最大接続数（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）。',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'メールユーザに対して許可される各 IP アドレスからの最大接続数（IMAP、POP3、IMAP over SSL/TLS、または POP3 over SSL/TLS）。',
    'server-mail-settings.general.messageSubmission' => 'ポート 587 で SMTP サービスを有効にする',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'ポート 587 とすべての IP アドレスで SMTP サービスを有効にする',
    'server-mail-settings.general.messageSubmissionBindTo' => 'オン',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'すべての IP アドレス',
    'server-mail-settings.general.outgoingEmailMode' => '送信メールモード',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'ドメイン IP アドレスから送信する',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'ドメイン IP アドレスから送信し、SMTP グリーティングにドメイン名を使用する',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => '指定した IP アドレスから送信する',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'なし',
    'server-mail-settings.general.subaddressing' => 'メールサブアドレスの運用を有効にする',
    'server-mail-settings.general.subaddressingHint' => 'このオプションにより、メールリストで %%verpStyleLink%% 形式のメールアドレスの構成が可能になります',
    'server-mail-settings.general.verpStyleLink' => 'VERP 形式',
    'server-mail-settings.general.mboxQuotaWarning' => 'メールボックスクォータの警告を有効にする',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'メールユーザのメールボックスクォータ使用率が 95% を超えたら通知を送信します',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'デフォルトメールボックスクォータの警告をカスタマイズします',
    'server-mail-settings.general.fixSender' => '送信メールに設定された不適切な送信者を修正します',
    'server-mail-settings.general.fixSenderHint' => 'ドメインから送信されるメールに有効なメールヘッダと送信者エンベロープアドレスを自動設定すると、スパムとして扱われる可能性が低下します',

    'server-mail-settings.autodiscover.title' => 'メール自動検出',
    'server-mail-settings.autodiscover.description' => '%%link%%で仕組みを確認',
    'server-mail-settings.autodiscover.link' => 'ナレッジベース',
    'server-mail-settings.autodiscover.enabled' => 'メール自動検出を有効にする',
    'server-mail-settings.autodiscover.enabledHint' => 'この機能を有効にすると、自動検出をオンにしたすべてのドメインが再構成されます',
    'server-mail-settings.autodiscover.customServer' => 'メール自動検出用にカスタムドメイン名を指定できません',
    'server-mail-settings.autodiscover.customServerHint' => '注：ドメイン名は有効な SSL/TLS 証明書で保護されている必要があります。',
    'server-mail-settings.autodiscover.reconfigureDns' => '自動検出 DNS レコードを再構成する',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'この機能を有効にすると、自動検出をオンにしたすべてのドメイン自動検出 DNS レコードが再構成されます',

    'server-mail-settings.relay.title' => 'リレーオプション',
    'server-mail-settings.relay.type' => "メールリレー",
    'server-mail-settings.relay.open' => "開く",
    'server-mail-settings.relay.openSpamWarning' => "メールリレーをオープンにすると、メールサーバがスパムに対して無防備になります。",
    'server-mail-settings.relay.openSpamChange' => "この設定を使用するのは、メールサーバを一時的にテストする場合や、インターネットに接続できない内部ネットワーク内に Plesk サーバがある場合のみとしてください。",
    'server-mail-settings.relay.closed' => "クローズ",
    'server-mail-settings.relay.auth' => "認証が必要",
    'server-mail-settings.relay.notSupported' => "メールサーバが未対応",
    'server-mail-settings.relay.change' => 'リレーのクローズ中に Plesk から通知を送信できるようにするには、%%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'SMTP 設定を変更してください',
    'server-mail-settings.relay.pop3' => "POP3（POP before SMTP）",
    'server-mail-settings.relay.lockTime' => "ロック時間",
    'server-mail-settings.relay.min' => "分",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => '次のネットワークにはリレー制限を適用しない',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP アドレス/マスク",

    'server-mail-settings.outgoing.title' => '送信メールメッセージ数の上限',
    'server-mail-settings.outgoing.description' => '以下の上限はデフォルトです。サービスプランや契約ごとに上書きできます。この上限はサーバ全体で機能するのではなく、カスタムの上限が指定されていないプランと契約のテンプレートとなります。送信メールメッセージ数の上限をオンにすると、メールサーバのパフォーマンスに影響を与える可能性があります。%%link%%',
    'server-mail-settings.outgoing.learnMore' => '送信メールの制限についてさらに詳しく',
    'server-mail-settings.outgoing.enabled' => '送信メールメッセージ数の上限をオンにする',
    'server-mail-settings.outgoing.countRecipients' => 'メッセージ数ではなく受信者数をカウントする',
    'server-mail-settings.outgoing.countRecipientsHint' => '送信メールの制限および統計のカウントにあたって、メッセージ数ではなく受信者数をカウントするモードを有効にします。このモードでは、たとえば 1 件のメッセージを 10 人の受信者に送信した場合、10 件のメッセージとしてカウントされます。',
    'server-mail-settings.outgoing.mailboxLimit' => 'メールボックスからの送信メッセージ数のデフォルト上限（1 時間あたり）',
    'server-mail-settings.outgoing.domainLimit' => 'ドメインからの送信メッセージ数のデフォルト上限（1 時間あたり）',
    'server-mail-settings.outgoing.subscriptionLimit' => '契約からの送信メッセージ数のデフォルト上限（1 時間あたり）',
    'server-mail-settings.outgoing.unlimited' => '無制限',
    'server-mail-settings.outgoing.sendmail' => 'ユーザおよびスクリプトによる Sendmail の使用を許可する',
    'server-mail-settings.outgoing.sendmailHint' => 'オンにすると、スクリプトおよびユーザは、たとえメールボックスおよびドメインの上限を超過していても、（契約のシステムユーザの代理として）Sendmail を使用してメールメッセージを送信することができます。Sendmail 経由で送信できるメッセージの最大数は、契約全体の上限によって定義されます。この設定は、サーバ全体での Sendmail の使用を許可するものではなく、サービスプランおよび契約のデフォルト設定として機能します。',
    'server-mail-settings.outgoing.reportPeriod' => 'レポート対象とする統計情報の取得期間',
    'server-mail-settings.outgoing.reportPeriodHint' => '指定期間内にメールの送信試行数が上限を超えると、レポートが作成され、［ホーム］ページにアラートが表示されます。',
    'server-mail-settings.outgoing.notificationPeriod' => 'メール通知の送信頻度',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'この通知は、指定期間内に送信メール数の上限を超えた送信試行について統計情報を提供します。',
    'server-mail-settings.outgoing.periodP1D' => '1 日',
    'server-mail-settings.outgoing.periodP1W' => '1 週間',
    'server-mail-settings.outgoing.periodP2W' => '2 週間',
    'server-mail-settings.outgoing.periodP1M' => '1 ヶ月',
    'server-mail-settings.outgoing.periodPT15M' => '15 分',
    'server-mail-settings.outgoing.periodPT1H' => '1 時間',
    'server-mail-settings.outgoing.periodPT6H' => '6 時間',
    'server-mail-settings.outgoing.periodPT12H' => '12 時間',
    'server-mail-settings.outgoing.whiteListNotEmpty' => '送信メールの上限は、メールサーバのホワイトリストに IP アドレスが含まれているメール送信者に対しては適用されません。例えば、ホワイトリストにローカルホスト（127.0.0.0 / 8, ::1 / 128）が含まれる場合、ローカルサーバからのすべてのメールが上限を問わず正常に送信されます。メール送信者は、ローカル IP アドレス（ローカルサーバ上でホストされるウェブサイトおよびカスタムスクリプト）または外部 IP アドレス（自分のコンピュータまたはモバイルデバイスにインストールしたメールクライアントからメールを送信する顧客）のいずれかを使用できます。すべてのメール送信者（ローカルと外部の両方）に対して上限を機能させるには、ホワイトリストからすべての IP アドレスとネットワークを削除してください。ホワイトリストからローカルホスト（127.0.0.0 / 8, ::1 / 128）を削除すると、このサーバからメールを送信するウェブサイトやスクリプトの動作に支障をきたす可能性があります。送信メールの上限について詳しくは、管理者ガイドの「アウトバウンドパムから防御する」を参照してください。',
    'server-mail-settings.outgoing.relayIsOpen' => 'メールリレーがオープンです。送信メールの上限は適用されません。',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'ドメインからの送信メッセージ数の上限（%%value%%）を契約の最大数（%%highLevelLimitValue%%）より大きくすることはできません。',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'メールアドレスからの送信メッセージ数の上限（%%value%%）をドメインの最大数（%%highLevelLimitValue%%）より大きくすることはできません。',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'メールアドレスからの送信メッセージ数の上限（%%value%%）を契約の最大数（%%highLevelLimitValue%%）より大きくすることはできません。',

    'server-mail-settings.mailman.title' => 'Mailman 設定',
    'server-mail-settings.mailman.secureLinks' => 'メールリストでセキュアリンクを使用',
    'server-mail-settings.mailman.secureLinksHint' => 'メーリングリストでセキュア（HTTPS）リンクの生成を有効/無効にします。',
    'server-mail-settings.mailman.noLocalhost' => 'メーリングリストを使用するためには、メールサーバのホワイトリストにローカルホスト（127.0.0.0/8, ::1/128）の登録が必要です。ところが、送信メール制御を使用する場合、ホワイトリストにローカルホストを追加してはいけません。回避策として、送信メール制御をアクティブにした場合には、メーリングリストではなくメールボックスでメール転送を使用することができます。',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'メーリングリストを使用するには、メールサーバのホワイトリストにローカルホストを含める必要があります。ところが、送信メール制御を使用する場合、ホワイトリストにローカルホストを追加してはいけません。回避策として、送信メール制御をアクティブにした場合には、メーリングリストではなくメールボックスでメール転送を使用することができます。現在、ホワイトリストに IPv4 ローカルホストアドレス（127.0.0.0/8）の登録がないため、送信メール制御が IPv4 アドレスに対して機能しています。',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'メーリングリストを使用するには、メールサーバのホワイトリストにローカルホストを含める必要があります。ところが、送信メール制御を使用する場合、ホワイトリストにローカルホストを追加してはいけません。回避策として、送信メール制御をアクティブにした場合には、メーリングリストではなくメールボックスでメール転送を使用することができます。現在、ホワイトリストに IPv6 ローカルホストアドレス（::1/128）の登録がないため、送信メール制御が IPv6 アドレスに対して機能しています。',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => '受信メールのチェック用に DMARC を有効にする',
    'server-mail-settings.spam-filter.dmarcHint' => 'このオプションは、受信メールに対して DKIM と SPF がオンになっている場合に使用できます。',
    'server-mail-settings.spam-filter.dkim' => 'DKIM スパム防御',
    'server-mail-settings.spam-filter.singOutgoing' => '送信メールの電子署名を許可する',
    'server-mail-settings.spam-filter.verifyIncoming' => '受信メールを検証する',
    'server-mail-settings.spam-filter.verifyIncomingHint' => '受信メールに対して DMARC がオンになっている場合、このオプションはオフにできません。',
    'server-mail-settings.spam-filter.spf' => 'SPF スパム防御',
    'server-mail-settings.spam-filter.spfEnabled' => 'SPF スパム防御を有効化して受信メールをチェック',
    'server-mail-settings.spam-filter.spfEnabledHint' => '受信メールに対して DMARC がオンになっている場合、このオプションはオフにできません。',
    'server-mail-settings.spam-filter.ignoreErrors' => 'DNS ルックアップで問題がある場合に SPF チェックを続ける',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'SPF は、まず DNS ルックアップを実行します。DNS ルックアップが失敗した後でもチェックを続けるには、このオプションをオンにしてください。現在のチェックモードに影響を与えない場合、このオプションはクリアされます。',
    'server-mail-settings.spam-filter.behavior' => 'SPF チェックモード',
    'server-mail-settings.spam-filter.behaviorHint' => '次に、SPF はローカルルールおよび guess ルールを適用します。選択したチェックモードおよびチェック結果に応じて、メッセージを拒否することができます。',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Received-SPF ヘッダの作成のみ。ブロックはしない',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'DNS ルックアップで問題が発生した場合、一時エラー通知を使用',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'SPF が "fail" と判断したメールを破棄する（拒否）',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'SPF が "softfail" と判断したメールを破棄する',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'SPF が "neutral" と判断したメールを破棄する',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'SPF が "pass" と判断しなかったメールを破棄する',
    'server-mail-settings.spam-filter.localRules' => 'SPF ローカルルール',
    'server-mail-settings.spam-filter.guessRules' => 'SPF guess ルール',
    'server-mail-settings.spam-filter.explanationText' => 'SPF 解釈テキスト',
    'server-mail-settings.spam-filter.rbl' => "DNS ブラックホールリストに基づくスパム防御",
    'server-mail-settings.spam-filter.rblEnabled' => "DNS ブラックホールリストに基づくスパム防御をオンにする",
    'server-mail-settings.spam-filter.rblServer' => "DNSBL サービス用の DNS ゾーン",
    'server-mail-settings.spam-filter.rblServerHint' => "複数のエントリを入力するときはセミコロンで区切ってください（例：「zen.spamhaus.org;dnsbl.example.net」）",

    'server-mail-settings.auto-reply-headers.title' => '追加の自動返信ヘッダ',
    'server-mail-settings.auto-reply-headers.description' => 'Plesk サーバから受信するすべての自動返信メッセージ用に追加ヘッダを設定します。',
    'server-mail-settings.auto-reply-headers.extra' => '追加ヘッダ',

    'server-mail-settings.pop3-names.title' => "POP3/IMAP メールアカウント名",
    'server-mail-settings.pop3-names.disabled' => "POP3/IMAP メールアカウントのフルネームのみが使用できます",
    'server-mail-settings.pop3-names.enabled' => "POP3/IMAP メールアカウントのショートネーム（webmaster）とフルネーム（webmaster@domain.com）を使用できます。",

    'server-mail-settings.success' => 'メールサーバ設定を変更しました',

    'server-mail-spam-filter.general' => '全般',
    'server-mail-spam-filter.isEnabled' => 'サーバ全体に対する SpamAssassin スパムフィルタをオンにする',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin がインストールされていません.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'サーバ全体に対するグレイリストスパム防御をオンにする',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'スパムフィルタにユーザごとの設定を適用する',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "スパムフィルタはオフになっています。このメールサーバはメールボックスレベルでのスパムフィルタ設定をサポートしません。",
    'server-mail-spam-filter.settings' => 'SpamAssassin 設定',
    'server-mail-spam-filter.maxChildrenTitle' => '最大プロセス数',
    'server-mail-spam-filter.maxChildrenDescription' => '実行するワーカ spamd プロセスの最大数.',
    'server-mail-spam-filter.requiredHitsTitle' => '必要なスコア',
    'server-mail-spam-filter.requiredHitsDescription' => 'メッセージをスパムとして判断するスコア値.',
    'server-mail-spam-filter.maxMailLimit' => 'メールサイズがこの値を超える場合はフィルタリングしない',
    'server-mail-spam-filter.maxMailLimitText' => 'サイズ制限',
    'server-mail-spam-filter.kbytes' => "KB",
    'server-mail-spam-filter.maxThreadsLimit' => 'スパムフィルタで作成できるスレッド数',
    'server-mail-spam-filter.tagTitle' => 'スパムのタグ',
    'server-mail-spam-filter.tagDescription' => 'スパムと判断されたメッセージの件名の先頭にこのテキストが追加されます。',
    'server-mail-spam-filter.byTag' => '使用するタグ',
    'server-mail-spam-filter.alarmMessage' => 'スパムが発見されたときのアラートテキスト',
    'server-mail-spam-filter.languages' => '信頼できる言語',
    'server-mail-spam-filter.locales' => '信頼できるロケール',
    'server-mail-spam-filter.success' => 'スパムフィルタ設定が変更されました',
    'server-mail-spam-filter.personalSettingsWarning' => '個人用スパムフィルタ設定を適用する権限は、サーバ管理者によってオフになっています。以下に指定されているスパムフィルタ設定は適用されません。',

    'service-plan.admin-plan.subscription_section' => '共通',
    'service-plan.admin-plan.tools_section' => 'ツールとリソース',
    'service-plan.admin-plan.apps_section' => 'アプリケーションとデータベース',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk の外観',
    'service-plan.admin-plan.statistics_section' => '統計',
    'service-plan.admin-plan.general_section' => '全般',
    'service-plan.admin-plan.mail_section' => 'メール',
    'service-plan.admin-plan.server_section' => 'サーバ',
    'service-plan.admin-plan.modules_section' => '拡張',
    'service-plan.admin-plan.troubleshooting_section' => 'サポートとトラブルシューティング',
    'service-plan.admin-plan.simplePanel' => '制限モード',
    'service-plan.admin-plan.enabled' => '制限モードを有効にする',
    'service-plan.admin-plan.enabledDescription' => '管理者が Plesk で実行できるアクションを制限するには、このオプションを選択します。',
    'service-plan.admin-plan.aliasEnabledDescription' => '追加管理者が Plesk で実行できるアクションを制限するには、このオプションを選択します。',

    'service-plan.applications-subscription.useFilterLabel' => '選択したアプリケーションのみを提供する',
    'service-plan.applications-subscription.useFilterDescription' => '契約者に提供するアプリケーションを選択するには、このオプションを使用します。',
    'service-plan.applications-subscription.applications' => 'アプリケーション',
    'service-plan.applications-subscription.isCommercial' => 'このアプリケーションは有償であり、ライセンスキーの購入が必要です。',

    'service-plan.applications.useFilterLabel' => '選択したアプリケーションのみを提供する',
    'service-plan.applications.useFilterDescription' => '契約者に提供するアプリケーションを選択するには、このオプションを使用します。',
    'service-plan.applications.applications' => 'アプリケーション',
    'service-plan.applications.isCommercial' => 'このアプリケーションは有償であり、ライセンスキーの購入が必要です。',

    'service-plan.dns.dnsZoneType' => 'ドメイン DNS ゾーン',
    'service-plan.dns.dnsZoneTypeMaster' => 'プライマリ',
    'service-plan.dns.dnsZoneTypeSlave' => 'セカンダリ',

    'service-plan.extras.groupOtherServices' => 'その他のサービス',
    'service-plan.extras.none' => 'なし',

    'service-plan.hosting.enablePhysicalHosting' => 'ホスティングを有効にする',
    'service-plan.hosting.sectionCoreHosting' => '一般プロパティ',
    'service-plan.hosting.sectionScripting' => 'スクリプティング',
    'service-plan.hosting.defaultDatabaseServer' => 'デフォルトのデータベースサーバ',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '詳細',
    'service-plan.hosting.phpSettingsHelpLink' => '最も適切な PHP 設定を選択する方法について',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'この契約が一時停止されたときのウェブサイトのステータス',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '一時停止中の契約に含まれるウェブサイトのステータス',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'ここで選択したステータスは、契約が一時停止になったときに（期限切れ、支払済み期間の満了時など）、この契約に含まれるすべてのウェブサイトに適用されます。',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'ここで選択したステータスは、契約が一時停止になったときに（期限切れ、支払済み期間の満了など）、ウェブサイトに適用されます。',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '無効',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'ウェブサイト訪問者は、ウェブサイトのデフォルトページにリダイレクトされます。',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '一時停止',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'ウェブサイト訪問者は、検索エンジンフレンドリーな HTTP コード 503 でカスタムエラードキュメントページにリダイレクトされます。',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'アクティブ',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'ウェブサイトはインターネットアクセス可能なまま維持されます。',

    'service-plan.ip.sharedIpAddresses' => '共用 IP アドレスの割り当て',
    'service-plan.ip.allocateExclusiveIp' => '専用 IP アドレスを割り当てる',
    'service-plan.ip.allocateExclusiveIpV4' => '専用 IPv4 アドレスを割り当てる',
    'service-plan.ip.allocateExclusiveIpV6' => '専用 IPv6 アドレスを割り当てる',

    'service-plan.mail.mailService' => 'メールサービス',
    'service-plan.mail.mailServiceDisabled' => '無効',
    'service-plan.mail.mailServiceDisabledIncoming' => '受信メールに対して無効',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk はドメインでいかなるメールサービスも提供しません。',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'ドメインでは、Sendmail を使用したメールの送信しかできません。',
    'service-plan.mail.mailServiceEnabled' => '有効',
    'service-plan.mail.mailServiceEnabledHint' => 'ドメインでメールを受送信できます。',
    'service-plan.mail.mailServiceNotConfigured' => '未構成',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk はドメインでいかなるメールサービスも提供しません。',
    'service-plan.mail.webMail' => 'ウェブメール',
    'service-plan.mail.mailingLists' => 'メーリングリストをオンにする',
    'service-plan.mail.mailToNonExistentUser' => '存在しないユーザ宛てのメールに関するポリシー',
    'service-plan.mail.mailToNonExistentUserBounce' => 'メッセージ付きでバウンス',
    'service-plan.mail.mailToNonExistentUserRedirect' => '指定アドレスに転送',
    'service-plan.mail.mailToNonExistentUserReject' => '拒否',
    'service-plan.mail.mailAutodiscovery' => 'メール自動検出を有効にする',
    'service-plan.mail.mailAutodiscoveryDescription' => '仕組みについては<a href="%%link%%" target="_blank">ナレッジベース</a>でご確認ください',
    'service-plan.mail.bounceMessage' => 'このアドレスではメールが受信されません。',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => '指定 IP アドレスの外部メールサーバへリダイレクト',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 無効',

    'service-plan.misc.retainEnabled' => 'ウェブおよびトラフィック統計の保持期間',
    'service-plan.misc.logRotation' => 'ログローテーション',
    'service-plan.misc.logRotationCondition' => 'ログローテーション条件',
    'service-plan.misc.logRotationBySize' => 'サイズ単位',
    'service-plan.misc.logRotationByTime' => '時間単位',
    'service-plan.misc.logRotationDaily' => '毎日',
    'service-plan.misc.logRotationWeekly' => '毎週',
    'service-plan.misc.logRotationMonthly' => '毎月',
    'service-plan.misc.logRotationSizeDescription' => 'サイズは %%min%%～%%max%% kB にする必要があります。',
    'service-plan.misc.maximumNumberOfFiles' => '最大ログファイル数',
    'service-plan.misc.compress' => 'ログファイルを圧縮',
    'service-plan.misc.sendLogToEmail' => 'Plesk がウェブ/FTP サーバのログファイルからデータを取得してからログをメール送信する宛先',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'ヶ月',
    'service-plan.misc.logRotationPeriodGreater' => 'ログローテーション期間がサーバ全体の上限である %%max%% を超えてはいけません。',

    'service-plan.performance.iisAppPoolAddonsHint' => 'オフにすると、契約のすべてのウェブサイトが、この契約専用である同じ IIS アプリケーションプールを使用します。',

    'service-plan.permissions-subscription.permissionsTabDescription' => '契約で提供するサービスと権限を選択します。',
    'service-plan.permissions-subscription.showMorePermissions' => '表示するパーミッションを増やす',
    'service-plan.permissions-subscription.hideMorePermissions' => '表示するパーミッションを減らす',
    'service-plan.permissions-subscription.noShellManagement' => '許可しない',
    'service-plan.permissions-subscription.systemAccessLabel' => 'SSH 経由でのサーバアクセス管理',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '顧客がシステムユーザに対して SSH をオンに切り替えることができます。「契約のシステムユーザとしてサーバシェルへ SSH アクセス」をプリセットにします。',

    'service-plan.permissions.permissionsTabDescription' => 'プランで提供するサービスとパーミッションを選択します。',
    'service-plan.permissions.permissionsAddonTabDescription' => 'このアドオンプランによって契約に追加されるサービスと権限を選択してください。このアドオンで選択されていないパーミッションによって契約のパラメータが変更されることはありません。',
    'service-plan.permissions.permissionsBehaviorDescription' => 'パーミッションにより、顧客は契約の特定の設定を変更することができます。契約が作成されると、Plesk により、顧客が変更できる設定にプランのプリセット値が適用されます。その後でプランを更新したりアドオンプランを適用したりしても、顧客が行った変更は上書きされません。',
    'service-plan.permissions.showMorePermissions' => '表示するパーミッションを増やす',
    'service-plan.permissions.hideMorePermissions' => '表示するパーミッションを減らす',
    'service-plan.permissions.noShellManagement' => '許可しない',
    'service-plan.permissions.systemAccessLabel' => 'SSH 経由でのサーバアクセス管理',
    'service-plan.permissions.systemAccessLabel_hint' => 'ホスティングパラメータ「契約のシステムユーザとしてサーバシェルへ SSH アクセス」をプリセットにします。',

    'service-plan.resources-subscription.overusePolicy' => '利用超過ポリシー',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '利用超過を許可しない',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'リソースの利用超過を許可しない。リソース使用量が制限値を超えると、契約は自動的に一時停止されます。',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'ディスク容量とトラフィックの利用超過を許可する',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'ディスク容量とトラフィックの利用超過を許可します。その他のリソースの利用超過を許可しません。',
    'service-plan.resources-subscription.overusePolicyAllowed' => '利用超過を許可する（推奨しません）',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '契約者に対し、契約で最初に提供されるリソースより多くのリソースを使用することを許可します。',
    'service-plan.resources-subscription.overuseNotify' => '利用超過時にメール通知を受け取る',
    'service-plan.resources-subscription.oversellPolicy' => '販売超過ポリシー',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '販売超過を許可する',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '販売超過によって、リセラーはプランで割り当てられた量よりも多くのリソースを販売できます。 販売超過が許可されると、リセラーは初期リソース割り当ての代わりに実際のリソース使用量で管理されます。',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '販売超過を許可しない',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '販売超過が許可されていない場合、リセラーは、実際に使用したリソースの量に関係なく、最初に契約で割り当てられた量のリソースしか販売できません。',
    'service-plan.resources-subscription.mainGroupTitle' => '契約で提供するリソースに使用量上限を定義',
    'service-plan.resources-subscription.additionalGroupTitle' => '表示するリソースを増やす',
    'service-plan.resources-subscription.hideMoreResources' => '表示するリソースを減らす',

    'service-plan.resources.overusePolicy' => '利用超過ポリシー',
    'service-plan.resources.overusePolicyNotAllowed' => '利用超過を許可しない',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'リソースの利用超過を許可しない。リソース使用量が制限値を超えると、契約は自動的に一時停止されます。',
    'service-plan.resources.overusePolicySoftAllowed' => 'ディスク容量とトラフィックの利用超過を許可する',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'ディスク容量とトラフィックの利用超過を許可します。その他のリソースの利用超過を許可しません。',
    'service-plan.resources.overusePolicyAllowed' => '利用超過を許可する（推奨しません）',
    'service-plan.resources.overusePolicyAllowedHint' => 'プランで当初提供されていたリソース以外のリソースも顧客が使用できます。',
    'service-plan.resources.overuseNotify' => '利用超過時にメール通知を受け取る',
    'service-plan.resources.oversellPolicy' => '販売超過ポリシー',
    'service-plan.resources.oversellPolicyAllowed' => '販売超過を許可する',
    'service-plan.resources.oversellPolicyAllowedHint' => '販売超過によって、リセラーはプランで割り当てられた量よりも多くのリソースを販売できます。 販売超過が許可されると、リセラーは初期リソース割り当ての代わりに実際のリソース使用量で管理されます。',
    'service-plan.resources.oversellPolicyNotAllowed' => '販売超過を許可しない',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '販売超過を許可しない場合、リセラーは実際のリソース使用量に関係なく、最初にプランで割り当てられた量のリソースしか販売できません。',
    'service-plan.resources.mainGroupTitle' => 'プランで提供するリソースを定義します。',
    'service-plan.resources.additionalGroupTitle' => '表示するリソースを増やす',
    'service-plan.resources.hideMoreResources' => '表示するリソースを減らす',
    'service-plan.resources.allowSitebuilderUpsell' => '顧客に対して Presence Builder のトライアルウェブサイトの作成を許可します。',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'この設定を使用すると、顧客はサービスプランに決められた数より多くの Presence Builder ウェブサイトを作成できます。これらのウェブサイトを公開するためには、ウェブサイトを購入する必要があります。',

    'service-plan.servicePlanName' => 'サービスプラン名',
    'service-plan.resellerPlanName' => 'リセラープラン名',
    'service-plan.addonPlanName' => 'アドオンプラン名',
    'service-plan.adminPlanPermissionsTab' => '管理ツール',
    'service-plan.adminPlanPermissionsTabDescription' => '制限モードが有効な場合に管理者が使用できる機能を選択します。',
    'service-plan.hostingPermissionsTab' => 'ホスティングツール',
    'service-plan.hostingPermissionsTabDescription' => '制限モードが有効な場合に管理者がパワーユーザービューで使用できるウェブホスティングツールと設定を選択します。',
    'service-plan.resourcesTab' => 'リソース',
    'service-plan.resourcesTabDescription' => 'プランで提供するリソースと、リソースの使用に関するポリシーを定義してください。',
    'service-plan.subscriptionResourcesTabDescription' => '契約で提供されているリソースと、リソース使用量のポリシーを定義します。',
    'service-plan.hostingTab' => 'ホスティングパラメータ',
    'service-plan.hostingTabDescription' => 'プランで提供されるホスティングサービスのパラメータを指定してください。アドオンプランに指定されているホスティング設定は、サービスプランまたはアドオンプランによって「ホスティング設定管理」パーミッションが付与されている契約には適用されません。',
    'service-plan.secureSettingsDescription' => '提供されているホスティングのセキュリティを強化するには、%%link%%してください。 パーミッションが付与されていれば、契約者がこれらの設定を変更できます。%%helpLink%%',
    'service-plan.secureSettingsLink' => 'セキュア設定プリセットを適用',
    'service-plan.secureSettingsHelpLink' => 'セキュアホスティング設定について',
    'service-plan.mailTab' => 'メール',
    'service-plan.mailTabDescription' => 'プランで提供するメールサービスのパラメータを指定してください。',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'プランで提供する DNS サービスのパラメータを指定してください。',
    'service-plan.performanceTab' => 'パフォーマンス',
    'service-plan.performanceTabDescription' => 'プランで提供する全サービスのパフォーマンスに影響を与えるシステムパラメータを指定します。',
    'service-plan.permissionsTab' => 'パーミッション',
    'service-plan.miscTab' => 'ログと統計',
    'service-plan.miscTabDescription' => 'プランの契約の統計とログを保管する方法を指定します。これらの設定は契約間で同期されません。',
    'service-plan.miscTabAdminPlanDescription' => '契約の統計とログを保存する方法を指定します。',
    'service-plan.extrasTab' => '追加サービス',
    'service-plan.extrasTabDescription' => 'ウェブホスティング、DNS、メールサービスに加え、プランに追加で含めるサービスを選択します。',
    'service-plan.ipTab' => 'IP アドレス',
    'service-plan.ipTabDescription' => 'プランで提供する IP リソースのパラメータを定義します。',
    'service-plan.applicationsTab' => 'アプリケーション',
    'service-plan.applicationsTabDescription' => 'プランで提供するアプリケーションを選択してください。アプリケーションカタログで、すべてのアプリケーションに加えてサーバにアップロードしたアプリケーションも提供することも、提供するアプリケーションを手動で選択することもできます。すべてのアプリケーションを提供する場合、このタブでの操作は不要です。［パーミッション］タブで［アプリケーションカタログへのアクセス］オプションを選択してください。アプリケーションを手動で選択する場合、このタブで選択可能です。',
    'service-plan.applicationsTabDescription-addon' => 'アドオンで提供するアプリケーションを選択してください。',
    'service-plan.applicationsTabDescription-subscription' => '契約で提供するアプリケーションを選択してください。アプリケーションカタログで、すべてのアプリケーションに加えてサーバにアップロードしたアプリケーションも提供することも、提供するアプリケーションを手動で選択することもできます。すべてのアプリケーションを提供する場合、このタブでの操作は不要です。［パーミッション］タブで［アプリケーションカタログへのアクセス］オプションを選択してください。アプリケーションを手動で選択する場合、このタブで選択可能です。',
    'service-plan.planSyncSubsriptionWarning' => '一部の契約がプランと同期されていません。契約リストで［非同期］のマークが付いています。 同期を再試行するには、契約の概要ページで［同期］ボタンをクリックしてください。',
    'service-plan.planSyncResellerWarning' => '一部のリセラーがプランと同期されていません。 リセラーリストで［非同期］のマークが付いています。 同期を再試行するには、リセラーの概要ページで［同期］ボタンをクリックしてください。',
    'service-plan.planSyncAdminWarning' => '契約に変更を適用できません。これらの変更の影響を受けるサービスまたはリソースの一部が Plesk で提供されていません。理由：%%reason%%',
    'service-plan.duplicateName' => 'この名前のプランは既に存在します。',
    'service-plan.phpSettingsTab' => 'PHP 設定',
    'service-plan.phpHandlerNotFound' => 'プランの PHP バージョンに関する情報を取得できません。再インストールするか、サービスプラン用に別の PHP バージョンを選択してください。',
    'service-plan.phpHandlerNotRegistered' => "PHP バージョン %%fullVersion%% はインストールされていません。このサービスプランを使用するドメインの PHP スクリプティングは使用できません。PHP <nobr>バージョン %%fullVersion%%</nobr> をインストールするか、サービスプラン用に別の PHP バージョンを選択してください。",

    'service-plan.phpSettingsTabDescription' => '契約ごとに PHP 設定を指定します。この設定はサーバ全体の php.ini ファイルに定義された設定より優先されます。この機能は、顧客の PHP スクリプトによるシステムリソース消費量を制限したい場合などに便利です。（許可される場合）顧客は、独自のドメイン単位の構成を使用して、この PHP 構成をオーバーライドすることができます。パラメータをデフォルト値に設定すると、PHP はサーバ全体の PHP 構成にあるパラメータ値を使用します。サポートされるプレースホルダは、{DOCROOT} と {WEBSPACEROOT}（それぞれ、ドメインのドキュメントルートディレクトリ、カスタム PHP 構成を使用するウェブスペースのルートディレクトリ）、{TMP}（一時ファイルを保存するディレクトリ）です。',
    'service-plan.phpSettingsTabDescriptionAddon' => 'ここでは、メインサービスプランに定義された設定より優先される契約単位の PHP 設定を指定できます。これは、メインサービスプランに設定された PHP 制限を削除したい場合などに便利です。パラメータをデフォルト値に設定すると、PHP はサービスプランの PHP 構成にあるパラメータの値を使用します。サポートされるプレースホルダは、{DOCROOT} と {WEBSPACEROOT}（それぞれ、ドメインのドキュメントルートディレクトリ、カスタム PHP 構成を使用するウェブスペースのルートディレクトリ）、{TMP}（一時ファイルを保存するディレクトリ）です。',
    'service-plan.phpSettingsPhpVersion' => '現在の PHP バージョンは %%version%% です。',
    'service-plan.phpSettingsTabAdminPlanDescription' => '契約ごとに PHP 設定を指定します。この設定はサーバ全体の php.ini ファイルに定義された設定より優先されます。パラメータをデフォルト値に設定すると、PHP はサーバ全体の PHP 構成に含まれるパラメータ値を使用します。',
    'service-plan.webServerSettingsTab' => 'ウェブサーバ',
    'service-plan.webServerSettingsTabDescription' => 'このサービスプランの Apache ウェブサーバ設定を指定します。Apache のフロントエンドサーバとして nginx を使用している場合、このページで nginx 設定も指定することができます。新規作成されたすべてのドメインに、指定した設定が適用されます。ただし、これらの設定を変更すると、既存のドメインに変更は適用されません。',
    'service-plan.servicesTab' => 'サービス',
    'service-plan.servicesTabDescription' => 'サービスプランに割り当てるサービスを指定します。',
    'service-plan.servicePropertiesTab' => '%%serviceName%% プロパティ',
    'service-plan.servicePropertiesTabDescription' => 'サービスプランに割り当てた %%serviceName%% サービスのプロパティを指定します。',
    'service-plan.longTaskWarning' => 'このプランには %%subscriptionsCount%% 件の契約があります。同期タスクは時間がかかるため、バックグラウンドで実行されます。',
    'service-plan.hostingParametersTab' => 'ホスティングパラメータ',
    'service-plan.adminInfoSection' => '管理者用の情報',
    'service-plan.descriptionInPanel' => '説明',
    'service-plan.longDescription' => '入力した説明が長すぎます。',
    'service-plan.conflictPermissions' => 'リセラープランと競合するため、パーミッション %%permissions%% を付与できません。',

    'services.change-startup-type.startupTypeLabel' => '起動タイプ',
    'services.change-startup-type.autoStartupTypeLabel' => '自動',
    'services.change-startup-type.manualStartupTypeLabel' => '手動',
    'services.change-startup-type.disabledStartupTypeLabel' => 'オフにする',
    'services.change-startup-type.autoActionError' => '起動タイプを「自動」に設定できません。%%error%%',
    'services.change-startup-type.manualActionError' => '起動タイプを「手動」に設定できません。%%error%%',
    'services.change-startup-type.disableActionError' => '起動タイプを「無効」に設定できません。%%error%%',

    'sessions.settings.restoreDefaultButton' => 'デフォルトにリセット',
    'sessions.settings.restoreDefaultButtonDescription' => 'セッションパラメータをデフォルト値に戻します。',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'セッションパラメータにはデフォルト値があります。',
    'sessions.settings.idleTime' => 'セッションアイドル時間',
    'sessions.settings.disableCheckSessionIp' => '1 セッション中の IP アドレス変更を許可する',
    'sessions.settings.minuteShortTitle' => '分',

    'settings-ui.controls.title' => 'コントロール',

    'settings-ui.interface-views.description' => "製品 UI ビューにはいくつかの種類があります。使用するビューに応じて、機能や設定が別の場所にある場合や、有効/無効の設定が違う場合があります。これらのビューはそれぞれ異なるタイプのユーザに適しています。",
    'settings-ui.interface-views.panelSimpleLink' => '［ツールと設定］/>［制限モードの設定］',
    'settings-ui.interface-views.useCustomView' => '制限モードを有効にする',
    'settings-ui.interface-views.useCustomViewHint' => '管理者が Plesk で実行できるアクションを制限するには、このオプションを選択します。アクションを使用可能にするかどうかは、%%customViewSettingsLink%%で変更します。',
    'settings-ui.interface-views.powerUserViewHint' => 'このビューは、ウェブサイトおよびウェブサイトのファイル、データベース、メールアカウント、ウェブアプリケーション、その他のサービスの管理に最適です。',
    'settings-ui.interface-views.selectUiModeTitle' => "インターフェースを選択",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "パワーユーザビュー（開発者とウェブエージェンシー向け）",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "サービスプロバイダビュー（ウェブホスティングプロバイダ向け）",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'このビューは、サービスプランを使用して顧客にウェブホスティングサービスを提供および販売するサービス管理者向けです。',
    'settings-ui.interface-views.visibilityMailBounce' => 'バウンスコントロールを非表示にする',
    'settings-ui.interface-views.visibilityMailBounceHint' => '存在しないメールアドレスに送信されたメールの処理方法をセットアップするためのボタンを非表示にする',

    'settings-ui.branding.description' => 'ブラウザのタイトルバーでのページの表示を変更したり、左上隅に表示される Plesk ロゴを変えることで、Plesk インターフェースをブランディングします。',
    'settings-ui.branding.buttonDefault' => 'デフォルトロゴ',
    'settings-ui.branding.sectionTitle' => 'カスタムタイトル',
    'settings-ui.branding.enableCustomTitle' => 'Plesk ページのカスタムタイトルを有効にする',
    'settings-ui.branding.customTitle' => 'タイトルテキスト',
    'settings-ui.branding.sectionLogo' => 'カスタムロゴ',
    'settings-ui.branding.enableCustomLogo' => 'カスタムパネルのロゴを有効にする',
    'settings-ui.branding.logo' => 'ロゴファイル',
    'settings-ui.branding.logoUrl' => 'ロゴ URL',
    'settings-ui.branding.logoUrlEnabled' => 'カスタム',
    'settings-ui.branding.logoUrlDisabled' => 'デフォルト',
    'settings-ui.branding.sectionFavicon' => 'カスタムファビコン',
    'settings-ui.branding.enableCustomFavicon' => 'カスタムファビコンを有効にする',
    'settings-ui.branding.sectionFaviconDesc' => '各種ブラウザのサポートを拡張するには、同じファビコンを両方の形式でアップロードする必要があります。',
    'settings-ui.branding.faviconSvg' => 'ファビコンファイル SVG',
    'settings-ui.branding.faviconSvgHint' => '許可される形式：SVG',
    'settings-ui.branding.faviconIco' => 'ファビコンファイル ICO',
    'settings-ui.branding.faviconIcoHint' => '許可される形式：ICO',
    'settings-ui.branding.show' => '表示',
    'settings-ui.branding.updateSuccess' => 'Plesk のブランディングプロパティが変更されました。',

    'sitebuilder.trial.description' => 'Try & Buy モード（旧「顧客開拓シナリオ」）を構成します。このモードでは、Presence Builder のすべての機能を試してウェブサイトを作成できます。ただし、トライアルウェブサイトを公開するためには、ホスティングサービスプランまたはプランアドオンを購入する必要があります。既存の顧客のホスティングプランまたはプランアドオンで Try & Buy モードを提供することもできます。%%link%%',
    'sitebuilder.trial.descriptionLink' => '詳細はマニュアルを参照してください。',
    'sitebuilder.trial.lifetimeLabel' => 'トライアルウェブサイト有効期間',
    'sitebuilder.trial.lifetimeUnits' => '日',
    'sitebuilder.trial.lifetimeDescription' => '指定した期間の経過後、顧客がトライアルウェブサイトを購入していないと、このサイトはサーバから削除されます。',
    'sitebuilder.trial.signupLabel' => 'トライアルモードへのパブリックアクセスを有効化',
    'sitebuilder.trial.signupDescription' => 'ウェブサイトで Presence Builder 込みのホスティングサービスを宣伝し、デモ環境を提供したい場合には、トライアルモードへのパブリックアクセスを有効にして、トライアルモードの URL をウェブサイトで公開してください。',
    'sitebuilder.trial.signupLinkLabel' => 'トライアルモードアクセス用 URL',
    'sitebuilder.trial.signupLinkDescription' => 'この URL をクリックすると、Presence Builder がトライアルモードで開きます。この URL は、ウェブサイトで Presence Builder 込みのホスティングサービスを宣伝するために使用できます。',
    'sitebuilder.trial.promotionLabel' => 'Presence Builder エディタにトライアルモードの通知を表示する',
    'sitebuilder.trial.promotionDescription' => 'トライアルモードの Presence Builder に関する追加の通知を表示するには、このオプションを使用します。',

    'update-settings.policyHintForPum' => 'アップデートの自動インストールをセットアップします。手動インストール可能なアップデートが提供された場合やアップデートが自動インストールされた場合に通知メールを送信できます。',
    'update-settings.policyHint' => '通知メールは、手動インストール可能なアップデートが提供された場合や、アップデートが自動インストールされた場合に送信されます。',
    'update-settings.branchDisabledDescription' => 'アップグレードの提供時に通知を受け取らない',
    'update-settings.automaticPatchesInstallation' => 'Plesk アップデートを自動インストールする（推奨）',
    'update-settings.automaticPatchesThirdParty' => 'Plesk が提供するサードパーティコンポーネント用のアップデートを自動インストールする',
    'update-settings.automaticSystemPackageUpdates' => 'システムパッケージのアップデートを自動インストールする',
    'update-settings.automaticSystemPackageUpdatesHint' => 'これにより、Plesk に付属するサードパーティコンポーネントのアップデートも自動的にインストールされます',
    'update-settings.installerProxyMode' => 'Plesk ホスト名とポート経由で Plesk インストーラにアクセスする',
    'update-settings.installerProxyModeHint' => '追加の 8447 TCP ポートを開く必要なく Plesk インストーラのウェブインターフェースにアクセスします。',
    'update-settings.automaticPatchesNotification' => '使用可能なアップデートとインストール済みのシステムパッケージのアップデートについて通知する',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'メールアドレス',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '通知メールの頻度',
    'update-settings.daily' => '毎日',
    'update-settings.weekly' => '毎週',
    'update-settings.generalSection' => '全般',
    'update-settings.notificationsSection' => '通知',
    'update-settings.safeUpdatesSection' => 'セーフアップデート',
    'update-settings.safeUpdatesSectionHint' => 'Plesk により、システムパッケージのアップデートがこのパッケージの初回インストール時と同じリポジトリからインストールされます。このようなアップデートは安全だとみなされます。セーフアップデートを無効化すると、システムパッケージマネージャはシステムの任意のリポジトリからアップデートをインストールします。',
    'update-settings.safeUpdatesSectionWarn' => '上級ユーザを除き、セーフアップデートは有効にしておくことをお勧めします。異なるリポジトリからシステムパッケージのアップデートを無差別にインストールすると、サーバの機能に悪影響を与える可能性があります。',
    'update-settings.allowSafeUpdates' => 'システムパッケージのセーフアップデートを有効化',

    'requiredFields' => '必須フィールド',
];