<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => '"%value%" は無効な値です。値は %unitMin% 以上、%unitMax% 以下にする必要があり、0 にはできません。',
    'cgroups.unlimited' => '無制限',
    'cgroups.period' => '"%value%" は無効な値です。値は、5 分、1 時間、1 日を秒単位（それぞれ 300、3600、86400）で指定する必要があります。',

    'file.fileIsImageFalseType' => 'アップロードしようしているファイルが見つかりません。',
    'file.fileUploadErrorIniSize' => 'アップロードしようとしているファイルが指定の ini サイズを超えています。',
    'file.fileUploadErrorFormSize' => 'アップロードしようとしているファイルが指定のフォームサイズを超えています。',
    'file.fileUploadErrorPartial' => 'ファイルが一部だけアップロードされました。',
    'file.fileUploadErrorNoFile' => 'ファイルがアップロードされませんでした',
    'file.fileUploadErrorNoTmpDir' => 'アップロードしようとしているファイルの一時ディレクトリが見つかりませんでした。',
    'file.fileUploadErrorCantWrite' => 'アップロードしようしているファイルは書き込みできません。',
    'file.fileUploadErrorExtension' => 'ファイルのアップロード中に拡張でエラーが返されました。',
    'file.fileUploadErrorAttack' => 'このファイルは不正にアップロードされたものであり、侵入が試みられた可能性があります。',
    'file.fileUploadErrorFileNotFound' => 'アップロードしようとしているファイルが見つかりませんでした。',
    'file.fileUploadErrorUnknown' => 'ファイルのアップロード中に不明なエラーが発生しました',
    'file.fileExtensionFalse' => 'アップロードしようとしているファイルは、許可されない拡張子を使用しています。',
    'file.fileExistsDoesNotExist' => '指定したファイルまたはディレクトリは存在しません。',

    'hostname.hostnameIpAddressNotAllowed' => "「%value%」は IP アドレスと考えられますが、IP アドレスは許可されません",
    'hostname.hostnameUnknownTld' => "「%value%」は DNS ホスト名と考えられますが、TLD が既知のリストと一致しません",
    'hostname.hostnameDashCharacter' => "「%value%」は DNS ホスト名と考えられますが、正しくない場所にダッシュ記号（-）が含まれています。",
    'hostname.hostnameInvalidHostnameSchema' => "「%value%」は DNS ホスト名と考えられますが、TLD「%tld%」のホスト名スキーマと一致しません",
    'hostname.hostnameUndecipherableTld' => "「%value%」は DNS ホスト名と考えられますが、TLD 部分を抽出できません",
    'hostname.hostnameInvalidHostname' => "「%value%」は、DNS ホスト名で期待される構造と一致しません",
    'hostname.hostnameInvalidLocalName' => "「%value%」は有効なローカルネットワーク名ではないと考えられます。",
    'hostname.hostnameLocalNameNotAllowed' => "「%value%」はローカルネットワーク名と考えられますが、ローカルネットワーク名は許可されません",

    'port.notBetween' => '指定されたポート値が無効です。1～65535 の間で指定してください。',

    'dns.invalidSoaValue' => '値は無効です。1 秒～68 年まで可能です',

    'isEmpty' => '必須フィールドが空です。 値を入力してください。',
    'stringLengthTooShort' => "「%value%」が半角 %min% 文字よりも短くなっています。",
    'stringLengthTooLong' => "「%value%」が半角 %max% 文字よりも長くなっています。",
    'regexNotMatch' => "「%value%」はパターン「%pattern%」と一致しません。",
    'notAlnum' => "「%value%」に半角アルファベット以外の文字が含まれています。 半角アルファベットのみを使用してください",
    'alnumStringEmpty' => "値が空です。",
    'stringEmpty' => "「%value%」が空です。",
    'loginSyntax' => 'ユーザ名には、英数字、ダッシュ（-）、ドット（.）、単一引用符（\'）、パーセント（%）、およびアンダースコア（_）を使用できます。ユーザ名の先頭は英数字にする必要があります。',
    'loginExists' => 'ユーザアカウント %value% は既に存在します。',
    'cu_admin_alias__login_exists' => 'ユーザアカウントは既に存在します。',
    'loginPassword' => 'パスワードにユーザ名が含まれないようにしてください。',
    'passwordSyntax' => '許可されない文字がパスワードに含まれています。',
    'passwordLength' => 'パスワードは長さ %minLength%～%maxLength% 文字にする必要があります。',
    'domain_invalid_name' => '入力したドメイン名は正しくありません。 有効なドメイン名（domain.com など）を入力してください。',
    'dns_domain_invalid_name' => '指定したドメイン名が無効です。',
    'dns_domain_template_invalid_name' => '指定したドメイン名テンプレートが無効です。',
    'not_ascii_string' => '値が有効な ASCII 文字列ではありません。',
    'virtual_directory_name_invalid' => 'ディレクトリ名には英数字、アンダースコア、ダッシュ記号のみを使用してください。',
    'virtual_directory_name_reserved' => 'この名称は予約済みです。',
    'invalid_city_name' => '入力した市区町村名が有効ではありません',
    'invalid_country_code' => '無効な国コード',
    'not_specified_country_code' => '国は必須フィールドです。明示的に指定する必要があります。',
    'invalid_system_user_login' => 'システムユーザのログインが無効です',
    'invalid_rfc_domain_name' => '指定したドメイン名は有効な RFC ドメインではありません',
    'idn_name_conversion' => 'ドメイン名を IDN から Punycode に変換するのに失敗しました',
    'domain_label_too_long' => 'ドメイン名を構成するどの部分も長さ 63 文字以上にはできません。',
    'domain_label_too_long_idn' => 'このドメインは国際化ドメイン名を使用しています。名前を構成するどの部分も、Punycode に変換した後で長さ 63 文字以上になってはいけません。',
    'domain_starts_with_www' => '\'www\' プレフィックスなしでドメイン名を入力してください。ドメインの www プレフィックスはウェブサーバの構成に自動的に追加されます。',
    'domain_already_exists' => 'このドメイン名は既に存在します。',
    'domain_without_www_already_exists' => 'このドメイン名は \'www\' プレフィックスなしで既に存在します。',
    'domain_with_www_already_exists' => 'このドメイン名は \'www\' プレフィックス付きで既に存在します。',
    'subdomain_conflicts_with_existing_domain' => 'サブドメイン \'%value%\' と同じ名前のドメインがあります。',
    'restrict_domain_creation' => '指定したドメイン名はサーバ全体のポリシーで禁止されています。このドメインがご自分に属している場合、ホスティング事業者までお問い合わせください。',
    'dns_record_already_exists' => 'この DNS レコードは既に存在します。',
    'domain_like_hostname' => 'このドメイン名はサーバのホスト名と同じです',
    'passwordsNotMatch' => '入力したパスワードが一致していません',
    'stringsNotEqual' => '値が同じではありません',
    'equalMailAliases' => '入力したメールエイリアスは別のメールエイリアスと同じ名前です',
    'mailAliasExist' => '指定したメールエイリアスは既に存在します。',
    'mailNameExist' => '指定されたメールアドレスは既に存在します。',
    'mailListExist' => '指定したアドレスはメーリングリストに割り当て済みです',
    'mailAutoReplyHeadersSpaceError' => "自動返信ハンドラにはスペースを使用できません",
    'mailAutoReplyHeadersInvalidValueError' => 'いくつかのフィールドが空であるか、無効な値が指定されています。',
    'sysUserExist' => '指定したユーザ名は別のシステムユーザが既に使用しています。 別のユーザ名を指定してください',
    'emailAddressInvalid' => '指定されたメールアドレスは有効ではありません。johndoe@example.com というパターンの有効なメールアドレスを指定してください',
    'emailAddressInvalidLocal' => '指定したメールアドレスが無効です。メールアドレスは、選択したドメインに属している必要があります。この場合、外部メールアドレスを指定できるのは管理者だけです。',
    'emailAddressSpecialNames' => '入力したメールアドレスは無効です。アドレスのユーザ名部分の先頭を予約済みのシステム名（con、lpt1、prn など）にして、残り部分からドット（.）で区切ることはできません。',
    'dkimSelectorInvalid' => '指定された DKIM セレクタが有効ではありません: %value%',
    'longAddress' => 'メールアドレスが長すぎます。',
    'longMailboxAddressMailServer' => 'このメールサーバに対して、メールアドレスのユーザ名部分が長すぎます。%%max%% 文字以内のユーザ名を指定してください。',
    'longFullAddressMailServer' => 'このメールサーバに対してメールアドレスが長すぎます。%%max%% 文字以内のアドレスを指定してください。',
    'dir_invalid_name' => '宛先ディレクトリが無効です',
    'directoryHidesDomain' => 'このディレクトリは、%path% にあるウェブサイトにオーバーラップするため使用できません。 オーバーラップすると、ウェブサイトを使用できなくなります。',
    'directoryHidesAnotherApplication' => 'このディレクトリは、%path% にインストールされた別のアプリケーションにオーバーラップするため使用できません。 オーバーラップすると、インストールしたアプリケーションを使用できなくなります。',
    'directoryIsBehindAnotherApplication' => 'このディレクトリは、%path% にインストールされた別のアプリケーションにオーバーラップされるため使用できません。 オーバーラップすると、アプリケーションを使用できなくなります。',
    'domainLoginSyntaxWindows' => 'ユーザ名は先頭をアルファベットにして、長さ %%maxlength%% 文字以内にする必要があります。先頭の文字以外は小文字の英数字、ダッシュ、ドット、アンダースコアにできます。ユーザ名の最後をドットにすることはできません。',
    'domainLoginSyntaxUnix' => 'ユーザ名は %%maxlength%% 文字以内にして、小文字、ダッシュ、アンダースコアのみを使用してください。ユーザ名の先頭はアルファベット小文字にする必要があります。',
    'notLocalMssqlHost' => 'ローカルの MSSQL ホスト名ではありません',
    'invalidMailTo' => '有効な mailto: リンクではありません',
    'passwordsNotEqual' => '入力したパスワードが一致していません',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "アップロードしようとしているイメージ「%value%」の幅が広すぎます（「%width%」）。 「%maxwidth%」よりも広くすることはできません。",
    'fileImageSizeWidthTooSmall' => "アップロードしようとしているイメージ「%value%」の幅が狭すぎます（「%width%」）。 「%minwidth%」よりも狭くすることはできません。",
    'fileImageSizeHeightTooBig' => "アップロードしようとしているイメージ「%value%」の高さが大きすぎます（「%height%」）。 「%maxheight%」よりも高くすることはできません。",
    'fileImageSizeHeightTooSmall' => "アップロードしようとしているイメージ「%value%」の高さが小さすぎます（「%height%」）。 「%minheight%」よりも小さくすることはできません。",
    'fileImageSizeNotDetected' => "アップロードしようとしているイメージ「%value%」のサイズを検出できません。",
    'fileImageSizeNotReadable' => "アップロードしようとしているイメージ「%value%」を読み込めません",
    'passwordConfirmation' => 'パスワードの確認',
    'databaseUserNameExists' => '%value% という名前のデータベースユーザ名は既に存在しています。',
    'invalidUserName' => 'データベースユーザ名に、許可されない文字が含まれています。',
    'longUserName' => 'データベースユーザ名が %%max%% 文字を超えています。',
    'forbiddenName' => '「%value%」というデータベースユーザ名は許可されません。',
    'invalidAdminLogin' => '選択したユーザのクレデンシャルを管理者のアクセスに使用できません。 入力したログイン名が無効です。%%cause%%',
    'invalidAdminPassword' => '選択したユーザのクレデンシャルを管理者のアクセスに使用できません。 指定したパスワードが無効です。%%cause%%',
    'passwordLengthTooShort' => "パスワードが %min% 文字よりも短いです",
    'passwordLengthTooLong' => "パスワードが %max% 文字よりも長いです",
    'passwordRegexNotMatch' => "パスワードがパターン「%pattern%」と一致しません。",
    'fileSharingEmptyFolderName' => "フォルダ名を指定してください",
    'fileSharingInvalidFolderName' => "指定したフォルダ名が無効です。 次の文字は使用できません。¥¥ / : * ? \" < > |",
    'fileSharingFolderExists' => "指定した名前のフォルダが既に存在するため、この名前でフォルダを作成することができません。",
    'invalidUrl' => '指定したアドレスが無効です。 有効なアドレスを指定してください（http://domain.com など）',
    'domainVirtualdirectoryReservedName' => 'このディレクトリ名は予約されています。仮想ディレクトリには別の名前を指定してください',
    'domainVirtualdirectoryInvalidName' => 'ディレクトリ名に使用できるのは、英数字、アンダースコア、およびダッシュのみです',
    'filesharingPathUnavailable' => 'この名前のディレクトリが指定したドメイン上に既に存在します。別のディレクトリ名を使用してください。',
    'filesharingSslNotAvailableOnDomain' => '安全なリンクの使用を選択しましたが、ドメインで SSL/TLS が有効ではありません。SSL/TLS 対応のドメインを選択するか、［安全なリンクを生成］チェックボックスをオフにしてください。',
    'filesharingSslRedirectOnDomain' => '選択したドメインで、［SEO に対応する HTTP から HTTPS への恒久的 301 リダイレクト］オプションが有効になっています。ファイル共有を設定するには、このオプションが無効になっているドメインを選択するか、［ファイルとフォルダへの安全なリンクを生成］チェックボックスをオンにしてください。',
    'filesharingSslNotAvailableOnDefaultDomain' => 'サーバの IP アドレスまたはホスト名で安全なリンクの使用を選択しましたが、そのようなリンクは SSL/TLS 対応のウェブサイトに対してのみ作成できます。SSL/TLS 対応のウェブサイトをセットアップするか、［安全なリンクを生成］チェックボックスをオフにしてください。',
    'filesharingDefaultDomainSelectedOnServerIp' => 'デフォルトドメインが割り当てられたサーバ IP アドレスを選択しました。 IP アドレスの代わりにウェブサイトを root URL として選択してください',
    'physicalPathOnDomainAlreadyExists' => 'この名前のディレクトリは既に存在します。',
    'virtualPathOnDomainAlreadyExists' => 'この名前の仮想ディレクトリは既に存在します。',
    'sysUserLoginSyntaxWindows' => 'ユーザ名には英数字、ダッシュ（-）、ドット（.）、アンダースコア（_）を使用できます。ユーザ名の先頭は英数字にする必要があります。',
    'sysUserLoginSyntaxUnix' => 'ユーザ名には小文字の英数字、ダッシュ（-）、ドット（.）、アンダースコア（_）を使用できます。ユーザ名の先頭は英数字にする必要があります。',
    'docrootNotInWebspaceRoot' => '指定されたディレクトリが契約のルートディレクトリにありません。',
    'docrootContainsSpecialCharacters' => '入力したディレクトリ名に、使用できない文字が含まれています。',
    'docrootWithinProhibitedDirectory' => '入力したディレクトリにサービスディレクトリが含まれています。',
    'docrootWithinInstalledApplication' => '入力したディレクトリは、%path% にインストールされたウェブアプリケーションによってオーバーラップされています。',
    'docrootIsNotDirectory' => '指定されたパスを使用できません。その一部がファイルを参照しているためです。',
    'docrootTooLongPart' => '入力したディレクトリ名が長すぎます。',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => '間違ったドメインが選択されました',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => '入力した電話番号は、許可されていない記号が含まれており正しくありません',
    'stateInvalid' => '入力した都道府県は無効です',
    'zipRegexNotMatch' => '入力した郵便番号が正しくありません',
    'limitValueInvalid' => '指定した上限が無効です。',
    'softLimitValueInvalid' => '値は %%MIN%%～%%MAX%% の範囲内にしてください。',
    'outgoingMessagesLimitValueInvalid' => '値は %%MIN%%～%%MAX%% の範囲内にしてください。この設定を調整することができるのは、Plesk 管理者のみです。',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'MS SQL データベースファイルのサイズは、0～16 TB の整数値でなければなりません。',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'MS SQL データベースログファイルのサイズは、0～2 TB の整数値でなければなりません。',
    'limitDiskspaceValueInvalid' => 'ディスクスペース上限は 0～4095 TB の間の整数で指定してください。',
    'limitTrafficValueInvalid' => 'トラフィック上限は 0～4095 TB/月の間の整数で指定してください。',
    'limitMboxQuotaValueInvalid' => 'メールボックスサイズ上限は 0～4095 TB の間の整数で指定してください。',
    'limitRetainPeriodValueInvalid' => 'サービスプランの［ウェブおよびトラフィック統計の保持期間］の値を、［ツールと設定］/>［サーバ設定］の［ウェブおよびとトラフィック統計の保持期間］より小さくすることはできません。%%MIN%% 以上 %%MAX%% 未満の整数で指定してください。',
    'limitValueOverused' => '現在のリソース使用量が、指定した上限値を超えています。%%used%% より小さい値は指定できません。',
    'limitValueOverselled' => 'リソース使用量上限として %%reserved%% が契約に割り当て済みです。 %%reserved%% より小さい値は指定できません',
    'lessThan' => "「%value%」が「%min%」を下回っています。",
    'greaterThan' => "「%value%」が「%max%」を超えています。",
    'greaterThanDiskQuota' => "%value% はディスククォータ（%max%）を超過しています",
    'notDigits' => '値は整数値にしてください。',
    'digitsInvalid' => '値は整数値にしてください。',
    'digitsStringEmpty' => '値は整数値にしてください。',
    'isEqual' => "値は「%invalidValue%」と同じではいけません。",
    'notInt' => '値は整数値にしてください。',
    'maillistNameInvalid' => '指定されたメーリングリストアドレスは無効です。',
    'maillistReservedNameAlreadyExists' => '入力したアドレスは予約済みです',
    'maillistAlreadyExists' => '入力したアドレスはメーリングリストに使用済みです',
    'maillistAlreadyExistsOnServer' => '指定したメーリングリスト名は別の契約で既に使用しています。',
    'mailnameAlreadyExists' => '指定されたメールアドレスは既に存在します。',
    'mailaliasAlreadyExists' => '指定されたアドレスはメールエイリアスで使用済みです。',
    'autoresponderEndDateIsInvalid' => '未来の日付を指定する必要があります。',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'zxcvbnEstimator.passwordStrength' => 'パスワードが十分に複雑ではありません。サーバポリシーには、最低限のパスワード強度は %strength% と規定されています。',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => '非常に弱い（非推奨）',
    'zxcvbnEstimator.passwordStrengthWeak' => '弱い（非推奨）',
    'zxcvbnEstimator.passwordStrengthMediocre' => '中',
    'zxcvbnEstimator.passwordStrengthStrong' => '強い（推奨）',
    'zxcvbnEstimator.passwordStrengthStronger' => '非常に強い',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => '簡単にブルートフォース攻撃を受けます。クレデンシャルスタッフィングや辞書攻撃に対して脆弱性があります。',
    'zxcvbnEstimator.passwordStrengthWeakHint' => '簡単にブルートフォース攻撃を受けます。クレデンシャルスタッフィングや辞書攻撃に対する脆弱性は低くなっています。',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'ブルートフォース攻撃を受ける可能性があります。',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'ブルートフォース攻撃は受けにくくなっています。オフライン攻撃に対して一定の保護を提供します。',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'ブルートフォース攻撃を受ける可能性はほぼありません。オフライン攻撃に対して適度な保護を提供します。',

    'emailCantBeRenamed' => "サーバはメールアカウントの名前変更をサポートしていません",
    'emailOwnedByAnotherUser' => "このメールアドレスは別のユーザが所有しています。",
    'maillistAdminEmailShouldExistsOnDomain' => 'メーリングリスト管理者のメールアドレスは、このメーリングリストと同じドメインに登録されている必要があります。',
    'webmailExists' => "ウェブメールサービス「%value%」は既に存在します。",
    'invalidDbName' => 'データベース名に使用できるのは、英数字、ドット、ダッシュ、アンダースコアのみです。',
    'longDbName' => 'データベース名が長すぎます。',
    'dbNameClash' => 'データベース名とデータベースユーザ名は異なる必要があります。',
    'dbConnectFailed' => 'データベースサーバに接続できません。データベースユーザのクレデンシャルとアクセス制限をチェックしてください。',
    'databaseNameAlreadyExists' => '%value% という名前のデータベースは既に存在しています。',
    'wrongUrlSyntax' => '指定したアドレスが無効です。有効なアドレスを指定してください（http://domain.com、相対パス、mailto:address など）',
    'connectionRefused' => '接続が拒否されました。',
    'loginIncorrect' => 'ユーザ名が正しくありません',
    'failedToChangeDirectory' => 'ディレクトリが存在しません',
    'failedToChangeMode' => 'モードを変更できませんでした',
    'failedToCreateDirectory' => 'ファイルの作成は許可されていません',
    'failedToRenameDirectory' => 'ファイル名の変更は許可されていません',
    'failedToDeleteDirectory' => 'ファイルの削除は許可されていません',
    'ipInvalid' => "'%value%' は有効な IP アドレスではないか、正しくないタイプに属しているようです。",
    'ipMaskInvalid' => "「%value%」は有効な IP アドレスマスクではないようです。",
    'ipInvalidForInterface' => '指定の IP アドレスをネットワークインターフェース上で使用できません。サブネットプレフィックス範囲またはマスクを使用して、有効な IP アドレスを指定する必要があります。',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'サポート選択したネットワークインターフェースでは、指定の IP アドレスを使用できません。これは、IPv6 のサポートがこのインターフェースでオフになっているためです。',
    'ipAlreadyExists' => 'IP アドレス「%value%」は既に存在します。',
    'notInArray' => 'このオプションはサポートされていません。',
    'ipAddressIsNotSelected' => 'IP アドレスを 1 つ以上選択してください。',
    'noServiceNodeSpecified' => '内部エラー：サービスノードが指定されていません。',
    'serviceNodeInvalidName' => 'サービスノード名 "%value%" が無効です。',
    'serviceNodeNameAlreadyExists' => '「%value%」という名前のサービスノードは既に存在します。',
    'serviceNodeIpUsed' => "サービスノードを削除できません。この IP アドレスは登録されています。",
    'serviceNodeIpAddressAlreadyExists' => 'IP アドレス「%value%」のサービスノードは既に存在します。',
    'serviceNodeInvalidTransport' => 'トランスポート名 "%value%" が無効です。',
    'app_non_unique_setting_value' => '他のオブジェクトに同じ値が設定されています。この設定は、このオブジェクト固有である必要があります。',
    'wrongLocalUrlSyntax' => '指定されたアドレスが無効です。有効なローカルアドレス（/smb/web/view など）を指定してください。',
    'phpIsapiHandlerTypeNotSupported' => 'ISAPI ハンドラのタイプは、現在の PHP バージョンでサポートされていません。',
    'dbNameNotExist' => '指定したデータベースは存在しません。',
    'invalidBooleanValue' => '許可される値は「true」または「false」です。',
    'invalidMimeType' => '指定した MIME タイプ（%value%）は無効です。',
    'invalidHeaders' => '指定したヘッダ &quot;%value%&quot; は無効です。',
    'invalidHandler' => '指定したハンドラ（%value%）は無効です。',
    'invalidAllowDeny' => '指定した Allow/Deny ディレクティブ（%value%）は無効です。',
    'nonUniqueAllowDeny' => 'Allow/Deny ディレクティブに指定された値は既に存在します。%value%。',
    'maxItemsCountExeededAllowDeny' => 'リストに含まれる IP アドレスの数は、%value% 以下でなければなりません。',
    'invalidDirectoryIndex' => '指定した root ディレクトリインデックスファイルは無効です。',
    'invalidNginxProxyMode' => 'nginxProxyMode プロパティに指定された値が無効です。許可される値は「true」または「false」です。',
    'invalidNginxTransparentMode' => 'nginxTransparentMode プロパティに指定された値が無効です。許可される値は「true」または「false」です。',
    'invalidNginxServeStatic' => 'nginxServeStatic プロパティに指定された値が無効です。許可される値は「true」または「false」です。',
    'invalidStaticFilesExtensions' => '指定した静的ファイルの拡張子（%value%）が無効です。',
    'invalidNginxServePhp' => 'nginxServePhp プロパティに指定された値が無効です。許可される値は「true」または「false」です。',
    'invalidDocuments' => 'ドキュメント名に「,」記号は使用できません。',
    'duplicateDocuments' => '次のドキュメントはデフォルトコンポーネントのリストに既に含まれています。%value%',
    'protected_directory_invalid_name' => '保護ディレクトリ名が正しくありません',
    'protected_directory_invalid_login' => 'パスワード保護されたディレクトリユーザのログイン名は、20 文字以内で指定してください。ログイン名にはダッシュ記号「-」を使用できますが、先頭には使用できません。',
    'notARelativePath' => 'パスは相対パスにする必要があります',
    'cannotUseJunctions' => 'ウェブスペース外のジャンクションをコンパイルの一時ディレクトリとして使用できません',
    'notBetween' => '%value% が %min%～%max% の範囲内ではありません',
    'notBetweenStrict' => '%value% が厳密に %min%～%max% の範囲内ではありません',
    'redirectToMyself' => 'ウェブサイトをこれ自身に転送することはできません。メインウェブサイトの URL とは異なる宛先アドレスを入力してください。',
    'redirectToAlias' => 'ウェブサイトをこのエイリアスに転送することはできません。メインウェブサイトエイリアスのアドレスとは異なる宛先アドレスを入力してください。',
    'relativePathInvalid' => '無効なパスが指定されました。',
    'aspDotNetSettingsInvalid' => 'ASP.NET 設定に指定した値が 1 つ以上無効です。',
    'mboxOutgoingMessagesLimitValueInvalid' => 'メールボックスからの送信メッセージ数の上限は "%%MIN%%" 以上にする必要があります。',
    'domainOutgoingMessagesLimitValueInvalid' => 'ドメインからの送信メッセージ数の上限は "%%MIN%%" 以上にする必要があります。',
    'subscriptionOutgoingMessagesLimitValueInvalid' => '契約からの送信メッセージ数の上限値は "%%MIN%%" 以上にする必要があります。',
    'iisAuthNotEnabled' => 'ドメインのウェブサーバ設定で匿名認証または Windows 認証をオンにする必要があります。',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'メールボックスの送信メッセージの上限値は、正の整数値または \'default\' にする必要があります。\'-1\' にすると、\'Unlimited\'（無制限）になります。',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'ドメインからの送信メッセージ数の上限は、正の整数値または \'default\' にする必要があります。\'-1\' にすると、\'Unlimited\'（無制限）になります。',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => '契約からの送信メッセージ数の上限は、正の整数値または \'default\' にする必要があります。\'-1\' にすると、\'Unlimited\'（無制限）になります。',
    'outgoingMessagesReportPeriodValueInvalid' => 'レポート期間に指定した値がサポートされていません。',
    'outgoingMessagesNotificationPeriodValueInvalid' => '通知期間に指定した値がサポートされていません。',
    'textItemsListInvalid' => '指定したアイテム "%value%" は無効です。',
    'textItemsListInvalidMulti' => '指定されたアイテムが無効です："%value%"。',
    'textItemsListNonUnique' => '指定した値は既に存在します。"%value%"。',
    'textItemsListMaxItemsCountExeeded' => 'アイテム数は %value% 以内でなければなりません。',
    'invalidAcl' => '指定したホスト "%value%" は無効です。',
    'nonUniqueAcl' => 'ホストに指定した値は既に存在します。"%value%"。',
    'httpInvalidStatusFormat' => 'ステータスコードはフォーム 400 または 400.1 でなければなりません',
    'httpInvalidStatusCode' => 'ステータスコードは %%minCode%%～%%maxCode%% の間でなければなりません',
    'httpInvalidStatusSubCode' => 'サブステータスコードは %%minSubCode%%～%%maxSubCode%% の間でなければなりません',
    'httpInvalidStatusRange' => 'ステータスの幅は、最低値から最大値までの幅で指定する必要があります。',
    'phpSettingValueByteRegexNotMatch' => '正しくない値が指定されました。整数値と省略形（K - キロバイト、M - メガバイト、G- ギガバイト。 例えば 128M）を入力してください。',
    'phpFpmServersAmountNotPositive' => "値は正の値にしてください。",
    'phpFpmServersAmountLessThan' => "「%value%」が「%%min%%」より小さくなっています（%%field%%）",
    'phpFpmServersAmountGreaterThan' => "「%value%」が「%%max%%」より大きくなっています（%%field%%）",
    'phpInvalidIniSyntax' => "無効な INI 構文が %%line%% 行目で検出されました: '%%text%%'",
    'portRangeInvalid' => '指定されたポート範囲は無効です。左の値が右の値より小さくなければなりません。',
    'portRangeValueInvalid' => 'ポート範囲の値 %value% が無効です。%min%～%max% の範囲内でなければなりません。',
    'domainResolvesToAnotherIp' => 'ドメインが正しくない IP アドレス（%value%）に変換されます。ウェブサイトをオンラインにするには %%dnsSettingsLink%% を修正してください。',
    'domainNotResolved' => 'ドメインを変換できません。ウェブサイトをオンラインにするには %%dnsSettingsLink%% を修正してください。',
    'dnsSettingsLink' => 'DNS 設定',
    'backupRotationSingleValueInvalid' => '上限を超過しました。',
    'backupRotationMultipleValueInvalid' => 'ローカルストレージに予定されているすべてのバックアップにより、上限を超過してしまいます：%%details%%。',
    'backupRotationDetail' => '{count, plural, other {# 件の{type}バックアップ}}',
    'backupRotationTypeHourly' => '時間単位',
    'backupRotationTypeDaily' => '日次',
    'backupRotationTypeWeekly' => '週次',
    'backupRotationTypeMonthly' => '月次',

    'backupPathInvalidCharacters' => '"%value%" に無効な文字が含まれています。',
    'backupPathInvalidDot' => '"%value%" に無効なパス "." または ".." が含まれています。',
    'networkAccessAlreadyExists' => 'このネットワークは既に IP アクセス制限リストに含まれています。',
    'codeRegexNotMatch' => 'アクティベーションコードが有効ではありません。',
    'nameUsedForPlesk' => 'このドメインを作成できません。この名前は Plesk へのログインに使用された URL に含まれています。このドメインを作成するには、Plesk に https://%value%:8443 または https://plesk.%value% からログインしてください。',
    'invalidNameDirectory' => '指定された名前が無効です。',
    'invalidPasswordCharacters' => 'パスワードに引用符、スペース、または国別文字を使用することはできません。',
    'invalidPasswordLength' => 'パスワードは長さ %%min%%～%%max%% 文字にする必要があります。',
    'passwordContainsLogin' => 'パスワードにログイン名を含めないでください。',

    'invalidPhpExtensionName' => '拡張名が正しくありません。',
    'hexStringNotMatch' => '指定された値は有効な 16 進数の文字列ではないようです。',
    'invalidCertificateData' => '指定された値は有効な証明書データではないようです。',
    'invalidSha256Hash' => '指定された値は有効な SHA-256 ハッシュではないようです。',
    'invalidSha512Hash' => '指定された値は有効な SHA-512 ハッシュではないようです。',
    'invalidTlsaMatchingType' => '無効な TLSA 一致タイプが指定されました.',
];