<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Ha egy dedikált IP-címen (nincs más felhasználókkal vagy webhelyekkel megosztva) történik webhelye üzemeltetése, akkor a webhelyen belül beállíthat egy olyan könyvtárat, ahol más felhasználók névtelenül végezhetik FTP-n keresztüli fájlok fel- és letöltését. Ha be van kapcsolva a névtelen FTP, akkor egy olyan címen jelentkezhetnek be a felhasználók a könyvtárba, mint ftp://ftp.your-domain.com a „névtelen” felhasználónév és jelszó segítségével.',
    'anonymous-ftp.displayLogin' => 'Bejelentkezési üzenet megjelenítése',
    'anonymous-ftp.loginText' => 'Üzenet szövege',
    'anonymous-ftp.incomingDir' => 'Feltöltés engedélyezése a bejövő fájlok könyvtárba',
    'anonymous-ftp.incomingSubDir' => 'Alkönyvtárak létrehozásának engedélyezése a bejövő fájlok könyvtárban',
    'anonymous-ftp.incomingReadable' => 'Letöltés engedélyezése a bejövő fájlok könyvtárból',
    'anonymous-ftp.quota' => 'A bejövő üzenet könyvtár lemezterületének korlátozása',
    'anonymous-ftp.maxConnections' => 'Az egyidejű kapcsolatok számának korlátozása',
    'anonymous-ftp.bandwidth' => 'E virtuális FTP-domain letöltési sávszélességének csökkentése',
    'anonymous-ftp.unlimited' => 'Korlátlan',

    'aps.catalog.loading' => 'Betöltés',
    'aps.catalog.searchName' => 'Alkalmazás',
    'aps.catalog.searchVendor' => 'Forgalmazó',
    'aps.catalog.searchPackager' => 'Csomagoló',
    'aps.catalog.searchLicenseType' => 'Licenctípus',
    'aps.catalog.searchLicenseTypeAny' => 'Bármely',
    'aps.catalog.searchLicenseTypeFreeware' => 'Ingyenes',
    'aps.catalog.searchLicenseTypeCommercial' => 'Fizetős',
    'aps.catalog.showSearch' => 'Keresés megjelenítése',
    'aps.catalog.hideSearch' => 'Keresés elrejtése',
    'aps.catalog.buttonSearch' => 'Keresés',
    'aps.catalog.buttonResetSearch' => 'Keresés visszaállítása',
    'aps.catalog.showCategories' => 'Válasszon ki egy alábbi kategóriát vagy a keresőmező használatával végezze alkalmazások keresését.',
    'aps.catalog.searchResults' => 'Keresési eredmények',
    'aps.catalog.buttonInstall' => 'Telepítés',
    'aps.catalog.buttonInstallTooltip' => 'Gyorsan végezze el az alkalmazás legújabb verziójának telepítését az optimális alapértelmezett paraméterek használatával.',
    'aps.catalog.buttonAdvancedInstall' => 'Telepítés (Egyéni)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Az alkalmazás legújabb verzióját telepítse, az összes paraméter testreszabásával.',
    'aps.catalog.buttonInstallOldVersion' => 'Telepített verzió',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Az alkalmazás kiválasztott verzióját telepítse, az összes paraméter testreszabásával.',
    'aps.catalog.buttonInstallDescription' => 'Telepítse az alkalmazást, ha már rendelkezik aktiváló kóddal vagy csak ki akarja próbálni.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Telepítse ezen ingyenes alkalmazást egy webhelyen.',
    'aps.catalog.version' => 'Verzió',
    'aps.catalog.moreVersions' => 'További verziók',
    'aps.catalog.release' => 'Kiadás',
    'aps.catalog.overview' => 'Áttekintés',
    'aps.catalog.noApplicationsInCategory' => 'Nem állnak alkalmazások rendelkezésre e kategóriában. Válasszon ki másik kategóriát.',
    'aps.catalog.noCategoriesSelected' => 'Válasszon ki egy kategóriát e kategórián belül rendelkezésre álló alkalmazások böngészéséhez.',
    'aps.catalog.noSearchResults' => 'Egyik alkalmazás sem felel meg a keresési feltételeinek.',
    'aps.catalog.connectionFailed' => 'Nem sikerült az Alkalmazáskatalógushoz kapcsolódás. %%retryLink%%.',
    'aps.catalog.retry' => 'Újból',
    'aps.catalog.categoriesError' => 'Jelenleg nem betölthető kategóriák listája.',
    'aps.catalog.applicationsError' => 'Jelenleg nem betölthető alkalmazások listája.',
    'aps.catalog.detailsError' => 'Jelenleg nem tölthetőek be alkalmazásadatok.',
    'aps.catalog.searchError' => 'Jelenleg nem tölthetőek be keresési eredmények.',
    'aps.catalog.changelogEntry' => 'v%%version%% (%%release%% kiadás) - %%description%%',
    'aps.catalog.changelog' => 'Korábbi változások',
    'aps.catalog.officialApplicationSite' => 'Szolgáltató adatai',
    'aps.catalog.returnToCategories' => '<< Vissza az alkalmazáslistára',
    'aps.catalog.buttonUninstall' => 'Eltávolítás',
    'aps.catalog.gotoHome' => 'Kezdőlap',
    'aps.catalog.all' => 'Az összes',
    'aps.catalog.buttonDetails' => 'További tudnivalók',
    'aps.catalog.buttonBuy' => 'Vásároljon most!',
    'aps.catalog.buttonBuyTooltip' => 'Vásárolja meg az alkalmazást!',
    'aps.catalog.buttonBuyDescription' => 'Keresse fel a webáruházunkat az alkalmazás aktiváló kódjának megvásárlása érdekében.',
    'aps.catalog.buttonDownload' => 'Letöltés',
    'aps.catalog.buttonDownloadDescription' => 'Töltse le az alkalmazást, ha már rendelkezik aktiváló kóddal vagy csak ki akarja próbálni.',
    'aps.catalog.marketplaceMoreInfo' => 'További információkért keresse fel a vonatkozó %%link%% hivatkozás által elérhető helyet.',
    'aps.catalog.marketplaceMoreInfoLink' => 'az alkalmazás forgalmazójának webhelye',

    'aps.configure.installedAt' => "Telepítve a következő helyen;",
    'aps.configure.otherSettings' => "Egyéb",
    'aps.configure.globalSettings' => 'Csomagbeállítások',
    'aps.configure.passwordConfirmation' => 'Jelszó megerősítése',
    'aps.configure.databaseParams' => 'Adatbázis paraméterek',
    'aps.configure.noInstallationUrlAvailable' => 'Nincs (külső alkalmazás)',
    'aps.configure.updateSettingsSection' => 'Frissítési beállítások',
    'aps.configure.forceUpdates' => 'Ezen alkalmazás automatikus frissítése, amikor frissítések állnak rendelkezésre',
    'aps.configure.forceUpdatesHint' => 'Automatikus frissítéseket kap az alkalmazás az újabb verziókra történő frissítéshez. Figyelmeztetés: Körültekintően használja e beállítást, mivel jelentősen befolyásolhatja az alkalmazás funkcióit. Például előfordulhat, hogy az alkalmazás bővítmények nem működnek az alkalmazás másik verziójával.',

    'aps.install.showAllSettings' => 'Az összes beállítás megjelenítése.',
    'aps.install.showLessSettings' => 'Minimum beállítások megjelenítése',
    'aps.install.install' => 'Telepítés',
    'aps.install.otherSettings' => 'Egyéb beállítások',
    'aps.install.globalSettings' => 'Csomagbeállítások',
    'aps.install.passwordConfirmation' => 'Jelszó megerősítése',
    'aps.install.provisionsSectionLabel' => 'Telepítési hely elérési útja',
    'aps.install.context' => 'Adja meg a helyet, ahová a webalkalmazást telepíteni kell.',
    'aps.install.registerAsWebmailSection' => 'Webes levelezés regisztrálás',
    'aps.install.registerAsWebmailDescription' => "Válassza ki e beállítást, ha webes levelezési ügyfél az alkalmazás. Ennek eredményeképpen megjelenik a rendelkezésre álló webes levelezés szolgáltatások között az alkalmazás az előfizetések és szolgáltatási csomagok Levelezési beállításainál. Az adminisztrátor konfigurálhatja a webes levelezés nyilvános hozzáférési URL-címét a Kiszolgáló kezelés > Beállítások > Webes levelezés menüpontban.",
    'aps.install.registerAsWebmailLabel' => 'Webes levelezési szolgáltatáskénti regisztrálás',
    'aps.install.addItem' => 'Hozzáadás',
    'aps.install.removeItem' => 'Eltávolítás',
    'aps.install.updateSettingsSection' => 'Frissítési beállítások',
    'aps.install.forceUpdates' => 'Ezen alkalmazás automatikus frissítése, amikor frissítések állnak rendelkezésre',
    'aps.install.forceUpdatesHint' => 'Automatikus frissítéseket kap az alkalmazás az újabb verziókra történő frissítéshez. Figyelmeztetés: Körültekintően használja e beállítást, mivel jelentősen befolyásolhatja az alkalmazás funkcióit. Például előfordulhat, hogy az alkalmazás bővítmények nem működnek az alkalmazás másik verziójával.',

    'aps.invalid-requirements.requirementsLegend' => 'Követelmények',
    'aps.invalid-requirements.domainLegend' => 'Webhely',
    'aps.invalid-requirements.context' => 'Másik webhely választása',
    'aps.invalid-requirements.backToApplicationList' => 'Vissza az alkalmazáslistára',

    'aps.license.title' => '%%packageName%% telepítése',
    'aps.license.doYouAcceptLicense' => 'Ezen alkalmazás telepítéséhez el kell olvasnia a végfelhasználói licencszerződést és el kell fogadnia annak feltételeit.',
    'aps.license.licenseAgree' => 'Elfogadom a Licencszerződés feltételeit.',

    'aps.services-list-customization.settings' => 'Beállítások',

    'asp-dot-net.change-version.frameworkVersion' => 'Az ASP.NET keretrendszer verzió',

    'asp-dot-net.settings.casSettingsSection' => "Kódelérés biztonsága",
    'asp-dot-net.settings.clientScriptsSection' => "Parancsprogram könyvtár beállítások",
    'asp-dot-net.settings.connStringsSection' => "Kapcsolódási karakterlánc kezelő",
    'asp-dot-net.settings.customErrorsSection' => "Egyéni hiba beállítások",
    'asp-dot-net.settings.frameworkVersionSection' => "Keretrendszer verzió",
    'asp-dot-net.settings.globalizationSection' => "Globalizációs beállítások",
    'asp-dot-net.settings.otherSection' => "Munkamenet beállítások",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Fordítás és hibakeresés",
    'asp-dot-net.settings.authMode' => "Hitelesítési mód",
    'asp-dot-net.settings.connStrings' => "Kapcsolódási karakterláncok",
    'asp-dot-net.settings.connStringsInvalid' => "Néhány mező üres, vagy helytelen értéket tartalmaz.",
    'asp-dot-net.settings.connStringName' => "Név",
    'asp-dot-net.settings.connStringValue' => "Kapcsolódási paraméterek",
    'asp-dot-net.settings.connStringsDescription' => "Név/kapcsolódási paraméterek",
    'asp-dot-net.settings.culture' => "Nyelv",
    'asp-dot-net.settings.customErrMode' => "Egyéni hibák módja",
    'asp-dot-net.settings.customErrorRedirect' => "Átirányítási URL-cím",
    'asp-dot-net.settings.customErrorStatus' => "Állapotkód",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Egy egész számnak kell az állapotkódnak lennie.",
    'asp-dot-net.settings.customErrors' => "Egyéni hiba",
    'asp-dot-net.settings.customErrorsDescription' => "Állapotkód/átirányítási URL-cím",
    'asp-dot-net.settings.customErrorsInvalid' => "Néhány mező üres, vagy helytelen értéket tartalmaz.",
    'asp-dot-net.settings.debugMode' => "Hibakeresésre átkapcsolás",
    'asp-dot-net.settings.defLanguage' => "Alapértelmezett weboldal nyelv",
    'asp-dot-net.settings.tempDirectory' => "Ideiglenes könyvtár",
    'asp-dot-net.settings.fileEnc' => "Fájlkódolás",
    'asp-dot-net.settings.fileEncInvalid' => "Érvénytelen a megadott Fájlkódolási paraméter érték.",
    'asp-dot-net.settings.pathToLib' => "Microsoft parancsprogram könyvtár elérési út",
    'asp-dot-net.settings.pathToLibInstall' => "Telepítés",
    'asp-dot-net.settings.reqEnc' => "Kérelem kódolása",
    'asp-dot-net.settings.reqEncInvalid' => "Érvénytelen a megadott Kérelem kódolása paraméter érték.",
    'asp-dot-net.settings.resEnc' => "Válasz kódolása",
    'asp-dot-net.settings.resEncInvalid' => "Érvénytelen a megadott Válasz kódolása paraméter érték.",
    'asp-dot-net.settings.sessTimeout' => "Munkamenet időtúllépés (perc)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Érvénytelen a megadott Munkamenet időtúllépési paraméter érték. %%max%% értékénél kisebb vagy azzal egyenlő pozitív egész számot írjon be.",
    'asp-dot-net.settings.connStringDuplicate' => "Már használatban van a kapcsolódási karakterlánc neve.",
    'asp-dot-net.settings.customErrorInvalidCode' => "100 és 999 között kell az állapotkódnak lennie",
    'asp-dot-net.settings.customErrorDuplicate' => "Már használatban van az állapotkód.",
    'asp-dot-net.settings.trustLevel' => "CAS megbízhatósági szint",
    'asp-dot-net.settings.uiCulture' => "Felhasználói felület nyelve",
    'asp-dot-net.settings.version' => "Verzió",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'CAS megbízhatósági szint felülbírálásának engedélyezése a webhelyen',
    'asp-dot-net.settings.addConnStrings' => 'Kapcsolódási karakterlánc hozzáadása',
    'asp-dot-net.settings.addCustomErrors' => 'Egyéni hiba hozzáadása',
    'asp-dot-net.settings.buttonRemove' => 'Eltávolítás',
    'asp-dot-net.settings.updateSuccess' => 'Sikerült a frissítés.',

    'database.clone.formDescription' => 'Másolja az adatbázis tartalmát egy új vagy meglévő adatbázisra. Egy meglévő adatbázisra történő másolásakor a forrásadatbázis táblázatai hozzáadásra kerülnek a céladatbázis táblázatlistájához. Figyelmeztetés: Ha egybeesnek táblázatnevek, akkor forrásról származó táblázat kerül a cél táblázat helyére.',
    'database.clone.copyData' => 'Egy teljes másolat létrehozása',
    'database.clone.copyDataHint' => 'Ha ki van választva, akkor az egész adatbázis (a struktúrát és adatokat beleértve) másolásra kerül. Ha törölve van, akkor csupán a táblázatok struktúrája kerül másolásra',
    'database.clone.server' => 'Cél adatbázis-kiszolgáló',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Egyéb',
    'database.clone.database' => 'Céladatbázis',
    'database.clone.newDatabase' => 'Következő nevű adatbázis létrehozása',
    'database.clone.existingDatabase' => 'Meglévő adatbázisra másolás',
    'database.clone.externalDbHost' => 'Állomásnév vagy IP-cím',
    'database.clone.externalDbLogin' => 'Felhasználónév',
    'database.clone.externalDbPassword' => 'Jelszó',
    'database.clone.subscription' => 'Célállomás előfizetés',
    'database.clone.subscription_powerUser' => 'Célállomás webtárhelye',
    'database.clone.cloneInProgress' => '%%source%% adatbázis %%destination%% adatbázisra klónozása. E-mailen (%%email%%) keresztül kap értesítést az előrehaladásról.',
    'database.clone.unableToClone' => 'Nem lehetséges "%%source%%" adatbázis másolása.',
    'database.clone.unableToCreateExternalDatabase' => 'Nem lehetséges "%%destination%%" adatbázis létrehozása a megadott kiszolgálón.',
    'database.clone.databaseCloned' => 'Megtörtént "%%source%%" adatbázis másolása.',
    'database.clone.emailSubjSuccess' => 'Megtörtént "%%sourceDatabase%%" adatbázis másolása.',
    'database.clone.emailSubjFailure' => '"%%sourceDatabase%%" adatbázis másolása nem sikerült.',
    'database.clone.emailBodySuccess' => '"%%sourceDatabase%%" (%%sourceHost%%) adatbázis "%%destDatabase%%" (%%destHost%%) adatbázisra másolása megtörént.',
    'database.clone.emailBodyFailure' => 'Nem lehetséges "%%sourceDatabase%%" (%%sourceHost%%) adatbázis "%%destDatabase%%" (%%destHost%%) adatbázisra másolása. Nem sikerült a másolás.',
    'database.clone.localServer' => 'helyi kiszolgáló',

    'database.repair-orphaned.formDescription' => 'Árva lesz e felhasználó a visszaállítást követően. Adjon egy jelszót e felhasználónak e probléma megoldása céljából. Ha feltételezhetően e felhasználó valaki jelszó nélküli felhasználója, akkor üres jelszó mezővel futtassa a hibajavító segédprogramot.',
    'database.repair-orphaned.login' => 'Adatbázis felhasználónév',
    'database.repair-orphaned.pass' => 'Jelszó',
    'database.repair-orphaned.pass2' => 'Jelszó megerősítése',
    'database.repair-orphaned.users' => 'Egyes felhasználókra oda kell figyelnie. Van néhány felhasználó, amelyeket ki kell javítania a megfelelő működésük érdekében.',
    'database.repair-orphaned.orphaned' => 'Árva a felhasználó. %%gui begin:link%%Javítás most%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Javítás',

    'database.repair.fixSelected' => 'Javítás kiválasztva',
    'database.repair.fix' => 'Javítás',

    'database.user.password' => 'Jelszó',
    'database.user.passwordConfirmation' => 'Jelszó megerősítése',
    'database.user.server' => 'Adatbázis-kiszolgáló',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Adatbázis',
    'database.user.anyDatabase' => 'Bármely',
    'database.user.dataAccess' => 'Adatelérés',
    'database.user.structureAccess' => 'Struktúra hozzáférés',
    'database.user.globalAccess' => 'Globális jogosultságok',
    'database.user.globalAccessHint' => 'Ezen üzemeltetési számlán belül a globális jogosultságok érvényesek az összes adatbázisra.',
    'database.user.aclRadio' => 'Hozzáférés-vezérlés',
    'database.user.aclLocalhost' => 'Csak helyi kapcsolatok engedélyezése',
    'database.user.aclAny' => 'Távoli kapcsolatok létesítésének engedélyezése bármelyik állomásról',
    'database.user.aclCustom' => 'Távoli kapcsolatok létesítésének engedélyezése a következő helyről;',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nA megadott állomás számára engedélyezett ezen adatbázishoz e felhasználó nevében történő hozzáférés.",
    'database.user.remoteAccess' => 'Távoli hozzáférés',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nA megadott IP-cím, egy tűzfal szabályon keresztüli hozzáférést tesz lehetővé az adatbázis kiszolgálóhoz. A szolgáltató előzetesen mérlegeli e lista változtatásait.",
    'database.user.example' => "Például:\n%%example%%",
    'database.user.denied' => 'A rendszer tűzfalszabályok használata',
    'database.user.allowed' => 'Távoli kapcsolatok létesítésének engedélyezése a következő helyről;',
    'database.user.default' => 'Alapértelmezés szerint e felhasználó hitelesítő adatait használja %%webadmin%% hozzáféréshez.',
    'database.user.remoteAccessHint' => 'Forduljon az üzemeltetőjéhez és ellenőrizze, hogy a fenti beállítás megfelel-e MySQL-adatbázis bejövő hozzáférésére vonatkozó aktuális tűzfal szabályoknak.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Webfelügyelet',
    'database.user.role' => 'Szerepkör',
    'database.user.roleReadWrite' => 'Olvasás és írás',
    'database.user.roleWriteOnly' => 'Csak írható',
    'database.user.roleReadOnly' => 'Csak olvasható',
    'database.user.roleCustom' => 'Egyéni',

    'database.generalSection' => 'Általános',
    'database.name' => 'Adatbázisnév',
    'database.server' => 'Adatbázis-kiszolgáló',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Kapcsolódó webhelyek',
    'database.noDomainRelations' => 'Nincsenek kapcsolódó webhelyek.',
    'database.userSection' => 'Felhasználók',
    'database.userSectionDescription' => 'Hozzon létre egy alapértelmezett adatbázis-felhasználót. E felhasználó nevében fog az adatbázishoz hozzáférni. Ha nincs adatbázis-felhasználó az adatbázishoz rendelve, akkor ahhoz nem lehet hozzáférni.',
    'database.createUser' => 'Egy adatbázis-felhasználó létrehozása',
    'database.username' => 'Adatbázis-felhasználó neve',
    'database.password' => 'Jelszó',
    'database.passwordConfirmation' => 'Jelszó megerősítése',
    'database.allDbAccess' => 'A kiválasztott előfizetéseken belül az összes adatbázishoz hozzáférése van a felhasználónak.',
    'database.aclRadio' => 'Hozzáférés-vezérlés',
    'database.aclLocalhost' => 'Csak helyi kapcsolatok engedélyezése',
    'database.aclAny' => 'Távoli kapcsolatok létesítésének engedélyezése bármelyik állomásról',
    'database.aclCustom' => 'Távoli kapcsolatok létesítésének engedélyezése a következő helyről;',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nA megadott állomás számára engedélyezett ezen adatbázishoz e felhasználó nevében történő hozzáférés.",
    'database.remoteAccess' => 'Távoli hozzáférés',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nA megadott IP-cím, egy tűzfal szabályon keresztüli hozzáférést tesz lehetővé az adatbázis kiszolgálóhoz. A szolgáltató előzetesen mérlegeli e lista változtatásait.",
    'database.example' => "Például:\n%%example%%",
    'database.denied' => 'A rendszer tűzfalszabályok használata',
    'database.allowed' => 'Távoli kapcsolatok létesítésének engedélyezése a következő helyről;',

    'deployment-section.deploymentDisabledHint' => 'Fájlok Git tárolóból feltöltése',
    'deployment-section.deploymentEnabledHint' => 'Git támogatás engedélyezése',
    'deployment-section.deploymentSectionLegend' => 'Üzemeltetés számára másolandó fájljai',
    'deployment-section.deploymentSectionDescriptionHint' => 'Ha letiltva hagyja a Git támogatást, akkor üresen kerülnek létrehozásra a gyökérkönyvtárak (webhely/alkalmazás- és dokumentumgyökér) és az alapértelmezett oldal kerül megjelenítésre a böngészőben. FTP vagy Fájlkezelő használatával kell webhelye fájlait a dokumentumgyökérbe feltölteni. Másik lehetőségként engedélyezze most vagy később a Git működését (Webhelyekben és domainekben) és egy Git tárolóból végezze a fájlok feltöltését.',

    'dns-zone.add-acl-record.description' => 'Végezze el egy olyan DNS-kiszolgáló IP-címének hozzáadását, mely kiszolgáló számára engedélyezett a DNS-zóna másolatának fogadása.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-cím',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-cím/maszk',

    'dns-zone.record.add-title' => "Erőforrás rekord zónasablonhoz adása",
    'dns-zone.record.add-ns-title' => "Névkiszolgáló hozzáadása",
    'dns-zone.record.edit-title' => "Erőforrás rekord szerkesztése",
    'dns-zone.record.edit-success' => "Frissítve lett a DNS-rekord.",
    'dns-zone.record.add-success' => "Létre lett hozva a DNS-rekord.",
    'dns-zone.record.type' => "Rekordtípus",
    'dns-zone.record.domainName' => "Domain név",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Névkiszolgáló",
    'dns-zone.record.protocol' => "Protokoll",
    'dns-zone.record.priority' => "Prioritás",
    'dns-zone.record.priorityLow' => "alacsony (%%priority%%)",
    'dns-zone.record.priorityHigh' => "nagyon magas (%%priority%%)",
    'dns-zone.record.weightLow' => "alacsony (%%weight%%)",
    'dns-zone.record.weightHigh' => "nagyon magas (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-cím",
    'dns-zone.record.ipAddressDescription' => "Például, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Például, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6-cím",
    'dns-zone.record.ipAddressV6Description' => "Például, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Például, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Például, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Például, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Például, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Kanonikus név",
    'dns-zone.record.mailDomain' => "Levelezési domain",
    'dns-zone.record.mxServer' => "Levelezési adatcsere kiszolgáló",
    'dns-zone.record.mxServerPriority' => "Adja meg a levelezési adatcsere kiszolgáló prioritását.",
    'dns-zone.record.txtRecord' => "TXT-rekord",
    'dns-zone.record.txtRecordString' => "Írjon be rekord karakterláncot",
    'dns-zone.record.txtSpfSyntax' => "SPF-rekord",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Helytelen TXT-rekord értékek kerültek megadásra.",
    'dns-zone.record.dsRecord' => "DS-rekord",
    'dns-zone.record.dsRecordDescription' => "Például, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "Helytelen DS-rekord érték került megadásra.",
    'dns-zone.record.serviceName' => "Szolgáltatás neve",
    'dns-zone.record.serviceNameDescription' => 'Például: SIP (az aláhúzásjel karakter nélkül).',
    'dns-zone.record.protocolNameDescription' => 'Például: tcp (az aláhúzásjel karakter nélkül).',
    'dns-zone.record.portDescription' => 'Például: 25 (az aláhúzásjel karakter nélkül).',
    'dns-zone.record.srvWeight' => "Azonos prioritású rekordok relatív súlya",
    'dns-zone.record.targetHost' => "Célállomás",
    'dns-zone.record.targetHostDescription' => "Például, example.com",
    'dns-zone.record.targetPort' => "Célport",
    'dns-zone.record.retrieveDataError' => "Nem találhatóak a rekordadatok.",
    'dns-zone.record.unknownTypeError' => "Ismeretlen DNS-rekord típus.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Addig nem állítható be nincs levelező-kiszolgáló erőforrás rekord, amíg más levelező-kiszolgáló rekordok jelen vannak.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Addig nem állítható be nincs levelező-kiszolgáló erőforrás rekordtól eltérő rekord, amíg nincs levelező-kiszolgáló erőforrás rekord jelen van.',
    'dns-zone.record.masterShouldBeRemote' => "Két különböző mérvadó névkiszolgálóval kell rendelkeznie különböző állomásokon.",
    'dns-zone.record.caaTag' => "Címke",
    'dns-zone.record.caaRecord' => "Érték",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protokoll',
    'dns-zone.record.tlsaUsage' => 'Használat',
    'dns-zone.record.tlsaSelector' => 'Választó',
    'dns-zone.record.tlsaMatching' => 'Egyezés típusa',
    'dns-zone.record.tlsaCertData' => 'Tanúsítvány társítási adatok',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'A részletekért lásd %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, 2.1.1 rész',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, 2.2.1 rész',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, 3.2.1 rész',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, 4.2.1 rész',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Másodperc",
    'dns-zone.record.invalidValue' => 'Érvénytelen az érték. 1 és 2147483647 másodperc közötti érték lehet.',
    'dns-zone.record.ttlDefaultValue' => 'Alapértelmezett érték: %%value%% másodperc',
    'dns-zone.record.invalidTTL' => 'Érvénytelen a megadott TTL-érték.',
    'dns-zone.record.invalidIpAddress' => 'Érvénytelen a megadott cím.',
    'dns-zone.record.invalidIpMaskPair' => 'Érvénytelen a megadott IP-cím/hálózati maszk pár.',
    'dns-zone.record.invalidCName' => 'Érvénytelen a megadás kanonikus név.',
    'dns-zone.record.invalidPort' => 'Érvénytelen a megadott port.',
    'dns-zone.record.invalidTLSACertData' => 'Érvénytelenek a megadott társítási adatok.',
    'dns-zone.record.invalidTLSAProtocol' => 'Érvénytelen a megadott protokoll.',
    'dns-zone.record.invalidTLSAUsage' => 'Érvénytelen a megadott használat.',
    'dns-zone.record.invalidTLSASelector' => 'Érvénytelen a megadott választó.',
    'dns-zone.record.invalidTLSAMatching' => 'Érvénytelen a megadott egyezési típus.',

    'dns-zone.restore-default.formHint' => "A kiszolgálón használt alapértelmezett DNS-sablon beállításoknak megfelelően, itt elvégezheti az eredeti zónakonfiguráció visszaállítását. Válassza ki a zóna visszaállításnál használandó IP-címeket és adja meg, hogy szükséges-e a domain számára egy www alias.",
    'dns-zone.restore-default.ipv4' => "IPv4-cím",
    'dns-zone.restore-default.ipv4Hint' => "Például, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6-cím",
    'dns-zone.restore-default.ipv6Hint' => "Például, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Érvénytelen a megadott cím.',
    'dns-zone.restore-default.customIpHint' => "Felhasználó által módosítottnak tekintettek ezen IP-címmel rendelkező rekordok és nem történik meg az egész kiszolgálóra érvényes DNS-sablonnal a szinkronizálásuk.",
    'dns-zone.restore-default.wwwPrefix' => "www prefix",
    'dns-zone.restore-default.previewRecords' => "Állítsa vissza a kiválasztott webhely előnézethez használt rekordokat.",

    'dns-zone.soa-record.soaMnameSection' => 'Elsődleges névkiszolgáló',
    'dns-zone.soa-record.soaMname' => 'Névkiszolgálók',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Automatikus kiválasztás)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA-rekord',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Frissítés',
    'dns-zone.soa-record.retry' => 'Újból',
    'dns-zone.soa-record.expire' => 'Lejár',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'E mail (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'A domain DNS-zónáért felelős személy e-mail címe. Amelyet a zónára vonatkozó információk lekérdezéseire válaszként a DNS-kiszolgáló visszaküldött.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Webhely tulajdonos e-mail címe',
    'dns-zone.soa-record.rnameTypeDomain' => 'Domain e-mail címe',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Csak a helyi részt írja be (a @<domain> előtti részt)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Külső e-mail cím',
    'dns-zone.soa-record.rnameEnforceEmail' => 'RNAME e-mail cím változtatásának megtiltása domainenként',
    'dns-zone.soa-record.invalidValue' => 'Érvénytelen az érték. 1 másodperc és 68 év közötti érték lehet.',
    'dns-zone.soa-record.advancedSection' => 'Speciális DNS funkciók',
    'dns-zone.soa-record.serialNumberFormat' => 'Az IETF és az RIPE által ajánlott sorozatszám formátumot használja.',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Akkor válassza ki a beállítást, ha problémája van a regisztrálója zónára vonatkozó információinak az átadásával. Sok domain regisztráló ezt a sorozatszám formátumot igényli.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Alapértelmezett beállítások használata',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Zóna alapértelmezései',
    'dns-zone.soa-record.unitSeconds' => 'másodperc',
    'dns-zone.soa-record.unitMinutes' => 'perc',
    'dns-zone.soa-record.unitHours' => 'óra',
    'dns-zone.soa-record.unitDays' => 'nap',
    'dns-zone.soa-record.unitWeeks' => 'hét',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Egy óránál rövidebb a frissítési időköz, mely kritikusan növelheti a kiszolgáló forgalmi és erőforrás kihasználtságát.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'A 3 órát meghaladó minimális TTL érték beállítása néhány domain adminisztrátor számára elérhetetlenné teheti a domainjeit. Csak akkor ajánlott ilyen érték beállítása, ha már tartalmazza a domain név nyilvántartása.',
    'dns-zone.soa-record.success' => 'Megtörtént az SOA-rekord tulajdonságainak a frissítése.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Megtörtént az alapértelmezett SOA-rekord visszaállítása.',

    'domain-info-section.domainName' => 'Domain név',
    'domain-info-section.emptyDomainName' => 'Adjon meg egy domain nevet.',
    'domain-info-section.ipAddress' => 'IP-cím',
    'domain-info-section.shared' => 'megosztva',
    'domain-info-section.exclusive' => 'dedikált',
    'domain-info-section.ipAddressHint' => "A webhely virtuális állomásának egy hálózati címe azon IP-cím, melyen a webhely üzemeltetése történik. Ezen IP-cím használatos az előfizetésen belül létrehozott összes webhely esetében.",
    'domain-info-section.ipAddressHint_powerUser' => "A webhely virtuális állomásának egy hálózati címe azon IP-cím, melyen a webhely üzemeltetése történik. Ezen IP-cím használatos a webtárhelyen belül létrehozott összes webhely esetében.",
    'domain-info-section.userName' => 'Felhasználónév',
    'domain-info-section.userNameHint' => 'Egy olyan webtárhellyel társított rendszerfelhasználói fiók, melyet FTP-és SSH-szolgáltatáson keresztül üzemeltetett fájlokhoz férésre használnak.',
    'domain-info-section.emptyLogin' => 'Adjon meg egy felhasználónevet.',
    'domain-info-section.password' => 'Jelszó',
    'domain-info-section.emptyPassword' => 'Adjon meg egy jelszót.',
    'domain-info-section.passwordConfirmation' => 'Jelszó ismétlése',

    'email-address.generalTab' => 'Általános',
    'email-address.generalHint' => 'Ha ezen e-mail fiók társítva van egy további felhasznállóval, akkor ezen az oldalon végzett változtatásai érintik a felhasználói beállításokat. (Engedélyezve van az Ügyfél kezelőpanelhez a hozzáférés.). Különösen, ha megváltoztatja az e-mail címet és jelszót, akkor a további felhasználó bejelentkezési neve és jelszava is az új értékre változik.',
    'email-address.redirectTab' => 'Továbbítás',
    'email-address.redirectHint' => 'Végezze el az e-mail üzenetek egy vagy több e-mail címre továbbításának beállítását.',
    'email-address.aliasesTab' => 'E-mail aliasok',
    'email-address.autoResponderTab' => 'Automatikus válasz',
    'email-address.antispamTab' => 'Levélszemét szűrő',
    'email-address.autoResponderHint' => 'Állítson be egy automatikus választ az e-mail címére érkező üzenetek számára. Az automatikus válasz partnerei értesítésének egy szokásos módja arról, hogy az irodán kívül tartózkodik vagy szabadságon van.',
    'email-address.antivirusTab' => 'Vírusvédelem',
    'email-address.name' => 'E-mail cím',
    'email-address.externalEmail' => 'Külső e-mail cím',
    'email-address.externalEmailHint' => 'Új jelszó megadására szolgál, ha megszűnik az elsődleges e-mail címéhez a hozzáférés.',
    'email-address.user' => 'Hozzárendelve a következőhöz;',
    'email-address.password' => 'Jelszó',
    'email-address.passwordConfirmation' => 'Jelszó megerősítése',
    'email-address.responderEnable' => 'Automatikus válasz beikapcsolása',
    'email-address.responderSubject' => 'Automatikus válaszüzenet szövege',
    'email-address.responderContentType' => 'Üzenet formátuma',
    'email-address.responderContentTypeHint' => 'Az egyszerű szöveg formátumot támogatja az összes levelezési ügyfélprogram, így valamennyi címzett ugyanúgy látja, az üzenetet, mint Ön. Előnyösebb a HTML-üzenetek megjelenése, mivel különböző betűstílusú formázott szövegek beírására van lehetősége. Azonban egyes levelezési ügyfélprogramok nem támogatják a HTML-üzeneteket és így előfordulhat, hogy egyes címzettek nem látják a formázott szöveget.',
    'email-address.responderContentTypeTextPlain' => 'Egyszerű szöveg',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Kódolás',
    'email-address.responderCodepageHint' => 'A szöveges karakterek megjelenítését határozza meg a kódolás  Az UTF-8 az ajánlott kódolás.',
    'email-address.responderReplyTo' => 'Továbbítás a következőre;',
    'email-address.responderReplyToHint' => 'Az automatikus válasz elküldése után, a megadott e-mail címre történik az eredeti üzenet továbbítása.',
    'email-address.responderForwardAddress' => 'Továbbítás a következőre;',
    'email-address.responderForwardAddressHint' => 'Az automatikus válasz elküldése után, a megadott e-mail címre történik az eredeti üzenet továbbítása.',
    'email-address.responderMessage' => 'Automatikus válaszüzenet szövege',
    'email-address.responderReplyToEqualsEmail' => 'A megadott továbbítási cím megegyezik ezen e-mail címmel.',
    'email-address.responderForwardAddressEqualsEmail' => 'A megadott továbbítási cím megegyezik ezen e-mail címmel.',
    'email-address.responderReplyLimit' => 'Automatikus válasz egyedi e-mail címre küldése nem többször, mint (naponta a következő számú alkalommal)',
    'email-address.buttonAddResponderAttachment' => 'Egy melléklet hozzáadása',
    'email-address.buttonRemoveResponderAttachment' => 'Eltávolítás',
    'email-address.responderAttachment' => 'Fájlok mellékelése',
    'email-address.redirectEnable' => 'E-mail továbbítás bekapcsolása',
    'email-address.redirectRemoveEnable' => 'Ne szállítsa a továbbított e-mailek másolatait a Plesk postaládába',
    'email-address.redirectAddress' => 'Bejövő üzenetek következő címre e-mail továbbítása',
    'email-address.redirectAddressHint' => 'Adjon meg e-mail címeket. Új sorba írhatja az egyes címeket, továbbá szóközzel, vesszővel vagy pontosvesszővel választhatja el azokat.',
    'email-address.role' => 'Felhasználói szerepkör',
    'email-address.roleHint' => 'A felhasználói szerepkörök adminisztrátori jogokat, továbbá az Ön által kiválasztott alkalmazásokhoz hozzáférést biztosítanak a felhasználóknak.',
    'email-address.errorRedirectAddress' => 'Érvénytelen e-mail címet adott meg: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Érvénytelen e-mail címeket adott meg: %value%.',
    'email-address.mailAlias' => "E-mail alias",
    'email-address.mailAliasNone' => 'Nincs',
    'email-address.mailAliasHint' => "Az elsődleges e-mail címhez társított alternatív e-mail címek az e-mail aliasok. Az összes e-mail alias számára küldött e-mail fogadása az elsődleges e-mail címen történik.",
    'email-address.buttonAddMailAlias' => 'Domain aliasok hozzáadása',
    'email-address.buttonRemoveMailAlias' => 'Eltávolítás',
    'email-address.emptyEmail' => 'Adja meg azon e-mail címet, melyre az összes bejövő üzenetet továbbítani kell.',
    'email-address.emailsIsEqual' => 'Egyezik az elsődlegessel a külső e-mail cím. Eltérő e-mail címet adjon meg.',
    'email-address.emptyPassword' => 'Biztosítania kell egy jelszót.',
    'email-address.emptyPasswordConfirmation' => 'Meg kell erősítenie a jelszót.',
    'email-address.emptyAlias' => "Adjon meg e-mail alias ezen e-mail cím számára.",
    'email-address.aliasEqualsEmail' => 'Megegyezik az e-mail címmel a megadott e-mail alias.',
    'email-address.passwordHint' => 'A postaládához és a Plesk kezelőpanelhez hozzáféréshez használatos (ha engedélyezve van a megfelelő beállítás).',
    'email-address.cyclicRedirect' => 'Nem állítható be úgy e-mail cím, hogy magának továbbítsa az e-mail üzeneteket.',
    'email-address.errorMailnameReserved' => 'A megadott e-mail cím már használatban van.',
    'email-address.antivirusEnable' => 'Kapcsolja be a levélszemét szűrést ezen e-mail cím esetében.',
    'email-address.antivirusHint' => 'A vírusvédelmi szolgáltatás blokkolja a vírusokat tartalmazó üzeneteket, majd értesíti erről a küldőt és a fogadót is.',
    'email-address.antivirusSettings' => 'Vírusellenőrzés',
    'email-address.antivirusSettingOnlyIncomingMail' => 'csak bejövő levél',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'csak kimenő levél',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'bejövő és kimenő levél',
    'email-address.antispamHint' => 'A levélszemét szűrés szolgáltatás az e-mail címre küldött levélszemét üzeneteket észlel. Beállíthatja a Levélszemét szűrőt úgy, hogy törölje a levélszemét üzeneteket, a tárgysor megváltoztatásával jelölje levélszemétként azokat vagy az IMAP levelezési ügyfélprogrammal elérhető speciális levélszemét mappába helyezheti át azokat. Helyi és hálózati tesztek széles választékát használja levélszemét aláírások azonosítására a Levélszemét szűrő.',
    'email-address.antispamEnable' => 'Kapcsolja be a levélszemét szűrést ezen e-mail cím esetében.',
    'email-address.antispamSettings' => 'A levélszemétként besorolt üzenettel kapcsolatos teendő',
    'email-address.antispamSettingsMark' => 'A következő szöveg tárgysorhoz adásával jelölje levélszemét üzeneteket.',
    'email-address.antispamSettingsMarkHint' => 'Hagyja üresen e mezőt, ha nem akar szöveget hozzáadni. Írja be a _SCORE_ változót, ha azt akarja, hogy megjelenjen a pontszám az üzenet szövegmezejében.',
    'email-address.antispamReportTextHint' => 'Írja be a levélszemét e-mail üzenet törzséhez adandó szöveget.',
    'email-address.antispamSettingsDelete' => 'Az összes levélszemét üzenet törlése',
    'email-address.antispamSettingsDeleteHint' => 'A postaládájából törlésre kerülnek a levélszemét üzenetek.',
    'email-address.antispamSettingsMove' => 'A levélszemé Levélszemét mappába helyezése',
    'email-address.antispamSettingsMoveHint' => 'Helyezze át az összes levélszemét üzenetet az úgynevezett Levélszemét mappába. A levelezési ügyfélprogramjából vagy a webes levelezés útján érhető el ezen mappa. Ha egy IMAP-postafiókot használ, akkor a Levélszemét mappát használhatja a a levélszemét szűrő betanítására.',
    'email-address.antispamSettingsMoveWarning' => 'Nem áll rendelkezésre „A levélszemét Levélszemét mappába helyezése” művelet, ha nem tiltja le a „Továbbítás” lapon a „Továbbított e-mailek másolatainak a szállítása” beállítást.',
    'email-address.antispamSettingsMoveJunk' => 'A levélszemét „Levélszemét” mappába helyezése',
    'email-address.antispamSettingsMoveJunkHint' => 'Helyezze át az összes levélszemét üzenetet a „Levélszemét” mappába. A levelezési ügyfélprogramjából vagy a webes levelezés útján érhető el ezen mappa. Ha egy IMAP-postafiókot használ, akkor a „Levélszemét” mappát használhatja a levélszemét szűrő betanítására.',
    'email-address.antispamShowAdvancedSection' => 'Speciális beálíltások megjelenítése',
    'email-address.antispamHideAdvancedSection' => 'Speciális beállítások elrejtése',
    'email-address.antispamLearnMore' => 'Ismerje meg a levélszemét szűrő betanításának a módját.',
    'email-address.antispamFilterScoreTitle' => 'Szűrő érzékenysége',
    'email-address.antispamFilterScoreHint' => 'A Levélszemét szűrű számos tartalom és címsor ellenőrzést hajt végre az egyes üzenetek esetében. Ennek eredményeképpen mindegyik üzenet egy pontszámoz kap. Minél magasabb a pontszám, annál valószínűbb, hogy levélszemét az üzenet. Alapértelmezés szerint minden 7 vagy annál több pontot kapott üzenet levélszemétnek minősül. Ha sok levélszemét üzenetet kap az aktuális beállításnál, akkor próbáljon ki egy alacsonyabb értéket, például 6-ot. Ha e-mailt veszít el, mivel levélszemétnek minősíti a Levélszemét szűrő, akkor egy magasabb érték, például 8, beállításával próbálja csökkenteni a szűrő érzékenységét.',
    'email-address.antispamFilterScore' => 'Levélszemét szűrő érzékenysége',
    'email-address.antispamWhiteListTitle' => 'Engedélyezési lista',
    'email-address.antispamWhiteListHint' => 'Nem ellenőrzi a levélszemét szűrő az engedélyezési listán szereplő küldőktől származó e-maileket.',
    'email-address.antispamWhiteListField' => 'Engedélyezési lista',
    'email-address.antispamWhiteListFieldHint' => 'Soronként írja be a domain neveket. A „*” és „?” helyettesítő karakterek szerepelhetnek a címekben, például *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Tiltólista',
    'email-address.antispamBlackListHint' => 'Levélszemét minősítést kapnak a tiltólistán szereplő küldőktől származó üzenetek.',
    'email-address.antispamBlackListField' => 'Tiltólista',
    'email-address.antispamBlackListFieldHint' => 'Soronként írja be a domain neveket. A „*” és „?” helyettesítő karakterek szerepelhetnek a címekben, például *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Megbízható nyelvek',
    'email-address.antispamTrustedLanguagesHint' => 'E nyelven írt e-mail üzenetek minden esetben átmennek a levélszemét szűrőn.',
    'email-address.antispamTrustedLocalesTitle' => 'Megbízható helyek',
    'email-address.antispamTrustedLocalesHint' => 'Megadott helyi csoportokat használó e-mail üzenetek minden esetben átmennek a levélszemét szűrőn. A helyi csoportok magukban foglalják a leggyakrabban használt karakterkészleteket. Például, a nyugati karakterkészlet az angolban és a nyugati nyelvekben használt karaktereket foglalja magában.',
    'email-address.antispamTrustedNetworksTitle' => 'Megbízható hálózatok',
    'email-address.antispamTrustedNetworksHint' => 'A megbízható hálózatokon található továbbító állomásokról úgy gondolják, hogy azokat vélhetően nem levélszemétküldők üzemeltetik és azok nem nyílt továbbítók vagy proxyk.',
    'email-address.antispamIpAddressesField' => 'IP-címek',
    'email-address.antispamIpAddressesFieldHint' => 'Adja meg a hálózati IP-címet és maszkot.',
    'email-address.mailBoxQuotaDomainDefault' => 'Alapértelmezett méret (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Alapértelmezett méret',
    'email-address.mailBoxOutgoingMessages' => 'A kimenő e-mail üzenetek maximális száma',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Alapértelmezett (%%domainOutgoingMessages%% üzenet óránként)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Egyéni érték postaláda számára',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'üzenetek',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Alapértelmezett',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Alapértelmezett méret',
    'email-address.mailBoxQuotaDomainSpecific' => 'Másik méret',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Postaláda méret',
    'email-address.mailBoxQuotaUnlimited' => 'Korlátlan',
    'email-address.mailBoxLimitReached' => 'Elérésre került a levélszekrény korlát.',
    'email-address.postboxEnabled' => 'Postaláda',
    'email-address.postboxEnabledYes' => 'Be',
    'email-address.postboxEnabledNo' => 'Ki',
    'email-address.description' => 'Leírás a Plesk kezelőpanelben',
    'email-address.descriptionHint' => 'Mindenki láthatja a leírást, akinek ezen a-mail fiókhoz hozzáférése van.',
    'email-address.longDescription' => 'Túl hosszú a megadott leírás. Nem haladhatja meg %%max%% szimbólumszámot.',
    'email-address.loginAsUser' => 'A Plesk kezelőpanelbe bejelentkezéshez használható.',
    'email-address.loginAsUserDescription' => '(felhasználónév: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Nem haladhatja meg a postaláda mérete az alapértelmezett méretet.',
    'email-address.endDateEnable' => 'Működő automatikus válasz kikapcsolási dátuma',

    'failed-request.enable-tracing.description' => 'A Sikertelen kérelmek nyomkövetése egy erőforrás-igényes művelet. %%days%% nap elteltével automatikusan leállítára kerül a követés. Kézzel bármikor leállíthatja.',
    'failed-request.enable-tracing.statusCodes' => 'Állapotkódok',
    'failed-request.enable-tracing.statusCodesDescription' => 'Példa 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Szolgáltató',

    'file-manager.show.buttonReload' => 'Újrabetöltés',
    'file-manager.show.buttonSave' => 'Mentés',
    'file-manager.show.buttonSaveAs' => 'Mentés másként',
    'file-manager.show.buttonReset' => 'Alaphelyzetbe állítás',
    'file-manager.show.buttonTextCodeEditor' => 'Kódszerkesztőben szerkesztés',
    'file-manager.show.buttonTextEdit' => 'Szövegszerkesztőben szerkesztés',
    'file-manager.show.buttonWysiwygEdit' => 'HTML-szerkesztőben szerkesztés',
    'file-manager.show.eolLabel' => 'Sortörés típus:',
    'file-manager.show.saveAs' => 'Mentés másként:',
    'file-manager.show.saveCodepage' => 'Mentés a következő kódolásban:',
    'file-manager.show.loadCodepage' => 'A következő kódolásban nézze meg az eredeti fájlt:',
    'file-manager.show.loadCodepageHint' => 'Figyelmeztetés: A fájl újbóli betöltésekor elvesznek a mentetlen változtatások.',
    'file-manager.show.fileExists' => "%%fileName%% fájl vagy mappa már létezik. Nem rendelkezhet megegyező nevű mappával és fájllal.",
    'file-manager.show.popupTitle' => 'Mentés másként',
    'file-manager.show.popupFilename' => 'Fájlnév:',

    'file-manager.permissions.filePermissions' => 'Fájlengedélyek',
    'file-manager.permissions.directoryPermissions' => 'Könyvtár engedélyek',
    'file-manager.permissions.buttonSubmit' => 'Mentés',
    'file-manager.permissions.buttonApply' => 'Mentés és folytatás',
    'file-manager.permissions.buttonCancel' => 'Mégse',
    'file-manager.permissions.buttonAdvanced' => 'Speciális',

    'file-manager.unix-file-permissions.group' => 'Csoport',
    'file-manager.unix-file-permissions.owner' => 'Tulajdonos',
    'file-manager.unix-file-permissions.others' => 'Egyebek',
    'file-manager.unix-file-permissions.readMode' => 'Olvasás',
    'file-manager.unix-file-permissions.writeMode' => 'Írás',
    'file-manager.unix-file-permissions.execMode' => 'Végrehajtás/keresés',
    'file-manager.unix-file-permissions.changeRecursive' => 'Engedélyek rekurzív változtatása',

    'file-manager.windows-permissions.allow' => 'Engedélyezés',
    'file-manager.windows-permissions.deny' => 'Megtagadás',
    'file-manager.windows-permissions.inheritFromParent' => 'A szülőtől örökölhető engedélyek kiterjesztése ezen objektumra és az összes gyermekobjektumra történő származtatás céljából. Ezek belefoglalása az itt pontosan meghatározott bejegyzésekkel együtt',
    'file-manager.windows-permissions.replaceOnChildren' => 'Az összes gyermekobjektum engedély bejegyzésének az itt megjelenített bejegyzésekre cserélése',
    'file-manager.windows-permissions.buttonAdvanced' => 'Speciális',
    'file-manager.windows-permissions.applyTo' => 'Alkalmazás a következőre:',
    'file-manager.windows-permissions.folderOnly' => 'Csak e mappa',
    'file-manager.windows-permissions.subfolderOnly' => 'Csak almappák',
    'file-manager.windows-permissions.filesOnly' => 'Csak fájlok',
    'file-manager.windows-permissions.permissionsFor' => 'Következőre szóló engedély',
    'file-manager.windows-permissions.applyOnto1' => 'Csak e mappa',
    'file-manager.windows-permissions.applyOnto2' => 'Csak almappák',
    'file-manager.windows-permissions.applyOnto3' => 'E mappa és almappák',
    'file-manager.windows-permissions.applyOnto4' => 'Csak fájlok',
    'file-manager.windows-permissions.applyOnto5' => 'E mappa és fájlok',
    'file-manager.windows-permissions.applyOnto6' => 'Csak almappák és fájlok',
    'file-manager.windows-permissions.applyOnto7' => 'E mappa, almappák és fájlok',
    'file-manager.windows-permissions.notInherited' => '<nem örökölt>',

    'file-manager.editor.titleTextEditor' => 'Szövegszerkesztő',
    'file-manager.editor.titleCodeEditor' => 'Kódszerkesztő',
    'file-manager.editor.titleCodeViewer' => 'Nézet',
    'file-manager.editor.buttonSubmit' => 'Mentés',
    'file-manager.editor.buttonApply' => 'Mentés és folytatás',
    'file-manager.editor.buttonSaveAs' => 'Mentés másként',
    'file-manager.editor.buttonCancel' => 'Mégse',
    'file-manager.editor.exitConfirmationYes' => 'Igen',
    'file-manager.editor.exitConfirmationNo' => 'Nem',
    'file-manager.editor.fileOverwrite' => 'Már létezik a fájl.',
    'file-manager.editor.fileOverwriteDescription' => 'Ugyanolyan nevű fájl már létezik. Felül akarja írni?',
    'file-manager.editor.exitConfirmation' => 'Biztosan be akarja zárni a fájlt és el akarja vetni a mentetlen változtatásokat?',
    'file-manager.editor.buttonCodeEditor' => 'Kódszerkesztőben szerkesztés',
    'file-manager.editor.buttonTextEditor' => 'Szövegszerkesztőben szerkesztés',
    'file-manager.editor.buttonHtmlEditor' => 'HTML-szerkesztőben szerkesztés',

    'file-manager.import-file.buttonSubmit' => 'Importálás',
    'file-manager.import-file.fieldUrl' => 'Fájl URL-címe',
    'file-manager.import-file.fieldUrlDescription' => 'Adja meg a forrás URL-címét, például, „https://example.com/example.tgz”.',
    'file-manager.import-file.fieldUrlFullDescription' => 'A következő a teljes URL-cím felépítése: „https://user:password@example.com/example.tgz”. A felhasználónév és a jelszó választható. A http, https, ftp, ftps a támogatott protokollok. Használja az URL-kódolást az olyan URL-cím részeknél, amelyek speciális karaktereket vagy szóközt tartalmaznak.',
    'file-manager.import-file.failure' => 'Nem lehetséges a fájl importálása.',

    'file-manager.rotation-settings.title' => 'Lomtár forgatási beállítások',
    'file-manager.rotation-settings.rotationBySize' => 'Méret szerinti forgatás',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'A lomtár meghatározott korlátjának túllépése esetén a beállítás töröl minden új fájlt.',
    'file-manager.rotation-settings.rotationByDate' => 'Dátum szerinti forgatás',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Nap',
    'file-manager.rotation-settings.rotationByDateHint' => 'A megadott napszámnál több a lomtárban tárolt fájlt töröl a beállítás.',

    'ftp-user.description' => 'Ha a webhelyén együtt dolgozik valaki mással vagy más felhasználók állomás aldomainjeit használja, akkor külön FTP-fiókokat hozhat létre a számukra.',
    'ftp-user.generalSection' => 'Általános',
    'ftp-user.login' => 'FTP-fiók neve',
    'ftp-user.home' => 'Kezdőkönyvtár',
    'ftp-user.systemArea' => 'A kezdőkönyvtáron kívüli fájlokhoz hozzáféréssel rendelkező FTP-fiók létrehozása',
    'ftp-user.password' => 'Jelszó',
    'ftp-user.passwordConfirmation' => 'Jelszó megerősítése',
    'ftp-user.hardQuotaSection' => 'Merevlemez kvóta',
    'ftp-user.hardQuota' => 'Merevlemez kvóta',
    'ftp-user.hardQuotaUnlimited' => 'Korlátlan',
    'ftp-user.permissionsSection' => 'Engedélyek',
    'ftp-user.permissionRead' => 'Olvasási engedély',
    'ftp-user.permissionWrite' => 'Írási engedély',
    'ftp-user.popupTitle' => 'Könyvtár kiválasztása',

    'mail-list.listName' => 'Levelezési lista cím',
    'mail-list.enabled' => 'Bekapcsolva',
    'mail-list.administratorEmail' => 'Levelezési lista adminisztártor e-mailje',
    'mail-list.password' => 'Jelszó',
    'mail-list.passwordConfirmation' => 'Jelszó megerősítése',
    'mail-list.subscribers' => 'Előfizetők',
    'mail-list.subscribersHint' => 'Adjon meg e-mail címeket. Új sorba írhatja az egyes címeket, továbbá szóköz, vessző vagy pontosvessző szimbólummal választhatja el azokat.',
    'mail-list.notify' => 'Adminisztrátor értesítése levelezési lista létrehozásáról',
    'mail-list.emptyPassword' => 'Adjon meg egy jelszót.',
    'mail-list.emptyPasswordConfirmation' => 'Erősítse meg a jelszót.',
    'mail-list.errorSubscribers' => 'Érvénytelen e-mail címek: %value%.',
    'mail-list.errorMaillistReserved' => 'Már használatban van a megadott levelezési lista cím.',

    'mail-settings.hint' => 'Itt meg tudja változtatni e domain levelezési szolgáltatás beállításait.',
    'mail-settings.service' => 'Levelezési szolgáltatás e domainen',
    'mail-settings.nonExist' => 'Nem létező felhasználók e-mailjeivel a teendő',
    'mail-settings.nonExistBounceWithMessage' => 'Visszapattanó üzenet',
    'mail-settings.nonExistBounce' => 'Pattogás',
    'mail-settings.nonExistCatch' => 'Címre továbbítás',
    'mail-settings.nonExistCatchDescription' => 'A kiválasztott domainhez kell a címnek tartoznia. Kizárólag az adminisztrátor adhat meg egy külső címet vagy több domain számára egy címet.',
    'mail-settings.nonExistExternal' => 'Az IP-címmel rendelkező külső levelezési kiszolgálóra átirányítás',
    'mail-settings.nonExistReject' => 'Elutasítás',
    'mail-settings.nonExistDiscard' => 'Elutasítás',
    'mail-settings.webmail' => 'Webes levelezés',
    'mail-settings.webmailNone' => 'Nincs',
    'mail-settings.webmailComponentNotInstalled' => 'Nincs telepítve a webes levelezés összetevő.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Nincs %%subdomain%% nevű aldomain.',
    'mail-settings.webmailCertificate' => 'Webes levelezés SSL/TLS tanúsítvány',
    'mail-settings.webmailCertificateNone' => 'Nincs kiválasztva.',
    'mail-settings.mailCertificate' => 'Levelezési SSL/TLS-tanúsítvány',
    'mail-settings.mailCertificateNone' => 'Nincs kiválasztva.',
    'mail-settings.serverCertificateNotSelected' => 'Megtörtént a tanúsítvány hozzárendelés, azonban nem biztonságos a .domain esetén a levelezés. A domain levelezés biztonságossá tétele befejezéséhez, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'levelezési kiszolgáló biztonságossá tétele',
    'mail-settings.mailLists' => 'Levelezési listák engedélyezése',
    'mail-settings.mailAutodiscovery' => 'E-mail automatikus konfigurálásának engedélyezése',
    'mail-settings.mailAutodiscoveryDescription' => '%%link%% segítségével nézze meg a működését.',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'Tudásbázis',
    'mail-settings.domainKeys' => 'A DKIM levélszemét elleni védelmi rendszer használata kimenő e-mail üzenetek aláírására',
    'mail-settings.greyListing' => 'A szürkelistás levélszemét elleni védelem bekapcsolása e domainben található összes postafiók számára',
    'mail-settings.howToConfigureExternalDns' => 'Külső DNS konfigurálása',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Ha külső DNS-kiszolgálót használ, akkor a DKIM-aláírás engedélyezésére, magának kell elvégeznie a DNS-kiszolgálón található DKIM DNS-rekordok konfigurálását.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Ehhez az alábbi DKIM DNS-rekordokat használja:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Ha rendelkezik domain aliasnevekkel, akkor használja azokat levélküldéshez, továbbá végezze el a DKIM DNS-rekordok hozzáadását is. Ugyanolyan rekordokat használjon, mint a fődomain esetén, de a domain aliasnévvel.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'A DKIM DNS-rekordok megtekintéséhez konfigurálást kell végeznie, jelölje be "%%option%%" jelölőnégyzetet, alkalmazza és nyissa meg ismét ezt az előugró elemet.',
    'mail-settings.mailServiceDisabled' => 'Letiltva',
    'mail-settings.mailServiceDisabledIncoming' => 'Le vannak tiltva bejövő e-mail esetében',
    'mail-settings.mailServiceDisabledHint' => 'A Plesk kiszolgáló nem biztosít levelezési szolgáltatásokat e domainen.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Ez a domain csak küldeni tud e-mailt és csak a Sendmail levelezőprogramot használja.',
    'mail-settings.mailServiceEnabled' => 'Engedélyezett',
    'mail-settings.mailServiceEnabledHint' => 'Ez a domain küldeni és fogadni is képes e-mailt.',
    'mail-settings.mailServiceNotConfigured' => 'Nincs konfigurálva',
    'mail-settings.mailServiceNotConfiguredHint' => 'A Plesk kiszolgáló nem biztosít levelezési szolgáltatásokat e domainen.',
    'mail-settings.warning' => 'Az összes fogadott és küldött e-maillel együtt, ez véglegesen eltávolítja a domain postaládáit.',
    'mail-settings.show.title' => '%%domain%% összes postaládájának és e-mailjének az eltávolítása',
    'mail-settings.show.checkbox' => 'Véglegesen távolítsa el a fogadott és küldött e-mail üzenetekkel együtt <b>%%domain%%</b> összes postaládáját.',

    'role.roleSection' => 'Általános',
    'role.name' => 'Felhasználói szerepkör neve',
    'role.description' => 'Leírás',
    'role.generalPermissionsSection' => 'Plesk szolgáltatásokhoz hozzáférés',
    'role.applicationsAccessSection' => 'Alkalmazásokhoz hozzáférés',
    'role.permissionAllow' => 'Megadva',
    'role.permissionDeny' => 'Elutasítva',
    'role.emptyRoleName' => 'Adjon meg egy szerepkör nevet.',
    'role.installedAt' => 'Telepítve a következő helyen;',
    'role.noInstallationUrlAvailable' => 'Külső alkalmazás',
    'role.invalidRoleName' => 'Érvénytelen a megadott felhasználói szerepkör neve. Kérdő- és idézőjel nem használható a felhasználói szerepkör nevében.',
    'role.longRoleName' => 'Túl hosszú a megadott felhasználói szerepkör neve.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Előfordulhat, hogy a következő okok miatt egyes műveletek nem állnak rendelkezésre: a jelenleg kiválasztott előfizetés esetén nincs a műveletre vonatkozó engedély megadva vagy a hozzárendelt erőforrások mennyisége nem elegendő egy művelet végrehajtásához.',
    'role.servicesPermissionsDescription' => 'E szerepkör segítségével határozza meg a telepített alkalmazásokhoz vagy Plesk szolgáltatásokhoz az összes felhasználó számára a hozzáférést. Ha hozzáférést engedélyez egy alkalmazáshoz, akkor az alkalmazás hozzáférhetővé válik a számukra az Ügyfél kezelőpanelen.',
    'role.emailActivation' => 'E szerepkör számlák e-mailen keresztüli aktiválása',

    'service.admin-access.adminAccess' => 'Adminisztrátor hozzáférése',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'E hitelesítő adatok kerülnek felhasználásra ezen alkalmazáshoz adminisztrátor hozzáférés esetén.',
    'service.admin-access.login' => 'Adminisztrátor felhasználónév',
    'service.admin-access.password' => 'Adminisztrátor jelszó',
    'service.admin-access.passwordConfirmation' => 'Jelszó megerősítése',

    'service.info.service-entry-point.availableAt' => 'Rendelkezésre áll a következő helyen;',
    'service.info.service-entry-point.customize' => 'Parancsikon testreszabása',
    'service.info.service-entry-point.displayNameLabel' => 'Parancsikon neve',
    'service.info.service-entry-point.displayNameDescription' => 'Adjon nevet e parancsikonnak. A parancsikon alatt jelenik meg a név. Azon felhasználók a Saját szolgáltatás oldalán jelennek meg a parancsikonok, akiknek számára engedélyeztek a hozzáférést ezen alkalmazáshoz.',
    'service.info.service-entry-point.descriptionLabel' => 'Parancsikon leírás',
    'service.info.service-entry-point.descriptionDescription' => 'Biztosítson leírást e parancsikonhoz. Az elemleírásként jelenik meg a leírás, amikor az egérmutató a parancsikon felett van.',
    'service.info.service-entry-point.iconLabel' => 'Kattintson a parancsikon kiválasztására.',
    'service.info.service-entry-point.iconCurrent' => 'Jelenlegi ikon',
    'service.info.service-entry-point.errorEmptyName' => 'Meg kell adni egy parancsikon nevet.',
    'service.info.service-entry-point.errorLongName' => '1 és 255 karakter között kell a parancsikon név hosszának lennie.',
    'service.info.service-entry-point.errorLongDescription' => '0 és 255 karakter között kell a parancsikon leírás hosszának lennie.',
    'service.info.service-entry-point.hiddenLabel' => 'Parancsikon elrejtése',
    'service.info.service-entry-point.hiddenDescription' => 'Ne jelenítse meg e parancsikont a felhasználóknak.',

    'service.info.service-permission.assignedUser' => "Adminisztrátor hozzáférés adása e felhasználónak.",
    'service.info.service-permission.assignedUserNone' => 'Nincs hozzárendelt felhasználó.',

    'shared-ssl.master-ssl.switchedOn' => 'Megosztott SSL/TSL bekapcsolása',
    'shared-ssl.master-ssl.domainName' => 'Egy olyan domain neve, melynek SSL/TLS-tanúsítványa más webhellyel megosztásra kerül.',
    'shared-ssl.master-ssl.none' => 'Nincs',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Nem kapcsolható be megosztott SSL/TLS, mivel nincsenek engedélyezett SSL/TLS-támogatással rendelkező domainek.',

    'user.email.email' => 'E-mail cím',
    'user.email.emptyEmail' => 'Meg kell adnia egy e-mail címet.',
    'user.email.internalEmailHint' => 'Hozzon létre egy új e-mail címet a Plesk kezelőpanelen vagy egy külső e-mail címet használjon.',
    'user.email.longInternalEmail' => 'Túl hosszú az e-mail cím.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Túl hosszú az e-mail cím felhasználónév része e levelezési kiszolgáló számára. %%max%% szimbólumnál rövidebb felhasználónevet adjon meg.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Túl hosszú az e-mail cím e levelezési kiszolgáló számára. %%max%% szimbólumnál rövidebb címet adjon meg.',
    'user.email.externalEmail' => 'Külső e-mail cím',
    'user.email.externalEmailHint' => 'Új jelszó megadására szolgál, ha megszűnik az elsődleges e-mail címéhez a hozzáférés.',
    'user.email.emailsIsEqual' => 'Egyezik az elsődlegessel a külső e-mail cím. Eltérő e-mail címet adjon meg.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Írjon be egy belső vagy külső e-mail címet.',

    'user.profileSection' => 'Általános információk',
    'user.contactName' => 'Kapcsolattartó neve',
    'user.email' => 'E-mail cím',
    'user.role' => 'Felhasználói szerepkör',
    'user.accountSection' => 'Plesk beállítások',
    'user.login' => 'Felhasználónév',
    'user.password' => 'Jelszó',
    'user.buttonBack' => 'Vissza',
    'user.generalTab' => 'Általános',
    'user.applicationsAccessSection' => 'Szolgáltatások',
    'user.generalPermissionsSection' => 'Jogosultságok',
    'user.contactsTab' => 'Kapcsolattartó adatai',
    'user.passwordConfirmation' => 'Jelszó megerősítése',
    'user.internalEmailPasswordChanged' => 'A jelszó megváltoztatása, egyben a belső e-mail címhez tartozó jelszót is megváltoztatja.',
    'user.emailName' => 'E-mail cím',
    'user.emailType' => 'E-mail típus',
    'user.companyName' => 'Cégnév',
    'user.phone' => 'Telefonszám',
    'user.imNumber' => 'Azonnali üzenetküldő',
    'user.fax' => 'Faxszám',
    'user.address' => 'Cím',
    'user.city' => 'Város',
    'user.state' => 'Állam vagy megye',
    'user.zip' => 'Irányítószám',
    'user.country' => 'Ország',
    'user.additionalInfo' => 'További információk',
    'user.additionalInfoHint' => 'Csak egyszerű szöveg Az összes HTML-címke figyelmen kívül hagyásra kerül.',
    'user.language' => 'Plesk nyelve',
    'user.buttonChangePassword' => 'Jelszó megváltoztatása',
    'user.permissionAllow' => 'Megadva',
    'user.permissionDeny' => 'Elutasítva',
    'user.permissionInherited' => 'Szerepkör által meghatározott',
    'user.emptyContactName' => 'Meg kell adnia egy kapcsolattartó nevet.',
    'user.emptyLogin' => 'Meg kell adnia egy felhasználónevet.',
    'user.emptyPassword' => 'Meg kell adnia egy jelszót.',
    'user.emptyPasswordConfirmation' => 'Meg kell erősítenie a jelszót.',
    'user.chooseDomainBoxTitle' => 'Másik domain kiválasztása:',
    'user.userIsActive' => 'Aktív a felhasználó.',
    'user.userIsActiveHint' => 'Aktív felhasználók rendelkeznek hozzáféréssel a Plesk kezelőpanelhez.',
    'user.emailActivation' => 'Számla e-mail általi aktiválása',
    'user.emailHint' => 'Egy ezen kiszolgálón üzemeltetett e-mail címnek a felhasználó számára biztosításához ugorjon a Levelezés lapora, ott hozza létre a megadott e-mail címet és társítsa e felhasználóval.',
    'user.emailContactHint' => 'Forduljon a szolgáltatójához, ha egy e kiszolgálón üzemeltetett e-mail címet akar használni.',
    'user.personalEmailHint' => "A Levelezés lapon változtatható meg e felhasználó e-mail címe.",
    'user.externalMailRedirectHint' => 'Csak e kiszolgálón üzemeltetett e-mail címek esetében lehetséges a Továbbítás aktiválása. E-mail cím létrehozásához ugorjon a Levelezés lapra.',
    'user.externalMailRedirectHint2' => 'Csak e kiszolgálón üzemeltetett e-mail címek esetében lehetséges a Továbbítás aktiválása.',
    'user.externalMailAutoResponderHint' => 'Csak e kiszolgálón üzemeltetett e-mail címek esetében lehetséges az Automatikus válasz aktiválása. E-mail cím létrehozásához ugorjon a Levelezés lapra.',
    'user.externalMailAutoResponderHint2' => 'Csak e kiszolgálón üzemeltetett e-mail címek esetében lehetséges az Automatikus válasz aktiválása.',
    'user.roleHint' => 'A felhasználói szerepkörök adminisztrátori jogokat, továbbá az Ön által kiválasztott alkalmazásokhoz hozzáférést biztosítanak a felhasználóknak.',
    'user.cannotManageMail' => "Nem rendelkezik a levelezési beállítások és szolgáltatások kezelésére vonatkozó engedéllyel.",
    'user.longCompanyName' => 'Túl hosszú a megadott vállalatnév.',
    'user.longPhone' => 'Túl hosszú a megadott telefonszám.',
    'user.longFax' => 'Túl hosszú a megadott faxszám.',
    'user.longAddress' => 'Túl hosszú a megadott cím.',
    'user.longCity' => 'Túl hosszú a megadott városnév.',
    'user.phoneRegexNotMatch' => 'Érvénytelen a megadott telefonszám.',
    'user.faxRegexNotMatch' => 'Érvénytelen a megadott faxszám.',
    'user.shortCity' => 'Túl rövid a megadott városnév.',
    'user.limitSubscription' => 'Előfizetésekhez hozzáférés',
    'user.limitSubscriptionHint' => 'Csak egy megadott előfizetéshez való hozzáférést engedélyezze a felhasználóknak. Az  „Összes” érték biztosítja az üzemeltetési számláján belüli összes előfizetéshez való hozzáférést.',
    'user.limitSubscriptionAll' => 'Az összes',
    'user.deletedSubscription' => 'Eltávolított előfizetés',

    'web.add-domain-alias.title' => 'Egy domain alias hozzáadása',
    'web.add-domain-alias.createdSuccessfully' => "Megtörtént %%name%% domain alias létrehozása.",
    'web.add-domain-alias.domainAliasName' => 'Domain alias név',
    'web.add-domain-alias.domainAliasNameHint' => 'Például, example.net',
    'web.add-domain-alias.forDomain' => 'a domain számára',
    'web.add-domain-alias.settingsSectionLegend' => 'Beállítások',
    'web.add-domain-alias.settingsDns' => 'DNS-zóna elsődleges domainnel szinkronizálása',
    'web.add-domain-alias.settingsMail' => 'E-mail szolgáltatás',
    'web.add-domain-alias.settingsWeb' => 'Webes szolgáltatás',
    'web.add-domain-alias.settingsSeoRedirect' => 'A HTTP 301 kóddal történő átirányítás',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Ha a látogatók megnyitják az alias URL-címét, akkor az elsődleges domain URL-címére kerülnek átirányításra. Keresőbarát HTTP 301 átirányítást használ a Plesk, mely azt jelenti, hogy a keresőmotor rangsorolás nem kerül felosztásra az URL-címek között.',
    'web.add-domain-alias.settingsTomcat' => 'Java webalkalmazás',
    'web.add-domain-alias.invalidDomainGuid' => 'Érvénytelen domain',

    'web.add-domain.formTitle' => 'Új domain hozzáadása',
    'web.add-domain.portalLink' => 'Szolgáltatási portál',
    'web.add-domain.domainName' => 'Domain név',
    'web.add-domain.domainNameHint' => "Például, example.com",
    'web.add-domain.assignToCustomer' => 'E domain egy ügyfélhez rendelése',
    'web.add-domain.customer' => 'Egy ügyfél kiválasztása',
    'web.add-domain.createNewCustomer' => 'Új ügyfél létrehozása',
    'web.add-domain.selectExistingCustomer' => 'Egy meglévő ügyfél kiválasztása:',
    'web.add-domain.customerContactInfoHint' => 'Írja be az ügyfél kapcsolattartási adatait. Később minden más adatot, mint telefonszámot és címet, is megadhat.',
    'web.add-domain.customerLoginInfoHint' => 'Ügyfél panel hitelesítő adatai',
    'web.add-domain.target' => 'Webtárhely',
    'web.add-domain.createNewTarget' => 'Új előfizetés létrehozása',
    'web.add-domain.createNewTarget_powerUser' => 'Új webtárhely létrehozása',
    'web.add-domain.selectExistingTarget' => 'Egy meglévő előfizetés kiválasztása:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Egy meglévő webtárhely kiválasztása:',
    'web.add-domain.dns' => 'A DNS-szolgáltatás aktiválása',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'A levelezési szolgáltatás aktiválása',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Akkor működik, ha az előfizetés beállításai lehetővé teszik a domainenkénti levelezési engedélyezés kezelést. Ha nem teszik lehetővé, akkor az előfizetésből történik az aktuális levelezési szolgáltatás állapotának a lekérdezése.',
    'web.add-domain.hostingManagementOptions' => 'Üzemeltetési típus',
    'web.add-domain.websiteHosting' => 'Webhely üzemeltetés',
    'web.add-domain.websiteForwarding' => 'Továbbítás',
    'web.add-domain.websiteNoHosting' => 'Nincs üzemeltetés.',
    'web.add-domain.hostingSettingsSectionLegend' => 'Üzemeltetési beállítások',
    'web.add-domain.domainCreatedSuccessfully' => '%%domainName%% létrehozása sikerült.',
    'web.add-domain.webspaceLegend' => 'Webtérhely beállítások',
    'web.add-domain.addWhmWebsiteTitle' => 'Új webhely hozzáadása',
    'web.add-domain.addWhmWebsiteHint' => "Választhatja egy webhelynek a kiszolgálón történő üzemeltetését.",
    'web.add-domain.selectWhmDomain' => 'Domain kiválasztása',
    'web.add-domain.customerLegend' => 'Ügyféladatok',
    'web.add-domain.credentials' => 'Rendszerfelhasználó hitelesítő adatai',
    'web.add-domain.credentialsHint' => 'A tárolt fájlokhoz FTP és SSH használatával való hozzáférés.',
    'web.add-domain.credentialsHintWin' => 'A tárolt fájlokhoz FTP és RDP használatával való hozzáférésre szolgál.',
    'web.add-domain.buttonAddDomain' => 'Domain hozzáadása',

    'web.add-subdomain.formTitle' => 'Egy aldomain hozzáadása',
    'web.add-subdomain.formGeneralHint' => 'Webhelye különböző részeinek internetcímei az aldomainek. A fődomain nevét és egy előtagot használnak. Például, ha domain.com a domainje címe, akkor store.domain.com lehet az aldomain címe.',
    'web.add-subdomain.formGeneralHintAdditional' => 'A név helyett a * szimbólum beírásával helyettesítő szimbólumos aldomaint is létrehozhat. A böngészőbe beírt aldomain névtől független a webhely látogatói átirányításra kerülnek ezen aldomainre.',
    'web.add-subdomain.subdomainName' => 'Aldomain név',
    'web.add-subdomain.subdomainNameHint' => 'Egy * szimbólumot írjon be egy helyettesítő szimbólumos aldomain létrehozására.',
    'web.add-subdomain.forDomain' => 'Szülődomain',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Megtörtént az aldomain létrehozása.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Üzemeltetési beállítások',

    'web.change-hosting.formGeneralHint' => 'Választhat webhely kiszolgálón történő üzemeltetést (Webhely üzemeltetés), weben keresztüli továbbítást másik webhelyre (Továbbítás) vagy e domain név alatt, a domain DNS-zónájának postaládák működtetésre történő használatát (Nincs üzemeltetés).',
    'web.change-hosting.changed' => '%%domainName%% üzemeltetési típusának megváltoztatása sikerült.',
    'web.change-hosting.hostingManagementOptions' => 'Üzemeltetési típus',
    'web.change-hosting.websiteHosting' => 'Webhely üzemeltetés',
    'web.change-hosting.websiteForwarding' => 'Továbbítás',
    'web.change-hosting.websiteNoHosting' => 'Nincs webes üzemeltetés.',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Üzemeltetési beállítások',
    'web.change-hosting.userName' => 'Felhasználónév',
    'web.change-hosting.userNameHint' => 'Rendszerfelhasználó fájloknak és mappáknak az előfizetésen belüli kezelésére.',
    'web.change-hosting.userNameHint_powerUser' => 'Rendszerfelhasználó fájloknak és mappáknak a webtárhelyen belüli kezelésére.',
    'web.change-hosting.emptyLogin' => 'Meg kell adnia egy felhasználónevet.',
    'web.change-hosting.password' => 'Jelszó',
    'web.change-hosting.emptyPassword' => 'Meg kell adnia egy jelszót.',
    'web.change-hosting.passwordConfirmation' => 'Jelszó megerősítése',
    'web.change-hosting.warningInstalledApplications' => 'Webalkalmazások vannak telepítve e webhelyre. Ha megváltoztatja az üzemeltetési típust, akkor az mát nem lesz elérhető.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Figyelmeztetés: Törlésre kerül a webhely tartalma.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Meg akarja változtatni webhelye üzemeltetési típusát?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Megtörténik a következő mappák és a teljes tartalmaik törlése:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'Megtörténik a webtárhely gyökérmappája összes tartalmának a törlése.',

    'web.change-status.changed' => '%%domainName%% webhely állapotának megváltoztatása sikerült.',
    'web.change-status.statusManagementOptions' => 'Webhely állapota',
    'web.change-status.statusDisabled' => 'Letiltva (korábbi elnevezéssel Felfüggesztve)',
    'web.change-status.statusSuspended' => 'Felfüggesztve',
    'web.change-status.statusActive' => 'Aktív',
    'web.change-status.statusDisabledHint' => 'Megszűnik a webhelynek a kiszolgálón történő üzemeltetése, így az FTP-ügyfelek és a Fájlkezelő kivételével az nem áll rendelkezésre. A webhely alapértelmezett oldalát látják a látogatók. Nem fog rendelkezésre állni a levelezési szolgáltatás.',
    'web.change-status.statusSuspendedHint' => 'Megmarad a webhelynek a kiszolgálón történő üzemeltetése, de az 503 HTTP-kód segítségével a látogatók átirányításra kerülnek az egyéni hibadokumentum oldalra. Továbbra is rendelkezésre áll a levelezési szolgáltatás. %%link%% itt végezhető el.',
    'web.change-status.statusSuspendedHintNoLink' => 'Bár a webhely üzemeltetése a kiszolgálón marad, a keresőmotor barát 503 HTTP-kód segítségével a látogatók átirányításra kerülnek az egyéni hibadokumentum oldalra. Továbbra is rendelkezésre áll a levelezési szolgáltatás.',
    'web.change-status.error503PageLink' => 'az ügyfél hibadokumentum szerkesztése',
    'web.change-status.statusActiveHint' => 'A szokásos módon működik a webhely.',
    'web.change-status.notActivatedSuspended' => '%%domainName%% domain vagy webhely nem aktiválható, mivel azt felfüggesztette a szolgáltatója.',
    'web.change-status.notActivatedDisabled' => '%%domainName%% domain vagy webhely nem aktiválható, mivel azt letiltotta a szolgáltatója.',

    'web.edit.formTitle' => '%%name%% webes üzemeltetési hozzáférés',
    'web.edit.formGeneralHint' => 'Itt megtekintheti az előfizetésével társított IP-címeket, és megváltoztathatja rendszerfelhasználói felhasználóneveit és jelszavait.',
    'web.edit.formGeneralHint_powerUser' => 'Itt megtekintheti a webtárhelyével társított IP-címeket, és megváltoztathatja rendszerfelhasználói felhasználóneveit és jelszavait.',
    'web.edit.ipAddressesLegend' => 'IP-címek',
    'web.edit.ipAddresses' => 'IP-címek',
    'web.edit.certificateLegend' => 'Tanúsítvány',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (más felhasználóé)',
    'web.edit.userAccountLegend' => 'Rendszerfelhasználó',
    'web.edit.systemUserHint' => 'Itt határozhat meg egy operációs rendszer felhasználót az előfizetésen belüli fájlok és mappák FTP vagy a Fájlkezelő segítségével történő kezelésére. A rendszerfelhasználó alkalmazható a Plesk kezelőpanelhez SSH-szolgáltatáson (Linux esetében) vagy RDP-szolgáltatáson (Windows esetében) való hozzáférésre is a megfelelő engedélyek megléte esetén.',
    'web.edit.systemUserHint_powerUser' => 'Itt határozhat meg egy operációs rendszer felhasználót a webtárhelyen belüli fájlok és mappák FTP vagy a Fájlkezelő segítségével történő kezelésére. A rendszerfelhasználó alkalmazható a Plesk kezelőpanelhez SSH-szolgáltatáson (Linux esetében) vagy RDP-szolgáltatáson (Windows esetében) való hozzáférésre is a megfelelő engedélyek megléte esetén.',
    'web.edit.login' => 'Felhasználónév',
    'web.edit.emptyLogin' => 'Adjon meg egy felhasználónevet.',
    'web.edit.password' => 'Jelszó',
    'web.edit.passwordConfirmation' => 'Jelszó megerősítése',
    'web.edit.emptyPassword' => 'Adjon meg egy jelszót.',
    'web.edit.emptyPasswordConfirmation' => 'Erősítse meg a jelszót.',
    'web.edit.shellUnix' => "SSH-szolgáltatáson keresztül történő kiszolgálóhoz hozzáférés",
    'web.edit.shellHintUnix' => "Rendszerfelhasználói hitelesítő adatokkal, az SSH-szolgáltatáson keresztül férjen a kiszolgálóhoz.",
    'web.edit.shellWin' => 'Távoli asztalon keresztül történő kiszolgálóhoz hozzáférés',
    'web.edit.shellHintWin' => "Rendszerfelhasználói hitelesítő adatokkal, a Távoli asztalon keresztül férjen a kiszolgálóhoz.",
    'web.edit.diskQuotaLegend' => 'Merevlemez-területi kvóta',
    'web.edit.diskQuotaHint' => 'A használható lemezterület korlátját jelenti a merevlemez-területi kvóta. Ha be van állítva a Merevlemez-területi kvóta és felhasználásra került a teljes lefoglalt lemezterület, akkor már nem végezhető több fájlművelet.',
    'web.edit.diskQuota' => 'Merevlemez-területi kvóta',
    'web.edit.diskQuotaUnlimited' => 'Korlátlan',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Korlátlan. A kiszolgáló fájlrendszerének konfigurációja miatt nem támogatott a Merevlemez-területi kvóta használata.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'Az üzemeltetési beállítások frissítése sikerült.',
    'web.edit.affectedDomainsLegend' => 'Ezen beállítások által érintett webhelyek',
    'web.edit.affectedDomainsHint' => 'A következő webhelyek vannak társítva a jelenlegi rendszerfelhasználóval. A webes üzemeltetés hozzáférés beállításainak ezen oldalon végrehajtott változtatásai e webhelyeken is alkalmazásra kerülnek.',

    'web.mobile.create.formTitle' => 'Mobiltelefonos webhely létrehozása',
    'web.mobile.create.formGeneralHint' => 'Adja meg a mobiltelefonos webhely nevét — egy olyan URL-cím, melyen keresztül érhető el a mobiltelefonos webhely. Általában olyan előtagok használatosak, mint „m”, „mob” , „mobi”, „mobile” és így tovább, például: mobile.example.com. Majd ezen URL-címet használhatja egy a normál webhelyén elhelyezett, pl. „Mobiltelefonos verzió” elnevezésű hivatkozásban, hogy a webhelye látogatói képesek legyenek a mobil és normál verziók közötti átkapcsolásra.',
    'web.mobile.create.prefix' => 'Webhely neve',
    'web.mobile.create.emptySiteName' => 'Nem maradhat üres mobiltelefonos webhely név mező, mivel ütközhet a normál webhelyével.',

    'web.security-section.securitySectionLegend' => 'Biztonság',
    'web.security-section.securitySectionHint' => 'SSL/TSL protokollt használjon webhelye tranzakcióinak biztonságossá tétele érdekében, mely elvégzi valamennyi adat titkosítását és egy biztonságos kapcsolaton keresztüli átvitelét. Az SSL/TSL-szolgáltatás telepítéséhez, helyezze át e webhelyet egy dedikált IP-címre, telepítsen egy SSL/TSL-tanúsítványt a webhelyre, majd alább válassza ki azt.',
    'web.security-section.securitySectionSniHint' => 'SSL/TSL protokollt használjon webhelye tranzakcióinak biztonságossá tétele érdekében, mely elvégzi valamennyi adat titkosítását és egy biztonságos kapcsolaton keresztüli átvitelét. Az SSL/TSL-szolgáltatás telepítéséhez, telepítsen egy SSL/TSL-tanúsítványt a webhelyre, majd alább válassza ki azt.',
    'web.security-section.enableSslSupport' => 'SSL/TLS-támogatás',
    'web.security-section.enableSslRedirect' => 'Végleges, 301-es átirányítás HTTP-ről HTTPS-re',

    'web.seo-settings.seoRedirectDirection' => 'Előnyben részesített domain',
    'web.seo-settings.seoRedirectDirectionHint' => 'Válassza ki azon URL-címet (a www. előtaggal vagy anélkül), ahová webhely látogatói SEO biztonságos HTTP 301 kód segítségével átirányításra kerülnek.',
    'web.seo-settings.seoRedirectDirectionNone' => 'Nincs',

    'web.settings.formGeneralHint' => 'Itt végezheti el a webhely üzemeltetési beállításait és választhatja ki a webhelyen rendelkezésre álló funkciókat.',
    'web.settings.hostingType' => 'Üzemeltetési típus',
    'web.settings.websiteHosting' => 'Webhely',
    'web.settings.forwardingHosting' => 'Továbbítás',
    'web.settings.noHosting' => 'Nincs üzemeltetés.',
    'web.settings.changeHosting' => 'Változtatás',
    'web.settings.websiteStatus' => 'Webhely állapota',
    'web.settings.changeStatus' => 'Változtatás',
    'web.settings.active' => 'Aktív',
    'web.settings.suspended' => 'Felfüggesztve',
    'web.settings.disabled' => 'Letiltva',
    'web.settings.webScriptingSectionLegend' => 'Webes parancsnyelv és statisztikák',
    'web.settings.webScriptingSectionHint' => 'Adja meg, hogy a következő programozási és parancsprogram nyelvek közül melyiket kell lefordítani, végrehajtani vagy vagy más módon feldolgozni a webkiszolgálónak.',
    'web.settings.__asp_win_support' => 'Microsoft ASP támogatás',
    'web.settings.__asp_dot_net_support' => 'Microsoft ASP.NET támogatás',
    'web.settings.__asp_dot_net_version' => 'Verzió',
    'web.settings.__asp_dot_net_version_readonly' => 'version %%value%%',
    'web.settings.__ssi_support' => 'SSI-támogatás',
    'web.settings.__ssi_with_html' => 'SSI használata *.htm, *.html fájl esetében',
    'web.settings.__php_support' => 'PHP-támogatás',
    'web.settings.__php_run_as' => 'PHP következőkénti futtatása',
    'web.settings.__php_served_by_apache' => 'Apache által kiszolgált',
    'web.settings.__php_served_by_nginx' => 'nginx által kiszolgált',
    'web.settings.__cgi_support' => 'CGI támogatás',
    'web.settings.__cgi_bin_mode' => 'A következő helyen található a CGI-bin könyvtár;',
    'web.settings.__cgi_bin_mode_webspace' => 'A webtárhely gyökérkönyvtára',
    'web.settings.__cgi_bin_mode_www_root' => 'e domain dokumentumgyökere',
    'web.settings.__cgi_bin_mode_old_style' => 'e domain régi stílusú gyökere',
    'web.settings.__cgi_bin_mode_readonly' => '%%value%% helyen található a CGI-bin könyvtár.',
    'web.settings.__perl_unix_support' => 'Perl támogatás',
    'web.settings.__perl_win_support' => 'Perl támogatás',
    'web.settings.__python_unix_support' => 'Python támogatás',
    'web.settings.__python_win_support' => 'Python támogatás',
    'web.settings.__fastcgi_unix_support' => 'FastCGI támogatás',
    'web.settings.__webstat_support' => 'Webstatisztikák',
    'web.settings.__plesk_stat_protect' => 'Az FTP-felhasználónevével és jelszavával védje a webstatisztikáihoz való hozzáférést.',
    'web.settings.__plesk_stat_protected' => 'Az FTP-felhasználónevével és jelszavával van védve a webstatisztikáihoz való hozzáférés.',
    'web.settings.__apache_errdocs' => 'Egyéni hiba dokumentumok',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'FastCGI-alkalmazás',
    'web.settings.__php_cgi_handler' => 'CGI-alkalmazás',
    'web.settings.__php_isapi_handler' => 'ISAPI-bővítmény',
    'web.settings.__php_version' => 'PHP-verzió',
    'web.settings.__hosting_write_modify' => 'További írás/olvasás engedélyek',
    'web.settings.__hosting_webdeploy' => 'Web Deploy közzététele',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'Nincs',
    'web.settings.activate' => 'Aktiválás',
    'web.settings.deactivate' => 'Felfüggesztés',
    'web.settings.__php_support_readonly' => 'verzió: %%version%%; kezelő: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'nincs regisztrálva',
    'web.settings.domainName' => 'Domain név',
    'web.settings.domainNameHint' => "Például, example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Kompatibilitási üzemmód a „Külön SSL/TSL- és nem SSL/TSL-tartalom” örökölt beállítás esetén',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Kompatibilitási üzemmódban futtassa a webhelyet a „Külön SSL/TSL- és nem SSL/TSL-tartalom” örökölt beállítás esetén.',
    'web.settings.sameSslCompatibilityHint' => 'Azért látja e részt, mivel a magasabb verzióra frissítés előtt használta a „Külön SSL/TSL- és nem SSL/TSL-tartalom” beállítást. A Plesk 11 verzióban már elavult a beállítás. A Plesk 11 verzióban létrehozott összes webhely ugyanazt a könyvtárat használja a HTTP- és a HTTPS kapcsolatokon keresztül elérhető tartalom tárolására. Ez azt jelenti, hogy e webhely még működik a kompatibilitási üzemmódban, azonban nem kezelheti a Plesk kezelőpanelen keresztül. Nyomatékosan ajánlott az összes adatának a httpsdocs/ könyvtárból a httpdocs/ könyvtárba való áthelyezése, majd ezt követően a kompatibilitási üzemmód kikapcsolása. A kompatibilitási üzemmód kikapcsolása után nem tudja azt ismét bekapcsolni, továbbá ez már nem jelenik meg többé. Ne feledje, ha alkalmazásokat telepít a httpsdocs/ könyvtárba, amikor be van kapcsolva a kompatibilitási üzemmód, akkor az interneten keresztül nem érhetőek el az alkalmazások. Ha alkalmazásokat akar telepíteni a httpsdocs/ könyvtárba, akkor kapcsolja ki a kompatibilitási üzemmódot.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => '%%restartInterval%% percen belül alkalmazásra kerülnek webhely beállítások.',
    'web.settings.phpSettingsDescription' => 'Ezen oldal jeleníti meg a webhely PHP-konfigurációját. E beállítások a webhelyre vonatkoznak, és nem befolyásolják az előfizetésen belüli más webhelyek működését. Megváltoztathatja a PHP-konfigurációt, ha az üzemeltető megadja a szükséges engedélyt. Egyéni PHP-konfigurációk használhatóak, például a PHP-parancsprogramok által használt rendszer erőforrás-használat korlátozása vagy bizonyos webalkalmazások követelményeinek való megfelelés érdekében. Amikor az Alapértelmezés szerint végzi egy paraméter értékének a beállítását, akkor a PHP az egész kiszolgálóra érvényes PHP-konfiguráció paraméterértékét állítja be.',
    'web.settings.phpSettingsAvailableVariables' => 'A fenti paraméterértékekben a következő helyőrzőket használhatja:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} a webhely dokumentum gyökérkönyvtára számára. %%DOCROOT%% a jelenlegi érték. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'Megegyezik a HTTPS és a http dokumentum gyökérkönyvtár.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => '%%DOCROOT%% a HTTPS dokumentum gyökérkönyvtár.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} az előfizetés elsődleges webhelyének dokumentum gyökérkönyvtára számára.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} az ideiglenes fájlokat tároló könyvtár számára.',
    'web.settings.phpSettingsPhpVersion' => '%%version%% a PHP verziója.',
    'web.settings.phpSettingsPhpDisabled' => 'Ki van kapcsolva a PHP.',
    'web.settings.phpHandlerTypeHint' => 'Ne feledje, hogy a PHP-kezelő típusának változtatása megszakíthatja a meglévő PHP-parancsprogramok működését e webhelyen.',
    'web.settings.fpmDedicatedHandlerHint' => 'E kezelő használata növeli a webhely stabilitását, de további memóriahasználattal is jár.',
    'web.settings.phpHandlerChangeHint' => 'Megváltoztatta a PHP-kezelő beállításait. Ha elmenti e beállításokat, akkor a kiszolgálója konfigurálása miatt előfordulhat %%interval%% másodpercre leállnak a webhelye PHP-parancsprogramjai.',
    'web.settings.phpHandlerTypeHelpLink' => 'A legmegfelelőbb PHP-beállítások kiválasztásának módja',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'Nem engedélyezhető PHP-támogatás, mivel a jelenlegi üzemeltetési konfiguráció nem tartalmaz e domain számára rendelkezésre álló PHP-verziót.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Érdeklődje meg hogyan történik más PHP-verziók engedélyezése.',
    'web.settings.phpHandlerBroken' => 'Sérült a jelenleg kiválasztott PHP-kezelő. Egy másik kezelőt válasszon ki.',
    'web.settings.phpHandlerOutdated' => '(Elavult)',
    'web.settings.phpHandlerDeprecated' => '(Elavult)',

    'web.setupService.formTitle' => 'Telepítési szolgáltatás: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => '\'%%serviceReference%%\' szolgáltatás frissítése sikerült.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% aldomain:',
    'web.site-copy.destinationTypeSection' => 'Másolás célhelye',
    'web.site-copy.destinationType' => 'Válassza ki a másolandó webhelyfájlokat.',
    'web.site-copy.destinationTypeSite' => 'Plesk kezelőpanelen lévő webhely',
    'web.site-copy.destinationTypeSiteDescription' => 'Másolja a webhely fájljait egy másik olyan webhelyre, melynek üzemeltetése e számlán belül történik. Ha rendelkezik FTP-hozzáféréssel e kiszolgáló egy másik fiókjához, akkor, akkor a választható FTP-tárolót használja.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Másolja a webhely fájljait egy másik olyan webhelyre, melynek üzemeltetése e kiszolgálón történik.',
    'web.site-copy.destinationTypeSiteSelect' => 'Webhely neve',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "%%source%% fájljai nem másolhatóak %%destination%% helyere, mivel %%destination%% ezen fájlok részét képezi -- %%source%% dokumentumgyökér alkönyvtára a dokumentumgyökér.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Nem távolíthatóak el ezen %%destination%% webhely fájljai, mivel %%source%% fájlok egy részüket képezik -- %%source%% dokumentumgyökér ezen %%destination%% alkönyvtárát képezi.",
    'web.site-copy.destinationTypeFtp' => 'FTP-tároló',
    'web.site-copy.destinationTypeFtpDescription' => 'Másolja a webhelyfájlokat ezen vagy egy külső kiszolgáló FTP-fiókjába.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Másolja a webhelyfájlokat egy külső kiszolgáló FTP-fiókjába.',
    'web.site-copy.destinationTypeFtpHost' => "Kiszolgáló állomásneve",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Könyvtár',
    'web.site-copy.destinationTypeFtpUser' => 'Felhasználónév',
    'web.site-copy.destinationTypeFtpPassword' => 'Jelszó',
    'web.site-copy.destinationTypeFtpMode' => 'FTP-kapcsolódási módszer',
    'web.site-copy.destinationTypeFtpModeActive' => 'Aktív mód',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'Aktív módban a Plesk elküldi azon IP-címét és portszámát, melyen figyelni fog egy külső kiszolgálót és a kiszolgáló indítja a TCP-kapcsolatot. Ez a mód ajánlott, amikor nem védi tűzfal a Plesk által kezelt kiszolgálót.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passzív mód',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Akkor használható a passzív mód egy tűzfal mögött helyezkedik el a Plesk által kezelt kiszolgáló és nem lehetséges a bejövő TCP-kapcsolatokhoz hozzáférni.',
    'web.site-copy.existingFiles' => 'Meglévő fájlokkal a teendő',
    'web.site-copy.existingFilesKeep' => 'A meglévő fájlok célhelyen tartása',
    'web.site-copy.existingFilesKeepDescription' => 'Írja felül a célhelyen található megegyező fájlnevű fájlokat.',
    'web.site-copy.existingFilesDelete' => 'Az összes meglévő fájl törlése',
    'web.site-copy.existingFilesDeleteDescription' => 'Másolás előtt törölje célhely összes fájlját.',
    'web.site-copy.emptyLogin' => 'Adja meg egy FTP-fiók felhasználónevét.',
    'web.site-copy.emptyHost' => 'Adja meg egy kiszolgáló állomásnevét.',
    'web.site-copy.emptyPort' => 'Adja meg egy kiszolgáló állomásportját.',
    'web.site-copy.copyInProgress' => 'A webhely %%sourceName%% helyről %%destinationName%% helyre történő másolása. E-mailen (%%email%%) keresztül kap értesítést az előrehaladásról.',
    'web.site-copy.unableToCopy' => 'Nem sikerült a webhelyfájlok másolása.',
    'web.site-copy.siteCopied' => 'A webhelyfájlok másolása megtörtént.',
    'web.site-copy.emailSubjSuccess' => '"%%source%%" fájlainak másolása megtörtént.',
    'web.site-copy.emailSubjFailure' => '"%%source%%" fájljainak másolása nem sikerült.',
    'web.site-copy.emailBodySuccess' => '"%%source%%" fájljainak másolása "%%destination%%" helyre történt meg.',
    'web.site-copy.emailBodyFailure' => '"%%source%%" webhely fájljainak %%destination%%" helyre másolása nem sikerült: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Továbbítási beállítások',
    'web._shared.forwardDestination' => 'Cél címe',
    'web._shared.forwardDestinationHint' => 'A cél webhely URL-címe.',
    'web._shared.forwardingTypeOptions' => 'Továbbítási típus',
    'web._shared.forwardingFrame' => 'Kerettovábbítás',
    'web._shared.forwardingFrameHint' => 'Irányítsa át a webhely látogatókat másik webhelyre, de nem jelenítse meg a számukra a cél címét, így nem fognak tudni az átirányításról.',
    'web._shared.forwardingHttpCode301' => 'Véglegesen áthelyezve (301 kód)',
    'web._shared.forwardingHttpCode301Hint' => 'Irányítsa át a webhely látogatókat másik webhelyre és jelenítse meg a számukra a cél címét. Az ilyen átirányítás megőrzi a webhely keresőmotorjának a rangsorolását.',
    'web._shared.forwardingHttpCode302' => 'Ideiglenesen áthelyezve (302 kód)',
    'web._shared.forwardingHttpCode302Hint' => 'Irányítsa át a webhely látogatókat egy ideiglenes webhely másolatra, ha nem akarja, hogy a keresőmotorok indexeljék ezen ideiglenes webhelyet.',
    'web._shared.documentRoot' => 'Kezdőkönyvtár',
    'web._shared.documentRootHint' => 'A webhely kezdőkönyvtárának elérési útja.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Nem lehetséges a dokumentumgyökér megváltoztatása, mivel webalkalmazások vannak telepítve e webhelyre.',
    'web._shared.ipAddress' => 'IP-cím',
    'web._shared.shared' => 'megosztva',
    'web._shared.exclusive' => 'dedikált',
    'web._shared.ipAddressHint' => "A webhely virtuális állomásának egy hálózati címe azon IP-cím, melyen a webhely üzemeltetése történik.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (más tároló)',
    'web._shared.certificate' => 'Tanúsítvány',
    'web._shared.sameCertificatesHint' => 'A kiválasztott tanúsítvány kerül felhasználásra az összes azonos IP-címen üzemeltetett webhely estében.',
    'web._shared.differentCertificatesHint' => 'Ezen előfizetés két különböző tanúsítvánnyal rendelkező két dedikált IP-címmel van társítva. A kiválasztott tanúsítvány kerül bármely e két IP-címen üzemeltetett webhelyre telepített tanúsítvány helyére.',
    'web._shared.differentIpTypesCertificateHint' => 'Az előfizetés egy megosztott és egy dedikált IP-címmel van társítva. A kiválasztott tanúsítvány használható az összes a dedikált IP-címen üzemeltetett más webhelyek esetében is.',
    'web._shared.certificateNotSelected' => 'Nincs kiválasztva.',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Nincsenek SSL/TSL-tanúsítványok az adattárjában. Egy tanúsítvány hozzáadásához ugorjon ezen %%link%% helyre.',
    'web._shared.sslCertificatesRepositoryLink' => 'ezen oldal',

    'web-user.settings.allowScripts' => 'Engedélyezze parancsprogramok használatát webes felhasználók számára.',

    'web-user.name' => 'A kiszolgálóhoz FTP-n keresztüli kapcsolódáshoz szükséges felhasználónév',
    'web-user.longName' => 'Túl hosszú a megadott felhasználónév (maximum %max% szimbólum engedélyezett).',
    'web-user.password' => 'Jelszó',
    'web-user.passwordConfirmation' => 'Jelszó megerősítése',
    'web-user.hardDiskQuota' => 'Merevlemez kvóta',
    'web-user.hardDiskQuotaUnlimited' => 'Korlátlan',
    'web-user.hardDiskQuotaIsNotSupported' => '(a kiszolgáló fájlrendszerének konfigurációja nem támogatja a merevlemez kvótát)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Kötelezően kitöltendő mezők',
];