<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'If your site is hosted on a dedicated IP address (not shared with other users or sites), you can set up a directory within the site where other users will be able to anonymously upload or download files through FTP. Once anonymous FTP is switched on, the users will be able to log in to the directory at an address like ftp://ftp.your-domain.com with the "anonymous" username and any password.',
    'anonymous-ftp.displayLogin' => 'Display login message',
    'anonymous-ftp.loginText' => 'Message text',
    'anonymous-ftp.incomingDir' => 'Allow uploading to incoming directory',
    'anonymous-ftp.incomingSubDir' => 'Allow creation of directories in the incoming directory',
    'anonymous-ftp.incomingReadable' => 'Allow downloading from the incoming directory',
    'anonymous-ftp.quota' => 'Limit the disk space in the incoming directory',
    'anonymous-ftp.maxConnections' => 'Limit the number of simultaneous connections',
    'anonymous-ftp.bandwidth' => 'Limit the download bandwidth for this virtual FTP domain',
    'anonymous-ftp.unlimited' => 'Unlimited',

    'aps.catalog.loading' => 'Loading...',
    'aps.catalog.searchName' => 'Application',
    'aps.catalog.searchVendor' => 'Vendor',
    'aps.catalog.searchPackager' => 'Packager',
    'aps.catalog.searchLicenseType' => 'License type',
    'aps.catalog.searchLicenseTypeAny' => 'Any',
    'aps.catalog.searchLicenseTypeFreeware' => 'Free',
    'aps.catalog.searchLicenseTypeCommercial' => 'Commercial',
    'aps.catalog.showSearch' => 'Show Search',
    'aps.catalog.hideSearch' => 'Hide Search',
    'aps.catalog.buttonSearch' => 'Search',
    'aps.catalog.buttonResetSearch' => 'Reset Search',
    'aps.catalog.showCategories' => 'Select a category below or search for apps using the search box',
    'aps.catalog.searchResults' => 'Search results',
    'aps.catalog.buttonInstall' => 'Install',
    'aps.catalog.buttonInstallTooltip' => 'Quickly install the latest version of the app with optimal default parameters.',
    'aps.catalog.buttonAdvancedInstall' => 'Install (Custom)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Install the latest version of the app, customizing all parameters.',
    'aps.catalog.buttonInstallOldVersion' => 'Install Version',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Install the selected version of the app, customizing all parameters.',
    'aps.catalog.buttonInstallDescription' => 'Install the app on a site if you already have an activation code, or if you just want to try it.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Install this free app on a site.',
    'aps.catalog.version' => 'Version',
    'aps.catalog.moreVersions' => 'More versions',
    'aps.catalog.release' => 'Release',
    'aps.catalog.overview' => 'Overview',
    'aps.catalog.noApplicationsInCategory' => 'No applications are available in this category. Select another category.',
    'aps.catalog.noCategoriesSelected' => 'Select a category to browse all applications available in this category.',
    'aps.catalog.noSearchResults' => 'Your search did not match any apps.',
    'aps.catalog.connectionFailed' => 'Connecting to Application Catalog failed. %%retryLink%%.',
    'aps.catalog.retry' => 'Retry',
    'aps.catalog.categoriesError' => 'List of categories could not be loaded at the moment.',
    'aps.catalog.applicationsError' => 'List of applications could not be loaded at the moment.',
    'aps.catalog.detailsError' => 'Application details could not be loaded at the moment.',
    'aps.catalog.searchError' => 'Search results could not be loaded at the moment.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Release %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'History of changes',
    'aps.catalog.officialApplicationSite' => 'Vendor Info',
    'aps.catalog.returnToCategories' => '<< Back to applications list',
    'aps.catalog.buttonUninstall' => 'Remove',
    'aps.catalog.gotoHome' => 'Home',
    'aps.catalog.all' => 'All',
    'aps.catalog.buttonDetails' => 'Learn more',
    'aps.catalog.buttonBuy' => 'Buy now',
    'aps.catalog.buttonBuyTooltip' => 'Buy the app',
    'aps.catalog.buttonBuyDescription' => 'Visit our store to purchase an activation code for the app.',
    'aps.catalog.buttonDownload' => 'Download',
    'aps.catalog.buttonDownloadDescription' => 'Download the app if you already have an activation code, or just want to try it.',
    'aps.catalog.marketplaceMoreInfo' => 'For more information, visit %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'the app vendor\'s website',

    'aps.configure.installedAt' => "Installed at",
    'aps.configure.otherSettings' => "Other",
    'aps.configure.globalSettings' => 'Package settings',
    'aps.configure.passwordConfirmation' => 'Confirm password',
    'aps.configure.databaseParams' => 'Database parameters',
    'aps.configure.noInstallationUrlAvailable' => 'None (external app)',
    'aps.configure.updateSettingsSection' => 'Update Settings',
    'aps.configure.forceUpdates' => 'Automatically update this app when updates are available',
    'aps.configure.forceUpdatesHint' => 'The app will receive automatic updates to newer versions. Warning: Use this option with care because updates can significantly affect the app functionality. For example, app extensions may stop working with another version of the app.',

    'aps.install.showAllSettings' => 'Show All Settings',
    'aps.install.showLessSettings' => 'Show Minimum Settings',
    'aps.install.install' => 'Install',
    'aps.install.otherSettings' => 'Other settings',
    'aps.install.globalSettings' => 'Package settings',
    'aps.install.passwordConfirmation' => 'Confirm password',
    'aps.install.provisionsSectionLabel' => 'Installation path',
    'aps.install.context' => 'Specify the location where this web application should be installed',
    'aps.install.registerAsWebmailSection' => 'Webmail registration',
    'aps.install.registerAsWebmailDescription' => "Select this option if the app is a webmail client. This will make the app appear among available webmail services in Mail settings of subscriptions and service plans. The administrator can configure the public access URL of the webmail in Server Management > Settings > Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Register as a webmail service',
    'aps.install.addItem' => 'Add',
    'aps.install.removeItem' => 'Remove',
    'aps.install.updateSettingsSection' => 'Update Settings',
    'aps.install.forceUpdates' => 'Automatically update this app when updates are available',
    'aps.install.forceUpdatesHint' => 'The app will receive automatic updates to newer versions. Warning: Use this option with care because updates can significantly affect the app functionality. For example, app extensions may stop working with another version of the app.',

    'aps.invalid-requirements.requirementsLegend' => 'Requirements',
    'aps.invalid-requirements.domainLegend' => 'Website',
    'aps.invalid-requirements.context' => 'Choose another website',
    'aps.invalid-requirements.backToApplicationList' => 'Back to application list',

    'aps.license.title' => 'Installation of %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'To install this application, you have to read the end user license agreement and agree to its terms.',
    'aps.license.licenseAgree' => 'I accept the terms of License Agreement',

    'aps.services-list-customization.settings' => 'Settings',

    'asp-dot-net.change-version.frameworkVersion' => 'The ASP.NET framework version',

    'asp-dot-net.settings.casSettingsSection' => "Code access security",
    'asp-dot-net.settings.clientScriptsSection' => "Script library settings",
    'asp-dot-net.settings.connStringsSection' => "Connection string manager",
    'asp-dot-net.settings.customErrorsSection' => "Custom error settings",
    'asp-dot-net.settings.frameworkVersionSection' => "Framework version",
    'asp-dot-net.settings.globalizationSection' => "Globalization settings",
    'asp-dot-net.settings.otherSection' => "Session settings",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilation and debugging",
    'asp-dot-net.settings.authMode' => "Authentication mode",
    'asp-dot-net.settings.connStrings' => "Connection strings",
    'asp-dot-net.settings.connStringsInvalid' => "Some fields are empty or contain an improper value.",
    'asp-dot-net.settings.connStringName' => "Name",
    'asp-dot-net.settings.connStringValue' => "Connection Parameters",
    'asp-dot-net.settings.connStringsDescription' => "Name / Connection Parameters",
    'asp-dot-net.settings.culture' => "Culture",
    'asp-dot-net.settings.customErrMode' => "Custom error mode",
    'asp-dot-net.settings.customErrorRedirect' => "Redirect URL",
    'asp-dot-net.settings.customErrorStatus' => "Status Code",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Status code must be an integer number.",
    'asp-dot-net.settings.customErrors' => "Custom errors",
    'asp-dot-net.settings.customErrorsDescription' => "Status Code / Redirect URL",
    'asp-dot-net.settings.customErrorsInvalid' => "Some fields are empty or contain an improper value.",
    'asp-dot-net.settings.debugMode' => "Switch on debugging",
    'asp-dot-net.settings.defLanguage' => "Default webpage language",
    'asp-dot-net.settings.tempDirectory' => "Temporary directory",
    'asp-dot-net.settings.fileEnc' => "File encoding",
    'asp-dot-net.settings.fileEncInvalid' => "The specified value for the File encoding parameter is invalid.",
    'asp-dot-net.settings.pathToLib' => "Path to the Microsoft script library",
    'asp-dot-net.settings.pathToLibInstall' => "Install",
    'asp-dot-net.settings.reqEnc' => "Request encoding",
    'asp-dot-net.settings.reqEncInvalid' => "The specified value for the Request encoding parameter is invalid.",
    'asp-dot-net.settings.resEnc' => "Response encoding",
    'asp-dot-net.settings.resEncInvalid' => "The specified value for the Response encoding parameter is invalid.",
    'asp-dot-net.settings.sessTimeout' => "Session timeout (minutes)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "The specified value for the Session timeout parameter is invalid. Enter a positive integer number less than or equal to %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "The connection string name is already in use.",
    'asp-dot-net.settings.customErrorInvalidCode' => "The status code must be between 100 and 999",
    'asp-dot-net.settings.customErrorDuplicate' => "The status code is already in use.",
    'asp-dot-net.settings.trustLevel' => "CAS trust level",
    'asp-dot-net.settings.uiCulture' => "UI Culture",
    'asp-dot-net.settings.version' => "Version",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Allow override CAS trust level on website',
    'asp-dot-net.settings.addConnStrings' => 'Add connection string',
    'asp-dot-net.settings.addCustomErrors' => 'Add custom error',
    'asp-dot-net.settings.buttonRemove' => 'Remove',
    'asp-dot-net.settings.updateSuccess' => 'Update successful',

    'database.clone.formDescription' => 'Copy the database contents into a new or existing database. When copied to an existing database, tables of the source database are added to the list of tables in the destination database. Warning: If table names coincide, then the table from the source will replace the one in the destination.',
    'database.clone.copyData' => 'Create a full copy',
    'database.clone.copyDataHint' => 'If selected, the entire database (including structure and data) will be copied. If cleared, only the structure of tables will be copied.',
    'database.clone.server' => 'Destination database server',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Other...',
    'database.clone.database' => 'Destination database',
    'database.clone.newDatabase' => 'Create database with name',
    'database.clone.existingDatabase' => 'Copy to existing database',
    'database.clone.externalDbHost' => 'Host name or IP address',
    'database.clone.externalDbLogin' => 'Username',
    'database.clone.externalDbPassword' => 'Password',
    'database.clone.subscription' => 'Destination subscription',
    'database.clone.subscription_powerUser' => 'Destination webspace',
    'database.clone.cloneInProgress' => 'Cloning the database %%source%% to the database %%destination%%. You will be notified of the progress by email (%%email%%).',
    'database.clone.unableToClone' => 'Unable to copy the database "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Unable to create a database "%%destination%%" on the specified server.',
    'database.clone.databaseCloned' => 'The database "%%source%%" was copied.',
    'database.clone.emailSubjSuccess' => 'Database "%%sourceDatabase%%" was copied.',
    'database.clone.emailSubjFailure' => 'Copying database "%%sourceDatabase%%" failed.',
    'database.clone.emailBodySuccess' => 'Database "%%sourceDatabase%%" (%%sourceHost%%) was copied to the database "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Unable to copy database "%%sourceDatabase%%" (%%sourceHost%%) to the database "%%destDatabase%%" (%%destHost%%). The copying procedure failed.',
    'database.clone.localServer' => 'local server',

    'database.repair-orphaned.formDescription' => 'This user became orphaned after the restoration process. Please provide a password for this user to resolve this issue. If this user is supposed to be a sys user with no password, run the repair utility with empty password field.',
    'database.repair-orphaned.login' => 'Database username',
    'database.repair-orphaned.pass' => 'Password',
    'database.repair-orphaned.pass2' => 'Confirm password',
    'database.repair-orphaned.users' => 'Some users require your attention. There are several orphaned users that should be repaired in order to function properly.',
    'database.repair-orphaned.orphaned' => 'User is orphaned. %%gui begin:link%%Repair now%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Repair',

    'database.repair.fixSelected' => 'Repair Selected',
    'database.repair.fix' => 'Repair',

    'database.user.password' => 'Password',
    'database.user.passwordConfirmation' => 'Confirm password',
    'database.user.server' => 'Database server',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Database',
    'database.user.anyDatabase' => 'Any',
    'database.user.dataAccess' => 'Data Access',
    'database.user.structureAccess' => 'Structure Access',
    'database.user.globalAccess' => 'Global Privileges',
    'database.user.globalAccessHint' => 'Global privileges work for all databases within this hosting account.',
    'database.user.aclRadio' => 'Access control',
    'database.user.aclLocalhost' => 'Allow local connections only',
    'database.user.aclAny' => 'Allow remote connections from any host',
    'database.user.aclCustom' => 'Allow remote connections from',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nThe specified hosts are allowed to access the database on behalf of this user.",
    'database.user.remoteAccess' => 'Remote access',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nThe specified IP addresses are allowed to access the database server via a firewall rule. Your changes in this list will be pre-moderated by your hosting provider.",
    'database.user.example' => "For example:\n%%example%%",
    'database.user.denied' => 'Use the system firewall rules',
    'database.user.allowed' => 'Allow remote connections from',
    'database.user.default' => 'Use this user\'s credentials by default for accessing %%webadmin%%',
    'database.user.remoteAccessHint' => 'Please contact your hosting provider and make sure that the option you specified above will comply with the current firewall rules for incoming access to MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Role',
    'database.user.roleReadWrite' => 'Read and Write',
    'database.user.roleWriteOnly' => 'Write Only',
    'database.user.roleReadOnly' => 'Read Only',
    'database.user.roleCustom' => 'Custom',

    'database.generalSection' => 'General',
    'database.name' => 'Database name',
    'database.server' => 'Database server',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Related site',
    'database.noDomainRelations' => 'No related sites',
    'database.userSection' => 'Users',
    'database.userSectionDescription' => 'Create a default database user. Plesk will access the database on behalf of this user. If no database users are assigned to the database, it is not accessible.',
    'database.createUser' => 'Create a database user',
    'database.username' => 'Database user name',
    'database.password' => 'Password',
    'database.passwordConfirmation' => 'Confirm password',
    'database.allDbAccess' => 'User has access to all databases within the selected subscription',
    'database.aclRadio' => 'Access control',
    'database.aclLocalhost' => 'Allow local connections only',
    'database.aclAny' => 'Allow remote connections from any host',
    'database.aclCustom' => 'Allow remote connections from',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nThe specified hosts are allowed to access the database on behalf of this user.",
    'database.remoteAccess' => 'Remote access',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nThe specified IP addresses are allowed to access the database server via a firewall rule. Your changes in this list will be pre-moderated by your hosting provider.",
    'database.example' => "For example:\n%%example%%",
    'database.denied' => 'Use the system firewall rules',
    'database.allowed' => 'Allow remote connections from',

    'deployment-section.deploymentDisabledHint' => 'Upload files from a Git repository',
    'deployment-section.deploymentEnabledHint' => 'Enable Git support',
    'deployment-section.deploymentSectionLegend' => 'Your Files to Copy to Hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'If you leave Git support disabled, the root directories (website/application root and document root) will be created empty, and the site will display the default page in the browser. You will need to upload the files of your site to the document root using FTP or File Manager. Alternatively, enable Git now or later (in Websites & Domains) and upload files from a Git repository.',

    'dns-zone.add-acl-record.description' => 'Add an IP address of a DNS server allowed to receive a copy of the DNS zone.',
    'dns-zone.add-acl-record.ipAddress' => 'IP address',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP address/mask',

    'dns-zone.record.add-title' => "Add resource record to the zone template",
    'dns-zone.record.add-ns-title' => "Add nameserver",
    'dns-zone.record.edit-title' => "Edit resource record",
    'dns-zone.record.edit-success' => "DNS record was updated.",
    'dns-zone.record.add-success' => "DNS record was created.",
    'dns-zone.record.type' => "Record type",
    'dns-zone.record.domainName' => "Domain name",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Name server",
    'dns-zone.record.protocol' => "Protocol",
    'dns-zone.record.priority' => "Priority",
    'dns-zone.record.priorityLow' => "low (%%priority%%)",
    'dns-zone.record.priorityHigh' => "very high (%%priority%%)",
    'dns-zone.record.weightLow' => "low (%%weight%%)",
    'dns-zone.record.weightHigh' => "very high (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP address",
    'dns-zone.record.ipAddressDescription' => "For example, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "For example, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6 address",
    'dns-zone.record.ipAddressV6Description' => "For example, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "For example, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "For example, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "For example, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "For example, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Canonical name",
    'dns-zone.record.mailDomain' => "Mail domain",
    'dns-zone.record.mxServer' => "Mail exchange server",
    'dns-zone.record.mxServerPriority' => "Specify the priority of the mail exchange server",
    'dns-zone.record.txtRecord' => "TXT record",
    'dns-zone.record.txtRecordString' => "Enter record string",
    'dns-zone.record.txtSpfSyntax' => "SPF record",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Incorrect values for the TXT record were specified.",
    'dns-zone.record.dsRecord' => "DS record",
    'dns-zone.record.dsRecordDescription' => "For example, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDsRecord' => "An incorrect value for the DS record was specified.",
    'dns-zone.record.serviceName' => "Service name",
    'dns-zone.record.serviceNameDescription' => 'For example, SIP (without the underscore character).',
    'dns-zone.record.protocolNameDescription' => 'For example, tcp (without the underscore character).',
    'dns-zone.record.portDescription' => 'For example, 25 (without the underscore character).',
    'dns-zone.record.srvWeight' => "Relative weight for records with the same priority",
    'dns-zone.record.targetHost' => "Target host",
    'dns-zone.record.targetHostDescription' => "For example, example.com",
    'dns-zone.record.targetPort' => "Target port",
    'dns-zone.record.retrieveDataError' => "The record data is not found.",
    'dns-zone.record.unknownTypeError' => "Unknown DNS record type.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'Cannot set up the NULL MX record while another MX records is present.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'Cannot set up the non-NULL MX record while the NULL MX record is present.',
    'dns-zone.record.masterShouldBeRemote' => "You must have two different authoritative name servers on separate hosts.",
    'dns-zone.record.caaTag' => "Tag",
    'dns-zone.record.caaRecord' => "Value",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protocol',
    'dns-zone.record.tlsaUsage' => 'Usage',
    'dns-zone.record.tlsaSelector' => 'Selector',
    'dns-zone.record.tlsaMatching' => 'Matching type',
    'dns-zone.record.tlsaCertData' => 'Certificate association data',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'See %%link%% for details',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, section 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, section 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, section 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, section 2.1.4',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Seconds",
    'dns-zone.record.invalidValue' => 'Value is invalid. It can be from 1 second to 2147483647 seconds.',
    'dns-zone.record.ttlDefaultValue' => 'Default value: %%value%% seconds',
    'dns-zone.record.invalidTTL' => 'The specified TTL value is invalid.',
    'dns-zone.record.invalidIpAddress' => 'The specified IP address is invalid.',
    'dns-zone.record.invalidIpMaskPair' => 'The specified IP address/netmask pair is invalid.',
    'dns-zone.record.invalidCName' => 'The specified canonical name is invalid.',
    'dns-zone.record.invalidPort' => 'The specified port is invalid.',
    'dns-zone.record.invalidTLSACertData' => 'The specified certificate association data is invalid.',
    'dns-zone.record.invalidTLSAProtocol' => 'The specified protocol is invalid.',
    'dns-zone.record.invalidTLSAUsage' => 'The specified usage is invalid.',
    'dns-zone.record.invalidTLSASelector' => 'The specified selector is invalid.',
    'dns-zone.record.invalidTLSAMatching' => 'The specified matching type is invalid.',

    'dns-zone.restore-default.formHint' => "Here you can restore the original zone configuration in accordance with the default DNS template settings used on the server. Select the IP addresses to be used for restoring the zone and specify whether a www alias is required for the domain.",
    'dns-zone.restore-default.ipv4' => "IPv4 address",
    'dns-zone.restore-default.ipv4Hint' => "For example, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6 address",
    'dns-zone.restore-default.ipv6Hint' => "For example, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'The specified IP address is invalid.',
    'dns-zone.restore-default.customIpHint' => "Records with this IP address will be considered as user-modified and will not synchronize with the server-wide DNS template.",
    'dns-zone.restore-default.wwwPrefix' => "www prefix",
    'dns-zone.restore-default.previewRecords' => "Restore the records used for site previewing",

    'dns-zone.soa-record.soaMnameSection' => 'Primary Name Server',
    'dns-zone.soa-record.soaMname' => 'Name Server',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Autoselect)',
    'dns-zone.soa-record.soaRecordSection' => 'SOA record',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Refresh',
    'dns-zone.soa-record.retry' => 'Retry',
    'dns-zone.soa-record.expire' => 'Expire',
    'dns-zone.soa-record.minimum' => 'Minimum',
    'dns-zone.soa-record.rnameType' => 'Email (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'The email address of the person responsible for the domain DNS zone. Returned by the DNS server in response to SOA queries.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Website owner\'s email address',
    'dns-zone.soa-record.rnameTypeDomain' => 'Domain email address',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Enter only the local-part (before @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'External email address',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Prohibit changing the RNAME email address on a per domain basis',
    'dns-zone.soa-record.invalidValue' => 'Value is invalid. It can be from 1 second to 68 years.',
    'dns-zone.soa-record.advancedSection' => 'Advanced DNS features',
    'dns-zone.soa-record.serialNumberFormat' => 'Use the serial number format recommended by IETF and RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Select the option if your domain has issues with passing SOA check of the registrar. Many domain registrars require this serial number format.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Use Default Settings',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Zone defaults',
    'dns-zone.soa-record.unitSeconds' => 'seconds',
    'dns-zone.soa-record.unitMinutes' => 'minutes',
    'dns-zone.soa-record.unitHours' => 'hours',
    'dns-zone.soa-record.unitDays' => 'days',
    'dns-zone.soa-record.unitWeeks' => 'weeks',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Refresh Interval value is less then an hour, which may critically increase server traffic and resources usage.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Setting the Minimum TTL value that is more than 3 hours can make your domains inaccessible for some of the domain administrators. It is recommended to set such value only if your domain names registrar insists on it.',
    'dns-zone.soa-record.success' => 'The SOA record properties were updated.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'The default SOA record was restored.',

    'domain-info-section.domainName' => 'Domain name',
    'domain-info-section.emptyDomainName' => 'Please provide a domain name.',
    'domain-info-section.ipAddress' => 'IP address',
    'domain-info-section.shared' => 'shared',
    'domain-info-section.exclusive' => 'dedicated',
    'domain-info-section.ipAddressHint' => "IP address on which the website is hosted is a network address of the website's virtual host. This IP address will be used for all websites created within the subscription.",
    'domain-info-section.ipAddressHint_powerUser' => "IP address on which the website is hosted is a network address of the website's virtual host. This IP address will be used for all websites created within the webspace.",
    'domain-info-section.userName' => 'Username',
    'domain-info-section.userNameHint' => 'System user account associated with the webspace, used to access hosted files over FTP and SSH.',
    'domain-info-section.emptyLogin' => 'Please provide a username.',
    'domain-info-section.password' => 'Password',
    'domain-info-section.emptyPassword' => 'Please provide a password.',
    'domain-info-section.passwordConfirmation' => 'Repeat password',

    'email-address.generalTab' => 'General',
    'email-address.generalHint' => 'If this email account is associated with an additional user (Access to the Customer Panel is enabled), the changes you make on this page affect this user\'s settings. Particularly, if you change the email address and password, the additional user\'s login and password will be changed to the new values as well.',
    'email-address.redirectTab' => 'Forwarding',
    'email-address.redirectHint' => 'Set up forwarding of email messages to one or more email addresses.',
    'email-address.aliasesTab' => 'Email Aliases',
    'email-address.autoResponderTab' => 'Auto-Reply',
    'email-address.antispamTab' => 'Spam Filter',
    'email-address.autoResponderHint' => 'Set up an automatic response to any mail message coming to your email address. Auto-reply is a standard means to notify your correspondents that you are out of office or on vacation.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Email address',
    'email-address.externalEmail' => 'External email address',
    'email-address.externalEmailHint' => 'Will be used to reset your password if you lose access to the primary email address.',
    'email-address.user' => 'Assigned to',
    'email-address.password' => 'Password',
    'email-address.passwordConfirmation' => 'Confirm password',
    'email-address.responderEnable' => 'Switch on auto-reply',
    'email-address.responderSubject' => 'Auto-reply message subject',
    'email-address.responderContentType' => 'Message format',
    'email-address.responderContentTypeHint' => 'Plain text format is supported by all mail client programs, therefore, all recipients will see the message in the same way as you see it. HTML messages look better because they let you enter formatted text with different font styles. However, some mail clients do not support HTML messages and some of recipients may not see the formatted text.',
    'email-address.responderContentTypeTextPlain' => 'Plain text',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Encoding',
    'email-address.responderCodepageHint' => 'Encoding defines how the text characters are displayed. The recommended encoding is UTF-8.',
    'email-address.responderReplyTo' => 'Forward to',
    'email-address.responderReplyToHint' => 'When the automatic response is sent, the original message will be forwarded to the specified email address.',
    'email-address.responderForwardAddress' => 'Forward to',
    'email-address.responderForwardAddressHint' => 'When the automatic response is sent, the original message will be forwarded to the specified email address.',
    'email-address.responderMessage' => 'Auto-reply message text',
    'email-address.responderReplyToEqualsEmail' => 'The specified forwarding address is the same as this email address.',
    'email-address.responderForwardAddressEqualsEmail' => 'The specified forwarding address is the same as this email address.',
    'email-address.responderReplyLimit' => 'Send an automatic response to a unique email address no more than (times a day)',
    'email-address.buttonAddResponderAttachment' => 'Add an attachment',
    'email-address.buttonRemoveResponderAttachment' => 'Remove',
    'email-address.responderAttachment' => 'Attach a file',
    'email-address.redirectEnable' => 'Switch on mail forwarding',
    'email-address.redirectRemoveEnable' => 'Do not deliver copies of forwarded emails to the Plesk mailbox',
    'email-address.redirectAddress' => 'Forward incoming messages to the following email address',
    'email-address.redirectAddressHint' => 'Specify email addresses. You can type each address on a new line, or separate addresses with white spaces, commas, or semicolons.',
    'email-address.role' => 'User role',
    'email-address.roleHint' => 'User roles grant users administrative privileges and access to applications that you selected for the role.',
    'email-address.errorRedirectAddress' => 'You specified invalid email address: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'You specified invalid email addresses: %value%.',
    'email-address.mailAlias' => "Email alias",
    'email-address.mailAliasNone' => 'None',
    'email-address.mailAliasHint' => "Email aliases are alternative email addresses associated with a primary email address. All mail sent to email aliases will be received by the primary email address.",
    'email-address.buttonAddMailAlias' => 'Add email alias',
    'email-address.buttonRemoveMailAlias' => 'Remove',
    'email-address.emptyEmail' => 'Specify email address to which all incoming messages should be forwarded.',
    'email-address.emailsIsEqual' => 'The external email address matches the primary one. Specify a different external email address.',
    'email-address.emptyPassword' => 'You need to provide a password.',
    'email-address.emptyPasswordConfirmation' => 'You need to confirm the password.',
    'email-address.emptyAlias' => "Specify email alias for this email address.",
    'email-address.aliasEqualsEmail' => 'The specified email alias is the same as the email address.',
    'email-address.passwordHint' => 'Will be used for accessing the mailbox and for logging in to Plesk (if the corresponding option is enabled).',
    'email-address.cyclicRedirect' => 'Email address cannot be set up to forward email messages to itself.',
    'email-address.errorMailnameReserved' => 'The specified email address is already in use.',
    'email-address.antivirusEnable' => 'Switch on antivirus protection for this email address',
    'email-address.antivirusHint' => 'Antivirus service blocks email messages that contain viruses and notifies both the sender and the recipient about it.',
    'email-address.antivirusSettings' => 'Check for viruses',
    'email-address.antivirusSettingOnlyIncomingMail' => 'only incoming mail',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'only outgoing mail',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'incoming and outgoing mail',
    'email-address.antispamHint' => 'Spam filtering service detects spam messages sent to the email address. You can set the spam filter to delete the spam messages, mark them as spam by changing their subject, or move them to the special spam folder accessible by mail clients over IMAP. Spam filter uses a wide variety of local and network tests to identify spam signatures.',
    'email-address.antispamEnable' => 'Switch on spam filtering for this email address',
    'email-address.antispamSettings' => 'What to do with messages classified as spam',
    'email-address.antispamSettingsMark' => 'Mark spam messages by adding the following text to message subject',
    'email-address.antispamSettingsMarkHint' => 'Leave this field blank if you do not want to add any text. Type _SCORE_ if you want to include the score in the message subject.',
    'email-address.antispamReportTextHint' => 'Type the text that you want to add to the spam email message bodies.',
    'email-address.antispamSettingsDelete' => 'Delete all spam messages',
    'email-address.antispamSettingsDeleteHint' => 'Spam messages will be deleted from your mailbox.',
    'email-address.antispamSettingsMove' => 'Move spam to the Spam folder',
    'email-address.antispamSettingsMoveHint' => 'Move all spam messages to the folder called Spam. This folder is accessible from your mail client program or webmail. If you are using an IMAP mail account, then you can use the Spam folder for training the spam filter.',
    'email-address.antispamSettingsMoveWarning' => '"Move spam to the Spam folder" does not work unless you disable the "Do not deliver copies of forwarded emails" option on the "Forwarding" tab.',
    'email-address.antispamSettingsMoveJunk' => 'Move spam to the "Junk E-mail" folder',
    'email-address.antispamSettingsMoveJunkHint' => 'Move all spam messages to the folder called "Junk E-mail". This folder is accessible from your mail client program or webmail. If you are using an IMAP mail account, then you can use the "Junk E-mail" folder for training the spam filter.',
    'email-address.antispamShowAdvancedSection' => 'Show Advanced Settings',
    'email-address.antispamHideAdvancedSection' => 'Hide Advanced Settings',
    'email-address.antispamLearnMore' => 'Learn how to train the spam filter.',
    'email-address.antispamFilterScoreTitle' => 'Filter Sensitivity',
    'email-address.antispamFilterScoreHint' => 'Spam filter performs a number of different tests on contents and subject line of each message. As a result, each message scores a number of points. The higher the number, the more likely a message is spam. By default, the filter sensitivity is set so that all messages that score 7 or more points are classified as spam. If you receive lots of spam messages with the current setting, to make filter more sensitive, try setting a lesser value, for example, 6. If you are missing email because your spam filter thinks they are junk, try reducing filter sensitivity by setting a higher value, for example, 8.',
    'email-address.antispamFilterScore' => 'Spam filter sensitivity',
    'email-address.antispamWhiteListTitle' => 'White List',
    'email-address.antispamWhiteListHint' => 'Emails from senders in the white list are not checked by the spam filter.',
    'email-address.antispamWhiteListField' => 'White list',
    'email-address.antispamWhiteListFieldHint' => 'Type domain names, one domain name per line. Addresses can contain "*" and "?" wildcard characters, for example, *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Black List',
    'email-address.antispamBlackListHint' => 'Emails from senders in the black list are classified as spam.',
    'email-address.antispamBlackListField' => 'Black list',
    'email-address.antispamBlackListFieldHint' => 'Type domain names, one domain per line. Addresses can contain "*" and "?" wildcard characters, for example, *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Trusted Languages',
    'email-address.antispamTrustedLanguagesHint' => 'Email messages written in these languages will always pass the filter.',
    'email-address.antispamTrustedLocalesTitle' => 'Trusted Locales',
    'email-address.antispamTrustedLocalesHint' => 'Email messages that use the specified locale groups will always pass the filter. Locale groups include most commonly used character sets. For example, Western character set includes encodings for letters used in English and Western European languages.',
    'email-address.antispamTrustedNetworksTitle' => 'Trusted Networks',
    'email-address.antispamTrustedNetworksHint' => 'The relay hosts on trusted networks are considered not to be potentially operated by spammers, and they are not open relays, or open proxies.',
    'email-address.antispamIpAddressesField' => 'IP addresses',
    'email-address.antispamIpAddressesFieldHint' => 'Specify network IP address and mask.',
    'email-address.mailBoxQuotaDomainDefault' => 'Default size (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Default size',
    'email-address.mailBoxOutgoingMessages' => 'The maximum number of outgoing email messages',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Default (%%domainOutgoingMessages%% messages per hour)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Custom value for the mailbox',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'messages',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Default',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Default size',
    'email-address.mailBoxQuotaDomainSpecific' => 'Another size',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Mailbox size',
    'email-address.mailBoxQuotaUnlimited' => 'Unlimited',
    'email-address.mailBoxLimitReached' => 'The limit on the number of mailboxes has been reached.',
    'email-address.postboxEnabled' => 'Mailbox',
    'email-address.postboxEnabledYes' => 'On',
    'email-address.postboxEnabledNo' => 'Off',
    'email-address.description' => 'Description in Plesk',
    'email-address.descriptionHint' => 'The description is visible to everyone who has access to this email account.',
    'email-address.longDescription' => 'The specified description is too long. It cannot be longer than %%max%% symbols.',
    'email-address.loginAsUser' => 'Can be used to log in to Plesk',
    'email-address.loginAsUserDescription' => '(username: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'The mailbox size cannot exceed the default size.',
    'email-address.endDateEnable' => 'Switch off auto-reply on',

    'failed-request.enable-tracing.description' => 'Failed requests tracing is a resource-intensive operation. The tracing will be automatically stopped in %%days%% days. You can stop it manually at any time.',
    'failed-request.enable-tracing.statusCodes' => 'Status codes',
    'failed-request.enable-tracing.statusCodesDescription' => 'Example: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Provider',

    'file-manager.show.buttonReload' => 'Reload',
    'file-manager.show.buttonSave' => 'Save',
    'file-manager.show.buttonSaveAs' => 'Save As',
    'file-manager.show.buttonReset' => 'Reset',
    'file-manager.show.buttonTextCodeEditor' => 'Edit in Code Editor',
    'file-manager.show.buttonTextEdit' => 'Edit in Text Editor',
    'file-manager.show.buttonWysiwygEdit' => 'Edit in HTML Editor',
    'file-manager.show.eolLabel' => 'Line break type:',
    'file-manager.show.saveAs' => 'Save as:',
    'file-manager.show.saveCodepage' => 'Save in the following encoding:',
    'file-manager.show.loadCodepage' => 'View the original file in the following encoding:',
    'file-manager.show.loadCodepageHint' => 'Warning: Any unsaved changes will be lost on reloading the file.',
    'file-manager.show.fileExists' => "The file or folder %%fileName%% already exists. You cannot have a folder and a file with the same name.",
    'file-manager.show.popupTitle' => 'Save As',
    'file-manager.show.popupFilename' => 'File name:',

    'file-manager.permissions.filePermissions' => 'File permissions',
    'file-manager.permissions.directoryPermissions' => 'Directory permissions',
    'file-manager.permissions.buttonSubmit' => 'Save',
    'file-manager.permissions.buttonApply' => 'Save and resume',
    'file-manager.permissions.buttonCancel' => 'Cancel',
    'file-manager.permissions.buttonAdvanced' => 'Advanced',

    'file-manager.unix-file-permissions.group' => 'Group',
    'file-manager.unix-file-permissions.owner' => 'Owner',
    'file-manager.unix-file-permissions.others' => 'Others',
    'file-manager.unix-file-permissions.readMode' => 'Read',
    'file-manager.unix-file-permissions.writeMode' => 'Write',
    'file-manager.unix-file-permissions.execMode' => 'Execute/search',
    'file-manager.unix-file-permissions.changeRecursive' => 'Change permissions recursively',

    'file-manager.windows-permissions.allow' => 'Allow',
    'file-manager.windows-permissions.deny' => 'Deny',
    'file-manager.windows-permissions.inheritFromParent' => 'Allow inheritable permissions from the parent to propagate to this object and all child objects. Include these with the entries explicitly defined here',
    'file-manager.windows-permissions.replaceOnChildren' => 'Replace permission entries on all child objects with the entries displayed here',
    'file-manager.windows-permissions.buttonAdvanced' => 'Advanced',
    'file-manager.windows-permissions.applyTo' => 'Apply to:',
    'file-manager.windows-permissions.folderOnly' => 'This folder only',
    'file-manager.windows-permissions.subfolderOnly' => 'Subfolders only',
    'file-manager.windows-permissions.filesOnly' => 'Files only',
    'file-manager.windows-permissions.permissionsFor' => 'Permissions for',
    'file-manager.windows-permissions.applyOnto1' => 'This folder only',
    'file-manager.windows-permissions.applyOnto2' => 'Subfolders only',
    'file-manager.windows-permissions.applyOnto3' => 'This folder and subfolders',
    'file-manager.windows-permissions.applyOnto4' => 'Files only',
    'file-manager.windows-permissions.applyOnto5' => 'This folder and files',
    'file-manager.windows-permissions.applyOnto6' => 'Subfolder and files only',
    'file-manager.windows-permissions.applyOnto7' => 'This folder, subfolders, and files',
    'file-manager.windows-permissions.notInherited' => '<not inherited>',

    'file-manager.editor.titleTextEditor' => 'Text Editor',
    'file-manager.editor.titleCodeEditor' => 'Code Editor',
    'file-manager.editor.titleCodeViewer' => 'View',
    'file-manager.editor.buttonSubmit' => 'Save',
    'file-manager.editor.buttonApply' => 'Save and resume',
    'file-manager.editor.buttonSaveAs' => 'Save as ...',
    'file-manager.editor.buttonCancel' => 'Cancel',
    'file-manager.editor.exitConfirmationYes' => 'Yes',
    'file-manager.editor.exitConfirmationNo' => 'No',
    'file-manager.editor.fileOverwrite' => 'File already exists.',
    'file-manager.editor.fileOverwriteDescription' => 'A file with the same name already exists. Do you want to overwrite it?',
    'file-manager.editor.exitConfirmation' => 'Are you sure you want to close the file and discard the unsaved changes?',
    'file-manager.editor.buttonCodeEditor' => 'Edit in Code Editor',
    'file-manager.editor.buttonTextEditor' => 'Edit in Text Editor',
    'file-manager.editor.buttonHtmlEditor' => 'Edit in HTML Editor',

    'file-manager.import-file.buttonSubmit' => 'Import',
    'file-manager.import-file.fieldUrl' => 'URL for the file',
    'file-manager.import-file.fieldUrlDescription' => 'Specify the source URL, for example, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'The full URL pattern is the following: \'https://user:password@example.com/example.tgz\'. The user name and password are optional. The supported protocols are http, https, ftp, ftps. Use the URL-encoding for URL parts that contain special characters or spaces.',
    'file-manager.import-file.failure' => 'Unable to import the file.',

    'file-manager.rotation-settings.title' => 'Recycle Bin Rotation Settings',
    'file-manager.rotation-settings.rotationBySize' => 'Rotation by size',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'The option deletes new files as long as the specified limit for the recycle bin is exceeded.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotation by date',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Days',
    'file-manager.rotation-settings.rotationByDateHint' => 'The option deletes files stored in the recycle bin for more than a specified number of days.',

    'ftp-user.description' => 'If you are working on your website together with someone else or host subdomains for other users, you might want to create separate FTP accounts for them.',
    'ftp-user.generalSection' => 'General',
    'ftp-user.login' => 'FTP account name',
    'ftp-user.home' => 'Home directory',
    'ftp-user.systemArea' => 'Create an FTP account with access to files outside the home directory',
    'ftp-user.password' => 'Password',
    'ftp-user.passwordConfirmation' => 'Confirm password',
    'ftp-user.hardQuotaSection' => 'Hard disk quota',
    'ftp-user.hardQuota' => 'Hard disk quota',
    'ftp-user.hardQuotaUnlimited' => 'Unlimited',
    'ftp-user.permissionsSection' => 'Permissions',
    'ftp-user.permissionRead' => 'Read permission',
    'ftp-user.permissionWrite' => 'Write permission',
    'ftp-user.popupTitle' => 'Select Directory',

    'mail-list.listName' => 'Mailing list address',
    'mail-list.enabled' => 'Switched on',
    'mail-list.administratorEmail' => 'Mailing list administrator\'s email',
    'mail-list.password' => 'Password',
    'mail-list.passwordConfirmation' => 'Confirm password',
    'mail-list.subscribers' => 'Subscribers',
    'mail-list.subscribersHint' => 'Specify email addresses. You can type each address on a new line, or separate addresses with the space, comma, or semicolon symbols.',
    'mail-list.notify' => 'Notify administrator on the mailing list creation',
    'mail-list.emptyPassword' => 'Provide a password.',
    'mail-list.emptyPasswordConfirmation' => 'Please confirm the password.',
    'mail-list.errorSubscribers' => 'Invalid email addresses: %value%.',
    'mail-list.errorMaillistReserved' => 'The specified mailing list address is already in use.',

    'mail-settings.hint' => 'This is where you can change the mail service settings for this domain.',
    'mail-settings.service' => 'Mail service on this domain',
    'mail-settings.nonExist' => 'What to do with mail for non-existent users',
    'mail-settings.nonExistBounceWithMessage' => 'Bounce with message',
    'mail-settings.nonExistBounce' => 'Bounce',
    'mail-settings.nonExistCatch' => 'Forward to address',
    'mail-settings.nonExistCatchDescription' => 'The address should belong to the selected domain. Only the administrator can specify an external address or one address for several domains.',
    'mail-settings.nonExistExternal' => 'Redirect to an external mail server with the IP address',
    'mail-settings.nonExistReject' => 'Reject',
    'mail-settings.nonExistDiscard' => 'Reject',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'None',
    'mail-settings.webmailComponentNotInstalled' => 'The webmail component was not installed.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'There is a subdomain with the name %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'SSL/TLS certificate for webmail',
    'mail-settings.webmailCertificateNone' => 'Not selected',
    'mail-settings.mailCertificate' => 'SSL/TLS certificate for mail',
    'mail-settings.mailCertificateNone' => 'Not selected',
    'mail-settings.serverCertificateNotSelected' => 'The certificate was assigned, but mail for the domain was not secured. To finish securing mail for the domain, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'secure the mail server',
    'mail-settings.mailLists' => 'Enable mailing lists',
    'mail-settings.mailAutodiscovery' => 'Enable mail autodiscover',
    'mail-settings.mailAutodiscoveryDescription' => 'See how it works in the %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'knowledge base',
    'mail-settings.domainKeys' => 'Use DKIM spam protection system to sign outgoing email messages',
    'mail-settings.greyListing' => 'Switch on greylisting spam protection for all mail accounts under this domain',
    'mail-settings.howToConfigureExternalDns' => 'How to configure external DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'To enable DKIM signing if you use an external DNS server, you need to configure DKIM DNS records on the DNS server yourself.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'To do so, use the DKIM DNS records below:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'If you have domain aliases you use to send mail, add the DKIM DNS records for them as well. Use the same records as for the main domain but with the domain alias name.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'To see the DKIM DNS records you need to configure, select the "%%option%%" checkbox, apply it and open this pop-up again.',
    'mail-settings.mailServiceDisabled' => 'Disabled',
    'mail-settings.mailServiceDisabledIncoming' => 'Disabled for incoming mail',
    'mail-settings.mailServiceDisabledHint' => 'Plesk will not provide any mail services on this domain.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'This domain can only send mail, and only using Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Enabled',
    'mail-settings.mailServiceEnabledHint' => 'This domain can send and receive mail.',
    'mail-settings.mailServiceNotConfigured' => 'Not configured',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk will not provide any mail services on this domain.',
    'mail-settings.warning' => 'This will permanently remove the domain’s mailboxes with all received and sent emails.',
    'mail-settings.show.title' => 'Remove all mailboxes and emails of %%domain%%',
    'mail-settings.show.checkbox' => 'Permanently remove all mailboxes of <b>%%domain%%</b>, including received and sent emails.',

    'role.roleSection' => 'General',
    'role.name' => 'User role name',
    'role.description' => 'Description',
    'role.generalPermissionsSection' => 'Access to Plesk services',
    'role.applicationsAccessSection' => 'Access to apps',
    'role.permissionAllow' => 'Granted',
    'role.permissionDeny' => 'Denied',
    'role.emptyRoleName' => 'Please provide a role name.',
    'role.installedAt' => 'Installed at',
    'role.noInstallationUrlAvailable' => 'External app',
    'role.invalidRoleName' => 'The specified user role name is not valid. Question marks and quotation marks cannot be used in the role name.',
    'role.longRoleName' => 'The specified user role name is too long.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Some operations may not be available for the following reasons: a permission for operation is not granted with the currently selected subscription, or the amount of allocated resources is not enough to perform an operation.',
    'role.servicesPermissionsDescription' => 'Define access to installed apps or Plesk services for all users with this role. If you grant a user access to an app, the app will become available to them in Customer Panel.',
    'role.emailActivation' => 'Activate this role\'s accounts by email',

    'service.admin-access.adminAccess' => 'Administrative access',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'These credentials will be used for administrative access to this application.',
    'service.admin-access.login' => 'Administrative username',
    'service.admin-access.password' => 'Administrative password',
    'service.admin-access.passwordConfirmation' => 'Confirm password',

    'service.info.service-entry-point.availableAt' => 'Available at',
    'service.info.service-entry-point.customize' => 'Customize shortcut',
    'service.info.service-entry-point.displayNameLabel' => 'Shortcut name',
    'service.info.service-entry-point.displayNameDescription' => 'Provide a name for this shortcut. The name is shown under the shortcut icon. Shortcuts are placed on My Services pages of users who were granted the access to this application.',
    'service.info.service-entry-point.descriptionLabel' => 'Shortcut description',
    'service.info.service-entry-point.descriptionDescription' => 'Provide a description for this shortcut. The description is shown as a tooltip when mouse cursor hovers over the shortcut.',
    'service.info.service-entry-point.iconLabel' => 'Click to select the shortcut icon',
    'service.info.service-entry-point.iconCurrent' => 'Current icon',
    'service.info.service-entry-point.errorEmptyName' => 'You need to provide a shortcut name',
    'service.info.service-entry-point.errorLongName' => 'Shortcut name should be between 1 and 255 characters.',
    'service.info.service-entry-point.errorLongDescription' => 'Shortcut description should be between 0 and 255 characters.',
    'service.info.service-entry-point.hiddenLabel' => 'Hide shortcut',
    'service.info.service-entry-point.hiddenDescription' => 'Do not show this shortcut to users.',

    'service.info.service-permission.assignedUser' => "Grant administrator's access to this user",
    'service.info.service-permission.assignedUserNone' => 'No user assigned',

    'shared-ssl.master-ssl.switchedOn' => 'Switch on shared SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Domain name of a site whose SSL/TLS certificate will be shared among other sites',
    'shared-ssl.master-ssl.none' => 'None',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Shared SSL/TLS cannot be switched on because there are no domains with enabled SSL/TLS support.',

    'user.email.email' => 'Email address',
    'user.email.emptyEmail' => 'You need to provide an email address.',
    'user.email.internalEmailHint' => 'Create a new email address in Plesk or use an external email address.',
    'user.email.longInternalEmail' => 'The email address is too long.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'The username part of the email address is too long for this mail server. Please specify a username no longer than %%max%% symbols.',
    'user.email.longInternalEmailFullAddressMailServer' => 'The email address is too long for this mail server. Please specify an address no longer than %%max%% symbols.',
    'user.email.externalEmail' => 'External email address',
    'user.email.externalEmailHint' => 'Will be used to reset your password if you lose access to the primary email address.',
    'user.email.emailsIsEqual' => 'The external email address matches the primary one. Specify a different external email address.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Please specify either internal or external email address.',

    'user.profileSection' => 'General Information',
    'user.contactName' => 'Contact name',
    'user.email' => 'Email address',
    'user.role' => 'User role',
    'user.accountSection' => 'Plesk Preferences',
    'user.login' => 'Username',
    'user.password' => 'Password',
    'user.buttonBack' => 'Back',
    'user.generalTab' => 'General',
    'user.applicationsAccessSection' => 'Services',
    'user.generalPermissionsSection' => 'Privileges',
    'user.contactsTab' => 'Contact Details',
    'user.passwordConfirmation' => 'Confirm password',
    'user.internalEmailPasswordChanged' => 'Changing the password will also change the internal email address password.',
    'user.emailName' => 'Email address',
    'user.emailType' => 'Email type',
    'user.companyName' => 'Company name',
    'user.phone' => 'Phone number',
    'user.imNumber' => 'Instant messenger',
    'user.fax' => 'Fax number',
    'user.address' => 'Address',
    'user.city' => 'City',
    'user.state' => 'State or province',
    'user.zip' => 'Postal or ZIP code',
    'user.country' => 'Country',
    'user.additionalInfo' => 'Additional information',
    'user.additionalInfoHint' => 'Plain text only: All HTML tags will be ignored.',
    'user.language' => 'Plesk language',
    'user.buttonChangePassword' => 'Change Password',
    'user.permissionAllow' => 'Granted',
    'user.permissionDeny' => 'Denied',
    'user.permissionInherited' => 'Defined by role',
    'user.emptyContactName' => 'You need to provide a contact name.',
    'user.emptyLogin' => 'You need to provide a username.',
    'user.emptyPassword' => 'You need to provide a password.',
    'user.emptyPasswordConfirmation' => 'You need to confirm the password.',
    'user.chooseDomainBoxTitle' => 'Select another domain:',
    'user.userIsActive' => 'User is active',
    'user.userIsActiveHint' => 'Active users can access Plesk.',
    'user.emailActivation' => 'Activate account by email',
    'user.emailHint' => 'To provide the user with an email address hosted on this server, go to the Mail tab, create specified email address and associate it with this user.',
    'user.emailContactHint' => 'Contact your service provider if you want to use an email address hosted on this server.',
    'user.personalEmailHint' => "This user's email address can be changed on the Mail tab.",
    'user.externalMailRedirectHint' => 'Forwarding can be activated only for email addresses hosted on this server. To create an email address, go to the Mail tab.',
    'user.externalMailRedirectHint2' => 'Forwarding can be activated only for email addresses hosted on this server.',
    'user.externalMailAutoResponderHint' => 'Auto-reply can be activated only for email addresses hosted on this server. To create an email address, go to the Mail tab.',
    'user.externalMailAutoResponderHint2' => 'Auto-reply can be activated only for email addresses hosted on this server.',
    'user.roleHint' => 'User roles grant users administrative privileges and access to applications that you selected for the role.',
    'user.cannotManageMail' => "You do not have the permission to manage mail settings and services.",
    'user.longCompanyName' => 'The specified company name is too long.',
    'user.longPhone' => 'The specified phone number is too long.',
    'user.longFax' => 'The specified fax number is too long.',
    'user.longAddress' => 'The specified address is too long.',
    'user.longCity' => 'The specified city name is too long.',
    'user.phoneRegexNotMatch' => 'The specified phone number is not valid.',
    'user.faxRegexNotMatch' => 'The specified fax number is not valid.',
    'user.shortCity' => 'The specified city name is too short.',
    'user.limitSubscription' => 'Access to subscriptions',
    'user.limitSubscriptionHint' => 'Allow users to access only a specified subscription. The "All" value grants them access to all subscriptions within your hosting account.',
    'user.limitSubscriptionAll' => 'All',
    'user.deletedSubscription' => 'Removed subscription',

    'web.add-domain-alias.title' => 'Add a Domain Alias',
    'web.add-domain-alias.createdSuccessfully' => "The domain alias %%name%% was created.",
    'web.add-domain-alias.domainAliasName' => 'Domain alias name',
    'web.add-domain-alias.domainAliasNameHint' => 'For example, example.net',
    'web.add-domain-alias.forDomain' => 'for the domain',
    'web.add-domain-alias.settingsSectionLegend' => 'Settings',
    'web.add-domain-alias.settingsDns' => 'Synchronize DNS zone with the primary domain',
    'web.add-domain-alias.settingsMail' => 'Mail service',
    'web.add-domain-alias.settingsWeb' => 'Web service',
    'web.add-domain-alias.settingsSeoRedirect' => 'Redirect with the HTTP 301 code',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'When visitors open the alias\'s URL, they will be redirected to the URL of the primary domain. Plesk uses the search engine-friendly HTTP 301 redirection, which means the search engine ranking will not be split between the URLs.',
    'web.add-domain-alias.settingsTomcat' => 'Java web applications',
    'web.add-domain-alias.invalidDomainGuid' => 'Invalid Domain',

    'web.add-domain.formTitle' => 'Adding New Domain',
    'web.add-domain.portalLink' => 'Services portal',
    'web.add-domain.domainName' => 'Domain name',
    'web.add-domain.domainNameHint' => "For example, example.com",
    'web.add-domain.assignToCustomer' => 'Assign this domain to a customer',
    'web.add-domain.customer' => 'Select a customer',
    'web.add-domain.createNewCustomer' => 'Create a new customer',
    'web.add-domain.selectExistingCustomer' => 'Select an existing customer:',
    'web.add-domain.customerContactInfoHint' => 'Enter the customer contact information. You can specify all other information like phone number and address later.',
    'web.add-domain.customerLoginInfoHint' => 'Credentials for the customer panel',
    'web.add-domain.target' => 'Webspace',
    'web.add-domain.createNewTarget' => 'Create a new subscription',
    'web.add-domain.createNewTarget_powerUser' => 'Create a new webspace',
    'web.add-domain.selectExistingTarget' => 'Select an existing subscription:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Select an existing webspace:',
    'web.add-domain.dns' => 'Activate the DNS service',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Activate the mail service',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Works if the subscription\'s settings allow managing the mail permission per domain. If they do not allow, the actual mail service status will be taken from the subscription.',
    'web.add-domain.hostingManagementOptions' => 'Hosting type',
    'web.add-domain.websiteHosting' => 'Website hosting',
    'web.add-domain.websiteForwarding' => 'Forwarding',
    'web.add-domain.websiteNoHosting' => 'No hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Hosting Settings',
    'web.add-domain.domainCreatedSuccessfully' => 'The domain %%domainName%% was successfully created.',
    'web.add-domain.webspaceLegend' => 'Webspace settings',
    'web.add-domain.addWhmWebsiteTitle' => 'Adding New Website',
    'web.add-domain.addWhmWebsiteHint' => "You can choose to host a website on the server.",
    'web.add-domain.selectWhmDomain' => 'Select domain',
    'web.add-domain.customerLegend' => 'Customer Info',
    'web.add-domain.credentials' => 'System user credentials',
    'web.add-domain.credentialsHint' => 'to access hosted files over FTP and SSH',
    'web.add-domain.credentialsHintWin' => 'to access hosted files over FTP and RDP',
    'web.add-domain.buttonAddDomain' => 'Add Domain',

    'web.add-subdomain.formTitle' => 'Add a Subdomain',
    'web.add-subdomain.formGeneralHint' => 'Subdomains are Internet addresses for different sections of your website. They use your main domain name and a prefix. For example, if your domain is domain.com, a subdomain might be store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'You can also create a wildcard subdomain by entering the * symbol instead of the name. Site visitors will be redirected to this subdomain regardless of the subdomain name they enter in a browser.',
    'web.add-subdomain.subdomainName' => 'Subdomain name',
    'web.add-subdomain.subdomainNameHint' => 'Enter * to create a wildcard subdomain.',
    'web.add-subdomain.forDomain' => 'Parent domain',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'The subdomain was created.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Hosting Settings',

    'web.change-hosting.formGeneralHint' => 'You can choose to host the website on the server (Website hosting), to set up web forwarding to another website (Forwarding), or to use the domain\'s DNS zone for having mailboxes under this domain name (No hosting).',
    'web.change-hosting.changed' => 'The hosting type for %%domainName%% was successfully changed.',
    'web.change-hosting.hostingManagementOptions' => 'Hosting type',
    'web.change-hosting.websiteHosting' => 'Website hosting',
    'web.change-hosting.websiteForwarding' => 'Forwarding',
    'web.change-hosting.websiteNoHosting' => 'No web hosting',
    'web.change-hosting.hostingSettingsSectionLegend' => 'Hosting settings',
    'web.change-hosting.userName' => 'Username',
    'web.change-hosting.userNameHint' => 'System user for managing files and folders within the subscription.',
    'web.change-hosting.userNameHint_powerUser' => 'System user for managing files and folders within the webspace.',
    'web.change-hosting.emptyLogin' => 'You need to specify a username.',
    'web.change-hosting.password' => 'Password',
    'web.change-hosting.emptyPassword' => 'You need to specify a password.',
    'web.change-hosting.passwordConfirmation' => 'Confirm password',
    'web.change-hosting.warningInstalledApplications' => 'There are web applications installed on the site. If you change the hosting type, they will no longer be accessible.',
    'web.change-hosting.removeWebsiteHostingTitle' => 'Warning: The content of the website will be deleted.',
    'web.change-hosting.removeWebsiteHostingDescription' => 'Do you want to change the hosting type for your website?',
    'web.change-hosting.removeWebsiteHostingDescriptionFolders' => 'Following folders and their entire content will be deleted:',
    'web.change-hosting.removeWebsiteHostingDescriptionAllFolders' => 'All contents of webspace root folder will be deleted.',

    'web.change-status.changed' => 'The website status for %%domainName%% was successfully changed.',
    'web.change-status.statusManagementOptions' => 'Website status',
    'web.change-status.statusDisabled' => 'Disabled (formely known as Suspended)',
    'web.change-status.statusSuspended' => 'Suspended',
    'web.change-status.statusActive' => 'Active',
    'web.change-status.statusDisabledHint' => 'The website will no longer be hosted on the server and will be unavailable except by FTP clients and File Manager. Visitors will see the web server\'s default page. The mail service will be unavailable.',
    'web.change-status.statusSuspendedHint' => 'The website will remain hosted on the server, but visitors will be redirected with the 503 HTTP code to the custom error document page. The mail service will remain available. Here you can %%link%%.',
    'web.change-status.statusSuspendedHintNoLink' => 'Visitors will be redirected with the search engine-friendly 503 HTTP code to the custom error document page, although the website will remain hosted on the server. The mail service will remain available.',
    'web.change-status.error503PageLink' => 'edit the custom error document',
    'web.change-status.statusActiveHint' => 'The website will operate as usual.',
    'web.change-status.notActivatedSuspended' => 'The domain or website %%domainName%% cannot be activated because it was suspended by your hosting provider.',
    'web.change-status.notActivatedDisabled' => 'The domain or website %%domainName%% cannot be activated because it was disabled by your hosting provider.',

    'web.edit.formTitle' => 'Web Hosting Access for %%name%%',
    'web.edit.formGeneralHint' => 'Here you can view the IP addresses associated with your subscription and change the username and password of your system user.',
    'web.edit.formGeneralHint_powerUser' => 'Here you can view the IP addresses associated with this webspace and change the username and password of your system user.',
    'web.edit.ipAddressesLegend' => 'IP addresses',
    'web.edit.ipAddresses' => 'IP Addresses',
    'web.edit.certificateLegend' => 'Certificate',
    'web.edit.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web.edit.certificateFromOtherRepository' => '%%name%% (owned by another user)',
    'web.edit.userAccountLegend' => 'System user',
    'web.edit.systemUserHint' => 'Here you can specify an operating system user for managing files and folders within the subscription by FTP or with File Manager. The system user is also used to access Plesk over SSH (on Linux) or RDP (on Windows) if the corresponding permissions are granted.',
    'web.edit.systemUserHint_powerUser' => 'Here you can specify an operating system user for managing files and folders within the webspace by FTP or with File Manager. The system user is also used to access Plesk over SSH (on Linux) or RDP (on Windows) if the corresponding permissions are granted.',
    'web.edit.login' => 'Username',
    'web.edit.emptyLogin' => 'Please specify a username.',
    'web.edit.password' => 'Password',
    'web.edit.passwordConfirmation' => 'Confirm password',
    'web.edit.emptyPassword' => 'Please specify a password.',
    'web.edit.emptyPasswordConfirmation' => 'Please confirm the password.',
    'web.edit.shellUnix' => "Access to the server over SSH",
    'web.edit.shellHintUnix' => "Access to the server over SSH with system user's credentials.",
    'web.edit.shellWin' => 'Access to the server over Remote Desktop',
    'web.edit.shellHintWin' => "Access to the server over Remote Desktop with system user's credentials.",
    'web.edit.diskQuotaLegend' => 'Hard quota on disk space',
    'web.edit.diskQuotaHint' => 'The hard quota on disk space is the limit on the amount of disk space that can be used. If the hard quota is set, and all allocated disk space is used, no further operations on files can be performed.',
    'web.edit.diskQuota' => 'Hard quota on disk space',
    'web.edit.diskQuotaUnlimited' => 'Unlimited',
    'web.edit.diskQuotaLimited' => '%%limit%% MB',
    'web.edit.diskQuotaNotSupported' => 'Unlimited. Hard disk quota is not supported due to the configuration of the server file system.',
    'web.edit.limitMbUnits' => 'MB',
    'web.edit.successfullyUpdated' => 'Hosting settings were successfully updated.',
    'web.edit.affectedDomainsLegend' => 'Websites to which these settings apply',
    'web.edit.affectedDomainsHint' => 'The following websites are associated with the current system user. The changes in web hosting access settings you make on this page will apply to all these websites.',

    'web.mobile.create.formTitle' => 'Create Mobile Site',
    'web.mobile.create.formGeneralHint' => 'Specify mobile site name — a URL by which the mobile site will be accessed. Usually, prefixes like "m", "mob", "mobi", "mobile" and so on are used, for example: mobile.example.com. You can use this URL then in a link like "Mobile version" at your regular site, so that your site visitors will be able to switch between the mobile and regular versions.',
    'web.mobile.create.prefix' => 'Site name',
    'web.mobile.create.emptySiteName' => 'Mobile site name cannot be empty, it would have conflicted with your regular website.',

    'web.security-section.securitySectionLegend' => 'Security',
    'web.security-section.securitySectionHint' => 'To secure transactions with your site, use SSL/TLS protocol, which encrypts all data and transfers it over a secure connection. To employ SSL/TLS, move this site to a dedicated IP address, install an SSL/TLS certificate on the site, and then select it below.',
    'web.security-section.securitySectionSniHint' => 'To secure transactions with your site, use SSL/TLS protocol, which encrypts all data and transfers it over a secure connection. To employ SSL/TLS, install an SSL/TLS certificate on the site, and then select it below.',
    'web.security-section.enableSslSupport' => 'SSL/TLS support',
    'web.security-section.enableSslRedirect' => 'Permanent SEO-safe 301 redirect from HTTP to HTTPS',

    'web.seo-settings.seoRedirectDirection' => 'Preferred domain',
    'web.seo-settings.seoRedirectDirectionHint' => 'Select the URL (either with or without the www. prefix) to which site visitors will be redirected via a SEO-safe HTTP 301 redirect.',
    'web.seo-settings.seoRedirectDirectionNone' => 'None',

    'web.settings.formGeneralHint' => 'This is where you configure website hosting settings and select the features available for your site.',
    'web.settings.hostingType' => 'Hosting type',
    'web.settings.websiteHosting' => 'Website',
    'web.settings.forwardingHosting' => 'Forwarding',
    'web.settings.noHosting' => 'No hosting',
    'web.settings.changeHosting' => 'Change',
    'web.settings.websiteStatus' => 'Website status',
    'web.settings.changeStatus' => 'Change',
    'web.settings.active' => 'Active',
    'web.settings.suspended' => 'Suspended',
    'web.settings.disabled' => 'Disabled',
    'web.settings.webScriptingSectionLegend' => 'Web scripting and statistics',
    'web.settings.webScriptingSectionHint' => 'Specify which of the following programming and scripting languages should be interpreted, executed or otherwise processed by the web server.',
    'web.settings.__asp_win_support' => 'Microsoft ASP support',
    'web.settings.__asp_dot_net_support' => 'Microsoft ASP.NET support',
    'web.settings.__asp_dot_net_version' => 'Version',
    'web.settings.__asp_dot_net_version_readonly' => 'version %%value%%',
    'web.settings.__ssi_support' => 'SSI support',
    'web.settings.__ssi_with_html' => 'use SSI for *.htm, *.html files',
    'web.settings.__php_support' => 'PHP support',
    'web.settings.__php_run_as' => 'run PHP as',
    'web.settings.__php_served_by_apache' => 'served by Apache',
    'web.settings.__php_served_by_nginx' => 'served by nginx',
    'web.settings.__cgi_support' => 'CGI support',
    'web.settings.__cgi_bin_mode' => 'cgi-bin directory is located in',
    'web.settings.__cgi_bin_mode_webspace' => 'the root directory of webspace',
    'web.settings.__cgi_bin_mode_www_root' => 'the document root of this domain',
    'web.settings.__cgi_bin_mode_old_style' => 'the old-style root of this domain',
    'web.settings.__cgi_bin_mode_readonly' => 'cgi-bin directory is located in %%value%%',
    'web.settings.__perl_unix_support' => 'Perl support',
    'web.settings.__perl_win_support' => 'Perl support',
    'web.settings.__python_unix_support' => 'Python support',
    'web.settings.__python_win_support' => 'Python support',
    'web.settings.__fastcgi_unix_support' => 'FastCGI support',
    'web.settings.__webstat_support' => 'Web statistics',
    'web.settings.__plesk_stat_protect' => 'Protect access to your web statistics with your FTP username and password',
    'web.settings.__plesk_stat_protected' => 'Access to your web statistics is protected with your FTP username and password',
    'web.settings.__apache_errdocs' => 'Custom error documents',
    'web.settings.__php_module_handler' => 'mod_php',
    'web.settings.__php_fastcgi_handler' => 'FastCGI application',
    'web.settings.__php_cgi_handler' => 'CGI application',
    'web.settings.__php_isapi_handler' => 'ISAPI extension',
    'web.settings.__php_version' => 'PHP version',
    'web.settings.__hosting_write_modify' => 'Additional write/modify permissions',
    'web.settings.__hosting_webdeploy' => 'Web Deploy publishing',
    'web.settings.awstats' => 'AWStats',
    'web.settings.webalizer' => 'Webalizer',
    'web.settings.smarterstats' => 'SmarterStats',
    'web.settings.__none' => 'None',
    'web.settings.activate' => 'Activate',
    'web.settings.deactivate' => 'Suspend',
    'web.settings.__php_support_readonly' => 'version: %%version%%; handler: %%handler%%',
    'web.settings.__php_support_readonly_not_registered' => 'not registered',
    'web.settings.domainName' => 'Domain name',
    'web.settings.domainNameHint' => "For example, example.com",
    'web.settings.sameSslCompatibilitySectionLegend' => 'Compatibility mode for the legacy option "Separate SSL/TLS and non-SSL/TLS content"',
    'web.settings.sameSslCompatibilityModeCheckbox' => 'Run the website in compatibility mode for the legacy option "Separate SSL/TLS and non-SSL/TLS content"',
    'web.settings.sameSslCompatibilityHint' => 'You see this section because you used the "Separate SSL/TLS and non-SSL/TLS content" option before upgrade. In Plesk 11, the option is deprecated. All websites created in Plesk 11 use the same directory to store the content available over HTTP and HTTPS connections. It means that this site is still working in the compatibility mode, but you cannot manage it through Plesk. It is highly recommended to move all your data from the httpsdocs/ directory to httpdocs/, and turn the compatibility mode off after that. After you switch the compatibility mode off, you will not be able to switch it on again, and this section will no longer appear. Note that if you install apps into the httpsdocs/ directory when the compatibility mode is switched on, the apps will not be accessible over the Internet. If you want to install apps to httpsdocs/, switch the compatibility mode off.',
    'web.settings.willBeAppliedAfterApacheRestartInterval' => 'The website settings will be applied in %%restartInterval%% minutes.',
    'web.settings.phpSettingsDescription' => 'This page displays the PHP configuration for the website. These settings are specific to the website and do not affect other websites on the subscription. You can change the PHP configuration if the hosting provider grants you the corresponding permission. Custom PHP configuration can be used, for example, to limit the consumption of system resources by PHP scripts, or meet the requirements of a certain web app. When you set the value of a parameter to Default, PHP uses the parameter\'s value from the server-wide PHP configuration.',
    'web.settings.phpSettingsAvailableVariables' => 'You can use the following placeholders in parameter values:',
    'web.settings.phpSettingsVariableDocroot' => '{DOCROOT} for the document root directory of the website. The current value is %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'web.settings.phpSettingsVariableDocrootHttpsSame' => 'The HTTPS document root directory is the same as for http.',
    'web.settings.phpSettingsVariableDocrootHttpsDifferent' => 'The HTTPS document root directory is %%DOCROOT%%.',
    'web.settings.phpSettingsVariableWebspaceRoot' => '{WEBSPACEROOT} for the document root directory of the subscription\'s primary website.',
    'web.settings.phpSettingsVariableTmp' => '{TMP} for the directory which stores temporary files.',
    'web.settings.phpSettingsPhpVersion' => 'Your PHP version is %%version%%.',
    'web.settings.phpSettingsPhpDisabled' => 'PHP is switched off.',
    'web.settings.phpHandlerTypeHint' => 'Note that changing the PHP handler type may disrupt the operation of existing PHP scripts on this website.',
    'web.settings.fpmDedicatedHandlerHint' => 'Using this handler increases the stability of a website, but also causes an additional memory consumption.',
    'web.settings.phpHandlerChangeHint' => 'You have changed the PHP handler settings. If you save these changes, PHP scripts on your website may stop for %%interval%% seconds because of your server configuration.',
    'web.settings.phpHandlerTypeHelpLink' => 'Learn how to choose the most suitable PHP settings',
    'web.settings.phpHandlerTypeNotAvailableHint' => 'PHP support cannot be enabled because current hosting configuration does not include any PHP versions available for this domain.',
    'web.settings.phpHandlerTypeNotAvailableHelpLink' => 'Find out how to enable other PHP versions.',
    'web.settings.phpHandlerBroken' => 'The currently selected PHP handler is corrupted. Select a different handler.',
    'web.settings.phpHandlerOutdated' => '(Outdated)',
    'web.settings.phpHandlerDeprecated' => '(Deprecated)',

    'web.setupService.formTitle' => 'Setup service: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'The \'%%serviceReference%%\' service was successfully updated.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% subdomains:',
    'web.site-copy.destinationTypeSection' => 'Copy Destination',
    'web.site-copy.destinationType' => 'Select where the site files should be copied',
    'web.site-copy.destinationTypeSite' => 'Website in Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copy the site files to another site of yours hosted under this account. If you have an FTP access to another account on this server, use the FTP Storage option.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copy the site files to another site hosted on this server.',
    'web.site-copy.destinationTypeSiteSelect' => 'Site name',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Files of the site %%source%% cannot be copied to %%destination%% because %%destination%% is also a part of those files — its document root is a subdirectory of the %%source%% document root.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Files of the site %%destination%% cannot be removed because the %%source%% files are a part of them — the %%source%% document root is a subdirectory of %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'FTP storage',
    'web.site-copy.destinationTypeFtpDescription' => 'Copy website files to an FTP account on this or an external server.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copy website files to an FTP account on an external server.',
    'web.site-copy.destinationTypeFtpHost' => "Server host name",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Directory',
    'web.site-copy.destinationTypeFtpUser' => 'Username',
    'web.site-copy.destinationTypeFtpPassword' => 'Password',
    'web.site-copy.destinationTypeFtpMode' => 'FTP connection method',
    'web.site-copy.destinationTypeFtpModeActive' => 'Active mode',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'In active mode, Plesk sends its IP address and port number on which it will listen to an external server, and the server initiates the TCP connection. This mode is recommended when the Plesk-managed server is not protected by a firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Passive mode',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'The passive mode can be used when the Plesk-managed server is behind a firewall and is unable to accept incoming TCP connections.',
    'web.site-copy.existingFiles' => 'What to do with existing files',
    'web.site-copy.existingFilesKeep' => 'Keep existing files on the destination site',
    'web.site-copy.existingFilesKeepDescription' => 'Overwrite existing files with coinciding file names on the destination site.',
    'web.site-copy.existingFilesDelete' => 'Delete all existing files',
    'web.site-copy.existingFilesDeleteDescription' => 'Delete all files on the destination site before copying.',
    'web.site-copy.emptyLogin' => 'Specify an FTP account username.',
    'web.site-copy.emptyHost' => 'Specify a server host name.',
    'web.site-copy.emptyPort' => 'Specify a server host port.',
    'web.site-copy.copyInProgress' => 'Copying the website %%sourceName%% to %%destinationName%%. You will be notified of the progress by email (%%email%%).',
    'web.site-copy.unableToCopy' => 'Copying the website files failed.',
    'web.site-copy.siteCopied' => 'The website files were copied.',
    'web.site-copy.emailSubjSuccess' => 'The website "%%source%%" files were copied.',
    'web.site-copy.emailSubjFailure' => 'Copying the website "%%source%%" files failed.',
    'web.site-copy.emailBodySuccess' => 'The website "%%source%%" files were copied to "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Copying the website "%%source%%" files to "%%destination%%" failed: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Forwarding Settings',
    'web._shared.forwardDestination' => 'Destination address',
    'web._shared.forwardDestinationHint' => 'URL of the target website.',
    'web._shared.forwardingTypeOptions' => 'Forwarding type',
    'web._shared.forwardingFrame' => 'Frame forwarding',
    'web._shared.forwardingFrameHint' => 'Redirect website visitors to another site, but do not show them the destination address, so they do not know about the redirection.',
    'web._shared.forwardingHttpCode301' => 'Moved permanently (code 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Redirect website visitors to another site and show them the destination address. Such redirection will keep the site\'s search engine rankings.',
    'web._shared.forwardingHttpCode302' => 'Moved temporarily (code 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Redirect website visitors to a temporary site copy when you do not want search engines to index this temporary site.',
    'web._shared.documentRoot' => 'Document root',
    'web._shared.documentRootHint' => 'The path to the website home directory.',
    'web._shared.documentRootHintDisabledDueApplications' => 'It is impossible to change document root because there are web applications installed on this website.',
    'web._shared.ipAddress' => 'IP Address',
    'web._shared.shared' => 'shared',
    'web._shared.exclusive' => 'dedicated',
    'web._shared.ipAddressHint' => "The IP address on which the website is hosted is a network address of the website's virtual host.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (other repository)',
    'web._shared.certificate' => 'Certificate',
    'web._shared.sameCertificatesHint' => 'The selected certificate will be used for all sites hosted on the same dedicated IP address.',
    'web._shared.differentCertificatesHint' => 'This subscription is associated with two dedicated IP addresses with two different certificates. The selected certificate will replace any certificates installed on sites hosted on these two IP addresses.',
    'web._shared.differentIpTypesCertificateHint' => 'This subscription is associated with one shared and one dedicated IP address. The selected certificate will also be used for all other sites hosted on the dedicated IP address.',
    'web._shared.certificateNotSelected' => 'Not selected',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'There are no SSL/TLS certificates in your repository. To add a certificate, go to %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'this page',

    'web-user.settings.allowScripts' => 'Allow web users to use scripts',

    'web-user.name' => 'Username for connecting to the server over FTP',
    'web-user.longName' => 'This username name is too long (maximum %max% symbols are allowed).',
    'web-user.password' => 'Password',
    'web-user.passwordConfirmation' => 'Confirm password',
    'web-user.hardDiskQuota' => 'Hard disk quota',
    'web-user.hardDiskQuotaUnlimited' => 'Unlimited',
    'web-user.hardDiskQuotaIsNotSupported' => '(hard disk quota is not supported due to configuration of server file system)',
    'web-user.megabytes' => 'MB',

    'requiredFields' => 'Required fields',
];
