<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Доступ запрещен. Ваша учетная запись приостановлена.",
    'login_up__login_has_been_locked' => "Вы слишком много раз ввели неправильный пароль. В целях безопасности вы некоторое время не сможете выполнить вход под этой учетной записью.",
    'login_up__unable_to_check_pass' => "Невозможно проверить пароль: %1",
    'login_up__warning_limits_licence_key' => "По одному из следующих элементов было превышено ограничение, определяемое условиями лицензионного ключа: учетные записи пользователей, домены, почтовые имена или веб-пользователи, размещенные на вашем сервере.\nПожалуйста, обратитесь в отдел продаж Plesk для покупки лицензионного ключа, который позволит вам разместить нужное количество учетных записей пользователей, доменов и т.д. Свяжитесь с отделом технической поддержки Plesk, если вы считаете, что получили это сообщение по ошибке.\nОграничение по условиям лицензии на число учетных записей пользователей/доменов/почтовых имен/веб-пользователей/пакетов локализации: %2.\nВ настоящий момент число размещенных учетных записей пользователей/доменов/почтовых имен/веб-пользователей/локализационных пакетов: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Объем ресурсов, которые вы используете, превысил ограничения, установленные вашей лицензией на продукт. Пожалуйста, обратитесь в службу продаж Plesk для приобретения нового лицензионного ключа.",
    'login_up__grace_period' => 'Ваша лицензия истекла, и для нее начался льготный период. Чтобы обновить лицензию, нажмите Получить ключи на странице %1Информация о лицензии%2.',
    'login_up__partner_license_message' => 'Вы работаете с ограниченной лицензией, которая требует регистрации для активации полного набора функций. Чтобы обновить лицензию, выберите опцию Получить ключи на странице %1Информация о лицензии%2.',
    'login_up__system_admin_disabled' => 'Суперпользователю (пользователю root или администратору) запрещено входить в Plesk в целях безопасности.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Руководство администратора Plesk",
    'plesk_guide_reseller' => "Руководство реселлера Plesk",
    'plesk_guide_client' => "Руководство клиента Plesk",
    'plesk_guide_domain_admin' => "Руководство администратора домена Plesk",
    'plesk_guide_mailuser' => "Руководство пользователя почты Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Поиск', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Клиенты',
    'ui__reseller_unknown__quick-search' => 'Реселлеры',
    'ui__client/domain_unknown__quick-search' => 'Домены',
    'nav__general' => 'Главное меню',
    '__home' => 'Главная',
    '__resellers' => 'Реселлеры',
    '__clients' => 'Клиенты',
    '__domains' => 'Домены',
    '__applications' => 'Приложения',
    '__settings' => 'Настройки',
    'nav__system' => 'Система',
    '__master' => 'Мастер',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Вернуться',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Удалить',
    'bt_make_default' => 'По умолчанию',

    // common list object operation errors
    'class_cList__empty_selection' => 'Объекты не выбраны.',

    // common list object search keys
    'clist__search_show' => 'Показать поиск',
    'clist__search_hide' => 'Скрыть поиск',

    'bt_show_all' => "Очистить",

    // common object list info keys
    'clist__first' => 'Первая',
    'clist__last' => 'Последняя',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Страницы',
    'clist__page_size' => 'Записей на странице',
    'clist__info' => 'Всего %1: %4',
    'clist__info_empty' => 'Нет %1',
    'clist__info_filter' => 'Найдено %1: %5 (всего %4)',
    'clist__info_paging' => 'Показаны %1: %2-%3 из %4',
    'clist__info_paging_filter' => 'Найдены %1: %2-%3 из %5 (всего %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Активен',
    '__object_off' => 'Приостановлен',

    '__home_description' => 'Назад на Домашнюю страницу.',
    'indicator_title' => 'Использовано: %1%, свободно: %2%', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Запрошен неверный URL.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Учетные записи реселлеров",
    'ui__reseller_unknown__title' => "Учетные записи реселлеров",
    'ui__reseller_unknown__description' => "Управлять учетными записями реселлеров.",
    'ui__reseller/client_unknown__short-title' => 'Учетные записи клиентов',
    'ui__reseller/client_unknown__title' => 'Учетные записи клиентов',
    'ui__reseller/client_unknown__description' => 'Управлять учетными записями клиентов.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Дополнительные учетные записи администратора", // PFW
    'ui__admin-alias_unknown__short-title' => "Дополнительные учетные записи администратора", // PFW
    'ui__admin-alias_unknown__description' => "Просмотр и управление дополнительными учетными записями администратора.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Глобальные параметры почты",
    'ui__server/mail__title' => "Глобальные параметры почты",
    'ui__server/mail__description' => "Настроить ваш почтовый сервер и установить глобальные параметры почты.",
    'ui__server/dns__short-title' => 'Настройки DNS',
    'ui__server/dns__title' => 'Настройки DNS',
    'ui__server/dns__description' => 'Просмотр и обновление серверных настроек DNS.',
    'ui__server/services__title' => 'Управление службами',
    'ui__server/services__description' => 'Запустить, остановить или перезапустить службы Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Планировщик задач',
    'ui__server/crontab/task_unknown__title' => 'Планировщик задач',
    'ui__server/crontab/task_unknown__description' => 'Добавить или удалить запланированные задачи на сервере.',
    'ui__server/ip-address_unknown__short-title' => 'IP-адреса',
    'ui__server/ip-address_unknown__title' => 'IP-адреса',
    'ui__server/ip-address_unknown__description' => 'Просмотр, добавление и удаление IP-адресов, назначение IP-адресов реселлерам.',
    // dropdowns
    'ui__server/time__title' => 'Системное время',
    'ui__server/time__short-title' => 'Системное время',
    'ui__server/time__description' => 'Изменить системную дату и время, настроить синхронизацию с сервером NTP.',
    'ui__server/maillists__title' => 'Настроить сервер списков рассылки', // PFU
    'ui__server/maillists__short-title' => 'Настроить сервер списков рассылки', // PFU
    'ui__server/maillists__description' => 'Настроить сервер списков рассылки Mailman.', // PFU
    'ui__mass-email__short-title' => "Сообщения почтовой рассылки", // PFW
    'ui__mass-email__title' => "Сообщения почтовой рассылки", // PFW
    'ui__mass-email__description' => "Отправка электронных сообщений сразу нескольким пользователям.", // PFW
    'ui__mass-mail__title' => 'Сообщения почтовой рассылки', // PFU
    'ui__mass-mail__short-title' => 'Сообщения почтовой рассылки', // PFU
    'ui__mass-mail__description' => 'Отправка электронных сообщений сразу нескольким пользователям.', // PFU
    'ui__server/spam-filter__title' => 'Настройки антиспама',
    'ui__server/spam-filter__short-title' => 'Настройки антиспама',
    'ui__server/spam-filter__description' => 'Настроить глобальный антиспам.',
    'ui__server/preferences__title' => "Настройки сервера",
    'ui__server/preferences__short-title' => "Настройки сервера",
    'ui__server/preferences__description' => "Установить настройки расчета серверной статистики, изменить имя хоста и другие настройки сервера.",

    // help & support
    // icons
    'ui__support__short-title' => 'Поддержка',
    'ui__support__title' => 'Поддержка',
    'ui__support__description' => 'Направить запрос на получение технической поддержки или посмотреть заявки на поддержку, созданные вашими клиентами.',
    'ui__license__short-title' => 'Информация о лицензии',
    'ui__license__title' => 'Информация о лицензии Plesk',
    'ui__license__description' => 'Посмотреть информацию о вашей лицензии Plesk или купить новые лицензии.',
    'ui__help__short-title' => 'Справка',
    'ui__help__title' => 'Онлайн-справка',
    'ui__help__description' => 'Открыть онлайн-справку.',
    'ui__news__short-title' => "Что нового",
    'ui__news__title' => "Что нового",
    'ui__news__description' => "Посмотреть список изменений в этой версии Plesk.",
    'ui__server/autoinstaller__short-title' => 'Обновления',
    'ui__server/autoinstaller__title' => 'Обновления',
    'ui__server/autoinstaller__description' => 'Обновить Plesk и его компоненты.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Домены',
    'ui__client/domain_unknown__title' => 'Домены',
    'ui__client/domain_unknown__description' => 'Управление доменами.',
    'ui__server/skeleton__short-title' => 'Шаблон виртуального сервера',
    'ui__server/skeleton__title' => 'Шаблон виртуального сервера',
    'ui__server/skeleton__description' => 'Укажите файлы и папки, которые следует включать в папки новых доменов.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Назначить нового владельца для подписок',
    'ui__client/domain/chowner_multi-select__short-title' => 'Назначить нового владельца подписки',
    'ui__client/domain/chowner_multi-select__description' => 'Назначить нового владельца для выбранных подписок',
    'ui__client/domain/disable_multi__title' => 'Приостановить домены',
    'ui__client/domain/disable_multi__short-title' => 'Приостановить домены',
    'ui__client/domain/disable_multi__description' => 'Приостановить выбранные домены',
    'ui__client/domain/enable_multi__title' => 'Активировать домены',
    'ui__client/domain/enable_multi__short-title' => 'Активировать домены',
    'ui__client/domain/enable_multi__description' => 'Активировать выбранные домены',

    // icons
    'ui__admin/extras-domain__short-title' => 'Инструменты из MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Инструменты из MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Настройки ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Настройки ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Задать серверные настройки ASP.NET.', // PFW
    'ui__server/sitebuilder__short-title' => 'Настройки Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Настройки Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Настроить Presence Builder для редактирования веб-сайтов, размещенных на этом сервере.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Зарегистрировать домен',
    'ui__admin/register-domain__short-title' => 'Зарегистрировать домен',
    'ui__admin/register-domain__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Управление доменом',
    'ui__admin/manage-domain__short-title' => 'Управление доменом',
    'ui__admin/manage-domain__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',
    'ui__server/register__title' => 'Зарегистрировать ваш сервер',
    'ui__server/register__short-title' => 'Зарегистрировать сервер',
    'ui__server/register__description' => 'Зарегистрируйте ваш сервер в партнерской программе',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Журнал операций',
    'ui__actionlog__title' => 'Журнал операций',
    'ui__actionlog__description' => 'Загрузите журнал операций и управляйте настройками журнала операций.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Сведения о сервере',
    'ui__server/statistics__title' => 'Сведения о сервере',
    'ui__server/statistics__description' => 'Статистика по службам, управляемым Plesk.',
    'ui__admin/report__title' => 'Сводный отчет',
    'ui__admin/report__short-title' => 'Сводный отчет',
    'ui__admin/report__description' => 'Посмотреть отчет по использованию трафика и ресурсов для реселлеров, клиентов и доменов.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Время простоя сеанса',
    'ui__sessions/properties__title' => 'Время простоя сеанса',
    'ui__sessions/properties__description' => 'Установить время простоя для сеансов Plesk.',
    'ui__cp-access__short-title' => 'Доступ к Plesk',
    'ui__cp-access__title' => 'Доступ к Plesk',
    'ui__cp-access__description' => 'Ограничить доступ к Plesk.',
    'ui__sessions__short-title' => 'Активные сеансы',
    'ui__sessions__title' => 'Активные сеансы',
    'ui__sessions__description' => 'Посмотреть список активных сеансов в Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-сертификаты',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-сертификаты',
    'ui__server/certificate_unknown__description' => 'Список SSL/TLS-сертификатов.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Личные данные',
    'ui__admin-info__title' => 'Личные данные',
    'ui__admin-info__description' => 'Изменить личную информацию в вашей учетной записи.',
    'ui__admin-password__short-title' => 'Изменить пароль',
    'ui__admin-password__title' => 'Изменить пароль',
    'ui__admin-password__description' => 'Измените пароль для своей учетной записи.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Защищенные паролем папки',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Защищенные паролем папки',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Защитить доступ к выбранным разделам веб-сайта.',
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Виртуальные папки', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Виртуальные папки', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Управление физическими и виртуальными файлами и папками на сайте.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Использование ресурсов',
    'ui__reseller/limits__title' => 'Использование ресурсов',
    'ui__reseller/limits__description' => 'Управлять использованием ресурсов реселлера %1.',
    'ui__reseller/limits_unknown__short-title' => 'Использование ресурсов',
    'ui__reseller/limits_unknown__title' => 'Использование ресурсов',
    'ui__reseller/limits_unknown__description' => 'Управлять использованием ресурсов реселлера.',
    'ui__reseller/limits_self__short-title' => 'Использование ресурсов',
    'ui__reseller/limits_self__title' => 'Использование ресурсов',
    'ui__reseller/limits_self__description' => "Просмотр и управление использованием ваших ресурсов.",
    'ui__reseller/limits_readonly-self__short-title' => 'Использование ресурсов',
    'ui__reseller/limits_readonly-self__title' => 'Использование ресурсов',
    'ui__reseller/limits_readonly-self__description' => "Просмотреть статистику по использованию ваших ресурсов.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Расход трафика клиентами',
    'ui__reseller/client/traffic_unknown__title' => 'Посмотреть использование трафика по клиентам',
    'ui__reseller/client/traffic_unknown__description' => 'Посмотреть отчеты по использованию трафика для учетных записей клиентов.',
    'ui__client/traffic_unknown__short-title' => "Расход трафика клиентами", // temporary for presets
    'ui__client/traffic_unknown__title' => "Просмотр расхода трафика клиентами", // temporary for presets
    'ui__client/traffic_unknown__description' => "Просмотр расхода трафика клиентами.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Менеджер журналов',
    'ui__client/domain/hosting/logs_unknown__title' => 'Менеджер журналов',
    'ui__client/domain/hosting/logs_unknown__description' => 'Просмотр журналов и настройка ротации журналов.',
    // dropdowns
    'ui__reseller/report__title' => 'Сводный отчет',
    'ui__reseller/report__short-title' => 'Сводный отчет',
    'ui__reseller/report__description' => 'Посмотреть отчет по использованию трафика и ресурсов для этого реселлера.',
    'ui__reseller/report_unknown__title' => 'Сводный отчет',
    'ui__reseller/report_unknown__short-title' => 'Сводный отчет',
    'ui__reseller/report_unknown__description' => 'Посмотреть отчет по использованию трафика и ресурсов для реселлера.',
    'ui__reseller/report_self__title' => 'Сводный отчет',
    'ui__reseller/report_self__short-title' => 'Сводный отчет',
    'ui__reseller/report_self__description' => 'Посмотреть отчет по использованию вами трафика и ресурсов.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Брендинг Plesk',
    'ui__client/logo_reseller__short-title' => 'Брендинг Plesk',
    'ui__client/logo_reseller__description' => 'Изменить фирменный стиль Plesk для реселлера %1.',
    'ui__client/logo_unknown__title' => 'Брендинг Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Брендинг Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Изменить фирменный стиль Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Брендинг Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Брендинг Plesk',
    'ui__client/logo_self-reseller__description' => 'Изменить фирменный стиль вашей панели Plesk.',
    'ui__reseller/permissions__title' => 'Права',
    'ui__reseller/permissions__short-title' => 'Права',
    'ui__reseller/permissions__description' => "Посмотреть или изменить список действий, которые может выполнять в Plesk реселлер %1.",
    'ui__reseller/permissions_unknown__short-title' => 'Права',
    'ui__reseller/permissions_unknown__title' => 'Права',
    'ui__reseller/permissions_unknown__description' => "Посмотреть или изменить список действий, которые может выполнять в Plesk реселлер.",
    'ui__reseller/permissions_self__title' => 'Права',
    'ui__reseller/permissions_self__short-title' => 'Права',
    'ui__reseller/permissions_self__description' => 'Посмотреть список действий, которые вы можете выполнять в Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Права',
    'ui__reseller/permissions_readonly-self__short-title' => 'Права',
    'ui__reseller/permissions_readonly-self__description' => 'Посмотреть список действий, которые вы можете выполнять в Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Шаблон виртуального сервера',
    'ui__client/skeleton__short-title' => 'Шаблон виртуального сервера',
    'ui__client/skeleton__description' => 'Укажите файлы и папки, которые следует включать в папки новых доменов.',
    'ui__client/skeleton_unknown__short-title' => 'Шаблон виртуального сервера',
    'ui__client/skeleton_unknown__title' => 'Шаблон виртуального сервера',
    'ui__client/skeleton_unknown__description' => 'Укажите файлы и папки, которые следует включать в папки новых доменов.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Псевдонимы домена',
    'ui__client/domain/domain-alias_unknown__title' => 'Псевдонимы домена',
    'ui__client/domain/domain-alias_unknown__description' => 'Просмотреть список альтернативных имен для вашего домена.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Настройки DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_unknown__description' => 'Управление настройками зоны DNS для домена.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Просмотреть настройки зоны DNS для домена.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Инструменты из MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Инструменты из MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Инструменты из MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Инструменты из MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Инструменты из MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Инструменты из MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Зарегистрировать домен',
    'ui__reseller/register-domain__title' => 'Зарегистрировать домен',
    'ui__reseller/register-domain__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Зарегистрировать домен',
    'ui__reseller/register-domain_unknown__title' => 'Зарегистрировать домен',
    'ui__reseller/register-domain_unknown__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Зарегистрировать домен',
    'ui__reseller/register-domain_self__title' => 'Зарегистрировать домен',
    'ui__reseller/register-domain_self__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Управление доменом',
    'ui__reseller/manage-domain__short-title' => 'Управление доменом',
    'ui__reseller/manage-domain__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Управление доменом',
    'ui__reseller/manage-domain_unknown__short-title' => 'Управление доменом',
    'ui__reseller/manage-domain_unknown__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Управление доменом',
    'ui__reseller/manage-domain_self__short-title' => 'Управление доменом',
    'ui__reseller/manage-domain_self__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-адреса',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-адреса',
    'ui__client/ipaddress_unknown-reseller__description' => 'Управление IP-адресами.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-сертификаты',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-сертификаты',
    'ui__client/domain/certificate_unknown__description' => 'Установка и управление SSL/TLS-сертификатами.',
    'ui__reseller/sessions__short-title' => 'Активные сеансы',
    'ui__reseller/sessions__title' => 'Активные сеансы',
    'ui__reseller/sessions__description' => 'Посмотреть список активных сеансов в Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Активные сеансы',
    'ui__reseller/sessions_unknown__title' => 'Активные сеансы',
    'ui__reseller/sessions_unknown__description' => 'Посмотреть список активных сеансов в Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Активные сеансы',
    'ui__reseller/sessions_self__title' => 'Активные сеансы',
    'ui__reseller/sessions_self__description' => 'Посмотреть список активных сеансов в Plesk.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Учетные записи почты под учетной записью пользователя %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Шаблон виртуального сервера',
    'ui__client/skeleton_self__title' => 'Шаблон виртуального сервера',
    'ui__client/skeleton_self__description' => 'Укажите файлы и папки, которые следует включать в папки новых доменов.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Использование ресурсов',
    'ui__client/limits__title' => 'Использование ресурсов',
    'ui__client/limits__description' => "Просмотр и управление расходом ресурсов клиентом %1.",
    'ui__client/limits_unknown__short-title' => 'Использование ресурсов',
    'ui__client/limits_unknown__title' => 'Использование ресурсов',
    'ui__client/limits_unknown__description' => 'Просмотр и управление расходом ресурсов клиентом.',
    'ui__client/limits_readonly__short-title' => 'Использование ресурсов',
    'ui__client/limits_readonly__title' => 'Использование ресурсов',
    'ui__client/limits_readonly__description' => 'Просмотр расхода ресурсов клиентом %1.',
    'ui__client/limits_self__short-title' => 'Использование ресурсов',
    'ui__client/limits_self__title' => 'Использование ресурсов',
    'ui__client/limits_self__description' => "Просмотр и управление использованием ваших ресурсов.",
    'ui__client/limits_readonly-self__short-title' => 'Использование ресурсов',
    'ui__client/limits_readonly-self__title' => 'Использование ресурсов',
    'ui__client/limits_readonly-self__description' => "Просмотреть статистику по использованию ваших ресурсов.",
    'ui__client/domain/traffic_unknown__short-title' => "Расход трафика доменами %1",
    'ui__client/domain/traffic_unknown__title' => "Посмотреть использование трафика по доменам",
    'ui__client/domain/traffic_unknown__description' => "Посмотреть отчет по использованию трафика для доменов.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Сводный отчет',
    'ui__client/report__short-title' => 'Сводный отчет',
    'ui__client/report__description' => 'Просмотр отчета о расходе трафика и ресурсов этим клиентом.',
    'ui__client/report_unknown__short-title' => 'Сводный отчет',
    'ui__client/report_unknown__title' => 'Сводный отчет',
    'ui__client/report_unknown__description' => 'Просмотр отчета о расходе трафика и ресурсов клиентом.',
    'ui__client/report_self__short-title' => 'Сводный отчет',
    'ui__client/report_self__title' => 'Сводный отчет',
    'ui__client/report_self__description' => 'Посмотреть отчет по использованию трафика и ресурсов.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Настройки интерфейса',
    'ui__client/preferences__title' => 'Настройки интерфейса',
    'ui__client/preferences__description' => 'Изменить настройки интерфейса Plesk для клиента %1.',
    'ui__client/preferences_unknown__short-title' => 'Настройки интерфейса',
    'ui__client/preferences_unknown__title' => 'Настройки интерфейса',
    'ui__client/preferences_unknown__description' => "Изменить настройки интерфейса Plesk для клиента.",
    'ui__client/preferences_self__short-title' => 'Настройки интерфейса',
    'ui__client/preferences_self__title' => 'Настройки интерфейса',
    'ui__client/preferences_self__description' => 'Изменить настройки вашего интерфейса Plesk.',
    'ui__client/logo__title' => 'Брендинг Plesk',
    'ui__client/logo__short-title' => 'Брендинг Plesk',
    'ui__client/logo__description' => "Изменить фирменный стиль Plesk для клиента %1.",
    'ui__client/logo_self__title' => 'Брендинг Plesk',
    'ui__client/logo_self__short-title' => 'Брендинг Plesk',
    'ui__client/logo_self__description' => 'Обновить фирменный стиль Plesk, изменив логотип и текст в заголовке браузера.',
    'ui__client/permissions__title' => 'Права',
    'ui__client/permissions__short-title' => 'Права',
    'ui__client/permissions__description' => "Посмотреть или изменить список действий, которые может выполнять в Plesk клиент %1.",
    'ui__client/permissions_unknown__short-title' => 'Права',
    'ui__client/permissions_unknown__title' => 'Права',
    'ui__client/permissions_unknown__description' => "Посмотреть или изменить список действий, которые может выполнять в Plesk этот клиент.",
    'ui__client/permissions_self__title' => 'Права',
    'ui__client/permissions_self__short-title' => 'Права',
    'ui__client/permissions_self__description' => "Посмотреть список действий, которые вы можете выполнять в Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Права',
    'ui__client/permissions_readonly-self__short-title' => 'Права',
    'ui__client/permissions_readonly-self__description' => "Посмотреть список действий, которые вы можете выполнять в Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Инструменты из MyPlesk.com',
    'ui__client/extras-domain__title' => 'Инструменты из MyPlesk.com',
    'ui__client/extras-domain__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Инструменты из MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Инструменты из MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Инструменты из MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Инструменты из MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Зарегистрировать домен',
    'ui__client/register-domain__short-title' => 'Зарегистрировать домен',
    'ui__client/register-domain__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Зарегистрировать домен',
    'ui__client/register-domain_unknown__short-title' => 'Зарегистрировать домен',
    'ui__client/register-domain_unknown__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Зарегистрировать домен',
    'ui__client/register-domain_self__short-title' => 'Зарегистрировать домен',
    'ui__client/register-domain_self__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Управление доменом',
    'ui__client/manage-domain__short-title' => 'Управление доменом',
    'ui__client/manage-domain__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Управление доменом',
    'ui__client/manage-domain_unknown__short-title' => 'Управление доменом',
    'ui__client/manage-domain_unknown__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Управление доменом',
    'ui__client/manage-domain_self__short-title' => 'Управление доменом',
    'ui__client/manage-domain_self__description' => 'Управляйте зарегистрированными доменными именами через MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-адреса',
    'ui__client/ipaddress_unknown__short-title' => "IP-адреса",
    'ui__client/ipaddress_unknown__description' => "Управление IP-адресами.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Псевдонимы домена',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Псевдонимы домена',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Просмотреть список альтернативных имен для вашего домена.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Активные сеансы',
    'ui__client/sessions__title' => 'Активные сеансы',
    'ui__client/sessions__description' => 'Посмотреть список активных сеансов в Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Активные сеансы',
    'ui__client/sessions_unknown__title' => 'Активные сеансы',
    'ui__client/sessions_unknown__description' => 'Посмотреть список активных сеансов в Plesk.',
    'ui__client/sessions_self__short-title' => 'Активные сеансы',
    'ui__client/sessions_self__title' => 'Активные сеансы',
    'ui__client/sessions_self__description' => 'Посмотреть список активных сеансов в Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/protected-directories__short-title' => 'Защищенные паролем папки',
    'ui__client/domain/hosting/protected-directories__title' => 'Защищенные паролем папки',
    'ui__client/domain/hosting/protected-directories__description' => 'Защитить доступ к выбранным разделам веб-сайта.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Защищенные паролем папки',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Защищенные паролем папки',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Защита доступа к определенным разделам веб-сайта.',
    'ui__client/domain/hosting/web-directories__title' => 'Виртуальные папки', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Виртуальные папки', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Управление физическими и виртуальными файлами и папками на сайте %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Виртуальные папки', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Виртуальные папки', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Управление физическими и виртуальными файлами и папками на вашем сайте.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => 'Использование трафика %1',
    'ui__client/domain/traffic__title' => 'Статистика передачи данных для <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Просмотр статистики передачи данных для домена %1.',
    'ui__client/domain/traffic_self__short-title' => 'Использование трафика',
    'ui__client/domain/traffic_self__title' => 'Посмотреть использование трафика для вашего домена',
    'ui__client/domain/traffic_self__description' => 'Посмотреть отчет по использованию трафика для вашего домена.',
    'ui__client/domain/hosting/logs__short-title' => 'Менеджер журналов',
    'ui__client/domain/hosting/logs__title' => 'Менеджер журналов',
    'ui__client/domain/hosting/logs__description' => 'Просмотр журналов и настройка ротации журналов.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Менеджер журналов',
    'ui__client/domain/hosting/logs_self__title' => 'Менеджер журналов',
    'ui__client/domain/hosting/logs_self__description' => 'Просмотр журналов и настройка ротации журналов.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Переименовать домен',
    'ui__client/domain/rename__short-title' => 'Переименовать домен',
    'ui__client/domain/rename__description' => 'Переименовать домен %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Переименовать домен',
    'ui__client/domain/rename_unknown__title' => 'Переименовать домен',
    'ui__client/domain/rename_unknown__description' => 'Переименовать домен',
    'ui__client/domain/chowner_select__title' => 'Назначить нового владельца для домена',
    'ui__client/domain/chowner_select__short-title' => 'Назначить нового владельца для подписки',
    'ui__client/domain/chowner_select__description' => 'Назначить нового владельца для подписки',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Назначить нового владельца для подписки',
    'ui__client/domain/chowner_unknown-select__title' => 'Назначить нового владельца для подписки',
    'ui__client/domain/chowner_unknown-select__description' => 'Назначить нового владельца для подписки.',
    'ui__client/domain/toggle__title' => 'Приостановить или активировать домен', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Приостановить или активировать домен', // for HP customization
    'ui__client/domain/toggle__description' => 'Приостановить или активировать домен %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Приостановить или активировать домен', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Приостановить или активировать домен', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Приостановить или активировать домен.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Активировать домен',
    'ui__client/domain/toggle_enable__short-title' => 'Активировать домен',
    'ui__client/domain/toggle_enable__description' => 'Активировать домен %1.',
    'ui__client/domain/toggle_disable__title' => 'Приостановить домен',
    'ui__client/domain/toggle_disable__short-title' => 'Приостановить домен',
    'ui__client/domain/toggle_disable__description' => 'Приостановить домен %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Настройки DNS',
    'ui__client/domain/dns__short-title' => 'Настройки DNS',
    'ui__client/domain/dns__description' => 'Управление настройками зоны DNS для домена %1.',
    'ui__client/domain/dns_self__title' => 'Настройки DNS',
    'ui__client/domain/dns_self__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_self__description' => 'Управление настройками зоны DNS для вашего домена.',
    'ui__client/domain/dns_disabled__title' => 'Настройки DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_disabled__description' => 'Управление настройками зоны DNS для домена %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Настройки DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Управление настройками зоны DNS для вашего домена.',
    'ui__client/domain/dns_readonly__title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly__description' => 'Просмотреть настройки зоны DNS для домена %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Просмотреть настройки зоны DNS для вашего домена.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Просмотреть настройки зоны DNS для вашего домена.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Просмотреть настройки зоны DNS для вашего домена.',
    'ui__client/domain/dns_slave__title' => 'Настройки DNS',
    'ui__client/domain/dns_slave__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_slave__description' => 'Управление настройками зоны DNS для домена %1.',
    'ui__client/domain/dns_self-slave__title' => 'Настройки DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Настройки DNS',
    'ui__client/domain/dns_self-slave__description' => 'Управление настройками зоны DNS для вашего домена.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Инструменты из MyPlesk.com',
    'ui__client/domain/extras__title' => 'Инструменты из MyPlesk.com',
    'ui__client/domain/extras__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Инструменты из MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Инструменты из MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Инструменты из MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Инструменты из MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Получить дополнительные инструменты и услуги на MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Зарегистрировать домен',
    'ui__client/domain/register__title' => 'Зарегистрировать домен',
    'ui__client/domain/register__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Зарегистрировать домен',
    'ui__client/domain/register_unknown__title' => 'Зарегистрировать домен',
    'ui__client/domain/register_unknown__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Зарегистрировать домен',
    'ui__client/domain/register_self__title' => 'Зарегистрировать домен',
    'ui__client/domain/register_self__description' => 'Зарегистрировать доменное имя через MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Инструменты",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Просмотр статистики',
    'ui__client/domain-summary-report_unknown__title' => 'Просмотр статистики',
    'ui__client/domain-summary-report_unknown__description' => 'Посмотреть информацию по использованию ресурсов доменами.',
    'ui__client/domain-summary-report__short-title' => "Просмотр статистики",
    'ui__client/domain-summary-report__title' => "Просмотр статистики",
    'ui__client/domain-summary-report__description' => "Посмотреть информацию по использованию ресурсов доменами.",
    'ui__client/domain-summary-report_self__short-title' => "Просмотр статистики",
    'ui__client/domain-summary-report_self__title' => "Просмотр статистики",
    'ui__client/domain-summary-report_self__description' => "Посмотреть информацию по использованию ресурсов вашими доменами.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Домены", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Вы должны выбрать домены, которые хотите удалить',
    'ui__client/domain/chowner__empty_selection' => 'Вы должны выбрать домены, для которых хотите назначить нового владельца',

    // list objects filtering
    'domains_list__name__filter_title' => 'Имя',
    'domains_list__state__filter_title' => 'Использование ресурсов',
    'domains_list__filter_state_any' => 'Все',
    'domains_list__filter_state_overuse' => 'Перерасход',
    'domains_list__filter_state_normal' => 'В рамках ограничений',
    'domains_list__status__filter_title' => 'Статус',
    'domains_list__filter_status_any' => 'Все',
    'domains_list__filter_status_blocked' => 'Приостановлен',
    'domains_list__filter_status_active' => 'Активен',
    'domains_list__ownership__filter_title' => 'Принадлежность',
    'domains_list__filter_ownership_all' => 'Все домены',
    'domains_list__filter_ownership_personal' => 'Только мои домены',
    'domains_list__filter_owner_pname__filter_title' => 'Имя владельца',
    'domains_list__subrows__filter_title' => 'Показать',
    'domains_list__subrows_off' => 'Только домены',
    'domains_list__subrows_subdomain_domainaliases' => 'С субдоменами и псевдонимами',
    'domains_list__subrows_subdomain' => 'С субдоменами',
    'domains_list__subrows_domainaliases' => 'С псевдонимами',

    // objects list
    'domains_list__owner__title' => 'Владелец',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Выбор приложений",
    'site_apps__promo_main_text' => "Каталог APS содержит список приложений, которые могут быть поставлены для домена или веб-сайта. Если вы хотели бы поставлять приложения, которых пока нет в каталоге, вы можете это сделать, следуя инструкциям по формированию пакетов APS, которые доступны на www.apsstandard.com",
    'site_apps__promo_download_now' => "Загрузить приложения:",
    'site_apps__promo_close' => "Закрыть этот блок",
    'site_apps__promo_preset__mostused' => '%1 самых популярных',
    'site_apps__promo_preset__lessused' => 'Следующие %1 самых популярных',
    'site_apps__promo_preset__all' => "Все",
    'site_apps__promo_disclaimer_note' => 'Помните, что приложения, устанавливаемые из каталога APS, предоставляются третьими лицами и не поддерживаются компанией Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Приложения APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Добавление приложений...',

    // Errors
    'site_apps__no_applications_for_update' => 'В вашем хранилище приложений нет установленных приложений.',
    'site_apps__incorrect_download_preset_configuration' => 'В конфигурации шаблона загрузки для каталога APS были обнаружены ошибки.',
    'site_apps__aps_catalog_url_is_invalid' => 'Указан недопустимый URL.',
    'site_apps__no_updates_at_the_moment' => 'В настоящий момент нет доступных обновлений приложений.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Из каталога приложений APS была получена неверная информация. Пожалуйста, повторите попытку позднее.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Настройки APS-каталога были сохранены, но Plesk не удалось подключиться указанному каталогу (%1). Убедитесь, что вы указали правильный адрес APS-каталога и этот каталог активен.',
    'site_apps__cannot_retrieve_updates' => 'В настоящий момент загрузка обновлений для приложений невозможна: не удалось установить соединение с каталогом APS (%1). Убедитесь, что указан правильный адрес каталога APS, и расположенный по этому адресу каталог APS является активным.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Нет доступных для установки веб-приложений.',
    'site_apps__site_applications_already_installed_in_root' => 'В корневых папках этих виртуальных серверов уже установлены другие веб-приложения',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Платформа Unix/Linux не поддерживает веб-приложения .NET.",
    'site_apps__server_wide_packages_not_supported' => 'Серверные веб-приложения не поддерживаются',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "Количество веб-приложений, запланированных для добавления в хранилище приложений: %1.",
    'site_apps__applications_all_in_vault' => "Выбранные веб-приложения уже имеются в хранилище приложений.",
    'site_apps__applications_already_in_download_queue' => "Количество выбранных веб-приложений, добавляемых в текущий момент в хранилище приложений: %1.",
    'site_apps__applications_already_in_valut' => "Количество выбранных веб-приложений, которые уже имеются в хранилище приложений: %1.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Другое (без категории)',

    // Errors
    'site_apps__no_applications_in_category' => 'В этой категории нет доступных приложений. Пожалуйста, выберите другую категорию.',
    'site_apps__no_category_selected__please_specify' => 'Выберите категорию в левом меню. В этом окне будет показан список всех доступных приложений из выбранной категории.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Учетная запись администратора',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Общие',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Изменить имя хоста',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Безопасность',
    'bt_setup_firewall' => 'Настроить брэндмауэр',
    'bt_manage_firewall_rules' => 'Управление правилами брэндмауэра',
    'cu_firewall__rule' => 'Создать правило брандмауэра',
    'cu_firewall__protocol' => 'Укажите протокол для правила (\'tcp\' или \'udp\')',
    'cu_firewall__name' => "Укажите имя правила",
    'cu_firewall__disabled' => 'Значение \'true\' означает, что созданное правило будет отключено',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Выбрать DNS-сервер', // PFW
    'bt_soa_records_template' => 'Шаблон записей SOA',
    'bt_restrict_creation_of_subzones' => 'Ограничить создание подзон',

    'databases' => 'Базы данных',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Приложения',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Почта',
    'bt_select_mailserver' => 'Выбрать почтовый сервер', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Выбрать антивирус', // PFW
    'bt_virus_protection_settings' => 'Настройки защиты от вирусов',
    'bt_select_spamfilter' => 'Выбрать антиспам', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Выбрать Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Журналы и статистика',
    'bt_server_statistics_settings' => 'Настройки статистики по серверу',
    'bt_select_web_statistics' => 'Доступные программы веб-статистики', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Интерфейс Plesk',

    'components_and_modules' => 'Компоненты и модули',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Настроить Watchdog', // PFU
    'bt_setup_vpn' => 'Настроить VPN', // PFU
    'bt_setup_samba' => 'Настроить samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Настройки',
    'ui__client/domain/settings_self__short-title' => 'Настройки',
    'ui__client/domain/settings_self__description' => 'Просмотреть и изменить настройки домена.',

    'domain_administrator_account' => 'Учетная запись администратора домена',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Настройки учетной записи',

    'domain' => 'Домен',
    'bt_dns_soa_records' => 'Записи DNS SOA',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Настройки планировщика задач',

    'website' => 'Сайт',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Скрипты для веб-пользователей',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Выбрать SSL/TLS-сертификат',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Веб-статистика',
    'bt_log_rotation_settings' => 'Настройки ротации журналов',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Ограничения", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Перерасход и продажа сверх запасов",
    'limits__overuse_policy_legend' => "Перерасход",
    'limits__oversell_policy_legend' => "Продажа сверх запасов",
    'limits__reseller_overuse_description' => "Политика перерасхода определяет, что делать в случае перерасхода ресурсов.",
    'limits__overuse_text' => "Перерасход",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Дисковое пространство и трафик',
    'limit__disk_space' => 'Диск',
    'limit__max_traffic' => 'Трафик',
    'limit_group__client' => 'Клиенты',
    'limit__max_cl' => 'Клиенты',
    'limit_group__domain' => 'Домены',
    'limit__max_dom' => 'Домены',
    'limit__max_dom_powerUser' => 'Подписки',
    'limit__max_subdom' => 'Субдомены',
    'limit__max_dom_aliases' => 'Псевдонимы домена',
    'limit__max_wu' => 'Веб-пользователи',
    'limit__max_subftp_users' => 'Дополнительные учетные записи FTP', // PFW
    'limit_group__mail' => 'Почта',
    'limit__max_box' => 'Почтовые ящики',
    'limit__mbox_quota' => 'Размер почтового ящика',
    'limit__total_mboxes_quota' => 'Общая квота почтовых ящиков', // PFW
    'limit__max_maillists' => 'Списки рассылки',
    'limit_group__database' => 'Базы данных',
    'limit__max_mssql_db' => 'Базы данных Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Квота на базы данных MS SQL', // PFW
    'limit__max_odbc' => 'Соединения ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Квота на базы данных MySQL', // PFW?
    'limit_group__application' => 'Приложения',
    'limit__max_iis_app_pools' => 'Пулы приложений IIS', // PFW
    'limit_group__security' => 'Безопасность',
    'limit_group__validity' => 'Срок действия',
    'limit__expiration' => 'Срок действия',
    'limit__validity' => 'Срок действия',
    'limit__max_site_builder' => 'Сайты, опубликованные с помощью Presence Builder',
    'limit__max_site' => 'Домены',
    'limit__mssql_dbase_filesize' => 'Размер файла базы данных MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Размер файла журнала базы данных MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Максимальный размер файла базы данных Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Максимальный размер файла журнала базы данных Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "Mб",
    'limit__units_mssql_dbase_log_filesize' => "Mб",

    'dom_pref__invalid_max_site_limit' => 'Неверное ограничение на домены. Минимальное значение — 1.',

    'property__has_wrong_value' => 'Неверное значение свойства %1.',
    'property__name_outgoing_messages_domain_limit' => 'Устанавливает ограничение на исходящие сообщения от домена (в час). Чтобы установить неограниченное значение, введите "-1". Чтобы установить значение из настроек сервера, введите "default".',
    'property__name_outgoing_messages_mbox_limit' => 'Устанавливает ограничение на исходящие сообщения от почтового ящика (в час). Чтобы установить неограниченное значение, введите "-1". Чтобы установить значение из настроек сервера, введите "default".',
    'property__name_outgoing_messages_subscription_limit' => 'Устанавливает ограничение на исходящие сообщения от подписки (в час). Чтобы установить неограниченное значение, введите "-1". Чтобы установить значение из настроек сервера, введите "default".',

    // for CLI report & email notifications
    '__resource_notify' => 'Уведомлять',
    '__general' => 'Общие',
    '__template_shared' => 'Общий шаблон',
    'limit__overuse' => 'Перерасход',
    'limit__max_traffic_soft' => 'Сообщить о достижении ограничения на трафик',
    'limit__disk_space_soft' => 'Уведомлять, когда расход дискового пространства приблизится к',
    '__overuse' => 'Перерасход',
    'performance__title' => 'Производительность',
    'performance__bandwidth' => 'Максимальный объем трафика (Кб/с)',
    'performance__max_connections' => 'Количество соединений',

    'gch__hosting_php_isapi' => 'Запускать PHP как ISAPI-расширение',
    'gch__hosting_ssi_html' => 'Использовать SSI для файлов с расширениями *.htm, *.html',
    'gch__hosting_php_handler_type' => 'запускать PHP как',
    'gch__hosting_php_handler_id' => 'запускать PHP как',
    'gch__hosting_php_served_by_nginx' => 'PHP обслуживается nginx',
    'gch__hosting_unpaid_website_status' => 'Статус сайтов в приостановленных подписках',
    'gch__mn_no_autoresponder' => 'Для этой учетной записи почты не настроено ни одного автоответчика.',
    'gch__no_clients_selected' => "Не выбрано ни одной учетной записи клиента",
    'gch__no_domains_selected' => "Выберите домены.",

    // limit units
    'limit__units_disk_space' => "Mб",
    'limit__units_max_traffic' => "Mб/месяц",
    'limit__units_mbox_quota' => "Кб",
    'limit__units_mysql_dbase_space' => "Mб", // PFW
    'limit__units_mssql_dbase_space' => "Mб", // PFW
    'limit__units_total_mboxes_quota' => "Mб", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Имя ресурса',
    '__resource_usage' => 'Используется',
    '__resource_limit' => 'Ограничение',

    '__used' => 'Используется',
    '__limit' => 'Ограничение',

    '__never_expires' => 'Бессрочный',
    '__resource_free' => 'Свободно %1 из %2',
    '__resource_unlimited' => 'Используется %1 из неограниченного числа',

    '__unlimited' => 'Без ограничений',
    '__increment' => "Увеличить (+)",
    '__decrement' => "Уменьшить (-)",
    '__pt' => 'единиц',
    '__procent' => '%',
    '__overused' => 'Перерасходуется',
    '__left' => 'левый',
    '__available' => 'доступно',
    '__not_available' => 'Не включено',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Посмотреть статистику по трафику',
    'ui__admin/report/traffic-history__title' => 'Посмотреть статистику по трафику',
    'ui__admin/report/traffic-history__description' => 'Посмотреть статистику по трафику для реселлеров, клиентов и доменов.',
    'admin_traffic_history__title' => 'Статистика по трафику',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Расписание доставки',
    'ui__admin/report/layout/auto_unknown__title' => 'Расписание доставки отчета',
    'ui__admin/report/layout/auto_unknown__description' => 'Выбрать расписание доставки отчета для шаблона отчета.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Добавить расписание доставки отчета',
    'ui__admin/report/layout/auto/properties_new__title' => 'Добавить расписание доставки отчета',
    'ui__admin/report/layout/auto/properties_new__description' => 'Добавить расписание доставки для отчета %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Расписание доставки отчета',
    'ui__admin/report/layout/auto/properties__title' => 'Расписание доставки отчета',
    'ui__admin/report/layout/auto/properties__description' => 'Просмотреть и изменить свойства расписания доставки отчетов.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Удалить расписание доставки отчета',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Удалить расписание доставки отчета',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Удалить выбранные расписания доставки отчетов.',

    'ui__admin/report/layout_unknown__short-title' => 'Шаблоны отчетов',
    'ui__admin/report/layout_unknown__title' => 'Шаблоны отчетов',
    'ui__admin/report/layout_unknown__description' => 'Просмотр и управление шаблонами отчетов.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Создать шаблон отчета',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Создать шаблон отчета',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Создать шаблон отчета',
    'ui__admin/report/layout/delete_multi__short-title' => 'Удалить шаблоны отчетов',
    'ui__admin/report/layout/delete_multi__title' => 'Удалить шаблоны отчетов',
    'ui__admin/report/layout/delete_multi__description' => 'Удалить выбранные шаблоны отчетов',
    'ui__admin/report/layout/properties__short-title' => 'Свойства',
    'ui__admin/report/layout/properties__title' => 'Свойства шаблона отчета',
    'ui__admin/report/layout/properties__description' => 'Редактировать свойства шаблона отчета.',

    // reseller
    'reseller_traffic_history__title' => "Статистика по трафику реселлера %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Просмотр расхода трафика для <b>%1</b>',
    'ui__reseller/traffic__description' => 'Посмотреть отчеты по использованию трафика для реселлера %1.',
    'ui__reseller/traffic_self__short-title' => 'Я',
    'ui__reseller/traffic_self__title' => 'Посмотреть использование трафика по клиентам',
    'ui__reseller/traffic_self__description' => 'Посмотреть отчеты по использованию трафика для ваших учетных записей клиентов.',

    'ui__reseller/report/traffic-history__short-title' => 'Посмотреть статистику по трафику',
    'ui__reseller/report/traffic-history__title' => 'Посмотреть статистику по трафику',
    'ui__reseller/report/traffic-history__description' => "Посмотреть статистику по трафику для реселлера %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Посмотреть статистику по трафику',
    'ui__reseller/report/traffic-history_self__title' => 'Посмотреть статистику по трафику',
    'ui__reseller/report/traffic-history_self__description' => 'Просмотреть вашу статистику по трафику.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'П',
    'report__full_s' => 'С',
    'report__full_h' => 'Х',
    'report__full_reseller_name' => 'Имя реселлера', // reseller report
    'report__full_client_name' => 'Имя клиента', // customer report
    'report__full_domain_name' => 'Имя домена', // domain report
    'report__full_owner' => 'Владелец', // customer & domain reports
    'report__full_creation_date' => 'Дата создания',
    'report__full_size' => 'Размер',
    'report__full_traffic' => 'Трафик',
    'report__full_active_clients' => 'Активные клиенты', // reseller report
    'report__full_clients' => 'Клиенты', // reseller report
    'report__full_active_domains' => 'Активные домены', // reseller & customer reports
    'report__full_domains' => 'Домены', // reseller & customer reports
    'report__full_subdomains' => 'Субдомены',
    'report__full_mboxes' => 'Mboxes',
    'report__full_disk_space' => 'Диск',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Общие',
    'report__version' => 'Версия продукта',
    'report__build' => 'Сборка продукта',
    'report__status' => 'Статус',
    'report__company_name' => 'Название компании',
    'report__personal_name' => 'Личное имя',
    'report__login' => 'Имя пользователя',
    'report__phone' => 'Телефон',
    'report__fax' => 'Факс',
    'report__email' => 'Электронная почта',
    'report__address' => 'Адрес',
    'report__city' => 'Город',
    'report__state' => 'Область/регион',
    'report__zip_code' => 'Почтовый индекс',
    'report__country' => 'Страна',
    'report__creation_date' => 'Дата создания',
    'report__expiration_date' => 'Срок действия',
    'report__dumps_total_size' => 'Общий размер файлов резервных копий',
    'report__section_resellers' => 'Реселлеры',
    'report__active_resellers' => 'Реселлеры с активными подписками',
    'report__resellers' => 'Реселлеры',
    'report__section_full_resellers' => 'Реселлеры',
    'report__section_clients' => 'Клиенты',
    'report__active_clients' => 'Клиенты с активными подписками',
    'report__clients' => 'Клиенты',
    'report__section_full_clients' => 'Клиенты',
    'report__section_personal_clients' => 'Собственные клиенты',
    'report__active_personal_clients' => 'Ваши клиенты с активными подписками',
    'report__personal_clients' => 'Собственные клиенты',
    'report__section_full_personal_clients' => 'Собственные клиенты',
    'report__section_domains' => 'Домены',
    'report__disk_usage' => 'Использование диска',
    'report__traffic' => 'Трафик',
    'report__active_domains' => 'Активные домены',
    'report__domains' => 'Домены',
    'report__subdomains' => 'Субдомены',
    'report__mboxes' => 'Почтовые ящики',
    'report__mail_groups' => 'Перенаправления почты',
    'report__mail_autoresp' => 'Автоответчики',
    'report__mail_lists' => 'Списки рассылки',
    'report__web_users' => 'Веб-пользователи',
    'report__mysql_databases' => 'Базы данных MySQL',
    'report__mssql_databases' => 'Базы данных MSSQL',
    'report__section_full_domains' => 'Домены',
    'report__section_personal_domains' => 'Личные домены',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Личные домены',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Сайты, опубликованные с помощью Presence Builder',
    'report__invalid_email' => 'Пожалуйста, укажите действительный адрес электронной почты.',


    // CLI-specific sections
    'report__section_hosting' => 'Хостинг',
    'report__section_webusers' => 'Веб-пользователи',
    'report__section_mailnames' => 'Учетные записи почты',
    'report__section_maillists' => 'Списки рассылки',
    'report__section_databases' => 'Базы данных',
    'report__section_siteapps' => 'Веб-приложения',
    'report__section_aspnetapps' => 'Приложения ASP.NET', // PFW
    'report__owner_pname' => "Имя провайдера",
    'report__owner_login' => "Имя пользователя провайдера",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Расписание доставки',
    'ui__reseller/report/layout/auto_unknown__title' => 'Расписание доставки отчета',
    'ui__reseller/report/layout/auto_unknown__description' => 'Выбрать расписание доставки отчета для шаблона отчета.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Добавить расписание доставки отчета',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Добавить расписание доставки отчета',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Добавить расписание доставки для отчета %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Расписание доставки отчетов',
    'ui__reseller/report/layout/auto/properties__title' => 'Расписание доставки отчетов',
    'ui__reseller/report/layout/auto/properties__description' => 'Просмотреть и изменить свойства расписания доставки отчетов.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Удалить расписание доставки отчета',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Удалить расписание доставки отчета',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Удалить выбранные расписания доставки отчетов.',

    'ui__reseller/report/layout_unknown__short-title' => 'Шаблоны отчетов',
    'ui__reseller/report/layout_unknown__title' => 'Шаблоны отчетов',
    'ui__reseller/report/layout_unknown__description' => 'Просмотр и управление шаблонами отчетов.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Создать шаблон отчета',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Создать шаблон отчета',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Создать шаблон отчета',
    'ui__reseller/report/layout/properties_new__short-title' => 'Создать шаблон отчета',
    'ui__reseller/report/layout/properties_new__title' => 'Создать шаблон отчета',
    'ui__reseller/report/layout/properties_new__description' => 'Создать шаблон отчета',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Удалить шаблоны отчетов',
    'ui__reseller/report/layout/delete_multi__title' => 'Удалить шаблоны отчетов',
    'ui__reseller/report/layout/delete_multi__description' => 'Удалить выбранные шаблоны отчетов',
    'ui__reseller/report/layout/properties__short-title' => 'Свойства',
    'ui__reseller/report/layout/properties__title' => 'Свойства шаблона отчета',
    'ui__reseller/report/layout/properties__description' => 'Редактировать свойства шаблона отчета.',

    // customer
    'cl_traffic_history__title' => "Статистика трафика клиента %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Просмотр расхода трафика для <b>%1</b>',
    'ui__client/traffic__description' => 'Просмотр отчетов о расходе трафика клиентом %1.',
    'ui__client/traffic_self__short-title' => 'Использование трафика',
    'ui__client/traffic_self__title' => 'Расход трафика доменами',
    'ui__client/traffic_self__description' => 'Посмотреть отчет по использованию трафика для ваших доменов.',

    'ui__client/report/traffic-history__short-title' => 'Посмотреть статистику по трафику',
    'ui__client/report/traffic-history__title' => 'Посмотреть статистику по трафику',
    'ui__client/report/traffic-history__description' => 'Просмотр истории трафика по клиенту %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Посмотреть статистику по трафику',
    'ui__client/report/traffic-history_self__title' => 'Посмотреть статистику по трафику',
    'ui__client/report/traffic-history_self__description' => 'Просмотреть вашу статистику по трафику.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Указанный пакет локализации установлен, но не включен.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Удалить сеансы',
    'ui__sessions/delete__title' => 'Удалить сеансы',
    'ui__sessions/delete__description' => 'Удалить выбранные сеансы.',
    'ui__ftp-sessions__short-title' => 'Сеансы FTP',
    'ui__ftp-sessions__title' => 'Сеансы FTP',
    'ui__ftp-sessions__description' => 'Просмотреть сеансы FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Удалить сеансы FTP',
    'ui__ftp-sessions/delete__title' => 'Удалить сеансы FTP',
    'ui__ftp-sessions/delete__description' => 'Удалить выбранные сеансы FTP.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Удалить сеансы',
    'ui__reseller/sessions/delete__title' => 'Удалить сеансы',
    'ui__reseller/sessions/delete__description' => 'Удалить выбранные сеансы.',
    'ui__reseller/sessions/delete_self__short-title' => 'Удалить сеансы',
    'ui__reseller/sessions/delete_self__title' => 'Удалить сеансы',
    'ui__reseller/sessions/delete_self__description' => 'Удалить выбранные сеансы.',
    'ui__reseller/ftp-sessions__short-title' => 'Сеансы FTP',
    'ui__reseller/ftp-sessions__title' => 'Сеансы FTP',
    'ui__reseller/ftp-sessions__description' => 'Просмотреть сеансы FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Сеансы FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Сеансы FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Просмотреть сеансы FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Удалить сеансы FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Удалить сеансы FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Удалить выбранные сеансы FTP.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Удалить сеансы FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Удалить сеансы FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Удалить выбранные сеансы FTP.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Удалить сеансы',
    'ui__client/sessions/delete__title' => 'Удалить сеансы',
    'ui__client/sessions/delete__description' => 'Удалить выбранные сеансы.',
    'ui__client/sessions/delete_self__short-title' => 'Удалить сеансы',
    'ui__client/sessions/delete_self__title' => 'Удалить сеансы',
    'ui__client/sessions/delete_self__description' => 'Удалить выбранные сеансы.',

    // domain administrator

    'forgery_token_expired' => 'Срок действия уникального идентификатора сеанса истек.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Следующие реселлеры будут преобразованы в клиентов',
    'downgradeResellers__downgrade' => 'Реселлеры, которые будут преобразованы',
    // controls
    'downgradeResellers__submit_downgrade' => 'Выполнить преобразование учетной записи.',
    'downgradeResellers__cancel_downgrade' => 'Отменить преобразование учетной записи.',
    'downgradeResellers__confirm' => 'Подтвердить преобразование',
    'downgradeResellers__confirm_message' => 'Подтвердить выполнение преобразования учетной записи',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Выбрать учетные записи клиентов',
    'upgradeClients__upgrade_clients' => 'Следующие клиенты будут преобразованы в реселлеров',
    'upgradeClients__upgrade' => 'Учетные записи клиентов, которые будут преобразованы',
    // controls
    'upgradeClients__submit_upgrade' => 'Выполнить преобразование учетной записи.',
    'upgradeClients__cancel_upgrade' => 'Отменить преобразование учетной записи.',
    'upgradeClients__confirm' => 'Подтвердить преобразование',
    'upgradeClients__confirm_message' => 'Подтвердить выполнение преобразования учетной записи',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Пользователь \'%1\' не может быть преобразован в реселлера: \'%1\' уже является реселлером.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Следующие учетные записи администраторов доменов будут преобразованы в учетные записи клиентов',
    'upgradeDomainUser__upgrade' => 'Учетные записи администраторов доменов, которые будут преобразованы',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Выполнить преобразование учетной записи.',
    'upgradeDomainUser__cancel_upgrade' => 'Отменить преобразование учетной записи.',
    'upgradeDomainUser__confirm' => 'Подтвердить преобразование',
    'upgradeDomainUser__confirm_message' => 'Подтвердить выполнение преобразования учетной записи',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Невозможно преобразовать учетные записи администраторов доменов',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Невозможно преобразовать в учетные записи клиентов следующие учетные записи администраторов доменов:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Некоторые учетные записи администраторов доменов не удалось преобразовать в учетные записи клиентов. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Учетная запись администратора домена не существует',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Домен должен принадлежать непосредственно администратору сервера или реселлеру.",
    'upgradeDomainUser__all_logins_already_used' => 'Невозможно создать учетную запись для клиента.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Учетная запись администратора домена была преобразована',
    'upgradeDomainUser__upgrade_notification_body' => 'Ваша учетная запись администратора домена была преобразована в учетную запись клиента с именем пользователя \'%%login%%\' и паролем \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Выбор учетных записей клиентов',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'У выбранного реселлера нет права \'%1\', но оно есть у некоторых клиентов.',
    'clientOwnerChanger__application_not_allowed' => 'Приложение \'%1\' недоступно выбранному реселлеру, но доступно некоторым клиентам.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Назначить нового владельца для выбранных подписок',
    // errors
    'domain_chown__empty_selection' => 'Вы должны указать нового владельца для выбранных доменов',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Максимальный объем трафика (%1)',
    'hosting_performance__max_connection_label' => 'Количество соединений',
    'performance__invalid_value' => "Неверное значение. Должно укладываться в диапазон %1 — %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Веб-почта',
    'webmail__server_text' => 'Доступные клиенты Webmail',
    'webmail__none' => 'Нет',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Серверный пул IP',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'База данных не будет восстановлена: отсутствует необходимый сервер баз данных',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Резервная копия сервера.",
    '__default_backup_comment_reseller' => "Резервная копия реселлера, созданная %1.",
    '__default_backup_comment_client' => "Резервная копия клиента, созданная %1.",
    '__default_backup_comment_domain' => "Резервная копия подписки, созданная %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Определить сопоставление IP-адресов',
    'backup__ip_mapping__download' => 'Сохранить текущее сопоставление IP-адресов в файл',
    'b_backup__ip_mapping__download' => 'Скачать конфигурацию сопоставления IP-адресов.',
    'b_backup__ip_mapping__download_is_empty' => 'Конфигурация сопоставления IP-адресов пуста.',
    'backup__ip_mapping_upload__title' => 'Загрузить файл сопоставления IP-адресов',
    'backup__ip_mapping__upload' => 'Загрузить файл сопоставления IP-адресов',
    'b_backup__ip_mapping__upload' => 'Загрузить конфигурацию сопоставления IP-адресов.',
    'backup__ip_mapping__list__header' => 'Сопоставление IP-адресов',
    'backup__ip_mapping__list__adddress' => 'Старые IP-адреса',
    'backup__ip_mapping__list__select_ip' => 'Новые IP-адреса',
    'backup__ip_mapping__clients_ip' => "IP-пул клиента %1",
    'backup__ip_mapping__resellers_ip' => "IP-пул реселлера %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Выделенные IP-адреса должны быть сопоставлены с уникальными IP-адресами. Выберите уникальный IP-адрес для каждого выделенного IP-адреса в списке.',
    'backup__ip_mapping__legend' => 'Сопоставление IP-адресов',
    'backup__ip_mapping__upload_legend' => 'Загрузить',
    'backup__ip_mapping__upload_file_text' => 'Файл соответствия IP-адресов',
    'backup__ip_mapping__upload_file_hint' => 'Файл соответствия IP-адресов ‒ это обычный текстовый файл. Каждая строка такого файла содержит соответствие IP-адресов в следующем формате: <старый IP-адрес> <новый IP-адрес>',
    'backup__ip_mapping__ip_address_not_found' => 'Нет ни одного свободного IP-адреса этого типа.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Невозможно выполнить перенос данных: сопоставление IP-адресов не завершено, так как в пуле на целевом сервере нет свободных IP-адресов.',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Доменам с этим IP-адресом будут запрещены небезопасные FTP-соединения.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Доменам с этим IP-адресом будут запрещены безопасные FTPS-соединения.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Конфликты',
    'backup__restore__object_vhost' => 'Виртуальный сервер',
    'backup__restore__object_plesk_admin' => 'Администратор Plesk',
    'backup__restore__object_ftpuser' => 'учетная запись FTP',
    'backup__restore__object_frontpageuser' => 'учетная запись FrontPage',
    'backup__restore__object_webuser' => 'веб-пользователя',
    'backup__restore__object_domain' => 'домен',
    'backup__restore__object_subdomain' => 'субдомен',
    'backup__restore__object_domainalias' => 'псевдоним домена',
    'backup__restore__object_client' => 'клиент',
    'backup__restore__object_reseller' => 'реселлер',
    'backup__restore__object_autoresponder' => 'автоответчик',
    'backup__restore__object_mailalias' => 'почтовый псевдоним',
    'backup__restore__object_database' => 'база данных',
    'backup__restore__object_mailname' => 'учетная запись электронной почты',
    'backup__restore__object_db_user' => 'пользователь базы данных',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-сертификат',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Следующие реселлеры не могут быть восстановлены, так как они преобразованы в клиентов: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Следующие клиенты не могут быть восстановлены, так как они преобразованы в реселлеров: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Следующие клиенты не могут быть восстановлены, так как они перенесены к другому владельцу: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'На целевом сервере недостаточно места для переноса всех выбранных подписок. Доступно: %1 Mб. Требуется: %2 Mб. Требуемое пространство рассчитывается исходя из общего объема данных в доменах (веб, почта, базы данных). Это значение рассчитывается раз в день и хранится в кэше, поэтому оно может отличаться от фактического размера доменов. Убедитесь, что выбранные домены не занимают больше места, чем доступно, и продолжите перенос.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Пожалуйста, освободите дисковое пространство на целевом сервере.',
    'backup__restore__capability_source_not_enough_disk_text' => 'На исходном сервере недостаточно дискового пространства для хранения временных файлов при переносе. Доступно: %1 Mб. Требуется: %2 Mб.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Пожалуйста, освободите дисковое пространство на исходном сервере.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Сведения о сервере',

    'backup__restore__capability_not_installed_component_text' => 'На целевом сервере не установлен компонент %1. Компонент %1 будет недоступен для всех восстановленных объектов.',
    'backup__restore__capability_not_installed_component_resolution' => 'Пожалуйста, установите %1. Это может занять несколько минут.',
    'backup__restore__capability_existing_sys_user_text' => 'На целевом сервере уже существует системный пользователь с именем %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Пожалуйста, переименуйте системного пользователя на целевом сервере.',
    'backup__restore__capability_license_usage_text' => 'После переноса данных на целевом сервере будут превышены следующие ограничения на ресурсы (определенные ключом лицензии):',
    'backup__restore__capability_license_usage_resolution' => 'Пожалуйста, установите на целевом сервере другой ключ лицензии, включающий необходимое количество ресурсов.',
    'backup__restore__capability_max_allowed_packet_text' => "Параметр 'max_allowed_packet' на исходном сервере БД имеет значение %1, что больше, чем на целевом сервере, где оно составляет %2. Некоторые объекты базы данных для указанных ниже доменов могут быть не восстановлены.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Пожалуйста, увеличьте значение 'max_allowed_packet' на целевом сервере БД.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Невозможно перенести базы данных PostgreSQL, так как версия PostgreSQL на целевом сервере меньше, чем на конечном. Текущая версия — %1, необходимая версия — %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Пожалуйста, установите нужную версию PostgreSQL на целевом сервере.',
    'backup__restore__capability_db_server_connection_problems' => 'Невозможно подключиться к целевому серверу БД PostgreSQL. Без этого подключения перенос баз данных будет невозможен.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Пожалуйста, проверьте настройки подключения на целевом сервере баз данных.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'На целевом сервере отключен компонент %1.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Пожалуйста, включите %1 на целевом сервере.',
    'backup__restore__capability_not_configured_component_text' => 'На целевом сервере не настроен компонент %1.',
    'backup__restore__capability_not_configured_component_resolution' => 'Пожалуйста, настройте %1 на странице "Инструменты и настройки".',

    'backup__restore__capability_webmail_is_not_available' => 'Веб-почта %1 недоступна на целевом сервере. Вместо нее будет использоваться веб-почта %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Чтобы использовать ту же веб-почту, что и на исходном сервере, ее нужно установить на этом сервере.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Чтобы использовать ту же веб-почту, что на исходном сервере, ее нужно установить на целевом сервере.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Веб-почта '%1' недоступна на целевом сервере. Вместо нее для следующих подписок будет использоваться веб-почта %2: %3/",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Пожалуйста, установите нужную веб-почту на конечном сервере.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Настройки веб-почты',

    'backup__restore__capability_shell_is_not_available' => 'Оболочка %1 недоступна на целевом сервере. Вместо нее будет использоваться одна из доступных оболочек.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Чтобы использовать ту же оболочку, что на исходном сервере, ее нужно включить (в /etc/shells) или установить на целевом сервере.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Целевой DNS-сервер не поддерживает сети из шаблона ограничений передачи зоны. Записи с IP-адресами, входящими в ограничения передачи DNS, восстановлены не будут.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Целевой DNS-сервер не поддерживает сети из шаблона ограничений передачи зоны, но некоторые подписки содержат сети, входящие в ограничения передачи DNS. Записи с IP-адресами, входящими в ограничения передачи DNS, восстановлены не будут.',

    'backup__restore__capability_wrong_php_handler_text' => 'Обработчик РНР %1 недоступен на целевом сервере. Вместо него будет использоваться обработчик РНР %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Чтобы использовать тот же обработчик PHP, что на исходном сервере, вам нужно включить или установить его на целевом сервере.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Обработчик PHP %1 недоступен. Вместо него Plesk будет использовать %2 для следующих тарифных планов: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Обработчик PHP %1 недоступен. Вместо него Plesk будет использовать %2 для следующих сайтов: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Обработчик PHP %1 недоступен. Его нельзя использовать для следующих сайтов: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => 'Версия %1 %2 недоступна на целевом сервере. Вместо нее будет использоваться версия по умолчанию.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Чтобы использовать ту же версию %1, что на исходном сервере, вам нужно включить или установить ее на целевом сервере.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Политика использования антивируса на целевом сервере не позволяет устанавливать индивидуальные (для отдельных почтовых адресов) настройки антивируса для исходящей почты. Эти настройки не будут перенесены.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Политика использования антивируса на целевом сервере не позволяет устанавливать индивидуальные (для отдельных почтовых адресов) настройки антивируса для входящей почты. Эти настройки не будут перенесены.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Политика использования антивируса на целевом сервере не позволяет устанавливать индивидуальные (для отдельных почтовых адресов) настройки антивируса. Эти настройки не будут перенесены.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Для того чтобы перенести индивидуальные настройки антивируса, пожалуйста, включите соответствующие опции на странице \"Инструменты и настройки\" > \"Настройки защиты от вирусов\".",
    'backup__restore__capability_antivirus_not_active_text' => 'У вас не включен антивирус. Настройки антивируса с исходного сервера начнут работать, только когда вы выберете антивирус на целевом сервере.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Пожалуйста, выберите этот антивирус на странице "Инструменты и настройки" > "Настройки защиты от вирусов" > раздел "Настройки антивируса".',

    'backup__restore__capability_antivirus_another_active_text' => 'Антивирус %2 недоступен на целевом сервере. Вместо него будет использоваться %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Чтобы использовать тот же антивирус, что на исходном сервере, пожалуйста, установите и выберите его на странице "Инструменты и настройки" > "Настройки защиты от вирусов" > раздел "Настройки антивируса".',
    'backup__restore__capability_not_available_sni_text' => 'На целевом сервере отсутствует SNI. Сайты с одним и тем же IP-адресом не смогут использовать отдельные SSL/TLS-сертификаты.',
    'backup__restore__capability_not_available_sni_resolution' => "Пожалуйста, убедитесь, что операционная система на целевом сервере поддерживает SNI и поддержка SNI включена в Plesk (опция 'Включить поддержку SNI, которая позволяет использовать отдельные SSL/TLS-сертификаты для сайтов с одним и тем же IP-адресом' на странице \"Инструменты и настройки\" > \"Настройки сервера\").",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Настройки сервера',

    'backup__restore__capability_vhost_already_exists_text' => 'Сайт %1 не может быть перенесен: на целевом сервере уже существует сайт с таким именем.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Пожалуйста, переименуйте или удалите сайт с таким же именем.',
    'backup__restore__capability_removed_vhosts' => 'Следующие подписки не будут восстановлены, так как содержат доменные имена, которые уже существуют на целевом сервере: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'На исходном сервере обнаружено %3 разных обработчика(ов) PHP с типом %1 и версией %2. На целевом сервере вместо них будет использоваться один обработчик надлежащего типа и версии. Обратите внимание, что настройки PHP на исходном и целевом сервере могут различаться.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Установщик Plesk не поддерживает Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Установщик Plesk не поддерживает Python. Пожалуйста, установите Python вручную.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Настройки почтового сервера',

    'backup__restore__capability_ftps_disabled' => 'Использование безопасных FTPS-подключений разрешено на исходном сервере, но запрещено на целевом. Пользовательские приложения, использующие FTP, могут работать с ошибками.',
    'backup__restore__capability_ftps_required' => 'Использование небезопасных FTP-подключений разрешено на исходном сервере, но запрещено на целевом. Пользовательские приложения, использующие FTP, могут работать с ошибками.',
    'backup__restore__capability_ftps_policy_resolution' => 'Политику безопасности FTP-соединений можно изменить на странице "Инструменты и настройки" > "Политика безопасности".',

    'backup__restore__capability_too_much_download_time_text' => '%1 мегабайт данных будет перенесено с исходного сервера на конечный за %2 часов.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Для более быстрого переноса, пожалуйста, проверьте сетевое соединение между исходным и конечным серверами и устраните проблемы (если они есть).',
    'backup__restore__too_low_download_speed' => "менее 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Для более быстрого переноса, пожалуйста, проверьте сетевое соединение между исходным и конечным серверами и устраните проблемы (если они есть).',
    'backup__restore__capability_zero_download_speed_text' => 'Минимальная приемлемая скорость скачивания составляет %1 Мб/с. Скорость скачивания между исходным и конечным серверами составляет 0 Мб/с. Это может быть вызвано проблемами с сетевым соединением. Перенос невозможен.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Пожалуйста, проверьте сетевое соединение между исходным и конечным серверами и устраните проблемы.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Минимальная приемлемая скорость скачивания составляет %2 Мб/с. Скорость скачивания между исходным и целевым сервером составляет %1 Мб/с. Это может увеличить время переноса. В вашем случае миграция %3 Мб займет %4 часов.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Минимальная приемлемая скорость скачивания составляет %2 Мб/с. Скорость скачивания между исходным и целевым сервером составляет %1 Мб/с. Это может увеличить время переноса.',

    'backup__restore__capability_remote_database_migration' => "Следующие домены используют удаленные базы данных: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Если на исходном сервере установлена более ранняя версия Plesk (до 11.5), не удаляйте эти домены с исходного сервера после завершения переноса. Просто приостановите их. Если вы удалите эти домены, их базы данных будут удалены с удаленного сервера. Примечание: дампы удаленных баз данных будут храниться на исходном сервере в папке %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Резервные копии серверов баз данных MySQL с версией ниже 5.1 (%1) могут не восстановиться на MySQL 5.1.x, так как MySQL 5.1.x по-другому обрабатывает символы Юникод.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Пожалуйста, смотрите статью базы знаний #136850',

    'backup__restore__capability_courier_not_installed_text' => 'На целевом сервере не установлен компонент Courier-IMAP.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Пожалуйста, установите Courier-IMAP с помощью установщика Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'На целевом сервере не установлен компонент Dovecot.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Пожалуйста, установите Dovecot с помощью установщика Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Срок хранения статистики трафика в конфигурациях следующих объектов меньше, чем глобальное значение на целевом сервере.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Пожалуйста, измените значение глобального параметра, определяющего срок хранения статистики на целевом сервере. Оно должно быть меньше или равно минимальному значению в конфигурациях доменов.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Срок хранения статистики трафика на некоторых доменах меньше, чем глобальное значение (%1). Для них это значение будет изменено на %1.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'У некоторых тарифных планов срок хранения статистики трафика меньше, чем у всего сервера (%1). Для них это значение будет изменено на %1.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Сопоставление выделенного IP-адреса с общим приведет к отключению доступа по HTTPS и анонимного доступа по FTP (если только у вас не включена поддержка SNI).',

    'backup__restore__no_postgresql_commands_text' => 'Эта подписка использует удаленную базу данных PostgreSQL, а ее временная резервная копия не может быть создана, так как на исходном сервере отсутствуют команды pg_dump и psql.',
    'backup__restore__no_postgresql_commands_resolution' => 'Пожалуйста, установите клиент PostgreSQL, поддерживающий эти команды.',
    'backup__restore__capability_apache_modules_disabled_text' => 'На целевом сервере отключены следующие модули Apache: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Пожалуйста, включите эти модули во избежание возможных проблем.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'На целевом сервере не установлены следующие модули Apache: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Пожалуйста, установите и включите эти модули во избежание возможных проблем.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Ограничение исходящих сообщений не поддерживается вашей лицензией. Соответствующие настройки не будут перенесены.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Пожалуйста, установите на целевом сервере ключ лицензии, который включает в себя необходимые функции.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'На целевом сервере отключено ограничение исходящих сообщений. Соответствующие настройки не будут перенесены.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Пожалуйста, включите ограничение исходящих сообщений на целевом сервере.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Глобальные параметры почты',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Ограничение на исходящие сообщения от почтового ящика не поддерживается почтовым сервером на целевом сервере. Значение этого ограничения не будет перенесено.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Пожалуйста, выберите такой же почтовый сервер, как на исходном сервере.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Глобальные параметры почты',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Ограничение на исходящие сообщения от домена не поддерживается почтовым сервером на целевом сервере. Значение этого ограничения не будет перенесено.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Пожалуйста, выберите такой же почтовый сервер, как на исходном сервере.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Глобальные параметры почты',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Ограничение на исходящие сообщения от подписки не поддерживается почтовым сервером на целевом сервере. Значение этого ограничения не будет перенесено.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Пожалуйста, выберите такой же почтовый сервер, как на исходном сервере.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Глобальные параметры почты',

    'bu_conflict_resolver_absent_phosting' => 'Указанные файлы не могут быть восстановлены, так как для этого нужен физический хостинг. Пожалуйста, создайте домен с физическим хостингом и попробуйте еще раз.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Данные реселлеров не будут восстановлены, потому что управление реселлерами не поддерживается.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'На целевом сервере не установлен компонент ModSecurity.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Чтобы перенесенные сайты были защищены брандмауэром, пожалуйста, установите ModSecurity. Установка может занять несколько минут.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Если вы хотите перенести настройки брандмауэра для веб-приложений, вам нужно установить ModSecurity. Установка может занять несколько минут.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'На целевом сервере не настроен компонент ModSecurity.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Если вы хотите, чтобы перенесенные сайты были защищены брандмауэром, настройте ModSecurity.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Брандмауэр для веб-приложений (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'На целевом сервере отключен брандмауэр ModSecurity.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Если вы хотите, чтобы перенесенные сайты были защищены брандмауэром, активируйте ModSecurity.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Брандмауэр для веб-приложений (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Не установлен компонент ModSecurity. Не будут восстановлены настройки брандмауэра веб-приложений для следующих объектов: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Сайты не могут быть восстановлены, так как принадлежат подписке %1, которая не существует в Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'На целевом сервере не установлен компонент %1. Служба DNS будет недоступна, а настройки DNS будут потеряны. Все сайты клиентов будут недоступны.',
    'bu_conflict_resolver_dns_not_installed' => 'Служба DNS не установлена. Для следующих объектов настройки DNS не будут восстановлены: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Следующие подписки не могут быть восстановлены, так как они были перенесены к другим владельцам: \'%1\'.',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Следующие подписки не могут быть восстановлены, так как они были перенесены к другим провайдерам: \'%1\'.',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Не удалось найти утилиту восстановления Web Presence Builder для восстановления данных Web Presence Builder. Возможно, Web Presence Builder не установлен.',
    'backup__restore__capability_renamed_db' => 'База данных "%1" уже используется другой подпиской. Название восстановленной базы данных будет изменено на "%2".',
    'backup__restore__capability_renamed_db_user' => 'Имя пользователя базы данных "%1" уже используется другой подпиской. Имя восстановленного пользователя базы данных будет изменено на "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Установщик Plesk не поддерживает Perl. Пожалуйста, установите ActiveState Perl вручную.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% обслуживается Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% обслуживается nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Антивирус Касперского',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Временные конфликты',
    'backup__restore__hint_timing_conflicts' => 'Конфликты возникают, когда восстанавливаемый объект уже существует в системе с более поздней датой изменения либо отсутствует в системе.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Использовать конфигурацию и данные из резервной копии',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Полностью перезаписать конфигурацию и данные объекта, имеющиеся в настоящее время в системе, конфигурацией и данными из файла резервной копии. Если восстановленный объект в настоящее время принадлежит другому владельцу, то объект будет восстановлен под прежним владельцем.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Использовать конфигурацию из текущей системы и данные из резервной копии',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Перезаписать текущие данные объекта данными из файла резервной копии, но сохранить конфигурацию объекта, имеющуюся в настоящее время в системе. Если восстановленный объект в настоящее время принадлежит другому владельцу, то объект будет восстановлен под текущим владельцем.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Не восстанавливать',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Не восстанавливать объекты, вызывающие временные конфликты.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Конфликты использования ресурсов',
    'backup__restore__hint_resource_usage_conflicts' => 'Конфликты использования ресурсов возникают, если ограничения по использованию ресурсов восстановленного объекта были превышены после восстановления.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Разрешить перерасход',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Восстановить объект и разрешить использовать больше ресурсов, чем было предоставлено изначально.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Не восстанавливать',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Не восстанавливать объекты, вызывающие конфликты использования ресурсов.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Конфликты конфигураций',
    'backup__restore__hint_configuration_conflicts' => 'Конфликты конфигураций возникают в тех случаях, когда восстановленный объект имеет свойства и веб-приложения, не разрешенные или запрещенные политикой владельца объекта или на текущем сервере. Например, конфликты конфигураций возникают при восстановлении учетных записей почты, имеющих индивидуальные настройки антиспама, если текущая серверная политика запрещает такие настройки для учетных записей почты.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Автоматически',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Восстановить объект и автоматически включить все опции конфликтующих конфигураций, которыми позволяют управлять ваши права.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Не восстанавливать',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Не восстанавливать объекты, вызывающие конфликты конфигураций.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Выделенные пулы приложений IIS запрещены в настройках пулов приложений IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Пожалуйста, измените настройки пула приложений IIS на странице "Инструменты и настройки" > "Пул приложений IIS" > "Глобальные настройки".',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Общие пулы приложений IIS запрещены в настройках пулов приложений IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Пожалуйста, измените настройки пула приложений IIS на странице "Инструменты и настройки" > "Пул приложений IIS" > "Глобальные настройки".',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'На целевом сервере запрещены краткие имена почтовых учетных записей POP3/IMAP.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'После восстановления данных краткие имена почтовых учетных записей станут недоступны.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Не удалось открыть файл журнала.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Не удается восстановить подписку %1: она была удалена из вашей учетной записи, и у вас недостаточно полномочий для создания новых подписок. Чтобы восстановить эту подписку, пожалуйста, обратитесь к своему сервис-провайдеру.',

    'backup__error11' => 'Недостаточно свободного места для резервного копирования.',
    'backup__error3011' => 'Отказано в подключении: указанные адрес и порт не прослушиваются ни одной программой.',
    'backup__error3012' => 'Таймаут подключения.',
    'backup__error3013' => 'Сеть недоступна.',
    'backup__error3014' => 'Отсутствует маршрут к серверу.',
    'backup__error3015' => 'Подключение не удалось.',
    'backup__error3016' => 'Не удается преобразовать имя сервера.',
    'backup__error3017' => 'Неверное имя пользователя или пароль.',
    'backup__error3018' => 'SSH-подключение не удалось.',

    'backup__error3110' => 'Не удается подключиться к удаленному агенту миграции: подключение к серверу недоступно.',
    'backup__error3111' => 'Агент миграции заблокирован неудавшейся задачей миграции или используется другим процессом миграции. Пожалуйста, перезапустите агент миграции на исходном сервере.',
    'backup__error3112' => 'Исходный сервер недоступен, или на нем не запущен агент миграции.',
    'backup__error3113' => 'Не удается установить агент миграции на сервер с Linux. Пожалуйста, проверьте SSH-подключение к исходному серверу.',
    'backup__error3114' => 'Не удается установить агент миграции на сервер с Linux: SSH-подключение не выполнено.',
    'backup__error3115' => 'Неверное имя пользователя или пароль.',
    'backup__error3116' => 'У данного пользователя нет прав администратора.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Все настройки и контент',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Все настройки и контент, кроме почтовых',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Только почтовые настройки и сообщения',

    'dns_t__unable_to_remove_ns_record' => 'Невозможно удалить NS-запись из шаблона DNS: каждая зона DNS должна иметь хотя бы одну NS-запись.',
    'dns__unsupported_server_zone_transfer' => 'Невозможно перенести шаблон ограничений передачи зоны из-за DNS-конфигурации сервера: перенос следующих сетевых адресов разрешен на исходном сервере, но эти адреса запрещены DNS-сервером Microsoft: %1',
    'dns__unsupported_domain_zone_transfer' => 'Невозможно перенести шаблон ограничений передачи зоны из-за DNS-конфигурации доменов: перенос следующих сетевых адресов разрешен на некоторых доменах, но эти адреса запрещены DNS-сервером Microsoft: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Определить сопоставление серверов баз данных',
    'dbbackup__check_network_settings_failed' => 'Нет доступа к общей временной сетевой папке для резервных копий. Пожалуйста, проверьте настройки этой сетевой папки, имя пользователя и пароль. Ошибка: %1',

    'migration_select_exist_db_server' => 'Выберите целевой сервер баз данных',

    'dbbackup__temp_dir_wrong_value' => 'Недопустимый путь к временной папке.',
    'dbbackup__network_temp_dir_wrong_value' => 'Недопустимый путь к временной сетевой папке.',
    'dbbackup__server_backup_not_configured' => 'На этом сервере не настроены параметры резервного копирования баз данных.',
    'dbbackup__temp_dir' => 'Временная папка',
    'dbbackup__temp_dir_hint' => 'Путь к физической папке на удаленном сервере, где расположен сервер MS SQL. Сервер MS SQL должен иметь доступ к этой папке для чтения и записи временных файлов резервного копирования. Например, C:\\ПутьКПапке',
    'dbbackup__network_temp_dir_hint' => 'Путь к сетевой папке с общим доступом, сопоставленной с физической папкой, указанной выше. Plesk будет использовать папку с общим доступом для загрузки и скачивания файлов резервных копий. Например, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Имя сетевого пользователя, созданного на удаленном сервере. Например, ИмяСервера\\ИмяПользователя. Пользователь должен иметь доступ к указанной выше папке общего доступа.',
    'dbbackup__network_password_hint' => 'Пароль сетевого пользователя',

    'dbbackup__success_import_without_dublicate_users' => 'Следующие пользователи не были импортированы: %1. Они уже существуют на сервере баз данных.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Архивировать журналы",
    'log_rot__log_rot_status' => "Статус ротации журналов",
    'log_rot__log_rot_period' => "Условие ротации журналов",
    'log_rot__log_rot_size' => "по объему",
    'log_rot__log_rot_time' => "по времени",
    'log_rot__logrotation_enable' => "Включить ротацию журналов",
    'log_rot__mail' => "Отправлять обработанные журналы по адресу",
    'log_rot__max_number_of_logfiles' => "Максимальное количество журналов",
    'log_rot__time_period' => "период",
    'log_rot__unable_turn_off' => 'Не удалось выключить ротацию журналов, так как она включена на уровне сервера',
    'log_rot__unable_set_period' => 'Не удалось установить периодичность ротации журналов, отличную от \'daily\' (ежедневно), так как это значение задано на уровне сервера',
    'log_rot__unable_set_max_log_files' => 'Не удалось установить максимальное количество файлов журнала больше серверного ограничения %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Введите число: %1",
    'actionlog__incorrect_rotation' => "Указаны недопустимые параметры ротации журналов: %1",
    'actionlog__unknown_rot_period' => "Неизвестный период обработки: %1",
    'actionlog__unknown_rot_type' => "Неизвестный тип обработки: %1",
    'actionlog__session_preferences' => 'Параметры сеанса',
    // items (PFU schema)
    'actionlog__admin_info' => 'Сведения об администраторе',
    'actionlog__admin_preferences' => "Настройки администратора",
    'actionlog__service' => 'Служба',
    'actionlog__ip_addr' => 'IP-адрес',
    'actionlog__client' => 'Учетная запись клиента',
    'actionlog__client_status' => 'Статус учетной записи клиента',
    'actionlog__client_preferences' => "Настройки интерфейса клиента",
    'actionlog__client_ip_pool' => "Пул IP-адресов клиента",
    'actionlog__client_siteapp' => "Репозиторий веб-приложений клиента",
    'actionlog__client_guid' => "GUID клиента",
    'actionlog__domain' => 'Домен по умолчанию (первый домен, добавленный в подписку)',
    'actionlog__domain_owner' => 'Владелец подписки',
    'actionlog__domain_plan' => 'Тарифный план подписки',
    'actionlog__domain_status' => 'Домен по умолчанию, статус',
    'actionlog__domain_dns' => 'Домен по умолчанию, зона DNS',
    'actionlog__subdomain' => 'Субдомен домена по умолчанию',
    'actionlog__domain_alias' => 'Домен по умолчанию, псевдоним',
    'actionlog__domain_alias_dns' => 'Домен по умолчанию, зона DNS псевдонима',
    'actionlog__site' => 'Домен',
    'actionlog__site_status' => 'Статус домена',
    'actionlog__site_dns' => 'Зона DNS домена',
    'actionlog__site_guid' => 'GUID домена',
    'actionlog__site_subdomain' => 'Субдомен',
    'actionlog__site_alias' => 'Псевдоним домена',
    'actionlog__site_alias_dns' => 'Зона DNS псевдонима домена',
    'actionlog__domain_limits' => 'Ограничения подписки',
    'actionlog__domain_limit_size' => 'Ограничение места на диске для подписки',
    'actionlog__domain_limit_traffic' => 'Ограничение трафика для подписки',
    'actionlog__domain_limits_powerUser' => 'Ограничения подписки',
    'actionlog__domain_limit_size_powerUser' => 'Ограничение места на диске для подписки',
    'actionlog__domain_limit_traffic_powerUser' => 'Ограничение трафика для подписки',
    'actionlog__domain_guid' => "Домен по умолчанию, GUID",
    'actionlog__cp_user' => 'Пользователь Plesk',
    'actionlog__mailname' => 'Учетная запись почты',
    'actionlog__maillist' => 'Список рассылки',
    'actionlog__phosting' => 'Настройки хостинга',
    'actionlog__forwarding' => 'Хостинг со стандартным перенаправлением или перенаправлением во фрейме',
    'actionlog__webuser' => 'Учетная запись веб-пользователя',
    'actionlog__site_application' => 'Веб-приложение',
    'actionlog__license' => 'Ключ лицензии',
    'actionlog__additional_license' => 'Дополнительный ключ лицензии',
    'actionlog__template_domain' => "Тарифный план реселлера",
    'actionlog__template_admin' => "Тарифный план администратора",
    'actionlog__template_reseller' => 'План реселлера',
    'actionlog__admin_alias' => 'Дополнительная учетная запись администратора', // PFW
    'actionlog__ftpuser' => 'Дополнительная учетная запись FTP', // PFW
    'actionlog__db_server' => 'Сервер баз данных',
    'actionlog__db' => 'База данных',
    'actionlog__db_user' => 'Учетная запись пользователя базы данных',
    'actionlog__client_sapppkg_pool' => "Веб-приложение пользователя", // PFW, not used?
    'actionlog__remote_dns' => 'Статус удаленного сервера DNS', // PFW
    'actionlog__reseller' => 'Учетная запись реселлера',
    'actionlog__reseller_guid' => 'GUID реселлера',
    'actionlog__reseller_ip_pool' => "Пул IP-адресов реселлера",
    'actionlog__reseller_limit_size' => 'Лимит дискового пространства для реселлера',
    'actionlog__reseller_limit_traffic' => 'Лимит трафика для реселлера',
    'actionlog__reseller_limits' => 'Ограничения реселлера',
    'actionlog__reseller_permissions' => 'Права реселлера',
    'actionlog__reseller_preferences' => "Настройки интерфейса реселлера",
    'actionlog__reseller_siteapp' => "Веб-приложения в пуле реселлера",
    'actionlog__reseller_status' => 'Статус учетной записи реселлера',
    'actionlog__health_status' => 'Состояние сервера',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'достижение',
    'actionlog__added' => 'добавление',
    'actionlog__removed' => 'удаление',
    'actionlog__change' => 'изменение',
    'actionlog__update' => 'обновление',
    'actionlog__move' => 'перемещено',
    'actionlog__upgrade' => 'обновление', // PFU?
    'actionlog__update_or_add' => 'обновление или добавление',
    'actionlog__expired' => 'срок действия истек',
    'actionlog__create' => 'создание',
    'actionlog__delete' => 'удаление',
    'actionlog__service_stop' => 'остановка',
    'actionlog__service_restart' => 'перезапуск',
    'actionlog__service_start' => 'запуск',
    'actionlog__login' => 'вход',
    'actionlog__logout' => 'выход',
    'actionlog__install' => 'установка',
    'actionlog__uninstall' => 'удаление',
    'actionlog__reconfigure' => 'изменение настроек',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Запрос на смену пароля',
    'actionlog__event_admin_update' => 'Информация об администраторе обновлена',
    'actionlog__event_admin_preferences_update' => "Обновлены настройки администратора",
    'actionlog__event_service_restart' => 'Сервис перезапущен',
    'actionlog__event_service_start' => 'Сервис запущен',
    'actionlog__event_service_stop' => 'Сервис остановлен',
    'actionlog__event_ip_address_create' => 'IP-адрес создан',
    'actionlog__event_ip_address_delete' => 'IP-адрес удален',
    'actionlog__event_ip_address_update' => 'IP-адрес обновлен',
    'actionlog__event_client_create' => 'Учетная запись клиента создана',
    'actionlog__event_client_delete' => 'Учетная запись клиента удалена',
    'actionlog__event_client_update' => 'Учетная запись клиента обновлена',
    'actionlog__event_client_status_update' => 'Статус учетной записи клиента обновлен',
    'actionlog__event_client_preferences_update' => "Клиентские настройки интерфейса обновлены",
    'actionlog__event_client_siteapp_added' => "Веб-приложение добавлено в пул приложений учетной записи клиента",
    'actionlog__event_client_siteapp_removed' => "Веб-приложение удалено из пула приложений учетной записи клиента",
    'actionlog__event_domain_limit_size_reached' => 'Лимит дискового пространства для подписки исчерпан',
    'actionlog__event_domain_limit_traffic_reached' => 'Лимит трафика для подписки исчерпан',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Лимит дискового пространства для подписки исчерпан',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Лимит трафика для подписки исчерпан',

    'actionlog__domain_limit_database' => 'Квота на базы данных для подписки',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Квота на базы данных MySQL для подписки исчерпана',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Мягкая квота на базы данных MySQL для подписки исчерпана',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Квота на базы данных Microsoft SQL Server для подписки исчерпана',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Мягкая квота на базы данных Microsoft SQL Server для подписки исчерпана',
    'actionlog__event_plesk_component_upgrade' => 'Компонент Plesk обновлен',
    'actionlog__event_plesk_component_install' => 'Компонент Plesk установлен',
    'actionlog__event_plesk_component_uninstall' => 'Компонент Plesk удален',
    'actionlog__event_domain_create' => 'Домен по умолчанию (первый домен, добавленный в подписку) создан',
    'actionlog__event_domain_delete' => 'Домен по умолчанию (первый домен, добавленный в подписку) удален',
    'actionlog__event_domain_update' => 'Обновлен домен по умолчанию (первый домен, добавленный в подписку)',
    'actionlog__event_domain_owner_change' => 'Владелец подписки изменен',
    'actionlog__event_domain_plan_change' => 'Тарифный план подписки изменен',
    'actionlog__event_domain_status_update' => 'Домен по умолчанию, обновлен статус',
    'actionlog__event_domain_dns_update' => 'Домен по умолчанию, обновлена зона DNS',
    'actionlog__event_subdomain_create' => 'Субдомен домена по умолчанию создан',
    'actionlog__event_subdomain_delete' => 'Субдомен домена по умолчанию удален',
    'actionlog__event_subdomain_update' => 'Субдомен домена по умолчанию обновлен',
    'actionlog__event_domain_alias_create' => 'Домен по умолчанию, псевдоним создан',
    'actionlog__event_domain_alias_delete' => 'Домен по умолчанию, псевдоним удален',
    'actionlog__event_domain_alias_update' => 'Домен по умолчанию, псевдоним обновлен',
    'actionlog__event_domain_limits_update' => 'Обновлены ограничения подписки',
    'actionlog__event_cp_user_login' => 'Пользователь Plesk вошел в систему',
    'actionlog__event_cp_user_logout' => 'Пользователь Plesk вышел из системы',
    'actionlog__event_mailname_create' => 'Учетная запись почты создана',
    'actionlog__event_mailname_delete' => 'Учетная запись почты удалена',
    'actionlog__event_mailname_update' => 'Учетная запись почты обновлена',
    'actionlog__event_maillist_create' => 'Список рассылки создан',
    'actionlog__event_maillist_delete' => 'Список рассылки удален',
    'actionlog__event_maillist_update' => 'Список рассылки обновлен',
    'actionlog__event_phys_hosting_create' => 'Физический хостинг создан',
    'actionlog__event_phys_hosting_delete' => 'Физический хостинг удален',
    'actionlog__event_phys_hosting_update' => 'Физический хостинг обновлен',
    'actionlog__event_forwarding_create' => 'Хостинг со стандартным перенаправлением или перенаправлением во фрейме создан',
    'actionlog__event_forwarding_delete' => 'Хостинг со стандартным перенаправлением или перенаправлением во фрейме удален',
    'actionlog__event_forwarding_update' => 'Хостинг со стандартным перенаправлением или перенаправлением во фрейме обновлен',
    'actionlog__event_webuser_create' => 'Учетная запись веб-пользователя создана',
    'actionlog__event_webuser_delete' => 'Учетная запись веб-пользователя удалена',
    'actionlog__event_webuser_update' => 'Учетная запись веб-пользователя обновлена',
    'actionlog__event_siteapp_install' => 'Веб-приложение установлено',
    'actionlog__event_siteapp_reconfigure' => 'Веб-приложение перенастроено',
    'actionlog__event_siteapp_uninstall' => 'Веб-приложение удалено',
    'actionlog__event_license_update' => 'Лицензионный ключ обновлен',
    'actionlog__event_admin_alias_create' => 'Дополнительная учетная запись администратора создана',
    'actionlog__event_admin_alias_delete' => 'Дополнительная учетная запись администратора удалена',
    'actionlog__event_admin_alias_update' => 'Дополнительная учетная запись администратора обновлена',
    'actionlog__event_ftpuser_create' => 'Дополнительная учетная запись FTP создана',
    'actionlog__event_ftpuser_update' => 'Дополнительная учетная запись FTP обновлена',
    'actionlog__event_ftpuser_delete' => 'Дополнительная учетная запись FTP удалена',
    'actionlog__event_template_domain_create' => "Тарифный план реселлера создан",
    'actionlog__event_template_domain_update' => "Тарифный план реселлера обновлен",
    'actionlog__event_template_domain_delete' => "Тарифный план реселлера удален",
    'actionlog__event_template_admin_create' => "Тарифный план администратора создан",
    'actionlog__event_template_admin_update' => "Тарифный план администратора обновлен",
    'actionlog__event_template_admin_delete' => "Тарифный план администратора удален",
    'actionlog__event_database_server_create' => 'Сервер баз данных создан',
    'actionlog__event_database_server_update' => 'Сервер баз данных обновлен',
    'actionlog__event_database_server_delete' => 'Сервер баз данных удален',
    'actionlog__event_remote_dns_status_update' => 'Статус удаленного сервера DNS обновлен',
    'actionlog__event_session_preferences_update' => 'Настройки сеанса обновлены',
    'actionlog__event_domain_alias_dns_update' => 'Домен по умолчанию, зона DNS псевдонима домена обновлена',
    'actionlog__event_domain_move' => 'Домен по умолчанию перемещен в новую подписку',
    'actionlog__event_site_move' => 'Домен перемещен в новую подписку',
    'actionlog__event_site_subdomain_move' => 'Субдомен перемещен в новую подписку',
    'actionlog__event_subdomain_move' => 'Субдомен домена по умолчанию перемещен в новую подписку',
    'actionlog__event_license_expired' => 'Срок действия лицензии Plesk истек',
    'actionlog__event_database_create' => 'База данных создана',
    'actionlog__event_database_delete' => 'База данных удалена',
    'actionlog__event_database_user_create' => 'Учетная запись пользователя базы данных создана',
    'actionlog__event_database_user_update' => 'Параметры учетной записи пользователя базы данных обновлены',
    'actionlog__event_database_user_delete' => 'Учетная запись пользователя базы данных удалена',
    'actionlog__event_client_guid_update' => "GUID клиента обновлен",
    'actionlog__event_domain_guid_update' => 'Домен по умолчанию, обновлен идентификатор GUID',
    'actionlog__event_reseller_create' => 'Учетная запись реселлера создана',
    'actionlog__event_reseller_delete' => 'Учетная запись реселлера удалена',
    'actionlog__event_reseller_update' => 'Учетная запись реселлера обновлена',
    'actionlog__event_reseller_guid_update' => 'GUID реселлера обновлен',
    'actionlog__event_reseller_ip_pool_update' => "Пул IP-адресов реселлера обновлен",
    'actionlog__event_reseller_limit_size_reached' => 'Лимит дискового пространства для учетной записи реселлера исчерпан',
    'actionlog__event_reseller_limit_traffic_reached' => 'Лимит трафика для учетной записи реселлера исчерпан',
    'actionlog__event_reseller_limits_update' => 'Ограничения реселлера обновлены',
    'actionlog__event_reseller_permissions_update' => 'Права реселлера обновлены',
    'actionlog__event_reseller_preferences_update' => "Настройки интерфейса реселлера обновлены",
    'actionlog__event_reseller_siteapp_added' => "Приложение добавлено в пул приложений реселлера",
    'actionlog__event_reseller_siteapp_removed' => "Приложение удалено из пула приложений реселлера",
    'actionlog__event_reseller_status_update' => 'Статус реселлера обновлен',
    'actionlog__event_template_reseller_create' => 'План реселлера создан',
    'actionlog__event_template_reseller_delete' => 'План реселлера удален',
    'actionlog__event_template_reseller_update' => 'План реселлера обновлен',
    'actionlog__event_health_status_change' => 'Изменилось состояние сервера',
    'actionlog__event_siteapp_upgrade' => 'Веб-приложение обновлено',
    'actionlog__event_extension_install' => 'Расширение установлено',
    'actionlog__event_extension_uninstall' => 'Расширение удалено',
    'actionlog__event_extension_upgrade' => 'Расширение обновлено',
    'actionlog__event_extension_status_update' => 'Состояние расширения обновлено',
    'actionlog__event_additional_license_expired' => 'Истек срок дополнительной лицензии',
    'actionlog__event_hostname_changed' => 'Имя хоста сервера изменено',
    'actionlog__event_smb_user_create' => 'Дополнительный пользователь создан',
    'actionlog__event_smb_user_delete' => 'Дополнительный пользователь удален',
    'actionlog__event_smb_user_update' => 'Дополнительный пользователь обновлен',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "На удаленном компьютере не установлен API RPC Plesk. Обратитесь к своему сервис-провайдеру.",
    'rsession_no_account_errmsg' => "Не удалось получить доступ к удаленному сервису из-под текущей учетной записи. Скорее всего сервис для вашей учетной записи еще не активирован. Пожалуйста, подождите несколько минут и попытайтесь повторить операцию еще раз. Если такая ошибка повторится, обратитесь к системному администратору.",
    'rsession_no_domain_errmsg' => "Не удалось получить доступ к удаленному сервису для домена. Скорее всего сервис для домена еще не активирован. Пожалуйста, подождите несколько минут и попытайтесь повторить операцию еще раз. Если такая ошибка повторится, обратитесь к системному администратору.",
    'rsession_unknown_errmsg' => "Удаленный сервер отказал в установке сессии. Обратитесь к системному администратору за поддержкой. Ошибка: %1",
    'rsession_unknown2_errmsg' => "Неизвестная ошибка при установке сеанса удаленной работы. Наиболее вероятно, что удаленный сервер отвечает неправильно либо не отвечает совсем. Попросите системного администратора проанализировать детали ошибки в журнале ошибок веб-сервера.",
    'rsession_no_connect_errmsg' => "Не удалось получить доступ к удаленному сервису: соединение с удаленной сессии завершилось с ошибкой. Обратитесь к системному администратору за поддержкой.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Разрешить загрузку в папку Incoming",
    'anonftp__allow_create_dirs' => 'Разрешить создание папок в папке Incoming',
    'anonftp__allow_download_incoming' => 'Разрешить скачивание из папки Incoming',
    'anonftp__display_login' => 'Показывать сообщение при входе',
    'anonftp__login_text' => 'Текст сообщения',
    'anonftp__limit_incoming_disk_space' => "Ограничить размер папки Incoming",
    'anonftp__limit_maximum_bandwidth' => "Ограничить пропускную способность",
    'anonftp__limit_maximum_connections' => "Ограничить максимальное количество одновременных соединений",
    'anonftp__unable_init' => "Инициализировать анонимный FTP не удалось: %1",
    'anonftp__unable_set_quota' => "Установить ограничение на размер папки Incoming не удалось: %1",
    'anonftp__unable_update' => "Сохранить настройки анонимного FTP не удалось: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-сертификаты', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Корневой сертификат не подписывает этот сертификат.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Секретный ключ и сертификат несовместимы.",
    'class_sslcertificate__invalid_cert_format' => "Недопустимый формат сертификата.",
    'class_sslcertificate__invalid_private_key_format' => "Недопустимый формат секретного ключа.",
    'class_sslcertificate__prob_invalid_priv_key' => "Возможно, используется секретный ключ недопустимого формата.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Создать виртуальную папку',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Создать виртуальную папку',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Создать виртуальную папку.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Создать виртуальную папку',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Создать виртуальную папку',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Создать виртуальную папку.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Создать папку',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Создать папку',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Создать папку.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Создать папку',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Создать папку',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Создать папку.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Свойства папки',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Свойства виртуальной папки',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Просмотреть и изменить свойства виртуальной папки.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Свойства папки',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Свойства виртуальной папки',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Просмотреть и изменить свойства виртуальной папки.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Права доступа к папке',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Права доступа к папке',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Настроить права доступа к папке.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Права доступа к папке',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Права доступа к папке',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Настроить права доступа к папке.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Настройки ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Настройки ASP.NET для %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Настроить ASP.NET для виртуальной папки %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Настройки ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Настройки ASP.NET для %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Настроить ASP.NET для виртуальной папки %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Настройки PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Настройки PHP для %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Настроить PHP для виртуальной папки %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Настройки PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Настройки PHP для %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Настроить PHP для виртуальной папки %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Удалить',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Удалить виртуальные папки',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Удалить выбранные виртуальные папки.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Удалить',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Удалить виртуальные папки',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Удалить выбранные виртуальные папки.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Следующие виртуальные папки будут удалены:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Выберите виртуальные папки, которые хотите удалить.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Типы MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Типы MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Просмотреть список зарегистрированных типов MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Добавить тип MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Добавить тип MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Зарегистрировать новый тип MIME.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Страницы ошибок',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Страницы ошибок',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Просмотреть и изменить страницы ошибок.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Защита',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Защита папок',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Ограничить доступ к папке с помощью пароля.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Защита',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Защита папок',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Ограничить доступ к папке с помощью пароля.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Настройки',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Посмотреть расположение папки и указать название защищенного раздела.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Настройки пользователя',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Добавить пользователя',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Добавить пользователя',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Добавить учетную запись пользователя, чтобы разрешить доступ к защищенной папке.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Новые настройки применены.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Учетная запись пользователя добавлена.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Удалить',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Удалить пользователей защищенной папки.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Удалить учетные записи пользователей',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Подтвердить удаление учетных записей пользователей.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Учетные записи удалены.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Операция успешно завершена.',
    'ui__admin/extras-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__admin/report/layout/delete_multi__done' => 'Выбранные шаблоны отчетов были удалены.',
    'ui__admin/report/traffic-history__done' => 'Операция успешно завершена.',
    'ui__admin/report__done' => 'Операция успешно завершена.',
    'ui__admin-alias/delete_multi__done' => "Выбранные дополнительные учетные записи администратора были удалены.",
    'ui__admin-alias/properties__done' => "Свойства о дополнительной учетной записи администратора изменены.",
    'ui__admin-alias/properties_new__done' => "Была создана дополнительная учетная запись администратора.",
    'ui__admin-alias/properties_unknown__done' => "Свойства о дополнительной учетной записи администратора изменены.",
    'ui__admin-alias__done' => "Информация о дополнительной учетной записи администратора успешно обновлена.",
    'ui__admin/manage-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__admin/register-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Выбранные расписания доставки отчетов были удалены.',
    'ui__admin/report/layout/auto/properties__done' => 'Расписание доставки отчетов было обновлено.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Расписание доставки отчетов было создано.',
    'ui__admin/report/layout/properties__done' => 'Шаблон отчета %1 был обновлен.',
    'ui__admin/report/layout/properties_new__done' => 'Шаблон отчета %1 был создан.',
    'ui__client/domain/certificate/properties__done' => 'Свойства SSL/TLS-сертификата были обновлены.',
    'ui__client/domain/certificate/properties_new__done' => 'Новый SSL/TLS-сертификат добавлен. Чтобы он заработал, не забудьте выбрать его в настройках веб-хостинга сайта (вкладка Сайты и домены> имя домена).',
    'ui__client/domain/certificate__done' => 'Операция успешно завершена.',
    'ui__client/domain/certificate_self__done' => 'Операция успешно завершена.',
    'ui__client/domain/chowner__done' => 'Подписка %1 теперь принадлежит другому пользователю.',
    'ui__client/domain/chowner_multi__done' => 'Владелец подписки был изменен.',
    'ui__client/domain/chowner_multi-select__done' => 'Операция успешно завершена.',
    'ui__client/domain/chowner_select__done' => 'Операция успешно завершена.',
    'ui__client/domain/dbbackup/create__done' => "Резервное копирование базы данных успешно выполнено.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Резервное копирование базы данных успешно выполнено.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Потерянный пользователь успешно восстановлен.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Резервные копии успешно удалены.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Содержимое базы данных успешно восстановлено.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Операция успешно завершена.", // PFW
    'ui__client/domain/dbbackup__done' => "Операция успешно завершена.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Операция успешно завершена.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Операция успешно завершена.", // PFW
    'ui__client/domain/delete__done' => "Домен %1 был удален.",
    'ui__client/domain/delete_multi__done' => "Домены были удалены.",
    'ui__client/domain/disable__done' => 'Домен %1 приостановлен.',
    'ui__client/domain/disable_multi__done' => 'Выбранные домены были приостановлены.',
    'ui__client/domain/enable__done' => 'Сайт %1 активирован.',
    'ui__client/domain/enable_multi__done' => 'Выбранные сайты активированы.',
    'ui__client/domain/extras__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/domain/extras_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Настройки ротации журналов были изменены.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Настройки ротации журналов были изменены.',
    'ui__client/domain/hosting/logs__done' => 'Операция успешно завершена.',
    'ui__client/domain/hosting/logs_self__done' => 'Операция успешно завершена.',
    'ui__client/domain/hosting/protected-directories__done' => 'Операция успешно завершена.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Операция успешно завершена.',
    'ui__client/domain/hosting/setup__done' => 'Хостинг для %1 был настроен.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Версия ASP.NET была изменена.', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => 'Операция успешно завершена.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Операция успешно завершена.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Настройки ASP.NET для %1 были изменены.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Виртуальная папка на сайте %1 создана.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Виртуальная папка создана.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Выбранные папки удалены.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Выбранные папки удалены.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Пользовательские страницы ошибок обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Выбранные типы MIME были удалены', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Новый тип MIME был зарегистрирован.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Операция успешно завершена.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Права доступа к папке обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Права доступа к папке обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Настройки PHP для %1 обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Настройки PHP для %1 обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Свойства папки обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Свойства папки обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Настройки защиты папки обновлены.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Настройки защиты папки обновлены.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Операция успешно завершена.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Операция успешно завершена.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'SSL/TLS-сертификаты, доступные в интернет-магазине',
    'ui__client/domain/mpc-certificates_self__done' => 'SSL/TLS-сертификаты, доступные в интернет-магазине',
    'ui__client/domain/register__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/domain/register_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/domain/rename__done' => 'Имя домена изменено.',
    'ui__client/domain/rename_self__done' => "Домен был успешно переименован.",
    'ui__client/domain/settings_self__done' => 'Операция успешно завершена.',
    'ui__client/domain/toggle_disable__done' => "Домен %1 приостановлен.",
    'ui__client/domain/toggle_enable__done' => "Домен %1 активирован.",
    'ui__client/domain/traffic__done' => 'Операция успешно завершена.',
    'ui__client/domain/traffic_self__done' => 'Операция успешно завершена.',
    'ui__client/domain/traffic_unknown__done' => 'Операция успешно завершена.',
    'ui__client/domain-summary-report__done' => 'Операция успешно завершена.',
    'ui__client/domain-summary-report_self__done' => 'Операция успешно завершена.',
    'ui__client/domain-summary-report_unknown__done' => 'Операция успешно завершена.',
    'ui__client/extras-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/extras-domain_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/ipaddress/delete_multi__done' => 'Операция успешно завершена.',
    'ui__client/ipaddress/properties__done' => 'Операция успешно завершена.',
    'ui__client/ipaddress/properties_new__done' => 'Операция успешно завершена.',
    'ui__client/ip-pool/properties__done' => "IP-пул клиента %1 обновлен.",
    'ui__client/ip-pool/properties_self__done' => 'Операция успешно завершена.',
    'ui__client/limits__done' => "Ограничения ресурсов для клиента %1 изменены.",
    'ui__client/limits_self__done' => 'Операция успешно завершена.',
    'ui__client/logo__done' => 'Новые настройки брендинга для клиента %1 применены.',
    'ui__client/logo_reseller__done' => 'Новые настройки брендинга применены.',
    'ui__client/logo_self__done' => 'Настройки брендинга применены.',
    'ui__client/logo_self-reseller__done' => 'Настройки брендинга вашей панели применены.',
    'ui__client/manage-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/manage-domain_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/permissions__done' => "Права клиента %1 были изменены.",
    'ui__client/permissions_self__done' => 'Операция успешно завершена.',
    'ui__client/preferences__done' => "Настройки клиента %1 были изменены.",
    'ui__client/preferences_self__done' => "Ваши настройки изменены.",
    'ui__client/register-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/register-domain_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__client/report/traffic-history__done' => 'Операция успешно завершена.',
    'ui__client/report/traffic-history_self__done' => 'Операция успешно завершена.',
    'ui__client/report__done' => 'Операция успешно завершена.',
    'ui__client/report_self__done' => 'Операция успешно завершена.',
    'ui__client/sessions/delete__done' => 'Операция успешно завершена.',
    'ui__client/sessions/delete_self__done' => 'Операция успешно завершена.',
    'ui__client/sessions__done' => 'Операция успешно завершена.',
    'ui__client/sessions_self__done' => 'Операция успешно завершена.',
    'ui__client/skeleton__done' => 'Операция успешно завершена.',
    'ui__client/skeleton_self__done' => 'Операция успешно завершена.',
    'ui__client/traffic__done' => "Операция успешно завершена.",
    'ui__client/traffic_unknown__done' => 'Операция успешно завершена.',
    'ui__cp-access__done' => 'Операция успешно завершена.',
    'ui__cp-session/properties__done' => 'Операция успешно завершена.',
    'ui__cp-session__done' => 'Операция успешно завершена.',
    'ui__ftp-sessions__done' => 'Операция успешно завершена.',
    'ui__license__done' => 'Операция успешно завершена.',
    'ui__logo__done' => "Настройки фирменного стиля Plesk были изменены.",
    'ui__longtasks/longtask/properties__done' => "Настройки фоновых задач были успешно изменены.",
    'ui__mass-email/delete__done' => "Шаблон сообщения %1 был удален.", // PFW
    'ui__mass-email/delete_multi__done' => "Шаблоны сообщений были удалены.",  // PFW
    'ui__mass-email/send_main__done' => "Операция успешно завершена.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Учетные записи клиента успешно выбраны.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Учетные записи администраторов доменов успешно выбраны.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Реселлеры успешно выбраны.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Изменения, внесенные в шаблон сообщений почтовой рассылки, сохранены.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Шаблон сообщений почтовой рассылки создан.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Учетные записи клиентов для шаблона сообщений почтовой рассылки выбраны.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Учетные записи администраторов доменов для шаблона сообщений почтовой рассылки выбраны.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Реселлеры для шаблона сообщений почтовой рассылки были выбраны.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Шаблон сообщений почтовой рассылки изменен.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Были указаны неверные значения.', // PFW
    'ui__mass-email__done' => "Операция успешно завершена.", // PFW
    'ui__mass-mail__done' => "Операция завершена успешно", // PFU
    'ui__mass-mail/delete__done' => 'Шаблон сообщения %1 был удален.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Шаблоны сообщений были удалены.', // PFU
    'ui__mass-mail/properties__done' => 'Шаблон %1 был изменен.', // PFU
    'ui__mass-mail/properties_new__done' => 'Шаблон %1 был создан.', // PFU
    'ui__mass-mail/send__done' => 'Сообщения были отправлены.', // PFU
    'ui__mass-mail/send_new__done' => 'Сообщения были отправлены.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Сообщения были отправлены.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Сообщения были отправлены.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Новый шаблон сообщений был создан', // PFU
    'ui__mass-mail/template/properties__done' => 'Шаблон сообщений изменен.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Параметры наблюдения за диском были обновлены.', // PFU
    'ui__modules__done' => 'Операция успешно завершена.',
    'ui__modules__short-title' => 'Расширения',
    'ui__modules__title' => 'Расширения',
    'ui__reseller/client/traffic_unknown__done' => 'Операция завершена успешно.',
    'ui__reseller/extras-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__reseller/extras-domain_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__reseller/ftp-sessions_self__done' => 'Операция успешно завершена.',
    'ui__reseller/limits__done' => "Ограничения по ресурсам и политики использования ресурсов реселлера были изменены.",
    'ui__reseller/limits_readonly-self__done' => 'Операция успешно завершена.',
    'ui__reseller/limits_self__done' => 'Ваши ограничения по ресурсам и политики использования ресурсов были изменены.',
    'ui__reseller/manage-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__reseller/manage-domain_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__reseller/permissions__done' => 'Права реселлера %1 были изменены.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Операция успешно завершена.',
    'ui__reseller/register-domain__done' => 'Страница MyPlesk.com была открыта.',
    'ui__reseller/register-domain_self__done' => 'Страница MyPlesk.com была открыта.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Выбранные расписания доставки отчетов были удалены.',
    'ui__reseller/report/layout/auto/properties__done' => 'Расписание доставки отчетов было обновлено.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Расписание доставки отчета было добавлено.',
    'ui__reseller/report/layout/properties__done' => 'Шаблон отчета был изменен.',
    'ui__reseller/report/layout/properties_new__done' => 'Новый шаблон отчета был создан.',
    'ui__reseller/report/traffic-history__done' => 'Операция успешно завершена.',
    'ui__reseller/report/traffic-history_self__done' => 'Операция успешно завершена.',
    'ui__reseller/report__done' => 'Операция успешно завершена.',
    'ui__reseller/report_self__done' => 'Операция успешно завершена.',
    'ui__reseller/sessions/delete__done' => 'Операция завершена успешно',
    'ui__reseller/sessions/delete_self__done' => 'Операция завершена успешно',
    'ui__reseller/sessions__done' => 'Операция успешно завершена.',
    'ui__reseller/sessions_self__done' => 'Операция успешно завершена.',
    'ui__reseller/traffic__done' => 'Операция успешно завершена.',
    'ui__reseller/traffic_self__done' => 'Операция успешно завершена.',
    'ui__reseller/traffic_unknown__done' => 'Операция успешно завершена.',
    'ui__reseller/logo_self__title' => 'Брендинг Plesk',
    'ui__reseller/logo_self__done' => 'Ваши настройки фирменного стиля Plesk были применены.',
    'ui__server/aspdotnet__done' => 'Серверные настройки ASP.NET были изменены.', // PFW
    'ui__server/certificate/default_multi__done' => 'Выбранный SSL/TLS-сертификат теперь используется для защиты подключений к вновь размещаемым сайтам.',
    'ui__server/certificate/delete_multi__done' => 'Выбранные SSL/TLS-сертификаты были удалены.',
    'ui__server/certificate/download__done' => 'SSL/TLS-сертификат загружен.',
    'ui__server/certificate/properties__done' => 'Свойства SSL/TLS-сертификата были обновлены.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-сертификат %1 создан.',
    'ui__server/certificate/setup_multi__done' => 'Выбранный SSL/TLS-сертификат был установлен.',
    'ui__server/certificate__done' => 'Операция успешно завершена.',
    'ui__server/cp-certificate-download__done' => "SSL/TLS-сертификат Plesk был загружен.",
    'ui__server/crontab/properties__done' => 'Запланированные задачи пользователя %1 изменены.',
    'ui__server/crontab/task/delete__done' => 'Задача была удалена.',
    'ui__server/crontab/task/delete_multi__done' => 'Задачи были удалены.',
    'ui__server/crontab/task/properties__done' => 'Запланированные задачи обновлены.',
    'ui__server/crontab/task/properties_new__done' => 'Новая задача запланирована.',
    'ui__server/crontab/task/toggle_disable__done' => 'Запланированная задача %1 отключена.',
    'ui__server/crontab/task/toggle_enable__done' => 'Запланированная задача %1 включена.',
    'ui__server/crontab__done' => 'Операция успешно завершена.',
    'ui__server/dns__done' => 'Операция успешно завершена.',
    'ui__server/ip-address/client/delete__done' => "IP-адрес был удален из пула IP-адресов клиента.",
    'ui__server/ip-address/client/delete_multi__done' => "IP-адрес был удален из пулов IP-адресов клиентов.",
    'ui__server/ip-address/client/properties_new__done' => 'IP-адрес был назначен пользователям.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-адрес %1 был назначен выбранным клиентам.',
    'ui__server/ip-addresses__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/spam/recipients__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/spam/summary__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/spam__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/virus/recipients__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/virus/summary__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/virus/viruses__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics/virus__done' => "Операция завершена успешно.",
    'ui__server/mail/statistics__done' => "Операция завершена успешно.",
    'ui__server/mail__done' => 'Настройки почтового сервера были изменены.',
    'ui__server/maillists__done' => 'Операция успешно завершена.',
    'ui__server/mpc-certificates__done' => 'Страница интернет-магазина со списком доступных SSL/TLS-сертификатов была открыта.',
    'ui__server/pmm__done' => 'Операция успешно завершена.',
    'ui__server/preferences__done' => "Настройки сервера были изменены.",
    'ui__server/register__done' => 'Страница MyPlesk.com была открыта.',
    'ui__server/services__done' => 'Операция успешно завершена.',
    'ui__server/sitebuilder__done' => 'Операция успешно завершена.',
    'ui__server/skeleton__done' => 'Операция успешно завершена.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Адрес %1 был удален из глобального черного списка.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Адреса были удалены из глобального черного списка.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Адреса были добавлены в черный список.',
    'ui__server/spam-filter/black-list/address__done' => 'Адреса были добавлены в черный список.',
    'ui__server/spam-filter/black-list__done' => 'Операция успешно завершена.', // PFU
    'ui__server/spam-filter/properties__done' => 'Настройки антиспама были изменены.',
    'ui__server/spam-filter/toggle_disable__done' => 'Антиспам отключен.',
    'ui__server/spam-filter/toggle_enable__done' => 'Антиспам включен.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Адрес %1 был удален из глобального белого списка.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Адреса были удалены из глобального белого списка.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Адреса были добавлены в белый список.',
    'ui__server/spam-filter/white-list/address__done' => 'Адреса были добавлены в белый список.',
    'ui__server/spam-filter/white-list__done' => 'Операция успешно завершена.', // PFU
    'ui__server/spam-filter__done' => 'Операция успешно завершена.',
    'ui__server/statistics__done' => 'Операция успешно завершена.',
    'ui__server/time__done' => "Системная дата и время были изменены.",
    'ui__server__done' => "Операция завершена успешно.",
    'ui__sessions/properties__done' => 'Операция успешно завершена.',
    'ui__sessions__done' => 'Операция успешно завершена.',
    'ui__sessions/delete__done' => 'Выбранные сеансы были удалены.',
    'ui__start-page__done' => 'Операция успешно завершена.',
    'ui__support__done' => 'Форма запроса технической поддержки была открыта в новом окне или вкладке браузера.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Нет файлов для загрузки.',
    'login_up__access_denied_no_permission' => "Доступ запрещен. У вас нет права на вход.",
    'mail__unable_remove_pattern' => "Невозможно удалить адрес из черного списка сервера: %1", // PFW
    'mail__incorrect_network_format' => 'Неправильный формат сети: %1', // PFW
    'initconf__unable_change_passwd' => "Не удалось изменить пароль администратора.%1",
    'initconf__unable_get_passwd' => 'Не удалось получить текущий пароль администратора: ошибка при выполнении %1: %2',
    'initconf__invalid_hostname' => 'Ошибка в имени хоста "%1"',
    'initconf__unable_reconfig' => 'Не удалось перенастроить Plesk: ошибка при выполнении reconfig: %1',
    'initconf__unable_update_admin' => 'Не удалось обновить контактную информацию администратора: %1',
    '__refresh' => 'Обновить',
    '__dalias_not_exist' => 'Такой псевдоним домена не существует.',
    '__bug146523_explanation' => 'В прошлых версиях Plesk имена пользователей FTP могли содержать до 16 символов. В этой версии Plesk максимальная длина имен пользователей FTP составляет 15 символов. Для разрешения этой проблемы сократите длину имен пользователей FTP до 15 символов и измените в них как минимум один символ, чтобы избежать конфликта имен. Приносим извинения за неудобства.',
    'domain__cannot_change_webmail' => 'Невозможно изменить веб-почту для домена: %1',
    'sb_publish_disable_warning' => 'Если вы отключите функцию создания сайтов с помощью Presence Builder, созданный ранее сайт будет удален вместе со всем содержимым. Чтобы продолжить, нажмите ОК.',
    '__sbnet_client_use_sbnet' => "Создать соответствующую учетную запись пользователя в Presence Builder",
    'mail_resp_activate' => 'Включить автоответчик',
    'limitsManger__limit_available_error' => 'Невозможно выделить требуемый объем ресурсов ("%%limitName%%"): объем доступных ресурсов для вашей учетной записи — %%available%%.',
    'limitsManger__limit_reserved_error' => 'Невозможно выделить меньше ресурсов ("%%limitName%%"), чем уже используется.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Невозможно переименовать домен: виртуальная папка с таким именем уже существует.',
    'domain_unable_to_rename' => 'Не удалось переименовать домен.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Общие',
    'spamfilter__spamassassin_status_legend' => 'Антиспам SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Настройки SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Включить антиспам SpamAssassin для всего сервера",
    'spamfilter__spamassassin_user_status_legend' => 'Включить антиспам SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Включить антиспам на основе серого списка для всего сервера',
    'spamfilter__personal_settings_not_allowed' => 'Использование индивидуальных настроек антиспама запрещено системной политикой.',
    'spamfilter__required_score' => 'Балл, после получения которого письмо считается спамом',
    'spamfilter__rewrite_header_subject' => 'Добавлять в тему писем, сочтенных за спам, следующий текст',
    'spamfilter__use_mailuser_prefs' => 'Применять индивидуальные настройки антиспама',
    'spamfilter_addresses__text_hint' => 'При перечислении адресов используйте в качестве разделителей перевод строки, пробел, символ табуляции, запятую или точку с запятой. Не допускается использование не-ASCII символов в адресе до знака "@". В адресах можно использовать подстановочные знаки "*" и "?" (например, *@domain.com, user?@*.com). Не допускается использование подстановочных знаков в не-ASCII метках доменов.',
    'spamfilter__score_error' => 'Количество баллов должно быть положительным числом, число перед десятичной запятой должно быть меньше 100, а число после десятичной запятой может включать не более двух цифр.',
    'spamfilter__rewrite_header_error' => 'Тема сообщения может содержать любые печатные символы, кроме #.',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Возвращать',
    'nonexistent_mail__mode_discard' => 'Игнорировать',
    'nonexistent_mail__mode_catch_addr' => 'Перенаправлять на адрес электронной почты',
    'nonexistent_mail__mode_catch_ip' => 'Перенаправление на IP',
    'nonexistent_mail__bounce_not_supported' => 'Режим отказа не поддерживается',
    'nonexistent_mail__discard_not_supported' => 'Режим игнорирования не поддерживается',
    'nonexistent_mail__catch_not_supported' => 'Перенаправление на адреса электронной почты не поддерживается',
    'nonexistent_mail__redirect_not_supported' => 'Перенаправление на IP не поддерживается',
    'nonexistent_mail__ip_used_on_this_host' => 'IP-адрес соответствует имени localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Поскольку включен контроль исходящей почты, почтовый адрес %1 для несуществующих получателей должен принадлежать выбранному домену. В противном случае вместо перенаправления будет выполняться действие "Отклонять".',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Поскольку включен контроль исходящей почты, почтовый адрес, указанный для перенаправления почты (%1), должен принадлежать выбранному домену. В противном случае сообщения, отправляемые на этот адрес, не будут учитываться при контроле исходящей почты.',
    // mail acc extras
    '__antivirus' => "Антивирус",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Нет доступных дополнительных учетных записей администратора.', // PFW
    'ui__client/domain/certificate__none-available' => 'У клиента нет SSL/TLS-сертификатов.',
    'ui__client/domain/certificate__none-available__1' => 'У клиента нет доменов с SSL/TLS-сертификатами.',
    'ui__client/domain/certificate__none-available__2' => 'Домен не имеет SSL/TLS-сертификатов.',
    'ui__reseller/client__none-available' => 'Нет реселлеров с клиентами.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Выберите IP-адреса, которые вы хотите удалить из IP-пула.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Выберите реселлеров, из IP-пулов которых вы хотите удалить IP-адрес.',
    'ui__server/crontab/task/delete__empty_selection' => 'Вы должны выбрать задачу, которую хотите отменить.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Поддержка PHP для этого сайта отключена.',
    'phosting__aspdotnet_not_enabled' => 'Поддержка ASP.NET для этого сайта отключена.',
    'phosting__php_forced_by_site_isolation' => 'Невозможно изменить настройки РНР: нет прав на перезапись глобальной политики безопасности.',
    'phosting__option_forced_by_site_isolation' => 'Невозможно изменить настройки %1: нет прав на перезапись глобальной политики безопасности.',
    'phosting__php_handler_id_not_registered' => 'Этот обработчик PHP запрещен настройками изоляции сайтов. Вместо него будет использоваться обработчик PHP по умолчанию.',
    'phosting__php_served_by_nginx_is_not_available' => 'Этот обработчик PHP (Приложение FPM, обслуживаемое nginx) запрещен настройками изоляции сайтов. Вместо него будет использоваться обработчик PHP по умолчанию.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Просмотреть список IP-адресов',
    'ui__client/ipaddress/properties_readonly__title' => 'Просмотреть список IP-адресов',
    'ui__client/ipaddress/properties_readonly__description' => 'Просмотреть список IP-адресов, доступных для пользователя.',
    'ui__server/certificate__short-title' => 'SSL/TLS-сертификаты',
    'ui__server/certificate__title' => 'SSL/TLS-сертификаты',
    'ui__server/certificate__description' => 'Управление SSL/TLS-сертификатами.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Удалить типы MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Удалить типы MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Удалить выбранные типы MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Добавить тип MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Добавить тип MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Зарегистрировать тип MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Удалить IP-адреса',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Выберите IP-адреса, которые вы хотите удалить из IP-пула клиента %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP-адрес',
    'ui__client/ipaddress__title' => 'IP-адрес',
    'ui__client/ipaddress__description' => 'Просмотреть информацию по IP-адресу.',
    'ui__server/ip-address__short-title' => 'IP-адрес',
    'ui__server/ip-address__title' => 'IP-адрес',
    'ui__server/ip-address__description' => 'Просмотреть информацию по IP-адресу.',
    'ui__client/domain/hosting/setup__short-title' => 'Настройки веб-хостинга',
    'ui__client/domain/hosting/setup__title' => 'Настройки веб-хостинга',
    'ui__client/domain/hosting/setup__description' => 'Установить настройки веб-хостинга для сайта %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Тип MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Свойства типа MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Посмотреть свойства типа MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Сообщение об ошибке', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Сообщение об ошибке', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Свойства сообщений об ошибках.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Удалить выбранные шаблоны отчетов.',
    'b_resellerreportslist_search' => 'Введите шаблон поиска и нажмите кнопку, чтобы найти шаблоны отчетов.',
    'b_resellerreportslist_show_all' => 'Показать все доступные шаблоны отчетов.',

    'l_resellerreportslist_auto' => 'Сортировать шаблоны отчетов по автоматизации поставки.',
    'l_resellerreportslist_clients' => 'Сортировать шаблоны отчетов по наличию информации о клиентах.',
    'l_resellerreportslist_domains' => 'Сортировать шаблоны отчетов по наличию информации о доменах.',
    'l_resellerreportslist_general' => 'Сортировать шаблоны отчетов по наличию общей информации',
    'l_resellerreportslist_name' => 'Сортировать шаблоны отчетов по названию отчета.',
    'l_resellerreportslist_personal_domains' => 'Сортировать шаблоны отчетов по наличию информации о личных доменах.',

    'b_adminreportslist_remove' => 'Удалить выбранные шаблоны отчетов.',
    'b_adminreportslist_search' => 'Введите шаблон поиска и нажмите кнопку, чтобы найти шаблоны отчетов.',
    'b_adminreportslist_show_all' => 'Показать все доступные шаблоны отчетов.',

    'l_adminreportslist_auto' => 'Сортировать шаблоны отчетов по автоматизации поставки.',
    'l_adminreportslist_clients' => 'Сортировать шаблоны отчетов по наличию информации о клиентах.',
    'l_adminreportslist_domains' => 'Сортировать шаблоны отчетов по наличию информации о доменах.',
    'l_adminreportslist_general' => 'Сортировать шаблоны отчетов по наличию общей информации',
    'l_adminreportslist_name' => 'Сортировать шаблоны отчетов по названию отчета.',
    'l_adminreportslist_personal_clients' => 'Сортировать шаблоны отчетов по наличию информации о ваших клиентах.',
    'l_adminreportslist_personal_domains' => 'Сортировать шаблоны отчетов по наличию информации о ваших доменах.',
    'l_adminreportslist_resellers' => 'Сортировать шаблоны отчетов по наличию информации о реселлерах.',

    'b_get_password_cancel' => 'Вернуться на предыдущую страницу без отправки сообщения.',
    'b_get_password_send' => 'Нажмите OK, чтобы отправить сообщение с информацией о восстановлении пароля на адрес электронной почты, зарегистрированный в системе.',



    'b_personaltrafficlist_search' => 'Введите шаблон поиска и нажмите кнопку, чтобы найти домены.',
    'b_personaltrafficlist_show_all' => 'Показать все домены.',

    'b_back' => 'Вернуться на предыдущую страницу.',
    'b_next' => 'Перейти на следующую страницу.',

    'b_dnsnstemplatelist_remove' => 'Удалить выбранные серверы имен.',
    'b_dnsnstemplatelist_search' => 'Введите комбинацию для поиска и нажмите, чтобы найти серверы имен.',
    'b_dnsnstemplatelist_show_all' => 'Показать все серверы имен.',

    'l_dnsnstemplatelist_ns' => 'Сортировать записи DNS шаблонов по серверу имен.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Создавать защищенные ссылки на файлы и папки',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Разрешить публикацию файлов',
    'cu__serverfilesharing_fsPublicFolder' => 'Папка для хранения опубликованных файлов',
    'cu__serverfilesharing_fsPublicUrl' => 'URL для просмотра опубликованных файлов посетителями',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Включить защиту опубликованных файлов паролем',
    'cu__serverfilesharing_fsPartnerFolder' => 'Папка для хранения защищенных паролем файлов',
    'cu__serverfilesharing_fsPartnersLogin' => 'Имя пользователя для доступа к файлам',
    'cu__serverfilesharing_fsPartnersPassword' => 'Пароль для доступа к файлам',
    'cu__serverfilesharing_fsDomain' => 'URL корневой веб-папки. Имя домена',
    'cu__serverfilesharing_fsPrefix' => 'URL корневой веб-папки. Префикс',
    'cu__serverfilesharing_commandUpdate' => 'Обновить настройки общего доступа к файлам',
    'cu__serverfilesharing_commandInfo' => 'Показать текущие настройки общего доступа к файлам',
    'subscription_rename_is_forbidden' => 'Переименование подписок запрещено политикой сервера.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Управление запланированными на сервере задачами',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Выберите системного пользователя для управления запланированными задачами.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Запланированная задача %1',
    'ui__server/crontab/task__description' => 'Посмотреть детали запланированной задачи %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Системные пользователи',
    'ui__server/crontab_unknown__title' => 'Системные пользователи',
    'ui__server/crontab_unknown__description' => 'Системные пользователи, которые могут быть владельцами запланированных задач.',


    'ui__server/crontab__none-available' => 'У вас нет ни одного системного пользователя.',
    'ui__server/crontab_readonly-unknown__description' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Планировщик задач',
    'ui__server/crontab_readonly-unknown__title' => 'Просмотр запланированных задач',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab_readonly__description' => 'Просмотреть запланированные задачи для %1.',
    'ui__server/crontab_readonly__short-title' => 'Запланированная задача для %1',
    'ui__server/crontab_readonly__title' => 'Просмотреть запланированные задачи для %1',
    'ui__server/crontab_unknown__wizard-title' => 'Управление запланированными задачами.',

    'ui__server/crontab/properties__description' => 'Изменить настройки запланированных задач пользователя %1.',

    'ui__server/crontab/properties__short-title' => 'Настройки',
    'ui__server/crontab/properties__title' => 'Настройки запланированных задач пользователя %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Настройки',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Просмотр запланированных задач',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab/properties_readonly__description' => 'Просмотреть запланированные задачи пользователя %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Настройки',
    'ui__server/crontab/properties_readonly__title' => 'Просмотр запланированных задач пользователя %1',
    'ui__server/crontab/properties_unknown__description' => 'Редактировать запланированные задачи.',
    'ui__server/crontab/properties_unknown__short-title' => 'Свойства',
    'ui__server/crontab/properties_unknown__title' => 'Редактирование запланированных задач',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Редактировать запланированные задачи.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Выберите системного пользователя, чьи задачи вы хотите посмотреть.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Выберите системного пользователя, чьи задачи вы хотите изменить.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Нажмите Закончить, чтобы применить изменения и выйти из мастера.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Нажмите Закончить, чтобы выйти из мастера.',

    'ui__server/crontab/task__none-available' => 'У вас нет запланированных задач.',
    'ui__server/crontab/task__none-available__2' => 'У системного пользователя %1 нет запланированных задач.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Планировщик задач.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Задачи',
    'ui__server/crontab/task_readonly-unknown__title' => 'Планировщик задач',

    'ui__server/crontab/task/delete__description' => 'Удалить запланированную задачу %1',

    'ui__server/crontab/task/delete__short-title' => 'Удалить',
    'ui__server/crontab/task/delete__title' => 'Удалить запланированную задачу %1',
    'ui__server/crontab/task/delete_multi__description' => 'Удалить запланированные задачи.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Удалить',
    'ui__server/crontab/task/delete_multi__title' => 'Удаление запланированных задач',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Удалить запланированные задачи.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Выберите системного пользователя, чьи задачи вы хотите удалить.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Выбрать задачи для удаления.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Поставьте флажок для подтверждения удаления задачи и нажмите Закончить, чтобы завершить операцию и выйти из мастера.',
    'ui__server/crontab/task/delete_unknown__description' => 'Удалить запланированную задачу.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Удалить',
    'ui__server/crontab/task/delete_unknown__title' => 'Удалить запланированную задачу',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Удалить запланированную задачу.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Выберите системного пользователя, чью задачу вы хотите удалить.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Выбрать задачу для удаления.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Поставьте флажок для подтверждения удаления задачи и нажмите Закончить, чтобы завершить операцию и выйти из мастера.',

    'ui__server/crontab/task/properties__description' => 'Редактировать запланированные задачи.',

    'ui__server/crontab/task/properties__short-title' => 'Редактировать задачу %1',
    'ui__server/crontab/task/properties__title' => 'Редактирование запланированных задач',
    'ui__server/crontab/task/properties_new__description' => 'Создать запланированные задачи для %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Добавить задачу',
    'ui__server/crontab/task/properties_new__title' => 'Создать запланированные задачи для %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Создать запланированную задачу.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Выберите системного пользователя, для которого вы хотите создать запланированную задачу.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Нажмите Закончить, чтобы применить изменения и выйти из мастера.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Свойства',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Просмотр запланированных задач',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab/task/properties_readonly__description' => 'Просмотреть запланированные задачи.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Просмотреть задачу %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Просмотр запланированных задач',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Создать запланированные задачи.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Добавить задачу',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Создать запланированные задачи',
    'ui__server/crontab/task/properties_unknown__description' => 'Редактировать запланированные задачи.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Свойства',
    'ui__server/crontab/task/properties_unknown__title' => 'Редактирование запланированных задач',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Редактировать запланированные задачи.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Выберите системного пользователя, чьи задачи вы хотите посмотреть.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Выберите системного пользователя, чьи задачи вы хотите изменить.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Выберите запланированную задачу.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Выберите запланированную задачу, которую вы хотите изменить.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Нажмите Закончить, чтобы применить изменения и выйти из мастера.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Нажмите Закончить, чтобы выйти из мастера.',

    'ui__server/crontab/task/toggle_disable__description' => 'Отключить запланированную задачу %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Отключить',
    'ui__server/crontab/task/toggle_disable__title' => 'Отключить запланированную задачу %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Включить запланированную задачу %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Включить',
    'ui__server/crontab/task/toggle_enable__title' => 'Включить запланированную задачу %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Включить или отключить запланированные задачи.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Разрешить или запретить к выполнению',
    'ui__server/crontab/task/toggle_unknown__title' => 'Включение и отключение запланированных задач',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Включить или отключить запланированные задачи',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Выберите системного пользователя, чьи задачи вы хотите включить или отключить.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Выберите задачу, которую требуется разрешить или запретить к выполнению.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Учетные записи клиентов', // not used on HP?
    'ui__client_unknown__title' => 'Учетные записи клиентов', // not used on HP?
    'ui__client_unknown__description' => 'Управлять учетными записями клиентов.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Приостановить домен', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Приостановить домен', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Приостановить домен.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Активировать домен', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Активировать домен', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Активировать домен.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Учетные записи FTP в домене %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Учетные записи FTP",
    'ftp__user_name' => "Имя учетной записи FTP",
    'ftp__user_home' => "Домашняя папка",
    'ftp__invalid_path' => "Указан неправильный путь",
    'i_ftp_ses_sub_user' => 'Сеанс учетной записи FTP.',
    '__new_passwd' => "Новый пароль %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Настроить веб-сервер на сервере <%%host%%> не удалось',
    'apacheConfigurationFailedMessageBody' => "Создать конфигурационный файл веб-сервера на сервере <%%host%%> не удалось из-за следующих ошибок:\n\n%%error%%\n\nПожалуйста, устраните эти ошибки в шаблонах конфигурации веб-сервера и попробуйте создать файл еще раз.",

    'apacheConfigurationMessageAdminTitle' => 'Создать конфигурацию веб-сервера не удалось',
    'apacheConfigurationMessageClientTitle' => 'Предупреждение',

    'apacheConfigurationFailedAdminHomeMessage' => 'Из-за ошибок в шаблонах конфигурации создать новый конфигурационный файл не удалось. Подробное сообщение об ошибках было отправлено на ваш адрес электронной почты. Пожалуйста, устраните указанные в нем ошибки и нажмите %1, чтобы повторить попытку.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'здесь', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Из-за ошибок в шаблонах конфигурации создать новую конфигурацию для домена %1 не удалось. Подробное сообщение об ошибках было отправлено на ваш адрес электронной почты; пожалуйста, устраните указанные в нем ошибки и нажмите %2, чтобы повторить попытку.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'здесь', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'В конфигурации веб-сервера для домена %1 обнаружены несоответствия. Для решения этой проблемы обратитесь к администратору сервера.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Для некоторых доменов создать новую конфигурацию не удалось из-за ошибок в шаблонах конфигурации. Подробное сообщение об ошибках было отправлено на ваш адрес электронной почты. Пожалуйста, устраните указанные в нем ошибки и нажмите %1, чтобы повторить попытку.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'здесь', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Конфигурация веб-сервера для некоторых из ваших доменов может содержать несоответствия. Для решения этой проблемы обратитесь к администратору сервера.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Пользовательские страницы ошибок",
    'dom_pref__webusers_script' => "Разрешить веб-пользователям использовать скрипты",
    '__seoRedirect' => 'Предпочтительный домен',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Нет',

    '__sites' => 'Домены',
    'domain_plan__perm_denied_manage_phosting' => 'Вам запрещено управлять настройками хостинга.',
    '__owned_by_client' => 'принадлежит клиенту',
    'ui__client/permissions_readonly__description' => "Посмотреть список действий, которые может выполнять в Plesk клиент %1.",
    'backup__restore__object_client_template' => 'Шаблон клиента',
    '__template_name' => 'Название тарифного плана',
    'template__not_exists' => 'Такого тарифного плана не существует',
    'template__exists' => 'План с именем %1 уже существует.',
    'clientOwnerChanger__ip_not_in_pool' => 'Указанный IP-адрес не входит в пул данного реселлера.',

    //// Change owner of subscription
    'chown__select_title' => "Выберите нового подписчика",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Выберите нового владельца для выбранных подписок и нажмите Далее >>.',
    'domains__client_info' => "%1 подписок, %2 активных подписки, использовано %3 дискового пространства, %4 трафика",
    '__possible_owners' => 'Потенциальные владельцы подписок',

    'clients_list__filter_owner__filter_title' => 'Провайдер',
    'clients_list__filter_owner_any' => 'Все пользователи',
    'clients_list__filter_owner_my' => 'Только мои подписчики',
    'clients_list__filter_owner_name__filter_title' => 'Имя провайдера',

    '__owner' => "Провайдер",
    'l_clientslist_owner' => 'Сортировать учетные записи клиентов по провайдеру.',
    'l_clientslist_date' => 'Сортировать учетные записи клиентов по дате создания.',
    'l_clientslist_name' => 'Сортировать учетные записи пользователей по имени.',
    'l_clientslist_domains' => 'Сортировать учетные записи по доменам.',
    'l_clientslist_cname' => 'Сортировать учетные записи по названию компании.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Назначить нового владельца для выбранных подписок',
    'chown__check_title' => 'Изменить подписчика',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Для смены владельца нажмите Закончить. После завершения операции выбранные подписки будут присвоены новому владельцу, их провайдер будет изменен на провайдера нового владельца, они будут откреплены от своих тарифных планов и станут 'Персональными'.",

    'chown__error_check' => 'Во время попытки присвоить некоторые подписки новому владельцу возникли проблемы.',
    'domain_chown_subscription_will_be_anonymous' => "Подписки будут откреплены от своих текущих тарифных планов и станут 'Персональными'.",
    'chown__error_domains_exclude' => "Во время попытки присвоить некоторые подписки новому владельцу возникли проблемы. Эти подписки выделены цветом.",
    'chown__ip_not_in_client_pool' => "IP-адрес, соответствующий этой подписке, не был добавлен в IP-пул нового владельца.",
    'chown__already_owned_by_client' => "Эта подписка уже принадлежит этому пользователю.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Защищенная папка /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Управление защищенной папкой /%1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Добавить пользователя',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Добавить пользователя',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Создайте новую учетную запись пользователя для доступа к защищенной папке %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Учетная запись пользователя для доступа к защищенной папке создана.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Учетные данные пользователя сохранены.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Удаление пользователей защищенной папки',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Выберите пользователей, которых вы хотите удалить.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Удалить',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Удалить пользователей папки.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Будут удалены следующие пользователи защищенной папки:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Выбранные пользователи были удалены.',

    '__redirect_hint' => 'Вы будете перенаправлены на новый адрес через 15 секунд... Если этого не произойдет, включите, пожалуйста, javascript или нажмите на ссылку %%link%%.',

    'backup__restore__object_maillist' => 'Список рассылки',
    'backup__restore__object_site' => 'Сайт',
    'backup__restore__object_user' => 'Пользователь',
    'backup__restore__object_role' => 'Роль',

    'limit__name_max_site' => 'сайты',

    'iis_pool__unable_rename_client' => "Невозможно переименовать пул приложений IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Услуга "Анонимный FTP" поддерживается только для главного домена подписки.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Услуга "Анонимный FTP" поддерживается только для главного домена подписки.',

    '__gb' => 'Гб',
    '__tb' => 'Тб',
    '__gb_month' => 'Гб/месяц',
    '__tb_month' => 'Тб/месяц',

    '__customers' => 'Клиенты',
    '__customer_name' => 'Имя клиента',
    '__customer_total' => 'Всего клиентов',
    '__site' => 'Сайт',
    '__def_site' => 'Сайт по умолчанию',
    '__subscription_name' => 'Название подписки',
    '__subscription_name_powerUser' => 'Название подписки',

    'limit__units_max_traffic_suffix' => '/месяц',

    'dom_pref__discard' => "Отклонять",

    'mail__pattern_already_exists' => 'Критерий "%1" уже есть в черном списке.',

    '__not_supported' => 'не поддерживается',

    'plesk_key__sitebuilder' => 'Сайты, опубликованные с помощью Presence Builder',
    'limit__name_max_site_builder' => 'Сайты, опубликованные с помощью Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Поддержка многоязычных сайтов в Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Статистика передачи данных для <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Статистика передачи данных для <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Передача данных по службам",

    'login_up__access_denied_no_subscriptions' => "Доступ запрещен. Для этой учетной записи недоступно ни одной подписки.",

    'interval__day' => '%1 дней',
    'interval__hour' => '%1 часов',
    'interval__minute' => '%1 минут',
    'interval__second' => '%1 секунд',

    ///License options
    'plesk_key__backward_incompatibility' => 'Вы пытаетесь использовать ключ лицензии, созданный для другой версии Plesk. Обратитесь в службу продаж Plesk, чтобы получить правильный лицензионный ключ.',
    //Standalone or virtualization
    'virtualization_any' => "Физический сервер или любое виртуализационное решение",
    'virtualization_pvc' => "Контейнеры Virtuozzo",
    'virtualization_vmware' => "VMware",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Сервер Virtuozzo",
    'plesk_key__virtualization' => "Поддерживаемые окружения",
    'plesk_key__virtualization_only_key' => 'Этот ключ лицензии предназначен только для экземпляров Plesk, установленных в виртуальной среде %1.',
    'plesk_key__virtualizations_only_key' => 'Этот ключ лицензии предназначен только для экземпляров Plesk, установленных в следующих виртуальных средах: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Использование самостоятельно созданных языковых пакетов запрещено.',
    'plesk_key__allowed-locales' => 'Доступные языки',
    'plesk_key__allowed-locales-any' => 'Любой язык',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'папка cgi-bin расположена в',
    '_cgi_bin_mode_webspace' => 'корневая папка подписки',
    '_cgi_bin_mode_www_root' => 'корневая папка этого домена',

    /// Custom buttons
    'custom_button__sort_key' => 'Приоритет',
    'custom_button__place' => 'Расположение',
    'custom_button__place_navigation' => 'Общий доступ',
    'custom_button__place_admin' => 'Домашняя страница администратора',
    'custom_button__place_admin-settings' => 'Страница Инструменты и настройки в панели администратора',
    'custom_button__place_reseller' => "Домашняя страница реселлера",
    'custom_button__place_reseller-settings' => 'Страница Инструменты и утилиты в панели реселлера',
    'custom_button__place_client' => 'Домашняя страница клиента',
    'custom_button__place_domain' => "Страница подписки Сайты и домены",
    'custom_button__place_domain_powerUser' => "Страница подписки Сайты и домены",
    'custom_button__place_domain-properties' => 'Инструментарий сайтов',
    'custom_button__private' => 'Показывать только мне',
    'custom_button__image' => 'Фоновое изображение',
    'custom_button__conhelp' => "Текст подсказки",
    'custom_button__edit' => "Настройки ссылки на дополнительную услугу",
    'custom_button__include_client_cname' => "Включить название компании клиента",
    'custom_button__include_client_email' => "Включить адрес электронной почты клиента",
    'custom_button__include_client_id' => "Включить ID клиента",
    'custom_button__include_client_pname' => "Включить контактное имя клиента",
    'custom_button__include_domain_id' => "Включить ID подписки, домена и псевдонима домена",
    'custom_button__include_domain_id_powerUser' => "Включить ID подписки, домена и псевдонима домена",

    'custom_button__include_domain_name' => "Включить имя основного домена",
    'custom_button__include_ftp_user' => "Включить имя пользователя FTP",
    'custom_button__include_ftp_pass' => "Включить пароль FTP",
    'custom_button__internal_open' => "Открыть ссылку в Plesk",
    'custom_button__text' => "Название кнопки",
    'custom_button__url' => "URL-адрес",

    'custom_button__not_image' => 'Этот файл не является изображением.',
    'custom_button__big_image' => 'Размер файла не должен превышать 100 Кб.',
    'custom_button__failed_copy_image' => 'Невозможно скопировать файл: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'В режиме Power User нельзя восстановить резервную копию, созданную в другом режиме',
    '__unknown_network_interface' => 'Неизвестный сетевой интерфейс',

    'init_conf__ip_address' => 'IP-адрес',

    //Confirmation page
    'bt_confirm' => 'Подтвердить',
    'b_confirm' => 'Подтвердите, что вы являетесь владельцем этих сайтов.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Настройки выделенного пула IIS-приложений выставлены в соответствии с глобальной политикой безопасности (конфигурация изоляции сайта).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Настройки выделенного пула IIS-приложений выставлены в соответствии с глобальными настройками производительности на сервере.',

    '__current' => 'Текущий',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Свойства пользователя обновлены.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Вы использовали почти все домены, входящие в вашу лицензию Plesk (90% или более).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Вы использовали почти все домены',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Вы использовали почти все сайты Presence Builder, входящие в вашу лицензию Plesk (90% или более).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Вы использовали почти все сайты Presence Builder.',
    'promo__button_hide' => 'Скрыть',
    'promo__button_next' => 'Далее >>',
    'promo__button_prev' => '<< Назад',
    'promo__button_license' => 'Обновить лицензию',

    'promo__google_integration_title' => 'Интеграция с сервисами Google',
    'promo__google_integration' => 'Настройте интеграцию с сервисами Google, такими как AdSense, Google Apps и Инструменты для веб-мастеров.',
    'promo__google_integration_button' => 'Настроить',

    'promo__button_learn_more' => 'Подробнее',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Вы можете настроить параметры интерфейса и брендинга с помощью персональных тем. Инструкции по персонализации тем Plesk доступны здесь: %1.',
    'panel_branding__description_link' => 'следующем документе',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Извлечь файлы',
    'b_filemanager__extract' => 'Извлеките файлы из выбранных архивов в текущую папку. Учтите, что если имена файлов в архиве содержат национальные символы, после извлечения они могут отображаться неверно.',
    'filemanager_error_extracting_files' => 'При извлечении файлов из архива произошла ошибка: %1',
    'filemanager_no_archive_files_specified' => 'Укажите архивы, которые вы хотите распаковать.',
    'filemanager_not_zip_archive_specified' => 'Невозможно распаковать %1 — это не ZIP-архив.',
    'filemanager_files_successfully_extracted' => 'Файлы извлечены из архива.',
    'filemanager_error_file_download' => 'Скачать файл не удалось: %1',
    'filemanager__user_poolgrp' => 'Группа пулов приложений',

    'loading' => 'Загрузка...',
    'bt_create_archive' => 'Добавить в архив',
    'filemanager__pack' => "Путь к архиву: %1",
    'filemanager__archive_name' => 'Имя файла архива',
    'filemanager__empty_filename' => 'Пожалуйста, введите имя файла архива.',
    'filemanager_archive_created' => 'Архив успешно создан.',
    'filemanager_error_creating_archive' => 'Не удалось создать архив: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Эта запись будет конфликтовать с записью AAAA зоны.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-сервер не поддерживает IPv6-адреса.)",
    'cmd_dns__glue_dns_record_conflict' => 'Эта запись будет конфликтовать со связующей записью зоны \'%1\'.',
    '__ftp_ipv6_not_supported' => "(FTP-сервер не поддерживает IPv6-адреса.)",
    '__ipv6_not_supported' => 'IPv6 не поддерживается.',
    'mail__ipv6_not_supported' => 'IPv6 не поддерживается почтовым сервером.',
    'mail__relay_while_list_ipv6_not_supported' => 'Белый список на основе ретранслятора IPv6 не поддерживается почтовым сервером.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Значение маски должно быть кратно 16.',
    'mail__ip_or_mask_is_invalid' => 'Неверный IP-адрес или маска.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Перенаправление на IPv6-адреса не поддерживается.',
    'sa__invalid_trusted_networks' => 'Неверно указаны надежные сети: %1',
    'dns_add__enter_ipv6_address' => "IPv6-адрес",
    'license_trial_days_left' => 'Ваша копия Plesk использует пробную лицензию, которая истечет через %1 дней.',
    'excl_ipv6_num' => 'Выделенный IPv6-адрес',
    '__ip_mask' => "Маска подсети",
    '__ipv4_addr' => 'IPv4-адрес',
    '__ipv6_addr' => 'IPv6-адрес',
    'template__num_excl_ipv6s' => 'Предоставить выделенные IPv6-адреса этому реселлеру',
    'anonftp__exclusive_ipv4_required' => 'Для работы анонимного FTP необходим выделенный IPv4-адрес.',
    'anonftp__ipv4_already_used' => 'Невозможно настроить анонимный FTP для этого сайта, так как он уже настроен на другом домене с таким же IPv4-адресом.',


    'restart__kav' => "Антивирус Касперского",
    '__view_migration_log_detailed_info' => 'Смотреть журнал',

    'chown__ip_address_warn' => 'Перед сменой владельца подписки нужно сначала выбрать для нее новый IP-адрес.',
    'chown__no_ip_address' => 'Нет',
    'chown__no_ipv4_address' => 'Не найдено ни одного IPv4-адреса',
    'chown__no_ipv6_address' => 'Не найдено ни одного IPv6-адреса',
    'chown__domain_exclude_already_owned_by_client' => 'Подписка %1 уже принадлежит этому пользователю.',
    'chown__error_ip_absent_in_ip_pool' => 'IP-адрес %1 не найден в пуле IP-адресов указанного пользователя.',
    'chown__error_ip_not_exist' => 'IP-адрес с кодом \'%1\'\\ не существует.',
    'chown__error_domain_ip_not_selected' => 'Нужно выбрать хотя бы один IP-адрес для домена %1. Проверьте значения, выбранные для сопоставления IP-адресов.',

    '__new_passwd_single' => "Пароль",
    '__confirm_passwd_single' => "Подтверждение пароля",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Неверный IPv6-адрес или маска: IP-адрес должен быть индивидуальным.',

    '__subscriptions' => 'Подписки',

    '__owned_by_reseller' => 'принадлежит реселлеру',
    '__owned_by_provider' => 'принадлежит провайдеру',

    'service_plan__anonymous' => 'Персональный',
    'subscription_not_locked__change_limits_warning' => 'Эта подписка не заблокирована: при синхронизации с тарифным планом ограничения на расход ресурсов будут изменены.',
    'subscription_not_locked__change_permissions_warning' => 'Эта подписка не заблокирована: при синхронизации с тарифным планом права будут изменены.',

    'subscription__conflict_resolution_policy' => 'Политика разрешения конфликтов',
    'subscription__conflict_resolution_policy_lock' => "Заблокировать подписку",

    'backup__list__backup_warnings' => 'Предупреждения',
    'backup__list__backup_info' => 'Информация',
    'backup__restore__object_reseller_template' => 'Шаблон реселлера',
    'backup__restore__object_domain_template' => 'Шаблон домена',

    'ui__client/permissions_readonly__title' => 'Права',
    'ui__client/permissions_readonly__short-title' => 'Права',

    'subscription__unable_lock_anonymous' => 'Эта подписка не привязана к тарифному плану и не может быть разблокирована.',
    'subscription__unable_sync_anonymous' => 'Эта подписка не привязана к тарифному плану и не может быть синхронизирована.',
    'subscription__unable_sync_locked' => 'Эта подписка заблокирована и не может быть синхронизирована.',
    'subscription__locked' => 'Подписка заблокирована.',
    'component_name__urlrewrite' => "URL Rewrite",
    '__quantity' => 'Количество',
    'hst__www_root_dir_absent' =>  'Предупреждение: указанная корневая папка не существует.',
    'object_creation__domain_is_not_a_webspace' => 'Этот объект может быть создан только в подписке.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Эта подписка содержит сайты и не может быть удалена или переведена на другой тип хостинга.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Ошибка: Не удалось обновить IP-адрес. Дополнительным доменам невозможно присвоить IP-адреса, не присвоенные главному домену подписки.',
    'domain_plan__unable_change' => 'Невозможно изменить тарифный план: %1.',
    'domain_plan__different_hosting_type' => 'Текущий тип хостинга не совпадает с типом хостинга, указанным в тарифном плане.',
    'domain_plan__addon_text' => 'Дополнительный план',
    'domain_plan__addon_description' => 'Дополнительные планы служат для добавления новых услуг в хостинг-планы.',
    'asp_net__managed_runtime_version' => 'Версия управляемой среды выполнения ASP.NET',
    'plan__can_not_change_hosting_type' => 'Тип хостинга не может быть изменен при редактировании плана.',
    'plan__apply_problems' => 'План не был применен из-за проблем со следующей функциональностью: %1',
    'plan_save__subscription_update_problem' => 'Не удалось применить изменения к %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Подписка приостановлена до завершения резервного копирования или восстановления. Пожалуйста, повторите попытку позднее.",
    '__login_incorrect_plain_shadow_password' => 'Неверный пароль администратора. Пожалуйста, используйте параметры доступа системного администратора (root) или укажите правильный пароль. Чтобы узнать, как получить пароль, смотрите файл /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Вы не можете отправить IP-адрес, который вам не принадлежит',

    'dns__dns_zone_not_synchronized' => 'Зона DNS была изменена. Если вы хотите применить изменения, внесенные в шаблон DNS, к этой зоне, нажмите кнопку \'Применить изменения шаблона DNS\' на этой странице или выберите опцию \'Применить изменения ко всем зонам\' в Панели управления сервером > Инструменты и настройки > Настройки шаблона DNS > Применить изменения шаблона DNS.',
    'dns__dns_zone_synchronize_link' => 'Нажмите',
    'dns__dns_zone_synchronize_done' => 'Зона DNS успешно синхронизирована.',

    'dns__dns_zone_template_error' => 'При синхронизации зон DNS с шаблоном зоны DNS возникли ошибки.%1',

    'dns__soa_rname_type_owner' => 'Адрес электронной почты владельца сайта',
    'dns__soa_rname_type_domain' => 'Адрес электронной почты домена',
    'dns__soa_rname_type_external' => 'Внешний адрес электронной почты',
    'dns__soa_rname_enforce_email' => 'Запретить изменение адреса электронной почты RNAME для отдельных доменов',
    'dns__soa_rname_label' => 'Электронная почта (RNAME)',
    'dns__soa_rname_hint' => 'Адрес электронной почты лица, ответственного за зону DNS домена. Возвращается сервером DNS в ответ на запросы SOA.',

    'dns__dns_zone_soa_sync_title' => 'Переопределить настройки SOA для всех существующих доменов',
    'dns__dns_zone_soa_sync_legend' => 'Требуется подтверждение',
    'dns__dns_zone_soa_sync_text' => 'Обновить записи SOA всех доменов, применив к ним изменения шаблона SOA?',

    'cu_db__repair_mysql_dbus' => "Восстановить пароли пользователей MySQL. Эта операция необходима, если вы обновились до Plesk 11 с более ранней версии.",

    'scheduled_backup_settings__start_at_hint' => 'Интервал проверки запланированных задач резервного копирования составляет 15 минут. Если вы хотите, чтобы резервное копирование начиналось в определенное время, запланируйте его как минимум на 15 минут ранее этого времени.',
    'cu_scheduled_backup_comment' => 'Запланированное резервное копирование',
    'cu_scheduled_backup_error' => 'В процессе создания резервной копии произошла ошибка: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Во время создания резервной копии по расписанию произошла ошибка.',
    'cu_scheduled_backup_mail_message' => "%1\nТочка входа Plesk: %2\n\nСледующие ошибки произошли во время создания резервной копии по расписанию:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Ежечасное резервное копирование',
    'cu_scheduled_backup_daily' => 'Ежедневное резервное копирование',
    'cu_scheduled_backup_weekly' => 'Еженедельное резервное копирование',
    'cu_scheduled_backup_monthly' => 'Ежемесячное резервное копирование',
    'cu_scheduled_backup_comment_backup_all' => '%1. Все настройки и контент.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Все настройки и контент, кроме почтовых сообщений.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Только настройки и почтовые сообщения.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Все настройки и контент, кроме пользовательских баз данных.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Все настройки и контент, кроме пользовательских файлов.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Только настройки и пользовательские базы данных.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Только настройки и пользовательские файлы',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Настройки домена.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Хранение запланированных резервных копий в удаленном облачном хранилище является дополнительной функцией. Свяжитесь со своим хостинг-провайдером, чтобы ее разблокировать.',

    'i_backup_invalid_file' => 'Этот файл не является резервной копей. Невозможно восстановить данные из этого файла. Для просмотра подробностей щелкните по имени резервной копии.',

    'ui__server/migration/download-agent__short-title' => 'Скачать Агент миграции и переноса',
    'ui__server/migration/download-agent__title' => 'Скачать Агент миграции и переноса',
    'ui__server/migration/download-agent__description' => 'Скачайте последнюю версию Агента миграции и переноса с сайта Plesk.',

    'filemanager_resulting_archive_exists' => 'Файл %1 уже существует в папке назначения.',

    'agent_unable_to_connect' => 'Подключиться к агенту по адресу \'%2\' не удалось. Пожалуйста, убедитесь, что агент установлен и запущен, а сервер \'%2\' доступен для подключения.',
    'agent_test_connection_failed' => 'Подключиться к агенту по адресу \'%2\' не удалось.',

    'agent_unable_to_resolve_host' => 'Найти удаленный сервер \'%1\' не удалось. Пожалуйста, убедитесь, что этот сервер доступен для подключения.',
    'agent_unknown_curl_error' => 'Во время подключения к агенту по адресу \'%2\' произошла ошибка \'%1\'.',
    'agent_unexpected_htp_code' => 'В ответ на HTTP-запрос к агенту по адресу \'%2\' получен недопустимый HTTP-код \'%1\'.',
    'agent_unable_to_auth' => 'Выполнить авторизацию на сервере \'%1\' не удалось. Для устранения этой проблемы, пожалуйста, следуйте инструкциям на странице http://kb.plesk.com/ru/116606.',
    'agent_internal_server_error' => 'Во время выполнения команды на удаленном сервере \'%1\' произошла внутренняя ошибка.',
    'agent_response_is_empty' => 'В ответ на HTTP-запрос к агенту по адресу \'%1\' получен пустой ответ.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Не удалось найти Агент миграции и переноса в локальном кэше. Чтобы устранить эту неисправность, пожалуйста, откройте Менеджер миграции и переноса еще раз.',

    '__hosting_webdeploy' => "Публикация с помощью инструмента веб-развертывания",
    'cu_domain__webdeploy' => "Публикация с помощью инструмента веб-развертывания (по умолчанию: %1)",
    'cu_dom_tpl__webdeploy' => "Публикация с помощью инструмента веб-развертывания (по умолчанию: %1)",
    'cu_subdomain__webdeploy' => "Публикация с помощью инструмента веб-развертывания (по умолчанию: %1)",
    'webdeploy__not_installed' => "Инструмент веб-развертывания Microsoft Web Deploy не установлен на сервере",
    'webdeploy__forced_by_site_isolation' => "Не удалось изменить настройки публикации: у вас недостаточно прав для переопределения глобальных настроек безопасности. Обратитесь к своему провайдеру.",



    'backup__restore_options__admin__server_configuration_license' => 'Ключ лицензии',
    'migration_start_migrate_server_license' => 'Перенести ключ лицензии',

    'defaultcomponents__delegation_rule_not_exist' => '(необходимое правило делегирования \'appPoolPipeline, appPoolNetFx\' не существует)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Эта резервная копия была создана администратором.',
    'i_backup_created_by_reseller' => 'Эта резервная копия была создана реселлером.',
    'i_backup_created_by_client' => 'Эта резервная копия была создана клиентом.',

    'migration__object_exists_on_target_host' => '(уже существует на целевом сервере)',

    '__customers_total' => 'Всего по клиентам',
    '__resellers_total' => 'Всего по реселлерам',
    '__reseller_total' => 'Всего по реселлеру',


    'cu_cl_pref__manage_website_maintenance' => 'Доступ к дополнительным операциям: копирование сайтов',
    'cu_cl_pref__manage_protected_dirs' => 'Управление запароленными папками',
    'cu_cl_pref__manage_mail_settings' => 'Возможность менять почтовые настройки',


    'cu__command_update_php_settings' => 'Обновляет настройки PHP.',
    'cu__php_settings_option' => 'Задает путь к файлу с настройками PHP.',

    'cu__additional_php_settings_option' => 'Укажите путь к файлу с дополнительными директивами PHP.',
    'cu__command_show_php_settings' => 'Показывает текущие настройки PHP.',
    'cu__general_settings' => 'Общие настройки:',
    'cu__performance_settings' => 'Настройки производительности:',
    'cu__php_fpm_settings' => 'Настройки PHP-FPM:',
    'cu__additional_directives' => 'Дополнительные директивы:',

    'php_settings_permission_required' => 'Управление общими настройками PHP',
    'php_settings_performance_permission_required' => 'Управление настройками производительности хостинга',
    'php_settings_customized' => 'Настройки PHP изменены.',
    'php_settings_synchronized_with_plan' => 'Настройки PHP должны быть синхронизированы с планом.',
    'phosting__unknown_shell_type' => 'Недоступная оболочка',

    'login_up__access_denied_subscription_deleted' => 'Доступ запрещен: ваша подписка была удалена.',

    'role_restricted_to_subscription' => '(переносится с подпиской: %1)',

    'filemanager__extract' => "Извлечь файлы в: %1",

    'cu__license_command_check_installed_license' => 'Проверить действительность установленного ключа лицензии (если ключ действителен, возвращает код завершения 0, если недействителен — 1)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Управляйте своим сервером Plesk с помощью мобильных устройств (BlackBerry, iPhone и Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Получайте важную информацию о своих серверах Plesk в любое время и в любом месте с помощью мобильного устройства (BlackBerry, iPhone, Android).',
    'promo__mobile_button' => 'Подробнее',

    'ui__server/migration/video__short-title' => 'Видеоуроки',
    'ui__server/migration/video__title' => 'Смотреть видеоуроки',
    'ui__server/migration/video__description' => 'Смотреть видеоуроки.',

    'subDomainNameHint' => 'Чтобы создать шаблон субдомена, введите * в качестве имени субдомена. Посетители сайта будут перенаправляться на этот субдомен независимо от того, какое имя субдомена они введут в браузере.',
    'subdomains__wildcard_name_invalid' => "Недопустимое имя субдомена. Оно может включать только буквы, цифры, дефисы (-) и звездочки (*).",
    'subdomains__name_invalid' => "Недопустимое имя субдомена. Оно может включать только буквы, цифры и дефисы (-).",

    'domain__wildcard_no_www_prefix' => 'Префикс www нельзя использовать для шаблонов субдоменов.',

    '__service_title__milter' => "Почтовый фильтр Plesk Postfix",
    '__service_description__milter' => "Почтовый фильтр Plesk Postfix",
    '__milter' => "Почтовый фильтр Postfix",
    'restart__milter' => "Почтовый фильтр Plesk (%1)",
    'restart__pop3' => "Сервер Courier POP3",
    'restart__pop3s' => "Сервер Courier POP3 с поддержкой SSL/TLS",
    'restart__imap' => "Сервер Courier IMAP",
    'restart__imaps' => "Сервер Courier IMAP с поддержкой SSL/TLS",
    'restart__authdaemon' => "Программа аутентификации Courier IMAP",
    'restart__imap-pop3' => "IMAP- и POP3-сервер Dovecot",


    'addon_packages_not_supported' => 'Дополнения для веб-приложений в формате APS не поддерживаются.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Не удалось назначить IP-адрес этому домену автоматически. Пожалуйста, укажите IP-адрес с помощью опции -ip.',

    'plesk_key__mb_accounts' => 'Учетные записи пользователей (реселлеры и клиенты) в Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Зона DNS субдомена',
    'actionlog__site_subdomain_dns' => 'Зона DNS субдомена в дополнительном домене обновлена',

    // PfW only
    'actionlog__event_site_create' => 'Домен создан',
    'actionlog__event_site_delete' => 'Домен удален',
    'actionlog__event_site_update' => 'Домен обновлен',

    'actionlog__event_site_status_update' => 'Статус домена обновлен',
    'actionlog__event_site_dns_update' => 'Зона DNS домена обновлена',
    'actionlog__event_site_guid_update' => 'Глобальный уникальный идентификатор домена обновлен',

    'actionlog__event_site_subdomain_create' => 'Субдомен создан',
    'actionlog__event_site_subdomain_delete' => 'Субдомен удален',
    'actionlog__event_site_subdomain_update' => 'Субдомен обновлен',

    'actionlog__event_site_alias_create' => 'Псевдоним домена создан',
    'actionlog__event_site_alias_delete' => 'Псевдоним домена удален',
    'actionlog__event_site_alias_update' => 'Псевдоним домена обновлен',

    'actionlog__event_site_alias_dns_update' => 'Зона DNS псевдонима домена обновлена',
    'actionlog__event_subdomain_dns_update' => 'Зона DNS субдомена в домене по умолчанию обновлена',
    'actionlog__event_site_subdomain_dns_update' => 'Зона DNS субдомена обновлена',
    // End of PfW only

    'win_policy__bad_password' => 'Проверка не пройдена. Неверный пароль.',
    'win_policy__password_too_short' => 'Проверка не пройдена. Слишком короткий пароль.',
    'win_policy__password_too_long' => 'Проверка не пройдена. Слишком длинный пароль.',
    'win_policy__password_not_complex_enough' => 'Проверка не пройдена. Ваш пароль недостаточно надежен и не соответствует требованиям политики паролей. Надежные пароли должны содержать как минимум следующее: восемь символов; один символ в верхнем или нижнем регистре; три цифры и один специальный символ (!, @, #, $, %, ^, &, *, ?, _, ~) или одну цифру и два специальных символа.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Не удается обновить лицензию.',


    'filemanager__error_path_is_not_allowed' => 'Путь запрещен',
    'filemanager__error_path_is_invalid' => 'Путь неправилен',
    'filemanager__error_path_not_found' => 'Путь не найден',
    'filemanager__error_path_already_exists' => 'Путь уже существует',
    'filemanager__error_access_is_denied' => 'Доступ запрещен',
    'filemanager__error_directory_not_empty' => 'Папка не пуста',
    'filemanager__error_sharing_violation' => 'Нарушение процедуры совместного использования',
    'filemanager__error_not_same_device' => 'Путь назначения находится на другом устройстве',
    'filemanager__binary_data_access' => 'Возможно, это бинарный файл. Открыть его в любом случае?',
    'filemanager__unable_to_resolve_realpath' => "Невозможно найти файл %1 по указанному пути",
    'filemanager__access_to_realpath_denied' => "Запрещен доступ по realpath: ссылка %1 на файл %2.",
    'bt_exit' => 'Выйти',

    'filemanager__chdir_error__' => "Невозможно сменить папку на %1: %2",
    'filemanager__chmod_dir' => "Изменить права доступа к папке %1",
    'filemanager__chmod_error__' => "Невозможно изменить права на файл %1: %2",
    'filemanager__chmod_file' => "Изменение прав на файл %1",
    'filemanager__copy_error__' => "Невозможно скопировать %1 в %2: %3",
    'filemanager__copy_move' => "Копирование/перемещение файлов из %1",
    'filemanager__count_size__' => 'Размер выделенных элементов: %1',
    'filemanager__count_size_error__' => 'Нельзя подсчитать размер для %1: %2',
    'filemanager__create_dir' => "Создание папки",
    'filemanager__create_dir_error__' => "Невозможно создать папку %1: %2",
    'filemanager__dir_not_exists' => "Папка %1 не существует.",
    'filemanager__dirname' => "Имя папки",
    'filemanager__filename' => "Имя файла",
    'filemanager__is_no_such' => "Не удалось найти папку или файл с именем %1",
    'filemanager__empty_selection' => "Не выбрано ни одного файла. Пожалуйста, выберите файл.",
    'filemanager__file_exists' => "Файл %1 уже существует.",
    'filemanager__move_error__' => "Невозможно переместить %1 в %2: %3",
    'filemanager__new_dir' => "Имя папки",
    'filemanager__not_allowed' => "Вам запрещено менять права доступа к этому файлу.",
    'filemanager__r_perm_dir' => "Просмотр папки",
    'filemanager__r_perm_file' => "Чтение данных",
    'filemanager__remove' => "Удаление файлов из %1",
    'filemanager__remove_error__' => "Невозможно удалить файл %1: %2",
    'filemanager__rename_dir' => "Переименовать папку %1",
    'filemanager__rename_error__' => "Невозможно переименовать %1 в %2: %3",
    'filemanager__rename_file' => "Переименование файла %1",
    'filemanager__set_win_permissions_dir' => "Установка прав доступа к папке %1",
    'filemanager__set_win_permissions_file' => "Установка прав на файл %1",
    'filemanager__touch_confirm' => "Вы действительно хотите изменить временную метку выбранных файлов?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Данный файл невозможно открыть, или не поддерживается формат данного файла.',
    'filemanager__upload_error__' => "Невозможно загрузить %1 в %2: %3",
    'filemanager__upload_file' => "Загрузить файл",
    'filemanager__upload_file_src' => "Путь к файлу",
    'filemanager__username' => "Пользователь",
    'filemanager__w_perm_dir' => "Создавать файлы",
    'filemanager__w_perm_file' => "Записывать данные",
    'filemanager__x_perm_dir' => "Обзор папки",
    'filemanager__x_perm_file' => "Исполнять файл",
    'filemanager__max_image_size_exceeded' => 'Невозможно показать изображение. Размер изображения не может быть больше %2 байт',

    '__fastcgi_unix_support' => 'Поддержка FastCGI',

    'dns__subdomain_dns_zone_parent' => 'DNS-записи этого субдомена хранятся в родительской зоне DNS. Вы можете изменить родительскую зону %1 или создать для этого субдомена отдельную зону.',
    'dns__subdomain_dns_zone_parent_link' => 'здесь',
    'dns__no_dns_zone' => 'Этому домену не назначено ни одной зоны DNS. Для управления зоной DNS своего домена нажмите \'Восстановить настройки по умолчанию\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Не удалось включить зону субдомена, так как в зоне его родительского домена для него существует запись CNAME.',

    '__hosting_write_modify' => 'Дополнительные права на запись/редактирование',

    'aspdotnet__group_framework_version' => "Версия Framework",
    'aspdotnet__param_version' => "Версия",

    'bt_restore_default' => "Сбросить",
    'b_aspdotnet' => 'Редактировать настройки ASP.NET.',
    'b_aspdotnet__restore_default' => 'Восстановить настройки ASP.NET по умолчанию.',
    'b_aspdotnet__restore_wdir_default' => "Восстановить настройки ASP.NET родительской папки для этого виртуальной папки.",
    'b_aspdotnet__restore_default_disabled' => 'Восстановление конфигурации ASP.NET по умолчанию невозможно: конфигурация ASP.NET повреждена на уровне сервера или родительской папки.',
    'b_autoinstaller' => 'Обновить Plesk или его компоненты.',
    'b_autoinstaller_configure' => 'Настройки обновления.',
    'b_autoinstaller_install' => 'Установить выбранные компоненты.',

    '__iis_app_pool__use_dedicated' => 'Выделенный пул приложений IIS',
    '__iis_app_pool__use_dedicated_addons' => 'Выделенный пул приложений IIS для каждого сайта',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Включить 32-битные приложения',
    '__iis_app_pool__load_user_profile' => 'Загружать профиль пользователя',
    'bt_iis_app_pool' => "Пул приложений IIS",

    'performance__cpu_usage' => 'Максимальная загрузка ЦП (%)',
    'performance__cpu_usage_action' => 'Действие при превышении ограничения',
    'performance__cpu_usage_interval' => 'Период ограничения (минут)',
    'performance__cpu_usage_action_not_supported' => 'Указанное действие не поддерживается веб-сервером.',

    'performance__idle_timeout_action_not_supported' => 'Указанное действие при таймауте не поддерживается веб-сервером.',
    'performance__max_worker_processes' => 'Максимальное количество рабочих процессов',
    'performance__idle_timeout' => 'Таймаут простоя (минут)',
    'performance__idle_timeout_action' => 'Действие при таймауте',
    'performance__recycling_by_time' => 'Интервал перезапуска (минут)',
    'performance__recycling_by_requests' => 'Перезапускать, когда достигнуто максимальное количество запросов',
    'performance__recycling_by_virtual_memory' => 'Перезапускать, когда достигнут максимальный объем виртуальной памяти',
    'performance__recycling_by_private_memory' => 'Перезапускать, когда достигнут максимальный объем собственной памяти',
    'performance__managed_pipeline_mode' => 'Управляемый конвейерный режим',
    'performance__managed_pipeline_mode_not_supported' => 'Указанный режим не поддерживается веб-сервером.',

    'iis_app_pool' => 'Управлять пулом приложений IIS.',
    'b_iis_app_pool' => 'Управлять пулом приложений IIS.',
    'iis_app_pool_cl_dom' => 'Управлять пулом приложений IIS.',

    'i_webdirs_not_protected' => 'Папка не защищена.',
    'i_webdirs_protected' => 'Папка защищена.',
    'i_webdirs_manage_protection' => 'Управление защитой.',
    'i_webdirs_open' => 'Открыть папку/файл в браузере.',
    'i_webdirs_preferences_disabled' => 'Эта папка не является виртуальной папкой.',
    'i_webdirs_permissions' => 'Управлять правами.',
    'i_webdirs_permissions_disabled' => 'Управление правами доступа к папкам недоступно.',
    'i_webdirs_type_dir' => 'Физическая папка',
    'i_webdirs_type_vdir' => 'Виртуальная папка',
    'i_webdirs_browse' => 'Просмотр содержимого папки.',
    'i_webdirs_preferences' => 'Управление настройками веб-папок.',

    'l_webdirslist_type' => 'Сортировать папки по типу.',
    'l_webdirslist_protected' => 'Сортировать папки по статусу защиты.',
    'l_webdirslist_name' => 'Сортировать папки по имени.',

    'b_webdirslist_remove' => 'Удалить выбранные виртуальные папки.',
    'b_webdirslist_search' => 'Введите слово для поиска и нажмите, чтобы найти виртуальные папки.',
    'b_webdirslist_show_all' => 'Показать все папки.',

    'l_webdirerrordocslist_code' => 'Сортировать страницы ошибок по номеру ошибки.',
    'l_webdirerrordocslist_name' => 'Сортировать страницы ошибок по описанию.',
    'l_webdirerrordocslist_type' => 'Сортировать страницы ошибок по типу.',
    'l_webdirerrordocslist_location' => 'Сортировать страницы ошибок по расположению.',

    'b_webdirerrordocslist_search' => 'Введите условие поиска и нажмите на кнопку, чтобы найти страницы ошибок.',
    'b_webdirerrordocslist_remove' => 'Удалить выбранные страницы ошибок.',
    'b_webdirerrordocslist_show_all' => 'Показать все страницы ошибок.',

    'l_webdirmimetypeslist_name' => 'Сортировать типы MIME по расширению',
    'l_webdirmimetypeslist_content' => 'Сортировать типы MIME по содержанию',

    'b_webdirmimetypeslist_remove' => 'Удалить выбранные типы MIME.',
    'b_webdirmimetypeslist_search' => 'Введите комбинацию для поиска и нажмите, чтобы найти типы MIME.',
    'b_webdirmimetypeslist_show_all' => 'Показать все типы MIME.',

    'b_webdir_preferences' => "Настройки виртуальной папки.",
    'b_webdir_permissions' => "Права доступа к виртуальной папке.",
    'b_webdir_permissions_disabled' => "Управление правами доступа к папкам недоступно.",
    'b_to_webdirs' => 'Вернуться к управлению папками.',
    'b_to_webdir_mime_types' => 'Вернуться к управлению типами MIME.',
    'b_to_webdir_error_docs' => 'Вернуться к управлению страницами ошибок.',
    'b_to_webdir_protection' => 'Вернуться к управлению защитой виртуальных папок.',

    'webdirs__title' => 'Виртуальная папка %1',
    'webdirs__preferences_title' => 'Настройки виртуальной папки',
    'webdirs__list_legend' => 'Виртуальные папки',
    'webdirs__list_type' => 'Тип',
    'webdirs__list_protected' => 'П',
    'webdirs__list_name' => 'Имя',
    'webdirs__list_header' => 'Элементов: %1',
    'webdirs__tabs_general' => 'Общие',
    'webdirs__tabs_mime_types' => 'Типы MIME',
    'webdirs__tabs_error_docs' => 'Страницы ошибок',

    'webdirs__tabs_permissions' => 'Права',
    'webdir__remove_vdirs' => 'Следующие виртуальные папки будут удалены:',
    'webdir__remove_mime_types' => 'Следующие типы MIME будут удалены:',
    'webdir__mime_types_title' => 'Типы MIME',
    'webdir__protection_disable_confirm' => 'Вы действительно хотите снять защиту с этой папки?',
    'webdir__protect_title' => 'Пользователи защищенного URL',
    'webdirs__permissions_title' => 'Права доступа к виртуальной папке',
    'webdirs__browse_content_permission_denied' => 'Вам запрещено просматривать содержимое этой папки.',
    'error_doc__list_code' => 'Ошибка',
    'error_doc__list_code_description' => 'Описание',
    'error_doc__list_type' => 'Тип',
    'error_doc__list_location' => 'Расположение',
    'error_doc__code' => 'Ошибка',
    'error_doc__type' => 'Тип',
    'error_doc__type_file' => 'Файл',
    'error_doc__type_url' => 'URL-адрес',
    'error_doc__location' => 'Расположение',
    'error_doc__legend' => 'Сообщение об ошибке',
    'error_doc__edit_title' => 'Редактирование сообщения об ошибке',
    'error_doc_erorr_invalid_url_location' => 'Неверный URL-адрес. Пожалуйста, укажите правильный URL.',
    'error_doc_erorr_invalid_file_location' => 'Неверный путь к файлу. Пожалуйста, укажите правильный путь.',
    'error_doc__type_default' => 'По умолчанию',

    'webdirs__tabs_protection' => 'Защита',
    'pb_webdirs' => 'Виртуальные папки',

    'webdirs_remove_title' => 'Следующие виртуальные папки будут удалены:',
    'webdirs_mime_types_remove_title' => 'Следующие типы MIME будут удалены:',
    'webdirs_preferences_title' => 'Настройки виртуальной папки',
    'webdirs_permissions_title' => 'Особые права доступа к файлам и папкам',
    'webdi_protection_disable_confirm' => 'Вы уверены, что хотите отключить защиту виртуальной папки? Это приведет к удалению всех пользователей защищенной папки и ее настроек защиты.',
    'bt_protect' => 'Защитить',
    'bt_unprotect' => 'Снять защиту',
    'bt_show_additional_users' => 'Показать дополнительных пользователей',
    'bt_hide_additional_users' => 'Скрыть дополнительных пользователей',
    'error_doc__list_title' => 'Страницы ошибок',
    'error_doc__list_header' => 'Страницы ошибок',
    'error_doc__code_400' => 'Некорректный запрос',
    'error_doc__code_401' => 'Несанкционированный',
    'error_doc__code_401.1' => 'Ошибка авторизации',
    'error_doc__code_401.2' => 'Ошибка авторизации — не удалось войти из-за некорректной настройки сервера',
    'error_doc__code_401.3' => 'Нет доступа из-за таблицы управления доступом на ресурсе',
    'error_doc__code_401.4' => 'Ошибка авторизации — отказ при проверке прав доступа на фильтре',
    'error_doc__code_401.5' => 'Ошибка авторизации — отказ при проверке прав доступа в приложении ISAPI/CGI',
    'error_doc__code_401.7' => 'Ошибка авторизации — отказ из-за политики авторизации URL',
    'error_doc__code_403' => 'Запрещенный',
    'error_doc__code_403.1' => 'В доступе к исполнению файлов отказано',
    'error_doc__code_403.2' => 'В доступе к чтению отказано',
    'error_doc__code_403.3' => 'В доступе к записи отказано',
    'error_doc__code_403.4' => 'В доступе отказано — требуется SSL',
    'error_doc__code_403.5' => 'В доступе отказано — требуется SSL 128',
    'error_doc__code_403.6' => 'В доступе отказано — IP-адрес не принят',
    'error_doc__code_403.7' => 'В доступе отказано — отсутствует сертификат на стороне клиента',
    'error_doc__code_403.8' => 'Доступ к сайту запрещен',
    'error_doc__code_403.9' => 'Доступ запрещен — слишком много пользователей',
    'error_doc__code_403.10' => 'Доступ запрещен — некорректная конфигурация',
    'error_doc__code_403.11' => 'Доступ запрещен — смена пароля',
    'error_doc__code_403.12' => 'Доступ запрещен средством сопоставления',
    'error_doc__code_403.13' => 'Доступ запрещен — сертификат клиента недействителен',
    'error_doc__code_403.14' => 'Запрещено — Вывод папок запрещен',
    'error_doc__code_403.15' => 'Доступ запрещен — достигнуто максимально разрешенное число подключений',
    'error_doc__code_403.16' => 'Доступ запрещен — сертификат клиента не вызывает доверия или неправильно сформирован.',
    'error_doc__code_403.17' => 'Доступ запрещен — у сертификата клиента истек срок годности, либо сертификат еще не вступил в силу',
    'error_doc__code_403.18' => 'Доступ запрещен — невозможно выполнить запрос из этого пула приложений',
    'error_doc__code_403.19' => 'Доступ к скриптам CGI запрещен',
    'error_doc__code_403.20' => 'Доступ запрещен — не удалось выполнить вход',
    'error_doc__code_404' => 'Файл не найден',
    'error_doc__code_404.2' => 'Файл не найден — отказано в связи с политикой lockdown',
    'error_doc__code_404.3' => 'Файл не найден — отказано в связи с политикой MIMEMAP',
    'error_doc__code_405' => 'Метод запрещен.',
    'error_doc__code_406' => 'Недопустимый объект',
    'error_doc__code_407' => 'Требуется проверка подлинности прокси-сервером',
    'error_doc__code_412' => 'Сбой подготовки начальных условий',
    'error_doc__code_414' => 'Слишком длинный URI запроса',
    'error_doc__code_415' => 'Неподдерживаемый тип данных',
    'error_doc__code_500' => 'Внутренняя ошибка сервера',
    'error_doc__code_500.12' => 'Внутренняя ошибка сервера — приложение перезагружается',
    'error_doc__code_500.13' => 'Внутренняя ошибка сервера — сервер занят',
    'error_doc__code_500.15' => 'Внутренняя ошибка сервера — прямые запросы к GLOBAL.ASA запрещены',
    'error_doc__code_500.16' => 'Внутренняя ошибка сервера — ошибка доступа UNC',
    'error_doc__code_500.17' => 'Внутренняя ошибка сервера — не найдено хранилище авторизации URL',
    'error_doc__code_500.18' => 'Внутренняя ошибка сервера — невозможно открыть хранилище авторизации URL',
    'error_doc__code_500.19' => 'Внутренняя ошибка сервера — некорректные метаданные файла',
    'error_doc__code_500.100' => 'Внутренняя ошибка сервера — ошибка ASP',
    'error_doc__code_501' => 'Не поддерживается',
    'error_doc__code_502' => 'Неверный шлюз',
    'error_doc__code_503' => 'Служба временно недоступна',

    'mimetype__extension' => 'Расширение',
    'mimetype__content' => 'Содержимое',
    'mimetypeslist__title' => 'Типы MIME',
    'mimetypes__title' => 'Типы MIME',
    'mimetypes__select_to_remove' => 'Выберите типы MIME, которые вы хотите удалить.',
    'mimetypes__select_for_remove' => "Выберите типы MIME для удаления.",
    'mimetypes_remove__title' => 'Удалить тип MIME',
    'mimetype__legend' => 'Тип MIME',
    'mimetype_edit__title' => 'Изменить свойства типа MIME',
    'mimetype_edit__already_exists' => 'Для этого расширения тип MIME уже зарегистрирован.',
    'mimetype_edit__not_exists' => 'Такой тип MIME не существует.',
    'mimetype__content_type_other' => 'Указать...',

    'b_webdir_protection_enable' => 'Защитить URL папки паролем.',
    'b_webdir_protection_disable' => 'Сделать URL папки доступным для всех.',
    'b_webdir_protection_disabled' => 'Защита виртуальной папки отключена.',

    'b_pd_usr_create' => 'Нажмите, чтобы создать этого пользователя.',
    'php__changeversion_title' => "Выбрать версию PHP",
    'php__group_php_version' => "Версия РНР",

    'virtualdir__name' => 'Имя',
    'virtualdir__path' => 'Путь',
    'virtualdir__read' => 'Чтение',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Запись',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Доступ к исходному коду скрипта',
    'virtualdir__source_short' => 'С',
    'virtualdir__browse' => 'Просмотр папки',
    'virtualdir__browse_short' => 'Байт',
    'virtualdir__script_execute' => 'Права на выполнение',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Сохранять в журнале записи о посещении',
    'virtualdir__app_create' => 'Создать приложение',
    'virtualdir__app_create_short' => 'В',
    'virtualdir__auth_anon' => 'Включает анонимный доступ.',
    'virtualdir__auth_windows' => 'Включает аутентификацию Windows.',
    'virtualdir__auth_not_enabled' => 'Должен быть включен анонимный доступ или аутентификация Windows.',
    'virtualdir__require_ssl' => 'Принудительное использование SSL/TLS',
    'virtualdir__enable_default_doc' => 'Использовать документы по умолчанию',
    'virtualdir__default_doc' => 'Порядок поиска документов по умолчанию',
    'virtualdir__enable_parent_paths' => 'Разрешить использование родительских путей',
    'virtualdir__execute_in_mta' => 'Разрешить выполнение приложений в режиме MTA (многопоточное подразделение)',
    'virtualdir_create__title' => 'Создать виртуальную папку в %1',
    'virtualdir_edit__title' => 'Свойства виртуальной папки %1',
    'virtualdir_edit__legend' => 'Виртуальная папка',
    'virtualdir_edit__application_legend' => 'Настройки приложения',
    'virtualdir_edit__security_legend' => 'Безопасность папки',
    'virtualdir_edit__documents_legend' => 'Документы',
    'virtualdir_edit__list_legend' => 'Вложенные виртуальные папки',
    'virtualdir_error__path_not_in__' => 'Указан неверный путь.',
    'virtualdir_error__already_exists' => 'Папка с таким именем уже существует.',
    'virtualdir_root' => 'Виртуальные папки',
    'virtualdir_root__title' => 'Виртуальные папки',
    'virtualdir_root__list_legend' => 'Виртуальные папки',
    'virtualdir_se__none' => 'Нет',
    'virtualdir_se__script' => 'Только скрипты',
    'virtualdir_se__script_execute' => 'Скрипты и исполняемые файлы',
    'virtualdirs__title' => 'Виртуальные папки',
    'virtualdirs__path_not_exists' => 'Неверный путь.',
    'virtualdirs__select_for_remove' => "Выберите виртуальные папки, которые вы хотите удалить.",
    'virtualdirs_remove__title' => 'Удалить виртуальные папки',
    'virtualdirs_phys_dir_exist' => 'Папка с таким именем уже существует. Если вы продолжите, она станет недоступна. Продолжить?',
    'virtualdir_auto_create_dir' => "Создать физическую папку с таким же именем, как у виртуальной",

    'asp_max_default_text' => 'Определяется родительской папкой (%1 Кб)',
    'asp_max_default_text_site' => 'Определяется IIS (%1 Кб)',
    'asp_max_buffer_text' =>'Максимальный размер буфера ASP (Кб)',
    'asp_max_body_text' => 'Максимальный размер тела объекта в запросе ASP (Кб)',
    'asp_buffers_legend' =>'Настройки ASP',

    'asp_debug_default_text' =>'Определено родительской папкой',
    'asp_debug_default_text_site' =>'Определено IIS',
    'asp_client_debug_text' =>'Включить отладку скриптов ASP на стороне клиента',
    'asp_server_debug_text' =>'Включить отладку скриптов ASP на сервере',

    'webdirs__list_with_broken_dirs' => "Обнаружены виртуальные папки, привязанные к несуществующим физическим папкам.",
    'webdirs__vdir_physical_path_not_exist' => "Эта виртуальная папка привязана к несуществующей физической папке.",
    'webdirs__physical_path_not_exist' => "Указанный путь не существует.",

    'filemanager__new_dir_title' => 'Создать папку',
    'php__configuration_title' => "Конфигурация PHP",

    'permissions__title' => 'Настроить права доступа',
    'permissions__title_advanced' => 'Настройка расширенных прав доступа',
    'permissions__inherit_from_parent' => 'Наследовать от родительского объекта применимые к дочерним объектам права. Добавлять их к явно заданным здесь.',
    'permissions__replace_on_children' => 'Заменить права для всех дочерних объектов на заданные здесь значения.',
    'permissions__group_or_user_name' => 'Группы или пользователи',
    'permissions__Permissions_for' => 'Права для',
    'permissions__allow' => 'Разрешить',
    'permissions__deny' => 'Запретить',
    'permissions__FullControl' => 'Полный доступ',
    'permissions__Modify' => 'Изменить',
    'permissions__ReadAndExecute' => 'Чтение и выполнение',
    'permissions__ListFolderContents' => 'Просмотр содержания папки',
    'permissions__Read' => 'Чтение',
    'permissions__Write' => 'Запись',
    'permissions__ReadControl' => 'Права на чтение',
    'permissions__WriteControl' => 'Права на запись',
    'permissions__ExecuteControl' => 'Права на выполнения',
    'permissions__TraverseFolderOrExecuteFile' => 'Обзор папок / Выполнение файлов',
    'permissions__ListFolderOrRead' => 'Содержание папки / Чтение данных',
    'permissions__CreateFilesOrWrite' => 'Создание файлов / Запись данных',
    'permissions__CreateFoldersOrAppend' => 'Создание папок / Дозапись данных',
    'permissions__DeleteSubfoldersandFiles' => 'Удаление вложенных папок и файлов',
    'permissions__Delete' => 'Удалить',
    'permissions__ChangePermissions' => 'Изменить права',
    'permissions__TakeOwnership' => 'Смена владельца',
    'permissions__inherited_from' => 'Унаследовано от',
    'permissions__not_inherited' => '<не унаследовано>',
    'permissions__apply_to' => 'Применить к',
    'permissions__apply_onto' => 'Применять к:',
    'permissions__apply_onto1' => 'Только эта папка',
    'permissions__apply_onto2' => 'Только подпапки',
    'permissions__apply_onto3' => 'Эта папка и вложенные папки',
    'permissions__apply_onto4' => 'Только файлы',
    'permissions__apply_onto5' => 'Эта папка и файлы',
    'permissions__apply_onto6' => 'Вложенные папки и файлы',
    'permissions__apply_onto7' => 'Эта папка, вложенные папки и файлы',

    'filemanager__not_allowed_dir' => "Вам запрещено менять права доступа к этой папке.",

    'filemanager__allow' => "Разрешить",
    'filemanager__deny' => "Запретить",
    'filemanager__user_domusr' => 'Администратор сайта',
    'filemanager__user_webusr' => 'Веб-пользователь',
    'filemanager__user_admins' => 'Администраторы',
    'filemanager__user_system' => 'СИСТЕМА',
    'filemanager__user_aspnet' => 'Пользователь ASP.NET',
    'filemanager__user_poolusr' => 'Пользователь пула приложений',
    'filemanager__user_sysaccount' => 'Дополнительный системный пользователь',

    'bt_permissions_advanced' => 'Дополнительно',
    'b_permissions_advanced' => 'Нажмите, чтобы посмотреть или изменить особые права.',

    'hotlink-protection_invalid_friend_domain' => 'Неверное имя надежного домена.',
    'hotlink-protection_duplicate_friend_domain' => 'Повторяющееся имя надежного домена.',
    'hotlink-protection_invalid_extensions' => 'Расширения файлов содержат недопустимые символы.',

    'i_domain_alias_status_on' => 'Псевдоним домена включен.',
    'i_domain_alias_status_off' => 'Псевдоним домена отключен.',
    'i_domain_alias_status_with_parent' => 'Псевдоним домена отключен, так как отключен сам домен.',
    'i_domain_alias_turn_off' => 'Нажмите для отключения.',
    'i_domain_alias_turn_on' => 'Нажмите для включения.',
    'i_domain_alias_mail_on' => 'Почтовая служба включена для этого псевдонима домена.',
    'i_domain_alias_mail_off' => 'Почтовая служба отключена для этого псевдонима домена.',
    'i_domain_alias_mail_with_parent' => 'Почтовая служба отключена, так как этот псевдоним домена отключен.',
    'i_domain_alias_web_on' => 'Веб-служба включена для этого псевдонима домена.',
    'i_domain_alias_web_off' => 'Веб-служба отключена для этого псевдонима домена.',
    'i_domain_alias_web_with_parent' => 'Веб-служба отключена, так как этот псевдоним домена отключен.',
    'i_domain_alias_dns_on' => 'Служба псевдонимов DNS для этого псевдонима домена включена.',
    'i_domain_alias_dns_off' => 'Служба псевдонимов DNS для этого псевдонима домена отключена.',
    'i_domain_alias_dns_with_parent' => 'Синхронизация DNS с родительским доменом отключена, так как этот псевдоним домена отключен.',
    'i_domain_alias_seoRedirect_on' => 'Перенаправление с кодом HTTP 301 для этого псевдонима домена включено.',
    'i_domain_alias_seoRedirect_off' => 'Перенаправление с кодом HTTP 301 для этого псевдонима домена отключено.',
    'i_domain_alias_seoRedirect_with_parent' => 'Перенаправление с кодом HTTP 301 отключено, потому что этот псевдоним домена отключен.',

    'domain_alias__control_title' => 'Псевдоним домена %1',
    'domain_alias__control_info_legend' => 'Информация',
    'domain_alias__control_status_title' => 'С',
    'domain_alias__control_name_title' => 'Название услуги',
    'domain_alias__control_details_title' => 'Подробности',

    'domain_alias__invalid_values' => 'Указанное вами имя домена недействительно. Имена доменов могут состоять из букв, цифр и дефисов. Каждая часть имени домена между точками не должна превышать 63 символов.',
    'domain_alias__domain_already_exists' => "Неверный псевдоним домена %1. Домен %1 уже существует.",
    'domain_alias__www_prefix_domain_already_exists' => "Неверный псевдоним домена (www).%1. Такой псевдоним уже создан для домена %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Неверный псевдоним домена (веб-почта).%1. Такой псевдоним уже создан для домена %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Неверный псевдоним домена.%1. Такой псевдоним уже создан для домена %1.',
    'domain_alias__dns_record_already_exists' => 'Невозможно создать псевдоним домена %1, так как DNS-запись, указывающая на компьютер %1, уже существует.',
    'domain_alias__domain_alias_already_exists' => "Такой псевдоним домена уже существует.",
    'domain_aliases__mail_server_not_support_aliases' => 'Текущий почтовый сервер не поддерживает псевдонимы доменов. Псевдонимы доменов могут работать с ошибками.',
    'domain_alias__restrict_domain_creation' => 'Указанный псевдоним домена запрещен политикой сервера. Если этот псевдоним домена принадлежит вам, пожалуйста, обратитесь к своему хостинг-провайдеру.',
    'domain_alias__restrict_creation_with_www' => 'Пожалуйста, введите имя домена без префикса \'www\'. Префикс www для домена будет автоматически добавлен к конфигурации веб-сервера.',
    'domain_unable_to_set_name' => 'Неверное имя %1.',

    'domain_alias__domain_service_dns_disabled' => 'Этот домен обслуживается другим сервером DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Данный сервер DNS выполняет функции первичного сервера имен для этой зоны DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Данный сервер DNS выполняет функции вторичного сервера имен для этой зоны DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Почтовая служба включена для домена.',
    'domain_alias__domain_service_mail_disabled' => 'Почтовая служба выключена для домена.',
    'domain_alias__domain_service_mail_mx' => '%1 используется как почтовый сервер.',

    'domain_alias__service_seoRedirect_hint' => 'При попытке открыть URL-адрес псевдонима домена посетители будут перенаправляться на URL-адрес основного домена. Plesk использует код перенаправления HTTP 301, что позволяет избежать разделения поискового рейтинга между такими URL-адресами.',

    'bt_task_run_now' => 'Запустить',
    'ftp__read_perm' => "Чтение",
    'ftp__write_perm' => "Запись",

    'filemanager__upload_backup_file_hint' => 'Здесь вы можете загрузить резервные копии в хранилище Plesk. Максимальный размер файла составляет 2 Гб.',

    '__default_for_mssql' => 'по умолчанию для MS SQL',

    '__login_does_not_pass_validation' => "Неверное имя пользователя. Убедитесь, что оно удовлетворяет следующим требованиям: %1",
    '__login_allowed_symbols' => 'Вы можете использовать только буквенно-цифровые символы, точки, дефисы и подчеркивания. Первый символ должен быть буквой или цифрой.',

    'restart__nginx' => 'Обратный прокси-сервер (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Я хочу получать общую информацию и новости о продуктах Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Я хочу получать информацию, связанную с безопасностью, и другие технические уведомления от Plesk.",

    '__login_status_inactive' => 'Ваша учетная запись неактивна. Обратитесь к администратору Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Вы можете вернуться на страницу Инструменты и настройки. Миграция будет продолжена в фоновом режиме.',

    'ui__admin-alias-info__description' => "Редактировать контактную информацию дополнительной учетной записи администратора.",
    'ui__admin-alias-info__short-title' => "Контакты",
    'ui__admin-alias-info__title' => "Информация о дополнительной учетной записи администратора",
    'ui__admin-alias-password__description' => "Изменить пароль дополнительного администратора.",

    'ui__admin-alias-password__short-title' => "Изменить пароль",
    'ui__admin-alias-password__title' => "Пароль дополнительного администратора",
    'ui__admin-alias__description' => "Просмотр и редактирование информации о дополнительных учетных записях администратора.",

    'chk_js__warning_about_login_syntax' => "Имя пользователя может содержать только буквы в нижнем регистре, цифры, дефисы, точки и подчеркивания. Имя пользователя должно начинаться с буквы. Пароль не должен включать имя пользователя и кавычки.",
    'chk_js__warning_about_ftp_login_syntax' => "Имя пользователя может состоять из букв, цифр, тире и подчеркиваний.",
    'chk_js__warning_about_login_syntax_win' => "Имя пользователя может включать только буквы в нижнем регистре, цифры, дефисы, точки и подчеркивания. Имя пользователя может начинаться с буквы или цифры. Пароль не должен содержать имя пользователя и кавычки.",
    'chk_js__warning_about_passwd_syntax' => "Пароль не может содержать кавычки, пробелы и национальные символы.\nПароль должен быть длиной от %1 до %2 символов и не может содержать имя пользователя.",
    'chk_js__warning_about_plesk_login_syntax' => "Имя пользователя может содержать только буквы в нижнем регистре, цифры, точки, тире и подчеркивания.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Имя пользователя может содержать только буквы в нижнем регистре, цифры, тире и подчеркивания. Имя пользователя должно начинаться с буквы.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Пароль не может содержать кавычки, пробелы и национальные символы.\nПароль должен быть длиной от %1 до %2 символов и не может содержать имя пользователя.",
    'chk_js__warning_about_pam_passwd_error' => "Неверно указан системный пользователь: %1",

    'cmd_server__admin_alias_not_found' => "Не удается найти дополнительную учетную запись администратора.",

    'panel_branding__skins_already_exists' => "Примечание: Тема '%1' уже существует. Она будет заменена на устанавливаемую в данный момент тему.",
    'panel_branding__skins_file_exists' => "Невозможно создать папку для темы '%1': Файл с таким именем уже существует.",

    'actionlog__login_failed' => 'ошибка входа',
    'actionlog__event_cp_user_login_failed' => 'Пользователь Plesk не смог войти в систему',
    'actionlog__api_login_failed' => 'ошибка входа через API',
    'actionlog__event_cp_user_api_login_failed' => 'Пользователь Plesk не смог войти через API',
    'actionlog__pw_reset' => 'запрошен сброс пароля',

    'ch_pass_admin__email_subject' => "Восстановление пароля Plesk",
    'ch_pass_admin__email_body' => "Здравствуйте, %1.\n\nИз соображений безопасности пароль администратора не может быть отправлен по электронной почте.\n\nЧтобы войти как пользователь \"admin\", используйте команду \"plesk login\".\n\nЧтобы установить новый пароль пользователя \"admin\", используйте команду \"plesk bin admin --set-password -passwd <new_password>\".\n\n",
    'ch_pass_admin__message_send_error' => 'Не удалось отправить сообщение: %1',

    'ch_pass_by_secret__email_subject' => "Восстановление пароля Plesk",
    'ch_pass_by_secret__email_body' => "Здравствуйте, %2,\n\nЧтобы задать новый пароль, перейдите по ссылке: %1\n\nВаше имя пользователя: %3",
    'ch_pass_by_secret__message_send_error' => 'Секретный код не был отправлен: %1',
    'ch_pass_by_secret__title' => 'Изменить пароль',
    'ch_pass_by_secret__secret' => 'Секретный код',

    'custom_button__noframe' => "Не использовать фреймы",

    'custom_button__internal_hint' => 'Укажите, где следует открывать ссылку: на странице Plesk или в новом окне браузера.',
    'custom_button__noframe_hint' => 'Если персональная кнопка ведет на какое-либо расширение Plesk или приложение в Панели клиента, вы можете указать, как его следует показывать: во фрейме или как часть интерфейса Plesk.',


    'actionlog__patch' => 'Обновить',
    'actionlog__patch_available' => 'обнаружение',
    'actionlog__event_patch_available' => 'Доступно обновление',
    'actionlog__patch_installed' => 'установка',
    'actionlog__event_patch_installed' => 'Обновление установлено',

    'actionlog__extension' => 'Расширение',
    'actionlog__extension_status' => 'Состояние расширения',
    'actionlog__cloning' => 'Клонирование сервера',
    'actionlog__cloning_complete' => 'завершение',
    'actionlog__event_cloning_complete' => 'Клонирование сервера завершено',

    'actionlog__ssl_web_binding' => 'SSL/TLS-сертификат для защиты домена',
    'actionlog__ssl_web_binding_update' => 'назначен или удален',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS-сертификат для защиты домена назначен или удален',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-сертификат для защиты веб-почты',
    'actionlog__ssl_web_mail_binding_update' => 'назначен или удален',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS-сертификат для защиты веб-почты назначен или удален',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-сертификат для защиты почтового сервера',
    'actionlog__ssl_mail_binding_update' => 'назначен или удален',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-сертификат для защиты почтового сервера назначен или удален',

    'actionlog__ssl_panel_binding' => 'SSL/TLS-сертификат для защиты Plesk',
    'actionlog__ssl_panel_binding_update' => 'назначен или удален',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-сертификат для защиты Plesk назначен или удален',

    'actionlog__hostname' => 'Имя хоста сервера',
    'actionlog__hostname_changed' => 'изменение',

    'actionlog__smb_user' => 'Дополнительный пользователь',
    'actionlog__smb_user_create' => 'Дополнительный пользователь создан',
    'actionlog__smb_user_delete' => 'Дополнительный пользователь удален',
    'actionlog__smb_user_update' => 'Дополнительный пользователь обновлен',

    'actionlog__event_mail_management_status_update' => 'Обновление статуса управления почтой',
    'actionlog__mail_management' => 'Статус управления почтой',
    'actionlog__mail_management_status_update' => 'обновление',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Всего по доменам',

    'chk_js__warning_about_admin_passwd_syntax' => "Не используйте в пароле символы кавычек, пробела, точки с запятой и буквы национального алфавита. Пароль должен быть длиной от %1 до %2 символов и не должен содержать имя пользователя.",

    'passwordSecurityLevelCheckFailed' => 'Ваш пароль недостаточно надежен. Текущая политика сервера требует, чтобы пароль был как минимум "%1". Чтобы сделать пароль более надежным, включите в него цифры, буквы в верхнем и нижнем регистре и специальные символы !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Очень ненадежный',
    'passwordSecurityLevelCheckFailedWeak' => 'Ненадежный',
    'passwordSecurityLevelCheckFailedMediocre' => 'Средний',
    'passwordSecurityLevelCheckFailedStrong' => 'Надежный',
    'passwordSecurityLevelCheckFailedStronger' => 'Очень надежный',

    'filemanager__invalid_path' => "Указан неправильный путь",

    'ui__client/domain/dns/sync__description' => 'Применить изменения, внесенные в глобальный шаблон DNS, к этой зоне.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Изменения, внесенные в шаблон DNS, не могут быть применены к этой зоне, так как она обслуживается другим сервером DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Применить изменения шаблона DNS',
    'ui__client/domain/dns/sync__done' => 'Изменения, внесенные в шаблон DNS, были успешно применены к этой зоне.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Применить изменения, внесенные в глобальный шаблон DNS, к этой зоне.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Изменения, внесенные в шаблон DNS, не могут быть применены к этой зоне, так как она обслуживается другим сервером DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Применить изменения шаблона DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Изменения, внесенные в шаблон DNS, были успешно применены к этой зоне.',
    'dns__dns_default_ipv4_modified' => 'Записи с этим IP-адресом будут считаться измененными пользователем и не будут синхронизироваться с серверным шаблоном DNS.',
    'dns__dns_default_ipv6_modified' => 'Записи с этим IP-адресом будут считаться измененными пользователем и не будут синхронизироваться с серверным шаблоном DNS.',

    'dns__view_dns_record_master_title' => 'Просмотр записей ресурсов',
    'dns__view_dns_record_off_title' => 'Просмотр записей DNS',
    'dns__view_dns_record_slave_title' => 'Просмотр записей первичного сервера DNS',

    'dns_unable_to_resolve_hostname' => "Не удается преобразовать имя сервера \"%1\": %2\nУбедитесь, что DNS-преобразователь операционной системы настроен и работает.",

    'no_database_server_available' => 'Для этой подписки недоступно ни одного сервера баз данных.',

    'database_used_by_application_can_not_be_moved' => 'Невозможно переместить базу данных: эта база данных используется веб-приложением.',
    'database_user_update_orphaned_is_restricted' => 'Обновление потерянных учетных записей пользователей базы данных запрещено. Их можно только удалить или исправить.',

    'database_unable_to_get_max_filesize_default_message' => 'Не удалось определить максимальный размер файла базы данных: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Не удалось установить максимальный размер файла базы данных: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Не удалось определить максимальный размер файла журнала базы данных: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Не удалось установить максимальный размер файла журнала базы данных: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Невозможно определить существующее ограничение на размер файла базы данных Microsoft SQL \'%1\'. Невозможно установить новое ограничение.',
    'database_unable_to_set_max_filesize' => 'Невозможно установить ограничение на размер файла базы данных Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Невозможно определить существующее ограничение на размер файла журнала базы данных Microsoft SQL \'%1\'. Невозможно установить новое ограничение.',
    'database_unable_to_set_max_log_filesize' => 'Невозможно установить ограничение на размер файла журнала базы данных Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Не удалось создать базу данных Microsoft SQL \'%1\': размер ее файла превышает максимально допустимый размер.',
    'database_unable_to_move_because_max_filesize' => 'Не удалось переместить базу данных Microsoft SQL \'%1\': размер ее файла превышает максимально допустимый размер: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Не удалось создать базу данных Microsoft SQL \'%1\': размер файла ее журнала превышает максимально допустимый размер.',
    'database_unable_to_move_because_max_log_filesize' => 'Не удалось переместить базу данных Microsoft SQL \'%1\': размер файла ее журнала превышает максимально допустимый размер: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Не удалось восстановить базу данных Microsoft SQL \'%1\': размер ее файла превышает максимально допустимый размер.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Такой сервер MS SQL уже зарегистрирован в Plesk. Пожалуйста, укажите другой сервер MS SQL в качестве тестового.',
    'database_server__mssql_server_registered_as_sandbox' => 'Такой тестовый сервер MS SQL уже зарегистрирован в Plesk. Пожалуйста, укажите другой сервер MS SQL в качестве тестового.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Не удалось подключиться к серверу по \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Функция %1 не поддерживается следующими узлами обслуживания: %2. Эта функция будет отключена для всех объектов, созданных на этих узлах.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Функция %1 не поддерживается этим сервером. Эта функция будет отключена для всех восстановленных объектов.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Компонент %1 не установлен. Он будет недоступен для следующих сайтов: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Компонент %1 не установлен. Вместо него будет использоваться %2 для следующих сайтов: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Текущая версия Plesk не поддерживает имена пользователей c точкой (.). Клиенты и реселлеры с такими именами не будут восстановлены.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Не удается найти файл резервной копии с данными для %1 %2. Данные для %1 %2 не будут восстановлены.',

    'bu_conflict_resolver_zone_master_removed' => "Невозможно восстановить первичную DNS-запись: запись во вторичной зоне указывает на существующий IP-адрес %1. Первичная DNS-запись будет удалена из вторичной зоны.",

    'bu_conflict_resolver_not_available_scripting' => '%1 не поддерживается.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 не поддерживается. Он будет недоступен для следующих сайтов: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Компонент %1 не установлен.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Он будет недоступен для следующих узлов обслуживания: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Он будет недоступен для следующих объектов: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'На этом сервере недоступны следующие серверы баз данных: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Резервная копия базы данных MS SQL хранится в собственном формате MS SQL и может быть восстановлена только на локальном сервере MS SQL или на удаленном сервере MS SQL с настроенными параметрами резервного копирования. Некоторые из ваших баз данных не были восстановлены, так как в Plesk нет подходящего сервера MSSQL. Это затронуло следующие домены: {{objects}}. Пожалуйста, обратитесь к своему хостинг-провайдеру.',

    'bu_conflict_resolver_not_available_webmail' => 'Веб-почта %1 недоступна. Она будет заменена на %2 для следующих объектов: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Веб-почта %1 недоступна. Она будет заменена на %2 для следующих тарифных планов: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Базы данных с типом '%1' не поддерживают имена пользователей, совпадающие с именами баз данных. Пользователь базы данных '%4' '%2' будет переименован в '%3'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'В конфигурации целевого сервера не задано ограничение на использование дискового пространства. Этому параметру будет присвоено значение "Без ограничений".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'В конфигурации целевого сервера не задано ограничение на количество подключений. Этому параметру будет присвоено значение "Без ограничений".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'В конфигурации целевого сервера не задано ограничение на использование трафика. Этому параметру будет присвоено значение "Без ограничений".',
    'cu__pleskrestore_backup_file_extracted' => 'Резервная копия была извлечена в "%1".',
    '__mod_bw_not_supported' => 'Текущая конфигурация файловой системы не поддерживает модуль mod_bw. Ограничения на трафик и максимальное количество подключений работать не будут.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Проверка подлинности POP3 при ретрансляции почты не поддерживается, вместо этого будет использоваться проверка подлинности "POP3 перед SMTP". ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Тарифный план \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 не поддерживается. Вместо этого для следующих тарифных планов будет использоваться %2: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 не поддерживается. Вместо этого для следующих сайтов будет использоваться %2: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'В резервной копии не найдены следующие объекты: %1',
    'bu_conflict_resolver_absent_domains' => 'Некоторые объекты не могут быть восстановлены, так как принадлежат следующим доменам, не найденным в Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Некоторые сайты не могут быть восстановлены, так как принадлежат следующим доменам, не найденным в Plesk: %1",
    'bu_conflict_resolver_dns_not_supported' => 'Невозможно восстановить зоны DNS: в настройках сервера отключена служба DNS.',
    'bu_conflict_resolver_mail_not_supported' => 'Невозможно восстановить почтовые ящики: в настройках сервера отключена почтовая служба.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'Указанное время ожидания простоя не поддерживается веб-сервером IIS. Это значение будет изменено на %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Указанное действие не поддерживается веб-сервером IIS. Это значение будет изменено на %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'SSL/TLS-сертификат сервера %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-сертификат %2 домена %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-сертификат %1',
    'bu_conflict_resolver_absent_objects' => 'Содержимое следующих объектов не может быть восстановлено, так как они не найдены в Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Контент следующих почтовых ящиков не может быть восстановлен, так как они не найдены в Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Контент следующих списков рассылки не может быть восстановлен, так как они не найдены в Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Содержимое следующих баз данных не может быть восстановлено, так как они не найдены в Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Не удалось восстановить приложение "%1" на "%2", потому что в "%3" уже установлено другое приложение. Вы можете удалить установленное приложение и попробовать еще раз.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Функция почтового автоответчика не поддерживается.',
    'bu_conflict_resolver_not_available_mail_content' => 'Восстановление почтового контента не поддерживается.',
    'bu_conflict_resolver_invalid_mail_name' => 'Следующие почтовые ящики не были восстановлены, так как на сервере включена почтовая субадресация и некоторые почтовые адреса содержат символ "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Следующие пользователи не были восстановлены, так как на сервере включена почтовая субадресация и некоторые почтовые адреса содержат символ "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'У следующих лицензий истек срок действия и они не будут восстановлены: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Следующие лицензии недействительны или просрочены и не будут восстановлены: {{objects}}',
    'expiration_unsupported' => "Ограничение 'expiration' не поддерживается.",

    'component_name__dbconnector' => "Средство подключения к базе данных",
    'component_name__mysqlserver' => 'Сервер MySQL',
    'component_name__troubleshooting' => 'Устранение неисправностей',
    'component_name__savi' => 'Интерфейс антивируса Sophos',

    '__subscription_has_no_license_key' => 'Ресурсы этой подписки предоставлены сервером #%1, которому не назначен ключ лицензии.',
    '__subscription_has_expired_license_key' => 'Ресурсы этой подписки предоставлены сервером #%1, у которого истек срок действия ключа лицензии %2.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Невозможно сохранить конфигурационные файлы',
    '__cfgmonConfigurationFileSaveErrorBody' => "Невозможно сохранить некоторые конфигурационные файлы на сервере <%%host%%>: возникли следующие ошибки:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Эта опция включает возможность настройки VERP-адресов электронной почты для списков рассылки',
    'mail__enter_right_ip_mask' => "Введите IP-маску в диапазоне от 1 до 32",
    'mail__enter_right_ip_mask_24' => "Введите IP-маску в диапазоне от 24 до 32",
    'mail__invalid_dom_name' => "%1 ― недопустимое имя домена.",
    'mail__invalid_pop_lock_time' => "Указано недопустимое время блокирования POP3.",
    'mail__invalid_rbl_server' => "Недопустимое имя зоны DNS.",
    'mail__total_files_size' => "Совокупный размер файлов в репозитории: %1",
    'mail__filename_already_in_repository' => "Файл с таким именем уже существует в хранилище",
    'mail__no_white_list_mask_feature_24' => "Используйте значение маски 24 или больше. Ваш почтовый сервер не поддерживает установку масок. Мы можем только эмулировать установку маски для значений не меньше 24.",
    'mail__unable_add_new_mail_name' => "Не удалось добавить учетную запись почты: %1",
    'mail_server_is_not_installed' => 'Почтовый сервер (Postfix или Qmail) не установлен. Установите его для продолжения работы.',
    'mail_server_not_available' => 'На этом узле обслуживания недоступно ни одного поддерживаемого почтового сервера.',
    '__not_installed' => '(не установлен)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Антиспам для исходящих сообщений отключен.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Данный сервер обслуживания не поддерживает ограничение исходящей почты от домена %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Данный сервер обслуживания не поддерживает ограничение исходящей почты от почтовых ящиков для домена %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Укажите адрес или хотя бы один тип (IPv4 или IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Указан недопустимый режим отправки почтовых сообщений.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Указан недопустимый IPv4-адрес.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Указан недопустимый IPv6-адрес.',
    'mail__outgoing_email_mode_unavailable' => 'Изменение режима исходящей почты не поддерживается ‒ возможно, в Plesk не установлен почтовый сервер Postfix.',

    'mail__autoresponder_attachment_not_supported' => 'Используемый в настоящее время почтовый сервер не поддерживает управление подключением автоответчика.',

    'mail__smtp_white_list_not_supported' => 'Используемый в настоящее время почтовый сервер не поддерживает белый список IP-адресов.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Маски CIDR не поддерживаются текущим выбранным почтовым сервером. Укажите IP-адрес в формате "192.*.0.*".',
    'mail__smtp_whitelist_mask_not_supported' => 'Шаблоны групповых IP-адресов не поддерживаются текущим выбранным почтовым сервером. Укажите IP-адрес в формате "192.0.0.0/8".',

    'sfdk_server_wide_verify_failed' => 'Невозможно изменить настройки службы проверки DKIM',

    'sfdk_domain__serverwide_disabled' => 'Выключено согласно политике сервера',
    'feature__domainkeys__serverwide_disabled' => 'Серверная защита от спама DKIM отключена',

    'defaultcomponents__error_set_default' => 'Программа %1 не может быть назначена как %2 по умолчанию: %3',
    'defaultcomponents__error_set_default_none' => 'Невозможно установить компонент по умолчанию для %1: %2',
    'defaultcomponents__required_package_not_default' => 'Компонент %1, необходимый для ее работы, не является вариантом по умолчанию.',

    '__percentage' => '%',
    '__seconds' => 'Секунд',
    '__resource_remain' => 'Осталось',

    '__not_registered' => '(не зарегистрирована)',
    '__php_handler_id' => 'Версия PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Обработчик PHP "%1" не зарегистрирован. Возможно, он был удален с сервера. Зарегистрируйте обработчик с такими же свойствами и повторите попытку.',
    '__php_handler_not_registered_on_domain' => 'Домен "%1": обработчик PHP "%2" не зарегистрирован. Возможно, он был удален с сервера. Зарегистрируйте обработчик с такими же свойствами и повторите попытку.',
    '__php_fpm_handler' => 'Приложение FPM',
    '__php_fpm-dedicated_handler' => 'Выделенное приложение FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Невозможно создать пользователя почтового ящика. Пользователь с именем %1 уже существует и имеет другой почтовый ящик.',
    'mailname_create_assigned_user_role_absent_error' => 'Невозможно создать пользователя почтового ящика. Его роль по умолчанию (%1) не существует.',

    'gphd__mime_types' => 'Типы MIME',
    'gphd__handlers' => 'Обработчики Apache',
    'gphd__ip_restrictions_allow' => 'Разрешить доступ к сайту указанным серверам и сетям (исключая запрещенные)',
    'gphd__ip_restrictions_deny' => 'Запретить доступ к сайту указанным серверам и сетям',
    'gphd__directory_index' => 'Стартовые страницы',
    'gphd__nginx_transparent_mode' => 'Режим, в котором Apache обрабатывает и статический, и динамический контент, а nginx только передает запросы и ответы HTTP без их изменения.',
    'gphd__nginx_serve_static' => 'Обрабатывать статические файлы с помощью nginx.',
    'gphd__nginx_static_extensions' => 'Расширения статических файлов, которые следует обрабатывать с помощью nginx',
    'gphd__nginx_serve_php' => 'Обрабатывать PHP-файлы с помощью nginx',
    'gphd__www_root' => 'Корневая папка WWW',

    'eol__none' => 'не изменять',
    'eol__lf' => 'преобразовать в формат Unix',
    'eol__cr' => 'преобразовать в формат MacOS',
    'eol__crlf' => 'преобразовать в формат Windows',

    'ui__dns_bad_zone' => 'Несогласованная зона "%1":',
    'ui__dns_ns_has_no_address_records' => 'В NS-записи "%1" нет ни одной адресной записи (A или AAAA).',
    '__dns_bad_zone' => 'Несогласованная зона "%1":',
    '__dns_ns_has_no_address_records' => 'В NS-записи "%1" нет ни одной адресной записи (A или AAAA).',
    '__dns_ptr_is_wildcard' => 'Ошибка в PTR-записи "%1": эта запись указывает на шаблон домена.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Разрешить удаленный доступ пользователю базы данных \'%3\' клиента \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Не удалось разрешить удаленное подключение пользователю базы данных \'%1\': не удалось определить TCP-порт, используемый сервером Microsoft SQL \'%2\'. Возможные причины: на этом сервере не включен протокол TCP/IP или используются динамические порты TCP. Настройте этот сервер так, чтобы он прослушивал конкретный фиксированный порт TCP, и снова попробуйте разрешить удаленное подключение.',

    'command__convertResellerHasCustomer' => 'У реселлера \'%1\' есть один или несколько клиентов. Прежде чем преобразовать этого реселлера в клиента, нужно передать его клиентов новому владельцу или преобразовать их в реселлеров.',
    'command__convertResellerNotReseller' => 'Только реселлеры могут быть преобразованы в клиентов. \'%1\' не является реселлером.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Пользователь \'%1\' является реселлером. Реселлеров нельзя передать новому владельцу, так как они принадлежат администратору сервера.',
    'moveCustomer__wrong_owner_type' => "Клиента '%1' можно передать только реселлеру или администратору, но не другому клиенту.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Клиент \'%1\' уже принадлежит выбранному владельцу.',
    'upgradeClient__user_is_admin' => 'Пользователь \'%1\' является администратором и не может быть преобразован в реселлера.',

    'mail__error_setting_max_connections_courier' => 'Не удалось сохранить максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Не удалось сохранить максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Не удалось сохранить максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS), разрешенное с одного и того же IP-адреса: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Не удалось сохранить максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS), которое может установить один пользователь почты с каждого IP-адреса: %1',
    'outgoing_messages_limit_value_invalid' => 'Значение должно находиться в диапазоне %%MIN%%..%%MAX%%. Этот параметр может изменить только администратор Plesk.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Следующие домены используют для пересылки почты, отправленной несуществующим адресатам, внешние почтовые адреса. Сообщения, отправляемые на эти адреса, не будут учитываться при контроле исходящей почты:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Ограничения на исходящую почту не будут работать для отправителей, чьи IP-адреса находятся в белом списке почтового сервера. Например, если белый список содержит запись localhost (127.0.0.0 / 8, ::1 / 128), то вся почта с локального сервера будет успешно отправляться независимо от ограничений. Отправители могут использовать локальные IP-адреса (сайты и пользовательские скрипты на локальном сервере) или внешние (клиенты, которые отправляют почту из почтовых клиентов, установленных на их компьютерах или мобильных устройствах). Чтобы ограничения работали для всех отправителей (и локальных, и внешних), удалите из белого списка все IP-адреса и сети. Учтите, что удаление из белого списка записи localhost (127.0.0.0 / 8, ::1 / 128) может нарушить работу сайтов и скриптов, отправляющих почту с этого сервера. Подробнее об ограничении исходящей почты смотрите в Руководстве администратора, раздел Защита от исходящего спама.',
    'outgoing_messages_relay_open' => 'Почтовый релей открыт: ограничения на исходящую почту не будут работать.',

    'notification_aps_app_updates_available' => 'Найдены обновления для следующих приложений:',
    'notification_aps_app_updates_installed' => 'Были автоматически обновлены следующие приложения:',
    'notification_aps_app_updates_requirements' => 'Для следующих приложений доступны обновления, но они не могут быть установлены, так как настройки хостинга соответствующих сайтов не удовлетворяют требованиям установки:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Плагин "%%name%%" на %%parentName%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Тема "%%name%%" на %%parentName%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Плагин "%%name%%" на %%parentName%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Тема "%%name%%" на %%parentName%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Ваша версия: %%from%%. Доступная версия: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Плагин "%%name%%" на %%parentName%% (%%url%%). Ваша версия: %%from%%. Доступная версия: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Тема "%%name%%" на %%parentName%% (%%url%%). Ваша версия: %%from%%. Доступная версия: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Новая версия: %%to%%. Предыдущая версия: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Новая версия: %%to%%. Предыдущая версия: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Новая версия: %%to%%. Предыдущая версия: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Установленная версия: %%from%%. Доступная версия: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Ваша версия: %%from%%. Доступная версия: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'внешнее приложение',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Домены',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Почтовые адреса',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Подписки',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 сообщений в час',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Без ограничений',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, ограничение ‒ %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 попыток с %2 до %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 попыток с %2 до сих пор',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Блокировка IP-адресов (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'На целевом сервере не установлен компонент Fail2Ban.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Установите Fail2Ban. Это может занять несколько минут.',

    'plesk_key__no_reseller_support' => 'Управление реселлерами запрещено лицензией.',
    'plesk_key__no_customers_support' => 'Управление клиентами запрещено лицензией.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Невозможно переключиться в режим Service Provider из-за ограничений лицензии.',
    'plesk_key__no_security_core_support' => 'Функции ModSecurity и Fail2Ban запрещены лицензией.',
    'plesk_key__outgoing-antispam' => 'Контроль исходящей почты',
    'plesk_key__security-core' => 'Безопасность (ModSecurity и Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Управление учетными записями',
    'plesk_key__can-manage-subscriptions' => 'Управление подписками',
    'plesk_key__can-manage-customers' => 'Управление клиентами',
    'plesk_key__can-manage-resellers' => 'Управление реселлерами',
    'plesk_key__can-manage-custom-view' => 'Доступность Ограниченного режима',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Управление подписками отключено, но у вас есть несколько подписок (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Управление реселлерами отключено, но у вас есть несколько реселлеров (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Управление клиентами отключено, но у вас есть несколько клиентов (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Некоторые ресурсы подписки, которыми вы больше не можете управлять через интерфейс Plesk (например, ограничения почтовых ящиков и дисковое пространство доменов), теперь не имеют ограничений.',
    'plesk_key__no_subscriptions_support' => 'Управление подписками запрещено лицензией.',
    'plesk_key__no_custom_view_support' => 'Вы не можете использовать Ограниченный режим из-за ограничений лицензии.',
    'plesk_key__trial_forbidden_region' => 'К сожалению, Plesk в вашем регионе сейчас недоступен.',
    'additional_key__main_key' => 'Этот ключ является основным: нельзя загрузить основной ключ в качестве дополнительного.',

    'gch__hosting_waf_rule_engine' => 'Режим работы брандмауэра для веб-приложений:',

    'backup__fieldset__restoration_options' => 'Параметры восстановления',
    'backup__restore_options__restore' => 'Восстановить',
    'backup__restore_options__domain__domain_configuration' => 'Настройки домена',
    'backup__restore_options__domain__virtual_host_content' => 'Контент виртуального сервера',
    'backup__restore_options__domain__mail' => 'Почта',
    'backup__restore_options__domain__databases' => 'Базы данных',
    'backup__restore_options__client__client_configuration' => 'Настройки клиента',
    'backup__restore_options__client__domains' => "Домены клиента",
    'backup__restore_options__reseller__reseller_configuration' => 'Настройки реселлера',
    'backup__restore_options__reseller__personal_domains' => "Домены реселлера",
    'backup__restore_options__reseller__clients' => "Клиенты реселлера",
    'backup__restore_options__admin__server_configuration' => 'Настройки сервера',
    'backup__restore_options__admin__administrator_configuration' => 'Настройки учетной записи администратора',
    'backup__restore_options__admin__personal_domains' => "Домены администратора",
    'backup__restore_options__admin__personal_clients' => "Клиенты администратора",
    'backup__restore_options__admin__resellers' => 'Реселлеры',

    'badge_new' => 'Создать',
    'upgrade_php_on_subscription' => 'Обновите PHP в своей подписке до версии 5.3.0 или выше.',

    'pkey_notify__body_expiration_notification' => 'Срок действия лицензии истек. Некоторые функции могут быть недоступны. Пожалуйста, обратитесь к своему хостинг-провайдеру.',

    'crontab__crontab_entry_exists' => "Такая задача уже существует.",
    'crontab__crontab_entry_not_exists' => "Такой запланированной задачи не существует.",
    'crontab__invalid_values_found' => "Неверные значения параметров.",
    'crontab__cmd_max_len' => "Команда не может быть длиннее %1 символов.",

    'domain__domain_exists' => "Уже существует домен с префиксом 'www' и таким же именем: %1.%2.",
    'domain__subdomain_exists' => "Уже существует субдомен с префиксом 'www' и таким же именем: %1.%2.",
    'domain__dalias_exists' => "Уже существует псевдоним домена с префиксом 'www' и таким же именем: %1.%2.",
    'domain__record_exists' => "Имеется запись DNS, указывающая на хост %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Сертификат '%1' не может быть указан как сертификат по умолчанию: отсутствует закрытый ключ.",
    'ip_addr__update_dns_error' => 'Возникли проблемы при обновлении IP-адреса в зонах DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Невозможно добавить IP-адрес. Этот сетевой интерфейс получает IP-адреса автоматически.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Невозможно удалить IP-адрес %1. Этот сетевой интерфейс получает IP-адреса автоматически.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Невозможно восстановить IP-адрес %1. Этот сетевой интерфейс получает IP-адреса автоматически.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Невозможно изменить интерфейс IP-адреса %1, так как сетевой интерфейс %2 получает IP-адреса автоматически.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Превышено ограничение подписки на количество %%type%%. Текущее ограничение %%limit%%, и %%usage%% используется.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Не разрешено создавать %%type%% в этой подписке.',
    'shm_lmsg__resource_title__db-mysql' => 'Базы данных MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Базы данных MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Базы данных PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'Пользователи баз данных',
    'shm_lmsg__resource_title__iis-application-pool' => 'Пулы приложений IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'дополнительные учетные записи FTP',

    'db_user_unable_remove_mysql_global_privileges' => 'Невозможно удалить глобальные права MySQL пользователя базы данных %1. Причина: %2',
    'report__client_description' => 'Описание',

    'db__user_role_error' => 'Указана неверная роль пользователя базы данных: %1. Пожалуйста, выберите одну из следующих ролей: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Невозможно установить ограничение на размер файла для следующих баз данных Microsoft SQL Server, потому что они содержат файлы большего размера: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Невозможно установить ограничение на размер файла журналов для следующих баз данных Microsoft SQL Server, потому что они содержат файлы журналов большего размера: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Невозможно настроить внешний IP-адрес: должен существовать частный IP-адрес.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Невозможно настроить внешний IPv4-адрес для IPv6-адреса.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Невозможно настроить внешний IPv6-адрес для IPv4-адреса.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Невозможно настроить внешний IP-адрес: недействительный IP-адрес.',

    '__user_already_exists' => "Пользователь %1 уже существует.",
    '__user_name_is_empty' => "Пожалуйста, укажите имя пользователя.",

    'upgrade_php_on_domain' => 'Не удалось найти PHP версии 5.3.0 или более поздних версий ни на одном домене с WordPress. Попробуйте обновить PHP.',

    'component_name__waf' => 'Брандмауэр для веб-приложений',
    'component_name__vcs' => 'Система контроля версий',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Обнаружена возможная попытка фишинга: попытка показать по ссылке не относящийся к ней контент.',
    'forceResetPasswordUpdated' => 'Ваш пароль был изменен. Используйте новый пароль для входа в Plesk.',

    'php_handlers_error_no_available_instance' => 'Невозможно создать домен: нет доступных обработчиков PHP.',
    'domain_error_unable_to_apply_hosting_settings' => 'Не удалось применить настройки хостинга: %1',

    'plesk_not_configured' => 'Plesk не настроен. Перейдите в панель управления, чтобы выполнить послеустановочную настройку.',
    'cmd_mail__mail_password_duplicated' => 'Указанная пара "электронный адрес и пароль" уже существует на почтовом сервере. Пожалуйста, укажите другой электронный адрес или пароль.',

    'extensionRequirementOs' => 'Пакет не поддерживает операционную систему (%1).',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 самая ранняя из поддерживаемых пакетом версий.',
    'extensionRequirementPleskMaxVersion' => 'Пакет не поддерживает версии Plesk %1 и выше.',
    'extensionBlacklisted' => 'Не разрешена установка расширения %1.',
    'extensionDisabled' => 'Расширение отключено.',


    'optimization_settings__unable_set_mpm_event' => 'Не удалось установить режим mpm_event: для его включения требуется выключить модуль Apache PHP5, а этот модуль используется доменами.',
    'optimization_settings__unable_turn_off_php' => 'Не удалось выключить модуль Apache PHP5: он используется доменами.',

    'hst_def__fp_admin_login' =>  'Имя FTP-пользователя',
    'hst_def__fp_admin_passwd' =>  'Пароль FTP-пользователя',

    'database_user_orphaned_old_password_wrong' => "Не удалось восстановить потерянного пользователя '%1': неверный пароль.",
    'cannot_load_partner_central_property_key_no_exist' => "Не удалось получить настраиваемые свойства: ключа лицензии не существует.",
    'extensionScriptFailure' => "Сбой при выполнении %1. Получено следующее сообщение:\n%3",
    '__ssl_redirect' => "Постоянное перенаправление с HTTP на HTTPS с кодом 301 без ущерба для поисковой оптимизации",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Управление DKIM не поддерживается.',
    'mail__dmarc_not_supported' => 'Управление DMARC не поддерживается.',
    'mail__relay_white_list_not_supported' => 'Управление белым списком на основе ретранслятора не поддерживается.',
    'mail__black_list_not_supported' => 'Управление черным списком не поддерживается.',
    'mail__autoresponder_not_supported' => 'Управление автоответчиком не поддерживается.',
    'defaultcomponents__not_supported_version' => '(версия не поддерживается)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Сертификат \'%1\' не найден.',
    'certificate__unable_setup_certificate' => 'Не удалось установить сертификат: не найден закрытый ключ и сертификат.',
    'certificate__used_by_panel' => 'Один из сертификатов, которые вы собираетесь удалить, используется для защиты Plesk.',
    'certificate__used_by_mail_server' => 'Один из сертификатов, которые вы собираетесь удалить, используется для защиты почтового сервера.',
    'certificate__used_by_domain_service' => 'Один из сертификатов, которые вы собираетесь удалить, используется службой домена.',
    'mail_server__not_installed' => 'Не удалось установить сертификат для почтового сервера, потому что не установлен почтовый сервер.',

    'email_activation_mail_subject' => 'Пожалуйста, активируйте вашу учетную запись в Plesk',
    'email_activation_mail_body' => "Учетная запись была создана на сервере Plesk %1\n\nСведения об учетной записи:\nИмя: %2\nАдрес электронной почты: %3\n\nЕсли эта информация верна, и эта учетная запись была создана для вас, пожалуйста, активируйте ее, перейдя по следующей ссылке:\n\n%4\n\nАктивируя учетную запись, вы даете владельцу сервера разрешение собирать, хранить, обрабатывать и использовать ваши персональные данные (имя и почтовый адрес) для создания и поддержки вашей учетной записи, в соответствии с действующими законами о защите персональных данных, в рамках контракта.",

    'backup_transport_permission_name' => 'Управление %1',
    'backup_transport_permission_description' => 'Разрешает использование %1 для хранения резервных копий.',

    'domain_move_err_target_no_hosting' => 'Невозможно переместить домен в подписку без хостинга.',
    'domain_move_err_already_in_target' => 'Этот домен уже принадлежит целевой подписке.',
    'domain_move_err_main_domain' => 'Основной домен не может быть перемещен.',
    'domain_move_err_subdomain_without_parent' => 'Невозможно переместить субдомен %1 без родительского домена %2.',
    'domain_move_err_root_exists' => 'Целевой путь для www_root %1 уже существует.',
    'domain_move_err_nested_roots' => 'Невозможно удалить домен, так как его корневая папка используется совместно с другим доменом: %1.',
    'domain_move_err_no_mail_service' => 'Невозможно переместить домен, так как почтовая служба на целевой подписке отключена.',
    'domain_move_err_app' => "Приложение, установленное на %1, не было перемещено в подписку '%2': %3",
    'domain_move_database_used_by_app' => "База данных '%1' на %2 используется приложением, которое было перемещено. Чтобы переназначить базу данных '%3', запустите команду `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Целевая подписка '%1' была заблокирована на время синхронизации.",
    'domain_move_filesharing_disabled' => 'Обмен файлами отключен.',
    'domain_move_website_preview_disabled' => 'Предпросмотр сайта отключен.',
    'domain_move_additional_webserver_settings' => "Проверьте дополнительные директивы веб-сервера для этого домена, чтобы избежать повреждения конфигурации.",
    'domain_move_no_permission' => "%1 запрещено для подписки '%2'.",
    'domain_move_no_access' => "Нет доступа к подписке '%1'.",
    'domain_split_no_create_permission' => "Создание доменов запрещено.",
    'domain_split_empty_login' => 'Необходимо указать имя системного пользователя.',
    'domain_split_empty_password' => 'Необходимо указать пароль системного пользователя.',
    'domain_split_err_home_exists' => 'Не удалось переместить домен %1, потому что его целевая домашняя папка уже существует в %2. Переименуйте домен, чтобы переместить его в новую подписку.',
    'domain_split_err_no_hosting_subdomains' => 'Этот домен нельзя переместить в новую подписку, потому что у него нет хостинга, но есть субдомены. Чтобы переместить этот домен, измените значение его параметра "Тип хостинга" на "Хостинг веб-сайтов" (в разделе "Настройки хостинга").',
    'domain_split_target_locked' => "Целевая подписка '%1' заблокирована на время синхронизации.",
    'domain_split_target_unsynced' => "Синхронизировать целевую подписку '%1' с тарифным планом не удалось из-за ошибки: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Запланированное резервное копирование было отключено на '%1'.",
    'domain_merge_database_error' => "База данных '%1' на %2 не была перемещена в подписку '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Анонимный FTP на '%1' выключен.",
    'domain_merge_smb_user_access' => "Дополнительный пользователь '%1' перемещен в подписку '%2', но его доступ к подписке отменен.",
    'domain_merge_scheduled_tasks' => "Запланированные задачи были перемещены в целевую подписку. Проверьте конфигурацию задач.",
    'domain_merge_scheduled_tasks_deactivated' => "Запланированные задачи были перемещены в целевую подписку и отключены. Проверьте конфигурацию задач.",
    'domain_merge_no_remove_permission' => "Удаление подписок запрещено.",
    'domain_merge_err_has_addons' => 'Не удалось переместить основной домен с дополнительными доменами; сначала переместите домены %1.',
    'domain_merge_err_has_webusers' => 'Не удалось переместить основной домен с веб-пользователями.',
    'domain_merge_err_root_exists' => 'Целевой путь %1 уже существует.',

    'database_server_edit_used_for_psa' => 'Обновление локального сервера баз данных MySQL не разрешено.',
    'suggest_repair_main_suggestion_ui' => '<b>Вы можете исправить эту ошибку</b> с помощью утилиты `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Вы можете исправить эту ошибку с помощью утилиты `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'перейти в раздел "Диагностировать и исправить"',
    'suggest_repair_using_cli_and_ui' => 'Для этого либо запустите команду `plesk repair %1` через CLI, либо %2 и нажмите "Исправить" напротив надписи "База данных Plesk"',
    'suggest_repair_using_cli' => 'Для этого запустите команду `plesk repair %1` через CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Служба DNS была недоступна во время создания резервной копии. Однако в резервной копии присутствуют активные зоны DNS, и они будут включены для следующих объектов: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Контроллер ресурсов (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Поддержка удаленного SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(не разрешено лицензионным ключом)',
    'plesk_key__validation_failed' => '%1 (Код ошибки: %2)',
    'promo__button_details' => 'Подробности',
    'promo__extension_catalog_title' => 'Каталог расширений',
    'promo__extension_catalog_description' => 'Посмотрите наш новый каталог расширений и сделайте Plesk лучше с помощью множества разнообразных и мощных расширений!',
    'promo__button_open_catalog' => 'Открыть каталог',

    'backup__repository_check_login' => "Не удалось получить доступ к хранилищу: %1\nУбедитесь, что вы ввели корректные учетные данные хранилища.",
    'backup__repository_check_error_list' => "Не удалось получить доступ к хранилищу: %1\nУбедитесь, что вы ввели корректные настройки хранилища.",
    'backup__repository_check_error_mkdir' => "Не удалось создать папку: %1\nПроверьте, есть ли у вас права на создание папок в этом хранилище.",
    'backup__repository_check_error_upload' => "Не удалось загрузить файл в хранилище: %1\nПроверьте, есть ли у вас права на загрузку файлов в это хранилище.",
    'backup__repository_check_error_download' => "Не удалось скачать файл из хранилища: %1\nПроверьте, есть ли у вас права на загрузку и скачивание файлов из этого хранилища.",
    'backup__repository_check_error_resume-upload' => "Не удалось возобновить загрузку файла в хранилище: %1\nПроверьте, есть ли у вас права на возобновление загрузок в это хранилище.",
    'backup__repository_check_error_resume-download' => "Не удалось возобновить скачивание файла из хранилища: %1\nПроверьте, есть ли у вас права на возобновление скачиваний из этого хранилища.",
    'backup__repository_check_error_enable-utf8' => "Не удалось выполнить действие в хранилище: %1\nПроверьте, что это хранилище поддерживает кодировку UTF-8.",
    'backup__repository_check_error_rm' => "Не удалось выполнить действие в хранилище: %1\nПроверьте, есть ли у вас права на удаление файлов из этого хранилища.",
    'backup__repository_check_error_rmdir' => "Не удалось выполнить действие в хранилище: %1\nПроверьте, есть ли у вас права на удаление папок из этого хранилища.",

    'backup__ftp_repository_check_login' => "%1 Вы можете проверить их отдельно с помощью команды:\n  %2",
    'backup__ftp_repository_check_error_list' => "%1 Вы можете проверить их отдельно с помощью команды:\n  %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Вы можете проверить это отдельно с помощью команды:\n  %2",
    'backup__ftp_repository_check_error_upload' => "%1 Вы можете проверить это отдельно с помощью команд:\n  %2\n  %3",
    'backup__ftp_repository_check_error_download' => "%1 Вы можете проверить это отдельно с помощью команд:\n  %2\n  %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Вы можете проверить это отдельно с помощью команд:\n  %2\n  %3\n  %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Вы можете проверить это отдельно с помощью команд:\n  %2\n  %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Вы можете проверить это отдельно с помощью команды:\n  %2",
    'backup__ftp_repository_check_error_rm' => "%1 Вы можете проверить это отдельно с помощью команд:\n  %2\n  %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Вы можете проверить это отдельно с помощью команд:\n  %2\n  %3",

    'sfdmarc_server_wide_enable_failed' => 'Не удалось изменить настройки DMARC. Чтобы включить эту опцию, пожалуйста, включите защиту от спама DKIM и SPF.',
    'spf_server_wide_disable_failed' => 'Не удалось изменить настройки для защиты от спама SPF. Чтобы отключить SPF, пожалуйста, отключите DMARC для входящей почты.',
    'sfdk_server_wide_verify_disable_failed' => 'Не удалось изменить настройки для защиты от спама DKIM. Чтобы отключить DKIM, пожалуйста, отключите DMARC для входящей почты.',

    'ccs_not_supported' => 'Центральное хранилище сертификатов IIS не настроено в системе.',
    'ccs_not_enabled' => 'Управление центральным хранилищем сертификатов IIS не включено в Plesk.',
    'ad_not_supported' => 'Сервер не присоединен к домену.',

    'component_name__appinit' => "Инициализация приложения",
    'component_name__httpcompression' => 'Сжатие содержимого HTTP',
    'common_feature_is_not_supported' => 'Эта функция больше не поддерживается.',
    'common_feature_is_not_supported_in_proto' => 'Эта функция не поддерживается для протокола версии %1.',
    'autoinstaller__plesk_component' => 'Компонент Plesk',
    'plesk_key__key_expired' => 'Срок действия вашей лицензии истек. Чтобы продолжить использование Plesk, купите бессрочный коммерческий %1.',
    'plesk_key__key_purchase' => 'ключ лицензии',

    'sa_action_move' => 'Перемещать спам в папку "Спам"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-приложения больше не поддерживаются. Они будут недоступны для следующих сайтов: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Мобильные версии сайтов, размещенных с помощью UNITY Mobile, больше не поддерживаются. Они будут недоступны для следующих сайтов: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Серверная политика использования не разрешает использовать персональные настройки антивируса. Они будут восстановлены не полностью для почтовых учетных записей на следующих доменах: {{objects}}',

    'module__not_installed' => "Расширение %1 не установлено",

    'mail__mail_autodiscovery_server_error' => 'Укажите персональное имя домена для автообнаружения почты',
    'mail__error_mail_autodiscovery_enable' => 'Не удалось настроить автообнаружение почты: %1',
    'mail__error_mail_autodiscovery_server' => 'Не удалось задать персональное имя домена для автообнаружения почты: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Не удалось изменить DNS-записи для автообнаружения доменов: %1',

    '__invalid_url' => 'Недопустимый URL-адрес "%1"',
    'actionlog__cloning_start' => 'запуск',
    'actionlog__event_cloning_start' => 'Запуск клонирования сервера',

    '__UPLOAD_ERR_FORM_SIZE' => "Загруженный файл превышает допустимый размер",
    '__UPLOAD_ERR_INI_SIZE' => "Загруженный файл превышает допустимый размер",
    '__UPLOAD_ERR_NO_FILE' => "Файл не был получен",
    '__UPLOAD_ERR_OK' => "Файл успешно загружен",
    '__UPLOAD_ERR_PARTIAL' => "Удалось загрузить только часть файла, пожалуйста, попробуйте ещё раз",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Временная папка отсутствует',
    '__UPLOAD_ERR_CANT_WRITE' => 'Не удалось записать файл на диск',
    '__UPLOAD_ERR_UNKNOWN' => 'Произошла неизвестная ошибка загрузки файла',
    '__accounts' => "Учетные записи",
    '__access' => "Доступ",
    '__address' => "Адрес",
    '__addresses' => "Адреса",
    '__acl_records' => 'Записи Списка контроля доступа',
    '__admin_repository' => "Репозиторий администратора",
    '__all' => 'Все',
    '__allowed' => "Доступно",
    '__anonftp_status' => "Анонимный FTP",
    '__antispam' => "Антиспам",
    '__apache_restart' => "...%1 веб-сервер перезагружается, подождите пожалуйста...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Поддержка Microsoft ASP.NET",
    '__asp_win_support' => "Поддержка Microsoft ASP",
    '__attachments' => "Прикрепляемые файлы",
    '__attachments_list' => "Прикрепляемые файлы",
    '__author' => 'Автор',
    '__autoresp_name_already_exists' => "Автоответчик с именем %1 уже существует.",
    '__autoresponder' => "Автоответчик",
    '__autoresponders' => "Автоответчики",
    '__autoresponders_list' => "Автоответчики",
    '__autoresponder_attachment_files' => "Файлы, прикрепляемые к автоответчикам",
    '__auto_updates_list' => 'Доступные обновления',
    '__avail' => "Доступна",
    '__backup_utilites' => "Утилиты резервного копирования",
    '__bind_status' => "Статус сервера DNS",
    '__bu_is_not_installed' => "Служба недоступна: не установлены приложения для резервного копирования/восстановления.",
    '__bu_not_support_in_key' => "Резервное копирование не поддерживается текущим лицензионным ключом.",
    '__notifications_not_support_in_key' => 'Уведомления не поддерживаются лицензионным ключом',
    'disabled_by_key' => 'Не поддерживается лицензионным ключом',
    '__bytes' => "байт",
    '__can_not_use_reserved_words' => "Недопустимо использование зарезервированных слов.",
    '__certificate' => "Сертификат",
    '__cgi_support' => "Поддержка CGI",
    '__change_date' => "Дата изменения",
    '__city' => "Город",
    '__cl_not_exist' => "Учетная запись клиента не существует.",
    '__client' => 'Клиент',
    '__client_card' => "Карта клиента",
    '__client_contact_name' => "Имя клиента",
    '__client_form' => "Личная информация",
    '__client_ip_pool' => "Пул IP-адресов клиента",
    '__client_limits' => "Ограничения учетной записи клиента",
    '__client_permissions' => "Права клиента",
    '__client_preferences' => "Настройки клиента",
    '__client_status' => "Статус клиента",
    '__client_name' => "Имя клиента",
    '__client_total' => "Всего клиентов",
    '__client_with_login_name_already_exists' => "Пользователь с именем \"%1\" уже существует.",
    '__client_domuser_with_login_already_exists' => "Имя пользователя '%1' уже используется администратором домена '%1'.",
    '__clients_global_changes' => "Изменить выбранные учетные записи клиентов",
    '__clients_list' => "Клиенты",
    '__cmd_not_found' => "Неизвестная команда: %1",
    '__comments' => "Комментарии",
    '__company_name' => "Название компании",
    '__component_version' => "Версия компонента",
    '__component_not_installed' => "Компонент %1 не был установлен",
    '__confirm_del' => "Вы должны подтвердить удаление.",
    '__confirm_overwrite' => "Подтвердить замену.",
    '__confirm_stop' => "Вы должны подтвердить остановку процесса.",
    '__confirm_passwd' => "Подтвердите пароль %1",
    '__confirm_removal' => "Подтвердить удаление",
    '__conhelp' => "Описание",
    '__contact_name' => "Контактное имя",
    '__country' => "Страна",
    '__countries' => 'Страна',
    '__country_unknown' => 'Не удается распознать код страны.',
    '__courier-imap' => 'Сервер Courier',
    '__create_domain' => 'Создать домен',
    '__crypted' => 'зашифровано',
    '__cp_access' => "Доступ к Plesk",
    '__cp_user' => "Пользователь Plesk",
    '__create' => "Создать",
    '__create_client_template_without_template' => "Создать учетную запись пользователя без шаблона",
    '__create_domain_for' => "Создать домен для <b>%1</b>",
    '__create_domain_template_without_template' => "Создать домен без шаблона",
    '__creation_date' => "Дата создания",
    '__crontab_unix' => "Планировщик",
    '__crontab_win' => "Планировщик",
    '__ct_month_jan' => 'Январь',
    '__ct_month_feb' => 'Февраль',
    '__ct_month_mar' => 'Март',
    '__ct_month_apr' => 'Апрель',
    '__ct_month_may' => 'Май',
    '__ct_month_jun' => 'Июнь',
    '__ct_month_jul' => 'Июль',
    '__ct_month_aug' => 'Август',
    '__ct_month_sep' => 'Сентябрь',
    '__ct_month_oct' => 'Октябрь',
    '__ct_month_nov' => 'Ноябрь',
    '__ct_month_dec' => 'Декабрь',
    '__custom_button' => "Персональная кнопка",
    '__custom_buttons_list' => "Ссылки на дополнительные услуги",
    '__daily' => "День",
    '__database_not_activated' => "%1 не был активирован на странице администрирования сервера.",
    '__database_not_installed' => "База данных %1 не установлена.",
    '__database_not_run' => "База данных %1 не запущена.",
    '__database_is_corrupt' => "База данных Plesk повреждена. Чтобы устранить неисправность, запустите утилиту Reconfigurator.",
    '__databases' => "Базы данных",
    '__databases_list' => "Базы данных",
    '__database_type_not_supported_by_key' => 'Чтобы вы могли использовать сервер %1, его поддержка должна входить в ваш ключ лицензии. Пожалуйста, обратитесь за помощью к своему продавцу-консультанту Plesk.',
    '__date_immediately' => "сегодня",
    '__date_never' => "никогда",
    '__day(s)' => "Дней",
    '__day0' => "воскресенье",
    '__day1' => "понедельник",
    '__day2' => "вторник",
    '__day3' => "среда",
    '__day4' => "четверг",
    '__day5' => "пятница",
    '__day6' => "суббота",
    '__days' => "%1 дней",
    '__db_admin_login_empty' => "Вы не указали имя пользователя, что приведет к отключению контроля над %1 в интерфейсе. Продолжить?",
    '__db_unable_to_unregister' => 'Невозможно удалить параметры соединения с базой данных.',
    '__db_db_exists' => 'На сервере уже есть база данных.',
    '__db_unable_to_change_server_name' => 'Невозможно изменить имя сервера.',
    '__db_unable_to_change_port' => 'Невозможно назначить другой порт.',
    '__db_already_exist' => "База данных %1 уже существует.",
    '__db_credentials_invalid' => "Неверные имя пользователя или пароль для доступа к базе данных.",
    '__db_invalid_password_characters' => 'Пароль содержит недопустимые символы',
    '__db_engine' => "Процессор базы данных", // indirect
    '__db_type' => "Тип базы данных",
    '__db_user' => "Пользователь базы данных",
    '__db_server' => 'Сервер баз данных',
    '__def_domain' => "Домен по умолчанию",
    '__default_for_mysql' => 'по умолчанию для MySQL',
    '__default_for_mariadb' => 'по умолчанию для MariaDB',
    '__default_for_percona' => 'по умолчанию для Percona',
    '__default_for_postgresql' => 'по умолчанию для PostgreSQL',
    '__delete' => "Удалить",
    '__demo' => "Эта функция не доступна в демонстрационной версии.",
    '__directory' => "Папка",
    '__disable_lock_screen' => 'Запретить работу в Plesk до полной загрузки экранов интерфейса',
    '__dismiss_news?' => "Вы уверены, что хотите закрыть блок новостей?\n\nВы не сможете видеть блок новостей до тех пор, пока не появятся свежие новости.",
    '__description' => "Описание",
    '__disabled' => "отключено",
    '__disk_space_limit' => "Ограничение на дисковое пространство",
    '__cgroups_cpu_usage_limit' => 'Ограничение загрузки процессора',
    '__cgroups_ram_usage_limit' => 'Ограничение использования памяти',
    '__cgroups_disk_read_usage_limit' => 'Ограничение пропускной способности для чтения с диска',
    '__cgroups_disk_write_usage_limit' => 'Ограничение пропускной способности для записи на диск',
    '__disk_usage_by' => "Дисковое пространство, используемое %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Запись DNS '%1' уже существует.",
    '__dns_master_should_be_remote' => "У вас должно быть два разных уполномоченных сервера имен на разных компьютерах.",
    '__dns_record_not_exist' => "Запись DNS не существует.",
    '__dns_server' => "Сервер DNS", // indirect
    '__dom_id_is_undefined' => "Идентификатор домена не определен.",
    '__dom_name' => "Имя домена",
    '__dom_name_is_invalid' => "Недопустимое имя домена. Убедитесь, что имя домена содержит только буквенно-цифровые символы, точки и тире, а также что оно не превышает 255 символов. Каждая часть доменного имени между точек не должна превышать 63 символа.",
    '__dom_not_exist' => "Домен не существует.",
    '__domain' => "Домен",
    '__domain_' => 'Домен %1',
    '__domain_form' => "Данные о домене",
    '__domain_id' => "ID домена",
    '__domain_is_turned_off_for_backup' => "Сайт %1 временно отключен для резервного копирования или восстановления и в данный момент недоступен.",
    '__domain_limits' => "Ограничения домена",
    '__domain_name' => "Имя домена",
    '__mail_name_in_ASCII_form' => "Имя учетной записи электронной почты в формате ASCII",
    '__message_error' => 'Ошибка',
    '__message_warning' => 'Предупреждение',
    '__message_info' => 'Информация',
    '__domain_name_in_ASCII_form' => "Имя домена в кодировке ASCII",
    '__domain_repository' => "Репозиторий домена %1",
    '__domain_status' => "Статус домена",
    '__domain_found_tech' => "Технологии, найденные на домене",
    '__domain_dns' => 'Зона DNS домена',
    '__domain_total' => "Подписка",
    '__domain_total_powerUser' => "Подписка",
    '__domain_user' => "Администратор домена",
    '__domains_global_changes' => "Групповые операции над доменами",
    '__mailnames_global_changes' => "Групповые операции над учетными записями электронной почты",
    '__backup_manager' => 'Менеджер резервного копирования',
    '__domains_list' => "Домены",
    'domains_list__list_header' => "домены",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Имя домена начинается с www, хотя используется префикс WWW.\nПродолжить?",
    '__dovecot' => 'IMAP- и POP3-сервер Dovecot',
    '__dsmail' => "Почтовая служба",
    '__dsmaillist' => "Служба списков рассылки",
    '__dsr_db' => "БД",
    '__dsr_dname' => "Имя домена",
    '__dsr_du' => "ИДП",
    '__dsr_ma' => "А",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "СР",
    '__dsr_mn' => "Почтовое имя",
    '__dsr_pname' => "Имя клиента",
    '__dsr_sd' => "Субдомены",
    '__dsr_tr' => "Т",
    '__dsr_wu' => "WП",
    '__dumps_tot_size' => "Общий размер файлов резервных копий в локальном хранилище",
    '__email' => "Электронная почта",
    '__email_addr_is_invalid' => "Недопустимый адрес электронной почты.",
    '__enabled' => "включено",
    '__enter_cert_text' => "Введите содержимое сертификата",
    '__enter_size' => "Введите размер",
    '__exclusive' => "Выделенный",
    '__expiration_date' => "Срок действия",
    '__fax' => "Факс",
    '__file' => "Файл",
    '__file_is_empty' => "Файл пуст.",
    '__file_name' => "Имя файла",
    '__file_type' => 'Тип файла',
    '__filemanager' => "Менеджер файлов",
    '__filepath_is_empty' => "Укажите путь к файлу",
    '__files_list' => "Файлы",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Настройки FTP",
    '__ftp_serv' => "Сервер FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Сначала необходимо ввести свойства учетной записи FTP!",
    '__ftp_status' => "Статус сервера FTP",
    '__full_day0' => "Воскресенье",
    '__full_day1' => "Понедельник",
    '__full_day2' => "Вторник",
    '__full_day3' => "Среда",
    '__full_day4' => "Четверг",
    '__full_day5' => "Пятница",
    '__full_day6' => "Суббота",
    '__full_month1' => "Январь",
    '__full_month10' => "Октябрь",
    '__full_month11' => "Ноябрь",
    '__full_month12' => "Декабрь",
    '__full_month2' => "Февраль",
    '__full_month3' => "Март",
    '__full_month4' => "Апрель",
    '__full_month5' => "Май",
    '__full_month6' => "Июнь",
    '__full_month7' => "Июль",
    '__full_month8' => "Август",
    '__full_month9' => "Сентябрь",
    '__giga' => "Г",
    '__group' => "Группа",
    '__h' => "Х",
    '__hard_disk_quota' => "Дисковая квота",
    '__hard_disk_quota_not_supported' => 'квота жесткого диска не поддерживается из-за конфигурации файловой системы сервера',
    '__header_text_is_invalid' => "Неверно указано название защищенного раздела.",
    '__help_topic_not_found' => 'Страница справки, к которой вы обратились (%1), не существует.',
    '__hosting_ip_dns_ip_not_equiv' => "Ни один из IP-адресов, указанных в записях DNS типа А, не соответствует IP-адресу, используемому для хостинга.",
    '__hosting_scripting' => "Поддержка скриптов для хостинга",
    '__hosting_setup_page_title' => "Настройка физического хостинга для домена %1",
    '__hosting_title' => "Хостинг (%1)",
    '__hosting_type' => "Тип хостинга",
    '__hostname_is_empty' => "Пустое имя хоста.",
    '__hour(s)' => 'Час(ы)',
    '__hst_type_incorrect' => "Недопустимый тип хостинга.",
    '__http' => "HTTP", //indirect
    '__htype' => "Х",
    '__idle_time' => "Время бездействия",
    '__iface' => "Интерфейс",
    '__image' => "Изображение",
    '__imap_status' => "Статус сервера IMAP",
    '__in' => "Входящие",
    '__in_%' => "в %",
    '__incorrect_databases_login_pass' => "Вы указали неверные параметры доступа к PostgreSQL.",
    '__incorrect_ip_or_network_address' => 'Неверный IP-адрес или сеть.',
    '__info' => 'Информация',
    '__install' => "Установить",
    '__install_prefix' => "Префикс установки",
    '__invalid_cert_id' => "Неверный идентификатор сертификата",
    '__invalid_context' => "Неверный контекст: %1",
    '__invalid_db_usr_name' => "Неверное имя пользователя базы данных.",
    '__invalid_dir_name' => "Недопустимое имя папки",
    '__invalid_dom_name' => "Недопустимое имя домена.",
    '__invalid_filename' => "Недопустимое имя файла. Не используйте одинарные кавычки, и/или комбинацию \"../\".",
    '__invalid_id' => "Недопустимый идентификатор.",
    '__invalid_lines_num' => "Недопустимое количество строк, разрешены только цифры.",
    '__invalid_max_letter_size' => "Недопустимый максимальный размер сообщения.",
    '__invalid_pdir_name' => "Недопустимое имя защищенной папки.",
    '__invalid_restart_apache_interval' => "Недопустимый интервал для перезагрузки Apache.",
    '__invalid_tmpl_name' => "Недопустимое имя шаблона.",
    '__invalid_value' => "Недопустимое значение.",
    '__ip_addr' => "IP-адрес",
    '__ip_address_and_mask' => "IP-адрес и маска подсети",
    '__ip_alias__mask' => "IP-адрес и маска подсети",
    '__ip_addr_is_invalid' => "Недопустимый IP-адрес.",
    '__ip_addr_list' => "IP-адреса",
    '__ip_address_and_mask_hint' => 'Например, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "Кб",
    '__kbps' => "Кб/с",
    '__kbytes' => "Кбайт",
    '__key_for_virtuozzo_only' => "Ваш лицензионный ключ предназначен только для использования с контейнерами Virtuozzo.",
    '__key_limits_exceeding' => "Выполнение этой операции приведет к превышению ограничений, установленных в соответствии с лицензионным ключом. Если вы получили это сообщение, свяжитесь с вашим провайдером или производителем программного обеспечения, чтобы прояснить условия лицензии или приобрести более подходящий лицензионный ключ.",
    '__kilo' => "К",
    '__keywords' => 'Ключевые слова',
    '__lang_unknown' => 'Невозможно определить язык.',
    '__languages' => 'Язык',
    '__learn_more' => 'Подробнее',
    '__loading' => 'Загрузка...',
    '__locales' => "языков",
    '__lists' => "Списки рассылки",
    '__literal_bytes' => "Байт",
    '__processing' => "Пожалуйста, подождите.<br>Выполняется загрузка...",
    '__locale' => "Язык интерфейса",
    '__locale_is_not_defined' => "Язык интерфейса не определен.",
    '__local_server_mysql' => 'Локальный сервер MySQL',
    '__local_server_postgresql' => 'Локальный сервер PostgreSQL',
    '__local_server_mssql' => 'Локальный сервер MS SQL',
    '__log_and_statistics_files' => 'Файлы журнала и статистические отчеты',
    '__config_files' => 'Конфигурационные файлы',
    '__chroot_files' => 'Chrooted окружение',
    '__login' => "Логин %1",
    '__login1' => "Логин",
    '__login_disabled' => "Вход запрещен",
    '__login_enabled' => "Вход разрешен",
    '__login_incorrect' => "Неверное имя пользователя или пароль.",
    '__login_name' => "Имя пользователя %1",
    '__login_name_is_invalid' => "Неверное имя пользователя %1.",
    '__logon_time' => "Время входа в систему",
    '__ma' => "Почтовые псевдонимы",
    '__mail' => "Почта",
    '__mail_alias_name' => "Почтовый псевдоним",
    '__mail_autodiscovery' => 'Автообнаружение почты',
    '__mail_exchanger_name_is_invalid' => "Недопустимое имя почтового сервера.",
    '__mail_groups' => "Почтовые группы",
    '__mail_list_engine' => "Программное обеспечение списков рассылки",
    '__mail_name' => "Учетная запись почты",
    '__mail_name_form' => "Свойства учетной записи электронной почты",
    '__mail_names' => "Учетные записи почты",
    '__mail_serv' => "Почтовый сервер",
    '__mail_user' => 'Пользователь почты',
    '__mailgroup' => "Почтовая группа",
    '__maillist' => "Список рассылки",
    '__maillists' => "Списки рассылки",
    '__maillist_member' => 'Подписчик списка рассылки',
    '__mailname' => "Учетная запись почты",
    '__mailname_redir_self' => "Учетная запись почты не может перенаправлять почту на саму себя.",
    '__max_dom_num_reached_for_cl' => "Исчерпано максимальное количество доменов для этой учетной записи клиента.",
    '__max_file_size_available' => "Максимально допустимый размер файла %1",
    '__max_subdom_num_reached_for_cl' => "Исчерпано максимальное количество субдоменов для этой учетной записи клиента.",
    '__max_subdom_num_reached_for_dom' => "Исчерпано максимальное количество субдоменов для этого домена.",
    '__max_subdom_num_reached_for_key' => "Исчерпано максимальное количество субдоменов, разрешенное лицензией.",
    '__max_traffic_limit' => "Ограничение трафика",
    '__maximum_excl_ip_num' => "Учетные записи почты",
    '__mb' => "Mб",
    '__mbytes' => "мегабайт",
    '__mb_month' => "Mб/месяц",
    '__mb_sec' => "Мб/с",
    '__gb_sec' => "Гб/с",
    '__tb_sec' => "Тб/с",
    '__mega' => "М",
    '__minute(s)' => 'Минута(ы)',
    '__mls_not_in_key' => "Ваш ключ не поддерживает многоязыковой интерфейс.",
    '__modification_date' => "Дата изменения",
    '__module' => "Расширение",
    '__month' => "Месяц",
    '__month(s)' => "Месяц(ев)",
    '__month1' => "Янв",
    '__month10' => "Окт",
    '__month11' => "Ноя",
    '__month12' => "Дек",
    '__month2' => "Фев",
    '__month3' => "Мар",
    '__month4' => "Апр",
    '__month5' => "Май",
    '__month6' => "Июн",
    '__month7' => "Июл",
    '__month8' => "Авг",
    '__month9' => "Сент",
    '__monthly' => "Ежемесячно",
    '__months' => "месяцев",
    '__moved_permanently' => 'Перенесено постоянно',
    '__mssql' => "Сервер Microsoft SQL",
    '__mssql__server' => "Сервер",
    'mssql__server' => "Название сервера Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "невозможно изменить имя сервера: на сервере есть базы данных.",
    '__mssql_status' => "Статус сервера Microsoft SQL",
    '__multiply_login_deny' => "Не удается выполнить вход. Другой пользователь с таким же именем (%1) уже вошел в Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Статус сервера MySQL",
    '__mysql_version' => "Версия Mysql",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Статус сервера MariaDB",
    '__mariadb_version' => "Версия MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Статус сервера Percona",
    '__percona_version' => "Версия Percona",
    '__name' => "Имя",
    '__name_invalid' => "Недопустимое имя.",
    '__nameserver' => "сервер имен",
    '__network' => "Сеть",
    '__networks' => "Сети",
    '__no' => "Нет",
    '__no_ip_address_with_properly_type_available' => "Невозможно восстановить резервную копию, так как нет подходящего IP-адреса для восстановления.",
    '__no_clients_specified' => "Не указано ни одной учетной записи клиента.",
    '__no_comments' => "Нет комментариев.",
    '__nologin' => "Запрещенный",
    '__none' => "Нет",
    '__not_configured' => "Не настроено",
    '__not_implemented_yet' => "Не доступно",
    '__not_supported_by_ftp' => "(не поддерживается сервером FTP)",
    '__notification' => "Уведомление",
    '__num_displayed' => "%1 из %2",
    '__num_is_invalid' => "Неверный номер.",
    '__object_not_found' => 'Объект не найден: %1',
    '__of_all' => "% от всего",
    '__off' => "Выкл.",
    '__ok' => "OK",
    '__old_passwd' => "Старый пароль %1",
    '__on' => "Вкл.",
    '__others' => "Остальные",
    '__other_ip__will_be_added' => 'Другие доступные IP адреса (будут добавлены в IP пул клиента)',
    '__out' => "Исходящие",
    '__p' => "П",
    '__passwd' => "Пароль %1",
    '__passwd_is_invalid' => "Неверный пароль %1.",
    '__passwd_not_match' => "Пароли не совпадают!",
    '__path' => "Путь",
    '__perl_unix_support' => "Поддержка Perl",
    '__perl_win_support' => "Поддержка Perl",
    '__perm_denied' => "Доступ запрещен.",
    '__permissions' => "Права",
    '__personal_name' => "Личное имя",
    '__pg_admin_not_activated' => "PostgreSQL не был активирован на странице администрирования сервера.",
    '__pg_not_inst' => "PostgreSQL не установлен.",
    '__pg_not_run_or_inst' => "PostgreSQL не установлен или не запущен.",
    '__pg_not_support_in_key' => "PostgreSQL не поддерживается ключом.",
    '__phone' => "Телефон",
    '__phosting' => "Физический хостинг",
    '__php_support' => "Поддержка PHP",
    '__php_run_as_isapi' => "запустить как ISAPI-расширение",
    '__php_safe_mode' => "PHP 'safe_mode' включен",
    '__php_version' => "Версия PHP",
    '__physical' => "Физический хостинг",
    '__plesk_stat_pdir' => "Защитить папку '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Статистика домена",
    '__plesk_stat_protect' => "Защитить доступ к веб-статистике именем пользователя и паролем FTP",
    '__plesk_stat_protect_install' => "Хранить в защищенной паролем папке '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Статус сервера POP3",
    '__popen_error' => "Произошла ошибка при запросе функции popen.",
    '__port' => 'Порт',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Статус PostgreSQL:",
    '__preferences' => "Настройки",
    '__account_preferences' => "Настройки учетной записи",
    '__interface_preferences_general' => 'Общие',
    '__interface_preferences_default' => 'Настройки интерфейса по умолчанию',
    '__interface_preferences_admin' => "Настройки интерфейса администратора",
    '__interface_template' => 'Шаблон настроек интерфейса',
    '__interface_preferences' => "Настройки интерфейса",
    '__proceed?' => "Вы действительно хотите продолжить?",
    '__protect_dir_user' => "Пользователь защищенной папки",
    '__protect_dir_users' => "Пользователи защищенной папки",
    '__provider_contact_name' => "Контактное имя владельца",
    '__python_unix_support' => "Поддержка Python",
    '__python_win_support' => "Поддержка Python",
    '__quota' => "Квота",
    '__r' => "R",
    '__reconfigure' => "Перенастройка",
    '__record_type' => "Тип записи",
    '__release' => "Выпуск",
    '__remote_db_not_supported_by_key' => 'Удаленный хостинг баз данных не поддерживается Вашим лицензионным ключом.',
    '__remove' => "Удалить",
    '__remove_confirmation' => "Подтвердите удаление",
    '__remove_protection' => 'Снять защиту',
    '__report' => "Отчет",
    '__report_auto' => 'Расписание доставки',
    '__report_form' => "Отчет",
    '__report_size_na' => "Служба недоступна",
    '__reports_list' => "Отчеты",
    '__requested' => "Запрошено",
    '__required_fields' => "Обязательные поля",
    '__resp_name_invalid' => "Неверное имя автоответчика. Используйте только буквы, цифры, точки, подчеркивания и пробелы.",
    '__c' => "В", // Access to panel
    '__s' => "С",
    '__server_name_is_invalid' => "Неверное имя сервера.",
    '__screenshots' => 'Скриншоты',
    '__script_warning' => "В результате отключения поддержки скриптов для этого домена, все скрипты, при обращении к ним, будут отображаться в браузере простым текстом. Администратору рекомендуется удалить все соответствующие скрипты из этого домена.",
    '__sec' => "Секунд",
    '__second(s)' => "Секунда(ы)",
    '__see_list_of_logged_in' => "Посмотреть список пользователей, зарегистрированных в настоящий момент в системе.",
    '__select_certs_to_remove' => "Выберите подлежащие удалению сертификаты.",
    '__select_domains_to_default_host' => "Выберите домен для установки по умолчанию.",
    '__select_files_to_remove' => "Выберите файлы для удаления.",
    '__select_ip' => "Назначить IP-адрес",
    '__select_ip_to_remove' => "Выберите подлежащий удалению IP-адрес.",
    '__select_domain_template' => "Использовать настройки шаблона домена",
    '__select_templates_to_remove' => "Выберите подлежащие удалению шаблоны.",
    '__server' => "Сервер",
    '__server_total' => "Итого по серверу",
    '__service' => "Служба",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Сервер баз данных MySQL",
    '__service_description__mysql' => "Сервер баз данных MySQL",
    '__service_title__web' => "Веб-сервер",
    '__service_description__web' => "Веб-сервер",
    '__service_title__smtp' => "Сервер SMTP",
    '__service_description__smtp' => "Сервер SMTP",
    '__service_title__mail' => "Сервер IMAP/POP3",
    '__service_description__mail' => "Сервер IMAP/POP3",
    '__service_title__dns' => "Сервер DNS",
    '__service_description__dns' => "Сервер DNS",
    '__service_title__postgresq' => "Сервер баз данных PostgreSQL",
    '__service_description__postgresq' => "Сервер баз данных PostgreSQL",
    '__service_title__spamassassin' => "Антиспам SpamAssassin",
    '__service_description__spamassassin' => "Антиспам SpamAssassin",
    '__services' => "Службы",
    '__all_services' => "Все службы",
    '__sessions' => "Сеансы",
    'sessions__feature_ftp_session_manager_not_supported' => "Ваш сервер FTP не поддерживает функцию FTP Sessions.",
    '__sessions_list' => "Сеансы",
    '__set' => "Включить",
    '__shared' => "Общие",
    '__shell_access_warning' => "Разрешая shell-доступ к системе, вы ставите под угрозу ее безопасность. Разрешать доступ имеет смысл только, если вы понимаете, что делаете, и только для тех пользователей, которым доверяете. Вы действительно хотите разрешить доступ?",
    '__siteapp_not_support_in_key' => "Веб-приложения не поддерживаются лицензионным ключом",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Настройки этого веб-приложения были изменены вручную. Чтобы защитить внесенные вручную изменения, изменение настроек через Plesk было заблокировано.',
    '__site_management' => "Веб-публикация", // indirect
    '__size' => "Размер",
    '__skeleton' => 'Шаблон виртуального сервера',
    '__skins' => 'Темы',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Статус сервера SMTP",
    '__some_fields_are_empty_or_invalid' => "Некоторые поля пусты или содержат недопустимые значения.",
    '__unable_to_set_parameters' => "Не удалось установить параметры компонента",
    '__spamassassin' => "Антиспам",
    '__spamassassin_status' => "Статус SpamAssassin",
    '__spamd_status' => 'Статус антиспама',
    '__splited_backup' => "(многотомная резервная копия)",
    '__split_backup_file' => "Создать многотомную резервную копию",
    '__split_backup_size' => "Размер тома",
    '__split_backup_less_than_500' => "Тома размером менее 500 Мб не поддерживаются",
    '__ssi' => "SSI",
    '__ssi_support' => "Поддержка SSI",
    '__ssi_with_html' => "использовать SSI для файлов *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Поддержка SSL/TLS",
    '__same_ssl' => "Хранить файлы, доступные по SSL/TLS и не-SSL/TLS, в одной папке",
    '__same_ssl_cu' => "Общие SSL/TLS и не-SSL/TLS файлы",
    '__state' => "Область/регион",

    '__status__Active' => 'Активен',
    '__status__active' => 'активно',
    '__status__Passive' => 'Отключить',
    '__status__passive' => 'отключено',
    '__status__off' => 'отключено',
    '__status__with_parent' => 'отключено',
    '__status__backup_restore' => 'приостановлено на время резервного копирования или восстановления',
    '__status__admin' => 'приостановлено администратором сервера',
    '__status__resseler' => 'приостановлено реселлером',
    '__status__client' => 'приостановлено клиентом',
    '__status__unknown' => 'статус неизвестен',

    '__status_of' => "Статус %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Сервер Stunnel", // indirect
    '__subdomain' => "Субдомен",
    '__subdomain_name' => "Имя субдомена",
    '__subdomain_name_in_ASCII_form' => "Имя субдомена в кодировке ASCII",
    '__subdomains' => "Субдомены",
    '__domainaliases' => "Псевдонимы домена",
    '__subdomains_list' => "Субдомены",
    '__subdomains_not_support_in_key' => "Операции над субдоменами не поддерживаются лицензионным ключом",
    '__sys_user_type' => "Пользователь FTP",
    '__sys_user_type_main' => "FTP-пользователь основного домена",
    '__sys_user_type_native' => "Создать отдельную учетную запись FTP для субдомена",
    '__t' => "Тип",
    '__target_domain' => "Целевой домен",
    '__template' => "Шаблон",
    '__template_not_accepted' => "Шаблон не принят — нарушены установленные ограничения.",
    '__templates' => "Шаблоны",
    '__templates_list' => "Шаблоны",
    '__tera' => "Тип",
    '__title' => "Название",
    '__tools' => "Инструменты",
    '__total' => "Итого %1",
    '__total_size' => "Совокупный размер",
    '__total_used' => "Всего использовано",
    '__traffic' => "Трафик",
    '__traffic_by_client' => "Трафик клиента",
    '__traffic_by_domain' => "Трафик домена",
    '__traffic_by_service' => "Трафик сервисов",
    '__traffic_history' => "Статистика трафика",
    '__unable_change_locale' => "Невозможно изменить язык интерфейса: %1",
    '__unable_create_new_dom' => "Невозможно создать домен: %1",
    '__unable_define_dom_name' => "Невозможно определить имя домена: %1",
    '__unable_define_necessary_properties' => "Невозможно установить необходимые настройки.",
    '__unable_define_properties' => "Невозможно определить свойства %1",
    '__unable_exec_util' => "Невозможно запустить утилиту: %1",
    '__unable_get_dns_a_recs' => "Невозможно найти IP-адреса записей DNS типа \"А\" для этой учетной записи хостинга: %1",
    '__unable_get_mbox_quota' => "Невозможно получить сведения о допустимом объеме почтового ящика.",
    '__unable_redirect_to_myself' => "Невозможно выполнить перенаправление на ту же самую учетную запись.",
    '__unable_redirect_to_my_alias' => "Невозможно перенаправить почту на почтовый псевдоним.",
    '__default_domain_redirect_to_myself' => "Домен невозможно сделать доменом по умолчанию для IP-адреса:\n обнаружено перенаправление на себя",
    '__unable_remove_client' => "Невозможно удалить клиента: %1",
    '__unable_set_up_mbox_quota' => "Невозможно установить ограничение на объем почтового ящика: %1",
    '__unable_setup_pass' => "Невозможно установить пароль: %1",
    '__unable_to_create_new_account' => "Невозможно создать учетную запись: %1",
    '__unable_to_define_db_size' => "Невозможно определить размер базы данных.",
    '__unable_to_enable_short_names' => "Невозможно разрешить использование коротких имен учетных записей электронной почты для учетных записей POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Невозможно принять введенные данные: %1",
    '__unable_to_open_file' => "Невозможно открыть файл %1: %2",
    '__unable_to_update_subdomain' => "Невозможно внести изменения в настройки субдомена %1",
    '__unable_update_cl_data' => "Невозможно сохранить изменения для учетной записи пользователя: %1",
    '__unable_update_db_params' => "Невозможно сохранить параметры базы данных: %1",
    '__unable_update_dom_data' => "Невозможно изменить данные домена: %1",
    '__undefined' => "не определено",
    '__uninstall' => "Удаление",
    '__unknown_error' => "Неизвестная ошибка",
    '__unlimited_lower' => "Без ограничений",
    '__unset' => "Отключить",
    '__update' => "Обновить",
    '__uploaded_file_is_invalid' => "Загружен недействительный файл: %1",
    '__url' => "URL-адрес",
    '__usage' => "Использование диска",
    '__user' => 'Пользователь',
    '__user_already_logged' => "Другой пользователь с таким же именем (%1) уже вошел в Plesk.",
    '__version' => "Версия",
    '__aps_license' => "Ключ лицензии",
    '__vh_type' => "Тип виртуального сервера",
    '__vhosts_apache_status' => "Статус Веб-сервера",
    '__wrong_charset_conversion' => 'Неверная кодировка; преобразование "%1" в "%2" недоступно',
    '__warning_' => "Внимание!",
    '__warning_excl_ip_num' => "Выделенный IP-адрес",
    '__warning_expiration' => "Срок действия",
    '__web_scripting' => "Веб-скрипты", // indirect
    '__web_serv' => "Веб-сервер", // indirect
    '__web_statistic' => "Веб-статистика", // indirect
    '__webmail' => "Веб-почта", // +indirect
    '__webstat_not_installed' => "Webalizer не установлен на сервере. Обратитесь за помощью к вашему сервис-провайдеру.",
    '__webstat_support' => "Веб-статистика",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "При переходе с одной программы для учета статистики на другую все предыдущие отчеты удаляются, и вместо них создаются новые — на основе хранящихся на сервере журналов. Это означает, что если у вас включено хранение журналов только за последний месяц (Домены > имя домена > Менеджер журналов > Ротация журналов), то веб-статистика будет доступна тоже только за последний месяц. Перейти на другую программу учета статистики?",
    '__webstat_perm_denied' => 'У вас нет прав для управления веб-статистикой.',
    '__webuser' => "Веб-пользователь",
    '__sysusers_list' => "Системные пользователи",
    '__sysuser' => "Системный пользователь",
    '__weekly' => "Неделя",
    '__whats_new_in_version' => "Что нового в Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Эта операция доступна только для доменов с веб-хостингом.",
    '__wrong_hosting_type__none' => 'Веб-хостинг не настроен на домене %1.',
    '__wrong_hosting_type__std_fwd' => 'На домене %1 настроено стандартное перенаправление. Данная операция доступна только для доменов с веб-хостингом.',
    '__wrong_hosting_type__frm_fwd' => 'На домене %1 настроено перенаправление во фрейме. Данная операция доступна только для доменов с веб-хостингом.',
    '__wu' => "Веб-пользователи",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Префикс WWW был изменен. Не забудьте обновить SSL/TLS-сертификат.",
    '__year' => "Год",
    '__year(s)' => "Лет",
    '__yes' => "Да",
    '__you' => "Вы",
    '__zip_code' => "Почтовый индекс",
    '__form_normal' => "Обычная",
    '__form_advanced' => "Дополнительно",

    'admin_ed__edit_administrator_info' => "Изменение сведений об администраторе",
    'admin_ed__create_default_client' => "Я хочу создать учетную запись по умолчанию.",
    'admin_ed__unable_update' => "Изменить сведения об администраторе не удалось: %1",

    'auth__update_admin_info' => "Пожалуйста, обновите сведения об администраторе. Эти сведения нужны для работы с %1.",
    'auth__you_not_have_perm' => "Вам запрещено управлять этим доменом.",
    'auth__key_expired_admin' => 'Закончился срок действия вашей лицензии на Plesk. Чтобы продолжать использовать Plesk, обновите вашу лицензию или купите новую.',
    'auth__key_expired_admin_restricted' => 'Закончился срок действия вашей лицензии на Plesk. Обратитесь к вашему сервис-провайдеру, чтобы продолжить работу c Plesk.',
    'auth__key_expired_client' => 'Срок действия лицензии на Plesk истек. Пожалуйста, свяжитесь со своим хостинг-провайдером.',
    'autoinstaller__not_installed' => 'Автоматический установщик не установлен.',
    'autoinstaller__release_action' => 'Доступные операции',
    'autoinstaller__release_action_icon' => 'С',
    'autoinstaller__release_action_upgrade' => 'Обновление до новой версии Plesk',
    'autoinstaller__release_action_update' => 'Обновление или добавление новых компонентов',
    'autoinstaller__release_action_up2date' => 'У вас установлена актуальная версия',
    'autoinstaller__component_action' => 'Статус',
    'autoinstaller__component_action_icon' => 'С',
    'autoinstaller__component_action_install' => 'Не установлен',
    'autoinstaller__component_action_update' => 'Обновления доступны',
    'autoinstaller__component_action_upgrade' => 'Доступно обновление',
    'autoinstaller__component_action_up2date' => 'У вас установлена актуальная версия',
    'autoinstaller__component_action_error' => 'Обновления недоступны',
    'autoinstaller__component_serverbuildtime' => 'Последний выпуск',
    'autoinstaller__component_localbuildtime' => 'Выпуск вашего компонента',
    'autoinstaller__component_installed_version' => 'Ваша версия',
    'autoinstaller__component_available_version' => 'Последняя версия',
    'autoinstaller__component' => 'Компонент',
    'autoinstaller__components' => 'Компоненты',
    'autoinstaller__components_title' => '%1 компонентов',
    'autoinstaller__component_dependency_note' => 'необходимо для установки выбранных компонентов',
    'autoinstaller__install_confirm' => 'Да, я хочу установить эти компоненты',
    'autoinstaller__install_confirm_request' => 'Для подтверждения установите этот флажок',
    'autoinstaller__install_title' => 'Подтверждение установки выбранных компонентов',
    'autoinstaller__key_update_confirm' => 'Подтвердите пропуск обновления ключа и установку ключа по умолчанию',
    'autoinstaller__key_update_confirm_request' => 'Для подтверждения установите этот флажок.',
    'autoinstaller__key_update_failed' => '<p> Plesk не может обновить лицензию.</p> <p> %1</p> <p> Если обновление продукта будет продолжено без соответствующей лицензии, будет установлена лицензия по умолчанию с ограниченной функциональностью. Администраторам рекомендуется приобрести соответствующую лицензию, прежде чем продолжить обновление продукта.</p>',
    'autoinstaller__email' => 'Получатель уведомления',
    'autoinstaller__email_admin' => "Адрес электронной почты администратора",
    'autoinstaller__email_email' => 'Другой адрес электронной почты...',
    'autoinstaller__release' => 'Название выпуска',
    'autoinstaller__releases' => 'Доступные выпуски',
    'autoinstaller__releases_title' => 'Программа обновления Plesk',
    'autoinstaller__select_components_to_install' => 'Выберите, какие компоненты необходимо установить',
    'autoinstaller__status_error' => 'Ошибка: %1',
    'autoinstaller__status_install_error' => 'Невозможно начать установку: %1.',
    'autoinstaller__status_install_busy' => 'Невозможно начать установку: в настоящий момент устанавливается другой компонент.',
    'autoinstaller__status_install_ok' => 'Установка началась. Вы будете получать уведомления о ходе установки на свой адрес электронной почты (%1).',
    'autoinstaller__status_query_busy' => 'Установка выполняется.',
    'autoinstaller__status_query_error' => 'Получить статус установки не удалось: %1',
    'autoinstaller__status_unknown' => 'Получить статус автоматической установки не удалось.',
    'autoinstaller__status_busy' => 'Автоматический установщик занят. Пожалуйста, подождите.',
    'autoinstaller__configure_title' => 'Настройки программы обновления',
    'autoinstaller__preferences_legend' => 'Настройки',
    'autoinstaller__target' => 'Временная папка для загрузки',
    'autoinstaller__target_invalid' => "Укажите абсолютный путь",
    'autoinstaller__check_updates' => 'Проверять обновления при входе администратора в Plesk',
    'autoinstaller__check_updates_warning' => 'Новые <a href="%1">обновления</a> доступны для %2',
    'autoinstaller__source_type' => 'Тип источника',
    'autoinstaller__source' => 'URL источника',
    'autoinstaller_source__preferences_legend' => 'Настройки',
    'autoinstaller_source__type' => 'Тип источника',
    'autoinstaller_source__url_invalid' => 'Неверный источник',
    'autoinstaller_source__url_invalid_network' => 'Неверный адрес источника (например: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL источника',
    'autoinstaller__source_invalid_network' => 'Вы указали неверный сетевой адрес',
    'backup__repository' => 'Местонахождение хранилища файлов резервных копий',
    'backup__error_notify_email' => 'Сообщать об ошибках на этот адрес',
    'backup__dump_info' => "Сведения о резервной копии.",
    'backup__dump_file_name_not_defined' => "Не указано имя резервного файла",
    'backup__local_file' => 'Локальный файл резервной копии',
    'backup__domain_ftp' => 'удаленный FTP-сервер',
    'backup__wrong_path' => "Неверный путь к хранилищу файлов резервных копий: не используйте последовательность символов ../../",
    'backup__unable_to_connect_to_ftp_server' => "Соединение с ftp сервером невозможно: %1",
    'backup__unable_to_read_file' => 'Невозможно прочитать файл резервной копии.',
    'backup__backup_task_does_not_exist' => "Задача резервного копирования не существует, вам нужно сначала создать ее.",
    'backup__restore_params' => "Параметры восстановления",
    'backup__confirmation' => "Предупреждение: домен будет недоступен во время резервного копирования/восстановления.",
    'backup__backup_method' => 'Метод резервного копирования',
    'backup__dumpfile_name' => "Имя файла резервной копии",
    'backup__dumpfile_name_is_invalid' => "Недопустимое имя файла резервной копии: используйте только алфавитно-цифровые символы, символы дефиса, точки и подчеркивания. Не используйте для файлов резервных копий такие имена, как description.*.",
    'backup__email_required' => "Чтобы сообщать вам о ходе резервного копирования и восстановления, нам необходим ваш адрес электронной почты. Пожалуйста, укажите его в свойствах учетной записи.",
    'backup__error_during_backup' => "Невозможно создать резервную копию: %1",
    'backup__input_email_warning' => "Или укажите адрес электронной почты для отправки уведомлений, или снимите этот флажок.",
    'backup__make_download' => "не сохранять файл резервной копии в хранилище, только скачать его",
    'backup__make_dump' => 'создать файл резервной копии и сохранить в локальном хранилище',
    'backup__makedump_to_ftp' => 'создать файл резервной копии и сохранить его на FTP сервере',
    'backup__restore_ip' => "IP-адрес для восстановления",
    'backup__select_dumpfile' => "Выберите файл резервной копии.",
    'backup__time' => "Время создания резервной копии",
    'backup__day' => 'День создания резервной копии',
    'backup__view_dump_info' => "Просмотр сведений о резервной копии домена %1",
    'backup__wrong_domain_name' => "Файл резервной копии содержит данные домена %1 и не может быть восстановлен на домене %2",
    'backup__incorrect_ftp_user_or_passwd' => "Неверное имя или пароль FTP-пользователя. Пожалуйста, измените свойства учетной записи FTP.",
    'backup__access_denied' => "Доступ запрещен. Пожалуйста, измените свойства учетной записи FTP",
    'backup__restore_from' => "Восстановить %1",
    'backup__domain_session_failed' => 'Резервная копия для домена %1 не была создана',
    'backup__client_session_failed' => 'Резервная копия клиента %1 не была создана',
    'backup__domain_session_restore_failed' => 'Домен %1 не был восстановлен',
    'backup__client_session_restore_failed' => 'Клиент %1 не был восстановлен',
    'backup__domain_session_complete' => 'Резервная копия для домена %1 создана',
    'backup__domain_session_backup' => 'Резервное копирование домена %1',
    'backup__client_session_backup' => 'Резервное копирование клиента %1',
    'backup__domain_stop_title' => 'Отмена резервного копирования домена %1',
    'backup__client_stop_title' => 'Отмена резервного копирования клиента %1',
    'backup__domain_restore_stop_title' => 'Отмена восстановления домена %1',
    'backup__client_restore_stop_title' => 'Отмена восстановления клиента %1',
    'backup__domain_session_backup_stop' => 'Вы собираетесь отменить активный процесс резервного копирования. Файл резервной копии не будет создан.',
    'backup__backup_stop_confirm' => 'Да, я хочу остановить резервное копирование',
    'backup__restore_stop_confirm' => 'Да, я хочу остановить процесс восстановления',
    'backup__domain_session_restore' => 'Восстановление домена %1',
    'backup__domain_session_restore_stop' => 'Вы собираетесь отменить активный процесс восстановления.',
    'backup__domain_backup_file_info' => 'Информация о файле резервной копии домена',
    'backup__domain_backup_file_list' => 'существующие файлы резервных копий',
    'backup__domain_backup_progress' => 'Прогресс резервного копирования сайта %1',
    'backup__domain_restore_progress' => 'Прогресс восстановления сайта %1',
    'backup__domain_backup_progress_elapsed_time' => 'Осталось времени: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Осталось времени: %1',
    'backup__ip_map_legend' => 'Сопоставление IP-адресов',
    'backup__ip_map_list_count' => 'IP-адреса',
    'backup__domain_restore_session_complete' => 'Домен %1 восстановлен.',
    'backup__domain_restore_session_complete_message' => 'Домен %1 восстановлен.',
    'backup__domain_backup_file_delete' => 'Данные файлы резервных копий будут удалены:',
    'backup__domain_backup_file_for_remove' => 'Выберите файлы резервных копий, которые необходимо удалить',
    'backup__backup_overwrite_file_confirm' => 'Подтверждение замены',
    'backup__backup_overwrite_file_confirm_text' => 'Файл резервной копии с именем "%1" уже существует. Заменить его?',
    'backup__backup_confirm_overwrite' => 'Подтвердите замену файла',
    'backup__backup_overwrite_legeng' => 'Заменить',
    'backup__backup_not_contain_domain' => 'Резервная копия не содержит информации о домене %1',
    'backup__backup_not_contain_client' => 'Резервная копия не содержит информации о клиенте %1',
    'backup__backup_client_info' => "Резервное копирование настроек и учетных данных клиента",
    'backup__client_backup_progress' => 'Прогресс резервного копирования клиента %1',
    'backup__client_session_complete' => 'Резервная копия клиента %1 создана',
    'backup__client_backup_file_info' => 'Информация о файле резервной копии клиента',
    'backup__restore_client_info' => "Восстановить настройки и учетные данные клиента",
    'backup__client_session_restore' => 'Восстановление клиента %1',
    'backup__client_db_server_map' => 'Установка соответствия серверов баз данных',
    'backup__domain_db_server_map' => 'Установка соответствия серверов баз данных',
    'backup__client_restore_session_complete_message' => 'Клиент %1 восстановлен.',
    'backup__client_restore_session_complete' => 'Клиент %1 восстановлен.',
    'backup__restore_select_some' => 'Пожалуйста, выберите объекты для восстановления.',
    'backup__client_restore_progress' => 'Прогресс восстановления клиента %1',
    'backup__new_backup' => 'Создание нового файла резервной копии',
    'backup__done' => 'Готово:',
    'backup__done_domains' => '%1 доменов из %2',
    'backup__done_clients' => '%1 клиентов из %2',
    'backup__remaining' => 'Осталось:',
    'backup__remaining_domains' => '%1 домена(ов)',
    'backup__remaining_clients' => '%1 клиента(ов)',
    'backup__overall_backup_progress' => 'Общий прогресс резервного копирования',
    'backup__comment_n_a' => 'недоступно',
    'backup__command_ignore' => 'Команда "%1" не выполнена',
    'backup__no_objects' => 'Нет объектов для резервного копирования',
    'backup__cli_warning_not_enough_ip' => 'ПРЕДУПРЕЖДЕНИЕ: недостаточно IP-адресов для установки соответствий по умолчанию:',
    'backup__local_repository' => "Хранилище Plesk",
    'backup__ftp_repository' => 'FTP-хранилище',
    'backup__ftp_login' => 'Имя пользователя',
    'backup__ftp_password' => 'Пароль',
    'backup__ftp_directory_hint' => 'Пример: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'Настройки учетной записи FTP',
    'backup__ftp_account_preferences' => 'Настройки учетной записи FTP',
    'backup__repository_not_exist' => 'Папка не существует',
    'backup__repository_not_readable' => 'Указанная папка недоступна для чтения',
    'backup__ftp_repository_not_configure' => 'Чтобы использовать FTP-хранилище файлов резервных копий, сначала <a href="%1">укажите пользователя FTP</a>.',
    'backup__ftp_repository_list_not_configure' => 'Настройки учетной записи не были определены',
    'backup__repository_list_unable_listing' => 'Невозможно получить список файлов',
    'backup__ftp_repository_unable_listing' => 'Невозможно получить список файлов папки "%1":',
    'backup__repository_legend' => 'Хранилище резервных копий',
    'backup__store_in_repository' => 'Сохранить файлы в',
    'backup__local_repository_lable' => 'Локальное хранилище',
    'backup__ftp_repository_lable' => 'FTP-хранилище',
    'backup__ftp_repository_not_configure_hint' => '(настройки учетной записи не определены)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(учетная запись FTP не указана или не поддерживается)',
    'backup__ftp_directory_not_exist' => 'Указанная папка не существует',
    'backup__other_user_process_modified' => 'Процесс резервного копирования или перемещения данных был остановлен другим пользователем.',
    'backup__another_user_exist' => 'Выполняемая операция была запущена другим пользователем Plesk. Этот пользователь еще не вышел из Plesk.',
    'backup__ftp_repository_wait' => 'Пожалуйста, подождите: идет запрос сведений об FTP-хранилище',
    'backup__ftp_write_test_failed' => 'Не удалось записать тестовые данные в учетную запись FTP %1:',
    'backup__ftp_storage' => 'FTP(S)-хранилище',
    'bt_upload_to_repository' => 'Загрузить файлы в локальное хранилище',
    'bt_new_restore' => "Восстановить",
    'bt_backup_schedule' => "Запланировать резервное копирование",
    'backup_exist_backups' => "Существующие файлы резервных копий",
    'backup_dialog__page_title' => "Создание файла резервной копии",
    'backup_dialog__please_wait' => "Начинается резервное копирование. Эта операция может занять некоторое время. Пожалуйста, подождите...",
    'backup_conf__page_title' => 'Конфигурация резервного копирования',
    'bt_accept' => "Принять",
    'bt_access' => "Доступ",
    'bt_action_log' => "Журнал операций",
    'bt_add' => "Добавить",
    'bt_add_client' => "Назначить для пользователей",
    'bt_database_server_add' => 'Добавить сервер баз данных',
    'bt_add_services' => "Доп. услуги",
    'bt_anonftp_stats' => "Стат. анон.FTP",
    'bt_anonymous_ftp' => "Анонимный FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Прикрепить",
    'bt_autoinstaller' => 'Программа обновления',
    'bt_auto-updates' => 'Программа обновления',
    'bt_back' => "Назад",
    'bt_backup' => "Копировать",
    'bt_backup_configure' => "Настройки резервного копирования",
    'bt_buy_certs' => "Купить сертификаты",
    'bt_card' => "Карта",
    'bt_cert' => "Сертификат",
    'bt_certificates' => "Сертификаты",
    'bt_change_passwd' => "Изменить пароль",
    'bt_clear' => "Очистить",
    'bt_client_templates' => "Шаблоны клиентов",
    'bt_clients' => "Клиенты",
    'bt_codepage_change' => 'Изменить кодировку',
    'bt_comp_info' => "Компоненты",
    'bt_configure_maillists' => "Настройка Mailman",
    'bt_configure' => 'Настроить',
    'bt_copy' => "Копировать",
    'bt_copy_move' => "Копировать/переместить",
    'bt_create' => "Создать",
    'bt_create_account' => "Создать учетную запись",
    'bt_create_dir' => "Добавить папку",
    'bt_create_file' => "Добавить файл",
    'bt_count_size' => "Размер",
    'bt_crontab_unix' => "Планировщик cron",
    'bt_crontab_win' => "Планировщик задач",
    'bt_custom_button_new' => "Добавить кнопку",
    'bt_custom_buttons' => "Персональные кнопки",
    'bt_customize' => "Настроить",
    'bt_databases' => "Базы данных",
    'bt_database_servers' => 'Серверы баз данных',
    'bt_sqlservers' => "Серверы баз данных",
    'bt_db_usr_new' => "Добавить пользователя базы данных",
    'bt_db_new' => "Добавить базу данных",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "По умолчанию для DB Webadmin",
    'bt_decline' => "Отклонить",
    'bt_default' => "По умолчанию",
    'bt_defaultcomponents' => "Сторонние компоненты",
    'bt_defaults' => "Настройки по умолчанию",
    'bt_delete' => "Удалить",
    'bt_directories' => "Защищенные папки",
    'bt_disable' => "Отключить",
    'bt_dns_zone_sync' => 'Применить изменения шаблона DNS',
    'bt_dnsrecord_add' => 'Добавить запись',
    'bt_do_backup' => "Создать резервную копию",
    'bt_do_restore' => "Восстановить",
    'bt_do_upload' => "Загрузить",
    'bt_domain_aliases' => "Псевдонимы домена",
    'bt_domain_templates' => "Шаблоны доменов",
    'bt_domain_user' => "Администратор домена",
    'bt_domain_user_passwd' => "Пароль администратора домена",
    'bt_domains' => "Домены",
    'bt_domain_alias_add' => 'Добавить псевдоним домена',
    'bt_download' => "Скачать",
    'bt_edit' => "Изменить",
    'bt_enable' => "Включить",
    'bt_export' => 'Экспортировать',
    'bt_extras' => "Дополнительно",
    'bt_finish' => "Закончить",
    'bt_ftp_account' => "Свойства учетной записи FTP",
    'bt_forget_password' => "Забыли пароль?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Статистика FTP",
    'bt_get_password' => "Получить пароль",
    'bt_global_changes' => "Изменить",
    'bt_help' => "Справка",
    'bt_hide_aliases' => "Скрыть псевдонимы",
    'bt_hide_toolbar' => 'Спрятать панель инструментов',
    'bt_hide_subdomains' => "Скрыть субдомены",
    'bt_hide_domainaliases' => "Скрыть псевдонимы доменов",
    'bt_home' => "Главная",
    'bt_hosting' => "Хостинг",
    'bt_icf' => 'Брандмауэр',
    'bt_install' => "Установить",
    'bt_ip_aliasing' => "IP-адреса",
    'bt_ip_add' => "Добавить IP-адрес",
    'bt_ip_pool' => "IP-пул",
    'bt_key_info' => "Информация о лицензии",
    'bt_key_buyonline_addons' => 'Купить дополнения к Plesk',
    'bt_key_buyonline_upgrades' => 'Купить обновления к Plesk',
    'bt_key_buyonline_new' => 'Заказать новый ключ',
    'bt_limits' => "Ограничения",
    'bt_locale_add' => 'Добавить пакет локализации',
    'bt_locales' => 'Локали',
    'bt_log_manager' => "Менеджер журналов",
    'bt_login' => "Войти",
    'bt_logo' => "Фирменное оформление",
    'bt_logo_send_link' => "Прикрепить ссылку",
    'bt_logo_send_logo' => "Установить логотип",
    'bt_logout' => "Выход",
    'bt_logrotation' => "Ротация журналов",
    'bt_mail' => "Почта",
    'bt_mail_alias_add' => "Добавить почтовый псевдоним",
    'bt_mail_aliases' => "Почтовые псевдонимы",
    'bt_mail_group_add' => "Добавить участника",
    'bt_mail_groups' => "Группы",
    'bt_mail_name_add' => "Добавить учетную запись почты",
    'bt_mail_preferences' => "Настройки",
    'bt_mail_group' => "Почтовая группа",
    'bt_mail_mailbox' => "Почтовый ящик",
    'bt_mail_redirect' => "Перенаправление",
    'bt_mail_resp_add' => "Добавить автоответчик",
    'bt_mail_resp_attach_add' => "Добавить прикрепляемый файл",
    'bt_mail_resp_files' => "Прикрепляемые файлы",
    'bt_mail_responders' => "Автоответчики",
    'bt_mail_spamfilter' => "Антиспам",
    'bt_mail_webmail' => "Веб-почта",
    'bt_maillist_new' => "Добавить список рассылки",
    'bt_maillists' => "Списки рассылки",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Сделать копию",
    'bt_manage' => "Управление",
    'bt_master' => "Мастер",
    'bt_migrate' => 'Перенос',
    'bt_modules_add' => 'Добавить расширение',
    'bt_modules_manage' => 'Управление расширениями',
    'bt_move' => "Переместить",
    'bt_mimetypes' => 'Типы MIME',
    'bt_mimetype_new' => 'Добавить тип MIME',
    'bt_new_client' => "Добавить учетную запись клиента",
    'bt_new_domain' => "Добавить домен",
    'bt_next' => "Далее >>",
    'bt_next_page' => "Далее",
    'bt_network_add' => "Добавить сеть",
    'bt_notifications' => "Уведомления",
    'bt_off' => "Выкл.",
    'bt_on' => "Вкл.",
    'bt_on_off' => "Вкл/Выкл",
    'bt_pd_new' => "Добавить защищенную папку",
    'bt_pd_user_new' => "Добавить пользователя",
    'bt_performance' => 'Производительность',
    'bt_permissions' => "Права",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Настройки",
    'bt_prev_page' => "Назад",
    'bt_preview' => 'Предварительный просмотр сайта',
    'bt_print' => "Печатать",
    'bt_reboot' => "Перезагрузить",
    'bt_reload' => "Обновить",
    'bt_refresh' => "Обновить",
    'bt_register' => "Регистрация",
    'bt_remove' => "Удалить",
    'bt_enable_selected' => 'Включить',
    'bt_disable_selected' => 'Отключить',
    'bt_repair_ip' => "Восстановить IP",
    'bt_report' => "Отчет",
    'bt_report_auto' => 'Доставка отчета',
    'bt_report_auto_new' => 'Добавить расписание доставки',
    'bt_report_new' => "Добавить шаблон",
    'bt_reset' => "Сбросить",
    'bt_restart_services' => "Управление службами",
    'bt_save' => "Сохранить",
    'bt_send_by_email' => "Отправить по почте",
    'bt_send_file' => "Отправить файл",
    'bt_send_mail' => "Отправить почту",
    'bt_send_passwd' => "Отправить пароль",
    'bt_send_text' => "Отправить",
    'bt_server' => "Сервер",
    'bt_server_add' => "Добавить сервер",
    'bt_server_preferences' => "Настройки сервера",
    'bt_servers_list' => "Список серверов",
    'bt_sessions' => "Сеансы",
    'bt_set' => "Сохранить",
    'bt_set_as_default' => "Установить по умолчанию",
    'bt_setup' => 'Настройка',
    'bt_show_aliases' => "Показать псевдонимы",
    'bt_show_subdomains' => "Показать субдомены",
    'bt_show_domainaliases' => "Показать псевдонимы доменов",
    'bt_shutdown' => "Завершить",
    'bt_site_apppkgs' => "Хранилище приложений",
    'bt_site_apppool' => "Пул приложений",
    'bt_application-pool' => "Веб-приложения",
    'bt_site_apps' => "Веб-приложения",
    'bt_site_app_add' => "Установить приложение",
    'bt_site_builder' => "Поддержка Presence Builder",
    'bt_skeleton' => 'Шаблон виртуального сервера',
    'bt_skins' => 'Темы',
    'bt_skin_add' => 'Добавить тему оформления',
    'bt_skin_manual' => 'Custom Plesk Skins Reference', // not used
    'bt_skin_download' => 'Загрузить схему',
    'bt_skin_replace' => 'Обновить схему',
    'bt_skip' => 'Пропустить',
    'bt_spamassassin' => "Антиспам",
    'bt_spamassassin_train' => "Обучение",
    'bt_spamfilter' => "Антиспам",
    'bt_start' => "Запустить",
    'bt_stop' => "Остановить",
    'bt_recycle' => "Перезапустить",
    'bt_statistics' => "Статистика",
    'bt_subdomain_new' => "Добавить субдомен",
    'bt_subdomains' => "Субдомены",
    'bt_submit' => "Принять",
    'bt_summary_report' => "Сводный отчет",
    'bt_support' => "Поддержка",
    'bt_switch' => "Переключить",
    'bt_system_time' => "Системное время",
    'bt_task_new' => "Добавить задачу",
    'bt_dom_tmpl_add' => 'Добавить шаблон домена',
    'bt_cl_tmpl_add' => 'Добавить шаблон клиента',
    'bt_cron_backup' => 'Настройки запланированного копирования',
    'bt_test' => "Проверка соединения",
    'bt_text' => "Текст",
    'bt_touch' => "Изменить временную метку",
    'bt_traffic' => "Трафик",
    'bt_traffic_history' => "Статистика по трафику",
    'bt_update' => "Обновить",
    'bt_upload' => "Загрузить",
    'bt_upload_from_ftp' => "Загрузить с FTP",
    'bt_virtualdirs' => 'Виртуальные папки',
    'bt_virtualdir_new' => 'Добавить виртуальную папку',
    'bt_virtualdir_add' => 'Добавить виртуальную папку',
    'bt_web_app_new' => "Установить Java-приложение",
    'bt_web_stats' => "Веб статистика",
    'bt_web_stats_ssl' => "Веб статистика SSL/TLS",
    'bt_web_user_add' => "Добавить веб-пользователя",
    'bt_web_users' => "Веб-пользователи",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Посмотреть полный список изменений",
    'cert_add__unable_set_ca_cert' => "Невозможно установить корневой сертификат: %1",
    'cert_add__unable_set_cert' => "Невозможно установить сертификат: %1",
    'cert_add__unable_set_private_key' => "Невозможно установить секретный ключ: %1",
    'certificates_list__certificate_used_as_default' => "Один из сертификатов, которые вы собираетесь удалить, используется как сертификат по умолчанию.",
    'certificates_list__certificates_assigned_on_ip' => "Один или несколько сертификатов назначены IP-адресам/доменам.",
    'ch_pass__admin_pass' => "Изменение пароля администратора",
    'ch_pass__old_pass' => "Старый пароль",
    'ch_pass__pass_confirm' => "Подтвердить",
    'ch_pass__unable_change_admin_pass' => "Не удалось изменить пароль администратора.%1",
    'check_mail_cycle__aliases' => "Обнаружено зацикливание почты, адрес \"%1\" содержится в псевдонимах этой учетной записи почты.",
    'check_mail_cycle__autoresponders' => "Обнаружено зацикливание почты, адрес \"%1\" содержится в автоответчиках этой учетной записи почты.",
    'check_mail_cycle__mail_groups' => "Обнаружено зацикливание почты, адрес \"%1\" содержится в почтовой группе этой учетной записи почты.",
    'check_mail_cycle__mail_name' => "Обнаружено зацикливание почты, адрес \"%1\" совпадает с этой учетной записью электронной почты.",
    'check_mail_cycle__redirect' => "Обнаружено зацикливание почты, адрес \"%1\" совпадает с адресом перенаправления для этой учетной записи почты.",
    'check_mail_dup__redirect' => "Обнаружено дублирование перенаправления, адрес \"%1\" совпадает с адресом перенаправления для этой учетной записи почты.",
    'check_mail_dup__mail_groups' => "Обнаружено дублирование перенаправления, адрес \"%1\" содержится в почтовой группе этой учетной записи почты.",
    'check_maillist_cycle__admin' => "Адрес электронной почты администратора \"%1\" совпадает с адресом списка рассылки.",
    'check_maillist_cycle__member' => "Обнаружено зацикливание почты, адрес \"%1\" совпадает с адресом списка рассылки.",
    'chk_js__enter_login_and_passwd' => "Введите имя пользователя и пароль.",
    'chk_js__enter_login_name' => "Введите имя пользователя.",
    'chk_js__enter_passwd' => "Введите пароль.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Сведения о клиенте %1",
    'cl_limits__cl' => "Ограничения клиента %1",
    'cl_logo__setup_logo_pref' => "Настройка логотипа для клиента %1",
    'cl_new__enter_new_cl_data' => "Введите сведения о новом клиенте:",
    'cl_new__unable_to_sent_notification' => 'Учетная запись пользователя была создана, однако отправить уведомление клиенту не удалось: %1',
    'cl_perm__all_ip' => "Все доступные IP-адреса",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Все учетные записи хостинга на базе IP-адресов, принадлежащие клиенту, будут преобразованы в учетные записи хостинга на базе имен.",
    'cl_perm__allow_client_create_domain' => "Поля, которые вы пытаетесь выбрать, применимы только к тем клиентам, которым разрешено создавать домены.",
    'cl_perm__allow_create_nb_w_ip' => "Клиент может создавать хостинг на базе имен с помощью %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Разрешить создание учетных записей хостинга на базе IP-адресов",
    'cl_perm__available_ips' => "Доступные IP-адреса",
    'cl_perm__change_limits' => "Настройка ограничений",
    'cl_perm__cl_disk_space' => "Совокупное дисковое пространство",
    'cl_perm__cl_expiration' => "Срок действия учетной записи клиента",
    'cl_perm__cl_max_box' => "Почтовые ящики",
    'cl_perm__cl_max_db' => "Базы данных",
    'cl_perm__cl_max_dom' => "Домены",
    'cl_perm__cl_max_maillists' => "Списки рассылки",
    'cl_perm__cl_max_subdom' => "Субдомены",
    'cl_perm__cl_max_traffic' => "Общий объем доступного трафика",
    'cl_perm__cl_max_wu' => "Веб-пользователи",
    'cl_perm__cl_mbox_quota' => "Ограничение размера почтового ящика для этой учетной записи пользователя",
    'cl_perm__current_maximum_exp_date' => "Текущее максимальное значение срока действия домена %1; запрошено %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Текущая квота на объем почтовых ящиков для данного пользователя %1; вы запрашиваете %2",
    'cl_perm__current_total_requested' => "Текущее совокупное значение ограничений домена для %1 составляет %2; запрошено %3.",
    'cl_perm__current_total_requested_dom' => "Текущее количество %1 данного клиента составляет %2; запрошено %3",
    'cl_perm__disk_space' => "Максимальный объем дискового пространства",
    'cl_perm__dashboard_stdgui' => 'Пользовательский интерфейс',
    'cl_perm__dashboard' => 'Режим "Домашней страницы"',
    'cl_perm__stdgui' => 'Стандартный режим просмотра',
    'cl_perm__manage_dashboard' => 'Управление Домашней страницей',
    'cl_perm__dashboard_and_stdgui' => 'Разрешены режим "Домашней страницы" и стандартный режим',
    'cl_perm__dashboard_only' => 'Разрешен только режим "Домашней страницы"',
    'cl_perm__stdgui_only' => 'Разрешен только стандартный режим',
    'cl_perm__edit_cl' => "Права клиента %1",
    'cl_perm__exp_date_exceeded' => "Срок действия, который вы пытаетесь установить, превышает ограничение, установленное на уровне отдельных доменов этого клиента.",
    'cl_perm__invalid_value' => "Недопустимое значение, разрешены только цифры.",
    'cl_perm__limit_disk_space' => "%1 Ограничить совокупный объем дискового пространства",
    'cl_perm__limit_expiration' => "%1 Ограничить срок действия учетной записи клиента",
    'cl_perm__limit_max_box' => "%1 Ограничить количество почтовых ящиков",
    'cl_perm__limit_max_db' => "%1 Ограничить количество баз данных",
    'cl_perm__limit_max_dom' => "%1 Ограничить количество доменов",
    'cl_perm__limit_max_maillists' => "%1 Ограничить количество списков рассылки",
    'cl_perm__limit_max_subdom' => "%1 Ограничить количество субдоменов",
    'cl_perm__limit_max_traffic' => "%1 Ограничить суммарный трафик",
    'cl_perm__limit_max_wu' => "%1 Ограничить количество веб-пользователей",
    'cl_perm__limit_mbox_quota' => "%1 Установить квоту почтового ящика",
    'cl_perm__limits_exceeded' => "Устанавливаемые ограничения уже превышены ограничениями, установленными на отдельных доменах клиента. Сумма ограничений должна быть больше или равняться сумме ограничений, установленных для отдельных доменов клиента.",
    'cl_perm__mailbox_quota_exceeded' => "Ограничение на объем почтового ящика, которое вы пытаетесь установить, превышает значение ограничения, установленное на отдельных доменах клиента.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Ограничение на объем дискового пространства, выделенного для почтовых ящиков, которое вы пытаетесь установить, превышает ограничение, установленное на уровне сервера.",
    'cl_perm__make_dumps' => "Резервное копирование и восстановление данных",

    'cl_perm__max_box' => "максимальное количество почтовых ящиков",
    'cl_perm__max_db' => "максимальное количество баз данных",
    'cl_perm__max_dom' => "домены",
    'cl_perm__max_maillists' => "максимальное количество списков рассылки",
    'cl_perm__max_subdom' => "субдомены",
    'cl_perm__max_traffic' => "максимально допустимый объем трафика",
    'cl_perm__max_wu' => "максимальное количество веб-пользователей",
    'cl_perm__max_dom_aliases' => "псевдонимы домена",
    'cl_perm__mbox_quota' => "квота почтового ящика",
    'cl_perm__not_allow_create_nb_hst' => "Клиент не может создавать хостинг на базе имен.",
    'cl_perm__this_ip_used_vrt_hst' => "Этот IP-адрес используется для виртуального хостинга. Чтобы удалить этот IP-адрес, сначала удалите хостинг или измените его тип на \"По имени\".",
    'cl_perm__unable_off_ipb_creating' => "Для этого клиента уже настроен хостинг на базе IP-адреса. Чтобы отключить эту функцию для клиента, снимите флажок \"Создание доменов\" или удалите все учетные записи хостинга на базе IP-адреса.",
    'cl_perm__unable_off_nb_creating' => "Для этого клиента уже настроен хостинг по имени. Чтобы отключить эту функцию для клиента, снимите флажок \"Создание доменов\" или удалите все учетные записи хостинга на базе имен.",
    'cl_perm__unable_set_domain_limit' => "Невозможно установить ограничение на количество доменов: у клиента уже %1 доменов",
    'cl_perm__unable_update_client_limitations' => "Невозможно изменить ограничения учетной записи клиента: %1",
    'cl_pref__edit_cl' => "Настройки клиента %1",
    'class_anonftp__create_ftp_domain' => "Для этого dom_id FTP сервера не существует, попробуйте сначала создать его.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Ограничение на дисковое пространство, которое вы пытаетесь установить (%1), не должно превышать ограничение на общее дисковое пространство, определенное на уровне домена (%2).",
    'class_anonftp__invalid_input_only_digits' => "Недопустимое значение, разрешены только цифры.",
    'class_anonftp__unable_change_ownerships' => "Невозможно изменить принадлежность или права на файл квоты: %1",
    'class_anonftp__unable_copy_quota_file' => "Невозможно скопировать файл квоты: %1",
    'class_anonftp__unable_get_disk_usage' => "Невозможно получить сведения об использовании дискового пространства папкой incoming: %1",
    'class_anonftp__unable_parse_quota_file' => "Невозможно распознать файл квоты.",
    'class_anonftp__unable_read_quota_file' => "Невозможно прочитать файл квоты: %1",
    'class_anonftp__unable_update_quota' => "Невозможно изменить квоту: файлы в папке incoming используют %1 Кб дискового пространства, что превышает новое значение квоты.",
    'class_anonftp__unable_write_temp_file' => "Невозможно записать во временный файл: %1",
    'class_bsdomain__warn_max_date__' => "В качестве окончания срока действия была установлена дата %1",
    'class_cList__empty' => "Список пуст.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Не найдено совпадений для <b>\"%1\"</b> в %2 (%3 из %4)",
    'class_cList__search_result' => "Результат поиска <b>\"%1\"</b> в %2 (%3 из %4)",
    'class_client__client_creation_notification' => "Уведомление о создании клиента.",
    'class_client__client_with_contact_name_already_exists' => "Клиент с именем %1 уже существует.",
    'class_client__disk_space' => "Диск",
    'class_client__invalid_max_dom' => "Недопустимое значение, разрешены только цифры.",
    'class_client__limit_exceed' => "Невозможно выделить запрошенный объем %1, так как это приведет к превышению объема выделенных для учетной записи клиента %2 ресурсов (%3). Если требуется выделить больше ресурсов, установите требуемое значение в разделе \"Клиенты\" > имя клиента > \"Ограничения\". Затем вернитесь на эту страницу и повторите попытку выделения ресурсов.",
    'class_client__limit_exceed_unlimited' => "Если вы хотите выделить неограниченный объем ресурсов (%1), сначала перейдите в раздел \"Клиенты\" > имя клиента > \"Ограничения\" и поставьте флажок \"Неограниченно\" напротив нужного типа ресурсов. Затем вернитесь на эту страницу и снова попытайтесь выделить ресурсы.",
    'class_client__max_box' => "Почтовые ящики",
    'class_client__max_db' => "Базы данных",
    'class_client__max_maillists' => "Списки рассылки",
    'class_client__max_subdom' => "Субдомены",
    'class_client__max_traffic' => "Максимальный трафик",
    'class_client__max_wu' => "Веб-пользователи",
    'class_client__max_dom_aliases' => "Псевдонимы домена",
    'class_client__mbox_quota' => "Квота почтового ящика",
    'class_client__unable_define_cl_status' => "Невозможно определить статус клиента: %1",
    'class_client__unable_define_inactive_dom' => "Невозможно определить неактивные домены %1.",
    'class_client__unable_del_ip' => "Невозможно удалить IP-адрес(а): %1",
    'class_db__db_name_not_set' => "Название базы данных не установлено.",
    'class_db__db_not_exist_for_curr_dom' => "В этом домене нет ни одной базы данных.",
    'class_db__invalid_db_or_dom_name' => "Неправильный идентификатор домена или базы данных, или имя базы данных не определено.",
    'class_db__invalid_pass' => "Неверный пароль.",
    'class_db__mailgrp_member_exist' => "Член почтовой группы уже существует.",
    'class_db__access_hosts_notsupport' => 'Для этого типа базы данных создание списка разрешенных для доступа хостов недопустимо',
    'class_db__unable_add' => 'Не удалось добавить запись для доступа хоста: %1',
    'class_db__unable_del' => 'Не удалось удалить запись для доступа хоста: %1',
    'class_db__inc_user_not_exist' => 'Пользователь базы данных "%1" не существует',
    'class_db__inc_access_record_exist' => 'Такая запись для доступа к базе данных уже существует',
    'class_db__inc_access_record_not_exist' => 'Такой записи для доступа не существует',
    'class_db__inc_unable_del_last_record' => 'Не удалось удалить последнюю запись доступа хоста',
    'class_domtmpleditform__dns_master' => "Первичный",
    'class_domtmpleditform__dns_slave' => "Вторичный",
    'class_domtmpleditform__dns_type' => "Тип зоны DNS домена",
    'class_traffichistory__no_data_available' => "Нет сведений.",
    'class_traffichistory__traffic_usage' => "Использование трафика",
    'clienttrafficlist_header' => "Трафик доменов",
    'clienttrafficlist_header_of_client__' => "Трафик по доменам клиента %1",
    'cmd_dns__a_dns_record_already_exist' => "Эта запись будет конфликтовать с записью А зоны.",
    'cmd_dns__domain_last_ns' => 'Ошибка удаления последней NS-записи DNS домена.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Недопустимое каноническое имя домена.",
    'cmd_dns__cname_dns_record_already_exist' => "Эта запись будет конфликтовать с записью CNAME зоны.",
    'cmd_dns__cname_in_rr_combination' => 'В зоне DNS имеется неверное сочетание записей DNS.',
    'cmd_dns__cname_coexist_with_data' => 'Запись зоны DNS типа CNAME не может сосуществовать с другими записями DNS в той же зоне.',
    'cmd_dns__dns_record_type_is_invalid' => "Недопустимый тип записи DNS.",
    'cmd_dns__ext_host_is_not_resolved' => "Каноническое имя %1 не распознается как запись типа A или AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Не удалось добавить запись %1 в зону %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Недопустимое имя почтового сервера.",
    'cmd_dns__mx_priority_is_invalid' => "Недопустимый приоритет почтового сервера.",
    'cmd_dns__name_server_is_invalid' => "Недопустимый сервер имен.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Маска сети должна быть 24, 16 или 8.",
    'cmd_dns__this_dns_record_already_exists' => "Такая запись DNS уже существует.",
    'cmd_dns__unable_add_record' => "Не удалось добавить запись '%1': %2",
    'cmd_dns__unable_add_a_record' => "Невозможно добавить запись A: %1",
    'cmd_dns__unable_add_cname_record' => "Невозможно добавить запись CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Невозможно добавить запись DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Невозможно добавить запись EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Невозможно добавить запись NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Невозможно добавить запись PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Нельзя добавить запись TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Невозможно создать зону DNS: %1",
    'cmd_dns__unable_define_dns_record' => "Невозможно определить запись DNS: %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Невозможно определить статус зоны DNS по умолчанию: %1",
    'cmd_dns__unable_insert_a_record' => "Невозможно добавить запись А: %1",
    'cmd_dns__unable_insert_mx_record' => "Невозможно добавить запись MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Невозможно добавить запись NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Невозможно установить статус зоны DNS: %1",
    'cmd_domains__dom_already_exists' => "Домен %1 уже существует.",
    'cmd_domains__dns_record_already_exists' => "Невозможно создать домен %1, так как запись DNS, указывающая на хост %1, уже существует.",
    'cmd_domains__dom_already_exists1' => "У данного домена имеется %2 субдоменов. Домен %1 уже существует.",
    'cmd_domains__dom_already_exists2' => "Субдомен %1 уже существует",
    'cmd_domains__dalias_already_exists' => "Такой псевдоним уже существует.",
    'cmd_domains__domain_alias_already_exists' => 'Такой псевдоним домена уже существует.',
    'cmd_domains__unable_del_mail_for_dom' => "Невозможно удалить почтовые службы домена: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Невозможно удалить учетную запись анонимного FTP: %1",
    'cmd_domains__unable_update_dom_param' => "Невозможно обновить параметры домена: %1.",
    'cmd_domains__unable_rename_client_exist' => "имя пользователя администратора домена уже используется.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Хостинг не является физическим.",
    'cmd_hosting__unable_create_user' => "Невозможно создать пользователя %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Невозможно определить IP-адрес для виртуальных серверов на базе имен: %1",
    'cmd_hosting__unable_del_old_hst' => "Невозможно удалить существующие настройки хостинга: %1",
    'cmd_hosting__unable_del_protected_directory' => "Невозможно удалить защищенную папку: %1.",
    'cmd_hosting__unable_del_web_user' => "Невозможно удалить веб-пользователя: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Невозможно создать/изменить виртуальный сервер: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Невозможно настроить хостинг с перенаправлением во фрейме.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Невозможно переписать конфигурационный файл proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Невозможно настроить SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Невозможно снять защиту с этой SSL/TLS-папки: %1",
    'cmd_hosting__unable_update_dest_url' => "Невозможно обновить конечный URL-адрес %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Невозможно внести изменения в зону DNS домена: не удается запустить утилиту.",
    'cmd_hosting__unable_update_ftp_passwd' => "Невозможно обновить пароль FTP %1.",
    'cmd_hosting__unable_update_user' => "Невозможно сохранить сведения пользователя %2: %1",
    'cmd_hosting__unknown_hst_type' => "Неизвестный тип хостинга.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Вам запрещено отключать услугу хостинга.",
    'cmd_mail__autoresponder__not_configured' => "Автоответчик для этой учетной записи почты не настроен",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Адрес %1 уже используется для перенаправления почты.",
    'cmd_mail__alias_already_exists' => "почтовый псевдоним уже существует.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID автоответчика и учетной записи почты не совпадают.",
    'cmd_mail__autoresp_id_is_undefined' => "ID автоответчика не определен.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Для учетной записи почты %1 уже есть такой почтовый псевдоним.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Учетная запись почты %1 уже имеется в этом списке рассылки.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Учетная запись почты %1 уже существует на этом домене.",
    'cmd_mail__mail_name_not_exist' => "Учетная запись почты не существует.",
    'cmd_mail__mail_name_passwd_part' => "Пароль не должен включать имя учетной записи электронной почты.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Список рассылки %1 уже есть в этом домене.",
    'cmd_mail__mailname_already_exist_in_mg' => "Учетная запись электронной почты %1 уже входит в почтовую группу.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Учетная запись почты %1 уже существует на этом домене.",
    'cmd_mail__mailname_already_exists' => "Учетная запись электронной почты уже существует.",
    'cmd_mail__mailname_is_invalid' => "Неверное имя учетной записи электронной почты %1.",
    'cmd_mail__mailname_unable_update' => "Невозможно обновить свойства учетной записи электронной почты:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Исчерпано максимальное количество автоответчиков для этого домена.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Исчерпано максимальное количество почтовых групп для этого домена.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Исчерпано максимальное количество перенаправлений для этого домена.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Исчерпано максимальное количество почтовых ящиков.",
    'cmd_mail__no_members_specified' => "не указан ни один член почтовой группы.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Слишком простой пароль, пожалуйста, выберите другой.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Этот адрес электронной почты уже используется.",
    'cmd_mail__unable_define_autoresp_id' => "Невозможно определить ID автоответчика %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Не удалось изменить настройки почтовой службы для домена %1",
    'cmd_mail__unable_del_mail_for_dom' => "Невозможно удалить почтовую службу с домена %1.",
    'cmd_mail__unable_del_mail_redirection' => "Невозможно удалить службу перенаправления почты %1.",
    'cmd_mail__unable_remove_autoresp' => "Невозможно удалить автоответчики: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Невозможно удалить членов почтовой группы: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Не удалось отключить почтовую группу: %1",
    'cmd_mail__unable_update_mail_redirect' => "Невозможно внести изменения в службу перенаправления почты %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Слишком большой размер загружаемого файла.",
    'cmd_mail__additionally' => "Дополнительно:",
    'cmd_pd__invalid_login' => "Неверное имя пользователя.",
    'cmd_pd__this_user_already_exist' => "Такой пользователь уже существует.",
    'cmd_pd__unable_define_hst_type' => "Невозможно определить тип хостинга.",
    'cmd_pd__unable_upd_pd_usr' => "Невозможно обновить свойства пользователя защищенной папки: %1.",
    'cmd_pd__user_is_undefined' => "Пользователь не определен.",
    'cmd_server__no_enough_free_disk_space' => "Недостаточно места на диске.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "неверный старый пароль. Пожалуйста, повторите попытку.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "исчерпано ограничение количества веб-пользователей для этого домена.",
    'cmd_web_usr__unable_create_user' => "невозможно создать системного пользователя: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "невозможно определить максимально допустимое количество веб-пользователей: %1",
    'cmd_web_usr__user_already_exists' => "пользователь уже существует.",
    'cmd_web_usr__web_user_name_is_invalid' => "недопустимое имя веб-пользователя %1.",
    'cmd_web_usr__web_user_not_exist' => "веб-пользователь не существует.",
    'common_func__exec_bad_argument' => "аргумент exec не должен содержать одинарной кавычки.",
    '__eol' => 'Перевод строки',
    'eol__binary_file' => 'Не удалось изменить стиль перехода на новую строку в бинарном файле.',
    'comp_info__header' => 'Компоненты',
    'comp_info__comp_name' => "Название компонента",
    'comp_info__comp_disabled' => 'Отключить',
    'comp_info__comp_active' => 'Активен',
    'comp_info__comp_not_configured' => 'Не настроено',
    'comp_info__comp_not_started' => 'Не запущен, проверьте настройки компонента',
    'comp_info__comp_version' => "Версия компонента",
    'comp_info__integration_error' => "Ошибка интеграции",
    'comp_info__title' => "Компоненты Plesk",
    'comp_info__service_name' => "Служба",
    'comp_info__last_updated' => '(последнее обновление: %1)',
    'cp_access_admin_deny' => "Доступ с правами администратора с адреса '%1' запрещен в соответствии с текущей политикой ограничения доступа.",
    'create_domain_warn__' => "При создании домена были сделаны следующие исключения:",
    'create_domain__client_select' => 'Выберите клиента, для которого вы хотите создать домен',

    'dashboard__nav_button_name' => "Главная",
    'dalias__list_title' => 'Псевдонимы домена %1',
    'dalias__list_legend' => 'Псевдонимы домена',
    'dalias__list_header' => 'Псевдонимы домена',
    'dalias__list_status' => 'С',
    'dalias__list_name' => 'Псевдоним домена',
    'dalias__list_ascii_name' => 'В формате ASCII',
    'dalias__remove_title' => 'Следующие псевдонимы домена %1 будут удалены:',
    'dalias__select_domain_aliases_to_remove' => 'Выберите псевдонимы домена для удаления.',
    'dalias__mail_turn_on_failed' => 'Не удалось включить почтовую службу: %1',
    'dalias__web_turn_on_failed' => 'Не удалось включить веб-службу: %1',
    'db_usr_edit__db_usr_name_old' => "Старое имя пользователя базы данных",
    'database_server_edit_form__cannot_infer_type' => 'Недостаточно данных, чтобы определить способ подключения. Укажите "127.0.0.1" в качестве имени хоста для сервера базы данных, чтобы подключиться через TCP/IP с помощью предоставленного порта, или оставьте имя порта незаполненным, чтобы использовать сокет Unix "%1".',
    'database_server_edit_form__duplicate' => 'Сервер баз данных с таким адресом хоста и номером порта уже зарегистрирован.',
    'database_server_edit_form__host_is_invalid' => 'Указано недопустимое имя хоста.',
    'database_server_edit_form__port_is_invalid' => 'Указан недопустимый номер порта.',
    'database_server_error__consult_admin' => 'Пожалуйста, обратитесь к администратору сервера.',
    'database_server_error__last__connection_failed' => 'Последняя попытка управления сервером баз данных не удалась по причине сетевых проблем.',
    'database_server_error__last__permission_denied' => 'Последняя попытка управления сервером баз данных не удалась, т.к. введенная учетная запись не имеет привилегий администратора.',
    'database_server_error__last__credentials_not_set' => "Последняя попытка подключиться к этому серверу не удалась, так как не были указаны правильные имя пользователя и пароль администратора.",
    'database_server_error__last__other_error' => 'Последняя попытка управления сервером баз данных не удалась.',
    'database_server_error__real__connection_failed' => 'Не удалось установить соединение с сервером баз данных из-за сетевых проблем:',
    'database_server_error__real__permission_denied' => 'Не удалось установить соединение с сервером баз данных, т.к. введенная учетная запись не имеет привилегий администратора.',
    'database_server_error__real__duplicate_object' => 'Не удалось установить соединение с сервером баз данных из-за конфликта имен:',
    'database_server_error__real__unacceptable_name' => 'Не удалось установить соединение с сервером баз данных из-за неверного имени объекта:',
    'database_server_error__real__unacceptable_password' => 'Не удалось установить соединение с сервером баз данных из-за неверного формата пароля:',
    'database_server_error__real__credentials_not_set' => "Plesk не может подключиться к серверу баз данных, так как не были указаны правильные имя пользователя и пароль администратора.",
    'database_server_error__real__other_error' => 'Не удалось установить соединение с сервером баз данных:',
    'database_server_error__test__connection_failed' => 'Тестовое подключение к серверу баз данных не удалось из-за проблем с сетью:',
    'database_server_error__test__permission_denied' => 'Тестовое подключение к серверу баз данных не удалось, так как у данного пользователя нет прав администратора.',
    'database_server_error__test__duplicate_object' => 'Тестовое подключение к серверу баз данных не удалось из-за конфликта имен:',
    'database_server_error__test__unacceptable_name' => 'Тестовое подключение к серверу баз данных не удалось из-за недопустимого имени объекта:',
    'database_server_error__test__unacceptable_password' => 'Тестовое подключение к серверу баз данных не удалось из-за недопустимого пароля:',
    'database_server_error__test__credentials_not_set' => "Тестовое подключение к этому серверу не удалось, так как не были указаны правильные имя пользователя и пароль администратора.",
    'database_server_error__test__other_error' => 'Тестовое подключение к серверу баз данных не удалось:',

    'db__create_new_db' => "Добавить базу данных.",
    'db__db_add' => "Добавить базу данных",
    'db__db_for_dom' => "Базы данных сайта %1",
    'db__db_id_undefined' => "Идентификатор базы данных не определен.",
    'db__db_name' => "Имя базы данных",
    'db__db_not_exist' => "База данных не существует.",
    'db__db_type' => "Тип",
    'db__db_server' => "Сервер баз данных",
    'db_server_not_exist' => "База данных не существует.",
    'db__db_user_not_exist' => "Пользователь базы данных не существует.",
    'db__domain_not_exist' => "Домен не существует.",
    'db__enter_db_name' => "Введите новое имя базы данных.",
    'db__invalid_db_id' => "Недопустимый идентификатор базы данных.",
    'db__invalid_db_name' => "Неверное имя базы данных. Имя базы данных должно содержать только символы латинского алфавита, цифры, символы подчерка или дефиса. Длина имени не должна превышать 63 символа.",
    'db__max_db_reached_for_dom' => "Достигнуто ограничение количества баз данных для этого домена.",
    'db__max_mssql_db_reached_for_dom' => "Достигнуто максимальное количество баз данных Microsoft SQL на этом домене.",
    'db__postgres_not_connect_for_admin' => "Невозможно выполнить подключение к PostgreSQL. Включите поддержку PostgreSQL на странице администрирования сервера.",
    'db__postgres_not_connect_for_client' => "Невозможно подключиться к PostgreSQL. Обратитесь за помощью к системному администратору.",
    'db__remove_db_on_domain' => "Следующие базы данных сайта %2, принадлежащего клиенту %1, будут удалены:",
    'db__remove_db_on_domain_of_cl' => "Следующие базы данных для домена %2, принадлежащего клиенту %1, будут удалены:",
    'db__remove_db_linked_resource' => 'Эта база данных используется веб-приложением. Она может быть удалена только после удаления этого веб-приложения.',
    'db__remove_db_users' => "Следующие пользователи базы данных %3 на сайте %2, принадлежащем клиенту %1, будут удалены:",
    'db__remove_db_users_of_cl' => "Следующие пользователи базы данных %3 на сайте %2, принадлежащем клиенту %1, будут удалены:",
    'db__select_db_for_remove' => "Выберите базы данных, которые нужно удалить.",
    'db__select_db_users_for_remove' => "Выберите пользователей базы данных, которых нужно удалить.",
    'db__unable_create_db_user' => "Невозможно создать пользователя базы данных: %1",
    'db__unable_define_db_name' => "Невозможно определить имя базы данных: %1",
    'db__unable_define_db_user' => "Невозможно определить пользователя базы данных: %1",
    'db__unable_define_db_users' => "Невозможно определить пользователей базы данных: %1",
    'db__unable_select_dom_name' => "Невозможно получить имя домена: %1",
    'db_edit__db_for_dom' => "Пользователи базы данных %1 в домене %2",
    'db_edit__invalid_db_name' => "Недопустимое имя базы данных.",
    'db_edit__no_users' => "Нет ни одного пользователя базы данных с установленным паролем.",
    'db_edit__unable_define_db_usrs' => "Невозможно определить пользователей базы данных: %1",
    'db_edit__unable_select_db_usr' => "Невозможно определить пользователя базы данных.",
    'db_edit__db_user_password_for_' => "Введите пароль, чтобы войти как пользователь базы данных %1",
    'db_list__tab_title_db_type' => "Тип",
    'db_usr_edit__add_db_usr' => "Добавить пользователя базы данных",
    'db_usr_edit__db_usr_name' => "Имя пользователя базы данных",
    'db_usr_edit__edit_db_usr' => "Установка параметров учетной записи пользователя базы данных.",
    'db_usr_edit__for_db' => "в базе данных %1",
    'db_usr_edit__not_create_pass' => "В результате этого действия будет создан пользователь без пароля, требуемого для входа. Хотите создать пользователя без пароля?",
    'dbuser__only_one_user_can_be_default' => "Можно задать только одного пользователя по умолчанию.",
    'db_server__cannot_delete_default' => "Сервер баз данных по умолчанию не может быть удален.",
    'db_server__cannot_delete_local' => "Локальный сервер баз данных не может быть удален.",
    'db_server__cannot_delete_used' => 'Сервер баз данных не может быть удален, пока он содержит базы данных или пользователей баз данных.',
    'demo__disabled_in_demo' => "Редактирование этого объекта запрещено в демо-версии.",
    'defaultcomponents__title' => "Выбор компонентов по умолчанию",
    'defaultcomponents__select_default' => "Выбрать компонент %1 по умолчанию",//to check
    'defaultcomponents__not_installed' => "(не установлен)",
    'defaultcomponents__not_configured' => "(не настроен)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Некоторые категории сервисов содержат некорректный выбор, либо выбор не сделан.",
    'defaultcomponents__depends_on' => "(требуется %1)",
    'defaultcomponents__parameters' => "Параметры %1",
    'component_name__antivirus' => "Антивирус",
    'component_name__database' => "Сервер SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Сервер DNS",
    'component_name__firewall' => "Брандмауэр",
    'component_name__ftpserver' => "Сервер FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Почтовый сервер",
    'component_name__local_mailserver' => "Локальный почтовый сервер",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Веб-скрипты",
    'component_name__spamfilter' => "Антиспам",
    'component_name__stats' => "Веб-статистика",
    'component_name__stunnel' => "Оболочка SSL/TLS",
    'component_name__webmail' => "Веб-почта",
    'component_name__webpublish' => "Веб-публикация",
    'component_name__webserver' => "Веб-сервер",
    'dns__dns_record_invalid_values' => 'Указаны неверные значения записи DNS: %1: %2',
    'dns__dns_record_not_found' => 'Запись DNS не найдена',
    'dns__dns_zone_invalid_values' => 'Указаны неверные параметры зоны DNS.',

    'dns__soa_mname_title' => 'Первичный сервер имен',
    'dns__soa_mname_legend' => 'Сервер имен',
    'dns__soa_mname_autoselect' => '(Автовыбор)',

    'dns__dns_zone_off_remove_title' => "Следующие записи будут удалены из зоны %1:",
    'dns__dns_zone_master_remove_title' => "Удаление ресурсных записей из зоны DNS %1",
    'dns__dns_zone_slave_remove_title' => "Следующие записи первичного сервера имен %1 будут удалены:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Укажите строку записи',
    'dns_add__is_spf_syntax' => 'Запись SPF',
    'dns_add__spf_value_is_invalid' => "Некорректное значение записи SPF, оно должно начинаться с 'v=spf'",
    'dns__dns_zone_status' => "Статус зоны DNS.",
    'dns__dns_zone_template' => 'Настройки DNS',
    'dns__invalid_ip_address' => "IP-адрес нового первичного сервера DNS недопустим или пуст.",
    'dns__ip_address' => "IP-адрес",
    'dns__master_dns_type' => "является первичным сервером DNS",
    'dns__masters' => "первичные серверы DNS",
    'dns__soa_minimum_too_large' => 'Кэширование отрицательных ответов на период более чем 3 часа не рекомендуется.',
    'dns__select_masters_to_remove' => "Выберите первичные серверы DNS для удаления.",
    'dns__select_template_record_to_remove' => 'Выберите записи шаблона DNS для удаления.',
    'dns__nameservers_for_domain' => "Серверы имен для домена",
    'dns__remove_dns_zone_of_domain__' => "Удаление записей DNS для %1",
    'dns__remove_dns_zone_template__' => "Следующие записи DNS будут удалены из шаблона:",
    'dns__remove_this_dns_record?' => "Вы действительно хотите удалить эту запись DNS ?",
    'dns__restore_default' => "Восстановление зоны DNS по шаблону",
    'dns__restore_default_confirm' => "Восстановление зоны DNS повлечет за собой потерю текущей конфигурации зоны DNS. Все равно продолжить?",
    'dns__restore_default_error' => "Ошибка восстановления зоны DNS:",
    'dns__slave_dns_type' => "является вторичным сервером DNS",
    'dns__subdomain_dns_rec_removed' => "Запись А была удалена из зоны субдомена %1",
    'dns__zone_switched_off_no_ns' => "Зона не может быть отключена, так как отсутствует NS-запись %1, которая должна присутствовать в зоне. Чтобы добавить запись, нажмите на кнопку Добавить запись.",
    'dns__cant_switch_on_no_ns' => "Зона не может быть включена, так как отсутствует NS-запись %1, которая должна присутствовать в зоне. Чтобы добавить запись, нажмите на кнопку Добавить запись.",
    'dns__unable_activate/deactivate_dns' => "Невозможно активировать/деактивировать DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Невозможно добавить первичный сервер DNS: дублирующиеся данные.",
    'dns__unable_add_dns_master_local_ip' => "Невозможно добавить IP-адрес для первичного сервера DNS: данная запись должна быть создана на удаленном сервере.",
    'dns__unable_define_dns_record' => "Невозможно определить запись DNS: %1",
    'dns__unable_get_dns_template_status' => "Невозможно определить статус шаблона DNS.",
    'dns__unable_remove_dns_rec' => "Невозможно удалить запись DNS: %1",
    'dns__warnings__' => "Результат изменений в зоне DNS:",
    'dns__you_not_have_perm_manage_dns' => "Вам запрещено управлять зоной DNS этого домена.",
    'dns__cant_create_record_with_server_ip' => "Невозможно добавить этот IP-адрес, так как он совпадает с IP-адресом данного сервера Plesk",

    'dns__tabs_acl' => "Передачи зоны",
    'dns__acl_add_network_legend' => "Добавить сеть",
    'dns__acl_add_ip_legend' => "Добавить IP-адрес",
    'dns__acl_network_not_allowed' => "Этот сетевой адрес запрещен DNS в Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP-адрес/маска",
    'dns__acl_enter_ip_address' => "IP-адрес",
    'dns__acl_list_network_legend' => "Сетевые адреса серверов, которые могут получить копию зоны DNS",
    'dns__acl_list_ip_legend' => "IP-адреса серверов, которые могут получить копию зоны DNS",
    'bt_dns_acl_add_network' => "Добавить сеть",
    'bt_dns_acl_add_ip' => "Добавить IP-адрес",

    'dns_add__add_rec_for_zone' => "Добавить %1 для зоны %2",
    'dns_add__canonical_dom_name_is_invalid' => "Недопустимое каноническое имя домена.",
    'dns_add__enter_canonical_name' => "Каноническое имя",
    'dns_add__enter_dom_name' => "Имя домена",
    'dns_add__enter_ip_address' => "IP-адрес",
    'dns_add__enter_ip_mask' => "IP-адрес и маска сети",
    'dns_add__enter_mail_domain' => "Почтовый домен",
    'dns_add__enter_mail_exchanger' => "Почтовый сервер",
    'dns_add__enter_nameserver' => "Сервер имен",
    'dns_add__enter_txt_record' => "TXT-запись",
    'dns_add__enter_service_name' => "Название услуги",
    'dns_add__hint_service_name' => "Пример: SIP (без символа подчеркивания)",
    'dns_add__enter_protocol' => "Протокол",
    'dns_add__hint_protocol_name' => "Пример: TCP (без символа подчеркивания)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Приоритет",
    'dns_add__specify_weight_of_service' => "Относительный вес для записей с таким же приоритетом",
    'dns_add__enter_target_host' => "Целевой компьютер",
    'dns_add__hint_target_host' => "Пример: example.com",
    'dns_add__enter_target_port' => "Целевой порт",
    'dns_add__caa_tag' => "Тег",
    'dns_add__caa_value' => "Значение",
    'dns_add-invalid-A_ip' => "Недопустимый IP-адрес.",
    'dns_add-invalid-AAAA_ip' => "Недопустимый IP-адрес.",
    'dns_add-invalid-PTR_ip_mask' => "Недопустимая комбинация IP-адреса и маски сети.",
    'dns_add-invalid-SRV_service_name' => "Неверное имя",
    'dns_add-invalid-SRV_protocol_name' => "Неверный протокол",
    'dns_add-invalid-SRV_target_port' => "Неверный целевой порт",

    'dns_add__invalid_ip' => "Недопустимый IP-адрес.",
    'dns_add__low' => "низкий",
    'dns_add__mail_dom_name_is_invalid' => "Недопустимое имя почтового домена.",
    'dns_add__nameserver_is_invalid' => "Недопустимый сервер имен.",
    'dns_add__record' => "Запись %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Укажите приоритет почтового сервера",
    'dns_add__unable_insert_new_dns_rec' => "Невозможно добавить новую запись в DNS: %1",
    'dns_add__very_high' => "очень высокий",
    'dom_ctrl__allowed' => "Доступно",
    'dom_ctrl__db' => "Базы данных MySQL",
    'dom_ctrl__mssql_db' => "Базы данных MS SQL",
    'dom_ctrl__disk_space' => "Диск",
    'dom_ctrl__dom_adm' => "Домен %1 клиента %2",
    'dom_ctrl__dom_cl' => "Домен %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Для домена настроено перенаправление, но при этом не указан конечный URL-адрес.",
    'dom_ctrl__domain_has_frame_forwarding' => "Для домена настроено перенаправление во фрейме на URL-адрес %1",
    'dom_ctrl__domain_has_no_hosting' => "Хостинг для домена не установлен.",
    'dom_ctrl__domain_has_physical_hosting' => "Для этого домена настроен веб-хостинг на IP-адресе %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Для домена настроено стандартное перенаправление на URL-адрес %1",
    'dom_ctrl__maillists' => "Списки рассылки",
    'dom_ctrl__mboxes' => "Почтовые ящики",
    'dom_ctrl__mg' => "Перенаправления почты",
    'dom_ctrl__resource_name' => "Ресурс",
    'dom_ctrl__resp' => "Автоответчики",
    'dom_ctrl__subdom' => "Субдомены",
    'dom_ctrl__dom_aliases' => "Псевдонимы домена",
    'dom_ctrl__traffic' => "Трафик",
    'dom_ctrl__unable_activate/deactivate_dom' => "Невозможно активировать/деактивировать домен: %1",
    'dom_ctrl__used' => "Используется",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Веб-пользователи",
    'dom_pref__bounce_with_phrase' => "Возвращать с уведомлением",
    'dom_pref__bounce' => "Возвращать",
    'dom_pref__catch_addr' => "Перенаправлять на адрес",
    'dom_pref__reject' => 'Отклонять',
    'dom_pref__confirm_domain_removing' => "Пожалуйста, не забудьте известить пользователей домена об изменении имени. Вы действительно хотите переименовать домен?",
    'dom_pref__db_inconsystency' => "ошибка в базе данных.",
    'dom_pref__dbs' => "базы данных",
    'dom_pref__delete_traffic_stat' => "Сохранять веб-статистику и статистику по трафику",
    'dom_pref__delete_traffic_stat_older' => "Сохранять веб-статистику и статистику по трафику",
    'dom_pref__dom_level_name_conflict' => "Имя пользователя администратора домена конфликтует с именем пользователя одного из клиентов.",
    'dom_pref__invalid_disk_space_limit' => "Неверное значение ограничения дискового пространства. Максимальное значение: %1",
    'dom_pref__invalid_expiration_date_limit' => "Установлен неверный срок действия.",
    'dom_pref__invalid_max_traffic_limit' => "Некорректное значение ограничения объема трафика. Максимальное значение: %1",
    'dom_pref__limits_of_dom' => "Ограничения домена %1",
    'dom_pref__mail_grps' => "почтовые группы",
    'dom_pref__mail_nonexistent_user' => "Действия с почтой, отправленной на несуществующий почтовый ящик",
    'dom_pref__mail_redirs' => "перенаправление почты",
    'dom_pref__mail_resps' => "почтовые автоответчики",
    'dom_pref__max_limit_is_invalid' => "%1 — недопустимое значение ограничения.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Указано недопустимое значение для ресурса %1.",
    'dom_pref__new_limit_less_currently_used' => "%1: запрошено — %2, использовано — %3",
    'dom_pref__older_that' => "в течение",
    'dom_pref__postboxes' => "почтовые ящики",
    'dom_pref__preferences_of_dom' => "Настройки домена %1",
    'dom_pref__redirect_to_itself' => "Домен будет перенаправляться сам на себя",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Вы установили время хранения статистики по трафику домена меньше, чем общее установленное значение для сервера (%1 месяц(ев)). Время хранения статистики по трафику домена установлено эквивалентным значению по умолчанию для сервера (%1 месяц(ев)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Невозможно добавить префикс www к имени домена: %1",
    'dom_pref__unable_define_physical_hst_param' => "Невозможно определить параметры физического хостинга: %1",
    'dom_pref__unable_rename_domain' => "Не удалось переименовать домен %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Невозможно установить квоту почтового ящика для этого домена: %1",
    'dom_pref__unable_set_up_web_user_script' => "Невозможно установить поддержку выполнения скриптов для веб-пользователей: %1",
    'dom_pref__unlimited' => "Без ограничений",
    'dom_pref__web_usrs' => "веб-пользователи",
    'dom_pref__you_already_have_%object' => "У вас уже есть %1",
    'cu_domain__error_unable_update_ftp_users' => 'Не удалось обновить FTP-пользователей домена: %1',
    'dom_cli__warning_ignore_quota' => 'Предупреждение: опция "-hard_quote" проигнорирована: квота на объём дискового пространства не поддерживается.',
    'dom_user_client_login_exist' => "Не удалось разрешить доступ к Plesk администратору домена %1: это имя пользователя уже используется.",
    'domain__unable_to_turn_on_service' => "Не удалось включить службу %1.",
    'domains__change_the_status_of_domain?' => "Вы действительно хотите изменить статус домена %1 ?",
    'domains__client_info_hiding_traffic' => "%1 доменов, %2 активных доменов, %3 использованного дискового пространства",
    'domains__unable_to_change_client_status' => "Невозможно изменить статус учетной записи клиента: %1",
    'domains__unable_update_apache_settings' => "Невозможно обновить настройки Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Вам запрещено удалять домены.",
    'domains__you_want_change_the_status_of_the_cl??' => "Вы действительно хотите изменить статус учетной записи клиента?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Вы действительно хотите совершить эту операцию?",
    'domains_list__unable_remove_doms' => "Невозможно удалить домены: %1",
    'domaintrafficlist_header_of_domain__' => "Трафик домена %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Выберите псевдонимы домена для удаления.',
    'domain_aliases_remove__title' => 'Удаление псевдонимов домена',
    'domain_aliases__max_aliases_reached_for_dom' => "Максимально разрешенное количество псевдонимов уже достигнуто для этого домена.",
    'domain_edit__edit_title' => 'Изменить псевдоним домена',
    'domain_alias_edit__type' => 'Тип псевдонима домена',
    'domain_aliases__list_header' => 'Псевдонимы домена',
    'domain_aliases__name' => 'Имя',
    'domain_aliases__type' => 'Тип',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Псевдонимы домена',
    'domain_aliases__legend' => 'Псевдонимы домена',
    'domain_alias__domain_exists' => 'Домен с таким именем уже существует',
    'domain_alias__subdomain_exists' => 'Субдомен с таким именем уже существует',
    'domain_alias__dns_record_exists' => 'DNS-запись с таким псевдонимом домена уже существует',
    'domain_alias__domain_alias_exists' => "Такой псевдоним домена уже существует",
    'domain_alias__invalid_type_full' => 'Почтовый сервер не поддерживает почтовые псевдонимы',
    'domain_alias__redirect_exists' => 'Обнаружено перенаправление на себя.',

    'ds__anonymous_ftp' => "Анонимный FTP",
    'drweb__pagetitle' => 'Настройки антивируса',
    'drweb__drweb' => 'Проверка почты на вирусы',
    'drweb__drweb_direction' => 'Проверка почты на вирусы.',
    'drweb__drweb_direction_off' => 'Не выполнять проверку на вирусы',
    'drweb__drweb_direction_any' => 'Входящие и исходящие сообщения',
    'drweb__drweb_direction_from' => 'Только исходящие сообщения',
    'drweb__drweb_direction_to' => 'Только входящие сообщения',
    'drweb__disable_reason_key' => 'Антивирус не поддерживается установленным лицензионным ключом.',
    'drweb__disable_reason_perm' => 'Вам запрещено управлять антивирусом.',
    'drweb__disable_reason_install' => 'Антивирус не установлен.',
    'drweb__filters' => 'Фильтры антивируса',
    'ds__dns' => "Зона DNS",
    'ds__mail' => "Почта",
    'dsr__of_client_title' => "Сводный отчет о доменах %1",
    'dsr__report_has_been_sent_email' => "Отчет отправлен на следующий адрес: %1",
    'dsr__title' => "Сводный отчет по доменам",
    'dumps_list__deletion_page_title' => "Следующие файлы резервных копий домена %1 будут удалены:",
    'dumps_list__dumpfile_is_invalid' => "Файл %1 не является действительным файлом резервной копии.",
    'dumps_list__page_title' => "Хранилище резервных копий",
    'dumps_upload__page_title' => "Загрузка резервных копий в хранилище",
    'dumps_list__repository_is_not_exist' => "Хранилище файлов резервных копий не существует.",
    'dumps_list__unable_to_remove' => "Невозможно удалить файл резервной копии: %1",
    'dumps_list__dumpfile_can_conflict' => "Указанное имя файла конфликтует с файлом %1 Пожалуйста, введите другое имя файла.",
    'dusr_ed__allow_dl_usr_access' => "Разрешить доступ администратору домена",
    'dusr_ed__information' => "Свойства администратора домена %1",
    'dusr_ed__locale' => "Язык администратора домена",
    'dusr_ed__skin' => "Схема интерфейса администратора домена",
    'dusr_ed__personal_information' => 'Личная информация',
    'ess__error' => "Ошибка",
    'example__' => "Пример: %1",
    'extras__allow_certificate_purchasing' => "Разрешить покупку сертификатов",
    'extras__allow_domain_registration' => "Разрешить регистрацию доменов",
    'extras__allow_extras' => "Разрешить доступ к дополнительным услугам",
    'extras__buy_new_key' => "Ваша текущая лицензия не позволяет редактировать эти объекты.",
    'extras__setup_services' => "Настроить дополнительные услуги",

    'ruleeditform__error' => 'Не удается обновить правило брандмауэра.',
    'ruleeditform__name_is_required' => 'Укажите имя правила.',
    'ruleeditform__profiles_is_required' => 'Выберите хотя бы один профиль.',
    'ruleeditform__invalid_ip' => 'Недопустимый IP-адрес или сеть.',
    'ruleeditform__invalid_port' => 'Недопустимый номер порта. Возможные значения: 1000 или 1000-1051',

    'filemanager__items' => 'объектов в папке %1',
    'filemanager__items_paging' => 'объектов в папке %1',

    'get_password__encrypted_password' => "Невозможно отправить сведения о пароле: пароль хранится в зашифрованном виде.",
    'get_password__mail_error' => "При отправке пароля на адрес %1 произошла ошибка: %2",
    'get_password__mail_ok' => "Пароль был успешно отправлен на адрес %1.",
    'get_password__message' => "Ваше имя пользователя для доступа в систему: %1 \nВаш пароль: %2",
    'get_password__subject' => "Пароль для доступа к системе",
    'groups__available' => "Существующие почтовые группы",
    'groups__groups_for_mailname' => "Почтовые группы, в которые входит учетная запись электронной почты %1",
    'groups__member_of' => "Участник следующих почтовых групп",
    'help__help_area' => "Место для краткой контекстной справки.",
    'hst_def__auth_disabled' => "запрещено",
    'hst_def__auth_enabled' => "разрешено",
    'hst_def__change_curr_dns_ip' => "Текущий IP-адрес для записи \"А\" будет изменен в DNS",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Ни один из IP-адресов в записях типа \"А\" в DNS не совпадает с IP-адресом создаваемого хостинга",
    'hst_def__dest_url' => "Конечный URL",
    'hst_def__disk_quota' => "Дисковая квота",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Устанавливаемое ограничение дискового пространства превышено ограничением, установленным для папки incoming анонимного FTP. Ограничение дискового пространства в папке incoming анонимного FTP не должно превышать ограничение дискового пространства домена.",
    'hst_def__frame_forwarding_definition' => "Создание перенаправления во фрейме для домена %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Предупреждение: пользователь FTP %1 используется в настройках учетной записи хостинга, но не существует в системе.",
    'hst_def__hst_type_is_not_defined' => "Тип хостинга не определен",
    'hst_def__ip_based' => "По IP-адресу",
    'hst_def__name_based_power_anonymous_ftp_down' => "В результате переноса этой учетной записи хостинга на общий IP-адрес служба анонимного FTP на этом домене станет недоступной. Продолжить?",
    'hst_def__password_is_invalid_password_syntax' => "Недопустимый пароль. Не используйте одиночные кавычки и символы национального алфавита при вводе пароля. Длина пароля должна быть от 5 до 14 символов. Пароль не должен совпадать с именем пользователя.",
    'hst_def__shell' => "SSH-доступ к серверу под системным пользователем подписки",
    'hst_def__shell_windows' => "Доступ по протоколу Удаленного рабочего стола к серверу под системным пользователем подписки",
    'hst_def__standard_forwarding_definition' => "Создание стандартного перенаправления для домена %1",
    'hst_def__title_name_based' => "По имени",
    'hst_def__unable_create/update_physic_hst' => "Невозможно установить/настроить физический хостинг: %1",
    'hst_def__unable_create/update_std_fwd' => "Невозможно создать/обновить стандартное перенаправление: %1",
    'hst_def__unable_create_forwarding_myself' => "Невозможно создать перенаправление на исходный домен.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Не удалось разрешить использовать одну и ту же папку для хранения SSL/TLS и не-SSL/TLS содержимого: поддержка SSL/TLS не включена.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Не удалось включить поддержку SSL/TLS: не установлен SSL/TLS-сертификат.",
    'hst_def__url_is_invalid' => "Недопустимый URL.",
    'hst_def__virtual_host_access' => "Доступ к виртуальному серверу для домена %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ВНИМАНИЕ. Данный виртуальный сервер использует несуществующий IP-адрес.",
    'hst_def__you_have_no_ips' => "У вас нет свободных IP-адресов, и вам запрещено создавать хостинг на базе имен.",
    'hst_sel__header' => "Чтобы разместить сайт на этом сервере, выберите опцию Физический хостинг.\n Чтобы настроить перенаправление на сайт, размещенный на другом сервере, выберите опцию Перенаправление во фрейме или Стандартное перенаправление.\n При стандартном перенаправлении в адресной строке браузера отображается URL-адрес фактического сайта, поэтому пользователь будет знать о перенаправлении. При перенаправлении во фрейме перенаправление происходит незаметно для пользователя.",
    'hst_sel__physical_hst' => "Физический хостинг",
    'hst_sel__select_hst_type' => "Выберите тип хостинга.",
    'hst_sel__select_hst_type_warning' => "Выберите тип хостинга.",
    'hst_sel__hosting_exists' => "На данном домене уже настроен хостинг. Вы попадете на страницу управления данным хостингом.",
    'hst_sel__standard_frw' => "Стандартное перенаправление",
    'hst_sel__frame_frw' => "Перенаправление во фрейме",
    '__frame_frw' => "Перенаправление во фрейме",
    '__hosting_exists' => "На данном домене уже настроен хостинг. Вы попадете на страницу управления данным хостингом.",
    '__choose_hst_type' => "Выберите необходимый тип хостинга.",
    '__no_hst_conf' => "На домене не настроен хостинг.",
    '__physical_hst' => "Физический хостинг",
    '__select_hst_type' => "Выберите тип хостинга.",
    '__standard_frw' => "Стандартное перенаправление",
    '__warning' => "Предупреждение! Все установленные ранее параметры будут утеряны. Вы уверены, что желаете изменить тип хостинга?",
    'i_cl_off' => "Клиент неактивен.",
    'i_cl_off_by_admin' => "Учетная запись клиента приостановлена администратором сервера.",
    'i_cl_off_expired' => "Срок действия учетной записи клиента истек.",
    'i_cl_on' => "Клиент активен.",

    'icf__title' => 'Брандмауэр соединений по Internet',
    'icf__if_legend' => 'Интерфейсы',
    'icf__mode' => 'Режим',

    'invalid_value' => 'Неверное значение.',

    'ip_addr__already_exists' => "IP-адрес %1 уже существует.",
    'ip_addr__cant_add' => "IP %1 не существует или принадлежит пулу другого клиента",
    'ip_alias__interface' => "Интерфейс",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "IP-адрес %1 не подходит для хостинга на базе имен.",
    'ip_alias__invalid_ip_or_netmask' => "Недопустимая комбинация IP-адреса и маски сети.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP-адрес %1 является IP-адресом исходного сервера, и поэтому не может быть удален.",
    'ip_alias__ip_is_invalid' => "Недопустимый IP-адрес %1.",
    'ip_alias__ip_mask_is_invalid' => "Недопустимая IP-маска %1.",
    'ip_alias__ip_not_exist' => "IP-адрес %1 не существует.",
    'ip_alias__ip_address_and_mask' => 'IP-адрес и маска подсети',
    'ip_alias__mask' => "Маска подсети",
    'ip_alias__remove_selected_ip_aliases?' => "Вы действительно хотите удалить эти IP-адреса?",
    'ip_alias__select_ip' => "Выберите IP-адрес.",
    'ip_alias__this_ip_used_for_domain' => "(%1) этот IP-адрес используется доменом %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) этот IP-адрес используется для виртуальных серверов на базе имен.",
    'ip_alias__unable_add_ip' => "Невозможно добавить IP-адрес: %1",
    'ip_alias__unable_remove_ip' => "Невозможно удалить IP-адрес: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Вы не можете изменить тип IP-адреса на 'Общий', так как после этого анонимный FTP для домена '%1' перестанет поддерживаться.",
    'ip_ctrl__ip_addr' => "IP-адрес %2 на интерфейсе %1",
    'ip_ctrl__ip_exists_many_pools' => "Вы не можете изменить тип IP-адреса. Данный IP-адрес содержится в пулах нескольких пользователей одновременно.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-сертификат",
    'limit__date_in_past' => "Недопустимый срок действия. %1 находится в прошлом.",
    'limit__enter_date' => "Введите дату",
    'limit__max_db' => "Базы данных",
    'limit__name_disk_space' => "дисковое пространство",
    'limit__name_max_box' => "почтовые ящики",
    'limit__name_max_db' => "Базы данных MySQL",
    'limit__name_max_dom' => "домены",
    'limit__name_max_maillists' => "списки рассылки",
    'limit__name_max_subdom' => "субдомены",
    'limit__name_max_traffic' => "трафик",
    'limit__name_max_wu' => "веб-пользователи",
    'limit__name_mbox_quota' => "квота почтового ящика",
    'limit__name_max_mn' => "учетные записи почты",
    'limit__name_max_cl' => 'клиенты',
    'limit__name_total_mboxes_quota' => "общая квота почтового ящика",
    'limit__name_mysql_dbase_space' => "пространство баз данных MySQL",
    'limit__name_mssql_dbase_space' => "пространство баз данных MSSQL",
    'limit__name_expiration' => 'срок действия',

    'locale_upload__unable_to_install' => 'Невозможно установить пакет локализации',
    'locale_upload__wrong_package' => 'Загруженный файл не является языковым пакетом, совместимым с данной версией Plesk.',
    'locale_upload__wrong_locale' => 'В загруженном файле нет правильного пакета локализации.',

    'ma__create_title' => 'Создание почтового псевдонима для %1',
    'ma__edit_title' => "Изменить почтовый псевдоним %1",
    'ma__enter_new_alias' => "Введите новый почтовый псевдоним.",
    'ma__invalid_alias' => "Недопустимый почтовый псевдоним.",
    'ma__mail_aliases_mailname' => "Псевдонимы учетной записи почты %1",
    'ma__mailname_does_not_exist' => "Учетная запись электронной почты не существует.",
    'ma__select_ma_for_remove' => "Выберите почтовые псевдонимы для удаления.",
    'ma__unable_to_add_new_ma' => "Невозможно добавить почтовый псевдоним: %1",

    'mail_queue__not_allowed_by_license_key' => 'Управление почтовой очередью не разрешено лицензионным ключом.',
    'maillist__' => "Список рассылки: %1",
    'maillist__already_exists' => "Список рассылки уже существует.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Почтовый псевдоним %1 уже существует в этом домене",
    'maillists__' => "Списки рассылки: %1",
    'maillists__limit_cl_max_maillists' => "Исчерпано максимальное количество списков рассылки для клиента (ограничение: %1, использовано: %2)",
    'maillists__limit_dom_max_maillists' => "Исчерпано максимальное количество списков рассылки для этого домена.",
    'maillists__list' => "Списки рассылки",
    'maillists__mailman_not_installed_or_conf' => "Компонент Mailman Server Extensions не установлен на сервере, либо не настроен. Свяжитесь с администратором сервера на предмет установки/настройки Mailman Server Extensions.",
    'maillists__status' => "Служба списков рассылки включена",
    'maillists__unable_to_delete__' => "Невозможно удалить список рассылки: %1",
    'maillists__disabled_text' => 'Вы не можете управлять списками рассылки так как сервер списков рассылки Mailman не установлен или не настроен.',
    'maillist_member__already_exists' => 'Подписчик с таким именем уже существует в списке рассылки.',
    'maillist_member__not_exists' => 'Подписчик с таким именем не найден в списке рассылки.',
    'mailserver_switching_warning' => "Предупреждение!\n\nОперация смены почтового сервера предназначена только для первоначальной настройки системы и, в случае изменения уже работающего почтового сервера, приведет к потере настроек и содержимого почтовых ящиков, а также, если новый сервер уже сконфигурирован — к различным конфликтам.\nЕсли текущий сервер используется и вы уверены, что хотите переключиться на другой, вы можете уведомить своих клиентов о предстоящей операции с тем, чтобы они имели возможность загрузить и сохранить свою почту.",
    'manager__access_denied' => "Доступ запрещен: %1",
    'manager__admin' => "Администратор",
    'manager__client' => 'Клиент',
    'manager__domain' => "Домен",
    'manager__domain_cl_limit_exceeding' => "Исчерпано ограничение на количество доменов, установленное для этой учетной записи клиента.",
    'manager__domain_is_not_yours' => "Домен %1 не принадлежит вам.",
    'manager__domain_key_limit_exceeding' => "Достигнуто ограничение на создание доменов, определенное вашим лицензионным ключом.",
    'manager__no_perm_to_call' => "Вам запрещено вызывать %1.",
    'manager__no_perm_to_create_domains' => "Вам запрещено создавать домены.",
    'manager__no_perm_to_modify_domain' => "Вам запрещено редактировать домен %1.",
    'manager__no_perm_to_modify_domains' => "Вам запрещено редактировать домены.",
    'manager__no_perm_to_remove_domain' => "Вам запрещено удалять домен %1.",
    'manager__no_perm_to_remove_domains' => "Вам запрещено удалять домены.",
    'manager__node_doesnt_exist' => "%1 не существует.",
    'manager__user_disabled' => "Ваша учетная запись приостановлена. Вы не можете работать в системе.",
    'mail_quota_unsupported' => "не поддерживается почтовым сервером",
    'mbox_quota_unsupported' => "не поддерживается почтовым сервером",
    'mn__create_title' => "Создать учетную запись электронной почты",
    'mn__edit_title' => "Настройки",
    'mn__files_list_title' => "Прикрепляемые файлы",
    'mn__files_remove' => "Удалите файлы из репозитория прикрепленных файлов. Возможно, эти файлы используются автоответчиками. Они будут удалены из репозитория и автоответчиков.",
    'mn__files_select_for_remove' => "Выберите файлы для удаления.",
    'mn__mail_alias_form' => "Почтовый псевдоним",
    'mn__mail_aliases_list' => "Почтовые псевдонимы",
    'mn__mailbox' => "Управление почтовым ящиком",
    'mn__unable_define_mn' => "Невозможно создать учетные записи электронной почты: %1",
    'mn__unable_remove_mbox_quota' => "Невозможно удалить квоту почтового ящика: %1",
    'mn__upload_file' => "Загрузить файл",
    'mn_edit__attach_filename_changed' => 'Загруженный файл %1 был переименован в %2, так как его имя содержало не-ASCII символы.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Сначала нужно добавить члена почтовой группы, прежде чем активировать ее.",
    'mn_edit__add_resp_or_turn_off_box' => "Добавьте автоответчик или снимите флажок из поля Автоответчик.",
    'mn_edit__attachments' => "Прикрепляемые файлы",
    'mn_edit__dom_quota_less_then_quota' => "Размер этого почтового ящика не должен превышать ограничения на объем дискового пространства, выделенного для почтовых ящиков на этом домене.",
    'mn_edit__enter_external_rcpnt_email' => "Введите адрес внешнего получателя",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Введите адрес для перенаправления почты или уберите эту галочку.",
    'mn_edit__ext_rcpnt_email_invalid' => "Недопустимый адрес электронной почты внешнего получателя.",
    'mn_edit__file_exists' => "Файл уже существует. Переписать?",
    'mn_edit__files_deld_from_repository' => "Эти файлы будут удалены из репозитория и автоответчиков. Продолжить?",
    'mn_edit__mail_name' => "Учетная запись почты",
    'mn_edit__mail_name_invalid' => "Неверное имя учетной записи электронной почты",
    'mn_edit__mail_redir' => "Перенаправление почты",
    'mn_edit__mail_redir_add' => "Добавить участника группы",
    'mn_edit__mail_resps' => "Автоответчики",
    'mn_edit__mailbox' => "Почтовый ящик",
    'mn_edit__enable_mailbox' => "Почтовый ящик",
    'mn_edit__mailgroup' => "Почтовая группа",
    'mn_edit__mailgroup_addresses' => "Участники почтовой группы",
    'mn_edit__mailgroup_disabled' => "Доступно только, когда учетная запись электронной почты уже добавлена.",
    'mn_edit__max_dom_quota' => "По умолчанию для домена (%1)",
    'mn_edit__mbox_quota_invalid' => "Указано некорректное значение квоты на объем почтового ящика.",
    'mn_edit__new_resp_name' => "Имя нового автоответчика",
    'mn_edit__no_autoresponders' => "Сначала необходимо создать хотя бы один автоответчик.",
    'mn_edit__no_file_sel' => "Выберите файл.",
    'mn_edit__no_mail_addresses' => "Не указано или не выбрано ни одного адреса электронной почты.",
    'mn_edit__none' => "Нет",
    'mn_edit__not_create_pass' => "Пароль не будет сохранен для этой учетное записи.\nБез пароля пользователь не сможет работать с почтой.",
    'mn_edit__redir_email_invalid' => "Недопустимый адрес для перенаправления почты.",
    'mn_edit__redirect_addr' => "Адрес для перенаправления",
    'mn_edit__remove_autoresp?' => "Вы действительно хотите удалить автоответчик?",
    'mn_edit__remove_rcpnts?' => "Вы действительно хотите удалить этих адресатов?",
    'mn_edit__repository' => "Репозиторий",
    'mn_edit__resps_attach' => "Файлы, прикрепляемые к автоответчикам",
    'mn_edit__select_rcpnt_from_list' => "Выберите адресатов.",
    'mn_edit__select_registered_users' => "Выберите зарегистрированных пользователей",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Вы создали почтовый ящик, но не указали пароль для доступа к нему.",
    'mn_edit__unable_act_deact_mail_group' => "Невозможно включить/выключить почтовую группу: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Невозможно включить/выключить перенаправление почты: %1",
    'mn_edit__unable_act_deact_postbox' => "Невозможно включить/выключить почтовый ящик: %1",
    'mn_edit__unable_act_deact_resp' => "Невозможно включить/выключить автоответчики: %1",
    'mn_edit__unable_add_attach' => "Невозможно добавить прикрепляемый файл: %1",
    'mn_edit__unable_add_mail_group_member' => "Невозможно добавить члена почтовой группы: %1",
    'mn_edit__unable_add_resp' => "Невозможно добавить автоответчик: %1",
    'mn_edit__unable_change_mail_name' => "Невозможно изменить имя учетной записи электронной почты: %1",
    'mn_edit__unable_deactivate_mail_group' => "Невозможно выключить почтовую группу: %1",
    'mn_edit__unable_deactivate_resp' => "Невозможно отключить автоответчики: %1",
    'mn_edit__unable_define_resp_id' => "Невозможно определить ID автоответчика: %1",
    'mn_edit__unable_remove_attach' => "Невозможно удалить прикрепляемые файлы: %1",
    'mn_edit__unable_remove_autoresp' => "Невозможно удалить автоответчик: %1",
    'mn_edit__unable_remove_mail_group_member' => "Невозможно удалить членов почтовой группы: %1",
    'mn_edit__wrong_way' => 'Сообщения, направленные на адрес %1, не будут доставлены, так как для этой учетной записи электронной почты не включены почтовый ящик или перенаправление почты.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Почтовый ящик с адресом %1 был отключен. Сообщения в почтовом ящике не были удалены, но вы не сможете получить их по протоколу IMAP или POP3.',
    'mn_list__mail_names_for_domain' => "Учетные записи электронной почты на домене %1",
    'mn_list__sa_cannot_unable' => "Невозможно включить антиспам",
    'mn_list__tab_cp_access' => "Р",
    'mn_list__tab_title_client' => 'Клиент',
    'mn_list__tab_title_domain' => 'Домен',
    'mn_list__tab_title_autoresp' => "В",
    'mn_list__tab_title_box' => "Байт",
    'mn_list__tab_title_group' => "Г",
    'mn_list__tab_title_name' => "Имя",
    'mn_list__tab_title_redirect' => "П",
    'mn_list__tab_title_spamfilter' => "С",
    'mn_list__tab_title_virusfilter' => 'АВ',
    'mn_list__tab_title_drweb' => 'АВ',
    'mn_list__unable_remove_mns' => "Невозможно удалить учетные записи электронной почты: %1",
    'module_upload__module_was_installed' => 'Этот модуль уже установлен. Если вы хотите установить более свежую версию модуля, пожалуйста, удалите его через Plesk и затем попробуйте выполнить установку.',
    'module_upload__unable_to_install' => 'Не удалось установить файл пакета модуля',
    'module_upload__wrong_package' => 'Загруженный файл не является поддерживаемым пакетом модуля.',
    'module_upload__wrong_module' => 'Загруженный файл не поддерживает пакет модуля.',

    'news_articles_title' => 'Новости Plesk',
    'notification_text__invalid_subject_length' => "Неверная длина темы уведомления. Она должна составлять от 1 до 255 символов.",
    'notification_text__invalid_text_length' => "Недопустимая длина текста уведомления. Длина сообщения должна быть не менее 1 и не более 65533 символов.",
    'notification_text__subject' => "Тема уведомления",
    'notification_text__text' => "Текст уведомления",
    'notification_text__title' => "Редактирование уведомления",
    'notification_text__unable_set_text' => "Невозможно изменить текст уведомления:",

    'odbc__cant_add_dsn' => "Невозможно добавить источник данных %1: %2",
    'odbc__cant_connect' => "Невозможно подключиться к источнику данных с указанными параметрами. Сервер вернул: %1",
    'odbc__cant_delete_dsn' => "Невозможно удалить источник данных %1: %2",
    'odbc__cant_get_drivers_info' => "Невозможно получить сведения о драйверах.",
    'odbc__cant_get_drivers' => "Невозможно получить список драйверов ODBC : %1",
    'odbc__cant_open_info_file' => "Невозможно открыть файл с информацией о драйверах ODBC.",
    'odbc__cant_parse_string' => "Невозможно распознать строку соединения.",
    'odbc__driver_not_set' => "Драйвер не установлен",
    'odbc__driver_or_name_not_set' => "Не установлен драйвер или название подключения к ODBC",
    'odbc__dsn_already_exists' => "Источник данных с таким именем (%1) уже есть в системе",
    'odbc__dsn_not_exists' => "Такого источника нет",
    'odbc__enter_dsn_name' => "Введите имя источника данных",
    'odbc__invalid_dsn_name' => "Неверный синтаксис названия соединения с ODBC (%1): пожалуйста, используйте только буквенно-цифровые символы.",
    'odbc__no_such_driver' => "Драйвер ODBC с таким именем (%1) не поддерживается.",
    'odbc__unknown_driver' => "Неизвестное имя драйвера (%1).",
    'odbc_dsn_system' => "Системный источник",

    'pb__aliases' => "Псевдонимы",
    'pb__anonftp' => "Анонимный FTP",
    'pb__autoinstaller_releases' => 'Программа обновления',
    'pb__cert' => "Сертификаты",
    'pb__cl_pool' => "IP-адреса",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Настройки",
    'pb__cl_rpt' => "Отчет",
    'pb__cl_rpt_list' => "Настроить",
    'pb__cl_templates' => "Шаблоны клиентов",
    'pb__cl_traffic' => "Трафик",
    'pb__cl_traffic_history' => "Статистика трафика",
    'pb__cl_traffic_of' => "Трафик %1",
    'pb__client' => "%1",
    'pb__clients' => "Клиенты",
    'pb__comp_info' => "Серверные компоненты",
    'pb__common_acl' => 'Разрешить перенос зоны на основании записей в Списке контроля доступа (ACL)',
    'pb__cp_access' => "Доступ",
    'pb__crontab' => "Планировщик",
    'pb__scheduler' => "Планировщик",
    'pb__custom_buttons' => "Персональные кнопки",
    'pb__databases_db' => 'Базы данных',
    'pb__sqlservers_db' => 'Сервера SQL',//to check
    'pb__db' => "Базы данных",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Серверы баз данных',
    'pb__dl_usr_ed' => "Администратор домена",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Ограничения домена",
    'pb__dom_pref' => "Настройки",
    'pb__dom_sum_report' => "Сводный отчет по доменам",
    'pb__dom_templates' => "Шаблоны доменов",
    'pb__dom_traffic' => "Трафик %1",
    'pb__domains' => "Домены",
    'pb__domain_aliases' => 'Псевдонимы домена',
    'pb__dumps_list' => "Хранилище резервных копий",
    'pb__forwarding_setup' => "Настройка перенаправления",
    'pb__filemanager' => "Менеджер файлов",
    'pb__ip_aliasing' => "IP-адреса",
    'pb__ip_clients' => "Удаление IP адресов",
    'pb__license_management' => 'Информация о лицензии',
    'pb__locales' => 'Локали',
    'pb__log_files' => "Журналы",
    'pb__mail' => 'Почта',
    'pb__mail_name_files' => "Прикрепляемые файлы",
    'pb__mail_name_redirects' => "Перенаправление почты",
    'pb__mail_name_resp_attach_add' => "Новый прикрепляемый файл",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Автоответчики",
    'pb__mail_names' => "Почта",
    'pb__maillists' => "Списки рассылки",
    'pb__mimetypes' => 'Типы MIME',
    'pb__modules' => 'Модули',
    'pb__modules_management' => 'Управление модулями',
    'pb__notifications' => "Уведомления",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Настройка физического хостинга",
    'pb__prtd_dirs' => "Защищенные папки",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Отчет",
    'pb__report_auto' => "Расписание доставки на %1",
    'pb__report_list' => "Настроить",
    'pb__server' => "Сервер",
    'pb__sessions' => "Сеансы",
    'pb__sapp_pool' => "Пул веб-приложений",
    'pb__siteapp_install' => 'Установка веб-приложения',
    'pb__site_app_pkgs' => 'Веб-приложения',
    'pb__site_apps' => "Веб-приложения",
    'pb__additional_key_info' => 'Свойства ключа',
    'pb__additional_key_properties' => 'Свойства ключа',
    'pb__skeleton' => 'Шаблон виртуального сервера',
    'pb__skins' => 'Темы',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Антиспам",
    'pb__statistics' => "Статистика",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Субдомены",
    'pb__templates' => "Шаблоны",
    'pb__virtualdirs' => 'Виртуальные папки',
    'pb__web_users' => "Веб-пользователи",
    'pdir__enter_dir_name' => "Введите имя папки.",
    'pdir__invalid_hst' => "Недопустимый тип хостинга. Должен быть физическим.",
    'pdir__pd_id_is_undefined' => "Идентификатор защищенной папки не определен.",
    'pdir__pdir_exist' => "Папка с таким именем уже защищена.",
    'pdir__pdir_not_exist' => "Такой защищенной папки не существует.",
    'pdir__pdir_usr_not_exist' => "Такого пользователя защищенной папки не существует.",
    'pdir__remove_pdir_usrs' => "Будут удалены следующие пользователи защищенной папки %2 сайта %1:",
    'pdir__remove_pdir_usrs_on_subdom' => "Будут удалены следующие пользователи защищенной папки %2 субдомена %1:",
    'pdir__select_pdir_usrs_for_remove' => "Выберите пользователей защищенной папки, которых вы хотите удалить.",
    'pdir__select_pdirs_to_remove' => "Выберите папки, с которых вы хотите снять защиту.",
    'pdir__unable_define_pdir_users' => "Невозможно определить пользователей защищенной папки.",
    'pdir__unable_define_pdirs_properties' => "Невозможно установить свойства защищенных папок: %1",
    'pdir__unable_select_dom_param' => "Невозможно выбрать параметры домена: %1",
    'pdir_ed__create_pdir_for_domain' => "Создать защищенную папку для: %1",
    'pdir_ed__create_pdir_for_subdomain' => "Создать защищенную папку в субдомене %1",
    'pdir_ed__dir_already_protect' => "Эта папка уже защищена.",
    'pdir_ed__head_txt' => "Название защищенного раздела",
    'pdir_ed__invalid_login' => "Недопустимое имя пользователя.",
    'pdir_ed__login_exists' => "Такой пользователь уже существует. Укажите другое имя пользователя.",
    'pdir_ed__new_usr' => "Имя пользователя",
    'pdir_ed__non_ssl' => "не-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Имя папки",
    'pdir_ed__pdir_for_domain' => "Защищенная папка %1 домена %2",
    'pdir_ed__pdir_for_subdomain' => "Защищенная папка %1 субдомена %2",
    'pdir_ed__pdir_location' => "Расположение папки",
    'pdir_ed__pdir_users' => "Пользователи защищенной папки",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Выберите хотя бы одну опцию.",
    'pdir_ed__unable_cr_pdir_usr' => "Невозможно создать пользователя защищенной папки: %1",
    'pdir_ed__unable_create_pdir' => "Невозможно создать защищенную папку: %1",
    'pdir_ed__unable_define_hst_type' => "Невозможно определить тип хостинга.",
    'pdir_ed__unable_update_pdir' => "Невозможно сохранить настройки защищенной папки: %1",
    'pdir_ed__wrong_symbol_in_header' => "Пожалуйста, не используйте символ %1 в имени папки.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Создать пользователя защищенной папки %1",
    'pdir_usr_ed__not_create_pass' => "В результате выполнения этой операции не будет создан пароль для нового пользователя защищенной папки. \nБез пароля этот пользователь не сможет войти под своей учетной записью.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Пароль пользователя защищенной папки %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Невозможно выбрать пользователя защищенной папки: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Невозможно определить пользователей защищенной папки: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Невозможно удалить пользователей защищенной папки: %1",
    'phosting__anonftp_encrypt' => 'Пароль пользователя FTP зашифрован и поэтому не может быть использован для защиты папки /plesk-stat/webstat/. Введите повторно свой пароль FTP или уберите галочку "доступно в защищенной паролем папке \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Имя домена %%domain_name%% соответствует IP-адресу %%dns_ip_address%%. Ваш сайт имеет IP-адрес %%hosting_ip_address%%. Если ваш сайт не открывается в браузере по доменному имени, откройте страницу управления DNS (Домены > имя домена > DNS) и внесите изменения в свойства ресурсной записи A: присвойте IP-адрес %%hosting_ip_address%% доменному имени %%domain_name%%.",
    'phosting__ip_change_warning' => "IP-адрес был изменен. Соответствующие изменения были также внесены в зону DNS домена.",
    'phosting__other_hosting_exists_on_ip' => "Невозможно сменить сертификат, так как IP-адрес уже используется в одной или нескольких учетных записях хостинга.",
    'phosting__unable_to_change_certificate' => "Невозможно установить сертификат: %1",
    'phosting__unable_to_change_ip_address' => "Невозможно изменить IP-адрес: %1",
    'phosting__unable_to_set_cert' => "Невозможно установить SSL/TLS-сертификат: %1",
    'phosting__unable_update' => "Невозможно обновить настройки хостинга: %1",
    'phosting__unable_manage' => "Управление хостингом невозможно: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Настроить отслеживание журналов домена в Fail2Ban не удалось. Журналы начнут автоматически отслеживаться после очередной перезагрузки службы Fail2Ban.\n%1",

    'picker_acl_record__tittle' => 'Выбрать запись из списка контроля доступа (ACL)',
    'picker_autoresponder__title' => 'Выберите автоответчик',
    'picker_black_list__domain_name' => 'Выберите имя домена',
    'picker_certificate' => 'Выбрать SSL/TLS-сертификат',

    'picker_dns_zone_template__title' => 'Выбрать запись ресурса',
    'picker_domain__title' => 'Выберите веб-сайт',
    'picker_domain_alias__title' => 'Выберите псевдоним домена',
    'picker_resource_record__title' => 'Выбрать запись ресурса',
    'picker_disabled_resource_record__title' => 'Выберите имя сервера',
    'picker_ip_address__title' => 'Выберите IP-адрес',
    'picker_ip_address_clients__title' => 'Выберите клиентов, использующих этот IP-адрес',
    'picker_mail_queue' => 'Выберите сообщения',
    'picker_site_application__title' => 'Выбрать веб-приложение',
    'picker_subdomain__title' => 'Выбрать субдомен',
    'picker_web_user__title' => 'Выбрать учетную запись веб-пользователя',
    'picker_custom_button__title' => 'Выбрать персональную кнопку',
    'picker_license_key__title' => "Выбор лицензионного ключа",
    'picker_spamfilter_address__title' => 'Выбрать адрес антиспама',
    'picker_white_list__networks' => 'Выбор сети',

    'plesk_key__action_logs' => "Ведение журнала действий, выполняемых пользователями Plesk",
    'plesk_key__app_vault' => "Хранилище приложений",
    'plesk_key__backup' => "Функции резервного копирования и восстановления",
    'plesk_key__client_templs' => "Управление тарифными планами",
    'plesk_key__clients' => "Учетные записи пользователей (реселлеры и клиенты)",
    'plesk_key__resellers_only' => "Учетные записи (реселлеров)",
    'plesk_key__customers_only' => "Учетные записи (клиентов)",
    'plesk_key__domains' => "Домены",
    'plesk_key__domain_aliases' => "Псевдонимы домена",
    'plesk_key__manage_dashboard' => 'Настройка Домашней страницы',
    'plesk_key__drweb' => "Управление антивирусом",
    'plesk_key__event_manager' => "Менеджер событий",
    'plesk_key__expirations' => "Управление сроками окончания действия учетных записей",
    'plesk_key__group_ops' => "Групповые операции над объектами",
    'plesk_key__expiration' => "Срок действия",
    'plesk_key__edition_name' => "Издание Plesk",
    'plesk_key__key_number' => "Номер ключа",
    'plesk_key__languages' => "языков",
    'plesk_key__mailnames' => "Учетные записи почты",
    'plesk_key__migration_manager' => "Менеджер миграции и переноса",
    'plesk_key__mssql' => "Поддержка Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Ссылки на покупку SSL/TLS-сертификатов и услуг регистрации доменов",
    'plesk_key__myplesk_server_id' => "Идентификатор подчиненного сервера MPC",
    'plesk_key__notifications' => "Управление уведомлениями",
    'plesk_key__postgresql' => "Поддержка сервера баз данных PostgreSQL",
    'plesk_key__qmail_queue' => 'Управление почтовыми очередями',
    'plesk_key__remote_db' => 'Удаленный хостинг баз данных',
    'plesk_key__slave_servers' => "Подчиненные серверы",
    'plesk_key__spamassassin' => "Управление антиспамом",
    'plesk_key__subdomains' => "Управление субдоменами",
    'plesk_key__sys_access' => "Управление доступом к серверу",
    'plesk_key__traffic_reports' => "Отчеты расхода трафика",
    'plesk_key__tts' => "Служба поддержки",
    'plesk_key__virtuozzo' => "Действительно только для контейнеров Virtuozzo",
    'plesk_key__webusers' => "Веб-пользователи",
    'plesk_key__license_update_date' => 'Следующее обновление',
    'plesk_key__autoinstaller_config' => 'Управление настройками программы обновления',
    'plesk_key__check_wrong' => "Этот ключ лицензии недействителен. Чтобы использовать Plesk, пожалуйста, купите и установите новый ключ лицензии.",
    'plesk_key__upload_check_wrong' => 'Загруженный лицензионный ключ не действителен.',
    'plesk_key__revert_check_wrong' => 'Ранее установленный лицензионный ключ не действителен.',
    'plesk_key__update_check_wrong' => 'Обновленный лицензионный ключ не действителен.',
    'plesk_key__viruozzo_only_key' => 'Этот ключ лицензии предназначен только для Plesk под управлением контейнеров Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Вы можете использовать эту лицензионную копию Plesk только со следующими IP-адресами: %2. Следующие IP-адреса не покрываются вашей лицензией: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Текущий объем используемых ресурсов превышает ограничения, заданные вашей лицензией.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Количество веб-сайтов, размещенных на сервере, превышает ограничение, определенное вашей лицензией. У Вас размещено %2 сайтов; ваша лицензия позволяет размещать только %1 сайтов.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Количество псевдонимов доменов на сервере превышает ограничение, заданное вашей лицензией. Текущее количество псевдонимов — %2; разрешено лицензией — %1.',
    'plesk_key__limits_exceeded_lim_cl' => 'Количество предоставляемых учетных записей клиентов превышает ограничение, определенное вашей лицензией. В данный момент вы предоставляете %2 учетных записей клиентов; ваша лицензия позволяет предоставлять только %1 учетных записей клиентов.',
    'plesk_key__limits_exceeded_lim_mn' => 'Количество предоставляемых учетных записей почты превышает ограничение, определенное вашей лицензией. В данный момент вы предоставляете %2 учетных записей почты; ваша лицензия позволяет предоставлять только %1 учетных записей почты.',
    'plesk_key__limits_exceeded_lim_wu' => 'Количество обслуживаемых персональных веб-страниц превышает лимит, определенный Вашей лицензией. В данный момент Вы обслуживаете %2 персональных веб-страниц; Ваша лицензия позволяет обслуживать только %1.',
    'plesk_key__limits_exceeded_MLS' => 'Количество установленных пакетов локализации превышает ограничения, определенные вашей лицензией. Количество установленных пакетов локализации равно %2; количество пакетов локализации, которое позволяет установить ваша лицензия, составляет всего %1.',
    'plesk_key__wrong_version' => 'Вы пытаетесь использовать ключ лицензии, созданный для другой версии Plesk. Обратитесь в службу продаж Plesk, чтобы получить правильный лицензионный ключ.',
    'plesk_key__other_product' => 'Вы пытаетесь использовать лицензионный ключ, созданный для другого продукта. Обратитесь в службу продаж Plesk, чтобы получить правильный лицензионный ключ.',
    'plesk_key__invalid_machine_id_trial' => 'Ваша текущая лицензия недействительна, так как она уже активирована на другом сервере Plesk. Чтобы продолжить пользоваться Plesk, установите новую лицензию или переустановите текущую с помощью кода активации (если он у вас есть).',
    'plesk_key__invalid_machine_id_retail' => 'Ваша текущая лицензия недействительна, поскольку она уже активирована на другом сервере Plesk. Лицензионное соглашение конечного пользователя Plesk (https://www.plesk.com/legal/) запрещает активацию одной лицензии на двух или более серверах одновременно. Чтобы продолжить пользоваться Plesk, установите новую лицензию или переустановите текущую еще раз, введя код активации. <br>Не можете найти код активации? Его можно восстановить с помощью Plesk 360. Чтобы это сделать, войдите на сайте https://platform360.io/ с помощью адреса электронной почты, с которого вы приобретали лицензию, и перейдите во вкладку "Лицензии", где вы увидите свой код активации. Также вы можете связаться со службой поддержки лицензирования и покупок Plesk, заполнив онлайн-форму (https://www.plesk.com/licensing-and-purchase-support/). Не забудьте в графе "How can we help you?" указать номер своей лицензии.',
    'plesk_key__limits_exceeded_error' => 'Невозможно установить лицензионный ключ: объем уже используемых ресурсов превышает ограничения, установленные в загружаемом лицензионном ключе.',
    'plesk_key__limits_exceeded_note' => 'Объем уже используемых ресурсов превышает ограничения, установленные в загружаемом лицензионном ключе.',
    'plesk_key__key_file_invalid' => 'Загруженный файл ключа недействителен или не содержит лицензионный ключ.',
    'plesk_key__server_request_error' => 'Не удалось обновить лицензию. Удостоверьтесь в том, что подключения к серверу лицензий ka.plesk.com на TCP-порту %1 не заблокированы. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Читайте о том, как это сделать</a>.',
    'key__no_key_file_in_zip' => 'Загруженный .zip файл не содержит файл ключа',
    'key__key_upload' => 'Установка лицензионного ключа',
    'additional_key__prop_name' => 'Свойство',
    'additional_key__prop_value' => 'Значение',
    'additional_key__descr_name' => 'Имя ключа',
    'additional_key__descr_key_number' => 'Номер ключа',
    'additional_key__descr_key_vz' => "Этот лицензионный ключ предназначен только для использования с контейнерами Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Почтовые ящики',
    'additional_key__descr_lim_date' => 'Срок действия',
    'additional_key__descr_license_update_date' => 'Следующее обновление',
    'additional_key__file_invalid' => 'Загруженный файл ключа недействителен или не содержит лицензионный ключ.',
    'additional_key__file_incompatible' => 'Загруженный файл ключа недействителен для данного приложения.',
    'additional_key__expired' => 'Срок действия этого дополнительного ключа истек.',
    'additional_key__not_exists' => 'Лицензионные ключи не установлены.',
    'additional_key__viruozzo_only_key' => 'Этот лицензионный ключ предназначен только для использования с Plesk, установленным в контейнерах Virtuozzo.',
    'additional_key_update__result_response' => 'Ответ сервера лицензирования: %1',
    'additional_key_update__result_network' => 'Не удалось подключиться к серверу лицензирования. Убедитесь, пожалуйста, что ваши сетевые настройки разрешают подключение к %1: %2.',
    'additional_key_update__result_lock' => 'Происходит обновление ключа',
    'additional_key_update__result_internal_error' => 'При обновлении лицензионного ключа произошла ошибка: %1',

    'proceed_to_cl_pool' => "Перейти к конфигурированию IP-пула клиента",
    'proceed_to_hosting_setup' => "Перейти к настройке хостинга",
    'removeCerts__remove_certificates_cp' => "Следующие сертификаты будут удалены:",
    'removeCerts__remove_certificates_domain' => "Следующие сертификаты, принадлежащие %1 будут удалены:",
    'removeClientsIP_remove_clients_ip' => "Этот IP-адрес будет удален из пулов следующих клиентов:",
    'removeMailAliases__remove_mail_aliases' => "Будут удалены следующие псевдонимы учетной записи почты %1:",
    'removeMailNames__remove_mailnames' => "Из домена %1 будут удалены следующие почтовые учетные записи и псевдонимы:",
    'removeMailNames__remove_mailnames_of_cl' => "Следующие почтовые учетные записи и псевдонимы будут удалены из домена %2, принадлежащего клиенту %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Эти учетные записи электронной почты не могут быть удалены.",
    'removeFtpSessions__remove_title' => "Следующие сеансы FTP будут завершены:",
    'removeTemplates__remove_templates' => "Следующие шаблоны будут удалены:",
    'report_auto__list_title' => 'Д',
    'report_auto__list_auto' => 'Частота',
    'report_auto__list_last' => 'Дата последней доставки',
    'report_auto__list_recipient' => 'Доставить',
    'report_auto__list_select' => 'Отчет по',
    'report_auto__title' => 'Расписания доставки для %1',
    'report_auto__recipient_email' => 'на указанный адрес электронной почты',
    'report_auto__recipient_admin' => 'администратору сервера',
    'report_auto__recipient_client' => 'клиенту',
    'report_auto__recipient_domain' => 'администратору домена',
    'report_auto_edit__select' => 'Отчет по',
    'report_auto__select_client_report_all' => 'все клиенты',
    'report_auto__select_client_report_current' => 'Этот клиент',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'всем доменам',
    'report_auto__select_domain_report_other_client' => 'всем доменам %1',
    'report_auto__select_domain_report_client' => 'все домены этого клиента',
    'report_auto__select_domain_report_reseller' => 'всем доменам этого реселлера',
    'report_auto__select_domain_report_current' => 'этому домену',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Расписания отчетов',
    'report_auto__select_for_remove' => "Выберите расписания отчетов для удаления.",
    'report_auto_remove__title' => "Следующие расписания отчетов будут удалены:",
    'report_auto_edit__title' => 'Свойства расписания доставки',
    'report_auto_edit__recipient' => 'Доставить',
    'report_auto_edit__target' => 'Отчет по',
    'report_auto_edit__auto' => 'Частота доставки',
    'resp_edit__always_respond' => "отвечать всегда",
    'resp_edit__reply_subject' => "Тема ответа",
    'resp_edit__answer_subject' => "Отвечать с темой",
    'resp_edit__answer_txt' => "Отвечать сообщением",
    'resp_edit__attach' => "Прикрепить файлы",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "для",
    'resp_edit__frw_rqst_email' => "При автоматическом ответе перенаправлять исходное сообщение на указанный адрес",
    'resp_edit__fwd_email_invalid' => "Указан недопустимый адрес электронной почты.",
    'resp_edit__in_body' => "в тексте письма",
    'resp_edit__in_subject' => "в поле \"Тема\"",
    'resp_edit__invalid_resp_freq' => "Недопустимая частота ответов.",
    'resp_edit__invalid_rqst_txt' => "Недопустимый текст запроса.",
    'resp_edit__invalid_store_lim_num' => "Указано недопустимое значение.",
    'resp_edit__limits_title' => "Ограничения",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Максимально допустимая частота ответов в день превышает установленное ограничение. Разрешено: %1, запрошено: %2",
    'resp_edit__no_files_sel' => "Выберите файл.",
    'resp_edit__no_txt_supplied' => "Введите текст.",
    'resp_edit__reply_title' => "Ответить",
    'resp_edit__reply_to_address' => "Обратный адрес",
    'resp_edit__reply_to_invalid' => "Недопустимый обратный адрес.",
    'resp_edit__reply_uniq_email' => "Отвечать на сообщения с уникального адреса электронной почты не чаще, чем",
    'resp_edit__conditions_title' => "Условия",
    'resp_edit__request_title' => "Запросить",
    'resp_edit__resp' => "Автоответчик",
    'resp_edit__resp_name' => "Имя автоответчика",
    'resp_edit__resp_not_exist' => "Автоответчик не существует.",
    'resp_edit__resp_status' => "Статус автоответчика",
    'resp_edit__rqst_txt' => 'Текст входящего письма',
    'resp_edit__select_files_on_server_for_attach' => "Выберите файлы, которые хотите прикрепить",
    'resp_edit__store_up_to' => "Запоминать до",
    'resp_edit__subj_line_invalid' => "Недопустимое значение в поле \"Тема\".",
    'resp_edit__text_too_big' => "Текст ответного сообщения слишком велик.",
    'resp_edit__times_in_a_day' => "раз в день.",
    'resp_edit__unable_define_resp_cond' => "Невозможно определить состояние автоответчика: %1",
    'resp_edit__unable_define_resp_status' => "Невозможно определить статус автоответчика: %1",
    'resp_edit__unable_turn_on_resp' => "Невозможно включить автоответчик: %1",
    'resp_edit__uniq_email' => "уникальные адреса электронной почты",
    'resp_edit__content_type' => 'Формат почтового сообщения с отчетом',
    'resp_edit__content_type_text' => 'Обычный текст',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Кодировка',
    'restart__dns' => 'Сервер DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Сервер IMAP/POP3 (%1)",
    'restart__mssql' => "Сервер Microsoft SQL",
    'restart__mysql' => "Сервер MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Службы",
    'restart__smtp' => "Сервер SMTP (%1)",
    'restart__spamd' => "Антиспам",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Веб-сервер (%1)",
    'restart__ftp' => "Сервер FTP (%1)",
    'restart__service_start' => 'Для запуска службы требуется некоторое время.',
    'restart__service_stop' => 'Для остановки службы требуется некоторое время.',
    'restart__service_restart' => 'Для перезапуска службы потребуется некоторое время.',
    'rm_domains__some_domains_are_not_exist' => "Некоторые из указанных доменов не существуют. Возможно, они были удалены другим пользователем.",
    'rpt_cl_dom_data_bases' => "Базы данных MySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "Почтовые группы",
    'rpt_cl_dom_mail_lists' => "Списки рассылки",
    'rpt_cl_dom_mail_resps' => "Автоответчики",
    'rpt_cl_dom_mail_antispam' => "Антиспам",
    'rpt_cl_dom_mail_antivirus' => "Антивирус",
    'rpt_cl_dom_postboxes' => "Почтовые ящики",
    'rpt_cl_dom_redirects' => "Перенаправление",
    'rpt_cl_dom_subdomains' => "Субдомены",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "Веб-пользователи",
    'rpt_cl_report_for_admin__' => "Отчет для администратора %1",
    'rpt_cl_report_for_reseller__' => "Отчет для реселлера %1",
    'rpt_cl_report_for_cl__' => "Отчет о клиенте %1",
    'rpt_cl_section_domains' => "Домены",
    'rpt_cl_section_full_domains' => "Домены",
    'rpt_cl_section_general' => "Общие",
    'rpt_create' => "Создать отчет",
    'rpt_empty' => "Отчет должен содержать хотя бы одну секцию",
    'rpt_default_report' => "Использовать по умолчанию",
    'rpt_dom_report_for_dom__' => "Отчет о домене %1",
    'rpt_dom_section_databases' => "Базы данных",
    'rpt_dom_section_full_databases' => "Базы данных",
    'rpt_dom_section_full_maillists' => "Списки рассылки",
    'rpt_dom_section_full_mailnames' => "Учетные записи почты",
    'rpt_dom_section_full_webusers' => "Веб-пользователи",
    'rpt_dom_section_full_siteapps' => 'Веб-приложения',
    'rpt_dom_section_full_aspnetapps' => 'Веб-приложения ASP.NET',
    'rpt_dom_section_general' => "Общие",
    'rpt_dom_section_hosting' => "Хостинг",
    'rpt_dom_section_maillists' => "Списки рассылки",
    'rpt_dom_section_mailnames' => "Учетные записи почты",
    'rpt_dom_section_siteapps' => 'Веб-приложения',
    'rpt_dom_section_aspnetapps' => 'Веб-приложения ASP.NET',
    'rpt_dom_section_webusers' => "Веб-пользователи",
    'rpt_dom_title_wa_status' => "С",
    'rpt_edit__' => "Редактирование отчета %1",
    'rpt_enter_email_address' => "Введите адрес электронной почты для доставки отчета.",
    'rpt_list' => "Настраиваемые шаблоны отчетов",
    'rpt_name' => "Название отчета",
    'rpt_remove_reports' => "Следующие шаблоны отчетов будут удалены:",
    'rpt_reports' => "Отчеты",
    'rpt_section_full' => "Полный",
    'rpt_section_none' => "Нет",
    'rpt_section_summary' => "Описание",
    'rpt_select_reports_for_remove' => "Выберите шаблоны отчетов на удаление.",
    'rpt_default_full' => 'Полный отчет',
    'rpt_default_summary' => 'Сводный отчет',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Ошибка при отправке отчета: %1",
    'rpt_send_report_by_email_ok__' => "Отчет отправлен по адресу %1",
    'sa_action' => "Действие",
    'sa_action_del' => "Удалить",
    'sa_action_desc' => "Что делать со спамом",
    'sa_action_save' => "Пометить как спам и сохранить в почтовом ящике",
    'sa_admin_blacklist' => "Черный список администратора",
    'sa_admin_whitelist' => "Белый список администратора",
    'sa_db_del_confirm' => "Вы действительно хотите очистить базу данных антиспама?",
    'sa_eml_in_ignorelist' => "Адрес находится в списке игнорируемых",
    'sa_empty_email' => "Нельзя добавить пустой шаблон электронной почты.",
    'sa_exists_email' => "Такой шаблон электронной почты уже существует.",
    'sa_disabled__mailname_not_filtering' => "Текущие настройки сервера запрещают фильтрацию почты для этой учетной записи",
    'sa_disabled__filtering_is_disabled' => 'Антиспам был отключен администратором сервера',
    'sa_disabled__hasnt_mailbox' => "Антиспам не может быть включен без почтового ящика",
    'sa_enable_filter' => "Включить антиспам",
    'sa_forget' => "сбросить",
    'sa_from' => "От",
    'sa_ham' => "нормальная почта",
    'sa_pattern_is_invalid' => "Неверный образец.",
    'sa_spam' => "спам",
    'sa_trainer__page_title' => 'Обучение антиспама',
    'sa_trainer__tools_legend' => 'Инструменты',
    'sa_trainer__info_legend' => 'Информация',
    'sa_trainer__messages_list_legend' => 'Сообщения в вашем почтовом ящике',
    'sa_trainer__c' => 'Тип',
    'sa_trainer__l' => 'Р',
    'sa_trainer__subject' => 'Тема',
    'sa_trainer__from' => 'От',
    'sa_trainer__date' => 'Дата',
    'sa_trainer__info_text' => 'Запомненные сообщения: %1 как спам, %2 как не спам, %3 всего.',
    'sa_trainer__messages' => 'сообщение(я)',
    'sa_trainer__select__all' => 'Все',
    'sa_trainer__select__spam_only' => 'Спам',
    'sa_trainer__select__ham_only' => 'Не спам',
    'sa_trainer__select__unknown_only' => 'Неизвестно',
    'sa_trainer__cannot_remove_messages' => 'Не удалось удалить выбранные сообщения из почтового ящика.',
    'sa_trainer__remove_messages_confirm' => 'Вы уверены, что Вы хотите удалить выбранные сообщения из почтового ящика?',
    'sa_subj' => "Тема",
    'sa_training' => "Обучение антиспама",
    'sa_training_legend' => "Обучение байесовского фильтра",
    'sa_use_srv_settings' => "Использовать серверные настройки",
    'sa_user_blacklist' => "Персональный черный список",
    'sa_user_whitelist' => "Персональный белый список",
    'sa_usr_disabled_by_srv' => "Индивидуальная настройка антиспама запрещена администратором сервера",
    'sa_usr_no_postbox' => "Не удалось включить антиспам, потому что почтовый ящик для этой почтовой учетной записи отключен.",
    'sa_filters' => 'Антиспамы',
    'spamfilter__tools_legend' => 'Инструменты',
    'spamfilter__prefs_legend' => 'Настройки',
    'spamfilter__max_children' => 'Максимальное количество рабочих процессов spamd',
    'spamfilter__rewrite_header_subject_hint' => 'Если вы не хотите добавлять никакой текст, оставьте это поле пустым. Если вы хотите, чтобы в тему письма добавлялось количество баллов, введите _SCORE_.',
    'spamfilter__reject_spam' => 'Удалять письма, содержащие спам, когда они поступают в почтовый ящик',
    'spamfilter__enabled' => 'Включено',
    'spamfilter_addresses_list__tools_legend' => 'Инструменты',
    'spamfilter_addresses_list__list_legend' => 'Адреса',
    'spamfilter_addresses_list__items' => 'адреса',
    'spamfilter_addresses_list__status' => 'С',
    'spamfilter_addresses_list__level' => 'Р',
    'spamfilter_addresses_list__address' => 'Адрес',
    'spamfilter_addresses__file_legend' => 'Из файла',
    'spamfilter_addresses__file_label' => 'Имя файла',
    'spamfilter_addresses__file_hint' => 'Загрузить файл в кодировке UTF-8.',
    'spamfilter_addresses__text_legend' => 'Из списка',
    'spamfilter_addresses__text_label' => 'Почтовые адреса',
    'spamfilter_addresses__remove_title' => 'Следующие адреса будут удалены из списка:',
    'spamfilter_addresses__empty_selection' => 'Адреса не выбраны.',
    'server__admin_info' => "Сведения об администраторе",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Введите описание проблемы ниже:",
    'server__power_management' => "Управление питанием",
    'server__services' => "Службы",
    'server__system' => "Система",
    'server__title' => "Управление сервером",
    'server_preferences__admin_skin' => "Тема интерфейса администратора",
    'server_preferences__default_language' => "Язык по умолчанию",
    'server_preferences__default_skin' => "Скин по умолчанию",
    'server_preferences__restart_apache_interval' => "Интервал перезагрузки Apache",
    'server_preferences__system' => 'Настройки системы',
    'mail__tabs_preferences' => "Настройки",
    'mail__tabs_white_list' => "Белый список",
    'server_preferences__use_vocabulary' => "Проверять пароли для почтовых ящиков в словаре",
    'sessions__agreement' => "Да, я хочу удалить эти сеансы.",
    'sessions__select_sessions_for_remove' => "Выберите сеансы, которые нужно завершить.",
    'sessions__tabs_cp_sessions' => 'Сеансы Plesk',
    'sessions__tabs_ftp_sessions' => 'Сеансы FTP',
    'sessions__ftp_sessions_login' => 'Имя пользователя FTP',
    'sessions__ftp_sessions_domain' => 'Имя домена',
    'sessions__ftp_sessions_path' => 'Текущее местонахождение',
    'sessions__ftp_sessions_file' => 'Имя файла',
    'sessions__ftp_sessions_action' => 'Статус',
    'sessions__ftp_sessions_speed' => 'Скорость, Кб/с',
    'sessions__ftp_sessions_comp' => 'Загружено, %',

    'site_apps__access_level' => 'Уровень доступа',
    'site_apps__access_level_commercial' => 'Коммерческая',
    'site_apps__access_level_free' => 'Бесплатная',
    'site_apps__action_installer' => "Установка веб-приложения",
    'site_apps__action_reconfigure' => "Переконфигурирование веб-приложения",
    'site_apps__custom_button_level' => 'Хотите создать персональную кнопку для доступа к этому приложению?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Нет',
    'site_apps__custom_button_level_domain_user_only' => 'Да',
    'site_apps__custom_button_level_false' => 'Нет',
    'site_apps__custom_button_level_domain' => 'Да, и сделать ее доступной только для текущего домена',
    'site_apps__custom_button_level_client' => 'Да, и сделать доступной для всех доменов клиента.',
    'site_apps__custom_button_level_admin' => 'Да, и сделать ее доступной для всех доменов',
    'site_apps__description' => "Описание",
    'site_apps__dir_used_by_sapp__' => "Папка \"%1\" уже используется другим веб-приложением",
    'site_apps__dir_used_by_unknown__' => "Папка \"%1\" уже существует. Продолжение операции приведет к перезаписи ее содержимого.",
    'site_apps__dir_invalid_name__' => "Неверное имя папки %1",
    'site_apps__file_name' => 'Имя файла веб-приложения',
    'site_apps__invalid_install_prefix' => "Неверный префикс для инсталляции",
    'site_apps__invalid_package' => "Недопустимое веб-приложение",
    'site_apps__key_status' => 'Лицензионный',
    'site_apps__key_status_free' => 'Распространяется бесплатно. Лицензионный ключ не требуется.',
    'site_apps__key_status_ok' => 'Требуемый лицензионный ключ установлен',
    'site_apps__key_status_problem' => 'Требуемый лицензионный ключ не установлен',
    'site_apps__name' => "Имя",
    'site_apps__no_domains' => 'Невозможно установить веб-приложение. В корневой папке этого домена уже установлено другое веб-приложение. Рекомендуем создать для этого веб-приложения субдомен.',
    'site_apps__package_info_' => "Сведения о веб-приложении",
    'site_apps__package_integrated' => "встроенное веб-приложение, не может быть удалено",
    'site_apps__pool_select_packages_to_add' => 'Выберите веб-приложения для добавления в пул',
    'site_apps__release' => "Выпуск",
    'site_apps__resource_used_by_sapp' => "Этот ресурс используется установленным веб-приложением",
    'site_apps__root_used_by_sapp' => "Этот ресурс используется установленным веб-приложением",
    'site_apps__these_domains_will_not_delete' => 'Эти (суб)домены не будут удалены',
    'site_apps__upload_site_app_pkg_title' => 'Загрузить новое веб-приложение',
    'site_apps__version' => "Версия",
    'site_apps__access_to' => "Доступ к %1",
    'site_builder_requires' => '%1 — %3',
    'skeleton__admin_label' => "Шаблон виртуального сервера",
    'skeleton__client_label' => "Шаблон виртуального сервера пользователя %1",
    'skeleton__admin_page' => "Управление шаблоном виртуального сервера",
    'skeleton__files_list' => "Файлы и папки",
    'skeleton__archiver_not_installed' => "Невозможно распаковать архив. Возможно, на сервере не установлен архиватор. Обратитесь к администратору $PROD_NAME, чтобы он установил необходимую программу архивирования.",
    'skeleton__client_page' => "Управление шаблоном виртуального сервера",
    'skeleton__archive_corrupted' => "Проверка архива показала, что файл архива поврежден или не поддерживается.",
    'skeleton__archive_too_large' => "Проверка архива показала, что файл архива слишком велик.",
    'skeleton__not_supported_archive_type' => "Такой тип архивов (файл %1) не поддерживаются.",
    'skeleton__upload_archive_file' => "Загрузить файл архива",
    'skin_download__title' => 'Загрузить схему',
    'skin_download_now__title' => 'Загружается скин',
    'skin_download_now__text' => 'Выполняется создание пакета темы интерфейса.<br>Эта операция может занять некоторое время.<br> После появления диалогового окна вы сможете вернуться к работе с Plesk.',
    'skin_file__help_for_using_types' => "Пожалуйста, используйте архивы схем оформления в следующих форматах:",
    'skin_info__title' => 'Свойства скина',
    'skin_mng_err__rpm_not_skin' => 'Данный RPM-пакет не является пакетом с темой интерфейса Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Не удалось установить тему интерфейса в формате rpm в указанное место.',
    'skin_mng_err__already_exists' => 'Установочная папка этой темы интерфейса уже существует и содержит файлы.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Нельзя заменить скин не на основе rpm другим rpm пакетом',
    'skin_mng_err__rpm_upgrade_noskin' => 'Нельзя заменить rpm пакет, не являющийся скином, другим скином',
    'skin_mng_err__rpm_upgrade_base' => "Загружаемый файл не является корректным скин-пакетом для {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'Новый пакет не может заменить предыдущий',
    'skin_mng_err__no_a_skin' => "Загружаемый файл не является корректным скин-пакетом для {$PROD_NAME}.",
    'skin_upload__title' => 'Загрузка нового скина',
    'skin_upload__already_exists' => "Схема оформления '%1' уже существует.",
    'skin_upload__unable_to_apply' => "Загруженный файл не является темой интерфейса Plesk или имеет неподдерживаемый формат.",
    'skin_upload__unable_to_rename__' => "Невозможно переименовать схему оформления %2 в %1: %3.",
    'skin_upload__file_name' => 'Путь к файлу пакета скинов',
    'skins_list__title' => 'Управление скинами',
    'skins_remove__title' => 'Удаление скина',
    'skins_remove__select_skins_for_remove' => 'Выберите схемы оформления для удаления',

    'spf__unable_update' => 'Не удалось обновить параметры SPF',
    'statistics__active_domains' => "Активные домены",
    'statistics__clients' => "Клиенты",
    'statistics__subdomains' => "Субдомены",
    'statistics__cpu' => "Процессор",
    'statistics__databases' => "Базы данных",
    'statistics__db_users' => "Пользователи баз данных",
    'statistics__dirs' => "Защищенные папки",
    'statistics__dom_active' => "Активен",
    'statistics__dom_passive' => "Заблокированные",
    'statistics__dom_problem' => "Проблема",
    'statistics__domains' => "Домены",
    'statistics__domains_with_host' => "Домены с хостингом:",
    'statistics__doms' => "Домены",
    'statistics__filesystem' => "Файловая система",
    'statistics__general' => "Общие",
    'statistics__hdd_available' => "Доступна",
    'statistics__hdd_capacity' => "Объем",
    'statistics__hdd_total' => "Всего",
    'statistics__hdd_usage' => "Использование места на жестком диске",
    'statistics__hdd_used' => "Используется",
    'statistics__ip' => "IP-адрес",
    'statistics__key_number' => "Номер ключа",
    'statistics__l1' => "За последнюю минуту",
    'statistics__l15' => "За последние 15 минут",
    'statistics__l5' => "За последние 5 минут",
    'statistics__la' => "Загрузка процессора",
    'statistics__mail_autoresponders' => "Автоответчики",
    'statistics__mail_boxes' => "Почтовые ящики",
    'statistics__mail_groups' => "Почтовые группы",
    'statistics__mail_lists' => "Списки рассылки",
    'statistics__mail_redirects' => "Перенаправление почты",
    'statistics__mem' => "Использование памяти",
    'statistics__mem_usage' => "Использование",
    'statistics__memory_available' => "Доступна",
    'statistics__memory_buffer' => "Буфер",
    'statistics__memory_cached' => "Кэш",
    'statistics__memory_free' => "Бесплатная",
    'statistics__memory_shared' => "Общие",
    'statistics__memory_total' => "Всего",
    'statistics__memory_used' => "Используется",
    'statistics__os' => "ОС",
    'statistics__problem_clients' => "Проблемные клиенты",
    'statistics__problem_domains' => "Проблемные домены",
    'statistics__swap' => "Использование подкачки",
    'statistics__swap_free' => "Бесплатная",
    'statistics__swap_total' => "Всего",
    'statistics__swap_usage' => "Использование",
    'statistics__swap_used' => "Используется",
    'statistics__system_stat' => "Сведения о сервере",
    'statistics__unable_define_active_doms' => "Невозможно определить количество активных доменов: %1",
    'statistics__unable_define_inactive_doms' => "Невозможно определить количество заблокированных доменов: %1",
    'statistics__failed_define_swap_usage' => 'Не удалось определить использование файла подкачки',
    'statistics__failed_define_load_averages' => 'Не удалось определить среднюю нагрузку',
    'statistics__up_time' => "Длительность непрерывной работы системы:",
    'statistics__ver' => "Версия",
    'statistics__web_users' => "Веб-пользователи",
    'statistics__mem_win' => "Использование физической памяти",
    'statistics__memory_total_win' => "Всего",
    'statistics__memory_used_win' => "Используется",
    'statistics__memory_free_win' => "Доступна",
    'statistics__swap_win' => "Использование виртуальной памяти",
    'statistics__swap_total_win' => "Всего",
    'statistics__swap_used_win' => "Используется",
    'statistics__swap_free_win' => "Доступна",
    'status__domain_has_reasons_to_be_off' => "Домен все еще приостановлен по следующей причине: %1",
    'subdomain__create__' => "Создать субдомен в домене %1",
    'subdomain__edit__' => "Редактировать субдомен %1",
    'subdomain__invalid_name' => "Неверное имя субдомена: имя должно содержать только буквенно-цифровые знаки и дефис.",
    'subdomain__incorrect_name' => "Неверное имя субдомена.",
    'subdomains__maillists_enabled_in_domain' => "Неверное имя субдомена lists.%1: это доменное имя используется почтовыми рассылками на домене %1",
    'subdomains__dalias_exists' => 'Такой псевдоним домена уже существует.',
    'subdomains__name_exists' => "Субдомен с таким именем уже существует.",
    'subdomains__regular_domain_exists' => "Домен с таким именем уже существует.",
    'subdomains__domain_alias_exists' => 'Такой псевдоним домена уже существует.',
    'subdomains__remove_subdomains_on_domain' => "Следующие субдомены будут удалены из домена %1:",
    'subdomains__select_subdomains_for_remove' => "Выберите субдомены, которые хотите удалить.",
    'subdomains__webmail_enabled_in_domain' => "Неверное имя субдомена webmail.%1: это доменное имя используется для доступа к веб-почте на домене %1.",
    'subdomains__dns_record_already_exists' => 'Невозможно создать субдомен %1, так как запись DNS, указывающая на хост %1, уже существует.',
    'subdomains__www_prefix_in_domain' => "Неверное имя субдомена www.%1: домен %1 уже имеет префикс WWW.",
    'subdomains__user_type_quota_exceeds' => 'Невозможно изменить учетную запись пользователя, так как это приведет к превышению объема выделенного дискового пространства.',
    'subdomains__creation_in_dns_slave' => "Сервер имен Plesk служит вторичным сервером имен для этого домена. Для нормальной работы DNS на вашем субдомене убедитесь, что файл зоны на первичном сервере содержит запись %1.",
    'sys_user__attributes_not_changed' => "Следующие атрибуты системного пользователя не могут быть изменены: %1",
    'sys_user__no_access_without_password' => "Вы не указали пароль. Системный пользователь будет создан, но не сможет войти в систему, пока не получит пароль. Продолжить?",
    'sys_user__no_hard_quota' => "(не поддерживается)",
    'sysuser__zero_quota_is_unlimited' => "0 — неограниченно",
    'template__num_excl_ips' => "Предоставить выделенные IP-адреса клиенту",
    'template__sel_sh_ips' => "Выбранные общие IP-адреса",
    'template__av_sh_ips' => "Доступные общие IP адреса",
    'template__up_to_excl_ip' => "До %1 IP-адресов",
    'templates__all_clients' => "все клиенты",
    'templates__cl_domain_templates' => "Шаблоны для создания доменов для %1",
    'templates__cl_templates' => "Шаблоны клиентов",
    'time__invalid_ip' => "Недопустимый IP-адрес или имя домена.",
    '__please_select_country' => 'Пожалуйста, выберите страну',
    'time__unable_set_time' => "Невозможно установить системное время: %1",
    'time__sinchronization_setup_error' => 'Не удалось настроить синхронизацию времени: ошибка timemng: %1',
    'time__sinchronization_disable_error' => 'Не удалось отключить синхронизацию времени: ошибка timemng: %1',
    'tmpl__create' => "Создание шаблона",
    'tmpl__edit__' => 'Шаблон %1',
    'tmpl__logrotation_warn' => "Ротация журналов на домене, созданном по этому шаблону, будет выполняться только в случае последующего создания учетной записи физического хостинга.",
    'tmpl__name' => "Название шаблона",
    'tmpl__dom_exist' => "Шаблон домена с таким именем уже существует среди шаблонов администратора или клиента.",
    'tmpl__name_invalid' => "Недопустимое или пустое имя шаблона.",
    'tmpl__use_next_ip_addr' => "Будет использован следующий свободный IP-адрес",
    'tmpl_name_already_exists' => "Шаблон с именем '%1' уже существует.",
    'traffic__no_periods_found' => "Невозможно отобразить веб-статистику и статистику трафика. Данные будут доступны только при следующем подсчете статистики.",

    'vh_based__no_free_ip_for_vh' => "Нет свободных IP-адресов для виртуального хостинга на базе IP. Пожалуйста, добавьте IP-адрес.",

    'wu__at_domains_text' => "Разрешить формат доступа webuser@%1",
    'wu__unable_create' => "Невозможно создать веб-пользователя: %1",
    'wu_edit__disk_quota' => "Дисковая квота",
    'wu_edit__invalid_pass' => "Неправильный пароль.",
    'wu_edit__invalid_quota' => "Указано недопустимое значение квоты дискового пространства. Введите положительное целое число.",
    'wu_edit__invalid_quota_value' => "Указанная квота дискового пространства меньше используемой на данный момент (%1MB). Некоторые функции могут стать недоступными. Вы действительно хотите продолжить?",
    'wu_edit__not_create_pass' => "В результате этого действия не будет создан пароль для нового веб-пользователя.\nБез пароля пользователь не сможет войти в систему.",
    'wu_edit__unable_update' => "Невозможно сохранить свойства веб-пользователя: %1",

    'bt_webdirs' => 'Виртуальные папки',

    'dns__tabs_general' => 'Настройки зоны',
    'dns__tabs_zone_settings' => 'Записи SOA',
    'soa__seconds' => 'секунд',
    'soa__minutes' => 'минут',
    'soa__hours' => 'часов',
    'soa__days' => 'дней',

    'DomainSubdirectory' => 'Целевая подпапка',

    'filemanager__select_codepage' => 'Выберите кодировку:',

    'bt_server_app_add' => 'Добавить серверное приложение',
    'packages_list' => 'Серверные приложения',

    'bt_packages_management' => 'Управление пакетами',
    'pb__packages_management' => 'Управление приложениями',
    'bt_package_new' => 'Добавить приложение',
    '__packages' => 'Серверные приложения',

    'dom_ctrl__mysql_dbase_space' => 'Квота на базы данных MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Квота на базы данных MS SQL',

    'dns_add__enter_ixfr_path' => 'Введите путь к IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Запись SPF TXT уже существует. Запись SPF может быть только одна. Для добавления записи необходимо удалить уже существующую.',

    'component_name__network' => 'Сеть',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Установить схему',
    'bt_set_skin' => 'Установить схему',
    'firewall__rule_already_exists' => 'Правило с именем "%1" уже существует',
    'firewall__rule_readonly' => 'Правило "%1" доступно только для чтения',
    'pb__firewall' => 'Брандмауэр',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Неправильный путь к файлу.',

    'error_doc__erorr_invalid_url_location' =>  'Неправильный формат URL-адреса. Пожалуйста, введите абсолютный URL-адрес на виртуальном сервере (сайте).',

    'mn_list__tab_title_antivirus' => 'АВ',

    'bt_antivirus' => 'Антивирус',
    'antivirus__antivirus' => 'Антивирусная защита',
    'antivirus__antivirus_direction_off' => 'Отключить',
    'antivirus__antivirus_direction_any' => 'Входящие и исходящие сообщения',
    'antivirus__antivirus_direction_from' => 'Только исходящие сообщения',
    'antivirus__antivirus_direction_to' => 'Только входящие сообщения',
    'antivirus__unable_to_update_settings' => 'Невозможно изменить настройки антивирусной программы: %1',




    '__normal' => 'Обычная',
    '__low' => 'Низкий',
    '__high' => 'Высокий',

    'mail__antivirus' => "Внутренний антивирус почтового сервера",
    'mail__use_internal_antivirus' => 'Использовать внутренний антивирус',

    'sa__tabs_blacklist' => 'Черный список',

    '__mysql_databases' => 'Базы данных MySQL',

    'cl_perm__mysql_dbase_space' => 'Квота на базы данных MySQL',
    'cl_perm__mssql_dbase_space' => 'Квота на базы данных MS SQL',
    'cl_perm__max_mssql_db' => 'Максимальное количество баз данных Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Общая квота почтовых ящиков',

    'i_i_cl_on' => 'Учетная запись клиента активна.',
    'i_i_cl_off_by_admin' => 'Учетная запись клиента приостановлена администратором.',

    'sa_exists_tn' => 'Сеть уже присутствует в списке.',

    'webdir__select_vdirs_to_remove' => 'Выберите папки, которые вы хотите удалить',
    'webdir__select_mime_types_to_remove' => 'Выберите типы MIME, которые хотите удалить',

    'defaultcomponents__not_activated' => 'компонент не активирован',

    'bt_traffic_at_domains' => 'Трафик',

    '__awstats_perl_warning' => 'Без установленного Perl, AWStats не сможет показывать статистику по предыдущим годам.',

    'class_client__mysql_dbase_space' => 'Значение превышает ограничения клиента.',
    'class_client__mssql_dbase_space' => 'Значение превышает ограничения клиента.',
    'class_client__max_mssql_db' => 'Значение превышает ограничения клиента.',

    'dns__remove_transfer_restrictions_list_items' => 'Следующие сети будут удалены из списка контроля доступа:',

    'bt_up' => "Вверх",
    'bt_down' => "Вниз",
    'virtualdir__type_default_doc_name_to_add' => 'Введите имя файла для добавления в список',
    'virtualdir__select_default_doc_to_remove' => 'Выберите файлы для удаления из списка',
    'virtualdir__select_directory' => 'Выбрать папку',

    'bt_install_selected' => 'Установить выбранные лицензионные ключи', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Домен настроен на разрешение другого IP-адреса: (%1). Пожалуйста, измените настройки DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Используемый в настоящее время почтовый сервер не позволяет одновременно включить почтовый ящик и почтовые группы. Нажмите OK, чтобы включить почтовый ящик за счет отключения почтовых групп. Нажмите Отмена, чтобы оставить все без изменений.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Используемый в настоящее время почтовый сервер не позволяет одновременно включить почтовый ящик и почтовые группы. Нажмите OK, чтобы включить почтовые группы за счет отключения почтового ящика. Нажмите Отмена, чтобы оставить все без изменений.',

    'mysql_dbase_space_limit' => 'Лимит на базы данных MySQL',
    'mysql_dbase_usage' => 'Использование баз данных MySQL',
    'mssql_dbase_space_limit' => 'Лимит на базы данных Microsoft SQL Server',
    'mssql_dbase_usage' => 'Использование баз данных Microsoft SQL Server',

    '__statistics' => "статистикой", //indirect

    'dns__soa_minimum_value_is_big' => 'Если для параметра Minimum TTL будет установлено значение более 3 часов, то ваш домен может стать недоступным для некоторых администраторов домена. Рекомендуется устанавливать такое значение только в том случае, если на этом настаивает орган, который зарегистрировал ваше доменное имя.',

    'virusfilter__interface_not_available' => 'Нет доступных антивирусных фильтров.',
    'virusfilter__none_virus_filter' => 'Нет',
    'virusfilter__mailname_status_text' => 'Антивирусная программа (%1)',
    'virusfilter__status_none' => 'отключено',
    'virusfilter__status_any' => 'входящую и исходящую почту',
    'virusfilter__status_outgoing' => 'только исходящую почту',
    'virusfilter__status_incoming' => 'только входящую почту',

    'visibility__root_override_parse_error' => 'Синтаксическая ошибка в файле %1 в строке %2.',

    'sb__not_support_publishing_api' => "Автоматизация публикации не поддерживается компонентом",

    'component_name__cphosting' => "Хостинг Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Установка квоты почтовых ящиков не поддерживается текущим почтовым сервером.',
    '__unable_get_total_mboxes_quota' => 'Установка квоты почтовых ящиков не поддерживается текущим почтовым сервером.',

    'install_prefix__parent_not_exists' => "Родительская папка не существует.",

    'bt_change_version' => 'Изменить версию',
    'aspdotnet__changeversion_title' => 'Выбор версии ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Выбрать все",
    '__uncheck_all' => "Очистить все",

    'dns__editing_domain_controller_zone' => "Редактирование записей зоны DNS для контроллера домена может вызвать проблемы с функционированием домена",

    'pb__interface_management' => "Управление интерфейсом",
    'interface_management__tabs_skins' => "Темы",
    'interface_management__tabs_interface_templates' => "Шаблоны интерфейса",
    'interface_management__tabs_locales' => "Локали",
    'locales_list__title' => "Репозиторий пакетов локализации",
    'locales_list__legend' => "Доступные языки",
    'locales_list__active_title' => "С",
    'locales_list__locale_title' => "Пакет локализации",
    'locales_list__lang_title' => "Язык",
    'locales_list__country_title' => "Страна",
    'locales_list__used_title' => "Используется",

    'backup__suspend_warning_during_backup' => "Домен будет недоступен во время резервного копирования",
    'backup__suspend_warning_during_restore' => "Домен будет недоступен во время восстановления",
    'backup__suspend_domain' => "Приостановить домен",

    'locales_list__mls_limit' => "Ваша текущая лицензия Plesk позволяет использовать следующее количество языков ‒ %2. В данный момент в качестве количества языков, доступных пользователям, у вас указано %1, что превышает указанное в лицензии ограничение. Пожалуйста, выберите %2 языка(ов), которые вы хотите использовать, и сделайте остальные языки недоступными пользователям с помощью значка в колонке 'С'.",

    'bt_change_owner' => 'Назначить нового владельца',
    'chown__new_owner' => 'Новый владелец',
    'chown__selected_domains' => 'Выбранные подписки',
    'chown__limits_legend' => 'Ресурсы',
    'chown__limit_name' => 'Имя ресурса',
    'chown__limit_value' => 'Выделенные ресурсы',
    'chown__limit_assigned_before' => 'До передачи',
    'chown__limit_assigned_after' => 'После передачи',
    'chown__error_limits' => "Невозможно продолжить перенос подписки: эта подписка требует больше ресурсов, чем есть у провайдера нового владельца.",
    'chown__error_no_domains' => 'Невозможно продолжить перенос подписки: не выбрано ни одной подписки, или выбранные подписки уже принадлежат этому пользователю.',
    'chown__error_empty_ip_pool' => "Невозможно продолжить перенос подписки: IP-пул провайдера нового владельца пуст. Пожалуйста, убедитесь, что в пуле провайдера есть хотя бы один IP-адрес.",
    'chown__please_select_new_domain_owner' => 'Пожалуйста, выберите нового владельца для данной подписки.',
    'chown__old_ip_address' => 'Текущий IP-адрес',
    'chown__new_ip_address' => 'Новый IP-адрес',

    'chown__error_ssl_already_used' => "Поддержка SSL/TLS уже используется на следующих целевых IP-адресах: %1. Поэтому невозможно выполнить передачу следующих доменов с поддержкой SSL/TLS: %2. Пожалуйста, устраните проблему и повторите попытку.",
    'chown__sitebuilder_not_installed' => 'Не установлен Presence Builder',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Домен %1 не может быть передан другому владельцу, так как не установлен Presence Builder.',

    'backup__backup_time' => 'Время создания резервной копии',
    'backup__backup_time_hour' => 'ч.',
    'backup__backup_time_minute' => 'мин.',
    'backup__every' => 'кажд.',
    'backup__day_of_month' => 'день месяца',

    'subdomain__select_hst_type' => 'Выберите тип хостинга для субдомена',
    'hst_sel__subdom_subfolder_hst' => 'Субдомен на вложенной папке',
    'subdomain__www_root_folder_not_exists' => 'Домашняя папка сайта %1 не существует',
    '__site_home_dir' => 'Домашняя папка сайта',
    'subdomain__aspnet_disabled_domain' => 'отключено доменом',

    'domains__remove_description' => 'Все доменные данные, включая контент и настройки доменов и субдоменов, данные веб-приложений, содержимое почтовых ящиков, настройки почты, антивируса и антиспама, файлы журналов, данные доменного хранилища резервных копий и SSL/TLS-сертификаты будут удалены. Если у вас нет файла резервного копирования на локальной машине, все данные будут безвозвратно утеряны.',
    'subdomains__remove_description' => 'Все субдоменные данные, включая содержимое и настройки субдоменов, данные веб-приложений и файлы журналов будут удалены. Если у вас нет файла резервного копирования на локальной машине, все данные будут безвозвратно утеряны.',

    'mail__tabs_spam_filtering' => 'Антиспам',
    'mail__tabs_antivirus' => 'Антивирус',
    'antivirus__use_server_settings_scan' => 'Использовать настройки сервера по умолчанию (сканировать)',
    'antivirus__use_server_settings_no_scan' => 'Использовать настройки сервера по умолчанию (не сканировать)',
    'antivirus__check_for_viruses' => 'Сканировать на вирусы',
    'antivirus__dont_check_for_viruses' => 'Не сканировать на вирусы',
    'antivirus__incoming_mail' => 'Входящая почта',
    'antivirus__outgoing_mail' => 'Исходящая почта',

    'domain_alias__CNAME_dns_record_exists' => 'CNAME-запись DNS с таким именем уже существует',
    'domain_alias__A_dns_record_exists' => 'A-запись DNS с таким именем уже существует',
    'domain_alias__bad_prefix' => 'Неправильный префикс для псевдонима домена',
    'domain_alias__domain_doesnt_exist' => "Домен не существует",

    'dns__zone_ttl_message_info' => 'Если значение TTL не задано, для этой DNS-записи будет использоваться значение TTL из шаблона записей SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Для перенаправления выбранных веб-приложений будет создан файл с именем index.html. Если файл с именем index.html уже существует, для него будет создана резервная копия с именем index.html.old, и файл будет заменен новым. Нажмите OK для подтверждения",

    'bt_ftp_ctrl' => "Дополнительные учетные записи FTP",
    'ftp_users_no_permission' => "Вам запрещено управлять учетными записями FTP на этом домене",
    'ftp_users_limit_reached' => "Достигнуто ограничение по учетным записям FTP для этого домена",
    'pb__ftp_ctrl' => "Управление FTP",
    'class_client__max_subftp_users' => "Дополнительные учетные записи FTP",

    '__client_form_settings' => "Настройки клиента",
    '__sbnet_client_keep_sbnet' => "Сохранить соответствующую учетную запись пользователя в Presence Builder",
    '__sbnet_cant_add_more_sites' => "Этот клиент исчерпал максимальное количество сайтов Presence Builder",
    '__sbnet_legend_text' => "Интеграция с Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Создать соответствующую учетную запись пользователя в Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Вы пытаетесь удалить пользователя Presence Builder, привязанного к данному клиенту. Это приведет к удалению из Presence Builder всех сайтов и соответствующих настроек, после чего редактирование существующих сайтов в Presence Builder станет невозможным, даже если позднее вы включите эту опцию. Если вы потом снова создадите учетную запись Presence Builder, вам нужно будет заново создать и опубликовать все свои сайты. Отключить создание и публикацию сайтов через Presence Builder?",
    'sb__build_site_with_subdomains' => "Создать субдомены Блог и Фотогалерея",
    '__sbnet_client_dont_have_sbuser' => "Невозможно создать и опубликовать сайт с помощью Presence Builder: пользователь Presence Builder не существует",

    '__component_disabled' => "Компонент отключен",

    'subdomains__physical_path_not_exist' => "Обнаружены субдомены, указывающие на несуществующие физические папки",

    'dnsserver_bind_to_msdns_switching_warning' => "Внимание: только первые 254 IP-адреса подсетей с масками /8 и /16, находящиеся в ACL, будут перенесены. Они будут перенесены как отдельные IP-адреса. Вы хотите продолжить?",

    '__sbnet_net_framework_required_for_site' => "Для сайтов Presence Builder может потребоваться поддержка ASP.NET 2.0 на вашем домене. Если вы используете Presence Builder, рекомендуем включить поддержку ASP.NET 2.0.",

    'subdomain_auto_create_dir' => "Создать физическую папку для субдомена",

    'sa_trainer__unable_to_get_messages_list' => "Невозможно получить список сообщений в почтовом ящике: %1",
    'sa_trainer__pass_doesnt_exist' => "Отсутствует пароль для данной учетной записи почты",

    '__sitebuilder_error' => "При подключении к Presence Builder произошла ошибка. Обратитесь к своему сервис-провайдеру.",
    'wsb_error_user_not_exist' => "В Presence Builder не существует такого пользователя.",
    'wsb_error_site_already_exist' => "Такой сайт уже существует в Presence Builder.",
    'wsb_error_site_limit_reached' => "Исчерпано максимальное количество сайтов Presence Builder.",
    'wsb_error_internal_error' => "Произошла внутренняя ошибка Presence Builder. Пожалуйста, обратитесь за помощью к своему сервис-провайдеру.",
    'wsb_error_user_already_exist' => "В Presence Builder уже существует пользователь с таким именем.",
    'sb_error_user_not_exist' => "Пользователь Presence Builder не существует.",
    'wsb_error_object_not_found' => "Presence Builder не смог найти правильную запись хоста.",

    'mg_no_mail_groups' => "Отсутствуют почтовые группы",

    'drweb__drweb_incoming' => 'Антивирусная проверка входящей почты',
    'drweb__drweb_outgoing' => 'Антивирусная проверка исходящей почты',
    'drweb__disable_reason_serv' => 'Почтовый сервер не поддерживает настройку антивируса на уровне почтовых ящиков',

    'vz_sitebuilder3_client_cant_be_created' => "Невозможно создать клиента: не установлен SiteBuilder версии 3.1 или выше",

    'chown__client_without_sitebuilder_support' => "Невозможно продолжить перенос подписки: в тарифном плане нового владельца или его провайдера отсутствует компонент Presence Builder.",

    // new limits

    'class_client__max_odbc' => "Соединения ODBC",
    'cl_perm__max_odbc' => "максимальное число соединений ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'С',
    'domain_alias__list_name' => 'Псевдоним домена',
    'domain_alias__list_ascii_name' => 'В формате ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Управление интерфейсом',
    'pb__interface_templates' => 'Управление интерфейсом',
    'pb__interface_clients' => 'Клиенты, использующие %1',

    // service management
    'bt_service_showall' => "Показать все",
    'bt_service_hideall' => "Скрыть все",
    'bt_service_start' => "Запустить",
    'bt_service_stop' => "Остановить",
    'bt_service_restart' => "Перезапустить",
    'bt_service_disable' => "Отключить",
    'bt_service_manual' => "Вручную",
    'bt_service_auto' => "Автоматически",
    'comp_info__statup_type' => 'Тип запуска',
    'service_startup_auto' => 'Автоматически',
    'service_startup_manual' => 'Вручную',
    'service_startup_disabled' => 'Отключено',
    'service_action_ok' => "Операция над службой %1 выполнена успешно",
    'service_action_failed_disabled_service' => "Невозможно завершить операцию над службой %1, так как она отключена",
    'service_action_failed_error' => "Невозможно выполнить операцию: %1",
    'service_group_action_ok' => "Операция на следующими службами была выполнена успешно: %1",
    'service_group_action_disabled' => "Невозможно завершить операцию над следующими службами, так как они отключены: \n %1",
    'service_group_action_failed' => "Невозможно выполнить операцию над следующими службами: \n %1. \nЧтобы получить подробную информацию об ошибке, выполните операцию над каждой службой в отдельности",

    // php 4vs5
    'bt_php' => "Настройки PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Доступные реселлеры',
    'massmail__resellers_list_selected' => 'Выбранные реселлеры',
    'massmail__clients_list_available_for_select' => 'Доступные клиенты',
    'massmail__clients_list_selected' => 'Выбранные клиенты',
    'massmail__advanced' => 'Дополнительно',
    'bt_massmail_send' => 'Отправить',
    'massmail__save_template_name' => 'Сохранить текст в новом шаблоне с именем',
    'massmail__template' => 'Шаблон',
    'massmail__compose_mail' => 'Сообщение',
    'massmail__from' => 'От',
    'massmail__to' => 'Кому',
    'massmail__subject' => 'Тема',
    'massmail__body' => 'Текст сообщения',
    'massmail__body_hint' => 'Чтобы автоматически вставить имя пользователя в сообщение, используйте переменную <name>.',
    'massmail__send_to_clients' => "Клиенты",
    'massmail__send_to_domainusers' => "Администраторы доменов",
    'massmail__send_to_admins' => "Администраторы Plesk",
    'massmail_select' => 'Выбрать адреса',
    'massmail_showhide_selected' => "Показать/скрыть выбранные",
    'massmail_send_all' => "Все",
    'massmail_send_selected' => "Только выбранные",
    'massmail_send_except' => "Все за исключением выбранных",
    'bt_new_mass_mail_template' => "Добавить шаблон сообщений почтовой рассылки",
    '__mass_mail_templates_list' => "Список шаблонов сообщений почтовой рассылки",
    'massmail__template_name' => 'Название шаблона',
    'massmail__receivers' => 'Получатели',
    'massmail__created' => 'Отправитель',
    'massmail__date_created' => 'Дата создания',
    'massmail__compose' => 'Отправить',
    'mass_mail__resellers_all' => 'Все реселлеры',
    'mass_mail__clients_all' => 'Все клиенты',
    'mass_mail__domainusers_all' => 'Все администраторы доменов',
    'mass_mail__resellers_selected' => 'Выбранные реселлеры',
    'mass_mail__clients_selected' => 'Выбранные клиенты',
    'mass_mail__domainusers_selected' => 'Выбранные администраторы доменов',
    'mass_mail__resellers_except' => 'Все реселлеры, кроме выбранных',
    'mass_mail__clients_except' => 'Все клиенты, кроме выбранных',
    'mass_mail__domainusers_except' => 'Все администраторы доменов, кроме выбранных',
    'mass_mail__admins_all' => 'Все администраторы',
    'massmailtemplateslist__title' => 'Шаблоны сообщений почтовой рассылки',
    'massmail__insert_from_template' => "Вставить данные из шаблона",
    'massmail__select_template' => "Выбрать шаблон",
    'massmail__body_short_hint' => "(только текст)",
    'massmail__from_short_hint' => "(электронная почта или имя)",
    'bt_insert' => "Вставить",
    'massmail__mail_send_successfully' => "Сообщение было успешно отправлено",
    'massmail__mail_send_successfully_with_some_errors' => "Сообщение было отправлено, но произошли ошибки. Возможно сообщение не было доставлено нескольким получателям. Более подробную информацию можно найти в файле журнала: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Сообщение не отправлено. Пожалуйста, убедитесь, что выбран хотя бы один получатель и почтовый сервер Plesk работает исправно. Более подробную информацию смотрите в следующем файле: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Данные из шаблона %1 были успешно вставлены.",
    'massmail__template_added_successfully' => "Шаблон сообщений был сохранен под именем %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Произошла ошибка базы данных Presence Builder. Обратитесь за помощью к своему сервис-провайдеру.",
    'wsb_error_sitebuilder_access_denied_error' => "Невозможно получить доступ к файлу: у Presence Builder нет доступа к запрошенному файлу или папке. Пожалуйста, обратитесь к своему сервис-провайдеру.",
    'wsb_error_sitebuilder_connection_failed' => "Невозможно подключиться к Presence Builder из-за потери соединения. Обратитесь за помощью к своему сервис-провайдеру.",
    'wsb_error_critical_during_operation' => "Произошла неисправимая ошибка Presence Builder: \n%1",
    'wsb_error_license_during_operation' => "Произошла ошибка лицензии Presence Builder: \n%1",
    'wsb_error_during_operation' => "Произошла ошибка Presence Builder: \n%1",
    'wsb_error_license_error' => "Обнаружено ограничение лицензии Presence Builder.",

    // Other
    '__confrim_service_stop' => "Предупреждение! Остановка службы %1 может привести к прекращению работы Plesk. Вы уверены, что хотите остановить службу %1?",
    'virtualdir__name_is_reserved' => "Это имя зарезервировано",
    'index_redirect_help_text' => 'Сейчас Вы будете автоматически перенаправлены на нужный сайт. Если Ваш браузер не поддерживает переадресацию, пожалуйста, щелкните по %1 этой ссылке %2',
    'bt_default_settings' => "Восстановить настройки по умолчанию",
    'logfiles__remove_failed' => "Невозможно удалить файл %1: файл заблокирован другим приложением. Пожалуйста, повторите попытку позднее",
    'subdomain__invalid_homedirectory' => "Указана неверная домашняя папка субдомена",
    'scheduler_item__empty_filename' => "Пожалуйста, укажите исполняемый файл, который нужно запустить",
    'subdomains__overlapped_domain_exists' => 'Субдомен перекрывается зоной DNS домена %1',
    'subdomains__overlapped_domain_alias_exists' => 'Субдомен пересекается с зоной DNS псевдонима домена %1',
    'services_action_none_selected' => 'Невозможно выполнить операцию: пожалуйста, выберите нужную службу.',
    'cl_perm__max_subftp_users' => "максимальное количество дополнительных учетных записей FTP",
    'login_up__access_denied_no_cp_access' => 'Доступ запрещен. У вас нет доступа к Plesk.',
    'drweb__disable_reason_admin' => "Изменение настроек антивируса на уровне почтовых ящиков запрещено политикой сервера.",

    'webdirs__name_is_invalid' => 'В именах папок можно использовать только буквы, цифры, подчеркивания и тире.',
    'webdirs__physical_path_is_invalid' => 'Физический путь неверен или не существует',
    '__use_default' => 'Использовать по умолчанию',

    'webalizer_hidden_referrer__already_exist' => 'Такая запись уже существует.',
    'webalizer_group_referrer__already_exist' => 'Реферер с таким именем уже существует.',

    'pb__dashboard' => 'Главная',

    'server_interface__page_title' => 'Настройки интерфейса сервера',
    'server_interface__tabs_locales' => 'Локали',
    'server_interface__tabs_skins' => 'Темы',
    'server_interface__tabs_interface_templates' => 'Шаблоны интерфейса',
    'bt_server_interface' => 'Настройки интерфейса',
    'pb__server_interface' => 'Настройки интерфейса',

    'bt_wizard_next' => 'Далее >>',
    'bt_wizard_prev' => 'Назад',

    '__limit_exceeded_max_dom_server' => 'Вы больше не можете создавать домены на этом сервере, так как исчерпано максимальное количество доменов, разрешенное ключом лицензии. Обратитесь к вашему сервис-провайдеру.',
    '__limit_exceeded_max_subdom_server' => 'Вы больше не можете создавать новые субдомены на этом сервере. Пожалуйста, свяжитесь с вашим провайдером хостинг услуг.',
    '__limit_exceeded_max_dom_aliases_server' => 'Вы больше не можете создавать новые псевдонимы доменов на этом сервере. Пожалуйста, свяжитесь со своим сервис-провайдером.',
    '__limit_exceeded_max_wu_server' => 'Вы больше не можете создавать веб-пользователей, так как исчерпано максимальное количество веб-пользователей на сервере, разрешенное лицензией. Обратитесь к вашему сервис-провайдеру.',
    '__limit_exceeded_max_mn_server' => 'Вы больше не можете создавать учетные записи почты, так как исчерпано максимальное количество почтовых учетных записей, разрешенное лицензией. Обратитесь к вашему сервис-провайдеру.',

    '__limit_exceeded_max_cl_useradmin' => 'Вы исчерпали максимальное количество клиентов, разрешенное вашей лицензией (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Вы достигли предела по количеству доменов, определенного Вашим лицензионным ключом (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Вы достигли ограничения по количеству субдоменов, определенному вашим лицензионным ключом (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Вы исчерпали ограничение на псевдонимы доменов, заданное в вашей лицензии (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'У Вас не осталось свободного места на диске',
    '__limit_exceeded_max_wu_useradmin' => 'Вы достигли предела по количеству учетных записей веб-пользователей, определенного Вашим лицензионным ключом (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Вы достигли предела по количеству баз данных, определенного Вашим лицензионным ключом (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Вы достигли предела по количеству почтовых ящиков, определенного Вашим лицензионным ключом (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Вы исчерпали максимальное количество почтовых учетных записей, разрешенное вашей лицензией (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Вы достигли предела по количеству списков рассылки, определенного Вашим лицензионным ключом (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Вы достигли ограничения по количеству доменов (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Вы достигли ограничения по количеству субдоменов (%2), которое было установлено вашим провайдером услуг',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Вы исчерпали ограничение на псевдонимы доменов (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Вы достигли ограничения по объему используемого дискового пространства (%2).',
    '__limit_exceeded_max_traffic_userclient' => 'Вы достигли ограничения по месячному объему трафика (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Вы достигли ограничения по количеству веб-пользователей (%2), которое было установлено вашим провайдером услуг.',
    '__limit_exceeded_max_db_userclient' => 'Вы достигли ограничения по количеству баз данных (%2)',
    '__limit_exceeded_max_box_userclient' => 'Вы достигли ограничения по количеству почтовых ящиков (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Вы достигли ограничения по количеству списков рассылки (%2)',
    '__limit_exceeded_expiration_userclient' => 'Срок действия вашей учетной записи истек на %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Вы достигли ограничения по количеству субдоменов (%2), которое было установлено вашим провайдером услуг',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Вы исчерпали ограничение на псевдонимы доменов (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Вы достигли ограничения по объему используемого дискового пространства (%2).',
    '__limit_exceeded_max_traffic_userdomain' => 'Вы достигли ограничения по месячному объему трафика (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Вы достигли ограничения по количеству учетных записей веб-пользователей (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Вы достигли ограничения по количеству баз данных (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Вы достигли ограничения по количеству почтовых ящиков (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Вы достигли ограничения по количеству списков рассылки (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Срок действия вашей учетной записи истек на %2',

    'mmt__to_none' => 'Нет',
    'mmt__to_admin' => 'Администратор',
    'mmt__to_resellers_all' => 'Все реселлеры',
    'mmt__to_resellers_select' => 'Выбранные реселлеры',
    'mmt__to_resellers_select__available' => 'Доступные реселлеры',
    'mmt__to_resellers_except' => 'Все реселлеры, кроме выбранных',
    'mmt__to_clients_all' => 'Все клиенты',
    'mmt__to_clients_select' => 'Выбранные клиенты',
    'mmt__to_clients_select__available' => 'Доступные клиенты',
    'mmt__to_clients_except' => 'Все клиенты, кроме выбранных',

    'mmt__unable_send_empty_selection' => 'Невозможно отправить сообщение, так как не выбрано ни одного адреса электронной почты.',
    'mmt__unable_send_to__' => 'Невозможно отправить почтовую рассылку по следующим адресам:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Невозможно проверить веб-приложение, так как не найден один из требуемых файлов (%1). Обратитесь за помощью в службу технической поддержки.',
    'sapp_error_validation_spec_failed' => 'Загруженное веб-приложение не соответствует спецификации AppPacks: %1.',
    'sapp_error_validation_register' => 'Невозможно зарегистрировать веб-приложение, расположенное в папке "%1": %2 Рекомендуем удалить это веб-приложение с сервера, так как оно не будет работать правильно.',

    'sapp__install_failed' => 'Ошибка при установке веб-приложения: %1',
    'sapp__install_res_failed' => 'Не удалось создать запрашиваемый ресурс.',

    'server_preferences__subdomains_blog_and_photo' => 'Создать субдомен для дневника и фото галереи по умолчанию',
    'plesk_key__blog_and_photo' => 'Возможность изменять статус по умолчанию полей субдомена Создать дневник и Фотогалерея',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Невозможно сделать IP-адрес выделенным, так как он назначен более чем одному пользователю.',

    // 8.1.1

    '__write_modify_warning' => 'Выбор дополнительных прав на запись/редактирование позволит обеспечить правильную работу некоторых веб-приложений, однако это значительно увеличит риски, связанные с безопасностью',
    '__write_modify_subdomain_warning' => 'Выбор дополнительных прав на запись/редактирование позволит обеспечить правильную работу некоторых веб-приложений, однако это значительно увеличит риски, связанные с безопасностью',

    'phosting__php_incorrect_version_used' => "Были обнаружены проблемы с версией PHP. Для устранения этих проблем поставьте флажок в поле, соответствующем нужной версии PHP, и нажмите OK. Чтобы отключить поддержку PHP на этом домене, нажмите OK, не выбирая версию PHP",
    'fp__mail_preferences' => 'Настройки почты',

    'mail__invalid_white_pattern' => 'Недопустимое значение. Адрес электронной почты должен быть указан в формате mail@example.com, домен — в формате example.com.',
    'mail__invalid_black_pattern' => 'Недопустимое значение. Адрес электронной почты должен быть указан в формате mail@example.com, домен — в формате example.com.',

    'resp_edit__reply_as_html' => 'Отправить как HTML',
    'exception__path_very_long' => "Слишком длинный путь. Убедитесь, что длина пути составляет меньше %1 символов",

    // 8.2


    //SAPP
    'sapp_on' => 'Вкл.',
    'sapp_off' => 'Выкл.',
    'sapp_directive_aspect' => 'Требуется',
    'sapp_databases_num' => 'Базы данных',
    'sapp_db_required' => 'Требуется',
    'sapp_Required' => 'Требуется',
    'sapp_Variant' => 'Вариант',
    'sapp_db_id' => 'Идентификатор базы данных',
    'sapp_db_id_type' => 'БД (идентификатор: %1) тип',
    'sapp_db_id_min_version' => 'БД (идентификатор: %1) мин. версия',
    'sapp_db_id_table_prefix' => 'БД (идентификатор: %1) префикс таблицы',
    'sapp_Default' => 'По умолчанию',
    'sapp_apache_mod_req' => 'Модуль Apache',
    'sapp_dbtype_not_installed' => 'не установлено',
    'sapp_apache_mod_not_installed' => 'не установлено',
    'sapp__value_error_empty' => 'Пустое значение не допустимо.',
    'sapp_error_invalid_type' => 'Приложение "%1" не поддерживает запрашиваемое действие.',
    'sapp_error_unknown_app_type' => 'Не поддерживаемый тип приложений: %1.',
    'sapp__ssl_text' => 'Установить приложение на виртуальный сервер "http://" или "https://"?',
    'sapp__app_to_upgrade' => 'Приложения, которые необходимо обновить',
    'sapp__upgrade_apps_title' => 'Обновить приложения',
    'sapp__upgrade_to_ver' => 'Обновить до версии',
    'sapp__choose_pkg_ver' => 'Выбрать пакет…',
    'sapp__pkg_cant_upgrade_pkg' => 'Пакет "%1" не может быть использован для обновления веб-приложения "%2".',
    'sapp__app_ugrade_error' => 'Не удается обновить приложение: %1. Пожалуйста, обратитесь к системному администратору.',
    'sapp__no_suitable_db_found' => 'Не найдено подходящей базы данных.',
    'sapp__upgrade_success' =>  'Приложение было успешно обновлено.',
    'sapp__pkg_info_changelog' => 'История изменений',
    'sapp_requirement_legend' => 'Функции хостинга, необходимые для приложения',

    // other
    'bt_apply' => 'Применить',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Для создания псевдонима у этой учетной записи почты должен быть включен почтовый ящик. Включить почтовый ящик?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Отключение почтового ящика приведет к удалению почтовых псевдонимов. Отключить почтовый ящик?',
    'antivirus__disable_reason_install' => 'Вы не можете управлять антивирусом, так как он не установлен.',
    'antivirus__disable_reason_key' => 'Вы не можете управлять антивирусом, так как правильный лицензионный ключ не установлен.',
    'antivirus__disable_reason_deny_personal_settings' => 'Вы не можете управлять антивирусом, так как серверная политика запрещает использовать индивидуальные настройки антивируса.',
    'change_foreign_user_password' => 'Изменить пароль',
    'change_foreign_user_password_hint' => "Данный пользователь не принадлежит этому приложению. Щелкните по ссылке, чтобы перейти в другое приложение, и измените там пароль этого пользователя. Для этого у вас должны быть соответствующие права в данном приложении.",
    'cf_url_text' => 'URL для JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Формат строки',
    'lang_unknown' => 'Неизвестный язык',
    'pb__cl_ed' => 'Сведения о клиенте',
    'pb__actionlog' => 'Журнал операций',
    'pb__cl_limits' => 'Ограничения клиента',
    'pb__edit' => 'Изменить',
    'pb__subdom_edit' => 'Настройки хостинга',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Резервное копирование содержимого почтовых ящиков',

    'maillist_import_result' => "Общее количество адресов электронной почты в файле: %1 \nколичество импортированных адресов электронной почты: %2 \nколичество уже существующих адресов электронной почты: %3 \nколичество дублирующихся адресов электронной почты в указанном файле: %4 \nколичество недопустимых адресов электронной почты в файле: %5",
    'maillist_import_error' => 'Не удалось импортировать список адресов электронной почты',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Выбранный вами файл пуст или не является документом HTML в выбранной кодировке. Пожалуйста, укажите правильную кодировку или добавьте содержимое в файл.",

    'dom_pref__external_mail_srv' => "Перенаправлять на внешний почтовый сервер с IP-адресом:",
    'mn_edit__store_messages' => 'Почтовый ящик',

    // aps

    'sapp__before_upgrade_notice' => 'Рекомендуется создать резервную копию приложения и данных пользователя прежде, чем приступить к выполнению обновления.',
    'sapp__application_properties' => 'Свойства приложения',
    'sapp__application_root_descr' => 'Главная страница приложения',

    'sapp__aps_license_invalid_id' => 'Лицензионный ключ имеет неверный идентификатор: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Лицензия с номером ключа %1 уже имеется в базе данных.',
    'sapp__aps_lic_del_used' => 'Невозможно удалить лицензионный ключ, он используется одним из установленных приложений.',
    'sapp__aps_lic_del_unknown' => 'Невозможно удалить лицензионный ключ: %1',
    'sapp__aps_cappi_duplicate' => "Это приложение уже есть в пуле приложений клиента.",
    'sapp__appi_not_shared_no_install' => "Такого приложения нет в пуле приложений клиента. Если вы хотите установить это приложение на сайт, сначала нужно добавить его в пул приложений клиента.",
    'sapp__appi_shared_not_client' => "Такого приложения нет в пуле приложений клиента. Если вы хотите обновить это приложение до указанной версии, то вам сначала нужно добавить эту версию в пул приложений клиента.",
    'sapp__apply_license_script_not_found' => 'Невозможно найти скрипт "apply-license" для этого веб-приложения.',
    'sapp__unable_to_activate_key' => 'При активации лицензионного ключа произошла ошибка: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Имеются установленные веб-приложения, для которых требуется наличие этого веб-приложения в системе.',
    'sapp__unable_to_delete_ai_in_pool' => 'Это приложение все еще находится в пуле клиента. Если вы хотите удалить это приложение, вы сначала должны удалить его из всех пулов приложений клиентов или сделать его бесплатным.',
    'sapp__unable_to_delete_app_template' => 'Невозможно удалить приложение #%1: %2',
    'sapp__limit_exceeded_client' => 'Вы достигли ограничения по количеству установленных экземпляров этого веб-приложения (%2).',


    // atis module

    '_week_on' => 'неделю в',
    '__week_first' => 'первый',
    '__week_second' => 'вторую',
    '__week_third' => 'третью',
    '__week_fourth' => 'четвертую',
    '__week_last' => 'последний',
    '__not_started' => 'Ожидание',
    '__started' => 'Работает',
    '__cancel_pending' => 'Отмена',
    '__canceled' => 'Отмененный',
    '__error' => 'Ошибка',
    '__done' => 'Выполнено',

    '__php_cgi_handler' => 'Приложения CGI',
    '__php_isapi_handler' => 'Расширение ISAPI',
    '__php_fastcgi_handler' => 'Приложения FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'запустить как',

    'cf_dbfolder_text' =>'Каталог базы данных',
    'cf_isnewdb_text' => 'Создать базу данных',
    'cf_isnewdb_title' => 'Поставьте флажок в поле, если необходимо создать базу данных',

    'pb__site_apps_upgrade' => 'Обновление веб-приложения',

    'detach' => 'Отключить',
    'preferences' => "Изменить пароль",

    'toolsbar__switch_user?' => "Вы действительно хотите войти в систему под другой учетной записью?",
    '__aps_left' => 'Осталось установок',
    'aps__license_key' => 'Ключ лицензии',
    'aps__download_code' => 'Загрузка лицензионного ключа и код активации',
    'aps__license_key_hint' => 'Получить с сервера лицензий, используя код активации',
    'aps__database_not_available' => 'не доступно, пожалуйста, проверьте ограничения по доменам или клиентам',
    'aps__yes' => 'да',
    'aps__no' => 'нет',
    '__click_to_enlarge' => 'Увеличить изображение',
    'site_apps__back_to_list' => 'Вернуться в список',
    'sapp__pkg_info_installation_requirements' => 'Требования к установке',
    '__close_window' => 'Закрыть',

    //SAPP END

    'skin_info__already_default' => 'Схема оформления уже установлена схемой по умолчанию.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Настройки Plesk Premium Antivirus для %1',
    'drweb:properties_legend' => 'Настройки',
    'drweb:status' => 'Проверка почты на вирусы.',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder',
    'dom_site_builder' => 'Нажмите, чтобы открыть Presence Builder.',
    'sb_plesk_admin_url' => 'URL-адрес сервера Presence Builder. Убедитесь, что этот адрес правильно распознается DNS.',
    'sb_plesk_admin_login' => 'Логин администратора сервера для входа в Presence Builder',
    'sb_plesk_admin_password' => 'Пароль администратора',
    'sb_sitebuilder_preferences' => 'Параметры доступа администратора Presence Builder',
    'sb__server' => 'Параметры администратора Presence Builder',
    'sb__sitebuilder_support' => 'Поддержка Presence Builder',
    'sb_keep_sb_user' => 'Сохранить соответствующую учетную запись пользователя в Presence Builder',
    'sb_create_sb_user' => 'Создать соответствующую учетную запись пользователя в Presence Builder',
    'sb__build_site_using_sitebuilder' => "Создать сайт с помощью Presence Builder",
    'sb_no_current_sb_server_set' => 'Соединение с Presence Builder еще не настроено: добавьте в шаблон зоны DNS A-запись, указывающую на сервер Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Невозможно получить информацию от Presence Builder: \n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Невозможно подключиться к Presence Builder: неверное имя пользователя или пароль.",
    'sb_init_sb_manager' => "Выполняется инициализация Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Не удалось подключиться к Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "У этого клиента нет учетной записи в Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder не настроен.",
    'sb_err_you_dont_have_sbaccount' => "Не удалось идентифицировать вас в Presence Builder.",
    'sb_error_critical_during_operation' => "В Presence Builder произошла следующая ошибка:\n%1",
    'sb_err_sso_is_not_enabled' => "В Plesk не включена поддержка единого входа.",

    'warning__super_zone_exist' => "Зона %1 была создана, однако имя этой зоны совпадает с именем с именем подзоны уже существующей зоны%2, которая принадлежит пользователю %3. Такое допустимо, однако вам следует убедиться, что вы выбрали правильную учетную запись пользователя.",
    'error__super_zone_exist' => "Невозможно создать зону DNS, так как ее суперзона принадлежит другому пользователю.",

    'locales__files_not_exits' => 'Невозможно изменить пакет локализации: указанных файлов пакета локализации интерфейса нет в системе.',
    'locales__unavailable' => 'Невозможно изменить пакет локализации: указанный пакет локализации интерфейса недоступен.',

    // DB BU

    'pb__dbbackup_list' => 'Файлы резервных копий базы данных',
    // server
    'dbbackup__server_backup_settings' => 'Резервное копирование',
    'dbbackup__network_temp_dir' => 'Временная сетевая папка',
    'dbbackup__network_user' => 'Имя пользователя',
    'dbbackup__network_pass' => 'Пароль',
    // domain
    'dbbackup__add_database_legend' => 'Восстановить базу данных из резервной копии',
    'dbbackup__add_database_restore' => 'Восстановить базу данных из файла резервной копии',
    'dbbackup__add_database_file' => 'Файл резервной копии базы данных',
    'dbbackup__add_database_user' => 'Имя пользователя по умолчанию',
    'dbbackup__add_database_pass' => 'Пароль пользователя по умолчанию',
    'dbbackup__add_database_pass2' => 'Подтверждение пароля пользователя по умолчанию',

    'bt_dbbackup_now' => 'Создать резервную копию',

    'bt_repair' => 'Исправить',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Загрузка дампов баз данных SQL Server запрещена хостинг-провайдером.',

    // APS categories

    'cf_invalid_password' => 'Пароль не может быть длиннее 16 символов',
    'cf_invalid_description_length' => 'Описание не может быть длиннее 256 символов',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-адрес %1 уже используется внешним почтовым сервером',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Неверное имя пользователя или пароль учетной записи FTP. Пожалуйста, укажите правильные параметры FTP-доступа.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Исчерпано максимальное количество изменений порядкового номера. Сегодня вы больше не сможете вносить изменения в зоны DNS.',
    'dns__zone_apply_changes' => 'Изменения, внесенные для записей DNS, не были сохранены. Внесенные изменения отмечены ниже. Нажмите Обновить, чтобы применить изменения для зоны DNS или нажмите Вернуть, чтобы отменить изменения.',
    'dns__update_dns_zone' => 'Нажмите, чтобы сохранить изменения, внесенные для записей DNS',
    'dns__revert_dns_zone' => 'Нажмите, чтобы отменить изменения, внесенные для записей DNS',
    'bt_revert' => 'Отменить',
    'dns__dns_zone_has_beed_updated' => 'Изменения, внесенные для записей DNS, были сохранены.',
    'dns__dns_zone_has_beed_reverted' => 'Изменения, внесенные для записей DNS, были отменены',
    'db__nondefault_server_not_allowed' => 'Не разрешено использовать другой сервер баз данных, кроме установленного по умолчанию',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Учетная запись и домены клиента %1.',
    'ui__client__disabled-warning' => 'Учетная запись клиента %1 приостановлена.',
    'ui__client__none-available' => 'В системе нет учетных записей клиентов.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Клиент %1',
    'ui__client_self__description' => 'Список моих доменов',
    'ui__client_self__short-title' => 'Мои домены',
    'ui__client_self__title' => 'Мои домены',


    'site_apps__non_removable' => 'Элементы, которые не могут быть удалены',
    'site_apps__non_removable_items' => 'Невозможно удалить следующие веб-приложения:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Нет персональных кнопок.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'В Панели клиента %1 нет персональных кнопок.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Удалить кнопку %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Удалить',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Удалить кнопку %1.',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Удалить персональные кнопки из Панели клиента',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Удалить',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Удалить персональные кнопки',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Удалить кнопки',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Выберите клиента, персональные кнопки которого вы хотите удалить, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Выберите кнопки, которые следует удалить, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Подтвердите удаление кнопок, поставив флажок на этой странице, и затем нажмите Закончить.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Удалить персональную кнопку из Панели клиента.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Удалить',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Удалить персональную кнопку',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Удалить персональную кнопку',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Выберите клиента, кнопку которого хотите удалить, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Выберите кнопку, которую нужно удалить, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Поставьте флажок на этой странице для подтверждения удаления кнопки и затем нажмите Закончить.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Изменить параметры персональной кнопки %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Настройки',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Изменить персональную кнопку клиента %1.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Добавить персональную кнопку',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Выберите клиента, в Панели клиента которого вы хотите создать персональную кнопку, и нажмите Далее>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Для создания кнопки нажмите Закончить.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Изменить свойства кнопки в Панели клиента.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Свойства',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Изменить свойства кнопки в Панели клиента',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Изменить свойства персональной кнопки',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Выберите клиента, персональную кнопку которого вы хотите изменить, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Выберите кнопку, которую требуется изменить, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'После завершения редактирования свойств кнопки нажмите Закончить, чтобы применить изменения и выйти из мастера.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Сделать кнопку %1 недоступной для Ваших пользователей.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Сделать недоступной для Ваших пользователей',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Сделать кнопку %1 недоступной для Ваших пользователей',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Сделать кнопку %1 видимой для пользователей клиента.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Сделать доступной для Ваших пользователей',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Сделать кнопку %1 видимой для пользователей клиента',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Сделать персональную кнопку доступной/недоступной для Ваших пользователей.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступно/недоступно для Ваших пользователей',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Сделать персональную кнопку доступной или недоступной для Ваших пользователей',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Сделать персональную кнопку доступной/недоступной для Ваших пользователей.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Выберите клиента, персональную кнопку которого вы хотите сделать доступной для его пользователей, и нажмите Далее >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Выберите персональную кнопку, которую следует сделать доступной или недоступной для Ваших пользователей, и нажмите Далее >>.',

    'ui__client/domain__description' => 'Управление доменом %1.',
    'ui__client/domain__disabled-warning' => 'Домен %1 приостановлен.',
    'ui__client/domain__none-available' => 'У Вас нет доменов.',
    'ui__client/domain__none-available__1' => 'Учетная запись %1 не имеет доменов.',
    'ui__client/domain__none-available__2' => 'Учетная запись %1 не имеет доменов.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Домен %1',
    'ui__client/domain_self__description' => 'Управление вашим доменом.',
    'ui__client/domain_self__disabled-warning' => 'Ваш домен приостановлен.',
    'ui__client/domain_self__quick-search' => 'Мои домены',
    'ui__client/domain_self__short-title' => 'Мой домен',
    'ui__client/domain_self__title' => 'Мой домен',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'В Панели клиента нет персональных кнопок.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'В Панели клиента %1 нет персональных кнопок.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'В панели управления сайтом %1 нет настраиваемых кнопок.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Удалить персональную кнопку %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Удалить',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Удалить персональную кнопку %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Удалить персональные кнопки.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Удалить',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Удалить персональные кнопки',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Удалить персональные кнопки',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Выберите клиента, из чьей панели управления доменом вы хотите удалить кнопки, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Выберите домен, для которого следует удалить кнопки с панели администратора, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Выберите кнопки, которые следует удалить, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Подтвердите удаление кнопок, поставив соответствующие флажки, и нажмите Закончить для удаления кнопок и выхода из мастера.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Удалить персональную кнопку.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Удалить',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Удалить персональную кнопку',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Удалить персональную кнопку',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Выберите клиента, из чьей панели управления доменом вы хотите удалить персональную кнопку, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Выберите домен, из панели управления которым требуется удалить кнопку, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Выберите персональную кнопку для удаления и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Поставьте флажок для подтверждения удаления персональной кнопки и нажмите Закончить, чтобы удалить кнопку и выйти из мастера.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Изменить свойства персональной кнопки %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Свойства",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Изменить свойства персональной кнопки %1 в Панели клиента.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Добавить кнопку',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Выберите клиента, в Панель клиента которого вы хотите добавить кнопку, и нажмите Далее>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Выберите подписку, для которой вы хотите изменить кнопку, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Для создания кнопки и выхода из мастера нажмите Закончить.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Изменить свойства кнопки в Панели клиента.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Свойства',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Изменить свойства кнопки в Панели клиента',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Изменить свойства кнопки',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Выберите персональную кнопку, настройки которой вы хотите изменить, и нажмите Далее >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'После завершения изменения свойств кнопки нажмите Закончить, чтобы применить изменения и выйти из мастера.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Сделать кнопку %1 недоступной для почтовых пользователей этого домена.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Недоступно для почтовых пользователей',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Сделать кнопку %1 недоступной для почтовых пользователей этого домена',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Сделать кнопку %1 видимой для почтовых пользователей этого домена.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Доступно для почтовых пользователей этого домена',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Сделать персональную кнопку %1 видимой для почтовых пользователей этого домена',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Сделать персональную кнопку доступной или недоступной для других пользователей.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступно/недоступно для других пользователей',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Сделать персональную кнопку доступной или недоступной для почтовых пользователей',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Сделать персональную кнопку доступной или недоступной для других пользователей',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Выберите домен, куда следует поместить кнопку, и нажмите Далее >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Выберите кнопку, которую следует сделать доступной или недоступной для других пользователей и нажмите Далее >>.',

    'ui__client/domain/delete__description' => 'Удалить домен %1.',
    'ui__client/domain/delete__short-title' => 'Удалить',
    'ui__client/domain/delete__title' => 'Удалить домен %1',
    'ui__client/domain/delete_multi__description' => 'Удалить домены.',

    'ui__client/domain/delete_multi__short-title' => 'Удалить',
    'ui__client/domain/delete_multi__title' => 'Удалить домены',
    'ui__client/domain/delete_multi__wizard-title' => 'Удалить домены',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Выберите домены, которые следует удалить, и нажмите Далее >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Подтвердите удаление доменов, поставив флажки, и нажмите Закончить для выполнения операции удаления и входа из мастера.',
    'ui__client/domain/delete_unknown__description' => 'Удалить домен.',
    'ui__client/domain/delete_unknown__short-title' => 'Удалить',
    'ui__client/domain/delete_unknown__title' => 'Удалить домен',
    'ui__client/domain/delete_unknown__wizard-title' => 'Удалить домен',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Выберите домен, который нужно удалить и нажмите Далее >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Поставьте флажок для подтверждения удаления домена и нажмите Закончить, чтобы удалить его и выйти из мастера.',

    'ui__client/domain/hosting__none-available' => 'Нет доменов с настроенным веб-хостингом. Создайте домен и настройте веб-хостинг на нем, чтобы использовать эту функциональность.',
    'ui__client/domain/hosting__none-available__1' => 'В этой учетной записи пользователя нет доменов с настроенным веб-хостингом. Настройте веб-хостинг для нужного домена, чтобы использовать эту функциональность.',
    'ui__client/domain/hosting__none-available__2' => 'Веб-хостинг для домена %1 не настроен. Настройте веб-хостинг на домене %1, чтобы использовать эту функциональность.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Клиенты",
    'ui__client/domain/hosting/application#list_header__description__title' => "Описание",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Элементы",
    'ui__client/domain/hosting/application#list_header__name__title' => "Имя",
    'ui__client/domain/hosting/application#list_header__release__title' => "Выпуск",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Сортировать по клиентам",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Сортировать по описанию",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Сортировать по элементам",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Сортировать по имени",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Сортировать по выпуску",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Сортировать по версии",
    'ui__client/domain/hosting/application#list_header__title' => "Веб-приложения",
    'ui__client/domain/hosting/application#list_header__version__title' => "Версии",

    'rpt_reseller_section_general' => 'Общие',
    'rpt_reseller_section_domains' => 'Домены',
    'rpt_reseller_section_clients' => 'Клиенты',
    'statistics__cl_active_domains' => "Активные домены",
    'rpt_reseller_cl_domains' => "Домены",
    'rpt_reseller_cl_subdomains' => "Субдомены",
    'by__cl_domains' => "домены клиентов",
    'dom_ctrl__cl_mboxes' => "Почтовые ящики",
    'rpt_reseller_cl_redirects' => "Перенаправление",
    'rpt_reseller_cl_mail_groups' => "Почтовые группы",
    'rpt_reseller_cl_mail_resps' => "Автоответчики",
    'rpt_reseller_cl_mail_lists' => "Списки рассылки",
    'rpt_reseller_cl_web_users' => "Веб-пользователи",
    'rpt_reseller_cl_data_bases' => "Базы данных",

    'statistics__active_clients' => 'Клиенты с активными подписками',
    'statistics__clients_active_domains' => 'Активные домены',
    'statistics__clients_doms' => 'Домены',
    'statistics__cl_doms' => 'Домены',
    '__clients_subdomains' => 'Субдомены',
    '__clients_domains' => 'Домены',
    'dom_ctrl__clients_mboxes' => 'Почтовые ящики',
    'dom_ctrl__clients_redir' => 'Перенаправление',
    'dom_ctrl__clients_mg' => 'Почтовые группы',
    'dom_ctrl__clients_resp' => 'Автоответчики',
    'dom_ctrl__clients_maillists' => 'Списки рассылки',
    'dom_ctrl__clients_wu' => 'Веб-пользователи',
    'dom_ctrl__clients_db' => 'Базы данных',

    'dom_ctrl__cl_redir' => 'Перенаправление', // to resolve!
    'dom_ctrl__cl_mg' => 'Почтовые группы', // to resolve!
    'dom_ctrl__cl_resp' => 'Автоответчики', // to resolve!
    'dom_ctrl__cl_maillists' => 'Списки рассылки', // to resolve!
    'dom_ctrl__cl_wu' => 'Веб-пользователи', // to resolve!
    'dom_ctrl__cl_db' => 'Базы данных', // to resolve!

    'rpt_cl_section_clients' => 'Клиенты',

    'rpt_admin_section_general' => 'Общие',
    'rpt_admin_section_resellers' => 'Реселлеры',
    'rpt_admin_section_clients' => 'Клиенты',
    'rpt_admin_section_personal_clients' => 'Собственные клиенты',
    'rpt_admin_section_domains' => 'Домены',
    'rpt_admin_section_personal_domains' => 'Личные домены',

    'rpt_reseller_section_personal_domains' => 'Личные домены',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Выберите домен, который вы хотите приостановить или активировать.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Приостановить или активировать домен',

    'ui__client/ip-pool__description' => 'Управление IP-адресами и SSL/TLS-сертификатами клиента %1.',
    'ui__client/ip-pool__short-title' => 'Диапазон предоставленных адресов IP',
    'ui__client/ip-pool__title' => 'IP-пул клиента %1',
    'ui__client/ip-pool_self__description' => 'Посмотреть Ваши адреса IP',
    'ui__client/ip-pool_self__short-title' => 'Диапазон предоставленных адресов IP',
    'ui__client/ip-pool_self__title' => 'Мои адреса IP',
    'ui__client/ip-pool/properties__description' => 'Настроить IP-пул клиента %1.',

    'ui__client/ip-pool/properties__short-title' => 'Диапазон предоставленных адресов IP',
    'ui__client/ip-pool/properties__title' => 'Настроить IP-пул клиента %1',
    'ui__client/ip-pool/properties_self__description' => 'Посмотреть Ваши адреса IP',

    'ui__client/ip-pool/properties_self__short-title' => 'Мои адреса IP',
    'ui__client/ip-pool/properties_self__title' => 'Мои адреса IP',
    'ui__client/ip-pool/properties_unknown__description' => 'Управление IP-адресами и SSL/TLS-сертификатами клиента.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Диапазон предоставленных адресов IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Настроить IP-пул клиента',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Настроить IP-пул клиента',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Выберите клиента, чей IP-пул вы хотите настроить.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'После завершения настройки IP-пула нажмите Закончить, чтобы применить изменения и выйти из мастера.',


    'ui__client/limits_readonly-unknown__description' => 'Просмотр ограничений ресурсов клиента.',
    'ui__client/limits_readonly-unknown__short-title' => 'Ограничения по ресурсам',
    'ui__client/limits_readonly-unknown__title' => 'Просмотр ограничений ресурсов клиента',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Управление ограничениями ресурсов клиента',

    'ui__client/limits_unknown__wizard-title' => 'Управление ограничениями ресурсов клиента',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Выберите нужного клиента.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Выберите нужного клиента.',
    'ui__client/limits_unknown__wizard__2' => 'Нажмите Закончить, чтобы применить изменения.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Для выхода из мастера нажмите Закончить.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Для выхода из мастера нажмите Закончить.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Для выхода из мастера нажмите Закончить.',

    'ui__client/permissions_unknown__wizard-title' => 'Управление правами клиента',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Просмотрев список своих прав, нажмите Закончить, чтобы применить изменения и закрыть мастер.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Выберите клиента, чьи права вы хотите посмотреть или изменить.',
    'ui__client/permissions_unknown__wizard__2' => 'Внеся нужные изменения, нажмите Закончить, чтобы применить их и закрыть мастер.',

    'ui__client/preferences_unknown__wizard-title' => 'Редактировать настройки клиента',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Выберите клиента, чьи настройки сеанса и интерфейса вы хотите изменить.',
    'ui__client/preferences_unknown__wizard__2' => 'После завершения редактирования настроек клиента нажмите Закончить.',
    'ui__client/preferences_unknown__wizard__2_self' => 'После завершения редактирования ваших настроек нажмите Закончить.',

    'ui__custom-buttons/custom-button__none-available' => 'У вас нет персональных кнопок.',
    'ui__custom-buttons/custom-button/delete__description' => 'Удалить персональную кнопку %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Удалить',
    'ui__custom-buttons/custom-button/delete__title' => 'Удалить персональную кнопку %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Удалить персональные кнопки.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Удалить',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Удалить персональные кнопки',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Удалить персональные кнопки',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Выбрать кнопки, которые требуется удалить.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Поставьте флажок для подтверждения удаления кнопок и нажмите Закончить, чтобы завершить операцию и выйти из мастера.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Удалить персональные кнопки.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Удалить',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Удалить персональные кнопки',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Удалить персональные кнопки',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Выберите персональную кнопку для удаления.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Поставьте флажок для подтверждения удаления кнопки и нажмите Закончить, чтобы завершить операцию и выйти из мастера.',
    'ui__custom-buttons/custom-button/properties__description' => 'Изменить свойства кнопки %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Свойства',
    'ui__custom-buttons/custom-button/properties__title' => 'Изменить свойства кнопки %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Создать кнопку',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Для создания кнопки нажмите Закончить.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Изменить свойства персональной кнопки.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Свойства',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Изменить свойства кнопки персональной кнопки',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Изменить свойства кнопки персональной кнопки',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Выберите персональную кнопку, свойства которой требуется изменить.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Нажмите Закончить, чтобы применить изменения.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Сделать персональную кнопку %1 недоступной для других пользователей.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Недоступна для других пользователей',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Сделать персональную кнопку %1 недоступной для других пользователей',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Сделать персональную кнопку %1 доступной для других пользователей.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Доступна для других пользователей',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Сделать персональную кнопку %1 доступной для других пользователей',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Сделать персональную кнопку доступной или недоступной для других пользователей.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступна или недоступна для других пользователей',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Сделать персональную кнопку доступной или недоступной для других пользователей',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Сделать персональную кнопку доступной или недоступной для других пользователей',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Выберите персональную кнопку, которую требуется сделать доступной или недоступной для других пользователей, и нажмите Далее >>.',

    'ui__longtasks#list_header__name__title' => "Имя",
    'ui__longtasks#list_header__owner__title' => "Владелец",
    'ui__longtasks#list_header__start_time__title' => "Время создания",
    'ui__longtasks#list_header__status__title' => "Статус",
    'ui__longtasks#list_header__title' => "Задачи",
    'ui__longtasks#list_header__finish_time__title' => "Время завершения",
    'ui__longtasks#task_list_legend__title' => "Задачи",
    'ui__longtasks#tools_legend__title' => "Инструменты",
    'ui__longtasks__description' => "Управление фоновыми задачами",
    'ui__longtasks__short-title' => "Фоновые задачи",
    'ui__longtasks__title' => "Фоновые задачи",
    'ui__longtasks/longtask/properties#current_operation__title' => "Текущая операция:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Расчетное время завершения:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Общие",
    'ui__longtasks/longtask/properties#owner__title' => "Задачи, которые запустил:",
    'ui__longtasks/longtask/properties#progress__title' => "Общий прогресс:",
    'ui__longtasks/longtask/properties#start_time__title' => "Задача запущена:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Состояние задачи",
    'ui__longtasks/longtask/properties__description' => "Статус и информация по фоновой задаче",

    'ui__longtasks/properties__description' => "Настройки фоновых задач",
    'ui__longtasks/properties__short-title' => "Настройки",
    'ui__longtasks/properties__title' => "Фоновые задачи",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Шаблоны сообщений почтовой рассылки',
    'ui__mass-mail/template#list_header__name__title' => 'Название шаблона',
    'ui__mass-mail/template#list_header__from_email__title' => 'Отправитель',
    'ui__mass-mail/template#list_header__to__title' => 'Получатели',
    'ui__mass-mail/template#list_header__subject__title' => 'Тема',
    'ui__mass-mail/template#list_header__cdate__title' => 'Дата создания',
    'ui__mass-mail/template#list_header__send__title' => 'Отправить',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Редактировать шаблон сообщений почтовой рассылки',
    'ui__mass-mail/template/properties__description' => 'Редактировать этот шаблон сообщений почтовой рассылки.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Добавить шаблон сообщений почтовой рассылки',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Добавить шаблон сообщений почтовой рассылки',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Добавить шаблон сообщений почтовой рассылки.',
    'ui__mass-mail/send__short-title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send__title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send__description' => 'Отправить групповое почтовое сообщение выбранным получателям.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Удалить шаблоны сообщений почтовой рассылки',
    'ui__mass-mail/template/delete_multi__title' => 'Удалить следующие шаблоны сообщений почтовой рассылки:',
    'ui__mass-mail/template/delete_multi__description' => 'Удалить выбранные шаблоны сообщений почтовой рассылки.',
    'ui__mass-mail/template/delete_multi__done' => 'Выбранные шаблоны сообщений были удалены.',
    'ui__mass-mail/template/properties__invalid_values' => 'Указаны неверные значения',


    // old
    'ui__mass-mail#body_text__description' => 'Можно использовать <name> переменную в тексте сообщения (но не в заголовке). Она будет заменена контактным именем клиента или реселлера.',
    'ui__mass-mail#body_text__title' => 'Текст сообщения',
    'ui__mass-mail#compose_legend__title' => 'Сообщение',
    'ui__mass-mail#from_email_text__title' => 'От (адрес электронной почты)',
    'ui__mass-mail#list_header__cdate__title' => 'Создано',
    'ui__mass-mail#list_header__from_email__title' => 'От',
    'ui__mass-mail#list_header__name__title' => 'Имя',
    'ui__mass-mail#list_header__send__title' => 'Создать сообщение',
    'ui__mass-mail#list_header__subject__title' => 'Тема',
    'ui__mass-mail#list_header__title' => 'Шаблоны сообщений почтовой рассылки',
    'ui__mass-mail#list_header__to__title' => 'Кому',
    'ui__mass-mail#list_legend__title' => 'Шаблоны сообщений почтовой рассылки',
    'ui__mass-mail#load_template_text__title' => 'Загрузить',
    'ui__mass-mail#name_text__title' => 'Название шаблона',
    'ui__mass-mail#option_mode_all__title' => 'Все',
    'ui__mass-mail#option_mode_except__title' => 'Все за исключением выбранных',
    'ui__mass-mail#option_mode_select__title' => 'Только выбранные',
    'ui__mass-mail#option_select_template__title' => '---Выберите шаблон---',
    'ui__mass-mail#picker_legend__title' => 'Шаблоны почтовых сообщений',
    'ui__mass-mail#picker_title__title' => 'Выбрать шаблон',
    'ui__mass-mail#save_as_legend__title' => 'Сохранить как шаблон',
    'ui__mass-mail#save_as_text__title' => 'Сохранить составленное сообщение как новый шаблон с именем',
    'ui__mass-mail#subject_text__title' => 'Тема',
    'ui__mass-mail#template_legend__title' => 'Шаблон',
    'ui__mass-mail#to_admin_text__title' => 'Администратор Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Клиенты',
    'ui__mass-mail#to_domains_text__title' => 'Администраторы доменов',
    'ui__mass-mail#to_select_text__title' => 'Выбрать адреса',
    'ui__mass-mail#to_show_hide_text__title' => 'Показать/скрыть выбранные',
    'ui__mass-mail#to_text__title' => 'Кому',
    'ui__mass-mail#tools_legend__title' => 'Инструменты',
    'ui__mass-mail__already_exists' => 'Шаблон с именем %1 уже существует',
    'ui__mass-mail__none-available' => 'У Вас нет шаблонов сообщений.',

    'ui__mass-mail/delete__description' => 'Удалить шаблон сообщений почтовой рассылки %1',

    'ui__mass-mail/delete__empty_selection' => 'Пожалуйста, выберите шаблоны, которые требуется удалить',
    'ui__mass-mail/delete__short-title' => 'Удалить %1',
    'ui__mass-mail/delete__title' => 'Удалить шаблон сообщений почтовой рассылки %1',
    'ui__mass-mail/delete_multi__description' => 'Удалить шаблоны сообщений почтовой рассылки.',

    'ui__mass-mail/delete_multi__short-title' => 'Удалить',
    'ui__mass-mail/delete_multi__title' => 'Удалить шаблоны сообщений почтовой рассылки',
    'ui__mass-mail/delete_multi__wizard-title' => 'Удаление шаблонов сообщений почтовой рассылки',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Выберите шаблоны сообщений почтовой рассылки, которые вы хотите удалить.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Поставьте флажок для подтверждения удаления шаблонов и нажмите Закончить, чтобы завершить операцию и выйти из мастера.',
    'ui__mass-mail/delete_unknown__description' => 'Удалить шаблоны сообщений почтовой рассылки.',
    'ui__mass-mail/delete_unknown__short-title' => 'Удалить',
    'ui__mass-mail/delete_unknown__title' => 'Удалить шаблоны сообщений почтовой рассылки',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Удаление шаблонов сообщений почтовой рассылки.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Выберите шаблон сообщений почтовой рассылки, который вы хотите удалить.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Поставьте флажок для подтверждения удаления шаблона и нажмите Закончить, чтобы завершить операцию и выйти из мастера.',

    'ui__mass-mail/properties__description' => 'Редактировать шаблон почтовых сообщений %1.',

    'ui__mass-mail/properties__invalid_values' => 'Указанные значения недопустимы',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Редактировать шаблон почтовых сообщений %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Создать шаблон сообщений почтовой рассылки',
    'ui__mass-mail/properties_unknown-new__description' => 'Создать шаблон почтовых сообщений.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Добавить шаблон почтовых сообщений',
    'ui__mass-mail/properties_unknown-new__title' => 'Создать шаблон почтовых сообщений',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Редактировать шаблон сообщений почтовой рассылки',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Выберите шаблон, который требуется изменить, и нажмите Далее >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'После завершения редактирования шаблона нажмите Закончить, чтобы применить изменения и выйти из мастера.',

    'ui__mass-mail/send__invalid_values' => 'Указаны недопустимые значения',

    'ui__mass-mail/send_new__wizard-title' => 'Создать шаблон сообщения и отправить письмо',
    'ui__mass-mail/send_unknown-new__description' => 'Отправить сообщение выбранным получателям',

    'ui__mass-mail/send_unknown-new__short-title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send_unknown-new__title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send_unknown__description' => 'Отправить сообщение выбранным получателям',

    'ui__mass-mail/send_unknown__short-title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send_unknown__title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send_unknown__wizard-title' => 'Отправить групповое сообщение',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Выберите нужный шаблон и нажмите Далее >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'После завершения редактирования свойств шаблона нажмите Закончить, чтобы отправить сообщение и выйти из мастера.',

    'ui__mass-email/delete__description' => 'Удалить выбранные шаблоны сообщений почтовой рассылки.',

    'ui__mass-email/delete__empty_selection' => "Пожалуйста, выберите шаблоны, которые вы хотите удалить",
    'ui__mass-email/delete__short-title' => "Удалить %1",
    'ui__mass-email/delete__title' => "Удалить шаблон сообщений почтовой рассылки %1",
    'ui__mass-email/delete_multi__description' => "Удалить шаблоны сообщений почтовой рассылки.",

    'ui__mass-email/delete_multi__short-title' => "Удалить",
    'ui__mass-email/delete_multi__title' => "Удалить шаблоны сообщений почтовой рассылки",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Поставьте флажок для подтверждения удаления шаблонов и нажмите Закончить, чтобы завершить операцию и выйти из мастера.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Выберите шаблоны сообщений почтовой рассылки, которые вы хотите удалить.",
    'ui__mass-email/delete_multi__wizard-title' => "Удаление шаблонов сообщений почтовой рассылки",
    'ui__mass-email/delete_unknown__description' => "Удалить шаблоны сообщений почтовой рассылки.",
    'ui__mass-email/delete_unknown__short-title' => "Удалить",
    'ui__mass-email/delete_unknown__title' => "Удалить шаблоны сообщений почтовой рассылки",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Поставьте флажок для подтверждения удаления шаблона и нажмите Закончить, чтобы завершить операцию и выйти из мастера.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Выберите шаблон сообщений почтовой рассылки, который вы хотите удалить.",
    'ui__mass-email/delete_unknown__wizard-title' => "Удаление шаблонов сообщений почтовой рассылки.",
    'ui__mass-email/send__description' => "Отправить сообщение выбранным получателям",
    'ui__mass-email/send__short-title' => "Отправить групповое сообщение",
    'ui__mass-email/send__title' => "Отправить групповое сообщение",
    'ui__mass-email/send_main__description' => "Отправить сообщение выбранным получателям",

    'ui__mass-email/send_main__short-title' => "Отправить групповое сообщение",
    'ui__mass-email/send_main__title' => "Отправить групповое сообщение",
    'ui__mass-email/send_selectresellers__title' => 'Выбрать реселлеров',
    'ui__mass-email/send_selectresellers__short-title' => 'Реселлеры',
    'ui__mass-email/send_selectresellers__description' => 'Выбрать учетные записи реселлеров',

    'ui__mass-email/send_selectclients__description' => "Выберите учетные записи клиентов",

    'ui__mass-email/send_selectclients__short-title' => "Клиенты",
    'ui__mass-email/send_selectclients__title' => "Выберите клиентов",
    'ui__mass-email/send_selectdomainusers__description' => "Выбрать учетные записи администраторов доменов",

    'ui__mass-email/send_selectdomainusers__short-title' => "Администраторы доменов",
    'ui__mass-email/send_selectdomainusers__title' => "Выбрать администраторов доменов",
    'ui__mass-email/template/properties_main__description' => "Создать шаблон сообщений почтовой рассылки",
    'ui__mass-email/template/properties_main__short-title' => "Редактировать шаблон",
    'ui__mass-email/template/properties_main__title' => "Редактировать шаблон сообщений почтовой рассылки",
    'ui__mass-email/template/properties_new-main__description' => "Создать шаблон сообщений почтовой рассылки.",
    'ui__mass-email/template/properties_new-main__short-title' => "Создать шаблон сообщений почтовой рассылки",
    'ui__mass-email/template/properties_new-main__title' => "Создать шаблон сообщений почтовой рассылки",
    'ui__mass-email/template/properties_new-selectclients__description' => "Выберите клиентов, которые будут получать групповые сообщения на основе этого шаблона",
    'ui__mass-email/template/properties_new-selectclients__title' => "Выберите клиентов, которые будут получать групповые сообщения на основе этого шаблона",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Выберите администраторов доменов, которые будут получать групповые сообщения на основе этого шаблона.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Выберите администраторов доменов, которые будут получать групповые сообщения на основе этого шаблона.",
    'ui__mass-email/template/properties_selectclients__title' => "Выберите клиентов, которые будут получать групповые сообщения на основе этого шаблона",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Выберите администраторов доменов, которые будут получать групповые сообщения на основе этого шаблона.",

    'ui__mass-email/template/properties_unknown-new__description' => "Создать шаблон сообщений почтовой рассылки",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Создание шаблона",
    'ui__mass-email/template/properties_unknown-new__title' => "Создание шаблона сообщения почтовой рассылки",
    'ui__news/dismiss__description' => 'Нажмите, чтобы скрыть новости. Plesk не будет показывать их, пока не появятся новые статьи.',

    'ui__news/dismiss__title' => 'Закрыть новости',

    'ui__server__description' => 'Управление сервером',
    'ui__server__short-title' => 'Управление Вашим сервером',
    'ui__server__title' => 'Управление сервером',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP-адрес %1 недоступен.',
    'ui__server/ip-address__none-available' => 'Нет IP-адресов.',
    'ui__server/ip-addresses/ip-address__title' => "IP-адреса",
    'ui__server/ip-address/client/properties_new__description' => "Присвоить IP-адрес %1 реселлерам.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Назначить',
    'ui__server/ip-address/client/properties_new__title' => "Присвоить IP-адрес %1 реселлерам",
    'ui__server/ip-address/client__none-available' => 'Нет учетных записей пользователей',
    'ui__server/ip-address/client_unknown__quick_search' => 'Пользователи',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Список пользователей, которые используют этот IP-адрес.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Пожалуйста, выберите IP-адрес.',
    'ui__server/ip-address/client/delete__description' => 'Открепить IP-адрес от этого реселлера.',
    'ui__server/ip-address/client/delete__short-title' => 'Отменить назначение',
    'ui__server/ip-address/client/delete__title' => 'Открепить IP-адрес от этого реселлера',
    'ui__server/ip-address/client/delete_multi__description' => "Удалить IP-адрес из пулов реселлеров.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Отменить назначение',
    'ui__server/ip-address/client/delete_multi__title' => 'Открепить IP-адрес от реселлера',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Удалить IP-адрес из пулов пользователей.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Выберите IP-адрес, по которому вы хотите отменить назначение пользователям, и нажмите Далее >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Выберите пользователей, для которых вы хотите снять назначение IP-адреса, и нажмите Далее >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Поставьте флажок для подтверждения отмены назначения IP-адреса пользователям и нажмите Закончить, чтобы завершить работу мастера.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Открепить IP-адрес от реселлеров.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Отменить назначение',
    'ui__server/ip-address/client/delete_unknown__title' => 'Открепить IP-адрес от реселлеров',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Отменить назначение IP-адреса пользователям',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Выберите IP-адрес, по которому вы хотите отменить назначение пользователям, и нажмите Далее >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Выберите пользователя, для которого вы хотите снять назначение IP-адреса, и нажмите Далее >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Поставьте флажок для подтверждения отмены назначения IP-адреса пользователям и нажмите Закончить, чтобы завершить работу мастера.',

    'ui__server/ip-address/domain__description' => "Все домены на IP-адресе %1.",
    'ui__server/ip-address/domain__short-title' => "Домены",
    'ui__server/ip-address/domain__title' => "Домены на IP-адресе %1",
    'ui__server/ip-address/domain_unknown__description' => "Все домены на IP-адресе.",
    'ui__server/ip-address/domain_unknown__short-title' => "Домены",
    'ui__server/ip-address/domain_unknown__title' => "Домены на IP-адресе",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Выберите нужный IP-адрес и нажмите Далее >>.",

    'ui__server/ip-address/properties__description' => 'Изменить свойства IP-адреса %1.',
    'ui__server/ip-address/properties__short-title' => 'Свойства',
    'ui__server/ip-address/properties__title' => 'Изменить свойства IP-адреса %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Добавить IP-адрес',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'После изменения свойств IP-адреса нажмите Закончить, чтобы применить изменения.',
    'ui__server/ip-address/properties_unknown__description' => 'Изменить свойства IP-адреса.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Свойства',
    'ui__server/ip-address/properties_unknown__title' => 'Изменить свойства IP-адреса',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Изменить свойства IP-адреса',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Выберите IP-адрес, свойства которого вы хотите изменить.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'После изменения свойств IP-адреса нажмите Закончить, чтобы применить изменения.',

    'ui__server/spam-filter/black-list__description' => 'Настроить черный список для глобального антиспама.',
    'ui__server/spam-filter/black-list__short-title' => 'Черный список',
    'ui__server/spam-filter/black-list__title' => 'Черный список для глобального антиспама',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Будет добавлено только следующее количество первых уникальных адресов электронной почты: %1.',
    'ui__server/spam-filter/black-list/address__description' => 'Адрес из черного списка антиспама.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'В списке нет ни одного адреса электронной почты.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Загружен пустой файл.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Следующие адреса электронной почты являются недопустимыми: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'В черном списке антиспама нет ни одного адреса.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Адрес',
    'ui__server/spam-filter/black-list/address__title' => 'Адрес %1 из черного списка',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Добавить адреса в черный список.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Добавить адреса',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Добавить адреса в черный список',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Удалить адрес %1 из глобального черного списка.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Удалить',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Удалить адрес %1 из глобального черного списка',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Удалить адреса из глобального черного списка.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Удалить',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Удалить адреса из глобального черного списка',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Удаление адресов из глобального черного списка антиспама',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Выберите адреса, которые хотите удалить, и нажмите Далее >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Подтвердите удаление и нажмите Закончить.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Удалить адрес из глобального черного списка.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Удалить',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Удалить адрес из глобального черного списка',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Удаление адресов из глобального черного списка антиспама',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Выберите адрес, который хотите удалить, и нажмите Далее >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Подтвердите удаление и нажмите Закончить.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Будет добавлено только следующее количество первых уникальных адресов электронной почты: %1.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'В списке нет ни одного адреса электронной почты.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Не удалось загрузить файл. Максимально допустимый размер загружаемого файла %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Следующие адреса электронной почты являются недопустимыми: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Добавить адреса в черный список.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Добавить адреса',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Добавить адреса в черный список',

    'ui__server/spam-filter/properties__description' => 'Настроить глобальный антиспам.',

    'ui__server/spam-filter/properties__short-title' => 'Настройки',
    'ui__server/spam-filter/properties__title' => 'Настройки антиспама',

    'ui__server/spam-filter/toggle_disable__description' => 'Отключить антиспам для всей системы.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Отключить',
    'ui__server/spam-filter/toggle_disable__title' => 'Отключить антиспам',
    'ui__server/spam-filter/toggle_enable__description' => 'Включить антиспам для всего сервера.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Включить',
    'ui__server/spam-filter/toggle_enable__title' => 'Включить антиспам',
    'ui__server/spam-filter/toggle_unknown__description' => 'Включить или отключить антиспам для всего сервера.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Разрешить или запретить к выполнению',
    'ui__server/spam-filter/toggle_unknown__title' => 'Включить или отключить антиспам',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Включить или отключить антиспам',

    'ui__server/spam-filter/white-list__description' => 'Настроить глобальный белый список антиспама.',
    'ui__server/spam-filter/white-list__short-title' => 'Белый список',
    'ui__server/spam-filter/white-list__title' => 'Глобальный белый список антиспама',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Будет добавлено только следующее количество первых уникальных адресов электронной почты: %1.',
    'ui__server/spam-filter/white-list/address__description' => 'Адрес из белого списка антиспама.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'В списке нет ни одного адреса электронной почты.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Загружен пустой файл.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Следующие адреса электронной почты являются недопустимыми: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'В глобальном белом списке антиспама нет ни одного адреса.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Адрес',
    'ui__server/spam-filter/white-list/address__title' => 'Адрес %1 из белого списка',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Добавить адреса в белый список.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Добавить адреса',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Добавить адреса в белый список',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Удалить адрес %1 из глобального белого списка.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Удалить',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Удалить адрес %1 из глобального белого списка',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Удалить адреса из глобального белого списка.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Удалить',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Удалить адреса из глобального белого списка',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Удаление адресов из глобального белого списка антиспама',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Выберите адреса, которые хотите удалить, и нажмите Далее >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Подтвердите удаление и нажмите Закончить.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Удалить адрес из глобального белого списка.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Удалить',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Удалить адрес из глобального белого списка',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Удаление адресов из глобального белого списка антиспама',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Выберите адрес, который хотите удалить, и нажмите Далее >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Подтвердите удаление и нажмите Закончить.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Будет добавлено только следующее количество первых уникальных адресов электронной почты: %1.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'В списке нет ни одного адреса электронной почты.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Не удалось загрузить файл. Максимально допустимый размер загружаемого файла %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Следующие адреса электронной почты являются недопустимыми: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Добавить адреса в белый список.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Добавить адреса',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Добавить адреса в белый список',

    'ui__server/mail/statistics#apply__description' => "Применить фильтр",
    'ui__server/mail/statistics#apply__title' => "Применить",
    'ui__server/mail/statistics#custom_from__title' => "от кого",
    'ui__server/mail/statistics#custom_to__title' => "кому",
    'ui__server/mail/statistics#period_all__title' => "Все",
    'ui__server/mail/statistics#period_custom__title' => "Персональный",
    'ui__server/mail/statistics#period_month__title' => "Текущий месяц",
    'ui__server/mail/statistics#period_prev_month__title' => "Предыдущий месяц",
    'ui__server/mail/statistics#period_prev_week__title' => "Предыдущая неделя",
    'ui__server/mail/statistics#period_today__title' => "Сегодня",
    'ui__server/mail/statistics#period_week__title' => "Текущая неделя",
    'ui__server/mail/statistics#period_yesterday__title' => "Вчера",
    'ui__server/mail/statistics#show_for_period__title' => "Показать за период",
    'ui__server/mail/statistics#tools_legend__title' => "Инструменты",
    'ui__server/mail/statistics__description' => "Посмотреть статистику по спаму и вирусам",

    'ui__server/mail/statistics__short-title' => "Статистика",
    'ui__server/mail/statistics__title' => "Статистика",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Статистика спама",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Инструменты",
    'ui__server/mail/statistics/spam__description' => "Посмотреть статистику спама",

    'ui__server/mail/statistics/spam__short-title' => "Статистика спама",
    'ui__server/mail/statistics/spam__title' => "Статистика спама",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Почтовое имя",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% от всего",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Сортировать по учетной записи почты",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Сортировать по % от всего",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Сортировать по полученному спаму",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "учетные записи почты",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Полученный спам",
    'ui__server/mail/statistics/spam/recipients__description' => "Получатели",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Получатели",
    'ui__server/mail/statistics/spam/recipients__title' => "Получатели",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Чистые",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Зараженные",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Статус",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% от всего",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Количество",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Защищенные",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Не проверены",
    'ui__server/mail/statistics/spam/summary__description' => "Описание",

    'ui__server/mail/statistics/spam/summary__short-title' => "Описание",
    'ui__server/mail/statistics/spam/summary__title' => "Описание",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Статистика вирусов",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Инструменты",
    'ui__server/mail/statistics/virus__description' => "Просмотреть статистику по вирусам",

    'ui__server/mail/statistics/virus__short-title' => "Статистика вирусов",
    'ui__server/mail/statistics/virus__title' => "Статистика вирусов",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Учетная запись почты",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% от всего",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Сортировать по почтовому имени",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Сортировать по % от всего",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Сортировать по полученным вирусам",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Учетные записи почты",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Полученные вирусы",
    'ui__server/mail/statistics/virus/recipients__description' => "Получатели",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Получатели",
    'ui__server/mail/statistics/virus/recipients__title' => "Получатели",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Чистые",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Зараженные",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Статус",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% от всего",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Количество",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Защищенные",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Не проверены",
    'ui__server/mail/statistics/virus/summary__description' => "Описание",

    'ui__server/mail/statistics/virus/summary__short-title' => "Описание",
    'ui__server/mail/statistics/virus/summary__title' => "Описание",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Имя",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% от всего",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Сортировать по имени",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Сортировать по % от всего",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Сортировать по зараженным объектам",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Вирусы",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Инфицированные объекты",
    'ui__server/mail/statistics/virus/viruses__description' => "Вирусы",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Вирусы",
    'ui__server/mail/statistics/virus/viruses__title' => "Вирусы",

    'ui__support#param_company__title' => "Компания",
    'ui__support#param_email__title' => "Электронная почта",
    'ui__support#param_firstname__title' => "Имя",
    'ui__support#param_keynumber__title' => "Номер ключа продукта",
    'ui__support#param_operatingsystem__title' => "Операционная система",
    'ui__support#param_phone__title' => "Телефон",
    'ui__support#param_psabuild__title' => "Сборка Plesk",
    'ui__support#param_psainsttype__title' => "Тип установки Plesk",
    'ui__support#param_psaversion__title' => "Версия Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Инструменты",

    'ui__reseller/traffic-history_unknown__short-title' => "Посмотреть трафик по реселлерам",
    'ui__reseller/traffic-history_unknown__title' => "Посмотреть трафик по реселлерам",
    'ui__reseller/traffic-history_unknown__description' => "Посмотреть трафик по учетным записям реселлеров.",
    'ui__reseller#list__title' => "Реселлеры",
    'accounts_list__name__filter_title' => "Имя",
    'accounts_list__resource__filter_title' => "Использование ресурсов",
    'resellers_list__filter_resource_usage_any' => "Все",
    'resellers_list__filter_resource_usage_overuse' => "Перерасход",
    'resellers_list__filter_resource_usage_normal' => "В рамках ограничений",
    'accounts_list__status__filter_title' => "Статус",
    'resellers_list__filter_status_any' => "Все",
    'resellers_list__filter_status_blocked' => "Приостановлен",
    'resellers_list__filter_status_active' => "Активен",
    'resellers_list__filter_clients__filter_title' => "Показать",
    'resellers_list__filter_clients_on' => "Реселлеры и их клиенты",
    'resellers_list__filter_clients_off' => "Только реселлеры",
    '__disk_usage' => "Используемое дисковое пространство",
    'ui__reseller/traffic_unknown__short-title' => "Посмотреть трафик по реселлерам",
    'ui__reseller/traffic_unknown__title' => "Посмотреть трафик по реселлерам",
    'ui__reseller/traffic#list__title' => "Трафик по реселлеру",
    'ui__reseller/traffic_unknown__description' => "Посмотреть отчеты по использованию трафика.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Трафик по реселлеру",

    '__reseller_name' => "Имя реселлера",
    '__reseller' => "Реселлеры",
    'resellertrafficlist_header' => "Посмотреть трафик по реселлерам",
    '__reseller_personal' => "Трафик, используемый доменами реселлера",
    'ui__reseller/traffic-history__short-title' => "Трафик по реселлерам",
    'ui__reseller/traffic-history__title' => "Трафик по реселлерам",
    'ui__reseller/traffic-history__description' => "Посмотреть отчеты по использованию трафика.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Разрешить продажу сверх запасов",
    'limits__reseller_oversell_description' => "Продажа сверх запасов разрешает реселлеру продавать больше ресурсов, чем для него выделено фактически. Если продажа сверх запасов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов",
    'limits__overuse_block_text' => "Перерасход",
    'limits__overuse_block_true_text' => "Перерасход запрещен",
    'limits__reseller_overuse_block_true_description' => "Блокировать перерасход ресурсов. Фактическое использование ресурсов не может превышать изначально выделенные объемы ресурсов",
    'limits__overuse_block_false_text' => "Перерасход разрешен",
    'limits__reseller_overuse_block_false_description' => "Не блокировать перерасход ресурсов, разрешая реселлеру использовать больше ресурсов, чем предоставлено изначально. Фактическое использование ресурсов может превышать изначально выделенные объемы ресурсов",
    'limits__reseller_overuse_notify_text' => "Уведомлять реселлера о достижении ограничений по ресурсам",
    'reseller_perm__manage_sh_access_disabled' => "Реселлер не может разрешить или запретить shell-доступ",
    'reseller_perm__manage_sh_access_chrooted' => "Реселлер может разрешить доступ только к chrooted-окружению",
    'reseller_perm__manage_sh_access_any' => "Реселлер может разрешить доступ к любому типу командной оболочки",
    'template__reseller_num_excl_ips' => "Предоставить выделенные IP-адреса реселлеру",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Учетная запись",
    'ui__reseller#info__title' => "Информация",
    'ui__reseller#clientsTab__title' => "Клиенты",
    'ui__reseller#domainsTab__title' => "Домены",
    'ui__reseller__title' => "Управление реселлером %1",
    'domains__reseller_info' => "клиентов: %1, доменов: %2, используемое дисковое пространство: %3, передано данных: %4.",
    'domains__reseller_info_hiding_traffic' => "клиентов: %1, доменов: %2, используемое дисковое пространство: %3.",
    'ui__reseller__description' => "Управление учетной записью реселлера.",

    'ui__reseller/limits_unknown__wizard-title' => 'Посмотреть или изменить ограничения по ресурсам для реселлера',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Выберите нужного реселлера.',
    'ui__reseller/limits_unknown__wizard__2' => 'Нажмите Закончить, чтобы применить изменения.',

    'ui__client/report_reseller__short-title' => "Отчет",
    'ui__client/report_reseller__title' => "Посмотреть отчет по учетной записи",
    'ui__client/report_reseller__description' => "Посмотреть отчет по учетной записи реселлера.",
    'ui__client/ip-pool_reseller__short-title' => "Диапазон предоставленных адресов IP",
    'ui__client/ip-pool_reseller__description' => "Назначить IP-адреса и SSL/TLS-сертификаты этому реселлеру.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Укажите настройки учетной записи и нажмите Закончить.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Посмотреть или изменить права реселлера',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Выберите реселлера, права которого вы хотите посмотреть или изменить.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Изменив права реселлера, нажмите Закончить, чтобы применить изменения и закрыть мастер.',

    // Customers > create customer account

    '__resellers_list' => 'Реселлеры',
    'picker_reseller__title' => 'Выбрать реселлера',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Инструменты",
    'ui__client#tools2__title' => "Учетная запись",
    'ui__client#info__title' => "Информация",
    'ui__client#clientslist__title' => "Клиенты",
    'ui__client#domainslist__title' => "Домены",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Все веб-приложения теперь упорядочены по категориям, благодаря чему становится проще выбрать нужное приложение для установки.",
    'feature__domainkeys__reseller' => "Механизм идентификации отправителей сообщений DKIM поможет вам сократить объем спама и мошеннических писем.",

    '__reseller_form' => "Форма реселлера",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Выберите учетную запись клиента, настройки которой вы хотите изменить.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Чтобы изменить ограничения на использование ресурсов, нажмите Ограничения ресурсов.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Чтобы изменить список операций, которые клиент может выполнять в Plesk, нажмите Права.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Сделать этот шаблон доступным для других пользователей",
    'template__shared_description' => "Отметьте эту опцию, если вы хотите, чтобы ваши клиенты могли использовать этот шаблон.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Инструменты',

    'ui__client/traffic-history_unknown__short-title' => 'Посмотреть трафик по клиентам',
    'ui__client/traffic-history_unknown__title' => 'Трафик по клиентам',
    'ui__client/traffic-history_unknown__description' => 'Посмотреть отчет о расходе трафика по всем клиентам',
    'ui__client/traffic-history__short-title' => 'Трафик по клиентам',
    'ui__client/traffic-history__title' => 'Посмотреть трафик по клиентам',
    'ui__client/traffic-history__description' => 'Посмотреть отчет о расходе трафика по всем клиентам',

    'ui__client/traffic#list__title' => 'Трафик по клиентам',
    'ui__reseller/client/traffic#list__title' => 'Трафик по клиентам',

    'clients_list__filter_type__filter_title' => 'Показать',
    'clients_list__filter_type_any' => 'Клиенты и реселлеры',
    'clients_list__filter_type_clients' => 'Только клиенты',
    'clients_list__filter_type_resellers' => 'Только реселлеры',
    'ui__client/domain_unknown-new__short-title' => "Создать домен",

    // Customers > View traffic by customers
    '__personal' => "Трафик, используемый доменами пользователя",
    'PersonalTrafficList_header_of_client__' => "Посмотреть отчет по использованию трафика для вашей учетной записи",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Администратор домена не может разрешить или запретить shell-доступ",
    'domain_perm__manage_sh_access_chrooted' => "Администратор домена может разрешить доступ только к chrooted-окружению",
    'domain_perm__manage_sh_access_any' => "Администратор домена может разрешить доступ к любому типу командной оболочки",

    // APS Catalog
    'bt_add_to_vault' => "Добавить в хранилище",
    'bt_hide_updates' => "Скрыть доступные обновления",
    'bt_show_updates' => "Показать доступные обновления",

    '__site_apps__applications' => "Приложения",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Приложения, выбранные для добавления в хранилище",
    'site_apps__application_selected' => "Выбранные",
    'site_apps__currently_in_vault' => "Другие версии уже имеются в хранилище:",
    'site_apps__new_versions' => "Новые версии:",
    'site_apps__patches' => "Исправления:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Количество приложений, запланированных для добавления в хранилище: %1",
    'site_apps__applications_downloading_now' => "Сейчас загружаются следующие приложения: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Уже имеется в хранилище",

    // Server > Action Log
    'bt_skin_edit' => "Редактировать описание схемы оформления",
    'domains__you_want_change_the_status_of_the_reseller??' => "Вы уверены, что хотите изменить статус учетной записи реселлера?",
    'limits__oversell_legend' => "Продажа сверх запасов",
    'limitsManager__limit_available_error' => "Невозможно выделить требуемый объем ресурсов (%%limitName%%, объем: %%quantity%%). Доступные ресурсы: %%limitName%%, объем: %%available%%.",
    'limitsManager__limit_reserved_error' => "Невозможно установить требуемое ограничение на использование ресурсов (%%limitName%%, объем: %%quantity%%), так как новое значение меньше, чем объем ресурсов, зарезервированный для ваших клиентов или используемый вами (%%limitName%%, объем: %%reserved%%).",
    'limitsManager__limit_used_error' => "Невозможно установить требуемое ограничение на использование ресурсов (%%limitName%%, объем: %%quantity%%), так как новое значение меньше, чем фактический объем ресурсов, уже используемый вашей учетной записью и сайтами (%%limitName%%, объем: %%used%%).",

    'ui__client/domain/traffic#list__title' => "Расход трафика по услугам",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Посмотреть отчет по использованию трафика",
    'ui__client/domain/traffic_unknown-reseller__title' => "Посмотреть отчет по использованию трафика",

    'ui__client/domain_new__short-title' => "Создать домен",

    'ui__client_reseller__description' => "Управление учетной записью реселлера %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Управление учетной записью реселлера",

    '__owner_name' => "Имя владельца",
    'domains_list__resource__filter_title' => "Использование ресурсов",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Каталог приложений APS",
    'site_apps__applications_have_updates' => "Доступны обновленные версии следующих приложений:\n%1\nДля того чтобы просмотреть обновления, убедитесь, что отображается область поиска, поставьте флажок в поле <b>Показывать только обновления</b> и выполните поиск нужных приложений.",
    'site_apps__progress_adding_to_vault' => "Добавление в хранилище:",
    'site_apps__progress_done_message' => "Статус:",
    'site_apps__progress_applications_left' => "Осталось приложений: %1 из %2",
    'site_apps__download_item_long_task_title' => "Загрузить приложение APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Загрузить приложения APS из каталога APS",
    'site_apps__last_check_for_updates' => "последняя проверка обновлений: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Все запланированные приложения успешно добавлены в хранилище приложений",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "Запланированные приложения в количестве %1 штук успешно добавлены в хранилище приложений.",
    'site_apps__no_search_results' => 'Приложения не найдены. Попробуйте изменить критерии поиска или просмотреть приложения по категориям.',
    'site_apps__search_results_title' => 'Результаты поиска',
    '__site_apps__search_by_application' => 'Название приложения',
    '__site_apps__search_by_vendor' => 'Разработчик',
    '__site_apps__search_by_vendor__all' => 'Все производители',
    '__site_apps__search_by_packager' => 'Упаковщик',
    '__site_apps__search_by_certification_level' => 'Уровень сертификации',
    '__site_apps__search_by_cert__any' => 'Все',
    '__site_apps__search_by_cert__silver_and_higher' => 'Серебряный и выше',
    '__site_apps__search_by_cert__gold_and_higher' => 'Золотой и выше',
    '__retry' => 'Повторить попытку',
    'site_apps__application_packager_site' => 'Упаковщик',
    'site_apps__add_to_pool_message' => "Приложения, помеченные как \"доступные для всех\", автоматически поставляются всем реселлерам и клиентам с неограниченным числом установок. Ограниченные приложения поставляются всем реселлерам и клиентам вручную на индивидуальной основе с указанием допустимого числа установок.",
    'site_apps__make_available_for_all' => "Сделать выбранные приложения доступными для всех пользователей",

    'site_apps__broadcast_app_text' => "Приложения, помеченные как \"доступные для всех\", автоматически поставляются всем реселлерам и клиентам с неограниченным числом установок. Ограниченные приложения поставляются всем реселлерам и клиентам вручную на индивидуальной основе с указанием допустимого числа установок.",
    'site_apps__broadcast_app_name' => 'Сделать приложения доступными для всех пользователей',

    // User Application Pool per application
    'site_apps__available_clients' => 'Доступные пользователи',
    'site_apps__no_more_clients_to_add_to_pool' => 'Больше нет учетных записей пользователей, которым вы можете предоставить это приложение',

    // Installed application instances
    'site_apps__installations' => 'Число установок',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Имя и IP-адрес домена",
    '__assign_ip_address' => "Назначить IP-адрес",
    '__switch_on_service' => "Включить службу",
    '__hosting_configuration' => "Конфигурация хостинга",
    '__vrt_hst' => "Хостинг веб-сайтов",
    '__vrt_hst_hint' => "Разместить веб-сайт на этом сервере.",
    '__fwd' => "Перенаправление",
    '__web_hosting_settings' => "Настройки хостинга",
    '__fwd_hint' => "Перенаправлять посетителей на другой веб-сайт.",
    '__none_hint' => "Не размещать веб-сайт в настоящий момент.",
    '__login_hint' => "Это имя пользователя используется для доступа к вашему веб-сайту через FTP.",
    '__password_hint' => "Этот пароль используется для доступа к вашему веб-сайту через FTP.",
    '__advanced_hosting_setup' => "Настроить дополнительные параметры хостинга веб-сайтов",
    '__domain_creation_successful' => "Домен был создан.",
    'bt_hosting_settings' => "Настройки хостинга",
    '__change_hosting_type' => "Изменить тип хостинга для домена %1",
    '__hosting_type_change_warning' => "Когда вы изменяете тип хостинга на перенаправление, все файлы и папки, относящиеся к вашему веб-сайту, удаляются с сервера. Не забудьте сделать локальную копию своего сайта.",
    '__current_hosting_type' => "Действующий тип хостинга",
    '__new_hosting_type' => "Новый тип хостинга",
    '__fwd_settings' => "Настройки перенаправления",
    '__fwd_settings_legend' => "Настройки перенаправления",
    '__fwd_destination_url' => "Конечный URL",
    '__fwd_type' => "Тип перенаправления",
    '__fwd_type_standart' => "Стандартное перенаправление",
    '__fwd_type_standart_hint' => "Перенаправлять посетителей веб-сайта на другой сайт и показывать им целевой адрес, чтобы они знали о перенаправлении.",
    '__fwd_type_frame' => "Перенаправление во фрейме",
    '__fwd_type_frame_hint' => "Перенаправлять посетителей веб-сайта на другой сайт, но не показывать им целевой адрес, чтобы они не знали о перенаправлении.",
    '__hosting_type_template_warning' => "Выбранный вами тип хостинга отличается от типа, указанного в шаблоне. Если вы продолжите, настройки веб-хостинга в выбранном шаблоне будут игнорироваться. Вы уверены, что хотите установить выбранный тип хостинга?",

    '__no_resellers_selected' => "Выберите хотя бы одного реселлера.",

    'ui__client/logo_unknown__wizard-title' => 'Установить логотип',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Пожалуйста, выберите клиента, логотип которого вы хотите изменить.',
    'ui__client/logo_unknown__wizard__2' => 'Нажмите Закончить, чтобы применить изменения.',
    'ui__client/logo_unknown__wizard__2_self' => 'Нажмите Закончить, чтобы применить изменения.',

    'ui__client/ipaddress/properties_new__short-title' => "Добавить IP-адрес",
    'ui__client/ipaddress/properties_new__title' => 'Добавить IP-адрес',
    'ui__client/ipaddress/properties_new__description' => "Добавить IP-адрес.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Добавить IP-адрес",
    'ui__client/ipaddress/properties_unknown-new__title' => "Добавить IP-адрес",
    'ui__client/ipaddress/properties_unknown-new__description' => "Добавить IP-адрес",
    'ui__client/ipaddress/delete_multi__short-title' => "Удалить IP-адрес",
    'ui__client/ipaddress/delete_multi__description' => "Удалить IP-адреса.",
    'ippool_Manager__no_available_ips' => "В пуле нет свободных IP-адресов.",
    'ippool_Manager__ip_shared' => "общий",
    'ippool_Manager__ip_exclusive' => "выделенный",
    'ui__client/ipaddress/properties__title' => "Управление IP-адресами",
    'ui__client/ipaddress/properties__description' => "Посмотреть или изменить свойства IP-адреса.",
    'ui__client/ipaddress_unknown-new__title' => "Добавить IP-адрес",
    'ui__client/ipaddress_unknown-new__short-title' => "Добавить IP-адрес",
    'ui__client/ipaddress_unknown-new__description' => "Добавить IP-адреса.",

    'ui__mass-mail#to_resellers_text__title' => "Реселлеры",
    'ui__mass-mail#to_domainusers_text__title' => "Администраторы доменов",
    'ui__mass-email#tools_legend__title' => "Инструменты",
    'ui__mass-email#list_legend__title' => 'Шаблоны сообщений почтовой рассылки',
    'ui__mass-email#template_legend__title' => "Шаблон",
    'ui__mass-email#from_email_text__title' => "От",
    'ui__mass-email#to_text__title' => 'Кому',
    'ui__mass-email#to_resellers_text__title' => "Реселлеры",
    'ui__mass-email#to_clients_text__title' => "Клиенты",
    'ui__mass-email#to_domainusers_text__title' => "Администраторы доменов",
    'ui__mass-email#to_admin_text__title' => "Администратор Plesk",
    'ui__mass-email#option_mode_all__title' => "Все",
    'ui__mass-email#option_mode_select__title' => "Только выбранные",
    'ui__mass-email#option_mode_except__title' => "Все за исключением выбранных",
    'ui__mass-email#option_select_template__title' => '---Выберите шаблон---',
    'ui__mass-email#subject_text__title' => "Тема",
    'ui__mass-email#body_text__title' => "Текст сообщения",
    'ui__mass-email#save_as_legend__title' => "Сохранить как шаблон",
    'ui__mass-email#save_as_text__title' => "Сохранить составленное сообщение как новый шаблон с именем",
    'ui__reseller/preferences_unknown__wizard-title' => "Изменить настройки учетной записи",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Выберите реселлера, настройки которого вы хотите изменить, и нажмите Далее.",
    'ui__reseller/preferences_unknown__wizard__2' => "Укажите настройки учетной записи и нажмите OK.",
    'ippoolManager__ip_shared' => "общий",
    'ippoolManager__ip_exclusive' => "выделенный",

    '__users_list' => "Пользователи",
    '__users' => "Пользователи",
    '__user_name' => "Имя пользователя",

    'limit__name_max_dom_aliases' => "псевдонимы домена",
    'limit__name_max_subftp_users' => "дополнительные учетные записи FTP",
    'limit__name_max_mssql_db' => "Базы данных Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Пулы приложений IIS",
    'limit__name_max_odbc' => "Соединения ODBC",
    'total_mboxes_quota_unsupported' => 'не поддерживается почтовым сервером',
    'limit_soft__disk_space' => 'Уведомлять при достижении ограничения на дисковое пространство',
    'limit_soft__max_traffic' => 'Уведомлять при достижении ограничения трафика',
    'dsr__of_reseller_title' => "Использование ресурсов доменами",
    'limitsManager__commit_failed' => "Невозможно изменить ограничения по ресурсам.",
    'limitsManager__date_in_past' => "Неверная дата истечения %1.",
    'limitsManager__limit_not_supported' => "Невозможно установить ограничения для типа ресурсов %1.",
    'limitsManager__limit_oversell_inconsistency' => "Невозможно выделить указанные объемы ресурсов при отключенной возможности продажи сверх запасов.",
    'limitsManager__limit_overuse_inconsistency' => "Использование ресурсов превышает установленные ограничения.",
    'limitsManager__no_resource_available' => "Не осталось доступных ресурсов данного типа (%%limitName%%). Запрошено: %%quantity%%; доступно: %%unused%%.",
    'limitsManager__no_total_resource_available' => "У вашего провайдера услуг нет доступных ресурсов данного типа (%%limitName%%). Запрошено: %%quantity%%; доступно: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Дата истечения должна быть меньше или равна %1.",
    'limitsManager__invalid_disk_space_limit' => "Объем дискового пространства должен быть меньше или равен %1.",
    'limitsManager__invalid_max_traffic_limit' => "Объем трафика должен быть меньше или равен %1.",
    'ippoolManager__ip_has_suballocations' => "Невозможно изменить тип IP-адреса, уже выделенного пользователю. IP-адрес %%ip%% уже выделен пользователю(ям) как %%reserved%% IP-адрес.",
    'ippoolManager__ip_is_already_in_pool' => "Данный IP-адрес уже назначен пользователю.",
    'ippoolManager__ip_is_not_in_pool' => "В пуле нет IP-адреса %%ip%%.",
    'ippoolManager__can_not_allocate_ip' => "IP-адрес %%ip%% доступен только как %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "IP-адрес %%ip%% не может быть предоставлен как выделенный.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP-адрес %%ip%% уже используется для хостинга.",
    'ippoolManager__active_anon_ftp_on_ip' => "Анонимный доступ по FTP уже включен для IP-адреса %%ip%%",
    'ippoolManager__no_vacant_ips' => "Нет свободных IP-адресов.",
    'ippoolManager__no_available_ips' => "Нет доступных IP-адресов.",
    'templates__dublicate_name' => "Шаблон с таким именем уже существует. Пожалуйста, выберите другое имя для этого шаблона.",
    'cl_perm__client_limits_exceeded' => "Указанные значения ограничений ресурсов превышают значения, допустимые по условиям вашего хостинга-плана, или предоставляют меньше ресурсов, чем используют ваши сайты в настоящий момент.",
    'cl_perm__reseller_limits_exceeded' => "Указанные значения ограничений ресурсов превышают значения, допустимые для вашего хостинг-плана, или предоставляют меньше ресурсов, чем используется в настоящий момент учетными записями и сайтами пользователей.",

    'site_apps__preferences_show_all_versions_title' => "Показывать полный список версий для каждого приложения, полученного из каталога",
    'site_apps__preferences_show_all_versions_hint' => "Если выбрана эта опция, то операция получения всех версий для всех приложений, выполняемая каждый раз при открытии каталога, может занимать значительное время. Если эта опция не выбрана, то показываются только последние версии.",
    '__select_user_template' => "Создать учетную запись пользователя на базе шаблона",
    'ip_already_added_to_all_clients' => "Данный IP-адрес уже назначен всем пользователям.",
    'ui__server/ip-address/client/delete#legend__description' => "Следующие IP-адреса будут удалены из системы и пулов IP-адресов пользователей:",

    'site_apps__cancelled_apps' => "Вы отменили добавление следующих приложений: %2",

    'sb_url_is_not_resolved' => 'Невозможно распознать URL-адрес: проверьте настройки DNS. URL-адрес %1 должен соответствовать IP-адресу сервера, на котором установлен Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Невозможно удалить IP-адрес %%ip%%, так как это последний IP-адрес, присутствующий в сетевом интерфейсе.',
    'ip_addr__used_for_current_session' => 'Невозможно удалить IP-адрес %%ip%%, так как он используется в активном сеансе.',
    'ip_addr__used_for_hosting' => 'Невозможно удалить IP-адрес %%ip%%, так как он используется для хостинга веб-сайта.',
    'ip_addr__is_main' => 'Невозможно удалить IP-адрес %%ip%%, так как это первичный IP-адрес сетевого интерфейса.',
    'ip_addr__ip_used_by_message_submission' => 'Невозможно удалить IP-адрес %%ip%%, так как он используется для отправки почтовых сообщений',

    // RESELLER ACTION LOG

    '__cl_domains' => 'домены клиентов',
    'excl_ip_num' => 'Выделенный IP-адрес',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder не установлен.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Невозможно запретить пользователю продажу сверх запасов, так как этому пользователю уже было выделено больше ресурсов, чем доступно, и он перешел в режим продажи сверх запасов.',
    'limitsManager__invalid_limit_value' => 'Указано неверное значение %%value%% для ограничения %%limit_name%%',
    'confirmationForm_default_agreement_text' => 'Подтвердить операцию',
    'confirmationForm_default_confirm_message' => 'Пожалуйста, подтвердите операцию.',
    'limit__max_mn' => 'Максимальное количество учетных записей почты',

    'limits__client_overuse_description' => 'Политика перерасхода определяет, что должно происходить в случае превышения использования изначально выделенного объема ресурсов.',
    'limits__client_overuse_block_true_description' => 'Блокировать перерасход ресурсов. Фактическое использование ресурсов не может превышать изначально выделенные объемы ресурсов',
    'limits__client_overuse_block_false_description' => 'Не блокировать перерасход ресурсов, разрешая клиенту использовать больше ресурсов, чем предоставлено изначально. Фактическое использование ресурсов может превышать изначально выделенные объемы ресурсов',
    'limits__client_overuse_notify_text' => 'Уведомлять клиента о достижении ограничения по ресурсам',

    'limits__domain_overuse_description' => 'Политика перерасхода определяет, что должно происходить в случае превышения использования изначально выделенного объема ресурсов.',
    'limits__domain_overuse_block_true_description' => 'Политика перерасхода определяет, что делать в случае перерасхода ресурсов.',
    'limits__domain_overuse_block_false_description' => 'Не блокировать перерасход ресурсов, разрешая домену использовать больше ресурсов, чем предоставлено изначально. Фактическое использование ресурсов может превышать изначально выделенные объемы ресурсов',
    'limits__domain_overuse_notify_text' => 'Уведомлять владельца домена о достижении ограничений по ресурсам',


    'cancel_remove' => 'Отменить все изменения и вернуться на предыдущую страницу.',
    'php_not_installed' => 'PHP не установлен',

    'dns__dns_rr_delete' => 'Элементы, которые будут удалены',
    'dns__delete_rr' => 'Следующие записи DNS будут удалены из зоны DNS:',
    'dns__dns_rr_delete_non_removable' => 'Элементы, которые не могут быть удалены',
    'dns__non_delete_rr' => 'Невозможно удалить следующие записи DNS:',
    'dns__dns_rr_delete_confirm_message' => 'Подтвердить удаление записей DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Веб-приложение неизвестного формата: веб-приложение может быть недоступно для установки и использования.',

    '__php_handler_type_desc' => 'Запускать PHP как',
    'sfdk_domain_sign__failed' => 'При попытке включить на домене подписание почты с помощью DKIM произошла неизвестная ошибка. Более подробную информацию можно найти в журнале ошибок сервера.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Уведомление об успешном обновлении ключа Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Уведомление об отсрочке обновления ключа Plesk',
    'pkey_notify__subj_update_error_notification' => 'Уведомление об ошибке обновления ключа Plesk',
    'pkey_notify__update_successful' => '%1: обновление выполнено успешно.',
    'pkey_notify__update_failed_no_more_try' => 'Невозможно обновить %1. Ключ, который вы пытаетесь отправить, недействителен. Не пробуйте больше его обновить.',
    'pkey_notify__update_failed_try_later' => 'Невозможно обновить %1: при обработке вашего ключа произошла ошибка. Вы можете попытаться получить ключ в Plesk вручную (Инструменты и настройки > Информация о лицензии) или позволить Plesk попытаться обновить его в течение последующих 24 часов. Если вы больше не хотите получать это сообщение, удалите этот ключ из Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Невозможно отключить антиспам на уровне всего сервера.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Невозможно включить антиспам на уровне всего сервера',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Этот реселлер',
    'report_auto__select_reseller_report_all' => 'Все реселлеры',
    'report_auto__select_reseller_report_client' => 'Все реселлеры этого клиента',
    'report_auto__select_reseller_report_current' => 'Этот реселлер',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Все клиенты этого реселлера',
    'report_auto__select_client_report_client' => 'Этот клиент',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'Реселлеры, клиенты и домены',

    'rpt_reseller_section_full_domains' => 'Домены',
    'rpt_reseller_dom_subdomains' => 'Субдомены',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'Почтовые ящики',
    'rpt_reseller_dom_redirects' => 'Перенаправление',
    'rpt_reseller_dom_mail_groups' => 'Почтовые группы',
    'rpt_reseller_dom_mail_resps' => 'Автоответчики',
    'rpt_reseller_dom_mail_antispam' => 'Антиспам',
    'rpt_reseller_dom_mail_antivirus' => 'Антивирус',
    'rpt_reseller_dom_mail_lists' => 'Списки рассылки',
    'rpt_reseller_dom_web_users' => 'Веб-пользователи',
    'rpt_reseller_dom_data_bases' => 'Базы данных MySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Клиенты',
    '__cl_name' => 'Имя клиента',
    '__cl_creation_date' => 'Дата создания',
    '__clients_traffic' => 'Трафик клиента',
    'rpt_reseller_cl_mail_antispam' => 'Антиспам',
    'rpt_reseller_cl_mail_antivirus' => 'Антивирус',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder не установлен.',
    'sitebuilder_disabled' => 'Presence Builder отключен.',
    'b_sitebuilder_disabled' => 'Presence Builder отключен.',
    'webmail_not_installed' => 'Не установлено ни одной программы для работы с электронной почтой через веб-интерфейс.',
    'webmail_disabled' => 'Служба веб-почты выключена.',
    'spamassassin_not_installed' => 'SpamAssassin не установлен.',
    // pfu:
    'anonymous_ftp_shared' => 'Настроить анонимный FTP не удалось: общий IP-адрес.',
    'anonymous_ftp_used' => 'Невозможно настроить анонимный FTP: IP-адрес используется другим доменом для службы анонимного FTP.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET не установлен.',
    'site_builder_no_package' => 'Presence Builder недоступен. Убедитесь, что компонент Presence Builder установлен и активен.',
    'site_builder_not_configured' => 'Presence Builder не настроен.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Инструменты',
    'ui__reseller/client#clientslist__title' => 'Клиенты',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Управление виртуальными папками сайта',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Выберите сайт, чьими папками вы хотите управлять.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Настроить анонимный FTP на домене',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Выберите домен, для которого хотите настроить анонимный FTP.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Управление защищенными паролем папками на домене',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Выберите домен, чьими защищенными паролем папками вы хотите управлять.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Настроить менеджер журналов для домена и просмотреть файлы журналов домена',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Выберите домен, менеджер журналов которого вы хотите настроить, и файлы журналов которого вы хотите просмотреть.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Управление SSL/TLS-сертификатами домена',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Выберите домен, чьими SSL/TLS-сертификатами вы хотите управлять.',

    'ui__client/domain/disable_multi__wizard-title' => 'Приостановить домены',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Выберите домены, которые вы хотите приостановить.',

    'ui__client/domain/enable_multi__wizard-title' => 'Активировать домены',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Выберите домены, которые вы хотите активировать.',

    'ui__client/domain_unknown__wizard-title' => 'Просмотреть домены',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Выберите клиента, домены которого вы хотите посмотреть.',

    'ui__client/domain/register_unknown__wizard-title' => 'Зарегистрировать домены',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Выберите домен, который вы хотите зарегистрировать.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Использовать инструменты из MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Выберите домен, которым вы хотите управлять с помощью инструментов из MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Пользователи IP-адреса',
    'ui__server/ip-address/client_unknown__title' => 'Пользователи IP-адреса',
    'ui__server/ip-address/client_unknown__description' => 'Пользователи IP-адреса %1',

    'disabled_by_admin' => 'Отключено администратором сервера',






    'ui__client/domain/chowner_multi__short-title' => 'Изменить владельца',
    'ui__client/domain/chowner_multi__title' => 'Изменить владельца подписки',
    'ui__client/domain/chowner_multi__description' => 'Изменить владельца подписки.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Выберите домены, для которых нужно изменить владельцев, и нажмите Далее >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Изменить владельца',
    'ui__client/domain/chowner_unknown__title' => 'Изменить владельца подписки',
    'ui__client/domain/chowner_unknown__description' => 'Изменить владельца подписки.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Изменить владельца подписки',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Нет персональных кнопок.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'В интерфейсе реселлера %1 нет персональных кнопок.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Удалить кнопку %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Удалить',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Удалить кнопку %1.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Удалить персональные кнопки из интерфейса реселлера',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Удалить',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Удалить персональные кнопки',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Удалить кнопки',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Выберите реселлеров, персональные кнопки которых вы хотите удалить, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Выберите кнопки, которые следует удалить, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Подтвердите удаление кнопок, поставив флажок на этой странице, и затем нажмите Закончить.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Удалить персональную кнопку из интерфейса реселлера',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Удалить',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Удалить персональную кнопку',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Удалить персональную кнопку',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Выберите реселлера, персональную кнопку которого вы хотите удалить, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Выберите кнопку, которую нужно удалить, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Поставьте флажок на этой странице для подтверждения удаления кнопки и затем нажмите Закончить.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Изменить свойства персональной кнопки %1 на уровне реселлера.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Настройки',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Изменить персональную кнопку реселлера %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Добавить персональную кнопку',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Выберите реселлера, в чьем интерфейсе вы хотите создать персональную кнопку, и нажмите Далее>>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Для создания кнопки нажмите Закончить.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Изменить свойства кнопки в интерфейсе реселлера.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Свойства',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Изменить свойства кнопки в интерфейсе реселлера',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Изменить свойства персональной кнопки',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Выберите реселлера, персональную кнопку которого вы хотите изменить, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Выберите кнопку, которую требуется изменить, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'После завершения редактирования свойств кнопки нажмите Закончить, чтобы применить изменения и выйти из мастера.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Сделать кнопку %1 недоступной для Ваших пользователей.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Сделать недоступной для Ваших пользователей',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Сделать кнопку %1 недоступной для Ваших пользователей',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Сделать кнопку %1 видимой для клиентов реселлера.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Сделать доступной для Ваших пользователей',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Сделать кнопку %1 видимой для клиентов реселлера',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Сделать персональную кнопку доступной/недоступной для Ваших пользователей.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Доступно/недоступно для Ваших пользователей',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Сделать персональную кнопку доступной или недоступной для Ваших пользователей',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Сделать персональную кнопку доступной/недоступной для Ваших пользователей.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Выберите реселлера, персональную кнопку которого вы хотите сделать доступной для его клиентов, и нажмите Далее >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Выберите персональную кнопку, которую следует сделать доступной или недоступной для Ваших пользователей, и нажмите Далее >>.',

    '__not_allowed' => 'Запрещено',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Выбрать нового владельца домена.',

    '__ip_addr_state_unknown' => "IP-адрес сейчас не действующий, так как система все еще обрабатывает ваш зарос. Пожалуйста, подождите.",


    'resellers_list__accounts' => 'Пользователи',

    'ip_addr__repair_is_not_allowed' => 'Невозможно восстановить IP-адрес в среде Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'У реселлера %1 нет ни одного клиента.',

    'ippoolManager__ip_used_by_nohost_domain' => "Удалить IP-адрес %%ip%% невозможно, так как его используют один или несколько доменов без хостинга.",
    'ippoolManager__ip_used_for_mail_service' => "Удалить IP-адрес %%ip%% невозможно, так как один или несколько доменов используют его в качестве IP-адреса почтовой службы.",
    'ippoolManager__ip_used_for_send_emails' => "Удалить IP-адрес %%ip%% невозможно, так как он используется для отправки почты с определенного IP-адреса (смотрите \"Настройки почтового сервера\").",
    'ippoolManager__ip_used_in_dns_zone' => 'Невозможно удалить IP-адрес %%ip%%, так как он используется зоной DNS одного или нескольких доменов.',
    'ip_ctrl__cannot_manage_on_vz' => 'Эта копия Plesk работает под управлением контейнеров Virtuozzo. Добавлять новые IP-адреса может только администратор сервера контейнеров Virtuozzo.',

    'client_template__limits_auto_adjusted' => 'Ограничения из шаблона клиента были автоматически скорректированы.',

    '__entries' => 'Записи',

    '__path_is_not_set' => 'Не указан путь. Пожалуйста, укажите правильный путь.',

    'defaultcomponents__imap_required' => '(Текущий почтовый сервер не поддерживает IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk поддерживает только коммерческие программы для учета статистики по субдоменам. В настоящий момент в системе не установлено ни одной такой программы.',

    'mail__spamassassin_personal_settings_disallowed' => 'Персональная настройка антиспама отключена администратором сервера. Указанные ниже настройки антиспама не будут применены',

    'server_settings_invalid_traffic_statistics' => 'Неверные параметры хранения статистики трафика.',
    'server_settings_invalid_logrotate_period' => 'Неверные параметры срока ротации журналов.',
];