<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'panel-update.context' => 'Plesk Updates',
    'panel-update.whatsNew' => 'What\'s new',

    'panel-update.available.title' => 'Plesk updates are available',
    'panel-update.available.subject' => 'Plesk %%version%% is available',
    'panel-update.available.message' => 'There is an updated version available for installation. Please update your Plesk at your earliest convenience.',
    'panel-update.available.action' => 'Install update',

    'panel-update.successUpgrade.title' => 'A Plesk update has been installed',
    'panel-update.successUpgrade.subject' => 'Plesk %%version%% has been installed',
    'panel-update.successUpgrade.message' => 'Your Plesk has been updated. Learn what’s new in Plesk Obsidian Change Log on our website.',

    'panel-update.successHotfix.title' => 'A Plesk hotfix has been installed.',
    'panel-update.successHotfix.subject' => 'Plesk %%version%% Update %%patch%% has been installed',
    'panel-update.successHotfix.message' => 'Your Plesk has been updated. Learn what’s new in Plesk Obsidian Change Log on our website.',

    'panel-update.error.title' => 'A Plesk update has not been installed.',
    'panel-update.error.subject' => 'A Plesk update has not been installed',
    'panel-update.error.message' => "There is an updated version available for installation. The attempt to install the update has failed. Examine the Plesk installer logs to find out the reason.\n\nPlease update your Plesk at your earliest convenience.",
    'panel-update.error.action' => 'Download Plesk Installer logs',

    'server-health.context' => 'Server health',

    'server-health.parameter-reach-red.title' => 'A parameter monitored by Server Health has reached the "red" alert level',
    'server-health.parameter-reach-red.subject' => 'Server Health: %%parameter%% status "red"',
    'server-health.parameter-reach-red.message' => 'Server health parameter "%%group%% > %%parameter%%" has changed its status from "green" to "red". Check Server Health for more information.',
    'server-health.parameter-reach-red.action' => 'Check Server Health',

    'web-application-firewall.context' => 'Web Application Firewall (ModSecurity)',

    'web-application-firewall.rules-applied.title' => 'A ModSecurity rule or rule set has been installed',
    'web-application-firewall.rules-applied.subject' => 'Web Application Firewall: a new rule or rule set has been installed',
    'web-application-firewall.rules-applied.message' => 'The following rule or rule set has been installed: %%ruleset%%. To make sure that it does not break hosted websites, check the ModSecurity audit log for errors.',
    'web-application-firewall.rules-applied.action' => 'Check audit log',

    'all-websites-switcher-available.subject' => 'Learn how to switch between webspace',
    'all-websites-switcher-available.context' => 'Plesk navigation hint',
    'all-websites-switcher-available.description' => '<h2>Tips</h2><p>Hey, you\'ve created the second webspace.</p><p>Plesk interface has two context of the navigation regarding website(s). In case when UI is in a context of a particular webspace, you will observe website(s) of only this webspace. In case when UI is in "All webspace", you will observe all existing websites.</p><p>The context can be switched implicitly as a result of browsing of the interface, or as a result of performed actions. Sometimes it can happen implicitly for you.</p><p>&#9757; &nbsp;<em>It\'s important - <strong>any time you can change the context</strong> to "All webspaces" or to a particular webspace by using a switcher in the menu at the top right corner.</em></p>',

    'broken-php-handlers-on-domains.subject' => 'Domains with broken PHP handlers found',
    'broken-php-handlers-on-domains.context' => 'Websites',
    'broken-php-handlers-on-domains.description' => 'The following PHP handlers not found on the server are used by %%domainCount%% domain(s): %%handlers%%. PHP code on these domains is not being executed. Install missing PHP handlers or run <code>plesk repair web -php-handlers</code> to fix broken domains.',

    'welcome-to-obsidian.title' => 'A Plesk update has been installed',
    'welcome-to-obsidian.learnMore' => 'Learn more',
    'welcome-to-obsidian.subject' => 'Welcome to Plesk Obsidian!',
    'welcome-to-obsidian.message-intro' => 'Congratulations! The new version of Plesk has been installed. Plesk Obsidian is our most powerful management platform proven on servers, sites, apps, hosting & cloud businesses.',
    'welcome-to-obsidian.message-features-list' => 'With Obsidian you get:',
    'welcome-to-obsidian.message-ux-header' => 'Your User Experience Improved',
    'welcome-to-obsidian.message-ux-body' => 'Obsidian new look and feel is the most professional yet for users, admins and resellers, thus streamlining the Web Project Lifecycle. Comfortably manage websites from one screen with our revised Website Overview. Enjoy better File Manager UX and advanced, personalized HTML notifications, keeping you in control – even when logged off.',
    'welcome-to-obsidian.message-security-header' => 'Tougher Security and Monitoring',
    'welcome-to-obsidian.message-security-body' => 'Obsidian is more robust, hence effective at avoiding outages and revenue loss. ModSecurity & Fail2ban secure by default with 3rd-party extensions available, but now server security is broader with SSL it! and all its capabilities. SNI for Mail Services ensures your conversations stay private on SMTP, IMAP & POP connections.',
    'welcome-to-obsidian.message-productivity-header' => 'Productivity and Value Maximized',
    'welcome-to-obsidian.message-productivity-body' => 'Get a ready-to-code platform and optimized Web stack full of deployment tools you’ll love (Git, Redis, Memcached, Node.js, and Docker). Be SEO-friendly with the permanent HTTP > HTTPS redirect enabled for new sites by default. Avoid hassle because crashed services restart automatically. Try other new features: PHP Composer (PHP Dependency Manager), optimized backups (less disk space needed for backing up and restoration), and the PageSpeed module (precompiled with nginx).',
    'welcome-to-obsidian.message-control-header' => 'More Flexibility and Control',
    'welcome-to-obsidian.message-control-body' => 'All features are more useful and faster out of the box, including the new Monitoring & Grafana extensions. The new Restricted Mode lets you control which server-side operations Plesk admins can perform. Plus, admins, resellers, and users can easily move domains between subscriptions both via Obsidian interface and CLI.',
    'welcome-to-obsidian.message-features-link-title' => 'Read our updates notes.',
    'welcome-to-obsidian.message-facebook-link-title' => 'Facebook Group',
    'welcome-to-obsidian.message-forum-link-title' => 'Community Forum',
    'welcome-to-obsidian.message-conclusion' => 'Join discussion about Plesk Obsidian on our %%facebookLink%% or %%forumLink%%.',
];
