<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Log files",
    'action-log.fromDate' => "From:",
    'action-log.toDate' => "To:",
    'action-log.clearLog' => "Clear Log",
    'action-log.downloadLog' => "Download",
    'action-log.loggedActions' => "Logged actions",
    'action-log.storeLogsInDb' => "Store records in the database",
    'action-log.storeNumber' => "Entries",
    'action-log.dontRemoveRecs' => "Do not remove records",
    'action-log.confirmCleanLog' => "Are you sure you wish to delete the selected action log records?",
    'action-log.incorrectDate' => "Invalid date specified.",
    'action-log.incorrectNumPeriods' => "Invalid rotation period specified.",
    'action-log.incorrectNumRecords' => "Invalid number of records specified.",
    'action-log.yes' => "Yes",
    'action-log.no' => "No",
    'action-log.mixed' => "(mixed)",
    'action-log.period' => "Period",
    'action-log.invalidDatePeriod' => "Invalid date period",
    'action-log.submitDone' => "Changes in the Action log settings were saved.",
    'action-log.clearDone' => "Action log cleared.",
    'action-log.periodDay' => "days",
    'action-log.periodWeek' => "weeks",
    'action-log.periodMonth' => "months",

    'admin-info.adminInfoSection' => 'Information for the administrator',
    'admin-info.description-admin' => 'Administrator\'s description',
    'admin-info.description-reseller' => 'Reseller\'s description',
    'admin-info.description-owner' => 'Owner\'s description',
    'admin-info.description' => 'Description',
    'admin-info.descriptionSuccess' => 'The description was updated.',
    'admin-info.longDescription' => 'The specified description is too long. It cannot be longer than %%max%% symbols.',
    'admin-info.add' => 'Add description',
    'admin-info.edit' => 'Edit',
    'admin-info.remove' => 'Delete',
    'admin-info.confirmOnRemove' => 'Do you want to remove this description?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% of customer %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% of reseller %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% of subscription %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% of %%name%%',
    'admin-info.popupHint-admin' => 'This description is visible only to administrator.',
    'admin-info.popupHint-reseller' => 'This description is visible to reseller and administrator.',
    'admin-info.popupHint-owner' => 'This description is visible to its author and the author\'s hosting provider.',
    'admin-info.customerDescriptionHint' => 'Customers cannot see this description.',
    'admin-info.subscriptionDescriptionHint' => "This information is visible only to the hosting provider (Plesk administrator or reseller).",

    'apache-settings.formGeneralHint' => 'Here you can specify Apache web server settings for this website. Custom Apache configuration is useful, for example, when you want to use a new type of index files on your website or to associate a certain MIME type with certain filename extensions. The Default value means that Apache will use the corresponding directive from its server-wide configuration. If Apache is running with nginx as a frontend server, you can specify the nginx settings on this page as well.',
    'apache-settings.general' => 'Common Apache settings',
    'apache-settings.example' => "For example:\n%%example%%",
    'apache-settings.settingOn' => 'On',
    'apache-settings.settingOff' => 'Off (Default)',
    'apache-settings.settingDefault' => 'Default',
    'apache-settings.settingCustom' => 'Enter custom value',
    'apache-settings.mimeTypes' => 'MIME types',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME types associate file extensions with file types. Typically, this is used to create a custom file extension for common file types.',
    'apache-settings.handlers' => 'Handlers',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache handlers define how the web server processes files with certain extensions when they are requested. For example, the string 'php-script .script' means that Apache will handle .script files as php scripts.",
    'apache-settings.deny' => 'Deny access to the site',
    'apache-settings.allow' => 'Excluding',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nThe specified hosts and networks are prohibited from accessing the site. Use '*' to deny all connections.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nThe specified hosts and networks are allowed to access the site.",
    'apache-settings.directoryIndex' => 'Index files',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache will look for the specified files when the index page of the site is requested.",
    'apache-settings.expires' => 'Expires',
    'apache-settings.expiresStaticOnly' => 'response with Expires headers for static files only',
    'apache-settings.expiresFullDescription' => 'The web server will add the “Expires” response headers to web pages. The expiration timestamp is obtained by adding the amount of time specified above to the time at which a web page is requested.',
    'apache-settings.expiresStaticOnlyDescription' => 'The "Expires" header will only be added to static files. Which files are treated as static is governed by the "Smart static files processing" and "Serve static files directly by nginx" options.',
    'apache-settings.expiresUnitDays' => 'days',
    'apache-settings.expiresUnitHours' => 'hours',
    'apache-settings.expiresUnitMinutes' => 'minutes',
    'apache-settings.expiresUnitSeconds' => 'seconds',
    'apache-settings.headers' => 'Additional headers',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Web server will add the specified HTTP response headers.",
    'apache-settings.restrictFollowSymLinks' => 'Restrict the ability to follow symbolic links',
    'apache-settings.restrictFollowSymLinksDescription' => "Select this option to prohibit users from using the FollowSymLink directive in .htaccess and improve the server security.",
    'apache-settings.nginx' => 'nginx settings',
    'apache-settings.nginxProxyMode' => 'Proxy mode',
    'apache-settings.nginxProxyModeDescription' => 'Nginx proxies requests to Apache. Turn off to stop using Apache.',
    'apache-settings.nginxTransparentMode' => 'Smart static files processing',
    'apache-settings.nginxTransparentModeDescription' => 'If turned off, Apache will process all requests for static files. nginx will only pass requests and responses without modification. Turn off this option only for troubleshooting.',
    'apache-settings.nginxServeStatic' => 'Serve static files directly by nginx',
    'apache-settings.nginxStaticExtensions' => 'Specify file extensions separated by spaces or by the "|" symbol. Requests for these files will be handled by nginx and never reach Apache. Caution: Apache rewrite rules will not be applied.',
    'apache-settings.nginxServePhp' => 'Process PHP by nginx',
    'apache-settings.nginxServePhpDescription' => 'PHP files (.php) will be handled by nginx and PHP-FPM. If turned off, PHP files will be processed by Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Maximum allowed HTTP request body size',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Requests with body above the limit will be discarded with HTTP 413 Payload Too Large (configures the "client_max_body_size" nginx directive value).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Option is disabled globally via an empty/zero value of the directive "clientMaxBodySize" in panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Enable nginx caching',
    'apache-settings.nginxCacheEnabledDescription' => 'Caching may reduce website response time and server load, but should be used with care.',
    'apache-settings.nginxCacheSize' => 'Cache size',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Cache timeout',
    'apache-settings.nginxCacheTimeoutDays' => 'days',
    'apache-settings.nginxCacheTimeoutHours' => 'hours',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minutes',
    'apache-settings.nginxCacheTimeoutSeconds' => 'seconds',
    'apache-settings.nginxCacheKey' => 'Cache key',
    'apache-settings.nginxCacheCookies' => 'Cache requests with cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Disable caching for locations',
    'apache-settings.nginxCacheBypass' => 'Bypass cache when',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'HTTP no-cache headers are received in request',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'HTTP authorization headers are received in request',
    'apache-settings.nginxCacheBypassGetNocache' => 'GET nocache parameter is received in request',
    'apache-settings.nginxCacheUseStale' => 'Return stale cached records',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream returns 5xx server error',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream returns 4xx client error',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Cache is being updated',
    'apache-settings.additional' => 'Additional Apache directives',
    'apache-settings.additionalSettingsDescription' => 'If you cannot find particular settings, add them to the fields below. These settings will override the server-wide Apache directives. The directives from the first field are used when a visitor accesses the site over HTTP. The second field contains the directives for HTTPS. Generally, you should add your directives to both fields. Use the same syntax as you use for httpd.include. For example, if you want to set a custom error page, add the line: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Additional directives for HTTP',
    'apache-settings.additionalSslSettings' => 'Additional directives for HTTPS',
    'apache-settings.additionalSettingsError' => 'Invalid Apache configuration: %%error%%',
    'apache-settings.rollbackFailed' => 'Unable to use the current Apache configuration file and to rollback to the previous version of the file because they contain invalid configuration.',
    'apache-settings.additionalNginx' => 'Additional nginx directives',
    'apache-settings.additionalNginxSettingsDescription' => 'Here you can specify the settings for the nginx reverse proxy server that runs in front of Apache. Your directives will override the server-wide nginx configuration. For example, you may want to change the connection timeout or to pack requests with gzip. Use the same syntax as you use for nginx.conf. For example, if you want to pack all the proxied requests with gzip, add the line: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Additional nginx directives',
    'apache-settings.additionalNginxSettingsError' => 'Invalid nginx configuration: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Unable to use the current nginx configuration file and to rollback to the previous version of the file because they both contain invalid configuration.',
    'apache-settings.clearCache' => 'Clear cache',
    'apache-settings.clearCacheHint' => 'Clear nginx cache for %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Cache has cleared successfuly',

    'backup.backup-password-protection.securitySettingsSection' => 'Backup security settings',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Get password from Remote storage settings',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Input password manually',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Provide password',
    'backup.backup-password-protection.backupPassword' => 'Password',
    'backup.backup-password-protection.inputPasswordType' => 'Password type',
    'backup.backup-password-protection.confirmBackupPassword' => 'Repeat password',
    'backup.backup-password-protection.backupPasswordHint' => ' If you have forgotten your password, clear this option. Note that in this case, some sensitive data will not be restored properly. For example, user passwords will be replaced with random ones, the information about already installed APS apps will be lost, and so on.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'If you used password protection for this backup, enter the password into the fields below. Note that if you provide an incorrect password, Plesk will not restore the backup. Instead, the backup will be copied to the local storage.',

    'backup.conflict-database.dbMappingLegend' => 'Database server mapping',
    'backup.conflict-database.serverType' => 'Server type',
    'backup.conflict-database.hostName' => 'Host name',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Destination database server',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'The database cannot be restored: There is no appropriate database server.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Upload IP Mapping File',
    'backup.conflict-ip.ipMappingLegend' => 'IP mapping',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Save Current IP Mapping to File',
    'backup.conflict-ip.ipAddressNotFound' => 'There are no free IP addresses of this type.',
    'backup.conflict-ip.sharedIp' => 'shared',
    'backup.conflict-ip.dedicatedIp' => 'dedicated',
    'backup.conflict-ip.fileNotFound' => 'The file must not be empty.',
    'backup.conflict-ip.invalidIpToMap' => 'An invalid value for an old IP address: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'An invalid value for a new IP address: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'The IP address %%ip%% is not found in the database.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Upload an IP mapping file',
    'backup.conflict-ip.ipMappingFileHint' => 'An IP mapping file is a plain text file. Each line of this file contains IP mapping in the format: <old IP address> <new IP address>',
    'backup.conflict-ip.oldIp' => 'Old IP addresses',
    'backup.conflict-ip.newIp' => 'New IP addresses',

    'backup.copy-to-server.ignoreBackupSign' => 'Upload backup files without a valid signature',
    'backup.copy-to-server.wrongPassword' => 'The specified password is incorrect. During the backup restoration, Plesk will prompt you to enter the password again.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'The uploaded backup file %%fileName%% was modified, corrupted, created on another server or in an older Plesk version that does not support signing of backups. Before restoring data from this backup file, make sure you can trust the source of this file.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Unable to upload the backup file %%fileName%%. The file either contains modified or corrupted data, or it was created on another server or in an older Plesk version. To restore data from this file, contact your hosting provider.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Unable to upload the backup file %%fileName%%. The file was modified, corrupted, created on another server or in an older Plesk version that does not support signing of backups. If you trust this backup, select the "Upload backup files without valid signatures" option and repeat uploading.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Unable to move the selected backup %%fileName%% to server storage. Error: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "The following parts of the incremental backup were not copied:%%endl%%%%missedParts%%%%endl%%Please copy the missing parts.",

    'backup.ftp-settings.isActive' => 'Use FTP(S) storage',
    'backup.ftp-settings.host' => 'FTP server hostname or IP',
    'backup.ftp-settings.directory' => 'Directory for backup files storage',
    'backup.ftp-settings.directoryHint' => 'For example, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP username',
    'backup.ftp-settings.ftpPassword' => 'FTP password',
    'backup.ftp-settings.usePassiveMode' => 'Use passive mode',
    'backup.ftp-settings.useFtps' => 'Use FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Using the local Plesk\'s FTP server as a remote storage is prohibited. Please specify a remote location.',
    'backup.ftp-settings.warningHostIsLocal' => 'FTP(S) storage settings were configured to store backups on the server where your subscriptions\' files are located. Such a configuration is not recommended due to the risk of data loss and disk space overuse.',
    'backup.ftp-settings.enterFtpLogin' => 'Enter a correct username.',
    'backup.ftp-settings.enterFtpPassword' => 'Enter a correct password.',

    'backup.remote-settings.isActive' => 'Use the storage',
    'backup.remote-settings.initError' => 'Unable to initialize %%extName%% settings page: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Backup security settings',

    'backup.restore.detailsSection' => 'Details',
    'backup.restore.contentInfoSection' => 'Backup content',
    'backup.restore.restorationOptionsSection' => 'Restoration options',
    'backup.restore.emailNotification' => 'When the restoration is completed, send a notification to',
    'backup.restore.comments' => 'Comments',
    'backup.restore.creationDate' => 'Creation date',
    'backup.restore.systemNotes' => 'System notes',
    'backup.restore.ownerAdmin' => 'Created by the administrator.',
    'backup.restore.ownerReseller' => 'Created by a reseller.',
    'backup.restore.ownerCustomer' => 'Created by a customer.',
    'backup.restore.ownerServiceUser' => 'Created by an additional user.',
    'backup.restore.partOfParentBackup' => 'Part of %%type%% backup.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'reseller',
    'backup.restore.client' => 'customer',
    'backup.restore.incremental' => 'Incremental.',
    'backup.restore.multiVolume' => 'Multi-volume.',
    'backup.restore.backupSize' => 'Backup size',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (this addition) + %%base%% (initial backup) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (this addition) + %%prev%% (previous additions) + %%base%% (initial backup) = %%total%%',
    'backup.restore.download' => 'Download',
    'backup.restore.downloadHint' => 'Download the backup file to your local computer.',
    'backup.restore.downloadDisabled' => 'Downloading of backup files is temporarily unavailable. Please try again later or contact your service provider.',
    'backup.restore.copy' => 'Copy to Server Storage',
    'backup.restore.copyHint' => 'Copy the selected backup files to the server storage.',
    'backup.restore.contentInfo' => 'Backup contains',
    'backup.restore.restoreButton' => 'Restore',
    'backup.restore.mail' => 'Mail',
    'backup.restore.domainConfiguration' => 'Domain configuration',
    'backup.restore.virtualHost' => 'Virtual host content',
    'backup.restore.database' => 'Databases',
    'backup.restore.serverConfiguration' => 'Server settings',
    'backup.restore.serverConfigurationLicense' => 'License key',
    'backup.restore.serverPersonalConfiguration' => 'Administrator account configuration',
    'backup.restore.serverPersonalDomains' => 'Administrator\'s domains',
    'backup.restore.serverPersonalClients' => 'Administrator\'s customers',
    'backup.restore.resellers' => 'Resellers',
    'backup.restore.resellerPersonalConfiguration' => 'Reseller account configuration',
    'backup.restore.resellerPersonalDomains' => 'Reseller\'s domains',
    'backup.restore.resellerPersonalClients' => 'Reseller\'s customers',
    'backup.restore.clientPersonalConfiguration' => 'Customer account configuration',
    'backup.restore.clientPersonalDomains' => 'Customer\'s domains',
    'backup.restore.restoreModifiedSection' => 'Restore the backup file despite a corrupted signature',
    'backup.restore.restoreModifiedDump' => 'Restore this backup despite the fact that it does not have a valid signature',
    'backup.restore.resolutionPolicy' => 'Resolution policy',
    'backup.restore.resolutionPolicyDescription' => 'Timing conflicts occur either when the restored object already exists in the system with more recent modification date, or when the restored object is not currently present in the system.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'The specified password is incorrect. The backup file will be copied to the server\'s local storage.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Unable to restore the backup. The specified password is incorrect.',
    'backup.restore.serverContentAndConfiguration' => 'Server configuration and content',
    'backup.restore.serverConfigurationOnly' => 'Server configuration',
    'backup.restore.resellerContentAndConfiguration' => 'Reseller account configuration and content',
    'backup.restore.resellerConfigurationOnly' => 'Reseller account configuration',
    'backup.restore.clientContentAndConfiguration' => 'Customer account configuration and content',
    'backup.restore.clientConfigurationOnly' => 'Customer account configuration',
    'backup.restore.domainContentAndConfiguration' => 'Domain configuration and content',
    'backup.restore.domainConfigurationOnly' => 'Domain configuration',
    'backup.restore.restoreType' => 'What do you want to restore?',
    'backup.restore.restoreTypeFull' => 'All objects (entire system)',
    'backup.restore.restoreTypeGranular' => 'Selected objects',
    'backup.restore.restoreObjectType' => 'Type of object to restore',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Subscription',
    'backup.restore.restoreObjectTypeCustomers' => 'Customer',
    'backup.restore.restoreObjectTypeResellers' => 'Reseller',
    'backup.restore.restoreObjectTypeMailUsers' => 'Mail account',
    'backup.restore.restoreObjectTypeDatabases' => 'Database',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS certificates',
    'backup.restore.restoreObjectTypeSites' => 'Sites',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS zone',
    'backup.restore.restoreObjectTypeMailLists' => 'Mailing lists',
    'backup.restore.restoreObjectTypeWebContent' => 'Files of domains',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Selected files',
    'backup.restore.restoreSubscriptionLookup' => 'Subscription',
    'backup.restore.restoreComponents' => 'Components to restore',
    'backup.restore.errorLog' => 'Error log',
    'backup.restore.backupDetailsLogDoesntExist' => 'The backup log is not available.',
    'backup.restore.dumpFailedSection' => 'Error log',
    'backup.restore.dumpFailed' => 'Unable to restore data: The backup file is invalid.',
    'backup.restore.granularNotSupported' => 'You can select objects to restore only when you are restoring from backups that were created in Plesk 12.0 or later.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Restoration of all data from backups is not supported in the reseller Power User view. Select the objects for restoring. You can change your interface view in %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Interface Preferences',
    'backup.restore.contentRestoreType' => 'Restore',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Only configuration of the selected objects',
    'backup.restore.contentRestoreTypeFull' => 'Configuration and contents of the selected objects',
    'backup.restore.errorWrongFormat' => 'Unable to restore the backup: the file contains wrong formatting.',
    'backup.restore.errorContentError' => 'Not all the data may be restored: the backup contains content errors.',
    'backup.restore.warningSignError' => 'Unable to validate the backup signature. The backup file might be modified, corrupted, created on another server or in an earlier Plesk version.',
    'backup.restore.warningSignErrorNotAdmin' => 'This backup can be restored by the Plesk administrator only.',
    'backup.restore.warningPartial' => "The following parts of the incremental backup were not found:%%endl%%%%missedParts%%%%endl%%Not all the files might be restored. Upload the missing parts and try restoring again.",
    'backup.restore.warningDeprecatedBackupVersion' => 'The backup you are trying to restore was created in an unsupported Plesk version and cannot be restored. Use the Plesk Migrator extension to transfer your data from old Plesk versions.',
    'backup.restore.encryptionKeyError' => 'Passwords for one or more accounts in this backup cannot be restored and will be reset. Probably this backup was created on a different Plesk server and encrypted with its encryption key.',
    'backup.restore.errorCorruptedContent' => 'The following files were not found or were corrupted: ',
    'backup.restore.statusSection' => 'Backup status',
    'backup.restore.statusDetails' => 'Status details',
    'backup.restore.restoreBlocked' => 'The backup cannot be restored.',
    'backup.restore.restoreBlockedDescription' => 'The backup of the type %%backupType%% cannot be restored now. To restore it, log in as the backup owner and click this backup name in Backup Manager.',

    'backup.schedule.scheduleSection' => 'Schedule',
    'backup.schedule.backupEnable' => 'Activate this backup task',
    'backup.schedule.backupPeriod' => 'Run this backup task',
    'backup.schedule.on' => 'on',
    'backup.schedule.at' => 'at',
    'backup.schedule.useIncremental' => 'Use incremental backup',
    'backup.schedule.fullBackupPeriod' => 'Perform full backup',
    'backup.schedule.daily' => 'Daily',
    'backup.schedule.weekly' => 'Weekly',
    'backup.schedule.monthly' => 'Monthly',
    'backup.schedule.yearly' => 'Yearly',
    'backup.schedule.days' => 'days',
    'backup.schedule.weeks' => 'weeks',
    'backup.schedule.months' => 'months',
    'backup.schedule.years' => 'years',
    'backup.schedule.backupTimeDescription' => 'Timezone: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Default system time zone',
    'backup.schedule.first' => 'first',
    'backup.schedule.last' => 'last',
    'backup.schedule.dayOfMonth' => 'day',
    'backup.schedule.email' => 'If errors occur during the execution of this backup task, send a notification email to',
    'backup.schedule.invalidFields' => 'Some fields are empty or contain an invalid value: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maximum number of full backup files to store (including both scheduled and manual backups)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Leave this field empty if you do not want to remove full backups automatically.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'The limit specified by the hosting provider for the server storage is %%max%%. Your limit for it must be lower or equal to %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Storing scheduled subscription backups in a remote cloud storage is a premium feature you can purchase from the Plesk Online Store.',

    'backup.secure-backup.hint' => 'You can use a password to encrypt users\' passwords contained in the Plesk database in a backup. Note that restoring a password-protected backup without providing the password will make Plesk generate the users\' passwords randomly.',
    'backup.secure-backup.hintAdmin' => 'You can encrypt Plesk database passwords contained in backups with the Plesk encryption key or with a password. The key is unique for each Plesk installation. Backups encrypted with the key can be restored only in the Plesk installation where they were created and cannot be restored in another Plesk installation. Note that Plesk does not protect all sensitive data in a backup. We recommend you store backups in remote cloud storage and enable backup encryption on the cloud storage side.',
    'backup.secure-backup.usePasswordProtection' => 'Use password protection (recommended)',
    'backup.secure-backup.backupPasswordSource' => 'Password type',
    'backup.secure-backup.pleskKey' => 'Plesk\'s encryption key',
    'backup.secure-backup.userPassword' => 'Specified password',
    'backup.secure-backup.password' => 'Password',
    'backup.secure-backup.passwordConfirmation' => 'Repeat password',

    'backup.subform.settingsSection' => 'Backup settings',
    'backup.subform.prefix' => 'Add a prefix to the backup name',
    'backup.subform.comment' => 'Comments',
    'backup.subform.splitSize' => 'Create a multivolume backup, volume size (MB)',
    'backup.subform.repository' => 'Store in',
    'backup.subform.repositoryDescription' => 'FTP(S) storage settings are not specified. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Both server storage and  %%name%%',
    'backup.subform.remoteRepository' => 'remote storage',
    'backup.subform.remoteRepositoryText' => 'Select remote cloud storage',
    'backup.subform.configureRemoteRepositories' => 'You can <a href="%%url%%">configure remote storages</a> to keep your backups in the cloud',
    'backup.subform.configureFtpRepository' => 'You can <a href="%%url%%">configure FTP storage</a> to keep your backups there',
    'backup.subform.repositoryConfigure' => 'Configure',
    'backup.subform.email' => 'When a backup task is completed, send a notification email to',
    'backup.subform.contentSection' => 'Backup content',
    'backup.subform.domainConfiguration' => 'Configuration',
    'backup.subform.domainConfigurationVhost' => 'User files and databases',
    'backup.subform.domainConfigurationMail' => 'Mail messages',
    'backup.subform.content' => 'Back up',
    'backup.subform.backupAll' => 'All configuration and content',
    'backup.subform.backupConfiguration' => 'Only configuration',
    'backup.subform.backupVhost' => 'All configuration and content except mail messages',
    'backup.subform.backupMail' => 'Only configuration and mail messages',
    'backup.subform.mssqlNativeBackup' => 'Use native MS SQL backup functionality if possible',
    'backup.subform.mssqlNativeBackupAdmin' => 'Use native MS SQL backup functionality (For remote databases, make sure you configured the backup settings of the remote MS SQL server in Tools & Settings > Database Servers)',
    'backup.subform.localRepository' => 'Server storage',
    'backup.subform.localRepositoryPath' => 'Server storage in %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP(S) storage at %%uri%% <a href="%%link%%">Change Settings</a>',
    'backup.subform.ftpRepositoryText' => 'FTP(S) storage at %%uri%%',
    'backup.subform.type' => 'Type',
    'backup.subform.typeFullBackup' => 'Full',
    'backup.subform.typeIncremental' => 'Incremental',
    'backup.subform.typeIncrementalDescription' => 'Back up web and mail hosting data that has changed since the last backup (databases are always backed up in full).',
    'backup.subform.incrementalNotAvailable' => 'To create incremental backups, first create a full backup.',
    'backup.subform.excludeLogs' => 'Exclude log files',
    'backup.subform.excludeFiles' => 'Exclude specific files from the backup',
    'backup.subform.excludeFilesDescription' => 'You can only exclude files within webspaces. Specify the path or paths relative to the webspace root, separating individual files with commas. Using the mask symbol is allowed (e.g. /somedir/log*).',

    'backup.upload.uploadHint' => 'Here you can upload backup files to the Plesk storage. The maximum file size is limited to two gigabytes.',
    'backup.upload.backupFile' => 'Backup file',
    'backup.upload.removeLink' => 'Remove',
    'backup.upload.addFileLink' => 'Upload More Files',
    'backup.upload.backupSecuritySettings' => 'Backup security settings',
    'backup.upload.signatureHint' => 'Plesk checks backup files for a valid structure and signature. Files that were modified, corrupted, or created on another server are distrusted. The option below enables you to restore data from such files. Select this option only if you trust the backup source because uploading such a file may compromise security or disrupt the operation of the server. Note: Backup files made in the Plesk versions prior to 11.5 are considered as distrusted because they lack signatures. Be sure to restore such files if you trust their source.',
    'backup.upload.ignoreSign' => 'Upload backup files without a valid signature',
    'backup.upload.passwordHint' => 'If you used password protection for this backup, enter the password into the fields below. Note that if you provide an incorrect password, Plesk will warn you but will upload the backup to the server anyway. During the backup restoration, you will be prompted to enter the password again.',
    'backup.upload.alreadyExistsWarning' => 'The backup file %%fileName%% already exists in the server\'s local storage.',
    'backup.upload.incorrectPasswordWarning' => 'The specified password is incorrect. During the backup restoration, Plesk will prompt you to enter the password again.',
    'backup.upload.deprecatedDumpError' => 'The backup you are trying to upload was created in a unsupported Plesk version and cannot be imported. Use the Plesk Migrator extension to transfer your data from old Plesk versions.',
    'backup.upload.mailFormatWarning' => 'The backup file %%fileName%% was uploaded to the storage. Important: The backup file %%fileName%% contains mail content that will not be restored because its format (Plesk 8.3 - 8.6) is not supported. To be able to restore this mail content, back it up using the Plesk Backup tool, select the option Back up mailboxes content, and select the option with dump restored to any mail server.',
    'backup.upload.corruptedSignatureAdminWarning' => 'The uploaded backup file (%%fileName%%) was modified, corrupted, created on another server or in an older Plesk version that does not support signing of backups. Before restoring data from this backup file, make sure you can trust the source of this file.',
    'backup.upload.corruptedSignatureAdminError' => 'Unable to upload the backup file (%%fileName%%). The file was modified, corrupted, created on another server or in an older Plesk version that does not support signing of backups. If you trust this backup, then select the "Upload backup files without valid signatures" option and repeat uploading.',
    'backup.upload.corruptedSignatureUserWarning' => 'The uploaded backup file (%%fileName%%) either contains modified or corrupted data, or it was created on another server or in an older Plesk version.',
    'backup.upload.corruptedSignatureUserError' => 'Unable to upload the backup file (%%fileName%%). The file either contains modified or corrupted data, or it was created on another server or in an older Plesk version. To restore data from this file, contact your hosting provider.',
    'backup.upload.uploadError' => 'Unable to upload %%fileName%% to the server storage: %%error%%',
    'backup.upload.fileNotSelected' => 'No files were selected to upload. Select at least one file.',
    'backup.upload.missedPartsWarning' => "The following parts of the incremental backup were not uploaded:%%endl%%%%missedParts%%%%endl%%Please upload the missing parts.",
    'backup.upload.unknownType' => 'Unknown object type',
    'backup.upload.storageLink' => 'another storage',
    'backup.upload.anotherStorage' => 'The dump was uploaded to %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'The reseller %%name%% not found. Create it first to restore the uploaded dump.',
    'backup.upload.clientNotFound' => 'The customer %%name%% not found. Create it first to restore the uploaded dump.',
    'backup.upload.domainNotFound' => 'The domain %%name%% not found. Create it first to restore the uploaded dump.',

    'backup.web-content-dynamic.addButtonTitle' => 'Add Files',
    'backup.web-content-dynamic.noItems' => 'No files selected',
    'backup.web-content-dynamic.hint' => 'Use checkboxes to select files and folders.',
    'backup.web-content-dynamic.title' => 'Select Files',
    'backup.web-content-dynamic.columnName' => 'Name',
    'backup.web-content-dynamic.columnChangeDate' => 'Modified',
    'backup.web-content-dynamic.columnSize' => 'Size',
    'backup.web-content-dynamic.columnPermissions' => 'Permissions',
    'backup.web-content-dynamic.columnUser' => 'User',
    'backup.web-content-dynamic.columnGroup' => 'Group',
    'backup.web-content-dynamic.waitButtonTitle' => 'Please wait',
    'backup.web-content-dynamic.loadingTitle' => 'Please wait. Loading...',

    'backup.invalidFields' => 'Some fields are empty or contain an invalid value.',
    'backup.notEnoughDiskSpace' => 'There is not enough disk space at %%path%% to backup creation. At least %%required%% GB free space is required (%%available%% GB is available)',

    'change-subscriptions-owner.infoTitle' => 'Info',
    'change-subscriptions-owner.infoDescription' => '%%total%% subscriptions, %%active%% active subscriptions, %%diskSpace%% disk space used, %%traffic%% traffic used',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Possible new owners of subscriptions',
    'change-subscriptions-owner.selectedSubscriptions' => 'Selected subscriptions',
    'change-subscriptions-owner.subscriptionName' => 'Subscription name',
    'change-subscriptions-owner.ownerName' => 'Owner\'s name',
    'change-subscriptions-owner.currentIpAddress' => 'Current IP address',
    'change-subscriptions-owner.newIpAddress' => 'New IP address',
    'change-subscriptions-owner.submit' => 'Reassign',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, Disk I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Set up limits on system resources consumption by a subscription. Plesk uses a Linux kernel feature called control groups (cgroups) to ensure that the limits are not exceeded.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Limit individual subscriptions to the specified amount of CPU usage.',
    'cgroups-settings.cpuPeriodLimit' => 'Period to check CPU usage',
    'cgroups-settings.percentUsageDescription' => 'The total amount of CPU time equals %%total%%%%units%% for your server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limit individual subscriptions to the specified amount of RAM usage. Note that if a subscription exceeds this limit, the process consuming the most will be stopped.',
    'cgroups-settings.ramPeriodLimit' => 'Period to check RAM usage',
    'cgroups-settings.diskSettings' => 'Disk I/O',
    'cgroups-settings.diskReadSettings' => 'Disk Read',
    'cgroups-settings.diskReadSettingsDescription' => 'Allow individual subscriptions to use disk read bandwidth only within the specified limit.',
    'cgroups-settings.diskReadPeriodLimit' => 'Period to check Disk Read usage',
    'cgroups-settings.diskWriteSettings' => 'Disk Write',
    'cgroups-settings.diskWriteSettingsDescription' => 'Allow individual subscriptions to use disk write bandwidth only within the specified limit.',
    'cgroups-settings.diskWritePeriodLimit' => 'Period to check Disk Write usage',
    'cgroups-settings.limit' => 'Limit',
    'cgroups-settings.threshold' => 'Notify when exceeded',
    'cgroups-settings.limitNotificationEnabled' => 'Notification enabled',
    'cgroups-settings.periodFiveMinutes' => '5 minutes',
    'cgroups-settings.periodHour' => '1 hour',
    'cgroups-settings.periodDay' => '1 day (24 hours)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sec',

    'custom-button.privateLabel' => 'Show to me only',
    'custom-button.textLabel' => 'Button label',
    'custom-button.tooltipLabel' => 'Tooltip text',
    'custom-button.iconLabel' => 'Background image',
    'custom-button.priorityLabel' => 'Priority',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Add parameters to URL',
    'custom-button.placeLabel' => 'Location',
    'custom-button.internalLabel' => 'Open URL in Plesk',
    'custom-button.internalDescription' => 'Specify whether to open the URL on a Plesk page or in a new browser window.',
    'custom-button.noFrameLabel' => 'Do not use frames',
    'custom-button.noFrameDescription' => 'If you add a custom button which leads to a Plesk extension or an app in the Customer Panel, you can specify how this extension/app should be displayed: in a frame or as a part of the Plesk GUI.',
    'custom-button.urlParamLabel_dom_id' => 'Include subscription ID, domain ID and domain alias ID',
    'custom-button.urlParamLabel_dom_name' => 'Include Primary Domain name',
    'custom-button.urlParamLabel_ftp_user' => 'Include FTP username',
    'custom-button.urlParamLabel_ftp_pass' => 'Include FTP password',
    'custom-button.urlParamLabel_cl_id' => 'Include customer ID',
    'custom-button.urlParamLabel_cname' => 'Include customer\'s company name',
    'custom-button.urlParamLabel_pname' => 'Include customer\'s contact name',
    'custom-button.urlParamLabel_email' => 'Include customer\'s email',
    'custom-button.buttonPlace_navigation' => 'Common Access',
    'custom-button.buttonPlace_admin' => 'Administrator\'s Home page',
    'custom-button.buttonPlace_admin-settings' => 'Administrator\'s Tools & Settings page',
    'custom-button.buttonPlace_reseller' => "Reseller's Home page",
    'custom-button.buttonPlace_reseller-settings' => 'Reseller\'s Tools & Utilities page',
    'custom-button.buttonPlace_client' => 'Customer\'s Home page',
    'custom-button.buttonPlace_domain' => "Websites & Domains page of Subscription",
    'custom-button.buttonPlace_domain_powerUser' => "Websites & Domains page of Webspace",
    'custom-button.buttonPlace_domain-properties' => 'Website Tools',

    'database-server-change-password.adminPassword' => 'Administrator\'s password',
    'database-server-change-password.success' => 'Administrator\'s password was successfully updated.',

    'database-server-create.general' => 'General',
    'database-server-create.type' => 'Database server type',
    'database-server-create.unixSocket' => '(local connection)',
    'database-server-create.host' => 'Host name or IP address',
    'database-server-create.port' => 'Port number',
    'database-server-create.portDescription' => 'Leave blank for the default port number',
    'database-server-create.version' => 'Database server version',
    'database-server-create.default' => 'Use this server as default for %%type%%',
    'database-server-create.externalConnections' => 'Allow local MySQL server to accept external connections',
    'database-server-create.externalConnectionsDescription' => 'Changing this setting will result in the Local MySQL server being restarted. To enable remote access to other MySQL servers registered in Plesk, change their configuration manually.',
    'database-server-create.authentication' => 'Authentication',
    'database-server-create.authenticationAddDescription' => 'Specify the database administrator\'s credentials that Plesk will use to access the database server. An administrator account with these credentials must be present on the database server.',
    'database-server-create.authenticationEditDescription' => 'Here you can change the credentials that Plesk uses to access the database server. These credentials must match the database administrator\'s credentials. For example, after you have changed the administrator\'s credentials on the database server, you need to change them in Plesk as well.',
    'database-server-create.authenticationChangeDescription' => 'Here you can change the credentials that Plesk uses to access the database server. If you change the username or password below, the database user account with administrative rights will be updated both on the database server and in Plesk.',
    'database-server-create.adminLogin' => 'Username',
    'database-server-create.adminPassword' => 'Password',
    'database-server-create.createSuccess' => 'Database server was successfully created.',
    'database-server-create.createError' => 'Database server was created with error: %%error%%',
    'database-server-create.updateSuccess' => 'Database server was successfully updated.',
    'database-server-create.updateError' => 'Database server was updated with error: %%error%%.',
    'database-server-create.backupSettings' => 'Backup',
    'database-server-create.backupTempDir' => 'Temporary directory',
    'database-server-create.backupTempDirDescription' => 'The path to a physical folder on the remote server where the MS SQL server is located. The MS SQL server must be able to access this folder for reading and writing temporary backup files. For example, C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Temporary network directory',
    'database-server-create.backupNetworkTempDirDescription' => 'The path to the network share mapped to the physical folder specified above. Plesk will access the shared folder to download and upload backup files. For example, \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Username',
    'database-server-create.backupNetworkUserDescription' => 'The username of a network user created on the remote server. For example, ServerName\UserName. The user must have access to the shared folder specified above.',
    'database-server-create.backupNetworkPassword' => 'Password',

    'domain.connection-info.title' => 'Connection info',
    'domain.connection-info.systemUserCredentials' => 'System user credentials',
    'domain.connection-info.systemUserCredentialsHint' => 'Access via FTP is always enabled, access via SSH or Remote Desktop — only if the %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'permission is granted',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Your SSH or Remote Desktop access is enabled and you cannot manage its state.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Your SSH or Remote Desktop access is disabled and you cannot manage its state.',
    'domain.connection-info.ipAddress' => 'IP address',
    'domain.connection-info.copyToClipboard' => 'Copy to clipboard',
    'domain.connection-info.username' => 'Username',
    'domain.connection-info.password' => 'Password',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'System user password change',
    'domain.connection-info.changePasswordTooltip' => 'Change password',
    'domain.connection-info.newPassword' => 'New password',
    'domain.connection-info.manageAccess' => 'Manage access',
    'domain.connection-info.additionalFtpAccounts' => 'Additional FTP accounts',
    'domain.connection-info.database' => 'Database',
    'domain.connection-info.databaseHint' => '1 of %%number%% databases belonging to the subscription.',
    'domain.connection-info.databaseNotCreatedHint' => 'Database is not created.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL Server',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Database name',
    'domain.connection-info.addDatabase' => 'Add database',
    'domain.connection-info.manageDatabases' => 'Manage databases',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Database user password change',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Do not forget to update the password in the configuration files of your application after changing it here.',
    'domain.connection-info.buttonSave' => 'Save',
    'domain.connection-info.buttonSaving' => 'Saving...',
    'domain.connection-info.buttonCancel' => 'Cancel',

    'domain.move.title' => 'Move domain %%name%%',
    'domain.move.hint' => 'The domain will be moved to a new subscription with its content, configuration files, log files, and APS applications.',
    'domain.move.hintMain' => 'The domain will be moved to a new subscription with its content, configuration files, log files, databases, database users, additional FTP users, scheduled tasks, smb users, and APS applications.',
    'domain.move.hintSubdomains' => 'The subdomain(s) %%subdomains%% will be moved together with the parent domain.',
    'domain.move.hintAliases' => 'The domain alias(es) %%aliases%% will be moved together with the parent domain.',
    'domain.move.hintSubdomainsAndAliases' => 'The subdomain(s) %%subdomains%% and the domain alias(es) %%aliases%% will be moved together with the parent domain.',
    'domain.move.labelDatabases' => 'After you have moved the domain, open the "Databases" tab to move the associated databases.',
    'domain.move.hintDatabases' => 'If necessary, move the databases separately.',

    'domain.move.Form.submitButton' => 'Move',
    'domain.move.Form.cancelButton' => 'Cancel',

    'domain.move.selectTarget' => 'Available subscriptions',
    'domain.move.nothingFound' => 'Nothing found',
    'domain.move.targetIsRequred' => 'Select the subscription to move the domain to.',
    'domain.move.selectNewSubscription' => 'Create a new subscription',
    'domain.move.ipv4Address' => 'IPv4 address',
    'domain.move.ipv4AddressHint' => 'IP address on which the website is hosted is a network address of the website\'s virtual host.',
    'domain.move.ipv6Address' => 'IPv6 address',
    'domain.move.ipv6AddressHint' => 'IP address on which the website is hosted is a network address of the website\'s virtual host.',
    'domain.move.ipAddressIsNotSelected' => 'At least one IP address must be selected.',
    'domain.move.username' => 'Username',
    'domain.move.usernameHint' => 'The system user account associated with the webspace. Used to access the hosted files via FTP and SSH.',
    'domain.move.usernameIsRequred' => 'You must provide a username.',
    'domain.move.password' => 'Password',
    'domain.move.passwordIsRequred' => 'You must provide a password.',
    'domain.move.noAvailableSubscriptions' => 'No available subscriptions',
    'domain.move.noWebHosting' => 'No system user will be created at this moment because the domain has no web hosting.',

    'domain.rename.title' => 'Change domain name',
    'domain.rename.titleAlias' => 'Change domain alias name',
    'domain.rename.hint' => 'You are now changing the domain name %%domainName%%',
    'domain.rename.hintAlias' => 'You are now changing the domain alias name %%domainName%%',
    'domain.rename.name' => 'New domain name',
    'domain.rename.nameAlias' => 'New domain alias name',
    'domain.rename.domainNameIsRequired' => 'This required field is empty. You need to specify a value.',
    'domain.rename.submitButton' => 'Change',
    'domain.rename.submitButtonProgress' => 'Changing',
    'domain.rename.successMessage' => 'Domain name %%oldName%% was changed to %%newName%%.',
    'domain.rename.successMessageAlias' => 'Domain alias name %%oldName%% was changed to %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Cancel',

    'domain.outgoing-messages.hint' => 'Here you can change the limit on the number of outgoing messages for this domain. It will not be possible to send more messages than the specified limit.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Default (%%domainOutgoingMessages%% messages per hour)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'messages per hour',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limit on outgoing messages',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Custom value for this domain',

    'domain.tech-domain-name.title' => 'Select your domain name',
    'domain.tech-domain-name.techDomainTitle' => 'Temporary domain name',
    'domain.tech-domain-name.customDomainTitle' => 'Registered domain name',
    'domain.tech-domain-name.techDomainText' => 'I don\'t have a registered domain name yet',
    'domain.tech-domain-name.customDomainText' => 'I already have a registered domain name',
    'domain.tech-domain-name.techDomain' => 'Your temporary domain name',
    'domain.tech-domain-name.customDomain' => 'Registered domain name',
    'domain.tech-domain-name.domainName' => 'Domain name',
    'domain.tech-domain-name.techDomainDesc' => 'Temporary domain names are used for accessing your site before you register and purchase a proper domain name. They are provided for free with the following conditions:',
    'domain.tech-domain-name.techDomainRandom' => 'The names are generated randomly',
    'domain.tech-domain-name.techDomainDns' => 'They are hosted in the .plesk.page DNS zone',
    'domain.tech-domain-name.techDomainSwitch' => 'You can switch to a registered domain name at any time later by renaming your domain in the domain settings.',
    'domain.tech-domain-name.error' => 'An unexpected error occurred.',
    'domain.tech-domain-name.errorNoIpAddress' => 'You have to select the IP address.',
    'domain.tech-domain-name.generating' => 'Generating...',

    'get-password.label' => 'Reset password',
    'get-password.text' => 'Enter your email address, or username registered in Plesk and we will send you a password reset email.',
    'get-password.emailLabel' => 'Email address',
    'get-password.loginLabel' => 'Username',
    'get-password.send' => 'Send',
    'get-password.cancel' => 'Cancel',
    'get-password.errorInvalidEmail' => 'The email address was not recognized. Please double-check and try again.',
    'get-password.messageSend' => "The password reset email was sent to the associated email address.\nIf the email does not arrive, please contact your Plesk administrator.",

    'iis-settings.formGeneralHint' => 'Here you can specify IIS web server settings for your website by changing the default values. Custom IIS configuration is useful, for example, when you want to use a new type of index files on your website or to associate a certain MIME type with certain filename extensions. The default values are defined by your hosting provider.',
    'iis-settings.formGeneralHint_powerUser' => 'Here you can specify IIS web server settings for this website. Custom IIS configuration is useful, for example, when you want to use a new type of index files on your website or to associate a certain MIME type with certain filename extensions. Default values mean that IIS will use the corresponding directives from its default configuration.',
    'iis-settings.virtualDirectoryLoadError' => 'Unable to get the properties of the specified virtual directory: %%errorMessage%%',
    'iis-settings.general' => 'Common settings',
    'iis-settings.example' => "For example:\n%%example%%",
    'iis-settings.settingOn' => 'On',
    'iis-settings.settingOff' => 'Off (Default)',
    'iis-settings.settingDefault' => 'Default',
    'iis-settings.settingCustom' => 'Enter custom value',
    'iis-settings.mimeTypes' => 'MIME types',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME types associate file extensions with file types. Typically, this is used to create a custom file extension for common file types.',
    'iis-settings.documents' => 'Default documents',
    'iis-settings.documentsOff' => 'Disabled',
    'iis-settings.documentsCustom' => 'Enter values',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'When browsers do not provide the name of a document within your site, IIS will look for the specified default documents and serve the first one found. If you do not specify the default documents, but turn on the Directory browsing, then the directory listing will be displayed in browsers instead of the index page.',
    'iis-settings.expires' => 'Expires',
    'iis-settings.expiresFullDescription' => 'The web server will add the “Expires” response headers to web pages. The expiration timestamp is obtained by adding the amount of time specified above to the time at which a web page is requested.',
    'iis-settings.expiresUnitDays' => 'days',
    'iis-settings.expiresUnitHours' => 'hours',
    'iis-settings.expiresUnitMinutes' => 'minutes',
    'iis-settings.expiresUnitSeconds' => 'seconds',
    'iis-settings.headers' => 'Additional headers',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Web server will add the specified HTTP response headers.',
    'iis-settings.directoryBrowsing' => 'Directory browsing',
    'iis-settings.directoryBrowsingDescription' => 'Allows users to see the site\'s directory listing in web browsers, for example, when the default index page is not available.',
    'iis-settings.securityTabDirectory' => 'Directory security settings',
    'iis-settings.allowAnonymous' => 'Anonymous authentication',
    'iis-settings.allowAnonymousDescription' => 'Anonymous authentication allows users to access public content of your site. Password-protected content of your site, as well as the content protected on a file system level, will not be available to anonymous users.',
    'iis-settings.allowWindows' => 'Windows authentication',
    'iis-settings.allowWindowsDescription' => 'Windows authentication (formerly named NTLM) protects content of your site on a file system level.',
    'iis-settings.requireSsl' => 'Require SSL/TLS',
    'iis-settings.requireSslDescription' => 'If you have enabled the SSL/TLS support for your site, this option will force web clients (browsers) to use secure HTTPS connections only.',
    'iis-settings.securityTabIpDeny' => 'Access restriction settings',
    'iis-settings.deny' => 'Deny access to the site',
    'iis-settings.denyOff' => 'Default',
    'iis-settings.denyCustom' => 'Enter custom value',
    'iis-settings.allow' => 'Excluding',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nThe specified hosts and networks are prohibited from accessing the site. Use '*' to deny all connections.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nThe specified hosts and networks are allowed to access the site.",
    'iis-settings.dynamicIpSecurity' => 'Preventing DoS attacks by IIS dynamic IP restriction',
    'iis-settings.isDenyByConcurrentRequests' => 'Deny IP addresses based on the number of concurrent requests from a unique IP address',
    'iis-settings.maxConcurrentRequests' => 'Maximum number of concurrent requests',
    'iis-settings.isDenyByRequestRate' => 'Deny IP addresses based on the number of requests over a period of time',
    'iis-settings.maxRequests' => 'Maximum number of requests',
    'iis-settings.requestInterval' => 'Time period (in milliseconds)',

    'ip-addresses-selector.ipAddress' => 'IP address',
    'ip-addresses-selector.ipv4Address' => 'IPv4 address',
    'ip-addresses-selector.ipv4AddressHint' => "IP address on which the website is hosted is a network address of the website's virtual host.",
    'ip-addresses-selector.ipv6Address' => 'IPv6 address',
    'ip-addresses-selector.ipv6AddressHint' => "IP address on which the website is hosted is a network address of the website's virtual host.",
    'ip-addresses-selector.noIpAddressHint' => 'None',
    'ip-addresses-selector.shared' => 'shared',
    'ip-addresses-selector.exclusive' => 'dedicated',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP server does not support IPv6. Allocate at least one IPv4 address, otherwise the user will not be able to upload files to the server over FTP.',

    'license-key-revert.description' => 'The license key with the following properties will be restored:',
    'license-key-revert.submitButton' => 'Roll Back',

    'license-key-upload.description' => 'Install your license key by entering an activation code.',
    'license-key-upload.descriptionWithFileUpload' => 'Install your license key either by entering an activation code or by uploading a license key file.',
    'license-key-upload.type' => 'Choose one of the following:',
    'license-key-upload.code' => 'Enter an activation code',
    'license-key-upload.codeDescription' => 'Paste the received activation code.',
    'license-key-upload.file' => 'Upload a license key file',
    'license-key-upload.fileDescription' => 'Specify the path to the file containing the license key.',
    'license-key-upload.submitButton' => 'Install',

    'log-rotation.customLogsDescription' => 'Note that your custom logs are not rotated.',
    'log-rotation.logRotation' => 'Log rotation',
    'log-rotation.logRotationCondition' => 'Log rotation condition',
    'log-rotation.logRotationBySize' => 'By size',
    'log-rotation.logRotationByTime' => 'By time',
    'log-rotation.logRotationDaily' => 'Daily',
    'log-rotation.logRotationWeekly' => 'Weekly',
    'log-rotation.logRotationMonthly' => 'Monthly',
    'log-rotation.logRotationSizeDescription' => 'Size value must be between %%min%% and %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Maximum number of log files',
    'log-rotation.compress' => 'Compress log files',
    'log-rotation.sendLogToEmail' => 'After Plesk retrieves data from log files of web and FTP servers, email the log files to this address',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Period cannot be grater than server wide limit %%max%%.',

    'login.loginLabel' => 'Username',
    'login.passwdLabel' => 'Password',
    'login.localeLabel' => 'Interface language',
    'login.defaultLocale' => 'Default',
    'login.loginButtonLabel' => 'Log in',
    'login.enterUsername' => 'Enter your username.',
    'login.enterPassword' => 'Enter your password.',
    'login.whatUsernamePassword' => 'What username and password to use?',
    'login.forgotPasswordLabel' => 'Forgot your password?',
    'login.cookies' => 'Cookies policy in Plesk',
    'login.avoidSSLWarningsMsg' => 'To avoid SSL warnings during Plesk login, use %%link%%',
    'login.digitalOceanMsg' => 'New to Plesk on DigitalOcean? Use "root" and the password entered when creating this droplet to log in. %%link%%',
    'login.amazonLightsailMsg' => 'New to Plesk on Lightsail? To log in to Plesk, access the server via SSH and use the "plesk login" command. %%link%%',
    'login.readGuide' => 'Read the complete guide.',
    'login.mobileApplicationMessage' => 'For a better experience, we recommend that you install the %%name%% application.',
    'login.mobileApplicationInstall' => 'Install Now',
    'login.mobileApplicationHide' => 'No, thanks',

    'force-reset-password.saveButton' => 'Save',
    'force-reset-password.title' => 'Change Your Password',
    'force-reset-password.passwordLabel' => 'New Password',

    'panel-access.title' => 'Customizing Plesk URL',
    'panel-access.hint' => 'Choose custom URLs for logging in to Plesk. This will not take away the possibility to log in to Plesk via port %%httpsPort%%. %%link%%',
    'panel-access.details' => 'More details',
    'panel-access.proxyEnabled' => 'All domains and subdomains that resolve to the server IP address but are not used for hosting',
    'panel-access.proxyDomain' => 'The specified domain or subdomain that resolves to the server IP address but is not used for hosting',
    'panel-access.proxyDisabled' => 'No custom URLs. Only https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Save',
    'panel-access.Form.cancelButton' => 'Cancel',

    'panel-access.domainNameIsRequired' => 'You must provide a domain name.',
    'panel-access.successMessage' => 'The selected way of logging in was applied.',
    'panel-access.notSupported' => 'Your Plesk does not support the selected way of logging in.',
    'panel-access.notViaDomainName' => 'To apply this way of logging in, choose the first option ("All domains and subdomains..."), log in to Plesk via https://%%domainName%%, and then choose the second option.',
    'panel-access.notViaPort' => 'To apply this way of logging in, log in to Plesk via https://<server-IP-or-hostname>:%%httpsPort%% first.',

    'php-settings.performance' => 'Performance and security settings',
    'php-settings.settings' => 'Common settings',
    'php-settings.fastCgiSettings' => 'FastCGI settings',
    'php-settings.fpmSettings' => 'PHP-FPM settings',
    'php-settings.enableFastcgi' => 'Enable FastCGI settings',
    'php-settings.plainTextEditing' => 'Additional directives',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'You can define any PHP parameters by typing them into the field below. The directives will be included in the PHP configuration. Use the same syntax as you would for php.ini. For example, to automatically load the mSQL extension, add the line: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'If you cannot find particular PHP parameters, add them to the field below. These additional directives will be merged with the directives of the main service plan. Use the same syntax as you use for php.ini. For example, if you want to automatically load the mSQL extension, add the line: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'You can define any PHP parameters by typing them into the field below. The directives will be included in the PHP configuration. Use the same syntax as you would for php.ini. For example, to automatically load the mSQL extension, add the line: extension=msql.so. To customize PHP-FPM pool settings, add the [php-fpm-pool-settings] separator and type the desired settings below.',
    'php-settings.additionalConfigurationDirectives' => 'Additional configuration directives',
    'php-settings.defaultValue' => 'Default',
    'php-settings.predefinedValue' => 'Select value',
    'php-settings.customValue' => 'Enter custom value',
    'php-settings.phpSettingDescription_memory_limit' => 'The maximum amount of memory in bytes a script is allowed to allocate.',
    'php-settings.phpSettingDescription_max_execution_time' => 'The maximum time in seconds a script is allowed to run before it is terminated.',
    'php-settings.phpSettingDescription_max_input_time' => 'The maximum time in seconds a script is allowed to parse input data.',
    'php-settings.phpSettingDescription_post_max_size' => 'The maximum size in bytes of data that can be posted with the POST method. Typically, should be larger than upload_max_filesize and smaller than memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'The maximum size in bytes of an uploaded file.',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP safe mode puts a number of restrictions on the execution of scripts, mainly for security reasons.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Files in the specified directory can be accessed by PHP scripts when the safe_mode directive is in effect. The directory must also be in include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programs in the specified directory can be executed by PHP scripts when the safe_mode directive is in effect.',
    'php-settings.phpSettingDescription_include_path' => 'The list of directories where scripts look for files (similar to system\'s PATH variable). To separate directories, use a colon (:) on Linux and a semicolon (;) on Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'The directory to store PHP session files.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Additional parameters for the mail() function.',
    'php-settings.phpSettingDescription_register_globals' => 'Register the contents of the EGPCS (Environment, GET, POST, Cookie, Server) variables as global variables.',
    'php-settings.phpSettingDescription_open_basedir' => 'Files in the specified directories can be accessed by PHP scripts. To separate directories, use a colon (:) on Linux and a semicolon (;) on Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'The error reporting level.',
    'php-settings.phpSettingDescription_display_errors' => 'Determines whether errors should be displayed as a part of the output.',
    'php-settings.phpSettingDescription_log_errors' => 'Enable the logging of PHP errors.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Allows PHP file functions to retrieve data from remote locations over FTP or HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Allows uploading files over HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Allows the short form (<? ?>) of the PHP\'s open tag.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Sets the magic_quotes state for the GPC (Get/Post/Cookie) operations. When magic_quotes are on, all single-quote, double quote, backslash, and NULL special characters are escaped with the backslash automatically.',
    'php-settings.phpSettingDescription_disable_functions' => 'This directive allows you to disable certain functions. It takes on a comma-delimited list of function names',
    'php-settings.phpSupport' => 'PHP support',
    'php-settings.phpRunAs' => 'run PHP as',
    'php-settings.phpVersion' => 'PHP version',
    'php-settings.phpHandlerOutdated' => '(Outdated)',
    'php-settings.phpHandlerDeprecated' => '(Deprecated)',
    'php-settings.phpServedByApache' => 'served by Apache',
    'php-settings.phpServedByNginx' => 'served by nginx',
    'php-settings.phpSettingsPhpVersion' => 'Your PHP version is %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP is switched off.',
    'php-settings.phpHandlerTypeHint' => 'Below are the details on the website\'s PHP configuration. You can change the PHP configuration if the hosting provider grants you the corresponding permission.',
    'php-settings.fpmDedicatedHandlerHint' => 'Using this handler increases the stability of a website, but also causes an additional memory consumption.',
    'php-settings.phpHandlerChangeHint' => 'You have changed the PHP handler settings. If you save these changes, PHP scripts on your website may stop for %%interval%% seconds because of your server configuration.',
    'php-settings.phpHandlerOutdatedHint' => 'To check if the new PHP version is available, %%link%% and look into "Web Hosting" category of the product components.',
    'php-settings.phpHandlerOutdatedHintLink' => 'open Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Learn how to choose the most suitable PHP settings',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP support cannot be enabled because current hosting configuration does not include any PHP versions available for this domain.',
    'php-settings.phpHandlersNotAvailableHint' => 'PHP support cannot be enabled because current Plesk configuration does not include any PHP versions available.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Find out how to enable other PHP versions.',
    'php-settings.phpSupportEditable' => '(PHP version %%version%%, run PHP as %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(version: %%version%%; handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(not registered) %%link%%',
    'php-settings.showPhpInfo' => 'View the phpinfo() page',
    'php-settings.phpSettingsFormError' => 'Unable to retrieve PHP settings because the required data is absent.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Unable to retrieve PHP settings because this PHP version is not installed. To proceed, install the selected PHP version or select another one for the domain.',
    'php-settings.showPhpInfoTitle' => 'View phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Some of your PHP settings have been changed but the changes are not saved yet. To see the new values on the phpinfo() page, please apply the changes first. Otherwise you will see the current values.',
    'php-settings.showPhpInfoButton' => 'View phpinfo()',
    'php-settings.onState' => 'On',
    'php-settings.offState' => 'Off',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent is checking for updates.',
    'pmm.agent.sync.updating' => 'Synchronizing and downloading Migration & Transfer Agent',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent was synchronized successfully.',
    'pmm.agent.sync.downloadLink' => 'Click to download Migration & Transfer Agent file that should be installed on the source host before the migration is started.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent failed to get updates. Please try again later.',

    'restore-password.title' => 'Change Your Password',
    'restore-password.passwordLabel' => 'New password',
    'restore-password.buttonRestore' => 'Save',
    'restore-password.buttonCancel' => 'Cancel',
    'restore-password.isEmpty' => 'The required field is empty. You need to specify a value.',
    'restore-password.errorInvalidSecret' => 'Invalid secret code',
    'restore-password.errorNotFoundSecret' => 'Please request a new secret code',
    'restore-password.restoreSuccess' => 'Your password was updated. Use the new password to log in to Plesk or to your email address.',

    'scheduler.settings.schedulerNotification' => 'Scheduler notification',
    'scheduler.settings.notificationOff' => "Switched off",
    'scheduler.settings.notificationDefault' => "Send to the default email (%%email%%)",
    'scheduler.settings.notificationCustom' => "Send to the email I specify",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Show tasks schedule using a time zone',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Use the system default time zone (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Use the system default time zone',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Use the time zone I specify',

    'scheduler.task.active' => 'Active',
    'scheduler.task.subscription' => 'Subscription',
    'scheduler.task.subscription_powerUser' => 'Webspace',
    'scheduler.task.type' => 'Task type',
    'scheduler.task.typeCommand' => 'Run a command',
    'scheduler.task.typeUrl' => 'Fetch a URL',
    'scheduler.task.typeScript' => 'Run a PHP script',
    'scheduler.task.command' => 'Command',
    'scheduler.task.arguments' => 'with arguments',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Specify an absolute URL, for example, http://example.com. If the response status code is 2xx or 3xx, the task is considered to have been successfully executed.',
    'scheduler.task.script' => 'Script path',
    'scheduler.task.scriptRelativePathDescription' => 'Example: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Specify the full path to the script. Example: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Use PHP version',
    'scheduler.task.scriptPathPopupTitle' => 'Script Path',
    'scheduler.task.run' => 'Run',
    'scheduler.task.on' => 'on',
    'scheduler.task.at' => 'at',
    'scheduler.task.sysUser' => 'System user',
    'scheduler.task.hourly' => 'Hourly',
    'scheduler.task.daily' => 'Daily',
    'scheduler.task.weekly' => 'Weekly',
    'scheduler.task.monthly' => 'Monthly',
    'scheduler.task.yearly' => 'Yearly',
    'scheduler.task.cronStyle' => 'Cron style',
    'scheduler.task.cronStyleError' => 'Invalid crontab syntax.',
    'scheduler.task.cronStyleErrorWin' => 'Slash (/) and hyphen (-) are not allowed.',
    'scheduler.task.cronStyleHint' => 'Use the UNIX crontab format "minute hour day-of-month month day-of-week". For example "0 22 * * 1-5". Plesk will use the default system time zone to run the task.',
    'scheduler.task.cronStyleWinHint' => 'Use the format "minute hour day-of-month month day-of-week", for example "0 22 * * 6,7". Plesk will use the default system time zone to run the task.',
    'scheduler.task.notify' => 'Notify',
    'scheduler.task.notifyIgnore' => 'Do not notify',
    'scheduler.task.notifyErrors' => 'Errors only',
    'scheduler.task.notifyAlways' => 'Every time',
    'scheduler.task.notifyErrorsHint' => 'Notifications contain the standard error stream of the command. If the stream is empty, no notification is sent.',
    'scheduler.task.notifyErrorsHintWin' => 'Notifications contain the command output and are sent only if the exit code is non-zero.',
    'scheduler.task.notifyAlwaysHint' => 'Notifications contain the command output. If the output is empty, no notification is sent.',
    'scheduler.task.notifyAlwaysHintWin' => 'Notifications contain the command output and are sent regardless of the command exit code.',
    'scheduler.task.emailType' => 'Send notifications to',
    'scheduler.task.emailTypeDefault' => 'Default system user (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Subscription owner (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrator (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Other users',
    'scheduler.task.emailTypeCustomDescription' => 'You can specify several addresses separated with commas.',
    'scheduler.task.minute' => 'minute',
    'scheduler.task.shortMinute' => 'min',
    'scheduler.task.dayOfMonth' => 'day',
    'scheduler.task.description' => 'Description',
    'scheduler.task.scheduleTimezoneHint' => 'The time zone for running the task is %%timezone%%',
    'scheduler.task.runTaskNow' => 'Run Now',
    'scheduler.task.runningTask' => 'Running the task "%%task%%"...',

    'server-settings.submitDone' => "The server settings were changed.",
    'server-settings.systemSettings' => "System settings",
    'server-settings.fullHostName' => "Full hostname",
    'server-settings.trafficStatisticsPeriod' => "Retain web and traffic statistics for",
    'server-settings.trafficStatisticsPeriodUnit' => "months",
    'server-settings.diskSpaceUsageCalculation' => "Include in the disk space usage calculation",
    'server-settings.includeLogs' => "log files and statistic reports",
    'server-settings.includeMysqlDatabases' => "mySQL databases",
    'server-settings.includeMssqlDatabases' => "microsoft SQL databases",
    'server-settings.includeDatabases' => "databases",
    'server-settings.includeRemoteDatabases' => "remote databases",
    'server-settings.includeMailboxes' => "mailboxes",
    'server-settings.includeMailLists' => "mailing lists",
    'server-settings.includeDomainDumps' => "domain backup files",
    'server-settings.includeAdminDumps' => "backup files created by the administrator",
    'server-settings.calculatingDiskSpaceUsage' => "When calculating disk space usage, count",
    'server-settings.typeByte' => "file size",
    'server-settings.typeBlock' => "amount of disk space used",
    'server-settings.trafficCalculation' => "Include in the traffic calculation",
    'server-settings.inboundAndOutbound' => "inbound and outbound traffic",
    'server-settings.onlyInbound' => "only inbound traffic",
    'server-settings.onlyOutbound' => "only outbound traffic",
    'server-settings.forbidCreateDnsSubZone' => "Forbid users to create DNS subzones in other users' DNS superzones",
    'server-settings.webDeployIncludePassword' => "Include the user's password into the file with Web Deploy publication settings",
    'server-settings.forbidSysUserRename' => "Customers can change the name of their system users",
    'server-settings.alwaysAllowSysUserRename' => "always",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "only if the Hosting Management permission is granted",
    'server-settings.neverAllowSysUserRename' => "never",
    'server-settings.forbidSubscriptionRename' => "Forbid customers and resellers to change their main domain name",
    'server-settings.preferredDomain' => "Preferred domain for websites",
    'server-settings.preferredDomainNone' => "none",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "IP logging",
    'server-settings.disableIpLogging' => "Disable IP logging in IIS, FTP, and mail logs",
    'server-settings.disableIpLoggingDescription' => "If selected, IIS and MailEnable no longer write IP addresses to log files",
    'server-settings.anonymizeIps' => "Anonymize IP addresses",
    'server-settings.logrotateAnonymizeIps' => "Anonymize IP addresses during log rotation and collecting of web statistics",
    'server-settings.logrotateAnonymizeIpsDescription' => 'The postrotate script replaces the last octet of IPv4 addresses in rotated log files with "0" before archiving. In IPv6 addresses, the script replaces the last section of the address (two octets after the last colon) with "0000" (in the full form) or "0" (in the short form)',
    'server-settings.logrotate' => "Log rotate",
    'server-settings.logrotateForce' => "Force daily log rotation for all domains",
    'server-settings.allowToStoreLogs' => "Allow to store website logs for",
    'server-settings.logrotatePeriod' => "days",
    'server-settings.configureUpdatePolicy' => "Configure update policy",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Default server-wide value (%%default%% messages per hour)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Custom value for the plan',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Custom value for the subscription',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'messages',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Outgoing messages from a mailbox (per hour)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Outgoing messages from a domain (per hour)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Outgoing messages from a subscription (per hour)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'The percentage of messages above the per-hour limit that should be sent in the next hour',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'If the limit on outgoing email messages from a mailbox per hour is 100 and the percentage is 10%, then the user is allowed to submit 110 messages per hour; 100 messages will be sent during an hour, and 10 messages will be put in the mail queue and scheduled to be sent in the next hour.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail usage policy',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Default server-wide settings (Sendmail is allowed)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Default server-wide settings (Sendmail is not allowed)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Custom settings for the plan',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Custom settings for the subscription',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Allow using Sendmail for scripts and users on this subscription',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Scripts and users will be able to send email messages (on behalf of the subscription\'s system user) by using Sendmail even if the limits for a mailbox and domain are exceeded. The maximum number of messages that can be sent through Sendmail will be defined by the limit for an entire subscription.',

    'setup.hint' => 'Welcome to Plesk, a control panel that helps you manage your server. Plesk provides a ready-to-code environment and gives you a suite of powerful extensions to help you develop websites and apps. Complete the setup process to begin using Plesk (it will only take a minute).',
    'setup.contactInfoSection' => 'Contact Information',
    'setup.contactInfoSectionHint' => 'Enter your name and email address to identify yourself as the owner of the server and receive important notifications about the server. If you are a corporate server administrator, do not enter your personal name or email address. Use your job title and corporate email address instead to avoid possible violation of data protection law.',
    'setup.contactName' => 'Your Contact Name',
    'setup.emptyContactName' => 'Please provide a contact name.',
    'setup.contactNameTooLong' => 'Contact name is too long (maximum %max% symbols are allowed).',
    'setup.email' => 'Email',
    'setup.emptyEmail' => 'Please provide an email address.',
    'setup.passwordSection' => 'Password',
    'setup.passwordSectionHint' => 'Next time you log in to Plesk, use the \'admin\' username and the password entered below.',
    'setup.password' => 'Password',
    'setup.licenseSection' => 'License',
    'setup.licenseSectionHint' => 'You need to install a license to start using Plesk.',
    'setup.licenseType' => 'Select your license type',
    'setup.licenseTypePaid' => 'Proceed with a paid license',
    'setup.onlineStoreLink' => 'Online Store',
    'setup.licenseTypeTrial' => 'Proceed with a full-featured trial license',
    'setup.activationCodeHint' => 'If you have already purchased a Plesk license, paste the activation code you received here. If not, you can buy a new license in our %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Plesk Privacy Policy',
    'setup.trialLicenseAgreement' => 'To issue a trial license, Plesk International GmbH will use and process the provided information in its internal systems according to the %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'I confirm that I\'ve read and accepted the %%link%%',
    'setup.eula' => 'End-User License Agreement',
    'setup.invalidEulaAgreementValue' => 'You must accept the End-User License Agreement',
    'setup.sendButton' => 'Enter Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Reset admin\'s password on the next login',

    'ssl-certificate.add.name' => 'Certificate name',
    'ssl-certificate.add.longName' => 'The specified certificate name is too long (maximum %max% symbols are allowed).',
    'ssl-certificate.add.certificateNameUsed' => 'A certificate with the name %%name%% already exists.',
    'ssl-certificate.add.certificateAdded' => 'The SSL/TLS certificate was issued. To make it work, assign the certificate to secure a domain, mail, or webmail.',
    'ssl-certificate.add.certificateUpdated' => 'The SSL/TLS certificate was successfully updated.',
    'ssl-certificate.add.settings' => 'Settings',
    'ssl-certificate.add.settingsHint' => 'Use this form to generate a request for a certificate, to buy a certificate from your provider, or to generate a self-signed certificate.',
    'ssl-certificate.add.settingsHint2' => 'A request is a CSR file that contains the information about your domain that you specified in the form. You can submit the request to a certification authority for issuing a certificate for you. You will then upload it using one of the upload forms below.',
    'ssl-certificate.add.settingsHint3' => 'A self-signed certificate is an identity certificate signed by its own creator. If you use such a certificate, it means that you yourself verify your sites\' identity. Although self-signed certificates allow the usage of SSL/TLS, they are trusted less, and considered as less secure.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'Country',
    'ssl-certificate.add.state' => 'State or province',
    'ssl-certificate.add.longState' => 'The specified state or province name is too long.',
    'ssl-certificate.add.city' => 'Location (city)',
    'ssl-certificate.add.longCity' => 'The specified city name is too long.',
    'ssl-certificate.add.shortCity' => 'The specified city name is too short.',
    'ssl-certificate.add.companyName' => 'Organization name (company)',
    'ssl-certificate.add.longCompanyName' => 'The specified company name is too long.',
    'ssl-certificate.add.companyUnitName' => 'Organization department or division name',
    'ssl-certificate.add.longCompanyUnitName' => 'The specified organization department name is too long (maximum %max% symbols are allowed).',
    'ssl-certificate.add.domainName' => 'Domain name',
    'ssl-certificate.add.email' => 'Email',
    'ssl-certificate.add.request' => 'Request',
    'ssl-certificate.add.buyCertificate' => 'Buy SSL/TLS Certificate',
    'ssl-certificate.add.selfSigned' => 'Self-Signed',
    'ssl-certificate.add.invalidCertificateParams' => 'Some fields are empty or contain improper values. The values should be limited to 64 characters. If you are using an internationalized domain name, make sure that no part of the domain name between dots exceeds 63 symbols when transformed to ASCII format. Check the fields: ',
    'ssl-certificate.add.unableCreateCsr' => 'Unable to create a CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Unable to create a self-signed certificate: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Unable to set the certificate data: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Unable to save the certificate in database: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Upload the certificate files',
    'ssl-certificate.add.uploadFilesHint' => 'Use this form to upload the components of a certificate as constituent files.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Private key (*.key)",
    'ssl-certificate.add.certificate' => "Certificate (*.crt)",
    'ssl-certificate.add.caCertificate' => "CA certificate (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Upload Certificate",
    'ssl-certificate.add.fileNotUploaded' => 'Unable to upload the certificate file: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Unable to set the private key: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Unable to set the certificate: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Unable to set the CA certificate: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Unable to check if the CA certificate signs the certificate: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Remove',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Do you want to remove the CA certificate?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Unable to clear the CA certificate: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'The CA part of the certificate was removed.',
    'ssl-certificate.add.rename' => 'Rename',
    'ssl-certificate.add.unableRenameCertificate' => 'Unable to rename the certificate: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'The certificate was renamed to %%name%%.',
    'ssl-certificate.add.uploadText' => "Upload the certificate as text",
    'ssl-certificate.add.uploadTextHint' => 'Use this form to upload the components of a certificate as text. Copy the contents of a file and paste into the corresponding field.',
    'ssl-certificate.add.sendText' => "Upload Certificate",
    'ssl-certificate.add.componentIsMissing' => 'The component is missing.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Upload the certificate here',
    'ssl-certificate.find-private-key.formGeneralHint' => 'If you created a certificate signing request on this server and received the certificate file, upload it here. If you want to upload a certificate and private key pair generated on a different server, or generate a self-signed certificate, click <b>Add SSL/TLS Certificate</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'After adding an SSL/TLS certificate to a domain, you need to enable SSL/TLS support and select that certificate in the website hosting settings: <b>Websites & Domains</b> > <b>Hosting Settings</b> of this domain > <b>Security</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificate (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Upload Certificate',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Unable to upload the certificate file.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Invalid certificate format.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Unable to find the appropriate private key for the certificate.',

    'ssl-certificate.secure.certificate' => 'Select Certificate',
    'ssl-certificate.secure.serverPool' => 'server pool',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Date",
    'system-time.dateAndTime' => "Date and time",
    'system-time.daylight' => "Automatically adjust clock for daylight saving changes",
    'system-time.dayMonthYear' => "Day-Month-Year",
    'system-time.domainNameOrIp' => "Domain name or IP",
    'system-time.hoursMinutesSeconds' => "Hours:Minutes:Seconds",
    'system-time.networkTime' => "Network time",
    'system-time.submitDone' => "System time settings were changed.",
    'system-time.synchronizedSystemTime' => "Synchronize system time",
    'system-time.title' => "System Date and Time",
    'system-time.timezone' => "Time zone",
    'system-time.time' => "Time",
    'system-time.updateSystemTime' => "Update system time",
    'system-time.yourTimezone' => "Your time zone",

    'web-app-firewall.pageHint' => 'Web application firewall protects web applications from attacks by checking and filtering incoming HTTP requests based on user-defined rules.',
    'web-app-firewall.webSitePageHint' => 'Here you can configure the web application firewall (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Web application firewall mode',
    'web-app-firewall.ruleEngineOn' => 'On',
    'web-app-firewall.ruleEngineOnDescription' => 'Each incoming HTTP request and the related response are checked against a set of rules. If the check succeeds, the HTTP request is passed to website content. If the check fails, the event is logged, a notification is sent, and the HTTP response is provided with an error code.',
    'web-app-firewall.ruleEngineOff' => 'Off',
    'web-app-firewall.ruleEngineOffDescription' => 'Incoming HTTP requests and related responses are not checked.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Detection only',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Each incoming HTTP request and the related response are checked against a set of rules. If the check succeeds, the HTTP request is passed to website content. If the check fails, the event is logged and ModSecurity performs no other actions. Other services (for example, Fail2ban) can still perform their own actions on HTTP requests that failed the check.',
    'web-app-firewall.ruleSetsSection' => 'Rule sets',
    'web-app-firewall.ruleSetsSectionHint' => 'Select which rule set (a package of files containing security rules) to use for checking the incoming HTTP requests.',
    'web-app-firewall.ruleSet' => 'Rule set',
    'web-app-firewall.ruleSetCrs' => 'OWASP (free)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set is very restrictive and might block some functions (for example, file sharing, webmail) and some features of web applications (for example, WordPress plugins).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Apply changes?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP rules might be too restrictive and thus block some functions, such as file sharing, webmail, and some web applications.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (free, can be upgraded to Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'A starter version of ModSecurity Rules by Atomicorp. They provide basic protection and are updated on a monthly basis.',
    'web-app-firewall.ruleSetTortixHowTo' => 'To upgrade this rule set to Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Buy %%linkPleskStore%% from the Plesk website and %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Advanced ModSecurity Rules by Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'install the bought additional license key',
    'web-app-firewall.ruleSetTortixSelect' => 'Select this ruleset, which will change its name to “Atomic Advanced (bought from Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (bought from Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules by Atomicorp include Atomic Standard rules plus a number of advanced features.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (bought from Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules by Atomicorp include Atomic Standard rules plus a number of advanced features.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Switch to another Atomicorp account.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Rule set is activated.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'If you already have the Atomicorp account with the bought Atomic Advanced rules, enter the account credentials below to enable this rule set.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'If you already have the Atomicorp account with the bought Atomic Advanced rules, enter the account credentials below to switch the account.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Username',
    'web-app-firewall.ruleSetAtomicPassword' => 'Password',
    'web-app-firewall.ruleSetComodo' => 'Comodo (free subscription)',
    'web-app-firewall.ruleSetComodoDescription' => 'Free ModSecurity Rules from Comodo. They provide basic protection.',
    'web-app-firewall.ruleSetComodoInstall' => 'Switch to another Comodo account.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Rule set is activated.',
    'web-app-firewall.ruleSetComodoHowTo' => 'To enable this rule set:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'To switch to another account:',
    'web-app-firewall.ruleSetComodoRegister' => 'Register on the Comodo website.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Enter your username and password from that website.',
    'web-app-firewall.ruleSetComodoLogin' => 'Username',
    'web-app-firewall.ruleSetComodoPassword' => 'Password',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (free)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Free ModSecurity Rules from Comodo. They provide basic protection.',
    'web-app-firewall.ruleSetCustom' => 'Custom rule set',
    'web-app-firewall.ruleSetCustomDescription' => 'Upload a custom web application firewall rule set. Supported formats: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Select Another File',
    'web-app-firewall.ruleSetError' => 'Failed to install the ModSecurity rule set: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'The OWASP ruleset is missing. Reinstall ModSecurity using the Plesk installer.',
    'web-app-firewall.ruleSetCustomMissingError' => 'The custom ruleset is missing. Reinstall the ruleset.',
    'web-app-firewall.ruleSetAuthError' => 'The specified username or password is invalid.',
    'web-app-firewall.ruleSetInvalid' => 'The selected rule set cannot be run on %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'The selected rule set cannot be run on the selected web server.',
    'web-app-firewall.webServer' => 'Run rules on',
    'web-app-firewall.webServerHint' => 'Select the desired combination of web server and ModSecurity version to see the compatible rule sets.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Reverse Proxy Server (nginx) is switched off and cannot be used to process requests. Select <a href="%%serverUrl%%">another web server</a> or switch on the reverse proxy server on the <a href="%%servicesUrl%%">Services Management page</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Selecting a different ModSecurity version may result in some settings being no longer valid (for example, you cannot use regular expressions to switch off security rules with ModSecurity 3). Make sure that your settings work as expected after applying the changes. Alternatively, you can reset the settings that switch off security rules to default values.',
    'web-app-firewall.nginxResetCustomizations' => 'Reset the server and domains settings that switch off security rules to default values.',
    'web-app-firewall.ruleSetUpdate' => 'Update rule sets',
    'web-app-firewall.ruleSetUpdateDaily' => 'Daily',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Weekly',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Monthly',
    'web-app-firewall.currentRuleSet' => 'Rule set',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% running on %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Change Rule Set',
    'web-app-firewall.ruleSetRollbackFailed' => 'Unable to use the current ModSecurity rule set and to roll back to the previous version because they contain invalid rules.',
    'web-app-firewall.configurationSection' => 'Configuration',
    'web-app-firewall.configurationSectionHint' => 'Configure web application firewall using either a predefined set of parameters or your custom ModSecurity directives.',
    'web-app-firewall.configPreset' => 'Predefined set of values',
    'web-app-firewall.configPresetFast' => 'Fast',
    'web-app-firewall.configPresetFastDescription' => 'The HTTP request URI and parts of headers will be analyzed.',
    'web-app-firewall.configPresetTradeOff' => 'Tradeoff',
    'web-app-firewall.configPresetTradeOffDescription' => 'The HTTP request URI, headers and the request POST data will be analyzed.',
    'web-app-firewall.configPresetThrough' => 'Thorough',
    'web-app-firewall.configPresetThroughDescription' => 'The full HTTP request headers, the request POST data and the HTTP response body content will be analyzed.',
    'web-app-firewall.configCustom' => 'Custom directives',
    'web-app-firewall.configCustomDescription' => "Input a ModSecurity directive here. It will override the previously specified directives (rule sets, specific rules, the predefined set of values, and so on).\nFor example: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Invalid ModSecurity configuration: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Unable to use the current ModSecurity configuration file and to roll back to the previous version of the file because they contain an invalid configuration.',
    'web-app-firewall.rulesSection' => 'Switch off security rules',
    'web-app-firewall.rulesSectionHint' => 'Here you can switch off security rules. It is handy if you find out that a security rule is too restrictive for some websites. To deactivate security rules, specify their IDs (for example, 340003 or 340005-340007), tags (for example, CVE-2011-4898), or regular expressions used in rule messages (for example, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Here you can switch off security rules. It is handy if you find out that a security rule is too restrictive for some websites. To deactivate security rules, specify their IDs (for example, 340003 or 340005-340007), tags (for example, CVE-2011-4898), or rule messages (for example, Found User-Agent associated with security scanner).',
    'web-app-firewall.filterById' => 'Security rule IDs',
    'web-app-firewall.filterByIdInvalid' => 'The following values are not valid: %%values%%. The rule ID should consist of digits or range of digits like 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'The following ranges are not valid: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tags',
    'web-app-firewall.filterByTagActive' => 'Active:',
    'web-app-firewall.filterByTagDeactivated' => 'Deactivated:',
    'web-app-firewall.filterByTagInvalid' => 'The following selected values are not valid: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Regular expressions in rule messages',
    'web-app-firewall.filterByRegexpInvalid' => 'The following values are not valid: %%values%%. They must not contain any \', " characters.',
    'web-app-firewall.filterByRegexpNginx' => 'Rule messages',
    'web-app-firewall.filterByRegexpNginxHint' => 'Only strict matches are supported.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'The following values are not valid: %%values%%. The rule message must consist of letters, digits, spaces or characters -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'ModSecurity audit log',
    'web-app-firewall.auditLogHint1' => 'The ModSecurity audit log file is the most useful piece of information in the system. When ModSecurity detects that any event occurs, it generates an entry in the audit log file.',
    'web-app-firewall.auditLogHint2' => 'A website can stop functioning as expected after you change the web application firewall mode to On from Off or Detection only. In this case, analyze the ModSecurity audit log to find out what is happening. You can switch off too restrictive security rules or adjust the website.',
    'web-app-firewall.auditLogHint3' => 'To find out why an HTTP request cannot be completed for a website:',
    'web-app-firewall.auditLogPoint1' => 'Click the ModSecurity Log File link below and open the audit log in a new browser window.',
    'web-app-firewall.auditLogPoint2' => 'Use Search (Ctrl+F in most web browsers) to find events for the website (the domain name) that experiences problems. For example, your_domain.tld. The browser will highlight entries like HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'In three lines above the highlighted entry, find a string like --eece5138-B--. The eight symbols between hyphens (in our example, eece5138) are the ID of the event triggered by the HTTP request.',
    'web-app-firewall.auditLogPoint4' => 'Search further for other entries with the same event ID. Look for an entry with the letter H after the event ID (in our example, eece5138-H--). This entry contains the ID and description of the security rule triggered while checking the HTTP request. The security rule ID is an integer number starting with 3, in quotation marks, and put with the prefix id in square brackets. For example, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Find a security rule ID in the event using a substring [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Switch off the security rule with this ID in the Security rules section below: enter the security rule ID (digits only) into the Security rule IDs field and click OK.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity Log File',
    'web-app-firewall.auditLogListLink' => 'Logs Archive',
    'web-app-firewall.errorLogSection' => 'Error log',
    'web-app-firewall.errorLogSectionHint' => 'A website can stop functioning as expected after you change the web application firewall mode to On from Off or Detection only. In this case, analyze the error log to find out what is happening. You can switch off too restrictive security rules or adjust the website.',
    'web-app-firewall.errorLogViewLink' => 'Error Log File',
    'web-app-firewall.notificationStateEnabled' => 'Plesk UI notifications on rule set updates are turned on. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Plesk UI notifications on rule set updates are turned off. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Manage them on the notification page',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Selecting the "Tradeoff" or "Thorough" options may cause WordPress sites to malfunction, among other unwanted side effects, because of the following <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity issue</a>.',
];
