<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "File di registro",
    'action-log.fromDate' => "Da:",
    'action-log.toDate' => "A:",
    'action-log.clearLog' => "Azzera Log",
    'action-log.downloadLog' => "Scarica",
    'action-log.loggedActions' => "Azioni registrate nel log",
    'action-log.storeLogsInDb' => "Salva i record nel database",
    'action-log.storeNumber' => "Voci",
    'action-log.dontRemoveRecs' => "Non cancellate i record",
    'action-log.confirmCleanLog' => "Eliminare i record del log di azioni selezionati?",
    'action-log.incorrectDate' => "Data specificata non valida",
    'action-log.incorrectNumPeriods' => "Periodo di rotazione specificato non valido",
    'action-log.incorrectNumRecords' => "Numero di record specificati non valido",
    'action-log.yes' => "Sì",
    'action-log.no' => "Nessuno",
    'action-log.mixed' => "(misto)",
    'action-log.period' => "Periodo",
    'action-log.invalidDatePeriod' => "Periodo di tempo non valido",
    'action-log.submitDone' => "Le modifiche nelle impostazioni di registro di azioni sono state salvate.",
    'action-log.clearDone' => "Il registro delle azioni è stato eliminato.",
    'action-log.periodDay' => "giorni",
    'action-log.periodWeek' => "settimane",
    'action-log.periodMonth' => "mesi",

    'admin-info.adminInfoSection' => 'Informazione per l\'amministratore',
    'admin-info.description-admin' => 'Descrizione dell\'amministratore',
    'admin-info.description-reseller' => 'Descrizione del rivenditore',
    'admin-info.description-owner' => 'Descrizione del proprietario',
    'admin-info.description' => 'Descrizione',
    'admin-info.descriptionSuccess' => 'La descrizione è stata aggiornata.',
    'admin-info.longDescription' => 'La descrizione specificata è troppo lunga.Non può contenere più di %%max%% simboli.',
    'admin-info.add' => 'Aggiungi descrizione',
    'admin-info.edit' => 'Modifica',
    'admin-info.remove' => 'Elimina',
    'admin-info.confirmOnRemove' => 'Rimuovere questo abbonamento?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% del cliente %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% del cliente %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% dell\'abbonamento %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% di %%name%%',
    'admin-info.popupHint-admin' => 'Questa descrizione è visibile solo all\'amministratore.',
    'admin-info.popupHint-reseller' => 'Questa descrizione è visibile al rivenditore e all\'amministratore.',
    'admin-info.popupHint-owner' => 'Questa descrizione è visibile al suo autore e al provider di hosting dell\'autore.',
    'admin-info.customerDescriptionHint' => 'I clienti non possono visualizzare questa descrizione.',
    'admin-info.subscriptionDescriptionHint' => "Questa informazione è visibile soltanto al provider di hosting (amministratore o rivenditore Plesk).",

    'apache-settings.formGeneralHint' => 'In questa sezione è possibile specificare le impostazioni del server web Apache per questo sito web. La configurazione Apache personalizzata è utile, ad esempio, quando si desidera usare un nuovo tipo di file indice sul sito web o associare un certo tipo MIME con determinate estensioni del filename. Il valore predefinito significa che Apache userà la direttiva corrispondente dalla configurazione del suo server. Se Apache è in esecuzione con nginx come server di frontend, sarà possibile specificare le impostazioni di nginx anche in questa pagina.',
    'apache-settings.general' => 'Impostazioni Apache comuni',
    'apache-settings.example' => "Ad esempio:\n%%example%%",
    'apache-settings.settingOn' => 'Attivato',
    'apache-settings.settingOff' => 'Disattivato (predefinito)',
    'apache-settings.settingDefault' => 'Predefinito',
    'apache-settings.settingCustom' => 'Inserisci valore personalizzato',
    'apache-settings.mimeTypes' => 'Tipi MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'I tipi MIME sono estensioni di file associati a tipi di file. Normalmente sono usati per creare un\'estensione di file personalizzata per i tipi di file comuni.',
    'apache-settings.handlers' => 'Gestori',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "I gestori Apache definiscono il modo in cui il server web elabora i file con alcune estensioni quando vengono richieste. Per esempio, la stringa 'php-script .script' significa che Apache gestirà i file .script come script php.",
    'apache-settings.deny' => 'Nega accesso al sito',
    'apache-settings.allow' => 'Esclusione',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nGli host e le reti indicati non possono accedere al sito. Usa '*' per negare tutte le connessioni.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nGli host e le reti indicati possono accedere al sito.",
    'apache-settings.directoryIndex' => 'File indice',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache cercherà i file specificati quando sarà richiesta la pagina indice del sito.",
    'apache-settings.expires' => 'Expires (Scade)',
    'apache-settings.expiresStaticOnly' => 'risposta con intestazioni Scade solo per file statici',
    'apache-settings.expiresFullDescription' => 'Il server web aggiungerà alle pagine web le intestazioni di risposta “Scade”. Il timestamp di scadenza si ottiene aggiungendo l’intervallo di tempo sopra specificato all’orario in cui viene richiesta una pagina web.',
    'apache-settings.expiresStaticOnlyDescription' => 'L’intestazione “Scade” viene aggiunta esclusivamente ai file statici. I file considerati statici dipendono dalle opzioni “Elaborazione intelligente di file statici” e “Servire file statici direttamente da nginx”.',
    'apache-settings.expiresUnitDays' => 'giorni',
    'apache-settings.expiresUnitHours' => 'ore',
    'apache-settings.expiresUnitMinutes' => 'minuti',
    'apache-settings.expiresUnitSeconds' => 'secondi',
    'apache-settings.headers' => 'Intestazioni aggiuntive',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Il server Web aggiungerà le intestazioni di risposta HTTP specificate.",
    'apache-settings.restrictFollowSymLinks' => 'Limita la capacità di seguire link simbolici',
    'apache-settings.restrictFollowSymLinksDescription' => "Seleziona questa opzione per evitare che gli utenti usino la direttiva FollowSymLink in .htaccess e migliora la sicurezza del server.",
    'apache-settings.nginx' => 'impostazioni nginx',
    'apache-settings.nginxProxyMode' => 'Modalità proxy',
    'apache-settings.nginxProxyModeDescription' => 'Nginx invia richieste tramite proxy ad Apache. Disattivare per interrompere l\'utilizzo di Apache.',
    'apache-settings.nginxTransparentMode' => 'Elaborazione intelligente di file statici',
    'apache-settings.nginxTransparentModeDescription' => 'Se disattivata, Apache elaborerà tutte le richieste per i file statici. nginx non passerà richieste e risposte senza modifica. Disattiva questa opzione unicamente per risolvere problemi.',
    'apache-settings.nginxServeStatic' => 'Servi file statici direttamente da Nginx',
    'apache-settings.nginxStaticExtensions' => 'Indica le estensioni di file separate da spazi o dal simbolo "|". Le richieste per questi file saranno gestite da nginx e non raggiungeranno mai Apache. Attenzione: Le regole di sovrascrittura Apache non verranno applicate.',
    'apache-settings.nginxServePhp' => 'Elabora PHP da nginx',
    'apache-settings.nginxServePhpDescription' => 'I file PHP (.php) saranno gestiti da nginx e PHP-FPM. Se disattivato, i file PHP verranno elaborati da Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Dimensione massima consentita per il corpo delle richieste HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Le richieste con corpo superiore al limite saranno scartate con HTTP 413 Payload Too Large (configura il valore della direttiva nginx "client_max_body_size").',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'L\'opzione è disattivata globalmente tramite un valore vuoto/zero della direttiva "clientMaxBodySize" in panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Abilitare la memorizzazione nella cache nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'La memorizzazione nella cache potrebbe ridurre il tempo di risposta del sito Web e il carico del server, ma è necessario utilizzarla con attenzione.',
    'apache-settings.nginxCacheSize' => 'Dimensione della Cache',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Timeout cache',
    'apache-settings.nginxCacheTimeoutDays' => 'giorni',
    'apache-settings.nginxCacheTimeoutHours' => 'ore',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minuti',
    'apache-settings.nginxCacheTimeoutSeconds' => 'secondi',
    'apache-settings.nginxCacheKey' => 'Chiave cache',
    'apache-settings.nginxCacheCookies' => 'Richieste cache con cookie',
    'apache-settings.nginxCacheBypassLocations' => 'Disabilita cache per ubicazioni',
    'apache-settings.nginxCacheBypass' => 'Bypassa cache quando',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Intestazioni no-cache HTTP ricevute nella richiesta',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Intestazioni di autorizzazione HTTP ricevute nella richiesta',
    'apache-settings.nginxCacheBypassGetNocache' => 'Parametro no-cache GET ricevuto nella richiesta',
    'apache-settings.nginxCacheUseStale' => 'Restituisci record della cache obsoleti',
    'apache-settings.nginxCacheUseStale5xx' => 'Errore server 5xx restituito a monte',
    'apache-settings.nginxCacheUseStale4xx' => 'Errore client 4xx restituito a monte',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Aggiornamento della cache in corso',
    'apache-settings.additional' => 'Direttive Apache aggiuntive',
    'apache-settings.additionalSettingsDescription' => 'Se non puoi trovare determinate impostazioni, aggiungile ai campi sottostanti. Queste impostazioni sovrascriveranno le direttive Apache dell\'intero server. Le direttive dal primo campo vengono usate quando un visitatore accede al sito su HTTP. Il secondo campo contiene le direttive per HTTPS. Normalmente, è necessario aggiungere le direttive a entrambi i campi. Usa la stessa sintassi usata per httpd.include. Per esempio, se desideri configurare una pagina di errore personalizzata, aggiungi la riga: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Direttive aggiuntive per HTTP',
    'apache-settings.additionalSslSettings' => 'Direttive aggiuntive per HTTPS',
    'apache-settings.additionalSettingsError' => 'Configurazione Apache non valida: %%error%%',
    'apache-settings.rollbackFailed' => 'Impossibile usare il corrente file di configurazione Apache e ripristinare la versione precedente del file perché contiene una configurazione non valida.',
    'apache-settings.additionalNginx' => 'Direttive Nginx aggiuntive',
    'apache-settings.additionalNginxSettingsDescription' => 'In questa sezione è possibile indicare le impostazioni per il server proxy Nginx inverso che gira di fronte ad Apache. Le tue direttive sovrascriveranno la configurazione Nginx dell\'intero server. Ad esempio, potrebbe essere utile cambiare il timeout di connessione o comprimere richieste con gzip. Usa la stessa sintassi usata per nginx.conf. Ad esempio, se desideri comprimere tutte le richieste di proxy con gzip, aggiungi la riga: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Direttive Nginx aggiuntive',
    'apache-settings.additionalNginxSettingsError' => 'Configurazione Nginx non valida: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Impossibile usare il corrente file di configurazione Nginx e ripristinare la versione precedente del file perché contengono entrambi una configurazione non valida.',
    'apache-settings.clearCache' => 'Svuota cache',
    'apache-settings.clearCacheHint' => 'Svuota cache nginx per %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'La cache è stata svuotata correttamente',

    'backup.backup-password-protection.securitySettingsSection' => 'Impostazioni di sicurezza di backup',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Ottieni password da impostazioni di archiviazione remota',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Inserisci password manualmente.',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Fornisci password',
    'backup.backup-password-protection.backupPassword' => 'Password',
    'backup.backup-password-protection.inputPasswordType' => 'Tipo di password',
    'backup.backup-password-protection.confirmBackupPassword' => 'Ripeti la password',
    'backup.backup-password-protection.backupPasswordHint' => 'Se hai dimenticato la password, deseleziona questa opzione. Tieni presente che in questo caso, alcuni dati sensibili non verranno ripristinati correttamente. Ad esempio, le password utente verranno sostituite con password casuali, le informazioni sulle app APS già installate verranno perse e così via.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Se hai usato la protezione da password per questo backup, inserisci la password nei campi sottostanti. Tieni presente che se inserisci una password non valida, Plesk non ripristinerà il backup. Invece, il backup verrà copiato sull\'archivio locale.',

    'backup.conflict-database.dbMappingLegend' => 'Mappatura del server del database',
    'backup.conflict-database.serverType' => 'Tipo di server',
    'backup.conflict-database.hostName' => 'Nome host',
    'backup.conflict-database.port' => 'Porta',
    'backup.conflict-database.destinationDbServer' => 'Server del database di destinazione',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Il database non può essere ripristinato: nessun server database adatto presente.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Caricare File di Mappatura IP',
    'backup.conflict-ip.ipMappingLegend' => 'Mappatura IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Salvare la Mappatura IP Attuale al File',
    'backup.conflict-ip.ipAddressNotFound' => 'Nessun indirizzo IP libero di questo tipo.',
    'backup.conflict-ip.sharedIp' => 'condiviso',
    'backup.conflict-ip.dedicatedIp' => 'dedicato',
    'backup.conflict-ip.fileNotFound' => 'Il file non deve essere vuoto.',
    'backup.conflict-ip.invalidIpToMap' => 'Un valore non valido per un vecchio indirizzo IP: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Un valore non valido per un nuovo indirizzo IP: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'L\'indirizzo IP %%ip%% non è stato trovato nel database.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Carica un file di mappatura IP',
    'backup.conflict-ip.ipMappingFileHint' => 'Un file di mappatura IP è un file di testo semplice. Ogni linea di questo file contiene una mappatura IP nel formato: <vecchio indirizzo IP> <nuovo indirizzo IP>',
    'backup.conflict-ip.oldIp' => 'Vecchi indirizzi IP',
    'backup.conflict-ip.newIp' => 'Nuovi indirizzi IP',

    'backup.copy-to-server.ignoreBackupSign' => 'Carica file di backup senza una firma valida',
    'backup.copy-to-server.wrongPassword' => 'La password specificata non è valida. Durante il ripristino del backup, Plesk richiederà di inserire la password nuovamente.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Il file di backup caricato %%fileName%% è stato modificato, è danneggiato o è stato creato su un altro server o versione Plesk precedente che non supporta la firma di backup. Prima di ripristinare dati da questo file di backup, accertati che la sorgente di questo file sia affidabile.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Impossibile caricare il file di backup %%fileName%%. Il file contiene dati modificati o danneggiati, è stato creato su un altro server o in una versione Plesk precedente. Contatta il tuo provider di hosting per ripristinare i dati da questo file.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Impossibile caricare il file di backup %%fileName%%. Il file è stato modificato, è danneggiato, creato su un altro server o in una versione di Plesk precedente che non supporta la firma di backup. Se il backup è considerato affidabile, seleziona l\'opzione "Carica file di backup senza firme valide" ed esegui il caricamento nuovamente.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Impossibile spostare il backup selezionato %%fileName%% verso l'archivio del server. Errore: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Le seguenti parti dei backup incrementali non sono state copiate:%%endl%%%%missedParts%%%%endl%%Copiare le parti mancanti.",

    'backup.ftp-settings.isActive' => 'Usa l\'archiviazione FTP(S)',
    'backup.ftp-settings.host' => 'Hostname o IP del server FTP',
    'backup.ftp-settings.directory' => 'Directory per l\'archiviazione di file di backup',
    'backup.ftp-settings.directoryHint' => 'Per esempio, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Nome utente FTP',
    'backup.ftp-settings.ftpPassword' => 'Password FTP',
    'backup.ftp-settings.usePassiveMode' => 'Usare modalità passiva',
    'backup.ftp-settings.useFtps' => 'Usa FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'L\'utilizzo del server FTP di Plesk locale come un archivio remoto è proibito. Specificare una ubicazione remota.',
    'backup.ftp-settings.warningHostIsLocal' => 'Le impostazioni di archivio FTP(s) sono state configurate per archiviare backup sul server dove si trovano i file degli abbonamenti. Una configurazione di questo tipo non è consigliata a causa del rischio della perdita di dati e del sovrautilizzo dello spazio su disco.',
    'backup.ftp-settings.enterFtpLogin' => 'Inserisci un nome utente corretto.',
    'backup.ftp-settings.enterFtpPassword' => 'Inserisci una password corretta.',

    'backup.remote-settings.isActive' => 'Usa archivio',
    'backup.remote-settings.initError' => 'Impossibile inizializzare la pagina delle impostazioni %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Impostazioni di sicurezza di backup',

    'backup.restore.detailsSection' => 'Dettagli',
    'backup.restore.contentInfoSection' => 'Contenuto del backup',
    'backup.restore.restorationOptionsSection' => 'Opzioni di ripristino',
    'backup.restore.emailNotification' => 'Una volta completato il ripristino, inviare una notifica a',
    'backup.restore.comments' => 'Commenti',
    'backup.restore.creationDate' => 'Data di creazione',
    'backup.restore.systemNotes' => 'Note di sistema',
    'backup.restore.ownerAdmin' => 'Creato dall\'amministratore.',
    'backup.restore.ownerReseller' => 'Creato da un rivenditore.',
    'backup.restore.ownerCustomer' => 'Creato dal cliente.',
    'backup.restore.ownerServiceUser' => 'Creato da un utente aggiuntivo.',
    'backup.restore.partOfParentBackup' => 'Parte del backup di %%type%%.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'rivenditore',
    'backup.restore.client' => 'cliente',
    'backup.restore.incremental' => 'Incrementale.',
    'backup.restore.multiVolume' => 'Multi-volume.',
    'backup.restore.backupSize' => 'Dimensione di backup',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (questa aggiunta) + %%base%% (backup iniziale) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (questa aggiunta) + %%prev%% (aggiunte precedenti) + %%base%% (backup iniziale) = %%total%%',
    'backup.restore.download' => 'Scarica',
    'backup.restore.downloadHint' => 'Scarica il file di backup sul computer locale.',
    'backup.restore.downloadDisabled' => 'Download dei file di backup temporaneamente non disponibile. Riprova più tardi o contatta il tuo service provider.',
    'backup.restore.copy' => 'Copia nell\'archivio del server',
    'backup.restore.copyHint' => 'Copia i file di backup selezionati nell\'archivio del server.',
    'backup.restore.contentInfo' => 'Il backup contiene',
    'backup.restore.restoreButton' => 'Ripristina',
    'backup.restore.mail' => 'Posta',
    'backup.restore.domainConfiguration' => 'Configurazione del dominio',
    'backup.restore.virtualHost' => 'Contenuto dell\'host virtuale',
    'backup.restore.database' => 'Database',
    'backup.restore.serverConfiguration' => 'Impostazioni del server',
    'backup.restore.serverConfigurationLicense' => 'Chiave di licenza',
    'backup.restore.serverPersonalConfiguration' => 'Configurazione dell\'account dell\'Amministratore',
    'backup.restore.serverPersonalDomains' => 'Domini dell\'Amministratore',
    'backup.restore.serverPersonalClients' => 'Clienti dell\'Amministratore',
    'backup.restore.resellers' => 'Rivenditori',
    'backup.restore.resellerPersonalConfiguration' => 'Configurazione dell\'account rivenditore',
    'backup.restore.resellerPersonalDomains' => 'Domini del rivenditore',
    'backup.restore.resellerPersonalClients' => 'Clienti del rivenditore',
    'backup.restore.clientPersonalConfiguration' => 'Configurazione dell\'account cliente',
    'backup.restore.clientPersonalDomains' => 'Domini del cliente',
    'backup.restore.restoreModifiedSection' => 'Ripristina il file di backup, nonostante la firma danneggiata',
    'backup.restore.restoreModifiedDump' => 'Ripristina questo backup indipendentemente dal fatto che non disponga di una firma valida',
    'backup.restore.resolutionPolicy' => 'Criteri di risoluzione',
    'backup.restore.resolutionPolicyDescription' => 'I conflitti di sincronizzazione oraria avvengono quando l\'oggetto ripristinato è già presente nel sistema con una data di modifica più recente oppure quando l\'oggetto ripristinato non è attualmente presente nel sistema.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'La password specificata non è valida. Il file di backup verrà copiato sull\'archivio locale del server.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Impossibile ripristinare il backup. La password specificata non è valida.',
    'backup.restore.serverContentAndConfiguration' => 'Configurazione e contenuto del server',
    'backup.restore.serverConfigurationOnly' => 'Configurazione Server',
    'backup.restore.resellerContentAndConfiguration' => 'Configurazione e contenuto dell\'account rivenditore',
    'backup.restore.resellerConfigurationOnly' => 'Configurazione dell\'account rivenditore',
    'backup.restore.clientContentAndConfiguration' => 'Configurazione e contenuto dell\'account cliente.',
    'backup.restore.clientConfigurationOnly' => 'Configurazione dell\'account cliente',
    'backup.restore.domainContentAndConfiguration' => 'Configurazione e contenuto del dominio',
    'backup.restore.domainConfigurationOnly' => 'Configurazione del dominio',
    'backup.restore.restoreType' => 'Cosa vuoi ripristinare?',
    'backup.restore.restoreTypeFull' => 'Tutti gli oggetti (intero sistema)',
    'backup.restore.restoreTypeGranular' => 'Oggetti selezionati',
    'backup.restore.restoreObjectType' => 'Tipo di oggetto da ripristinare',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Abbonamento',
    'backup.restore.restoreObjectTypeCustomers' => 'Cliente',
    'backup.restore.restoreObjectTypeResellers' => 'Rivenditore',
    'backup.restore.restoreObjectTypeMailUsers' => 'Account di posta',
    'backup.restore.restoreObjectTypeDatabases' => 'Database',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificati SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Siti',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zona DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Liste di posta',
    'backup.restore.restoreObjectTypeWebContent' => 'File di domini',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'File selezionati',
    'backup.restore.restoreSubscriptionLookup' => 'Abbonamento',
    'backup.restore.restoreComponents' => 'Componenti da ripristinare',
    'backup.restore.errorLog' => 'Log di errore',
    'backup.restore.backupDetailsLogDoesntExist' => 'Il log di backup non è disponibile.',
    'backup.restore.dumpFailedSection' => 'Log di Errore',
    'backup.restore.dumpFailed' => 'Impossibile ripristinare dati: Il file di backup non è valido.',
    'backup.restore.granularNotSupported' => 'È possibile selezionare oggetti da ripristinare soltanto quando si esegue il ripristino dai backup che sono stati creati in Plesk 12.0 o versioni successive.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Il ripristino di tutti i dati dai backup non è supportato nella modalità di visualizzazione Power User del rivenditore. Seleziona gli oggetti per il ripristino. È possibile cambiare la visualizzazione dell\'interfaccia in %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Preferenze dell\'interfaccia',
    'backup.restore.contentRestoreType' => 'Ripristina',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Soltanto la configurazione degli oggetti selezionati',
    'backup.restore.contentRestoreTypeFull' => 'Configurazione e contenuti degli oggetti selezionati',
    'backup.restore.errorWrongFormat' => 'Impossibile ripristinare il backup: il file contiene errori di formattazione.',
    'backup.restore.errorContentError' => 'Impossibile ripristinare il tutti i dati: il backup presenta errori di contenuto.',
    'backup.restore.warningSignError' => 'Impossibile convalidare la firma di backup. Il file di backup potrebbe essere modificato, danneggiato, creato su un altro server o in una versione Plesk precedente.',
    'backup.restore.warningSignErrorNotAdmin' => 'Questo backup può essere ripristinato dall\'amministratore Plesk unicamente.',
    'backup.restore.warningPartial' => "Le seguenti parti del backup incrementale non sono state trovate:%%endl%%%%missedParts%%%%endl%%Probabilmente non tutti i file sono stati ripristinati. Carica le parti mancanti e riprova il ripristino.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Il backup che stai cercando di ripristinare è stato creato in una versione di Plesk non supportata e non può essere ripristinato. Utilizza l\'estensione Plesk Migrator per trasferire dati dalle versioni di Plesk precedenti.',
    'backup.restore.encryptionKeyError' => 'Le password per uno o più account in questo backup non possono essere ripristinati e saranno reimpostati. Probabilmente questo backup è stato creato su un server Plesk diverso e crittografato con la sua chiave di crittografia.',
    'backup.restore.errorCorruptedContent' => 'I seguenti file non sono stati trovati o sono danneggiati: ',
    'backup.restore.statusSection' => 'Stato di backup',
    'backup.restore.statusDetails' => 'Dettagli dello stato',
    'backup.restore.restoreBlocked' => 'Non è possibile ripristinare il backup.',
    'backup.restore.restoreBlockedDescription' => 'Non è possibile ripristinare ora il backup del tipo %%backupType%%. Per ripristinarlo, accedi come titolare del backup e clicca questo nome di backup nel Backup Manager.',

    'backup.schedule.scheduleSection' => 'Pianifica',
    'backup.schedule.backupEnable' => 'Attiva quest\'attività di backup',
    'backup.schedule.backupPeriod' => 'Esegui questa attività di backup',
    'backup.schedule.on' => 'Attivo',
    'backup.schedule.at' => 'a',
    'backup.schedule.useIncremental' => 'Usa backup incrementale',
    'backup.schedule.fullBackupPeriod' => 'Esegui backup completo',
    'backup.schedule.daily' => 'Ogni giorno',
    'backup.schedule.weekly' => 'Settimanalmente',
    'backup.schedule.monthly' => 'Mensile',
    'backup.schedule.yearly' => 'Annuale',
    'backup.schedule.days' => 'giorni',
    'backup.schedule.weeks' => 'settimane',
    'backup.schedule.months' => 'mesi',
    'backup.schedule.years' => 'anni',
    'backup.schedule.backupTimeDescription' => 'Fuso orario: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Fuso orario di sistema predefinito',
    'backup.schedule.first' => 'primo',
    'backup.schedule.last' => 'Ultimo',
    'backup.schedule.dayOfMonth' => 'giorno',
    'backup.schedule.email' => 'Se si verificano errori durante l\'esecuzione di quest\'attività di backup, inviare una notifica per posta elettronica a',
    'backup.schedule.invalidFields' => 'Alcuni campi sono vuoti o contengono un valore non valido: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Numero massimo di file di backup completi da archiviare (inclusi i backup pianificati e manuali)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Lascia questo campo vuoto se non vuoi rimuovere i backup completi automaticamente.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Il limite specificato dal provider di hosting per l’archivio sul server è %%max%%. Il tuo limite deve essere inferiore o pari a %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'La memorizzazione dei backup dell\'abbonamento pianificati in un archivio remoto sul cloud è una funzionalità Premium che deve essere acquistata nel negozio online di Plesk.',

    'backup.secure-backup.hint' => 'Puoi utilizzare una password con cui crittografare le password degli utenti contenute nel database di Plesk in un backup. Ricorda che se un backup protetto da password viene ripristinato senza fornire tale password, Plesk genera le password degli utenti casualmente.',
    'backup.secure-backup.hintAdmin' => 'Puoi crittografare le password del database di Plesk contenute nei backup con la chiave di crittografia di Plesk o con una password. La chiave è unica per ogni installazione di Plesk. I backup crittografati con la chiave possono essere ripristinati solo nell\'installazione di Plesk dove sono stati creati e non possono essere ripristinati in un\'altra installazione di Plesk. Tieni presente che Plesk non protegge tutti i dati sensibili in un backup. Si consiglia di archiviare i backup in un archivio remoto sul cloud e di abilitare la crittografia del backup nell\'archivio sul cloud.',
    'backup.secure-backup.usePasswordProtection' => 'Usa protezione password (consigliato)',
    'backup.secure-backup.backupPasswordSource' => 'Tipo di password',
    'backup.secure-backup.pleskKey' => 'Chiave di crittografia Plesk',
    'backup.secure-backup.userPassword' => 'Password specificata',
    'backup.secure-backup.password' => 'Password',
    'backup.secure-backup.passwordConfirmation' => 'Ripeti la password',

    'backup.subform.settingsSection' => 'Impostazioni di backup',
    'backup.subform.prefix' => 'Aggiungi un prefisso al nome del backup',
    'backup.subform.comment' => 'Commenti',
    'backup.subform.splitSize' => 'Crea un backup multivolume, dimensione volume (MB)',
    'backup.subform.repository' => 'Archivia in',
    'backup.subform.repositoryDescription' => 'Le impostazioni dell\'archivio FTP(S) non sono state specificate. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Sia archivio sul server e %%name%%',
    'backup.subform.remoteRepository' => 'archivio remoto',
    'backup.subform.remoteRepositoryText' => 'Seleziona archivio remoto nel cloud',
    'backup.subform.configureRemoteRepositories' => 'Puoi <a href="%%url%%">configurare archivi remoti</a> per conservare i backup nel cloud',
    'backup.subform.configureFtpRepository' => 'Puoi <a href="%%url%%">configurare l’archivio FTP</a> per conservarvi i backup',
    'backup.subform.repositoryConfigure' => 'Configura',
    'backup.subform.email' => 'Dopo il completamento di un backup, inviare una notifica per posta elettronica a',
    'backup.subform.contentSection' => 'Contenuto del backup',
    'backup.subform.domainConfiguration' => 'Configurazione',
    'backup.subform.domainConfigurationVhost' => 'File utente e database',
    'backup.subform.domainConfigurationMail' => 'Messaggi di posta',
    'backup.subform.content' => 'Esegui backup',
    'backup.subform.backupAll' => 'Tutta la configurazione e il contenuto',
    'backup.subform.backupConfiguration' => 'Solo configurazione',
    'backup.subform.backupVhost' => 'Tutta la configurazione e il contenuto, tranne i messaggi di posta',
    'backup.subform.backupMail' => 'Solo configurazione e messaggi di posta',
    'backup.subform.mssqlNativeBackup' => 'Usa la funzionalità di backup MS SQL nativa, se possibile',
    'backup.subform.mssqlNativeBackupAdmin' => 'Usa la funzionalità di backup MS SQL nativa (Per database remoti, accertati di aver configurato le impostazioni di backup del server MS SQL remoto in Strumenti & Impostazioni > Server database)',
    'backup.subform.localRepository' => 'Archivio del server',
    'backup.subform.localRepositoryPath' => 'Archiviazione del server in %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Archivio FTP(S) in %%uri%% <a href="%%link%%">Modifica impostazioni</a>',
    'backup.subform.ftpRepositoryText' => 'Archivio FTP(S) in %%uri%%',
    'backup.subform.type' => 'Tipo',
    'backup.subform.typeFullBackup' => 'Completo',
    'backup.subform.typeIncremental' => 'Incrementale',
    'backup.subform.typeIncrementalDescription' => 'Fai il backup dei dati web e di hosting di posta che sono cambiati rispetto all\'ultimo backup (il backup dei database è sempre completo).',
    'backup.subform.incrementalNotAvailable' => 'Per creare backup incrementali, prima crea un backup completo.',
    'backup.subform.excludeLogs' => 'Escludi i file di registro',
    'backup.subform.excludeFiles' => 'Escludi file specifici dal backup',
    'backup.subform.excludeFilesDescription' => 'È possibile escludere file solo negli spazi web. Specifica il percorso o i percorsi relativi alla directory principale dello spazio web, separando i singoli file tramite la virgola. È consentito utilizzare il simbolo della maschera (ad es., /somedir/log*).',

    'backup.upload.uploadHint' => 'In questa sezione è possibile caricare file di backup nell\'archivio di Plesk. La dimensione massima dei file è limitata a due gigabyte.',
    'backup.upload.backupFile' => 'File di backup',
    'backup.upload.removeLink' => 'Rimuovi',
    'backup.upload.addFileLink' => 'Carica più file',
    'backup.upload.backupSecuritySettings' => 'Impostazioni di sicurezza di backup',
    'backup.upload.signatureHint' => 'Plesk verifica l\'esistenza di una struttura e una firma valida nei file di backup. I file che sono stati modificati, danneggiati o creati su un altro server non sono affidabili. L\'opzione seguente consente di ripristinare dati dai file di questo genere. Seleziona questa opzione unicamente se ritieni affidabile la sorgente di backup, poiché caricare tale file potrebbe compromettere la sicurezza o interrompere il funzionamento del server. Nota: I file di backup creati nelle versioni Plesk precedenti a 11.5 non sono considerate affidabili poiché non dispongono di firme. Accertati di ripristinare tali file unicamente se la loro sorgente è affidabile.',
    'backup.upload.ignoreSign' => 'Carica file di backup senza una firma valida',
    'backup.upload.passwordHint' => 'Se hai usato la protezione da password per questo backup, inserisci la password nei campi sottostanti. Tieni presente che se inserisci una password non valida, Plesk ti avvertirà ma caricherà comunque il backup sul server.Durante il ripristino del backup, ti verrà richiesto di inserire la password nuovamente.',
    'backup.upload.alreadyExistsWarning' => 'Il file di backup %%fileName%% esiste già nell\'archivio locale del server.',
    'backup.upload.incorrectPasswordWarning' => 'La password specificata non è valida. Durante il ripristino del backup, Plesk richiederà di inserire la password nuovamente.',
    'backup.upload.deprecatedDumpError' => 'Il backup che stai cercando di caricare è stato creato in una versione di Plesk non supportata e non può essere importato. Utilizza l\'estensione Plesk Migrator per trasferire dati dalle versioni di Plesk precedenti.',
    'backup.upload.mailFormatWarning' => 'Il file di backup %%fileName%% è stato caricato nell\'archivio. Importante: Il file di backup %%fileName%% contiene contenuto di posta che non sarà archiviato perché il suo formato (Plesk 8.3 - 8.6) non è supportato. Per essere in grado di ripristinare il contenuto della posta, esegui il relativo backup mediante lo strumento di creazione di backup di Plesk, seleziona l\'opzione Esegui backup del contenuto delle caselle postali e poi scegli l\'opzione con il dump ripristinato in qualsiasi server di posta.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Il file di backup caricato (%%fileName%%) è stato modificato, è danneggiato, creato su un altro server o in una versione Plesk precedente, che non supporta la firma di backup. Prima di ripristinare i dati da questo file di backup, accertati che la sua sortente sia affidabile.',
    'backup.upload.corruptedSignatureAdminError' => 'Impossibile caricare il file di backup (%%fileName%%). Il file è stato modificato, è danneggiato, creato su un altro server o in una versione di Plesk precedente che non supporta la firma di backup. Se il backup è considerato affidabile, seleziona l\'opzione "Carica file di backup senza firme valide" ed esegui il caricamento nuovamente.',
    'backup.upload.corruptedSignatureUserWarning' => 'Il file di backup caricato (%%fileName%%) contiene dati modificati o danneggiati, è stato creato su un altro server o in una versione Plesk precedente.',
    'backup.upload.corruptedSignatureUserError' => 'Impossibile caricare il file di backup (%%fileName%%). Il file contiene dati modificati o danneggiati, è stato creato su un altro server o in una versione Plesk precedente. Contatta il tuo provider di hosting per ripristinare i dati da questo file.',
    'backup.upload.uploadError' => 'Impossibile caricare %%fileName%% sull\'archivio del server: %%error%%',
    'backup.upload.fileNotSelected' => 'Nessun file selezionato per il caricamento. Seleziona almeno un file.',
    'backup.upload.missedPartsWarning' => "Le seguenti parti del backup incrementale non sono state caricate:%%endl%%%%missedParts%%%%endl%%Caricare le parti mancanti.",
    'backup.upload.unknownType' => 'Tipo di oggetto sconosciuto',
    'backup.upload.storageLink' => 'un\'altra archiviazione',
    'backup.upload.anotherStorage' => 'Il dump è stato caricato su %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Il rivenditore %%name%% non è stato trovato. Si consiglia di crearlo prima per ripristinare il dump caricato.',
    'backup.upload.clientNotFound' => 'Il cliente %%name%% non è stato trovato. Si consiglia di crearlo prima per ripristinare il dump caricato.',
    'backup.upload.domainNotFound' => 'Il dominio %%name%% non è stato trovato. Si consiglia di crearlo prima per ripristinare il dump caricato.',

    'backup.web-content-dynamic.addButtonTitle' => 'Aggiungi file',
    'backup.web-content-dynamic.noItems' => 'Nessun file selezionato.',
    'backup.web-content-dynamic.hint' => 'Usa caselle di controllo per selezionare file e cartelle.',
    'backup.web-content-dynamic.title' => 'Seleziona file',
    'backup.web-content-dynamic.columnName' => 'Nome',
    'backup.web-content-dynamic.columnChangeDate' => 'Modificato',
    'backup.web-content-dynamic.columnSize' => 'Dimensione',
    'backup.web-content-dynamic.columnPermissions' => 'Permessi',
    'backup.web-content-dynamic.columnUser' => 'Utente',
    'backup.web-content-dynamic.columnGroup' => 'Gruppo',
    'backup.web-content-dynamic.waitButtonTitle' => 'Attendere, prego',
    'backup.web-content-dynamic.loadingTitle' => 'Attendere, prego. Caricamento in corso...',

    'backup.invalidFields' => 'Alcuni campi sono vuoti o contengono un valore non valido.',
    'backup.notEnoughDiskSpace' => 'Non c\'è abbastanza spazio su disco in %%path%% per la creazione di backup. Sono necessari almeno %%required%% GB di spazio libero (disponibilità: %%available%% GB)',

    'change-subscriptions-owner.infoTitle' => 'Info',
    'change-subscriptions-owner.infoDescription' => '%%total%% iscrizioni, %%active%% iscrizioni attive, %%diskSpace%% spazio su disco usato, %%traffic%% traffico usato',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Possibili nuovi proprietari di abbonamenti',
    'change-subscriptions-owner.selectedSubscriptions' => 'Abbonamenti selezionati',
    'change-subscriptions-owner.subscriptionName' => 'Nome abbonamento',
    'change-subscriptions-owner.ownerName' => 'Nome del proprietario',
    'change-subscriptions-owner.currentIpAddress' => 'L\'indirizzo IP corrente',
    'change-subscriptions-owner.newIpAddress' => 'Nuovo indirizzo IP',
    'change-subscriptions-owner.submit' => 'Nuova assegnazione',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, I/O disco',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Impostare limiti al consumo delle risorse di sistema da parte di un abbonamento. Plesk utilizza una funzionalità kernel Linux denominata gruppi di controllo (cgroup) per assicurare che i limiti non vengano superati.',
    'cgroups-settings.cpuSettings' => 'CPU:',
    'cgroups-settings.cpuSettingsDescription' => 'Limitare i singoli abbonamenti alla quantità specificata di utilizzo della CPU.',
    'cgroups-settings.cpuPeriodLimit' => 'Periodo di verifica dell\'utilizzo della CPU',
    'cgroups-settings.percentUsageDescription' => 'La quantità totale di tempo della CPU equivale a %%total%%%%units%% per il server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limitare i singoli abbonamenti alla quantità specificata di utilizzo della RAM. Tieni presente che se un abbonamento supera questo limite, il processo con il consumo maggiore verrà arrestato.',
    'cgroups-settings.ramPeriodLimit' => 'Periodo di verifica dell\'utilizzo della RAM',
    'cgroups-settings.diskSettings' => 'I/O disco',
    'cgroups-settings.diskReadSettings' => 'Lettura disco',
    'cgroups-settings.diskReadSettingsDescription' => 'Consenti ai singoli abbonamenti di utilizzare la larghezza di banda di lettura disco solo entro il limite specificato.',
    'cgroups-settings.diskReadPeriodLimit' => 'Periodo di verifica dell\'utilizzo della lettura disco',
    'cgroups-settings.diskWriteSettings' => 'Scrittura su disco',
    'cgroups-settings.diskWriteSettingsDescription' => 'Consenti ai singoli abbonamenti di utilizzare la larghezza di banda di scrittura su disco solo entro il limite specificato.',
    'cgroups-settings.diskWritePeriodLimit' => 'Periodo di verifica dell\'utilizzo della scrittura su disco',
    'cgroups-settings.limit' => 'Limite',
    'cgroups-settings.threshold' => 'Notifica al superamento',
    'cgroups-settings.limitNotificationEnabled' => 'Notifica abilitata',
    'cgroups-settings.periodFiveMinutes' => '5 minuti',
    'cgroups-settings.periodHour' => '1 ora',
    'cgroups-settings.periodDay' => '1 giorno (24 ore)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/sec',

    'custom-button.privateLabel' => 'Mostra solo a me',
    'custom-button.textLabel' => 'Etichetta del pulsante',
    'custom-button.tooltipLabel' => 'Testo di aiuto',
    'custom-button.iconLabel' => 'Immagine di sfondo',
    'custom-button.priorityLabel' => 'Priorità',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Aggiungi parametri alla URL',
    'custom-button.placeLabel' => 'Posizione',
    'custom-button.internalLabel' => 'Apri URL in Plesk',
    'custom-button.internalDescription' => 'Indica se aprire la URL su una pagina Plesk oppure in una nuova finestra del browser.',
    'custom-button.noFrameLabel' => 'Non utilizzare frame',
    'custom-button.noFrameDescription' => 'Se aggiungi un pulsante personalizzato che porta ad un\'estensione di Plesk o ad un\'app nel Pannello del Cliente, puoi specificare il modo in cui visualizzare tale estensione/app: in un frame o come parte della GUI di Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Includi ID abbonamento, ID dominio e ID dell\'alias del dominio',
    'custom-button.urlParamLabel_dom_name' => 'Comprende il nome del dominio principale',
    'custom-button.urlParamLabel_ftp_user' => 'Includi nome utente FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Includi password FTP',
    'custom-button.urlParamLabel_cl_id' => 'Includi ID cliente',
    'custom-button.urlParamLabel_cname' => 'Comprende il nome della società del cliente',
    'custom-button.urlParamLabel_pname' => 'Comprende il nome di contatto del cliente',
    'custom-button.urlParamLabel_email' => 'Includi e-mail del cliente',
    'custom-button.buttonPlace_navigation' => 'Accesso comune',
    'custom-button.buttonPlace_admin' => 'Home page Amministratore',
    'custom-button.buttonPlace_admin-settings' => 'Pagina Impostazioni e Strumenti dell\'Amministratore',
    'custom-button.buttonPlace_reseller' => "Home page del rivenditore",
    'custom-button.buttonPlace_reseller-settings' => 'Pagina Utility e Strumenti Rivenditore',
    'custom-button.buttonPlace_client' => 'Home page del cliente',
    'custom-button.buttonPlace_domain' => "Pagina Siti Web e Domini dell'abbonamento",
    'custom-button.buttonPlace_domain_powerUser' => "Pagina Siti Web e Domini dello spazio web",
    'custom-button.buttonPlace_domain-properties' => 'Strumenti del Sito Web',

    'database-server-change-password.adminPassword' => 'Password amministratore',
    'database-server-change-password.success' => 'La password dell\'amministratore è stata aggiornata correttamente.',

    'database-server-create.general' => 'Generale',
    'database-server-create.type' => 'Tipo server database',
    'database-server-create.unixSocket' => '(connessione locale)',
    'database-server-create.host' => 'Nome host o indirizzo IP',
    'database-server-create.port' => 'Numero porta',
    'database-server-create.portDescription' => 'Lascia vuoto per usare il numero della porta predefinito',
    'database-server-create.version' => 'Versione del server database',
    'database-server-create.default' => 'Usa questo server come predefinito per %%type%%',
    'database-server-create.externalConnections' => 'Consenti al server MySQL locale di accettare connessioni esterne',
    'database-server-create.externalConnectionsDescription' => 'La modifica di questa impostazione determina il riavvio del server MySQL locale.Per abilitare l’accesso remoto ad altri server MySQL registrati in Plesk, modifica la loro configurazione manualmente.',
    'database-server-create.authentication' => 'Autenticazione',
    'database-server-create.authenticationAddDescription' => 'Indica le credenziali dell\'amministratore del database che Plesk userà per accedere al server del database. L\'account amministratore con queste credenziali deve essere presente sul server database.',
    'database-server-create.authenticationEditDescription' => 'In questa sezione è possibile cambiare le credenziali che Plesk usa per accedere al server database. Queste credenziali devono corrispondere alle credenziali dell\'amministratore del database. Ad esempio, dopo aver cambiato le credenziali dell\'amministratore sul server database, bisogna cambiarle anche in Plesk.',
    'database-server-create.authenticationChangeDescription' => 'In questa sezione è possibile cambiare le credenziali che Plesk usa per accedere al server database. Se si cambia il nome utente o la password sotto, l\'account utente del database con i diritti amministrativi sarà aggiornato sia sul server database che in Plesk.',
    'database-server-create.adminLogin' => 'Nome utente',
    'database-server-create.adminPassword' => 'Password',
    'database-server-create.createSuccess' => 'Il server database è stato creato.',
    'database-server-create.createError' => 'Il server del database è stato creato con un errore: %%error%%',
    'database-server-create.updateSuccess' => 'Il server database è stato aggiornato.',
    'database-server-create.updateError' => 'Il server del database è stato aggiornato con un errore: %%error%%.',
    'database-server-create.backupSettings' => 'Backup',
    'database-server-create.backupTempDir' => 'Directory temporanea',
    'database-server-create.backupTempDirDescription' => 'Il percorso a una cartella fisica sul server remoto dove si trova il server MS SQL. Il server MS SQL deve essere in grado di accedere a questa cartella per la lettura e la scrittura di file di backup temporanei. Per esempio, C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Directory di rete temporanea',
    'database-server-create.backupNetworkTempDirDescription' => 'Il percorso verso la rete condivisa è stato attribuito alla cartella fisica indicata in precedenza. Plesk accederà alla cartella condivisa per scaricare e caricare file di backup. Per esempio, \\\\NomeServer\\PercorsoDirectory',
    'database-server-create.backupNetworkUser' => 'Nome utente',
    'database-server-create.backupNetworkUserDescription' => 'Il nome utente di un utente di rete creato sul server remoto. Per esempio, ServerName\\UserName. L\'utente deve essere autorizzato ad accedere alla cartella condivisa sopraindicata.',
    'database-server-create.backupNetworkPassword' => 'Password',

    'domain.connection-info.title' => 'Informazioni della connessione',
    'domain.connection-info.systemUserCredentials' => 'Credenziali dell\'utente di sistema',
    'domain.connection-info.systemUserCredentialsHint' => 'L\'accesso tramite FTP è sempre abilitato, l\'accesso tramite SSH o Desktop Remoto è abilitato solo se %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'il permesso è stato concesso',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'L\'accesso tramite SSH o Desktop Remoto è abilitato e non è possibile gestirne lo stato.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'L\'accesso tramite SSH o Desktop Remoto è disabilitato e non è possibile gestirne lo stato.',
    'domain.connection-info.ipAddress' => 'Indirizzo IP',
    'domain.connection-info.copyToClipboard' => 'Copia negli appunti',
    'domain.connection-info.username' => 'Nome utente',
    'domain.connection-info.password' => 'Password',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Modifica della password dell\'utente di sistema',
    'domain.connection-info.changePasswordTooltip' => 'Cambiare Password',
    'domain.connection-info.newPassword' => 'Nuova password',
    'domain.connection-info.manageAccess' => 'Gestisci l\'accesso',
    'domain.connection-info.additionalFtpAccounts' => 'Account FTP aggiuntivi',
    'domain.connection-info.database' => 'Database',
    'domain.connection-info.databaseHint' => '1 database su %%number%% appartiene all\'abbonamento.',
    'domain.connection-info.databaseNotCreatedHint' => 'Database non creato.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Server MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nome del database',
    'domain.connection-info.addDatabase' => 'Aggiungi database',
    'domain.connection-info.manageDatabases' => 'Gestisci database',
    'domain.connection-info.phpMyAdmin' => 'PhpMyAdmin',
    'domain.connection-info.myLittleAdmin' => 'myLittleAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Modifica della password dell\'utente del database',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Non dimenticare di aggiornare la password nei file di configurazione della tua applicazione dopo averla modificata qui.',
    'domain.connection-info.buttonSave' => 'Salva',
    'domain.connection-info.buttonSaving' => 'Salvataggio in corso...',
    'domain.connection-info.buttonCancel' => 'Annulla',

    'domain.move.title' => 'Sposta dominio %%name%%',
    'domain.move.hint' => 'Il dominio verrà spostato in un nuovo abbonamento insieme al proprio contenuto, ai file di configurazione, ai file di registro e alle applicazioni APS.',
    'domain.move.hintMain' => 'Il dominio verrà spostato in un nuovo abbonamento insieme al proprio contenuto, ai file di configurazione, file di registro, database, utenti di database, utenti FTP aggiuntivi, attività pianificate, utenti smb e applicazioni APS.',
    'domain.move.hintSubdomains' => 'Il sottodominio/i sottodomini %%subdomains%% verrà/anno spostato/i insieme al dominio principale.',
    'domain.move.hintAliases' => 'L’alias/gli alias di dominio %%aliases%% verrà/anno spostato/i insieme al dominio principale.',
    'domain.move.hintSubdomainsAndAliases' => 'Il sottodominio/i sottodomini %%subdomains%% e l’alias/gli alias di dominio %%aliases%% verranno spostati insieme al dominio principale.',
    'domain.move.labelDatabases' => 'Una volta spostato il dominio, apri la scheda "Database" per spostare i database associati.',
    'domain.move.hintDatabases' => 'Se necessario, sposta i database separatamente',

    'domain.move.Form.submitButton' => 'Sposta',
    'domain.move.Form.cancelButton' => 'Annulla',

    'domain.move.selectTarget' => 'Abbonamenti disponibili',
    'domain.move.nothingFound' => 'Non è stato trovato nulla',
    'domain.move.targetIsRequred' => 'Seleziona l’abbonamento nel quale spostare il dominio.',
    'domain.move.selectNewSubscription' => 'Crea un nuovo abbonamento',
    'domain.move.ipv4Address' => 'Indirizzi IPv4',
    'domain.move.ipv4AddressHint' => 'L\'indirizzo IP su cui il sito web è ospitato è un indirizzo di rete dell\'host virtuale del sito web.',
    'domain.move.ipv6Address' => 'Indirizzo IPv6',
    'domain.move.ipv6AddressHint' => 'L\'indirizzo IP su cui il sito web è ospitato è un indirizzo di rete dell\'host virtuale del sito web.',
    'domain.move.ipAddressIsNotSelected' => 'Almeno un indirizzo IP deve essere selezionato',
    'domain.move.username' => 'Nome utente',
    'domain.move.usernameHint' => 'L’account dell’utente di sistema associato allo spazio Web. Utilizzato per accedere ai file ospitati tramite FTP e SSH.',
    'domain.move.usernameIsRequred' => 'Devi fornire un nome utente.',
    'domain.move.password' => 'Password',
    'domain.move.passwordIsRequred' => 'Devi fornire una password.',
    'domain.move.noAvailableSubscriptions' => 'Nessun abbonamento disponibile',
    'domain.move.noWebHosting' => 'Nessun utente di sistema verrà creato al momento poiché il dominio è privo di hosting web.',

    'domain.rename.title' => 'Cambia nome di dominio',
    'domain.rename.titleAlias' => 'Cambia alias di dominio',
    'domain.rename.hint' => 'Ora stai cambiando il nome di dominio %%domainName%%',
    'domain.rename.hintAlias' => 'Ora stai cambiando l\'alias di dominio %%domainName%%',
    'domain.rename.name' => 'Nuovo nome di dominio',
    'domain.rename.nameAlias' => 'Nuovo alias di dominio',
    'domain.rename.domainNameIsRequired' => 'Questo campo obbligatorio è vuoto. È necessario specificare un valore.',
    'domain.rename.submitButton' => 'Cambia',
    'domain.rename.submitButtonProgress' => 'Cambio',
    'domain.rename.successMessage' => 'Il nome di dominio %%oldName%% è stato cambiato in %%newName%%.',
    'domain.rename.successMessageAlias' => 'L\'alias di dominio %%oldName%% è stato cambiato in %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Annulla',

    'domain.outgoing-messages.hint' => 'Qui è possibile configurare il limite sul numero di messaggi in uscita per questo dominio. Non sarà possibile inviare più messaggi del limite specificato.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Predefinito (%%domainOutgoingMessages%% messaggi l\'ora)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'messaggi per ora',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limite sul messaggi in uscita',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valore predefinito per questo dominio',

    'domain.tech-domain-name.title' => 'Seleziona il tuo nome di dominio',
    'domain.tech-domain-name.techDomainTitle' => 'Nome di dominio temporaneo',
    'domain.tech-domain-name.customDomainTitle' => 'Nome di dominio registrato',
    'domain.tech-domain-name.techDomainText' => 'Non ho ancora un nome di dominio registrato',
    'domain.tech-domain-name.customDomainText' => 'Ho già un nome di dominio registrato',
    'domain.tech-domain-name.techDomain' => 'Il tuo nome di dominio temporaneo',
    'domain.tech-domain-name.customDomain' => 'Nome di dominio registrato',
    'domain.tech-domain-name.domainName' => 'Nome di dominio',
    'domain.tech-domain-name.techDomainDesc' => 'I nomi di dominio temporanei vengono utilizzati per accedere al sito prima di registrare e acquistare un nome di dominio appropriato. Essi sono forniti gratuitamente alle seguenti condizioni:',
    'domain.tech-domain-name.techDomainRandom' => 'I nomi sono generati in modo casuale',
    'domain.tech-domain-name.techDomainDns' => 'Sono ospitati nella zona DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Puoi passare a un nome di dominio registrato in un secondo momento, rinominando il dominio nelle impostazioni del dominio.',
    'domain.tech-domain-name.error' => 'Si è verificato un errore imprevisto.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Devi selezionare l\'indirizzo IP.',
    'domain.tech-domain-name.generating' => 'Creazione in corso...',

    'get-password.label' => 'Reimposta password',
    'get-password.text' => 'Immetti il tuo indirizzo e-mail o nome utente registrato in Plesk e ti invieremo un\'e-mail di reimpostazione della password.',
    'get-password.emailLabel' => 'Indirizzo e-mail',
    'get-password.loginLabel' => 'Nome utente',
    'get-password.send' => 'Invia',
    'get-password.cancel' => 'Annulla',
    'get-password.errorInvalidEmail' => 'L’indirizzo e-mail non è stato riconosciuto. Verifica e riprova.',
    'get-password.messageSend' => "L'e-mail di reimpostazione della password è stata inviata all'indirizzo e-mail associato. \nSe l'e-mail non arriva, contatta il tuo amministratore di Plesk.",

    'iis-settings.formGeneralHint' => 'Qui è possibile specificare le impostazioni del server web IIS per il tuo sito web, cambiando i valori predefiniti. La configurazione IIS personalizzata è utile, ad esempio, quando si desidera usare un nuovo tipo di file index sul sito web o associare un certo tipo MIME con determinate estensioni del filename. I valori predefiniti vengono definiti dal tuo provider di hosting.',
    'iis-settings.formGeneralHint_powerUser' => 'In questa sezione è possibile specificare le impostazioni del server web IIS per questo sito web. La configurazione IIS personalizzata è utile, ad esempio, quando si desidera usare un nuovo tipo di file index sul sito web o associare un certo tipo MIME con determinate estensioni del filename. I valori predefiniti implicano che IIS userà le direttive corrispondenti dalla sua configurazione predefinita.',
    'iis-settings.virtualDirectoryLoadError' => 'Impossibile ottenere le proprietà della directory virtuale specificata: %%errorMessage%%',
    'iis-settings.general' => 'Impostazioni comuni',
    'iis-settings.example' => "Ad esempio:\n%%example%%",
    'iis-settings.settingOn' => 'Attivato',
    'iis-settings.settingOff' => 'Disattivato (predefinito)',
    'iis-settings.settingDefault' => 'Predefinito',
    'iis-settings.settingCustom' => 'Inserisci valore personalizzato',
    'iis-settings.mimeTypes' => 'Tipi MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'I tipi MIME sono estensioni di file associati a tipi di file. Normalmente sono usati per creare un\'estensione di file personalizzata per i tipi di file comuni.',
    'iis-settings.documents' => 'Documenti predefiniti',
    'iis-settings.documentsOff' => 'Disabilitato',
    'iis-settings.documentsCustom' => 'Inserisci valori',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsExampleFullDescription' => 'Quando i browser non forniscono il nome di un documento all\'interno del tuo sito, IIS cercherà i documenti predefiniti specificati e servirà il primo trovato. Se non specifichi alcun documento predefinito, ma attivi l\'esplorazione directory, allora verrà visualizzato l\'elenco delle directory nei browser invece della pagina indice.',
    'iis-settings.expires' => 'Scade',
    'iis-settings.expiresFullDescription' => 'Il server web aggiungerà alle pagine web le intestazioni di risposta “Scade”. Il timestamp di scadenza si ottiene aggiungendo l’intervallo di tempo sopra specificato all’orario in cui viene richiesta una pagina web.',
    'iis-settings.expiresUnitDays' => 'giorni',
    'iis-settings.expiresUnitHours' => 'ore',
    'iis-settings.expiresUnitMinutes' => 'minuti',
    'iis-settings.expiresUnitSeconds' => 'secondi',
    'iis-settings.headers' => 'Intestazioni aggiuntive',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Il server Web aggiungerà le intestazioni di risposta HTTP specificate.',
    'iis-settings.directoryBrowsing' => 'Permesso di esplorazione directory',
    'iis-settings.directoryBrowsingDescription' => 'Consente agli utenti di visualizzare l\'elenco di directory del sito nei browser web, ad esempio, quando la pagina indice predefinita non è disponibile.',
    'iis-settings.securityTabDirectory' => 'Impostazioni di sicurezza delle directory',
    'iis-settings.allowAnonymous' => 'Autenticazione anonima',
    'iis-settings.allowAnonymousDescription' => 'L\'autenticazione anonima consente agli utenti di accedere al contenuto pubblico del sito. Gli utenti anonimi non potranno accedere al contenuto protetto da password del sito né al contenuto protetto a livello del file system.',
    'iis-settings.allowWindows' => 'Autenticazione Windows',
    'iis-settings.allowWindowsDescription' => 'Autenticazione Windows (in precedenza NTLM) protegge il contenuto del sito su un livello di file system.',
    'iis-settings.requireSsl' => 'Richiedi SSL/TLS',
    'iis-settings.requireSslDescription' => 'Se hai abilitato il supporto SSL/TLS per il tuo sito, questa opzione forzerà i client web (browser) a usare unicamente le connessioni HTTPS sicure.',
    'iis-settings.securityTabIpDeny' => 'Impostazioni di limitazione di accesso',
    'iis-settings.deny' => 'Nega accesso al sito',
    'iis-settings.denyOff' => 'Predefinito',
    'iis-settings.denyCustom' => 'Inserisci valore personalizzato',
    'iis-settings.allow' => 'Esclusione',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nGli host e le reti indicati non possono accedere al sito. Usa '*' per negare tutte le connessioni.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nGli host e le reti indicati possono accedere al sito.",
    'iis-settings.dynamicIpSecurity' => 'Evitare gli attacchi DoS dalla limitazione di IP dinamici IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Negare gli indirizzi IP in base al numero di richieste successive da un unico indirizzo IP',
    'iis-settings.maxConcurrentRequests' => 'Massimo di richieste successive',
    'iis-settings.isDenyByRequestRate' => 'Negare gli indirizzi IP in base al numero di richieste su un periodo di tempo',
    'iis-settings.maxRequests' => 'Massimo di richieste',
    'iis-settings.requestInterval' => 'Periodo di tempo (in millisecondi)',

    'ip-addresses-selector.ipAddress' => 'Indirizzo IP',
    'ip-addresses-selector.ipv4Address' => 'Indirizzi IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "L'indirizzo IP su cui il sito web è ospitato è un indirizzo di rete dell'host virtuale del sito web.",
    'ip-addresses-selector.ipv6Address' => 'Indirizzi IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "L'indirizzo IP su cui il sito web è ospitato è un indirizzo di rete dell'host virtuale del sito web.",
    'ip-addresses-selector.noIpAddressHint' => 'Nessuno',
    'ip-addresses-selector.shared' => 'Condiviso',
    'ip-addresses-selector.exclusive' => 'dedicato',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'Il server FTP non supporta IPv6. Assegna almeno un indirizzo IPv4, altrimenti l\'utente non sarà in grado di caricare file nel server su FTP.',

    'license-key-revert.description' => 'Verrà ripristinata la chiave di licenza con le seguenti proprietà:',
    'license-key-revert.submitButton' => 'Ripristina',

    'license-key-upload.description' => 'Installa la chiave di licenza inserendo un codice di attivazione.',
    'license-key-upload.descriptionWithFileUpload' => 'Installa la chiave di licenza inserendo un codice di attivazione oppure caricando il file della chiave di licenza.',
    'license-key-upload.type' => 'Scegli uno dei seguenti:',
    'license-key-upload.code' => 'Inserire codice di attivazione',
    'license-key-upload.codeDescription' => 'Incolla il codice di attivazione che hai ricevuto.',
    'license-key-upload.file' => 'Carica il file della chiave di licenza',
    'license-key-upload.fileDescription' => 'Specificare il percorso al file che contiene la chiave di licenza.',
    'license-key-upload.submitButton' => 'Installa',

    'log-rotation.customLogsDescription' => 'I tuoi registri personalizzati non sono ruotati.',
    'log-rotation.logRotation' => 'Rotazione di registri',
    'log-rotation.logRotationCondition' => 'Condizione della rotazione di registri',
    'log-rotation.logRotationBySize' => 'Per dimensione',
    'log-rotation.logRotationByTime' => 'Per ora',
    'log-rotation.logRotationDaily' => 'Ogni giorno',
    'log-rotation.logRotationWeekly' => 'Settimanalmente',
    'log-rotation.logRotationMonthly' => 'Mensile',
    'log-rotation.logRotationSizeDescription' => 'Il valore della dimensione deve essere tra %%min%% e %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Numero massimo di file di registro',
    'log-rotation.compress' => 'Comprimi i file di registro',
    'log-rotation.sendLogToEmail' => 'Una volta che Plesk avrà ripristinato i dati dai file di registro dei server web e FTP, invia per posta elettronica i file di registro a questo indirizzo',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Il periodo non può superare il limite %%max%% per l’intero server.',

    'login.loginLabel' => 'Nome utente',
    'login.passwdLabel' => 'Password',
    'login.localeLabel' => 'Lingua interfaccia',
    'login.defaultLocale' => 'Predefinito',
    'login.loginButtonLabel' => 'Accesso',
    'login.enterUsername' => 'Inserisci il nome utente.',
    'login.enterPassword' => 'Inserisci la password.',
    'login.whatUsernamePassword' => 'Quale nome utente e password utilizzare?',
    'login.forgotPasswordLabel' => 'Password dimenticata?',
    'login.cookies' => 'Politica dei cookie in Plesk',
    'login.avoidSSLWarningsMsg' => 'Per evitare gli avvisi di SSL durante l\'accesso a Plesk, utilizzare %%link%%',
    'login.digitalOceanMsg' => 'È la prima volta che usi Plesk su DigitalOcean? Utilizza "root" e la password inserita durante la creazione di questo droplet per accedere. %%link%%',
    'login.amazonLightsailMsg' => 'È la prima volta che usi Plesk su Lightsail? Per accedere a Plesk, accedi al server via SSH e utilizza il comando "plesk login". %%link%%',
    'login.readGuide' => 'Leggi la guida completa.',
    'login.mobileApplicationMessage' => 'Per una migliore esperienza, consigliamo di installare l\'applicazione %%name%%.',
    'login.mobileApplicationInstall' => 'Installa adesso',
    'login.mobileApplicationHide' => 'No, grazie',

    'force-reset-password.saveButton' => 'Salva',
    'force-reset-password.title' => 'Cambia la tua password',
    'force-reset-password.passwordLabel' => 'Nuova password',

    'panel-access.title' => 'Personalizzazione dell’URL di Plesk',
    'panel-access.hint' => 'Imposta URL di accesso personalizzati per Plesk. Questo non limita l’accesso a Plesk attraverso la porta %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Maggiori dettagli',
    'panel-access.proxyEnabled' => 'Tutti i domini e sottodomini che risolvono l’indirizzo IP ma non sono usati per l’hosting',
    'panel-access.proxyDomain' => 'Il dominio o sottodominio specificato che risolve l’indirizzo IP del server ma non è usato per l’hosting',
    'panel-access.proxyDisabled' => 'Nessun URL personalizzato. Solo https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Salva',
    'panel-access.Form.cancelButton' => 'Annulla',

    'panel-access.domainNameIsRequired' => 'È necessario indicare un nome di dominio.',
    'panel-access.successMessage' => 'Il metodo di accesso selezionato è stato applicato.',
    'panel-access.notSupported' => 'Il tuo Plesk non supporta la modalità di accesso selezionata.',
    'panel-access.notViaDomainName' => 'Per applicare questo metodo di accesso, scegli la prima opzione ("Tutti i domini e sottodomini..."), accedi a Plesk da https://%%domainName%%, e poi scegli la seconda opzione.',
    'panel-access.notViaPort' => 'Per applicare questo metodo di accesso, accedi a Plesk da https://<server-IP-or-hostname>:%%httpsPort%% primo.',

    'php-settings.performance' => 'Impostazioni per le prestazioni e la sicurezza',
    'php-settings.settings' => 'Impostazioni comuni',
    'php-settings.fastCgiSettings' => 'Impostazioni FastCGI',
    'php-settings.fpmSettings' => 'Impostazioni PHP-FPM',
    'php-settings.enableFastcgi' => 'Abilita le impostazioni FastCGI',
    'php-settings.plainTextEditing' => 'Direttive aggiuntive',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Puoi definire qualsiasi parametro PHP digitandolo nel campo sottostante. Le direttive saranno incluse nella configurazione PHP. Usa la stessa sintassi richiesta per php.ini. Ad esempio, se desideri caricare automaticamente l\'estensione mSQL, aggiungi la riga: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Se non puoi trovare determinati parametri PHP, aggiungili al campo sottostante. Le direttive aggiuntive verranno incorporate alle direttive del piano di servizio principale. Usa la stessa sintassi usata per php.ini. Per esempio, se desideri caricare automaticamente l\'estensione mSQL, aggiungi la riga: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Puoi definire qualsiasi parametro PHP digitandolo nel campo sottostante. Le direttive saranno incluse nella configurazione PHP. Usa la stessa sintassi richiesta per php.ini. Ad esempio, se desideri caricare automaticamente l\'estensione mSQL, aggiungi la riga: extension=msql.so. Per personalizzare le impostazioni del pool PHP-FPM, aggiungi il separatore [php-fpm-pool-settings] e digita le impostazioni desiderate di seguito.',
    'php-settings.additionalConfigurationDirectives' => 'Direttive di configurazione aggiuntive',
    'php-settings.defaultValue' => 'Predefinito',
    'php-settings.predefinedValue' => 'Seleziona valore',
    'php-settings.customValue' => 'Inserisci valore personalizzato',
    'php-settings.phpSettingDescription_memory_limit' => 'La quantità massima di memoria in byte che uno script può assegnare.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Il tempo massimo in secondi durante il quale uno script può essere in esecuzione prima di essere terminato.',
    'php-settings.phpSettingDescription_max_input_time' => 'Il tempo massimo in secondi durante il quale uno script può analizzare dati di input.',
    'php-settings.phpSettingDescription_post_max_size' => 'La dimensione massima in byte dei dati che possono essere inclusi con il metodo POST. Normalmente, dovrebbe essere maggiore di upload_max_filesize e minore di memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'La dimensione massima in byte di un file caricato.',
    'php-settings.phpSettingDescription_safe_mode' => 'La modalità sicura PHP stabilisce un numero di restrizioni sull\'esecuzione degli script, principalmente per motivi di sicurezza.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Gli script PHP possono accedere ai file nella directory specificata quando la direttiva safe_mode è attiva.La directory deve anche essere presente in include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'I programmi nella directory specificata possono essere eseguiti dagli script PHP quando la direttiva safe_mode è operativa.',
    'php-settings.phpSettingDescription_include_path' => 'La lista di directory in cui gli script cercano dei file (simile alla variabile PATH di sistema). Per dividere le directory, usare due punti (:) su Linux e punto e virgola (;) su Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'La directory per archiviare file della sessione PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Parametri aggiunti per la funzione della posta.',
    'php-settings.phpSettingDescription_register_globals' => 'Registrare il contenuto delle variabili EGPCS (Environment, GET, POST, Cookie, Server), in quanto variabili globali.',
    'php-settings.phpSettingDescription_open_basedir' => 'Gli script PHP possono accedere ai file nelle directory specificate. Per dividere le directory, usare due punti (:) su Linux e punto e virgola (;) su Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Il livello di segnalazione dell\'errore.',
    'php-settings.phpSettingDescription_display_errors' => 'Determina se gli errori devono essere mostrati come una parte dell\'output.',
    'php-settings.phpSettingDescription_log_errors' => 'Abilita l\'accesso degli errori PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Permette alle funzioni del file PHP di ripristinare dati da percorsi remoti su FTP o HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Permette di caricare file su HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Permette la forma breve () sul tag aperto di PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Definisce lo stato di magic_quotes per le operazioni (Get/Post/Cookie). Quando magic_quotes sono attivate, i caratteri speciali: apostrofo, virgolette, barra rovesciata e NULL sono automaticamente preceduti dal carattere escape o barra rovesciata.',
    'php-settings.phpSettingDescription_disable_functions' => 'Questa direttiva consente di disabilitare determinate funzioni. Richiede un elenco di nomi di funzioni delimitato da virgole',
    'php-settings.phpSupport' => 'Supporto PHP',
    'php-settings.phpRunAs' => 'eseguire PHP come',
    'php-settings.phpVersion' => 'Versione PHP',
    'php-settings.phpHandlerOutdated' => '(Obsoleto)',
    'php-settings.phpHandlerDeprecated' => '(Deprecato)',
    'php-settings.phpServedByApache' => 'servito da Apache',
    'php-settings.phpServedByNginx' => 'servito da nginx',
    'php-settings.phpSettingsPhpVersion' => 'La tua versione PHP è %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP è disattivato.',
    'php-settings.phpHandlerTypeHint' => 'Di seguito si indicano le informazioni sulla configurazione PHP del sito web. È possibile cambiare la configurazione PHP se il provider di hosting concede il relativo permesso.',
    'php-settings.fpmDedicatedHandlerHint' => 'L\'uso di questo gestore aumenta la stabilità di un sito, ma causa anche un ulteriore consumo di memoria.',
    'php-settings.phpHandlerChangeHint' => 'Hai modificato le impostazioni del gestore PHP. Salvando queste modifiche, gli script PHP sul tuo sito web potrebbero interrompersi per %%interval%% secondi a causa della configurazione del server.',
    'php-settings.phpHandlerTypeHelpLink' => 'Scopri come scegliere le impostazioni PHP più adatte',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Non è possibile abilitare il supporto di PHP poiché l’attuale configurazione di hosting non include versioni PHP per questo dominio.',
    'php-settings.phpHandlersNotAvailableHint' => 'Non è possibile abilitare il supporto di PHP poiché l’attuale configurazione di Plesk non include versioni PHP disponibili.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Scopri come abilitare altre versioni PHP.',
    'php-settings.phpSupportEditable' => '(versione PHP %%version%%, esegui PHP come %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versione: %%version%%; gestore: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(non registrato) %%link%%',
    'php-settings.showPhpInfo' => 'Visualizza la pagina phpinfo()',
    'php-settings.phpSettingsFormError' => 'Impossibile ripristinare le impostazioni PHP perché i dati richiesti sono assenti.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Impossibile recuperare le impostazioni PHP perché questa versione di PHP non è installata. Per andare avanti, installa la versione di PHP selezionata o scegline un\'altra per il dominio.',
    'php-settings.showPhpInfoTitle' => 'Visualizza phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Alcune delle impostazioni PHP non sono cambiate ma le modifiche non sono state salvate. Per visualizzare i nuovi valore sulla pagina phpinfo(), applica prima le modifiche. Altrimenti, saranno mostrati i valori correnti.',
    'php-settings.showPhpInfoButton' => 'Visualizza phpinfo()',
    'php-settings.onState' => 'Attivato',
    'php-settings.offState' => 'Disattivato',

    'pmm.agent.sync.check' => 'Verifica di aggiornamenti di Migration & Transfer Agent in corso.',
    'pmm.agent.sync.updating' => 'Sincronizzazione e download di Migration & Transfer Agent in corso',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent è stato correttamente sincronizzato.',
    'pmm.agent.sync.downloadLink' => 'Fai clic per scaricare il file di Migration & Transfer Agent da installare sull\'host di origine prima che la migrazione sia avviata.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent non è riuscito a ottenere aggiornamenti. Riprovare più tardi.',

    'restore-password.title' => 'Cambia la tua password',
    'restore-password.passwordLabel' => 'Nuova password',
    'restore-password.buttonRestore' => 'Salva',
    'restore-password.buttonCancel' => 'Annulla',
    'restore-password.isEmpty' => 'Il campo obbligatorio è vuoto. È necessario specificare un valore.',
    'restore-password.errorInvalidSecret' => 'Codice segreto non valido',
    'restore-password.errorNotFoundSecret' => 'Richiedi un nuovo codice segreto',
    'restore-password.restoreSuccess' => 'La tua password è stata aggiornata. Utilizza la nuova password per accedere a Plesk o al tuo indirizzo e-mail.',

    'scheduler.settings.schedulerNotification' => 'Notifica del pianificatore',
    'scheduler.settings.notificationOff' => "Disattivato",
    'scheduler.settings.notificationDefault' => "Invia all'indirizzo e-mail predefinito (%%email%%)",
    'scheduler.settings.notificationCustom' => "Invia l'indirizzo e-mail da me indicato",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Mostra il piano di attività usando un fuso orario',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Usa fuso orario predefinito di sistema (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Usa fuso orario predefinito di sistema',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Usa il fuso orario da me indicato',

    'scheduler.task.active' => 'Attivo',
    'scheduler.task.subscription' => 'Abbonamento',
    'scheduler.task.subscription_powerUser' => 'Spazio web',
    'scheduler.task.type' => 'Tipo attività',
    'scheduler.task.typeCommand' => 'Esegui un comando',
    'scheduler.task.typeUrl' => 'Prendi un URL',
    'scheduler.task.typeScript' => 'Esegui uno script PHP',
    'scheduler.task.command' => 'Comando',
    'scheduler.task.arguments' => 'con argomenti',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Specifica un URL assoluto, ad esempio http://esempio.com. Se il codice di stato della risposta è 2xx o 3xx, si ritiene che l’attività sia stata eseguita correttamente.',
    'scheduler.task.script' => 'Percorso dello script',
    'scheduler.task.scriptRelativePathDescription' => 'Esempio: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Indica il percorso completo allo script. Esempio: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Usa versione PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Percorso dello script',
    'scheduler.task.run' => 'Esegui',
    'scheduler.task.on' => 'Attivo',
    'scheduler.task.at' => 'a',
    'scheduler.task.sysUser' => 'Utente di sistema',
    'scheduler.task.hourly' => 'Ogni ora',
    'scheduler.task.daily' => 'Ogni giorno',
    'scheduler.task.weekly' => 'Settimanale',
    'scheduler.task.monthly' => 'Mensile',
    'scheduler.task.yearly' => 'Annuale',
    'scheduler.task.cronStyle' => 'Stile cron.',
    'scheduler.task.cronStyleError' => 'Sintassi crontab non valida.',
    'scheduler.task.cronStyleErrorWin' => 'La barra (/) e il trattino (-) non sono consentiti.',
    'scheduler.task.cronStyleHint' => 'Usa il formato crontab UNIX "minuto ora giorno-del-mese mese giorno-della-settimana". Per esempio "0 22 * * 1-5". Plesk userà il fuso orario di sistema predefinito per eseguire l\'attività.',
    'scheduler.task.cronStyleWinHint' => 'Usa il formato "minuto ora giorno-del-mese mese giorno-della-settimana", per esempio "0 22 * * 6,7". Plesk userà il fuso orario di sistema predefinito per eseguire l\'attività.',
    'scheduler.task.notify' => 'Notificare',
    'scheduler.task.notifyIgnore' => 'Non notificare',
    'scheduler.task.notifyErrors' => 'Solo errori',
    'scheduler.task.notifyAlways' => 'Ogni volta',
    'scheduler.task.notifyErrorsHint' => 'Le notifiche contengono il flusso di errore standard del comando. Se il flusso è vuoto, non viene inviata alcuna notifica.',
    'scheduler.task.notifyErrorsHintWin' => 'Le notifiche contengono l\'output del comando e sono inviata soltanto se il codice di uscita non è zero.',
    'scheduler.task.notifyAlwaysHint' => 'Le notifiche contengono l\'output del comando. Se l\'output è vuoto, nessuna notifica è inviata.',
    'scheduler.task.notifyAlwaysHintWin' => 'Le notifiche contengono l\'output del comando e sono inviate a prescindere del codice di uscita del comando.',
    'scheduler.task.emailType' => 'Invia notifiche a',
    'scheduler.task.emailTypeDefault' => 'Utente di sistema predefinito (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Proprietario abbonamento (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Amministratore (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Altri utenti',
    'scheduler.task.emailTypeCustomDescription' => 'Puoi specificare diversi indirizzi separati da virgola.',
    'scheduler.task.minute' => 'minuto',
    'scheduler.task.shortMinute' => 'min.',
    'scheduler.task.dayOfMonth' => 'giorno',
    'scheduler.task.description' => 'Descrizione',
    'scheduler.task.scheduleTimezoneHint' => 'Il fuso orario per l\'esecuzione dell\'attività è %%timezone%%',
    'scheduler.task.runTaskNow' => 'Esegui ora',
    'scheduler.task.runningTask' => 'Esecuzione dell\'attività "%%task%%"...',

    'server-settings.submitDone' => "Le impostazioni del server sono state modificate.",
    'server-settings.systemSettings' => "Impostazioni di sistema",
    'server-settings.fullHostName' => "Nome Host completo",
    'server-settings.trafficStatisticsPeriod' => "Conservare le statistiche web e del traffico per",
    'server-settings.trafficStatisticsPeriodUnit' => "mesi",
    'server-settings.diskSpaceUsageCalculation' => "Includi nel calcolo dello spazio disco utilizzato",
    'server-settings.includeLogs' => "file di registro e report di statistiche",
    'server-settings.includeMysqlDatabases' => "database MySQL",
    'server-settings.includeMssqlDatabases' => "database di Microsoft SQL",
    'server-settings.includeDatabases' => "database",
    'server-settings.includeRemoteDatabases' => "database remoti",
    'server-settings.includeMailboxes' => "caselle postali",
    'server-settings.includeMailLists' => "liste di posta",
    'server-settings.includeDomainDumps' => "File di backup del Dominio",
    'server-settings.includeAdminDumps' => "file di backup creati dall'amministratore",
    'server-settings.calculatingDiskSpaceUsage' => "Durante il calcolo dello spazio disco utilizzato, conteggia",
    'server-settings.typeByte' => "la dimensione dei file",
    'server-settings.typeBlock' => "lo spazio disco utilizzato",
    'server-settings.trafficCalculation' => "Includi nel calcolo del traffico",
    'server-settings.inboundAndOutbound' => "traffico entrante e uscente",
    'server-settings.onlyInbound' => "solo traffico entrante",
    'server-settings.onlyOutbound' => "solo traffico uscente",
    'server-settings.forbidCreateDnsSubZone' => "Proibisci agli utenti di creare sottozone DNS in superzone DNS di altri utenti",
    'server-settings.webDeployIncludePassword' => "Comprendi la password dell'utente nel file con le impostazioni di pubblicazione di Web Deploy",
    'server-settings.forbidSysUserRename' => "I clienti possono cambiare il nome dei propri utenti di sistema",
    'server-settings.alwaysAllowSysUserRename' => "sempre",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "solo se il permesso Gestione di Hosting è concesso",
    'server-settings.neverAllowSysUserRename' => "mai",
    'server-settings.forbidSubscriptionRename' => "Impedire ai clienti e ai rivenditori di modificare il proprio nome di dominio principale",
    'server-settings.preferredDomain' => "Dominio preferito per i siti web",
    'server-settings.preferredDomainNone' => "Nessuno",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Accesso IP",
    'server-settings.disableIpLogging' => "Disabilita l'accesso IP nei registri IIS, FTP e di posta elettronica",
    'server-settings.disableIpLoggingDescription' => "Se selezionati, IIS e MailEnable non scrivono più indirizzi IP sui file di log",
    'server-settings.anonymizeIps' => "Anonimizza indirizzi IP",
    'server-settings.logrotateAnonymizeIps' => "Anonimizza gli indirizzi IP durante la rotazione dei registri e la raccolta delle statistiche Web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Prima dell’archiviazione, lo script di post-rotazione sostituisce con “0” l’ultimo ottetto di indirizzi IPv4 nei file di registro ruotati. Negli indirizzi IPv6 lo script sostituisce l’ultima sezione dell’indirizzo (due ottetti dopo l’ultima colonna) con “0000” (in formato completo) o “0” (in formato abbreviato)',
    'server-settings.logrotate' => "Rotazione di registri",
    'server-settings.logrotateForce' => "Forza rotazione dei registri giornaliera per tutti i domini",
    'server-settings.allowToStoreLogs' => "Consenti di archiviare i registri dei siti Web per",
    'server-settings.logrotatePeriod' => "giorni",
    'server-settings.configureUpdatePolicy' => "Configura criteri di aggiornamento",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valore predefinito del server (%%default%% messaggi l\'ora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valore pianificato per il piano',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valore pianificato per l\'abbonamento',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'messaggi',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Messaggi in uscita da una casella postale (l\'ora)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Messaggi in uscita da un dominio (l\'ora)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Messaggi in uscita da un abbonamento (l\'ora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'La percentuale di messaggi l\'ora sopra il limite che dovrebbero essere inviati nell\'ora seguente',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Se il limite sui messaggi email in uscita l\'ora è di 100 e la percentuale è del 10%, allora l\'utente può inviare 110 messaggi l\'ora; 100 messaggi verranno inviati durante un\'ora e 10 messaggi verranno messi in coda e saranno pianificati per essere inviati nell\'ora seguente.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Norme di utilizzo Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Impostazioni predefinite del server (Sendmail è consentito)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Impostazioni predefinite del server (Sendmail non è consentito)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Impostazioni predefinite per il piano',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Impostazioni predefinite per l\'abbonamento',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Consenti l\'utilizzo di Sendmail per gli script e utenti su questo abbonamento',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Gli script e gli utenti saranno in grado di inviare messaggi email (da parte dell\'utente di sistema dell\'abbonamento) mediante Sendmail anche se i limiti di una casella postale e un dominio sono superati. Il massimo di messaggi che possono essere inviati tramite Sendmail verrà definito dal limite per un intero abbonamento.',

    'setup.hint' => 'Benvenuto in Plesk, un pannello di controllo che ti assiste nella gestione del server. Plesk fornisce un ambiente predisposto per il codice e offre una suite di potenti estensioni che agevolano lo sviluppo di siti Web e app. Per iniziare a utilizzare Plesk, completa il processo di configurazione (richiede appena un minuto).',
    'setup.contactInfoSection' => 'Informazioni sul Contatto',
    'setup.contactInfoSectionHint' => 'Immetti il tuo nome e indirizzo e-mail per identificarti quale proprietario del server e ricevere notifiche importanti sul server stesso. Se sei un amministratore di server aziendali, non immettere il tuo nome o l\'indirizzo e-mail personali. Al contrario, utilizza la tua qualifica professionale e l\'indirizzo e-mail aziendale per evitare una possibile violazione della legge di protezione dei dati.',
    'setup.contactName' => 'Nome del tuo contatto',
    'setup.emptyContactName' => 'Indicare un nome di contatto.',
    'setup.contactNameTooLong' => 'Il nome di contatto è troppo lungo (sono consentiti %max% simboli massimi).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Inserisci indirizzo e-mail.',
    'setup.passwordSection' => 'Password',
    'setup.passwordSectionHint' => 'Al tuo prossimo accesso a Plesk, utilizza il nome utente \'admin\' e la password indicata di seguito.',
    'setup.password' => 'Password',
    'setup.licenseSection' => 'Licenza',
    'setup.licenseSectionHint' => 'Per iniziare a utilizzare Plesk è necessario installare una licenza.',
    'setup.licenseType' => 'Seleziona il tuo tipo di licenza',
    'setup.licenseTypePaid' => 'Continua con una licenza pagata',
    'setup.onlineStoreLink' => 'Negozio Online',
    'setup.licenseTypeTrial' => 'Continua con una licenza di prova dotata di funzionalità complete',
    'setup.activationCodeHint' => 'Se hai già acquistato una licenza di Plesk, incolla qui il codice di attivazione che hai ricevuto. In caso contrario, puoi acquistare una nuova licenza in %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Informativa sulla privacy di Plesk',
    'setup.trialLicenseAgreement' => 'Per rilasciare una licenza di prova, Plesk International GmbH utilizzerà e tratterà le informazioni fornite nei propri sistemi interni, in conformità all’%%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Confermo di avere letto e accettato %%link%%',
    'setup.eula' => 'Contratto di licenza per utenti finali',
    'setup.invalidEulaAgreementValue' => 'È necessario accettare il Contratto di licenza per utenti finali',
    'setup.sendButton' => 'Accedi a Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Reimposta la password dell\'amministratore al prossimo accesso',

    'ssl-certificate.add.name' => 'Nome del certificato',
    'ssl-certificate.add.longName' => 'Il nome del certificato specificato è troppo lungo (maximum %max% caratteri sono consentiti).',
    'ssl-certificate.add.certificateNameUsed' => 'Esiste già un certificato con il nome %%name%%.',
    'ssl-certificate.add.certificateAdded' => 'Il certificato SSL/TLS è stato emesso.Per utilizzarlo, assegna il certificato a protezione di un dominio, della posta o della webmail.',
    'ssl-certificate.add.certificateUpdated' => 'Il certificato SSL/TLS è stato correttamente aggiornato.',
    'ssl-certificate.add.settings' => 'Impostazioni',
    'ssl-certificate.add.settingsHint' => 'Usa questo formulario per generare una richiesta di certificato, per acquistare un certificato dal tuo provider o per generare un certificato autofirmato.',
    'ssl-certificate.add.settingsHint2' => 'Una richiesta è un file CSR che contiene l\'informazione sul tuo dominio, specificato nel formulario. Puoi inviare la richiesta a un\'autorità di certificazione perché emetta un certificato per te. Potrai quindi caricarlo usando uno dei formulari di Caricamento in basso',
    'ssl-certificate.add.settingsHint3' => 'Un certificato autofirmato è un certificato d\'identità firmato dal proprio creatore. Se utilizzi un certificato di questo tipo, significa che tu stesso verifichi l\'identità dei tuoi siti. Sebbene un certificato autofirmato consente di usare SSL/TLS, non sono tanto affidabili e sono considerati meno sicuri',
    'ssl-certificate.add.bits' => 'Bit',
    'ssl-certificate.add.country' => 'Paese',
    'ssl-certificate.add.state' => 'Stato o provincia',
    'ssl-certificate.add.longState' => 'Il nome di stato o provincia specificato è troppo lungo.',
    'ssl-certificate.add.city' => 'Luogo (città)',
    'ssl-certificate.add.longCity' => 'Il nome della città specificato è troppo lungo.',
    'ssl-certificate.add.shortCity' => 'Il nome della città specificato è troppo breve.',
    'ssl-certificate.add.companyName' => 'Nome società (company)',
    'ssl-certificate.add.longCompanyName' => 'Il nome dell\'azienda specificato è troppo lungo.',
    'ssl-certificate.add.companyUnitName' => 'Divisione o dipartimento della società',
    'ssl-certificate.add.longCompanyUnitName' => 'Il nome del reparto dell\'organizzazione specificato è troppo lungo (maximum %max% caratteri sono consentiti).',
    'ssl-certificate.add.domainName' => 'Nome del dominio',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Richiesta',
    'ssl-certificate.add.buyCertificate' => 'Acquista certificato SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Self-Signed',
    'ssl-certificate.add.invalidCertificateParams' => 'Alcuni campi sono vuoti o contengono valori non adatti. I valori devono essere limitati a 64 caratteri. Se utilizzi un nome di dominio internazionale, accertati che nessuna parte del nome di dominio fra i punti superi i 63 caratteri una volta trasformato in formato ASCII. Verifica i campi:',
    'ssl-certificate.add.unableCreateCsr' => 'Impossibile creare un CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Impossibile creare un certificato autofirmato: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Impossibile impostare i dati del certificato: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Impossibile salvare il certificato nel database: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Carica i file del certificato',
    'ssl-certificate.add.uploadFilesHint' => 'Usare questo modulo per caricare i componenti di un certificato come file costitutivi.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Chiave privata (*.key)",
    'ssl-certificate.add.certificate' => "Certificato (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificato CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Caricare certificato",
    'ssl-certificate.add.fileNotUploaded' => 'Impossibile caricare il file del certificato: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Impossibile impostare la chiave privata: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Impossibile impostare il certificato: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Impossibile impostare il certificato CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Impossibile verificare se il certificato CA firma il certificato: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Rimuovi',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Rimuovere il certificato CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Impossibile eliminare il certificato CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'È stata rimossa la parte CA del certificato.',
    'ssl-certificate.add.rename' => 'Rinomina',
    'ssl-certificate.add.unableRenameCertificate' => 'Impossibile rinominare il certificato: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Il certificato è stato rinominato a %%name%%.',
    'ssl-certificate.add.uploadText' => "Invia il certificato come testo",
    'ssl-certificate.add.uploadTextHint' => 'Usare questo modulo per caricare i componenti di un certificato come testo. Copia e incolla i contenuti di un file nel campo corrispondente.',
    'ssl-certificate.add.sendText' => "Caricare certificato",
    'ssl-certificate.add.componentIsMissing' => 'Il componente è assente.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Carica qui il certificato',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Se hai creato una richiesta di firma di certificato su questo server e hai ricevuto il file del certificato, puoi caricarlo qui. Se desideri caricare una coppia di certificato e chiave privata generata in un server diverso o generare un certificato autofirmato, fai clic su <b>Aggiungi certificato SSL/TLS</b>',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Una volta aggiunto un certificato SSL/TLS a un dominio, è necessario abilitare il supporto SSL/TLS e selezionare il certificato nelle impostazioni di hosting del sito web: <b>Siti web e Domini</b>> <b>Impostazioni di hosting</b> di questo dominio> <b>Sicurezza</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificato (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Caricare certificato',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Impossibile caricare il file del certificato.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Formato certificato non valido.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Impossibile trova la chiave privata adatta per il certificato.',

    'ssl-certificate.secure.certificate' => 'Seleziona certificato',
    'ssl-certificate.secure.serverPool' => 'Pool di Server',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Data",
    'system-time.dateAndTime' => "Data e ora",
    'system-time.daylight' => "Passa automaticamente all'ora legale",
    'system-time.dayMonthYear' => "Giorno-Mese-Anno",
    'system-time.domainNameOrIp' => "Nome dominio o IP",
    'system-time.hoursMinutesSeconds' => "Ore:Minuti:Secondi",
    'system-time.networkTime' => "Ora del Network",
    'system-time.submitDone' => "Le impostazioni dell'ora del sistema sono state modificate.",
    'system-time.synchronizedSystemTime' => "Sincronizza l'orario di sistema",
    'system-time.title' => "Data e orario di sistema",
    'system-time.timezone' => "Fuso Orario",
    'system-time.time' => "Ora",
    'system-time.updateSystemTime' => "Aggiorna l'ora di sistema",
    'system-time.yourTimezone' => "Fuso Orario",

    'web-app-firewall.pageHint' => 'Il firewall dell\'applicazione web protegge le applicazioni web dagli attacchi controllando e filtrando le richieste HTTP in entrata sulla base di regole definite dall\'utente.',
    'web-app-firewall.webSitePageHint' => 'Qui è possibile configurare il firewall dell\'applicazione web (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Modalità del firewall dell\'applicazione web',
    'web-app-firewall.ruleEngineOn' => 'Attivato',
    'web-app-firewall.ruleEngineOnDescription' => 'Ogni richiesta HTTP in arrivo e la risposta correlata sono verificate sulla base un set di regole predefinite. Se la verifica va a buon fine, la richiesta HTTP viene trasferita al contenuto del sito web. Se la verifica non va a buon fine, l\'evento viene registrato, viene inviata una notifica e alla risposta HTTP viene attribuito un codice di errore.',
    'web-app-firewall.ruleEngineOff' => 'Disattivato',
    'web-app-firewall.ruleEngineOffDescription' => 'Le richieste HTTP in arrivo e risposte correlate non sono controllate.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Solo rilevamento',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Ogni richiesta HTTP in arrivo e la relativa risposta correlata sono verificate sulla base un set di regole predefinite. Se la verifica va a buon fine, la richiesta HTTP viene trasferita al contenuto del sito web. Se la verifica non va a buon fine, l\'evento viene registrato e ModSecurity non esegue ulteriori azioni. Altri servizi (per esempio, Fail2ban) possono continuare ad agire sulle richieste HTTP che non hanno superato la verifica.',
    'web-app-firewall.ruleSetsSection' => 'Set di regole',
    'web-app-firewall.ruleSetsSectionHint' => 'Seleziona quale set di regole (un pacchetto di file contenente le regole di sicurezza) utilizzare per controllare le richieste HTTP in arrivo.',
    'web-app-firewall.ruleSet' => 'Set di regole',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratuito)',
    'web-app-firewall.ruleSetCrsDescription' => 'Il Ruleset core ModSecurity OWASP è molto restrittivo e potrebbe bloccare alcune funzioni (ad esempio, condivisione di file, Webmail) e alcune caratteristiche delle applicazioni Web (ad esempio, i plugin di WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Applicare le modifiche?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Le regole OWASP potrebbero essere troppo restrittive e quindi bloccare alcune funzioni, come la Condivisione di file, webmail e altre applicazioni web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratuito, si può effettuare l’upgrade ad Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Una versione iniziale delle Regole ModSecurity di Atomicorp. Queste regole forniscono una protezione di base e vengono aggiornate una volta al mese.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Per effettuare l’upgrade di questo ruleset ad Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Acquista %%linkPleskStore%% dal sito Web di Plesk e %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Regole ModSecurity avanzate di Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'installa la chiave di licenza aggiuntiva acquistata',
    'web-app-firewall.ruleSetTortixSelect' => 'Seleziona questo ruleset, il cui nome diventerà “Atomic Advanced (acquistato da Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (acquistato da Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Le Regole ModSecurity avanzate di Atomicorp comprendono le regole Atomic Standard oltre a varie funzionalità avanzate.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (acquistato da Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Le Regole ModSecurity avanzate di Atomicorp comprendono le regole Atomic Standard oltre a varie funzionalità avanzate.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Passa a un altro account Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Set di regole attivato.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Se disponi già di un account Atomicorp con le regole Atomic Advanced acquistate, inserisci le credenziali dell’account di seguito per abilitare il set di regole.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Se hai già l\'account Atomicorp con le regole Atomic Advanced acquistate, inserisci le credenziali del account qui sotto per passare ad esso.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nome utente',
    'web-app-firewall.ruleSetAtomicPassword' => 'Password',
    'web-app-firewall.ruleSetComodo' => 'Comodo (abbonamento gratuito)',
    'web-app-firewall.ruleSetComodoDescription' => 'Regole ModSecurity gratuite di Comodo. Forniscono una protezione di base.',
    'web-app-firewall.ruleSetComodoInstall' => 'Passa a un altro account Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Set di regole attivato.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Per abilitare questo set di regole:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Per passare a un altro account:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registrati sul sito Web di Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Immetti il tuo nome utente e la password da tale sito Web.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nome utente',
    'web-app-firewall.ruleSetComodoPassword' => 'Password',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratuito)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Regole ModSecurity gratuite di Comodo. Forniscono una protezione di base.',
    'web-app-firewall.ruleSetCustom' => 'Personalizza set di regole',
    'web-app-firewall.ruleSetCustomDescription' => 'Carica un set di regole personalizzate del firewall dell\'applicazione web. Formati supportati: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Seleziona un altro file',
    'web-app-firewall.ruleSetError' => 'Errore nell\'installazione del set di regole di ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'Il set di regole OWASP non è stato rilevato. Reinstalla ModSecurity utilizzando l\'installer di Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Il set di regole personalizzato non è stato rilevato. Reinstalla il set di regole.',
    'web-app-firewall.ruleSetAuthError' => 'Nome utente o password specificati non validi.',
    'web-app-firewall.ruleSetInvalid' => 'Il set di regole selezionato non può essere eseguito su %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Il set di regole selezionato non può essere eseguito sul server web indicato.',
    'web-app-firewall.webServer' => 'Esegui regole su',
    'web-app-firewall.webServerHint' => 'Seleziona la combinazione desiderata di server web e versione ModSecurity per vedere i set di regole compatibili.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Il Server proxy inverso (nginx) è disattivato e non può essere utilizzato per elaborare le richieste. Seleziona <a href="%%serverUrl%%">un altro server web</a> o attiva il server proxy inverso sulla <a href="%%servicesUrl%%">pagina Gestione di servizi</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'La selezione di una diversa versione di ModSecurity potrebbe far sì che alcune impostazioni non siano più valide (ad esempio, non è possibile utilizzare le espressioni regolari per disattivare le regole di sicurezza con ModSecurity 3). Assicurati che le tue impostazioni funzionino come previsto dopo aver applicato le modifiche. In alternativa, puoi ripristinare le impostazioni che disattivano le regole di sicurezza ai valori predefiniti.',
    'web-app-firewall.nginxResetCustomizations' => 'Ripristina le impostazioni del server e dei domini che disattivano le regole di sicurezza ai valori predefiniti.',
    'web-app-firewall.ruleSetUpdate' => 'Aggiorna set di regole',
    'web-app-firewall.ruleSetUpdateDaily' => 'Ogni giorno',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Settimanalmente',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Mensilmente',
    'web-app-firewall.currentRuleSet' => 'Set di regole',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% in esecuzione su %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Cambia set di regole',
    'web-app-firewall.ruleSetRollbackFailed' => 'Non è possibile usare il set di regole ModSecurity attuale e tornare alla versione precedente del file, perché contiene regole non valide.',
    'web-app-firewall.configurationSection' => 'Configurazione',
    'web-app-firewall.configurationSectionHint' => 'Configura il firewall dell\'applicazione web mediante un set predefinito di parametri o tramite le tue direttive ModSecurity personalizzate.',
    'web-app-firewall.configPreset' => 'Set predefinito di valori',
    'web-app-firewall.configPresetFast' => 'Veloce',
    'web-app-firewall.configPresetFastDescription' => 'L\'URI della richiesta HTTP e le sezioni delle intestazioni verranno analizzati.',
    'web-app-firewall.configPresetTradeOff' => 'Intermedio',
    'web-app-firewall.configPresetTradeOffDescription' => 'L\'URI della richiesta HTTP, le intestazioni e i dati POST della richiesta verranno analizzati.',
    'web-app-firewall.configPresetThrough' => 'Esaustivo',
    'web-app-firewall.configPresetThroughDescription' => 'Le intestazioni della richiesta HTTP, i dati POST della richiesta e il contenuto del corpo della risposta HTTP verranno interamente analizzati.',
    'web-app-firewall.configCustom' => 'Personalizza direttive',
    'web-app-firewall.configCustomDescription' => "Inserisci una direttiva ModSecurity qui. Sovrascriverà le direttive specificate in precedenza (set di regole, regole specifiche, set predefinito di valori eccetera).\nPer esempio: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Configurazione ModSecurity non valida: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Non è possibile usare il file di configurazione ModSecurity attuale e tornare alla versione precedente del file, perché contiene una configurazione non valida.',
    'web-app-firewall.rulesSection' => 'Disattiva regole di sicurezza',
    'web-app-firewall.rulesSectionHint' => 'Qui è possibile disattivare regole di sicurezza. Può essere utile se si determina che una regola di sicurezza sia troppo restrittiva per alcuni siti web. Per disattivare le regole di sicurezza, indicare i loro ID (ad esempio, 340003 o 340005-340007), tag (ad esempio, CVE-2011-4898) o espressioni regolari usate nei messaggi di regole (ad esempio, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Qui è possibile disattivare regole di sicurezza. Può essere utile se si determina che una regola di sicurezza sia troppo restrittiva per alcuni siti web. Per disattivare le regole di sicurezza, indicare i loro ID (ad esempio, 340003 o 340005-340007), tag (ad esempio, CVE-2011-4898) o messaggi di regole (ad esempio: "Trovato Utente-Agente associato allo scanner di sicurezza").',
    'web-app-firewall.filterById' => 'ID della regola di sicurezza',
    'web-app-firewall.filterByIdInvalid' => 'I seguenti valori non sono validi: %%values%%. L\'ID della regola dovrebbe essere composto da cifre o da un intervallo di cifre come 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'I seguenti intervalli non sono validi: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tag',
    'web-app-firewall.filterByTagActive' => 'Attivo:',
    'web-app-firewall.filterByTagDeactivated' => 'Disattivato:',
    'web-app-firewall.filterByTagInvalid' => 'I seguenti valori selezionati non sono validi: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Espressioni regolari nei messaggi di regole',
    'web-app-firewall.filterByRegexpInvalid' => 'I seguenti valori non sono validi: %%values%%. Non devono contenere i caratteri \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Messaggi di regole',
    'web-app-firewall.filterByRegexpNginxHint' => 'Sono supportate solo le combinazioni "rigorose".',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'I seguenti valori non sono validi: %%values%%. Il messaggio di regola deve essere composto da lettere, cifre, spazi o caratteri -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Registro controllo ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Il file registro di controllo ModSecurity è la parte più utile d\'informazione nel sistema. Quando ModSecurity rileva che un evento è in corso, genera una voce nel file registro di controllo.',
    'web-app-firewall.auditLogHint2' => 'Un sito web può anche smettere di funzionare come previsto dopo il cambiamento della modalità del firewall dell\'applicazione web da Disattivato verso Attivato o unicamente Rilevamento. In tale caso, analizza il registro di controllo ModSecurity per scoprire cosa sta succedendo. Puoi disattivare le regole di sicurezza troppo restrittive o regolare il sito web.',
    'web-app-firewall.auditLogHint3' => 'Per scoprire perché una richiesta HTTP non può essere completata per un sito web:',
    'web-app-firewall.auditLogPoint1' => 'Fai clic sul link del file registro ModSecurity sotto e apri il registro di controllo in una nuova finestra del browser.',
    'web-app-firewall.auditLogPoint2' => 'Usa l\'opzione Cerca (Ctrl+F nella maggior parte di browser web) per trovare gli eventi per il sito web (il nome di dominio) che sperimentano problemi. Per esempio, your_domain.tld. Il browser evidenzierà voci quali HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'Nelle tre righe sopra la voce evidenziata, trova una stringa del tipo --eece5138-B--. Gli otto caratteri fra trattini (nel nostro esempio, eece5138) rappresentano l\'ID dell\'evento attivato dalla richiesta HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Cerca ancora altre voci con lo stesso ID dell\'evento. Cerca una voce con la lettera H dopo l\'ID dell\'evento (nel nostro esempio, eece5138-H--). Questa voce contiene l\'ID e una descrizione della regola di sicurezza attivata durante la verifica della richiesta HTTP. L\'ID della regola di sicurezza è un numero intero che inizia dal numero 3, tra virgolette, con il prefisso id tra parentesi quadre. Per esempio, %340003',
    'web-app-firewall.auditLogPoint5' => 'Trova l\'ID di una regola di sicurezza nell\'evento mediante una stringa secondaria [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Disattiva la regola di sicurezza con questo ID nella sezione delle regole di sicurezza sotto: inserisci l\'ID della regola di sicurezza (solo cifre) nel campo dell\'ID della regola di sicurezza e fai clic su OK.',
    'web-app-firewall.auditLogViewLink' => 'File registro ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Archivio di registri',
    'web-app-firewall.errorLogSection' => 'Registro di errore',
    'web-app-firewall.errorLogSectionHint' => 'Un sito web può anche smettere di funzionare come previsto dopo il cambiamento della modalità del firewall dell\'applicazione web da Disattivato verso Attivato o unicamente Rilevamento. In tale caso, analizza il log dell\'errore per scoprire cosa sta succedendo. Puoi disattivare le regole di sicurezza troppo restrittive o regolare il sito web.',
    'web-app-firewall.errorLogViewLink' => 'File registro di errore',
    'web-app-firewall.notificationStateEnabled' => 'Le notifiche dell\'interfaccia utente di Plesk sugli aggiornamenti dei set di regole sono attivate. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Le notifiche dell\'interfaccia utente di Plesk sugli aggiornamenti dei set di regole sono disattivate. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Gestiscile sulla pagina delle notifiche',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Selezionare le opzioni "Intermedio" o "Esaustivo" può causare il malfunzionamento dei siti WordPress, oltre ad altri effetti collaterali indesiderati, a causa dei seguenti <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">problemi di ModSecurity</a>.',
];