<?php
/**
 * This class provides the Kronolith configuration for the test script.
 *
 * Copyright 2010-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 *
 * @author  Michael Slusarz <slusarz@horde.org>
 * @package Kronolith
 */
class Kronolith_Test extends Horde_Test
{
    /**
     * The module list
     *
     * @var array
     */
    protected $_moduleList = array();

    /**
     * PHP settings list.
     *
     * @var array
     */
    protected $_settingsList = array();

    /**
     * PEAR modules list.
     *
     * @var array
     */
    protected $_pearList = array(
        'Date' => array(
            'path' => 'Date/Calc.php',
            'error' => 'Kronolith requires the Date_Calc class to calculate dates.',
            'required' => true,
        ),
        'Date_Holidays' => array(
            'error' => 'Date_Holidays can be used to calculate and display national and/or religious holidays.',
            'required' => false,
        ),
    );

    /**
     * Inter-Horde application dependencies.
     *
     * @var array
     */
    protected $_appList = array();

    /**
     */
    public function __construct()
    {
        parent::__construct();

        $this->_fileList += array(
            'config/prefs.php' => null
        );
    }

    /**
     * Any application specific tests that need to be done.
     *
     * @return string  HTML output.
     */
    public function appTests()
    {
    }

}
