<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Odmowa dostępu. Twoje konto jest zawieszone.",
    'login_up__login_has_been_locked' => "Próbowałeś zalogować się przy użyciu błędnego hasła zbyt wiele razy. Ze względów bezpieczeństwa, nie będziesz mógł się zalogować przez jakiś czas używając tej nazwy użytkownika.",
    'login_up__login_label_plesk' => "Zaloguj do %1", // PFU
    'login_up__login_label_parallels' => "Zaloguj się do Plesk %1",
    'login_up__login_text' => "Podaj swój login i hasło.",
    'login_up__unable_to_check_pass' => "Błąd przy sprawdzaniu hasła: %1",
    'login_up__warning_limits_licence_key' => "Jeden z następujących elementów przekroczył limit określony przez klucz licencyjny: liczba kont użytkownika, domen, kont pocztowych lub użytkowników sieci przechowywanych na serwerze.\nProszę skontaktować się z działem sprzedaży Plesk, aby zakupić klucz, który umożliwi hostowanie odpowiedniej liczby użytkowników i domen. Proszę skontaktować się z działem obsługi technicznej Plesk, jeśli otrzymałeś tę wiadomość przez pomyłkę.\nLimit licencyjny dla kont użytkownika/domen/kont pocztowych/ użytkowników sieci/pakietów językowych: %2.\nLiczba kont użytkownika/domen/kont pocztowych/ użytkowników sieci/pakietów językowych obecnie hostowanych: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Liczba zasobów, na których pracujesz, przekroczyła ograniczenia Twojej licencji produktowej. Proszę skontaktować się z działem sprzedaży Pleska i zakupić klucz licencyjny.",
    'login_up__grace_period' => 'Obecnie działasz w okresie prolongaty licencji na produkt. Aby zaktualizować licencję produktu, wybierz opcję Pobierz klucze na stronie %1Informacje o licencji%2.',
    'login_up__partner_license_message' => 'Obecnie korzystasz z ograniczonej licencji produktu, która wymaga rejestracji przed aktywacją pełnego zestawu funkcji. Aby zaktualizować licencję produktu, wybierz opcję Pobierz klucze na stronie %1Informacje o licencji%2.',
    'login_up__system_admin_disabled' => 'Superużytkownik (konto root lub administratora) nie ma prawa logować się w Plesku z powodów bezpieczeństwa.',
    'login_up__mobile_application_message' => 'Dla lepszego doświadczenia zalecamy zainstalowanie aplikacji %%name%%.',
    'login_up__mobile_application_install' => 'Zainstaluj teraz',
    'login_up__mobile_application_hide' => 'Nie, dziękuję',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Przewodnik Administratora Plesk",
    'plesk_guide_reseller' => "Przewodnik sprzedawcy Plesk",
    'plesk_guide_client' => "Przewodnik Klienta Plesk",
    'plesk_guide_domain_admin' => "Przewodnik Administratora domeny Plesk",
    'plesk_guide_mailuser' => "Przewodnik Użytkownika\\ów poczty e-mail Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Szukaj', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Klienci',
    'ui__reseller_unknown__quick-search' => 'Sprzedawcy',
    'ui__client/domain_unknown__quick-search' => 'Domeny',
    'nav__general' => 'Menu Główne',
    '__home' => 'Start',
    '__resellers' => 'Sprzedawcy',
    '__clients' => 'Klienci',
    '__domains' => 'Domeny',
    '__applications' => 'Aplikacje',
    '__settings' => 'Ustawienia',
    'nav__system' => 'System',
    '__master' => 'Master',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Górny poziom',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Usuń',
    'bt_make_default' => 'Domyślny',

    // common list object operation errors
    'class_cList__empty_selection' => 'Nie wybrano żadnych obiektów.',

    // common list object search keys
    'clist__search_show' => 'Pokaż wyszukiwanie',
    'clist__search_hide' => 'Ukryj szukanie',

    'bt_show_all' => "Wyczyść szukanie",

    // common object list info keys
    'clist__first' => 'Pierwsza',
    'clist__last' => 'Ostatnia',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Strony',
    'clist__page_size' => 'Wpisy na stronę',
    'clist__info' => 'Ogółem %1: %4',
    'clist__info_empty' => 'Brak %1',
    'clist__info_filter' => '%5 %1 znalezionych (%4 wszystkich)',
    'clist__info_paging' => '%2-%3 %1 of %4 ogółem',
    'clist__info_paging_filter' => '%2-%3 %1 z %5 znalezionych (%4 wszystkich)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktywne',
    '__object_off' => 'Zawieszone',

    '__home_description' => 'Powr o strony domowej.',
    'indicator_title' => '%1% wykorzystano, %2% wolne', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Zażądano niepoprawnego URL.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Konta sprzedawcy",
    'ui__reseller_unknown__title' => "Konta sprzedawcy",
    'ui__reseller_unknown__description' => "Zarządzaj kontami sprzedawców.",
    'ui__reseller/client_unknown__short-title' => 'Konta klienta',
    'ui__reseller/client_unknown__title' => 'Konta klienta',
    'ui__reseller/client_unknown__description' => 'Zarządzaj kontami klientów.',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => 'Przypisz nowego właściciela dla kont klienta',
    'ui__reseller/client/chowner_multi-select__short-title' => 'Zmień właściciela',
    'ui__reseller/client/chowner_multi-select__description' => 'Przypisz nowego właściciela dla wybranych kont klienta.',
    'ui__client/to-reseller_multi__title' => 'Konwertuj konto klienta na konto sprzedawcy',
    'ui__client/to-reseller_multi__short-title' => 'Konwertuj do sprzedawców',
    'ui__client/to-reseller_multi__description' => 'Konwertuj wybrane konta klienta do kont sprzedawcy.',
    'ui__reseller/to-client_multi__title' => 'Przekształć konta sprzedawców na konta klientów',
    'ui__reseller/to-client_multi__short-title' => 'Konwertuj do klientó',
    'ui__reseller/to-client_multi__description' => 'Konwertuj wybrane konta sprzedawcy do kont klienta',
    'ui__admin-alias_unknown__title' => "Dodatkowe konta administratora", // PFW
    'ui__admin-alias_unknown__short-title' => "Dodatkowe konta administratora", // PFW
    'ui__admin-alias_unknown__description' => "Wyświetl i zarządzaj dodatkowymi kontami administratora.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Ustawienia serwera poczty",
    'ui__server/mail__title' => "Ustawienia serwera poczty",
    'ui__server/mail__description' => "Zarządzaj systemem poczty serwera.",
    'ui__server/dns__short-title' => 'Ustawienia DNS',
    'ui__server/dns__title' => 'Ustawienia DNS',
    'ui__server/dns__description' => 'Przeglądaj i aktualizuj ustawienia DNS na całym serwerze.',
    'ui__server/components__short-title' => 'Komponentów serwera',
    'ui__server/components__title' => 'Komponentów serwera',
    'ui__server/components__description' => 'Informacje dotyczące komponentów systemowych zainstalowanych na serwerze i zarządzanych przez Plesk.',
    'ui__server/services__short-title' => 'Zarządzanie usługami',
    'ui__server/services__title' => 'Zarządzanie usługami',
    'ui__server/services__description' => 'Start, stop lub restart usług Plesk kontrolnego.',
    'ui__server/crontab/task_unknown__short-title' => 'Zaplanowane zadania',
    'ui__server/crontab/task_unknown__title' => 'Zaplanowane zadania',
    'ui__server/crontab/task_unknown__description' => 'Zaplanowane zadania.',
    'ui__server/ip-address_unknown__short-title' => 'Adresy IP',
    'ui__server/ip-address_unknown__title' => 'Adresy IP',
    'ui__server/ip-address_unknown__description' => 'Wyświetl, dodaj oraz usuń adresy IP, przypisz adresy IP do użytkowników.',
    'ui__promotion/smartermail__short-title' => 'Pobierz SmarterMail',
    'ui__promotion/smartermail__title' => 'Pobierz SmarterMail',
    'ui__promotion/smartermail__description' => 'Otwórz nowe okno przez stronę SmarterMail, gdzie możesz pobrać najnowszą wersję serwera pocztowego SmarterMail. Strona SmarterMail jest produkowana przez SmarterTools Inc. Plesk nie jest odpowiedzialny za treści serwisu SmarterMail website, a także nie zapewnia obsługi serwera poczty SmarterMail Lite.',
    // dropdowns
    'ui__server/time__title' => 'Czas systemowy',
    'ui__server/time__short-title' => 'Czas systemowy',
    'ui__server/time__description' => 'Ustaw czas systemowy i synchronizacje z serwerem NTP.',
    'ui__server/odbc__title' => 'Źródła danych ODBC', // PFW
    'ui__server/odbc__short-title' => 'Źródła danych ODBC', // PFW
    'ui__server/odbc__description' => 'Konfiguruj źródła danych ODBC.', // PFW
    'ui__server/ftp-settings__short-title' => "Ustawienia FTP", // PFW
    'ui__server/ftp-settings__title' => "Ustawienia FTP", // PFW
    'ui__server/ftp-settings__description' => "Skonfiguruj ustawienia FTP na całym serwerze.", // PFW
    'ui__server/maillists__title' => 'Ustaw serwer list mailingowych', // PFU
    'ui__server/maillists__short-title' => 'Ustaw serwer list mailingowych', // PFU
    'ui__server/maillists__description' => 'Konfiguruj listę mailingową serwera Mailman.', // PFU
    'ui__mass-email__short-title' => "Masowe wiadomości e-mail", // PFW
    'ui__mass-email__title' => "Masowe wiadomości e-mail", // PFW
    'ui__mass-email__description' => "Wyślij wiadomości e-mail do kilku użytkowników jednocześnie.", // PFW
    'ui__mass-mail__title' => 'Masowe wiadomości e-mail', // PFU
    'ui__mass-mail__short-title' => 'Masowe wiadomości e-mail', // PFU
    'ui__mass-mail__description' => 'Wyślij wiadomości e-mail do kilku użytkowników jednocześnie.', // PFU
    'ui__server/spam-filter__title' => 'Ustawienia filtru antyspamowego',
    'ui__server/spam-filter__short-title' => 'Ustawienia filtru antyspamowego',
    'ui__server/spam-filter__description' => 'Ustaw parametry filtru antyspamowego.',
    'ui__server/preferences__title' => "Ustawienia serwera",
    'ui__server/preferences__short-title' => "Ustawienia serwera",
    'ui__server/preferences__description' => "Ustaw właściwości serwera, change server\\'s host name and change other server settings.",

    // help & support
    // icons
    'ui__support__short-title' => 'Obsługa',
    'ui__support__title' => 'Obsługa',
    'ui__support__description' => 'Wyślij pytanie do obsługi technicznej Plesk.',
    'ui__license__short-title' => 'Informacje na temat licencji',
    'ui__license__title' => 'Informacje o licencji Plesk',
    'ui__license__description' => 'Zobacz informacje o licencji Pleska i zamów nowe klucze licencji.',
    'ui__help__short-title' => 'Pomoc',
    'ui__help__title' => 'Pomoc online',
    'ui__help__description' => 'Wyświetl pomoc online.',
    'ui__news__short-title' => "Co nowego",
    'ui__news__title' => "Co nowego",
    'ui__news__description' => "Zobacz listę zmian w tej wersji Plesk.",
    'ui__server/autoinstaller__short-title' => 'Aktualizacja',
    'ui__server/autoinstaller__title' => 'Aktualizacja',
    'ui__server/autoinstaller__description' => 'Aktualizuj Plesk i jego komponenty.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domeny',
    'ui__client/domain_unknown__title' => 'Domeny',
    'ui__client/domain_unknown__description' => 'Zarządzaj domenami.',
    'ui__server/skeleton__short-title' => 'Zarządzanie szkieletem',
    'ui__server/skeleton__title' => 'Zarządzanie szkieletem',
    'ui__server/skeleton__description' => 'Sprecyzuj pliki i foldery, które powinny być umieszczone w folderach nowo utworzonych domen.',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => 'Stwórz domenę',
    'ui__client/domain/properties_unknown-new__short-title' => 'Stwórz domenę',
    'ui__client/domain/properties_unknown-new__description' => 'Stwórz i skonfiguruj nową domenę.',
    'ui__client/domain/chowner_multi-select__title' => 'Przypisz nowego właściciela do subskrypcji',
    'ui__client/domain/chowner_multi-select__short-title' => 'Przypisz nowego właściciela subskrypcji',
    'ui__client/domain/chowner_multi-select__description' => 'Przypisz nowego właściciela do wybranych subskrypcji',
    'ui__client/domain/to-client_multi__title' => 'Przekształć konta administratorów domen na konta klientów',
    'ui__client/domain/to-client_multi__short-title' => 'Konwertuj do klientó',
    'ui__client/domain/to-client_multi__description' => 'Konwertuj wybrane konta administratora domeny do kont klientó',
    'ui__client/domain/disable_multi__title' => 'Zawieś domeny',
    'ui__client/domain/disable_multi__short-title' => 'Zawieś domeny',
    'ui__client/domain/disable_multi__description' => 'Zawieś wybrane domeny',
    'ui__client/domain/enable_multi__title' => 'Aktywuj domeny',
    'ui__client/domain/enable_multi__short-title' => 'Aktywuj domeny',
    'ui__client/domain/enable_multi__description' => 'Aktywuj wybrane domeny',

    // icons
    'ui__admin/extras-domain__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Ustawienia ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Ustawienia ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Skonfiguruj ustawienia ASP.NET dla całego serwera.', // PFW
    'ui__server/sitebuilder__short-title' => 'Ustawienia Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Ustawienia Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Skonfiguruj Presence Builder do edycji stron hostowanych na tym serwerze.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Zarejestruj domenę',
    'ui__admin/register-domain__short-title' => 'Zarejestruj domenę',
    'ui__admin/register-domain__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Zarządzaj domeną',
    'ui__admin/manage-domain__short-title' => 'Zarządzaj domeną',
    'ui__admin/manage-domain__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',
    'ui__server/register__title' => 'Zarejestruj sw erwer',
    'ui__server/register__short-title' => 'Zarejestruj serwer',
    'ui__server/register__description' => 'Zarejestruj swój serwer aby przystąpić do programu lojalnościowego',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Logi akcji',
    'ui__actionlog__title' => 'Logi akcji',
    'ui__actionlog__description' => 'Pobierz logi wykonanych akcji i zarządzaj ustawieniami logów.',
    'ui__notification_unknown__short-title' => 'Powiadomienia',
    'ui__notification_unknown__title' => 'Powiadomienia',
    'ui__notification_unknown__description' => 'Wyświetl i edytuj powiadomienia o ważnych wydarzeniach w Plesk.',
    'ui__server/resources__short-title' => 'Zużycie zasobu',
    'ui__server/resources__title' => 'Zużycie zasobu',
    'ui__server/resources__description' => 'Wyświetl wykorzystanie zasobów systemowych.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Informacje o serwerze',
    'ui__server/statistics__title' => 'Informacje o serwerze',
    'ui__server/statistics__description' => 'Statystyki usług zarządzanych przez Plesk.',
    'ui__admin/report__title' => 'Raport zbiorczy',
    'ui__admin/report__short-title' => 'Raport zbiorczy',
    'ui__admin/report__description' => 'Wyświetl raport dotyczący wykorzystanie ruchu i zasobów dla sprzedawców, klientów i domen.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Czas bezczynności sesji',
    'ui__sessions/properties__title' => 'Czas bezczynności sesji',
    'ui__sessions/properties__description' => 'Ustaw czas bezczynności sesji dla sesji Plesk.',
    'ui__cp-access__short-title' => 'Dostęp do Plesk',
    'ui__cp-access__title' => 'Dostęp do Plesk',
    'ui__cp-access__description' => 'Ograniczony dostęp do Plesk.',
    'ui__sessions__short-title' => 'Aktywne sesje',
    'ui__sessions__title' => 'Aktywne sesje',
    'ui__sessions__description' => 'Zobacz aktywne sesje Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Ceryfikaty SSl/TLS',
    'ui__server/certificate_unknown__short-title' => 'Ceryfikaty SSl/TLS',
    'ui__server/certificate_unknown__description' => 'Lista certyfikatów SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Dane personalne',
    'ui__admin-info__title' => 'Dane personalne',
    'ui__admin-info__description' => 'Zmień personalne dane dla twojego konta.',
    'ui__admin-password__short-title' => 'Zmień hasło',
    'ui__admin-password__title' => 'Zmień hasło',
    'ui__admin-password__description' => 'Zmień hasło dla swojego konta.',
    'ui__admin/interface__short-title' => 'Ustawienia Interfejsu',
    'ui__admin/interface__title' => 'Ustawienia interfejsu administratora',
    'ui__admin/interface__description' => 'Zmień ustawienia interfejsu administratora serwera.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => 'Menedżer plików',
    'ui__client/domain/hosting/file-manager_unknown__title' => 'Menedżer plików',
    'ui__client/domain/hosting/file-manager_unknown__description' => 'Pracuj z plikami i katalogami za pośrednictwem managera plików.',
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => 'Użyj terminalu SSH, aby uzyskać dostęp do serwera.', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => 'Katalogi chronione hasłem',
    'ui__client/domain/hosting/protected-directories_unknown__title' => 'Katalogi chronione hasłem',
    'ui__client/domain/hosting/protected-directories_unknown__description' => 'Zabezpiecz dostęp do wybranych obszarów strony internetowej.',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => 'Utwórz i zarządzaj katalogami wirtualnymi w domenie.', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Pracuj z fizycznymi i wirtualnymi plikami i katalogami na stronie internetowej.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => 'Statystyki WWW',
    'ui__client/domain/report/web-stats_unknown__title' => 'Statystyki WWW',
    'ui__client/domain/report/web-stats_unknown__description' => 'Zobacz statystyki odwiedzin strony.',
    'ui__reseller/limits__short-title' => 'Zużycie zasobu',
    'ui__reseller/limits__title' => 'Zużycie zasobu',
    'ui__reseller/limits__description' => 'Wyświetl i zarządzaj zużycie zasobów sprzedawcy %1.',
    'ui__reseller/limits_unknown__short-title' => 'Zużycie zasobu',
    'ui__reseller/limits_unknown__title' => 'Zużycie zasobu',
    'ui__reseller/limits_unknown__description' => 'Wyświetl i zarządzaj zużycie zasobów sprzedawcy.',
    'ui__reseller/limits_self__short-title' => 'Zużycie zasobu',
    'ui__reseller/limits_self__title' => 'Zużycie zasobu',
    'ui__reseller/limits_self__description' => "Wyświetl i zarządzaj zużycie swoich zasobów.",
    'ui__reseller/limits_readonly-self__short-title' => 'Zużycie zasobu',
    'ui__reseller/limits_readonly-self__title' => 'Zużycie zasobu',
    'ui__reseller/limits_readonly-self__description' => "Wyświetl zużycie twoich zasobów.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Zużycie ruchu przez klientów',
    'ui__reseller/client/traffic_unknown__title' => 'Wyświetl zużycie ruchu przez klientów',
    'ui__reseller/client/traffic_unknown__description' => 'Wyświetl raporty zużycia ruchu dla kont klienta.',
    'ui__client/traffic_unknown__short-title' => "Zużycie ruchu przez klientów", // temporary for presets
    'ui__client/traffic_unknown__title' => "Wyświetl zużycie ruchu przez klientów", // temporary for presets
    'ui__client/traffic_unknown__description' => "Wyświetl raporty zużycia ruchu dla kont klienta.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Menedżer logów',
    'ui__client/domain/hosting/logs_unknown__title' => 'Manager logów',
    'ui__client/domain/hosting/logs_unknown__description' => 'Zobacz logi i skonfiguruj rotację logów.',
    // dropdowns
    'ui__reseller/report__title' => 'Raport zbiorczy',
    'ui__reseller/report__short-title' => 'Raport zbiorczy',
    'ui__reseller/report__description' => 'Wyświetl raport zużycia ruchu i zasobów dla tego sprzedawcy.',
    'ui__reseller/report_unknown__title' => 'Raport zbiorczy',
    'ui__reseller/report_unknown__short-title' => 'Raport zbiorczy',
    'ui__reseller/report_unknown__description' => 'Wyświetl raport dotyczący zużycia ruchu i źródeł dla sprzedawcy.',
    'ui__reseller/report_self__title' => 'Raport zbiorczy',
    'ui__reseller/report_self__short-title' => 'Raport zbiorczy',
    'ui__reseller/report_self__description' => 'Wyświetl raport twojego korzystania z ruchu i zasobów.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Branding Plesk',
    'ui__client/logo_reseller__short-title' => 'Branding Plesk',
    'ui__client/logo_reseller__description' => 'Zmień brand Plesk dla sprzedawcy %1.',
    'ui__client/logo_unknown__title' => 'Branding Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Branding Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Przebranduj Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Branding Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Branding Plesk',
    'ui__client/logo_self-reseller__description' => 'Przebranduj sw Plesk.',
    'ui__reseller/permissions__title' => 'Uprawnienia',
    'ui__reseller/permissions__short-title' => 'Uprawnienia',
    'ui__reseller/permissions__description' => "Wyświetl lub zmień akcje, które sprzedawca %1 może przeprowadzić w Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Uprawnienia',
    'ui__reseller/permissions_unknown__title' => 'Uprawnienia',
    'ui__reseller/permissions_unknown__description' => "Wyświetl lub zmień akcje, które sprzedawca może przeprowadzić w Plesk.",
    'ui__reseller/permissions_self__title' => 'Uprawnienia',
    'ui__reseller/permissions_self__short-title' => 'Uprawnienia',
    'ui__reseller/permissions_self__description' => 'Wyświetl listę akcji, które możesz przeprowadzić w Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Uprawnienia',
    'ui__reseller/permissions_readonly-self__short-title' => 'Uprawnienia',
    'ui__reseller/permissions_readonly-self__description' => 'Wyświetl listę akcji, które możesz przeprowadzić w Plesk.',
    // dropdowns
    'ui__reseller/to-client__title' => 'Konwertuj konto sprzedawcy do konta klienta',
    'ui__reseller/to-client__short-title' => 'Konwertuj sprzedawcy do klienta',
    'ui__reseller/to-client__description' => 'Konwertuj to konto sprzedawcy do konta klienta.',
    'ui__reseller/to-client_unknown__title' => 'Konwertuj konto sprzedawcy do konta klienta',
    'ui__reseller/to-client_unknown__short-title' => 'Konwertuj sprzedawcy do klienta',
    'ui__reseller/to-client_unknown__description' => 'Konwertuj konto sprzedawcy do konta klienta.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Zarządzanie szkieletem',
    'ui__client/skeleton__short-title' => 'Zarządzanie szkieletem',
    'ui__client/skeleton__description' => 'Sprecyzuj pliki i foldery, które powinny być umieszczone w folderach nowo utworzonych domen.',
    'ui__client/skeleton_unknown__short-title' => 'Zarządzanie szkieletem',
    'ui__client/skeleton_unknown__title' => 'Zarządzanie szkieletem',
    'ui__client/skeleton_unknown__description' => 'Sprecyzuj pliki i foldery, które powinny być umieszczone w folderach nowo utworzonych domen.',
    // dropdowns
    'ui__client/domain/properties_new__title' => 'Stwórz domenę',
    'ui__client/domain/properties_new__short-title' => 'Stwórz domenę',
    'ui__client/domain/properties_new__description' => "Utwórz domenę dla %1.",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Aliasy domen',
    'ui__client/domain/domain-alias_unknown__title' => 'Aliasy domen',
    'ui__client/domain/domain-alias_unknown__description' => 'Wyświetl listę alternatywnych nazw dla twojej domeny.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_unknown__description' => 'Zarządzaj strefą DNS dla swojej domeny.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Wyświetl ustawienia strefy DNS dla domeny.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__client/domain/odbc_unknown__short-title' => 'Źródła danych ODBC', // PFW
    'ui__client/domain/odbc_unknown__title' => 'Źródła danych ODBC', // PFW
    'ui__client/domain/odbc_unknown__description' => 'Skonfiguruj źródła danych ODBC dla domeny.', // PFW
    'ui__reseller/register-domain__short-title' => 'Zarejestruj domenę',
    'ui__reseller/register-domain__title' => 'Zarejestruj domenę',
    'ui__reseller/register-domain__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Zarejestruj domenę',
    'ui__reseller/register-domain_unknown__title' => 'Zarejestruj domenę',
    'ui__reseller/register-domain_unknown__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Zarejestruj domenę',
    'ui__reseller/register-domain_self__title' => 'Zarejestruj domenę',
    'ui__reseller/register-domain_self__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Zarządzaj domeną',
    'ui__reseller/manage-domain__short-title' => 'Zarządzaj domeną',
    'ui__reseller/manage-domain__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Zarządzaj domeną',
    'ui__reseller/manage-domain_unknown__short-title' => 'Zarządzaj domeną',
    'ui__reseller/manage-domain_unknown__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Zarządzaj domeną',
    'ui__reseller/manage-domain_self__short-title' => 'Zarządzaj domeną',
    'ui__reseller/manage-domain_self__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Adresy IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Adresy IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Zarządzaj adresami IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Ceryfikaty SSl/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Ceryfikaty SSl/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Zainstaluj certyfikaty SSL/TLS i zarządzaj nimi.',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => 'Ochrona przed hotlinkowaniem', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => 'Ochrona przed hotlinkowaniem', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => 'Chroń pliki przed hotlinkowaniem.', // PFW
    'ui__reseller/sessions__short-title' => 'Aktywne sesje',
    'ui__reseller/sessions__title' => 'Aktywne sesje',
    'ui__reseller/sessions__description' => 'Zobacz aktywne sesje Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktywne sesje',
    'ui__reseller/sessions_unknown__title' => 'Aktywne sesje',
    'ui__reseller/sessions_unknown__description' => 'Zobacz aktywne sesje Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Aktywne sesje',
    'ui__reseller/sessions_self__title' => 'Aktywne sesje',
    'ui__reseller/sessions_self__description' => 'Zobacz aktywne sesje Plesk.',
    'ui__client/domain/hosting/performance_unknown__short-title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_unknown__title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_unknown__description' => 'Zobacz i dostosuj limit na wykorzystanie pasma oraz liczbę jednoczesnych połączeń ze stroną internetową.',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => 'Zobacz limit na wykorzystanie pasma oraz liczbę jednoczesnych połączeń.',
    'ui__client/domain/hosting/php_unknown__short-title' => 'Ustawienia PHP', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'Ustawienia PHP', // PFW
    'ui__client/domain/hosting/php_unknown__description' => 'Skonfiguruj PHP na domenie.', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Konta pocztowe dla konta użytkownika %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Zarządzanie szkieletem',
    'ui__client/skeleton_self__title' => 'Zarządzanie szkieletem',
    'ui__client/skeleton_self__description' => 'Sprecyzuj pliki i foldery, które powinny być umieszczone w folderach nowo utworzonych domen.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Zużycie zasobu',
    'ui__client/limits__title' => 'Zużycie zasobu',
    'ui__client/limits__description' => "Pokaż lub edytuj limity użycia zasobów dla klienta %1.",
    'ui__client/limits_unknown__short-title' => 'Zużycie zasobu',
    'ui__client/limits_unknown__title' => 'Zużycie zasobu',
    'ui__client/limits_unknown__description' => 'Pokaż lub edytuj limity użycia zasobów klienta.',
    'ui__client/limits_readonly__short-title' => 'Zużycie zasobu',
    'ui__client/limits_readonly__title' => 'Zużycie zasobu',
    'ui__client/limits_readonly__description' => 'Podgląd zasobów przydzielonych klientowi %1.',
    'ui__client/limits_self__short-title' => 'Zużycie zasobu',
    'ui__client/limits_self__title' => 'Zużycie zasobu',
    'ui__client/limits_self__description' => "Wyświetl i zarządzaj zużycie swoich zasobów.",
    'ui__client/limits_readonly-self__short-title' => 'Zużycie zasobu',
    'ui__client/limits_readonly-self__title' => 'Zużycie zasobu',
    'ui__client/limits_readonly-self__description' => "Wyświetl zużycie twoich zasobów.",
    'ui__client/domain/traffic_unknown__short-title' => "Zużycie ruchu przez domeny %1",
    'ui__client/domain/traffic_unknown__title' => "Zobacz zużycie ruchu przez domeny",
    'ui__client/domain/traffic_unknown__description' => "Zobacz raporty zużycia ruchu dla domen.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Raport zbiorczy',
    'ui__client/report__short-title' => 'Raport zbiorczy',
    'ui__client/report__description' => 'Podgląd raportu klienta.',
    'ui__client/report_unknown__short-title' => 'Raport zbiorczy',
    'ui__client/report_unknown__title' => 'Raport zbiorczy',
    'ui__client/report_unknown__description' => 'Podgląd raportu klienta.',
    'ui__client/report_self__short-title' => 'Raport zbiorczy',
    'ui__client/report_self__title' => 'Raport zbiorczy',
    'ui__client/report_self__description' => 'Zobacz informację o Twoim koncie.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Ustawienia Interfejsu',
    'ui__client/preferences__title' => 'Ustawienia Interfejsu',
    'ui__client/preferences__description' => 'Edytuj ustawienia sesji i interfejsu Plesk dla klienta %1.',
    'ui__client/preferences_unknown__short-title' => 'Ustawienia Interfejsu',
    'ui__client/preferences_unknown__title' => 'Ustawienia Interfejsu',
    'ui__client/preferences_unknown__description' => "Edytuj ustawienia sesji i interfejsu Plesk dla klienta.",
    'ui__client/preferences_self__short-title' => 'Ustawienia Interfejsu',
    'ui__client/preferences_self__title' => 'Ustawienia Interfejsu',
    'ui__client/preferences_self__description' => 'Ustaw preferencje interfejsu dla swojego Plesk.',
    'ui__client/logo__title' => 'Branding Plesk',
    'ui__client/logo__short-title' => 'Branding Plesk',
    'ui__client/logo__description' => "Ustaw właściwości loga Plesk administracyjnego klienta %1.",
    'ui__client/logo_self__title' => 'Branding Plesk',
    'ui__client/logo_self__short-title' => 'Branding Plesk',
    'ui__client/logo_self__description' => 'Przebranduj Plesk, zmieniając logotyp i pasek tytułu w przeglądarce.',
    'ui__client/permissions__title' => 'Uprawnienia',
    'ui__client/permissions__short-title' => 'Uprawnienia',
    'ui__client/permissions__description' => "Zobacz lub zmień działania, które klient %1 może wykonywać w Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Uprawnienia',
    'ui__client/permissions_unknown__title' => 'Uprawnienia',
    'ui__client/permissions_unknown__description' => "Zobacz operacje lub edytuj, które klient może wykonywać w Plesk.",
    'ui__client/permissions_self__title' => 'Uprawnienia',
    'ui__client/permissions_self__short-title' => 'Uprawnienia',
    'ui__client/permissions_self__description' => "Wyświetl listę akcji, które możesz przeprowadzić w Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Uprawnienia',
    'ui__client/permissions_readonly-self__short-title' => 'Uprawnienia',
    'ui__client/permissions_readonly-self__description' => "Wyświetl listę akcji, które możesz przeprowadzić w Plesk.",
    // dropdowns
    'ui__client/chowner_select__title' => 'Przypisz nowego właściciela do konta klienta',
    'ui__client/chowner_select__short-title' => 'Przypisz nowego właściciela do klienta',
    'ui__client/chowner_select__description' => 'Przypisz nowego właściciela do tego konta klienta.',
    'ui__client/chowner_unknown-select__short-title' => 'Przypisz nowego właściciela do konta klienta',
    'ui__client/chowner_unknown-select__title' => 'Przypisz nowego właściciela do klienta',
    'ui__client/chowner_unknown-select__description' => 'Przypisz nowego właściciela do konta klienta.',
    'ui__client/to-reseller__title' => 'Konwertuj konto klienta do konta sprzedawcy',
    'ui__client/to-reseller__short-title' => 'Konwertuj klienta do sprzedawcy',
    'ui__client/to-reseller__description' => 'Konwertuj to konto klienta do konta sprzedawcy.',
    'ui__client/to-reseller_unknown__title' => 'Konwertuj konto klienta do konta sprzedawcy',
    'ui__client/to-reseller_unknown__short-title' => 'Konwertuj klienta do sprzedawcy',
    'ui__client/to-reseller_unknown__description' => 'Konwertuj to konto klienta do konta sprzedawcy.',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/extras-domain__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/extras-domain__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Zarejestruj domenę',
    'ui__client/register-domain__short-title' => 'Zarejestruj domenę',
    'ui__client/register-domain__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Zarejestruj domenę',
    'ui__client/register-domain_unknown__short-title' => 'Zarejestruj domenę',
    'ui__client/register-domain_unknown__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Zarejestruj domenę',
    'ui__client/register-domain_self__short-title' => 'Zarejestruj domenę',
    'ui__client/register-domain_self__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Zarządzaj domeną',
    'ui__client/manage-domain__short-title' => 'Zarządzaj domeną',
    'ui__client/manage-domain__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Zarządzaj domeną',
    'ui__client/manage-domain_unknown__short-title' => 'Zarządzaj domeną',
    'ui__client/manage-domain_unknown__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Zarządzaj domeną',
    'ui__client/manage-domain_self__short-title' => 'Zarządzaj domeną',
    'ui__client/manage-domain_self__description' => 'Zarządzaj zarejestrowanymi nazwami domen poprzez MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Adresy IP',
    'ui__client/ipaddress_unknown__short-title' => "Adresy IP",
    'ui__client/ipaddress_unknown__description' => "Zarządzaj adresami IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Aliasy domen',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Aliasy domen',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Wyświetl listę alternatywnych nazw dla twojej domeny.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => 'Aktywne sesje',
    'ui__client/sessions__title' => 'Aktywne sesje',
    'ui__client/sessions__description' => 'Zobacz aktywne sesje Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Aktywne sesje',
    'ui__client/sessions_unknown__title' => 'Aktywne sesje',
    'ui__client/sessions_unknown__description' => 'Zobacz aktywne sesje Plesk.',
    'ui__client/sessions_self__short-title' => 'Aktywne sesje',
    'ui__client/sessions_self__title' => 'Aktywne sesje',
    'ui__client/sessions_self__description' => 'Zobacz aktywne sesje Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => 'Menedżer plików',
    'ui__client/domain/hosting/file-manager__title' => 'Zarządzaj plikami w domenie %1',
    'ui__client/domain/hosting/file-manager__description' => "Pracuj z plikami i katalogami na domenie %1 za pośrednictwem managera plików.",
    'ui__client/domain/hosting/file-manager_self__short-title' => 'Menedżer plików',
    'ui__client/domain/hosting/file-manager_self__title' => 'Menedżer plików',
    'ui__client/domain/hosting/file-manager_self__description' => "Pracuj z plikami i katalogami za pośrednictwem managera plików.",
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => 'Użyj terminalu SSH, aby uzyskać dostęp do serwera.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'Terminal SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => 'Użyj terminalu SSH, aby uzyskać dostęp do serwera.', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => 'Katalogi chronione hasłem',
    'ui__client/domain/hosting/protected-directories__title' => 'Katalogi chronione hasłem',
    'ui__client/domain/hosting/protected-directories__description' => 'Zabezpiecz dostęp do wybranych obszarów strony internetowej.',
    'ui__client/domain/hosting/protected-directories_self__short-title' => 'Katalogi chronione hasłem',
    'ui__client/domain/hosting/protected-directories_self__title' => 'Katalogi chronione hasłem',
    'ui__client/domain/hosting/protected-directories_self__description' => 'Zabezpiecz dostęp do wybranych obszarów strony internetowej.',
    'ui__client/domain/hosting/virtual-directories__short-title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => 'Utwórz i zarządzaj katalogami wirtualnymi w domenie %1.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => 'Utwórz i zarządzaj katalogami wirtualnymi w twojej domenie.', // PFW
    'ui__client/domain/hosting/web-directories__title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Pracuj z fizycznymi i wirtualnymi plikami i katalogami na stronie %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Wirtualne katalogi', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Pracuj z fizycznymi i wirtualnymi plikami i katalogami na twojej stronie internetowej.', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => 'Statystyki WWW',
    'ui__client/domain/report/web-stats__title' => 'Statystyki WWW',
    'ui__client/domain/report/web-stats__description' => 'Zobacz statystyki odwiedzin strony.',
    'ui__client/domain/report/web-stats_self__short-title' => 'Statystyki WWW',
    'ui__client/domain/report/web-stats_self__title' => 'Statystyki WWW',
    'ui__client/domain/report/web-stats_self__description' => 'Zobacz statystyki odwiedzin strony.',
    'ui__client/domain/traffic__short-title' => '%1 zużycie ruchu',
    'ui__client/domain/traffic__title' => 'Statystyki transferu danych dla domeny %1',
    'ui__client/domain/traffic__description' => 'Zobacz statystyki transferu danych dla domeny %1.',
    'ui__client/domain/traffic_self__short-title' => 'Użycie transferu',
    'ui__client/domain/traffic_self__title' => 'Zobacz zużycie ruchu dla twojej domeny',
    'ui__client/domain/traffic_self__description' => 'Zobacz raport zużycia ruchu dla twojej domeny.',
    'ui__client/domain/hosting/logs__short-title' => 'Menedżer logów',
    'ui__client/domain/hosting/logs__title' => 'Menedżer logów',
    'ui__client/domain/hosting/logs__description' => 'Zobacz logi i skonfiguruj rotację logów.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Menedżer logów',
    'ui__client/domain/hosting/logs_self__title' => 'Menedżer logów',
    'ui__client/domain/hosting/logs_self__description' => 'Zobacz logi i skonfiguruj rotację logów.',
    // dropdowns
    'ui__client/domain/report__title' => 'Raport zbiorczy',
    'ui__client/domain/report__short-title' => 'Raport zbiorczy',
    'ui__client/domain/report__description' =>  'Zobacz informację o Twoim koncie.',
    'ui__client/domain/report_unknown__short-title' => 'Raport zbiorczy',
    'ui__client/domain/report_unknown__title' => 'Raport zbiorczy',
    'ui__client/domain/report_unknown__description' => 'Zobacz informację o Twoim koncie.',
    'ui__client/domain/report_self__short-title' => 'Raport zbiorczy',
    'ui__client/domain/report_self__title' => 'Raport zbiorczy',
    'ui__client/domain/report_self__description' => 'Zobacz informację o Twoim koncie.',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => 'Dane personalne',
    'ui__client/domain/properties__title' => 'Dane personalne',
    'ui__client/domain/properties__description' => 'Ustaw konto administratora/ów domeny dla domeny.',
    'ui__client/domain/properties_unknown__short-title' => 'Dane personalne',
    'ui__client/domain/properties_unknown__title' => 'Dane personalne',
    'ui__client/domain/properties_unknown__description' => 'Ustaw konto administratora domeny dla domeny.',
    'ui__client/domain/properties_self__short-title' => 'Dane personalne',
    'ui__client/domain/properties_self__title' => 'Dane personalne',
    'ui__client/domain/properties_self__description' => 'Zmień personalne dane dla twojego konta.',
    // dropdowns
    'ui__client/domain/rename__title' => 'Zmień nazwę domeny',
    'ui__client/domain/rename__short-title' => 'Zmień nazwę domeny',
    'ui__client/domain/rename__description' => 'Zmień nazwę domeny %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Zmień nazwę domeny',
    'ui__client/domain/rename_unknown__title' => 'Zmień nazwę domeny',
    'ui__client/domain/rename_unknown__description' => 'Zmień nazwę domeny',
    'ui__client/domain/chowner_select__title' => 'Przypisz nowego właściciela do domeny',
    'ui__client/domain/chowner_select__short-title' => 'Przypisz nowego właściciela do subskrypcji',
    'ui__client/domain/chowner_select__description' => 'Przypisz nowego właściciela do subskrypcji',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Przypisz nowego właściciela do subskrypcji',
    'ui__client/domain/chowner_unknown-select__title' => 'Przypisz nowego właściciela do subskrypcji',
    'ui__client/domain/chowner_unknown-select__description' => 'Przypisz nowego właściciela do subskrypcji.',
    'ui__client/domain/to-client__title' => 'Konwertuj konto administratora domeny do konta klienta',
    'ui__client/domain/to-client__short-title' => 'Konwertuj administratora domeny do klienta',
    'ui__client/domain/to-client__description' => 'Konwertuj to konto administratora domeny do konta klienta',
    'ui__client/domain/to-client_unknown__short-title' => 'Konwertuj administratora domeny do klienta',
    'ui__client/domain/to-client_unknown__title' => 'Konwertuj konto administratora domeny do konta klienta',
    'ui__client/domain/to-client_unknown__description' => 'Konwertuj konto administratora domeny do konta klienta',
    'ui__client/domain/toggle__title' => 'Zawieś lub aktywuj domenę', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Zawieś lub aktywuj domenę', // for HP customization
    'ui__client/domain/toggle__description' => 'Zawieś lub aktywuj domenę %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Zawieś lub aktywuj domenę', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Zawieś lub aktywuj domenę', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Zawieś albo odwieś domenę.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Włącz domenę %1',
    'ui__client/domain/toggle_enable__short-title' => 'Włącz domenę %1',
    'ui__client/domain/toggle_enable__description' => 'Włącz domenę %1.',
    'ui__client/domain/toggle_disable__title' => 'Zawieś domenę %1',
    'ui__client/domain/toggle_disable__short-title' => 'Zawieś domenę %1',
    'ui__client/domain/toggle_disable__description' => 'Zawieś domenę %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Ustawienia DNS',
    'ui__client/domain/dns__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns__description' => 'Zarządzaj strefą DNS %1.',
    'ui__client/domain/dns_self__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_self__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_self__description' => 'Zarządzaj moją strefą DNS %1.',
    'ui__client/domain/dns_disabled__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_disabled__description' => 'Zarządzaj strefą DNS %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Zarządzaj moją strefą DNS %1.',
    'ui__client/domain/dns_readonly__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly__description' => 'Pokaż ustawienia stref DNS dla domeny %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Przeglądaj ustawienia stref DNS dla Twojej domeny.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Przeglądaj ustawienia stref DNS dla Twojej domeny.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Przeglądaj ustawienia stref DNS dla Twojej domeny.',
    'ui__client/domain/dns_slave__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_slave__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_slave__description' => 'Zarządzaj strefą DNS %1.',
    'ui__client/domain/dns_self-slave__title' => 'Ustawienia DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Ustawienia DNS',
    'ui__client/domain/dns_self-slave__description' => 'Zarządzaj moją strefą DNS %1.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/domain/extras__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/domain/extras__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Narzędzia ze strony MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Zdobądź dodatkowe narzędzia i usługi ze strony MyPlesk.com.',
    'ui__client/domain/odbc__short-title' => 'Źródła danych ODBC', // PFW
    'ui__client/domain/odbc__title' => 'Źródła danych ODBC', // PFW
    'ui__client/domain/odbc__description' => 'Skonfiguruj źródła danych ODBC dla domeny %1.', // PFW
    'ui__client/domain/odbc_self__short-title' => 'Źródła danych ODBC', // PFW
    'ui__client/domain/odbc_self__title' => 'Źródła danych ODBC', // PFW
    'ui__client/domain/odbc_self__description' => 'Skonfiguruj źródła danych ODBC dla twojej domeny.', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Zarejestruj domenę',
    'ui__client/domain/register__title' => 'Zarejestruj domenę',
    'ui__client/domain/register__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Zarejestruj domenę',
    'ui__client/domain/register_unknown__title' => 'Zarejestruj domenę',
    'ui__client/domain/register_unknown__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Zarejestruj domenę',
    'ui__client/domain/register_self__title' => 'Zarejestruj domenę',
    'ui__client/domain/register_self__description' => 'Zarejestruj nazwę domeny poprzez MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => 'Ochrona przed hotlinkowaniem', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => 'Ochrona przed hotlinkowaniem', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => 'Chroń pliki w domenie %1 przed hotlinkowaniem.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => 'Ochrona przed hotlinkowaniem', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => 'Ochrona przed hotlinkowaniem', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => 'Chroń swoje pliki przed hotlinkowaniem.', // PFW
    'ui__client/domain/hosting/performance__short-title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance__title' => 'Ogranicz zużycie pasma i liczbę możliwych połączeń ze swoją stroną internetową',
    'ui__client/domain/hosting/performance__description' => 'Zobacz i dostosuj limit na wykorzystanie pasma dla domeny %1 oraz liczbę jednoczesnych połączeń z nią.',
    'ui__client/domain/hosting/performance_readonly__short-title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_readonly__title' => 'Limity na wykorzystanie pasma oraz liczba dozwolonych połączeń z twoją stroną internetową',
    'ui__client/domain/hosting/performance_readonly__description' => 'Zobacz limit na wykorzystanie pasma dla domeny %1 oraz liczbę jednoczesnych połączeń.',
    'ui__client/domain/hosting/performance_self__short-title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_self__title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_self__description' => 'Zobacz i dostosuj limit na wykorzystanie pasma dla swojej domeny oraz liczbę jednoczesnych połączeń z nią.',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_readonly-self__title' => 'Ograniczenie pasma',
    'ui__client/domain/hosting/performance_readonly-self__description' => 'Zobacz limit na wykorzystanie pasma dla swojej domeny oraz liczbę jednoczesnych połączeń.',
    'ui__client/domain/hosting/php__short-title' => 'Ustawienia PHP', // PFW
    'ui__client/domain/hosting/php__title' => 'Ustawienia PHP', // PFW
    'ui__client/domain/hosting/php__description' => 'Skonfiguruj PHP na domenie %1.', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'Ustawienia PHP', // PFW
    'ui__client/domain/hosting/php_self__title' => 'Ustawienia PHP', // PFW
    'ui__client/domain/hosting/php_self__description' => 'Skonfiguruj PHP na swojej domenie.', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => 'Musisz wybrać konta klienta, które chcesz skonwertować do kont sprzedawcy',
    'ui__client/chowner__empty_selection' => 'Musisz wybrać konta klienta, które chcesz przypisać do nowego właściciela',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Narzędzia",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Zobacz statystyki',
    'ui__client/domain-summary-report_unknown__title' => 'Zobacz statystyki',
    'ui__client/domain-summary-report_unknown__description' => 'Wyświetl informacje o wykorzystaniu zasobów przez domeny.',
    'ui__client/domain-summary-report__short-title' => "Zobacz statystyki",
    'ui__client/domain-summary-report__title' => "Zobacz statystyki",
    'ui__client/domain-summary-report__description' => "Wyświetl informacje o wykorzystaniu zasobów przez domeny.",
    'ui__client/domain-summary-report_self__short-title' => "Zobacz statystyki",
    'ui__client/domain-summary-report_self__title' => "Zobacz statystyki",
    'ui__client/domain-summary-report_self__description' => "Wyświetl informacje o wykorzystaniu zasobów przez twoje domeny.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domeny", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => 'Sprawdź uprawnienia',
    'ui__client/domain/check-permissions_multi__title' => 'Sprawdzanie uprawnień',
    'ui__client/domain/check-permissions_multi__description' => 'Sprawdź pozwolenia dostępu pliku i folderu na domenie. Jeśli wystąpią jakieś błędy, zostaną one automatycznie poprawione.',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Musisz wybrać domeny, które chcesz usunąć',
    'ui__client/domain/properties__empty_selection' => 'Musisz wybrać domeny, które chcesz zmodyfikować',
    'ui__client/domain/chowner__empty_selection' => 'Musisz wybrać domeny, które chcesz przypisać do nowego właściciela',
    'ui__client/domain/check-permissions__empty_selection' => 'Musisz wybrać domeny, których pozwolenia pliku i folderu chcesz sprawdzić',
    'ui__client/domain/to-client__empty_selection' => 'Musisz wybrać domeny, których konta administratora chcesz skonwertować do kont klienta',

    // list objects filtering
    'domains_list__name__filter_title' => 'Nazwa',
    'domains_list__state__filter_title' => 'Zużycie zasobu',
    'domains_list__filter_state_any' => 'Jakikolwiek',
    'domains_list__filter_state_overuse' => 'Nadmiarowe zużycie',
    'domains_list__filter_state_normal' => 'W limitach',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Jakikolwiek',
    'domains_list__filter_status_blocked' => 'Zawieszone',
    'domains_list__filter_status_active' => 'Aktywne',
    'domains_list__ownership__filter_title' => 'Prawo własności',
    'domains_list__filter_ownership_all' => 'Wszystkie domeny',
    'domains_list__filter_ownership_personal' => 'Tylko moje domeny',
    'domains_list__filter_owner_pname__filter_title' => 'Nazwa właściciela',
    'domains_list__subrows__filter_title' => 'Pokaż',
    'domains_list__subrows_off' => 'Tylko domeny',
    'domains_list__subrows_subdomain_domainaliases' => 'Z poddomenami i aliasami',
    'domains_list__subrows_subdomain' => 'Z poddomenami',
    'domains_list__subrows_domainaliases' => 'Z aliasami',

    // objects list
    'domains_list__owner__title' => 'Właściciel',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Przeglądaj aplikacje",
    'site_apps__promo_main_text' => "Katalog Application Packaging Standard (APS) zawiera listę aplikacji, które mogą być dostarczone do domeny lub przestrzeni internetowej. Jeśli chciałbyś dostarczyć aplikacje, które obecnie nie znajdują się w katalogu, możesz to łatwo zrobić za pomocą następujących instrukcji pakowania APS dostępnych na stronie www.apsstandard.com",
    'site_apps__promo_download_now' => "Pobierz aplikacje:",
    'site_apps__promo_close' => "Zamknij i zablokuj",
    'site_apps__promo_preset__mostused' => '%1 najpopularniejszy',
    'site_apps__promo_preset__lessused' => 'Następny %1 najpopularniejszy',
    'site_apps__promo_preset__all' => "Wszystkie",
    'site_apps__promo_disclaimer_note' => 'Zauważ, że aplikacje zainstalowane z katalogu APS są dostarczane przez dostawcę zewnętrznego i nie są obsługiwane przez Plesk.',
    'site_apps__promo_preset__page_title' => '%1 aplikacje APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Trwa dodawanie aplikacji...',

    // Errors
    'site_apps__no_applications_for_update' => 'Nie masz żadnych aplikacji zainstalowanych w skarbcu aplikacji.',
    'site_apps__incorrect_download_preset_configuration' => 'Znaleziono błędy w konfiguracji pobranego katalogu APS z ustawieniami fabrycznymi.',
    'site_apps__aps_catalog_url_is_invalid' => 'Podano nieprawidłowy URL.',
    'site_apps__no_updates_at_the_moment' => 'W tej chwili żadne aktualizacje aplikacji nie są dostępne.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Otrzymano niepoprawną informację z katalogu aplikacji APS. Spróbuj ponownie później.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Ustawienia katalogu APS zostały zapisane, ale Plesk nie może ustanowić połączenia z katalogiem APS określonym w ustawieniach katalogu APS (%1). Upewnij się, że adres katalogu APS jest poprawny i że katalog pod tym adresem jest aktywny.',
    'site_apps__cannot_retrieve_updates' => 'W tej chwili nie można pobrać aktualizacji aplikacji: nie można ustanowić połączenia z katalogiem APS (%1). Upewnij się, że adres katalogu APS jest poprawny i że katalog pod tym adresem jest aktywny.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Brak aplikacji sieciowych dostępnych do instalacji.',
    'site_apps__site_applications_already_installed_in_root' => 'Inne aplikacje sieciowe są już zainstalowane w katalogach root tych wirtualnych hostów',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Aplikacje .NET nie są obsługiwane na platformie Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Aplikacje sieciowe serwera nie są obsługiwane',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 więcej aplikacji sieciowych jest zaplanowanch do dodania do skarbca aplikacji.",
    'site_apps__applications_all_in_vault' => "Wybrane aplikacje sieciowe znajdują się już w skarbcu aplikacji.",
    'site_apps__applications_already_in_download_queue' => "%1 wybranych aplikacji sieciowych jest właśnie dodawanych do skarbca aplikacji.",
    'site_apps__applications_already_in_valut' => "%1 wybranych aplikacji sieciowych jest już w skarbcu aplikacji.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Inne ( bez kategorii)',

    // Errors
    'site_apps__no_applications_in_category' => 'Brak dostępnych aplikacji w tej kategorii. Proszę wybrać inną kategorię.',
    'site_apps__no_category_selected__please_specify' => 'Wybierz kategorię w menu po lewej stronie. Wszystkie aplikacje dostępne w wybranej kategorii będą wyświetlane w tym oknie.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Konto administratora',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Ogólny',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Zmień nazwę hosta',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Bezpieczeństwo',
    'bt_setup_firewall' => 'Ustaw zaporę firewall',
    'bt_manage_firewall_rules' => 'Reguły zarządzania zaporą ogniową (firewall)',
    'cu_firewall__rule' => 'Utwórz regułę firewalla',
    'cu_firewall__protocol' => 'Ustaw protokół dla reguły (\'tcp\' lub \'udp\')',
    'cu_firewall__name' => "Ustaw nazwę reguły",
    'cu_firewall__disabled' => 'Jeśli \'true\', reguła będzie wyłączona po utworzeniu',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Wybierz serwer DNS', // PFW
    'bt_soa_records_template' => 'Szablon rekord OA',
    'bt_restrict_creation_of_subzones' => 'Ogranicz możliwość tworzenia podstref',

    'databases' => 'Bazy danych',
    'bt_select_mssqlwebadmin' => 'Wybierz MS SQL Webadmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplikacje',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Poczta',
    'bt_select_mailserver' => 'Wybierz serwer poczty e-mail', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Wybierz program antywirusowy', // PFW
    'bt_virus_protection_settings' => 'Ustawienia ochrony przed wirusami',
    'bt_select_spamfilter' => 'Wybierz filtr spamu', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Wybierz Webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logi i Statystyki',
    'bt_server_statistics_settings' => 'Ustawienia statystyk serwera',
    'bt_select_web_statistics' => 'Dostępne oprogramowanie statystyk internetowych', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interfejs Plesk',

    'components_and_modules' => 'Komponenty i moduły',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Ustaw Watchdog', // PFU
    'bt_setup_vpn' => 'Ustaw VPN', // PFU
    'bt_setup_samba' => 'Ustaw aplikację samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Ustawienia',
    'ui__client/domain/settings_self__short-title' => 'Ustawienia',
    'ui__client/domain/settings_self__description' => 'Zobacz i zmień ustawienia domeny.',

    'domain_administrator_account' => 'Konto administratora domeny',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Ustawienia konta',

    'domain' => 'Domena',
    'bt_dns_soa_records' => 'Rozpakuj pliki',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Ustawienia harmonogramu zadań',

    'website' => 'Strona WWW',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Tworzenie skryptów dla użytkowników sieci',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => 'Wybierz certyfikat SSL/TLS',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Statystyki WWW',
    'bt_log_rotation_settings' => 'Strona ustawień rotacji logów',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limity", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Polityka nadużycia i zawyżania ceny",
    'limits__overuse_policy_legend' => "Nadmiarowe zużycie",
    'limits__oversell_policy_legend' => "Zawyżanie ceny",
    'limits__reseller_overuse_description' => "Polityka nadużycia mówi Plesk co robić kiedy zasoby są nadmiernie zużyte.",
    'limits__overuse_text' => "Polityka nadużyć",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Powierzchnia dysku i ruch',
    'limit__disk_space' => 'Przestrzeń dyskowa',
    'limit__max_traffic' => 'Transfer',
    'limit_group__client' => 'Klienci',
    'limit__max_cl' => 'Klienci',
    'limit_group__domain' => 'Domeny',
    'limit__max_dom' => 'Domeny',
    'limit__max_dom_powerUser' => 'Subskrypcje',
    'limit__max_subdom' => 'Subdomeny',
    'limit__max_dom_aliases' => 'Aliasy domen',
    'limit__max_wu' => 'Użytkownicy Stron',
    'limit__max_subftp_users' => 'Dodatkowe konta FTP', // PFW
    'limit_group__mail' => 'Poczta',
    'limit__max_box' => 'Skrzynki pocztowe',
    'limit__mbox_quota' => 'Rozmiar skrzynki pocztowej',
    'limit__total_mboxes_quota' => 'Całkowita quota pocztowa', // PFW
    'limit__max_maillists' => 'Listy mailingowe',
    'limit_group__database' => 'Bazy danych',
    'limit__max_mssql_db' => 'Bazy danych serwera Microsoft SQL', // PFW
    'limit__mssql_dbase_space' => 'Limit baz danych MS SQL w sumie', // PFW
    'limit__max_odbc' => 'Połączenia ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Ograniczenie bazy danych MySQL', // PFW?
    'limit_group__application' => 'Aplikacje',
    'limit__max_iis_app_pools' => 'Pule aplikacji IIS', // PFW
    'limit_group__security' => 'Bezpieczeństwo',
    'limit_group__validity' => 'Data ważności',
    'limit__expiration' => 'Data ważności',
    'limit__validity' => 'Okres ważności',
    'limit__max_site_builder' => 'Strony opublikowane za pomocą Presence Builder',
    'limit__max_site' => 'Domeny',
    'limit__mssql_dbase_filesize' => 'Rozmiar pliku bazy danych MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Rozmiar pliku logu bazy danych MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Maksymalny rozmiar pliku bazy danych Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Maksymalny rozmiar pliku logu bazy danych Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Nieprawidłowy limit domen. Minimalna wartość wynosi 1.',

    'property__has_wrong_value' => 'Własność %1 ma niepoprawną wartość.',
    'property__name_outgoing_messages_domain_limit' => 'Ustawia domyślny limit wiadomości wychodzących z domeny (na godzinę). Aby ustawić nieograniczoną wartość, wpisz "-1". Wpisz "domyślny", aby ustawić wartość określoną w ogólnych ustawieniach serwera.',
    'property__name_outgoing_messages_mbox_limit' => 'Ustawia domyślny limit wiadomości wychodzących ze skrzynki pocztowej (na godzinę). Aby ustawić nieograniczoną wartość, wpisz "-1". Wpisz "domyślny", aby ustawić wartość określoną w ogólnych ustawieniach serwera.',
    'property__name_outgoing_messages_subscription_limit' => 'Ustawia domyślny limit wiadomości wychodzących z subskrypcji (na godzinę). Aby ustawić nieograniczoną wartość, wpisz "-1". Wpisz "domyślny", aby ustawić wartość określoną w ogólnych ustawieniach serwera.',

    // for CLI report & email notifications
    '__resource_notify' => 'Zawiadom',
    '__general' => 'Ogólny',
    '__template_shared' => 'Współdzielony szablon',
    'limit__overuse' => 'Polityka nadużyć',
    'limit__max_traffic_soft' => 'Powiadom o osiągnięciu limitu wykorzystania ruchu',
    'limit__disk_space_soft' => 'Powiadom o maksymalnym wykorzystaniu miejsca na dysku',
    '__overuse' => 'Polityka nadużyć',
    'performance__title' => 'Wydajność',
    'performance__bandwidth' => 'Maksymalne użycie transferu (KB/S)',
    'performance__max_connections' => 'Liczba połączeń ograniczona do',

    'gch__hosting_php_isapi' => 'Uruchom PHP jako rozszerzenie ISAPI',
    'gch__hosting_ssi_html' => 'Używaj SSI dla plików *.htm, *.html',
    'gch__hosting_php_handler_type' => 'uruchom PHP jako',
    'gch__hosting_php_handler_id' => 'uruchom PHP jako',
    'gch__hosting_php_served_by_nginx' => 'PHP obsługiwany przez nginx',
    'gch__hosting_unpaid_website_status' => 'Status serwisów w zawieszonych subskrypcjach',
    'gch__mn_no_autoresponder' => 'Nie ma żadnych autoresponderów dla tej nazwy skrzynki.',
    'gch__no_clients_selected' => "Nie wybrano żadnego klienta",
    'gch__no_domains_selected' => "Nie wybrano żadnej domeny",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/miesiąc",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nazwa zasobu',
    '__resource_usage' => 'Zużyto',
    '__resource_limit' => 'Limit',

    '__used' => 'Zużyto',
    '__limit' => 'Limit',

    '__never_expires' => 'Nigdy nie wygasa',
    '__resource_free' => '%1 wolne z %2',
    '__resource_unlimited' => '%1 użyte z nieskończoności',

    '__unlimited' => 'Nieograniczone',
    '__increment' => "Powiększ (+)",
    '__decrement' => "Pomniejsz (-)",
    '__pt' => 'elementy',
    '__procent' => '%',
    '__overused' => 'Nadużywane',
    '__left' => 'lewy',
    '__available' => 'dostępny',
    '__not_available' => 'Nie zawarty',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => 'Wyświetl historię ruchu',
    'ui__admin/report/traffic-history__title' => 'Wyświetl historię ruchu',
    'ui__admin/report/traffic-history__description' => 'Wyświetl historię ruchu dla sprzedawców, klientów i domen.',
    'admin_traffic_history__title' => 'Historia transferu',

    'ui__admin/report/layout/auto_unknown__short-title' => 'Harmonogram dostawy',
    'ui__admin/report/layout/auto_unknown__title' => 'Harmonogram dostarczania raportów',
    'ui__admin/report/layout/auto_unknown__description' => 'Wybierz raport harmonogramu dostawy dla layoutu raportu.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Dodaj Raport Harmonogramu Dostawy',
    'ui__admin/report/layout/auto/properties_new__title' => 'Dodaj Raport Harmonogramu Dostawy',
    'ui__admin/report/layout/auto/properties_new__description' => 'Dodaj raport harmonogramu dostawy dla raportu %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Harmonogram dostarczania raportów',
    'ui__admin/report/layout/auto/properties__title' => 'Harmonogram dostarczania raportów',
    'ui__admin/report/layout/auto/properties__description' => 'Wyświetl i modyfikuj właściwości raportu harmonogramu dostawy.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Usuń Raport Harmonogramu Dostawy',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Usuń Raport Harmonogramu Dostawy',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Usuń wybrany Raport Harmonogramu Dostawy.',

    'ui__admin/report/layout_unknown__short-title' => 'Layouty raportu',
    'ui__admin/report/layout_unknown__title' => 'Layouty raportu',
    'ui__admin/report/layout_unknown__description' => 'Wyświetl i zarządzaj layoutami raportów.',
    'ui__admin/report/layout/properties_unknown-new__short-title' => 'Stwórz layout raportu',
    'ui__admin/report/layout/properties_unknown-new__title' => 'Stwórz layout raportu',
    'ui__admin/report/layout/properties_unknown-new__description' => 'Stwórz layout raportu.',
    'ui__admin/report/layout/delete_multi__short-title' => 'Usuń układy raportów',
    'ui__admin/report/layout/delete_multi__title' => 'Usuń układy raportów',
    'ui__admin/report/layout/delete_multi__description' => 'Usuń wybrane layouty raportów',
    'ui__admin/report/layout/properties__short-title' => 'Właściwości',
    'ui__admin/report/layout/properties__title' => 'Właściwości layoutu raportu',
    'ui__admin/report/layout/properties__description' => 'Edytuj właściwości layoutów raportów.',

    // reseller
    'reseller_traffic_history__title' => "Historia ruchu sprzedawcy %1",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Wyświetl zużycie ruchu dla sprzedawcy %1',
    'ui__reseller/traffic__description' => 'Wyświetl raport zużycia ruchu dla konta sprzedawcy %1.',
    'ui__reseller/traffic_self__short-title' => 'Moje',
    'ui__reseller/traffic_self__title' => 'Wyświetl zużycie ruchu przez klientów',
    'ui__reseller/traffic_self__description' => 'Wyświetl raporty zużycia ruchu dla kont twojego klienta.',

    'ui__reseller/report/traffic-history__short-title' => 'Wyświetl historię ruchu',
    'ui__reseller/report/traffic-history__title' => 'Wyświetl historię ruchu',
    'ui__reseller/report/traffic-history__description' => "Wyświetl historię ruchuWyświetl historię ruchu sprzedawcy %1.",
    'ui__reseller/report/traffic-history_self__short-title' => 'Wyświetl historię ruchu',
    'ui__reseller/report/traffic-history_self__title' => 'Wyświetl historię ruchu',
    'ui__reseller/report/traffic-history_self__description' => 'Strona z historią statystyk ruchu.',

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Harmonogram dostawy',
    'ui__reseller/report/layout/auto_unknown__title' => 'Harmonogram dostarczania raportów',
    'ui__reseller/report/layout/auto_unknown__description' => 'Wybierz raport harmonogramu dostawy dla layoutu raportu.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Dodaj Raport Harmonogramu Dostawy',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Dodaj Raport Harmonogramu Dostawy',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Dodaj raport harmonogramu dostawy dla raportu %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Harmonogram dostarczania raportów',
    'ui__reseller/report/layout/auto/properties__title' => 'Harmonogram dostarczania raportów',
    'ui__reseller/report/layout/auto/properties__description' => 'Wyświetl i modyfikuj właściwości raportu harmonogramu dostawy.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Usuń Raport Harmonogramu Dostawy',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Usuń Raport Harmonogramu Dostawy',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Usuń wybrany Raport Harmonogramu Dostawy.',

    'ui__reseller/report/layout_unknown__short-title' => 'Layouty raportu',
    'ui__reseller/report/layout_unknown__title' => 'Layouty raportu',
    'ui__reseller/report/layout_unknown__description' => 'Wyświetl i zarządzaj layoutami raportów.',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => 'Stwórz layout raportu',
    'ui__reseller/report/layout/properties_unknown-new__title' => 'Stwórz layout raportu',
    'ui__reseller/report/layout/properties_unknown-new__description' => 'Utwórz layout raportu.',
    'ui__reseller/report/layout/properties_new__short-title' => 'Stwórz layout raportu',
    'ui__reseller/report/layout/properties_new__title' => 'Stwórz layout raportu',
    'ui__reseller/report/layout/properties_new__description' => 'Utwórz layout raportu.',
    'ui__reseller/report/layout/delete_multi__short-title' => 'Usuń układy raportów',
    'ui__reseller/report/layout/delete_multi__title' => 'Usuń układy raportów',
    'ui__reseller/report/layout/delete_multi__description' => 'Usuń wybrane layouty raportów',
    'ui__reseller/report/layout/properties__short-title' => 'Właściwości',
    'ui__reseller/report/layout/properties__title' => 'Właściwości layoutów raportów',
    'ui__reseller/report/layout/properties__description' => 'Edytuj właściwości layoutów raportów.',

    // customer
    'cl_traffic_history__title' => "Historia ruchu klienta %1",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Wyświetl zużycie ruchu dla klienta %1',
    'ui__client/traffic__description' => 'Wyświetl raporty zużycia ruchu dla kont klienta %1.',
    'ui__client/traffic_self__short-title' => 'Zużycie ruchu',
    'ui__client/traffic_self__title' => 'Wykorzystanie ruchu sieciowego według domen',
    'ui__client/traffic_self__description' => 'Wyświetl raporty zużycia ruchu dla twoich domen.',

    'ui__client/report/traffic-history__short-title' => 'Wyświetl historię ruchu',
    'ui__client/report/traffic-history__title' => 'Wyświetl historię ruchu',
    'ui__client/report/traffic-history__description' => 'Podgląd historii zużycia pasma dla %1.',
    'ui__client/report/traffic-history_self__short-title' => 'Wyświetl historię ruchu',
    'ui__client/report/traffic-history_self__title' => 'Wyświetl historię ruchu',
    'ui__client/report/traffic-history_self__description' => 'Strona z historią statystyk ruchu.',



    // domain
    'dom_traffic_history__title' => "Historia ruchu domeny %1",

    'ui__client/domain/report/traffic-history__short-title' => 'Wyświetl historię ruchu',
    'ui__client/domain/report/traffic-history__title' =>  'Wyświetl historię ruchu',
    'ui__client/domain/report/traffic-history__description' => 'Zobacz historię użycia transferu dla strony %1.',
    'ui__client/domain/report/traffic-history_self__short-title' => 'Wyświetl historię ruchu',
    'ui__client/domain/report/traffic-history_self__title' =>  'Wyświetl historię ruchu',
    'ui__client/domain/report/traffic-history_self__description' => 'Zobacz historię ruchu dla twojej domeny.',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => 'Statystki Web SSL',
    'ui__client/domain/report/web-stats-ssl__title' => 'Statystyki bezpiecznych odwiedzin dla witryny %1',
    'ui__client/domain/report/web-stats-ssl__description' => 'Statystyki bezpiecznych odwiedzin dla witryny %1.',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => 'Statystyki WWW SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_self__title' => 'Statystyki dotyczące bezpiecznych odwiedzin na twojej stronie',
    'ui__client/domain/report/web-stats-ssl_self__description' => 'Statystyki dotyczące bezpiecznych odwiedzin na twojej stronie.',
    'ui__client/domain/report/ftp-stats__short-title' => 'Statystyki usługi FTP',
    'ui__client/domain/report/ftp-stats__title' => 'Statystyki konta FTP dla domeny %1',
    'ui__client/domain/report/ftp-stats__description' => 'Statystyki konta FTP dla domeny %1',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'Statystyki usługi FTP',
    'ui__client/domain/report/ftp-stats_self__title' => 'Statystyki FTP dla twojej domeny',
    'ui__client/domain/report/ftp-stats_self__description' => 'Statystyki konta FTP dla twojej domeny.',
    'ui__client/domain/report/anon-ftp-stats__short-title' => 'Statystyki dla usługi Anonimowy FTP',
    'ui__client/domain/report/anon-ftp-stats__title' => 'Statystyki anonimowego konta FTP dla domeny %1',
    'ui__client/domain/report/anon-ftp-stats__description' => 'Statystyki anonimowego konta FTP dla domeny %1',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => 'Statystyki dla usługi Anonimowy FTP',
    'ui__client/domain/report/anon-ftp-stats_self__title' => 'Statystyki anonimowego konta FTP dla domeny %1',
    'ui__client/domain/report/anon-ftp-stats_self__description' => 'Statystyki anonimowego konta FTP dla domeny %1',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Właściwości programu Webalizer',
    'ui__client/domain/report/webalizer-preferences__title' => 'Właściwości programu Webalizer dla strony %1',
    'ui__client/domain/report/webalizer-preferences__description' => 'Przystosuj prezentację raportów statystycznych stworzonych w Webalizerze dla witryny %1.',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Właściwości programu Webalizer',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Właściwości programu Webalizer dla strony %1',
    'ui__client/domain/report/webalizer-preferences_self__description' => 'Przystosuj prezentację raportów statystycznych stworzonych w Webalizerze dla witryny %1.',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nazwa sprzedawcy', // reseller report
    'report__full_client_name' => 'Nazwa klienta', // customer report
    'report__full_domain_name' => 'Nazwa domeny', // domain report
    'report__full_owner' => 'Właściciel', // customer & domain reports
    'report__full_creation_date' => 'Data utworzenia',
    'report__full_size' => 'Rozmiar',
    'report__full_traffic' => 'Transfer',
    'report__full_active_clients' => 'Aktywni klienci', // reseller report
    'report__full_clients' => 'Klienci', // reseller report
    'report__full_active_domains' => 'Aktywne domeny', // reseller & customer reports
    'report__full_domains' => 'Domeny', // reseller & customer reports
    'report__full_subdomains' => 'Subdomeny',
    'report__full_mboxes' => 'Skrzynki pocztowe',
    'report__full_disk_space' => 'Przestrzeń dyskowa',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Odpowiedź',
    'report__full_mail_antispam' => 'Aspam',
    'report__full_mail_antivirus' => 'Avir',
    'report__full_mail_lists' => 'Lista mailingowa',
    'report__full_web_users' => 'Użytkownik sieciowy',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => 'Ogólny',
    'report__version' => 'Wersja produktu',
    'report__build' => 'Egzemplarz produktu',
    'report__status' => 'Status',
    'report__company_name' => 'Nazwa firmy',
    'report__personal_name' => 'Imię i Nazwisko',
    'report__login' => 'Nazwa użytkownika',
    'report__phone' => 'Numer telefonu',
    'report__fax' => 'Faks',
    'report__email' => 'E-mail',
    'report__address' => 'Adres',
    'report__city' => 'Miasto',
    'report__state' => 'Stan/prowincja',
    'report__zip_code' => 'Kod pocztowy',
    'report__country' => 'Kraj',
    'report__creation_date' => 'Data utworzenia',
    'report__expiration_date' => 'Data ważności',
    'report__dumps_total_size' => 'Całkowity rozmiar plików kopii zapasowych',
    'report__section_resellers' => 'Sprzedawcy',
    'report__active_resellers' => 'Sprzedawcy z aktywnymi subskrypcjami',
    'report__resellers' => 'Sprzedawcy',
    'report__section_full_resellers' => 'Sprzedawcy',
    'report__section_clients' => 'Klienci',
    'report__active_clients' => 'Klienci z aktywnymi subskrypcjami',
    'report__clients' => 'Klienci',
    'report__section_full_clients' => 'Klienci',
    'report__section_personal_clients' => 'Klienci',
    'report__active_personal_clients' => 'Twoi klienci z aktywnymi subskrypcjami',
    'report__personal_clients' => 'Klienci',
    'report__section_full_personal_clients' => 'Klienci',
    'report__section_domains' => 'Domeny',
    'report__disk_usage' => 'Zajętość dysku',
    'report__traffic' => 'Transfer',
    'report__active_domains' => 'Aktywne domeny',
    'report__domains' => 'Domeny',
    'report__subdomains' => 'Subdomeny',
    'report__mboxes' => 'Skrzynki pocztowe',
    'report__mail_groups' => 'Przekazywanie poczty',
    'report__mail_autoresp' => 'Autorespondery',
    'report__mail_lists' => 'Listy mailingowe',
    'report__web_users' => 'Użytkownicy Stron',
    'report__mysql_databases' => 'Bazy danych MySQL',
    'report__mssql_databases' => 'Bazy danych MSSQL',
    'report__section_full_domains' => 'Domeny',
    'report__section_personal_domains' => 'Domeny osobiste',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domeny osobiste',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Strony opublikowane za pomocą Presence Builder',
    'report__invalid_email' => 'Proszę podać prawidłowy adres e-mail.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Użytkownicy web',
    'report__section_mailnames' => 'Konta pocztowe',
    'report__section_maillists' => 'Listy mailingowe',
    'report__section_databases' => 'Bazy danych',
    'report__section_siteapps' => 'Aplikacje WWW',
    'report__section_aspnetapps' => 'Aplikacje ASP.NET', // PFW
    'report__owner_pname' => "Indywidualna nazwa dostawcy",
    'report__owner_login' => "Login dostawcy",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Podany pakiet językowy jest zainstalowany, ale nie jest odblokowany w twoim systemie.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Usuń sesję',
    'ui__sessions/delete__title' => 'Usuń sesję',
    'ui__sessions/delete__description' => 'Usuń wybrane sesje.',
    'ui__ftp-sessions__short-title' => 'Sesje FTP',
    'ui__ftp-sessions__title' => 'Sesje FTP',
    'ui__ftp-sessions__description' => 'Wyświetl sesje FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Usuń sesje FTP',
    'ui__ftp-sessions/delete__title' => 'Usuń sesje FTP',
    'ui__ftp-sessions/delete__description' => 'Usuń wybrane sesje FTP.',
    'ui__ts-sessions__short-title' => 'Sesje TS',
    'ui__ts-sessions__title' => 'Sesje TS',
    'ui__ts-sessions__description' => 'Zobacz sesje usługi terminala.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Usuń sesję',
    'ui__reseller/sessions/delete__title' => 'Usuń sesję',
    'ui__reseller/sessions/delete__description' => 'Usuń wybrane sesje.',
    'ui__reseller/sessions/delete_self__short-title' => 'Usuń sesję',
    'ui__reseller/sessions/delete_self__title' => 'Usuń sesję',
    'ui__reseller/sessions/delete_self__description' => 'Usuń wybrane sesje.',
    'ui__reseller/ftp-sessions__short-title' => 'Sesje FTP',
    'ui__reseller/ftp-sessions__title' => 'Sesje FTP',
    'ui__reseller/ftp-sessions__description' => 'Wyświetl sesje FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Sesje FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Sesje FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Wyświetl sesje FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Usuń sesje FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Usuń sesje FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Usuń wybrane sesje FTP.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Usuń sesje FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Usuń sesje FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Usuń wybrane sesje FTP.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Usuń sesję',
    'ui__client/sessions/delete__title' => 'Usuń sesję',
    'ui__client/sessions/delete__description' => 'Usuń wybrane sesje.',
    'ui__client/sessions/delete_self__short-title' => 'Usuń sesję',
    'ui__client/sessions/delete_self__title' => 'Usuń sesję',
    'ui__client/sessions/delete_self__description' => 'Usuń wybrane sesje.',

    // domain administrator

    'forgery_token_expired' => 'Token sesji wygasł.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Następujące konta sprzedawcy będą konwertowane na konta klienta',
    'downgradeResellers__downgrade' => 'Konta sprzedawcy, które będą konwertowane',
    // controls
    'downgradeResellers__submit_downgrade' => 'Przeprowadź konwertowanie konta.',
    'downgradeResellers__cancel_downgrade' => 'Anuluj konwersję konta.',
    'downgradeResellers__confirm' => 'Potwierdź konwersję',
    'downgradeResellers__confirm_message' => 'Potwierdź konwersję konta, aby kontynuować',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Wybierz konta klientów',
    'upgradeClients__upgrade_clients' => 'Następujące konta klienta zostaną przekonwertowane do kont sprzedawcy',
    'upgradeClients__upgrade' => 'Konta klienta, które zostaną przekonwertowane',
    // controls
    'upgradeClients__submit_upgrade' => 'Przeprowadź konwertowanie konta.',
    'upgradeClients__cancel_upgrade' => 'Anuluj konwersję konta.',
    'upgradeClients__confirm' => 'Potwierdź konwersję',
    'upgradeClients__confirm_message' => 'Potwierdź konwersję konta, aby kontynuować',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Nie udało się zmienić konta \'%1\' na konto sprzedawcy: \'%1\' jest już sprzedawcą.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Następujące konta administratora domeny zostaną przekonwertowane do kont klienta',
    'upgradeDomainUser__upgrade' => 'Konta administratora domeny które zostaną przekonwertowane',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Przeprowadź konwertowanie konta.',
    'upgradeDomainUser__cancel_upgrade' => 'Anuluj konwersję konta.',
    'upgradeDomainUser__confirm' => 'Potwierdź konwersję',
    'upgradeDomainUser__confirm_message' => 'Potwierdź konwersję konta, aby kontynuować',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Konta administratora domeny które nie mogą zostać przekonwertowane',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Następujące konta administratora domeny nie mogą zostać przekonwertowane do konta klienta:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Kilka kont administratorów domeny nie może zostać przekonwertowanych do konta klienta. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Konto administratora domeny nie istnieje',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domena powinna należeć bezpośrednio do administratora serwera lub sprzedawcy.",
    'upgradeDomainUser__all_logins_already_used' => 'Nie można stworzyć konta dla klienta wynikowego.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Konto administratora domeny zostało przekonwertowane',
    'upgradeDomainUser__upgrade_notification_body' => 'Konto administratora domeny zostało przekonwertowane do konta klienta o nazwie \'%%login%%\' and password \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => 'Przypisz nowego właściciela do konta %1 klienta', // customer home
    'ui__client/chowner_multi__wizard-title' => 'Przypisz nowego właściciela do wybranych kont klienta', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => 'Przypisz nowego właściciela dla wybranych kont użytkownika', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => 'Wybierz konta klientów',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => 'Wybierz konta klienta, które chcesz przenieść do innego właściciela.',
    //  owner selection
    'client_chown__select_title' => 'Wybierz nowego właściciela dla kont klientów',
    'client_chown__select-multi_title' => 'Wybierz nowego właściciela dla kont klientów',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "Wybierz nowego właściciela dla wybranych kont klienta.", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => 'Wybierz nowego właściciela dla wybranych kont klienta.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => 'Wybierz nowego właściciela dla wybranych kont klienta.', // reseller & admin home
    // changes check page
    'client_chown__check_title' => 'Przejrzyj zmiany i zakończ kreator',
    'ui__client/chowner__wizard__2' => 'Przejrzyj zmiany i kliknij Zakończ, aby zakończyć kreatora.', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => 'Przejrzyj zmiany i kliknij Zakończ, aby zakończyć kreatora.', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => 'Przejrzyj zmiany i kliknij Zakończ, aby zakończyć kreatora.', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => 'Musisz wybrać nowego właściciela dla wybranych kont klienta',
    'clientOwnerChanger__unable_to_transfer_some_clients' => 'Nie można przenieść jednego lub więcej kont(a) do nowego użytkownika.',
    'client_chown__client_warn' => 'Opis',

    'clientOwnerChanger__owner_has_no_permission' => 'Wybrany sprzedawca nie ma uprawnień \'%1\', ale niektórzy klienci posiadają to uprawnienie.',
    'clientOwnerChanger__application_not_allowed' => 'Aplikacja \'%1\' nie jest dostępna dla wybranych sprzedawców, ale jest dostępna dla niektórych klientów.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Zmiana przypisania wybranych subskrypcji',
    // errors
    'domain_chown__empty_selection' => 'Musisz wybrać nowego właściciela wybranych domen',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => 'Wydajność',
    'hosting_performance__traffic_bandwidth_legend' => 'Włącz ograniczenia prędkości połączenia',
    'hosting_performance__traffic_bandwidth_legend_ro' => 'Ograniczenie pasma',
    'hosting_performance__traffic_bandwidth_label' => 'Ogranicz prędkość połączenia do (%1)',
    'hosting_performance__traffic_bandwidth_hint' => 'Ograniczania przepustowości dotyczą tylko danych przekazywanych za pośrednictwem protokołu HTTP.',
    'hosting_performance__max_connection_legend' => 'Włącz ograniczenie ilości połączeń',
    'hosting_performance__max_connection_legend_ro' => 'Ograniczenie połączeń',
    'hosting_performance__max_connection_label' => 'Liczba połączeń ograniczona do',
    'hosting_performance__max_connection_hint' => 'Jeśli ograniczysz przepustowość pasma, zalecamy także ograniczyć liczbę jednoczesnych połączeń ze stroną. W przeciwnym razie, w przypadku częstych odwołań na stronie, procesy na serwerze sieciowym zwiększą obciążenie serwera.',

    // errors:
    'performance__qos_not_installed' => 'Funkcja została wyłączona, ponieważ QoS nie jest zaisntalowany',
    'performance__bandwidth_throttling' => 'Nie możesz kontrolować ograniczeń łącza ponieważ QuS nie jest zainstalowany.',
    'performance__invalid_value' => "Wartość jest błędna. Powinna być z zakresu od %1 do %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Poczta webowa',
    'webmail__server_text' => 'Dostępne klienty webmail',
    'webmail__none' => 'Żaden',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Pula adres P serwera',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Baza danych nie będzie przywrócona: brak odpowiedniego serwera bazy danych',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Kopia zapasowa serwera.",
    '__default_backup_comment_reseller' => "Kopia zapasowa konta sprzedawcy utworzona przez %1.",
    '__default_backup_comment_client' => "Kopia zapasowa konta klienta utworzona przez %1.",
    '__default_backup_comment_domain' => "Kopia zapasowa utworzona przez %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => 'Zdefiniuj ustawienia mapowania adres P',
    'backup__ip_mapping__download' => 'Zapisz obecne ustawienia mapowania IP do pliku',
    'b_backup__ip_mapping__download' => 'Kliknij, aby pobrać konfigurację mapowania IP.',
    'b_backup__ip_mapping__download_is_empty' => 'Konfiguracja mapowania IP jest pusta.',
    'backup__ip_mapping_upload__title' => 'Wgraj plik z ustawieniami mapowania IP',
    'backup__ip_mapping__upload' => 'Wgraj plik z ustawieniami mapowania IP',
    'b_backup__ip_mapping__upload' => 'Kliknij, aby wgrać konfigurację mapowania IP.',
    'backup__ip_mapping__list__header' => 'Mapowanie IP',
    'backup__ip_mapping__list__adddress' => 'Stare adresy IP',
    'backup__ip_mapping__list__select_ip' => 'Nowe adresy IP',
    'backup__ip_mapping__clients_ip' => "Pula IP dla klienta %1",
    'backup__ip_mapping__resellers_ip' => "Pula IP sprzedawcy %1",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => 'Dedykowane adresy IP powinny być mapowane do unikatowych adresów IP. Wybierz unikatowy adres IP dla każdego dedykowanego adresu IP z listy.',
    'backup__ip_mapping__legend' => 'Mapowanie IP',
    'backup__ip_mapping__upload_legend' => 'Wgraj',
    'backup__ip_mapping__upload_file_text' => 'Plik z ustawieniami mapowania IP',
    'backup__ip_mapping__upload_file_hint' => 'Plik z ustawieniami mapowania IP jest zapisany w tzw. "plain text". Każda linia zawiera przypisanie w formacie: <stary adres IP> <nowy adres IP>',
    'backup__ip_mapping__ip_address_not_found' => 'Brak dostępnych adresów IP tego typu.',
    'backup__ip_mapping__ip_address_not_found_hint' => 'Nie udało się wykonać transferu danych: Mapowanie adresów IP jest niekompletne, ponieważ w puli na serwerze docelowym brakuje wolnych adresów IP..',
    'backup__ip_mapping__ftp_will_be_disabled' => 'Niezabezpieczone połączenia FTP nie będą dozwolone dla domen o tym adresie IP.',
    'backup__ip_mapping__ftps_will_be_disabled' => 'Bezpieczne połączenia FTPS nie będą dozwolone dla domen o tym adresie IP.',

    // Conflicts occured
    'legend_conflicts_occured' => 'Konflikty',
    'backup__restore__object_vhost' => 'Wirtualny host',
    'backup__restore__object_plesk_admin' => 'Administrator Plesk',
    'backup__restore__object_ftpuser' => 'Konto FTP',
    'backup__restore__object_frontpageuser' => 'konto FrontPage',
    'backup__restore__object_webuser' => 'użytkownik sieci',
    'backup__restore__object_domain' => 'domena',
    'backup__restore__object_subdomain' => 'subdomena',
    'backup__restore__object_domainalias' => 'alias domeny',
    'backup__restore__object_client' => 'klient',
    'backup__restore__object_reseller' => 'sprzedawca',
    'backup__restore__object_autoresponder' => 'auto-odpowiedź',
    'backup__restore__object_mailalias' => 'alias poczty',
    'backup__restore__object_database' => 'baza danych',
    'backup__restore__object_mailname' => 'konto pocztowe',
    'backup__restore__object_db_user' => 'użytkownik bazy danych',
    'backup__restore__object_ssl_certificate' => 'Certyfikat SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Następujący sprzedawcy nie mogą być przywróceni, ponieważ są zamienieni w klientów: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Następujący klienci nie mogą być przywróceni, ponieważ są zamienieni w sprzedawców: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Następujący klienci nie mogą być przywróceni, ponieważ zostali przeniesieni do innego właściciela: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Niewystarczająca przestrzeń na dysku na serwerze docelowym, aby przenieść wszystkie wybrane subskrypcje. Dostępne: %1 MB. Wymagane: %2 MB. Zauważ, że wymagana przestrzeń jest obliczona jako suma zawartości serwisów, poczty i bazy danych domeny. Wymagana przestrzeń jest obliczna raz dziennie i przechowywana w pamięci podręcznej, a zatem rzeczywisty rozmiar domen może się różnić od obliczonego rozmiaru. Jeśli upewnisz się, że wybrane domeny nie zajmują więcej miejsca niż to dostępne, możesz kontynuować transfer.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Proszę zwolnić miejsce na dysku na serwerze docelowym.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Niewystarczająca ilość przestrzeni dysku na serwerze źródłowym, aby przechować tymczasowe pliki używane do transferu. Dostępne: %1 MB. Wymagane: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Proszę zwolnić miejsce na dysku na serwerze źródłowym.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informacje o serwerze',

    'backup__restore__capability_not_installed_component_text' => 'Komponent %1 nie jest zainstalowany na serwerze docelowym. %1 będzie niedostępny dla wszystkich przywróconych obiektów.',
    'backup__restore__capability_not_installed_component_resolution' => 'Proszę zainstalować %1. Zauważ, że to może zająć kilka minut.',
    'backup__restore__capability_existing_sys_user_text' => 'Użytkownik systemu o nazwie %1 już istnieje na serwerze docelowym.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Proszę zmienić nazwę istniejącego użytkownika systemu na serwerze docelowym.',
    'backup__restore__capability_license_usage_text' => 'Następujące ograniczenia zasobów (zdefiniowane przez klucz licencyjny) zostaną przekroczone na serwerze docelowym po transferze danych:',
    'backup__restore__capability_license_usage_resolution' => 'Proszę zainstalować na serwerze docelowym inny klucz licencyjny, który zapewni odpowiednią ilość zasobów.',
    'backup__restore__capability_max_allowed_packet_text' => "Parametr 'max_allowed_packet' na źródłowym serwerze bazodanowym to %1, co stanowi wartość wyższą niż na serwerze docelowym, na którym wynosi %2. Niektóre obiekty bazy danych dla domen określonych poniżej mogą nie być przywrócone.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Proszę zwiększyć wartość 'max_allowed_packet' na docelowym serwerze bazodanowym.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Nie udało się przenieść baz danych PostgreSQL, ponieważ wersja PostgreSQL na serwerze docelowym jest wcześniejsza niż na serwerze źródłowym. Obecna wersja to %1, wersja wymagana to %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Zainstaluj wymaganą wersję PostgreSQL na serwerze docelowym.',
    'backup__restore__capability_db_server_connection_problems' => 'Nie udało sie połączyć z docelowym serwerem bazy danych PostgreSQL. Bazy danych nie będą przeniesione, jeśli nie przywrócisz połączenia.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Sprawdź ustawienia połączenia na docelowym serwerze bazy danych.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponent %1 jest wyłączony na serwerze docelowym.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Proszę włączyć %1 na serwerze docelowym.',
    'backup__restore__capability_not_configured_component_text' => 'Komponenty %1 nie są skonfigurowane na serwerze docelowym.',
    'backup__restore__capability_not_configured_component_resolution' => 'Proszę skonfigurować %1 na stronie Narzędzia & Ustawienia.',

    'backup__restore__capability_webmail_is_not_available' => 'Poczta webowa %1 nie jest dostępna na serwerze docelowym.. Zamiast niego Plesk wykorzysta następujący usługę poczty sieciowej: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Aby korzystać z tej samej poczty internetowej, co na serwerze źródłowym, należy zainstalować ją na tym serwerze.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Aby używać tej samej poczty webowej co na serwerze źródłowym, powinieneś zainstalować ją na serwerze docelowym.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Poczta sieciowa '%1' nie jest dostępna na serwerze docelowym. W zamian w następujących subskrypcjach: %3, Plesk wykorzysta następującą usługę poczty sieciowej: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Zainstaluj wymaganą pocztę sieciową na serwerze docelowym.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Ustawienia poczty sieciowej',

    'backup__restore__capability_shell_is_not_available' => 'Powłoka %1 nie jest dostępna na serwerze docelowym. W zamian zostanie użyta jedna z istniejących powłok.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Aby używać tej samej powłoki co na serwerze źródłowym, powinieneś włączyć ją lub zainstalować na serwerze docelowm.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Docelowy serwer DNS nie obsługuje sieci w szablonie ograniczeń transferu. Rekordy z sieciowymi adresami IP w ograniczeniach transferu DNS nie zostaną przywrócone.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Docelowy serwer DNS nie obsługuje sieci w szablonie ograniczeń transferu, ale niektóre subskrypcje mają sieci w ograniczeniach transferu DNS. Rekordy z sieciowymi adresami IP w ograniczeniach transferu DNS nie zostaną przywrócone.',

    'backup__restore__capability_wrong_php_handler_text' => 'Handler PHP %1 nie jest dostępny na serwerze docelowym. Zamiast niego Plesk wykorzysta następujący handler PHP: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Aby używać tego samego handlera PHP co na serwerze źródłowym, powinieneś włączyć lub zainstalować go na serwerze docelowym.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Handler PHP %1 nie jest dostępny. Zamiast tego, Plesk użyje %2 dla następujących planów usługi: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Handler PHP %1 nie jest dostępny. Zamiast tego, Plesk użyje %2 dla następujących strony: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Handler PHP %1 nie jest dostępny. Bedzie niedostępny dla następujących serwisów WWW: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 nie jest dostępne na serwerze docelowym. W zamian zostanie użyta wersja domyślna.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Aby używać tego samego %1 co na serwerze źródłowym, powinieneś włączyć lub zainstalować go na serwerze docelowym.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Polityka wykorzystania oprogramowania antywirusowego na przychodzącejdocelowym nie pozwala na indywidualne (według adresu e-mail) ustawienia antywirusowe dla poczty wychodzącej. Te ustawienia nie będą przeniesione.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Polityka wykorzystania oprogramowania antywirusowego na serwerze docelowym nie pozwala na indywidualne (według adresu e-mail) ustawienia antywirusowe dla poczty przychodzącej. Te ustawienia nie będą przeniesione.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Polityka wykorzystania oprogramowania antywirusowego na serwerze docelowym nie pozwala na indywidualne (według adresu e-mail) ustawienia antywirusowe. Te ustawienia nie będą przeniesione.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Aby przenieść spersonalizowane ustawienia antywirusowe (według adresu e-mail), należy włączyć korespondujące opcje w Narzędzia & Ustawienia > Ustawienia ochrony antywirusowej.",
    'backup__restore__capability_antivirus_not_active_text' => 'Brak włączonego oprogramowania antywirusowego. Wszystkie ustawienia antywirusowe z serwera źródłowego nie będą działały, dopóki nie wybierzesz oprogramowania antywirusowego na serwerze docelowym.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Proszę wybrać oprogramowanie antywirusowe w Narzędzia & Ustawienia > Ustawienia ochrony antywirusowej > Sekcja ustawień antywirusowych.',

    'backup__restore__capability_antivirus_another_active_text' => 'Oprogramowanie antywirusowe %2 nie jest dostępne na serwerze docelowym. W zamian użyte zostanie %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Aby używać tego samego antywirusa, co na serwerze źródłowym, zainstaluj go i wybierz w Narzędzia & Ustawienia > Ustawienia ochrony antywirusowej > Sekcja ustawień antywirusowych.',
    'backup__restore__capability_not_available_sni_text' => 'SNI nie jest dostępne na serwerze docelowym. Serwisy WWW, które mają ten sam adres IP nie będą mogły używać indywidualnych certyfikatów SSL/TLS.',
    'backup__restore__capability_not_available_sni_resolution' => "Sprawdź, czy system na serwerze docelowym obsługuje SNI i czy obsługa SNI jest włączona w Plesku (pole wyboru '\\Włącz obsługę SNI, która umożliwia używanie indywidualnych certyfikatów SSL/TLS w serwisach o tym samym adresie IP' w Narzędzia i ustawienia/>Ustawienia serwera.",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Ustawienia serwera',

    'backup__restore__capability_vhost_already_exists_text' => 'Serwis %1 nie może być przeniesiony: serwis o takiej samej nazwie już istnieje na serwerze docelowym.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Proszę zmienić nazwę serwisu lub usunąć serwis o tej samej nazwie z serwera.',
    'backup__restore__capability_removed_vhosts' => 'Następujące subskrypcje nie zostaną przywrócone, ponieważ zawierają nazwy domen, które już istnieją na serwerze docelowym: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Na serwerze źródłowym jest %3 różnych handlerów PHP typu %1 i wersji %2. W zamian jeden handler odpowiedniego typu i w odpowiedniej wersji zostanie wykorzystany na serwerze docelowym. Zauważ, że ustawienia PHP na serwerze docelowym i źródłowym mogą się różnić.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Instalator Plesk nie obsługuje Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Instalator Plesk nie obsługuje Python. Proszę ręcznie zainstalować Pythona.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Ustawienia serwera poczty',

    'backup__restore__capability_ftps_disabled' => 'Używanie bezpieczonego FTP jest dozowolone na serwerze źródłowym, ale zabronione na serwerze docelowym. Aplikacje użytkownika, które korzystają z FTP mogą działać niepoprawnie.',
    'backup__restore__capability_ftps_required' => 'Używanie niezabezpieczonego FTP jest dozowolone na serwerze źródłowym, ale zabronione na serwerze docelowym. Aplikacje użytkownika, które korzystają z FTP mogą działać niepoprawnie.',
    'backup__restore__capability_ftps_policy_resolution' => 'Zmień politykę bezpiecznego FTP w Narzędzia i ustawienia > Polityka bezpieczeństwa.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabajtów danych zostanie przeniesionych z serwera źródłowego na docelowy za %2 godzin/y.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Aby uzyskać szybszy transfer, sprawdż połączenie sieciowe pomiędzy serwerem źródłowym i docelowym i rozwiąż problemy (jeżeli wystąpią).',
    'backup__restore__too_low_download_speed' => "mniej niż 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Aby uzyskać szybszy transfer, sprawdż połączenie sieciowe pomiędzy serwerem źródłowym i docelowym i rozwiąż problemy (jeżeli wystąpią).',
    'backup__restore__capability_zero_download_speed_text' => 'Minimalna akceptowalna prędkość pobierania to %1 Mb/s. Prędkość pobierania pomiędzy serwerem źródłowym a docelowym wynosi 0 MBps. To może spowodować problemy z połączeniem sieciowym. Transferu nie jest możliwe.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Sprawdź połączenie sieciowe pomiędzy serwerem źródłowym i docelowym, aby rozwiązać problemy.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Minimalna akceptowalna prędkość pobierania to %2 Mb/s. Prędkość pobierania pomiędzy serwerem źródłowym a docelowym wynosi %1 Mb/s. To może zwiększyć czas transferu. W twoim obecnym środowisku migracja %3 MB zajmie %4 godzin/y.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Minimalna akceptowalna prędkość pobierania to %2 Mb/s. Prędkość pobierania pomiędzy serwerem źródłowym a docelowym wynosi %1 Mb/s. To może zwiększyć czas transferu.',

    'backup__restore__capability_remote_database_migration' => "Poniższe domeny korzystają ze zdalnych baz danych: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Nie usuwaj tych domen z serwera źródłowego po transferze, jeśli wersja Plesku na serwerze źródłowym jest wcześniejsza niż 11.5! Możesz je zawiesić. Jeśli usuniesz domeny, bazy danych zostaną usunięte z serwera zdalnego. Uwaga: Pliki dump zdalnych baz danych będą przechowywane na i w katalogu %1 na serwerze źródłowym.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Pliki kopii zapasowej serwerów bazy danych MySQL w wersji wcześniejszej niż 5.1 (%1) mogą nie zostać przywrócone na MySQL 5.1.x, ponieważ MySQL 5.1.x inaczej obsługuje znaki Unicode.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Proszę przeczytać powiązany artykuł z bazy wiedzy #136850',

    'backup__restore__capability_firewall_not_installed_text' => 'Rozszerzenie zapory ogniowej nie jest zainstalowane na serwerze docelowym. Jeśli ustanowiłeś reguły ograniczające dostep, reguly nie zadziałają.',
    'backup__restore__capability_firewall_not_installed_resolution' => 'Zainstaluj rozszerzenie zapory ogniowej używając instalatora Plesk.',
    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP nie jest zainstalowany na serwerze docelowym.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Zainstaluj Courier-IMAP używając instalatora Plesk.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot nie jest zainstalowany na serwerze docelowym.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Zainstaluj Dovecot używając instalatora Plesk.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Czas przechowywania statystyk ruchu sieciowego następujących obiektów jest mniejszy niż wartość ogólna dla serwera na serwerze docelowym.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Należy zmienić ogólną dla serwera wartość dla czasu przechowywania statystyk na serwerze docelowym. Powinna być równa lub mniejsza niż najmniejsza wartość w konfiguracji domen.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Czas przechowywania statystyk ruchu sieciowego na niektórych domenach jest mniejszy niż wartość ogólna dla serwera (%1). Wartość zostanie zmieniona na %1 dla tych domen.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Czas przechowywania statystyk ruchu w niektórych planach usługi jest mniejszy niż wartość ogólna dla serwera (%1). Dla tych planów wartość zostanie zmieniona na %1.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Mapowanie wyłącznego adresu IP na współdzielony zablokuje anonimowy FTP i HTTPS (chyba że włączona jest obsługa SNI).',

    'backup__restore__no_postgresql_commands_text' => 'Subskrypcja używa zdalnej bazy PostgreSQL, a tymczasowy plik jej kopii zapasowej nie może być wygenerowany, ponieważ na serwerze źródłowym brakuje polecenia pg_dump i psql.',
    'backup__restore__no_postgresql_commands_resolution' => 'Zainstaluj jakikolwiek pakiet klienta PostgreSQL, który obsługuje te polecenia.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Następujące moduły Apache są zablokowane na serwerze docelowym: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Uruchom te moduły, aby zapobiec możliwym problemom.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Następujące moduły Apache nie są zainstalowane na serwerze docelowym: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Zainstaluj i uruchom te moduły, aby zapobiec możliwym problemom.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Ograniczanie wiadomości wychodzących nie jest obsługiwane przez twoją licencję. Powiązane ustawienia konfiguracji nie zostaną przeniesione.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Zainstaluj klucz licencyjny na innym serwerze docelowym, który zapewnia wymagane własności.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Ograniczanie wiadomości wychodzących jest wyłączone na serwerze docelowym. Powiązane ustawienia konfiguracji nie zostaną przeniesione.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Włącz ograniczanie wiadomości wychodzących na serwerze docelowym.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Ustawienia serwera poczty',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Ograniczenie wiadomości wychodzących ze skrzynki pocztowej nie jest obsługiwane przez serwer poczty, który jest używany na serwerze docelowym. Wartość limitu nie zostanie przeniesiona.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Zmień serwer poczty na ten sam, którego używałeś na serwerze źródłowym.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Ustawienia serwera poczty',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Ograniczenie wiadomości wychodzących z domeny nie jest obsługiwane przez serwer poczty, który jest używany na serwerze docelowym. Wartość limitu nie zostanie przeniesiona.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Zmień serwer poczty na ten sam, którego używałeś na serwerze źródłowym.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Ustawienia serwera poczty',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Ograniczenie wiadomości wychodzących z subskrypcji nie jest obsługiwane przez serwer poczty, który jest używany na serwerze docelowym. Wartość limitu nie zostanie przeniesiona.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Zmień serwer poczty na ten sam, którego używałeś na serwerze źródłowym.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Ustawienia serwera poczty',

    'bu_conflict_resolver_absent_phosting' => 'Nie udało się przywrócić podanych plików, ponieważ fizyczny hosting do przywracania ich nie istnieje. Najpierw utwórz domenę z fizycznym hostingiem, a następnie ponownie rozpocznij przywracanie kopii zapasowej.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Dane sprzedawców nie zostaną przywrócone, ponieważ zarządzanie sprzedawcami nie jest obsługiwane.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Komponent ModSecurity nie jest zainstalowany na serwerze docelowym.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Zainstaluj ModSecurity, jesli chcesz zachować działającą zaporę ogniową aplikacji sieciowej dla przeniesionych serwisów. Pamiętaj, że instalacja może zająć trochę czasu.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Zainstaluj ModSecurity, jeśli chcesz przenieść ustawienia zapory ogniowej aplikacji sieciowej. Pamiętaj, że instalacja może zająć trochę czasu.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Komponenty ModSecurity nie są skonfigurowane na serwerze docelowym.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konfiguruj ModSecurity, jesli chcesz zachować działającą zaporę ogniową aplikacji sieciowej dla przeniesionych serwisów.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Zapora ogniowa aplikacji WWW (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity jest wyłączony na serwerze docelowym.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktywuj ModSecurity, jesli chcesz zachować działającą zaporę ogniową aplikacji sieciowej dla przeniesionych serwisów.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Zapora ogniowa aplikacji WWW (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Komponent ModSecurity nie jest zainstalowany. Ustawienia zapory ogniowej aplikacji WWW nie zostaną przywrócone dla następujących obiektów: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Serwisy WWW nie mogą być przywrócone, ponieważ należą do subskrypcji %1, która nie znajduje się w Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Komponent %1 nie jest zainstalowany na serwerze docelowym. Usługa DNS będzie niedostępna, a ustawienia DNS zostaną utracone. Wszystkie serwisy klienta będą zablokowane.',
    'bu_conflict_resolver_dns_not_installed' => 'Usługa DNS nie jest zainstalowana. Ustawienia DNS nie zostaną przywrócone dla następujących obiektów: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Następujące subskrypcje nie mogą zostac przywrócone, ponieważ zostały przesunięte do innych właścicieli: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Następujące subskrypcje nie mogą zostac przywrócone, ponieważ zostały przesunięte do innych właścicieli: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Nie udało się znaleźć funkcjonalności przywrócenia Web Presence Builder, aby przywrócić dane Web Presence Builder. Web Presence Builder prawdopodobnie nie jest zainstalowany.',
    'backup__restore__capability_renamed_db' => 'Nazwa bazy danych "%1" jest już używana przez inną subskrypcję. Nazwa przywróconej bazy danych zostanie zmieniona na "%2".',
    'backup__restore__capability_renamed_db_user' => 'Nazwa użytkownika bazy danych "%1" jest już uzywana przez inną subskrypcję. Nazwa użytkownika przywróconej bazy danych zostanie zmieniona na "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Instalator Plesk nie obsługuje Perl. Proszę ręcznie zainstalować ActiveState Perl.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% obsługiwany przez Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% obsługiwany przez nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Program antywirusowy Kaspersky',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => 'Konflikty synchronizacji',
    'backup__restore__hint_timing_conflicts' => 'Konflikty synchronizacji pojawiają się, gdy odtwarzany obiekt już istnieje w systemie z nowszą datą modyfikacji lub gdy odtwarzany obiekt nie znajduje się aktualnie w systemie.',
    'backup__restore__text_timing_resolution_policy_overwrite' => 'Użyj konfiguracji i danych z kopii zapasowej',
    'backup__restore__hint_timing_resolution_policy_overwrite' => 'Całkowicie nadpisz konfigurację obiektów i dane znajdujące się w tym momencie w systemie danymi i konfiguracją z kopii zapasowej. Jeśli przywrócone obiekty obecnie należą do innego właściciela, to obiekty zostaną przywrócone pod poprzednim właścicielem.',
    'backup__restore__text_timing_resolution_policy_proceed' =>  'Użyj konfiguracji z obecnego systemu i danych z kopii zapasowej',
    'backup__restore__hint_timing_resolution_policy_proceed' => 'Nadpisuj aktualne dane obiektu danymi z pliku kopii zapasowej, ale zachowaj konfigurację obiektu aktualnie znajdującą się w systemie. Jeśli przywracany obiekt obecnie należy do innego właściciela, zostanie przywrócony u aktualnego właściciela.',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => 'Nie przywracaj',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => 'Nie odtwarzaj obiektów, które mają konflikty synchronizacji.',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Konflikty wykorzystania zasobów',
    'backup__restore__hint_resource_usage_conflicts' => 'Konflikty wykorzystania zasobów pojawiają się, gdy po przywróceniu przekroczone zostaną limity wykorzystania zasobów odtwarzanego obiektu.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Pozwól nadużyć',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Przywróć obiekt i pozwól na wykorzystanie większej ilości zasobów niż początkowo ustalono.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Nie przywracaj',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Nie odtwarzaj obiektów, które mają konflikty wykorzystania zasobów.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konflikty konfiguracji',
    'backup__restore__hint_configuration_conflicts' => 'Konflikty konfiguracji występują, gdy przenoszony obiekt zawiera ustawienia i aplikacje sieciowe, które nie są dostępne lub są zabronione przez bieżący serwer lub politykę właściciela obiektu. Wystąpił problem z konfiguracją: odtwarzany obiekt zawiera ustawienia lub aplikacje, które są niedostępne lub zabronione na tym serwerze, albo są niezgodne z polityką właściciela.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatycznie',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Odtwórz obiekt i automatycznie włącz wszystkie opcje konfiguracyjne, którymi możesz zarządzać zgodnie ze swoimi uprawnieniami.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Nie przywracaj',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Nie odtwarzaj obiektów, które zawierają problemy z konfiguracją.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Pule aplikacji dedykowanych IIS nie są dostępne w ustawieniach puli aplikacji IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Zmień ustawienia puli aplikacji IIS w Narzędzia i ustawienia > Pula aplikacji IIS > Ustawienia globalne.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Współdzielone pule aplikacji IIS nie są dostępne w ustawieniach puli aplikacji IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Zmień ustawienia puli aplikacji IIS w Narzędzia i ustawienia > Pula aplikacji IIS > Ustawienia globalne.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Skrócone nazwy kont pocztowych POP3/IMAP nie są dostępne na serwerze docelowym.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Skrócone nazwy kont pocztowych będą niedostępne po przywróceniu danych.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Nie można otworzyć pliku logu.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Nie udało sie przywrócić subskrypcji %1: została usunięta z twojego konta i nie masz uprawnień do utworzenia subskrypcji. Jeśli musisz ją przywrócić, skontaktuj się z dostawcą usług.',

    'backup__error11' => 'Niewystarczająca przestrzeń na dysku dla kopii zapasowej.',
    'backup__error3011' => 'Odmówiono połączenia: Żadne programy nie odpowiadają pod podanym adresem i na podanym porcie.',
    'backup__error3012' => 'Przekroczono czas połączenia.',
    'backup__error3013' => 'Sieć jest nieosiągalna.',
    'backup__error3014' => 'Brak drogi do hosta.',
    'backup__error3015' => 'Połączenie nie udało się.',
    'backup__error3016' => 'Nie udało się rozwiązać nazwy hosta.',
    'backup__error3017' => 'Niepoprawna nazwa użytkownika lub hasło.',
    'backup__error3018' => 'Nieudane połączenie SSH.',

    'backup__error3110' => 'Nie udało się połączyć ze zdalnym agentem migracji: Połączenie z hostem nie jest dostępne.',
    'backup__error3111' => 'Agent migracji jest zablokownay przez nieudane zadanie migracji lub jest używany przez inny proces migracji. Uruchom ponownie agenta migracji na serwerze źródłowym.',
    'backup__error3112' => 'Połączenie z hostem nie jest dostępne lub agent migracji nie jest uruchomiony na hoście źródłowym.',
    'backup__error3113' => 'Nie udało się wdrożyć agenta migracji na hoście Linux. Sprawdź połączenie SSH na hoście źródłowym.',
    'backup__error3114' => 'Nie udało się wdrożyć agenta migracji na hoście Linux: Nieudane połączenie SSH.',
    'backup__error3115' => 'Niepoprawna nazwa użytkownika lub hasło.',
    'backup__error3116' => 'Podany użytkownik nie ma uprawnień administracyjnych.',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => 'Wszystkie konfiguracje i zawartość',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => 'Wszystkie konfiguracje i zawartość z wyjątkiem poczty e-mail',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => 'Tylko konfiguracja i zawartość poczty',

    'dns_t__unable_to_remove_ns_record' => 'Nie udało się usunąć rekordu NS z szablonu DNS: Każda strefa DNS musi mieć przynajmniej jeden rekord NS..',
    'dns__unsupported_server_zone_transfer' => 'Nie udało się przenieść szablonu ograniczeń transferu z powodu konfiguracji DNS na całym serwerze: Na serwerze źródłowym następujące adresy sieciowe mogą być przenoszone pomiędzy strefami, ale te adresy są niedozwolone przez Microsoft DNS Server: %1',
    'dns__unsupported_domain_zone_transfer' => 'Nie udało się przenieść szablonu ograniczeń transferu z powodu konfiguracji DNS: Na niektórych domenach następujące adresy sieciowe mogą być przenoszone pomiędzy strefami, ale te adresy są niedozwolone przez Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => 'Określ mapowanie serwerów baz danych',
    'dbbackup__check_network_settings_failed' => 'Brak dostępu do współdzielonego tymczasowego katalogu sieciowego dla plików kopii zapasowej. Sprawdź ustawienia katalogu sieciowego, nazwy użytkownika oraz hasła. Błąd: %1',

    'migration_select_exist_db_server' => 'Wybierz docelowy serwer bazy danych',

    'dbbackup__temp_dir_wrong_value' => 'Podano niewłaściwą wartość tymczasowego katalogu.',
    'dbbackup__network_temp_dir_wrong_value' => 'Podano niewłaściwą wartość tymczasowego katalogu sieciowego.',
    'dbbackup__server_backup_not_configured' => 'Ustawienia kopii zapasowej bazy danych nie zostały skonfigurowane na serwerze.',
    'dbbackup__temp_dir' => 'Katalog tymczasowy',
    'dbbackup__temp_dir_hint' => 'Ścieżka do fizycznego folderu na zdalnym serwerze, na którym umieszczony jest serwer MS SQL. Serwer MS SQL musi mieć możliwość dostępu do tego folderu, aby odczytywać i zapisywać tymczasowe pliki kopii zapasowej. Na przykład, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Ścieżka do części sieci zamapowana do fizycznego folderu określonego powyżej. Plesk uzyska dostęp do tego współdzileonego folderu, aby pobierać i wgrywać pliki kopii zapasowej. Na przykład, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Nazwa użytkownika użytkownika sieciowego utworzona na zdalnym serwerze. Na przykład, ServerName\\UserName. Użytkownik musi mieć dostęp do współdzielonego folderu określonego powyżej.',
    'dbbackup__network_password_hint' => 'Hasło użytkownika sieci',

    'dbbackup__success_import_without_dublicate_users' => 'Następujący użytkownicy nie zostali zaimportowani: %1. Już istnieją na serwerze bazy danych.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Skompresuj pliki logów",
    'log_rot__log_rot_status' => "Strona statusu rotacji logów",
    'log_rot__log_rot_period' => "Stan rotacji logów",
    'log_rot__log_rot_size' => "według rozmiaru",
    'log_rot__log_rot_time' => "według czasu",
    'log_rot__logrotation_enable' => "Włącz rotację logów",
    'log_rot__mail' => "Wyślij przetwarzane pliki logów na adres e-mail",
    'log_rot__max_number_of_logfiles' => "Maksymalna liczba plików logów",
    'log_rot__time_period' => "okres",
    'log_rot__unable_turn_off' => 'Nie można wyłączyć rotacji dziennika, ponieważ jest ona wymuszany na poziomie serwera',
    'log_rot__unable_set_period' => 'Nie można ustawić okresu rotacji dziennika różnego od \'daily \', ponieważ jest on wymuszany na poziomie serwera',
    'log_rot__unable_set_max_log_files' => 'Nie można ustawić maksymalnej liczby plików dziennika większej niż limit serwera %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Oczekiwana liczba: %1",
    'actionlog__incorrect_rotation' => "Podano błędne parametry rotacji logów: %1",
    'actionlog__unknown_rot_period' => "Nieznany okres rotacji: %1",
    'actionlog__unknown_rot_type' => "Nieznany typ rotacji: %1",
    'actionlog__session_preferences' => 'Ustawienia sesji',
    // items (PFU schema)
    'actionlog__admin_info' => 'Informacja administratora',
    'actionlog__admin_preferences' => "Preferencje Administratora",
    'actionlog__service' => 'Usługa',
    'actionlog__ip_addr' => 'Adres IP',
    'actionlog__client' => 'Konto klienta',
    'actionlog__client_status' => 'Status konta klienta',
    'actionlog__client_preferences' => "Ustawienia interfejsu klienta",
    'actionlog__client_ip_pool' => "Pula IP klienta",
    'actionlog__client_siteapp' => "Aplikacja klienta",
    'actionlog__client_guid' => "Identyfikator klienta (GUID)",
    'actionlog__domain' => 'Domyślna domena (pierwsza domena dodana do subskrypcji)',
    'actionlog__domain_owner' => 'Właściciel subskrypcji',
    'actionlog__domain_plan' => 'Plan usługi dla subskrypcji',
    'actionlog__domain_status' => 'Domyślna domena, status',
    'actionlog__domain_dns' => 'Domyślna domena, strefa DNS',
    'actionlog__subdomain' => 'Podomena domyślnej domeny',
    'actionlog__domain_alias' => 'Domyślna domena, alias',
    'actionlog__domain_alias_dns' => 'Domyślna domena, alias strefy DNS',
    'actionlog__site' => 'Domena',
    'actionlog__site_status' => 'Status domeny',
    'actionlog__site_dns' => 'Strefa DNS domeny',
    'actionlog__site_guid' => 'Domena GUID',
    'actionlog__site_subdomain' => 'Subdomena',
    'actionlog__site_alias' => 'alias domeny',
    'actionlog__site_alias_dns' => 'Strefa DNS alisu domeny',
    'actionlog__domain_limits' => 'Limity subskrypcji',
    'actionlog__domain_limit_size' => 'Limit przestrzeni dyskowej dla subskrybcji',
    'actionlog__domain_limit_traffic' => 'Limit transferu dla subskrypcji',
    'actionlog__domain_limits_powerUser' => 'Limity subskrypcji',
    'actionlog__domain_limit_size_powerUser' => 'Limit przestrzeni dyskowej dla subskrybcji',
    'actionlog__domain_limit_traffic_powerUser' => 'Limit transferu dla subskrypcji',
    'actionlog__domain_guid' => "Domyślna domena, GUID",
    'actionlog__cp_user' => 'Użytkownik Plesk',
    'actionlog__mailname' => 'Konto pocztowe',
    'actionlog__maillist' => 'Lista mailingowa',
    'actionlog__phosting' => 'Ustawienia hostingu',
    'actionlog__forwarding' => 'Przekierowanie ramką lub standardowe',
    'actionlog__webuser' => 'Użytkownik Web',
    'actionlog__site_application' => 'Aplikacja WWW',
    'actionlog__license' => 'Klucz licencji',
    'actionlog__additional_license' => 'Dodatkowy klucz licencji',
    'actionlog__template_domain' => "Plan usługi sprzedawcy",
    'actionlog__template_admin' => "Plan usługi administratora",
    'actionlog__template_reseller' => 'Plan sprzedawcy',
    'actionlog__admin_alias' => 'Dodatkowe konto administratora', // PFW
    'actionlog__ftpuser' => 'Dodatkowe konto FTP', // PFW
    'actionlog__db_server' => 'Serwer bazy danych',
    'actionlog__db' => 'Baza danych',
    'actionlog__db_user' => 'Konto użytkownika bazy danych',
    'actionlog__client_sapppkg_pool' => "Pula aplikacji klienta", // PFW, not used?
    'actionlog__remote_dns' => 'Status zdalnego serwera DNS', // PFW
    'actionlog__reseller' => 'Konto sprzedawcy',
    'actionlog__reseller_guid' => 'Identyfikator sprzedawcy (GUID)',
    'actionlog__reseller_ip_pool' => "Pula adresów IP sprzedawcy",
    'actionlog__reseller_limit_size' => 'Przestrzeń dyskowa konta sprzedawcy',
    'actionlog__reseller_limit_traffic' => 'Limit transferu konta sprzedawcy',
    'actionlog__reseller_limits' => 'Ograniczenia konta sprzedawcy',
    'actionlog__reseller_permissions' => 'Uprawnienia sprzedawcy',
    'actionlog__reseller_preferences' => "Ustawienia interfejsu sprzedawcy",
    'actionlog__reseller_siteapp' => "Aplikacje WWW w puli sprzedawcy",
    'actionlog__reseller_status' => 'Status konta sprzedawcy',
    'actionlog__health_status' => 'Status serwera',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'osiągnięty',
    'actionlog__added' => 'dodany',
    'actionlog__removed' => 'usunięty',
    'actionlog__change' => 'zmienione',
    'actionlog__update' => 'zaktualizowany',
    'actionlog__move' => 'przeniesiony',
    'actionlog__upgrade' => 'ulepszony', // PFU?
    'actionlog__update_or_add' => 'zaktualizowany lub dodany',
    'actionlog__expired' => 'wygasł',
    'actionlog__create' => 'utworzony',
    'actionlog__delete' => 'usunięty',
    'actionlog__service_stop' => 'zatrzymana',
    'actionlog__service_restart' => 'zrestartowana',
    'actionlog__service_start' => 'uruchomiona',
    'actionlog__login' => 'zalogowany',
    'actionlog__logout' => 'wylogowany',
    'actionlog__install' => 'zainstalowany',
    'actionlog__uninstall' => 'odinstalowany',
    'actionlog__reconfigure' => 'zrekonfigurowany',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Prośba o zresetowanie hasła',
    'actionlog__event_admin_update' => 'Zaktualizowano dodatkowe administratora',
    'actionlog__event_admin_preferences_update' => "Zaktualizowano preferencje administratora",
    'actionlog__event_service_restart' => 'Zrestartowano usługę',
    'actionlog__event_service_start' => 'Uruchomiono usługę',
    'actionlog__event_service_stop' => 'Zatrzymano usługę',
    'actionlog__event_ip_address_create' => 'Utworzono adres IP',
    'actionlog__event_ip_address_delete' => 'Usunięto adres IP',
    'actionlog__event_ip_address_update' => 'Zaktualizowano adres IP',
    'actionlog__event_client_create' => 'Stworzono konto klienta',
    'actionlog__event_client_delete' => 'Usunięto konto klienta',
    'actionlog__event_client_update' => 'Zaktualizowano konto klienta',
    'actionlog__event_client_status_update' => 'Zaktualizowano status konta klienta',
    'actionlog__event_client_preferences_update' => "Zaktualizowano ustawienia interfejsu klienta",
    'actionlog__event_client_siteapp_added' => "Dodano aplikację WWW do puli aplikacji klienta",
    'actionlog__event_client_siteapp_removed' => "Usunięto aplikację WWW z puli aplikacji klienta",
    'actionlog__event_domain_limit_size_reached' => 'Osiągnięto limit przestrzeni dyskowej dla subskrypcji',
    'actionlog__event_domain_limit_traffic_reached' => 'Osiągnięto limit transferu dla subskrypcji',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Osiągnięto limit przestrzeni dyskowej dla subskrypcji',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Osiągnięto limit transferu dla subskrypcji',

    'actionlog__domain_limit_database' => 'Limit dyskowy bazy danych dla subskrypcji',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Osiągnięto limit baz danych MySQL dla subskrypcji',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Osiągnięto miękki limit baz danych MySQL dla subskrypcji',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Osiągnięto limit dla bazy danych serwera Microsoft SQL dla subskrypcji',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Osiągnięto miękki limit dla bazy danych serwera Microsoft SQL dla subskrypcji',
    'actionlog__event_plesk_component_upgrade' => 'Zaktualizowano komponent pakietu Plesk',
    'actionlog__event_plesk_component_install' => 'Zainstalowano komponent pakietu Plesk',
    'actionlog__event_plesk_component_uninstall' => 'Usunięto komponent pakietu Plesk',
    'actionlog__event_domain_create' => 'Domyślna domena (pierwsza domena dodana do subskrypcji) została utworzona',
    'actionlog__event_domain_delete' => 'Domyślna domena (pierwsza domena dodana do subskrypcji) została usunięta',
    'actionlog__event_domain_update' => 'Domyślna domena (pierwsza domena dodana do subskrypcji) została zaktualizowana',
    'actionlog__event_domain_owner_change' => 'Zmieniono właściciela subskrypcji',
    'actionlog__event_domain_plan_change' => 'Zmieniony plan usługi dla subskrypcji',
    'actionlog__event_domain_status_update' => 'Domyślna domena, status zaktualizowany',
    'actionlog__event_domain_dns_update' => 'Domyślna domena, strefa DNS zaktualizowana',
    'actionlog__event_subdomain_create' => 'Poddomena domeny domyślnej została utworzona',
    'actionlog__event_subdomain_delete' => 'Poddomena domeny domyślnej została usunięta',
    'actionlog__event_subdomain_update' => 'Poddomena domeny domyślnej została zaktualizowana',
    'actionlog__event_domain_alias_create' => 'Domyślna domena, utworzono alias',
    'actionlog__event_domain_alias_delete' => 'Domyślna domena, usunięto alias',
    'actionlog__event_domain_alias_update' => 'Domyślna domena, zaktualizowano alias',
    'actionlog__event_domain_limits_update' => 'Zaktualizowano limity subskrypcji',
    'actionlog__event_cp_user_login' => 'Zalogowano użytkownika Plesk',
    'actionlog__event_cp_user_logout' => 'Wylogowano użytkownika Plesk',
    'actionlog__event_mailname_create' => 'Utworzono konto e-mailowe',
    'actionlog__event_mailname_delete' => 'Usunięto konto e-mailowe',
    'actionlog__event_mailname_update' => 'Zaktualizowano konto e-mailowe',
    'actionlog__event_maillist_create' => 'Utworzono listę mailingową',
    'actionlog__event_maillist_delete' => 'Usunięto listę mailingową',
    'actionlog__event_maillist_update' => 'Zaktualizowano listę mailingową',
    'actionlog__event_phys_hosting_create' => 'Utworzono hosting fizyczny',
    'actionlog__event_phys_hosting_delete' => 'Usunięto hosting fizyczny',
    'actionlog__event_phys_hosting_update' => 'Zaktualizowano hosting fizyczny',
    'actionlog__event_forwarding_create' => 'Standardowy lub przekazujący ramkę hosting został utworzony',
    'actionlog__event_forwarding_delete' => 'Standardowy lub przekazujący ramkę hosting został usunięty',
    'actionlog__event_forwarding_update' => 'Standardowy lub przekazujący ramkę hosting został zaktualizowany',
    'actionlog__event_webuser_create' => 'Utworzono konto użytkownika',
    'actionlog__event_webuser_delete' => 'Usunięto konto użytkownika',
    'actionlog__event_webuser_update' => 'Zaktualizowano konto użytkownika',
    'actionlog__event_siteapp_install' => 'Zainstalowano aplikację WWW',
    'actionlog__event_siteapp_reconfigure' => 'Zrekonfigurowano aplikację WWW',
    'actionlog__event_siteapp_uninstall' => 'Odinstalowano aplikację WWW',
    'actionlog__event_license_update' => 'Klucz licencyjny został zaktualizowany',
    'actionlog__event_admin_alias_create' => 'Stworzono dodatkowe konto administratora',
    'actionlog__event_admin_alias_delete' => 'Usunięto dodatkowe konto administratora',
    'actionlog__event_admin_alias_update' => 'Zaktualizowano dodatkowe konto administratora',
    'actionlog__event_ftpuser_create' => 'Utworzono dodatkowe konto FTP',
    'actionlog__event_ftpuser_update' => 'Zaktualizowano dodatkowe konto FTP',
    'actionlog__event_ftpuser_delete' => 'Usunięto dodatkowe konto FTP',
    'actionlog__event_template_domain_create' => "Utworzono plan usługi sprzedawcy",
    'actionlog__event_template_domain_update' => "Zaktualizowano plan usługi sprzedawcy",
    'actionlog__event_template_domain_delete' => "Usunięto plan usługi sprzedawcy",
    'actionlog__event_template_admin_create' => "Utworzono plan usługi administratora",
    'actionlog__event_template_admin_update' => "Zaktualizowano plan usługi administratora",
    'actionlog__event_template_admin_delete' => "Usunięto plan usługi administratora",
    'actionlog__event_database_server_create' => 'Utworzono serwer baz danych',
    'actionlog__event_database_server_update' => 'Serwer baz danych został zaktualizowany',
    'actionlog__event_database_server_delete' => 'Usunięto serwer baz danych',
    'actionlog__event_remote_dns_status_update' => 'Zaktualizowano status zdalnego serwera DNS',
    'actionlog__event_session_preferences_update' => 'Zaktualizowano ustawienia sesji',
    'actionlog__event_domain_alias_dns_update' => 'Domyślna domena, strefa DNS aliasu domeny zaktualizowana',
    'actionlog__event_domain_move' => 'Domena domyślna została przeniesiona do nowej subskrypcji',
    'actionlog__event_site_move' => 'Domena została przeniesiona do nowej subskrypcji',
    'actionlog__event_site_subdomain_move' => 'Subdomena została przeniesiona do nowej subskrypcji',
    'actionlog__event_subdomain_move' => 'Subdomena domeny domyślnej została przeniesiona do nowej subskrypcji',
    'actionlog__event_license_expired' => 'Licencja na korzystanie z Plesk wygasła',
    'actionlog__event_database_create' => 'Stworzono bazę danych',
    'actionlog__event_database_delete' => 'Usunięto bazę danych',
    'actionlog__event_database_user_create' => 'Utworzono konto użytkownika bazy danych',
    'actionlog__event_database_user_update' => 'Ustawienia konta użytkownika bazy danych zostały zaktualizowane',
    'actionlog__event_database_user_delete' => 'Usunięto konto użytkownika bazy danych',
    'actionlog__event_client_guid_update' => "Zaktualizowano identyfikator klienta (GUID)",
    'actionlog__event_domain_guid_update' => 'Domyślna domena, GUID zaktualizowane',
    'actionlog__event_reseller_create' => 'Utworzono konto sprzedawcy',
    'actionlog__event_reseller_delete' => 'Usunięto konto sprzedawcy',
    'actionlog__event_reseller_update' => 'Zaktualizowano konto sprzedawcy',
    'actionlog__event_reseller_guid_update' => 'Zaktualizowano identyfikator sprzedawcy (GUID)',
    'actionlog__event_reseller_ip_pool_update' => "Zaktualizowano pulę adresów IP sprzedawcy",
    'actionlog__event_reseller_limit_size_reached' => 'Osiągnięto limit przestrzeni dyskowej konta sprzedawcy',
    'actionlog__event_reseller_limit_traffic_reached' => 'Osiągnięto limit transferu konta sprzedawcy',
    'actionlog__event_reseller_limits_update' => 'Zaktualizowano limity konta sprzedawcy',
    'actionlog__event_reseller_permissions_update' => 'Zaktualizowano pozwolenia konta sprzedawcy',
    'actionlog__event_reseller_preferences_update' => "Zaktualizowano ustawienia interfejsu sprzedawcy",
    'actionlog__event_reseller_siteapp_added' => "Dodano aplikację do puli aplikacji sprzedawcy",
    'actionlog__event_reseller_siteapp_removed' => "Usunięto aplikację z puli aplikacji sprzedawcy",
    'actionlog__event_reseller_status_update' => 'Zaktualizowano status konta sprzedawcy',
    'actionlog__event_template_reseller_create' => 'Utworzono plan sprzedawcy',
    'actionlog__event_template_reseller_delete' => 'Usunięto plan sprzedawcy',
    'actionlog__event_template_reseller_update' => 'Zaktualizowano plan sprzedawcy',
    'actionlog__event_health_status_change' => 'Zmieniono status serwera',
    'actionlog__event_siteapp_upgrade' => 'Podniesiono parametry aplikacji',
    'actionlog__event_extension_install' => 'Rozszerzenie zainstalowane',
    'actionlog__event_extension_uninstall' => 'Rozszerzenie odinstalowane',
    'actionlog__event_extension_upgrade' => 'Podniesienie parametrów rozszerzenia',
    'actionlog__event_extension_status_update' => 'Zaktualizowano status rozszerzenia',
    'actionlog__event_additional_license_expired' => 'Dodatkowa licencja wygasła',
    'actionlog__event_hostname_changed' => 'Zmieniono nazwę hosta serwera',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "API Plesk RPC nie jest zainstalowane na zdalnym hoście. Skontaktuj się z dostawcą usług.",
    'rsession_no_account_errmsg' => "Nie udało się uzyskać dostępu do usługi w twoim koncie. Przeważnie przyczyną jest to, że usługa nie jest jeszcze aktywna. Proszę, poczekaj kilkanaście minut i spróbuj ponownie. Jeżeli ten problem wystąpi ponownie skontaktuj się z Twoim administratorem.",
    'rsession_no_domain_errmsg' => "Nie udało się uzyskać dostępu do zdalnej usługi dla tej domeny. Najczęstszą przyczyną jest to, że usługa nie jest jeszcze aktywna. Proszę, poczekaj kilkanaście minut i spróbuj ponownie. Jeżeli ten problem wystąpi ponownie skontaktuj się z Twoim administratorem.",
    'rsession_unknown_errmsg' => "Zdalny host odmówił próby nawiązania sesji. Skontaktuj się z administratorem systemu po pomoc. Wystąpił błąd: %1",
    'rsession_unknown2_errmsg' => "Nieznany błąd podczas tworzenia zdalnej sesji. Najprawdopodobniej zdalny serwer nie odpowiada poprawnie lub nie odpowiada w ogóle. Poproś twojego administratora aby sprawdził szczegóły błędu w pliku logu Apache.",
    'rsession_no_connect_errmsg' => "Nie udało się uzyskać dostępu do zdalnej usługi: połączenie do zdalnej sesji nie powiodło się. Skontaktuj się z administratorem systemu po pomoc.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Pozwól na wgrywanie do katalogu przychodzącego",
    'anonftp__allow_create_dirs' => 'Pozwól na tworzenie podkatalogów w katalogu przychodzącym',
    'anonftp__allow_download_incoming' => 'Pozwól na pobieranie z katalogu przychodzącego',
    'anonftp__display_login' => 'Wyświetl wiadomość logowania',
    'anonftp__login_text' => 'Tekst wiadomości',
    'anonftp__limit_incoming_disk_space' => "Ogranicz przestrzeń dysku w katalogu przychodzącym",
    'anonftp__limit_maximum_bandwidth' => "Ogranicz limit pobierania dla tej wirtualnej domeny FTP",
    'anonftp__limit_maximum_connections' => "Ogranicz liczbę równoczesnych połączeń",
    'anonftp__unable_init' => "Nie można zainicjować anonimowego konta FTP: %1",
    'anonftp__unable_set_quota' => "Nie można ustawić limitu dysku dla katalogu przychodzącego: %1",
    'anonftp__unable_update' => "Nie można zaktualizować właściwości konta anonimowego FTP: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Ceryfikaty SSl/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Certyfikat CA nie podpisuje certyfikatu.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Niekompatybilna para prywatny klucz/certyfikat.",
    'class_sslcertificate__invalid_cert_format' => "Nieprawidłowy format certyfikatu.",
    'class_sslcertificate__invalid_private_key_format' => "Nieprawidłowy format prywatnego klucza.",
    'class_sslcertificate__prob_invalid_priv_key' => "Prawdopodobnie format prywatnego klucza jest nieprawidłowy.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Utwórz wirtualny katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Utwórz wirtualny katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Utwórz wirtualny katalog.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Utwórz wirtualny katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Utwórz wirtualny katalog',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Utwórz wirtualny katalog.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Utwórz katalog',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Utwórz katalog',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Utwórz katalog.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Utwórz katalog',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Utwórz katalog',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Utwórz katalog.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Właściwości katalogu',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Właściwości wirtualnego katalogu',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Zobacz i zmień właściwości wirtualnego katalogu.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Właściwości katalogu',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Właściwości wirtualnego katalogu',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Zobacz i zmień właściwości wirtualnego katalogu.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Uprawnienia dostępu do katalogu',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Uprawnienia dostępu do katalogu',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Ustaw uprawnienia dostępu do katalogu.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Uprawnienia dostępu do katalogu',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Uprawnienia dostępu do katalogu',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Ustaw uprawnienia dostępu do katalogu.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Ustawienia ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Ustawienia ASP.NET dla %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Skonfiguruj ustawienia ASP.NET dla wirtualnego katalogu %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Ustawienia ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Ustawienia ASP.NET dla %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Skonfiguruj ustawienia ASP.NET dla wirtualnego katalogu %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => 'Zmień wersję',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => 'Zmień wersję',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => 'Zmień wersję ASP.NET używaną przez wirtualny katalog %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => 'Zmień wersję',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => 'Zmień wersję',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => 'Zmień wersję ASP.NET używaną przez wirtualny katalog %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Ustawienia PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Ustawienia PHP dla %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Skonfiguruj ustawienia PHP dla wirtualnego katalogu %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Ustawienia PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Ustawienia PHP dla %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Skonfiguruj ustawienia PHP dla wirtualnego katalogu %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Usuń',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Usuń wirtualne katalogi',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Potwierdzenie usunięcia katalogów www.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Usuń',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Usuń wirtualne katalogi',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Potwierdzenie usunięcia katalogów www.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Katalogi web zostaną:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Musisz wybrać katalogi, które chcesz usunąć.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Wyświetl listę zarejestrowanych typów MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Dodaj typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Dodaj typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Zarejestruj nowy typ MIME.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Dokumenty błędów',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Dokumenty błędów',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Zobacz i zmień dokumenty błędów.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Ochrona',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Zabezpieczenia katalogu',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Ogranicz dostęp do katalogu za pomocą hasła.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Ochrona',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Zabezpieczenia katalogu',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Ogranicz dostęp do katalogu za pomocą hasła.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Ustawienia',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Zobacz lokalizację katalogu i podaj tytuł chronionego obszaru.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Dodaj użytkownika',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Dodaj konto użytkownika, aby umożliwić dostęp do chronionego katalogu.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Nowe ustawienia zostały zastosowane.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Konto użytkownika zostało dodane.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Usuń',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Usuń użytkowników chronionego katalogu.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Usuń konta użytkowników',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Potwierdź usunięcie kont użytkowników.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Konta użytkowników zostały usunięte.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => 'Proces kontroli uprawnień został uruchomiony. Po zakończeniu procesu sprawdzania zostanie wysłane powiadomienie na następujący adres e-mail: %1', // PFW
    'additional_keys__install_done' => 'Rozpoczęto instalację klucza licencyjnego.',

    // UI
    'ui____done' => 'Operacja zakończona powodzeniem.',
    'ui__admin/extras-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__admin/interface__done' => 'Zmiany w ustawieniach interfejsu administratora serwera zostały zapisane.',
    'ui__admin/report/layout/delete_multi__done' => 'Wybrane layouty raportu zostały usunięte.',
    'ui__admin/report/traffic-history__done' => 'Operacja zakończona powodzeniem.',
    'ui__admin/report__done' => 'Operacja zakończona powodzeniem.',
    'ui__admin-alias/delete_multi__done' => "Wybrane dodatkowe konto administratora zostało usunięte.",
    'ui__admin-alias/properties__done' => "Właściwości dodatkowego konta administratora zostały zaktualizowane.",
    'ui__admin-alias/properties_new__done' => "Dodatkowe konto administratora zostało utworzone.",
    'ui__admin-alias/properties_unknown__done' => "Właściwości dodatkowego konta administratora zostały zaktualizowane.",
    'ui__admin-alias__done' => "Informacje o dodatkowym koncie administratora zostały zaktualizowane.",
    'ui__admin/manage-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__admin/register-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Wybrany Raport Harmonogramu Dostawy został usunięty.',
    'ui__admin/report/layout/auto/properties__done' => 'Raport Harmonogramu Dostawy został zaktualizowany.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Utworzony nowy plan dostawy raportu.',
    'ui__admin/report/layout/properties__done' => 'Układ raportu %1 został usunięty.',
    'ui__admin/report/layout/properties_new__done' => 'Układ raportu %1 został usunięty.',
    'ui__client/chowner__done' => 'Przypisano nowego właściciela konta %1 klienta.',
    'ui__client/chowner_multi__done' => "Wybrane konta użytkownika zostały przeniesione do innego właściciela.",
    'ui__client/chowner_multi-select__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/chowner_select__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/certificate/properties__done' => 'Właściwości certyfikatu SSL/TSL zostały zaktualizowane.',
    'ui__client/domain/certificate/properties_new__done' => 'Dodano nowy certyfikat SSL/TLS. Aby zadziałał, należy wybrać go w globalnych ustawieniach hostingu sieciowego (na stronie "Strony i domeny").',
    'ui__client/domain/certificate__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/certificate_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/check-permissions_multi__done' => 'Sprawdzanie uprawnień dla wybranych domen zostało zakończone.', // PFW
    'ui__client/domain/chowner__done' => 'Subskrypcja %1 należy teraz do innego użytkownika.',
    'ui__client/domain/chowner_multi__done' => 'Zmieniono właściciela domeny.',
    'ui__client/domain/chowner_multi-select__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/chowner_select__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/dbbackup/create__done' => "Pomyślnie utworzono kopię zapasową bazy danych.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Pomyślnie utworzono kopię zapasową bazy danych.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Użytkownik.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Pliki kopii zapasowych zostały pomyślnie usunięte.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Zawartość bazy danych została pomyślnie przywrócona.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operacja zakończona powodzeniem.", // PFW
    'ui__client/domain/dbbackup__done' => "Operacja zakończona powodzeniem.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operacja zakończona powodzeniem.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operacja zakończona powodzeniem.", // PFW
    'ui__client/domain/delete__done' => "Domena %1 została usunięta.",
    'ui__client/domain/delete_multi__done' => "Domeny zostały usunięte.",
    'ui__client/domain/disable__done' => 'Domena %1 została zawieszona.',
    'ui__client/domain/disable_multi__done' => 'Wybrane domeny zostały zawieszone.',
    'ui__client/domain/enable__done' => 'Strona internetowa %1 została aktywowana.',
    'ui__client/domain/enable_multi__done' => 'Wybrane strony internetowe zostały aktywowane.',
    'ui__client/domain/extras__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/domain/extras_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/domain/hosting/file-manager/copy-move__done' => 'Wybrane pliki lub foldery zostały skopiowane lub usunięte.',
    'ui__client/domain/hosting/file-manager/create-dir__done' => 'Katalog został utworzony.',
    'ui__client/domain/hosting/file-manager/create-file__done' => 'Plik został utworzony.',
    'ui__client/domain/hosting/file-manager/edit__done' => 'Plik został zaktualizowany.',
    'ui__client/domain/hosting/file-manager/permissions__done' => 'Prawa dostępu do pliku lub katalogu zostały uaktualnione.', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => 'Nazwa katalogu lub pliku została zmieniona.',
    'ui__client/domain/hosting/file-manager/remove__done' => 'Wybrane pliki i katalogi zostały usunięte.',
    'ui__client/domain/hosting/file-manager/remove_self__done' => 'Wybrane pliki i katalogi zostały usunięte.',
    'ui__client/domain/hosting/file-manager/view__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/file-manager__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/file-manager_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/hotlink-protection__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => 'Ustawienia rotacji logów zostały zmienione.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Ustawienia rotacji logów zostały zmienione.',
    'ui__client/domain/hosting/logs__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/logs_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/performance__done' => 'Ustawienia wydajności hostingu dla strony internetowej %1 zostały dostosowane.',
    'ui__client/domain/hosting/performance_self__done' => 'Ustawienia wydajności hostingu dla twojej strony internetowej zostały dostosowane.',
    'ui__client/domain/hosting/performance_unknown__done' => 'Ustawienia wydajności hostingu sieciowego zostały dostosowane.',
    'ui__client/domain/hosting/php__done' => 'Ustawienia PHP zostały zmienione.', // PFW
    'ui__client/domain/hosting/php_self__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/protected-directories__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/protected-directories_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/hosting/setup__done' => 'Hosting dla %1 został skonfigurowany.',
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operacja zakończona powodzeniem.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operacja zakończona powodzeniem.', // PFU
    'ui__client/domain/hosting/virtual-directories__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Wersja ASP.NET została zmieniona.', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Ustawienia ASP.NET dla %1 zostały zmienione.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Wirtualny katalog został utworzony na stronie %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Wirtualny katalog został utworzony.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Wybrane katalogi zostały usunięte.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Wybrane katalogi zostały usunięte.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Dokumenty błędów niestandardowych zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Wybrane typy MIME zostały usunięte', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Nowy typ MIME został zarejestrowany.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Uprawnienia dostępu do katalogu zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Uprawnienia dostępu do katalogu zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Ustawienia PHP dla %1 zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Ustawienia PHP dla %1 zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Właściwości katalogu zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Właściwości katalogu zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Ustawienia ochrony katalogu zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Ustawienia ochrony katalogu zostały zaktualizowane.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Operacja zakończona powodzeniem.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Certyfikaty SSL/TLS są dostępne w sklepie online',
    'ui__client/domain/mpc-certificates_self__done' => 'Certyfikaty SSL/TLS są dostępne w sklepie online',
    'ui__client/domain/odbc__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/odbc_self__done' => 'Operacja zakończona powodzeniem.', // PFW
    'ui__client/domain/properties__done' => "Konto administratora/ów domeny zostało zmienione.",
    'ui__client/domain/properties_new__done' => "Domena %1 została stworzona.",
    'ui__client/domain/properties_self__done' => "Właściwości Twojej domeny zostały zmienione.",
    'ui__client/domain/register__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/domain/register_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/domain/rename__done' => 'Nazwa domeny została zmieniona.',
    'ui__client/domain/rename_self__done' => "Nazwa domeny została pomyślnie zmieniona.",
    'ui__client/domain/report/anon-ftp-stats__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/report/ftp-stats__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/report/ftp-stats_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/report/traffic-history__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/report/traffic-history_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/report/webalizer-preferences__done' => 'Operacja zakończona powodzeniem.', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => 'Operacja zakończona powodzeniem.', // PFU
    'ui__client/domain/report/web-stats__done' => 'Strona ze statystykami sieci została otwarta.',
    'ui__client/domain/report/web-stats_self__done' => 'Strona ze statystykami sieci została otwarta.',
    'ui__client/domain/report/web-stats-ssl__done' => 'Strona ze statystykami sieci została otwarta.',
    'ui__client/domain/report/web-stats-ssl_self__done' => 'Strona ze statystykami sieci została otwarta.',
    'ui__client/domain/report__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/report_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/settings_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/to-client__done' => 'Konto %1 administratora domeny zostało skonwertowane do konta klienta.',
    'ui__client/domain/to-client_multi__done' => 'Konta administratora domeny zostały skonwertowane do kont klienta.',
    'ui__client/domain/toggle_disable__done' => "Domena %1 została zawieszona.",
    'ui__client/domain/toggle_enable__done' => "Domena %1 została odwieszona.",
    'ui__client/domain/traffic__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/traffic_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/traffic_unknown__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain/web-stats__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain-summary-report__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain-summary-report_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/domain-summary-report_unknown__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/extras-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/extras-domain_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/ipaddress/delete_multi__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/ipaddress/properties__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/ipaddress/properties_new__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/ip-pool/properties__done' => "Pula IP dla klienta %1 została zaktualizowana.",
    'ui__client/ip-pool/properties_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/limits__done' => "Limity klienta %1 zostały zaktualizowane.",
    'ui__client/limits_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/logo__done' => 'Właściwości loga panelu administracyjnego klienta %1 zostały zmienione.',
    'ui__client/logo_reseller__done' => 'Ustawienia nowego brandowania panelu zostały zastosowane.',
    'ui__client/logo_self__done' => 'Ustawienia brandingu zostały zastosowane.',
    'ui__client/logo_self-reseller__done' => 'Zastosowano ustawienia brandingu panelu.',
    'ui__client/manage-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/manage-domain_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/permissions__done' => "Uprawnienia klienta %1 zostały zmienione.",
    'ui__client/permissions_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/preferences__done' => "Ustawienia dla klienta %1 zostały zmienione.",
    'ui__client/preferences_self__done' => "Twoje ustawienia zostały zaktualizowane.",
    'ui__client/register-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/register-domain_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__client/report/traffic-history__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/report/traffic-history_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/report__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/report_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/sessions/delete__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/sessions/delete_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/sessions__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/sessions_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/skeleton__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/skeleton_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__client/to-reseller__done' => 'Konto klienta %1 zostało skonwertowane do konta sprzedawcy.',
    'ui__client/to-reseller_multi__done' => "Wybrane konta klienta zostały skonwertowane do kont sprzedawcy.Konwertuj do sprzedawcó\"_x000D_.",
    'ui__client/traffic__done' => "Operacja zakończona powodzeniem.",
    'ui__client/traffic_unknown__done' => 'Operacja zakończona powodzeniem.',
    'ui__cp-access__done' => 'Operacja zakończona powodzeniem.',
    'ui__cp-session/properties__done' => 'Operacja zakończona powodzeniem.',
    'ui__cp-session__done' => 'Operacja zakończona powodzeniem.',
    'ui__ftp-sessions__done' => 'Operacja zakończona powodzeniem.',
    'ui__license__done' => 'Operacja zakończona powodzeniem.',
    'ui__logo__done' => "Zmieniono własności personalizacji Plesk.",
    'ui__longtasks/longtask/properties__done' => "Ustawienia zadania tła zostały pomyślnie zmienione.",
    'ui__mass-email/delete__done' => "Szablon wiadomości %1 został usunięty.", // PFW
    'ui__mass-email/delete_multi__done' => "Szablony wiadomości zostały usunięte.",  // PFW
    'ui__mass-email/send_main__done' => "Operacja zakończona powodzeniem.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Pomyślnie wybrano konta klienta.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Pomyślnie wybrano konta administratora domeny.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Pomyślnie wybrano konta sprzedawcy.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Zmiany w szablonie masowej wiadomości e-mail zostały zapisane.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Szablon masowej wiadomości e-mail został utworzony.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Wybrano konta klienta dla szablonu masowej wiadomości e-mail.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Wybrano konta administratora dla szablonu masowej wiadomości e-mail.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Wybrano konta sprzedawcy dla szablonu masowej wiadomości e-mail.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Szablon masowej wiadomości e-mail został zmieniony.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Podane zostały niepoprawne wartości.', // PFW
    'ui__mass-email__done' => "Operacja zakończona powodzeniem.", // PFW
    'ui__mass-mail__done' => "Operacja zakończona powodzeniem.", // PFU
    'ui__mass-mail/delete__done' => 'Szablon wiadomości %1 został usunięty.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Szablony wiadomości zostały usunięte.', // PFU
    'ui__mass-mail/properties__done' => 'Szablon %1 został zmieniony.', // PFU
    'ui__mass-mail/properties_new__done' => 'Szablon %1 został stworzony.', // PFU
    'ui__mass-mail/send__done' => 'Wiadomości zostały wysłane.', // PFU
    'ui__mass-mail/send_new__done' => 'Wiadomości zostały wysłane.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Wiadomości zostały wysłane.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Wiadomości zostały wysłane.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Utworzono nowy szablon wiadomości.', // PFU
    'ui__mass-mail/template/properties__done' => 'Szablon wiadomości został zmieniony.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Nowe ustawienia monitorowania dysku zostały zastosowane.', // PFU
    'ui__modules__done' => 'Operacja zakończona powodzeniem.',
    'ui__modules__short-title' => 'Rozszerzenia',
    'ui__modules__title' => 'Rozszerzenia',
    'ui__reseller/client/chowner_multi__done' => 'Wybrane konta klienta zostały przeniesione do innego właściciela.',
    'ui__reseller/client/chowner_multi-select__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/client/traffic_unknown__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/extras-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__reseller/extras-domain_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__reseller/ftp-sessions_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/limits__done' => "Polityki limitów zasobów i zużycia zasobów sprzedawcy\\ów zostały zmienione.",
    'ui__reseller/limits_readonly-self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/limits_self__done' => 'Twoje polityki limitów zasobów i zużycia zasobów zostały zmienione.',
    'ui__reseller/manage-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__reseller/manage-domain_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__reseller/permissions__done' => 'Uprawnienia sprzedawcy %1 zostały zmienione.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/register-domain__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__reseller/register-domain_self__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Wybrany Raport Harmonogramu Dostawy został usunięty.',
    'ui__reseller/report/layout/auto/properties__done' => 'Raport Harmonogramu Dostawy został zaktualizowany.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Raport Harmonogramu Dostawy został dodany.',
    'ui__reseller/report/layout/properties__done' => 'Layouty raportów zostały zmienione.',
    'ui__reseller/report/layout/properties_new__done' => 'Nowy layout raportu został stworzony.',
    'ui__reseller/report/traffic-history__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/report/traffic-history_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/report__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/report_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/sessions/delete__done' => 'Operacja zakończona powodzeniem',
    'ui__reseller/sessions/delete_self__done' => 'Operacja zakończona powodzeniem',
    'ui__reseller/sessions__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/sessions_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/to-client__done' => 'Konto sprzedawcy %1 zostało przekonwertowane do konta klienta.',
    'ui__reseller/to-client_multi__done' => "Wybrane konta sprzedawcy zostały przekonwertowane do kont klienta.",
    'ui__reseller/traffic__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/traffic_self__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/traffic_unknown__done' => 'Operacja zakończona powodzeniem.',
    'ui__reseller/logo_self__title' => 'Branding Plesk',
    'ui__reseller/logo_self__done' => 'Zastosowano ustawienia brandingu Plesk.',
    'ui__server/aspdotnet__done' => 'Ustawienia ASP.NET na całym serwerze zostały zmienione.', // PFW
    'ui__server/certificate/default_multi__done' => 'Wybrany certyfikat SSL/TLS został ustawiony do używania do zabezpieczenia połączeń w nowohostowanymi serwisami WWW.',
    'ui__server/certificate/delete_multi__done' => 'Wybrane certyfikaty SSL/TLS zostały usunięte.',
    'ui__server/certificate/download__done' => 'Certyfikat SSL/TLS został pobrany.',
    'ui__server/certificate/properties__done' => 'Właściwości certyfikatu SSL/TSL zostały zaktualizowane.',
    'ui__server/certificate/properties_new__done' => 'Certyfikat SSL/TLS %1 został utworzony.',
    'ui__server/certificate/setup_multi__done' => 'Wybrany certyfikat SSL/TLS został ustawiony do używania do zabezpieczenia połączeń z Pleskiem.',
    'ui__server/certificate__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/components__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/cp-certificate-download__done' => "Pobrano certyfikat SSL/TLS Pleska.",
    'ui__server/crontab/properties__done' => 'Zaplanowane zadania %1 zostały zmienione.',
    'ui__server/crontab/task/delete__done' => 'Zadanie zostało usunięte.',
    'ui__server/crontab/task/delete_multi__done' => 'Zadania zostały usunięte.',
    'ui__server/crontab/task/properties__done' => 'Zaplanowane zadania zostały zaktualizowane.',
    'ui__server/crontab/task/properties_new__done' => 'Nowe zadanie zostało zaplanowane.',
    'ui__server/crontab/task/toggle_disable__done' => 'Zaplanowane zadanie %1 zostało wyłączone.',
    'ui__server/crontab/task/toggle_enable__done' => 'Zaplanowane zadanie %1 zostało włączone.',
    'ui__server/crontab__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/dns__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/ftp-settings__done' => "Ustawienia FTP zostały pomyślnie zmienione.",
    'ui__server/ip-address/client/delete__done' => "Adres IP został usunięty z puli IP użytkownika.",
    'ui__server/ip-address/client/delete_multi__done' => "Adres IP został usunięty z puli IP użytkownika.",
    'ui__server/ip-address/client/properties_new__done' => 'Adres IP został przypisany do użytkowników.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'Adres IP %1 został przypisany do wybranych klientów.',
    'ui__server/ip-addresses__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/spam/summary__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/spam__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/virus/summary__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics/virus__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail/statistics__done' => "Operacja zakończona powodzeniem.",
    'ui__server/mail__done' => 'Ustawienia serwera pocztowego zostały zmienione.',
    'ui__server/maillists__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/mpc-certificates__done' => 'Otworzono dostępne certyfikaty SSL/TLS na stronie sklepu online.',
    'ui__server/odbc__done' => 'Ustawienia ODBC dotyczące całego serwera zostały zmienione.', // PFW
    'ui__server/pmm__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/preferences__done' => "Ustawienia serwera zostały zmienione.",
    'ui__server/register__done' => 'Strona MyPlesk.com została otwarta.',
    'ui__server/resources__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/services__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/sitebuilder__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/skeleton__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Adresy %1 zostały usunięte z czarnej listy serwerowej.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Adresy zostały usunięte z czarnej listy serwerowej.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adresy zostały dodane do czarnej listy.',
    'ui__server/spam-filter/black-list/address__done' => 'Adresy zostały dodane do czarnej listy.',
    'ui__server/spam-filter/black-list__done' => 'Operacja zakończona powodzeniem.', // PFU
    'ui__server/spam-filter/properties__done' => 'Ustawienia filtra spamu zostały zmienione.',
    'ui__server/spam-filter/toggle_disable__done' => 'Filtr spamu został wyłączony dla całego systemu.',
    'ui__server/spam-filter/toggle_enable__done' => 'Filtrowanie spamu zostało uruchomione w trybie system-vide.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Adresy %1 zostały usunięte z czarnej listy serwerowej.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Adresy zostały usunięte z czarnej listy serwerowej.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adresy zostały dodane do Białych list.',
    'ui__server/spam-filter/white-list/address__done' => 'Adresy zostały dodane do Białych list.',
    'ui__server/spam-filter/white-list__done' => 'Operacja zakończona powodzeniem.', // PFU
    'ui__server/spam-filter__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/statistics__done' => 'Operacja zakończona powodzeniem.',
    'ui__server/time__done' => "Czas systemowy został zmieniony.",
    'ui__server__done' => "Operacja zakończona powodzeniem.",
    'ui__sessions/properties__done' => 'Operacja zakończona powodzeniem.',
    'ui__sessions__done' => 'Operacja zakończona powodzeniem.',
    'ui__sessions/delete__done' => 'Wybrane sesje zostały usunięte.',
    'ui__start-page__done' => 'Operacja zakończona powodzeniem.',
    'ui__support__done' => 'Strona obsługi technicznej została otwarta.',
    'ui__ts-sessions__done' => 'Operacja zakończona powodzeniem.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Brak plików do wysłania.',
    'login_up__access_denied_no_permission' => "Odmowa dostępu. Nie masz uprawnień, aby się zalogować.",
    'mail__unable_remove_pattern' => "Nie można usunąć adresu z czarnej listy serwera: %1", // PFW
    'mail__incorrect_network_format' => 'Niepoprawny format sieci: %1', // PFW
    'initconf__unable_change_passwd' => "Nie można zmienić hasła administratora: %1",
    'initconf__unable_get_passwd' => 'Nie można uzyskać bieżącego hasła administratora: %1 failed: %2',
    'initconf__invalid_hostname' => 'Błąd w nazwie hosta "%1"',
    'initconf__unable_reconfig' => 'Nie można skonfigurować Plesk: reconfig zawiódł: %1',
    'initconf__unable_update_admin' => 'Nie można zaktualizować informacji kontaktowych administratora: %1',
    '__refresh' => 'Odśwież',
    '__dalias_not_exist' => 'Alias domeny nie istnieje.',
    '__bug146523_explanation' => 'Poprzednia wersja Plesk pozwalała używać do 16 znaków dla nazw użytkowników FTP. Ta wersja Plesk pozwala na 15 znakowe nazwy użytkowników FTP. Aby rozwiązać ten problem zredukuj nazwy użytkowników FTP do 15 znaków tam gdzie jest to konieczne, zmień chociaż jeden znak przy problematycznych nazwach kont użytkowników FTP aby uniknąć kolizji nazw użytkowników. Przepraszamy za wszelkie możliwe problemy związane z tą zmianą.',
    'domain__cannot_change_webmail' => 'Nie można zmienić webmail-a dla domeny: %1',
    'sb_publish_disable_warning' => 'Jeśli wyłączysz tworzenie strony internetowej z Presence Builder, utworzone wcześniej strony w Presence Builder zostaną usunięte, a wszystkie dane na stronie zostaną utracone. Kliknij OK, jeśli chcesz kontynuować.',
    '__sbnet_client_use_sbnet' => "Utwórz korespondujące konto użytkownika w Presence Builder",
    'mail_resp_activate' => 'Aktywuj auto-odpowiedź',
    'limitsManger__limit_available_error' => 'Ne można przydzielić żądanej liczby zasobów ("%%limitName%%"): tylko %%available%% jest dostępnych dla tego konta.',
    'limitsManger__limit_reserved_error' => 'Nie można przydzielić mniej zasobów ("%%limitName%%") niż te, które zostały już wykorzystane.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Nie można zmienić domeny: Katalog wirtualny o podanej nazwie już istnieje.',
    'domain_unable_to_rename' => 'Nie można zmienić domeny.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Ogólny',
    'spamfilter__spamassassin_status_legend' => 'Filtrowanie spamu za pomocą SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Ustawienia SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Włącz filtrowanie spamu za pomocą SpamAssassin dla całego serwera",
    'spamfilter__spamassassin_user_status_legend' => 'Włącz filtrowanie spamu za pomocą SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Włącz ochronę przed spamem typu szara lista dla całego serwera',
    'spamfilter__personal_settings_not_allowed' => 'Polityka systemu nie zezwala na stosowanie indywidualnych ustawień filtrowania spamu.',
    'spamfilter__required_score' => 'Liczba punktów jaką wiadomość musi uzyskać aby zostać zakwalifikowana jako spam',
    'spamfilter__rewrite_header_subject' => 'Dodaj następujący tekst na początku tytułu każdej wiadomości rozpoznanej jako spam',
    'spamfilter__use_mailuser_prefs' => 'Pozwól edycję właściwości per użytkownik',
    'spamfilter_addresses__text_hint' => 'Rozdziel wiele adresów znakiem nowej linii, spacją, tabulacją, przecinkiem lub średnikiem. Na lewo od znaku @ nie może być znaków nie należących do zbioru ASCII. Adresy mogą zawierać wieloznaczniki "*" oraz "?" (na przykład, *@domena.com, użytkownik?@*.com). Części nazw domen które zawierają znaki spoza zbioru ASCII nie mogą z zawierać wieloznaczników.',
    'spamfilter__spamassassin__antivirus_settings_legend' => 'Użyj ustawień serwera',
    'spamfilter__antivirus_use_mailuser_prefs' => 'Ustawienia osobiste',
    'spamfilter__score_error' => 'Wynik nie powienien być negatywny, część przed przecinkiem musi być niższa niż 100 i nie może zawierać więcej niz 2 cyfry po przecinku.',
    'spamfilter__rewrite_header_error' => 'Temat wiadomości może zawierać jakikolwiek znak drukarski oprócz znaku (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Odbij',
    'nonexistent_mail__mode_discard' => 'Odrzuć',
    'nonexistent_mail__mode_catch_addr' => 'Prześlij na adres e-mail',
    'nonexistent_mail__mode_catch_ip' => 'Prześlij na IP',
    'nonexistent_mail__bounce_not_supported' => 'Tryb odrzucania e-maila nie jest obsługiwany',
    'nonexistent_mail__discard_not_supported' => 'Tryb odrzuć (discard) nie jest obsługiwany',
    'nonexistent_mail__catch_not_supported' => 'Przekazywanie na adres e-mail nie jest obsługiwane',
    'nonexistent_mail__redirect_not_supported' => 'Przesyłanie na IP nie jest obsługiwane',
    'nonexistent_mail__ip_used_on_this_host' => 'Adres IP przetwarza do hosta lokalnego',
    'nonexistent_mail_address_should_be_local_domain' => 'Ponieważ Kontrola poczty wychodzącej jest włączona, adres e-mail %1 dla nieistniejących odbiorców powinien należeć do wybranej domeny. Jeśli nie należy, zastosowana zostanie polityka "Odrzuć" zamiast przekazywania.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Skoro kontrola poczty wychodzącej jest włączona, adres e-mail podany do przekazywania poczty (%1) powinien należeć do wybranej domeny. Jeśli nie jest, wiadomości wysłane na ten adres nie będą zaliczane do kontroli poczty wychodzącej.',
    // mail acc extras
    '__antivirus' => "Antywirus",

    // additional keys
    'additional_keys__select_to_install' => 'Żaden klucz nie został wybrany. Proszę wybrać klucze, które chcesz zainstalować.',
    'additional_key_update__title' => "Aktualizacja dodatkowego klucza",
    'additional_key_update__legend' => "Status aktualizacji dodatkowego klucza",
    'additional_key_update__new_key' => "Dodatkowe właściwości klucza",
    'bt_additional_key_install' => "Zainstaluj klucz",
    'b_additional_key_install' => 'Kliknij, aby zainstalować aktualny klucz licencyjny.',
    'bt_additional_key_update' => "Pobierz dodatkowy klucz",
    'bt_additional_key_revert' => "Przywróć klucz",
    'b_additional_key_upload' => 'Kliknij, aby wgrać nowy klucz licencji.',
    'b_additional_key_download' => 'Kliknij, aby pobrać aktualny klucz licencyjny.',
    'b_additional_key_remove' => 'Kliknij, aby usunąć aktualny klucz licencji.',
    'b_additionalkeyslist_install' => 'Zainstaluj zaznaczone klucze licencyjne.',

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Brak dostępnych dodatkowych kont administratora.', // PFW
    'ui__client/domain/certificate__none-available' => 'Klient nie posiada certyfikatów SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Klient nie posiada domen z certyfikatami SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Domena nie posiada certyfikatów SSL/TLS.',
    'ui__reseller/client__none-available' => 'Nie ma żadnych sprzedawców z klientami.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Musisz wybrać adresy IP, które chcesz usunąć z puli IP.',
    'ui__reseller/client/chowner__empty_selection' => 'Musisz wybrać konta klienta, które chcesz przypisać do innego właściciela.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Musisz wybrać konta sprzedawcy z tych puli IP, które chcesz, aby odwoływały się do adresu IP.',
    'ui__server/crontab/task/delete__empty_selection' => 'Musisz wybrać zadanie, które chcesz anulować.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'PHP jest wyłączony dla tej strony.',
    'phosting__aspdotnet_not_enabled' => 'Wsparcie ASP.NET jest wyłączone dla tej strony.',
    'phosting__php_forced_by_site_isolation' => 'Nie jest możliwe zmienienie ustawień PHP: Nie masz uprawnień do nadpisywania globalnego regulaminu bezpieczeństwa serwera.',
    'phosting__option_forced_by_site_isolation' => 'Nie jest możliwe zmienienie ustawień %1: Nie masz uprawnień do nadpisywania globalnego regulaminu bezpieczeństwa serwera.',
    'phosting__mod_bw_disabled_by_vps_optimized' => 'mod_bw jest wyłączony, ponieważ Plesk działa w trybie VPS-zoptymilizowany.',
    'phosting__mod_php_disabled_by_vps_optimized' => 'mod_php jest wyłączony, ponieważ Plesk działa w trybie VPS-zoptymilizowany.',
    'phosting__perl_disabled_by_vps_optimized' => 'Perl jest wyłączony, ponieważ Plesk działa w trybie VPS-zoptymilizowany.',
    'phosting__asp_disabled_by_vps_optimized' => 'ASP jest wyłączony, ponieważ Plesk działa w trybie VPS-zoptymilizowany.',
    'phosting__python_disabled_by_vps_optimized' => 'Python jest wyłączony, ponieważ Plesk działa w trybie VPS-zoptymilizowany.',
    'phosting__fastcgi_disabled_by_vps_optimized' => 'fastcgi jest wyłączony, ponieważ Plesk działa w trybie VPS-zoptymilizowany.',
    'phosting__php_handler_id_not_registered' => 'Ten handler PHP nie jest dozwolony w ustawieniach izolacji serwisu. Zostanie użyty domyślny handler PHP.',
    'phosting__php_served_by_nginx_is_not_available' => 'Ten handler PHP (aplikacja FPM obsługiwana przez nginx) nie jest dozwolony w ustawieniach izolacji serwisu. Zostanie użyty domyślny handler PHP.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Zobacz listę adresów IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Zobacz listę adresów IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Zobacz listę adresów IP, dostępnych dla tego użytkownika.',
    'ui__server/certificate__short-title' => 'Ceryfikaty SSl/TLS',
    'ui__server/certificate__title' => 'Ceryfikaty SSl/TLS',
    'ui__server/certificate__description' => 'Zobacz certyfikaty SSL/TLS i zarządzaj nimi.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Usuń typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Usuń typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Potwierdzenie usunięcia typów MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Dodaj typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Dodaj typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Zarejestruj typ MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Usuń adresy IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Wybierz adresy IP, które chcesz usunąć z puli IP klienta %1',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => 'Utwórz plik',
    'ui__client/domain/hosting/file-manager/create-file__title' => 'Utwórz plik',
    'ui__client/domain/hosting/file-manager/create-file__description' => 'Tworzenie pliku.',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => 'Utwórz folder',
    'ui__client/domain/hosting/file-manager/create-dir__title' => 'Utwórz folder',
    'ui__client/domain/hosting/file-manager/create-dir__description' => 'Utwórz folder.',
    'ui__client/domain/hosting/file-manager/edit__short-title' => 'Edytuj plik lub folder',
    'ui__client/domain/hosting/file-manager/edit__title' => 'Edytuj plik lub folder',
    'ui__client/domain/hosting/file-manager/edit__description' => 'Edytuj wybrany plik lub folder.',
    'ui__client/domain/hosting/file-manager/rename__short-title' => 'Zmień nazwę pliku lub folderu',
    'ui__client/domain/hosting/file-manager/rename__title' => 'Zmień nazwę pliku lub folderu',
    'ui__client/domain/hosting/file-manager/rename__description' => 'Zmień nazwę zaznaczonego pliku lub folderu.',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => 'Zmień Uprawnienia',
    'ui__client/domain/hosting/file-manager/permissions__title' => 'Zmień Uprawnienia',
    'ui__client/domain/hosting/file-manager/permissions__description' => 'Zmień prawa dostępu do pliku lub folderu.',
    'ui__client/domain/hosting/file-manager/remove__short-title' => 'Usuń plik lub folder',
    'ui__client/domain/hosting/file-manager/remove__title' => 'Usuń plik lub folder',
    'ui__client/domain/hosting/file-manager/remove__description' => 'Usuń ten plik lub folder.',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => 'Usuń plik lub folder',
    'ui__client/domain/hosting/file-manager/remove_self__title' => 'Usuń plik lub folder',
    'ui__client/domain/hosting/file-manager/remove_self__description' => 'Usuń ten plik lub folder.',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => 'Kopiuj lub przenieś plik lub katalog',
    'ui__client/domain/hosting/file-manager/copy-move__title' => 'Kopiuj lub przenieś plik lub katalog',
    'ui__client/domain/hosting/file-manager/copy-move__description' => 'Kopiuj lub przenieś wybrane pliki lub katalogi.',
    'ui__client/domain/hosting/file-manager/view__short-title' => 'Zobacz plik',
    'ui__client/domain/hosting/file-manager/view__title' => 'Zobacz plik',
    'ui__client/domain/hosting/file-manager/view__description' => 'Zobacz wybrany plik.',

    'ui__client/ipaddress__short-title' => 'Adres IP',
    'ui__client/ipaddress__title' => 'Adres IP',
    'ui__client/ipaddress__description' => 'Wyświetl informacje o adresach IP.',
    'ui__server/ip-address__short-title' => 'Adres IP',
    'ui__server/ip-address__title' => 'Adres IP',
    'ui__server/ip-address__description' => 'Wyświetl informacje o adresach IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Ustawienia hostingu',
    'ui__client/domain/hosting/setup__title' => 'Ustawienia hostingu',
    'ui__client/domain/hosting/setup__description' => 'Skonfiguruj ustawienia hostingu sieciowego dla strony internetowej %1.',
    'ui__reseller/client/chowner_multi__description' => 'Wybierz nowego właściciela dla wybranych kont klienta.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Typ MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Właściwości typu MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Zobacz właściwości typu MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Dokument błędów', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Dokument błędów', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Właściwości dokumentu błędu.', // PFW

    // tooltips

    'b_resellerreportslist_remove' => 'Usuń wybrane layouty raportu.',
    'b_resellerreportslist_search' => 'Podaj wzór wyszukiwania i kliknij przycisk, aby znaleźć layouty raportu.',
    'b_resellerreportslist_show_all' => 'Pokaż wszystkie dostępne layouty raportu.',

    'l_resellerreportslist_auto' => 'Sortuj layouty raportu według automatyzacji dostawy.',
    'l_resellerreportslist_clients' => 'Sortuj layouty raportu po obecności informacji o klientach.',
    'l_resellerreportslist_domains' => 'Sortuj layouty raportu po obecności informacji o domenach.',
    'l_resellerreportslist_general' => 'Sortuj layouty raportu po obecności informacji ogólnych.',
    'l_resellerreportslist_name' => 'Sortuj layouty raportu po nazwie raportu.',
    'l_resellerreportslist_personal_domains' => 'Sortuj layouty raportu po obecności informacji o prywatnych domenach.',

    'b_adminreportslist_remove' => 'Usuń wybrane layouty raportu.',
    'b_adminreportslist_search' => 'Podaj wzór wyszukiwania i kliknij przycisk, aby znaleźć layouty raportu.',
    'b_adminreportslist_show_all' => 'Pokaż wszystkie dostępne layouty raportu.',

    'l_adminreportslist_auto' => 'Sortuj layouty raportu według automatyzacji dostawy.',
    'l_adminreportslist_clients' => 'Sortuj layouty raportu po obecności informacji o klientach.',
    'l_adminreportslist_domains' => 'Sortuj layouty raportu po obecności informacji o domenach.',
    'l_adminreportslist_general' => 'Sortuj layouty raportu po obecności informacji ogólnych.',
    'l_adminreportslist_name' => 'Sortuj layouty raportu po nazwie raportu.',
    'l_adminreportslist_personal_clients' => 'Sortuj layouty raportu po obecności informacji o własnych klientach.',
    'l_adminreportslist_personal_domains' => 'Sortuj layouty raportu po obecności informacji o własnych domenach.',
    'l_adminreportslist_resellers' => 'Sortuj layouty raportu po obecności informacji o sprzedawcach.',

    'b_clientsonlylist_remove' => 'Usuń wybrane konta klienta.',
    'b_clientsonlylist_search' => 'Wprowadź wzorzec wyszukiwania i kliknij, aby znaleźć konta klienta.',
    'b_clientsonlylist_show_all' => 'Pokaż wszystkie konta klientów.',
    'l_clientsonlylist_cname' => 'Sortuj konta klientów według nazwy firmy.',
    'l_clientsonlylist_date' => 'Sortuj konta klientów według daty utworzenia.',
    'l_clientsonlylist_domains' => 'Sortuj konta klientów według ilości domen.',
    'l_clientsonlylist_name' => 'Sortuj konta klientów według nazwy.',
    'l_clientsonlylist_owner' => 'Sortuj konta klientów według właściciela.',
    'l_clientsonlylist_type' => 'Sortuj konta klientów według typu.',

    'b_get_password_cancel' => 'Wróć do poprzedniego ekranu bez wysyłania e-maila.',
    'b_get_password_send' => 'Kliknij OK, aby wysłać wiadomość dotyczącą odzyskiwania hasła na adres e-mail zarejestrowany w systemie.',



    'b_personaltrafficlist_search' => 'Wpisz maskę przeszukiwania i Kliknij, aby znaleźć domeny.',
    'b_personaltrafficlist_show_all' => 'Pokaż wszystkie domeny.',

    'b_back' => 'Powr o poprzedniej strony.',
    'b_next' => 'Przejdź do następnej strony.',

    'b_dnsnstemplatelist_remove' => 'Usuń zaznaczone serwery DNS.',
    'b_dnsnstemplatelist_search' => 'Wpisz maskę przeszukiwania i kliknij , aby znaleźć serwery DNS.',
    'b_dnsnstemplatelist_show_all' => 'Pokaż wszystkie serwery DNS.',

    'l_dnsnstemplatelist_ns' => 'Sortuj rekordy szablonu DNS po nazwie serwera.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Wygeneruj bezpieczne linki do plików i katalogów',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Uruchom pliki ogólnodostępne',
    'cu__serverfilesharing_fsPublicFolder' => 'Katalog do przechowywania plików ogólnodostępnych',
    'cu__serverfilesharing_fsPublicUrl' => 'URL dostępu do plików ogólnodostępnych na zasadzie',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Uruchom zabezpieczanie hasłem plików ogólnodostępnych',
    'cu__serverfilesharing_fsPartnerFolder' => 'Katalog do przechowywania plików zabezpieczonych hasłem',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nazwa użytkownika używana do dostępu do pliku',
    'cu__serverfilesharing_fsPartnersPassword' => 'Hasło używane do dostępu do pliku',
    'cu__serverfilesharing_fsDomain' => 'URL katalogu webowego roota. Nazwa domeny',
    'cu__serverfilesharing_fsPrefix' => 'URL katalogu webowego roota. Prefiks',
    'cu__serverfilesharing_commandUpdate' => 'Zaktualizuj ustawienia współdzielenia plików',
    'cu__serverfilesharing_commandInfo' => 'Wyświetl obecne ustawienia współdzielenia plików',
    'server_preferences_include_admin_dumps_into_client_usage' => 'kopie zapasowe utworzone przez administratora',
    'server_preferences__forbid_subscription_rename' => 'Zabroń klientom i sprzedawcom zmiany nazwy domeny głównej',
    'subscription_rename_is_forbidden' => 'Zmiana nazw subskrypcji jest zabroniona przez politykę ogólną serwera.',
    'server_preferences__allow_sys_user_rename' => 'Klienci mogą zmieniać nazwy użytkowników systemu',
    'server_preferences__allow_sys_user_rename_false' => 'Zawsze',
    'server_preferences__allow_sys_user_rename_true' => 'Tylko jeśli nadano uprawnienia do zarządzania hostingiem',
    'server_preferences__allow_sys_user_rename_forced' => 'Nigdy',
    'server_preferences__preferred_domain' => 'Preferowane domeny dla serwisów WWW',
    'server_preferences__preferred_domain_none' => 'Żaden',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => 'Anonimizuj adresy IP',
    'server_preferences__anonymize_ips_text' => 'Anonimizuj adresy IP podczas rotacji logów i zbierania statystyk internetowych',
    'server_preferences__anonymize_ips_description' => 'Skrypt uruchamiany po rotacji logów zamienia ostatni oktet adresów IPv4 w obróconych plikach dziennika na "0" przed archiwizacją. W adresach IPv6 skrypt zastępuje ostatnią sekcję adresu (dwa oktety po ostatnim dwukropku) z "0000" (w pełnej formie) lub "0" (w skróconej formie)',
    'server_preferences__logrotate' => 'Twórz logi rotacji',
    'server_preferences__logrotate_force' => 'Wymuś codzienne rotowanie dzienników dla wszystkich domen',
    'server_preferences__logrotate_period' => 'Zezwalaj na przechowywanie plików dzienników witryny dla',
    'server_preferences__logrotate_period_days' => 'dni',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Zarządzaj zaplanowanymi zadaniami na serwerze',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Wybierz użytkownika systemu, którego zaplanowanymi zadaniami chcesz zarządzać.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Zaplanowane zadanie %1',
    'ui__server/crontab/task__description' => 'Przeglądaj właściwości zaplanowanego zadania %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Zarządzaj harmonogramem zadań',
    'ui__server/crontab_unknown__title' => 'Zarządzaj harmonogramem zadań',
    'ui__server/crontab_unknown__description' => 'Zarządzaj harmonogramem zadań.',


    'ui__server/crontab__none-available' => 'Nie masz kont użytkowników systemu.',
    'ui__server/crontab_readonly-unknown__description' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Harmonogram zadań',
    'ui__server/crontab_readonly-unknown__title' => 'Zobacz zaplanowane zadania',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab_readonly__description' => 'Zobacz zaplanowane zadania z %1.',
    'ui__server/crontab_readonly__short-title' => 'Zaplanowane zadanie %1',
    'ui__server/crontab_readonly__title' => 'Zobacz zaplanowane zadania z %1',
    'ui__server/crontab_unknown__wizard-title' => 'Zarządzaj zaplanowanymi zadaniami.',

    'ui__server/crontab/properties__description' => 'Edytuj zaplanowane zadania %1.',

    'ui__server/crontab/properties__short-title' => 'Ustawienia',
    'ui__server/crontab/properties__title' => 'Edytuj zaplanowane zadania %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Ustawienia',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Zobacz zaplanowane zadania',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab/properties_readonly__description' => 'Zobacz zaplanowane zadania z %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Ustawienia',
    'ui__server/crontab/properties_readonly__title' => 'Zobacz zaplanowane zadania z %1',
    'ui__server/crontab/properties_unknown__description' => 'Edytuj zaplanowane zadania.',
    'ui__server/crontab/properties_unknown__short-title' => 'Właściwości',
    'ui__server/crontab/properties_unknown__title' => 'Edytuj zaplanowane zadania',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Edytuj zaplanowane zadania.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Wskaż użytkownika którego zadania chcesz zobaczyć.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Wskaż użytkownika którego zadania chcesz zmienić.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Kliknij Zakończ, aby zastosować zmiany i wyjść z kreatora.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Kliknij Zakończ, aby wyjść z kreatora.',

    'ui__server/crontab/task__none-available' => 'Nie masz zaplanowanych zadać.',
    'ui__server/crontab/task__none-available__2' => 'Użytkownik systemu %1 nie ma żadnych zaplanowanych zadań.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Zaplanowane zadania.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Zadania',
    'ui__server/crontab/task_readonly-unknown__title' => 'Harmonogram zadań',

    'ui__server/crontab/task/delete__description' => 'Usuń zaplanowane zadanie %1',

    'ui__server/crontab/task/delete__short-title' => 'Usuń',
    'ui__server/crontab/task/delete__title' => 'Usuń zaplanowane zadanie %1',
    'ui__server/crontab/task/delete_multi__description' => 'Usuń zaplanowane zadania.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Usuń',
    'ui__server/crontab/task/delete_multi__title' => 'Usuń zaplanowane zadania',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Usuń zaplanowane zadania.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Wskaż użytkownika systemu którego zadania chcesz usunąć.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Wskaż zadania które chcesz usunąć.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Zatwierdź usunięcie zadania zaznaczając kwadracik po czym kliknij Zakończ aby wyjść z kreatora.',
    'ui__server/crontab/task/delete_unknown__description' => 'Usuń zaplanowane zadanie.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Usuń',
    'ui__server/crontab/task/delete_unknown__title' => 'Usuń zaplanowane zadania',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Usuń zaplanowane zadanie.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Wskaż użytkownika któremu chcesz usunąć zadania.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Wskaż zadania które chcesz usunąć.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Zatwierdź usunięcie zadania zaznaczając kwadracik po czym kliknij Zakończ aby wyjść z kreatora.',

    'ui__server/crontab/task/properties__description' => 'Edytuj zaplanowane zadania.',

    'ui__server/crontab/task/properties__short-title' => 'Edytuj zadanie %1',
    'ui__server/crontab/task/properties__title' => 'Edytuj zaplanowane zadania',
    'ui__server/crontab/task/properties_new__description' => 'Utwórz zaplanowane zadanie dla %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Dodaj zadanie',
    'ui__server/crontab/task/properties_new__title' => 'Utwórz zaplanowane zadanie dla %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Utwórz zaplanowane zadanie.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Wskaż użytkownika systemu któremu chcesz dodać nowe zaplanowane zadanie.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Kliknij Zakończ, aby zastosować zmiany i wyjść z kreatora.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Właściwości',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Zobacz zaplanowane zadania',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab/task/properties_readonly__description' => 'Zobacz zaplanowane zadania.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Zobacz zadanie %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Zobacz zaplanowane zadania',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Utwórz zaplanowane zadania.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Dodaj zadanie',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Utwórz zaplanowane zadania',
    'ui__server/crontab/task/properties_unknown__description' => 'Edytuj zaplanowane zadania.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Właściwości',
    'ui__server/crontab/task/properties_unknown__title' => 'Edytuj zaplanowane zadania',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Edytuj zaplanowane zadania.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Wskaż użytkownika którego zadania chcesz zobaczyć.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Wskaż użytkownika którego zadania chcesz zmienić.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Zaznacz zaplanowane zadanie.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Zaznacz zaplanowane zadanie które chcesz zmienić.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Kliknij Zakończ, aby zastosować zmiany i wyjść z kreatora.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Kliknij Zakończ, aby wyjść z kreatora.',

    'ui__server/crontab/task/toggle_disable__description' => 'Wyłącz zaplanowane zadanie %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Wyłącz',
    'ui__server/crontab/task/toggle_disable__title' => 'Wyłącz zaplanowane zadanie %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Włącz zaplanowane zadanie %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Włącz',
    'ui__server/crontab/task/toggle_enable__title' => 'Włącz zaplanowane zadanie %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Włącz lub wyłącz zaplanowane zadania.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Aktywuj lub zdezaktywuj',
    'ui__server/crontab/task/toggle_unknown__title' => 'Włącz lub wyłącz zaplanowane zadania',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Włącz lub wyłącz zaplanowane zadania',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Wskaż użytkownika systemu któremu chcesz włączyć lub wyłączyć zadania.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Zaznacz zadanie które chcesz włączyć lub wyłączyć.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Konta klienta', // not used on HP?
    'ui__client_unknown__title' => 'Konta klienta', // not used on HP?
    'ui__client_unknown__description' => 'Zarządzaj kontami klientów.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Zawieś domenę', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Zawieś domenę', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Zawieś domenę.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktywuj domenę', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktywuj domenę', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktywuj domenę.', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => 'Przypisz nowego właściciela do kont klienta',
    'ui__client/chowner_multi-select__short-title' => 'Przypisz nowego właściciela',
    'ui__client/chowner_multi-select__description' => 'Przypisz nowego właściciela dla wybranych kont klienta.',


    //Additional FTP Accounts
    'directory_browser__select_folder' => 'Wybierz folder',
    'ftp__management_domain' => "Konta FTP pod domeną %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Konta FTP",
    'ftp__user_name' => "Nazwa konta FTP",
    'ftp__user_home' => "Katalog domowy",
    'ftp__invalid_path' => "Podano błędną ścieżkę",
    'ftp__physical_path_not_exist' => "Fizyczna ścieżka nie istnieje",
    'i_ftp_ses_sub_user' => 'Sesja konta FTP.',
    '__new_passwd' => "Nowe %1 hasło",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Nie udało się skonfigurować serwera sieciowego dla hosta <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Nie udało się wygenerować pliku konfiguracyjnego serwera sieciowego na hoście <%%host%%>, ponieważ wystąpiły następujące błędy:\n\n%%error%%\n\nNapraw błędy w szablonach konfiguracji serwera sieciowego i wygeneruj plik ponownie.",

    'apacheConfigurationMessageAdminTitle' => 'Konfiguracja serwera WWW nie powiodła się',
    'apacheConfigurationMessageClientTitle' => 'Uwaga',

    'apacheConfigurationFailedAdminHomeMessage' => 'Nowa plik konfiguracji nie został utworzony z powodu błędów w konfiguracji szablonów. Szczegółowe informacje na temat błędów zostały wysłane do Ciebie e-mailem. Prosimy więc o sprawdzenie skrzynki e-mailowej, naprawienie błędów i kliknięcie %1, by ponowić tworzenie konfiguracji.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'tutaj', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Nowa konfiguracja dla domeny %1 nie została utworzona z powodu błędów w konfiguracji szablonów. Szczegółowe informacje na temat błędów zostały wysłane do Ciebie e-mailem. Prosimy więc o sprawdzenie skrzynki e-mailowej, naprawienie błędów i kliknięcie %2, by ponowić tworzenie konfiguracji.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'tutaj', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Konfiguracja serwera WWW dla domeny %1 może być nieprawidłowa. Skontaktuj się z administratorem serwera, aby rozwiązać problem.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Nowa konfiguracja dla niektórych domen nie została utworzona z powodu błędów w konfiguracji szablonów. Szczegółowe informacje na temat błędów zostały wysłane do Ciebie e-mailem. Prosimy więc o sprawdzenie skrzynki e-mailowej, naprawienie błędów i kliknięcie %1, by ponowić tworzenie konfiguracji.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'tutaj', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Konfiguracja serwera dla niektórych twoich domen może być niespójna. Skontaktuj się z administratorem serwera, aby rozwiązać problem.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Spersonalizowane dokumenty błędów",
    'dom_pref__webusers_script' => "Zezwalaj użytkownikom sieci na używanie skryptów",
    '__seoRedirect' => 'Skonfiguruj preferowaną domenę jako',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Żaden',

    '__sites' => 'Domeny',
    'domain_plan__perm_denied_manage_phosting' => 'Nie masz uprawnień do zarządzania ustawieniami hostingu.',
    '__owned_by_client' => 'właścicielem jest klient',
    'ui__client/permissions_readonly__description' => "Zobacz operacje, które klient %1 może wykonywać w Plesk.",
    'client_chown_subscription_will_be_anonymous' => 'Klienci zostaną wypisani ze swoich obecnych planów usług.',
    'backup__restore__object_client_template' => 'Szablon klienta',
    '__template_name' => 'Nazwa planu usługi',
    'template__not_exists' => 'Nie ma takiego planu usługi',
    'template__exists' => 'Plan o nazwie %1 już istnieje.',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => 'Klient subskrybował domeny do %1 planów usługi.',
    'clientOwnerChanger__ip_not_in_pool' => 'Podany adres IP nie znajduje się w puli sprzedawcy.',

    //// Change owner of subscription
    'chown__select_title' => "Wybierz nowego abonenta",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Wybierz nowego właściciela zaznaczonej subskrycji i kliknij Dalej >>.',
    'domains__client_info' => "%1 subskrypcji (aktywnych: %2), %3 zajętego dysku, %4 zużytego transferu",
    '__possible_owners' => 'Możliwi nowi właściciele subskrypcji',

    'clients_list__filter_owner__filter_title' => 'Dostawca',
    'clients_list__filter_owner_any' => 'Wszyscy użytkownicy',
    'clients_list__filter_owner_my' => 'Tylko moi subskrybenci',
    'clients_list__filter_owner_name__filter_title' => 'Nazwa dostawcy',

    '__owner' => "Dostawca",
    'l_clientslist_owner' => 'Sortuj konta użytkowników według dostawcy.',
    'l_clientslist_date' => 'Sortuj konta użytkowników według daty utworzenia.',
    'l_clientslist_name' => 'Sortuj konta użytkowników według nazwy.',
    'l_clientslist_domains' => 'Sortuj konta użytkowników według domen.',
    'l_clientslist_cname' => 'Sortuj konta użytkowników według nazwy firmy.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Zmiana przypisania wybranych subskrypcji',
    'chown__check_title' => 'Zmień subskrybenta',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Kliknij Zakończ, aby zakończyć ponowne przypisywanie. Po wykonaniu tego, wybrane subskrypcje zostaną przypisane do nowego właściciela, ich dostawca zostanie zamieniony na nowego dostawcę właściciela\\li oraz zostaną oni odcięci od swoich planów usług, które zaczną być niestandardowe.",

    'chown__error_check' => 'Wystąpiły pewne problemy podczas próby przypisania niektórych subkrypcji do nowego właściciela.',
    'domain_chown_subscription_will_be_anonymous' => "Te subskrypcje zostaną odłączone od swoich obecnych planów usług i staną się niestandardowe.",
    'chown__error_domains_exclude' => "Wystąpiły pewne problemy podczas próby przypisania niektórych subkrypcji do nowego właściciela. Subskrypcje te są podświetlone.",
    'chown__ip_not_in_client_pool' => "Adres IP związany z tą subskrypcją nie został dodany do puli IP nowego właściciela.",
    'chown__already_owned_by_client' => "Ta subskrypcja należy już do tego użytkownika.",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => 'Chroniony katalog /%1',
    'ui__client/domain/hosting/protected-directories/path__description' => 'Zarządzanie chronionym katalogiem %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => 'Utwórz chroniony katalog pod serwisem %1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => 'Nowy katalog',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => 'Utwórz chroniony katalog.',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => 'Chroniony katalog /%1 został pomyślnie usunięty.',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => 'Ustawienia chronionego katalogu /%1',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => 'Ustawienia katalogu',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => 'Zmień lokalizację, nazwę i tytuł obszaru dla chronionego katalogu.',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => 'Ustawienia chronionego katalogu zostały zmienione.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => 'Potwierdzenie usunięcia',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => 'Usuń zabezpieczenie',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => 'Usuń ochronę z wybranych katalogów.',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => 'Wybierz katalog, z którego chcesz usunąć zabezpieczenie.',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => 'Ta operacja spowoduje usunięcie zabezpieczeń z katalogów. Katalogi staną się wolnodostępne dla użytkowników Internetu.',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => 'Zabezpieczenie zostało pomyślnie usunięte z wybranych katalogów.',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => 'Dodaj użytkownika',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => 'Dodaj użytkownika',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => 'Ustaw konto użytkownika, aby nadać mu dostęp do chronionego katalogu %1',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => 'Konto użytkownika z dostępem do chronionego katalogu zostało utworzone.',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "Dane uwierzytelniające użytkownika zostały zapisane.",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => 'Usuwanie użytkowników chronionego katalogu',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => 'Wybierz użytkowników, których chcesz usunąć.',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => 'Usuń',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => 'Usuń użytkowników katalogu.',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => 'Następujący użytkownicy chronionego katalogu zostaną usunięci:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => 'Wybrane konta użytkownika zostały usunięte.',

    '__redirect_hint' => 'Zostaniesz przekierowany do nowego adresu za 15 sekund... Jeśli nie zostaniesz automatycznie przekierowany do nowej lokacji, proszę włączyć JavaScript lub kliknąć link %%link%%.',

    'backup__restore__object_maillist' => 'Lista mailingowa',
    'backup__restore__object_site' => 'Strona',
    'backup__restore__object_user' => 'Użytkownik',
    'backup__restore__object_role' => 'Rola',

    'limit__name_max_site' => 'strony',

    'iis_pool__unable_rename_client' => "Nie można zmienić nazwy puli aplikacji: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonimowy dostęp do FTP jest obsługiwany tylko w wypadku głównej domeny subskrypcji.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Anonimowa usługa FTP jest obsługiwana tylko dla głównej domeny subskrypcji.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/miesiąc',
    '__tb_month' => 'TB/miesiąc',

    '__customers' => 'Klienci',
    '__customer_name' => 'Nazwa klienta',
    '__customer_total' => 'Podsumowanie klienta',
    '__site' => 'Strona',
    '__def_site' => 'Strona domyślna',
    '__subscription_name' => 'Nazwa subskrypcji',
    '__subscription_name_powerUser' => 'Nazwa subskrypcji',

    'limit__units_max_traffic_suffix' => '/miesiąc',

    'dom_pref__discard' => "Odrzuć",

    'mail__pattern_already_exists' => 'Wzór "%1" jest już na czarnej liście.',

    '__not_supported' => 'Nie obsługiwane',

    'plesk_key__sitebuilder' => 'Strony opublikowane za pomocą Presence Builder',
    'limit__name_max_site_builder' => 'Strony opublikowane za pomocą Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Obsługa serwisów w wielu językach w Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statystyki transferu danych dla domeny %1',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statystyki transferu danych dla domeny %1',
    'ui__client/domain/traffic-hosting#list__title' => "Transfer danych za pomocą usług",

    'login_up__access_denied_no_subscriptions' => "Odmowa dostępu. Nie ma żadnych subskrypcji dostępnych dla tego konta.",

    'interval__day' => '%1 dni/dzień',
    'interval__hour' => '%1 godzin(a)',
    'interval__minute' => '%1 minut(a)',
    'interval__second' => '%1 sekund(a)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Próbujesz używać klucza licencyjnego innej wersji Plesk. Skontaktuj się z przedstawicielem handlowym Plesk, aby otrzymać odpowiedni klucz licencyjny.',
    //Standalone or virtualization
    'virtualization_any' => "Fizyczny serwer lub dowolne rozwiązania wirtualizacyjne",
    'virtualization_pvc' => "Kontenery Virtuozzo",
    'virtualization_vmware' => "VMware",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Serwer Virtuozzo",
    'plesk_key__virtualization' => "Ważny dla następujących środowisk:",
    'plesk_key__virtualization_only_key' => 'Klucz licencyjny jest przeznaczony wyłącznie do użytku z Plesk, pracującym w obrębie wirtualnego środowiska %1.',
    'plesk_key__virtualizations_only_key' => 'Klucz licencyjny jest przeznaczony wyłącznie do użytku z Plesk, pracującym w obrębie następujących środowisk wirtualnych: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Korzystanie z niestandardowych pakietów językowych jest zabronione.',
    'plesk_key__allowed-locales' => 'Dostępne pakiety językowe',
    'plesk_key__allowed-locales-any' => 'Dowolny język',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'Katalog cgi-bin jest umieszczony w',
    '_cgi_bin_mode_webspace' => 'katalog root subskrypcji',
    '_cgi_bin_mode_www_root' => 'dokument root tej domeny',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => 'Dodaj ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => 'Dodaj źródło danych ODBC.',
    'ui__server/odbc/dsn/delete_multi__short-title' => 'Usuń',
    'ui__server/odbc/dsn/delete_multi__title' => 'Potwierdzenie usunięcia',
    'ui__server/odbc/dsn/delete_multi__description' => 'Usuń zaznaczone źródła danych ODBC DSN.',
    'ui__server/odbc/dsn/delete#legend__description' => 'Poniższe połączenia ODBC DSN zostaną usunięte:',
    'ui__server/odbc/dsn/delete__empty_selection' => 'Nie wybrano żadnych połączeń ODBC DSN.',
    'ui__server/odbc/dsn/delete_multi__done' => 'Wybrane źródła danych zostały usunięte.',
    'ui__server/odbc/dsn__title' => 'Połączenia ODBC DSN %1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => 'Dodaj ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => 'Dodaj źródło danych ODBC.',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => 'Usuń',
    'ui__client/domain/odbc/dsn/delete_multi__title' => 'Potwierdzenie usunięcia',
    'ui__client/domain/odbc/dsn/delete_multi__description' => 'Usuń zaznaczone źródła danych ODBC DSN.',
    'ui__client/domain/odbc/dsn/delete#legend__description' => 'Poniższe połączenia ODBC DSN zostaną usunięte:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => 'Nie wybrano żadnych połączeń ODBC DSN.',
    'ui__client/domain/odbc/dsn/delete_multi__done' => 'Wybrane źródła danych zostały usunięte.',
    'ui__client/domain/odbc/dsn__title' => 'Połączenia ODBC DSN %1',


    /// Custom buttons
    'custom_button__sort_key' => 'Priorytet',
    'custom_button__place' => 'Lokalizacja',
    'custom_button__place_navigation' => 'Powszechny dostęp',
    'custom_button__place_admin' => 'Strona domowa administratora',
    'custom_button__place_admin-settings' => 'Strona Narzędzia i ustawienia administratora',
    'custom_button__place_reseller' => "Strona domowa sprzedawcy",
    'custom_button__place_reseller-settings' => 'Strona Narzędzia i Funkcjonalnośc sprzedawcyi',
    'custom_button__place_client' => 'Pulpit klientów',
    'custom_button__place_domain' => "Strony WWW i Domeny z subskrypcji",
    'custom_button__place_domain_powerUser' => "Strony WWW i Domeny z subskrypcji",
    'custom_button__place_domain-properties' => 'Narzędzia serwisu WWW',
    'custom_button__private' => 'Pokaż tylko mnie',
    'custom_button__image' => 'Obrazek tła',
    'custom_button__conhelp' => "Zawartość podpowiedzi pomocy kontekstowej",
    'custom_button__edit' => "Ustawienia linka do dodatkowej usługi",
    'custom_button__include_client_cname' => "Dołącz nazwę firmy klienta",
    'custom_button__include_client_email' => "Dołącz adres e-mail klienta",
    'custom_button__include_client_id' => "Dołącz ID klienta",
    'custom_button__include_client_pname' => "Dołącz kontakt klienta",
    'custom_button__include_domain_id' => "Dołącz ID subskrypcji, ID domeny i ID aliasu domeny",
    'custom_button__include_domain_id_powerUser' => "Dołącz ID subskrypcji, ID domeny i ID aliasu domeny",

    'custom_button__include_domain_name' => "Umieść nazwę domeny głównej",
    'custom_button__include_ftp_user' => "Dołącz nazwę użytkownika FTP",
    'custom_button__include_ftp_pass' => "Dołącz hasło FTP",
    'custom_button__internal_open' => "Otwórz URL w Plesk",
    'custom_button__text' => "Etykieta przycisku",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Format pliku nie jest formatem graficznym.',
    'custom_button__big_image' => 'Wielkość pliku nie może przekraczać 100 KB.',
    'custom_button__failed_copy_image' => 'Nie można skopiować pliku: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Nie można przywrócić kopii zapasowej nie należącej do Power-użytkownika w widoku trybu Power.',
    '__unknown_network_interface' => 'Nieznany interfejs sieciowy',

    'init_conf__ip_address' => 'Adres IP',

    //Confirmation page
    'bt_confirm' => 'Potwierdź',
    'b_confirm' => 'Potwierdź własność Twoich witryn.',

    //// New VZPP Integration
    '__vzpp_integration_warning' => 'Ta instancja Plesk jest zainstalowana w kontenerze Virtuozzo. Obecne ustawienia trybu offline kontenera sprawiają, że Plesk jest niedostępny.',
    '__vzpp_integration_contact_admin' => 'Jeśli posiadasz odpowiednie uprawienia do modyfikowania konfiguracji Kontenera, %1. W przeciwnym razie skontaktuj się z dostawcą.',
    '__vzpp_integration_help_link' => 'Zmień ustawienia trybu offline',



    'performance__iss_app_pool_forced_by_site_isolation' => 'Ustawienia przydzielonej puli aplikacji IIS wykonano zgodnie z polityką bezpieczeństwa całego serwera (konfiguracja izolacji stron).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Ustawienia przydzielonej puli aplikacji IIS wykonano zgodnie z ustawieniami wydajności całego serwera.',

    '__current' => 'Obecny',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Właściwości użytkownika zostały zaktualizowane.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Wykorzystałeś niemal wszystkie domeny dostarczone z twoją licencją Plesk (90% lub nawet więcej).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Wykorzystałeś niemal wszystkie domeny.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Wykorzystałeś niemal wszystkie strony Presence Builder ,dostarczone wraz z twoją licencją Plesk (90% lub nawet więcej).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Wykorzystałeś niemal wszystkie strony Presence Builder.',
    'promo__button_hide' => 'Ukryj',
    'promo__button_next' => 'Następny >>',
    'promo__button_prev' => '<< Poprzedni',
    'promo__button_license' => 'Zaktualizuj licencję',

    'promo__google_integration_title' => 'Integracja z usługami Google',
    'promo__google_integration' => 'Skonfiguruj integrację z usługami Google, takimi jak AdSense, Google Apps, narzędzia dla webmasterów.',
    'promo__google_integration_button' => 'Konfiguruj',

    'promo__button_learn_more' => 'Dowiedz się więcej',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Możesz personalizować wygląd interfejsu i ustawienia marki za pomocą motywów niestandardowych. Aby uzyskać instrukcje dotyczące dostosowywania motywów Plesk, należy odnieść się do %1.',
    'panel_branding__description_link' => 'następujący dokument',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Wypakuj pliki',
    'b_filemanager__extract' => 'Rozpakuj pliki z wybranych archiwów do bieżącego katalogu. Należy mieć na uwadze, że nazwy plików mogą być wyświetlane nieprawidłowo po ekstrakcji, jeśli zawierają znaki charakterystyczne dla danego państwa.',
    'filemanager_error_extracting_files' => 'Wystąpił błąd podczas rozpakowywania archiwum: %1',
    'filemanager_no_archive_files_specified' => 'Określ, które archiwa chcesz rozpakować.',
    'filemanager_not_zip_archive_specified' => '%1 nie mogą być rozpakowane, nie jest to archiwum w formacie ZIP.',
    'filemanager_files_successfully_extracted' => 'Pliki archiwum zostały rozpakowane.',
    'filemanager_error_file_download' => 'Pobieranie pliku nie powiodło się: %1',
    'filemanager__user_poolgrp' => 'Grupa puli aplikacji',

    'loading' => 'Ładowanie',
    'bt_create_archive' => 'Dodaj do archiwum',
    'filemanager__pack' => "Ścieżka do archiwum: %1",
    'filemanager__archive_name' => 'Nazwa pliku archiwum',
    'filemanager__empty_filename' => 'Proszę wpisać nazwę pliku archiwum.',
    'filemanager_archive_created' => 'Utworzono archiwum.',
    'filemanager_error_creating_archive' => 'Nie udało się utworzyć archiwum: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Ten rekord jest w konflikcie z przyczepionym do tej AAAA rekordem.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Serwer FTP nie obsługuje adresów IPv6)",
    'cmd_dns__glue_dns_record_conflict' => 'Ten rekord jest w konflikcie z przyczepionym do tej strefy rekordem \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Serwer FTP nie obsługuje adresów IPv6)",
    '__ipv6_not_supported' => 'IPv6 nie jest obsługiwane.',
    'mail__ipv6_not_supported' => 'IPv6 nie jest obsługiwane przez serwer poczty.',
    'mail__relay_while_list_ipv6_not_supported' => 'Przekaźnik IPv6 białej listy nie jest obsługiwany przez serwer poczty.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Wartość maski musi być wielokrotnością 16.',
    'mail__ip_or_mask_is_invalid' => 'Adres IP bądź maska są niepoprawne.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Przekierowywanie na adresy IPv6 nie jest obsługiwane.',
    'sa__invalid_trusted_networks' => 'Niewłaściwie określone zaufane sieci: %1',
    'dns_add__enter_ipv6_address' => "Adres Ipv6",
    'license_trial_days_left' => 'Twój Plesk działa na podstawie licencji testowej, która wygaśnie za %1 dni.',
    'excl_ipv6_num' => 'Dedykowany adres IPv6',
    '__ip_mask' => "Maska podsieci",
    '__ipv4_addr' => 'Adres IPv4',
    '__ipv6_addr' => 'Adres IPv6',
    'template__num_excl_ipv6s' => 'Przydziel dedykowane adresy IPv6 sprzedawcy',
    'anonftp__exclusive_ipv4_required' => 'Aby skonfigurować anonimową usługę FTP i jej używać, potrzebny jest dedykowany adres IPv4.',
    'anonftp__ipv4_already_used' => 'Nie możesz skonfigurować anonimowej usługi FTP dla tej strony, ponieważ jest już ona skonfigurowana na innej domenie pod tym samym adresem IPv4.',


    'restart__kav' => "Program antywirusowy Kaspersky",
    '__view_migration_log_detailed_info' => 'Zobacz log',

    'chown__ip_address_warn' => 'Przed przekazaniem subskrypcji nowemu właścicielowi musisz wybrać nowy adres IP dla tej subskrypcji.',
    'chown__no_ip_address' => 'Żaden',
    'chown__no_ipv4_address' => 'Brak adresu IPv4',
    'chown__no_ipv6_address' => 'Brak adresu IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Subskrypcja %1 już należy do użytkownika.',
    'chown__error_ip_absent_in_ip_pool' => 'Adres IP %1 nie jest obecny w puli IP użytkownika docelowego.',
    'chown__error_ip_not_exist' => 'Adres IP o ID \'%1\' nie istnieje.',
    'chown__error_domain_ip_not_selected' => 'Co najmniej jeden adres IP dla domeny %1 powinien być wybrany. Sprawdź wartości wybrane do mapowania IP.',

    '__new_passwd_single' => "Hasło",
    '__confirm_passwd_single' => "Napraw „osieroconego” użytkownika %1",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Adres IPv6 bądź maska są niepoprawne: adres IP powinien być poprawnym adresem typu unicast.',

    '__subscriptions' => 'Subskrypcje',

    '__owned_by_reseller' => 'należy do sprzedawcy',
    '__owned_by_provider' => 'należy do dostawcy',

    'service_plan__anonymous' => 'Personalizuj',
    'subscription_not_locked__change_limits_warning' => 'Ta subskrypcja nie jest zablokowana: ograniczenia wykorzystania zasobów będą zmienione podczas synchronizacji z planem usługi.',
    'subscription_not_locked__change_permissions_warning' => 'Ta subskrypcja nie jest zablokowana: uprawnienia będą zmienione podczas synchronizacji z planem usługi.',

    'subscription__conflict_resolution_policy' => 'Polityka rozwiązywania konfliktów',
    'subscription__conflict_resolution_policy_lock' => "Zablokuj subskrypcję",

    'backup__list__backup_warnings' => 'Ostrzeżenia',
    'backup__list__backup_info' => 'Informacja',
    'backup__restore__object_reseller_template' => 'Szablon sprzedawcy',
    'backup__restore__object_domain_template' => 'Szablon domeny',

    'ui__client/permissions_readonly__title' => 'Uprawnienia',
    'ui__client/permissions_readonly__short-title' => 'Uprawnienia',

    'subscription__unable_lock_anonymous' => 'Ta subskrypcja nie jest powiązana z planem usługi, więc nie może być odblokowana.',
    'subscription__unable_sync_anonymous' => 'Ta subskrypcja nie jest powiązana z planem usługi, więc nie może być zsynchronizowana.',
    'subscription__unable_sync_locked' => 'Ta subskrypcja jest zablokowana i nie może być zsynchronizowana.',
    'subscription__locked' => 'Subskrypcja zablokowana.',
    'component_name__urlrewrite' => "Nadpisywanie URL",
    '__quantity' => 'Llość',
    'hst__www_root_dir_absent' =>  'Uwaga: Katalog określony jako root nie istnieje.',
    'object_creation__domain_is_not_a_webspace' => 'Ten obiekt może być utworzony tylko w subskrypcji.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Subskrypcja zawiera serwisy i dlatego nie możesz zmienić typu hostingu ani jej usunąć.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Błąd: Nie udało się zaktualizować adresu IP. Domenom dodatków nie można przypisać adresu IP nieprzypisanego do domeny głównej subskrypcji.',
    'domain_plan__unable_change' => 'Nie udało się zmienić planu usługi: %1.',
    'domain_plan__different_hosting_type' => 'Obecny typ hostingu różni się od typu określonego w planie usługi.',
    'domain_plan__addon_text' => 'Plan dodatkowy',
    'domain_plan__addon_description' => 'Plan dodatkowy uzupełnia plan hostingu.',
    'asp_net__managed_runtime_version' => 'Zarządzalna wersja uruchomieniowa ASP.NET',
    'plan__can_not_change_hosting_type' => 'Nie można zmienić typu hostingu podczas edycji planu.',
    'plan__apply_problems' => 'Ten plan nie zostanie zastosowany, ponieważ wystapiły problemy z funkcjonalnością: %1',
    'plan_save__subscription_update_problem' => 'Nie udało się zastosować zmian w planie %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Subskrypcja jest czasowo zawieszona dopóki nie zakończy się proces tworzenia kopii zapasowej lub proces przywracania. Proszę wrócić później.",
    'mail__whitenet_exists' => "Biała lista z prefiksem %1 już istnieje.",
    '__login_incorrect_plain_shadow_password' => 'Podałeś niepoprawne hasło do konta administratora. Proszę użyć innych danych administratora (root) lub odzyskaj poprawne hasło. Aby dowiedzieć się więcej o odzyskiwaniu hasła, przeczytaj plik /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Nie możesz wysłać adresu IP, którego nie jesteś właścicielem',

    'dns__dns_zone_not_synchronized' => 'Strefa DNS została zmieniona. Jeśli chciałbyś zastosować zmiany szablonu DNS do tej strefy, kliknij albo przycisk \'Zastosuj zmiany szablonu DNS\' na tej stronie lub wybierz opcję \'Zastosuj zmiany do wszystkich stref\' w Panelu administracji serwera > Narzędzia i ustawienia > Ustawienia szablonu DNS > Zastosuj zmiany szablonu DNS.',
    'dns__dns_zone_synchronize_link' => 'Kliknij',
    'dns__dns_zone_synchronize_done' => 'Strefa DNS została zaktualizowna.',

    'dns__dns_zone_template_not_synchronized' => 'Szablon strefy DNS został zmieniony i zostanie zastosowany do wszystkich nowo utworzonych domen. Możesz także %1.',
    'dns__dns_zone_soa_template_not_synchronized' => 'Szablon SOA został zmieniony i zostanie zastosowany do wszystkich nowo utworzonych domen. Możesz także %1.',
    'dns__dns_zone_template_synchronize_link' => 'zastosuj zmiany we wszystkich hostowanych domenach',
    'dns__dns_zone_template_error_details' => 'Szczegóły',
    'dns__dns_zone_template_error' => 'Wystąpiły problemy z synchronizacją stref DNS z szablonem strefy DNS.%1',

    'dns__soa_rname_type_owner' => 'Adres e-mail właściciela witryny',
    'dns__soa_rname_type_domain' => 'Adres e-mail domeny',
    'dns__soa_rname_type_external' => 'Zewnętrzny adres e-mail',
    'dns__soa_rname_enforce_email' => 'Zabroń zmiany adresu e-mail RNAME dla poszczególnych domen',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'Adres e-mail osoby odpowiedzialnej za strefę DNS domeny. Zwrócony przez serwer DNS w odpowiedzi na zapytania SOA.',

    'dns__dns_zone_soa_sync_title' => 'Zastąp ustawienia SOA dla wszystkich istniejących domen',
    'dns__dns_zone_soa_sync_legend' => 'Wymagane potwierdzenie',
    'dns__dns_zone_soa_sync_text' => 'Zaktualizować rekordy SOA wszystkich hostowanych domen, stosując zmiany wprowadzone do szablonu SOA?',

    'cu_db__repair_mysql_dbus' => "Napraw hasła użytkowników MySQL. Ta operacja jest konieczna, jeśli przeniosłeś się do Plesk 11 z wcześniejszych wersji.",

    'scheduled_backup_settings__start_at_hint' => 'Przerwa na sprawdzenie dla zaplanowanej kopii zapasowej trwa 15 minut. Jeśli chcesz, by Plesk rozpoczął proces tworzenia kopii zapasowej w określonym czasie, ustaw czas rozpoczęcia tego zadania minimum 15 minut wcześniej, niż czas oczekiwanego startu.',
    'cu_scheduled_backup_comment' => 'Zaplanowane kopie zapasowe',
    'cu_scheduled_backup_error' => 'Wystąpił błąd podczas procesu tworzenia kopii zapasowej: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Wystąpił błąd podczas zaplanowanej kopii zapasowej.',
    'cu_scheduled_backup_mail_message' => "%1\nPunkt wejścia do Pleska: %2\n\nPodczas zaplanowanego procesu tworzenia kopii zapasowej wystąpiły następujące błędy:\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => 'Zaplanowana kopia zapasowa. Cała konfiguracja i zawartość.',
    'cu_scheduled_backup_comment_backup_vhost' => 'Zaplanowana kopia zapasowa. Cała konfiguracja i treść oprócz poczty.',
    'cu_scheduled_backup_comment_backup_mail' => 'Zaplanowana kopia zapasowa. Tylko konfiguracja poczty i zawartość.',
    'cu_scheduled_backup_comment_backup_domain' => 'Zaplanowana kopia zapasowa. Konfiguracja domeny.',
    'cu_scheduled_backup_to_cloud_not_allowed' => 'Przechowywanie zaplanowanych kopii zapasowych w zdalnym magazynie w chmurze to funkcja premium. Skontaktuj się z dostawcą usług hostingowych, aby ją odblokować.',

    'i_backup_invalid_file' => 'To nie jest właściwa kopia zapasowa. Dane mogą być przywrócone z tego pliku. Kliknij na nazwę kopii zapasowej, aby zobaczyć szczegóły.',

    'ui__server/migration/download-agent__short-title' => 'Pobierz Agenta migracji i transferu (Migration & Transfer Agent)',
    'ui__server/migration/download-agent__title' => 'Pobierz Agenta migracji i transferu (Migration & Transfer Agent)',
    'ui__server/migration/download-agent__description' => 'Pobierz najnowszą wersję Migration & Transfer Agent z serwisu WWW Plesk.',

    'filemanager_resulting_archive_exists' => 'Plik %1 już istnieje w katalogu docelowym.',

    'agent_unable_to_connect' => 'Nie udało się połączyć z agentem na \'%2\'. Upewnij się, że agent jest zainstalowany i że działa i że nie ma problemów z połączeniem z hostem \'%2\'.',
    'agent_test_connection_failed' => 'Połączenie z agentem na \'%2\' nie udało się.',

    'agent_unable_to_resolve_host' => 'Nie można zlokalizować zdalnego hosta \'%1\'. Upewnij się, że nie ma problemów z połączeniem z hostem.',
    'agent_unknown_curl_error' => 'Pojawił się błąd \'%1\' podczas połączenia z agentem na \'%2\'.',
    'agent_unexpected_htp_code' => 'Otrzymano niespodziewany kod HTTP \'%1\' w odpowiedzi na żądanie HTTP do agenta na \'%2\'.',
    'agent_unable_to_auth' => 'Nie można autentykować na hoście \'%1\'. Aby rozwiązać ten problem, wykonaj działania opisane tutaj: http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Napotkano wewnętrzny błąd serwera podczas wykonywania komendy na zdalnym hoście \'%1\'.',
    'agent_response_is_empty' => 'Otrzymano pustą odpowiedź na żądanie HTTP do agenta na \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Nie udało się znaleźć Agenta migracji i transferu w lokalnym schowku. Proszę ponownie otworzyć Menedżer migracji i transferu, aby naprawić problem.',

    '__hosting_webdeploy' => "Publikacja Web Deploy",
    'cu_domain__webdeploy' => "Publikacja Web Deploy (domyślny: %1)",
    'cu_dom_tpl__webdeploy' => "Publikacja Web Deploy (domyślny: %1)",
    'cu_subdomain__webdeploy' => "Publikacja Web Deploy (domyślny: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy nie jest zainstalowane na tym serwerze",
    'webdeploy__forced_by_site_isolation' => "Nie udało się zmienić ustawień publikacji Web Deploy: nie masz uprawnień do nadpisywania globalnego regulaminu bezpieczeństwa serwera. Aby uzyskać szczegóły, skontaktuj się z dostawcą.",



    'backup__restore_options__admin__server_configuration_license' => 'Klucz licencji',
    'migration_start_migrate_server_license' => 'Klucz licencyjny transferu',

    'defaultcomponents__delegation_rule_not_exist' => '(wymagana reguła delegacji \'appPoolPipeline, appPoolNetFx\' nie istnieje)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Kopia zapasowa została utworzona przez administratora.',
    'i_backup_created_by_reseller' => 'Kopia zapasowa została utworzona przez sprzedawcę.',
    'i_backup_created_by_client' => 'Kopia zapasowa została utworzona przez klienta.',

    'migration__object_exists_on_target_host' => '(już istnieje na docelowym hoście)',

    '__customers_total' => 'Suma według klientów',
    '__resellers_total' => 'Suma według sprzedawców',
    '__reseller_total' => 'Suma sprzedawców',


    'cu__mailserver_update_webmail_command' => "Określa klienta poczty webowej, którego chesz zablokować lub odblokować",
    'cu__mailserver_webmail_state' => "Określa stan wybranego klienta poczty webowej (prawda odblokowuje kllienta, fałsz blokuje klienta)",

    'cu_db_set_default_user' => 'Uczyć określonego użytkownika domyślnym dla bazy danych. Opcja jest używana z komendami: add_user, update_user',

    'cu_role__opt_subscription_name' => 'Zezwalaj użytkownikom na dostęp tylko do określonej subskrypcji',
    'cu_role__opt_for_all_subscription' => 'Zewalaj użytkownikom na dostęp do wszystkich subskrypcji w obrębie konta hostingowego',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Nie udało się zastosować zmian do roli: Nie znaleziono subskrypcji %1.',

    'cu_cl_pref__manage_website_maintenance' => 'Dostęp do zaawansowanych operacji: Kopiowanie strony',
    'cu_cl_pref__manage_protected_dirs' => 'Zarządzanie katalogami zabezpieczonymi hasłem',
    'cu_cl_pref__manage_mail_settings' => 'Możliwość zmiany ustawień poczty',


    'cu__command_update_php_settings' => 'Aktualizacja ustawień PHP.',
    'cu__php_settings_option' => 'Ustawia ścieżkę do pliku z dodatkowymi ustawieniami PHP.',

    'cu__additional_php_settings_option' => 'Ustawia ścieżkę do pliku z dodatkowymi dyrektywami PHP.',
    'cu__command_show_php_settings' => 'Wyświetla obecne ustawienia PHP.',
    'cu__general_settings' => 'Ustawienia główne:',
    'cu__performance_settings' => 'Ustawienia wydajności:',
    'cu__php_fpm_settings' => 'Ustawienia PHP-FPM:',
    'cu__additional_directives' => 'Dodatkowe dyrektywy:',

    'b_filemanager__pack' => 'Dodaj wybrane pliki do archiwum.',

    'php_settings_permission_required' => 'Zarządzanie powszechnymi ustawieniami PHP',
    'php_settings_performance_permission_required' => 'Zarządzanie ustawieniami wydajności hostingu',
    'php_settings_customized' => 'Spersonalizowano ustawienia PHP.',
    'php_settings_synchronized_with_plan' => 'Ustawienia PHP muszą być zsynchronizowane z planem.',
    'phosting__unknown_shell_type' => 'Niedostępna powłoka',

    'login_up__access_denied_subscription_deleted' => 'Dostęp zabroniony: Twoja subskrypcja została usunięta.',

    'role_restricted_to_subscription' => '(przeniesiony wraz z subskrypcją: %1)',

    'filemanager__extract' => "Wypakuj pliki do: %1",

    'cu__license_command_check_installed_license' => 'Sprawdź ważność zainstalowanego klucza licencyjnego (zwraca kod wyjściowy 0, jeśli klucz jest ważny i 1, jeśli klucz jest nieważny)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Rozszerz funkcjonalność Plesku, aby móc kontrolować i monitorować serwer z urządzeń mobilnych (BlackBerry, iPhone'a i Androida).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Zdobądź najwazniejsze informacje o serwerach Plesku zawsze i wszędzie z urządzeń mobilnych (BlackBerry, iPhone\'a i Androida).',
    'promo__mobile_button' => 'Dowiedz się więcej',

    'ui__server/migration/video__short-title' => 'Tutoriale wideo',
    'ui__server/migration/video__title' => 'Oglądaj tutoriale wideo',
    'ui__server/migration/video__description' => 'Oglądaj tutoriale wideo.',

    'auto_install_updates_moved_to_separate_page' => 'Skonfiguruj zasady aktualizacji',

    '__system_preferences' => 'Ustawienia Systemu',
    'subDomainNameHint' => 'Wpisz * jako nazwę poddomeny, aby utworzyć poddomenę jako dziką kartę. Odwiedzający serwis będą przekierowania do tej poddomeny bez względu na wpisaną w przeglądarce nazwę poddomeny.',
    'subdomains__wildcard_name_invalid' => "Nazwa poddomeny jest niepoprawna. Mozesz użyć znaków alfanumerycznych, myślnika (-), gwiazdki (*) dla nazw poddomen jako dzikich kart.",
    'subdomains__name_invalid' => "Nazwa poddomeny jest niepoprawna. Mozesz użyć znaków alfanumerycznych e myślnika (-) dla nazw poddomen.",

    'domain__wildcard_no_www_prefix' => 'Nie można użyć prefisku www dla poddomen na prawach dzikiej karty.',

    '__service_title__milter' => "Filtr poczty Plesk Postfix (milter)",
    '__service_description__milter' => "Filtr poczty Plesk Postfix",
    '__milter' => "Filtr poczty Postfix (milter)",
    'restart__milter' => "Filtr poczty Plesk (milter) (%1)",
    'restart__pop3' => "Serwer courier POP3",
    'restart__pop3s' => "Serwer courier POP3 z obsługą SSL/TLS",
    'restart__imap' => "Serwer Courier IMAP",
    'restart__imaps' => "Serwer courier IMAP z obsługą SSL/TLS",
    'restart__authdaemon' => "Courier IMAP daemon autentykacji",
    'restart__imap-pop3' => "Serwery Dovecot IMAP i POP3",


    'addon_packages_not_supported' => 'Dodatki do pakietu APS aplikacji sieciowych nie są obsługiwane.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Nie udało się automatycznie przypisać adresu IP do domeny. Proszę określić adres IP używając opcji -ip.',

    'plesk_key__mb_accounts' => 'Konta użytkowników (sprzedawców i klientów) w Menedżerze Klienta i Biznesu',

    'actionlog__subdomain_dns' => 'Strefa DNS poddomeny',
    'actionlog__site_subdomain_dns' => 'Strefa DNS poddomeny pod dodatkową domeną',

    // PfW only
    'actionlog__event_site_create' => 'Utworzono domenę',
    'actionlog__event_site_delete' => 'Usunięto domenę',
    'actionlog__event_site_update' => 'Zaktualizowano domenę',

    'actionlog__event_site_status_update' => 'Zaktualizowano status domeny',
    'actionlog__event_site_dns_update' => 'Zaktualizowano strefę DNS domeny',
    'actionlog__event_site_guid_update' => 'Zaktualizowano GUID domeny',

    'actionlog__event_site_subdomain_create' => 'Utworzono subdomenę',
    'actionlog__event_site_subdomain_delete' => 'Usunięto subdomenę',
    'actionlog__event_site_subdomain_update' => 'Zaktualizowano subdomenę',

    'actionlog__event_site_alias_create' => 'Utworzono alias domeny',
    'actionlog__event_site_alias_delete' => 'Usunięto alias domeny',
    'actionlog__event_site_alias_update' => 'Zaktualizowano alias domeny',

    'actionlog__event_site_alias_dns_update' => 'Zaktualizowano strefę DNS lub alias domeny',
    'actionlog__event_subdomain_dns_update' => 'Zaktualizowano strefę DNS poddomeny pod domeną domyślną',
    'actionlog__event_site_subdomain_dns_update' => 'Zaktualizowano strefę DNS aliasu domeny',
    // End of PfW only

    'win_policy__bad_password' => 'Uwierzytelnianie nieudane. Hasło jest niepoprawne.',
    'win_policy__password_too_short' => 'Uwierzytelnianie nieudane. Hasło nie spełnia warunków określanych w wymaganiach wobec haseł, ponieważ jest zbyt krótkie.',
    'win_policy__password_too_long' => 'Uwierzytelnianie nieudane. Hasło nie spełnia warunków określanych w wymaganiach wobec haseł, ponieważ jest zbyt długie.',
    'win_policy__password_not_complex_enough' => 'Weryfikacja nie powiodła się. Hasło nie jest wystarczająco złożone i nie spełnia wymagań polityki haseł. Silne hasła muszą zawierać wszystkie z następujących elementów: osiem znaków; jedna wielka lub mała litera; trzy cyfry i jeden znak specjalny (!, @, #, $,%, ^, &, *,?, _, ~) lub jedna liczba i dwa znaki specjalne.',

    //// Activation Code feature
    'key__tabs_activation' => 'Aktywacja klucza licencji',
    'key__description' => 'Tutaj możesz zainstalować swój klucz licencyjny poprzez wpisanie kodu aktywacyjnego lub poprzez wgranie pliku klucza licencyjnego.',
    'key__description_code_only' => 'Tutaj możesz zainstalować swój klucz licencyjny, wprowadzając kod aktywacyjny.',
    'key__license_key' => 'Wybierz jeden z poniższych:',
    'key__code_text' => 'Wpisz kod aktywacyjny',
    'key__code_hint' => 'Wklej kod aktywacyjny, który otrzymałeś.',
    'key__file_text' => 'Wgraj plik klucza licencyjnego',
    'key__file_hint' => 'Określ ścieżkę do pliku zawierającego klucz licencyjny.',
    'plesk_key__code_check_wrong' => 'Ten kod aktywacyjny jest niepoprawny.',
    'plesk_key__license_update_failed' => 'Nie można zaktualizować licencji produktu.',


    'filemanager__error_path_is_not_allowed' => 'Ścieżka dostępu jest niedozwolona',
    'filemanager__error_path_is_invalid' => 'Ścieżka dostępu jest nieprawidłowa',
    'filemanager__error_path_not_found' => 'Nie znaleziono ścieżki dostępu',
    'filemanager__error_path_already_exists' => 'Ścieżka dostępu już istnieje',
    'filemanager__error_access_is_denied' => 'Dostęp niemożliwy',
    'filemanager__error_directory_not_empty' => 'Katalog nie jest pusty',
    'filemanager__error_sharing_violation' => 'Naruszenie zasad współdzielenia',
    'filemanager__error_not_same_device' => 'Ścieżka dostępu nie jest na tej samie maszynie',
    'filemanager__binary_data_access' => 'Ten plik może być plikiem binarnym. Otworzyć mimo to?',
    'filemanager__unable_to_resolve_realpath' => "Nie znaleziono pliku %1 w podanej lokalizacji",
    'filemanager__access_to_realpath_denied' => "Dostęp do realpath jest zabroniony: %1 do %2.",
    'bt_exit' => 'Wyjście',

    'filemanager__chdir_error__' => "Nie można przejść do katalogu %1: %2",
    'filemanager__chmod_dir' => "Zmień uprawnienia dla katalogu %1",
    'filemanager__chmod_error__' => "Nie można zmienić uprawnień dla pliku %1: %2",
    'filemanager__chmod_file' => "Zmień uprawnienia dla pliku %1",
    'filemanager__copy_error__' => "Nie można skopiować %1 do %2: %3",
    'filemanager__copy_move' => "Kopiuj (przenieś) pliki z %1",
    'filemanager__count_size__' => 'Rozmiar zaznaczenia: %1',
    'filemanager__count_size_error__' => 'Nie można obliczyć rozmiaru %1: %2',
    'filemanager__create_dir' => "Tworzenie nowego katalogu",
    'filemanager__create_dir_error__' => "Nie można utworzyć katalogu %1: %2",
    'filemanager__dir_not_exists' => "Katalog %1 nie istnieje.",
    'filemanager__dirname' => "Nazwa katalogu",
    'filemanager__filename' => "Nazwa pliku",
    'filemanager__is_no_such' => "Nie ma pliku lub katalogu o nazwie %1",
    'filemanager__empty_selection' => "Nie wybrano pliku(ów).",
    'filemanager__file_exists' => "Plik %1 już istnieje.",
    'filemanager__move_error__' => "Nie można przenieść %1 do %2: %3",
    'filemanager__new_dir' => "Nazwa katalogu",
    'filemanager__not_allowed' => "Nie możesz zmieniać uprawnień dla tego pliku.",
    'filemanager__r_perm_dir' => "Zawartość katalogu",
    'filemanager__r_perm_file' => "Czytaj dane",
    'filemanager__remove' => "Usuń pliki z %1",
    'filemanager__remove_error__' => "Nie można usunąć pliku %1: %2",
    'filemanager__rename_dir' => "Zmień nazwę katalogu %1",
    'filemanager__rename_error__' => "Nie można zmienić nazwy z %1 na %2: %3",
    'filemanager__rename_file' => "Zmień nazwę pliku %1",
    'filemanager__set_win_permissions_dir' => "Ustaw uprawnienia dla katalogu %1",
    'filemanager__set_win_permissions_file' => "Ustaw uprawnienia dla pliku %1",
    'filemanager__touch_confirm' => "Czy jesteś pewien, że chcesz zmienić oznaczenia czasu dla wybranych plików?",
    'filemanager__no_perms_or_unsupported_file_type' => 'Nie można odczytać pliku, lub jego format jest niepoprawny.',
    'filemanager__upload_error__' => "Nie można wgrać %1 do %2: %3",
    'filemanager__upload_file' => "Wgraj plik",
    'filemanager__upload_file_src' => "Źródło pliku",
    'filemanager__username' => "Użytkownik",
    'filemanager__w_perm_dir' => "Stwórz pliki",
    'filemanager__w_perm_file' => "Zapisz dane",
    'filemanager__x_perm_dir' => "Przeglądaj katalog",
    'filemanager__x_perm_file' => "Uruchom plik",
    'filemanager__max_image_size_exceeded' => 'Nie udało się wyświetlić obrazu. Rozmiar obrazu nie może być większy niż %2 bajtów',

    '__fastcgi_unix_support' => 'Obsługa FastCGI',

    'ts_sessions_list' => 'Ta strona pokazuje listę wszystkich sesji Usługi Terminala.',
    'b_tssessionslist_search' => 'Wyniki sesje według nazwy.',
    'b_tssessionslist_show_all' => 'Pokaż wszystkie sesje usług terminalowych.',
    'l_tssessionslist_state' => 'Sortuj po stanie.',
    'l_tssessionslist_name' => 'Sortuj względem nazwy.',
    'l_tssessionslist_user' => 'Sortuj po użytkowniku.',
    'b_tssessionslist_logoff' => 'Kliknij by wylogować wybrane sesje.',
    'b_tssessionslist_disconnect' => 'Kliknij by odłączyć wybrane sesje.',
    'tssessions_info' => 'Pokazuje właściwości sesji.',
    'tssessions_disconnect' => 'Wybierz opcję Potwierdź usunięcie i kliknij OK aby odłączyć wybrane sesje TS.',
    'tssessions_logoff' => 'Zaznacz checkbox Potwierdzenia Usuwania i kliknij OK aby wylogować zaznaczoną sesję serwera.',
    'b_tssession_disconnect_submit' => 'Kliknij, aby zapamiętać wprowadzone zmiany.',
    'b_tssession_logoff' => 'Kliknij, aby wylogować sesję.',
    'b_tssession_logoff_submit' => 'Kliknij, aby zapamiętać wprowadzone zmiany.',
    'i_tssession_active' => 'Aktywne',
    'i_tssession_connected' => 'Podłączony',
    'i_tssession_disconnected' => 'Odłączony',
    'i_tssession_listen' => 'Słuchaj',
    'tssessions__tssessionslist' => 'Sesje',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => 'Nazwa',
    'tssessionslist__user' => 'Użytkownik',
    'bt_logoff_selected' => 'Wyloguj się',
    'bt_logoff' => "Wyloguj się",
    'bt_disconnect_selected' => 'Rozłącz',
    'bt_tssession_logoff' => 'Wyloguj się',
    'bt_tssession_disconnect' => 'Rozłącz',
    'bt_tssession_disconect' => 'Rozłącz',
    'b_tssession_disconnect' => 'Kliknij, aby rozłączyć sesję.',
    'b_tssession_logoff_disabled' => 'Nie udało sie wylogować z sesji.',
    'b_tssession_disconnect_disabled' => 'Nie udało się rozłączyć sesji.',
    'tssessions_info__title' => 'Właściwości sesji %1',
    'tssessions_info__property_name' => 'Nazwa właściwości',
    'tssessions_info__property_value' => 'Wartość własności',
    'tssessions__disconnect_title' => 'Następujące sesje terminala zostaną zakończone',
    'tssessions__session_cant_disconnect' => 'sesja nie może być odłączona',
    'tssessions__logoff_title' => 'Następujące sesje Usługi Terminala zostaną wylogowane:',
    'tssessions__session_cant_logoff' => 'sesja nie może być wylogowana',
    'tssessions__select_sessions_to_logoff' => 'Proszę wybrać sesje do wylogowania.',
    'tssessions__select_sessions_to_disconnect' => 'Proszę wybrać sesje do odłączenia.',
    'dns__subdomain_dns_zone_parent' => 'Rekordy DNS tej poddomeny są przechowywane w nadrzędnej strefie DNS. Możesz modyfikować nadrzędną strefę %1 lub utworzyć oddzielną strefę dla tej poddomeny.',
    'dns__subdomain_dns_zone_parent_link' => 'tutaj',
    'dns__no_dns_zone' => 'Brak stref DNS przypisanych do domeny. Aby zarządzać strefą DNS dla domeny, musisz wcisnąć przycisk \'Przywróć domyślne\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Nie udało się włączyć strefy poddomeny, ponieważ istnieje rekord CNAME dla tej poddomeny w strefie domeny nadrzędnej.',

    '__hosting_write_modify' => 'Dodatkowe uprawnienia zapisu/modyfikacji',


    'aspdotnet__title' => "Konfiguracja Serwera ASP.NET",
    'aspdotnet__dom_title' => "Konfiguracja ASP.NET dla Domeny",
    'aspdotnet__wdir_title' => "Konfiguracja ASP.NET dla Katalogu Sieciowego %1",
    'aspdotnet__group_cas_settings' => "Bezpieczeństwo Kodu Dostępu",
    'aspdotnet__group_client_scripts' => "Ustawienia Biblioteki Skryptów",
    'aspdotnet__group_conn_strings' => "Manager Ciągów Połączeń",
    'aspdotnet__group_custom_errors' => "Własne Ustawienia Błędów",
    'aspdotnet__group_framework_version' => "Wersja Frameworku",
    'aspdotnet__group_globalization' => "Ustawienia Globalne",
    'aspdotnet__group_other' => "Ustawienia sesji",
    'aspdotnet__group_page_and_runtime' => "Kompilacja i Testy",
    'aspdotnet__invalid_dom_config_file' => "Plik konfiguracyjny ASP.NET dla tej domeny jest uszkodzony. Domyślne ustawienia mogą być przywrócone po kliknięciu w przycisk Ustaw Domyślne.",
    'aspdotnet__invalid_file_enc' => "Błędna wartość dla parametru kodowania Pliku.",
    'aspdotnet__invalid_req_enc' => "Błędna wartość dla parametru kodowania Zapytania.",
    'aspdotnet__invalid_res_enc' => "Błędna wartość dla parametru kodowania Odpowiedzi.",
    'aspdotnet__invalid_parent_wdir_config_file' => "Plik konfiguracji ASP.NET jest uszkodzony w wyniku zniszczeń w konfiguracji w katalogu bazowym %1. \nAby rozwiązać ten problem, przywróć konfigurację %1 ASP.NET.",
    'aspdotnet__invalid_global_config_file_admin' => "Konfiguracja ASP.NET jest uszkodzona w wyniku zniszczenia pliku konfiguracji serwera ASP.NET.",
    'aspdotnet__invalid_global_config_file' => "Konfiguracja ASP.NET jest uszkodzona w wyniku zniszczenia pliku konfiguracji serwera ASP.NET. Skontaktuj się z dostawcą usług.",
    'aspdotnet__invalid_sess_timeout' => "Błędna wartość dla parametru wygaśnięcia czasu sesji. Podaj dodatnią liczbę mniejszą lub równą niż %1.",
    'aspdotnet__invalid_wdir_config_file' => "Plik konfiguracji ASP.NET dla tego katalogu sieciowego jest uszkodzony. Aby go przywrócić, zastosuj w stosunku do niego konfigurację ASP.NET katalogu bazowego klikając Ustaw Domyślne.",
    'aspdotnet__param_auth_mode' => "Tryb autentykacji",
    'aspdotnet__param_conn_strings' => "Ciągi połączenia",
    'aspdotnet__param_conn_string_name' => "Nazwa",
    'aspdotnet__param_conn_string_value' => "Parametry Połączenia",
    'aspdotnet__param_culture' => "Kultura",
    'aspdotnet__param_custom_err_mode' => "Tryb własnych błędów",
    'aspdotnet__param_custom_error_redirect' => "URL przekierowania",
    'aspdotnet__param_custom_error_status' => "Kod Statusu",
    'aspdotnet__param_custom_errors' => "Własne błędy",
    'aspdotnet__param_debug_mode' => "Przełącz na debugowanie",
    'aspdotnet__param_def_language' => "Domyślny język strony",
    'aspdotnet__param_temp_directory' => "Katalog tymczasowy",
    'aspdotnet__param_file_enc' => "Kodowanie pliku",
    'aspdotnet__param_req_enc' => "kodowanie zapytania",
    'aspdotnet__param_res_enc' => "Kodowanie odpowiedzi",
    'aspdotnet__param_sess_timeout' => "Przekroczony czas sesji (minuty)",
    'aspdotnet__param_trust_level' => "Poziom zaufania CAS",
    'aspdotnet__param_ui_culture' => "Kultura UI",
    'aspdotnet__param_version' => "Wersja",
    'aspdotnet__param_trust_level_allow_override' => 'Pozwala na zmianę poziomu zaufania CAS pojedynczym serwisom WWW',
    'aspdotnet__restore_default_confirm' => "Przywrócić domyślne ustawienia ASP.NET?",

    'bt_restore_default' => "Ustaw na Domyślne",
    'b_aspdotnet' => 'Edytuj konfigurację ustawień ASP.NET.',
    'b_aspdotnet__restore_default' => 'Przywrócić domyślne ustawienia ASP.NET.',
    'b_aspdotnet__restore_wdir_default' => "Przywróć ustawienia katalogu bazowego ASP.NET dla tego katalogu sieciowego.",
    'b_aspdotnet__restore_default_disabled' => 'Przywracanie domyślnej konfiguracji ASP.NET jest niedostępne: konfiguracja ASP.NET jest uszkodzona, albo na poziomie serwera albo katalogu bazowego.',
    'b_autoinstaller' => 'Aktualizuj Plesk lub jego komponenty.',
    'b_autoinstaller_configure' => 'Ustawienia aktualizacji.',
    'b_autoinstaller_install' => 'Instaluj wybrane komponenty.',

    '__iis_app_pool__use_dedicated' => 'Pakiet aplikacji dedykowanych IIS',
    '__iis_app_pool__use_dedicated_addons' => 'Dedykowana pula aplikacji IIS dla każdego serwisu WWW',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Włącz aplikacje 32-bitowe',
    'bt_iis_app_pool' => "Pula aplikacji IIS",

    'performance__cpu_usage' => 'Maksymalne zużycie procesora (%)',
    'performance__cpu_usage_action' => 'Limit działań',
    'performance__cpu_usage_interval' => 'Limit interwału (minuty)',
    'performance__cpu_usage_action_not_supported' => 'Podane działanie nie jest obsługiwnae przez serwer WWW.',

    'performance__idle_timeout_action_not_supported' => 'Podany czas bezczynności nie jest obsługiwany przez serwer WWW.',
    'performance__max_worker_processes' => 'Maksymalna liczba procesów',
    'performance__idle_timeout' => 'Limit czasu bezczynności (minuty)',
    'performance__idle_timeout_action' => 'Działanie limitu czasu bezczynności',
    'performance__recycling_by_time' => 'Ponowne wykorzystanie w regularnych odstępach czasu (minuty)',
    'performance__recycling_by_requests' => 'Ponowne wykorzystanie, kiedy maksymalna liczba żądań zostanie osiągnięta',
    'performance__recycling_by_virtual_memory' => 'Ponowne wykorzystanie, kiedy maksymalna ilość pamięci wirtualnej zostanie wykorzystana',
    'performance__recycling_by_private_memory' => 'Ponowne wykorzystanie, kiedy maksymalna ilość pamięci prywatnej zostanie wykorzystana',
    'performance__managed_pipeline_mode' => 'Zarządzaj trybem potokowości',
    'performance__managed_pipeline_mode_not_supported' => 'Określony tryb nie jest obsługiwany przez serwer WWW.',

    'iis_app_pool' => 'Zarządzanie kolejką aplikacji IIS.',
    'b_iis_app_pool' => 'Zarządza pulą aplikacji IIS.',
    'iis_app_pool_cl_dom' => 'Zarządzanie kolejką aplikacji IIS.',

    'i_webdirs_not_protected' => 'Katalog nie jest chroniony.',
    'i_webdirs_protected' => 'Katalog jest chroniony.',
    'i_webdirs_manage_protection' => 'Kliknij, aby zarządzać ochroną.',
    'i_webdirs_open' => 'Otwórz w przeglądarce.',
    'i_webdirs_preferences_disabled' => 'Ten katalog nie jest wirtualnym katalogiem.',
    'i_webdirs_permissions' => 'Kliknij, aby zarządzać prawami.',
    'i_webdirs_permissions_disabled' => 'Zarządzanie prawami dostępu do katalogów sieciowych jest niedostępne.',
    'i_webdirs_type_dir' => 'Katalog fizyczny',
    'i_webdirs_type_vdir' => 'Wirtualny katalog',
    'i_webdirs_browse' => 'Kliknij, aby przeglądać zawartość katalogu.',
    'i_webdirs_preferences' => 'Zarządzaj preferencjami katalogu www.',

    'l_webdirslist_type' => 'Sortuj katalogi www według typu.',
    'l_webdirslist_protected' => 'Sortuj katalogi www według statusu ochrony.',
    'l_webdirslist_name' => 'Sortuj katalogi www według nazwy.',

    'b_webdirslist_remove' => 'Skasuj zaznaczone katalogi wirtualne.',
    'b_webdirslist_search' => 'Wprowadź wzór i kliknij, by znaleźć wirtualne katalogi.',
    'b_webdirslist_show_all' => 'Pokaż wszystkie katalogi www.',

    'l_webdirerrordocslist_code' => 'Sortuj dokumenty błędów według numeru błędu.',
    'l_webdirerrordocslist_name' => 'Sortuj dokumenty błędów według opisu.',
    'l_webdirerrordocslist_type' => 'Sortuj dokumenty błędów według typu.',
    'l_webdirerrordocslist_location' => 'Sortuj dokumenty błędów według lokalizacji.',

    'b_webdirerrordocslist_search' => 'Wpisz wzorzec i kliknij, aby znaleźć dokumenty błędów.',
    'b_webdirerrordocslist_remove' => 'Usuń wybrane dokumenty błędów.',
    'b_webdirerrordocslist_show_all' => 'Pokaż wszystkie dokumenty błędów.',

    'l_webdirmimetypeslist_name' => 'Sortuj typy MIME według rozszerzenia.',
    'l_webdirmimetypeslist_content' => 'Sortuj typy MIME według treści.',

    'b_webdirmimetypeslist_remove' => 'Usuń wybrane typy MIME.',
    'b_webdirmimetypeslist_search' => 'Wpisz wzorzec i kliknij by szukać typów MIME.',
    'b_webdirmimetypeslist_show_all' => 'Pokaż wszystkie typy MIME.',

    'b_webdir_preferences' => "Preferencje katalogu www.",
    'b_webdir_permissions' => "Prawa katalogu www.",
    'b_webdir_permissions_disabled' => "Zarządzanie prawami dostępu do katalogów sieciowych jest niedostępne.",
    'b_to_webdirs' => 'Powrót do strony katalogów www.',
    'b_to_webdir_mime_types' => 'Powrót do strony zarządzania typami MIME katalogu www.',
    'b_to_webdir_error_docs' => 'Powrót do strony zarządzania dokumentami błędów katalogu www.',
    'b_to_webdir_protection' => 'Powrót do strony zarządzania ochroną katalogu www.',

    'webdirs__title' => 'Katalog web %1',
    'webdirs__preferences_title' => 'Ustawienia Katalogu Web',
    'webdirs__list_legend' => 'Katalogi web',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Nazwa',
    'webdirs__list_header' => '%1 obiektów',
    'webdirs__tabs_general' => 'Ogólny',
    'webdirs__tabs_mime_types' => 'Typy MIME',
    'webdirs__tabs_error_docs' => 'Dokumenty błędów',

    'webdirs__tabs_permissions' => 'Uprawnienia',
    'webdir__remove_vdirs' => 'Następujące katalogi web zostaną usunięte:',
    'webdir__remove_mime_types' => 'Następujące typy MIME zostaną usunięte:',
    'webdir__mime_types_title' => 'Typy MIME',
    'webdir__protection_disable_confirm' => 'Czy na pewno chcesz usunąć ochronę z katalogu?',
    'webdir__protect_title' => 'Użytkownicy chronionego katalogu',
    'webdirs__permissions_title' => 'Prawa katalogu web',
    'webdirs__browse_content_permission_denied' => 'Nie masz uprawnień do oglądania zawartości tego katalogu.',
    'error_doc__list_code' => 'Błąd',
    'error_doc__list_code_description' => 'Opis',
    'error_doc__list_type' => 'Typ',
    'error_doc__list_location' => 'Lokalizacja',
    'error_doc__code' => 'Błąd',
    'error_doc__type' => 'Typ',
    'error_doc__type_file' => 'Plik',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Lokalizacja',
    'error_doc__legend' => 'Dokument Błędu',
    'error_doc__edit_title' => 'Edytuj dokument błędu',
    'error_doc_erorr_invalid_url_location' => 'URL jest nieprawidłowa. Proszę podać poprawne URL.',
    'error_doc_erorr_invalid_file_location' => 'Ścieżka do pliku jest nieprawidłowa. Proszę podać poprawną ścieżkę pliku.',
    'error_doc__type_default' => 'Domyślny',

    'webdirs__tabs_protection' => 'Ochrona',
    'pb_webdirs' => 'Wirtualne katalogi',

    'webdirs_remove_title' => 'Katalogi web zostaną:',
    'webdirs_mime_types_remove_title' => 'Następujące typy MIME zostaną usunięte:',
    'webdirs_preferences_title' => 'Ustawienia Katalogu Web',
    'webdirs_permissions_title' => 'Specjalne Uprawnienia Pliku/Katalogu',
    'webdi_protection_disable_confirm' => 'Czy jesteś pewien, że chcesz usunąć ochronę z wirtualnego katalogu? To również usunie wszystkie chronione katalogi użytkowników ustawienia ochrony folderów.',
    'bt_protect' => 'Chroń',
    'bt_unprotect' => 'Usuń zabezpieczenie',
    'bt_show_additional_users' => 'Pokaż dodatkowych użytkowników',
    'bt_hide_additional_users' => 'Ukryj dodatkowych użytkowników',
    'error_doc__list_title' => 'Dokumenty błędów',
    'error_doc__list_header' => 'Dokumenty błędów',
    'error_doc__code_400' => 'Złe zapytanie',
    'error_doc__code_401' => 'Nieautoryzowane',
    'error_doc__code_401.1' => 'Nieautoryzowane - Logowanie nie powiodło się',
    'error_doc__code_401.2' => 'Nieautoryzowane - Logowanie nie powiodło się z uwagi na konfigurację serwera',
    'error_doc__code_401.3' => 'Nieautoryzowane - z uwagi na ACL za zasobach',
    'error_doc__code_401.4' => 'Nieautoryzowane - Autoryzacja nie powiodła się z uwagi na filtr',
    'error_doc__code_401.5' => 'Nieautoryzowane - Autoryzacja nie powiodła się z uwagi ISAPI/CGI app',
    'error_doc__code_401.7' => 'Nieautoryzowane - Zabronione z uwagi na politykę Autoryzacji Adresów URL',
    'error_doc__code_403' => 'Zabroniono',
    'error_doc__code_403.1' => 'Zabroniono - Brak praw wykonywania',
    'error_doc__code_403.2' => 'Zabroniono - Brak praw odczytu',
    'error_doc__code_403.3' => 'Zabroniono - Brak praw zapisu',
    'error_doc__code_403.4' => 'Zabroniono - Wymagany SSL',
    'error_doc__code_403.5' => 'Zabroniono - Wymagany SSL128',
    'error_doc__code_403.6' => 'Zabroniono - Odrzucono adres IP',
    'error_doc__code_403.7' => 'Zabroniono - Wymagany certyfikat klienta',
    'error_doc__code_403.8' => 'Zabroniono - Brak praw dostępu do strony',
    'error_doc__code_403.9' => 'Zabroniono - Zbyt dużo użytkowników',
    'error_doc__code_403.10' => 'Zabroniono - Błędna konfiguracja',
    'error_doc__code_403.11' => 'Zabroniono - Zmiana hasła',
    'error_doc__code_403.12' => 'Zabroniono - Mapper Odrzucił Dostęp',
    'error_doc__code_403.13' => 'Zabroniono - Certyfikat Klienta odwołany',
    'error_doc__code_403.14' => 'Zabroniono - Odczyt katalogu zabroniony',
    'error_doc__code_403.15' => 'Zabroniono - Przekroczono Licencje dostępu klienta',
    'error_doc__code_403.16' => 'Zabroniono - Certyfikat klienta niezaufany lub źle sformułowany',
    'error_doc__code_403.17' => 'Zabroniono - Certyfikat klienta stracił ważność lub nie jest już poprawny',
    'error_doc__code_403.18' => 'Zabroniono - Nie można wykonać zapytania z tej puli aplikacji',
    'error_doc__code_403.19' => 'Zabroniono - Zabroniony dostęp CGI',
    'error_doc__code_403.20' => 'Zabroniono - Nie powiodło się logowanie',
    'error_doc__code_404' => 'Nie znaleziono',
    'error_doc__code_404.2' => 'Nie znaleziono - Zabroniono z uwagi na politykę Lockdown',
    'error_doc__code_404.3' => 'Nie znaleziono - Zabroniono z uwagi na politykę MIMEMAP',
    'error_doc__code_405' => 'Metoda nie dozwolona',
    'error_doc__code_406' => 'Brak akceptacji',
    'error_doc__code_407' => 'Wymagana Autentykacja Proxy',
    'error_doc__code_412' => 'Warunek wstępny nie powiódł się',
    'error_doc__code_414' => 'Zbyt długi żądanie URI',
    'error_doc__code_415' => 'Nieobsługiwany typ medium',
    'error_doc__code_500' => 'Błąd serwera',
    'error_doc__code_500.12' => 'Błąd serwera - Aplikacja restartuje się',
    'error_doc__code_500.13' => 'Błąd serwera - Serwer zbyt zajęty',
    'error_doc__code_500.15' => 'Błąd serwera - Bezpośrednie odpytania GLOBAL.ASA zabronione',
    'error_doc__code_500.16' => 'Błąd serwera - Błąd Dostępu UNC',
    'error_doc__code_500.17' => 'Błąd serwera - Nie znaleziono miejsca Autoryzacji Adresu URL',
    'error_doc__code_500.18' => 'Błąd serwera - Miejsce Autoryzacji adresu URL nie może być otwarte',
    'error_doc__code_500.19' => 'Błąd serwera - Błędny metadata pliku',
    'error_doc__code_500.100' => 'Błąd serwera - Błąd ASP',
    'error_doc__code_501' => 'Nie zaimplementowano',
    'error_doc__code_502' => 'Błędna Brama',
    'error_doc__code_503' => 'Usługa czasowo niedostępna',

    'mimetype__extension' => 'Rozszerzenie',
    'mimetype__content' => 'Zawartość',
    'mimetypeslist__title' => 'Typy MIME',
    'mimetypes__title' => 'Typy MIME',
    'mimetypes__select_to_remove' => 'Wybierz typy MIME do usunięcia.',
    'mimetypes__select_for_remove' => "Wybierz typy MIME do usunięcia.",
    'mimetypes_remove__title' => 'Usuń typ MIME',
    'mimetype__legend' => 'Typ MIME',
    'mimetype_edit__title' => 'Edytuj typ MIME',
    'mimetype_edit__already_exists' => 'Typ MIME jest już zdefiniowany dla tego rozszerzenia.',
    'mimetype_edit__not_exists' => 'Typ MIME nie istnieje.',
    'mimetype__content_type_other' => 'Własny',

    'b_webdir_protection_enable' => 'Włącz ochronę katalogu www.',
    'b_webdir_protection_disable' => 'Wyłącz ochronę katalogu www.',
    'b_webdir_protection_disabled' => 'Ochrona katalogu www jest wyłączona.',

    'b_pd_usr_create' => 'Kliknij, aby stworzyć tego użytkownika chronionego URL.',
    'php__changeversion_title' => "Wybierz wersję PHP",
    'php__group_php_version' => "Wersja PHP",

    'virtualdir__name' => 'Nazwa',
    'virtualdir__path' => 'Ścieżka',
    'virtualdir__read' => 'Prawa odczytu',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Prawa zapisu',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Dostęp do źródła Skryptu',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Przeglądanie katalogu',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Prawa wykonywania',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Loguj wizity',
    'virtualdir__app_create' => 'Stwórz aplikację',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Włącza anonimową autentykację.',
    'virtualdir__auth_windows' => 'Włącza autentykację Windows.',
    'virtualdir__auth_not_enabled' => 'Autentykacja anonimowa lub Windows musi być włączona.',
    'virtualdir__require_ssl' => 'Wymaga SSL/TLS',
    'virtualdir__enable_default_doc' => 'Użyj domyślnych dokumentów',
    'virtualdir__default_doc' => 'Domyślna kolejność przeszukiweania dokumentów',
    'virtualdir__enable_parent_paths' => 'Zezwalaj na użycie ścieżek nadrzędnych',
    'virtualdir__execute_in_mta' => 'Zezwalaj na wykonywanie plików w trybie MTA (w zestawieniach wielowątkowych)',
    'virtualdir_create__title' => 'Stwórz katalog wirtualny w %1',
    'virtualdir_edit__title' => 'Ustawieni wirtualnego katalogu %1',
    'virtualdir_edit__legend' => 'Wirtualny katalog',
    'virtualdir_edit__application_legend' => 'Ustawienia aplikacji',
    'virtualdir_edit__security_legend' => 'Bezpieczeństwo katalogu',
    'virtualdir_edit__documents_legend' => 'Dokumenty',
    'virtualdir_edit__list_legend' => 'Zagnieżdzone katalogi wirtualne',
    'virtualdir_error__path_not_in__' => 'Podano błędną ścieżkę',
    'virtualdir_error__already_exists' => 'Katalog o takiej nazwie już istnieje.',
    'virtualdir_root' => 'Wirtualne katalogi',
    'virtualdir_root__title' => 'Wirtualne katalogi',
    'virtualdir_root__list_legend' => 'Wirtualne katalogi',
    'virtualdir_se__none' => 'Żaden',
    'virtualdir_se__script' => 'Jedynie Skrypty',
    'virtualdir_se__script_execute' => 'Skrypty i Wykonywalne',
    'virtualdirs__title' => 'Wirtualne katalogi',
    'virtualdirs__path_not_exists' => 'Błędna ścieżka.',
    'virtualdirs__select_for_remove' => "Zaznacz katalogi wirtualne do usunięcia.",
    'virtualdirs_remove__title' => 'Usuń wirtualne katalogi',
    'virtualdirs_phys_dir_exist' => 'Fizyczny katalog o tej samej nazwie już istnieje. Jeżeli będziesz kontynuował stanie się on niedostępny. Czy chcesz kontynuować?',
    'virtualdir_auto_create_dir' => "Utwórz fizyczny katalog z taką samą nazwą jak nazwa katalogu wirtualnego",

    'asp_max_default_text' => 'Zdefiniowany przez katalog nadrzędny (%1 KB)',
    'asp_max_default_text_site' => 'Zdefiniowany przez IIS (%1 KB)',
    'asp_max_buffer_text' =>'Maksymalny rozmiar bufora ASP (KB)',
    'asp_max_body_text' => 'Maksymalny rozmiar zapytania ASP (KB)',
    'asp_buffers_legend' =>'Ustawienia ASP',

    'asp_debug_default_text' =>'Zdefiniowany przez katalog nadrzędny',
    'asp_debug_default_text_site' =>'Zdefiniowany przez IIS',
    'asp_client_debug_text' =>'Włącz debugowanie skryptów ASP po stronie klienta',
    'asp_server_debug_text' =>'Włącz debugowanie skryptów ASP po stronie serwera',

    'webdirs__list_with_broken_dirs' => "Istnieją wirtualne katalogi linkujące do nieistniejących fizycznie katalogów.",
    'webdirs__vdir_physical_path_not_exist' => "Katalog wirtualny linkuje do nieistniejącego fizycznie katalogu.",
    'webdirs__physical_path_not_exist' => "Podana ścieżka nie istnieje.",

    'filemanager__new_dir_title' => 'Utwórz katalog',
    'php__configuration_title' => "Konfiguracja PHP",

    'permissions__title' => 'Ustawianie Uprawnień Dostępu',
    'permissions__title_advanced' => 'Ustawianie Zaawansowanych Uprawnień Dostępu',
    'permissions__inherit_from_parent' => 'Pozwól na propagację uprawnień z obiektu nadrzędnego do tego obiektu i wszystkich obiektów podrzędnych. Zawrzyj to wraz z wpisami zdefiniowanymi tutaj.',
    'permissions__replace_on_children' => 'Zastąp wpisy dotyczące uprawnień wszystkich obiektów podrzędnych wpisami poniżej.',
    'permissions__group_or_user_name' => 'Grupa lub nazwy użytkowników',
    'permissions__Permissions_for' => 'Uprawnienia dla',
    'permissions__allow' => 'Pozwól',
    'permissions__deny' => 'Zabroń',
    'permissions__FullControl' => 'Pełna kontrola',
    'permissions__Modify' => 'Modyfikuj',
    'permissions__ReadAndExecute' => 'Odczyt & Wykonywanie',
    'permissions__ListFolderContents' => 'Pokaż zawartość katalogu',
    'permissions__Read' => 'Odczyt',
    'permissions__Write' => 'Zapisz',
    'permissions__ReadControl' => 'Kontrola Odczytu',
    'permissions__WriteControl' => 'Kontrola Zapisu',
    'permissions__ExecuteControl' => 'Kontrola wykonywania',
    'permissions__TraverseFolderOrExecuteFile' => 'Przeglądaj Folder / Wykonaj Plik',
    'permissions__ListFolderOrRead' => 'Zawartość Katalogu / Odczytaj Dane',
    'permissions__CreateFilesOrWrite' => 'Twórz Pliki / Zapisuj Dane',
    'permissions__CreateFoldersOrAppend' => 'Twórz Foldery / Nadpisuj Dane',
    'permissions__DeleteSubfoldersandFiles' => 'Usuń podkatalogi i pliki',
    'permissions__Delete' => 'Usuń',
    'permissions__ChangePermissions' => 'Zmień Uprawnienia',
    'permissions__TakeOwnership' => 'Jest właścicielem',
    'permissions__inherited_from' => 'Odziedziczony z',
    'permissions__not_inherited' => '<nie dziedziczone>',
    'permissions__apply_to' => 'Zastosuj do',
    'permissions__apply_onto' => 'Zastosuj do:',
    'permissions__apply_onto1' => 'Jedynie ten katalog',
    'permissions__apply_onto2' => 'Jedynie podkatalogi',
    'permissions__apply_onto3' => 'Ten katalog i podkatalogi',
    'permissions__apply_onto4' => 'Jedynie pliki',
    'permissions__apply_onto5' => 'Ten katalog i pliki',
    'permissions__apply_onto6' => 'Jedynie podkatalog i pliki',
    'permissions__apply_onto7' => 'Ten katalog, podkatalogi i pliki',

    'filemanager__not_allowed_dir' => "Nie masz uprawnień do zmiany uprawnień dla tego folderu.",

    'filemanager__allow' => "Pozwól",
    'filemanager__deny' => "Zabroń",
    'filemanager__user_domusr' => 'Administrator strony WWW',
    'filemanager__user_webusr' => 'Użytkownik Web',
    'filemanager__user_admins' => 'Administratorzy',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'Użytkownik ASP.NET',
    'filemanager__user_poolusr' => 'Użytkownik puli aplikacji',
    'filemanager__user_sysaccount' => 'Dodatkowy użytkownik systemowy',

    'bt_permissions_advanced' => 'Zaawansowane',
    'b_permissions_advanced' => 'Kliknij, aby przeglądać i ustawiać specjalne uprawnienia.',

    'b_hotlinkprotection' => 'Ustaw ochronę przed hotlinkowaniem dla domeny.',
    'b_hotlinkprotection_on' => 'Włącz ochronę przed hotlinkowaniem dla treści domeny.',
    'b_hotlinkprotection_off' => 'Wyłącz ochronę przed hotlinkowaniem dla treści domeny.',

    'bt_hotlinkprotection' => 'Ochrona przed hotlinkowaniem',
    'hotlinkprotection__title' =>'Ochrona przed hotlinkowaniem',
    'hotlinkprotection__friend_domains' => 'Przyjazne domeny',
    'hotlinkprotection__extensions' => 'Rozszerzenia plików chronionych',

    'hotlinkprotection_invalid_friend_domains' => 'Nieprawidłowa nazwa dla zaprzyjaźnionych domen.',
    'hotlinkprotection_invalid_extensions' => 'Rozszerzenie pliku zawiera niedozwolone znaki.',

    'i_domain_alias_status_on' => 'Alias domeny jest włączony.',
    'i_domain_alias_status_off' => 'Alias domeny jest wyłączony.',
    'i_domain_alias_status_with_parent' => 'Alias domeny jest wyłączony, ponieważ domena jest wyłączona.',
    'i_domain_alias_turn_off' => 'Kliknij, by wyłączyć.',
    'i_domain_alias_turn_on' => 'Kliknij, by włączyć.',
    'i_domain_alias_mail_on' => 'Usługa mailowa jest włączona dla tego aliasu domeny.',
    'i_domain_alias_mail_off' => 'Usługa mailowa jest wyłączona dla tego aliasu domeny.',
    'i_domain_alias_mail_with_parent' => 'Usługa mailowa jest wyłączona, ponieważ alias domeny jest wyłączony.',
    'i_domain_alias_web_on' => 'Usługa webowa jest włączona dla tego aliasu domeny.',
    'i_domain_alias_web_off' => 'Usługa webowa jest wyłączona dla tego aliasu domeny.',
    'i_domain_alias_web_with_parent' => 'Usługa webowa jest wyłączona, ponieważ alias domeny jest wyłączony.',
    'i_domain_alias_dns_on' => 'Usługa aliasingu DNS jest włączona dla tego aliasu domeny.',
    'i_domain_alias_dns_off' => 'Usługa aliasingu DNS jest wyłączona dla tego aliasu domeny.',
    'i_domain_alias_dns_with_parent' => 'Synchronizacja DNS z domeną nadrzędną jest wyłączona, ponieważ alias domeny jest wyłączony.',
    'i_domain_alias_seoRedirect_on' => 'Przekierowanie z kodem HTTP 301 jest włączone dla tego aliasu domeny.',
    'i_domain_alias_seoRedirect_off' => 'Przekierowanie z kodem HTTP 301 jest wyłączone dla tego aliasu domeny.',
    'i_domain_alias_seoRedirect_with_parent' => 'Przekierowanie z kodem HTTP 301 jest wyłączone, ponieważ alias domeny jest wyłączony.',

    'domain_alias__control_title' => 'Alias domeny %1',
    'domain_alias__control_info_legend' => 'Informacja',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Nazwa usługi',
    'domain_alias__control_details_title' => 'Szczegóły',

    'domain_alias__invalid_values' => 'Wprowadzona nazwa domeny jest niewłaściwa. Na nazwę mogą się składać litery, cyfry i myślniki. Każdy człon nazwy domenowej nie powinien być dłuższy niż 63 znaki.',
    'domain_alias__domain_already_exists' => "Niewłaściwa nazwa aliasu domeny %1. Domeny %1 już istnieje.",
    'domain_alias__www_prefix_domain_already_exists' => "Niewłaściwa nazwa aliasu domeny www.%1. Ten alias jest już utworzony dla domeny %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Niewłaściwa nazwa aliasu domeny webmail.%1. Ten alias jest już utworzony dla domeny %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Niewłaściwa nazwa aliasu domeny lists.%1. Ten alias jest już utworzony dla domeny %1.',
    'domain_alias__dns_record_already_exists' => 'Nie powiodło się utworzenie aliasu domeny %1. Rekord PTR dla hosta %1 już istnieje.',
    'domain_alias__domain_alias_already_exists' => "Alias domeny o takiej nazwie już istnieje.",
    'domain_aliases__mail_server_not_support_aliases' => 'Serwer mailowy nie obsługuje funkcji aliasów domen. Aliasy mogą nie działać prawidłowo.',
    'domain_alias__restrict_domain_creation' => 'Podana nazwa dla aliasu domeny jest zabroniona w ogólnej polityce serwera. Jeśli ta nazwa aliasu domeny należy do ciebie, skontaktuj się z dostawcą usług hostingowych.',
    'domain_alias__restrict_creation_with_www' => 'Proszę wpisać nazwę domeny bez prefiksu \'www\'. Prefiks www dla domeny zostanie sutomatycznie dodany do konfiguracji serwera WWW.',
    'domain_unable_to_set_name' => 'Niepoprawna nazwa %1.',

    'domain_alias__domain_service_dns_disabled' => 'Ta domena jest udostępniona przez inny serwer DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Ten serwer DNS działa jako podstawowy serwer (master) w tej strefie.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Ten serwer DNS działa jako zastępczy serwer (slave) w tej strefie.',
    'domain_alias__domain_service_mail_enabled' => 'Usługa poczty została uruchomiona w tej domenie.',
    'domain_alias__domain_service_mail_disabled' => 'Usługa poczty została wyłączona w tej domenie.',
    'domain_alias__domain_service_mail_mx' => '%1 jest używany jako serwer poczty.',

    'domain_alias__service_seoRedirect_hint' => 'Kiedy odwiedzający otworzą URL aliasu, zostaną przekierowani na URL podstawowej domeny. Plesk używa przyjaznego wyszukiwarkom przekierowania HTTP 301, co oznacza, że ranking w wyszukiwarce nie będzie podzielony pomiędzy URL.',

    'bt_task_run_now' => 'Uruchom teraz',
    'ftp__read_perm' => "Prawa odczytu",
    'ftp__write_perm' => "Prawa zapisu",

    'filemanager__upload_backup_file_hint' => 'Tutaj możesz wgrać pliki kopii zapasowej do przechowywania Pleska. Maksymalny rozmiar pliku to dwa gigabajty.',

    'additional_key__used' => 'aktywowany',

    '__default_for_mssql' => 'domyślny dla MS SQL',

    '__login_does_not_pass_validation' => "Niepoprawna nazwa użytkownika. Upewnij się, że spełnia następujące kryteria: %1",
    '__login_allowed_symbols' => 'Dozwolone są tylko znaki alfanumeryczne w tym kropki, kreski i podkreślniki. Pierwszy znak powinien być alfanumeryczny.',

    'restart__nginx' => 'Reverse Proxy Server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Chciałbym otrzymywać ogólne informacje o produkcie oraz ogłoszenia od Pleska.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Chciałbym otrzymywać informacje dotyczące bezpieczeństwa i inne techniczne powiadomienia od Pleska.",

    'server_preferences__webdeploy_include_password' => 'Umieść hasło użytkownika w pliku z ustawieniami publikacji Web Deploy',

    '__login_status_inactive' => 'Twoje konto jest nieaktywny. Proszę skontaktować się z administratora Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Wróć na stronę Narzędzia i Ustawienia. Migracja będzie kontynuowana w tle.',

    'ui__admin-alias-info__description' => "Edytuj dane kontaktowe o dodatkowym koncie administratora.",
    'ui__admin-alias-info__short-title' => "Dane kontaktowe",
    'ui__admin-alias-info__title' => "Informacje o koncie administratora",
    'ui__admin-alias-password__description' => "Zmień hasło dodatkowe administratora.",

    'ui__admin-alias-password__short-title' => "Zmień hasło",
    'ui__admin-alias-password__title' => "Hasło dodatkowe administratora",
    'ui__admin-alias__description' => "Przejrzyj i zmień informacje o dodatkowych kontach administratora.",

    'chk_js__warning_about_login_syntax' => "Używaj wyłšcznie małych liter, mylnika, kropek i symbolu podkrelenia w nazwie loginu. Nazwa użytkownika powinna zaczynać się od znaku alfabetu. Hasło nie powinno zawierać nazwy użytkownika i cudzysłów.",
    'chk_js__warning_about_ftp_login_syntax' => "W nazwie loginu możesz używać jedynie symbolów alfanumerycznych, myślnika i podkreślenia.",
    'chk_js__warning_about_login_syntax_win' => "Możesz używać małych znaków alfanumerycznych, mylnika, kropki oraz podkreleń w nazwie użytkownika. Nazwa użytkownika powinna rozpoczynać się od litery alfabetu lub cyfry. Hasło nie powinno zawierać nazwy użytkownika i cudzysłów.",
    'chk_js__warning_about_passwd_syntax' => "Nie używaj cudzysłowów, spacji i znaków alfabetu narodowego w haśle.\nHasło powinno mieć długość od %1 do %2 znaków i nie powinno zawierać nazwy użytkownika.",
    'chk_js__warning_about_plesk_login_syntax' => "Używaj wyłšcznie małych liter, mylnika, kropek i symbolu podkrelenia w nazwie loginu.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Używaj wyłšcznie małych liter, mylnika, kropek i symbolu podkrelenia w nazwie loginu. Nazwa użytkownika powinna zaczynać się od znaku alfabetu.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Nie używaj cudzysłowów, spacji i znaków alfabetu narodowego w haśle.\nHasło powinno mieć długość od %1 do %2 znaków i nie powinno zawierać nazwy użytkownika.",
    'chk_js__warning_about_pam_passwd_error' => "Błędne dane o koncie klienta systemu: %1",

    'cmd_server__admin_alias_not_found' => "Nie udało się znaleźć dodatkowego konta administratora.",

    'panel_branding__skins_already_exists' => "Uwaga: Skórki '%1' już istnieje. Zostanie zastąpiony motywem, który obecnie instalujesz.",
    'panel_branding__skins_file_exists' => "Nie udało się utworzyć katalogu dla motywu '%1': Plik o takiej nazwie już istnieje.",

    'actionlog__login_failed' => 'Nie udało się zalogować',
    'actionlog__event_cp_user_login_failed' => 'Nie udało się zalogować użytkownika Plesk',
    'actionlog__api_login_failed' => 'nie udało się zalogować przez API',
    'actionlog__event_cp_user_api_login_failed' => 'Nie udało się zalogować użytkownika Plesk poprzez API',
    'actionlog__pw_reset' => 'zażądano zresetowania hasła',

    'ch_pass_by_secret__email_subject' => "Przypominanie hasła Plesk",
    'ch_pass_by_secret__email_body' => "Witaj %2,\n\nAby ustawić nowe hasło, postępuj zgodnie z linkiem: %1\n\nTwój login: %3",
    'ch_pass_by_secret__message_send_error' => 'Błąd podczas wysyłania tajnego kodu: %1',
    'ch_pass_by_secret__title' => 'Zmień swoje hasło',
    'ch_pass_by_secret__secret' => 'Kod',

    'custom_button__noframe' => "Nie używaj ramek",

    'custom_button__internal_hint' => 'Określ, czy otworzyć URL na stronie Plesk czy w nowym oknie przeglądarki.',
    'custom_button__noframe_hint' => 'Jeśli dodasz spersonalizowany przycisk, który prowadzi do rozszerzenia Plesku lub do aplikacji w Panelu klienta, możesz okreslić, w jaki sposób rozszerzenie lub aplikacja mają być wyświetlane: w ramce czy jako część interfejsu użytkownika Plesk.',


    'actionlog__patch' => 'Aktualizuj',
    'actionlog__patch_available' => 'dostępny',
    'actionlog__event_patch_available' => 'Dostępne aktualizacje',
    'actionlog__patch_installed' => 'zainstalowany',
    'actionlog__event_patch_installed' => 'Zainstalowano aktualizację',

    'actionlog__extension' => 'Rozszerzenie',
    'actionlog__extension_status' => 'Status rozszerzenia',
    'actionlog__cloning' => 'Klonowanie serwera',
    'actionlog__cloning_complete' => 'kompletny',
    'actionlog__event_cloning_complete' => 'Zakończono klonowanie serwerów',

    'actionlog__ssl_web_binding' => 'Certyfikat SSL / TLS w domenie',
    'actionlog__ssl_web_binding_update' => 'przypisany / nieprzypisany',
    'actionlog__event_ssl_web_binding_update' => 'Certyfikat SSL / TLS w domenie przypisanej / nieprzypisanej',

    'actionlog__ssl_web_mail_binding' => 'Certyfikat SSL/TLS na poczcie internetowej',
    'actionlog__ssl_web_mail_binding_update' => 'przypisany / nieprzypisany',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certyfikat SSL/TLS na stronie internetowej przypisany / nieprzypisany',

    'actionlog__ssl_mail_binding' => 'Certyfikat SSL/TLS na serwerze pocztowym',
    'actionlog__ssl_mail_binding_update' => 'przypisany / nieprzypisany',
    'actionlog__event_ssl_mail_binding_update' => 'Certyfikat SSL/TLS na serwerze poczty przypisany / nieprzypisany',

    'actionlog__ssl_panel_binding' => 'Certyfikat SSL / TLS w Plesku',
    'actionlog__ssl_panel_binding_update' => 'przypisany / nieprzypisany',
    'actionlog__event_ssl_panel_binding_update' => 'Certyfikat SSL/TLS dla Plesk przypisany / nieprzypisany',

    'actionlog__hostname' => 'Nazwa hosta serwera',
    'actionlog__hostname_changed' => 'zmienione',

    'actionlog__event_mail_management_status_update' => 'Aktualizacja stanu zarządzania pocztą',
    'actionlog__mail_management' => 'Stan zarządzania pocztą',
    'actionlog__mail_management_status_update' => 'zaktualizowany',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Suma według domen',

    'chk_js__warning_about_admin_passwd_syntax' => "Nie używaj cudzysłowu, spacji, średnika i znaków diakrytycznych w haśle.\nHasło powinno mieć długość od %1 do %2 i nie powinno zawierać nazwy użytkownika.",

    'passwordSecurityLevelCheckFailed' => 'Twoje hasło nie jest wystarczająco złożone. Według polityki serwera, minimalna siła hasła to %1. Aby wzmocnić siłę hasła, użyj liczb, małych i dużych liter oraz znaków specjalnych takich jak !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Bardzo słabe',
    'passwordSecurityLevelCheckFailedWeak' => 'Słabe',
    'passwordSecurityLevelCheckFailedMediocre' => 'Średnie',
    'passwordSecurityLevelCheckFailedStrong' => 'Silne',
    'passwordSecurityLevelCheckFailedStronger' => 'Bardzo silne',

    'cu__php_settings__command_update_all' => "Aktualizuj indywidualne ustawienia PHP dla wszystkich domen zgodnie z plikiem php.ini.",
    'cu__php_settings__update_all_done' => "Zaktualizowano indywidualne ustawienia PHP dla wszystkich domen.",

    'filemanager__invalid_path' => "Podano błędną ścieżkę",

    'additional_key__descr_app' => 'Aplikacja',
    'additional_keys__used_keys' => ', %1 wykorzystanych kluczy',
    'additional_key__descr_key_mailboxes' => 'Skrzynki pocztowe',

    'ui__client/domain/dns/sync__description' => 'Zastosuj zmiany szablonu DNS do tej strefy.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Nie udało się zastosować zmian szablonu DNS do strefy, ponieważ strefa jest obsługiwana przez inny serwer DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Zastosuj zmiany szablonu DNS',
    'ui__client/domain/dns/sync__done' => 'Zmiany w szablonie DNS zostały zastosowane do strefy.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Zastosuj zmiany szablonu DNS do tej strefy.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Nie udało się zastosować zmian szablonu DNS do strefy, ponieważ strefa jest obsługiwana przez inny serwer DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Zastosuj zmiany szablonu DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Zmiany w szablonie DNS zostały zastosowane do strefy.',
    'dns__dns_zone_sync_form' => 'Zastosuj zmiany szablonu DNS',
    'dns__dns_zone_sync_legend' => 'Opcje',
    'dns__dns_zone_sync_ways' => 'Wybierz jeden z poniższych',
    'dns__dns_zone_sync_way_safe' => 'Zastosuj zmiany do niezmienianych stref. Jeśli strefa została spersonalizowana (dodano nowe rekordy lub istniejące zostały zmienione), Plesk nie zastosuje zmian z szablonu do tych stref.',
    'dns__dns_zone_sync_way_forced' => 'Zastosuj zmiany do wszystkich stref. Plesk zastosuje zmiany z szablonu do wszystkich stref DNS w tym do tych spersonalizowanych. Zauważ, że rekordy zmodyfikowane przez użytkownika pozostają bez zmian. Na przykład, jeśli szablon zawiera nowy rekord, który został dodany przez klienta, Plesk zachowa rekord klienta.',
    'dns__dns_default_ipv4_modified' => 'Rekordy z adresem IP będą uważane za zmodyfikowane przez użytkownika i nie będą synchronizowane z ogólnym dla serwera szablonem DNS.',
    'dns__dns_default_ipv6_modified' => 'Rekordy z adresem IP będą uważane za zmodyfikowane przez użytkownika i nie będą synchronizowane z ogólnym dla serwera szablonem DNS.',

    'dns__view_dns_record_master_title' => 'Pokazuje rekordy',
    'dns__view_dns_record_off_title' => 'Pokazuje rekordy serwera nazw',
    'dns__view_dns_record_slave_title' => 'Podgląd głównych rekordów serwera DNS',

    'dns_unable_to_resolve_hostname' => "Nie udało się rozwiązać nazwy hosta \"%1\": %2\nUpewnij się, że rozwiązywacz DNS systemu operacyjnego jest skonfigurowany i pracuje poprawnie.",

    'no_database_server_available' => 'Brak serwerów baz danych dla tej subskrypcji.',

    'database_used_by_application_can_not_be_moved' => 'Nie udało się przenieść bazy danych: Aplikacja serwisu używa tej bazy danych.',
    'database_user_update_orphaned_is_restricted' => 'Aktualizowanie kont osieroconych użytkowników baz danych jest zabronione. Można je tylko usuwać lub naprawiać.',

    'database_unable_to_get_max_filesize_default_message' => 'Nie udało się określić maksymalnego rozmiaru pliku bazy danych: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Nie udało się ustalić maksymalnego rozmiaru pliku bazy danych: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Nie udało się określić maksymalnego rozmiaru pliku logu bazy danych: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Nie udało się ustalić maksymalnego rozmiaru pliku logu bazy danych: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Nie udało się określić istniejącego limitu rozmiaru pliku bazy danych Microsoft SQL \'%1\'. Ustawienie nowego limitu jest niemożliwe.',
    'database_unable_to_set_max_filesize' => 'Nie udało się ustalić limitu rozmiaru pliku bazy danych Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Nie udało się określić istniejącego limitu rozmiaru pliku logu bazy danych Microsoft SQL \'%1\'. Ustawienie nowego limitu jest niemożliwe.',
    'database_unable_to_set_max_log_filesize' => 'Nie udało się ustalić limitu rozmiaru pliku logu bazy danych Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Nie udało się utworzyć bazy danych Microsoft SQL \'%1\': Rozmiar jej pliku jest większy niż maksymalny dozwolony rozmiar.',
    'database_unable_to_move_because_max_filesize' => 'Nie udało się przenieść bazy danych Microsoft SQL \'%1\': Rozmiar jej pliku jest większy niż maksymalny dozwolony rozmiar: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Nie udało się utworzyć bazy danych Microsoft SQL \'%1\': Rozmiar jego pliku logu jest większy niż maksymalny dozwolony rozmiar.',
    'database_unable_to_move_because_max_log_filesize' => 'Nie udało się przenieść bazy danych Microsoft SQL \'%1\': Rozmiar jego pliku logu jest większy niż maksymalny dozwolony rozmiar: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Nie udało się przywrócić bazy danych Microsoft SQL \'%1\': Rozmiar jej pliku jest większy niż maksymalny dozwolony rozmiar.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Identyczny serwer MS SQL jest już zarejestrowany w Plesku. Proszę określić inny serwer MS SQL jako piaskownicę.',
    'database_server__mssql_server_registered_as_sandbox' => 'Identyczny piaskownica - serwer MS SQL jest już zarejestrowany w Plesku. Proszę określić inny serwer MS SQL jako piaskownicę.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Nie można połączyć się z serwerem za pomocą \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Funkcja %1 nie jest obsługiwana przez następujące węzły usługi: %2. Ta funkcja zostanie zablokowana dla wszystkich obiektów utworzonych na tych węzłach.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Ta funkcja %1 nie jest obsługiwana przez serwer. Ta funkcja zostanie zablokowana dla wszystkich przywróconych obiektów.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Komponent %1 nie jest zainstalowany. Zostanie wyłączony dla następujących strony: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Komponent %1 nie jest zainstalowany. Zostanie zastąpiony %2 dla następujących strony: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Obecna wersja Plesk nie obsługuje nazw użytkownika ze znakiem kropki (. ). Klienci i sprzedawcy z takimi nazwami użytkownika nie mogą być przywrócone.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Nie udało się znaleźć pliku kopii zapasowej z danymi dla %1 %2. Dane dla %1 %2 nie będzie przywrócona.',

    'bu_conflict_resolver_zone_master_removed' => "Nie udało się przywrócić nadrzędnego rekordu DNS: Rekord w strefie podrzędnej wskazuje na istniejący adres IP %1. Rekord DNS master zostanie usunięty ze strefy slave.",

    'bu_conflict_resolver_not_available_scripting' => '%1 nie jest obsługiwana.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 nie jest obsługiwana. Zostanie wyłączony dla następujących strony: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Komponent %1 nie jest zainstalowany.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Będzie niedostępny dla następujących węzłów usługi: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Zostanie wyłączony dla następujących obiektów: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Następujące serwery bazy danych nie są dostępne na tym serwerze: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Plik kopii zapasowej MS SQL jest przechowany w oryginalnym formacie MS SQL, który może być przywrócony tylko do lokalnego serwera MS SQL lub do zdalnego serwera MS SQL z w pełni skonfigurowanymi ustawieniami kopii zapaowej. Niektóre twoje bazy danych nie zostały przywrócone, ponieważ brak odpowiedniego serwera MS SQL zarejestrowanego w Plesku. Dotyczy to następujących domen: {{objects}}. Skontaktuj się z dostawcą usług.',

    'bu_conflict_resolver_not_available_webmail' => 'Poczta webowa %1 jest niedostępna. Zostanie zastąpiony %2 dla następujących obiekty: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Poczta webowa %1 jest niedostępna. Zostanie zastąpiony %2 dla następującego planów usługi: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Bazy danych typu '%1' nie obsługują nazw użytkowników identycznych z nazwami baz danych. Użytkownik '%2' zostanie ponownie nazwany '%3' dla bazy danych '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Limit użycia przestrzeni dyskowej nie jest określony w konfiguracji serwera docelowego. Wartość tego ustawienia zostanie zmieniona na "Nieograniczony".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Limit liczby połączeń nie jest określony w konfiguracji serwera docelowego. Wartość tego ustawienia zostanie zmieniona na "Nieograniczony".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Limit użycia ruchu sieciowego nie jest określony w konfiguracji serwera docelowego. Wartość tego ustawienia zostanie zmieniona na "Nieograniczony".',
    'cu__pleskrestore_backup_file_extracted' => 'Plik kopii zapasowej został wypakowany do "%1".',
    '__mod_bw_not_supported' => 'Moduł mod_bw dla serwera sieciowego Apache nie jest obsługiwany z powodu konfiguracji pliku systemowego. Limity użycia ruchu sieciowego i maksymalna liczba połączeń nie będą działały.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Autoryzacja POP3 do przekazywania poczty nie jest obsługiwana, wykorzystana zostanie autoryzacja POP3 przed SMTP. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Plan usługi \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 nie jest obsługiwana. Zostanie zastąpiony %2 dla następującego planów usługi: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 nie jest obsługiwana. Zostanie zastąpiony %2 dla następujących strony: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Następujące obiekty nie zostały znalezione w pliku kopii zapasowej: %1',
    'bu_conflict_resolver_absent_domains' => 'Niektóre obiekty nie mogą być przywrócone, ponieważ należą do następujących domen, które nie znajdują się w Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Niektóre serwisy WWW nie mogą być przywrócone, ponieważ należą do następujących domen nadrzędnych, które nie znajdują się w Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Nie udało się przywrócić stref DNS: Usługa DNS jest wyłączona w konfiguracji serwera.',
    'bu_conflict_resolver_mail_not_supported' => 'Nie udało się przywrócić skrzynek pocztowych: Usługa poczty jest wyłączona w konfiguracji serwera.',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'Podany czas bezczynności nie jest obsługiwany przez serwer WWW IIS. Wartość zostanie zresetowana na %1.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Podany limit działań procesora nie jest obslugiwany przez serwer WWW IIS. Wartość zostanie zresetowana na %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'certyfikat SSL/TLS serwera %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certyfikat SSL/TLS %2 domeny %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certyfikat SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Zawartość następujących obiektów nie może być przywrócona, ponieważ obiekty nie zostały odnalezione w Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Zawartość następujących skrzynek pocztowych nie może być przywrócona, ponieważ skrzynki pocztowe nie zostały odnalezione w Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Zawartość następujących list mailingowych nie może być przywrócona, ponieważ listy mailingowe nie zostały odnalezione w Plesku %1',
    'bu_conflict_resolver_absent_objects_database' => 'Zawartość następujących baz danych nie może być przywrócona, ponieważ bazy danych nie zostały odnalezione w Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Przywrócenie aplikacji "%1" na "%2" nie powiodło się, poniewaz inna aplikacja jest już zainstalowana w %3". Mozesz usunąć zainstalowana aplikację i spróbować ponownie.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Autoodpowiedź w poczcie nie jest obsługiwana.',
    'bu_conflict_resolver_not_available_mail_content' => 'Przywracanie treści poczty nie jest obsługiwana.',
    'bu_conflict_resolver_invalid_mail_name' => 'Następujące skrzynki pocztowe nie zostały przywrócone, ponieważ jest włączone podadresowanie wiadomości e-mail, a niektóre adresy e-mail zawierają znak "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Następujący użytkownicy nie zostali przywróceni, ponieważ jest włączone podadresowanie wiadomości e-mail, a niektóre adresy e-mail zawierają znak "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Następujące licencje wygasły i nie zostaną przywrócone: {{objects}}',
    'expiration_unsupported' => "Limit 'expiration' nie jest obługiwany.",

    'component_name__dbconnector' => "Łacznik bazy danych",
    'component_name__mysqlserver' => 'Serwer MySQL',
    'component_name__troubleshooting' => 'Wyszukiwanie problemów',

    '__subscription_has_no_license_key' => 'Zasoby subskrypcji są zapewniane przez węzeł usługi #%1, który nie ma powiązanego klucza licencyjnego.',
    '__subscription_has_expired_license_key' => 'Zasoby subskrypcji są zapewniane przez węzeł usługi #%1, którego klucz licencyjny %2 wygasł.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Nie udało się zachować plików konfiguracyjnych',
    '__cfgmonConfigurationFileSaveErrorBody' => "Nie udało się zachować niektórych plików konfiguracyjnych na hoście <%%host%%>: Pojawił się następujący błąd:\n\n%%errors%%",

    'mail__baddomain_exists' => "Ta domena jest już na czarnej liście.",
    'mail__block_mail_from_doms' => "Czarna lista",
    'mail__blockers' => "Zablokowane domeny",
    'mail__blockers_remove' => "Usuń zablokowane domeny",
    'mail__blocker_add' => "Dodaj domeny do czarnej listy",
    'mail__enable_email_subaddressing_cli_desc' => 'Ta opcja umożliwia skonfigurowanie adresów e-mail w stylu VERP dla list mailingowych',
    'mail__dom_in_list' => "Ta domena jest już na czarnej liście.",
    'mail__enter_right_ip_mask' => "Podaj maskę IP pomiędzy 1 a 32",
    'mail__enter_right_ip_mask_24' => "Podaj maskę IP pomiędzy 24 a 32",
    'mail__invalid_dom_name' => "Nazwa domeny %1 jest nieprawidłowa.",
    'mail__invalid_pop_lock_time' => "Czas ważności połączenia POP3 jest niepoprawny.",
    'mail__invalid_rbl_server' => "Nazwa strefy DNS jest nieprawidłowa.",
    'mail__ip_and_mask' => "Adres IP/maska",
    'mail__ip_and_mask_exists' => "Ta para adres IP/maska sieci już istnieje.",
    'mail__select_domains_for_remove' => "Zaznacz domeny do usunięcia.",
    'mail__total_files_size' => "Całkowita wielkość repozytorium: %1",
    'mail__filename_already_in_repository' => "Plik o tej samej nazwie znajduje się już w repozytorium",
    'mail__no_white_list_mask_feature_24' => "Użyj wartości maski 24 lub wyższej.\nTwój serwer pocztowy nie obsługuje ustawień masek. Możemy jedynie emulować ustawienia masek dla wartości nie mniejszych niż 24.",
    'mail__relay_from_ip' => "Biała lista",
    'mail__unable_add_new_mail_name' => "Nie można dodać konta pocztowego: %1",
    'mail_server_is_not_installed' => 'Serwer poczty (Postfix lub Qmail) nie jest zainstalowany. Zainstaluj, aby kontynuować pracę.',
    'mail_server_not_available' => 'Na węźle usługi nie ma dostępnych obsługiwanych serwerów pocztowych.',
    '__not_installed' => '(nie zainstalowane)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Filtrowanie spamu dla e-maili wychodzących jest zablokowane.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Węzeł usługi nie obsługuje ograniczania liczby wychodzących wiadomości e-mail z domeny na domenę %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Węzeł usługi nie obsługuje ograniczania liczby wychodzących wiadomości e-mail ze skrzynki pocztowej na domenę %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Podaj adres przynajmniej jednego typu (IPv4 lubr IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Określono niepoprawny tryb poczty wychodzącej.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Określono niepoprawny adres IPv4.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Określono niepoprawny adres IPv6.',
    'mail__outgoing_email_mode_unavailable' => 'Zmiana trybu poczty wychodzącej nie jest obsługiwana, prawdopodobnie dlatego, że serwer pocztowy Postfix nie jest zainstalowany na tym serwerze.',

    'mail__autoresponder_attachment_not_supported' => 'Obecnie używany serwer poczty nie obsługuje zarządzania załącznikiem autoodpowiedzi.',

    'mail__smtp_white_list_not_supported' => 'Aktualnie używany serwer poczty nie obsługuje białej listy adresów IP.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Maski CIDR nie są obsługiwane przez aktualnie wybrany serwer pocztowy. Podaj adres IP w formacie \'192.*.0.*”.',
    'mail__smtp_whitelist_mask_not_supported' => 'Wzorce adresów IP z symbolami wieloznacznymi nie są obsługiwane przez aktualnie wybrany serwer poczty. Podaj adres IP w formacie \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Nie można  zmienić ustawień usługi weryfikacji DKIM',

    'sfdk_domain__serverwide_disabled' => 'Wyłšczone zgodnie z regulaminem serwera',
    'feature__domainkeys__serverwide_disabled' => 'Ochrona serwera przed spamem DKIM jest wyłączona',

    'defaultcomponents__error_set_default' => 'Nie udało się ustawić %1 jako domyślnego %2',
    'defaultcomponents__required_package_not_default' => 'Komponent %1 wymagany do działania nie jest ustawiony jako domyślny.',

    '__percentage' => '%',
    '__seconds' => 'Sekundy',
    '__resource_remain' => 'Pozostałe',

    '__not_registered' => '(nie zarejestrowany)',
    '__php_handler_id' => 'Wersja PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Handler PHP "%1" nie jest zarejestrowany. Prawdopodobnie został usunięty z serwera. Zarejestruj handler o tych samych właściwościach i spróbuj ponownie.',
    '__php_handler_not_registered_on_domain' => 'Domena "%1": Handler PHP "%2" nie jest zarejestrowany. Prawdopodobnie został usunięty z serwera. Zarejestruj handler o tych samych właściwościach i spróbuj ponownie.',
    '__php_fpm_handler' => 'Aplikacja FPM',
    '__php_fpm-dedicated_handler' => 'Dedykowana aplikacja FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Uruchom, aby utworzyć użytkownika dla skrzynki pocztowej. Użytkownik o nazwie %1 już istnieje i ma inną skrzynkę pocztową.',
    'mailname_create_assigned_user_role_absent_error' => 'Uruchom, aby utworzyć użytkownika dla skrzynki pocztowej. Domyślna rola %1 użytkownika nie istnieje.',

    'gphd__mime_types' => 'Typy MIME',
    'gphd__handlers' => 'Uchwyty Apache',
    'gphd__ip_restrictions_allow' => 'Zezwalaj określonym hostom i sieciom (z wyłączeniem tych, którym odmówiono dostępu) na dostęp do serwisu',
    'gphd__ip_restrictions_deny' => 'Odmów określonym hostom i sieciom dostępu do serwisu',
    'gphd__directory_index' => 'Pliki indeksacyjne',
    'gphd__nginx_transparent_mode' => 'Tryb, kiedy Apache obsługuje zarówno treści statyczne, jak i dynamiczne, podczas gdy nginx tylko przekazuje żądania i odpowiedzi HTTP bez modyfikacji.',
    'gphd__nginx_serve_static' => 'Obsługuj statyczne pliki bezpośrednio przez nginx',
    'gphd__nginx_static_extensions' => 'Rozszerzenia plików statycznych, które muszą być obsługiwane przez nginx',
    'gphd__nginx_serve_php' => 'Przetwarzaj plików PHP przy pomocy nginx',
    'gphd__www_root' => 'Katalog root WWW',

    'eol__none' => 'nie modyfikuj',
    'eol__lf' => 'w stylu UNIX',
    'eol__cr' => 'w stylu MacOS',
    'eol__crlf' => 'w stylu Windows',

    'ui__dns_bad_zone' => 'Niespójna strefa "%1":',
    'ui__dns_ns_has_no_address_records' => 'Rekord NS "%1" nie ma rekordów adresu (A lub AAAA).',
    '__dns_bad_zone' => 'Niespójna strefa "%1":',
    '__dns_ns_has_no_address_records' => 'Rekord NS "%1" nie ma rekordów adresu (A lub AAAA).',
    '__dns_ptr_is_wildcard' => 'Rekord PTR "%1" jest niepoprawny: Rekord wskazuje na wieloznaczną domenę.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Zezwalaj na zdalny dostęp dla użytkownika bazy danych \'%3\' klienta \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Nie udało się zezwolić na zdalne połączenia z użytkownikiem bazy danych \'%1\': Nie udało się określić numeru portu TCP używanego przez serwer Microsoft SQL \'%2\'. Możliwe przyczyny są następujące: protokół TCP/IP nie jest odblokowany w konfiguracji seiciowej serwera lub serwer jest skonfigurowany tak, aby używać dynamicznych portów TCP. Skonfiguruj serwer tak, aby słuchał na określonym porcie TCP i spróbuj ponownie zezwolić na zdalne połączenia.',

    'command__convertResellerHasCustomer' => 'To konto sprzedawcy \'%1\' ma jedno lub kilka kont(o) klienta. Aby przekonwertować konto sprzedawcy na konto klienta, najpierw prześlij te konta klienta do nowego właściciela lub przekonwertuj je na konta sprzedawcy.',
    'command__convertResellerNotReseller' => 'Tylko konta sprzedawców mogą być zamienione w konta klientów. \'%1\' nie jest sprzedawcą.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Nie można zsynchronizować subskrypcji z planem usługi. Następujące ustawienia subskrypcji są w konflikcie z planem usługi: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Konto \'%1\' jest kontem sprzedawcy. Konta sprzedawcy nie mogą być przeniesione do nowego właściciela, ponieważ ich właścicielem jest administrator systemu.',
    'moveCustomer__wrong_owner_type' => "Konto klienta '%1' może przeniesione tylko do sprzedawcy lub administratora, nie do innego klienta.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Konto klienta \'%1\' już należy do wybranego właściciela.',
    'upgradeClient__user_is_admin' => 'Konto \'%1\' nie może być zmienione w konto sprzedawcy, ponieważ jest kontem administratora.',

    'mail__error_setting_max_connections_courier' => 'Nie udało się ustawić maksymalnej liczby połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Nie udało się ustawić maksymalnej liczby połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Nie udało się ustawić maksymalnej liczby połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS) na adres IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Nie udało się ustawić maksymalnej liczby połączeń (IMAP, POP3, IMAP poprzez SSL/TLS lub POP3 poprzez SSL/TLS) na adres IP dla podanego użytkownika poczty: %1',
    'outgoing_messages_limit_value_invalid' => 'Wartość musi mieścic się w zakresie %%MIN%%..%%MAX%%. Tylko administrator Plesk może dostosować to ustawienie.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Następujące domeny używają zewnętrznych adresów e-mail do przekazywania poczty wysyłanej na nieistniejące adresy. Wiadomości wysłane pod te adresy nie będą się liczyły w kontroli poczty wychodzącej:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Limity poczty wychodzącej nie będą działały dla wysyłających, których adresy IP są na białej liście serwera. Na przykład, jeśli lokalny host (127.0.0.0 / 8, ::1 / 128) znajduje się na białej liście, cała poczta z lokalnego serwera zostanie wysłana bez względu na ograniczenia.Nadawcy poczty mogą używać lokalnych adresów IP (serwisów WWW i spersonalizowanych skryptów na lokalnym serwerze) lub zewnętrznych adresów (klienci, którzy wysyłają poczte z klientów pocztowych zainstalowanych na ich komputerach lub na urządzeniach mobilnych).Aby zastosować limity dla wszystkich nadawców poczty (lokalnych i zewnętrznych), usuń wszystkie adresy IP i sieci z białej listy. Zauważ, że usunięcie lokalnego hosta (127.0.0.0 / 8, ::1 / 128) z białej listy może przerwać działanie serwisów WWW i skryptów, które wysyłają pocztę z tego serwera. Aby poznać szczegóły dotyczące ograniczeń poczty wychodzącej, zajrzyj do przewodnika administratora do sekcji dotyczącej ochrony przed spamem wychodzącym.',
    'outgoing_messages_relay_open' => 'Przekazywanie poczty jest otwarte: Limity poczty wychodzącej nie będą działały:.',

    'notification_aps_app_updates_available' => 'Aktualizacje są dostępne dla tych aplikacji:',
    'notification_aps_app_updates_installed' => 'Aktualizacje są automatycznie instalowane dla następujących aplikacji:',
    'notification_aps_app_updates_requirements' => 'Aktualizacje są dostępne dla następujących aplikacji, ale nie można ich zainstalować, ponieważ ustawienia hostingu powiązanych serwisów WWW nie spełniają wymagań instalacyjnych',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Wtyczka "%%name%%" na %%parentName%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Motyw "%%name%%" na %%parentName%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Wtyczka "%%name%%" na %%parentName%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Motyw "%%name%%" na %%parentName%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Twoja wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Wtyczka "%%name%%" na %%parentName%% (%%url%%). Twoja wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Motyw "%%name%%" na %%parentName%% (%%url%%). Twoja wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nowa wersja: %%to%%. Poprzednia wersja: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nowa wersja: %%to%%. Poprzednia wersja: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nowa wersja: %%to%%. Poprzednia wersja: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Zainstalowana wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Twoja wersja: %%from%%. Dostępna wersja: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'aplikacja zewnętrzna',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domeny',
    'notification_outgoing_mail_exceeded_limits_mails' => 'adres e-mail',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Subskrypcje',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 wiadomości na godzinę',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Nieograniczone',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, limit to %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 próba(y) przekroczenia limitów od %2 do %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 próba(y) przekroczenia limitów od %2 aż do teraz',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Blokowanie adresu IP (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Komponent Fail2ban nie jest zainstalowany na serwerze docelowym.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Zainstaluj Fail2ban. Zauważ, że to może zająć kilka minut.',

    'plesk_key__no_reseller_support' => 'Nie możesz zarządzać sprzedawcami z powodu ograniczeń licencji.',
    'plesk_key__no_customers_support' => 'Nie możesz zarządzać kllientami z powodu ograniczeń licencji.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Nie udało się włączyć widoku Dostawcy usługi z powodu ograniczeń licencji.',
    'plesk_key__no_security_core_support' => 'Główne własności bezpieczeństwa (ModSecurity i Fail2Ban) nie są dostępne z powodu ograniczeń licencji.',
    'plesk_key__outgoing-antispam' => 'Kontrola poczty wychodzącej',
    'plesk_key__security-core' => 'Rdzeń bezpieczeństwa (ModSecurity i Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Zarządzanie kontami',
    'plesk_key__can-manage-subscriptions' => 'Zarządzanie subskrypcjami',
    'plesk_key__can-manage-customers' => 'Zarządzanie klientami',
    'plesk_key__can-manage-resellers' => 'Zarządzanie sprzedawcami',
    'plesk_key__can-manage-custom-view' => 'Dostępność trybu ograniczonego',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Zarządzanie subskrypcjami jest wyłączone, ale masz wiele subskrypcji (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Zarządzanie sprzedawcami jest wyłączone, ale masz wielu sprzedawców (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Zarządzanie klientami jest wyłączone, ale masz wielu klientów (%1).',
    'plesk_key__no_subscriptions_support' => 'Nie możesz zarządzać subskrypcjami z powodu ograniczeń licencji.',
    'plesk_key__no_custom_view_support' => 'Nie możesz używać trybu ograniczonego ze względu na ograniczenia licencyjne.',
    'plesk_key__trial_forbidden_region' => 'Niestety, Plesk jest obecnie niedostępny w twoim regionie.',
    'additional_key__main_key' => 'Ten klucz jest kluczem głównym: Nie możesz wgrać głównego klucza jako dodatkowego.',

    'gch__hosting_waf_rule_engine' => 'Tryb zapory ogniowej aplikacji WWW',

    'backup__fieldset__restoration_options' => 'Opcje przywracania',
    'backup__restore_options__restore' => 'Przywróć %1',
    'backup__restore_options__domain__domain_configuration' => 'Konfiguracja domeny',
    'backup__restore_options__domain__virtual_host_content' => 'Zawartość wirtualnego hosta',
    'backup__restore_options__domain__mail' => 'Poczta',
    'backup__restore_options__domain__databases' => 'Bazy danych',
    'backup__restore_options__client__client_configuration' => 'Konfiguracja konta klienta',
    'backup__restore_options__client__domains' => "Domeny klienta",
    'backup__restore_options__reseller__reseller_configuration' => 'Konfiguracja konta sprzedawcy',
    'backup__restore_options__reseller__personal_domains' => "Domeny sprzedawcy",
    'backup__restore_options__reseller__clients' => "Klienci sprzedawcy",
    'backup__restore_options__admin__server_configuration' => 'Ustawienia serwera',
    'backup__restore_options__admin__administrator_configuration' => 'Ustawienia konta administratora',
    'backup__restore_options__admin__personal_domains' => "Domeny administratora",
    'backup__restore_options__admin__personal_clients' => "Klienci administratora",
    'backup__restore_options__admin__resellers' => 'Sprzedawcy',

    'badge_new' => 'Nowe',
    'upgrade_php_on_subscription' => 'Podnieś parametry PHP w swojej subskrypcji do wersji 5.3.0 lub późniejszej.',

    'pkey_notify__body_expiration_notification' => 'Klucz licencyjny utracił ważność. Niektóre funkcjonalności mogą być niedostępne. Skontaktuj się z dostawcą usług.',

    'crontab__crontab_entry_exists' => "Zaznacz zaplanowane zadanie.",
    'crontab__crontab_entry_not_exists' => "Zadanie nie istnieje.",
    'crontab__invalid_values_found' => "Znaleziono niepoprawne wartości parametrów.",
    'crontab__cmd_max_len' => "Polecenie nie może być dłuższe niż %1 znaków.",

    'domain__domain_exists' => "Istnieje domena o prefiksie 'www' i tej samej nazwie: %1.%2.",
    'domain__subdomain_exists' => "Istnieje poddomena o prefiksie 'www' i tej samej nazwie: %1.%2.",
    'domain__dalias_exists' => "Istnieje alias domeny o prefiksie 'www' i tej samej nazwie: %1.%2.",
    'domain__record_exists' => "Występuje już rekord DNS wskazujšcy na host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certyfikat '%1' nie może być ustawiony jako domyślny: brakuje klucza prywatnego.",
    'ip_addr__update_dns_error' => 'Wystąpiły błędy podczas aktualizacji adresu IP w strefach DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Nie można dodać adresu IP. Ten interfejs sieciowy uzyskuje adresy IP automatycznie.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Nie można usunąć adresu IP %1. Ten interfejs sieciowy uzyskuje adresy IP automatycznie.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Nie można naprawić adresu IP %1. Ten interfejs sieciowy uzyskuje adresy IP automatycznie.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Nie można zmienić interfejsu adresu IP %1, ponieważ interfejs sieciowy %2 uzyskuje adresy IP automatycznie.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Limit subskrypcji dotyczący liczby %%type%% został przekroczony. Limit wynosi %%limit%%, a %%usage%% jest używane.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Utworzenie %%type%% nie jest dozwolone dla tej subskrypcji.',
    'shm_lmsg__resource_title__db-mysql' => 'Bazy danych MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Baza Danych MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Bazy danych PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'użytkownicy bazy danych',
    'shm_lmsg__resource_title__iis-application-pool' => 'Pule aplikacji IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'dodatkowe konta FTP',

    'db_user_unable_remove_mysql_global_privileges' => 'Nie udało się usunąć globalnych uprawnień MySQL użytkownika bazy danych %1. Przyczyna: %2',
    'report__client_description' => 'Opis',

    'db__user_role_error' => 'Podano niepoprawną rolę użytkownika bazy danych: %1. Proszę wybrać jedną z następujących ról: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Nie udało się ustawić limitu rozmiaru pliku dla następujących serwerów baz danych SQL, ponieważ mają wiekszy rozmiar pliku: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Nie udało się ustawić limitu rozmiaru pliku logu dla następujących serwerów baz danych SQL, ponieważ mają wiekszy rozmiar pliku logu: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Nie udało się ustawić publicznego adresu IP: Musi istnieć prywatny adres IP.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Nie udało się ustawić publicznego adresu IPv4 dla adresu IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Nie udało się ustawić publicznego adresu IPv6 dla adresu IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Nie można ustawić publicznego adresu IP: nieprawidłowy adres IP.',

    '__user_already_exists' => "Użytkownik %1 już istnieje.",
    '__user_name_is_empty' => "Proszę określić nazwę użytkownika.",

    'upgrade_php_on_domain' => 'Nie udało się znaleźć PHP wersja 5.3.0 lub późniejszej na żadnej z twoich domen WordPress. Spróbuj podnieść parametry PHP.',

    'component_name__waf' => 'Zapora ogniowa aplikacji WWW',
    'component_name__vcs' => 'System kontroli wersji',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Wykryto mozliwy spoofing: Link próbował wyświetlić niepotrzebne treści.',
    'forceResetPasswordUpdated' => 'Twoje hasło zostało zmienione. Użyj nowego hasła, aby zalogować się do Pleska.',

    'php_handlers_error_no_available_instance' => 'Nie udało się utworzyć domeny: brak dostępnych handlerów PHP.',
    'domain_error_unable_to_apply_hosting_settings' => 'Nie udało się zastosować ustawień hostingu: %1',

    'plesk_not_configured' => 'Plesk nie jest skonfigurowany. Przejdź do panelu kontrolnego, aby wykonać konfigurację poinstalacyjną.',
    'cmd_mail__mail_password_duplicated' => 'Podana para adres e-mail i hasło już istnieje na serwerze poczty. Proszę podać inny adres e-mail lub hasło.',

    'extensionRequirementOs' => 'System operacyjny (%1) nie jest obsługiwany przez pakiet.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 jest najwcześniejszą wersją obsługiwaną przez pakiet.',
    'extensionRequirementPleskMaxVersion' => 'Wersje od Plesk %1 nie są obsługiwane przez pakiet.',
    'extensionBlacklisted' => 'Rozszerzenie %1 nie jest dozwolone w instalacji.',
    'extensionDisabled' => 'To rozszerzenie jest wyłączone.',


    'optimization_settings__unable_set_mpm_event' => 'Nie udało się skonfigurować trybu mpm_event: wymaga wyłączenia modułu Apache PHP5, ale ten moduł jest używany przez domeny.',
    'optimization_settings__unable_turn_off_php' => 'Nie udało się wyłączyć modułu Apache PHP5: jest używany przez domeny.',

    'hst_def__fp_admin_login' =>  'Nazwa użytkownika FTP',
    'hst_def__fp_admin_passwd' =>  'Hasło FTP',

    'database_user_orphaned_old_password_wrong' => "Nie udało się naprawić osieroconego użytkownika '%1': hasło jest niepoprawne.",
    'cannot_load_partner_central_property_key_no_exist' => "Nie udało się odzyskać spersonalizowanych właściwości: klucz licencyjny nie istnieje.",
    'extensionScriptFailure' => "Wykonanie %1 nie powiodło się z powodu następującego błędu:\n%3",
    '__ssl_redirect' => "Stałe bezpieczne w kontekście SEO 301 przekierowanie z HTTP na HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Zarządzanie DKIM nie jest obsługiwane.',
    'mail__dmarc_not_supported' => 'Zarządzanie DMARC nie jest obsługiwane.',
    'mail__relay_white_list_not_supported' => 'Zarządzanie białą listą nie jest obsługiwane.',
    'mail__black_list_not_supported' => 'Zarządzanie czarną listą nie jest obsługiwane.',
    'mail__autoresponder_not_supported' => 'Zarządzanie auto-responderem nie jest obsługiwane.',
    'defaultcomponents__not_supported_version' => '(wersja nieobsługiwana)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Certyfikat \'%1\' nie został odnaleziony.',
    'certificate__unable_setup_certificate' => 'Nie można zainstalować certyfikatu: brak klucza prywatnego i zawartości certyfikatu.',
    'certificate__used_by_panel' => 'Jeden z certyfikatów, które zamierzasz usunąć, jest używany jako zabezpieczenie Plesk.',
    'certificate__used_by_mail_server' => 'Jeden z certyfikatów, które zamierzasz usunąć, jest używany jako zabezpieczenie serwera poczty.',
    'certificate__used_by_domain_service' => 'Jeden z certyfikatów, który chcesz usunąć, jest używany przez usługę domeny.',
    'mail_server__not_installed' => 'Nie może zainstalować certyfikatu dla serwera pocztowego ponieważ serwer pocztowy nie jest zainstalowany.',

    'email_activation_mail_subject' => 'Aktywuj swoje konto w Plesku',
    'email_activation_mail_body' => "Konto zostało utworzone na serwerze Plesk %1\n\nDane konta:\nNazwa: %2\nAdres e-mail: %3\n\nJeśli te informacje są poprawne, a konto zostało utworzone dla Ciebie, aktywuj je za pomocą następującego linku:\n\n%4\n\nAktywując konto, upoważniasz posiadacza serwera do zbierania, przechowywania, przetwarzania i wykorzystywania twoich danych osobowych (imienia i nazwiska oraz adresu e-mail) do tworzenia i obsługi twojego konta, zgodnie z obowiązującymi obecnie przepisami o ochronie danych, w ramach kontrakt.",

    'backup_transport_permission_name' => 'Zarządzanie %1',
    'backup_transport_permission_description' => 'Pozwala używać %1 do przechowywania kopii zapasowych.',

    'domain_move_err_target_no_hosting' => 'Nie można przenieść domeny do subskrypcji bez hostingu.',
    'domain_move_err_already_in_target' => 'Domena już należy do docelowej subskrypcji.',
    'domain_move_err_main_domain' => 'Nie można przenieść głównej domeny.',
    'domain_move_err_subdomain_without_parent' => 'Nie można przenieść poddomeny %1 bez domeny nadrzędnej %2.',
    'domain_move_err_root_exists' => 'Ścieżka docelowa dla www_root %1 już istnieje.',
    'domain_move_err_nested_roots' => 'Nie można przenieść domeny, ponieważ dzieli ona katalog główny dokumentu z inną domeną: %1.',
    'domain_move_err_no_mail_service' => 'Nie można przenieść domeny, ponieważ usługa poczty jest wyłączona w docelowej subskrypcji.',
    'domain_move_err_app' => "Aplikacja zainstalowana na %1 nie została przeniesiona do subskrypcji '%2': %3",
    'domain_move_database_used_by_app' => "Baza danych '%1' na %2 jest używana przez przeniesioną aplikację. Aby ponownie przypisać bazę danych do  '%3', uruchom `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Subskrypcja docelowa '%1' została zablokowana do synchronizacji.",
    'domain_move_filesharing_disabled' => 'Udostępnianie plików zostało wyłączone.',
    'domain_move_website_preview_disabled' => 'Podgląd strony został wyłączony.',
    'domain_move_additional_webserver_settings' => "Zapoznaj się z dodatkowymi dyrektywami serwera WWW domeny, aby zapobiec uszkodzeniu konfiguracji.",
    'domain_move_no_permission' => "%1 nie jest dozwolony dla subskrypcji '%2'.",
    'domain_move_no_access' => "Brak dostępu do subskrypcji '%1'.",
    'domain_split_no_create_permission' => "Tworzenie domen jest niedozwolone.",
    'domain_split_empty_login' => 'Login użytkownika systemu jest wymagany.',
    'domain_split_empty_password' => 'Hasło użytkownika systemu jest wymagane.',
    'domain_split_err_home_exists' => 'Nie można przenieść domey %1, ponieważ jej docelowa ścieżka główna już istnieje w %2. Zmień nazwę domeny, aby przenieść ją do nowej subskrypcji.',
    'domain_split_err_no_hosting_subdomains' => 'Domeny nie można przenieść do nowej subskrypcji, ponieważ domena nie ma hostingu, ale ma subdomeny. Aby przenieść domenę, zmień jej wartość "Typ hostingu" na "Hosting stron WWW" (w Ustawieniach hostingu).',
    'domain_split_target_locked' => "Subskrypcja docelowa '%1' jest zablokowana do synchronizacji.",
    'domain_split_target_unsynced' => "Subskrypcja docelowa '%1' nie została zsynchronizowana z planem z powodu: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Zaplanowana kopia zapasowa została dezaktywowana w dniu '%1'.",
    'domain_merge_database_error' => "Baza danych '%1' na %2 nie została przeniesiona do subskrypcji '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Anonimowy FTP na '%1' został wyłączony.",
    'domain_merge_smb_user_access' => "Dodatkowy użytkownik '%1' został przeniesiony do subskrypcji '%2', ale dostęp użytkownika do subskrypcji został cofnięty.",
    'domain_merge_scheduled_tasks' => "Zaplanowane zadania zostały przeniesione do subskrypcji docelowej. Przejrzyj konfigurację zadań.",
    'domain_merge_scheduled_tasks_deactivated' => "Zaplanowane zadania zostały przeniesione do subskrypcji docelowej i dezaktywowane. Przejrzyj konfigurację zadań.",
    'domain_merge_no_remove_permission' => "Usuwanie subskrypcji jest niedozwolone.",
    'domain_merge_err_has_addons' => 'Nie można przenieść głównej domeny z dodatkowymi domenami; najpierw przenieś domeny %1.',
    'domain_merge_err_has_webusers' => 'Nie można przenieść głównej domeny z użytkownikami sieci.',
    'domain_merge_err_root_exists' => 'Ścieżka docelowa %1 już istnieje.',

    'database_server_edit_used_for_psa' => 'Aktualizowanie lokalnego serwera bazy danych MySQL jest niedozwolone.',
    'suggest_repair_main_suggestion_ui' => '<b>Możesz naprawić ten błąd,</b> używając narzędzia `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Możesz naprawić ten błąd za pomocą narzędzia `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'przejdź do Diagnozuj & Napraw',
    'suggest_repair_using_cli_and_ui' => 'Aby to zrobić, uruchom polecenie `plesk repair %1` za pośrednictwem interfejsu wiersza polecenia lub %2 i kliknij opcję Napraw obok pozycji "Baza danych Plesk"',
    'suggest_repair_using_cli' => 'Aby to zrobić, uruchom polecenie `plesk repair %1` za pośrednictwem interfejsu wiersza polecenia',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Usługa DNS była niedostępna podczas tworzenia kopii zapasowej. Jednak w kopii zapasowej istnieją aktywne strefy DNS i zostaną one włączone dla następujących obiektów: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Resource Controller (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Obsługa zdalnej aplikacji SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backupuj do Cloud Pro',
    'defaultcomponents__no_license' => '(niedozwolone przez klucz licencyjny)',
    'plesk_key__validation_failed' => '%1 (Kod błędu: %2)',
    'promo__button_details' => 'Szczegóły',
    'promo__extension_catalog_title' => 'Katalog rozszerzeń',
    'promo__extension_catalog_description' => 'Sprawdź nowy katalog rozszerzeń i doładuj swojego Pleska za pomocą różnych zaawansowanych rozszerzeń!',
    'promo__button_open_catalog' => 'Otwórz katalog',

    'backup__repository_check_login' => "Nie można uzyskać dostępu do dysku: %1\nUpewnij się, że wprowadziłeś poprawne dane logowania do dysku.",
    'backup__repository_check_error_list' => "Nie można uzyskać dostępu do dysku: %1\nUpewnij się, że wprowadziłeś prawidłowe ustawienia dysku.",
    'backup__repository_check_error_mkdir' => "Nie udało się utworzyć katalogu: %1\nSprawdź, czy masz uprawnienia do tworzenia folderów na dysku.",
    'backup__repository_check_error_upload' => "Nie można przesłać pliku na dysk: %1\nSprawdź, czy masz uprawnienia do przesyłania plików na dysk.",
    'backup__repository_check_error_download' => "Nie można pobrać pliku z dysku: %1\nSprawdź, czy masz uprawnienia do przesyłania i pobierania plików z dysku.",
    'backup__repository_check_error_resume-upload' => "Nie można wznowić przesyłania pliku na dysk: %1\nSprawdź, czy masz uprawnienia do wznawiania przesyłania na dysk.",
    'backup__repository_check_error_resume-download' => "Nie można wznowić pobierania pliku z dysku: %1\nSprawdź, czy masz uprawnienia do wznawiania pobierania z dysku.",
    'backup__repository_check_error_enable-utf8' => "Nie można obsługiwać dysku: %1\nSprawdź, czy dysk obsługuje kodowanie UTF8.",
    'backup__repository_check_error_rm' => "Nie można obsługiwać dysku: %1\nSprawdź, czy masz uprawnienia do usuwania plików z dysku.",
    'backup__repository_check_error_rmdir' => "Nie można obsługiwać dysku: %1\nSprawdź, czy masz uprawnienia do usuwania folderów z dysku.",

    'backup__ftp_repository_check_login' => "%1 Możesz je sprawdzić niezależnie poleceniem:\n  %2",
    'backup__ftp_repository_check_error_list' => "%1 Możesz je sprawdzić niezależnie poleceniem:\n  %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Możesz to sprawdzić niezależnie poleceniem:\n  %2",
    'backup__ftp_repository_check_error_upload' => "%1 Możesz to sprawdzić niezależnie za pomocą poleceń:\n  %2\n  %3",
    'backup__ftp_repository_check_error_download' => "%1 Możesz to sprawdzić niezależnie za pomocą poleceń:\n  %2\n  %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Możesz to sprawdzić niezależnie za pomocą poleceń:\n  %2\n  %3\n  %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Możesz to sprawdzić niezależnie za pomocą poleceń:\n  %2\n  %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Możesz to sprawdzić niezależnie poleceniem:\n  %2",
    'backup__ftp_repository_check_error_rm' => "%1 Możesz to sprawdzić niezależnie za pomocą poleceń:\n  %2\n  %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Możesz to sprawdzić niezależnie za pomocą poleceń:\n  %2\n  %3",

    'sfdmarc_server_wide_enable_failed' => 'Nie można zmienić ustawień DMARC. Aby włączyć tę opcję, włącz ochronę przed spamem DKIM i SPF.',
    'spf_server_wide_disable_failed' => 'Nie można zmienić ustawień ochrony przed spamem SPF. Aby wyłączyć SPF, wyłącz DMARC dla poczty przychodzącej.',
    'sfdk_server_wide_verify_disable_failed' => 'Nie można zmienić ustawień ochrony przed spamem DKIM. Aby wyłączyć DKIM, wyłącz DMARC dla poczty przychodzącej.',

    'ccs_not_supported' => 'Centralny dysk certyfikatów usług IIS nie jest skonfigurowany w systemie.',
    'ccs_not_enabled' => 'Zarządzanie centralnym dyskem certyfikatów usług IIS nie jest włączone w Plesku.',
    'ad_not_supported' => 'Serwer nie jest przyłączony do domeny.',

    'component_name__appinit' => "Inicjalizacja aplikacji",
    'component_name__httpcompression' => 'Kompresja treści HTTP',
    'common_feature_is_not_supported' => 'Ta funkcja nie jest już obsługiwana.',
    'common_feature_is_not_supported_in_proto' => 'Ta funkcja nie jest obsługiwana dla wersji protokołu %1.',
    'autoinstaller__plesk_component' => 'Komponent Pleska',
    'plesk_key__key_expired' => 'Twój klucz licencyjny utracił ważność. Aby nadal używać Pleska, kup niewygasającą wersję komercyjną %1.',
    'plesk_key__key_purchase' => 'klucz licencyjny',

    'sa_action_move' => 'Przenieś spam do folderu "Wiadomości śmieci"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Aplikacje Java nie są już obsługiwane. Będą niedostępne dla następujących witryn: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobilne wersje witryn hostowanych przez UNITY Mobile nie są już obsługiwane. Będą niedostępne dla następujących witryn: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Zasady użytkowania zdefiniowane dla całego serwera nie pozwalają na używanie osobistych ustawień antywirusowych. W przypadku kont e-mail w następujących domenach zostaną one przywrócone niecałkowicie: {{objects}}',

    'server_preferences__ip_logging' => 'Logowanie IP',
    'server_preferences__disable_ip_logging' => 'Wyłącz rejestrowanie IP w dziennikach usług IIS, FTP i poczty',
    'server_preferences__disable_ip_logging_description' => 'Jeśli ta opcja jest zaznaczona, usługi IIS i MailEnable nie zapisują już adresów IP w plikach dziennika',

    'module__not_installed' => "Rozszerzenie %1 nie jest zainstalowane",

    'mail__mail_autodiscovery_server_error' => 'Określ niestandardową nazwę domeny na potrzeby automatycznego wykrywania poczty',
    'mail__error_mail_autodiscovery_enable' => 'Nie można ustawić automatycznego wykrywania poczty: %1',
    'mail__error_mail_autodiscovery_server' => 'Nie można ustawić niestandardowej nazwy domeny na potrzeby automatycznego wykrywania poczty: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Nie można ponownie skonfigurować rekordów DNS automatycznego wykrywania domen: %1',

    '__invalid_url' => 'Adres URL \'%1\' jest nieprawidłowy',
    'actionlog__cloning_start' => 'początek',
    'actionlog__event_cloning_start' => 'Rozpoczęcie klonowania serwera',

        '__show_hide_title' => 'Minimalizuj/Odzyskaj',
    '__show_hide_navigation_pane' => 'Schowaj/pokaż panel nawigacyjny',
    '__UPLOAD_ERR_FORM_SIZE' => "Wgrywany plik przekracza dopuszczalną wielkość %1",
    '__UPLOAD_ERR_INI_SIZE' => "Wgrywany plik przekracza dopuszczalną wielkość %1",
    '__UPLOAD_ERR_NO_FILE' => "Nie otrzymano pliku",
    '__UPLOAD_ERR_OK' => "Plik poprawnie wgrany",
    '__UPLOAD_ERR_PARTIAL' => "Plik nie wgrał się do końca, spróbuj ponownie",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Brakuje tymczasowego folderu',
    '__UPLOAD_ERR_CANT_WRITE' => 'Nie udało się zapisać pliku na dysk',
    '__UPLOAD_ERR_UNKNOWN' => 'Wystąpił nieznany błąd wgrywania pliku',
    '__accounts' => "Konta",
    '__access' => "Dostęp",
    '__address' => "Adres",
    '__addresses' => "Adresy",
    '__acl_records' => 'Rekordy ACL',
    '__admin_repository' => "Repozytorium administratora",
    '__all' => 'Wszystko',
    '__allowed' => "Dozwolony",
    '__anonftp_status' => "Anonimowy FTP",
    '__antispam' => "AntySpam",
    '__apache_restart' => "...%1 web-server jest restartowany, proszę czekać...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Obsługa Microsoft ASP.NET",
    '__asp_win_support' => "Obsługa Microsoft ASP",
    '__attachments' => "Załączniki",
    '__attachments_list' => "Załączniki",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Autoresponder o nazwie %1 już istnieje.",
    '__autoresponder' => "Autoresponder",
    '__autoresponders' => "Autorespondery",
    '__autoresponders_list' => "Autorespondery",
    '__autoresponder_attachment_files' => "Pliki załącznika autorespondera",
    '__auto_updates_list' => 'Dostępne aktualizacje',
    '__avail' => "Dostępne",
    '__backup_utilites' => "Narzędzia Archiwizacji",
    '__bind_status' => "Status serwera DNS",
    '__bu_is_not_installed' => "Ta opcja nie jest aktualnie dostępna ponieważ nie zainstalowałeś pakietu narzędzi archiwizacji (backup utilities).",
    '__bu_not_support_in_key' => "Możliwość archiwizacji nie jest dostępna w tym kluczu licencji.",
    '__notifications_not_support_in_key' => 'Powiadamiania nie są wspierane przez ten klucz licencyjny',
    'disabled_by_key' => 'Nie obsługiwane przez ten klucz licencji',
    '__bytes' => "bajty",
    '__can_not_use_reserved_words' => "Nie możesz używać zarezerwowanych słów.",
    '__certificate' => "Certyfikat",
    '__cgi_support' => "Obsługa CGI",
    '__change_date' => "Data modyfikacji",
    '__city' => "Miasto",
    '__cl_not_exist' => "Konto klienta nie istnieje.",
    '__client' => 'Klient',
    '__client_card' => "Wizytówka klienta",
    '__client_contact_name' => "Kontakt",
    '__client_form' => "Informacje osobiste",
    '__client_ip_pool' => "Pula IP klienta",
    '__client_limits' => "Limity konta klienta",
    '__client_permissions' => "Uprawnienia klienta",
    '__client_preferences' => "Ustawienia klienta",
    '__client_status' => "Status klienta",
    '__client_name' => "Nazwa klienta",
    '__client_total' => "Klient ogółem",
    '__client_with_login_name_already_exists' => "Klient o loginie \"%1\" już istnieje.",
    '__client_domuser_with_login_already_exists' => "Nazwa użytkownika '%1' jest już używana przez administratora domeny '%1'.",
    '__clients_global_changes' => "Ogólne operacje na kontach klientów",
    '__clients_list' => "Klienci",
    '__cmd_not_found' => "Nieznane polecenie: %1",
    '__comments' => "Komentarze",
    '__company_name' => "Nazwa firmy",
    '__component_version' => "Wersja składnika",
    '__component_not_installed' => "Komponent %1 nie jest zainstalowany",
    '__confirm_del' => "Musisz potwierdzić usuwanie.",
    '__confirm_overwrite' => "Potwierd nadpisanie.",
    '__confirm_stop' => "Musisz potwierdzić proces zatrzymywania.",
    '__confirm_passwd' => "Potwierdź %1 Hasło",
    '__confirm_removal' => "Potwierdź usuwanie",
    '__conhelp' => "Opis",
    '__contact_name' => "Kontakt",
    '__country' => "Kraj",
    '__countries' => 'Kraj',
    '__country_unknown' => 'Nie można rozpoznać kodu kraju.',
    '__courier-imap' => 'Serwer Courier',
    '__create_domain' => 'Utwórz domenę',
    '__crypted' => 'zaszyfrowany',
    '__cp_access' => "Dostęp do Pleska",
    '__cp_user' => "Użytkownik Plesk",
    '__create' => "Utwórz",
    '__create_client_template_without_template' => "Utwórz klienta bez użycia szablonu",
    '__create_domain_for' => "Utwórz domenę dla <b />%1</b>",
    '__create_domain_template_without_template' => "Utwórz domenę bez użycia szablonu",
    '__creation_date' => "Data utworzenia",
    '__crontab_unix' => "Harmonogram zadań (Scheduler)",
    '__crontab_win' => "Harmonogram zadań (Scheduler)",
    '__ct_month_jan' => 'Styczeń',
    '__ct_month_feb' => 'Luty',
    '__ct_month_mar' => 'Marzec',
    '__ct_month_apr' => 'Kwiecień',
    '__ct_month_may' => 'Maj',
    '__ct_month_jun' => 'Czerwiec',
    '__ct_month_jul' => 'Lip',
    '__ct_month_aug' => 'Sierpień',
    '__ct_month_sep' => 'Wrzesień',
    '__ct_month_oct' => 'Październik',
    '__ct_month_nov' => 'Listopad',
    '__ct_month_dec' => 'Grudzień',
    '__custom_button' => "Własny przycisk",
    '__custom_buttons_list' => "Linki do dodatkowych usług",
    '__daily' => "Dziennie",
    '__database_not_activated' => "%1 nie zostało aktywowane na stronie administracji serwerem.",
    '__database_not_installed' => "Baza danych %1 nie jest zainstalowana.",
    '__database_not_run' => "Baza danych %1 nie działa.",
    '__database_is_corrupt' => "Baza danych Plesk jest uszkodzona. Proszę uruchom narzędzie Rekonfiguracji aby to naprawić.",
    '__databases' => "Bazy danych",
    '__databases_list' => "Bazy danych",
    '__database_type_not_supported_by_key' => 'Aby użyć serwer %1, potrzebujesz jego obsługi w swoim kluczu licencyjnym. Skonsultuj się z przedstawicielem handlowym Plesk.',
    '__date_immediately' => "dzisiaj",
    '__date_never' => "nigdy",
    '__day(s)' => "Dzień/Dni",
    '__day0' => "Nie",
    '__day1' => "Pon",
    '__day2' => "Wto",
    '__day3' => "Śr",
    '__day4' => "Czw",
    '__day5' => "Pią",
    '__day6' => "Sob",
    '__days' => "%1 dni/dzień",
    '__db_admin_login_empty' => "Podałeś pusty login, blokując dostęp do %1 w interfejsie. Czy chcesz kontynuować?",
    '__db_unable_to_unregister' => 'Nie można usunąć parametrów połączenia z bazą danych',
    '__db_db_exists' => 'Jest przynajmniej jedna baza danych na serwerze',
    '__db_unable_to_change_server_name' => 'Nazwa dla serwera nie może zostać zmieniona',
    '__db_unable_to_change_port' => 'Port dla serwera nie może zostać zmieniony',
    '__db_already_exist' => "Baza danych %1 już istnieje.",
    '__db_credentials_invalid' => "Listy uwierzytelniające Bazy Danych sąbłędny.",
    '__db_invalid_password_characters' => 'Hasło zawiera nieprawidłowe znaki',
    '__db_engine' => "Wyszukiwarkę bazy danych", // indirect
    '__db_type' => "Typ bazy danych",
    '__db_user' => "Użytkownik bazy danych",
    '__db_server' => 'Serwer bazy danych',
    '__def_domain' => "Domyślna domena",
    '__default_for_mysql' => 'domyślny dla MySQL',
    '__default_for_mariadb' => 'domyślne dla MariaDB',
    '__default_for_percona' => 'domyślne dla Percona',
    '__default_for_postgresql' => 'domylny dla PostgreS',
    '__delete' => "Usuń",
    '__demo' => "Ta funkcja nie jest dostępna w wersji demonstracyjnej.",
    '__directory' => "Katalog",
    '__disable_lock_screen' => 'Nie pozwalaj użytkownikom na pracę z Pleskiem, dopóki ekrany interfejsu nie będą załadowane',
    '__dismiss_news?' => "Wiadomości nie będą już więcej pokazywane dopóki nie pojawią się nowe artykuły?\n\nJeżeli chcesz zobaczyć jeszcze raz te wiadomości, możesz zminimalizować blok poprzez kliknięcie na jego tytuł.",
    '__description' => "Opis",
    '__disabled' => "Wyłączony",
    '__disk_space_limit' => "Limit przestrzeni dysku",
    '__cgroups_cpu_usage_limit' => 'Limit zużycia procesora',
    '__cgroups_ram_usage_limit' => 'Limit zużycia RAM',
    '__cgroups_disk_read_usage_limit' => 'Limit  szerokości pasma odczytu dysku',
    '__cgroups_disk_write_usage_limit' => 'Limit szerokości pasma zapisu dysku',
    '__disk_usage_by' => "Przestrzeń dysku zużyta przez %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Rekord DNS '%1' już istnieje.",
    '__dns_master_should_be_remote' => "Powinieneś mieć dwie różne nazwy serwerów na różnych hostach.",
    '__dns_record_not_exist' => "Rekord DNS nie istnieje.",
    '__dns_server' => "Serwer DNS", // indirect
    '__dom_id_is_undefined' => "ID domeny jest niezdefiniowane.",
    '__dom_name' => "Nazwa domeny",
    '__dom_name_is_invalid' => "Nazwa domeny jest niepoprawna. Sprawdź czy nazwa Twojej domeny zawiera znaki alfanumeryczne, kropkę i nie jest dłuższa niż 255 znaków. Każda część domeny pomiędzy kropkami nie powinna przekraczać 63 symboli długości.",
    '__dom_not_exist' => "Domena nie istnieje.",
    '__domain' => "Domena",
    '__domain_' => 'Domena %1',
    '__domain_form' => "Formularz domeny",
    '__domain_id' => "Identyfikator domeny",
    '__domain_is_turned_off_for_backup' => "Domena %1 jest czasowo wyłšczona z uwagi na proces archiwizacji/odtwarzania i nie jest dostępna.",
    '__domain_limits' => "Limity domeny",
    '__domain_name' => "Nazwa domeny",
    '__mail_name_in_ASCII_form' => "Nazwa poczty w formacie ASCII",
    '__message_error' => 'Błąd',
    '__message_warning' => 'Ostrzeżenie',
    '__message_info' => 'Informacja',
    '__domain_name_in_ASCII_form' => "Nazwy domeny w formacie ASCII",
    '__domain_repository' => "Repozytorium domeny %1",
    '__domain_status' => "Status domeny",
    '__domain_dns' => 'Strefa DNS domeny',
    '__domain_total' => "Domena ogółem",
    '__domain_total_powerUser' => "Domena ogółem",
    '__domain_user' => "Użytkownik domeny",
    '__domains_global_changes' => "Ogólne zmiany dla domen",
    '__mailnames_global_changes' => "Grupa Operacji w Kontach Poczty",
    '__backup_manager' => 'Menedżer kopii zapasowej',
    '__domains_list' => "Domeny",
    'domains_list__list_header' => "domeny", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Nazwa domeny zawiera prefiks www, chociaż włączono już ten prefiks.\nCzy kontynuować mimo to?",
    '__dovecot' => 'Serwery Dovecot IMAP i POP3',
    '__dsmail' => "Usługa pocztowa",
    '__dsmaillist' => "Usługa list pocztowych",
    '__dsr_db' => "BD",
    '__dsr_dname' => "Nazwa domeny",
    '__dsr_du' => "UD",
    '__dsr_ma' => "AU",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "LP",
    '__dsr_mn' => "KP",
    '__dsr_pname' => "Nazwa klienta",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Rozmiar plików kopii zapasowej w lokalnych przechowalniach",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "Adres e-mail jest błędny.",
    '__enabled' => "włączony",
    '__enter_cert_text' => "Podaj tekst certyfikatu",
    '__enter_size' => "Podaj wielkość",
    '__exclusive' => "Dedykowany",
    '__expiration_date' => "Data ważności",
    '__fax' => "Faks",
    '__file' => "Plik",
    '__file_is_empty' => "Plik jest pusty.",
    '__file_name' => "Nazwa pliku",
    '__file_type' => 'Typ pliku',
    '__filemanager' => "Menedżer plików",
    '__filepath_is_empty' => "Ścieżka do pliku jest pusta",
    '__files_list' => "Pliki",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Ustawienia FTP",
    '__ftp_serv' => "Serwer FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Wczeniej musisz ustawić właciwoci konta FTP!",
    '__ftp_status' => "Status serwera FTP",
    '__full_day0' => "Niedziela",
    '__full_day1' => "Poniedziałek",
    '__full_day2' => "Wtorek",
    '__full_day3' => "Środa",
    '__full_day4' => "Czwartek",
    '__full_day5' => "Piątek",
    '__full_day6' => "Sobota",
    '__full_month1' => "Styczeń",
    '__full_month10' => "Październik",
    '__full_month11' => "Listopad",
    '__full_month12' => "Grudzień",
    '__full_month2' => "Luty",
    '__full_month3' => "Marzec",
    '__full_month4' => "Kwiecień",
    '__full_month5' => "Maj",
    '__full_month6' => "Czerwiec",
    '__full_month7' => "Lip",
    '__full_month8' => "Sierpień",
    '__full_month9' => "Wrzesień",
    '__giga' => "G",
    '__group' => "Grupa",
    '__h' => "H",
    '__hard_disk_quota' => "Limit przestrzeni dysku",
    '__hard_disk_quota_not_supported' => 'wielkość dysku twardego nie jest obsługiwana z powodu konfiguracji systemu plików na serwerze',
    '__header_text_is_invalid' => "Nagłówek tekstu jest błędny.",
    '__help_topic_not_found' => 'Temat pomocy jaki szukasz (%1) nie istnieje.',
    '__hosting' => "Hosting",
    '__hosting_ip_dns_ip_not_equiv' => "Żaden z adresów IP podanych w rekordzie DNS A nie jest równy adresowi IP hostingu.",
    '__hosting_scripting' => "Obsługa skryptów hostingu",
    '__hosting_setup_page_title' => "Ustawienia fizycznego hostingu dla domeny %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Typ hostingu",
    '__hostname' => "Nazwa hosta",
    '__hostname_is_empty' => "Nazwa hosta jest pusta.",
    '__hour(s)' => 'Godzina(y)',
    '__hst_type_incorrect' => "Nazwa hosta jest niepoprawna.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Czas jałowy",
    '__iface' => "Interfejs",
    '__image' => "Obraz",
    '__imap_status' => "Status serwera IMAP",
    '__in' => "Przych",
    '__in_%' => "w %",
    '__incorrect_databases_login_pass' => "Podałeś błędny login lub hasło zapewniające dostęp do bazy danych PostgreSQL.",
    '__incorrect_ip_or_network_address' => 'Adres IP lub sieci jest niepoprawny.',
    '__info' => 'Informacja',
    '__install' => "Instaluj",
    '__install_prefix' => "Prefiks instalacji",
    '__invalid_cert_id' => "Błędny id certyfikatu",
    '__invalid_context' => "Błędny kontekst: %1",
    '__invalid_db_usr_name' => "Nazwa użytkownika bazy danych jest błędna.",
    '__invalid_dir_name' => "Nazwa katalogu jest niepoprawna",
    '__invalid_dom_name' => "Nazwa domeny jest niepoprawna.",
    '__invalid_filename' => "Błędna nazwa pliku. Nie używaj kombinacji pojedynczych cudzysłowów lub \"../\".",
    '__invalid_id' => "Błędny identyfikator.",
    '__invalid_lines_num' => "Niepoprawna wartość liczby linii, dopuszczalne są jedynie cyfry.",
    '__invalid_max_letter_size' => "Maksymalna wielkość listu jest błędna.",
    '__invalid_pdir_name' => "Nazwa chronionego katalogu jest błędna.",
    '__invalid_restart_apache_interval' => "Interwał restartu Apache'a jest błędny.",
    '__invalid_tmpl_name' => "Nazwa szablonu jest błędna.",
    '__invalid_value' => "Wartość jest błędna.",
    '__ip_addr' => "Adres IP",
    '__ip_address_and_mask' => "Adres IP i Maska podsieci",
    '__ip_alias__mask' => "Adres IP i Maska podsieci",
    '__ip_addr_form' => "Formularz adresu IP",
    '__ip_addr_is_invalid' => "Adres IP jest błędny.",
    '__ip_addr_list' => "Adresy IP",
    '__ip_address_does_not_exist' => "Adres IP nie istnieje.",
    '__ip_addresses' => "Adresy IP",
    '__ip_address_and_mask_hint' => 'Np. %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KBajty",
    '__key_for_virtuozzo_only' => "Twój klucz licencji jest przeznaczony jedynie do użycia w środowisku Virtuozzo containers.",
    '__key_limits_exceeding' => "Ta akcja przekracza limity dopuszczone w Twoim kluczu licencji. Jeżeli otrzymałeś tą wiadomość możesz skontaktować się z Twoim sprzedawcą bądź dostawcą w celu wyjaśnienia lub zwiększenia limitów.",
    '__kilo' => "K",
    '__keywords' => 'Słowo kluczowe',
    '__lang_unknown' => 'Nie można rozpoznać języka.',
    '__languages' => 'Język',
    '__learn_more' => 'Dowiedz się więcej',
    '__loading' => 'Ładowanie….',
    '__locales' => "Pakiety językowe",
    '__lists' => "Listy mailingowe",
    '__literal_bytes' => "B",
    '__processing' => "Proszę czekać.<br>Ładowanie",
    '__locale' => "Język interfejsu",
    '__locale_is_not_defined' => "Język interfejsu jest niezdefiniowany.",
    '__local_server_mysql' => 'Lokalny serwer MySQL',
    '__local_server_postgresql' => 'Lokalny serwer PostgreSQL',
    '__local_server_mssql' => 'Lokalny serwer MS SQL',
    '__log_and_statistics_files' => 'Pliki z logami i raporty',
    '__config_files' => 'Pliki konfiguracji',
    '__chroot_files' => 'rodowisko root-owe',
    '__login' => "%1 Login",
    '__login1' => "Login",
    '__login_disabled' => "Login zablokowany",
    '__login_enabled' => "Login odblokowany",
    '__login_incorrect' => "Login jest błędny.",
    '__login_name' => "%1 nazwa loginu",
    '__login_name_is_invalid' => "Login %1 jest błędny.",
    '__logon_time' => "Czas logowania",
    '__ma' => "Aliasy pocztowe",
    '__mail' => "Poczta",
    '__mail_alias_name' => "Nazwa aliasu poczty",
    '__mail_autodiscovery' => 'Automatyczne wykrywanie poczty',
    '__mail_exchanger_name_is_invalid' => "Nazwa serwera wymiany poczty jest niepoprawna.",
    '__mail_groups' => "Grupy pocztowe",
    '__mail_list_engine' => "Oprogramowanie list mailingowych",
    '__mail_name' => "Konto pocztowe",
    '__mail_name_form' => "Formularz skrzynki pocztowej",
    '__mail_names' => "Konta pocztowe",
    '__mail_serv' => "Serwer pocztowy",
    '__mail_user' => 'Użytkownik poczty',
    '__mailgroup' => "Grupa pocztowa",
    '__maillist' => "Lista mailingowa",
    '__maillists' => "Listy mailingowe",
    '__maillist_member' => 'Użytkownik listy',
    '__mailname' => "Konto pocztowe",
    '__mailname_redir_self' => "Adres e-mail nie może być przekierowany na samego siebie.",
    '__max_dom_num_reached_for_cl' => "Maksymalna ilość domen dla tego klienta została osiągnięta.",
    '__max_file_size_available' => "Maksymalna dopuszczalna wielkość pliku %1",
    '__max_subdom_num_reached_for_cl' => "Maksymalna ilość subdomen została osiągnięta przez tego klienta.",
    '__max_subdom_num_reached_for_dom' => "Maksymalna ilość subdomen została osiągnięta dla tej domeny.",
    '__max_subdom_num_reached_for_key' => "Maksymalna ilość subdomen dopuszczalna w kluczu licencji została osiągnięta.",
    '__max_traffic_limit' => "Limity transferu",
    '__maximum_excl_ip_num' => "Konta pocztowe",
    '__mb' => "MB",
    '__mbytes' => "megabajty",
    '__mb_month' => "MB/miesiąc",
    '__mb_sec' => "MB/s",
    '__gb_sec' => "GB/s",
    '__tb_sec' => "TB/s",
    '__mega' => "M",
    '__minute(s)' => 'Minuta(y)',
    '__mls_not_in_key' => "Twój klucz licencji nie dopuszcza wielojęzyczności.",
    '__modification_date' => "Data modyfikacji",
    '__module' => "Rozszerzenie",
    '__month' => "Miesiąc",
    '__month(s)' => "Miesiąc(e)",
    '__month1' => "Sty",
    '__month10' => "Paź",
    '__month11' => "Lis",
    '__month12' => "Gru",
    '__month2' => "Lut",
    '__month3' => "Mar",
    '__month4' => "Kwiecień",
    '__month5' => "Maj",
    '__month6' => "Czerwiec",
    '__month7' => "Lip",
    '__month8' => "Sie",
    '__month9' => "Wrz",
    '__monthly' => "Miesięcznie",
    '__months' => "Miesięcy",
    '__moved_permanently' => 'Przeniesiony na stałe',
    '__mssql' => "Serwer Microsoft SQL",
    '__mssql__server' => "Serwer",
    'mssql__server' => "Nazwa Serwera Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "Nazwa dla serwera nie może zostać zmieniona: jest na nim przynajmniej jedna zainstalowana baza danych.",
    '__mssql_status' => "Status serwera Microsoft SQL",
    '__multiply_login_deny' => "Nie można Ciebie zalogować. Inny użytkownik z tym samym loginem (%1) jest już zalogowany do Plesku.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Status serwera SQL",
    '__mysql_version' => "wersja Mysql",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Status serwera MariaDB",
    '__mariadb_version' => "Wersja MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Status serwera Percona",
    '__percona_version' => "Wersja Percona",
    '__name' => "Nazwa",
    '__name_invalid' => "Nazwa jest błędna.",
    '__nameserver' => "serwer nazw",
    '__network' => "Sieć",
    '__networks' => "Sieci",
    '__no' => "Nie",
    '__no_ip_address_with_properly_type_available' => "Nie można odtworzyć pliku zrzutu ponieważ nie ma odpowiednich adresów IP wymaganych do odtworzenia.",
    '__no_clients_specified' => "Nie wybrano kont klientów.",
    '__no_comments' => "Brak komentarza.",
    '__no_ip_specified' => "Nie podano IP.",
    '__nologin' => "Zabroniono",
    '__none' => "Brak",
    '__not_configured' => "Nie skonfigurowany",
    '__not_implemented_yet' => "Jeszcze nie zaimplementowane",
    '__not_supported_by_ftp' => "(nie obsługiwany przez serwer FTP)",
    '__notification' => "Powiadomienie",
    '__num_displayed' => "wyświetlono %1 z %2",
    '__num_is_invalid' => "Liczba jest błędna.",
    '__object_not_found' => 'Obiekt nie znaleziony: %1',
    '__of_all' => "% ze wszystkich",
    '__off' => "Wył",
    '__ok' => "OK",
    '__old_passwd' => "Stare %1 hasło",
    '__on' => "WŁĄCZ",
    '__others' => "Inne",
    '__other_ip__will_be_added' => 'Inne dostępne adresy IP (zostaną dodane do zbioru IP klienta)',
    '__out' => "Wych",
    '__p' => "P",
    '__passwd' => "%1 Hasło",
    '__passwd_is_invalid' => "%1 hasło jest błędne.",
    '__passwd_not_match' => "Hasła nie są takie same!",
    '__path' => "Ścieżka",
    '__perl_unix_support' => "Obsługa Perl",
    '__perl_win_support' => "Obsługa Perl",
    '__perm_denied' => "Dostęp zabroniony.",
    '__permissions' => "Uprawnienia",
    '__personal_name' => "Imię i Nazwisko",
    '__pg_admin_not_activated' => "PostgreSQL nie został aktywowany na stronie administracji serwerem.",
    '__pg_not_inst' => "PostgreSQL nie jest zainstalowany.",
    '__pg_not_run_or_inst' => "PostgreSQL nie jest zainstalowany bądź nie działa.",
    '__pg_not_support_in_key' => "Klucz licencji nie zawiera obsługi PostgreSQL.",
    '__phone' => "Numer telefonu",
    '__phosting' => "Hosting fizyczny",
    '__php_support' => "Obsługa PHP",
    '__php_run_as_isapi' => "uruchom jako rozszerzenie ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' włšczone",
    '__php_version' => "Wersja PHP",
    '__physical' => "Hosting fizyczny",
    '__plesk_stat_pdir' => "Katalog chroniony '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Statystyki domeny",
    '__plesk_stat_protect' => "Chroń dostęp do statystyk sieciowych używając nazwy użytkownika i hasła FTP",
    '__plesk_stat_protect_install' => "dostępne jako katalog chroniony hasłem '/plesk-stat/webstat/'",
    '__plesk_stat_webstat_not_activate' => "Statystyki WWW nie są włączone.",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Status serwera POP3",
    '__popen_error' => "Pojawił się błąd przy wywołaniu funkcji popen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Status PostgreSQL",
    '__preferences' => "Ustawienia",
    '__account_preferences' => "Ustawienia konta",
    '__interface_preferences_general' => 'Ogólny',
    '__interface_preferences_default' => 'Ustawienia domylnego interfejsu',
    '__interface_preferences_admin' => "Ustawienia Interfejsu Administratora",
    '__interface_template' => 'Szablon dostosowywania interfejsu',
    '__interface_preferences' => "Ustawienia Interfejsu",
    '__proceed?' => "Czy chcesz kontynuować?",
    '__protect_dir_user' => "Użytkownik chronionego katalogu",
    '__protect_dir_users' => "Użytkownicy chronionego katalogu",
    '__protect_dirs' => "Chronione katalogi",
    '__provider_contact_name' => "Nazwa właściciela",
    '__python_unix_support' => "Obsługa Python",
    '__python_win_support' => "Obsługa Python",
    '__quota' => "Ograniczenie",
    '__r' => "R",
    '__reconfigure' => "Rekonfiguruj",
    '__record_type' => "Typ rekordu",
    '__release' => "Wersja",
    '__remote_db_not_supported_by_key' => 'Zdalne bazy danych nie sš obsługiwane przez twój klucz licencyjny.',
    '__remove' => "Usuń",
    '__remove_confirmation' => "Potwierdzenie usuwania",
    '__remove_protection' => 'Usuń zabezpieczenie',
    '__report' => "Raport",
    '__report_auto' => 'Raport dostarczenia',
    '__report_form' => "Formularz raportu",
    '__report_size_na' => "Usługa jest niedostępna",
    '__reports_list' => "Raporty",
    '__requested' => "Żądane",
    '__required_fields' => "Wymagane pola",
    '__resp_name_invalid' => "Nazwa autoodpowiedzi jest nieprawidłowa. Możesz używać tylko liter, kropek, podkreleń oraz spacji.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Nazwa serwera jest niepoprawna.",
    '__screenshots' => 'Zrzuty ekranu',
    '__script_warning' => "Usuwając obsługę skryptów dla tej domeny spowodujesz, że wszystkie skrypty będą wyświetlane jako czysty tekst. Zalecamy usunięcie wszystkich skryptów przyporządkowanych danej domenie.",
    '__sec' => "Sekundy",
    '__second(s)' => "Sekunda(y)",
    '__see_list_of_logged_in' => "Zobacz listę obecnie zalogowanych użytkowników.",
    '__select_certs_to_remove' => "Wybierz certyfikaty do usunięcia.",
    '__select_domains_to_default_host' => "Wybierz domenę domylnš.",
    '__select_domains_to_remove' => "Wybierz domeny do usunięcia.",
    '__type_domain_name_to_add' => "Wpisz nazwę domeny do dodania.",
    '__select_files_to_remove' => "Wybierz pliki do usunięcia.",
    '__select_ip' => "Wybierz adres IP",
    '__select_ip_to_remove' => "Wybierz adresy IP do usunięcia.",
    '__select_domain_template' => "Użyj ustawień z szablonu domeny",
    '__select_templates_to_remove' => "Wybierz szablony do usunięcia.",
    '__server' => "Serwer",
    '__server_total' => "Serwer ogółem",
    '__service' => "Usługa",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Serwer bazodanowy MySQL",
    '__service_description__mysql' => "Serwer bazodanowy MySQL",
    '__service_title__web' => "Serwer WWW",
    '__service_description__web' => "Serwer WWW",
    '__service_title__smtp' => "Serwer SMTP",
    '__service_description__smtp' => "Serwer SMTP",
    '__service_title__mail' => "Serwer IMAP/POP3",
    '__service_description__mail' => "Serwer IMAP/POP3",
    '__service_title__dns' => "Serwer DNS",
    '__service_description__dns' => "Serwer DNS",
    '__service_title__postgresq' => "Serwer bazodanowy PostgreSQL",
    '__service_description__postgresq' => "Serwer bazodanowy PostgreSQL",
    '__service_title__spamassassin' => "Usługa filtrowania spamu SpamAssassin",
    '__service_description__spamassassin' => "Usługa filtrowania spamu SpamAssassin",
    '__services' => "Usługi",
    '__all_services' => "Wszystkie usługi",
    '__sessions' => "Sesje",
    'sessions__feature_ftp_session_manager_not_supported' => "Cecha Sesji FTP nie jest obsługiwana przez obecny serwer FTP",
    '__sessions_list' => "Sesje",
    '__set' => "Włącz",
    '__shared' => "Współdzielony",
    '__shell_access_warning' => "Udostępnianie dostępu do powłoki systemowej (shell) klientom jest ogromnym zagrożeniem dla bezpieczeństwa systemu. Zezwalaj na to tylko wtedy kiedy masz absolutnš pewnoć tego co robisz. Dostępu udzielaj tylko zaufanym klientom. Czy na pewno chcesz dać klientowi dostęp do powłoki ?",
    '__siteapp_not_support_in_key' => "Aplikacje stron nie są wspierane przez klucz licencji",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfiguracja tej aplikacji WWW została ręcznie zmieniona. Aby zapobiegać ręcznym zmianom, konfiguracja poprzez Plesk jest zabroniona.',
    '__site_management' => "Publikacja strony", // indirect
    '__size' => "Rozmiar",
    '__skeleton' => 'Zarządzanie szkieletem',
    '__skins' => 'Skóry',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Status serwera SMTP",
    '__some_fields_are_empty_or_invalid' => "Niektóre pola są puste lub zawierają puste lub niepoprawne wartości.",
    '__spamassassin' => "Filtr spamu",
    '__spamassassin_status' => "Status SpamAssassin",
    '__spamd_status' => 'Status filtrem antyspamowym',
    '__splited_backup' => "(archiwum wielo wolumenowe)",
    '__split_backup_file' => "Stwórz archiwum wielo wolumenowe",
    '__split_backup_size' => "Rozmiar wolumenu",
    '__split_backup_less_than_500' => "Wolumeny poniżej 500 megabajtów nie sš obsługiwane",
    '__ssi' => "SSI",
    '__ssi_support' => "Obsługa SSI",
    '__ssi_with_html' => "użyj SSI dla plików *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Obsługa SSL/TLS",
    '__same_ssl' => "Użyj pojedynczego katalogu do przechowywania treści SSL/TLS i nie-SSL/TLS",
    '__same_ssl_cu' => "Wspólne treści SSL/TLS i nie-SSL/TLS",
    '__state' => "Województwo",

    '__status__Active' => 'Aktywny',
    '__status__active' => 'aktywny',
    '__status__Passive' => 'Wyłączony',
    '__status__passive' => 'Wyłączony',
    '__status__off' => 'Wyłączony',
    '__status__with_parent' => 'Wyłączony',
    '__status__backup_restore' => 'tymczasowo zawieszone dla archiwizacji lub odzyskiwania',
    '__status__admin' => 'zablokowane przez admina',
    '__status__resseler' => 'zablokowane przez sprzedawcę',
    '__status__client' => 'zablokowane przez klienta',
    '__status__unknown' => 'nieokrelony status',

    '__status_of' => "%1 Status",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Serwer Stunnel", // indirect
    '__subdomain' => "Subdomena",
    '__subdomain_name' => "Nazwa subdomeny",
    '__subdomain_name_in_ASCII_form' => "Nazwa poddomeny w formacie ASCII",
    '__subdomains' => "Subdomeny",
    '__domainaliases' => "Aliasy domen",
    '__subdomains_list' => "Subdomeny",
    '__subdomains_not_support_in_key' => "Operacje na subdomenach nie są dostępne w Twoim kluczu licencji",
    '__sys_user_type' => "Użytkownik FTP",
    '__sys_user_type_main' => "Użyj tego samego użytkownika FTP co dla głównej domeny",
    '__sys_user_type_native' => "Stwórz osobnego użytkownika FTP dla tej subdomeny",
    '__t' => "T",
    '__target_domain' => "Docelowa domena",
    '__template' => "Szablon",
    '__template_not_accepted' => "Szablon nie został zaakceptowany: następujące limity zostały przekroczone.",
    '__templates' => "Szablony",
    '__templates_list' => "Szablony",
    '__tera' => "T",
    '__title' => "Tytuł",
    '__tools' => "Narzędzia",
    '__total' => "Ogółem %1",
    '__total_size' => "Całkowity rozmiar",
    '__total_used' => "Ogółem użyto",
    '__traffic' => "Ruch",
    '__traffic_by_client' => "Transfer per klient",
    '__traffic_by_domain' => "Transfer per domena",
    '__traffic_by_service' => "Transfer per usługa",
    '__traffic_history' => "Historia transferu",
    '__unable_change_locale' => "Błąd przy zmianie języka interfejsu: %1",
    '__unable_create_new_dom' => "Nie udało się stworzyć domeny: %1",
    '__unable_define_dom_name' => "Nie można określić nazwy domeny: %1",
    '__unable_define_necessary_properties' => "Nie można określić wszystkich wymaganych parametrów.",
    '__unable_define_properties' => "Nie można określić parametrów: %1",
    '__unable_exec_util' => "Nie można uruchomić narzędzia: %1",
    '__unable_get_dns_a_recs' => "Nie można pozyskać adresów IP rekordów A DNS dla tego hostingu: %1",
    '__unable_get_mbox_quota' => "Nie można okrelić informacji o ograniczeniach skrzynki pocztowej.",
    '__unable_redirect_to_myself' => "Nie można przekierować na siebie samego.",
    '__unable_redirect_to_my_alias' => "Nie udało się przekazać maila na alias.",
    '__default_domain_redirect_to_myself' => "Nie udało się skonfigurować domeny jako domyślnej dla adresu IP:\n wykryto przekierowanie do samej siebie.",
    '__unable_remove_client' => "Nie można usunąć klienta: %1",
    '__unable_set_up_mbox_quota' => "Nie można ustawić ograniczenia zajętości poczty: %1",
    '__unable_setup_pass' => "Nie można ustawić hasła: %1",
    '__unable_to_create_new_account' => "Nie można stworzyć konta: %1",
    '__unable_to_define_db_size' => "Nie można określić wielkości bazy danych.",
    '__unable_to_enable_short_names' => "Nie można pozwolić na użycie krótkich nazwa dla kont POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Nie można przetworzyć przesłanych danych: %1",
    '__unable_to_open_file' => "Nie można otworzyć pliku %1: %2",
    '__unable_to_update_subdomain' => "Nie można wprowadzić zmian dla domeny: %1",
    '__unable_update_cl_data' => "Nie można zaktualizować danych klienta: %1",
    '__unable_update_db_params' => "Nie można zaktualizować parametrów bazy danych: %1",
    '__unable_update_dom_data' => "nie można zaktualizować danych domeny: %1",
    '__undefined' => "niezdefiniowany",
    '__uninstall' => "Odinstaluj",
    '__unknown_error' => "Nieznany błąd",
    '__unlimited_lower' => "Nieograniczone",
    '__unset' => "Zablokuj",
    '__update' => "Aktualizuj",
    '__uploaded_file_is_invalid' => "Wgrywany plik jest błędny: %1",
    '__url' => "URL",
    '__usage' => "Zajętość dysku",
    '__user' => 'Użytkownik',
    '__user_already_logged' => "Inny użytkownik z tym samym loginem (%1) jest już zalogowany do Plesku.",
    '__version' => "Wersja",
    '__aps_license' => "Klucz licencji",
    '__vh_type' => "Typ wirtualnego hosta",
    '__vhosts_apache_status' => "Status serwera WWW",
    '__wrong_charset_conversion' => 'Błędne kodowanie, konwersja z "%1" do "%2" nie jest możliwa',
    '__warning_' => "Uwaga!",
    '__warning_excl_ip_num' => "Dedykowany adres IP",
    '__warning_expiration' => "Data ważności",
    '__web_scripting' => "Skrypty strony", // indirect
    '__web_serv' => "Serwer WWW", // indirect
    '__web_statistic' => "Statystyki WWW", // indirect
    '__webmail' => "Poczta webowa", // +indirect
    '__webstat_not_installed' => "Webalizer nie jest obecnie zainstalowany na serwerze. Skontaktuj się z administratorem aby zainstalował Webalizera.",
    '__webstat_support' => "Statystyki WWW",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Gdy przełšczasz się pomiędzy programami raportujšcymi, wszystkie raporty stworzone przez poprzedni program sš usuwane i tworzone sš nowe z logów przechowywanych na serwerze. Oznacza to, że jeli skonfigurowałe system (w Domeny->nazwa_domeny->Menedżer Logów->Rotacja Logów) tak, aby pliki z logami były trzymane przez miesišc - nowe raporty WWW będš dostępne tylko dla ostatniego miesišca. Czy chcesz przełšczyć na drugi program raportujšcy?",
    '__webstat_perm_denied' => 'Brak uprawnień do zarzšdzania raportami z WWW.',
    '__webuser' => "Użytkownik Web",
    '__sysusers_list' => "Użytkownicy systemu",
    '__sysuser' => "Użytkownik systemu",
    '__weekly' => "Tygodniowo",
    '__whats_new_in_version' => "Co nowego w Plesk %1?",
    '__wrong_hosting_type__none' => 'Nie ma fizycznego hostingu skonfigurowanego w tej domenie %1.',
    '__wrong_hosting_type__std_fwd' => 'Ta domena %1 ma skonfigurowane standardowe przekierowanie. Ta operacja jest dostępna jedynie dla domen z fizycznym hostingiem.',
    '__wrong_hosting_type__frm_fwd' => 'Ta domena %1 ma skonfigurowane przekierowane w ramce. Ta operacja jest dostępna jedynie dla domen z fizycznym hostingiem.',
    '__wu' => "Użytkownicy Stron",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Prefiks WWW został zmieniony. Upewnij się, że odpowiednio zmodyfikowałeś certyfikat SSL/TLS.",
    '__year' => "Rok",
    '__year(s)' => "Rok/lata",
    '__yes' => "Tak",
    '__you' => "Ty",
    '__zip_code' => "Kod pocztowy",
    '__form_normal' => "Normalny",
    '__form_advanced' => "Zaawansowane",

    'admin_ed__edit_administrator_info' => "Edytuj informacje o administratorze",
    'admin_ed__create_default_client' => "Chciałbym utworzyć domyślne konto klienta.",
    'admin_ed__unable_update' => "Nie można zaktualizować informacji o administratorze: %1",

    'auth__update_admin_info' => "Proszę podaj informacje o administratorze. Te informacje są potrzebne by używać %1.",
    'auth__you_not_have_perm' => "Nie masz uprawnień do zarządzania tą domeną.",
    'auth__key_expired_admin' => 'Twoja licencja Plesk wygasła. Aby kontynuować korzystanie z Plesk, odnów licencję lub kup nową.',
    'auth__key_expired_admin_restricted' => 'Twoja licencja Plesk wygasła. Skontaktuj się z usługodawcą, aby kontynuować korzystanie z Plesk.',
    'auth__key_expired_client' => 'Licencja Plesk wygasła. Skontaktuj się z dostawcą usług.',
    'autoinstaller__not_installed' => 'Składnik autoinstaler nie jest zainstalowany.',
    'autoinstaller__release_action' => 'Dostępne operacje',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Aktualizacja do nowej wersji Plesk sterowania',
    'autoinstaller__release_action_update' => 'Aktualizacja lub dodawanie nowych komponentów',
    'autoinstaller__release_action_up2date' => 'Masz aktualną wersję',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Nie zainstalowano',
    'autoinstaller__component_action_update' => 'Dostępne są aktualizacje',
    'autoinstaller__component_action_upgrade' => 'Aktualizacja jest dostępna',
    'autoinstaller__component_action_up2date' => 'Masz aktualną wersję',
    'autoinstaller__component_action_error' => 'Brak aktualizacji',
    'autoinstaller__component_serverbuildtime' => 'Najnowsza wersja',
    'autoinstaller__component_localbuildtime' => 'Twój numer wydania',
    'autoinstaller__component_installed_version' => 'Obecna wersja',
    'autoinstaller__component_available_version' => 'Najnowsza wersja',
    'autoinstaller__component' => 'Komponent',
    'autoinstaller__components' => 'Komponenty',
    'autoinstaller__components_title' => 'komponenty %1',
    'autoinstaller__component_dependency_note' => 'wymaga do instalacji komponentów które wybrałeś',
    'autoinstaller__install_confirm' => 'Tak, chcę zainstalować te komponenty',
    'autoinstaller__install_confirm_request' => 'Proszę zaznaczyć pole aby potwierdzić',
    'autoinstaller__install_title' => 'Potwierdź instalację wybranych komponentów',
    'autoinstaller__key_update_confirm' => 'Potwierd pominięcie instalacji domylnego klucza',
    'autoinstaller__key_update_confirm_request' => 'Zaznacz pole aby potwierdzić.',
    'autoinstaller__key_update_failed' => '<p>Plesk nie potrafi aktualizować klucza licencji.</p><p>%1</p><p>Kontynuowanie aktualizacji bez posiadania poprawnego klucza spowoduje ustawienie klucza domyślnego o ograniczonej funkcjonalności. Administratorzy powinni najpierw zdobyć poprawny klucz licencji przed aktualizacją do nowszej wersji.</p>',
    'autoinstaller__email' => 'Wyślij notkę do',
    'autoinstaller__email_admin' => "Adres e-mail administratora",
    'autoinstaller__email_email' => 'Własny adres e-mail',
    'autoinstaller__release' => 'Nazwa wydania',
    'autoinstaller__releases' => 'Dostępne wydania',
    'autoinstaller__releases_title' => 'Aktualizator Plesk',
    'autoinstaller__select_components_to_install' => 'Wybierz komponent do zainstalowania',
    'autoinstaller__status_error' => 'Błąd: %1',
    'autoinstaller__status_install_error' => 'Instalacja nie może być uruchomiona: %1',
    'autoinstaller__status_install_busy' => 'Instalacja nie może być uruchomiona: ponieważ inna procedura instalacji jest uruchomiona.',
    'autoinstaller__status_install_ok' => 'Instalacja uruchomiona. Zostaniesz poinformowany o jej postępie e-mailem (%1).',
    'autoinstaller__status_query_busy' => 'Instalacja w trakcie.',
    'autoinstaller__status_query_error' => 'Nie można otrzymać statusu aktualizacji: %1',
    'autoinstaller__status_unknown' => 'Nie można uzyskać statusu auto instalatora.',
    'autoinstaller__status_busy' => 'Auto-instalator jest zajęty, proszę czekać.',
    'autoinstaller__configure_title' => 'Ustawienia aktualizacji',
    'autoinstaller__preferences_legend' => 'Ustawienia',
    'autoinstaller__target' => 'Katalog tymczasowy do zapisu',
    'autoinstaller__target_invalid' => "Podaj cieżkę bezwzględnš",
    'autoinstaller__check_updates' => 'Sprawd aktualizację podczas logowania do Plesku',
    'autoinstaller__check_updates_warning' => 'Nowe <a href="%1">aktualizacje </a> dostępne dla %2',
    'autoinstaller__source_type' => 'Typ ródła',
    'autoinstaller__source' => 'ródłowy URL',
    'autoinstaller_source__preferences_legend' => 'Ustawienia',
    'autoinstaller_source__type' => 'Typ ródła',
    'autoinstaller_source__url_invalid' => 'Niewłaciwe ródło',
    'autoinstaller_source__url_invalid_network' => 'Niewłaciwy URL ródłowy (np.: http://source, ftp://source)',
    'autoinstaller_source__url' => 'ródłowy URL',
    'autoinstaller__source_invalid_network' => 'Niewłaciwy adres URL (np: http://source, ftp://source)',
    'backup__repository' => 'Lokalizacja plików kopii zapasowej',
    'backup__error_notify_email' => 'Wysyłaj powiadomienia o błędach jeli jaki wystšpi na e-mail',
    'backup__dump_info' => "Informacje o backupie",
    'backup__dump_file_name_not_defined' => "Nazwa pliku zrzutu jest nieustawiona",
    'backup__local_file' => 'Plik lokalnego backupu',
    'backup__domain_ftp' => 'zdalny serwer FTP',
    'backup__wrong_path' => "Niepoprawna ścieżka do przechowywania plików kopii zapasowej: Nie używaj sekwencji znaków ../../",
    'backup__unable_to_connect_to_ftp_server' => "Nie można połączyć się z serwerem ftp: %1",
    'backup__unable_to_read_file' => 'Odczyt plikukopii zapasowej nie powiódł się.',
    'backup__backup_task_does_not_exist' => "Zadanie backupu nie istnieje, musisz je najpierw utworzyć przez włączeniem.",
    'backup__restore_params' => "Parametry odzyskiwania",
    'backup__confirmation' => "Ostrzeżenie: domena nie będzie dostępna podczas procesu archiwizacji/odtwarzania.",
    'backup__backup_method' => 'Metoda kopii zapasowej',
    'backup__dumpfile_name' => "Nazwa pliku archiwum",
    'backup__dumpfile_name_is_invalid' => "Błędna nazwa pliku archiwum: Używaj jedynie znaków alfanumerycznych, myślnika, kropki i podkreślenia Nie używaj nazw jak opis.* jako nazwy pliku archiwum.",
    'backup__email_required' => "Twój adres e-mail jest wymagany do powiadamianie Cię o postępie trwania archiwizacji/odzyskiwania. Proszę podać swój adres e-mail w parametrach konta.",
    'backup__error_during_backup' => "Nie można utworzyć pliku archiwum: %1",
    'backup__input_email_warning' => "Powinieneś albo podać adres e-mail do powiadomienia lub wyłączyć tę funkcję.",
    'backup__make_download' => "nie przechowuj pliku kopii zapasowej w przechowalni, pobierz je",
    'backup__make_dump' => 'utwórz kopię zapasową i przechowaj ją w lokalnej przechowalni',
    'backup__makedump_to_ftp' => 'utwórz kopię zapasową i trzymaj ją na serwerze FTP',
    'backup__restore_ip' => "Adres IP dla odtwarzania",
    'backup__select_dumpfile' => "Wybierz plik archiwum.",
    'backup__time' => "Czas Backupu",
    'backup__day' => 'Dzień wykonania kopii zapasowej',
    'backup__view_dump_info' => "Pokaż informacje o archiwizacji dla domeny %1",
    'backup__wrong_domain_name' => "Plik archiwum zawiera dane dla domeny %1 i dlatego nie może być odzyskiwany na domenie %2",
    'backup__incorrect_ftp_user_or_passwd' => "Błędny użytkownik FTP lub hasło. Proszę popraw ustawienia konta FTP",
    'backup__access_denied' => "Dostęp zabroniony. Proszę popraw ustawienia konta FTP",
    'backup__restore_from' => "Przywróć %1",
    'backup__domain_session_failed' => 'Domena %1 nie została zarchiwizowana',
    'backup__client_session_failed' => 'Nie wykonano Kopii Zapasowej klienta %1',
    'backup__domain_session_restore_failed' => 'Domena %1 nie jest odzyskana',
    'backup__client_session_restore_failed' => 'Klient %1 nie został odzyskany',
    'backup__domain_session_complete' => 'Domena %1 została zarchiwizowana',
    'backup__domain_session_backup' => 'Archiwizacja domeny %1',
    'backup__client_session_backup' => 'Archiwizacja klienta %1',
    'backup__domain_stop_title' => 'Anulowanie archiwizacji domeny %1',
    'backup__client_stop_title' => 'Anulowanie archiwizacji klienta %1',
    'backup__domain_restore_stop_title' => 'Anulowanie odzyskiwania domeny %1',
    'backup__client_restore_stop_title' => 'Anulowanie odzyskiwania klienta %1',
    'backup__domain_session_backup_stop' => 'Masz zamiar przerwać proces archiwizacji. Plik archiwum nie zostanie stworzony.',
    'backup__backup_stop_confirm' => 'Tak, chcę przerwać proces archiwizacji',
    'backup__restore_stop_confirm' => 'Tak, chce zatrzymać proces odzyskiwania',
    'backup__domain_session_restore' => 'Odzyskiwanie domeny %1',
    'backup__domain_session_restore_stop' => 'Masz zamiar anulować aktywny proces odzyskiwania.',
    'backup__domain_backup_file_info' => 'Informacje o Pliku Archiwum Domeny',
    'backup__domain_backup_file_list' => 'istniejšce pliki archiwum',
    'backup__domain_backup_progress' => 'Postęp archiwizacji domeny %1',
    'backup__domain_restore_progress' => 'Proces odzyskiwania domeny %1',
    'backup__domain_backup_progress_elapsed_time' => 'Czas: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Czas: %1',
    'backup__ip_map_legend' => 'Mapowanie IP',
    'backup__ip_map_list_count' => 'Adresy IP',
    'backup__domain_restore_session_complete' => 'Domena %1 jest odzyskana.',
    'backup__domain_restore_session_complete_message' => 'Domena %1 jest odzyskana.',
    'backup__domain_backup_file_delete' => 'Następujšce pliki archiwum zostanš usunięte:',
    'backup__domain_backup_file_for_remove' => 'Wybierz pliki archiwum jakie chcesz usunšć',
    'backup__backup_overwrite_file_confirm' => 'Potwierdzenie podmiany',
    'backup__backup_overwrite_file_confirm_text' => 'Plik archiwum o nazwie "%1" już istnieje. Czy chcesz go podmienić?',
    'backup__backup_confirm_overwrite' => 'Potwierd zamianę pliku',
    'backup__backup_overwrite_legeng' => 'Zastąp',
    'backup__backup_not_contain_domain' => 'Plik archiwum nie zawiera informacji o domenie %1',
    'backup__backup_not_contain_client' => 'Plik archiwum nie zawiera informacji o kliencie %1',
    'backup__backup_client_info' => "Ustawienia archiwum klienta a szczegóły konta",
    'backup__client_backup_progress' => 'Postęp archiwizacji klienta %1',
    'backup__client_session_complete' => 'Wykonano Kopię Zapasowš klienta %1',
    'backup__client_backup_file_info' => 'Informacje o Pliku Archiwum Klienta',
    'backup__restore_client_info' => "Odzyskaj ustawienia Klienta i szczegóły konta",
    'backup__client_session_restore' => 'Odzyskiwanie Klienta %1',
    'backup__client_db_server_map' => 'Mapowanie Serwerów Baz Danych',
    'backup__domain_db_server_map' => 'Mapowanie Serwerów Baz Danych',
    'backup__client_restore_session_complete_message' => 'Klient %1 został przywrócony.',
    'backup__client_restore_session_complete' => 'Klient %1 został przywrócony.',
    'backup__restore_select_some' => 'Proszę wybrać obiekty jakie chcesz odzyskać.',
    'backup__client_restore_progress' => 'Postęp odzyskiwania danych klienta %1',
    'backup__new_backup' => 'Utworzenie nowej kopii zapasowej',
    'backup__done' => 'Zakończono:',
    'backup__done_domains' => '%1 domen(a) z %2',
    'backup__done_clients' => '%1 klient(ów) z %2',
    'backup__remaining' => 'Pozostało:',
    'backup__remaining_domains' => '%1 domen(a)',
    'backup__remaining_clients' => '%1 klient(ów)',
    'backup__overall_backup_progress' => 'Całkowity postęp archiwizacji',
    'backup__comment_n_a' => 'b/o',
    'backup__command_ignore' => 'Polecenie "%1" jest ignorowane',
    'backup__no_objects' => 'nie ma obiektów do archiwizacji',
    'backup__cli_warning_not_enough_ip' => 'UWAGA: za mało adresów IP aby przeprowadzić domylne mapowanie IP:',
    'backup__local_repository' => "Przechowalnia Pleska",
    'backup__ftp_repository' => 'Przechowywanie FTP',
    'backup__ftp_login' => 'Nazwa użytkownika',
    'backup__ftp_password' => 'Hasło',
    'backup__ftp_directory_hint' => 'Przykład: /myfolder/mybackups',
    'backup__ftp_account_settings' => 'Ustawienia Konta FTP',
    'backup__ftp_account_preferences' => 'Ustawienia Konta FTP',
    'backup__repository_not_exist' => 'Katalog nie istnieje',
    'backup__repository_not_readable' => 'Nie można odczytać danych z podanego katalogu',
    'backup__ftp_repository_not_configure' => 'Aby użyć przechowalni kopii zapasowych FTP, <a href="%1">najpierw określ konto FTP</a>',
    'backup__ftp_repository_list_not_configure' => 'Ustawienia konta nie zostały podane',
    'backup__repository_list_unable_listing' => 'Pobranie listy plików nie powiodło się',
    'backup__ftp_repository_unable_listing' => 'Nie można pobrać listy plików z katalogu "%1":',
    'backup__repository_legend' => 'Przechowywanie plików kopii zapasowej',
    'backup__store_in_repository' => 'Składuj pliki w',
    'backup__local_repository_lable' => 'Lokalne przechowywanie',
    'backup__ftp_repository_lable' => 'Przechowywanie FTP',
    'backup__ftp_repository_not_configure_hint' => '(ustawienia konta nie zostały podane)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(konto FTP nie zostało podane lub mechanizm nie jest wspierany)',
    'backup__ftp_directory_not_exist' => 'Podany katalog nie istnieje',
    'backup__other_user_process_modified' => 'Proces archiwizacji lub proces migracji został zatrzymany przez innego użytkownika.',
    'backup__another_user_exist' => 'Obecnie wykonywana operacja została zainicjowana przez innego użytkownika. Ten użytkownik jest cišgle zalogowany do Plesku.',
    'backup__ftp_repository_wait' => 'Proszę czekać - trwa zbieranie informacji o pzrechowalni FTP',
    'backup__ftp_write_test_failed' => 'Zapis testowych danych na konto FTP nie powiódł się %1:',
    'bt_upload_to_repository' => 'Wgraj pliki do lokalnej przechowalni',
    'bt_new_restore' => "Przywróć",
    'bt_backup_schedule' => "Zaplanowana Archiwizacja",
    'backup_exist_backups' => "Istniejšce pliki archiwum",
    'backup_dialog__page_title' => "Tworzenie Pliku Archiwum",
    'backup_dialog__please_wait' => "Za chwilę rozpocznie się proces archiwizacji. Ta operacja może zająć trochę czasu. Proszę czekać",
    'backup_conf__page_title' => 'Konfiguracja Archiwizacji',
    'bt_accept' => "Akceptuj",
    'bt_access' => "Dostęp",
    'bt_action_log' => "Log akcji",
    'bt_add' => "Dodaj",
    'bt_add_client' => "Dodaj Klienta",
    'bt_database_server_add' => 'Nowy serwer baz danych',
    'bt_add_services' => "Dodaj usługi",
    'bt_anonftp_stats' => "Stat. Anon.FTP",
    'bt_anonymous_ftp' => "Anonimowy FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Załącz",
    'bt_autoinstaller' => 'Aktualizacja',
    'bt_auto-updates' => 'Aktualizacja',
    'bt_back' => "<< Wstecz",
    'bt_backup' => "Archiwum",
    'bt_backup_configure' => "Ustawienia Archiwizacji",
    'bt_buy_certs' => "Kup certyfikaty",
    'bt_blocked_domains' => 'Czarna lista',
    'bt_blocked_domain_add' => 'Dodaj domenę',
    'bt_card' => "Karta",
    'bt_cert' => "Certyfikat",
    'bt_certificates' => "Certyfikaty",
    'bt_change_passwd' => "Zmień hasło",
    'bt_clear' => "Wyczyść",
    'bt_client_templates' => "Szablony klientów",
    'bt_clients' => "Klienci",
    'bt_codepage_change' => 'Zmień stronę kodową',
    'bt_comp_info' => "Informacja o komponentach",
    'bt_configure_maillists' => "Ustawienia listy mailingowej (Mailman)",
    'bt_configure_odbc' => "Ustawienia ODBC",
    'bt_configure' => 'Konfiguruj',
    'bt_copy' => "Kopiuj",
    'bt_copy_move' => "Kopiuj/Przenieś",
    'bt_create' => "Utwórz",
    'bt_create_account' => "Utwórz konto",
    'bt_create_dir' => "Dodaj katalog",
    'bt_create_file' => "Dodaj plik",
    'bt_count_size' => "Rozmiar",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Harmonogram zadań",
    'bt_custom_button_new' => "Dodaj przycisk",
    'bt_custom_buttons' => "Własne przyciski",
    'bt_customize' => "Dostosuj",
    'bt_databases' => "Bazy danych",
    'bt_database_servers' => 'Serwery baz danych',
    'bt_sqlservers' => "Serwery baz danych",
    'bt_db_usr_new' => "Dodaj użytkownika bazy danych",
    'bt_db_new' => "Dodaj bazę danych",
    'bt_db_phpmyadmin' => "Administracja MySQL",
    'bt_dbuser_default' => "Uczyń domyślnym dla DB Webadmin",
    'bt_decline' => "Odmów",
    'bt_default' => "Domyślny",
    'bt_defaultcomponents' => "Usługi Alternatywne",
    'bt_defaults' => "Domyślnie",
    'bt_delete' => "Usuń",
    'bt_directories' => "Chronione katalogi",
    'bt_disable' => "Zablokuj",
    'bt_dns' => "Ustawienia DNS",
    'bt_dns_enable' => 'Włącz',
    'bt_dns_disable' => 'Zablokuj',
    'bt_dns_default' => 'Przywróć ustawienia domyślne',
    'bt_dns_zone_sync' => 'Zastosuj zmiany szablonu DNS',
    'bt_dnsrecord_add' => 'Dodaj rekord',
    'bt_do_backup' => "Archiwum",
    'bt_do_restore' => "Przywróć",
    'bt_do_upload' => "Wgraj",
    'bt_domain_aliases' => "Aliasy domen",
    'bt_domain_templates' => "Szablony domeny",
    'bt_domain_user' => "Użytkownik domeny",
    'bt_domain_user_passwd' => "Hasło użytkownika domeny",
    'bt_domains' => "Domeny",
    'bt_domain_alias_add' => 'Dodaj Alias Domeny',
    'bt_download' => "Pobierz",
    'bt_edit' => "Edytuj",
    'bt_enable' => "Włącz",
    'bt_export' => 'Eksportuj',
    'bt_extras' => "Dodatki",
    'bt_file_manager' => "Menedżer plików",
    'bt_finish' => "Zakończ",
    'bt_ftp_account' => "Właściwości konta FTP",
    'bt_forget_password' => "Zapomniałeś hasła?",
    'bt_fp_ssl_webadmin' => "Admin FP-SSL/TLS",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Statystyki FTP",
    'bt_get_password' => "Przypomnij hasło",
    'bt_global_changes' => "Modyfikuj",
    'bt_help' => "Pomoc",
    'bt_hide_aliases' => "Ukryj Aliasy",
    'bt_hide_toolbar' => 'Ukryj pasek',
    'bt_hide_subdomains' => "Ukryj subdomeny",
    'bt_hide_domainaliases' => "Ukryj Aliasy",
    'bt_home' => "Start",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Zapora',
    'bt_install' => "Instaluj",
    'bt_ip_aliasing' => "Adresy IP",
    'bt_ip_add' => "Dodaj adres IP",
    'bt_ip_pool' => "Pula IP",
    'bt_key_info' => "Informacje na temat licencji",
    'bt_key_buyonline_addons' => 'Zamów dodatki do Plesk',
    'bt_key_buyonline_upgrades' => 'Zamów podniesienie parametrów Plesk',
    'bt_key_buyonline_new' => 'Zamów nowy klucz',
    'bt_key_update' => 'Odzyskaj klucze',
    'bt_key_upload' => 'Zainstaluj klucz',
    'bt_key_download' => 'Pobierz klucz',
    'bt_key_revert' => 'Przywróć klucz',
    'bt_limits' => "Limity",
    'bt_locale_add' => 'Dodaj Lokalizację',
    'bt_locales' => 'Wersje językowe',
    'bt_log_manager' => "Menedżer logów",
    'bt_login' => "Zaloguj",
    'bt_login_vzpp' => "Zaloguj się do Power Panelu",
    'bt_logo' => "Logo i wygląd",
    'bt_logo_send_link' => "Załącz link",
    'bt_logo_send_logo' => "Załącz logo",
    'bt_logout' => "Wyloguj",
    'bt_logrotation' => "Rotacja logów",
    'bt_mail' => "Poczta",
    'bt_mail_alias_add' => "Dodaj alias poczty",
    'bt_mail_aliases' => "Aliasy poczty",
    'bt_mail_group_add' => "Dodaj członka",
    'bt_mail_groups' => "Grupy",
    'bt_mail_name_add' => "Dodaj konto pocztowe",
    'bt_mail_preferences' => "Ustawienia",
    'bt_mail_group' => "Grupa pocztowa",
    'bt_mail_mailbox' => "Skrzynka pocztowa",
    'bt_mail_redirect' => "Przekierowanie",
    'bt_mail_resp_add' => "Dodaj autoodpowiedź",
    'bt_mail_resp_attach_add' => "Dodaj załącznik",
    'bt_mail_resp_files' => "Pliki załącznika",
    'bt_mail_responders' => "Autorespondery",
    'bt_mail_spamfilter' => "Filtr spamu",
    'bt_mail_webmail' => "Poczta webowa",
    'bt_maillist_new' => "Dodaj listę mailingową",
    'bt_maillists' => "Listy mailingowe",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Utwórz archiwum",
    'bt_manage' => "Zarządzaj",
    'bt_master' => "Master",
    'bt_migrate' => 'Migruj',
    'bt_modules_add' => 'Dodaj rozszerzenie',
    'bt_modules_manage' => 'Zarzšdzaj rozszerzeniami',
    'bt_move' => "Przenieś",
    'bt_mimetypes' => 'Typy MIME',
    'bt_mimetype_new' => 'Dodaj typ MIME',
    'bt_new_client' => "Dodaj konto klienta",
    'bt_new_domain' => "Dodaj domenę",
    'bt_next' => "Następny >>",
    'bt_next_page' => "Dalej",
    'bt_network_add' => "Dodaj sieć",
    'bt_notifications' => "Powiadomienia",
    'bt_odbc_dsn_add' => "Dodaj ODBC DSN",
    'bt_off' => "Wył",
    'bt_on' => "Wł",
    'bt_on_off' => "Wł./Wył",
    'bt_pd_new' => "Nowy katalog",
    'bt_pd_user_new' => "Dodaj użytkownika",
    'bt_performance' => 'Wydajność',
    'bt_permissions' => "Uprawnienia",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Ustawienia",
    'bt_prev_page' => "Wstecz",
    'bt_preview' => 'Podgląd strony',
    'bt_print' => "Drukuj",
    'bt_reboot' => "Restartuj",
    'bt_reload' => "Przeładuj",
    'bt_refresh' => "Odśwież",
    'bt_register' => "Zarejestruj",
    'bt_remove' => "Usuń",
    'bt_enable_selected' => 'Włącz',
    'bt_disable_selected' => 'Zablokuj',
    'bt_repair_ip' => "Napraw IP",
    'bt_report' => "Raport",
    'bt_report_auto' => 'Raport dostarczenia',
    'bt_report_auto_new' => 'Dodaj Harmonogram dostarczania',
    'bt_report_new' => "Dodaj layout",
    'bt_reset' => "Zresetuj",
    'bt_restart_services' => "Zarządzanie usługami",
    'bt_save' => "Zapisz",
    'bt_send_by_email' => "Wyślij e-mailem",
    'bt_send_file' => "Wyślij plik",
    'bt_send_mail' => "Wyślij pocztę",
    'bt_send_passwd' => "Wyślij hasło",
    'bt_send_text' => "Wyślij tekst",
    'bt_server' => "Serwer",
    'bt_server_add' => "Dodaj serwer",
    'bt_server_preferences' => "Ustawienia Serwera",
    'bt_servers_list' => "Serwery",
    'bt_sessions' => "Sesje",
    'bt_set' => "Ustaw",
    'bt_set_as_default' => "Ustaw jako domyślny",
    'bt_setup' => 'Ustawienia',
    'bt_show_aliases' => "Pokaż aliasy",
    'bt_show_subdomains' => "Pokaż subdomeny",
    'bt_show_domainaliases' => "Pokaż Aliasy",
    'bt_shutdown' => "Wyłącz",
    'bt_site_apppkgs' => "Skład aplikacji",
    'bt_site_apppool' => "Pula aplikacji",
    'bt_application-pool' => "Aplikacje WWW",
    'bt_site_apps' => "Aplikacje WWW",
    'bt_site_app_add' => "Nowa aplikacja",
    'bt_additional_key_upload' => 'Wgraj nowy klucz',
    'bt_additional_key_download' => 'Pobierz klucz',
    'bt_additional_key_remove' => 'Usuń klucz',
    'bt_additional_key_activate' => 'Aktywuj',
    'bt_site_builder' => "Wsparcie Presence Builder",
    'bt_skeleton' => 'Zarządzanie szkieletem',
    'bt_skins' => 'Skóry',
    'bt_skin_add' => 'Dodaj skórkę',
    'bt_skin_manual' => 'Własne skóry Plesk', // not used
    'bt_skin_download' => 'Pobierz Skórę',
    'bt_skin_replace' => 'Podmień skórę',
    'bt_skip' => 'Pomiń',
    'bt_spamassassin' => "Filtr spamu",
    'bt_spamassassin_train' => "Trening",
    'bt_spamfilter' => "Filtr spamu",
    'bt_sshterm' => 'Terminal SSH',
    'bt_start' => "Początek",
    'bt_stop' => "Zatrzymaj",
    'bt_recycle' => "Odzyskaj",
    'bt_statistics' => "Statystyki",
    'bt_subdomain_new' => "Dodaj poddomenę",
    'bt_subdomains' => "Subdomeny",
    'bt_submit' => "Wyślij",
    'bt_summary_report' => "Raport zbiorczy",
    'bt_support' => "Obsługa",
    'bt_switch' => "Zmień",
    'bt_system_time' => "Czas systemowy",
    'bt_task_new' => "Dodaj zadanie",
    'bt_dom_tmpl_add' => 'Dodaj szablon domeny',
    'bt_cl_tmpl_add' => 'Dodaj szablon klienta',
    'bt_cron_backup' => 'Ustawienia harmonogramu backupu',
    'bt_test' => "Testuj połączenie",
    'bt_text' => "Tekst",
    'bt_touch' => "Utwórz",
    'bt_traffic' => "Ruch",
    'bt_traffic_history' => "Historia transferu",
    'bt_update' => "Aktualizuj",
    'bt_upload' => "Wgraj",
    'bt_upload_from_ftp' => "Wgraj na FTP",
    'bt_virtualdirs' => 'Wirtualne katalogi',
    'bt_virtualdir_new' => 'Dodaj wirtualny katalog',
    'bt_virtualdir_add' => 'Dodaj wirtualny katalog',
    'bt_web_app_new' => "Zainstaluj aplikację Java",
    'bt_web_stats' => "Statystyki stron",
    'bt_web_stats_ssl' => "Statystyki WWW SSL/TLS",
    'bt_web_user_add' => "Dodaj użytkownika WWW",
    'bt_web_users' => "Użytkownicy web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "Ustawienia Statystyk Stron",
    'bt_hidden-referrer-add' => 'Ukryj Więcej Referencji',
    'bt_group-referrer-add' => 'Grupuj Referencje',
    'bt_whats_new_full' => "Pokaż pełną listę zmian",
    'bt_white_list' => "Biała lista",
    'bt_white_list_add' => "Dodaj sieć",
    'cert_add__unable_set_ca_cert' => "Nie można ustawić certyfikatu CA: %1",
    'cert_add__unable_set_cert' => "Nie można ustawić certyfikatu: %1",
    'cert_add__unable_set_private_key' => "Błąd ustawiania klucza: %1",
    'certificates_list__certificate_used_as_default' => "Jeden z certyfikatów jaki chcesz usunąć jest ustawiony jako Certyfikat Domyślny.",
    'certificates_list__certificates_assigned_on_ip' => "Jeden lub kilka certyfikatów są przydzielone do adresów IP/domen.",
    'ch_pass__admin_pass' => "Zmiana Hasło administratora",
    'ch_pass__old_pass' => "Stare hasło",
    'ch_pass__pass_confirm' => "Potwierdź",
    'ch_pass__unable_change_admin_pass' => "Nie można zmienić hasła administratora: %1",
    'check_mail_cycle__aliases' => "Wykryto operacje cykliczne poczty, adres \"%1\" jest zawarty w aliasach nazwy tej skrzynki pocztowej.",
    'check_mail_cycle__autoresponders' => "Wykryto operacje cykliczne poczty, adres \"%1\" jest zawarty w auto-odpowiedziach tej nazwy poczty.",
    'check_mail_cycle__mail_groups' => "Wykryto operacje cykliczne poczty, adres \"%1\" jest zawarty w grupie pocztowej tej nazwy poczty.",
    'check_mail_cycle__mail_name' => "Wykryto operacje cykliczne poczty, adres \"%1\" zgadza się z nazwą tej poczty.",
    'check_mail_cycle__redirect' => "Wykryto operacje cykliczne poczty, adres \"%1\" zgadza się z przekierowaniem tej nazwy poczty.",
    'check_mail_dup__redirect' => "Wykryto duplikujące się przekierowania, adres \"%1\" pokrywa się z przekierowaniem dla tej nazwy skrzynki.",
    'check_mail_dup__mail_groups' => "Wykryto duplikujące się przekierowania, adres \"%1\" jest już zawarty w grupie mailowej tej skrzynki pocztowej.",
    'check_maillist_cycle__admin' => "Wykryto cykl mailowy, adres email Administratora \"%1\" pokrywa się z adresem listy mailingowej.",
    'check_maillist_cycle__member' => "Wykryto cykl mailowy, adres \"%1\" pokrywa się z adresem listy mailingowej.",
    'chk_js__enter_login_and_passwd' => "Podaj login i hasło.",
    'chk_js__enter_login_name' => "Podaj login.",
    'chk_js__enter_passwd' => "Podaj hasło.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detale dla konta %1",
    'cl_limits__cl' => "Limity klienta %1",
    'cl_logo__setup_logo_pref' => "Ustaw właściwości logo dla klienta %1",
    'cl_new__enter_new_cl_data' => "Podaj informacje o nowym kliencie",
    'cl_new__unable_to_sent_notification' => 'Konto użytkownika zostało utworzone, aczkolwiek nie powiodło się wysłanie informacji do klienta: %1',
    'cl_perm__all_ip' => "Wszystkie dostępne IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Wszystkie konta hostingu opartego o IP dla klienta zostaną przeniesione na hosting oparty na nazwach.",
    'cl_perm__allow_client_create_domain' => "Pola jakie starasz się wybrać są jedynie dostępne dla klientów mogących tworzyć domeny.",
    'cl_perm__allow_create_nb_w_ip' => "Klient może tworzyć hosting oparty na nazwach używając %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Pozwól na tworzenie kont hostingowych opartych o IP",
    'cl_perm__available_ips' => "Lista dostępnych IP",
    'cl_perm__change_limits' => "Ustawienia limitów",
    'cl_perm__cl_disk_space' => "Całkowita dostępna przestrzeń dysku",
    'cl_perm__cl_expiration' => "Okres ważności konta klienta",
    'cl_perm__cl_max_box' => "Skrzynki pocztowe",
    'cl_perm__cl_max_db' => "Bazy danych",
    'cl_perm__cl_max_dom' => "Domeny",
    'cl_perm__cl_max_maillists' => "Listy mailingowe",
    'cl_perm__cl_max_subdom' => "Subdomeny",
    'cl_perm__cl_max_traffic' => "Całkowita dostępna wielkość transferu",
    'cl_perm__cl_max_wu' => "Użytkownicy Stron",
    'cl_perm__cl_mbox_quota' => "Maksymalna wielkoć skrzynki pocztowej dla tego użytkownika konta",
    'cl_perm__current_maximum_exp_date' => "Obecnie maksymalna wartość okresu ważności domeny wynosi %1; żądano %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Obecna maksymalna wartoć ograniczeń poczty domeny wynosi %1; żšdano %2",
    'cl_perm__current_total_requested' => "Obecna całkowita wartość limitów domen dla %1 wynosi %2; żądano %3.",
    'cl_perm__current_total_requested_dom' => "Obecna ilość %1 należąca do tego klienta wynosi %2; żądano %3.",
    'cl_perm__disk_space' => "maksymalna pojemność przestrzeni dysku",
    'cl_perm__dashboard_stdgui' => 'Interfejs użytkownika',
    'cl_perm__dashboard' => 'Widok strony głównej',
    'cl_perm__stdgui' => 'Standardowy interfejs',
    'cl_perm__manage_dashboard' => 'Zarządzanie pulpitem',
    'cl_perm__dashboard_and_stdgui' => 'Widok strony głównej oraz widok standardowy są dozwolone',
    'cl_perm__dashboard_only' => 'Jedynie widok strony głównej jest dozwolony',
    'cl_perm__stdgui_only' => 'Jedynie widok standardowy jest dozwolony',
    'cl_perm__edit_cl' => "Uprawnienia klienta %1",
    'cl_perm__exp_date_exceeded' => "Okres ważności jaki starasz się ustawić wykracza poza limit określony dla domen należących do tego klienta.",
    'cl_perm__invalid_value' => "Błędna wartość, jedynie cyfry są dozwolone.",
    'cl_perm__limit_disk_space' => "%1 Ograniczenie całkowitej przestrzeni dysku",
    'cl_perm__limit_expiration' => "%1 Ograniczenie okresu ważności dla konta klienta",
    'cl_perm__limit_max_box' => "%1 Ograniczenie maksymalnej liczby skrzynek pocztowych",
    'cl_perm__limit_max_db' => "%1 Ograniczenie maksymalnej liczby baz danych",
    'cl_perm__limit_max_dom' => "%1 Ograniczenie maksymalnej liczby domen",
    'cl_perm__limit_max_maillists' => "%1 Ograniczenie maksymalnej liczby list mailingowych",
    'cl_perm__limit_max_subdom' => "%1 Ograniczenie maksymalnej liczby subdomen",
    'cl_perm__limit_max_traffic' => "%1 Ograniczenie maksymalnej wielkości transferu",
    'cl_perm__limit_max_wu' => "%1 Ograniczenie maksymalnej liczby użytkowników web",
    'cl_perm__limit_mbox_quota' => "%1 Ograniczenie maksymalnej pojemność poczty",
    'cl_perm__limits_exceeded' => "Jeden lub więcej limitów jakie starasz się ustawić przekracza limity zdefiniowane indywidualnie dla domeny należącej do tego klienta.\nCałkowity limit dla klienta powinien być większy lub równy całkowitej sumie limitów dla domen należących do tego klienta.",
    'cl_perm__mailbox_quota_exceeded' => "Limit pojemności poczty jaki starasz się ustawić przekracza limity zdefiniowane indywidualnie dla domeny należącej do tego klienta.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Limit pojemności poczty jaki starasz się ustawić przekracza limit ustawiony na poziomie serwera.",
    'cl_perm__make_dumps' => "Funkcje archiwizacji/odzyskiwania",

    'cl_perm__max_box' => "maksymalna ilość skrzynek pocztowych",
    'cl_perm__max_db' => "maksymalna ilość baz danych",
    'cl_perm__max_dom' => "domeny",
    'cl_perm__max_maillists' => "maksymalna ilość list mailingowych",
    'cl_perm__max_subdom' => "subdomeny",
    'cl_perm__max_traffic' => "maksymalna wielkość transferu",
    'cl_perm__max_wu' => "maksymalna ilość użytkowników web",
    'cl_perm__max_dom_aliases' => "aliasy domen",
    'cl_perm__mbox_quota' => "quota dla skrzynki",
    'cl_perm__not_allow_create_nb_hst' => "Klient może tworzyć hosting oparty o nazwę.",
    'cl_perm__select_ip_addrs' => "Wybierz adresy IP",
    'cl_perm__this_ip_used_vrt_hst' => "Ten adres(y) IP jest (są) użyty w wirtualnym hostingu.\nBy usunąć ten (te) adres(y) IP, usuń hosting lub zmień jego typ na hosting oparty na nazwach.",
    'cl_perm__unable_off_ipb_creating' => "Klient już posiada ustawienia hostingu opartego o IP. By deaktywować tę możliwość klientowi, odznacz pole \"Tworzenie domen\" lub usuń wszystkie konta hostingu opartego o IP.",
    'cl_perm__unable_off_nb_creating' => "Klient już posiada ustawienia hostingu opartego na nazwach. By zdezaktywować tę możliwość klientowi, oznacz pole \"Tworzenie domen\" lub usuń wszystkie konta hostingu opartego na nazwach.",
    'cl_perm__unable_set_domain_limit' => "Nie można ograniczyć maksymalnej ilości domen: klient już posiada %1 domen",
    'cl_perm__unable_update_client_limitations' => "Nie można zmodyfikować limitów konta klienta: %1",
    'cl_pref__edit_cl' => "Ustawienia klienta %1's",
    'class_anonftp__create_ftp_domain' => "Brak domeny wirtualnego FTP dla dom_id, spróbuj najpierw ją utworzyć.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Ograniczenie przestrzeni dysku dla katalogu przychodzącego, jakie starasz się ustawić (%1) nie powinno przekraczać całkowitego limitu dysku ustawionego na poziomie domeny (%2).",
    'class_anonftp__invalid_input_only_digits' => "Podano błędną wartość, jedynie cyfry są dozwolone.",
    'class_anonftp__unable_change_ownerships' => "Nie można zmienić właściciela lub praw dla pliku quoty: %1",
    'class_anonftp__unable_copy_quota_file' => "Nie można skopiować pliku quoty: %1",
    'class_anonftp__unable_get_disk_usage' => "Nie można uzyskać informacji o zajętości dysku dla katalogu przychodzącego: %1",
    'class_anonftp__unable_parse_quota_file' => "Nie można przetworzyć pliku quoty.",
    'class_anonftp__unable_read_quota_file' => "Nie można odczytać pliku quoty: %1",
    'class_anonftp__unable_update_quota' => "Nie można zaktualizować quoty: plik w katalogu przychodzącym zajmuje %1 KB przestrzeni dysku, co przekracza nową wartość quoty.",
    'class_anonftp__unable_write_temp_file' => "Nie można pisać do pliku tymczasowego: %1",
    'class_bsdomain__warn_max_date__' => "Najdłuższy możliwy okres ważności został ustawiony na %1",
    'class_cList__empty' => "Brak elementów.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Nie znaleziono powiązań dla <b>\"%1\"</b> w %2 (%3 z %4).",
    'class_cList__search_result' => "Wyniki szukania dla <b>\"%1\"</b> w %2 (%3 z %4).",
    'class_client__client_creation_notification' => "Notatka utworzenia klienta.",
    'class_client__client_with_contact_name_already_exists' => "Klient o kontakcie %1 już istnieje.",
    'class_client__disk_space' => "Przestrzeń dyskowa",
    'class_client__invalid_max_dom' => "Błędna liczba ilości domen, tylko liczby są dozwolone.",
    'class_client__limit_exceed' => "Kwota %1 nie może być przydzielona, ponieważ w ten sposób zostanie przekroczony przydział dla konta (%3) użytkownika %2. Jeśli chcesz przydzielić więcej zasobów, przejdź do Klienci > Nazwa klienta > Limity, a nastepnie zmień dane według potrzeby. Następnie wróć do tego ekranu i spróbuj ponownie skorygować przydział.",
    'class_client__limit_exceed_unlimited' => "Jeśli chcesz przydzielić nieograniczoną ilość zasobów (%1), powinieneś najpierw przejdź do Klienci > Nazwa klienta > Limity, a następnie zaznaczyć okienko Nieograniczone, które koresponduje z wymaganym typem zasobu.Następnie wróć do tego ekranu i spróbuj ponownie skorygować przydział.",
    'class_client__max_box' => "Skrzynki pocztowe",
    'class_client__max_db' => "Bazy danych",
    'class_client__max_maillists' => "Listy mailingowe",
    'class_client__max_subdom' => "Subdomeny",
    'class_client__max_traffic' => "Maksymalny transfer",
    'class_client__max_wu' => "Użytkownicy Stron",
    'class_client__max_dom_aliases' => "Aliasy domen",
    'class_client__mbox_quota' => "Quota dla skrzynki",
    'class_client__unable_define_cl_status' => "Nie można określić statusu konta klienta: %1",
    'class_client__unable_define_inactive_dom' => "Nie można określić nieaktywnych domen %1.",
    'class_client__unable_del_ip' => "Nie można usunąć IP: %1",
    'class_db__db_name_not_set' => "Nie zdefiniowano nazwy bazy danych.",
    'class_db__db_not_exist_for_curr_dom' => "Dla tej domeny nie istnieje baza danych.",
    'class_db__invalid_db_or_dom_name' => "ID domeny lub bazy danych jest błędne lub nie podano nazwy bazy danych.",
    'class_db__invalid_pass' => "Hasło jest niepoprawne.",
    'class_db__mailgrp_member_exist' => "Członek grupy pocztowej już istnieje.",
    'class_db__access_hosts_notsupport' => 'Dostęp do ustawień hostów nie jest wspierany przez ten typ bazy danych',
    'class_db__unable_add' => 'Nie udało się dodać rekordu dostępu hosta: %1',
    'class_db__unable_del' => 'Nie można usunšć rekordu dostępu hosta: %1',
    'class_db__inc_user_not_exist' => 'Użytkownik bazy danych "%1" nie istnieje',
    'class_db__inc_access_record_exist' => 'Ten rekord dostępu już istnieje',
    'class_db__inc_access_record_not_exist' => 'Podany rekord dostępu nie istnieje',
    'class_db__inc_unable_del_last_record' => 'Nie można usunšć ostatniego rekordu dostępu hosta',
    'class_domtmpleditform__dns_master' => "Master",
    'class_domtmpleditform__dns_slave' => "Podrzędny",
    'class_domtmpleditform__dns_type' => "Typ strefy DNS domeny",
    'class_traffichistory__no_data_available' => "Brak dostępnych danych.",
    'class_traffichistory__reten_pref' => 'Właciwoci statystyk transferu',
    'class_traffichistory__traffic_usage' => "Użycie transferu",
    'clienttrafficlist_header' => "Transfer dla domen",
    'clienttrafficlist_header_of_client__' => "Transfer dla domen klienta %1",
    'cmd_dns__a_dns_record_already_exist' => "Ten rekord jest w konflikcie z przyczepionym do tej A rekordem.",
    'cmd_dns__domain_last_ns' => 'Nie można usunąć ostatniego rekordu NS DNS dla domeny.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kanoniczna nazwa domeny jest błędna.",
    'cmd_dns__cname_dns_record_already_exist' => "Ten rekord jest w konflikcie z przyczepionym do tej CNAME rekordem.",
    'cmd_dns__cname_in_rr_combination' => 'Wykryto błędną kombinację rekordów w strefie',
    'cmd_dns__cname_coexist_with_data' => 'Rekord CNAME nie może istnieć jednocześnie wraz z innymi rekordami w tej samej strefie.',
    'cmd_dns__dns_record_type_is_invalid' => "Typ rekordu DNS jest niepoprawny.",
    'cmd_dns__ext_host_is_not_resolved' => "Nazwa kanoniczna %1 nie jest zgodna z rekordem A lub AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Nie udało się dodać %1 rekordu do strefy %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Nazwa serwera wymiany poczty jest niepoprawna.",
    'cmd_dns__mx_priority_is_invalid' => "Priorytet MX jest błędny.",
    'cmd_dns__name_server_is_invalid' => "Serwer nazw jest niepoprawny.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Maska sieci powinna wynosić 24, 16 lub 8.",
    'cmd_dns__this_dns_record_already_exists' => "Taki rekord A DNS już istnieje.",
    'cmd_dns__unable_add_record' => "Nie udało się dodać rekordu '%1': %2",
    'cmd_dns__unable_add_a_record' => "Nie można dodać rekordu A: %1",
    'cmd_dns__unable_add_cname_record' => "Nie można dodać rekordu CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Nie można dodać rekordu DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Nie można dodać rekordu EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Nie można dodać rekordu NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Nie można dodać rekordu PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Nie można dodać rekordu TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Nie można stworzyć strefy DNS %1",
    'cmd_dns__unable_define_dns_record' => "Nie można zdefiniować rekordu DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Nie można ustalić statusu domyślnej strefy DNS: %1",
    'cmd_dns__unable_insert_a_record' => "Nie można wstawić rekordu A: %1",
    'cmd_dns__unable_insert_mx_record' => "Nie można wstawić rekordu MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Nie można wstawić rekordu NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Nie można ustawić statusu strefy DNS: %1",
    'cmd_domains__dom_already_exists' => "Domena %1 już istnieje.",
    'cmd_domains__dns_record_already_exists' => "Nie udało się utworzenie domeny %1. Rekord PTR dla hosta %1 już istnieje.",
    'cmd_domains__dom_already_exists1' => "Są %2 subdomeny w tej domenie. Domena %1 już istnieje.",
    'cmd_domains__dom_already_exists2' => "subdomena %1 już istnieje.",
    'cmd_domains__dalias_already_exists' => "Ten alias już istnieje.",
    'cmd_domains__domain_alias_already_exists' => 'Alias domeny o takiej nazwie już istnieje.',
    'cmd_domains__unable_del_mail_for_dom' => "Nie można usunąć usług poczty dla domeny: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Nie można usunąć konta anonimowego FTP dla domeny: %1",
    'cmd_domains__unable_update_dom_param' => "Nie można zaktualizować parametrów domeny: %1.",
    'cmd_domains__unable_rename_client_exist' => "nazwa loginu administratora domeny jest już w użyciu.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Typ hostingu nie jest Fizyczny.",
    'cmd_hosting__unable_create_user' => "Nie można utworzyć użytkownika %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Nie można zdefiniować adresu IP dla wirtualnych hostów: %1",
    'cmd_hosting__unable_del_old_hst' => "Nie można usunąć wcześniej ustawionego hostingu: %1",
    'cmd_hosting__unable_del_protected_directory' => "Nie można usunąć chronionego katalogu: %1.",
    'cmd_hosting__unable_del_web_user' => "Nie można usunąć użytkownika web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Nie można stworzyć lub uaktualnić Wirtualnego Hosta: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Nie można ustawić hostingu przekierowania z ramką.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Nie można przebudować pliku konfiguracji proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Nie udało się ustawić SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Nie udało się usunąć ochrony z katalogu SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Nie można zaktualizować adresu docelowego URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Nie można uaktualnić strefy DNS dla domeny: błąd przy uruchamianiu narzędzia.",
    'cmd_hosting__unable_update_ftp_passwd' => "Nie można uaktualnić hasła FTP %1.",
    'cmd_hosting__unable_update_user' => "Nie można uaktualnić %2: %1",
    'cmd_hosting__unknown_hst_type' => "Nieznany typ hostingu.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Nie masz uprawnień aby przerwać hosting.",
    'cmd_mail__autoresponder__not_configured' => "Auto odpowiedź dla tego konta e-mailowego nie jest skonfigurowana",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adres %1 jest już użyty przy przekierowaniu poczty.",
    'cmd_mail__alias_already_exists' => "alias już istnieje.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID auto-odpowiedzi oraz ID nazwy skrzynki pocztowej nie zgadzajš się.",
    'cmd_mail__autoresp_id_is_undefined' => "ID auto-odpowiedzi jest niezdefiniowane.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Alias konta pocztowego o tej nazwie już istnieje dla tej skrzynki pocztowej %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Nazwa konta pocztowego %1 już istnieje w liście mailingowej.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Nazwa konta pocztowego %1 już istnieje w tej domenie.",
    'cmd_mail__mail_name_not_exist' => "Nazwa poczty nie istnieje.",
    'cmd_mail__mail_name_passwd_part' => "Hasło nie powinno zawierać nazwy poczty jako swojej części.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Lista mailingowa %1 już istnieje w tej domenie.",
    'cmd_mail__mailname_already_exist_in_mg' => "Nazwa konta pocztowego %1 już istnieje w grupie pocztowej.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Nazwa konta pocztowego %1 już istnieje w tej domenie.",
    'cmd_mail__mailname_already_exists' => "nazwa konta pocztowego już istnieje.",
    'cmd_mail__mailname_is_invalid' => "Nazwa poczty %1 jest błędna.",
    'cmd_mail__mailname_unable_update' => "Nie można zmienić nazwy skrzynki:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Maksymalna ilość autoresponderów jest osiągnięta dla tej domeny.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "maksymalna ilość grup pocztowych została osiągnięta dla tej domeny.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "maksymalna iloć przekierowań została osišgnięta dla tej domeny.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "maksymalna ilość skrzynek pocztowych została osiągnięta.",
    'cmd_mail__no_members_specified' => "nie określono członków.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Hasło jest za proste, wybierz inne.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Taki adres już istnieje w grupie pocztowej lub nazwie poczty.",
    'cmd_mail__unable_define_autoresp_id' => "Nie można określić id autorespondera %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Nie powiodła się zmiana ustawień usługi pocztowej dla domeny %1",
    'cmd_mail__unable_del_mail_for_dom' => "Nie można usunąć usługi poczty dla domeny %1.",
    'cmd_mail__unable_del_mail_redirection' => "Nie można usunšć przekierowania poczty %1.",
    'cmd_mail__unable_remove_autoresp' => "Nie można usunąć auto-odpowiedzi: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Nie można usunąć członków grupy pocztowej: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Nie udało się zablokować grupy pocztowej: %1",
    'cmd_mail__unable_update_mail_redirect' => "Nie można zaktualizować przekierowania poczty %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Wielkość wgrywanego pliku jest za duża.",
    'cmd_mail__additionally' => "Dodatkowo:",
    'cmd_pd__invalid_login' => "Błędny login.",
    'cmd_pd__this_user_already_exist' => "Taki użytkownik już istnieje.",
    'cmd_pd__unable_define_hst_type' => "Nie można określić typu hostingu.",
    'cmd_pd__unable_upd_pd_usr' => "Nie można zaktualizować właściwości użytkownika chronionego katalogu: %1.",
    'cmd_pd__user_is_undefined' => "Użytkownik jest nieokreślony.",
    'cmd_server__no_enough_free_disk_space' => "Brak wystarczającego miejsca na dysku.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "stare hasło jest błędne. Proszę, spróbuj ponownie.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "maksymalny limit użytkowników web jest osiągnięty dla tej domeny.",
    'cmd_web_usr__unable_create_user' => "nie można utworzyć użytkownika systemu: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "nie można określić limitu użytkowników web: %1",
    'cmd_web_usr__user_already_exists' => "użytkownik już istnieje.",
    'cmd_web_usr__web_user_name_is_invalid' => "nazwa użytkownika web (%1) jest błędna.",
    'cmd_web_usr__web_user_not_exist' => "użytkownik web nie istnieje.",
    'common_func__exec_bad_argument' => "argument wykonania nie powinien zawierać znaku pojedynczego cudzysłowu.",
    '__eol' => 'Złamania linii',
    'eol__binary_file' => 'Nie można zmienić stylu łamania linii w pliku binarnym.',
    'comp_info__header' => 'Komponenty',
    'comp_info__comp_name' => "Nazwa składnika",
    'comp_info__comp_disabled' => 'Wyłączony',
    'comp_info__comp_active' => 'Aktywny',
    'comp_info__comp_not_configured' => 'Nie skonfigurowany',
    'comp_info__comp_not_started' => 'Nie rozpoczęto, sprawdź ustawienia komponentu',
    'comp_info__comp_version' => "Wersja składnika",
    'comp_info__integration_error' => "Błąd integracji",
    'comp_info__title' => "Komponenty Plesk",
    'comp_info__service_name' => "Usługa",
    'comp_info__last_updated' => '(Ostatni pomiar: %1)',
    'configure__full_hostname' => "Pełna nazwa hosta",
    'cp_access_admin_deny' => "Dostęp dla administratora z adresu '%1' jest ograniczony z uwagi na obecnie włączoną politykę ograniczeń dostępu dla adresów IP.",
    'create_domain_warn__' => "Poniższe wyjątki wystąpiły podczas tworzenia domeny:",
    'create_domain__client_select' => 'Wybierz klienta, dla którego chcesz dodać domenę',

    'dashboard__nav_button_name' => "Start",
    'dalias__list_title' => 'Aliasy domen w domenie %1',
    'dalias__list_legend' => 'Aliasy domen',
    'dalias__list_header' => 'Aliasy domen',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Nazwa aliasu Domeny',
    'dalias__list_ascii_name' => 'W formacie ASCII',
    'dalias__remove_title' => 'Następujšce aliasy domeny %1 zostanš usunięte:',
    'dalias__select_domain_aliases_to_remove' => 'Wybierz alias domeny do usunięcia.',
    'dalias__mail_turn_on_failed' => 'Nie powiodło się uruchomienie usługi poczty: %1',
    'dalias__web_turn_on_failed' => 'Nie powiodło się uruchomienie usługi WWW: %1',
    'db_usr_edit__db_usr_name_old' => "Stara nazwa użytkownika bazy danych",
    'database_server_edit_form__duplicate' => 'Serwer baz danych o tej kombinacji adresu hosta i numeru portu jest już zarejestrowany.',
    'database_server_edit_form__host_is_invalid' => 'Podana nazwa hosta jest nieprawidłowa.',
    'database_server_edit_form__port_is_invalid' => 'Podany numer portu jest nieprawidłowy.',
    'database_server_error__consult_admin' => 'Proszę skontaktować się z administratorem serwera.',
    'database_server_error__last__connection_failed' => 'Ostatnia próba kontroli tego serwera baz danych nie powiodła się z uwagi na problemy z siecią.',
    'database_server_error__last__permission_denied' => 'Ostatnia próba kontroli tego serwera baz danych nie powiodła się z uwagi na to, że podane konto nie ma uprawnienia administratora.',
    'database_server_error__last__credentials_not_set' => "Ostatnia próba połączenia się z serwerem bazy danych nie udała się, ponieważ nie podano poprawnej nazwy użytkownika i hasła administratora.",
    'database_server_error__last__other_error' => 'Ostatnia próba kontroli serwera baz danych nie powiodła się.',
    'database_server_error__real__connection_failed' => 'Połączenie do serwera baz danych nie powiodło się z uwagi na problemy z siecią:',
    'database_server_error__real__permission_denied' => 'Połączenie do serwera baz danych nie powiodło się ponieważ podane login i hasło nie maja praw administratora:',
    'database_server_error__real__duplicate_object' => 'Połączenie do serwera baz danych nie powiodło się z uwagi na błąd w nazwie:',
    'database_server_error__real__unacceptable_name' => 'Połączenie do serwera baz danych nie powiodło się z uwagi na błędną nazwę obiektu:',
    'database_server_error__real__unacceptable_password' => 'Połączenie do serwera baz danych nie powiodło się z uwagi na nieprzyjęcie hasła:',
    'database_server_error__real__credentials_not_set' => "Plesk nie może połączyć się z serwerem bazy danych, ponieważ nie podano poprawnej nazwy użytkownika i hasła administratora.",
    'database_server_error__real__other_error' => 'Połšczenie do serwera baz danych nie powiodło się:',
    'database_server_error__test__connection_failed' => 'Testowe połączenie do serwera baz danych nie powiodło się z uwagi na problemy sieciowe:',
    'database_server_error__test__permission_denied' => 'Testowe połączenie do serwera baz danych nie powiodło się z uwagi na to, że podane dane dostępu nie mają praw administratora:',
    'database_server_error__test__duplicate_object' => 'Testowe połączenie do serwera baz danych nie powiodło się z uwagi na błąd w nazwie:',
    'database_server_error__test__unacceptable_name' => 'Testowe połączenie do serwera baz danych nie powiodło się z uwagi na błędna nazwę obiektu:',
    'database_server_error__test__unacceptable_password' => 'Testowe połączenie do serwera baz danych nie powiodło się z uwagi na nieprzyjęcie hasła:',
    'database_server_error__test__credentials_not_set' => "Ostatni test połączenia się z serwerem nie udał się, ponieważ nie podano poprawnej nazwy użytkownika i hasła administratora.",
    'database_server_error__test__other_error' => 'Testowe połšczenie do serwera baz danych nie powiodło się:',

    'db__create_new_db' => "Dodaj bazę danych",
    'db__db_add' => "Dodaj bazę danych",
    'db__db_for_dom' => "Bazy danych dla domeny %1",
    'db__db_id_undefined' => "ID bazy danych nie jest zdefiniowany.",
    'db__db_name' => "Nazwa bazy danych",
    'db__db_not_exist' => "Baza danych nie istnieje.",
    'db__db_type' => "Typ",
    'db__db_server' => "Serwer bazy danych",
    'db_server_not_exist' => "Serwer bazy danych nie istnieje.",
    'db__db_user_not_exist' => "Użytkownik bazy danych nie istnieje.",
    'db__domain_not_exist' => "Domena nie istnieje.",
    'db__enter_db_name' => "Podaj nową nazwę bazy danych.",
    'db__invalid_db_id' => "Identyfikator bazy danych jest błędny.",
    'db__invalid_db_name' => "Nazwa bazy danych jest błędna. Nazwa bazy danych powinna zawierać jedynie alfanumeryczne symbole, liczby i podkreślenie. Nie może być dłuższa niż 63 znaki.",
    'db__max_db_reached_for_dom' => "Limit ilości baz danych dla tej domeny został osiągnięty.",
    'db__max_mssql_db_reached_for_dom' => "Limit ilości baz danych Serwera Microsoft SQL został osiągnięty dla tej domeny",
    'db__postgres_not_connect_for_admin' => "Nie można się połączyć z PostgreSQL. Włącz obsługę PostgreSQL na stronie administracji serwerem.",
    'db__postgres_not_connect_for_client' => "Nie można się połączyć z PostgreSQL. Zgłoś się do Twojego administratora po pomoc.",
    'db__remove_db_on_domain' => "Poniższe bazy danych dla domeny %2 należącej do klienta %1 zostaną usunięte:",
    'db__remove_db_on_domain_of_cl' => "Bazy danych dla domeny %2 których włacicielem jest klient %1 zostanš usunięte:",
    'db__remove_db_linked_resource' => 'Ta baza danych jest używana przez aplikację WWW. Może zostać usunięta tylko po odinstalowaniu tej aplikacji.',
    'db__remove_db_users' => "Użytkownicy bazy danych %3 dla domeny %2 których włacicielem jest klient %1 zostanš usunięcie:",
    'db__remove_db_users_of_cl' => "Użytkownicy bazy danych %3 dla domeny %2 których włacicielem jest klient %1 zostanš usunięcie:",
    'db__select_db_for_remove' => "Wybierz bazy danych do usunięcia.",
    'db__select_db_users_for_remove' => "Wybierz użytkowników bazy danych do usunięcia.",
    'db__unable_create_db_user' => "Nie można utworzyć użytkownika bazy danych: %1",
    'db__unable_define_db_name' => "Nie można określić nazwy bazy danych: %1",
    'db__unable_define_db_user' => "Nie można określić użytkownika bazy danych: %1",
    'db__unable_define_db_users' => "Nie można określić użytkowników bazy danych: %1",
    'db__unable_select_dom_name' => "Nie można wybrać nazwy domeny: %1",
    'db_edit__db_for_dom' => "Użytkownicy bazy danych %1 dla domeny %2",
    'db_edit__invalid_db_name' => "Nazwa bazy danych jest błędna.",
    'db_edit__no_users' => "Nie znaleziono użytkowników z hasłami przypisanych do tej bazy danych.",
    'db_edit__unable_define_db_usrs' => "Nie można określić użytkowników bazy danych: %1",
    'db_edit__unable_select_db_usr' => "Nie można wybrać użytkownika bazy danych.",
    'db_edit__db_user_password_for_' => "Podaj hasło i zaloguj się do bazy danych %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Dodawanie użytkownika bazy danych",
    'db_usr_edit__db_usr_name' => "Nazwa użytkownika bazy danych",
    'db_usr_edit__edit_db_usr' => "Edycja użytkownika bazy danych",
    'db_usr_edit__for_db' => "dla bazy danych %1",
    'db_usr_edit__not_create_pass' => "Ta akcja utworzy użytkownika bazy danych bez wymaganego hasła.\nCzy życzysz sobie aby utworzyć użytkownika bez hasła?",
    'dbuser__only_one_user_can_be_default' => "Jedynie jeden użytkownik może być ustawiony jako domylny.",
    'db_server__cannot_delete_default' => "Domyślny serwer bazy danych nie może być usunięty.",
    'db_server__cannot_delete_local' => "Lokalny serwer bazy danych nie może być usunięty.",
    'db_server__cannot_delete_used' => 'Serwer bazy danych nie może być usunięty, kiedy istnieją hostowane na nim bazy danych i użytkownicy bazy danych.',
    'demo__disabled_in_demo' => "Edycja tego obiektu jest zablokowana w wersji demo.",
    'defaultcomponents__title' => "Wybieram Usługi Alternatywne",
    'defaultcomponents__select_default' => "Wybierz domyślne komponenty %1",//to check
    'defaultcomponents__not_installed' => "(nie zainstalowane)",
    'defaultcomponents__not_configured' => "(nie skonfigurowany)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Niektóre kategorie usług zawierają błędne zaznaczenia, lub nic nie zaznaczono.",
    'defaultcomponents__depends_on' => "(wymaga %1)",
    'defaultcomponents__parameters' => "Parametry %1",
    'component_name__antivirus' => "Antywirus",
    'component_name__database' => "Serwer SQL",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "Serwer DNS",
    'component_name__firewall' => "Zapora",
    'component_name__ftpserver' => "Serwer FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Serwer Pocztowy",
    'component_name__local_mailserver' => "Serwer lokalnej poczty",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Skrypty",
    'component_name__spamfilter' => "Filtr spamu",
    'component_name__stats' => "Statystyki WWW",
    'component_name__stunnel' => "Tunel SSL/TLS",
    'component_name__webmail' => "Poczta webowa",
    'component_name__webpublish' => "Publikacja strony",
    'component_name__webserver' => "Serwer WWW",
    'dns__dns_record_invalid_values' => 'Podano niepoprawne wartości rekordów DNS: %1: %2',
    'dns__dns_zone_invalid_values' => 'Występując błędne wartości parametrów.',

    'dns__soa_mname_title' => 'Główny serwer nazw',
    'dns__soa_mname_legend' => 'Serwer nazw',
    'dns__soa_mname_autoselect' => '(Automatyczny wybór)',

    'dns__dns_zone_default' => 'Domyślne ustawienia strefy',
    'dns__dns_soa_legend' => 'rekord SOA',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => 'Odśwież',
    'dns__dns_soa_retry' => 'Potwórz',
    'dns__dns_soa_expire' => 'Wygasa',
    'dns__dns_soa_minimum' => 'Minimum',
    'dns__dns_soa_ttl_error' => 'Wartość TTL jest nieprawidłowa. Powinna być z zakresu od 1 sekundy do 68 lat.',
    'dns__dns_soa_refresh_error' => 'Wartość odświeżania jest nieprawidłowa. Powinna być z zakresu od 1 sekundy do 68 lat.',
    'dns__dns_soa_retry_error' => 'Wartość Ponawiania jest nieprawidłowa. Powinna być z zakresu od 1 sekundy do 68 lat.',
    'dns__dns_soa_expire_error' => 'Wartość wygaśnięcia jest nieprawidłowa. Powinna być z zakresu od 1 sekundy do 68 lat.',
    'dns__dns_soa_minimum_error' => 'Wartość minimalna jest nieprawidłowa. Powinna być z zakresu od 1 sekundy do 68 lat.',
    'dns__dns_default_title' => 'Przywróć strefę DNS',
    'dns__dns_default_legend' => "Opcje przywracania strefy",
    'dns__dns_default_text' => "Wybierz opcje przywracania strefy DNS, potwierd je i kliknij OK.",
    'dns__dns_default_confirm' => "Potwierdź przywracanie strefy DNS",
    'dns__dns_default_confirm_required' => "Proszę, potwierdź przywracanie strefy DNS",
    'dns__dns_default_invalid_ip_address' => 'Nieprawidłowy adres IP',

    'dns_t__dns_default_title' => 'Przywróć domylny szablon strefy DNS',
    'dns_t__dns_default_legend' => "Opcje przywracania",
    'dns_t__dns_default_text' => 'Potwierd, że chcesz przywrócić domylnš konfigurację szablonu strefy DNS.',
    'dns_t__dns_default_confirm' => "Potwierd przywrócenie",
    'dns_t__dns_default_confirm_required' => "Proszę potwierdzić przywracanie szablonu strefy DNS",
    'dns_t__dns_zone_off_remove_title' => "Następujące rekordy zasobu dla szablonu strefy DNS zostaną usunięte:",
    'dns_t__dns_zone_master_remove_title' => "Następujące rekordy zasobu zostaną usunięte ze szablonu strefy DNS:",
    'dns_t__add_dns_record_master_title' => 'Dodaj nowy rekord zasobu do szablonu strefy',
    'dns_t__add_dns_record_off_title' => 'Nowy serwer nazw',
    'dns_t__edit_dns_record_master_title' => 'Edytuj rekord zasobów',
    'dns_t__edit_dns_record_off_title' => 'Edytuj serwer nazw',
    'dns_t__select_record_to_remove' => "Zaznacz rekordy z szablonu DNS do usunięcia",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__dns_zone_off_remove_title' => "Następujące rekordy zasobów zostaną usunięte ze strefy %1:",
    'dns__dns_zone_master_remove_title' => "Następujące rekordy zasobów dla strefy DNS %1 zostaną usunięte:",
    'dns__dns_zone_slave_remove_title' => "Następujące rekordy podstawowego serwera nazw dla %1 zostaną usunięte:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Podaj rekord SPF',
    'dns_add__is_spf_syntax' => 'Rekord SPF',
    'dns_add__spf_value_is_invalid' => "Wartość rekordu SPF jest niepoprawna, musi rozpoczynać się od 'v=spf'",
    'dns__dns_zone_status' => "Status strefy DNS.",
    'dns__dns_zone_template' => 'Ustawienia DNS',
    'dns__host' => "Host",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "Adres IP nowego nadrzędnego serwera DNS jest błędny lub pusty.",
    'dns__ip_address' => "Adres IP",
    'dns__master_dns_type' => "ma typ nadrzędnego serwera DNS",
    'dns__masters' => "Nadrzędne serwery DNS",
    'dns__soa_minimum_too_large' => 'Zapamiętywanie negatywnych odpowiedzi na okres dłuższy niż trzy godziny nie jest zalecane.',
    'dns__select_masters_to_remove' => "Wybierz rekordy do usunięcia.",
    'dns__select_template_record_to_remove' => 'Wybierz rekordy do usunięcia.',
    'dns__select_record_to_remove' => 'Zaznacz rekordy zasobów do usunięcia.',
    'dns__nameservers_for_domain' => "Serwery nazwa dla domeny",
    'dns__ns' => "Serwer nazw",
    'dns__ns_record' => "Serwery nazw",
    'dns__remove_dns_zone_of_domain__' => "Usuwanie rekordu DNS z domeny %1",
    'dns__remove_dns_zone_template__' => "Poniższe rekordy zasobów zostaną usunięte z szablonu:",
    'dns__remove_this_dns_record?' => "Czy jesteś pewien, że chcesz usunąć ten rekord DNS?",
    'dns__restore_default' => "Odzyskiwanie strefy DNS z szablonu",
    'dns__restore_default_confirm' => "Odzyskiwanie strefy DNS spowoduje utratę obecnej konfiguracji strefy DNS. Czy kontynuować mimo to?",
    'dns__restore_default_error' => "Błąd odzyskiwania strefy DNS:",
    'dns__slave_dns_type' => "jest drugorzędnym serwerem nazw",
    'dns__soa_refresh_value_is_small' => 'Wartość interwały odświeżania jest mniejsza niż1 godzina, co może drastycznie zwiększyć obciążenie serwera i zużycie zasobów. Kontynuować używając tę wartość?',
    'dns__subdomain_dns_rec_removed' => "Rekord A został usunięty z subdomeny %1.",
    'dns__zone_switched_off_no_ns' => "Strefa została wyłšczona ponieważ brakuje rekordu NS %1 który musi być obecny w strefie. Aby dodać rekord do strefy kliknij przycisk Dodaj rekord.",
    'dns__cant_switch_on_no_ns' => "Strefa nie może zostać włšczona z powodu braku w DNS rekordu %1, który musi zostać dodany do strefy. Aby dodać rekord do strefy kliknij przycisk Dodaj rekord.",
    'dns__type' => "Typ rekordu",
    'dns__unable_activate/deactivate_dns' => "Nie można aktywować/zdezaktywować DNS-u: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Nie można dodać nadrzędnego serwera DNS: zduplikowany wpis.",
    'dns__unable_add_dns_master_local_ip' => "Nie można dodać adresu IP dla głównego serwera DNS: ten rekord powinien być stworzony na zdalnym serwerze.",
    'dns__unable_define_dns_record' => "Nie można zdefiniować rekordu DNS: %1",
    'dns__unable_get_dns_template_status' => "Nie można uzyskać stanu szablonu strefy DNS.",
    'dns__unable_remove_dns_rec' => "Nie można usunąć rekordu DNS: %1",
    'dns__val' => "Wartość",
    'dns__warnings__' => "Rezultat modyfikacji strefy DNS:",
    'dns__you_not_have_perm_manage_dns' => "Nie masz uprawnień by zarządzać strefą DNS dla tej domeny.",
    'dns__zone_record' => "Rekordy DNS",
    'dns__cant_create_record_with_server_ip' => "Nie udało się dodać tego adresu IP, ponieważ jest taki sam, jak adres IP tego serwera zarządzanego przez Plesk.",

    'dns__tabs_acl' => "Transfery strefy",
    'dns__acl_add_network_legend' => "Dodaj sieć",
    'dns__acl_add_ip_legend' => "Dodaj adres IP",
    'dns__acl_network_not_allowed' => "Ten adres sieciowy nie jest dozowolony przez DNS w Windowsie.",
    'dns__acl_enter_ip_address_with_mask' => "Adres IP/maska",
    'dns__acl_enter_ip_address' => "Adres IP",
    'dns__acl_list_network_legend' => "Sieci, które mają dostęp do kopii strefy DNS",
    'dns__acl_list_ip_legend' => "Adresy IP uprawnione do pobrania kopii strefy DNS",
    'bt_dns_acl_add_network' => "Dodaj sieć",
    'bt_dns_acl_add_ip' => "Dodaj adres IP",

    'dns_add__add_rec_for_zone' => "Dodaj %1 dla strefy %2",
    'dns_add__canonical_dom_name_is_invalid' => "Kanoniczna nazwa domeny jest błędna.",
    'dns_add__enter_canonical_name' => "Nazwa kanoniczna",
    'dns_add__enter_dom_name' => "Nazwa domeny",
    'dns_add__enter_ip_address' => "Adres IP",
    'dns_add__enter_ip_mask' => "Podaj IP/maskę",
    'dns_add__enter_mail_domain' => "Domena poczty",
    'dns_add__enter_mail_exchanger' => "Podaj zamiennik poczty",
    'dns_add__enter_nameserver' => "Serwer nazw",
    'dns_add__enter_txt_record' => "rekord TXT",
    'dns_add__enter_service_name' => "Nazwa usługi",
    'dns_add__hint_service_name' => "Przykład: SIP (bez symbolu podkreślenia)",
    'dns_add__enter_protocol' => "Protokół",
    'dns_add__hint_protocol_name' => "Przykład: TCP (bez symbolu podkreślenia)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priorytet",
    'dns_add__specify_weight_of_service' => "Względna waga dla zapisów z tym samy priorytetem",
    'dns_add__enter_target_host' => "Host docelowy",
    'dns_add__hint_target_host' => "Przykład: przykład.com",
    'dns_add__enter_target_port' => "Port docelowy",
    'dns_add__caa_tag' => "Tag",
    'dns_add__caa_value' => "Wartość",

    'dns_add__invalid_ip' => "Adres IP jest błędny.",
    'dns_add__low' => "niski",
    'dns_add__mail_dom_name_is_invalid' => "Nazwa domeny poczty jest błędna.",
    'dns_add__nameserver_is_invalid' => "Serwer nazw jest niepoprawny.",
    'dns_add__record' => "rekord %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Sprecyzuj priorytet serwera wymiany",
    'dns_add__unable_insert_new_dns_rec' => "Nie można wstawić nowego rekordu DNS: %1",
    'dns_add__very_high' => "bardzo wysokie",
    'dns_check__test_dns_zone' => "Testuj strefę DNS %1 na %2",
    'dns_check__unable_get_dom_properties' => "Nie można uzyskać właściwości domeny: %1",
    'dom_ctrl__allowed' => "Dozwolony",
    'dom_ctrl__db' => "Bazy danych MySQL",
    'dom_ctrl__mssql_db' => "Baza Danych MS SQL",
    'dom_ctrl__disk_space' => "Przestrzeń dyskowa",
    'dom_ctrl__dom_adm' => "Domena %1 użytkownika %2",
    'dom_ctrl__dom_cl' => "Domena %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domena ma ustawione przekierowanie na niezdefiniowany adres URL",
    'dom_ctrl__domain_has_frame_forwarding' => "Domena ma przekierowanie w ramce na URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Domena nie ma ustawionego hostingu",
    'dom_ctrl__domain_has_physical_hosting' => "Domena ma fizyczny hosting na IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domena ma podstawowe przekierowanie na URL %1",
    'dom_ctrl__maillists' => "Listy mailingowe",
    'dom_ctrl__mboxes' => "Skrzynki pocztowe",
    'dom_ctrl__mg' => "Przekazywanie poczty",
    'dom_ctrl__resource_name' => "Zasób",
    'dom_ctrl__resp' => "Autorespondery",
    'dom_ctrl__subdom' => "Subdomeny",
    'dom_ctrl__dom_aliases' => "Aliasy domen",
    'dom_ctrl__traffic' => "Ruch",
    'dom_ctrl__unable_activate/deactivate_dom' => "Nie można aktywować/zdezaktywować domeny: %1",
    'dom_ctrl__used' => "Zużyto",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Użytkownicy Stron",
    'dom_pref__bounce_with_phrase' => "Odbij z wiadomością",
    'dom_pref__bounce' => "Odbij",
    'dom_pref__catch_addr' => "Przechwyć do adresu",
    'dom_pref__reject' => 'Odrzuć',
    'dom_pref__confirm_domain_removing' => "Proszę, nie zapomnij poinformować użytkowników domeny o zmianie nazwy domeny. Czy jeste pewien, że chcesz zmienić nazwę domeny?",
    'dom_pref__db_inconsystency' => "nielogiczność bazy danych.",
    'dom_pref__dbs' => "bazy danych",
    'dom_pref__delete_traffic_stat' => "Zachowaj statystyki transferu",
    'dom_pref__delete_traffic_stat_older' => "Zachowaj statystyki transferu",
    'dom_pref__dom_level_name_conflict' => "Jest konflikt między nazwš loginu użytkownika domeny a nazwš jednego z klientów.",
    'dom_pref__invalid_disk_space_limit' => "Niepoprawny limit zajętości dysku. Maksymalną wartością: %1",
    'dom_pref__invalid_expiration_date_limit' => "Niepoprawny okres ważności.",
    'dom_pref__invalid_max_traffic_limit' => "Błędny limit transferu. Maksymalną wartością: %1",
    'dom_pref__limits_of_dom' => "Limity dla domeny %1",
    'dom_pref__mail_grps' => "grupy pocztowe",
    'dom_pref__mail_nonexistent_user' => "Poczta do nieistniejącego użytkownika",
    'dom_pref__mail_redirs' => "przekierowania poczty",
    'dom_pref__mail_resps' => "autorespondery poczty",
    'dom_pref__max_limit_is_invalid' => "%1 jest niepoprawny.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maksymalna ilość %1 jest niepoprawna.",
    'dom_pref__new_limit_less_currently_used' => "%1: żądano - %2, obecnie używane - %3",
    'dom_pref__older_that' => "dla",
    'dom_pref__postboxes' => "skrzynki pocztowe",
    'dom_pref__preferences_of_dom' => "Ustawienia dla domeny %1",
    'dom_pref__redirect_to_itself' => "Domena będzie miała ustawione przekierowanie na siebie samą",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Określiłeś czas przechowywania statystyk dla domeny na okres krótszy niż wynosi całkowita wartość zdefiniowana dla serwera (%1 miesięcy). Okres przechowywania statystyk został ustawiony zgodnie z wartością domyślną dla serwera (%1 miesięcy).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Nie można dodać prefiksu WWW dla domeny: %1",
    'dom_pref__unable_define_physical_hst_param' => "Nie można zdefiniować parametru fizycznego hostingu: %1",
    'dom_pref__unable_rename_domain' => "Nie można zmienić domeny",
    'dom_pref__unable_set_up_mbox_quota' => "Nie można ustawić quoty dla skrzynki pocztowej w tej domenie: %1",
    'dom_pref__unable_set_up_web_user_script' => "Nie można ustawić wykonywania skryptów dla Użytkownika web: %1",
    'dom_pref__unlimited' => "Nieograniczone",
    'dom_pref__web_usrs' => "użytkownicy web",
    'dom_pref__you_already_have_%object' => "Już masz %1",
    'dom_cli__warning_ignore_quota' => 'UWAGA: Opcja "-hard_quota" jest ignorowana: quota dysku twardego nie jest wspierana',
    'dom_user_client_login_exist' => "Nie udało się zapewnić administratorowi domeny dostępu do Plesk w domenie %1: ta nazwa użytkownika jest już używana.",
    'domain__unable_to_turn_on_service' => "Nie udało się włączyć usługi %1.",
    'domains__change_the_status_of_domain?' => "Czy jesteś pewien, że chcesz usunąć status domeny %1?",
    'domains__client_info_hiding_traffic' => "%1 domen, %2 aktywnych domen, %3 zużytego miejsca na dysku",
    'domains__unable_to_change_client_status' => "Nie można zmienić statusu konta klienta: %1",
    'domains__unable_update_apache_settings' => "Nie można uaktualnić ustawień Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Nie masz uprawnień by usuwać domeny.",
    'domains__you_want_change_the_status_of_the_cl??' => "Czy jesteś pewien, że chcesz zmienić status konta klienta?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Jeste pewien, że chcesz przeprowadzić tš operację?",
    'domains_list__unable_remove_doms' => "Nie można usunąć domen: %1",
    'domaintrafficlist_header_of_domain__' => "Transfer dla domeny %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Wybierz alias domeny do usunięcia.',
    'domain_aliases_remove__title' => 'Usuwanie aliasów domeny',
    'domain_aliases__max_aliases_reached_for_dom' => "Limit maksymalnej ilości aliasów dla tej domeny został osiągnięty.",
    'domain_edit__edit_title' => 'Edytuj nazwę aliasu domeny',
    'domain_alias_edit__type' => 'Typ aliasu domeny',
    'domain_aliases__list_header' => 'Aliasy domen',
    'domain_aliases__name' => 'Nazwa',
    'domain_aliases__type' => 'Typ',
    'domain_aliases__type_full' => 'WWW+FTP+Poczta',
    'domain_aliases__type_web_ftp' => 'WWW+ FTP',
    'domain_aliases__page_title' => 'Aliasy domen',
    'domain_aliases__legend' => 'Aliasy domen',
    'domain_alias__domain_exists' => 'Domeny o takiej nazwie już istnieje',
    'domain_alias__subdomain_exists' => 'Poddomena o takiej nazwie już istnieje',
    'domain_alias__dns_record_exists' => 'Rekord DNS o określonej nazwie aliasu domeny już istnieje',
    'domain_alias__domain_alias_exists' => "Alias domeny o takiej nazwie już istnieje",
    'domain_alias__invalid_type_full' => 'Serwer pocztowy nie obsługuje aliasów domeny',
    'domain_alias__redirect_exists' => 'Przekierowanie na samego siebie zostało wykryte.',

    'ds__anonymous_ftp' => "Anonimowy FTP",
    'drweb__pagetitle' => 'Właściwości antywirusa',
    'drweb__drweb' => 'Ochrona antywirusowa poczty',
    'drweb__drweb_direction' => 'Sprawd pocztę pod kštem wirusów',
    'drweb__drweb_direction_off' => 'Nie sprawdzaj w poszukiwaniu wirusa',
    'drweb__drweb_direction_any' => 'Przychodząca i wychodząca poczta',
    'drweb__drweb_direction_from' => 'Tylko poczta wychodząca',
    'drweb__drweb_direction_to' => 'Tylko poczta przychodząca',
    'drweb__disable_reason_key' => 'Program antywirusowy nie jest obsługiwany przez tą licencję.',
    'drweb__disable_reason_perm' => 'Nie masz uprawnień do zarządzania antywirusem.',
    'drweb__disable_reason_install' => 'Program antywirusowy nie jest zainstalowany.',
    'drweb__filters' => 'Filtry Antywirusowe',
    'ds__dns' => "Strefa DNS",
    'ds__mail' => "Poczta",
    'dsr__of_client_title' => "Raport podsumowujący %1",
    'dsr__report_has_been_sent_email' => "Raport został wysłany na adres e-mail: %1",
    'dsr__title' => "Zestawienie dla domeny",
    'dumps_list__deletion_page_title' => "Poniższe pliki archiwum dla domeny %1 zostaną usunięte:",
    'dumps_list__dumpfile_is_invalid' => "Plik %1 nie jest poprawnym plikiem archiwum {$PROD_NAME}.",
    'dumps_list__page_title' => "Przechowywanie plików kopii zapasowej",
    'dumps_upload__page_title' => "Wgrywanie plików kopii zapasowej do przechowalni",
    'dumps_list__repository_is_not_exist' => "Przechowywanie plików kopii zapasowej nie istnieje.",
    'dumps_list__unable_to_remove' => "Nie można usunąć pliku archiwum: %1",
    'dumps_list__dumpfile_can_conflict' => "Nazwa pliku jakš podałe jest w konflikcie z plikiem %1. Proszę podaj inna nazwę pliku.",
    'dusr_ed__allow_dl_usr_access' => "Pozwól na dostęp użytkownika domeny",
    'dusr_ed__information' => "Edytuj użytkownika domeny %1",
    'dusr_ed__locale' => "Język użytkownika domeny",
    'dusr_ed__skin' => "Wygląd interfejsu użytkownika domeny",
    'dusr_ed__personal_information' => 'Informacje osobiste',
    'ess__error' => "Błąd",
    'example__' => "Przykład: %1",
    'extras__allow_certificate_purchasing' => "Pozwól na nabywanie certyfikatów",
    'extras__allow_domain_registration' => "Pozwól na rejestrację domen",
    'extras__allow_extras' => "Pozwól na dodatkowe usługi",
    'extras__buy_new_key' => "Twój obecny klucz licencji nie pozwala Tobie na modyfikację tych obiektów.",
    'extras__setup_services' => "Ustaw dodatkowe usługi",

    'firewallmainform__title' => 'Zarządzanie Zaporą Ogniową',
    'firewallmainform__interfaces_list_legend' => 'Lista interfejsów sieciowych',
    'firewall__interfacelist' => 'Interfejsy sieciowe',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => 'Nazwa interfejsu',
    'interfacelist__type' => 'Typ interfejsu',
    'bt_rule_add' => 'Nowa reguła zapory ogniowej',
    'bt_panic' => 'Tryb Paniki',
    'firewallmainform__rules_list_legend' => 'Lista reguł',
    'firewall__rulelist' => 'Reguły',
    'rulelist__enable' => 'S',
    'rulelist__name' => 'Nazwa',
    'rulelist__allow_input_from_any_port_profiles' => '[Zezwalaj] na przychodzące połączenia od [all] na porcie [%1], profile: [%2]',
    'rulelist__allow_input_from_port_profiles' => '[Zezwalaj] na przychodzące połączenia od [%1] na porcie [%2], profile: [%3]',
    'rulelist__block_input_from_any_port_profiles' => '[Zabraniaj] na przychodzące połączenia od [all] na porcie [%1], profile: [%2]',
    'rulelist__block_input_from_port_profiles' => '[Zabraniaj] na przychodzące połączenia od [%1] na porcie [%2], profile: [%3]',
    'rulelist__description' => 'Opis',
    'ruleeditform__add_title' => 'Dodawanie nowej reguły',
    'ruleeditform__properties' => 'Właściwości reguły',
    'ruleeditform__name' => 'Nazwa reguły',
    'ruleeditform__port' => 'Zezwalaj na połączenia z następującym portem lub portami w tym zakresie',
    'ruleeditform__protocol_tcp' => 'Protokół TCP',
    'ruleeditform__protocol_udp' => 'Protokół UDP',
    'ruleeditform__edit_title' => 'Edytuj regułę zapory ogniowej',
    'ruleeditform__newrule' => 'Nowa reguła',
    'ruleeditform__enabled' => 'Włącz regułę',
    'ruleeditform__profiles_text' => 'Profile',
    'ruleeditform__profiles_domain_text' => 'Domena',
    'ruleeditform__profiles_private_text' => 'Prywatne',
    'ruleeditform__profiles_public_text' => 'Ogólnodostępny',
    'ruleeditform__action' => 'Operacja',
    'ruleeditform__action_allow' => 'Pozwól',
    'ruleeditform__action_deny' => 'Zabroń',
    'ruleeditform__from' => 'Zdalne adresy',
    'ruleeditform__from_add' => 'Dodaj adres IP lub sieć:',
    'ruleeditform__profiles_hint' => 'Musisz wybrać przynajmniej jeden profil.',
    'ruleeditform__port_hint' => 'Na przykład: 1000 lub 1000-1051',
    'ruleeditform__from_hint' => 'Na przykład: 192.168.0.1 lub 192.168.0.0/16',
    'ruleeditform__ip_any' => 'Wszystko',
    'firewall_from_add' => 'Dodaj',
    'firewall_from_remove' => 'Usuń',
    'firewall_from_clear' => 'Wyczyść listę',
    'bt_firewall_from_add' => 'Dodaj',
    'bt_firewall_from_remove' => 'Usuń',
    'bt_firewall_from_clear' => 'Wyczyść listę',
    'ruleeditform__name_is_required' => 'Określ nazwę reguły.',
    'ruleeditform__profiles_is_required' => 'Wybierz przynajmniej jeden profil.',
    'ruleeditform__invalid_action' => 'Podane działanie jest niepoprawne. Możliwe wartości to "Zezwalaj" lub "Odmów".',
    'ruleeditform__invalid_ip' => 'Podany adres IP lub sieć są niepoprawne.',
    'ruleeditform__invalid_protocol' => 'Podany protokół jest niepoprawny. Możliwe wartości to "udp" lub "tcp".',
    'ruleeditform__invalid_port' => 'Podany port jest niepoprawny. Możliwe wartości to 1000 lub 1000-1051',
    'firewall__panic_configuration' => 'Czy na pewno chcesz włączyć Tryb Paniki? Użytkownicy nie będą mogli wejść na swoje domeny.',
    'firewall__reset_configuration' => 'Czy na pewno chcesz przywrócić domyślne ustawienia zapory ogniowej?',
    'rulelist__remove_selected' => 'Czy na pewno chcesz usunąć wybrane reguły?',

    'filemanager__items' => 'elementy w katalogu %1',
    'filemanager__items_paging' => 'elementy w katalogu %1',

    'get_password__encrypted_password' => "Nie udało się wysłać informacji o hale: przetrzymywane hasło jest zakodowane.",
    'get_password__mail_error' => "Wystąpił błąd podczas próby wysłania hasła na adres e-mail %1: %2",
    'get_password__mail_ok' => "Hasło zostało wysłane na e-mail: %1",
    'get_password__message' => "Twoja nazwa loginu do dostępu do systemu: %1\nTwoje hasło do %2",
    'get_password__subject' => "Hasło dostępu do systemu",
    'groups__available' => "Dostępne grupy pocztowe",
    'groups__groups_for_mailname' => "Grupy pocztowe dla nazwy poczty %1",
    'groups__member_of' => "Członek następujących grup pocztowych",
    'help__help_area' => "Obszar pomocy.",
    'hst_def__auth_disabled' => "wyłączona",
    'hst_def__auth_enabled' => "włączona",
    'hst_def__change_curr_dns_ip' => "Obecny adres IP rekordu DNA A zostanie zmieniony",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Żaden z adresów IP rekordu DNS A nie pasuje do adresu IP przypisanego do tworzonego konta hostingowego",
    'hst_def__dest_url' => "Docelowy URL",
    'hst_def__disk_quota' => "Ograniczenie dysku",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Limit przestrzeni dysku jaki starasz się ustawić jest przekroczony przez limit dla katalogu przychodzącego anonimowego FTP. Limit przestrzeni dysku dla katalogu przychodzącego anonimowego FTP nie może przekraczać limitu przestrzeni dysku dla domeny.",
    'hst_def__frame_forwarding_definition' => "Przypisanie przekierowania w ramce dla domeny %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Ostrzeżenie: Użytkownik FTP %1 jest użyty w koncie hostingu ale nie istnieje w systemie.",
    'hst_def__hst_type_is_not_defined' => "Typ hostingu nie jest określony",
    'hst_def__ip_based' => "Oparty o IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Przeniesienie Twojego konta hostingowego na współdzielony adres IP spowoduje, że anonimowe FTP stanie się niedostępne. Czy kontynuować mimo to?",
    'hst_def__password_is_invalid_password_syntax' => "Hasło jest błędne.\nNie używaj pojedynczego cudzysłowu ani znaków narodowych w haśle.\nDługość hasła powinna być między 5 a 14 znaków i. Hasło nie powinno zawierać nazwy użytkownika.",
    'hst_def__shell' => "Dostęp do powłoki serwera po SSH z wykorzystaniem praw użytkownika subskrypcji",
    'hst_def__shell_windows' => "Zdalny dostęp do serwera z wykorzystaniem użytkownika systemu subskrypcji",
    'hst_def__standard_forwarding_definition' => "Przypisanie standardowego przekierowania dla domeny %1",
    'hst_def__title_name_based' => "Wirtualny",
    'hst_def__unable_create/update_physic_hst' => "Nie można stworzyć/zaktualizować fizycznego hostingu: %1",
    'hst_def__unable_create/update_std_fwd' => "Nie można stworzyć/zaktualizować standardowego przekierowania: %1",
    'hst_def__unable_create_forwarding_myself' => "Nie można stworzyć przekierowania na tą samą domenę.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Nie udało się zezwolić na użycie pojedynczego katalogu z przechowywania treści SSL/TLS i nie-SSL/TLS: obsługa SSL/TLS nie jest włączona.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Nie udało się włączyć obsługi SSL/TLS: brak zainstalowanego certyfikatu SSL/TLS.",
    'hst_def__url_is_invalid' => "URL jest błędny.",
    'hst_def__virtual_host_access' => "Dostęp wirtualnego hosta dla domeny %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "UWAGA. Ten wirtualny host używa nieistniejącego adresu IP do hostingu.",
    'hst_def__you_have_no_ips' => "Nie masz dostępnych adresów IP i nie masz uprawnień do tworzenia hostingu opartego na nazwach.",
    'hst_sel__header' => "Aby hostować stronę na tym serwerze, wybierz opcję Hosting fizyczny.\n Aby ustawić przekierowanie domeny na stronę na innej maszynie, wybierz Przekierowanie w ramce lub opcję Przekierowanie standardowe.\n Przy standardowym przekierowaniu użytkownik jest przerzucany na stronę i zmienia się adres URL widoczny w polu przeglšdarki, a zatem użytkownik wie, że został przekierowany do innego adresu URL. W przekierowaniu z ramkš użytkownik jest przekierowany nie wiedzšc, że strona znajduje się w innej lokalizacji.",
    'hst_sel__physical_hst' => "Hosting fizyczny",
    'hst_sel__select_hst_type' => "Wybierz typ hostingu dla domeny",
    'hst_sel__select_hst_type_warning' => "Wybierz typ hostingu dla domeny",
    'hst_sel__hosting_exists' => "Nie można utworzyć hostingu, ponieważ jest już skonfigurowany dla tej domeny. Zostaniesz przekierowany do strony zarzšdzania hostingiem.",
    'hst_sel__standard_frw' => "Standardowe przekierowanie",
    'hst_sel__frame_frw' => "Przekierowanie przez ramkę",
    '__frame_frw' => "Przekierowanie przez ramkę",
    '__hosting_exists' => "Nie można utworzyć hostingu, ponieważ jest już skonfigurowany dla tej domeny. Zostaniesz przekierowany do strony zarzšdzania hostingiem.",
    '__choose_hst_type' => "Zaznacz rodzaj hostingu.",
    '__no_hst_conf' => "Nie ma skonfigurowanego hostingu dla tej domeny.",
    '__physical_hst' => "Hosting fizyczny",
    '__select_hst_type' => "Wybierz typ hostingu dla domeny",
    '__standard_frw' => "Standardowe przekierowanie",
    '__warning' => "Uwaga! Wszystkie poprzednie ustawienia zostaną stracone. Czy na pewno chcesz utworzyć taki rodzaj hostingu?",
    'i_cl_off' => "Klient jest nieaktywny.",
    'i_cl_off_by_admin' => "Konto klienta wyłączone przez administratora.",
    'i_cl_off_expired' => "Ważność konta klienta wygasła.",
    'i_cl_on' => "To konto użytkownika nie jest zablokowane.",

    'icf__title' => 'Zapora Ogniowa Połączeń Internetowych',
    'icf__if_legend' => 'Interfejsy',
    'icf__mode' => 'Tryb',

    'invalid_value' => 'Wartość jest błędna',

    'ip_addr__already_exists' => "Adres IP %1 już istnieje.",
    'ip_addr__cant_add' => "IP %1 nie istnieje lub należy do puli adresów innego klienta",
    'ip_addr__cl_list_for_ip' => "Sprzedawcy używający adresu IP %1 - %2",
    'ip_addr__cl_list_for_ip_add' => "Dodaj adres IP do puli sprzedawcy",
    'ip_addr__domains_list_for_ip' => "Serwisy używające adresu IP %1 - %2",
    'ip_addr__ip_used_by_hst_or_frw' => "Adres IP %1 jest użyty do hostingu lub przekierowania.",
    'ip_addr__only_one_ip_and_client_have_domain' => "Usunięcie adresu IP nie powiodło się ponieważ istnieją domeny hostowane na tym adresie.",
    'ip_addr__remove_ip_addr' => "Poniższe adresy IP zostaną usunięte z systemu:",
    'ip_addr__select_clients' => "Wybierz klientów",
    'ip_addr__select_ip_addr_to_remove' => "Wybierz adres IP do usunięcia.",
    'ip_addr__unallowed_by_license' => "Ta kopia Pleska nie ma licencji do działania na adresie IP %1.\nDozwolone zakresy IP: %2.",
    'ip_alias__interface' => "Interfejs",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "Adres IP %1 dla hostingu opartego na nazwach jest błędny.",
    'ip_alias__invalid_ip_or_netmask' => "Błędna para adres IP/maska sieci.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Adres IP %1 jest podstawowym adresem serwera - nie można go usunšć.",
    'ip_alias__ip_is_invalid' => "Adres IP %1 jest błędny.",
    'ip_alias__ip_mask_is_invalid' => "Maska IP %1 jest błędna.",
    'ip_alias__ip_not_exist' => "Adres IP %1 nie istnieje.",
    'ip_alias__ip_address_and_mask' => 'Adres IP i Maska podsieci',
    'ip_alias__mask' => "Maska podsieci",
    'ip_alias__remove_selected_ip_aliases?' => "Czy jesteś pewien, że chcesz usunąć wybrane aliasy adresów IP?",
    'ip_alias__select_ip' => "Wybierz przynajmniej jeden adres IP z listy do usunięcia.",
    'ip_alias__this_ip_used_for_domain' => "(%1) ten adres IP jest użyty dla domeny %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "Ten adres IP (%1) jest użyty do hostingu opartego na nazwach.",
    'ip_alias__unable_add_ip' => "Nie można dodać aliasu IP: %1",
    'ip_alias__unable_remove_ip' => "Nie można usunąć aliasu(ów) IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Nie możesz zmienić typu adresu IP na współdzielony, jako że wyłączy to anonimowy FTP dla domeny '%1'.",
    'ip_ctrl__ip_addr' => "Adres IP %2 w interfejsie %1",
    'ip_ctrl__ip_exists_many_pools' => "Nie możesz zmienić typu IP. Adres IP należy obecnie do puli kilku klientów.",
    'ip_ctrl__ssl_cert' => "Certyfikat SSL/TLS",
    'ip_pool__ip_address_is_absend_in_pool' => "Brakuje adresu IP.",
    'ip_pool__ip_pool_for_client' => "Pula IP dla klienta %1",
    'ip_pool__no_cliens_avail' => "Nie ma żadnych klientów.",
    'ip_pool__no_vacant_ips' => "Nie ma wolnych IP.",
    'ip_pool__pool_is_empty' => "Pula IP klienta jest pusta.",
    'ip_pool__remove_ip_addr' => "Poniższe adresy IP zostaną usunięte z puli %1:",
    'ip_pool__select_free_ips' => "Wolne adresy IP",
    'limit__date_in_past' => "Okres ważności jest błędny. %1 jest w przeszłości.",
    'limit__enter_date' => "Podaj datę",
    'limit__max_db' => "Bazy danych",
    'limit__name_disk_space' => "przestrzeń dyskowa",
    'limit__name_max_box' => "skrzynki pocztowe",
    'limit__name_max_db' => "Bazy danych MySQL",
    'limit__name_max_dom' => "domeny",
    'limit__name_max_maillists' => "listy mailingowe",
    'limit__name_max_subdom' => "subdomeny",
    'limit__name_max_traffic' => "transfer",
    'limit__name_max_wu' => "użytkownicy web",
    'limit__name_mbox_quota' => "quota dla skrzynki",
    'limit__name_max_mn' => "konta pocztowe",
    'limit__name_max_cl' => 'klienci',
    'limit__name_total_mboxes_quota' => "Wielkość wszystkich skrzynek pocztowych",
    'limit__name_mysql_dbase_space' => "Przestrzeń dla baz danych MySQL",
    'limit__name_mssql_dbase_space' => "Przestrzeń dla baz danych MS SQL",
    'limit__name_expiration' => 'data ważności',

    'locale_upload__title' => 'Dodaj Lokalizację',
    'locale_upload__file_name' => 'cieżka do pakietu językowego',
    'locale_upload__unable_to_install' => 'Nie można zainstalować pakietu językowego',
    'locale_upload__wrong_package' => 'Plik który załadowałe nie zawiera plików językowych zgodnych z tš wersjš Plesk\'a.',
    'locale_upload__wrong_locale' => 'Załadowany plik nie zawiera poprawnego pakietu językowego.',

    'locales_remove__title' => 'Usunięcie ustawień regionalnych',
    'locales_remove__select_locales_for_remove' => 'Zaznacz pakiety regionalne do usunięcia.',
    'locales__can_not_remove' => 'Nie można usunšć pakietów językowych dla %1: %2',

    'ma__create_title' => 'Stwórz alias poczty dla %1',
    'ma__edit_title' => "Edytuj alias poczty %1",
    'ma__enter_new_alias' => "Podaj nowy alias poczty.",
    'ma__invalid_alias' => "Błędny alias poczty.",
    'ma__mail_aliases_mailname' => "Aliasy pocztowe dla skrzynki pocztowej %1",
    'ma__mailname_does_not_exist' => "Nazwa skrzynki nie istnieje.",
    'ma__select_ma_for_remove' => "Zaznacz skrzynki pocztowe do usunięcia.",
    'ma__unable_to_add_new_ma' => "Nie można dodać alias poczty: %1",

    'mail__white_list' => "Biała lista",
    'mail__white_list_add' => 'Dodaj sieć',
    'mail__white_list_remove' => 'Następujšce sieci zostanš usunięte:',
    'mail__white_list_remove_warning_webmail' => 'Usunięcie następujšcych sieci może spowodować, że wysyłanie z Webmail\'a będzie niemożliwe: %1.',
    'mail__white_list_member' => 'Dozwolone sieci',
    'mail__white_list_empty_selection_for_remove' => 'Zaznacz wpisy do usunięcia.',
    'mail_queue__not_allowed_by_license_key' => 'Zarzšdzanie kolejkš poczty nie jest dozwolone przez klucz licencji.',
    'maillist__' => "Lista mailingowa %1",
    'maillist__already_exists' => "Lista mailingowa już istnieje.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Alias poczty %1 już istnieje w tej domenie",
    'maillists__' => "Listy mailingowe %1",
    'maillists__limit_cl_max_maillists' => "Limit ilości list mailingowych został osiągnięty dla tego klienta (limit: %1, używanych: %2)",
    'maillists__limit_dom_max_maillists' => "Limit ilości list mailingowych został osiągnięty dla tej domeny.",
    'maillists__list' => "Listy mailingowe",
    'maillists__mailman_not_installed_or_conf' => "Rozszerzenia Serwera Mailman nie są obecnie zainstalowane lub\n skonfigurowane na serwerze. Skontaktuj się z administratorem serwera w celu zainstalowania Rozszerzeń Serwera Mailman lub poprawnej ich konfiguracji.",
    'maillists__status' => "Listy mailingowe włączone",
    'maillists__unable_to_delete__' => "Nie można usunąć listy mailingowej: %1",
    'maillists__disabled_text' => 'Nie możesz zarzšdzać listami pocztowymi ponieważ komponent Mailman nie jest zainstalowany lub skonfigurowany.',
    'maillist_member__already_exists' => 'Użytkownik list mailingowej już istnieje.',
    'maillist_member__not_exists' => 'Użytkownik listy mailingowej nie istnieje.',
    'mailserver_switching_warning' => "Uwaga!\n\nZmienianie serwera pocztowego jest przeznaczone wyłącznie na potrzeby początkowej konfiguracji, jeśli serwer jest już wykorzystywany, występują następujące problemy: utrata ustawień i zawartości skrzynek pocztowych oraz w przypadku, gdy serwer na który chcesz przełączyć jest już skonfigurowany, różnego rodzaju konflikty.\nJeśli ten serwer jest obecnie w użyciu i masz całkowitą pewność co do przełączenia się na inny serwer, możesz poinformować swoich użytkowników o planowanej operacji przełączenia, tak aby mieli czas ściągnąć i zachować swoją pocztę e-mail jeszcze przed przełączeniem.",
    'manager__access_denied' => "Dostęp zabroniony: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Klient',
    'manager__domain' => "Domena",
    'manager__domain_cl_limit_exceeding' => "Limit ilości domen został osiągnięty dla tego konta klienta.",
    'manager__domain_is_not_yours' => "Domena %1 nie należy do Ciebie.",
    'manager__domain_key_limit_exceeding' => "Limit ilości domen zdefiniowany w Twoim kluczu licencji jest osiągnięty.",
    'manager__no_perm_to_call' => "Nie masz uprawnień by używać %1.",
    'manager__no_perm_to_create_domains' => "Nie masz uprawnień by tworzyć nowe domeny.",
    'manager__no_perm_to_modify_domain' => "Nie masz uprawnień by zmodyfikować domenę %1.",
    'manager__no_perm_to_modify_domains' => "Nie masz uprawnień by modyfikować domeny.",
    'manager__no_perm_to_remove_domain' => "Nie masz uprawnień by usunąć domenę %1.",
    'manager__no_perm_to_remove_domains' => "Nie masz uprawnień do usuwania domen.",
    'manager__node_doesnt_exist' => "%1 nie istnieje.",
    'manager__user_disabled' => "Twoje konto jest zawieszone. Nie możesz pracować w systemie.",
    'mail_quota_unsupported' => "nie obsługiwany przez serwer pocztowy",
    'mbox_quota_unsupported' => "nie obsługiwany przez serwer pocztowy",
    'mn__create_title' => "Utwórz nazwę poczty",
    'mn__edit_title' => "Ustawienia",
    'mn__files_list_title' => "Pliki załącznika",
    'mn__files_remove' => "Usuń pliki z repozytorium załšczników. Te pliki sš prawdopodobnie używane przez auto-odpowiedzi. Zostanš usunięte z: repozytorium i auto-odpowiedzi, które je używajš.",
    'mn__files_select_for_remove' => "Wybierz pliki do usunięcia.",
    'mn__mail_alias_form' => "Formularz aliasu poczty",
    'mn__mail_aliases_list' => "Aliasy pocztowe",
    'mn__mailbox' => "Zarządzanie skrzynką pocztową",
    'mn__unable_define_mn' => "Nie można określić nazw poczty: %1",
    'mn__unable_remove_mbox_quota' => "Nie można usunąć quoty poczty: %1",
    'mn__upload_file' => "Wgraj plik",
    'mn_edit__attach_filename_changed' => 'Wgranemu plikowi %1 została zmieniona nazwa na %2, ponieważ zawierała znaki spoza zestawu ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Powinieneś dodać członka grupy pocztowej zanim uaktywnisz grupę.",
    'mn_edit__add_resp_or_turn_off_box' => "Powinieneś dodać autoresponder lub odznaczyć opcję autorespondera.",
    'mn_edit__attachments' => "Załączniki",
    'mn_edit__dom_quota_less_then_quota' => "Wartość quoty poczty nie może przekraczać całkowitej wartości quoty dla tej domeny.",
    'mn_edit__enter_external_rcpnt_email' => "Podaj zewnętrzny adres e-mail członka grupy",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Powiniene podać dane do przekierowania poczty lub odznaczyć opcję przekierowania.",
    'mn_edit__ext_rcpnt_email_invalid' => "Adres e-mail odbiorcy jest nieprawidłowy.",
    'mn_edit__file_exists' => "Plik istnieje. Nadpisać?",
    'mn_edit__files_deld_from_repository' => "Te pliki zostaną usunięte z repozytorium wraz z autoresponderami zawierającymi je. Czy chcesz kontynuować?",
    'mn_edit__mail_name' => "Konto pocztowe",
    'mn_edit__mail_name_invalid' => "Nazwa poczty jest błędna.",
    'mn_edit__mail_redir' => "Przekierowania poczty",
    'mn_edit__mail_redir_add' => "Nowy członek grupy pocztowej",
    'mn_edit__mail_resps' => "Autorespondery",
    'mn_edit__mailbox' => "Skrzynka pocztowa",
    'mn_edit__enable_mailbox' => "Skrzynka pocztowa",
    'mn_edit__mailgroup' => "Grupa pocztowa",
    'mn_edit__mailgroup_addresses' => "członkowie grypy pocztowej",
    'mn_edit__mailgroup_disabled' => "Dostępny jedynie, gdy konto pocztowe jest już dodane.",
    'mn_edit__max_dom_quota' => "Domyślny dla domeny (%1)",
    'mn_edit__mbox_quota_invalid' => "Ograniczenie pojemności poczty jest błędne.",
    'mn_edit__new_resp_name' => "Nowa nazwa autorespondera",
    'mn_edit__no_autoresponders' => "Musisz dodać przynajmniej jeden autoresponder zanim zaczniesz przełączać obsługę autorespondera - wł./wył.",
    'mn_edit__no_file_sel' => "Nie wybrano żadnych plików.",
    'mn_edit__no_mail_addresses' => "Nie podano ani wybrano żadnego adresu poczty.",
    'mn_edit__none' => "Brak",
    'mn_edit__not_create_pass' => "Ta akcja nie utworzy hasła dla tego konta.\nBez hasła, użytkownik nie będzie w stanie odbierać lub/i wysyłać poczty.",
    'mn_edit__redir_email_invalid' => "Adres e-mail przekierowania jest błędny.",
    'mn_edit__redirect_addr' => "Adres przekierowania",
    'mn_edit__remove_autoresp?' => "czy jesteś pewien, że chcesz usunąć autoresponder?",
    'mn_edit__remove_rcpnts?' => "Na pewno chcesz usunąć tych odbiorców?",
    'mn_edit__repository' => "Repozytorium",
    'mn_edit__resps_attach' => "Pliki załącznika autorespondera",
    'mn_edit__select_rcpnt_from_list' => "Wybierz przynajmniej jednego adresata z listy w celu usunięcia.",
    'mn_edit__select_registered_users' => "Wybierz zarejestrowanych użytkowników",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Wybrałeś, że chcesz mieć skrzynkę pocztową ale nie podałeś hasła dla niej.",
    'mn_edit__unable_act_deact_mail_group' => "Nie można zaktywować/zdezaktywować grupy pocztowej: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Nie można zaktywować/zdezaktywować przekierowania poczty: %1",
    'mn_edit__unable_act_deact_postbox' => "Nie można zaktywować/zdezaktywować skrzynki pocztowej: %1",
    'mn_edit__unable_act_deact_resp' => "Nie można aktywować/zdezaktywować auto-odpowiedzi: %1",
    'mn_edit__unable_add_attach' => "Nie można dodać plika załącznika: %1",
    'mn_edit__unable_add_mail_group_member' => "Nie można dodać członka grupy pocztowej: %1",
    'mn_edit__unable_add_resp' => "Nie można dodać auto-odpowiedzi: %1",
    'mn_edit__unable_change_mail_name' => "Nie można zmienić nazwy poczty: %1",
    'mn_edit__unable_deactivate_mail_group' => "Nie można zdezaktywować grupy pocztowej: %1",
    'mn_edit__unable_deactivate_resp' => "Nie można zdezaktywować auto-odpowiedzi: %1",
    'mn_edit__unable_define_resp_id' => "Nie można określić ID auto-odpowiedzi: %1",
    'mn_edit__unable_remove_attach' => "Nie można usunąć plik(ów) załącznika: %1",
    'mn_edit__unable_remove_autoresp' => "Nie można usunąć auto-odpowiedzi: %1",
    'mn_edit__unable_remove_mail_group_member' => "Nie można usunąć członków grupy pocztowej: %1",
    'mn_edit__wrong_way' => 'Wiadomość adresowana do %1 nie będzie dostarczona, jako że nazwa poczty nie jest ani skrzynką pocztową, ani przekierowaniem, ani grupą pocztową, czy autoresponderem.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Skrzynka pocztowa %1 została wyłšczona. Wiadomoci nie zostały ze skrzynki usunięte, więc nie należy zapominać o pobraniu ich poprzez protokół POP3 lub IMAP.',
    'mn_list__mail_names_for_domain' => "Skrzynki pocztowe dla domeny %1",
    'mn_list__sa_cannot_unable' => "Nie można włšczyć filtrowania spamu",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Klient',
    'mn_list__tab_title_domain' => 'Domena',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nazwa",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Nie można usunąć nazw poczty: %1",
    'no_psa_mails_matched' => "Brak nazw skrzynek pocztowych odpowiadających podanemu wzorcowi.",
    'module_upload__module_was_installed' => 'Ten moduł jest już zainstalowany. Jeżeli chcesz zainstalować nowš wersję moduły, proszę odinstalować moduł poprzez Plesk kontrolny a potem zainstaluj go od nowa.',
    'module_upload__unable_to_install' => 'Nie można zainstalować pliki modułu',
    'module_upload__wrong_package' => 'Wgrany plik nie zawiera wspieranej wersji pakietu z modułem.',
    'module_upload__wrong_module' => 'Wgrany plik nie zawiera pakietu z modułem.',

    'news_articles_title' => 'Aktualności Plesk',
    'notification_text__invalid_subject_length' => "Nieprawidłowa długość tematu powiadomienia. Powinna być między 1 a 255 znaków.",
    'notification_text__invalid_text_length' => "Błędna długość treści notatki. Powinna być między 1 a 65533 znaków.",
    'notification_text__subject' => "Temat powiadomienia",
    'notification_text__text' => "Treść notatki",
    'notification_text__title' => "Edytuj notatkę",
    'notification_text__unable_set_text' => "Nie można zmodyfikować treści notatki:",

    'odbc__cant_add_dsn' => "Nie można dodać DSN %1: %2",
    'odbc__cant_build_connection_string' => "Nie można ustanowić połšczenia używajšc podanych parametrów, spróbuj ponownie używajšc innych parametrów. Narzędzie zwróciło: %1",
    'odbc__cant_connect' => "Nie można połšczyć się ze ródłem danych używajšc zdefiniowanych ustawień. Serwer zwrócił: %1",
    'odbc__cant_delete_dsn' => "Nie można usunšć DNS %1: %2",
    'odbc__cant_get_drivers_info' => "Nie udało się pobrać informacji o sterownikach.",
    'odbc__cant_get_drivers' => "Nie można pozyskać listy sterowników ODBC: %1",
    'odbc__cant_get_list' => "Nie można pozyskać listy istniejšcych DNS-ów: %1",
    'odbc__cant_get_servers_list' => "Nie udało się pobrać listy serwerów.",
    'odbc__cant_open_info_file' => "Nie można otworzyć pliku z informacjami o sterownikach ODBC.",
    'odbc__cant_parse_string' => "Nie można przetworzyć strumienia połączenia.",
    'odbc__connect_success' => "Połšczenie udane",
    'odbc__driver_not_set' => "Sterownik nie jest ustawiony",
    'odbc__driver_or_name_not_set' => "Sterownik lub nazwa połšczenia ODBC nie zostały wysłane",
    'odbc__dsn_already_exists' => "DSN o takiej nazwie (%1) już istnieje w systemie",
    'odbc__dsn_not_exists' => "Ten DNS nie istnieje",
    'odbc__enter_connection_params' => "Po tym jak podasz wszystkie wymagane dane, będziesz musiał kliknąć \"Koniec\" aby zakończyć konfigurację ODBC DSN",
    'odbc__enter_dsn_name' => "Podano nazwę DNS",
    'odbc__invalid_dsn_name' => "Błędna składnia dla nazwy połączenia ODBC (%1): proszę używać jedynie symboli alfanumerycznych.",
    'odbc__no_such_driver' => "Sterownik ODBC o tej nazwie (%1) nie jest obsługiwany.",
    'odbc__remove_page_title' => "Poniższe połączenia ODBC DSN zostaną usunięte:",
    'odbc__select_dsn_to_remove' => "Wybierz DSN-y do usunięcia.",
    'odbc__unknown_driver' => "Nieznana nazwa sterownika (%1).",
    'odbc_add_new' => "Dodaj połączenie DSN",
    'odbc_driver' => "Sterownik",
    'odbc_dsn_description' => "Opis połączenia",
    'odbc_dsn_list' => "Połączenia ODBC DSN",
    'odbc_dsn_name' => "Nazwa połączenia",
    'odbc_dsn_system' => "System DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => 'Dodaj ODBC DSN',
    'odbc_req_field_not_set' => "Wymagane argumenty nie zostały podane.",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => 'Ścieżka do Pliku Bazy Danych',
    'odbc__access_pagetimeout' => 'Okres czasu, w dziesiątych częściach sekundy, w którym nieużywana strona pozostaje w buforze. Ta opcja odnosi się do wszystkich źródeł, które korzystają ze sterownika Microsoft Access.',
    'odbc__access_maxbuffersize' => 'Rozmiar wewnętrznego buforu, w KB, ustawiony jest na 256 KB.',
    'odbc__access_readonly' => 'Przełącza bazę danych w tryb tylko do odczytu aby zapobiec jakimkolwiek aktualizacjom.',
    'odbc__access_exclusive' => 'Przełącza bazę danych w tryb wyłączony aby zapobiec współdzielonym aktualizacjom.',
    'odbc__access_safetransactions' => 'Jeśli 0, domyślnie, wszystkie transakcje są zatwierdzane natychmiastowo. Jeśli 1, wszystkie transakcje są zapisywane na wyłącznie po wykonaniu operacji commit, ale wydajność jest delikatnie mniejsza.',
    'odbc__access_threads' => 'Liczba wątków w tle do wykorzystania przez silnik.',
    'odbc__access_maxscanrows' => "Liczba wierszy, które będą skanowane, gdy będzie ustawiany typ danych dla kolumny w już istniejącej bazie danych.",
    'odbc__access_implicitcommitsync' => 'Określa jak zmiany poczynione poza transakcją są zapisywane do bazy danych.',
    'odbc__access_usercommitsync' => 'Określa czy sterownik MS Access będzie wykonywał w sposób asynchronicznie jawnie zdefiniowane przez użytkownika transakcje.',
    'odbc__mssql_server' => 'Serwer',
    'odbc__mssql_uid' => 'Login ID',
    'odbc__mssql_pwd' => 'Hasło',
    'odbc__mssql_database' => 'Domyślna baza danych dla źródła danych ODBC',
    'odbc__mssql_app' => 'Nazwa aplikacji',
    'odbc__mssql_wid' => 'Identyfikator stacji roboczej',
    'odbc__mssql_language' => 'Domyślnie używany język',
    'odbc__mssql_oemtoansi' => 'Ten parametr określa czy konwertować rozszerzone znaki do wartości OEM',
    'odbc__mysql_server' => 'Nazwa maszyny serwera MySQL',
    'odbc__mysql_database' => 'Domyślna baza danych',
    'odbc__mysql_user' => 'Nazwa użytkownika wykorzystywana podczas połączenia do MySQL',
    'odbc__mysql_password' => 'Hasło do konta użytkownika na serwerze',
    'odbc__mysql_port' => 'Port TCP/IP używany gdy serwer nie jest lokalną maszyną',
    'odbc__mysql_socket' => 'Nazwany pipe windowsowy w przypadku lokalnych połączeń do serwera',
    'odbc__mysql_option' => 'Opcje które określają jak MyODBC powinno działać. Zobacz <a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html.</a>',
    'odbc__excel_dbq' => 'Ścieżka do pliku DB',
    'odbc__excel_defaultdir' => 'Domyślny katalog danych',
    'odbc__excel_fil' => 'Wersja bazy danych',
    'odbc__excel_maxbuffersize' => 'Maksymalny rozmiar bufora',
    'odbc__excel_pagetimeout' => 'Wygaśnięcie strony',

    'pb__aliases' => "Aliasy",
    'pb__anonftp' => "Anonimowy FTP",
    'pb__autoinstaller_releases' => 'Aktualizacja',
    'pb__cert' => "Certyfikaty",
    'pb__cl_pool' => "Adresy IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Ustawienia",
    'pb__cl_rpt' => "Raport",
    'pb__cl_rpt_list' => "Dostosuj",
    'pb__cl_templates' => "Szablony klienta",
    'pb__cl_traffic' => "Ruch",
    'pb__cl_traffic_history' => "Historia transferu",
    'pb__cl_traffic_of' => "Transfer dla %1",
    'pb__client' => "%1",
    'pb__clients' => "Klienci",
    'pb__comp_info' => "Komponentów serwera",
    'pb__common_acl' => 'Lista dozwolonych stref ACL',
    'pb__cp_access' => "Dostęp",
    'pb__crontab' => "Harmonogram zadań (Scheduler)",
    'pb__scheduler' => "Harmonogram zadań (Scheduler)",
    'pb__custom_buttons' => "Własne przyciski",
    'pb__databases_db' => 'Bazy danych',
    'pb__sqlservers_db' => 'Serwery SQL',//to check
    'pb__db' => "Bazy danych",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Serwery baz danych',
    'pb__dl_usr_ed' => "Użytkownik domeny",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limity domeny",
    'pb__dom_pref' => "Ustawienia",
    'pb__dom_sum_report' => "Zestawienie dla domeny",
    'pb__dom_templates' => "Szablony domeny",
    'pb__dom_traffic' => "Transfer dla %1",
    'pb__dom_traffic_history' => "Historia transferu",
    'pb__domains' => "Domeny",
    'pb__domain_aliases' => 'Aliasy domen',
    'pb__dumps_list' => "Przechowywanie plików kopii zapasowej",
    'pb__forwarding_setup' => "Ustawienia przekierowania",
    'pb__filemanager' => "Menedżer plików",
    'pb__ip_aliasing' => "Adresy IP",
    'pb__ip_clients' => "Usuwanie adresów IP",
    'pb__license_management' => 'Informacje na temat licencji',
    'pb__locales' => 'Wersje językowe',
    'pb__log_files' => "Pliki logów",
    'pb__mail' => 'Poczta',
    'pb__mail_blocked_domains' => 'Czarna lista',
    'pb__mail_name_files' => "Pliki załącznika",
    'pb__mail_name_redirects' => "Przekierowania poczty",
    'pb__mail_name_resp_attach_add' => "Nowy załącznik",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Autorespondery",
    'pb__mail_names' => "Poczta",
    'pb__mail_white_list' => 'Biała lista',
    'pb__maillists' => "Listy mailingowe",
    'pb__mimetypes' => 'Typy MIME',
    'pb__modules' => 'Moduły',
    'pb__modules_management' => 'Zarzšdzaj modułami',
    'pb__notifications' => "Powiadomienia",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Ustawienia fizycznego hostingu",
    'pb__prtd_dirs' => "Chronione katalogi",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Raport",
    'pb__report_auto' => "Harmonogram wysyłki dla %1",
    'pb__report_list' => "Dostosuj",
    'pb__server' => "Serwer",
    'pb__sessions' => "Sesje",
    'pb__sapp_pool' => "Pula aplikacji",
    'pb__siteapp_install' => 'Instalacja aplikacji webowej',
    'pb__site_app_pkgs' => 'Aplikacje WWW',
    'pb__site_apps' => "Aplikacje WWW",
    'pb__additional_key_info' => 'Właściwości klucza',
    'pb__additional_key_properties' => 'Właściwości klucza',
    'pb__skeleton' => 'Zarządzanie szkieletem',
    'pb__skins' => 'Skóry',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtr spamu",
    'pb__statistics' => "Statystyki",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomeny",
    'pb__templates' => "Szablony",
    'pb__virtualdirs' => 'Wirtualne katalogi',
    'pb__web_users' => "Użytkownicy Stron",
    'pb__webalizer_preferences' => 'Ustawienia Statystyk Stron',
    'pdir__enter_dir_name' => "Podaj nazwę katalogu.",
    'pdir__invalid_hst' => "Typ hostingu jest błędny. Musi być fizyczny.",
    'pdir__pd_id_is_undefined' => "ID chronionego katalogu jest niezdefiniowane.",
    'pdir__pdir_exist' => "Katalog o tej nazwie jest już chroniony.",
    'pdir__pdir_not_exist' => "Chroniony katalog nie istnieje.",
    'pdir__pdir_usr_not_exist' => "Użytkownik chronionego katalogu nie istnieje.",
    'pdir__prdirs_for_domain' => "Chronione katalogi dla domeny %1",
    'pdir__prdirs_for_subdomain' => "Chronione katalogi dla domeny %1",
    'pdir__remove_pdir_usrs' => "Poniżsi użytkownicy chronionego katalogu %3 dla domeny %2 klienta %1 zostanš usunięci:",
    'pdir__remove_pdir_usrs_on_subdom' => "Następujący użytkownicy chronionego URL %2 w subdomenie %1 będą usunięci:",
    'pdir__remove_pdirs_on_dom' => "Poprzez tę akcję, tylko ochrona jest usuwana z katalogu dla domeny %2, klienta %1. Za same katalogi nie sš usuwane.",
    'pdir__remove_pdirs_on_subdom' => "Ta operacja spowoduje usunięcie ochrony z katalogów dla subdomeny %1,. zaś same katalogi nie są usuwane.",
    'pdir__select_pdir_usrs_for_remove' => "Wybierz użytkowników chronionego katalogu do usunięcia.",
    'pdir__select_pdirs_to_remove' => "Wybierz katalogi z których chcesz usunąć ochronę.",
    'pdir__unable_define_pdir_users' => "Nie można określić użytkownika chronionego katalogu.",
    'pdir__unable_define_pdirs_properties' => "Nie można ustawić właściwości chronionego katalogu: %1",
    'pdir__unable_select_dom_param' => "Nie można ustawić parametrów domeny: %1",
    'pdir_ed__create_pdir_for_domain' => "Utwórz chroniony katalog pod serwisem %1",
    'pdir_ed__create_pdir_for_subdomain' => "nowy chroniony katalog w subdomenie %1",
    'pdir_ed__dir_already_protect' => "Ten katalog jest już chroniony.",
    'pdir_ed__head_txt' => "Nagłówek tekstowy",
    'pdir_ed__invalid_login' => "Nazwa użytkownika jest błędna.",
    'pdir_ed__login_exists' => "Taki użytkownik już istnieje. Spróbuj innš nazwę loginu.",
    'pdir_ed__new_usr' => "Nazwa użytkownika",
    'pdir_ed__non_ssl' => "nie-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Nazwa katalogu",
    'pdir_ed__pdir_for_domain' => "Chroniony katalog %1 dla domeny %2",
    'pdir_ed__pdir_for_subdomain' => "Chroniony katalog %1 dla poddomeny %2",
    'pdir_ed__pdir_location' => "Lokalizacja katalogu",
    'pdir_ed__pdir_users' => "Użytkownicy chronionego katalogu",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "SSL/TLS nie jest obsługiwane przez ten serwis lub nie jest dostarczane wraz z subskrypcję. Aby włączyć obsługę SSL/LS, przejdź do zakładki Serwisy i domeny i kliknij nazwę domeny na liście. Jeśli obsługa SSL/TLS nie jest dostarczana wraz z subskrypcją, skontaktuj się z dostawcą hostingu, aby podnieść parametry planu hostingowego.",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "SSL/TLS nie jest obsługiwane przez ten serwis. Aby włączyć obsługę SSL/LS, przejdź do zakładki Serwisy i domeny i kliknij nazwę domeny na liście.",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Przynajmniej jedno pole wyboru powinno być wybrane z pól SSL/TLS i nie-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Nie można stworzyć użytkownika chronionego katalogu: %1",
    'pdir_ed__unable_create_pdir' => "Nie można utworzyć chronionego katalogu: %1",
    'pdir_ed__unable_define_hst_type' => "Nie można określić typu hostingu.",
    'pdir_ed__unable_update_pdir' => "Nie można uaktualnić chronionego katalogu: %1",
    'pdir_ed__wrong_symbol_in_header' => "Proszę, nie używaj symbolu %1 w nagłówku katalogu.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Stwórz użytkownika dla chronionego katalogu %1",
    'pdir_usr_ed__not_create_pass' => "Ta akcja nie utworzy hasła dla nowego użytkownika chronionego katalogu.\nBez hasła użytkownik nie będzie w stanie się zalogować.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Hasło dla użytkownika chronionego katalogu %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Nie można wybrać użytkownika chronionego katalogu: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Nie można określić użytkownika chronionego katalogu: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Nie można usunąć użytkowników chronionego katalogu: %1",
    'pdirs_list__name' => "Nazwa",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "Nie można usunąć chronionych katalogów: %1",
    'phosting__anonftp_disabled' => "Usługa anonimowego FTP jest wyłączona dla tej domeny jako, że ten adres IP jest już użyty do usługi anonimowego FTP na innej domenie.",
    'phosting__anonftp_encrypt' => 'Hasło użytkownika FTP jest zaszyfrowane i nie może być użyte do ochrony katalogu /plesk-stat/webstat/. Podaj ponownie hasło FTP lub odznacz opcję "dostępne przez katalog chroniony hasłem \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Nazwa domeny %%domain_name%% rozwišzuje się na adres IP %%dns_ip_address%%. Twoja strona WWW jest przypisana do adresu IP %%hosting_ip_address%%. Jeli strona nie otworzy się w przeglšdarce WWW, przejd na stronę Zarzšdzanie DNS (Domeny > Nazwa domeny > DNS) i zmień zawartoć rekordu A: przydziel adres IP %%hosting_ip_address%% domenie %%domain_name%%.",
    'phosting__ip_change_warning' => "Adres IP zmieniony. Odpowiednie zmiany w strefie DNS dla tej domeny zostały wprowadzone.",
    'phosting__other_hosting_exists_on_ip' => "Nie można zmienić certyfikatu ponieważ ten adres IP jest już użyty dla jednego lub więcej kont hostingowych.",
    'phosting__unable_to_change_certificate' => "Nie można zainstalować certyfikatu: %1",
    'phosting__unable_to_change_ip_address' => "Nie można zmienić adresu IP: %1",
    'phosting__unable_to_set_cert' => "Nie udało się ustawić certyfikatu SSL/TLS: %1",
    'phosting__unable_update' => "Nie można zaktualizować ustawień hostingu: %1",
    'phosting__unable_manage' => "Nie można zarządzać hostingiem: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Nie można skonfigurować fail2ban do śledzenia dzienników logów domeny. Dzienniki logów będą automatycznie śledzone przy następnym ponownym uruchomieniu usługi fail2ban.\n%1",

    'picker_acl_record__tittle' => 'Wybierz wpis w ACL',
    'picker_autoresponder__title' => 'Wybierz auto-odpowiedzi',
    'picker_black_list__domain_name' => 'Wybierz Nazwę Domeny',
    'picker_certificate' => 'Wybierz certyfikat SSL/TLS',

    'picker_dns_zone_template__title' => 'Wybierz Rekord',
    'picker_domain__title' => 'Wybór domeny',
    'picker_domain_alias__title' => 'Wybierz Alias Domen',
    'picker_resource_record__title' => 'Wybierz Rekord',
    'picker_disabled_resource_record__title' => 'Wybierz Serwer Nazw',
    'picker_ip_address__title' => 'Wybierz Adres IP',
    'picker_ip_address_clients__title' => 'Wybierz Klientów Używajšcych Tego Adresu IP',
    'picker_mail_queue' => 'Wybierz wiadomoci e-mail',
    'picker_site_application__title' => 'Wybór aplikacji WWW',
    'picker_subdomain__title' => 'Wybór subdomeny',
    'picker_web_user__title' => 'Wybór użytkownika Web',
    'picker_custom_button__title' => 'Wybierz własnego przycisku',
    'picker_license_key__title' => "Wybór klucza licencyjnego",
    'picker_spamfilter_address__title' => 'Wybierz Adres Filtra Spamowego',
    'picker_white_list__networks' => 'Wybór sieci',

    'plesk_key__action_logs' => "Zapisywanie działań wykonywanych przez użytkowników Plesk",
    'plesk_key__app_vault' => "Możliwość używania aplikacji",
    'plesk_key__backup' => "Możliwość używania funkcji archiwizacji",
    'plesk_key__client_templs' => "Możliwość zarządzania szablonami klientów",
    'plesk_key__clients' => "Maksymalna liczba kont klienta",
    'plesk_key__resellers_only' => "Konta użytkowników (sprzedawcy)",
    'plesk_key__customers_only' => "Konta użytkowników (klienci)",
    'plesk_key__domains' => "Domeny",
    'plesk_key__domain_aliases' => "Aliasy domen",
    'plesk_key__manage_dashboard' => 'Możliwoć zarzšdzania Pulpitem',
    'plesk_key__drweb' => "Zarządzanie antywirusem",
    'plesk_key__event_manager' => "Menadżer zdarzeń",
    'plesk_key__expirations' => "Możliwość zarządzania datami ważności domen i kont klientów",
    'plesk_key__group_ops' => "Możliwość przeprowadzania ogólnych operacji na obiektach(Ogólne operacje)",
    'plesk_key__expiration' => "Data ważności klucza",
    'plesk_key__edition_name' => "Plesk Edition",
    'plesk_key__key_number' => "Numer klucza",
    'plesk_key__languages' => "Pakiety językowe",
    'plesk_key__mailnames' => "Konta pocztowe",
    'plesk_key__migration_manager' => "Menedżer migracji i transferu",
    'plesk_key__mssql' => "Możliwość używania serwera Microsoft SQL",
    'plesk_key__myplesk_func' => "Linki do zakupu certyfikatów SSL/TLS oraz usługi rejestracji domeny",
    'plesk_key__myplesk_server_id' => "Identyfikator serwera podrzędnego MPC",
    'plesk_key__notifications' => "Możliwość zarządzania powiadomieniami",
    'plesk_key__postgresql' => "Możliwość używania PostgreSQL",
    'plesk_key__qmail_queue' => 'Możliwoć zarzšdzania kolejkš poczty',
    'plesk_key__remote_db' => 'Możliwoć używania zdalnego hostingu baz danych',
    'plesk_key__slave_servers' => "Serwery podrzędne",
    'plesk_key__spamassassin' => "Zarządzanie filtrem antyspamowym",
    'plesk_key__subdomains' => "Zarządzanie subdomenami",
    'plesk_key__sys_access' => "Zarządzanie dostępem do serwera",
    'plesk_key__traffic_reports' => "Możliwość używania raportów transferu",
    'plesk_key__tts' => "Pomoc techniczna",
    'plesk_key__virtuozzo' => "Działa tylko z Virtuozzo containers",
    'plesk_key__webusers' => "Użytkownicy Stron",
    'plesk_key__license_update_date' => 'Następna aktualizacja klucza',
    'plesk_key__autoinstaller_config' => 'Dostęp do ustawień aktualizacji',
    'plesk_key_update__title' => 'Status aktualizacji klucza',
    'plesk_key_update__legend' => 'Status aktualizacji klucza',
    'plesk_key_update__new_additional_key' => 'Nowy dodatkowy klucz pobrany',
    'plesk_key__check_wrong' => "Klucz licencji jest niepoprawny. Aby używać Pleska, zdobšd i zainstaluj nowy poprawny klucz licencyjny.",
    'plesk_key__upload_check_wrong' => 'Wgrany klucz licencji jest nieważny.',
    'plesk_key__revert_check_wrong' => 'Poprzedni klucz licencji nie jest poprawny.',
    'plesk_key__update_check_wrong' => 'Zaktualizowany klucz licencji nie jest ważny.',
    'plesk_key__viruozzo_only_key' => 'Klucz licencyjny jest przeznaczony wyłącznie do użytku z Plesk wewnątrz środowiska Virtuozzo containers.',
    'plesk_key__ip_ranges_exceeded' => 'Możesz użyć tej licencjonowanej kopii Plesk jedynie z następującymi adresami IP: %2. Następujące adresy IP nie są zawarte w Twojej licencji: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Ilość obecnie zużywanych zasobów przekracza limity określone przez licencję.',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Liczba stron hostowanych na serwerze przekracza limity zdefiniowane w Twoim kluczu licencji. Masz obecnie %2 hostowane strony; Twoja licencja pozwala jedynie na %1 hostowanych stron.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Liczba aliasów domen na serwerze przekracza limit zdefiniowany w licencji. Masz %2 aliasów domen; twoja licencja pozwala hostować tylko %1 aliasów domen.',
    'plesk_key__limits_exceeded_lim_cl' => 'Liczba kont klientów przekracza limity zdefiniowane w Twoim kluczu licencji. Masz obecnie %2 konta klientów; Twoja licencja pozwala jedynie na %1 kont klienckich.',
    'plesk_key__limits_exceeded_lim_mn' => 'Liczba kont e-mail przekracza limity zdefiniowane w Twoim kluczu licencji. Obecnie masz %2 kont pocztowych; twoja licencja pozwala tylko na %1 kont pocztowych.',
    'plesk_key__limits_exceeded_lim_wu' => 'Liczba kont użytkowników web przekracza limity zdefiniowane w Twoim kluczu licencji. Masz obecnie %2 konta użytkowników web; Twoja licencja pozwala jedynie na %1 konta użytkowników web.',
    'plesk_key__limits_exceeded_MLS' => 'Liczba obecnie zainstalowanych pakietów językowych przekracza limity zdefiniowane w Twoim kluczu licencji. Są %2 zainstalowane pakiety; Twoja licencja pozwala na zainstalowanie jedynie %1 pakietów językowych.',
    'plesk_key__wrong_version' => 'Próbujesz używać klucza licencyjnego innej wersji Plesk. Skontaktuj się z przedstawicielem handlowym Plesk, aby otrzymać odpowiedni klucz licencyjny.',
    'plesk_key__other_product' => 'Próbujesz używać klucza licencyjnego innego produktu. Skontaktuj się z przedstawicielem handlowym Plesk, aby otrzymać odpowiedni klucz licencyjny.',
    'plesk_key__limits_exceeded_error' => 'Nie udało się zainstalować klucza licencyjnego Aktualne użycie panelu sterowania przekracza limity wgranego klucza.',
    'plesk_key__limits_exceeded_note' => 'Aktualne użycie panelu sterowania przekracza limity wgranego klucza.',
    'plesk_key__key_file_invalid' => 'Wgrany klucz jest niepoprawny albo nie zawiera poprawnego klucza licencji.',
    'plesk_key__server_request_error' => 'Nie można zaktualizować licencji. Upewnij się, że połączenia z serwerem licencji ka.plesk.com na porcie TCP %1 nie są blokowane. <a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">Zobacz, jak to zrobić</a>.',
    'key__title' => 'Informacje na temat licencji',
    'key__upload_title' => 'Zainstaluj klucz licencyjny',
    'key__no_key_file_in_zip' => 'Skopiowany plik .zip nie zawiera klucza licencji',
    'key__key_upload' => 'Instalacja klucza licencji',
    'key__tabs_plesk' => 'Klucz licencji Plesk',
    'key__tabs_additional' => 'Dodatkowe klucze licencji',
    'key_revert__title' => 'Przywrócenie klucza',
    'key_revert__legend' => 'Potwierdzenie przywrócenia klucza',
    'key_revert__text' => 'Klucz o następujących własnościach zostanie przywrócony:',
    'key__license_update_date_hint' => 'Data wygaśnięcia licencji zostanie automatycznie przedłużona do %%license_update_date%%. Aby uruchomić automatyczne uaktualnianie należy umozliwić dostęp do %%keyserver_host%%. Aby uzyskać więcej informacji kliknij na %%help begin:lim_date%%following help topic%%help end:lim_date%%.',
    'additional_key__info' => 'Dodatkowe właściwości klucza',
    'additional_key__prop_name' => 'Właściwość',
    'additional_key__prop_value' => 'Wartość',
    'additional_key__descr_name' => 'Nazwa klucza',
    'additional_key__descr_key_number' => 'Numer klucza',
    'additional_key__descr_key_vz' => "Ten klucz licencyjny jest przeznaczony wyłącznie dla Virtuozzo containers.",
    'additional_key__descr_lim_date' => 'Data ważności',
    'additional_key__descr_license_update_date' => 'Następna aktualizacja klucza',
    'additional_key__remove_title' => "Klucz aplikacji WWW o następujących właściwościach zostanie usunięty:",
    'additional_keys__remove_title' => "Poniższe dodatkowe klucze zostaną usunięte:",
    'additional_keys__select_to_remove' => 'Zaznacz dodatkowe klucze do usunięcia.',
    'additional_key__file_invalid' => 'Wgrany klucz jest niepoprawny albo nie zawiera poprawnego klucza licencji.',
    'additional_key__file_incompatible' => 'Wgrany plik z kluczem licencji jest niepoprawny dla tej aplikacji.',
    'additional_key__expired' => 'Ten dodatkowy klucz utracił ważność.',
    'additional_key__not_exists' => 'Nie ma zainstalowanych klucz licencji.',
    'additional_key__viruozzo_only_key' => 'Ten klucz licencyjny jest przeznaczony wyłącznie dla Plesk zainstalowanym na kontenerach Virtuozzo.',
    'additional_keys__legend' => 'Dodatkowe klucze',
    'additional_keys__list_header' => 'Dodatkowe klucze',
    'additional_key_update__result_response' => 'Licencjonowanie odpowiedzi serwera: %1',
    'additional_key_update__result_network' => 'Nie udało się połšczenie do serwera licencji. Proszę upewnij się, że Twój serwer umożliwia połšczenia %1: %2.',
    'additional_key_update__result_lock' => 'Aktualizacja klucza włanie trwa',
    'additional_key_update__result_internal_error' => 'Wystšpił błšd podczas aktualizacji klucza licencji: %1',

    'additional_key_revert__title' => 'Potwierdzenie przywracania klucza',
    'additional_key_revert__legend' => 'Stare ustawienia klucza',
    'additional_key_revert__confirm_text' => 'Przywróć stary klucz',
    'additional_key_revert__confirm_required' => 'Proszę potwierdzić operację.',

    'proceed_to_cl_pool' => "Przystąp do konfiguracji zestawu adresów IP klienta",
    'proceed_to_hosting_setup' => "Przejdź do ustawień hostingu",
    'removeCerts__remove_certificates_cp' => "Poniższe certyfikaty zostaną usunięte:",
    'removeCerts__remove_certificates_domain' => "Poniższe certyfikaty należące do %1 zostaną usunięte:",
    'removeClientsIP_remove_clients_ip' => "Ten adres IP zostanie usunięty z puli następujących klientów:",
    'removeMailAliases__remove_mail_aliases' => "Poniższe aliasy poczty dla skrzynki pocztowej %1 zostaną usunięte:",
    'removeMailNames__remove_mailnames' => "Poniższe nazwy i aliasy poczty dla domeny %2 klienta %1 zostanš usunięte:",
    'removeMailNames__remove_mailnames_of_cl' => "Poniższe konta pocztowe i aliasy zostanš usunięte w domenie %2 której włacicielem jest %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Te nazwy skrzynek pocztowych nie zostaną usunięte.",
    'removeFtpSessions__remove_title' => "Poniższe sesje FTP zostaną zakończone:",
    'removeTemplates__remove_templates' => "Poniższe szablony zostaną usunięte:",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => 'Częstotliwość',
    'report_auto__list_last' => 'Ostatnio wysłane',
    'report_auto__list_recipient' => 'Odbiorca',
    'report_auto__list_select' => 'Raport do',
    'report_auto__title' => 'Harmonogram wysyłek dla %1',
    'report_auto__recipient_email' => 'adres e-mail który podam',
    'report_auto__recipient_admin' => 'administratora serwera',
    'report_auto__recipient_client' => 'klienta',
    'report_auto__recipient_domain' => 'użytkownika domeny',
    'report_auto_edit__select' => 'Raport do',
    'report_auto__select_client_report_all' => 'wszyscy klienci',
    'report_auto__select_client_report_current' => 'ten klient',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => 'wszystkich domen',
    'report_auto__select_domain_report_other_client' => 'wszystkie domeny %1',
    'report_auto__select_domain_report_client' => 'wszystkie domeny tego klienta',
    'report_auto__select_domain_report_reseller' => 'wszystkie domeny tego sprzedawcy',
    'report_auto__select_domain_report_current' => 'aktualnej domeny',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => 'Harmonogram wysyłek',
    'report_auto__select_for_remove' => "Wybierz harmonogram wysyłek do usunięcia.",
    'report_auto_remove__title' => "Poniższe raporty harmonogramu wysyłek zostaną usunięte:",
    'report_auto_edit__title' => 'Właściwości harmonogramu wysyłek',
    'report_auto_edit__recipient' => 'Odbiorca',
    'report_auto_edit__target' => 'Raport do',
    'report_auto_edit__auto' => 'Częstotliwość wysyłek',
    'resp_edit__always_respond' => "zawsze odpowiadaj",
    'resp_edit__reply_subject' => "Temat odpowiedzi",
    'resp_edit__answer_subject' => "Odpowiedz z tematem",
    'resp_edit__answer_txt' => "Odpowiedz z treścią",
    'resp_edit__attach' => "Załącz pliki",
    'resp_edit__default_subject' => "Odp: %1",
    'resp_edit__for' => "dla",
    'resp_edit__frw_rqst_email' => "W wypadku otrzymania informacji automatycznej, przekieruj oryginalną wiadomość na podany adres e-mail",
    'resp_edit__fwd_email_invalid' => "E-mail przekierowujący jest błędny.",
    'resp_edit__in_body' => "kiedy określone słowa znajdują się w treści",
    'resp_edit__in_subject' => "kiedy określone słowa znajdują się w temacie",
    'resp_edit__invalid_resp_freq' => "Częstotliwość odpowiedzi jest błędna.",
    'resp_edit__invalid_rqst_txt' => "Błędny tekst zapytania.",
    'resp_edit__invalid_store_lim_num' => "Wartość limitu jest błędna.",
    'resp_edit__limits_title' => "Limity",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Liczba maksymalnej ilości odpowiedzi na dzień przekracza dopuszczalną wartość. Dozwolony %1, żądano: %2",
    'resp_edit__no_files_sel' => "Nie wybrano żadnych plików.",
    'resp_edit__no_txt_supplied' => "Nie podano tekstu.",
    'resp_edit__reply_title' => "Odpowiedz",
    'resp_edit__reply_to_address' => "Adres zwrotny",
    'resp_edit__reply_to_invalid' => "Adres zwrotny jest błędny.",
    'resp_edit__reply_uniq_email' => "Odpowiedz na unikalny e-mail nie więcej niż",
    'resp_edit__conditions_title' => "Warunki",
    'resp_edit__request_title' => "Żądanie",
    'resp_edit__resp' => "Autoresponder",
    'resp_edit__resp_name' => "Nazwa autorespondera",
    'resp_edit__resp_not_exist' => "Autoresponder nie istnieje.",
    'resp_edit__resp_status' => "Status autorespondera",
    'resp_edit__rqst_txt' => 'Tekst żądania',
    'resp_edit__select_files_on_server_for_attach' => "Wybierz pliki jakie chcesz załączyć",
    'resp_edit__store_up_to' => "Przechowuj do",
    'resp_edit__subj_line_invalid' => "Linia tematu jest błędna.",
    'resp_edit__text_too_big' => "Treść odpowiedzi jest za duża.",
    'resp_edit__times_in_a_day' => "razy na dzień.",
    'resp_edit__unable_define_resp_cond' => "Nie można określić warunku auto-odpowiedzi: %1",
    'resp_edit__unable_define_resp_status' => "Nie można określić statusu auto-odpowiedzi: %1",
    'resp_edit__unable_turn_on_resp' => "Nie można włączyć auto-odpowiedzi: %1",
    'resp_edit__uniq_email' => "unikalne adresy e-mail",
    'resp_edit__content_type' => 'Format wysyłanego e-maila',
    'resp_edit__content_type_text' => 'Zwykły tekst',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kodowanie',
    'restart__dns' => 'Serwer DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Serwer IMAP/POP3 (%1)",
    'restart__mssql' => "Serwer Microsoft SQL",
    'restart__mysql' => "Serwer MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Usługi",
    'restart__smtp' => "Serwer SMTP (%1)",
    'restart__spamd' => "Filtr spamu",
    'restart__spamassassin' => "Filtr spamu",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Serwer WEB (%1)",
    'restart__ftp' => "Serwer FTP (%1)",
    'restart__service_start' => 'Uruchomienie usługi zajmie trochę czasu.',
    'restart__service_stop' => 'Zatrzymanie usługi zajmie trochę czasu..',
    'restart__service_restart' => 'Ponowne uruchomienie usługi zajmie trochę czasu.',
    'rm_domains__some_domains_are_not_exist' => "Niektóre z wybranych domen nie istniejš. Prawdopodobnie zostały usunięte przez innego użytkownika.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "GrupyP",
    'rpt_cl_dom_mail_lists' => "ListyM",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntySpam",
    'rpt_cl_dom_mail_antivirus' => "Antywirus",
    'rpt_cl_dom_postboxes' => "Skrzynki",
    'rpt_cl_dom_redirects' => "Przekazywanie",
    'rpt_cl_dom_subdomains' => "Subdomeny",
    'rpt_cl_dom_domain_aliases' => "AliasyD",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Raport dla administratora %1",
    'rpt_cl_report_for_reseller__' => "Raport dla sprzedawcy %1",
    'rpt_cl_report_for_cl__' => "Raport dla klienta %1",
    'rpt_cl_section_domains' => "Domeny",
    'rpt_cl_section_full_domains' => "Domeny",
    'rpt_cl_section_general' => "Ogólny",
    'rpt_create' => "Stwórz raport",
    'rpt_empty' => "Raport powinien zawierać przynajmniej jedną sekcję",
    'rpt_default_report' => "Użyj jako domyślny raport",
    'rpt_dom_report_for_dom__' => "Raport dla domeny %1",
    'rpt_dom_section_databases' => "Bazy danych",
    'rpt_dom_section_full_databases' => "Bazy danych",
    'rpt_dom_section_full_maillists' => "Listy mailingowe",
    'rpt_dom_section_full_mailnames' => "Konta pocztowe",
    'rpt_dom_section_full_webusers' => "Użytkownicy Stron",
    'rpt_dom_section_full_siteapps' => 'Aplikacje WWW',
    'rpt_dom_section_full_aspnetapps' => 'Aplikacje ASP.NET',
    'rpt_dom_section_general' => "Ogólny",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Listy mailingowe",
    'rpt_dom_section_mailnames' => "Konta pocztowe",
    'rpt_dom_section_siteapps' => 'Aplikacje WWW',
    'rpt_dom_section_aspnetapps' => 'Aplikacje ASP.NET',
    'rpt_dom_section_webusers' => "Użytkownicy Stron",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Edycja raportu %1",
    'rpt_enter_email_address' => "Podaj adres e-mail, na który zostanie wysłany raport.",
    'rpt_list' => "Wyglądy raportów",
    'rpt_name' => "Nazwa raportu",
    'rpt_remove_reports' => "Poniższe wyglądy raportów zostaną usunięte:",
    'rpt_reports' => "Raporty",
    'rpt_section_full' => "Pełen",
    'rpt_section_none' => "Brak",
    'rpt_section_summary' => "Podsumowanie",
    'rpt_select_reports_for_remove' => "Wybierz wyglądy raportów do usunięcia.",
    'rpt_default_full' => 'Pełen raport',
    'rpt_default_summary' => 'Raport zbiorczy',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Wystąpił błąd podczas wysyłania raportu: %1",
    'rpt_send_report_by_email_ok__' => "Raport został wysłany do %1",
    'sa_action' => "Operacja",
    'sa_action_del' => "Usuń",
    'sa_action_desc' => "Co robić ze spamem poczty",
    'sa_action_save' => "Zaznacz jako spam i zachowaj w skrzynce pocztowej",
    'sa_admin_blacklist' => "Czarna lista administratora",
    'sa_admin_whitelist' => "Biała lista administratora",
    'sa_blacklist' => "Czarna lista",
    'sa_blacklist_desc' => "Zawsze zaznaczaj jako spam pocztę przychodzącą z adresów",
    'sa_by_tag' => "tagiem",
    'sa_conf_list_black' => "Czy jesteś pewien, że chcesz usunąć wybrane maski z czarnej listy ?",
    'sa_conf_list_ignore' => "Czy jesteś pewien, że chcesz usunąć wybrane maski z listy ignorowanych ?",
    'sa_conf_list_white' => "Czy jesteś pewien, że chcesz usunąć wybrane maski z białej listy ?",
    'sa_db_del_confirm' => "Czy jesteś pewien, że chcesz wyczyścić bazy danych Filtru Spamu?",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "Filtrowanie spamu jest wyłączone : serwer poczty nie obsługuje ustawień filtra spamu na poziomie skrzynki pocztowej.",
    'sa_eml_in_ignorelist' => "E-mail nie jest na liście ignorowanych",
    'sa_eml_pattern' => "Wzorzec adresu e-mail",
    'sa_empty_email' => "Nie można dodać pustej maski e-maila.",
    'sa_exists_email' => "Taka maska e-maila już istnieje.",
    'sa_disabled__mailname_not_filtering' => "Obecne ustawienia serwera nie pozwalają na filtrowanie spamu dla tej skrzynki pocztowe",
    'sa_disabled__filtering_is_disabled' => 'Administrator wyłączył filtrowanie spamu',
    'sa_disabled__hasnt_mailbox' => "Nie udało się włączyć filtrowania spamu bez skrzynki pocztowej",
    'sa_enable_filter' => "Włącz filtrowanie spamu",
    'bt_sa_clear_db' => 'Wyczyć bazę Filtru Spamu',
    'bt_sa_forget' => 'Zapomnij',
    'bt_sa_learn_as_spam' => "To jest Spam!",
    'bt_sa_learn_as_nonspam' => "To nie jest Spam",
    'sa_forget' => "opuść",
    'sa_from' => "Od",
    'sa_ham' => "ham",
    'sa_ignorelist' => "Lista ignorowanych dla serwera",
    'sa_ignorelist_desc' => "Nie filtruj poczty dla tych kont",
    'sa_pattern_in_blacklist' => "Wzorzec już istnieje na czarnej liście.",
    'sa_pattern_in_ignorelist' => "Wzorzec już istnieje na liście ignorowanych.",
    'sa_pattern_in_whitelist' => "Wzorzec już istnieje na białej liście.",
    'sa_pattern_is_invalid' => "Maska jest niepoprawna.",
    'sa_select_email' => "Wybierz przynajmniej jedną maskę e-maila z listy, aby ją usunąć.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Trening filtru spamu',
    'sa_trainer__tools_legend' => 'Narzędzia',
    'sa_trainer__info_legend' => 'Informacja',
    'sa_trainer__messages_list_legend' => 'Wiadomości w skrzynce',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Temat',
    'sa_trainer__from' => 'Od',
    'sa_trainer__date' => 'Data',
    'sa_trainer__info_text' => 'Wyuczonych wiadomości: %1 jako spam, %2 jako nie spam, %3 ogółem.',
    'sa_trainer__messages' => 'wiadomość(i)',
    'sa_trainer__select__all' => 'Wszystko',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Nie Spam',
    'sa_trainer__select__unknown_only' => 'Nieznany',
    'sa_trainer__cannot_remove_messages' => 'Nie można usunąć wybranych wiadomości ze skrzynki pocztowej.',
    'sa_trainer__remove_messages_confirm' => 'Czy jesteś pewien, że chcesz usunąć wybrane wiadomości ze skrzynki?',
    'sa_srv_blacklist' => "Czarna lista dla serwera",
    'sa_srv_whitelist' => "Biała lista dla serwera",
    'sa_subj' => "Temat",
    'sa_training' => "Trening filtru spamu",
    'sa_training_legend' => "Test filtru Bayesowskiego",
    'sa_use_srv_settings' => "Użyj ustawień serwera",
    'sa_user_blacklist' => "Czarna lista użytkownika",
    'sa_user_whitelist' => "Biała lista użytkownika",
    'sa_usr_disabled_by_srv' => "Indywidualne ustawienia filtrowania spamu są niedozwolone przez dostawcę",
    'sa_usr_no_postbox' => "Nie można włączyć filtrowania spamu, ponieważ skrzynka pocztowa jest wyłączona dla tego konta e-mail.",
    'sa_whitelist' => "Biała lista",
    'sa_whitelist_desc' => "Nigdy nie oznaczaj poczty jako spam z adresów",
    'sa_filters' => 'Filtry spamu',
    'sa_max_mail' => 'Nie filtruj, jeżeli wielkość maila przekroczy podaną wartość',
    'sa_size_limit_text' => 'limit wielkości',
    'sa_invalid__max_spam_threads' => 'Błędna wartość. Podaj wartość od 1 do 32.',
    'sa_max_threads' => 'Liczba wątków, którą może wytworzyć filtr spamu',
    'sa_max_threads_maximum' => '(maksimum 32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(niedostępne: obecny filtr spamu nie posiada tej opcji)',
    'spamfilter__tools_legend' => 'Narzędzia',
    'spamfilter__prefs_legend' => 'Ustawienia',
    'spamfilter__max_children' => 'Maksymalna liczba procesów spamd do uruchomienia',
    'spamfilter__rewrite_header_subject_hint' => 'Pozostaw puste pole jeśli nie chcesz dodać żadnego tekstu. Wpisz _SCORE_ jeśli do tytułu wiadomości chcesz dodać także punktację.',
    'spamfilter__reject_spam' => 'Usuń spam gdy przyjdzie na skrzynkę',
    'spamfilter__enabled' => 'Włączony',
    'spamfilter_addresses_list__tools_legend' => 'Narzędzia',
    'spamfilter_addresses_list__list_legend' => 'Adresy',
    'spamfilter_addresses_list__items' => 'adresy',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => 'Adres',
    'spamfilter_addresses__file_legend' => 'Z pliku',
    'spamfilter_addresses__file_label' => 'Nazwa pliku',
    'spamfilter_addresses__file_hint' => 'Wgraj plik ze znakami zakodowanymi w formacie UTF-8.',
    'spamfilter_addresses__text_legend' => 'Z listy',
    'spamfilter_addresses__text_label' => 'Adres e-mail',
    'spamfilter_addresses__remove_title' => 'Następujšce adresy zostanš usunięte z listy:',
    'spamfilter_addresses__empty_selection' => 'Nie zaznaczono żadnego adresu.',
    'server__admin_info' => "Informacja administratora",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Podaj poniżej opis błędu",
    'server__power_management' => "Zarządzanie zasilaniem",
    'server__services' => "Usługi",
    'server__system' => "System",
    'server__title' => "Administracja serwera",
    'server_preferences__admin_skin' => "Wygląd interfejsu administratora",
    'server_preferences__count_disk_space' => "W kalkulacjach zajętości dysku zawrzyj",
    'server_preferences__count_traffic' => "W kalkulacjach transferu zawrzyj",
    'server_preferences__count_type' => 'Kiedy obliczasz przestrzeń dyskowš, licz',
    'server_preferences__count_type__byte' => 'rozmiar pliku',
    'server_preferences__count_type__block' => 'rozmiar przestrzeni używanej przestrzeni dyskowej',
    'server_preferences__default_language' => "Domyślny język",
    'server_preferences__default_skin' => "Domyślny wygląd",
    'server_preferences__include_databases' => "bazy danych",
    'server_preferences__include_domaindumps' => "pliki archiwum domeny",
    'server_preferences__include_incoming' => "tylko transfer przychodzący",
    'server_preferences__include_incoming_and_outgoing' => "przychodzący i wychodzący transfer",
    'server_preferences__include_logs' => "pliki logów",
    'server_preferences__include_mailboxes' => "skrzynki pocztowe",
    'server_preferences__include_maillists' => "listy mailingowe",
    'server_preferences__include_outgoing' => "tylko transfer wychodzący",
    'server_preferences__include_remote_databases' => 'Zdalne bazy dane',
    'server_preferences__keep_stats' => "Zachowaj statystyki sieci i ruchu przez",
    'server_preferences__restart_apache_interval' => "Interwał restartu serwera Apache",
    'server_preferences__stat_warning' => "Zmiany naniesione do kalkulacji schematu pojemności dysku odniosą skutek jedynie podczas następnej kalkulacji statystyk.",
    'server_preferences__title' => "Ustawienia Serwera",
    'server_preferences__system' => 'Ustawienia systemu',
    'server_mail__title' => "Ustawienia serwera poczty",
    'mail__tabs_preferences' => "Ustawienia",
    'mail__tabs_white_list' => "Biała lista",
    'mail__tabs_blocked_domains' => "Czarna lista",
    'mail__tabs_mail_queue' => "Kolejka poczty",
    'server_preferences__use_vocabulary' => "Sprawdzaj hasła poczty w słowniku",
    'sessions__agreement' => "Tak, chcę zakończyć te sesje.",
    'sessions__select_sessions_for_remove' => "Wybierz sesje, które chcesz załączyć.",
    'sessions__tabs_cp_sessions' => 'Sesje Plesk',
    'sessions__tabs_ftp_sessions' => 'Sesje FTP',
    'sessions__ftp_sessions_login' => 'Login użytkownika FTP',
    'sessions__ftp_sessions_domain' => 'Nazwa domeny',
    'sessions__ftp_sessions_path' => 'Aktualna ścieżka',
    'sessions__ftp_sessions_file' => 'Nazwa pliku',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Prędkość, KB/S',
    'sessions__ftp_sessions_comp' => 'Postęp, %',

    'site_apps__access_level' => 'Poziom dostępu',
    'site_apps__access_level_commercial' => 'Komercyjny',
    'site_apps__access_level_free' => 'Darmowy',
    'site_apps__action_installer' => "Instalacja aplikacji webowej",
    'site_apps__action_reconfigure' => "Re-konfiguracja aplikacji WWW",
    'site_apps__custom_button_level' => 'Własny przycisk dostępu do aplikacji?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nie',
    'site_apps__custom_button_level_domain_user_only' => 'Tak',
    'site_apps__custom_button_level_false' => 'Nie',
    'site_apps__custom_button_level_domain' => 'Tak, udostępnij tylko dla aktualnej domeny',
    'site_apps__custom_button_level_client' => 'Tak udostępnij dla wszystkich domen klienta',
    'site_apps__custom_button_level_admin' => 'Tak, udostępnij dla wszystkich domen',
    'site_apps__description' => "Opis",
    'site_apps__dir_used_by_sapp__' => "Katalog \"%1\" jest używany przez inną aplikację WWW",
    'site_apps__dir_used_by_unknown__' => "Katalog \"%1\" już istnieje. Jego zawartość będzie nadpisana.",
    'site_apps__dir_invalid_name__' => "Nazwa katalogu %1 nie jest właciwa",
    'site_apps__file_name' => 'Nazwa pliku aplikacji WWW',
    'site_apps__invalid_install_prefix' => "Błędny prefiks instalacji",
    'site_apps__invalid_package' => "Aplikacja WWW jest nieważna",
    'site_apps__key_status' => 'Licencjonowanie',
    'site_apps__key_status_free' => 'Dystrybucja bez ograniczeń. Nie jest wymagana licencja',
    'site_apps__key_status_ok' => 'Wymagany klucz licencji jest zainstalowany',
    'site_apps__key_status_problem' => 'Wymagany klucz licencji nie jest zainstalowany',
    'site_apps__name' => "Nazwa",
    'site_apps__no_domains' => 'Aplikacja WWW nie może zostać zainstalowana. Istnieje już inna aplikacja zainstalowana w katalogu root tej domenie. Rozważ utworzenie subdomeny dla tej aplikacji.',
    'site_apps__package_info_' => "Informacje o aplikacji WWW",
    'site_apps__package_integrated' => "Zintegrowana aplikacja WWW nie może być usunięta",
    'site_apps__pool_select_packages_to_add' => 'Zaznacz pakiety aplikacji do usunięcia z puli',
    'site_apps__release' => "Wersja",
    'site_apps__resource_used_by_sapp' => "Ten zasób jest używany przez zainstalowaną aplikację WWW",
    'site_apps__root_used_by_sapp' => "Zasób jest używany przez zainstalowanš aplikację WWW",
    'site_apps__these_domains_will_not_delete' => 'Te (pod)domeny nie zostaną usunięte',
    'site_apps__upload_site_app_pkg_title' => 'Wgraj nową aplikację WWW',
    'site_apps__version' => "Wersja",
    'site_apps__access_to' => "Dostęp do %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Zarządzanie szkieletem",
    'skeleton__client_label' => "%1 zdefiniowanych szkieletów",
    'skeleton__admin_page' => "Zarządzanie szkieletem",
    'skeleton__files_list' => "Plikami i katalogami",
    'skeleton__archiver_not_installed' => "Nie można rozpakować szkieletu. Program rozpakowujący nie jest prawdopodobnie zainstalowany na serwerze. Skontaktuj się z administratorem {$PROD_NAME} w celu zainstalowania programu rozpakowującego.",
    'skeleton__client_page' => "Zarządzanie szkieletem",
    'skeleton__archive_corrupted' => "Test archiwum odkrył, że ten plik archiwum albo jest zepsuty albo nie jest obsługiwanego typu.",
    'skeleton__archive_too_large' => "Test archiwum wykrył, że ten plik archiwum ma za duży rozmiar.",
    'skeleton__not_supported_archive_type' => "Ten typ archiwum (plik %1) nie jest obsługiwany.",
    'skeleton__upload_archive_file' => "Wgraj plik archiwum szkieletu",
    'skin_download__title' => 'Pobierz Skórę',
    'skin_download_now__title' => 'Pobieranie skóry',
    'skin_download_now__text' => 'Trwa tworzenie pakietu skórki.<br>Może to potrwać kilka minut.<br>W momencie gdy pokaże się okno dialogu, możesz kontynuować korzystanie z Plesk.',
    'skin_file__help_for_using_types' => "Proszę używaj skór w następujących formatach archiwum",
    'skin_info__title' => 'Właściwości skóry',
    'skin_mng_err__rpm_not_skin' => 'rpm nie zawiera skóry systemu Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Nie można zainstalować skóry RPM w dowolnym miejscu.',
    'skin_mng_err__already_exists' => 'Katalog instalacyjny już istnieje.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Nie można podmienić skóry zwykłej na skórę RPM.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Nie można podmienić skóry RPM na skórę zwykłš.',
    'skin_mng_err__rpm_upgrade_base' => "Nie można podmienić skóry podstawowej {$PROD_NAME} na pakiet skóry.",
    'skin_mng_err__rpm_upgrade_other' => 'Nie udało sie zainstalować skórę: niewłaciwe formatu.',
    'skin_mng_err__no_a_skin' => "Nie można podmienić skóry podstawowej {$PROD_NAME} na pakiet skóry.",
    'skin_upload__title' => 'Wyślij nową skórę',
    'skin_upload__already_exists' => "Skóra '%1' już istnieje.",
    'skin_upload__unable_to_apply' => "Wgrany plik nie zawiera poprawnej skóry Plesk, albo format archiwum nie jest dostępny.",
    'skin_upload__unable_to_rename__' => "Nie można było zmienić skórki %2 na %1: %3.",
    'skin_upload__file_name' => 'Ścieżka do pliku skóry',
    'skins_list__title' => 'Lista skór',
    'skins_remove__title' => 'Usuwanie skór',
    'skins_remove__select_skins_for_remove' => 'Zaznacz skóry do usunięcia',

    'spamassassin__title' => "Konfiguracja filtru spamu",
    'spf__unable_update' => 'Nie udało się zaktualizować parametrów SPF',
    'sshterm__title' => 'Secure Shell Terminal',
    'sshterm__password_authentication_warning' => 'Uwaga: Autentykacja hasłem jest wyłšczona na lokalnym serwerze SSH. Nie możesz się połšczyć się korzystajšc z Terminala SSH, skontaktuj się z administratorem aby ustawił "PasswordAuthentication yes" w pliku /etc/ssh/sshd_config.',
    'sshterm__password_authentication_warning_admin' => 'Uwaga: Autentykacja hasłem jest wyłšczona na lokalnym serwerze SSH. Jeli nie możesz połšczyć się przez Terminal SSH ustaw opcję, "PasswordAuthentication yes" w pliku /etc/ssh/sshd_config.',
    'statistics__active_domains' => "Aktywne domeny",
    'statistics__clients' => "Klienci",
    'statistics__subdomains' => "Subdomeny",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Bazy danych",
    'statistics__db_users' => "Użytkownicy bazy danych",
    'statistics__dirs' => "Chronione katalogi",
    'statistics__dom_active' => "Aktywny",
    'statistics__dom_passive' => "Pasywne",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Domeny",
    'statistics__domains_with_host' => "Domeny z hostingiem",
    'statistics__doms' => "Domeny",
    'statistics__filesystem' => "System plików",
    'statistics__general' => "Ogólny",
    'statistics__hdd_available' => "Dostępne",
    'statistics__hdd_capacity' => "Pojemność",
    'statistics__hdd_total' => "Suma",
    'statistics__hdd_usage' => "Użycie dysku",
    'statistics__hdd_used' => "Zużyto",
    'statistics__ip' => "Adres IP",
    'statistics__key_number' => "Numer klucza",
    'statistics__l1' => "Ostatnia 1 minuta",
    'statistics__l15' => "Ostatnie 15 minut",
    'statistics__l5' => "Ostatnie 5 minut",
    'statistics__la' => "Użycie CPU",
    'statistics__mail_autoresponders' => "Autorespondery",
    'statistics__mail_boxes' => "Skrzynki pocztowe",
    'statistics__mail_groups' => "Grupy pocztowe",
    'statistics__mail_lists' => "Listy mailingowe",
    'statistics__mail_redirects' => "Przekierowania poczty",
    'statistics__mem' => "Użycie pamięci",
    'statistics__mem_usage' => "Użycie",
    'statistics__memory_available' => "Dostępne",
    'statistics__memory_buffer' => "Bufor",
    'statistics__memory_cached' => "W pamięci podręcznej",
    'statistics__memory_free' => "Darmowy",
    'statistics__memory_shared' => "Współdzielony",
    'statistics__memory_total' => "Suma",
    'statistics__memory_used' => "Zużyto",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Problemy z klientami:",
    'statistics__problem_domains' => "Problemy z domenami:",
    'statistics__swap' => "Użycie swapu",
    'statistics__swap_free' => "Darmowy",
    'statistics__swap_total' => "Suma",
    'statistics__swap_usage' => "Użycie",
    'statistics__swap_used' => "Zużyto",
    'statistics__system_stat' => "Informacje o serwerze",
    'statistics__unable_define_active_doms' => "Nie można określić ilości aktywnych domen: %1",
    'statistics__unable_define_inactive_doms' => "Nie można określić ilości nieaktywnych domen: %1",
    'statistics__failed_define_swap_usage' => 'Nie udało się zdefiniować użycia wymiany',
    'statistics__failed_define_load_averages' => 'Nie udało się zdefiniować średnich obciążeń',
    'statistics__up_time' => "Czas działania systemu:",
    'statistics__ver' => "Wersja",
    'statistics__web_users' => "Użytkownicy Stron",
    'statistics__mem_win' => "Użycie Pamięci Fizycznej",
    'statistics__memory_total_win' => "Suma",
    'statistics__memory_used_win' => "Zużyto",
    'statistics__memory_free_win' => "Dostępne",
    'statistics__swap_win' => "Użycie Pamięci Wirtualnej",
    'statistics__swap_total_win' => "Suma",
    'statistics__swap_used_win' => "Zużyto",
    'statistics__swap_free_win' => "Dostępne",
    'status__domain_has_reasons_to_be_off' => "Domena jest nadal zablokowana. Przyczyna: %1",
    'subdomain__create__' => "Utwórz subdomenę w domenie %1",
    'subdomain__edit__' => "Edytuj subdomenę %1",
    'subdomain__invalid_name' => "Błędna nazwa poddomeny: proszę używać jedynie symboli alfanumerycznych.",
    'subdomain__incorrect_name' => "Błędna nazwa poddomeny.",
    'subdomains__maillists_enabled_in_domain' => "Błędna nazwa list subdomeny.%1, w domenie %1 listy mailingowe są włączone.",
    'subdomains__dalias_exists' => 'Alias domeny o takiej nazwie już istnieje.',
    'subdomains__name_exists' => "Poddomena o takiej nazwie już istnieje.",
    'subdomains__regular_domain_exists' => "Domeny o takiej nazwie już istnieje.",
    'subdomains__domain_alias_exists' => 'Alias domeny o takiej nazwie już istnieje.',
    'subdomains__remove_subdomains_on_domain' => "Poniższe subdomeny w domenie %1 zostaną usunięte:",
    'subdomains__select_subdomains_for_remove' => "Wybierz subdomeny do usunięcia.",
    'subdomains__webmail_enabled_in_domain' => "Niepoprawna nazwa poczty WWW poddomeny.%1: Ta nazwa domeny jest używana do dostępu do poczty WWW pod domeną %1.",
    'subdomains__dns_record_already_exists' => 'Taki rekord jest już w strefie %1. Rekord DNS dla hosta %1 już istnieje.',
    'subdomains__www_prefix_in_domain' => "Błędna nazwa subdomeny www.%1: domena %1 posiada już alias WWW.",
    'subdomains__user_type_quota_exceeds' => 'Nie można było zmienić konta użytkownika ponieważ mogłoby to spowodować przekroczenie przydzielonych zasobów dyskowych.',
    'subdomains__creation_in_dns_slave' => "Serwer nazwy Pleska działa jako drugi (podrzędny) serwer nazwy dla tej domeny. Aby poddomena działała poprawnie, musisz upewnić się, że plik strefy na głównym (master) serwerze zawiera rekord %1.",
    'sys_user__attributes_not_changed' => "Poniższe atrybuty użytkownika systemu nie zostały zmienione: %1",
    'sys_user__no_access_without_password' => "Nie ustawiłeś hasła. Użytkownik systemu zostanie stworzony, ale nie będzie w stanie zalogować się do niego, dopóki on/ona nie poda hasła. Czy chcesz kontynuować?",
    'sys_user__no_hard_quota' => "nie obsługiwane",
    'sysuser__zero_quota_is_unlimited' => "0 dla bez ograniczeń",
    'template__num_excl_ips' => "Przydziel dedykowany adres IP do klienta",
    'template__sel_sh_ips' => "Wybierz współdzielone adresy IP",
    'template__av_sh_ips' => "Dostępne współdzielone adresy IP",
    'template__up_to_excl_ip' => "Do %1 adresów IP",
    'templates__all_clients' => "wszyscy klienci",
    'templates__cl_domain_templates' => "Szablon dla %1",
    'templates__cl_templates' => "Szablony klienta",
    'time__invalid_ip' => "Błędne IP lub nazwa domeny.",
    '__please_select_country' => 'Wybierz swój kraj',
    'time__unable_set_time' => "Nie można ustawić czasu systemu: %1",
    'time__sinchronization_setup_error' => 'Nie można skonfigurować synchronizacji czasu: timemng nie działa: %1',
    'time__sinchronization_disable_error' => 'Nie można wyłączyć synchronizacji czasu: timemng nie działa: %1',
    'tmpl__create' => "Stwórz szablon",
    'tmpl__edit__' => 'Edytuj szablon %1',
    'tmpl__logrotation_warn' => "Rotacja logów dla domeny utworzonej przez ten szablon będzie przeprowadzona jedynie w przypadku następstwa utworzenia konta fizycznego hostingu dla tej domeny.",
    'tmpl__name' => "Nazwa szablonu",
    'tmpl__dom_exist' => "Szablon domeny z taka nazwš już istnieje w kolejce klienta lub administratora.",
    'tmpl__name_invalid' => "Nazwa szablonu jest błędna lub pusta.",
    'tmpl__use_next_ip_addr' => "Użyty zostanie kolejny wolny adres IP",
    'tmpl_name_already_exists' => "Szablon o nazwie '%1' już istnieje.",
    'traffic__no_periods_found' => "Nie można wywietlić statystyk transferu. Ta funkcja będzie dostępna jedynie po następnej kalkulacji statystyk.",

    'vh_based__no_free_ip_for_vh' => "Nie ma wolnych adresów IP dla wirtualnego hostingu opartego o IP. Proszę, dodaj adres IP.",

    'wu__at_domains_text' => "Dopuść format dostępu webuser@%1",
    'wu__unable_create' => "Nie można utworzyć użytkownika web: %1",
    'wu_edit__disk_quota' => "Ograniczenie dysku",
    'wu_edit__invalid_pass' => "Hasło jest błędne.",
    'wu_edit__invalid_quota' => "Podana wartość ograniczenia przestrzeni dysku jest błędna. Podaj wartość dodatnią.",
    'wu_edit__invalid_quota_value' => "Podana quota jest mniejsza niż bieżące użycie powierzchni dyskowej (%1MB). Niektóre funkcjonalności mogą stać się niedostępne. Czy chcesz kontynuować?",
    'wu_edit__not_create_pass' => "Ta akcja nie utworzy hasła dla nowego użytkownika web.\nBez hasła użytkownik nie będzie w stanie się zalogować.",
    'wu_edit__unable_update' => "Nie można zaktualizować właściwości użytkownika web: %1",

    'bt_webdirs' => 'Wirtualne katalogi',

    'dns__tabs_general' => 'Ustawienia strefy',
    'dns__tabs_zone_settings' => 'Rekordy SOA',
    'soa__seconds' => 'sekundy',
    'soa__minutes' => 'minuty',
    'soa__hours' => 'godziny',
    'soa__days' => 'dni',

    'DomainSubdirectory' => 'Docelowy podkatalog',

    'filemanager__select_codepage' => 'Wybierz stronę kodową:',

    'bt_server_app_add' => 'Dodaj aplikację serwerową',
    'packages_list' => 'Aplikacje serwera',

    'bt_packages_management' => 'Zarządzanie Pakietami',
    'pb__packages_management' => 'Zarządzanie aplikacjami',
    'bt_package_new' => 'Dodaj aplikację',
    '__packages' => 'Aplikacje serwera',

    'dom_ctrl__mysql_dbase_space' => 'Limit baz danych MySQL w sumie',
    'dom_ctrl__mssql_dbase_space' => 'Limit baz danych MS SQL w sumie',
    'server_preferences__include_mysql_databases' => 'Bazy danych MySQL',
    'server_preferences__include_mssql_databases' => 'Bazy danych Microsoft SQL',

    'check_permissions__domains_selection' => 'Następujące uprawnienia domen zostaną sprawdzone',

    'dns_add__enter_ixfr_path' => 'Podaj ścieżkę IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Taki rekord TXT DNS już istnieje. Może być tylko jeden rekord SPF. Aby dodać rekord, najpierw usuń istniejący.',

    'component_name__network' => 'Sieć',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Ustaw Skórkę',
    'bt_set_skin' => 'Ustaw Skórkę',
    'firewall__rule_already_exists' => 'Reguła o nazwie "%1" już istnieje',
    'pb__firewall' => 'Zapora',
    'ruleeditform__incorect_port_value' => 'Numer portu powinien być pomiędzy 1 i 65535.',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Lokalizacja pliku jest nieprawidłowa.',

    'error_doc__erorr_invalid_url_location' =>  'Błędny format URL. Proszę podać bezwzględny URL wewnątrz wirtualnego hosta (strony).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antywirus',
    'antivirus__antivirus' => 'Ochrona Antywirusowa',
    'antivirus__antivirus_direction_off' => 'Wyłączony',
    'antivirus__antivirus_direction_any' => 'Przychodząca i wychodząca poczta',
    'antivirus__antivirus_direction_from' => 'Tylko poczta wychodząca',
    'antivirus__antivirus_direction_to' => 'Tylko poczta przychodząca',
    'antivirus__unable_to_update_settings' => 'Nie jest możliwe zmienienie ustawień antywirusa: %1',




    '__normal' => 'Normalny',
    '__low' => 'Niski',
    '__high' => 'Wysoki',

    'mail__antivirus' => "Wewnętrzny antywirus serwera pocztowego",
    'mail__use_internal_antivirus' => 'Używaj wewnętrznego antywirusa',

    'sa__tabs_general' => 'Ogólny',
    'sa__tabs_whitelist' => 'Biała lista',
    'sa__tabs_blacklist' => 'Czarna lista',
    'sa__tabs_trustednetworks' => 'Zaufane sieci',
    'sa__alarm_message_text' => 'Tekst ostrzeżenia o wykryciu spamu',
    'sa__ok_languages' => 'Zaufane języki',
    'sa__language_groups_available' => 'Dostępne pakiety językowe',
    'sa__language_groups_belonged' => 'Wybrane zaufane języki',
    'sa__ok_locales' => 'Zaufane ustawienia lokalne',
    'sa__locale_groups_available' => 'Dostępne grupy lokalne',
    'sa__locale_groups_belonged' => 'Wybrane zaufane grupy lokalne',

    'sa_trustednetworks' => 'Lista zaufanych sieci',
    'sa_tn_address' => 'Sieć/Maska',
    'sa_trustednetworks_desc' => 'Wybrane zaufane sieci',

    '__mysql_databases' => 'Baza Danych MySQL',

    'check_permissions__read_only' => 'Tryb tylko sprawdzaj',
    'check_permissions__notification_email' => 'Wyślij powiadomienie za pomocą e-mail',

    'cl_perm__mysql_dbase_space' => 'Limit baz danych MySQL w sumie',
    'cl_perm__mssql_dbase_space' => 'Limit baz danych MS SQL w sumie',
    'cl_perm__max_mssql_db' => 'Maksymalna liczba baz danych Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Całkowita quota pocztowa',

    'check_permissions_warning' => 'Ta procedura może zająć sporo czasu zanim się zakończy, proszę być cierpliwym i nie anulować ładowania strony.',

    'i_i_cl_on' => 'Konto klienta jest aktywne.',
    'i_i_cl_off_by_admin' => 'Konto klienta jest wyłączone przez administratora.',

    'check_permissions__email_is_invalid' => 'Podany adres email jest nieprawidłowy.',

    'sa_invalid_tn_ip' => 'Wartość IP jest nieprawidłowa.',
    'sa_invalid_tn_mask' => 'Wartość maski jest nieprawidłowa.',
    'sa_exists_tn' => 'Ta sieć jest już na liście.',
    'sa_select_tn' => 'Nie wybrano żadnej sieci do usunięcia.',
    'sa_conf_list_tn' => 'Proszę potwierdzić usuwanie zaznaczonych sieci.',

    'firewall__tabs_general' => 'Ogólny',
    'firewall_tabs_icmp' => 'Protokołów ICMP',

    'firewallicmpform__title' => 'Zasady zapory ogniowej dla protokołu ICMP',
    'firewallicmpform__icmpsettings_list_legend' => 'Zasady zapory ogniowej dla protokołu ICMP',
    'firewallicmpform__icmpsettingslist' => 'Reguły',
    'icmpsettingslist__enabled' => 'S',
    'icmpsettingslist__type' => 'Nazwa reguły',
    'firewall__icmp_type_allowinboundrouterrequest' => 'Zezwól na przychodzące żądania routera',
    'firewall__icmp_type_allowinboundtimestamprequest' => 'Zezwól na przychodzące żądania timestamp\'a',
    'firewall__icmp_type_allowinboundmaskrequest' => 'Zezwól na przychodzące żądania maski',
    'firewall__icmp_type_allowoutboundsourcequench' => 'Zezwól na wychodzące żądania typu "source quench"',
    'firewall__icmp_type_allowoutboundparameterproblem' => 'Zezwól na wychodzący parametr problemu',
    'firewall__icmp_type_allowredirect' => 'Zezwól na przekierowania',
    'firewall__icmp_type_allowinboundechorequest' => 'Zezwól na przychodzące żądania typu echo',
    'firewall__icmp_type_allowoutboundtimeexceeded' => 'Zezwól na wychodzące żadąnia typu przekroczono czas',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => 'Zezwól na wychodzące żądania typu punktdocelowy nieosiągalny',


    'webdir__select_vdirs_to_remove' => 'Zaznacz katalogi, które chcesz usunąć',
    'webdir__select_mime_types_to_remove' => 'Zaznacz typy MIME, które chcesz usunąć',

    'defaultcomponents__not_activated' => 'nie aktywowany',

    'bt_traffic_at_domains' => 'Ruch',

    'firewall__icmpsettingslist' => 'Reguły',
    'icmpsettingslist__name' => 'Nazwa reguły',

    '__awstats_perl_warning' => 'Bez zainstalowanego języka Perl, AWStats nie będzie pozwalało użytkownikowi sprawdzać statystyki dla poprzednich lat.',

    'class_client__mysql_dbase_space' => 'Wartość przekracza limit przyznany klientowi',
    'class_client__mssql_dbase_space' => 'Wartość przekracza limit przyznany klientowi',
    'class_client__max_mssql_db' => 'Wartość przekracza limit przyznany klientowi',

    'firewall__icmp_reset_configuration' => 'Czy na pewno chcesz przywrócić domyślne ustawienia zapory ogniowej?',
    'firewall__icmp_panic_configuration' => 'Czy na pewno chcesz włączyć Tryb Paniki? Niektóre z usług sieciowych mogą przestać działać.',


    'dns__remove_transfer_restrictions_list_items' => 'Następujące sieci zostaną usunięte z listy kontroli dostępu:',

    'firewall__select_rule_to_remove' => 'Zaznacz reguły do usunięcia',

    'bt_up' => "Do góry",
    'bt_down' => "W dół",
    'virtualdir__type_default_doc_name_to_add' => 'Wprowadź nazwę pliku do dodania na listę',
    'virtualdir__select_default_doc_to_remove' => 'Wybierz z listy pliki, które mają zostać usunięte',

    'bt_install_selected' => 'Instaluj Klucze Licencji', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Ta domena rozwiązuje do innego adresu IP: (%1). Popraw ustawienia DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Serwer pocztowy nie obsługuje skrzynek pocztowych oraz grup poczty włączonych w tym samym czasie. Naciśnij OK, by włączyć skrzynkę pocztową i tym samym wyłączyć grupowanie poczty. Kliknij Anuluj, aby nie wprowadzać zmian.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Serwer pocztowy nie obsługuje skrzynek pocztowych oraz grup poczty włączonych w tym samym czasie. Naciśnij OK, by włączyć skrzynkę pocztową i tym samym wyłączyć grupowanie poczty. Kliknij Anuluj, aby nie wprowadzać zmian.',

    'mysql_dbase_space_limit' => 'Limit przestrzeni bazy danych MySQL',
    'mysql_dbase_usage' => 'Zużycie miejsca przez bazę danych MySQL',
    'mssql_dbase_space_limit' => 'Limit przestrzeni serwera baz danych Microsoft SQL',
    'mssql_dbase_usage' => 'Zużycie miejsca dysku przez bazę danych Serwera Microsoft SQL',

    '__statistics' => "statystyki", //indirect

    'dns__soa_minimum_value_is_big' => 'Ustawienie minimalnej wartości TTL jako dłuższej niż 3 godziny może spowodować, że twoje domeny będą niedostępne dla niektórych administratorów domeny. Rekomendujemy użycie takich wartości, tylko wtedy kiedy twój registrar domenowy nalega na to.',

    'virusfilter__interface_not_available' => 'Brak dostępnych filtrów antywirusowych.',
    'virusfilter__none_virus_filter' => 'Brak',
    'virusfilter__mailname_status_text' => 'Antywirus (%1)',
    'virusfilter__status_none' => 'Wyłączony',
    'virusfilter__status_any' => 'przychodząca i wychodząca poczta',
    'virusfilter__status_outgoing' => 'tylko wychodząca poczta',
    'virusfilter__status_incoming' => 'tylko przychodząca poczta',

    'visibility__adminonly' => 'Tylko Admin',
    'visibility__button_sets' => 'Kontrole',
    'visibility__control' => 'Kliknij by dopasować tę kontrolkę.',
    'visibility__customization_footnote' => 'Kliknij OK aby zakończyć dopasowywanie tego ekranu.',
    'visibility__default' => 'Domyślny',
    'visibility__export_note' => "Ustawienia dostosowawcze jakie zrobiłeś zostaną za chwilę wyeksportowane. Zostanie teraz zgrany skrypt powłoki na twój komputer. Aby wgrać ustawienia na inny serwer Plesk, nadpisując wszystkie istniejące ustawienia interfejsu, proszę wgraj i uruchom ten skrypt na tym serwerze.\n\nZauważ, że jeżeli wprowadziłeś jakiś zmiany na tym ekranie ale nie kliknąłeś OK, wyeksportowane dane nie będą zawierały tych ostatnich zmian.",
    'visibility__hide' => 'Ukryj',
    'visibility__reset_all' => 'Przywróć ustawienia domyślne',
    'visibility__reset_screen' => 'Przywróć oryginalny wygląd obecnego ekranu',
    'visibility__root_override_parse_error' => 'To jest błąd składni w pliku %1 w linii %2.',
    'visibility__screen_title' => 'Zarządzanie interfejsem',
    'visibility__set_billing_enabled' => 'Odłącz Customer Managera i Business Managera',
    'visibility__set_cert_puchasing' => 'Ukryj przyciski do zakupu certyfikatów',
    'visibility__set_domain_registration' => 'Ukryj przyciski do rejestracji domen',
    'visibility__set_extras' => 'Ukryj przyciski dla dodatkowych usług',
    'visibility__set_mail_bounce' => 'Ukryj kontrolki dla wiadomości odrzucanych dla nieistniejących adresów pocztowych',
    'visibility__show' => 'Pokaż',
    'visibility__show_toolbar' => 'Pokaż pasek zarządzania interfejsem',
    'visibility__standby_footnote' => 'Kliknij, aby dopasować kontrolki na tym ekranie.',
    'visibility__standby_footnote_nocontrols' => 'Nie ma żadnych kontrolek z możliwością dopasowania na tym ekranie.',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "Komponent nie posiada automatyzacji publikacji",

    'component_name__cphosting' => "Hosting Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Ustawianie ograniczeń wielkości skrzynek pocztowych nie jest wspierane przez serwer pocztowy.',
    '__unable_get_total_mboxes_quota' => 'Ustawianie ograniczeń wielkości skrzynek pocztowych nie jest wspierane przez serwer pocztowy.',

    'install_prefix__parent_not_exists' => "Nadrzędny katalog nie istnieje.",

    'bt_change_version' => 'Zmień wersję',
    'aspdotnet__changeversion_title' => 'Wybieranie Wersji ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Wybierz wszystkie",
    '__uncheck_all' => "Wyczyść wszystko",

    'dns__editing_domain_controller_zone' => "Edytowanie stref DNS dla kontrolera domeny może powodować problemy w funkcjonowaniu domeny",

    'pb__interface_management' => "Zarządzanie interfejsem",
    'interface_management__tabs_skins' => "Skóry",
    'interface_management__tabs_interface_templates' => "Szablony interfejsu",
    'interface_management__tabs_locales' => "Wersje językowe",
    'locales_list__title' => "Składnica pakietów językowych",
    'locales_list__legend' => "Dostępne pakiety językowe",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Pakiet językowy",
    'locales_list__lang_title' => "Język",
    'locales_list__country_title' => "Kraj",
    'locales_list__used_title' => "Zużyto",

    'backup__suspend_warning_during_backup' => "Domena będzie niedostępna podczas wykonywania kopii zapasowej",
    'backup__suspend_warning_during_restore' => "Domena będzie niedostępna podczas odtwarzania kopii zapasowej",
    'backup__suspend_domain' => "Zawieś domenę",

    'locales_list__mls_limit' => "Twoja obecna licencja Pleska pozwala na używanie %2 języków. W tej chwili %1 języków jest dostępnych dla użytkowników, co przekracza liczbę określoną w licencji. Wybierz %2 języki, które chcesz wykorzystać, a pozostałe oznacz, jako niedostępne dla użytkowników, klikając ich ikonę w kolumnie 'S'.",

    'bt_change_owner' => 'Zmień właściciela',
    'chown__new_owner' => 'Nowy właściciel',
    'chown__selected_domains' => 'Wybierz domeny',
    'chown__limits_legend' => 'Zasoby',
    'chown__limit_name' => 'Nazwa zasobu',
    'chown__limit_value' => 'Przydzielone zasoby',
    'chown__limit_assigned_before' => 'Przed transferem',
    'chown__limit_assigned_after' => 'Po transferze',
    'chown__error_limits' => "Nie można kontynuować transferu domeny: eomena wymaga zasobów, które nie są dostępne na koncie docelowego użytkownika.",
    'chown__error_no_domains' => 'Nie można kontynuować transferu domeny: nie wybrano subskrypcji lub wybrane subskrypcje już należą do docelowego użytkownika.',
    'chown__error_empty_ip_pool' => "Nie można kontynuować transferu domeny: Pula IP klienta jest pusta. Przydziel najpierw kolejne IP do klienta.",
    'chown__please_select_new_domain_owner' => 'Wybierz nowego właściciela do tej domeny',
    'chown__old_ip_address' => 'Stary adres IP',
    'chown__new_ip_address' => 'Nowy adres IP',

    'chown__error_ssl_already_used' => "Obsługa SSL/TLS jest już używana na docelowych IP: %1: Dlatego następujące domeny z obsługą SSL/TLS nie mogą być przeniesione: %2. Proszę, rozwiąż ten problem i spróbuj ponownie",
    'chown__sitebuilder_not_installed' => 'Presence Builder jest niezainstalowany',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domena %1 nie może być transferowana do innego właściciela ponieważ Presence Builder nie jest zainstalowany..',

    'backup__backup_time' => 'Czas Backupu',
    'backup__backup_time_hour' => 'godziny',
    'backup__backup_time_minute' => 'minuty',
    'backup__every' => 'każdego',
    'backup__day_of_month' => 'dzień miesiąca',

    'subdomain__select_hst_type' => 'Wybierz typ hostingu dla poddomeny',
    'hst_sel__subdom_subfolder_hst' => 'Subdomena dla podkatalogu',
    'subdomain__www_root_folder_not_exists' => 'Katalog domowy strony %1 nie istnieje',
    '__site_home_dir' => 'Katalog domowy strony',
    'subdomain__aspnet_disabled_domain' => 'wyłączone przez domenę',

    'domains__remove_description' => 'Wszystkie dane dotyczące domeny, włączając w to domeny, subdomeny, dane aplikacji webowych, zawartość skrzynek pocztowych, ustawienia antywirusa i filtru spamowego, pliki logów, repozytorium kopii zapasowych oraz certyfikaty SSL/TLS, zostaną skasowane. Jeśli nie masz pliku z archiwum na swoim komputerze, wszystkie dane zostaną na zawsze utracone.',
    'subdomains__remove_description' => 'Wszystkie dane poddomeny, w tym zawartość poddomeny i jej ustawienia, dane aplikacji webowych oraz logi zostaną usunięte. Jeśli nie masz pliku z archiwum na swoim komputerze, wszystkie dane zostaną na zawsze utracone.',

    'mail__tabs_spam_filtering' => 'Filtrowanie spamu',
    'mail__tabs_antivirus' => 'Antywirus',
    'server_mail__usage_policy_legend' => 'Polityka użytkowania',
    'server_mail__for_incoming_mail' => 'Dla poczty przychodzącej',
    'server_mail__for_outgoing_mail' => 'Dla poczty wychodzącej',
    'server_mail__antivirus_direction_off' => 'Skanowanie wyłączone',
    'server_mail__antivirus_direction_any' => 'Skanuj pocztę wychodzącą i przychodzącą',
    'server_mail__antivirus_direction_from' => 'Skanuj tylko pocztę wychodzącą',
    'server_mail__antivirus_direction_to' => 'Skanuj tylko pocztę przychodzącą',
    'antivirus__use_server_settings_scan' => 'Użyj globalnych ustawień serwera (skanuj)',
    'antivirus__use_server_settings_no_scan' => 'Użyj globalnych ustawień serwera (nie skanuj)',
    'antivirus__check_for_viruses' => 'Skanuj w poszukiwaniu wirusów',
    'antivirus__dont_check_for_viruses' => 'Nie skanuj w poszukiwaniu wirusów',
    'antivirus__incoming_mail' => 'Przychodząca poczta',
    'antivirus__outgoing_mail' => 'Wychodząca poczta',

    'domain_alias__CNAME_dns_record_exists' => 'Rekord CNAME o takiej nazwie już istnieje',
    'domain_alias__A_dns_record_exists' => 'Rekord A o takiej nazwie już istnieje',
    'domain_alias__bad_prefix' => 'Zły prefiks dla aliasu domeny',
    'domain_alias__domain_doesnt_exist' => "Domena nie istnieje",

    'dns__zone_ttl_message_info' => 'Jeśli wartość TTL nie zostanie określona, dla tego rekordu DNS zostanie użyta wartość TTL z szablonu rekordu SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Plik o nazwie index.html zostanie utworzony, aby przekierowywać do wybranych aplikacji webowych. Jeśli plik o tej nazwie już istnieje, zostanie on zarchiwizowany jako index.html.old i zastąpiony nowym plikiem. Kliknij OK, aby potwierdzić",

    'bt_ftp_ctrl' => "Dodatkowe konta FTP",
    'ftp_users_no_permission' => "Nie masz uprawnień do zarządzania kontami FTP dla tej domeny",
    'ftp_users_limit_reached' => "Limit kont FTP dla tej domeny został osiągnięty",
    'pb__ftp_ctrl' => "Zarządzanie FTP",
    'class_client__max_subftp_users' => "Dodatkowe konta FTP",

    '__client_form_settings' => "Ustawienia klienta",
    '__sbnet_client_keep_sbnet' => "Utrzymaj korespondujšce konto użytkownika w Presence Builder",
    '__sbnet_cant_add_more_sites' => "Ten klient osiągnął limit liczby stron używających Presence Builder",
    '__sbnet_legend_text' => "Integracja Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Utwórz korespondujące konto użytkownika w Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Próbujesz usunąć konto użytkownika Presence Builder powiązane z tym klientem. To usunie wszystkie strony webowe użytkownika i wszystkie ustawienia Presence Builder ich dotyczące, usuwając możliwość edycji istniejących stron przez Presence Builder, nawet jeśli później ponownie włączysz tą opcję. Jeśli później stworzysz konto użytkownika Presence Builder, będziesz musiał tworzyć i publikować wszystkie strony webowe od nowa. Czy chcesz wyłączyć tworzenie i publikację stron przez Presence Builder ?",
    'sb__build_site_with_subdomains' => "Utwórz poddomeny dla bloga i galerii zdjęć",
    '__sbnet_client_dont_have_sbuser' => "Nie można utworzyć i opublikować serwisu używając Presence Builder: Użytkownik Presence Builder nie istnieje",

    '__component_disabled' => "Komponent wyłączony",

    'subdomains__physical_path_not_exist' => "Te poddomeny są podłączone do nieistniejących fizycznie folderów",

    'dnsserver_bind_to_msdns_switching_warning' => "Uwaga: tylko pierwsze 254 adresy IP podsieci z /8 i /16 maskami zlokalizowane na liście w panelu kontrolnym zostaną przeniesione. Zostaną przeniesione jako odrębne adresy IP. Chcesz kontynuować?",

    '__sbnet_net_framework_required_for_site' => "Strony z Presence Builder mogą wymagać obsługi ASP.NET 2.0 na twojej domenie. Zalecamy włączenie obsługi ASP.NET 2.0, jeśli używasz Presence Builder.",

    'subdomain_auto_create_dir' => "Utwórz fizyczny katalog dla poddomeny",

    'sa_trainer__unable_to_get_messages_list' => "Nie udało się pobrać listy wiadomości w tej skrzynce: %1",
    'sa_trainer__pass_doesnt_exist' => "Brakuje hasła dla tego konta pocztowego",

    '__sitebuilder_error' => "Wystąpił błąd podczas próby połączenia z Presence Builder. Skontaktuj się z dostawcą usług.",
    'wsb_error_user_not_exist' => "Takie konto użytkownika Presence Builder nie istnieje.",
    'wsb_error_site_already_exist' => "Ta strona już istnieje w Presence Builder.",
    'wsb_error_site_limit_reached' => "Osiągnięto limit liczby stron w Presence Builder.",
    'wsb_error_internal_error' => "Wystąpił wewnętrzny błąd Presence Builder. Skontaktuj się z dostawcą usług.",
    'wsb_error_user_already_exist' => "Użytkownik Presence Builder o takiej nazwie już istnieje.",
    'sb_error_user_not_exist' => "Użytkownik Presence Builder nie istnieje.",
    'wsb_error_object_not_found' => "Presence Builder nie mógł odnaleźć poprawnego wejścia do hosta.",

    'mg_no_mail_groups' => "Brak grup pocztowych",

    'drweb__drweb_incoming' => 'Kontrola antywirusowa poczty przychodzącej',
    'drweb__drweb_outgoing' => 'Kontrola antywirusowa poczty wychodzącej',
    'drweb__disable_reason_serv' => 'Serwer pocztowy nie obsługuje ustawiania filtra antywirusowego na poziomie skrzynki pocztowej',

    'vz_sitebuilder3_client_cant_be_created' => "Nie móżna utworzyć konta klienta: wersja 3.1 SiteBuildera (lub późniejsza) nie jest zainstalowana",

    'chown__client_without_sitebuilder_support' => "Transfer domeny jest niemożliwy: usługa Presence Builder nie jest włączona w plan usługi nowego właściciela lub dostawcy usług.",

    // new limits

    'class_client__max_odbc' => "Połączenia ODBC",
    'cl_perm__max_odbc' => "maksymalna liczba połączeń ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Nazwa aliasu Domeny',
    'domain_alias__list_ascii_name' => 'W formacie ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Zarządzanie interfejsem',
    'pb__interface_templates' => 'Zarządzanie interfejsem',
    'pb__interface_clients' => 'Klienci używający %1',

    // service management
    'bt_service_showall' => "Pokaż wszystkie",
    'bt_service_hideall' => "Schowaj wszystkie",
    'bt_service_start' => "Początek",
    'bt_service_stop' => "Zatrzymaj",
    'bt_service_restart' => "Zrestartuj",
    'bt_service_disable' => "Zablokuj",
    'bt_service_manual' => "Ręcznie",
    'bt_service_auto' => "Automatycznie",
    'comp_info__statup_type' => 'Typ uruchomienia',
    'service_startup_auto' => 'Automatycznie',
    'service_startup_manual' => 'Ręcznie',
    'service_startup_disabled' => 'Wyłączony',
    'service_action_ok' => "Zakończono działanie %1 usługi",
    'service_action_failed_disabled_service' => "Nie udało się zakończyć działania z %1 usługi, ponieważ była ona włączona",
    'service_action_failed_error' => "Nie udało się zakończyć działań: %1",
    'service_group_action_ok' => "Zakończono działanie z następującymi usługami: \n %1",
    'service_group_action_disabled' => "Nie udało się zakończyć działania z następującymi usługami, ponieważ są one wyłączone: \n %1",
    'service_group_action_failed' => "Nie udało się zakończyć działania z następującymi usługami: \n %1. \n Aby otrzymać szczegółowe informacje o błędzie, przeprowadź działanie z każdą usługą oddzielnie",

    // php 4vs5
    'bt_php' => "Ustawienia PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Dostępni sprzedawcy',
    'massmail__resellers_list_selected' => 'Wybrani sprzedawcy',
    'massmail__clients_list_available_for_select' => 'Dostępni klienci',
    'massmail__clients_list_selected' => 'Wybrani klienci',
    'massmail__advanced' => 'Zaawansowane',
    'bt_massmail_send' => 'Wyślij',
    'massmail__save_template_name' => 'Zapisz tekst do nowego szablonu',
    'massmail__template' => 'Szablon',
    'massmail__compose_mail' => 'Wiadomość',
    'massmail__from' => 'Od',
    'massmail__to' => 'Do',
    'massmail__subject' => 'Temat',
    'massmail__body' => 'Tekst wiadomości',
    'massmail__body_hint' => 'Użyj zmiennej <name>, by automatycznie wstawić nazwę użytkownika do twojej wiadomości.',
    'massmail__send_to_clients' => "Klienci",
    'massmail__send_to_domainusers' => "Administratorzy domeny",
    'massmail__send_to_admins' => "Administratorzy Plesk",
    'massmail_select' => 'Wybierz adresy',
    'massmail_showhide_selected' => "Pokaż/Schowaj zaznaczone",
    'massmail_send_all' => "Wszystko",
    'massmail_send_selected' => "Wszystkie zaznaczone",
    'massmail_send_except' => "Wszystkie prócz zaznaczonych",
    'bt_new_mass_mail_template' => "Dodaj szablon masowej wysyłki e-mailowej",
    '__mass_mail_templates_list' => "Lista szablonów e-maili masowych",
    'massmail__template_name' => 'Nazwa szablonu',
    'massmail__receivers' => 'Odbiorcy',
    'massmail__created' => 'Nadawca',
    'massmail__date_created' => 'Data utworzenia',
    'massmail__compose' => 'Wyślij',
    'mass_mail__resellers_all' => 'Wszyscy sprzedawcy',
    'mass_mail__clients_all' => 'Wszyscy klienci',
    'mass_mail__domainusers_all' => 'Wszyscy administratorzy domeny',
    'mass_mail__resellers_selected' => 'Wybrani sprzedawcy',
    'mass_mail__clients_selected' => 'Wybrani klienci',
    'mass_mail__domainusers_selected' => 'Zaznaczeni administratorzy domeny',
    'mass_mail__resellers_except' => 'Wszyscy sprzedawcy z wyjštkiem zaznaczonych',
    'mass_mail__clients_except' => 'Wszyscy klienci oprócz zaznaczonych',
    'mass_mail__domainusers_except' => 'Wszyscy administratorzy domeny oprócz zaznaczonych',
    'mass_mail__admins_all' => 'Wszyscy administratorzy',
    'massmailtemplateslist__title' => 'Wzorce masowych wiadomoci e-mail',
    'massmail__insert_from_template' => "Wprowadź dane z szablonu",
    'massmail__select_template' => "Zaznacz szablon",
    'massmail__body_short_hint' => "(tylko plain tekst)",
    'massmail__from_short_hint' => "(e-mail lub nazwa)",
    'bt_insert' => "Wprowadź",
    'massmail__mail_send_successfully' => "Wiadomość została wysłana poprawnie",
    'massmail__mail_send_successfully_with_some_errors' => "Wiadomość została wysłana, ale pojawiło się kilka błędów. Niektórzy odbiorcy mogli nie otrzymać wiadomości. Aby uzyskać więcej informacji obejrzyj plik logów w: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Wiadomość nie została wysłana. Upewnij się, że przynajmniej jeden odbiorca jest wybrany i że serwer poczty Plesk działa poprawnie. Aby uzyskać więcej informacji obejrzyj plik logów w: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Dane z szablonu %1 zostały poprawnie umieszczone.",
    'massmail__template_added_successfully' => "Szablon wiadomości został zapisany jako %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Wystąpił błąd bazy danych Presence Builder. Skontaktuj się z dostawcą usług.",
    'wsb_error_sitebuilder_access_denied_error' => "Brak dostępu do pliku: Presence Builder nie ma uprawnień do dostępu do wymaganego pliku lub folderu. Skontaktuj się z dostawcą usług.",
    'wsb_error_sitebuilder_connection_failed' => "Nie udało się połączyć z Presence Builder, ponieważ utracono połączenie. Skontaktuj się z dostawcą usług.",
    'wsb_error_critical_during_operation' => "Wystąpił poważny błąd Web Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Wystąpił licencyjny poważny błąd Presence Builder:\n%1",
    'wsb_error_during_operation' => "Wystąpił poważny błąd Web Presence Builder:\n%1",
    'wsb_error_license_error' => "Napotkano ograniczenie licencyjne Presence Builder.",

    // Other
    '__confrim_service_stop' => "Uwaga! Jeśli zatrzymasz usługę %1, Plesk może przestać działać. Czy na pewno chcesz zatrzymać usługę %1?",
    'virtualdir__name_is_reserved' => "Ta nazwa jest zarezerwowana",
    'index_redirect_help_text' => 'Zostaniesz automatycznie przekierowany na wybraną stronę. Jeśli twoja przeglądarka nie obsługuje przekierowań, proszę kliknij %1 tutaj %2',
    'bt_default_settings' => "Przywróć wartości domyślne",
    'logfiles__remove_failed' => "Nie można skasować pliku %1: plik jest zablokowany przez inną aplikację. Proszę, spróbuj później raz jeszcze",
    'subdomain__invalid_homedirectory' => "Podany katalog domowy poddodmeny jest niepoprawny",
    'scheduler_item__empty_filename' => "Proszę określić plik wykonywalny do uruchomienia",
    'subdomains__overlapped_domain_exists' => 'Poddomena pokrywa się ze strefą DNS aliasów domeny %1',
    'subdomains__overlapped_domain_alias_exists' => 'Poddomena pokrywa się ze strefą DNS aliasów domeny %1',
    'services_action_none_selected' => 'Nie udało się zakończyć działań: proszę wybrać wymagane usługi',
    'cl_perm__max_subftp_users' => "maksymalna liczba dodatkowych kont FTP",
    'login_up__access_denied_no_cp_access' => 'Odmowa dostępu. Nie masz uprawnień do Plesk.',
    'drweb__disable_reason_admin' => "Ustawienia filtra antywirusowego na poziomie skrzynki pocztowej nie jest dozwolone prze regulamin serwera.",

    'webdirs__name_is_invalid' => 'Używaj tylko znaków alfanumerycznych, podkreśleń oraz myślników w nazwach katalogów.',
    'webdirs__physical_path_is_invalid' => 'Fizyczna ścieżka jest niepoprawna lub nie istnieje',
    '__use_default' => 'Użyj domyślnych',
    'odbc__dsn_list_legend' => 'Połączenia ODBC DSN',

    'webalizer_preferences__title' => 'Ustawienia Statystyk Stron',
    'webalizer_preferences__tab_hidden_referrers' => 'Ukryte Referencje',
    'webalizer_preferences__tab_group_referrers' => 'Zgrupowane Referencje',

    'webalizer_hidden_referrer__edit_title' => 'Ustawienia Ukrytej Referencji',
    'webalizer_hidden_referrer__edit_legend' => 'Ukryte Referencje',
    'webalizer_hidden_referrer__referrer_type' => 'Typ referencji',
    'webalizer_hidden_referrer__referrer' => 'Referencja',
    'webalizer_hidden_referrer__list_header' => 'Ukryte Referencje',
    'webalizer_hidden_referrer__list_legend' => 'Ukryte Referencje',
    'webalizer_hidden_referrer__referrer_direct_request' => 'Bezporednie odwołanie',
    'webalizer_hidden_referrer__referrer_custom_referrer' => 'Referencja',
    'webalizer_hidden_referrer__remove_empty_selection' => 'Nie wybrano rekordów',
    'webalizer_hidden_referrer__remove_title' => 'Następujšce referencje nie będš już ukrywane:',
    'webalizer_hidden_referrer__already_exist' => 'Taki wpis już istnieje.',

    'webalizer_group_referrer__list_header' => 'Grupuj Referencje',
    'webalizer_group_referrer__list_legend' => 'Grupuj Referencje',
    'webalizer_group_referrer__edit_title' => 'Ustawienia Grupy Referencji',
    'webalizer_group_referrer__edit_legend' => 'Ustawienia Grupy Referencji',
    'webalizer_group_referrer__group' => 'Grupa',
    'webalizer_group_referrer__referrer' => 'Referencja',
    'webalizer_group_referrer__already_exist' => 'Grupa referencji o takiej nazwie już istnieje.',
    'webalizer_group_referrer__remove_empty_selection' => 'Nie wybrano referencji',
    'webalizer_group_referrer__remove_title' => 'Następujšce strony referencji zostanš przegrupowane:',

    'pb__dashboard' => 'Start',

    'server_interface__page_title' => 'Właciwoci Interfejsu Serwera',
    'server_interface__tabs_locales' => 'Wersje językowe',
    'server_interface__tabs_skins' => 'Skóry',
    'server_interface__tabs_interface_templates' => 'Szablony interfejsu',
    'bt_server_interface' => 'Ustawienia Interfejsu',
    'pb__server_interface' => 'Ustawienia Interfejsu',

    'bt_wizard_next' => 'Następny >>',
    'bt_wizard_prev' => '<< Wstecz',

    '__limit_exceeded_max_dom_server' => 'Nie możesz hostować większej liczby domen na tym serwerze, ponieważ limit liczby domen zdefiniowany w kluczu licencji został osiągnięty. Skontaktuj się z dostawca usługi, aby rozwiązać problem.',
    '__limit_exceeded_max_subdom_server' => 'Nie można mieć więcej subdomen na tym serwerze. Proszę skontaktować się z administratorem.',
    '__limit_exceeded_max_dom_aliases_server' => 'Nie można ustawić więcej aliasów domen na tym serwerze. Proszę skontaktować się z administratorem.',
    '__limit_exceeded_max_wu_server' => 'Nie możesz utworzyć większej liczby użytkowników web na tym serwerze, ponieważ limit liczby użytkowników web zdefiniowany w kluczu licencji został osiągnięty. Skontaktuj się z dostawca usługi, aby rozwiązać problem.',
    '__limit_exceeded_max_mn_server' => 'Nie możesz utworzyć większej liczby kontach pocztowych na tym serwerze, ponieważ limit liczby kontach pocztowych zdefiniowany w kluczu licencji został osiągnięty. Skontaktuj się z dostawca usługi, aby rozwiązać problem.',

    '__limit_exceeded_max_cl_useradmin' => 'Osišgnšłe limit iloci kont klientów zdefiniowany w kluczu licencji (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Osišgnšłe limit iloci domen zdefiniowany w kluczu licencji (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Osišgnšłe limit iloci subdomen zdefiniowany w kluczu licencji (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Osiągnąłeś limit liczby aliasów domen zdefiniowany przez Twój klucz licencyjny (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Zabrakło miejsca na dysku',
    '__limit_exceeded_max_wu_useradmin' => 'Osišgnšłe limit iloci kont użytkowników web zdefiniowany w kluczu licencji (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Osišgnšłe limit iloci baz danych zdefiniowany w kluczu licencji (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Osišgnšłe limit iloci skrzynek pocztowych zdefiniowany w kluczu licencji (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Osišgnałe limit liczby kont pocztowych okrelony przez twój klucz licencyjny (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Osišgnšłe limit iloci skrzynek list mailingowych w kluczu licencji (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Osišgnšłe limit iloci domen (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Osišgnšłe limit liczby subdomen (%2)',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Osiągnąłeś limit liczby aliasów domen (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Osišgnšłe limit przestrzeni dysku (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Osišgnšłe miesięczny limit wielkoci transferu (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Osiągnąłeś limit liczby użytkowników kont Web (%2).',
    '__limit_exceeded_max_db_userclient' => 'Osišgnšłe limit iloci baz danych (%2)',
    '__limit_exceeded_max_box_userclient' => 'Osišgnšłe limit iloci skrzynek pocztowych (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Osišgnšłe limit iloci list mailingowych (%2)',
    '__limit_exceeded_expiration_userclient' => 'Twoje konto wygasło %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Osišgnšłe limit liczby subdomen (%2)',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Osiągnąłeś limit liczby aliasów domen (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Osišgnšłe limit przestrzeni dysku (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Osišgnšłe miesięczny limit iloci transferu (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Osišgnšłe limit iloci kont użytkowników web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Osišgnšłe limit iloci baz danych (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Osišgnšłe limit iloci skrzynek pocztowych (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Osišgnšłe limit iloci list mailingowych (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Twoje konto wygasło %2',

    'mmt__to_none' => 'Brak',
    'mmt__to_admin' => 'Administrator',
    'mmt__to_resellers_all' => 'Wszyscy sprzedawcy',
    'mmt__to_resellers_select' => 'Wybrani sprzedawcy',
    'mmt__to_resellers_select__available' => 'Dostępni sprzedawcy',
    'mmt__to_resellers_except' => 'Wszyscy sprzedawcy z wyjštkiem zaznaczonych',
    'mmt__to_clients_all' => 'Wszyscy klienci',
    'mmt__to_clients_select' => 'Wybrani klienci',
    'mmt__to_clients_select__available' => 'Dostępni klienci',
    'mmt__to_clients_except' => 'Wszyscy klienci oprócz zaznaczonych',

    'mmt__unable_send_empty_selection' => 'Wysłanie korespondencji masowej nie powiodło się. Nie wybrano żadnego adresata.',
    'mmt__unable_send_to__' => 'Nie powiodło się wysłanie korespondencji masowej do:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Nie można zweryfikować aplikacji webowej ponieważ jeden z wymaganych plików \'(%1) nie został znaleziony. Skontaktuj się z działem wsparcia technicznego w celu uzyskania pomocy.',
    'sapp_error_validation_spec_failed' => 'Aplikacja przesłana na serwer nie jest zgodna ze specyfikacją AppPacks: %1.',
    'sapp_error_validation_register' => 'Nie można zarejestrować aplikacji webowej zlokalizowanej w katalogu "%1": %2 Powinieneś usunąć tę aplikację z serwera ponieważ nie będzie funkcjonować prawidłowo.',

    'sapp__install_failed' => 'Instalacja aplikacji webowej zakończona niepowodzeniem: %1',
    'sapp__install_res_failed' => 'Nieudane utworzenie żšdanego zasobu.',

    'server_preferences__subdomains_blog_and_photo' => 'Utwórz domyślnie poddomeny dla bloga i galerii zdjęć',
    'firewall__info' => 'Z powodu kwestii bezpieczeństwa firewall blokuje wszystkie połączenia oprócz tych, które zostały określone jako dozwolone. Możesz zezwolić na kolejne połączenie poprzez utworzenie kolejnej reguły. Więcej informacji znajdziesz w dokumentacji',
    'plesk_key__blog_and_photo' => 'Zaznacz checkbox, jeśli chcesz mieć możliwość zarządzania mechanizmem tworzenia bloga i galerii zdjęć',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Nie można uczynić IP wyłącznym, jeśli jest przypisane do więcej niż jednego użytkownika.',

    // 8.1.1

    '__write_modify_warning' => 'Wybór dodatkowych uprawnień zapisu/modyfikacji sprawi, że niektóre aplikacje webowe będą pracowały poprawnie, ale równocześnie znaczenie obniży poziom bezpieczeństwa',
    '__write_modify_subdomain_warning' => 'Wybór dodatkowych uprawnień zapisu/modyfikacji sprawi, że niektóre aplikacje webowe będą pracowały poprawnie, ale równocześnie znaczenie obniży poziom bezpieczeństwa',

    'phosting__php_incorrect_version_used' => "Napotkano problemy z wersją PHP. Żeby rozwiązać te problemy, zaznacz checkbox z wymaganą wersją PHP o kliknij OK. Żeby wyłączyć PHP dla tej domeny kliknij OK bez zaznaczania wersji PHP",
    'fp__mail_preferences' => 'Ustawienia poczty',

    'mail__specify_patterns' => 'Adres e-mail',
    'mail__specify_patterns_with_ip' => 'Adresy e-mail lub IP',
    'mail__blocker_action_text' => 'Co zrobić z e-mailem, który spełnia kryteria:',
    'mail__action_delete' => 'Skasuj z serwera',
    'mail__action_spam' => 'Oznacz jako spam',
    'mail__action_with_mails' => 'Operacja',
    'mail__white_list_action_text' => 'Podane tutaj adresy e-mail nie będą rozpoznawane przez SpamAssassin jako spam.',
    'mail__smtp_white_list_action_text' => 'Określone tutaj wpisy IP zostaną dodane do wyjątków serwera pocztowego.',
    'mail__invalid_white_pattern' => 'Podana wartość jest nieprawidłowa. Użyj następujących formatów: mail@example.com dla adresów e-mail, example.com dla domen.',
    'mail__white_list__text_wildcard_pattern' => 'Adresy IP mogą zawierać symbole wieloznaczne (na przykład 123.123.*.123).',
    'mail__white_list__text_cidr_pattern' => 'Adresy IP mogą zawierać maski CIDR (na przykład 10.0.0.0/8).',
    'mail__invalid_black_pattern' => 'Określona wartość jest nieprawidłowa. Użyj następującego formatu: poczta@domena.pl dla adresów e-mail, domena.pl dla domen.',
    'mail__black_list_no_sa_warning' => 'Elementy nie zostaną zaznaczone jako spam ponieważ Spamassasin nie jest zainstalowany lub jest wyłączony',
    'mail__smtp_white_list__text_hint' => 'Poszczególne adresy oddziel przecinkiem lub średnikiem. Po lewej stronie znaku @ nie może być znaków spoza zestawu ASCII. Adresy mogą zawierać symbole wieloznaczne "*" i "?" (na przykład *@domena.com, uzytkownik?@*.com). Części nazw domen inne niż ASCII nie mogą zawierać symboli wieloznacznych.',

    'resp_edit__reply_as_html' => 'Wyślij jako HTML',
    'exception__path_very_long' => "Ścieżka jest zbyt długa. Proszę, upewnij się, że w ścieżce jest mniej niż %1 znaków.",

    // 8.2


    //SAPP
    'sapp_on' => 'Wł',
    'sapp_off' => 'Wył',
    'sapp_directive_aspect' => 'Wymagane',
    'sapp_databases_num' => 'Bazy danych',
    'sapp_db_required' => 'Wymagane',
    'sapp_Required' => 'Wymagane',
    'sapp_Variant' => 'Zmienny(a)',
    'sapp_db_id' => 'Identyfikator Bazy',
    'sapp_db_id_type' => 'DB (id: %1) typ',
    'sapp_db_id_min_version' => 'DB (id: %1) min wersja',
    'sapp_db_id_table_prefix' => 'DB (id: %1) prefix tabeli',
    'sapp_Default' => 'Wartość domyślna',
    'sapp_apache_mod_req' => 'Moduł Apache',
    'sapp_dbtype_not_installed' => 'nie zainstalowano',
    'sapp_apache_mod_not_installed' => 'nie zainstalowano',
    'sapp__value_error_empty' => 'Pusta wartość jest niedozwolona.',
    'sapp_error_invalid_type' => 'Aplikacja "%1" nie wspiera żądanej akcji.',
    'sapp_error_unknown_app_type' => 'Niewspierany typ aplikacji: %1.',
    'sapp__ssl_text' => 'Zainstaluj aplikację na wirtualnym hoście "http://" czy "https://"?',
    'sapp__app_to_upgrade' => 'Aplikacje do aktualizacji',
    'sapp__upgrade_apps_title' => 'Aktualizuj aplikacje',
    'sapp__upgrade_to_ver' => 'Uaktualnij do wersji',
    'sapp__choose_pkg_ver' => 'Wybierz pakiet',
    'sapp__pkg_cant_upgrade_pkg' => 'Paczka "%1" nie może być użyta do aktualizacji strony aplikacji "%2".',
    'sapp__app_ugrade_error' => 'Uaktualnienie aplikacji nie powiodło się: %1. Skontaktuj się z administratorem systemu.',
    'sapp__no_suitable_db_found' => 'Nie znaleziono odpowiedniej bazy danych.',
    'sapp__upgrade_success' =>  'Aplikacja została zaktualizowana z powodzeniem.',
    'sapp__pkg_info_changelog' => 'Historia zmian',
    'sapp_requirement_legend' => 'Elementy hostingu wymagane przez aplikację',

    // other
    'odbc__mssql_wsid' => 'Identyfikator stacji roboczej',
    'odbc__mssql_driver' => 'Sterownik',
    'bt_apply' => 'Zastosuj',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Żeby stworzyć alias pocztowy, skrzynka pocztowa powinna być włączona dla tego konta. Włączyć skrzynkę pocztową?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Wyłączają skrzynkę pocztową, usuniesz aliasy poczty. Wyłączyć skrzynkę poczty?',
    'odbc__mysql_driver' => 'Sterownik MySQL ODBC',
    'antivirus__disable_reason_install' => 'Nie możesz zarządzać antywirusem, ponieważ nie został on zainstalowany.',
    'antivirus__disable_reason_key' => 'Nie możesz zarządzać antywirusem, ponieważ nie został on aktywowany za pomocą odpowiedniego klucza licencyjnego.',
    'antivirus__disable_reason_deny_personal_settings' => 'Nie możesz zarządzać antywirusem, ponieważ ustawienia serwera uniemożliwiają indywidualną konfigurację tego programu.',
    'component_name__sqladminmssql' => 'MS SQL Webadmin',
    'change_foreign_user_password' => 'Zmień hasło',
    'change_foreign_user_password_hint' => "Użytkownik nie jest użytkownikiem tej aplikacji. Kliknij na link aby przejść do innej aplikacji i zmienić tam hasło użytkownika. Aby to zrobić, musisz posiadać odpowiednie uprawnienia w aplikacji.",
    'cf_url_text' => 'URL do JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Format ciągu znaków',
    'lang_unknown' => 'Nieznany język',
    'odbc__access_driver' => 'Sterownik',
    'odbc__access_pwd' => 'Hasło',
    'odbc__access_uid' => 'Login ID',
    'odbc__excel_driver' => 'Sterownik',
    'pb__cl_ed' => 'Szczegóły dotyczące klienta',
    'pb__actionlog' => 'Logi akcji',
    'pb__cl_limits' => 'Ograniczenia klienta',
    'pb__edit' => 'Edytuj',
    'pb__subdom_edit' => 'Ustawienia hostingu',
    'cf__select_dsn_to_remove' => 'Wybierz przynajmniej jeden DSN do usunięcia',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Utwórz kopię zapasową zawartości skrzynek e-mailowych',

    'maillist_import_result' => "Całkowita liczba adresów e-mailowych w pliku: %1\nliczba zaimportowanych adresów: %2\nliczba już istniejących adresów: %3\nliczba zduplikowanych adresów: %4\nliczba niepoprawnych adresów w pliku: %5",
    'maillist_import_error' => 'Nie można usunąć listy mailingowej',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Wybrany plik jest albo pusty albo jest niepoprawnym dokumentem HTML w niewłaściwym kodowaniu. Proszę wybrać poprawne kodowanie lub dodać zawartość do pliku.",

    'dom_pref__external_mail_srv' => "Przekieruj na zewnętrzny serwer pocztowy z adresem IP:",
    'mn_edit__store_messages' => 'Skrzynka pocztowa',

    // aps

    'sapp__before_upgrade_notice' => 'Rekomenduje się zarchiwizować aplikację oraz dane użytkowników przed rozpoczęciem procesu aktualizacji.',
    'sapp__application_properties' => 'Właściwości aplikacji',
    'sapp__application_root_descr' => 'Strona główna aplikacji',

    'sapp__aps_license_invalid_id' => 'Licencja ma niewłaciwe ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Licencja o numerze %1 już istnieje w bazie danych.',
    'sapp__aps_lic_del_used' => 'Nie można usunšć klucza licencyjnego, jest on w użyciu przez jednš z zainstalowanych aplikacji.',
    'sapp__aps_lic_del_unknown' => 'Nie można usunšć klucza licencyjnego: %1',
    'sapp__aps_cappi_duplicate' => "Ta aplikacja znajduje się już w puli aplikacji użytkownika",
    'sapp__appi_not_shared_no_install' => "Nie ma takiej aplikacji w puli aplikacji klienta. Jeśli chcesz zainstalować tę aplikację na stronie powinieneś najpierw dodać tę aplikację do puli aplikacji klienta.",
    'sapp__appi_shared_not_client' => "Nie ma takiej aplikacji w puli aplikacji klienta. Jeśli chcesz zaktualizować tę aplikację do określonej wersji powinieneś najpierw dodać tę aplikację do puli aplikacji klienta.",
    'sapp__apply_license_script_not_found' => 'Nie można znaleźć skryptu ,,apply-license" (zastosuj licencję) dla tej aplikacji webowej.',
    'sapp__unable_to_activate_key' => 'Wystąpił błąd podczas próby aktywacji klucza licencji: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Istnieją już zainstalowane aplikacje wymagające obecności tej aplikacji webowej w systemie.',
    'sapp__unable_to_delete_ai_in_pool' => 'Ta aplikacja nadal znajduje się w puli klienta. Jeli chcesz usunšć aplikację musisz najpierw usunšć jš z wszystkich pul klienta lub udostępnić jš nieodpłatnie.',
    'sapp__unable_to_delete_app_template' => 'Nie można usunąć aplikacji #%1: %2',
    'sapp__limit_exceeded_client' => 'Osiągnąłeś limit ilości instalacji tej aplikacji webowej (%2).',


    // atis module

    '_week_on' => 'w tygodniu',
    '__week_first' => 'pierwszy',
    '__week_second' => 'drugi',
    '__week_third' => 'trzeci',
    '__week_fourth' => 'czwarty',
    '__week_last' => 'ostatni',
    '__not_started' => 'Oczekiwanie',
    '__started' => 'Działanie',
    '__cancel_pending' => 'Anulowano',
    '__canceled' => 'Anulowano',
    '__error' => 'Błąd',
    '__done' => 'Wykonano',

    '__php_cgi_handler' => 'Aplikacja CGI',
    '__php_isapi_handler' => 'Rozszerzenie ISAPI',
    '__php_fastcgi_handler' => 'Aplikacja FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'uruchom jako',

    'firewall_tabs_rules' => 'Reguły zapory ogniowej',

    'cf_dbfolder_text' =>'Folder bazy danych',
    'cf_isnewdb_text' => 'Utwórz bazę danych',
    'cf_isnewdb_title' => 'Zaznacz checkbox, jeśli baza danych musi zostać utworzona',

    'pb__site_apps_upgrade' => 'Podnoszenie parametrów aplikacji webowych',

    'detach' => 'Rozłącz',
    'preferences' => "Zmień hasło",

    'toolsbar__switch_user?' => "Czy jesteś pewny, że chcesz się zalogować jako inny użytkownik konta?",
    '__aps_left' => 'Liczba pozostałych instalacji',
    'aps__license_key' => 'Klucz licencji',
    'aps__download_code' => 'Download klucza licencji oraz kodu aktywacyjnego',
    'aps__license_key_hint' => 'Pozyskaj z serwera licencyjnego przy pomocy kodu aktywującego',
    'aps__database_not_available' => 'niedostępna, proszę sprawdzić limity domeny albo klienta',
    'aps__yes' => 'tak',
    'aps__no' => 'nie',
    '__click_to_enlarge' => 'Kliknij, aby powiększyć',
    'site_apps__back_to_list' => 'Powróć do listy',
    'sapp__pkg_info_installation_requirements' => 'Wymagania instalacyjne',
    '__close_window' => 'Zamknij',

    //SAPP END

    'skin_info__already_default' => 'Wygląd już jest ustawiony jako domyślny.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Ustawienia Plesk Premium Antivirus dla %1',
    'drweb:properties_legend' => 'Ustawienia',
    'drweb:status' => 'Sprawd pocztę pod kštem wirusów',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder Wizard',
    'dom_site_builder' => 'Kliknij, aby otworzyć kreatora Presence Builder.',
    'sb_plesk_admin_url' => 'URL serwera Presence Builder . Upewnij się, że serwer DNS prawidłowo odpowiada na zapytanie',
    'sb_plesk_admin_login' => 'Login administratora serwera do Presence Builder',
    'sb_plesk_admin_password' => 'Hasło administratora',
    'sb_sitebuilder_preferences' => 'Dane administratora Presence Builder',
    'sb__server' => 'Preferencje Administratora Systemu Presence Builder',
    'sb__sitebuilder_support' => 'Wsparcie Presence Builder',
    'sb_keep_sb_user' => 'Utrzymaj korespondujšce konto użytkownika w Presence Builder',
    'sb_create_sb_user' => 'Utwórz korespondujące konto użytkownika w Presence Builder',
    'sb__build_site_using_sitebuilder' => "Stwórz stronę WWW używajšc Presence Builder",
    'sb_no_current_sb_server_set' => 'Połšczenie z Presence Builder nie jest jeszcze skonfigurowane: musisz dodać rekord A w szablonie strefy DNS, który wskaże serwer Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Nie można uzyskać informacji z systemu Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Nie udało się połšczyć z Presence Builder: Niepoprawna nazwa użytkownika i hasło.",
    'sb_init_sb_manager' => "Uruchamianie Presence Builder manager: %1",
    'sb_err_couldnt_connect_sb' => "Nieudane połšczenie do systemu Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Klient nie posiada konta użytkownika w Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder nie jest skonfigurowany.",
    'sb_err_you_dont_have_sbaccount' => "Nie powiodła się autoryzacja Ciebie w Presence Builder.",
    'sb_error_critical_during_operation' => "W Presence Builder wystšpił następujšcy błšd:\n%1",
    'sb_err_sso_is_not_enabled' => "Wsparcie po pojedynczym logowaniu nie jest włšczone w Plesk.",

    'forbid_create_dns_subzone' => "Nie powalaj użytkownikom tworzyć podstrefy DNS w super-strefach DNS innych użytkowników",
    'warning__super_zone_exist' => "Strefa %1 została stworzona, jedna nazwa tej strefy jest podstrefą już istniejącej strefy %2, która należy do użytkownika %3. Jest to możliwe, jednak upewnij się, że wybrałeś właściwego użytkownika.",
    'error__super_zone_exist' => "Nie można stworzyć strefy DNS ponieważ jej nadstrefa należy do innego użytkownika.",

    'locales__files_not_exits' => 'Nie można zmienić lokalizacji: wskazany pakiet interfejsu językowego nie istnieje w systemie.',
    'locales__unavailable' => 'Nie można zmienić lokalizacji: wskazany pakiet interfejsu językowego jest niedostępny.',

    // DB BU

    'pb__dbbackup_list' => 'Pliki kopii zapasowej bazy danych',
    // server
    'dbbackup__server_backup_settings' => 'Kopia zapasowa',
    'dbbackup__network_temp_dir' => 'Czasowy katalog sieciowy',
    'dbbackup__network_user' => 'Nazwa użytkownika',
    'dbbackup__network_pass' => 'Hasło',
    // domain
    'dbbackup__add_database_legend' => 'Odtwórz bazę danych z kopii zapasowej',
    'dbbackup__add_database_restore' => 'Odtwórz bazę danych z kopii zapasowej',
    'dbbackup__add_database_file' => 'Plik kopii zapasowej bazy danych',
    'dbbackup__add_database_user' => 'Domyślna nazwa użytkownika',
    'dbbackup__add_database_pass' => 'Domyślne hasło użytkownika',
    'dbbackup__add_database_pass2' => 'Potwierdzenia domyślnego hasła użytkownika',

    'bt_dbbackup_now' => 'Archiwum',

    'bt_repair' => 'Naprawa',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Wgrywanie zrzutów bazy danych serwera SQL jest zabroniony przez dostawcę usług hostingowych.',

    // APS categories

    'cf_invalid_password' => 'Hasło nie może być dłuższe niż 16 znaków',
    'cf_invalid_description_length' => 'Opis nie może być dłuższy niż 256 znaków',
    'ip_addr__ip_used_by_external_mail_server' => 'Adres IP %1 jest już użyty do hostingu lub przekierowania',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Hasło lub nazwa użytkownika konta FTP jest niepoprawne. Proszę określić poprawne dane dostępowe do FTP.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Został osiągnięty limit zmian w numerach seryjnych strefy DNS. W dniu dzisiejszym nie można wprowadzać więcej zmian do strefy DNS.',
    'dns__zone_apply_changes' => 'Zmiany zrobione w rekordach DNS nie są jeszcze zapisane. Zmiany są podświetlone poniżej. Naciśnij Aktualizuj aby wprowadzić zmiany do strefy DNS lub naciśnij Przywróć aby porzucić zmiany.',
    'dns__update_dns_zone' => 'Kliknij, aby zapisać zmiany dokonane w rekordach DNS',
    'dns__revert_dns_zone' => 'Kliknij, aby skasować zmiany dokonane w rekordach DNS',
    'bt_revert' => 'Odwróć',
    'dns__dns_zone_has_beed_updated' => 'Zmiany dokonane w rekordach DNS zostały zapisane.',
    'dns__dns_zone_has_beed_reverted' => 'Zmiany dokonane w rekordach DNS zostały skasowane',
    'db__nondefault_server_not_allowed' => 'Jedynie administrator może wybrać serwer dla hostingu bazy danych',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Konto i domeny klienta %1.',
    'ui__client__disabled-warning' => 'Klient %1 jest wyłączony.',
    'ui__client__none-available' => 'Nie ma skonfigurowanych kont klienta.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Klient %1',
    'ui__client_self__description' => 'Lista moich domen.',
    'ui__client_self__short-title' => 'Moje domeny',
    'ui__client_self__title' => 'Moje domeny',


    'site_apps__non_removable' => 'Pozycje których nie można usunąć',
    'site_apps__non_removable_items' => 'Nie można usunąć następujących aplikacji webowych:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Brak własnych przycisków.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Klient %1 nie posiada żadnych własnych przycisków w Panelu klienta.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Usuń przycisk %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Usuń',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Usuń przycisk %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Usuń własne przyciski z Panelu klienta',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Usuń',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Usuń własne przyciski',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Usuń przyciski',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Wybierz klienta którego własne przyciski chcesz usunąć i kliknij Dalej >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Wybierz przyciski które chcesz usunąć i kliknij Dalej >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Potwierdź usunięcie przycisków poprzez zaznaczenie checkbox\'u, i kliknij Zakończ.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Usuń spersonalizowany przycisk z Panelu klienta.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Usuń',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Usuń przycisk dowolny',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Usuń przycisk dowolny',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Zaznacz klienta któremu chcesz usunąć własny przycisk i kliknij Dalej >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Wybierz własny przycisk który chcesz usunąć i kliknij Dalej >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Potwierdź usunięcie dowolnego przycisku poprzez zaznaczenie pola typu check box na tym ekranie a potem naciśnij Zakończ.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Edytuj właciwoci własnego przycisku klientów %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Ustawienia',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Zmodyfikuj klientowi własny przycisk %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Dodaj dowolny przycisk',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Zaznacz klienta, w którego Panelu klienta chcesz utworzyć własny przycisk i kliknij Dalej ».',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Kliknij Zakończ aby utworzyć przycisk.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Zmień właściwości przycisku w Panelu klienta.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Właściwości',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Zmień właściwości przycisku w Panelu klienta',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Zmień właściwości dowolnego przycisku',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Wybierz klienta którego własny przycisk chcesz zmodyfikować i kliknij Dalej >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Wybierz, który własny przycisk chcesz zmodyfikować i kliknij Następna >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Kiedy skończysz edytować właściwości przycisku, kliknij zakończ aby wprowadzić zmiany i opuścić kreatora.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Uczyń przycisk %1 niedostępnym dla ywoich klientów.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Ukryj przed użytkownikiem',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Uczyń przycisk %1 niedostępnym dla toich klientów',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Pokazuj użytkownikowi klienta przycisk %1.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Udostępnij użytkownikom',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Pokazuj użytkownikowi klienta przycisk %1',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Włącz / wyłącz dowolny przycisk Twoim klientom.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostępne/niedostępne dla Twoich klientów',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Włącz / wyłącz dowolny przycisk Twoim klientom',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Włącz / wyłącz dowolny przycisk Twoim klientom.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Wybierz klienta, któremu chcesz ustawić przycisk jako widoczny dla klientów klienta i kliknij Następna >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Wybierz własny przycisk który chcesz uczynić dostępnym lub niedostępnym dla swoich klientów i kliknij Dalej >>.',

    'ui__client/domain__description' => 'Zarządzaj domeną %1.',
    'ui__client/domain__disabled-warning' => 'Domena %1 jest wyłączona.',
    'ui__client/domain__none-available' => 'Nie posiadasz żadnej domeny.',
    'ui__client/domain__none-available__1' => 'Konto %1 nie posiada żadnych domen.',
    'ui__client/domain__none-available__2' => 'Konto %1 nie posiada żadnych domen.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domena %1',
    'ui__client/domain_self__description' => 'Zarządzaj Twoją domeną.',
    'ui__client/domain_self__disabled-warning' => 'Twoja domena jest wyłączona.',
    'ui__client/domain_self__quick-search' => 'Moje domeny',
    'ui__client/domain_self__short-title' => 'Moja domena',
    'ui__client/domain_self__title' => 'Moja domena',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Nie posiadasz żadnych własnych przycisków w Panelu klienta.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Klient %1 nie posiada własnych przycisków dla Panelu klienta.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Nie ma własnych przycisków dla domeny %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Usuń własny przycisk %1 z zasięgu całego serwera.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Usuń',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Usuń własny przycisk %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Usuń własne przyciski.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Usuń',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Usuń własne przyciski',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Usuń własne przyciski',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Wybierz klienta któremu z panelu administracyjnego chcesz usunąć przyciski i kliknij Dalej >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Wybierz domenę której z panelu administracyjnego chcesz usunąć przyciski i kliknij Dalej >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Wybierz przyciski które chcesz usunąć i kliknij Dalej >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Potwierdź usunięcie przycisków przez zaznaczenie odpowiednich checkbox\'ów i kliknij Zakończ i opuścić kreatora.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Usuń własny przycisk dla domeny.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Usuń',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Usuń przycisk dowolny',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Usuń przycisk dowolny',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Wybierz klienta, dla którego domeny chcesz usunąć własny przycisk i kliknij Następny >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Wybierz domenę której z panelu administracyjnego chcesz usunąć przyciski i kliknij Dalej >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Wybierz własny przycisk jaki chcesz usunąć i kliknij Następne >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Potwierdź usuwanie własnego przycisku poprzez wybranie opcji i kliknij Zakończ aby zakończyć usuwanie przycisku i wyjść z kreatora.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Zmień właściwości własnego przycisku %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Właściwości",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Zmień właściwości własnego przycisku %1 w Panelu klienta.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Dodaj przycisk',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Zaznacz klienta, w którego Panelu klienta chcesz stworzyć własny przycisk i kliknij Następny>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Wybierz domenę, dla której chcesz zmodyfikować własny przycisk i kliknij Następny >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Kliknij Zakończ aby utworzyć przycisk.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Edytuj właściwości własnego przycisku w Panelu klienta.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Właściwości',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Edytuj właściwości własnego przycisku w Panelu klienta',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Zmień właściwości przycisku',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Wybierz własny przycisk, dla którego chcesz zmodyfikować ustawienia i kliknij Następna >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Gdy skończysz zmianę właściwości własnego przycisku, kliknij Zakończ aby zapisać zmiany i wyjść z kreatora.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Ukryj przycisk %1 przed użytkownikami poczty w tej domenie.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Niedostępny dla użytkowników poczty',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Ukryj przycisk %1 przed użytkownikami poczty w tej domenie',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Pokazuj przycisk %1 użytkownikom poczty w tej domenie.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Dostępny dla użytkowników poczty w tej domenie',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Pokaż własny przycisk %1 użytkownikom poczty w tej domenie',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Pokaż lub ukryj własny przycisk innym użytkownikom.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostępny/niedostępny dla innych użytkowników',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Pokazuj lub nie własny przycisk użytkownikom poczty',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Pokaż lub ukryj własny przycisk innym użytkownikom',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Wybierz domenę gdzie umieszczono przycisk i kliknij Dalej',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Wybierz przycisk który chcesz udostępnić lub nie innym użytkownikom i kliknij Dalej',

    'ui__client/domain/delete__description' => 'Usuń domenę %1.',
    'ui__client/domain/delete__short-title' => 'Usuń',
    'ui__client/domain/delete__title' => 'Usuń domenę %1',
    'ui__client/domain/delete_multi__description' => 'Usuń domeny.',

    'ui__client/domain/delete_multi__short-title' => 'Usuń',
    'ui__client/domain/delete_multi__title' => 'Usuń domeny',
    'ui__client/domain/delete_multi__wizard-title' => 'Usuń domeny',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Zaznacz domeny do usunięcia i kliknij Dalej',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Potwierdź usunięcie domen wybierając pola wyboru, a następnie kliknij Zakończ, aby usunąć je i wyjść z kreatora.',
    'ui__client/domain/delete_unknown__description' => 'Usuń domenę.',
    'ui__client/domain/delete_unknown__short-title' => 'Usuń',
    'ui__client/domain/delete_unknown__title' => 'Usuń domenę',
    'ui__client/domain/delete_unknown__wizard-title' => 'Usuwanie domeny',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Wybierz domenę, którą chcesz usunąć i kliknij Następna',
    'ui__client/domain/delete_unknown__wizard__3' => 'Potwierdź usuwanie domeny poprzez wybór opcji i kliknij Zakończa aby ją całkowicie usunąć i wyjść z kreatora.',

    'ui__client/domain/hosting__none-available' => 'Brak domen ze skonfigurowanym hostingiem webowym. Stwórz domenę i skonfiguruj na niej hosting aby uzyskać dostęp do tej funkcjonalności.',
    'ui__client/domain/hosting__none-available__1' => 'To konto użytkownika nie posiada żadnych domen ze skonfigurowanym hostingiem webowym. Skonfiguruj hosting na domenie aby uzyskać dostęp do tej funkcjonalności.',
    'ui__client/domain/hosting__none-available__2' => 'Hosting webowy nie jest skonfigurowany dla domeny %1. Skonfiguruj hosting na domenie %1 aby uzyskać dostęp do tej funkcjonalności.',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => 'Zarządzanie plikami',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => 'Wybierz domenę, na plikach której chcesz pracować.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => 'Hosting nie jest jeszcze skonfigurowany w domenie. Proszę ustaw hosting fizyczny i kliknij',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => 'Hosting nie jest jeszcze skonfigurowany dla Twojej domeny. Proszę ustaw hosting fizyczny i kliknij',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => 'Gdy skończysz zarządzanie plikami w Twojej domenie, kliknij Zakończ aby wyjść z kreatora.',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => 'Gdy skończysz zarządzanie plikami w Twojej domenie, kliknij Zakończ aby wyjść z kreatora.',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => 'Pokaż ustawienia wydajnociowe hostingu',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => 'Dostosuj ustawienia wydajnoci hostingu WWW',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => 'Wybierz domenę której ustawienia wydajnociowe chcesz zobaczyć i kliknij Dalejť.',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => 'Wybierz domenę której ustawienia wydajnociowe chcesz skonfigurować i kliknij Dalej ť.',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => 'Dostosuj ustawienia wydajnoci hostingu na domenie i nacinij Koniec.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => 'Kiedy skończysz oglšdać ustawienia wydajnociowe na domenie, kliknij Zakończ.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => 'Kiedy skończysz oglšdać ustawienia wydajnociowe na swojej domenie, kliknij Zakończ.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => 'Kiedy skończysz oglšdać ustawienia wydajnociowe na domenie, kliknij Zakończ.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => 'Kiedy konfigurować ustawienia wydajnociowe na swojej domenie, kliknij Zakończ.',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => 'Kiedy konfigurować ustawienia wydajnociowe na domenie, kliknij Zakończ.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Klienci",
    'ui__client/domain/hosting/application#list_header__description__title' => "Opis",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Elementy",
    'ui__client/domain/hosting/application#list_header__name__title' => "Nazwa",
    'ui__client/domain/hosting/application#list_header__release__title' => "Wersja",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sortuj według klientów",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sortuj według opisu",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sortuj według obiektów",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sortuj według nazwy",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sortuj według wersji",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sortuj według wersji",
    'ui__client/domain/hosting/application#list_header__title' => "Aplikacje WWW",
    'ui__client/domain/hosting/application#list_header__version__title' => "Wersje",

    'ui__client/domain/properties__client_ip_address_was_assigned' => 'Klientowi %%client_name%% przyznano adres %%ip_address%%.',
    'ui__client/domain/properties__client_ip_pool_is_empty' => 'Pula adresów IP klienta/klientów jest pusta. Zaznaczony adres IP będzie przypisany do odpowiadającego konta użytkownika.',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => 'Nowe domeny zostaną utworzone po tym jak klikniesz Dalej',

    'ui__client/domain/properties_new__wizard-title' => 'Utwórz domenę',
    'ui__client/domain/properties_new__wizard__1_unknown' => 'Zaznacz klienta dla którego chcesz utworzyć domenę.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => 'Zaznacz odpowiedni typ hostingu w domenie i kliknij Dalej ť.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => 'Gdy skończysz konfigurację forwardowania w domenie, kliknij Zakończ aby zapisać konfigurację i wyjść z kreatora.',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => 'Gdy skończysz konfigurację fizycznego hostingu w domenie, kliknij Zakończ aby zapisać zmiany i wyjść z kreatora.',

    'ui__client/domain/properties_unknown__wizard-title' => 'Ustawianie Konta Administratora Domeny',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => 'Zaznacz domenę dla której chcesz ustawić konto administratora domeny.',
    'ui__client/domain/properties_unknown__wizard__3' => 'Gdy skończysz ustawianie właściwości konta administratora domeny, kliknij Zakończ.',
    'ui__client/domain/properties_unknown__wizard__3_self' => 'Kliknij Zakończ aby zapisać zmiany i wyjść z kreatora.',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => 'Statystyki dla usługi Anonimowy FTP dla domeny',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => 'Statystyki dla usługi Anonimowy FTP',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => 'Statystyki dla usługi Anonimowy FTP dla domeny',

    'ui__client/domain/report/ftp-stats_unknown__description' => 'Statystyki usługi FTP dla domeny',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'Statystyki usługi FTP',
    'ui__client/domain/report/ftp-stats_unknown__title' => 'Statystyki usługi FTP dla domeny',

    'ui__client/domain/report/traffic__description' => 'Podgląd zużycia pasma dla strony %1',
    'ui__client/domain/report/traffic__short-title' => 'Zużycie pasma',
    'ui__client/domain/report/traffic__title' => 'Pasmo używane przez stronę %1',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => 'Statystyki bezpiecznego dostępu do strony',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => 'Statystyki wizyt poprzez SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => 'Statystyki bezpiecznego dostępu do strony',

    'rpt_reseller_section_general' => 'Ogólny',
    'rpt_reseller_section_domains' => 'Domeny',
    'rpt_reseller_section_clients' => 'Klienci',
    'statistics__cl_active_domains' => "Aktywne domeny",
    'rpt_reseller_cl_domains' => "Domeny",
    'rpt_reseller_cl_subdomains' => "Subdomeny",
    'by__cl_domains' => "domeny klienta",
    'dom_ctrl__cl_mboxes' => "Skrzynki pocztowe",
    'rpt_reseller_cl_redirects' => "Przekazywanie",
    'rpt_reseller_cl_mail_groups' => "Grupy pocztowe",
    'rpt_reseller_cl_mail_resps' => "Autorespondery",
    'rpt_reseller_cl_mail_lists' => "Listy mailingowe",
    'rpt_reseller_cl_web_users' => "Użytkownicy Stron",
    'rpt_reseller_cl_data_bases' => "Bazy danych",

    'statistics__active_clients' => 'Klienci z aktywnymi subskrypcjami',
    'statistics__clients_active_domains' => 'Aktywne domeny',
    'statistics__clients_doms' => 'Domeny',
    'statistics__cl_doms' => 'Domeny',
    '__clients_subdomains' => 'Subdomeny',
    '__clients_domains' => 'Domeny',
    'dom_ctrl__clients_mboxes' => 'Skrzynki pocztowe',
    'dom_ctrl__clients_redir' => 'Przekazywanie',
    'dom_ctrl__clients_mg' => 'Grupy pocztowe',
    'dom_ctrl__clients_resp' => 'Autorespondery',
    'dom_ctrl__clients_maillists' => 'Listy mailingowe',
    'dom_ctrl__clients_wu' => 'Użytkownicy Stron',
    'dom_ctrl__clients_db' => 'Bazy danych',

    'dom_ctrl__cl_redir' => 'Przekazywanie', // to resolve!
    'dom_ctrl__cl_mg' => 'Grupy pocztowe', // to resolve!
    'dom_ctrl__cl_resp' => 'Autorespondery', // to resolve!
    'dom_ctrl__cl_maillists' => 'Listy mailingowe', // to resolve!
    'dom_ctrl__cl_wu' => 'Użytkownicy Stron', // to resolve!
    'dom_ctrl__cl_db' => 'Bazy danych', // to resolve!

    'rpt_cl_section_clients' => 'Klienci',

    'rpt_admin_section_general' => 'Ogólny',
    'rpt_admin_section_resellers' => 'Sprzedawcy',
    'rpt_admin_section_clients' => 'Klienci',
    'rpt_admin_section_personal_clients' => 'Klienci',
    'rpt_admin_section_domains' => 'Domeny',
    'rpt_admin_section_personal_domains' => 'Domeny osobiste',

    'rpt_reseller_section_personal_domains' => 'Domeny osobiste',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Wybierz, którą domenę chcesz włączyć/wyłączyć.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Włączanie/Wyłączanie Domeny',

    'ui__client/ip-pool__description' => 'Przypisz lub ponownie przypisz adresy IP i certyfikaty SSL/TLS do klienta %1.',
    'ui__client/ip-pool__short-title' => 'Zbiór IP',
    'ui__client/ip-pool__title' => 'Pula IP klienta %1',
    'ui__client/ip-pool_self__description' => 'Pokaż Twoją pulę IP.',
    'ui__client/ip-pool_self__short-title' => 'Zbiór IP',
    'ui__client/ip-pool_self__title' => 'Mój zbiór IP',
    'ui__client/ip-pool/properties__description' => 'Ustaw zbiór IP dla klienta %1.',

    'ui__client/ip-pool/properties__short-title' => 'Zbiór IP',
    'ui__client/ip-pool/properties__title' => 'Ustaw zbiór IP dla klienta %1',
    'ui__client/ip-pool/properties_self__description' => 'Pokaż Twoją pulę IP.',

    'ui__client/ip-pool/properties_self__short-title' => 'Mój zbiór IP',
    'ui__client/ip-pool/properties_self__title' => 'Mój zbiór IP',
    'ui__client/ip-pool/properties_unknown__description' => 'Przypisz lub ponownie przypisz adresy IP i certyfikaty SSL/TLS od klienta.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Zbiór IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Konfiguracja Zbioru IP klienta',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Konfiguracja Zbioru IP klienta',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Wybierz klienta, którego zbiór IP chcesz skonfigurować.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Gdy skończysz edytowanie zbioru IP klienta, kliknij Zakończ aby zapisać zmiany i wyjść z kreatora.',


    'ui__client/limits_readonly-unknown__description' => 'Podgląd przydzielonych klientowi zasobów.',
    'ui__client/limits_readonly-unknown__short-title' => 'Przydziały zasobów',
    'ui__client/limits_readonly-unknown__title' => 'Podgląd zasobów przydzielonych do konta klienta',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Pokazywanie/Edycja limitów klienta',

    'ui__client/limits_unknown__wizard-title' => 'Pokazywanie/Edycja limitów klienta',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Wybierz klienta.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Wybierz klienta.',
    'ui__client/limits_unknown__wizard__2' => 'Aby wprowadzić zmiany kliknij Zakończ.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Aby opuścić kreatora kliknij Zakończ.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Aby opuścić kreatora kliknij Zakończ.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Aby opuścić kreatora kliknij Zakończ.',

    'ui__client/permissions_unknown__wizard-title' => 'Pokazywanie/Edycja uprawnień klienta',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Gdy skończysz pokazywanie twoich uprawnień, kliknij Zakończ aby zapisać zmiany i wyjść z kreatora.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Wybierz klienta, którego uprawnienia chcesz pokazać/edytować.',
    'ui__client/permissions_unknown__wizard__2' => 'Gdy skończysz edycję uprawnień klienta, kliknij Zakończ aby zapisać zmiany i wyjść z kreatora.',

    'ui__client/preferences_unknown__wizard-title' => 'Edycja ustawień klienta',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Wybierz klienta, dla którego chcesz zarządzać ustawieniami interfejsu.',
    'ui__client/preferences_unknown__wizard__2' => 'Po edycji ustawień klienta, kliknij Zakończ.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Po edycji Twoich ustawień, kliknij Zakończ.',

    'ui__custom-buttons/custom-button__none-available' => 'Nie posiadasz obecnie żadnego własnego przycisku.',
    'ui__custom-buttons/custom-button/delete__description' => 'Usuń własny przycisk %1 z zasięgu całego serwera.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Usuń',
    'ui__custom-buttons/custom-button/delete__title' => 'Usuń własny przycisk %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Usuń własne przyciski.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Usuń',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Usuń własne przyciski',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Usuń własne przyciski',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Wybierz przyciski do usunięcia.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Potwierdź usunięcie przycisków poprzez zaznaczenie checkbox\'u i kliknij Zakończ.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Usuń własne przyciski.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Usuń',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Usuń własne przyciski',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Usuń własne przyciski',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Wybierz, który własny przycisk serwera chcesz usunąć.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Potwierdź usuwanie własnego przycisku serwera poprzez zaznaczenie opcji i kliknij zakończ aby całkowicie go usunąć i wyjść z kreatora.',
    'ui__custom-buttons/custom-button/properties__description' => 'Edytuj właściwości własnego przycisku serwera %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Właściwości',
    'ui__custom-buttons/custom-button/properties__title' => 'Modyfikuj własny przycisk %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Tworzenie własnego przycisku',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Kliknij Zakończ aby utworzyć przycisk.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Edytuj właściwości własnego przycisku.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Właściwości',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Edytuj właściwości własnego przycisku',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Edytuj właściwości własnego przycisku',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Wybierz, który własny przycisk chcesz zmodyfikować.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Aby wprowadzić zmiany kliknij Zakończ.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Ukryj własny przycisk %1 przed innymi użytkownikami.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Niedostępny dla innych użytkowników',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Ukryj własny przycisk %1 przed innymi użytkownikami',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Udostępnij własny przycisk %1 innym użytkownikom.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Dostępny dla innych użytkowników',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Udostępnij własny przycisk %1 innym użytkownikom',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Udostępnij innym użytkownikom lub schowaj przed nimi własny przycisk.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostępny lub niedostępny dla innych użytkowników',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Udostępnij innym użytkownikom lub schowaj przed nimi własny przycisk',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Udostępnij innym użytkownikom lub schowaj przed nimi własny przycisk',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Wybierz własny przycisk który chcesz udostępnić lub nie innym użytkownikom i kliknij Dalej',

    'ui__longtasks#list_header__name__title' => "Nazwa",
    'ui__longtasks#list_header__owner__title' => "Właściciel",
    'ui__longtasks#list_header__start_time__title' => "Czas utworzenia",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Zadania",
    'ui__longtasks#list_header__finish_time__title' => "Czas zakończenia",
    'ui__longtasks#task_list_legend__title' => "Zadania",
    'ui__longtasks#tools_legend__title' => "Narzędzia",
    'ui__longtasks__description' => "Zarządzaj dodatkowymi zadaniami",
    'ui__longtasks__short-title' => "Dodatkowe zadania",
    'ui__longtasks__title' => "Dodatkowe zadania",
    'ui__longtasks/longtask/properties#current_operation__title' => "Obecne działanie",
    'ui__longtasks/longtask/properties#finish_time__title' => "Przewidywany czas zakończenia",
    'ui__longtasks/longtask/properties#general_legend__title' => "Ogólny",
    'ui__longtasks/longtask/properties#owner__title' => "Zadanie rozpoczęto o:",
    'ui__longtasks/longtask/properties#progress__title' => "Ogólny postęp:",
    'ui__longtasks/longtask/properties#start_time__title' => "Zadanie rozpoczęto o:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Status zadania",
    'ui__longtasks/longtask/properties__description' => "Dodatkowe informacje o zadaniu",

    'ui__longtasks/properties__description' => "Ustawienia dodatkowych zadań",
    'ui__longtasks/properties__short-title' => "Ustawienia",
    'ui__longtasks/properties__title' => "Dodatkowe zadania",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Wzorce masowych wiadomoci e-mail',
    'ui__mass-mail/template#list_header__name__title' => 'Nazwa szablonu',
    'ui__mass-mail/template#list_header__from_email__title' => 'Nadawca',
    'ui__mass-mail/template#list_header__to__title' => 'Odbiorcy',
    'ui__mass-mail/template#list_header__subject__title' => 'Temat',
    'ui__mass-mail/template#list_header__cdate__title' => 'Data utworzenia',
    'ui__mass-mail/template#list_header__send__title' => 'Wyślij',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Edytuj szablon wiadomoci korespondencji masowej',
    'ui__mass-mail/template/properties__description' => 'Edytuj wzorzec e-maila wysyłki masowej.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Dodaj szablon masowej wysyłki e-mailowej',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Dodaj szablon masowej wysyłki e-mailowej',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Dodaj wzorzec masowej wiadomości e-mail.',
    'ui__mass-mail/send__short-title' => 'Masowe wysyłanie E-maili',
    'ui__mass-mail/send__title' => 'Wylij e-mail seryjny',
    'ui__mass-mail/send__description' => 'Wylij wiadomoć do wskazanych odbiorców.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Usuń szablony wiadomoci korespondencji masowej',
    'ui__mass-mail/template/delete_multi__title' => 'Usuń te szablony masowych wiadomoci e-mail:',
    'ui__mass-mail/template/delete_multi__description' => 'Usuń wybrane szablony e-maili masowych.',
    'ui__mass-mail/template/delete_multi__done' => 'Zaznaczone szablony wiadomoci zostały usunięte.',
    'ui__mass-mail/template/properties__invalid_values' => 'Podano niewłaciwe wartoci',


    // old
    'ui__mass-mail#body_text__description' => 'Możesz użyć zmiennej w <name>tekście wiadomości (le nie w nagłówku). Zostanie zastąpiony przez nazwę klienta lub sprzedawcy.',
    'ui__mass-mail#body_text__title' => 'Tekst wiadomości',
    'ui__mass-mail#compose_legend__title' => 'Wiadomość',
    'ui__mass-mail#from_email_text__title' => 'Od (adres e-mail)',
    'ui__mass-mail#list_header__cdate__title' => 'Utworzone',
    'ui__mass-mail#list_header__from_email__title' => 'Od',
    'ui__mass-mail#list_header__name__title' => 'Nazwa',
    'ui__mass-mail#list_header__send__title' => 'Utwórz wiadomoć',
    'ui__mass-mail#list_header__subject__title' => 'Temat',
    'ui__mass-mail#list_header__title' => 'Wzorce masowych wiadomoci e-mail',
    'ui__mass-mail#list_header__to__title' => 'Do',
    'ui__mass-mail#list_legend__title' => 'Wzorce masowych wiadomoci e-mail',
    'ui__mass-mail#load_template_text__title' => 'Załaduj',
    'ui__mass-mail#name_text__title' => 'Nazwa szablonu',
    'ui__mass-mail#option_mode_all__title' => 'Wszystko',
    'ui__mass-mail#option_mode_except__title' => 'Wszystkie prócz zaznaczonych',
    'ui__mass-mail#option_mode_select__title' => 'Wszystkie zaznaczone',
    'ui__mass-mail#option_select_template__title' => '---Zaznacz szablon---',
    'ui__mass-mail#picker_legend__title' => 'Szablony wiadomoci',
    'ui__mass-mail#picker_title__title' => 'Wybierz szablon',
    'ui__mass-mail#save_as_legend__title' => 'Zapisz jako wzorzec',
    'ui__mass-mail#save_as_text__title' => 'Zapisz utworzoną wiadomość jako nowy szablon pod nazwą',
    'ui__mass-mail#subject_text__title' => 'Temat',
    'ui__mass-mail#template_legend__title' => 'Szablon',
    'ui__mass-mail#to_admin_text__title' => 'Administrator Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Klienci',
    'ui__mass-mail#to_domains_text__title' => 'Administratorzy domen',
    'ui__mass-mail#to_select_text__title' => 'Wybierz adresy',
    'ui__mass-mail#to_show_hide_text__title' => 'Pokaż/Ukryj zaznaczone',
    'ui__mass-mail#to_text__title' => 'Do',
    'ui__mass-mail#tools_legend__title' => 'Narzędzia',
    'ui__mass-mail__already_exists' => 'Szablon z nazwš %1 już istnieje',
    'ui__mass-mail__none-available' => 'Nie masz żadnych szablonów.',

    'ui__mass-mail/delete__description' => 'Usuń szablon wiadomoci korespondencji masowej %1',

    'ui__mass-mail/delete__empty_selection' => 'Proszę zaznaczyć szablon do usunięcia',
    'ui__mass-mail/delete__short-title' => 'Usuń %1',
    'ui__mass-mail/delete__title' => 'Usuń szablon wiadomoci korespondencji masowej %1',
    'ui__mass-mail/delete_multi__description' => 'Usuń szablony wiadomoci korespondencji masowej.',

    'ui__mass-mail/delete_multi__short-title' => 'Usuń',
    'ui__mass-mail/delete_multi__title' => 'Usuń szablony wiadomoci korespondencji masowej',
    'ui__mass-mail/delete_multi__wizard-title' => 'Usuwanie szablonów wiadomoci korespondencji masowej',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Zaznacz szablony do usunięcia.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Potwierd usunięcie szablonów poprzez zaznaczenie checkbox\'u i kliknięcie na Zakończ.',
    'ui__mass-mail/delete_unknown__description' => 'Usuń szablony wiadomoci korespondencji masowej.',
    'ui__mass-mail/delete_unknown__short-title' => 'Usuń',
    'ui__mass-mail/delete_unknown__title' => 'Usuń szablony wiadomoci korespondencji masowej',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Usuwanie szablonów wiadomoci korespondencji masowej.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Zaznacz szablony do usunięcia.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Potwierd usunięcie szablonów poprzez zaznaczenie checkbox\'u i kliknięcie na Zakończ.',

    'ui__mass-mail/properties__description' => 'Edytuj szablon wiadomoci %1.',

    'ui__mass-mail/properties__invalid_values' => 'Wprowadzone zmienne sš nieprawidłowe',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Edytuj szablon wiadomoci %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Utwórz szablon wiadomoci korespondencji masowej',
    'ui__mass-mail/properties_unknown-new__description' => 'Utwórz szablon wiadomoci.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Dodaj szablon wiadomoci',
    'ui__mass-mail/properties_unknown-new__title' => 'Utwórz szablon wiadomoci',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Edytuj szablon wiadomoci korespondencji masowej',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Zaznacz szablon do edycji a następnie kliknij Następny >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Po zakończeniu edycji szablonu kliknij Zakończ aby wprowadzić zmiany.',

    'ui__mass-mail/send__invalid_values' => 'Wstawiono niewłaciwe wartoci',

    'ui__mass-mail/send_new__wizard-title' => 'Utwórz szablon wiadomoci i wylij E-mail',
    'ui__mass-mail/send_unknown-new__description' => 'Wylij wiadomoć do wskazanych odbiorców',

    'ui__mass-mail/send_unknown-new__short-title' => 'Masowe wysyłanie E-maili',
    'ui__mass-mail/send_unknown-new__title' => 'Wylij e-mail seryjny',
    'ui__mass-mail/send_unknown__description' => 'Wylij wiadomoć do wskazanych odbiorców',

    'ui__mass-mail/send_unknown__short-title' => 'Masowe wysyłanie E-maili',
    'ui__mass-mail/send_unknown__title' => 'Wylij e-mail seryjny',
    'ui__mass-mail/send_unknown__wizard-title' => 'Wylij e-mail seryjny',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Zaznacz potrzebny szablon i kliknij Następny >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Po zakończeniu edycji właciwoci szablonu kliknij Zakończ aby wysłać wiadomoć.',

    'ui__mass-email/delete__description' => 'Usuń wybrane szablony e-maili masowych.',

    'ui__mass-email/delete__empty_selection' => "Wybierz szablony wiadomości seryjnych. które chcesz usunąć.",
    'ui__mass-email/delete__short-title' => "Usuń %1",
    'ui__mass-email/delete__title' => "Usuń szablon wiadomoci korespondencji masowej %1",
    'ui__mass-email/delete_multi__description' => "Usuń szablony wiadomoci korespondencji masowej.",

    'ui__mass-email/delete_multi__short-title' => "Usuń",
    'ui__mass-email/delete_multi__title' => "Usuń szablony wiadomoci korespondencji masowej",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Potwierd usunięcie szablonów poprzez zaznaczenie checkbox'u i kliknięcie na Zakończ.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Zaznacz szablony do usunięcia.",
    'ui__mass-email/delete_multi__wizard-title' => "Usuwanie szablonów wiadomoci korespondencji masowej",
    'ui__mass-email/delete_unknown__description' => "Usuń szablony wiadomoci korespondencji masowej.",
    'ui__mass-email/delete_unknown__short-title' => "Usuń",
    'ui__mass-email/delete_unknown__title' => "Usuń szablony wiadomoci korespondencji masowej",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Potwierd usunięcie szablonów poprzez zaznaczenie checkbox'u i kliknięcie na Zakończ.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Zaznacz szablony do usunięcia.",
    'ui__mass-email/delete_unknown__wizard-title' => "Usuwanie szablonów wiadomoci korespondencji masowej.",
    'ui__mass-email/send__description' => "Wylij wiadomoć do wskazanych odbiorców",
    'ui__mass-email/send__short-title' => "Masowe wysyłanie E-maili",
    'ui__mass-email/send__title' => "Wylij e-mail seryjny",
    'ui__mass-email/send_main__description' => "Wylij wiadomoć do wskazanych odbiorców",

    'ui__mass-email/send_main__short-title' => "Masowe wysyłanie E-maili",
    'ui__mass-email/send_main__title' => "Wyślij e-mail seryjny",
    'ui__mass-email/send_selectresellers__title' => 'Wybierz sprzedawców',
    'ui__mass-email/send_selectresellers__short-title' => 'Sprzedawcy',
    'ui__mass-email/send_selectresellers__description' => 'Wybierz konta sprzedawców',

    'ui__mass-email/send_selectclients__description' => "Wybierz konta klientów",

    'ui__mass-email/send_selectclients__short-title' => "Klienci",
    'ui__mass-email/send_selectclients__title' => "Wybierz klientów",
    'ui__mass-email/send_selectdomainusers__description' => "Wybierz konta administratora domeny",

    'ui__mass-email/send_selectdomainusers__short-title' => "Administratorzy domen",
    'ui__mass-email/send_selectdomainusers__title' => "Wybierz administratorów domeny",
    'ui__mass-email/template/properties_main__description' => "Utwórz szablon wiadomoci korespondencji masowej",
    'ui__mass-email/template/properties_main__short-title' => "Edytuj szablon",
    'ui__mass-email/template/properties_main__title' => "Edytuj szablon wiadomoci korespondencji masowej",
    'ui__mass-email/template/properties_new-main__description' => "Utwórz szablon wiadomości seryjnej.",
    'ui__mass-email/template/properties_new-main__short-title' => "Utwórz szablon wiadomoci korespondencji masowej",
    'ui__mass-email/template/properties_new-main__title' => "Utwórz szablon wiadomoci korespondencji masowej",
    'ui__mass-email/template/properties_new-selectclients__description' => "Wybierz klientów, którzy powinni otrzymywać wiadomości seryjne na bazie tego szablonu",
    'ui__mass-email/template/properties_new-selectclients__title' => "Wybierz klientów, którzy powinni otrzymywać wiadomości seryjne na bazie tego szablonu",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Wybierz administratorów domen, którzy powinni otrzymywać wiadomości seryjne na bazie tego szablonu.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Wybierz administratorów domen, którzy powinni otrzymywać wiadomości seryjne na bazie tego szablonu.",
    'ui__mass-email/template/properties_selectclients__title' => "Wybierz klientów, którzy powinni otrzymywać wiadomości seryjne na bazie tego szablonu",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Wybierz administratorów domen, którzy powinni otrzymywać wiadomości seryjne na bazie tego szablonu.",

    'ui__mass-email/template/properties_unknown-new__description' => "Utwórz szablon wiadomości korespondencji masowej",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Stwórz szablon",
    'ui__mass-email/template/properties_unknown-new__title' => "Tworzenie szablonu wiadomości seryjnej",
    'ui__news/dismiss__description' => 'Kliknij, aby zamknąć ramkę newsów. Plesk nie będzie pokazywał tej ramki, dopóki artykuły w aktualnościach nie będą zaktualizowane.',

    'ui__news/dismiss__title' => 'Zamknij wiadomości',

    'ui__server__description' => 'Zarządzanie serwerem.',
    'ui__server__short-title' => 'Serwer',
    'ui__server__title' => 'Zarządzanie serwerem',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Adres IP %1 jest niedostępny.',
    'ui__server/ip-address__none-available' => 'Brak adres.',
    'ui__server/ip-addresses/ip-address__title' => "Adresy IP",
    'ui__server/ip-address/client/properties_new__description' => "Przypisz adres IP %1 do użytkownika.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Przypisz',
    'ui__server/ip-address/client/properties_new__title' => "Przypisz adres IP %1 do użytkownika",
    'ui__server/ip-address/client__none-available' => 'Brak kont użytkowników',
    'ui__server/ip-address/client_unknown__quick_search' => 'Użytkownicy',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Lista użytkowników, którzy używają ten adres IP.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Proszę wybrać adres IP.',
    'ui__server/ip-address/client/delete__description' => 'Przepisz adresy IP od użytkownika.',
    'ui__server/ip-address/client/delete__short-title' => 'Odłącz',
    'ui__server/ip-address/client/delete__title' => 'Przepisz adresy IP od użytkownika',
    'ui__server/ip-address/client/delete_multi__description' => "Przepisz adresy IP z zasobów użytkownika.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Odłącz',
    'ui__server/ip-address/client/delete_multi__title' => 'Przepisz adresy IP od użytkownika',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Usuń adres IP z puli klienta.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Wybierz adresy IP których chcesz pozbawić użytkowników i kliknij Dalej ť.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Wybierz użytkowników których chcesz pozbawić adresów IP i kliknij Dalej',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Potwierdź odłączenie adresu IP od użytkownika poprzez zaznaczenie pola typu check box oraz naciśnij Zakończ aby zamknąć kreatora.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Przepisz adresy IP od użytkownika.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Odłącz',
    'ui__server/ip-address/client/delete_unknown__title' => 'Przepisz adresy IP od użytkowników',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Przepisz adresy IP od użytkowników',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Wybierz adresy IP których chcesz pozbawić użytkowników i kliknij Dalej ť.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Wybierz użytkownika którego chcesz pozbawić adresu IP i kliknij Dalej',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Potwierdź odłączenie adresu IP od użytkownika poprzez zaznaczenie pola typu check box oraz naciśnij Zakończ aby zamknąć kreatora.',

    'ui__server/ip-address/domain__description' => "Wszystkie domeny na adresie IP %1.",
    'ui__server/ip-address/domain__short-title' => "Domeny",
    'ui__server/ip-address/domain__title' => "Domeny na adresie IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Wszystkie domeny na adresie IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domeny",
    'ui__server/ip-address/domain_unknown__title' => "Domeny na adresie IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Wybierz odpowiedni adres IP i kliknij Dalej ť.",

    'ui__server/ip-address/properties__description' => 'Zmień właciwoci adresu IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Właściwości',
    'ui__server/ip-address/properties__title' => 'Zmień właciwoci adresu IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Dodaj adres IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Kiedy skończysz zmieniać właciwoci adresu IP kliknij Zakończ aby wprowadzić zmiany.',
    'ui__server/ip-address/properties_unknown__description' => 'Zmień właciwoci adresu IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Właściwości',
    'ui__server/ip-address/properties_unknown__title' => 'Zmień właciwoci adresów IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Zmień właciwoci adresów IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Wybierz adres IP którego właciwoci chcesz zmienić.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Kiedy skończysz zmieniać właciwoci adresu IP kliknij Zakończ aby wprowadzić zmiany.',

    'ui__server/spam-filter/black-list__description' => 'Ustaw parametry czarnej listy antyspamowej serwera.',
    'ui__server/spam-filter/black-list__short-title' => 'Czarna lista',
    'ui__server/spam-filter/black-list__title' => 'Czarna lista antyspamowa serwera',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Tylko %1 pierwszy unikalny adres e-mail zostanie dodany.',
    'ui__server/spam-filter/black-list/address__description' => 'Adresy na czarnej licie antyspamowej.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Nie ma żadnych adresów e-mail na licie.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Wgrany plik jest pusty.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Następujšcy adres e-mail jest nieważny: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Nie ma żadnych adresów na czarnej licie antyspamowej.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adres',
    'ui__server/spam-filter/black-list/address__title' => 'Adres na czarnej licie %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Wstaw adresy na czarnš listę.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Dodaj adresy',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Wstaw adresy na czarnš listę',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Usuń %1 adres z czarnej listy antyspamowej serwera.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Usuń',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Usuń %1 adres z czarnej listy antyspamowej serwera',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Usuń adresy z czarnej listy antyspamowej serwera.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Usuń',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Usuń adresy z czarnej listy antyspamowej serwera',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Usuwanie adresów z czarnej listy antyspamowej serwera',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Wybierz adresy do usunięcia i kliknij Dalej ť',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Potwierdź usunięcie adresów filtra antyspamowego poprzez oznaczenie okienka Zakończ, aby zupełnie je usunąć i wyjść z kreatora.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Usuń adres z czarnej listy antyspamowej serwera.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Usuń',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Usuń adres z czarnej listy antyspamowej serwera',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Usuwanie adresów z czarnej listy antyspamowej serwera',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Wybierz adres do usunięcia i kliknij Dalej >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Potwierdź usunięcie adresu filtra antyspamowego poprzez oznaczenie okienka Zakończ, aby zupełnie je usunąć i wyjść z kreatora.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Tylko %1 pierwszy unikalny adres e-mail zostanie dodany.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Nie ma żadnych adresów e-mail na licie.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Nie udało się wgrać pliku. Maksymalny rozmiar pliku do wgrania to %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Następujšcy adres e-mail jest nieważny: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Wstaw adresy na czarnš listę.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Dodaj adresy',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Wstaw adresy na czarnš listę',

    'ui__server/spam-filter/properties__description' => 'Ustaw parametry filtru antyspamowego.',

    'ui__server/spam-filter/properties__short-title' => 'Ustawienia',
    'ui__server/spam-filter/properties__title' => 'Ustawienia filtru antyspamowego',

    'ui__server/spam-filter/toggle_disable__description' => 'Zdezaktywuj filtrowanie antyspamowe dla całego systemu.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Zablokuj',
    'ui__server/spam-filter/toggle_disable__title' => 'Zdezaktywuj filtrowanie antyspamowe',
    'ui__server/spam-filter/toggle_enable__description' => 'Aktywuj filtrowanie antyspamowe dla całego serwera.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Włącz',
    'ui__server/spam-filter/toggle_enable__title' => 'Aktywuj filtrowanie antyspamowe',
    'ui__server/spam-filter/toggle_unknown__description' => 'Aktywuj lub zdezaktywuj filtrowanie antyspamowe dla całego serwera.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Aktywuj lub zdezaktywuj',
    'ui__server/spam-filter/toggle_unknown__title' => 'Aktywuj lub zdezaktywuj filtrowanie antyspamowe',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Aktywuj lub zdezaktywuj filtr antyspamowy',

    'ui__server/spam-filter/white-list__description' => 'Ustaw parametry filtru antyspamowego na całym serwerze.',
    'ui__server/spam-filter/white-list__short-title' => 'Biała lista',
    'ui__server/spam-filter/white-list__title' => 'Biała lista filtru antyspamowego serwera',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Tylko %1 pierwszy unikalny adres e-mail zostanie dodany.',
    'ui__server/spam-filter/white-list/address__description' => 'Adresy na białej licie filtru antyspamowego.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Nie ma żadnych adresów e-mail na licie.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Wgrany plik jest pusty.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Następujšcy adres e-mail jest nieważny: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Nie ma żadnych adresów na białej licie antyspamowej serwera.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adres',
    'ui__server/spam-filter/white-list/address__title' => 'Adres na białej licie %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Dodaj adresy do białej listy.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Dodaj adresy',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Dodaj adresy do białej listy',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Usuń %1 adres z białej listy antyspamowej serwera.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Usuń',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Usuń %1 adres z białej listy antyspamowej serwera',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Usuń adresy z białej listy antyspamowej serwera.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Usuń',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Usuń adresy z białej listy antyspamowej serwera',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Usuwanie adresów z białej listy antyspamowej serwera',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Wybierz adresy do usunięcia i kliknij Dalej ť',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Potwierdź usunięcie adresów filtra antyspamowego poprzez oznaczenie okienka Zakończ, aby zupełnie je usunąć i wyjść z kreatora.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Usuń adres z białej listy antyspamowej serwera.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Usuń',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Usuń adres z białej listy antyspamowej serwera',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Usuwanie adresów z białej listy antyspamowej serwera',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Wybierz adres do usunięcia i kliknij Dalej >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Potwierdź usunięcie adresu filtra antyspamowego poprzez oznaczenie okienka Zakończ, aby zupełnie je usunąć i wyjść z kreatora.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Tylko %1 pierwszy unikalny adres e-mail zostanie dodany.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Nie ma żadnych adresów e-mail na licie.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Nie udało się wgrać pliku. Maksymalny rozmiar pliku do wgrania to %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Następujšcy adres e-mail jest nieważny: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Dodaj adresy do białej listy.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Dodaj adresy',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Dodaj adresy do białej listy',

    'ui__server/mail/statistics#apply__description' => "Zastosuj filtr",
    'ui__server/mail/statistics#apply__title' => "Zastosuj",
    'ui__server/mail/statistics#custom_from__title' => "od",
    'ui__server/mail/statistics#custom_to__title' => "do",
    'ui__server/mail/statistics#period_all__title' => "Wszystko",
    'ui__server/mail/statistics#period_custom__title' => "Personalizuj",
    'ui__server/mail/statistics#period_month__title' => "Obecny miesiąc",
    'ui__server/mail/statistics#period_prev_month__title' => "Poprzedni miesiąc",
    'ui__server/mail/statistics#period_prev_week__title' => "Poprzedni tydzień",
    'ui__server/mail/statistics#period_today__title' => "Dzisiaj",
    'ui__server/mail/statistics#period_week__title' => "Obecny tydzień",
    'ui__server/mail/statistics#period_yesterday__title' => "Wczoraj",
    'ui__server/mail/statistics#show_for_period__title' => "Pokaż okres",
    'ui__server/mail/statistics#tools_legend__title' => "Narzędzia",
    'ui__server/mail/statistics__description' => "Zobacz statystyki spamu i wirusów",

    'ui__server/mail/statistics__short-title' => "Statystyki",
    'ui__server/mail/statistics__title' => "Ustawienia poczty",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Statystyki spamu",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Narzędzia",
    'ui__server/mail/statistics/spam__description' => "Zobacz statystyki spamu",

    'ui__server/mail/statistics/spam__short-title' => "Statystyki spamu",
    'ui__server/mail/statistics/spam__title' => "Statystyki spamu",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Nazwa skrzynki",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% ze wszystkich",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sortuj według kont pocztowych",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sortuj według % ze wszystkich",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sortuj według otrzymanego spamu",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "konta pocztowe",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Otrzymany spam",
    'ui__server/mail/statistics/spam/recipients__description' => "Odbiorcy",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Odbiorcy",
    'ui__server/mail/statistics/spam/recipients__title' => "Odbiorcy",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Czyste",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Zainfekowany",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% ze wszystkich",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Liczba",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Chronione",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Niesprawdzone",
    'ui__server/mail/statistics/spam/summary__description' => "Podsumowanie",

    'ui__server/mail/statistics/spam/summary__short-title' => "Podsumowanie",
    'ui__server/mail/statistics/spam/summary__title' => "Podsumowanie",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Statystyki wirusów",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Narzędzia",
    'ui__server/mail/statistics/virus__description' => "Zobacz statystyki wirusów",

    'ui__server/mail/statistics/virus__short-title' => "Statystyki wirusów",
    'ui__server/mail/statistics/virus__title' => "Statystyki wirusów",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Konto pocztowe",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% ze wszystkich",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sortuj według nazwy skrzynki",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sortuj według % ze wszystkich",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sortuj według otrzymanych wirusów",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Konta pocztowe",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Otrzymane wirusy",
    'ui__server/mail/statistics/virus/recipients__description' => "Odbiorcy",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Odbiorcy",
    'ui__server/mail/statistics/virus/recipients__title' => "Odbiorcy",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Czyste",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Zainfekowany",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% ze wszystkich",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Liczba",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Chronione",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Niesprawdzone",
    'ui__server/mail/statistics/virus/summary__description' => "Podsumowanie",

    'ui__server/mail/statistics/virus/summary__short-title' => "Podsumowanie",
    'ui__server/mail/statistics/virus/summary__title' => "Podsumowanie",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Nazwa",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% ze wszystkich",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sortuj według nazwy",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sortuj według % ze wszystkich",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sortuj według zainfekowanych obiektów",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Wirusy",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Zainfekowane obiekty",
    'ui__server/mail/statistics/virus/viruses__description' => "Wirusy",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Wirusy",
    'ui__server/mail/statistics/virus/viruses__title' => "Wirusy",

    'ui__support#param_company__title' => "Firma",
    'ui__support#param_email__title' => "E-mail",
    'ui__support#param_firstname__title' => "Imię",
    'ui__support#param_keynumber__title' => "Numer klucza produktu",
    'ui__support#param_operatingsystem__title' => "System operacyjny",
    'ui__support#param_phone__title' => "Numer telefonu",
    'ui__support#param_psabuild__title' => "Wersja Pleska",
    'ui__support#param_psainsttype__title' => "Typ instalacji Plesk",
    'ui__support#param_psaversion__title' => "Wersja Pleska",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Narzędzia",

    'ui__reseller/traffic-history_unknown__short-title' => "Zobacz zużycie transferu przez sprzedawców",
    'ui__reseller/traffic-history_unknown__title' => "Zobacz zużycie transferu przez sprzedawców",
    'ui__reseller/traffic-history_unknown__description' => "Pokaż transfer względem kont sprzedawców.",
    'ui__reseller#list__title' => "Sprzedawcy",
    'accounts_list__name__filter_title' => "Nazwa",
    'accounts_list__resource__filter_title' => "Zużycie zasobu",
    'resellers_list__filter_resource_usage_any' => "Jakiekolwiek",
    'resellers_list__filter_resource_usage_overuse' => "Nadmiarowe zużycie",
    'resellers_list__filter_resource_usage_normal' => "W limitach",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Jakiekolwiek",
    'resellers_list__filter_status_blocked' => "Zawieszone",
    'resellers_list__filter_status_active' => "Aktywny",
    'resellers_list__filter_clients__filter_title' => "Pokaż",
    'resellers_list__filter_clients_on' => "sprzedawcy ze swoimi klientami",
    'resellers_list__filter_clients_off' => "Tylko sprzedawcy",
    '__disk_usage' => "Zużyta przestrzeń dyskowa",
    'ui__reseller/traffic_unknown__short-title' => "Zobacz zużycie transferu przez sprzedawców",
    'ui__reseller/traffic_unknown__title' => "Zobacz zużycie transferu przez sprzedawców",
    'ui__reseller/traffic#list__title' => "Transfer względem sprzedawcy",
    'ui__reseller/traffic_unknown__description' => "Pokaż raporty zużycia transferu.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Transfer względem sprzedawcy",

    '__reseller_name' => "Nazwa sprzedawcy",
    '__reseller' => "Sprzedawcy",
    'resellertrafficlist_header' => "Zobacz zużycie transferu przez sprzedawców",
    '__reseller_personal' => "Transfer zużyty przez domeny sprzedawcy",
    'ui__reseller/traffic-history__short-title' => "Transfer względem sprzedawców",
    'ui__reseller/traffic-history__title' => "Transfer względem sprzedawców",
    'ui__reseller/traffic-history__description' => "Pokaż raporty zużycia transferu.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Zezwalaj na nad-sprzedaż",
    'limits__reseller_oversell_description' => "Nadsprzedaż pozwala sprzedawcy sprzedać więcej zasobów niż właściwie mu było alokowanych. Jeżeli nadsprzedaż jest udostępniona to sprzedawca jest podporządkowany przez właściwe zużycie zamiast inicjalną alokację zasobów",
    'limits__overuse_block_text' => "Polityka nadużyć",
    'limits__overuse_block_true_text' => "Nadmiarowe zużycie jest niedozwolone",
    'limits__reseller_overuse_block_true_description' => "Blokuj nadużycie zasobów. Zużycie zasobów nie może przekraczać inicjalną ich alokację",
    'limits__overuse_block_false_text' => "Nadmiarowe zużycie jest dozwolone",
    'limits__reseller_overuse_block_false_description' => "Nie blokuj nadmiernego zużycia zasobów, pozwalając sprzedawcom użytkować więcej zasobów niż początkowo dostarczono. Właściwe zużycie zasobów może przekroczyć inicjalna alokację",
    'limits__reseller_overuse_notify_text' => "Poinformuj sprzedawcy, że niedługo osiągnie limit zasobów",
    'reseller_perm__manage_sh_access_disabled' => "Sprzedawca nie może udostępnić ani zablokować dostępu do powłoki",
    'reseller_perm__manage_sh_access_chrooted' => "Sprzedawca może udostępnić jedynie do środowisko chroot",
    'reseller_perm__manage_sh_access_any' => "Sprzedawca może udostępnić dowolny typu powłoki",
    'template__reseller_num_excl_ips' => "Przydziel dedykowane adresy IP do sprzedawcy",

    // Reseller's Home page
    'client_chown__no_clients_selected' => 'Proszę wybrać konta klientów do których chcesz przypisać nowego właściciela.',
    'ui__reseller#tools2__title' => "Konto",
    'ui__reseller#info__title' => "Informacja",
    'ui__reseller#clientsTab__title' => "Klienci",
    'ui__reseller#domainsTab__title' => "Domeny",
    'ui__reseller__title' => "Zarządzaj kontem sprzedawcy %1",
    'domains__reseller_info' => "%1 klient(ów), %2 domen(a), zużyte %3 przestrzeni dyskowej, wytransferowano %4 danych.",
    'domains__reseller_info_hiding_traffic' => "Zużyto %1 klientów, %2 domen, %3 przestrzeni dyskowej.",
    'ui__reseller__description' => "Zarządzaj kontem sprzedawcy.",

    'ui__reseller/limits_unknown__wizard-title' => 'Pokaż lub zmień limity zasobów sprzedawcy',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Wybierz właściwego sprzedawcy.',
    'ui__reseller/limits_unknown__wizard__2' => 'Aby wprowadzić zmiany kliknij Zakończ.',

    'ui__client/report_reseller__short-title' => "Raport",
    'ui__client/report_reseller__title' => "Wyświetl raport konta",
    'ui__client/report_reseller__description' => "Wyświetl raport konta sprzedawcy.",
    'ui__client/ip-pool_reseller__short-title' => "Zbiór IP",
    'ui__client/ip-pool_reseller__description' => "Przypisz adresy Ipi certyfikaty SSL/TLS do konta sprzedawcy.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Określ preferencje konta i kliknij Zakończ.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Zobacz lub zmień przyzwolenia które chcesz zmienić lub zmodyfikować',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Wybierz sprzedawcy którego przyzwolenia chcesz zobaczyć lub zmienić.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Kiedy skończysz zmieniać uprawnienia sprzedawcy kliknij Zakończ aby wprowadzić zmiany i opuścić kreatora.',

    // Customers > create customer account

    '__resellers_list' => 'Sprzedawcy',
    'picker_reseller__title' => 'Wybierz sprzedawcy',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Narzędzia",
    'ui__client#tools2__title' => "Konto",
    'ui__client#info__title' => "Informacja",
    'ui__client#clientslist__title' => "Klienci",
    'ui__client#domainslist__title' => "Domeny",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Jeżeli chcesz mieć taką możliwość, powinieneś nabyć nowy klucz licencji Wszystkie aplikacje WW są teraz posortowane według kategorii, co czyni łatwiejszym wybór instalacji właściwej aplikacji.",
    'feature__domainkeys__reseller' => "Możesz użyć mechanizmu autentykacji wysyłania email DKIM by zredukować ilość spamu i phishing.",

    '__reseller_form' => "Formularz sprzedawcy",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Wybierz konto klienckie, którego preferencje chcesz zmienić.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Aby zmienić limity zużycia zasobów, kliknij Limity zasobów.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Aby zmienić przyzwolenia do operacji które może przeprowadzić klient w Plesk, kliknij Przyzwolenia.",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "Aby stworzyć domenę, która należy do Twojego własnego konta kliknij Utwórz Domenę. Aby utworzyć domenę dla jednego ze swoich klientów kliknij jego nazwę, a następnie Utwórz Domenę.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Uczyń ten wzorzec dostępnym dla innych użytkowników",
    'template__shared_description' => "Zaznacz tę opcję jeśli chcesz aby Twoi klienci mogli używać tego szablonu.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Narzędzia',

    'ui__client/traffic-history_unknown__short-title' => 'Pokaż transfer względem Klientów',
    'ui__client/traffic-history_unknown__title' => 'Transfer względem klientów',
    'ui__client/traffic-history_unknown__description' => 'Pokaż raport zużycia transferu dla wszystkich klientów',
    'ui__client/traffic-history__short-title' => 'Transfer względem klientów',
    'ui__client/traffic-history__title' => 'Pokaż transfer względem Klientów',
    'ui__client/traffic-history__description' => 'Pokaż raport zużycia transferu dla wszystkich klientów',

    'ui__client/traffic#list__title' => 'Transfer względem klientów',
    'ui__reseller/client/traffic#list__title' => 'Transfer względem klientów',

    'clients_list__filter_type__filter_title' => 'Pokaż',
    'clients_list__filter_type_any' => 'Klienci i sprzedawcy',
    'clients_list__filter_type_clients' => 'Tylko klienci',
    'clients_list__filter_type_resellers' => 'Tylko sprzedawcy',
    'ui__client/domain_unknown-new__short-title' => "Utwórz domenę",

    // Customers > View traffic by customers
    '__personal' => "Transfer zużyty przez domeny użytkownika",
    'PersonalTrafficList_header_of_client__' => "Pokaż Raport Zużycia Transferu dla Twojego Konta",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Administrator domeny nie może zezwolić lub zabronić dostępu do shell",
    'domain_perm__manage_sh_access_chrooted' => "Administrator domeny może zezwolić na dostęp tylko do środowiska izolowanego (chroot)",
    'domain_perm__manage_sh_access_any' => "Administrator domeny może zezwolić na dostępu do jakiegokolwiek typu shell",

    // APS Catalog
    'bt_add_to_vault' => "Dodaj do skarbca",
    'bt_hide_updates' => "Ukryj dostępne uaktualnienia",
    'bt_show_updates' => "Pokaż dostępne aktualizacje",

    '__site_apps__applications' => "Aplikacje",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplikacje wybrane do dania do skarbca",
    'site_apps__application_selected' => "Wybrany",
    'site_apps__currently_in_vault' => "Inne wersje już są w skarbcu:",
    'site_apps__new_versions' => "Nowe wersje:",
    'site_apps__patches' => "Łatki:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Liczba aplikacji zaplanowanych do dodania do składu: %1",
    'site_apps__applications_downloading_now' => "Teraz pobierane są następujące aplikacje: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Pakiet już istnieje w skarbcu",

    // Server > Action Log
    'bt_skin_edit' => "Edytuj opis skórki",
    'domains__you_want_change_the_status_of_the_reseller??' => "Jesteś pewny, że chcesz zmienić status konta sprzedawcy?",
    'limits__oversell_legend' => "Nad sprzedaż",
    'limitsManager__limit_available_error' => "Ne można przydzielić żądanej liczby zasobów (%%quantity%% %%limitName%%). Jedynie %%available%% %%limitName%% jest dostępne.",
    'limitsManager__limit_reserved_error' => "Nie można ustawić wymaganego limitu zużycia zasobów (%%quantity%% %%limitName%%) ponieważ nowa wartoć jest mniejsza od iloci zasobów zarezerwowanych dla twoich klientów lub używana przez Ciebie (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Nie można ustawić wymaganego limitu zużycia zasobów (%%quantity%% %%limitName%%) ponieważ nowa wartość jest mniejsza od ilości zasobów używanych przez Twoje konto i strony (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Raport zużycia transferu",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Pokaż raport zużycia transferu",
    'ui__client/domain/traffic_unknown-reseller__title' => "Pokaż raport zużycia transferu",

    'ui__client/domain_new__short-title' => "Utwórz domenę",

    'ui__client_reseller__description' => "Zarządzaj kontem sprzedawcy %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Zarządzaj kontem sprzedawcy",

    '__owner_name' => "Nazwa właściciela",
    'domains_list__resource__filter_title' => "Zużycie zasobu",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Katalog aplikacji APS",
    'site_apps__applications_have_updates' => "Dostępne są zaktualizowane wersje następujących aplikacji:\n%1\nAby zobaczyć aktualizacje upewnij się, że pole Wyszukaj jest widoczne, zaznacz pole wyboru <b>Pokaż tylko aktualizacje </b> i wyszukaj tylko aplikacje których potrzebujesz.",
    'site_apps__progress_adding_to_vault' => "Dodawane do skarbca:",
    'site_apps__progress_done_message' => "Postęp:",
    'site_apps__progress_applications_left' => "Pozostało %1 z %2 aplikacji",
    'site_apps__download_item_long_task_title' => "Ściągnij aplikację APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Ściągnij aplikacje APS z katalogu APS",
    'site_apps__last_check_for_updates' => "ostatnie sprawdzenie aktualizacji: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Wszystkie zaplanowane aplikacje zostały dodane z powodzeniem do skarbca aplikacji",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 zaplanowanych aplikacji zostało pomyślnie dodanych do skarbca aplikacji.",
    'site_apps__no_search_results' => 'Nie znaleziono aplikacji. Spróbuj innego wyszukiwania lub przeszukaj aplikacje według kategorii.',
    'site_apps__search_results_title' => 'Wyniki wyszukiwania',
    '__site_apps__search_by_application' => 'Nazwa aplikacji',
    '__site_apps__search_by_vendor' => 'Dostawca',
    '__site_apps__search_by_vendor__all' => 'Wszyscy dostawcy',
    '__site_apps__search_by_packager' => 'Pakowacz',
    '__site_apps__search_by_certification_level' => 'Poziom certyfikacji',
    '__site_apps__search_by_cert__any' => 'Jakiekolwiek',
    '__site_apps__search_by_cert__silver_and_higher' => 'Srebrne i wyższe',
    '__site_apps__search_by_cert__gold_and_higher' => 'Złoty i wyższy',
    '__retry' => 'Potwórz',
    'site_apps__application_packager_site' => 'Pakowacz',
    'site_apps__add_to_pool_message' => "Aplikacje oznaczone jako \"dostępne dla wszystkich\"\\ są automatycznie dystrybuowane do wszystkich sprzedawców i klientów z nieograniczoną liczbą instalacji. Ograniczone aplikacje są dystrybuowane do wszystkich sprzedawców i klientów ręcznie i indywidualnie z określoną liczbą dostępnych instalacji.",
    'site_apps__make_available_for_all' => "Uczyń wybrane aplikacje dostępnymi dla wszystkich użytkowników",

    'site_apps__broadcast_app_text' => "Aplikacje oznaczone jako \"dostępne dla wszystkich\"\\ są automatycznie dystrybuowane do wszystkich sprzedawców i klientów z nieograniczoną liczbą instalacji. Ograniczone aplikacje są dystrybuowane do wszystkich sprzedawców i klientów ręcznie i indywidualnie z określoną liczbą dostępnych instalacji.",
    'site_apps__broadcast_app_name' => 'Uczyń aplikacje dostępnymi dla wszystkich użytkowników',

    // User Application Pool per application
    'site_apps__available_clients' => 'Dostępni użytkownicy',
    'site_apps__no_more_clients_to_add_to_pool' => 'Nie ma więcej kont użytkowników którym mógłbyś dostarczyć tej aplikacji',

    // Installed application instances
    'site_apps__installations' => 'Instalacje',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nazwa domeny i adresy IP",
    '__assign_ip_address' => "Wybierz adres IP",
    '__switch_on_service' => "Włącz usługę",
    '__hosting_configuration' => "Konfiguracja hostingu",
    '__vrt_hst' => "Hosting strony WWW",
    '__vrt_hst_hint' => "Hostuj stronę WWW na tym serwerze.",
    '__fwd' => "Przekierowanie",
    '__web_hosting_settings' => "Ustawienia hostingu",
    '__fwd_hint' => "Przekierowanie gości na inną stronę WWW.",
    '__none_hint' => "Nie hostuj strony WWW w tej chwili.",
    '__login_hint' => "Ten login jest używany w celu uzyskania dostępu do strony przez FTP",
    '__password_hint' => "To hasło jest używane w celu uzyskania dostępu do strony przez FTP",
    '__advanced_hosting_setup' => "Konfiguruj zaawansowane ustawienia hostingu strony WWW",
    '__domain_creation_successful' => "Domena została utworzona.",
    'bt_hosting_settings' => "Ustawienia hostingu",
    '__change_hosting_type' => "Zmień typ hostingu dla domeny %1",
    '__hosting_type_change_warning' => "Kiedy zmieniasz tym hostingu na przekazywanie (forwarding) lub brak hostingu wszystkie katalogi dotyczące twojej strony zostają usunięte z serwera. Upewnij się, że zabezpieczyłeś lokalną kopię zapasową swojej strony.",
    '__current_hosting_type' => "Obecny typ hostingu",
    '__new_hosting_type' => "Nowy typ hostingu",
    '__fwd_settings' => "Ustawienia przekierowania",
    '__fwd_settings_legend' => "Ustawienia przekierowania",
    '__fwd_destination_url' => "Docelowy URL",
    '__fwd_type' => "Typ przekierowania",
    '__fwd_type_standart' => "Standardowe przekierowanie",
    '__fwd_type_standart_hint' => "Przekieruj odwiedzających stronę na inną stronę i pokaż im adres docelowy tak, żeby wiedzieli o przekierowaniu.",
    '__fwd_type_frame' => "Przekierowanie przez ramkę",
    '__fwd_type_frame_hint' => "Przekieruj odwiedzających stronę na inną stronę, ale nie pokazuj im adresu docelowego tak, żeby nie wiedzieli o przekierowaniu.",
    '__hosting_type_template_warning' => "Typ hostingu który wybrałeś jest niż wskazanego w szablonie. Jeśli zdecydujesz się kontynuować ustawienia hostingu określone w szablonie zostaną zignorowane. Czy na pewno chcesz ustawić wybrany typ hostingu ?",

    'ui__client/domain/properties#vrt_hst__title' => "Hosting strony WWW",
    'ui__client/domain/properties#vrt_hst__description' => "Hostuj stronę WWW na tym serwerze",
    'ui__client/domain/properties#fwd__title' => "Przekierowanie",
    'ui__client/domain/properties#fwd__description' => "Przekieruj odwiedzających do innej strony WWW",
    'ui__client/domain/properties#none__title' => "Brak hostingu",
    'ui__client/domain/properties#none__description' => "Nie hostuj strony WWW w tym momencie",

    '__no_resellers_selected' => "Musisz wybrać przynajmniej jedno konto sprzedawcy.",

    'ui__client/logo_unknown__wizard-title' => 'Ustaw właściwości loga',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Zaznacz klienta u którego właściwości loga chcesz zmienić.',
    'ui__client/logo_unknown__wizard__2' => 'Kliknij Zakończ.',
    'ui__client/logo_unknown__wizard__2_self' => 'Kliknij Zakończ.',

    'ui__client/ipaddress/properties_new__short-title' => "Dodaj adres IP",
    'ui__client/ipaddress/properties_new__title' => 'Dodaj adres IP',
    'ui__client/ipaddress/properties_new__description' => "Dodaj adres IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Dodaj adres IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Dodaj adres IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Dodaj adres IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Usuń adres IP",
    'ui__client/ipaddress/delete_multi__description' => "Usuń adresy IP.",
    'ippool_Manager__no_available_ips' => "Brak wolnych adresów IP w puli IP.",
    'ippool_Manager__ip_shared' => "współdzielony",
    'ippool_Manager__ip_exclusive' => "dedykowany",
    'ui__client/ipaddress/properties__title' => "Zarządzaj adresami IP",
    'ui__client/ipaddress/properties__description' => "Wyświetl lub zmień właściwości adresu IP.",
    'ui__client/ipaddress_unknown-new__title' => "Dodaj adres IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Dodaj adres IP",
    'ui__client/ipaddress_unknown-new__description' => "Dodaj adresy IP.",

    'ui__mass-mail#to_resellers_text__title' => "Sprzedawcy",
    'ui__mass-mail#to_domainusers_text__title' => "Administratorzy domen",
    'ui__mass-email#tools_legend__title' => "Narzędzia",
    'ui__mass-email#list_legend__title' => 'Wzorce masowych wiadomoci e-mail',
    'ui__mass-email#template_legend__title' => "Szablon",
    'ui__mass-email#from_email_text__title' => "Od",
    'ui__mass-email#to_text__title' => 'Do',
    'ui__mass-email#to_resellers_text__title' => "Sprzedawcy",
    'ui__mass-email#to_clients_text__title' => "Klienci",
    'ui__mass-email#to_domainusers_text__title' => "Administratorzy domen",
    'ui__mass-email#to_admin_text__title' => "Administrator Plesk",
    'ui__mass-email#option_mode_all__title' => "Wszystko",
    'ui__mass-email#option_mode_select__title' => "Wszystkie zaznaczone",
    'ui__mass-email#option_mode_except__title' => "Wszystkie prócz zaznaczonych",
    'ui__mass-email#option_select_template__title' => '---Zaznacz szablon---',
    'ui__mass-email#subject_text__title' => "Temat",
    'ui__mass-email#body_text__title' => "Tekst wiadomości",
    'ui__mass-email#save_as_legend__title' => "Zapisz jako wzorzec",
    'ui__mass-email#save_as_text__title' => "Zapisz utworzoną wiadomość jako nowy szablon pod nazwą",
    'ui__reseller/preferences_unknown__wizard-title' => "Zmień preferencje konta",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Wybierz sprzedawcy którego preferencje konta chcesz zmienić i kliknij Dalej.",
    'ui__reseller/preferences_unknown__wizard__2' => "Określ preferencje konta i kliknij OK.",
    'ippoolManager__ip_shared' => "współdzielony",
    'ippoolManager__ip_exclusive' => "dedykowany",

    '__users_list' => "Użytkownicy",
    '__users' => "Użytkownicy",
    '__user_name' => "Nazwa/-y użytkownika/-ów",

    'clientOwnerChanger__wrong_owner_type' => "Możesz przekazać wybrane konta klienckie jedynie do konta sprzedawcy.",
    'clientOwnerChanger__wrong_client_type' => 'Wybrane konto użytkownika jest kontem sprzedawcy. Kontom sprzedawców nie można przypisać nowego użytkownika, jako że są w posiadaniu administratora serwera.',
    'ui__client/chowner_multi__description' => "Transfer kont użytkowników do innego właściciela.",
    'client_chown__clients_list_legend' => "Konta użytkowników",
    'client_chown__client_name' => "Nazwa/-y użytkownika/-ów",
    'client_chown__old_owner' => "Poprzedni właściciel",
    'client_chown__limits_legend' => "Zasoby",
    'client_chown__limit_name' => "Nazwa zasobu",
    'client_chown__limit_value' => "Przydzielone zasoby",
    'client_chown__usage_before' => "Przed transferem",
    'client_chown_usage_after' => "Po transferze",
    'limit__name_max_dom_aliases' => "aliasy domen",
    'limit__name_max_subftp_users' => "dodatkowe konta FTP",
    'limit__name_max_mssql_db' => "Bazy danych serwera Microsoft SQL",
    'limit__name_max_iis_app_pools' => "Pule aplikacji IIS",
    'limit__name_max_odbc' => "Połączenia ODBC",
    'total_mboxes_quota_unsupported' => 'nie obsługiwany przez serwer pocztowy',
    'limit_soft__disk_space' => 'Powiadom o osiągnięciu limitu przestrzeni dyskowej',
    'limit_soft__max_traffic' => 'Powiadom o osiągnięciu limitu ruchu',
    'dsr__of_reseller_title' => "Zużycie zasobów przez domeny",
    'client_chown__new_owner' => 'Nowy właściciel',
    'ui__reseller/to-client__has_clients_warning' => 'Niektóre z wybranych kont sprzedawców nie mogą zostać przekonwertowane do klienckich ponieważ posiadają przypisane konta klienckie. Usuń konta klienckie przypisane do tych sprzedawców bądź przenieś je do innego sprzedawcy.',
    'limitsManager__commit_failed' => "Nie można zmienić limitów zasobów.",
    'limitsManager__date_in_past' => "Niewłaściwa data wygaszenia %1.",
    'limitsManager__limit_not_supported' => "Limity dla typu zasobu %1 nie mogą być ustawione.",
    'limitsManager__limit_oversell_inconsistency' => "Nie można alokować określonej ilości zasobów z włączoną nadsprzedażą.",
    'limitsManager__limit_overuse_inconsistency' => "Zużycie zasobu przekracza zdefiniowane limity.",
    'limitsManager__no_resource_available' => "Nie ma dostępnych zasobów tego typu (%%limitName%%) pozostało. Żądane: %%quantity%%; dostępne: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Brak zasobów tego typu (%%limitName%%) udostępnianych przez dostawce usług. Żądane: %%quantity%%; dostępne: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Data wygaśnięcia musi być mniejsza od lub równa %1.",
    'limitsManager__invalid_disk_space_limit' => "Ilość miejsca na dysku musi być mniejsza od lub równa %1.",
    'limitsManager__invalid_max_traffic_limit' => "Ilość transferu musi być mniejsza od lub równa %1.",
    'ippoolManager__ip_has_suballocations' => "Nie można zmienić typu adresu IP już alokowanego do użytkownika. Adres IP %%ip%% jest już alokowany do użytkownika jako %%reserved%% adres IP.",
    'ippoolManager__ip_is_already_in_pool' => "Adres IP %%ip%% jest już przypisany do użytkownika.",
    'ippoolManager__ip_is_not_in_pool' => "Brak adresu IP %%ip%% w puli.",
    'ippoolManager__can_not_allocate_ip' => "Adres IP %%ip%% jest dostępny jedynie jako %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Adres IP %%ip%% nie może być przydzielony jako dedykowany.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Adres IP %%ip%% jest już używany do hostingu.",
    'ippoolManager__active_anon_ftp_on_ip' => "Dostęp do anonimowego FTP jest już włączony dla adresu IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Brak wolnych adres.",
    'ippoolManager__no_available_ips' => "Brak dostępnych adresów IP.",
    'templates__dublicate_name' => "Wzorzec o takiej nazwie już istnieje. Proszę podać inną nazwę dla tego wzorca.",
    'cl_perm__client_limits_exceeded' => "Wartość limitu określonego zasobu lub bieżące zużycie zasobów przez Twoje strony przekracza wartości dozwolone przez Twój plan hostingowy.",
    'cl_perm__reseller_limits_exceeded' => "Wartość limitu określonego zasobu lub bieżące zużycie zasobów przez kona lub strony użytkowników przekraczają wartości dozwolone przez Twój plan hostingowy.",

    'site_apps__preferences_show_all_versions_title' => "Pokaż pełną listę wersji dla każdej aplikacji uzyskanej z katalogu",
    'site_apps__preferences_show_all_versions_hint' => "Jeśli ta opcja jest zaznaczona to operacja pobrania wszystkich wersji każdej aplikacji może zająć dużo czasu, za każdym razem gdy otworzysz katalog. Jeśli ta opcja nie jest zaznaczona to tylko ostatnie wersje są pokazane.",
    '__select_user_template' => "Utwórz konto użytkownika bazujące na wzorcu",
    'ip_already_added_to_all_clients' => "Ten adres IP jest już przypisany do wszystkich użytkowników.",
    'ui__server/ip-address/client/delete#legend__description' => "Następujące adresy IP zostaną usunięte z systemu i z pul użytkowników:",

    'site_apps__cancelled_apps' => "Anulowałeś dodanie następującej aplikacji: %2",

    'sb_url_is_not_resolved' => 'URL nie może być rozwišzane: sprawd ustawienia DNS. Zapytanie o URL %1 musi zwracać odpowied z adresem IP serwera z zainstalowanym Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Nie można usunąć adresu IP %%ip%% ponieważ to jest ostatni adres IP w obecnym interfejsie sieciowym.',
    'ip_addr__used_for_current_session' => 'Nie można usunąć adresu IP %%ip%% ponieważ jest używany przez aktywną sesję.',
    'ip_addr__used_for_hosting' => 'Nie można usunąć adresu IP %%ip%% ponieważ jest używany do utrzymania serwisu WWW.',
    'ip_addr__is_main' => 'Nie można usunąć adresu IP %%ip%% ponieważ to jest podstawowy adres IP w obecnym interfejsie sieciowym.',
    'ip_addr__ip_used_by_message_submission' => 'Nie można usunąć adresu IP %%ip%% ponieważ jest używany do wysyłania wiadomości pocztowych',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domeny klienta',
    'excl_ip_num' => 'Dedykowany adres IP',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder jest niezainstalowany.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Pozwolenie na nadsprzedaż nie może być cofnięta użytkownikowi ponieważ już alokował więcej zasobów niż było dostępnych kiedy przechodził w tryb nadsprzedaży.',
    'limitsManager__invalid_limit_value' => 'Niewłaściwa wartość %%value%% określona dla limitu %%limit_name%%',
    'ip_alias__type' => "Typ IP",
    'ip_alias__in_type' => 'Adres IP przeniesiony jako',
    'ui__client/ipaddress/delete_multi__title' => 'Usuń adresy IP',
    'ui__client/ipaddress/delete#legend__short-title' => 'Pozycje które będą usunięte',
    'ui__client/ipaddress/delete#legend__description' => "Następujące adresy IP zostaną usunięte z puli użytkownika:",
    'ui__client/ipaddress/delete#nlegend__short-title' => 'Pozycje których nie można usunąć',
    'ui__client/ipaddress/delete#nlegend__description' => 'Następujące adresy IP nie mogą zostać usunięte:',
    'ui__server/ip-address/delete#legend__description' => 'Następujące adresy IP zostaną usunięte z puli serwera:',
    'confirmationForm_default_agreement_text' => 'Potwierdź operację',
    'confirmationForm_default_confirm_message' => 'Proszę potwierdzić operację.',
    'limit__max_mn' => 'Maksymalna liczba kont pocztowych',

    'limits__client_overuse_description' => 'Polityka nadużycia mówi Plesk co robić kiedy zużycie zasobów przekroczy początkową alokację zasobów.',
    'limits__client_overuse_block_true_description' => 'Blokuj nadużycie zasobów. Zużycie zasobów nie może przekraczać inicjalną ich alokację',
    'limits__client_overuse_block_false_description' => 'Nie blokuj nadużycia zasobów, pozwalając klientom zużyć więcej zasobów niż początkowo dostarczono. Właściwe zużycie zasobów może przekroczyć inicjalna alokację',
    'limits__client_overuse_notify_text' => 'Poinformuj klienta o osiągnięciu limitów zasobów',

    'limits__domain_overuse_description' => 'Polityka nadużycia mówi Plesk co robić kiedy zużycie zasobów przekroczy początkową alokację zasobów.',
    'limits__domain_overuse_block_true_description' => 'Polityka nadużycia mówi Plesk co robić kiedy zasoby są nadmiernie zużyte.',
    'limits__domain_overuse_block_false_description' => 'Nie blokuj nadużycia zasobów, zezwalajšc domenie na użycie więcej zasobów niż poczštkowo dostarczono. Właciwe zużycie zasobów może przekroczyć inicjalna alokację',
    'limits__domain_overuse_notify_text' => 'Powiadom właściciela domeny o osiągnięciu limitów zasobów dla domeny',


    'cancel_remove' => 'Kliknij, aby zrezygnować z jakichkolwiek zmian i wróć do poprzedniej strony.',
    'php_not_installed' => 'PHP nie jest zainstalowane',

    'dns__dns_rr_delete' => 'Pozycje które będą usunięte',
    'dns__delete_rr' => 'Następujące rekordy DNS zostaną usunięte ze strefy DNS:',
    'dns__dns_rr_delete_non_removable' => 'Pozycje których nie można usunąć',
    'dns__non_delete_rr' => 'Następujące rekordy DNS nie mogą zostać usunięte:',
    'dns__dns_rr_delete_confirm_message' => 'Potwierdź usunięcie rekordu DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Nie znany format aplikacji webowej: aplikacja webowa może być niedostępna do instalacji i użytkowania.',

    '__php_handler_type_desc' => 'Uruchom PHP jako',
    'sfdk_domain_sign__failed' => 'Niezidentyfikowany błąd pojawił się podczas próby włączenia podpisywania poczty z DKIM w domenie. Sprawdź logi błędów serwera w celu uzyskania dalszych informacji.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Powiadomienie o udanym uaktualnieniu klucza Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Powiadomienie o odłożeniu uaktualnienia klucza Plesk',
    'pkey_notify__subj_update_error_notification' => 'Powiadomienie o błędzie kluczowej aktualizacji klucza Plesk',
    'pkey_notify__update_successful' => '%1 uaktualnienie zakończone sukcesem.',
    'pkey_notify__update_failed_no_more_try' => 'Nie można uaktualnić %1. Klucz który próbujesz wysłać jest nieprawidłowy. Nie możesz już próbować aktualizacji.',
    'pkey_notify__update_failed_try_later' => 'Nie można zaktualizować %1: wystąpił błąd podczas przetwarzania klucza. Możesz spróbować odzyskać klucz ręcznie w Plesku (Narzędzia i ustawienia > Informacje o licencji) lub pozwolić Pleskowi spróbować go zaktualizować w ciągu najbliższych 24 godzin. Jeśli nie chcesz już otrzymywać tego powiadomienia, usuń ten klucz z Pleska.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Nie można wyłączyć filtrowania antyspamowego na poziomie serwera.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Nie można włączyć filtrowania antyspamowego na poziomie serwera',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => 'Ten sprzedawca',
    'report_auto__select_reseller_report_all' => 'Wszyscy sprzedawcy',
    'report_auto__select_reseller_report_client' => 'Wszyscy sprzedawcy tego klienta',
    'report_auto__select_reseller_report_current' => 'Ten sprzedawca',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => 'Wszyscy klienci sprzedawcy',
    'report_auto__select_client_report_client' => 'Ten klient',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => 'sprzedawcy, klienci i domeny',

    'rpt_reseller_section_full_domains' => 'Domeny',
    'rpt_reseller_dom_subdomains' => 'Subdomeny',
    'rpt_reseller_dom_domain_aliases' => 'AliasyD',
    'rpt_reseller_dom_postboxes' => 'Skrzynki',
    'rpt_reseller_dom_redirects' => 'Przekazywanie',
    'rpt_reseller_dom_mail_groups' => 'GrupyP',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'AntySpam',
    'rpt_reseller_dom_mail_antivirus' => 'Antywirus',
    'rpt_reseller_dom_mail_lists' => 'ListyM',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Klienci',
    '__cl_name' => 'Nazwa klienta',
    '__cl_creation_date' => 'Data utworzenia',
    '__clients_traffic' => 'Ruch klienta',
    'rpt_reseller_cl_mail_antispam' => 'AntySpam',
    'rpt_reseller_cl_mail_antivirus' => 'Antywirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder jest niezainstalowany.',
    'sitebuilder_disabled' => 'Presence Builder jest wyłączony.',
    'b_sitebuilder_disabled' => 'Presence Builder jest wyłączony.',
    'webmail_not_installed' => 'Nie zainstalowano oprogramowania poczty online.',
    'webmail_disabled' => 'Oprogramowanie WebMail jest wyłšczone.',
    'spamassassin_not_installed' => 'SpamAssasin nie jest zainstalowany.',
    // pfu:
    'anonymous_ftp_shared' => 'Nie można ustawić anonimowego FTP: współdzielony adres IP.',
    'anonymous_ftp_used' => 'Nie można ustawić anonimowego FTP: adres IP używany przez innš domenę do anonimowego FTP.',
    'sshterm__not_installed' => 'Terminal SSH nie został zainstalowany.',
    'sshterm__empty_shell' => 'W celu użycia klienta terminalowego musisz zezwolić na dostęp shell dla tej domeny.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET nie jest zainstalowane.',
    'site_builder_no_package' => 'Presence Builder jest niedostępny. Sprawdź, czy Presence Builder jest zainstalowany i czy jest oznaczony jako aktywny komponent.',
    'site_builder_not_configured' => 'Presence Builder nie jest skonfigurowany.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Narzędzia',
    'ui__reseller/client#clientslist__title' => 'Klienci',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "Konfiguruj żródła danych ODBC dla strony",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "Wybierz stronę, dla której aplikacji chcesz ustawić źródła danych ODBC.",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "Zarządzaj wirtualnymi katalogami na domenie",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "Wybierz domenę, której wirtualnymi katalogami chcesz zarządzać.",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Zarządzaj wirtualnymi katalogami na stronie',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Wybierz stronę WWW, której katalogami chcesz zarządzać.",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "Konfiguruj ochronę przed hotlink dla domeny",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "Wybierz domenę, której pliki chcesz chronić przed hotlinkowaniem.",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "Konfiguruj ustawienia PHP dla domeny",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "Wybierz domenę, dla której chcesz skonfigurować ustawienia PHP.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Ustaw anonimowe FTP na domenie',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Wybierz domenę, dla której chcesz skonfigurować anonimowy dostęp FTP.',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => 'Zarzšdzaj katalogami chronionymi hasłami na domenie',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => 'Wybierz domenę której katalogami chronionymi hasłem chcesz zarzšdzać.',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => 'Wybierz statystyki webowe dla domeny',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => 'Wybierz domenę, której statystyki webowe chcesz obejrzeć.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Ustaw menedżera logów dla domeny i zobacz logi domeny',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Wybierz domenę, której menedżera chcesz ustawić i której logi chcesz obejrzeć.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Zarządzaj certyfikatami SSL/TLS dla domeny',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Wybierz domenę, której certyfikatem SSL/TLs chcesz zarządzać.',

    'ui__client/to-reseller_multi__wizard-title' => 'Konwertuj konto klienta na konto sprzedawcy',
    'ui__client/to-reseller_multi__wizard__1_multi' => 'Wybierz konta klienckie, które chcesz przekonwertować na konta sprzedawcy.',

    'ui__reseller/to-client_multi__wizard-title' => 'Przekształć konta sprzedawców na konta klientów',
    'ui__reseller/to-client_multi__wizard__1_multi' => 'Wybierz konta sprzedawców które chcesz przekonwertować do kont klienckich.',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => 'Określ ustawienia hostingu dla tej domeny.',







    'ui__client/domain/disable_multi__wizard-title' => 'Zawieś Domeny',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Wybierz domeny które chcesz zawiesić.',

    'ui__client/domain/enable_multi__wizard-title' => 'Przywróć domeny',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Wybierz domeny, które chcesz przywrócić.',

    'ui__client/domain_unknown__wizard-title' => 'Pokaż domeny',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Wybierz klientów których domeny chcesz zobaczyć.',

    'ui__client/domain/to-client_multi__wizard-title' => 'Przekształć konta administratorów domen na konta klientów',
    'ui__client/domain/to-client_multi__wizard__2_multi' => 'Wybierz domeny, których konta administratora chcesz przekonwertować do kont klienckich',

    'ui__client/domain/register_unknown__wizard-title' => 'Zarejestruj domeny',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Wybierz domenę, którą chcesz zarejestrować.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Użyj narzędzi z MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Wybierz domeny, którymi chcesz zarządzać przy pomocy narzędzi z MyPlesk.com.',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => 'Dostęp do serwera poprzez SSH', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => 'Wybierz domenę do której wirtualnego hosta chcesz się połączyć przez SSH.', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Użytkownicy adresów IP',
    'ui__server/ip-address/client_unknown__title' => 'Użytkownicy adresów IP',
    'ui__server/ip-address/client_unknown__description' => 'Użytkownicy adresu IP %1',

    'disabled_by_admin' => 'Wyłączone przez administratora serwera',






    'ui__client/domain/chowner_multi__short-title' => 'Zmień właściciela',
    'ui__client/domain/chowner_multi__title' => 'Zmień właściciela domeny',
    'ui__client/domain/chowner_multi__description' => 'Zmień właściciela domeny.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Zaznacz domenę której chcesz zmienić właściciela i kliknij Dalej >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Zmień właściciela',
    'ui__client/domain/chowner_unknown__title' => 'Zmień właściciela domeny',
    'ui__client/domain/chowner_unknown__description' => 'Zmień właściciela domeny.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Zmień właściciela domeny',


    'ui__client/chowner__short-title' => 'Zmień właściciela klienta',
    'ui__client/chowner__title' => 'Zmień właściciela konta klienta',
    'ui__client/chowner__description' => 'Przypisz nowego właściciela do tego konta klienta',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Brak własnych przycisków.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Nie ma spersonalizowanych przycisków w interfejsie sprzedawcy %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Usuń przycisk %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Usuń',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Usuń przycisk %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Usuń spersonalizowane przyciski z interfejsu sprzedawcy',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Usuń',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Usuń własne przyciski',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Usuń przyciski',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Wybierz sprzedawcy którego własne przyciski chcesz usunąć i kliknij Dalej',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Wybierz przyciski które chcesz usunąć i kliknij Dalej >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Potwierdź usunięcie przycisków poprzez zaznaczenie checkbox\'u, i kliknij Zakończ.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Usuń spersonalizowany przycisk z interfejsu sprzedawcy.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Usuń',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Usuń przycisk dowolny',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Usuń przycisk dowolny',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Wybierz sprzedawcy którego własny przycisk chcesz usunąć i kliknij Dalej',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Wybierz własny przycisk który chcesz usunąć i kliknij Dalej >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Potwierdź usunięcie dowolnego przycisku poprzez zaznaczenie pola typu check box na tym ekranie a potem naciśnij Zakończ.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Edytuj właściwości przycisku poziom sprzedawcy %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Ustawienia',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Zmień dowolny przycisk %1 sprzedawcy',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Dodaj dowolny przycisk',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Wybierz sprzedawcę, w którego interfejsie chcesz utworzyć spersonalizowany przycisk i kliknij Dalej >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Kliknij Zakończ aby utworzyć przycisk.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Zmień właściwości przycisku w interfejsie sprzedawcy.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Właściwości',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Zmień właściwości przycisku w interfejsie sprzedawcy',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Zmień właściwości dowolnego przycisku',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Wybierz sprzedawcy którego własne przyciski chcesz zmodyfikować i kliknij Dalej',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Wybierz, który własny przycisk chcesz zmodyfikować i kliknij Następna >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Kiedy skończysz edytować właściwości przycisku, kliknij zakończ aby wprowadzić zmiany i opuścić kreatora.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Uczyń przycisk %1 niedostępnym dla ywoich klientów.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Ukryj przed użytkownikiem',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Uczyń przycisk %1 niedostępnym dla toich klientów',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Uczyń przycisk %1 widocznym dla klientów sprzedawców.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Udostępnij użytkownikom',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Uczyń przycisk %1 widocznym dla klientów sprzedawców',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Włącz / wyłącz dowolny przycisk Twoim klientom.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostępne/niedostępne dla Twoich klientów',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Włącz / wyłącz dowolny przycisk Twoim klientom',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Włącz / wyłącz dowolny przycisk Twoim klientom.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Wybierz sprzedawcy którego własny przycisk chcesz udostępnić jego klientom i kliknij Dalej',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Wybierz własny przycisk który chcesz uczynić dostępnym lub niedostępnym dla swoich klientów i kliknij Dalej >>.',




    'ui__server/ip-addresses__short-title' => 'Adresy IP',
    'ui__server/ip-addresses__title' => 'Zarzšdzaj adresami IP',
    'ui__server/ip-addresses__description' => 'Dodaj i usuń adresy IP z interfejsu sieci.',

    'ip_ctrl__allow_ftps' => 'Zezwalaj na FTP poprzez SSL/TLS',
    '__ftps' => 'FTP poprzez SSL/TLS',
    '__not_allowed' => 'Niedozwolone',



    'ui__client/ipaddress/domain_unknown__short-title' => 'Domeny używające %2',
    'ui__client/ipaddress/domain_unknown__title' => 'Domeny, które używają %1 adresów IP %2',
    'ui__client/ipaddress/domain_unknown__description' => 'Zobacz listę domen, które używają %1 adresów IP %2',

    'ui__client/ipaddress__none-available' => 'Brak dostępnych adresów IP',
    'ui__client/ipaddress__none-available__1' => 'Brak dostępnych adresów IP',



    'ui__client/domain/report_unknown__wizard-title' => 'Pokaż raport domeny',
    'ui__client/domain/report_unknown__wizard__2_unknown' => 'Wybierz raport domeny który chcesz zobaczyć.',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Wybierz nowego właściciela domeny.',

    'ui__client/chowner__wizard__2_select' => 'Wybierz nowego właściciela konta klienckiego.',

    '__ip_addr_state_unknown' => "Adres IP nie działa teraz ponieważ system ciągle przetwarza Twoje żądanie. Proszę poczekać minutę.",


    'resellers_list__accounts' => 'Użytkownicy',

    'ip_addr__repair_is_not_allowed' => 'Adres IP nie może być naprawiony na środowisku Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Sprzedawca %1 nie posiada klient.',

    'ippoolManager__ip_used_by_nohost_domain' => "Nie można usunąć adresu IP %%ip%%, ponieważ jest używany przez co najmniej jedną domenę bez hostingu.",
    'ippoolManager__ip_used_for_mail_service' => "Adres IP %%ip%% nie może zostać usunięty, ponieważ jest używany przez co najmniej jedną domenę jako adres IP ich usługi pocztowej.",
    'ippoolManager__ip_used_for_send_emails' => "Adres IP %%ip%% nie może zostać usunięty, ponieważ jest używany do wysyłania wiadomości e-mail z określonego adresu IP (zobacz ustawienia serwera poczty).",
    'ippoolManager__ip_used_in_dns_zone' => 'Adres IP %%ip%% nie może być usunięty ponieważ jest używany przez strefę DNS jednej lub więcej domen.',
    'ip_ctrl__cannot_manage_on_vz' => 'Ta instalacja Plesk działa pod Virtuozzo containers. Nowy adres IP może zostać dodany jedynie przez administratora węzła Virtuozzo containers.',

    'client_template__limits_auto_adjusted' => 'Limity ze wzorca klienta zostały automatycznie dostosowane.',

    '__entries' => 'Wpisy',

    '__path_is_not_set' => 'Ścieżka nie została określona. Proszę o wskazanie prawidłowej ścieżki.',

    // license keys
    'key_new_plesk_key_is_uploaded' => 'Nowy klucz Plesk został załadowany.',
    'key_new_additional_key_is_uploaded' => 'Nowy klucz dodatkowy został załadowany.',

    'defaultcomponents__imap_required' => '(serwer e-mailowy nie obsługuje IMAP)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => 'Ochrona przed hotlinkowaniem jest włączona dla tej domeny.',
    'i_hotlinkprotection_off' => 'Ochrona przed hotlinkowaniem jest wyłączona dla tej domeny.',

    '__commercial_web_stats_not_installed' => 'Plesk obsługuje tylko komercyjne oprogramowanie do statystyk sieci dla kalkulowania statystyk poddomeny. Żadne takie oprogramowanie nie jest obecnie zainstalowane w systemie.',

    'mail__spamassassin_personal_settings_disallowed' => 'Możliwoć zastosowania osobistych ustawień filtra antyspamowego jest wyłšczona przez administratora. Okrelone poniżej ustawienia filtracji nie zostanš zastosowane',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => 'Nie udało się stworzyć %1 obiektu: %2',
    'cu_dom_pref__invalid_expiration_date' => 'Niewłaciwa data wygaszenia: %1',
    'cu_cl_pref__illegal_date_val' => 'Została wprowadzona niedozwolona wartoć daty ("%1")',
    'cu_cl_pref__illegal_date_greater_less' => 'Wprowad rok z zakresu od: "%1" do "%2"',
    'cu_initconf__unable_set_ip_alias_type' => 'Brak możliwoci ustawienia typu aliasu IP: %1',
    'cu_mlist__unable_change_status' => "Nie można zmienić statusu listy mailingowej: %1",
    'cu_initconf__unable_change_passwd' => "Brak możliwoci zmiany hasła administratora: %1",
    'cu_serverpref__option_description_include_remote_databases' => 'Zawiera zdalne bazy danych MySQL w obliczeniu użycia przestrzeni dyskowej.',
    'cu_siteapp_item__add_to_pool_success' => 'Aplikacja webowa została dodana do puli aplikacji webowych.',
    'cu_siteapp_item__remove_from_pool_success' => 'Aplikacja webowa została usunięta z puli aplikacji webowych.',
    'cu_traffic_command_description_add_user' => 'Rejestruj specyficznš iloć ruchu jaka by już była zużyta przez klienta/sprzedawcę',
    'cu_traffic_command_description_sub_user' => 'Odejmuje okrelonš iloć transferu od transferu zarejestrowanego dla tego klienta/sprzedawcę',
    'cu_traffic_command_description_add_batch_user' => 'Rejestruj specyficznš iloć ruchu tak jakby już była zużyta przez klienta/sprzedawcę (batch mode)',
    'cu_traffic_command_description_del_user' => 'Zeruje wartoć zarejestrowanego zużytego transferu dla tego użytkownika',
    'cu_resellerpref__option_lock_screen' => 'Nie pozwala użytkownikom na pracę z Pleskiem, dopóki ekrany interfejsu nie będš załadowane',
];