<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => 'This feature is not currently available.',
    'b_disabled_by_key' => 'This feature is not supported by the license key.',
    'b_disabled_by_permissions' => 'You do not have permission to perform backup operations.',
    'b_accept' => "You should agree to the terms of this license agreement in order to use {$PROD_NAME}.",
    'b_action_log' => 'Action log configuration.',
    'b_add_ip' => "Add IP addresses to client's IP pool.",
    'b_database_server_add' => 'Add a database server.',
    'b_adm_skeleton' => 'Manage virtual host template.',

    'b_autoinstaller_install' => 'Install the selected components.',

    'b_autoinstallerreleaseslist_search' => 'Enter a search pattern and click to find releases.',
    'b_autoinstallerreleaseslist_show_all' => 'Show all releases.',

    'b_autoinstallercomponentslist_search' => 'Enter a search pattern and click to find components.',
    'b_autoinstallercomponentslist_show_all' => 'Show all components.',
    'b_auto-updates' => "Update Plesk or its components.",

    'b_blocked_domains' => 'Manage black list.',
    'b_blocked_domain_add' => 'Click to add a domain to the black list.',
    'b_codepage_change' => 'Click to change the encoding.',
    'b_configure_maillists' => 'Mailing list postinstall configuration.',
    'b_configure_odbc' => 'ODBC DSN configuration.',
    'b_crontablist_cancel' => 'Cancel task removal.',
    'b_crontablist_show_all' => 'Show all tasks.',
    'b_clienttrafficlist_search' => 'Enter a search pattern and click to find domains.',
    'b_clienttrafficlist_show_all' => 'Show all domains.',
    'b_comp_info' => 'Information on components.',
    'b_decline' => "Declining this license you will not be able to use {$PROD_NAME}.",
    'b_dumps_list' => 'Access the backup and restoration functions and manage backup files storage.',
    'b_dumps_list_disabled' => 'The service is not available because the backup utilities were not installed.',
    'b_add_services' => 'Additional services management page.',
    'b_add_ip_for_clients' => "Add an owner for this IP address.",
    'b_anonymous_ftp' => 'Set up Anonymous FTP for the domain.',
    'b_attach_add' => 'Add attached file.',
    'b_attach_remove' => 'Remove attached file.',
    'b_backup_ok' => 'Backing up was finished. Click to go to the backup files storage.',
    'b_restore_ok' => 'Restoring was finished. Click to go to the backup files storage.',
    'b_cancel' => 'Discard any changes and return to the previous page.',
    'b_card' => 'Edit personal information.',
    'b_clean_log' => 'Clear log.',
    'b_cl_skeleton' => 'Manage virtual host template.',
    'b_dashboard' => 'Go to Home page.',
    'b_dashboard_shortcut_remove' => 'Remove the shortcut from Home page.',
    'b_domain_restore' => 'Restore the domain from this backup file.',
    'b_domain_user' => 'Allow and configure domain administrator\'s access.',
    'b_do_backup' => 'Back up the domain. During this procedure the domain management functions in the Customer Panel will not be accessible.',
    'b_do_upload' => 'Upload dump to storage.',
    'b_backup_configure' => 'Backup manager configuration.',
    'b_domain_alias_add' => 'Set up an additional domain name for your website.',
    'b_domain_aliases_limit_reached' => 'The limit on the number of domain aliases was reached.',
    'b_create_client_back' => 'Discard the suggested parameters and return to the previous page.',
    'b_create_client_update' => 'Apply the suggested parameters and proceed with customer creation.',
    'b_create_domain_back' => 'Discard the suggested parameters and return to the previous page.',
    'b_create_domain_update' => 'Apply the suggested parameters and proceed with domain creation.',
    'b_create_domain_client_select' => 'Select the customer and click OK to create the domain.',
    'b_crontab_unix' => 'Manage scheduler tasks.',
    'b_crontab_win' => 'Manage scheduler tasks.',
    'b_crontab_unix_turn_on' => 'Click to switch on the scheduled task.',
    'b_crontab_win_turn_on' => 'Click to switch on the scheduled task.',
    'b_crontab_unix_turn_off' => 'Click to suspend the scheduled task.',
    'b_crontab_win_turn_off' => 'Click to suspend the scheduled task.',
    'b_extcert_send_file' => 'Upload previously purchased certificate from the specified file.',
    'b_extras_admin' => 'Additional server tools.',
    'b_extras_client' => 'Additional domain tools.',
    'b_cl_ed' => "Click to edit customer's information.",
    'b_cl_ed_update' => "Click to update customer's information.",
    'b_cl_limits' => 'View or define customer account limits.',
    'b_cl_new' => 'Click to create a customer account.',
    'b_cl_new_update' => 'Click to create the customer account.',
    'b_cl_not_cr_dom' => 'The customer is not allowed to create domains.',
    'b_cl_on' => "Activate customer account and all customer's websites.",
    'b_cl_off' => "Suspend customer account and all customer's websites.",
    'b_cl_permissions' => 'View or set permissions for the resources allocated to the customer.',
    'b_cl_pref_up_level' => "Click to return to the customer's settings page without updating.",
    'b_cl_pool_update' => 'Click to add IP address.',
    'b_cl_pool_add_no_ips' => "There are no vacant IP addresses to add.",
    'b_default_db_user' => "Use the selected database user's credentials to log in to the database administration interface.",
    'b_edit_tpl__add_ip' => 'Click to add IP addresses.',
    'b_edit_tpl__cancel_ip' => 'Click to cancel.',
    'b_icf' => 'Set up firewall.',
    'b_ip_clients__add' => 'Click to add.',
    'b_ip_clients__cancel' => 'Click to cancel.',
    'b_client_templates' => 'Customer templates management.',
    'b_create_login' => 'Click to create a MyPlesk.com account.',
    'b_skins_managment' => 'Click to manage skins.',
    'b_skin_add' => 'Upload a new skin to Plesk.',
    'b_skin_manual' => "Open a user's manual on creating custom Plesk skins.",
    'b_skin_manual_not_installed' => "User's manual on creating custom Plesk skins is not installed.",
    'b_skin_download' => 'Click to download skin.',
    'b_skin_replace' => 'Click to replace the current skin with the new one.',
    'b_spamassassin' => 'SpamAssassin server configuration.',
    'b_schedulertaskslist_search' => 'Enter a search pattern and click the button to search in the tasks.',
    'b_schedulertaskslist_remove' => 'Remove selected tasks.',
    'b_schedulertaskslist_cancel' => 'Cancel tasks removal.',
    'b_schedulertaskslist_show_all' => 'Show all tasks.',

    'b_sshterm' => 'Open the terminal client to access your account at Plesk server over the secure shell.',
    'b_sshterm__no_vrt_hst' => 'In order to use the terminal client, you should set up physical hosting for this domain.',
    'b_sshterm__empty_shell' => 'The terminal client is not available because access to the server shell is not provided with this service plan.',
    'b_sshterm__not_installed' => 'SSHTerminal is not installed.',
    'b_subdom_update' => 'Click to submit the settings.',
    'b_subdom_create' => 'Click to create the subdomain.',
    'b_switch_user' => 'Log in under another account.',
    'b_clients' => 'Manage client accounts.',
    'b_client_traffic' => "Client's traffic.",
    'b_change_passwd' => "Click to change administrator's password.",
    'b_change_cert_name' => 'Change the certificate name.',
    'b_databases' => 'Create and manage databases and database users.',
    'b_databases__change_server_passwd' => 'Click to go to the page of changing password.',
    'b_default_skel' => 'Restore the default virtual host template.',
    'b_directories' => 'Create SSL/TLS or Non-SSL/TLS password-protected directories.',
    'b_db_access' => "Set up database administrator's credentials.",
    'b_pgsql_access' => "Set up PostgreSQL administrator's credentials.",
    'b_pgsql_not_access' => 'PostgreSQL is not installed.',
    'b_db_add' => 'Add a database.',
    'b_db_add__lim' => 'You cannot add databases to this domain: the limit on the number of databases is reached.',
    'b_db_add_update' => 'Enter new database name and click to add.',
    'b_db_del' => 'Remove database.',
    'b_db_admin_not_installed' => 'Webadmin is not installed. Contact your hosting service provider for assistance.',
    'b_db_no_default_user' => 'Unable to access Webadmin: the default Webadmin user is not specified.',
    'b_db_dbserver_not_configured' => 'Unable to access Webadmin: the database server is not configured.',
    'b_db_usr_add' => 'Add a database user.',
    'b_db_user_del' => 'Remove the database user.',
    'b_db_usr_update' => 'Change password.',
    'b_db_rm_submit' => 'Delete the selected databases.',
    'b_db_not_started' => 'The database server is not started',
    'b_db_not_configured' => 'The database server is not configured',
    'b_db_not_installed' => 'The database server is not installed',
    'b_default_text' => 'Set up default notification text.',
    'b_du_rm_submit' => 'Delete the database users.',
    'b_dns' => 'Administer DNS settings for the domain.',
    'b_dns_soa_set' => 'Apply all changes.',
    'b_dns_acl_add' => 'Click to add IP address or subnet mask.',
    'b_dns_rec_del' => 'Remove this record from DNS zone.', //to remove
    'b_dns_rec_new' => 'Select a new record type and click to add.', //to remove
    'b_dnsrecord_add' => 'Click to add a resource record to DNS zone',
    'b_dns_soa' => 'Click to configure SOA settings',
    'b_dns_soa_default' => 'Click to restore the default SOA settings.',
    'b_dns_default' => 'Click to restore the DNS zone.',
    'b_dns_t_new_rec' => 'Click to add a resource record to DNS zone template.',
    'b_dns_t_default' => 'Click to restore the default DNS zone template configuration.',

    'b_dns_master_add' => 'Add DNS master server.', //to remove
    'b_dns_new_ns' => 'Add nameserver.', //to remove
    'b_dns_on' => 'Switch on local DNS service for the zone.',
    'b_dns_off' => 'Switch off local DNS service for the zone.',
    'b_dns_t_on' => 'Switch on local DNS service for all newly hosted sites.',
    'b_dns_t_off' => 'Switch off local DNS service for all newly hosted sites.',
    'b_dns_not_perm' => 'You do not have permissions to manage DNS zone for this domain.',
    'b_dns_zone_sync' => 'Apply the template changes to existing DNS zones.',

    'b_dns_template' => 'DNS template settings.', //to remove
    'b_dns_template_rec_del' => 'Remove the record from the DNS template.', //to remove
    'b_dns_template_rec_new' => 'Select a new DNS record type and click to add.', //to remove
    'b_dns_template_restore_default' => 'Replace the current DNS zone template with the standard one.', //to remove
    'b_dns_restore_default' => 'Select an IP address and click to restore the DNS zone.', //to remove
    'b_dns_rm_submit' => 'Click to delete the DNS records.', //to remove
    'b_dom_deact' => 'Not available for suspended domains.',
    'b_dom_del' => 'Delete all domain information.',
    'b_log_manager' => 'Manage log files and log processing options.',
    'b_dom_new' => 'Click to create a domain.',
    'b_dom_new_no_clients' => 'Unable to create a domain. You have no client accounts.',
    'b_dom_new_update' => 'Click to create a domain.',
    'b_dom_on' => 'Turn the domain on.',
    'b_dom_off' => 'Turn the domain off.',
    'b_dom_pref' => 'Set up settings for the domain.',
    'b_dom_limits' => 'View or set up limits for the domain.',
    'b_domain_traffic' => 'Domain traffic.',
    'b_dom_reg' => 'Register this domain.',
    'b_dom_usr_del' => 'Delete domain level user access.',
    'b_doms_mng' => 'Manage the domains registered through Plesk.',
    'b_doms_reg' => 'Register a domain.',
    'b_report' => 'View report.',
    'b_report_auto' => 'Manage the report delivery schedule.',
    'b_report_auto_new' => 'Add a report delivery schedule.',
    'b_reportautolist_search' => 'Enter a search pattern and click to find the report delivery schedules.',
    'b_reportautolist_show_all' => 'Show all report delivery schedules.',
    'b_reportautolist_remove' => 'Delete the selected report delivery schedules.',
    'b_report_saem' => 'Send the status report to the specified address.',
    'b_domains' => 'Manage domains.',
    'b_domain_templates' => 'Create, edit and delete domain templates.',
    'b_download_log' => 'Download the log file to the local machine.',
    'b_dumps_rm_submit' => 'Click to delete the backup files.',
    'b_edit_adm' => 'Click to edit administrator information.',
    'b_filemanager_apply_win_perm' => 'Click to submit the changes made.',
    'b_filemanager_cancel_win_perm' => 'Click to return to the previous page without saving changes.',
    'b_filemanager__chmod_update' => 'Click to submit the changes.',
    'b_filemanager__rename_update' => 'Click to submit the changes.',
    'b_filemanager__new_dir' => 'Click to create a directory.',
    'b_filemanager__count_size' => 'Click to calculate the total size of the selected objects.',
    'b_filemanager__pack' => 'Add the selected files to archive.',
    'b_domaintrafficlist_search' => 'Enter a search pattern and click to find services.',
    'b_domaintrafficlist_show_all' => 'Show all services.',
    'b_custom_buttons' => 'Custom buttons management.',
    'b_custom_button_add' => 'Click to add a custom button.',
    'b_custom_buttons_rm_submit' => 'Click to remove the selected custom buttons.',
    'b_hide_aliases' => 'Hide aliases.',
    'b_hide_domainaliases' => 'Hide domain aliases.',
    'b_hide_subdomains' => 'Hide subdomains.',
    'b_home' => 'Return to the home page.',
    'b_hosting' => 'Administer and set up web hosting for the domain.',
    'b_hst_del' => 'Delete the current hosting configuration.',
    'b_hst_not_set' => 'Hosting is not set up.',
    'b_hst_wo_ip' => 'Hosting is not ip-based.',
    'b_hst_wo_ip_or_not_ssl' => 'Hosting is not ip-based or SSL/TLS support is not activated.',
    'b_not_phys_hst' => 'Hosting is not physical.',
    'b_web_stat_not_set' => "Web statistics are not kept. If you want to keep statistics, go to hosting account properties (Domains > domain name > Setup > Web statistics menu) and select the statistics program you need.",
    'b_white_list' => 'Manage white list.',
    'b_white_list_add' => 'Add a domain to the white list.',
    'b_hst_sel_next' => 'Set up the selected hosting type.',
    'b_hst_update' => 'Apply all changes.',
    'b_int_ip_del' => 'Select IP addresses from the list and click to remove them from the interface.',
    'b_ip_new' => 'Click to add an IP address.',
    'b_ip_new_virtuozzo' => 'Unable to add an IP address in Virtuozzo containers.',
    'b_ip_new_lycos' => 'Unable to add an IP address in Lycos.',
    'b_ip_aliasing' => 'Manage IP addresses on the server.',
    'b_ip_del' => 'Select IP addresses/masks from the list and click to remove.',
    'b_ip_rm_submit' => 'Click to delete IP addresses.',
    'b_ip_cl_rm_submit' => 'Click to remove the IP address from the IP pool.',
    'b_ip_pool' => "Management of customer's IP pool.",
    'b_language' => 'Set up interface language.',
    'b_login' => 'Log in to Plesk.',
    'b_login_vzpp' => 'Click to access VZPP.',
    'b_logo' => 'Manage logo displayed in the top interface area.',
    'b_logo_default' => 'Click to restore the default logo.',
    'b_logo_send_file' => 'Enter new logo filename and click to upload.',
    'b_logo_send_link' => 'Enter new logo link and click to attach.',
    'b_logo_send_logo' => 'Enter new logo file name and click to upload.',
    'b_log_rm_submit' => 'Click to delete log files.',
    'b_ma_rm_submit' => 'Click to delete mail aliases.',

    'b_odbc' => 'Manage ODBC DSN connections.',

    'b_mail' => 'Configure server-wide mail system settings.',
    'b_mail_disabled_by_admin' => 'The mail service for this domain is switched off by server administrator.',

    'b_mail_resp_on' => 'Activate the auto-reply.',
    'b_mail_resp_off' => 'Deactivate the auto-reply.',
    'b_mail_resp_add' => 'Create an auto-reply.',
    'b_mail_resp_files' => 'Manage attachments repository.',
    'b_mail_resp_files_no_mailbox' => 'This feature is not currently available because you did not set up a mailbox under this mail account.',
    'b_mail_resp_upload' => 'Upload file to the attachments repository.',
    'b_mail_resp_attach_add' => 'Create an attachment.',

    'b_mail_name_new' => 'Click to create a mail account.',
    'b_mail_names' => 'Manage mail services: POP3 mailboxes, forwarders, groups, and auto-replies.',
    'b_mail_name_resp_attach_selected' => 'Click to attach the selected files to the auto-reply.',

    'b_mail_on' => 'Activate mail services for this domain.',
    'b_mail_off' => 'Deactivate mail services for this domain.',
    'b_mail_preferences' => 'Configure mail reception settings for non-existent users.',

    'b_mimetypes' => 'Manage MIME types.',
    'b_mimetype_new' => 'Add a MIME Type.',

    'b_mimetypeslist_remove' => 'Delete the selected MIME types.',
    'b_mimetypeslist_search' => 'Enter a search pattern and click to find MIME types.',
    'b_mimetypeslist_show_all' => 'Show all MIME types.',

    'b_mn_alias_new' => 'Add a mail alias.',
    'b_mn_mail_group' => 'Manage mail group.',
    'b_mn_mailbox' => 'Manage mailbox.',
    'b_mn_preferences' => 'Configure mail account.',
    'b_mn_responders' => 'Manage auto-replies.',
    'b_mn_resp_rm_submit' => 'Delete auto-replies.',
    'b_mn_redir_rm_submit' => 'Delete mail forwarders.',
    'b_mn_redirect' => 'Manage mail forwarders.',
    'b_mn_files_rm_submit' => 'Click to delete files.',
    'b_mn_attach_rm_submit' => 'Click to delete attachments.',
    'b_mn_groups' => 'Click to manage mail groups.',
    'b_mn_spamfilter_on' => 'Click to manage spam filtering.',
    'b_mn_spamfilter_off' => 'Spam filtering is currently unavailable. To enable spam filtering you need to have the Spam Filter software installed, and support for user-level spam filtering enabled on the Mail box -> Spam Filter page.',
    'b_mn_spamfilter_srv' => 'Administrator has disabled users ability to configure spam filtering.',

    'b_make_dump' => 'Back up the domain.',
    'b_ftp_account_for_dumps_repository' => 'To be able to use an external FTP server for storing the domain backups, you should specify the properties of FTP account used for accessing the server.',
    'b_cron_task_backup' => 'Manage backing up on schedule.',

    'b_mg_mem_del' => 'Select mail group members from the list and click to remove.',
    'b_mg_add' => 'Add the mail account to the selected mail groups.',
    'b_mg_cancel' => 'Click to cancel.',
    'b_mg_del' => 'Remove the mail account from the selected mail groups.',
    'b_mg_mem_new' => 'Click to add a mail group member.',
    'b_mg_turn_on' => 'Click to switch on the mail group.',
    'b_mg_turn_off' => 'Click to switch off the mail group.',
    'b_mg_update' => 'Click to submit changes.',
    'b_mn_rm_submit' => 'Click to delete mail accounts.',
    'b_mn_webmail_on' => 'Click to open webmail.',
    'b_mn_webmail_off' => 'This feature is not currently available because webmail support is not switched on in the mail settings, or mailbox is not activated.',

    'b_modules_manage' => 'Manage modules installed in Plesk and access the functions provided by these modules.',
    'b_notifications' => 'Edit notifications.',
    'b_permissions' => 'View or set permissions for the customer.',
    'b_performance' => 'Manage domain performance.',
    'b_first_page' => 'You are already on the first page.',
    'b_file_manager' => 'Manage your files and directories.',
    'b_anonftp_stats' => 'Anonymous FTP transactions statistics.',
    'b_ftp_stats' => 'FTP server transactions statistics.',
    'b_ftp_stats_disable' => 'Web statistics are not kept, or anonymous FTP service is not turned on, or hosting is not physical.',
    'b_last_page' => 'You are already on the last page.',
    'b_next_page' => 'Go to the next page.',
    'b_prs_rm_submit' => 'Click to delete priorities.',
    'b_preferences' => "Set up interface preferences.",
    'b_prev_page' => 'Go to the previous page.',
    'b_preview' => 'Preview the site prior to DNS propagation.',
    'b_pd_new' => 'Click to create a protected directory.',
    'b_pd_update' => 'Click to update the directory location (Non-SSL/TLS or SSL/TLS) and Header Text.',
    'b_pd_usr_new' => 'Click to add a user.',
    'b_pd_usr_update' => 'Click to change password.',
    'b_pd_users_rm_submit' => 'Click to delete the protected directory users.',
    'b_pd_preferences' => 'Click to change protected directory settings.',
    'b_pd_rm_submit' => 'Click to unprotect the directories and their users.',
    'b_qus_rm_submit' => 'Click to delete priorities.',
    'b_repair_ip' => 'Click to add the IP address.',
    'b_repair_ip_status_ok' => 'This IP address does not need to be repaired.',
    'b_reboot' => 'Reboot the server.',
    'b_refresh' => 'Refresh data on the screen.',
    'b_key_info' => 'View information on license key and upgrade it online.',
    'b_key_upload' => 'Upload and install a new license key.',
    'b_key_download' => 'Download the currently installed license key.',
    'b_key_buyonline_addons' => 'Order Plesk add-ons.',
    'b_key_buyonline_upgrades' => 'Order Plesk upgrades.',
    'b_key_buyonline_new' => 'Order a new license key.',
    'b_key_update' => 'Retrieve the ordered license keys and install them.',
    'b_key_revert' => 'Click to revert to the previously installed license key.',
    'b_quick_search' => 'View the list of items that match the search criteria.',
    'b_remove_ip' => "Select IP addresses from the list and click to remove from customer's IP pool.",
    'b_restart_services' => "Manage {$PROD_NAME} services.",
    'b_rpt_print' => 'Click to get a printer-friendly version of the report.',
    'b_rpt_send_by_email' => 'Click to send this report by email.',
    'b_send_passwd' => 'Click to get password by email.',
    'b_server' => 'Set up server-wide settings.',
    'b_database_servers' => 'Manage database servers.',
    'b_server_pref' => 'System and interface settings.',
    'b_send_skel_file' => 'Upload an archive containing a virtual host template.',
    'b_sessions' => 'Manage sessions.',
    'b_sess_rm_submit' => 'Click to delete sessions.',
    'b_set_time' => 'Set system date and time.',
    'b_set_time_virtuozzo' => 'Unable to change the system date/time in Virtuozzo containers.',
    'b_site_apps' => 'Web applications management.',
    'b_site_apppkgs' => 'Web application packages management.',
    'b_site_apppkgs_pool' => 'Management of web application packages.',
    'b_site_apps_rm_submit' => 'Click to delete the selected web applications.',
    'b_additional_key_is_active' => 'License key is already active.',
    'b_additional_key_activate' => 'Click to activate license key.',
    'b_site_builder' => 'Click to enable integration with Presence Builder.',
    'b_dom_site_builder' => 'Click to open Presence Builder Wizard.',
    'site_builder_no_permission' => 'You do not have permission to use Mambo CMS.',
    'b_site_builder_no_package' => 'Mambo CMS is not installed.',
    'b_site_builder_no_requires' => 'Unable to run Mambo CMS as the hosting requirements are not satisfied.',
    'b_site_builder_no_vrt_hst' => 'To be able to use Mambo CMS, you should set up physical hosting for this domain.',
    'b_site_builder_setup' => 'Run Mambo CMS (if this is the first run - the application will be configured)',
    'b_spam_bayes_clear' => 'Clear the spam filter bayes database.',
    'b_spam_settings_update' => 'Update the spam filter settings.',
    'b_spam_usage_update' => 'Update the usage policy settings.',
    'b_spam_blackmail_new' => 'Add email pattern to the black list.',
    'b_spam_blackmail_remove' => 'Remove email pattern from the black list.',
    'b_spam_whitemail_new' => 'Add email pattern to the white list.',
    'b_spam_whitemail_remove' => 'Remove email pattern from the white list.',
    'b_spam_ignoremail_new' => 'Add email pattern to the ignore list.',
    'b_spam_ignoremail_remove' => 'Remove email pattern from the ignore list.',
    'b_sa_clear_db' => "Clear the spam filter's database.",
    'b_sa_forget' => 'Remove from the spam filter database any information previously learned from the selected messages.',
    'b_sa_learn_as_spam' => 'Learn the selected messages as spam.',
    'b_sa_learn_as_nonspam' => 'Learn the selected messages as non-spam.',
    'b_show_aliases' => 'Show aliases.',
    'b_show_domainaliases' => 'Show domain aliases.',
    'b_show_subdomains' => 'Show subdomains.',
    'b_shutdown' => 'Shut the server down.',
    'b_statistics' => 'Review server statistics.',
    'b_system_time' => 'Manage system date and time.',
    'b_support' => 'File a request for technical support.',
    'b_summary_report' => 'Click to view the summary report.',
    'b_subdom_hosting' => 'Administer and set up web hosting for the subdomain.',
    'b_subdomains' => 'Create and manage subdomains.',
    'b_traffic_history' => 'View traffic history.',
    'b_set_timezone' => 'Click to set the time zone.',
    'b_set_timezone_virtuozzo' => 'Unable to change the timezone in Virtuozzo containers.',
    'b_uninst_submit' => "Click to uninstall {$PROD_NAME}.",
    'b_uninst_cancel' => 'Click to cancel uninstalling.',
    'b_upload_from_ftp' => 'Click to view a list of backups stored on FTP server.',
    'b_ok' => 'Apply all changes.',
    'b_update' => 'Apply all changes.',
    'b_update_db_access' => 'Save the changes made to the database access credentials.',
    'b_updateslist_search' => "Enter a search pattern in the search box and click to find a specific update.",
    'b_updateslist_show_all' => "Show all available updates.",
    'b_updateslist_install' => "Install the selected updates.",
    'b_updtntp' => 'Turn on/off time synchronization with the NTP server.',
    'b_updtntp_virtuozzo' => 'Unable to set up time synchronization with NTP server in Virtuozzo containers.',
    'b_updtpswd' => "Change administrator's password.",
    'b_upload_dump' => 'Upload the backup file to the backup storage.',
    'b_no_dumps_on_ftp' => 'Remote storage is empty.',
    'b_web_stats' => 'Web server transactions statistics.',
    'b_web_stats_disable' => 'Web statistics are not activated or hosting is not physical.',
    'b_web_stats_ssl' => 'Secure web server transactions statistics.',
    'b_web_stats_ssl_disable' => 'Web statistics are not activated or secure web server is not configured or hosting is not physical.',
    'b_web_users' => 'Set up web users for the domain.',
    'b_vhost_app_add' => 'Install web application in the domain.',
    'b_vhost_app_add_no_domains' => 'There are web applications already installed in root directories of these virtual hosts.',
    'b_interface_management' => 'Hide or show various elements of Plesk.',
    'b_virtualdirs' => 'Manage virtual directories.',
    'b_virtualdir_add' => 'Add a virtual directory.',
    'b_zone_switch_master' => 'Switch the DNS zone type to master.',
    'b_zone_switch_slave' => 'Switch the DNS zone type to slave.',

    'b_logrotation_update' => 'Change log rotation settings.',
    'b_logrotation_on' => 'Turn the log rotation on.',
    'b_logrotation_off' => 'Turn the log rotation off.',

    'b_dom_tmpl_add' => 'Create a Domain Template.',
    'b_cl_tmpl_add' => 'Create a Client Template.',
    'b_tmpl_update' => 'Update template properties.',
    'b_tmpl_rm_subm' => 'Click to delete the templates.',

    'b_certificateslist_remove' => 'Delete the selected certificates.',
    'b_certificateslist_search' => 'Enter a search pattern and click to find certificates.',
    'b_certificateslist_show_all' => 'Show all certificates.',

    'b_certfileslist_download' => 'Download all certificate components.',

    'b_clientslist_remove' => 'Delete the accounts and domains of the selected customers.',
    'b_clientslist_search' => 'Enter a search pattern and click to find customers.',
    'b_clientslist_show_all' => 'Show all customers.',

    'b_componetslist_search' => 'Enter a search pattern and click to find components.',
    'b_componetslist_show_all' => 'Show all componets.',

    'b_defaultcomponents' => 'Third-party Services selection.',
    'b_defaultcomponents__update' => 'Confirm the selection and proceed with setting third-party services.',
    'b_defaultcomponents__cancel' => 'Discard any changes and return to the previous page.',

    'b_domainslist_remove' => 'Delete the selected domains.',
    'b_domainslist_search' => 'Enter a search pattern and click to find domains.',
    'b_domainslist_show_all' => 'Show all domains.',

    'b_sysuserslist_search' => 'Enter a search pattern and click to find system users.',
    'b_sysuserslist_show_all' => 'Show all system users.',

    'b_dnszonelist_remove' => 'Delete the selected DNS records.',
    'b_dnszonelist_search' => 'Enter a search pattern and click to find DNS records.',
    'b_dnszonelist_show_all' => 'Show all DNS records.',

    'b_dnszonetemplatelist_remove' => 'Delete the selected DNS template records.',
    'b_dnszonetemplatelist_search' => 'Enter a search pattern and click to find DNS template records.',
    'b_dnszonetemplatelist_show_all' => 'Show all DNS template records.',

    'b_dnsnslist_remove' => 'Delete the selected name servers.',
    'b_dnsnslist_search' => 'Enter a search pattern and click to find name servers.',
    'b_dnsnslist_show_all' => 'Show all name servers.',

    'b_dnsmasterslist_remove' => 'Delete the selected DNS master servers.',
    'b_dnsmasterslist_search' => 'Enter a search pattern and click to find DNS master servers.',
    'b_dnsmasterslist_show_all' => 'Show all DNS master servers.',

    'b_domainsumreplist_search' => 'Enter a search pattern and click to search for a domain.',
    'b_domainsumreplist_show_all' => 'Show all domains.',

    'b_filelist_remove' => 'Delete the selected files or directories.',
    'b_filelist_search' => 'Enter a search pattern and click to find files and directories.',
    'b_filelist_show_all' => 'Show all files and directories.',

    'b_filemanager__copy_move' => 'Select one or several files or directories and click to copy or move to another directory.',
    'b_filemanager__touch_files' => 'Select one or several files or directories and click to change the timestamp.',
    'b_filemanager__upload_file' => 'Enter the path to file and click to upload it to the current directory.',
    'b_filemanager__create_dir' => 'Enter the directory name and click to create it in the current directory.',
    'b_filemanager__edit_reset' => 'Restore the original file contents.',
    'b_filemanager__edit_save' => 'Save all changes.',
    'b_filemanager__edit_save_exit' => 'Save all changes and return to the list of files.',
    'b_filemanager__remove_submit' => 'Confirm removal and click to remove the selected files.',
    'b_filemanager__cancel' => 'Discard any changes and return to the previous page.',

    'i_filemanager__type_pdir' => 'Go to the directory one level up.',
    'i_filemanager__type_dir' => 'Go inside the directory.',
    'i_filemanager__type_text' => 'View the file contents.',
    'i_filemanager__type_image' => 'View the image.',
    'i_filemanager__type_audio' => 'Audio file.',
    'i_filemanager__type_security' => 'Apache security file.',
    'i_filemanager__type_webscript' => 'Webscript page file.',
    'i_filemanager__type_wappage' => 'WAP page file.',
    'i_filemanager__type_webpage' => 'Webpage file.',
    'i_filemanager__type_compressed' => 'Compressed file.',
    'i_filemanager__type_unknown_text' => 'Unknown file type (text data).',
    'i_filemanager__type_unknown_binary' => 'Unknown file type (binary data).',

    'i_filemanager__wysiwyg' => 'Edit the file in visual editor.',
    'i_filemanager__wysiwyg_disabled' => 'Editing the file in visual editor requires Internet Explorer version 5.5 or later.',
    'i_filemanager__chmod' => 'Change access rights to the file or directory.',
    'i_filemanager__rename' => 'Change the file or directory name.',
    'i_filemanager__edit' => 'Edit the file.',
    'i_filemanager__show' => 'View the file.',
    'i_filemanager__preview' => 'Open the file in a web browser.',
    'i_filemanager__download' => 'Download the file.',

    'b_custombutton_list_remove' => 'Delete the selected links.',
    'b_custombutton_list_search' => 'Enter a search pattern and click to find links.',
    'b_custombutton_list_show_all' => 'Show all links.',

    'b_mailnameslist_remove' => 'Delete the selected mail accounts.',
    'b_mailnameslist_search' => 'Enter a search pattern and click to find mail accounts.',
    'b_mailnameslist_show_all' => 'Show all mail accounts.',

    'b_mailnameresponderattachmentslist_remove' => 'Delete the selected attachments.',
    'b_mailnameresponderattachmentslist_search' => 'Enter a search pattern and click to find attachments.',
    'b_mailnameresponderattachmentslist_show_all' => 'Show all attachments.',

    'b_mailnameresponderslist_remove' => 'Delete the selected auto-replies.',
    'b_mailnameresponderslist_search' => 'Enter a search pattern and click to find auto-replies.',
    'b_mailnameresponderslist_show_all' => 'Show all auto-replies.',

    'l_mailnameredirectslist_name' => 'Sort forwarders by address.',

    'b_mailnameredirectslist_remove' => 'Delete the selected addresses.',
    'b_mailnameredirectslist_search' => 'Enter a search pattern and click to find addresses.',
    'b_mailnameredirectslist_show_all' => 'Show all addresses.',

    'b_ipdomainslist_default' => 'Set the selected domain as default for this IP address.',
    'b_ipdomainslist_search' => 'Enter a search pattern and click to find domains.',
    'b_ipdomainslist_show_all' => 'Show all domains.',

    'b_ipclientslist_remove' => 'Remove this IP address from IP pools of selected users.',
    'b_ipclientslist_search' => 'Enter a search pattern and click to find users.',
    'b_ipclientslist_show_all' => 'Show all users.',

    'b_locale_add' => 'Click to upload new language pack.',
    'b_locales_managment' => 'Click to manage interface languages.',
    'b_localeslist_remove' => 'Delete the selected language packs.',
    'b_localeslist_search' => 'Enter a search pattern and click to search in the language packs.',
    'b_localeslist_show_all' => 'Show all installed language packs.',

    'b_masterslist_remove' => 'Delete the selected DNS master servers.',
    'b_masterslist_search' => 'Enter a search pattern and click to find the DNS master server.',
    'b_masterslist_show_all' => 'Show all DNS master servers.',

    'b_protecteddirslist_remove' => 'Remove protection from the selected directories.',
    'b_protecteddirslist_search' => 'Enter a search pattern and click to find protected directories.',
    'b_protecteddirslist_show_all' => 'Show all protected directories.',

    'b_protecteddiruserslist_remove' => 'Delete the selected users of protected directory.',
    'b_protecteddiruserslist_search' => 'Enter a search pattern and click to find protected directory users.',
    'b_protecteddiruserslist_show_all' => 'Show all users of this protected directory.',

    'b_skinslist_remove' => 'Delete the selected skins.',
    'b_skinslist_search' => 'Enter a search pattern and click to find skins.',
    'b_skinslist_show_all' => 'Show all skins.',


    'b_virtualdirslist_remove' => 'Delete the selected virtual directories.',
    'b_virtualdirslist_search' => 'Enter a search pattern and click to find virtual directories.',
    'b_virtualdirslist_show_all' => 'Show all virtual directories.',

    'b_ippoollist_remove' => 'Delete the selected IP addresses from pool.',
    'b_ippoollist_search' => 'Enter a search pattern and click to find IP addresses.',
    'b_ippoollist_show_all' => 'Show all IP addresses.',

    'b_ipaddrlist_remove' => 'Remove the selected IP addresses.',
    'b_ipaddrlist_search' => 'Enter the search pattern and click to search.',
    'b_ipaddrlist_show_all' => 'Show all IP addresses.',

    'b_sessionslist_remove' => 'Delete the selected sessions.',
    'b_sessionslist_search' => 'Enter a search pattern and click to find sessions.',
    'b_sessionslist_show_all' => 'Show all sessions.',

    'b_subdom_performance' => 'Manage subdomain performance.',

    'b_logfileslist_remove' => 'Delete the selected log files. You can delete only processed log files.',
    'b_logfileslist_search' => 'Enter a search pattern and click to find log files by filename.',
    'b_logfileslist_show_all' => 'Show all log files.',
    'b_logfileslist_download' => 'Click to download the log file.',

    'b_eventhandlerslist_remove' => 'Delete the selected event handlers.',
    'b_eventhandlerslist_search' => 'Enter a search pattern and click to find event handler.',
    'b_eventhandlerslist_show_all' => 'Show all event handlers.',

    'b_servermailblockeddomainslist_remove' => 'Delete the selected domains from the black list.',
    'b_servermailblockeddomainslist_search' => 'Enter a search pattern and click to find black list entries.',
    'b_servermailblockeddomainslist_show_all' => 'Show all blocked domains.',

    'b_servermailwhitelistlist_remove' => 'Delete the selected entries from the white list.',
    'b_servermailwhitelistlist_search' => 'Enter a search pattern and click to find white list entries.',
    'b_servermailwhitelistlist_show_all' => 'Show all blocked domains.',

    'b_anon_on' => 'Switch on anonymous FTP service for the domain.',
    'b_anon_off' => 'Switch off anonymous FTP service for the domain.',

    'b_maillists' => 'Click to manage mailing lists.',
    'b_maillist_new' => 'Click to create mailing list.',
    'b_maillist_edit' => 'Click to access the mailing list administration functions.',
    'b_maillist_turn_on_off' => 'Click to change the mailing list status.',
    'b_maillists_on' => 'Activate the mailing lists service.',
    'b_maillists_off' => 'Deactivate the mailing lists service.',
    'b_maillist_off_disabled' => 'Disabling mailing lists is not supported by the current mail server.',
    'b_maillists_invert_on_off' => 'Click to change the state of the selected mailing lists.',

    'b_rpt_customize' => 'Click to customize the report layouts.',
    'b_rpt_add' => 'Click to create a report layout.',
    'b_rpt_rm_submit' => 'Click to delete report layouts.',

    'b_clientreportslist_remove' => 'Delete the selected report layouts.',
    'b_clientreportslist_search' => 'Enter a search pattern and click to find reports.',
    'b_clientreportslist_show_all' => 'Show all reports.',

    'b_domainreportslist_remove' => 'Delete the selected report layouts.',
    'b_domainreportslist_search' => 'Enter a search pattern and click to find reports.',
    'b_domainreportslist_show_all' => 'Show all reports.',

    'b_odbc_dsn_add' => 'Add ODBC data source.',
    'b_odbc_new_finish' => 'Complete ODBC data source name configuration.',
    'b_odbc_new_test' => 'Try to connect to the data source with the current parameters.',
    'b_odbc_new_chk' => 'Check the currently defined settings.',
    'b_dsnlist_search' => 'Enter a search pattern and click to find matching data source names.',
    'b_dsnlist_show_all' => 'Show all data source names.',
    'b_dsnlist_remove' => 'Delete the selected data source names.',
    'b_odbc_rm_submit' => 'Delete data source names.',
    'b_remove_cancel' => 'Cancel removing.',
    'b_ftpsessionslist_search' => 'Enter a search pattern and click to find FTP sessions.',
    'b_ftpsessionslist_show_all' => 'Show all FTP sessions.',
    'b_ftpsessionslist_remove' => 'End the selected FTP sessions.',
    'b_dom_performance_edit' => 'Manage the domain performance.',
    'b_dom_performance_readonly' => 'View the domain performance settings.',
    'b_dom_performance_disabled' => 'Feature is unavailable while QoS is not applied to the network device.',
    'b_subdom_performance_disabled' => 'Feature is unavailable while QoS is not applied to the network device.',

    //=============return to up level conhelp =====================

    'b_to_admin' => "Return to managing the Help Desk.",
    'b_to_aliases' => 'Return to mail aliases management page.',
    'b_to_autoinstaller_components' => 'Return to the components selection page.',
    'b_to_autoinstaller_releases' => 'Return to the release selection page.',
    'b_to_custom_buttons' => 'Return to managing custom buttons.',
    'b_to_cl_traffic' => "Return to the customer's traffic page.",
    'b_to_cl_templates' => "Return to the list of customer templates.",
    'b_to_cl_pref' => 'Return to the customer settings.',
    'b_to_comp_info' => "Return to managing Plesk's components.",
    'b_to_dom_rep' => 'Return to the viewing the domain information.',
    'b_to_filemanager' => 'Return to the file manager.',
    'b_to_subdomains' => 'Return to the list of subdomains.',
    'b_to_sessions' => 'Return to sessions.',
    'b_to_databases_db' => "Return to Database administrator's credentials and tools page.",
    'b_to_dumps_list' => 'Return to the domain backup files storage.',
    'b_to_backup_manager' => 'Return to the Backup Management page.',
    'b_to_log_files' => 'Return to the log files list.',
    'b_to_domains' => 'Return to the domains list.',
    'to_domain_aliases' => 'Return to the Domain Aliases page',
    'b_to_clients' => 'Return to the customers list.',
    'b_to_client_home' => "Return to the customer's home page.",
    'b_to_cp_access' => 'Return to the access restriction management page.',
    'b_to_crontab_unix' => 'Return to the Crontab management page.',
    'b_to_crontab_win' => 'Return to the Scheduler management page.',
    'b_to_dns' => 'Return to the DNS zone management.',
    'b_to_dom_ctrl' => 'Return to the domain administration page.',
    'b_to_report_auto' => 'Return to managing the delivery schedules.',
    'b_to_license_management' => 'Return to license information.',
    'b_to_mail' => 'Return to configuring the server-wide mail settings.',
    'b_to_maillists' => 'Return to the mailing lists management.',
    'b_to_maillist_members' => 'Return to managing mailing list subscribers.',
    'b_to_mail_names' => 'Return to managing mail accounts.',
    'b_to_mail_name_responders' => 'Return to managing auto-replies.',
    'b_to_mail_name_resp_edit' => 'Return to editing auto-reply properties.',
    'b_to_mail_name_resp_attach_add' => 'Return to creating a new attachment.',
    'b_to_mail_name_redirects' => 'Return to managing mail forwarders.',
    'b_to_mail_name_files' => 'Return to mail account attachments repository.',
    'b_to_mail_blocked_domains' => 'Return to managing black list entries.',
    'b_to_mail_white_list' => 'Return to managing white list entries.',
    'b_to_mimetypes' => 'Return to managing MIME Types.',
    'b_to_notifications' => 'Return to editing notifications.',
    'b_to_server' => 'Return to the server administration page.',
    'b_to_spamassassin' => 'Return to the spamfilter configuration.',
    'b_to_skins' => 'Return to managing skins.',
    'b_to_skin_info' => 'Return to viewing skin properties.',
    'b_to_scheduler' => 'Return to the Scheduler Management page.',
    'b_to_subdom_ctrl' => 'Return to the Subdomain Administration page.',
    'b_to_prtdir_edit' => 'Return to the password-protected directory management page.',
    'b_to_prtd_dirs' => 'Return to the list of password-protected directories.',
    'b_to_prs' => 'Return to priorities.',
    'b_to_responders' => 'Return to managing auto-replies.',
    'b_to_virtualdirs' => 'Return to managing Virtual Directories.',
    'b_to_virtualdir_edit' => 'Return to the previous Virtual Directory.',
    'b_to_virtualdir_root' => 'Return to the list of virtual directories.',
    'b_to_web_users' => 'Return to the list of web users.',
    'b_to_cert' => 'Return to certificate management.',
    'b_to_cl_rep' => "Return to client's information.",
    'b_to_report' => 'Return to the report.',
    'b_to_report_list' => 'Return to the custom report layouts.',
    'b_to_db_list' => 'Return to the databases list.',
    'b_to_db_usr_lst' => 'Return to the database users list.',
    'b_to_db_servers' => 'Return to the list of database servers.',
    'b_to_dns_template' => 'Return to the DNS template records list.', //to remove
    'b_to_log_files_list' => 'Return to log files management.',
    'b_to_log_rotation' => 'Return to log rotation settings.',
    'b_to_locales' => 'Return to managing Plesk languages.',
    'b_to_modules' => 'Return to the modules management.',
    'b_to_modules_management' => 'Return to the modules management.',
    'b_to_cl_pool' => 'Return to IP pool management.',
    'b_to_db' => 'Return to databases management.',
    'b_to_db_edit' => 'Return to database users management.',
    'b_to_dom_templates' => 'Return to domain templates management.',
    'b_to_dom_sum_report' => 'Return to domain summary report.',
    'b_to_statistics' => 'Return to traffic statistics.',
    'b_to_odbc' => 'Return to ODBC management.',
    'b_to_ip_aliasing' => 'Return to IP addresses management.',
    'b_to_qus' => 'Return to the list of queues.',
    'b_to_site_apps' => 'Return to the list of web applications.',
    'b_to_site_app_pkgs' => 'Return to the application vault.',
    'b_to_siteapp_install' => 'Return to the web applications installation wizard.',
    'b_to_siteapppackage_info' => 'Return to the web application package properties.',
    'b_to_additional_key_info' => 'Return to the license key properties.',
    'b_to_additional_key_properties' => 'Return to the license key properties.',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'Change default component for this feature.',
    'b_components_configure' => "Set up configuration's parameters for this component.",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'This feature is not available because your license key does not support it or the service is not installed.',
    'i_db_conn_ok' => 'Connection to the database is established.',
    'i_db_conn_att' => 'The database server is not started or incorrect credentials are specified.',
    'i_db_conn_stopped' => 'The database server is not started.',
    'i_db_conn_login_failed' => 'Incorrect credentials were supplied for the database connection.',

    'i_drweb_off' => "Antivirus checking is not enabled for the mail account.",
    'i_drweb_any' => 'Antivirus checking is enabled for outgoing/incoming mail.',
    'i_drweb_from' => 'Antivirus checking is enabled for outgoing mail.',
    'i_drweb_to' => 'Antivirus checking is enabled for incoming mail.',
    'i_drweb_turn_key' => 'Antivirus is not supported by the license key.',
    'i_drweb_turn_perm' => 'You do not have the permission to manage Antivirus.',
    'i_drweb_turn_install' => 'Antivirus is not installed.',
    'i_drweb_turn_pref' => 'Click to manage antivirus settings.',

    'i_client_ok' => 'Resource usage of the client is within limits.',
    'i_cl_ok' => 'Resource usage of the client is within limits.',
    'i_client_!' => 'Resource usage of the client is exceeding limits.',
    'i_cl_!' => "Resource usage of the client is exceeding the limits.",
    'i_client_on' => 'This user account is active.',
    'i_client_off' => 'The user account is suspended.',
    'i_client_off_by_admin' => 'Client account is suspended by administrator.',
    'i_client_off_by_reseller' => 'Client account is suspended by reseller.',
    'i_client_off_with_parent' => "This client account is suspended because its owner was suspended",
    'i_client_off_expired' => 'Client account has expired.',
    'i_reseller_off_expired' => 'Reseller account has expired.',

    'i_client_cp_access_on' => 'Access to the Customer Panel is allowed for the customer.',
    'i_client_cp_access_off' => 'Access to the Customer Panel is not allowed for the customer.',
    'i_click_to_cl_cp_access_on_off' => "Click to allow or prohibit access to the Customer Panel for the customer.",

    'i_custom_errors_del' =>'Click to remove the item from the list.',
    'i_custom_errors_del_disabled' => 'Removing server default custom errors is unavailable.',

    'i_open_subdomain' => 'Click to view the site in the web browser.',
    'i_open_domain' => 'Click to view the site in the web browser.',
    'i_open_domain_disabled' => 'Domain has no hosting configured.',

    'i_dom_ok' => 'Resource usage of this domain is within the allocated limits.',

    'i_dom_tmpl__owner_admin' => 'This template is created by administrator',
    'i_dom_tmpl__owner_client' => 'This template is created by customer.',

    'i_dns_on' => 'This DNS zone is served by the local DNS server.',
    'i_dns_off' => 'This DNS zone is served by an external DNS server.',
    'i_click_to_dom_on_off' => 'Click to activate/deactivate the domain.',
    'i_click_to_cl_on_off' => "Click to activate/deactivate the customer account and customer's domains.",
    'i_dom_!' => 'Resource usage limits are exceeded by this domain.',
    'i_dom_on' => 'Domain is active.',
    'i_dom_off' => 'Domain is inactive.',
    'i_dom_off_by_admin' => 'Domain was suspended by administrator.',
    'i_dom_off_by_reseller' => 'Domain was suspended by reseller.',
    'i_dom_off_by_client' => 'Domain was suspended by client.',
    'i_dom_off_expired' => 'Domain is expired.',
    'i_dom_off_with_parent' => "This user account and user's domain were suspended",
    'i_dom_off_backup_restore' => 'Domain is temporarily suspended for backing up or restoring.',

    'i_locale_active_true' => 'This language is available to Plesk users.',
    'i_locale_active_att' => 'This language got unavailable to users because your limit on the number of allowed languages is exceeded.',
    'i_locale_active_false' => 'This language is not available to users.',
    'i_locale_set_active_true' => 'Click this icon to make the language available to users.',
    'i_locale_set_active_false' => 'Click this icon to make the language unavailable to users.',
    'i_locale_default_locale' => 'This is the default language: you cannot make it unavailable to users.',

    'i_log_rot_enabled' => 'Log rotation is switched on.',
    'i_log_rot_disabled' => 'Log rotation is switched off.',
    'i_log_rot_disabled_by_parent' => 'Log rotation is switched off because the website was switched off.',

    'i_spamfilter_on' => 'Spam filtering is switched on.',
    'i_spamfilter_off' => 'Spam filtering is switched off.',
    'i_spamfilter_turn_srv' => 'The use of individual spam protection settings is not allowed by the server policy.',
    'i_spamfilter_turn_key' => 'SpamAssassin is not supported by the license key.',
    'i_spamfilter_turn_component' => 'SpamAssassin component is not installed.',
    'i_spamfilter_service_off' => 'SpamAssassin service is not running.',
    'i_spamfilter_turn_is_disabled_system_wide' => "Spam protection was switched off by your hosting service provider.",
    'i_spamfilter_turn_permission' => 'You do not have the permission to manage spam filter.',

    'i_additional_key_free' => 'Distributed freely. No license key is required.',
    'i_additional_key_ok' => 'The required license key is installed.',
    'i_additional_key_problem' => 'The required license key is not installed.',
    'i_additional_key_info' => 'Click the icon to access the license key management functions.',
    'i_additional_key_download' => 'Click to download the license key.',

    'i_vcard' => 'Add person to your Address Book.',

    'i_autoinstaller_component_action_error' => 'No updates available.',

    'i_autoinstaller_release_action_upgrade' => 'Upgrading to the new Plesk version.',
    'i_autoinstaller_release_action_update' => 'Updating or adding new components.',
    'i_autoinstaller_release_action_up2date' => 'You have an up-to-date version.',
    'i_autoinstaller_release_action_error' => 'Error retrieving information about the release.',

    'i_autoinstaller_component_action_install' => 'Not installed',
    'i_autoinstaller_component_action_update' => 'Updates are available',
    'i_autoinstaller_component_action_upgrade' => 'Updates are available',
    'i_autoinstaller_component_action_up2date' => 'You have an up to date version',

    'i_mail_resp_on' => 'The auto-reply is switched on.',
    'i_mail_resp_turn_off' => 'Click this icon to turn it off.',
    'i_mail_resp_off' => 'The auto-reply is switched off.',
    'i_mail_resp_turn_on' => 'Click this icon to turn it on.',
    'i_mail_resp_att' => 'All auto-replies are switched off for this mail account.',

    'i_report_auto_on' => 'This report is scheduled for delivery.',
    'i_report_auto_off' => 'This report is not delivered automatically.',
    'i_report_auto_click' => 'Click to manage report delivery schedule.',

    'i_anonftp_on' => 'Anonymous FTP account for the domain is switched on.',
    'i_anonftp_off' => 'Anonymous FTP account for the domain is switched off.',

    'i_sapp_ssl' => 'Web application is installed in SSL/TLS directory.',
    'i_sapp_non_ssl' => 'Web application is installed in Non-SSL/TLS directory.',
    'i_serv_drweb_up_dis' => "Start the service.",
    'i_serv_none' => 'Service is not installed.',
    'i_serv_not_configured' => 'Service is not configured.',
    'i_serv_on' => 'Service is running.',
    'i_serv_off' => 'Service is not running.',
    'i_serv_up' => 'Start the service.',
    'i_serv_up_dis' => 'Service is already running.',
    'i_serv_down' => 'Stop the service.',
    'i_serv_down_dis' => 'Service is already stopped.',
    'i_serv_up_n_down' => 'Restart the service.',
    'i_serv_up_n_down_dis' => 'Service is stopped.',
    'i_serv_key_dsbld_not_inst' => 'This feature is not available because either your license key does not support it or the service is not installed or properly configured.',

    'i_skin_download' => 'Click to download the skin.',

    'i_virtualdirs_read_enabled' => 'Virtual directory Read permission is enabled.',
    'i_virtualdirs_read_disabled' => 'Virtual directory Read permission is disabled.',
    'i_virtualdirs_write_enabled' => 'Virtual directory Write permission is enabled.',
    'i_virtualdirs_write_disabled' => 'Virtual directory Write permission is disabled.',
    'i_virtualdirs_source_enabled' => 'Virtual directory Script source access permission is enabled.',
    'i_virtualdirs_source_disabled' => 'Virtual directory Script source access permission is disabled.',
    'i_virtualdirs_browse_enabled' => 'Virtual directory Directory browsing permission is enabled.',
    'i_virtualdirs_browse_disabled' => 'Virtual directory Directory browsing permission is disabled.',
    'i_virtualdirs_change_status' => 'Click to turn permission On/Off.',

    'webdirs_remove' => 'Remove selected virtual directories.',
    'webdir_preferences' => 'Virtual directory settings.',
    'webdir_protection' => 'Manage protection for this virtual directory.',
    'webdir_mime_types' => 'Manage MIME types for this virtual directory.',
    'webdir_mime_types_remove' => 'Remove selected MIME types.',
    'webdir_mime_type_edit' => 'Set up a MIME type.',
    'webdir_error_docs' => 'Manage error documents for this virtual directory.',
    'webdir_error_doc_edit' => 'Set up an error document for this virtual directory.',

    'b_show_additional_users' => 'Extends the list of users/user\'s groups showing users with non-defined permissions.',
    'b_hide_additional_users' => 'Reduces the list of users/user\'s groups hiding users with non-defined permissions.',

    'i_ip_ok' => 'IP address functions properly.',
    'i_ip_fail' => 'IP address is not present on the interface.',
    'i_ip_sh' => 'Shared IP address.',
    'i_ip_excl' => 'Dedicated IP address.',
    'i_ip_change_type' => 'Click to change type of IP address.',
    'i_ip_repair' => 'Click to repair IP.',


    'i_prtd_ssl' => 'SSL/TLS directory is password-protected.',
    'i_prtd_no_ssl' => 'SSL/TLS directory is not password-protected.',
    'i_prtd_nonssl' => 'Non-SSL/TLS directory is password-protected.',
    'i_prtd_no_nonssl' => 'Non-SSL/TLS directory is not password-protected.',
    'i_prtd_cgi_bin' => 'cgi-bin directory is password-protected.',
    'i_prtd_no_cgi_bin' => 'cgi-bin directory is not password-protected.',

    'i_htype_none' => 'Hosting is not set up.',
    'i_htype_vrt_hst' => 'Physical hosting.',
    'i_htype_frm_fwd' => 'Frame forwarding.',
    'i_htype_std_fwd' => 'Standard forwarding.',

    'i_click_to_hosting' => 'Click to proceed to hosting setup.',


    'i_dsn_configured' => 'DSN is configured.',
    'i_dsn_not_configured' => 'DSN is not configured.',
    'i_dsn_system' => 'It is a system DSN.',
    'i_ftp_ses_domain' => 'Domain administrator\'s session.',
    'i_ftp_ses_sub_domain' => 'Subdomain administrator\'s session.',
    'i_ftp_ses_web_user' => 'Web user\'s session.',
    'i_ftp_ses_anonymous' => 'Anonymous FTP user session.',
    'i_ftp_ses_not_plesk' => 'FTP user who is not registered in Plesk.',
    'i_ftp_ses_idle' => 'Idle (no transactions).',
    'i_ftp_ses_upload' => 'Upload is in progress.',
    'i_ftp_ses_download' => 'Download is in progress.',
    'i_ftp_ses_list' => 'Downloading a list of directories.',
    'i_ftp_ses_not_know' => 'Unrecognized FTP activity.',


    //===============Page conhelp==================//

    'admin_ed' => 'Administrator information.',
    'anonftp' => 'Configure Anonymous FTP service.',
    'actionlog' => 'Manage Action Log settings.',
    'aspdotnet' => 'Editing server-wide ASP.NET configuration.',
    'aspdotnet_dom' => 'Editing ASP.NET configuration for domain.',
    'aspdotnet_subdom' => 'Editing ASP.NET configuration for subdomain.',
    'aspdotnet_wdir' => 'Editing ASP.NET configuration for web directory.',
    'auto_updates' => "Available {$PROD_NAME} updates.",
    'autoinstaller_releases' => 'Select the desired release name to access the list of available components.',
    'autoinstaller_components' => 'Select the required components and click Install to install them.',
    'autoinstaller_install' => 'Please confirm the installation and click OK to begin.',
    'autoinstaller_configure' => 'Updater settings.',
    'backup_dialog' => 'You can back up the domain on this page. The resulting backup file can be placed in the local or remote backups storage or downloaded to the local disk.',
    'backup_configure' => 'Backup manager configuration page.',
    'card' => 'Edit personal information.',
    'cat_edit' => 'Category set up page.',
    'cert' => 'Certificate repository.',
    'cert_dom' => 'Certificate repository.',
    'cert_add' => 'Add a certificate.',
    'cert_add_dom' => 'Add a certificate.',
    'cert_edit' => 'Certificate editing page.',
    'cl_ed' => "Edit customer's information and click OK.",
    'cl_home' => 'Customer home page.',
    'cl_new' => "Enter customer's information and click OK to create a customer account.",
    'cl_perm' => "Set up customer's permissions.",
    'cl_limits' => "Set up customer's limits.",
    'cl_logo' => "Set up a logo for the customer's Customer Panel.",
    'cl_pool' => 'The range of IP addresses allotted to the customer.',
    'cl_pool_add' => "Allocation of IP addresses to the customer.",
    'cl_pool_first_time' => 'Allocation of IP addresses to the customer.',
    'cl_pool_ctrl' => 'IP address properties.',
    'cl_pref' => "Customer's settings.",
    'cl_traffic_history' => 'Traffic history page for the customer.',
    'cl_templates' => 'This page lists customer templates.',
    'cl_traffic' => "Customer's traffic",
    'clients' => 'This page lists all customer accounts registered in the system.',
    'component_conf' => "Configuring the component parameters.",
    'custom_buttons_admin' => 'Create and manage your custom buttons.',
    'custom_buttons_domain' => 'Create and manage your custom buttons.',
    'custom_buttons_client' => 'Create and manage your custom buttons.',
    'custom_buttons_reseller' => 'Create and manage your custom buttons.',
    'custom_buttons_remove' => 'Remove selected custom buttons.',
    'custom_button_admin_edit' => 'Edit custom button.',
    'custom_button_domain_edit' => 'Edit custom button.',
    'custom_button_client_edit' => 'Edit custom button.',
    'custom_button_reseller_edit' => 'Edit custom button.',
    'configure' => 'Postinstall configuration page.',
    'comp_info' => 'Information on components.',
    'common_acl' => 'This page displays a list of all IP and Network addresses for which zone transfer is allowed.',
    'to_common_acl' => 'Return to the common access control list.',
    'common_acl_add' => 'On this page you can add a record to the common allow zone transfer ACL.',
    'common_acl_remove' => 'Removal of the selected ACL records.',
    'cp_access' => 'Management of access to Plesk.',
    'cp_access_add_edit' => 'Network properties.',
    'cp_access_remove' => 'Network removal from the access restriction list.',
    'crontab_unix' => 'This page lists all tasks scheduled in the system.',
    'crontab_win' => 'This page lists all tasks scheduled in the system.',
    'crontab_unix_add_edit' => 'Fill in the required data and click OK to schedule the task.',
    'crontab_win_add_edit' => 'Fill in the required data and click OK to schedule the task.',
    'crontab_unix_remove' => 'Removal of the selected tasks.',
    'crontab_win_remove' => 'Removal of the selected tasks.',
    'scheduler' => 'This page contains the list of tasks scheduled in the system.',
    'scheduler_edit' => 'Fill out the required fields and click OK to add the task to the Scheduler.',
    'scheduler_remove' => 'Removal of the selected scheduled tasks.',
    'b_databases_access' => 'Set up credentials for access to external database servers.',
    'databases_db' =>  'Database access configuration and management tools.',
    'databases_server' =>  'This page allows changing the password used for access to the database server.',
    'db' => 'All databases managed by Plesk are listed on this page.',
    'db_add' => 'Addition of a new database.',
    'db_edit' => 'All users of this database are listed on this page.',
    'db_usr_edit' => 'Set up password for the database user.',
    'defaultcomponents' => 'Selecting default components for the services.',
    'dl_usr_ed' => "Manage domain administrator's account.",
    'dns_add' => 'Add a record to the DNS zone for the domain.',
    'dns_soa' => 'SOA settings configuration.',
    'dns_check' => 'DNS zone testing results.',
    'dns_rec_edit' => 'Edit a resource record.',
    'dns_rec_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'dns_default' => 'Restore the DNS zone.',
    'dnscommonacllist_search' => 'Search in ACL records',
    'dnscommonacllist_show_all' => 'Show all ACL records',
    'dnscommonacllist_remove' => 'Click to remove selected ACL records',
    'mail_name_drweb' => 'Antivirus settings setup.',
    'dom_ctrl' => 'Domain administration.',
    'dom_traffic' => 'Traffic at the domain.',
    'dom_templates' => 'Domain template is a predefined set of domain-specific restrictions, options, and hosting parameters, intended to simplify creation of domains with automatic assignment of settings to them.',
    'create_domain' => 'Enter a new domain name to create a domain for the customer.',
    'create_domain_client_select' => 'Select the customer you wish to create the domain for.',
    'dom_pref' => 'Domain settings.',
    'dom_lim' => 'Domain limits.',
    'domain_report' => 'Domain information.',
    'domain_aliases' => 'Manage domain aliases.',
    'domain_aliases_remove' => 'Remove domain aliases.',
    'client_app_item_info' => 'Web application information.',
    'client_report' => 'Customer information.',
    'report_auto' => 'Manage report delivery schedules.',
    'report_auto_edit' => 'Report delivery schedule properties.',
    'report_auto_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'cl_rpt_list' => 'Custom report layouts.',
    'dom_rpt_list' => 'Custom report layouts.',
    'cl_rpt_edit' => 'Edit report.',
    'dom_rpt_edit' => 'Edit report.',
    'dom_sum_report' => 'This page displays the domain summary report on all domains served by the system.',
    'dom_traffic_history' => 'Traffic history page for the domain.',
    'domains' => 'This page displays a list of all domains served by the system.',
    'dumps_list' => 'Use the domain backup functions and manage the storage of backup files.',
    'download_dialog' => 'Backup file creation.',
    'extras' => 'Additional services management page.',
    'edit_dom_tmpl' => 'Edit a domain template on this page.',
    'edit_cl_tmpl' => 'Edit a customer template on this page.',

    'interface_templates' => 'Interface templates management.',
    'interface_templates_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'b_to_interface_templates' => 'Return to the list of interface templates.',
    'b_interface_template_make_default' => 'Select an interface template and click to make it default.',
    'interface_template_upload' => 'Upload your interface template.',
    'interface_clients' => 'List of clients who use this interface template.',
    'b_to_interface_clients' => 'Return to the list of clients who use this interface template.',
    'interface_clients_add' => 'Specify the clients who should use this interface template.',
    'interface_clients_remove' => 'Specify the clients who should not use the interface template.',

    'ftp_account' => 'If you use an external FTP server for storing backup files, on this page specify the properties of the FTP account used on this server.',
    'ftp_dumps_list' => "The contents of backup files storage on FTP server are listed. You can select a backup file for uploading it into domain's storage.",

    'filemanager' => 'Manage your files and directories on this page.',
    'filemanager_rename_file' => 'File renaming.',
    'filemanager_rename_dir' => 'Directory renaming.',
    'filemanager_chmod' => 'Changing access rights to file.',
    'filemanager_copy_move' => 'File copying (moving).',
    'filemanager_create_file' => 'File creation.',
    'filemanager_show' => 'File viewing.',
    'filemanager_edit' => 'File editing.',
    'filemanager_remove' => 'Files removal.',
    'filemanager_owner_row' => 'File owner.',
    'filemanager_new_file' => 'File creation.',
    'filemanager_new_dir' => 'Directory creation.',

    'gl_list' => 'Global Help Desk.',
    'groups' => 'Mail groups management.',
    'icf' => 'Firewall configuration.',
    'ip_clients' => 'The list of users who have this IP address in the pool.',
    'ip_clients_add' => 'Select clients and click OK to add this IP address in their pools.',
    'b_ipclientsaddlist_search' => 'Enter a search pattern and click to find users.',
    'b_ipclientsaddlist_show_all' => 'Show all users.',

    'frm_fwd' => 'Enter destination URL for forwarding.',
    'std_fwd' => 'Enter destination URL for forwarding.',
    'performance' => 'Domain performance configuring.',
    'phosting_setup' => 'Hosting account setup. Choose the IP address type (dedicated or shared), FTP account username and password, and other hosting related parameters.',
    'phosting_setup_dom_usr' => 'Hosting account parameters setup.',
    'webusers' => 'This page list web users of this domain.',
    'hst_type_sel' => 'Select the type of hosting to set up.',
    'key_info' => 'License key management.',
    'key_upload' => 'Select the license key file and click OK to install.',
    'key_update' => 'Key update status.',
    'key_revert' => 'License key rollback.',
    'interface_management' => 'This page allows you to control which elements of the user interface are visible and which are not.',
    'ip_aliasing' => 'Add to and remove IP addresses from the network interfaces.',
    'ip_aliasing_clients' => 'See the list of users who have this IP address in their IP pools',
    'ip_aliasing_hosting' => 'See the domains hosted on or forwarded from this IP address',
    'ip_add' => 'IP address adding.',
    'ip_ctrl' => 'IP address parameters changing.',
    'license' => 'Read the license agreement carefully.',
    'logo' => 'Change logo image and logo URL.',
    'log_files' => 'This page lists all log files for this domain.',
    'log_rotation' => 'Log rotation settings.',

    'locale_upload' => 'Language pack upload.',
    'locales' => 'Manage Plesk languages.',
    'locales_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'mail_blocked_domains' => 'Manage black list.',
    'mail_blocked_domain_edit' => 'Add domains to black list.',
    'mail_blocked_domains_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'mail_white_list' => 'Manage white list.',
    'mail_white_list_edit' => 'Add domains to white list.',
    'mail_white_list_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'mail_name_alias_edit' => 'Create or edit an email alias.',
    'mail_name_groups' => 'Mail group membership management.',
    'mail_name_mailbox' => 'Mailbox management.',
    'mail_name_preferences' => 'Mail account settings.',
    'mail_name_redirects' => 'Mail forwarder management.',
    'mail_name_redirects_add' => 'Add mail group member.',
    'mail_name_redirects_remove' => 'Mail group members removal.',
    'mail_name_resp_edit' => 'Configure the auto-reply.',
    'mail_name_resp_attach_add' => 'Select files to attach.',
    'mail_name_resp_attach_del' => 'Remove auto-reply attachments.',
    'mail_name_resp_remove' => 'Remove auto-replies.',
    'mail_name_responders' => 'Auto-replies management.',
    'mail_name_files' => 'Mail account attachments repository.',
    'mail_name_files_remove' => 'Files removal.',
    'mail_names' => 'Mail accounts (mailboxes, mail forwarders, mail groups, auto-replies).',
    'mail_preferences' => 'Mail settings.',

    'maillists' => 'This page displays all mailing lists in this domain.',
    'maillists_conf' => 'The main mailing list creation page.',
    'maillist_edit' => 'Mailing list settings.',
    'maillist_new' => 'Mailing list addition.',
    'maillist_del' => 'Mailing list removal.',

    'maillist_members' => 'Mailing list subscribers.',
    'maillist_members_remove' => 'Mailing list subscribers removal.',
    'maillist_member_edit' => 'Mailing list user addition.',

    'mimetypes' => 'MIME types management.',
    'mimetype_edit' => 'MIME type editing.',
    'mimetypes_remove' => 'Click "OK" to delete the selected MIME type(s), or click "Cancel" to cancel deletion.',

    'upload_module' => 'Extension upload.',
    'modules_management' => 'Extensions management.',

    'b_modules_add' => 'Add an extension.',
    'modules_manaege' => 'Add and remove extensions.',
    'modules' => 'From this page you can access the features provided by the extensions installed in your Plesk.',
    'b_moduleslist_search' => 'Enter a search pattern and click to find extensions.',
    'b_moduleslist_show_all' => 'Show all extensions.',
    'b_moduleslist_remove' => 'Remove the selected extensions.',

    'notifications' => 'Manage notification system.',
    'notification_text' => 'Edit notice text.',
    'pg_manage' => 'Adding/changing the PostgreSQL administrator information.',
    'prtd_dirs' => 'Password-protected directories.',
    'prtdir_edit' => 'Protected directory management.',
    'prtdir_preferences' => 'Protected directory settings.',
    'prtdir_usr_edit' => 'Set up password for the protected directory user.',
    'reboot' => 'The system will now be rebooted.',
    'responders' => 'Mail auto-replies.',
    'redirects' => 'Mail forwarders.',
    'restart_services' => 'Services management.',
    'server' => 'Server administration.',
    'sessions' => 'Change session settings.',
    'sessions_list' => 'This page displays a list of all sessions.',
    'ftp_sessions_list' => 'This page displays a list of all FTP sessions.',
    'cl_skeleton' => 'Manage virtual host template.',
    'skeleton' => 'Manage virtual host template.',
    'skins' => 'Manage Plesk skins.',
    'skin_info' => 'Skin information.',
    'skin_download' => 'Skin download.',
    'skin_download_now' => 'Skin download in progress.',
    'skin_upload' => 'Skin upload.',
    'skins_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'shutdown' => 'The system is shutting down.',
    'site_apps_list' => "Domain's application repository.",
    'site_app_pkgs_add' => 'Add a web application package.',
    'site_app_pkgs_list' => 'Available web application packages.',
    'site_app_pkgs_instances' => 'Application installations.',
    'siteapp_install' => 'Web application installation.',
    'siteapp_reconfigure' => 'Web application reconfiguring.',
    'sitepackage_install_config' => 'Web application installation settings.',
    'sitepackage_install_agreement' => 'Web application license agreement.',
    'siteapp_extra_files' => 'Please specify what to do with the files.',
    'siteapppackage_info_server' => 'Web application package properties.',
    'siteapppackage_info_domain' => 'Web application package properties.',
    'additional_keys' => 'Manage the additional license keys: install and remove the license keys for additional features and components.',
    'additional_key_info' => 'You can upload a new license key for the application, download the currently used key to a local machine, and remove it.',
    'additional_key_properties' => 'You can upload a new additional license key, and download the currently used key to the local machine.',
    'additional_key_remove' => 'Select the check box to confirm removal and click OK to remove. Click Cancel to cancel removal.',
    'additional_key_upload' => 'Select the license key file and click OK to install.',
    'additional_keys_remove' => 'Select the check box to confirm removal and click OK to remove. Click Cancel to cancel removal.',

    'b_additional_key_update' => 'Retrieve the additional key and install them.',
    'b_additional_key_revert' => 'Click to roll back the additional key.',
    'b_additional_key_revert_not_avaible' => 'No key installed.',
    'additional_key_revert' => 'To proceed with rolling back the key, select the check box to confirm the operation and click OK.',

    'sshterm' => 'Secure Shell Terminal.',
    'statistics' => 'System statistics.',
    'sys_time' => 'Set up system date/time and synchronization with NTP server.',
    'subdomains' => 'Subdomains management. You can add, edit, and remove subdomains from this page.',
    'subdom_ctrl' => 'Subdomain administration page.',
    'subdom_edit' => 'Subdomain properties configuring.',
    'subdom_create' => 'Subdomain creation.',
    'subdom_remove' => 'Removal of the selected subdomains.',
    'templates' => 'This page displays a list of all domain templates, which can be used when creating a new domain.',
    'tmpl_warn' => "The template limits that exceed client's limits are listed on this page.",
    'view_info' => 'From this page you can view the backup file properties and restore this backup.',

    'visibility_adminonly' => 'Make this control visible only to the administrator.',
    'visibility_cancel' => 'Cancel customization of controls on this screen.',
    'visibility_control' => 'Click to customize this control.',
    'visibility_customize' => 'Customize individual controls on this screen.',
    'visibility_default' => 'Apply default settings to this control.',
    'visibility_export' => 'Export the settings made on this screen in the form of a shell script. Run this script on a Plesk-managed server to import the settings.',
    'visibility_hide' => 'Hide this control.',
    'visibility_hide_toolbar' => 'Hide this toolbar.',
    'visibility_ok' => 'Save customizations of controls on this screen.',
    'visibility_reset_all' => 'Reset all controls on all screens to their default settings.',
    'visibility_reset_screen' => 'Reset all controls on this screen to their default settings.',
    'visibility_show' => 'Show this control.',

    'b_webalizer_preferences' => 'Click to manage web statistics settings.',
    'b_to_webalizer_preferences' => 'Return to web statistics settings.',
    'webalizer_hidden_referrers' => 'List of referrers that will not be displayed in statistical reports.',
    'webalizer_hidden_referrer_edit' => 'Modify the hidden referrer properties.',
    'webalizer_hidden_referrers_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'b_hidden-referrer-add' => 'Hide more referrers.',
    'b_webalizerhiddenreferrerslist_remove' => 'Delete the selected referrers.',
    'b_webalizerhiddenreferrerslist_search' => 'Enter a search pattern and click to find referrers.',
    'b_webalizerhiddenreferrerslist_show_all' => 'Show all referrers',
    'l_webalizerhiddenreferrerslist_name' => 'Sort referrers by site.',
    'webalizer_group_referrers' => 'Displayed are the grouped referrer sites.',
    'webalizer_group_referrer_edit' => 'Referrer group properties.',
    'webalizer_group_referrers_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'b_group-referrer-add' => 'Add referrer group.',
    'b_webalizergroupreferrerslist_remove' => 'Show these referrers in statistical reports.',
    'b_webalizergroupreferrerslist_search' => 'Enter a search pattern and click to find referrers.',
    'b_webalizergroupreferrerslist_show_all' => 'Show all referrer site entries',
    'l_webalizergroupreferrerslist_name' => 'Sort referrers by group.',
    'l_webalizergroupreferrerslist_referrer' => 'Sort referrers by site.',
    'cl_tmpl_warn' => "The template limits that cannot be accepted are listed on this page.",
    'virtualdirs' => 'Virtual directories management.',
    'virtualdir_create' => 'Virtual directory creation.',
    'virtualdir_edit' => 'Virtual directory editing.',
    'virtualdirs_remove' => 'Virtual directories removal.',
    'web_users' => 'Managing web users of the domain.',
    'web_users_preferences' => "Additional web user settings.",
    'wu_edit' => 'Set up FTP password for web user.',
    'lang' => 'Set default interface language on this page.',
    'ch_pass' => "Change Administrator's password on this page.",
    'dns_template' => 'DNS zone template management.', //to remove
    'dns_template_add' => 'Add a record to the DNS zone template.', //to remove

    'dns_t' => 'This screen shows the resource records in the server-wide DNS zone template.',
    'dns_t_add' => 'Add a record to the DNS zone template.',
    'dns_t_soa' => 'SOA settings configuration.',
    'dns_t_rec_edit' => 'Edit a resource record.',
    'dns_t_rec_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'dns_t_default' => 'Restore the DNS zone template.',
    'b_to_dns_t' => 'Return to the DNS template records list.',

    'web_app_add' => 'Add a Java application.',
    'odbc_dsn_configuration' => 'ODBC management page.',
    'odbc_dsn_add' => 'Add a ODBC DSN.',
    'odbc_removing' => 'Removal of the selected ODBC DSNs.',
    'odbc_connection_config' => 'ODBC connection configuration.',
    'odbc_connection_config_access' => 'Configuring ODBC connection for Microsoft Access driver.',
    'odbc_connection_config_mssql' => 'Configuring ODBC connection for Microsoft SQL Server driver.',
    'odbc_connection_config_mysql' => 'Configuring ODBC connection for MySQL driver.',

    'webdirs' => 'Web directories management.',

    'webdir_permissions' => 'Viewing and setting up special permissions.',

    'chowner_select' => 'Select the new owner and click Next to continue.',
    'chowner' => 'Click Finish to confirm subscription transfer.',
    'b_chowner_back_to_clients' => "Click to return to the previous screen.",
    'b_chowner_back_to_domains' => "Click to return to the previous screen.",
    'b_chowner_next' => "Click to proceed.",
    'b_chowner_finish' => "Click to finish the wizard.",
    'b_chowner_finish_disabled' => 'Unable to transfer subscriptions to the new owner.',
    'b_change_domains_owner' => "Transfer subscriptions to another owner.",

    'qu_edit' => 'Queue set up page.',
    'qus' => 'This page displays a list of queues.',

    'remove_modules' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeServers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeCerts' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeMailAliases' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDataBases' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDataBaseUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeCrontabTask' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDomains' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDNS' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeClients' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeLogFiles' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDumps' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeMailNames' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeWebUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeProtectedDirs' => "Select the check box and click OK to remove protection from the selected directories, or click Cancel to cancel.",
    'removeProtectedDirUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeReports' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeSessions' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeTemplates' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeIPAddress' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeClientsIP' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'cat_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'pr_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'qu_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'pr_edit' => 'Priority setup.',
    'prs' => 'This page lists priorities.',

    'spamassassin' => 'SpamAssassin settings.',
    'spamassassin_train' => 'Training of statistics databases used for Bayesian filtering. Classify content of your mailbox as spam and good mail.',
    'spamassassin_train_view_message_source' => 'Click to view message source.',
    'spamassassin_user_conf' => 'Personal SpamAssassin settings configuration.',
    'spaw' => 'HTML editor.',
    'upload_dump' => "Select a backup file and click 'Upload' to upload the file to the storage. To upload a multivolume backup, specify the first part of the volume, then click the 'Specify the next volume' link, and specify the next volume. Repeat it until you have specified all volumes of the backup. When finished, click 'Upload'.",
    'subdom_performance' => 'Subdomain performance configuring.',

    'dom_performance_edit' => 'Domain performance configuring.',
    'dom_performance_readonly' => 'Viewing the domain performance configuration.',

    //===============List table header conhelp==================//

    'l_inv' => 'Invert selection of check boxes.',
    'l_rad' => 'Select the radio button.',

    'l_autoinstallerreleaseslist_name' => 'Sort releases by name.',
    'l_autoinstallerreleaseslist_action' => 'Sort releases by available operations.',
    'l_autoinstallerreleaseslist_action_icon' => 'Sort releases by available operations.',

    'l_autoinstallercomponentslist_name' => 'Sort components by name.',
    'l_autoinstallercomponentslist_action' => 'Sort components by status.',
    'l_autoinstallercomponentslist_action_icon' => 'Sort components by status.',
    'l_autoinstallercomponentslist_serverbuildtime' => 'Sort components by release date.',
    'l_autoinstallercomponentslist_localbuildtime' => 'Sort components by release date.',
    'l_autoinstallercomponentslist_available_version' => 'Sort components by version.',
    'l_autoinstallercomponentslist_installed_version' => 'Sort components by version.',

    'b_autoinstallervendorsourceslist_remove' => 'Remove the selected sources from the list.',
    'b_autoinstallervendorsourceslist_search' => 'Enter a source URL and click to find sources.',
    'b_autoinstallervendorsourceslist_show_all' => 'Show all sources.',

    'l_autoinstallervendorsourceslist_status' => 'Sort sources by status.',
    'l_autoinstallervendorsourceslist_type' => 'Sort sources by type.',
    'l_autoinstallervendorsourceslist_url' => 'Sort sources by URL.',
    'l_autoinstallervendorsourceslist_priority' => 'Sort sources by priority.',


    'l_reportautolist_auto' => 'Sort schedules by delivery frequency.',
    'l_reportautolist_last' => 'Sort schedules by last delivery date.',
    'l_reportautolist_recipient' => 'Sort schedules by recipients.',
    'l_reportautolist_select' => 'Sort schedules by selection.',

    'l_componetslist_name' => 'Sort components by name.',
    'l_componetslist_version' => 'Sort components by version.',

    'l_certificateslist_csr' => 'Sort certificates by CSR part presence.',
    'l_certificateslist_usage' => 'Sort certificates by usage.',
    'l_certificateslist_pvt_key' => 'Sort certificates by Private Key part presence.',
    'l_certificateslist_cert' => 'Sort certificates by Certificate part presence.',
    'l_certificateslist_ca_cert' => 'Sort certificates by CA Certificate part presence.',
    'l_certificateslist_name' => 'Sort certificates by name.',

    'l_clientslist_type' => 'Sort customer accounts by account ownership type.',
    'l_clientslist_state' => 'Sort customer accounts by state.',
    'l_clientslist_status' => 'Sort customer accounts by status.',
    'l_clientslist_cp_access' => 'Sort customer accounts by permission to access Customer Panel.',

    'l_custombutton_list_sort_key' => 'Sort links by display order.',
    'l_custombutton_list_public' => 'Sort links by accessibility.',
    'l_custombutton_list_place' => 'Sort links by location.',
    'l_custombutton_list_name' => 'Sort links by label.',
    'l_custombutton_list_url' => 'Sort links by URL.',
    'l_custombutton_list_conhelp' => 'Sort links by description.',

    'l_clientreportslist_auto' => 'Sort report layouts by delivery schedule state.',
    'l_clientreportslist_name' => 'Sort by report name.',
    'l_clientreportslist_general' => 'Sort by amount of data that will be presented in the General section of report.',
    'l_clientreportslist_domains' => 'Sort by amount of data that will be presented in the Domains section of report.',

    'l_clienttrafficlist_name' => 'Sort domains by name.',
    'l_clienttrafficlist_used' => 'Sort domains by traffic.',
    'l_clienttrafficlist_limit' => 'Sort domains by traffic limit defined.',
    'l_clienttrafficlist_avail' => 'Sort domains by traffic availability.',
    'l_clienttrafficlist_ubar' => 'Sort domains by traffic usage.',

    'l_cpaccesslist_netaddr' => 'Sort the networks by address.',
    'l_cpaccesslist_netmask' => 'Sort the networks by mask.',

    'l_crontablist_enabled' => 'Sort tasks by status.',
    'l_crontablist_minute' => 'Sort tasks by minute.',
    'l_crontablist_hour' => 'Sort tasks by hour.',
    'l_crontablist_dom' => 'Sort tasks by day of the month.',
    'l_crontablist_month' => 'Sort tasks by month.',
    'l_crontablist_dow' => 'Sort tasks by day of the week.',
    'l_crontablist_cmd' => 'Sort tasks by command.',

    'l_schedulertaskslist_status' => 'Sort tasks by status.',
    'l_schedulertaskslist_name' => 'Sort tasks by description.',
    'l_schedulertaskslist_priority' => 'Sort tasks by task priority.',

    'l_additionalkeyslist_key_name' => 'Sort license keys by name.',
    'l_additionalkeyslist_name' => 'Sort license keys by name.',
    'l_additionalkeyslist_key_number' => 'Sort license keys by key number.',
    'b_additionalkeyslist_remove' => 'Delete the selected license keys.',
    'b_additionalkeyslist_search' => 'Enter a search pattern and click to find additional keys.',
    'b_additionalkeyslist_show_all' => 'Show all additional keys.',
    'b_key_additional_list_install' => 'Install the selected license keys.',
    'b_key_additional_list_remove' => 'Delete the selected license keys.',

    'b_databaseserverdatabaselist_search' => 'Enter a seach pattern and click to find databases.',
    'b_databaseserverdatabaselist_show_all' => 'Show all databases',
    'b_databaseserverdatabaselist_remove' => 'Delete selected databases',
    'l_databaseserverdatabaselist_name' => 'Sort databases by name.',
    'l_databaseserverdatabaselist_domain' => 'Sort databases by domain.',
    'l_databaseserverdatabaselist_client' => 'Sort databases by client.',

    'l_domainslist_state' => 'Sort domains by state.',
    'l_domainslist_status' => 'Sort domains by status.',
    'l_domainslist_date' => 'Sort domains by date.',
    'l_domainslist_name' => 'Sort domains by name.',
    'l_domainslist_subdomains' => 'Sort domains by number of subdomains.',
    'l_domainslist_domainaliases' => 'Sort domains by number of domain aliases.',
    'l_domainslist_usage' => 'Sort domains by disk space usage.',
    'l_domainslist_traffic' => 'Sort domains by traffic.',
    'l_domainslist_htype' => 'Sort domains by hosting type.',

    'l_sysuserslist_name' => 'Sort system users by name.',

    'l_domaintrafficlist_name' => 'Sort services by name.',
    'l_domaintrafficlist_in' => 'Sort services by incoming traffic.',
    'l_domaintrafficlist_out' => 'Sort services by outgoing traffic.',
    'l_domaintrafficlist_used' => 'Sort services by total amount of traffic.',
    'l_domaintrafficlist_ubar' => 'Sort services by service traffic share in the total traffic at the domain.',

    'l_dnscommonacllist_host' => 'Sort ACL records by Addresses value',

    'l_domainsumreplist_du' => 'Sort domain summary reports by disk space usage.',
    'l_domainsumreplist_tr' => 'Sort domain summary reports by traffic.',
    'l_domainsumreplist_sd' => 'Sort domain summary reports by number of subdomains.',
    'l_domainsumreplist_mn' => 'Sort domain summary reports by number of mailboxes.',
    'l_domainsumreplist_mg' => 'Sort domain summary reports by number of mail forwardings.',
    'l_domainsumreplist_ma' => 'Sort domain summary reports by number of auto-replies.',
    'l_domainsumreplist_wu' => 'Sort domain summary reports by number of web users.',
    'l_domainsumreplist_db' => 'Sort domain summary reports by number of databases.',
    'l_domainsumreplist_ml' => 'Sort domain summary reports by number of mailing lists.',
    'l_domainsumreplist_name' => 'Sort domain summary reports by domain name.',
    'l_domainsumreplist_pname' => 'Sort domain summary reports by client name.',

    'l_domainreportslist_auto' => 'Sort report layouts by delivery schedule state.',
    'l_domainreportslist_name' => 'Sort report layouts by name.',
    'l_domainreportslist_general' => 'Sort report layouts by amount of data presented in the General section.',
    'l_domainreportslist_hosting' => 'Sort report layouts by amount of data presented in the Hosting section.',
    'l_domainreportslist_webusers' => 'Sort report layouts by amount of data presented in the Web users section.',
    'l_domainreportslist_mailnames' => 'Sort report layouts by amount of data presented in the Mail accounts section.',
    'l_domainreportslist_maillists' => 'Sort report layouts by amount of data presented in the Mailing lists section.',
    'l_domainreportslist_databases' => 'Sort report layouts by amount of data presented in the Databases section.',
    'l_domainreportslist_siteapps' => 'Sort report layouts by amount of data presented in the Site Applications section.',
    'l_domainreportslist_aspnetapps' => 'Sort report layouts by amount of data presented in the ASP.NET Web Applications section.',

    'l_dnszonelist_host' => 'Sort DNS zone records by host.',
    'l_dnszonelist_type' => 'Sort DNS zone records by type.',
    'l_dnszonelist_val' => 'Sort DNS zone records by value.',

    'l_dnszonetemplatelist_host' => 'Sort DNS zone template records by host.',
    'l_dnszonetemplatelist_type' => 'Sort DNS zone template records by type.',
    'l_dnszonetemplatelist_val' => 'Sort DNS zone template records by value.',
    'l_dnsnslist_ns' => 'Sort DNS records by name server.',
    'l_dnsmasterlist_ip' => 'Sort DNS records by master server.',
    'l_dnsnslist_name' => 'Sort DNS records by name server.',
    'l_dnsmasterlist_name' => 'Sort DNS records by master server.',

    'l_filelist_file_perms' => 'Sort files and directories by permissions.',
    'l_filelist_type' => 'Sort files and directories by type.',
    'l_filelist_name' => 'Sort files and directories by name.',
    'l_filelist_size' => 'Sort files and directories by size.',
    'l_filelist_ch_date' => 'Sort files and directories by modification date.',
    'l_filelist_user' => 'Sort files and directories by owner user.',
    'l_filelist_group' => 'Sort files and directories by owner group.',
    'l_filelist_file_perm' => 'Sort files and directories by permissions.',

    'l_mailnameresponderattachmentslist_name' => 'Sort attachments by name.',
    'l_mailnameresponderattachmentslist_size' => 'Sort attachments by size.',

    'l_mailnameresponderslist_status' => 'Sort auto-replies by status.',
    'l_mailnameresponderslist_name' => 'Sort auto-replies by name.',

    'l_mailnameslist_client' => 'Sort mail accounts by client name.',
    'l_mailnameslist_domain' => 'Sort mail accounts by domain name.',
    'l_mailnameslist_cp_access' => 'Sort mail accounts by capability to access the Customer Panel.',
    'l_mailnameslist_mailbox' => 'Sort mail accounts by presence of mailbox.',
    'l_mailnameslist_redirect' => 'Sort mail accounts by presence of forwarders.',
    'l_mailnameslist_mailgroup' => 'Sort mail accounts by presence of forwarders to multiple recipients.',
    'l_mailnameslist_mailresp' => 'Sort mail accounts by presence of auto-replies.',
    'l_mailnameslist_spamfilter' => 'Sort mail accounts by presence of spamfilter.',
    'l_mailnameslist_virusfilter' => 'Sort mail accounts by presence of antivirus.',
    'l_mailnameslist_drweb' => 'Sort mail accounts by antivirus filtering usage.',
    'l_mailnameslist_name' => 'Sort mail accounts by name.',

    'l_mimetypeslist_name' => 'Sort MIME types by extension.',
    'l_mimetypeslist_content' => 'Sort MIME types by content type.',

    'l_moduleslist_name' => 'Sort extensions by name.',
    'l_moduleslist_version' => 'Sort extensions by version.',
    'l_moduleslist_release' => 'Sort extensions by release number.',
    'l_moduleslist_description' => 'Sort extensions by description.',
    'l_moduleslist_key' => 'Sort extensions by license key.',

    'l_sessionslist_type' => 'Sort sessions by access type.',
    'l_sessionslist_name' => 'Sort sessions by name.',
    'l_sessionslist_ip_addr' => 'Sort sessions by IP address.',
    'l_sessionslist_login_time' => 'Sort sessions by login date and time.',
    'l_sessionslist_idle' => 'Sort sessions by idle time.',

    'l_serviceslist_name' => 'Sort services by name.',
    'l_serviceslist_comp' => 'Sort services by component name.',

    'l_ippoollist_state' => 'Sort IP addresses by state.',
    'l_ippoollist_certificate' => 'Sort IP addresses by certificate.',
    'l_ippoollist_type' => 'Sort IP addresses by type.',
    'l_ippoollist_name' => 'Sort the list by IP addresses.',
    'l_ippoollist_hostings' => 'Sort IP addresses by use in hosting accounts.',

    'l_ipaddrlist_state' => 'Sort the list of IP addresses by state.',
    'l_ipaddrlist_type' => 'Sort the list of IP addresses by type.',
    'l_ipaddrlist_name' => 'Sort the list by IP addresses.',
    'l_ipaddrlist_mask' => 'Sort the list of IP addresses by mask.',
    'l_ipaddrlist_iface' => 'Sort the list of IP addresses by interface.',
    'l_ipaddrlist_clients' => 'Sort the list of IP addresses by the number of user accounts.',
    'l_ipaddrlist_hostings' => 'Sort the list of IP addresses by use in hosting accounts.',

    'l_ipclientslist_name' => 'Sort users by name.',
    'l_ipclientsaddlist_name' => 'Sort users by name.',

    'l_protecteddirslist_non_ssl' => 'Sort protected/non-protected directories on the Non-SSL/TLS site.',
    'l_protecteddirslist_ssl' => 'Sort protected/non-protected directories on the SSL/TLS site.',
    'l_protecteddirslist_cgi_bin' => 'Sort protected/non-protected directories in the cgi-bin.',
    'l_protecteddirslist_name' => 'Sort protected directories by name.',
    'l_protecteddirslist_header_text' => 'Sort protected directories by area title.',

    'l_protecteddiruserslist_name' => 'Sort protected directory users by name.',

    'l_ipdomainslist_name' => 'Sort domains by name.',

    'l_localeslist_active' => 'Sort by status.',
    'l_localeslist_country' => 'Sort by country.',
    'l_localeslist_lang' => 'Sort by language.',
    'l_localeslist_name' => 'Sort by language code.',
    'l_localeslist_used' => 'Sort by usage.',

    'l_virtualdirslist_name' => 'Sort virtual directories by name.',
    'l_virtualdirslist_path' => 'Sort virtual directories by path.',
    'l_virtualdirslist_script_execute' => 'Sort virtual directories by execute permission.',
    'l_virtualdirslist_read' => 'Sort virtual directories by read permission.',
    'l_virtualdirslist_write' => 'Sort virtual directories by write permision.',
    'l_virtualdirslist_source' => 'Sort virtual directories by script source access permission.',
    'l_virtualdirslist_browse' => 'Sort virtual directories by directory browsing permission.',

    'l_logfileslist_date' => 'Sort log files by modification date.',
    'l_logfileslist_name' => 'Sort log files by name.',
    'l_logfileslist_size' => 'Sort log files by size.',
    'l_logfileslist_download' => 'Click on diskette icon to download a log file.',
    'l_logfileslist_view' => 'Click to view the log file.',

    'l_servermailblockeddomainslist_name' => 'Sort blocked domains by name.',

    'l_servermailwhitelistlist_name' => 'Sort white list entries by IP address/mask.',

    'l_eventhandlerslist_name' => 'Sort event handlers by event type.',
    'l_eventhandlerslist_priority' => 'Sort event handlers by priority.',
    'l_eventhandlerslist_user' => 'Sort event handlers by system user name.',
    'l_eventhandlerslist_command' => 'Sort event handlers by command.',

    'l_skinslist_name' => 'Sort skins by name.',
    'l_skinslist_used' => 'Sort skins by usage.',
    'l_skinslist_author' => "Sort skins by author's name.",
    'l_skinslist_description' => 'Sort skins by description.',

    'l_dumpslist_date' => 'Sort backup files by modification date.',
    'l_dumpslist_name' => 'Sort backup files by name.',
    'l_dumpslist_size' => 'Sort backup files by size.',
    'l_dumpslist_info' => 'Display the backup information.',
    'l_dupmslist_download' => 'Click to download the backup file.',

    'l_siteappclientsaddlist_name' => 'Sort clients by name.',
    'siteappclientsaddlist_search' => 'Enter a search pattern and click to find clients.',
    'siteappclientsaddlist_show_all' => 'Show all clients.',

    'l_serversiteapppackageslist_name' => 'Sort by package name.',
    'l_serversiteapppackageslist_version' => 'Sort by package version.',
    'l_serversiteapppackageslist_release' => 'Sort by package release.',
    'l_serversiteapppackageslist_installation_number' => 'Sort by the number of installed applications.',
    'l_serversiteapppackageslist_clients_number' => 'Sort by the number of customers who are allowed to use this web application.',
    'l_serversiteapppackageslist_size' => 'Sort by package size',
    'l_serversiteapppackageslist_description' => 'Sort by package description.',
    'b_serversiteapppackageslist_search' => 'Enter a search pattern and click to find packages.',
    'b_serversiteapppackageslist_show_all' => 'Show all available web application packages',
    'b_serversiteapppackageslist_install' => 'Install the web application to the selected domain.',
    'b_serversiteapppackageslist_remove' => 'Remove the selected web application packages from the server.',

    'b_apsapplicationslist_remove' => 'Remove the selected applications.',
    'b_apsapplicationslist_show_all' => 'Show all available web application packages',
    'b_apsapplicationslist_search' => 'Enter a search pattern and click to find web application packages.',

    'l_dsnlist_configured' => 'Sort DSN by configuration status.',
    'l_dsnlist_name' => 'Sort DSN by name.',
    'l_dsnlist_description' => 'Sort DSN by description.',

    'l_updateslist_name' => "Sort updates by name.",

    'l_ftpsessionslist_path' => "Sort FTP sessions by user's location.",
    'l_ftpsessionslist_domain' => 'Sort FTP sessions by domain name.',
    'l_ftpsessionslist_file' => 'Sort FTP sessions by file name.',
    'l_ftpsessionslist_actions' => 'Sort FTP sessions by status.',
    'l_ftpsessionslist_speed' => 'Sort FTP sessions by speed.',
    'l_ftpsessionslist_persent' => 'Sort FTP sessions by the file transfer operation progress.',
    'l_ftpsessionslist_ip_addr' => 'Sort FTP sessions by the IP address the FTP account is accessed from.',
    'l_ftpsessionslist_name' => "Sort FTP sessions by user's FTP account username.",
    'l_ftpsessionslist_login_time' => 'Sort FTP sessions by logon time.',
    'l_ftpsessionslist_idle' => 'Sort FTP sessions by idle time.',
    'l_ftpsessionslist_type' => 'Sort FTP sessions by user type.',

    'b_spamfilteraddresseslist_search' => 'Enter a search criterion and click to find addresses.',
    'b_spamfilteraddresseslist_show_all' => 'Show all addresses.',
    'b_spamfilteraddresseslist_remove' => 'Remove the selected addresses from the list.',

    'l_spamfilteraddresseslist_status' => 'Sort addresses by whether mail coming from a given address is filtered.',
    'l_spamfilteraddresseslist_level' => "Sort addresses by whether a given address came from the administrator's or email user's list.",
    'l_spamfilteraddresseslist_address' => 'Sort addresses first by the part to the left of the @ sign, and then by domain names.',

    'spamfilter_addresses_list__status_conhelp' => 'Shows whether mail coming from a given address is filtered.',
    'spamfilter_addresses_list__level_conhelp' => "Shows if the entry came from the administrator's or email user's list.",

    'b_spamassassintrainlist_search' => 'Search for messages that contain the specified string in the Subject or From field.',
    'b_spamassassintrainlist_show_all' => 'Show all messages in your mailbox.',
    'b_spamassassintrainlist_remove' => 'Remove the selected messages from the mailbox.',
    'l_spamassassintrainlist_class' => 'Sort messages by type.',
    'l_spamassassintrainlist_learned' => 'Sort by learnt and not learnt messages.',
    'l_spamassassintrainlist_subject' => 'Sort messages by subject.',
    'l_spamassassintrainlist_from' => "Sort messages by sender.",
    'l_spamassassintrainlist_date' => 'Sort messages by date.',

    'b_mailqueuelist_search' => 'Search for messages by specified criteria.',
    'b_mailqueuelist_show_all' => 'Show all messages in specified queue.',
    'b_mailqueuelist_remove' => 'Remove the selected messages from the queue.',

    'l_mailqueuelist_queue' => 'Sort messages by queue type.',
    'l_mailqueuelist_subject' => 'Sort messages by subject.',
    'l_mailqueuelist_sender' => 'Sort messages by envelope sender.',
    'l_mailqueuelist_recipients' => 'Sort messages by envelope recipients.',
    'l_mailqueuelist_date' => 'Sort messages by date.',
    'l_mailqueuelist_age' => 'Sort messages by the time elapsed since the moment the message was put into queue.',
    'l_mailqueuelist_size' => 'Sort messages by size.',

    'b_wizard_prev' => 'Return to the previous step of the wizard.',
    'b_wizard_next' => 'Proceed to the next step of the wizard.',
    'b_finish' => 'Apply the changes made on this screen and exit the wizard.',

    'l_backupfileslist_name' => 'Sort backup files by name.',
    'l_backupfileslist_date' => 'Sort backup files by date.',
    'l_backupfileslist_size' => 'Sort backup files by size.',
    'backupfileslist_remove' => 'Delete the selected backup files.',
    'backupfileslist_search' => 'Enter a search pattern and click to find backup files.',
    'backupfileslist_show_all' => 'Show all backup files.',
    'backupfileslist_download' => 'Click to download the backup file.',

    // pacif add

    'b_backup_ftp_settings' => 'Click to specify FTP account settings.',
    'b_backup_scheduled_settings' => 'Click to set up backing up on schedule.',
    'b_backup_ftp_not_configured' => 'FTP account is not configured.',
    'backup_client_front' => 'Back up and restore user accounts and set up backing up on schedule.',
    'backup_domain_front' => 'Back up and restore websites and set up backing up on schedule.',
    'backup_client_new' => 'Back up a user account.',
    'backup_domain_new' => 'Back up a website.',
    'backup_ftp_settings' => 'Specify the settings for the FTP account that will be used as a remote storage.',

    'backup_overwrite' => 'Select the check box to confirm replacement, and click OK to replace the file.',
    'b_backup_file_overwrite' => 'Click to replace the existing backup file with a new one.',
    'b_backup_file_overwrite_cancel' => 'Click to cancel file replacement and return to setting up backup properties.',
    'b_backup_cancel' => 'Click to stop the backup process.',

    'b_backup_cancel_creating' => 'Click to cancel backup creation and return to the previous page.',
    'b_backup_cancel_ftp_settings' => 'Click to discard the FTP account settings and return to the previous screen.',
    'b_restore_cancel' => 'Stop restoration.',
    'backup_progress' => 'Viewing the backup progress. Click Cancel to stop the backup process.',
    'restore_progress' => 'Viewing the restoration progress. Click Cancel to stop restoration.',
    'b_backup_new_restore' => 'Start restoring.',
    'b_restore_cancel_creating' => 'Click to cancel restoring and return to the previous page.',
    'b_backup_file_delete' => 'Click to delete backup file.',
    'backup_delete' => 'Select the check box to confirm backup files removal and click OK.',
    'backup_result' => 'After viewing the backup results, click OK to complete and return to the Backup Manager.',
    'backup_restore_results' => 'After viewing the restoration results, click OK to return to the Backup Manager.',
    'l_backupdomainsinbackuplist_valid' => 'Sort domains by state.',
    'l_backupdomainsinbackuplist_name' => 'Sort domains by name.',
    'backupdomainsinbackuplist_search' => 'Enter a search pattern and click to find domains.',
    'backupdomainsinbackuplist_show_all' => 'Show all domains.',

    'i_backup_domain_can_restore' => 'This domain can be restored.',
    'i_backup_domain_exist_other_client' => 'This domain cannot be restored because there is another domain with such a name, which belongs to another user.',
    'backup_failed' => 'Backup failed.',
    'backup_stop' => 'Click OK to stop the backup process. Click Cancel to continue backup.',
    'restore_stop' => 'Click OK to stop restoration. Click Cancel to continue restoration.',
    'backup_info_domain' => 'To restore the data from this backup file, click Next>>.',
    'backup_info_domain_restore' => 'To restore the data from this backup file, click Restore.',
    'backup_info_client' => 'To restore the data from this backup file, select the required items and click Next>>.',
    'backup_ip_mapping_domain' => 'Map the IP address registered in the backup file to another available IP address.',
    'backup_ip_mapping_client' => 'Map the IP addresses registered in the backup file to available IP addresses.',
    'backup__db_server_mapping' => 'Select the database server configured in Plesk to which you wish to map the database server from backup.',

    'b_restore_ip_mapping' => 'Click to set up IP mapping for restoring.',
    'learn_more' => 'Read more about this new feature.',
    'try_new_feature' => 'Try out this new feature!',
    'whats_new_full' => 'A detailed description of new features and changes in this release.',
    'b_migration_dump_all' => 'Migrate all accounts from the remote host.',
    'i_migration_not_exist_account' => 'This account can be migrated.',
    'i_migration_exist_account' => "This account cannot be migrated: it is already in {$PROD_NAME}",
    'i_migration_not_exist_domain' => 'This domain can be migrated.',
    'i_migration_exist_domain' => "This domain cannot be migrated: it is already in {$PROD_NAME}",
    'i_migration_bad_domain' => 'This domain cannot be migrated: domain name is invalid',
    'i_migration_con_exist_domain' => 'Some of the domains were already migrated to this account.',
    'i_migration_all_domain_exist' => "Only the account information will be migrated: all domains related to this account are already in {$PROD_NAME}",
    'migration_upload' => 'Select the source platform, specify the source host name and credentials for login, and click Next to upload the Migration & Transfer Agent to the host.',
    'migration_progress' => 'View the migration progress and stop the migration if desired.',
    'b_migration_host_info' => 'View information on the remote host and select objects for migration.',
    'b_migration_single_info' => 'You have an option to import all data from the dump or select the objects to be imported. From this page you can also define the deployment settings.',
    'migration_content_download' => 'View the content downloading progress and stop the downloading if desired.',
    'migration_content_download_not_space' => 'Not enough disk space to download content from the remote host.',
    'migration_objects_select' => 'Select the accounts and domains for migration.',
    'migration_account_select' => 'Select the user account in Plesk to which you want to migrate the selected domains.',
    'migration_ip_mapping' => 'Select the IP address in Plesk to which you want to map the remote host IP addresses.',
    'migration_stop' => 'Select the check box to confirm that you want to stop the migration and remove Migration & Transfer Agent from the remote host, and click OK.',
    'migration_result' => 'After viewing the migration results, click Finish to complete.',
    'migration_failed' => 'Migration failed.',
    'b_migrate' => 'Start migration.',
    'b_migrate_cancel' => 'Stop the migration process.',
    'b_migration_reload' => 'Click to refresh the data.',
    'b_migrate_domains' => 'Click to migrate the selected domains.',
    'b_migrate_accounts' =>'Click to migrate the selected accounts.',
    'b_migrate_set_accounts' =>'Click to define accounts for migrating object.',
    'b_migrate_set_ip_map' =>'Click to set up IP mapping for migrating object.',
    'b_migrate_set_db_server_map' =>'Click to set up mapping for the migrated databases.',
    'b_migration_begin' =>'Click to begin new migration.',
    'b_migration_more' =>'Click to migrate more objects from this host.',
    'l_migrationdomainlist_name' => 'Sort domains by name.',
    'l_migrationdomainlist_valid' => 'Sort domains by availability.',
    'l_migrationaccountslist_name' => 'Sort accounts by name.',
    'l_migrationipmaplist_old' => 'Sort the list by IP addresses.',
    'b_migrationdomainlist_search' => 'Enter a search pattern and click to find domains.',
    'b_migrationdomainlist_show_all' => 'Show all domains.',
    'b_migrationaccountslist_search' => 'Enter a search pattern and click to find accounts.',
    'b_migrationaccountslist_show_all' => 'Show all accounts.',
    'b_migrationipmaplist_search' => 'Enter a search pattern and click to find IP Address.',
    'b_migrationipmaplist_show_all' => 'Show all IP Address.',
    'l_migrationaccountslist_count' => 'Sort accounts by number of domains.',
    'l_migrationaccountslist_contact' => 'Sort accounts by contact name.',
    'l_migrationdomainlist_account' => 'Sort domains by account.',
    'l_migrationipmaplist_type' => 'Sort the list by IP addresses type.',
    'b_migration_retry' =>'Click to continue migration after you have freed up disk space.',
    'b_migration_ignore' =>'Click to continue migration anyway.',
    'l_migrationaccountslist_status' => 'Group accounts that can be migrated and sort them alphabetically.',
    'b_migrate_single' => 'Single-Host Migration.',
    'l_migrationdomainlist_status' => 'Group domain names that can be migrated and sort them alphabetically.',

    'b_migrationclientslist_remove' => 'Delete the accounts and domains of the selected clients.',
    'b_migrationclientslist_search' => 'Enter a search pattern and click to find clients.',
    'b_migrationclientslist_show_all' => 'Show all clients.',

    'l_migrationclientslist_state' => 'Sort client accounts by state.',
    'l_migrationclientslist_status' => 'Sort client accounts by status.',
    'l_migrationclientslist_date' => 'Sort client accounts by date.',
    'l_migrationclientslist_name' => 'Sort client accounts by name.',
    'l_migrationclientslist_domains' => 'Sort client accounts by domains.',
    'l_migrationclientslist_cname' => 'Sort client accounts by company name.',
    'b_migration_session_list' => 'Current migrations',
    'l_migrationsessionlist_host' => 'Sort session list by host.',
    'l_migrationsessionlist_objects' => 'Sort session list by migration objects.',
    'l_migrationsessionlist_start_date' => 'Sort session list by start date.',
    'l_migrationsessionlist_elapsed' => 'Sort session list by elapsed time.',
    'l_migrationsessionlist_state' => 'Sort session list by migration state.',
    'l_migrationsessionlist_state_icon' => 'Sort session list by migration state icon',
    'b_migration_session_add' => 'Click to create a migration session.',
    'migrationsessionlist_show_all' => 'Show all migrations.',
    'migrationsessionlist_search' => 'Enter a search pattern and click to find migration by hostname.',
    'l_migrationclientslist_cp_access' => 'Sort users by permission to access Plesk.',
    'b_to_migration_manager' => 'Return to the list of migration sessions.',
    'b_to_ip_map_page' => 'Return to IP mapping.',
    'b_to_db_server_map_page' => 'Return to databases mapping.',
    'migration_upload_ipmap_file' => 'Upload IP map file.',
    'b_ipmap_download' => 'Download IP map file.',
    'b_ipmap_upload' => 'Upload IP map file.',

    'b_install' => 'Install web application',
    'ippool__submit_remove' => 'Click to remove IP addresses from IP pool',

    'b_migrationclientippool_search' => 'Enter the search pattern and click to search.',
    'b_migrationclientippool_show_all' => 'Show all IP addresses.',
    'l_migrationclientippool_type' => 'Sort the list of IP addresses by type.',
    'l_migrationclientippool_name' => 'Sort the list by IP addresses.',
    'l_migrationclientippool_clients' => 'Sort the list of IP addresses by usage by clients.',
    'l_migrationclientippool_hostings' => 'Sort the list of IP addresses by use in hosting accounts.',

    'b_migrationdomainipmaplist_search' => 'Enter the search pattern and click to search.',
    'b_migrationdomainipmaplist_show_all' => 'Show all IP addresses.',
    'l_migrationdomainipmaplist_type' => 'Sort the list of IP addresses by type.',
    'l_migrationdomainipmaplist_old' => 'Sort the list by IP addresses.',

    'b_migrationaccountsipmaplist_search' => 'Enter the search pattern and click to search.',
    'b_migrationaccountsipmaplist_show_all' => 'Show all IP addresses.',
    'l_migrationaccountsipmaplist_type' => 'Sort the list of IP addresses by type.',
    'l_migrationaccountsipmaplist_old' => 'Sort the list by IP addresses.',

    'b_migrationserverippool_search' => 'Enter the search pattern and click to search.',
    'b_migrationserverippool_show_all' => 'Show all IP addresses.',
    'l_migrationserverippool_type' => 'Sort the list of IP addresses by type.',
    'l_migrationserverippool_name' => 'Sort the list by IP addresses.',
    'l_migrationserverippool_clients' => 'Sort the list of IP addresses by usage by clients.',
    'l_migrationserverippool_hostings' => 'Sort the list of IP addresses by use in hosting accounts.',

    'b_clist__search_show' => 'Click to show search area.',
    'b_clist__search_hide' => 'Click to hide search area.',

    'l_massmailtemplateslist_name' => "Sort mass mail templates by name",
    'l_massmailtemplateslist_from' => "Sort mass mail templates by from header",
    'l_massmailtemplateslist_subject' => "Sort mass mail templates by subject",
    'l_massmailtemplateslist_cdate' => "Sort mass mail templates by creation date",
    'b_massmailtemplateslist_remove' => 'Remove the selected templates',
    'b_massmailtemplateslist_search' => 'Enter a search pattern and click to find templates.',
    'b_massmailtemplateslist_show_all' => 'Show all templates',

    'b_sb_menu_desktop' => "Go to the Presence Builder system administrator's Home page.",
    'b_sb_menu_users' => "Add and manage user accounts and service plans for your customers.",
    'b_sb_menu_sites' => "Add and manage websites.",
    'b_sb_menu_server' => "Set up Presence Builder system.",
    'b_sb_menu_logs' => "View Presence Builder system and security logs.",
    'b_sb_server_configure' => "Set up integration with Presence Builder.",
    'sb_server_configure_page_description' => "Specify the username and password that Plesk should use for authorization in Presence Builder. These username and password must be first set in Presence Builder.",
    'b_sb_site_wizard' => "Go to Presence Builder for creating and managing websites.",

    'b_connect' => 'Connect your local account to a global account.',
    'b_disconnect' => 'Disconnect your local account from a global account.',
    'b_fi_change_passwd' => 'Change password for the global account.',
    'connect' => 'Connect your local account to your global account.',
    'disconnect' => 'Disconnect your local account from your global account.',
    'fi_change_passwd' => 'Change the password for your global account.',

    'sapp__no_license_key' => 'You cannot create application packages until you add a license key to the repository of license keys',

    'b_webdirs' => 'Web directories management.',

    'b_dns__tabs_general' => 'General DNS settings page.',
    'sessions__tabs_soa_record' => 'SOA Record customization.',

    'packages_preinstall' => 'Web Application installation settings.',

    'packages_info_server' => 'Viewing information on the application package.',
    'packages_info_domain' => 'Viewing information on the application package.',
    'b_to_packages_info' => 'Return to the package information page.',
    'packages_install' => 'The application package installation.',

    'b_friend_domain_add' => 'Add a website address to the list of friendly websites. ',
    'b_friend_domain_remove' => 'Remove selected website addresses from the list of friendly websites.',

    'b_server_app_add' => 'Click to go to the new server application installation page.',
    'b_help_install' => 'Start application installation.',
    'b_help_cancel' => 'Cancel application installation.',
    'packages_reconfigure' => 'Server Application Reconfiguring.',
    'packages_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',

    'b_packages_management' => 'Server Applications management.',
    'packages_management' => 'This page allows to install to and remove server applications from the server.',
    'b_to_packages_management' => 'Return to the server applications management page.',
    'packageslist_remove' => 'Click to remove the selected server applications from the server.',

    'i_ftp_ses_type' => 'The last command sent by customer is TYPE.',
    'i_ftp_ses_pass' => 'The last command sent by customer is PASS.',
    'i_ftp_ses_noop' => 'The last command sent by customer is NOOP.',

    'firewall_main' => 'Firewall management.',
    'b_interfacelist_search' => 'Enter a pattern and click to find network interfaces.',
    'b_interfacelist_show_all' => 'Show all network interfaces.',
    'l_interfacelist_enabled' => 'Sort by firewall status',
    'l_interfacelist_status' => 'Sort by interface status',
    'l_interfacelist_name' => 'Sort by interface name',
    'l_interfacelist_type' => 'Sort by interface type',
    'b_firewall__off' => 'Disable firewall on the interface.',
    'b_firewall__on' => 'Enable firewall on the interface.',
    'b_firewall__rule_add' => 'Add a firewall rule.',
    'b_firewall__reset' => 'Reset the firewall to default settings.',
    'b_firewall__panic' => 'Enable Panic Mode.',
    'b_rulelist_search' => 'Enter a pattern and click to find rules.',
    'b_rulelist_show_all' => 'Show all firewall rules.',
    'b_rulelist_remove' => 'Remove the selected rules.',
    'i_firewall_rule_true' => 'The firewall passes through packets matching the rule.',
    'i_firewall_rule_false' => 'The firewall filters out packets matching the rule.',
    'b_to_firewall_interface' => 'Return to the network interface page.',
    'b_to_firewall' => 'Return to the firewall page.',
    'i_firewall_true' => 'The firewall is turned on for this network interface.',
    'i_firewall_false' => 'The firewall is turned off for this network interface.',
    'i_firewall_connection_on' => 'The network interface connection is turned on.',
    'i_firewall_connection_off' => 'The network interface connection is turned off.',
    'firewall_interface' => 'Firewall settings page for chosen network interface',
    'firewall_rule_edit' => 'Firewall rule editing page',
    'l_rulelist_enable' => 'Sort rules by activity status',
    'l_rulelist_name' => 'Sort rules by name',
    'l_rulelist_port' => 'Sort rules by affected port',
    'i_farewall_general_false' => 'Firewall is disabled. Click Enable to turn on firewall protection.',

    'virtualdirs__remove_submit' => 'Click to delete selected virtual directories. The actual physical directories are not deleted.',

    'b_maillists__disabled_by_server' => 'The current mail server does not support external mailing lists management.',

    'b_set_skin' => 'Click to make the current skin a default Plesk skin.',
    'set_skin__already_default' => 'The current skin is already set to be a default Plesk skin.',

    'i_custom_errors_add' => 'Enter the necessary information and click to add a custom error message.',

    'i_antivirus_off' => 'Antivirus protection is not enabled for this mailbox.',
    'i_antivirus_on' => 'Antivirus protection is enabled for this mailbox.',
    'i_antivirus_turn_pref' => 'Click to set up antivirus protection settings.',
    'i_antivirus_turn_key' => 'Antivirus protection is not supported with the current license key.',
    'i_antivirus_turn_perm' => 'You do not have permissions for managing antivirus.',

    'l_mailnameslist_antivirus' => 'Sort by antivirus protection status.',

    'b_dnsacllist_show_all' => 'Click to view all the addresses.',
    'b_dnsacllist_' => 'Click to remove the selected addresses.',
    'b_acl_add' => 'Click to add an address to Allow Zone Transfer ACL.',
    'dns_acl' => 'This page displays a list of all IP and Network addresses for which zone transfer is allowed.',
    'b_dnsacllist_search' => 'Enter a pattern and click to search addresses.',

    'i_antivirus_any' => 'Antivirus protection is set for incoming and outgoing mail.',
    'i_antivirus_from' => 'Antivirus protection is set for outgoing mail.',
    'i_antivirus_to' => 'Antivirus protection is set for incoming mail.',

    'i_ip_fail_no_interface' => 'Interface associated with the IP address is absent.',

    'b_test' => 'Test connection.',

    'b_language_groups_add' => 'Add language group to the list of trusted languages.',
    'b_language_groups_del' => 'Delete language group from the list of trusted languages.',
    'b_locale_groups_add' => 'Add locale group to the list of trusted locales.',
    'b_locale_groups_del' => 'Delete locale group from the list of trusted locales.',
    'spam_trustednetworks_new' => 'Add the network to the list of trusted networks.',
    'spam_trustednetworks_remove' => 'Delete the network from the list of trusted networks.',


    'i_i_client_on' => 'Customer account is active.',
    'i_i_client_off_by_admin' => 'Customer account is disabled by administrator.',


    'b_virtualdir_add_disabled' => 'The virtual directory creation is unavailable.',

    'b_firewall__icmp_reset' => 'Return to the default settings.',
    'b_firewall__icmp_panic' => 'Turn on panic mode.',
    'i_firewall_icmp_true' => 'The rule is active.',
    'i_firewall_icmp_false' => 'The rule is not active.',

    'l_icmpsettingslist_enabled' => 'Sort by firewall rule status.',
    'l_icmpsettingslist_name' => 'Sort by rule name.',

    'icmpsettingslist_search' => 'Enter a search pattern and click to find rules.',
    'icmpsettingslist_show_all' => 'Show all rules.',

    'b_db_add_disabled' => 'Your database server connection is not configured. It can be set up on the Server->Database page.',

    'b_databases__change_server_passwd_disabled' => "You are using the Plesk's internal database server because you have configured the connection with port 8306. Therefore, the password should be changed on Settings > Change Password page.",

    'b_traffic_at_domains' => 'Viewing traffic statistics at the domains of the server.',
    'traffic_at_domains' => 'Traffic statistics at the all domains registered in the system.',

    'firewall__general_on' => 'Turn on the firewall protection.',
    'firewall__general_off' => 'Turn off the firewall protection.',
    'firewall_icmp' => 'ICMP protocol firewall setup.',

    'b_rdp_session__open_new' => 'Open new terminal session.',

    'l_dnsacllist_val' => 'Sort networks by value.',
    'b_dnsacllist_remove' => 'Remove selected network from the access common list.',

    'l_dnsmasterslist_ip' => 'Sort DNS master servers by IP address.',

    'removeDNS_acl' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',

    'l_dsnlist_host' => 'Sort DSNs by host name.',
    'l_dsnlist_driver' => 'Sort DSNs by driver name.',

    'b_defaultdoc_add' => 'Click to add a file to the list.',
    'b_defaultdoc_remove' => 'Click to remove the selected file(s) from the list.',
    'b_defaultdoc_up' => 'Click to move the selected document up in the list.',
    'b_defaultdoc_down' => 'Click to move the selected document down in the list.',

    'i_firewall_rule_set_false' => 'Click here to disable filtering of messages matching the rule.',
    'i_firewall_rule_set_true' => 'Click here to enable filtering of messages matching the rule.',

    'l_additionalkeylist_status' => 'Sort keys by status.',
    'i_additional_key_installed' => 'The key is installed to the application.',
    'i_additional_key_not_installed' => 'The key is not installed to the application.',

    'odbc_connection_config_excel' => 'Configuring ODBC connection for Microsoft Excel driver.',

    'b_unhandlederror_showinfo' => 'Click to view detailed information on the error.',
    'b_unhandlederror_hideinfo' => 'Click to hide additional information on the error.',
    'b_unhandlederror_submitticket' => 'Click to report the error to Support service.',
    'unhandlederror' => 'Operation failure.',

    'permissions' => 'Setting up file or folder permissions.',
    'i_permissions_userlist_add' => 'Click to add the selected group or user to the list for assigning permissions.',
    'i_permissions_userlist_add_disabled' => 'Adding the selected group or user is unavailable.',
    'i_permissions_userlist_del' => 'Click to remove the permission entry from the list.',
    'i_permissions_userlist_del_disabled' => 'Removing this permission entry is unavailable.',

    'l_clienttrafficlist_client' => 'Sort domains by owner\'s name.',

    'permissions_advanced' => 'Setting up advanced file or folder permissions.',
    'l_domainslist_client' => 'Sort domains by owner\'s name.',

    'l_updateslist_description' => 'Sort updates by description.',

    'b_aspdotnet__change_version' => 'Click to change the framework version.',
    'b_aspdotnet__change_version_disabled' => 'Changing framework version is unavailable.',
    'aspdotnet_changeversion' => 'Changing framework version.',
    'to_aspdotnet' => 'Return to the ASP.NET Configuration page.',

    'i_conn_strings_add' => 'Click to add the connection string.',
    'i_conn_strings_add_disabled' => 'Adding connection strings is unavailable.',
    'i_conn_strings_del' => 'Click to delete the connection string.',
    'i_conn_strings_del_disabled' => 'Deleting connection strings is unavailable.',

    'dns_acl_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',

    'to_interface_management' => "Return to the interface management page.",
    't_locales' => "Click to manage interface languages.",
    't_skins' => "Click to manage skins.",
    't_interface_templates' => "Click to manage interface templates.",
    'b_locale_make_default' => "Select a language pack and click to make it default.",
    'b_skin_make_default' => "Select a skin and click to make it default.",

    'wu_limits_exceeding' => "You cannot create web users because the limit on the number of supported web users is exceeded for this domain.",

    'mail_setenable_off' => 'This feature is not supported by the mail server.',
    'domain_aliases__status_ok' => 'Domain alias is working correctly.',

    'i_htype_sub_hst' => 'Subdomain on subfolder.',
    'mail_antivirus' => 'Antivirus settings.',

    'dom_new_no_clients' => 'You need to create a customer account before you can add domains.',

    'dns_t_acl' => 'Access Control List settings.',
    'b_dnszonetemplateacllist_search' => 'Enter a search pattern and search for DNS zone template records.',
    'b_dnszonetemplateacllist_show_all' => 'Show all DNS zone template records.',
    'b_dnszonetemplateacllist_remove' => 'Remove the selected DNS zone template records.',
    'l_dnszonetemplateacllist_host' => 'Sort DNS zone template records by host.',
    'l_dnszonetemplateacllist_type' => 'Sort DNS zone template records by type.',
    'l_dnszonetemplateacllist_val' => 'Sort DNS zone template records by value.',

    'b_filemanager__new_dir_disabled' => 'Cannot create a folder in this folder.',

    'site_apps_list_subdomain' => "Subdomain's application repository.",

    'dns_t_acl_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'b_sapp_make_default' => "Make selected web application a default one",

    'b_ftp_ctrl' => "Manage additional FTP accounts under a domain.",
    'ftp_ctrl' => "Managing additional FTP accounts under domain.",
    'b_ftp_user_add' => "Click to add an FTP account.",
    'b_ftp_users_limit_reached' => "The limit on number of FTP accounts was reached.",
    'ftp_user_edit' => "FTP account settings.",
    'l_ftpuserslist_name' => "Sort FTP accounts by name.",
    'l_ftpuserslist_home' => "Sort FTP accounts by home directory.",
    'ftp_users' => "Manage additional FTP accounts under a domain.",
    'ftpuserslist_search' => "Enter a search pattern and search for FTP accounts.",
    'removeFtpUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'to_ftp_ctrl' => "Return to FTP accounts management page.",

    'b_sb_desktop' => "Overview of main Presence Builder functionalities.",
    'b_sb_users' => "Manage user accounts registered in Presence Builder.",
    'b_sb_sites' => "Add and manage various types of Presence Builder sites.",
    'b_sb_server' => "Presence Builder administration.",
    'b_sb_logs' => "View records of Presence Builder system and security logs.",

    'dns_recursion' => "DNS recursion management.",

    'subdom_hst_type_sel' => "Select the type of hosting to set up for subdomain.",

    'i_wu_open_help' => "Click to open the web user page in browser.",

    'i_i_client_off_expired' => "Validity period for this customer account has expired.",

    'i_antivirus_turn_install' => 'Antivirus is not installed or properly configured.',
    'i_trusted_networks_add' => "Add a network to the list of trusted networks",
    'i_trusted_networks_del' => "Remove a network from the list of trusted networks",

    'b_ftp_users_no_permission' => "You do not have permissions to manage additional FTP accounts.",

    // Plesk 8 keys

    'b_search' => "Search for customers, domains and mail accounts.",

    // services management
    'b_service_showall' => 'Show all services.',
    'b_service_hideall' => "Hide all services.",
    'b_service_start' => "Start selected services.",
    'b_service_stop' => "Stop selected services.",
    'b_service_restart' => "Restart selected services.",
    'b_service_disable' => "Disable selected services.",
    'b_service_manual' => "Select manual startup type for selected services.",
    'b_service_auto' => "Select automatic startup type for selected services.",
    'i_serv_group_on' => 'All services in group are running.',
    'i_serv_group_none' => 'Some of the services in the group are disabled or stopped.',
    'i_serv_group_off' => 'All services in group are disabled or stopped.',
    'i_serv_key_disabled' => 'Service disabled.',
    'l_serviceslist_startup' => 'Sort services by startup type.',

    // php4v5
    'php' => "View and change PHP settings for current virtual directory.",
    'php_changeversion' => "PHP configuration for current directory.",
    'php_dom' => "Change PHP settings for domain.",
    'php_subdom' => "Change PHP settings for subdomain.",
    'php_changeversion_dom' => "PHP configuration for domain.",
    'php_changeversion_subdom' => "PHP configuration for subdomain.",

    // mass mail
    'l_massmailtemplateslist_receivers' => "Sort mass email message templates by recipients",
    'l_massmailtemplateslist_created' => "Sort mass email message templates by author",
    'l_massmailtemplateslist_crdate' => "Sort mass email message templates by creation date",
    'b_new_mass_mail_template' => 'Add a mass email message template',
    'b_massmail_send' => "Send email to all selected recipients",

    // Other
    '__max_odbc_num_reached' => "The limit on the number of ODBC connections was reached.",
    'l_dumpslist_comments' => "Sort backup files by comments",
    'b_additional_key_is_install' => 'Install additional key.',
    'l_additionalkeyslist_status' => 'Sort additional license keys by status.',
    'i_domain_sitebuilder_disabled' => "Presence Builder support is disabled for this domain.",
    'i_subdomain_sitebuilder_disabled' => "Presence Builder support is disabled for this subdomain.",
    'i_subdomain_sitebuilder_wizard' => "Go to Presence Builder Wizard for this subdomain.",
    'i_domain_sitebuilder_wizard' => "Go to Presence Builder Wizard for this domain.",
    'sitebuilder_page' => 'You are currently operating in Presence Builder window. Refer to Presence Builder documentation for more information.',
    'removeFpseUsers' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'b_insert' => 'Click to insert data from the selected template into your mass email message',
    'b_mass_mail_remove' => 'Click to remove selected mass email message templates.',
    'i_firewall_general_false' => 'Firewall is disabled',
    'i_firewall_general_true' => 'Firewall is enabled',
    'i_spamfilter_turn_install' => 'Spam Filter is not installed.',

    // help desk


    // 8.1.1

    'l_servermailblockeddomainslist_action' => 'Sort black list entries by action.',

    // 8.2

    // other

    'l_ippoollist_ftps' => 'Sort IP addresses by the ability to use FTP over SSL/TLS',
    'b_db_preferences' => 'Change database connection parameters',
    'b_disabled_hosting' => 'This feature is not available because physical hosting is not configured',
    'net_apps' => 'Manage ASP.NET 1.1 web applications',
    'site_apps' => "Manage standard web applications",

    'b_default_cert' => 'Use the selected certificate for securing connections to newly hosted websites.',
    'b_setup_cp' => 'Use the selected certificate for securing connections to Plesk',
    'b_to_actionlog' => 'Return to Action Log',

    // 8.3

    'additional_key_update' => 'Status of additional key update or retrieval',
    'admin_alias_password_update' => 'Confirm password change',
    'removeTasks' => "Confirm the removal of selected tasks and click OK",

    'i_maillist_export' => 'Export mail list to a text file',

    'b_license_key_remove' => 'Click to remove the license key.',
    'l_apsdomainapplicationitemslist_name' => 'Sort by web application name.',
    'l_apsdomainapplicationitemslist_version' => 'Sort by web application version.',
    'l_apsdomainapplicationitemslist_release' => 'Sort by web application release number.',
    'l_apsdomainapplicationitemslist_license' => 'Sort by license key description.',
    'l_apsdomainapplicationitemslist_left' => 'Sort by the number of times you can install the web application.',
    'l_apsdomainapplicationitemslist_description' => 'Sort by web application description.',
    'b_apsdomainapplicationitemslist_search' => 'Enter a search pattern and click to find web applications.',
    'b_apsdomainapplicationitemslist_show_all' => 'Show all available web applications.',
    'b_apsdomainapplicationitemslist_install' => 'Install the application on the selected domain.',
    'fi-attach' => 'Specify the global account to which you want to connect.',
    'fi-detach' => 'Confirm disconnection of the current local account from a global account and click to disconnect.',
    'fi-update' => 'Update global account settings.',

    // 8.4
    // RESELLERS
    'b_resellers' => 'Manage reseller accounts',
    'b_resellerslist_remove' => "Remove selected reseller accounts.",
    'b_resellerslist_search' => "Search in the reseller accounts.",
    'b_resellerslist_show_all' => "Show all reseller accounts.",
    'l_resellerslist_traffic' => "Sort by traffic usage.",
    'l_resellerslist_disk_space' => "Sort by disk space usage.",
    'l_resellerslist_clients' => "Sort by number of customer accounts.",
    'l_resellerslist_date' => "Sort by account creation date.",
    'l_resellerslist_cname' => "Sort by company name.",
    'l_resellerslist_name' => "Sort by reseller's name.",
    'l_resellerslist_status' => "Sort by account status (suspended or active).",
    'l_resellerslist_resource' => "Sort by resource usage criteria (overusing or not overusing).",
    'b_adminresellertrafficlist_show_all' => 'Show all reseller accounts',
    'b_adminresellertrafficlist_search' => 'Enter a search pattern and click to find reseller accounts',
    'l_adminresellertrafficlist_name' => "Sort by reseller's name.",
    'l_adminresellertrafficlist_used' => "Sort by usage.",
    'l_adminresellertrafficlist_limit' => "Sort by traffic limit.",
    'l_adminresellertrafficlist_avail' => 'Sort by available amount of traffic',
    'l_adminresellertrafficlist_ubar' => 'Sort by used amount of traffic',
    'i_reseller_on' => "This user account is active.",
    'i_reseller_off_by_admin' => "This user account was suspended by the service provider.",
    'i_reseller_off_by_parent' => "This user account was suspended by the service provider.",
    'i_reseller_off_by_expired' => "The subsription term for this user account has expired.",
    'i_reseller_off_backup_restore' => "This user account was temporarily suspended for backing up or restoring data.",
    'i_reseller_off' => "This user account was suspended.",
    'i_reseller_ok' => "Resource usage of the reseller is within limits.",
    'i_reseller_!' => "Resource usage of the reseller is exceeding limits.",
    'i_reseller_cp_access_on' => "Access to Plesk is allowed for the reseller.",
    'i_reseller_cp_access_off' => "Access to Plesk is not allowed for the reseller.",
    'i_click_to_reseller_on_off' => "Click to suspend or activate this user account.",
    'i_click_to_report' => "Click to view a brief usage report.",
    'i_click_to_reseller_cp_access_on_off' => "Click to allow or prohibit access to Plesk for the reseller.",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'Discard any changes and return to the previous page.',
    'b_upgradeClients__submit_upgrade' => 'Click to convert eligible customer accounts to reseller accounts.',
    'b_upgradeDomainUser__cancel_upgrade' => 'Discard any changes and return to the previous page.',
    'b_upgradeDomainUser__submit_upgrade' => 'Click to convert eligible domain administrator accounts to customer accounts.',

    //Clients > View traffic by clients

    'l_adminclienttrafficlist_type' => "Sort by account type.",
    'l_adminclienttrafficlist_name' => "Sort by user name.",
    'l_adminclienttrafficlist_owner' => "Sort by owner.",
    'l_adminclienttrafficlist_personal' => "Sort by the amount of traffic used by reseller's domains.",
    'l_adminclienttrafficlist_clients' => "Sort by the amount of traffic used by clients.",
    'l_adminclienttrafficlist_limit' => "Sort by the resource usage limits.",
    'l_adminclienttrafficlist_avail' => "Sort by the amount of available resources.",
    'l_adminclienttrafficlist_ubar' => "Sort by the amount of used resources.",

    // Reseller's session in the control panel
    'l_clientslist_resource' => "Sort by resource usage criteria (overused/not overused).",
    'l_clientslist_owner' => 'Sort customer accounts by customer owner',

    // DOMAINS (upgraded for resellers)

    'l_domainslist_owner' => 'Sort domains by owner',
    'l_domainslist_disk_space' => 'Sort domains by disk space usage',

    //APS Catalog
    'b_hide_updates' => "Hide updates.",
    'b_show_updates' => "Show updates.",
    'b_add_to_vault' => "Add the selected applications to the Application Vault.",

    // new and unsorted
    'b_to_server_interface' => "Return to the list of available skins.",
    'b_skin_edit' => "Edit skin description.",
    'b_to_phosting_setup' => "Return to hosting settings.",
    'l_personaltrafficlist_name' => "Sort by domain name.",
    'l_personaltrafficlist_owner' => "Sort by owner.",
    'l_personaltrafficlist_used' => "Sort by the amount of used traffic.",
    'l_personaltrafficlist_clients' => "Sort by the amount of traffic used by clients.",
    'l_personaltrafficlist_limit' => "Sort by the resource usage limits.",
    'l_personaltrafficlist_avail' => "Sort by the amount of available resources.",
    'l_personaltrafficlist_ubar' => "Sort by the amount of used resources.",
    // Hosting setup redesign
    'b_dom_hosting_update' => "Save hosting settings.",
    'b_downgradeResellers__submit_downgrade' => "Click to complete the operation.",
    'b_rs_pool_add' => "Allocate IP addresses to the reseller.",
    'b_cl_pool_add' => "Allocate IP addresses to the client.",
    'b_ippoolManager__no_available_ips' => "There are no vacant IP addresses in the IP pool.",
    'b_ip_already_added_to_all_clients' => "This IP address is already in IP pools of all users.",
    'i_click_to_client_on_off' => 'Suspend or activate this user account.',

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'Change server hostname.',
    'b_setup_firewall_conhelp' => 'Set up firewall to protect the server.',
    'b_setup_firewall_none_available_conhelp' => 'Firewall functionality is not available: firewall is not installed.',
    'b_manage_firewall_rules_conhelp' => 'Create, edit and remove firewall rules.',
    'b_manage_firewall_rules_none_available_conhelp' => 'Firewall functionality is not available: firewall is not installed.',
    'b_select_dns_server_conhelp' => 'Select DNS server software that should be used by the server and managed by Plesk.',
    'b_select_dns_server_none_available_conhelp' => 'No other DNS servers are available.',
    'b_soa_records_template_conhelp' => 'Configure SOA records that will be used as a template when creating DNS zone for domains.',
    'b_dns_recursion_conhelp' => 'Configure DNS recursion settings that will be used as a template when creating DNS zone for domains.',
    'b_restrict_creation_of_subzones_conhelp' => "Restrict the creation of DNS subzones in other users' DNS superzones",
    'b_select_mssqlwebadmin_conhelp' => 'Select MS SQL WebAdmin software that should be used for managing MS SQL databases.',
    'b_select_mssqlwebadmin_none_available_conhelp' => 'No other MS SQL WebAdmin programs are available.',
    'b_select_mailserver_conhelp' => 'Select mail server software that should be used by the server and managed by Plesk.',
    'b_select_mailserver_none_available_conhelp' => 'No other mail servers are available.',
    'b_select_antivirus_conhelp' => 'Select antivirus software that should be used by the server and managed by Plesk.',
    'b_select_antivirus_none_available_conhelp' => 'No other antivirus programs are available.',
    'b_virus_protection_settings_conhelp' => 'Configure server-wide virus protection settings.',
    'b_select_spamfilter_conhelp' => 'Select spam filtering software that should be used by the server and managed by Plesk.',
    'b_select_spamfilter_none_available_conhelp' => 'No other spam filtering programs are available.',
    'b_select_webmail_conhelp' => 'Select webmail software that should be available to email users.',
    'b_select_webmail_none_available_conhelp' => 'No other webmail programs are available.',
    'b_server_statistics_settings_conhelp' => 'Select what should be included in calculations of server-wide statistics.',
    'b_select_ssl_certificate_conhelp' => 'Select SSL/TLS certificate to be used for protecting your domain.',
    'b_select_ssl_certificate_none_available_conhelp' => 'Web hosting is required to have access to this feature.',
    'b_select_web_statistics_conhelp' => 'Select web statistics software that should be available to domain owners.',
    'b_select_web_statistics_none_available_conhelp' => 'No other web statistics programs are available.',
    'b_interface_management_conhelp' => 'Set up various Plesk interface options.',
    'b_setup_watchdog_conhelp' => 'Set up Watchdog server monitoring module.',
    'b_setup_watchdog_none_available_conhelp' => 'Watchdog module is not installed.',
    'b_setup_vpn_conhelp' => 'Set up VPN access on the server.',
    'b_setup_vpn_none_available_conhelp' => 'VPN access extension is not installed.',
    'b_setup_samba_conhelp' => 'Set up samba access on the server.',
    'b_setup_samba_none_available_conhelp' => 'Samba access extension is not installed.',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'View and change your account settings.',
    'b_dns_soa_records_conhelp' => 'View and change DNS SOA records for your domain.',
    'b_task_scheduler_settings_conhelp' => 'Set up task scheduler for your domain.',
    'b_task_scheduler_settings_none_available_conhelp' => 'Web hosting is required to have access to this feature.',
    'b_web_users_scripting_conhelp' => 'Allow or prohibit web users to use scripts.',
    'b_web_statistics_conhelp' => 'View visiting statistics for your domain.',
    'b_log_rotation_settings_conhelp' => 'Set up rotation of logs on your domain.',

    // navbar
    'b_mailnames' => 'Go to the list of mail accounts.',
    'b_applications' => 'Go to the list of web applications.',
    'b_settings' => 'Configure a variety of settings.',

    'b_adminclienttrafficlist_show_all' => 'Show all client accounts.',
    'b_adminclienttrafficlist_search' => 'Enter a search pattern and click to find client accounts.',

    // billing
    'l_clientslist_balance' => 'Sort user accounts by balance',
    'l_resellerslist_balance' => 'Sort user accounts by balance',

    // spam stats
    'b_servermailstatisticsvirusrecipientslist_search' => 'Enter a search pattern and click to find virus recipients',
    'b_servermailstatisticsvirusrecipientslist_show_all' => 'Show all virus recipients',
    'b_servermailstatisticsvirusviruseslist_search' => 'Enter a search pattern and click to find viruses',
    'b_servermailstatisticsvirusviruseslist_show_all' => 'Show all viruses',

    // templates
    'i_tmpl__shared_template' => 'This template was made by your hosting provider. It can be used by you, since your hosting provider is sharing it.',
    'i_tmpl__owned_template' => 'This template was made by you. It can be used by you and your users, if you permit that.',

    // reseller
    'i_client_is_reseller' => 'This user is a reseller.',

    'b_load' => 'Load message from previously saved template.',

    'b_sh_ip_add' => 'Add IP address to the list of shared IP addresses',
    'b_sh_ip_del' => 'Remove IP address from the list of shared IP addresses',

    'b_icmpsettingslist_search' => 'Enter a search pattern and click to find ICMP protocol firewall rules.',
    'b_icmpsettingslist_show_all' => 'Show all available ICMP protocol firewall rules.',

    // mail queue

    'b_postfixmailqueuelist_remove' => 'Remove selected messages from the queue.',
    'b_postfixmailqueuelist_search' => 'Enter a search pattern and click to find messages in the queue.',
    'b_postfixmailqueuelist_show_all' => 'Show all messages in the queue.',

    'b_qmailmailqueuelist_remove' => 'Remove selected messages from the queue.',
    'b_qmailmailqueuelist_search' => 'Enter a search pattern and click to find messages in the queue.',
    'b_qmailmailqueuelist_show_all' => 'Show all messages in the queue.',

    'l_postfixmailqueuelist_age' => 'Sort messages in the queue by age.',
    'l_postfixmailqueuelist_date' => 'Sort messages in the queue by date.',
    'l_postfixmailqueuelist_queue' => 'Sort messages in the queue by queue type.',
    'l_postfixmailqueuelist_recipients' => 'Sort messages in the queue by recipients.',
    'l_postfixmailqueuelist_sender' => 'Sort messages in the queue by sender.',
    'l_postfixmailqueuelist_size' => 'Sort messages in the queue by size.',
    'l_postfixmailqueuelist_subject' => 'Sort messages in the queue by subject.',

    'l_qmailmailqueuelist_age' => 'Sort messages in the queue by age.',
    'l_qmailmailqueuelist_date' => 'Sort messages in the queue by date.',
    'l_qmailmailqueuelist_queue' => 'Sort messages in the queue by queue type.',
    'l_qmailmailqueuelist_recipients' => 'Sort messages in the queue by recipients.',
    'l_qmailmailqueuelist_sender' => 'Sort messages in the queue by sender.',
    'l_qmailmailqueuelist_size' => 'Sort messages in the queue by size.',
    'l_qmailmailqueuelist_subject' => 'Sort messages in the queue by subject.',

    // new

    'b_longtasklist_remove' => 'Remove selected background tasks.',
    'b_longtasklist_search' => 'Enter a search pattern and click to find background tasks.',
    'b_longtasklist_show_all' => 'Show all background tasks.',
    'l_longtasklist_name' => 'Sort background tasks by task name.',
    'l_longtasklist_owner' => 'Sort background tasks by task owner.',
    'l_longtasklist_status' => 'Sort background tasks by task status.',
    'l_longtasklist_start_time' => 'Sort background tasks by the start time.',
    'l_longtasklist_finish_time' => 'Sort background tasks by the finish time.',
];
