<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: huluan menghantar pengepala terlalu besar semasa membaca pengepala respons"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Ralat Pelayan Dalaman: Pilihan FollowSymLinks tidak dibenarkan di sini"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Simptom</h4><ul><li><p>Tapak web yang mempunyai pengendali PHP ditetapkan sebagai <strong>aplikasi FPM yang disediakan oleh Apache</strong> atau<strong>Aplikasi FPM disampaikan oleh nginx</strong> di<strong>Domain</strong> &gt; <strong>example.com</strong> &gt; <strong>Tetapan PHP</strong> mengalami salah satu daripada isu berikut:</p><ul><li><p>muat perlahan-lahan</p></li><li><p>tidak boleh diakses (secara kekal atau berkala) dengan ralat 50x dalam pelayar web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Servis tergendala sebentar</pre><hr><pre>504 Gateway Tamat masa</pre></li></ul></li><li><p>Mesej berikut muncul dalam fail log ralat PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (di mana <em>XX</em> ialah versi PHP yang digunakan oleh laman web):</p><pre>AMARAN: [pool example.com] pelayan mencapai tetapan max_children (*), pertimbangkan untuk menaikkannya</pre><ul><li><p>Mesej di atas biasanya disertakan dengan ralat ini:</p><pre>tidak dapat membaca apa yang kanak-kanak katakan: Deskriptor fail buruk (9)</pre></li></ul></li><li><p>Jika nginx didayakan pada pelayan, salah satu daripada mesej ralat berikut mungkin muncul dalam fail log ralat domain <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 sambung() ke unix:///var/www/vhosts/system/example.com/php-fpm.sock gagal (11: Sumber tidak tersedia buat sementara waktu) semasa menyambung ke huluan, pelanggan: 203.0.113.2, pelayan: example.com, minta: "GET / HTTP/1.1", huluan: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", hos: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 sambungan tertutup pramatang huluan semasa membaca pengepala respons daripada huluan, pelanggan: 203.0.113.2, pelayan: example.com, minta: "POST /path/to/some/file HTTP/2.0", huluan:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> telah dicapai oleh laman web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Increase the pm.max_children limit',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Tingkatkan <code>pm.max_children</code> had untuk domain yang terjejas:</p><ol><li><p>Sambung ke pelayan Plesk melalui <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Cari domain yang terjejas menggunakan arahan di bawah:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> Nombor di sebelah kiri menunjukkan berapa kali <code>pm.max_children</code> had telah dicapai oleh laman web.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Log masuk ke Plesk</a>.</p></li><li><p>Go to <strong>Domain</strong> &gt; <strong>example.com</strong> &gt; <strong>Tetapan PHP</strong> &gt; <strong>Tetapan PHP-FPM</strong>.</p></li><li><p>Tingkatkan <code>pm.max_children</code> nilai untuk domain dan gunakan perubahan. Tingkatkan nilai ini untuk semua domain yang disenaraikan dalam langkah 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Terlalu banyak fail terbuka"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx gagal untuk memulakan/muat semula pada pelayan Plesk: Terlalu banyak fail yang terbuka</p><h4>Simptom</h4><ul><li><p>Perkhidmatan nginx gagal dimulakan/muat semula dengan ralat berikut dalam <code>/var/log/nginx/error.log</code> fail:</p><pre style="white-space: pre-wrap;">nginx: [emerg] buka () "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" gagal (24: Terlalu banyak fail yang terbuka)</pre></li><li><p>Beberapa atau semua laman web tidak boleh diakses</p></li><li><p>Amaran ditunjukkan dalam <strong>Alatan&amp; Tetapan&gt; Diagnos &amp; baiki</strong>:</p><pre style="white-space: pre-wrap;">Menyemak nilai nginx ULIMIT N domain telah ditemui pada pelayan. Masalah dengan had lalai nginx untuk fail terbuka adalah mungkin</pre></li><li><p>Aplikasi web NodeJS dan Ruby menunjukkan ralat 502 Bad Gateway apabila melakukan beberapa tugas Plesk seperti membuat domain, langganan, perubahan pada Apache atau Nginx, dll:</p><pre style="white-space: pre-wrap;">Ralat Pelayan<br>502 Bad Gateway <br>Pelayan web menerima respons yang tidak sah semasa bertindak sebagai gerbang atau pelayan proksi.</pre></li><li><p>Selepas<a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">memasang sijil baharu untuk domain</a>, yang lama masih ditunjukkan dalam pelayar web, bagaimanapun, sijil yang betul dipilih di <strong>Domain &gt; example.com &gt; Halaman Tetapan </strong> Pengehosan.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Hos maya Nginx membuka 4 fail log untuk setiap hos maya dengan pengehosan fizikal:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Akibat fakta ini, bilangan maksimum fail terbuka melebihi oleh pelayan nginx disebabkan oleh sejumlah besar domain (biasanya, lebih daripada 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Increase the open files limit',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Amaran:</strong> Pelaksanaan <code>websrv_ulimits</code> utiliti tanpa <strong>--no-restart</strong> pilihan memulakan pembinaan semula fail konfigurasi web untuk semua domain dan boleh menyebabkan masa henti yang ketara sekiranya terdapat sejumlah besar laman web yang dihoskan.<br><br>Laksanakan arahan semasa rangka masa penyelenggaraan.</div><p>Amalan yang baik untuk menetapkan nilai had fail terbuka lebih daripada <strong>bilangan domain dalam Plesk * 16</strong> sekurang-kurangnya. Dalam contoh di bawah menyediakan tindakan cara menetapkan had kepada 4096:</p><ol><li><p>Sambung ke pelayan melalui <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Tetapkan had fail terbuka kepada 4096 untuk kedua-dua Apache dan Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Mulakan semula perkhidmatan Apache dan nginx di <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Alatan &amp; Tetapan &gt; Pengurusan Perkhidmatan</strong> untuk membuat perubahan.</p></li><li><p>Semak bahawa \'Had fail terbuka maksimum\' telah digunakan dengan betul, selepas perkhidmatan web dimulakan semula:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Fail buka maks 4096 4096 fail</pre></li><li><p>Jika penyelesaian di atas tidak membantu, tetapkan had menggunakan utiliti <code>tanpa had</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Badan tindak balas terlalu besar"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Akses dinafikan dengan kod 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Ralat Pelayan Dalaman 500: Saiz memori yang dibenarkan XXX habis"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "sekatan open_basedir berkuat kuasa"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: klien dinafikan oleh konfigurasi pelayan"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Tidak boleh mengakses direktori laman web dalam Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Tidak boleh mengakses direktori laman web di Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "pelayan mencapai tetapan MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Had badan permintaan PHP "pelanggan bertujuan untuk menghantar badan terlalu besar"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Had badan permintaan PHP "pelanggan bertujuan untuk menghantar badan terlalu besar"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesi PHP "Ralat Pelayan Dalaman 503" atau "Gagal membaca data sesi"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: tidak dapat menyemak fail htaccess, pastikan ia boleh dibaca"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];