<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Ungültiger Wert: "%value%". Der Wert muss zwischen %unitMin% und %unitMax% liegen (beide eingeschlossen) und darf nicht 0 sein.',
    'cgroups.unlimited' => 'Unbegrenzt',
    'cgroups.period' => 'Ungültiger Wert: "%value%". Der Wert muss in Sekunden angegeben werden und 5 Minuten, 1 Stunde oder 1 Tag entsprechen (300, 3600 oder 86400).',

    'file.fileIsImageFalseType' => 'Die Datei, die Sie versuchen hochzuladen, ist kein Bild.',
    'file.fileUploadErrorIniSize' => 'Die hochzuladende Datei überschreitet die für ini-Dateien festgelegte Größe.',
    'file.fileUploadErrorFormSize' => 'Die hochzuladende Datei überschreitet die festgelegte Formulargröße.',
    'file.fileUploadErrorPartial' => 'Die Datei wurde nur teilweise hochgeladen.',
    'file.fileUploadErrorNoFile' => 'Die Datei wurde nicht hochgeladen.',
    'file.fileUploadErrorNoTmpDir' => 'Es wurde kein temporäres Verzeichnis für die hochzuladende Datei gefunden.',
    'file.fileUploadErrorCantWrite' => 'Die hochzuladende Datei kann nicht geschrieben werden.',
    'file.fileUploadErrorExtension' => 'Die Erweiterung gab beim Hochladen der Datei einen Fehler zurück.',
    'file.fileUploadErrorAttack' => 'Die Datei wurde unerlaubt hochgeladen. Dies kann ein Eindringversuch sein.',
    'file.fileUploadErrorFileNotFound' => 'Die hochzuladende Datei konnte nicht gefunden werden.',
    'file.fileUploadErrorUnknown' => 'Beim Hochladen der Datei ist ein unbekannter Fehler aufgetreten.',
    'file.fileExtensionFalse' => 'Die Datei, die Sie hochladen möchten, hat eine nicht zulässige Erweiterung.',
    'file.fileExistsDoesNotExist' => 'Die angegebene Datei oder das Verzeichnis existiert nicht.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' scheint eine IP-Adresse zu sein, aber IP-Adressen sind nicht zulässig.",
    'hostname.hostnameUnknownTld' => "'%value%' scheint ein DNS-Hostname zu sein, kann aber TLD nicht mit bekannten Liste abgleichen.",
    'hostname.hostnameDashCharacter' => "'%value%' scheint ein DNS-Hostname zu sein, weist aber einen Strich (-) an ungültiger Stelle auf.",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' scheint ein DNS-Hostname zu sein, entspricht aber nicht dem Hostnamen-Schema für TLD '%tld%'.",
    'hostname.hostnameUndecipherableTld' => "'%value%' scheint ein DNS-Hostname zu sein, kann aber TLD-Teil nicht extrahieren.",
    'hostname.hostnameInvalidHostname' => "'%value%' entspricht nicht der erwarteten Struktur eines DNS-Hostnamens.",
    'hostname.hostnameInvalidLocalName' => "'%value%' scheint kein gültiger lokaler Netzwerkname zu sein.",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' scheint ein lokaler Netzwerkname zu sein, aber lokale Netzwerknamen sind nicht zulässig.",

    'port.notBetween' => 'Der angegebene Wert für den Port ist ungültig. Er muss zwischen 1 und 65535 (inklusive) liegen',

    'isEmpty' => 'Dieses erforderliche Feld ist leer. Sie müssen einen Wert angeben.',
    'stringLengthTooShort' => "'%value%' ist kleiner als %min% Zeichen.",
    'stringLengthTooLong' => "'%value%' ist größer als %max% Zeichen.",
    'regexNotMatch' => "'%value%' entspricht nicht dem Schema '%pattern%'.",
    'notAlnum' => "'%value%' enthält nicht-alphanumerische Zeichen. Sie dürfen nur alphanumerische Zeichen verwenden.",
    'stringEmpty' => "'%value%' ist leer.",
    'loginSyntax' => 'Zugelassene Zeichen für den Nutzernamen sind alphanumerische Zeichen, sowie Bindestrich (-), Punkt (.), einfache Anführungszeichen (\'), Prozentzeichen (%) und Unterstrich (_). Der Nutzername muss mit einem alphanumerischen Zeichen beginnen.',
    'loginExists' => 'Benutzerkonto %value% existiert bereits.',
    'cu_admin_alias__login_exists' => 'Das Benutzerkonto existiert bereits.',
    'loginPassword' => 'Das Passwort darf nicht den Benutzernamen enthalten.',
    'passwordSyntax' => 'Das Passwort enthält nicht zulässige Zeichen: %chars%.',
    'passwordLength' => 'Die Passwortlänge muss zwischen %minLength% und %maxLength% Zeichen betragen.',
    'domain_invalid_name' => 'Der angegebene Domainname ist nicht gültig. Sie müssen einen gültigen Domainnamen, wie z.B. domain.com, verwenden.',
    'dns_domain_invalid_name' => 'Der angegebene Domainname ist nicht gültig.',
    'dns_domain_template_invalid_name' => 'Das angegebene Template für Domainnamen ist nicht gültig.',
    'not_ascii_string' => 'Wert ist keine gültige ASCII-Zeichenfolge.',
    'virtual_directory_name_invalid' => 'Verwenden Sie nur alphanumerische Zeichen, Unterstriche oder Bindestriche im Verzeichnisnamen.',
    'virtual_directory_name_reserved' => 'Dieser Name ist reserviert.',
    'invalid_city_name' => 'Der eingegebene Name der Stadt ist nicht gültig',
    'invalid_country_code' => 'Ungültiger Ländercode',
    'not_specified_country_code' => 'Land ist ein erforderliches Feld. Es muss ein Land angegeben werden.',
    'invalid_system_user_login' => 'Anmeldedaten des Systembenutzers sind ungültig',
    'invalid_rfc_domain_name' => 'Der angegebene Domainname ist keine gültige RFC-Domain',
    'idn_name_conversion' => 'Domainname konnte nicht von IDN in Punycode konvertiert werden',
    'domain_label_too_long' => 'Kein Bestandteil des Domainnamens darf über 63 Zeichen lang sein.',
    'domain_label_too_long_idn' => 'Für die Domain wird ein internationalisierter Domainname verwendet. Kein Bestandteil des Namens darf über 63 Zeichen lang sein, wenn er mit Punycode umgewandelt wird.',
    'domain_starts_with_www' => 'Bitte geben Sie einen Domainnamen ohne das Präfix \'www\' ein. Das www-Präfix für die Domain wird automatisch zur Webserver-Konfiguration hinzugefügt.',
    'domain_already_exists' => 'Dieser Domainname existiert bereits.',
    'domain_without_www_already_exists' => 'Dieser Domainname existiert bereits ohne das Präfix \'www\'.',
    'domain_with_www_already_exists' => 'Dieser Domainname existiert bereits mit dem Präfix \'www\'.',
    'subdomain_conflicts_with_existing_domain' => 'Es gibt bereits eine Domain mit demselben Namen wie die Subdomain \'%value%\'.',
    'restrict_domain_creation' => 'Der angegebene Domainname ist aufgrund der serverweiten Richtlinie nicht zulässig. Kontaktieren Sie Ihren Hosting-Provider, falls die Domain Ihnen gehört.',
    'dns_record_already_exists' => 'Dieser DNS-Eintrag existiert bereits.',
    'domain_like_hostname' => 'Dieser Domainname ist mit dem Hostnamen des Servers identisch.',
    'passwordsNotMatch' => 'Die eingegebenen Passwörter stimmen nicht überein.',
    'stringsNotEqual' => 'Die Werte sind nicht identisch.',
    'equalMailAliases' => 'Der angegebene E-Mail-Alias ist derselbe wie ein anderer E-Mail-Alias.',
    'mailAliasExist' => 'Der angegebene E-Mail-Alias ist bereits vorhanden.',
    'mailNameExist' => 'Die angegebene E-Mail-Adresse ist bereits vorhanden.',
    'mailListExist' => 'Die angegebene Adresse wurde bereits einer Mailingliste zugewiesen.',
    'mailAutoReplyHeadersSpaceError' => "Header für automatische Antworten dürfen keine Leerzeichen enthalten",
    'mailAutoReplyHeadersInvalidValueError' => 'Einige Felder sind leer oder enthalten einen ungültigen Wert.',
    'sysUserExist' => 'Der angegebene Benutzername wird bereits von einem anderen Systembenutzer verwendet. Bitte geben Sie einen anderen Benutzernamen an.',
    'emailAddressInvalid' => 'Die angegebene E-Mail-Adresse ist nicht gültig. Geben Sie eine gültige Adresse an, die dem folgenden Muster entspricht: maxmuster@beispiel.com.',
    'emailAddressInvalidLocal' => 'Die angegebene E-Mail-Adresse ist nicht gültig. Die E-Mail-Adresse muss zur ausgewählten Domain gehören. Nur der Administrator kann in diesem Fall externe E-Mail-Adressen angeben.',
    'emailAddressSpecialNames' => 'Die angegebene E-Mail-Adresse ist ungültig. Der Nutzernamenteil in der Adresse darf nicht mit einem reservierten Systemnamen (wie con, lpt1, prn), getrennt durch einen Punkt (.) vom Rest des Nutzernamens, beginnen.',
    'longAddress' => 'Die E-Mail-Adresse ist zu lang.',
    'longMailboxAddressMailServer' => 'Der Benutzernamenteil der E-Mail-Adresse ist zu lang für diesen Mailserver. Bitte geben Sie einen Benutzernamen an, der nicht mehr als %%max%% Zeichen enthält.',
    'longFullAddressMailServer' => 'Die E-Mail-Adresse ist zu lang für diesen Mailserver. Bitte geben Sie eine Adresse an, die nicht mehr als %%max%% Zeichen enthält.',
    'dir_invalid_name' => 'Ungültiges Zielverzeichnis.',
    'directoryHidesDomain' => 'Dieses Verzeichnis kann nicht verwendet werden, da sie sich mit einer Website unter %path% überschneiden würde. Durch diese Überschneidung wäre die Website nicht verfügbar.',
    'directoryHidesAnotherApplication' => 'Dieses Verzeichnis kann nicht verwendet werden, da sie sich mit einer Anwendung überschneidet, die unter folgenden Pfad %path% installiert ist. Durch diese Überschneidung wäre die installierte Anwendung nicht verfügbar.',
    'directoryIsBehindAnotherApplication' => 'Dieses Verzeichnis kann nicht verwendet werden, da sie sie sich mit einer Anwendung überschneiden würde, die unter folgenden Pfad %path% installiert ist. Durch diese Überschneidung wäre die installierte Anwendung nicht verfügbar.',
    'domainLoginSyntaxWindows' => 'Der Benutzername muss mit einem Buchstaben beginnen und darf nicht länger als %%maxlength%% Zeichen sein. Sie können kleingeschriebene alphanumerische Zeichen, Bindestriche, Punkte und Unterstriche verwenden. Dies gilt nicht für das erste Zeichen. Der Benutzername kann nicht mit einem Punkt enden.',
    'domainLoginSyntaxUnix' => 'Der Benutzername darf nicht länger als %%maxlength%% Zeichen sein und kann nur alphanumerische Kleinbuchstaben, Bindestriche und Unterstriche enthalten. Der Benutzername muss mit einem Kleinbuchstaben beginnen.',
    'notLocalMssqlHost' => 'Kein Name eines lokalen MSSQL-Hosts',
    'invalidMailTo' => 'Kein gültiger mailto:-Link',
    'passwordsNotEqual' => 'Die eingegebenen Passwörter stimmen nicht überein.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "Das hochzuladende Bild '%value%' ist zu breit ('%width%'). Hochgeladene Bilder dürfen nicht breiter sein als '%maxwidth%'.",
    'fileImageSizeWidthTooSmall' => "Das hochzuladende Bild '%value%' ist nicht breit genug ('%width%'). Hochgeladene Bilde müssen mindestens '%minwidth%' breit sein.",
    'fileImageSizeHeightTooBig' => "Die Höhe des Bildes '%value%', das Sie versuchen hochzuladen, ist zu groß ('%height%'). Hochgeladene Bilder dürfen eine Höhe von '%maxheight%' nicht überschreiten.",
    'fileImageSizeHeightTooSmall' => "Die Höhe des Bildes '%value%', das Sie versuchen hochzuladen, ist zu klein ('%height%'). Hochgeladene Bilder dürfen eine Höhe von '%minheight%' nicht unterschreiten.",
    'fileImageSizeNotDetected' => "Die Größe des hochzuladenden Bildes '%value%' konnte nicht ermittelt werden.",
    'fileImageSizeNotReadable' => "Das hochzuladende Bild '%value%' konnte nicht gelesen werden.",
    'passwordConfirmation' => 'Passwort bestätigen',
    'databaseUserNameExists' => 'Ein Datenbankbenutzer mit dem Namen %value% ist bereits vorhanden.',
    'invalidUserName' => 'Der Datenbankbenutzername enthält nicht zugelassene Zeichen.',
    'longUserName' => 'Der Datenbankbenutzername besteht aus mehr als %%max%% Zeichen.',
    'forbiddenName' => 'Benutzername "%value%" für die Datenbank ist nicht zulässig.',
    'invalidAdminLogin' => 'Die Benutzerinformationen können nicht für den Administratorzugang verwendet werden. Der angegebene Benutzername ist nicht gültig. %%cause%%',
    'invalidAdminPassword' => 'Die Benutzerinformationen können nicht für den Administratorzugang verwendet werden. Das angegebene Passwort ist nicht gültig. %%cause%%',
    'passwordLengthTooShort' => "Das Passwort ist kürzer als %min% Zeichen.",
    'passwordLengthTooLong' => "Das Passwort ist länger als %max% Zeichen.",
    'passwordRegexNotMatch' => "das Passwort entspricht nicht dem Schema '%pattern%'.",
    'fileSharingEmptyFolderName' => "Sie müssen einen Ordnernamen angeben.",
    'fileSharingInvalidFolderName' => "Der angegebene Ordnername ist nicht gültig. Er darf folgende Zeichen nicht enthalten: \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "Ein Ordner mit dem angegebenen Namen kann nicht erstellt werden, da bereits ein Ordner mit diesem Namen vorhanden ist.",
    'invalidUrl' => 'Die angegebene Adresse ist nicht gültig. Sie müssen eine gültige Adresse angeben, wie z.B. http://domain.com.',
    'domainVirtualdirectoryReservedName' => 'Dieser Verzeichnis-Name ist reserviert. Bitte geben Sie einen anderen Namen für Ihr virtuelles Verzeichnis an.',
    'domainVirtualdirectoryInvalidName' => 'Ein Verzeichnisname darf nur aus alphanumerischen Zeichen, Unterstrichen und Geviertstrichen bestehen.',
    'filesharingPathUnavailable' => 'Unter der angegebenen Domain ist bereits ein Verzeichnis mit diesem Namen vorhanden. Bitte geben Sie einen anderen Verzeichnisnamen an.',
    'filesharingSslNotAvailableOnDomain' => 'Sie haben angegeben, dass sichere Links verwendet werden sollen, für die Domain wurde jedoch SSL/TLS nicht aktiviert. Wählen Sie entweder eine Domain mit SSL/TLS-Unterstützung aus oder deaktivieren Sie das Kontrollkästchen "Sichere Links generieren".',
    'filesharingSslRedirectOnDomain' => 'Für die ausgewählte Domain wurde die Option "Dauerhafte, für SEO geeignete 301-Weiterleitung von HTTP zu HTTPS" aktiviert. Wählen Sie für die Dateifreigabe entweder eine Domain aus, für die diese Option nicht aktiviert wurde, oder klicken Sie auf das Kontrollkästchen "Sichere Links zu Dateien und Ordnern erstellen".',
    'filesharingSslNotAvailableOnDefaultDomain' => 'Sie haben angegeben, dass sichere Links für IP-Adressen oder den Hostnamen des Servers verwendet werden sollen, aber solche Links können nur auf Websites mit SSL/TLS-Unterstützung erstellt werden. Richten Sie entweder eine Website mit SSL/TLS-Unterstützung ein oder deaktivieren Sie das Kontrollkästchen "Sichere Links generieren".',
    'filesharingDefaultDomainSelectedOnServerIp' => 'Sie haben eine Server-IP-Adresse ausgewählt, die einer Standarddomain zugewiesen ist. Bitte wählen Sie anstelle einer IP-Adresse eine Website als root-URL.',
    'physicalPathOnDomainAlreadyExists' => 'Ein Verzeichnis mit diesem Namen ist bereits vorhanden.',
    'virtualPathOnDomainAlreadyExists' => 'Ein virtuelles Verzeichnis mit diesem Namen ist bereits vorhanden.',
    'sysUserLoginSyntaxWindows' => 'Für den Benutzernamen sind alphanumerische Zeichen, Bindestriche (-), Punkte (.) und Unterstriche (_) erlaubt. Der Benutzername muss mit einem alphanumerischen Zeichen beginnen.',
    'sysUserLoginSyntaxUnix' => 'Für den Benutzernamen sind kleingeschriebene alphanumerische Zeichen, Bindestriche (-), Punkte (.) und Unterstriche (_) erlaubt. Der Benutzername muss mit einem alphanumerischen Zeichen beginnen.',
    'docrootNotInWebspaceRoot' => 'Das angegebene Verzeichnis befindet sich nicht im Stammverzeichnis des Abonnements.',
    'docrootContainsSpecialCharacters' => 'Der angegebene Verzeichnisname enthält nicht zulässige Zeichen.',
    'docrootWithinProhibitedDirectory' => 'Das angegebene Verzeichnis enthält ein Service-Verzeichnis.',
    'docrootWithinInstalledApplication' => 'Das angegebene Verzeichnis überschneidet sich mit einer Webanwendung, die unter folgenden Pfad %path% installiert ist.',
    'docrootIsNotDirectory' => 'Der angegebene Pfad kann nicht verwendet werden, weil er sich auf eine Datei bezieht.',
    'docrootTooLongPart' => 'Der angegebene Verzeichnisname ist zu lang.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'Es wurde eine falsche Domain ausgewählt.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'Es wurde eine falsche Telefonnummer angegeben, sie beinhaltet unzulässige Zeichen.',
    'stateInvalid' => 'Bundesstaat/Bundesland/Kanton ist falsch.',
    'zipRegexNotMatch' => 'PLZ ist falsch.',
    'limitValueInvalid' => 'Die angegebene Grenze ist ungültig.',
    'softLimitValueInvalid' => 'Der Wert muss sich im Bereich %%MIN%%..%%MAX%% befinden.',
    'outgoingMessagesLimitValueInvalid' => 'Der Wert muss sich im Bereich %%MIN%%..%%MAX%% befinden. Nur der Plesk Administrator kann diese Einstellung anpassen.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'Die Größe einer MS-SQL-Datenbankdatei muss ein ganzzahliger Wert zwischen 0 und 16 TB sein.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'Die Größe einer MS-SQL-Datenbank-Protokolldatei muss ein ganzzahliger Wert zwischen 0 und 2 TB sein.',
    'limitDiskspaceValueInvalid' => 'Die Grenze für den Speicherplatz muss ein ganzzahliger Wert zwischen 0 und 4095 TB sein.',
    'limitTrafficValueInvalid' => 'Die Traffic-Grenze muss ein ganzzahliger Wert zwischen 0 und 4095 TB/Monat sein.',
    'limitMboxQuotaValueInvalid' => 'Die Grenze für die Postfachgröße muss ein ganzzahliger Wert zwischen 0 und 4095 TB sein.',
    'limitRetainPeriodValueInvalid' => 'Der Wert für "Web- und Traffic-Statistiken aufbewahren" in den Service-Paketen kann nicht kleiner sein als der Wert für "Web- und Traffic-Statistiken aufbewahren" in Tools & Einstellungen> Servereinstellungen. Geben Sie eine ganze Zahl größer oder gleich %%MIN%% und unter %%MAX%% ein.',
    'limitValueOverused' => 'Die aktuelle genutzte Menge an Ressourcen übersteigt den angegebenen Grenzwert. Sie können keinen Wert, der kleiner als %%used%% ist, angeben.',
    'limitValueOverselled' => 'Die Ressourcenverbrauchsgrenze von %%reserved%% wurde bereits einigen Abonnements zugewiesen. Sie können keinen Wert angeben, der kleiner als %%reserved%% ist.',
    'lessThan' => "'%value%' ist kleiner als '%min%'",
    'greaterThan' => "'%value%' ist größer als '%max%'",
    'greaterThanDiskQuota' => "%value% ist höher als das Speicherkontingent (%max%)",
    'notDigits' => 'Der Wert muss eine ganze Zahl sein.',
    'digitsStringEmpty' => 'Der Wert muss eine ganze Zahl sein.',
    'isEqual' => "Der Wert darf nicht mit \"%invalidValue%\" übereinstimmen.",
    'notInt' => 'Der Wert muss eine ganze Zahl sein.',
    'maillistNameInvalid' => 'Die angegebene Mailinglistenadresse ist nicht gültig.',
    'maillistReservedNameAlreadyExists' => 'Die angegebene Adresse ist bereits reserviert.',
    'maillistAlreadyExists' => 'Die angegebene Adresse wird bereits von einer Mailingliste verwendet.',
    'maillistAlreadyExistsOnServer' => 'Der angegebene Name einer Mailingliste wird bereits von einem anderen Abonnement verwendet.',
    'mailnameAlreadyExists' => 'Die angegebene E-Mail-Adresse existiert bereits.',
    'mailaliasAlreadyExists' => 'Die angegebene Adresse wird bereits von einem E-Mail-Alias verwendet.',
    'autoresponderEndDateIsInvalid' => 'Das angegebene Datum muss in der Zukunft liegen.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'legacyEstimator.passwordStrength' => 'Ihr Passwort ist nicht komplex genug. Gemäß der Serverrichtlinie ist die Mindeststärke für Passwörter %strength%. Starke Passwörter müssen mindestens folgende Anforderungen erfüllen: acht Zeichen, ein Groß- oder Kleinbuchstabe, drei Ziffern und ein Sonderzeichen (!, @, #, $, %, ^, &, *, ?, _, ~) oder eine Ziffer und zwei Sonderzeichen.',
    'legacyEstimator.passwordStrengthVeryWeak' => 'Sehr schwach: Nicht empfohlen. Solche Passwörter können innerhalb von 3 Minuten über einen Brute-Force-Angriff herausgefunden werden.',
    'legacyEstimator.passwordStrengthWeak' => 'Schwach: Nicht empfohlen. Solche Passwörter können innerhalb von 5 Minuten über einen Brute-Force-Angriff herausgefunden werden.',
    'legacyEstimator.passwordStrengthMediocre' => 'Mittel: Nicht empfohlen. Solche Passwörter können innerhalb von 7 Minuten über einen Brute-Force-Angriff herausgefunden werden.',
    'legacyEstimator.passwordStrengthStrong' => 'Sicher',
    'legacyEstimator.passwordStrengthStronger' => 'Sehr sicher',
    'legacyEstimator.passwordStrengthVeryWeakHint' => 'Diese Passwörter sind für gewöhnlich kurz und enthalten nur eine Art von Zeichen (Klein- oder Großbuchstaben oder Ziffern). Beispiel: passwort. Dieses Sicherheitsniveau verhindert die einfachsten Angriffe, bei denen das Passwort geraten wird.',
    'legacyEstimator.passwordStrengthWeakHint' => 'Diese Passwörter sind für gewöhnlich kurz und enthalten überwiegend eine Art von Zeichen (Klein- oder Großbuchstaben oder Ziffern) mit einigen Zeichen einer anderen Art. Beispiel: passwort12. Diese Passwörter bieten einen Basisschutz vor dem Erraten eines Passworts.',
    'legacyEstimator.passwordStrengthMediocreHint' => 'Diese Passwörter sind für gewöhnlich kurz und enthalten mindestens zwei Zeichentypen (Klein- oder Großbuchstaben, Ziffern oder Sonderzeichen). Beispiel: Passwort12. Solche Passwörter bieten einen zuverlässigen Schutz gegen Angriffe, die darauf abzielen, Passwörter herauszufinden.',
    'legacyEstimator.passwordStrengthStrongHint' => 'Diese Passwörter bestehen aus mindestens 8 Zeichen, wobei mindestens ein Klein- und Großbuchstabe, eine Ziffer und ein Sonderzeichen vorkommen. Beispiel: P@ssw0rt12. Solche Passwörter bieten einen effektiven Schutz vor Brute-Force-Angriffen (Angriffe mit systematischem Durchprobieren aller möglichen Kombinationen).',
    'legacyEstimator.passwordStrengthStrongerHint' => 'Diese Passwörter bestehen aus mindestens 16 Zeichen, wobei Klein- und Großbuchstaben, Ziffern und Sonderzeichen in unterschiedlicher Kombination vorkommen. Beispiel: ~!my_P@$$w0rD123. Solche Passwörter bieten den bestmöglichen Schutz, auch wenn sie schwer zu merken sind.',

    'zxcvbnEstimator.passwordStrength' => 'Ihr Passwort ist nicht komplex genug. Mindestpasswortsicherheit gemäß der Serverrichtlinie: %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Sehr schwach',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Schwach',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Mittel',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Sicher',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Sehr sicher',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Kein Schutz (viel zu einfach zu erraten).',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Mäßiger Schutz vor gedrosselten Online-Angriffen (einfach zu erraten).',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Mäßiger Schutz vor nicht gedrosselten Online-Angriffen (kann erraten werden).',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Mäßiger Schutz vor Offline-Angriffen, unter der Annahme einer langsamen Hash-Funktion (z. B. bcrypt, scrypt, PBKDF2 und argon).',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Hoher Schutz vor Offline-Angriffen, unter der Annahme einer langsamen Hash-Funktion (z. B. bcrypt, scrypt, PBKDF2 und argon).',

    'emailCantBeRenamed' => "Der Server unterstützt nicht das Umbenennen von E-Mail-Konten.",
    'emailOwnedByAnotherUser' => "Diese E-Mail-Adresse gehört einem anderen Benutzer.",
    'maillistAdminEmailShouldExistsOnDomain' => 'Die E-Mail-Adresse des Mailinglisten-Administrators sollte auf derselben Domain wie die Mailingliste registriert werden.',
    'webmailExists' => "Der Webmail-Service '%value%' existiert bereits.",
    'invalidDbName' => 'Der Datenbankname darf nur alphanumerische Zeichen, Punkte, Bindestriche und Unterstriche enthalten.',
    'longDbName' => 'Der Datenbankname ist zu lang.',
    'dbNameClash' => 'Datenbankname und Name des Datenbankbenutzers sollten nicht übereinstimmen.',
    'dbConnectFailed' => 'Verbindungsaufbau zum Datenbankserver nicht möglich. Bitte überprüfen Sie die Nutzerzugangsdaten und Zugriffsbeschränkungen der Datenbank.',
    'databaseNameAlreadyExists' => 'Eine Datenbank mit dem Namen %value% existiert bereits.',
    'wrongUrlSyntax' => 'Die angegebene Adresse ist nicht gültig. Sie müssen eine gültige Adresse angeben, wie z.B. http://domain.com, Pfad oder mailto:address',
    'connectionRefused' => 'Verbindung abgelehnt.',
    'loginIncorrect' => 'Falscher Benutzername',
    'failedToChangeDirectory' => 'Das Verzeichnis existiert nicht',
    'failedToChangeMode' => 'Modus kann nicht geändert werden',
    'failedToCreateDirectory' => 'Datei-Erstellung ist nicht zulässig',
    'failedToRenameDirectory' => 'Umbenennen von Dateien ist nicht zulässig',
    'failedToDeleteDirectory' => 'Löschen von Dateien ist nicht zulässig',
    'ipInvalid' => "'%value%' scheint keine gültige IP-Adresse zu sein oder ist ein falscher Typ.",
    'ipMaskInvalid' => "\"%value%\" scheint keine gültige IP-Adressmaske zu sein.",
    'ipInvalidForInterface' => 'Die angegebene IP-Adresse kann nicht auf der Netzwerkoberfläche verwendet werden. Sie müssen eine gültige IP-Adresse mit einem Subnetz-Präfixbereich oder eine Maske angeben.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'Die angegebene IP-Adresse kann nicht auf der Netzwerkoberfläche verwendet werden, da die IPv6-Unterstützung für diese Oberfläche ausgeschaltet ist.',
    'ipAlreadyExists' => 'Die IP-Adresse %value% existiert bereits.',
    'notInArray' => 'Diese Option wird nicht unterstützt.',
    'ipAddressIsNotSelected' => 'Es muss mindestens eine IP-Adresse ausgewählt werden.',
    'noServiceNodeSpecified' => 'Interner Fehler: Kein Service Node angegeben.',
    'serviceNodeInvalidName' => 'Ungültiger Service-Knotenname "%value%".',
    'serviceNodeNameAlreadyExists' => 'Der Service Node mit dem Namen "%value%" existiert bereits.',
    'serviceNodeIpUsed' => "Der Service Node kann nicht entfernt werden: die IP-Adresse ist registriert.",
    'serviceNodeIpAddressAlreadyExists' => 'Der Service Node mit der IP-Adresse "%value%" existiert bereits.',
    'serviceNodeInvalidTransport' => 'Ungültiger Transportname "%value%".',
    'app_non_unique_setting_value' => 'Ein anderes Objekt weist denselben Einstellungswert auf. Die Einstellung muss für dieses Objekt eindeutig sein.',
    'wrongLocalUrlSyntax' => 'Die angegebene Adresse ist ungültig. Bitte geben Sie eine gültige Adresse, wie z. B. /smb/web/view, an.',
    'phpIsapiHandlerTypeNotSupported' => 'Der Handler-Typ ISAPI wird von der aktuellen PHP-Version nicht unterstützt.',
    'dbNameNotExist' => 'Die angegebene Datenbank existiert nicht.',
    'invalidBooleanValue' => 'Die zulässigen Werte sind "true" oder "false".',
    'invalidMimeType' => 'Der angegebene MIME-Typ ist ungültig: "%value%".',
    'invalidHeaders' => 'Der angegebene Header ist ungültig: "%value%".',
    'invalidHandler' => 'Der angegebene Handler ist ungültig: "%value%".',
    'invalidAllowDeny' => 'Die angegebenen Allow/Deny-Anweisungen sind ungültig: "%value%".',
    'nonUniqueAllowDeny' => 'Der angegebene Wert für die Allow/Deny-Anweisung existiert bereits: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'Die Anzahl an IP-Adressen in der Liste darf höchstens %value% betragen.',
    'invalidDirectoryIndex' => 'Die angegebene Indexdatei des Stammverzeichnisses ist ungültig.',
    'invalidNginxTransparentMode' => 'Der angegebene Wert für die Eigenschaft nginxTransparentMode ist ungültig. Die zulässigen Werte sind "true" oder "false".',
    'invalidNginxServeStatic' => 'Der angegebene Wert für die Eigenschaft nginxServeStatic ist ungültig. Die zulässigen Werte sind "true" oder "false".',
    'invalidStaticFilesExtensions' => 'Die angegebenen Erweiterungen für statische Dateien sind ungültig: "%value%".',
    'invalidNginxServePhp' => 'Der angegebene Wert für die Eigenschaft nginxServePhp ist ungültig. Die zulässigen Werte sind "true" oder "false".',
    'invalidDocuments' => 'Der Name des Dokuments darf keine Kommata (",") enthalten.',
    'duplicateDocuments' => 'Folgende Dokumente existieren bereits in der Liste der Standarddokumente: "%value%"""',
    'protected_directory_invalid_login' => 'Der Nutzername eines Nutzers eines passwortgeschützten Verzeichnisses darf maximal aus 20 alphanumerische Zeichen bestehen. Der Nutzername kann auch Bindestriche ("-") enthalten, darf aber nicht damit beginnen.',
    'notARelativePath' => 'Der Pfad muss relativ sein',
    'cannotUseJunctions' => 'Verbindungen außerhalb des Webspace können nicht als temporäres Kompilierungsverzeichnis verwendet werden',
    'notBetween' => '"%value%" liegt nicht zwischen "%min%" und "%max%" (Werte inklusive)',
    'notBetweenStrict' => '"%value%" liegt nicht genau zwischen "%min%" und "%max%" (Werte inklusive)',
    'redirectToMyself' => 'Die Website kann nicht zu sich selbst weitergeleitet werden. Geben Sie eine Zieladresse ein, die sich von der URL der Hauptwebsite unterscheidet.',
    'redirectToAlias' => 'Die Website kann nicht zu ihrem eigenen Alias weitergeleitet werden. Geben Sie eine Zieladresse ein, die sich von der Adresse des Alias der Hauptwebsite unterscheidet.',
    'relativePathInvalid' => 'Der angegebene Pfad ist ungültig.',
    'aspDotNetSettingsInvalid' => 'Ein oder mehr angegebene Werte für die ASP.NET-Einstellungen sind ungültig.',
    'mboxOutgoingMessagesLimitValueInvalid' => 'Der Grenzwert für ausgehende Nachrichten für ein Postfach muss größer als %%MIN%% sein.',
    'domainOutgoingMessagesLimitValueInvalid' => 'Der Grenzwert für ausgehende Nachrichten für eine Domain muss größer als %%MIN%% sein.',
    'subscriptionOutgoingMessagesLimitValueInvalid' => 'Der Grenzwert für ausgehende Nachrichten für ein Abonnement muss größer als %%MIN%% sein.',
    'iisAuthNotEnabled' => 'Für die Domain muss die anonyme oder die Windows Authentifizierung in den Webserver-Einstellungen eingeschaltet werden.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'Der Grenzwert für ausgehende Nachrichten für ein Postfach muss eine positive ganze Zahl oder \'Standard\' sein. Er kann auch \'-1\' betragen, wenn Sie den Wert \'Unbegrenzt\' festlegen wollen.',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'Der Grenzwert für ausgehende Nachrichten für eine Domain muss eine positive ganze Zahl oder \'Standard\' sein. Er kann auch \'-1\' betragen, wenn Sie den Wert \'Unbegrenzt\' festlegen wollen.',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'Der Grenzwert für ausgehende Nachrichten für ein Abonnement muss eine positive ganze Zahl oder \'Standard\' sein. Er kann auch \'-1\' betragen, wenn Sie den Wert \'Unbegrenzt\' festlegen wollen.',
    'outgoingMessagesReportPeriodValueInvalid' => 'Der angegebene Wert für den Erfassungszeitraum wird nicht unterstützt.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'Der angegebene Wert für den Benachrichtigungszeitraum wird nicht unterstützt.',
    'textItemsListInvalid' => 'Das angegebene Element ist ungültig: "%value%".',
    'textItemsListInvalidMulti' => 'Die angegebenen Elemente sind nicht gültig: &quot;%value%&quot;.',
    'textItemsListNonUnique' => 'Der angegebene Wert ist bereits vorhanden: "%value%".',
    'textItemsListMaxItemsCountExeeded' => 'Die Anzahl der Elemente darf den Wert %value% nicht überschreiten.',
    'invalidAcl' => 'Der angegebene Host ist ungültig: "%value%".',
    'nonUniqueAcl' => 'Der angegebene Wert für den Host ist bereits vorhanden: "%value%".',
    'httpInvalidStatusFormat' => 'Statuscodes müssen Nummern in der Form 400 oder 400.1 sein',
    'httpInvalidStatusCode' => 'Statuscodes müssen zwischen %%minCode%% und %%maxCode%% liegen',
    'httpInvalidStatusSubCode' => 'Unterstatuscodes müssen zwischen %%minSubCode%% und %%maxSubCode%% liegen',
    'httpInvalidStatusRange' => 'Statusbereiche müssen einen Bereich von einem Mindest- bis auf einen Maximalwert angeben',
    'phpSettingValueByteRegexNotMatch' => 'Ein falscher Wert wurde angegeben. Geben Sie eine ganze Zahl und ein Kürzel ein (K für Kilobyte, M für Megabyte, G für Gigabyte, z.B. 128M)',
    'phpFpmServersAmountNotPositive' => "Der Wert muss eine positive Zahl sein.",
    'phpFpmServersAmountLessThan' => "'%value%' ist kleiner als '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' ist größer als '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Ungültiger INI-Syntax erkannt in Zeile %%line%%: '%%text%%'",
    'portRangeInvalid' => 'Der angegebene Portbereich ist ungültig. Der linke Wert muss unter dem rechten Wert liegen.',
    'portRangeValueInvalid' => 'Der Wert %value% im Portbereich ist ungültig. Er muss zwischen %min% und %max% liegen.',
    'domainResolvesToAnotherIp' => 'Die Domain wird in eine falsche IP-Adresse (%value%) aufgelöst. Um Ihre Website online zu stellen, korrigieren Sie %%dnsSettingsLink%%.',
    'domainNotResolved' => 'Die Domain kann nicht aufgelöst werden. Um Ihre Website online zu stellen, korrigieren Sie %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'DNS-Einstellungen',
    'backupPathInvalidCharacters' => '%value% enthält ungültige Zeichen.',
    'backupPathInvalidDot' => '%value% enthält einen ungültigen Pfad: "." oder "..".',
    'networkAccessAlreadyExists' => 'Dieses Netzwerk befindet sich bereits in der IP-Zugriffsliste.',
    'codeRegexNotMatch' => 'Der Aktivierungscode ist nicht gültig.',
    'nameUsedForPlesk' => 'Die Domain kann nicht erstellt werden, da der Name in der URL enthalten ist, die Sie zur Anmeldung in Plesk verwendet haben. Wenn Sie eine Domain erstellen möchten, melden Sie sich über https://%value%:8443 oder https://plesk.%value% in Plesk an.',
    'invalidNameDirectory' => 'Der angegebene Name ist ungültig.',
    'invalidPasswordCharacters' => 'Das Passwort darf keine Anführungszeichen, Leerzeichen oder sprachspezifische Sonderzeichen enthalten.',
    'invalidPasswordLength' => 'Das Passwort muss zwischen %%min%% und %%max%% Zeichen lang sein.',
    'passwordContainsLogin' => 'Das Passwort darf nicht den Benutzernamen enthalten.',
];