<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Comprobación de registros de los sitios web',

    'regularCheck' => 'Verificación estándar',
    'manualCheck' => 'Comprobación manual',

    'promoTitle' => 'Rápida detección de no disponibilidad o de un funcionamiento incorrecto de sus sitios web',
    'promoDescription' => 'Los problemas en sitios web suelen mostrarse a los visitantes del sitio, si bien pueden pasar desapercibidos para los administradores a menos que estos analicen de forma constante los registros del sitio. Nuestra novedosa comprobación de registros automatiza esta rutina y permite corregir los problemas detectados de forma sumamente eficiente.',
    'promoMore' => 'Más información',
    'promoButton' => '¡Entendido!',
    'checkEnabledTitle' => 'La comprobación periódica está activada',
    'checkDisabledTitle' => 'La comprobación periódica está desactivada',
    'disabledDescription' => 'Active la verificación ahora para descubrir si existe algún problema en sus sitios web que pueda ocasionar que estos no estén disponibles o que funcionen de forma incorrecta',
    'websitesChecked' => '{count, plural, one {# sitio web se comprueba} other {# sitios web se comprueban}} a diario.',
    'websitesCheckedAt' => '{count, plural, one {# sitio web se comprueba} other {# sitios web se comprueban}} a diario a las %%time%%.',
    'websitesNotChecked' => 'La comprobación está desactivada en {count, plural, one {# sitio web} other {# sitios web}}.',
    'checkedWebsites' => 'Lista de sitios web comprobados',
    'lastCheckTitle' => 'Última comprobación',
    'lastCheckDescription' => 'Se efectuó el %%date%% a las %%time%% y tardó %%duration%% minutos en completarse',
    'lastCheckError' => '%%problems%% detectados en %%websites%%',
    'lastCheckErrorServerWide' => '%%problems%% detectados',
    'lastCheckSuccess' => 'No se detectó ningún problema',
    'lastCheckProblems' => '{count, plural, one {# problema} other {# problemas}}',
    'lastCheckWebsites' => '{count, plural, one {# sitio web} other {# sitios web}}',
    'durationLess' => 'menos de 0.1',
    'month0' => '%%date%% Ene',
    'month1' => '%%date%% Feb',
    'month2' => '%%date%% Mar',
    'month3' => '%%date%% Abr',
    'month4' => '%%date%% May',
    'month5' => '%%date%% Jun',
    'month6' => '%%date%% Jul',
    'month7' => '%%date%% Ago',
    'month8' => '%%date%% Sep',
    'month9' => '%%date%% Oct',
    'month10' => '%%date%% Nov',
    'month11' => '%%date%% Dic',
    'exportTitle' => 'El informe es estático',
    'exportDescription' => 'No refleja ningún cambio en el sitio web.',
    'export' => 'Exportar el informe a CSV',
    'buttonRun' => 'Ejecutar una nueva comprobación manual',
    'buttonRunDescription' => 'Detecte problemas que pueden ocasionar que su sitio web no esté disponible o que no funcione correctamente',

    'websites.title' => 'Lista de sitios web comprobados',
    'websites.description' => 'Se han seleccionado %%selected%% de %%total%% sitios web',
    'websites.search' => 'Encontrar sitios web...',
    'websites.new' => 'Todos los sitios creados recientemente',
    'websites.newHint' => 'If checked, all the new websites will automatically be included into the list',
    'websites.existing' => 'Todos los sitios web existentes',
    'websites.buttonSave' => 'Guardar la lista',
    'websites.buttonCancel' => 'Cancelar',
    'websites.updateSuccess' => 'La configuración ha sido actualizada',

    'tabs.problemDetails' => 'Detalles del problema',
    'tabs.affectedWebsites' => 'Sitios web afectados',

    'chart.requests' => 'Peticiones',
    'chart.errors' => 'Errores',

    'affected-websites.selected' => 'Se han seleccionado %%selectedCount%% de %%totalCount%% sitios web',
    'affected-websites.none' => 'Ninguno',
    'affected-websites.all' => 'Todos',
    'affected-websites.searchForWebsite' => 'Buscar sitios web',
    'affected-websites.websites' => 'Sitios web',

    'problem-report.commonTitle' => 'Problema notificado',
    'problem-report.domainTitle' => 'Se informó de un problema en %%domain%%',
    'problem-report.cumulativeTitle' => 'Se notificó un problema en {count, plural, one {# sitio web} other {# sitios web}}',
    'problem-report.serverwideTitle' => 'Problema a nivel del servidor notificado',
    'problem-report.problemAppearsOn' => 'El problema aparece en un total de {count, plural, one {# sitio web} other {# sitio web}}:',
    'problem-report.seeTheConsolidatedReport' => 'Examine el informe consolidado',
    'problem-report.cause' => 'Causa principal',
    'problem-report.possibleSolution' => 'Posible solución',
    'problem-report.possibleSolutionNumber' => 'Posible solución #%%number%%',
    'problem-report.useAnOption' => 'Usar una opción para solución automática',
    'problem-report.repairTheWebsite' => 'Reparar el sitio web',
    'problem-report.selectAndRepair' => 'Seleccionar y reparar varios sitios web',
    'problem-report.logEntries' => 'Ejemplos de entradas del registro que indican el problema',
    'problem-report.pleaseKeepInMind' => 'Tenga en cuenta que los registros se rotan de forma constante y que las entradas mencionadas se transfieren al archivo o se eliminan en un momento dado',
    'problem-report.numberOfEntries' => 'Nº entradas',
    'problem-report.logEntry' => 'Entrada de registro',
    'problem-report.logFile' => 'Archivo de registro',
    'problem-report.openWebsiteLogs' => 'Abrir registros del sitio web',
    'problem-report.thisIsServerWideProblem' => 'Se trata de un problema a nivel del servidor que afecta a todos los sitios web alojados',
    'problem-report.serverWideTitle' => 'Problema a nivel del servidor notificado',

    'distribution-over-time.title' => 'Distribución del problema a lo largo del tiempo',
    'distribution-over-time.serverTimezone' => 'Zona horaria del servidor (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Su zona horaria (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'Le recomendamos comparar el gráfico de distribución del error con %%link%% en Monitoring',
    'distribution-over-time.resourceUsageCharts' => 'Gráficos de uso de recursos',

    'report.title' => 'Informe sobre la última verificación',
    'report.groupByWebsites' => 'Agrupados por sitios web',
    'report.groupByProblems' => 'Por problemas',
    'report.columnWebsite' => 'Sitio web',
    'report.columnStatus' => 'Resultado de la última verificación',
    'report.columnProblem' => 'Problema',
    'report.columnAppearedOn' => 'Apareció en',
    'report.serverWideName' => 'Problemas a nivel del servidor',
    'report.serverWideDescription' => 'Estos son los problemas que afectan a todo el servidor y a los sitios web presentes en este',
    'report.statusProblems' => '{count, plural, one {# problema} other {# problemas}}',
    'report.statusSuccess' => 'Seguro',
    'report.serverWide' => 'Todo el servidor',
    'report.appearedOn' => '{count, plural, one {# sitio web} other {# sitios web}}',
    'report.actionPreview' => 'Previsualizar sitio web',
    'report.actionManage' => 'Gestionar sitio web',
    'report.actionLogs' => 'Registros del sitio web',
    'report.problemsList' => 'Detección de {count, plural, one {# problema} other {# problemas}}',
    'report.serverWideProblemsList' => 'Detección de {count, plural, one {# problema a nivel del servidor} other {# problemaa a nivel del servidor}}',
    'report.groupByWebsitesTotal' => '{totalRows, plural, one {# item} other {# elementos}} en total',
    'report.searchWebsite' => 'Encontrar sitios web...',
    'report.searchProblem' => 'Buscar problemas...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# problema} other {# problemas}} en {websitesCount, plural, one {# sitio web} other {# sitios web}}',
    'report.noProblemsTitle' => 'No se detectó ningún problema en {websitesCount, plural, one {# sitio web} other {# sitios web}}',
    'report.noProblemsDescription' => 'Parece que trata a sus sitios web con mucho cariño. ¡Bien hecho!',

    'new-check.title' => 'Ejecutando una nueva comprobación manual',
    'new-check.description' => 'Se han seleccionado %%selected%% de %%total%% sitios web',
    'new-check.depth' => 'Profundidad de la comprobación',
    'new-check.hours' => 'últimas horas',
    'new-check.websites' => 'Sitios web a comprobar',
    'new-check.buttonSave' => 'Comprobar',
    'new-check.buttonCancel' => 'Cancelar',
    'new-check.search' => 'Encontrar sitios web...',
    'new-check.manualCheckProblems' => 'Sitios web con problemas en la última comprobación manual',
    'new-check.regularCheckProblems' => 'Sitios web con problemas en la última comprobación estándar',
    'new-check.allWebsites' => 'Todos los sitios web',
];