<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'title' => 'Überprüfung der Websiteprotokolle',

    'regularCheck' => 'Regelmäßige Überprüfung',
    'manualCheck' => 'Manuelle Überprüfung',

    'promoTitle' => 'Nicht verfügbare oder fehlerhafte Websites rasch erkennen',
    'promoDescription' => 'Oft sind Probleme auf Websites für die Besucher sichtbar, Administratoren erkennen diese Fehler aber nur, wenn sie regelmäßig die Websiteprotokolle überprüfen. Mit unserer brandneuen Protokollprüfung kann dies automatisiert werden. Das ermöglicht Ihnen eine effizientere Problemlösung.',
    'promoMore' => 'Mehr erfahren',
    'promoButton' => 'OK',
    'checkEnabledTitle' => 'Regelmäßige Überprüfung aktiviert',
    'checkDisabledTitle' => 'Regelmäßige Überprüfung deaktiviert',
    'disabledDescription' => 'Aktivieren Sie die Prüfung, um herauszufinden, ob Probleme auf Ihren Websites vorhanden sind, die zu Nichtverfügbarkeit oder Fehlern führen können.',
    'websitesChecked' => '{count, plural, one {# Website wird} other {# Websites werden}} täglich überprüft.',
    'websitesCheckedAt' => '{count, plural, one {# Website wird} other {# Websites werden}} täglich um %%time%% überprüft.',
    'websitesNotChecked' => 'Die Überprüfung ist für {count, plural, one {# Website} other {# Websites}} deaktiviert.',
    'checkedWebsites' => 'Liste der überprüften Websites',
    'lastCheckTitle' => 'Letzte Überprüfung',
    'lastCheckDescription' => 'Durchgeführt am %%date%% um %%time%%. Dauer: %%duration%% Minuten',
    'lastCheckError' => '%%problems%% auf %%websites%% gefunden',
    'lastCheckErrorServerWide' => '%%problems%% gefunden',
    'lastCheckSuccess' => 'Keine Probleme gefunden',
    'lastCheckProblems' => '{count, plural, one {# Problem} other {# Probleme}}',
    'lastCheckWebsites' => '{count, plural, one {# Website} other {# Websites}}',
    'durationLess' => 'weniger als 0,1',
    'month0' => '%%date%% Jan.',
    'month1' => '%%date%% Feb.',
    'month2' => '%%date%% März',
    'month3' => '%%date%% Apr.',
    'month4' => '%%date%% Mai',
    'month5' => '%%date%% Juni',
    'month6' => '%%date%% Juli',
    'month7' => '%%date%% Aug.',
    'month8' => '%%date%% Sept.',
    'month9' => '%%date%% Okt.',
    'month10' => '%%date%% Nov.',
    'month11' => '%%date%% Dez.',
    'exportTitle' => 'Der Bericht ist statisch',
    'exportDescription' => 'Änderungen an der Website werden nicht widergespiegelt.',
    'export' => 'Bericht als CSV exportieren',
    'buttonRun' => 'Neue manuelle Überprüfung durchführen',
    'buttonRunDescription' => 'Probleme erkennen, die zu nicht verfügbaren oder fehlerhaften Websites führen können',

    'websites.title' => 'Liste der überprüften Websites',
    'websites.description' => '%%selected%% von %%total%% Websites sind ausgewählt',
    'websites.search' => 'Websites suchen...',
    'websites.new' => 'Alle neu erstellten Websites',
    'websites.newHint' => 'If checked, all the new websites will automatically be included into the list',
    'websites.existing' => 'Alle vorhandenen Websites',
    'websites.buttonSave' => 'Liste speichern',
    'websites.buttonCancel' => 'Abbrechen',
    'websites.updateSuccess' => 'Einstellungen wurden aktualisiert',

    'tabs.problemDetails' => 'Problemdetails',
    'tabs.affectedWebsites' => 'Betroffene Websites',

    'chart.requests' => 'Anfragen',
    'chart.errors' => 'Fehler',

    'affected-websites.selected' => '%%selectedCount%% von %%totalCount%% Websites sind ausgewählt',
    'affected-websites.none' => 'Ohne',
    'affected-websites.all' => 'Alle',
    'affected-websites.searchForWebsite' => 'Websites suchen',
    'affected-websites.websites' => 'Websites',

    'problem-report.commonTitle' => 'Problem erkannt',
    'problem-report.domainTitle' => 'Problem erkannt auf %%domain%%',
    'problem-report.cumulativeTitle' => 'Problem erkannt auf {count, plural, one {# Website} other {# Websites}}',
    'problem-report.serverwideTitle' => 'Serverweites Problem erkannt',
    'problem-report.problemAppearsOn' => 'Das Problem tritt auf {count, plural, one {# Website} other {# Websites}} auf:',
    'problem-report.seeTheConsolidatedReport' => 'Konsolidierten Bericht anzeigen',
    'problem-report.cause' => 'Ursache',
    'problem-report.possibleSolution' => 'Mögliche Lösung',
    'problem-report.possibleSolutionNumber' => 'Mögliche Lösung Nr. %%number%%',
    'problem-report.useAnOption' => 'Eine Option zur automatischen Lösung verwenden',
    'problem-report.repairTheWebsite' => 'Website reparieren',
    'problem-report.selectAndRepair' => 'Mehrere Websites auswählen und reparieren',
    'problem-report.logEntries' => 'Beispiele für Protokolleinträge, die auf das Problem hinweisen',
    'problem-report.pleaseKeepInMind' => 'Bitte beachten Sie, dass die Protokolle ständig rotiert werden und die genannten Einträge irgendwann ins Archiv übertragen oder gelöscht werden.',
    'problem-report.numberOfEntries' => 'Anzahl der Einträge',
    'problem-report.logEntry' => 'Protokolleintrag',
    'problem-report.logFile' => 'Logfile',
    'problem-report.openWebsiteLogs' => 'Websiteprotokolle öffnen',
    'problem-report.thisIsServerWideProblem' => 'Das ist ein serverweites Problem, das alle gehosteten Websites betrifft',
    'problem-report.serverWideTitle' => 'Serverweites Problem erkannt',

    'distribution-over-time.title' => 'Verteilung des Problems im Zeitverlauf',
    'distribution-over-time.serverTimezone' => 'Zeitzone des Servers (UTC%%utcShift%%)',
    'distribution-over-time.yourTimezone' => 'Ihre Zeitzone (UTC%%utcShift%%)',
    'distribution-over-time.weRecomendComparing' => 'Wir empfehlen, das Diagramm mit der Fehlerverteilung mit %%link%% in Monitoring zu vergleichen',
    'distribution-over-time.resourceUsageCharts' => 'Diagramme zur Ressourcennutzung',

    'report.title' => 'Bericht zur letzten Überprüfung',
    'report.groupByWebsites' => 'Gruppiert nach Websites',
    'report.groupByProblems' => 'Nach Problemen',
    'report.columnWebsite' => 'Webseite',
    'report.columnStatus' => 'Ergebnis der letzten Überprüfung',
    'report.columnProblem' => 'Problem',
    'report.columnAppearedOn' => 'Aufgetreten',
    'report.serverWideName' => 'Serverweite Probleme',
    'report.serverWideDescription' => 'Dies sind Probleme, die den ganzen Server und alle Websites darauf betreffen.',
    'report.statusProblems' => '{count, plural, one {# Problem} other {# Probleme}}',
    'report.statusSuccess' => 'Alles in Ordnung',
    'report.serverWide' => 'Der ganze Server',
    'report.appearedOn' => '{count, plural, one {# Website} other {# Websites}}',
    'report.actionPreview' => 'Vorschau der Website',
    'report.actionManage' => 'Website verwalten',
    'report.actionLogs' => 'Websiteprotokolle',
    'report.problemsList' => '{count, plural, one {# Problem} other {# Probleme}} gefunden',
    'report.serverWideProblemsList' => '{count, plural, one {# serverweites Problem} other {# serverweite Probleme}} gefunden',
    'report.groupByWebsitesTotal' => '{totalRows, plural, one {# Element} other {# Elemente}} insgesamt',
    'report.searchWebsite' => 'Websites suchen...',
    'report.searchProblem' => 'Probleme suchen...',
    'report.groupByProblemsTotal' => '{totalRows, plural, one {# Problem} other {# Probleme}} auf {websitesCount, plural, one {# Website} other {# Websites}}',
    'report.noProblemsTitle' => 'Keine Probleme gefunden auf {websitesCount, plural, one {# Website} other {# Websites}}',
    'report.noProblemsDescription' => 'Ihre Websites scheinen gut in Schuss zu sein. Gut gemacht!',

    'new-check.title' => 'Neue manuelle Überprüfung wird durchgeführt',
    'new-check.description' => '%%selected%% von %%total%% Websites sind ausgewählt',
    'new-check.depth' => 'Umfang der Überprüfung',
    'new-check.hours' => 'letzte Stunden',
    'new-check.websites' => 'Zu überprüfende Websites',
    'new-check.buttonSave' => 'Überprüfen',
    'new-check.buttonCancel' => 'Abbrechen',
    'new-check.search' => 'Websites suchen...',
    'new-check.manualCheckProblems' => 'Websites mit Problemen bei der letzten manuellen Überprüfung',
    'new-check.regularCheckProblems' => 'Websites mit Problemen bei der letzten regelmäßigen Überprüfung',
    'new-check.allWebsites' => 'Alle Websites',
];