<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream envió un encabezado demasiado grande mientras respondía al encabezado de la respuesta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Error interno del servidor 500: aquí no se permite la opción FollowSymLinks"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "el servidor alcanzó la opción max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Síntomas</h4><ul><li><p>Aquellos sitios web que tengan el controlador PHP configurado como <strong>aplicación FPM servida por Apache</strong> o bien <strong>aplicación FPM servida por nginx</strong> en <strong>Dominios</strong> &gt; <strong>example.com</strong> &gt; <strong>Configuración PHP</strong> experimentan uno de los siguientes problemas:</p><ul><li><p>carga lenta</p></li><li><p>no accesible (de forma permanente o periódica) con un error 50x en un navegador web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>En el archivo de registro de errores de PHP-FPM aparece el siguiente mensaje <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (donde <em>XX</em> es la versión de PHP usada por los sitios web):</p><pre>ADVERTENCIA: el servidor [pool example.com] alcanzó la opción max_children (*), considere aumentarla</pre><ul><li><p>El mensaje que aparece arriba suele ir acompañado del siguiente error:</p><pre>no pudo leerse lo que dice el secundario: descriptor de archivo incorrecto (9)</pre></li></ul></li><li><p>Si en el servidor se ha activado nginx, es posible que los siguientes mensajes de error aparezcan en el archivo de registro de errores del dominio <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>El <code>pm.max_children</code> de PHP-FPM ha sido alcanzado por el/los sitio(s) web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Aumente el límite <code>pm.max_children</code> para los dominios afectados:</p><ol><li><p>Conéctese al servidor Plesk mediante <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Encuentre los dominios afectados usando el siguiente comando:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> el número a la izquierda indica cuántas veces el sitio web ha alcanzado el límite <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Acceda a Plesk</a>.</p></li><li><p>Vaya a <strong>Dominios</strong> &gt; <strong>example.com</strong> &gt; <strong>Configuración PHP</strong> &gt; <strong>Configuración PHP-FPM</strong>.</p></li><li><p>Aumente el valor <code>pm.max_children</code> para el dominio y aplique los cambios. Aumente este valor para todos los dominios detallados en el paso 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Demasiados archivos abiertos"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx no puede iniciarse/volver a cargarse en un servidor Plesk, puesto que hay demasiados archivos abiertos</p><h4>Síntomas</h4><ul><li><p>El servicio nginx no puede iniciarse/volverse a cargar debido al siguiente error en el archivo <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>No es posible acceder a algunos o a todos los sitios web</p></li><li><p>La advertencia se muestra en <strong>Herramientas y configuración &gt; Diagnosticar y reparar</strong>:</p><pre style="white-space: pre-wrap;">Al comprobar el valor ULIMIT de nginx se encontraron N dominios en el servidor. Es posible que exista un problema con el límite predeterminado de nginx en cuanto a archivos abiertos</pre></li><li><p>Las aplicaciones web NodeJS y Ruby muestran el error 502 Bad Gateway cuando se efectúan algunas tareas de Plesk, como puede ser el caso de la creación de dominios, suscripciones, cambios en Apache o Nginx, etc:</p><pre style="white-space: pre-wrap;">Error del servidor<br>502 Bad Gateway <br>El servidor web recibió una respuesta no válida cuando actuaba como pasarela o servidor proxy.</pre></li><li><p>Una vez <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalado un nuevo certificado para el dominio</a>, el certificado anterior todavía se muestra en un navegador web, si bien el certificado correcto se encuentra seleccionado en la página <strong>Dominios &gt; example.com &gt; Configuración de hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>El host virtual de nginx abre 4 archivos de registro para cada host virtual con hosting físico:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Como consecuencia, se excede el número máximo de archivos abiertos por parte del servidor nginx debido a un gran número de dominios (generalmente más de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Advertencia:</strong> La ejecución de la utilidad <code>websrv_ulimits</code> sin la opción <strong>--no-restart</strong> inicia la reacreación de archivos de configuración web para todos los dominios, lo que puede causar un tiempo de interrupción significativo en el caso de alojar una gran cantidad de sitios web.<br><br>Ejecute el comando durante la franja horaria del mantenimiento.</div><p>Una buena práctica es establecer un valor límite archivos abiertos superior a la <strong>cantidad de dominios en Plesk * 16</strong>. En el ejemplo que se muestra a continuación se indican las acciones necesarias para establecer el límite a 4096:</p><ol><li><p>Conéctese el servidor mediante <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Establezca el límite de archivos abiertos a 4096 tanto para Apache como para nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reinicie los servicios Apache y nginx en <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Herramientas y configuración &gt; Administración de servicios</strong> para así aplicar los cambios.</p></li><li><p>Compruebe que \'Max open files limit\' se aplicó correctamente tras el reinicio de los servicios web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Si esta solución no ayudó a resolver el problema, establezca el límite mediante la utilidad <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Cuerpo de la respuesta demasiado grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Acceso denegado con código 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Error interno del servidor 500: Tamaño de memoria permitido de XXX agotado"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restricción open_basedir en efecto"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Prohibido AH01797: cliente denegado por la configuración del servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "No es posible acceder a un directorio de sitio web: 403 Prohibido"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "No es posible acceder a un directorio de un sitio web en Plesk: 403 Prohibido"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "el servidor alcanzó la opción MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Límite de cuerpo de petición PHP "el cliente pretendía enviar un cuerpo demasiado grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Límite de cuerpo de petición PHP "el cliente pretendía enviar un cuerpo demasiado grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesiones PHP "Error interno del servidor 503" o "No pudieron leerse los datos de la sesión"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Prohibido: pcfg_openfile: no pudo comprobarse el archivo htaccess. Compruebe que puede leerse"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];