<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Εσφαλμένη πύλη: το upstream έστειλε πολύ μεγάλη επικεφαλίδα κατά την ανάγνωση της επικεφαλίδας απάντησης"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Εσωτερικό σφάλμα διακομιστή 500: Δεν επιτρέπεται η επιλογή FollowSymLinks εδώ"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => '',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "Ο διακομιστής έφτασε στη ρύθμιση max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Συμπτώματα</h4><ul><li><p>Ιστότοποι που έχουν οριστεί ως χειριστής PHP <strong>Εφαρμογή FPM που εξυπηρετείται από το Apache</strong> ή <strong>Εφαρμογή FPM που εξυπηρετείται από το nginx</strong> στους <strong>Τομείς</strong> &gt; <strong>example.com</strong> &gt; <strong>Ρυθμίσεις PHP</strong> παρουσιάζουν ένα από τα ακόλουθα προβλήματα:</p><ul><li><p>φορτώνουν αργά</p></li><li><p>δεν είναι προσβάσιμες (μόνιμα ή περιοδικά) με σφάλμα 50x σε ένα πρόγραμμα περιήγησης ιστού: </p><pre>502 Εσφαλμένη πύλη</pre><hr><pre>503 Η υπηρεσία δεν είναι διαθέσιμη προσωρινά.</pre><hr><pre>504 Χρονικό όριο πύλης</pre></li></ul></li><li><p>Στο αρχείο καταγραφής σφαλμάτων PHP-FPM εμφανίζεται το ακόλουθο μήνυμα <code>/var/log/plesk-php<strong>XX</strong>-fpm/error. log</code> (όπου <em>XX</em> είναι η έκδοση PHP που χρησιμοποιείται από τους ιστότοπους):</p><pre>ΠΡΟΕΙΔΟΠΟΙΗΣΗ: [pool example.com] ο διακομιστής έφτασε τη ρύθμιση max_children (*), εξετάστε το ενδεχόμενο να την αυξήσετε</pre><ul><li><p>Το παραπάνω μήνυμα συνοδεύεται συνήθως από αυτό το σφάλμα:</p><pre>δεν είναι δυνατή η ανάγνωση του τι λένε τα θυγατρικά: Περιγραφή κατεστραμμένου αρχείου (9)</pre></li></ul></li><li><p>Εάν το nginx είναι ενεργοποιημένο στον διακομιστή, ένα από τα ακόλουθα μηνύματα σφάλματος μπορεί να εμφανιστεί στο αρχείο καταγραφής σφαλμάτων του τομέα <code>/var/www/vhosts/system/example. com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 η σύνδεση() στο unix:///var/www/vhosts/system/example.com/php-fpm.sock απέτυχε (11: Πόρος προσωρινά μη διαθέσιμος) κατά τη σύνδεση στο upstream, πελάτης: 203.0.113.2, διακομιστής: example.com, αίτημα: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", κεντρικός υπολογιστής: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 Το upstream έκλεισε πρόωρα τη σύνδεση ενώ διάβαζε την επικεφαλίδα απάντησης από το upstream, πελάτης: 203.0.113.2, διακομιστής: example.com, αίτημα: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Το PHP-FPM <code>pm.max_children</code> έχει επιτευχθεί από τον ιστότοπο (τους ιστότοπους).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1' => '<p>Αυξήστε το όριο <code>pm.max_children</code> για τους επηρεαζόμενους τομείς:</p><ol><li><p>Συνδεθείτε στον διακομιστή Plesk μέσω <a href="https://support.plesk.com/hc/en-us/articles/115000172834" target="_blank" rel="noopener">SSH</a>. </p></li><li><p>Εντοπίστε τους επηρεαζόμενους τομείς χρησιμοποιώντας την παρακάτω εντολή:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6 bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Σημείωση:</strong> Ο αριθμός στα αριστερά δείχνει πόσες φορές το όριο <code>pm. max_children</code> έχει επιτευχθεί από τον ιστότοπο.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener">Είσοδος στο Plesk</a>. </p></li><li><p>Μεταβείτε στους <strong>Τομείς</strong> &gt; <strong>example.com</strong> &gt; <strong>Ρυθμίσεις PHP</strong> &gt; <strong>Ρυθμίσεις PHP-FPM</strong>.</p></li><li><p>Αυξήστε την τιμή <code>pm.max_children</code> για τον τομέα και εφαρμόστε τις αλλαγές. Αυξήστε αυτήν την τιμή για όλους τους τομείς που αναφέρονται στο βήμα 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Πάρα πολλά ανοιχτά αρχεία"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>Το nginx αποτυγχάνει να ξεκινήσει/επαναφορτώσει σε διακομιστή Plesk: Πάρα πολλά ανοικτά αρχεία</p><h4>Συμπτώματα</h4><ul><li><p>Η υπηρεσία nginx αποτυγχάνει να ξεκινήσει/επαναφορτώσει με το ακόλουθο σφάλμα στο αρχείο <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] ανοιχτό() Το "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" απέτυχε (24: Πάρα πολλά ανοικτά αρχεία)</pre></li><li><p>Μερικοί ή όλοι οι ιστότοποι δεν είναι προσβάσιμοι</p></li><li><p>Η προειδοποίηση εμφανίζεται στο <strong>Εργαλεία &amp; Ρυθμίσεις &gt; Διάγνωση &amp; επισκευή</strong>:</p><pre style="white-space: pre-wrap;">Έλεγχος για την τιμή nginx ULIMIT N domains have been found on server. Πιθανό πρόβλημα με το προεπιλεγμένο όριο του nginx για τα ανοιχτά αρχεία</pre></li><li><p>Οι εφαρμογές web NodeJS και Ruby εμφανίζουν σφάλμα 502 Εσφαλμένη πύλη κατά την εκτέλεση ορισμένων εργασιών του Plesk, όπως δημιουργία τομέων, συνδρομές, αλλαγές στο Apache ή το Nginx κ.λπ:</p><pre style="white-space: pre-wrap;">Σφάλμα διακομιστή<br>502 Εσφαλμένη πύλη <br>Ο διακομιστής ιστού έλαβε άκυρη απάντηση ενώ ενεργούσε ως διακομιστής πύλης ή διακομιστής μεσολάβησης. </pre></li><li><p>Μετά την <a href="https://support.plesk.com/hc/en-us/articles/213946825-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">εγκατάσταση ενός νέου πιστοποιητικού για τον τομέα</a>, το παλιό εξακολουθεί να εμφανίζεται σε ένα πρόγραμμα περιήγησης ιστού, ωστόσο, το σωστό πιστοποιητικό έχει επιλεγεί στη σελίδα <strong>Τομείς &gt; example.com &gt; Ρυθμίσεις φιλοξενίας</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Ο εικονικός κεντρικός υπολογιστής του nginx ανοίγει 4 αρχεία καταγραφής για κάθε εικονικό κεντρικό υπολογιστή με φυσική φιλοξενία:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Απόρροια αυτού του γεγονότος είναι η υπέρβαση του μέγιστου αριθμού ανοιχτών αρχείων από τον διακομιστή nginx λόγω μεγάλου αριθμού τομέων (συνήθως, πάνω από 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6 bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Προειδοποίηση:</strong> Η εκτέλεση του βοηθητικού προγράμματος <code>websrv_ulimits</code> χωρίς την επιλογή <strong>--χωρίς επανεκκίνηση</strong> ξεκινά την αναδημιουργία των αρχείων ρυθμίσεων ιστού για όλους τους τομείς και μπορεί να προκαλέσει σημαντικό χρόνο διακοπής λειτουργίας σε περίπτωση μεγάλου αριθμού φιλοξενούμενων ιστότοπων. <br><br>Εκτελέστε την εντολή κατά τη διάρκεια του χρονικού πλαισίου συντήρησης.</div><p>Είναι καλή πρακτική να ορίσετε τιμή ορίου ανοιχτών αρχείων μεγαλύτερη από τον <strong>αριθμό τομέων στο Plesk * 16</strong> τουλάχιστον. Στο παρακάτω παράδειγμα παρέχονται ενέργειες για το πώς να ορίσετε το όριο σε 4096:</p><ol><li><p>Συνδεθείτε στον διακομιστή μέσω <a href="https://support.plesk. com/hc/en-us/articles/115000172834" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Ορίστε το όριο ανοιχτών αρχείων σε 4096 τόσο για το Apache όσο και για το Nginx: </p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Επανεκκίνηση των υπηρεσιών Apache και nginx στη διεύθυνση <strong><a href="https://support.plesk.com/hc/en-us/articles/213413369" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Ρυθμίσεις &amp; εργαλείων &gt; Διαχείριση υπηρεσιών</strong> για να εφαρμόσετε τις αλλαγές.</p></li><li><p>Ελέγξτε ότι το \'Μέγιστο όριο ανοιχτών αρχείων\' εφαρμόστηκε σωστά, μετά την επανεκκίνηση των υπηρεσιών ιστού:</p><pre># grep \'Μέγιστο όριο ανοιχτών αρχείων\' /proc/$(cat /var/run/nginx. pid)/limits<br>Μέγιστο όριο ανοιχτών αρχείων 4096 4096 file</pre></li><li><p>Εάν η παραπάνω λύση δεν βοήθησε, ορίστε το όριο χρησιμοποιώντας το βοηθητικό πρόγραμμα <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Το σώμα της απάντησης είναι πολύ μεγάλο"',
    'problem-detail.apache-modsec-response-body-too-large.description' => '',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Άρνηση πρόσβασης με κωδικό 403"',
    'problem-detail.modsec-access-denied.description' => '',
    'problem-detail.modsec-access-denied.cause' => '',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Εσωτερικό σφάλμα διακομιστή 500: Εξαντλήθηκε το επιτρεπόμενο μέγεθος μνήμης XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "περιορισμός open_basedir σε ισχύ"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => '',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Απαγορεύεται AH01797: ο πελάτης απορρίπτεται από τις ρυθμίσεις του διακομιστή"',
    'problem-detail.apache-client-denied-by-server.description' => '',
    'problem-detail.apache-client-denied-by-server.cause' => '',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Δεν είναι δυνατή η πρόσβαση σε κατάλογο ιστότοπου στο Plesk: 403 Απαγορεύεται"',
    'problem-detail.apache-no-directory-index.description' => '',
    'problem-detail.apache-no-directory-index.cause' => '',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Δεν είναι δυνατή η πρόσβαση σε κατάλογο ιστότοπου στο Plesk: 403 Απαγορεύεται"',
    'problem-detail.nginx-no-directory-index.description' => '',
    'problem-detail.nginx-no-directory-index.cause' => '',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "ο διακομιστής έχει τη ρύθμιση MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => '',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Όριο σώματος αίτησης PHP "ο πελάτης σκόπευε να στείλει πολύ μεγάλο σώμα"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => '',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Όριο σώματος αίτησης PHP "ο πελάτης σκόπευε να στείλει πολύ μεγάλο σώμα"',
    'problem-detail.nginx-client-sent-too-large-body.description' => '',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Συνεδρίες PHP "503 Εσωτερικό σφάλμα διακομιστή" ή "Αποτυχία ανάγνωσης δεδομένων περιόδου λειτουργίας"',
    'problem-detail.php-failed-to-read-session-data.description' => '',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Απαγορεύεται: pcfg_openfile: αδυναμία ελέγχου του αρχείου htaccess, βεβαιωθείτε ότι είναι αναγνώσιμο"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => '',
];