<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "拒絕存取。您的帳戶已掛起。",
    'login_up__login_has_been_locked' => "您已多次嘗試使用錯誤的密碼登入。因安全因素，一段時間內，無法使用此用戶名登入。",
    'login_up__login_label_plesk' => "登入%1", // PFU
    'login_up__login_label_parallels' => "登入到 Plesk %1",
    'login_up__login_text' => "輸入您的用戶名和密碼。",
    'login_up__unable_to_check_pass' => "無法檢查密碼：%1。",
    'login_up__warning_limits_licence_key' => "下列項之一超出您目前許可證金鑰所定的限制：使用者帳戶數、域名數、郵件帳戶數或伺服器上託管的網站用戶數。\n請聯繫 Plesk 銷售部門來購買合適的許可證金鑰，允許您託管相應數量的用戶、域名等。如果您認為誤收到此郵件，請聯繫 Plesk 技術支援部門。\n您當前許可證允許的使用者帳戶數/域名數/郵件帳戶數/網站使用者數/語言包數為: %2.\n您當前託管的使用者帳戶數/域名數/郵件帳戶數/網站使用者數/語言包數為: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "您操作的資源量已超出當前產品許可證所定的限制。請聯繫 Plesk 銷售部門來購買新許可證金鑰。",
    'login_up__grace_period' => '您的產品許可證即將失效。若要更新您的產品許可證，請在%1授權管理頁面%2中選擇“檢索許可證”選項。',
    'login_up__partner_license_message' => '您目前所用的是限制版產品許可證，您需要註冊才可以啟用全部功能。若要更新您的產品許可證，請在%1授權管理頁面%2選擇“檢索許可證”選項。',
    'login_up__system_admin_disabled' => '出於安全原因，高級用戶（root 或管理員帳戶）被禁止登入到 Plesk。',
    'login_up__mobile_application_message' => '為了更佳體驗，我們建議您安裝 %%name%% 應用程式。',
    'login_up__mobile_application_install' => '現在安裝',
    'login_up__mobile_application_hide' => '不，謝謝',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk 管理員指南",
    'plesk_guide_reseller' => "Plesk 代理商指南",
    'plesk_guide_client' => "Plesk 客戶指南",
    'plesk_guide_domain_admin' => "Plesk 域名管理員指南",
    'plesk_guide_mailuser' => "Plesk 郵件使用者指南",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => '查找', // multiple usage: TBI
    'ui__client_unknown__quick-search' => '客戶',
    'ui__reseller_unknown__quick-search' => '代理商',
    'ui__client/domain_unknown__quick-search' => '域名',
    'nav__general' => '主菜單',
    '__home' => '首頁',
    '__resellers' => '代理商',
    '__clients' => '客戶',
    '__domains' => '域名',
    '__applications' => '應用程式',
    '__settings' => '設定',
    'nav__system' => '系統',
    '__master' => '主要伺服器',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => '上一級',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => '刪除',
    'bt_make_default' => '設為默認',

    // common list object operation errors
    'class_cList__empty_selection' => '未選擇對象。',

    // common list object search keys
    'clist__search_show' => '顯示“查找”',
    'clist__search_hide' => '隱藏“查找”',

    'bt_show_all' => "重置搜尋",

    // common object list info keys
    'clist__first' => '開始',
    'clist__last' => '最後',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => '頁',
    'clist__page_size' => '每頁顯示條目',
    'clist__info' => '所有%1：%4',
    'clist__info_empty' => '無%1',
    'clist__info_filter' => '%5 %1查找結果(共%4)',
    'clist__info_paging' => '%2-%3 %1 (共計 %4)',
    'clist__info_paging_filter' => '%5 中找到 %2-%3 %1（共 %4）',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => '活動',
    '__object_off' => '掛起',

    '__home_description' => '返回首頁。',
    'indicator_title' => '已使用 %1%, 可用 %2%', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => '請求的是無效的 URL。',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "代理商帳戶",
    'ui__reseller_unknown__title' => "代理商帳戶",
    'ui__reseller_unknown__description' => "管理代理商帳戶。",
    'ui__reseller/client_unknown__short-title' => '客戶帳戶',
    'ui__reseller/client_unknown__title' => '客戶帳戶',
    'ui__reseller/client_unknown__description' => '管理客戶帳戶。',
    // dropdowns
    'ui__reseller/client/chowner_multi-select__title' => '分配新所有者給客戶帳戶',
    'ui__reseller/client/chowner_multi-select__short-title' => '分配新所有者',
    'ui__reseller/client/chowner_multi-select__description' => '分配新所有者給所選客戶帳戶。',
    'ui__client/to-reseller_multi__title' => '轉換客戶帳戶為代理商帳戶',
    'ui__client/to-reseller_multi__short-title' => '轉換為代理商',
    'ui__client/to-reseller_multi__description' => '轉換所選客戶為代理商。',
    'ui__reseller/to-client_multi__title' => '轉換代理商帳戶為客戶帳戶',
    'ui__reseller/to-client_multi__short-title' => '轉換為客戶',
    'ui__reseller/to-client_multi__description' => '轉換所選代理商帳戶為客戶帳戶',
    'ui__admin-alias_unknown__title' => "附加管理員帳戶", // PFW
    'ui__admin-alias_unknown__short-title' => "附加管理員帳戶", // PFW
    'ui__admin-alias_unknown__description' => "查看並更改附加管理員帳戶。", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "郵件伺服器設定",
    'ui__server/mail__title' => "郵件伺服器設定",
    'ui__server/mail__description' => "設定郵件伺服器和伺服器級郵件設定。",
    'ui__server/dns__short-title' => 'DNS設定',
    'ui__server/dns__title' => 'DNS設定',
    'ui__server/dns__description' => '查看和更新伺服器級DNS設定。',
    'ui__server/components__short-title' => '伺服器組件',
    'ui__server/components__title' => '伺服器組件',
    'ui__server/components__description' => '查看安裝在伺服器上並被 Plesk 使用的系統元件相關資訊。',
    'ui__server/services__short-title' => '服務管理',
    'ui__server/services__title' => '服務管理',
    'ui__server/services__description' => '開始、停止或重啟 Plesk 服務。',
    'ui__server/db__short-title' => '資料庫伺服器',
    'ui__server/db__title' => '資料庫伺服器',
    'ui__server/db__description' => '查看和管理伺服器級資料庫伺服器。',
    'ui__server/crontab/task_unknown__short-title' => '計畫的任務',
    'ui__server/crontab/task_unknown__title' => '計畫的任務',
    'ui__server/crontab/task_unknown__description' => '添加和刪除伺服器級計畫的任務。',
    'ui__server/ip-address_unknown__short-title' => 'IP地址',
    'ui__server/ip-address_unknown__title' => 'IP地址',
    'ui__server/ip-address_unknown__description' => '查看、添加與移除 IP 地址，分配 IP 位元元址給代理商。',
    'ui__promotion/smartermail__short-title' => '下載SmarterMail',
    'ui__promotion/smartermail__title' => '下載SmarterMail',
    'ui__promotion/smartermail__description' => '在新視窗中打開SmarterMail網站，即可下載最新版的SmarterMail郵件伺服器。SmarterTools Inc.享有 SmarterMail 網站的所有權，並為此網站提供支援。Plesk 對 SmarterMail 網站不承擔任何責任，也不對 SmarterMail Lite 郵件伺服器提供任何支援。',
    // dropdowns
    'ui__server/tsclient__short-title' => '遠程桌面',
    'ui__server/tsclient__title' => '遠程桌面',
    'ui__server/tsclient__description' => '通過遠端桌面存取伺服器。',
    'ui__server/time__title' => '系統時間',
    'ui__server/time__short-title' => '系統時間',
    'ui__server/time__description' => '設定系統日期和時間，設定與NTP伺服器同步。',
    'ui__server/odbc__title' => 'ODBC資料來源', // PFW
    'ui__server/odbc__short-title' => 'ODBC資料來源', // PFW
    'ui__server/odbc__description' => '設定ODBC資料來源。', // PFW
    'ui__server/ftp-settings__short-title' => "FTP設定", // PFW
    'ui__server/ftp-settings__title' => "FTP設定", // PFW
    'ui__server/ftp-settings__description' => "配置伺服器級FTP設定。", // PFW
    'ui__server/maillists__title' => '設定郵寄清單伺服器', // PFU
    'ui__server/maillists__short-title' => '設定郵寄清單伺服器', // PFU
    'ui__server/maillists__description' => '設定郵寄清單伺服器。', // PFU
    'ui__mass-email__short-title' => "群發電子郵件", // PFW
    'ui__mass-email__title' => "群發電子郵件", // PFW
    'ui__mass-email__description' => "同時發送郵件給多個用戶。", // PFW
    'ui__mass-mail__title' => '群發郵件', // PFU
    'ui__mass-mail__short-title' => '群發郵件', // PFU
    'ui__mass-mail__description' => '一次發送郵件給多個用戶。', // PFU
    'ui__server/spam-filter__title' => '垃圾郵件篩檢程式設定',
    'ui__server/spam-filter__short-title' => '垃圾郵件過濾設定',
    'ui__server/spam-filter__description' => '設定伺服器級的垃圾郵件篩檢程式。',
    'ui__server/preferences__title' => "伺服器設定",
    'ui__server/preferences__short-title' => "伺服器設定",
    'ui__server/preferences__description' => "配置伺服器級統計計算，更改伺服器主機名稱和更改其它伺服器設定。",

    // interface
    // icons
    'ui__logo__short-title' => 'Plesk 品牌自訂',
    'ui__logo__title' => 'Plesk 品牌自訂',
    'ui__logo__description' => '重新定義 Plesk 品牌，請更改徽標圖像和瀏覽器工具列。',

    // help & support
    // icons
    'ui__support__short-title' => '支援',
    'ui__support__title' => '技術支援',
    'ui__support__description' => '提交Panel技術支援請求或查看客戶提交的技術支援工單。',
    'ui__license__short-title' => '授權管理',
    'ui__license__title' => 'Plesk 授權管理',
    'ui__license__description' => '查看 Plesk 許可證相關資訊，訂購新許可證。',
    'ui__help__short-title' => '幫助',
    'ui__help__title' => '線上說明',
    'ui__help__description' => '查看線上說明。',
    'ui__news__short-title' => "新功能",
    'ui__news__title' => "新功能",
    'ui__news__description' => "查看此版 Plesk 的變更列表。",
    'ui__server/autoinstaller__short-title' => '更新',
    'ui__server/autoinstaller__title' => '更新',
    'ui__server/autoinstaller__description' => '更新 Plesk 與其組件。',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => '域名',
    'ui__client/domain_unknown__title' => '域名',
    'ui__client/domain_unknown__description' => '管理域名。',
    'ui__server/skeleton__short-title' => '虛擬主機範本',
    'ui__server/skeleton__title' => '虛擬主機範本',
    'ui__server/skeleton__description' => '指定要放置到新近創建的域名目錄中的檔和資料夾。',
    // dropdowns
    'ui__client/domain/properties_unknown-new__title' => '創建域名',
    'ui__client/domain/properties_unknown-new__short-title' => '創建域名',
    'ui__client/domain/properties_unknown-new__description' => '創建並配置域名。',
    'ui__client/domain/chowner_multi-select__title' => '給訂閱分配新的所有者',
    'ui__client/domain/chowner_multi-select__short-title' => '分配新的訂閱所有者',
    'ui__client/domain/chowner_multi-select__description' => '給選定的訂閱分配新所有者',
    'ui__client/domain/to-client_multi__title' => '轉換域名管理員帳戶為客戶帳戶',
    'ui__client/domain/to-client_multi__short-title' => '轉換為客戶',
    'ui__client/domain/to-client_multi__description' => '轉換所選域名管理員帳戶為客戶帳戶',
    'ui__client/domain/disable_multi__title' => '掛起域名',
    'ui__client/domain/disable_multi__short-title' => '掛起域名',
    'ui__client/domain/disable_multi__description' => '掛起所選域名',
    'ui__client/domain/enable_multi__title' => '啟動域名',
    'ui__client/domain/enable_multi__short-title' => '啟動域名',
    'ui__client/domain/enable_multi__description' => '啟動所選域名',

    // icons
    'ui__admin/extras-domain__short-title' => '來自MyPlesk.com的工具',
    'ui__admin/extras-domain__title' => '來自MyPlesk.com的工具',
    'ui__admin/extras-domain__description' => '從MyPlesk.com獲取其它工具和服務。',
    'ui__server/aspdotnet__short-title' => 'ASP.NET設定', // PFW
    'ui__server/aspdotnet__title' => 'ASP.NET設定', // PFW
    'ui__server/aspdotnet__description' => '配置伺服器級ASP.NET設定。', // PFW
    'ui__server/sitebuilder__short-title' => 'Presence Builder 設定', // PFU
    'ui__server/sitebuilder__title' => 'Presence Builder  設定', // PFU
    'ui__server/sitebuilder__description' => '設定 Presence Builder 編輯託管於該伺服器上的網站。', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => '註冊域名',
    'ui__admin/register-domain__short-title' => '註冊域名',
    'ui__admin/register-domain__description' => '通過MyPlesk.com註冊域名名。',
    'ui__admin/manage-domain__title' => '管理域名',
    'ui__admin/manage-domain__short-title' => '管理域名',
    'ui__admin/manage-domain__description' => '通過MyPlesk.com管理域名名。',
    'ui__server/register__title' => '註冊伺服器',
    'ui__server/register__short-title' => '註冊伺服器',
    'ui__server/register__description' => '加入會員計畫註冊伺服器',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => '操作日誌',
    'ui__actionlog__title' => '操作日誌',
    'ui__actionlog__description' => '下載操作日誌並管理操作日誌設定。',
    'ui__notification_unknown__short-title' => '通知',
    'ui__notification_unknown__title' => '通知',
    'ui__notification_unknown__description' => '查看和編輯發送的關鍵 Plesk 事件通知。',
    'ui__server/resources__short-title' => '資源使用量',
    'ui__server/resources__title' => '資源使用量',
    'ui__server/resources__description' => '查看系統資源使用。',
    // dropdowns
    'ui__server/statistics__short-title' => '伺服器資訊',
    'ui__server/statistics__title' => '伺服器資訊',
    'ui__server/statistics__description' => '查看伺服器和 Plesk 的多種統計資訊。',
    'ui__admin/report__title' => '匯總報告',
    'ui__admin/report__short-title' => '匯總報告',
    'ui__admin/report__description' => '查看代理商、客戶和域名的流量及資源使用報告。',

    // security
    // icons
    'ui__sessions/properties__short-title' => '會話閒置設定',
    'ui__sessions/properties__title' => '會話閒置設定',
    'ui__sessions/properties__description' => '設定 Plesk 會話的閒置時間。',
    'ui__cp-access__short-title' => '存取 Plesk',
    'ui__cp-access__title' => '存取 Plesk',
    'ui__cp-access__description' => '限制存取 Plesk。',
    'ui__sessions__short-title' => '活動會話',
    'ui__sessions__title' => '活動會話',
    'ui__sessions__description' => '查看活動 Plesk 會話。',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS 證書',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS 證書',
    'ui__server/certificate_unknown__description' => 'SSL/TLS 證書列表。',

    // account
    // icons
    'ui__admin-info__short-title' => '個人資訊',
    'ui__admin-info__title' => '個人資訊',
    'ui__admin-info__description' => '更改帳戶的個人資訊。',
    'ui__admin-password__short-title' => '更改密碼',
    'ui__admin-password__title' => '更改密碼',
    'ui__admin-password__description' => '更改帳戶密碼。',
    'ui__admin/interface__short-title' => '介面偏好設定',
    'ui__admin/interface__title' => '管理員介面偏好設定',
    'ui__admin/interface__description' => '更改伺服器管理員的介面偏好設定。',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/file-manager_unknown__short-title' => '檔案管理員',
    'ui__client/domain/hosting/file-manager_unknown__title' => '檔案管理員',
    'ui__client/domain/hosting/file-manager_unknown__description' => '通過檔案管理員來管理檔和目錄。',
    'ui__client/domain/hosting/tsclient_unknown__short-title' => '遠程桌面', // PFW
    'ui__client/domain/hosting/tsclient_unknown__title' => '遠程桌面', // PFW
    'ui__client/domain/hosting/tsclient_unknown__description' => '通過遠端桌面存取伺服器。', // PFW
    'ui__client/domain/hosting/ssh-terminal_unknown__short-title' => 'SSH終端', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__title' => 'SSH終端', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__description' => '使用SSH終端存取伺服器。', // PFU
    'ui__client/domain/hosting/protected-directories_unknown__short-title' => '有密碼保護的目錄',
    'ui__client/domain/hosting/protected-directories_unknown__title' => '有密碼保護的目錄',
    'ui__client/domain/hosting/protected-directories_unknown__description' => '限制存取所選網站區。',
    'ui__client/domain/hosting/virtual-directories_unknown__short-title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/virtual-directories_unknown__description' => '創建和管理域名上的虛擬目錄。', // PFW
    'ui__client/domain/hosting/web-directories_unknown__title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => '處理網站上的物理和虛擬檔及目錄。', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats_unknown__short-title' => '網站統計',
    'ui__client/domain/report/web-stats_unknown__title' => '網站統計',
    'ui__client/domain/report/web-stats_unknown__description' => '查看網站存取統計。',
    'ui__reseller/limits__short-title' => '資源使用量',
    'ui__reseller/limits__title' => '資源使用量',
    'ui__reseller/limits__description' => '查看和管理代理商%1的資源使用。',
    'ui__reseller/limits_unknown__short-title' => '資源使用量',
    'ui__reseller/limits_unknown__title' => '資源使用量',
    'ui__reseller/limits_unknown__description' => '查看和管理代理商所用資源。',
    'ui__reseller/limits_self__short-title' => '資源使用量',
    'ui__reseller/limits_self__title' => '資源使用量',
    'ui__reseller/limits_self__description' => "查看和管理您的資源使用。",
    'ui__reseller/limits_readonly-self__short-title' => '資源使用量',
    'ui__reseller/limits_readonly-self__title' => '資源使用量',
    'ui__reseller/limits_readonly-self__description' => "查看您的資源使用。",
    'ui__reseller/client/traffic_unknown__short-title' => '客戶所用流量',
    'ui__reseller/client/traffic_unknown__title' => '查看客戶所用流量',
    'ui__reseller/client/traffic_unknown__description' => '查看客戶帳戶的流量使用報告。',
    'ui__client/traffic_unknown__short-title' => "客戶所用流量", // temporary for presets
    'ui__client/traffic_unknown__title' => "按客戶查看流量使用", // temporary for presets
    'ui__client/traffic_unknown__description' => "查看客戶帳戶流量使用報告。", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => '日誌管理器',
    'ui__client/domain/hosting/logs_unknown__title' => '日誌管理器',
    'ui__client/domain/hosting/logs_unknown__description' => '查看日誌和配置日誌迴圈。',
    // dropdowns
    'ui__reseller/report__title' => '匯總報告',
    'ui__reseller/report__short-title' => '匯總報告',
    'ui__reseller/report__description' => '查看此代理商帳戶的流量和資源使用報告。',
    'ui__reseller/report_unknown__title' => '匯總報告',
    'ui__reseller/report_unknown__short-title' => '匯總報告',
    'ui__reseller/report_unknown__description' => '查看代理商所用流量和資源報告。',
    'ui__reseller/report_self__title' => '匯總報告',
    'ui__reseller/report_self__short-title' => '匯總報告',
    'ui__reseller/report_self__description' => '查看流量和資源使用報告。',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Plesk 品牌自訂',
    'ui__client/logo_reseller__short-title' => 'Plesk 品牌自訂',
    'ui__client/logo_reseller__description' => '重新定義代理商 %1 的 Plesk 品牌。',
    'ui__client/logo_unknown__title' => 'Plesk 品牌自訂', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Plesk 品牌自訂', // temporary for presets
    'ui__client/logo_unknown__description' => '重新定義 Plesk 品牌', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Plesk 品牌自訂',
    'ui__client/logo_self-reseller__short-title' => 'Plesk 品牌自訂',
    'ui__client/logo_self-reseller__description' => '重新定義 Plesk 品牌',
    'ui__reseller/permissions__title' => '許可權',
    'ui__reseller/permissions__short-title' => '許可權',
    'ui__reseller/permissions__description' => "查看或更改代理商 %1 可以在 Plesk 中執行的操作。",
    'ui__reseller/permissions_unknown__short-title' => '許可權',
    'ui__reseller/permissions_unknown__title' => '許可權',
    'ui__reseller/permissions_unknown__description' => "查看或更改代理商可以在 Plesk 中執行的操作。",
    'ui__reseller/permissions_self__title' => '許可權',
    'ui__reseller/permissions_self__short-title' => '許可權',
    'ui__reseller/permissions_self__description' => '查看您可以在 Plesk l中執行的操作列表。',
    'ui__reseller/permissions_readonly-self__title' => '許可權',
    'ui__reseller/permissions_readonly-self__short-title' => '許可權',
    'ui__reseller/permissions_readonly-self__description' => '查看您可以在 Plesk l中執行的操作列表。',
    // dropdowns
    'ui__reseller/to-client__title' => '轉換代理商帳戶為客戶帳戶',
    'ui__reseller/to-client__short-title' => '轉換代理商為客戶',
    'ui__reseller/to-client__description' => '轉換此代理商帳戶為客戶帳戶。',
    'ui__reseller/to-client_unknown__title' => '轉換代理商帳戶為客戶帳戶',
    'ui__reseller/to-client_unknown__short-title' => '轉換代理商為客戶',
    'ui__reseller/to-client_unknown__description' => '轉換代理商帳戶為客戶帳戶。',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => '虛擬主機範本',
    'ui__client/skeleton__short-title' => '虛擬主機範本',
    'ui__client/skeleton__description' => '指定放置新創建域名目錄中的檔和資料夾。',
    'ui__client/skeleton_unknown__short-title' => '虛擬主機範本',
    'ui__client/skeleton_unknown__title' => '虛擬主機範本',
    'ui__client/skeleton_unknown__description' => '指定新創建域名的檔和資料夾的存放目錄。',
    // dropdowns
    'ui__client/domain/properties_new__title' => '創建域名',
    'ui__client/domain/properties_new__short-title' => '創建域名',
    'ui__client/domain/properties_new__description' => "為 %1 創建域名。",
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert domain administrator accounts to customer accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => '域名別名',
    'ui__client/domain/domain-alias_unknown__title' => '域名別名',
    'ui__client/domain/domain-alias_unknown__description' => '查看域名的可用名稱列表。',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS設定',
    'ui__client/domain/dns_unknown__short-title' => 'DNS設定',
    'ui__client/domain/dns_unknown__description' => '管理域名的DNS區域設定。',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS設定',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS設定',
    'ui__client/domain/dns_readonly-unknown__description' => '查看域名的DNS區域設定。',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => '來自MyPlesk.com的工具',
    'ui__reseller/extras-domain__title' => '來自MyPlesk.com的工具',
    'ui__reseller/extras-domain__description' => '從MyPlesk.com獲取其它工具和服務。',
    'ui__reseller/extras-domain_unknown__short-title' => '來自MyPlesk.com的工具',
    'ui__reseller/extras-domain_unknown__title' => '來自MyPlesk.com的工具',
    'ui__reseller/extras-domain_unknown__description' => '從MyPlesk.com獲取其他工具和服務。',
    'ui__reseller/extras-domain_self__short-title' => '來自MyPlesk.com的工具',
    'ui__reseller/extras-domain_self__title' => '來自MyPlesk.com的工具',
    'ui__reseller/extras-domain_self__description' => '從MyPlesk.com獲取其它工具和服務。',
    'ui__client/domain/odbc_unknown__short-title' => 'ODBC資料來源', // PFW
    'ui__client/domain/odbc_unknown__title' => 'ODBC資料來源', // PFW
    'ui__client/domain/odbc_unknown__description' => '設定域名的ODBC資料來源。', // PFW
    'ui__reseller/register-domain__short-title' => '註冊域名',
    'ui__reseller/register-domain__title' => '註冊域名',
    'ui__reseller/register-domain__description' => '通過MyPlesk.com註冊域名。',
    'ui__reseller/register-domain_unknown__short-title' => '註冊域名',
    'ui__reseller/register-domain_unknown__title' => '註冊域名',
    'ui__reseller/register-domain_unknown__description' => '通過MyPlesk.com註冊域名名。',
    'ui__reseller/register-domain_self__short-title' => '註冊域名',
    'ui__reseller/register-domain_self__title' => '註冊域名',
    'ui__reseller/register-domain_self__description' => '通過MyPlesk.com註冊域名名。',
    // dropdowns
    'ui__reseller/manage-domain__title' => '管理域名',
    'ui__reseller/manage-domain__short-title' => '管理域名',
    'ui__reseller/manage-domain__description' => '管理通過MyPlesk.com註冊的域名名。',
    'ui__reseller/manage-domain_unknown__title' => '管理域名',
    'ui__reseller/manage-domain_unknown__short-title' => '管理域名',
    'ui__reseller/manage-domain_unknown__description' => '管理通過MyPlesk.com註冊的域名名。',
    'ui__reseller/manage-domain_self__title' => '管理域名',
    'ui__reseller/manage-domain_self__short-title' => '管理域名',
    'ui__reseller/manage-domain_self__description' => '管理通過MyPlesk.com註冊的域名名。',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP地址',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP地址',
    'ui__client/ipaddress_unknown-reseller__description' => '管理IP地址。',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS 證書',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS 證書',
    'ui__client/domain/certificate_unknown__description' => '安裝和管理 SSL/TLS 證書。',
    'ui__client/domain/hosting/hotlink-protection_unknown__short-title' => '盜鏈防護', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__title' => '盜鏈防護', // PFW
    'ui__client/domain/hosting/hotlink-protection_unknown__description' => '保護檔防止被盜鏈。', // PFW
    'ui__reseller/sessions__short-title' => '活動會話',
    'ui__reseller/sessions__title' => '活動會話',
    'ui__reseller/sessions__description' => '查看活動 Plesk 會話。',
    'ui__reseller/sessions_unknown__short-title' => '活動會話',
    'ui__reseller/sessions_unknown__title' => '活動會話',
    'ui__reseller/sessions_unknown__description' => '查看活動 Plesk 會話。',
    'ui__reseller/sessions_self__short-title' => '活動會話',
    'ui__reseller/sessions_self__title' => '活動會話',
    'ui__reseller/sessions_self__description' => '查看活動 Plesk 會話。',
    'ui__client/domain/hosting/performance_unknown__short-title' => '頻寬限制',
    'ui__client/domain/hosting/performance_unknown__title' => '頻寬限制',
    'ui__client/domain/hosting/performance_unknown__description' => '查看和調整網站的頻寬使用限制及同時連接數。',
    'ui__client/domain/hosting/performance_readonly-unknown__short-title' => '頻寬限制',
    'ui__client/domain/hosting/performance_readonly-unknown__title' => '頻寬限制',
    'ui__client/domain/hosting/performance_readonly-unknown__description' => '查看網站的頻寬使用限制及同時連接數。',
    'ui__client/domain/hosting/php_unknown__short-title' => 'PHP設定', // PFW
    'ui__client/domain/hosting/php_unknown__title' => 'PHP設定', // PFW
    'ui__client/domain/hosting/php_unknown__description' => '配置域名的PHP。', // PFW

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => '使用者帳戶%1下的郵件帳戶',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => '虛擬主機範本',
    'ui__client/skeleton_self__title' => '虛擬主機範本',
    'ui__client/skeleton_self__description' => '指定應放置新建域名的檔和資料夾的目錄。',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // Remote desktop - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Password protected directories - RESELLER/FILES
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => '資源使用量',
    'ui__client/limits__title' => '資源使用量',
    'ui__client/limits__description' => "查看和管理客戶%1的資源使用。",
    'ui__client/limits_unknown__short-title' => '資源使用量',
    'ui__client/limits_unknown__title' => '資源使用量',
    'ui__client/limits_unknown__description' => '查看和更改客戶的資源使用。',
    'ui__client/limits_readonly__short-title' => '資源使用量',
    'ui__client/limits_readonly__title' => '資源使用量',
    'ui__client/limits_readonly__description' => '查看客戶%1的資源使用。',
    'ui__client/limits_self__short-title' => '資源使用量',
    'ui__client/limits_self__title' => '資源使用量',
    'ui__client/limits_self__description' => "查看和管理資源使用。",
    'ui__client/limits_readonly-self__short-title' => '資源使用量',
    'ui__client/limits_readonly-self__title' => '資源使用量',
    'ui__client/limits_readonly-self__description' => "查看資源使用。",
    'ui__client/domain/traffic_unknown__short-title' => "域名%1所用流量",
    'ui__client/domain/traffic_unknown__title' => "查看域名所用的流量",
    'ui__client/domain/traffic_unknown__description' => "查看域名的流量使用報告。",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => '匯總報告',
    'ui__client/report__short-title' => '匯總報告',
    'ui__client/report__description' => '查看此客戶的流量和資源使用報告。',
    'ui__client/report_unknown__short-title' => '匯總報告',
    'ui__client/report_unknown__title' => '匯總報告',
    'ui__client/report_unknown__description' => '查看客戶所用流量和資源報告。',
    'ui__client/report_self__short-title' => '匯總報告',
    'ui__client/report_self__title' => '匯總報告',
    'ui__client/report_self__description' => '查看流量和資源使用報告。',

    // account
    // icons
    'ui__client/preferences__short-title' => '介面偏好設定',
    'ui__client/preferences__title' => '介面偏好設定',
    'ui__client/preferences__description' => '為客戶 %1 設定 Plesk 介面偏好設定。',
    'ui__client/preferences_unknown__short-title' => '介面偏好設定',
    'ui__client/preferences_unknown__title' => '介面偏好設定',
    'ui__client/preferences_unknown__description' => "為客戶的 Plesk 設定介面偏好設定。",
    'ui__client/preferences_self__short-title' => '介面偏好設定',
    'ui__client/preferences_self__title' => '介面偏好設定',
    'ui__client/preferences_self__description' => '設定 %1 介面偏好設定。',
    'ui__client/logo__title' => 'Plesk 品牌自訂',
    'ui__client/logo__short-title' => 'Plesk 品牌自訂',
    'ui__client/logo__description' => "重新定義 客戶 %1 的 Plesk 品牌。",
    'ui__client/logo_self__title' => 'Plesk 品牌自訂',
    'ui__client/logo_self__short-title' => 'Plesk 品牌自訂',
    'ui__client/logo_self__description' => '重新定義 Plesk 品牌，請更改徽標圖像和瀏覽器工具列。',
    'ui__client/permissions__title' => '許可權',
    'ui__client/permissions__short-title' => '許可權',
    'ui__client/permissions__description' => "查看或更改客戶 %1 可以在 Plesk 中執行的操作。",
    'ui__client/permissions_unknown__short-title' => '許可權',
    'ui__client/permissions_unknown__title' => '許可權',
    'ui__client/permissions_unknown__description' => "查看或更改客戶可以在 Plesk 中執行的操作。",
    'ui__client/permissions_self__title' => '許可權',
    'ui__client/permissions_self__short-title' => '許可權',
    'ui__client/permissions_self__description' => "查看您可以在 Plesk l中執行的操作列表。",
    'ui__client/permissions_readonly-self__title' => '許可權',
    'ui__client/permissions_readonly-self__short-title' => '許可權',
    'ui__client/permissions_readonly-self__description' => "查看您可以在 Plesk l中執行的操作列表。",
    // dropdowns
    'ui__client/chowner_select__title' => '分配新所有者給客戶帳戶',
    'ui__client/chowner_select__short-title' => '分配新所有者給客戶',
    'ui__client/chowner_select__description' => '為此客戶帳戶分配新所有者。',
    'ui__client/chowner_unknown-select__short-title' => '分配新所有者給客戶帳戶',
    'ui__client/chowner_unknown-select__title' => '分配新所有者給客戶',
    'ui__client/chowner_unknown-select__description' => '分配新所有者給客戶帳戶。',
    'ui__client/to-reseller__title' => '轉換客戶帳戶為代理商帳戶',
    'ui__client/to-reseller__short-title' => '轉換客戶為代理商',
    'ui__client/to-reseller__description' => '轉換此客戶帳戶為代理商帳戶。',
    'ui__client/to-reseller_unknown__title' => '轉換客戶帳戶為代理商帳戶',
    'ui__client/to-reseller_unknown__short-title' => '轉換客戶為代理商',
    'ui__client/to-reseller_unknown__description' => '轉換此客戶帳戶為代理商帳戶。',

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => '來自MyPlesk.com的工具',
    'ui__client/extras-domain__title' => '來自MyPlesk.com的工具',
    'ui__client/extras-domain__description' => '從MyPlesk.com獲取其它工具和服務。',
    'ui__client/extras-domain_unknown__short-title' => '來自MyPlesk.com的工具',
    'ui__client/extras-domain_unknown__title' => '來自MyPlesk.com的工具',
    'ui__client/extras-domain_unknown__description' => '從MyPlesk.com獲得其他工具和服務。',
    'ui__client/extras-domain_self__short-title' => '來自MyPlesk.com的工具',
    'ui__client/extras-domain_self__title' => '來自MyPlesk.com的工具',
    'ui__client/extras-domain_self__description' => '從MyPlesk.com獲取其它工具和服務。',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // ODBC data sources - RESELLER/APPLICATIONS & SERVICES    // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => '註冊域名',
    'ui__client/register-domain__short-title' => '註冊域名',
    'ui__client/register-domain__description' => '通過MyPlesk.com註冊域名名。',
    'ui__client/register-domain_unknown__title' => '註冊域名',
    'ui__client/register-domain_unknown__short-title' => '註冊域名',
    'ui__client/register-domain_unknown__description' => '通過MyPlesk.com註冊域名。',
    'ui__client/register-domain_self__title' => '註冊域名',
    'ui__client/register-domain_self__short-title' => '註冊域名',
    'ui__client/register-domain_self__description' => '通過MyPlesk.com註冊域名名。',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => '管理域名',
    'ui__client/manage-domain__short-title' => '管理域名',
    'ui__client/manage-domain__description' => '通過MyPlesk.com管理註冊的域名名。',
    'ui__client/manage-domain_unknown__title' => '管理域名',
    'ui__client/manage-domain_unknown__short-title' => '管理域名',
    'ui__client/manage-domain_unknown__description' => '管理通過MyPlesk.com註冊的域名。',
    'ui__client/manage-domain_self__title' => '管理域名',
    'ui__client/manage-domain_self__short-title' => '管理域名',
    'ui__client/manage-domain_self__description' => '通過MyPlesk.com管理註冊的域名名。',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP地址',
    'ui__client/ipaddress_unknown__short-title' => "IP地址",
    'ui__client/ipaddress_unknown__description' => "管理IP地址。",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => '域名別名',
    'ui__client/domain/domain-alias_readonly-unknown__title' => '域名別名',
    'ui__client/domain/domain-alias_readonly-unknown__description' => '查看域名的可用名稱列表。',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // Hotlink protection - RESELLER/ADDITIONAL TOOLS    // PFW
    'ui__client/sessions__short-title' => '活動會話',
    'ui__client/sessions__title' => '活動會話',
    'ui__client/sessions__description' => '查看活動 Plesk 會話。',
    'ui__client/sessions_unknown__short-title' => '活動會話',
    'ui__client/sessions_unknown__title' => '活動會話',
    'ui__client/sessions_unknown__description' => '查看活動 Plesk 會話。',
    'ui__client/sessions_self__short-title' => '活動會話',
    'ui__client/sessions_self__title' => '活動會話',
    'ui__client/sessions_self__description' => '查看活動 Plesk 會話。',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/file-manager__short-title' => '檔案管理員',
    'ui__client/domain/hosting/file-manager__title' => '管理域名%1上的文件',
    'ui__client/domain/hosting/file-manager__description' => "通過檔案管理員處理域名%1上的檔和目錄。",
    'ui__client/domain/hosting/file-manager_self__short-title' => '檔案管理員',
    'ui__client/domain/hosting/file-manager_self__title' => '檔案管理員',
    'ui__client/domain/hosting/file-manager_self__description' => "通過檔案管理員來管理您的檔和目錄。",
    'ui__client/domain/hosting/tsclient__short-title' => '遠程桌面', // PFW
    'ui__client/domain/hosting/tsclient__title' => '遠程桌面', // PFW
    'ui__client/domain/hosting/tsclient__description' => '通過遠端桌面存取伺服器。', // PFW
    'ui__client/domain/hosting/tsclient_self__short-title' => '遠程桌面', // PFW
    'ui__client/domain/hosting/tsclient_self__title' => '遠程桌面', // PFW
    'ui__client/domain/hosting/tsclient_self__description' => '通過遠端桌面存取伺服器。', // PFW
    'ui__client/domain/hosting/ssh-terminal__short-title' => 'SSH終端', // PFU
    'ui__client/domain/hosting/ssh-terminal__title' => 'SSH終端', // PFU
    'ui__client/domain/hosting/ssh-terminal__description' => '使用SSH終端存取伺服器。', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__short-title' => 'SSH終端', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__title' => 'SSH終端', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__description' => '使用SSH終端存取伺服器。', // PFU
    'ui__client/domain/hosting/protected-directories__short-title' => '有密碼保護的目錄',
    'ui__client/domain/hosting/protected-directories__title' => '有密碼保護的目錄',
    'ui__client/domain/hosting/protected-directories__description' => '限制存取所選網站區域。',
    'ui__client/domain/hosting/protected-directories_self__short-title' => '有密碼保護的目錄',
    'ui__client/domain/hosting/protected-directories_self__title' => '有密碼保護的目錄',
    'ui__client/domain/hosting/protected-directories_self__description' => '限制存取所選網站區。',
    'ui__client/domain/hosting/virtual-directories__short-title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/virtual-directories__title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/virtual-directories__description' => '創建和管理域名%1上的虛擬目錄。', // PFW
    'ui__client/domain/hosting/virtual-directories_self__short-title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/virtual-directories_self__title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/virtual-directories_self__description' => '創建和管理域名上的虛擬目錄。', // PFW
    'ui__client/domain/hosting/web-directories__title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/web-directories__description' => '處理網站%1上的物理和虛擬檔及目錄。', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => '虛擬目錄', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => '處理網站的物理和虛擬檔及目錄。', // PFW

    // statistics
    // icons
    'ui__client/domain/report/web-stats__short-title' => '網站統計',
    'ui__client/domain/report/web-stats__title' => '網站統計',
    'ui__client/domain/report/web-stats__description' => '查看網站存取統計。',
    'ui__client/domain/report/web-stats_self__short-title' => '網站統計',
    'ui__client/domain/report/web-stats_self__title' => '網站統計',
    'ui__client/domain/report/web-stats_self__description' => '查看網站存取統計。',
    'ui__client/domain/traffic__short-title' => '%1流量使用',
    'ui__client/domain/traffic__title' => '域名%1的資料傳輸統計',
    'ui__client/domain/traffic__description' => '查看域名%1的資料傳輸統計。',
    'ui__client/domain/traffic_self__short-title' => '流量使用',
    'ui__client/domain/traffic_self__title' => '查看域名的流量使用',
    'ui__client/domain/traffic_self__description' => '查看域名的流量使用報告。',
    'ui__client/domain/hosting/logs__short-title' => '日誌管理器',
    'ui__client/domain/hosting/logs__title' => '日誌管理器',
    'ui__client/domain/hosting/logs__description' => '查看日誌和配置日誌迴圈。',
    'ui__client/domain/hosting/logs_self__short-title' => '日誌管理器',
    'ui__client/domain/hosting/logs_self__title' => '日誌管理器',
    'ui__client/domain/hosting/logs_self__description' => '查看日誌和配置日誌迴圈。',
    // dropdowns
    'ui__client/domain/report__title' => '匯總報告',
    'ui__client/domain/report__short-title' => '匯總報告',
    'ui__client/domain/report__description' =>  '查看流量和資源使用報告。',
    'ui__client/domain/report_unknown__short-title' => '匯總報告',
    'ui__client/domain/report_unknown__title' => '匯總報告',
    'ui__client/domain/report_unknown__description' => '查看流量和資源使用報告。',
    'ui__client/domain/report_self__short-title' => '匯總報告',
    'ui__client/domain/report_self__title' => '匯總報告',
    'ui__client/domain/report_self__description' => '查看流量和資源使用報告。',

    // domain administration
    // icons
    'ui__client/domain/properties__short-title' => '個人資訊',
    'ui__client/domain/properties__title' => '個人資訊',
    'ui__client/domain/properties__description' => '更改域名管理員帳戶的個人資訊。',
    'ui__client/domain/properties_unknown__short-title' => '個人資訊',
    'ui__client/domain/properties_unknown__title' => '個人資訊',
    'ui__client/domain/properties_unknown__description' => '更改帳戶的個人資訊。',
    'ui__client/domain/properties_self__short-title' => '個人資訊',
    'ui__client/domain/properties_self__title' => '個人資訊',
    'ui__client/domain/properties_self__description' => '更改帳戶的個人資訊。',
    // dropdowns
    'ui__client/domain/rename__title' => '重命名域名',
    'ui__client/domain/rename__short-title' => '重命名域名',
    'ui__client/domain/rename__description' => '重命名域名 %1。',
    'ui__client/domain/rename_unknown__short-title' => '重命名域名',
    'ui__client/domain/rename_unknown__title' => '重命名域名',
    'ui__client/domain/rename_unknown__description' => '重命名域名',
    'ui__client/domain/chowner_select__title' => '分配新所有者給域名',
    'ui__client/domain/chowner_select__short-title' => '給訂閱分配新的所有者',
    'ui__client/domain/chowner_select__description' => '給訂閱分配新的所有者',
    'ui__client/domain/chowner_unknown-select__short-title' => '給訂閱分配新的所有者',
    'ui__client/domain/chowner_unknown-select__title' => '給訂閱分配新的所有者',
    'ui__client/domain/chowner_unknown-select__description' => '給訂閱分配新的所有者',
    'ui__client/domain/to-client__title' => '轉換域名管理員帳戶為客戶帳戶',
    'ui__client/domain/to-client__short-title' => '轉換域名管理員為客戶',
    'ui__client/domain/to-client__description' => '轉換此域名管理員帳戶為客戶帳戶',
    'ui__client/domain/to-client_unknown__short-title' => '轉換域名管理員為客戶',
    'ui__client/domain/to-client_unknown__title' => '轉換域名管理員帳戶為客戶帳戶',
    'ui__client/domain/to-client_unknown__description' => '轉換域名管理員帳戶為客戶帳戶',
    'ui__client/domain/toggle__title' => '掛起或啟動域名', // for HP customization
    'ui__client/domain/toggle__short-title' => '掛起或啟動域名', // for HP customization
    'ui__client/domain/toggle__description' => '掛起或啟動域名%1。', // for HP customization
    'ui__client/domain/toggle_unknown__title' => '掛起或啟動域名', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => '掛起或啟動域名', // for HP customization
    'ui__client/domain/toggle_unknown__description' => '掛起或啟動域名。', // for HP customization
    'ui__client/domain/toggle_enable__title' => '啟動域名',
    'ui__client/domain/toggle_enable__short-title' => '啟動域名',
    'ui__client/domain/toggle_enable__description' => '啟動域名%1。',
    'ui__client/domain/toggle_disable__title' => '掛起域名',
    'ui__client/domain/toggle_disable__short-title' => '掛起域名',
    'ui__client/domain/toggle_disable__description' => '掛起域名%1。',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS設定',
    'ui__client/domain/dns__short-title' => 'DNS設定',
    'ui__client/domain/dns__description' => '管理域名%1的DNS區域設定。',
    'ui__client/domain/dns_self__title' => 'DNS設定',
    'ui__client/domain/dns_self__short-title' => 'DNS設定',
    'ui__client/domain/dns_self__description' => '管理域名的DNS區域設定。',
    'ui__client/domain/dns_disabled__title' => 'DNS設定',
    'ui__client/domain/dns_disabled__short-title' => 'DNS設定',
    'ui__client/domain/dns_disabled__description' => '管理域名%1的DNS區域設定。',
    'ui__client/domain/dns_self-disabled__title' => 'DNS設定',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS設定',
    'ui__client/domain/dns_self-disabled__description' => '管理域名的DNS區域設定。',
    'ui__client/domain/dns_readonly__title' => 'DNS設定',
    'ui__client/domain/dns_readonly__short-title' => 'DNS設定',
    'ui__client/domain/dns_readonly__description' => '查看域名%1的DNS區域設定。',
    'ui__client/domain/dns_readonly-self__title' => 'DNS設定',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS設定',
    'ui__client/domain/dns_readonly-self__description' => '查看域名的DNS區域設定。',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS設定',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS設定',
    'ui__client/domain/dns_readonly-self-disabled__description' => '查看域名的DNS區域設定。',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS設定',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS設定',
    'ui__client/domain/dns_readonly-self-slave__description' => '查看域名的DNS區域設定。',
    'ui__client/domain/dns_slave__title' => 'DNS設定',
    'ui__client/domain/dns_slave__short-title' => 'DNS設定',
    'ui__client/domain/dns_slave__description' => '管理域名%1的DNS區域設定。',
    'ui__client/domain/dns_self-slave__title' => 'DNS設定',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS設定',
    'ui__client/domain/dns_self-slave__description' => '管理域名的DNS區域設定。',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => '來自MyPlesk.com的工具',
    'ui__client/domain/extras__title' => '來自MyPlesk.com的工具',
    'ui__client/domain/extras__description' => '從MyPlesk.com獲取其它工具和服務。',
    'ui__client/domain/extras_unknown__short-title' => '來自MyPlesk.com的工具',
    'ui__client/domain/extras_unknown__title' => '來自MyPlesk.com的工具',
    'ui__client/domain/extras_unknown__description' => '從MyPlesk.com獲取其他工具和服務。',
    'ui__client/domain/extras_self__short-title' => '來自MyPlesk.com的工具',
    'ui__client/domain/extras_self__title' => '來自MyPlesk.com的工具',
    'ui__client/domain/extras_self__description' => '從MyPlesk.com獲取其它工具和服務。',
    'ui__client/domain/odbc__short-title' => 'ODBC資料來源', // PFW
    'ui__client/domain/odbc__title' => 'ODBC資料來源', // PFW
    'ui__client/domain/odbc__description' => '設定域名%1的ODBC資料來源。', // PFW
    'ui__client/domain/odbc_self__short-title' => 'ODBC資料來源', // PFW
    'ui__client/domain/odbc_self__title' => 'ODBC資料來源', // PFW
    'ui__client/domain/odbc_self__description' => '設定域名的ODBC資料來源。', // PFW
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => '註冊域名',
    'ui__client/domain/register__title' => '註冊域名',
    'ui__client/domain/register__description' => '通過MyPlesk.com註冊域名名。',
    'ui__client/domain/register_unknown__short-title' => '註冊域名',
    'ui__client/domain/register_unknown__title' => '註冊域名',
    'ui__client/domain/register_unknown__description' => '通過MyPlesk.com註冊域名名。',
    'ui__client/domain/register_self__short-title' => '註冊域名',
    'ui__client/domain/register_self__title' => '註冊域名',
    'ui__client/domain/register_self__description' => '通過MyPlesk.com註冊域名名。',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/domain/hosting/hotlink-protection__short-title' => '盜鏈防護', // PFW
    'ui__client/domain/hosting/hotlink-protection__title' => '盜鏈防護', // PFW
    'ui__client/domain/hosting/hotlink-protection__description' => '保護域名 %1 上的檔防止被盜鏈。', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__short-title' => '盜鏈防護', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__title' => '盜鏈防護', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__description' => '防止檔被盜鏈。', // PFW
    'ui__client/domain/hosting/performance__short-title' => '頻寬限制',
    'ui__client/domain/hosting/performance__title' => '頻寬使用限制和允許的網站連接數',
    'ui__client/domain/hosting/performance__description' => '查看和調整域名%1的頻寬使用限制及同時連接數。',
    'ui__client/domain/hosting/performance_readonly__short-title' => '頻寬限制',
    'ui__client/domain/hosting/performance_readonly__title' => '頻寬使用限制和允許的網站連接數',
    'ui__client/domain/hosting/performance_readonly__description' => '查看和調整域名%1的頻寬使用限制及同時連接數。',
    'ui__client/domain/hosting/performance_self__short-title' => '頻寬限制',
    'ui__client/domain/hosting/performance_self__title' => '頻寬限制',
    'ui__client/domain/hosting/performance_self__description' => '查看和調整域名的頻寬使用限制及同時連接數。',
    'ui__client/domain/hosting/performance_readonly-self__short-title' => '頻寬限制',
    'ui__client/domain/hosting/performance_readonly-self__title' => '頻寬限制',
    'ui__client/domain/hosting/performance_readonly-self__description' => '查看和調整域名頻寬使用限制及同時連接數。',
    'ui__client/domain/hosting/php__short-title' => 'PHP設定', // PFW
    'ui__client/domain/hosting/php__title' => 'PHP設定', // PFW
    'ui__client/domain/hosting/php__description' => '配置域名%1上的PHP。', // PFW
    'ui__client/domain/hosting/php_self__short-title' => 'PHP設定', // PFW
    'ui__client/domain/hosting/php_self__title' => 'PHP設定', // PFW
    'ui__client/domain/hosting/php_self__description' => '配置域名的PHP。', // PFW

    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// CLIENTS
    ///

    // list object operations

    // list object operation errors
    'ui__client/to-reseller__empty_selection' => '請選擇要轉換為代理商帳戶的客戶帳戶',
    'ui__client/chowner__empty_selection' => '請選擇要分配給新所有者的客戶帳戶',

    ///
    /// END OF CLIENTS
    ///

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "工具",
    // Create domain - ui__client/domain/properties_unknown-new__short-title (HOME)
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => '查看統計',
    'ui__client/domain-summary-report_unknown__title' => '查看統計',
    'ui__client/domain-summary-report_unknown__description' => '查看域名的資源使用相關資訊。',
    'ui__client/domain-summary-report__short-title' => "查看統計",
    'ui__client/domain-summary-report__title' => "查看統計",
    'ui__client/domain-summary-report__description' => "查看域名的資源使用相關資訊。",
    'ui__client/domain-summary-report_self__short-title' => "查看統計",
    'ui__client/domain-summary-report_self__title' => "查看統計",
    'ui__client/domain-summary-report_self__description' => "查看域名所用資源的相關資訊。",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "域名", // DOMAINS

    // list object operations
    'ui__client/domain/check-permissions_multi__short-title' => '檢查許可權',
    'ui__client/domain/check-permissions_multi__title' => '檢查許可權',
    'ui__client/domain/check-permissions_multi__description' => '檢查域名上的檔和資料夾存取權限。如果有任何錯誤，則會自動修正。',

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => '請選擇要刪除的域名',
    'ui__client/domain/properties__empty_selection' => '請選擇要修改的域名',
    'ui__client/domain/chowner__empty_selection' => '請選擇要分配給新所有者的域名',
    'ui__client/domain/check-permissions__empty_selection' => '請選擇要檢查其檔和資料夾許可權的域名',
    'ui__client/domain/to-client__empty_selection' => '請選擇要將其域名管理員帳戶轉換為客戶帳戶的域名',

    // list objects filtering
    'domains_list__name__filter_title' => '名稱',
    'domains_list__state__filter_title' => '資源使用量',
    'domains_list__filter_state_any' => '任意',
    'domains_list__filter_state_overuse' => '超額使用',
    'domains_list__filter_state_normal' => '在限制內',
    'domains_list__status__filter_title' => '狀態',
    'domains_list__filter_status_any' => '任意',
    'domains_list__filter_status_blocked' => '掛起',
    'domains_list__filter_status_active' => '活動',
    'domains_list__ownership__filter_title' => '所有權',
    'domains_list__filter_ownership_all' => '所有域名',
    'domains_list__filter_ownership_personal' => '僅限我的域名',
    'domains_list__filter_owner_pname__filter_title' => '所有者名稱',
    'domains_list__subrows__filter_title' => '顯示',
    'domains_list__subrows_off' => '僅限域名',
    'domains_list__subrows_subdomain_domainaliases' => '附子域名和別名',
    'domains_list__subrows_subdomain' => '附子域名',
    'domains_list__subrows_domainaliases' => '附別名',

    // objects list
    'domains_list__owner__title' => '所有者',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "查找應用程式",
    'site_apps__promo_main_text' => "應用程式打包標準(APS)目錄包含可部署到域名或主機空間的應用程式清單。如果希望部署當前不在目錄中的應用程式，您可以通過按照www.apsstandard.com上的APS打包指南輕鬆完成。",
    'site_apps__promo_download_now' => "下載應用程式:",
    'site_apps__promo_close' => "關閉此區",
    'site_apps__promo_preset__mostused' => '%1最常用',
    'site_apps__promo_preset__lessused' => '下%1最常用',
    'site_apps__promo_preset__all' => "所有",
    'site_apps__promo_disclaimer_note' => '請注意，從 APS 目錄安裝的應用程式由協力廠商提供，Plesk 不提供支援。',
    'site_apps__promo_preset__page_title' => '%1 APS應用程式',

    // Progress bar
    'site_apps__progress_initialization_message' => '添加應用程式...',

    // Errors
    'site_apps__no_applications_for_update' => '您沒有在應用百寶箱中安裝應用程式。',
    'site_apps__incorrect_download_preset_configuration' => 'APS目錄下載預置配置出錯。',
    'site_apps__aps_catalog_url_is_invalid' => '指定的URL無效。',
    'site_apps__no_updates_at_the_moment' => '此刻沒有可用的應用程式更新。',
    'site_apps__incorrect_content_returned_by_catalog' => '從APS應用程式目錄獲取的資訊錯誤。請稍後重試。',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'APS目錄設定已保存，Plesk 無法建立到 APS 目錄設定(%1)中指定APS目錄的連接。請確定APS目錄位址正確，且此位址上的APS目錄處於活動狀態。',
    'site_apps__cannot_retrieve_updates' => '此刻無法下載應用程式更新: 無法建立APS目錄(%1)連接。請確定APS目錄位址正確，且此位址上的APS目錄處於活動狀態。',
    'site_apps__no_site_applications_in_client_pool_to_install' => '無可供安裝的web應用程式。',
    'site_apps__site_applications_already_installed_in_root' => '其它web應用程式已安裝到這些虛擬主機的根目錄中',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Unix/Linux平臺不支援.NET web應用程式。",
    'site_apps__server_wide_packages_not_supported' => '伺服器級web應用程式不受支援',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 多個 web 應用程式已計畫添加到應用百寶箱。",
    'site_apps__applications_all_in_vault' => "所選web應用程式已在應用百寶箱中。",
    'site_apps__applications_already_in_download_queue' => "此刻%1個所選web應用程式已添加到應用百寶箱中。",
    'site_apps__applications_already_in_valut' => "%1個所選web應用程式已在應用百寶箱中。",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => '其它(未分類)',

    // Errors
    'site_apps__no_applications_in_category' => '此類別中無可用的應用程式。請選擇另一類別。',
    'site_apps__no_category_selected__please_specify' => '選擇左側功能表中的類別。所選類別中所有可用的應用程式將會列出在此視窗中。',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => '管理員帳戶',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => '常規',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => '更改主機名稱',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => '安全性',
    'bt_setup_firewall' => '設定防火牆',
    'bt_manage_firewall_rules' => '管理防火牆規則',
    'cu_firewall__rule' => '創建防火牆規則',
    'cu_firewall__protocol' => '為該規則設定一個協定（\'tcp\' or \'udp\'）',
    'cu_firewall__name' => "設定一個規則名稱",
    'cu_firewall__disabled' => '如果是 \'對\'，創建後此規則將被禁用',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => '選擇DNS伺服器', // PFW
    'bt_soa_records_template' => 'SOA記錄範本',
    'bt_dns_recursion' => 'DNS 遞迴設定',
    'bt_restrict_creation_of_subzones' => '限制創建子區域',

    'databases' => '資料庫',
    'bt_select_mssqlwebadmin' => '選擇MS SQL WebAdmin', // PFW
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => '應用程式',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => '郵件',
    'bt_select_mailserver' => '選擇郵件伺服器', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => '選擇防病毒程式', // PFW
    'bt_virus_protection_settings' => '防病毒設定',
    'bt_select_spamfilter' => '選擇垃圾郵件篩檢程式', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => '選擇web 郵箱',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => '日誌與統計',
    'bt_server_statistics_settings' => '伺服器統計設定',
    'bt_select_web_statistics' => '可用的網站統計軟體', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk 介面',

    'components_and_modules' => '元件與模組',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => '設定Watchdog', // PFU
    'bt_setup_vpn' => '設定VPN', // PFU
    'bt_setup_samba' => '設定samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => '設定',
    'ui__client/domain/settings_self__short-title' => '設定',
    'ui__client/domain/settings_self__description' => '查看和更改域名設定。',

    'domain_administrator_account' => '域名管理員帳戶',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => '帳戶設定',

    'domain' => '域名',
    'bt_dns_soa_records' => 'DNS SOA記錄',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => '任務計畫程式設定',

    'website' => '網站',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => '網站用戶腳本',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    // Password protected directories - HOME/DOMAIN ADMINISTRATOR/FILES
    'bt_select_ssl_certificate' => '選擇 SSL/TLS 證書',
    // Hotlink protection - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => '網站統計',
    'bt_log_rotation_settings' => '日誌迴圈設定',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "限制", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "超額使用與超額銷售策略",
    'limits__overuse_policy_legend' => "超額使用",
    'limits__oversell_policy_legend' => "過度銷售",
    'limits__reseller_overuse_description' => "超額使用策略會在資源超額使用時指令 Plesk 如何進行操作。",
    'limits__overuse_text' => "超額使用策略",

    // limit names
    'limit_group__disk_space_and_traffic' => '磁碟空間和流量',
    'limit__disk_space' => '磁碟空間',
    'limit__max_traffic' => '流量',
    'limit_group__client' => '客戶',
    'limit__max_cl' => '客戶',
    'limit_group__domain' => '域名',
    'limit__max_dom' => '域名',
    'limit__max_dom_powerUser' => '訂閱',
    'limit__max_subdom' => '子域名',
    'limit__max_dom_aliases' => '域名別名',
    'limit__max_wu' => '網站用戶',
    'limit__max_subftp_users' => '其他FTP帳戶', // PFW
    'limit_group__mail' => '郵件',
    'limit__max_box' => '郵箱',
    'limit__mbox_quota' => '郵箱大小',
    'limit__total_mboxes_quota' => '郵箱總配額', // PFW
    'limit__max_maillists' => '郵寄清單',
    'limit_group__database' => '資料庫',
    'limit__max_mssql_db' => 'Microsoft SQL Server資料庫', // PFW
    'limit__mssql_dbase_space' => '所有的 MS SQL 資料庫配額', // PFW
    'limit__max_odbc' => 'ODBC連接', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL 資料庫配額', // PFW?
    'limit_group__application' => '應用程式',
    'limit__max_iis_app_pools' => 'IIS應用程式池', // PFW
    'limit_group__security' => '安全性',
    'limit_group__validity' => '過期日',
    'limit__expiration' => '過期日',
    'limit__validity' => '有效期',
    'limit__max_site_builder' => '使用 Presence Builder 發佈的網站',
    'limit__max_site' => '域名',
    'limit__mssql_dbase_filesize' => 'MS SQL 資料庫檔大小',
    'limit__mssql_dbase_log_filesize' => 'MS SQL 資料庫日誌檔大小',
    'limit__mssql_dbase_filesize_hint' => 'Microsoft SQL 資料庫檔大小的最大值。',
    'limit__mssql_dbase_log_filesize_hint' => 'Microsoft SQL 資料庫日誌檔大小的最大值。',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => '域名限制無效。最小值為1。',

    'property__has_wrong_value' => '屬性 %1 有一個錯誤的值。',
    'property__name_outgoing_messages_domain_limit' => '為發自一個域名的資訊（每小時）設定限制。若要設為無限值，請指定 "-1"。指定“默認”則可以設定在伺服器級設定中指定的值。',
    'property__name_outgoing_messages_mbox_limit' => '為發自一個郵箱的資訊（每小時）設定限制。若要設為無限值，請指定 "-1"。指定“默認”則可以設定在伺服器級設定中指定的值。',
    'property__name_outgoing_messages_subscription_limit' => '為發自一個訂閱的資訊（每小時）設定限制。若要設為無限值，請指定 "-1"。指定“默認”則可以設定在伺服器級設定中指定的值。',

    // for CLI report & email notifications
    '__resource_notify' => '通知',
    '__general' => '常規',
    '__template_shared' => '共用範本',
    'limit__overuse' => '超額使用策略',
    'limit__max_traffic_soft' => '達到流量使用限制時則通知',
    'limit__disk_space_soft' => '達到磁碟空間使用限制時則通知',
    '__overuse' => '超額使用策略',
    'performance__title' => '性能',
    'performance__bandwidth' => '頻寬最大使用量 (KB/S)',
    'performance__max_connections' => '最大連接數',

    'gch__hosting_php_isapi' => '將 PHP 作為 ISAPI 擴展運行',
    'gch__hosting_ssi_html' => '在 htm 和 html 檔中使用 SSI',
    'gch__hosting_php_handler_type' => 'PHP運行身份',
    'gch__hosting_php_handler_id' => '運行 PHP',
    'gch__hosting_php_served_by_nginx' => '由 nginx 服務的 PHP',
    'gch__hosting_unpaid_website_status' => '已掛起訂閱中的網站狀態',
    'gch__mn_no_autoresponder' => '尚未對此郵件帳戶設定自動回復。',
    'gch__no_clients_selected' => "未選擇客戶帳戶",
    'gch__no_domains_selected' => "尚未選擇域名",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/月",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => '資源名稱',
    '__resource_usage' => '已使用',
    '__resource_limit' => '限制',

    '__used' => '已使用',
    '__limit' => '限制',

    '__never_expires' => '永不過期',
    '__resource_free' => '%1可用，共%2',
    '__resource_unlimited' => '已用 %1（共計 無限）',

    '__value' => '值',
    '__unlimited' => '無限',
    '__increment' => "增加 (+)",
    '__decrement' => "減小 (-)",
    '__pt' => '單位',
    '__procent' => '%',
    '__overused' => '超額使用',
    '__left' => '左',
    '__available' => '可用',
    '__not_available' => '未包括在內',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/traffic-history__short-title' => '查看流量歷史',
    'ui__admin/report/traffic-history__title' => '查看流量歷史',
    'ui__admin/report/traffic-history__description' => '查看代理商、客戶和域名的流量歷史。',
    'admin_traffic_history__title' => '流量歷史',

    'ui__admin/report/layout/auto_unknown__short-title' => '發送計畫',
    'ui__admin/report/layout/auto_unknown__title' => '報告發送計畫',
    'ui__admin/report/layout/auto_unknown__description' => '選擇報告發送計畫。',
    'ui__admin/report/layout/auto/properties_new__short-title' => '添加報告發送計畫',
    'ui__admin/report/layout/auto/properties_new__title' => '添加報告發送計畫',
    'ui__admin/report/layout/auto/properties_new__description' => '為報告 %1 添加報告發送計畫。',
    'ui__admin/report/layout/auto/properties__short-title' => '報告發送計畫',
    'ui__admin/report/layout/auto/properties__title' => '報告發送計畫',
    'ui__admin/report/layout/auto/properties__description' => '查看和修改報告發送計畫屬性。',
    'ui__admin/report/layout/auto/delete_multi__short-title' => '刪除報告發送計畫',
    'ui__admin/report/layout/auto/delete_multi__title' => '刪除報告發送計畫',
    'ui__admin/report/layout/auto/delete_multi__description' => '刪除所選報告發送計畫。',

    'ui__admin/report/layout_unknown__short-title' => '報告佈局',
    'ui__admin/report/layout_unknown__title' => '報告佈局',
    'ui__admin/report/layout_unknown__description' => '查看和管理報告佈局。',
    'ui__admin/report/layout/properties_unknown-new__short-title' => '創建報告佈局',
    'ui__admin/report/layout/properties_unknown-new__title' => '創建報告佈局',
    'ui__admin/report/layout/properties_unknown-new__description' => '創建報告佈局。',
    'ui__admin/report/layout/delete_multi__short-title' => '刪除報告佈局',
    'ui__admin/report/layout/delete_multi__title' => '刪除報告佈局',
    'ui__admin/report/layout/delete_multi__description' => '刪除所選報告佈局',
    'ui__admin/report/layout/properties__short-title' => '屬性',
    'ui__admin/report/layout/properties__title' => '報告佈局屬性',
    'ui__admin/report/layout/properties__description' => '編輯報告佈局屬性。',

    // reseller
    'reseller_traffic_history__title' => "代理商%1流量歷史",

    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => '查看代理商%1所用流量',
    'ui__reseller/traffic__description' => '查看代理商帳戶%1的流量使用報告。',
    'ui__reseller/traffic_self__short-title' => '我的',
    'ui__reseller/traffic_self__title' => '查看客戶所用流量',
    'ui__reseller/traffic_self__description' => '查看客戶帳戶的流量使用報告。',

    'ui__reseller/report/traffic-history__short-title' => '查看流量歷史',
    'ui__reseller/report/traffic-history__title' => '查看流量歷史',
    'ui__reseller/report/traffic-history__description' => "查看代理商%1的流量歷史。",
    'ui__reseller/report/traffic-history_self__short-title' => '查看流量歷史',
    'ui__reseller/report/traffic-history_self__title' => '查看流量歷史',
    'ui__reseller/report/traffic-history_self__description' => '查看流量歷史。',

    'ui__reseller/report/layout/auto_unknown__short-title' => '發送計畫',
    'ui__reseller/report/layout/auto_unknown__title' => '報告發送計畫',
    'ui__reseller/report/layout/auto_unknown__description' => '選擇報告發送計畫。',
    'ui__reseller/report/layout/auto/properties_new__short-title' => '添加報告發送計畫',
    'ui__reseller/report/layout/auto/properties_new__title' => '添加報告發送計畫',
    'ui__reseller/report/layout/auto/properties_new__description' => '為報告 %1 添加報告發送計畫。',
    'ui__reseller/report/layout/auto/properties__short-title' => '報告發送計畫',
    'ui__reseller/report/layout/auto/properties__title' => '報告發送計畫',
    'ui__reseller/report/layout/auto/properties__description' => '查看和修改報告發送計畫屬性。',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => '刪除報告發送計畫',
    'ui__reseller/report/layout/auto/delete_multi__title' => '刪除報告發送計畫',
    'ui__reseller/report/layout/auto/delete_multi__description' => '刪除所選報告發送計畫',

    'ui__reseller/report/layout_unknown__short-title' => '報告佈局',
    'ui__reseller/report/layout_unknown__title' => '報告佈局',
    'ui__reseller/report/layout_unknown__description' => '查看和管理報告佈局。',
    'ui__reseller/report/layout/properties_unknown-new__short-title' => '創建報告佈局',
    'ui__reseller/report/layout/properties_unknown-new__title' => '創建報告佈局',
    'ui__reseller/report/layout/properties_unknown-new__description' => '創建報告佈局。',
    'ui__reseller/report/layout/properties_new__short-title' => '創建報告佈局',
    'ui__reseller/report/layout/properties_new__title' => '創建報告佈局',
    'ui__reseller/report/layout/properties_new__description' => '創建報告佈局。',
    'ui__reseller/report/layout/delete_multi__short-title' => '刪除報告佈局',
    'ui__reseller/report/layout/delete_multi__title' => '刪除報告佈局',
    'ui__reseller/report/layout/delete_multi__description' => '刪除所選報告佈局',
    'ui__reseller/report/layout/properties__short-title' => '屬性',
    'ui__reseller/report/layout/properties__title' => '報告佈局屬性',
    'ui__reseller/report/layout/properties__description' => '編輯報告佈局屬性。',

    // customer
    'cl_traffic_history__title' => "客戶%1的流量歷史",

    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => '查看客戶%1所用流量',
    'ui__client/traffic__description' => '查看客戶帳戶%1的流量使用報告。',
    'ui__client/traffic_self__short-title' => '流量使用',
    'ui__client/traffic_self__title' => '查看域名所用流量',
    'ui__client/traffic_self__description' => '查看域名所用流量報告。',

    'ui__client/report/traffic-history__short-title' => '查看流量歷史',
    'ui__client/report/traffic-history__title' => '查看流量歷史',
    'ui__client/report/traffic-history__description' => '查看客戶%1的流量歷史。',
    'ui__client/report/traffic-history_self__short-title' => '查看流量歷史',
    'ui__client/report/traffic-history_self__title' => '查看流量歷史',
    'ui__client/report/traffic-history_self__description' => '查看流量歷史。',



    // domain
    'dom_traffic_history__title' => "域名%1流量歷史",

    'ui__client/domain/report/traffic-history__short-title' => '查看流量歷史',
    'ui__client/domain/report/traffic-history__title' =>  '查看流量歷史',
    'ui__client/domain/report/traffic-history__description' => '查看域名%1 的流量歷史。',
    'ui__client/domain/report/traffic-history_self__short-title' => '查看流量歷史',
    'ui__client/domain/report/traffic-history_self__title' =>  '查看流量歷史',
    'ui__client/domain/report/traffic-history_self__description' => '查看域名的流量歷史。',



    // Web Statistics - ui__client/domain/report/web-stats__short-title (HOME)
    'ui__client/domain/report/web-stats-ssl__short-title' => '安全網站存取統計',
    'ui__client/domain/report/web-stats-ssl__title' => '有關對網站 %1 的安全存取的統計',
    'ui__client/domain/report/web-stats-ssl__description' => '網站%1 的安全存取的統計。',
    'ui__client/domain/report/web-stats-ssl_self__short-title' => '網站統計 SSL/TLS',
    'ui__client/domain/report/web-stats-ssl_self__title' => '安全存取網站統計。',
    'ui__client/domain/report/web-stats-ssl_self__description' => '安全存取網站統計。',
    'ui__client/domain/report/ftp-stats__short-title' => 'FTP 統計',
    'ui__client/domain/report/ftp-stats__title' => '域名 %1 的 FTP 統計',
    'ui__client/domain/report/ftp-stats__description' => '域名 %1 的 FTP 統計',
    'ui__client/domain/report/ftp-stats_self__short-title' => 'FTP統計',
    'ui__client/domain/report/ftp-stats_self__title' => '域名的FTP統計',
    'ui__client/domain/report/ftp-stats_self__description' => '域名的FTP統計。',
    'ui__client/domain/report/anon-ftp-stats__short-title' => '匿名 FTP 統計',
    'ui__client/domain/report/anon-ftp-stats__title' => '域名 %1 的匿名 FTP 統計',
    'ui__client/domain/report/anon-ftp-stats__description' => '域名 %1 的匿名 FTP 統計',
    'ui__client/domain/report/anon-ftp-stats_self__short-title' => '匿名FTP統計',
    'ui__client/domain/report/anon-ftp-stats_self__title' => '域名%1的匿名FTP統計',
    'ui__client/domain/report/anon-ftp-stats_self__description' => '域名%1的匿名FTP統計',

    'ui__client/domain/report/webalizer-preferences__short-title' => 'Webalizer設定',
    'ui__client/domain/report/webalizer-preferences__title' => 'Webalizer %1設定',
    'ui__client/domain/report/webalizer-preferences__description' => '通過Webalizer%1調整統計報告視圖。',
    'ui__client/domain/report/webalizer-preferences_self__short-title' => 'Webalizer設定',
    'ui__client/domain/report/webalizer-preferences_self__title' => 'Webalizer%1設定',
    'ui__client/domain/report/webalizer-preferences_self__description' => '通過Webalizer%1調整統計報告視圖。',

    ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => '代理商名稱', // reseller report
    'report__full_client_name' => '客戶名稱', // customer report
    'report__full_domain_name' => '域名', // domain report
    'report__full_owner' => '所有者', // customer & domain reports
    'report__full_creation_date' => '創建日',
    'report__full_size' => '大小',
    'report__full_traffic' => '流量',
    'report__full_active_clients' => '活動客戶', // reseller report
    'report__full_clients' => '客戶', // reseller report
    'report__full_active_domains' => '活動域名', // reseller & customer reports
    'report__full_domains' => '域名', // reseller & customer reports
    'report__full_subdomains' => '子域名',
    'report__full_mboxes' => '郵箱',
    'report__full_disk_space' => '磁碟空間',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => '回復',
    'report__full_mail_antispam' => '防垃圾郵件',
    'report__full_mail_antivirus' => '防病毒程式',
    'report__full_mail_lists' => '郵寄清單',
    'report__full_web_users' => '網站用戶',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',

    // common summary report
    'report__section_general' => '常規',
    'report__version' => '產品版本',
    'report__build' => '產品小版本號',
    'report__status' => '狀態',
    'report__company_name' => '公司名稱',
    'report__personal_name' => '個人姓名',
    'report__login' => '用戶名',
    'report__phone' => '電話',
    'report__fax' => '傳真',
    'report__email' => '郵件',
    'report__address' => '地址',
    'report__city' => '城市',
    'report__state' => '省/市/自治區',
    'report__zip_code' => '郵遞區號',
    'report__country' => '國家',
    'report__creation_date' => '創建日',
    'report__expiration_date' => '過期日',
    'report__dumps_total_size' => '備份檔案總大小',
    'report__section_resellers' => '代理商',
    'report__active_resellers' => '有活動訂閱的代理商',
    'report__resellers' => '代理商',
    'report__section_full_resellers' => '代理商',
    'report__section_clients' => '客戶',
    'report__active_clients' => '有活動訂閱的客戶',
    'report__clients' => '客戶',
    'report__section_full_clients' => '客戶',
    'report__section_personal_clients' => '個人客戶',
    'report__active_personal_clients' => '有活動訂閱的客戶',
    'report__personal_clients' => '個人客戶',
    'report__section_full_personal_clients' => '個人客戶',
    'report__section_domains' => '域名',
    'report__disk_usage' => '磁碟空間',
    'report__traffic' => '流量',
    'report__active_domains' => '活動域名',
    'report__domains' => '域名',
    'report__subdomains' => '子域名',
    'report__mboxes' => '郵箱',
    'report__mail_groups' => '郵件轉發',
    'report__mail_autoresp' => '自動回復',
    'report__mail_lists' => '郵寄清單',
    'report__web_users' => '網站用戶',
    'report__mysql_databases' => 'MySQL資料庫',
    'report__mssql_databases' => 'MySQL資料庫',
    'report__section_full_domains' => '域名',
    'report__section_personal_domains' => '個人域名',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => '個人域名',

    //New for Plesk 10
    'report__sitebuilder_sites' => '使用 Presence Builder 發佈的網站',
    'report__invalid_email' => '請指定一個有效的郵寄位址。',


    // CLI-specific sections
    'report__section_hosting' => '主機',
    'report__section_webusers' => '網站用戶',
    'report__section_mailnames' => '郵件帳戶',
    'report__section_maillists' => '郵寄清單',
    'report__section_databases' => '資料庫',
    'report__section_siteapps' => 'Web應用程式',
    'report__section_aspnetapps' => 'ASP.NET應用程式', // PFW
    'report__owner_pname' => "服務商個人姓名",
    'report__owner_login' => "服務商用戶名",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => '已在系統中安裝指定的語言包但是未啟用。',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => '刪除會話',
    'ui__sessions/delete__title' => '刪除會話',
    'ui__sessions/delete__description' => '刪除所選會話。',
    'ui__ftp-sessions__short-title' => 'FTP會話',
    'ui__ftp-sessions__title' => 'FTP會話',
    'ui__ftp-sessions__description' => '查看FTP會話。',
    'ui__ftp-sessions/delete__short-title' => '刪除FTP會話',
    'ui__ftp-sessions/delete__title' => '刪除FTP會話',
    'ui__ftp-sessions/delete__description' => '刪除所選的FTP會話。',
    'ui__ts-sessions__short-title' => 'TS會話',
    'ui__ts-sessions__title' => 'TS會話',
    'ui__ts-sessions__description' => '查看終端服務會話。',

    // reseller
    'ui__reseller/sessions/delete__short-title' => '刪除會話',
    'ui__reseller/sessions/delete__title' => '刪除會話',
    'ui__reseller/sessions/delete__description' => '刪除所選會話。',
    'ui__reseller/sessions/delete_self__short-title' => '刪除會話',
    'ui__reseller/sessions/delete_self__title' => '刪除會話',
    'ui__reseller/sessions/delete_self__description' => '刪除所選會話。',
    'ui__reseller/ftp-sessions__short-title' => 'FTP會話',
    'ui__reseller/ftp-sessions__title' => 'FTP會話',
    'ui__reseller/ftp-sessions__description' => '查看FTP會話。',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP會話',
    'ui__reseller/ftp-sessions_self__title' => 'FTP會話',
    'ui__reseller/ftp-sessions_self__description' => '查看FTP會話。',
    'ui__reseller/ftp-sessions/delete__short-title' => '刪除FTP會話',
    'ui__reseller/ftp-sessions/delete__title' => '刪除FTP會話',
    'ui__reseller/ftp-sessions/delete__description' => '刪除所選的FTP會話。',
    'ui__reseller/ftp-sessions/delete_self__short-title' => '刪除FTP會話',
    'ui__reseller/ftp-sessions/delete_self__title' => '刪除FTP會話',
    'ui__reseller/ftp-sessions/delete_self__description' => '刪除所選的FTP會話。',

    // customer
    'ui__client/sessions/delete__short-title' => '刪除會話',
    'ui__client/sessions/delete__title' => '刪除會話',
    'ui__client/sessions/delete__description' => '刪除所選會話。',
    'ui__client/sessions/delete_self__short-title' => '刪除會話',
    'ui__client/sessions/delete_self__title' => '刪除會話',
    'ui__client/sessions/delete_self__description' => '刪除所選會話。',

    // domain administrator

    'forgery_token_expired' => '會話權杖已過期。',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => '下列代理商帳戶即將轉換為客戶帳戶',
    'downgradeResellers__downgrade' => '待轉換的代理商帳戶',
    // controls
    'downgradeResellers__submit_downgrade' => '執行帳戶轉換。',
    'downgradeResellers__cancel_downgrade' => '取消帳戶轉換。',
    'downgradeResellers__confirm' => '確認轉換',
    'downgradeResellers__confirm_message' => '確認進行帳戶轉換',
    // errors

    // customers > resellers
    'picker_client_multi__title' => '選擇客戶帳戶',
    'upgradeClients__upgrade_clients' => '下列客戶帳戶將會轉換為代理商帳戶',
    'upgradeClients__upgrade' => '即將轉換的客戶帳戶',
    // controls
    'upgradeClients__submit_upgrade' => '執行帳戶轉換。',
    'upgradeClients__cancel_upgrade' => '取消帳戶轉換。',
    'upgradeClients__confirm' => '確認轉換',
    'upgradeClients__confirm_message' => '確認進行帳戶轉換',
    // errors
    'upgradeClient__user_is_already_reseller' => '無法轉換 \'%1\' 為代理商：\'%1\' 已經是代理商。',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => '下列域名管理員帳戶即將轉換為客戶帳戶',
    'upgradeDomainUser__upgrade' => '即將轉換下列域名管理員帳戶',
    // controls
    'upgradeDomainUser__submit_upgrade' => '執行帳戶轉換。',
    'upgradeDomainUser__cancel_upgrade' => '取消帳戶轉換。',
    'upgradeDomainUser__confirm' => '確認轉換',
    'upgradeDomainUser__confirm_message' => '確認進行帳戶轉換',
    // errors
    'upgradeDomainUser__non_upgradeable' => '無法轉換的域名管理員帳戶',
    'upgradeDomainUser__non_upgradeable_domain_users' => '下列域名管理員帳戶無法轉換為客戶帳戶:',
    'upgradeDomainUser__some_domains_were_not_converted' => '無法轉換為客戶帳戶的多個域名管理員帳戶。%%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => '域名管理員帳戶不存在',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "此域名應直接屬於伺服器管理員或代理商。",
    'upgradeDomainUser__all_logins_already_used' => '無法為最終客戶帳戶創建帳戶。',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => '域名管理員帳戶已轉換',
    'upgradeDomainUser__upgrade_notification_body' => '您的域名管理員帳戶已轉換為客戶帳戶，用戶名為"%%login%%"，密碼為"%%password%%"。',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // wizard title
    'ui__client/chowner_unknown__wizard-title' => '分配新所有者給客戶帳戶%1', // customer home
    'ui__client/chowner_multi__wizard-title' => '分配新所有者給所選使用者帳戶', // list of customers
    'ui__reseller/client/chowner_multi__wizard-title' => '分配新所有者給所選使用者帳戶', // reseller & admin home
    // customers selection - reseller & admin home
    'picker_client__title' => '選擇客戶帳戶',
    'ui__reseller/client/chowner_multi__wizard__2_multi' => '選擇要轉讓給另一所有者的客戶帳戶。',
    //  owner selection
    'client_chown__select_title' => '選擇新所有者給客戶帳戶',
    'client_chown__select-multi_title' => '為客戶帳戶選擇新所有者',
    'ui__reseller/client/chowner_multi__wizard__2_multi-select' => "為所選客戶帳戶選擇新所有者。", // customer home
    'ui__client/chowner_multi__wizard__2_multi-select' => '為所選客戶帳戶選擇新所有者。', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi-select' => '為所選客戶帳戶選擇新所有者。', // reseller & admin home
    // changes check page
    'client_chown__check_title' => '檢查變更並結束嚮導',
    'ui__client/chowner__wizard__2' => '檢查變更，並按一下完成推出嚮導。', // customer home
    'ui__client/chowner_multi__wizard__2_multi' => '檢查變更，並按一下完成結束嚮導。', // customers list
    'ui__reseller/client/chowner_multi__wizard__3_multi' => '檢查變更，並按一下完成結束嚮導。', // admin "accounts" dropdown:
    // errors
    'client_chown__empty_selection' => '請為所選客戶帳戶選擇新所有者',
    'clientOwnerChanger__unable_to_transfer_some_clients' => '一或多個所選使用者帳戶無法轉移給新所有者。',
    'client_chown__client_warn' => '描述',

    'clientOwnerChanger__owner_has_no_permission' => '選定的代理商沒有許可權 \'%1\'，但是某些客戶有該許可權。',
    'clientOwnerChanger__application_not_allowed' => '選定代理商無法使用應用程式 \'%1\'，但是某些客戶可以使用。',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => '正在重新分配選定的訂閱',
    // errors
    'domain_chown__empty_selection' => '請為所選域名選擇新所有者',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__title' => '性能',
    'hosting_performance__traffic_bandwidth_legend' => '啟用頻寬限制',
    'hosting_performance__traffic_bandwidth_legend_ro' => '頻寬限制',
    'hosting_performance__traffic_bandwidth_label' => '頻寬最大使用量 (%1)',
    'hosting_performance__traffic_bandwidth_hint' => '頻寬使用限制僅應用到通過HTTP協定傳送的資料。',
    'hosting_performance__max_connection_legend' => '啟用連接限制',
    'hosting_performance__max_connection_legend_ro' => '連接限制',
    'hosting_performance__max_connection_label' => '連接限制',
    'hosting_performance__max_connection_hint' => '如果您限制頻寬使用，則建議您也限制此網站的同時連接數。如果網站請求頻率較高，則Web伺服器進程會增加伺服器負載。',

    // errors:
    'performance__qos_not_installed' => '因尚未安裝Qos，從而禁用功能',
    'performance__bandwidth_throttling' => '您不能控制頻寬節流，因為 QoS 尚未安裝。',
    'performance__invalid_value' => "無效值。範圍應該從 %1 到 %2。",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'web 郵箱',
    'webmail__server_text' => '可用的 web 郵箱用戶端',
    'webmail__none' => '無',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => '伺服器IP池',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => '資料庫將不會被恢復：尚無合適的資料庫伺服器',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "伺服器備份。",
    '__default_backup_comment_reseller' => "%1 創建的代理商帳戶備份。",
    '__default_backup_comment_client' => "%1 創建的客戶帳戶備份。",
    '__default_backup_comment_domain' => "%1 創建的訂閱備份。",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__title' => '定義IP位址映射',
    'backup__ip_mapping__download' => '保存當前IP映射到檔',
    'b_backup__ip_mapping__download' => '按一下下載IP映射配置。',
    'b_backup__ip_mapping__download_is_empty' => 'IP映射配置為空。',
    'backup__ip_mapping_upload__title' => '上傳IP位址映射文件',
    'backup__ip_mapping__upload' => '上傳IP映射文件',
    'b_backup__ip_mapping__upload' => '按一下上傳IP映射配置。',
    'backup__ip_mapping__list__header' => 'IP映射',
    'backup__ip_mapping__list__adddress' => '舊IP地址',
    'backup__ip_mapping__list__select_ip' => '新IP地址',
    'backup__ip_mapping__clients_ip' => "客戶 %1 的 IP 池",
    'backup__ip_mapping__resellers_ip' => "代理商 %1 的 IP 池",
    'backup__ip_mapping__exclusive_ip_must_be_unique' => '獨立 IP 位址應映射到唯一的IP位址。請為列表中的每個獨立 IP 位址選擇唯一的 IP 位址。',
    'backup__ip_mapping__legend' => 'IP映射',
    'backup__ip_mapping__upload_legend' => '上傳',
    'backup__ip_mapping__upload_file_text' => 'IP映射文件',
    'backup__ip_mapping__upload_file_hint' => 'IP映射檔是純文字檔。此檔的每行都包含如下格式的IP映射: <old IP address> <new IP address>',
    'backup__ip_mapping__ip_address_not_found' => '無此類可用 IP 地址',
    'backup__ip_mapping__ip_address_not_found_hint' => '無法執行資料移轉： IP 位址映射不完整，因為目標伺服器上的 IP 池中沒有可用的 IP 地址。',
    'backup__ip_mapping__ftp_will_be_disabled' => '禁止帶有該 IP 位址的域使用非安全 FTP 連接',
    'backup__ip_mapping__ftps_will_be_disabled' => '禁止帶有該 IP 位址的域使用安全 FTPS 連接',

    // Conflicts occured
    'legend_conflicts_occured' => '衝突',
    'backup__restore__object_vhost' => '虛擬主機',
    'backup__restore__object_plesk_admin' => 'Plesk 管理員',
    'backup__restore__object_ftpuser' => 'FTP帳戶',
    'backup__restore__object_frontpageuser' => 'Frontpage帳戶',
    'backup__restore__object_webuser' => '網站用戶',
    'backup__restore__object_domain' => '域名',
    'backup__restore__object_subdomain' => '子域名',
    'backup__restore__object_domainalias' => '域名別名',
    'backup__restore__object_client' => '客戶',
    'backup__restore__object_reseller' => '代理商',
    'backup__restore__object_autoresponder' => '自動回復',
    'backup__restore__object_mailalias' => '郵件別名',
    'backup__restore__object_database' => '資料庫',
    'backup__restore__object_mailname' => '郵件帳戶',
    'backup__restore__object_db_user' => '資料庫使用者',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS 證書',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => '無法恢復以下代理商，因為他們已被轉換為客戶：\'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => '無法恢復以下客戶，因為他們已被轉換為代理商：\'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => '無法恢復以下客戶，因為他們已被移動給其它所有者：\'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => '目標伺服器上的磁碟空間不夠存儲用於傳輸所有選定的訂閱。可用：%1 MB.要求：%2 MB.注意所需空間是網站、郵件和域名資料庫內容的總量。所需空間每日計算一次並把結果存儲於緩存中，因此域名的實際大小可能跟計算的大小有出入。如果您想要確保選定的域名不會佔用比可用空間更大的空間，您可以進行傳輸。',
    'backup__restore__capability_not_enough_disk_resolution' => '請清空目標伺服器上的磁碟空間。',
    'backup__restore__capability_source_not_enough_disk_text' => '原始伺服器上的磁碟空間不夠存儲用於遷移的暫存檔案。 可用： %1 MB. 需要 %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => '請清空原始伺服器上的磁碟空間。',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => '伺服器資訊',

    'backup__restore__capability_not_installed_component_text' => '目標伺服器上的未安裝組件 %1。%1 將不能用於所有被恢復的對象。',
    'backup__restore__capability_not_installed_component_resolution' => '請安裝 %1。',
    'backup__restore__capability_existing_sys_user_text' => '目標伺服器上已經存在名為 %1 的系統使用者。',
    'backup__restore__capability_existing_sys_user_resolution' => '請重命名目標伺服器上的現有系統使用者。',
    'backup__restore__capability_license_usage_text' => '資料移轉後，目標伺服器上的以下資源上限（許可證金鑰定義）將會被超過：',
    'backup__restore__capability_license_usage_resolution' => '請在目標伺服器上安裝可提供所需資源量的其他許可證金鑰。',
    'backup__restore__capability_max_allowed_packet_text' => "來源資料庫伺服器上的 'max_allowed_packet' 參數是 %1，該值大於目標伺服器上的值（%2）。以下指定的域名的一些資料庫對象可能無法恢復。",
    'backup__restore__capability_max_allowed_packet_resolution' => "請增加目標資料庫伺服器上的 \\'max_allowed_packet\\' 值。",

    'backup__restore__capability_postgres_to_lower_version_text' => '無法遷移 PostgreSQL 資料庫因為目標伺服器上的 PostgreSQL 版本早於原始伺服器上的版本。 當前版本是 %1，所需版本是 %2。',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => '請在目的伺服器上安裝所需的 PostgreSQL 版本。',
    'backup__restore__capability_db_server_connection_problems' => '無法連接到目標 PostgreSQL 資料庫伺服器。 資料庫將不被遷移除非您恢復連接。',
    'backup__restore__capability_db_server_connection_problems_resolution' => '請查看目的資料庫伺服器上的連接設定。',
    'backup__restore__capability_component_not_enabled_server_wide_text' => '目標伺服器上的元件 %1 已被關閉。',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => '請打開目標伺服器上的 %1。',
    'backup__restore__capability_not_configured_component_text' => '目標伺服器上的元件 %1 未進行配置。',
    'backup__restore__capability_not_configured_component_resolution' => '請在 工具與設定 頁面上配置 %1。',

    'backup__restore__capability_webmail_is_not_available' => '目標伺服器上沒有 %1 web 郵箱服務。Plesk 將會使用以下 web 郵箱服務：%2。%2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => '若要使用與原始伺服器上相同的 web 郵箱，應在此伺服器上將其安裝。',
    'backup__restore__capability_webmail_is_not_installed_resolution' => '要使用與原始伺服器上相同的 web 郵箱，您應在目的伺服器上安裝它。',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "目標伺服器上沒有 '%1' web 郵箱。而在以下訂閱上：%3, Plesk 將會使用以下 web 郵箱服務：%2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => '請在目的伺服器上安裝所需的 web 郵箱。',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'web 郵箱設定',

    'backup__restore__capability_shell_is_not_available' => '目標伺服器上沒有 shell %1。 將會使用現有的一個 shells。',
    'backup__restore__capability_shell_is_not_available_resolution' => '要使用與原始伺服器上相同的 shell，您應該在目標伺服器上打開 (in /etc/shells) 或安裝該 shell。',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => '目標 DNS 伺服器不支援傳輸限制範本中的網路。 將不會恢復 DNS 遷移限制中的網路 IP 位址的記錄。',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => '目標 DNS 伺服器不支援傳輸限制範本中的網路，但是一些訂閱有 DNS 遷移限制中的網路。 將不會恢復 DNS 遷移限制中的網路 IP 位址的記錄。',

    'backup__restore__capability_wrong_php_handler_text' => '目標伺服器上沒有 PHP 處理器 %1。而 Plesk 將會使用以下 PHP 處理常式：%2.',
    'backup__restore__capability_wrong_php_handler_resolution' => '要使用與原始伺服器上相同的 PHP 處理器，您應該在目標伺服器上打開或安裝該 PHP 處理器。',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP 處理常式 %1 不可用。對於以下服務方案，Plesk 將會使用 %2：{{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP 處理常式 %1 不可用。對於以下網站，Plesk 將會使用 %2：{{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP handler %1 不可用。對以下網站將不可用：{{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '目標伺服器上沒有 %1 %2 。 將會使用默認的版本。',
    'backup__restore__capability_wrong_component_version_resolution' => '要使用與原始伺服器上相同的 %1，您應該在目標伺服器上打開或安裝該 %1。',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => '目標伺服器上的殺毒軟體使用策略不允許為傳出郵件配置個人（每電郵地址）殺毒軟體設定。這些設定將不被遷移。',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => '目標伺服器上的殺毒軟體使用策略不允許為傳入郵件配置個人（每郵寄位址）殺毒軟體設定。這些設定將不被遷移。',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => '目標伺服器上的殺毒軟體使用策略不允許為發送郵件配置個人（每電郵地址）殺毒軟體設定。這些設定將不被遷移。',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "要遷移個人（每電郵地址）殺毒軟體設定，請進入 工具與設定 > 病毒防護設定 打開相應的選項。",
    'backup__restore__capability_antivirus_not_active_text' => '沒有啟用殺毒軟體。來自原始伺服器的所有殺毒軟體設定只有在您於目的伺服器上選定了該軟體才能使用。',
    'backup__restore__capability_antivirus_not_active_resolution' => '請進入 工具與設定 > 病毒防護設定 > 殺毒軟體設定 選定該殺毒軟體。',

    'backup__restore__capability_antivirus_another_active_text' => '目標伺服器上沒有殺毒軟體 %2 。將會使用 %1。',
    'backup__restore__capability_antivirus_another_active_resolution' => '要使用與原始伺服器上相同殺毒軟體，請安裝該軟體並進入 工具與設定 > 病毒防護設定 > 殺毒軟體設定 選定該軟體。',
    'backup__restore__capability_not_available_sni_text' => '目標伺服器上沒有 SNI。共用相同 IP 位址的網站將無法使用單獨的 SSL/TLS 證書。',
    'backup__restore__capability_not_available_sni_resolution' => "請查看目的伺服器上的作業系統是否支援 SNI 且是否在 Plesk 中啟用了 SNI 支援（進入 工具與設定 > 伺服器設定 標籤勾選核取方塊 '啟用 SNI 支援，允許共用相同 IP 位址的網站使用單獨的 SSL/TLS 證書'）。",
    'backup__restore__capability_not_available_sni_resolution_url_text' => '伺服器設定',

    'backup__restore__capability_vhost_already_exists_text' => '無法遷移網站 %1：與目的伺服器上存在相同名稱的網站',
    'backup__restore__capability_vhost_already_exists_resolution' => '請重命名或從伺服器上移除具有相同名稱的網站。',
    'backup__restore__capability_removed_vhosts' => '將不會恢復以下訂閱因為它們包含在目的伺服器上已經存在的域名:%1',
    'backup__restore__capability_duplicate_php_handler_text' => '在原始伺服器上有 %3 個不同的 %1 類型 %2 版本的 PHP 處理器。而將有一個合適類型和版本的處理器用於目的伺服器上。注意原始伺服器和目的伺服器上的 PHP 設定可能會不同。',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk 安裝程式不支援 Microsoft Frontpage。',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk 安裝程式不支援 Python。請手動安裝 Python。',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => '郵件伺服器設定',

    'backup__restore__capability_ftps_disabled' => '允許在原始伺服器上使用安全 FTPS 但是禁止在目標伺服器上使用。使用 FTP 的使用者應用程式可能運行不正常。',
    'backup__restore__capability_ftps_required' => '允許在原始伺服器上使用非安全 FTP 但是禁止在目標伺服器上使用。使用 FTP 的使用者應用程式可能運行不正常。',
    'backup__restore__capability_ftps_policy_resolution' => '更改安全 FTP 策略請進入 工具與設定 > 安全策略。',

    'backup__restore__capability_too_much_download_time_text' => '將會在 %2 小時內從原始伺服器移動 %1 MB 資料到目的伺服器。',
    'backup__restore__capability_too_much_download_time_resolution' => '為了更快傳輸，請查看原始伺服器和目的伺服器之間的網路連接並解決出現的問題。',
    'backup__restore__too_low_download_speed' => "小於 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => '為了更快傳輸，請查看原始伺服器和目的伺服器之間的網路連接並解決出現的問題。',
    'backup__restore__capability_zero_download_speed_text' => '可接受的最慢下載速度是 %1 MBps。原始伺服器和目的伺服器之間的下載速度是 0 MBps。這可能是網路連接問題引起的。無法傳輸。',
    'backup__restore__capability_zero_download_speed_resolution' => '請查看原始伺服器和目的伺服器之間的網路連接並解決問題。',
    'backup__restore__capability_too_slow_download_speed_text' => '可接受的最慢下載速度是 %2 MBps。原始伺服器和目的伺服器之間的下載速度是 %1 MBps。這可能會增加傳輸的時間。在您當前的環境中，遷移 %3 MB 將需要 %4 小時。',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => '可接受的最慢下載速度是 %2 MBps。原始伺服器和目的伺服器之間的下載速度是 %1 MBps。這可能會增加傳輸的時間。',

    'backup__restore__capability_remote_database_migration' => "以下的域名正使用遠端資料庫：%1",
    'backup__restore__capability_remote_database_migration_resolution' => "如果原始伺服器上的 Plesk  版本早於 11.5，遷移後不要從原始伺服器上移除這些域名。請掛起它們。如果您移除域名，資料庫將會從遠端伺服器上被移除。注意：遠端資料庫的轉儲檔將會存儲於原始伺服器上的 %1 目錄中。",

    'backup__restore__capability_mysql_50_to_51_migration' => '早於 5.1 (%1) 的 MySQL 資料庫伺服器的備份檔案可能不會在 MySQL 5.1.x 上恢復，因為 MySQL 5.1.x 處理 Unicode 字元的方式不同。',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => '請參閱相關的知識庫文章 #136850',

    'backup__restore__capability_firewall_not_installed_text' => '目標伺服器上的未安裝防火牆擴展。如果您建立了存取限制規則，該規則將無法實現。',
    'backup__restore__capability_firewall_not_installed_resolution' => '請使用 Plesk 安裝程式安裝防火牆擴展。',
    'backup__restore__capability_courier_not_installed_text' => '未在目的伺服器上安裝 Courier-IMAP。',
    'backup__restore__capability_courier_not_installed_resolution' => '請使用 Plesk 安裝程式安裝 Courier-IMAP。',
    'backup__restore__capability_dovecot_not_installed_text' => '未在目的伺服器上安裝 Dovecot。',
    'backup__restore__capability_dovecot_not_installed_resolution' => '請使用 Plesk 安裝程式安裝 Dovecot。',

    'backup__restore__wrong_stat_ttl_value_text' => '以下對象配置中的流量統計保留時間小於目的伺服器上的伺服器級的值。',
    'backup__restore__wrong_stat_ttl_value_resolution' => '請在目的伺服器上更改伺服器級的統計保留時間。設定該時間等於或小於域名配置中的最小值。',
    'bu_conflict_resolver_wrong_stat_ttl_value' => '一些域名的流量統計保留時間的值小於伺服器級的值 (%1)。這些域名的此值將會更改為 %1。',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => '一些服務方案的流量統計保留時間的值小於伺服器級的值 (%1)。這些服務方案的此值將會更改為 %1。',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => '映射專用 IP 位址至共用位址將會禁用匿名 FTP 和 HTTPS（除非啟用 SNI 支援）。',

    'backup__restore__no_postgresql_commands_text' => '訂閱使用了遠端 PostgreSQL 資料庫，無法生成其臨時的備份檔案因為原始伺服器上丟失了 pg_dump 和 psql 命令。',
    'backup__restore__no_postgresql_commands_resolution' => '請安裝任何可支援這些命令的 PostgreSQL 用戶端套裝程式。',
    'backup__restore__capability_apache_modules_disabled_text' => '在目的伺服器上禁用了以下 Apache 模組：%1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => '請啟用這些模組以阻止可能的問題出現。',
    'backup__restore__capability_apache_modules_not_installed_text' => '在目的伺服器上未安裝以下 Apache 模組：%1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => '請安裝和啟用這些模組以阻止可能的問題出現。',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => '您的許可證不支援傳出資訊限制。將不遷移相應的配置設定。',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => '請在目標伺服器上安裝可提供所需功能的其他許可證金鑰。',
    'backup__restore__capability_disabled_outgoing_antispam' => '目的伺服器上的傳出資訊限制已被關閉。將不遷移相應的配置設定。',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => '請打開目標伺服器上的傳出資訊限制。',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => '伺服器級的郵件設定',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => '目的伺服器上使用的郵件伺服器不支援限制郵箱的傳出資訊。將不遷移該限制的值。',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => '請修改郵件伺服器與您在原始伺服器上使用的一致。',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => '伺服器級的郵件設定',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => '目的伺服器上使用的郵件伺服器不支援限制域名的傳出資訊。將不遷移該限制的值。',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => '請修改郵件伺服器與您在原始伺服器上使用的一致。',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => '伺服器級的郵件設定',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => '目的伺服器上使用的郵件伺服器不支援限制訂閱的傳出資訊。將不遷移該限制的值。',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => '請修改郵件伺服器與您在原始伺服器上使用的一致。',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => '伺服器級的郵件設定',

    'bu_conflict_resolver_absent_phosting' => '無法恢復指定的檔因為用於存儲它們的物理主機不存在。請首先使用物理主機創建一個域名然後再開始恢復備份。',
    'bu_conflict_resolver_resellers_management_is_not_supported' => '由於不支援代理商管理，因此將不恢復代理商數據。',

    'backup__restore__capability_modsecurity_not_installed_text' => '目標伺服器上未安裝 ModSecurity 組件。',
    'backup__restore__capability_modsecurity_not_installed_resolution' => '如果您希望 web 應用程式防火牆對傳輸的網站保持有效請安裝 ModSecurity。注意安裝可能需要幾分鐘。',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => '如果您想要傳輸 web 應用程式防火牆的設定請安裝 ModSecurity。注意安裝可能需要幾分鐘。',
    'backup__restore__capability_modsecurity_not_configured_text' => '目標伺服器上的 ModSecurity 未進行配置。',
    'backup__restore__capability_modsecurity_not_configured_resolution' => '如果您希望 web 應用程式防火牆對傳輸的網站保持有效請配置 ModSecurity。',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Web 應用程式防火牆 (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => '目標伺服器上的 ModSecurity 已被關閉。',
    'backup__restore__capability_modsecurity_not_active_resolution' => '如果您希望 web 應用程式防火牆對傳輸的網站保持有效請啟動 ModSecurity。',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Web 應用程式防火牆 (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => '未安裝 ModSecurity 組件。將不會恢復以下對象的 web 防火牆設定：{{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "無法恢復網站因為它們隸屬在 Plesk 中無法找到的訂閱  %1：",
    'backup__restore__capability_not_installed_dns_text' => '目標伺服器上的未安裝組件 %1。DNS 服務將不可用而 DNS 設定將會丟失。所有客戶的網站都會停止運行。',
    'bu_conflict_resolver_dns_not_installed' => '未安裝 DNS 服務。將不會恢復以下對象的 DNS 設定：{{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => '無法恢復以下訂閱，因為它們已被移動給其它所有者：\'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => '無法恢復以下訂閱，因為它們已被移動給其它提供商：\'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => '無法找到 Web Presence Builder 恢復工具來恢復 Web Presence Builder 資料。Web Presence Builder 可能還未安裝。',
    'backup__restore__capability_renamed_db' => '資料庫名稱 "%1" 已被其它訂閱使用。被恢復的資料庫的名稱將被更改為 "%2"。',
    'backup__restore__capability_renamed_db_user' => '資料庫用戶名稱 "%1" 已被其它訂閱使用。被恢復的資料庫使用者的名稱將被更改為 "%2"。',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk 安裝程式不支援 Perl。請手動安裝 ActiveState Perl。',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => 'Apache (id=%%id%%) 支援的 %%version%% %%type%%',
    'backup__restore__capability_php_handler_served_by_nginx' => 'nginx (id=%%id%%) 支援的 %%version%% %%type%%',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Timing conflicts
    'backup__restore__timing_conflicts' => '計時衝突',
    'backup__restore__hint_timing_conflicts' => '計時衝突出現情況: 當恢復對象已在系統中，且新近修改日期更接近，或恢復對象當前沒有出現在系統中。',
    'backup__restore__text_timing_resolution_policy_overwrite' => '使用備份配置及資料',
    'backup__restore__hint_timing_resolution_policy_overwrite' => '使用備份檔案配置和資料完全覆蓋系統中當前出現的對象配置和資料。如果當前恢復的對象屬於不同的所有者，則該對象會在前所有者下恢復。',
    'backup__restore__text_timing_resolution_policy_proceed' =>  '使用當前系統組態及來自備份的資料',
    'backup__restore__hint_timing_resolution_policy_proceed' => '使用備份檔案資料覆蓋當前對象資料，但保留系統中的當前出現的對象配置。如果當前恢復的對象屬於不同的所有者，則該對象會在當前所有者下恢復。',
    'backup__restore__text_timing_resolution_policy_do_not_restore' => '請不要恢復',
    'backup__restore__hint_timing_resolution_policy_do_not_restore' => '請不要恢復有計時衝突的對象。',
    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => '資源使用衝突',
    'backup__restore__hint_resource_usage_conflicts' => '恢復後，恢復對象所用資源超出限制，則會出現資源使用衝突。',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => '允許超額使用',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => '恢復對象，並允許它使用多於初始分配的資源量。',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => '請不要恢復',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => '請不要恢復有資源使用衝突的對象。',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => '配置衝突',
    'backup__restore__hint_configuration_conflicts' => '配置衝突出現情況: 恢復的對象設定與web應用程式不可用或被當前伺服器或對象擁有者策略禁止。例如，如果郵件帳戶有獨立的垃圾郵件過濾設定，但當前伺服器級策略不允許郵件帳戶有這些設定，則會出現配置衝突。',
    'backup__restore__text_configuration_resolution_policy_automatic' => '自動',
    'backup__restore__hint_configuration_resolution_policy_automatic' => '恢復對象，並自動啟用您可以管理的所有衝突配置選項。',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => '請不要恢復',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => '請不要恢復有配置衝突的對象。',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'IIS 應用程式池設定中不允許獨立 IIS 應用程式池。',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => '請進入 工具與設定 > IIS 應用程式池 > 全域設定 更改您的 IIS 應用程式池設定。',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'IIS 應用程式池設定中不允許共用 IIS 應用程式池。',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => '請進入 工具與設定 > IIS 應用程式池 > 全域設定 更改您的 IIS 應用程式池設定。',

    'backup__restore__unable_allow_short_pop3 _names_text' => '目的伺服器上不允許使用簡短的 POP3/IMAP 郵件帳戶名稱。',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => '恢復資料後郵件帳戶無法使用簡短名稱',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => '無法打開日誌檔。',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => '無法恢復訂閱 %1： 它已從您的帳戶上移除，您沒有許可權創建訂閱。如果您需要恢復，請聯繫您的服務提供者。',

    'backup__error11' => '用於備份的磁碟空間不夠。',
    'backup__error3011' => '連接被拒絕：沒有程式正在監聽指定的地址和埠。',
    'backup__error3012' => '連接逾時。',
    'backup__error3013' => '網路不可到達。',
    'backup__error3014' => '未路由到主機。',
    'backup__error3015' => '連接失敗。',
    'backup__error3016' => '無法解析主機名稱。',
    'backup__error3017' => '用戶名或密碼不正確。',
    'backup__error3018' => 'SSH 連接失敗。',

    'backup__error3110' => '無法連接遠端遷移代理：無法連接到主機。',
    'backup__error3111' => '遷移代理已被一項失敗的遷移任務鎖定或正被其它遷移流程使用。請在原始伺服器上重新開機遷移代理。',
    'backup__error3112' => '無法連接到主機或源主機上未運行遷移代理。',
    'backup__error3113' => '無法在 Linux 主機上部署遷移代理。請檢查到源主機的 SSH 連接。',
    'backup__error3114' => '無法在 Linux 主機上部署遷移代理。SSH 連接失敗。',
    'backup__error3115' => '用戶名或密碼不正確。',
    'backup__error3116' => '指定的用戶沒有管理許可權。',

    'backup__scheduled_backup_settings__backup_of_domain_all_at_domain' => '所有配置及內容',
    'backup__scheduled_backup_settings__backup_of_domain_vhost_only' => '所有配置及內容(郵件除外)',
    'backup__scheduled_backup_settings__backup_of_domain_mail_only' => '僅限郵件配置及內容',

    'dns_t__unable_to_remove_ns_record' => '無法從 DNS 範本中移除 NS 記錄： 每個 DNS 區域必須至少有一個 NS 記錄。',
    'dns__unsupported_server_zone_transfer' => '因為伺服器級別的 DNS 配置導致無法傳輸 傳輸限制範本： 在原始伺服器上，允許以下網路位址進行區域遷移，但是 Microsoft DNS Server 禁止這些位址進行此操作： %1',
    'dns__unsupported_domain_zone_transfer' => '因為域名的 DNS 配置導致無法傳輸 傳輸限制範本： 在一些域名上，允許以下網路位址進行區域遷移，但是 Microsoft DNS Server 禁止這些位址進行此操作： %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'backup__db_mapping__title' => '定義資料庫伺服器映射',
    'dbbackup__check_network_settings_failed' => '無法存取備份檔案的共用臨時網路目錄。請檢查網路目錄、用戶名和密碼設定。錯誤：%1',

    'migration_select_exist_db_server' => '選擇目的資料庫伺服器',

    'dbbackup__temp_dir_wrong_value' => '指定的臨時目錄的值無效。',
    'dbbackup__network_temp_dir_wrong_value' => '指定的臨時網路目錄的值無效。',
    'dbbackup__dumpfile_name_is_invalid' => '資料庫備份檔案名無效：名稱只能包含字母數位元元、破折號(-)、點號(.) 和底線(_)。不得使用諸如 description.* 之類的名稱作為備份檔案名。',
    'dbbackup__server_backup_not_configured' => '在伺服器上未配置資料庫備份設定。',
    'dbbackup__temp_dir' => '臨時目錄',
    'dbbackup__temp_dir_hint' => '進入 MS SQL 伺服器所在的遠端伺服器上的物理資料夾的路徑。該 MS SQL 伺服器必須能夠存取該資料夾以讀取和寫入臨時備份檔案。例如，C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => '網路共用的路徑被映射到以上指定的物理資料夾。Plesk 將會存取共用資料夾以下載和上傳備份檔案。例如，\\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => '在遠端伺服器上創建的網路使用者的用戶名。例如，ServerName\\UserName。該用戶必須有存取以上指定的共用資料夾的許可權。',
    'dbbackup__network_password_hint' => '網路使用者的密碼',

    'dbbackup__success_import_without_dublicate_users' => '以下用戶未被導入：%1。它們已存在於資料庫伺服器上。',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "壓縮日誌檔",
    'log_rot__log_rot_status' => "日誌迴圈狀態",
    'log_rot__log_rot_period' => "日誌迴圈條件",
    'log_rot__log_rot_size' => "按大小",
    'log_rot__log_rot_time' => "按時間",
    'log_rot__logrotation_enable' => "啟用日誌迴圈",
    'log_rot__mail' => "將已處理的日誌檔發送到電子郵件",
    'log_rot__max_number_of_logfiles' => "最大日誌檔數量",
    'log_rot__time_period' => "週期",
    'log_rot__unable_turn_off' => '无法关闭日志轮转，因为它是在服务器级别上强制执行的',
    'log_rot__unable_set_period' => '无法将日志轮转周期的形式设置为不同于\'daily\'，因为它是在服务器级别上强制执行的',
    'log_rot__unable_set_max_log_files' => '无法将日志文件的最大值设置得比服务器范围内的限制%1大',

    /// action log
    // common/various
    'actionlog__confirm_clean_log' => "您確定要刪除相應操作的日誌記錄嗎？",
    'actionlog__digit_expected' => "期望值：%1",
    'actionlog__dont_remove_recs' => "不要刪除記錄",
    'actionlog__from_date' => "開始時間：",
    'actionlog__incorrect_rotation' => "指定了無效的日誌迴圈參數：%1。",
    'actionlog__js_incorrect_date' => "指定的日期無效。",
    'actionlog__js_incorrect_num_periods' => "指定的迴圈週期無效。",
    'actionlog__js_incorrect_num_records' => "指定的記錄數無效。",
    'actionlog__logged_actions' => "記錄的操作",
    'actionlog__period_day' => "天",
    'actionlog__period_month' => "月",
    'actionlog__period_week' => "星期",
    'actionlog__settings' => "操作日誌設定",
    'actionlog__store_logs_in_db' => "在資料庫中存儲記錄",
    'actionlog__store_number' => "項目",
    'actionlog__to_date' => "結束時間：",
    'actionlog__unknown_rot_period' => "未知的迴圈週期：%1。",
    'actionlog__unknown_rot_type' => "未知的迴圈類型：%1。",
    'actionlog__wrong_date_period' => "無效日期",
    'actionlog__session_preferences' => '會話設定',
    // items (PFU schema)
    'actionlog__admin_info' => '管理員資訊',
    'actionlog__admin_preferences' => "管理員的偏好設定",
    'actionlog__service' => '服務',
    'actionlog__ip_addr' => 'IP 地址',
    'actionlog__client' => '客戶帳戶',
    'actionlog__client_status' => '客戶帳戶狀態',
    'actionlog__client_preferences' => "客戶介面偏好設定",
    'actionlog__client_ip_pool' => "客戶IP池",
    'actionlog__client_siteapp' => "客戶的域名應用程式池",
    'actionlog__client_guid' => "客戶GUID",
    'actionlog__domain' => '默認域名（添加到訂閱的第一個域名）',
    'actionlog__domain_owner' => '訂閱所有者',
    'actionlog__domain_plan' => '訂閱的服務方案',
    'actionlog__domain_status' => '預設域名、狀態',
    'actionlog__domain_dns' => '預設域名、DNS 區域',
    'actionlog__subdomain' => '默認域名的子域名',
    'actionlog__domain_alias' => '默認域名、別名',
    'actionlog__domain_alias_dns' => '預設域名、別名 DNS 區域',
    'actionlog__site' => '域名',
    'actionlog__site_status' => '域名狀態',
    'actionlog__site_dns' => '域名  DNS 區域',
    'actionlog__site_guid' => '域名 GUID',
    'actionlog__site_subdomain' => '子域名',
    'actionlog__site_alias' => '域名別名',
    'actionlog__site_alias_dns' => '域名別名 DNS 區域',
    'actionlog__domain_limits' => '訂閱上限',
    'actionlog__domain_limit_size' => '訂閱的磁碟空間上限',
    'actionlog__domain_limit_traffic' => '訂閱的流量上限',
    'actionlog__domain_limits_powerUser' => '訂閱上限',
    'actionlog__domain_limit_size_powerUser' => '訂閱的磁碟空間上限',
    'actionlog__domain_limit_traffic_powerUser' => '訂閱的流量上限',
    'actionlog__domain_guid' => "默認域名、GUID",
    'actionlog__cp_user' => 'Plesk 用戶',
    'actionlog__mailname' => '郵件帳戶',
    'actionlog__maillist' => '郵寄清單',
    'actionlog__phosting' => '主機設定',
    'actionlog__forwarding' => '標準或幀轉發主機',
    'actionlog__webuser' => '網站使用者帳戶',
    'actionlog__site_application' => 'web應用程式',
    'actionlog__license' => '許可證號',
    'actionlog__additional_license' => '額外的許可證金鑰',
    'actionlog__template_domain' => "代理商服務方案",
    'actionlog__template_admin' => "管理員域名方案",
    'actionlog__template_reseller' => '代理商方案',
    'actionlog__admin_alias' => '其他管理員帳戶', // PFW
    'actionlog__ftpuser' => '其它的 FTP 帳戶', // PFW
    'actionlog__db_server' => '資料庫伺服器',
    'actionlog__db' => '資料庫',
    'actionlog__db_user' => '資料庫使用者帳戶',
    'actionlog__client_sapppkg_pool' => "使用者web應用程式", // PFW, not used?
    'actionlog__remote_dns' => '遠端DNS伺服器狀態', // PFW
    'actionlog__reseller' => '代理商帳戶',
    'actionlog__reseller_guid' => '代理商的GUID',
    'actionlog__reseller_ip_pool' => "代理商的IP池",
    'actionlog__reseller_limit_size' => '代理商帳戶磁碟空間限制',
    'actionlog__reseller_limit_traffic' => '代理商帳戶流量限制',
    'actionlog__reseller_limits' => '代理商帳戶限制',
    'actionlog__reseller_permissions' => '代理商許可權',
    'actionlog__reseller_preferences' => "代理商的介面偏好設定",
    'actionlog__reseller_siteapp' => "代理商池中的Web應用程式",
    'actionlog__reseller_status' => '代理商帳戶狀態',
    'actionlog__health_status' => '伺服器健康狀態',
    // actions (PFU schema)
    'actionlog__limit_reached' => '達到',
    'actionlog__added' => '添加',
    'actionlog__removed' => '刪除',
    'actionlog__change' => '更改',
    'actionlog__update' => '更新',
    'actionlog__move' => '已移動',
    'actionlog__upgrade' => '已升級', // PFU?
    'actionlog__update_or_add' => '更新或添加',
    'actionlog__expired' => '過期',
    'actionlog__create' => '創建',
    'actionlog__delete' => '刪除',
    'actionlog__service_stop' => '停止',
    'actionlog__service_restart' => '重啟',
    'actionlog__service_start' => '啟動',
    'actionlog__login' => '登入',
    'actionlog__logout' => '登出',
    'actionlog__install' => '安裝',
    'actionlog__uninstall' => '卸載',
    'actionlog__reconfigure' => '重新配置',
    // events (PFW schema)
    'actionlog__event_admin_update' => '管理員資訊更新',
    'actionlog__event_admin_preferences_update' => "已更新管理員的偏好設定",
    'actionlog__event_service_restart' => '服務已重啟',
    'actionlog__event_service_start' => '服務已啟動',
    'actionlog__event_service_stop' => '服務已停止',
    'actionlog__event_ip_address_create' => '已創建 IP 地址',
    'actionlog__event_ip_address_delete' => 'IP地址已刪除',
    'actionlog__event_ip_address_update' => 'IP位址已更新',
    'actionlog__event_client_create' => '已創建客戶帳戶',
    'actionlog__event_client_delete' => '客戶帳戶已刪除',
    'actionlog__event_client_update' => '客戶帳戶已更新',
    'actionlog__event_client_status_update' => '客戶帳戶狀態已更新',
    'actionlog__event_client_preferences_update' => "客戶介面偏好設定已更新",
    'actionlog__event_client_siteapp_added' => "客戶應用套裝程式已添加到客戶帳戶應用程式池",
    'actionlog__event_client_siteapp_removed' => "已從客戶帳戶應用程式池中刪除Web應用程式",
    'actionlog__event_domain_limit_size_reached' => '已達到訂閱的磁碟空間上限',
    'actionlog__event_domain_limit_traffic_reached' => '已達到訂閱的流量上限',
    'actionlog__event_domain_limit_size_reached_powerUser' => '已達到訂閱的磁碟空間上限',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => '已達到訂閱的流量上限',

    'actionlog__domain_limit_database' => '訂閱的資料庫配額',
    'actionlog__event_domain_limit_mysql_quota_reached' => '已達到訂閱的 MySQL 資料庫配額',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => '已達到訂閱的 MySQL 資料庫軟配額',
    'actionlog__event_domain_limit_mssql_quota_reached' => '已達到訂閱的 Microsoft SQL 伺服器資料庫配額',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => '已達到訂閱的 Microsoft SQL 伺服器資料庫軟配額',
    'actionlog__event_plesk_component_upgrade' => 'Plesk 組件已更新',
    'actionlog__event_plesk_component_install' => 'Plesk 組件已安裝',
    'actionlog__event_plesk_component_uninstall' => 'Plesk 組件已卸載',
    'actionlog__event_domain_create' => '已創建默認域名（添加到訂閱的第一個域名）',
    'actionlog__event_domain_delete' => '已刪除默認域名（添加到訂閱的第一個域名）',
    'actionlog__event_domain_update' => '已更新默認域名（添加到訂閱的第一個域名）',
    'actionlog__event_domain_owner_change' => '訂閱所有者已更改',
    'actionlog__event_domain_plan_change' => '已更改訂閱的服務方案',
    'actionlog__event_domain_status_update' => '已更新的預設域名、狀態',
    'actionlog__event_domain_dns_update' => '已更新的預設域名、DNS 區域',
    'actionlog__event_subdomain_create' => '已創建默認域名的子域名',
    'actionlog__event_subdomain_delete' => '默認域名的子域名已刪除',
    'actionlog__event_subdomain_update' => '默認域的子域名已更新',
    'actionlog__event_domain_alias_create' => '已創建默認域名、別名',
    'actionlog__event_domain_alias_delete' => '默認域名、別名已刪除',
    'actionlog__event_domain_alias_update' => '默認域名、別名已更新',
    'actionlog__event_domain_limits_update' => '已更新的訂閱上限',
    'actionlog__event_cp_user_login' => 'Plesk 用戶登入',
    'actionlog__event_cp_user_logout' => 'Plesk 用戶登出',
    'actionlog__event_mailname_create' => '已創建郵件帳戶',
    'actionlog__event_mailname_delete' => '郵件帳戶已刪除',
    'actionlog__event_mailname_update' => '郵件帳戶已更新',
    'actionlog__event_maillist_create' => '已創建郵寄清單',
    'actionlog__event_maillist_delete' => '郵寄清單已刪除',
    'actionlog__event_maillist_update' => '郵寄清單已更新',
    'actionlog__event_phys_hosting_create' => '已創建物理主機',
    'actionlog__event_phys_hosting_delete' => '物理主機已刪除',
    'actionlog__event_phys_hosting_update' => '物理主機已更新',
    'actionlog__event_forwarding_create' => '已創建標準或幀轉發主機',
    'actionlog__event_forwarding_delete' => '標準或幀轉發主機已刪除',
    'actionlog__event_forwarding_update' => '標準或幀轉發主機已更新',
    'actionlog__event_webuser_create' => '已創建網站使用者帳戶',
    'actionlog__event_webuser_delete' => '網站使用者帳戶已刪除',
    'actionlog__event_webuser_update' => '網站使用者帳戶已更新',
    'actionlog__event_siteapp_install' => 'Web應用程式已安裝',
    'actionlog__event_siteapp_reconfigure' => 'Web應用程式已重新配置',
    'actionlog__event_siteapp_uninstall' => 'Web應用程式已卸載',
    'actionlog__event_license_update' => '許可證已更新',
    'actionlog__event_admin_alias_create' => '其他所創建的管理員帳戶',
    'actionlog__event_admin_alias_delete' => '其他所刪除的管理員帳戶',
    'actionlog__event_admin_alias_update' => '其他所更新的管理員帳戶',
    'actionlog__event_ftpuser_create' => '已創建其他 FTP 帳戶',
    'actionlog__event_ftpuser_update' => '已更新FTP帳戶',
    'actionlog__event_ftpuser_delete' => '已刪除其他FTP帳戶',
    'actionlog__event_template_domain_create' => "已創建代理商服務方案",
    'actionlog__event_template_domain_update' => "代理商服務方案已更新",
    'actionlog__event_template_domain_delete' => "代理商服務方案已刪除",
    'actionlog__event_template_admin_create' => "已創建管理員的服務方案",
    'actionlog__event_template_admin_update' => "管理員服務方案已更新",
    'actionlog__event_template_admin_delete' => "管理員服務方案已刪除",
    'actionlog__event_database_server_create' => '已創建資料庫伺服器',
    'actionlog__event_database_server_update' => '資料庫伺服器已更新',
    'actionlog__event_database_server_delete' => '資料庫伺服器已刪除',
    'actionlog__event_remote_dns_status_update' => '遠端DNS伺服器狀態已更新',
    'actionlog__event_session_preferences_update' => '會話設定已更新',
    'actionlog__event_domain_alias_dns_update' => '默認域名、域名別名的 DNS 區域已更新',
    'actionlog__event_domain_move' => '默認的域名已移動到新的訂閱',
    'actionlog__event_site_move' => '域名已移動到新的訂閱',
    'actionlog__event_site_subdomain_move' => '已移動到新訂閱的子域名',
    'actionlog__event_subdomain_move' => '默認域名的子域名已移動到新的訂閱',
    'actionlog__event_license_expired' => 'Plesk 許可證已過期',
    'actionlog__event_database_create' => '創建的資料庫',
    'actionlog__event_database_delete' => '刪除的資料庫',
    'actionlog__event_database_user_create' => '創建的資料庫使用者帳戶',
    'actionlog__event_database_user_update' => '更新的資料庫使用者帳戶設定',
    'actionlog__event_database_user_delete' => '刪除的資料庫使用者帳戶',
    'actionlog__event_client_guid_update' => "客戶GUID已更新",
    'actionlog__event_domain_guid_update' => '默認域名、GUID 已更新',
    'actionlog__event_reseller_create' => '已創建代理商帳戶',
    'actionlog__event_reseller_delete' => '代理商帳戶已刪除',
    'actionlog__event_reseller_update' => '代理商帳戶已更新',
    'actionlog__event_reseller_guid_update' => '代理商的GUID已更新',
    'actionlog__event_reseller_ip_pool_update' => "代理商帳戶的IP池已更新",
    'actionlog__event_reseller_limit_size_reached' => '已達到代理商帳戶磁碟空間限制',
    'actionlog__event_reseller_limit_traffic_reached' => '已達到代理商帳戶流量限制',
    'actionlog__event_reseller_limits_update' => '代理商帳戶限制已更新',
    'actionlog__event_reseller_permissions_update' => '代理商帳戶許可權已更新',
    'actionlog__event_reseller_preferences_update' => "代理商介面偏好設定已更新",
    'actionlog__event_reseller_siteapp_added' => "添加到代理商帳戶應用程式池中的應用程式",
    'actionlog__event_reseller_siteapp_removed' => "從代理商帳戶應用程式池中刪除的應用程式",
    'actionlog__event_reseller_status_update' => '代理商帳戶狀態已更新',
    'actionlog__event_template_reseller_create' => '已創建代理商方案',
    'actionlog__event_template_reseller_delete' => '代理商方案已刪除',
    'actionlog__event_template_reseller_update' => '代理商方案已更新',
    'actionlog__event_health_status_change' => '已更改伺服器健康狀態',
    'actionlog__event_siteapp_upgrade' => 'Web app 已升級',
    'actionlog__event_extension_install' => '擴展已安裝',
    'actionlog__event_extension_uninstall' => '擴展已卸載',
    'actionlog__event_extension_upgrade' => '擴展已升級',
    'actionlog__event_extension_status_update' => '擴展狀態已更新',
    'actionlog__event_additional_license_expired' => '額外的許可證已到期',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "遠端主機上尚未安裝 Plesk API RPC。請向您的系統管理員尋求協助。",
    'rsession_no_account_errmsg' => "無法存取您帳戶下的遠端服務。最常見的原因可能是您帳戶下的服務尚未啟用。請稍候幾分鐘時間，然後重新嘗試。如果再次遇到此問題，請聯繫您的系統管理員。",
    'rsession_no_domain_errmsg' => "無法存取此域名的遠端服務。最常見的原因可能是此域名的服務尚未啟用。請稍候幾分鐘時間，然後重新嘗試。如果再次遇到此問題，請聯繫您的系統管理員。",
    'rsession_unknown_errmsg' => "遠端伺服器拒絕建立會話。請聯繫您的系統管理員以獲得支援。錯誤為：%1",
    'rsession_unknown2_errmsg' => "建立遠端會話時出現未知錯誤。最常見的原因可能是遠端伺服器未正確回應，或根本未回應。請聯繫系統管理員，查看web伺服器錯誤日誌中詳細的錯誤資訊。",
    'rsession_no_connect_errmsg' => "無法存取遠端服務：連接遠端會話失敗。請聯繫您的系統管理員以獲得支援。",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "允許上傳至接收目錄",
    'anonftp__allow_create_dirs' => '允許在接收目錄中創建目錄',
    'anonftp__allow_download_incoming' => '允許從接收目錄中下載',
    'anonftp__display_login' => '顯示登入資訊',
    'anonftp__login_text' => '消息文本',
    'anonftp__limit_incoming_disk_space' => "限制接收目錄的磁碟空間",
    'anonftp__limit_maximum_bandwidth' => "限制此虛擬 FTP 域名的下載頻寬",
    'anonftp__limit_maximum_connections' => "限制最大併發連接數",
    'anonftp__unable_init' => "無法初始化匿名 FTP 帳戶：%1。",
    'anonftp__unable_set_quota' => "無法設定接收目錄的磁片使用限制：%1。",
    'anonftp__unable_update' => "無法更新匿名 FTP 帳戶屬性：%1。",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS 證書', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA 證書沒有簽署此證書。",
    'class_sslcertificate__incompatible_pvt_key_cert' => "私密金鑰/證書對不相容。",
    'class_sslcertificate__invalid_cert_format' => "無效的證書格式。",
    'class_sslcertificate__invalid_private_key_format' => "無效的私密金鑰格式。",
    'class_sslcertificate__prob_invalid_priv_key' => "私密金鑰格式可能無效。",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => '創建虛擬目錄',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => '創建虛擬目錄',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => '創建虛擬目錄。',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => '創建虛擬目錄',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => '創建虛擬目錄',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => '創建虛擬目錄。',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => '創建目錄',
    'ui__client/domain/hosting/web-directories/create-dir__title' => '創建目錄',
    'ui__client/domain/hosting/web-directories/create-dir__description' => '創建目錄。',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => '創建目錄',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => '創建目錄',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => '創建目錄。',
    'ui__client/domain/hosting/web-directories/properties__short-title' => '目錄屬性',
    'ui__client/domain/hosting/web-directories/properties__title' => '虛擬目錄屬性',
    'ui__client/domain/hosting/web-directories/properties__description' => '查看和更改虛擬目錄屬性。',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => '目錄屬性',
    'ui__client/domain/hosting/web-directories/properties_self__title' => '虛擬目錄屬性',
    'ui__client/domain/hosting/web-directories/properties_self__description' => '查看和更改虛擬目錄屬性。',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => '目錄存取權限',
    'ui__client/domain/hosting/web-directories/permissions__title' => '目錄存取權限',
    'ui__client/domain/hosting/web-directories/permissions__description' => '設定目錄存取權限。',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => '目錄存取權限',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => '目錄存取權限',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => '設定目錄存取權限。',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'ASP.NET設定',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => '%1的ASP.NET設定',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => '配置虛擬目錄%1所用的ASP.NET設定。',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'ASP.NET設定',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => '%1的ASP.NET設定',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => '配置虛擬目錄%1的ASP.NET設定。',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__short-title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__description' => '更改虛擬目錄%1所用的ASP.NET版本。',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__short-title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__title' => '更改版本',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version_self__description' => '更改虛擬目錄%1的ASP.NET版本。',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP設定',
    'ui__client/domain/hosting/web-directories/php__title' => '%1 的PHP設定',
    'ui__client/domain/hosting/web-directories/php__description' => '配置虛擬目錄%1的PHP設定。',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP設定',
    'ui__client/domain/hosting/web-directories/php_self__title' => '%1的PHP設定',
    'ui__client/domain/hosting/web-directories/php_self__description' => '配置虛擬目錄%1的PHP設定。',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => '移除',
    'ui__client/domain/hosting/web-directories/delete__title' => '移除虛擬目錄',
    'ui__client/domain/hosting/web-directories/delete__description' => '移除所選虛擬目錄。',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => '移除',
    'ui__client/domain/hosting/web-directories/delete_self__title' => '移除虛擬目錄',
    'ui__client/domain/hosting/web-directories/delete_self__description' => '移除所選虛擬目錄。',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => '即將移除下列虛擬目錄:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => '請選擇要移除的目錄。',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => '查看註冊的MIME類型列表。',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => '添加MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => '添加 MIME 類型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => '註冊新MIME類型。',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => '錯誤文檔',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => '錯誤文檔',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => '查看和更改錯誤文檔。',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => '保護',
    'ui__client/domain/hosting/web-directories/protection__title' => '目錄保護',
    'ui__client/domain/hosting/web-directories/protection__description' => '使用密碼限制存取目錄。',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => '保護',
    'ui__client/domain/hosting/web-directories/protection_self__title' => '目錄保護',
    'ui__client/domain/hosting/web-directories/protection_self__description' => '使用密碼限制存取目錄。',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => '設定',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => '查看目錄位置，並指定受保護區標題。',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => '添加用戶',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => '添加使用者帳戶以允許存取受保護目錄。',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => '已應用新設定。',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => '已添加使用者帳戶。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => '移除',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => '移除受保護目錄的使用者。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => '移除使用者帳戶',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => '確認移除使用者帳戶。',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => '已移除使用者帳戶。',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // non-UI
    'check_permissions_done' => '檢查域名許可權進程已開始。完成檢查後，則會發送郵件到: %1', // PFW
    'additional_keys__install_done' => '許可證安裝進程已開始。',

    // UI
    'ui____done' => '成功完成操作。',
    'ui__actionlog__done' => "操作日誌變更已保存。",
    'ui__admin/extras-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__admin/interface__done' => '伺服器管理員的介面偏好設定已保存。',
    'ui__admin/report/layout/delete_multi__done' => '所選報告佈局已移除。',
    'ui__admin/report/traffic-history__done' => '成功完成操作。',
    'ui__admin/report__done' => '成功完成操作。',
    'ui__admin-alias/delete_multi__done' => "所選管理員子帳戶已刪除。",
    'ui__admin-alias/properties__done' => "管理員子帳戶屬性已更新。",
    'ui__admin-alias/properties_new__done' => "已創建其他的管理員帳戶。",
    'ui__admin-alias/properties_unknown__done' => "管理員子帳戶屬性已更新。",
    'ui__admin-alias__done' => "管理員子帳號資訊已成功更新。",
    'ui__admin/manage-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__admin/register-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__admin/report/layout/auto/delete_multi__done' => '所選報告發送計畫已刪除。',
    'ui__admin/report/layout/auto/properties__done' => '報告發送計畫已更新。',
    'ui__admin/report/layout/auto/properties_new__done' => '已創建報告發送計畫。',
    'ui__admin/report/layout/properties__done' => '報告佈局%1已更新。',
    'ui__admin/report/layout/properties_new__done' => '報告佈局%1已更新。',
    'ui__client/chowner__done' => '已分配新所有者給客戶帳戶%1。',
    'ui__client/chowner_multi__done' => "所選使用者帳戶已轉給另一所有者。",
    'ui__client/chowner_multi-select__done' => '成功完成操作。',
    'ui__client/chowner_select__done' => '成功完成操作。',
    'ui__client/domain/certificate/properties__done' => '已更新 SSL/TLS 證書屬性。',
    'ui__client/domain/certificate/properties_new__done' => '已添加新的 SSL/TLS 證書。若要讓其運行，需在網站主機設定裡選擇該證書（進入 網站與域名 標籤> 域名）。',
    'ui__client/domain/certificate__done' => '成功完成操作。',
    'ui__client/domain/certificate_self__done' => '成功完成操作。',
    'ui__client/domain/check-permissions_multi__done' => '已完成對所選域名的許可權檢查。', // PFW
    'ui__client/domain/chowner__done' => '現在訂閱%1屬於另一個用戶。',
    'ui__client/domain/chowner_multi__done' => '訂閱所有權已更改。',
    'ui__client/domain/chowner_multi-select__done' => '成功完成操作。',
    'ui__client/domain/chowner_select__done' => '成功完成操作。',
    'ui__client/domain/dbbackup/create__done' => "成功備份資料庫。", // PFW
    'ui__client/domain/dbbackup/get__done' => "成功備份資料庫。", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "成功修復孤立用戶。", // PFW
    'ui__client/domain/dbbackup/remove__done' => "成功刪除備份檔案。", // PFW
    'ui__client/domain/dbbackup/restore__done' => "成功恢復資料庫內容。", // PFW
    'ui__client/domain/dbbackup/upload__done' => "成功完成操作。", // PFW
    'ui__client/domain/dbbackup__done' => "成功完成操作。", // PFW
    'ui__client/domain/dbbackup_self__done' => "成功完成操作。", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "成功完成操作。", // PFW
    'ui__client/domain/delete__done' => "域名%1已刪除。",
    'ui__client/domain/delete_multi__done' => "域名已刪除。",
    'ui__client/domain/disable__done' => '域名%1已掛起。',
    'ui__client/domain/disable_multi__done' => '所選域名已掛起。',
    'ui__client/domain/enable__done' => '網站%1已啟動。',
    'ui__client/domain/enable_multi__done' => '所選網站已啟動。',
    'ui__client/domain/extras__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/domain/hosting/file-manager/copy-move__done' => '所選檔及目錄已複製或刪除。',
    'ui__client/domain/hosting/file-manager/create-dir__done' => '已創建目錄。',
    'ui__client/domain/hosting/file-manager/create-file__done' => '已創建文件。',
    'ui__client/domain/hosting/file-manager/edit__done' => '檔已更新。',
    'ui__client/domain/hosting/file-manager/permissions__done' => '檔或目錄存取權限已更新。', // PFU
    'ui__client/domain/hosting/file-manager/rename__done' => '目錄或檔已重命名。',
    'ui__client/domain/hosting/file-manager/remove__done' => '所選檔及目錄已刪除。',
    'ui__client/domain/hosting/file-manager/remove_self__done' => '所選檔和目錄已移除。',
    'ui__client/domain/hosting/file-manager/view__done' => '成功完成操作。',
    'ui__client/domain/hosting/file-manager__done' => '成功完成操作。',
    'ui__client/domain/hosting/file-manager_self__done' => '成功完成操作。',
    'ui__client/domain/hosting/hotlink-protection__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/hotlink-protection_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/logs/rotation__done' => '日誌迴圈設定已更改。',
    'ui__client/domain/hosting/logs/rotation_self__done' => '日誌迴圈設定已更改。',
    'ui__client/domain/hosting/logs__done' => '成功完成操作。',
    'ui__client/domain/hosting/logs_self__done' => '成功完成操作。',
    'ui__client/domain/hosting/performance__done' => '已調整網站%1的主機性能設定。',
    'ui__client/domain/hosting/performance_self__done' => '已調整網站的主機性能設定。',
    'ui__client/domain/hosting/performance_unknown__done' => '已調整虛擬主機性能設定。',
    'ui__client/domain/hosting/php__done' => 'PHP設定已更改。', // PFW
    'ui__client/domain/hosting/php_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/protected-directories__done' => '成功完成操作。',
    'ui__client/domain/hosting/protected-directories_self__done' => '成功完成操作。',
    'ui__client/domain/hosting/setup__done' => '%1主機已配置。',
    'ui__client/domain/hosting/ssh-terminal__done' => '成功完成操作。', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => '成功完成操作。', // PFU
    'ui__client/domain/hosting/tsclient__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/tsclient_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/virtual-directories__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/virtual-directories_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET版本已更改。', // PFW
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => '%1的ASP.NET設定已更改。', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => '已在網站%1上創建虛擬目錄。', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => '已創建虛擬目錄。', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => '所選目錄已移除。', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => '所選目錄已移除。', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => '自訂錯誤文檔已更新。', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => '所選MIME類型已移除', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => '新的MIME類型已註冊。', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => '目錄存取權限已更新。', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => '目錄存取權限已更新。', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP設定%1已更新。', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => '%1 PHP設定已更新。', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => '目錄屬性已更新。', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => '目錄屬性已更新。', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => '目錄保護設定已更新。', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => '目錄保護設定已更新。', // PFW
    'ui__client/domain/hosting/web-directories__done' => '成功完成操作。', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "成功完成操作。", // PFW
    'ui__client/domain/mpc-certificates__done' => '線上商店中可用的 SSL/TLS 證書',
    'ui__client/domain/mpc-certificates_self__done' => '線上商店中可用的 SSL/TLS 證書',
    'ui__client/domain/odbc__done' => '成功完成操作。', // PFW
    'ui__client/domain/odbc_self__done' => '成功完成操作。', // PFW
    'ui__client/domain/properties__done' => "域名管理員帳戶已更改。",
    'ui__client/domain/properties_new__done' => "已創建域名 %1。",
    'ui__client/domain/properties_self__done' => "域名屬性已更改。",
    'ui__client/domain/register__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/domain/register_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/domain/rename__done' => '已更改域名。',
    'ui__client/domain/rename_self__done' => "成功更改域名。",
    'ui__client/domain/report/anon-ftp-stats__done' => '成功完成操作。',
    'ui__client/domain/report/ftp-stats__done' => '成功完成操作。',
    'ui__client/domain/report/ftp-stats_self__done' => '成功完成操作。',
    'ui__client/domain/report/traffic-history__done' => '成功完成操作。',
    'ui__client/domain/report/traffic-history_self__done' => '成功完成操作。',
    'ui__client/domain/report/webalizer-preferences__done' => '成功完成操作。', // PFU
    'ui__client/domain/report/webalizer-preferences_self__done' => '成功完成操作。', // PFU
    'ui__client/domain/report/web-stats__done' => '網站統計頁已打開。',
    'ui__client/domain/report/web-stats_self__done' => '網站統計頁已打開。',
    'ui__client/domain/report/web-stats-ssl__done' => '網站統計頁已打開。',
    'ui__client/domain/report/web-stats-ssl_self__done' => '網站統計頁已打開。',
    'ui__client/domain/report__done' => '成功完成操作。',
    'ui__client/domain/report_self__done' => '成功完成操作。',
    'ui__client/domain/settings_self__done' => '成功完成操作。',
    'ui__client/domain/to-client__done' => '域名管理員帳戶%1已轉換為客戶帳戶。',
    'ui__client/domain/to-client_multi__done' => '域名管理員帳戶已轉換為客戶帳戶。',
    'ui__client/domain/toggle_disable__done' => "域名%1已掛起。",
    'ui__client/domain/toggle_enable__done' => "域名%1已啟動。",
    'ui__client/domain/traffic__done' => '成功完成操作。',
    'ui__client/domain/traffic_self__done' => '成功完成操作。',
    'ui__client/domain/traffic_unknown__done' => '成功完成操作。',
    'ui__client/domain/web-stats__done' => '成功完成操作。',
    'ui__client/domain-summary-report__done' => '成功完成操作。',
    'ui__client/domain-summary-report_self__done' => '成功完成操作。',
    'ui__client/domain-summary-report_unknown__done' => '成功完成操作。',
    'ui__client/extras-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/ipaddress/delete_multi__done' => '成功完成操作。',
    'ui__client/ipaddress/properties__done' => '成功完成操作。',
    'ui__client/ipaddress/properties_new__done' => '成功完成操作。',
    'ui__client/ip-pool/properties__done' => "客戶%1的IP池已更新。",
    'ui__client/ip-pool/properties_self__done' => '成功完成操作。',
    'ui__client/limits__done' => "客戶%1的資源配置已更改。",
    'ui__client/limits_self__done' => '成功完成操作。',
    'ui__client/logo__done' => '客戶%1的徽標設定已應用。',
    'ui__client/logo_reseller__done' => '已應用新的 Panel 品牌自訂設定。',
    'ui__client/logo_self__done' => '徽標設定已應用。',
    'ui__client/logo_self-reseller__done' => '您的控制台徽標設定已應用。',
    'ui__client/manage-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/permissions__done' => "客戶%1的許可權已更改。",
    'ui__client/permissions_self__done' => '成功完成操作。',
    'ui__client/preferences__done' => "已更改客戶 %1 的偏好設定。",
    'ui__client/preferences_self__done' => "已更改您的偏好設定。",
    'ui__client/register-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/register-domain_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__client/report/traffic-history__done' => '成功完成操作。',
    'ui__client/report/traffic-history_self__done' => '成功完成操作。',
    'ui__client/report__done' => '成功完成操作。',
    'ui__client/report_self__done' => '成功完成操作。',
    'ui__client/sessions/delete__done' => '成功完成操作。',
    'ui__client/sessions/delete_self__done' => '成功完成操作。',
    'ui__client/sessions__done' => '成功完成操作。',
    'ui__client/sessions_self__done' => '成功完成操作。',
    'ui__client/skeleton__done' => '成功完成操作。',
    'ui__client/skeleton_self__done' => '成功完成操作。',
    'ui__client/to-reseller__done' => '客戶帳戶%1已轉換為代理商帳戶。',
    'ui__client/to-reseller_multi__done' => "已將所選客戶帳戶轉換為代理商帳戶。",
    'ui__client/traffic__done' => "成功完成操作。",
    'ui__client/traffic_unknown__done' => '成功完成操作。',
    'ui__cp-access__done' => '成功完成操作。',
    'ui__cp-session/properties__done' => '成功完成操作。',
    'ui__cp-session__done' => '成功完成操作。',
    'ui__ftp-sessions__done' => '成功完成操作。',
    'ui__license__done' => '成功完成操作。',
    'ui__logo__done' => "Plesk 品牌自訂屬性已更改。",
    'ui__longtasks/longtask/properties__done' => "成功更改幕後工作設定。",
    'ui__mass-email/delete__done' => "郵件範本%1已刪除。", // PFW
    'ui__mass-email/delete_multi__done' => "郵件範本已刪除。",  // PFW
    'ui__mass-email/send_main__done' => "已成功完成操作。",  // PFW
    'ui__mass-email/send_selectclients__done' => "已成功選擇群發電子郵件範本的客戶收件人。",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "成功選擇域名管理員帳戶。",  // PFW
    'ui__mass-email/send_selectresellers__done' => '成功選擇代理商帳戶。',  // PFW
    'ui__mass-email/template/properties_main__done' => '對群發郵件範本所做變更已保存。', // PFW
    'ui__mass-email/template/properties_new-main__done' => '已創建群發郵件範本。', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => '已成功選擇群發電子郵件範本的客戶收件人。',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => '群發郵件範本的域名管理員帳戶已選擇。', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => '群發郵件範本的代理商帳戶已選擇。',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "群發電子郵件範本已更改。",  // PFW
    'ui__mass-email/template/properties__invalid_values' => '指定的值無效。', // PFW
    'ui__mass-email__done' => "成功完成操作。", // PFW
    'ui__mass-mail__done' => "成功完成操作", // PFU
    'ui__mass-mail/delete__done' => '郵件範本%1已刪除。', // PFU
    'ui__mass-mail/delete_multi__done' => '郵件範本已刪除。', // PFU
    'ui__mass-mail/properties__done' => '範本%1已更改。', // PFU
    'ui__mass-mail/properties_new__done' => '已創建範本 %1。', // PFU
    'ui__mass-mail/send__done' => '郵件已發送。', // PFU
    'ui__mass-mail/send_new__done' => '郵件已發送。', // PFU
    'ui__mass-mail/send_unknown__done' => '郵件已發送。',  // PFU
    'ui__mass-mail/send_unknown-new__done' => '郵件已發送。', // PFU
    'ui__mass-mail/template/properties_new__done' => '已創建新郵件範本', // PFU
    'ui__mass-mail/template/properties__done' => '郵件範本已更新。', // PFU
    'ui__modules/watchdog/disk/properties__done' => '磁片監控新設定已應用。', // PFU
    'ui__modules__done' => '成功完成操作。',
    'ui__modules__short-title' => '擴展',
    'ui__modules__title' => '擴展',
    'ui__reseller/client/chowner_multi__done' => '所選客戶帳戶已遷移給另一所有者。',
    'ui__reseller/client/chowner_multi-select__done' => '成功完成操作。',
    'ui__reseller/client/traffic_unknown__done' => '成功完成操作。',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__reseller/ftp-sessions_self__done' => '成功完成操作。',
    'ui__reseller/limits__done' => "代理商資源限制和資源使用策略已更改。",
    'ui__reseller/limits_readonly-self__done' => '成功完成操作。',
    'ui__reseller/limits_self__done' => '您的資源限制和資源使用策略已更改。',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__reseller/permissions__done' => '已更改代理商%1的許可權。',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => '成功完成操作。',
    'ui__reseller/register-domain__done' => 'MyPlesk.com頁面已打開。',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com頁面已打開。',
    'ui__reseller/report/layout/auto/delete_multi__done' => '所選報告發送計畫已刪除。',
    'ui__reseller/report/layout/auto/properties__done' => '報告發送計畫已更新。',
    'ui__reseller/report/layout/auto/properties_new__done' => '報告發送計畫已添加。',
    'ui__reseller/report/layout/properties__done' => '報告佈局已更改。',
    'ui__reseller/report/layout/properties_new__done' => '已創建新報告佈局。',
    'ui__reseller/report/traffic-history__done' => '成功完成操作。',
    'ui__reseller/report/traffic-history_self__done' => '成功完成操作。',
    'ui__reseller/report__done' => '成功完成操作。',
    'ui__reseller/report_self__done' => '成功完成操作。',
    'ui__reseller/sessions/delete__done' => '成功完成操作',
    'ui__reseller/sessions/delete_self__done' => '成功完成操作',
    'ui__reseller/sessions__done' => '成功完成操作。',
    'ui__reseller/sessions_self__done' => '成功完成操作。',
    'ui__reseller/to-client__done' => '代理商帳戶%1已轉換為客戶帳戶。',
    'ui__reseller/to-client_multi__done' => "已將所選代理商帳戶轉換為客戶帳戶。",
    'ui__reseller/traffic__done' => '成功完成操作。',
    'ui__reseller/traffic_self__done' => '成功完成操作。',
    'ui__reseller/traffic_unknown__done' => '成功完成操作。',
    'ui__reseller/logo_self__title' => 'Plesk 品牌自訂',
    'ui__reseller/logo_self__done' => '您的 Plesk 徽標設定已經應用。',
    'ui__server/aspdotnet__done' => '伺服器級ASP.NET設定已更改。', // PFW
    'ui__server/certificate/default_multi__done' => '已設定所選 SSL/TLS 證書用於保護新託管網站的連接安全。',
    'ui__server/certificate/delete_multi__done' => '已移除選定的 SSL/TLS 證書。',
    'ui__server/certificate/download__done' => '已下載 SSL/TLS 證書。',
    'ui__server/certificate/properties__done' => '已更新 SSL/TLS 證書屬性。',
    'ui__server/certificate/properties_new__done' => '已創建 SSL/TLS 證書 %1。',
    'ui__server/certificate/setup_multi__done' => '已設定所選 SSL/TLS 證書用於保護 Plesk 的連接安全。',
    'ui__server/certificate__done' => '成功完成操作。',
    'ui__server/components__done' => '成功完成操作。',
    'ui__server/cp-certificate-download__done' => "已下載 Plesk 的 SSL/TLS 證書。",
    'ui__server/crontab/properties__done' => '%1的計畫的任務已更改。',
    'ui__server/crontab/task/delete__done' => '任務已刪除。',
    'ui__server/crontab/task/delete_multi__done' => '任務已刪除。',
    'ui__server/crontab/task/properties__done' => '計畫的任務已更新。',
    'ui__server/crontab/task/properties_new__done' => '已計畫新任務。',
    'ui__server/crontab/task/toggle_disable__done' => '計畫任務%1已禁用。',
    'ui__server/crontab/task/toggle_enable__done' => '計畫任務%1已啟用。',
    'ui__server/crontab__done' => '成功完成操作。',
    'ui__server/db__done' => '成功完成操作。',
    'ui__server/dns__done' => '成功完成操作。',
    'ui__server/ftp-settings__done' => "成功更改FTP設定。",
    'ui__server/ip-address/client/delete__done' => "已從用戶的IP池中刪除此IP地址。",
    'ui__server/ip-address/client/delete_multi__done' => "已從客戶池移除IP位址。",
    'ui__server/ip-address/client/properties_new__done' => 'IP地址已分配給用戶。',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP位址%1已分配給所選客戶。',
    'ui__server/ip-addresses__done' => "成功完成操作。",
    'ui__server/mail/statistics/spam/recipients__done' => "成功完成操作。",
    'ui__server/mail/statistics/spam/summary__done' => "成功完成操作。",
    'ui__server/mail/statistics/spam__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus/recipients__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus/summary__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus/viruses__done' => "成功完成操作。",
    'ui__server/mail/statistics/virus__done' => "成功完成操作。",
    'ui__server/mail/statistics__done' => "成功完成操作。",
    'ui__server/mail__done' => '郵件伺服器設定已更改。',
    'ui__server/maillists__done' => '成功完成操作。',
    'ui__server/mpc-certificates__done' => '已打開列有可用 SSL/TLS 證書的線上商店頁面。',
    'ui__server/odbc__done' => '伺服器級ODBC設定已更改。', // PFW
    'ui__server/pmm__done' => '成功完成操作。',
    'ui__server/preferences__done' => "伺服器設定已更改。",
    'ui__server/register__done' => 'MyPlesk.com頁面已打開。',
    'ui__server/resources__done' => '成功完成操作。',
    'ui__server/services__done' => '成功完成操作。',
    'ui__server/sitebuilder__done' => '成功完成操作。',
    'ui__server/skeleton__done' => '成功完成操作。',
    'ui__server/spam-filter/black-list/address/delete__done' => '地址%1已從伺服器級黑名單中刪除。',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => '地址已從伺服器級黑名單中刪除。',
    'ui__server/spam-filter/black-list/address/properties_new__done' => '地址已被添加至黑名單。',
    'ui__server/spam-filter/black-list/address__done' => '地址已添加至黑名單。',
    'ui__server/spam-filter/black-list__done' => '成功完成操作。', // PFU
    'ui__server/spam-filter/properties__done' => '垃圾郵件篩檢程式配置已更改。',
    'ui__server/spam-filter/toggle_disable__done' => '已在系統範圍禁用垃圾郵件過濾。',
    'ui__server/spam-filter/toggle_enable__done' => '已在系統範圍啟用了垃圾郵件過濾。',
    'ui__server/spam-filter/white-list/address/delete__done' => '地址%1已從伺服器級的白名單中刪除。',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => '地址已從伺服器級白名單刪除。',
    'ui__server/spam-filter/white-list/address/properties_new__done' => '地址已添加至白名單。',
    'ui__server/spam-filter/white-list/address__done' => '地址已添加至白名單。',
    'ui__server/spam-filter/white-list__done' => '成功完成操作。', // PFU
    'ui__server/spam-filter__done' => '成功完成操作。',
    'ui__server/statistics__done' => '成功完成操作。',
    'ui__server/time__done' => "系統日期和時間已更改。",
    'ui__server/tsclient__done' => '遠端桌面會話已開始。', // PFW
    'ui__server__done' => "成功完成操作。",
    'ui__sessions/properties__done' => '成功完成操作。',
    'ui__sessions__done' => '成功完成操作。',
    'ui__sessions/delete__done' => '所選會話已刪除。',
    'ui__start-page__done' => '成功完成操作。',
    'ui__support__done' => '支援請求表單已在單獨的瀏覽器視窗中打開。',
    'ui__ts-sessions__done' => '成功完成操作。',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => '無可上傳的文件。',
    'login_up__access_denied_no_permission' => "拒絕存取。許可權不足，無法登入。",
    'mail__unable_remove_pattern' => "無法從伺服器黑名單中移除地址: %1", // PFW
    'mail__incorrect_network_format' => '網路格式錯誤: %1', // PFW
    'dbbackup__new_remote_backup_available' => '此 MS SQL 資料庫伺服器現正在遠端主機上操作。若要能夠使用本地資料庫轉儲導入和匯出資料庫，您需要為該資料庫伺服器指定正確的備份設定。', // PFW
    'dbbackup__local_to_remote_backup_available' => '此MS SQL資料庫伺服器現正在遠端主機上操作。請在%1頁指定此資料庫伺服器的備份設定。', // PFW
    'initconf__unable_change_passwd' => "無法更改管理員的密碼：%1",
    'initconf__unable_get_passwd' => '無法獲取當前的管理員密碼：%1 失敗：%2',
    'initconf__invalid_hostname' => '主機名稱 "%1" 中的錯誤',
    'initconf__unable_reconfig' => '無法配置 Plesk：reconfig 失敗：%1',
    'initconf__unable_update_admin' => '無法更新管理員聯繫資訊：%1',
    '__refresh' => '刷新',
    '__dalias_not_exist' => '域名別名不存在。',
    '__bug146523_explanation' => '之前版本的 Plesk 允許 FTP 用戶名可以使用最多 16 個字元。該版本的 Plesk 允許 FTP 用戶名可以使用最多 15 個字元。若要解決此問題，請將受影響的 FTP 用戶名長度減少到 15 個字元，同時更改至少一個字元來避免用戶名衝突。由此變動帶來的任何不便，我們深表歉意。',
    'domain__cannot_change_webmail' => '無法更改域名上的 web 郵箱：%1',
    'sb_publish_disable_warning' => '如果您關閉使用 Presence Builder 創建的網站，將會移除之前在 Presence Builder 中創建的網站而所有的網站資料都會丟失。 如果您想繼續請點按 確定。',
    '__sbnet_client_use_sbnet' => "在 Presence Builder 中創建相應的用戶帳戶",
    'mail_resp_activate' => '啟動自動回復',
    'limitsManger__limit_available_error' => '無法分配要求的資源("%%limitName%%"): 您的帳戶僅可以使用%%available%%。',
    'limitsManger__limit_reserved_error' => '無法分配比已用資源更少的資源("%%limitName%%")。',
    'domain__unable_to_rename_vhost_dir_already_exists' => '無法重命名域名：帶有指定名稱的虛擬目錄已存在。',
    'domain_unable_to_rename' => '無法重命名域名。',

    // Greylisting
    'spamfilter__general_settings_legend' => '常規',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin垃圾郵件過濾',
    'spamfilter__spamassassin_settings_legend' => 'SpamAssassin設定',
    'spamfilter__spamassassin_server_status_legend' =>  "啟用伺服器級SpamAssassin垃圾郵件過濾",
    'spamfilter__spamassassin_user_status_legend' => '啟用SpamAssassin垃圾郵件過濾',
    'spamfilter__greylisting_status_legend' => '啟用伺服器級灰名單垃圾郵件過濾功能',
    'spamfilter__personal_settings_not_allowed' => '系統原則不允許使用個人垃圾郵件過濾設定。',
    'spamfilter__required_score' => '郵件被標識為垃圾郵件需獲得的分值',
    'spamfilter__rewrite_header_subject' => '將下列文本添加至被視為垃圾郵件的每封郵件的主題開頭',
    'spamfilter__use_mailuser_prefs' => '將單個設定應用到垃圾郵件過濾中',
    'spamfilter_addresses__text_hint' => '使用空格、Tab 鍵、逗號、分號或另起一行分隔多個位址。“@”符號左邊不得含有非 ASCII 字元。位址可以包含“*”和“?”萬用字元 (如：*@domain.com、user?@*.com)。域名的非 ASCII 部分不得包含萬用字元。',
    'spamfilter__spamassassin__antivirus_settings_legend' => '使用伺服器級設定',
    'spamfilter__antivirus_use_mailuser_prefs' => '允許個人設定',
    'spamfilter__score_error' => '分值不得為負數，小數點之前的部分必須小於 100，小數點後不能超過兩位數。',
    'spamfilter__rewrite_header_error' => '資訊主題可包含除數位識別碼 (#) 以外的任何可列印的字元。',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => '退信',
    'nonexistent_mail__mode_discard' => '丟棄',
    'nonexistent_mail__mode_catch_addr' => '轉發到電郵地址',
    'nonexistent_mail__mode_catch_ip' => '轉發到IP',
    'nonexistent_mail__bounce_not_supported' => '不支援退信模式',
    'nonexistent_mail__discard_not_supported' => '不支援丟棄模式',
    'nonexistent_mail__catch_not_supported' => '不支援轉發到郵寄位址',
    'nonexistent_mail__redirect_not_supported' => '轉發到IP功能',
    'nonexistent_mail__ip_used_on_this_host' => 'IP位址解析到 localhost',
    'nonexistent_mail_address_should_be_local_domain' => '因為傳出郵件控制功能已被打開，所以不存在收件人的電郵地址 %1 應屬於選定的域名。如若不是，將會應用 "拒絕" 策略而不是轉發。',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => '因為傳出郵件控制功能已被打開，為郵件轉發指定的電郵地址 (%1) 應該屬於選定的域名。如若不是，發送到這些地址的郵件將不計入傳出郵件控制範疇。',
    // mail acc extras
    '__antivirus' => "防病毒程式",

    // additional keys
    'additional_keys__select_to_install' => '尚未選擇許可證。請選擇要安裝的許可證。',
    'additional_key_update__title' => "更新其他許可證",
    'additional_key_update__legend' => "其他許可證更新狀態",
    'additional_key_update__new_key' => "其他許可證屬性",
    'bt_additional_key_install' => "安裝許可證",
    'b_additional_key_install' => '按一下安裝當前許可證。',
    'bt_additional_key_update' => "檢索其它的金鑰",
    'bt_additional_key_revert' => "恢復許可證",
    'b_additional_key_upload' => '按一下上傳新的許可證。',
    'b_additional_key_download' => '按一下下載當前許可證。',
    'b_additional_key_remove' => '按一下刪除當前許可證。',
    'b_additionalkeyslist_install' => '安裝所選許可證。',

    // web apps

    // none available
    'ui__admin-alias__none-available' => '無可用的其他管理員帳戶。', // PFW
    'ui__client/domain/certificate__none-available' => '客戶沒有 SSL/TLS 證書。',
    'ui__client/domain/certificate__none-available__1' => '客戶沒有帶有 SSL/TLS 證書的域名。',
    'ui__client/domain/certificate__none-available__2' => '域名沒有 SSL/TLS 證書。',
    'ui__reseller/client__none-available' => '無代理商及客戶。',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => '請選擇要從IP池中移除的IP位址。',
    'ui__reseller/client/chowner__empty_selection' => '請選擇要分配給新所用者的客戶帳戶。',
    'ui__server/ip-address/client/delete__empty_selection' => '請選擇要從其IP池中移除IP位元元址的代理商帳戶。',
    'ui__server/crontab/task/delete__empty_selection' => '您需要選擇要取消的任務。',

    // scripting languages errors
    'phosting__php_not_enabled' => '此網站上的PHP支援已停用。',
    'phosting__aspdotnet_not_enabled' => '此網站上的ASP.NET支援已停用。',
    'phosting__php_forced_by_site_isolation' => '無法修改 PHP 設定：無許可權覆蓋伺服器級安全性原則。',
    'phosting__option_forced_by_site_isolation' => '無法修改 %1 設定：無許可權覆蓋伺服器級安全性原則。',
    'phosting__mod_bw_disabled_by_vps_optimized' => '因為 Plesk 在 VPS 優化模式下運行，mod_bw已被禁用。',
    'phosting__mod_php_disabled_by_vps_optimized' => '因為 Plesk 在 VPS 優化模式下運行，mod_php 已被禁用。',
    'phosting__perl_disabled_by_vps_optimized' => '因為 Plesk 在 VPS 優化模式下運行，Perl 已被禁用。',
    'phosting__asp_disabled_by_vps_optimized' => '因為 Plesk 在 VPS 優化模式下運行，ASP已被禁用。',
    'phosting__python_disabled_by_vps_optimized' => '因為 Plesk 在 VPS 優化模式下運行，Python 已被禁用。',
    'phosting__fastcgi_disabled_by_vps_optimized' => '因為 Plesk 在 VPS 優化模式下運行，fastcgi 已被禁用。',
    'phosting__php_handler_id_not_registered' => '在網站隔離設定中不允許設定 PHP 處理器。將會使用默認的 PHP 處理器。',
    'phosting__php_served_by_nginx_is_not_available' => '不允許在網站隔離設定中設定 PHP 處理常式（由 nginx 服務的 FPM 應用程式）。將會使用默認的 PHP 處理器。',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => '查看IP地址清單',
    'ui__client/ipaddress/properties_readonly__title' => '查看IP地址清單',
    'ui__client/ipaddress/properties_readonly__description' => '查看此用戶可用的IP地址清單。',
    'ui__server/certificate__short-title' => 'SSL/TLS 證書',
    'ui__server/certificate__title' => 'SSL/TLS 證書',
    'ui__server/certificate__description' => '查看和管理 SSL/TLS 證書。',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => '移除MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => '移除MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => '移除所選MIME類型。',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => '添加MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => '添加MIME類型',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => '註冊 MIME 類型。',

    'ui__client/ipaddress/delete_multi__wizard-title' => '移除IP地址',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => '選擇要從客戶%1IP池中移除的IP地址',

    // mail

    // for future use
    'ui__client/domain/hosting/file-manager/create-file__short-title' => '創建文件',
    'ui__client/domain/hosting/file-manager/create-file__title' => '創建文件',
    'ui__client/domain/hosting/file-manager/create-file__description' => '創建文件。',
    'ui__client/domain/hosting/file-manager/create-dir__short-title' => '創建資料夾',
    'ui__client/domain/hosting/file-manager/create-dir__title' => '創建資料夾',
    'ui__client/domain/hosting/file-manager/create-dir__description' => '創建資料夾。',
    'ui__client/domain/hosting/file-manager/edit__short-title' => '編輯檔或資料夾',
    'ui__client/domain/hosting/file-manager/edit__title' => '編輯檔或資料夾',
    'ui__client/domain/hosting/file-manager/edit__description' => '編輯所選檔或資料夾。',
    'ui__client/domain/hosting/file-manager/rename__short-title' => '重命名檔或資料夾',
    'ui__client/domain/hosting/file-manager/rename__title' => '重命名檔或資料夾',
    'ui__client/domain/hosting/file-manager/rename__description' => '重命名所選檔或資料夾。',
    'ui__client/domain/hosting/file-manager/permissions__short-title' => '更改許可權',
    'ui__client/domain/hosting/file-manager/permissions__title' => '更改許可權',
    'ui__client/domain/hosting/file-manager/permissions__description' => '更改文件或資料夾的存取權限。',
    'ui__client/domain/hosting/file-manager/remove__short-title' => '移除文件或資料夾',
    'ui__client/domain/hosting/file-manager/remove__title' => '移除文件或資料夾',
    'ui__client/domain/hosting/file-manager/remove__description' => '移除此文件或資料夾。',
    'ui__client/domain/hosting/file-manager/remove_self__short-title' => '移除文件或資料夾',
    'ui__client/domain/hosting/file-manager/remove_self__title' => '移除文件或資料夾',
    'ui__client/domain/hosting/file-manager/remove_self__description' => '移除此文件或資料夾。',
    'ui__client/domain/hosting/file-manager/copy-move__short-title' => '複製或移動檔/目錄',
    'ui__client/domain/hosting/file-manager/copy-move__title' => '複製或移動檔/目錄',
    'ui__client/domain/hosting/file-manager/copy-move__description' => '複製或移動所選檔/目錄',
    'ui__client/domain/hosting/file-manager/view__short-title' => '查看文件',
    'ui__client/domain/hosting/file-manager/view__title' => '查看文件',
    'ui__client/domain/hosting/file-manager/view__description' => '查看所選文件。',

    'ui__client/ipaddress__short-title' => 'IP地址',
    'ui__client/ipaddress__title' => 'IP地址',
    'ui__client/ipaddress__description' => '查看IP位址相關資訊。',
    'ui__server/ip-address__short-title' => 'IP地址',
    'ui__server/ip-address__title' => 'IP地址',
    'ui__server/ip-address__description' => '查看IP位址相關資訊。',
    'ui__client/domain/hosting/setup__short-title' => '虛擬主機設定',
    'ui__client/domain/hosting/setup__title' => '虛擬主機設定',
    'ui__client/domain/hosting/setup__description' => '設定網站%1的虛擬主機設定。',
    'ui__reseller/client/chowner_multi__description' => '選擇所選客戶帳戶的新所有者。',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME類型', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME類型屬性', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => '查看MIME類型屬性。', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => '錯誤檔', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => '錯誤檔', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => '錯誤檔案屬性。', // PFW

    // tooltips

    'b_resellerreportslist_remove' => '移除所選報告佈局。',
    'b_resellerreportslist_search' => '輸入搜尋模式，並按一下查找報告佈局。',
    'b_resellerreportslist_show_all' => '顯示所有可用的報告佈局。',

    'l_resellerreportslist_auto' => '按是否自動提交對報告佈局進行排序。',
    'l_resellerreportslist_clients' => '按客戶資訊對報告佈局進行排序。',
    'l_resellerreportslist_domains' => '按域名資訊對報告佈局進行排序。',
    'l_resellerreportslist_general' => '按常規資訊對報告佈局進行排序。',
    'l_resellerreportslist_name' => '按報告名稱對報告佈局進行排序。',
    'l_resellerreportslist_personal_domains' => '按個人域名資訊對報告佈局進行排序。',

    'b_adminreportslist_remove' => '移除所選報告佈局。',
    'b_adminreportslist_search' => '輸入搜尋模式，並按一下查找報告佈局。',
    'b_adminreportslist_show_all' => '顯示所有可用的報告佈局。',

    'l_adminreportslist_auto' => '按是否自動提交對報告佈局進行排序。',
    'l_adminreportslist_clients' => '按客戶資訊對報告佈局進行排序。',
    'l_adminreportslist_domains' => '按域名資訊對報告佈局進行排序。',
    'l_adminreportslist_general' => '按常規資訊對報告佈局進行排序。',
    'l_adminreportslist_name' => '按報告名稱對報告佈局進行排序。',
    'l_adminreportslist_personal_clients' => '按個人客戶資訊對報告佈局進行排序。',
    'l_adminreportslist_personal_domains' => '按個人域名資訊對報告佈局進行排序。',
    'l_adminreportslist_resellers' => '按代理商資訊對報告佈局進行排序。',

    'b_clientsonlylist_remove' => '移除所選客戶帳戶。',
    'b_clientsonlylist_search' => '輸入搜尋模式，並按一下查找客戶帳戶。',
    'b_clientsonlylist_show_all' => '顯示所有客戶帳戶。',
    'l_clientsonlylist_cname' => '按公司名稱對客戶帳戶進行排序。',
    'l_clientsonlylist_date' => '按創建日期對客戶帳戶進行排序。',
    'l_clientsonlylist_domains' => '按域名數量對客戶帳戶進行排序。',
    'l_clientsonlylist_name' => '按客戶名稱對客戶帳戶進行排序。',
    'l_clientsonlylist_owner' => '按所有者對客戶帳戶進行排序。',
    'l_clientsonlylist_type' => '按類型對客戶帳戶進行排序。',

    'b_get_password_cancel' => '不發送郵件，並返回上一螢幕。',
    'b_get_password_send' => '按一下“確定”發送密碼恢復郵件到已在系統中註冊的電郵地址',



    'b_personaltrafficlist_search' => '輸入搜尋模式，並按一下查找域名。',
    'b_personaltrafficlist_show_all' => '顯示所有域名。',

    'b_back' => '返回上一頁。',
    'b_next' => '轉到下一頁。',

    'b_dnsnstemplatelist_remove' => '刪除所選的域名伺服器。',
    'b_dnsnstemplatelist_search' => '輸入搜尋模式，然後按一下查找域名伺服器。',
    'b_dnsnstemplatelist_show_all' => '顯示所有域名伺服器。',

    'l_dnsnstemplatelist_ns' => '按域名伺服器對DNS範本記錄進行排序。',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => '生成到檔與資料夾的安全連結',
    'cu__serverfilesharing_fsPublicFolderEnabled' => '啟用共用檔',
    'cu__serverfilesharing_fsPublicFolder' => '用於存儲共用檔的資料夾',
    'cu__serverfilesharing_fsPublicUrl' => '訪客用於存取共用檔的 URL',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => '共用檔啟用密碼保護',
    'cu__serverfilesharing_fsPartnerFolder' => '用於存儲加密保護檔的資料夾',
    'cu__serverfilesharing_fsPartnersLogin' => '用於存取檔的用戶名',
    'cu__serverfilesharing_fsPartnersPassword' => '存取檔的密碼',
    'cu__serverfilesharing_fsDomain' => '網站資料夾根 URL。域名',
    'cu__serverfilesharing_fsPrefix' => '網站資料夾跟 URL。首碼',
    'cu__serverfilesharing_commandUpdate' => '更新檔共用設定',
    'cu__serverfilesharing_commandInfo' => '顯示現存檔共用設定',
    'server_preferences_include_admin_dumps_into_client_usage' => '管理員創建備份檔案',
    'server_preferences__forbid_subscription_rename' => '禁止客戶和代理商更改其主域名',
    'subscription_rename_is_forbidden' => '伺服器級的策略禁止重命名訂閱。',
    'server_preferences__allow_sys_user_rename' => '客戶可更改其系統使用者的名稱',
    'server_preferences__allow_sys_user_rename_false' => '總是',
    'server_preferences__allow_sys_user_rename_true' => '只有在已授予主機管理許可權的情況下',
    'server_preferences__allow_sys_user_rename_forced' => '從不',
    'server_preferences__preferred_domain' => '網站的偏好域名',
    'server_preferences__preferred_domain_none' => '無',
    'server_preferences__preferred_domain_to_landing' => 'domain.tld',
    'server_preferences__preferred_domain_to_www' => 'www.domain.tld',
    'server_preferences__anonymize_ips' => '隐藏IP地址',
    'server_preferences__anonymize_ips_text' => '在日志轮转和收集web统计数据时隐藏IP地址',
    'server_preferences__anonymize_ips_description' => '归档前，postrotate脚本会用"0"替换掉IPv4 地址的最后八位字节。在 IPv6 地址中，脚本会用"0000" （完整的形式）或"0"（简短的形式） 替换掉该地址的后半部分',
    'server_preferences__logrotate' => '日志轮转',
    'server_preferences__logrotate_force' => '强制为所有域名执行每日日志轮转',
    'server_preferences__logrotate_period' => '允许存储网站日志文件',
    'server_preferences__logrotate_period_days' => '天',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => '管理伺服器上的計畫的任務',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => '選擇要管理其計畫的任務的系統使用者。',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => '計畫任務%1',
    'ui__server/crontab/task__description' => '查看計畫任務%1的屬性。',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => '系統使用者',
    'ui__server/crontab_unknown__title' => '系統使用者',
    'ui__server/crontab_unknown__description' => '可為計畫的任務所有者的系統使用者。',


    'ui__server/crontab__none-available' => '您尚無系統使用者帳戶。',
    'ui__server/crontab_readonly-unknown__description' => '查看計畫的任務。',
    'ui__server/crontab_readonly-unknown__short-title' => '計畫的任務',
    'ui__server/crontab_readonly-unknown__title' => '查看計畫的任務',
    'ui__server/crontab_readonly-unknown__wizard-title' => '查看計畫的任務。',
    'ui__server/crontab_readonly__description' => '查看計畫的任務 %1。',
    'ui__server/crontab_readonly__short-title' => '計畫任務%1',
    'ui__server/crontab_readonly__title' => '查看計畫的任務 %1',
    'ui__server/crontab_unknown__wizard-title' => '管理計畫的任務。',

    'ui__server/crontab/properties__description' => '編輯%1的計畫的任務。',

    'ui__server/crontab/properties__short-title' => '設定',
    'ui__server/crontab/properties__title' => '編輯%1的計畫的任務',
    'ui__server/crontab/properties_readonly-unknown__description' => '查看計畫的任務。',
    'ui__server/crontab/properties_readonly-unknown__short-title' => '設定',
    'ui__server/crontab/properties_readonly-unknown__title' => '查看計畫的任務',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => '查看計畫的任務。',
    'ui__server/crontab/properties_readonly__description' => '查看%1的計畫的任務。',
    'ui__server/crontab/properties_readonly__short-title' => '設定',
    'ui__server/crontab/properties_readonly__title' => '查看%1的計畫的任務',
    'ui__server/crontab/properties_unknown__description' => '編輯計畫的任務。',
    'ui__server/crontab/properties_unknown__short-title' => '屬性',
    'ui__server/crontab/properties_unknown__title' => '編輯計畫的任務',
    'ui__server/crontab/properties_unknown__wizard-title' => '編輯計畫的任務。',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => '選擇您要查看其任務的系統使用者。',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => '選擇您要更改其任務的系統使用者。',
    'ui__server/crontab/properties_unknown__wizard__3' => '按一下“完成”應用更改並退出嚮導。',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => '按一下“完成”並退出嚮導。',

    'ui__server/crontab/task__none-available' => '您尚無計畫的任務。',
    'ui__server/crontab/task__none-available__2' => '系統使用者%1尚無任何計畫的任務。',
    'ui__server/crontab/task_readonly-unknown__description' => '計畫的任務。',
    'ui__server/crontab/task_readonly-unknown__short-title' => '任務',
    'ui__server/crontab/task_readonly-unknown__title' => '計畫的任務',

    'ui__server/crontab/task/delete__description' => '刪除計畫任務%1',

    'ui__server/crontab/task/delete__short-title' => '刪除',
    'ui__server/crontab/task/delete__title' => '刪除計畫任務%1',
    'ui__server/crontab/task/delete_multi__description' => '刪除計畫的任務。',

    'ui__server/crontab/task/delete_multi__short-title' => '刪除',
    'ui__server/crontab/task/delete_multi__title' => '刪除計畫的任務',
    'ui__server/crontab/task/delete_multi__wizard-title' => '刪除計畫的任務。',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => '選擇您要刪除其任務的系統使用者。',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => '選擇您要刪除的任務。',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => '通過選中核取方塊確認刪除任務，按一下“完成”並退出嚮導。',
    'ui__server/crontab/task/delete_unknown__description' => '刪除計畫任務。',
    'ui__server/crontab/task/delete_unknown__short-title' => '刪除',
    'ui__server/crontab/task/delete_unknown__title' => '刪除計畫任務',
    'ui__server/crontab/task/delete_unknown__wizard-title' => '刪除計畫任務。',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => '選擇您要刪除其任務的系統使用者。',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => '選擇您要刪除的任務。',
    'ui__server/crontab/task/delete_unknown__wizard__4' => '通過選中核取方塊確認刪除任務，請按一下“完成”並退出嚮導。',

    'ui__server/crontab/task/properties__description' => '編輯計畫的任務。',

    'ui__server/crontab/task/properties__short-title' => '編輯任務%1',
    'ui__server/crontab/task/properties__title' => '編輯計畫的任務',
    'ui__server/crontab/task/properties_new__description' => '為 %1 創建計畫的任務。',

    'ui__server/crontab/task/properties_new__short-title' => '添加任務',
    'ui__server/crontab/task/properties_new__title' => '為 %1 創建計畫的任務',
    'ui__server/crontab/task/properties_new__wizard-title' => '創建計畫的任務。',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => '選擇您要為其創建計畫任務的系統使用者。',
    'ui__server/crontab/task/properties_new__wizard__4_new' => '按一下“完成”應用更改並退出嚮導。',
    'ui__server/crontab/task/properties_readonly-unknown__description' => '查看計畫的任務。',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => '屬性',
    'ui__server/crontab/task/properties_readonly-unknown__title' => '查看計畫的任務',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => '查看計畫的任務。',
    'ui__server/crontab/task/properties_readonly__description' => '查看計畫的任務。',
    'ui__server/crontab/task/properties_readonly__short-title' => '查看任務%1',
    'ui__server/crontab/task/properties_readonly__title' => '查看計畫的任務',
    'ui__server/crontab/task/properties_unknown-new__description' => '創建計畫的任務。',
    'ui__server/crontab/task/properties_unknown-new__short-title' => '添加任務',
    'ui__server/crontab/task/properties_unknown-new__title' => '創建計畫的任務',
    'ui__server/crontab/task/properties_unknown__description' => '編輯計畫的任務。',
    'ui__server/crontab/task/properties_unknown__short-title' => '屬性',
    'ui__server/crontab/task/properties_unknown__title' => '編輯計畫的任務',
    'ui__server/crontab/task/properties_unknown__wizard-title' => '編輯計畫的任務。',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => '選擇您要查看其任務的系統使用者。',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => '選擇您要更改其任務的系統使用者。',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => '選擇計畫任務。',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => '選擇您要更改的計畫任務。',
    'ui__server/crontab/task/properties_unknown__wizard__4' => '按一下“完成”應用更改並退出嚮導。',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => '按一下“完成”退出嚮導。',

    'ui__server/crontab/task/toggle_disable__description' => '禁用計畫任務%1。',

    'ui__server/crontab/task/toggle_disable__short-title' => '禁用',
    'ui__server/crontab/task/toggle_disable__title' => '禁用計畫任務%1',
    'ui__server/crontab/task/toggle_enable__description' => '啟用計畫任務%1。',

    'ui__server/crontab/task/toggle_enable__short-title' => '啟用',
    'ui__server/crontab/task/toggle_enable__title' => '啟用計畫任務%1',
    'ui__server/crontab/task/toggle_unknown__description' => '啟用或禁用計畫的任務。',
    'ui__server/crontab/task/toggle_unknown__short-title' => '啟用或禁用',
    'ui__server/crontab/task/toggle_unknown__title' => '啟用或禁用計畫的任務',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => '啟用或禁用計畫的任務',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => '選擇您要啟用或禁用其任務的系統使用者。',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => '選擇您要啟用或禁用的任務。',


    /// not used on HP:

    'ui__client_unknown__short-title' => '客戶帳戶', // not used on HP?
    'ui__client_unknown__title' => '客戶帳戶', // not used on HP?
    'ui__client_unknown__description' => '管理客戶帳戶。', // not used on HP?
    'ui__client/domain/disable_unknown__title' => '掛起域名', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => '掛起域名', // not used on HP,
    'ui__client/domain/disable_unknown__description' => '掛起域名。', // not used on HP
    'ui__client/domain/enable_unknown__title' => '啟動域名', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => '啟動域名', // not used on HP
    'ui__client/domain/enable_unknown__description' => '啟動域名。', // not used on HP


    // to customer home page
    'ui__client/chowner_multi-select__title' => '分配新所有者給所選客戶帳戶',
    'ui__client/chowner_multi-select__short-title' => '分配新所有者',
    'ui__client/chowner_multi-select__description' => '分配新所有者給所選客戶帳戶',


    //Additional FTP Accounts
    'directory_browser__select_folder' => '選擇資料夾',
    'ftp__management_domain' => "域名 %1 下的 FTP 帳戶", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP子帳戶",
    'ftp__user_name' => "FTP子帳戶名稱",
    'ftp__user_home' => "主目錄",
    'ftp__invalid_path' => "所指定的路徑無效",
    'ftp__physical_path_not_exist' => "物理路徑不存在",
    'i_ftp_ses_sub_user' => 'FTP子帳戶會話。',
    '__new_passwd' => "新的%1密碼",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => '無法在主機 <%%host%%> 上配置 web 伺服器',
    'apacheConfigurationFailedMessageBody' => "無法在主機 <%%host%%> 上生成 web 伺服器設定檔因為以下錯誤：\n\n%%error%%\n\n請在 web 伺服器配置範本中修正該錯誤並重新生成檔。",

    'apacheConfigurationMessageAdminTitle' => '生成web伺服器配置失敗',
    'apacheConfigurationMessageClientTitle' => '警告',

    'apacheConfigurationFailedAdminHomeMessage' => '因配置範本錯誤，導致未建立新配置。錯誤詳情已發送到您的郵箱，請查看郵件，修正錯誤，並按一下 %1 重新嘗試生成配置。',
    'apacheConfigurationFailedAdminHomeMessageLink' => '此處', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  '因配置範本錯誤，導致未建立域名 %1 的新配置。錯誤詳情已發送到您的郵箱，請查看郵件，修正錯誤，並按一下 %2 重新嘗試生成配置。',
    'apacheConfigurationFailedAdminDomainMessageLink' => '此處', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => '域名%1的Web伺服器配置可能不一致。請聯繫伺服器管理員解決此問題。',

    'apacheConfigurationFailedAdminDomainsMessage' => '因配置範本錯誤，導致未建成部分域名的新配置。錯誤詳情已發送到您的郵箱，請查看郵件，修正錯誤，並點按 %1 重新嘗試生成配置。',
    'apacheConfigurationFailedAdminDomainsMessageLink' => '此處', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => '部分域名的Web伺服器配置可能不一致。請聯繫伺服器管理員解決此問題。',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "自訂錯誤文檔",
    'dom_pref__webusers_script' => "允許網站用戶使用腳本",
    '__seoRedirect' => '配置偏好的域為',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => '無',

    '__sites' => '域名',
    'domain_plan__perm_denied_manage_phosting' => '許可權不足，無法管理主機設定。',
    '__owned_by_client' => '由客戶所有',
    'ui__client/permissions_readonly__description' => "查看客戶 %1 可在 Plesk 中執行的操作。",
    'client_chown_subscription_will_be_anonymous' => '客戶將取消訂閱當前服務方案。',
    'backup__restore__object_client_template' => '客戶範本',
    '__template_name' => '服務方案名稱',
    'template__not_exists' => '服務方案不存在。',
    'template__exists' => '名為 %1 的方案已經存在。',
    'clientOwnerChanger__has_domains_subscribed_to_reseller_plans' => '客戶已有域名訂閱%1\\的服務方案。',
    'clientOwnerChanger__ip_not_in_pool' => '指定的 IP 位址未在代理商的池裡。',

    //// Change owner of subscription
    'chown__select_title' => "選擇新訂戶",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => '為所選訂閱選擇新的所有者並按一下下一步 >>。',
    'domains__client_info' => "%1 個訂閱，%2 個活動訂閱，已使用磁碟空間 %3，已使用流量 %4",
    '__possible_owners' => '可能的新訂戶',

    'clients_list__filter_owner__filter_title' => '服務商',
    'clients_list__filter_owner_any' => '所有用戶',
    'clients_list__filter_owner_my' => '僅限我的客戶',
    'clients_list__filter_owner_name__filter_title' => '服務商名稱',

    '__owner' => "服務商",
    'l_clientslist_owner' => '按服務商對使用者帳戶進行排序。',
    'l_clientslist_date' => '按日期對客戶帳戶進行排序。',
    'l_clientslist_name' => '按名稱對客戶帳戶進行排序。',
    'l_clientslist_domains' => '按域名對使用者帳戶進行排序。',
    'l_clientslist_cname' => '按公司名稱對客戶帳戶進行排序。',

    'ui__client/domain/chowner_multi__wizard-title' => '正在重新分配選定的訂閱',
    'chown__check_title' => '更改訂戶',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "按一下“完成”結束操作。完成後，所選訂閱則會分配給新的所有者，相關服務商則會更改為新所有者的服務商，且訂閱將會與其服務方案解除綁定，成為'自訂'訂閱。",

    'chown__error_check' => '嘗試分配訂閱給新所有者時出現問題。',
    'domain_chown_subscription_will_be_anonymous' => "即將從當前服務方案取消限制訂閱，並變成'自訂'。",
    'chown__error_domains_exclude' => "嘗試向新的所有者移交某些訂閱時出現問題。突出顯示的為移交出現問題的訂閱。",
    'chown__ip_not_in_client_pool' => "尚未將此訂閱的IP位址分配給新的訂閱所有者的IP位址集區",
    'chown__already_owned_by_client' => "此訂閱已屬於該用戶。",

    /// Protected directories

    'ui__client/domain/hosting/protected-directories/path__short-title' => '/%1',
    'ui__client/domain/hosting/protected-directories/path__title' => '受保護目錄/%1',
    'ui__client/domain/hosting/protected-directories/path__description' => '管理受保護目錄/%1',
    'ui__client/domain/hosting/protected-directories/path/properties_new__title' => '在網站 %1 下創建受保護目錄',
    'ui__client/domain/hosting/protected-directories/path/properties_new__short-title' => '添加受保護目錄',
    'ui__client/domain/hosting/protected-directories/path/properties_new__description' => '創建受保護目錄。',
    'ui__client/domain/hosting/protected-directories/path/properties_new__done' => '成功創建受保護目錄/%1。',
    'ui__client/domain/hosting/protected-directories/path/properties__title' => '受保護目錄/%1的設定',
    'ui__client/domain/hosting/protected-directories/path/properties__short-title' => '目錄設定',
    'ui__client/domain/hosting/protected-directories/path/properties__description' => '更改受保護目錄的位置、名稱和區域標題。',
    'ui__client/domain/hosting/protected-directories/path/properties__done' => '已更改受保護目錄設定',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__title' => '確認刪除',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__short-title' => '移除受保護內容',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__description' => '移除所選目錄的保護機制。',
    'ui__client/domain/hosting/protected-directories/path/delete__empty_selection' => '選擇要移除保護的目錄。',
    'ui__client/domain/hosting/protected-directories/path/delete#legend__description' => '此操作將導致從目錄中移除保護功能。Internet使用者將可以自由存取這些目錄。',
    'ui__client/domain/hosting/protected-directories/path/delete_multi__done' => '從所選目錄中成功移除受保護內容。',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__title' => '添加用戶',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__short-title' => '添加用戶',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__description' => '設定存取受保護目錄%1的使用者帳戶',
    'ui__client/domain/hosting/protected-directories/path/user/properties_new__done' => '已創建存取受保護目錄的使用者帳戶。',
    'ui__client/domain/hosting/protected-directories/path/user/properties__done' => "已保存用戶憑證。",
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__title' => '已移除受保護目錄使用者',
    'ui__client/domain/hosting/protected-directories/path/user/delete__empty_selection' => '選定您需移除的用戶。',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__short-title' => '移除',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__description' => '移除目錄使用者。',
    'ui__client/domain/hosting/protected-directories/path/user/delete#legend__description' => '即將刪除下列受保護目錄:',
    'ui__client/domain/hosting/protected-directories/path/user/delete_multi__done' => '已移除所選使用者帳戶。',

    '__redirect_hint' => '即將在15秒內重定向到新地址... 若未自動轉到新位址，請啟用javascript或點按超連結%%link%%。',

    'backup__restore__object_maillist' => '郵寄清單',
    'backup__restore__object_site' => '網站',
    'backup__restore__object_user' => '用戶',
    'backup__restore__object_role' => '角色',

    'limit__name_max_site' => '網站',

    'iis_pool__unable_rename_client' => "無法重命名IIS應用程式池: %1。",

    'anonftp__is_not_supported_for_addon_domains' => '僅限此訂閱的主域名支援匿名FTP服務。',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => '僅限此訂閱的主域名支援匿名FTP服務。',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/月',
    '__tb_month' => 'TB/月',

    '__customers' => '客戶',
    '__customer_name' => '客戶名稱',
    '__customer_total' => '總客戶',
    '__site' => '網站',
    '__def_site' => '默認網站',
    '__subscription_name' => '訂閱名稱',
    '__subscription_name_powerUser' => '訂閱名稱',

    'limit__units_max_traffic_suffix' => '/月',

    'dom_pref__discard' => "丟棄",

    'mail__pattern_already_exists' => '範本"%1"已在黑名單中。',

    '__not_supported' => '不受支援',

    'plesk_key__sitebuilder' => '使用 Presence Builder 發佈的網站',
    'limit__name_max_site_builder' => '使用 Presence Builder 發佈的網站',
    'plesk_key__wpb-multi-language-sites-support' => '在 Presence Builder 中支援多語言網站',

    'ui__client/domain/traffic-hosting__title' => '域名%1的資料傳輸統計',
    'ui__client/domain/traffic-hosting__title_powerUser' => '域名%1的資料傳輸統計',
    'ui__client/domain/traffic-hosting#list__title' => "按服務進行資料傳輸",

    'login_up__access_denied_no_subscriptions' => "拒絕存取。此帳戶無可用訂閱。",

    'interval__day' => '%1日',
    'interval__hour' => '%1小時',
    'interval__minute' => '%1分鐘',
    'interval__second' => '%1秒',

    ///License options
    'plesk_key__backward_incompatibility' => '您正在嘗試使用為其它 Plesk 版本創建的許可證金鑰。請聯繫 Plesk 銷售代表獲取正確的許可證金鑰。',
    //Standalone or virtualization
    'virtualization_any' => "物理伺服器或任何虛擬化解決方案",
    'virtualization_pvc' => "Virtuozzo 容器",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "對下列環境進行驗證:",
    'plesk_key__virtualization_only_key' => '此許可證金鑰僅適用於在 %1 虛擬環境中操作 Plesk 。',
    'plesk_key__virtualizations_only_key' => '此許可證金鑰僅適用於在下列虛擬環境中操作 Plesk：%1.',
    //Language options
    'plesk_key__invalid_locale_signature' => '禁止使用自訂語言包。',
    'plesk_key__allowed-locales' => '可用語言',
    'plesk_key__allowed-locales-any' => '任意語言',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin目錄位於',
    '_cgi_bin_mode_webspace' => '訂閱的根目錄',
    '_cgi_bin_mode_www_root' => '此域名的文檔根',

    ///ODBC DSN data sources
    'ui__server/odbc/dsn/properties_unknown-new__short-title' => '添加 ODBC DSN',
    'ui__server/odbc/dsn/properties_unknown-new__description' => '添加ODBC資料來源。',
    'ui__server/odbc/dsn/delete_multi__short-title' => '移除',
    'ui__server/odbc/dsn/delete_multi__title' => '確認移除',
    'ui__server/odbc/dsn/delete_multi__description' => '移除所選ODBC DSN資料來源。',
    'ui__server/odbc/dsn/delete#legend__description' => '即將移除下列ODBC DSN連線:',
    'ui__server/odbc/dsn/delete__empty_selection' => '未選擇ODBC DSN連線。',
    'ui__server/odbc/dsn/delete_multi__done' => '已移除所選資料來源。',
    'ui__server/odbc/dsn__title' => 'ODBC DSN連線%1',

    'ui__client/domain/odbc/dsn/properties_new__short-title' => '添加 ODBC DSN',
    'ui__client/domain/odbc/dsn/properties_new__description' => '添加ODBC資料來源。',
    'ui__client/domain/odbc/dsn/delete_multi__short-title' => '移除',
    'ui__client/domain/odbc/dsn/delete_multi__title' => '確認移除',
    'ui__client/domain/odbc/dsn/delete_multi__description' => '移除所選ODBC DSN資料來源。',
    'ui__client/domain/odbc/dsn/delete#legend__description' => '即將移除下列ODBC DSN連線:',
    'ui__client/domain/odbc/dsn/delete__empty_selection' => '未選擇ODBC DSN連線。',
    'ui__client/domain/odbc/dsn/delete_multi__done' => '已移除所選資料來源。',
    'ui__client/domain/odbc/dsn__title' => 'ODBC DSN連線%1',


    /// Custom buttons
    'custom_button__sort_key' => '優先順序',
    'custom_button__place' => '位置',
    'custom_button__place_navigation' => '通用存取',
    'custom_button__place_admin' => '管理員首頁',
    'custom_button__place_admin-settings' => '管理員的 工具與設定 頁面',
    'custom_button__place_reseller' => "代理商首頁",
    'custom_button__place_reseller-settings' => '代理商的 工具與實用程式 頁面',
    'custom_button__place_client' => '客戶首頁',
    'custom_button__place_domain' => "訂閱的 網站與域名 頁面",
    'custom_button__place_domain_powerUser' => "訂閱的 網站與域名 頁面",
    'custom_button__place_domain-properties' => '網站工具',
    'custom_button__private' => '僅向我顯示',
    'custom_button__image' => '背景圖片',
    'custom_button__conhelp' => "工具提示文本",
    'custom_button__edit' => "其它服務的連結設定",
    'custom_button__include_client_cname' => "包含客戶的公司名稱",
    'custom_button__include_client_email' => "包含客戶的電子郵件",
    'custom_button__include_client_id' => "包含客戶ID",
    'custom_button__include_client_pname' => "包含客戶的連絡姓名",
    'custom_button__include_domain_id' => "包括訂閱 ID、域名 ID 和域名別名 ID",
    'custom_button__include_domain_id_powerUser' => "包括訂閱 ID、域名 ID 和域名別名 ID",

    'custom_button__include_domain_name' => "包括主域名",
    'custom_button__include_ftp_user' => "包含FTP用戶名",
    'custom_button__include_ftp_pass' => "包含FTP密碼",
    'custom_button__internal_open' => "在 Plesk 中打開 URL",
    'custom_button__text' => "按鈕標籤",
    'custom_button__url' => "URL",

    'custom_button__not_image' => '檔不是鏡像檔。',
    'custom_button__big_image' => '檔大小不得超過 100 KB。',
    'custom_button__failed_copy_image' => '無法複製檔：%1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => '無法在高級使用者視圖下恢復非高級使用者備份。',
    '__unknown_network_interface' => '未知網路介面',

    'init_conf__ip_address' => 'IP地址',

    //Confirmation page
    'bt_confirm' => '確認',
    'b_confirm' => '確認網站所有者。',

    //// New VZPP Integration
    '__vzpp_integration_warning' => '該 Plesk 實例安裝於一個 Virtuozzo 容器中。當前的容器離線管理設定導致 Plesk 不可用。',
    '__vzpp_integration_contact_admin' => '如果您有足夠的許可權更改容器配置，%1。否則，請聯繫您的提供商來操作。',
    '__vzpp_integration_help_link' => '更改離線管理設定',



    'performance__iss_app_pool_forced_by_site_isolation' => '獨立IIS應用百寶箱的設定根據伺服器級安全性原則（網站隔離配置）而定。',
    'performance__iss_app_pool_forced_by_server_wide_settings' => '獨立IIS應用百寶箱的設定根據伺服器級性能設定而定。',

    '__current' => '當前',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => '使用者屬性已更新。',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => '您已幾乎使用 Plesk 許可證提供所有的域名（90% 或更多）。',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => '您幾乎使用了所有域名。',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => '您幾乎使用了 Plesk 許可證提供的所有 Presence Builder 網站（90% 或甚至更多）。',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => '您幾乎使用了所有 Presence Builder 網站。',
    'promo__button_hide' => '隱藏',
    'promo__button_next' => '往後 >>',
    'promo__button_prev' => '<< 往前',
    'promo__button_license' => '更新許可證',

    'promo__google_integration_title' => '與 Google 服務集成',
    'promo__google_integration' => '配置與 Google 服務集成，如 AdSense、Google Apps 與網站管理員工具。',
    'promo__google_integration_button' => '配置',

    'promo__button_learn_more' => '瞭解更多',

    //// Plesk Branding in 10.1
    'panel_branding__description' => '您可以通過自訂方案定制化介面外觀並優化設定。欲瞭解自訂 Plesk 主題的說明，請參閱 %1。',
    'panel_branding__description_link' => '下面文檔',
    'mail__enable_mail_ui_label' => '在 Plesk 裡啟用郵件管理功能',

    ///// File Manager new buttons
    'bt_extract_archive' => '提取文件',
    'b_filemanager__extract' => '從所選的文檔裡提取檔到現有目錄。注意如果檔案名包含公共通用字元，在提取後檔案名將不正常顯示。',
    'filemanager_error_extracting_files' => '提取壓縮檔出現錯誤：%1',
    'filemanager_no_archive_files_specified' => '指定您要提取的文檔。',
    'filemanager_not_zip_archive_specified' => '%1 無法提取，不是 ZIP 文檔。',
    'filemanager_files_successfully_extracted' => '壓縮檔已被提取。',
    'filemanager_error_file_download' => '下載檔失敗：%1',
    'filemanager__user_poolgrp' => '應用程式池組',

    'loading' => '載入...',
    'bt_create_archive' => '添加至壓縮檔',
    'filemanager__pack' => "進入壓縮檔的路徑：%1",
    'filemanager__archive_name' => '壓縮檔名',
    'filemanager__empty_filename' => '請輸入壓縮檔名。',
    'filemanager_archive_created' => '已成功創建壓縮檔。',
    'filemanager_error_creating_archive' => '無法創建壓縮檔：%1',

    'cmd_dns__aaaa_dns_record_already_exist' => "該記錄將會與用於區域的 AAAA 記錄相衝突。",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "（FTP 伺服器不支援 IPv6 位址。）",
    'cmd_dns__glue_dns_record_conflict' => '該記錄將會與 \'%1\'區域的粘附 (glue record) 記錄相衝突。',
    '__ftp_ipv6_not_supported' => "（FTP 伺服器不支援 IPv6 位址。）",
    '__ipv6_not_supported' => '不支援 IPv6。',
    'mail__ipv6_not_supported' => '郵件伺服器不支援 IPv6。',
    'mail__relay_while_list_ipv6_not_supported' => '郵件伺服器不支援 IPv6 中繼白名單。',
    'mail__relay_while_list_ipv6_mask_mul_16' => '設定值必須為 16 的倍數。',
    'mail__ip_or_mask_is_invalid' => 'IP位址/網路遮罩無效。',
    'nonexistent_mail__redirect_ipv6_not_supported' => '不支援轉發到 IPv6 IP 位址。',
    'sa__invalid_trusted_networks' => '不正確指定的信任網路：%1',
    'dns_add__enter_ipv6_address' => "IPv6 地址",
    'license_trial_days_left' => '您的 Plesk 正使用一個試用許可證進行操作，該許可證將在 %1 天后到期。',
    'excl_ipv6_num' => '獨立 IPv6 位址',
    '__ip_mask' => "子網路遮罩",
    '__ipv4_addr' => 'IPv4 地址',
    '__ipv6_addr' => 'IPv6 地址',
    'template__num_excl_ipv6s' => '分配獨立 IPv6 位元元址給代理商',
    'anonftp__exclusive_ipv4_required' => '需要獨立的 IPv4 位址以創建並使用匿名 FTP 服務。',
    'anonftp__ipv4_already_used' => '您無法為此網站創建匿名 FTP 服務因為已在其他域名的同一 IPv4 位元元址上配置過。',


    'restart__kav' => "Kaspersky Antivirus",
    'panel_branding__page_description_admin' => '可通過更改在瀏覽器標題列中顯示的頁面標題和/或替換左上角的 Plesk 徽標來自訂 Plesk 介面品牌。',
    '__view_migration_log_detailed_info' => '查看日誌',

    'chown__ip_address_warn' => '把訂閱移動給新的所有者之前，您必須選擇該訂閱的新 IP 位址。',
    'chown__no_ip_address' => '無',
    'chown__no_ipv4_address' => '無 IPv4 地址',
    'chown__no_ipv6_address' => '無 IPv6 地址',
    'chown__domain_exclude_already_owned_by_client' => '此訂閱 %1 已屬於該用戶。',
    'chown__error_ip_absent_in_ip_pool' => '在目標使用者 IP 池裡不顯示 IP 位址 %1。',
    'chown__error_ip_not_exist' => 'ID 為 \'%1\' 的 IP 地址不存在。',
    'chown__error_domain_ip_not_selected' => '至少應該為域名 %1 選擇一個 IP 位址。查看 IP 映射所選擇的值。',

    '__new_passwd_single' => "密碼",
    '__confirm_passwd_single' => "確認密碼",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 地址或遮罩無效：IP 位址應為有效的單播位址。',

    '__subscriptions' => '訂閱',

    '__owned_by_reseller' => '代理商所有',
    '__owned_by_provider' => '供應商所有',

    'service_plan__anonymous' => '自訂',
    'subscription_not_locked__change_limits_warning' => '此訂閱未鎖定：在與服務方案同步時此資源使用上限將被更改。',
    'subscription_not_locked__change_permissions_warning' => '此訂閱未鎖定：在與服務方案同步時此許可權將被更改。',

    'subscription__conflict_resolution_policy' => '衝突解決策略',
    'subscription__conflict_resolution_policy_lock' => "鎖定訂閱",

    'backup__list__backup_warnings' => '警告',
    'backup__list__backup_info' => '信息',
    'backup__restore__object_reseller_template' => '代理商範本',
    'backup__restore__object_domain_template' => '域名範本',

    'ui__client/permissions_readonly__title' => '許可權',
    'ui__client/permissions_readonly__short-title' => '許可權',

    'subscription__unable_lock_anonymous' => '此訂閱未與服務方案綁定，因此無法解鎖。',
    'subscription__unable_sync_anonymous' => '此訂閱未與服務方案綁定，因此無法同步。',
    'subscription__unable_sync_locked' => '此訂閱被鎖定，因此不能同步。',
    'subscription__locked' => '此訂閱已被鎖定。',
    'component_name__urlrewrite' => "URL 重寫",
    '__quantity' => '數量',
    'hst__www_root_dir_absent' =>  '警告：指定為檔根的目錄不存在。',
    'object_creation__domain_is_not_a_webspace' => '只能在訂閱裡創建此對象。',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => '訂閱包含網站，因此，您無法更改主機類型或移除主機類型。',
    'phosting__addon_domain_ip_must_match_webspace' => '錯誤：更新 IP 位址失敗。不能將未分配給訂閱主域名的 IP 位址分配給附加域名。',
    'domain_plan__unable_change' => '無法更改服務方案：%1。',
    'domain_plan__different_hosting_type' => '當前託管類型不同於在服務方案裡指定的類型。',
    'domain_plan__addon_text' => '附加方案',
    'domain_plan__addon_description' => '附加方案用於補充主機方案。',
    'asp_net__managed_runtime_version' => 'ASP.NET 託管執行階段版本',
    'plan__can_not_change_hosting_type' => '在編輯方案時無法更改託管類型。',
    'plan__apply_problems' => '因下列功能問題導致未應用方案： %1',
    'plan_save__subscription_update_problem' => '無法在 %1 裡應用方案更改。',
    '__perm_denied_subscription_suspended_by_backuprestore' => "在備份或恢復過程完成前訂閱暫時掛起。之後請返回。",
    'mail__whitenet_exists' => "帶有首碼 %1 的白名單已經存在。",
    '__login_incorrect_plain_shadow_password' => '您指定的管理員帳戶的密碼不正確。請使用系統管理員（root）認證，或者獲取正確的密碼。若要瞭解獲取密碼的更多資訊，可參閱檔 /etc/psa/README.psa.shadow。',

    '__perm_denied_ip' => '您無法發送不屬於您的 IP 地址',

    'dns__dns_zone_not_synchronized' => '已修改 DNS 區域。如果您想要在該區域應用 DNS 範本更改，可在該頁面按一下 \'應用 DNS 範本更改\' 按鈕或進入伺服器管理面板 > 工具與設定 > DNS 範本設定 > 應用 DNS 範本更改 選擇 \'應用更改至所有區域\' 選項。',
    'dns__dns_zone_synchronize_link' => '按一下',
    'dns__dns_zone_synchronize_done' => 'DNS 區已成功同步。',

    'dns__dns_zone_template_not_synchronized' => 'DNS 區域範本已更改且將要被應用到所有新創建的域名。您還可以 %1。',
    'dns__dns_zone_soa_template_not_synchronized' => 'SOA 範本已更改且將要被應用到所有新創建的域名。您還可以 %1。',
    'dns__dns_zone_template_synchronize_link' => '應用更改到所有的託管域名',
    'dns__dns_zone_template_error_details' => '詳情',
    'dns__dns_zone_template_error' => '同步 DNS 區域和 DNS 區域範本時出現問題。%1',

    'dns__soa_rname_type_owner' => '網站所有者的郵箱地址',
    'dns__soa_rname_type_domain' => '域名电子邮件地址',
    'dns__soa_rname_type_external' => '外部电子邮件地址',
    'dns__soa_rname_enforce_email' => '禁止單獨為每個域名更改 RNAME 電子郵箱位址',
    'dns__soa_rname_label' => '电子邮件（RNAME）',
    'dns__soa_rname_hint' => '負責域名 DNS 區域的人的電子郵箱位址。由 DNS 伺服器回應 SOA 查詢返回。',

    'dns__dns_zone_soa_sync_title' => '覆蓋所有現有域名的SOA設定',
    'dns__dns_zone_soa_sync_legend' => '需要確認',
    'dns__dns_zone_soa_sync_text' => '通過應用對 SOA 範本所做的更改來更新所有託管域名的 SOA 記錄？',

    'cu_db__repair_mysql_dbus' => "修改 MySQL 使用者密碼。如果您從以前的版本升級至 Plesk 11 時需要進行此操作。",

    'scheduled_backup_settings__start_at_hint' => '預訂備份任務每隔 15 分鐘檢查一次。如果您想要 Plesk 在某個特定時間開始備份處理，需在該時間至少 15 分鐘之前安排好。',
    'cu_scheduled_backup_comment' => '計畫的備份',
    'cu_scheduled_backup_error' => '在備份過程中出現一個錯誤：%1',
    'cu_scheduled_backup_mail_subject' => '<%1> 在計畫備份過程中出現了一個錯誤。',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk 入口點： %2\n\n在計畫備份過程中出現了以下錯誤：\n\n%3",
    'cu_scheduled_backup_comment_backup_all' => '計畫備份。所有配置和內容。',
    'cu_scheduled_backup_comment_backup_vhost' => '計畫備份。所有配置和除郵件之外的內容。',
    'cu_scheduled_backup_comment_backup_mail' => '計畫備份。僅郵件配置和內容。',
    'cu_scheduled_backup_comment_backup_domain' => '計畫備份。域名配置。',

    'i_backup_invalid_file' => '這是無效備份。不能從該檔案修復資料。按一下該備份名瞭解詳情。',

    'ui__server/migration/download-agent__short-title' => '下載 遷移與傳輸代理',
    'ui__server/migration/download-agent__title' => '下載 遷移與傳輸代理',
    'ui__server/migration/download-agent__description' => '從 Plesk 網站上下載最新版本的 遷移與傳輸代理。',

    'filemanager_resulting_archive_exists' => '目標目錄裡已經存在檔 %1。',

    'agent_unable_to_connect' => '無法連接在 \'%2\' 上的代理。請確保已經安裝並正在運行代理，而且主機 \'%2\' 沒有連接問題。',
    'agent_test_connection_failed' => '連接 \'%2\' 上的代理失敗。',

    'agent_unable_to_resolve_host' => '無法找到遠端主機 \'%1\'。請確保該主機沒有任何連接問題。',
    'agent_unknown_curl_error' => '連接 \'%2\' 上的代理過程中出現錯誤 \'%1\' .',
    'agent_unexpected_htp_code' => '對 \'%2\' 上的代理進行 HTTP 請求時出現意外的 HTTP 代碼 \'%1\'。',
    'agent_unable_to_auth' => '無法在主機 \'%1\' 上驗證。要解決該問題，請根據該知識庫文章的說明操作：http://kb.plesk.com/116606。',
    'agent_internal_server_error' => '在遠端主機 \'%1\' 上執行指令的過程中出現內部伺服器錯誤。',
    'agent_response_is_empty' => '對 \'%1\' 上的代理進行 HTTP 請求時出現空的反應。',

    'migration__disabled_due_to_local_file_does_not_exist' => '在本地緩存中無法找到遷移與傳輸代理。請再次打開 遷移與傳輸管理器 修正該問題。',

    '__hosting_webdeploy' => "Web Deploy 發佈",
    'cu_domain__webdeploy' => "Web Deploy 發佈（默認：%1）",
    'cu_dom_tpl__webdeploy' => "Web Deploy 發佈（默認：%1）",
    'cu_subdomain__webdeploy' => "Web Deploy 發佈（默認：%1）",
    'webdeploy__not_installed' => "Microsoft Web 部署沒有安裝在伺服器上",
    'webdeploy__forced_by_site_isolation' => "無法更改 Web Deploy 發佈設定：您沒有許可權覆蓋伺服器級安全策略。聯繫您提供商瞭解詳情。",



    'backup__restore_options__admin__server_configuration_license' => '許可證金鑰',
    'migration_start_migrate_server_license' => '轉移許可證金鑰',

    'defaultcomponents__delegation_rule_not_exist' => '（所需授權規則 \'appPoolPipeline, appPoolNetFx\' 不存在）',

    '__o' => 'O',

    'i_backup_created_by_admin' => '管理員已創建備份。',
    'i_backup_created_by_reseller' => '代理商已創建備份。',
    'i_backup_created_by_client' => '客戶已創建備份。',

    'migration__object_exists_on_target_host' => '（在目標主機上已存在）',

    '__customers_total' => '全部按客戶',
    '__resellers_total' => '全部按代理商',
    '__reseller_total' => '代理商總量',


    'cu__mailserver_update_webmail_command' => "指定您需要啟用或禁用的 web 郵箱用戶端",
    'cu__mailserver_webmail_state' => "指定選定的 web 郵箱用戶端的狀態（true 啟用用戶端，false 禁用用戶端）",

    'cu_db_set_default_user' => '設定使用資料庫的預設使用者。該選項的命令：add_user, update_user',

    'cu_role__opt_subscription_name' => '僅允許用戶指定的訂閱',
    'cu_role__opt_for_all_subscription' => '允許使用者可存取一個主機帳戶中的所有訂閱',
    'cu_role__subscription_not_found_role_is_not_limited' => '無法在此角色中應用更改：未找到訂閱 %1 。',

    'cu_cl_pref__manage_website_maintenance' => '進入高級操作：網站複製',
    'cu_cl_pref__manage_protected_dirs' => '管理有密碼保護的目錄',
    'cu_cl_pref__manage_mail_settings' => '允許更改郵件設定',


    'cu__command_update_php_settings' => '更新 PHP 設定。',
    'cu__php_settings_option' => '設定可進入帶有 PHP 設定的檔的路徑。',

    'cu__additional_php_settings_option' => '設定可進入帶有其它 PHP 指令的檔的路徑。',
    'cu__command_show_php_settings' => '顯示當前的 PHP 設定。',
    'cu__general_settings' => '常規設定：',
    'cu__performance_settings' => '性能設定：',
    'cu__php_fpm_settings' => 'PHP-FPM 設定：',
    'cu__additional_directives' => '其它指令：',

    'b_filemanager__pack' => '添加所選的文件到壓縮檔。',

    'php_settings_permission_required' => '通用 PHP 設定管理',
    'php_settings_performance_permission_required' => '"主機性能設定管理"許可權',
    'php_settings_customized' => 'PHP 設定已定制化。',
    'php_settings_synchronized_with_plan' => 'PHP 設定必須與方案同步。',
    'phosting__unknown_shell_type' => '無效的 shell',

    'login_up__access_denied_subscription_deleted' => '存取被拒絕：您的訂閱已移除。',

    'role_restricted_to_subscription' => '（與訂閱一起傳輸：%1)',

    'filemanager__extract' => "提取文件至：%1",

    'cu__license_command_check_installed_license' => '查看已安裝的許可證的有效性（如果金鑰有效返回 0 推出代碼，如果金鑰無效則返回 1）',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "擴展 Plesk 功能以通過移動設備（BlackBerry、iPhone 與 Android）控制與監控伺服器。",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => '可通過移動設備（BlackBerry、iPhone 與 Android）隨時隨地獲得有關 Plesk 伺服器最重要的資訊。',
    'promo__mobile_button' => '瞭解更多',

    'ui__server/migration/video__short-title' => '視頻教程',
    'ui__server/migration/video__title' => '觀看視頻教程',
    'ui__server/migration/video__description' => '觀看視頻教程。',

    'auto_install_updates_moved_to_separate_page' => '配置更新策略',

    '__system_preferences' => '系統設定',
    'subDomainNameHint' => '輸入 * 作為子域名以創建一個萬用字元子域。不管網站訪客在瀏覽器中輸入什麼子域名都將被重導向該子域。',
    'subdomains__wildcard_name_invalid' => "子域名無效。萬用字元子域名只能包含字母數位元元、連字號 (-) 和星號 (*)。",
    'subdomains__name_invalid' => "子域名無效。子域名只能包含字母數位元元和連字號 (-)。",

    'domain__wildcard_no_www_prefix' => '萬用字元子域名不能使用 www 首碼。',

    '__service_title__milter' => "Plesk 尾碼篩檢程式",
    '__service_description__milter' => "Plesk 尾碼郵件篩檢程式",
    '__milter' => "尾碼篩檢程式",
    'restart__milter' => "Plesk 郵件篩檢程式（%1）",
    'restart__pop3' => "Courier POP3 伺服器",
    'restart__pop3s' => "帶有 SSL/TLS 支援的 Courier POP3 伺服器",
    'restart__imap' => "Courier IMAP 伺服器",
    'restart__imaps' => "帶有 SSL/TLS 支援的 Courier IMAP 伺服器",
    'restart__authdaemon' => "Courier IMAP 驗證守護進程",
    'restart__imap-pop3' => "Dovecot IMAP 和 POP3 伺服器",


    'addon_packages_not_supported' => '不支援用於 APS 打包的 web 應用程式的附件。',
    'cu_domain__unable_to_automaticaly_select_ip' => '無法自動分配 IP 位址給域名。請使用 -ip 選項指定一個 IP 位址。',

    'plesk_key__mb_accounts' => 'Customer and Business Manager 中的使用者帳戶（代理商與客戶）',

    'actionlog__subdomain_dns' => '子域名 DNS 區域',
    'actionlog__site_subdomain_dns' => '其它域名下子域名的 DNS 區域',

    // PfW only
    'actionlog__event_site_create' => '已創建域名',
    'actionlog__event_site_delete' => '已刪除的域名',
    'actionlog__event_site_update' => '已更新的域名',

    'actionlog__event_site_status_update' => '已更新的域名狀態',
    'actionlog__event_site_dns_update' => '已更新的域名 DNS 區域',
    'actionlog__event_site_guid_update' => '已更新的域名 GUID',

    'actionlog__event_site_subdomain_create' => '已創建子域名',
    'actionlog__event_site_subdomain_delete' => '已刪除的子域名',
    'actionlog__event_site_subdomain_update' => '已更新的子域名',

    'actionlog__event_site_alias_create' => '已創建域名別名',
    'actionlog__event_site_alias_delete' => '已刪除的域名別名',
    'actionlog__event_site_alias_update' => '已更新的域名別名',

    'actionlog__event_site_alias_dns_update' => '已更新域名別名的 DNS 區域',
    'actionlog__event_subdomain_dns_update' => '默認域名下子域名的 DNS 區域已更新',
    'actionlog__event_site_subdomain_dns_update' => '已更新子域名的 DNS 區域',
    // End of PfW only

    'rdp_app__type' => '終端會話應用程式',
    'rdp_app__msactivex' => 'Microsoft RDP ActiveX',
    'rdp_info__prop_title' => "通過遠端桌面連接伺服器",
    'rdp_info__session_title' => '伺服器%1 (%2) 的終端會話',
    'rdp_info__prop_legend' => "終端會話屬性",
    'rdp_screen_resolution' => '終端會話的螢幕解析度',
    'rdp_user_name' => '終端會話用戶名',

    'win_policy__bad_password' => '驗證失敗。密碼無效。',
    'win_policy__password_too_short' => '驗證失敗。密碼太短，不符合密碼策略要求。',
    'win_policy__password_too_long' => '驗證失敗。密碼太長，不符合密碼策略要求。',
    'win_policy__password_not_complex_enough' => '驗證失敗。密碼不夠複雜且不符合伺服器策略要求。強式密碼必須至少包含以下所有項：八個字元；一個大寫或小寫字元；三個數位和一個特殊字元（!、@、#、$、%、^、&、*、?、 _、~）或一個數位和兩個特殊字元。',

    //// Activation Code feature
    'key__tabs_activation' => '啟動許可證',
    'key__description' => '在此處您可通過輸入啟動代碼或上傳許可證金鑰檔來安裝許可證金鑰',
    'key__description_code_only' => '您可在此輸入啟動碼來安裝您的許可證金鑰。',
    'key__license_key' => '選擇以下中的一項：',
    'key__code_text' => '輸入啟動代碼',
    'key__code_hint' => '粘上您收到的啟動代碼。',
    'key__file_text' => '上傳許可證金鑰檔',
    'key__file_hint' => '指定進入包含許可證金鑰的檔的路徑。',
    'plesk_key__code_check_wrong' => '該啟動代碼無效。',
    'plesk_key__license_update_failed' => '無法更新產品許可證。',


    'filemanager__error_path_is_not_allowed' => '路徑不被允許',
    'filemanager__error_path_is_invalid' => '路徑無效',
    'filemanager__error_path_not_found' => '路徑未找到',
    'filemanager__error_path_already_exists' => '路徑已存在',
    'filemanager__error_access_is_denied' => '存取被拒絕',
    'filemanager__error_directory_not_empty' => '資料夾不為空',
    'filemanager__error_sharing_violation' => '共用衝突',
    'filemanager__error_not_same_device' => '目的路徑不在同一設備上',
    'filemanager__binary_data_access' => '該檔可能是二進位檔案。您想要打開它嗎？',
    'filemanager__unable_to_resolve_realpath' => "無法在特定的位置找到 %1 文件",
    'filemanager__access_to_realpath_denied' => "存取 realpath 被拒：%1 到 %2。",
    'bt_exit' => '退出',

    'filemanager__chdir_error__' => "無法更改目錄為 %1：%2。",
    'filemanager__chmod_dir' => "更改目錄 %1 的許可權",
    'filemanager__chmod_error__' => "無法更改文件 %1 的許可權：%2。",
    'filemanager__chmod_file' => "更改文件 %1 的許可權",
    'filemanager__copy_error__' => "無法複製 %1 到 %2：%3。",
    'filemanager__copy_move' => "從 %1 處複製 (移動) 檔。",
    'filemanager__count_size__' => '所選項大小：%1',
    'filemanager__count_size_error__' => '無法計算 %1 的大小：%2。',
    'filemanager__create_dir' => "目錄創建",
    'filemanager__create_dir_error__' => "無法創建目錄 %1：%2。",
    'filemanager__dir_not_exists' => "目錄 %1 不存在。",
    'filemanager__dirname' => "目錄名",
    'filemanager__filename' => "檔案名",
    'filemanager__is_no_such' => "不存在帶有名稱 %1 的檔或目錄。",
    'filemanager__empty_selection' => "尚未選擇檔",
    'filemanager__file_exists' => "文件 %1 已存在。",
    'filemanager__move_error__' => "無法移動 %1 到 %2：%3。",
    'filemanager__new_dir' => "目錄名",
    'filemanager__not_allowed' => "不允許更改此檔。",
    'filemanager__r_perm_dir' => "列出目錄",
    'filemanager__r_perm_file' => "讀取數據",
    'filemanager__remove' => "從 %1 中刪除檔。",
    'filemanager__remove_error__' => "無法刪除檔 %1：%2。",
    'filemanager__rename_dir' => "重命名目錄 %1",
    'filemanager__rename_error__' => "無法重命名 %1 為 %2：%3。",
    'filemanager__rename_file' => "重命名檔 %1",
    'filemanager__set_win_permissions_dir' => "設定 %1 資料夾的許可權",
    'filemanager__set_win_permissions_file' => "設定 %1 文件的許可權",
    'filemanager__touch_confirm' => "您確定要更改所選檔的時間戳記嗎？",
    'filemanager__no_perms_or_unsupported_file_type' => '無法讀取檔或者檔案格式不受支援。',
    'filemanager__upload_error__' => "無法上傳 %1 到 %2：%3。",
    'filemanager__upload_file' => "上傳文件",
    'filemanager__upload_file_src' => "檔路徑",
    'filemanager__username' => "用戶",
    'filemanager__w_perm_dir' => "創建文件",
    'filemanager__w_perm_file' => "寫入資料",
    'filemanager__x_perm_dir' => "遍歷目錄",
    'filemanager__x_perm_file' => "執行檔",
    'filemanager__max_image_size_exceeded' => '無法顯示圖像。圖像大小不能大於 %2 位元組',

    '__fastcgi_unix_support' => 'FastCGI 支援',

    'ts_sessions_list' => '此頁面顯示了 終端服務 會話清單。',
    'b_tssessionslist_search' => '按名稱搜尋會話。',
    'b_tssessionslist_show_all' => '顯示所有終端服務會話。',
    'l_tssessionslist_state' => '按狀態進行排序。',
    'l_tssessionslist_name' => '按名稱進行排序。',
    'l_tssessionslist_user' => '按用戶進行排序。',
    'b_tssessionslist_logoff' => '按一下登出所選會話。',
    'b_tssessionslist_disconnect' => '按一下斷開連接所選會話。',
    'tssessions_info' => '查看會話屬性。',
    'tssessions_disconnect' => '選中確認刪除核取方塊，然後按一下“確定”斷開連接所選的終端伺服器會話。',
    'tssessions_logoff' => '選擇確認刪除選項框並按一下確定退出選中的終端伺服器會話。',
    'b_tssession_disconnect_submit' => '按一下提交更改。',
    'b_tssession_logoff' => '按一下登出會話。',
    'b_tssession_logoff_submit' => '按一下提交更改。',
    'i_tssession_active' => '活動',
    'i_tssession_connected' => '已連接',
    'i_tssession_disconnected' => '已斷開連接',
    'i_tssession_listen' => '監聽',
    'tssessions__tssessionslist' => '會話',
    'tssessionslist__state' => 'S',
    'tssessionslist__name' => '名稱',
    'tssessionslist__user' => '用戶',
    'bt_logoff_selected' => '登出',
    'bt_logoff' => "登出",
    'bt_disconnect_selected' => '斷開連接',
    'bt_tssession_logoff' => '登出',
    'bt_tssession_disconnect' => '斷開連接',
    'bt_tssession_disconect' => '斷開連接',
    'b_tssession_disconnect' => '按一下斷開連接會話。',
    'b_tssession_logoff_disabled' => '無法登出該會話。',
    'b_tssession_disconnect_disabled' => '無法斷開連接該會話。',
    'tssessions_info__title' => '會話 %1 屬性',
    'tssessions_info__property_name' => '屬性名',
    'tssessions_info__property_value' => '屬性值',
    'tssessions__disconnect_title' => '將斷開連接下列終端服務會話：',
    'tssessions__session_cant_disconnect' => '無法斷開連接會話',
    'tssessions__logoff_title' => '下列終端伺服器會話將被登出：',
    'tssessions__session_cant_logoff' => '不能登出會話',
    'tssessions__select_sessions_to_logoff' => '請選擇要登出的會話。',
    'tssessions__select_sessions_to_disconnect' => '請選擇要斷開連接的會話。',
    'dns__subdomain_dns_zone_parent' => '此子域名的 DNS 區域存儲于父 DNS 區域中。您可修改父區域 %1 或為該子域名單獨創建一個區域。',
    'dns__subdomain_dns_zone_parent_link' => '此處',
    'dns__no_dns_zone' => '未通過域分配 DNS 區域。要管理域的 DNS 區域您應按下 \'恢復預設\' 按鈕。',
    'dns__unable_turn_on_subdomain_zone' => '無法打開子域名的區域因為在該子域名的父級域名區域中存在該子域名的 CNAME 記錄。',

    '__hosting_write_modify' => '其他寫入/修改許可權',


    'aspdotnet__title' => "ASP.NET 配置",
    'aspdotnet__dom_title' => "網站的ASP.NET配置",
    'aspdotnet__wdir_title' => "虛擬目錄 %1 的 ASP.NET 配置",
    'aspdotnet__group_cas_settings' => "代碼存取安全性",
    'aspdotnet__group_client_scripts' => "腳本庫設定",
    'aspdotnet__group_conn_strings' => "連接字串管理器",
    'aspdotnet__group_custom_errors' => "自訂錯誤設定",
    'aspdotnet__group_framework_version' => "Framework 版本",
    'aspdotnet__group_globalization' => "全域設定",
    'aspdotnet__group_other' => "會話設定",
    'aspdotnet__group_page_and_runtime' => "編譯和調試",
    'aspdotnet__invalid_dom_config_file' => "此網站的 ASP.NET 設定檔已損壞。要恢復該檔，請點按 設定為預設值 來應用伺服器默認的 ASP.NET 配置。",
    'aspdotnet__invalid_file_enc' => "無效的檔編碼參數值。",
    'aspdotnet__invalid_req_enc' => "無效的請求編碼參數值。",
    'aspdotnet__invalid_res_enc' => "無效的回應編碼參數值。",
    'aspdotnet__invalid_parent_wdir_config_file' => "ASP.NET 設定檔已損壞，因 %1 父目錄的 ASP.NET 配置已損壞。\n若要解決此問題，請恢復 %1 ASP.NET 配置。",
    'aspdotnet__invalid_global_config_file_admin' => "ASP.NET配置已損壞，因伺服器的ASP.NET設定檔已損壞。",
    'aspdotnet__invalid_global_config_file' => "ASP.NET配置已損壞，因伺服器的ASP.NET設定檔已損壞。有關支援資訊，請聯繫服務商尋求協助。",
    'aspdotnet__invalid_sess_timeout' => "無效的會話超時參數值。請輸入一個不大於 %1 的正整數。",
    'aspdotnet__invalid_wdir_config_file' => "此虛擬目錄的 ASP.NET 設定檔已損壞。若要恢復此設定檔，請按一下“設定為預設值”以應用父級虛擬目錄的 ASP.NET 配置。",
    'aspdotnet__param_auth_mode' => "驗證模式",
    'aspdotnet__param_conn_strings' => "連接字串",
    'aspdotnet__param_conn_string_name' => "名稱",
    'aspdotnet__param_conn_string_value' => "連接參數",
    'aspdotnet__param_culture' => "區域性",
    'aspdotnet__param_custom_err_mode' => "自訂錯誤模式",
    'aspdotnet__param_custom_error_redirect' => "重定向 URL",
    'aspdotnet__param_custom_error_status' => "狀態碼",
    'aspdotnet__param_custom_errors' => "自訂錯誤",
    'aspdotnet__param_debug_mode' => "啟用調試",
    'aspdotnet__param_def_language' => "網頁預設語言",
    'aspdotnet__param_temp_directory' => "臨時目錄",
    'aspdotnet__param_file_enc' => "檔編碼",
    'aspdotnet__param_req_enc' => "請求編碼",
    'aspdotnet__param_res_enc' => "回應編碼",
    'aspdotnet__param_sess_timeout' => "會話超時(分鐘)",
    'aspdotnet__param_trust_level' => "代碼存取安全性 (CAS) 信任級別",
    'aspdotnet__param_ui_culture' => "UI 區域性",
    'aspdotnet__param_version' => "版本",
    'aspdotnet__param_trust_level_allow_override' => '允許覆蓋網站上的代碼存取安全性 (CAS) 信任級別',
    'aspdotnet__restore_default_confirm' => "恢復默認的 ASP.NET 配置嗎？",

    'bt_restore_default' => "重置",
    'b_aspdotnet' => '編輯 ASP.NET 配置。',
    'b_aspdotnet__restore_default' => '恢復默認的 ASP.NET 設定。',
    'b_aspdotnet__restore_wdir_default' => "恢復此虛擬目錄的父級目錄 ASP.NET 設定。",
    'b_aspdotnet__restore_default_disabled' => '無法恢復默認ASP.NET配置: 伺服器或某個父級目錄中的ASP.NET配置已損壞。',
    'b_autoinstaller' => '更新 Plesk 或其組件。',
    'b_autoinstaller_configure' => '更新設定。',
    'b_autoinstaller_install' => '安裝所選組件。',

    '__iis_app_pool__use_dedicated' => '獨立IIS應用程式池',
    '__iis_app_pool__use_dedicated_addons' => '每個網站使用獨立 IIS 應用程式池',
    '__iis_app_pool__enable_32bit_app_on_win64' => '啟用 32 位元應用程式',
    'bt_iis_app_pool' => "IIS 應用程式池",

    'performance__cpu_usage' => '最大 CPU 使用率(%)',
    'performance__cpu_usage_action' => '限制操作',
    'performance__cpu_usage_interval' => '間隔設限（分鐘）',
    'performance__cpu_usage_action_not_supported' => 'web 伺服器不支援指定的操作。',

    'performance__idle_timeout_action_not_supported' => 'web 伺服器不支援指定的閒置超時操作。',
    'performance__max_worker_processes' => 'worker 進程的最大數量',
    'performance__idle_timeout' => '閒置超時 (分鐘)',
    'performance__idle_timeout_action' => '閒置超時操作',
    'performance__recycling_by_time' => '定時回收（分鐘）',
    'performance__recycling_by_requests' => '當達到請求最大數量時回收',
    'performance__recycling_by_virtual_memory' => '當已使用虛擬記憶體最大容量時回收',
    'performance__recycling_by_private_memory' => '當已使用獨立記憶體最大容量時回收',
    'performance__managed_pipeline_mode' => '託管管道模式',
    'performance__managed_pipeline_mode_not_supported' => 'web 伺服器不支援指定的模式。',

    'iis_app_pool' => 'IIS 應用程式池管理。',
    'b_iis_app_pool' => '管理 IIS 應用程式池。',
    'iis_app_pool_cl_dom' => 'IIS 應用程式池管理',

    'i_webdirs_not_protected' => '目錄未受保護。',
    'i_webdirs_protected' => '目錄受保護。',
    'i_webdirs_manage_protection' => '管理保護。',
    'i_webdirs_open' => '在瀏覽器中打開目錄/檔。',
    'i_webdirs_preferences_disabled' => '它不是虛擬目錄。',
    'i_webdirs_permissions' => '管理許可權。',
    'i_webdirs_permissions_disabled' => '目錄許可權管理不可用。',
    'i_webdirs_type_dir' => '物理目錄',
    'i_webdirs_type_vdir' => '虛擬目錄',
    'i_webdirs_browse' => '流覽目錄內容。',
    'i_webdirs_preferences' => '網站目錄設定管理。',

    'l_webdirslist_type' => '按類型對目錄進行排序。',
    'l_webdirslist_protected' => '按保護狀態對目錄進行排序。',
    'l_webdirslist_name' => '按名稱對目錄進行排序。',

    'b_webdirslist_remove' => '刪除所選虛擬目錄。',
    'b_webdirslist_search' => '輸入搜尋模式，然後按一下查找虛擬目錄。',
    'b_webdirslist_show_all' => '顯示所有目錄。',

    'l_webdirerrordocslist_code' => '按錯誤號對錯誤文檔進行排序。',
    'l_webdirerrordocslist_name' => '按描述對錯誤文檔進行排序。',
    'l_webdirerrordocslist_type' => '按類型對錯誤文檔進行排序。',
    'l_webdirerrordocslist_location' => '按位置對錯誤文檔進行排序。',

    'b_webdirerrordocslist_search' => '輸入搜尋模式，然後按一下查找錯誤文檔。',
    'b_webdirerrordocslist_remove' => '刪除所選的錯誤文檔。',
    'b_webdirerrordocslist_show_all' => '顯示所有錯誤文檔。',

    'l_webdirmimetypeslist_name' => '按擴展名對 MIME 類型進行排序。',
    'l_webdirmimetypeslist_content' => '按內容對 MIME 類型進行排序。',

    'b_webdirmimetypeslist_remove' => '刪除所選的 MIME 類型。',
    'b_webdirmimetypeslist_search' => '輸入搜尋模式並點按查找 MIME 類型。',
    'b_webdirmimetypeslist_show_all' => '顯示所有 MIME 類型。',

    'b_webdir_preferences' => "虛擬目錄設定。",
    'b_webdir_permissions' => "虛擬目錄許可權。",
    'b_webdir_permissions_disabled' => "虛擬目錄許可權管理不可用。",
    'b_to_webdirs' => '返回管理目錄。',
    'b_to_webdir_mime_types' => '返回管理MIME類型。',
    'b_to_webdir_error_docs' => '返回管理錯誤頁。',
    'b_to_webdir_protection' => '返回管理虛擬目錄保護。',

    'webdirs__title' => '虛擬目錄%1',
    'webdirs__preferences_title' => '虛擬目錄設定',
    'webdirs__list_legend' => '虛擬目錄',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => '名稱',
    'webdirs__list_header' => '%1項目',
    'webdirs__tabs_general' => '常規',
    'webdirs__tabs_mime_types' => 'MIME 類型',
    'webdirs__tabs_error_docs' => '錯誤文檔',

    'webdirs__tabs_permissions' => '許可權',
    'webdir__remove_vdirs' => '下列虛擬目錄將被刪除:',
    'webdir__remove_mime_types' => '下列 MIME 類型將被刪除：',
    'webdir__mime_types_title' => 'MIME 類型',
    'webdir__protection_disable_confirm' => '真的想刪除目錄保護嗎？',
    'webdir__protect_title' => '受保護 URL 用戶',
    'webdirs__permissions_title' => '虛擬目錄許可權',
    'webdirs__browse_content_permission_denied' => '您不具有流覽此目錄內容的許可權。',
    'error_doc__list_code' => '錯誤',
    'error_doc__list_code_description' => '描述',
    'error_doc__list_type' => '類型',
    'error_doc__list_location' => '位置',
    'error_doc__code' => '錯誤',
    'error_doc__type' => '類型',
    'error_doc__type_file' => '文件',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => '位置',
    'error_doc__legend' => '錯誤文檔',
    'error_doc__edit_title' => '編輯錯誤文檔',
    'error_doc_erorr_invalid_url_location' => '該 URL 無效。請指定正確的 URL。',
    'error_doc_erorr_invalid_file_location' => '該檔路徑無效。請指定正確的檔路徑。',
    'error_doc__type_default' => '默認',

    'webdirs__tabs_protection' => '保護',
    'pb_webdirs' => '虛擬目錄',

    'webdirs_remove_title' => '下列虛擬目錄將被刪除:',
    'webdirs_mime_types_remove_title' => '下列 MIME 類型將被刪除：',
    'webdirs_preferences_title' => '虛擬目錄設定',
    'webdirs_permissions_title' => '文件和資料夾特定許可權',
    'webdi_protection_disable_confirm' => '您確定要刪除虛擬目錄保護嗎？此操作也會刪除所有受保護的目錄使用者和目錄保護設定。',
    'bt_protect' => '保護',
    'bt_unprotect' => '取消保護',
    'bt_show_additional_users' => '顯示更多使用者',
    'bt_hide_additional_users' => '顯示更少使用者',
    'error_doc__list_title' => '錯誤文檔',
    'error_doc__list_header' => '錯誤文檔',
    'error_doc__code_400' => '錯誤的請求',
    'error_doc__code_401' => '未經授權',
    'error_doc__code_401.1' => '未經授權 - 登入失敗',
    'error_doc__code_401.2' => '未經授權 - 由於伺服器配置導致登入失敗',
    'error_doc__code_401.3' => '未經授權 - 由於資源 ACL 導致無法授權',
    'error_doc__code_401.4' => '未經授權 - 由於篩檢程式導致授權失敗',
    'error_doc__code_401.5' => '未經授權 - 由於 ISAPI/CGI 應用程式導致授權失敗',
    'error_doc__code_401.7' => '未經授權 - 由於URL授權策略被拒絕',
    'error_doc__code_403' => '禁止',
    'error_doc__code_403.1' => '禁止 - 執行存取執行',
    'error_doc__code_403.2' => '禁止 - 讀存取被拒絕',
    'error_doc__code_403.3' => '禁止 - 寫存取被拒絕',
    'error_doc__code_403.4' => '禁止 - 需要 SSL',
    'error_doc__code_403.5' => '禁止 - 需要SSL 128',
    'error_doc__code_403.6' => '禁止 - IP 地址被拒絕',
    'error_doc__code_403.7' => '禁止 - 需要客戶證書',
    'error_doc__code_403.8' => '禁止 - 存取網站被拒絕',
    'error_doc__code_403.9' => '禁止 - 用戶太多',
    'error_doc__code_403.10' => '禁止 - 無效配置',
    'error_doc__code_403.11' => '禁止 - 密碼更改',
    'error_doc__code_403.12' => '禁止 - Mapper存取被拒絕',
    'error_doc__code_403.13' => '禁止 - 客戶證書已被吊銷',
    'error_doc__code_403.14' => '禁止 - 列出目錄被拒絕',
    'error_doc__code_403.15' => '禁止 - 超出客戶存取許可權',
    'error_doc__code_403.16' => '禁止 - 客戶證書不被信任或格式錯誤',
    'error_doc__code_403.17' => '禁止 - 客戶證書已到期或無效',
    'error_doc__code_403.18' => '禁止 - 不能執行此應用程式池的請求',
    'error_doc__code_403.19' => '禁止 - CGI存取被拒絕',
    'error_doc__code_403.20' => '禁止 -  Passport 登入失敗',
    'error_doc__code_404' => '未找到',
    'error_doc__code_404.2' => '未找到 - 由於鎖定策略而被拒絕',
    'error_doc__code_404.3' => '未找到 - 由於 MIMEMAP策略而被拒絕',
    'error_doc__code_405' => '方法不被允許',
    'error_doc__code_406' => '不接受',
    'error_doc__code_407' => '必要的代理驗證',
    'error_doc__code_412' => '先決條件錯誤',
    'error_doc__code_414' => '請求URI太長',
    'error_doc__code_415' => '不支援的媒體類型',
    'error_doc__code_500' => '內部伺服器錯誤',
    'error_doc__code_500.12' => '內部伺服器錯誤 - 應用程式正在重啟',
    'error_doc__code_500.13' => '內部伺服器錯誤 - 伺服器太忙',
    'error_doc__code_500.15' => '內部伺服器錯誤 - 禁止直接請求GLOBAL.ASA',
    'error_doc__code_500.16' => '內部伺服器錯誤 - UNC存取錯誤',
    'error_doc__code_500.17' => '內部伺服器錯誤 - 未找到URL授權存儲',
    'error_doc__code_500.18' => '內部伺服器錯誤 - 無法打開URL授權存儲',
    'error_doc__code_500.19' => '內部伺服器錯誤 - 中繼資料檔損壞',
    'error_doc__code_500.100' => '內部伺服器錯誤 - ASP錯誤',
    'error_doc__code_501' => '未執行',
    'error_doc__code_502' => '閘道錯誤',
    'error_doc__code_503' => '服務暫時不能使用',

    'mimetype__extension' => '擴展名',
    'mimetype__content' => '內容',
    'mimetypeslist__title' => 'MIME 類型',
    'mimetypes__title' => 'MIME 類型',
    'mimetypes__select_to_remove' => '選擇要移除的 MIME 類型。',
    'mimetypes__select_for_remove' => "選擇要刪除的 MIME 類型。",
    'mimetypes_remove__title' => '刪除 MIMI 類型。',
    'mimetype__legend' => 'MIME 類型',
    'mimetype_edit__title' => '編輯 MIME 類型',
    'mimetype_edit__already_exists' => '已經為此擴展名定義了 MIME 類型。',
    'mimetype_edit__not_exists' => 'MIME 類型不存在。',
    'mimetype__content_type_other' => '自訂',

    'b_webdir_protection_enable' => '設定與有密碼保護的目錄相對應的 URL。',
    'b_webdir_protection_disable' => '指定所有人都可以存取目錄對應的URL。',
    'b_webdir_protection_disabled' => '虛擬目錄保護已禁用。',

    'b_pd_usr_create' => '按一下創建此受保護 URL 用戶。',
    'php__changeversion_title' => "選擇PHP版本",
    'php__group_php_version' => "PHP版本",

    'virtualdir__name' => '名稱',
    'virtualdir__path' => '路徑',
    'virtualdir__read' => '讀取許可權',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => '寫入許可權',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => '腳本源存取',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => '目錄流覽',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => '執行許可權',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => '日誌存取',
    'virtualdir__app_create' => '創建應用程式',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => '啟用匿名驗證。',
    'virtualdir__auth_windows' => '啟用 Windows 驗證。',
    'virtualdir__auth_not_enabled' => '必須啟用匿名或 Windows 驗證。',
    'virtualdir__require_ssl' => '需要 SSL/TLS',
    'virtualdir__enable_default_doc' => '使用默認文檔',
    'virtualdir__default_doc' => '預設文檔搜尋順序',
    'virtualdir__enable_parent_paths' => '允許使用父路徑',
    'virtualdir__execute_in_mta' => '允許應用程式在MTA(多執行緒單元)模式下運行',
    'virtualdir_create__title' => '在 %1 中創建虛擬目錄',
    'virtualdir_edit__title' => '虛擬目錄 %1 的屬性',
    'virtualdir_edit__legend' => '虛擬目錄',
    'virtualdir_edit__application_legend' => '應用程式設定',
    'virtualdir_edit__security_legend' => '目錄安全性',
    'virtualdir_edit__documents_legend' => '文檔',
    'virtualdir_edit__list_legend' => '嵌套的虛擬目錄',
    'virtualdir_error__path_not_in__' => '指定的路徑無效',
    'virtualdir_error__already_exists' => '相同名稱的目錄已經存在。',
    'virtualdir_root' => '虛擬目錄',
    'virtualdir_root__title' => '虛擬目錄',
    'virtualdir_root__list_legend' => '虛擬目錄',
    'virtualdir_se__none' => '無',
    'virtualdir_se__script' => '僅腳本',
    'virtualdir_se__script_execute' => '腳本和可執行檔',
    'virtualdirs__title' => '虛擬目錄',
    'virtualdirs__path_not_exists' => '無效路徑。',
    'virtualdirs__select_for_remove' => "選擇要刪除的虛擬目錄。",
    'virtualdirs_remove__title' => '刪除虛擬目錄',
    'virtualdirs_phys_dir_exist' => '相同名稱的物理目錄已經存在。如果繼續，此目錄將變成不可存取。您想要繼續嗎？',
    'virtualdir_auto_create_dir' => "創建與虛擬目錄名稱相同的物理目錄",

    'asp_max_default_text' => '由主目錄定義(%1 KB)',
    'asp_max_default_text_site' => '由IIS定義(%1 KB)',
    'asp_max_buffer_text' =>'ASP最大緩衝大小(KB)',
    'asp_max_body_text' => 'ASP請求郵件正文的最大容量 (KB)',
    'asp_buffers_legend' =>'ASP設定',

    'asp_debug_default_text' =>'由主目錄定義',
    'asp_debug_default_text_site' =>'由IIS定義',
    'asp_client_debug_text' =>'啟用 ASP 用戶端腳本調試',
    'asp_server_debug_text' =>'啟用 ASP 伺服器端腳本調試',

    'webdirs__list_with_broken_dirs' => "有連結到不存在的物理資料夾虛擬目錄。",
    'webdirs__vdir_physical_path_not_exist' => "該虛擬目錄連結到不存在的物理資料夾。",
    'webdirs__physical_path_not_exist' => "指定的路徑不存在。",

    'filemanager__new_dir_title' => '創建目錄',
    'php__configuration_title' => "PHP配置",

    'permissions__title' => '設定存取權限',
    'permissions__title_advanced' => '設定高級存取權限',
    'permissions__inherit_from_parent' => '允許來自父級的可繼承權限傳播到此對象和所有子對象。包括此處明確定義的項目。',
    'permissions__replace_on_children' => '將所有子對象的許可權項替換為此處顯示的許可權項。',
    'permissions__group_or_user_name' => '組名或用戶名',
    'permissions__Permissions_for' => '許可權主體',
    'permissions__allow' => '允許',
    'permissions__deny' => '拒絕',
    'permissions__FullControl' => '完全控制',
    'permissions__Modify' => '修改',
    'permissions__ReadAndExecute' => '讀取和執行',
    'permissions__ListFolderContents' => '列出資料夾內容',
    'permissions__Read' => '讀取',
    'permissions__Write' => '寫入',
    'permissions__ReadControl' => '讀取控制',
    'permissions__WriteControl' => '寫入控制',
    'permissions__ExecuteControl' => '執行控制',
    'permissions__TraverseFolderOrExecuteFile' => '遍歷資料夾 / 執行檔',
    'permissions__ListFolderOrRead' => '列出資料夾 / 讀取數據',
    'permissions__CreateFilesOrWrite' => '創建檔 / 寫入資料',
    'permissions__CreateFoldersOrAppend' => '創建檔 / 附加資料',
    'permissions__DeleteSubfoldersandFiles' => '刪除子資料夾和檔',
    'permissions__Delete' => '刪除',
    'permissions__ChangePermissions' => '更改許可權',
    'permissions__TakeOwnership' => '獲取所有權',
    'permissions__inherited_from' => '繼承自',
    'permissions__not_inherited' => '<尚未繼承>',
    'permissions__apply_to' => '應用到',
    'permissions__apply_onto' => '應用到:',
    'permissions__apply_onto1' => '僅此資料夾',
    'permissions__apply_onto2' => '僅子資料夾',
    'permissions__apply_onto3' => '此資料夾和子資料夾',
    'permissions__apply_onto4' => '僅文件',
    'permissions__apply_onto5' => '此資料夾和文件',
    'permissions__apply_onto6' => '僅子資料夾和文件',
    'permissions__apply_onto7' => '此資料夾、子資料夾和文件',

    'filemanager__not_allowed_dir' => "您不能更改此資料夾的許可權。",

    'filemanager__allow' => "允許",
    'filemanager__deny' => "拒絕",
    'filemanager__user_domusr' => '網站管理員',
    'filemanager__user_webusr' => '網站用戶',
    'filemanager__user_admins' => '管理員',
    'filemanager__user_system' => '系統',
    'filemanager__user_aspnet' => 'ASP.NET 用戶',
    'filemanager__user_poolusr' => '應用程式池使用者',
    'filemanager__user_sysaccount' => '其他系統使用者',

    'bt_permissions_advanced' => '高級',
    'b_permissions_advanced' => '按一下查看和設定特定許可權。',

    'b_hotlinkprotection' => '為網站設定盜鏈防護。',
    'b_hotlinkprotection_on' => '啟用網站內容的盜鏈防護功能。',
    'b_hotlinkprotection_off' => '禁用網站內容的盜鏈防護功能。',

    'bt_hotlinkprotection' => '盜鏈防護',
    'hotlinkprotection__title' =>'盜鏈防護',
    'hotlinkprotection__friend_domains' => '友好網站地址',
    'hotlinkprotection__extensions' => '受保護的檔副檔名',

    'hotlinkprotection_invalid_friend_domains' => '無效的友好域名',
    'hotlinkprotection_invalid_extensions' => '檔副檔名包含錯誤字元',

    'i_domain_alias_status_on' => '域名別名已啟用。',
    'i_domain_alias_status_off' => '域名別名已禁用。',
    'i_domain_alias_status_with_parent' => '域名別名已禁用，因為該域名已關閉。',
    'i_domain_alias_turn_off' => '按一下以禁用。',
    'i_domain_alias_turn_on' => '按一下以啟用。',
    'i_domain_alias_mail_on' => '已啟用了該域名別名的郵件服務。',
    'i_domain_alias_mail_off' => '已禁用了該域名別名的郵件服務。',
    'i_domain_alias_mail_with_parent' => '域名別名已禁用，因為該域名已關閉。',
    'i_domain_alias_web_on' => '已啟用了該域名別名的Web服務。',
    'i_domain_alias_web_off' => '已禁用了該域名別名的Web服務。',
    'i_domain_alias_web_with_parent' => 'Web服務已禁用，因為該域名已關閉。',
    'i_domain_alias_dns_on' => '為此域名別名打開了 DNS 別名服務。',
    'i_domain_alias_dns_off' => '為此域名別名關閉了 DNS 別名服務。',
    'i_domain_alias_dns_with_parent' => '因域名別名已停用，從而無法對 DNS 和主域名進行同步。',
    'i_domain_alias_seoRedirect_on' => '為此域名別名打開了使用 HTTP 301 代碼的重定向。',
    'i_domain_alias_seoRedirect_off' => '此域名別名關閉了使用 HTTP 301 代碼的重定向',
    'i_domain_alias_seoRedirect_with_parent' => '關閉了使用 HTTP 301 代碼的重定向因為關閉了域名別名。',

    'domain_alias__control_title' => '域名別名%1',
    'domain_alias__control_info_legend' => '信息',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => '服務名稱',
    'domain_alias__control_details_title' => '詳情',

    'domain_alias__invalid_values' => '您指定的域名無效。域名可由字母、數位元元和連字號組成。點號之間的每部分域名不得長於 63 個字元。',
    'domain_alias__domain_already_exists' => "域名別名 %1 不正確的名稱。已經存在域名 %1。",
    'domain_alias__www_prefix_domain_already_exists' => "域名別名 www.%1 不正確的名稱。已為域名 %1 創建了該別名。",
    'domain_alias__webmail_enabled_domain_already_exists' => '域名別名 web 郵箱的名稱不正確。%1。已經為域名 %1 創建了該別名。',
    'domain_alias__lists_enabled_domain_already_exists' => '域名別名列表的名稱不正確。%1。已經為域名 %1 創建了該別名。',
    'domain_alias__dns_record_already_exists' => '無法設定域名別名 %1 因為指向主機 %1 的 DNS 記錄已存在。',
    'domain_alias__domain_alias_already_exists' => "相同名稱的域名別名已經存在。",
    'domain_aliases__mail_server_not_support_aliases' => '郵件伺服器不支援域名別名功能。域名別名可能無法正常運行。',
    'domain_alias__restrict_domain_creation' => '伺服器級的策略禁止為域名別名指定名稱。如果該域名別名屬於您，請聯繫您的主機提供商。',
    'domain_alias__restrict_creation_with_www' => '請輸入沒有帶 \'www\' 首碼的域名。域名的 www 首碼將會自動被添加到 web 伺服器配置。',
    'domain_unable_to_set_name' => '不正確的名稱 %1。',

    'domain_alias__domain_service_dns_disabled' => '該域名由其它的 DNS 伺服器管理。',
    'domain_alias__domain_service_dns_enabled_master' => '該 DNS 伺服器作為其 DNS 區域的主域名伺服器。',
    'domain_alias__domain_service_dns_enabled_slave' => '該 DNS 伺服器作為其 DNS 區域的從屬域名伺服器。',
    'domain_alias__domain_service_mail_enabled' => '已為該域名啟用郵件服務。',
    'domain_alias__domain_service_mail_disabled' => '已為該域名關閉了郵件服務。',
    'domain_alias__domain_service_mail_mx' => '%1 用作郵件伺服器。',

    'domain_alias__service_seoRedirect_hint' => '當訪客打開別名的 URL，他們將會被重定向至主域的 URL。Plesk 會使用搜尋引擎友好 HTTP 301 重定向，這表示搜尋引擎排名將不會在兩個 URL 之間分割。',

    'bt_task_run_now' => '立即運行',
    'ftp__read_perm' => "讀取許可權",
    'ftp__write_perm' => "寫入許可權",

    'filemanager__upload_backup_file_hint' => '在此處您可上傳備份檔案到 Plesk 存儲。最大檔容量限於 2 GB。',

    'additional_key__used' => '已啟動',

    '__default_for_mssql' => 'MS SQL 默認使用',

    '__login_does_not_pass_validation' => "該用戶名無效。請確定用戶名符合以下要求：%1",
    '__login_allowed_symbols' => '只允許使用包括點號、破折號與底線的字母數位元元字元。首字元應為字母數位元元。',

    'restart__nginx' => '反向代理伺服器（nginx）',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "我願意接收來自 Plesk 的常規產品資訊和公告。",
    'admin_ed__i_would_like_recieve_tech_announce' => "我願意接收來自 Plesk 與安全有關的資訊與其他技術通知。",

    'server_preferences__webdeploy_include_password' => '將使用者的密碼包含到帶有 Web Deploy 發佈設定的檔中。',

    '__login_status_inactive' => '您的帳戶處於未啟動狀態。請聯繫 Plesk 管理員。',

    'migration__task_keep_in_process' => '確定',
    'migration__task_keep_in_process_conhelp' => '返回 工具與設定 頁面。遷移將在後臺中繼續進行。',

    'ui__admin-alias-info__description' => "編輯管理員其它帳戶的聯繫資訊。",
    'ui__admin-alias-info__short-title' => "聯繫資訊",
    'ui__admin-alias-info__title' => "管理員其它的帳號資訊",
    'ui__admin-alias-password__description' => "更改其它的管理員的密碼。",

    'ui__admin-alias-password__short-title' => "更改密碼",
    'ui__admin-alias-password__title' => "其它的管理員密碼",
    'ui__admin-alias__description' => "查看和更改其它的管理員帳號資訊。",

    'chk_js__warning_about_login_syntax' => "使用者名稱中可以包含小寫字母數字、破折號、點號和底線。此使用者名稱應以字母開頭。密碼不可以包含使用者名稱和引號。",
    'chk_js__warning_about_ftp_login_syntax' => "您可以在用戶名中使用字母、數位、短橫線和底線。",
    'chk_js__warning_about_login_syntax_win' => "用戶名中可以包含小寫字母數位、破折號、點號和底線。此用戶名應以字母或數位開頭。密碼不可以包含用戶名和引號。",
    'chk_js__warning_about_passwd_syntax' => "密碼中不得使用引號、空格和國家字母字元。\n密碼的長度需介於 %1 到 %2 個字元之間，且不得包含用戶名。",
    'chk_js__warning_about_plesk_login_syntax' => "您可以在用戶名中使用小寫字母數位、點、短橫線和底線符號。",
    'chk_js__warning_about_plesk_login_syntax_win' => "用戶名只能包含小寫字母、數位、短橫線和底線。用戶名應以字母開頭。",
    'chk_js__warning_about_plesk_passwd_syntax' => "密碼中不得使用引號、空格和國家字母字元。\n密碼長度應介於 %1 和 %2 個字元之間，且不得包含用戶名。",
    'chk_js__warning_about_pam_passwd_error' => "指定的系統使用者帳戶錯誤: %1",

    'cmd_server__admin_alias_not_found' => "無法找到其它管理員帳戶。",

    'panel_branding__skins_already_exists' => "注意主題 '%1' 已經存在。您當前正安裝的主題將會替換該主題。",
    'panel_branding__skins_file_exists' => "無法為主題 '%1' 創建目錄：相同名稱的檔已經存在。",

    'actionlog__login_failed' => '登入失敗',
    'actionlog__event_cp_user_login_failed' => 'Plesk 用戶無法登入',
    'actionlog__api_login_failed' => '通過 API 登入失敗',
    'actionlog__event_cp_user_api_login_failed' => '通過 API 登入失敗的 Plesk 用戶',
    'actionlog__pw_reset' => '請求的密碼重設',

    'ch_pass_by_secret__email_subject' => "Plesk 的密碼提示",
    'ch_pass_by_secret__email_body' => "您好 %2，\n\n如需設定新的密碼，請前往此連結：%1\n\n您的登入資料：%3",
    'ch_pass_by_secret__message_send_error' => '無法發送秘密代碼：%1',
    'ch_pass_by_secret__title' => '更改密碼',
    'ch_pass_by_secret__secret' => '秘密代碼',

    'custom_button__noframe' => "不要使用幀",

    'custom_button__internal_hint' => '指定是否在 Plesk 頁面上或新的瀏覽器視窗中打開 URL。',
    'custom_button__noframe_hint' => '若您添加一個自訂按鈕，通過該按鈕能夠進入客戶面板中的 Plesk 擴展或某個應用程式，則可以指定顯示該擴展/應用程式的方式：在幀中或作為 Plesk GUI 的一部分顯示。',


    'actionlog__patch' => '更新',
    'actionlog__patch_available' => '可用',
    'actionlog__event_patch_available' => '可用更新',
    'actionlog__patch_installed' => '已安裝',
    'actionlog__event_patch_installed' => '已安裝更新',

    'actionlog__extension' => '擴展',
    'actionlog__extension_status' => '擴展狀態',
    'actionlog__cloning' => '伺服器克隆',
    'actionlog__cloning_complete' => '完成',
    'actionlog__event_cloning_complete' => '伺服器克隆完成',

    'actionlog__ssl_web_binding' => '網域上的 SSL/TLS 憑證',
    'actionlog__ssl_web_binding_update' => '已簽署/未簽署',
    'actionlog__event_ssl_web_binding_update' => '網域上的 SSL/TLS 憑證已簽署/未簽署',

    'actionlog__ssl_web_mail_binding' => '網頁郵件上的 SSL/TLS 憑證',
    'actionlog__ssl_web_mail_binding_update' => '已簽署/未簽署',
    'actionlog__event_ssl_web_mail_binding_update' => '網頁郵件上的 SSL/TLS 憑證已簽署/未簽署',

    'actionlog__ssl_mail_binding' => '郵件伺服器上的 SSL/TLS 憑證',
    'actionlog__ssl_mail_binding_update' => '已簽署/未簽署',
    'actionlog__event_ssl_mail_binding_update' => '郵件伺服器上的 SSL/TLS 憑證已簽署/未簽署',

    'actionlog__ssl_panel_binding' => 'Plesk 上的 SSL/TLS 憑證',
    'actionlog__ssl_panel_binding_update' => '已簽署/未簽署',
    'actionlog__event_ssl_panel_binding_update' => 'Plesk 上的 SSL/TLS 憑證已簽署/未簽署',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => '所有（按域名）',

    'chk_js__warning_about_admin_passwd_syntax' => "請不要在密碼中使用引號、空格和國家字母字元。\n密碼長度應在%1到%2個字元之間，並且不能包含用戶名。",

    'passwordSecurityLevelCheckFailed' => '您的密碼不夠複雜。根據伺服器策略，密碼的最小強度需為 %1。若要提高密碼強度，可使用數位、大寫與小寫字母與如 !、@、#,$、%、^、&、*、?、_、~ 的特殊符號。',
    'passwordSecurityLevelCheckFailedVeryWeak' => '非常弱',
    'passwordSecurityLevelCheckFailedWeak' => '弱',
    'passwordSecurityLevelCheckFailedMediocre' => '中等',
    'passwordSecurityLevelCheckFailedStrong' => '強',
    'passwordSecurityLevelCheckFailedStronger' => '非常強',

    'cu__php_settings__command_update_all' => "根據伺服器級 php.ini 檔更新所有域名的每域名  PHP 設定。",
    'cu__php_settings__update_all_done' => "已經成功更新所有域名的每域名  PHP 設定。",

    'filemanager__invalid_path' => "指定的路徑無效",

    'rdp_app__msactivex_comment' => '我們建議您使用 Internet Explorer 因為 Microsoft RDP ActiveX 元件可能在其他瀏覽器中無法工作',

    'additional_key__descr_app' => '應用程式',
    'additional_keys__used_keys' => ', 使用的%1金鑰',
    'additional_key__descr_key_mailboxes' => '郵箱',

    'ui__client/domain/dns/sync__description' => '在該區域應用伺服器級 DNS 範本的修改。',
    'ui__client/domain/dns/sync__disabled-warning' => '無法應用 DNS 範本修改至該區域因為該區域由其它 DNS 伺服器服務。',
    'ui__client/domain/dns/sync__short-title' => '應用 DNS 範本修改',
    'ui__client/domain/dns/sync__done' => 'DNS 範本的修改已成功應用至該區域。',
    'ui__client/domain/domain-alias/dns/sync__description' => '應用伺服器級 DNS 範本的修改至該區域。',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => '無法應用 DNS 範本修改至該區域因為該區域由其它 DNS 伺服器服務。',
    'ui__client/domain/domain-alias/dns/sync__short-title' => '應用 DNS 範本修改',
    'ui__client/domain/domain-alias/dns/sync__done' => 'DNS 範本修改已成功應用至該區域。',
    'bt_dns_zone_sync' => '應用 DNS 範本修改',
    'b_dns_zone_sync' => '在現存的 DNS 區域中應用範本修改。',
    'dns__dns_zone_sync_form' => '應用 DNS 範本修改',
    'dns__dns_zone_sync_legend' => '選項',
    'dns__dns_zone_sync_ways' => '選擇以下當中的一項',
    'dns__dns_zone_sync_way_safe' => '應用更改到未修改區域。如果一個區域已進行過自訂修改（已添加新紀錄或已更改現存紀錄），Plesk 將不會應用對範本的修改至此類區域。',
    'dns__dns_zone_sync_way_forced' => '應用更改到所有區域。Plesk 將應用對範本的更改到所有的 DNS 區域，其中包括自訂的區域。注意使用者修改的記錄將保持原樣。例如，如果該範本包含了客戶已經添加的新紀錄，Plesk 將保持客戶的記錄。',
    'dns__dns_default_ipv4_modified' => '帶有此 IP 位址的記錄將被視為使用者修改的記錄，將不會與伺服器級的 DNS 範本同步。',
    'dns__dns_default_ipv6_modified' => '帶有此 IP 位址的記錄將被視為使用者修改的記錄，將不會與伺服器級的 DNS 範本同步。',

    'dns__view_dns_record_master_title' => '查看資源記錄',
    'dns__view_dns_record_off_title' => '查看域名伺服器記錄',
    'dns__view_dns_record_slave_title' => '查看主要的 DNS 伺服器記錄',

    'dns_unable_to_resolve_hostname' => "無法解析主機名稱 \"%1\"：%2\n請確保作業系統的 DNS 解析器得以正確設定且運行正常。",

    'no_database_server_available' => '沒有該訂閱可用的資料庫伺服器。',

    'database_server_edit_form__admin_add_hint' => "指定 Plesk 將用於存取資料庫伺服器的資料庫管理員驗證憑據。在資料庫伺服器上必須存在帶有這些驗證憑據的管理員帳戶。",
    'database_server_edit_form__admin_edit_hint' => "在此處您可以更改 Plesk 將用於存取資料庫伺服器的驗證憑據。這些驗證憑據必須匹配資料庫管理員的驗證憑據。例如，您在資料庫伺服器上更改了管理員驗證憑據後，有必要在 Plesk 中對其進行相應更改。",
    'database_server_edit_form__admin_change_hint' => '在此處您可以更改 Plesk 將用於存取資料庫伺服器的驗證憑據。如果您修改下面的用戶名和密碼，將會在資料庫伺服器上和 Plesk 中同時更新帶有管理許可權的資料庫使用者帳戶。',
    'database_server_edit_form__version' => '資料庫伺服器版本',
    'database_used_by_application_can_not_be_moved' => '無法移動資料庫：一個網站應用程式在使用該資料庫。',
    'database_server_database_list__subscription' => '訂閱',
    'database_server_database_list__webspace' => '訂閱',
    'bt_assign_subscription_selected' => '移動到訂閱',
    'bt_cp_login' => '在客戶面板中打開',
    'bt_cp_login_classic_mode' => '管理主機',
    'hint_cp_login' => '在訂戶的客戶面板中管理資料庫。',
    'hint_cp_admin_login' => '管理資料庫。',
    'hint_cp_login_classic_mode' => '管理資料庫。',
    'database_user_update_orphaned_is_restricted' => '禁止更新孤立資料庫使用者帳戶。您只能刪除或修復它們。',

    'database_unable_to_get_max_filesize_default_message' => '無法確定資料庫的檔大小最大值：\'%1\'',
    'database_unable_to_set_max_filesize_default_message' => '無法設定資料庫的檔大小最大值：\'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => '無法確定資料庫的日誌檔大小最大值：\'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => '無法設定資料庫的日誌檔大小最大值：\'%1\'',

    'database_unable_to_get_max_filesize' => '無法確定 Microsoft SQL 資料庫 \'%1\' 的檔大小的當前限制。不能設定新的限制。',
    'database_unable_to_set_max_filesize' => '無法為 Microsoft SQL 資料庫 \'%1\' 的檔大小設定限制。',
    'database_unable_to_get_max_log_filesize' => '無法確定 Microsoft SQL 資料庫 \'%1\' 的日誌檔大小的當前限制。不能設定新的限制。',
    'database_unable_to_set_max_log_filesize' => '無法為 Microsoft SQL 資料庫 \'%1\' 的日誌檔大小設定限制。',

    'database_unable_to_create_because_max_filesize' => '無法創建 Microsoft SQL 資料庫 \'%1\'：其檔大小超過了允許的最大值。',
    'database_unable_to_move_because_max_filesize' => '無法移動 Microsoft SQL 資料庫 \'%1\'：其檔大小超過了允許的最大值：%2.',
    'database_unable_to_create_because_max_log_filesize' => '無法創建 Microsoft SQL 資料庫 \'%1\'：其日誌檔大小超過了允許的最大值。',
    'database_unable_to_move_because_max_log_filesize' => '無法移動 Microsoft SQL 資料庫 \'%1\'：其日誌檔大小超過了允許的最大值：%2.',
    'database_unable_to_restore_because_max_filesize' => '無法恢復 Microsoft SQL 資料庫 \'%1\'：其檔大小超過了允許的最大值。',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Plesk 中已註冊了相同的 MS SQL 伺服器。請指定其它的 MS SQL 伺服器作為沙箱。',
    'database_server__mssql_server_registered_as_sandbox' => '在 Plesk 中已經註冊了一個相同的沙箱 MS SQL 伺服器。請指定其它的 MS SQL 伺服器作為沙箱。',

    'database_server_mysql_unable_to_connect_via_cli' => '無法通過\'%1\'連接伺服器：%2',

    'bu_conflict_resolver_feature_not_available' => '以下服務節點不支援功能 %1：%2。在這些節點上創建的所有對象都將禁用此功能。',
    'bu_conflict_resolver_feature_not_available_single_server' => '該伺服器不支援功能 %1：所有恢復的對象都將禁用此功能。',
    'bu_conflict_resolver_component_unavailable_in_sites' => '未安裝組件 %1。以下網站無法使用它：{{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => '未安裝組件 %1。對於以下網站，它將被 %2 替換：{{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => '當前的 Plesk 版本不支援帶有點號 (.) 字元的用戶名。將不會恢復帶有此類用戶名的客戶和代理商。',
    'bu_conflict_resolver_unable_to_find_backup_part' => '無法找到帶有 %1 %2 的資料的備份檔案。將不會恢復 %1 %2 的資料。',

    'bu_conflict_resolver_zone_master_removed' => "無法恢復 master DNS 記錄：從屬區域中的記錄指向現有的 IP 位址 %1。將會從 slave 區域中移除 master DNS 記錄。",

    'bu_conflict_resolver_not_available_scripting' => '不支援 %1。',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '不支援 %1。以下網站無法使用它：{{objects}}',
    'bu_conflict_resolver_not_available_component' => '未安裝組件 %1。',
    'bu_conflict_resolver_disabled_in_multi_server' => '以下服務節點無法使用它：{{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => '以下對象無法使用它：{{objects}}',
    'bu_conflict_resolver_not_available_db' => '在此伺服器上無法使用以下資料庫伺服器: %1。',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'MS SQL 資料庫備份檔案以 MS SQL 本地格式進行存儲，此格式的備份檔案只能恢復到本地 MS SQL 伺服器或到完全配置備份設定的遠端 MS SQL 伺服器。因為 Plesk 中沒有註冊相應的 MS SQL 伺服器導致一些資料庫未得以恢復。以下的域名受到影響：{{objects}}. 請聯繫您的主機提供商。',

    'bu_conflict_resolver_not_available_webmail' => '%1 web 郵箱服務不可用。對於以下對象，它將被 %2 替換：{{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => '%1 web 郵箱服務不可用。對於以下服務方案，它將被 %2 替換：{{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "'%1' 類型的資料庫不支援與資料庫名稱一致的用戶名。用戶 '%2' 將被重命名為 '%3' 用於資料庫 '%4'。",

    'bu_conflict_resolver_wrong_hard_quota_value' => '在目的伺服器配置中未設定磁碟空間使用限制。該設定的值將會更改為“無限”。',
    'bu_conflict_resolver_wrong_max_connections_value' => '在目的伺服器配置中未設定連接數量限制。該設定的值將會更改為“無限”。',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => '在目的伺服器配置中未設定流量使用限制。該設定的值將會更改為“無限”。',
    'cu__pleskrestore_backup_file_extracted' => '備份檔案摘取自 "%1"。',
    '__mod_bw_not_supported' => '因檔案系統的配置，不支援 Apache web 伺服器的 mod_bw 模組。流量使用和連接最大數量的限制無效。',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => '不支援郵件中繼使用 POP3 驗證，而在 SMTP 驗證之前將會使用 POP3。({{objects}})',
    'bu_conflict_resolver_service_plan_name' => '服務方案 \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '不支援 %1。對於以下服務方案，它將被 %2 替換：{{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '不支援 %1。對於以下網站，它將被 %2 替換：{{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => '未在備份檔案中找到以下對象：%1',
    'bu_conflict_resolver_absent_domains' => '無法恢復某些對象因為它們隸屬在 Plesk 中無法找到的以下域名：%1',
    'bu_conflict_resolver_absent_parent_domains' => "無法恢復某些網站因為它們隸屬在 Plesk 中無法找到的以下父級域名：\n%1",
    'bu_conflict_resolver_dns_not_supported' => '無法恢復 DNS 區域：在伺服器配置中已關閉 DNS 服務。',
    'bu_conflict_resolver_mail_not_supported' => '無法恢復郵箱：在伺服器配置中已關閉郵件服務。',
    'bu_conflict_resolver__idle_timeout_action_not_supported' => 'IIS web 伺服器不支援指定的閒置超時。該值將被重設為 %1。',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'IIS web 伺服器不支援指定的 CPU 限制操作。該值將被重設為 %1。',
    'bu_conflict_detector_server_ssl_cert_name' => '伺服器 SSL/TLS 證書 %1',
    'bu_conflict_detector_domain_ssl_cert_name' => '域名 %1 的 SSL/TLS 證書 %2',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS 證書 %1',
    'bu_conflict_resolver_absent_objects' => '無法恢復以下對象的內容因為這些對象無法在 Plesk 中找到：%1',
    'bu_conflict_resolver_absent_objects_mailuser' => '無法恢復以下郵箱的內容因為這些物件無法在 Plesk 中找到：%1',
    'bu_conflict_resolver_absent_objects_maillist' => '無法恢復以下郵寄清單的內容因為這些郵寄清單無法在 Plesk 中找到：%1',
    'bu_conflict_resolver_absent_objects_database' => '無法恢復以下資料庫的內容因為這些物件無法在 Plesk 中找到：%1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => '在 "%2" 上恢復應用程式 "%1" 失敗因為另一個應用程式已被安裝到 "%3"。您可以移除已安裝的應用程式然後再試。',
    'bu_conflict_resolver_not_available_mail_autoresponders' => '不支援郵件自動回復功能。',
    'bu_conflict_resolver_not_available_mail_content' => '不支援恢復郵件內容。',
    'bu_conflict_resolver_invalid_mail_name' => '下列郵箱未恢復，因為開啟了電子郵件子定址且某些電子郵箱位址包含符號 "%1"：%2',
    'bu_conflict_resolver_invalid_user_name' => '下列使用者未恢復，因為開啟了電子郵件子定址且某些電子郵箱位址包含符號 "%1"：%2',
    'expiration_unsupported' => "不支援'到期'限制。",

    'component_name__dbconnector' => "資料庫連接器",
    'component_name__mysqlserver' => 'MySQL 伺服器',
    'component_name__troubleshooting' => '故障排除',

    '__subscription_has_no_license_key' => '該訂閱資源由服務節點 #%1 提供（該服務節點沒有相關聯的許可證金鑰）。',
    '__subscription_has_expired_license_key' => '該訂閱資源由服務節點 #%1 提供（該服務節點的許可證金鑰 %2 已到期）。',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> 無法保存設定檔',
    '__cfgmonConfigurationFileSaveErrorBody' => "無法在主機 <%%host%%> 上保存一些設定檔： 出現以下錯誤：\n\n%%errors%%",

    'mail__allow_short_pop3_names' => "POP3/IMAP 郵件帳戶名",
    'mail__allow_short_pop3_names_disabled' => "只能使用 POP3/IMAP 郵件帳戶的全名",
    'mail__allow_short_pop3_names_enabled' => "可使用 POP3/IMAP 郵件帳戶的簡稱 (webmaster) 或全名 (webmaster@domain.com)。",
    'mail__baddomain_exists' => "此域名已在黑名單上了。",
    'mail__block_mail_from_doms' => "黑名單",
    'mail__blockers' => "受阻域名",
    'mail__blockers_remove' => "刪除受阻域名",
    'mail__blocker_add' => "將域名添加到黑名單",
    'mail__closed' => "關閉",
    'mail__crypted_passwd_match' => "存在與加密密碼匹配的郵件名。",
    'mail__enable_email_subaddressing' => '開啟電子郵件子定址',
    'mail__enable_email_subaddressing_hint' => '此選項會開啟為郵寄清單配置 %%verpStyleLink%% 電子郵箱位址的功能',
    'mail__enable_email_subaddressing_cli_desc' => '此選項會開啟為郵寄清單配置 VERP 式電子郵箱位址的功能',
    'mail__dom_in_list' => "此域名已在黑名單上了。",
    'mail__enable_rbl' => "關閉基於 DNS blackhole lists 的垃圾郵件防護措施",
    'mail__enter_rbl_server' => "鍵入 DNS 區域。",
    'mail__enter_right_ip_mask' => "輸入IP遮罩(在1到32之間)",
    'mail__enter_right_ip_mask_24' => "輸入IP遮罩(在24到32之間)",
    'mail__install_rblsmtpd_program' => "安裝 rblsmtp 軟體。",
    'mail__invalid_dom_name' => "域名 %1 無效。",
    'mail__invalid_pop_lock_time' => "POP3 鎖定時間無效。",
    'mail__invalid_rbl_server' => "DNS 區域名無效。",
    'mail__ip_and_mask' => "IP 地址/遮罩",
    'mail__ip_and_mask_exists' => "此 IP 位址/網路遮罩對已存在。",
    'mail__lock_time' => "鎖定時間",
    'mail__general_options' => '常規選項',
    'mail__relay_options' => '中繼選項',
    'mail__mailnames_passwd_match' => "存在匹配的郵件名和密碼對。",
    'mail__select_domains_for_remove' => "選擇要刪除的域名。",
    'mail__max_size' => "最大郵件大小",
    'mail__mbox_quota' => "郵箱配額",
    'mail__min' => "分鐘",
    'mail__total_files_size' => "總計庫大小：%1",
    'mail__filename_already_in_repository' => "repository 中已存在相同名稱的檔",
    'mail__no_white_list_mask_feature_24' => "使用遮罩值 24 或更高值。\n您的郵件伺服器不支援設定遮罩。我們只能模擬為值不小於 24 的設定遮罩。",
    'mail__open' => "打開",
    'mail__open_relay_warning' => "打開郵件中繼會使您的郵件伺服器暴露於垃圾郵件中。\n\n只有當您想暫時測試郵件伺服器或您的 Plesk 伺服器在內部網路中而不能通過互聯網進行存取時才能保留此設定。\n\n保留設定？",
    'mail__pop3' => "POP3優先SMTP",
    'mail__rbl_zones' => "DNSBL 服務的 DNS 區域",
    'mail__rbl_zones_hint' => "使用分號隔開項目，例如：'zen.spamhaus.org;dnsbl.example.net'",
    'mail__relay_from_ip' => "白名單",
    'mail__relaying' => "郵件中繼",
    'mail__reqr_auth' => "需要驗證：",
    'mail__smtp' => "SMTP",
    'mail__unable_add_new_mail_name' => "無法添加郵件帳戶：%1",
    'mail_server_is_not_installed' => '郵件伺服器 (Postfix 或 Qmail) 尚未安裝。將其安裝以繼續運行工作。',
    'mail_server_not_available' => '在服務節點上沒有支援的郵件伺服器。',
    '__not_installed' => '(尚未安裝)',
    'mail__server_name_label' => '安裝的郵件伺服器',
    'mail__imap_server_name_label' => '已安裝 IMAP/POP3 伺服器',
    'mail__server_change_hint' => '您可以 %%serverChangeLink%%',
    'mail__server_change_link' => '安裝並使用其它郵件伺服器',
    'mail__imap_server_change_link' => '安裝和使用其它 IMAP/POP3 伺服器',
    'mail__message_submission' => '啟用埠 587 上的 SMTP 服務',
    'mail__message_submission_on_all_ips' => '在所有 IP 地址上啟用埠 587 上的 SMTP 服務',
    'mail__message_submission_bind_to' => '打開',
    'mail__message_submission_all_ip_addresses' => '所有 IP 地址',
    'mail__service_node_outgoing_messages_is_disabled' => '禁用在傳出郵件資訊上進行垃圾郵件過濾。',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => '服務節點不支援限制域名 %1 的域名的傳出郵件資訊數量。',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => '服務節點不支援限制域名 %1 的郵箱的傳出郵件資訊數量。',
    'mail__max_outgoing_messages_enable_text' => '對外發電子郵件資訊開啟限制',
    'mail__max_outgoing_messages_enable_hint' => '以下限制是默認的。這些限制可在每個服務方案和訂閱中被覆蓋。此等限制不是伺服器範圍的，但是可作為未指定自訂限制的方案和訂閱的範本。注意對外發電子郵件資訊開啟限制可能會影響郵件伺服器的性能。',
    'mail__outgoing_messages_mbox_limit_text' => '發自一個郵箱的資訊預設限制（每小時）',
    'mail__outgoing_messages_domain_limit_text' => '發自一個域名的資訊預設限制（每小時）',
    'mail__outgoing_messages_subscription_limit_text' => '發自一個訂閱的資訊預設限制（每小時）',
    'mail__outgoing_messages_enable_sendmail_text' => '允許用戶和腳本使用 Sendmail',
    'mail__outgoing_messages_enable_sendmail_hint' => '即使在超過了郵箱和域名的限制的情況下腳本和使用者也將能夠使用  Sendmail 發送郵件資訊（代表訂閱的系統使用者）。可通過 Sendmail 發送的資訊最大數量將由整個訂閱的限制所定義。該設定不允許腳本在整個伺服器範圍使用 Sendmail，但是作為服務方案和訂閱的預設設定。',
    'mail__outgoing_messages_report_period_text' => '顯示基於上一次統計的報告',
    'mail__max_outgoing_messages_period_P1D' => '1 日',
    'mail__max_outgoing_messages_period_P1W' => '1 周',
    'mail__max_outgoing_messages_period_P2W' => '2 周',
    'mail__max_outgoing_messages_period_P1M' => '1 個月',
    'mail__outgoing_messages_report_period_hint' => '會創建報告，且會在首頁顯示有關在指定期限內嘗試超過郵件傳出限制的警告。',
    'mail__outgoing_messages_notification_period_text' => '發送郵件通知，每隔',
    'mail__max_outgoing_messages_period_PT15M' => '15 分鐘',
    'mail__max_outgoing_messages_period_PT1H' => '1 小時',
    'mail__max_outgoing_messages_period_PT6H' => '6 小時',
    'mail__max_outgoing_messages_period_PT12H' => '12 小時',
    'mail__outgoing_messages_notification_period_hint' => '該通知會提供有關在指定期限內嘗試超過郵件傳出限制的統計。',

    'mail__outgoing_email_mode_explicit_ip_none' => '無',
    'mail__outgoing_email_mode_explicit_ip_unspecified' => '至少指定一種類型的一個位址（IPv4 或 IPv6）。',

    'mail__max_connections_text_courier' => '連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量',
    'mail__max_connections_text_dovecot' => '連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量',
    'mail__max_connections_hint_courier' => '啟動的伺服器 (IMAP 或 POP3) 的最大數量。',
    'mail__max_connections_hint_dovecot' => '同時可登入的郵件用戶的最大數量。',

    'mail__max_connections_per_ip_text_courier' => '每個 IP 位址的連接的最大數量',
    'mail__max_connections_per_ip_text_dovecot' => '每個 IP 位址一個用戶可連接的最大數量。',
    'mail__max_connections_per_ip_hint_courier' => '接受來自同一 IP 位址的連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量。',
    'mail__max_connections_per_ip_hint_dovecot' => '允許郵件用戶接收來自每個 IP 位址的連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量。',

    'mail__outgoing_email_mode' => '傳出郵件模式',
    'mail__outgoing_email_mode_domain_ip' => '發自域名的 IP 地址',
    'mail__outgoing_email_mode_domain_name' => '發自域名的 IP 位址並在 SMTP 問候中使用域名',
    'mail__outgoing_email_mode_explicit_ip' => '發自指定的 IP 地址',
    'mail__outgoing_email_mode_explicit_ip_v4' => 'IPv4',
    'mail__outgoing_email_mode_explicit_ip_v6' => 'IPv6',
    'mail__outgoing_email_mode_invalid' => '指定的傳出郵件模式無效。',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => '指定的 IPv4 地址無效',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => '指定的 IPv6 地址無效',
    'mail__outgoing_email_mode_unavailable' => '不支援更改發送郵件模式，可能因為未在此伺服器上安裝 Postfix 郵件伺服器。',

    'mail__smtp_settings_change_hint' => '若要實現 Plesk 能夠在中繼關閉時發送通知，則可以 %%changeLink%%',
    'mail__smtp_settings_change_link' => '修改 SMTP 設定',

    'mail__autoresponder_attachment_not_supported' => '當前使用的郵件伺服器不支援自動回復附件管理。',

    'sfdk_server_wide_legend' => 'DKIM 垃圾郵件防護',
    'sfdk_server_wide_sign_text' => '允許給發件簽名',
    'sfdk_server_wide_verify_text' => '驗證傳入郵件',
    'sfdk_server_wide_verify_failed' => '無法更改 DKIM 驗證服務的設定',

    'sfdk_domain__serverwide_disabled' => '根據伺服器策略關閉',
    'feature__domainkeys__serverwide_disabled' => '伺服器級 DKIM 垃圾郵件防護被關閉',

    'defaultcomponents__error_set_default' => '無法設定 %1 作為默認的 %2',
    'defaultcomponents__required_package_not_default' => '工作所需的 %1 元件不是預設元件。',

    '__percentage' => '%',
    '__seconds' => '秒',
    '__resource_remain' => '重命名',

    '__not_registered' => '（未註冊）',
    '__php_handler_id' => 'PHP 版本',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP 處理常式 "%1" 未被註冊。它可能已被從伺服器刪除。使用相同的屬性註冊一個處理常式然後再試。',
    '__php_handler_not_registered_on_domain' => '域名 "%1"：PHP 處理常式 "%2" 未被註冊。它可能已被從伺服器刪除。使用相同的屬性註冊一個處理常式然後再試。',
    '__php_fpm_handler' => 'FPM 應用程式',

    'mailname_create_assigned_user_dublicate_error' => '無法為郵箱創建用戶。用戶名為 %1 的用戶已存在並且有其它的郵箱。',
    'mailname_create_assigned_user_role_absent_error' => '無法為郵箱創建用戶。用戶默認的角色 %1 不存在。',

    'gphd__mime_types' => 'MIME 類型',
    'gphd__handlers' => 'Apache 處理常式',
    'gphd__ip_restrictions_allow' => '允許存取指定主機和網路的網站（拒絕存取的除外）',
    'gphd__ip_restrictions_deny' => '拒絕存取指定主機和網路的網站',
    'gphd__directory_index' => '索引檔',
    'gphd__nginx_transparent_mode' => 'Apache 處理靜態和動態內容而 nginx 僅通過 HTTP 請求和回應不做修改的模式。',
    'gphd__nginx_serve_static' => '由 nginx 直接服務靜態檔',
    'gphd__nginx_static_extensions' => '必須由 nginx 處理的靜態檔擴展',
    'gphd__nginx_serve_php' => '由 nginx 處理 PHP 文件',
    'gphd__www_root' => 'WWW 根目錄',

    'eol__none' => '不修改',
    'eol__lf' => '轉換到Unix風格',
    'eol__cr' => '轉換為MacOS風格',
    'eol__crlf' => '轉換為Windows風格',

    'ui__dns_bad_zone' => '不一致的區域 "%1"。',
    'ui__dns_ns_has_no_address_records' => 'NS 記錄 "%1" 沒有位址記錄 (A 或 AAAA)。',
    '__dns_bad_zone' => '不一致的區域 "%1"。',
    '__dns_ns_has_no_address_records' => 'NS 記錄 "%1" 沒有位址記錄 (A 或 AAAA)。',
    '__dns_ptr_is_wildcard' => 'PTR 記錄 "%1" 無效。記錄指向一個萬用字元域名。',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] 允許客戶 \'%4\' 的資料庫使用者 \'%3\' 使用遠端存取。',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => '無法允許資料庫使用者 \'%1\' 使用遠端連接。無法確定 Microsoft SQL server \'%2\' 使用的 TCP 埠號。可能的原因有：TCP/IP 協定未在伺服器網路配置中啟用或伺服器被配置使用動態 TCP 埠。請配置伺服器監聽指定的固定 TCP 埠並再次嘗試允許遠端連接。',

    'command__convertResellerHasCustomer' => '代理商帳戶 \'%1\'  有一或多個客戶帳戶。若要轉換此代理商帳戶為客戶帳戶，請轉換這些客戶帳戶給新所有者，或轉換為代理商帳戶。',
    'command__convertResellerNotReseller' => '僅代理商帳戶可被轉換為客戶帳戶。\'%1\' 不是一個代理商。',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => '無法將訂閱與服務方案同步。訂閱的下列設定與服務方案衝突：%%problems%%。',

    'moveCustomer__wrong_customer_type' => '帳戶 \'%1\' 是一個代理商帳戶。無法移動代理商帳戶給新的所有者因為這些帳戶由伺服器管理員所有。',
    'moveCustomer__wrong_owner_type' => "可以把客戶帳戶 '%1' 僅移動給一個代理商或 admin，而不能移給其它客戶。",
    'moveCustomer__customer_already_belongs_to_owner' => '客戶帳戶 \'%1\' 已屬於選定所有者。',
    'upgradeClient__user_is_admin' => '帳戶 \'%1\' 無法被轉換為代理商帳戶因為該帳戶是管理員帳戶。',

    'mail__error_setting_max_connections_courier' => '無法設定連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量：%1',
    'mail__error_setting_max_connections_dovecot' => '無法設定連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量：%1',
    'mail__error_setting_max_connections_per_ip_courier' => '無法按 IP 位址設定連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量：%1',
    'mail__error_setting_max_connections_per_ip_dovecot' => '無法為某個特定用戶按 IP 位址設定連接（IMAP、POP3、IMAP over SSL/TLS 或 POP3 over SSL/TLS）的最大數量：%1',
    'mail__error_no_localhost_for_maillists_in_server_white_list' => '若要使用郵寄清單，您需要在郵件伺服器的白名單中設定有 localhost (127.0.0.0/8, ::1/128) 。但是，若要使用傳出郵件控制，白名單中則不需要有 localhost。如果您已經啟動了傳出郵件控制，那麼可使用折中方案，即在郵箱上使用郵件轉發而非郵寄清單。',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv4' => '若要使用郵寄清單，您需要在郵件伺服器的白名單中有 localhost。但是，若要使用傳出郵件控制，白名單中則不需要有 localhost。如果您已經啟動了傳出郵件控制，那麼可使用折中方案，即在郵箱上使用郵件轉發而非郵寄清單。注意現在白名單中沒有 IPv4 localhost 位址 (127.0.0.0/8)，因此傳出郵件控制功能將用於 IPv4 位址。',
    'mail__error_no_localhost_for_maillists_in_server_white_list_ipv6' => '若要使用郵寄清單，您需要在郵件伺服器的白名單中有 localhost。但是，若要使用傳出郵件控制，白名單中則不需要有 localhost。如果您已經啟動了傳出郵件控制，那麼可使用折中方案，即在郵箱上使用郵件轉發而非郵寄清單。注意現在白名單中沒有 IPv6 localhost 位址 (::1/128)，因此傳出郵件控制功能將用於 IPv6 位址。',
    'mail__outgoing_messages_with_open_relay_error' => '為了更好地限制傳出郵件資訊的數量，請關閉中繼。',
    'outgoing_messages_limit_value_invalid' => '該值必須介於 %%MIN%%..%%MAX%% 之間。只有 Plesk 管理員可以調整該設定。',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "以下域名使用外部電郵地址來對發送到位址不存在的郵件進行轉發。發送到這些位址的郵件將不計入傳出郵件控制範疇：\n%1",
    'outgoing_messages_white_list_not_empty' => '對傳出郵件的限制將不適用於IP地址來自郵件伺服器白名單的寄件者。例如，如果在白名單中有 localhost (127.0.0.0 / 8, ::1 / 128)，不管該限制如何，所有本機伺服器的郵件將被成功發送。寄件者可以使用本地IP位址（在本機伺服器上託管的網站和自訂腳本）或外部IP位址（通過安裝在電腦或移動設備上的郵件用戶端發送郵件的客戶）。要實現該限制適用於所有寄件者（本地的和外部的），請移除所有來自白名單的IP位址和網路。請注意，移除來自白名單的 localhost (127.0.0.0 / 8, ::1 / 128) 可能干擾該伺服器發送郵件網站和腳本的操作。瞭解有關傳出郵件限制的詳情，請查看管理員指南，傳出垃圾郵件防護。',
    'outgoing_messages_relay_open' => '郵件中繼已打開：將無法實現對傳出郵件的限制。',

    'spf_dsnignore' => '當有 DNS 查找問題時繼續 SPF 檢查',
    'spf_dnsignore_hint' => '首先，SPF 會執行 DNS 查找。若選擇該選項，如果 DNS 查找失敗則仍會繼續檢查。如果在當前的檢查模式中沒有任何效果則取消選定該選項。',
    'spf_behavior_hint' => '然後，SPF 會應用本地和猜測規則。可能會根據選定的檢查模式和檢查結果拒絕郵件資訊。',

    'notification_aps_app_updates_available' => '更新可用于以下應用程式。',
    'notification_aps_app_updates_installed' => '已自動為以下應用程式安裝更新：',
    'notification_aps_app_updates_requirements' => '更新可用于以下應用程式但是無法安裝因為相應網站的主機設定不符合安裝要求：',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%).已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) 上的外掛程式 "%%name%%"。已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) 上的主題 "%%name%%"。已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%).已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) 上的外掛程式 "%%name%%"。已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) 上的主題 "%%name%%"。已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%).您的版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => '%%parentName%% (%%url%%) 上的外掛程式 "%%name%%"。您的版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => '%%parentName%% (%%url%%) 上的主題 "%%name%%"。您的版本：%%from%%.可用版本：%%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%).新版本：%%to%%.舊版本：%%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%).新版本：%%to%%.舊版本：%%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%).新版本：%%to%%.舊版本：%%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%).已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%).已安裝版本：%%from%%.可用版本：%%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%).您的版本：%%from%%.可用版本：%%to%%.',
    'notification_aps_app_updates_no_installation_url' => '外部應用程式',

    'notification_outgoing_mail_exceeded_limits_domains' => '域名',
    'notification_outgoing_mail_exceeded_limits_mails' => '電郵地址',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => '訂閱',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '每小時 %1 條資訊',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => '無限',
    'notification_outgoing_mail_exceeded_limits_object' => '%1，限制為 %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 嘗試超過限制（從 %2 到 %3）',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 嘗試超過限制（從 %2 直到現在）',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "IP 地址禁止 (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => '目標伺服器上的未安裝 Fail2ban 組件。',
    'backup__restore__capability_fail2ban_not_installed_resolution' => '安裝 Fail2ban。注意這可能需要幾分鐘。',

    'plesk_key__no_reseller_support' => '因許可證限制您無法管理代理商。',
    'plesk_key__no_customers_support' => '因許可證限制您無法管理客戶。',
    'panel_interface_uimodes__service_provider_view_not_allowed' => '因許可證限制無法切換到服務提供者視圖。',
    'plesk_key__no_security_core_support' => '因許可證限制無法使用安全核心功能 (ModSecurity 和 Fail2Ban)。',
    'plesk_key__outgoing-antispam' => '傳出郵件控制',
    'plesk_key__security-core' => '安全核心 (ModSecurity 和 Fail2Ban)',
    'plesk_key__can-manage-accounts' => '帳戶管理',
    'plesk_key__can-manage-subscriptions' => '訂閱管理',
    'plesk_key__can-manage-customers' => '客戶管理',
    'plesk_key__can-manage-resellers' => '代理商管理',
    'plesk_key__can-manage-custom-view' => '限制模式可用性',
    'plesk_key__limits_exceeded_no_subscriptions_management' => '訂閱管理已被關閉但是您有多個訂閱 (%1)。',
    'plesk_key__limits_exceeded_no_resellers_management' => '代理商管理已被關閉但是您有多個代理商 (%1)。',
    'plesk_key__limits_exceeded_no_customers_management' => '客戶管理已被關閉但是您有多個客戶 (%1)。',
    'plesk_key__no_subscriptions_support' => '因許可證限制您無法管理訂閱。',
    'plesk_key__no_custom_view_support' => '由於許可證限制，您不能使用限制模式。',
    'plesk_key__trial_forbidden_region' => '很抱歉，Plesk 目前在您的區域裡不供使用。',
    'additional_key__main_key' => '該金鑰是主要的金鑰：您無法上傳主要的金鑰作為其它的金鑰。',

    'gch__hosting_waf_rule_engine' => 'Web 應用程式防火牆模式',

    'backup__fieldset__restoration_options' => '恢復選項',
    'backup__restore_options__restore' => '恢復',
    'backup__restore_options__domain__domain_configuration' => '域名配置',
    'backup__restore_options__domain__virtual_host_content' => '虛擬主機內容',
    'backup__restore_options__domain__mail' => '郵件',
    'backup__restore_options__domain__databases' => '資料庫',
    'backup__restore_options__client__client_configuration' => '客戶帳戶配置',
    'backup__restore_options__client__domains' => "客戶域名",
    'backup__restore_options__reseller__reseller_configuration' => '代理商帳戶配置',
    'backup__restore_options__reseller__personal_domains' => "代理商域名",
    'backup__restore_options__reseller__clients' => "代理商客戶",
    'backup__restore_options__admin__server_configuration' => '伺服器設定',
    'backup__restore_options__admin__administrator_configuration' => '管理員帳戶配置',
    'backup__restore_options__admin__personal_domains' => "管理員域名",
    'backup__restore_options__admin__personal_clients' => "管理員客戶",
    'backup__restore_options__admin__resellers' => '代理商',

    'badge_new' => '新',
    'upgrade_php_on_subscription' => '請將您訂閱的 PHP 升級到5.3.0或更新版本。',

    'pkey_notify__body_expiration_notification' => '許可證金鑰已過期。一些功能特性不可用。請聯繫您的主機提供商。',

    'crontab__crontab_entry_exists' => "計畫任務已存在",
    'crontab__crontab_entry_not_exists' => "計畫任務不存在。",
    'crontab__invalid_values_found' => "參數值錯誤。",
    'crontab__cmd_max_len' => "該命令不得超過 %1 個字元。",

    'domain__domain_exists' => "有一個域名帶有 'www' 首碼和相同名稱：%1.%2.",
    'domain__subdomain_exists' => "有一個子域名帶有 'www' 首碼和相同名稱：%1.%2.",
    'domain__dalias_exists' => "有一個域名別名帶有 'www' 首碼和相同名稱：%1.%2.",
    'domain__record_exists' => "已有對應於主機%1.%2的DNS記錄。",

    'ip_addr__cannot_assign_certificate' => "無法設定證書 '%1' 作為默認的證書：私密金鑰丟失。",
    'ip_addr__update_dns_error' => '在 DNS 區域中更新 IP 位址時出現錯誤。%1',
    'ip_addr__cannot_add_dhcp_enabled' => '無法添加 IP 地址。該網路介面會自動獲取 IP 位址。',
    'ip_addr__cannot_remove_dhcp_enabled' => '無法移除 IP 地址 %1。該網路介面會自動獲取 IP 位址。',
    'ip_addr__cannot_repair_dhcp_enabled' => '無法修復 IP 地址 %1。該網路介面會自動獲取 IP 位址。',
    'ip_addr__cannot_change_interface_dhcp_enabled' => '無法更改 IP 位址 %1 的介面因為網路介面 %2 會自動獲取 IP 位址。',

    'shm_lmsg__limit_for_resource_exceeded' => '已超過訂閱對 %%type%% 數量的限制。限制為 %%limit%%，而當前正使用 %%usage%%。',
    'shm_lmsg__resource_is_forbidden_for_creation' => '該訂閱沒有創建 %%type%% 的許可權。',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL資料庫',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL 資料庫',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL 資料庫',
    'shm_lmsg__resource_title__db-user' => '資料庫使用者',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS應用程式池',
    'shm_lmsg__resource_title__additional-ftp-account' => '其他 FTP 帳號',

    'db_user_unable_remove_mysql_global_privileges' => '無法移除資料庫使用者 %1 的 MySQL 全域許可權。原因：%2',
    'report__client_description' => '描述',

    'db__user_role_error' => '指定的資料庫使用者角色不正確：%1。請選擇下面當中的一個角色：%2.',

    'subscription_unable_to_set_max_filesize_warning' => '無法為下面的 Microsoft SQL Server 資料庫設定檔大小限制因為它們的檔較大：%1.',
    'subscription_unable_to_set_max_log_filesize_warning' => '無法為下面的 Microsoft SQL Server 資料庫設定日誌檔大小限制因為它們的日誌檔較大：%1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => '無法設定公共 IP 地址：必須存在一個獨立的 IP 位址。',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => '無法為 IPv6 位址設定一個公共的 IPv4 位址。',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => '無法為 IPv4 位址設定一個公共的 IPv6 位址。',
    'ipaddress__cannot_set_up_public_ip_invalid' => '無法設定公共 IP 地址：無效的 IP 地址。',

    '__user_already_exists' => "用戶 %1 已存在。",
    '__user_name_is_empty' => "請指定一個用戶名。",

    'upgrade_php_on_domain' => '在您任何的 WordPress 域名上無法找到 PHP 5.3.0 版本或更新版本。請嘗試升級 PHP。',

    'component_name__waf' => 'Web 應用程式防火牆',
    'component_name__vcs' => '版本控制系統',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => '已檢測到可能的欺騙行為嘗試：連結嘗試顯示不相關的內容。',

    'php_handlers_error_no_available_instance' => '無法創建域名：沒有可用的 PHP 處理常式。',
    'domain_error_unable_to_apply_hosting_settings' => '無法應用主機設定：%1',

    'plesk_not_configured' => 'Plesk 未進行配置。請進入控制台執行安裝後配置。',
    'cmd_mail__mail_password_duplicated' => '郵件伺服器上已存在指定的電郵地址和密碼組合。請指定其它的電郵地址或密碼。',

    'extensionRequirementOs' => '該套裝程式不支援作業系統 (%1)。',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 是該套裝程式支援的最早版本。',
    'extensionRequirementPleskMaxVersion' => '該套裝程式不支援自 Plesk %1 起的版本。',
    'extensionBlacklisted' => '不允許安裝擴展 %1。',
    'extensionDisabled' => '該擴展被禁用。',


    'optimization_settings__unable_set_mpm_event' => '無法設定 mpm_event 模式：需要關閉 Apache PHP5 模組，但是該模組正被域名使用。',
    'optimization_settings__unable_turn_off_php' => '無法關閉 Apache PHP5 模組：正被域名使用。',

    'hst_def__fp_admin_login' =>  'FTP 用戶名',
    'hst_def__fp_admin_passwd' =>  'FTP 密碼',

    'database_user_orphaned_old_password_wrong' => "無法修復孤立的用戶 '%1'：該密碼不正確。",
    'cannot_load_partner_central_property_key_no_exist' => "無法檢索自訂屬性：該許可金鑰不存在。",
    'extensionScriptFailure' => "執行 %1 失敗，出現以下資訊：\n%3",
    '__ssl_redirect' => "SEO 安全 301 永久重定向（從 HTTP 到 HTTPS）",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => '不支援 DKIM 管理。',
    'mail__dmarc_not_supported' => '不支援 DMARC 管理。',
    'mail__relay_white_list_not_supported' => '不支援中繼白名單管理。',
    'mail__black_list_not_supported' => '不支援黑名單管理。',
    'mail__autoresponder_not_supported' => '不支援自動回復管理。',
    'defaultcomponents__not_supported_version' => '（不支援的版本）',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => '未找到證書 \'%1\'。',
    'certificate__unable_setup_certificate' => '無法安裝證書：%1 私密金鑰和證書內容丟失。',
    'certificate__used_by_panel' => '您要刪除的證書中有一個被用於保護 Plesk 的安全。',
    'certificate__used_by_mail_server' => '您要刪除的證書中有一個被用於保護郵件伺服器的安全。',
    'certificate__used_by_domain_service' => '您要刪除的其中一個證書被域名服務使用。',
    'mail_server__not_installed' => '無法為郵件伺服器安裝證書因為沒有安裝郵件伺服器。',

    'email_activation_mail_subject' => '請在Plesk中啟動您的帳戶',
    'email_activation_mail_body' => "在Plesk伺服器上創建了一個帳戶%1\n\n帳戶詳情：\n姓名：%2\n電子電郵地址：%3\n\n如果這個資訊是正確的，並且該帳戶是為您創建的，請使用以下連結啟動它：\n\n%4\n\n啟動該帳戶後，作為合同的一個組成部分，你便授權伺服器持有人根據現行的資料保護法收集、傳出、處理和使用您的個人資料（姓名和電子郵件），用以創建和支援您的帳戶。",

    'backup_transport_permission_name' => '%1 管理',
    'backup_transport_permission_description' => '允許使用 %1 來存儲備份。',

    'domain_move_err_target_no_hosting' => '無法在無代管的情況下將網域移至訂閱。',
    'domain_move_err_already_in_target' => '網域已屬於目標訂閱。',
    'domain_move_err_main_domain' => '主網域無法移動。',
    'domain_move_err_subdomain_without_parent' => '無法只移動子網域 %1 而不移動上層網域 %2。',
    'domain_move_err_root_exists' => 'www_root %1 的目標路徑已存在。',
    'domain_move_err_nested_roots' => '無法移動網域，因為文件根目錄與其他網域共用：%1。',
    'domain_move_err_no_mail_service' => '無法移動網域，因為目標訂閱上的郵件服務已停用。',
    'domain_move_err_app' => "安裝在 %1 的應用程式未移至 '%2'：%3",
    'domain_move_database_used_by_app' => "位於 %2 上的資料庫 '%1' 已為移走的應用程式所使用。如需將資料庫重新指定給 '%3'，請執行 `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "目標訂閱 '%1' 已封鎖同步功能。",
    'domain_move_filesharing_disabled' => '檔案共用已停用。',
    'domain_move_website_preview_disabled' => '網站預覽已被禁用。',
    'domain_move_additional_webserver_settings' => "檢查網域額外的網頁伺服器指令以避免設定缺失。",
    'domain_move_no_permission' => "訂閱 '%2' 不允許使用 %1。",
    'domain_move_no_access' => "沒有對 '%1' 的存取權限。",
    'domain_split_no_create_permission' => "不允許創建域名。",
    'domain_split_empty_login' => '需要提供系統使用者登入名。',
    'domain_split_empty_password' => '需要提供系統使用者密碼。',
    'domain_split_err_home_exists' => '無法移動域名 %1 因為 %2 中已存在其目標主路徑。請將域名重命名以將其移動到新的訂閱。',
    'domain_split_err_no_hosting_subdomains' => '域名無法移動到新訂閱因為該域名沒有主機而是有子域名。若要移動域名，請將其 "主機類型" 的值更改為 "網站主機"（在“主機設定”中）。',
    'domain_split_target_locked' => "目標訂閱 '%1' 已鎖定不能同步。",
    'domain_split_target_unsynced' => "目標訂閱 '%1' 未與方案同步，因為：%2.",
    'domain_merge_scheduled_backup_deactivated' => "已在 '%1' 上停用了計畫備份。",
    'domain_merge_database_error' => "%2 上的資料庫 '%1' 未被移動到訂閱 '%3'：%4",
    'domain_merge_anon_ftp_deactivated' => "'%1' 上的匿名 FTP 已被關閉。",
    'domain_merge_smb_user_access' => "其它用戶 '%1' 被移動到訂閱 '%2' 但是該用戶對訂閱的存取權限已被取消。",
    'domain_merge_scheduled_tasks' => "計畫任務已被移動到目標訂閱。請檢查任務配置。",
    'domain_merge_scheduled_tasks_deactivated' => "計畫任務已被移動到目標訂閱且被停用。請檢查任務配置。",
    'domain_merge_no_remove_permission' => "不允許移除訂閱。",
    'domain_merge_err_has_addons' => '無法移動帶有其它域名的主域名；請首先移動域名 %1。',
    'domain_merge_err_has_webusers' => '無法移動帶有其 web 用戶的主域名。',
    'domain_merge_err_root_exists' => '目標路徑 %1 已存在。',

    'database_server_edit_used_for_psa' => '不允許更新本地的 MySQL 資料庫伺服器。',
    'suggest_repair_main_suggestion_ui' => '<b>您可以修復此錯誤</b>，通過使用 `plesk repair` 實用工具。',
    'suggest_repair_main_suggestion_cli' =>  '您可以使用 `plesk repair` 實用工具修復此錯誤。',
    'suggest_repair_repair_kit_link_title' => '轉到 “診斷與修復”',
    'suggest_repair_using_cli_and_ui' => '如要實現此目的，可通過 CLI 運行 `plesk repair %1` 命令或者 %2 並點按 “Plesk 資料庫” 旁的修復',
    'suggest_repair_using_cli' => '要實現此目的，需通過 CLI 運行 `plesk repair %1` 命令',
    'verp_style_link' => 'VERP 式',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => '當創建了備份時 DNS 服務變得不可用了。但是，在備份中有活動的 DNS 區域，將為以下對象啟用這些服務：{{objects}}',
    'plesk_key__system-resources-limits-enabled' => '資源調度控制器 (cgroups)',
    'plesk_key__remote-smartermail-enabled' => '遠端 SmarterMail 的支援',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '（許可證金鑰不允許）',
    'plesk_key__validation_failed' => '%1（錯誤代碼：%2)',
    'promo__button_details' => '詳情',
    'promo__extension_catalog_title' => '擴展目錄',
    'promo__extension_catalog_description' => '查看新的擴展目錄，並通過各種強大的擴展壯大您的 Plesk！',
    'promo__button_open_catalog' => '打開目錄',

    'backup__repository_check_login' => "無法存取存儲系統：%1\n請確保您已輸入了正確的存儲驗證憑據。",
    'backup__repository_check_error_list' => "無法存取存儲系統：%1\n請確保您已輸入了正確的存儲設定。",
    'backup__repository_check_error_mkdir' => "無法創建目錄：%1\n檢查您是否有許可權在存儲系統中創建資料夾。",
    'backup__repository_check_error_upload' => "無法將檔上傳到存儲系統： %1\n檢查您是否有許可權將檔上傳到存儲系統。",
    'backup__repository_check_error_download' => "無法從存儲系統下載檔案： %1\n檢查您是否有許可權將檔上傳到存儲系統或從存儲系統下載檔案。",
    'backup__repository_check_error_resume-upload' => "無法恢復上傳到存儲系統中的檔： %1\n檢查您是否有許可權恢復上傳到存儲系統中的檔。",
    'backup__repository_check_error_resume-download' => "無法恢復從存儲系統中下載的檔： %1\n檢查您是否有許可權恢復從存儲系統中下載的檔。",
    'backup__repository_check_error_enable-utf8' => "無法操作存儲系統：%1\n檢查存儲系統是否支援 UTF8 編碼。",
    'backup__repository_check_error_rm' => "無法操作存儲系統：%1\n檢查您是否有許可權從存儲系統刪除檔。",
    'backup__repository_check_error_rmdir' => "無法操作存儲系統：%1\n檢查您是否有許可權從存儲系統刪除資料夾。",

    'backup__ftp_repository_check_login' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2",
    'backup__ftp_repository_check_error_list' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2",
    'backup__ftp_repository_check_error_upload' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_download' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2\n  %3\n  %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2",
    'backup__ftp_repository_check_error_rm' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2\n  %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 您可以使用命令對其進行獨立地檢查：\n  %2\n  %3",

    'link_to_extension_developer_guide' => '如何開發一個擴展？',

    'sfdmarc_server_wide_legend' => 'DMARC',
    'sfdmarc_server_wide_enable_dmarc' => '啟用 DMARC 以檢查傳入郵件',
    'sfdmarc_server_wide_enable_failed' => '無法更改 DMARC 的設定若要啟用此選項，請打開 DKIM 和 SPF 垃圾郵件防護服務。',
    'sfdmarc_server_wide_enable_hint' => '當為傳入郵件啟用了 DKIM 和 SPF 時此選項可用。',
    'spf_server_wide_enable_hint' => '當為傳入郵件啟用了 DMARC 時，可能無法關閉此選項。',
    'spf_server_wide_disable_failed' => '無法更改 SPF 垃圾郵件防護的設定。若要禁用 SPF，請為傳入郵件關閉 DMARC。',
    'sfdk_server_wide_enable_hint' => '當為傳入郵件啟用了 DMARC 時，可能無法關閉此選項。',
    'sfdk_server_wide_verify_disable_failed' => '無法更改 DKIM 垃圾郵件防護的設定。若要禁用 DKIM，請為傳入郵件關閉 DMARC。',

    'ccs_not_supported' => '系統上未配置 IIS Central Certificate Store。',
    'ccs_not_enabled' => '在 Plesk 中未啟用 IIS Central Certificate Store 管理。',
    'ad_not_supported' => '伺服器未加入到域名中。',

    'component_name__appinit' => "應用程式初始化",
    'component_name__httpcompression' => 'HTTP 內容壓縮',
    'common_feature_is_not_supported' => '不再支援此功能。',
    'common_feature_is_not_supported_in_proto' => '對於協定版本 %1 不再支援此功能。',
    'autoinstaller__plesk_component' => 'Plesk 組件',
    'plesk_key__key_expired' => '您的許可證金鑰已到期。若要繼續使用 Plesk，請購買非到期商業 %1。',
    'plesk_key__key_purchase' => '許可證金鑰',

    'sa_action_move' => '將垃圾郵件移動到 "垃圾郵件" 資料夾。',

    'bu_conflict_resolver_tomcat_not_supported' => '不再支援 Java 應用程式。以下網站將不可用這些服務：{{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => '不再支援使用 UNITY Mobile 託管的網站移動版本。以下網站將不可用這些服務：{{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => '伺服器範圍的使用策略不允許使用個人的反病毒設定。將會為以下域名上的電子郵件帳戶不完全的將其恢復：{{objects}}',

    'server_preferences__ip_logging' => 'IP 日誌記錄',
    'server_preferences__disable_ip_logging' => '禁用 IIS、FTP 和郵件日誌中的 IP 日誌記錄',
    'server_preferences__disable_ip_logging_description' => '如果選定，IIS 和 MailEnable 不再會將 IP 位址寫入到日誌檔中',

    'module__not_installed' => "擴展 %1 未安裝",

    'mail__mailbox_quota_warning_text' => '啟用郵箱配額警告',
    'mail__mailbox_quota_warning_hint' => '當郵件用戶的郵箱配額使用超過了 95% 時發送通知給郵件用戶',
    'mail__mailbox_quota_warning_customization_text' => '自訂默認的郵箱配額警告',
    'mail__mailbox_fix-incorrectly-set-sender-text' => '修復外發郵件的錯誤設定的寄件者',
    'mail__mailbox_fix-incorrectly-set-sender-hint' => '自動為從域名外發郵件設定有效的電子郵件資訊頭和寄件者信封位址以降低被視作垃圾郵件的風險',
    'mail__mail_autodiscovery' => '郵件 autodiscover',
    'mail__mail_autodiscovery_description_text' => '查看其在 %%link%% 中是如何工作運行的',
    'mail__mail_autodiscovery_description_text_link' => '知識庫',
    'mail__mail_autodiscovery_text' => '啟用郵件 autodiscover',
    'mail__mail_autodiscovery_hint' => '啟用此功能會重新配置啟用了 autodiscover 的所有域名',
    'mail__mail_autodiscovery_server_text' => '為郵件 autodiscover 指定一個自訂域名',
    'mail__mail_autodiscovery_server_hint' => '注意：域名必須使用有效的 SSL/TLS 證書進行安全保護。',
    'mail__mail_autodiscovery_server_error' => '為郵件 autodiscover 指定一個自訂域名',
    'mail__mail_autodiscovery_reconfigure_dns_text' => '重新配置 autodiscover DNS 記錄',
    'mail__mail_autodiscovery_reconfigure_dns_hint' => '啟用此功能會重新配置啟用了 autodiscover 的所有域名 autodiscover DNS 記錄',
    'mail__error_mail_autodiscovery_enable' => '無法設定郵件 autodiscover：%1',
    'mail__error_mail_autodiscovery_server' => '無法為郵件 autodiscover 設定自訂域名：%1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => '無法重新配置域名 autodiscover DNS 記錄：%1',

    '__invalid_url' => 'URL "%1" 無效',
    'actionlog__cloning_start' => '開始',
    'actionlog__event_cloning_start' => '伺服器克隆開始',

        '__show_hide_title' => '最小化/還原',
    '__show_hide_navigation_pane' => '隱藏/顯示導航面板',
    '__UPLOAD_ERR_FORM_SIZE' => "上傳的檔超出了允許的大小。",
    '__UPLOAD_ERR_INI_SIZE' => "上傳的檔超出了允許的大小。",
    '__UPLOAD_ERR_NO_FILE' => "未接收到文件。",
    '__UPLOAD_ERR_OK' => "檔成功上傳。",
    '__UPLOAD_ERR_PARTIAL' => "僅上傳了部分檔，請重試。",
    '__UPLOAD_ERR_NO_TMP_DIR' => '丟失暫存檔案夾',
    '__UPLOAD_ERR_CANT_WRITE' => '將檔寫入磁片失敗',
    '__UPLOAD_ERR_UNKNOWN' => '發生未知的檔上傳錯誤',
    '__accounts' => "帳戶",
    '__access' => "存取",
    '__address' => "地址",
    '__addresses' => "地址",
    '__acl_records' => 'ACL記錄',
    '__admin_repository' => "管理員的證書庫",
    '__all' => '所有',
    '__allowed' => "允許",
    '__anonftp_status' => "匿名FTP",
    '__antispam' => "垃圾郵件",
    '__apache_restart' => "...%1Web伺服器正在重啟，請等待...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET支援",
    '__asp_win_support' => "Microsoft ASP支援",
    '__attachments' => "附件",
    '__attachments_list' => "附件",
    '__author' => '創建者',
    '__autoresp_name_already_exists' => "名為%1的自動回復已存在。",
    '__autoresponder' => "自動回復",
    '__autoresponders' => "自動回復",
    '__autoresponders_list' => "自動回復",
    '__autoresponder_attachment_files' => "自動回復附件",
    '__auto_updates_list' => '可用更新',
    '__avail' => "可用",
    '__backup_utilites' => "備份工具",
    '__bind_status' => "DNS 伺服器狀態",
    '__bu_is_not_installed' => "由於備份程式尚未安裝，此服務目前不可用。",
    '__bu_not_support_in_key' => "許可證不支援備份功能。",
    '__notifications_not_support_in_key' => '許可證不支援通知',
    'disabled_by_key' => '許可證不支援',
    '__bytes' => "位元組",
    '__can_not_use_reserved_words' => "您不能使用保留字。",
    '__certificate' => "證書",
    '__cgi_support' => "CGI支援",
    '__change_date' => "修改日期",
    '__choose_logo' => "徽標文件",
    '__city' => "城市",
    '__cl_not_exist' => "客戶帳戶不存在。",
    '__client' => '客戶',
    '__client_card' => "客戶名片",
    '__client_contact_name' => "客戶連絡人名稱",
    '__client_form' => "個人資訊",
    '__client_ip_pool' => "客戶IP池",
    '__client_limits' => "客戶帳戶限制",
    '__client_permissions' => "客戶許可權",
    '__client_preferences' => "客戶偏好設定",
    '__client_status' => "客戶狀態",
    '__client_name' => "客戶名稱",
    '__client_total' => "客戶總數",
    '__client_with_login_name_already_exists' => "用戶名為\"%1\"的用戶已存在。",
    '__client_domuser_with_login_already_exists' => "域名 '%1' 的管理員已使用用戶名 '%1'。",
    '__clients_global_changes' => "修改所選客戶帳戶",
    '__clients_list' => "客戶",
    '__cmd_not_found' => "未知命令：%1",
    '__comments' => "備註",
    '__company_name' => "公司名稱",
    '__component_version' => "組件版本",
    '__allow_zone_transfer_list' => '公共的解析傳遞允許列表',
    '__component_not_installed' => "尚未安裝組件%1",
    '__confirm_del' => "您必須確認刪除。",
    '__confirm_overwrite' => "確認覆蓋。",
    '__confirm_stop' => "您必須停止確認進程。",
    '__confirm_passwd' => "確認%1密碼",
    '__confirm_removal' => "確認刪除",
    '__conhelp' => "描述",
    '__contact_name' => "聯繫名稱",
    '__country' => "國家",
    '__countries' => '國家',
    '__country_unknown' => '無法識別國家/地區的子碼。',
    '__courier-imap' => 'Courier 伺服器',
    '__create_domain' => '創建域名',
    '__crypted' => '已加密',
    '__cp_access' => "存取 Plesk",
    '__cp_user' => "Plesk 用戶",
    '__create' => "創建",
    '__create_client_template_without_template' => "不使用範本創建使用者帳戶",
    '__create_domain_for' => "為 <b>%1 創建域名</b>",
    '__create_domain_template_without_template' => "不使用範本創建域名",
    '__creation_date' => "創建日",
    '__crontab_unix' => "計畫程式",
    '__crontab_win' => "計畫程式",
    '__ct_month_jan' => '一月',
    '__ct_month_feb' => '二月',
    '__ct_month_mar' => '三月',
    '__ct_month_apr' => '四月',
    '__ct_month_may' => '五月',
    '__ct_month_jun' => '六月',
    '__ct_month_jul' => '七月',
    '__ct_month_aug' => '八月',
    '__ct_month_sep' => '九月',
    '__ct_month_oct' => '十月',
    '__ct_month_nov' => '十一月',
    '__ct_month_dec' => '十二月',
    '__custom_button' => "自訂按鈕",
    '__custom_buttons_list' => "其它服務的連結",
    '__daily' => "每日",
    '__database_not_activated' => "尚未在伺服器管理頁上啟用%1。",
    '__database_not_installed' => "資料庫 %1 尚未安裝。",
    '__database_not_run' => "資料庫 %1 沒在運行。",
    '__database_is_corrupt' => "Plesk 的資料庫已損壞。請啟動 Reconfigurator 工具來修復。",
    '__databases' => "資料庫",
    '__databases_list' => "資料庫",
    '__database_type_not_supported_by_key' => '要使用 %1 伺服器，需要您的許可證金鑰支援該服務。請諮詢您的 Plesk 銷售代表。',
    '__date_immediately' => "今天",
    '__date_never' => "從不",
    '__day(s)' => "天",
    '__day0' => "星期日",
    '__day1' => "星期一",
    '__day2' => "星期二",
    '__day3' => "星期三",
    '__day4' => "星期四",
    '__day5' => "星期五",
    '__day6' => "星期六",
    '__days' => "%1日",
    '__db_admin_login_empty' => "您輸入的用戶名為空，這將導致無法在介面中通過%1啟用控制。您想要繼續嗎？",
    '__db_unable_to_unregister' => '無法刪除資料庫連接參數',
    '__db_db_exists' => '伺服器上至少有一個資料庫。',
    '__db_unable_to_change_server_name' => '此伺服器名稱不能更改',
    '__db_unable_to_change_port' => '不能更改伺服器埠',
    '__db_already_exist' => "資料庫 %1 已存在。",
    '__db_credentials_invalid' => "資料庫憑證無效。",
    '__db_invalid_password_characters' => 'The password contains invalid characters',
    '__db_engine' => "資料庫引擎", // indirect
    '__db_type' => "資料庫類型",
    '__db_user' => "資料庫使用者",
    '__db_server' => '資料庫伺服器',
    '__def_domain' => "默認域名",
    '__default_for_mysql' => 'MySQL 默認使用',
    '__default_for_mariadb' => '默認用於 MariaDB',
    '__default_for_percona' => '默認用於 Percona',
    '__default_for_postgresql' => 'PostgreSQL 默認使用',
    '__delete' => "刪除",
    '__demo' => "此功能在展示版本中不可用。",
    '__directory' => "目錄",
    '__disable_lock_screen' => '請阻止使用者在介面螢幕完全載入之前使用 Plesk 。',
    '__dismiss_news?' => "您確定要完全關閉新聞區嗎？\n\n直到有更多的新聞時，您才可以看到新聞區。",
    '__description' => "描述",
    '__disabled' => "禁用",
    '__disk_space_limit' => "磁碟空間限制",
    '__cgroups_cpu_usage_limit' => 'CPU 使用限制',
    '__cgroups_ram_usage_limit' => 'RAM 記憶體使用量限制',
    '__cgroups_disk_read_usage_limit' => '磁片讀取頻寬限制',
    '__cgroups_disk_write_usage_limit' => '磁片寫入頻寬限制',
    '__disk_usage_by' => "%1使用的磁碟空間",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS 記錄 '%1' 已存在。",
    '__dns_master_should_be_remote' => "不同主機上需要分別有授權域名伺服器。",
    '__dns_record_not_exist' => "DNS 記錄不存在。",
    '__dns_server' => "DNS 伺服器", // indirect
    '__dom_id_is_undefined' => "域名ID未定義。",
    '__dom_name' => "域名",
    '__dom_name_is_invalid' => "域名無效。請確定您的域名由字母數位、點、連字號組成，且不超過255個字元。點之間的每個域名部分都不超過63個符號。",
    '__dom_not_exist' => "域名不存在。",
    '__domain' => "域名",
    '__domain_' => '域名 %1',
    '__domain_form' => "域名表單",
    '__domain_id' => "域名 ID",
    '__domain_is_turned_off_for_backup' => "網站%1在備份/恢復過程中會被暫時關閉，當前不可用。",
    '__domain_limits' => "域名限額",
    '__domain_name' => "域名",
    '__mail_name_in_ASCII_form' => "ASCII格式的郵件帳戶名",
    '__message_error' => '錯誤',
    '__message_warning' => '警告',
    '__message_info' => '信息',
    '__domain_name_in_ASCII_form' => "ASCII 格式的域名",
    '__domain_repository' => "域名%1的庫",
    '__domain_status' => "域名狀態",
    '__domain_dns' => '域名 DNS 區域',
    '__domain_total' => "訂閱總數",
    '__domain_total_powerUser' => "訂閱總數",
    '__domain_user' => "域名管理員",
    '__domains_global_changes' => "修改選定的域名",
    '__mailnames_global_changes' => "對郵件名進行組操作",
    '__backup_manager' => '備份管理員',
    '__domains_list' => "域名",
    'domains_list__list_header' => "域名", //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "雖然WWW首碼功能已啟用，域名仍以www開始。\n是否繼續？",
    '__dovecot' => 'Dovecot IMAP 和 POP3 伺服器',
    '__dsmail' => "郵件服務",
    '__dsmaillist' => "郵寄清單服務",
    '__dsr_db' => "DB",
    '__dsr_dname' => "域名",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "客戶名稱",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "本機存放區中備份檔案的大小總和",
    '__email' => "電子郵箱",
    '__email_addr_is_invalid' => "電郵地址無效。",
    '__enabled' => "啟用",
    '__enter_cert_text' => "輸入證書文本",
    '__enter_logo_url' => "徽標 URL",
    '__enter_size' => "輸入大小",
    '__exclusive' => "獨立",
    '__expiration_date' => "到期日",
    '__fax' => "傳真",
    '__file' => "文件",
    '__file_is_empty' => "文件為空。",
    '__file_name' => "檔案名稱",
    '__file_type' => '檔案類型',
    '__filemanager' => "檔案管理員",
    '__filepath_is_empty' => "檔路徑為空",
    '__files_list' => "文件",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP 設定",
    '__ftp_serv' => "FTP 伺服器", // indirect
    '__ftp_server_parameters_are_empty' => "您必須先設定FTP帳戶屬性！",
    '__ftp_status' => "FTP 伺服器狀態",
    '__full_day0' => "星期日",
    '__full_day1' => "星期一",
    '__full_day2' => "星期二",
    '__full_day3' => "星期三",
    '__full_day4' => "星期四",
    '__full_day5' => "星期五",
    '__full_day6' => "星期六",
    '__full_month1' => "一月",
    '__full_month10' => "十月",
    '__full_month11' => "十一月",
    '__full_month12' => "十二月",
    '__full_month2' => "二月",
    '__full_month3' => "三月",
    '__full_month4' => "四月",
    '__full_month5' => "五月",
    '__full_month6' => "六月",
    '__full_month7' => "七月",
    '__full_month8' => "八月",
    '__full_month9' => "九月",
    '__giga' => "G",
    '__group' => "組",
    '__h' => "H",
    '__hard_disk_quota' => "硬碟配額",
    '__hard_disk_quota_not_supported' => '因伺服器檔案系統配置，導致硬碟配額不受支援',
    '__header_text_is_invalid' => "受保護區的標題無效。",
    '__help_topic_not_found' => '您所請求的說明主題(%1)不存在。',
    '__hosting' => "主機",
    '__hosting_ip_dns_ip_not_equiv' => "在A DNS記錄中指定的IP位址與主機使用的IP位址不一致。",
    '__hosting_scripting' => "主機腳本支援",
    '__hosting_setup_page_title' => "域名 %1 的主機設定",
    '__hosting_title' => "主機 (%1)",
    '__hosting_type' => "主機類型",
    '__hostname' => "主機名稱",
    '__hostname_is_empty' => "主機名稱為空。",
    '__hour(s)' => '小時',
    '__hst_type_incorrect' => "主機類型不正確。",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "閒置時間",
    '__iface' => "介面",
    '__image' => "圖像",
    '__imap_status' => "IMAP 伺服器狀態",
    '__in' => "流入",
    '__in_%' => "以 % 為單位",
    '__incorrect_databases_login_pass' => "您指定的用於存取PostgreSQL的憑據不正確。",
    '__incorrect_ip_or_network_address' => '不正確的IP位址或網路。',
    '__info' => '信息',
    '__install' => "安裝",
    '__install_prefix' => "安裝首碼",
    '__invalid_cert_id' => "無效的證書ID",
    '__invalid_context' => "無效上下文：%1",
    '__invalid_db_usr_name' => "資料庫用戶名無效。",
    '__invalid_dir_name' => "目錄名無效",
    '__invalid_dom_name' => "域名無效。",
    '__invalid_filename' => "檔案名無效。不要使用單引號和/或\"../\"的組合。",
    '__invalid_id' => "無效識別字。",
    '__invalid_lines_num' => "行數值不正確，這個值只能是數字。",
    '__invalid_max_letter_size' => "最大郵件大小無效。",
    '__invalid_pdir_name' => "受保護 URL 無效。",
    '__invalid_restart_apache_interval' => "Apache重啟間隔無效。",
    '__invalid_tmpl_name' => "範本名稱無效。",
    '__invalid_value' => "錯誤值。",
    '__ip_addr' => "IP 地址",
    '__ip_address_and_mask' => "IP地址和子網路遮罩",
    '__ip_alias__mask' => "IP地址和子網路遮罩",
    '__ip_addr_form' => "IP 地址格式",
    '__ip_addr_is_invalid' => "IP 地址無效。",
    '__ip_addr_list' => "IP地址",
    '__ip_address_does_not_exist' => "IP 地址不存在。",
    '__ip_addresses' => "IP地址",
    '__ip_address_and_mask_hint' => '如%1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KB",
    '__key_for_virtuozzo_only' => "您的許可證只能用於 Virtuozzo 容器中。",
    '__key_limits_exceeding' => "此操作超出了您的軟體許可證授權。如果您收到此消息，請及時聯繫您產品的提供商或製造商，以確認或擴展許可證授權。",
    '__kilo' => "K",
    '__keywords' => '關鍵字',
    '__lang_unknown' => '無法識別此語言。',
    '__languages' => '語言',
    '__learn_more' => '瞭解更多',
    '__loading' => '正在載入...',
    '__locales' => "語言包",
    '__link_url_is_invalid' => "徽標 URL 無效。",
    '__lists' => "郵寄清單",
    '__literal_bytes' => "B",
    '__processing' => "請稍候。<br>載入中...",
    '__locale' => "介面語言",
    '__locale_is_not_defined' => "未定義介面語言。",
    '__local_server_mysql' => '本地 MySQL 伺服器',
    '__local_server_postgresql' => '本地 PostgreSQL 伺服器',
    '__log_files' => "日誌檔",
    '__log_and_statistics_files' => '日誌檔和統計報告',
    '__config_files' => '設定檔',
    '__chroot_files' => 'Chrooted環境',
    '__login' => "%1 登入",
    '__login1' => "登入名",
    '__login_disabled' => "登入名已禁用",
    '__login_enabled' => "所允許的登入名",
    '__login_incorrect' => "您輸入的用戶名或密碼錯誤。",
    '__login_name' => "%1用戶名",
    '__login_name_is_invalid' => "%1用戶名無效。",
    '__logon_time' => "登入時間",
    '__ma' => "郵件別名",
    '__mail' => "郵件",
    '__mail_alias_name' => "郵件別名",
    '__mail_autodiscovery' => '郵件 autodiscover',
    '__mail_exchanger_name_is_invalid' => "郵件 exchanger 名稱無效。",
    '__mail_groups' => "郵件組",
    '__mail_list_engine' => "郵寄清單軟體",
    '__mail_name' => "郵件帳戶",
    '__mail_name_form' => "郵件帳戶屬性",
    '__mail_names' => "郵件帳戶",
    '__mail_serv' => "郵件伺服器",
    '__mail_user' => '郵件用戶',
    '__mailgroup' => "郵件組",
    '__maillist' => "郵寄清單",
    '__maillists' => "郵寄清單",
    '__maillist_member' => '郵寄清單成員',
    '__mailname' => "郵件帳戶",
    '__mailname_redir_self' => "郵件帳戶不可以轉發給自身。",
    '__max_dom_num_reached_for_cl' => "已達到此客戶帳戶的域名數量限制。",
    '__max_file_size_available' => "允許的最大檔大小 %1",
    '__max_subdom_num_reached_for_cl' => "已達到此客戶帳戶的子域名數量限制。",
    '__max_subdom_num_reached_for_dom' => "已達到域名的子域名數量限制。",
    '__max_subdom_num_reached_for_key' => "已達到許可證允許的子域名數量限制。",
    '__max_traffic_limit' => "流量限制",
    '__maximum_excl_ip_num' => "郵件帳戶",
    '__mb' => "MB",
    '__mbytes' => "MB",
    '__mb_month' => "MB/月",
    '__mb_sec' => "MB/秒",
    '__gb_sec' => "GB/秒",
    '__tb_sec' => "TB/秒",
    '__mega' => "M",
    '__minute(s)' => '分鐘',
    '__mls_not_in_key' => "您的產品許可證不支援多語言介面。",
    '__modification_date' => "修改日期",
    '__module' => "擴展名",
    '__month' => "月",
    '__month(s)' => "月",
    '__month1' => "一月",
    '__month10' => "十月",
    '__month11' => "十一月",
    '__month12' => "十二月",
    '__month2' => "二月",
    '__month3' => "三月",
    '__month4' => "四月",
    '__month5' => "五月",
    '__month6' => "六月",
    '__month7' => "七月",
    '__month8' => "八月",
    '__month9' => "九月",
    '__monthly' => "每月",
    '__months' => "月",
    '__moved_permanently' => '已永久移動',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "伺服器",
    'mssql__server' => "Microsoft SQL Server 伺服器名稱。",
    'mssql__unable_to_change_server_name_db_exists' => "不能更改伺服器名稱：因為其中至少有一個資料庫。",
    '__mssql_status' => "Microsoft SQL Server 伺服器狀態",
    '__multiply_login_deny' => "您無法登入。已有其它用戶使用相同的用戶名 (%1) 登入到 Plesk。",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL伺服器狀態",
    '__mysql_version' => "Mysql版本",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB 伺服器狀態",
    '__mariadb_version' => "MariaDB 版本",
    '__percona' => "Percona",
    '__percona_status' => "Percona 伺服器狀態",
    '__percona_version' => "Percona 版本",
    '__name' => "名稱",
    '__name_invalid' => "無效名稱。",
    '__nameserver' => "域名伺服器",
    '__network' => "網路",
    '__networks' => "網路",
    '__no' => "否",
    '__no_ip_address_with_properly_type_available' => "無法恢復備份資料，因為沒有匹配的 IP 位址用於恢復。",
    '__no_clients_specified' => "未指定客戶帳戶。",
    '__no_comments' => "無注釋。",
    '__no_ip_specified' => "尚未指定IP。",
    '__nologin' => "禁止",
    '__none' => "無",
    '__not_configured' => "未配置",
    '__not_implemented_yet' => "尚未執行",
    '__not_supported_by_ftp' => "(不被 FTP 伺服器支援)",
    '__not_supported_by_mailmng' => "郵件伺服器不支援",
    '__notification' => "通知",
    '__num_displayed' => "顯示了 %1 個(共 %2 個)",
    '__num_is_invalid' => "數值無效。",
    '__object_not_found' => '對象未找到：%1',
    '__of_all' => "%（占總量比例）",
    '__off' => "停用",
    '__ok' => "確定",
    '__old_passwd' => "原有%1密碼",
    '__on' => "啟用",
    '__others' => "其他",
    '__other_ip__will_be_added' => '其他可用的IP地址(將被添加至客戶IP池)',
    '__out' => "流出",
    '__p' => "P",
    '__passwd' => "%1密碼",
    '__passwd_hint' => "至少 5 個字元，而且不能有國家字元",
    '__passwd_is_invalid' => "%1密碼無效。",
    '__passwd_not_match' => "密碼不匹配!",
    '__path' => "路徑",
    '__perl_unix_support' => "Perl支援",
    '__perl_win_support' => "Perl支援",
    '__perm_denied' => "拒絕存取。",
    '__permissions' => "許可權",
    '__personal_name' => "個人姓名",
    '__pg_admin_not_activated' => "PostgreSQL尚未在伺服器管理頁啟用。",
    '__pg_not_inst' => "PostgreSQL 尚未安裝。",
    '__pg_not_run_or_inst' => "PostgreSQL 尚未安裝或沒有運行。",
    '__pg_not_support_in_key' => "許可證不支援 PostgreSQL",
    '__phone' => "電話",
    '__phosting' => "物理主機",
    '__php_support' => "PHP 支援",
    '__php_run_as_isapi' => "作為 ISAPI 擴展運行",
    '__php_safe_mode' => "PHP'safe_mode'開啟",
    '__php_version' => "PHP 版本",
    '__physical' => "物理主機",
    '__plesk_stat_pdir' => "保護目錄 \"/plesk-stat/webstat/\"",
    '__plesk_stat_dir_name' => "域名統計",
    '__plesk_stat_protect' => "使用使用者的 FTP 用戶名和密碼對網站統計存取權限加以保護",
    '__plesk_stat_protect_install' => "可通過有密碼保護的目錄 '/plesk-stat/webstat/' 進行存取",
    '__plesk_stat_webstat_not_activate' => "您未選擇用於此網站的網站統計程式。",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3 伺服器狀態",
    '__popen_error' => "調用 popen 函數時出錯。",
    '__port' => '埠',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL 狀態",
    '__preferences' => "設定",
    '__account_preferences' => "帳戶設定",
    '__interface_preferences_general' => '常用',
    '__interface_preferences_default' => '預設介面偏好設定',
    '__interface_preferences_admin' => "管理員介面偏好設定",
    '__interface_template' => '介面自訂範本',
    '__interface_preferences' => "介面偏好設定",
    '__proceed?' => "是否繼續？",
    '__protect_dir_user' => "受保護 URL 用戶",
    '__protect_dir_users' => "受保護 URL 用戶",
    '__protect_dirs' => "受保護目錄",
    '__provider_contact_name' => "所有者的聯繫名稱",
    '__python_unix_support' => "Python支援",
    '__python_win_support' => "Python支援",
    '__quota' => "配額",
    '__r' => "R",
    '__reconfigure' => "重新配置",
    '__record_type' => "記錄類型",
    '__release' => "發行版本本",
    '__remote_db_not_supported_by_key' => '您的許可證不支援遠端資料庫主機。',
    '__remove' => "移除",
    '__remove_confirmation' => "確認刪除",
    '__remove_protection' => '移除受保護內容',
    '__report' => "報告",
    '__report_auto' => '發送計畫',
    '__report_form' => "報告格式",
    '__report_size_na' => "服務不可用",
    '__reports_list' => "報告",
    '__requested' => "請求值",
    '__required_fields' => "必填欄位",
    '__resp_name_invalid' => "自動回復名稱無效。只能使用字母、數位、點、底線和空格。",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "伺服器名稱無效。",
    '__screenshots' => '螢幕截圖',
    '__script_warning' => "通過從域名中刪除無用的腳本功能，瀏覽器調用時所有受影響的腳本將以明文形式顯示。建議管理員從給定域名中刪除所有相關腳本。",
    '__sec' => "秒",
    '__second(s)' => "秒",
    '__see_list_of_logged_in' => "查看當前登入用戶的列表。",
    '__select_certs_to_remove' => "選擇要刪除的證書。",
    '__select_domains_to_default_host' => "選擇要設為預設值的域名。",
    '__select_domains_to_remove' => "選擇要刪除的域名。",
    '__type_domain_name_to_add' => "請輸入要添加的域名。",
    '__select_files_to_remove' => "選擇要刪除的檔。",
    '__select_ip' => "分配IP地址",
    '__select_ip_to_remove' => "選擇要刪除的 IP 位址。",
    '__select_domain_template' => "使用域名範本設定",
    '__select_templates_to_remove' => "選擇要刪除的範本。",
    '__server' => "伺服器",
    '__server_total' => "伺服器總數",
    '__service' => "服務",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL 資料庫伺服器",
    '__service_description__mysql' => "MySQL 資料庫伺服器",
    '__service_title__web' => "Web 伺服器",
    '__service_description__web' => "Web 伺服器",
    '__service_title__smtp' => "SMTP 伺服器",
    '__service_description__smtp' => "SMTP 伺服器",
    '__service_title__mail' => "IMAP/POP3 伺服器",
    '__service_description__mail' => "IMAP/POP3 伺服器",
    '__service_title__dns' => "DNS 伺服器",
    '__service_description__dns' => "DNS 伺服器",
    '__service_title__postgresq' => "PostgreSQL 資料庫伺服器",
    '__service_description__postgresq' => "PostgreSQL 資料庫伺服器",
    '__service_title__spamassassin' => "SpamAssassin 垃圾郵件過濾服務",
    '__service_description__spamassassin' => "SpamAssassin 垃圾郵件過濾服務",
    '__services' => "服務",
    '__all_services' => "所有服務",
    '__sessions' => "會話",
    'sessions__feature_ftp_session_manager_not_supported' => "當前的 FTP 伺服器不支援 FTP 會話功能。",
    '__sessions_list' => "會話",
    '__set' => "啟用",
    '__setup_logo_pref' => "徽標",
    '__shared' => "共用",
    '__shell_access_warning' => "允許存取系統對系統安全十分危險。僅在您清楚瞭解自己在做什麼時才允許存取系統，並且僅允許信任的使用者存取系統。您真的要允許對於系統的存取嗎？",
    '__siteapp_not_support_in_key' => "許可證不支援Web應用程式",
    '__siteapp_cannot_reconfigure_with_remote_database' => '該 web 應用程式的配置已被手動修改。為了保護手動修改資料，通過 Plesk 進行重新配置已被設定不可用。',
    '__site_management' => "Web 發佈", // indirect
    '__size' => "大小",
    '__skeleton' => '虛擬主機範本',
    '__skins' => '皮膚',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP 伺服器狀態",
    '__some_fields_are_empty_or_invalid' => "一些欄位為空或者含有不正確的值。",
    '__spamassassin' => "垃圾郵件篩檢程式",
    '__spamassassin_status' => "SpamAssassin狀態",
    '__spamd_status' => '垃圾郵件篩檢程式狀態',
    '__splited_backup' => "(多卷備份)",
    '__split_backup_file' => "創建多卷備份",
    '__split_backup_size' => "卷大小",
    '__split_backup_less_than_500' => "不支援大於500MB的卷",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI支援",
    '__ssi_with_html' => "使用*.htm, *.html文件用於SSI",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS 支援",
    '__same_ssl' => "使用一個目錄存放 SSL/TLS 和非 SSL/TLS 內容",
    '__same_ssl_cu' => "通用的 SSL/TLS 和非 SSL/TLS 內容",
    '__state' => "省/市/自治區",

    '__status__Active' => '活動',
    '__status__active' => '活動',
    '__status__Passive' => '已關閉',
    '__status__passive' => '禁用',
    '__status__off' => '禁用',
    '__status__with_parent' => '禁用',
    '__status__backup_restore' => '備份或恢復功能已暫時停用',
    '__status__admin' => '由管理員掛起',
    '__status__resseler' => '由零售商掛起',
    '__status__client' => '由客戶掛起',
    '__status__unknown' => '未知狀態',

    '__status_of' => "%1狀態",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel 伺服器", // indirect
    '__subdomain' => "子域名",
    '__subdomain_name' => "子域名",
    '__subdomain_name_in_ASCII_form' => "ASCII格式的子域名",
    '__subdomains' => "子域名",
    '__domainaliases' => "域名別名",
    '__subdomains_list' => "子域名",
    '__subdomains_not_support_in_key' => "許可證不支援子域名操作",
    '__sys_user_type' => "FTP 用戶",
    '__sys_user_type_main' => "使用主域名的 FTP 使用者帳戶",
    '__sys_user_type_native' => "為子域名創建一個獨立 FTP 使用者帳戶",
    '__t' => "T",
    '__target_domain' => "目標域名",
    '__template' => "範本",
    '__template_not_accepted' => "無法接受範本：超出下列限制。",
    '__templates' => "範本",
    '__templates_list' => "範本",
    '__tera' => "T",
    '__title' => "標題",
    '__tools' => "工具",
    '__total' => "所有%1",
    '__total_size' => "總計大小",
    '__total_used' => "總計使用",
    '__traffic' => "流量",
    '__traffic_by_client' => "客戶流量",
    '__traffic_by_domain' => "域名流量",
    '__traffic_by_service' => "服務流量",
    '__traffic_history' => "流量歷史",
    '__unable_change_locale' => "無法更改介面語言：%1",
    '__unable_create_new_dom' => "無法創建域名：%1",
    '__unable_define_dom_name' => "無法定義域名：%1",
    '__unable_define_necessary_properties' => "無法定義所有需要的屬性。",
    '__unable_define_properties' => "無法定義屬性：%1。",
    '__unable_exec_util' => "無法執行實用程式：%1",
    '__unable_get_dns_a_recs' => "無法檢索 IP 位址查找該主機帳戶的 A DNS 記錄：%1",
    '__unable_get_mbox_quota' => "無法檢索郵箱配額的資訊。",
    '__unable_redirect_to_myself' => "無法轉發到同一帳戶。",
    '__unable_redirect_to_my_alias' => "無法轉發到郵件別名。",
    '__default_domain_redirect_to_myself' => "無法將域名設定為IP地址的默認域名：\n系統檢測到它會重定向到自身。",
    '__unable_remove_client' => "無法刪除客戶: %1",
    '__unable_set_up_mbox_quota' => "無法設定郵箱限額：%1。",
    '__unable_setup_pass' => "無法設定密碼：%1。",
    '__unable_to_create_new_account' => "無法創建帳戶：%1",
    '__unable_to_define_db_size' => "無法定義資料庫大小。",
    '__unable_to_enable_short_names' => "無法允許POP3/IMAP帳戶使用郵件縮寫名。",
    '__unable_to_fetch_data_from_submit' => "無法獲取提交的資料：%1",
    '__unable_to_open_file' => "無法打開文件%1: %2",
    '__unable_to_update_subdomain' => "無法更改子域名：%1。",
    '__unable_update_cl_data' => "無法保存對使用者帳戶所做的更改: %1",
    '__unable_update_db_params' => "無法更新資料庫參數：%1。",
    '__unable_update_dom_data' => "無法更新域名資訊：%1。",
    '__undefined' => "未定義",
    '__uninstall' => "卸載",
    '__unknown_error' => "未知錯誤",
    '__unlimited_lower' => "無限",
    '__unset' => "禁用",
    '__update' => "更新",
    '__uploaded_file_is_invalid' => "上傳檔無效：%1。",
    '__url' => "URL",
    '__usage' => "磁碟空間",
    '__user' => '用戶',
    '__user_already_logged' => "相同用戶名 (%1) 的其它用戶已經登入到 Plesk。",
    '__version' => "版本",
    '__aps_license' => "許可證金鑰",
    '__vh_type' => "虛擬主機類型",
    '__vhosts_apache_status' => "Web 伺服器狀態",
    '__wrong_charset_conversion' => '字元集錯誤，不允許從%1轉換到%2',
    '__warning_' => "警告!",
    '__warning_excl_ip_num' => "獨立 IP 位址",
    '__warning_expiration' => "到期日",
    '__web_scripting' => "Web 腳本", // indirect
    '__web_serv' => "Web 伺服器", // indirect
    '__web_statistic' => "網站統計", // indirect
    '__webmail' => "web 郵箱", // +indirect
    '__webstat_not_installed' => "Webalizer目前尚未在此伺服器上安裝。 請聯繫伺服器管理員來安裝Webalizer。",
    '__webstat_support' => "網站統計",
    '__webstat_awstats_support' => "AWstats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWstats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "當您切換統計程式時，系統會刪除之前所用的統計程式創建的所有報告，還會根據從伺服器上所保留的日誌檔讀取到的資訊來創建新報告。這意味著如果您配置系統(位於“域名 > 域名 > 日誌管理器 > 日誌迴圈”)僅保留上月的日誌檔，則網站統計僅適用於上月。您確定要切換到另一統計套裝程式嗎？",
    '__webstat_perm_denied' => '您尚無管理網站統計的許可權。',
    '__webuser' => "網站用戶",
    '__sysusers_list' => "系統使用者",
    '__sysuser' => "系統使用者",
    '__weekly' => "每週",
    '__whats_new_in_version' => "Plesk %1 新增功能？",
    '__wrong_hosting_type__none' => '域名%1上沒有配置虛擬主機。',
    '__wrong_hosting_type__std_fwd' => '域名 %1 已配置標準轉發。該操作只適用於帶有主機的域名。',
    '__wrong_hosting_type__frm_fwd' => '域名 %1 已配置幀轉發。該操作只適用於帶有主機的域名。',
    '__wu' => "網站用戶",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW 首碼已更改。請務必相應地修改 SSL/TLS 證書。",
    '__year' => "年",
    '__year(s)' => "年",
    '__yes' => "是",
    '__you' => "您",
    '__zip_code' => "郵遞區號",
    '__form_normal' => "正常",
    '__form_advanced' => "高級",

    'admin_ed__edit_administrator_info' => "編輯管理員資訊",
    'admin_ed__create_default_client' => "我想創建一個預設客戶帳戶。",
    'admin_ed__unable_update' => "無法更新管理員資訊：%1。",

    'auth__update_admin_info' => "請輸入管理員資訊。操作%1需要用到此資訊。",
    'auth__you_not_have_perm' => "您無權管理此域名。",
    'auth__key_expired_admin' => '您的 Plesk 許可證已到期。要繼續使用 Plesk，請續訂更新您的許可證或購買新的許可證。',
    'auth__key_expired_admin_restricted' => '您的 Plesk 許可證已到期。請聯繫您的服務提供者以繼續使用 Plesk。',
    'auth__key_expired_client' => 'Plesk 許可證已到期。請聯繫您的主機提供商。',
    'autoinstaller__not_installed' => '未安裝自動安裝程式元件。',
    'autoinstaller__release_action' => '可用操作',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => '升級到新的 Plesk 版本',
    'autoinstaller__release_action_update' => '更新或添加新組件',
    'autoinstaller__release_action_up2date' => '此為最新版',
    'autoinstaller__component_action' => '狀態',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => '尚未安裝',
    'autoinstaller__component_action_update' => '有可用的更新',
    'autoinstaller__component_action_upgrade' => '有可用的更新。',
    'autoinstaller__component_action_up2date' => '此為最新版',
    'autoinstaller__component_action_error' => '更新不可用',
    'autoinstaller__component_serverbuildtime' => '最新版本',
    'autoinstaller__component_localbuildtime' => '您的版本',
    'autoinstaller__component_installed_version' => '您的版本',
    'autoinstaller__component_available_version' => '最新版本',
    'autoinstaller__component' => '組件',
    'autoinstaller__components' => '組件',
    'autoinstaller__components_title' => '%1 組件',
    'autoinstaller__component_dependency_note' => '安裝所選元件時需要',
    'autoinstaller__install_confirm' => '是的，我希望安裝這些組件。',
    'autoinstaller__install_confirm_request' => '請勾選核取方塊進行確認',
    'autoinstaller__install_title' => '確認安裝所選組件。',
    'autoinstaller__key_update_confirm' => '確認跳過許可證更新，並安裝默認許可證',
    'autoinstaller__key_update_confirm_request' => '請選中核取方塊以進行確認。',
    'autoinstaller__key_update_failed' => '<p> Plesk 無法更新您的產品許可證。</p> <p> %1</p> <p> 在沒有合適的產品許可證的支援下繼續升級會導致安裝帶有功能限制的默認許可證。建議管理員在繼續產品升級之前首先獲取合適的許可證金鑰。</p>',
    'autoinstaller__email' => '發送通知到',
    'autoinstaller__email_admin' => "管理員的電子郵件",
    'autoinstaller__email_email' => '自訂電郵地址…',
    'autoinstaller__release' => '版本名稱',
    'autoinstaller__releases' => '可用版本',
    'autoinstaller__releases_title' => 'Plesk 更新程式',
    'autoinstaller__select_components_to_install' => '請選擇要安裝的組件。',
    'autoinstaller__status_error' => '錯誤: %1',
    'autoinstaller__status_install_error' => '安裝無法開始: %1',
    'autoinstaller__status_install_busy' => '安裝無法開始：另一個安裝過程正在運行。',
    'autoinstaller__status_install_ok' => '安裝開始。您將通過電子郵件 (%1) 獲知安裝的進度。',
    'autoinstaller__status_query_busy' => '正在安裝。',
    'autoinstaller__status_query_error' => '無法檢索安裝狀態：%1。',
    'autoinstaller__status_unknown' => '無法檢索自動安裝程式狀態。',
    'autoinstaller__status_busy' => '自動安裝程式繁忙，請稍候。',
    'autoinstaller__configure_title' => '更新程式設定',
    'autoinstaller__preferences_legend' => '設定',
    'autoinstaller__target' => '臨時下載目錄',
    'autoinstaller__target_invalid' => "指定絕對路徑",
    'autoinstaller__check_updates' => '以管理員身份登入到 Plesk 時檢查更新',
    'autoinstaller__check_updates_warning' => '新的<a href="%1">更新</a>可用于 %2',
    'autoinstaller__source_type' => '來源類型',
    'autoinstaller__source' => '源 URL',
    'autoinstaller_source__preferences_legend' => '設定',
    'autoinstaller_source__type' => '來源類型',
    'autoinstaller_source__url_invalid' => '無效來源',
    'autoinstaller_source__url_invalid_network' => '無效的源URL (示例：http://source, ftp://source)',
    'autoinstaller_source__url' => '源 URL',
    'autoinstaller__source_invalid_network' => '您所指定的網路位址無效',
    'backup__repository' => '備份檔案存儲位置',
    'backup__error_notify_email' => '如果備份過程中出現錯誤，請發送通知到郵箱',
    'backup__dump_info' => "備份信息",
    'backup__dump_file_name_not_defined' => "尚未指定備份檔案名。",
    'backup__local_file' => '本地備份檔案',
    'backup__domain_ftp' => '遠端FTP 伺服器',
    'backup__wrong_path' => "進入備份檔案存儲的不正確的路徑：不要使用字元的序列../../",
    'backup__unable_to_connect_to_ftp_server' => "無法連接到 FTP 伺服器：%1。",
    'backup__unable_to_read_file' => '無法讀取備份檔案。',
    'backup__backup_task_does_not_exist' => "備份任務不存在，您必須在開始前創建備份任務。",
    'backup__restore_params' => "恢復參數",
    'backup__confirmation' => "警告: 在備份/恢復過程中域名將暫不可用。",
    'backup__backup_method' => '備份方式',
    'backup__dumpfile_name' => "備份檔案名稱",
    'backup__dumpfile_name_is_invalid' => "備份檔案名無效: 只能使用字母數位、破折號、點和底線，請不要使用類似description.* 的名稱作為備份檔案名。",
    'backup__email_required' => "請提供電郵地址，以便通知您備份/恢復進度。請在帳號資訊頁上指定電郵地址。",
    'backup__error_during_backup' => "無法創建備份檔案：%1。",
    'backup__input_email_warning' => "您必須指定用於通知的電子電郵地址，或清空此核取方塊。",
    'backup__make_download' => "不要保存存儲中的備份檔案，只下載備份檔案",
    'backup__make_dump' => '創建備份檔案並存在本機存放區中',
    'backup__makedump_to_ftp' => '創建備份檔案並將其存儲在 FTP 伺服器上',
    'backup__restore_ip' => "用於恢復的 IP 地址",
    'backup__select_dumpfile' => "選擇備份檔案。",
    'backup__time' => "備份時間",
    'backup__day' => '備份日期',
    'backup__view_dump_info' => "查看域名%1的備份信息。",
    'backup__wrong_domain_name' => "備份檔案包含的是域名%1的資料，因而不能用於恢復域名%2。",
    'backup__incorrect_ftp_user_or_passwd' => "不正確的FTP使用者或密碼。請修正“FTP帳戶屬性”",
    'backup__access_denied' => "拒絕存取。請修正“FTP帳戶屬性”",
    'backup__restore_from' => "恢復%1",
    'backup__domain_session_failed' => '尚未備份域名%1',
    'backup__client_session_failed' => '尚未備份客戶%1',
    'backup__domain_session_restore_failed' => '尚未恢復域名%1',
    'backup__client_session_restore_failed' => '尚未恢復帳戶%1',
    'backup__domain_session_complete' => '備份了域名%1',
    'backup__domain_session_backup' => '備份域名%1',
    'backup__client_session_backup' => '備份客戶%1',
    'backup__domain_stop_title' => '取消備份域名%1',
    'backup__client_stop_title' => '正在取消備份客戶帳戶%1',
    'backup__domain_restore_stop_title' => '取消恢復域名%1',
    'backup__client_restore_stop_title' => '正在取消恢復客戶帳戶%1',
    'backup__domain_session_backup_stop' => '您正要取消活動的備份過程。不會創建備份檔案。',
    'backup__backup_stop_confirm' => '是的，我想要停止備份過程',
    'backup__restore_stop_confirm' => '是，我想要停止恢復過程',
    'backup__domain_session_restore' => '恢復域名%1',
    'backup__domain_session_restore_stop' => '您正要取消活動的恢復過程。',
    'backup__domain_backup_file_info' => '域名備份檔案信息',
    'backup__domain_backup_file_list' => '現有備份檔案',
    'backup__domain_backup_progress' => '備份網站%1過程',
    'backup__domain_restore_progress' => '恢復網站%1過程',
    'backup__domain_backup_progress_elapsed_time' => '用時：%1',
    'backup__domain_restore_progress_elapsed_time' => '用時：%1',
    'backup__ip_map_legend' => 'IP映射',
    'backup__ip_map_list_count' => 'IP地址',
    'backup__domain_restore_session_complete' => '域名%1已恢復。',
    'backup__domain_restore_session_complete_message' => '域名%1已恢復。',
    'backup__domain_backup_file_delete' => '刪除下列備份檔案：',
    'backup__domain_backup_file_for_remove' => '選擇要刪除的備份檔案',
    'backup__backup_overwrite_file_confirm' => '確認替換',
    'backup__backup_overwrite_file_confirm_text' => '名為“%1”的備份檔案已存在。您想要替換它嗎？',
    'backup__backup_confirm_overwrite' => '確認文件替換',
    'backup__backup_overwrite_legeng' => '替換',
    'backup__backup_not_contain_domain' => '備份檔案不包含關於域名%1的資訊',
    'backup__backup_not_contain_client' => '備份檔案不包含客戶帳戶%1相關資訊。',
    'backup__backup_client_info' => "備份客戶設定和帳戶詳情",
    'backup__client_backup_progress' => '客戶帳戶%1備份過程',
    'backup__client_session_complete' => '客戶帳戶%1備份完成',
    'backup__client_backup_file_info' => '客戶備份檔案資訊',
    'backup__restore_client_info' => "恢復客戶設定和帳戶詳細資訊",
    'backup__client_session_restore' => '正在恢復客戶帳戶%1',
    'backup__client_db_server_map' => '資料庫伺服器映射',
    'backup__domain_db_server_map' => '資料庫伺服器映射',
    'backup__client_restore_session_complete_message' => '客戶帳戶%1已恢復。',
    'backup__client_restore_session_complete' => '客戶帳戶%1已恢復。',
    'backup__restore_select_some' => '請選擇要恢復的對象。',
    'backup__client_restore_progress' => '客戶帳戶%1恢復過程',
    'backup__new_backup' => '創建備份',
    'backup__done' => '完成：',
    'backup__done_domains' => '%1 個域名/ %2',
    'backup__done_clients' => '%2中的%1客戶',
    'backup__remaining' => '剩餘：',
    'backup__remaining_domains' => '%1 個域名',
    'backup__remaining_clients' => '%1客戶',
    'backup__overall_backup_progress' => '整個備份過程',
    'backup__comment_n_a' => 'n/a',
    'backup__command_ignore' => '命令“%1”已忽略',
    'backup__no_objects' => '無可備份的對象',
    'backup__cli_warning_not_enough_ip' => '警告：沒有足夠的IP位址來執行默認的IP映射：',
    'backup__local_repository' => "Plesk 的存儲",
    'backup__ftp_repository' => 'FTP 存儲',
    'backup__ftp_login' => '用戶名',
    'backup__ftp_password' => '密碼',
    'backup__ftp_directory_hint' => '示例：/myfolder/mybackups',
    'backup__ftp_account_settings' => 'FTP帳戶設定',
    'backup__ftp_account_preferences' => 'FTP帳戶設定',
    'backup__repository_not_exist' => '目錄不存在',
    'backup__repository_not_readable' => '指定的目錄不可讀',
    'backup__ftp_repository_not_configure' => '若要使用 FTP 備份存儲，請首先 <a href="%1">指定 FTP 帳戶</a />。',
    'backup__ftp_repository_list_not_configure' => '帳戶設定未指定',
    'backup__repository_list_unable_listing' => '無法檢索文件列表',
    'backup__ftp_repository_unable_listing' => '無法檢索目錄清單“%1”：',
    'backup__repository_legend' => '備份檔案存儲',
    'backup__store_in_repository' => '存儲檔於',
    'backup__local_repository_lable' => '本機存放區',
    'backup__ftp_repository_lable' => 'FTP 存儲',
    'backup__ftp_repository_not_configure_hint' => '(帳戶設定尚未指定)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP帳戶尚未指定或不受支援)',
    'backup__ftp_directory_not_exist' => '指定的目錄不存在',
    'backup__other_user_process_modified' => '另一個用戶停止了備份或遷移過程。',
    'backup__another_user_exist' => '正在進行的操作由其它 Plesk 用戶開始。該使用者仍處於登入到 Plesk 的狀態。',
    'backup__ftp_repository_wait' => '正在索取有關 FTP 存儲的資訊請稍後',
    'backup__ftp_write_test_failed' => '向FTP帳戶%1寫入測試資料失敗：',
    'bt_upload_to_repository' => '上傳文件到本機存放區',
    'bt_new_restore' => "恢復",
    'bt_backup_schedule' => "計畫備份",
    'backup_exist_backups' => "現有備份檔案",
    'backup_dialog__page_title' => "創建備份檔案",
    'backup_dialog__please_wait' => "備份過程即將開始。 此操作可能需要一些時間。請稍候...",
    'backup_conf__page_title' => '備份配置',
    'bt_accept' => "接受",
    'bt_access' => "存取",
    'bt_action_log' => "操作日誌",
    'bt_add' => "添加",
    'bt_add_client' => "分配給用戶",
    'bt_database_server_add' => '添加資料庫伺服器',
    'bt_add_services' => "添加服務",
    'bt_add_address_to_acl' => '添加地址',
    'bt_anonftp_stats' => "匿名 FTP 數據",
    'bt_anonymous_ftp' => "匿名FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "附加",
    'bt_autoinstaller' => '更新程式',
    'bt_auto-updates' => '更新程式',
    'bt_back' => "<< 返回",
    'bt_backup' => "備份",
    'bt_backup_configure' => "備份設定",
    'bt_buy_certs' => "購買證書",
    'bt_blocked_domains' => '黑名單',
    'bt_blocked_domain_add' => '添加網站',
    'bt_card' => "卡",
    'bt_cert' => "證書",
    'bt_certificates' => "證書",
    'bt_change_passwd' => "更改密碼",
    'bt_clean_log' => "清除日誌",
    'bt_clear' => "清空",
    'bt_client_templates' => "客戶範本",
    'bt_clients' => "客戶",
    'bt_codepage_change' => '更改',
    'bt_comp_info' => "組件管理",
    'bt_common_acl' => '傳輸限制範本',
    'bt_configure_maillists' => "Mailman 設定",
    'bt_configure_odbc' => "ODBC資料來源",
    'bt_configure' => '配置',
    'bt_copy' => "複製",
    'bt_copy_move' => "複製/移動",
    'bt_create' => "創建",
    'bt_create_account' => "創建帳戶",
    'bt_create_dir' => "添加目錄",
    'bt_create_file' => "添加文件",
    'bt_count_size' => "計算大小",
    'bt_crontab_unix' => "定期任務",
    'bt_crontab_win' => "任務計畫程式",
    'bt_custom_button_new' => "添加按鈕",
    'bt_custom_buttons' => "自訂按鈕",
    'bt_customize' => "自訂",
    'bt_databases' => "資料庫",
    'bt_database_servers' => '資料庫伺服器',
    'bt_sqlservers' => "資料庫伺服器",
    'bt_db_usr_new' => "添加資料庫使用者",
    'bt_db_new' => "添加資料庫",
    'bt_db_phpmyadmin' => "MySQL管理員",
    'bt_dbuser_default' => "DB WebAdmin預設值",
    'bt_decline' => "拒絕",
    'bt_default' => "默認",
    'bt_defaultcomponents' => "協力廠商服務",
    'bt_defaults' => "默認",
    'bt_delete' => "刪除",
    'bt_directories' => "受保護目錄",
    'bt_disable' => "關閉",
    'bt_dns' => "DNS設定",
    'bt_dns_add' => "添加DNS記錄",
    'bt_dnsrecord_add' => '添加DNS記錄',
    'bt_dns_soa' => "SOA記錄範本",
    'bt_dns_zone_settings_template' => "區域設定範本",
    'bt_dns_preferences' => "DNS遞迴",
    'bt_do_backup' => "備份",
    'bt_do_restore' => "恢復",
    'bt_do_upload' => "上傳",
    'bt_domain_aliases' => "域名別名",
    'bt_domain_templates' => "域名範本",
    'bt_domain_user' => "域名管理員",
    'bt_domain_user_passwd' => "域名管理員密碼",
    'bt_domains' => "域名",
    'bt_domain_alias_add' => '添加域名別名',
    'bt_download' => "下載",
    'bt_download_log' => "下載",
    'bt_edit' => "編輯",
    'bt_enable' => "打開",
    'bt_export' => '匯出',
    'bt_extras' => "附加",
    'bt_file_manager' => "檔案管理員",
    'bt_finish' => "完成",
    'bt_ftp_account' => "FTP 帳戶屬性",
    'bt_forget_password' => "忘記密碼？",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP 數據",
    'bt_get_password' => "獲取密碼",
    'bt_global_changes' => "修改",
    'bt_help' => "幫助",
    'bt_hide_aliases' => "隱藏別名",
    'bt_hide_toolbar' => '隱藏工具列',
    'bt_hide_subdomains' => "隱藏子域名",
    'bt_hide_domainaliases' => "隱藏欄位名別名",
    'bt_home' => "首頁",
    'bt_hosting' => "主機",
    'bt_icf' => '防火牆',
    'bt_install' => "安裝",
    'bt_ip_aliasing' => "IP地址",
    'bt_ip_add' => "添加 IP 地址",
    'bt_ip_pool' => "IP 位址集區",
    'bt_key_info' => "授權管理",
    'bt_key_buyonline_addons' => '訂購 Plesk 附加方案',
    'bt_key_buyonline_upgrades' => '訂購 Plesk 升級',
    'bt_key_buyonline_new' => '訂購新的許可證',
    'bt_key_update' => '檢索許可證',
    'bt_key_upload' => '安裝許可證',
    'bt_key_download' => '下載許可證',
    'bt_key_revert' => '恢復許可證',
    'bt_limits' => "限制",
    'bt_locale_add' => '添加區域設定',
    'bt_locales' => '區域設定',
    'bt_log_manager' => "日誌管理器",
    'bt_login' => "登入",
    'bt_login_vzpp' => "登入到 Power Panel",
    'bt_logo' => "品牌自訂",
    'bt_logo_default' => "默認徽標",
    'bt_logo_send_link' => "附加連結",
    'bt_logo_send_logo' => "附加徽標",
    'bt_logout' => "登出",
    'bt_logrotation' => "日誌輪替",
    'bt_mail' => "郵件",
    'bt_mail_alias_add' => "添加郵件別名",
    'bt_mail_aliases' => "郵件別名",
    'bt_mail_group_add' => "添加成員",
    'bt_mail_groups' => "組",
    'bt_mail_name_add' => "添加郵件帳戶",
    'bt_mail_preferences' => "設定",
    'bt_mail_group' => "郵件組",
    'bt_mail_mailbox' => "郵箱",
    'bt_mail_redirect' => "轉發",
    'bt_mail_resp_add' => "添加自動回復",
    'bt_mail_resp_attach_add' => "添加附件",
    'bt_mail_resp_files' => "附件檔",
    'bt_mail_responders' => "自動回復",
    'bt_mail_spamfilter' => "垃圾郵件篩檢程式",
    'bt_mail_webmail' => "web 郵箱",
    'bt_maillist_new' => "添加郵寄清單",
    'bt_maillists' => "郵寄清單",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "創建備份",
    'bt_manage' => "管理",
    'bt_master' => "主控",
    'bt_migrate' => '遷移',
    'bt_modules_add' => '添加擴展',
    'bt_modules_manage' => '管理擴展',
    'bt_move' => "移動",
    'bt_mimetypes' => 'MIME類型',
    'bt_mimetype_new' => '添加MIME類型',
    'bt_new_client' => "添加客戶帳戶",
    'bt_new_domain' => "添加網站",
    'bt_next' => "下一個 >>",
    'bt_next_page' => "下一頁",
    'bt_network_add' => "添加網路",
    'bt_notifications' => "通知",
    'bt_odbc_dsn_add' => "添加 ODBC DSN",
    'bt_off' => "停用",
    'bt_on' => "啟用",
    'bt_on_off' => "開啟/關閉",
    'bt_pd_new' => "添加受保護目錄",
    'bt_pd_user_new' => "添加用戶",
    'bt_performance' => '性能',
    'bt_permissions' => "許可權",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "設定",
    'bt_prev_page' => "上一頁",
    'bt_preview' => '網站預覽',
    'bt_print' => "列印",
    'bt_reboot' => "重啟",
    'bt_reload' => "重新載入",
    'bt_refresh' => "刷新",
    'bt_register' => "註冊",
    'bt_remove' => "移除",
    'bt_enable_selected' => '打開',
    'bt_disable_selected' => '關閉',
    'bt_repair_ip' => "修復 IP",
    'bt_report' => "報告",
    'bt_report_auto' => '報告發送',
    'bt_report_auto_new' => '添加發送計畫',
    'bt_report_new' => "添加佈局",
    'bt_reset' => "重設",
    'bt_restart_services' => "服務管理",
    'bt_save' => "保存",
    'bt_send_by_email' => "通過電子郵件發送",
    'bt_send_file' => "上傳文件",
    'bt_send_mail' => "發送郵件",
    'bt_send_passwd' => "發送密碼",
    'bt_send_text' => "發送文本",
    'bt_server' => "伺服器",
    'bt_server_add' => "添加伺服器",
    'bt_server_preferences' => "伺服器設定",
    'bt_servers_list' => "伺服器",
    'bt_sessions' => "會話",
    'bt_set' => "設定",
    'bt_set_as_default' => "設為預設值",
    'bt_setup' => '設定',
    'bt_show_aliases' => "顯示別名",
    'bt_show_subdomains' => "顯示子域名",
    'bt_show_domainaliases' => "顯示域名別名",
    'bt_shutdown' => "關機",
    'bt_site_apppkgs' => "應用百寶箱",
    'bt_site_apppool' => "應用程式池",
    'bt_application-pool' => "Web應用程式",
    'bt_site_apps' => "Web應用程式",
    'bt_site_app_add' => "安裝應用程式",
    'bt_additional_key_upload' => '上傳新的許可證',
    'bt_additional_key_download' => '下載許可證',
    'bt_additional_key_remove' => '刪除許可證',
    'bt_additional_key_activate' => '啟動',
    'bt_site_builder' => "Presence Builder 支援",
    'bt_skeleton' => '虛擬主機範本',
    'bt_skins' => '皮膚',
    'bt_skin_add' => '添加皮膚',
    'bt_skin_manual' => '自訂 Plesk 皮膚參考', // not used
    'bt_skin_download' => '下載外觀',
    'bt_skin_replace' => '更新外觀',
    'bt_skip' => '跳過',
    'bt_spamassassin' => "垃圾郵件篩檢程式",
    'bt_spamassassin_train' => "培訓",
    'bt_spamfilter' => "垃圾郵件篩檢程式",
    'bt_sshterm' => 'SSH 終端',
    'bt_start' => "啟動",
    'bt_stop' => "停止",
    'bt_recycle' => "回收",
    'bt_statistics' => "統計",
    'bt_subdomain_new' => "添加子域名",
    'bt_subdomains' => "子域名",
    'bt_submit' => "提交",
    'bt_summary_report' => "概要報告",
    'bt_support' => "支援",
    'bt_switch' => "切換",
    'bt_system_time' => "系統時間",
    'bt_task_new' => "添加任務",
    'bt_dom_tmpl_add' => '添加域名範本',
    'bt_cl_tmpl_add' => '添加自訂範本',
    'bt_cron_backup' => '計畫的備份設定',
    'bt_test' => "測試",
    'bt_text' => "文本",
    'bt_touch' => "更改時間戳記",
    'bt_traffic' => "流量",
    'bt_traffic_history' => "流量歷史",
    'bt_tsclient' => "遠程桌面",
    'bt_update' => "更新",
    'bt_upload' => "上傳",
    'bt_upload_from_ftp' => "FTP 上傳",
    'bt_virtualdirs' => '虛擬目錄',
    'bt_virtualdir_new' => '添加虛擬目錄',
    'bt_virtualdir_add' => '添加虛擬目錄',
    'bt_web_app_new' => "安裝Java應用程式",
    'bt_web_stats' => "網站統計",
    'bt_web_stats_ssl' => "網站統計 SSL/TLS",
    'bt_web_user_add' => "添加網站用戶",
    'bt_web_users' => "網站用戶",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_webalizer_preferences' => "網站統計設定",
    'bt_hidden-referrer-add' => '隱藏項',
    'bt_group-referrer-add' => '組引用',
    'bt_whats_new_full' => "參見完整的新功能列表",
    'bt_white_list' => "白名單",
    'bt_white_list_add' => "添加網路",
    'cert_add__unable_set_ca_cert' => "無法設定 CA 證書：%1。",
    'cert_add__unable_set_cert' => "無法設定證書：%1。",
    'cert_add__unable_set_private_key' => "無法設定私密金鑰：%1。",
    'certificates_list__certificate_used_as_default' => "您要刪除的證書中有一個被用作默認的證書。",
    'certificates_list__certificates_assigned_on_ip' => "一個或多個證書已被分配給該 IP 位址/域名。",
    'ch_pass__admin_pass' => "更改管理員密碼",
    'ch_pass__old_pass' => "舊密碼",
    'ch_pass__pass_confirm' => "確認",
    'ch_pass__unable_change_admin_pass' => "無法更改管理員的密碼：%1",
    'check_mail_cycle__aliases' => "檢測到郵件迴圈，位址 \"%1\" 包含在此郵件帳戶的別名中。",
    'check_mail_cycle__autoresponders' => "檢測到郵件迴圈，位址 \"%1\" 包含在此郵件帳戶的自動回復中。",
    'check_mail_cycle__mail_groups' => "檢測到郵件迴圈，位址 \"%1\" 包含在此郵件帳戶的郵件群組中。",
    'check_mail_cycle__mail_name' => "檢測到郵件迴圈，位址 \"%1\" 與此郵件帳戶相符。",
    'check_mail_cycle__redirect' => "檢測到郵件迴圈，位址 \"%1\" 與此郵件帳戶的 forwarder 相符。",
    'check_mail_dup__redirect' => "檢測到重複的轉發，位址“%1”與此郵件帳戶的轉發目標相同。",
    'check_mail_dup__mail_groups' => "檢測到重複的轉發，位址 \"%1\" 包含在此郵件帳戶的郵件組裡。",
    'check_maillist_cycle__admin' => "檢測到郵件迴圈，管理員的電子郵件 \"%1\" 與郵寄清單的地址相符。",
    'check_maillist_cycle__member' => "檢測到郵件迴圈，地址 \"%1\" 與郵寄清單的地址相符。",
    'chk_js__enter_login_and_passwd' => "輸入用戶名和密碼。",
    'chk_js__enter_login_name' => "輸入用戶名。",
    'chk_js__enter_passwd' => "輸入密碼。",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1 的帳號資訊",
    'cl_limits__cl' => "客戶%1的限制",
    'cl_logo__setup_logo_pref' => "設定客戶%1的徽標屬性",
    'cl_new__enter_new_cl_data' => "輸入新客戶資訊",
    'cl_new__unable_to_sent_notification' => '已創建使用者帳戶，但發送客戶通知失敗: %1',
    'cl_perm__all_ip' => "所有可用的 IP",
    'cl_perm__all_ip_based_hst_will_be_nb' => "客戶的所有基於IP的主機帳戶都將被轉換為基於名稱的主機。",
    'cl_perm__allow_client_create_domain' => "您嘗試選擇的欄位僅適用於有權創建域名的客戶。",
    'cl_perm__allow_create_nb_w_ip' => "客戶可以使用%1創建基於名稱的主機",
    'cl_perm__allow_creation_ip_based_hosting' => "允許創建基於 IP 的主機帳戶",
    'cl_perm__available_ips' => "可用 IP",
    'cl_perm__change_limits' => "限制調整",
    'cl_perm__cl_disk_space' => "總計可用的磁碟空間",
    'cl_perm__cl_expiration' => "客戶帳戶有效期",
    'cl_perm__cl_max_box' => "郵箱",
    'cl_perm__cl_max_db' => "資料庫",
    'cl_perm__cl_max_dom' => "域名",
    'cl_perm__cl_max_maillists' => "郵寄清單",
    'cl_perm__cl_max_subdom' => "子域名",
    'cl_perm__cl_max_traffic' => "可用的總流量",
    'cl_perm__cl_max_wu' => "網站用戶",
    'cl_perm__cl_mbox_quota' => "此使用者帳戶的最大郵箱配額",
    'cl_perm__current_maximum_exp_date' => "當前域名的最大有效期為%1；請求%2。",
    'cl_perm__current_maximum_mailbox_quota' => "當前定義的為該使用者帳戶下的郵箱分配的磁碟空間量限制為%1；請求%2。",
    'cl_perm__current_total_requested' => "當前%1的域名限制總值為%2；請求%3。",
    'cl_perm__current_total_requested_dom' => "當前屬於此客戶%1的數量為%2；請求%3。",
    'cl_perm__disk_space' => "最大磁碟空間",
    'cl_perm__dashboard_stdgui' => '使用者介面',
    'cl_perm__dashboard' => '首頁視圖',
    'cl_perm__stdgui' => '標準視圖',
    'cl_perm__manage_dashboard' => '首頁管理',
    'cl_perm__dashboard_and_stdgui' => '允許首頁視圖和標準視圖',
    'cl_perm__dashboard_only' => '僅允許首頁視圖',
    'cl_perm__stdgui_only' => '僅允許標準視圖',
    'cl_perm__edit_cl' => "客戶%1的許可權",
    'cl_perm__exp_date_exceeded' => "您嘗試設定的驗證週期超出了在該客戶的個別域名中指定的限制。",
    'cl_perm__invalid_value' => "無效值，只能使用數位。",
    'cl_perm__limit_disk_space' => "%1 限定總磁碟空間量",
    'cl_perm__limit_expiration' => "%1限定客戶帳戶的有效期",
    'cl_perm__limit_max_box' => "%1 限定郵箱的最大數量",
    'cl_perm__limit_max_db' => "%1 限定資料庫的最大數量",
    'cl_perm__limit_max_dom' => "%1 限定域名的最大數量",
    'cl_perm__limit_max_maillists' => "%1 限定郵寄清單的最大數量",
    'cl_perm__limit_max_subdom' => "%1 限定子域名的最大數量",
    'cl_perm__limit_max_traffic' => "%1 限定總流量",
    'cl_perm__limit_max_wu' => "%1 限定網站用戶的最大數量",
    'cl_perm__limit_mbox_quota' => "%1 限定最大郵箱限額",
    'cl_perm__limits_exceeded' => "您嘗試設定的一或多項限制超出了此客戶的單個域名限制。\n對於客戶帳戶的域名設定的限制總數不能超過對於此客戶的限制總數。",
    'cl_perm__mailbox_quota_exceeded' => "您嘗試設定的郵箱配額超出了此客戶域名中定義的限制。",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "您試圖設定的分配給郵箱的磁碟空間超出定義的伺服器級限制。",
    'cl_perm__make_dumps' => "備份和恢復資料",

    'cl_perm__max_box' => "最大郵箱數量",
    'cl_perm__max_db' => "最大資料庫數量",
    'cl_perm__max_dom' => "域名",
    'cl_perm__max_maillists' => "最大郵寄清單數量",
    'cl_perm__max_subdom' => "子域名",
    'cl_perm__max_traffic' => "最大流量",
    'cl_perm__max_wu' => "最大網站用戶數量",
    'cl_perm__max_dom_aliases' => "域名別名",
    'cl_perm__mbox_quota' => "郵箱配額",
    'cl_perm__not_allow_create_nb_hst' => "客戶無法創建基於名稱的主機。",
    'cl_perm__select_ip_addrs' => "選擇IP位址",
    'cl_perm__this_ip_used_vrt_hst' => "此IP位址用於虛擬主機。\n要刪除此IP位址，請刪除主機服務或將主機類型更改為基於名稱。",
    'cl_perm__unable_off_ipb_creating' => "客戶已經設定了基於IP的主機服務。要禁用該功能，請清空 \"域名創建\" 核取方塊或刪除所有基於IP的主機服務帳戶。",
    'cl_perm__unable_off_nb_creating' => "客戶已經設定了基於名稱的主機服務。要禁用該功能，請清空 \"域名創建\" 核取方塊或刪除所有基於名稱的主機服務帳戶。",
    'cl_perm__unable_set_domain_limit' => "無法限制域名的最大數量: 客戶已經擁有%1個域名",
    'cl_perm__unable_update_client_limitations' => "無法修改客戶帳戶限制: %1",
    'cl_pref__edit_cl' => "客戶%1的偏好設定",
    'class_anonftp__create_ftp_domain' => "此域名 ID 沒有 FTP 虛擬域名，請先創建。",
    'class_anonftp__incoming_disk_space_should_be_lower' => "您試圖設定的磁碟空間限制(%1)不應超過所定義的域名級總磁碟空間限制(%2)。",
    'class_anonftp__invalid_input_only_digits' => "指定值無效，只能使用數位。",
    'class_anonftp__unable_change_ownerships' => "無法更改配額文件的所有者和許可權：%1。",
    'class_anonftp__unable_copy_quota_file' => "無法複製配額檔：%1。",
    'class_anonftp__unable_get_disk_usage' => "無法檢索接收目錄的磁碟空間使用資訊：%1。",
    'class_anonftp__unable_parse_quota_file' => "無法分析配額檔。",
    'class_anonftp__unable_read_quota_file' => "無法讀取配額文件：%1。",
    'class_anonftp__unable_update_quota' => "無法更新配額: 在接收目錄裡的檔使用了%1 KB的磁碟空間，它超過了新的配額值。",
    'class_anonftp__unable_write_temp_file' => "無法寫入暫存檔案：%1。",
    'class_bsdomain__warn_max_date__' => "過期日設為%1",
    'class_cList__empty' => "尚無項目。",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "尚未在%2中找到<b>“%1”</b>的匹配項 (%4中的%3)。",
    'class_cList__search_result' => "在 %2 中搜尋 <b>\"%1\"</b> 的結果(%4 中的 %3)",
    'class_client__client_creation_notification' => "客戶創建通知。",
    'class_client__client_with_contact_name_already_exists' => "名為%1的客戶已存在。",
    'class_client__disk_space' => "磁碟空間",
    'class_client__invalid_max_dom' => "無效的域名數量詞，只能使用數位。",
    'class_client__limit_exceed' => "%1所請求的量無法分配，因為這超出了客戶%2的帳戶分配(%3)。如果您要分配更多的資源，請轉到“客戶 > 客戶名稱 > 限制”並按照需要更改分配。然後返回此螢幕並嘗試再次調整分配。",
    'class_client__limit_exceed_unlimited' => "如果您要分配無限的資源量(%1)，那麼您應轉到“客戶 > 客戶名稱 > 限制”並選中與所選資源類型相對應的“無限”核取方塊。然後返回此螢幕並嘗試再次調整分配。",
    'class_client__max_box' => "郵箱",
    'class_client__max_db' => "資料庫",
    'class_client__max_maillists' => "郵寄清單",
    'class_client__max_subdom' => "子域名",
    'class_client__max_traffic' => "最大流量",
    'class_client__max_wu' => "網站用戶",
    'class_client__max_dom_aliases' => "域名別名",
    'class_client__mbox_quota' => "郵箱配額",
    'class_client__unable_define_cl_status' => "無法定義客戶帳戶狀態: %1",
    'class_client__unable_define_inactive_dom' => "無法定義非活動域名%1。",
    'class_client__unable_del_ip' => "無法刪除 IP：%1",
    'class_db__db_name_not_set' => "尚未定義資料庫名稱。",
    'class_db__db_not_exist_for_curr_dom' => "此域名沒有資料庫。",
    'class_db__invalid_db_or_dom_name' => "域名或資料庫ID無效，或尚未定義資料庫名稱。",
    'class_db__invalid_pass' => "密碼無效。",
    'class_db__mailgrp_member_exist' => "郵件組成員已存在。",
    'class_db__access_hosts_notsupport' => '此資料庫類型不支援存取主機設定',
    'class_db__unable_add' => '無法添加主機存取記錄：%1',
    'class_db__unable_del' => '無法刪除主機存取記錄：%1',
    'class_db__inc_user_not_exist' => '資料庫使用者%1不存在',
    'class_db__inc_access_record_exist' => '此存取記錄已存在',
    'class_db__inc_access_record_not_exist' => '指定的存取記錄不存在',
    'class_db__inc_unable_del_last_record' => '無法刪除最後一次主機存取記錄',
    'class_domtmpleditform__dns_master' => "主控",
    'class_domtmpleditform__dns_slave' => "從屬",
    'class_domtmpleditform__dns_type' => "域名 DNS 區域類型",
    'class_traffichistory__no_data_available' => "尚無可用資料。",
    'class_traffichistory__reten_pref' => '網站和流量統計保留設定',
    'class_traffichistory__traffic_usage' => "流量使用",
    'clienttrafficlist_header' => "域名流量",
    'clienttrafficlist_header_of_client__' => "客戶%1的域名流量",
    'cmd_dns__a_dns_record_already_exist' => "該記錄將會與用於區域的 A 記錄相衝突。",
    'cmd_dns__domain_has_no_ns' => '域名無NS DNS記錄。',
    'cmd_dns__domain_last_ns' => '無法刪除域名最後的 NS DNS 記錄。',
    'cmd_dns__canonical_dom_name_is_invalid' => "規範域名無效。",
    'cmd_dns__cname_dns_record_already_exist' => "該記錄將會與用於區域的 CNAME 記錄相衝突。",
    'cmd_dns__cname_in_rr_combination' => 'DNS區域中的資源記錄組合錯誤',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS記錄無法與同一區域中的其他DNS記錄共存。',
    'cmd_dns__dns_record_type_is_invalid' => "DNS記錄類型無效。",
    'cmd_dns__ext_host_is_not_resolved' => "正式名稱 %1 不會解析為A 或AAAA記錄。",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => '無法添加 %1 記錄到區域 %2：%3',
    'cmd_dns__mail_dom_name_is_invalid' => "郵件 exchanger 名稱無效。",
    'cmd_dns__mx_priority_is_invalid' => "MX 優先順序無效。",
    'cmd_dns__name_server_is_invalid' => "域名伺服器無效。",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "網路遮罩必須為 24、16 或 8。",
    'cmd_dns__this_dns_record_already_exists' => "相同 DNS 記錄已存在。",
    'cmd_dns__unable_add_record' => "無法添加%1記錄：%2",
    'cmd_dns__unable_add_a_record' => "無法添加 A 記錄：%1",
    'cmd_dns__unable_add_cname_record' => "無法添加 CNAME 記錄：%1。",
    'cmd_dns__unable_add_dns_record' => "無法添加DNS記錄: %1。",
    'cmd_dns__unable_add_ext_ns_record' => "無法添加 EXT_NS 記錄：%1",
    'cmd_dns__unable_add_ns_record' => "無法添加 NS 記錄：%1",
    'cmd_dns__unable_add_ptr_record' => "無法添加 PTR 記錄：%1",
    'cmd_dns__unable_add_txt_record' => "無法添加TXT記錄：%1",
    'cmd_dns__unable_create_dns_zone' => "無法創建 DNS 區域 %1",
    'cmd_dns__unable_define_dns_record' => "無法定義DNS記錄%1。",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "無法檢索預設 DNS 區域狀態：%1",
    'cmd_dns__unable_insert_a_record' => "無法插入 A 記錄：%1",
    'cmd_dns__unable_insert_mx_record' => "無法插入 MX 記錄：%1",
    'cmd_dns__unable_insert_ns_record' => "無法插入 NS 記錄：%1",
    'cmd_dns__unable_set_dns_zone_status' => "無法設定 DNS 區域狀態：%1",
    'cmd_domains__dom_already_exists' => "域名%1已存在。",
    'cmd_domains__dns_record_already_exists' => "因對應於主機%1的DNS記錄已存在，從而無法創建域名%1。",
    'cmd_domains__dom_already_exists1' => "此域名中存在 %2 個子域名，域名%1已存在。",
    'cmd_domains__dom_already_exists2' => "子域名%1已存在",
    'cmd_domains__dalias_already_exists' => "此別名已存在。",
    'cmd_domains__domain_alias_already_exists' => '相同名稱的域名別名已經存在。',
    'cmd_domains__unable_del_mail_for_dom' => "無法刪除域名的郵件服務：%1。",
    'cmd_domains__unable_delete_anonymous_ftp' => "無法刪除域名%1的匿名 FTP 帳戶。",
    'cmd_domains__unable_update_dom_param' => "無法更新域名參數：%1。",
    'cmd_domains__unable_rename_client_exist' => "域名管理員的用戶名已在使用中。",
    'cmd_hosting__hst_type_is_not_physical_hst' => "主機類型不是物理主機。",
    'cmd_hosting__unable_create_user' => "無法創建用戶 %2：%1。",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "無法為基於名稱的虛擬主機定義 IP 位址：%1。",
    'cmd_hosting__unable_del_old_hst' => "無法刪除之前設定的主機：%1",
    'cmd_hosting__unable_del_protected_directory' => "無法刪除受保護目錄: %1。",
    'cmd_hosting__unable_del_web_user' => "無法刪除網站用戶：%1。",
    'cmd_hosting__unable_make/update_virtual_host' => "無法創建或更新虛擬主機：%1。",
    'cmd_hosting__unable_make_frame_forward_hst' => "無法設定幀轉發主機。",
    'cmd_hosting__unable_rebuild_ftp_config' => "無法重新建立proftpd設定檔: %1。",
    'cmd_hosting__unable_set_up_ssl' => "無法設定 SSL/TLS：%1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "無法從 SSL/TLS 目錄移除保護：%1",
    'cmd_hosting__unable_update_dest_url' => "無法更新目標URL %1。",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "無法更新域名的DNS 區域：實用程式執行失敗。",
    'cmd_hosting__unable_update_ftp_passwd' => "無法更新FTP密碼%1。",
    'cmd_hosting__unable_update_user' => "無法更新用戶 %2：%1。",
    'cmd_hosting__unknown_hst_type' => "未知主機型號。",
    'cmd_hosting__you_not_have_permission_del_hst' => "您無權終止主機服務。",
    'cmd_mail__autoresponder__not_configured' => "此郵件帳戶未配置自動回復功能",
    'cmd_mail__addr_already_used_in_mail_redirect' => "地址%1已被用於郵件轉發。",
    'cmd_mail__alias_already_exists' => "別名已存在。",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "自動回復ID和郵箱帳戶ID不匹配。",
    'cmd_mail__autoresp_id_is_undefined' => "自動回復ID未定義。",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "郵件帳戶 %1 已存在相同名稱的郵件別名。",
    'cmd_mail__mail_name_already_exists_in_maillists' => "郵件帳戶%1已存在於郵寄清單中。",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "郵件帳戶%1已在此域名中。",
    'cmd_mail__mail_name_not_exist' => "此郵件帳戶不存在。",
    'cmd_mail__mail_name_passwd_part' => "密碼不可以包含郵件帳戶名。",
    'cmd_mail__maillist_already_exist_in_this_dom' => "此域名已存在郵寄清單 %1。",
    'cmd_mail__mailname_already_exist_in_mg' => "郵件帳戶%1已存在於郵件組中。",
    'cmd_mail__mailname_already_exist_in_this_dom' => "郵件帳戶%1已在此域名中。",
    'cmd_mail__mailname_already_exists' => "郵件帳戶已存在。",
    'cmd_mail__mailname_is_invalid' => "郵件帳戶名%1無效。",
    'cmd_mail__mailname_unable_update' => "無法更新郵件帳戶屬性：",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "已達到此域名的最大自動回復數量。",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "已達到此域名的最大郵件組數量。",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "已達到此域名的最大轉發器數量。",
    'cmd_mail__max_postboxes_num_has_been_reached' => "已達到郵箱最大數量。",
    'cmd_mail__no_members_specified' => "尚未指定成員。",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "密碼太簡單，請選擇其他密碼。",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "此電子電郵地址已在使用。",
    'cmd_mail__unable_define_autoresp_id' => "無法定義自動回復ID%1。",
    'cmd_mail__unable_update_mail_for_dom' => "更改域名%1的郵件服務設定失敗",
    'cmd_mail__unable_del_mail_for_dom' => "無法從域名%1中刪除郵件服務。",
    'cmd_mail__unable_del_mail_redirection' => "無法刪除郵件轉發服務%1。",
    'cmd_mail__unable_remove_autoresp' => "無法刪除自動回復: %1",
    'cmd_mail__unable_remove_mail_group_members' => "無法刪除郵件組成員：%1。",
    'cmd_mail__unable_turn_off_mail_group' => "禁用郵件組失敗：%1",
    'cmd_mail__unable_update_mail_redirect' => "無法重新配置郵件轉發服務%1。",
    'cmd_mail__uploaded_file_is_too_big' => "上傳文件過大。",
    'cmd_mail__additionally' => "此外：",
    'cmd_pd__invalid_login' => "用戶名錯誤。",
    'cmd_pd__this_user_already_exist' => "相同用戶已存在。",
    'cmd_pd__unable_define_hst_type' => "無法定義主機類型。",
    'cmd_pd__unable_upd_pd_usr' => "無法更新受保護目錄使用者屬性: %1。",
    'cmd_pd__user_is_undefined' => "用戶未定義。",
    'cmd_server__no_enough_free_disk_space' => "磁碟空間不足。",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "原有密碼錯誤。請重試。",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "已達到此域名的最大網站用戶數限制。",
    'cmd_web_usr__unable_create_user' => "無法創建系統使用者：%1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "無法定義最大網站用戶數量：%1。",
    'cmd_web_usr__user_already_exists' => "用戶已存在。",
    'cmd_web_usr__web_user_name_is_invalid' => "網站用戶名%1無效。",
    'cmd_web_usr__web_user_not_exist' => "網站用戶不存在。",
    'common_func__exec_bad_argument' => "exec 參數不應包含單引號。",
    'common_acl__add_address' => '添加到公共的允許域名解析傳遞列表中',
    'common_acl_add_record' => '添加ACL記錄',
    'enter_ip_or_network_address' => '輸入IP位址或網路位址',
    '__eol' => '分行符號',
    'eol__binary_file' => '無法更改二進位檔案中的分行符號風格。',
    'comp_info__header' => '組件',
    'comp_info__comp_name' => "組件名",
    'comp_info__comp_disabled' => '已關閉',
    'comp_info__comp_active' => '活動',
    'comp_info__comp_not_configured' => '未配置',
    'comp_info__comp_not_started' => '未啟動，請查看組件設定',
    'comp_info__comp_version' => "組件版本",
    'comp_info__integration_error' => "整合錯誤",
    'comp_info__title' => "Plesk 組件",
    'comp_info__service_name' => "服務",
    'comp_info__last_updated' => '(上次更新：%1)',
    'configure__full_hostname' => "完整的主機名稱",
    'cp_access_admin_deny' => "根據當前應用的限制 IP 存取策略，管理員不能從位址 '%1' 進行存取。",
    'create_domain_warn__' => "域名創建過程中出現下列異常：",
    'create_domain__client_select' => '選擇創建域名的客戶',

    'dashboard__nav_button_name' => "首頁",
    'dalias__list_title' => '域名%1的域名別名',
    'dalias__list_legend' => '域名別名',
    'dalias__list_header' => '域名別名',
    'dalias__list_status' => 'S',
    'dalias__list_name' => '域名別名',
    'dalias__list_ascii_name' => '使用ASCII形式',
    'dalias__remove_title' => '域名%1的下列別名將被刪除：',
    'dalias__select_domain_aliases_to_remove' => '選擇要刪除的域名別名。',
    'dalias__mail_turn_on_failed' => '無法啟用郵件服務：%1',
    'dalias__web_turn_on_failed' => '無法啟用Web服務: %1',
    'db_usr_edit__db_usr_name_old' => "舊資料庫用戶名",
    'databases__db_title' => "MS SQL 伺服器管理員的驗證憑據和工具",
    'databases__server_title' => "%1 管理員的密碼",
    'databases__connection' => "連接",
    'databases__db_server' => "伺服器名稱",
    'databases__db_admin_login' => "%1管理員用戶名",
    'databases__db_admin_passwd' => "管理員密碼",
    'databases__db_confirm_passwd' => "確認密碼",
    'databases__can_not_manage' => "您不能管理資料庫伺服器",
    'databases__not_installed' => "(尚未安裝)",
    'databases__not_supported_license' => "(許可證不支援)",
    'databases__title' => "設定資料庫管理員憑據",
    'databases__unable_connect' => "無法存取資料庫。參數錯誤。",
    'databases__incorrect_db_admin_login' => '用戶名只能包含字母、數位、破折號和底線，且必須以字母開頭。',
    'databases__incorrect_db_admin_passwd' => '密碼不可以包含用戶名。',
    'database_servers_form__title' => '資料庫伺服器',
    'database_servers_form__server_list_legend' => '資料庫伺服器',
    'database_servers_form__remove_empty_selection' => '尚未選擇資料庫伺服器。',
    'database_servers_form__remove_title' => '下列資料庫伺服器將被刪除：',
    'database_server_database_list__client' => '客戶',
    'database_server_database_list__domain' => '域名',
    'database_server_database_list__header' => '資料庫',
    'database_server_database_list__name' => '名稱',
    'database_server_databases_form__databases_list_legend' => '資料庫',
    'database_server_databases_form__remove_empty_selection' => '尚未選擇資料庫。',
    'database_server_databases_form__remove_title' => '下列資料庫將被刪除：',
    'database_server_databases_form__tab' => '資料庫(%1)',
    'database_server_edit_form__admin_login' => "用戶名",
    'database_server_edit_form__admin_password' => "密碼",
    'database_server_edit_form__admin_password2' => "確認密碼",

    'database_server_edit_form__default' => '使用此伺服器作為 %1 的默認伺服器',
    'database_server_edit_form__duplicate' => '使用此主機位址和埠號的資料庫伺服器已註冊。',
    'database_server_edit_form__host' => '主機名稱稱或 IP 地址',
    'database_server_edit_form__legend_authentication' => '驗證',
    'database_server_edit_form__legend_general' => '常用',
    'database_server_edit_form__port' => '埠號',
    'database_server_edit_form__port_hint' => '將默認埠號保留為空',
    'database_server_edit_form__tab' => '資料庫伺服器',
    'database_server_edit_form__title_new' => '新建資料庫伺服器',
    'database_server_edit_form__title_edit' => '%1上的資料庫伺服器',
    'database_server_edit_form__type' => '資料庫伺服器類型',
    'database_server_edit_form__unix_socket' => '(本地連接)',
    'database_server_edit_form__external_connection' => '允許本端 MySQL 伺服器接受外部連線',
    'database_server_edit_form__external_connection_hint' => '變更此設定導致本端 MySQL 伺服器重新啟動。如需啟用在 Plesk 遠端存取其他 MySQL 伺服器的功能，請手動變更其設定。',
    'database_server_edit_form__external_connection__configured_to_local' => '本端 MySQL 伺服器的設定拒絕遠端連線',
    'database_server_edit_form__external_connection__configured_to_remote' => '本端 MySQL 伺服器設定接受遠端連線',
    'database_server_error__consult_admin' => '請聯繫伺服器管理員。',
    'database_server_error__last__connection_failed' => '由於網路問題，控制此資料庫伺服器的最後一次嘗試失敗。',
    'database_server_error__last__permission_denied' => '由於所提供的帳戶沒有管理許可權，控制此資料庫伺服器的最後一次嘗試失敗。',
    'database_server_error__last__credentials_not_set' => "上一次嘗試連接該伺服器失敗因為未指定有效的管理員用戶名和密碼。",
    'database_server_error__last__other_error' => '控制此資料庫伺服器的最後一次嘗試失敗。',
    'database_server_error__real__connection_failed' => '由於網路問題，無法連接此資料庫伺服器。',
    'database_server_error__real__permission_denied' => '由於所提供的帳戶沒有管理許可權，無法連接此資料庫伺服器：',
    'database_server_error__real__duplicate_object' => '由於名稱衝突，無法連接此資料庫伺服器：',
    'database_server_error__real__unacceptable_name' => '由於對象名稱無效，無法連接此資料庫伺服器：',
    'database_server_error__real__unacceptable_password' => '由於密碼不可接受，無法連接此資料庫伺服器。',
    'database_server_error__real__credentials_not_set' => "Plesk 無法連接到資料庫伺服器因為未指定有效的管理員用戶名和密碼。",
    'database_server_error__real__other_error' => '連接此資料庫伺服器失敗:',
    'database_server_error__test__connection_failed' => '因網路問題導致測試連接資料庫伺服器失敗：',
    'database_server_error__test__permission_denied' => '測試連接資料庫伺服器失敗因為提供的帳戶沒有管理許可權：',
    'database_server_error__test__duplicate_object' => '因名字衝突導致測試連接資料庫伺服器失敗：',
    'database_server_error__test__unacceptable_name' => '因無效的對象名稱導致測試連接資料庫伺服器失敗：',
    'database_server_error__test__unacceptable_password' => '因不可接受的密碼導致測試連接資料庫伺服器失敗：',
    'database_server_error__test__credentials_not_set' => "測試連接該伺服器失敗因為未指定有效的管理員用戶名和密碼。",
    'database_server_error__test__other_error' => '測試連接資料庫伺服器失敗：',
    'database_server_list__header' => '資料庫伺服器',
    'database_server_list__last_error' => 'S',
    'database_server_list__type' => '伺服器類型',
    'database_server_list__host' => '主機名稱',
    'database_server_list__port' => '埠',
    'database_server_list__version' => '版本',
    'database_server_list__dbcount' => '資料庫',
    'db__create_new_db' => "添加資料庫",
    'db__db_add' => "添加資料庫",
    'db__db_for_dom' => "網站%1的資料庫",
    'db__db_id_undefined' => "未定義資料庫ID。",
    'db__db_name' => "資料庫名稱",
    'db__db_not_exist' => "資料庫並不存在。",
    'db__db_type' => "類型",
    'db__db_server' => "資料庫伺服器",
    'db_server_not_exist' => "資料庫伺服器不存在。",
    'db__db_user_not_exist' => "資料庫使用者不存在。",
    'db__domain_not_exist' => "域名不存在。",
    'db__enter_db_name' => "輸入新資料庫名。",
    'db__invalid_db_id' => "資料庫識別字無效。",
    'db__invalid_db_name' => "資料庫名無效。資料庫名應只包含拉丁字母表字元、數位或破折號。它不可以超過63個符號。",
    'db__max_db_reached_for_dom' => "已達到此域名的資料庫數量上限。",
    'db__max_mssql_db_reached_for_dom' => "已達到此域名的 Microsoft SQL Server 資料庫數量上限。",
    'db__postgres_not_connect_for_admin' => "無法連接到PostgreSQL。請在伺服器管理頁面上啟用PostgreSQL支援。",
    'db__postgres_not_connect_for_client' => "無法連接到PostgreSQL。請向系統管理員尋求説明。",
    'db__remove_db_on_domain' => "客戶%1所有的網站%2的下列資料庫將被刪除:",
    'db__remove_db_on_domain_of_cl' => "客戶%1名下域名%2的下列資料庫將被刪除:",
    'db__remove_db_linked_resource' => '此資料庫被web應用程式使用。只有卸載該web應用程式後才能刪除此資料庫。',
    'db__remove_db_users' => "客戶%1名下網站%2上資料庫%3的下列使用者將被刪除:",
    'db__remove_db_users_of_cl' => "客戶%1名下網站%2上資料庫%3的下列使用者將被刪除:",
    'db__select_db_for_remove' => "選擇要刪除的資料庫。",
    'db__select_db_users_for_remove' => "選擇要刪除的資料庫使用者。",
    'db__unable_create_db_user' => "無法創建資料庫使用者：%1。",
    'db__unable_define_db_name' => "無法定義資料庫名：%1。",
    'db__unable_define_db_user' => "無法定義資料庫使用者：%1。",
    'db__unable_define_db_users' => "無法定義資料庫使用者：%1。",
    'db__unable_select_dom_name' => "無法選擇域名：%1。",
    'db_edit__db_for_dom' => "域名%2上資料庫 %1 的使用者",
    'db_edit__invalid_db_name' => "資料庫名無效。",
    'db_edit__no_users' => "尚無使用者擁有此資料庫的憑據。",
    'db_edit__unable_define_db_usrs' => "無法定義資料庫使用者：%1。",
    'db_edit__unable_select_db_usr' => "無法選擇資料庫使用者。",
    'db_edit__db_user_password_for_' => "請輸入資料庫使用者%1的登入密碼",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "添加資料庫使用者",
    'db_usr_edit__db_usr_name' => "資料庫用戶名",
    'db_usr_edit__edit_db_usr' => "資料庫使用者編輯",
    'db_usr_edit__for_db' => "用於 %1 資料庫",
    'db_usr_edit__not_create_pass' => "此操作將導致創建一個沒有密碼的資料庫使用者帳戶。\n您希望創建一個沒有指定密碼的使用者嗎？",
    'dbuser__only_one_user_can_be_default' => "只能將一名用戶設為預設值。",
    'db_server__cannot_delete_default' => "無法刪除預設資料庫伺服器。",
    'db_server__cannot_delete_local' => "無法刪除本地資料庫伺服器。",
    'db_server__cannot_delete_used' => '如果資料庫伺服器上有託管資料庫或資料庫使用者則無法刪除該資料庫伺服器。',
    'demo__disabled_in_demo' => "此操作在展示版本本中不可用。",
    'defaultcomponents__title' => "選擇預設組件",
    'defaultcomponents__select_default' => "選擇預設%1組件",//to check
    'defaultcomponents__not_installed' => "(尚未安裝)",
    'defaultcomponents__not_configured' => "(未配置)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "某些服務目錄包含無效選項，或尚無可用選項。",
    'defaultcomponents__depends_on' => "(要求 %1)",
    'defaultcomponents__parameters' => "%1 的參數",
    'component_name__antivirus' => "防病毒程式",
    'component_name__database' => "SQL 伺服器",
    'component_name__sqladmin' => "MySQL Web Admin",
    'component_name__sqladminmysql' => "MySQL Web Admin",
    'component_name__dnsserver' => "DNS 伺服器",
    'component_name__firewall' => "防火牆",
    'component_name__ftpserver' => "FTP 伺服器",
    'component_name__java' => "Java",
    'component_name__mailserver' => "郵件伺服器",
    'component_name__local_mailserver' => "本地郵件伺服器",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Web 腳本",
    'component_name__spamfilter' => "垃圾郵件篩檢程式",
    'component_name__stats' => "網站統計",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "web 郵箱",
    'component_name__webpublish' => "Web 發佈",
    'component_name__webserver' => "Web 伺服器",
    'dns__dns_zone_legend' => 'DNS 記錄',
    'dns__dns_record_invalid_values' => '指定了不正確的 DNS 記錄值：%1: %2',
    'dns__dns_zone_invalid_values' => '指定的DNS區域參數值錯誤。',

    'dns__soa_mname_title' => '主域名伺服器',
    'dns__soa_mname_legend' => '域名伺服器',
    'dns__soa_mname_autoselect' => '（自動選擇）',

    'dns__dns_soa_title' => 'SOA 記錄',
    'dns__dns_zone_default' => '區域預設設定',
    'dns__dns_zone_settings_template_title' => '區域設定',
    'dns__dns_soa_legend' => 'SOA 記錄',
    'dns__dns_soa_ttl' => 'TTL',
    'dns__dns_soa_refresh' => '刷新',
    'dns__dns_soa_retry' => '重試',
    'dns__dns_soa_expire' => '過期',
    'dns__dns_soa_minimum' => '最小',
    'dns__dns_soa_ttl_error' => 'TTL值無效，此值應介於1秒到68年之間。',
    'dns__dns_soa_refresh_error' => '刷新值無效，此值應介於1秒到68年之間。',
    'dns__dns_soa_retry_error' => '重試值無效，此值應介於1秒到68年之間。',
    'dns__dns_soa_expire_error' => '過期值無效，此值應介於1秒到68年之間。',
    'dns__dns_soa_minimum_error' => '最小值無效，此值應介於1秒到68年之間。',
    'dns__dns_default_title' => '恢復DNS區域。',
    'dns__dns_default_legend' => "區域恢復選項。",
    'dns__dns_default_text' => "選擇恢復 DNS 區域的設定，確認這些設定，並按一下“確定”。",
    'dns__dns_default_confirm' => "確認恢復DNS區域",
    'dns__dns_default_confirm_required' => "請確認恢復DNS區域",
    'dns__dns_default_invalid_ip_address' => '無效的IP地址',

    'dns_t__dns_default_title' => '恢復預設的 DNS 區域範本',
    'dns_t__dns_default_legend' => "恢復選項",
    'dns_t__dns_default_text' => '請確認要恢復 DNS 區域範本的預設配置。',
    'dns_t__dns_default_confirm' => "確認恢復",
    'dns_t__dns_default_confirm_required' => "請確認恢復DNS區域範本",
    'dns_t__dns_zone_off_remove_title' => "DNS 區域範本的下列資源記錄將被刪除：",
    'dns_t__dns_zone_master_remove_title' => "下列資源記錄將從 DNS 區域範本中刪除：",
    'dns_t__add_dns_record_master_title' => '添加資源記錄到區域範本',
    'dns_t__add_dns_record_off_title' => '添加域名伺服器',
    'dns_t__edit_dns_record_master_title' => '編輯DNS記錄',
    'dns_t__edit_dns_record_off_title' => '編輯域名伺服器',
    'dns_t__select_record_to_remove' => "選擇要從DNS範本中刪除的記錄。",
    'dns_t__edit_dns_record_ttl' => 'TTL',

    'dns__unit_seconds' => '秒',
    'dns__unit_minutes' => '分鐘',
    'dns__unit_hours' => '小時',
    'dns__unit_days' => '天',
    'dns__unit_weeks' => '星期',
    'dns__dns_zone_off_remove_title' => "下列資源記錄將從區域%1中刪除：",
    'dns__dns_zone_master_remove_title' => "刪除 DNS 區域 %1 的資源記錄",
    'dns__dns_zone_slave_remove_title' => "%1的下列主域名伺服器記錄將被刪除：",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => '輸入記錄字串',
    'dns_add__is_spf_syntax' => 'SPF 記錄',
    'dns_add__spf_value_is_invalid' => "SPF 記錄的值錯誤，這個值必須以 'v=spf 開頭",
    'dns__dns_zone_status' => "DNS 區域狀態。",
    'dns__dns_zone_template' => "DNS 區域範本",
    'dns__host' => "主機",
    'dns__ttl' => "TTL",
    'dns__invalid_ip_address' => "新的 DNS 主要伺服器的 IP 位址為空或者無效。",
    'dns__ip_address' => "IP 地址",
    'dns__master_dns_type' => "是主 DNS 伺服器",
    'dns__masters' => "DNS 主要伺服器",
    'dns__soa_minimum_too_large' => '不推薦緩存負回應3小時以上。',
    'dns__select_masters_to_remove' => "選擇要刪除的DNS主控伺服器。",
    'dns__select_template_record_to_remove' => '選擇要刪除的DNS範本記錄。',
    'dns__select_common_acl_record_to_remove' => '選擇要刪除的ACL DNS記錄。',
    'dns__select_record_to_remove' => '選擇要刪除的DNS記錄。',
    'dns__nameservers_for_domain' => "域名的域名伺服器",
    'dns__ns' => "域名伺服器",
    'dns__ns_record' => "域名伺服器",
    'dns__remove_dns_zone_of_domain__' => "從域名%1中刪除 DNS 記錄",
    'dns__remove_dns_zone_template__' => "下列DNS記錄將從範本中刪除:",
    'dns__remove_common_acl_record' => "下列ACL記錄將被刪除",
    'dns__remove_this_dns_record?' => "您確定要刪除此 DNS 記錄嗎？",
    'dns__restore_default' => "通過範本恢復 DNS 區域",
    'dns__restore_default_confirm' => "恢復 DNS 區域將丟棄當前的 DNS 區域配置。是否繼續？",
    'dns__restore_default_error' => "恢復 DNS 區域時發生錯誤：",
    'dns__slave_dns_type' => "是從屬DNS伺服器",
    'dns__soa_refresh_value_is_small' => '刷新間隔值小於一小時，這會大大增加伺服器流量和資源使用率。繼續使用這個值嗎？',
    'dns__subdomain_dns_rec_removed' => "A記錄已從子域名區域%1中刪除。",
    'dns__zone_switched_off_no_ns' => "因區域中沒有本應顯示的NS記錄%1，導致此區域已關閉。若要將記錄添加到此區域中，請按一下“添加記錄”按鈕。",
    'dns__cant_switch_on_no_ns' => "因區域中沒有本應顯示的NS記錄%1，導致無法打開此區域。若要將記錄添加到此區域中，請按一下“添加記錄”按鈕。",
    'dns__type' => "記錄類型",
    'dns__unable_activate/deactivate_dns' => "無法啟用/禁用 DNS：%1。",
    'dns__unable_add_dns_master_duplicate_entry' => "無法添加 DNS 主要伺服器：項目重複。",
    'dns__unable_add_dns_master_local_ip' => "無法添加 DNS 主 IP 地址：DNS 主記錄應放到遠端伺服器。",
    'dns__unable_define_dns_record' => "無法定義 DNS 記錄：%1。",
    'dns__unable_get_dns_template_status' => "無法檢索 DNS 範本狀態。",
    'dns__unable_remove_dns_rec' => "無法刪除 DNS 記錄：%1。",
    'dns__val' => "值",
    'dns__warnings__' => "DNS 區域修改結果：",
    'dns__you_not_have_perm_manage_dns' => "您無權管理此域名的 DNS 區域。",
    'dns__zone_record' => "DNS 記錄",
    'dns__dns_preferences_form' => 'DNS 遞迴設定',
    'dns__dns_recursion_settings' => 'DNS遞迴設定',
    'dns__allow_recursion' => '允許遞迴',
    'dns__cant_create_record_with_server_ip' => "無法添加該 IP 地址因為它與該 Plesk 管理的伺服器的 IP 地址。",

    'dns__tabs_acl' => "區域傳輸",
    'dns__acl_add_network_legend' => "添加網路",
    'dns__acl_add_ip_legend' => "添加 IP 地址",
    'dns__acl_network_not_allowed' => "DNS 不允許在 Windows 中使用該網路位址。",
    'dns__acl_enter_ip_address_with_mask' => "IP 地址/遮罩",
    'dns__acl_enter_ip_address' => "IP 地址",
    'dns__acl_list_network_legend' => "允許獲取 DNS 區域副本的網路",
    'dns__acl_list_ip_legend' => "允許獲取 DNS 區域副本的 IP 位址",
    'dns__acl_record_network' => "允許的網路",
    'dns__acl_record_ip' => "允許的 IP 位址",
    'bt_dns_acl_add_network' => "添加網路",
    'bt_dns_acl_add_ip' => "添加 IP 地址",

    'dns_add__add_rec_for_zone' => "為區域 %2 添加 %1",
    'dns_add__canonical_dom_name_is_invalid' => "規範域名無效。",
    'dns_add__enter_canonical_name' => "正式名稱",
    'dns_add__enter_dom_name' => "域名",
    'dns_add__enter_ip_address' => "IP 地址",
    'dns_add__enter_ip_mask' => "IP位址和網路遮罩",
    'dns_add__enter_mail_domain' => "郵件域名",
    'dns_add__enter_mail_exchanger' => "郵件交換伺服器",
    'dns_add__enter_nameserver' => "域名伺服器",
    'dns_add__enter_txt_record' => "TXT 記錄",
    'dns_add__enter_service_name' => "服務名稱",
    'dns_add__hint_service_name' => "示例：SIP",
    'dns_add__enter_protocol' => "協議",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "優先順序",
    'dns_add__specify_weight_of_service' => "擁有相同優先順序的記錄的相對權重",
    'dns_add__enter_target_host' => "目標主機",
    'dns_add__hint_target_host' => "例如：example.com",
    'dns_add__enter_target_port' => "目標埠",
    'dns_add__caa_tag' => "標籤",
    'dns_add__caa_value' => "值",

    'dns_add__invalid_ip' => "IP 地址無效。",
    'dns_add__low' => "低",
    'dns_add__mail_dom_name_is_invalid' => "郵件域名無效。",
    'dns_add__nameserver_is_invalid' => "域名伺服器無效。",
    'dns_add__record' => "%1 記錄",
    'dns_add__select_prefer_for_mail_exchange_server' => "指定郵件交換伺服器優先順序。",
    'dns_add__unable_insert_new_dns_rec' => "無法插入新的 DNS 記錄：%1",
    'dns_add__very_high' => "很高",
    'dns_check__test_dns_zone' => "測試 %2 上的 DNS 區域 %1",
    'dns_check__unable_get_dom_properties' => "無法檢索域名屬性：%1。",
    'dom_ctrl__allowed' => "允許",
    'dom_ctrl__db' => "MySQL 資料庫",
    'dom_ctrl__mssql_db' => "MS SQL Server 資料庫",
    'dom_ctrl__disk_space' => "磁碟空間",
    'dom_ctrl__dom_adm' => "%2 的域名 %1",
    'dom_ctrl__dom_cl' => "域名 %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "域名已設定轉發，但是沒有定義轉發 URL。",
    'dom_ctrl__domain_has_frame_forwarding' => "域名已有到 URL %1 的 URL 轉發。",
    'dom_ctrl__domain_has_no_hosting' => "域名沒有配置主機",
    'dom_ctrl__domain_has_physical_hosting' => "為 IP 地址 %1 上的該域名配置了主機",
    'dom_ctrl__domain_has_standard_forwarding' => "域名已標準轉發到 URL %1。",
    'dom_ctrl__maillists' => "郵寄清單",
    'dom_ctrl__mboxes' => "郵箱",
    'dom_ctrl__mg' => "郵件轉發",
    'dom_ctrl__resource_name' => "資源",
    'dom_ctrl__resp' => "自動回復",
    'dom_ctrl__subdom' => "子域名",
    'dom_ctrl__dom_aliases' => "域名別名",
    'dom_ctrl__traffic' => "流量",
    'dom_ctrl__unable_activate/deactivate_dom' => "無法啟用/禁用域名：%1。",
    'dom_ctrl__used' => "已使用",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "網站用戶",
    'dom_pref__bounce_with_phrase' => "退回信息",
    'dom_pref__bounce' => "退信",
    'dom_pref__catch_addr' => "轉發至地址",
    'dom_pref__reject' => '拒絕',
    'dom_pref__confirm_domain_removing' => "請不要忘記通知域名用戶域名已經更改。 確定要更改域名嗎？",
    'dom_pref__db_inconsystency' => "資料庫不一致。",
    'dom_pref__dbs' => "資料庫",
    'dom_pref__delete_traffic_stat' => "保留網站和流量統計",
    'dom_pref__delete_traffic_stat_older' => "保留網站和流量統計",
    'dom_pref__dom_level_name_conflict' => "域名管理員的用戶名同某個客戶的用戶名衝突。",
    'dom_pref__invalid_disk_space_limit' => "無效的磁碟空間限制。最大值：%1",
    'dom_pref__invalid_expiration_date_limit' => "無效的有效期限。",
    'dom_pref__invalid_max_traffic_limit' => "無效的流量限制。最大值：%1",
    'dom_pref__limits_of_dom' => "域名%1的限制",
    'dom_pref__mail_grps' => "郵件組",
    'dom_pref__mail_nonexistent_user' => "如何處理發送到不存在用戶的郵件",
    'dom_pref__mail_redirs' => "郵件轉發",
    'dom_pref__mail_resps' => "郵件自動回復",
    'dom_pref__max_limit_is_invalid' => "%1 無效。",
    'dom_pref__max_num_of_%objects_is_invalid' => "%1的最大數量無效。",
    'dom_pref__new_limit_less_currently_used' => "%1：請求 - %2，目前使用 - %3",
    'dom_pref__older_that' => "時間長度",
    'dom_pref__postboxes' => "郵箱",
    'dom_pref__preferences_of_dom' => "域名%1設定",
    'dom_pref__redirect_to_itself' => "域名將被設定成轉發到自身。",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "您指定的域名流量統計保留時間小於對伺服器定義的總值 (%1 個月)。因此保留時間已被設為伺服器的預設值 (%1 個月)。",
    'dom_pref__unable_add_www_prefix_in_dom' => "無法添加 www 首碼到域名：%1。",
    'dom_pref__unable_define_physical_hst_param' => "無法定義物理主機參數：%1。",
    'dom_pref__unable_rename_domain' => "無法重命名域名。",
    'dom_pref__unable_set_up_mbox_quota' => "無法設定此域名的郵箱配額：%1。",
    'dom_pref__unable_set_up_web_user_script' => "無法為網站用戶設定腳本：%1。",
    'dom_pref__unlimited' => "無限",
    'dom_pref__web_usrs' => "網站用戶",
    'dom_pref__you_already_have_%object' => "您已經擁有了 %1",
    'dom_cli__warning_ignore_quota' => '警告：已忽略選項“-hard_quota”：不支援硬碟配額',
    'dom_user_client_login_exist' => "無法許可域名管理員存取域名  %1 上的 Plesk：該用戶名已在使用當中。",
    'domain__unable_to_turn_on_service' => "啟用%1服務失敗。",
    'domains__change_the_status_of_domain?' => "您確定要更改域名%1的狀態嗎？",
    'domains__client_info_hiding_traffic' => "%1個域名、%2個活動域名、已使用%3磁碟空間",
    'domains__unable_to_change_client_status' => "無法更改客戶帳戶狀態: %1",
    'domains__unable_update_apache_settings' => "無法更新Apache設定。",
    'domains__you_do_not_have_permissions_to_delete_domains' => "您無權刪除域名。",
    'domains__you_want_change_the_status_of_the_cl??' => "您確定要更改客戶帳戶的狀態嗎？",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "您確定要執行此操作嗎？",
    'domains_list__unable_remove_doms' => "無法刪除域名：%1",
    'domaintrafficlist_header_of_domain__' => "域名%1的流量",

    'domain_aliases_remove__select_domain_aliases_for_remove' => '選擇要刪除的域名別名。',
    'domain_aliases_remove__title' => '刪除域名別名',
    'domain_aliases__max_aliases_reached_for_dom' => "已達到此域名的別名數量上限。",
    'domain_edit__edit_title' => '編輯域名別名',
    'domain_alias_edit__type' => '域名別名類型',
    'domain_aliases__list_header' => '域名別名',
    'domain_aliases__name' => '名稱',
    'domain_aliases__type' => '類型',
    'domain_aliases__type_full' => '全部',
    'domain_aliases__type_web_ftp' => 'WEB 與 FTP',
    'domain_aliases__page_title' => '域名別名',
    'domain_aliases__legend' => '域名別名',
    'domain_alias__domain_exists' => '相同名稱的域名已經存在',
    'domain_alias__subdomain_exists' => '相同名稱的子域名已經存在',
    'domain_alias__dns_record_exists' => '使用指定域名別名的 DNS 記錄已存在',
    'domain_alias__domain_alias_exists' => "相同名稱的域名別名已經存在",
    'domain_alias__invalid_type_full' => '郵件伺服器不支援域名別名',
    'domain_alias__redirect_exists' => '重定向至自我監測',

    'ds__anonymous_ftp' => "匿名FTP",
    'drweb__pagetitle' => '防病毒設定',
    'drweb__drweb' => '郵件防病毒檢查',
    'drweb__drweb_direction' => '檢查病毒郵件',
    'drweb__drweb_direction_off' => '請不要進行病毒檢查',
    'drweb__drweb_direction_any' => '傳入和傳出的郵件',
    'drweb__drweb_direction_from' => '僅傳出的郵件',
    'drweb__drweb_direction_to' => '僅傳入的郵件',
    'drweb__disable_reason_key' => '許可證不支援防毒軟體。',
    'drweb__disable_reason_perm' => '您無權管理防病毒程式。',
    'drweb__disable_reason_install' => '尚未安裝防毒軟體。',
    'drweb__filters' => '防病毒篩檢程式',
    'ds__dns' => "DNS 區域",
    'ds__mail' => "郵件",
    'dsr__of_client_title' => "%1 的域名摘要報告",
    'dsr__report_has_been_sent_email' => "報告已發送到郵箱: %1",
    'dsr__title' => "域名摘要報告",
    'dumps_list__deletion_page_title' => "域名%1的下列備份檔案將被刪除：",
    'dumps_list__dumpfile_is_invalid' => "此檔%1不是有效的備份檔案。",
    'dumps_list__page_title' => "備份檔案存儲",
    'dumps_upload__page_title' => "上傳備份檔案到存儲",
    'dumps_list__repository_is_not_exist' => "備份檔案存儲不存在。",
    'dumps_list__unable_to_remove' => "無法刪除備份檔案：%1",
    'dumps_list__dumpfile_can_conflict' => "您指定的檔案名與檔%1衝突。請指定其他檔案名。",
    'dusr_ed__allow_dl_usr_access' => "允許域名管理員存取",
    'dusr_ed__information' => "域名%1管理員屬性",
    'dusr_ed__locale' => "域名管理員的語言",
    'dusr_ed__skin' => "域名管理員的介面皮膚",
    'dusr_ed__personal_information' => '個人資訊',
    'ess__error' => "錯誤",
    'example__' => "示例：%1",
    'extras__allow_certificate_purchasing' => "允許購買證書",
    'extras__allow_domain_registration' => "允許域名註冊",
    'extras__allow_extras' => "允許其它服務",
    'extras__buy_new_key' => "您當前的許可證不允許修改這些對象。",
    'extras__setup_services' => "設定其它服務",

    'firewallmainform__title' => '防火牆管理',
    'firewallmainform__interfaces_list_legend' => '網路介面清單',
    'firewall__interfacelist' => '網路介面',
    'interfacelist__enabled' => 'F',
    'interfacelist__status' => 'I',

    'interfacelist__interface' => '介面名稱',
    'interfacelist__type' => '介面類別型',
    'bt_rule_add' => '添加防火牆規則',
    'bt_panic' => '應急模式',
    'firewallmainform__rules_list_legend' => '規則清單',
    'firewall__rulelist' => '規則',
    'rulelist__enable' => 'S',
    'rulelist__name' => '名稱',
    'rulelist__allow_input_from_any_port_profiles' => '[允許] 來自埠 [%1] 上[所有]的傳入連接，設定檔：[%2]',
    'rulelist__allow_input_from_port_profiles' => '[允許] 來自埠 [%2] 上 [%1] 的傳入連接，設定檔：[%3]',
    'rulelist__block_input_from_any_port_profiles' => '[拒絕] 來自埠 [%1] 上[所有]的傳入連接，設定檔：[%2]',
    'rulelist__block_input_from_port_profiles' => '[拒絕] 來自埠 [%2] 上 [%1] 的傳入連接，設定檔：[%3]',
    'rulelist__description' => '描述',
    'ruleeditform__add_title' => '添加新規則',
    'ruleeditform__properties' => '規則屬性',
    'ruleeditform__name' => '規則名稱',
    'ruleeditform__port' => '允許連接到下列埠或埠範圍',
    'ruleeditform__protocol_tcp' => 'TCP 協議',
    'ruleeditform__protocol_udp' => 'UDP 協議',
    'ruleeditform__edit_title' => '編輯防火牆規則',
    'ruleeditform__newrule' => '新建規則',
    'ruleeditform__enabled' => '啟用規則',
    'ruleeditform__profiles_text' => '設定檔',
    'ruleeditform__profiles_domain_text' => '域名',
    'ruleeditform__profiles_private_text' => '私有',
    'ruleeditform__profiles_public_text' => '公共',
    'ruleeditform__action' => '操作',
    'ruleeditform__action_allow' => '允許',
    'ruleeditform__action_deny' => '拒絕',
    'ruleeditform__from' => '遠程地址',
    'ruleeditform__from_add' => '添加 IP 位址或網路',
    'ruleeditform__profiles_hint' => '您必須至少選擇一個設定檔。',
    'ruleeditform__port_hint' => '例如：1000 或 1000-1051',
    'ruleeditform__from_hint' => '例如：192.168.0.1 or 192.168.0.0/16',
    'ruleeditform__ip_any' => '所有',
    'firewall_from_add' => '添加',
    'firewall_from_remove' => '移除',
    'firewall_from_clear' => '清除列表',
    'bt_firewall_from_add' => '添加',
    'bt_firewall_from_remove' => '移除',
    'bt_firewall_from_clear' => '清除列表',
    'ruleeditform__name_is_required' => '指定規則名稱。',
    'ruleeditform__profiles_is_required' => '至少選擇一個設定檔。',
    'ruleeditform__invalid_action' => '指定的操作無效。可能的值為“允許”或“拒絕”。',
    'ruleeditform__invalid_ip' => '指定的 IP 位址或網路無效。',
    'ruleeditform__invalid_protocol' => '指定的協議無效。可能的值為 "udp" 或 "tcp"。',
    'ruleeditform__invalid_port' => '指定的埠無效。可能的值為 1000 或 1000-1051',
    'firewall__panic_configuration' => '您確定要打開應急模式嗎？用戶可能會因此不能存取他們的域名。',
    'firewall__reset_configuration' => '您確定要將防火牆設定重置為預設狀態？',
    'rulelist__remove_selected' => '您想要移除所選規則嗎？',

    'filemanager__items' => '%1中的項目',
    'filemanager__items_paging' => '%1中的項目',

    'get_password__encrypted_password' => "無法發送密碼資訊: 密碼存放在加密表單中。",
    'get_password__mail_error' => "嘗試發送密碼到郵箱 %1 時出錯: %2",
    'get_password__mail_ok' => "密碼已成功發送到郵箱: %1",
    'get_password__message' => "存取系統的用戶名為: %1\n密碼為%2",
    'get_password__subject' => "用於存取系統的密碼",
    'groups__available' => "可用的郵件組",
    'groups__groups_for_mailname' => "此郵件帳戶%1註冊的郵件組",
    'groups__member_of' => "下列郵件組成員",
    'help__help_area' => "説明區域。",
    'hst_def__auth_disabled' => "不推薦",
    'hst_def__auth_enabled' => "允許",
    'hst_def__change_curr_dns_ip' => "當前 A DNS 記錄的 IP 位址將更改",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "A DNS 記錄中的 IP 位址與分配給所創建的主機帳戶的 IP 位址不一致。",
    'hst_def__dest_url' => "目標 URL",
    'hst_def__disk_quota' => "磁片配額",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "您試圖設定的磁碟空間限制小於匿名 FTP 接收目錄的限制值。匿名 FTP 接收目錄的磁碟空間限制值不能超過域名的磁碟空間限制。",
    'hst_def__frame_forwarding_definition' => "域名%1的 URL 轉發分配",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "警告。FTP 使用者%1被用於主機帳戶，但在系統中找不到",
    'hst_def__hst_type_is_not_defined' => "主機類型沒有定義",
    'hst_def__ip_based' => "基於 IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "此主機帳戶轉為共用IP位址將導致匿名FTP服務不可用。是否繼續？",
    'hst_def__password_is_invalid_password_syntax' => "密碼無效。\n不要在密碼中使用單引號和國家字母表字元。\n密碼的長度應該在5到14個字元之間，而且不能包含用戶名。",
    'hst_def__shell' => "通過 SSH 在訂閱的系統使用者的名下存取伺服器 shell",
    'hst_def__shell_windows' => "通過遠端桌面在訂閱的系統使用者的名下存取伺服器",
    'hst_def__standard_forwarding_definition' => "域名%1的地址跳轉分配",
    'hst_def__title_name_based' => "基於名稱",
    'hst_def__unable_create/update_physic_hst' => "無法創建/更新物理主機：%1。",
    'hst_def__unable_create/update_std_fwd' => "無法創建/更新位址跳轉：%1。",
    'hst_def__unable_create_forwarding_myself' => "無法創建到域名自身的轉發。",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "無法允許使用一個目錄來存儲 SSL/TLS 和非 SSL/TLS 內容：未啟用 SSL/TLS 支援。",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "無法啟用 SSL/TLS 支援：尚未安裝 SSL/TLS 證書。",
    'hst_def__url_is_invalid' => "URL 無效。",
    'hst_def__virtual_host_access' => "域名%1的虛擬主機存取",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "警告。此虛擬主機使用了一個不存在的 IP 位址。",
    'hst_def__you_have_no_ips' => "您沒有可用的IP地址，而且您不能創建基於名稱的主機。",
    'hst_sel__header' => "若要在此機器上託管網站，請選擇“物理主機”選項。\n若要設定網站轉發到另一機器的網站，請選擇 幀轉發 或 標準轉發 選項。\n使用“位址跳轉”，用戶可以重定向到該網站，真實網站的URL顯示在使用者的瀏覽器視窗中，因此使用者會知道有關重定向的情況。使用幀轉發，用戶可以被重定向到網站，但不瞭解真實網站的位置。",
    'hst_sel__physical_hst' => "物理主機",
    'hst_sel__select_hst_type' => "選擇域名的主機類型",
    'hst_sel__select_hst_type_warning' => "選擇域名的主機類型",
    'hst_sel__hosting_exists' => "無法創建主機，因為它已經被配置給此域名。您將被重定向到域名管理頁。",
    'hst_sel__standard_frw' => "不隱藏目標位址的 URL 轉發(位址跳轉)",
    'hst_sel__frame_frw' => "幀轉發",
    '__frame_frw' => "幀轉發",
    '__hosting_exists' => "無法創建主機，因為它已經被配置給此域名。您將被重定向到域名管理頁。",
    '__choose_hst_type' => "請選擇所需的主機類型。",
    '__no_hst_conf' => "您的域名沒有開通主機服務。",
    '__physical_hst' => "物理主機",
    '__select_hst_type' => "選擇域名的主機類型",
    '__standard_frw' => "不隱藏目標位址的 URL 轉發(位址跳轉)",
    '__warning' => "警告! 所有之前設定的參數都將被丟棄。您確定要更改主機類型嗎？",
    'i_cl_off' => "客戶處於非活動狀態。",
    'i_cl_off_by_admin' => "客戶帳戶已被伺服器管理員掛起。",
    'i_cl_off_expired' => "客戶帳戶已過期。",
    'i_cl_on' => "客戶處於活動狀態。",

    'icf__title' => 'Internet 連接防火牆',
    'icf__if_legend' => '介面',
    'icf__mode' => '模式',

    'invalid_value' => '無效值',

    'ip_addr__already_exists' => "IP 地址 %1 已存在。",
    'ip_addr__cant_add' => "IP %1不存在或屬於另一客戶的IP位址集區",
    'ip_addr__cl_list_for_ip' => "使用%1 IP位址%2的代理商",
    'ip_addr__cl_list_for_ip_add' => "添加IP位址到代理商池",
    'ip_addr__domains_list_for_ip' => "使用%1 IP位址%2的網站",
    'ip_addr__ip_used_by_hst_or_frw' => "IP 位址 %1 已被用於主機或轉發。",
    'ip_addr__only_one_ip_and_client_have_domain' => "無法刪除該IP地址，因為尚有域名託管在該IP地址上。",
    'ip_addr__remove_ip_addr' => "這些 IP 位址將從系統中刪除：",
    'ip_addr__select_clients' => "選擇客戶",
    'ip_addr__select_ip_addr_to_remove' => "選擇要刪除的 IP 位址。",
    'ip_addr__unallowed_by_license' => "Plesk 該副本並未被許可授權在 IP 位址 %1 上操作。\n允許的 IP 範圍是：%2.",
    'ip_alias__interface' => "介面",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "基於名稱的虛擬主機的 %1 IP 位址無效。",
    'ip_alias__invalid_ip_or_netmask' => "無效 IP 地址/遮罩對。",
    'ip_alias__orig_ip_can_not_be_deleted' => "該IP位址%1為原有伺服器IP，因此您無法將其刪除。",
    'ip_alias__ip_is_invalid' => "%1 IP 地址無效。",
    'ip_alias__ip_mask_is_invalid' => "%1 IP 遮罩無效。",
    'ip_alias__ip_not_exist' => "IP地址%1不存在。",
    'ip_alias__ip_address_and_mask' => 'IP 地址與子網路遮罩',
    'ip_alias__mask' => "子網路遮罩",
    'ip_alias__remove_selected_ip_aliases?' => "您確定要刪除所選 IP 位址嗎？",
    'ip_alias__select_ip' => "請至少從列表中選擇一種要刪除的郵件模式。",
    'ip_alias__this_ip_used_for_domain' => "(%1) 此 IP 地址已被用於域名%2。",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) 此 IP 地址已被用於基於名稱的虛擬主機。",
    'ip_alias__unable_add_ip' => "無法添加 IP：%1",
    'ip_alias__unable_remove_ip' => "無法刪除 IP：%1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "您不能更改 IP 網址類別型為共用型，因為這樣將使得域名 '%1' 的匿名 FTP 不可用。",
    'ip_ctrl__ip_addr' => "IP 位址 %2 位於介面 %1",
    'ip_ctrl__ip_exists_many_pools' => "無法更改IP類型。此IP位址同時屬於幾個用戶的IP池。",
    'ip_ctrl__ssl_cert' => "SSL/TLS 證書",
    'ip_pool__ip_address_is_absend_in_pool' => "IP 地址沒找到。",
    'ip_pool__ip_pool_for_client' => "客戶%1的IP位址集區",
    'ip_pool__no_cliens_avail' => "無可用客戶。",
    'ip_pool__no_vacant_ips' => "尚無空閒的IP。",
    'ip_pool__pool_is_empty' => "IP池為空。",
    'ip_pool__remove_ip_addr' => "這些IP位址將從池%1中刪除：",
    'ip_pool__select_free_ips' => "空閒 IP",
    'limit__date_in_past' => "有效期無效。%1 已經過去。",
    'limit__enter_date' => "輸入日期",
    'limit__max_db' => "資料庫",
    'limit__name_disk_space' => "磁碟空間",
    'limit__name_max_box' => "郵箱",
    'limit__name_max_db' => "MySQL 資料庫",
    'limit__name_max_dom' => "域名",
    'limit__name_max_maillists' => "郵寄清單",
    'limit__name_max_subdom' => "子域名",
    'limit__name_max_traffic' => "流量",
    'limit__name_max_wu' => "網站用戶",
    'limit__name_mbox_quota' => "郵箱配額",
    'limit__name_max_mn' => "郵件帳戶的最大數量",
    'limit__name_max_cl' => '客戶',
    'limit__name_total_mboxes_quota' => "郵箱總配額。",
    'limit__name_mysql_dbase_space' => "MySQL 資料庫空間",
    'limit__name_mssql_dbase_space' => "MySQL資料庫空間",
    'limit__name_expiration' => '到期日',

    'locale_upload__title' => '添加區域設定',
    'locale_upload__file_name' => '語言包檔路徑',
    'locale_upload__unable_to_install' => '無法安裝語言包檔',
    'locale_upload__wrong_package' => '你上傳的檔不包含該 Plesk 版本有效的語言包。',
    'locale_upload__wrong_locale' => '您上傳的檔不包含有效的語言包。',

    'locales_remove__title' => '刪除區域設定',
    'locales_remove__select_locales_for_remove' => '選擇要刪除的區域設定',
    'locales__can_not_remove' => '無法刪除區域設定%1的語言包：%2',

    'ma__create_title' => '為 %1 創建郵件別名',
    'ma__edit_title' => "編輯郵件別名 %1",
    'ma__enter_new_alias' => "輸入新別名。",
    'ma__invalid_alias' => "無效郵件別名。",
    'ma__mail_aliases_mailname' => "郵件帳戶%1的郵件別名",
    'ma__mailname_does_not_exist' => "郵件帳戶不存在。",
    'ma__select_ma_for_remove' => "選擇要刪除的郵件別名。",
    'ma__unable_to_add_new_ma' => "無法添加郵件別名：%1",

    'mail__white_list' => "白名單",
    'mail__white_list_add' => '添加網路',
    'mail__white_list_remove' => '下列網路將被刪除:',
    'mail__white_list_remove_warning_webmail' => '刪除下列網路可能會導致從 web 郵箱發送郵件失敗: %1。',
    'mail__white_list_member' => '允許的網路',
    'mail__white_list_empty_selection_for_remove' => '選擇要刪除的項目。',
    'mail_queue__not_allowed_by_license_key' => '該許可證不允許郵件佇列管理。',
    'maillist__' => "郵寄清單 %1",
    'maillist__already_exists' => "郵寄清單已存在。",
    'maillist__mail_alias_already_exists_in_this_domain' => "郵件別名 %1 已經存在於此域名中。",
    'maillists__' => "郵寄清單 %1",
    'maillists__limit_cl_max_maillists' => "已達到客戶(限制: %1，已使用: %2)的郵寄清單數量上限。",
    'maillists__limit_dom_max_maillists' => "已達到域名的郵寄清單數量上限。",
    'maillists__list' => "郵寄清單",
    'maillists__mailman_not_installed_or_conf' => "Mailman伺服器擴展目前尚未在伺服器上安裝或配置。\n請聯繫伺服器管理員進行安裝或配置。",
    'maillists__status' => "郵寄清單服務已啟用",
    'maillists__unable_to_delete__' => "無法刪除郵寄清單：%1",
    'maillists__disabled_text' => '因 Mailman 郵寄清單伺服器元件尚未安裝或未配置，導致無法管理郵寄清單。',
    'maillist_member__already_exists' => '郵寄清單訂戶已存在。',
    'maillist_member__not_exists' => '郵寄清單中沒有此用戶。',
    'mailserver_switching_warning' => "警告!\n\n更改郵件伺服器僅可以在初始安裝時進行，如果伺服器已使用，這將會引起下列問題：丟失設定和郵箱內容，如果切換到的目標伺服器已完成配置，則會引起各種衝突。\n如果此伺服器正在使用，而您確定要切換到另一台伺服器，請提前通知客戶，以便他們/她們可以下載和保存郵件。",
    'manager__access_denied' => "拒絕存取：%1",
    'manager__admin' => "管理員",
    'manager__client' => '客戶',
    'manager__domain' => "域名",
    'manager__domain_cl_limit_exceeding' => "已達到此客戶帳戶的域名數量限制。",
    'manager__domain_is_not_yours' => "域名%1不屬於您。",
    'manager__domain_key_limit_exceeding' => "已達到您的許可證設定的可創建域名數量上限。",
    'manager__no_perm_to_call' => "許可權不足，無法調用%1。",
    'manager__no_perm_to_create_domains' => "許可權不足，無法創建域名。",
    'manager__no_perm_to_modify_domain' => "許可權不足，無法修改域名%1。",
    'manager__no_perm_to_modify_domains' => "許可權不足，無法修改域名。",
    'manager__no_perm_to_remove_domain' => "許可權不足，無法刪除域名%1。",
    'manager__no_perm_to_remove_domains' => "許可權不足，無法刪除域名。",
    'manager__node_doesnt_exist' => "%1不存在。",
    'manager__user_disabled' => "您的帳戶已掛起。您無法作業系統。",
    'mail_quota_unsupported' => "郵件伺服器不支援",
    'mbox_quota_unsupported' => "郵件伺服器不支援",
    'mn__create_title' => "創建郵件帳戶",
    'mn__edit_title' => "設定",
    'mn__files_list_title' => "附件檔",
    'mn__files_remove' => "從附件庫中刪除檔。這些檔可能被用於自動回復。它們將從附件庫和使用它們的自動回復中同時刪除。",
    'mn__files_select_for_remove' => "選擇要刪除的檔。",
    'mn__mail_alias_form' => "郵件別名格式",
    'mn__mail_aliases_list' => "郵件別名",
    'mn__mailbox' => "郵箱管理",
    'mn__unable_define_mn' => "無法設定郵件帳戶：%1",
    'mn__unable_remove_mbox_quota' => "無法刪除郵箱配額: %1",
    'mn__upload_file' => "上傳文件",
    'mn_edit__attach_filename_changed' => '上傳的檔%1已被重命名為%2，因為其原名包含非ASCII字元。',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "在啟用郵件組之前，您必須至少添加一位郵件組成員。",
    'mn_edit__add_resp_or_turn_off_box' => "請添加自動回復，或清空自動回復核取方塊。",
    'mn_edit__attachments' => "附件",
    'mn_edit__dom_quota_less_then_quota' => "郵箱配額值不可以超出為此域名定義的郵箱配額總量。",
    'mn_edit__enter_external_rcpnt_email' => "輸入外部郵件組成員的電郵地址",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "請輸入郵件轉發位址，或者清空此核取方塊。",
    'mn_edit__ext_rcpnt_email_invalid' => "外部收件人的電子電郵地址無效。",
    'mn_edit__file_exists' => "文件已存在。覆蓋嗎？",
    'mn_edit__files_deld_from_repository' => "這些檔將從包含它們的庫中或自動回復中刪除。您要繼續嗎？",
    'mn_edit__mail_name' => "郵件帳戶",
    'mn_edit__mail_name_invalid' => "郵件帳戶名無效。",
    'mn_edit__mail_redir' => "郵件轉發器",
    'mn_edit__mail_redir_add' => "添加郵件組成員",
    'mn_edit__mail_resps' => "郵件自動回復",
    'mn_edit__mailbox' => "郵箱",
    'mn_edit__enable_mailbox' => "郵箱",
    'mn_edit__mailgroup' => "郵件組",
    'mn_edit__mailgroup_addresses' => "郵件組成員",
    'mn_edit__mailgroup_disabled' => "僅當添加郵件名之後才可以使用。",
    'mn_edit__max_dom_quota' => "域名 (%1) 默認使用",
    'mn_edit__mbox_quota_invalid' => "郵箱配額無效。",
    'mn_edit__new_resp_name' => "新建自動回復名",
    'mn_edit__no_autoresponders' => "在打開/關閉自動回復服務之前，您必須至少添加一個自動回復。",
    'mn_edit__no_file_sel' => "尚未選擇檔。",
    'mn_edit__no_mail_addresses' => "未指定或選擇電子電郵地址。",
    'mn_edit__none' => "無",
    'mn_edit__not_create_pass' => "此項操作不會為帳戶創建密碼。\n使用者不使用密碼將無法查看和/或發送郵件。",
    'mn_edit__redir_email_invalid' => "電子郵件轉發位址無效。",
    'mn_edit__redirect_addr' => "轉發地址",
    'mn_edit__remove_autoresp?' => "您確定要刪除自動回復嗎？",
    'mn_edit__remove_rcpnts?' => "您確定要刪除這些收件人嗎？",
    'mn_edit__repository' => "庫",
    'mn_edit__resps_attach' => "自動回復郵件的附件",
    'mn_edit__select_rcpnt_from_list' => "請至少從列表中選擇一種要刪除的收件人。",
    'mn_edit__select_registered_users' => "選擇已註冊用戶",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "您選擇創建一個郵箱，但沒有為它設定密碼。",
    'mn_edit__unable_act_deact_mail_group' => "無法啟用/禁用郵件組: %1",
    'mn_edit__unable_act_deact_mail_redir' => "無法啟用/禁用郵件轉發: %1",
    'mn_edit__unable_act_deact_postbox' => "無法啟用/禁用郵箱: %1",
    'mn_edit__unable_act_deact_resp' => "無法啟用/禁用自動回復: %1",
    'mn_edit__unable_add_attach' => "無法添加附件：%1。",
    'mn_edit__unable_add_mail_group_member' => "無法添加郵件組成員：%1。",
    'mn_edit__unable_add_resp' => "無法添加自動恢復: %1",
    'mn_edit__unable_change_mail_name' => "無法更改郵件帳戶名：%1",
    'mn_edit__unable_deactivate_mail_group' => "無法禁用郵件組：%1。",
    'mn_edit__unable_deactivate_resp' => "無法禁用郵件自動回復: %1",
    'mn_edit__unable_define_resp_id' => "無法定義自動回復ID: %1",
    'mn_edit__unable_remove_attach' => "無法刪除附件：%1。",
    'mn_edit__unable_remove_autoresp' => "無法刪除自動回復: %1",
    'mn_edit__unable_remove_mail_group_member' => "無法刪除郵件組成員：%1",
    'mn_edit__wrong_way' => '無法將郵件發送到%1，此郵件帳戶沒有郵箱，或郵件轉發器已啟用。',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => '地址為%1的郵箱已關閉。此郵箱中的郵件並未刪除，但您無法通過IMAP或POP3檢索這些郵件。',
    'mn_list__mail_names_for_domain' => "域名%1的郵件帳戶",
    'mn_list__sa_cannot_unable' => "無法啟用垃圾郵件過濾功能",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => '客戶',
    'mn_list__tab_title_domain' => '域名',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "名稱",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "無法刪除郵件帳戶：%1",
    'no_psa_mails_matched' => "尚無郵件帳戶符合輸入的模式字串。",
    'module_upload__module_was_installed' => '該模組已被安裝。如果您想要安裝該模組的新版本，請通過 Plesk 卸載該模組，然後再試。',
    'module_upload__unable_to_install' => '無法安裝模組包檔',
    'module_upload__wrong_package' => '上傳的檔不是受支援的模組包。',
    'module_upload__wrong_module' => '上傳的檔不包含模組包。',

    'news_articles_title' => 'Plesk 新聞',
    'notification_text__invalid_subject_length' => "通知主題長度無效。應為 1 到 255 個字元。",
    'notification_text__invalid_text_length' => "無效的通知文本長度。應當包含 1 到 65533 個字元。",
    'notification_text__subject' => "通知主題",
    'notification_text__text' => "通知文本",
    'notification_text__title' => "編輯通知",
    'notification_text__unable_set_text' => "無法修改通知文本：",

    'odbc__cant_add_dsn' => "無法添加 DSN %1：%2",
    'odbc__cant_build_connection_string' => "無法使用指定的參數進行連接，請用不同的參數重新嘗試。實用程式返回：%1",
    'odbc__cant_connect' => "無法使用定義的設定連接到資料來源。伺服器返回：%1。",
    'odbc__cant_delete_dsn' => "無法刪除 DSN %1：%2。",
    'odbc__cant_get_drivers_info' => "無法獲得驅動程式相關資訊。",
    'odbc__cant_get_drivers' => "無法檢索 ODBC 驅動程式的清單：%1。",
    'odbc__cant_get_list' => "無法檢索現有 DSN 的列表：%1。",
    'odbc__cant_get_servers_list' => "無法檢索伺服器列表。",
    'odbc__cant_open_info_file' => "無法打開ODBC驅動程式資訊檔。",
    'odbc__cant_parse_string' => "無法分析連接字串。",
    'odbc__connect_success' => "連接成功",
    'odbc__driver_not_set' => "驅動程式沒有設定",
    'odbc__driver_or_name_not_set' => "ODBC 的驅動程式或名稱沒有設定",
    'odbc__dsn_already_exists' => "系統中已存在此名稱 (%1) 的 DSN",
    'odbc__dsn_not_exists' => "此 DSN 不存在",
    'odbc__enter_connection_params' => "ODBC連接配置",
    'odbc__enter_dsn_name' => "輸入 DSN 名稱",
    'odbc__invalid_dsn_name' => "ODBC 連接名 (%1) 語法錯誤：只能使用字母或者數位。",
    'odbc__no_such_driver' => "不支援使用該名稱 (%1) 的 ODBC 驅動程式。",
    'odbc__remove_page_title' => "即將移除下列ODBC DSN連線:",
    'odbc__select_dsn_to_remove' => "選擇要刪除的 DSN。",
    'odbc__unknown_driver' => "未知的驅動程式名稱 (%1)。",
    'odbc_add_new' => "添加 DSN 連接",
    'odbc_driver' => "驅動程式",
    'odbc_dsn_description' => "連接描述",
    'odbc_dsn_list' => "ODBC DSN 連接",
    'odbc_dsn_name' => "連接名",
    'odbc_dsn_system' => "系統 DSN",
    'odbc_dsn_text' => "ODBC DSN",
    'odbc_dsn_add__title' => '添加 ODBC DSN',
    'odbc_req_field_not_set' => "未提供所需的參數。",

    // Descriptions of parameters of ODBC connection string
    'odbc__access_dbq' => '資料庫檔路徑',
    'odbc__access_pagetimeout' => '未使用頁面在緩存中保留的時段以 0.1 秒計。該選項適用於所有使用 Microsoft Access 驅動程式的資料來源。',
    'odbc__access_maxbuffersize' => '內部緩衝區的大小，以 KB 計，按 256 KB 的單位排列。',
    'odbc__access_readonly' => '將資料庫指定為唯讀狀態以禁止任何升級。',
    'odbc__access_exclusive' => '將資料庫指定為獨佔狀態以禁止共用更新。',
    'odbc__access_safetransactions' => '如果是預設值 0，所有的事務會立即 commit。如果是 1，所有的事務會通過一次 commit 操作保存到硬碟，但是性能將會略微下降。',
    'odbc__access_threads' => '引擎要使用的後臺執行緒數量。',
    'odbc__access_maxscanrows' => "根據現有資料設定列的資料類型時，要掃描的行數。",
    'odbc__access_implicitcommitsync' => '指定事務外部更改如何寫入資料庫中。',
    'odbc__access_usercommitsync' => '指定 MS Access 驅動程式是否顯式同步執行使用者定義的事務。',
    'odbc__mssql_server' => '伺服器',
    'odbc__mssql_uid' => '登入 ID',
    'odbc__mssql_pwd' => '密碼',
    'odbc__mssql_database' => 'ODBC 資料來源的預設資料庫',
    'odbc__mssql_app' => '應用程式名稱',
    'odbc__mssql_wid' => '工作站ID',
    'odbc__mssql_language' => '預設使用的國家語言',
    'odbc__mssql_oemtoansi' => '此參數指定了是否將擴充字元轉換為OEM值',
    'odbc__mysql_server' => 'MySQL伺服器的主機名稱',
    'odbc__mysql_database' => '預設資料庫',
    'odbc__mysql_user' => '用於連接到MySQL的用戶名',
    'odbc__mysql_password' => '伺服器上的使用者帳戶密碼',
    'odbc__mysql_port' => '如果伺服器不是本地主機，則使用TCP/IP埠',
    'odbc__mysql_socket' => '如果伺服器是本地主機，Windows將使用具名管道來連接',
    'odbc__mysql_option' => '指定MyODBC如何工作的選項。請參見<a target="_blank" href="http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">http://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html。</a>',
    'odbc__excel_dbq' => '資料庫檔路徑',
    'odbc__excel_defaultdir' => '預設資料路徑',
    'odbc__excel_fil' => '資料庫版本',
    'odbc__excel_maxbuffersize' => '緩衝區最大值',
    'odbc__excel_pagetimeout' => '頁面超時',

    'pb__aliases' => "別名",
    'pb__anonftp' => "匿名FTP",
    'pb__autoinstaller_releases' => '更新程式',
    'pb__cert' => "證書",
    'pb__cl_pool' => "IP 地址",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "設定",
    'pb__cl_rpt' => "報告",
    'pb__cl_rpt_list' => "自訂",
    'pb__cl_templates' => "客戶範本",
    'pb__cl_traffic' => "流量",
    'pb__cl_traffic_history' => "流量歷史",
    'pb__cl_traffic_of' => "%1 的流量",
    'pb__client' => "%1",
    'pb__clients' => "客戶",
    'pb__comp_info' => "伺服器組件",
    'pb__common_acl' => '解析傳遞允許列表',
    'pb__cp_access' => "存取",
    'pb__crontab' => "計畫程式",
    'pb__scheduler' => "計畫程式",
    'pb__custom_buttons' => "自訂按鈕",
    'pb__databases_db' => '資料庫',
    'pb__sqlservers_db' => 'SQL Server',//to check
    'pb__db' => "資料庫",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => '資料庫伺服器',
    'pb__dl_usr_ed' => "域名管理員",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "域名限額",
    'pb__dom_pref' => "設定",
    'pb__dom_sum_report' => "域名摘要報告",
    'pb__dom_templates' => "域名範本",
    'pb__dom_traffic' => "%1 的流量",
    'pb__dom_traffic_history' => "流量歷史",
    'pb__domains' => "域名",
    'pb__domain_aliases' => '域名別名',
    'pb__dumps_list' => "備份檔案存儲",
    'pb__forwarding_setup' => "轉發設定",
    'pb__filemanager' => "檔案管理員",
    'pb__ip_aliasing' => "IP地址",
    'pb__ip_clients' => "IP 地址刪除",
    'pb__license_management' => '授權管理',
    'pb__locales' => '區域設定',
    'pb__log_files' => "日誌檔",
    'pb__mail' => '郵件',
    'pb__mail_blocked_domains' => '黑名單',
    'pb__mail_name_files' => "附件檔",
    'pb__mail_name_redirects' => "郵件轉發器",
    'pb__mail_name_resp_attach_add' => "新建附件",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "郵件自動回復",
    'pb__mail_names' => "郵件",
    'pb__mail_white_list' => '白名單',
    'pb__maillists' => "郵寄清單",
    'pb__mimetypes' => 'MIME類型',
    'pb__modules' => '模組',
    'pb__modules_management' => '管理模組',
    'pb__notifications' => "通知",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "物理主機設定",
    'pb__prtd_dirs' => "受保護目錄",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "報告",
    'pb__report_auto' => "%1的發送計畫",
    'pb__report_list' => "自訂",
    'pb__server' => "伺服器",
    'pb__sessions' => "會話",
    'pb__sapp_pool' => "Web應用程式池",
    'pb__siteapp_install' => 'Web應用程式安裝',
    'pb__site_app_pkgs' => 'Web應用程式',
    'pb__site_apps' => "Web應用程式",
    'pb__additional_key_info' => '許可證屬性',
    'pb__additional_key_properties' => '許可證屬性',
    'pb__skeleton' => '虛擬主機範本',
    'pb__skins' => '皮膚',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "垃圾郵件篩檢程式",
    'pb__statistics' => "統計",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "子域名",
    'pb__templates' => "範本",
    'pb__virtualdirs' => '虛擬目錄',
    'pb__web_users' => "網站用戶",
    'pb__webalizer_preferences' => '網站統計設定',
    'pdir__enter_dir_name' => "輸入 URL。",
    'pdir__invalid_hst' => "主機類型無效。必須是物理主機。",
    'pdir__pd_id_is_undefined' => "未定義受保護目錄ID。",
    'pdir__pdir_exist' => "相同 URL 已受保護。",
    'pdir__pdir_not_exist' => "受保護 URL 不存在。",
    'pdir__pdir_usr_not_exist' => "受保護 URL 用戶不存在。",
    'pdir__prdirs_for_domain' => "網站 %1 下受保護的目錄",
    'pdir__prdirs_for_subdomain' => "子域名%1的受保護目錄",
    'pdir__remove_pdir_usrs' => "網站%1的受保護目錄 %2的下列使用者將被刪除:",
    'pdir__remove_pdir_usrs_on_subdom' => "子域名%1中受保護目錄%2的下列使用者將被刪除:",
    'pdir__remove_pdirs_on_dom' => "此操作將刪除客戶%1名下網站%2的受保護目錄。目錄本身並不會被刪除。",
    'pdir__remove_pdirs_on_subdom' => "此操作將刪除子域名%1的目錄保護，目錄本身並不會被刪除。",
    'pdir__select_pdir_usrs_for_remove' => "選擇要刪除的受保護目錄的使用者。",
    'pdir__select_pdirs_to_remove' => "選擇要從中移除保護的 URL。",
    'pdir__unable_define_pdir_users' => "無法定義受保護 URL 用戶。",
    'pdir__unable_define_pdirs_properties' => "無法設定受保護目錄的屬性: %1",
    'pdir__unable_select_dom_param' => "無法選擇域名參數：%1。",
    'pdir_ed__create_pdir_for_domain' => "在網站 %1 下創建受保護目錄",
    'pdir_ed__create_pdir_for_subdomain' => "在子域名 %1 下創建受保護目錄",
    'pdir_ed__dir_already_protect' => "此 URL 已受保護。",
    'pdir_ed__head_txt' => "受保護區的標題",
    'pdir_ed__invalid_login' => "指定的用戶名錯誤。",
    'pdir_ed__login_exists' => "此用戶已存在。請嘗試指定其他用戶名。",
    'pdir_ed__new_usr' => "用戶名",
    'pdir_ed__non_ssl' => "非 SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "目錄名稱",
    'pdir_ed__pdir_for_domain' => "域名%2上的受保護 URL %1",
    'pdir_ed__pdir_for_subdomain' => "子域名%2上的受保護目錄%1",
    'pdir_ed__pdir_location' => "目錄位置",
    'pdir_ed__pdir_users' => "受保護 URL 用戶",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_not_supported_domain' => "此網站不支援 SSL/TLS，或您的訂閱不包括此功能。若要啟用 SSL/TLS 支援，轉到 網站與域名 標籤，按一下列表中的域名。若您的訂閱不提供 SSL/TLS 支援，請聯繫主機服務商升級主機方案。",
    'pdir_ed__ssl_not_supported_domain_powerUser' => "此網站不支援 SSL/TLS。若要啟用 SSL/TLS 支援，轉到 網站與域名 標籤，在列表中點按該域名。",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "SSL/TLS 核取方塊和非 SSL/TLS 核取方塊中至少必須選擇一個。",
    'pdir_ed__unable_cr_pdir_usr' => "無法創建受保護 URL 用戶：%1。",
    'pdir_ed__unable_create_pdir' => "無法創建受保護 URL：%1",
    'pdir_ed__unable_define_hst_type' => "無法定義主機類型。",
    'pdir_ed__unable_update_pdir' => "無法更新受保護目錄: %1",
    'pdir_ed__wrong_symbol_in_header' => "請不要在目錄標題中使用符號%1",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "為受保護 URL %1 創建用戶",
    'pdir_usr_ed__not_create_pass' => "此項操作不會為新建的受保護目錄使用者創建密碼。\n使用者不使用密碼將無法登入。",
    'pdir_usr_ed__pass_for_pdir_usr' => "受保護 URL 使用者 %1 的密碼。",
    'pdir_usr_ed__unable_select_pdir_usr' => "無法選擇受保護 URL 用戶：%1。",
    'pdir_usrs_list__unable_define_pdir_usrs' => "無法定義受保護 URL 用戶：%1。",
    'pdir_usrs_list__unable_remove_pd_usrs' => "無法刪除受保護 URL 用戶：%1。",
    'pdirs_list__name' => "名稱",
    'pdirs_list__tab_title_non_secure_dir' => "N",
    'pdirs_list__tab_title_secure_dir' => "S",
    'pdirs_list__tab_title_cgi_bin_dir' => "C",
    'pdirs_list__unable_remove_pdirs' => "無法刪除受保護目錄：%1。",
    'phosting__anonftp_disabled' => "此域名的匿名FTP服務已禁用，因為此IP地址已用於其他域名的匿名FTP服務。",
    'phosting__anonftp_encrypt' => '由於FTP使用者密碼已加密，因此無法用於保護目錄 /plesk-stat/webstat/。請重新輸入FTP密碼，或清除選項 "可通過有密碼保護的目錄 \'/plesk-stat/webstat/\' 進行存取。"',
    'phosting__hosting_and_dns_ip_difference_warning' => "該網站名%%domain_name%%解析至IP地址 %%dns_ip_address%%。您的網站被分配IP地址%%hosting_ip_address%%。如果通過網站名無法在Web瀏覽器中打開網站，那麼請轉到DNS管理螢幕 (網站 > 網站名稱 > DNS) 並更改A資源記錄的屬性：將IP地址%%hosting_ip_address%%分配給網站名%%domain_name%%。",
    'phosting__ip_change_warning' => "IP 地址已更改。域名的 DNS 區域也已進行了相應更改。",
    'phosting__other_hosting_exists_on_ip' => "無法更改證書，因為此IP位址正被一個或多個主機帳戶所使用。",
    'phosting__unable_to_change_certificate' => "無法安裝證書：%1",
    'phosting__unable_to_change_ip_address' => "無法更改IP地址：%1",
    'phosting__unable_to_set_cert' => "無法設定 SSL/TLS 證書:%1",
    'phosting__unable_update' => "無法更新主機設定: %1",
    'phosting__unable_manage' => "無法管理主機：%1。",
    'phosting__failed_to_add_logs_fail2ban' => "無法配置 fail2ban 跟蹤域名的日誌。fail2ban 服務下一次重啟時將會自動跟蹤日誌。\n%1",

    'picker_acl_record__tittle' => '選擇一個ACL記錄',
    'picker_autoresponder__title' => '選擇自動回復',
    'picker_black_list__domain_name' => '選擇一個域名',
    'picker_certificate' => '選擇一個 SSL/TLS 證書',

    'picker_dns_zone_template__title' => '選擇一個資源記錄',
    'picker_domain__title' => '選擇網站',
    'picker_domain_alias__title' => '選擇域名別名',
    'picker_resource_record__title' => '選擇一個資源記錄',
    'picker_disabled_resource_record__title' => '選擇域名伺服器',
    'picker_ip_address__title' => '選擇IP位址',
    'picker_ip_address_clients__title' => '選擇使用此IP位址的客戶',
    'picker_mail_queue' => '選擇郵件資訊',
    'picker_site_application__title' => '選擇Web應用程式',
    'picker_subdomain__title' => '選擇子域名',
    'picker_web_user__title' => '選擇網站用戶',
    'picker_custom_button__title' => '選擇自訂按鈕',
    'picker_license_key__title' => "選擇許可證",
    'picker_spamfilter_address__title' => '選擇一個垃圾郵件篩檢程式位址',
    'picker_white_list__networks' => '網路選擇',

    'plesk_key__action_logs' => "由 Plesk 用戶執行的登入操作",
    'plesk_key__app_vault' => "應用百寶箱",
    'plesk_key__backup' => "備份及恢復功能",
    'plesk_key__client_templs' => "服務方案管理",
    'plesk_key__clients' => "使用者帳戶(代理商與客戶)",
    'plesk_key__resellers_only' => "使用者帳戶（代理商）",
    'plesk_key__customers_only' => "使用者帳戶（客戶）",
    'plesk_key__domains' => "域名",
    'plesk_key__domain_aliases' => "域名別名",
    'plesk_key__manage_dashboard' => '自訂首頁',
    'plesk_key__drweb' => "防病毒程式管理",
    'plesk_key__event_manager' => "事件管理器",
    'plesk_key__expirations' => "帳戶過期日管理",
    'plesk_key__group_ops' => "允許批量修改",
    'plesk_key__expiration' => "許可證過期時間",
    'plesk_key__edition_name' => "Plesk 版本",
    'plesk_key__key_number' => "許可證號",
    'plesk_key__languages' => "語言包",
    'plesk_key__mailnames' => "郵件帳戶",
    'plesk_key__migration_manager' => "遷移與傳輸管理器",
    'plesk_key__mssql' => "Microsoft SQL Server支援",
    'plesk_key__myplesk_func' => "購買 SSL/TLS 證書及域名註冊服務的連結",
    'plesk_key__myplesk_server_id' => "MPC 從屬伺服器識別字",
    'plesk_key__notifications' => "通知管理",
    'plesk_key__postgresql' => "PostgreSQL資料庫伺服器支援",
    'plesk_key__qmail_queue' => '郵件佇列管理',
    'plesk_key__remote_db' => '遠端資料庫主機',
    'plesk_key__slave_servers' => "從屬伺服器",
    'plesk_key__spamassassin' => "垃圾郵件篩檢程式管理。",
    'plesk_key__subdomains' => "子域名管理",
    'plesk_key__sys_access' => "對存取伺服器的管理",
    'plesk_key__traffic_reports' => "流量使用報告",
    'plesk_key__tts' => "幫助桌面",
    'plesk_key__virtuozzo' => "僅對 Virtuozzo 容器有效",
    'plesk_key__webusers' => "網站用戶",
    'plesk_key__license_update_date' => '許可證下一次更新日期',
    'plesk_key__autoinstaller_config' => '更新程式設定管理',
    'plesk_key_update__title' => '許可證更新狀態',
    'plesk_key_update__legend' => '許可證更新狀態',
    'plesk_key_update__new_additional_key' => '其他新許可證已收到',
    'plesk_key__check_wrong' => "許可證金鑰無效。若要使用 Plesk，請獲取並安裝一個新的有效的許可證金鑰。",
    'plesk_key__upload_check_wrong' => '上傳的許可證無效。',
    'plesk_key__revert_check_wrong' => '之前安裝的許可證無效。',
    'plesk_key__update_check_wrong' => '更新的許可證無效。',
    'plesk_key__viruozzo_only_key' => '此許可證金鑰僅適用於在 Virtuozzo 容器內操作 Plesk。',
    'plesk_key__ip_ranges_exceeded' => '您只能把該許可授權的 Plesk 副本用於以下的 IP 地址：%2。您的許可證並未覆蓋以下的 IP 位址：%1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => '當前使用的資源量超過了您的許可證定義的限制。',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => '伺服器上託管的網站數量超出許可證指定的限制。您有%2個託管的網站；您的許可證僅允許託管%1個網站。',
    'plesk_key__limits_exceeded_lim_domain_aliases' => '伺服器上域名別名的數量超過了您許可證所定義的限制。您有%2個域名別名；您的許可證僅允許託管%1個域名別名。',
    'plesk_key__limits_exceeded_lim_cl' => '所服務的客戶帳戶數量超出許可證指定的限制。當前服務的客戶帳戶為%2；您的許可中僅允許服務%1個客戶帳戶。',
    'plesk_key__limits_exceeded_lim_mn' => '所服務的電子郵件帳戶數量超出許可證指定的限制。當前所服務的電子郵件帳戶數量為 %2；您的許可證僅允許服務 %1 個電子郵件帳戶。',
    'plesk_key__limits_exceeded_lim_wu' => '所服務的網站使用者帳戶數量超出許可證指定的限制。當前服務的網站使用者帳戶為%2；您的許可證僅允許服務%1個網站使用者帳戶。',
    'plesk_key__limits_exceeded_MLS' => '當前安裝的語言包數量超出許可證指定的限制。已安裝了%2個語言包；您的許可證只允許安裝%1個語言包。',
    'plesk_key__wrong_version' => '您正在嘗試使用為其它 Plesk 版本創建的許可證金鑰。請聯繫 Plesk 銷售代表獲取正確的許可證金鑰。',
    'plesk_key__other_product' => '您正在嘗試使用為其它產品創建的許可證金鑰。請聯繫 Plesk 銷售代表獲取正確的許可證金鑰。',
    'plesk_key__limits_exceeded_error' => '無法安裝許可證: 當前的控制台資源使用超過了上傳的許可證中定義的限制。',
    'plesk_key__limits_exceeded_note' => '當前的控制台資源使用超過了上傳的許可證中定義的限制。',
    'plesk_key__key_file_invalid' => '上傳的授權檔案無效或不包含許可證。',
    'plesk_key__server_request_error' => '無法更新授權。確認透過連接授權伺服器 ka.plesk.com 的 TCP 連結埠 %1 未被封鎖。<a href="https://support.plesk.com/hc/en-us/articles/213383529" target="_blank">瞭解如何這麼做</a>。',
    'key__title' => '授權管理',
    'key__upload_title' => '安裝許可證金鑰',
    'key__no_key_file_in_zip' => '上傳的 .zip 檔不包含授權檔案',
    'key__key_upload' => '許可證安裝',
    'key__tabs_plesk' => 'Plesk 許可證號',
    'key__tabs_additional' => '其他許可證',
    'key_revert__title' => '恢復許可證',
    'key_revert__legend' => '確認恢復許可證',
    'key_revert__text' => '具有下列屬性的許可證將被恢復:',
    'key__license_update_date_hint' => '%%license_update_date%% 之後，過期日期將自動延長。要自動更新，您須允許至 %%keyserver_host%% 的連接。有關更多資訊，請參閱 %%help begin:lim_date%%下列說明主題%%help end:lim_date%%。',
    'additional_key__info' => '其他許可證屬性',
    'additional_key__prop_name' => '屬性',
    'additional_key__prop_value' => '值',
    'additional_key__descr_name' => '許可證名稱',
    'additional_key__descr_key_number' => '許可證號',
    'additional_key__descr_key_vz' => "該許可證只能用於 Virtuozzo 容器中。",
    'additional_key__descr_lim_date' => '到期日',
    'additional_key__descr_license_update_date' => '許可證下一次更新日期',
    'additional_key__remove_title' => "即將刪除具有下列屬性的web應用程式許可證:",
    'additional_keys__remove_title' => "下列附加許可證將被刪除：",
    'additional_keys__select_to_remove' => '選擇要刪除的其他許可證。',
    'additional_key__file_invalid' => '上傳的授權檔案無效或不包含許可證。',
    'additional_key__file_incompatible' => '上傳的授權檔案不能用於此應用程式。',
    'additional_key__expired' => '其他許可證已過期。',
    'additional_key__not_exists' => '尚未安裝許可證。',
    'additional_key__viruozzo_only_key' => '該許可證只能用於在 Virtuozzo 容器中安裝的 Plesk',
    'additional_keys__legend' => '其他許可證',
    'additional_keys__list_header' => '其他許可證',
    'additional_key_update__result_response' => '許可伺服器回應：%1',
    'additional_key_update__result_network' => '無法連接許可伺服器。請確保網路可以與%1通信：%2。',
    'additional_key_update__result_lock' => '正在更新許可證',
    'additional_key_update__result_internal_error' => '更新許可證時發生錯誤：%1',

    'additional_key_revert__title' => '請確認操作',
    'additional_key_revert__legend' => '以前使用的其他許可證的屬性',
    'additional_key_revert__confirm_text' => '恢復許可證',
    'additional_key_revert__confirm_required' => '請確認操作。',

    'proceed_to_cl_pool' => "繼續配置客戶的IP位址集區",
    'proceed_to_hosting_setup' => "進入主機設定",
    'removeCerts__remove_certificates_cp' => "下列證書將被刪除：",
    'removeCerts__remove_certificates_domain' => "%1 所有的下列證書將被刪除：",
    'removeClientsIP_remove_clients_ip' => "此IP位址將從下列客戶的IP位址集區中刪除:",
    'removeMailAliases__remove_mail_aliases' => "將刪除郵件帳戶%1的下列郵件別名：",
    'removeMailNames__remove_mailnames' => "將從域名%1上刪除下列郵件帳戶和別名：",
    'removeMailNames__remove_mailnames_of_cl' => "下列郵件帳戶和別名將從客戶%1名下的域名%2中刪除:",
    'removeMailNames__these_mailnames_will_not_delete' => "這些郵件名將不會被刪除。",
    'removeFtpSessions__remove_title' => "下列 FTP 會話將被終止：",
    'removeTemplates__remove_templates' => "下列範本將被刪除：",
    'report_auto__list_title' => 'D',
    'report_auto__list_auto' => '頻率',
    'report_auto__list_last' => '最後發送日期',
    'report_auto__list_recipient' => '發送到',
    'report_auto__list_select' => '報告',
    'report_auto__title' => '%1的發送計畫',
    'report_auto__recipient_email' => '我指定的電郵地址',
    'report_auto__recipient_admin' => '伺服器管理員',
    'report_auto__recipient_client' => '客戶',
    'report_auto__recipient_domain' => '域名管理員',
    'report_auto_edit__select' => '報告',
    'report_auto__select_client_report_all' => '所有客戶',
    'report_auto__select_client_report_current' => '此客戶',
    'report_auto__select_client_report_other_client' => '%1',
    'report_auto__select_domain_report_all' => '所有域名',
    'report_auto__select_domain_report_other_client' => '%1的所有域名',
    'report_auto__select_domain_report_client' => '此客戶名下的所有域名',
    'report_auto__select_domain_report_reseller' => '此代理商的所有域名',
    'report_auto__select_domain_report_current' => '該域名',
    'report_auto__select_domain_report_other_domain' => '%1',
    'report_auto__legend' => '發送計畫',
    'report_auto__select_for_remove' => "選擇要刪除的發送計畫。",
    'report_auto_remove__title' => "下列報告發送計畫將被刪除：",
    'report_auto_edit__title' => '發送計畫屬性',
    'report_auto_edit__recipient' => '發送到',
    'report_auto_edit__target' => '報告',
    'report_auto_edit__auto' => '發送頻率',
    'resp_edit__always_respond' => "總是回應",
    'resp_edit__reply_subject' => "回復主題",
    'resp_edit__answer_subject' => "主題應答",
    'resp_edit__answer_txt' => "回信正文",
    'resp_edit__attach' => "附加檔",
    'resp_edit__default_subject' => "回復：%1",
    'resp_edit__for' => "用於",
    'resp_edit__frw_rqst_email' => "一旦自動回復，請將原始資訊轉發到指定的郵箱",
    'resp_edit__fwd_email_invalid' => "目的電郵地址無效。",
    'resp_edit__in_body' => "在正文中",
    'resp_edit__in_subject' => "在主題中",
    'resp_edit__invalid_resp_freq' => "回應頻率無效。",
    'resp_edit__invalid_rqst_txt' => "無效的請求文本。",
    'resp_edit__invalid_store_lim_num' => "限制值無效。",
    'resp_edit__limits_title' => "限制",
    'resp_edit__maximum_allowed_resp_freq_reached' => "每天的最大回復數量超過了設定的數值。允許：%1，請求：%2",
    'resp_edit__no_files_sel' => "尚未選擇檔。",
    'resp_edit__no_txt_supplied' => "尚未提供文本。",
    'resp_edit__reply_title' => "回復",
    'resp_edit__reply_to_address' => "回復地址",
    'resp_edit__reply_to_invalid' => "回復地址無效。",
    'resp_edit__reply_uniq_email' => "給同一個電郵地址的回復不超過",
    'resp_edit__conditions_title' => "條件",
    'resp_edit__request_title' => "請求",
    'resp_edit__resp' => "自動回復",
    'resp_edit__resp_name' => "自動回復名稱",
    'resp_edit__resp_not_exist' => "自動回復不存在。",
    'resp_edit__resp_status' => "自動回復狀態",
    'resp_edit__rqst_txt' => '請求文本',
    'resp_edit__select_files_on_server_for_attach' => "選擇要附加的檔",
    'resp_edit__store_up_to' => "存儲至",
    'resp_edit__subj_line_invalid' => "主題行有錯誤。",
    'resp_edit__text_too_big' => "回復郵件文本太長。",
    'resp_edit__times_in_a_day' => "次每天。",
    'resp_edit__unable_define_resp_cond' => "無法定義自動回復條件: %1",
    'resp_edit__unable_define_resp_status' => "無法定義自動回復狀態: %1",
    'resp_edit__unable_turn_on_resp' => "無法啟用自動回復: %1",
    'resp_edit__uniq_email' => "唯一的電郵地址",
    'resp_edit__content_type' => '郵件發送格式',
    'resp_edit__content_type_text' => '純文字',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => '文本編碼',
    'restart__dns' => 'DNS 伺服器 (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3 伺服器 (%1)",
    'restart__mssql' => "%1",
    'restart__mysql' => "MySQL Server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "服務",
    'restart__smtp' => "SMTP 伺服器 (%1)",
    'restart__spamd' => "垃圾郵件篩檢程式",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Web 伺服器 (%1)",
    'restart__ftp' => "FTP 伺服器 (%1)",
    'restart__service_start' => '請允許一定時間啟動服務。',
    'restart__service_stop' => '請允許一定時間停止服務。',
    'restart__service_restart' => '請允許一定時間重啟服務。',
    'rm_domains__some_domains_are_not_exist' => "指定的部分域名不存在。可能已被其他用戶刪除。",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "郵件組(MGroup)",
    'rpt_cl_dom_mail_lists' => "郵寄清單(MList)",
    'rpt_cl_dom_mail_resps' => "自動回復",
    'rpt_cl_dom_mail_antispam' => "垃圾郵件",
    'rpt_cl_dom_mail_antivirus' => "防病毒程式",
    'rpt_cl_dom_postboxes' => "郵箱(MBox)",
    'rpt_cl_dom_redirects' => "轉發器",
    'rpt_cl_dom_subdomains' => "子域名",
    'rpt_cl_dom_domain_aliases' => "域名別名",
    'rpt_cl_dom_web_users' => "web 用戶",
    'rpt_cl_report_for_admin__' => "針對管理員 %1 的報告",
    'rpt_cl_report_for_reseller__' => "針對代理商 %1 的報告",
    'rpt_cl_report_for_cl__' => "關於客戶 %1 的報告",
    'rpt_cl_section_domains' => "域名",
    'rpt_cl_section_full_domains' => "域名",
    'rpt_cl_section_general' => "常用",
    'rpt_create' => "創建報告",
    'rpt_empty' => "報告必須至少包含一個小節",
    'rpt_default_report' => "作為默認報告",
    'rpt_dom_report_for_dom__' => "域名%1的報告",
    'rpt_dom_section_databases' => "資料庫",
    'rpt_dom_section_full_databases' => "資料庫",
    'rpt_dom_section_full_maillists' => "郵寄清單",
    'rpt_dom_section_full_mailnames' => "郵件帳戶",
    'rpt_dom_section_full_webusers' => "網站用戶",
    'rpt_dom_section_full_siteapps' => 'Web應用程式',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET Web應用程式',
    'rpt_dom_section_general' => "常用",
    'rpt_dom_section_hosting' => "主機",
    'rpt_dom_section_maillists' => "郵寄清單",
    'rpt_dom_section_mailnames' => "郵件帳戶",
    'rpt_dom_section_siteapps' => 'Web應用程式',
    'rpt_dom_section_aspnetapps' => 'ASP.NET Web應用程式',
    'rpt_dom_section_webusers' => "網站用戶",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "編輯報告 %1",
    'rpt_enter_email_address' => "輸入報告要發往的電郵地址。",
    'rpt_list' => "自訂報告佈局",
    'rpt_name' => "報告名稱",
    'rpt_remove_reports' => "下列報告佈局將被刪除：",
    'rpt_reports' => "報告",
    'rpt_section_full' => "全量",
    'rpt_section_none' => "無",
    'rpt_section_summary' => "匯總",
    'rpt_select_reports_for_remove' => "選擇要刪除的報告佈局。",
    'rpt_default_full' => '完整報告',
    'rpt_default_summary' => '概要報告',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "發送報告時發生錯誤：%1。",
    'rpt_send_report_by_email_ok__' => "報告已發送給%1",
    'sa_action' => "操作",
    'sa_action_del' => "刪除",
    'sa_action_desc' => "反垃圾郵件的措施",
    'sa_action_save' => "標識為垃圾郵件並保存在郵箱中",
    'sa_admin_blacklist' => "管理員的黑名單",
    'sa_admin_whitelist' => "管理員的白名單",
    'sa_blacklist' => "黑名單",
    'sa_blacklist_desc' => "始終不信任以下電郵地址",
    'sa_by_tag' => "按標籤",
    'sa_conf_list_black' => "您確定要從黑名單中刪除所選模式嗎？",
    'sa_conf_list_ignore' => "您確定要從忽略名單中刪除所選模式嗎？",
    'sa_conf_list_white' => "您確定要從白名單中刪除所選模式嗎？",
    'sa_db_del_confirm' => "您確定要清空垃圾郵件篩檢程式的資料庫嗎？",
    'sa_disabled__mailserv_not_support_sa_mbox_settings' => "垃圾郵件過濾功能已禁用：郵件伺服器不支援郵箱級的垃圾郵件過濾功能。",
    'sa_eml_in_ignorelist' => "電子郵件在忽略清單中",
    'sa_eml_pattern' => "電子郵件模式",
    'sa_empty_email' => "不能添加空的電子郵件模式",
    'sa_exists_email' => "相同電子郵件模式已存在。",
    'sa_disabled__mailname_not_filtering' => "當前伺服器設定不允許對此郵件帳戶使用郵件過濾功能",
    'sa_disabled__filtering_is_disabled' => '伺服器管理員已禁用垃圾郵件過濾功能',
    'sa_disabled__hasnt_mailbox' => "如果沒有信箱，則無法啟用垃圾郵件過濾功能",
    'sa_enable_filter' => "啟用垃圾郵件過濾功能",
    'bt_sa_clear_db' => '清除垃圾郵件篩檢程式資料庫',
    'bt_sa_forget' => '忘記它',
    'bt_sa_learn_as_spam' => "這是垃圾郵件！",
    'bt_sa_learn_as_nonspam' => "這不是垃圾郵件",
    'sa_forget' => "忘記",
    'sa_from' => "來自",
    'sa_ham' => "ham",
    'sa_ignorelist' => "伺服器級忽略列表",
    'sa_ignorelist_desc' => "不要過濾這些帳戶的郵件",
    'sa_pattern_in_blacklist' => "模式已經存在於黑名單中。",
    'sa_pattern_in_ignorelist' => "模式已經存在於忽略名單中。",
    'sa_pattern_in_whitelist' => "模式已經存在于白名單中。",
    'sa_pattern_is_invalid' => "模式無效。",
    'sa_select_email' => "請至少從列表中選擇一種要刪除的郵件模式。",
    'sa_spam' => "垃圾郵件",
    'sa_trainer__page_title' => '垃圾郵件篩檢程式培訓',
    'sa_trainer__tools_legend' => '工具',
    'sa_trainer__info_legend' => '信息',
    'sa_trainer__messages_list_legend' => '郵箱中的郵件',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => '主題',
    'sa_trainer__from' => '來自',
    'sa_trainer__date' => '日期',
    'sa_trainer__info_text' => '標記郵件：%1為垃圾郵件，%2為非垃圾郵件，%3全部郵件。',
    'sa_trainer__messages' => '郵件',
    'sa_trainer__select__all' => '所有',
    'sa_trainer__select__spam_only' => '垃圾郵件',
    'sa_trainer__select__ham_only' => '非垃圾郵件',
    'sa_trainer__select__unknown_only' => '未知',
    'sa_trainer__cannot_remove_messages' => '無法從郵箱中刪除所選郵件。',
    'sa_trainer__remove_messages_confirm' => '您確定要從郵箱中刪除所選郵件嗎？',
    'sa_srv_blacklist' => "伺服器級黑名單",
    'sa_srv_whitelist' => "伺服器級白名單",
    'sa_subj' => "主題",
    'sa_training' => "垃圾郵件篩檢程式培訓",
    'sa_training_legend' => "貝葉斯篩檢程式練習",
    'sa_use_srv_settings' => "使用伺服器級設定",
    'sa_user_blacklist' => "用戶的黑名單",
    'sa_user_whitelist' => "用戶的白名單",
    'sa_usr_disabled_by_srv' => "提供商不允許單獨設定垃圾郵件過濾功能",
    'sa_usr_no_postbox' => "無法啟用垃圾郵件過濾，因為此電子郵件帳戶的郵箱已關閉。",
    'sa_whitelist' => "白名單",
    'sa_whitelist_desc' => "始終信任以下電郵地址",
    'sa_filters' => '垃圾郵件篩檢程式',
    'sa_max_mail' => '如果郵件大小超過指定大小，則不進行過濾',
    'sa_size_limit_text' => '大小限制',
    'sa_invalid__max_spam_threads' => '無效值。請輸入 1 到 32 之間的值。',
    'sa_max_threads' => '垃圾郵件篩檢程式可創建的執行緒數量',
    'sa_max_threads_maximum' => '(最大值 32)',
    'sa_disabled__spamfilter_not_support_sa_max_threads_limit' => '(無法使用：當前垃圾郵件篩檢程式不支援此選項)',
    'spamfilter__tools_legend' => '工具',
    'spamfilter__prefs_legend' => '設定',
    'spamfilter__max_children' => '可運行的 worker spamd 進程的最大數量',
    'spamfilter__rewrite_header_subject_hint' => '如果您不想添加任何文本，保持該欄位元為空。如果您想要把評分包括在資訊主題中請輸入評分。',
    'spamfilter__reject_spam' => '郵箱接收到垃圾郵件後，將其刪除',
    'spamfilter__enabled' => '已啟用',
    'spamfilter_addresses_list__tools_legend' => '工具',
    'spamfilter_addresses_list__list_legend' => '地址',
    'spamfilter_addresses_list__items' => '地址',
    'spamfilter_addresses_list__status' => 'S',
    'spamfilter_addresses_list__level' => 'L',
    'spamfilter_addresses_list__address' => '地址',
    'spamfilter_addresses__file_legend' => '來自文件',
    'spamfilter_addresses__file_label' => '檔案名稱',
    'spamfilter_addresses__file_hint' => '上傳 UTF-8 編碼的檔。',
    'spamfilter_addresses__text_legend' => '來自列表',
    'spamfilter_addresses__text_label' => '電郵地址',
    'spamfilter_addresses__remove_title' => '下列地址將從列表中刪除：',
    'spamfilter_addresses__empty_selection' => '尚未選擇位址。',
    'server__admin_info' => "管理員資訊",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "在下面輸入錯誤描述",
    'server__power_management' => "電源管理",
    'server__services' => "服務",
    'server__system' => "系統",
    'server__title' => "伺服器管理",
    'server_preferences__admin_skin' => "管理員的介面皮膚",
    'server_preferences__count_disk_space' => "包含在磁碟空間使用量計算中",
    'server_preferences__count_traffic' => "包含在流量計算中",
    'server_preferences__count_type' => '當計算磁碟空間使用量時，計算',
    'server_preferences__count_type__byte' => '文件大小',
    'server_preferences__count_type__block' => '磁碟空間使用量',
    'server_preferences__default_language' => "預設語言",
    'server_preferences__default_skin' => "默認外觀",
    'server_preferences__include_databases' => "資料庫",
    'server_preferences__include_domaindumps' => "域名備份檔案",
    'server_preferences__include_incoming' => "僅入站流量",
    'server_preferences__include_incoming_and_outgoing' => "入站和出站流量",
    'server_preferences__include_logs' => "日誌檔和統計報告",
    'server_preferences__include_mailboxes' => "郵箱",
    'server_preferences__include_maillists' => "郵寄清單",
    'server_preferences__include_outgoing' => "僅出站流量",
    'server_preferences__include_remote_databases' => '遠端資料庫',
    'server_preferences__keep_stats' => "保留網站和流量統計",
    'server_preferences__restart_apache_interval' => "Apache 重啟間隔",
    'server_preferences__stat_warning' => "對磁碟空間使用情況計算方式的更改將會在下一次計算統計資料時生效。",
    'server_preferences__title' => "伺服器設定",
    'server_preferences__system' => '系統設定',
    'server_mail__title' => "伺服器級的郵件設定",
    'mail__tabs_preferences' => "設定",
    'mail__tabs_white_list' => "白名單",
    'mail__tabs_blocked_domains' => "黑名單",
    'mail__tabs_mail_queue' => "郵件佇列",
    'server_preferences__use_vocabulary' => "檢查郵箱密碼複雜性",
    'sessions__agreement' => "是的，我希望結束這些會話。",
    'sessions__select_sessions_for_remove' => "選擇要結束的會話。",
    'sessions__tabs_cp_sessions' => 'Plesk 會話',
    'sessions__tabs_ftp_sessions' => 'FTP 會話',
    'sessions__ftp_sessions_login' => 'FTP帳戶用戶名',
    'sessions__ftp_sessions_domain' => '域名',
    'sessions__ftp_sessions_path' => '當前位置',
    'sessions__ftp_sessions_file' => '檔案名稱',
    'sessions__ftp_sessions_action' => '狀態',
    'sessions__ftp_sessions_speed' => '速度，KB/S',
    'sessions__ftp_sessions_comp' => '進度，%',

    'site_apps__access_level' => '存取級別',
    'site_apps__access_level_commercial' => '商業',
    'site_apps__access_level_free' => '免費',
    'site_apps__action_installer' => "Web應用程式安裝",
    'site_apps__action_reconfigure' => "Web應用程式重新配置",
    'site_apps__custom_button_level' => '您想要創建能夠存取該應用程式的自訂按鈕嗎？',
    'site_apps__custom_button_level_false_domain_user_only' => '否',
    'site_apps__custom_button_level_domain_user_only' => '是',
    'site_apps__custom_button_level_false' => '否',
    'site_apps__custom_button_level_domain' => '是，僅允許當前域名使用。',
    'site_apps__custom_button_level_client' => '是，允許客戶的所有域名可用',
    'site_apps__custom_button_level_admin' => '是，允許所有域名使用',
    'site_apps__description' => "描述",
    'site_apps__dir_used_by_sapp__' => "另一web應用程式正在使用目錄\"%1\"。",
    'site_apps__dir_used_by_unknown__' => "目錄\"%1\"已存在。繼續操作將覆蓋它的內容。",
    'site_apps__dir_invalid_name__' => "目錄名%1不正確",
    'site_apps__file_name' => 'Web應用程式檔案名',
    'site_apps__invalid_install_prefix' => "無效安裝首碼。",
    'site_apps__invalid_package' => "Web應用程式無效",
    'site_apps__key_status' => '許可',
    'site_apps__key_status_free' => '自由分發，不需要許可證。',
    'site_apps__key_status_ok' => '所需的許可證已經安裝',
    'site_apps__key_status_problem' => '所需的許可證尚未安裝',
    'site_apps__name' => "名稱",
    'site_apps__no_domains' => '無法安裝web應用程式。此域名的根目錄中已安裝其他web應用程式。請考慮為該web應用程式創建子域名。',
    'site_apps__package_info_' => "Web應用程式資訊",
    'site_apps__package_integrated' => "內建應用程式，無法刪除",
    'site_apps__pool_select_packages_to_add' => '選擇要添加到池中的web應用程式',
    'site_apps__release' => "發行版本本",
    'site_apps__resource_used_by_sapp' => "此資源正由已安裝的web應用程式使用",
    'site_apps__root_used_by_sapp' => "此資源正在由已安裝的web應用程式使用。",
    'site_apps__these_domains_will_not_delete' => '這些(子)域名將不會被刪除',
    'site_apps__upload_site_app_pkg_title' => '上傳新Web應用程式',
    'site_apps__version' => "版本",
    'site_apps__access_to' => "存取 %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "虛擬主機範本",
    'skeleton__client_label' => "%1 虛擬主機範本",
    'skeleton__admin_page' => "管理虛擬主機範本",
    'skeleton__files_list' => "檔與目錄",
    'skeleton__archiver_not_installed' => "無法解壓壓縮檔。伺服器上可能尚未安裝解壓程式，請聯繫{$PROD_NAME}管理員安裝解壓軟體。",
    'skeleton__client_page' => "管理虛擬主機範本",
    'skeleton__archive_corrupted' => "壓縮檔檢查發現壓縮檔已被損壞或該壓縮檔類型不被支援。",
    'skeleton__archive_too_large' => "壓縮檔檢查發現壓縮檔過大。",
    'skeleton__not_supported_archive_type' => "此類型的歸檔(檔%1)不受支援。",
    'skeleton__upload_archive_file' => "上傳壓縮檔",
    'skin_download__title' => '下載外觀',
    'skin_download_now__title' => '正在下載外觀',
    'skin_download_now__text' => '正在創建外觀包。<br>該過程可能需要一些時間。<br>在對話方塊視窗出現後，您可以繼續操作 Plesk。',
    'skin_file__help_for_using_types' => "請使用下列格式的皮膚壓縮檔:",
    'skin_info__title' => '外觀屬性',
    'skin_mng_err__rpm_not_skin' => '該 RPM 不是 Plesk 皮膚套裝程式',
    'skin_mng_err__psa_install_noreloc' => '無法在指定位置安裝基於RPM的外觀。',
    'skin_mng_err__already_exists' => '此外觀安裝目錄已存在，並且已經部署了一個外觀包。',
    'skin_mng_err__rpm_upgrade_nonrpm' => '上傳的檔沒有有效的RPM外觀包。',
    'skin_mng_err__rpm_upgrade_noskin' => '上傳的檔沒有有效的外觀包。',
    'skin_mng_err__rpm_upgrade_base' => "上傳的檔不是有效的{$PROD_NAME}外觀套裝程式。",
    'skin_mng_err__rpm_upgrade_other' => '無法安裝外觀：無效的外觀格式。',
    'skin_mng_err__no_a_skin' => "上傳的檔不是有效的{$PROD_NAME}外觀套裝程式。",
    'skin_upload__title' => '上傳新的外觀',
    'skin_upload__already_exists' => "外觀'%1'已存在。",
    'skin_upload__unable_to_apply' => "上傳的檔不包含 Plesk 皮膚，或者壓縮檔格式不被支援。",
    'skin_upload__unable_to_rename__' => "無法將外觀%2重命名為%1：%3。",
    'skin_upload__file_name' => '外觀套裝程式檔路徑',
    'skins_list__title' => '外觀庫',
    'skins_remove__title' => '刪除外觀',
    'skins_remove__select_skins_for_remove' => '選擇要刪除的外觀',

    'spamassassin__title' => "垃圾郵件篩檢程式配置",
    'spf_parameters' => 'SPF 垃圾郵件防護',
    'spf_enable_label' => '啟用 SPF 垃圾郵件防護措施以檢查傳入郵件',
    'spf_behavior' => 'SPF檢查模式',
    'spf_rules' => 'SPF本地規則',
    'spf_guess' => 'SPF猜測規則',
    'spf_exp' => 'SPF解釋文本',
    'spf__unable_update' => '無法更新SPF參數',
    'spf_bhv__create_headers_no_block' => '只創建 Received-SPF 標頭資訊，不遮罩',
    'spf_bhv__use_tmp_errors' => 'DNS查找出現問題時，使用臨時錯誤通知',
    'spf_bhv__reject_if_fail' => 'SPF解析為“失敗”(拒絕)時，退信',
    'spf_bhv__reject_if_softfail' => 'SPF解析為“軟失敗”時，退信',
    'spf_bhv__reject_if_neutral' => 'SPF解析為“中性”時，退信',
    'spf_bhv__reject_if_no_pass' => 'SPF沒有解析為“通過”時，退信',
    'sshterm__title' => '安全 Shell 終端',
    'sshterm__password_authentication_warning' => '注意：本地SSH伺服器配置中已禁用密碼驗證。如果無法使用SSH終端連接，請讓管理員在/etc/ssh/sshd_config檔中設定“PasswordAuthentication yes”。',
    'sshterm__password_authentication_warning_admin' => '注意：本地SSH伺服器配置中已禁用密碼驗證。如果無法使用SSH終端連接，請讓管理員在/etc/ssh/sshd_config檔中設定"PasswordAuthentication yes"。',
    'statistics__active_domains' => "活動域名",
    'statistics__clients' => "客戶",
    'statistics__subdomains' => "子域名",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "資料庫",
    'statistics__db_users' => "資料庫使用者",
    'statistics__dirs' => "受保護目錄",
    'statistics__dom_active' => "活動",
    'statistics__dom_passive' => "關閉",
    'statistics__dom_problem' => "問題",
    'statistics__domains' => "域名",
    'statistics__domains_with_host' => "帶有主機服務的域名",
    'statistics__doms' => "域名",
    'statistics__filesystem' => "檔案系統",
    'statistics__general' => "常用",
    'statistics__hdd_available' => "可用",
    'statistics__hdd_capacity' => "使用",
    'statistics__hdd_total' => "共計",
    'statistics__hdd_usage' => "硬碟使用",
    'statistics__hdd_used' => "已使用",
    'statistics__ip' => "IP 地址",
    'statistics__key_number' => "許可證號",
    'statistics__l1' => "過去 1 分鐘",
    'statistics__l15' => "過去 15 分鐘",
    'statistics__l5' => "過去 5 分鐘",
    'statistics__la' => "CPU使用",
    'statistics__mail_autoresponders' => "自動回復",
    'statistics__mail_boxes' => "郵箱",
    'statistics__mail_groups' => "郵件組",
    'statistics__mail_lists' => "郵寄清單",
    'statistics__mail_redirects' => "郵件轉發器",
    'statistics__mem' => "記憶體使用量",
    'statistics__mem_usage' => "使用",
    'statistics__memory_buffer' => "緩衝區",
    'statistics__memory_cached' => "已緩存",
    'statistics__memory_free' => "免費",
    'statistics__memory_shared' => "共用",
    'statistics__memory_total' => "共計",
    'statistics__memory_used' => "已使用",
    'statistics__os' => "作業系統",
    'statistics__problem_clients' => "問題客戶",
    'statistics__problem_domains' => "出故障的域名",
    'statistics__swap' => "交換空間使用情況",
    'statistics__swap_free' => "免費",
    'statistics__swap_total' => "共計",
    'statistics__swap_usage' => "使用",
    'statistics__swap_used' => "已使用",
    'statistics__system_stat' => "伺服器資訊",
    'statistics__unable_define_active_doms' => "無法定義活動域名的數量：%1。",
    'statistics__unable_define_inactive_doms' => "無法定義非活動域名數量：%1。",
    'statistics__up_time' => "系統執行時間",
    'statistics__ver' => "版本",
    'statistics__web_users' => "網站用戶",
    'statistics__mem_win' => "實體記憶體使用量",
    'statistics__memory_total_win' => "共計",
    'statistics__memory_used_win' => "已使用",
    'statistics__memory_free_win' => "可用",
    'statistics__swap_win' => "虛擬記憶體使用量",
    'statistics__swap_total_win' => "共計",
    'statistics__swap_used_win' => "已使用",
    'statistics__swap_free_win' => "可用",
    'status__domain_has_reasons_to_be_off' => "客戶帳戶仍處於掛起狀況，原因如下：%1",
    'subdomain__create__' => "在域名%1中創建子域名",
    'subdomain__edit__' => "管理子域名%1",
    'subdomain__invalid_name' => "無效的子域名：只能使用數位、字母和破折號。",
    'subdomain__incorrect_name' => "無效的子域名。",
    'subdomains__maillists_enabled_in_domain' => "不正確的子域名列表。%1：域名%1上的郵寄清單正使用此域名。",
    'subdomains__dalias_exists' => '相同名稱的域名別名已經存在。',
    'subdomains__name_exists' => "相同名稱的子域名已經存在。",
    'subdomains__regular_domain_exists' => "相同名稱的域名已經存在。",
    'subdomains__domain_alias_exists' => '相同名稱的域名別名已經存在。',
    'subdomains__remove_subdomains_on_domain' => "域名%1的下列子域名將被刪除：",
    'subdomains__select_subdomains_for_remove' => "選擇要刪除的子域名。",
    'subdomains__webmail_enabled_in_domain' => "不正確的子域名 web 郵箱。%1: 此域名用於存取域名%1上的 web 郵箱。",
    'subdomains__dns_record_already_exists' => '因已有DNS記錄對應主機%1，從而無法創建子域名%1。',
    'subdomains__www_prefix_in_domain' => "不正確的子域名www.%1: 域名%1已有WWW首碼。",
    'subdomains__user_type_quota_exceeds' => '無法更改使用者帳戶，因為這將導致超出所分配的磁碟空間。',
    'subdomains__creation_in_dns_slave' => "Plesk 的域名伺服器用作該域名的二級（從屬）域名伺服器。為了正確解析您的子域名，請保證主要的（主） 伺服器包含記錄 %1。",
    'sys_user__attributes_not_changed' => "尚未更改下列系統使用者屬性：%1",
    'sys_user__no_access_without_password' => "您沒有設定密碼。系統使用者將被創建，但擁有密碼之前此使用者將不能登入系統。您要繼續嗎？",
    'sys_user__no_hard_quota' => "不支援",
    'sysuser__zero_quota_is_unlimited' => "0 表示不受限制",
    'template__num_excl_ips' => "向客戶分配獨立的 IP 位址",
    'template__sel_sh_ips' => "選擇共用的IP位址",
    'template__av_sh_ips' => "可用的共用IP地址",
    'template__up_to_excl_ip' => "最多%1個IP地址",
    'templates__all_clients' => "所有客戶",
    'templates__cl_domain_templates' => "%1 的範本",
    'templates__cl_templates' => "客戶範本",
    'time__day' => "日",
    'time__dom_name_ip' => "域名或 IP",
    'time__hours' => "小時",
    'time__invalid_ip' => "無效的 IP 地址或域名。",
    'time__invalid_year' => "年份無效。應該在 1971 到 2036 之間。",
    'time__invalid_month' => "月份值無效，此值應界於1到12之間。",
    'time__invalid_day' => "日期值無效，此值應界於1到31之間。",
    'time__invalid_hours' => "小時值無效，此值應界於0到24之間。",
    'time__invalid_minutes' => "分鐘值無效，該值應界於0到59之間。",
    'time__invalid_seconds' => "秒值無效，此值應界於0到59之間。",
    'time__minutes' => "分鐘",
    'time__month' => "月",
    'time__sec' => "秒",
    'time__syn_sys_time' => "同步系統時間",
    'time__system_datetime' => '日期和時間',
    'time__system_date_update' => '更新系統時間',
    'time__system_date' => "日期(年-月-日)",
    'time__system_time' => "時間(小時:分鐘:秒)",
    'time__system_date_title' => "系統日期和時間",
    'time__timezone_title' => '時區',
    'time__network_time' => '網路時間',
    'time__timezone' => '您的時區',
    'time__daylight' => '自動將時鐘調整為夏令時制',
    'time__please_select_timezone' => '請選擇一個時區',
    '__please_select_country' => '請選擇國家/地區',
    'time__unable_set_time' => "無法設定系統時間：%1",
    'time__year' => "年",
    'tmpl__create' => "創建範本",
    'tmpl__edit__' => '範本 %1',
    'tmpl__logrotation_warn' => "套用範本創建的域名，其日誌迴圈功能僅在物理主機帳戶創建之後方可生效。",
    'tmpl__name' => "範本名稱",
    'tmpl__dom_exist' => "管理員或客戶的範本池中已存在相同名稱的域名範本。",
    'tmpl__name_invalid' => "範本名稱無效或為空。",
    'tmpl__use_next_ip_addr' => "將使用下一個空缺的IP位址",
    'tmpl_name_already_exists' => "名為“%1”的模版已存在。",
    'traffic__no_periods_found' => "無法顯示網站和流量統計。此功能在下一次計算統計資料時才可用。",

    'vh_based__no_free_ip_for_vh' => "基於 IP 的虛擬主機沒有可用的 IP 位址。 請增加 IP 地址。",

    'wu__at_domains_text' => "允許webuser@%1存取格式",
    'wu__unable_create' => "無法創建網站用戶：%1",
    'wu_edit__disk_quota' => "磁片配額",
    'wu_edit__invalid_pass' => "密碼無效。",
    'wu_edit__invalid_quota' => "指定的磁碟空間配額值無效。請輸入一個正整數。",
    'wu_edit__invalid_quota_value' => "指定的硬碟空間配額少於當前使用的數量 (%1MB)。這樣設定可能造成一些功能無法使用。您確定要繼續嗎？",
    'wu_edit__not_create_pass' => "此操作不會為新網站使用者創建密碼。\n如果沒有密碼，使用者將無法登入。",
    'wu_edit__unable_update' => "無法更新網站使用者的屬性：%1。",

    'dns__soa_settings_legend' => 'SOA 設定',
    'dns__default_ttl_legend' => '默認 TTL',
    'dns__soa_param_ttl' => '默認 TTL',
    'dns__soa_param_retry' => '重試間隔',
    'dns__soa_param_refresh' => '刷新間隔',
    'dns__soa_param_expire' => '過期間隔',
    'dns__soa_param_minimum' => '最小 TTL',

    'bt_webdirs' => '虛擬目錄',

    'dns__tabs_general' => '區域設定',
    'dns__tabs_zone_settings' => 'SOA記錄',
    'soa__seconds' => '秒',
    'soa__minutes' => '分鐘',
    'soa__hours' => '小時',
    'soa__days' => '天',

    'DomainSubdirectory' => '子目錄路徑',

    'filemanager__select_codepage' => '選擇內碼表面：',

    'bt_server_app_add' => '添加伺服器應用程式',
    'packages_list' => '伺服器應用程式',

    'bt_packages_management' => '套裝程式管理',
    'pb__packages_management' => '應用程式管理',
    'bt_package_new' => '添加應用程式',
    '__packages' => '伺服器應用程式',

    'dom_ctrl__mysql_dbase_space' => '所有的 MySQL 資料庫配額',
    'dom_ctrl__mssql_dbase_space' => '所有的 MS SQL 資料庫配額',
    'server_preferences__include_mysql_databases' => 'MySQL 資料庫',
    'server_preferences__include_mssql_databases' => 'Microsoft SQL Server 資料庫',

    'check_permissions__domains_selection' => '即將檢查下列域名的檔和資料夾存取權限',

    'dns_add__enter_ixfr_path' => '輸入 IXFR 路徑',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT 記錄已經存在。只能有一個 SPF 記錄。若要添加記錄，請刪除現有的記錄。',

    'component_name__network' => '網路',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => '設定外觀',
    'bt_set_skin' => '設定外觀',
    'firewall__rule_already_exists' => '名為 "%1" 的規則已存在。',
    'pb__firewall' => '防火牆',
    'ruleeditform__incorect_port_value' => '埠數值應該在 1 到 65535 之間。',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => '檔位置無效。',

    'error_doc__erorr_invalid_url_location' =>  'URL 格式錯誤。請輸入網站內的絕對 URL。',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => '防病毒程式',
    'antivirus__antivirus' => '防病毒保護',
    'antivirus__antivirus_direction_off' => '已關閉',
    'antivirus__antivirus_direction_any' => '傳入和傳出的郵件',
    'antivirus__antivirus_direction_from' => '僅傳出的郵件',
    'antivirus__antivirus_direction_to' => '僅傳入的郵件',
    'antivirus__unable_to_update_settings' => '無法更新防病毒設定：%1。',




    '__normal' => '正常',
    '__low' => '低',
    '__high' => '高',

    'mail__antivirus' => "內部郵件伺服器的防病毒程式",
    'mail__use_internal_antivirus' => '使用內部防病毒程式',

    'sa__tabs_general' => '常用',
    'sa__tabs_whitelist' => '白名單',
    'sa__tabs_blacklist' => '黑名單',
    'sa__tabs_trustednetworks' => '可信的網路',
    'sa__alarm_message_text' => '垃圾郵件警報文本',
    'sa__ok_languages' => '可信的語言',
    'sa__language_groups_available' => '可用語言',
    'sa__language_groups_belonged' => '選擇信任的語言',
    'sa__ok_locales' => '可信的區域設定',
    'sa__locale_groups_available' => '可用的區域設定組',
    'sa__locale_groups_belonged' => '選擇信任的區域設定組',

    'sa_trustednetworks' => '可信的網路清單',
    'sa_tn_address' => '網路/遮罩',
    'sa_trustednetworks_desc' => '選擇信任的網路',

    '__mysql_databases' => 'MySQL 資料庫',

    'check_permissions__read_only' => '只檢查模式',
    'check_permissions__notification_email' => '通過電子郵件發送通知',

    'cl_perm__mysql_dbase_space' => '所有的 MySQL 資料庫配額',
    'cl_perm__mssql_dbase_space' => '所有的 MS SQL 資料庫配額',
    'cl_perm__max_mssql_db' => 'Microsoft SQL Server 最大資料庫數量',
    'cl_perm__total_mboxes_quota' => '總郵箱配額',



    'time__date' => '日期',
    'time__time' => '時間',

    'check_permissions_warning' => '這個過程需要一些時間，請耐心等待，不要取消頁面載入。',

    'i_i_cl_on' => '客戶帳戶處於活動狀態。',
    'i_i_cl_off_by_admin' => '伺服器管理員已掛起此客戶帳戶。',

    'check_permissions__email_is_invalid' => '提供的電子電郵地址無效。',

    'sa_invalid_tn_ip' => 'IP 值無效。',
    'sa_invalid_tn_mask' => '遮罩值無效。',
    'sa_exists_tn' => '網路已經存在於清單中。',
    'sa_select_tn' => '尚未選擇要刪除的網路。',
    'sa_conf_list_tn' => '請確認刪除所選的網路。',

    'firewall__tabs_general' => '常用',
    'firewall_tabs_icmp' => 'ICMP 協議',

    'firewallicmpform__title' => 'ICMP 協定防火牆規則',
    'firewallicmpform__icmpsettings_list_legend' => 'ICMP 協定防火牆規則',
    'firewallicmpform__icmpsettingslist' => '規則',
    'icmpsettingslist__enabled' => 'S',
    'icmpsettingslist__type' => '規則名稱',
    'firewall__icmp_type_allowinboundrouterrequest' => '允許入站路由器請求',
    'firewall__icmp_type_allowinboundtimestamprequest' => '允許入站時間戳記請求',
    'firewall__icmp_type_allowinboundmaskrequest' => '允許入站遮罩請求',
    'firewall__icmp_type_allowoutboundsourcequench' => '允許出站源抑制',
    'firewall__icmp_type_allowoutboundparameterproblem' => '允許出站參數問題',
    'firewall__icmp_type_allowredirect' => '允許重定向',
    'firewall__icmp_type_allowinboundechorequest' => '允許入站回應要求',
    'firewall__icmp_type_allowoutboundtimeexceeded' => '允許出站時間超時',
    'firewall__icmp_type_allowoutbounddestinationunreachable' => '允許出站目標不能達到',


    'webdir__select_vdirs_to_remove' => '選擇要刪除的目錄',
    'webdir__select_mime_types_to_remove' => '選擇要刪除的 MIME 類型',

    'defaultcomponents__not_activated' => '尚未啟動',

    'bt_traffic_at_domains' => '流量',

    'firewall__icmpsettingslist' => '規則',
    'icmpsettingslist__name' => '規則名稱',

    '__awstats_perl_warning' => '不安裝 Perl，客戶將不能通過 AWStats 去讀取往年的統計資料。',

    'class_client__mysql_dbase_space' => '值超出客戶限制',
    'class_client__mssql_dbase_space' => '值超出客戶限制',
    'class_client__max_mssql_db' => '值超出客戶限制',

    'firewall__icmp_reset_configuration' => '您確定要將防火牆設定重置為預設狀態？',
    'firewall__icmp_panic_configuration' => '您確定要打開應急模式嗎？一些網路服務可能會因此停止工作。',


    'dns__remove_transfer_restrictions_list_items' => '下列網路將會從存取控制清單中刪除：',
    'dns__select_transfer_restrictions_list_items_to_remove' => '請選擇要從存取控制清單中刪除的網路',

    'firewall__select_rule_to_remove' => '選擇要刪除的規則',

    'bt_up' => "向上",
    'bt_down' => "向下",
    'virtualdir__type_default_doc_name_to_add' => '輸入要添加到列表的檔案名',
    'virtualdir__select_default_doc_to_remove' => '刪除要從列表中刪除的檔',

    'bt_install_selected' => '安裝所選許可證', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => '該域名解析為其它的 IP 地址：(%1)。請更正 DNS 設定。',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => '當前所用的郵件伺服器不支援同時啟用郵箱和郵件組。按“確定”可在啟用郵箱的同時禁用郵件組。按“取消”則保留原設定不變。',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => '當前使用的郵件伺服器不支援同時啟用郵箱和郵件組。按“確定”可在啟用郵件組的同時禁用郵箱。按“取消”則保留原設定不變。',

    'mysql_dbase_space_limit' => 'MySQL 資料庫空間限制',
    'mysql_dbase_usage' => 'MySQL 資料庫空間使用率',
    'mssql_dbase_space_limit' => 'Microsoft SQL Server 資料庫空間限制',
    'mssql_dbase_usage' => 'Microsoft SQL Server 資料庫空間使用率',

    '__statistics' => "統計資料", //indirect

    'dns__soa_minimum_value_is_big' => '設定大於3小時的最小TTL值會使某些域名管理員無法存取您的域名。建議僅當您的域名註冊商要求這樣設定時，才設定這樣的值。',

    'maillists__server_legend' => 'Mailman 設定',
    'maillists__secure_links_text' => '在郵寄清單中使用安全連結',
    'maillists__secure_links_hint' => '啟用或禁用郵寄清單中的安全 (HTTPS) 連結生成。',

    'virusfilter__interface_not_available' => '尚無可用病毒篩檢程式。',
    'virusfilter__none_virus_filter' => '無',
    'virusfilter__server_legend' => '防病毒設定',
    'virusfilter__server_text' => '使用的反病毒軟體',
    'virusfilter__mailname_status_text' => '防病毒程式 (%1)',
    'virusfilter__status_none' => '禁用',
    'virusfilter__status_any' => '傳入和傳出郵件',
    'virusfilter__status_outgoing' => '僅限傳出郵件',
    'virusfilter__status_incoming' => '僅限傳入郵件',

    'visibility__adminonly' => '僅管理員',
    'visibility__button_sets' => '控制項',
    'visibility__control' => '按一下自訂此控制項。',
    'visibility__customization_footnote' => '按一下“確定”完成螢幕自訂。',
    'visibility__default' => '默認',
    'visibility__export_note' => "將要匯出您所做的自訂設定。現在將會下載 shell 腳本到您的電腦。要在其它的 Plesk 伺服器上應用這些設定，覆蓋任何現有的介面管理設定，請上傳並執行該腳本。\n請注意如果您在此螢幕上做了任何修改而還未點按確定，匯出的資料將不會包括您最新所做的修改。",
    'visibility__hide' => '隱藏',
    'visibility__reset_all' => '全部重置為預設值',
    'visibility__reset_screen' => '恢復此螢幕的原始佈局',
    'visibility__root_override_parse_error' => '檔%1的第%2行有語法錯誤。',
    'visibility__screen_title' => '介面管理',
    'visibility__set_billing_enabled' => '斷開連接 Customer and Business Manager',
    'visibility__set_cert_puchasing' => '隱藏用於購買證書的按鈕',
    'visibility__set_domain_registration' => '隱藏域名註冊的按鈕',
    'visibility__set_extras' => '隱藏用於其它服務的按鈕',
    'visibility__set_mail_bounce' => '隱藏電郵地址不存在的退信控制項',
    'visibility__show' => '顯示',
    'visibility__show_toolbar' => '顯示介面管理工具列',
    'visibility__standby_footnote' => '按一下自訂當前螢幕的控制項。',
    'visibility__standby_footnote_nocontrols' => '此螢幕上沒有自訂控制項。',

    'bt_mpc' => "MyPlesk.com",
    'sb__not_support_publishing_api' => "組件不支援自動發佈",

    'component_name__cphosting' => "Plesk 主機",

    'dom_pref__unable_set_up_total_mboxes_quota' => '當前郵件伺服器不支援設定郵箱配額。',
    '__unable_get_total_mboxes_quota' => '當前郵件伺服器不支援設定郵箱配額。',

    'install_prefix__parent_not_exists' => "父目錄不存在。",

    'bt_change_version' => '更改版本',
    'aspdotnet__changeversion_title' => '選擇 ASP.NET 版本',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "全選",
    '__uncheck_all' => "清空全部",

    'dns__editing_domain_controller_zone' => "編輯域名控制器的 DNS 區域記錄可能會導致域名功能上出現問題",

    'pb__interface_management' => "介面管理",
    'interface_management__tabs_skins' => "皮膚",
    'interface_management__tabs_interface_templates' => "介面範本",
    'interface_management__tabs_locales' => "區域設定",
    'locales_list__title' => "語言包的庫",
    'locales_list__legend' => "可用語言",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "語言包",
    'locales_list__lang_title' => "語言",
    'locales_list__country_title' => "國家",
    'locales_list__used_title' => "已使用",

    'backup__suspend_warning_during_backup' => "備份過程中，此域名不可用",
    'backup__suspend_warning_during_restore' => "恢復過程中，此域名不可用",
    'backup__suspend_domain' => "掛起域名",

    'locales_list__mls_limit' => "您當前的 Plesk 許可證允許使用 %2 種語言。目前，您已設定用戶可使用 %1 種語言，這超過了許可證允許的數量。請選擇您想要使用的 %2 種語言，且通過點按 'S' 欄中的相應圖示來設定使用者不可使用剩下的語言。",

    'bt_change_owner' => '分配新所有者',
    'chown__new_owner' => '新的所有者',
    'chown__selected_domains' => '所選訂閱',
    'chown__limits_legend' => '資源',
    'chown__limit_name' => '資源名稱',
    'chown__limit_value' => '已分配資源',
    'chown__limit_assigned_before' => '移交前',
    'chown__limit_assigned_after' => '移交後',
    'chown__error_limits' => "無法繼續移交訂閱：該訂閱所需的資源量超過了新所有者的提供商所能提供的資源量。",
    'chown__error_no_domains' => '無法繼續移交訂閱：未選擇訂閱，或選擇的訂閱已屬於目標客戶。',
    'chown__error_empty_ip_pool' => "無法繼續移交訂閱：新所有者的提供商的 IP 池為空。請確保提供商的 IP 池中至少有一個 IP 位址。",
    'chown__please_select_new_domain_owner' => '請為此域名選擇新的所有者。',
    'chown__old_ip_address' => '當前IP地址',
    'chown__new_ip_address' => '新的IP位址',

    'chown__error_ssl_already_used' => "SSL/TLS 支援已用於以下目的 IP：%1 因此，無法遷移下列帶有 SSL/TLS 支援的域名：%2。請解決該問題再重試",
    'chown__sitebuilder_not_installed' => '未安裝 Presence Builder',
    'chown__domain_exclude_sitebuilder_not_installed' => '未安裝 Presence Builder，無法移交域名 %1 給另一所有者。',

    'backup__backup_time' => '備份時間',
    'backup__backup_time_hour' => '小時',
    'backup__backup_time_minute' => '分鐘',
    'backup__every' => '每',
    'backup__day_of_month' => '日期',

    'subdomain__select_hst_type' => '選擇子域名的主機類型',
    'hst_sel__subdom_subfolder_hst' => '子資料夾中的子域名',
    'subdomain__www_root_folder_not_exists' => '網站主目錄%1不存在',
    '__site_home_dir' => '網站主目錄',
    'subdomain__aspnet_disabled_domain' => '按域名禁用',

    'domains__remove_description' => '所有域名資料（包括域名及其對應的子域名內容與設定、web 應用程式資料、郵箱內容、郵件、防毒程式和垃圾郵件過濾設定、日誌檔、域名備份 repository 資料和 SSL/TLS 證書）都將被刪除。如果您未在本機上備份，所有的資料將會永久丟失。',
    'subdomains__remove_description' => '所有子域名資料(包括子域名內容和設定、web應用程式和記錄檔)將被刪除。如果您未在本機上備份這些檔，所有的資料將會永久丟失。',

    'mail__no_relay_networks' => '對下面的網路使用無中繼限制：',
    'mail__tabs_spam_filtering' => '垃圾郵件過濾',
    'mail__tabs_antivirus' => '防病毒程式',
    'server_mail__usage_policy_legend' => '使用策略',
    'server_mail__for_incoming_mail' => '用於傳入郵件',
    'server_mail__for_outgoing_mail' => '用於傳出郵件',
    'server_mail__antivirus_direction_off' => '掃描功能已禁用',
    'server_mail__antivirus_direction_any' => '掃描傳入郵件和傳出郵件',
    'server_mail__antivirus_direction_from' => '僅掃描傳出郵件',
    'server_mail__antivirus_direction_to' => '僅掃描傳入郵件',
    'antivirus__use_server_settings_scan' => '使用默認伺服器級的設定(掃描)',
    'antivirus__use_server_settings_no_scan' => '使用默認的伺服器級的設定(請不要掃描)',
    'antivirus__check_for_viruses' => '掃描病毒',
    'antivirus__dont_check_for_viruses' => '請不要掃描病毒',
    'antivirus__incoming_mail' => '傳入郵件',
    'antivirus__outgoing_mail' => '傳出的郵件',

    'domain_alias__CNAME_dns_record_exists' => '相同名稱的 DNS CNAME 記錄已經存在',
    'domain_alias__A_dns_record_exists' => '相同名稱的 DNS 記錄已經存在',
    'domain_alias__bad_prefix' => '域名別名的首碼錯誤',
    'domain_alias__domain_doesnt_exist' => "域名不存在",

    'dns__zone_ttl_message_info' => '若未指定 TTL 值，SOA 記錄範本 (%1) 中的 TTL 值將用於此 DNS 記錄。',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWstats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "創建名稱為index.html的文件，用於跳轉到所選的web應用程式。如果名稱為index.html的檔已存在，它將被備份為index.html.old，並被新文件取代。請按“確認”來確認。",

    'bt_ftp_ctrl' => "其他FTP帳戶",
    'ftp_users_no_permission' => "您尚無管理此域名FTP子帳戶的許可權",
    'ftp_users_limit_reached' => "已達到此域名的FTP子帳戶限制",
    'pb__ftp_ctrl' => "FTP管理",
    'class_client__max_subftp_users' => "其它 FTP 帳戶",

    '__client_form_settings' => "客戶設定",
    '__sbnet_client_keep_sbnet' => "在 Presence Builder 中保留相應使用者帳戶",
    '__sbnet_cant_add_more_sites' => "此客戶可以使用的 Presence Builder 網站已達到數量限制",
    '__sbnet_legend_text' => "Presence Builder 整合",
    '__sbnet_synchronize_user_with_sbnet' => "在 Presence Builder 中創建相應的用戶帳戶",
    '__sbnet_client_warning_delete_sb_user' => "您正嘗試刪除與此客戶相關的 Presence Builder 使用者。這項操作將會刪除所有的 Presence Builder 使用者設定和資料，並禁止通過 Presence Builder 編輯現有網站(即使您稍後啟用此選項)。如果稍後再創建 Presence Builder 使用者，您將需要重新創建和發佈所有網站。您確定要禁止通過 Presence Builder 創建和發佈網站嗎？",
    'sb__build_site_with_subdomains' => "創建博客和照片圖庫子域名",
    '__sbnet_client_dont_have_sbuser' => "無法使用創建和發佈網站 Presence Builder:Presence Builder 用戶不存在",

    '__component_disabled' => "禁用組件",

    'dns_t__remove_transfer_restrictions_list_items' => "下列網路將從 DNS 區域範本的存取控制清單中移除：",

    'subdomains__physical_path_not_exist' => "子域名連結到不存在的物理資料夾",
    'dns__recursion_settings_legend' => "DNS遞迴設定",
    'dns__recursion_on' => "允許所有請求",
    'dns__recursion_local' => "僅允許本地請求",
    'dns__recursion_off' => "拒絕",

    'dnsserver_bind_to_msdns_switching_warning' => "警告：僅限於傳輸“存取控制清單”上遮罩為/8和/16的254個子網IP位址(從開始計算)。它們將會被作為單個IP位址進行傳輸。您想要繼續嗎？",

    '__sbnet_net_framework_required_for_site' => "Presence Builder 網站可能需要在您的域名上啟用 ASP.NET 2.0 支援。如果您正使用 Presence Builder 我們建議啟用 ASP.NET 2.0 支援。",

    'subdomain_auto_create_dir' => "為子域名創建物理目錄",

    'sa_trainer__unable_to_get_messages_list' => "無法在郵箱中取得郵寄清單：%1",
    'sa_trainer__pass_doesnt_exist' => "此郵件帳戶的密碼丟失",

    '__sitebuilder_error' => "嘗試連接 Presence Builder 時出錯。請聯繫 Panel 服務商尋求協助。",
    'wsb_error_user_not_exist' => "Presence Builder 用戶不存在。",
    'wsb_error_site_already_exist' => "網站已在 Presence Builder 中。",
    'wsb_error_site_limit_reached' => "達到 Presence Builder 網站數限制。",
    'wsb_error_internal_error' => "發生 Presence Builder 內部錯誤。請聯繫管理員。",
    'wsb_error_user_already_exist' => "Presence Builder 中已存在帶有相同名稱的 Presence Builder 用戶。",
    'sb_error_user_not_exist' => "Presence Builder 用戶不存在。",
    'wsb_error_object_not_found' => "Presence Builder 無法找到正確的主機項。",

    'mg_no_mail_groups' => "無郵件組",

    'drweb__drweb_incoming' => '對傳入的郵件進行防病毒檢查',
    'drweb__drweb_outgoing' => '對傳出的郵件進行防病毒檢查',
    'drweb__disable_reason_serv' => '郵件伺服器不支援郵箱級別的防病毒篩檢程式設定',

    'vz_sitebuilder3_client_cant_be_created' => "無法創建客戶帳戶: 未安裝SiteBuilder 3.1或更高版本",

    'chown__client_without_sitebuilder_support' => "無法繼續移交訂閱：新所有者或其提供商的服務方案不支援 Presence Builder 服務。",

    // new limits

    'class_client__max_odbc' => "ODBC 連接",
    'cl_perm__max_odbc' => "ODBC連接的最大數量",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => '域名別名',
    'domain_alias__list_ascii_name' => '使用ASCII形式',
    'dns_template__tabs_general' => "區域設定範本",
    'dns_template__tabs_zone_settings' => "SOA記錄範本",
    'dns_template__tabs_acl' => "傳輸限制範本",
    'dns_template__tabs_recursion' => "DNS遞迴",
    'dns_template__tabs_records_template' => "區域記錄範本",


    // Interface Customization Templates
    'interface_preferences' => '介面管理',
    'pb__interface_templates' => '介面管理',
    'pb__interface_clients' => '使用%1的客戶',

    // service management
    'bt_service_showall' => "顯示全部",
    'bt_service_hideall' => "隱藏全部",
    'bt_service_start' => "啟動",
    'bt_service_stop' => "停止",
    'bt_service_restart' => "重新啟動",
    'bt_service_disable' => "關閉",
    'bt_service_manual' => "手動",
    'bt_service_auto' => "自動",
    'comp_info__statup_type' => '啟動類型',
    'service_startup_auto' => '自動',
    'service_startup_manual' => '手動',
    'service_startup_disabled' => '已禁用',
    'service_action_ok' => "%1服務操作成功完成",
    'service_action_failed_disabled_service' => "無法完成%1服務操作，因它已禁用",
    'service_action_failed_error' => "無法完成操作：%1",
    'service_group_action_ok' => "下列服務操作已成功完成：%1",
    'service_group_action_disabled' => "無法完成下列服務操作，因它們已禁用：\n%1",
    'service_group_action_failed' => "無法完成下列服務操作：%1。要接收關於錯誤的詳細資訊，請分別執行每個服務操作",

    // php 4vs5
    'bt_php' => "PHP 設定",

    // Mass mail

    'massmail__resellers_list_available_for_select' => '可用代理商',
    'massmail__resellers_list_selected' => '所選代理商',
    'massmail__clients_list_available_for_select' => '可用客戶',
    'massmail__clients_list_selected' => '所選客戶',
    'massmail__advanced' => '高級',
    'bt_massmail_send' => '發送',
    'massmail__save_template_name' => '將文本保存至新命名的範本',
    'massmail__template' => '範本',
    'massmail__compose_mail' => '信息',
    'massmail__from' => '來自',
    'massmail__to' => '至',
    'massmail__subject' => '主題',
    'massmail__body' => '資訊文本',
    'massmail__body_hint' => '使用<name>變數向您的郵件自動插入連絡人姓名資訊。',
    'massmail__send_to_clients' => "客戶",
    'massmail__send_to_domainusers' => "域名管理員",
    'massmail__send_to_admins' => "Plesk 管理員",
    'massmail_select' => '選擇位址',
    'massmail_showhide_selected' => "顯示/隱藏所選項",
    'massmail_send_all' => "所有",
    'massmail_send_selected' => "僅所選項",
    'massmail_send_except' => "除所選外的全部項",
    'bt_new_mass_mail_template' => "添加群發郵件範本",
    '__mass_mail_templates_list' => "群發電子郵件範本清單",
    'massmail__template_name' => '範本名稱',
    'massmail__receivers' => '收件人',
    'massmail__created' => '寄件者',
    'massmail__date_created' => '創建日',
    'massmail__compose' => '發送',
    'mass_mail__resellers_all' => '所有代理商',
    'mass_mail__clients_all' => '所有客戶',
    'mass_mail__domainusers_all' => '所有域名管理員',
    'mass_mail__resellers_selected' => '所選代理商',
    'mass_mail__clients_selected' => '所選客戶',
    'mass_mail__domainusers_selected' => '所選域名管理員',
    'mass_mail__resellers_except' => '排除所選之外的其他代理商',
    'mass_mail__clients_except' => '除選中之外的所有客戶',
    'mass_mail__domainusers_except' => '除所選的之外的所有域名管理員',
    'mass_mail__admins_all' => '所有管理員',
    'massmailtemplateslist__title' => '群發郵件範本',
    'massmail__insert_from_template' => "從範本插入資料",
    'massmail__select_template' => "所選範本",
    'massmail__body_short_hint' => "(僅純文字)",
    'massmail__from_short_hint' => "(電子郵件或名稱)",
    'bt_insert' => "插入",
    'massmail__mail_send_successfully' => "郵件發送成功",
    'massmail__mail_send_successfully_with_some_errors' => "郵件已發出，但出現數個錯誤。一些收件人可能沒有收到郵件。如需更多資訊，請參見下面的日誌檔：%plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "資訊未被發出。請確定至少選定了一個收件人且 Plesk 的郵件伺服器運行正常。欲瞭解更多資訊，請查看以下日誌檔：%plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "範本%1的資料已成功插入。",
    'massmail__template_added_successfully' => "群發電子郵件消息資料已保存在名為%1的範本中。",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder 資料庫錯誤。請聯繫服務商尋求協助。",
    'wsb_error_sitebuilder_access_denied_error' => "無法存取檔: Presence Builder 不具有存取所請求檔或資料夾的許可權。請聯繫服務商尋求協助。",
    'wsb_error_sitebuilder_connection_failed' => "無法連接 Presence Builder: 連接丟失。請聯繫服務商尋求協助。",
    'wsb_error_critical_during_operation' => "Presence Builder 嚴重錯誤:\n%1",
    'wsb_error_license_during_operation' => "出現的 Presence Builder 許可證錯誤：\n%1",
    'wsb_error_during_operation' => "出現的 Presence Builder 錯誤：\n%1",
    'wsb_error_license_error' => "遇到 Presence Builder 許可證限制",

    // Other
    '__confrim_service_stop' => "警告！如果您停止服務 %1，Plesk 可能也會停止工作。您確定要停止服務 %1 嗎？",
    'virtualdir__name_is_reserved' => "該名稱已保留",
    'index_redirect_help_text' => '現在您將被自動重定向到所需網站。如果您的瀏覽器不支援重定向，請按一下%1此處%2',
    'bt_default_settings' => "恢復默認",
    'logfiles__remove_failed' => "無法刪除檔%1：檔被另一個應用程式鎖定。請稍候重試",
    'subdomain__invalid_homedirectory' => "指定的子域名主目錄無效",
    'scheduler_item__empty_filename' => "請指定可執行檔以運行",
    'subdomains__overlapped_domain_exists' => '子域名與域名 %1 的 DNS 區域重疊',
    'subdomains__overlapped_domain_alias_exists' => '子域名與域名別名 %1 的 DNS 區域重疊',
    'services_action_none_selected' => '無法完成操作：請選擇所需服務',
    'cl_perm__max_subftp_users' => "FTP子帳戶的最大數量",
    'login_up__access_denied_no_cp_access' => '存取被拒絕。您無權存取 Plesk。',
    'drweb__disable_reason_admin' => "伺服器策略不允許郵箱級反病毒篩檢程式設定。",

    'webdirs__name_is_invalid' => '僅可在目錄名中使用字母數位、底線和破折號字元。',
    'webdirs__physical_path_is_invalid' => '物理路徑無效或不存在',
    '__use_default' => '使用默認',
    'branding_pagetitle' => '產品設定',
    'fieldset_titlebar_setup' => "Plesk 頁面的標題",
    'use_custom_titlebar' => "標題文本",
    'odbc__dsn_list_legend' => 'ODBC DSN 連接',

    'webalizer_preferences__title' => '網站統計設定',
    'webalizer_preferences__tab_hidden_referrers' => '隱藏引用',
    'webalizer_preferences__tab_group_referrers' => '組引用',

    'webalizer_hidden_referrer__edit_title' => '隱藏項屬性',
    'webalizer_hidden_referrer__edit_legend' => '隱藏項',
    'webalizer_hidden_referrer__referrer_type' => '項類型',
    'webalizer_hidden_referrer__referrer' => '引用',
    'webalizer_hidden_referrer__list_header' => '隱藏引用',
    'webalizer_hidden_referrer__list_legend' => '隱藏引用',
    'webalizer_hidden_referrer__referrer_direct_request' => '直接請求',
    'webalizer_hidden_referrer__referrer_custom_referrer' => '引用',
    'webalizer_hidden_referrer__remove_empty_selection' => '未選擇項目',
    'webalizer_hidden_referrer__remove_title' => '下列引用將不再被隱藏：',
    'webalizer_hidden_referrer__already_exist' => '該項目已存在。',

    'webalizer_group_referrer__list_header' => '組引用',
    'webalizer_group_referrer__list_legend' => '組引用',
    'webalizer_group_referrer__edit_title' => '引用組屬性',
    'webalizer_group_referrer__edit_legend' => '引用組屬性',
    'webalizer_group_referrer__group' => '組',
    'webalizer_group_referrer__referrer' => '引用',
    'webalizer_group_referrer__already_exist' => '相同名稱的群組推薦人已經存在。',
    'webalizer_group_referrer__remove_empty_selection' => '尚未選擇引用組',
    'webalizer_group_referrer__remove_title' => '下列引用網站將被取消分組：',

    'pb__dashboard' => '首頁',

    'server_interface__page_title' => '伺服器介面設定',
    'server_interface__tabs_locales' => '區域設定',
    'server_interface__tabs_skins' => '皮膚',
    'server_interface__tabs_interface_templates' => '介面範本',
    'bt_server_interface' => '介面偏好設定',
    'pb__server_interface' => '介面偏好設定',

    'bt_wizard_next' => '下一個 >>',
    'bt_wizard_prev' => '<< 返回',

    '__limit_exceeded_max_dom_server' => '無法在此伺服器上託管更多域名，因為已達到許可證對該台伺服器域名數量的限制。請聯繫您的服務提供者解決此問題。',
    '__limit_exceeded_max_subdom_server' => '您無法在此伺服器上託管更多的子域名。請聯繫您的服商。',
    '__limit_exceeded_max_dom_aliases_server' => '您無法在此伺服器上設定更多的域名別名。請聯繫您的服務商。',
    '__limit_exceeded_max_wu_server' => '因達到許可證允許的伺服器上網站用戶的數量限制，無法創建更多的網站用戶。請聯繫服務商解決此問題。',
    '__limit_exceeded_max_mn_server' => '因達到許可證允許的伺服器上郵件帳戶的數量限制，無法創建更多的郵件帳戶。請聯繫服務商解決此問題。',

    '__limit_exceeded_max_cl_useradmin' => '已達到許可證所定義的客戶帳戶數量限制(%2)',
    '__limit_exceeded_max_dom_useradmin' => '已達到許可證所定義的域名數量限制(%2)',
    '__limit_exceeded_max_subdom_useradmin' => '已達到許可證定義的子域名數量限制(%2)。',
    '__limit_exceeded_max_dom_aliases_useradmin' => '已達到許可證定義的域名別名數量限制(%2)',
    '__limit_exceeded_disk_space_useradmin' => '磁碟空間已滿',
    '__limit_exceeded_max_wu_useradmin' => '已達到許可證所定義的網站使用者帳戶數量限制(%2)',
    '__limit_exceeded_max_db_useradmin' => '已達到許可證所定義的資料庫數量限制(%2)',
    '__limit_exceeded_max_box_useradmin' => '已達到許可證所定義的郵箱數量限制(%2)',
    '__limit_exceeded_max_mn_useradmin' => '已達到許可證所定義的電子郵件帳戶數量限制(%2)',
    '__limit_exceeded_max_maillists_useradmin' => '已達到許可證所定義的郵寄清單數量限制(%2)',

    '__limit_exceeded_max_dom_userclient' => '已達到域名數量限制(%2)。',
    '__limit_exceeded_max_subdom_userclient' => '您已達到服務提供者允許的子域名數量限制(%2)',
    '__limit_exceeded_max_dom_aliases_userclient' => '已達到域名別名數量限制(%2)',
    '__limit_exceeded_disk_space_userclient' => '已達到磁碟空間使用限制(%2)',
    '__limit_exceeded_max_traffic_userclient' => '已達到每月使用的頻寬量限制(%2)',
    '__limit_exceeded_max_wu_userclient' => '已達到服務提供者允許的網站用戶數量限制(%2)。',
    '__limit_exceeded_max_db_userclient' => '已達到資料庫數量限制(%2)',
    '__limit_exceeded_max_box_userclient' => '已達到郵箱數量限制(%2)',
    '__limit_exceeded_max_maillists_userclient' => '已達到郵寄清單數量限制(%2)。',
    '__limit_exceeded_expiration_userclient' => '您的帳戶終止期為%2。',

    '__limit_exceeded_max_subdom_userdomain' => '您已達到服務提供者允許的子域名數量限制(%2)',
    '__limit_exceeded_max_dom_aliases_userdomain' => '已達到域名別名數量限制(%2)',
    '__limit_exceeded_disk_space_userdomain' => '已達到磁碟空間使用限制(%2)',
    '__limit_exceeded_max_traffic_userdomain' => '已達到每月使用的頻寬量限制(%2)',
    '__limit_exceeded_max_wu_userdomain' => '已達到網站使用者帳戶的數量限制(%2)',
    '__limit_exceeded_max_db_userdomain' => '已達到資料庫數量限制(%2)',
    '__limit_exceeded_max_box_userdomain' => '已達到郵箱數量限制(%2)',
    '__limit_exceeded_max_maillists_userdomain' => '已達到郵寄清單數量限制(%2)。',
    '__limit_exceeded_expiration_userdomain' => '您的帳戶終止期為%2。',

    'mmt__to_none' => '無',
    'mmt__to_admin' => '管理員',
    'mmt__to_resellers_all' => '所有代理商',
    'mmt__to_resellers_select' => '所選代理商',
    'mmt__to_resellers_select__available' => '可用代理商',
    'mmt__to_resellers_except' => '排除所選之外的其他代理商',
    'mmt__to_clients_all' => '所有客戶',
    'mmt__to_clients_select' => '所選客戶',
    'mmt__to_clients_select__available' => '可用客戶',
    'mmt__to_clients_except' => '除選中之外的所有客戶',

    'mmt__unable_send_empty_selection' => '無法群發郵件，尚未選擇電子電郵地址。',
    'mmt__unable_send_to__' => '無法群發郵件至：',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => '因未找到所需文件(%1)，導致無法驗證web應用程式。請聯繫技術支援代表尋求協助。',
    'sapp_error_validation_spec_failed' => '上傳的web應用程式不符合應用套裝程式規範: %1。',
    'sapp_error_validation_register' => '無法註冊目錄"%1"中的web應用程式: %2請從伺服器上刪除web應用程式，它才可以正常運行。',

    'sapp__install_failed' => 'Web應用程式安裝失敗: %1',
    'sapp__install_res_failed' => '創建請求的資源失敗。',

    'server_preferences__subdomains_blog_and_photo' => '預設創建博客和圖片庫子域名',
    'firewall__info' => '出於安全原因，防火牆阻止了除明確允許的之外所有連接。您可以通過創建某個規則來允許某個連接。更多資訊，請參閱相關文檔。',
    'plesk_key__blog_and_photo' => '允許管理“創建博客”和“圖片庫”子域名核取方塊的預設狀態',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => '如果 IP 被分配給一個以上的客戶，則無法將其設定為獨立型',

    // 8.1.1


    'database_server_list__mssql_server_port_undefined' => "無法確定 Microsoft SQL server \\&apos;%1\\&apos; 使用的 TCP 埠號。TCP/IP 協定未在伺服器網路配置中啟用或伺服器被配置使用動態 TCP 埠。\n 要允許您的客戶自動為遠端資料庫存取配置防火牆，則需手動配置 SQL 伺服器監聽一個指定的固定的 TCP 埠。",
    '__local_server_mssql' => '本地MSSQL伺服器',
    'pb__db_server_databases' => '資料庫伺服器管理',

    '__write_modify_warning' => '選擇其他寫入/修改許可權將使得一些 web 應用程式正常運行，但是也會大大增加安全風險',
    '__write_modify_subdomain_warning' => '選擇其他寫入/修改許可權將使得一些 web 應用程式正常運行，但是也會大大增加安全風險',

    'phosting__php_incorrect_version_used' => "發現 PHP 版本問題。若要解決這些問題，請選中下面所需PHP版本對應的核取方塊並按一下“確定”。若要禁用該域名的PHP，無需選擇PHP版本直接按一下“確定”即可。",
    'fp__mail_preferences' => '郵件設定',

    'mail__specify_patterns' => '電郵地址',
    'mail__blocker_action_text' => '對符合標準的郵件執行的操作：',
    'mail__action_delete' => '從伺服器刪除',
    'mail__action_spam' => '標識為垃圾郵件',
    'mail__action_with_mails' => '操作',
    'mail__white_list_action_text' => '符合標準的郵件不會被標識為垃圾郵件',
    'mail__invalid_white_pattern' => '所指定的值無效。請使用下列格式：mail@example.com 用於電郵地址，example.com 用於域名，或 123.123.123.123/32 用於 IP 地址。',
    'mail__invalid_black_pattern' => '指定的值無效。請使用下列格式: mail@example.com 用於電郵地址，example.com 用於域名。',
    'mail__black_list_no_sa_warning' => '因未安裝Spamassassin或已關閉，則系統不會將這些條目標示為垃圾郵件',

    'resp_edit__reply_as_html' => '以 HTML 發送',
    'exception__path_very_long' => "路徑過長。請確定路徑長度不超過%1個字元。",

    // 8.2


    //SAPP
    'sapp_on' => '啟用',
    'sapp_off' => '停用',
    'sapp_directive_aspect' => '需要',
    'sapp_databases_num' => '資料庫',
    'sapp_db_required' => '需要',
    'sapp_Required' => '需要',
    'sapp_Variant' => '變數',
    'sapp_db_id' => '資料庫ID',
    'sapp_db_id_type' => 'DB (id: %1)類型',
    'sapp_db_id_min_version' => 'DB (id: %1)最低版本',
    'sapp_db_id_table_prefix' => 'DB (id: %1)表首碼',
    'sapp_Default' => '預設值',
    'sapp_apache_mod_req' => 'Apache模組',
    'sapp_dbtype_not_installed' => '未安裝',
    'sapp_apache_mod_not_installed' => '未安裝',
    'sapp__value_error_empty' => '不允許空值。',
    'sapp_error_invalid_type' => '應用程式“%1”不支援所請求的操作。',
    'sapp_error_unknown_app_type' => '不受支援的應用程式類型：%1。',
    'sapp__ssl_text' => '將應用程式安裝到“http://”或“https://”虛擬主機？',
    'sapp__app_to_upgrade' => '待升級的應用程式',
    'sapp__upgrade_apps_title' => '升級應用程式',
    'sapp__upgrade_to_ver' => '升級到',
    'sapp__choose_pkg_ver' => '選擇套裝程式...',
    'sapp__pkg_cant_upgrade_pkg' => '套裝程式"%1" 無法用於升級web應用程式"%2"。',
    'sapp__app_ugrade_error' => '無法升級應用程式：%1。請聯繫系統管理員。',
    'sapp__no_suitable_db_found' => '未找到合適的資料庫。',
    'sapp__upgrade_success' =>  '應用程式已成功升級。',
    'sapp__pkg_info_changelog' => '變更歷史記錄',
    'sapp_requirement_legend' => '此應用程式需要主機功能',

    // other
    'odbc__mssql_wsid' => '工作站ID',
    'odbc__mssql_driver' => '驅動程式',
    'bt_apply' => '應用',
    'tsclient_disabled' => '許可權不足，無法通過遠端桌面存取系統',
    'mn_edit__add_alias_if_mailbox_disabled' => '若要創建郵件別名，此郵件帳戶的郵箱應處於啟用狀態。是否啟用郵箱？',
    'mn_edit__mailbox_disable_if_has_alias' => '禁用郵箱將會刪除所有的郵件別名，因它們將停止工作。是否禁用郵箱？',
    'odbc__mysql_driver' => 'MySQL ODBC驅動程式',
    'antivirus__disable_reason_install' => '因尚未安裝，導致無法管理防毒軟體。',
    'antivirus__disable_reason_key' => '因由不正確的許可證啟動，導致無法管理防病毒功能。',
    'antivirus__disable_reason_deny_personal_settings' => '因伺服器策略禁止單獨進行防病毒設定，導致無法管理防病毒功能。',
    'component_name__sqladminmssql' => 'Microsoft SQL Webadmin',
    'change_foreign_user_password' => '更改密碼',
    'change_foreign_user_password_hint' => "此使用者不屬於該應用程式。按一下此連結轉到另一應用程式，並在該處更改使用者密碼。若要執行此操作，您必須在此應用程式中具備相應許可權。",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => '字串格式',
    'lang_unknown' => '未知語言',
    'odbc__access_driver' => '驅動程式',
    'odbc__access_pwd' => '密碼',
    'odbc__access_uid' => '登入 ID',
    'odbc__excel_driver' => '驅動程式',
    'pb__cl_ed' => '客戶詳情',
    'pb__actionlog' => '操作日誌',
    'pb__cl_limits' => '客戶限制',
    'pb__edit' => '編輯',
    'pb__subdom_edit' => '主機設定',
    'cf__select_dsn_to_remove' => '選擇至少一個待刪除的DNS',

    // NEW 8.3 FEATURES

    'firewall__port_range_warn_limit' => '處理此埠範圍規則可能會持續一段時間。\\n是否繼續？',
    'firewall__port_range_exceeds_limit' => '指定的埠範圍超過可用的埠範圍值%1',

    'backup_mail_content' => '備份郵箱內容',

    'maillist_import_result' => "文件中的總電郵地址數：%1\n所導入的電郵地址數：%2\n已存在的電郵地址數：%3\n指定檔中重複的電郵地址數：%4\n檔中無效的電郵地址數：%5",
    'maillist_import_error' => '無法匯出電郵地址列表',

    //  spaw

    'spaw__unable_to_edit_no_body' => "您已選定的檔要麼為空要麼是選定編碼無效的 HTML 檔。請選擇正確的編碼或簡單地添加內容到檔。",

    'dom_pref__external_mail_srv' => "重定向到該 IP 位址的外部郵件伺服器：",
    'mn_edit__store_messages' => '郵箱',

    // aps

    'sapp__before_upgrade_notice' => '建議您在啟動升級進程之前備份應用程式和使用者資料。',
    'sapp__application_properties' => '應用程式屬性',
    'sapp__application_root_descr' => '應用程式主首頁',

    'sapp__aps_license_invalid_id' => '許可證ID有效：%1。',
    'sapp__aps_lic_key_alredy_exists' => '資料庫中已有許可證號為%1的許可證。',
    'sapp__aps_lic_del_used' => '無法刪除此許可證，所安裝的某個應用程式正在使用此許可證。',
    'sapp__aps_lic_del_unknown' => '無法刪除許可證：%1',
    'sapp__aps_cappi_duplicate' => "此應用程式已在該客戶的應用程式池中",
    'sapp__appi_not_shared_no_install' => "客戶應用程式池中沒有此應用程式。如果您想在網站上安裝此應用程式，請先將此應用程式添加到客戶應用程式池中。",
    'sapp__appi_shared_not_client' => "客戶應用程式池中沒有此應用程式。如果您想將此應用程式升級到指定版本，請先將此版應用程式添加到客戶應用程式池中。",
    'sapp__apply_license_script_not_found' => '無法找到此web應用程式的"apply-license"腳本。',
    'sapp__unable_to_activate_key' => '嘗試啟動許可證的過程中出錯：%1',
    'sapp__unable_to_delete_ai_instances_exists' => '系統中已安裝所需web應用程式。',
    'sapp__unable_to_delete_ai_in_pool' => '此應用程式仍在客戶池中。如果要刪除此應用程式，您需要先從所有客戶應用程式池中刪除它，或允許用戶免費使用它。',
    'sapp__unable_to_delete_app_template' => '無法刪除應用程式#%1: %2',
    'sapp__limit_exceeded_client' => '您已達到此web應用程式的安裝次數限制(%2)。',


    // atis module

    '_week_on' => '周',
    '__week_first' => '首頁',
    '__week_second' => '第二',
    '__week_third' => '第三',
    '__week_fourth' => '第四',
    '__week_last' => '最後',
    '__not_started' => '等待',
    '__started' => '正在運行',
    '__cancel_pending' => '正在取消',
    '__canceled' => '已取消',
    '__error' => '錯誤',
    '__done' => '完成',

    '__php_cgi_handler' => 'CGI應用程式',
    '__php_isapi_handler' => 'ISAPI擴展',
    '__php_fastcgi_handler' => 'FastCGI應用程式',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => '運行身份',

    'firewall_tabs_rules' => '防火牆規則',

    'cf_dbfolder_text' =>'資料庫資料夾',
    'cf_isnewdb_text' => '創建資料庫',
    'cf_isnewdb_title' => '若必須創建資料庫資料庫，請選中複選庫',

    'pb__site_apps_upgrade' => 'Web應用程式升級',

    'detach' => '斷開連接',
    'preferences' => "更改密碼",

    'toolsbar__switch_user?' => "您確定要使用另一使用者帳戶登入嗎？",
    '__aps_left' => '可用的安裝',
    'aps__license_key' => '許可證金鑰',
    'aps__download_code' => '許可證下載和啟動碼',
    'aps__license_key_hint' => '使用啟動碼從授權伺服器進行檢索',
    'aps__database_not_available' => '不可用，請檢查域名或客戶限制',
    'aps__yes' => '是',
    'aps__no' => '否',
    '__click_to_enlarge' => '點按放大',
    'site_apps__back_to_list' => '返回列表',
    'sapp__pkg_info_installation_requirements' => '安裝要求',
    '__close_window' => '關閉',

    //SAPP END

    'skin_info__already_default' => '已將此外觀設定為默認外觀。',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => '針對 %1 的 Plesk Premium Antivirus 設定',
    'drweb:properties_legend' => '設定',
    'drweb:status' => '檢查病毒郵件',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder 嚮導',
    'dom_site_builder' => '點按打開 Presence Builder 嚮導。',
    'sb_plesk_admin_url' => 'Presence Builder 伺服器URL。確保此位址在 DNS 中正確解析。',
    'sb_plesk_admin_login' => '伺服器管理員登入 Presence Builder 所用的用戶名',
    'sb_plesk_admin_password' => '管理員密碼',
    'sb_sitebuilder_preferences' => 'Presence Builder 管理員憑據',
    'sb__server' => 'Presence Builder 系統管理員偏好設定',
    'sb__sitebuilder_support' => 'Presence Builder 支援',
    'sb_keep_sb_user' => '在 Presence Builder 中保留相應使用者帳戶',
    'sb_create_sb_user' => '在 Presence Builder 中創建相應的用戶帳戶',
    'sb__build_site_using_sitebuilder' => "使用 Presence Builder 創建網站",
    'sb_no_current_sb_server_set' => '尚未配置 Presence Builder 連接: 您需要在 DNS 區域範本中添加指向 Presence Builder 伺服器的記錄。',
    'sb_unable_update_sb_server_sb_return_message' => "無法從 Presence Builder 系統檢索資訊:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "無法連接 Presence Builder : 用戶名或密碼錯誤。",
    'sb_init_sb_manager' => "初始化 Presence Builder 管理器: %1",
    'sb_err_couldnt_connect_sb' => "連接 Presence Builder 系統失敗。",
    'sb_err_client_dont_have_sbuser' => "此客戶在 Presence Builder 中沒有使用者帳戶。",
    'sb_err_sitebuilder_not_configured' => "未配置 Presence Builder 。",
    'sb_err_you_dont_have_sbaccount' => "在 Presence Builder 中給您授權時失敗。",
    'sb_error_critical_during_operation' => "Presence Builder 中出現下列錯誤:\n%1",
    'sb_err_sso_is_not_enabled' => "在 Plesk 中並未啟用單點登入支援。",

    'forbid_create_dns_subzone' => "不允許用戶在其它使用者的 DNS 主區域中創建 DNS 子區域",
    'warning__super_zone_exist' => "已創建區域%1，但此區域名是另一區域%2(該區域屬於另一使用者%3)的子區域名。有這種可能，但請確認您已選擇正確的使用者帳戶。",
    'error__super_zone_exist' => "無法創建DNS區域，因它的主區域屬於另一使用者。",

    'locales__files_not_exits' => '無法更改語言: 系統中沒有指定的介面語言包。',
    'locales__unavailable' => '無法更改語言: 指定的介面語言包不可用。',

    // DB BU

    'pb__dbbackup_list' => '資料庫備份檔案',
    // server
    'dbbackup__server_backup_settings' => '備份',
    'dbbackup__network_temp_dir' => '臨時網路目錄',
    'dbbackup__network_user' => '用戶名',
    'dbbackup__network_pass' => '密碼',
    // domain
    'dbbackup__add_database_legend' => '恢復備份的資料庫',
    'dbbackup__add_database_restore' => '從備份檔案恢復資料庫',
    'dbbackup__add_database_file' => '資料庫備份檔案',
    'dbbackup__add_database_user' => '預設使用者名',
    'dbbackup__add_database_pass' => '預設使用者密碼',
    'dbbackup__add_database_pass2' => '預設使用者密碼確認',

    'bt_dbbackup_now' => '備份',

    'bt_repair' => '修理',

    'dbbackup__mssql_dump_upload_not_allowed' => '主機提供商禁止上傳 SQL 伺服器資料庫轉存。',

    // APS categories

    'cf_invalid_password' => '密碼不可以超過16個字元',
    'cf_invalid_description_length' => '描述不可以超過256個符號',
    'ip_addr__ip_used_by_external_mail_server' => 'IP位址%1已被外部郵件伺服器使用',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP帳戶用戶名或密碼無效。請指定正確的FTP用戶憑據。',

    // 8.6

    'dns__dns_serial_update_limit_warning' => '已達到序號更改限制。今日不可以再進行任何DNS區域更改。',
    'dns__serial_format_legend' => 'DNS 區域序號格式',
    'dns__soa_param_serial_format_hint' => '使用 IETF 和 RIPE 推薦的序號格式可解決註冊混亂的問題，因此強制用於一些高級別 DNS 區域中註冊的眾多域名中。',
    'dns__soa_param_serial_format' => '選擇使用 IETF 與 RIPE 推薦的序號格式。',
    'dns__serial_format_dns_zone_update_delay' => '在多個DNS區域序號格式之間切換可能會導致DNS區域更新延遲',
    'dns__zone_apply_changes' => '尚未保存對DNS記錄所做的更改。下方高亮顯示這些更改。按一下更新將這些更改應用到DNS區域，或按一下恢復放棄更改。',
    'dns__update_dns_zone' => '按一下保存對DNS記錄所做的更改。',
    'dns__revert_dns_zone' => '按一下取消對DNS記錄所做的更改。',
    'bt_revert' => '還原',
    'dns__dns_zone_has_beed_updated' => '已保存對DNS記錄所做的更改。',
    'dns__dns_zone_has_beed_reverted' => '已取消對DNS記錄所做的更改。',
    'db__nondefault_server_not_allowed' => '不允許使用非預設的資料庫伺服器',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => '客戶%1的帳戶和域名。',
    'ui__client__disabled-warning' => '客戶%1的帳戶已掛起。',
    'ui__client__none-available' => '未配置客戶帳戶。',
    'ui__client__short-title' => '%1',
    'ui__client__title' => '客戶%1',
    'ui__client_self__description' => '我的域名列表。',
    'ui__client_self__short-title' => '我的域名',
    'ui__client_self__title' => '我的域名',


    'site_apps__non_removable' => '無法刪除的項目',
    'site_apps__non_removable_items' => '無法刪除下列web應用程式:',

    'ui__client/custom-buttons/custom-button__none-available' => '尚無自訂按鈕。',
    'ui__client/custom-buttons/custom-button__none-available__1' => '在客戶 %1 的客戶面板中沒有自訂按鈕。',

    'ui__client/custom-buttons/custom-button/delete__description' => '刪除按鈕%1。',
    'ui__client/custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__client/custom-buttons/custom-button/delete__title' => '刪除按鈕%1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => '從客戶的客戶面板移除自訂按鈕',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => '刪除自訂按鈕',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => '刪除按鈕',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '選擇要刪除其自訂按鈕的客戶，並按一下“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '選擇您要刪除的按鈕，並按一下“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '通過選中螢幕上的核取方塊確認刪除該按鈕，並按一下“完成”。',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => '從客戶的客戶面板移除自訂按鈕。',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => '刪除自訂按鈕',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => '刪除自訂按鈕',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '選擇要刪除其自訂按鈕的客戶，並按一下“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '選擇要刪除的自訂按鈕，並按一下“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => '通過選中螢幕上的核取方塊來確認刪除自訂按鈕，並按一下“完成”。',

    'ui__client/custom-buttons/custom-button/properties__description' => '編輯客戶級按鈕%1的屬性。',
    'ui__client/custom-buttons/custom-button/properties__short-title' => '設定',
    'ui__client/custom-buttons/custom-button/properties__title' => '修改客戶按鈕%1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => '添加自訂按鈕',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '請選定您想要在其客戶面板中創建自訂按鈕的的客戶並點按下一步 >>。',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => '按一下“完成”創建按鈕。',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => '請在客戶的客戶面板中更改按鈕許可權。',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => '屬性',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => '請在客戶的客戶面板中更改按鈕許可權',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => '更改自訂按鈕屬性',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => '選擇您要修改其自訂按鈕的客戶，並按一下“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '選擇要修改的自訂按鈕，並按一下“下一步 >>”。',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => '完成編輯按鈕屬性之後，請按一下“完成”應用更改並退出嚮導。',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => '使得按鈕%1對您的客戶不可用。',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => '對您的客戶不可用',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => '使得按鈕%1對您的客戶不可用',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => '讓按鈕%1對客戶的使用者可見。',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => '對您的客戶可用',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => '讓按鈕%1對客戶的使用者可見',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => '使得自訂按鈕對您的客戶可用/不可用。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => '對您的客戶可用/不可用',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => '使得自訂按鈕對您的客戶可用/不可用',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => '使得自訂按鈕對您的客戶可用/不可用。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '選擇可以使用其自訂按鈕的客戶，並按一下“下一步>>”。',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '選擇您要使其對您的客戶可用或不可用的自訂按鈕，並按一下“下一步 >>”。',

    'ui__client/domain__description' => '管理域名%1。',
    'ui__client/domain__disabled-warning' => '域名%1已掛起。',
    'ui__client/domain__none-available' => '您尚無任何域名。',
    'ui__client/domain__none-available__1' => '帳戶%1尚無任何域名。',
    'ui__client/domain__none-available__2' => '帳戶%1尚無任何域名。',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => '域名 %1',
    'ui__client/domain_self__description' => '管理域名。',
    'ui__client/domain_self__disabled-warning' => '您的域名已掛起。',
    'ui__client/domain_self__quick-search' => '我的域名',
    'ui__client/domain_self__short-title' => '我的域名',
    'ui__client/domain_self__title' => '我的域名',

    'ui__client/domain/custom-buttons/custom-button__none-available' => '客戶的客戶面板中沒有放置自訂按鈕。',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => '客戶 %1 在客戶面板中沒有放置自訂按鈕。',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => '域名%1沒有自訂按鈕',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => '刪除自訂按鈕%1。',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => '刪除自訂按鈕%1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => '刪除自訂按鈕。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => '刪除自訂按鈕',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => '刪除自訂按鈕',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '選擇要從其域名管理員面板刪除按鈕的客戶，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => '選擇要從其管理員面板刪除按鈕的域名，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '選擇您要刪除的按鈕，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => '通過選中相應核取方塊確認刪除按鈕，按一下“完成”以刪除該按鈕並退出嚮導。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => '刪除級自訂按鈕。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => '刪除自訂按鈕',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => '刪除自訂按鈕',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '選擇要從其域名管理員面板刪除自訂按鈕的客戶，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '選擇要從其管理員面板刪除按鈕的域名，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => '選擇要刪除的自訂按鈕，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => '通過選中核取方塊確認刪除自訂按鈕，按一下“完成”刪除該按鈕，並退出嚮導。',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "更改自訂按鈕%1的屬性",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "屬性",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "請在客戶面板中更改自訂按鈕 %1 的許可權。",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => '添加按鈕',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '請選定您想要在其客戶面板中放置按鈕的的客戶並點按下一步 >>。',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => '選擇要為其控制台修改按鈕的域名，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => '按一下“完成”以創建按鈕並退出嚮導。',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "請在客戶面板中更改按鈕許可權。",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => '屬性',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => '請在客戶面板中更改按鈕許可權',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => '更改按鈕屬性',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "選擇要修改其設定的自訂按鈕，並按一下“下一步 >>”。",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => '更改按鈕屬性之後，按一下“完成”應用更改並退出嚮導。',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => '使得按鈕%1在此域名中對郵件用戶不可用。',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => '對郵件用戶不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => '使得按鈕%1在此域名中對郵件用戶不可用。',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => '使得按鈕%1在此域名中對郵件用戶不可用。',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => '該域名下的郵件用戶可對其進行存取',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => '使得自訂按鈕%1對該域名下的郵件用戶可見',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => '使得自訂按鈕對其他使用者可用或不可用。',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => '對其他用戶可用/不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => '使得自訂按鈕對郵件使用者可用/不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => '使得自訂按鈕對其他使用者可用/不可用',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '選擇存放該按鈕的域名，並按一下“下一步 >>”。',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => '選擇要使其對其他用戶可用或不可用的按鈕，並按一下“下一步 >>”。',

    'ui__client/domain/delete__description' => '刪除域名%1。',
    'ui__client/domain/delete__short-title' => '移除',
    'ui__client/domain/delete__title' => '刪除域名%1',
    'ui__client/domain/delete_multi__description' => '刪除域名。',

    'ui__client/domain/delete_multi__short-title' => '移除',
    'ui__client/domain/delete_multi__title' => '刪除域名',
    'ui__client/domain/delete_multi__wizard-title' => '刪除域名',
    'ui__client/domain/delete_multi__wizard__2_multi' => '選擇您要刪除的域名並按一下“下一步 >>”。',
    'ui__client/domain/delete_multi__wizard__3_multi' => '通過選中核取方塊確認移除域名，按一下“完成”以完成移除並退出嚮導。',
    'ui__client/domain/delete_unknown__description' => '刪除域名。',
    'ui__client/domain/delete_unknown__short-title' => '移除',
    'ui__client/domain/delete_unknown__title' => '刪除域名',
    'ui__client/domain/delete_unknown__wizard-title' => '刪除域名',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => '選擇要刪除的域名，並按一下“下一步 >>”。',
    'ui__client/domain/delete_unknown__wizard__3' => '通過選中核取方塊以確認刪除域名，按一下“完成”徹底刪除並退出嚮導。',

    'ui__client/domain/hosting__none-available' => '無配置虛擬主機的域名。創建域名並配置虛擬主機才可以存取此功能。',
    'ui__client/domain/hosting__none-available__1' => '此使用者帳戶沒有配置虛擬主機的域名。在所需域名上配置虛擬主機才可以存取此功能。',
    'ui__client/domain/hosting__none-available__2' => '尚未在域名%1上配置虛擬主機。在域名%1上配置虛擬主機才可以存取此功能。',

    'ui__client/domain/hosting/file-manager_unknown__wizard-title' => '管理您的檔和目錄',
    'ui__client/domain/hosting/file-manager_unknown__wizard__2_unknown' => '選擇要使用的其檔的域名。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_phosting' => '尚未在域名上配置主機。請設定物理主機，並按一下“下一步 >>”轉到檔案管理員。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__3/properties_self-phosting' => '尚未在您的域名上配置主機。請設定物理主機，並按一下“下一步>>”轉到檔案管理員。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4' => '使用檔和目錄後，按一下“完成”退出嚮導。',
    'ui__client/domain/hosting/file-manager_unknown__wizard__4_self' => '使用檔和目錄後，按一下“完成”退出嚮導。',

    'ui__client/domain/hosting/performance_readonly-unknown__wizard-title' => '查看主機性能設定',

    'ui__client/domain/hosting/performance_unknown__wizard-title' => '調整虛擬主機性能設定',
    'ui__client/domain/hosting/performance_unknown__wizard__2_readonly-unknown' => '選擇您希望查看其主機性能設定的域名，並按一下“下一步 >>”。',
    'ui__client/domain/hosting/performance_unknown__wizard__2_unknown' => '選擇您希望配置其主機性能設定的域名，並按一下“下一步 >>”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4' => '調整域名上的虛擬主機性能設定，並按一下“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly' => '查看域名的主機性能設定之後，請按一下“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-self' => '查看域名的主機性能設定之後，請按一下“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_readonly-unknown' => '查看域名的主機性能設定之後，請按一下“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_self' => '查看域名的主機性能設定之後，請按一下“完成”。',
    'ui__client/domain/hosting/performance_unknown__wizard__4_unknown' => '查看域名的主機性能設定之後，請按一下“完成”。',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "客戶",
    'ui__client/domain/hosting/application#list_header__description__title' => "描述",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "項目",
    'ui__client/domain/hosting/application#list_header__name__title' => "名稱",
    'ui__client/domain/hosting/application#list_header__release__title' => "發行版本本",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "按客戶進行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "按描述進行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "按項目進行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "按名稱進行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "按版本進行排序",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "按版本進行排序",
    'ui__client/domain/hosting/application#list_header__title' => "Web應用程式",
    'ui__client/domain/hosting/application#list_header__version__title' => "版本",

    'ui__client/domain/properties__client_ip_address_was_assigned' => '已將IP地址%%ip_address%%分配給%%client_name%%。',
    'ui__client/domain/properties__client_ip_pool_is_empty' => '用戶IP池為空。所選IP位址將會分配給相應的使用者帳戶。',

    'ui__client/domain/properties_new-adhoc__wizard__3_new' => '按一下“下一步 >>”後，新的域名將立刻創建。',

    'ui__client/domain/properties_new__wizard-title' => '創建域名',
    'ui__client/domain/properties_new__wizard__1_unknown' => '選擇要為其創建域名的客戶。',
    'ui__client/domain/properties_new__wizard__2/hosting/properties' => '選擇所需主機服務類型，並按一下“下一步 >>”',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_forwarding' => '配置域名的轉發之後，按一下“完成”應用配置，並退出嚮導。',
    'ui__client/domain/properties_new__wizard__2/hosting/properties_phosting' => '在域名上配置好主機服務後，按一下“完成”應用所有更改，並退出嚮導。',

    'ui__client/domain/properties_unknown__wizard-title' => '設定域名管理員帳戶',
    'ui__client/domain/properties_unknown__wizard__2_unknown' => '選擇要為其設定域名管理員帳戶的域名。',
    'ui__client/domain/properties_unknown__wizard__3' => '要完成域名管理員帳戶的創建，請按一下“完成”。',
    'ui__client/domain/properties_unknown__wizard__3_self' => '要應用更改並退出嚮導，請按一下“完成”。',

    'ui__client/domain/report/anon-ftp-stats_unknown__description' => '域名的匿名 FTP 統計',
    'ui__client/domain/report/anon-ftp-stats_unknown__short-title' => '匿名 FTP 統計',
    'ui__client/domain/report/anon-ftp-stats_unknown__title' => '域名的匿名 FTP 統計',

    'ui__client/domain/report/ftp-stats_unknown__description' => '域名的 FTP 統計',
    'ui__client/domain/report/ftp-stats_unknown__short-title' => 'FTP 統計',
    'ui__client/domain/report/ftp-stats_unknown__title' => '域名的 FTP 統計',

    'ui__client/domain/report/traffic__description' => '查看網站 %1 的頻寬使用情況',
    'ui__client/domain/report/traffic__short-title' => '頻寬使用情況',
    'ui__client/domain/report/traffic__title' => '網站 %1 的頻寬使用情況',

    'ui__client/domain/report/web-stats-ssl_unknown__description' => '有關網站安全存取的統計',
    'ui__client/domain/report/web-stats-ssl_unknown__short-title' => '有關通過 SSL/TLS 的存取的統計',
    'ui__client/domain/report/web-stats-ssl_unknown__title' => '有關網站安全存取的統計',

    'rpt_reseller_section_general' => '常用',
    'rpt_reseller_section_domains' => '域名',
    'rpt_reseller_section_clients' => '客戶',
    'statistics__cl_active_domains' => "活動域名",
    'rpt_reseller_cl_domains' => "域名",
    'rpt_reseller_cl_subdomains' => "子域名",
    'by__cl_domains' => "客戶域名",
    'dom_ctrl__cl_mboxes' => "郵箱",
    'rpt_reseller_cl_redirects' => "轉發器",
    'rpt_reseller_cl_mail_groups' => "郵件組",
    'rpt_reseller_cl_mail_resps' => "自動回復",
    'rpt_reseller_cl_mail_lists' => "郵寄清單",
    'rpt_reseller_cl_web_users' => "網站用戶",
    'rpt_reseller_cl_data_bases' => "資料庫",

    'statistics__active_clients' => '有活動訂閱的客戶',
    'statistics__clients_active_domains' => '活動域名',
    'statistics__clients_doms' => '域名',
    'statistics__cl_doms' => '域名',
    '__clients_subdomains' => '子域名',
    '__clients_domains' => '域名',
    'dom_ctrl__clients_mboxes' => '郵箱',
    'dom_ctrl__clients_redir' => '轉發器',
    'dom_ctrl__clients_mg' => '郵件組',
    'dom_ctrl__clients_resp' => '自動回復',
    'dom_ctrl__clients_maillists' => '郵寄清單',
    'dom_ctrl__clients_wu' => '網站用戶',
    'dom_ctrl__clients_db' => '資料庫',

    'dom_ctrl__cl_redir' => '轉發器', // to resolve!
    'dom_ctrl__cl_mg' => '郵件組', // to resolve!
    'dom_ctrl__cl_resp' => '自動回復', // to resolve!
    'dom_ctrl__cl_maillists' => '郵寄清單', // to resolve!
    'dom_ctrl__cl_wu' => '網站用戶', // to resolve!
    'dom_ctrl__cl_db' => '資料庫', // to resolve!

    'rpt_cl_section_clients' => '客戶',

    'rpt_admin_section_general' => '常用',
    'rpt_admin_section_resellers' => '代理商',
    'rpt_admin_section_clients' => '客戶',
    'rpt_admin_section_personal_clients' => '個人客戶',
    'rpt_admin_section_domains' => '域名',
    'rpt_admin_section_personal_domains' => '個人域名',

    'rpt_reseller_section_personal_domains' => '個人域名',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => '選擇要掛起或啟動的域名。',
    'ui__client/domain/toggle_unknown__wizard-title' => '掛起或啟動域名',

    'ui__client/ip-pool__description' => '分配或重新分配 IP 位址和 SSL/TLS 證書給客戶 %1。',
    'ui__client/ip-pool__short-title' => 'IP池',
    'ui__client/ip-pool__title' => '客戶%1的IP池',
    'ui__client/ip-pool_self__description' => '查看您的IP池。',
    'ui__client/ip-pool_self__short-title' => 'IP池',
    'ui__client/ip-pool_self__title' => '我的IP池',
    'ui__client/ip-pool/properties__description' => '設定客戶%1的IP池。',

    'ui__client/ip-pool/properties__short-title' => 'IP池',
    'ui__client/ip-pool/properties__title' => '設定客戶%1的IP池',
    'ui__client/ip-pool/properties_self__description' => '查看您的IP池。',

    'ui__client/ip-pool/properties_self__short-title' => '我的IP池',
    'ui__client/ip-pool/properties_self__title' => '我的IP池',
    'ui__client/ip-pool/properties_unknown__description' => '分配或重新分配客戶的 IP 位址和 SSL/TLS 證書。',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP池',
    'ui__client/ip-pool/properties_unknown__title' => '設定客戶IP池',
    'ui__client/ip-pool/properties_unknown__wizard-title' => '設定客戶IP池',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => '選擇要配置其IP池的客戶。',
    'ui__client/ip-pool/properties_unknown__wizard__3' => '編輯客戶IP池之後，按一下“完成”應用更改，並退出嚮導。',


    'ui__client/limits_readonly-unknown__description' => '查看客戶的資源限制。',
    'ui__client/limits_readonly-unknown__short-title' => '資源限制',
    'ui__client/limits_readonly-unknown__title' => '查看客戶帳戶的資源限制。',
    'ui__client/limits_readonly-unknown__wizard-title' => '查看或更改客戶的資源限制',

    'ui__client/limits_unknown__wizard-title' => '查看或更改客戶的資源限制',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => '請選擇所需客戶。',
    'ui__client/limits_unknown__wizard__1_unknown' => '請選擇所需客戶。',
    'ui__client/limits_unknown__wizard__2' => '要應用更改，按一下“完成”。',
    'ui__client/limits_unknown__wizard__2_readonly' => '要退出嚮導，請按一下“完成”。',
    'ui__client/limits_unknown__wizard__2_readonly-self' => '要退出嚮導，請按一下“完成”。',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => '要退出嚮導，請按一下“完成”。',

    'ui__client/permissions_unknown__wizard-title' => '查看或更改客戶許可權',
    'ui__client/permissions_unknown__wizard__1/properties_self' => '查看您的許可權後，請按一下“完成”應用更改，並退出嚮導。',
    'ui__client/permissions_unknown__wizard__1_unknown' => '選擇要查看或編輯其許可權的客戶。',
    'ui__client/permissions_unknown__wizard__2' => '更改客戶許可權後，請按一下“完成”應用更改，並退出嚮導。',

    'ui__client/preferences_unknown__wizard-title' => '編輯客戶偏好設定',
    'ui__client/preferences_unknown__wizard__1_unknown' => '選擇要管理其會話和介面偏好設定的客戶。',
    'ui__client/preferences_unknown__wizard__2' => '更改客戶偏好設定後，按一下“完成”。',
    'ui__client/preferences_unknown__wizard__2_self' => '更改偏好設定後，按一下“完成”。',

    'ui__custom-buttons/custom-button__none-available' => '您尚無自訂按鈕。',
    'ui__custom-buttons/custom-button/delete__description' => '刪除自訂按鈕%1。',
    'ui__custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__custom-buttons/custom-button/delete__title' => '刪除自訂按鈕%1',
    'ui__custom-buttons/custom-button/delete_multi__description' => '刪除自訂按鈕。',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__custom-buttons/custom-button/delete_multi__title' => '刪除自訂按鈕',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => '刪除自訂按鈕',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => '選擇您要刪除的自訂按鈕。',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => '通過選中核取方塊確認刪除按鈕，按一下“完成”並退出嚮導。',
    'ui__custom-buttons/custom-button/delete_unknown__description' => '刪除自訂按鈕。',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__custom-buttons/custom-button/delete_unknown__title' => '刪除自訂按鈕',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => '刪除自訂按鈕',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => '選擇要刪除的自訂按鈕。',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => '通過選中核取方塊來確認按鈕的刪除，按一下“完成”退出嚮導。',
    'ui__custom-buttons/custom-button/properties__description' => '更改按鈕%1的屬性。',

    'ui__custom-buttons/custom-button/properties__short-title' => '屬性',
    'ui__custom-buttons/custom-button/properties__title' => '更改按鈕%1的屬性',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => '創建按鈕',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => '按一下“完成”創建按鈕。',
    'ui__custom-buttons/custom-button/properties_unknown__description' => '更改自訂按鈕的屬性。',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => '屬性',
    'ui__custom-buttons/custom-button/properties_unknown__title' => '更改自訂按鈕屬性',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => '更改自訂按鈕屬性',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => '選擇要更改其屬性的自訂按鈕。',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => '要應用更改，按一下“完成”。',
    'ui__custom-buttons/custom-button/toggle_private__description' => '使自訂按鈕%1對其他使用者不可用。',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => '對其他用戶不可用',
    'ui__custom-buttons/custom-button/toggle_private__title' => '使自訂按鈕%1對其他使用者不可用',
    'ui__custom-buttons/custom-button/toggle_public__description' => '使自訂按鈕%1對其他使用者可用。',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => '對其他用戶可用',
    'ui__custom-buttons/custom-button/toggle_public__title' => '使自訂按鈕%1對其他使用者可用',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => '使自訂按鈕對其他使用者可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => '對其他用戶可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => '使自訂按鈕對其他使用者可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => '使自訂按鈕對其他使用者可用或不可用。',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => '選擇您要將其設定為對其他用戶可用或不可用的自訂按鈕，並按一下“下一步 >>”。',

    'ui__longtasks#list_header__name__title' => "名稱",
    'ui__longtasks#list_header__owner__title' => "所有者",
    'ui__longtasks#list_header__start_time__title' => "創建時間",
    'ui__longtasks#list_header__status__title' => "狀態",
    'ui__longtasks#list_header__title' => "任務",
    'ui__longtasks#list_header__finish_time__title' => "完成時間",
    'ui__longtasks#task_list_legend__title' => "任務",
    'ui__longtasks#tools_legend__title' => "工具",
    'ui__longtasks__description' => "管理幕後工作",
    'ui__longtasks__short-title' => "幕後工作",
    'ui__longtasks__title' => "幕後工作",
    'ui__longtasks/longtask/properties#current_operation__title' => "當前操作：",
    'ui__longtasks/longtask/properties#finish_time__title' => "預計完成時間：",
    'ui__longtasks/longtask/properties#general_legend__title' => "常用",
    'ui__longtasks/longtask/properties#owner__title' => "任務開始時間：",
    'ui__longtasks/longtask/properties#progress__title' => "整體進程：",
    'ui__longtasks/longtask/properties#start_time__title' => "任務開始：",
    'ui__longtasks/longtask/properties#status_legend__title' => "任務狀態",
    'ui__longtasks/longtask/properties__description' => "幕後工作狀態和資訊",

    'ui__longtasks/properties__description' => "幕後工作設定",
    'ui__longtasks/properties__short-title' => "設定",
    'ui__longtasks/properties__title' => "幕後工作",

    // updated
    'ui__mass-mail/template#list_header__title' => '群發郵件範本',
    'ui__mass-mail/template#list_header__name__title' => '範本名稱',
    'ui__mass-mail/template#list_header__from_email__title' => '寄件者',
    'ui__mass-mail/template#list_header__to__title' => '收件人',
    'ui__mass-mail/template#list_header__subject__title' => '主題',
    'ui__mass-mail/template#list_header__cdate__title' => '創建日',
    'ui__mass-mail/template#list_header__send__title' => '發送',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => '編輯群發郵件範本',
    'ui__mass-mail/template/properties__description' => '編輯此群發郵件範本',

    'ui__mass-mail/template/properties_unknown-new__short-title' => '添加群發郵件範本',
    'ui__mass-mail/template/properties_unknown-new__title' => '添加群發郵件範本',
    'ui__mass-mail/template/properties_unknown-new__description' => '添加群發郵件資訊範本。',
    'ui__mass-mail/send__short-title' => '群發郵件',
    'ui__mass-mail/send__title' => '群發郵件',
    'ui__mass-mail/send__description' => '向所選收件人群發郵件。',
    'ui__mass-mail/template/delete_multi__short-title' => '刪除群發郵件範本',
    'ui__mass-mail/template/delete_multi__title' => '刪除群發郵件範本:',
    'ui__mass-mail/template/delete_multi__description' => '刪除所選的群發郵件範本。',
    'ui__mass-mail/template/delete_multi__done' => '所選郵件範本已移除。',
    'ui__mass-mail/template/properties__invalid_values' => '指定的值無效',


    // old
    'ui__mass-mail#body_text__description' => '您可以在資訊文本（但不是標頭）中使用<name> 變數。這將會被客戶或代理商的連絡人名稱代替。',
    'ui__mass-mail#body_text__title' => '資訊文本',
    'ui__mass-mail#compose_legend__title' => '信息',
    'ui__mass-mail#from_email_text__title' => '發自（電郵地址）',
    'ui__mass-mail#list_header__cdate__title' => '已創建',
    'ui__mass-mail#list_header__from_email__title' => '來自',
    'ui__mass-mail#list_header__name__title' => '名稱',
    'ui__mass-mail#list_header__send__title' => '創建郵件',
    'ui__mass-mail#list_header__subject__title' => '主題',
    'ui__mass-mail#list_header__title' => '群發郵件範本',
    'ui__mass-mail#list_header__to__title' => '至',
    'ui__mass-mail#list_legend__title' => '群發郵件範本',
    'ui__mass-mail#load_template_text__title' => '載入',
    'ui__mass-mail#name_text__title' => '範本名稱',
    'ui__mass-mail#option_mode_all__title' => '所有',
    'ui__mass-mail#option_mode_except__title' => '除所選外的全部項',
    'ui__mass-mail#option_mode_select__title' => '僅所選項',
    'ui__mass-mail#option_select_template__title' => '---選擇範本---',
    'ui__mass-mail#picker_legend__title' => '電子郵件範本',
    'ui__mass-mail#picker_title__title' => '選擇一個範本',
    'ui__mass-mail#save_as_legend__title' => '另存為範本',
    'ui__mass-mail#save_as_text__title' => '保存組合資訊到一個新的範本（名為',
    'ui__mass-mail#subject_text__title' => '主題',
    'ui__mass-mail#template_legend__title' => '範本',
    'ui__mass-mail#to_admin_text__title' => 'Plesk 管理員',
    'ui__mass-mail#to_clients_text__title' => '客戶',
    'ui__mass-mail#to_domains_text__title' => '域名管理員',
    'ui__mass-mail#to_select_text__title' => '選擇位址',
    'ui__mass-mail#to_show_hide_text__title' => '顯示/隱藏所選項',
    'ui__mass-mail#to_text__title' => '至',
    'ui__mass-mail#tools_legend__title' => '工具',
    'ui__mass-mail__already_exists' => '名為%1的範本已存在',
    'ui__mass-mail__none-available' => '您尚無郵件範本',

    'ui__mass-mail/delete__description' => '刪除群發電子郵件範本 %1',

    'ui__mass-mail/delete__empty_selection' => '請選擇您要刪除的範本',
    'ui__mass-mail/delete__short-title' => '刪除%1',
    'ui__mass-mail/delete__title' => '刪除群發電子郵件範本 %1',
    'ui__mass-mail/delete_multi__description' => '刪除群發電子郵件範本。',

    'ui__mass-mail/delete_multi__short-title' => '移除',
    'ui__mass-mail/delete_multi__title' => '刪除群發電子郵件範本',
    'ui__mass-mail/delete_multi__wizard-title' => '刪除群發電子郵件範本',
    'ui__mass-mail/delete_multi__wizard__1_multi' => '選擇您要刪除的群發電子郵件範本。',
    'ui__mass-mail/delete_multi__wizard__2_multi' => '通過選中核取方塊確認刪除範本，按一下“完成”並退出嚮導。',
    'ui__mass-mail/delete_unknown__description' => '刪除群發電子郵件範本。',
    'ui__mass-mail/delete_unknown__short-title' => '移除',
    'ui__mass-mail/delete_unknown__title' => '刪除群發電子郵件範本',
    'ui__mass-mail/delete_unknown__wizard-title' => '刪除群發電子郵件範本。',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => '選擇您要刪除的群發電子郵件範本。',
    'ui__mass-mail/delete_unknown__wizard__2' => '通過選中核取方塊確認刪除範本，按一下“完成”並退出嚮導。',

    'ui__mass-mail/properties__description' => '編輯電子郵件範本 %1。',

    'ui__mass-mail/properties__invalid_values' => '指定的值不正確',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => '編輯電子郵件範本%1。',

    'ui__mass-mail/properties_new__wizard-title' => '創建群發電子郵件範本',
    'ui__mass-mail/properties_unknown-new__description' => '創建電子郵件範本。',
    'ui__mass-mail/properties_unknown-new__short-title' => '添加電子郵件範本',
    'ui__mass-mail/properties_unknown-new__title' => '創建電子郵件範本',
    'ui__mass-mail/properties_unknown__wizard-title' => '編輯群發電子郵件範本',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => '選擇您要修改的範本並按一下“下一步 >>”。',
    'ui__mass-mail/properties_unknown__wizard__2' => '編輯範本完成後，請按一下“完成”應用更改並退出嚮導。',

    'ui__mass-mail/send__invalid_values' => '您指定了不正確的值',

    'ui__mass-mail/send_new__wizard-title' => '創建郵件範本並發送電子郵件',
    'ui__mass-mail/send_unknown-new__description' => '向所選收件人發送電子郵件',

    'ui__mass-mail/send_unknown-new__short-title' => '群發郵件',
    'ui__mass-mail/send_unknown-new__title' => '群發郵件',
    'ui__mass-mail/send_unknown__description' => '向所選收件人發送電子郵件',

    'ui__mass-mail/send_unknown__short-title' => '群發郵件',
    'ui__mass-mail/send_unknown__title' => '群發郵件',
    'ui__mass-mail/send_unknown__wizard-title' => '群發郵件',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => '選擇您所需的範本並按一下“下一步 >>”。',
    'ui__mass-mail/send_unknown__wizard__2' => '編輯範本屬性完成後，請按一下“完成”發送郵件並退出嚮導。',

    'ui__mass-email/delete__description' => '刪除所選的群發郵件範本。',

    'ui__mass-email/delete__empty_selection' => "請選擇您要刪除的範本。",
    'ui__mass-email/delete__short-title' => "刪除%1",
    'ui__mass-email/delete__title' => "刪除群發電子郵件範本 %1",
    'ui__mass-email/delete_multi__description' => "刪除群發電子郵件範本。",

    'ui__mass-email/delete_multi__short-title' => "移除",
    'ui__mass-email/delete_multi__title' => "刪除群發電子郵件範本",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "通過選中核取方塊確認刪除範本，按一下“完成”並退出嚮導。",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "選擇您要刪除的群發電子郵件範本。",
    'ui__mass-email/delete_multi__wizard-title' => "刪除群發電子郵件範本",
    'ui__mass-email/delete_unknown__description' => "刪除群發電子郵件範本。",
    'ui__mass-email/delete_unknown__short-title' => "移除",
    'ui__mass-email/delete_unknown__title' => "刪除群發電子郵件範本",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "通過選中核取方塊確認刪除範本，按一下“完成”並退出嚮導。",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "選擇您要刪除的群發電子郵件範本。",
    'ui__mass-email/delete_unknown__wizard-title' => "刪除群發電子郵件範本。",
    'ui__mass-email/send__description' => "向所選收件人發送電子郵件",
    'ui__mass-email/send__short-title' => "群發電子郵件",
    'ui__mass-email/send__title' => "群發郵件",
    'ui__mass-email/send_main__description' => "向所選收件人發送電子郵件",

    'ui__mass-email/send_main__short-title' => "群發電子郵件",
    'ui__mass-email/send_main__title' => "群發電子郵件",
    'ui__mass-email/send_selectresellers__title' => '所選代理商',
    'ui__mass-email/send_selectresellers__short-title' => '代理商',
    'ui__mass-email/send_selectresellers__description' => '所選代理商帳戶',

    'ui__mass-email/send_selectclients__description' => "選擇客戶帳戶",

    'ui__mass-email/send_selectclients__short-title' => "客戶",
    'ui__mass-email/send_selectclients__title' => "選擇客戶",
    'ui__mass-email/send_selectdomainusers__description' => "選擇域名管理員帳戶",

    'ui__mass-email/send_selectdomainusers__short-title' => "域名管理員",
    'ui__mass-email/send_selectdomainusers__title' => "選擇域名管理員",
    'ui__mass-email/template/properties_main__description' => "創建群發電子郵件範本",
    'ui__mass-email/template/properties_main__short-title' => "編輯範本",
    'ui__mass-email/template/properties_main__title' => "編輯群發電子郵件範本",
    'ui__mass-email/template/properties_new-main__description' => "為群發電子郵件創建範本。",
    'ui__mass-email/template/properties_new-main__short-title' => "創建群發電子郵件範本",
    'ui__mass-email/template/properties_new-main__title' => "創建群發電子郵件範本",
    'ui__mass-email/template/properties_new-selectclients__description' => "選擇要基於該範本接收群發電子郵件的客戶",
    'ui__mass-email/template/properties_new-selectclients__title' => "選擇要基於該範本接收群發電子郵件的客戶",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "選擇要基於此範本接收群發電子郵件的域管理員。",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "選擇要基於此範本接收群發電子郵件的域管理員。",
    'ui__mass-email/template/properties_selectclients__title' => "選擇要基於該範本接收群發電子郵件的客戶",
    'ui__mass-email/template/properties_selectdomainusers__title' => "選擇要基於此範本接收群發電子郵件的域管理員。",

    'ui__mass-email/template/properties_unknown-new__description' => "創建群發郵件資訊範本",
    'ui__mass-email/template/properties_unknown-new__short-title' => "創建範本",
    'ui__mass-email/template/properties_unknown-new__title' => "創建群發電子郵件範本",
    'ui__news/dismiss__description' => '點按關閉新聞框架。Plesk 將不會顯示該框架除非已更新新聞文章。',

    'ui__news/dismiss__title' => '關閉新聞',

    'ui__server__description' => '伺服器管理。',
    'ui__server__short-title' => '管理您的伺服器',
    'ui__server__title' => '伺服器管理',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP地址%1不可用。',
    'ui__server/ip-address__none-available' => '無IP地址。',
    'ui__server/ip-addresses/ip-address__title' => "IP 地址",
    'ui__server/ip-address/client/properties_new__description' => "分配IP位址%1給代理商。",
    'ui__server/ip-address/client/properties_new__short-title' => '分配',
    'ui__server/ip-address/client/properties_new__title' => "分配IP位址%1給代理商",
    'ui__server/ip-address/client__none-available' => '無使用者帳戶',
    'ui__server/ip-address/client_unknown__quick_search' => '用戶',
    'ui__server/ip-address/client_unknown__wizard-title' => '使用此IP位址的用戶列表。',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => '請選擇IP位址。',
    'ui__server/ip-address/client/delete__description' => '移除用戶的IP地址。',
    'ui__server/ip-address/client/delete__short-title' => '移除',
    'ui__server/ip-address/client/delete__title' => '移除用戶的IP地址。',
    'ui__server/ip-address/client/delete_multi__description' => "從代理商池移除IP地址。",

    'ui__server/ip-address/client/delete_multi__short-title' => '移除',
    'ui__server/ip-address/client/delete_multi__title' => '移除代理商的IP位址。',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "已從用戶池中移除此IP地址。",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => '選擇要移除的用戶IP位址，並按一下“下一步 >>”。',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => '選擇要移除的用戶IP位址，並按一下“下一步 >>”。',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => '勾選核取方塊確認移除用戶的IP位址，並按一下“完成”退出嚮導。',
    'ui__server/ip-address/client/delete_unknown__description' => '移除代理商的IP位址。',
    'ui__server/ip-address/client/delete_unknown__short-title' => '移除',
    'ui__server/ip-address/client/delete_unknown__title' => '移除代理商的IP位址',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => '移除用戶的IP地址',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => '選擇要移除的用戶IP位址，並按一下“下一步 >>”。',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => '選擇要移除的用戶IP位址，並按一下“下一步>>”。',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => '勾選核取方塊確認移除用戶的IP位址，並按一下“完成”退出嚮導。',

    'ui__server/ip-address/domain__description' => "IP地址%1上的所有域名。",
    'ui__server/ip-address/domain__short-title' => "域名",
    'ui__server/ip-address/domain__title' => "IP地址%1上的域名",
    'ui__server/ip-address/domain_unknown__description' => "IP地址上的所有域名。",
    'ui__server/ip-address/domain_unknown__short-title' => "域名",
    'ui__server/ip-address/domain_unknown__title' => "IP地址上的域名",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "選擇所需的IP位址，並按一下“下一步>>”。",

    'ui__server/ip-address/properties__description' => '更改IP位址%1的屬性。',
    'ui__server/ip-address/properties__short-title' => '屬性',
    'ui__server/ip-address/properties__title' => '更改IP位址%1的屬性',

    'ui__server/ip-address/properties_new__wizard-title' => '添加 IP 地址',
    'ui__server/ip-address/properties_new__wizard__4_new' => '更改IP位址屬性後，按一下“完成”應用更改。',
    'ui__server/ip-address/properties_unknown__description' => '更改IP位址屬性',
    'ui__server/ip-address/properties_unknown__short-title' => '屬性',
    'ui__server/ip-address/properties_unknown__title' => '更改IP位址屬性',
    'ui__server/ip-address/properties_unknown__wizard-title' => '更改IP位址屬性',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => '選擇待更改其屬性的IP位址。',
    'ui__server/ip-address/properties_unknown__wizard__4' => '更改IP位址屬性後，按一下“完成”應用更改。',

    'ui__server/spam-filter/black-list__description' => '為伺服器級的垃圾郵件篩檢程式設定黑名單。',
    'ui__server/spam-filter/black-list__short-title' => '黑名單',
    'ui__server/spam-filter/black-list__title' => '伺服器級的垃圾郵件篩檢程式的黑名單',

    'ui__server/spam-filter/black-list/address__addresses_available' => '將僅添加 %1 首個唯一電子電郵地址。',
    'ui__server/spam-filter/black-list/address__description' => '垃圾郵件篩檢程式黑名單地址。',

    'ui__server/spam-filter/black-list/address__empty_content' => '清單中尚無電子電郵地址。',
    'ui__server/spam-filter/black-list/address__file_size' => '上傳的文件為空。',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => '下列電子電郵地址無效：%1。',
    'ui__server/spam-filter/black-list/address__none-available' => '垃圾郵件篩檢程式黑名單中尚無地址。',
    'ui__server/spam-filter/black-list/address__short-title' => '地址',
    'ui__server/spam-filter/black-list/address__title' => '黑名單地址%1',
    'ui__server/spam-filter/black-list/address_unknown__description' => '將地址添加到黑名單中。',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => '添加地址',
    'ui__server/spam-filter/black-list/address_unknown__title' => '將地址添加到黑名單中。',

    'ui__server/spam-filter/black-list/address/delete__description' => '從伺服器級黑名單中刪除地址%1。',

    'ui__server/spam-filter/black-list/address/delete__short-title' => '移除',
    'ui__server/spam-filter/black-list/address/delete__title' => '從伺服器級黑名單中刪除地址%1',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => '從伺服器級黑名單中刪除地址。',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => '移除',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => '從伺服器級黑名單中刪除地址',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => '伺服器級垃圾郵件篩檢程式黑名單地址刪除',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => '選擇您要刪除其位址的垃圾郵件篩檢程式，並按一下“下一步 >>”',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => '通過選中核取方塊刪除垃圾郵件篩檢程式位址，按一下“完成”徹底刪除並退出嚮導。',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => '從伺服器級黑名單中刪除地址。',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => '移除',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => '從伺服器級黑名單中刪除地址',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => '伺服器級垃圾郵件篩檢程式黑名單地址刪除',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => '選擇您要刪除其位址的垃圾郵件篩檢程式，並按一下“下一步 >>”',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => '通過選中核取方塊確認刪除垃圾郵件篩檢程式位址，按一下“完成”徹底刪除並退出嚮導。',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => '將僅添加 %1 首個唯一電子電郵地址。',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => '清單中尚無電子電郵地址。',
    'ui__server/spam-filter/black-list/address/properties__file_size' => '無法上傳文件。上傳的文件的最大容量為 %1。',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => '下列電子電郵地址無效：%1。',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => '將地址添加到黑名單中。',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => '添加地址',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => '將地址添加到黑名單中。',

    'ui__server/spam-filter/properties__description' => '設定伺服器級的垃圾郵件篩檢程式。',

    'ui__server/spam-filter/properties__short-title' => '設定',
    'ui__server/spam-filter/properties__title' => '垃圾郵件篩檢程式設定。',

    'ui__server/spam-filter/toggle_disable__description' => '禁用整個系統的垃圾郵件過濾。',

    'ui__server/spam-filter/toggle_disable__short-title' => '禁用',
    'ui__server/spam-filter/toggle_disable__title' => '禁用垃圾郵件過濾',
    'ui__server/spam-filter/toggle_enable__description' => '啟用整個伺服器的垃圾郵件過濾。',

    'ui__server/spam-filter/toggle_enable__short-title' => '啟用',
    'ui__server/spam-filter/toggle_enable__title' => '啟用垃圾郵件過濾',
    'ui__server/spam-filter/toggle_unknown__description' => '啟用或禁用整個伺服器的垃圾郵件過濾。',
    'ui__server/spam-filter/toggle_unknown__short-title' => '啟用或禁用',
    'ui__server/spam-filter/toggle_unknown__title' => '啟用或禁用垃圾郵件過濾',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => '啟用或禁用垃圾郵件篩檢程式',

    'ui__server/spam-filter/white-list__description' => '設定伺服器級的垃圾郵件篩檢程式白名單。',
    'ui__server/spam-filter/white-list__short-title' => '白名單',
    'ui__server/spam-filter/white-list__title' => '伺服器級的垃圾郵件篩檢程式白名單',

    'ui__server/spam-filter/white-list/address__addresses_available' => '將僅添加 %1 首個唯一電子電郵地址。',
    'ui__server/spam-filter/white-list/address__description' => '垃圾郵件篩檢程式的白名單地址。',

    'ui__server/spam-filter/white-list/address__empty_content' => '清單中尚無電子電郵地址。',
    'ui__server/spam-filter/white-list/address__file_size' => '上傳的文件為空。',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => '下列電子電郵地址無效：%1。',
    'ui__server/spam-filter/white-list/address__none-available' => '垃圾郵件篩檢程式伺服器級白名單中尚無地址。',
    'ui__server/spam-filter/white-list/address__short-title' => '地址',
    'ui__server/spam-filter/white-list/address__title' => '白名單地址%1',
    'ui__server/spam-filter/white-list/address_unknown__description' => '將地址添加到白名單中。',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => '添加地址',
    'ui__server/spam-filter/white-list/address_unknown__title' => '將地址添加到白名單中。',

    'ui__server/spam-filter/white-list/address/delete__description' => '從伺服器級的白名單中刪除地址%1。',

    'ui__server/spam-filter/white-list/address/delete__short-title' => '移除',
    'ui__server/spam-filter/white-list/address/delete__title' => '從伺服器級的白名單中刪除地址%1',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => '從伺服器級白名單刪除地址。',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => '移除',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => '從伺服器級白名單刪除地址',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => '伺服器級垃圾郵件篩檢程式白名單地址刪除',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => '選擇您要刪除其位址的垃圾郵件篩檢程式，並按一下“下一步 >>”',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => '通過選中核取方塊刪除垃圾郵件篩檢程式位址，按一下“完成”徹底刪除並退出嚮導。',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => '從伺服器級白名單刪除地址。',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => '移除',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => '從伺服器級白名單刪除地址',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => '伺服器級垃圾郵件篩檢程式白名單地址刪除',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => '選擇您要刪除其位址的垃圾郵件篩檢程式，並按一下“下一步 >>”',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => '通過選中核取方塊確認刪除垃圾郵件篩檢程式位址，按一下“完成”徹底刪除並退出嚮導。',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => '將僅添加 %1 首個唯一電子電郵地址。',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => '清單中尚無電子電郵地址。',
    'ui__server/spam-filter/white-list/address/properties__file_size' => '無法上傳文件。上傳的文件的最大容量為 %1。',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => '下列電子電郵地址無效：%1。',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => '將地址添加到白名單中。',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => '添加地址',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => '將地址添加到白名單中。',

    'ui__server/mail/statistics#apply__description' => "應用篩檢程式",
    'ui__server/mail/statistics#apply__title' => "應用",
    'ui__server/mail/statistics#custom_from__title' => "寄件者",
    'ui__server/mail/statistics#custom_to__title' => "收件人",
    'ui__server/mail/statistics#period_all__title' => "所有",
    'ui__server/mail/statistics#period_custom__title' => "自訂",
    'ui__server/mail/statistics#period_month__title' => "本月",
    'ui__server/mail/statistics#period_prev_month__title' => "上月",
    'ui__server/mail/statistics#period_prev_week__title' => "上周",
    'ui__server/mail/statistics#period_today__title' => "今日",
    'ui__server/mail/statistics#period_week__title' => "本周",
    'ui__server/mail/statistics#period_yesterday__title' => "昨日",
    'ui__server/mail/statistics#show_for_period__title' => "顯示時段",
    'ui__server/mail/statistics#tools_legend__title' => "工具",
    'ui__server/mail/statistics__description' => "查看垃圾郵件和病毒統計資料",

    'ui__server/mail/statistics__short-title' => "統計",
    'ui__server/mail/statistics__title' => "郵件設定",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "垃圾郵件統計",
    'ui__server/mail/statistics/spam#tools_legend__title' => "工具",
    'ui__server/mail/statistics/spam__description' => "查看垃圾郵件統計",

    'ui__server/mail/statistics/spam__short-title' => "垃圾郵件統計",
    'ui__server/mail/statistics/spam__title' => "垃圾郵件統計",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "郵件名",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "按郵件帳戶進行排序",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "按全部%進行排序",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "按所接收的垃圾郵件進行排序",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "郵件帳戶的最大數量",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "所接收的垃圾郵件",
    'ui__server/mail/statistics/spam/recipients__description' => "收件人",

    'ui__server/mail/statistics/spam/recipients__short-title' => "收件人",
    'ui__server/mail/statistics/spam/recipients__title' => "收件人",
    'ui__server/mail/statistics/spam/summary#clean__title' => "未感染病毒",
    'ui__server/mail/statistics/spam/summary#infected__title' => "已感染病毒",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "狀態",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "計數",
    'ui__server/mail/statistics/spam/summary#protected__title' => "受保護",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "未檢查",
    'ui__server/mail/statistics/spam/summary__description' => "匯總",

    'ui__server/mail/statistics/spam/summary__short-title' => "匯總",
    'ui__server/mail/statistics/spam/summary__title' => "匯總",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "病毒統計資料",
    'ui__server/mail/statistics/virus#tools_legend__title' => "工具",
    'ui__server/mail/statistics/virus__description' => "查看病毒統計資料",

    'ui__server/mail/statistics/virus__short-title' => "病毒統計資料",
    'ui__server/mail/statistics/virus__title' => "病毒統計資料",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "郵件帳戶",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "按郵件名進行排序",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "按全部%進行排序",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "按所收病毒進行排序",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "郵件帳戶",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "所收病毒",
    'ui__server/mail/statistics/virus/recipients__description' => "收件人",

    'ui__server/mail/statistics/virus/recipients__short-title' => "收件人",
    'ui__server/mail/statistics/virus/recipients__title' => "收件人",
    'ui__server/mail/statistics/virus/summary#clean__title' => "未感染病毒",
    'ui__server/mail/statistics/virus/summary#infected__title' => "已感染病毒",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "狀態",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "計數",
    'ui__server/mail/statistics/virus/summary#protected__title' => "受保護",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "未檢查",
    'ui__server/mail/statistics/virus/summary__description' => "匯總",

    'ui__server/mail/statistics/virus/summary__short-title' => "匯總",
    'ui__server/mail/statistics/virus/summary__title' => "匯總",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "名稱",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "全部%",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "按名稱進行排序",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "按全部%進行排序",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "按感染對象進行排序",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "病毒",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "感染對象",
    'ui__server/mail/statistics/virus/viruses__description' => "病毒",

    'ui__server/mail/statistics/virus/viruses__short-title' => "病毒",
    'ui__server/mail/statistics/virus/viruses__title' => "病毒",

    'ui__support#param_company__title' => "公司",
    'ui__support#param_email__title' => "電子郵箱",
    'ui__support#param_firstname__title' => "名字",
    'ui__support#param_keynumber__title' => "產品許可證號",
    'ui__support#param_operatingsystem__title' => "作業系統",
    'ui__support#param_phone__title' => "電話",
    'ui__support#param_psabuild__title' => "Plesk 版本號",
    'ui__support#param_psainsttype__title' => "Plesk 安裝類型",
    'ui__support#param_psaversion__title' => "Plesk 版本",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "工具",

    'ui__reseller/traffic-history_unknown__short-title' => "按代理商查看流量",
    'ui__reseller/traffic-history_unknown__title' => "按代理商查看流量",
    'ui__reseller/traffic-history_unknown__description' => "查看代理商帳戶所用流量。",
    'ui__reseller#list__title' => "代理商",
    'accounts_list__name__filter_title' => "名稱",
    'accounts_list__resource__filter_title' => "資源使用量",
    'resellers_list__filter_resource_usage_any' => "任何",
    'resellers_list__filter_resource_usage_overuse' => "超額使用",
    'resellers_list__filter_resource_usage_normal' => "在限制內",
    'accounts_list__status__filter_title' => "狀態",
    'resellers_list__filter_status_any' => "任何",
    'resellers_list__filter_status_blocked' => "掛起",
    'resellers_list__filter_status_active' => "活動",
    'resellers_list__filter_clients__filter_title' => "顯示",
    'resellers_list__filter_clients_on' => "代理商及其客戶",
    'resellers_list__filter_clients_off' => "僅限代理商",
    '__disk_usage' => "所用磁碟空間",
    'ui__reseller/traffic_unknown__short-title' => "按代理商查看流量",
    'ui__reseller/traffic_unknown__title' => "按代理商查看流量",
    'ui__reseller/traffic#list__title' => "查看代理商所用流量",
    'ui__reseller/traffic_unknown__description' => "查看流量使用報告。",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "查看代理商所用流量",

    '__reseller_name' => "代理商名稱",
    '__reseller' => "代理商",
    'resellertrafficlist_header' => "按代理商查看流量",
    '__reseller_personal' => "代理商域名所用的流量",
    'ui__reseller/traffic-history__short-title' => "按代理商查看流量",
    'ui__reseller/traffic-history__title' => "按代理商查看流量",
    'ui__reseller/traffic-history__description' => "查看流量使用報告。",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "允許超額銷售",
    'limits__reseller_oversell_description' => "過度銷售允許代理商售出多於實際分配的資源。如果允許過度銷售，則代理商可以使用實際的資源量，而不是開始時所分配的資源量。",
    'limits__overuse_block_text' => "超額使用策略",
    'limits__overuse_block_true_text' => "不允許超額使用",
    'limits__reseller_overuse_block_true_description' => "阻止超額使用資源。真正使用的資源則無法超出所分配的資源",
    'limits__overuse_block_false_text' => "允許超額使用",
    'limits__reseller_overuse_block_false_description' => "請不要阻止超額使用資源，允許代理商使用多於初始分配的資源。真正使用的資源可以超出初始分配的資源。",
    'limits__reseller_overuse_notify_text' => "達到資源限制時，通知代理商",
    'reseller_perm__manage_sh_access_disabled' => "代理商無法允許或禁止shell存取",
    'reseller_perm__manage_sh_access_chrooted' => "代理商僅可以允許存取更改根檔案系統的環境",
    'reseller_perm__manage_sh_access_any' => "代理商可以允許任何類型的shell存取",
    'template__reseller_num_excl_ips' => "分配獨立 IP 位址給代理商",

    // Reseller's Home page
    'client_chown__no_clients_selected' => '請選擇希望分配給其新所有者的客戶帳戶。',
    'ui__reseller#tools2__title' => "帳戶",
    'ui__reseller#info__title' => "信息",
    'ui__reseller#clientsTab__title' => "客戶",
    'ui__reseller#domainsTab__title' => "域名",
    'ui__reseller__title' => "管理%1代理商帳戶",
    'domains__reseller_info' => "%1 個客戶，%2 個域名，已使用 %3 磁碟空間，已遷移 %4 數據。",
    'domains__reseller_info_hiding_traffic' => "%1 個客戶，%2 個域名，已使用 %3 磁碟空間。",
    'ui__reseller__description' => "管理%1代理商帳戶。",

    'ui__reseller/limits_unknown__wizard-title' => '查看或更改代理商資源限制',
    'ui__reseller/limits_unknown__wizard__1_unknown' => '選擇所需的代理商。',
    'ui__reseller/limits_unknown__wizard__2' => '要應用更改，按一下“完成”。',

    'ui__client/report_reseller__short-title' => "報告",
    'ui__client/report_reseller__title' => "查看帳戶報告",
    'ui__client/report_reseller__description' => "查看代理商帳戶報告。",
    'ui__client/ip-pool_reseller__short-title' => "IP池",
    'ui__client/ip-pool_reseller__description' => "分配 IP 位址和 SSL/TLS 證書給代理商帳戶。",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "指定帳戶設定，並按一下“完成”。",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => '查看或更改代理商的許可權',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => '選擇要查看或更改其許可權的代理商。',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => '更改代理商許可權後，按一下“完成”應用更改，並退出嚮導。',

    // Customers > create customer account

    '__resellers_list' => '代理商',
    'picker_reseller__title' => '選擇代理商',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "工具",
    'ui__client#tools2__title' => "帳戶",
    'ui__client#info__title' => "信息",
    'ui__client#clientslist__title' => "客戶",
    'ui__client#domainslist__title' => "域名",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "所有web應用程式現按類別進行排序，這會便於正確選擇待安裝的應用程式。",
    'feature__domainkeys__reseller' => "您可以使用 DKIM 電子郵件寄件者驗證機制來減少垃圾郵件和釣魚郵件的數量。",

    '__reseller_form' => "代理商表單",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "選擇要更改其設定的客戶帳戶。",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "若要更改資源使用限制，按一下“資源限制”。",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "要更改客戶可在 Plesk 中執行操作的許可權，請點按 許可權。",

    // Reseller's session in the control panel - Home page > Create Domain
    'ui__client/domain/properties_new__wizard__reseller' => "若要創建屬於您個人帳戶的域名，按一下“創建域名”。若要創建客戶域名，按一下相應的客戶名，然後按一下“創建域名”。",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "讓其他使用者可以使用此範本",
    'template__shared_description' => "若允許客戶使用此範本，請選擇此選項。",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => '工具',

    'ui__client/traffic-history_unknown__short-title' => '客戶所用流量',
    'ui__client/traffic-history_unknown__title' => '客戶所用流量',
    'ui__client/traffic-history_unknown__description' => '查看所有客戶的流量使用報告',
    'ui__client/traffic-history__short-title' => '客戶所用流量',
    'ui__client/traffic-history__title' => '客戶所用流量',
    'ui__client/traffic-history__description' => '查看所有客戶的流量使用報告',

    'ui__client/traffic#list__title' => '客戶所用流量',
    'ui__reseller/client/traffic#list__title' => '客戶所用流量',

    'clients_list__filter_type__filter_title' => '顯示',
    'clients_list__filter_type_any' => '客戶與代理商',
    'clients_list__filter_type_clients' => '僅限客戶',
    'clients_list__filter_type_resellers' => '僅限代理商',
    'ui__client/domain_unknown-new__short-title' => "創建域名",

    // Customers > View traffic by customers
    '__personal' => "代理商域名所用流量",
    'PersonalTrafficList_header_of_client__' => "查看帳戶的流量使用報告",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "域名管理員無法允許或禁止shell存取",
    'domain_perm__manage_sh_access_chrooted' => "域名管理員僅可以允許存取改變根檔案系統的環境",
    'domain_perm__manage_sh_access_any' => "域名管理員可以運行任何類型的shell存取",

    // APS Catalog
    'bt_add_to_vault' => "添加到百寶箱",
    'bt_hide_updates' => "隱藏可用更新",
    'bt_show_updates' => "顯示可用更新",

    '__site_apps__applications' => "應用程式",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "選擇待添加到百寶箱中的應用程式",
    'site_apps__application_selected' => "所選項",
    'site_apps__currently_in_vault' => "其他版本已在百寶箱中:",
    'site_apps__new_versions' => "新版本:",
    'site_apps__patches' => "補丁:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "排程添加到百寶箱中的應用程式數量: %1",
    'site_apps__applications_downloading_now' => "即將下載下列應用程式: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "已在百寶箱中",

    // Server > Action Log
    'bt_skin_edit' => "編輯外觀描述",
    'domains__you_want_change_the_status_of_the_reseller??' => "您確定要更改此代理商帳戶的狀態嗎？",
    'limits__oversell_legend' => "過度銷售",
    'limitsManager__limit_available_error' => "無法分配所需資源量(%%quantity%% %%limitName%%)。僅有%%available%% %%limitName%%可用。",
    'limitsManager__limit_reserved_error' => "無法設定要求的資源使用限制(%%quantity%% %%limitName%%)，因新值小於為客戶保留的或自用的資源量(%%reserved%% %%limitName%%)。",
    'limitsManager__limit_used_error' => "無法設定要求的資源使用限制(%%quantity%% %%limitName%%)，因新值小於您的客戶和網站實際使用的資源量(%%used%% %%limitName%%)。",

    'ui__client/domain/traffic#list__title' => "服務所用流量",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "查看流量使用報告",
    'ui__client/domain/traffic_unknown-reseller__title' => "查看流量使用報告",

    'ui__client/domain_new__short-title' => "創建域名",

    'ui__client_reseller__description' => "管理代理商帳戶%1。",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "管理代理商帳戶",

    '__owner_name' => "所有者名稱",
    'domains_list__resource__filter_title' => "資源使用量",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS應用程式目錄",
    'site_apps__applications_have_updates' => "下列應用程式的更新版本可用: \n%1 \n若要查看更新，請確定搜尋區可用，並勾選<b>僅顯示更新</b>核取方塊，並搜尋所需的應用程式。",
    'site_apps__progress_adding_to_vault' => "添加到百寶箱:",
    'site_apps__progress_done_message' => "進度:",
    'site_apps__progress_applications_left' => "共 %2 個應用程式剩下 %1 個",
    'site_apps__download_item_long_task_title' => "下載APS應用程式(%1)",
    'site_apps__download_transaction_long_task_title' => "從APS目錄下載APS應用程式",
    'site_apps__last_check_for_updates' => "上次檢查更新: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "成功添加所有排程的應用程式到應用百寶箱中",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "成功添加%1排程應用程式到應用百寶箱。",
    'site_apps__no_search_results' => '未找到應用程式。請嘗試不同的搜尋請求，或按類別流覽應用程式。',
    'site_apps__search_results_title' => '搜索結果',
    '__site_apps__search_by_application' => '應用程式名稱',
    '__site_apps__search_by_vendor' => '廠商',
    '__site_apps__search_by_vendor__all' => '所有代理商',
    '__site_apps__search_by_packager' => '打包者',
    '__site_apps__search_by_certification_level' => '證書級別',
    '__site_apps__search_by_cert__any' => '任何',
    '__site_apps__search_by_cert__silver_and_higher' => '銀牌或更高',
    '__site_apps__search_by_cert__gold_and_higher' => '金牌或更高',
    '__retry' => '重試',
    'site_apps__application_packager_site' => '打包者',
    'site_apps__add_to_pool_message' => "會自動將標記為\"對所有使用者可用\"的應用程式分配給所有享有無限安裝實例的代理商和客戶。僅可以按個人手動分配受限應用程式及其指定數量的安裝給所有代理商和客戶。",
    'site_apps__make_available_for_all' => "讓所選應用程式對所有使用者可用",

    'site_apps__broadcast_app_text' => "會自動將標記為\"對所有使用者可用\"的應用程式分配給所有享有無限安裝實例的代理商和客戶。僅可以按個人手動分配受限應用程式及其指定數量的安裝給所有代理商和客戶。",
    'site_apps__broadcast_app_name' => '讓應用程式對所有使用者可用',

    // User Application Pool per application
    'site_apps__available_clients' => '可用用戶',
    'site_apps__no_more_clients_to_add_to_pool' => '無可供分配此應用程式的使用者帳戶',

    // Installed application instances
    'site_apps__installations' => '安裝',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "域名和IP地址",
    '__assign_ip_address' => "分配IP地址",
    '__switch_on_service' => "啟用服務",
    '__hosting_configuration' => "主機配置",
    '__vrt_hst' => "網站主機",
    '__vrt_hst_hint' => "在此伺服器上託管網站。",
    '__fwd' => "轉發",
    '__web_hosting_settings' => "主機設定",
    '__fwd_hint' => "重定向訪客到另一網站。",
    '__none_hint' => "此刻不要託管網站。",
    '__login_hint' => "此用戶名用於通過FTP存取您的網站",
    '__password_hint' => "此密碼用於通過FTP存取您的網站",
    '__advanced_hosting_setup' => "配置網站高級託管設定",
    '__domain_creation_successful' => "已創建域名。",
    'bt_hosting_settings' => "主機設定",
    '__change_hosting_type' => "更改域名%1的託管類型",
    '__hosting_type_change_warning' => "更改主機類型為轉發時，則會從伺服器上刪除所有相關的檔、目錄和郵件。請確定本地保存有網站和郵件副本。",
    '__current_hosting_type' => "當前託管類型",
    '__new_hosting_type' => "新託管類型",
    '__fwd_settings' => "轉發設定",
    '__fwd_settings_legend' => "轉發設定",
    '__fwd_destination_url' => "目標 URL",
    '__fwd_type' => "轉發類型",
    '__fwd_type_standart' => "不隱藏目標位址的 URL 轉發(位址跳轉)",
    '__fwd_type_standart_hint' => "重定向訪客到另一網站，顯示目標位址，向訪客公開重定向動作。",
    '__fwd_type_frame' => "幀轉發",
    '__fwd_type_frame_hint' => "重定向網站訪客到另一網站，但不向訪客顯示目標位址，讓訪客不知道被重定向。",
    '__hosting_type_template_warning' => "所選主機類型不同於範本中指定的類型。如果繼續，則會忽略所選範本中的虛擬主機設定。您確定要設定所選的主機類型嗎？",

    'ui__client/domain/properties#vrt_hst__title' => "網站主機",
    'ui__client/domain/properties#vrt_hst__description' => "在此伺服器上託管網站",
    'ui__client/domain/properties#fwd__title' => "轉發",
    'ui__client/domain/properties#fwd__description' => "重定向訪客到另一網站。",
    'ui__client/domain/properties#none__title' => "無主機",
    'ui__client/domain/properties#none__description' => "此刻不要託管網站。",

    '__no_resellers_selected' => "您必須選擇至少一個代理商帳戶。",

    'ui__client/logo_unknown__wizard-title' => '設定徽標',
    'ui__client/logo_unknown__wizard__1_unknown' => '請選擇您要更改其徽標屬性的客戶。',
    'ui__client/logo_unknown__wizard__2' => '按一下“完成”應用更改。',
    'ui__client/logo_unknown__wizard__2_self' => '按一下“完成”應用更改。',

    'ui__client/ipaddress/properties_new__short-title' => "添加 IP 地址",
    'ui__client/ipaddress/properties_new__title' => '添加 IP 地址',
    'ui__client/ipaddress/properties_new__description' => "添加IP地址。",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "添加 IP 地址",
    'ui__client/ipaddress/properties_unknown-new__title' => "添加 IP 地址",
    'ui__client/ipaddress/properties_unknown-new__description' => "添加 IP 地址",
    'ui__client/ipaddress/delete_multi__short-title' => "刪除IP地址",
    'ui__client/ipaddress/delete_multi__description' => "刪除IP地址。",
    'ippool_Manager__no_available_ips' => "此IP池中沒有空閒的IP地址。",
    'ippool_Manager__ip_shared' => "共用",
    'ippool_Manager__ip_exclusive' => "獨立",
    'ui__client/ipaddress/properties__title' => "管理IP地址",
    'ui__client/ipaddress/properties__description' => "查看或更改IP位址屬性。",
    'ui__client/ipaddress_unknown-new__title' => "添加 IP 地址",
    'ui__client/ipaddress_unknown-new__short-title' => "添加 IP 地址",
    'ui__client/ipaddress_unknown-new__description' => "添加 IP 地址。",

    'ui__mass-mail#to_resellers_text__title' => "代理商",
    'ui__mass-mail#to_domainusers_text__title' => "域名管理員",
    'ui__mass-email#tools_legend__title' => "工具",
    'ui__mass-email#list_legend__title' => '群發郵件範本',
    'ui__mass-email#template_legend__title' => "範本",
    'ui__mass-email#from_email_text__title' => "來自",
    'ui__mass-email#to_text__title' => '至',
    'ui__mass-email#to_resellers_text__title' => "代理商",
    'ui__mass-email#to_clients_text__title' => "客戶",
    'ui__mass-email#to_domainusers_text__title' => "域名管理員",
    'ui__mass-email#to_admin_text__title' => "Plesk 管理員",
    'ui__mass-email#option_mode_all__title' => "所有",
    'ui__mass-email#option_mode_select__title' => "僅所選項",
    'ui__mass-email#option_mode_except__title' => "除所選外的全部項",
    'ui__mass-email#option_select_template__title' => '---選擇範本---',
    'ui__mass-email#subject_text__title' => "主題",
    'ui__mass-email#body_text__title' => "資訊文本",
    'ui__mass-email#save_as_legend__title' => "另存為範本",
    'ui__mass-email#save_as_text__title' => "保存組合資訊到一個新的範本（名為",
    'ui__reseller/preferences_unknown__wizard-title' => "更改帳戶設定",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "選擇要更改其設定的帳戶，並按一下“下一步”。",
    'ui__reseller/preferences_unknown__wizard__2' => "指定帳戶設定，並按一下“確定”。",
    'ippoolManager__ip_shared' => "共用",
    'ippoolManager__ip_exclusive' => "獨立",

    '__users_list' => "用戶",
    '__users' => "用戶",
    '__user_name' => "用戶名",

    'clientOwnerChanger__wrong_owner_type' => "您僅可以將所選客戶帳戶轉換為代理商帳戶。",
    'clientOwnerChanger__wrong_client_type' => '所選使用者帳戶是代理商帳戶。無法分配新所有者給伺服器管理員持有的代理商帳戶。',
    'ui__client/chowner_multi__description' => "轉換使用者帳戶給另一所有者。",
    'client_chown__clients_list_legend' => "使用者帳戶",
    'client_chown__client_name' => "用戶名",
    'client_chown__old_owner' => "之前所有者",
    'client_chown__limits_legend' => "資源",
    'client_chown__limit_name' => "資源名稱",
    'client_chown__limit_value' => "已分配資源",
    'client_chown__usage_before' => "移交前",
    'client_chown_usage_after' => "移交後",
    'limit__name_max_dom_aliases' => "域名別名",
    'limit__name_max_subftp_users' => "其它 FTP 帳戶",
    'limit__name_max_mssql_db' => "Microsoft SQL Server資料庫",
    'limit__name_max_iis_app_pools' => "IIS 應用程式池",
    'limit__name_max_odbc' => "ODBC 連接",
    'total_mboxes_quota_unsupported' => '郵件伺服器不支援',
    'limit_soft__disk_space' => '達到磁碟空間即通知',
    'limit_soft__max_traffic' => '達到流量即通知',
    'dsr__of_reseller_title' => "域名所用的資源",
    'client_chown__new_owner' => '新的所有者',
    'ui__reseller/to-client__has_clients_warning' => '無法將所選的部分代理商帳戶轉換為客戶帳戶，因已經有客戶訂閱其服務。請刪除此代理商的訂閱客戶，或移給另一代理商。',
    'limitsManager__commit_failed' => "無法更改資源限制。",
    'limitsManager__date_in_past' => "錯誤的過期日%1。",
    'limitsManager__limit_not_supported' => "無法設定資源類型%1的限制。",
    'limitsManager__limit_oversell_inconsistency' => "因過度銷售已停用，無法分配指定的資源量。",
    'limitsManager__limit_overuse_inconsistency' => "資源使用超出定義的限制。",
    'limitsManager__no_resource_available' => "沒有剩下此類 (%%limitName%%) 資源。 請求： %%quantity%%; 可用： %%unused%%.",
    'limitsManager__no_total_resource_available' => "沒有來自服務提供者的可用 (%%limitName%%) 資源。 請求： %%quantity%%; 可用： %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "過期日必須小於或等於%1。",
    'limitsManager__invalid_disk_space_limit' => "磁碟空間量必須小於或等於%1。",
    'limitsManager__invalid_max_traffic_limit' => "流量必須小於或等於%1。",
    'ippoolManager__ip_has_suballocations' => "因IP位址%%ip%%已分配給用戶，無法更改它的類型。IP地址%%ip%%已歸為%%reserved%%IP地址，並已分配給用戶。",
    'ippoolManager__ip_is_already_in_pool' => "此IP地址已分配給用戶。",
    'ippoolManager__ip_is_not_in_pool' => "IP 池中沒有 IP 地址 %%ip%%。",
    'ippoolManager__can_not_allocate_ip' => "IP地址%%ip%%僅可歸類為%%available%%。",
    'ippoolManager__unable_to_set_default_type' => "此IP地址%%ip%% 無法歸類為獨立型。",
    'ippoolManager__ip_used_by_hst_or_frw' => "此IP地址%%ip%%已用於託管。",
    'ippoolManager__active_anon_ftp_on_ip' => "已啟用IP位址%%ip%%的匿名FTP存取",
    'ippoolManager__no_vacant_ips' => "無空閒的IP地址。",
    'ippoolManager__no_available_ips' => "無可用的IP地址。",
    'templates__dublicate_name' => "相同名稱的範本已經存在。請為該範本選擇其它名稱。",
    'cl_perm__client_limits_exceeded' => "指定資源限制值超過主機方案允許的值，或這些值小於網站當前所用的資源。",
    'cl_perm__reseller_limits_exceeded' => "指定資源限制值超過主機方案允許的值，或這些值小於使用者帳戶當前所用的資源。",

    'site_apps__preferences_show_all_versions_title' => "顯示從該類別中檢索的每個應用程式版本的完整清單",
    'site_apps__preferences_show_all_versions_hint' => "如果選擇此選項，則需要在每次打開該類別時花時間檢索各個應用程式的版本。如果不選擇此選項，則只顯示最新版。",
    '__select_user_template' => "基於範本創建使用者帳戶",
    'ip_already_added_to_all_clients' => "此IP地址已分配給所有用戶。",
    'ui__server/ip-address/client/delete#legend__description' => "即將從此系統和使用者的IP池中刪除下列IP位址:",

    'dns__serial_format_timestamp' => "UNIX時間戳記SOA序號格式",
    'dns__serial_format_yyyymmddnn' => "IETF和RIPE推薦的SOA序號格式",
    'site_apps__cancelled_apps' => "您已取消增加下列應用程式: %2",

    'sb_url_is_not_resolved' => 'URL 無法解析: 檢查您的 DNS 設定。URL %1 必須解析成安裝有 Presence Builder 的伺服器IP地址。',

    'ip_addr__is_last_on_interface' => '因IP位址%%ip%%是出現在網路介面上的最後一個IP位址，導致無法刪除。',
    'ip_addr__used_for_current_session' => '因活動會話正使用IP位址%%ip%%，導致無法刪除。',
    'ip_addr__used_for_hosting' => '因主機網站正使用IP位址%%ip%%，導致無法刪除。',
    'ip_addr__is_main' => '因IP位址%%ip%%是網路介面的主IP位址，導致無法刪除。',
    'ip_addr__ip_used_by_message_submission' => '您不可以刪除用於提交郵件的IP位址%%ip%%',

    // RESELLER ACTION LOG

    '__cl_domains' => '客戶域名',
    'excl_ip_num' => '獨立 IP 位址',

    'sb_err_sitebuilder_not_installed' => '未安裝 Presence Builder。',

    '__perm_allow_oversell_can_not_be_revoked' => '不可以撤銷此用戶的過度銷售權，因已分配給該用戶超出可用量的資源，變為過度銷售模式。',
    'limitsManager__invalid_limit_value' => '指定的%%limit_name%%限制值%%value%%錯誤',
    'ip_alias__type' => "IP網址類別型",
    'ip_alias__in_type' => '分配的IP網址類別型',
    'ui__client/ipaddress/delete_multi__title' => '移除IP地址',
    'ui__client/ipaddress/delete#legend__short-title' => '待刪除項目',
    'ui__client/ipaddress/delete#legend__description' => "即將從用戶IP池刪除下列IP地址:",
    'ui__client/ipaddress/delete#nlegend__short-title' => '無法刪除的項目',
    'ui__client/ipaddress/delete#nlegend__description' => '無法刪除下列IP地址:',
    'ui__server/ip-address/delete#legend__description' => '即將從伺服器IP池中刪除下列IP地址:',
    'confirmationForm_default_agreement_text' => '確認操作',
    'confirmationForm_default_confirm_message' => '請確認操作。',
    'limit__max_mn' => '郵件帳戶的最大數量',

    'limits__client_overuse_description' => '超額使用策略會在資源使用超過初始資源配置量時指令 Plesk 如何進行操作。',
    'limits__client_overuse_block_true_description' => '阻止超額使用資源。真正使用的資源則無法超出所分配的資源',
    'limits__client_overuse_block_false_description' => '不阻止超額使用資源，允許客戶使用多於初始分配的資源。真正使用的資源則可以超出初始分配的資源',
    'limits__client_overuse_notify_text' => '達到資源限制時通知客戶',

    'limits__domain_overuse_description' => '超額使用策略會在資源使用超過初始資源配置量時指令 Plesk 如何進行操作。',
    'limits__domain_overuse_block_true_description' => '超額使用策略會在資源超額使用時指令 Plesk 如何進行操作。',
    'limits__domain_overuse_block_false_description' => '不阻止超額使用資源，允許域名使用多於初始分配的資源。真正使用的資源可以超出初始分配的資源',
    'limits__domain_overuse_notify_text' => '達到資源限制時，通知域名所有者',


    'cancel_remove' => '按一下放棄全部更改並返回上一頁。',
    'php_not_installed' => '未安裝PHP',

    'dns__dns_rr_delete' => '待刪除項目',
    'dns__delete_rr' => '即將從DNS區域刪除下列資源記錄:',
    'dns__dns_rr_delete_non_removable' => '無法刪除的項目',
    'dns__non_delete_rr' => '無法刪除下列DNS記錄:',
    'dns__dns_rr_delete_confirm_message' => '確認刪除DNS記錄',

    'site_apps__format_is_unsupported_broadcast_not_set' => '未知的web應用程式格式: web應用程式可能無法安裝或使用。',

    '__php_handler_type_desc' => 'PHP運行方式',
    'sfdk_domain_sign__failed' => '嘗試在域名上啟用通過 DKIM 簽名郵件時出現未定義錯誤。請參考伺服器錯誤日誌瞭解更多資訊。',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Plesk 金鑰更新成功通知',
    'pkey_notify__subj_update_deferral_notification' => 'Plesk 金鑰更新延遲通知',
    'pkey_notify__subj_update_error_notification' => 'Plesk 金鑰更新錯誤通知',
    'pkey_notify__update_successful' => '成功更新%1。',
    'pkey_notify__update_failed_no_more_try' => '無法更新%1。您嘗試發送的許可證無效。此許可證無法再更新。',
    'pkey_notify__update_failed_try_later' => '無法更新 %1：處理您的金鑰時出現一個錯誤。您可以嘗試在 Plesk（工具與設定>授權管理）中手動索取金鑰或讓 Plesk 嘗試在 24 小時內更新金鑰。如果您不想再收到該通知，請從 Plesk 移除該金鑰。',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => '無法禁用伺服器級垃圾郵件過濾。',
    'ui__server/spam-filter/toggle__unable_enable' => '無法啟用伺服器級垃圾郵件過濾',

    // Application vault/ application pool for admin mapping - TEMPORARY

    // report
    'report_auto__recipient_reseller' => '此代理商',
    'report_auto__select_reseller_report_all' => '所有代理商',
    'report_auto__select_reseller_report_client' => '此客戶的所有代理商',
    'report_auto__select_reseller_report_current' => '此代理商',
    'report_auto__select_reseller_report_reseller' => '%1',
    'report_auto__select_client_report_reseller' => '此代理商的所有客戶',
    'report_auto__select_client_report_client' => '此客戶',
    'report_auto__select_client_report_other_reseller' => '%1',
    'report_auto__select_admin_report_all' => '代理商、客戶和域名',

    'rpt_reseller_section_full_domains' => '域名',
    'rpt_reseller_dom_subdomains' => '子域名',
    'rpt_reseller_dom_domain_aliases' => '域名別名',
    'rpt_reseller_dom_postboxes' => '郵箱(MBox)',
    'rpt_reseller_dom_redirects' => '轉發器',
    'rpt_reseller_dom_mail_groups' => '郵件組(MGroup)',
    'rpt_reseller_dom_mail_resps' => '自動回復',
    'rpt_reseller_dom_mail_antispam' => '防垃圾郵件',
    'rpt_reseller_dom_mail_antivirus' => '防病毒程式',
    'rpt_reseller_dom_mail_lists' => '郵寄清單(MList)',
    'rpt_reseller_dom_web_users' => 'web 用戶',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => '客戶',
    '__cl_name' => '客戶名稱',
    '__cl_creation_date' => '創建日',
    '__clients_traffic' => '客戶流量',
    'rpt_reseller_cl_mail_antispam' => '防垃圾郵件',
    'rpt_reseller_cl_mail_antivirus' => '防病毒程式',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => '未安裝 Presence Builder。',
    'sitebuilder_disabled' => '已停用 Presence Builder。',
    'b_sitebuilder_disabled' => '已停用 Presence Builder。',
    'webmail_not_installed' => 'web 郵箱未安裝。',
    'webmail_disabled' => 'web 郵箱服務已停用。',
    'spamassassin_not_installed' => 'SpamAssassin未安裝。',
    // pfu:
    'anonymous_ftp_shared' => '無法設定匿名FTP: 共用的IP網址類別型。',
    'anonymous_ftp_used' => '無法設定匿名FTP: 此IP地址已被另一域名用於匿名FTP服務。',
    'sshterm__not_installed' => 'SSH終端未安裝。',
    'sshterm__empty_shell' => '若要使用終端用戶端，請允許shell存取此域名。',
    // pfw:
    'aspdotnet_not_installed' => '未安裝 ASP.NET',
    'tsclient__not_installed' => '遠程桌面未安裝。',
    'site_builder_no_package' => 'Presence Builder 不可用。請檢查 Presence Builder 是否已安裝，並選為活動元件。',
    'site_builder_not_configured' => '未配置 Presence Builder 。',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => '工具',
    'ui__reseller/client#clientslist__title' => '客戶',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/odbc_unknown__wizard-title' => "設定網站的ODBC資料來源",
    'ui__client/domain/odbc_unknown__wizard__2_unknown' => "選擇要設定其ODBC資料來源的網站。",

    'ui__client/domain/hosting/tsclient_unknown__wizard-title' => "通過遠端桌面存取域名的虛擬主機",
    'ui__client/domain/hosting/tsclient_unknown__wizard__2_unknown' => "選擇要通過遠端桌面存取其虛擬主機的域名。",

    'ui__client/domain/hosting/virtual-directories_unknown__wizard-title' => "管理域名上的虛擬目錄",
    'ui__client/domain/hosting/virtual-directories_unknown__wizard__2_unknown' => "選擇要管理其虛擬目錄的域名。",

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => '管理網站上的虛擬目錄',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "選擇要管理其目錄的網站。",

    'ui__client/domain/hosting/hotlink-protection_unknown__wizard-title' => "為域名設定盜鏈防護",
    'ui__client/domain/hosting/hotlink-protection_unknown__wizard__2_unknown' => "選擇要防止其檔被盜鏈的域名。",

    'ui__client/domain/hosting/php_unknown__wizard-title' => "配置域名的PHP設定",
    'ui__client/domain/hosting/php_unknown__wizard__2_unknown' => "選擇要配置其PHP設定的域名。",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => '設定域名的匿名FTP',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => '選擇您想要為其設定匿名 FTP 的域名。',

    'ui__client/domain/hosting/protected-directories_unknown__wizard-title' => '管理域名上的受密碼保護目錄',
    'ui__client/domain/hosting/protected-directories_unknown__wizard__2_unknown' => '選擇要管理有密碼保護的目錄所在的域名。',




    'ui__client/domain/report/web-stats_unknown__wizard-title' => '查看域名的網站統計',
    'ui__client/domain/report/web-stats_unknown__wizard__2_unknown' => '選擇要查看其網站統計的域名。',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => '設定域名的日誌管理器並查看域名的日誌檔',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => '選擇要設定其日誌管理器並查看其日誌檔的域名。',

    'ui__client/domain/certificate_unknown__wizard-title' => '管理域名的 SSL/TLS 證書',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => '選擇要管理其 SSL/TLS 證書的域名。',

    'ui__client/to-reseller_multi__wizard-title' => '轉換客戶帳戶為代理商帳戶',
    'ui__client/to-reseller_multi__wizard__1_multi' => '選擇要轉換為代理商帳戶的客戶帳戶。',

    'ui__reseller/to-client_multi__wizard-title' => '轉換代理商帳戶為客戶帳戶',
    'ui__reseller/to-client_multi__wizard__1_multi' => '選擇要轉換為客戶帳戶的代理商帳戶。',

    'ui__client/domain/properties_new__wizard__2/hosting/setup' => '指定域名的主機設定。',







    'ui__client/domain/disable_multi__wizard-title' => '掛起域名',
    'ui__client/domain/disable_multi__wizard__2_multi' => '選擇要掛起的域名。',

    'ui__client/domain/enable_multi__wizard-title' => '啟動域名',
    'ui__client/domain/enable_multi__wizard__2_multi' => '選擇要啟動的域名。',

    'ui__client/domain_unknown__wizard-title' => '查看域名',
    'ui__client/domain_unknown__wizard__1_unknown' => '選擇要查看其域名的客戶。',

    'ui__client/domain/to-client_multi__wizard-title' => '轉換域名管理員帳戶為客戶帳戶',
    'ui__client/domain/to-client_multi__wizard__2_multi' => '選擇要將其管理員帳戶轉換為客戶帳戶的域名',

    'ui__client/domain/register_unknown__wizard-title' => '註冊域名',
    'ui__client/domain/register_unknown__wizard__2_unknown' => '選擇要註冊的域名。',

    'ui__client/domain/extras_unknown__wizard-title' => '使用來自MyPlesk.com的工具',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => '選擇要使用來自MyPlesk.com的工具管理的域名。',



    'ui__client/domain/hosting/ssh-terminal_unknown__wizard-title' => '通過SSH存取伺服器', // PFU
    'ui__client/domain/hosting/ssh-terminal_unknown__wizard__2_unknown' => '選擇要通過SSH連接其虛擬機的域名。', // PFU

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP地址用戶',
    'ui__server/ip-address/client_unknown__title' => 'IP地址用戶',
    'ui__server/ip-address/client_unknown__description' => 'IP地址%1用戶',

    'disabled_by_admin' => '由伺服器管理員禁用',






    'ui__client/domain/chowner_multi__short-title' => '更改所有權',
    'ui__client/domain/chowner_multi__title' => '更改域名所有權',
    'ui__client/domain/chowner_multi__description' => '更改域名所有權。',

    'ui__client/domain/chowner_multi__wizard__2_multi' => '選擇您要更改其所有權的域名並按一下“下一步 >>”。',
    'ui__client/domain/chowner_unknown__short-title' => '更改所有權',
    'ui__client/domain/chowner_unknown__title' => '更改域名所有權',
    'ui__client/domain/chowner_unknown__description' => '更改域名所有權。',

    'ui__client/domain/chowner_unknown__wizard-title' => '更改域名所有權',


    'ui__client/chowner__short-title' => '更改客戶所有者',
    'ui__client/chowner__title' => '更改客戶帳戶所有者',
    'ui__client/chowner__description' => '分配新所有者給此客戶帳戶',


    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => '尚無自訂按鈕。',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => '在代理商 %1 的介面中沒有自訂按鈕。',

    'ui__reseller/custom-buttons/custom-button/delete__description' => '刪除按鈕%1。',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => '移除',
    'ui__reseller/custom-buttons/custom-button/delete__title' => '刪除按鈕%1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => '請從代理商的介面移除自訂按鈕',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => '移除',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => '刪除自訂按鈕',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => '刪除按鈕',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => '選擇要刪除其自訂按鈕的代理商，並按一下"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => '選擇您要刪除的按鈕，並按一下“下一步 >>”。',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => '通過選中螢幕上的核取方塊確認刪除該按鈕，並按一下“完成”。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => '請從代理商的介面移除一個自訂按鈕。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => '移除',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => '刪除自訂按鈕',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => '刪除自訂按鈕',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => '選擇要刪除其自訂按鈕的代理商，並按一下"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => '選擇要刪除的自訂按鈕，並按一下“下一步 >>”。',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => '通過選中螢幕上的核取方塊來確認刪除自訂按鈕，並按一下“完成”。',

    'ui__reseller/custom-buttons/custom-button/properties__description' => '編輯代理商級自訂按鈕%1屬性。',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => '設定',
    'ui__reseller/custom-buttons/custom-button/properties__title' => '修改代理商自訂按鈕%1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => '添加自訂按鈕',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => '請選定您想要在其介面中創建自訂按鈕的的代理商並點按下一步 >>。',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => '按一下“完成”創建按鈕。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => '請在代理商介面中修改按鈕許可權。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => '屬性',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => '請在代理商介面中修改按鈕許可權',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => '更改自訂按鈕屬性',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => '選擇要修改其自訂按鈕的代理商，並按一下"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => '選擇要修改的自訂按鈕，並按一下“下一步 >>”。',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => '完成編輯按鈕屬性之後，請按一下“完成”應用更改並退出嚮導。',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => '使得按鈕%1對您的客戶不可用。',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => '對您的客戶不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => '使得按鈕%1對您的客戶不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => '設定按鈕%1對代理商客戶可見。',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => '對您的客戶可用',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => '設定按鈕%1對代理商客戶可見',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => '使得自訂按鈕對您的客戶可用/不可用。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => '對您的客戶可用/不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => '使得自訂按鈕對您的客戶可用/不可用',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => '使得自訂按鈕對您的客戶可用/不可用。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => '選擇要設定其自訂按鈕對代理商客戶可用的代理商，並按一下"下一步 >>"。',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => '選擇您要使其對您的客戶可用或不可用的自訂按鈕，並按一下“下一步 >>”。',




    'ui__server/ip-addresses__short-title' => 'IP地址',
    'ui__server/ip-addresses__title' => 'IP地址管理',
    'ui__server/ip-addresses__description' => '添加、刪除和分配IP地址。',

    'ip_ctrl__allow_ftps' => '允許 FTP over SSL/TLS',
    '__ftps' => 'FTP over SSL/TLS',
    '__not_allowed' => '不允許',



    'ui__client/ipaddress/domain_unknown__short-title' => '使用%2的域名',
    'ui__client/ipaddress/domain_unknown__title' => '使用%1 IP位址%2的域名',
    'ui__client/ipaddress/domain_unknown__description' => '查看使用 %1 IP位址 %2 的域名列表',

    'ui__client/ipaddress__none-available' => '無可用的IP地址',
    'ui__client/ipaddress__none-available__1' => '無可用的IP地址',



    'ui__client/domain/report_unknown__wizard-title' => '查看域名報告',
    'ui__client/domain/report_unknown__wizard__2_unknown' => '選擇要查看其報告的域名。',


    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => '選擇域名的新所有者。',

    'ui__client/chowner__wizard__2_select' => '選擇客戶帳戶的新所有者。',

    '__ip_addr_state_unknown' => "因系統仍在處理您的請求，導致IP位址無法運行。請稍候。",


    'resellers_list__accounts' => '用戶',

    'ip_addr__repair_is_not_allowed' => '無法修復Virtuozzo環境下的IP地址。',

    'ui__reseller/client__none-available__1' => '代理商%1無客戶。',

    'ippoolManager__ip_used_by_nohost_domain' => "因一或多個無主機的域名使用 IP 位址 %%ip%%，導致無法移除該地址。",
    'ippoolManager__ip_used_for_mail_service' => "因 IP 位址 %%ip%% 被一個或多個域名用於其郵件服務 IP 位址而不能被移除。",
    'ippoolManager__ip_used_for_send_emails' => "IP 位址 %%ip%% 因被用於從指定 IP 發送電子郵件而不能被移除（請查看郵件伺服器設定）。",
    'ippoolManager__ip_used_in_dns_zone' => '因一或多個域名的DNS區域使用IP位址%%ip%%，導致無法刪除該地址。',
    'ip_ctrl__cannot_manage_on_vz' => '正在 Virtuozzo 容器下安裝 Plesk 。只有 Virtuozzo 容器節點管理員才能添加新的 IP 位址。',

    'client_template__limits_auto_adjusted' => '已自動調整來自客戶範本的限制。',

    '__entries' => '項目',

    '__path_is_not_set' => '未指定此路徑。請指定有效路徑。',

    // license keys
    'key_new_plesk_key_is_uploaded' => '新的 Plesk 金鑰已被上傳。',
    'key_new_additional_key_is_uploaded' => '新附加許可證已上傳',

    'defaultcomponents__imap_required' => '(當前郵件伺服器不支援IMAP)',
    'defaultcomponents__php_required' => '(PHP未安裝)',

    // Hotlink protection conhelp // PFW
    'i_hotlinkprotection_on' => '此域名的盜鏈防護功能已啟用。',
    'i_hotlinkprotection_off' => '此域名的盜鏈防護功能已停用。',

    '__commercial_web_stats_not_installed' => 'Plesk 僅支援使用商業網站統計軟體用於子域名的統計計算。目前系統中還未安裝此類軟體。',

    'mail__spamassassin_personal_settings_disallowed' => '伺服器管理員已禁止使用個人垃圾郵件過濾設定。不會應用下面指定的垃圾郵件過濾設定。',

    // CLI keys, should be moved to separate file after 9.0
    'cu__unable_create_object' => '無法創建%1對象：%2',
    'cu_dom_pref__invalid_expiration_date' => '過期日無效: %1',
    'cu_cl_pref__illegal_date_val' => '您指定的日期值無效("%1")',
    'cu_cl_pref__illegal_date_greater_less' => '輸入從“%1”到“%2”的年份',
    'cu_initconf__unable_set_ip_alias_type' => '無法設定 IP 別名類型：%1',
    'cu_mlist__unable_change_status' => "無法更改郵寄清單狀態：%1",
    'cu_initconf__unable_change_passwd' => "無法更改管理員密碼：%1",
    'cu_serverpref__option_description_include_remote_databases' => '把遠端的 MySQL 資料庫計算在磁碟空間使用內。',
    'cu_siteapp_item__add_to_pool_success' => 'Web應用程式已添加到web應用程式池。',
    'cu_siteapp_item__remove_from_pool_success' => 'Web應用程式已從web應用程式池移除。',
    'cu_traffic_command_description_add_user' => '若已被客戶/代理商使用，則註冊指定量的流量',
    'cu_traffic_command_description_sub_user' => '若已被客戶/代理商使用，則從總流量中減去指定量',
    'cu_traffic_command_description_add_batch_user' => '註冊指定流量，就像已被客戶/代理商使用(批量模式)',
    'cu_traffic_command_description_del_user' => '重置此客戶/代理商的註冊流量為零',
    'cu_resellerpref__option_lock_screen' => '請阻止使用者在介面螢幕完全載入之前使用 Plesk 。',
];