<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Subnät eller IP-adress',
    'access-network.subnetOrIpAddressHint' => 'Till exempel, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Nyhetsbrev',
    'admin.announcement-settings.getConsentLoading' => 'Hämtar information om nyhetsbrev...',
    'admin.announcement-settings.getConsentWarning' => 'Kunde inte hämta din prenumerationsstatus.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Jag vill få nyhetsbrev från Plesk. De kan innehålla säkerhetsrelaterad, teknisk och allmän produktinformation. Jag godkänner och auktoriserar Plesk att samla, bearbeta och använda mina personuppgifter (e-postadress), inklusive gränsöverskridande bearbetning, i enlighet med gällande lagstiftning om sekretess som för närvarande gäller för att skicka mig nyhetsbrev, antingen direkt eller via en tredjeparts tjänst. Genom att avmarkera den här kryssrutan återkallar jag mitt samtycke och beordrar Plesk för att sluta skicka mig e-postmeddelanden och permanent ta bort mina personuppgifter från sina system.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Ja tack, jag accepterar att ta emot mitt personliga Plesk-nyhetsbrev. Plesk International GmbH och dess dotterbolag kan lagra och behandla de uppgifter jag tillhandahåller för att leverera nyhetsbrevet i enligt med %%privacyPolicy%%. För att skräddarsy meddelanden och erbjudanden till mig kan Plesk också använda övrig information för att skapa min profil, som användnings- och beteendedata. Jag kan när som helst avsluta prenumerationen på e-postlistan (-orna).',
    'admin.announcement-settings.privacyPolicy' => 'Plesk Sekretesspolicy',
    'admin.announcement-settings.noConsent' => 'Avsluta min prenumeration på Plesks nyhetsbrev.',
    'admin.announcement-settings.reportConsentError' => 'Kunde inte spara dina inställningar för att ta emot information från Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'Vi kan tyvärr inte uppdatera din profil just nu. Försök igen senare.',
    'admin.announcement-settings.invalidConsentType' => "Okänd typ: '%%type%%'",
    'admin.announcement-settings.retry' => 'Försök igen',
    'admin.announcement-settings.consentGivenInfo' => 'Vi hoppas att du har gillat vårt allmänna Plesk-nyhetsbrev. Vi kan nu ge dig ett ännu bättre personligt alternativ med bra information och praktiska tips, beroende på dina behov. För att få ditt personliga Plesk-nyhetsbrev väljer du det första påståendet nedan och klickar på OK.',
    'admin.announcement-settings.consentNotGivenInfo' => 'Det verkar som om du inte prenumererar på vårt allmänna nyhetsbrev. Vi kan ge dig ett bättre alternativ - ett personligt nyhetsbrev med bra information och tips enligt dina behov.',

    'admin.personal-info.title' => 'Redigera administratörsprofil',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk inställningar',
    'admin.personal-info.settingsSectionLegend' => 'Inställningar',

    'admin-alias.login' => 'Användarnamn',
    'admin-alias.password' => 'Lösenord',
    'admin-alias.passwordConfirmation' => 'Bekräfta lösenord',
    'admin-alias.email' => 'E-post',
    'admin-alias.contact' => 'Kontakt namn',
    'admin-alias.comments' => 'Kommentarer',
    'admin-alias.emptyLogin' => 'Ange ett användarnamn.',
    'admin-alias.loginTooLong' => 'Användarnamnets längd överstiger 20 tecken.',
    'admin-alias.emptyEmail' => 'Ange en e-postadress.',
    'admin-alias.emptyContactName' => 'Ange ett kontaktnamn.',
    'admin-alias.contactNameTooLong' => 'Kontaktens namn längd överstiger 255 tecken.',
    'admin-alias.emptyPassword' => 'Ange ett lösenord.',
    'admin-alias.commentsTooLong' => 'Kommentarens längd överstiger 255 tecken.',
    'admin-alias.emailActivation' => 'Aktivera kontot via e-post',
    'admin-alias.simplePanel' => 'Aktivera begränsat läge',
    'admin-alias.simplePanelHint' => 'Välj detta alternativ för att begränsa antalet åtgärder som den extra administratören kan vidta i Plesk. För att ändra åtgärderna som är tillgängliga, gå till %%link%%.',
    'admin-alias.simplePanelLink' => 'Verktyg & inställningar> Inställningar för begränsat läge',
    'admin-alias.lockPowerUser' => 'Force Power User-vy för ytterligare administratör',
    'admin-alias.lockPowerUserHint' => 'Förmåga att begränsa visningen till extra Plesk-administratör (ingen tillgång för kunder, återförsäljare och serviceplaner).',

    'admin-info.plesk-settings.multiplyLogin' => 'TIllåt flera sessioner med detta konto',
    'admin-info.plesk-settings.adminLanguage' => 'Administratörens gränssnittsspråk',
    'admin-info.plesk-settings.password' => 'Lösenord',
    'admin-info.plesk-settings.passwordConfirmation' => 'Bekräfta lösenord',

    'admin-panel.form.contact-info.contactName' => 'Kontakt namn',
    'admin-panel.form.contact-info.emptyContactName' => 'Ange ett kontaktnamn.',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Kontaktnamnet är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.email' => 'E-postadress',
    'admin-panel.form.contact-info.emptyEmail' => 'Ange en e-postadress.',
    'admin-panel.form.contact-info.companyName' => 'Företagsnamn',
    'admin-panel.form.contact-info.longCompanyName' => 'Detta företagsnamn är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.phone' => 'Telefonnummer',
    'admin-panel.form.contact-info.longPhone' => 'Detta telefonnummer är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.fax' => 'Faxnummer',
    'admin-panel.form.contact-info.imNumber' => 'Snabbmeddelande',
    'admin-panel.form.contact-info.longFax' => 'Detta faxnummer är för långt (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Det angivna telefonnumret är ogiltigt.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Detta faxnummer är felaktigt.',
    'admin-panel.form.contact-info.address' => 'Adress',
    'admin-panel.form.contact-info.longAddress' => 'Denna adress är för lång (maximalt %max% tecken är tillåtet).',
    'admin-panel.form.contact-info.city' => 'Stad',
    'admin-panel.form.contact-info.longCity' => 'Stadens namn är för långt.',
    'admin-panel.form.contact-info.shortCity' => 'Stadens namn är för kort.',
    'admin-panel.form.contact-info.state' => 'Län',
    'admin-panel.form.contact-info.postalCode' => 'Postnummer',
    'admin-panel.form.contact-info.country' => 'Land',
    'admin-panel.form.contact-info.additionalInfo' => 'Ytterligare information',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Endast oformaterad text: Alla HTML-taggar kommer att ignoreras.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Användare med en sådan e-postadress finns redan i systemet.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Abonnemang',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Egenskaperna för webbplatsen tillhandahålls tillsammans med abonnemanget.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Egenskaperna för webbplatsen tillhandahålls tillsammans med abonnemanget.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Egenskaperna för webbplatsen tillhandahålls tillsammans med abonnemanget.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Skapa abonnemang för kunden',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Avmarkera denna kryssruta om du inte vill skapa ett värdtjänsttjänstabonnemang eller ställa in en webbplats för kunden just nu. Utan ett abonnemang, kommer kunden inte att kunna logga in till Kundpanelen.',
    'admin-panel.form.domain-info-section.domainName' => 'Domännamn',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Du  måste ange ett domännamn.',
    'admin-panel.form.domain-info-section.shared' => 'delad',
    'admin-panel.form.domain-info-section.exclusive' => 'dedikerad',
    'admin-panel.form.domain-info-section.userName' => 'Användarnamn',
    'admin-panel.form.domain-info-section.userNameHint' => 'Systemets användarkonto används för att hantera filer och mappar på webbplatserna som skapas inom abonnemanget.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Du  måste ange ett användarnamn.',
    'admin-panel.form.domain-info-section.password' => 'Lösenord',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Du måste ange ett lösenord.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Bekräfta lösenord',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4-adress',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "IP-adressen som webbplatsen finns på är en nätverksadress för webbplatsens virtuella värd.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6-adress',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Ingen',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Ytterligare prenumerationsinställningar',
    'admin-panel.form.domain-info-section.credentials' => 'Uppgifter för systemanvändare',
    'admin-panel.form.domain-info-section.credentialsHint' => 'för åtkomst till hostade filer över FTP och SSH',

    'admin-panel.form.login-info.userName' => 'Användarnamn',
    'admin-panel.form.login-info.emptyUserName' => 'Ange ett användarnamn.',
    'admin-panel.form.login-info.password' => 'Lösenord',
    'admin-panel.form.login-info.emptyPassword' => 'Ange ett lösenord.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Upprepa lösenordet',
    'admin-panel.form.login-info.emailActivation' => 'Aktivera kontot via e-post',
    'admin-panel.form.login-info.emailActivationHint' => 'Ett skapat konto är inaktivt tills användaren aktiverar den med länken skickad via e-post eller administratören aktiverar kontot manuellt.',

    'admin-panel.form.subscription-info-section.subscription' => 'Abonnemang',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Tjänsteplan',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Aktuell serviceplan',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Ny serviceplan',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Enkel plan',
    'admin-panel.form.subscription-info-section.none' => 'Ingen',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Tillägg',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'Sätt igång med anpassning av parametrarna för abonnemanget efter att planets associering har ändrats. Observera att när du gör det, låser sig abonnemanget för synkronisering.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'Anpassa parametrarna för prenumerationen efter att den skapats.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "Proceed to customizing the subscription parameters after the customer is created.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'Fortsätt med att anpassa abonnemangsparametrarna efter skapandet. Observera att när du gör det, låser sig abonnemanget för synkronisering.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Observera att det kommer låsa prenumerationen för synkning.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Lägg till Abonnemang',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'app.configure.otherSettings' => 'Övrigt',
    'app.configure.passwordConfirmation' => 'Bekräfta lösenord',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Framtvinga uppdateringar för alla installerade appar',
    'app.update-settings.forceUpdatesHint' => 'Alla kunders appar uppdateras automatiskt så snart uppdateringarna är tillgängliga. Kunderna kommer inte att kunna stänga av autoamtiska uppdateringar för sina appar. Varning: Använd detta alternativ försiktigt eftersom uppdateringar märkbart kan påverka app-funktionaliteten. Exempelvis kan app-tillägg sluta fungera med en annan version av appen.',
    'app.update-settings.suggestUpdates' => 'Aktivera alternativet "Uppdatera automatiskt denna app" som standard',
    'app.update-settings.suggestUpdatesHint' => 'För nyligen installerade appar, kommer alternativet "Uppdatera automatiskt denna app" i appens inställningar att slås på.',

    'backup.server-settings.rotation' => 'Maxialt antal fullständiga säkerhetskopierignsfiler för att lagra (inklusive schemalagda och manuella säkerhetskopior)',
    'backup.server-settings.rotationDescription' => 'Användare kan lagra många fullständiga säkerhetskopior o serverlagringsutrymmet. Om antalet fullständiga säkerhetskopior i lagret redan överstiger gränsvärdet, kommer endast de sista säkerhetskopiorna att behållas. Inkrementella säkerhetskopior påverkas inte.',
    'backup.server-settings.maxProcesses' => 'Maximalt antal samtidigt körande schemalagda säkerhetskopieringsprocesser',
    'backup.server-settings.niceScheduled' => 'Kör schemalagda säkerhetskopieringsprocesser med låg prioritet',
    'backup.server-settings.niceScheduledPriority' => 'Prioritet',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Ange ett värde mellan 1 och 19 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.niceScheduledIoPriority' => 'IO prioritet',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Ange ett värde mellan 0 och 7 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.niceAlways' => 'Kör alla säkerhetskopieringsprocesser med låg prioritet',
    'backup.server-settings.niceAlwaysPriority' => 'Prioritet',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Ange ett värde mellan 1 och 19 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO prioritet',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Ange ett värde mellan 0 och 7 där en högre siffra avser lägre prioritet.',
    'backup.server-settings.noCompression' => 'Komprimera inte säkerhetskopior',
    'backup.server-settings.freeSpaceRequired' => 'Starta säkerhetskopieringen endast om servern har den angivna mängden ledigt diskutrymme (i MB)',
    'backup.server-settings.checkBackupDiskSpace' => 'Starta säkerhetskopieringen endast om servern har den angivna mängden ledigt diskutrymme',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Använd den integrerade MS SQL säkerhetskopieringsfunktionen (För fjärrstyrda databaser, se till att du har konfigurerat säkerhetskopieringsinställningarna för den fjärrstyrda MS SQL-servern i Verktyg och inställningar> Databasservrar)',
    'backup.server-settings.localFtpRestriction' => 'Tillåt inställningen av FTP-säkerhetskopiering i den lokala servern',
    'backup.server-settings.backupSecuritySettings' => 'Säkerhetsinställningar för säkerhetskopieringar',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Spara säkerhetskopior i serverlagringen om uppladdningen till fjärrlagringssystemet misslyckas',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Manuell och schemalagd säkerhetskopiering som avses för fjärrlagringen sparas i den lokala serverlagringen om uppladdningen till fjärrlagringen misslyckas. Användare måste ha tillstånd till att lagra säkerhetskopior i serverlagringen.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => 'Kunder som ägs av Admin',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Alla kundkonton som tillhör admin i den föregående versionen av Plesk omvandlades till kundkonton som ägs av admin: (1) Tidigare resurser för varje kund sparades (kan hittas under etiketten \'Mina resurser\' högst upp i kundens abonnemangslista), kommer att tas bort så snart överföringen är klar; (2) Alla domäner som omvandlades till abonnemang (ett nytt abonnemang för varje domän); (3) Domänadministratörer har omvandlats till kundens användare som har åtkomst endast till abonnemanget som innehåller deras domän.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => 'Tidigare kundtillstånd',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => 'Antal kunder',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => 'Övergångsschema',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => 'En domän; justering av gränser har förbjudits.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => 'Nya abonnemangsresurser är lika minimum från den tidigare klientens eller domänens gränser.',
    'business-model-upgrade.bunch.t1s1-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => 'En domän; justering av gränser har tillåtits.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => 'Nya abonnemangsresurser är lika med den tidigare kundens gränser.',
    'business-model-upgrade.bunch.t1s2-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => 'Flera domäner; domänskapande och justering av gränser har förbjudits.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => 'Nya abonnemangsresurser nedärvs av tidigare domängränser.',
    'business-model-upgrade.bunch.t1s3-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => 'Flera domäner; domänskapande och justering av gränser har tillåtits.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => 'Övergång som:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => 'Återförsäljare. En tidigare kund uppgraderas till återförsäljare. Återförsäljarens abonnemangsresurser nedärvs av tidigare klientens gränser. Om domänens administratörskonto har aktiverats för en tidigare domän, uppgraderas den till kundkonto och motsvarande abonnemang associeras med det. Annars tillhör abonnemangen direkt återförsäljaren.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => 'Kund. En tidigare klient förblir kund. Klientresurserna är jämnt fördelade över sina abonnemang.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => 'Återförsäljare',
    'business-model-upgrade.bunch.t1s6c-solutionName' => 'Kunder',
    'business-model-upgrade.bunch.t1s6-apply' => 'Överföring av dessa kunder som',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => 'Kunder som ägs av Återförsäljare',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Alla kundkonton som tillhörde återförsäljaren i Plesk 9 omvandlades till kundkonton som ägs av resåeltove återförsäljare: (1) Tidigare resurser för varje kund sparades (kan hittas under etiketten \'Mina resurser\' högst upp i kundens abonnemangslista), kommer att tas bort så snart överföringen är klar; (2) Alla domäner som omvandlades till abonnemang (ett nytt abonnemang för varje domän); (3) Domänadministratörer har omvandlats till kundens användare som har åtkomst endast till abonnemanget som innehåller deras domän.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => 'Tidigare kundtillstånd',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => 'Antal kunder',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => 'Övergångsschema',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => 'En domän; justering av gränser har förbjudits.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => 'Nya abonnemangsresurser är lika minimum från den tidigare klientens eller domänens gränser.',
    'business-model-upgrade.bunch.t2s1-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => 'En domän; justering av gränser har tillåtits.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => 'Nya abonnemangsresurser är lika med den tidigare kundens gränser.',
    'business-model-upgrade.bunch.t2s2-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => 'Flera domäner; domänskapande och justering av gränser har förbjudits.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => 'Nya abonnemangsresurser nedärvs av tidigare domängränser.',
    'business-model-upgrade.bunch.t2s3-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => 'Flera domäner; domänskapande och justering av gränser har tillåtits.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => 'Klientresurserna är jämnt fördelade över sina abonnemang.',
    'business-model-upgrade.bunch.t2s6-apply' => 'Överföring av dessa kunder',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => 'Abonnemang som ägs av Admin',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Alla domäner som tillhörde admin i en tidigare version av Plesk har konverterats till admins egna abonnemang. Domänadministratörer har omvandlats till Kundpanelanvändare och har åtkomst endast till abonnemangen som innehåller deras domän. Använd de rekommenderade åtgärderna för dessas abonnemangs övergång eller välj ett anpassad övergångsschema för var och en i fliken \'Selektiv överföring av abonnemang\'.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => 'Föregående domän-tillstånd',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => 'Antalet abonnemang',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => 'Övergångsschema',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => 'Domänen tillhörde admin; Domänens administratörskonto har aktiverats.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => 'Den tidigare domänadministratören uppgraderas till kund och blir en abonnent, vilket innebär att abonnemanget tilldelas honom.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => 'Låt dessa abonnemang övergå',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => 'Abonnemang som ägs av Återförsäljare',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Alla domäner som tillhörde återförsäljare i en tidigare version av Plesk omvandlades till återfösäljarnas egna abonnemang med bevarat ägarskap. Domänadministratörer har omvandlats till Kundpanelanvändare och har åtkomst endast till abonnemangen som innehåller deras domän. Använd de rekommenderade åtgärderna för dessas abonnemangs övergång eller välj ett anpassad övergångsschema för var och en i fliken \'Selektiv överföring av abonnemang\'.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => 'Föregående domän-tillstånd',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => 'Antalet abonnemang',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => 'Övergångsschema',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => 'Dmänen tillhörde en återförsäljare; Domänens administratörskonto har aktiverats.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => 'Den tidigare domänadministratören uppgraderas till kund och blir en abonnent, vilket innebär att abonnemanget tilldelas honom.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => 'Låt dessa abonnemang övergå',
    'business-model-upgrade.bunch.thereWereSomeErrors' => 'Vissa av de valda kunderna och abonnemangen har inte överförts.',

    'change-current-subscription.hint' => 'Detta är när du ändrar associeringen med tjänsteplaner för abonnemanget. Observera att om du väljer \'ingen\' som ny tjänsteplan, löses abonnemanget från tjänsteplanen och den blir då \'Anpassad\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'change-password.oldPassword' => 'Gammalt lösenord',
    'change-password.password' => 'Nytt lösenord',
    'change-password.passwordConfirmation' => 'Bekräfta lösenord',
    'change-password.oldPasswordIsIncorrect' => 'Det gamla lösenordet är felaktigt. Försök igen.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Kan inte hitta det extra administratörskontot.',
    'change-password.warningAboutAdminPasswordSyntax' => "Lösenordet ska vara %%min%% - %%max%% tecken långt och ska inte innehålla användarnamnet.\nAnvänd inte citationstecken, mellanslag och nationella alfabetstecken i lösenordet.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Använd inte citationstecken, mellanslag, semikolon och nationella alfabetstecken i lösenordet.\nLösenordet ska vara mellan %%min%% och %%max%% tecken långt, och det ska inte innehålla användarnamnet.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Överförsäljningspolicy',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Överförsäljning är tillåtet',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Översäljning gör att återförsäljaren kan sälja mer resurser än vad som allokeras till dem med en plan. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Överförsäljning är inte tillåtet',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Om översäljning inte tillåts, kan en återförsäljare endast sälja så mycket resurser som till en början tilldelades honom med en plan, oavsett hur mycket dessa resurser för närvarande används.',

    'change-reseller-subscription.hint' => 'Detta är när du ändrar associeringen med tjänsteplaner för återförsäljarens abonnemang. Observera att om du väljer \'ingen\' som ny tjänsteplan, löses abonnemanget från tjänsteplanerna och den blir då \'Anpassad\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Ny plan',
    'change-reseller-subscription.oldSubscription' => 'Aktuell plan',
    'change-reseller-subscription.none' => 'ingen',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Abonnemangets association med tjänsteplanen har uppdaterats.',
    'change-reseller-subscription.customizeSubscription' => 'Fortsätt med anpassningen av abonnemangsparametrarna efter associeringen med tjänsteplanen har uppdaterats. Observera att när du gör det, låser sig abonnemanget för synkronisering.',

    'change-subscription.hint' => 'Detta är när du ändrar associeringen med tjänsteplaner för valda abonnemang.',
    'change-subscription.selectPlanLegend' => 'Tjänsteplan',
    'change-subscription.selectPlanDescription' => 'För att ändra till en annan tjänsteplan, välj den nya planen ur listan. Observera att om du väljer \'ingen\', löses abonnemanget från tjänsteplanen och den blir då \'Anpassad\'.',
    'change-subscription.servicePlan' => 'Ny serviceplan',
    'change-subscription.selectAddonPlansLegend' => 'Tilläggsplaner',
    'change-subscription.selectAddonPlansDescription' => 'Lägg till eller ta bort tilläggsplaner.',
    'change-subscription.noChange' => 'ingen ändring',
    'change-subscription.none' => 'ingen',
    'change-subscription.add' => 'lägg till',
    'change-subscription.del' => 'ta bort',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Subnät eller IP-adress',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Till exempel, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Åtkomst till Plesk med administratörsprivilegier',
    'control-panel-access.settings.policyAllow' => 'Tillåtet, förutom för nätverken i listan.',
    'control-panel-access.settings.policyDeny' => 'Nekas från nätverken som inte är listade.',

    'create-subscription.title' => 'Lägga till ett Abonnemang',
    'create-subscription.titleOwn' => 'Lägga till ditt eget abonnemang',
    'create-subscription.poolIsEmpty' => 'Kan inte skapa en prenumeration eftersom det inte finns några delade IP-adresser och inga lediga dedikerade IP-adresser i Plesk.',
    'create-subscription.infoNewSubscriptionCreated' => 'Abonnemanget %%name%% har skapats.',
    'create-subscription.createBeforeAppInstall' => 'Du behöver en prenumeration för att installera appen.',

    'customer.hint' => 'Det är här du tillför en ny kund till dina värdtjänsttjänster. Med denna inskrivning skapar du ett kundkonto i Plesk och ett abonnemang på en av dina värdtjänstplaner och alternativt tillägg. Abonnemanget kan också tillhandahålla en fullständig anpassad uppsättning resurser och tjänster som int eär bundna till några planer -- för detta väljer du \'Ingen\' bredvid tjänsteplanen.',
    'customer.contactInfoSection' => 'Kontaktinformation',
    'customer.additionalInfoSection' => 'Additional customer information',
    'customer.accessToPanelSection' => 'Åtkomst till Plesk-tjänster',
    'customer.contactInfoSectionHint' => 'Ange kundens kontaktinformation.',
    'customer.accessToPanelSectionHint' => 'Autentiseringsuppgifter som kunden använder för åtkomst till Kundpanelen.',
    'customer.unableCreateSubscription' => 'Abonnemanget kan inte skapas: %%reason%%',
    'customer.poolIsEmpty' => 'IP-poolen är tom',
    'customer.buttonOk' => 'Lägg till kund',

    'database-settings.dbPrefixRadio' => 'Lägg till prefix och understreck till början av databasnamnet',
    'database-settings.dbPrefixNone' => 'Ingen',
    'database-settings.dbPrefixUsername' => 'Användarnamn',
    'database-settings.dbPrefixExternalId' => 'Externt ID för ett abonnemang',
    'database-settings.dbUserPrefix' => 'Lägg till användarnamn och understreck till början av databasanvändarnamnen',
    'database-settings.dbUserPrefixHint' => 'Databasanvändarnamn kommer att se ut som <plesk_username>_<database_user_name>. Till följd av databasbegränsningar av användarnamnslängden, kan <plesk_username> bli förkortat.',
    'database-settings.grantAlterDatabase' => 'Bevilja ALTER DATABASE behörighet till alla Microsoft SQL Server databasanvändare',
    'database-settings.grantAlterDatabaseHint' => 'Nya och befintliga användare kommer att beviljas denna behörighet.',
    'database-settings.enableBackupOperator' => 'Bevilja db_backoperator rollmedlemskapet för alla Microsoft SQL Server databasanvändare',
    'database-settings.enableBackupOperatorHint' => 'Nya och befintliga användare kommer att vara medlem av denna roll.',
    'database-settings.aclRadio' => 'Standardinställningar för fjärråtkomst från databasanvändare',
    'database-settings.aclLocalhost' => 'Tillåt endast lokala anslutningar',
    'database-settings.aclAny' => 'Tillåt fjärranslutningar från valfri värd',
    'database-settings.aclCustom' => 'Tillåt fjärranslutningar från',
    'database-settings.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDe specificerade värdarna tillåtas åtkomst till databasen å vägnar av denna användaren.",
    'database-settings.aclDescription' => 'Den här inställningen ändrar endast användarnas behörigheter. För att aktivera fjärråtkomst till Local MySQL-servern väljer du motsvarande alternativ i <a href="/server/db_server_edit.php?db_server_id=%d">aulas>Lokala MySQL-inställningar</a>.',
    'database-settings.example' => "Till exempel:\n%%example%%",

    'dns.template.synchronize-done' => 'DNS-zonmallen har tillämpats korrekt.',
    'dns.template.synchronize-error' => 'DNS-zonmallen har inte tillämpats för vissa DNS-zoner.',
    'dns.template.synchronize-progress' => 'Tillämpa DNS-zonmallen.',

    'domain-restriction.name' => 'Domännamn',
    'domain-restriction.nameDescription' => 'Du kan ange ett mönster med jokertecken genom att använda asterisk tecknet (*). Exempelvis, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Det angivna domännamnet finns redan i listan.',

    'event-handler.eventLabel' => 'Händelse',
    'event-handler.priorityLabel' => 'Prioritet',
    'event-handler.userLabel' => 'Användare',
    'event-handler.commandLabel' => 'Kommando',
    'event-handler.commandHint' => 'För bäst resultat, ange en fullständig sökväg till en skriptfil i fältet \\’command\\’. Vi rekommenderar att du inte går in i systemkommandona eftersom de kanske inte fungerar. Exempelvis kommer kommandon med operatörer för utgångsomdirigering /&gt; eller &gt; inte att fungera.',
    'event-handler.priorityHighestText' => 'högst',
    'event-handler.priorityHighText' => 'hög',
    'event-handler.priorityNormalText' => 'normal',
    'event-handler.priorityLowText' => 'låg',
    'event-handler.priorityLowestText' => 'lägsta',
    'event-handler.priorityCustomText' => 'anpassad',
    'event-handler.priorityHighestOption' => 'högst (%%value%%)',
    'event-handler.priorityHighOption' => 'hög (%%value%%)',
    'event-handler.priorityNormalOption' => 'normal (%%value%%)',
    'event-handler.priorityLowOption' => 'låg (%%value%%)',
    'event-handler.priorityLowestOption' => 'lägst (%%value%%)',

    'extension.upload.fileUpload' => 'Sökväg till tilläggspaketfilen',

    'external-webmail.hint' => 'När du har registrerat en extra webbmail i Plesk, blir den tillgänglig för dina kunder: den visas som ett alternativ i \'Mail\'-egenskaperna i värdtjänstplanerna och abonnnemangen. Webbmailnamnet kommer att visas i listan över webbmailalternativ, och URL:en kommer att öppnas vid klick på webbmailikonen intill e-postkontot i Kundpanelen.',
    'external-webmail.name' => 'Webbmailens tjänstnamn',
    'external-webmail.url' => 'Webbmailens tjänste-URL',
    'external-webmail.enabled' => 'Tillgänglig',

    'ftp-settings.generalSection' => 'Allmänt',
    'ftp-settings.portRange' => 'Port eller portintervall för anslutningar i passivt FTP-läge',
    'ftp-settings.hintPortRange' => '(standardvärde: %%defaultPortRange%%)',

    'health.upload.hint' => 'Ladda upp din konfiguration av serverns hälsoövervakare. Konfigurationen tillämpas så snart den laddas upp.',
    'health.upload.selectFile' => 'Konfigurationsfil',

    'install-local-package.selectUploadType' => 'Välj något av följande:',
    'install-local-package.uploadAsFile' => 'Ladda upp ett APS-paket',
    'install-local-package.downloadFromCatalog' => 'Markera en app ur Programkatalogen',
    'install-local-package.formInfo' => "Öppna listan över tillgängliga program genom att ladda upp en ny app eller lägg till en app från Programkatalogen för ytterligare konfiguration.",
    'install-local-package.invalidFileExtension' => 'Den uppladdade appen måste vara ett ZIP-arkiv med .zip-tillägget.',
    'install-local-package.packagesNotSelected' => 'Inget av paketen är valt.',
    'install-local-package.visible' => 'Gör den tillgänglig för kunderna',
    'install-local-package.isCommercial' => 'Denna app är kommersiell och kräver köp av en licensnyckel.',
    'install-local-package.visibleDescription' => 'Gör appen tillgänglig för installation av kunderna.',

    'ip-address.generalSection' => 'Allmänt',
    'ip-address.interface' => 'Gränssnitt',
    'ip-address.addressAndSubnetPrefixLength' => 'IP-adress och nätmask',
    'ip-address.publicIp' => 'Offentlig IP-adress',
    'ip-address.hintPublicIp' => 'Du kan använda en offentlig IP-adress om din Plesk-server är bakom NAT',
    'ip-address.distributionType' => 'IP-adressen distribueras som',
    'ip-address.distributionTypeShared' => 'Delad',
    'ip-address.distributionTypeExclusive' => 'Dedikerad',
    'ip-address.certificate' => 'SSL/TLS-certifikat',
    'ip-address.defaultSite' => 'Standardplats',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Den installerade FTP-servern stödjer inte FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Den installerade FTP-servern stödjer inte IPv6-adresser.',
    'ip-address.interfaceDHCPEnabled' => 'Kunde inte reparera IP-adressen. Detta nätverksgränssnitt får IP-adresser automatiskt.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Obs: Anpassad Plesk-URL är aktiverad för alla okända domäner; Plesk-gränssnittet kommer att visas istället för standardgränssnittet på "https://%%ip%%/"',

    'ip-ban.filter.name' => 'Namn',
    'ip-ban.filter.content' => 'Innehåll',
    'ip-ban.filter.filterExistsError' => 'Ett filter med ett sådant namn finns redan.',

    'ip-ban.jail.name' => 'Namn',
    'ip-ban.jail.filter' => 'Filter',
    'ip-ban.jail.filterDescription' => 'Välj filter.',
    'ip-ban.jail.action' => 'Action',
    'ip-ban.jail.actionDescription' => 'Välj en åtgärd och klicka på knappen för att addera den.',
    'ip-ban.jail.logPath' => 'Loggsökväg',
    'ip-ban.jail.banTime' => 'Bannlysningsperiod för IP-adress',
    'ip-ban.jail.maxRetry' => 'Det maximala antalet misslyckade inloggningsförsök',
    'ip-ban.jail.timeUnit' => 'sekunder',
    'ip-ban.jail.addAction' => 'Lägg till',
    'ip-ban.jail.chooseAction' => 'Välj:',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache-auktoriseringsfel (när du loggar in i filen)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache-auktoriseringsfel (eventuell loggning)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache-auktoriseringsfel (när du loggar in i syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'Skräppost sökrobotar och dårliga webbcrawlers',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP och POP3 autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP, POP3, och Sieve autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP, POP3 och Sieve-autentiseringsfel (aggressivt läge)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde webbpost autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Webbsäkerhets- och åtkomstkontrollbrott (Web Security)',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube webbpost autentiseringsmisslyckanden',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress autentiseringsfel',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP-klientfel (inklusive RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP-klientfel, autentiseringsfel och DDoS-attacker',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP och SASL autentiseringsmisslyckanden',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS-attacker',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP-klientfel och autentiseringsfel',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP-klientfel (inklusive RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP-klientfel (endast RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD inloggningsmisslyckanden',
    'ip-ban.jail.recidive-filter-description' => 'Värdar bannlysta upprepade gånger av Fail2Ban',
    'ip-ban.jail.sshd-filter-description' => 'SSH inloggningsmisslyckanden',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH-inloggningsfel, förhandlingsfel och DDoS-attacker',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH-inloggningsfel och DDoS-attacker',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH-inloggnings- och förhandlingsfel',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Bannlysning via firewalld brandvägg, på alla porter',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Bannlysning via firewalld brandvägg, på flera porter',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Bannlysning via firewalld brandvägg, på en enkel port',
    'ip-ban.jail.iptables-action-description' => 'Bannlysning via iptables brandvägg, på en enkel port',
    'ip-ban.jail.iptables-allports-action-description' => 'Bannlysning via iptables brandvägg, på alla porter',
    'ip-ban.jail.iptables-multiport-action-description' => 'Bannlysning via iptables brandvägg, på flera porter',
    'ip-ban.jail.sendmail-action-description' => 'Skicka e-postmeddelanden via sendmail',
    'ip-ban.jail.jailExistsError' => 'Ett fängelse med ett sådant namn finns redan.',
    'ip-ban.jail.invalidInteger' => 'Den angivna värdet är ogiltigt. Specificera ett heltal.',

    'ip-ban.settings.pageHint' => 'Här kan du ställa in bannlysning av IP-adress för att skydda servern din och dina värdbaserade webbplatser från skadlig trafik.',
    'ip-ban.settings.detectionEnabled' => 'Aktivera identifiering av intrång',
    'ip-ban.settings.banPeriod' => 'Bannlysningsperiod för IP-adress',
    'ip-ban.settings.banTimeWindow' => 'Tidsintervall för detektering av upprepade angrepp',
    'ip-ban.settings.maxRetries' => 'Antal misslyckanden för bannlysning av IP-adress',
    'ip-ban.settings.timeUnit' => 'sekunder',
    'ip-ban.settings.invalidInteger' => 'Ett ogiltigt värde har tillhandahållits. Tillhandahåll ett positivt heltal.',

    'ip-ban.trusted-ip.ipAddress' => 'IP-adress',
    'ip-ban.trusted-ip.hintIpAddress' => 'Ange en IP adress, en CIDR mask, eller ett DNS-värdnamn.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => 'Den angivna IP-adress, nätverksadress eller värdnamn är ogiltig.',

    'login-info.hint' => 'Det är här du ändrar användarnamnet och lösenordet som kunden använder för tillgång till Kundanelen.',
    'login-info.resellerHint' => 'Det är här du ändrar användarnamnet och/eller lösenordet som återförsäljaren använder för tillgång till deras Plesk.',
    'login-info.myProfileHint' => 'Det är här du ändrar lösenordet du använder för åtkomst till din Plesk.',

    'mail.lists-server-settings.email' => "E-postlistans administratörspost",
    'mail.lists-server-settings.emptyEmail' => 'Ange en e-postadress.',
    'mail.lists-server-settings.newPassword' => 'Nytt lösenord',
    'mail.lists-server-settings.emptyPassword' => 'Ange ett lösenord.',
    'mail.lists-server-settings.passwordConfirmation' => 'Bekräfta lösenord',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Programvarans e-postlista har konfigurerats.',

    'mail.outgoing-messages.hint' => 'Här kan du specificera en gräns för utgående meddelanden från en postlåda.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Maximalt antal utgående e-postmeddelanden',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'Standard (%%domainOutgoingMessages%% meddelanden per timme)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Anpassat värde för denna postlåda',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'meddelanden per timme',

    'mail-gate-settings.host' => 'Värddatornamn eller IP-adress',
    'mail-gate-settings.port' => 'Port',
    'mail-gate-settings.login' => 'Användarnamn',
    'mail-gate-settings.password' => 'Lösenord',
    'mail-gate-settings.encryption' => 'SMTP-servern kräver krypterad anslutning',
    'mail-gate-settings.allowUsers' => 'Tillåt användarskript skicka e-post via denna SMTP-server (genom att använda det angivna användarnamnet och lösenordet)',
    'mail-gate-settings.useDefaultSettings' => 'Använd e-post servern installerad med Plesk och standard e-postkontot skapad av Plesk',

    'mail-gate.hint' => 'Här kan du specificera SMTP-servern som ska användas när Plesks e-postserver inte har instalelrats eller är blockerad för att skicka utgående e-post. Denna server används som ett SMTP-relä av Plesk och användarskript för att skicka utgående e-post som e-postmeddelanden.',
    'mail-gate.enableMailGate' => 'Låt Plesk skicka e-postmeddelanden via denna SMTP-server',
    'mail-gate.notifications' => 'E-postmeddelanden från en extern SMTP-server',
    'mail-gate.smtpSettings' => 'Externa SMTP-serverinställningar',

    'optimization-settings.apacheModulesSection' => 'Apache-moduler',
    'optimization-settings.apacheSettingsSection' => 'Allmänna inställningar',
    'optimization-settings.additionalPageHint' => 'Växla mellan moduler endast om du fullständigt begriper konsekvenserna av dina åtgärder. Notera att vissa modifieringar kan sänka Apaches prestanda eller t.o.m. leda till att det slutar fungera.',
    'optimization-settings.pageHint' => 'Här kan du optimera Plesk genom att stänga av oanvända Apache-moduler. Denna optimering förbättrar användningen av minnet och gör så att du kan betjäna mer värdtjänst-kunder. Notera att vissa moduler är beroende av varandra och kan slås av (på) enbart när modulerna de är beroende av är av (på).',
    'optimization-settings.advancedUsersOnlyWarning' => 'Denna funktion är endast för avancerade användare.',
    'optimization-settings.apacheRestartInterval' => 'Apache omstartintervall (sekunder)',
    'optimization-settings.apacheRestartIntervalHint' => 'Väl i det angivna intervallet, söker Plesk efter ändringar gjorda på domäner och subdomäner. Om det finns förändringar som kräver att webbservern återstartas, startar Plesk om Apache.',
    'optimization-settings.gracefulRestart' => 'Apache graciös omstart',
    'optimization-settings.gracefulRestartHint' => 'Välj för att undvika driftstopp för alla webbplatser som finns på servern, varje gång du ändrar värdinställningarna.',
    'optimization-settings.pipedLog' => 'Pipade loggar',
    'optimization-settings.mpmMode' => 'MPM-läge',
    'optimization-settings.moduleDeprecated' => '(Avrådd)',

    'personal-info.contactInfoSection' => 'Kontaktinformation',
    'personal-info.hint' => 'Här redigerar du användarens kontaktinformation.',
    'personal-info.hintMyProfile' => 'Här redigerar du din kontaktinformation.',

    'php-handler.ini.formHint' => 'Denna php.ini-fil används endast av denna hanterare.',
    'php-handler.ini.formHintSharedIni' => 'Denna php.ini-fil används också av följande PHP-hanterare: %%handlers%%. Inställningarna gäller alla webbplatser som använder dessa hanterare.',
    'php-handler.ini.incorrectTextForIniFile' => "De specificerade inställningarna är felaktiga och kan inte sparas i php.ini-filen. Fel: %%message%%.",

    'php-handler.modules.formHint' => 'Inställningarna för dessa PHP-extensioner gäller endast för denna hanterare.',
    'php-handler.modules.formHintSharedModules' => 'Dessa inställningar är gemensamma för följande PHP-hanterare: %%handlers%%. Inställningarna gäller alla webbplatser som använder dessa hanterare.',

    'plan-item-custom.planItemName' => 'Tjänstnamn',
    'plan-item-custom.buttonLabel' => 'Detta namn används även som etikett för den anpassade knappen.',
    'plan-item-custom.planItemDescription' => 'Tjänstbeskrivning',
    'plan-item-custom.buttonTooltip' => 'Denna text används även som verktygstips för den anpassade knappen',
    'plan-item-custom.url' => 'URl som är bifogad den anpassade knappen',
    'plan-item-custom.backgroundImage' => 'Bakgrundsbild för den anpassade knappen',
    'plan-item-custom.emptyItemName' => 'Ange en etikett för tjänsten.',
    'plan-item-custom.emptyItemDescription' => 'Ange en text för verktygstipstjänsten.',
    'plan-item-custom.emptyUrl' => 'Specificera en URL.',
    'plan-item-custom.longItemName' => 'Denna tjänsteetikett är för lång. Den maximalt tillåtna längden är %max% tecken.',
    'plan-item-custom.longItemDescription' => 'Denna tjänstetext är för lång. Den maximalt tillåtna längden är %max% tecken.',
    'plan-item-custom.longUrl' => 'Denna URL är för lång. Den maximalt tillåtna längden är %max% tecken.',
    'plan-item-custom.useCustomButton' => 'Använd den anpassade knappen för tjänsten',
    'plan-item-custom.useCustomButtonHint' => 'Placera en anpassad knapp på användarens startsida och webbplatsens sidor.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Öppna URL:en i Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Ange huruvida URL:en ska öppnas på en Plesk-sida eller i ett nytt webbläsarfönster.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Använd inte ramar',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Om du lägger till en anpassad knapp som leder till ett Plesk-tillägg eller en app på Kundpanelen, kan du specificera hur denna ändelse/app ska visas: i en ram eller som en del av Plesk GUI.',
    'plan-item-custom.includeDomId' => 'Inkludera abonnemang-ID',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Inkludera huvuddomännamnet',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Inkludera FTP-användarnamn',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Inkludera FTP-lösenord',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Inkludera kund-ID',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Inkludera kundens företagsnamn",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Inkludera kundens kontaktnamn",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Inkludera kundens e-post",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => 'Markera hur du ska förhandsvisa webbplatser',
    'preview-domain-settings.previewQuick' => 'Standard snabbförhandsgranskning',
    'preview-domain-settings.previewDisabled' => 'Inaktivera snabbdemonstrationen',
    'preview-domain-settings.previewQuickDescription' => 'Ett rekommenderat alternativ som fungerar i alla sammanhang.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Snabbdemonstration på ett domännamn i Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Välj en av dina Plesk-webbplatser som ska användas för förhandsgranskningen.',
    'preview-domain-settings.previewZoneDomainCreate' => 'För att använda denna funktion, %%link%% åtminstone en domän.',
    'preview-domain-settings.subscriptionCreateLink' => 'skapa',
    'preview-domain-settings.previewZoneTypeExternal' => 'Snabbdemonstration på ett externt domännamn',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Använd ett externt domännamn (DNS-zon). Om du använder detta alternativ, lägg till följande DNS-post (typ A) till den externa domänzonen: *.<Plesk_IP>.external.dom. Här <Plesk_IP />är Plesk-serverns IP där punkterna (.) för IPv4 eller kolon (:) för IPv6 ersätts av bindestreck (-). Till exempel, *.192-0-2-12.external.dom. Om Plesk har mer än ett registrerat IP, lägg till en post för varje adress.',
    'preview-domain-settings.sitePreviewProtection' => 'Kräv autentisering',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Kräv FTP-inloggning och lösenord för att få tillgång till förhandsgranskningen.',
    'preview-domain-settings.nginxNotInstalled' => 'Standard snabbförhandsgranskningen är inte tillgänglig eftersom nginx-webbservern inte är installerad.',
    'preview-domain-settings.nginxDisabled' => 'Standard snabbförhandsgranskningen är inte tillgänglig eftersom nginx-webbservern är inaktiverad.',

    'reseller-preferences.settingsSection' => 'Inställningar',
    'reseller-preferences.multiLogin' => 'Tillåt multipla sessioner',
    'reseller-preferences.language' => 'Gränssnittsspråk',
    'reseller-preferences.interfaceView' => 'Markera ditt gränssnitt',
    'reseller-preferences.serviceProviderView' => 'Internetleverantörens vy',
    'reseller-preferences.serviceProviderViewHint' => 'Denna vy är avsedd för återförsäljare som har kunder. Du kan hantera kunder såväl som dina egna webbplatser och hostingtjänster i denna vy.',
    'reseller-preferences.powerUserView' => 'Power User-vyn',
    'reseller-preferences.powerUserViewHint' => 'Denna vy är avsedd för att möjliggöra ett enkelt gränssnitt för att återförsäljare skall kunna hantera sina egna webbplatser, e-postkonton och andra hostingtjänster. I denna vy kan du inte hantera kunder.',

    'reseller.hint' => 'Det är här du tillför en ny återförsäljare till dina värdtjänsttjänster.',
    'reseller.contactInfoSection' => 'Kontaktinformation',
    'reseller.contactInfoSectionHint' => 'Ange återförsäljarens kontaktinformation.',
    'reseller.accessToPanelSection' => 'Åtkomst till Plesk-tjänster',
    'reseller.accessToPanelSectionHint' => 'Autentiseringsuppgifter som återförsäljaren använder för Plesk åtkomst till tjänstehanteringen som han är registrerad för.',
    'reseller.subscription' => 'Abonnemang',
    'reseller.subscriptionSectionHint' => 'Markera en tjänsteplan som återförsäljaren ska abonnera på.',
    'reseller.servicePlan' => 'Tjänsteplan',
    'reseller.none' => 'ingen',
    'reseller.customizeSubscription' => 'Fortsätt med att anpassa abonnemangsparametrarna efter att ha skapat återförsäljaren. Observera att när du gör det, låser sig abonnemanget för synkronisering.',
    'reseller.subscriptionNotSynchronized' => 'Kunde inte synkronisera prenumerationen med serviceplanen. Följande inställningar av prenumerationen står i konflikt med serviceplanen: %%problems%%.',

    'security-policy.encryptionSection' => 'Förbättrat säkerhetsläge',
    'security-policy.encryptionSectionHint' => 'Det förbättrade säkerhetsläget presenterar avancerat skydd av känsliga data i Plesk. I detta läge använder Plesk flera säkerhetsmekanismer som är absolut transparenta för Plesk-användare. För att förbättra säkerheten på Plesk, rekommenderar vi att du aktiverar läget.',
    'security-policy.encryptionEnable' => 'Förbättrat säkerhetsläge',
    'security-policy.securePassword' => 'Förbättrat säkerhetsläge',
    'security-policy.strengthSection' => 'Lösenordets styrka',
    'security-policy.strengthSectionHint' => 'När användare ställer in ett nytt lösenord i systemet (skapar ett nytt eller ändrar ett befintliga), måste de justera lösenordet enligt minimikraven på styrka som anges på denna sida. Lösenordets styrka beräknas enligt dess allmänna längd och komplexitet (användning av siffror, versaler och gemener och specialtecken). Vi rekommenderar att ni tvingar era användare att använda starkare lösenord.',
    'security-policy.passwordStrength' => 'Minsta lösenordsstyrka',
    'security-policy.passwordStrengthVeryWeakHint' => 'Dessa lösenord är typiskt korta och använder endast en typ av tecken (versaler, gemener eller siffror). Exempel: lösenord. Denna säkerhetsnivå förebygger de enklaste attackerna med lösenordsgissning.',
    'security-policy.passwordStrengthWeakHint' => 'Dessa lösenord är typiskt korta och använder för det mesta endast en typ av tecken (versaler, gemener eller siffror) med ett par tecken av en annan typ. Exempel: lösenord12. Dessa lösenord ger grundläggande skydd mot lösenordsgissning.',
    'security-policy.passwordStrengthMediocreHint' => 'Dessa lösenord är typiskt korta och innehåller tecken av minst två typer (versaler eller gemener, siffror eller specialtecken). Exempel: Lösenord12. Sådana lösenord erbjuder ett tillförlitligt skydd mot attacker som fångar upp lösenord.',
    'security-policy.passwordStrengthStrongHint' => 'Dessa lösenord består av minst 8 tecken och inkluderar minst en förekomst av versaler och gemener, siffror och specialtecken. Exempel: P@ssw0rd12. Sådana lösenord ger starkt skydd från brute-force attacker.',
    'security-policy.passwordStrengthStrongerHint' => 'Dessa lösenord består av minst 16 tecken och inkluderar flera förekomster av versaler och gemener, siffror och specialtecken. Exempel: ~!my_P@$$w0rD123. Sådana lösenord erbjuder det bästa möjliga skyddet, dock är de svårare att komma ihåg.',
    'security-policy.secureFtpSection' => 'Säker FTP',
    'security-policy.ftpOverSsl' => 'FTPS-användningspolicy',
    'security-policy.ftpOverSslHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll. Här kan du välja vilka typer av anslutningar som ska tillåtas.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll. Här kan du välja vilka typer av anslutningar som ska tillåtas. Det valda alternativet kommer att tillämpas på alla IP-adresser på servern. För att använda anpassade inställningar per IP-adress, välj motsvarande alternativ och ändra sedan FTPS-policyn i Verktyg & inställningar> IP-adresser.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS används för att skydda kommunikationen mellan FTP-servern och externa FTP-klienter med hjälp av SSL/TLS-protokoll. Om du vill justera FTPS-inställningarna per IP-adress, välj först alternativet "Använd anpassade FTPS-inställningar per IP-adress" i Verktyg & inställningar> Säkerhetspolicy> Säker FTP.',
    'security-policy.ftpOverSslOptionRequired' => 'Tillåt endast skyddade FTPS-anslutningar',
    'security-policy.ftpOverSslOptionEnabled' => 'Tillåt båda säkra FTPS- och icke-säkra FTP-anslutningar',
    'security-policy.ftpOverSslOptionDisabled' => 'Tillåt endast icke-säkra FTP-anslutningar. Använd inte FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Använd anpassad FTPS-policy per IP-adress',
    'security-policy.prohibitWebConfigHandlersSection' => 'Anpassad hanteringspolitik',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Aktivera detta alternativ för att hindra kunder från att utesluta IIS-hanterare som definieras på servernivå via web.config.filen.',
    'security-policy.prohibitWebConfigHandlers' => 'Förhindrar möjligheten att utesluta hanterare via web.config',

    'service-instance.setup-instance.resourcesSection' => 'Tjänsteresurser',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => 'Redan installerad',
    'service-instance.setup-instance.requirementsSection' => 'Nödvändiga tjänster',
    'service-instance.setup-instance.requiredServiceNotSelected' => 'Inte valt',

    'service-node.ipAddress' => 'Tjänstenodens IP-adress',
    'service-node.ipAddressLocal' => 'Lokal tjänstenod',
    'service-node.description' => 'Tjänstenod beskrivning',
    'service-node.accessKey' => 'Lösenord',
    'service-node.useAccessKey' => 'Använd autentisering',
    'service-node.useAccessKeyDescription' => 'Tips om att använda autentisering.',
    'service-node.oldAccessKey' => 'Gammalt lösenord',
    'service-node.newAccessKey' => 'Nytt lösenord',
    'service-node.noAccessKeySpecified' => 'Enhetspriset har inte specificerats',

    'service-plan.admin-plan.subscription_section' => 'Vanlig',
    'service-plan.admin-plan.tools_section' => 'Verktyg & resurser',
    'service-plan.admin-plan.apps_section' => 'Program och databaser',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk utseende',
    'service-plan.admin-plan.statistics_section' => 'Statistik',
    'service-plan.admin-plan.general_section' => 'Allmänt',
    'service-plan.admin-plan.mail_section' => 'E-post',
    'service-plan.admin-plan.server_section' => 'Server',
    'service-plan.admin-plan.modules_section' => 'Anknytningar',
    'service-plan.admin-plan.simplePanel' => 'Begränsat läge',
    'service-plan.admin-plan.enabled' => 'Aktivera begränsat läge',
    'service-plan.admin-plan.enabledDescription' => 'Välj detta alternativ för att begränsa antalet åtgärder som den administratören kan vidta i Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Välj detta alternativ för att begränsa antalet åtgärder som den extra administratören kan vidta i Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Tillhandahåll endast programen jag väljer',
    'service-plan.applications-subscription.useFilterDescription' => 'Använd detta alternativ för att välja program som ska vara tillgängliga för abonnenten.',
    'service-plan.applications-subscription.applications' => 'Program',
    'service-plan.applications-subscription.isCommercial' => 'Denna app är kommersiell och kräver köp av en licensnyckel.',

    'service-plan.applications.useFilterLabel' => 'Tillhandahåll endast programen jag väljer',
    'service-plan.applications.useFilterDescription' => 'Använd detta alternativ för att välja program som ska vara tillgängliga för abonnenterna.',
    'service-plan.applications.applications' => 'Program',
    'service-plan.applications.isCommercial' => 'Denna app är kommersiell och kräver köp av en licensnyckel.',

    'service-plan.dns.dnsZoneType' => 'Domänens DNS-namn',
    'service-plan.dns.dnsZoneTypeMaster' => 'Huvud',
    'service-plan.dns.dnsZoneTypeSlave' => 'Slav',

    'service-plan.extras.groupOtherServices' => 'Andra tjänster',
    'service-plan.extras.none' => 'Ingen',

    'service-plan.hosting.enablePhysicalHosting' => 'Aktivera värdtjänst',
    'service-plan.hosting.sectionCoreHosting' => 'Allmänna egenskaper',
    'service-plan.hosting.sectionScripting' => 'Scripting',
    'service-plan.hosting.defaultDatabaseServer' => 'Standarddatabasserver',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Avancerat',
    'service-plan.hosting.phpSettingsHelpLink' => 'Lär dig att välja de mest lämpliga PHP-inställningarna',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Statusen för webbplatserna är upphävd i detta abonnemang',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Status för webbplatserna i abonnemang som upphävts tillfälligt',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Vald status tillämpas på alla webbplatser under planens abonnemang när abonnemanget upphävs (till exempel då det löper ut eller dess betalningsperiod löper ut).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Vald status tillämpas på webbplatser när abonnemanget upphävs (till exempel då det löper ut eller dess betalningsperiod löper ut).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Inaktiverad',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Webbplatsbesökare kommer att omdirigeras till webbserverns standardsida.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Avstängd',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Webbplatsbesökare kommer att omdirigeras med sökmotorvänliga 503 HTTP-koden till den anpassade sidan med feldokument.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Aktiva',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Webbplatserna förblir tillgängliga från Internet.',

    'service-plan.ip.sharedIpAddresses' => 'Allokera delade IP-adresser',
    'service-plan.ip.allocateExclusiveIp' => 'Allokera dedikerade IP-adresser',
    'service-plan.ip.allocateExclusiveIpV4' => 'Tilldela dedikerade IPv4-adresser',
    'service-plan.ip.allocateExclusiveIpV6' => 'Tilldela dedikerade IPv6-adresser',

    'service-plan.mail.mailService' => 'Sätt på e-posttjänsten',
    'service-plan.mail.webMail' => 'Webbpost',
    'service-plan.mail.mailingLists' => 'Sätt på e-postlistor',
    'service-plan.mail.mailToNonExistentUser' => 'Policy om mail för obefintliga användare',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Returnera med meddelande',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Vidarebefordra till adressen',
    'service-plan.mail.mailToNonExistentUserReject' => 'Avvisa',
    'service-plan.mail.mailAutodiscovery' => 'Aktivera e-postens automatiska detektering',
    'service-plan.mail.mailAutodiscoveryDescription' => 'Se hur det fungerar <a href="%%link%%" target="_blank">kunskapsbasen</a>',
    'service-plan.mail.bounceMessage' => 'Denna adress accepterar ingen e-post längre.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Omdirigera till extern e-postserver med IP-adress',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - inaktiverat',

    'service-plan.misc.retainEnabled' => 'Behåll webb- och trafikstatistik för',
    'service-plan.misc.logRotation' => 'Loggrotering',
    'service-plan.misc.logRotationCondition' => 'Loggroteringsvillkor',
    'service-plan.misc.logRotationBySize' => 'Efter storlek',
    'service-plan.misc.logRotationByTime' => 'Efter tid',
    'service-plan.misc.logRotationDaily' => 'Dagens',
    'service-plan.misc.logRotationWeekly' => 'Veckovis',
    'service-plan.misc.logRotationMonthly' => 'Månadsvis',
    'service-plan.misc.logRotationSizeDescription' => 'Storleksvärdet måste vara mellan %%min%% och %%max%% kB.',
    'service-plan.misc.maximumNumberOfFiles' => 'Maximalt antal loggfiler',
    'service-plan.misc.compress' => 'Komprimera loggfilerna',
    'service-plan.misc.sendLogToEmail' => 'Efter att Plesk hämtat data från loggfilen i webben och FTP-servrarna, skicka loggarna via e-post till denna adress',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => 'månader',
    'service-plan.misc.logRotationPeriodGreater' => 'Loggrotationsperioden får inte vara längre än servergränsen %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Om den är avstängd använder alla webbplatser för ett abonnemang samma IIS-applikationspool som är dedikerad abonnemanget.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Markera tjänster och privilegier som tillhandahålls med abonnemanget.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Visa fler tillgängliga behörigheter',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Visa färre behörigheter',
    'service-plan.permissions-subscription.noShellManagement' => 'Tillåts inte',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Hantering av åtkomsten till servern via SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Ger kunderna möjlighet att byta SSH för deras systemanvändare. Gör att "SSH-åtkomst till servern under abonnemangets systemanvändare" värdparameter fungerar som en förinställning.',

    'service-plan.permissions.permissionsTabDescription' => 'Välj tjänsterna och tillstånden som tillhandahålls av planen.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Markera tjänster och privilegier som läggs till abonnemangen med denna tilläggsplan. Observera att tillstånd som inte väljs i tillägget inte kommer att modifiera abonnemangsparametrarna på något sätt.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Tillstånd låter kunder ändra specifika inställningar hos sina prenumerationer. När en prenumeration skapas så tillämpar Plesk förbestämda värden från planen på inställningarna som kunderna kan ändra. Efteråt kommer uppdatering av planen eller tillämpning av ett tillägg inte att skriva över kundens ändringar.',
    'service-plan.permissions.showMorePermissions' => 'Visa fler tillgängliga behörigheter',
    'service-plan.permissions.hideMorePermissions' => 'Visa färre behörigheter',
    'service-plan.permissions.noShellManagement' => 'Tillåts inte',
    'service-plan.permissions.systemAccessLabel' => 'Hantering av åtkomsten till servern via SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Gör så att värdtjänstparametern "SSH-åtkomst till serverskalet under abonnemangets systemanvändare" fungerar som förinställning.',

    'service-plan.resources-subscription.overusePolicy' => 'Överanvändningspolicy',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Överanvändning är inte tillåtet',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Tillåt inte överanvändning av resurser. Ett abonnemang upphävs automatiskt om resursanvändningen överstiger gränsvärdena.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Överanvändning av diskutrymme och trafik är tillåtet',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Tillåt överanvändning av diskutrymme och trafik.  Tillåt inte överanvändning av andra resurser.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Överanvändning är tillåtet (rekommenderas inte)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Tillåt abonnenten att använda mer resurser än vad som till en början ingick med abonnemanget.',
    'service-plan.resources-subscription.overuseNotify' => 'Meddela mig via e-post vid överanvändning.',
    'service-plan.resources-subscription.oversellPolicy' => 'Överförsäljningspolicy',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Överförsäljning är tillåtet',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Översäljning gör att återförsäljaren kan sälja mer resurser än vad som allokeras till dem med ett abonnemang. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Överförsäljning är inte tillåtet',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Om översäljning inte tillåts, kan en återförsäljare endast sälja så mycket resurser som till en början tilldelades honom med ett abonnemang, oavsett hur mycket dessa resurser för närvarande används.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Definiera gränserna för användningen av resurserna som tillhandahålls med abonnemanget.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Visa fler tillgängliga resurser',
    'service-plan.resources-subscription.hideMoreResources' => 'Visa mindre resurser',

    'service-plan.resources.overusePolicy' => 'Överanvändningspolicy',
    'service-plan.resources.overusePolicyNotAllowed' => 'Överanvändning är inte tillåtet',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Tillåt inte överanvändning av resurser. Ett abonnemang upphävs automatiskt om resursanvändningen överstiger gränsvärdena.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Överanvändning av diskutrymme och trafik är tillåtet',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Tillåt överanvändning av diskutrymme och trafik. Tillåt inte överanvändning av andra resurser.',
    'service-plan.resources.overusePolicyAllowed' => 'Överanvändning är tillåtet (rekommenderas inte)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Tillåt kunderna använda mer resurser än vad som till en början ingick i planen.',
    'service-plan.resources.overuseNotify' => 'Meddela mig via e-post vid överanvändning.',
    'service-plan.resources.oversellPolicy' => 'Överförsäljningspolicy',
    'service-plan.resources.oversellPolicyAllowed' => 'Överförsäljning är tillåtet',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Översäljning gör att återförsäljaren kan sälja mer resurser än vad som allokeras till dem med en plan. Om översäljning tillåts, styrs en återförsäljare av faktisk resursanvändning i stället för inledande resursallokering.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Överförsäljning är inte tillåtet',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Om översäljning inte tillåts, kan en återförsäljare endast sälja så mycket resurser som till en början tilldelades honom med en plan, oavsett hur mycket dessa resurser för närvarande används.',
    'service-plan.resources.mainGroupTitle' => 'Definiera resurserna som tillhandahålls med planen.',
    'service-plan.resources.additionalGroupTitle' => 'Visa fler tillgängliga resurser',
    'service-plan.resources.hideMoreResources' => 'Visa mindre resurser',
    'service-plan.resources.allowSitebuilderUpsell' => 'Låt kunden skapa en provversion av Presence Builder webbplatser.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Denna inställning låter kunderna skapa mer Presence Builder-webbplatser än vad som tillhandahålls av tjänsteplanen. Kunder måste köpa dessa webbplatser för att publicera dem.',

    'service-plan.servicePlanName' => 'Namn på servicenplan',
    'service-plan.resellerPlanName' => 'Återförsäljarens plannamn',
    'service-plan.addonPlanName' => 'Tilläggsprogram i planens namn',
    'service-plan.adminPlanPermissionsTab' => 'Administrationsverktyg',
    'service-plan.adminPlanPermissionsTabDescription' => 'Välj funktionerna som är tillgängliga för administratören när Begränsat läge är aktiverat.',
    'service-plan.hostingPermissionsTab' => 'värdtjänstverktyg',
    'service-plan.hostingPermissionsTabDescription' => 'Välj webbvärdtjänstverktyg och inställningar som är tillgängliga för administratören i Power User-vyn när det Begränsade läget är aktiverat.',
    'service-plan.resourcesTab' => 'Resurser',
    'service-plan.resourcesTabDescription' => 'Definiera resurserna som tillhandahålls med planen och policyn om resursanvändningen.',
    'service-plan.subscriptionResourcesTabDescription' => 'Definiera resurserna som tillhandahålls med abonnemanget och policyn om resursanvändningen.',
    'service-plan.hostingTab' => 'värdtjänstparametrar',
    'service-plan.hostingTabDescription' => 'Specificera parametrarna för värdtjänsttjänsten som tillhandahålls med planen. Observera att hostinginställningarna som specificerats i tilläggsplanen inte har tillämpats på abonnemangen som gav tillståndet "Hostinginställningshantering" antingen via serviceplanen eller tilläggsplanen.',
    'service-plan.secureSettingsDescription' => 'Om du vill att den tillhandahållna värdtjänsten ska vara den säkraste, %%link%%. Notera att några av behörigheterna, om beviljade, låter abonnenter förändra dessa inställningar. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'applicera förvalda säkra inställningar',
    'service-plan.secureSettingsHelpLink' => 'Lär dig om säker värdtjänstinställning',
    'service-plan.mailTab' => 'E-post',
    'service-plan.mailTabDescription' => 'Specificera parametrarna för e-posttjäntsen som tillhandahålls med planen.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Specificera parametrarna för DNS-tjänsten som tillhandahålls med planen.',
    'service-plan.performanceTab' => 'Uppträdande',
    'service-plan.performanceTabDescription' => 'Specificera systemparametrarna som påverkar prestandan för alla tjänster som tillhandahålls med planen.',
    'service-plan.permissionsTab' => 'Behörigheter',
    'service-plan.miscTab' => 'Loggar & statistik',
    'service-plan.miscTabDescription' => 'Specificera hur statistik och loggar för planens abonnemang ska lagras. Notera att dessa inställningar inte synkar i abonnemang.',
    'service-plan.miscTabAdminPlanDescription' => 'Specificera hur statistik och loggar från abonnemanget ska lagras.',
    'service-plan.extrasTab' => 'Ytterligare tjänster',
    'service-plan.extrasTabDescription' => 'Markera tjänsterna som ska inkluderas i planen förutom webbvärdtjänst, DNS och e-posttjänster.',
    'service-plan.ipTab' => 'IP-adresser',
    'service-plan.ipTabDescription' => 'Definiera parametrarna för IP-resurserna som tillhandahålls med planen.',
    'service-plan.applicationsTab' => 'Program',
    'service-plan.applicationsTabDescription' => 'Markera programmen som ska vara tillgängliga i planen. Du kan välja att tillhandahålla alla program som är tillgängliga i Programkatalogen, plus de som du har laddat upp till servern eller välj programmen manuellt. Om du vill tillhandahålla alla tillgängliga program, behöver du inte göra någonting på denna flik, gå till fliken Behörigheter och välj alternativet Tillgång till programkatalogen. Om du vill välja programmen manuellt, kan du göra det på denna flik.',
    'service-plan.applicationsTabDescription-addon' => 'Markera programmen som ska vara tillgängliga i tilläggen.',
    'service-plan.applicationsTabDescription-subscription' => 'Markera programmen som ska vara tillgängliga i abonnemanget. Du kan välja att tillhandahålla alla program som är tillgängliga i Programkatalogen, plus de som du har laddat upp till servern eller välj programmen manuellt. Om du vill tillhandahålla alla tillgängliga program, behöver du inte göra någonting på denna flik, gå till fliken Behörigheter och välj alternativet Tillgång till programkatalogen. Om du vill välja programmen manuellt, kan du göra det på denna flik.',
    'service-plan.planSyncSubsriptionWarning' => 'Vissa abonnemang är inte synkroniserade med planen. De har markerats som \'Osynkroniserade\' i prenumerationslistan. För att försöka med synkroniseringen igen, gå till abonnemangets översiktssida och klicka på Sync-knappen.',
    'service-plan.planSyncResellerWarning' => 'Vissa återförsäljare är inte synkroniserade med planen. De markerades som \'Osynkroniserade\' i återförsäljarnas lista. För att försöka med synkroniseringen igen, gå till återförsäljarens översiktssida och klicka på Sync-knappen.',
    'service-plan.planSyncAdminWarning' => 'Kan inte tillämpa ändringarna på abonnemang eftersom Plesk inte tillhandahåller några av de tjänster eller resurser som påverkas av dessa ändringar. Orsaken: %%reason%%',
    'service-plan.duplicateName' => 'En plan med det namnet existerar redan.',
    'service-plan.phpSettingsTab' => 'PHP-inställningar',
    'service-plan.phpSettingsTabDescription' => 'Här kan du specificera förabonnemangets PHP-inställningar som förbigår inställningarna som definieras av den serveromfattande php.ini-filne. Detta kan vara användabart till exempel när du vill begränsa systemresursernas förbrukning med kundernas PHP-skript. Kunderna (om så tillåts) kan förbigå denna PHP-konfiguration med deras egna fördomän-konfiguration. När du ställer in en parameter till standardvärdet, använder PHP parametervärdet från den serveromfattande PHP-konfigurationen. Notera att följande platshållare stöds: {DOCROOT} och {WEBSPACEROOT} står för dokumentrotkatalogen av en domän och en rotkatalog av ett webbutrymme vilket får en egen PHP-konfiguration; {TMP} står för katalogen som lagrar temporära filer.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Här kan du specificera förabonnemangets PHP-inställningar som förbigår inställningarna som definieras av huvudtjänsteplanen. Detta kan vara användbart till exempel när du vill ta bort vissa PHP-begränsningar som ställts in i huvudtjänsteplanen. När du ställer in en parameter på standardvärdet, kommer PHP att använda parametervärdet från tjänsteplanens PHP-konfiguration. Notera att följande platshållare stöds: {DOCROOT} och {WEBSPACEROOT} står för dokumentrotkatalogen av en domän och en rotkatalog av ett webbutrymme vilket får en egen PHP-konfiguration; {TMP} står för katalogen som lagrar temporära filer.',
    'service-plan.phpSettingsPhpVersion' => 'Din aktuella PHP-version är %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Här kan du specificera förabonnemangets PHP-inställningar som förbigår inställningarna som definieras av den serveromfattande php.ini-filne. När du ställer in en parameter till standardvärdet, använder PHP parametervärdet från den serveromfattande PHP-konfigurationen.',
    'service-plan.webServerSettingsTab' => 'Webbserver',
    'service-plan.webServerSettingsTabDescription' => 'Här kan du specificera Apache webbserverinställningar för denna tjänsteplan. Om Apache körs med nginx som en frontend-server, kan du ange nginx-inställningar på denna sida också. Alla nyskapade domäner kommer att få de specificerade inställningarna. Dock kommer befintliga domäner inte att erhålla förändringarna när du förändrar dessa inställningar.',
    'service-plan.servicesTab' => 'Tjänster',
    'service-plan.servicesTabDescription' => 'Här kan du specificera tjänster som tilldelats tjänsteplanen.',
    'service-plan.servicePropertiesTab' => 'Egenskaper %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Här kan du specificera egenskaperna för %%serviceName%% tjänsten som tilldelats tjänsteplanen.',
    'service-plan.longTaskWarning' => 'Du har %%subscriptionsCount%% abonnemang i denna plan. Synk-uppgiften kan behöva avsevärd tid, därför kommer den utföras i bakgrunden.',
    'service-plan.hostingParametersTab' => 'värdtjänstparametrar',
    'service-plan.adminInfoSection' => 'Information för administratören',
    'service-plan.descriptionInPanel' => 'Beskrivning',
    'service-plan.longDescription' => 'Den angivna beskrivningen är för lång.',
    'service-plan.conflictPermissions' => 'Kan inte ge följande tillstånd eftersom de står i konflikt med återförsäljningsplanen: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Startmetod',
    'services.change-startup-type.autoStartupTypeLabel' => 'Automatisk',
    'services.change-startup-type.manualStartupTypeLabel' => 'Manuell',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Stänga av',
    'services.change-startup-type.autoActionError' => 'Kan inte ställa in starttypen på \'auto\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Kan inte ställa in starttypen på \'manual\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Kan inte ställa in starttypen på \'disabled\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Återställ till standard',
    'sessions.settings.restoreDefaultButtonDescription' => 'Återställ sessionsparametrarna till standardvärden.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Sessionsparametrarna har standardvärden.',
    'sessions.settings.idleTime' => 'Sessionens inaktivitetstid',
    'sessions.settings.disableCheckSessionIp' => 'TIllåt IP-adressändringar under en enkel session',
    'sessions.settings.minuteShortTitle' => 'Min',

    'settings-ui.controls.title' => 'Kontroller',

    'settings-ui.interface-views.description' => "Det finns flera produkt UI-vyer tillgängliga för dig. Beroende på vilken vy du använder, kan funktioner och inställningar finnas på olika platser eller t.o.m. vara aktiverade/inaktiverade. Olika vyer är bättre lämpade för olika typer av användare.",
    'settings-ui.interface-views.panelSimpleLink' => 'Verktyg & inställningar> Inställningar för begränsat läge',
    'settings-ui.interface-views.useCustomView' => 'Aktivera begränsat läge',
    'settings-ui.interface-views.useCustomViewHint' => 'Välj detta alternativ för att begränsa antalet åtgärder som administratören kan vidta i Plesk Panel. För att förändra tillgängligheten av åtgärderna, gå till %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => "Denna vy är avsedd för att möjliggöra ett enkelt, förenklat gränssnitt för att serveradministratörer ska kunna hantera sina egna webbplatser, e-postkonton och andra tjänster.",
    'settings-ui.interface-views.selectUiModeTitle' => "Markera ditt gränssnitt",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Power User-vyn",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Internetleverantörens vy",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "Denna vy erbjuder gränssnitt som kan användas av serveradministratörer, återförsäljare och värdtjänstens slutanvändare.",

    'sitebuilder.trial.description' => 'Denna sida låter dig konfigurera Try and Buy-läget (tidigare Kundens förvärvsscenario). I detta läge kan kunden skapa en webbplats med alla tillgängliga funktioner i det inkluderadde Presence Builder-programmet. Men publiceringen av testwebbplatserna är inte tillgänglig för kunderna förrän de köper en värdtjänsttjänsteplan eller en tilläggsplan. Läget Try and Buy kan också ges dina befintliga kunder via en värdtjänstplan eller en tilläggsplan. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Se dokumentationen för ytterligare information.',
    'sitebuilder.trial.lifetimeLabel' => 'Livslängd för testwebbplatser',
    'sitebuilder.trial.lifetimeUnits' => 'dagar',
    'sitebuilder.trial.lifetimeDescription' => 'Detta är den tid som ska gå innan provwebbplatserna som inte köpts av kunderna tas bort från server.',
    'sitebuilder.trial.signupLabel' => 'Aktivera offentlig tillgång till testläget',
    'sitebuilder.trial.signupDescription' => 'Om du vill locka kunder med värdtjänstannonsering med Presence Bulider och tillhandahåller Presence Builder-demon till dem, aktivera det offentliga testläget och publicera testlägets åtkomst-URL på din webbplats.',
    'sitebuilder.trial.signupLinkLabel' => 'Testläge för URL-åtkomst',
    'sitebuilder.trial.signupLinkDescription' => 'Denna URL öppnar Presence Builder i testläge. Publicera denna URL på din webbplats för att annonsera värdtjänst med Presence Builder och locka kunder.',
    'sitebuilder.trial.promotionLabel' => 'Visa testlägesinformation i Presence Builder-redigeraren',
    'sitebuilder.trial.promotionDescription' => 'Använd detta alternativ om du vill visa extra information om att Presence Builder körs i testläge.',

    'update-settings.policyHintForPum' => 'Du kan ställa in automatiska installationer av uppdateringar här. Meddelanden om e-post kan ställas in när uppdateringar är tillgängliga för manuell installation eller installerades automatiskt.',
    'update-settings.policyHint' => 'Meddelanden om e-post kan ställas in när uppdateringar är tillgängliga för manuell installation eller installerades automatiskt.',
    'update-settings.branchDisabledDescription' => 'Meddela mig inte om tillgängliga uppgraderingar',
    'update-settings.automaticPatchesInstallation' => 'Installera Plesk-uppdateringar automatiskt (rekommenderas)',
    'update-settings.automaticPatchesInstallationHint' => 'Kritiska säkerhetsuppdateringar installeras alltid automatiskt.',
    'update-settings.automaticPatchesThirdParty' => 'Installera automatiskt uppdateringar för tredjepartskomponenter som levereras av Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Installera systempaketens uppdateringar automatiskt',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Observera att detta installerar automatiskt uppdateringar för tredjepartskomponenter som levereras av Plesk',
    'update-settings.automaticPatchesNotification' => 'Meddela tillgängliga och installerade uppdateringar för systempaket',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'E-postadress',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Meddelande om e-postfrekvens',
    'update-settings.daily' => 'Dagens',
    'update-settings.weekly' => 'Veckovis',
    'update-settings.generalSection' => 'Allmänt',
    'update-settings.notificationsSection' => 'Meddelanden',
    'update-settings.safeUpdatesSection' => 'Säkra uppdateringar',
    'update-settings.safeUpdatesSectionHint' => 'Plesk ser till att systempaketets uppdateringar installeras från samma katalog som paketen ursprungligen installerades från.Sådana uppdateringar anses säkra. Om du inaktiverar säkra uppdateringar, kan ditt systems pakethanterare installera uppdateringar från vilken katalog som helst i systemet.',
    'update-settings.safeUpdatesSectionWarn' => 'Vi rekommenderar att du lämnar säkra uppdateringar aktiverade om du inte är en avancerad användare. Okontrollerade uppdateringar av systempaket från olika kataloger kan påverka serverns funktion negativt.',
    'update-settings.allowSafeUpdates' => 'Aktivera säkra uppdateringar för systempaket',

    'requiredFields' => 'Obligatoriska fält',
];