<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    //===============Button conhelp================//

    'b_disabled' => 'This feature is not currently available.',
    'b_disabled_by_key' => 'This feature is not supported by the license key.',
    'b_disabled_by_permissions' => 'You do not have permission to perform backup operations.',
    'b_accept' => "You should agree to the terms of this license agreement in order to use {$PROD_NAME}.",
    'b_action_log' => 'Action log configuration.',
    'b_add_ip' => "Add IP addresses to client's IP pool.",
    'b_database_server_add' => 'Add a database server.',
    'b_adm_skeleton' => 'Manage virtual host template.',

    'b_auto-updates' => "Update Plesk or its components.",

    'b_codepage_change' => 'Click to change the encoding.',
    'b_configure_maillists' => 'Mailing list postinstall configuration.',
    'b_comp_info' => 'Information on components.',
    'b_decline' => "Declining this license you will not be able to use {$PROD_NAME}.",
    'b_dumps_list' => 'Access the backup and restoration functions and manage backup files storage.',
    'b_dumps_list_disabled' => 'The service is not available because the backup utilities were not installed.',
    'b_add_services' => 'Additional services management page.',
    'b_add_ip_for_clients' => "Add an owner for this IP address.",
    'b_anonymous_ftp' => 'Set up Anonymous FTP for the domain.',
    'b_attach_add' => 'Add attached file.',
    'b_attach_remove' => 'Remove attached file.',
    'b_backup_ok' => 'Backing up was finished. Click to go to the backup files storage.',
    'b_restore_ok' => 'Restoring was finished. Click to go to the backup files storage.',
    'b_cancel' => 'Discard any changes and return to the previous page.',
    'b_card' => 'Edit personal information.',
    'b_clean_log' => 'Clear log.',
    'b_cl_skeleton' => 'Manage virtual host template.',
    'b_dashboard' => 'Go to Home page.',
    'b_dashboard_shortcut_remove' => 'Remove the shortcut from Home page.',
    'b_domain_restore' => 'Restore the domain from this backup file.',
    'b_domain_user' => 'Allow and configure domain administrator\'s access.',
    'b_do_backup' => 'Back up the domain. During this procedure the domain management functions in the Customer Panel will not be accessible.',
    'b_do_upload' => 'Upload dump to storage.',
    'b_backup_configure' => 'Backup manager configuration.',
    'b_domain_alias_add' => 'Set up an additional domain name for your website.',
    'b_domain_aliases_limit_reached' => 'The limit on the number of domain aliases was reached.',
    'b_create_client_back' => 'Discard the suggested parameters and return to the previous page.',
    'b_create_client_update' => 'Apply the suggested parameters and proceed with customer creation.',
    'b_create_domain_back' => 'Discard the suggested parameters and return to the previous page.',
    'b_create_domain_update' => 'Apply the suggested parameters and proceed with domain creation.',
    'b_create_domain_client_select' => 'Select the customer and click OK to create the domain.',
    'b_crontab_unix' => 'Manage scheduler tasks.',
    'b_crontab_win' => 'Manage scheduler tasks.',
    'b_crontab_unix_turn_on' => 'Click to switch on the scheduled task.',
    'b_crontab_win_turn_on' => 'Click to switch on the scheduled task.',
    'b_crontab_unix_turn_off' => 'Click to suspend the scheduled task.',
    'b_crontab_win_turn_off' => 'Click to suspend the scheduled task.',
    'b_extcert_send_file' => 'Upload previously purchased certificate from the specified file.',
    'b_extras_admin' => 'Additional server tools.',
    'b_extras_client' => 'Additional domain tools.',
    'b_cl_ed' => "Click to edit customer's information.",
    'b_cl_ed_update' => "Click to update customer's information.",
    'b_cl_limits' => 'View or define customer account limits.',
    'b_cl_new_update' => 'Click to create the customer account.',
    'b_cl_not_cr_dom' => 'The customer is not allowed to create domains.',
    'b_cl_on' => "Activate customer account and all customer's websites.",
    'b_cl_off' => "Suspend customer account and all customer's websites.",
    'b_cl_permissions' => 'View or set permissions for the resources allocated to the customer.',
    'b_cl_pref_up_level' => "Click to return to the customer's settings page without updating.",
    'b_default_db_user' => "Use the selected database user's credentials to log in to the database administration interface.",
    'b_edit_tpl__add_ip' => 'Click to add IP addresses.',
    'b_edit_tpl__cancel_ip' => 'Click to cancel.',
    'b_icf' => 'Set up firewall.',
    'b_ip_clients__add' => 'Click to add.',
    'b_ip_clients__cancel' => 'Click to cancel.',
    'b_client_templates' => 'Customer templates management.',
    'b_create_login' => 'Click to create a MyPlesk.com account.',
    'b_skins_managment' => 'Click to manage skins.',
    'b_skin_add' => 'Upload a new skin to Plesk.',
    'b_skin_manual' => "Open a user's manual on creating custom Plesk skins.",
    'b_skin_manual_not_installed' => "User's manual on creating custom Plesk skins is not installed.",
    'b_skin_download' => 'Click to download skin.',
    'b_skin_replace' => 'Click to replace the current skin with the new one.',
    'b_spamassassin' => 'SpamAssassin server configuration.',

    'b_subdom_update' => 'Click to submit the settings.',
    'b_subdom_create' => 'Click to create the subdomain.',
    'b_switch_user' => 'Log in under another account.',
    'b_clients' => 'Manage client accounts.',
    'b_client_traffic' => "Client's traffic.",
    'b_change_passwd' => "Click to change administrator's password.",
    'b_change_cert_name' => 'Change the certificate name.',
    'b_databases' => 'Create and manage databases and database users.',
    'b_databases__change_server_passwd' => 'Click to go to the page of changing password.',
    'b_directories' => 'Create SSL/TLS or Non-SSL/TLS password-protected directories.',
    'b_db_access' => "Set up database administrator's credentials.",
    'b_pgsql_access' => "Set up PostgreSQL administrator's credentials.",
    'b_pgsql_not_access' => 'PostgreSQL is not installed.',
    'b_db_add' => 'Add a database.',
    'b_db_add__lim' => 'You cannot add databases to this domain: the limit on the number of databases is reached.',
    'b_db_add_update' => 'Enter new database name and click to add.',
    'b_db_del' => 'Remove database.',
    'b_db_admin_not_installed' => 'Webadmin is not installed. Contact your hosting service provider for assistance.',
    'b_db_no_default_user' => 'Unable to access Webadmin: the default Webadmin user is not specified.',
    'b_db_dbserver_not_configured' => 'Unable to access Webadmin: the database server is not configured.',
    'b_db_usr_add' => 'Add a database user.',
    'b_db_user_del' => 'Remove the database user.',
    'b_db_usr_update' => 'Change password.',
    'b_db_rm_submit' => 'Delete the selected databases.',
    'b_db_not_started' => 'The database server is not started',
    'b_db_not_configured' => 'The database server is not configured',
    'b_db_not_installed' => 'The database server is not installed',
    'b_default_text' => 'Set up default notification text.',
    'b_du_rm_submit' => 'Delete the database users.',
    'b_dns' => 'Administer DNS settings for the domain.',
    'b_dns_soa_set' => 'Apply all changes.',
    'b_dns_acl_add' => 'Click to add IP address or subnet mask.',
    'b_dns_rec_del' => 'Remove this record from DNS zone.', //to remove
    'b_dns_rec_new' => 'Select a new record type and click to add.', //to remove
    'b_dnsrecord_add' => 'Click to add a resource record to DNS zone',
    'b_dns_soa' => 'Click to configure SOA settings',
    'b_dns_soa_default' => 'Click to restore the default SOA settings.',
    'b_dns_default' => 'Click to restore the DNS zone.',

    'b_dns_master_add' => 'Add primary DNS server.', //to remove
    'b_dns_new_ns' => 'Add nameserver.', //to remove
    'b_dns_on' => 'Switch on local DNS service for the zone.',
    'b_dns_off' => 'Switch off local DNS service for the zone.',
    'b_dns_not_perm' => 'You do not have permissions to manage DNS zone for this domain.',

    'b_dom_deact' => 'Not available for suspended domains.',
    'b_dom_del' => 'Delete all domain information.',
    'b_log_manager' => 'Manage log files and log processing options.',
    'b_dom_new' => 'Click to create a domain.',
    'b_dom_new_no_clients' => 'Unable to create a domain. You have no client accounts.',
    'b_dom_new_update' => 'Click to create a domain.',
    'b_dom_on' => 'Turn the domain on.',
    'b_dom_off' => 'Turn the domain off.',
    'b_dom_pref' => 'Set up settings for the domain.',
    'b_dom_limits' => 'View or set up limits for the domain.',
    'b_domain_traffic' => 'Domain traffic.',
    'b_dom_reg' => 'Register this domain.',
    'b_dom_usr_del' => 'Delete domain level user access.',
    'b_doms_mng' => 'Manage the domains registered through Plesk.',
    'b_doms_reg' => 'Register a domain.',
    'b_report' => 'View report.',
    'b_report_saem' => 'Send the status report to the specified address.',
    'b_domains' => 'Manage domains.',
    'b_domain_templates' => 'Create, edit and delete domain templates.',
    'b_download_log' => 'Download the log file to the local machine.',
    'b_dumps_rm_submit' => 'Click to delete the backup files.',
    'b_edit_adm' => 'Click to edit administrator information.',
    'b_custom_buttons' => 'Custom buttons management.',
    'b_custom_button_add' => 'Click to add a custom button.',
    'b_custom_buttons_rm_submit' => 'Click to remove the selected custom buttons.',
    'b_hide_aliases' => 'Hide aliases.',
    'b_hide_domainaliases' => 'Hide domain aliases.',
    'b_hide_subdomains' => 'Hide subdomains.',
    'b_home' => 'Return to the home page.',
    'b_hosting' => 'Administer and set up web hosting for the domain.',
    'b_hst_del' => 'Delete the current hosting configuration.',
    'b_hst_not_set' => 'Hosting is not set up.',
    'b_hst_wo_ip' => 'Hosting is not ip-based.',
    'b_hst_wo_ip_or_not_ssl' => 'Hosting is not ip-based or SSL/TLS support is not activated.',
    'b_not_phys_hst' => 'Hosting is not physical.',
    'b_web_stat_not_set' => "Web statistics are not kept. If you want to keep statistics, go to hosting account properties (Domains > domain name > Setup > Web statistics menu) and select the statistics program you need.",
    'b_white_list' => 'Manage white list.',
    'b_white_list_add' => 'Add a domain to the white list.',
    'b_hst_sel_next' => 'Set up the selected hosting type.',
    'b_hst_update' => 'Apply all changes.',
    'b_int_ip_del' => 'Select IP addresses from the list and click to remove them from the interface.',
    'b_ip_new' => 'Click to add an IP address.',
    'b_ip_new_virtuozzo' => 'Unable to add an IP address in Virtuozzo containers.',
    'b_ip_new_lycos' => 'Unable to add an IP address in Lycos.',
    'b_ip_aliasing' => 'Manage IP addresses on the server.',
    'b_ip_del' => 'Select IP addresses/masks from the list and click to remove.',
    'b_ip_rm_submit' => 'Click to delete IP addresses.',
    'b_ip_cl_rm_submit' => 'Click to remove the IP address from the IP pool.',
    'b_ip_pool' => "Management of customer's IP pool.",
    'b_language' => 'Set up interface language.',
    'b_login' => 'Log in to Plesk.',
    'b_logo' => 'Manage logo displayed in the top interface area.',
    'b_logo_default' => 'Click to restore the default logo.',
    'b_logo_send_file' => 'Enter new logo filename and click to upload.',
    'b_logo_send_link' => 'Enter new logo link and click to attach.',
    'b_logo_send_logo' => 'Enter new logo file name and click to upload.',
    'b_log_rm_submit' => 'Click to delete log files.',
    'b_ma_rm_submit' => 'Click to delete mail aliases.',

    'b_mail' => 'Configure server-wide mail system settings.',
    'b_mail_disabled_by_admin' => 'The mail service for this domain is switched off by server administrator.',

    'b_mail_resp_on' => 'Activate the auto-reply.',
    'b_mail_resp_off' => 'Deactivate the auto-reply.',
    'b_mail_resp_add' => 'Create an auto-reply.',
    'b_mail_resp_files' => 'Manage attachments repository.',
    'b_mail_resp_files_no_mailbox' => 'This feature is not currently available because you did not set up a mailbox under this mail account.',
    'b_mail_resp_upload' => 'Upload file to the attachments repository.',
    'b_mail_resp_attach_add' => 'Create an attachment.',

    'b_mail_names' => 'Manage mail services: POP3 mailboxes, forwarders, groups, and auto-replies.',
    'b_mail_name_resp_attach_selected' => 'Click to attach the selected files to the auto-reply.',

    'b_mail_on' => 'Activate mail services for this domain.',
    'b_mail_off' => 'Deactivate mail services for this domain.',
    'b_mail_preferences' => 'Configure mail reception settings for non-existent users.',

    'b_mn_alias_new' => 'Add a mail alias.',
    'b_mn_mail_group' => 'Manage mail group.',
    'b_mn_mailbox' => 'Manage mailbox.',
    'b_mn_preferences' => 'Configure mail account.',
    'b_mn_responders' => 'Manage auto-replies.',
    'b_mn_resp_rm_submit' => 'Delete auto-replies.',
    'b_mn_redir_rm_submit' => 'Delete mail forwarders.',
    'b_mn_redirect' => 'Manage mail forwarders.',
    'b_mn_files_rm_submit' => 'Click to delete files.',
    'b_mn_attach_rm_submit' => 'Click to delete attachments.',
    'b_mn_groups' => 'Click to manage mail groups.',
    'b_mn_spamfilter_on' => 'Click to manage spam filtering.',
    'b_mn_spamfilter_off' => 'Spam filtering is currently unavailable. To enable spam filtering you need to have the Spam Filter software installed, and support for user-level spam filtering enabled on the Mail box -> Spam Filter page.',
    'b_mn_spamfilter_srv' => 'Administrator has disabled users ability to configure spam filtering.',

    'b_make_dump' => 'Back up the domain.',
    'b_ftp_account_for_dumps_repository' => 'To be able to use an external FTP server for storing the domain backups, you should specify the properties of FTP account used for accessing the server.',
    'b_cron_task_backup' => 'Manage backing up on schedule.',

    'b_mg_mem_del' => 'Select mail group members from the list and click to remove.',
    'b_mg_add' => 'Add the mail account to the selected mail groups.',
    'b_mg_cancel' => 'Click to cancel.',
    'b_mg_del' => 'Remove the mail account from the selected mail groups.',
    'b_mg_mem_new' => 'Click to add a mail group member.',
    'b_mg_turn_on' => 'Click to switch on the mail group.',
    'b_mg_turn_off' => 'Click to switch off the mail group.',
    'b_mg_update' => 'Click to submit changes.',
    'b_mn_rm_submit' => 'Click to delete mail accounts.',
    'b_mn_webmail_on' => 'Click to open webmail.',
    'b_mn_webmail_off' => 'This feature is not currently available because webmail support is not switched on in the mail settings, or mailbox is not activated.',

    'b_modules_manage' => 'Manage modules installed in Plesk and access the functions provided by these modules.',
    'b_notifications' => 'Edit notifications.',
    'b_permissions' => 'View or set permissions for the customer.',
    'b_performance' => 'Manage domain performance.',
    'b_first_page' => 'You are already on the first page.',
    'b_anonftp_stats' => 'Anonymous FTP transactions statistics.',
    'b_ftp_stats' => 'FTP server transactions statistics.',
    'b_ftp_stats_disable' => 'Web statistics are not kept, or anonymous FTP service is not turned on, or hosting is not physical.',
    'b_last_page' => 'You are already on the last page.',
    'b_next_page' => 'Go to the next page.',
    'b_prs_rm_submit' => 'Click to delete priorities.',
    'b_preferences' => "Set up interface preferences.",
    'b_prev_page' => 'Go to the previous page.',
    'b_preview' => 'Preview the site prior to DNS propagation.',
    'b_qus_rm_submit' => 'Click to delete priorities.',
    'b_repair_ip' => 'Click to add the IP address.',
    'b_repair_ip_status_ok' => 'This IP address does not need to be repaired.',
    'b_reboot' => 'Reboot the server.',
    'b_refresh' => 'Refresh data on the screen.',
    'b_key_buyonline_addons' => 'Order Plesk add-ons.',
    'b_key_buyonline_upgrades' => 'Order Plesk upgrades.',
    'b_key_buyonline_new' => 'Order a new license key.',
    'b_quick_search' => 'View the list of items that match the search criteria.',
    'b_remove_ip' => "Select IP addresses from the list and click to remove from customer's IP pool.",
    'b_restart_services' => "Manage {$PROD_NAME} services.",
    'b_send_passwd' => 'Click to get password by email.',
    'b_server' => 'Set up server-wide settings.',
    'b_database_servers' => 'Manage database servers.',
    'b_server_pref' => 'System and interface settings.',
    'b_sessions' => 'Manage sessions.',
    'b_sess_rm_submit' => 'Click to delete sessions.',
    'b_set_time' => 'Set system date and time.',
    'b_set_time_virtuozzo' => 'Unable to change the system date/time in Virtuozzo containers.',
    'b_site_apps' => 'Web applications management.',
    'b_site_apppkgs' => 'Web application packages management.',
    'b_site_apppkgs_pool' => 'Management of web application packages.',
    'b_site_apps_rm_submit' => 'Click to delete the selected web applications.',
    'b_additional_key_is_active' => 'License key is already active.',
    'b_additional_key_activate' => 'Click to activate license key.',
    'b_site_builder' => 'Click to enable integration with Presence Builder.',
    'b_dom_site_builder' => 'Click to open Presence Builder Wizard.',
    'site_builder_no_permission' => 'You do not have permission to use Mambo CMS.',
    'b_site_builder_no_package' => 'Mambo CMS is not installed.',
    'b_site_builder_no_requires' => 'Unable to run Mambo CMS as the hosting requirements are not satisfied.',
    'b_site_builder_no_vrt_hst' => 'To be able to use Mambo CMS, you should set up physical hosting for this domain.',
    'b_site_builder_setup' => 'Run Mambo CMS (if this is the first run - the application will be configured)',
    'b_show_aliases' => 'Show aliases.',
    'b_show_domainaliases' => 'Show domain aliases.',
    'b_show_subdomains' => 'Show subdomains.',
    'b_shutdown' => 'Shut the server down.',
    'b_statistics' => 'Review server statistics.',
    'b_system_time' => 'Manage system date and time.',
    'b_support' => 'File a request for technical support.',
    'b_summary_report' => 'Click to view the summary report.',
    'b_subdom_hosting' => 'Administer and set up web hosting for the subdomain.',
    'b_subdomains' => 'Create and manage subdomains.',
    'b_traffic_history' => 'View traffic history.',
    'b_set_timezone' => 'Click to set the time zone.',
    'b_set_timezone_virtuozzo' => 'Unable to change the timezone in Virtuozzo containers.',
    'b_uninst_submit' => "Click to uninstall {$PROD_NAME}.",
    'b_uninst_cancel' => 'Click to cancel uninstalling.',
    'b_upload_from_ftp' => 'Click to view a list of backups stored on FTP server.',
    'b_ok' => 'Apply all changes.',
    'b_update' => 'Apply all changes.',
    'b_update_db_access' => 'Save the changes made to the database access credentials.',
    'b_updtntp' => 'Turn on/off time synchronization with the NTP server.',
    'b_updtntp_virtuozzo' => 'Unable to set up time synchronization with NTP server in Virtuozzo containers.',
    'b_updtpswd' => "Change administrator's password.",
    'b_upload_dump' => 'Upload the backup file to the backup storage.',
    'b_no_dumps_on_ftp' => 'Remote storage is empty.',
    'b_web_stats' => 'Web server transactions statistics.',
    'b_web_stats_disable' => 'Web statistics are not activated or hosting is not physical.',
    'b_web_stats_ssl' => 'Secure web server transactions statistics.',
    'b_web_stats_ssl_disable' => 'Web statistics are not activated or secure web server is not configured or hosting is not physical.',
    'b_web_users' => 'Set up web users for the domain.',
    'b_vhost_app_add' => 'Install web application in the domain.',
    'b_vhost_app_add_no_domains' => 'There are web applications already installed in root directories of these virtual hosts.',
    'b_interface_management' => 'Hide or show various elements of Plesk.',
    'b_virtualdirs' => 'Manage virtual directories.',
    'b_virtualdir_add' => 'Add a virtual directory.',
    'b_zone_switch_master' => 'Switch the DNS zone type to primary.',
    'b_zone_switch_slave' => 'Switch the DNS zone type to secondary.',

    'b_logrotation_update' => 'Change log rotation settings.',
    'b_logrotation_on' => 'Turn the log rotation on.',
    'b_logrotation_off' => 'Turn the log rotation off.',

    'b_dom_tmpl_add' => 'Create a Domain Template.',
    'b_cl_tmpl_add' => 'Create a Client Template.',
    'b_tmpl_update' => 'Update template properties.',
    'b_tmpl_rm_subm' => 'Click to delete the templates.',

    'b_defaultcomponents' => 'Third-party Services selection.',
    'b_defaultcomponents__update' => 'Confirm the selection and proceed with setting third-party services.',
    'b_defaultcomponents__cancel' => 'Discard any changes and return to the previous page.',

    'b_locale_add' => 'Click to upload new language pack.',
    'b_locales_managment' => 'Click to manage interface languages.',

    'b_subdom_performance' => 'Manage subdomain performance.',

    'b_anon_on' => 'Switch on anonymous FTP service for the domain.',
    'b_anon_off' => 'Switch off anonymous FTP service for the domain.',

    'b_maillists' => 'Click to manage mailing lists.',
    'b_maillist_new' => 'Click to create mailing list.',
    'b_maillist_edit' => 'Click to access the mailing list administration functions.',
    'b_maillist_turn_on_off' => 'Click to change the mailing list status.',
    'b_maillists_on' => 'Activate the mailing lists service.',
    'b_maillists_off' => 'Deactivate the mailing lists service.',
    'b_maillist_off_disabled' => 'Disabling mailing lists is not supported by the current mail server.',
    'b_maillists_invert_on_off' => 'Click to change the state of the selected mailing lists.',

    'b_dom_performance_edit' => 'Manage the domain performance.',
    'b_dom_performance_readonly' => 'View the domain performance settings.',
    'b_dom_performance_disabled' => 'Feature is unavailable while QoS is not applied to the network device.',
    'b_subdom_performance_disabled' => 'Feature is unavailable while QoS is not applied to the network device.',

    //=============return to up level conhelp =====================

    'b_to_admin' => "Return to managing the Help Desk.",
    'b_to_aliases' => 'Return to mail aliases management page.',
    'b_to_autoinstaller_components' => 'Return to the components selection page.',
    'b_to_autoinstaller_releases' => 'Return to the release selection page.',
    'b_to_custom_buttons' => 'Return to managing custom buttons.',
    'b_to_cl_traffic' => "Return to the customer's traffic page.",
    'b_to_cl_templates' => "Return to the list of customer templates.",
    'b_to_cl_pref' => 'Return to the customer settings.',
    'b_to_comp_info' => "Return to managing Plesk's components.",
    'b_to_dom_rep' => 'Return to the viewing the domain information.',
    'b_to_filemanager' => 'Return to the file manager.',
    'b_to_subdomains' => 'Return to the list of subdomains.',
    'b_to_sessions' => 'Return to sessions.',
    'b_to_databases_db' => "Return to Database administrator's credentials and tools page.",
    'b_to_dumps_list' => 'Return to the domain backup files storage.',
    'b_to_backup_manager' => 'Return to the Backup Management page.',
    'b_to_log_files' => 'Return to the log files list.',
    'b_to_domains' => 'Return to the domains list.',
    'to_domain_aliases' => 'Return to the Domain Aliases page',
    'b_to_clients' => 'Return to the customers list.',
    'b_to_client_home' => "Return to the customer's home page.",
    'b_to_cp_access' => 'Return to the access restriction management page.',
    'b_to_crontab_unix' => 'Return to the Crontab management page.',
    'b_to_crontab_win' => 'Return to the Scheduler management page.',
    'b_to_dns' => 'Return to the DNS zone management.',
    'b_to_dom_ctrl' => 'Return to the domain administration page.',
    'b_to_license_management' => 'Return to license information.',
    'b_to_mail' => 'Return to configuring the server-wide mail settings.',
    'b_to_maillists' => 'Return to the mailing lists management.',
    'b_to_maillist_members' => 'Return to managing mailing list subscribers.',
    'b_to_mail_names' => 'Return to managing mail accounts.',
    'b_to_mail_name_responders' => 'Return to managing auto-replies.',
    'b_to_mail_name_resp_edit' => 'Return to editing auto-reply properties.',
    'b_to_mail_name_resp_attach_add' => 'Return to creating a new attachment.',
    'b_to_mail_name_redirects' => 'Return to managing mail forwarders.',
    'b_to_mail_name_files' => 'Return to mail account attachments repository.',
    'b_to_mail_white_list' => 'Return to managing white list entries.',
    'b_to_notifications' => 'Return to editing notifications.',
    'b_to_server' => 'Return to the server administration page.',
    'b_to_spamassassin' => 'Return to the spamfilter configuration.',
    'b_to_skins' => 'Return to managing skins.',
    'b_to_skin_info' => 'Return to viewing skin properties.',
    'b_to_scheduler' => 'Return to the Scheduler Management page.',
    'b_to_subdom_ctrl' => 'Return to the Subdomain Administration page.',
    'b_to_prs' => 'Return to priorities.',
    'b_to_responders' => 'Return to managing auto-replies.',
    'b_to_virtualdirs' => 'Return to managing Virtual Directories.',
    'b_to_virtualdir_edit' => 'Return to the previous Virtual Directory.',
    'b_to_virtualdir_root' => 'Return to the list of virtual directories.',
    'b_to_web_users' => 'Return to the list of web users.',
    'b_to_cert' => 'Return to certificate management.',
    'b_to_cl_rep' => "Return to client's information.",
    'b_to_report' => 'Return to the report.',
    'b_to_report_list' => 'Return to the custom report layouts.',
    'b_to_db_list' => 'Return to the databases list.',
    'b_to_db_usr_lst' => 'Return to the database users list.',
    'b_to_db_servers' => 'Return to the list of database servers.',
    'b_to_dns_template' => 'Return to the DNS template records list.', //to remove
    'b_to_log_files_list' => 'Return to log files management.',
    'b_to_log_rotation' => 'Return to log rotation settings.',
    'b_to_locales' => 'Return to managing Plesk languages.',
    'b_to_modules' => 'Return to the modules management.',
    'b_to_modules_management' => 'Return to the modules management.',
    'b_to_cl_pool' => 'Return to IP pool management.',
    'b_to_db' => 'Return to databases management.',
    'b_to_db_edit' => 'Return to database users management.',
    'b_to_dom_templates' => 'Return to domain templates management.',
    'b_to_dom_sum_report' => 'Return to domain summary report.',
    'b_to_statistics' => 'Return to traffic statistics.',
    'b_to_ip_aliasing' => 'Return to IP addresses management.',
    'b_to_qus' => 'Return to the list of queues.',
    'b_to_site_apps' => 'Return to the list of web applications.',
    'b_to_site_app_pkgs' => 'Return to the application vault.',
    'b_to_siteapp_install' => 'Return to the web applications installation wizard.',
    'b_to_siteapppackage_info' => 'Return to the web application package properties.',
    'b_to_additional_key_info' => 'Return to the license key properties.',
    'b_to_additional_key_properties' => 'Return to the license key properties.',


    //===============Href conhelp==================//
    'b_components_choice_default' => 'Change default component for this feature.',
    'b_components_configure' => "Set up configuration's parameters for this component.",


    //===============Icon conhelp==================//

    'i_db_conn_none' => 'This feature is not available because your license key does not support it or the service is not installed.',
    'i_db_conn_ok' => 'Connection to the database is established.',
    'i_db_conn_att' => 'The database server is not started or incorrect credentials are specified.',
    'i_db_conn_stopped' => 'The database server is not started.',
    'i_db_conn_login_failed' => 'Incorrect credentials were supplied for the database connection.',

    'i_drweb_off' => "Antivirus checking is not enabled for the mail account.",
    'i_drweb_any' => 'Antivirus checking is enabled for outgoing/incoming mail.',
    'i_drweb_from' => 'Antivirus checking is enabled for outgoing mail.',
    'i_drweb_to' => 'Antivirus checking is enabled for incoming mail.',
    'i_drweb_turn_key' => 'Antivirus is not supported by the license key.',
    'i_drweb_turn_perm' => 'You do not have the permission to manage Antivirus.',
    'i_drweb_turn_install' => 'Antivirus is not installed.',
    'i_drweb_turn_pref' => 'Click to manage antivirus settings.',

    'i_client_ok' => 'Resource usage of the client is within limits.',
    'i_cl_ok' => 'Resource usage of the client is within limits.',
    'i_cl_!' => "Resource usage of the client is exceeding the limits.",
    'i_client_on' => 'This user account is active.',

    'i_client_cp_access_on' => 'Access to the Customer Panel is allowed for the customer.',
    'i_client_cp_access_off' => 'Access to the Customer Panel is not allowed for the customer.',
    'i_click_to_cl_cp_access_on_off' => "Click to allow or prohibit access to the Customer Panel for the customer.",

    'i_custom_errors_del' => 'Click to remove the item from the list.',
    'i_custom_errors_del_disabled' => 'Removing server default custom errors is unavailable.',

    'i_open_subdomain' => 'Click to view the site in the web browser.',
    'i_open_domain' => 'Click to view the site in the web browser.',
    'i_open_domain_disabled' => 'Domain has no hosting configured.',

    'i_dom_ok' => 'Resource usage of this domain is within the allocated limits.',

    'i_dom_tmpl__owner_admin' => 'This template is created by administrator',
    'i_dom_tmpl__owner_client' => 'This template is created by customer.',

    'i_dns_on' => 'This DNS zone is served by the local DNS server.',
    'i_dns_off' => 'This DNS zone is served by an external DNS server.',
    'i_click_to_dom_on_off' => 'Click to activate/deactivate the domain.',
    'i_click_to_cl_on_off' => "Click to activate/deactivate the customer account and customer's domains.",
    'i_dom_!' => 'Resource usage limits are exceeded by this domain.',
    'i_dom_on' => 'Domain is active.',
    'i_dom_off' => 'Domain is inactive.',
    'i_dom_off_by_admin' => 'Domain was suspended by administrator.',
    'i_dom_off_by_reseller' => 'Domain was suspended by reseller.',
    'i_dom_off_by_client' => 'Domain was suspended by client.',
    'i_dom_off_expired' => 'Domain is expired.',
    'i_dom_off_with_parent' => "This user account and user's domain were suspended",
    'i_dom_off_backup_restore' => 'Domain is temporarily suspended for backing up or restoring.',

    'i_locale_active_true' => 'This language is available to Plesk users.',
    'i_locale_active_att' => 'This language got unavailable to users because your limit on the number of allowed languages is exceeded.',
    'i_locale_active_false' => 'This language is not available to users.',
    'i_locale_set_active_true' => 'Click this icon to make the language available to users.',
    'i_locale_set_active_false' => 'Click this icon to make the language unavailable to users.',
    'i_locale_default_locale' => 'This is the default language: you cannot make it unavailable to users.',

    'i_log_rot_enabled' => 'Log rotation is switched on.',
    'i_log_rot_disabled' => 'Log rotation is switched off.',
    'i_log_rot_disabled_by_parent' => 'Log rotation is switched off because the website was switched off.',

    'i_spamfilter_on' => 'Spam filtering is switched on.',
    'i_spamfilter_off' => 'Spam filtering is switched off.',
    'i_spamfilter_turn_srv' => 'The use of individual spam protection settings is not allowed by the server policy.',
    'i_spamfilter_turn_key' => 'SpamAssassin is not supported by the license key.',
    'i_spamfilter_turn_component' => 'SpamAssassin component is not installed.',
    'i_spamfilter_service_off' => 'SpamAssassin service is not running.',
    'i_spamfilter_turn_is_disabled_system_wide' => "Spam protection was switched off by your hosting service provider.",
    'i_spamfilter_turn_permission' => 'You do not have the permission to manage spam filter.',

    'i_additional_key_free' => 'Distributed freely. No license key is required.',
    'i_additional_key_ok' => 'The required license key is installed.',
    'i_additional_key_problem' => 'The required license key is not installed.',
    'i_additional_key_info' => 'Click the icon to access the license key management functions.',
    'i_additional_key_download' => 'Click to download the license key.',

    'i_vcard' => 'Add person to your Address Book.',

    'i_autoinstaller_component_action_error' => 'No updates available.',

    'i_autoinstaller_release_action_upgrade' => 'Upgrading to the new Plesk version.',
    'i_autoinstaller_release_action_update' => 'Updating or adding new components.',
    'i_autoinstaller_release_action_up2date' => 'You have an up-to-date version.',
    'i_autoinstaller_release_action_error' => 'Error retrieving information about the release.',

    'i_autoinstaller_component_action_install' => 'Not installed',
    'i_autoinstaller_component_action_update' => 'Updates are available',
    'i_autoinstaller_component_action_upgrade' => 'Updates are available',
    'i_autoinstaller_component_action_up2date' => 'You have an up to date version',

    'i_mail_resp_on' => 'The auto-reply is switched on.',
    'i_mail_resp_turn_off' => 'Click this icon to turn it off.',
    'i_mail_resp_off' => 'The auto-reply is switched off.',
    'i_mail_resp_turn_on' => 'Click this icon to turn it on.',
    'i_mail_resp_att' => 'All auto-replies are switched off for this mail account.',

    'i_anonftp_on' => 'Anonymous FTP account for the domain is switched on.',
    'i_anonftp_off' => 'Anonymous FTP account for the domain is switched off.',

    'i_sapp_ssl' => 'Web application is installed in SSL/TLS directory.',
    'i_sapp_non_ssl' => 'Web application is installed in Non-SSL/TLS directory.',
    'i_serv_drweb_up_dis' => "Start the service.",
    'i_serv_none' => 'Service is not installed.',
    'i_serv_not_configured' => 'Service is not configured.',
    'i_serv_on' => 'Service is running.',
    'i_serv_off' => 'Service is not running.',
    'i_serv_up' => 'Start the service.',
    'i_serv_up_dis' => 'Service is already running.',
    'i_serv_down' => 'Stop the service.',
    'i_serv_down_dis' => 'Service is already stopped.',
    'i_serv_up_n_down' => 'Restart the service.',
    'i_serv_up_n_down_dis' => 'Service is stopped.',
    'i_serv_key_dsbld_not_inst' => 'This feature is not available because either your license key does not support it or the service is not installed or properly configured.',

    'i_skin_download' => 'Click to download the skin.',

    'i_virtualdirs_read_enabled' => 'Virtual directory Read permission is enabled.',
    'i_virtualdirs_read_disabled' => 'Virtual directory Read permission is disabled.',
    'i_virtualdirs_write_enabled' => 'Virtual directory Write permission is enabled.',
    'i_virtualdirs_write_disabled' => 'Virtual directory Write permission is disabled.',
    'i_virtualdirs_source_enabled' => 'Virtual directory Script source access permission is enabled.',
    'i_virtualdirs_source_disabled' => 'Virtual directory Script source access permission is disabled.',
    'i_virtualdirs_browse_enabled' => 'Virtual directory Directory browsing permission is enabled.',
    'i_virtualdirs_browse_disabled' => 'Virtual directory Directory browsing permission is disabled.',
    'i_virtualdirs_change_status' => 'Click to turn permission On/Off.',

    'b_show_additional_users' => 'Extends the list of users/user\'s groups showing users with non-defined permissions.',
    'b_hide_additional_users' => 'Reduces the list of users/user\'s groups hiding users with non-defined permissions.',

    'i_prtd_ssl' => 'SSL/TLS directory is password-protected.',
    'i_prtd_no_ssl' => 'SSL/TLS directory is not password-protected.',
    'i_prtd_nonssl' => 'Non-SSL/TLS directory is password-protected.',
    'i_prtd_no_nonssl' => 'Non-SSL/TLS directory is not password-protected.',
    'i_prtd_cgi_bin' => 'cgi-bin directory is password-protected.',
    'i_prtd_no_cgi_bin' => 'cgi-bin directory is not password-protected.',

    'i_htype_none' => 'Hosting is not set up.',
    'i_htype_vrt_hst' => 'Physical hosting.',
    'i_htype_frm_fwd' => 'Frame forwarding.',
    'i_htype_std_fwd' => 'Standard forwarding.',

    'i_click_to_hosting' => 'Click to proceed to hosting setup.',

    'i_ftp_ses_domain' => 'Domain administrator\'s session.',
    'i_ftp_ses_sub_domain' => 'Subdomain administrator\'s session.',
    'i_ftp_ses_web_user' => 'Web user\'s session.',
    'i_ftp_ses_anonymous' => 'Anonymous FTP user session.',
    'i_ftp_ses_not_plesk' => 'FTP user who is not registered in Plesk.',
    'i_ftp_ses_idle' => 'Idle (no transactions).',
    'i_ftp_ses_upload' => 'Upload is in progress.',
    'i_ftp_ses_download' => 'Download is in progress.',
    'i_ftp_ses_list' => 'Downloading a list of directories.',
    'i_ftp_ses_not_know' => 'Unrecognized FTP activity.',


    //===============Page conhelp==================//

    'admin_ed' => 'Administrator information.',
    'anonftp' => 'Configure Anonymous FTP service.',
    'actionlog' => 'Manage Action Log settings.',
    'auto_updates' => "Available {$PROD_NAME} updates.",
    'autoinstaller_releases' => 'Select the desired release name to access the list of available components.',
    'autoinstaller_components' => 'Select the required components and click Install to install them.',
    'autoinstaller_install' => 'Please confirm the installation and click OK to begin.',
    'autoinstaller_configure' => 'Updater settings.',
    'backup_dialog' => 'You can back up the domain on this page. The resulting backup file can be placed in the local or remote backups storage or downloaded to the local disk.',
    'backup_configure' => 'Backup manager configuration page.',
    'card' => 'Edit personal information.',
    'cat_edit' => 'Category set up page.',
    'cert' => 'Certificate repository.',
    'cert_dom' => 'Certificate repository.',
    'cert_add' => 'Add a certificate.',
    'cert_add_dom' => 'Add a certificate.',
    'cert_edit' => 'Certificate editing page.',
    'cl_ed' => "Edit customer's information and click OK.",
    'cl_home' => 'Customer home page.',
    'cl_new' => "Enter customer's information and click OK to create a customer account.",
    'cl_perm' => "Set up customer's permissions.",
    'cl_limits' => "Set up customer's limits.",
    'cl_logo' => "Set up a logo for the customer's Customer Panel.",
    'cl_pool' => 'The range of IP addresses allotted to the customer.',
    'cl_pool_add' => "Allocation of IP addresses to the customer.",
    'cl_pool_first_time' => 'Allocation of IP addresses to the customer.',
    'cl_pool_ctrl' => 'IP address properties.',
    'cl_pref' => "Customer's settings.",
    'cl_traffic_history' => 'Traffic history page for the customer.',
    'cl_templates' => 'This page lists customer templates.',
    'cl_traffic' => "Customer's traffic",
    'clients' => 'This page lists all customer accounts registered in the system.',
    'component_conf' => "Configuring the component parameters.",
    'custom_buttons_admin' => 'Create and manage your custom buttons.',
    'custom_buttons_domain' => 'Create and manage your custom buttons.',
    'custom_buttons_client' => 'Create and manage your custom buttons.',
    'custom_buttons_reseller' => 'Create and manage your custom buttons.',
    'custom_buttons_remove' => 'Remove selected custom buttons.',
    'custom_button_admin_edit' => 'Edit custom button.',
    'custom_button_domain_edit' => 'Edit custom button.',
    'custom_button_client_edit' => 'Edit custom button.',
    'custom_button_reseller_edit' => 'Edit custom button.',
    'configure' => 'Postinstall configuration page.',
    'comp_info' => 'Information on components.',
    'common_acl' => 'This page displays a list of all IP and Network addresses for which zone transfer is allowed.',
    'to_common_acl' => 'Return to the common access control list.',
    'common_acl_add' => 'On this page you can add a record to the common allow zone transfer ACL.',
    'common_acl_remove' => 'Removal of the selected ACL records.',
    'cp_access' => 'Management of access to Plesk.',
    'cp_access_add_edit' => 'Network properties.',
    'cp_access_remove' => 'Network removal from the access restriction list.',
    'crontab_unix' => 'This page lists all tasks scheduled in the system.',
    'crontab_win' => 'This page lists all tasks scheduled in the system.',
    'crontab_unix_add_edit' => 'Fill in the required data and click OK to schedule the task.',
    'crontab_win_add_edit' => 'Fill in the required data and click OK to schedule the task.',
    'crontab_unix_remove' => 'Removal of the selected tasks.',
    'crontab_win_remove' => 'Removal of the selected tasks.',
    'scheduler' => 'This page contains the list of tasks scheduled in the system.',
    'scheduler_edit' => 'Fill out the required fields and click OK to add the task to the Scheduler.',
    'scheduler_remove' => 'Removal of the selected scheduled tasks.',
    'b_databases_access' => 'Set up credentials for access to external database servers.',
    'databases_db' =>  'Database access configuration and management tools.',
    'databases_server' =>  'This page allows changing the password used for access to the database server.',
    'db' => 'All databases managed by Plesk are listed on this page.',
    'db_add' => 'Addition of a new database.',
    'db_edit' => 'All users of this database are listed on this page.',
    'db_usr_edit' => 'Set up password for the database user.',
    'defaultcomponents' => 'Selecting default components for the services.',
    'dl_usr_ed' => "Manage domain administrator's account.",
    'dns_add' => 'Add a record to the DNS zone for the domain.',
    'dns_soa' => 'SOA settings configuration.',
    'dns_check' => 'DNS zone testing results.',
    'dns_rec_edit' => 'Edit a resource record.',
    'dns_default' => 'Restore the DNS zone.',
    'mail_name_drweb' => 'Antivirus settings setup.',
    'dom_ctrl' => 'Domain administration.',
    'dom_traffic' => 'Traffic at the domain.',
    'dom_templates' => 'Domain template is a predefined set of domain-specific restrictions, options, and hosting parameters, intended to simplify creation of domains with automatic assignment of settings to them.',
    'create_domain' => 'Enter a new domain name to create a domain for the customer.',
    'create_domain_client_select' => 'Select the customer you wish to create the domain for.',
    'dom_pref' => 'Domain settings.',
    'dom_lim' => 'Domain limits.',
    'domain_report' => 'Domain information.',
    'domain_aliases' => 'Manage domain aliases.',
    'client_app_item_info' => 'Web application information.',
    'client_report' => 'Customer information.',
    'cl_rpt_list' => 'Custom report layouts.',
    'dom_rpt_list' => 'Custom report layouts.',
    'dom_rpt_edit' => 'Edit report.',
    'dom_sum_report' => 'This page displays the domain summary report on all domains served by the system.',
    'domains' => 'This page displays a list of all domains served by the system.',
    'dumps_list' => 'Use the domain backup functions and manage the storage of backup files.',
    'download_dialog' => 'Backup file creation.',
    'extras' => 'Additional services management page.',
    'edit_dom_tmpl' => 'Edit a domain template on this page.',
    'edit_cl_tmpl' => 'Edit a customer template on this page.',

    'interface_templates' => 'Interface templates management.',
    'interface_templates_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'b_to_interface_templates' => 'Return to the list of interface templates.',
    'b_interface_template_make_default' => 'Select an interface template and click to make it default.',
    'interface_template_upload' => 'Upload your interface template.',
    'interface_clients' => 'List of clients who use this interface template.',
    'b_to_interface_clients' => 'Return to the list of clients who use this interface template.',
    'interface_clients_add' => 'Specify the clients who should use this interface template.',
    'interface_clients_remove' => 'Specify the clients who should not use the interface template.',

    'ftp_account' => 'If you use an external FTP server for storing backup files, on this page specify the properties of the FTP account used on this server.',
    'ftp_dumps_list' => "The contents of backup files storage on FTP server are listed. You can select a backup file for uploading it into domain's storage.",

    'filemanager' => 'Manage your files and directories on this page.',
    'filemanager_rename_file' => 'File renaming.',
    'filemanager_rename_dir' => 'Directory renaming.',
    'filemanager_chmod' => 'Changing access rights to file.',
    'filemanager_copy_move' => 'File copying (moving).',
    'filemanager_create_file' => 'File creation.',
    'filemanager_show' => 'File viewing.',
    'filemanager_edit' => 'File editing.',
    'filemanager_remove' => 'Files removal.',
    'filemanager_owner_row' => 'File owner.',
    'filemanager_new_file' => 'File creation.',
    'filemanager_new_dir' => 'Directory creation.',

    'gl_list' => 'Global Help Desk.',
    'groups' => 'Mail groups management.',
    'icf' => 'Firewall configuration.',
    'ip_clients' => 'The list of users who have this IP address in the pool.',
    'ip_clients_add' => 'Select clients and click OK to add this IP address in their pools.',

    'frm_fwd' => 'Enter destination URL for forwarding.',
    'std_fwd' => 'Enter destination URL for forwarding.',
    'performance' => 'Domain performance configuring.',
    'phosting_setup' => 'Hosting account setup. Choose the IP address type (dedicated or shared), FTP account username and password, and other hosting related parameters.',
    'phosting_setup_dom_usr' => 'Hosting account parameters setup.',
    'webusers' => 'This page list web users of this domain.',
    'hst_type_sel' => 'Select the type of hosting to set up.',
    'key_update' => 'Key update status.',
    'key_revert' => 'License key rollback.',
    'interface_management' => 'This page allows you to control which elements of the user interface are visible and which are not.',
    'ip_aliasing' => 'Add to and remove IP addresses from the network interfaces.',
    'ip_aliasing_clients' => 'See the list of users who have this IP address in their IP pools',
    'ip_aliasing_hosting' => 'See the domains hosted on or forwarded from this IP address',
    'ip_add' => 'IP address adding.',
    'ip_ctrl' => 'IP address parameters changing.',
    'license' => 'Read the license agreement carefully.',
    'logo' => 'Change logo image and logo URL.',
    'log_files' => 'This page lists all log files for this domain.',
    'log_rotation' => 'Log rotation settings.',

    'locale_upload' => 'Language pack upload.',
    'locales' => 'Manage Plesk languages.',
    'locales_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'mail_blocked_domains' => 'Manage black list.',

    'mail_white_list' => 'Manage white list.',
    'mail_white_list_edit' => 'Add domains to white list.',
    'mail_white_list_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'mail_name_alias_edit' => 'Create or edit an email alias.',
    'mail_name_groups' => 'Mail group membership management.',
    'mail_name_mailbox' => 'Mailbox management.',
    'mail_name_preferences' => 'Mail account settings.',
    'mail_name_redirects' => 'Mail forwarder management.',
    'mail_name_redirects_add' => 'Add mail group member.',
    'mail_name_redirects_remove' => 'Mail group members removal.',
    'mail_name_resp_edit' => 'Configure the auto-reply.',
    'mail_name_resp_attach_add' => 'Select files to attach.',
    'mail_name_resp_attach_del' => 'Remove auto-reply attachments.',
    'mail_name_resp_remove' => 'Remove auto-replies.',
    'mail_name_responders' => 'Auto-replies management.',
    'mail_name_files' => 'Mail account attachments repository.',
    'mail_name_files_remove' => 'Files removal.',
    'mail_names' => 'Mail accounts (mailboxes, mail forwarders, mail groups, auto-replies).',
    'mail_preferences' => 'Mail settings.',

    'maillists' => 'This page displays all mailing lists in this domain.',
    'maillists_conf' => 'The main mailing list creation page.',
    'maillist_edit' => 'Mailing list settings.',
    'maillist_new' => 'Mailing list addition.',
    'maillist_del' => 'Mailing list removal.',

    'maillist_members' => 'Mailing list subscribers.',
    'maillist_members_remove' => 'Mailing list subscribers removal.',
    'maillist_member_edit' => 'Mailing list user addition.',

    'upload_module' => 'Extension upload.',
    'modules_management' => 'Extensions management.',

    'b_modules_add' => 'Add an extension.',
    'modules_manaege' => 'Add and remove extensions.',
    'modules' => 'From this page you can access the features provided by the extensions installed in your Plesk.',

    'notifications' => 'Manage notification system.',
    'notification_text' => 'Edit notice text.',
    'pg_manage' => 'Adding/changing the PostgreSQL administrator information.',
    'prtd_dirs' => 'Password-protected directories.',
    'reboot' => 'The system will now be rebooted.',
    'responders' => 'Mail auto-replies.',
    'redirects' => 'Mail forwarders.',
    'restart_services' => 'Services management.',
    'server' => 'Server administration.',
    'sessions' => 'Change session settings.',
    'sessions_list' => 'This page displays a list of all sessions.',
    'ftp_sessions_list' => 'This page displays a list of all FTP sessions.',
    'cl_skeleton' => 'Manage virtual host template.',
    'skeleton' => 'Manage virtual host template.',
    'skins' => 'Manage Plesk skins.',
    'skin_info' => 'Skin information.',
    'skin_download' => 'Skin download.',
    'skin_download_now' => 'Skin download in progress.',
    'skin_upload' => 'Skin upload.',
    'skins_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'shutdown' => 'The system is shutting down.',
    'site_app_pkgs_add' => 'Add a web application package.',
    'site_app_pkgs_list' => 'Available web application packages.',
    'site_app_pkgs_instances' => 'Application installations.',
    'siteapp_install' => 'Web application installation.',
    'siteapp_reconfigure' => 'Web application reconfiguring.',
    'sitepackage_install_config' => 'Web application installation settings.',
    'sitepackage_install_agreement' => 'Web application license agreement.',
    'siteapp_extra_files' => 'Please specify what to do with the files.',
    'siteapppackage_info_server' => 'Web application package properties.',
    'siteapppackage_info_domain' => 'Web application package properties.',

    'statistics' => 'System statistics.',
    'sys_time' => 'Set up system date/time and synchronization with NTP server.',
    'subdomains' => 'Subdomains management. You can add, edit, and remove subdomains from this page.',
    'subdom_ctrl' => 'Subdomain administration page.',
    'subdom_edit' => 'Subdomain properties configuring.',
    'subdom_create' => 'Subdomain creation.',
    'subdom_remove' => 'Removal of the selected subdomains.',
    'templates' => 'This page displays a list of all domain templates, which can be used when creating a new domain.',
    'view_info' => 'From this page you can view the backup file properties and restore this backup.',

    'visibility_adminonly' => 'Make this control visible only to the administrator.',
    'visibility_cancel' => 'Cancel customization of controls on this screen.',
    'visibility_control' => 'Click to customize this control.',
    'visibility_customize' => 'Customize individual controls on this screen.',
    'visibility_default' => 'Apply default settings to this control.',
    'visibility_export' => 'Export the settings made on this screen in the form of a shell script. Run this script on a Plesk-managed server to import the settings.',
    'visibility_hide' => 'Hide this control.',
    'visibility_hide_toolbar' => 'Hide this toolbar.',
    'visibility_ok' => 'Save customizations of controls on this screen.',
    'visibility_reset_all' => 'Reset all controls on all screens to their default settings.',
    'visibility_reset_screen' => 'Reset all controls on this screen to their default settings.',
    'visibility_show' => 'Show this control.',

    'virtualdirs' => 'Virtual directories management.',
    'virtualdir_create' => 'Virtual directory creation.',
    'virtualdir_edit' => 'Virtual directory editing.',
    'virtualdirs_remove' => 'Virtual directories removal.',
    'web_users' => 'Managing web users of the domain.',
    'web_users_preferences' => "Additional web user settings.",
    'wu_edit' => 'Set up FTP password for web user.',
    'lang' => 'Set default interface language on this page.',
    'ch_pass' => "Change Administrator's password on this page.",
    'dns_template' => 'DNS zone template management.', //to remove
    'dns_template_add' => 'Add a record to the DNS zone template.', //to remove

    'dns_t' => 'This screen shows the resource records in the server-wide DNS zone template.',
    'dns_t_add' => 'Add a record to the DNS zone template.',
    'dns_t_soa' => 'SOA settings configuration.',
    'dns_t_rec_edit' => 'Edit a resource record.',
    'dns_t_rec_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'dns_t_default' => 'Restore the DNS zone template.',
    'b_to_dns_t' => 'Return to the DNS template records list.',

    'web_app_add' => 'Add a Java application.',

    'qu_edit' => 'Queue set up page.',
    'qus' => 'This page displays a list of queues.',

    'remove_modules' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeServers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeCerts' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeMailAliases' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDataBases' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDataBaseUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeCrontabTask' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDomains' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDNS' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeClients' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeLogFiles' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeDumps' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeMailNames' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeWebUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeSessions' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeTemplates' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeIPAddress' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'removeClientsIP' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'cat_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'pr_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'qu_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'pr_edit' => 'Priority setup.',
    'prs' => 'This page lists priorities.',

    'spamassassin' => 'SpamAssassin settings.',
    'spamassassin_train' => 'Training of statistics databases used for Bayesian filtering. Classify content of your mailbox as spam and good mail.',
    'spamassassin_train_view_message_source' => 'Click to view message source.',
    'spamassassin_user_conf' => 'Personal SpamAssassin settings configuration.',
    'spaw' => 'HTML editor.',
    'upload_dump' => "Select a backup file and click 'Upload' to upload the file to the storage. To upload a multivolume backup, specify the first part of the volume, then click the 'Specify the next volume' link, and specify the next volume. Repeat it until you have specified all volumes of the backup. When finished, click 'Upload'.",
    'subdom_performance' => 'Subdomain performance configuring.',

    'dom_performance_edit' => 'Domain performance configuring.',
    'dom_performance_readonly' => 'Viewing the domain performance configuration.',

    //===============List table header conhelp==================//

    'l_inv' => 'Invert selection of check boxes.',
    'l_rad' => 'Select the radio button.',

    'b_wizard_prev' => 'Return to the previous step of the wizard.',
    'b_wizard_next' => 'Proceed to the next step of the wizard.',
    'b_finish' => 'Apply the changes made on this screen and exit the wizard.',

    // pacif add

    'b_backup_ftp_settings' => 'Click to specify FTP account settings.',
    'b_backup_scheduled_settings' => 'Click to set up backing up on schedule.',
    'b_backup_ftp_not_configured' => 'FTP account is not configured.',
    'backup_client_front' => 'Back up and restore user accounts and set up backing up on schedule.',
    'backup_domain_front' => 'Back up and restore websites and set up backing up on schedule.',
    'backup_client_new' => 'Back up a user account.',
    'backup_domain_new' => 'Back up a website.',
    'backup_ftp_settings' => 'Specify the settings for the FTP account that will be used as a remote storage.',

    'backup_overwrite' => 'Select the check box to confirm replacement, and click OK to replace the file.',
    'b_backup_file_overwrite' => 'Click to replace the existing backup file with a new one.',
    'b_backup_file_overwrite_cancel' => 'Click to cancel file replacement and return to setting up backup properties.',
    'b_backup_cancel' => 'Click to stop the backup process.',

    'b_backup_cancel_creating' => 'Click to cancel backup creation and return to the previous page.',
    'b_backup_cancel_ftp_settings' => 'Click to discard the FTP account settings and return to the previous screen.',
    'b_restore_cancel' => 'Stop restoration.',
    'backup_progress' => 'Viewing the backup progress. Click Cancel to stop the backup process.',
    'restore_progress' => 'Viewing the restoration progress. Click Cancel to stop restoration.',
    'b_backup_new_restore' => 'Start restoring.',
    'b_restore_cancel_creating' => 'Click to cancel restoring and return to the previous page.',
    'b_backup_file_delete' => 'Click to delete backup file.',
    'backup_delete' => 'Select the check box to confirm backup files removal and click OK.',
    'backup_result' => 'After viewing the backup results, click OK to complete and return to the Backup Manager.',
    'backup_restore_results' => 'After viewing the restoration results, click OK to return to the Backup Manager.',

    'i_backup_domain_can_restore' => 'This domain can be restored.',
    'i_backup_domain_exist_other_client' => 'This domain cannot be restored because there is another domain with such a name, which belongs to another user.',
    'backup_failed' => 'Backup failed.',
    'backup_stop' => 'Click OK to stop the backup process. Click Cancel to continue backup.',
    'restore_stop' => 'Click OK to stop restoration. Click Cancel to continue restoration.',
    'backup_info_domain' => 'To restore the data from this backup file, click Next>>.',
    'backup_info_domain_restore' => 'To restore the data from this backup file, click Restore.',
    'backup_info_client' => 'To restore the data from this backup file, select the required items and click Next>>.',
    'backup_ip_mapping_domain' => 'Map the IP address registered in the backup file to another available IP address.',
    'backup_ip_mapping_client' => 'Map the IP addresses registered in the backup file to available IP addresses.',
    'backup__db_server_mapping' => 'Select the database server configured in Plesk to which you wish to map the database server from backup.',

    'b_restore_ip_mapping' => 'Click to set up IP mapping for restoring.',
    'learn_more' => 'Read more about this new feature.',
    'try_new_feature' => 'Try out this new feature!',
    'whats_new_full' => 'A detailed description of new features and changes in this release.',
    'b_migration_dump_all' => 'Migrate all accounts from the remote host.',
    'i_migration_not_exist_account' => 'This account can be migrated.',
    'i_migration_exist_account' => "This account cannot be migrated: it is already in {$PROD_NAME}",
    'i_migration_not_exist_domain' => 'This domain can be migrated.',
    'i_migration_exist_domain' => "This domain cannot be migrated: it is already in {$PROD_NAME}",
    'i_migration_bad_domain' => 'This domain cannot be migrated: domain name is invalid',
    'i_migration_con_exist_domain' => 'Some of the domains were already migrated to this account.',
    'i_migration_all_domain_exist' => "Only the account information will be migrated: all domains related to this account are already in {$PROD_NAME}",
    'migration_upload' => 'Select the source platform, specify the source host name and credentials for login, and click Next to upload the Migration & Transfer Agent to the host.',
    'migration_progress' => 'View the migration progress and stop the migration if desired.',
    'b_migration_host_info' => 'View information on the remote host and select objects for migration.',
    'b_migration_single_info' => 'You have an option to import all data from the dump or select the objects to be imported. From this page you can also define the deployment settings.',
    'migration_content_download' => 'View the content downloading progress and stop the downloading if desired.',
    'migration_content_download_not_space' => 'Not enough disk space to download content from the remote host.',
    'migration_objects_select' => 'Select the accounts and domains for migration.',
    'migration_account_select' => 'Select the user account in Plesk to which you want to migrate the selected domains.',
    'migration_ip_mapping' => 'Select the IP address in Plesk to which you want to map the remote host IP addresses.',
    'migration_stop' => 'Select the check box to confirm that you want to stop the migration and remove Migration & Transfer Agent from the remote host, and click OK.',
    'migration_result' => 'After viewing the migration results, click Finish to complete.',
    'migration_failed' => 'Migration failed.',
    'b_migrate' => 'Start migration.',
    'b_migrate_cancel' => 'Stop the migration process.',
    'b_migration_reload' => 'Click to refresh the data.',
    'b_migrate_domains' => 'Click to migrate the selected domains.',
    'b_migrate_accounts' => 'Click to migrate the selected accounts.',
    'b_migrate_set_accounts' => 'Click to define accounts for migrating object.',
    'b_migrate_set_ip_map' => 'Click to set up IP mapping for migrating object.',
    'b_migrate_set_db_server_map' => 'Click to set up mapping for the migrated databases.',
    'b_migration_begin' => 'Click to begin a new migration.',
    'b_migration_more' => 'Click to migrate more objects from this host.',
    'b_migration_retry' => 'Click to continue migration after you have freed up disk space.',
    'b_migration_ignore' => 'Click to continue migration anyway.',
    'b_migrate_single' => 'Single-Host Migration.',

    'b_migration_session_add' => 'Click to create a migration session.',
    'b_to_migration_manager' => 'Return to the list of migration sessions.',
    'b_to_ip_map_page' => 'Return to IP mapping.',
    'migration_upload_ipmap_file' => 'Upload IP map file.',
    'b_ipmap_download' => 'Download IP map file.',
    'b_ipmap_upload' => 'Upload IP map file.',

    'b_install' => 'Install web application',

    'b_sb_menu_desktop' => "Go to the Presence Builder system administrator's Home page.",
    'b_sb_menu_users' => "Add and manage user accounts and service plans for your customers.",
    'b_sb_menu_sites' => "Add and manage websites.",
    'b_sb_menu_server' => "Set up Presence Builder system.",
    'b_sb_menu_logs' => "View Presence Builder system and security logs.",
    'b_sb_server_configure' => "Set up integration with Presence Builder.",
    'sb_server_configure_page_description' => "Specify the username and password that Plesk should use for authorization in Presence Builder. These username and password must be first set in Presence Builder.",
    'b_sb_site_wizard' => "Go to Presence Builder for creating and managing websites.",

    'b_connect' => 'Connect your local account to a global account.',
    'b_disconnect' => 'Disconnect your local account from a global account.',
    'b_fi_change_passwd' => 'Change password for the global account.',
    'connect' => 'Connect your local account to your global account.',
    'disconnect' => 'Disconnect your local account from your global account.',
    'fi_change_passwd' => 'Change the password for your global account.',

    'sapp__no_license_key' => 'You cannot create application packages until you add a license key to the repository of license keys',

    'b_dns__tabs_general' => 'General DNS settings page.',
    'sessions__tabs_soa_record' => 'SOA Record customization.',

    'packages_preinstall' => 'Web Application installation settings.',

    'packages_info_server' => 'Viewing information on the application package.',
    'packages_info_domain' => 'Viewing information on the application package.',
    'b_to_packages_info' => 'Return to the package information page.',
    'packages_install' => 'The application package installation.',

    'b_server_app_add' => 'Click to go to the new server application installation page.',
    'b_help_install' => 'Start application installation.',
    'b_help_cancel' => 'Cancel application installation.',
    'packages_reconfigure' => 'Server Application Reconfiguring.',
    'packages_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',

    'b_packages_management' => 'Server Applications management.',
    'packages_management' => 'This page allows to install to and remove server applications from the server.',
    'b_to_packages_management' => 'Return to the server applications management page.',

    'i_ftp_ses_type' => 'The last command sent by customer is TYPE.',
    'i_ftp_ses_pass' => 'The last command sent by customer is PASS.',
    'i_ftp_ses_noop' => 'The last command sent by customer is NOOP.',

    'virtualdirs__remove_submit' => 'Click to delete selected virtual directories. The actual physical directories are not deleted.',

    'b_set_skin' => 'Click to make the current skin a default Plesk skin.',
    'set_skin__already_default' => 'The current skin is already set to be a default Plesk skin.',

    'i_custom_errors_add' => 'Enter the necessary information and click to add a custom error message.',

    'i_antivirus_off' => 'Antivirus protection is not enabled for this mailbox.',
    'i_antivirus_on' => 'Antivirus protection is enabled for this mailbox.',
    'i_antivirus_turn_pref' => 'Click to set up antivirus protection settings.',
    'i_antivirus_turn_key' => 'Antivirus protection is not supported with the current license key.',
    'i_antivirus_turn_perm' => 'You do not have permissions for managing antivirus.',

    'b_acl_add' => 'Click to add an address to Allow Zone Transfer ACL.',
    'dns_acl' => 'This page displays a list of all IP and Network addresses for which zone transfer is allowed.',

    'i_antivirus_any' => 'Antivirus protection is set for incoming and outgoing mail.',
    'i_antivirus_from' => 'Antivirus protection is set for outgoing mail.',
    'i_antivirus_to' => 'Antivirus protection is set for incoming mail.',

    'i_ip_fail_no_interface' => 'Interface associated with the IP address is absent.',

    'b_test' => 'Test connection.',

    'b_language_groups_add' => 'Add language group to the list of trusted languages.',
    'b_language_groups_del' => 'Delete language group from the list of trusted languages.',
    'b_locale_groups_add' => 'Add locale group to the list of trusted locales.',
    'b_locale_groups_del' => 'Delete locale group from the list of trusted locales.',
    'spam_trustednetworks_new' => 'Add the network to the list of trusted networks.',
    'spam_trustednetworks_remove' => 'Delete the network from the list of trusted networks.',


    'i_i_client_on' => 'Customer account is active.',
    'i_i_client_off_by_admin' => 'Customer account is disabled by administrator.',


    'b_virtualdir_add_disabled' => 'The virtual directory creation is unavailable.',

    'b_db_add_disabled' => 'Your database server connection is not configured. It can be set up on the Server->Database page.',

    'b_databases__change_server_passwd_disabled' => "You are using the Plesk's internal database server because you have configured the connection with port 8306. Therefore, the password should be changed on Settings > Change Password page.",

    'b_traffic_at_domains' => 'Viewing traffic statistics at the domains of the server.',
    'traffic_at_domains' => 'Traffic statistics at the all domains registered in the system.',

    'b_rdp_session__open_new' => 'Open new terminal session.',

    'removeDNS_acl' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',

    'i_additional_key_installed' => 'The key is installed to the application.',
    'i_additional_key_not_installed' => 'The key is not installed to the application.',

    'b_unhandlederror_showinfo' => 'Click to view detailed information on the error.',
    'b_unhandlederror_hideinfo' => 'Click to hide additional information on the error.',
    'b_unhandlederror_submitticket' => 'Click to report the error to Support service.',
    'unhandlederror' => 'Operation failure.',

    'permissions' => 'Setting up file or folder permissions.',

    'permissions_advanced' => 'Setting up advanced file or folder permissions.',

    'i_conn_strings_add' => 'Click to add the connection string.',
    'i_conn_strings_add_disabled' => 'Adding connection strings is unavailable.',
    'i_conn_strings_del' => 'Click to delete the connection string.',
    'i_conn_strings_del_disabled' => 'Deleting connection strings is unavailable.',

    'dns_acl_remove' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',

    'to_interface_management' => "Return to the interface management page.",
    't_locales' => "Click to manage interface languages.",
    't_skins' => "Click to manage skins.",
    't_interface_templates' => "Click to manage interface templates.",
    'b_locale_make_default' => "Select a language pack and click to make it default.",
    'b_skin_make_default' => "Select a skin and click to make it default.",

    'wu_limits_exceeding' => "You cannot create web users because the limit on the number of supported web users is exceeded for this domain.",

    'mail_setenable_off' => 'This feature is not supported by the mail server.',
    'domain_aliases__status_ok' => 'Domain alias is working correctly.',

    'i_htype_sub_hst' => 'Subdomain on subfolder.',
    'mail_antivirus' => 'Antivirus settings.',

    'dom_new_no_clients' => 'You need to create a customer account before you can add domains.',

    'dns_t_acl' => 'Access Control List settings.',

    'dns_t_acl_remove' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",

    'b_sapp_make_default' => "Make selected web application a default one",

    'b_ftp_ctrl' => "Manage additional FTP accounts under a domain.",
    'ftp_ctrl' => "Managing additional FTP accounts under domain.",
    'b_ftp_user_add' => "Click to add an FTP account.",
    'b_ftp_users_limit_reached' => "The limit on number of FTP accounts was reached.",
    'ftp_user_edit' => "FTP account settings.",
    'ftp_users' => "Manage additional FTP accounts under a domain.",
    'removeFtpUsers' => "Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.",
    'to_ftp_ctrl' => "Return to FTP accounts management page.",

    'b_sb_desktop' => "Overview of main Presence Builder functionalities.",
    'b_sb_users' => "Manage user accounts registered in Presence Builder.",
    'b_sb_sites' => "Add and manage various types of Presence Builder sites.",
    'b_sb_server' => "Presence Builder administration.",
    'b_sb_logs' => "View records of Presence Builder system and security logs.",

    'dns_recursion' => "DNS recursion management.",

    'subdom_hst_type_sel' => "Select the type of hosting to set up for subdomain.",

    'i_wu_open_help' => "Click to open the web user page in browser.",

    'i_i_client_off_expired' => "Validity period for this customer account has expired.",

    'i_antivirus_turn_install' => 'Antivirus is not installed or properly configured.',

    'b_ftp_users_no_permission' => "You do not have permissions to manage additional FTP accounts.",

    // Plesk 8 keys

    'b_search' => "Search for customers, domains and mail accounts.",

    // services management
    'b_service_showall' => 'Show all services.',
    'b_service_hideall' => "Hide all services.",
    'b_service_start' => "Start selected services.",
    'b_service_stop' => "Stop selected services.",
    'b_service_restart' => "Restart selected services.",
    'b_service_disable' => "Disable selected services.",
    'b_service_manual' => "Select manual startup type for selected services.",
    'b_service_auto' => "Select automatic startup type for selected services.",
    'i_serv_group_on' => 'All services in group are running.',
    'i_serv_group_none' => 'Some of the services in the group are disabled or stopped.',
    'i_serv_group_off' => 'All services in group are disabled or stopped.',
    'i_serv_key_disabled' => 'Service disabled.',

    // php4v5
    'php' => "View and change PHP settings for current virtual directory.",
    'php_changeversion' => "PHP configuration for current directory.",
    'php_dom' => "Change PHP settings for domain.",
    'php_subdom' => "Change PHP settings for subdomain.",
    'php_changeversion_dom' => "PHP configuration for domain.",
    'php_changeversion_subdom' => "PHP configuration for subdomain.",

    // mass mail
    'b_new_mass_mail_template' => 'Add a mass email message template',
    'b_massmail_send' => "Send email to all selected recipients",

    // Other
    'b_additional_key_is_install' => 'Install additional key.',
    'i_domain_sitebuilder_disabled' => "Presence Builder support is disabled for this domain.",
    'i_subdomain_sitebuilder_disabled' => "Presence Builder support is disabled for this subdomain.",
    'i_subdomain_sitebuilder_wizard' => "Go to Presence Builder Wizard for this subdomain.",
    'i_domain_sitebuilder_wizard' => "Go to Presence Builder Wizard for this domain.",
    'sitebuilder_page' => 'You are currently operating in Presence Builder window. Refer to Presence Builder documentation for more information.',
    'removeFpseUsers' => 'Select the check box to confirm removal, and click OK to remove. Click Cancel to cancel removal.',
    'b_insert' => 'Click to insert data from the selected template into your mass email message',
    'i_spamfilter_turn_install' => 'Spam Filter is not installed.',

    // help desk

    // 8.2

    // other

    'b_db_preferences' => 'Change database connection parameters',
    'b_disabled_hosting' => 'This feature is not available because physical hosting is not configured',
    'net_apps' => 'Manage ASP.NET 1.1 web applications',
    'site_apps' => "Manage standard web applications",

    'b_default_cert' => 'Use the selected certificate for securing connections to newly hosted websites.',
    'b_setup_cp' => 'Use the selected certificate for securing connections to Plesk',
    'b_to_actionlog' => 'Return to Action Log',

    // 8.3

    'additional_key_update' => 'Status of additional key update or retrieval',
    'admin_alias_password_update' => 'Confirm password change',
    'removeTasks' => "Confirm the removal of selected tasks and click OK",

    'b_license_key_remove' => 'Click to remove the license key.',
    'fi-attach' => 'Specify the global account to which you want to connect.',
    'fi-detach' => 'Confirm disconnection of the current local account from a global account and click to disconnect.',
    'fi-update' => 'Update global account settings.',

    // 8.4
    // RESELLERS
    'b_resellers' => 'Manage reseller accounts',
    'i_reseller_on' => "This user account is active.",
    'i_reseller_off_by_parent' => "This user account was suspended by the service provider.",
    'i_reseller_off_by_expired' => "The subsription term for this user account has expired.",
    'i_reseller_off_backup_restore' => "This user account was temporarily suspended for backing up or restoring data.",
    'i_reseller_ok' => "Resource usage of the reseller is within limits.",
    'i_reseller_cp_access_on' => "Access to Plesk is allowed for the reseller.",
    'i_reseller_cp_access_off' => "Access to Plesk is not allowed for the reseller.",
    'i_click_to_reseller_cp_access_on_off' => "Click to allow or prohibit access to Plesk for the reseller.",

    // CLIENTS (upgraded for resellers)

    // 'upgradeclients__submit_update' => 'Click',
    'b_upgradeClients__cancel_upgrade' => 'Discard any changes and return to the previous page.',
    'b_upgradeClients__submit_upgrade' => 'Click to convert eligible customer accounts to reseller accounts.',
    'b_upgradeDomainUser__cancel_upgrade' => 'Discard any changes and return to the previous page.',
    'b_upgradeDomainUser__submit_upgrade' => 'Click to convert eligible domain administrator accounts to customer accounts.',

    //APS Catalog
    'b_hide_updates' => "Hide updates.",
    'b_show_updates' => "Show updates.",
    'b_add_to_vault' => "Add the selected applications to the Application Vault.",

    // new and unsorted
    'b_to_server_interface' => "Return to the list of available skins.",
    'b_skin_edit' => "Edit skin description.",
    'b_to_phosting_setup' => "Return to hosting settings.",
    // Hosting setup redesign
    'b_dom_hosting_update' => "Save hosting settings.",
    'b_downgradeResellers__submit_downgrade' => "Click to complete the operation.",
    'b_rs_pool_add' => "Allocate IP addresses to the reseller.",
    'b_cl_pool_add' => "Allocate IP addresses to the client.",
    'b_ippoolManager__no_available_ips' => "There are no vacant IP addresses in the IP pool.",
    'b_ip_already_added_to_all_clients' => "This IP address is already in IP pools of all users.",

    // SERVER/SETTINGS
    'b_change_hostname_conhelp' => 'Change server hostname.',
    'b_setup_firewall_conhelp' => 'Set up firewall to protect the server.',
    'b_setup_firewall_none_available_conhelp' => 'Firewall functionality is not available: firewall is not installed.',
    'b_manage_firewall_rules_conhelp' => 'Create, edit and remove firewall rules.',
    'b_manage_firewall_rules_none_available_conhelp' => 'Firewall functionality is not available: firewall is not installed.',
    'b_select_dns_server_conhelp' => 'Select DNS server software that should be used by the server and managed by Plesk.',
    'b_select_dns_server_none_available_conhelp' => 'No other DNS servers are available.',
    'b_soa_records_template_conhelp' => 'Configure SOA records that will be used as a template when creating DNS zone for domains.',
    'b_dns_recursion_conhelp' => 'Configure DNS recursion settings that will be used as a template when creating DNS zone for domains.',
    'b_restrict_creation_of_subzones_conhelp' => "Restrict the creation of DNS subzones in other users' DNS superzones",
    'b_select_mailserver_conhelp' => 'Select mail server software that should be used by the server and managed by Plesk.',
    'b_select_mailserver_none_available_conhelp' => 'No other mail servers are available.',
    'b_select_antivirus_conhelp' => 'Select antivirus software that should be used by the server and managed by Plesk.',
    'b_select_antivirus_none_available_conhelp' => 'No other antivirus programs are available.',
    'b_virus_protection_settings_conhelp' => 'Configure server-wide virus protection settings.',
    'b_select_spamfilter_conhelp' => 'Select spam filtering software that should be used by the server and managed by Plesk.',
    'b_select_spamfilter_none_available_conhelp' => 'No other spam filtering programs are available.',
    'b_select_webmail_conhelp' => 'Select webmail software that should be available to email users.',
    'b_select_webmail_none_available_conhelp' => 'No other webmail programs are available.',
    'b_server_statistics_settings_conhelp' => 'Select what should be included in calculations of server-wide statistics.',
    'b_select_ssl_certificate_conhelp' => 'Select SSL/TLS certificate to be used for protecting your domain.',
    'b_select_ssl_certificate_none_available_conhelp' => 'Web hosting is required to have access to this feature.',
    'b_select_web_statistics_conhelp' => 'Select web statistics software that should be available to domain owners.',
    'b_select_web_statistics_none_available_conhelp' => 'No other web statistics programs are available.',
    'b_interface_management_conhelp' => 'Set up various Plesk interface options.',
    'b_setup_vpn_conhelp' => 'Set up VPN access on the server.',
    'b_setup_vpn_none_available_conhelp' => 'VPN access extension is not installed.',
    'b_setup_samba_conhelp' => 'Set up samba access on the server.',
    'b_setup_samba_none_available_conhelp' => 'Samba access extension is not installed.',

    // DOMAIN/SETTINGS
    'b_account_settings_conhelp' => 'View and change your account settings.',
    'b_dns_soa_records_conhelp' => 'View and change DNS SOA records for your domain.',
    'b_task_scheduler_settings_conhelp' => 'Set up task scheduler for your domain.',
    'b_task_scheduler_settings_none_available_conhelp' => 'Web hosting is required to have access to this feature.',
    'b_web_users_scripting_conhelp' => 'Allow or prohibit web users to use scripts.',
    'b_web_statistics_conhelp' => 'View visiting statistics for your domain.',
    'b_log_rotation_settings_conhelp' => 'Set up rotation of logs on your domain.',

    // navbar
    'b_mailnames' => 'Go to the list of mail accounts.',
    'b_applications' => 'Go to the list of web applications.',
    'b_settings' => 'Configure a variety of settings.',

    // templates
    'i_tmpl__shared_template' => 'This template was made by your hosting provider. It can be used by you, since your hosting provider is sharing it.',
    'i_tmpl__owned_template' => 'This template was made by you. It can be used by you and your users, if you permit that.',

    'b_load' => 'Load message from previously saved template.',

    'b_sh_ip_add' => 'Add IP address to the list of shared IP addresses',
    'b_sh_ip_del' => 'Remove IP address from the list of shared IP addresses',
];
