<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Accesso negato. Il tuo account è stato sospeso.",
    'login_up__login_has_been_locked' => "Hai cercato di accedere usando una password errata troppe volte. Per motivi di sicurezza, non sarai in grado di accedere con questo nome utente per qualche tempo.",
    'login_up__unable_to_check_pass' => "Impossibile verificare la password: %1",
    'login_up__warning_limits_licence_key' => "Uno dei seguenti elementi ha superato il limite definito dalla tua chiave di licenza: numero di account utente, domini, account di posta o utenti web ospitati sul tuo server.\nContatta l'ufficio vendite di Plesk per acquistare una chiave che ti consentirà di ospitare un numero di utenti e domini a piacere. Contatta l'assistenza tecnica di Plesk se ritieni di aver ricevuto questo messaggio per errore.\nIl limite autorizzato per account utente/domini/account di posta/utenti web/language pack: %2.\nIl numero di account utente/domini/account di posta/utenti web/language pack attualmente ospitati: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "La quantità di risorse che utilizzi ha superato i limiti definiti dalla licenza del prodotto attuale. Contatta l'ufficio vendite di Plesk per acquistare una nuova chiave di licenza.",
    'login_up__grace_period' => 'Stai attualmente operando in un grace period della tua licenza. Per aggiornare la licenza del tuo prodotto seleziona l\'opzione "Recupera chiavi" dalla pagina %1Informazioni sulla licenza%2.',
    'login_up__partner_license_message' => 'Stai attualmente operando con una licenza di prodotto limitata che richiede la registrazione per poter attivare tutte le caratteristiche. Per aggiornare la licenza del tuo prodotto seleziona l\'opzione "Recupera chiavi" dalla pagina %1Informazioni sulla licenza%2.',
    'login_up__system_admin_disabled' => 'Per motivi di sicurezza, il superutente (account root o amministratore) non è autorizzato ad accedere a Plesk.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Manuale dell'amministratore di Plesk",
    'plesk_guide_reseller' => "Manuale del rivenditore di Plesk",
    'plesk_guide_client' => "Manuale del cliente di Plesk",
    'plesk_guide_domain_admin' => "Manuale dell'amministratore del dominio di Plesk",
    'plesk_guide_mailuser' => "Manuale dell'utente e-mail di Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Cerca', // multiple usage: TBI
    'nav__general' => 'Menu Principale',
    '__home' => 'Home',
    '__applications' => 'Applicazioni',
    '__settings' => 'Impostazioni',
    'nav__system' => 'Sistema',
    '__master' => 'Principale',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Livello superiore',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Rimuovi',
    'bt_make_default' => 'Rendi predefinito',

    // common list object search keys
    'bt_show_all' => "Reimposta Ricerca",

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Attivo/a',
    '__object_off' => 'Sospeso',

    '__home_description' => 'Ritornare alla Home page.',
    'indicator_title' => '%1% usato, %2% libero', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    '__invalid_url_requested' => 'L\'URL richiesto non è valido.',

    // business objects
    'mn_list__mail_names_for_client' => 'Account di posta sotto l\'account utente %1',

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // list objects filtering
    'domains_list__name__filter_title' => 'Nome',
    'domains_list__state__filter_title' => 'Utilizzo delle risorse',
    'domains_list__filter_state_any' => 'Qualsiasi',
    'domains_list__filter_state_overuse' => 'Sovrautilizzo',
    'domains_list__filter_state_normal' => 'Entro i limiti',
    'domains_list__status__filter_title' => 'Stato',
    'domains_list__filter_status_any' => 'Qualsiasi',
    'domains_list__filter_status_blocked' => 'Sospeso',
    'domains_list__filter_status_active' => 'Attivo/a',
    'domains_list__subrows__filter_title' => 'Mostra',
    'domains_list__subrows_off' => 'Solo i domini',
    'domains_list__subrows_subdomain_domainaliases' => 'Con sottodomini e alias',
    'domains_list__subrows_subdomain' => 'Con sottodomini',
    'domains_list__subrows_domainaliases' => 'Con alias',

    // objects list
    'domains_list__owner__title' => 'Titolare',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Cercare applicazioni",
    'site_apps__promo_main_text' => "Il Catalogo APS (Application Packaging Standard) contiene la lista di applicazioni che possono essere approvvigionate su un dominio o uno spazio web. Se pensate di approvvigionare delle applicazioni non presenti sul catalogo, potete farlo facilmente seguendo le istruzioni di packaging APS su www.apsstandard.com",
    'site_apps__promo_download_now' => "Scaricare Applicazioni:",
    'site_apps__promo_close' => "Chiudere questo blocco",
    'site_apps__promo_preset__mostused' => '%1 Più Note',
    'site_apps__promo_preset__lessused' => 'Seguenti %1 Più Note',
    'site_apps__promo_preset__all' => "Tutti",
    'site_apps__promo_disclaimer_note' => 'Si prega di notare che le applicazioni installate dal Catalogo APS sono fornite da terzi e non sono supportate da Plesk.',
    'site_apps__promo_preset__page_title' => '%1 Applicazioni APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Aggiunta delle applicazioni in corso',

    // Errors
    'site_apps__no_applications_for_update' => 'Nessuna applicazione installata nell\'Application Vault.',
    'site_apps__incorrect_download_preset_configuration' => 'Si sono verificati alcuni errori nella configurazione della preimpostazione di download del Catalogo APS.',
    'site_apps__aps_catalog_url_is_invalid' => 'URL specificato non valido.',
    'site_apps__no_updates_at_the_moment' => 'Non ci sono aggiornamenti di applicazioni disponibili al momento.',
    'site_apps__incorrect_content_returned_by_catalog' => 'L\'informazione ricevuta dal catalogo di applicazioni APS non è corretta. Riprovare in seguito.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Le impostazioni del catalogo APS sono state salvate, ma Plesk non ha stabilito una connessione al catalogo APS specificato nelle impostazioni del catalogo APS (%1). Verificare che l\'indirizzo del catalogo APS sia corretto e che il catalogo APS su questo indirizzo sia attivo.',
    'site_apps__cannot_retrieve_updates' => 'Impossibile scaricare gli aggiornamenti delle applicazioni al momento: impossibile stabilire la connessione con il catalogo APS (%1). Verificare che l\'indirizzo del catalogo APS sia corretto e che il catalogo APS su questo indirizzo sia attivo.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Non ci sono applicazioni web disponibili per l\'installazione.',
    'site_apps__site_applications_already_installed_in_root' => 'Sono presenti altre applicazioni installate nelle directory root di questi host virtuali',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Le applicazioni web .NET non sono supportate sulla piattaforma Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Le applicazioni web del server non sono supportate',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 applicazioni web in più sono state pianificate per l'aggiunta all'Application Vault.",
    'site_apps__applications_all_in_vault' => "Le applicazioni web selezionate sono già presenti nell'Application Vault.",
    'site_apps__applications_already_in_download_queue' => "Al momento, %1 applicazioni web selezionate sono state aggiunte all'Application Vault.",
    'site_apps__applications_already_in_valut' => "%1 applicazioni web selezionate sono già presenti nell'Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Altro (senza categoria)',

    // Errors
    'site_apps__no_applications_in_category' => 'Non ci sono applicazioni disponibili in questa categoria. Selezionare un\'altra categoria.',
    'site_apps__no_category_selected__please_specify' => 'Selezionare una categoria nel menu sinistro. Tutte le applicazioni disponibili nella categoria selezionata verranno elencate in questa finestra.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Account amministratore',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Generale',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Cambia hostname',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Sicurezza',
    'bt_setup_firewall' => 'Configurare firewall',
    'bt_manage_firewall_rules' => 'Gestire le regole del firewall',
    'cu_firewall__rule' => 'Crea una regola di firewall.',
    'cu_firewall__protocol' => 'Imposta un protocollo per la regola (\'tcp\' o \'udp\')',
    'cu_firewall__name' => "Imposta il nome di una regola",
    'cu_firewall__disabled' => 'Se \'true\', la regola è disabilitata dopo la creazione.',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Selezionare server DNS.', // PFW
    'bt_soa_records_template' => 'Modello di record SOA',
    'bt_restrict_creation_of_subzones' => 'Limita la creazione di sottozone',

    'databases' => 'Database',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Applicazioni',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Posta',
    'bt_select_mailserver' => 'Selezionare server di posta.', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Selezionare antivirus', // PFW
    'bt_virus_protection_settings' => 'Impostazioni della protezione antivirus',
    'bt_select_spamfilter' => 'Selezionare filtro spam', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Selezionare WebMail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logo & statistiche',
    'bt_server_statistics_settings' => 'Impostazioni delle statistiche di server',
    'bt_select_web_statistics' => 'Software di statistiche Web disponibile', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Interfaccia di Plesk',

    'components_and_modules' => 'Componenti & moduli',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_vpn' => 'Configurare VPN', // PFU
    'bt_setup_samba' => 'Configurare samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'domain_administrator_account' => 'Account dell\'amministratore del dominio',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Impostazioni account',

    'domain' => 'Dominio',
    'bt_dns_soa_records' => 'Record SOA DNS',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Impostazioni del pianificatore di task',

    'website' => 'Sito web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Scripting per utenti web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Seleziona certificato SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Statistiche web',
    'bt_log_rotation_settings' => 'Impostazioni di rotazione di log',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limiti", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Norme sul sovrautilizzo e l'overselling (vendita al di sopra delle disponibilità)",
    'limits__overuse_policy_legend' => "Sovrautilizzo",
    'limits__oversell_policy_legend' => "Vendita al di sopra delle disponibilità",
    'limits__reseller_overuse_description' => "Le norme sul sovrautilizzo indicano a Plesk cosa fare quando le risorse vengono sovrautilizzate.",
    'limits__overuse_text' => "Norme sul sovrautilizzo",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Spazio su disco e traffico',
    'limit__disk_space' => 'Spazio su disco',
    'limit__max_traffic' => 'Traffico',
    'limit_group__client' => 'Clienti',
    'limit__max_cl' => 'Clienti',
    'limit_group__domain' => 'Domini',
    'limit__max_dom' => 'Domini',
    'limit__max_dom_powerUser' => 'Abbonamenti',
    'limit__max_subdom' => 'Sottodomini',
    'limit__max_dom_aliases' => 'Alias di dominio',
    'limit__max_wu' => 'Utenti web',
    'limit__max_subftp_users' => 'Account FTP aggiuntivi', // PFW
    'limit_group__mail' => 'Posta',
    'limit__max_box' => 'Caselle postali',
    'limit__mbox_quota' => 'Dimensione della casella postale',
    'limit__total_mboxes_quota' => 'Quota per tutte le caselle postali', // PFW
    'limit__max_maillists' => 'Liste di posta',
    'limit_group__database' => 'Database',
    'limit__max_mssql_db' => 'Database del server Microsoft SQL', // PFW
    'limit__mssql_dbase_space' => 'Totale quota database MS SQL', // PFW
    'limit__max_odbc' => 'Connessioni ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Quota database MariaDB/MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Quota database PostgreSQL', // PFW
    'limit_group__application' => 'Applicazioni',
    'limit__max_iis_app_pools' => 'Pool di applicazioni IIS', // PFW
    'limit_group__security' => 'Sicurezza',
    'limit_group__validity' => 'Data di scadenza',
    'limit__expiration' => 'Data di scadenza',
    'limit__validity' => 'Periodo di validità',
    'limit__max_site_builder' => 'Siti pubblicati con Presence Builder',
    'limit__max_site' => 'Domini',
    'limit__mssql_dbase_filesize' => 'Dimensione del file del database MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Dimensione del file di registro del database MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'La dimensione massima di un file di un database Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'La dimensione massima di un file di registro di un database Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Limite di domini non valido. Il valore minimo è 1.',

    'property__has_wrong_value' => 'La proprietà %1 presenta un valore errato.',
    'property__name_outgoing_messages_domain_limit' => 'Definisce il limite predefinito sui messaggi in uscita da un dominio (l\'ora) Per impostare il valore Illimitato, specificare "-1". Specificare "predefinito" per impostare il valore specificato nelle impostazioni del server.',
    'property__name_outgoing_messages_mbox_limit' => 'Definisce il limite predefinito sui messaggi in uscita da una casella postale (l\'ora) Per impostare il valore Illimitato, specificare "-1". Specificare "predefinito" per impostare il valore specificato nelle impostazioni del server.',
    'property__name_outgoing_messages_subscription_limit' => 'Definisce il limite predefinito sui messaggi in uscita da un abbonamento (l\'ora) Per impostare il valore Illimitato, specificare "-1". Specificare "predefinito" per impostare il valore specificato nelle impostazioni del server.',

    // for CLI report & email notifications
    '__resource_notify' => 'Notificare',
    '__general' => 'Generale',
    '__template_shared' => 'Modello condiviso',
    'limit__overuse' => 'Norme sul sovrautilizzo',
    'limit__max_traffic_soft' => 'Notificare quando l\'utilizzo del traffico viene superato',
    'limit__disk_space_soft' => 'Notificarmi al superamento dell\'utilizzo dello spazio su disco',
    '__overuse' => 'Norme sul sovrautilizzo',
    'performance__title' => 'Prestazioni',
    'performance__bandwidth' => 'Utilizzo massimo di larghezza di banda (KB/s)',
    'performance__max_connections' => 'Connessioni limitate a',

    'gch__hosting_php_isapi' => 'Esegui PHP come estensione ISAPI',
    'gch__hosting_ssi_html' => 'Usa SSI per i file *.htm, *.html',
    'gch__hosting_php_handler_type' => 'eseguire PHP come',
    'gch__hosting_php_handler_id' => 'eseguire PHP come',
    'gch__hosting_php_served_by_nginx' => 'PHP servito da nginx',
    'gch__hosting_unpaid_website_status' => 'Stato dei siti Web negli abbonamenti sospesi',
    'gch__mn_no_autoresponder' => 'Non ci sono risposte automatiche configurate per l\'account di posta.',
    'gch__no_clients_selected' => "Nessun account cliente selezionato",
    'gch__no_domains_selected' => "Nessun dominio selezionato",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/mese",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Nome risorsa',
    '__resource_usage' => 'Usato',
    '__resource_limit' => 'Limite',

    '__never_expires' => 'Non scade mai',
    '__resource_free' => '%1 libero da %2',
    '__resource_unlimited' => '%1 usato da Illimitato',

    '__unlimited' => 'Illimitato',
    '__increment' => "Aumenta (+)",
    '__decrement' => "Diminuisci (-)",
    '__pt' => 'unità',
    '__procent' => '%',
    '__overused' => 'Sovrautilizzato',
    '__left' => 'rimasto',
    '__available' => 'disponibile',
    '__not_available' => 'Non incluso',

    ///
    /// END OF LIMITS
    ///


    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'A',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Nome del rivenditore', // reseller report
    'report__full_client_name' => 'Nome del cliente', // customer report
    'report__full_domain_name' => 'Nome del dominio', // domain report
    'report__full_owner' => 'Titolare', // customer & domain reports
    'report__full_creation_date' => 'Data di creazione',
    'report__full_size' => 'Dimensione',
    'report__full_traffic' => 'Traffico',
    'report__full_active_clients' => 'Clienti attivi', // reseller report
    'report__full_clients' => 'Clienti', // reseller report
    'report__full_active_domains' => 'Domini attivi', // reseller & customer reports
    'report__full_domains' => 'Domini', // reseller & customer reports
    'report__full_subdomains' => 'Sottodom',
    'report__full_mboxes' => 'CaselleP',
    'report__full_disk_space' => 'Spazio su disco',
    'report__full_mail_groups' => 'InoltriP',
    'report__full_mail_autoresp' => 'Risp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'ListeP',
    'report__full_web_users' => 'UtntWeb',
    'report__full_mysql_databases' => 'DB MariaDB/MySQL',
    'report__full_mssql_databases' => 'DB MSSQL',
    'report__full_pgsql_databases' => 'DB PostgreSQL',

    // common summary report
    'report__section_general' => 'Generale',
    'report__version' => 'Versione del prodotto',
    'report__build' => 'Build del prodotto',
    'report__status' => 'Stato',
    'report__company_name' => 'Nome della società',
    'report__personal_name' => 'Nome personale',
    'report__login' => 'Nome utente',
    'report__phone' => 'Telefono',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Indirizzo',
    'report__city' => 'Città',
    'report__state' => 'Stato/provincia',
    'report__zip_code' => 'Codice di Avviamento Postale',
    'report__country' => 'Paese',
    'report__creation_date' => 'Data di creazione',
    'report__expiration_date' => 'Data di scadenza',
    'report__dumps_total_size' => 'Dimensione totale di file di backup',
    'report__section_resellers' => 'Rivenditori',
    'report__active_resellers' => 'Rivenditori con abbonamenti attivi',
    'report__resellers' => 'Rivenditori',
    'report__section_full_resellers' => 'Rivenditori',
    'report__section_clients' => 'Clienti',
    'report__active_clients' => 'Clienti con abbonamenti attivi',
    'report__clients' => 'Clienti',
    'report__section_full_clients' => 'Clienti',
    'report__section_personal_clients' => 'Propri clienti',
    'report__active_personal_clients' => 'I tuoi clienti con abbonamenti attivi',
    'report__personal_clients' => 'Propri clienti',
    'report__section_full_personal_clients' => 'Propri clienti',
    'report__section_domains' => 'Domini',
    'report__disk_usage' => 'Utilizzo del disco',
    'report__traffic' => 'Traffico',
    'report__active_domains' => 'Domini attivi',
    'report__domains' => 'Domini',
    'report__subdomains' => 'Sottodomini',
    'report__mboxes' => 'Caselle postali',
    'report__mail_groups' => 'Inoltri di posta',
    'report__mail_autoresp' => 'Risposte automatiche',
    'report__mail_lists' => 'Liste di posta',
    'report__web_users' => 'Utenti web',
    'report__mysql_databases' => 'Database di MariaDB/MySQL',
    'report__mssql_databases' => 'Database MSSQL',
    'report__pgsql_databases' => 'Database di PostgreSQL',
    'report__section_full_domains' => 'Domini',
    'report__section_personal_domains' => 'Domini personali',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Domini personali',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Siti pubblicati con Presence Builder',
    'report__invalid_email' => 'Indicare un indirizzo e-mail valido',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Utenti web',
    'report__section_mailnames' => 'Account di posta',
    'report__section_maillists' => 'Liste di Posta',
    'report__section_databases' => 'Database',
    'report__section_siteapps' => 'Applicazioni Web',
    'report__section_aspnetapps' => 'Applicazioni ASP.NET', // PFW
    'report__owner_pname' => "Nome personale del provider",
    'report__owner_login' => "Nome utente del provider",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Il language pack specificato è installato ma non abilitato nel sistema.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    'forgery_token_expired' => 'Token della sessione scaduto.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'I seguenti account rivenditore verranno convertiti ad account cliente',
    'downgradeResellers__downgrade' => 'Account rivenditore che verranno convertiti',
    // controls
    'downgradeResellers__submit_downgrade' => 'Effettuare la conversione dell\'account.',
    'downgradeResellers__cancel_downgrade' => 'Annulla la conversione dell\'account.',
    'downgradeResellers__confirm' => 'Confermare la conversione',
    'downgradeResellers__confirm_message' => 'Confermare la conversione dell\'account per procedere',
    // errors

    // customers > resellers
    'upgradeClients__upgrade_clients' => 'I seguenti account cliente saranno convertiti ad account rivenditore',
    'upgradeClients__upgrade' => 'Account cliente che verranno convertiti',
    // controls
    'upgradeClients__submit_upgrade' => 'Effettuare la conversione dell\'account.',
    'upgradeClients__cancel_upgrade' => 'Annulla la conversione dell\'account.',
    'upgradeClients__confirm' => 'Confermare la conversione',
    'upgradeClients__confirm_message' => 'Confermare la conversione dell\'account per procedere',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Impossibile convertire l\'account \'%1\' in account rivenditore: \'%1\' è già un rivenditore.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'I seguenti account dell\'amministratore del dominio verranno convertiti ad account cliente',
    'upgradeDomainUser__upgrade' => 'Account dell\'amministratore del dominio che verranno convertiti',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Esegui conversione dell\'account.',
    'upgradeDomainUser__cancel_upgrade' => 'Annulla la conversione dell\'account.',
    'upgradeDomainUser__confirm' => 'Confermare la conversione',
    'upgradeDomainUser__confirm_message' => 'Conferma la conversione dell\'account per procedere',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Account dell\'amministratore del dominio che non possono essere convertiti',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Non è stato possibile convertire i seguenti account dell\'amministratore del dominio ad account cliente:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Non è stato possibile convertire alcuni account dell\'amministratore del dominio ad account cliente. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'L\'account dell\'amministratore del dominio non esiste',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Il dominio dovrebbe appartenere direttamente all'amministratore del server o al rivenditore.",
    'upgradeDomainUser__all_logins_already_used' => 'Impossibile creare un account per il cliente conseguente.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'L\'account amministratore del dominio è stato convertito',
    'upgradeDomainUser__upgrade_notification_body' => 'Il tuo account amministratore del dominio è stato convertito ad account cliente con il nome utente \'%%login%%\' e la password \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Il rivenditore selezionato non ha il permesso \'%1\', ma alcuni dei clienti hanno questo permesso.',
    'clientOwnerChanger__application_not_allowed' => 'L\'applicazione \'%1\' non è disponibile per il rivenditore selezionato, ma è disponibile ad alcuni dei clienti.',

    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Utilizzo massimo di larghezza di banda (%1)',
    'hosting_performance__max_connection_label' => 'Connessioni limitate a',
    'performance__invalid_value' => "Valore non valido. Il valore deve essere compreso tra %1 e %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'WebMail',
    'webmail__server_text' => 'Clienti webmail disponibili',
    'webmail__none' => 'Nessuno',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Pool IP di Server',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Backup del server.",
    '__default_backup_comment_reseller' => "Backup dell'account rivenditore creato da %1.",
    '__default_backup_comment_client' => "Backup dell'account cliente creato da %1.",
    '__default_backup_comment_domain' => "Backup dell'abbonamento creato da %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Pool di IP del cliente %1",
    'backup__ip_mapping__resellers_ip' => "Pool di IP del rivenditore %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Host virtuale',
    'backup__restore__object_plesk_admin' => 'Amministratore Plesk',
    'backup__restore__object_ftpuser' => 'Account FTP',
    'backup__restore__object_frontpageuser' => 'Account Frontpage',
    'backup__restore__object_webuser' => 'utente web',
    'backup__restore__object_domain' => 'dominio',
    'backup__restore__object_subdomain' => 'sottodominio',
    'backup__restore__object_domainalias' => 'alias di dominio',
    'backup__restore__object_client' => 'cliente',
    'backup__restore__object_reseller' => 'rivenditore',
    'backup__restore__object_autoresponder' => 'risposta automatica',
    'backup__restore__object_mailalias' => 'alias di posta',
    'backup__restore__object_database' => 'database',
    'backup__restore__object_mailname' => 'account di posta',
    'backup__restore__object_db_user' => 'utente del database',
    'backup__restore__object_ssl_certificate' => 'Certificato SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'I seguenti rivenditori non possono essere ripristinati perché sono stati convertiti a clienti: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'I seguenti clienti non possono essere ripristinati perché sono stati convertiti a rivenditori: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'I seguenti clienti non possono essere ripristinati perché sono stati spostati verso un altro proprietario: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Insufficient disk space on the destination server to migrate all the selected subscriptions. Available: %1 MB. Required: %2 MB. Note: The required space is calculated as the sum of the web, mail, and database contents of domains. This calculation is performed once a day and stored in cache, so the actual size of the domains may differ from the calculated size. If you are sure that the selected domains do not occupy more space than available, you can proceed with the migration.',
    'backup__restore__capability_not_enough_disk_windows_text' => 'Insufficient disk space on disk \'%1\' on the destination server to migrate all the selected subscriptions. Available: %2 MB. Required: %3 MB. Note: The required space is calculated as the sum of the web, mail, and database contents of domains. This calculation is performed once a day and stored in cache, so the actual size of the domains may differ from the calculated size. If you are sure that the selected domains do not occupy more space than available, you can proceed with the migration.',
    'backup__restore__capability_not_enough_disk_resolution' => 'To proceed with the migration, free up disk space on the destination server.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Spazio su disco insufficiente sul server di origine per archiviare i file temporanei per il trasferimento. Disponibile: %1 MB. Richiesto: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Libera spazio su disco sul server di origine.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informazioni del server',

    'backup__restore__capability_not_installed_component_text' => 'Il componente %1 non è installato sul server di destinazione. %1 non sarà disponibile per tutti gli oggetti ripristinati.',
    'backup__restore__capability_not_installed_component_resolution' => 'Installa %1. L\'operazione potrebbe richiedere alcuni minuti.',
    'backup__restore__capability_existing_sys_user_text' => 'Un utente di sistema con il nome %1 esiste già sul server di destinazione.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Rinomina l\'utente di sistema esistente sul server di destinazione.',
    'backup__restore__capability_license_usage_text' => 'I seguenti limiti di risorse (definiti dalla chiave di licenza) saranno superati sul server di destinazione dopo il trasferimento di dati:',
    'backup__restore__capability_license_usage_resolution' => 'Installa sul server di destinazione un\'altra chiave di licenza che fornisca la quantità di risorse richieste.',
    'backup__restore__capability_max_allowed_packet_text' => "Il parametro 'max_allowed_packet' sul server database di origine è %1, che è superiore di quanto specificato sul server di destinazione, dove è %2. Alcuni oggetti del database per i domini specificati sotto potrebbero non essere ripristinati.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Aumenta il valore 'max_allowed_packet' sul server database di destinazione.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Impossibile trasferire i database di PostgreSQL perché la versione di PostgreSQL sul server di destinazione è precedente rispetto a quella sul server di origine. La corrente versione è %1, ma la versione richiesta è %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Installare la versione di PostgreSQL necessaria sul server di destinazione.',
    'backup__restore__capability_db_server_connection_problems' => 'Impossibile connettere al server database PostgreSQL di destinazione. I database non saranno trasferiti a meno che la connessione non venga ripristinata.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Controllare le impostazioni di connessione sul server database di destinazione.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Il componente %1 è disattivato sul server di destinazione.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Attiva %1 sul server di destinazione.',
    'backup__restore__capability_not_configured_component_text' => 'Il componente %1 non è configurato sul server di destinazione.',
    'backup__restore__capability_not_configured_component_resolution' => 'Configura %1 alla pagina Strumenti e Impostazioni.',

    'backup__restore__capability_webmail_is_not_available' => 'Il servizio webmail %1 non è disponibile sul server di destinazione. Al suo posto, Plesk userà il seguente servizio webmail: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Per utilizzare la stessa webmail del server di origine, è necessario installarla in questo server.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Per usare lo stesso servizio webmail di quello sul server di origine, è necessario installarlo sul server di destinazione.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Il servizio webmail '%1' non è disponibile sul server di destinazione. Al suo posto, sui seguenti abbonamenti: %3, Plesk userà il seguente servizio webmail: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Installare il servizio webmail necessario sul server di destinazione.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Impostazioni Webmail',

    'backup__restore__capability_shell_is_not_available' => 'La shell %1 non è disponibile sul server di destinazione. Verrà invece usata una delle shell disponibili.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Per usare la stessa shell del server di origine, è necessario attivare (in /etc/shells) o installarla sul server di destinazione.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Il server DNS di destinazione non supporta le reti nel Modello di Restrizioni del Trasferimento. I registri con indirizzi IP di rete nelle limitazioni di trasferimento DNS non saranno ripristinati.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Il server DNS di destinazione non supporta le reti nel Modello di Restrizioni di Trasferimento, ma alcuni abbonamenti hanno reti nelle restrizioni di trasferimento DNS. I registri con indirizzi IP di rete nelle limitazioni di trasferimento DNS non saranno ripristinati.',

    'backup__restore__capability_wrong_php_handler_text' => 'Il gestore PHP %1 non è disponibile sul server di destinazione. Al suo posto, Plesk userà il seguente gestore PHP: %2.',
    'backup__restore__capability_no_php_handler_text' => 'Il gestore PHP %1 non è disponibile sul server di destinazione.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Per usare lo stesso gestore PHP di quello sul server di origine, è necessario attivarlo o installarlo sul server di destinazione.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Il gestore PHP "%1" non è disponibile. Al suo posto, Plesk utilizzerà %2 per i seguenti piani di servizio: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Il gestore PHP "%1" non è disponibile. Al suo posto, Plesk userà %2 per i seguenti siti web: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Il gestore PHP %1 non è disponibile. Non sarà disponibile per i seguenti siti web: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 non disponibile sul server di destinazione. Verrà invece usata la versione predefinita.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Per usare lo stesso %1 di quello sul server di origine, è necessario attivarlo o installarlo sul server di destinazione.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Le norme sull\'utilizzo della soluzione antivirus sul server di destinazione non consentono le impostazioni antivirus personali (per indirizzo email) per la posta in uscita. Tali impostazioni non saranno trasferite.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Le norme sull\'utilizzo della soluzione antivirus sul server di destinazione non consentono le impostazioni personali dell\'antivirus (per indirizzo email) per la posta in arrivo. Tali impostazioni non saranno trasferite.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Le norme sull\'utilizzo della soluzione antivirus sul server di destinazione non consentono le impostazioni personali dell\'antivirus (per indirizzo email). Tali impostazioni non saranno trasferite.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Per trasferire le impostazioni antivirus personali (per indirizzo email), attivare le opzioni corrispondenti nella sezione Strumenti e Impostazioni > Impostazioni di protezione antivirus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Nessun software antivirus attivato. Tutte le impostazioni per l\'antivirus dal server di origine non funzioneranno finché non verrà selezionato il software antivirus sul server di destinazione.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Seleziona il software antivirus nella sezione Strumenti e impostazioni > Impostazioni di protezione antivirus > Impostazioni antivirus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Il software antivirus %2 non è disponibile sul server di destinazione. Verrà invece usato %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Per usare la stessa soluzione antivirus sul server di origine, installala e selezionala nella sezione Strumenti e Impostazioni > Impostazioni di protezione antivirus > Impostazioni antivirus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI non è disponibile sul server di destinazione. I siti web che hanno lo stesso indirizzo IP non potranno usare certificati SSL/TLS individuali.',
    'backup__restore__capability_not_available_sni_resolution' => "Controllare che il sistema operativo sul server di destinazione supporti SNI e che il supporto SNI sia attivato su Plesk (la casella di controllo 'Attiva supporto SNI, che permette di utilizzare certificati SSL/TLS individuali su siti web con lo stesso indirizzo IP' su Strumenti e impostazioni> Impostazioni del server).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Impostazioni del server',

    'backup__restore__capability_vhost_already_exists_text' => 'Il sito web %1 non può essere trasferito: un sito web con lo stesso nome esiste già sul server di destinazione.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Rinomina o rimuovi dal server il sito web con lo stesso nome.',
    'backup__restore__capability_removed_vhosts' => 'I seguenti abbonamenti non saranno ripristinati perché contengono nomi di dominio già esistenti sul server di destinazione: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Sul server di origine ci sono %3 gestori PHP diversi del tipo %1 e la versione %2. Sul server di destinazione verrà invece usato un gestore del tipo e della versione adatta. Si noti bene che le impostazioni PHP sul server di origine e di destinazione possono variare.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'L\'installer Plesk non supporta Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer non supporta Python. Installare Python manualmente.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Impostazioni del server di posta',

    'backup__restore__capability_ftps_disabled' => 'L\'utilizzo di FTPS sicuro è consentito sul server di origine ma proibito sulla destinazione. Le app dell\'utente che usano FTP potrebbero non funzionare correttamente.',
    'backup__restore__capability_ftps_required' => 'L\'utilizzo FTP non sicuro è consentito sul server di origine ma proibito sulla destinazione. Le app dell\'utente che usano FTP potrebbero non funzionare correttamente.',
    'backup__restore__capability_ftps_policy_resolution' => 'Modificare le norme di sicurezza FTP in Strumenti e impostazioni > Norme di sicurezza.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte di dati verranno trasferiti dal server di origine alla destinazione in %2 ore.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Per un trasferimento più rapido, controllare la connessione di rete fra i server di origine e destinazione e risolvere gli eventuali problemi.',
    'backup__restore__too_low_download_speed' => "meno di 0.01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Per un trasferimento più rapido, controllare la connessione di rete fra i server di origine e destinazione e risolvere gli eventuali problemi.',
    'backup__restore__capability_zero_download_speed_text' => 'La velocità di download minima accettabile è %1 MBps. La velocità di download tra i server di origine e di destinazione è 0 MBps. Ciò potrebbe essere causato da problemi di connessione di rete. Il trasferimento non è possibile.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Verificare la connessione di rete tra i server di origine e di destinazione e risolvere i problemi.',
    'backup__restore__capability_too_slow_download_speed_text' => 'La velocità di download minima consentita è %2 MBps. La velocità di download fra il server di origine e quello di destinazione è %1 MBps. Ciò potrebbe incrementare i tempi di trasferimento. Nell\'ambiente che utilizzi attualmente, la migrazione di %3 MB impiegherà %4 ore.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'La velocità di download minima consentita è %2 MBps. La velocità di download fra il server di origine e quello di destinazione è %1 MBps. Ciò potrebbe incrementare i tempi di trasferimento.',

    'backup__restore__capability_remote_database_migration' => "I seguenti domini utilizzano database remoti: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Non rimuovere questi domini dal server di origine dopo il trasferimento se la versione Plesk sul server di origine è precedente alla versione 11.5! Al contrario, devono essere sospesi. Rimuovendo i domini, vengono rimossi i database dal server remoto. Nota: i file di dump dei database remoti vengono memorizzati sul server di origine nella directory %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'I file di backup del server database MySQL di versioni precedenti alla 5.1 (%1) potrebbero non venire ripristinati su MySQL 5.1.x poiché MySQL 5.1.x gestisce i caratteri Unicode in modo diverso.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Leggere l\'articolo correlato nella base di conoscenza(n. 136850)',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP non è installato sul server di destinazione.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Installa Courier-IMAP tramite Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot non è installato sul server di destinazione.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Installare Dovecot tramite Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Il tempo di ritenzione delle statistiche di traffico nelle configurazioni dei seguenti oggetti è inferiore al valore a livello di server sul server di destinazione.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Cambia il valore a livello server che fa riferimento al tempo di conservazione delle statistiche sul server di destinazione. Imposta questo tempo a un valore pari o inferiore al valore più piccolo nelle configurazioni dei domini.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Il tempo di ritenzione delle statistiche di traffico su alcuni domini è inferiore al valore a livello di server (%1). Verrà modificato il valore di %1 per questi domini.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Il tempo per conservare le statistiche del traffico su alcuni piani di servizio è inferiore al valore del server (%1). Il valore sarà cambiato in %1 per questi piani di servizio.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Mappando un indirizzo IP esclusivo in riferimento a uno condiviso vengono disattivati gli accessi anonimi FTP e HTTPS (a meno che non sia attivo il supporto SNI).',

    'backup__restore__no_postgresql_commands_text' => 'L\'abbonamento usa un database PostgreSQL remoto e il file di backup temporaneo di esso non può essere generato perché i comandi pg_dump e psql non sono presenti sul server di origine.',
    'backup__restore__no_postgresql_commands_resolution' => 'Installa qualsiasi pacchetto client PostgreSQL che supporti questi comandi.',
    'backup__restore__capability_apache_modules_disabled_text' => 'I seguenti moduli Apache sono disabilitati sul server di destinazione: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Abilita questi moduli per evitare possibili problemi.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'I seguenti moduli Apache non sono installati sul server di destinazione: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Installa e abilita questi moduli per evitare possibili problemi.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'La limitazione dei messaggi in uscita non è supportata dalla tua licenza. Le impostazioni di configurazione corrispondenti non saranno trasferite.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Installa sul server di destinazione un\'altra chiave di licenza che fornisca le funzionalità richieste.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'La limitazione dei messaggi in uscita è disattivata sul server di destinazione. Le impostazioni di configurazione corrispondenti non saranno trasferite.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Attivare la limitazione dei messaggi in uscita sul server di destinazione.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Impostazioni di posta del server',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'La limitazione dei messaggi in uscita da una casella postale non è supportata dal server di posta usato sul server di destinazione. Il valore di questo limite non sarà trasferito.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Cambia il server di posta allo stesso che usi sul server di origine.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Impostazioni di posta del server',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'La limitazione dei messaggi in uscita da un dominio non è supportata dal server di posta usato sul server di destinazione. Il valore di questo limite non sarà trasferito.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Cambia il server di posta allo stesso che usi sul server di origine.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Impostazioni di posta del server',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'La limitazione dei messaggi in uscita da un abbonamento non è supportata dal server di posta usato sul server di destinazione. Il valore di questo limite non sarà trasferito.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Cambia il server di posta allo stesso che usi sul server di origine.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Impostazioni di posta del server',

    'bu_conflict_resolver_absent_phosting' => 'Impossibile ripristinare i file specificati perché l\'hosting fisico per ripristinarli non esiste. Crea prima un dominio con hosting fisico e poi avvia il ripristino del backup nuovamente.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'I dati dei rivenditori non saranno ripristinati poiché la gestione dei rivenditori non è supportata.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Il componente ModSecurity non è installato sul server di destinazione.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Installa ModSecurity perché il firewall dell\'applicazione web continui a funzionare per i siti trasferiti. L\'installazione potrebbe richiedere alcuni minuti.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installa ModSecurity se desideri trasferire le impostazioni del firewall dell\'applicazione web. L\'installazione potrebbe richiedere alcuni minuti.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Il componente ModSecurity non è configurato sul server di destinazione.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Configura ModSecurity se desideri che il firewall dell\'applicazione web continui a funzionare per i siti trasferiti.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Firewall di Applicazione Web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity è disattivato sul server di destinazione.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Attiva ModSecurity se desideri che il firewall dell\'applicazione web continui a funzionare per i siti trasferiti.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Firewall di Applicazione Web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Il componente ModSecurity non è installato. Le impostazioni del firewall dell\'applicazione web non saranno ripristinate per gli oggetti seguenti: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "I siti web non possono essere ripristinati perché appartengono all'abbonamento %1, che non è stato trovato in Plesk.",
    'bu_conflict_resolver_attend_websites_subscription' => "Some websites cannot be restored because there are subscriptions with the same names: %1.",
    'backup__restore__capability_not_installed_dns_text' => 'Il componente %1 non è installato sul server di destinazione. Il servizio DNS non sarà disponibile e le impostazioni DNS si perderanno. I siti web di tutti i clienti saranno inattivi.',
    'bu_conflict_resolver_dns_not_installed' => 'Il servizio DNS non è installato.Le impostazioni DNS non saranno ripristinate per gli oggetti seguenti: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'I seguenti abbonamenti non possono essere ripristinati perché sono stati spostati verso altri proprietari: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'I seguenti abbonamenti non possono essere ripristinati perché sono stati spostati verso altri fornitori: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Impossibile trovare l\'utility di ripristino di Web Presence Builder per ripristinare i dati di Web Presence Builder. Web Presence Builder probabilmente non è installato.',
    'backup__restore__capability_renamed_db' => 'Il nome del database "%1" è già usato da un altro abbonamento. Il nome del database ripristinato sarà cambiato in "%2".',
    'backup__restore__capability_renamed_db_user' => 'Il nome dell\'utente del database "%1" è già usato da un altro abbonamento. Il nome dell\'utente del database ripristinato sarà cambiato in "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer non supporta Perl. Installare ActiveState Perl manualmente.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% fornito da Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% fornito da nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Conflitti sull\'utilizzo delle risorse',
    'backup__restore__hint_resource_usage_conflicts' => 'I conflitti sull\'utilizzo delle risorse avvengono quando i limiti sull\'utilizzo delle risorse dell\'oggetto ripristinato vengono superati dopo il ripristino.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Consentire sovrautilizzo',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Ripristinare l\'oggetto e consentire l\'utilizzo di più risorse di quante fornite inizialmente.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Non ripristinare',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Non ripristinare oggetti che presentano conflitti sull\'utilizzo delle risorse.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Conflitti di configurazione',
    'backup__restore__hint_configuration_conflicts' => 'I conflitti di configurazione avvengono quando l\'oggetto ripristinato presenta impostazioni e applicazioni web che non sono disponibili o che sono proibite dal server corrente o dalle norme del proprietario dell\'oggetto. Per esempio, i conflitti di configurazione avverranno se gli account ripristinati presentano impostazioni di filtraggio spam mentre le norme correnti del server proibiscono agli account di avere queste impostazioni.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatico',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Ripristinare l\'oggetto e attivare automaticamente tutte le opzioni di configurazione di conflitti che i vostri permessi consentono di gestire.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Non ripristinare',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Non ripristinare oggetti che presentano conflitti di configurazione.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'I pool di applicazioni IIS dedicato non sono consentiti nelle impostazioni del pool di applicazioni IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Cambia le impostazioni del pool di applicazioni IIS in Strumenti e Impostazioni > Pool di applicazioni IIS > Impostazioni globali.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'I pool di applicazioni IIS condiviso non sono consentiti nelle impostazioni del pool di applicazioni IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Cambia le impostazioni del pool di applicazioni IIS in Strumenti e Impostazioni > Pool di applicazioni IIS > Impostazioni globali.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'I nomi brevi degli account di posta POP3/IMAP non sono consentiti sul server di destinazione.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'I nomi brevi per gli account di posta non saranno disponibili dopo il ripristino di dati.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Impossibile aprire il file di registro.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Impossibile ripristinare l\'abbonamento %1: È stato rimosso dal tuo account e non hai il permesso per creare abbonamenti. Per ripristinarlo, contatta il tuo service provider.',

    'backup__error11' => 'Spazio su disco insufficiente per il backup.',
    'backup__error3011' => 'La connessione è stata rifiutata: Nessun programma elencato sull\'indirizzo e la porta specificati.',
    'backup__error3012' => 'Timeout di connessione.',
    'backup__error3013' => 'La rete è irraggiungibile.',
    'backup__error3014' => 'Nessun percorso verso l\'host.',
    'backup__error3015' => 'Connessione non riuscita.',
    'backup__error3016' => 'Impossibile risolvere il nome host.',
    'backup__error3017' => 'Nome utente o password errati.',
    'backup__error3018' => 'Connessione SSH non riuscita.',

    'backup__error3110' => 'Impossibile connettere all\'agente di migrazione a distanza: La connessione all\'host non è disponibile.',
    'backup__error3111' => 'L\'agente di migrazione è bloccato da un\'attività di migrazione non riuscita o usato da un altro processo di migrazione. Riavvia l\'agente di migrazione sul server di origine.',
    'backup__error3112' => 'La connessione all\'host non è disponibile o l\'agente di migrazione non è in esecuzione sull\'host di origine.',
    'backup__error3113' => 'Impossibile implementare l\'agente di migrazione su un host Linux. Verifica la connessione SSH sull\'host di origine.',
    'backup__error3114' => 'Impossibile implementare l\'agente di migrazione su un host Linux: Connessione SSH non riuscita.',
    'backup__error3115' => 'Nome utente o password errati.',
    'backup__error3116' => 'L\'utente specificato non dispone di privilegi amministrativi.',

    'dns_t__unable_to_remove_ns_record' => 'Impossibile rimuovere il registro NS dal modello DNS: Ogni zona DNS deve avere almeno un registro NS.',
    'dns__unsupported_server_zone_transfer' => 'Impossibile trasferire il Modello di Restrizioni di Trasferimento a causa della configurazione DNS del server: Sul server di origine, i seguenti indirizzi di rete sono autorizzati al trasferimento di zona, ma tali indirizzi sono proibiti da Microsoft DNS Server: %1',
    'dns__unsupported_domain_zone_transfer' => 'Impossibile trasferire il Modello di Restrizioni di Trasferimento a causa della configurazione DNS dei domini: Su alcuni domini i seguenti indirizzi di rete sono autorizzati al trasferimento di zona, ma tali indirizzi sono proibiti da Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Impossibile accedere alla directory della rete temporanea per i fil di backup. Verifica la directory di rete, il nome utente e le impostazioni della password. Errore: %1',

    'dbbackup__temp_dir_wrong_value' => 'È stato specificato un valore non valido per la directory temporanea.',
    'dbbackup__network_temp_dir_wrong_value' => 'È stato specificato un valore non valido per la directory di rete temporanea.',
    'dbbackup__server_backup_not_configured' => 'Le impostazioni del backup del database non sono configurate nel server.',
    'dbbackup__temp_dir' => 'Directory temporanea',
    'dbbackup__temp_dir_hint' => 'Il percorso a una cartella fisica sul server remoto dove si trova il server MS SQL. Il server MS SQL deve essere in grado di accedere a questa cartella per la lettura e la scrittura di file di backup temporanei. Per esempio, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Il percorso verso la rete condivisa è stato attribuito alla cartella fisica indicata in precedenza. Plesk accederà alla cartella condivisa per scaricare e caricare file di backup. Per esempio, \\\\NomeServer\\PercorsoDirectory',
    'dbbackup__network_user_hint' => 'Il nome utente di un utente di rete creato sul server remoto. Per esempio, ServerName\\UserName. L\'utente deve essere autorizzato ad accedere alla cartella condivisa sopraindicata.',
    'dbbackup__network_password_hint' => 'La password dell\'utente della rete',

    'dbbackup__success_import_without_dublicate_users' => 'I seguenti utenti non sono stati importati: %1. Esistono già sul server database.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Comprimi i file di registro",
    'log_rot__log_rot_status' => "Stato di rotazione di log",
    'log_rot__log_rot_period' => "Condizione della rotazione di registri",
    'log_rot__log_rot_size' => "per dimensione",
    'log_rot__log_rot_time' => "per data",
    'log_rot__logrotation_enable' => "Attiva la rotazione dei file di registro",
    'log_rot__mail' => "Invia i log elaborati via e-mail",
    'log_rot__max_number_of_logfiles' => "Numero massimo di file di registro",
    'log_rot__time_period' => "periodo",
    'log_rot__unable_turn_off' => 'Impossibile disattivare la rotazione dei registri poiché viene imposta a livello del server',
    'log_rot__unable_set_period' => 'Impossibile definire un periodo di rotazione dei registri diverso da \'daily\', poiché viene imposto a livello del server',
    'log_rot__unable_set_max_log_files' => 'Impossibile definire un numero massimo di file di registro superiore al limite %1 per l’intero server',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Numero atteso: %1",
    'actionlog__incorrect_rotation' => "Parametri rotazione log non validi: %1",
    'actionlog__unknown_rot_period' => "Periodo di rotazione sconosciuto: %1",
    'actionlog__unknown_rot_type' => "Tipo di rotazione sconosciuto: %1",
    'actionlog__session_preferences' => 'Impostazioni della sessione',
    'actionlog__nis2_delete_prohibited' => 'Non è consentito rimuovere i record dei registri poiché sono in vigore le restrizioni della direttiva NIS2.',
    'actionlog__nis2_forbidden_rot_type' => "Non è possibile utilizzare Il tipo di rotazione di registri '%1' poiché sono in vigore le restrizioni della direttiva NIS2.",
    // items (PFU schema)
    'actionlog__admin_info' => 'Informazioni dell\'amministratore',
    'actionlog__admin_preferences' => "Preferenze dell'amministratore",
    'actionlog__service' => 'Servizio',
    'actionlog__ip_addr' => 'Indirizzo IP',
    'actionlog__client' => 'Account cliente',
    'actionlog__client_status' => 'Stato dell\'account cliente',
    'actionlog__client_preferences' => "Preferenze dell'interfaccia del cliente",
    'actionlog__client_ip_pool' => "Pool IP del cliente",
    'actionlog__client_siteapp' => "Pool di applicazioni web del cliente",
    'actionlog__client_guid' => "GUID del cliente",
    'actionlog__domain' => 'Dominio predefinito (il primo dominio aggiunto a un abbonamento)',
    'actionlog__domain_owner' => 'Proprietario dell\'abbonamento',
    'actionlog__domain_plan' => 'Piano di servizio della sottoscrizione',
    'actionlog__domain_status' => 'Dominio predefinito, stato',
    'actionlog__domain_dns' => 'Dominio predefinito, zona DNS',
    'actionlog__subdomain' => 'Sottodominio di un dominio predefinito',
    'actionlog__domain_alias' => 'Dominio predefinito, alias',
    'actionlog__domain_alias_dns' => 'Dominio predefinito, alias zona DNS',
    'actionlog__site' => 'Dominio',
    'actionlog__site_status' => 'Stato del dominio',
    'actionlog__site_dns' => 'Zona DNS del dominio',
    'actionlog__site_guid' => 'GUID del dominio',
    'actionlog__site_subdomain' => 'Sottodominio',
    'actionlog__site_alias' => 'Alias di dominio',
    'actionlog__site_alias_dns' => 'Zona DNS dell\'alias di dominio',
    'actionlog__domain_limits' => 'Limiti dell\'abbonamento',
    'actionlog__domain_limit_size' => 'Limite spazio su disco per l\'abbonamento',
    'actionlog__domain_limit_traffic' => 'Limite di traffico per l\'abbonamento',
    'actionlog__domain_limits_powerUser' => 'Limiti dell\'abbonamento',
    'actionlog__domain_limit_size_powerUser' => 'Limite spazio su disco per l\'abbonamento',
    'actionlog__domain_limit_traffic_powerUser' => 'Limite di traffico per l\'abbonamento',
    'actionlog__domain_guid' => "Dominio predefinito, GUID",
    'actionlog__cp_user' => 'Utente Plesk',
    'actionlog__mailname' => 'Account di posta',
    'actionlog__maillist' => 'Mailing list',
    'actionlog__phosting' => 'Impostazioni di hosting',
    'actionlog__forwarding' => 'Hosting d\'inoltro standard o frame',
    'actionlog__webuser' => 'Account Utente Web',
    'actionlog__site_application' => 'Applicazione web',
    'actionlog__license' => 'Chiave di licenza',
    'actionlog__additional_license' => 'Chiave di licenza aggiuntiva',
    'actionlog__template_domain' => "Piano di servizio del rivenditore",
    'actionlog__template_admin' => "Piano di servizio dell'amministratore",
    'actionlog__template_reseller' => 'Piano del rivenditore',
    'actionlog__admin_alias' => 'Account amministratore aggiuntivo', // PFW
    'actionlog__ftpuser' => 'Account FTP aggiuntivo', // PFW
    'actionlog__db_server' => 'Server database',
    'actionlog__db' => 'Database',
    'actionlog__db_user' => 'Account utente del database',
    'actionlog__client_sapppkg_pool' => "Applicazione web dell'utente", // PFW, not used?
    'actionlog__remote_dns' => 'Stato del server DNS remoto', // PFW
    'actionlog__reseller' => 'Account rivenditore',
    'actionlog__reseller_guid' => 'GUID del rivenditore',
    'actionlog__reseller_ip_pool' => "Pool d'IP del rivenditore",
    'actionlog__reseller_limit_size' => 'Limite dello spazio su disco per l\'account rivenditore',
    'actionlog__reseller_limit_traffic' => 'Limite del traffico per l\'account rivenditore',
    'actionlog__reseller_limits' => 'Limiti dell\'account rivenditore',
    'actionlog__reseller_permissions' => 'Permessi del rivenditore',
    'actionlog__reseller_preferences' => "Preferenze dell'interfaccia del rivenditore",
    'actionlog__reseller_siteapp' => "Applicazioni web nel pool del rivenditore",
    'actionlog__reseller_status' => 'Stato dell\'account rivenditore',
    'actionlog__health_status' => 'Stato d\'integrità del server.',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'raggiunto',
    'actionlog__added' => 'aggiunto',
    'actionlog__removed' => 'eliminato',
    'actionlog__change' => 'cambiato',
    'actionlog__update' => 'aggiornato',
    'actionlog__move' => 'spostato',
    'actionlog__upgrade' => 'aggiornato', // PFU?
    'actionlog__update_or_add' => 'aggiornato o aggiunto',
    'actionlog__expired' => 'scaduto',
    'actionlog__create' => 'creato',
    'actionlog__delete' => 'cancellato',
    'actionlog__service_stop' => 'arrestato',
    'actionlog__service_restart' => 'riavviato',
    'actionlog__service_start' => 'avviato',
    'actionlog__login' => 'connesso',
    'actionlog__logout' => 'disconnesso',
    'actionlog__install' => 'installato',
    'actionlog__uninstall' => 'Disinstallato',
    'actionlog__reconfigure' => 'riconfigurato',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Richiesta di ripristino della password',
    'actionlog__event_admin_update' => 'Informazioni dell\'amministratore aggiornate',
    'actionlog__event_admin_preferences_update' => "Preferenze aggiornate dell'amministratore",
    'actionlog__event_service_restart' => 'Servizio riavviato',
    'actionlog__event_service_start' => 'Servizio avviato',
    'actionlog__event_service_stop' => 'Servizio arrestato',
    'actionlog__event_ip_address_create' => 'Indirizzo IP creato',
    'actionlog__event_ip_address_delete' => 'Indirizzo IP eliminato',
    'actionlog__event_ip_address_update' => 'Indirizzo IP aggiornato',
    'actionlog__event_client_create' => 'Account cliente creato',
    'actionlog__event_client_delete' => 'Account cliente eliminato',
    'actionlog__event_client_update' => 'Account cliente aggiornato',
    'actionlog__event_client_status_update' => 'Lo stato dell\'account cliente è stato aggiornato',
    'actionlog__event_client_preferences_update' => "Preferenze dell'interfaccia del cliente aggiornate",
    'actionlog__event_client_siteapp_added' => "Applicazione web aggiunta al pool di applicazioni dell'account cliente",
    'actionlog__event_client_siteapp_removed' => "Applicazione web rimossa per il pool di applicazioni dell'account cliente",
    'actionlog__event_domain_limit_size_reached' => 'È stato raggiunto il limite dello spazio su disco per l\'abbonamento',
    'actionlog__event_domain_limit_traffic_reached' => 'È stato raggiunto il limite del traffico per l\'abbonamento',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'È stato raggiunto il limite dello spazio su disco per l\'iscrizione',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'È stato raggiunto il limite del traffico per l\'iscrizione',

    'actionlog__domain_limit_database' => 'Quota del database per l\'abbonamento',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Quota dei database MariaDB/MySQL per l\'abbonamento superata',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Quota flessibile dei database MariaDB/MySQL per l\'abbonamento superata',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Quota dei database del server Microsoft SQL per l\'abbonamento superata',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Quota flessibile dei database del server Microsoft SQL per l\'abbonamento superata',
    'actionlog__event_plesk_component_upgrade' => 'Componente di Plesk aggiornato',
    'actionlog__event_plesk_component_install' => 'Componente di Plesk installato',
    'actionlog__event_plesk_component_uninstall' => 'Componente di Plesk disinstallato',
    'actionlog__event_domain_create' => 'Dominio predefinito (il primo dominio aggiunto a un abbonamento) creato',
    'actionlog__event_domain_delete' => 'Dominio predefinito (il primo dominio aggiunto a un abbonamento) eliminato',
    'actionlog__event_domain_update' => 'Dominio predefinito (il primo dominio aggiunto a un abbonamento) aggiornato',
    'actionlog__event_domain_owner_change' => 'Il proprietario dell\'abbonamento è cambiato',
    'actionlog__event_domain_plan_change' => 'Piano di servizio della sottoscrizione modificato',
    'actionlog__event_domain_status_update' => 'Dominio predefinito, stato aggiornato',
    'actionlog__event_domain_dns_update' => 'Dominio predefinito, zona DNS aggiornata',
    'actionlog__event_subdomain_create' => 'Sottodominio di un dominio predefinito creato',
    'actionlog__event_subdomain_delete' => 'Sottodominio di un dominio predefinito eliminato',
    'actionlog__event_subdomain_update' => 'Sottodominio di un dominio predefinito aggiornato',
    'actionlog__event_domain_alias_create' => 'Dominio predefinito, alias creato',
    'actionlog__event_domain_alias_delete' => 'Dominio predefinito, alias eliminato',
    'actionlog__event_domain_alias_update' => 'Dominio predefinito, alias aggiornato',
    'actionlog__event_domain_limits_update' => 'Limiti dell\'abbonamento',
    'actionlog__event_cp_user_login' => 'Accesso utente Plesk riuscito',
    'actionlog__event_cp_user_logout' => 'Disconnessione utente Plesk riuscito',
    'actionlog__event_mailname_create' => 'Account di posta creato',
    'actionlog__event_mailname_delete' => 'Account di posta eliminato',
    'actionlog__event_mailname_clear' => 'Account di posta svuotato',
    'actionlog__event_mailname_update' => 'Account di posta aggiornato',
    'actionlog__event_maillist_create' => 'Lista di posta creata',
    'actionlog__event_maillist_delete' => 'Lista di posta eliminata',
    'actionlog__event_maillist_update' => 'Lista di posta aggiornata',
    'actionlog__event_phys_hosting_create' => 'Hosting fisico creato',
    'actionlog__event_phys_hosting_delete' => 'Hosting fisico eliminato',
    'actionlog__event_phys_hosting_update' => 'Hosting fisico aggiornato',
    'actionlog__event_forwarding_create' => 'È stato creato un hosting standard o un inoltro frame',
    'actionlog__event_forwarding_delete' => 'È stato eliminato un hosting standard o un inoltro frame',
    'actionlog__event_forwarding_update' => 'È stato aggiornato un hosting standard o un inoltro frame',
    'actionlog__event_webuser_create' => 'Account utente web creato',
    'actionlog__event_webuser_delete' => 'Account utente web eliminato',
    'actionlog__event_webuser_update' => 'Account utente web aggiornato',
    'actionlog__event_siteapp_install' => 'Applicazione web installata',
    'actionlog__event_siteapp_reconfigure' => 'Applicazione web riconfigurata',
    'actionlog__event_siteapp_uninstall' => 'Applicazione web disinstallata',
    'actionlog__event_license_update' => 'La chiave della licenza è stata aggiornata',
    'actionlog__event_admin_alias_create' => 'L\'account amminstratore aggiuntivo è stato creato',
    'actionlog__event_admin_alias_delete' => 'L\'account amminstratore aggiuntivo è stato eliminato',
    'actionlog__event_admin_alias_update' => 'L\'account amminstratore aggiuntivo è stato aggiornato',
    'actionlog__event_ftpuser_create' => 'Account FTP aggiuntivo creato',
    'actionlog__event_ftpuser_update' => 'Account FTP aggiuntivo aggiornato',
    'actionlog__event_ftpuser_delete' => 'Account FTP aggiuntivo annullato',
    'actionlog__event_template_domain_create' => "Piano di servizio del rivenditore creato",
    'actionlog__event_template_domain_update' => "Piano di servizio del rivenditore aggiornato",
    'actionlog__event_template_domain_delete' => "Piano di servizio del rivenditore annullato",
    'actionlog__event_template_admin_create' => "Piano di servizio dell'amministratore creato",
    'actionlog__event_template_admin_update' => "Piano di servizio dell'amministratore aggiornato",
    'actionlog__event_template_admin_delete' => "Piano di servizio dell'amministratore annullato",
    'actionlog__event_database_server_create' => 'Server database creato',
    'actionlog__event_database_server_update' => 'Server database aggiornato',
    'actionlog__event_database_server_delete' => 'Server database eliminato',
    'actionlog__event_remote_dns_status_update' => 'Lo stato del server DNS remoto è stato aggiornato',
    'actionlog__event_session_preferences_update' => 'Le impostazioni della sessione sono state aggiornate',
    'actionlog__event_domain_alias_dns_update' => 'Dominio predefinito, zona DNS di alias di dominio aggiornata',
    'actionlog__event_domain_move' => 'Dominio predefinito trasferito in un nuovo abbonamento',
    'actionlog__event_site_move' => 'Dominio trasferito in un nuovo abbonamento',
    'actionlog__event_site_subdomain_move' => 'Sottodominio trasferito in un nuovo abbonamento',
    'actionlog__event_subdomain_move' => 'Sottodominio di un dominio predefinito trasferito in un nuovo abbonamento',
    'actionlog__event_license_expired' => 'La licenza di Plesk è scaduta',
    'actionlog__event_database_create' => 'Database creato',
    'actionlog__event_database_delete' => 'Database eliminato',
    'actionlog__event_database_user_create' => 'Account utente del database creato',
    'actionlog__event_database_user_update' => 'Impostazioni dell\'account utente del database aggiornate',
    'actionlog__event_database_user_delete' => 'Account utente del database eliminato',
    'actionlog__event_client_guid_update' => "GUID del cliente aggiornato",
    'actionlog__event_domain_guid_update' => 'Dominio predefinito, GUID aggiornata',
    'actionlog__event_reseller_create' => 'Account rivenditore creato',
    'actionlog__event_reseller_delete' => 'Account rivenditore eliminato',
    'actionlog__event_reseller_update' => 'Account rivenditore aggiornato',
    'actionlog__event_reseller_guid_update' => 'Il GUID del rivenditore è stato aggiornato',
    'actionlog__event_reseller_ip_pool_update' => "Il pool d'IP del rivenditore è stato aggiornato",
    'actionlog__event_reseller_limit_size_reached' => 'Il limite dello spazio su disco per l\'account rivenditore è stato raggiunto',
    'actionlog__event_reseller_limit_traffic_reached' => 'Il limite del traffico per l\'account rivenditore è stato raggiunto',
    'actionlog__event_reseller_limits_update' => 'I limiti dell\'account rivenditore sono stati aggiornati',
    'actionlog__event_reseller_permissions_update' => 'I permessi dell\'account rivenditore sono stati aggiornati',
    'actionlog__event_reseller_preferences_update' => "Le preferenze dell'interfaccia del rivenditore sono state aggiornate.",
    'actionlog__event_reseller_siteapp_added' => "L'applicazione è stata aggiunta al pool di applicazioni dell'account rivenditore.",
    'actionlog__event_reseller_siteapp_removed' => "L'applicazione è stata rimossa dal pool di applicazioni dell'account rivenditore.",
    'actionlog__event_reseller_status_update' => 'Lo stato dell\'account rivenditore è stato aggiornato',
    'actionlog__event_template_reseller_create' => 'Piano del rivenditore creato',
    'actionlog__event_template_reseller_delete' => 'Piano del rivenditore annullato',
    'actionlog__event_template_reseller_update' => 'Piano del rivenditore aggiornato',
    'actionlog__event_health_status_change' => 'Lo stato d\'integrità del server è cambiato',
    'actionlog__event_siteapp_upgrade' => 'App web aggiornata',
    'actionlog__event_extension_install' => 'Estensione installata',
    'actionlog__event_extension_uninstall' => 'Estensione disinstallata',
    'actionlog__event_extension_upgrade' => 'Estensione aggiornata',
    'actionlog__event_extension_status_update' => 'Stato dell’estensione aggiornato',
    'actionlog__event_additional_license_expired' => 'La licenza aggiuntiva è scaduta',
    'actionlog__event_hostname_changed' => 'Nome host del server cambiato',
    'actionlog__event_smb_user_create' => 'Utente aggiuntivo creato',
    'actionlog__event_smb_user_delete' => 'Utente aggiuntivo eliminato',
    'actionlog__event_smb_user_update' => 'Utente aggiuntivo aggiornato',
    'actionlog__dns_record' => 'Record DNS',
    'actionlog__dns_zone' => 'Zona DNS',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "L'API RPC di Plesk non è installata nell'host remoto. Contatta il tuo service provider per richiedere assistenza.",
    'rsession_no_account_errmsg' => "Impossibile accedere al servizio remoto tramite il tuo account. La ragione più comune è che il servizio non è stato ancora attivato per il tuo account. Prego attendi qualche minuto, e riprova. Se si verifica nuovamente l'errore, contatta il tuo amministratore di sistema.",
    'rsession_no_domain_errmsg' => "Impossibile accedere al servizio remoto per questo dominio. La ragione più comune è che il servizio non è stato ancora attivato per questo dominio. Prego attendi qualche minuto, e riprova. Se si verifica nuovamente l'errore, contatta il tuo amministratore di sistema.",
    'rsession_unknown_errmsg' => "Il server remoto ha rifiutato il tentativo di stabilire una sessione. Contatta il tuo amministratore di sistema per il supporto. L'errore era: %1",
    'rsession_unknown2_errmsg' => "Si è verificato un errore sconosciuto cercando di stabilire la sessione remota. Probabilmente il server remoto non risponde correttamente o non risponde affatto. Richiedi al tuo amministratore di sistema di controllare i dettagli sull'errore nel log di errori del server web.",
    'rsession_no_connect_errmsg' => "Impossibile accedere al servizio remoto: connessione fallita alla sessione remota. Contatta il tuo amministratore di sistema per il supporto.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Consenti il caricamento nella directory in arrivo",
    'anonftp__allow_create_dirs' => 'Permetti la creazione di directory nella directory in arrivo',
    'anonftp__allow_download_incoming' => 'Permetti il download dalla directory in arrivo',
    'anonftp__display_login' => 'Mostra messaggio di login',
    'anonftp__login_text' => 'Testo del messaggio',
    'anonftp__limit_incoming_disk_space' => "Limite spazio nella directory in arrivo",
    'anonftp__limit_maximum_bandwidth' => "Limite banda in download per questo dominio virtuale FTP",
    'anonftp__limit_maximum_connections' => "Limite connessioni simultanee",
    'anonftp__unable_init' => "Impossibile inizializzare l'account per FTP anonimo: %1",
    'anonftp__unable_set_quota' => "Impossibile impostare i limiti di spazio nella directory in arrivo: %1",
    'anonftp__unable_update' => "Impossibile aggiornare le proprietà del FTP anonimo: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certificati SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Il certificato CA non valida il certificato.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Coppia di certificato/chiave privata incompatibile",
    'class_sslcertificate__invalid_cert_format' => "Formato certificato non valido.",
    'class_sslcertificate__invalid_private_key_format' => "Formato della chiave privata non valido.",
    'class_sslcertificate__prob_invalid_priv_key' => "Probabilmente il formato della chiave privata non è valido.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Nessun file da scaricare.',
    'login_up__access_denied_no_permission' => "Accesso negato. Non hai permessi di accesso.",
    'mail__unable_remove_pattern' => "Impossibile rimuovere l'indirizzo dalla lista nera del server: %1", // PFW
    'mail__incorrect_network_format' => 'Formato di rete non valido: %1', // PFW
    'initconf__unable_change_passwd' => "Impossibile cambiare la password dell'amministratore: %1",
    'initconf__unable_get_passwd' => 'Impossibile ottenere la password dell’amministratore corrente: %1 errore: %2',
    'initconf__invalid_hostname' => 'Errore nel nome host "%1"',
    'initconf__unable_reconfig' => 'Impossibile configurare Plesk: errore riconfig: %1',
    'initconf__unable_update_admin' => 'Impossibile aggiornare le informazioni di contatto dell’amministratore: %1',
    '__refresh' => 'Aggiorna',
    '__dalias_not_exist' => 'L\'alias del dominio non esiste',
    '__bug146523_explanation' => 'Le versioni precedenti di Plesk consentivano di usare fino a 16 caratteri per i nomi utente FTP. Questa versione di Plesk limita a 15 il numero massimo di caratteri consentiti nei nomi utente FTP. Per risolvere questo problema, riduci la lunghezza del nome utente FTP a 15 caratteri per i nomi utente FTP coinvolti e cambia almeno un carattere nei nomi utente FTP coinvolti per evitare problemi di collisione nei nomi utente. Siamo spiacenti per qualsiasi inconveniente causato da questa modifica.',
    'domain__cannot_change_webmail' => 'Impossibile cambiare il webmail per il dominio: %1',
    'sb_publish_disable_warning' => 'Disattivando la creazione di siti web con Presence Builder, il sito web creato in precedenza con Presence Builder verrà rimosso e si perderanno tutti i dati del sito web. Fai clic su OK per continuare.',
    '__sbnet_client_use_sbnet' => "Crea un account utente corrispondente in Presence Builder",
    'mail_resp_activate' => 'Attiva risposta automatica',
    'limitsManger__limit_available_error' => 'Impossibile assegnare la quantità richiesta di risorse ("%%limitName%%"): solo %%available%% è disponibile per il vostro account.',
    'limitsManger__limit_reserved_error' => 'Impossibile assegnare meno risorse ("%%limitName%%") di quelle già usate.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Impossibile rinominare il dominio: Esiste già una directory virtuale con lo nome specificato.',
    'domain_unable_to_rename' => 'Impossibile rinominare il dominio.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Generale',
    'spamfilter__spamassassin_status_legend' => 'Filtro spam di SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Impostazioni SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Attivare il filtro spam SpamAssassin del server",
    'spamfilter__spamassassin_user_status_legend' => 'Attivare il filtro spam SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Attivare la protezione spam di greylisting del server',
    'spamfilter__personal_settings_not_allowed' => 'L\'utilizzo delle impostazioni individuali del filtro spam non è consentito dalle norme di sistema.',
    'spamfilter__required_score' => 'Il punteggio che un messaggio deve ricevere per essere qualificato come spam',
    'spamfilter__rewrite_header_subject' => 'Aggiungi il seguente testo all\'inizio dell\'oggetto di ogni messaggio riconosciuto come spam:',
    'spamfilter__use_mailuser_prefs' => 'Applica le impostazioni personali al filtro antispam',
    'spamfilter__score_error' => 'Il punteggio non deve essere negativo, la parte prima del punto decimale deve essere inferiore a 100 e dopo il punto decimale possono essere incluse non più di due cifre.',
    'spamfilter__rewrite_header_error' => 'L\'oggetto del messaggio può contenere qualsiasi carattere stampabile tranne il simbolo del cancelletto (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Respingere',
    'nonexistent_mail__mode_discard' => 'Escludere',
    'nonexistent_mail__mode_catch_addr' => 'Inoltro a indirizzo e-mail',
    'nonexistent_mail__mode_catch_ip' => 'Inoltro a IP',
    'nonexistent_mail__bounce_not_supported' => 'La modalità rimbalzo non è supportata',
    'nonexistent_mail__discard_not_supported' => 'Escludere la modalità non supportata',
    'nonexistent_mail__catch_not_supported' => 'Inoltro all\'indirizzo e-mail non supportato',
    'nonexistent_mail__redirect_not_supported' => 'L\'inoltro a IP non è supportato',
    'nonexistent_mail__ip_used_on_this_host' => 'L\'indirizzo IP risolve all\'host locale',
    'nonexistent_mail_address_should_be_local_domain' => 'Poiché il controllo della posta in uscita è attivato, l\'indirizzo email %1 per i destinatari inesistenti devono appartenere al dominio selezionato. In caso negativo, verranno applicate le normative di "Rifiuto" invece di quelle d\'inoltro.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Poiché Controllo posta in uscita è attivato, l\'indirizzo email specificato per l\'inoltro della posta (%1) deve appartenere al dominio selezionato. Altrimenti, i messaggi inviati a questo indirizzo non saranno contati in Controllo della posta in uscita.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // scripting languages errors
    'phosting__aspdotnet_not_enabled' => 'Il supporto ASP.NET è disattivato per questo sito web.',
    'phosting__php_forced_by_site_isolation' => 'Impossibile cambiare le impostazioni PHP: il permesso per sovrascrivere le normative di sicurezza del server non è consentito.',
    'phosting__option_forced_by_site_isolation' => 'Impossibile cambiare le impostazioni di %1: il permesso per sovrascrivere le normative di sicurezza del server non è consentito.',
    'phosting__php_handler_id_not_registered' => 'Il gestore PHP non è consentito nelle impostazioni d\'isolamento del sito. Verrà usato il gestore PHP predefinito.',
    'phosting__php_served_by_nginx_is_not_available' => 'Il gestore PHP (applicazione FPM servita da nginx) non è consentito nelle impostazioni d\'isolamento del sito. Sarà usato il gestore PHP predefinito.',

    // tooltips

    'b_get_password_cancel' => 'Torna alla schermata precedente senza inviare l\'e-mail.',
    'b_get_password_send' => 'Fai clic su OK per inviare un messaggio di recupero della password all\'indirizzo e-mail registrato nel sistema.',

    'b_back' => 'Torna alla pagina precedente.',
    'b_next' => 'Accedi alla pagina successiva.',

    'b_dnsnstemplatelist_remove' => 'Cancella i name server selezionati.',
    'b_dnsnstemplatelist_search' => 'Inserisci un modello di ricerca e clicca per cercare i name server.',
    'b_dnsnstemplatelist_show_all' => 'Mostra tutti i name server.',

    'l_dnsnstemplatelist_ns' => 'Ordinare i record del modello DNS per server di nomi.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Genera link protetti per file e cartelle',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Abilita cartelle pubbliche',
    'cu__serverfilesharing_fsPublicFolder' => 'Cartella per l\'archiviazione di file pubblici',
    'cu__serverfilesharing_fsPublicUrl' => 'URL per l\'accesso dei visitatori ai file pubblici',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Abilita protezione da password dei file pubblici',
    'cu__serverfilesharing_fsPartnerFolder' => 'Cartella per l\'archiviazione di file protetti da password',
    'cu__serverfilesharing_fsPartnersLogin' => 'Nome utente per l\'accesso ai file',
    'cu__serverfilesharing_fsPartnersPassword' => 'Password per l\'accesso ai file',
    'cu__serverfilesharing_fsDomain' => 'URL root della cartella web. Nome di dominio',
    'cu__serverfilesharing_fsPrefix' => 'URL root della cartella web. Prefisso',
    'cu__serverfilesharing_commandUpdate' => 'Aggiorna le impostazioni di condivisione di file',
    'cu__serverfilesharing_commandInfo' => 'Visualizza le correnti impostazioni di condivisione di file.',
    'subscription_rename_is_forbidden' => 'Rinominare gli abbonamenti è proibito dalle normative del server.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///
    ///

    //Additional FTP Accounts
    'ftp__management_domain' => "Account FTP sotto il dominio %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Account FTP",
    'ftp__user_name' => "Nome account FTP",
    'ftp__user_home' => "Directory principale",
    'ftp__invalid_path' => "Percorso specificato non valido",
    'i_ftp_ses_sub_user' => 'Sessione account FTP.',
    '__new_passwd' => "Nuova password per %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Impossibile configurare un server web sull\'host <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Impossibile generare il file di configurazione del server web sull'host <%%host%%> a causa dei seguenti errori:\n\n%%error%%\n\nRisolvi gli errori nei modelli di configurazione del server web e genera il file nuovamente.",

    'apacheConfigurationMessageAdminTitle' => 'La creazione della configurazione del server web non è riuscita',
    'apacheConfigurationMessageClientTitle' => 'Avvertenza',

    'apacheConfigurationFailedAdminHomeMessage' => 'Il nuovo file di configurazione non è stato creato a causa di alcuni errori presenti nei modelli di configurazione. È stato inviato un messaggio con i dettagli sull\'errore al tuo indirizzo e-mail. Verifica la posta elettronica, risolvi gli errori e fai clic su %1 per provare a generare la configurazione nuovamente.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'qui', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'La nuova configurazione per il dominio %1 non è stata creata a causa di alcuni errori presenti nei modelli di configurazione. È stato inviato un messaggio con i dettagli sull\'errore al tuo indirizzo e-mail. Verifica la posta elettronica, risolvi gli errori e fai clic su %2 per provare a generare di nuovo la configurazione.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'qui', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'La configurazione del server web per il dominio %1 potrebbe non essere coerente. Contattare l\'amministratore del server per risolvere il problema.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'La nuova configurazione per alcuni domini non è stata creata a causa di alcuni errori presenti nei modelli di configurazione. È stato inviato un messaggio con i dettagli sull\'errore al tuo indirizzo e-mail. Verifica la posta elettronica, risolvi gli errori e fai clic su %1 per provare a generare la configurazione nuovamente.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'qui', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'La configurazione del server per alcuni dei tuoi domini potrebbe non essere coerente. Contattare l\'amministratore del server per risolvere il problema.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Documenti di errore personalizzati",
    'dom_pref__webusers_script' => "Consenti agli utenti web di usare script",
    '__seoRedirect' => 'Configura il dominio preferito come',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Nessuno',

    '__sites' => 'Domini',
    'domain_plan__perm_denied_manage_phosting' => 'Non hai permessi per gestire le impostazioni di hosting.',
    '__owned_by_client' => 'proprietà del cliente',
    'backup__restore__object_client_template' => 'Modello di cliente',
    '__template_name' => 'Nome del piano di servizio',
    'template__not_exists' => 'Questo piano di servizio non è presente',
    'template__exists' => 'Esiste già un piano con il nome %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'L\'indirizzo IP specificato non è nel pool del rivenditore.',
    '__owner_name' => 'Proprietario del piano di servizio',

    'chown__error_check' => 'Si sono verificati alcuni problemi nel tentativo di assegnare alcuni degli abbonamenti ad un nuovo proprietario.',

    '__redirect_hint' => 'Verrai reindirizzato al nuovo indirizzo entro 15 secondi... Se non vieni automaticamente reindirizzato verso il nuovo percorso, abilita javascript o clicca sull\'hyperlink %%link%%.',

    'backup__restore__object_maillist' => 'Mailing list',
    'backup__restore__object_site' => 'Sito',
    'backup__restore__object_user' => 'Utente',
    'backup__restore__object_role' => 'Ruolo',

    'limit__name_max_site' => 'siti',

    'iis_pool__unable_rename_client' => "Impossibile rinominare il pool di applicazioni IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Il servizio FTP Anonimo è supportato solo per il dominio principale di un abbonamento.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Il servizio FTP Anonimo è supportato solo per il dominio principale di un abbonamento.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/mese',
    '__tb_month' => 'TB/mese',

    '__customer_total' => 'Totale Cliente',
    '__site' => 'Sito',
    '__def_site' => 'Sito predefinito',
    '__subscription_name' => 'Nome abbonamento',
    '__subscription_name_powerUser' => 'Nome dell\'abbonamento',

    'limit__units_max_traffic_suffix' => '/mese',

    'dom_pref__discard' => "Rifiuta",

    'mail__pattern_already_exists' => 'Il modello "%1" è già nella lista nera.',

    '__not_supported' => 'Non supportato',

    'plesk_key__sitebuilder' => 'Siti pubblicati con Presence Builder',
    'limit__name_max_site_builder' => 'Siti pubblicati con Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Supporto per i siti multilingue in Presence Builder',

    'login_up__access_denied_no_subscriptions' => "Accesso negato. Non ci sono abbonamenti disponibili per questo account",

    'interval__day' => '%1 giorno(i)',
    'interval__hour' => '%1 ora(e)',
    'interval__minute' => '%1 minuto(i)',
    'interval__second' => '%1 secondo(i)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Stai cercando di usare una chiave di licenza creata per un\'altra versione di Plesk. Contatta i rappresentanti Plesk per ottenere una chiave di licenza adeguata.',
    //Standalone or virtualization
    'virtualization_any' => "Server fisico o qualsiasi soluzione di virtualizzazione",
    'virtualization_pvc' => "Virtuozzo containers",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Server Virtuozzo",
    'plesk_key__virtualization' => "Valido per i seguenti ambienti:",
    'plesk_key__virtualization_only_key' => 'La chiave di licenza è destinata solo all\'utilizzo con Plesk, funzionando all\'interno di un ambiente virtuale %1.',
    'plesk_key__virtualizations_only_key' => 'La chiave di licenza è destinata solo all\'utilizzo con Plesk, funzionando nei seguenti ambienti virtuali: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'L\'utilizzo dei language pack personalizzati non è consentito',
    'plesk_key__allowed-locales' => 'Lingue disponibili',
    'plesk_key__allowed-locales-any' => 'Qualsiasi linguaggio',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'la directory cgi-bin si trova in',
    '_cgi_bin_mode_webspace' => 'la directory principale dell\'abbonamento',
    '_cgi_bin_mode_www_root' => 'la directory principale di questo dominio',

    /// Custom buttons
    'custom_button__sort_key' => 'Priorità',
    'custom_button__place' => 'Posizione',
    'custom_button__place_navigation' => 'Accesso comune',
    'custom_button__place_admin' => 'Home page Amministratore',
    'custom_button__place_admin-settings' => 'Pagina Impostazioni e Strumenti dell\'Amministratore',
    'custom_button__place_reseller' => "Home page del rivenditore",
    'custom_button__place_reseller-settings' => 'Pagina Utility e Strumenti Rivenditore',
    'custom_button__place_client' => 'Home page del cliente',
    'custom_button__place_domain' => "Pagina Siti Web e Domini dell'abbonamento",
    'custom_button__place_domain_powerUser' => "Pagina Siti Web e Domini dell'abbonamento",
    'custom_button__place_domain-properties' => 'Strumenti del Sito Web',
    'custom_button__private' => 'Mostra solo a me',
    'custom_button__image' => 'Immagine di sfondo',
    'custom_button__conhelp' => "Testo di aiuto",
    'custom_button__edit' => "Impostazioni di un link a un servizio aggiuntivo",
    'custom_button__include_client_cname' => "Comprende il nome della società del cliente",
    'custom_button__include_client_email' => "Includi e-mail del cliente",
    'custom_button__include_client_id' => "Includi ID cliente",
    'custom_button__include_client_pname' => "Comprende il nome di contatto del cliente",
    'custom_button__include_domain_id' => "Includi ID abbonamento, ID dominio e ID dell'alias del dominio",
    'custom_button__include_domain_id_powerUser' => "Includi ID abbonamento, ID dominio e ID dell'alias del dominio",

    'custom_button__include_domain_name' => "Comprende il nome del dominio principale",
    'custom_button__include_ftp_user' => "Includi nome utente FTP",
    'custom_button__include_ftp_pass' => "Includi password FTP",
    'custom_button__internal_open' => "Apri URL in Plesk",
    'custom_button__text' => "Etichetta del pulsante",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Il file non è un file d\'immagine.',
    'custom_button__big_image' => 'La dimensione del file non deve superare i 100 KB.',
    'custom_button__failed_copy_image' => 'Impossibile copiare il file: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Impossibile ripristinare un backup che non sia Power User in visualizzazione Power User.',
    '__unknown_network_interface' => 'Interfaccia di rete sconosciuta',

    'init_conf__ip_address' => 'Indirizzo IP',

    //Confirmation page
    'bt_confirm' => 'Conferma',
    'b_confirm' => 'Conferma la proprietà dei tuoi siti.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Le impostazioni del pool di applicazioni IIS dedicato sono definite secondo le norme di sicurezza per tutto il server (configurazione dell\'isolamento del sito)',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Le impostazioni del pool di applicazioni IIS dedicato sono definite secondo le impostazioni della performance di tutto il server',

    '__current' => 'Corrente',

    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Hai usato quasi tutti i domini forniti con la licenza di Plesk (il 90% o anche di più).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Hai usato quasi tutti i domini',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Hai usato quasi tutti i siti di Presence Builder forniti con la licenza di Plesk (il 90% o anche di più).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Hai usato quasi tutti i siti di Presence Builder.',
    'promo__button_hide' => 'Nascondi',
    'promo__button_next' => 'Avanti >>',
    'promo__button_prev' => '<< Indietro',
    'promo__button_license' => 'Aggiorna licenza',

    'promo__google_integration_title' => 'Integrazione con i servizi Google',
    'promo__google_integration' => 'Configura l\'integrazione con i servizi Google, come AdSense, Google Apps e strumenti per Webmaster.',
    'promo__google_integration_button' => 'Configura',

    'promo__button_learn_more' => 'Maggiori informazioni',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'È possibile personalizzare l\'aspetto dell\'interfaccia e le impostazioni di branding mediante i temi personalizzati. Per le istruzioni sulla personalizzazione dei temi di Plesk, consultare %1.',
    'panel_branding__description_link' => 'il seguente documento',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Estrai file',
    'filemanager_error_extracting_files' => 'Si è verificato un errore durante l\'estrazione dei file dell\'archivio: %1',
    'filemanager_no_archive_files_specified' => 'Indica gli archivi che desideri estrarre.',
    'filemanager_not_zip_archive_specified' => 'Impossibile estrarre %1. Non è un archivio ZIP.',
    'filemanager_files_successfully_extracted' => 'I file dell\'archivio sono stati estratti.',
    'filemanager_error_file_download' => 'Download del file non riuscito:%1',
    'filemanager__user_poolgrp' => 'Gruppo del pool di applicazioni',

    'loading' => 'Caricamento in corso...',
    'bt_create_archive' => 'Aggiungi all\'archivio',
    'filemanager__pack' => "Percorso all'archivio: %1",
    'filemanager__archive_name' => 'Nome del file dell\'archivio',
    'filemanager__empty_filename' => 'Inserisci il nome del file dell\'archivio.',
    'filemanager_archive_created' => 'L\'archivio è stato correttamente creato.',
    'filemanager_error_creating_archive' => 'Impossibile creare l\'archivio: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Questo registro entrerà in conflitto con il registro AAAA per la zona.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Il server FTP non supporta indirizzi IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Questo record contrasterà con il glue record per la zona \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Il server FTP non supporta indirizzi IPv6.)",
    '__ipv6_not_supported' => 'IPv6 non è supportato.',
    'mail__ipv6_not_supported' => 'IPv6 non è supportato dal server di posta.',
    'mail__relay_while_list_ipv6_not_supported' => 'Lista bianca di relay IPv6 non supportata dal server di posta.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Il valore della maschera deve essere un multiplo di 16.',
    'mail__ip_or_mask_is_invalid' => 'Maschera o indirizzo IP non validi.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Inoltro a indirizzi IPv6 IP non supportato.',
    'sa__invalid_trusted_networks' => 'Reti affidabili specificate erroneamente: %1',
    'dns_add__enter_ipv6_address' => "Indirizzo IPv6",
    'license_trial_days_left' => 'Plesk sta funzionando con una licenza di prova che scadrà entro %1 giorni.',
    'excl_ipv6_num' => 'Indirizzi IPv6 dedicati',
    '__ip_mask' => "Subnet mask",
    '__ipv4_addr' => 'Indirizzi IPv4',
    '__ipv6_addr' => 'Indirizzo IPv6',
    'template__num_excl_ipv6s' => 'Assegna indirizzi IPv6 dedicati al rivenditore',
    'anonftp__exclusive_ipv4_required' => 'È richiesto un indirizzo IPv4 dedicato per configurare e usare il servizio FTP anonimo.',
    'anonftp__ipv4_already_used' => 'Non è possibile configurare il servizio FTP anonimo per questo sito perché è già stato configurato per un altro dominio sullo stesso indirizzo IPv4.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'Visualizza il registro',

    'chown__error_ip_absent_in_ip_pool' => 'L\'indirizzo IP %1 non è presente nel pool IP dell\'utente di destinazione.',
    'chown__error_ip_not_exist' => 'L\'indirizzo IP con \'%1\' è inesistente.',
    'chown__error_domain_ip_not_selected' => 'Almeno un indirizzo IP deve essere selezionato per il dominio %1. Verifica i valori selezionati per la mappatura IP.',

    'mail__ip_or_mask_is_invalid_ipv6' => 'L\'indirizzo IPv6 o maschera non sono validi: L\'indirizzo IP deve essere un indirizzo unicast valido.',

    '__subscriptions' => 'Abbonamenti',

    '__owned_by_reseller' => 'proprietà del rivenditore',
    '__owned_by_provider' => 'proprietà del provider',

    'service_plan__anonymous' => 'Personalizza',
    'subscription_not_locked__change_limits_warning' => 'Questo abbonamento non è bloccato: I limiti di utilizzo della risorsa saranno modificati durante la sincronizzazione con il piano di servizio.',
    'subscription_not_locked__change_permissions_warning' => 'Questo abbonamento non è bloccato: I permessi saranno modificati durante la sincronizzazione con il piano di servizio.',

    'subscription__conflict_resolution_policy' => 'Norme sulla risoluzione di conflitti',
    'subscription__conflict_resolution_policy_lock' => "Blocca abbonamento",

    'backup__list__backup_warnings' => 'Avvisi',
    'backup__list__backup_info' => 'Informazione',
    'backup__restore__object_reseller_template' => 'Modello di rivenditore',
    'backup__restore__object_domain_template' => 'Modello di dominio',

    'subscription__unable_lock_anonymous' => 'Questo abbonamento non è vincolato a un piano di servizio e quindi non può essere sbloccato.',
    'subscription__unable_sync_anonymous' => 'Questo abbonamento non è vincolato a un piano di servizio e quindi non può essere sincronizzato.',
    'subscription__unable_sync_locked' => 'Questo abbonamento è bloccato e quindi non può essere sincronizzato.',
    'subscription__locked' => 'L\'abbonamento è bloccato.',
    'component_name__urlrewrite' => "Riscrivi URL",
    '__quantity' => 'Quantità',
    'hst__www_root_dir_absent' =>  'Attenzione: La directory specificata come radice del documento non esiste.',
    'object_creation__domain_is_not_a_webspace' => 'Questo oggetto può essere creato soltanto in un abbonamento.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'L\'abbonamento contiene siti, pertanto non è possibile cambiare tipo di hosting o eliminarlo.',
    'phosting__apache_error_docs_are_not_enabled' => 'I documenti di errore personalizzati non sono abilitati su questo dominio.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Errore: impossibile aggiornare l’indirizzo IP. Ai domini aggiuntivi non è possibile assegnare un indirizzo IP non assegnato al dominio principale dell’abbonamento.',
    'domain_plan__unable_change' => 'Impossibile cambiare il piano di servizio: %1.',
    'domain_plan__different_hosting_type' => 'Il tipo di hosting attuale è diverso dal tipo indicato nel piano di servizio specificato.',
    'domain_plan__addon_text' => 'Piano di componente aggiuntivo',
    'domain_plan__addon_description' => 'Il piano del componente aggiuntivo è usato come supplemento di un piano di hosting.',
    'asp_net__managed_runtime_version' => 'Versione in fase di esecuzione gestita ASP.NET',
    'plan__can_not_change_hosting_type' => 'Non è possibile cambiare il tipo di hosting quando si modifica un piano.',
    'plan__apply_problems' => 'Il piano non è stato applicato a causa di problemi con la seguente funzionalità: %1',
    'plan_save__subscription_update_problem' => 'Impossibile applicare le modifiche del piano a %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "L'abbonamento è temporaneamente sospeso finché la procedura di backup o di ripristino sia completata. Tornare in seguito.",
    '__login_incorrect_plain_shadow_password' => 'Hai specificato una password non valida per l\'account amministratore. Usa le credenziali dell\'amministratore di sistema (root) oppure ottieni la password corretta. Per maggiori informazioni su come ottenere la password, leggi il file /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Non puoi inviare un indirizzo IP che non ti appartiene',

    'dns__dns_zone_not_synchronized' => 'La zona DNS è stata modificata. Se desideri applicare modifiche del modello DNS a questa zona, fai clic sul pulsante \'Applica Modifiche del modello DNS\' su questa pagina o cambia l\'opzione \'Applica modifiche a tutte le zone\' nel Pannello di Amministrazione del Server > Strumenti e Impostazioni > Impostazioni del Modello DNS > Applica modifiche del modello DNS.',
    'dns__dns_zone_synchronize_link' => 'Fai clic',
    'dns__dns_zone_synchronize_done' => 'La zona DNS è stata correttamente sincronizzata.',

    'dns__dns_zone_template_error' => 'Si sono verificati problemi durante la sincronizzazione delle zone DNS con il modello di zona DNS.%1',

    'dns__soa_rname_type_owner' => 'Indirizzo e-mail del proprietario del sito Web',
    'dns__soa_rname_type_domain' => 'Indirizzo e-mail non valido',
    'dns__soa_rname_type_external' => 'Indirizzo esterno non valido',
    'dns__soa_rname_enforce_email' => 'Vieta di modificare l’indirizzo e-mail RNAME dominio per dominio',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'L’indirizzo e-mail della persona responsabile per la zona DNS del dominio. Restituito dal server DNS in risposta a query SOA.',

    'dns__dns_zone_soa_sync_title' => 'Sostituisci le impostazioni SOA per tutti i domini esistenti',
    'dns__dns_zone_soa_sync_legend' => 'Conferma necessaria',
    'dns__dns_zone_soa_sync_text' => 'Aggiornare i record SOA di tutti i domini ospitati applicando le modifiche effettuate al modello SOA?',

    'cu_db__repair_mysql_dbus' => "Ripara le password utente di MariaDB/MySQL. Questa operazione è necessaria se hai aggiornato Plesk 11 da versioni precedenti.",

    'cu_scheduled_backup_comment' => 'Backup pianificato',
    'cu_scheduled_backup_error' => 'Si è verificato un errore durante il processo di backup: %1.',
    'cu_scheduled_backup_mail_subject' => '<%1> Si è verificato un errore durante il backup pianificato.',
    'cu_scheduled_backup_mail_message' => "%1\nPunto di ingresso a Plesk: %2 \n\nDurante il processo di backup pianificato si sono verificati i seguenti errori: \n\n%3",

    'cu_scheduled_backup_hourly' => 'Backup orario',
    'cu_scheduled_backup_daily' => 'Backup giornaliero',
    'cu_scheduled_backup_weekly' => 'Backup settimanale',
    'cu_scheduled_backup_monthly' => 'Backup mensile',
    'cu_scheduled_backup_comment_backup_all' => '%1. Tutta la configurazione e il contenuto.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Tutta la configurazione e il contenuto, tranne i messaggi di posta.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Solo configurazione e messaggi di posta.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Tutta la configurazione e il contenuto, tranne i database dell\'utente.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Tutta la configurazione e il contenuto, tranne i file dell\'utente.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Solo configurazione e database dell\'utente.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Solo configurazione e file dell\'utente',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Configurazione del dominio.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'La memorizzazione dei backup pianificati in un archivio remoto sul cloud è una funzionalità Premium. Contatta il tuo provider di hosting per sbloccarla.',

    'i_backup_invalid_file' => 'Questo non è un backup valido. I dati non possono essere ripristinati da questo file. Fai clic sul nome del backup per maggiori dettagli.',

    'filemanager_resulting_archive_exists' => 'Il file %1 esiste già nella directory di destinazione.',

    'agent_unable_to_connect' => 'Impossibile connettere all\'agente su \'%2\'. Accertati che l\'agente sia installato e in esecuzione e che non ci siano problemi di connessione con l\'host \'%2\'.',
    'agent_test_connection_failed' => 'Connessione all\'agente su \'%2\' non riuscita.',

    'agent_unable_to_resolve_host' => 'Impossibile trovare l\'host remoto \'%1\'. Accertati che non ci siano problemi di connessione con l\'host.',
    'agent_unknown_curl_error' => 'L\'errore \'%1\' si è verificato durante la connessione all\'agente in \'%2\'.',
    'agent_unexpected_htp_code' => 'È stato ricevuto il codice HTTP inaspettato \'%1\' sulla richiesta HTTP all\'agente in \'%2\'.',
    'agent_unable_to_auth' => 'Autenticazione non riuscita nell\'host \'%1\'. Per risolvere questo problema, seguire le istruzioni su http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Si è verificato un errore interno del server durante l\'esecuzione del comando sull\'host remoto \'%1\'.',
    'agent_response_is_empty' => 'È stata ricevuta una risposta vuota sulla richiesta HTTP all\'agente in \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Impossibile trovare Migration & Transfer Agent nella cache locale. Apri nuovamente Migration & Transfer Manager per risolvere il problema.',

    '__hosting_webdeploy' => "Pubblicazione implementazione web",
    'cu_domain__webdeploy' => "Pubblicazione di Web Deploy (default: %1)",
    'cu_dom_tpl__webdeploy' => "Pubblicazione di Web Deploy (default: %1)",
    'cu_subdomain__webdeploy' => "Pubblicazione di Web Deploy (default: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy non è installato sul server",
    'webdeploy__forced_by_site_isolation' => "Impossibile cambiare le impostazioni di pubblicazione di Web Deploy: Non hai i permessi per sovrascrivere le norme di sicurezza del server. Contatta il tuo provider per maggiori informazioni.",



    'backup__restore_options__admin__server_configuration_license' => 'Chiave di licenza',
    'migration_start_migrate_server_license' => 'Trasferisci chiave di licenza',

    'defaultcomponents__delegation_rule_not_exist' => '(la regola di delegazione richiesta \'appPoolPipeline, appPoolNetFx\' non esiste)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Il backup è stato creato dall\'amministratore.',
    'i_backup_created_by_reseller' => 'Il backup è stato creato da un rivenditore.',
    'i_backup_created_by_client' => 'Il backup è stato creato da un cliente.',

    'migration__object_exists_on_target_host' => '(esiste già sull\'host di destinazione)',

    'cu_cl_pref__manage_website_maintenance' => 'Accesso alle operazioni avanzate:Copia del sito web',
    'cu_cl_pref__manage_protected_dirs' => 'Gestione delle directory protette da password',
    'cu_cl_pref__manage_mail_settings' => 'Capacità per cambiare le impostazioni della posta',


    'cu__command_update_php_settings' => 'Aggiorna le impostazioni PHP.',
    'cu__php_settings_option' => 'Definisce il percorso al file con impostazioni PHP.',

    'cu__additional_php_settings_option' => 'Definisce il percorso al file con le direttive PHP aggiuntive.',
    'cu__command_show_php_settings' => 'Mostra le correnti impostazioni PHP.',
    'cu__general_settings' => 'Impostazioni generali:',
    'cu__performance_settings' => 'Impostazioni sulle prestazioni:',
    'cu__php_fpm_settings' => 'Impostazioni PHP-FPM:',
    'cu__additional_directives' => 'Direttive aggiuntive:',

    'php_settings_permission_required' => 'Gestione delle impostazioni PHP comuni',
    'php_settings_performance_permission_required' => 'Gestione delle impostazioni della performance di hosting',
    'php_settings_customized' => 'Le impostazioni PHP sono state personalizzate.',
    'php_settings_synchronized_with_plan' => 'Le impostazioni PHP devono essere sincronizzate con il piano.',
    'phosting__unknown_shell_type' => 'Shell non disponibile',

    'login_up__access_denied_subscription_deleted' => 'Accesso negato:Il tuo abbonamento è stato rimosso.',

    'role_restricted_to_subscription' => '(trasferito con l\'abbonamento: %1)',

    'filemanager__extract' => "Estrai file a: %1",

    'cu__license_command_check_installed_license' => 'Verifica la validità della chiave di licenza installata (restituisce il codice di uscita 0 se la chiave è valida e 1 se non è valida)',

    'promo__mobile_manager_title' => 'Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Estendi la funzionalità di Plesk in modo che sia possibile controllare e monitorare il server da dispositivi mobili (BlackBerry, iPhone e Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Ottieni le informazioni più importanti sui server Plesk in qualsiasi momento e dovunque da un dispositivo mobile (BlackBerry, iPhone e Android).',
    'promo__mobile_button' => 'Maggiori informazioni',

    'subDomainNameHint' => 'Inserisci * come un nome del sottodominio per creare un sottodominio wildcard. I visitatori del sito verranno reindirizzati a questo sottodominio, indipendentemente dal nome di sottodominio che inseriranno sul browser.',
    'subdomains__wildcard_name_invalid' => "Il nome di sottodominio non è valido. È possibile usare soltanto caratteri alfanumerici, un trattino (-) e un asterisco (*) per i nomi di sottodominio wildcard.",
    'subdomains__name_invalid' => "Il nome di sottodominio non è valido. È possibile usare soltanto caratteri alfanumerici e un trattino (-) per i nomi di sottodominio.",

    'domain__wildcard_no_www_prefix' => 'Non è possibile usare il prefisso www per sottodomini wildcard.',

    '__service_title__milter' => "Milter Plesk Postfix",
    '__service_description__milter' => "Filtro di posta Plesk Postfix",
    '__milter' => "Milter di Postfix",
    'restart__milter' => "Milter di Plesk (%1)",
    'restart__pop3' => "Server Courier POP3",
    'restart__pop3s' => "Server Courier POP3 con supporto SSL/TLS",
    'restart__imap' => "Server Courier IMAP",
    'restart__imaps' => "Server Courier IMAP con supporto SSL/TLS",
    'restart__authdaemon' => "Daemon di autenticazione Courier IMAP",
    'restart__imap-pop3' => "Dovecot IMAP e POP3 server",


    'addon_packages_not_supported' => 'I componenti aggiuntivi per le app web incluse nel pacchetto APS non sono supportate.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Impossibile assegnare automaticamente un indirizzo IP al dominio. Specificare un indirizzo ip usando l\'opzione -ip.',

    'plesk_key__mb_accounts' => 'Account utente (rivenditori e clienti) in Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Zona DNS del sottodominio',
    'actionlog__site_subdomain_dns' => 'Zona DNS di un sottodominio sotto un dominio aggiuntivo',

    // PfW only
    'actionlog__event_site_create' => 'Dominio creato',
    'actionlog__event_site_delete' => 'Dominio eliminato',
    'actionlog__event_site_update' => 'Dominio aggiornato',

    'actionlog__event_site_status_update' => 'Stato del dominio aggiornato',
    'actionlog__event_site_dns_update' => 'Zona DNS del dominio aggiornata',
    'actionlog__event_site_guid_update' => 'GUID di dominio aggiornato',

    'actionlog__event_site_subdomain_create' => 'Sottodominio creato',
    'actionlog__event_site_subdomain_delete' => 'Sottodominio eliminato',
    'actionlog__event_site_subdomain_update' => 'Sottodominio aggiornato',

    'actionlog__event_site_alias_create' => 'Alias di dominio creato',
    'actionlog__event_site_alias_delete' => 'Alias di dominio eliminato',
    'actionlog__event_site_alias_update' => 'Alias di dominio aggiornato',

    'actionlog__event_site_alias_dns_update' => 'Zona DNS di un alias di dominio aggiornato',
    'actionlog__event_subdomain_dns_update' => 'È stata aggiornata la zona DNS di un sottodominio sotto il dominio predefinito.',
    'actionlog__event_site_subdomain_dns_update' => 'Zona DNS di un sottodominio aggiornato',
    // End of PfW only

    'win_policy__bad_password' => 'Convalida non riuscita. La password non è valida.',
    'win_policy__password_too_short' => 'Convalida non riuscita. La password non soddisfa i requisiti della politica per password, perché è troppo corta.',
    'win_policy__password_too_long' => 'Convalida non riuscita. La password non soddisfa i requisiti della politica per password, perché è troppo lunga.',
    'win_policy__password_not_complex_enough' => 'Validazione non riuscita. La password non è abbastanza sicura e non soddisfa i requisiti descritti nelle norme di sicurezza della password. Le password più sicure soddisfano almeno uno dei seguenti requisiti: otto caratteri; un carattere minuscolo o maiuscolo; tre numeri e un carattere speciale (!, @, #, $, %, ^, &, *, ?, _, ~) oppure un numero e due caratteri speciali.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Impossibile aggiornare la licenza del prodotto.',


    'filemanager__error_path_is_not_allowed' => 'Il percorso non è ammesso',
    'filemanager__error_path_is_invalid' => 'Il percorso non è valido',
    'filemanager__error_path_not_found' => 'Percorso non trovato',
    'filemanager__error_path_already_exists' => 'Il percorso esiste già',
    'filemanager__error_access_is_denied' => 'Accesso negato',
    'filemanager__error_directory_not_empty' => 'La cartella non è vuota',
    'filemanager__error_sharing_violation' => 'Violazione nella condivisione',
    'filemanager__error_not_same_device' => 'Il percorso di destinazione non si trova sullo stesso dispositivo',
    'filemanager__unable_to_resolve_realpath' => "Impossibile trovare il file %1 nella posizione specificata",
    'filemanager__access_to_realpath_denied' => "Accesso negato al percorso reale: %1 a %2.",
    'bt_exit' => 'Esci',

    'filemanager__copy_error__' => "Impossibile copiare %1 in %2: %3",
    'filemanager__copy_move' => "Copia (sposta) file da %1",
    'filemanager__count_size__' => 'Selezionate la dimensione: %1',
    'filemanager__count_size_error__' => 'Impossibile calcolare la dimensione per %1: %2',
    'filemanager__create_dir_error__' => "Impossibile creare la directory %1: %2",
    'filemanager__dir_not_exists' => "La directory %1 non esiste.",
    'filemanager__dirname' => "Nome directory",
    'filemanager__filename' => "Nome di file",
    'filemanager__is_no_such' => "Non esistono file o directory con il nome %1",
    'filemanager__empty_selection' => "Nessun file selezionato.",
    'filemanager__move_error__' => "Impossibile spostare %1 in %2: %3",
    'filemanager__not_allowed' => "Non siete autorizzati a modificare i permessi di questo file.",
    'filemanager__remove' => "Cancella file da %1",
    'filemanager__remove_error__' => "Impossibile rimuovere il file %1: %2",
    'filemanager__set_win_permissions_dir' => "Imposta permessi per %1 cartella",
    'filemanager__set_win_permissions_file' => "Imposta permessi per %1 file",
    'filemanager__touch_confirm' => "Siete certi di voler cambiare data e orario dei file selezionati?",
    'filemanager__upload_error__' => "Impossibile caricare %1 su %2: %3",
    'filemanager__upload_file' => "Caricare file",
    'filemanager__upload_file_src' => "Percorso al file",
    'filemanager__max_image_size_exceeded' => 'Impossibile visualizzare l\'immagine. Le dimensioni dell\'immagine non possono essere maggiori di %2 byte',

    '__fastcgi_unix_support' => 'Supporto FastCGI',

    'dns__subdomain_dns_zone_parent' => 'I record DNS di questo sottodominio sono archiviati nella zona DNS principale. È possibile modificare la zona principale %1 o creare un\'altra zona per il sottodominio.',
    'dns__subdomain_dns_zone_parent_link' => 'qui',
    'dns__no_dns_zone' => 'Nessuna zona DNS assegnata al dominio. Per gestire la zona DNS del dominio è necessario premere il pulsante \'Ripristina predefiniti\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Impossibile attivare la zona del sottodominio perché c\'è un registro CNAME per questo sottodominio nella zona del suo dominio principale.',

    '__hosting_write_modify' => 'Permessi aggiuntivi di scrittura/modifica',

    'aspdotnet__group_framework_version' => "Versione framework",

    'bt_restore_default' => "Imposta predefinita",
    'b_autoinstaller' => 'Aggiorna Plesk o i suoi componenti.',
    'b_autoinstaller_configure' => 'Impostazioni di aggiornamento.',
    'b_autoinstaller_install' => 'Installa i componenti selezionati.',

    '__iis_app_pool__use_dedicated' => 'Pool di applicazioni IIS dedicato',
    '__iis_app_pool__use_dedicated_addons' => 'Pool di applicazioni IIS dedicato per ogni sito web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Attiva applicazioni a 32 bit',
    '__iis_app_pool__load_user_profile' => 'Carica il profilo dell\'utente',
    'bt_iis_app_pool' => "Pool di applicazioni IIS",

    'performance__cpu_usage' => 'Utilizzo massimo della CPU (%)',
    'performance__cpu_usage_action' => 'Limita azione',
    'performance__cpu_usage_interval' => 'Limita intervallo (minuti)',
    'performance__cpu_usage_action_not_supported' => 'L\'azione specificata non è supportata dal server web.',

    'performance__idle_timeout_action_not_supported' => 'L\'azione di timeout di inattività specificata non è supportata dal server web.',
    'performance__max_worker_processes' => 'Il numero massimo di processi di lavoro',
    'performance__idle_timeout' => 'Timeout inattività (minuti)',
    'performance__idle_timeout_action' => 'Azione timeout inattività',
    'performance__recycling_by_time' => 'Riciclo a intervalli di tempo regolari (minuti)',
    'performance__recycling_by_requests' => 'Riciclo quando il numero massimo di richieste viene raggiunto',
    'performance__recycling_by_virtual_memory' => 'Riciclo quando la quantità massima di memoria virtuale viene usata',
    'performance__recycling_by_private_memory' => 'Riciclo quando la quantità massima di memoria privata viene usata',
    'performance__managed_pipeline_mode' => 'Modalità pipeline gestita',
    'performance__managed_pipeline_mode_not_supported' => 'La modalità specificata non è supportata dal server web.',

    'iis_app_pool' => 'Gestione pool di applicazioni IIS.',
    'b_iis_app_pool' => 'Gestione del pool di applicazioni IIS.',
    'iis_app_pool_cl_dom' => 'Gestione pool di applicazioni IIS.',

    'bt_protect' => 'Proteggi',
    'bt_unprotect' => 'Rimuovi la Protezione',
    'bt_show_additional_users' => 'Mostra utenti addizionali',
    'bt_hide_additional_users' => 'Nascondi utenti addizionali',
    'error_doc__code_400' => 'Richiesta Sbagliata',
    'error_doc__code_401' => 'Non Autorizzato',
    'error_doc__code_401.1' => 'Non autorizzato - Login fallito',
    'error_doc__code_401.2' => 'Non autorizzato - Login fallito dovuto alla configurazione del server',
    'error_doc__code_401.3' => 'Non autorizzato - Non autorizzato dovuto all\'ACL sulla risorsa',
    'error_doc__code_401.4' => 'Non autorizzato - Autorizzazione negata dal filtro',
    'error_doc__code_401.5' => 'Non autorizzato - Autorizzazione negata dall\'applicazione ISAPI/CGI',
    'error_doc__code_401.7' => 'Non autorizzato - Negato a causa delle norme di autenticazione URL',
    'error_doc__code_403' => 'Non permesso',
    'error_doc__code_403.1' => 'Vietato - Accesso di esecuzione negato',
    'error_doc__code_403.2' => 'Vietato - Accesso di lettura negato',
    'error_doc__code_403.3' => 'Vietato - Accesso di scrittura negato',
    'error_doc__code_403.4' => 'Vietato - SSL richiesti',
    'error_doc__code_403.5' => 'Proibito - SSL 128 richiesto',
    'error_doc__code_403.6' => 'Vietato - Indirizzo IP rifiutato',
    'error_doc__code_403.7' => 'Vietato - Certificato del cliente richiesto',
    'error_doc__code_403.8' => 'Vietato - Accesso al sito negato',
    'error_doc__code_403.9' => 'Vietato - Troppi utenti',
    'error_doc__code_403.10' => 'Proibito - Configurazione non valida',
    'error_doc__code_403.11' => 'Proibito - Cambio della password',
    'error_doc__code_403.12' => 'Proibito - Accesso negato del mapper',
    'error_doc__code_403.13' => 'Vietato - Certificato di cliente revocato',
    'error_doc__code_403.14' => 'Proibito - Elenco di directory negato',
    'error_doc__code_403.15' => 'Proibito - Licenze di accesso del cliente superate',
    'error_doc__code_403.16' => 'Proibito - Certificato del cliente non attendibile o malformato',
    'error_doc__code_403.17' => 'Vietato - Il certificato del cliente è scaduto o non è valido',
    'error_doc__code_403.18' => 'Vietato- Impossibile eseguire la richiesta da questo pool di applicazioni',
    'error_doc__code_403.19' => 'Proibito - Accesso CGI negato',
    'error_doc__code_403.20' => 'Proibito - Login Passport non riuscito',
    'error_doc__code_404' => 'Non trovato',
    'error_doc__code_404.2' => 'Non trovato - Negato a causa delle norme di blocco',
    'error_doc__code_404.3' => 'Non trovato - Negato a causa delle norme MIMEMAP',
    'error_doc__code_405' => 'Metodo non consentito',
    'error_doc__code_406' => 'Non accettabile',
    'error_doc__code_407' => 'Autenticazione proxy richiesta',
    'error_doc__code_408' => 'Timeout della richiesta',
    'error_doc__code_412' => 'Precondizione non riuscita',
    'error_doc__code_414' => 'Richiesta-URI troppo lunga',
    'error_doc__code_415' => 'Tipo di supporto non supportato',
    'error_doc__code_431' => 'I campi d\'intestazione richiesti sono troppo grandi',
    'error_doc__code_500' => 'Errore del server interno',
    'error_doc__code_500.12' => 'Errore del server interno - Riavvio dell\'applicazione',
    'error_doc__code_500.13' => 'Errore del server interno - Server troppo occupato',
    'error_doc__code_500.15' => 'Errore del server interno - Richieste dirette proibite per GLOBAL.ASA',
    'error_doc__code_500.16' => 'Errore del server interno - Errore di accesso UNC',
    'error_doc__code_500.17' => 'Errore del server interno - Store di autorizzazione URL non trovato',
    'error_doc__code_500.18' => 'Errore del server interno - Impossibile aprire lo store di autorizzazione URL',
    'error_doc__code_500.19' => 'Errore del server interno - Metadati del file errati',
    'error_doc__code_500.100' => 'Errore del server interno - errore ASP',
    'error_doc__code_501' => 'Non implementato',
    'error_doc__code_502' => 'Gateway errato',
    'error_doc__code_503' => 'Servizio temporaneamente non disponibile',

    'mimetype_edit__already_exists' => 'Il tipo MIME è giù definito per questa estensione.',
    'mimetype_edit__not_exists' => 'Il tipo MIME non esiste.',

    'php__group_php_version' => "Versione PHP",

    'virtualdir__path' => 'Percorso',
    'virtualdir__read' => 'Permesso di lettura',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Permesso di scrittura',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Accesso origine script',
    'virtualdir__source_short' => 'A',
    'virtualdir__browse' => 'Permesso di esplorazione directory',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Esegui permessi',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Registra visite',
    'virtualdir__app_create' => 'Crea applicazione',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Attiva l\'autenticazione anonima.',
    'virtualdir__auth_windows' => 'Attiva l\'autenticazione di Windows.',
    'virtualdir__auth_not_enabled' => 'L\'autenticazione anonima o di Windows deve essere attivata.',
    'virtualdir__require_ssl' => 'Richiedi SSL/TLS',
    'virtualdir__enable_default_doc' => 'Utilizza i documenti predefiniti',
    'virtualdir__default_doc' => 'Ordine di ricerca dei documenti predefiniti',
    'virtualdir__enable_parent_paths' => 'Consenti l\'uso dei percorsi principali',
    'virtualdir__execute_in_mta' => 'Consentire l\'esecuzione dell\'applicazione in modalità MTA (multi-threaded apartment)',
    'virtualdir_create__title' => 'Crea directory virtuale in %1',
    'virtualdir_edit__title' => 'Proprietà della directory virtuale %1',
    'virtualdir_edit__legend' => 'Directory virtuale',
    'virtualdir_edit__application_legend' => 'Impostazioni applicazione',
    'virtualdir_edit__security_legend' => 'Protezione directory',
    'virtualdir_edit__documents_legend' => 'Documenti',
    'virtualdir_edit__list_legend' => 'Directory virtuali nidificate',
    'virtualdir_error__path_not_in__' => 'Percorso specificato non valido',
    'virtualdir_root' => 'Directory virtuali',
    'virtualdir_root__title' => 'Directory virtuali',
    'virtualdir_root__list_legend' => 'Directory virtuali',
    'virtualdir_se__none' => 'Nessuno',
    'virtualdir_se__script' => 'Solo script',
    'virtualdir_se__script_execute' => 'Script ed eseguibili',
    'virtualdirs__title' => 'Directory virtuali',
    'virtualdirs__path_not_exists' => 'Percorso non valido.',
    'virtualdirs__select_for_remove' => "Seleziona le directory virtuali da eliminare.",
    'virtualdirs_remove__title' => 'Elimina directory Virtuali',

    'asp_max_buffer_text' => 'Dimensione massima del buffer ASP (KB)',
    'asp_max_body_text' => 'Dimensione massima del testo del corpo dell\'entità per una richiesta ASP (KB)',
    'asp_buffers_legend' => 'Impostazioni ASP',
    'asp_client_debug_text' => 'Attivare il debug ASP dello script a livello del cliente.',
    'asp_server_debug_text' => 'Attivare il debug ASP dello script a livello del server.',

    'permissions__group_or_user_name' => 'Nomi gruppi o utenti',
    'permissions__FullControl' => 'Controllo completo',
    'permissions__Modify' => 'Modifica',
    'permissions__ReadAndExecute' => 'Lettura ed esecuzione',
    'permissions__ListFolderContents' => 'Visualizzazione contenuto cartella',
    'permissions__Read' => 'Lettura',
    'permissions__Write' => 'Scrittura',
    'permissions__ReadControl' => 'Autorizzazioni di lettura',
    'permissions__WriteControl' => 'Autorizzazioni di scrittura',
    'permissions__ExecuteControl' => 'Autorizzazioni di esecuzione',
    'permissions__TraverseFolderOrExecuteFile' => 'Visita cartella / Esecuzione file',
    'permissions__ListFolderOrRead' => 'Visualizza cartella / Lettura dati',
    'permissions__CreateFilesOrWrite' => 'Creazione file / Scrittura dati',
    'permissions__CreateFoldersOrAppend' => 'Creazione cartelle / Aggiunta dati',
    'permissions__DeleteSubfoldersandFiles' => 'Eliminazione sottocartelle e file',
    'permissions__Delete' => 'Elimina',
    'permissions__ChangePermissions' => 'Cambiare Permessi',
    'permissions__TakeOwnership' => 'Diventa proprietario',
    'permissions__inherited_from' => 'Ereditata da',
    'permissions__not_inherited' => '<non ereditato>',
    'permissions__apply_to' => 'Applica a',
    'permissions__apply_onto' => 'Applica a:',
    'permissions__apply_onto1' => 'Solo la cartella selezionata',
    'permissions__apply_onto2' => 'Solo sottocartelle',
    'permissions__apply_onto3' => 'La cartella selezionata e le sottocartelle',
    'permissions__apply_onto4' => 'Solo file',
    'permissions__apply_onto5' => 'Questa cartella e file',
    'permissions__apply_onto6' => 'Solo sottocartelle e file',
    'permissions__apply_onto7' => 'La cartella selezionata, le sottocartelle e i file',

    'filemanager__not_allowed_dir' => "Non ti è consentito cambiare i permessi di questa cartella.",

    'filemanager__allow' => "Consenti",
    'filemanager__deny' => "Nega",
    'filemanager__user_domusr' => 'Amministratore del sito web',
    'filemanager__user_webusr' => 'utente web',
    'filemanager__user_admins' => 'Amministratori',
    'filemanager__user_system' => 'Utente di sistema',
    'filemanager__user_aspnet' => 'Utente ASP.NET',
    'filemanager__user_poolusr' => 'Utente pool di applicazioni',
    'filemanager__user_sysaccount' => 'Utente di sistema addizionale',

    'bt_permissions_advanced' => 'Avanzato',
    'b_permissions_advanced' => 'Clicca per vedere ed impostare i permessi speciali.',

    'hotlink-protection_invalid_friend_domain' => 'Nome non valido per dominio conosciuto.',
    'hotlink-protection_duplicate_friend_domain' => 'Nome duplicato per dominio conosciuto.',
    'hotlink-protection_invalid_extensions' => 'L\'estensione del file contiene caratteri non validi.',

    'i_domain_alias_status_on' => 'L\'alias di domino è abilitato.',
    'i_domain_alias_status_off' => 'L\'alias di domino è disabilitato.',
    'i_domain_alias_status_with_parent' => 'L\'alias di domino è disabilitato perché il dominio è disattivato.',
    'i_domain_alias_turn_off' => 'Clicca per disabilitare.',
    'i_domain_alias_turn_on' => 'Clicca per abilitare.',

    'domain_alias__control_title' => 'Alias di dominio %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'A',
    'domain_alias__control_name_title' => 'Nome di servizio',
    'domain_alias__control_details_title' => 'Dettagli',

    'domain_alias__invalid_values' => 'Il nome del dominio che hai specificato non è valido. I nomi dei domini possono includere lettere, numeri e trattini. Ogni parte del nome del dominio fra i punti non deve essere più lungo di 63 caratteri.',
    'domain_alias__domain_already_exists' => "Nome non valido dell'alias del dominio %1. Il dominio %1 esiste già.",
    'domain_alias__www_prefix_domain_already_exists' => "Nome non valido dell'alias di dominio www.%1. Questo alias è già creato per il dominio %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nome non valido del webmail dell\'alias di dominio.%1. Questo alias è già creato per il dominio %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nome non valido nelle liste di alias di dominio.%1. Questo alias è già creato per il dominio %1.',
    'domain_alias__dns_record_already_exists' => 'Impossibile impostare l\'alias del dominio %1 perché esiste già un record DNS che punta all\'host %1.',
    'domain_alias__domain_alias_already_exists' => "Esiste già un alias di dominio con questo nome.",
    'domain_aliases__mail_server_not_support_aliases' => 'Il server della posta non supporta gli alias di dominio. Pertanto, questi potrebbero non funzionare correttamente.',
    'domain_alias__restrict_domain_creation' => 'Il nome specificato per un alias di dominio è proibito dalle normative del server. Se questo nome di alias di dominio ti appartiene, contatta il tuo fornitore di hosting.',
    'domain_alias__restrict_creation_with_www' => 'Inserisci un nome di dominio senza il prefisso \'www\'. Il prefisso www per il dominio sarà automaticamente aggiunto alla configurazione del server web.',
    'domain_unable_to_set_name' => 'Nome non valido %1.',

    'domain_alias__domain_service_dns_disabled' => 'Questo dominio è servito da un altro server DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Questo server DNS agisce come server di nomi primario per questa zona DNS.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Questo server DNS agisce come server di nomi secondario per questa zona DNS.',
    'domain_alias__domain_service_mail_enabled' => 'Il servizio di posta è attivato per il dominio.',
    'domain_alias__domain_service_mail_disabled' => 'Il servizio di posta è disattivato per il dominio.',
    'domain_alias__domain_service_mail_mx' => '%1 è usato come server di posta.',

    'domain_alias__service_seoRedirect_hint' => 'Quando i visitatori apriranno l\'URL dell\'alias, saranno reindirizzati verso l\'URL del dominio principale. Plesk usa il motore di ricerca compatibile con il reindirizzamento HTTP 301, il che significa che il ranking del motore di ricerca non sarà diviso tra gli URL.',

    'bt_task_run_now' => 'Esegui ora',
    'ftp__read_perm' => "Permesso di lettura",
    'ftp__write_perm' => "Permesso di scrittura",

    'filemanager__upload_backup_file_hint' => 'In questa sezione è possibile caricare file di backup nell\'archivio di Plesk. La dimensione massima dei file è limitata a due gigabyte.',

    '__default_for_mssql' => 'predefinito per MS SQL',

    '__login_does_not_pass_validation' => "Il nome utente non è valido. Accertati che i seguenti requisiti siano soddisfatti: %1",
    '__login_allowed_symbols' => 'Sono consentiti soltanto caratteri alfanumerici, tra cui punti, trattini e caratteri di sottolineatura. Il primo carattere deve essere alfanumerico.',

    'restart__nginx' => 'Server proxy inverso (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Desidero ricevere informazioni generali sul prodotto e comunicazioni da parte di Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Desidero ricevere informazioni in materia di sicurezza o altre notifiche tecniche da Plesk.",

    '__login_status_inactive' => 'Il tuo account non è attivo. Contattare l\'amministratore di Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Ritorna alla pagina Strumenti e Impostazioni. La migrazione continuerà in un secondo piano.',

    'chk_js__warning_about_ftp_login_syntax' => "Puoi usare caratteri alfanumerici, trattini e caratteri di sottolineatura nel nome utente.",
    'chk_js__warning_about_passwd_syntax' => "Non usare virgolette, spazi né caratteri dell'alfabeto latino nella password.\nLa lunghezza della password deve comprendere da %1 a %2 caratteri e non deve contenere il nome utente.",
    'chk_js__warning_about_plesk_login_syntax' => "Puoi usare caratteri alfanumerici minuscoli, punti, trattini e caratteri di sottolineatura nel nome utente.",
    'chk_js__warning_about_admin_passwd_syntax' => "Non usare virgolette, spazi, punto e virgola né caratteri dell'alfabeto latino nella password.\nLa lunghezza della password deve comprendere da %1 a %2 caratteri e non deve contenere il nome utente.",

    'cmd_server__admin_alias_not_found' => "Impossibile trovare l'account amministratore aggiuntivo.",

    'panel_branding__skins_already_exists' => "Nota: Il tema '%1' esiste già. Sarà sostituito con il tema che stai attualmente installando.",
    'panel_branding__skins_file_exists' => "Impossibile creare una directory per il tema '%1': Un file con questo nome esiste già.",

    'actionlog__login_failed' => 'accesso non riuscito',
    'actionlog__event_cp_user_login_failed' => 'Accesso utente Plesk non riuscito',
    'actionlog__api_login_failed' => 'accesso tramite API non riuscito',
    'actionlog__event_cp_user_api_login_failed' => 'Accesso non riuscito dell\'utente Plesk tramite API',
    'actionlog__pw_reset' => 'richiesta di reimpostazione della password',
    'actionlog__pw_admin_force_reset' => 'ha richiesto la reimpostazione forzata della password Amministratore',

    'ch_pass_admin__email_subject' => "Promemoria password di Plesk",
    'ch_pass_admin__email_body' => "Ciao, %1.\n\nLa password dell'amministratore non può essere inviata via email per motivi di sicurezza.\n\nPer effettuare l'accesso come 'admin', usa il comando 'plesk login'.\n\nPer configurare una nuova password da 'admin', usa il comando 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Impossibile inviare l\'email:%1',

    'ch_pass_by_secret__email_subject' => "Promemoria password di Plesk",
    'ch_pass_by_secret__email_body' => "Salve %2,\n\nPer impostare una nuova password, segui il link: %1\n\nIl tuo nome utente: %3",
    'ch_pass_by_secret__message_send_error' => 'Impossibile inviare il codice segreto: %1',
    'ch_pass_by_secret__title' => 'Cambia la tua password',
    'ch_pass_by_secret__secret' => 'Codice segreto',

    'custom_button__noframe' => "Non utilizzare frame",

    'custom_button__internal_hint' => 'Indica se aprire la URL su una pagina Plesk oppure in una nuova finestra del browser.',
    'custom_button__noframe_hint' => 'Se aggiungi un pulsante personalizzato che porta ad un\'estensione di Plesk o ad un\'app nel Pannello del Cliente, puoi specificare il modo in cui visualizzare tale estensione/app: in un frame o come parte della GUI di Plesk.',


    'actionlog__patch' => 'Aggiorna',
    'actionlog__patch_available' => 'disponibile',
    'actionlog__event_patch_available' => 'Aggiornamento disponibile',
    'actionlog__patch_installed' => 'installato',
    'actionlog__event_patch_installed' => 'Aggiornamento installato',

    'actionlog__extension' => 'Estensione',
    'actionlog__extension_status' => 'Stato dell’estensione',
    'actionlog__cloning' => 'Clonazione del server',
    'actionlog__cloning_complete' => 'completo',
    'actionlog__event_cloning_complete' => 'Clonazione del server completata',

    'actionlog__ssl_web_binding' => 'Certificato SSL / TLS sul dominio',
    'actionlog__ssl_web_binding_update' => 'assegnato/non assegnato',
    'actionlog__event_ssl_web_binding_update' => 'Certificato SSL/TLS sul dominio assegnato/non assegnato',

    'actionlog__ssl_web_mail_binding' => 'Certificato SSL/TLS sulla Webmail',
    'actionlog__ssl_web_mail_binding_update' => 'assegnato/non assegnato',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certificato SSL/TLS sulla Webmail assegnato/non assegnato',

    'actionlog__ssl_mail_binding' => 'Certificato SSL/TLS sul server della posta',
    'actionlog__ssl_mail_binding_update' => 'assegnato/non assegnato',
    'actionlog__event_ssl_mail_binding_update' => 'Certificato SSL/TLS sul server della posta assegnato/non assegnato',

    'actionlog__ssl_panel_binding' => 'Certificato SSL/TLS su Plesk',
    'actionlog__ssl_panel_binding_update' => 'assegnato/non assegnato',
    'actionlog__event_ssl_panel_binding_update' => 'Certificato SSL/TLS su Plesk assegnato/non assegnato',

    'actionlog__hostname' => 'Nome host del server',
    'actionlog__hostname_changed' => 'cambiato',

    'actionlog__smb_user' => 'Utente aggiuntivo',
    'actionlog__smb_user_create' => 'Utente aggiuntivo creato',
    'actionlog__smb_user_delete' => 'Utente aggiuntivo eliminato',
    'actionlog__smb_user_update' => 'Utente aggiuntivo aggiornato',

    'actionlog__event_mail_management_status_update' => 'Aggiornamento dello stato di gestione della posta',
    'actionlog__mail_management' => 'Stato di gestione della posta',
    'actionlog__mail_management_status_update' => 'aggiornato',

    'virtualization_openvz' => 'OpenVZ',

    'passwordSecurityLevelCheckFailed' => 'Questa password non è sufficientemente sicura. Secondo le norme del server, la lunghezza minima della password è %1. Per migliorare la sicurezza delle password, utilizza numeri, maiuscole e minuscole e caratteri speciali come !,@,#,$ eccetera.',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Molto debole',
    'passwordSecurityLevelCheckFailedWeak' => 'Debole',
    'passwordSecurityLevelCheckFailedMediocre' => 'Mezza',
    'passwordSecurityLevelCheckFailedStrong' => 'Alta',
    'passwordSecurityLevelCheckFailedStronger' => 'Molto alta',

    'dns__dns_default_ipv4_modified' => 'I registri con questo indirizzo IP saranno considerati modificati dall\'utente e non verranno sincronizzati con il modello DNS del server.',
    'dns__dns_default_ipv6_modified' => 'I registri con questo indirizzo IP saranno considerati modificati dall\'utente e non verranno sincronizzati con il modello DNS del server.',

    'dns__view_dns_record_master_title' => 'Visualizzazione di registri di risorse',
    'dns__view_dns_record_off_title' => 'Visualizzazione di record del name server',
    'dns__view_dns_record_slave_title' => 'Visualizzazione di record del server DNS primario',

    'dns_unable_to_resolve_hostname' => "Impossibile risolvere l'hostname \"%1\": %2\nAccertati che il resolver DNS del sistema operativo sia impostato e funzioni correttamente.",

    'no_database_server_available' => 'Non ci sono server di database disponibili per questo abbonamento.',

    'database_used_by_application_can_not_be_moved' => 'Impossibile spostare il database: Un\'applicazione utilizza questo database.',
    'database_user_update_orphaned_is_restricted' => 'L\'aggiornamento di account utente del database orfani è proibito. È solo possibile eliminarli o ripararli.',

    'database_unable_to_get_max_filesize_default_message' => 'Impossibile determinare la dimensione di file massima del database: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Impossibile impostare la dimensione di file massima del database: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Impossibile determinare la dimensione di file di registro massima del database: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Impossibile impostare la dimensione di file di registro massima del database: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Impossibile determinare il limite attuale sulla dimensione del file del database Microsoft SQL \'%1\'. Impostare un nuovo limite è impossibile.',
    'database_unable_to_set_max_filesize' => 'Impossibile impostare il limite per la dimensione del file del database Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Impossibile determinare il limite attuale sul file di registro del database Microsoft SQL \'%1\'. Impostare un nuovo limite è impossibile.',
    'database_unable_to_set_max_log_filesize' => 'Impossibile impostare il limite per la dimensione del file di registro del database Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Impossibile creare il database Microsoft SQL \'%1\': Il suo file è più grande della dimensione massima consentita.',
    'database_unable_to_move_because_max_filesize' => 'Impossibile spostare il database Microsoft SQL \'%1\': Il suo file è più grande della dimensione massima consentita: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Impossibile creare il database Microsoft SQL \'%1\': La dimensione del suo file di registro è più grande della dimensione massima consentita.',
    'database_unable_to_move_because_max_log_filesize' => 'Impossibile spostare il database Microsoft SQL \'%1\': Il suo file di registro è più grande della dimensione massima consentita: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Impossibile ripristinare il database Microsoft SQL \'%1\': Il suo file è più grande della dimensione massima consentita.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Un MS SQL server identico è già registrato in Plesk. Specificare un altro server MS SQL come sandbox.',
    'database_server__mssql_server_registered_as_sandbox' => 'Una sandbox MS SQL server identica è già registrata in Plesk. Specificare un altro server MS SQL come sandbox.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Impossibile connettersi al server tramite \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'La funzionalità %1 non è supportata dai seguenti nodi di servizio: %2. Questa funzionalità sarà disabilitata per tutti gli oggetti creati su questi nodi.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'La funzionalità %1 non +e supportata da questo server. Questa funzionalità sarà disabilitata per tutti gli oggetti ripristinati.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Il componente %1 non è installato. Non sarà disponibile per i seguenti siti web: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Il componente %1 non è installato. Verrà sostituito con %2 per i seguenti siti web: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'La corrente versione di Plesk non supporta nomi utente con il carattere punto (.). I clienti e rivenditori con tali nomi utente non saranno ripristinati.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Impossibile trovare un file di backup con i dati per %1 %2. I dati per %1 %2 non saranno ripristinati.',

    'bu_conflict_resolver_zone_master_removed' => "Impossibile ripristinare il record DNS primario: Il record nella zona secondaria punta verso l'indirizzo IP esistente %1. Il registro DNS primario verrà rimosso dalla zona secondaria.",
    'bu_conflict_resolver_dns_not_supported_https' => 'Il supporto per i record DNS HTTPS non è attivo. I record HTTPS non saranno ripristinati nei seguenti domini: {{objects}}',

    'bu_conflict_resolver_not_available_scripting' => '%1 non è supportato.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 non è supportato. Non sarà disponibile per i seguenti siti web: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Il componente %1 non è installato.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Non sarà disponibile per i seguenti nodi di servizio: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Non sarà disponibile per i seguenti oggetti: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'I seguenti server database non sono disponibili su questo server: %1.',

    'bu_conflict_resolver_smarthost_not_supported' => 'La gestione degli smarthost non è supportata. Le impostazioni dello smarthost non saranno ripristinate.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Il file di backup del database MS SQL è archiviato in formato nativo MS SQL, che può essere ripristinato soltanto sul server MS SQL locale o su un server MS SQL remoto con impostazioni di backup totalmente configurate. Alcuni dei tuoi database non sono stati ripristinati perché non c\'è alcun server appropriato MS SQL registrato in Plesk. I seguenti database sono stati coinvolti: {{objects}}. Contattare il provider di hosting.',

    'bu_conflict_resolver_not_available_webmail' => 'Il servizio webmail %1 non è disponibile. Verrà sostituito con %2 per gli oggetti seguenti: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Il servizio webmail %1 non è disponibile. Verrà sostituito con %2 per i piani di servizio seguenti: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "I database del tipo '%1' non supportano i nomi utente coincidenti con i nomi di database. L'utente '%2' sarà rinominato '%3' per il database '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Il limite di utilizzo dello spazio su disco non è impostato nella configurazione del server di destinazione. Il valore di questa impostazione verrà modificato in "Illimitato".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Il limite di utilizzo dello numero di connessioni non è impostato nella configurazione del server di destinazione. Il valore di questa impostazione verrà modificato in "Illimitato".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Il limite di utilizzo del traffico su disco non è impostato nella configurazione del server di destinazione. Il valore di questa impostazione verrà modificato in "Illimitato".',
    'cu__pleskrestore_backup_file_extracted' => 'Il file di backup è stato estratto per "%1".',
    '__mod_bw_not_supported' => 'Il modulo mod_bw per il server web Apache non è supportato a causa della configurazione del file system. I limiti di utilizzo del traffico e il numero massimo di connessioni non saranno quindi attivi.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'L\'autorizzazione POP3 per l\'inoltro di posta non è supportata. Verrà invece usata l\'autorizzazione SMTP prima di POP3. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Piano di servizio \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 non è supportato. Verrà sostituito con %2 per i piani di servizio seguenti: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 non è supportato. Verrà sostituito con %2 per i siti web seguenti: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'I seguenti oggetti non sono stati trovati nel file di backup: %1',
    'bu_conflict_resolver_absent_domains' => 'Alcuni oggetti non possono essere ripristinati perché appartengono ai seguenti domini, che non sono stati trovati in Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Alcuni siti web non possono essere ripristinati perché appartengono ai seguenti domini principali, che non sono stati trovati in Plesk: %1",
    'bu_conflict_resolver_dns_not_supported' => 'Impossibile ripristinare le zone DNS: Il servizio DNS è disattivato nella configurazione del server.',
    'bu_conflict_resolver_mail_not_supported' => 'Impossibile ripristinare le caselle postali: Il servizio di posta è disattivato nella configurazione del server.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Il limite della CPU specificato non è supportato dal server web IIS. Il valore varrà ripristinato a %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'certificato %1 SSL/TLS del server',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certificato SSL/TLS %2 del dominio %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certificato SSL/TLS%1',
    'bu_conflict_resolver_absent_objects' => 'I contenuti dei seguenti oggetti non possono essere ripristinati perché gli oggetti non sono stati trovati in Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'I contenuti delle seguenti caselle postali nono possono essere ripristinati perché le caselle postali non sono state trovate in Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'I contenuti delle seguenti liste di posta non possono essere ripristinati perché le liste di posta non sono state trovate in Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'I contenuti dei seguenti database non possono essere ripristinati perché i database non sono stati trovati in Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Il ripristino dell\'applicazione "%1" su "%2" non è riuscito perché un\'altra applicazione è già installata in "%3". Puoi rimuovere l\'applicazione installata e riprovare.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'La funzione di risposta automatica della posta non è supportata.',
    'bu_conflict_resolver_not_available_mail_content' => 'Il ripristino del contenuto delle mail non è supportato.',
    'bu_conflict_resolver_invalid_mail_name' => 'Le seguenti caselle di posta elettronica non sono state ripristinate perché il subaddressing dell\'e-mail è abilitato e alcuni indirizzi e-mail contengono il simbolo "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'I seguenti utenti non sono stati ripristinati perché il subaddressing dell\'e-mail è abilitato e alcuni indirizzi e-mail contengono il simbolo "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Le seguenti licenze sono scadute e non verranno ripristinate: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Le seguenti licenze sono scadute o non valide, e non verranno ripristinate: {{objects}}',
    'expiration_unsupported' => "Il limite \"scadenza\" non è supportato.",

    'component_name__dbconnector' => "Connettore Database",
    'component_name__mysqlserver' => 'Server MariaDB/MySQL',
    'component_name__troubleshooting' => 'Risoluzione di problemi',
    'component_name__savi' => 'Interfaccia Sophos Antivirus',

    '__subscription_has_no_license_key' => 'Le risorse dell\'abbonamento sono fornite dal nodo di servizio #%1, al quale non è associata una chiave di licenza.',
    '__subscription_has_expired_license_key' => 'Le risorse dell\'abbonamento sono fornite dal nodo di servizio #%1, la cui chiave di licenza %2 è scaduta.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Impossibile salvare i file di configurazione',
    '__cfgmonConfigurationFileSaveErrorBody' => "Impossibile salvare alcuni file di configurazione sull'host <%%host%%>: Si sono verificati i seguenti errori: %%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Questa opzione consente di configurare gli indirizzi e-mail in stile VERP per le mailing list',
    'mail__enter_right_ip_mask' => "Immettere la maschera IP tra 1 e 32",
    'mail__enter_right_ip_mask_24' => "Immettere la maschera IP 24 e 32",
    'mail__invalid_dom_name' => "Il nome di dominio %1 non è valido.",
    'mail__invalid_pop_lock_time' => "Il tempo di lock del POP3 non è valido.",
    'mail__invalid_rbl_server' => "Il nome della zona DNS non è valido.",
    'mail__total_files_size' => "Dimensione totale cartella: %1",
    'mail__filename_already_in_repository' => "Un file con lo stesso nome è già presente nell'archivio",
    'mail__no_white_list_mask_feature_24' => "Utilizza un valore di maschera pari a 24 o superiore.\nIl tuo server di posta non supporta le impostazioni per maschere. Possiamo solo emulare l'impostazione della maschera per i valori non inferiori a 24.",
    'mail__unable_add_new_mail_name' => "Impossibile aggiungere l'account di posta: %1",
    'mail_server_is_not_installed' => 'Il server di posta (Postfix o Qmail) non è installato. Installalo per continuare il lavoro.',
    'mail_server_not_available' => 'Non ci sono server di posta supportati disponibili sul nodo di servizio.',
    '__not_installed' => '(non installato)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Il filtro antispam sui messaggi email in uscita è disabilitato.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Il nodo di servizio non supporta la limitazione del numero di messaggi email in uscita da un dominio per il dominio %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Il nodo di servizio non supporta la limitazione del numero di messaggi email in uscita da una casella postale per il dominio %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Specifica un indirizzo di almeno un tipo (IPv4 o IPv6).',

    'mail__outgoing_email_mode_invalid' => 'È stata specificata una modalità di posta in uscita non valida.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'È stato specificato un indirizzo IPv4 non valido.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'È stato specificato un indirizzo IPv6 non valido.',
    'mail__outgoing_email_mode_unavailable' => 'Non è consentito cambiare modalità per la posta in uscita, probabilmente perché il server di posta Postfix non è installato in questo server.',

    'mail__autoresponder_attachment_not_supported' => 'Il server di posta utilizzato attualmente non supporta la gestione degli allegati del risponditore automatico.',

    'mail__smtp_white_list_not_supported' => 'Il server di posta attualmente in uso non supporta l\'aggiunta d\'indirizzi IP alla whitelist.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Le maschere CIDR non sono supportate dal server di posta attualmente selezionato. Indicare l\'indirizzo IP nel formato \'192.*.0.*\'.',
    'mail__smtp_whitelist_mask_not_supported' => 'I modelli jolly per l\'IP non sono supportati dal server di posta attualmente selezionato. Indicare l\'indirizzo IP nel formato \'192.0.0.0/8\'.',

    'sfdk_server_wide_verify_failed' => 'Impossibile cambiare le impostazioni per il servizio di verifica di DKIM',

    'sfdk_domain__serverwide_disabled' => 'Disattivato secondo le normative del server',
    'feature__domainkeys__serverwide_disabled' => 'La protezione spam DKIM per il server è disattivata',

    'defaultcomponents__error_set_default' => 'Impossibile impostare %1 come %2 predefinito: %3',
    'defaultcomponents__error_set_default_none' => 'Impossibile non impostare alcun componente predefinito per %1:%2',
    'defaultcomponents__required_package_not_default' => 'Il componente %1 richiesto per il suo funzionamento non è quello predefinito.',

    '__percentage' => '%',
    '__seconds' => 'Secondi',
    '__resource_remain' => 'Rimanente',

    '__not_registered' => '(non registrato)',
    '__php_handler_id' => 'Versione PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Il gestore PHP "%1" non è registrato. È stato probabilmente eliminato dal server. Registra un gestore con le stesse proprietà e riprova.',
    '__php_handler_not_registered_on_domain' => 'Dominio "%1": il gestore PHP "%2" non è registrato. È stato probabilmente eliminato dal server. Registra un gestore con le stesse proprietà e riprova.',
    '__php_fpm_handler' => 'Applicazione FPM',
    '__php_fpm-dedicated_handler' => 'Applicazione FPM dedicata',

    'mailname_create_assigned_user_dublicate_error' => 'Impossibile creare un utente per la casella postale. L\'utente con il nome utente %1 esiste già e possiede un\'altra casella postale.',
    'mailname_create_assigned_user_role_absent_error' => 'Impossibile creare un utente per la casella postale. Il ruolo predefinito %1 dell\'utente è inesistente.',

    'gphd__mime_types' => 'Tipi MIME',
    'gphd__handlers' => 'Gestori di Apache',
    'gphd__ip_restrictions_allow' => 'Consenti l\'accesso al sito per gli host e le reti specificati (esclusi quelli rifiutati)',
    'gphd__ip_restrictions_deny' => 'Rifiuta l\'accesso al sito a host e reti specificati',
    'gphd__directory_index' => 'File indice',
    'gphd__nginx_transparent_mode' => 'La modalità in cui Apache gestisce il contenuto sia statico che dinamico, mentre nginx trasmette solo le richieste e le risposte HTTP senza modifiche.',
    'gphd__nginx_serve_static' => 'Servi file statici direttamente da Nginx',
    'gphd__nginx_static_extensions' => 'Le estensioni file statiche devono essere gestite da nginx',
    'gphd__nginx_serve_php' => 'Elabora file PHP da nginx',
    'gphd__www_root' => 'Directory Radice WWW',

    'eol__none' => 'Non modificare',
    'eol__lf' => 'converti allo stile Unix',
    'eol__cr' => 'converti allo stile MacOS',
    'eol__crlf' => 'converti allo stile Windows',

    'ui__dns_bad_zone' => 'Zona incoerente "%1":',
    'ui__dns_ns_has_no_address_records' => 'Il record NS "%1" non ha record dell\'indirizzo (A o AAAA).',
    '__dns_bad_zone' => 'Zona incoerente "%1":',
    '__dns_ns_has_no_address_records' => 'Il record NS "%1" non ha record dell\'indirizzo (A o AAAA).',
    '__dns_ptr_is_wildcard' => 'Il record PTR "%1" non è valido: Il record punta verso un dominio wildcard.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Consenti l\'accesso remoto per l\'utente del database \'%3\' del cliente \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Impossibile consentire le connessioni remote per l\'utente del database \'%1\': Impossibile determinare il numero di porta TCP usato dal server Microsoft SQL \'%2\'. I possibili motivi sono i seguenti: il protocollo TCP/IP non è abilitato nella configurazione di rete del server o il server è configurato per usare porte TCP dinamiche. Configurare il server perché ascolti su una specifica porta TCP fissa e prova a consentire le connessioni remote nuovamente.',

    'command__convertResellerHasCustomer' => 'L\'account rivenditore \'%1\' ha uno o diversi account cliente. Per convertire questo account rivenditore in un account cliente, prima trasferisci questi account cliente verso un nuovo proprietario o convertili in account rivenditore.',
    'command__convertResellerNotReseller' => 'Unicamente gli account rivenditore possono essere convertiti in account cliente. \'%1\' non è un rivenditore.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Impossibile sincronizzare l\'iscrizione con il piano di servizio. Le seguenti impostazioni dell’abbonamento sono in conflitto con il piano di servizio: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'L\'account \'%1\' è un account rivenditore. Gli account rivenditore non possono essere spostati ad un nuovo proprietario poiché appartengono all\'amministratore del server.',
    'moveCustomer__wrong_owner_type' => "L'account cliente '%1' può essere spostato soltanto verso un rivenditore o admin, non verso un altro cliente.",
    'moveCustomer__customer_already_belongs_to_owner' => 'L\'account cliente \'%1\' appartiene già al proprietario selezionato.',
    'upgradeClient__user_is_admin' => 'L\'account \'%1\' non può essere convertito in account rivenditore perché questo è un account amministratore.',

    'mail__error_setting_max_connections_courier' => 'Impossibile impostare il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Impossibile impostare il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Impossibile impostare il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS) per indirizzo IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Impossibile impostare il numero massimo di connessioni (IMAP, POP3, IMAP su SSL/TLS o POP3 su SSL/TLS) per indirizzo IP per un utente di posta specifico: %1',
    'outgoing_messages_limit_value_invalid' => 'Il valore deve essere nell\'intervallo %%MIN%%..%%MAX%%. Unicamente l\'amministratore Plesk può regolare tale impostazione.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "I seguenti domini usano indirizzi email esterni per l'inoltro della posta dei messaggi inviati agli indirizzi inesistenti. I messaggi inviati a questi indirizzi non saranno contabilizzati in Outgoing Mail Control:\n%1",
    'outgoing_messages_white_list_not_empty' => 'I limiti di posta in uscita non avranno effetto per i mittenti di posta con indirizzi IP appartenenti alla lista bianca del server di posta. Ad esempio, se il localhost (127.0.0.0 / 8, ::1 / 128) è nella lista bianca, tutta la posta dal server locale sarà correttamente inviata indipendentemente dalle limitazioni. I mittenti di posta possono usare sia indirizzi IP locali (siti web e script personalizzati ospitati sul server locale) o quelli esterni (clienti che inviano messaggi da client di posta installati sui loro computer o dispositivi mobili). Affinché i limiti funzionino per tutti i mittenti di posta (sia locali sia esterni), rimuovere tutti gli indirizzi IP e network dalla lista bianca. Tieni presente che rimuovere il localhost (127.0.0.0 / 8, ::1 / 128) dalla lista bianca potrebbe interrompere il funzionamento dei siti web e script che inviano posta da questo server. Per maggiori informazioni sulle limitazioni della posta in uscita, consultare il Manuale di amministrazione, sezione Protezione da Outbound Spam.',
    'outgoing_messages_relay_open' => 'L\'inoltro della posta è aperto: I limiti della posta in uscita non funzioneranno.',

    'notification_aps_app_updates_available' => 'Gli aggiornamenti sono disponibili per le seguenti applicazioni:',
    'notification_aps_app_updates_installed' => 'Gli aggiornamenti sono stati automaticamente installati per le seguenti applicazioni:',
    'notification_aps_app_updates_requirements' => 'Gli aggiornamenti sono disponibili per le seguenti applicazioni ma non possono essere installate perché le impostazioni di hosting dei corrispondenti siti web non soddisfano i requisiti d\'installazione:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" su %%parentName%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" su %%parentName%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" su %%parentName%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" su %%parentName%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). La tua versione: %%from%%. Versione disponibile: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" su %%parentName%% (%%url%%). La tua versione: %%from%%. Versione disponibile: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" su %%parentName%% (%%url%%). La tua versione: %%from%%. Versione disponibile: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nuova versione: %%to%%. Versione precedente: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nuova versione: %%to%%. Versione precedente: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nuova versione: %%to%%. Versione precedente: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Versione installata: %%from%%. Versione disponibile: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). La tua versione: %%from%%. Versione disponibile: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'Applicazione esterna',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domini',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Indirizzi e-mail',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abbonamenti',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 messaggi l\'ora',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Illimitato',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, il limite è %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 tentativo(i) di superare i limiti da %2 a %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 tentativo(i) di superare i limiti da %2 finora',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Esclusione indirizzo IP (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Il componente Fail2Ban non è installato sul server di destinazione.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installa Fail2Ban. L\'operazione potrebbe richiedere alcuni minuti.',

    'plesk_key__no_reseller_support' => 'Non sei autorizzato a gestire rivenditori a causa delle limitazioni della licenza.',
    'plesk_key__no_customers_support' => 'Non sei autorizzato a gestire clienti a causa delle limitazioni della licenza.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Impossibile passare alla visualizzazione Service Provider a causa delle limitazioni della licenza.',
    'plesk_key__no_security_core_support' => 'Le principali funzioni di sicurezza (ModSecurity e Fail2Ban) non sono disponibili a causa delle limitazioni della licenza.',
    'plesk_key__outgoing-antispam' => 'Controllo posta in uscita',
    'plesk_key__security-core' => 'Funzionalità principali di sicurezza (ModSecurity e Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Gestione di account',
    'plesk_key__can-manage-subscriptions' => 'Gestione Sottoscrizioni',
    'plesk_key__can-manage-customers' => 'Gestione di Clienti',
    'plesk_key__can-manage-resellers' => 'Gestione Rivenditori',
    'plesk_key__can-manage-custom-view' => 'Disponibilità della modalità limitata',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'La gestione di abbonamenti è disattivata ma disponi di diversi abbonamenti (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'La gestione di rivenditori è disattivata ma disponi di diversi rivenditori (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'La gestione clienti è spenta ma ci sono diversi clienti (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Alcune risorse di abbonamento non più gestibili dall\'interfaccia di Plesk (ad es. limiti delle caselle di posta e spazio su disco dei domini) ora sono impostate come illimitate.',
    'plesk_key__no_subscriptions_support' => 'Non sei autorizzato a gestire abbonamenti a causa delle limitazioni della licenza.',
    'plesk_key__no_custom_view_support' => 'Non sei autorizzato a utilizzare la modalità limitata a causa delle restrizioni della licenza.',
    'plesk_key__trial_forbidden_region' => 'Purtroppo al momento Plesk non è disponibile nella tua regione.',
    'additional_key__main_key' => 'La chiave è una chiave principale: Non è possibile caricare una chiave principale come una chiave aggiuntiva.',

    'gch__hosting_waf_rule_engine' => 'Modalità del firewall dell\'applicazione web',

    'backup__fieldset__restoration_options' => 'Opzioni di ripristino',
    'backup__restore_options__restore' => 'Ripristina',
    'backup__restore_options__domain__domain_configuration' => 'Configurazione del dominio',
    'backup__restore_options__domain__virtual_host_content' => 'Contenuto dell\'host virtuale',
    'backup__restore_options__domain__mail' => 'Posta',
    'backup__restore_options__domain__databases' => 'Database',
    'backup__restore_options__client__client_configuration' => 'Configurazione dell\'account cliente',
    'backup__restore_options__client__domains' => "Domini del cliente",
    'backup__restore_options__reseller__reseller_configuration' => 'Configurazione dell\'account rivenditore',
    'backup__restore_options__reseller__personal_domains' => "Domini del rivenditore",
    'backup__restore_options__reseller__clients' => "Clienti del rivenditore",
    'backup__restore_options__admin__server_configuration' => 'Impostazioni del server',
    'backup__restore_options__admin__administrator_configuration' => 'Configurazione dell\'account dell\'Amministratore',
    'backup__restore_options__admin__personal_domains' => "Domini dell'Amministratore",
    'backup__restore_options__admin__personal_clients' => "Clienti dell'Amministratore",
    'backup__restore_options__admin__resellers' => 'Rivenditori',

    'badge_new' => 'Nuovo',
    'upgrade_php_on_subscription' => 'Aggiorna PHP sul tuo abbonamento alla versione 5.3.0 o versioni successive.',

    'pkey_notify__body_expiration_notification' => 'La chiave di licenza è scaduta. Alcune funzioni possono non essere disponibili. Contattare il provider di hosting.',

    'crontab__crontab_entry_exists' => "L'attività pianificata esiste già.",
    'crontab__crontab_entry_not_exists' => "L'attività pianificata non esiste.",
    'crontab__invalid_values_found' => "Valori del parametro non validi.",
    'crontab__cmd_max_len' => "Il comando non può contenere più di %1 caratteri.",

    'domain__domain_exists' => "C'è un dominio con il prefisso 'www' e lo stesso nome: %1.%2.",
    'domain__subdomain_exists' => "C'è un sottodominio con il prefisso 'www' e lo stesso nome: %1.%2.",
    'domain__dalias_exists' => "C'è un alias di dominio con il prefisso 'www' e lo stesso nome: %1.%2.",
    'domain__record_exists' => "C'è un record DNS che punta all'host %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Il certificato '%1' non può essere definito come predefinito: la chiave privata non è presente.",
    'ip_addr__update_dns_error' => 'Problemi verificatisi durante l\'aggiornamento dell\'indirizzo IP nelle zone DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Impossibile aggiungere l’indirizzo IP. Questa interfaccia di rete ottiene gli indirizzi IP automaticamente.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Impossibile rimuovere l’indirizzo IP %1. Questa interfaccia di rete ottiene gli indirizzi IP automaticamente.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Impossibile correggere l’indirizzo IP %1. Questa interfaccia di rete ottiene gli indirizzi IP automaticamente.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Impossibile modificare l’interfaccia dell’indirizzo IP %1 poiché l’interfaccia di rete %2 ottiene gli indirizzi IP automaticamente.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Il limite dell\'abbonamento sul numero di %%type%% è stato superato. Il limite è %%limit%%, e %%usage%% è al momento in uso.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'La creazione di %%type%% non è consentita per questo abbonamento.',
    'shm_lmsg__resource_title__db-mysql' => 'Database di MariaDB/MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Database MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Database di PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'utenti del database',
    'shm_lmsg__resource_title__iis-application-pool' => 'Pool di applicazioni IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'account FTP addizionali',

    'db_user_unable_remove_mysql_global_privileges' => 'Impossibile rimuovere i privilegi globali di MariaDB/MySQL dell\'utente del database %1. Motivo: %2',
    'report__client_description' => 'Descrizione',

    'db__user_role_error' => 'È stato specificato un ruolo utente del database errato: %1. Scegli uno dei ruoli seguenti: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Impossibile impostare il limite della dimensione del file per il seguente database di Microsoft SQL Server perché hanno un dimensione di file superiore: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Impossibile impostare il limite della dimensione del file di registro per il seguente database di Microsoft SQL Server perché hanno un dimensione di file di registro superiore: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Impossibile configurare un indirizzo IP pubblico: deve essere presente un indirizzo IP privato.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Impossibile configurare un indirizzo IPv4 pubblico per l\'indirizzo IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Impossibile configurare un indirizzo IPv6 pubblico per l\'indirizzo IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Impossibile configurare un indirizzo IP pubblico: indirizzo IP non valido.',

    '__user_already_exists' => "L'utente %1 esiste già.",
    '__user_name_is_empty' => "Indica un nome utente.",

    'upgrade_php_on_domain' => 'Impossibile trovare la versione PHP 5.3.0 o versioni superiori in nessun dominio WordPress. Prova ad aggiornare PHP.',

    'component_name__waf' => 'Firewall di Applicazione Web',
    'component_name__vcs' => 'Sistema di Controllo Versione',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'È stato rilevato un possibile tentativo di spoofing: Il link ha cercato di mostrare del contenuto irrelevante.',
    'forceResetPasswordUpdated' => 'La tua password è stata modificata. Utilizza la nuova password per accedere a Plesk.',

    'php_handlers_error_no_available_instance' => 'Non è stato possibile creare un dominio: non ci sono gestori PHP disponibili.',
    'domain_error_unable_to_apply_hosting_settings' => 'Non è stato possibile applicare le impostazioni di hosting: %1',

    'plesk_not_configured' => 'Plesk non è configurato. Vai al pannello di controllo per eseguire la configurazione successiva all\'installazione.',
    'cmd_mail__mail_password_duplicated' => 'La coppia di indirizzo e-mail e password indicata è già esistente nel server di posta. Indica un altro indirizzo e-mail o password.',

    'extensionRequirementOs' => 'Il sistema operativo (%1) non è supportato dal pacchetto.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 è la versione meno recente supportata dal pacchetto.',
    'extensionRequirementPleskMaxVersion' => 'Le versioni a partire da Plesk %1 non sono supportate dal pacchetto.',
    'extensionBlacklisted' => 'L\'estensione %1 non è consentita per l\'installazione.',
    'extensionDisabled' => 'L\'estensione è disabilitata.',


    'optimization_settings__unable_set_mpm_event' => 'Impossibile definire la modalità mpm_event: richiede che il modulo PHP5 Apache sia disattivato ma questo modulo è usato dai domini.',
    'optimization_settings__unable_turn_off_php' => 'Impossibile disattivare il modulo PHP5 Apache: è usato dai domini.',

    'hst_def__fp_admin_login' =>  'Nome utente FTP',
    'hst_def__fp_admin_passwd' =>  'Password FTP',

    'database_user_orphaned_old_password_wrong' => "Non è stato possibile riparare l'utente orfano '%1': la password non è corretta.",
    'cannot_load_partner_central_property_key_no_exist' => "Non è stato possibile recuperare le proprietà personalizzate: la chiave di licenza non esiste.",
    'extensionScriptFailure' => "Esecuzione di %1 non riuscita, con il seguente messaggio:\n%3",
    '__ssl_redirect' => "Reindirizzamento SEO-safe 301 permanente da HTTP a HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'La gestione DKIM non è supportata.',
    'mail__dmarc_not_supported' => 'La gestione DMARC non è supportata.',
    'mail__relay_white_list_not_supported' => 'La gestione della lista bianca di relay non è supportata.',
    'mail__black_list_not_supported' => 'La gestione della lista nera non è supportata.',
    'mail__autoresponder_not_supported' => 'La gestione del risponditore automatico non è supportata.',
    'mail__autoresponder_message_subject' => 'Risposta automatica',
    'defaultcomponents__not_supported_version' => '(versione non supportata)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Il certificato \'%1\' non è stato trovato.',
    'certificate__unable_setup_certificate' => 'Impossibile installare il certificato: la chiave privata e il contenuto del certificato non sono presenti.',
    'certificate__used_by_panel' => 'Uno dei certificati che stai per eliminare viene utilizzato per proteggere Plesk.',
    'certificate__used_by_mail_server' => 'Uno dei certificati che stai per eliminare viene utilizzato per proteggere il server di posta.',
    'certificate__used_by_domain_service' => 'Uno dei certificati che stai per eliminare viene utilizzato dal servizio di dominio.',
    'mail_server__not_installed' => 'Impossibile installare il certificato per il server di posta poiché quest\'ultimo non è installato.',

    'email_activation_mail_subject' => 'Attiva il tuo account in Plesk',
    'email_activation_mail_body' => "È stato creato un account sul server Plesk %1 \n\nDettagli dell'account: \nNome: %2 \nIndirizzo e-mail: %3 \n\nSe queste informazioni sono corrette e l'account è stato creato per te, attivalo mediante il link seguente: \n\n%4. \n\nAttivando l'account, autorizzi il titolare del server a raccogliere, archiviare, elaborare e utilizzare i tuoi dati personali (nome e indirizzo e-mail) al fine di creare e supportare il tuo account, in conformità alle leggi applicabili sulla protezione dei dati attualmente vigenti, ai sensi di un contratto.",

    'backup_transport_permission_name' => 'Gestione di %1',
    'backup_transport_permission_description' => 'Consente di utilizzare %1 per l\'archiviazione dei backup.',

    'domain_move_err_target_no_hosting' => 'Impossibile trasferire il dominio a un abbonamento senza hosting.',
    'domain_move_err_already_in_target' => 'Il dominio appartiene già all’abbonamento di destinazione.',
    'domain_move_err_main_domain' => 'Impossibile trasferire il dominio principale.',
    'domain_move_err_subdomain_without_parent' => 'Impossibile trasferire il sottodominio %1 senza il dominio padre %2.',
    'domain_move_err_root_exists' => 'Il percorso di destinazione per www_root %1 è già esistente.',
    'domain_move_err_nested_roots' => 'Impossibile trasferire il dominio poiché condivide la directory principale dei documenti con un altro dominio: %1.',
    'domain_move_err_no_mail_service' => 'Impossibile trasferire il dominio poiché il servizio di posta è disattivato nell’abbonamento di destinazione.',
    'domain_move_err_app' => "L’applicazione installata in %1 non è stata trasferita all’abbonamento '%2': %3",
    'domain_move_database_used_by_app' => "Il database '%1' in %2 è utilizzato dall’applicazione trasferita. Per riassegnare il database a '%3', esegui `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "L’abbonamento di destinazione '%1\\’ è stato bloccato per la sincronizzazione.",
    'domain_move_filesharing_disabled' => 'Condivisione file disattivata.',
    'domain_move_website_preview_disabled' => 'L’anteprima del sito Web è stata disattivata.',
    'domain_move_additional_webserver_settings' => "Esamina le direttive supplementari del server Web del dominio per evitare errori di configurazione.",
    'domain_move_no_permission' => "%1 non è consentito per l’abbonamento '%2'.",
    'domain_move_no_access' => "Nessun accesso all’abbonamento '%1'.",
    'domain_split_no_create_permission' => "Creazione del dominio non consentita.",
    'domain_split_empty_login' => 'È necessario il nome di accesso dell\'utente di sistema.',
    'domain_split_empty_password' => 'È necessaria la password dell\'utente di sistema.',
    'domain_split_err_home_exists' => 'Impossibile trasferire %1 poiché il suo percorso home di destinazione esiste già in %2. Rinomina il dominio per trasferirlo a un nuovo abbonamento.',
    'domain_split_err_no_hosting_subdomains' => 'Impossibile trasferire il dominio a un nuovo abbonamento in quanto è privo di hosting ma include sottodomini. Per trasferire il dominio, modificane il valore "Tipo di hosting" in "Hosting di siti Web" (nelle Impostazioni di hosting).',
    'domain_split_target_locked' => "L'abbonamento di destinazione '%1' è bloccato per la sincronizzazione.",
    'domain_split_target_unsynced' => "L'abbonamento di destinazione '%1' non è stato sincronizzato con il piano a causa di: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Il backup pianificato è stato disattivato il '%1'.",
    'domain_merge_database_error' => "Il database '%1' in %2 non è stato trasferito all'abbonamento '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "L’FTP anonimo in '%1' è stato disattivato.",
    'domain_merge_smb_user_access' => "L’utente aggiuntivo '%1\\’ è stato trasferito all’abbonamento '%2\\’ ma il suo accesso all’abbonamento è stato revocato.",
    'domain_merge_scheduled_tasks' => "Le attività pianificate sono state trasferite nell'abbonamento di destinazione. Riesamina la configurazione delle attività.",
    'domain_merge_scheduled_tasks_deactivated' => "Le attività pianificate sono state trasferite nell'abbonamento di destinazione e disattivate. Riesamina la configurazione delle attività.",
    'domain_merge_no_remove_permission' => "La rimozione degli abbonamenti non è consentita.",
    'domain_merge_err_has_addons' => 'Impossibile trasferire il dominio principale e i suoi domini aggiuntivi; spostare prima i/il domini/o %1.',
    'domain_merge_err_has_webusers' => 'Impossibile trasferire il dominio principale e i suoi utenti web.',
    'domain_merge_err_root_exists' => 'Il percorso di destinazione %1 è già esistente.',

    'database_server_edit_used_for_psa' => 'Non è consentito l\'aggiornamento del server database MariaDB/MySQL locale.',
    'suggest_repair_main_suggestion_ui' => '<b>Puoi correggere questo errore</b> usando l\'utility `plesk repair`.',
    'suggest_repair_main_suggestion_cli' =>  'Puoi correggere questo errore usando l\'utility `plesk repair`.',
    'suggest_repair_repair_kit_link_title' => 'vai a Diagnostica e ripara',
    'suggest_repair_using_cli_and_ui' => 'A tale scopo, utilizza il comando `plesk repair %1` tramite la CLI oppure %2 e fai clic su Ripara accanto a "Database di Plesk"',
    'suggest_repair_using_cli' => 'A tale scopo, utilizza il comando `plesk repair %1` tramite la CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Il servizio DNS non era disponibile al momento della creazione del backup. Tuttavia, ci sono zone DNS attive nel backup e saranno abilitate per i seguenti oggetti: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Controller risorse (Cgroup)',
    'plesk_key__remote-smartermail-enabled' => 'Supporto di SmarterMail da remoto',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(non consentito dalla chiave di licenza)',
    'plesk_key__validation_failed' => '%1 (Codice di errore: %2)',
    'promo__button_details' => 'Dettagli',
    'promo__extension_catalog_title' => 'Catalogo di estensioni',
    'promo__extension_catalog_description' => 'Scopri il nuovo catalogo di estensioni e arricchisci Plesk con una varietà di potenti estensioni!',
    'promo__button_open_catalog' => 'Apri il catalogo',

    'backup__repository_check_login' => "Impossibile accedere all'archivio: %1 Controlla di aver inserito le credenziali di archiviazione corrette.",
    'backup__repository_check_error_list' => "Impossibile accedere all'archivio: %1 Controlla di aver inserito le impostazioni di archiviazione corrette.",
    'backup__repository_check_error_mkdir' => "Impossibile creare la directory: %1 Controlla se hai i permessi per creare cartelle nell'archivio.",
    'backup__repository_check_error_upload' => "Impossibile caricare il file sull'archivio: %1 Verifica se disponi dei permessi per caricare file sull'archivio.",
    'backup__repository_check_error_download' => "Impossibile scaricare il file dall'archivio: %1 Verifica se disponi dei permessi per caricare e scaricare i file dall'archivio.",
    'backup__repository_check_error_resume-upload' => "Impossibile riprendere l'upload del file sull'archivio: %1 Verifica se disponi dei permessi per riprendere l'upload sull'archivio.",
    'backup__repository_check_error_resume-download' => "Impossibile riprendere il download del file dall'archivio: %1 Verifica se disponi dei permessi per riprendere il download dall'archivio.",
    'backup__repository_check_error_enable-utf8' => "Impossibile far funzionare dell'archivio: %1 Controlla se l'archivio supporta la codifica UTF8.",
    'backup__repository_check_error_rm' => "Impossibile far funzionare l'archivio: %1 Verifica se disponi dei permessi per eliminare i file dall'archivio.",
    'backup__repository_check_error_rmdir' => "Impossibile far funzionare l'archivio: %1 Verifica se disponi dei permessi per eliminare le cartelle dall'archivio.",

    'backup__ftp_repository_check_login' => "%1 Puoi controllarli in modo indipendente con il comando: %2",
    'backup__ftp_repository_check_error_list' => "%1 Puoi controllarli in modo indipendente con il comando: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Puoi controllarlo in modo indipendente con il comando: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Puoi controllarlo in modo indipendente con i comandi: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Puoi controllarlo in modo indipendente con i comandi: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Puoi controllarlo in modo indipendente con i comandi: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Puoi controllarlo in modo indipendente con i comandi: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Puoi controllarlo in modo indipendente con il comando: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Puoi controllarlo in modo indipendente con i comandi: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Puoi controllarlo in modo indipendente con i comandi: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Impossibile modificare le impostazioni per DMARC. Per abilitare questa opzione, attiva la protezione antispam DKIM e SPF.',
    'spf_server_wide_disable_failed' => 'Impossibile modificare le impostazioni per la protezione antispam SPF. Per disabilitare la SPF, disattiva DMARC per la posta in arrivo.',
    'sfdk_server_wide_verify_disable_failed' => 'Impossibile modificare le impostazioni per la protezione antispam DKIM. Per disabilitare DKIM, spegnere DMARC per la posta in arrivo.',

    'ccs_not_supported' => 'L\'Archivio centralizzato certificati IIS non è configurato nel sistema.',
    'ccs_not_enabled' => 'La gestione dell\'Archivio centralizzato certificati IIS non è abilitata in Plesk.',
    'ad_not_supported' => 'Il server non è collegato ad un dominio.',

    'component_name__appinit' => "Inizializzazione applicazione",
    'component_name__cors' => "Condivisione di risorse tra le origini (CORS)",
    'component_name__httpcompression' => 'Compressione dei contenuti HTTP',
    'common_feature_is_not_supported' => 'Questa funzionalità non è più supportata.',
    'common_feature_is_not_supported_in_proto' => 'Questa caratteristica non è supportata per la versione di protocollo %1.',
    'autoinstaller__plesk_component' => 'Componente Plesk',
    'plesk_key__key_expired' => 'La chiave di licenza è scaduta. Per continuare a utilizzare Plesk, %1.',
    'plesk_key__key_purchase' => 'acquista una nuova licenza',
    'plesk_key__key_expired_period' => 'La chiave di licenza è scaduta da più di %1 giorni.',

    'sa_action_move' => 'Sposta lo spam nella cartella “Posta indesiderata”',

    'bu_conflict_resolver_tomcat_not_supported' => 'Le applicazioni Java non sono più supportate. Non saranno più disponibili per i seguenti siti web: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Le versioni mobili dei siti web ospitati con UNITY Mobile non sono più supportate. Non saranno più disponibili per i seguenti siti web: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Le norme sull\'utilizzo del server non consentono l\'utilizzo di impostazioni antivirus personali. Esse saranno ripristinate in modo incompleto per gli account di posta elettronica sui seguenti domini: {{objects}}',

    'module__not_installed' => "L'estensione %1 non è installata",

    'mail__mail_autodiscovery_server_error' => 'Specifica un nome di dominio personalizzato per il rilevamento automatico della posta',
    'mail__error_mail_autodiscovery_enable' => 'Impossibile configurare il rilevamento automatico della posta: %1',
    'mail__error_mail_autodiscovery_server' => 'Impossibile impostare un nome di dominio personalizzato per il rilevamento automatico della posta: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Impossibile riconfigurare i registri DNS di rilevamento automatico di domini: %1',

    'mail__smarthost_not_configured_error' => 'Nessuno smarthost configurato.',
    'mail__smarthost_attach_domains_error' => 'Aggiunta dei domini allo smarthost completata con errori:',

    '__invalid_url' => 'L\'URL "%1" non è valido.',
    'actionlog__cloning_start' => 'avvio',
    'actionlog__event_cloning_start' => 'Avvio clonazione del server',

    '__UPLOAD_ERR_FORM_SIZE' => "Il file caricato supera la dimensione consentita",
    '__UPLOAD_ERR_INI_SIZE' => "Il file caricato supera la dimensione consentita",
    '__UPLOAD_ERR_NO_FILE' => "Nessun file ricevuto",
    '__UPLOAD_ERR_OK' => "Caricamento completato",
    '__UPLOAD_ERR_PARTIAL' => "Il file è stato solo parzialmente caricato. Riprovare",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'La cartella temporanea non è presente',
    '__UPLOAD_ERR_CANT_WRITE' => 'Scrittura su disco fallita',
    '__UPLOAD_ERR_UNKNOWN' => 'Si è verificato un errore di caricamento di file sconosciuto',
    '__accounts' => "Informazioni personali",
    '__access' => "Accesso",
    '__address' => "Indirizzo",
    '__addresses' => "Indirizzi",
    '__acl_records' => 'Record ACL',
    '__admin_repository' => "Cartella amministratore",
    '__all' => 'Tutti',
    '__allowed' => "permesso",
    '__anonftp_status' => "FTP Anonimo",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...riavvio in corso del server-web %1, attendere prego",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Supporto di Microsoft ASP.NET",
    '__asp_win_support' => "Supporto di Microsoft ASP",
    '__attachments' => "Allegati",
    '__attachments_list' => "Allegati",
    '__author' => 'Autore',
    '__autoresp_name_already_exists' => "Esiste già una risposta automatica con il nome %1.",
    '__autoresponder' => "Risposta automatica",
    '__autoresponders' => "Risposte automatiche",
    '__autoresponders_list' => "Risposte automatiche",
    '__autoresponder_attachment_files' => "File in allegato alla risposta automatica",
    '__auto_updates_list' => 'Aggiornamenti disponibili',
    '__backup_utilites' => "Utilità Backup",
    '__bind_status' => "Stato DNS Server",
    '__bu_is_not_installed' => "Servizio non disponibile: le utility di backup non sono state installate.",
    '__bu_not_support_in_key' => "La licenza non supporta le funzioni di backup.",
    '__notifications_not_support_in_key' => 'Le notifiche non sono supportate dalla chiave di licenza',
    'disabled_by_key' => 'Non supportati dalla chiave di licenza',
    '__bytes' => "byte",
    '__can_not_use_reserved_words' => "Non potete utilizzare le parole riservate.",
    '__certificate' => "Certificato",
    '__cgi_support' => "Supporto di CGI",
    '__city' => "Città",
    '__cl_not_exist' => "L'account cliente non esiste.",
    '__client' => 'Cliente',
    '__client_card' => "Carta del cliente",
    '__client_contact_name' => "Nome di contatto del cliente",
    '__client_form' => "Informazioni personali",
    '__client_ip_pool' => "Pool IP del cliente",
    '__client_limits' => "Limiti dell'account cliente",
    '__client_permissions' => "Permessi del cliente",
    '__client_preferences' => "Preferenze del cliente",
    '__client_status' => "Stato del cliente",
    '__client_total' => "Totale Cliente",
    '__client_with_login_name_already_exists' => "Esiste già un utente con il nome utente \"%1\".",
    '__client_domuser_with_login_already_exists' => "Il nome utente '%1' è già utilizzato dall'amministratore del dominio '%1'.",
    '__clients_global_changes' => "Modifica gli account cliente selezionati",
    '__cmd_not_found' => "Comando sconosciuto: %1",
    '__comments' => "Commenti",
    '__component_version' => "Versione del componente",
    '__component_not_installed' => "Il componente %1 non è stato installato",
    '__confirm_overwrite' => "Conferma la sovrascrittura.",
    '__confirm_stop' => "Devi confermare l'interruzione del processo",
    '__confirm_passwd' => "Confermare la password %1",
    '__conhelp' => "Descrizione",
    '__contact_name' => "Nome di contatto",
    '__country' => "Paese",
    '__countries' => 'Paese',
    '__country_unknown' => 'Impossibile riconoscere il codice della nazione.',
    '__courier-imap' => 'Server Courier',
    '__create_domain' => 'Crea un dominio',
    '__crypted' => 'crittografato',
    '__cp_access' => "Accesso a Plesk",
    '__cp_user' => "Utente Plesk",
    '__create' => "Crea",
    '__create_client_template_without_template' => "Crea account utente senza modello",
    '__create_domain_for' => "Crea un dominio per <b>%1</b>",
    '__create_domain_template_without_template' => "Crea nuovo dominio senza template",
    '__creation_date' => "Data di creazione",
    '__crontab_unix' => "Pianificatore",
    '__crontab_win' => "Pianificatore",
    '__ct_month_jan' => 'Gennaio',
    '__ct_month_feb' => 'Febbraio',
    '__ct_month_mar' => 'Marzo',
    '__ct_month_apr' => 'Aprile',
    '__ct_month_may' => 'Mag',
    '__ct_month_jun' => 'Giugno',
    '__ct_month_jul' => 'Luglio',
    '__ct_month_aug' => 'Agosto',
    '__ct_month_sep' => 'Settembre',
    '__ct_month_oct' => 'Ottobre',
    '__ct_month_nov' => 'Novembre',
    '__ct_month_dec' => 'Dicembre',
    '__custom_button' => "Pulsante personalizzato",
    '__custom_buttons_list' => "Link a servizi aggiuntivi",
    '__daily' => "Ogni giorno",
    '__database_not_activated' => "%1 non è stato attivato nella pagina di amministrazione del server.",
    '__database_not_installed' => "il database %1 non è installato.",
    '__database_not_run' => "il Database %1 non è attivo.",
    '__database_is_corrupt' => "Il database di Plesk è danneggiato. Lancia l'utility Reconfigurator per aggiustarlo.",
    '__databases' => "Database",
    '__databases_list' => "Database",
    '__database_type_not_supported_by_key' => 'Per usare il server %1, è necessario avere il supporto per esso nella chiave di licenza utilizzata. Consulta il tuo rappresentante Plesk.',
    '__date_immediately' => "oggi",
    '__date_never' => "mai",
    '__day(s)' => "Giorno(i)",
    '__day0' => "Dom",
    '__day1' => "Lun",
    '__day2' => "Mar",
    '__day3' => "Mer",
    '__day4' => "Gio",
    '__day5' => "Ven",
    '__day6' => "Sab",
    '__days' => "%1 giorno(i)",
    '__db_admin_login_empty' => "Hai inserito un nome utente vuoto, disattivando il controllo su %1 nell'interfaccia. Procedere?",
    '__db_unable_to_unregister' => 'Impossibile eliminare i parametri della connessione al database',
    '__db_db_exists' => 'C\'è almeno un database sul server.',
    '__db_unable_to_change_server_name' => 'Il nome del server non può essere cambiato.',
    '__db_unable_to_change_port' => 'La porta del server non può essere cambiata.',
    '__db_already_exist' => "Il Database %1 è già esistente.",
    '__db_credentials_invalid' => "Le credenziali per il database non sono valide.",
    '__db_invalid_password_characters' => 'La password contiene caratteri non validi',
    '__db_engine' => "Motore del database", // indirect
    '__db_type' => "Tipo Database",
    '__db_user' => "Utente Database",
    '__db_server' => 'Server database',
    '__def_domain' => "Dominio predefinito",
    '__default_for_mysql' => 'predefinito per MySQL',
    '__default_for_mariadb' => 'predefinito per MariaDB',
    '__default_for_percona' => 'predefinito per Percona',
    '__default_for_postgresql' => 'predefinito per PostgreSQL',
    '__delete' => "Elimina",
    '__demo' => "Questa funzione non è disponibile nella versione demo.",
    '__directory' => "Directory",
    '__disable_lock_screen' => 'Evita che gli utenti usino Plesk finché le schermate dell\'interfaccia saranno completamente caricate',
    '__dismiss_news?' => "Sei sicuro di voler completamente rimuovere questo blocco di news? Non potrai piu' visualizzare le news finche' non ne verranno inserite di nuove.",
    '__description' => "Descrizione",
    '__disabled' => "disattivato",
    '__disk_space_limit' => "Limite spazio disco",
    '__cgroups_cpu_usage_limit' => 'Limite utilizzo CPU',
    '__cgroups_ram_usage_limit' => 'Limite di utilizzo della RAM',
    '__cgroups_disk_read_usage_limit' => 'Limite di larghezza di banda di lettura disco',
    '__cgroups_disk_write_usage_limit' => 'Limite di larghezza di banda di scrittura su disco',
    '__disk_usage_by' => "Spazio disco usato da %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Il DNS record '%1' è già esistente.",
    '__dns_master_should_be_remote' => "Sarebbe necessario disporre di due server di nome di autorizzazione su host separati.",
    '__dns_record_not_exist' => "Il DNS record non esiste.",
    '__dns_server' => "Server DNS", // indirect
    '__dom_id_is_undefined' => "L'id del dominio è indefinito.",
    '__dom_name' => "Nome del dominio",
    '__dom_name_is_invalid' => "Il nome del dominio non è valido. Accertati che il nome del dominio comprenda solo simboli alfanumerici, punti e trattini e che non sia più lungo di 255 caratteri. Ogni parte del nome del dominio fra i punti non deve essere più lunga di 63 caratteri.",
    '__dom_not_exist' => "Il Dominio non esiste.",
    '__domain' => "Dominio",
    '__domain_' => 'Dominio %1',
    '__domain_form' => "Form Dominio",
    '__domain_id' => "ID dominio",
    '__domain_is_turned_off_for_backup' => "Il sito web %1 è temporaneamente disconnesso per il backup o ripristino, quindi non è al momento disponibile.",
    '__domain_limits' => "Limiti del dominio",
    '__domain_name' => "Nome del dominio",
    '__mail_name_in_ASCII_form' => "Nome dell'account di posta in formato ASCII",
    '__message_error' => 'Errore',
    '__message_warning' => 'Avvertenza',
    '__message_info' => 'Informazione',
    '__domain_name_in_ASCII_form' => "Nome dominio in formato ASCII",
    '__domain_repository' => "Cartella per dominio %1",
    '__domain_status' => "Stato del dominio",
    '__domain_found_tech' => "Tecnologia trovata sul dominio",
    '__domain_dns' => 'Zona DNS del dominio',
    '__domain_total_powerUser' => "Quantità totale per l'abbonamento",
    '__domain_user' => "Amministratore di dominio",
    '__domains_global_changes' => "Operazioni globali sul Dominio",
    '__mailnames_global_changes' => "Operazioni globali sugli account di posta",
    '__backup_manager' => 'Backup Manager',
    '__domains_list' => "Domini",
    'domains_list__list_header' => "domini",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Il nome del dominio inizia con www, nonostante sia utilizzato il prefisso WWW. Continuare comunque?",
    '__dovecot' => 'Dovecot IMAP e POP3 server',
    '__dsmail' => "Servizio di posta",
    '__dsmaillist' => "Servizio Mailing list",
    '__dumps_tot_size' => "Dimensione totale dei file di backup nell'archivio locale",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "L'indirizzo e-mail non è valido.",
    '__enabled' => "attivato",
    '__enter_cert_text' => "Inserire testo del certificato",
    '__enter_size' => "Inserire dimensione",
    '__exclusive' => "dedicato",
    '__expiration_date' => "Data di scadenza",
    '__fax' => "Fax",
    '__file' => "File",
    '__file_is_empty' => "Il file è vuoto.",
    '__file_name' => "Nome di file",
    '__file_type' => 'Tipo File',
    '__filemanager' => "Manager di File",
    '__filepath_is_empty' => "Il percorso del file è vuoto",
    '__files_list' => "File",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Impostazioni FTP",
    '__ftp_serv' => "Server FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Dovete impostare le proprietà dell'account FTP",
    '__ftp_status' => "Server FTP status",
    '__full_day0' => "Domenica",
    '__full_day1' => "Lunedì",
    '__full_day2' => "Martedì",
    '__full_day3' => "Mercoledì",
    '__full_day4' => "Giovedì",
    '__full_day5' => "Venerdì",
    '__full_day6' => "Sabato",
    '__full_month1' => "Gennaio",
    '__full_month10' => "Ottobre",
    '__full_month11' => "Novembre",
    '__full_month12' => "Dicembre",
    '__full_month2' => "Febbraio",
    '__full_month3' => "Marzo",
    '__full_month4' => "Aprile",
    '__full_month5' => "Mag",
    '__full_month6' => "Giugno",
    '__full_month7' => "Luglio",
    '__full_month8' => "Agosto",
    '__full_month9' => "Settembre",
    '__giga' => "G",
    '__h' => "H",
    '__hard_disk_quota' => "Quota rigida del disco",
    '__hard_disk_quota_not_supported' => 'la quota hard disk non è supportata a causa della configurazione del sistema di file del server',
    '__help_topic_not_found' => 'L\'argomento della guida richiesto (%1) non esiste.',
    '__hosting_ip_dns_ip_not_equiv' => "Nessuno degli indirizzi IP specificati nei record DNS A coincide con gli indirizzi IP utilizzati per l'hosting",
    '__hosting_scripting' => "Estensioni Scrip per hosting",
    '__hosting_setup_page_title' => "Impostazione hosting fisico per il dominio %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Tipologia di hosting",
    '__hostname_is_empty' => "Hostname è vuoto.",
    '__hour(s)' => 'ore',
    '__hst_type_incorrect' => "Il tipo Hosting non è corretto.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Inattività",
    '__iface' => "Interfaccia",
    '__image' => "Immagine",
    '__imap_status' => "Stato IMAP Server",
    '__incorrect_databases_login_pass' => "Le credenziali specificate per l'accesso a PostgreSQL non sono corrette.",
    '__incorrect_ip_or_network_address' => 'Indirizzo IP o di rete non validi.',
    '__info' => 'Info',
    '__install' => "Installa",
    '__install_prefix' => "Prefisso Installazione",
    '__invalid_cert_id' => "ID certificato non valido",
    '__invalid_context' => "Contesto non valido: %1",
    '__invalid_db_usr_name' => "Nome utente per il database non valido.",
    '__invalid_dir_name' => "Nome directory non valido",
    '__invalid_dom_name' => "Nome del dominio non valido.",
    '__invalid_filename' => "Nome del file non valido. Non utilizzare virgolette singole e/o la combinazione \"../\".",
    '__invalid_id' => "Identificatore non valido.",
    '__invalid_lines_num' => "Valore non valido per numero di line, solo caratteri numerici consentiti.",
    '__invalid_max_letter_size' => "La dimensione massima del testo non è valida.",
    '__invalid_restart_apache_interval' => "L'intervallo del riavvio di Apache non è valido",
    '__invalid_tmpl_name' => "Il nome del Template non è valido.",
    '__invalid_value' => "Valore non corretto.",
    '__ip_addr' => "Indirizzo IP",
    '__ip_address_and_mask' => "Indirizzo IP e maschera di sottorete",
    '__ip_alias__mask' => "Indirizzo IP e maschera di sottorete",
    '__ip_addr_is_invalid' => "Indirizzo IP non è valido.",
    '__ip_addr_list' => "Indirizzi IP",
    '__ip_address_and_mask_hint' => 'Per esempio, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KByte",
    '__key_for_virtuozzo_only' => "La tua chiave di licenza è destinata all'utilizzo esclusivo di Virtuozzo Containers.",
    '__key_limits_exceeding' => "Questa azione supera i limiti della vostra licenza. Se viene visualizzato questo messaggio, dovete contattare il vostro fornitore per chiarire o estendere i limiti di questa licenza.",
    '__kilo' => "K",
    '__keywords' => 'Chiavi',
    '__lang_unknown' => 'Impossibile riconoscere il linguaggio.',
    '__languages' => 'Lingua',
    '__learn_more' => 'Più info',
    '__loading' => 'Caricamento in corso...',
    '__locales' => "Pacchetto lingua",
    '__lists' => "Liste di posta",
    '__literal_bytes' => "B",
    '__processing' => "Attendere.<br>Caricamento in corso ...",
    '__locale' => "Lingua interfaccia",
    '__locale_is_not_defined' => "La lingua dell'interfaccia non è definita.",
    '__local_server_mysql' => 'Server locale MariaDB/MySQL',
    '__local_server_postgresql' => 'Server PostgreSQL locale',
    '__local_server_mssql' => 'Server MS SQL locale',
    '__log_and_statistics_files' => 'File di registro e rapporti statistici',
    '__config_files' => 'File di configurazione',
    '__chroot_files' => 'Ambiente Chroot',
    '__login' => "Login %1",
    '__login1' => "Accedi",
    '__login_disabled' => "Login proibito",
    '__login_enabled' => "Login consentito",
    '__login_incorrect' => "Hai inserito un nome utente o password non validi.",
    '__login_name' => "Nome utente %1",
    '__login_name_is_invalid' => "Il nome utente %1 non è valido.",
    '__logon_time' => "Tempo di connessione",
    '__ma' => "Mail alias",
    '__mail' => "Posta",
    '__mail_alias_name' => "Nome alias di Mail",
    '__mail_autodiscovery' => 'Rilevamento automatico della posta',
    '__mail_exchanger_name_is_invalid' => "Il nome del Mail exchanger non è valido.",
    '__mail_groups' => "mail group",
    '__mail_list_engine' => "Software per Mailing list",
    '__mail_name' => "Account di posta",
    '__mail_name_form' => "Proprietà dell'account di posta",
    '__mail_names' => "Account di posta",
    '__mail_serv' => "Server di posta",
    '__mail_user' => 'Utente Mail',
    '__mailgroup' => "mail group",
    '__maillist' => "Mailing list",
    '__maillists' => "Liste di posta",
    '__maillist_member' => 'Iscritto alla mailing list',
    '__mailname' => "Account di posta",
    '__mailname_redir_self' => "L'account di posta non può inoltrare posta a sé stesso.",
    '__max_dom_num_reached_for_cl' => "È stato raggiunto il limite di domini per questo account cliente.",
    '__max_file_size_available' => "Dimensione massima file: %1",
    '__max_subdom_num_reached_for_cl' => "È stato raggiunto il limite di sottodomini per questo account cliente.",
    '__max_subdom_num_reached_for_dom' => "È stato raggiunto il limite di sottodomini per il dominio.",
    '__max_subdom_num_reached_for_key' => "È stato raggiunto il limite di sottodomini consentiti dalla chiave di licenza.",
    '__max_traffic_limit' => "Limite Traffico",
    '__maximum_excl_ip_num' => "Account di posta",
    '__mb' => "MB",
    '__mbytes' => "megabyte",
    '__mb_month' => "MB/mese",
    '__mb_sec' => "MB/sec",
    '__gb_sec' => "GB/s",
    '__tb_sec' => "TB/s",
    '__mega' => "M",
    '__minute(s)' => 'Minuti',
    '__mls_not_in_key' => "La vostra licenza non supporta l'interfaccia multilingue.",
    '__modification_date' => "Data di modifica",
    '__module' => "Estensione",
    '__month' => "Mese",
    '__month(s)' => "Mese(i)",
    '__month1' => "Gen",
    '__month10' => "Ott",
    '__month11' => "Nov",
    '__month12' => "Dic",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "Aprile",
    '__month5' => "Mag",
    '__month6' => "Giugno",
    '__month7' => "Luglio",
    '__month8' => "Ago",
    '__month9' => "Set",
    '__monthly' => "Mensile",
    '__months' => "Mesi",
    '__moved_permanently' => 'Rimosso permanentemente',
    '__mssql' => "Microsoft SQL server",
    '__mssql__server' => "Server",
    'mssql__server' => "Nome server Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "il nome del server non può essere cambiato: c'è almeno un database su di esso.",
    '__mssql_status' => "Stato Microsoft SQL server",
    '__multiply_login_deny' => "Impossibile effettuare il tuo accesso. Un altro utente è già connesso a Plesk con lo stesso nome utente (%1).",
    '__mysql' => "MySQL",
    '__mysql_status' => "Stato del server MySQL",
    '__mysql_version' => "Versione MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Stato del server MariaDB",
    '__mariadb_version' => "Versione MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Stato del server Percona",
    '__percona_version' => "Versione Percona",
    '__name' => "Nome",
    '__name_invalid' => "Il nome non è valido.",
    '__nameserver' => "nameserver",
    '__network' => "Rete",
    '__networks' => "Network",
    '__no' => "Nessuno",
    '__no_ip_address_with_properly_type_available' => "Impossibile ripristinare i dati del backup perché non ci sono indirizzi IP disponibili per il ripristino.",
    '__no_clients_specified' => "Nessun account cliente specificato.",
    '__no_comments' => "Nessun commento.",
    '__nologin' => "Non permesso",
    '__none' => "Nessuno",
    '__not_configured' => "Non configurato",
    '__not_implemented_yet' => "Non implementato",
    '__not_supported_by_ftp' => "(non supportato dal server FTP )",
    '__notification' => "Notifica",
    '__num_displayed' => "%1 di%2 visualizzato",
    '__num_is_invalid' => "Numero non valido.",
    '__object_not_found' => 'Oggetto non trovato: %1',
    '__off' => "Disattivato",
    '__ok' => "OK",
    '__old_passwd' => "Vecchia password: %1",
    '__on' => "Attivato",
    '__others' => "Altri",
    '__other_ip__will_be_added' => 'Altri indirizzi IP disponibili (verranno aggiunti al pool IP del cliente)',
    '__p' => "P",
    '__passwd' => "Password %1",
    '__passwd_is_invalid' => "%1 - Password non valida.",
    '__path' => "Percorso",
    '__perl_unix_support' => "Supporto di Perl",
    '__perl_win_support' => "Supporto di Perl",
    '__perm_denied' => "Accesso Negato.",
    '__permissions' => "Permessi",
    '__personal_name' => "Nome personale",
    '__pg_admin_not_activated' => "PostgreSQL non è stato attivato sulla pagina dell'amministratore del server.",
    '__pg_not_inst' => "Il PostgreSQL non è stato installato.",
    '__pg_not_run_or_inst' => "Il PostgreSQL non è stato installato o non è attivo.",
    '__pg_not_support_in_key' => "PostgreSQL non è supportato dalla chiave della licenza.",
    '__phone' => "Telefono",
    '__phosting' => "Hosting fisico",
    '__php_support' => "Supporto PHP",
    '__php_run_as_isapi' => "esegui come estensione ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' attivo",
    '__php_version' => "Versione PHP",
    '__physical' => "Hosting fisico",
    '__plesk_stat_pdir' => "Directory protetta '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Statistiche dominio",
    '__plesk_stat_protect' => "Proteggi l'accesso alle statistiche web con il nome utente e la password del FTP dell'utente",
    '__plesk_stat_protect_install' => "accessibile tramite la directory protetta da password '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Stato server POP3",
    '__popen_error' => "Si è verificato un errore durante la chiamata della funzione popen.",
    '__port' => 'Porta',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Stato PostgreSQL",
    '__preferences' => "Impostazioni",
    '__account_preferences' => "Impostazioni account",
    '__interface_preferences_general' => 'Generale',
    '__interface_preferences_default' => 'Preferenze predefinite interfaccia',
    '__interface_preferences_admin' => "Preferenze interfaccia amministratore",
    '__interface_template' => 'Modello personalizzazione interfaccia',
    '__interface_preferences' => "Preferenze dell'interfaccia",
    '__proceed?' => "Volete procedere?",
    '__provider_contact_name' => "Nome di contatto del proprietario",
    '__python_unix_support' => "Supporto di Python",
    '__python_win_support' => "Supporto di Python",
    '__quota' => "Quota",
    '__r' => "R",
    '__reconfigure' => "Riconfigura",
    '__record_type' => "Tipo di record",
    '__release' => "Release",
    '__remote_db_not_supported_by_key' => 'L\'hosting del database remoto non è supportato dalla tua chiave della licenza',
    '__remove_protection' => 'Rimuovi la Protezione',
    '__report' => "Segnala",
    '__report_size_na' => "Servizio non disponibile",
    '__reports_list' => "Report",
    '__requested' => "Richiesto",
    '__required_fields' => "Campi obbligatori",
    '__resp_name_invalid' => "Il nome della risposta automatica non è valido. Usa solo caratteri alfanumerici, punti, caratteri di sottolineatura e spazi in bianco.",
    '__c' => "A", // Access to panel
    '__s' => "A",
    '__server_name_is_invalid' => "Il nome del server non è valido.",
    '__screenshots' => 'Istantanee',
    '__script_warning' => "L'eliminazione delle capacità di script per questo dominio provocherà la visualizzazione degli script come testo, una volta chiamati dal browser. Si consiglia alll'amministratore di eliminare tutti gli script dipendenti da questa opzione dal dominio.",
    '__sec' => "Secondi",
    '__second(s)' => "Secondo(i)",
    '__see_list_of_logged_in' => "Visualizzare la lista degli utenti attualmente connessi.",
    '__select_certs_to_remove' => "Seleziona i certificati da rimuovere.",
    '__select_files_to_remove' => "Seleziona i file da rimuovere.",
    '__select_ip' => "Assegnare indirizzo IP",
    '__select_ip_to_remove' => "Seleziona un indirizzo IP da rimuovere.",
    '__select_domain_template' => "Usare impostazioni del modello del dominio",
    '__select_templates_to_remove' => "Seleziona template da rimuovere",
    '__server' => "Server",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Server database MariaDB/MySQL",
    '__service_description__mysql' => "Server database MariaDB/MySQL",
    '__service_title__web' => "Server web",
    '__service_description__web' => "Server web",
    '__service_title__smtp' => "Server SMTP",
    '__service_description__smtp' => "Server SMTP",
    '__service_title__mail' => "Server IMAP/POP3",
    '__service_description__mail' => "Server IMAP/POP3",
    '__service_title__dns' => "Server DNS",
    '__service_description__dns' => "Server DNS",
    '__service_title__postgresq' => "Server database PostgreSQL",
    '__service_description__postgresq' => "Server database PostgreSQL",
    '__service_title__spamassassin' => "Servizio antispam SpamAssassin",
    '__service_description__spamassassin' => "Servizio antispam SpamAssassin",
    '__all_services' => "Tutti i servizi",
    '__sessions' => "Sessioni",
    'sessions__feature_ftp_session_manager_not_supported' => "Le sessioni FTP non sono supportate dal server FTP corrente",
    '__sessions_list' => "Sessioni",
    '__set' => "Attiva",
    '__shared' => "Condivisi",
    '__shell_access_warning' => "Consentire l'accesso è altamente pericoloso per la sicurezza del sistema. Permettere l'accesso al sistema esclusivamente se vi rendete pienamente conto di quello che state facendo e solo ad utenti di cui nutrite la massima fiducia. Volete veramente consentire l'accesso al sistema?",
    '__siteapp_not_support_in_key' => "Le applicazioni web non sono supportate dalla chiave della licenza",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'La configurazione di questa applicazione web è stata modificata in modo manuale. Al fine di proteggere le modifiche manuali, la riconfigurazione mediante Plesk non è disponibile.',
    '__site_management' => "Pubblicazione web", // indirect
    '__size' => "Dimensione",
    '__skins' => 'Skin',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Stato SMTP server",
    '__some_fields_are_empty_or_invalid' => "Alcuni campi sono vuoti o contengono dati non validi.",
    '__no_email_addresses_selected' => 'Non è stato selezionato alcun indirizzo e-mail.',
    '__unable_to_set_parameters' => "Impossibile impostare parametri del componente.",
    '__spamassassin' => "Filtro antispam",
    '__spamassassin_status' => "Stato SpamAssassin",
    '__spamd_status' => 'Stato Spamassassin',
    '__splited_backup' => "(backup multivolume)",
    '__split_backup_file' => "Crea un backup multivolume",
    '__split_backup_size' => "Dimensione del volume",
    '__split_backup_less_than_500' => "Non sono supportati volumi con dimensioni inferiori a 500 megabytes",
    '__ssi' => "SSI",
    '__ssi_support' => "Supporto di SSI",
    '__ssi_with_html' => "usa SSI per i file *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Supporto SSL/TLS",
    '__same_ssl' => "Utilizza una directory singola per gestire i contenuti SSL/TLS e non-SSL/TLS",
    '__same_ssl_cu' => "Contenuti comuni SSL/TLS e non-SSL/TLS",
    '__state' => "Stato/Provincia",

    '__status__Active' => 'Attivo/a',
    '__status__active' => 'attivo',
    '__status__Passive' => 'Disattivato',
    '__status__passive' => 'disattivato',
    '__status__off' => 'disattivato',
    '__status__with_parent' => 'disattivato',
    '__status__backup_restore' => 'temporaneamente sospeso per il backup o per il ripristino',
    '__status__admin' => 'sospeso dall\'amministratore del server',
    '__status__resseler' => 'sospeso dal rivenditore',
    '__status__client' => 'sospeso dal cliente',
    '__status__unknown' => 'Lo stato è sconosciuto',

    '__status_of' => "stato %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Server Stunnel", // indirect
    '__subdomain' => "Sottodominio",
    '__subdomain_name' => "Nome del sottodominio",
    '__subdomain_name_in_ASCII_form' => "Nome di sottodominio in formato ASCII",
    '__subdomains' => "Sottodomini",
    '__domainaliases' => "Alias di dominio",
    '__subdomains_list' => "Sottodomini",
    '__subdomains_not_support_in_key' => "I sottodomini non sono supportati dalla vostra licenza",
    '__sys_user_type' => "Utente FTP",
    '__sys_user_type_main' => "Utilizzare l'account FTP del dominio principale",
    '__sys_user_type_native' => "Crea un utente FTP per questo sottodominio",
    '__target_domain' => "Dominio di destinazione",
    '__template' => "Modello",
    '__template_not_accepted' => "Non è possibile accettare il template: le seguenti limitazioni vengono superate.",
    '__templates' => "Template",
    '__templates_list' => "Template",
    '__tera' => "T",
    '__title' => "Titolo",
    '__total' => "Totale %1",
    '__total_size' => "Dimensione totale",
    '__total_used' => "Utilizzato",
    '__traffic' => "Traffico",
    '__traffic_by_client' => "Traffico dal cliente",
    '__traffic_by_domain' => "Traffico per dominio",
    '__traffic_by_service' => "Traffico per servizio",
    '__traffic_history' => "Storico traffico",
    '__unable_change_locale' => "Impossibile cambiare l'interfaccia della lingua: %1",
    '__unable_create_new_dom' => "Impossibile creare un dominio: %1",
    '__unable_define_dom_name' => "Impossibile definire il nome del dominio: %1",
    '__unable_define_necessary_properties' => "Impossibile definire le proprietà richieste.",
    '__unable_define_properties' => "Impossibile definire le proprietà: %1",
    '__unable_exec_util' => "Impossibile eseguire l'utilità : %1",
    '__unable_get_dns_a_recs' => "Non e' possibile recuperare gli indirizzi IP per i record A DNS per questo account di hosting: %1",
    '__unable_get_mbox_quota' => "Impossibile recuperare le informazioni sul limite della dimensione della casella postale.",
    '__unable_redirect_to_myself' => "L'inoltro allo stesso account non è possibile.",
    '__unable_redirect_to_my_alias' => "Impossibile inoltrare posta ad un alias di posta.",
    '__default_domain_redirect_to_myself' => "Impossibile impostare il dominio come predefinito per l'indirizzo IP:\nrilevato reindirizzamento su sé stesso.",
    '__unable_remove_client' => "Impossibile rimuovere il cliente: %1",
    '__unable_set_up_mbox_quota' => "Impossibile impostare la quota per la mailbox: %1",
    '__unable_setup_pass' => "Impossibile configurare la password: %1",
    '__unable_to_create_new_account' => "Impossibile creare un account: %1",
    '__unable_to_define_db_size' => "Impossibile definire la dimensione del database.",
    '__unable_to_enable_short_names' => "Impossibile permettere l'uso di nomi brevi di account di posta per gli account POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Impossibile ottenere i dati immessi: %1",
    '__unable_to_open_file' => "Impossibile aprire il file %1: %2.",
    '__unable_to_update_subdomain' => "Impossibile applicare le modifiche al ottoominio: %1",
    '__unable_update_cl_data' => "Impossibile salvare le modifiche nell'account utente: %1",
    '__unable_update_db_params' => "Impossibile aggiornare i parametri del database: %1",
    '__unable_update_dom_data' => "Impossibile aggiornare i dati del dominio: %1",
    '__undefined' => "non definito",
    '__uninstall' => "Disinstalla",
    '__unknown_error' => "Errore sconosciuto",
    '__unlimited_lower' => "Illimitato",
    '__unset' => "Disattiva",
    '__update' => "Aggiorna",
    '__uploaded_file_is_invalid' => "Il file caricato non è valido: %1",
    '__url' => "URL",
    '__usage' => "Utilizzo del disco",
    '__user_already_logged' => "Un altro utente è già connesso a Plesk con lo stesso nome utente (%1).",
    '__version' => "Versione",
    '__aps_license' => "Chiave di licenza",
    '__vh_type' => "Tipo virtual host",
    '__vhosts_apache_status' => "Stato server web",
    '__wrong_charset_conversion' => 'Set di caratteri errato, la conversione da "%1" a "%2" non è consentita',
    '__warning_' => "ATTENZIONE!",
    '__warning_excl_ip_num' => "Indirizzo IP dedicato",
    '__warning_expiration' => "Data di scadenza",
    '__web_scripting' => "Scripting web", // indirect
    '__web_serv' => "Server web", // indirect
    '__web_statistic' => "Statistiche web", // indirect
    '__webmail' => "WebMail", // +indirect
    '__webstat_not_installed' => "Webalizer non è installato sul server. Contatta il tuo service provider per chiedere assistenza per l'installazione di Webalizer.",
    '__webstat_support' => "Statistiche web",
    '__webstat_awstats_support' => "AWstats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWstats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Quando passi da un programma di statistiche ad un altro, tutti i rapporti creati dal programma di statistiche usato in precedenza vengono annullati per creare nuovi rapporti secondo l'informazione presente dei file di registro memorizzati nel server. Questo vuol dire che se hai configurato il sistema (su Domini > nome di dominio > Manager di Registri > Rotazione di Registri) affinché i file di registro vengano memorizzati solo durante l'ultimo mese, allora le statistiche web saranno disponibili solo per l'ultimo mese. Vuoi passare ad un altro pacchetto di statistiche?",
    '__webstat_perm_denied' => 'Non hai permessi per gestire le statistiche web.',
    '__webuser' => "utente web",
    '__sysusers_list' => "Utenti di sistema",
    '__sysuser' => "Utente di sistema",
    '__weekly' => "Settimanalmente",
    '__whats_new_in_version' => "Novità in Plesk %1",
    '__wrong_hosting_type__virtual_required' => "Questa operazione è disponibile solo per i domini con hosting web.",
    '__wrong_hosting_type__none' => 'Non c\'è un hosting fisico configurato su questo dominio %1.',
    '__wrong_hosting_type__std_fwd' => 'Il dominio %1 ha l\'inoltro standard configurato. Questa operazione è disponibile solo per i domini con hosting web.',
    '__wrong_hosting_type__frm_fwd' => 'Il dominio %1 ha l\'inoltro frame configurato. Questa operazione è disponibile solo per i domini con hosting web.',
    '__wu' => "Utenti web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Il prefisso WWW è stato modificato. Assicurati di modificare il certificato SSL/TLS in modo che rispecchi le modifiche.",
    '__year' => "Anno",
    '__year(s)' => "Anno(i)",
    '__yes' => "Sì",
    '__you' => "Tu",
    '__zip_code' => "Codice di Avviamento Postale",
    '__form_normal' => "Normale",
    '__form_advanced' => "Avanzato",

    'admin_ed__edit_administrator_info' => "Modifica del profilo dell'amministratore",
    'admin_ed__create_default_client' => "Vorrei creare un account cliente predefinito.",
    'admin_ed__unable_update' => "Impossibile aggiornare le informazioni sull'amministratore: %1",

    'auth__update_admin_info' => "Inserire le informazioni sull'amministratore. Sono richieste per effetture l'operazione %1.",
    'auth__you_not_have_perm' => "Privilegi insufficienti per gestire questo dominio.",
    'auth__key_expired_admin' => 'La tua licenza di Plesk è scaduta. Per continuare a utilizzare Plesk, rinnova la licenza o acquistane una nuova.',
    'auth__key_expired_admin_restricted' => 'La tua licenza di Plesk è scaduta. Per continuare a utilizzare Plesk, contatta il fornitore di servizi.',
    'auth__key_expired_client' => 'La licenza di Plesk è scaduta. Contattare il provider di hosting.',
    'autoinstaller__not_installed' => 'I componenti di autoinstaller non sono installati.',
    'autoinstaller__release_action' => 'Operazioni disponibili',
    'autoinstaller__release_action_icon' => 'A',
    'autoinstaller__release_action_upgrade' => 'Aggiornamento alla nuova versione di Plesk.',
    'autoinstaller__release_action_update' => 'In fase di aggiornamento o aggiunta nuovi componenti',
    'autoinstaller__release_action_up2date' => 'La vostra versione è aggiornata',
    'autoinstaller__component_action' => 'Stato',
    'autoinstaller__component_action_icon' => 'A',
    'autoinstaller__component_action_install' => 'Non installato',
    'autoinstaller__component_action_update' => 'Gli aggiornamenti sono disponibili',
    'autoinstaller__component_action_upgrade' => 'È disponibile un aggiornamento',
    'autoinstaller__component_action_up2date' => 'La vostra versione è aggiornata',
    'autoinstaller__component_action_error' => 'Gli aggiornamenti non sono disponibili',
    'autoinstaller__component_serverbuildtime' => 'Ultima versione',
    'autoinstaller__component_localbuildtime' => 'La tua versione',
    'autoinstaller__component_installed_version' => 'La tua versione',
    'autoinstaller__component_available_version' => 'Ultima Versione',
    'autoinstaller__component' => 'Componente',
    'autoinstaller__components' => 'Componenti',
    'autoinstaller__components_title' => 'Componenti di %1',
    'autoinstaller__component_dependency_note' => 'è richiesto per l\'installazione dei componenti che hai selezionato',
    'autoinstaller__install_confirm' => 'Sì, voglio installare questi componenti',
    'autoinstaller__install_confirm_request' => 'Selezionare la casella di controllo per confermare.',
    'autoinstaller__install_title' => 'Conferma l\'installazione dei componenti selezionati',
    'autoinstaller__key_update_confirm' => 'Conferma salto aggiornamento chiave e installazione della chiave predefinita',
    'autoinstaller__key_update_confirm_request' => 'Prego seleziona il checkbox per confermare.',
    'autoinstaller__key_update_failed' => '<p>Plesk non può aggiornare la licenza del prodotto.</p><p>%1</p><p>Se si continua l\'aggiornamento senza disporre di una licenza adeguata al prodotto, verrà installata una licenza predefinita con funzionalità limitata. Si consiglia agli amministratori di acquistare prima la chiave di licenza occorrente per proseguire all\'aggiornamento del prodotto.</p>',
    'autoinstaller__email' => 'Invia notifica a',
    'autoinstaller__email_admin' => "E-mail dell'amministratore",
    'autoinstaller__email_email' => 'Indirizzo e-mail del cliente...',
    'autoinstaller__release' => 'Nome versione',
    'autoinstaller__releases' => 'Versioni disponibili',
    'autoinstaller__releases_title' => 'Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Seleziona i componenti da installare',
    'autoinstaller__status_error' => 'Errore; %1.',
    'autoinstaller__status_install_error' => 'Impossibile avviare l\'installazione: %1.',
    'autoinstaller__status_install_busy' => 'L\'installazione non può essere avviata: è in corso un\'altra sessione di installazione.',
    'autoinstaller__status_install_ok' => 'Installazione avviata. Verrai informato sulla procedura d\'installazione per posta elettronica (%1).',
    'autoinstaller__status_query_busy' => 'L\'Installazione è in corso.',
    'autoinstaller__status_query_error' => 'Impossibile verificare lo stato dell\'installazione: %1',
    'autoinstaller__status_unknown' => 'Impossibile ripristinare lo stato dell\'autoinstallazione.',
    'autoinstaller__status_busy' => 'L\'autoinstallazione è occupata, si prega di attendere.',
    'autoinstaller__configure_title' => 'Impostazioni di aggiornamento',
    'autoinstaller__preferences_legend' => 'Impostazioni',
    'autoinstaller__target' => 'Cartella di download temporanea',
    'autoinstaller__target_invalid' => "Specifica il percorso assoluto",
    'autoinstaller__check_updates' => 'Verifica gli aggiornamenti dopo l\'accesso a Plesk come amministratore',
    'autoinstaller__check_updates_warning' => 'Nuovi <a href="%1">aggiornamenti</a> disponibili per %2',
    'autoinstaller__source_type' => 'Sorgente',
    'autoinstaller__source' => 'URL Sorgente',
    'autoinstaller_source__preferences_legend' => 'Impostazioni',
    'autoinstaller_source__type' => 'Sorgente',
    'autoinstaller_source__url_invalid' => 'Fonte non valida',
    'autoinstaller_source__url_invalid_network' => 'URL di fonte non valida (Esempio: http://source, ftp://source)',
    'autoinstaller_source__url' => 'URL Sorgente',
    'autoinstaller__source_invalid_network' => 'Hai specificato un indirizzo di rete non valido',
    'backup__repository' => 'Percorso dell\'archivio dei file di backup',
    'backup__error_notify_email' => 'Se si verificano degli errori durante il backup, invia una segnalazione per e-mail',
    'backup__dump_info' => "Informazioni di Backup",
    'backup__dump_file_name_not_defined' => "Nome file del backup non specificato",
    'backup__local_file' => 'File backup locale',
    'backup__domain_ftp' => 'server FTP remoto',
    'backup__wrong_path' => "Percorso errato dell'archivio dei file di backup: Non usare la sequenza di caratteri ../../",
    'backup__unable_to_connect_to_ftp_server' => "Impossibile connettersi al server FTP: %1",
    'backup__unable_to_read_file' => 'Impossibile leggere il file di backup.',
    'backup__backup_task_does_not_exist' => "Non sono presenti task per la creazione di backup. Dovete crearlo prima di attivarlo.",
    'backup__restore_params' => "Parametri di ripristino",
    'backup__confirmation' => "Attenzione: il dominio non sarà disponibile durante il backup/ripristino.",
    'backup__backup_method' => 'Tipo Backup',
    'backup__dumpfile_name' => "Nome del file di backup",
    'backup__dumpfile_name_is_invalid' => "Il nome del file di backup non è valido: utilizzare soltanto caratteri alfanumerici, linee, sottolineature e punti, non utilizzare nomi tipo descrizione.* come nome del file di backup.",
    'backup__email_required' => "Il tuo indirizzo email è necessario al fine di tenerti informato sulle procedure di backup e ripristino. Specifica il tuo indirizzo e-mail nelle informazioni dell'account.",
    'backup__error_during_backup' => "Impossibile creare Il file di backup: %1",
    'backup__input_email_warning' => "È necessario indicare un indirizzo e-mail per le notifiche o deselezionare la casella di controllo.",
    'backup__make_download' => "non salvare il file di backup nell'archivio, effettuarne solo il download",
    'backup__make_dump' => 'crea il file di backup e salvalo nell\'archivio locale',
    'backup__makedump_to_ftp' => 'creazione del file di backup e memorizzazione nel server ftp',
    'backup__restore_ip' => "Indirizzo IP per il ripristino",
    'backup__select_dumpfile' => "Seleziona un file di backup.",
    'backup__time' => "Ora backup",
    'backup__day' => 'Giorno di backup',
    'backup__view_dump_info' => "Visualizza le informazioni di backup per il dominio %1",
    'backup__wrong_domain_name' => "Il file di backup contiene i dati del dominio %1 e non può essere ripristinato nel dominio %2",
    'backup__incorrect_ftp_user_or_passwd' => "Utente o password FTP non corretti. Correggi le proprietà dell'account FTP",
    'backup__access_denied' => "Accesso negato. Correggi le proprietà dell'account FTP",
    'backup__restore_from' => "Ripristinare %1",
    'backup__domain_session_failed' => 'Backup del dominio %1 fallito',
    'backup__client_session_failed' => 'Il backup del cliente %1 non è stato completato',
    'backup__domain_session_restore_failed' => 'Ripristino del dominio %1 fallito',
    'backup__client_session_restore_failed' => 'L\'account cliente %1 non è stato ripristinato.',
    'backup__domain_session_complete' => 'Backup del dominio %1 completato',
    'backup__domain_session_backup' => 'Backup del dominio %1',
    'backup__client_session_backup' => 'Crea il backup del cliente %1',
    'backup__domain_stop_title' => 'Cancellazione del backup del dominio %1',
    'backup__client_stop_title' => 'Annullamento del backup dell\'account cliente %1',
    'backup__domain_restore_stop_title' => 'Annullamento del ripristino del dominio %1',
    'backup__client_restore_stop_title' => 'Annullamento del ripristino dell\'account cliente %1',
    'backup__domain_session_backup_stop' => 'Stai per annullare l\'avanzamento del backup attivo. Il file di backup non verrà creato.',
    'backup__backup_stop_confirm' => 'Sì, voglio bloccare il backup',
    'backup__restore_stop_confirm' => 'Sì, voglio arrestare la procedura di ripristino',
    'backup__domain_session_restore' => 'Ripristino del dominio %1',
    'backup__domain_session_restore_stop' => 'Stai per annullare l\'avanzamento del ripristino attivo.',
    'backup__domain_backup_file_info' => 'Informazioni del file di backup del dominio',
    'backup__domain_backup_file_list' => 'File di backup esistenti',
    'backup__domain_backup_progress' => 'Avanzamento del backup del sito web %1',
    'backup__domain_restore_progress' => 'Avanzamento del ripristino del sito web %1',
    'backup__domain_backup_progress_elapsed_time' => 'Tempo trascorso: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Tempo trascorso: %1',
    'backup__domain_restore_session_complete' => 'Il dominio %1 è stato ripristinato.',
    'backup__domain_restore_session_complete_message' => 'Il dominio %1 è stato ripristinato.',
    'backup__domain_backup_file_delete' => 'I seguenti file di backup saranno eliminati:',
    'backup__domain_backup_file_for_remove' => 'Seleziona i file di backup da rimuovere',
    'backup__backup_overwrite_file_confirm' => 'Confermare la sovrascrittura del file',
    'backup__backup_overwrite_file_confirm_text' => 'Il file di backup con il nome "%1" esiste già. Vuoi sostituirlo?',
    'backup__backup_confirm_overwrite' => 'Conferma la sostituzione del file',
    'backup__backup_overwrite_legeng' => 'Sostituisci',
    'backup__backup_not_contain_domain' => 'Il file di backup non contiene informazioni sul dominio %1',
    'backup__backup_not_contain_client' => 'Il file di backup non contiene le informazioni sull\'account cliente %1',
    'backup__backup_client_info' => "Crea il backup delle impostazioni del cliente e dei dettagli dell'account",
    'backup__client_backup_progress' => 'Avanzamento del backup dell\'account cliente %1',
    'backup__client_session_complete' => 'Backup dell\'account cliente %1 completato',
    'backup__client_backup_file_info' => 'Informazioni del file di backup del cliente',
    'backup__restore_client_info' => "Ripristina le impostazioni ed i dettagli dell'account cliente",
    'backup__client_session_restore' => 'Ripristino dell\'account cliente %1 in corso',
    'backup__client_db_server_map' => 'Mappatura dei database server',
    'backup__domain_db_server_map' => 'Mappatura dei database server',
    'backup__client_restore_session_complete_message' => 'L\'account cliente %1 è stato ripristinato.',
    'backup__client_restore_session_complete' => 'L\'account cliente %1 è stato ripristinato.',
    'backup__restore_select_some' => 'Selezionare gli oggetti da ripristinare',
    'backup__client_restore_progress' => 'Avanzamento del ripristino dell\'account cliente %1',
    'backup__new_backup' => 'Creazione di un nuovo backup',
    'backup__done' => 'Completato:',
    'backup__done_domains' => '%1 domini su %2',
    'backup__done_clients' => '%1 cliente(i) su %2',
    'backup__remaining' => 'Rimanenti:',
    'backup__remaining_domains' => '%1 dominio/i',
    'backup__remaining_clients' => '%1 cliente(i)',
    'backup__overall_backup_progress' => 'Avanzamento del backup',
    'backup__comment_n_a' => 'n/d',
    'backup__command_ignore' => 'Il comando "%1" è stato ignorato',
    'backup__no_objects' => 'Non ci sono oggetti per il backup',
    'backup__cli_warning_not_enough_ip' => 'ATTENZIONE: non ci sono indirizzi IP sufficienti per effettuare la mappatura predefinita di IP:',
    'backup__local_repository' => "Archivio di Plesk",
    'backup__ftp_repository' => 'Storage FTP',
    'backup__ftp_login' => 'Nome utente',
    'backup__ftp_password' => 'Password',
    'backup__ftp_account_settings' => 'Impostazioni dell\'account FTP',
    'backup__ftp_account_preferences' => 'Impostazioni dell\'account FTP',
    'backup__repository_not_exist' => 'Directory inesistente',
    'backup__repository_not_readable' => 'La directory specificata non è leggibile',
    'backup__ftp_repository_not_configure' => 'Per utilizzare un archivio di backup FTP, <a href="%1">indica prima l\'account FTP</a>.',
    'backup__ftp_repository_list_not_configure' => 'Le impostazioni dell\'account non sono state specificate',
    'backup__repository_list_unable_listing' => 'Non è possibile recuperare l\'elenco dei file.',
    'backup__ftp_repository_unable_listing' => 'Non è possibile recuperare l\'elenco della directory "%1":',
    'backup__repository_legend' => 'Archivio dei file di backup',
    'backup__store_in_repository' => 'Archivia i file in',
    'backup__local_repository_lable' => 'Archivio locale',
    'backup__ftp_repository_lable' => 'Storage FTP',
    'backup__ftp_repository_not_configure_hint' => '(le impostazioni dell\'account non sono state specificate)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(l\'account FTP non è specificato o non è supportato)',
    'backup__other_user_process_modified' => 'Un altro utente ha arrestato il backup o il processo di migrazione',
    'backup__another_user_exist' => 'L\'operazione in esecuzione è stata iniziata da un altro utente di Plesk. Tale utente è ancora connesso a Plesk.',
    'backup__ftp_repository_wait' => 'Attendere il ripristino delle informazioni dell\'archiviazione FTP.',
    'backup__ftp_write_test_failed' => 'Non è stato possibile scrivere i dati di test nell\'account FTP %1:',
    'backup__ftp_storage' => 'Archivio FTP(S)',
    'bt_upload_to_repository' => 'Carica i file nell\'archivio locale',
    'bt_new_restore' => "Ripristina",
    'bt_backup_schedule' => "Pianificazione del Backup",
    'backup_exist_backups' => "File di backup esistenti",
    'backup_dialog__page_title' => "Creazione del file di backup",
    'backup_dialog__please_wait' => "Sta per iniziare il processo di backup. Questa operazione potrebbe richiedere del tempo. Prego attendi...",
    'backup_conf__page_title' => 'Configurazione del backup',
    'bt_accept' => "Accetta",
    'bt_access' => "Accesso",
    'bt_action_log' => "Registro di azioni",
    'bt_add' => "Aggiungi",
    'bt_add_client' => "Assegnare agli Utenti",
    'bt_database_server_add' => 'Aggiungi server database',
    'bt_add_services' => "Aggiungi servizi",
    'bt_anonftp_stats' => "Statistiche FTP:Anon",
    'bt_anonymous_ftp' => "FTP Anonimo",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Allegato",
    'bt_autoinstaller' => 'Aggiornamento',
    'bt_auto-updates' => 'Aggiornamento',
    'bt_back' => "<< Indietro",
    'bt_backup' => "Esegui backup",
    'bt_backup_configure' => "Impostazioni di backup",
    'bt_buy_certs' => "Compera certificati",
    'bt_card' => "Card",
    'bt_cert' => "Certificato",
    'bt_certificates' => "Certificati",
    'bt_change_passwd' => "Cambiare Password",
    'bt_clear' => "Deseleziona",
    'bt_client_templates' => "Modelli di cliente",
    'bt_clients' => "Clienti",
    'bt_codepage_change' => 'Cambia Codificazione',
    'bt_comp_info' => "Gestione di Componenti",
    'bt_configure_maillists' => "Impostazioni Mailman",
    'bt_configure' => 'Configura',
    'bt_copy' => "Copia",
    'bt_copy_move' => "Copia/Sposta",
    'bt_create' => "Crea",
    'bt_create_account' => "Crea un account",
    'bt_create_dir' => "Aggiungi una directory",
    'bt_create_file' => "Aggiungi un file",
    'bt_count_size' => "Calcolo dimensione",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Pianificatore di Task",
    'bt_custom_button_new' => "Aggiungi un bottone",
    'bt_custom_buttons' => "Pulsanti personalizzati",
    'bt_customize' => "Personalizza",
    'bt_databases' => "Database",
    'bt_database_servers' => 'Server Database',
    'bt_sqlservers' => "Server Database",
    'bt_db_usr_new' => "Aggiungi un utente del database",
    'bt_db_new' => "Aggiungi un database",
    'bt_db_phpmyadmin' => "Amministrazione MySQL",
    'bt_dbuser_default' => "Rendi predefinito per DB Webadmin",
    'bt_decline' => "Rifiuta",
    'bt_default' => "Predefinito",
    'bt_defaultcomponents' => "Servizi di terze parti",
    'bt_defaults' => "Default",
    'bt_delete' => "Elimina",
    'bt_directories' => "Directory protette",
    'bt_disable' => "Disattiva",
    'bt_dns_zone_sync' => 'Applica modifiche del modello DNS',
    'bt_dnsrecord_add' => 'Aggiungere record',
    'bt_do_backup' => "Esegui backup",
    'bt_do_restore' => "Ripristina",
    'bt_do_upload' => "Carica",
    'bt_domain_aliases' => "Alias di dominio",
    'bt_domain_templates' => "Modelli di Dominio",
    'bt_domain_user' => "Amministratore del dominio",
    'bt_domain_user_passwd' => "Password dell'amministratore del dominio",
    'bt_domains' => "Domini",
    'bt_domain_alias_add' => 'Aggiungi alias di dominio',
    'bt_download' => "Scarica",
    'bt_edit' => "Modifica",
    'bt_enable' => "Attiva",
    'bt_export' => 'Esporta',
    'bt_extras' => "Extra",
    'bt_finish' => "Fine",
    'bt_ftp_account' => "Proprieta account FTP",
    'bt_forget_password' => "Password dimenticata?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "Amministrazione web FP",
    'bt_ftp_stats' => "Statistiche FTP",
    'bt_get_password' => "Recupera Password",
    'bt_global_changes' => "Modifica",
    'bt_help' => "Aiuto",
    'bt_hide_aliases' => "Nascondi gli Alias",
    'bt_hide_toolbar' => 'Nascondi barra degli strumenti',
    'bt_hide_subdomains' => "Nascondi sottodomini",
    'bt_hide_domainaliases' => "Nascondere Alias di Dominio",
    'bt_home' => "Home",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Firewall',
    'bt_install' => "Installa",
    'bt_ip_aliasing' => "Indirizzi IP",
    'bt_ip_add' => "Aggiungi indirizzo IP",
    'bt_ip_pool' => "Lista IP",
    'bt_key_info' => "Informazioni sulla licenza",
    'bt_key_buyonline_addons' => 'Ordina componenti aggiuntivi di Plesk.',
    'bt_key_buyonline_upgrades' => 'Ordina aggiornamenti Plesk.',
    'bt_key_buyonline_new' => 'Ordina una nuova chiave di licenza per il pannello di controllo',
    'bt_limits' => "Limiti",
    'bt_locale_add' => 'Aggiungi localizzazione',
    'bt_locales' => 'Impostazioni internazionali',
    'bt_log_manager' => "Manager di log",
    'bt_login' => "Accesso",
    'bt_logo' => "Personalizzazione",
    'bt_logo_send_link' => "Inserisci Link",
    'bt_logo_send_logo' => "Inserisci Logo",
    'bt_logout' => "Disconnetti",
    'bt_logrotation' => "Rotazione di registri",
    'bt_mail' => "Posta",
    'bt_mail_alias_add' => "Aggiungi alias di posta",
    'bt_mail_aliases' => "Alias di Mail",
    'bt_mail_group_add' => "Aggiungi membro",
    'bt_mail_groups' => "Gruppi",
    'bt_mail_name_add' => "Aggiungi account di posta",
    'bt_mail_preferences' => "Impostazioni",
    'bt_mail_group' => "Gruppo di mail",
    'bt_mail_mailbox' => "Casella postale",
    'bt_mail_redirect' => "Inoltro",
    'bt_mail_resp_add' => "Aggiungi risposta automatica",
    'bt_mail_resp_attach_add' => "Aggiungi Allegato",
    'bt_mail_resp_files' => "Allegati",
    'bt_mail_responders' => "Risposte automatiche",
    'bt_mail_spamfilter' => "Filtro antispam",
    'bt_mail_webmail' => "WebMail",
    'bt_maillist_new' => "Aggiungi mailing list",
    'bt_maillists' => "Liste di Posta",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Crea Backup",
    'bt_manage' => "Gestisci",
    'bt_master' => "Principale",
    'bt_migrate' => 'Esegui migrazione',
    'bt_modules_add' => 'Aggiungi estensione',
    'bt_modules_manage' => 'Gestisci estensioni',
    'bt_move' => "Sposta",
    'bt_new_client' => "Aggiungi account cliente",
    'bt_new_domain' => "Aggiungi Dominio",
    'bt_next' => "Avanti >>",
    'bt_next_page' => "Successivo",
    'bt_network_add' => "Aggiungi rete",
    'bt_notifications' => "Notifiche",
    'bt_off' => "Disattivato",
    'bt_on' => "Attivato",
    'bt_on_off' => "On/Off",
    'bt_performance' => 'Prestazioni',
    'bt_permissions' => "Permessi",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Impostazioni",
    'bt_prev_page' => "Prec",
    'bt_preview' => 'Anteprima sito',
    'bt_print' => "Stampa",
    'bt_reboot' => "Riavvio",
    'bt_reload' => "Ricarica",
    'bt_refresh' => "Aggiorna",
    'bt_register' => "Registra",
    'bt_remove' => "Rimuovi",
    'bt_enable_selected' => 'Attiva',
    'bt_disable_selected' => 'Disattiva',
    'bt_repair_ip' => "Ripara IP",
    'bt_report' => "Segnala",
    'bt_report_new' => "Aggiungi layout",
    'bt_reset' => "Reimposta",
    'bt_restart_services' => "Gestione di servizi",
    'bt_save' => "Salva",
    'bt_send_by_email' => "Inviato per e-mail",
    'bt_send_file' => "Invia file",
    'bt_send_mail' => "Invia Mail",
    'bt_send_passwd' => "Invia Password",
    'bt_send_text' => "Invia Testo",
    'bt_server' => "Server",
    'bt_server_add' => "Aggiungi Server",
    'bt_server_preferences' => "Impostazioni del server",
    'bt_servers_list' => "Server",
    'bt_sessions' => "Sessioni",
    'bt_set' => "Imposta",
    'bt_set_as_default' => "Imposta come predefinito",
    'bt_setup' => 'Configura',
    'bt_show_aliases' => "Mostra Alias",
    'bt_show_subdomains' => "Mostra sottodomini",
    'bt_show_domainaliases' => "Mostrare Alias di Dominio",
    'bt_shutdown' => "Spegni",
    'bt_site_apppkgs' => "Application vault",
    'bt_site_apppool' => "Pool di applicazioni",
    'bt_application-pool' => "Applicazioni Web",
    'bt_site_apps' => "Applicazioni Web",
    'bt_site_app_add' => "Installare Applicazione",
    'bt_site_builder' => "Supporto di Presence Builder",
    'bt_skeleton' => 'Modello di Host Virtuale',
    'bt_skins' => 'Skin',
    'bt_skin_add' => 'Aggiungi Skin',
    'bt_skin_manual' => 'Riferimento di interfacce personalizzate Plesk', // not used
    'bt_skin_download' => 'Download tema grafico',
    'bt_skin_replace' => 'Aggiorna tema grafico',
    'bt_skip' => 'Ometti',
    'bt_spamassassin' => "Filtro antispam",
    'bt_spamassassin_train' => "Auto apprendimento",
    'bt_spamfilter' => "Filtro antispam",
    'bt_start' => "Avvia",
    'bt_stop' => "Arresta",
    'bt_recycle' => "Ricicla",
    'bt_statistics' => "Statistiche",
    'bt_subdomain_new' => "Aggiungi sottodominio",
    'bt_subdomains' => "Sottodomini",
    'bt_submit' => "Invia",
    'bt_summary_report' => "Rapporto riassuntivo",
    'bt_support' => "Supporto",
    'bt_switch' => "Cambia",
    'bt_system_time' => "Ora di sistema",
    'bt_task_new' => "Aggiungi attività",
    'bt_dom_tmpl_add' => 'Aggiungi modello di dominio',
    'bt_cl_tmpl_add' => 'Aggiungi modello di cliente',
    'bt_cron_backup' => 'Impostazioni di backup pianificati',
    'bt_test' => "Test Connessione",
    'bt_text' => "Testo",
    'bt_touch' => "Cambia zona oraria",
    'bt_traffic' => "Traffico",
    'bt_traffic_history' => "Cronologia del traffico",
    'bt_update' => "Aggiorna",
    'bt_upload' => "Carica",
    'bt_upload_from_ftp' => "Caricamento FTP",
    'bt_virtualdirs' => 'Directory virtuali',
    'bt_virtualdir_new' => 'Aggiungi Directory Virtuale',
    'bt_virtualdir_add' => 'Aggiungi Directory Virtuale',
    'bt_web_app_new' => "Aggiungere Applicazione Java",
    'bt_web_stats' => "Statistiche web",
    'bt_web_stats_ssl' => "SSL/TLS stat Web",
    'bt_web_user_add' => "Aggiungi utente web",
    'bt_web_users' => "Utenti web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Vedi l'intera lista dei cambiamenti",
    'cert_add__unable_set_ca_cert' => "Impossibile configurare il certificato CA : %1",
    'cert_add__unable_set_cert' => "Impossibile configurare il certificato: %1",
    'cert_add__unable_set_private_key' => "Impossibile impostare la chiave privata (Private Key): %1",
    'certificates_list__certificate_used_as_default' => "Uno dei certificati che state per cancellare viene utilizzato come Certificato Predefinito.",
    'certificates_list__certificates_assigned_on_ip' => "Uno o più certificati sono assegnati ai domini/indirizzi IP.",
    'ch_pass__admin_pass' => "Modifica della password dell'amministratore",
    'ch_pass__old_pass' => "Vecchia password",
    'ch_pass__pass_confirm' => "Conferma",
    'ch_pass__unable_change_admin_pass' => "Impossibile cambiare la password dell'amministratore: %1",
    'check_mail_cycle__aliases' => "Ciclo email rilevato, l'indirizzo \"%1\" è contenuto negli alias di questo account di posta.",
    'check_mail_cycle__autoresponders' => "È stata individuata una mail ciclica, l'indirizzo \"%1\" è presente nelle risposte automatiche di questo account di posta.",
    'check_mail_cycle__mail_groups' => "Ciclo email rilevato, l'indirizzo \"%1\" è contenuto nel gruppo di mail di questo account di posta.",
    'check_mail_cycle__mail_name' => "Ciclo email rilevato, l'indirizzo \"%1\" coincide con questo account di posta.",
    'check_mail_cycle__redirect' => "È stata individuata una mail ciclica, l'indirizzo \"%1\" coincide con l'inoltro di questo account di posta.",
    'check_mail_dup__redirect' => "È stato rilevato un inoltro duplicato, l'indirizzo \"%1\" coincide con l'indirizzo d'inoltro di questo account di posta.",
    'check_mail_dup__mail_groups' => "È stato individuato un inoltro duplicato, l'indirizzo \"%1\" è presente nel gruppo di posta di questo account di posta.",
    'check_maillist_cycle__admin' => "È stata rilevata una mail ciclica, l'e-mail dell'amministratore \"%1\" coincide con l'indirizzo di una lista di posta.",
    'check_maillist_cycle__member' => "Rilevato riferimento circolare nella mail, l'indirizzo \"%1\" coincide con l'indirizzo della mailing list.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Dettagli account di %1",
    'cl_limits__cl' => "Limiti del cliente %1",
    'cl_logo__setup_logo_pref' => "Imposta le proprietà del logo per il cliente %1",
    'cl_new__enter_new_cl_data' => "Inserisci l'informazione sul nuovo cliente",
    'cl_new__unable_to_sent_notification' => 'È stato creato l\'account utente, nonostante, l\'invio dell\'avviso al cliente non è riuscito: %1',
    'cl_perm__all_ip' => "Tutti gli IP disponibili",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Tutti gli account di hosting Basati su IP per il cliente saranno trasferiti a Basati su nome.",
    'cl_perm__allow_client_create_domain' => "I campi che stai cercando di selezionare sono solo applicabili ai clienti che possono creare domini.",
    'cl_perm__allow_create_nb_w_ip' => "Il cliente può creare l'hosting Basato su nomi usando %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Permetti la creazione di hosting basati su IP",
    'cl_perm__available_ips' => "Indirizzi IP disponibili",
    'cl_perm__change_limits' => "Modifica limiti",
    'cl_perm__cl_disk_space' => "Spazio totale su disco disponibile",
    'cl_perm__cl_expiration' => "Periodo di validità dell'account cliente",
    'cl_perm__cl_max_box' => "Caselle postali",
    'cl_perm__cl_max_db' => "Database",
    'cl_perm__cl_max_dom' => "Domini",
    'cl_perm__cl_max_maillists' => "Liste di posta",
    'cl_perm__cl_max_subdom' => "Sottodomini",
    'cl_perm__cl_max_traffic' => "Totale traffico disponibile",
    'cl_perm__cl_max_wu' => "Utenti web",
    'cl_perm__cl_mbox_quota' => "Il limite di dimensione della mailbox per questo account utente",
    'cl_perm__current_maximum_exp_date' => "Il periodo massimo attuale per la durata del dominio è %1; richiesto %2",
    'cl_perm__current_maximum_mailbox_quota' => "Il limite attualmente definito sulla quantità di spazio su disco assegnato per ospitare le mailbox sotto questo account utente è %1; richiesto %2",
    'cl_perm__current_total_requested' => "Il limite attuale per il dominio è %1 è %2; richiesto %3",
    'cl_perm__current_total_requested_dom' => "L'attuale numero di %1 appartenente a questo cliente è %2; richiesto %3.",
    'cl_perm__disk_space' => "valore massimo spazio disco",
    'cl_perm__dashboard_stdgui' => 'Interfaccia utente',
    'cl_perm__dashboard' => 'Visualizzazione della Home page',
    'cl_perm__stdgui' => 'Visualizzazione standard',
    'cl_perm__manage_dashboard' => 'Gestione del della Home page',
    'cl_perm__dashboard_and_stdgui' => 'La visualizzazione della Home page e la visualizzazione standard sono permesse',
    'cl_perm__dashboard_only' => 'È permessa solo la visualizzazione della Home page',
    'cl_perm__stdgui_only' => 'È permessa solo la visualizzazione standard',
    'cl_perm__edit_cl' => "Permessi del cliente %1",
    'cl_perm__exp_date_exceeded' => "Il periodo di validità che stai cercando d'impostare supera il limite specificato per i domini individuali correlati a questo cliente.",
    'cl_perm__invalid_value' => "Valore errato, sono consentiti solo caratteri numerici.",
    'cl_perm__limit_disk_space' => "%1 Limite spazio su disco",
    'cl_perm__limit_expiration' => "%1 Limite del periodo di validità per l'account cliente",
    'cl_perm__limit_max_box' => "%1 Limite Numero massimo di mailbox",
    'cl_perm__limit_max_db' => "%1 Limite Numero massimo di database",
    'cl_perm__limit_max_dom' => "%1 Limite Numero massimo di domain",
    'cl_perm__limit_max_maillists' => "%1 Limite Numero massimo di mailing list",
    'cl_perm__limit_max_subdom' => "%1 Limite Numero massimo di sotodomini",
    'cl_perm__limit_max_traffic' => "%1 Limite traffico totale",
    'cl_perm__limit_max_wu' => "%1 Limite Numero massimo di utenti web",
    'cl_perm__limit_mbox_quota' => "%1 Limite massimo di quota mailbox",
    'cl_perm__limits_exceeded' => "Alcuni dei limiti che stai cercando di impostare hanno già superato i limiti definiti per i domini individuali appartenenti a questo cliente.\nIl limite totale per il cliente deve essere superiore o pari alla somma totale dei limiti di dominio definiti per questo account cliente.",
    'cl_perm__mailbox_quota_exceeded' => "Il limite della quantità di spazio su disco assegnato alle caselle postali che stai cercando d'impostare supera il limite definito per i domini individuali correlati a questo account cliente.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Il limite del totale di spazio su disco assegnato per le caselle postali che state cercando di impostare supera i limiti definiti a livello server.",
    'cl_perm__make_dumps' => "Backup e ripristino dei dati",

    'cl_perm__max_box' => "numero massimo di mailbox",
    'cl_perm__max_db' => "Numero massimo di database",
    'cl_perm__max_dom' => "domini",
    'cl_perm__max_maillists' => "Numero massimo di mailing list",
    'cl_perm__max_subdom' => "sottodomini",
    'cl_perm__max_traffic' => "valore massimo di traffica",
    'cl_perm__max_wu' => "Numero massimo di utenti web",
    'cl_perm__max_dom_aliases' => "alias di dominio",
    'cl_perm__mbox_quota' => "quota della casella postale",
    'cl_perm__not_allow_create_nb_hst' => "Il cliente non può creare hosting basato su nomi.",
    'cl_perm__this_ip_used_vrt_hst' => "Questo indirizzo IP e' utilizzato per un hosting virtuale.\nPer cancellare questo indirizzo IP, rimuovi i servizi di hosting o modifica la sua tipologia in Name-based.",
    'cl_perm__unable_off_ipb_creating' => "Il cliente ha già un servizio di hosting basato su IP configurato. Per disattivare questa caratteristica per il cliente, deseleziona la casella di controllo \"Creazione del dominio\" o rimuovi tutti gli account di hosting basati su IP.",
    'cl_perm__unable_off_nb_creating' => "Il cliente ha già un servizio di hosting basato su nomi configurato. Per disattivare questa caratteristica per il cliente, deseleziona la casella di controllo \"Creazione del dominio\" o rimuovi tutti gli account di hosting basati su nomi.",
    'cl_perm__unable_set_domain_limit' => "Impossibile limitare il numero massimo di domini: il cliente ha già domini %1",
    'cl_perm__unable_update_client_limitations' => "Impossibile modificare i limiti dell'account cliente: %1",
    'cl_pref__edit_cl' => "Preferenze del cliente %1",
    'class_anonftp__create_ftp_domain' => "Nessun dominio FTP virtuale per questo dom_id, provate a crearlo.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Il limite di spazio disco che state cercando di impostare (%1) non deve superare il limite totale di spazio definito a livello di dominio (%2)",
    'class_anonftp__invalid_input_only_digits' => "Valore non corretto , sono validi solo i caratteri numerici",
    'class_anonftp__unable_change_ownerships' => "Impossibile cambiare proprietario o permessi per Il file quota: %1",
    'class_anonftp__unable_copy_quota_file' => "Impossibile copiare il file di quota: %1",
    'class_anonftp__unable_get_disk_usage' => "Impossibile recuperare le informazioni relative all'utilizzo del spazio della directory incoming: %1",
    'class_anonftp__unable_parse_quota_file' => "Impossibile analizzare Il file quota.",
    'class_anonftp__unable_read_quota_file' => "Impossibile leggere Il file quota: %1",
    'class_anonftp__unable_update_quota' => "Impossibile aggiornare la quota: il file nella directory in arrivo utilizzano %1 KB di spazio superando il nuovo valore di quota",
    'class_anonftp__unable_write_temp_file' => "Impossibile scrivere il file temporaneo: %1",
    'class_bsdomain__warn_max_date__' => "Il periodo di validità è impostato a %1",
    'class_client__client_creation_notification' => "Avviso di creazione del cliente.",
    'class_client__client_with_contact_name_already_exists' => "Esiste già un cliente con il nome %1.",
    'class_client__disk_space' => "Spazio su disco",
    'class_client__invalid_max_dom' => "Numero domini non valido, sono consentiti solo caratteri numerici.",
    'class_client__limit_exceed' => "La quantità richiesta di %1 non può essere assegnata perché questo supererebbe le assegnazioni per l'account (%3) del cliente %2. Se vuoi assegnare più risorse, accedi a Clienti > nome del cliente > Limiti, e modifica le assegnazioni nel modo necessario. Quindi torna a questa schermata e prova a regolare nuovamente le assegnazioni.",
    'class_client__limit_exceed_unlimited' => "Se vuoi assegnare una quantità illimitata di risorse (%1), devi prima accedere a Clienti > nome del cliente > Limiti, e scegli la casella di controllo Illimitato corrispondente al tipo di risorsa occorrente. Quindi torna a questa schermata e prova a regolare nuovamente le assegnazioni.",
    'class_client__max_box' => "Caselle postali",
    'class_client__max_db' => "Database",
    'class_client__max_maillists' => "Liste di posta",
    'class_client__max_subdom' => "Sottodomini",
    'class_client__max_traffic' => "Traffico massimo",
    'class_client__max_wu' => "Utenti web",
    'class_client__max_dom_aliases' => "Alias di dominio",
    'class_client__mbox_quota' => "Quota Mailbox",
    'class_client__unable_define_cl_status' => "Impossibile definire lo stato dell'account cliente: %1",
    'class_client__unable_define_inactive_dom' => "Impossibile definire i domini inattivi %1",
    'class_client__unable_del_ip' => "Impossibile rimuovere gli indirizzi IP: %1",
    'class_db__db_name_not_set' => "Il nome del database non è definito.",
    'class_db__db_not_exist_for_curr_dom' => "Il database non esiste per questo dominio.",
    'class_db__invalid_db_or_dom_name' => "L'ID del database o il dominio non sono validi oppure il nome del database non è definito.",
    'class_db__invalid_pass' => "La password è invalida.",
    'class_db__mailgrp_member_exist' => "Il iscritto del gruppo email esiste già.",
    'class_db__access_hosts_notsupport' => 'L\'impostazione dell\'host di accesso non è supportata per questo tipo di database',
    'class_db__unable_add' => 'Impossibile aggiungere il record di accesso host: %1',
    'class_db__unable_del' => 'Impossibile eliminare il record di accesso host: %1',
    'class_db__inc_user_not_exist' => 'L\'utente "%1" del database non esiste',
    'class_db__inc_access_record_exist' => 'Questo record di accesso esiste già',
    'class_db__inc_access_record_not_exist' => 'Il record di accesso indicato non esiste',
    'class_db__inc_unable_del_last_record' => 'Impossibile eliminare l\'ultimo record dell\'host di accesso',
    'class_domtmpleditform__dns_master' => "Primario",
    'class_domtmpleditform__dns_slave' => "Secondario",
    'class_domtmpleditform__dns_type' => "Tipo DNS zone del dominio",
    'cmd_dns__a_dns_record_already_exist' => "Questo registro entrerà in conflitto con il registro A per la zona.",
    'cmd_dns__domain_last_ns' => 'Impossibile eliminare l\'ultimo registro DNS NS per il dominio.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Nome canonico del dominio non valido.",
    'cmd_dns__cname_dns_record_already_exist' => "Questo registro entrerà in conflitto con il registro CNAME per la zona.",
    'cmd_dns__cname_in_rr_combination' => 'Nella zona DNS è presente una combinazione errata di record DNS',
    'cmd_dns__cname_coexist_with_data' => 'Il record della zona DNS CNAME non può coesistere con altri record DNS nella stessa zona.',
    'cmd_dns__dns_record_type_is_invalid' => "Il tipo di record DNS non è valido.",
    'cmd_dns__ext_host_is_not_resolved' => "Il nome canonico %1 non si risolve in un record A o AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Impossibile aggiungere il record %1 alla zona %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Il nome del Mail exchanger non è valido.",
    'cmd_dns__mx_priority_is_invalid' => "Piorità MX non è valida.",
    'cmd_dns__name_server_is_invalid' => "Il Name server non è valido.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Il network mask deve essere 24, 16, 8.",
    'cmd_dns__this_dns_record_already_exists' => "Questo record DNS A esiste già.",
    'cmd_dns__unable_add_record' => "Impossibile aggiungere il record '%1': %2",
    'cmd_dns__unable_add_a_record' => "Impossibile aggiungere il record A : %1",
    'cmd_dns__unable_add_cname_record' => "Impossibile aggiungere il record CNAME : %1",
    'cmd_dns__unable_add_dns_record' => "Impossibile aggiungere il record DNS : %1",
    'cmd_dns__unable_add_ext_ns_record' => "Impossibile aggiungere record EXT_NS : %1",
    'cmd_dns__unable_add_ns_record' => "Impossibile aggiungere record NS : %1",
    'cmd_dns__unable_add_ptr_record' => "Impossibile aggiungere record PTR : %1",
    'cmd_dns__unable_add_txt_record' => "Impossibile aggiungere il record TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Impossibile creare la DNS zone %1",
    'cmd_dns__unable_define_dns_record' => "Impossibile definire il record DNS: %1",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Impossibile recuperare lo stato della DNS zone di default: %1",
    'cmd_dns__unable_insert_a_record' => "Impossibile inserire il record A : %1",
    'cmd_dns__unable_insert_mx_record' => "Impossibile inserire il record MX : %1",
    'cmd_dns__unable_insert_ns_record' => "Impossibile inserire il record NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Impostare lo status della DNS zone : %1",
    'cmd_domains__dom_already_exists' => "Il dominio %1 esiste già .",
    'cmd_domains__dns_record_already_exists' => "Impossibile creare il dominio %1 perché esiste già un record DNS che punta all'host %1.",
    'cmd_domains__dom_already_exists1' => "Ci sono %2 subdomini in questo dominio. Il dominio %1 esiste già.",
    'cmd_domains__dom_already_exists2' => "il sottodominio %1 esiste già.",
    'cmd_domains__dalias_already_exists' => "Questo alias esiste già.",
    'cmd_domains__domain_alias_already_exists' => 'Esiste già un alias di dominio con questo nome.',
    'cmd_domains__unable_del_mail_for_dom' => "Impossibile cancellare il service di mail per il domini: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Impossibile cancellare l'account FTP anonimo per il dominio: %1",
    'cmd_domains__unable_update_dom_param' => "Impossibile aggiornare i parametri del dominio: %1.",
    'cmd_domains__unable_rename_client_exist' => "il nome utente dell'amministratore del dominio è già in uso.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "L'hosting non è di tipo fisico.",
    'cmd_hosting__unable_create_user' => "Impossibile creare l'utente %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Impossibile definire l'indirizzo IP per i virtual host Name-Based: %1",
    'cmd_hosting__unable_del_old_hst' => "Impossibile cancellare il vecchio configura dell'hosting: %1",
    'cmd_hosting__unable_del_protected_directory' => "Impossibile cancellare la directory protetta: %1",
    'cmd_hosting__unable_del_web_user' => "Impossibile cancellare l'utente web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Impossibile creare o aggiornare il Virtual Host: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Impossibile configurare l'hosting d'inoltro in frame.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Impossibile ricostruire il file di configurazione proftpd : %1",
    'cmd_hosting__unable_set_up_ssl' => "Impossibile configurare SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Impossibile rimuovere la protezione dalla directory SSL/TLS : %1",
    'cmd_hosting__unable_update_dest_url' => "Impossibile aggiornare l'URL di destinazione %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Impossibile aggiornare la DNS zone per il dominio: l'esecuzione dell'utility non è andata a buon fine.",
    'cmd_hosting__unable_update_ftp_passwd' => "Impossibile aggiornare la password FTP %1.",
    'cmd_hosting__unable_update_user' => "Impossibile aggiornare l'utente %2: %1",
    'cmd_hosting__unknown_hst_type' => "Tipo hosting non definito.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Diritti insufficienti per terminare i servizi di hosting.",
    'cmd_mail__autoresponder__not_configured' => "La risposta automatica per questo account di posta non è stata configurata",
    'cmd_mail__addr_already_used_in_mail_redirect' => "L'indirizzo %1 è già in uso dall'inoltro di posta.",
    'cmd_mail__alias_already_exists' => "l'alias esiste già .",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "L'ID della risposta automatica e l'ID dell'account di posta non coincidono.",
    'cmd_mail__autoresp_id_is_undefined' => "L'ID della risposta automatica non è definito.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "L'alias di posta con questo nome esiste già per l'account di posta %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "L'account di posta %1 è già iscritto ad una mailing list.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "L'account di posta %1 esiste già in questo dominio.",
    'cmd_mail__mail_name_not_exist' => "L'account di posta non esiste.",
    'cmd_mail__mail_name_passwd_part' => "La password non deve contenere il nome dell'account di posta come sua parte.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "La Mailing list %1 esiste già in questo dominio.",
    'cmd_mail__mailname_already_exist_in_mg' => "L'account di posta %1 è già in un gruppo di posta.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "L'account di posta %1 esiste già in questo dominio.",
    'cmd_mail__mailname_already_exists' => "L'account di posta esiste già.",
    'cmd_mail__mailname_is_invalid' => "L'account di posta %1 non è valido.",
    'cmd_mail__mailname_unable_update' => "Impossibile aggiornare le proprietà dell'account di posta:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Il numero massimo di risposte automatiche è stato raggiunto per questo dominio.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Il numero massimo di gruppi di posta è stato raggiunto per questo dominio.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Il numero massimo d'inoltri è stato raggiunto per questo dominio.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "È stato raggiunto il numero massimo di caselle postali.",
    'cmd_mail__no_members_specified' => "nessun iscritto specificato.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Password troppo semplice, selezionarne un'altra.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Questo indirizzo e-mail è già in uso.",
    'cmd_mail__unable_define_autoresp_id' => "Impossibile definire l'ID della risposta automatica %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Impossibile cambiare le impostazioni del servizio di posta per il dominio %1.",
    'cmd_mail__unable_del_mail_for_dom' => "Impossibile rimuovere il servizio di posta dal dominio %1.",
    'cmd_mail__unable_del_mail_redirection' => "Impossibile rimuovere il servizio d'inoltro di posta %1.",
    'cmd_mail__unable_remove_autoresp' => "Impossibile rimuovere le risposte automatiche: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Impossibile eliminare i membri del gruppo di posta: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Impossibile disattivare il gruppo di mail: %1",
    'cmd_mail__unable_update_mail_redirect' => "Impossibile configurare nuovamente il servizio d'inoltro di posta %1.",
    'cmd_mail__uploaded_file_is_too_big' => "La dimensione del file caricato è eccessiva.",
    'cmd_mail__additionally' => "In aggiunta:",
    'cmd_pd__invalid_login' => "Nome utente errato.",
    'cmd_pd__this_user_already_exist' => "Questo utente esiste già .",
    'cmd_pd__unable_define_hst_type' => "Impossibile definire tipologia di hosting.",
    'cmd_pd__unable_upd_pd_usr' => "Impossibile aggiornare le proprietà dell'utente della directory protetta: %1.",
    'cmd_pd__user_is_undefined' => "utente non definito.",
    'cmd_server__no_enough_free_disk_space' => "Spazio disco insufficiente.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "la vecchia password non è corretta. Riprovare.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "E' stato raggiunto il numero massimo di utenti web per questo dominio.",
    'cmd_web_usr__unable_create_user' => "Impossibile creare l'utente di sistema: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Impossibile definire il numero massimo di utenti web: %1",
    'cmd_web_usr__user_already_exists' => "L'utente esiste già .",
    'cmd_web_usr__web_user_name_is_invalid' => "Il nome dell'utente web %1 non è valido.",
    'cmd_web_usr__web_user_not_exist' => "L'utente web non esiste.",
    'common_func__exec_bad_argument' => "l'argomento dell'eseguibile non deve contenere il simbolo di apostrofo.",
    '__eol' => 'Interruzioni di linea',
    'eol__binary_file' => 'Impossibile cambiare lo stile di interruzione di linea in un file binario.',
    'cp_access_admin_deny' => "L'accesso amministrativo dall'indirizzo '%1' è limitato come previsto dalla policy relativa alle restrizioni di accesso IP applicata.",
    'create_domain_warn__' => "Le seguenti eccezioni si sono verificate durante la creazione del dominio:",
    'create_domain__client_select' => 'Seleziona il cliente per cui creare il dominio',

    'dashboard__nav_button_name' => "Home",
    'dalias__list_title' => 'Alias del dominio per il dominio %1',
    'dalias__list_legend' => 'Alias di dominio',
    'dalias__list_header' => 'Alias di dominio',
    'dalias__list_status' => 'A',
    'dalias__list_name' => 'Nome dell\'alias di dominio',
    'dalias__list_ascii_name' => 'In formato ASCII',
    'dalias__remove_title' => 'I seguenti alias del dominio per il dominio %1 saranno eliminati:',
    'dalias__select_domain_aliases_to_remove' => 'Seleziona gli alias di dominio da eliminare.',
    'dalias__mail_turn_on_failed' => 'Impossibile avviare il servizio mail: %1',
    'dalias__web_turn_on_failed' => 'Impossibile attivare il servizio web: %1',
    'db_usr_edit__db_usr_name_old' => "Antico nome utente del database",
    'database_server_edit_form__cannot_infer_type' => 'Impossibile dedurre il metodo di connessione dai dati forniti. Specificare "127.0.0.1" come nome host del server del database per connettersi tramite TCP/IP con la porta fornita, oppure lasciare il campo della porta vuoto per usare il socket unix "%1".',
    'database_server_edit_form__duplicate' => 'Un server database con questa combinazione di indirizzo host e numero porta è già registrato.',
    'database_server_edit_form__host_is_invalid' => 'Il nome host specificato non è valido.',
    'database_server_edit_form__port_is_invalid' => 'Il numero di porta specificato non è valido.',
    'database_server_error__consult_admin' => 'Prego contatta l\'amministratore del server.',
    'database_server_error__last__connection_failed' => 'L\'ultimo tentativo di controllare questo server database è fallito a causa di problemi di rete.',
    'database_server_error__last__permission_denied' => 'L\'ultimo tentativo di controllare questo server database è fallito perché l\'account fornito non possiede privilegi amministrativi.',
    'database_server_error__last__credentials_not_set' => "L'ultimo tentativo di connettere a questo server non è riuscito perché il nome utente e la password dell'amministratore specificati non sono validi.",
    'database_server_error__last__other_error' => 'L\'ultimo tentativo di controllare questo server database è fallito.',
    'database_server_error__real__connection_failed' => 'La connessione al server database è fallita a causa di problemi di rete.',
    'database_server_error__real__permission_denied' => 'La connessione al server database è fallita perché l\'account fornito non possiede privilegi amministrativi.',
    'database_server_error__real__duplicate_object' => 'La connessione al server database è fallita a causa di un conflitto di nome:',
    'database_server_error__real__unacceptable_name' => 'La connessione al server database è fallita a causa di un nome oggetto non valido:',
    'database_server_error__real__unacceptable_password' => 'La connessione al server database è fallita a causa di una password inaccettabile:',
    'database_server_error__real__credentials_not_set' => "Plesk non può connettere al server database perché non sono stati specificati un nome utente e una password amministratore validi.",
    'database_server_error__real__other_error' => 'Connessione al server database non riuscita:',
    'database_server_error__test__connection_failed' => 'La connessione di verifica al server database non è riuscita a causa di problemi di rete:',
    'database_server_error__test__permission_denied' => 'La connessione di verifica al server database non è riuscita perché l\'account fornito non possiede privilegi amministrativi.',
    'database_server_error__test__duplicate_object' => 'La connessione di verifica al server database non è riuscita a causa di un conflitto di nome:',
    'database_server_error__test__unacceptable_name' => 'La connessione di verifica al server database non è riuscita a causa di un nome oggetto non valido:',
    'database_server_error__test__unacceptable_password' => 'La connessione di test al server database non è riuscita a causa di una password inaccettabile:',
    'database_server_error__test__credentials_not_set' => "La connessione di verifica a questo server non è riuscita perché non sono stati specificati un nome utente e una password amministratore validi.",
    'database_server_error__test__other_error' => 'La connessione di verifica al server database non è riuscita:',

    'db__create_new_db' => "Aggiungi un database",
    'db__db_add' => "Aggiungi database",
    'db__db_for_dom' => "Database del sito web %1",
    'db__db_id_undefined' => "L'ID del database non è definito.",
    'db__db_name' => "Nome del database",
    'db__db_not_exist' => "Il Database non esiste.",
    'db__db_type' => "Tipo",
    'db__db_server' => "Server database",
    'db_server_not_exist' => "Il database server non esiste",
    'db__db_user_not_exist' => "L'utente del database non esiste.",
    'db__domain_not_exist' => "Il Dominio non esiste.",
    'db__enter_db_name' => "Immettere il nome del database.",
    'db__invalid_db_id' => "L'identificatore del database non è valido.",
    'db__invalid_db_name' => "Il nome del database non è valido. Il nome del database deve contenere solo simboli dell'alfabeto latino, numeri, sottolineature o trattini. Non può essere più lungo di 63 caratteri.",
    'db__max_db_reached_for_dom' => "E' stato raggiunto il limite dei database per questo dominio.",
    'db__max_mssql_db_reached_for_dom' => "È stato raggiunto il limite sul numero di database Microsoft SQL Server per questo dominio",
    'db__postgres_not_connect_for_admin' => "Impossibile connettersi a PostgreSQL. Attivare il supporto a PostgreSQL nella pagina di amministrazione del server.",
    'db__postgres_not_connect_for_client' => "Impossibile connettersi a PostgreSQL. Rivolgersi all'amministratore di sistema per informazioni.",
    'db__remove_db_on_domain' => "I seguenti database nel sito web %2 appartenente al cliente %1 verranno rimossi:",
    'db__remove_db_on_domain_of_cl' => "I seguenti database per il dominio %2 appartenente al cliente %1 verranno rimossi:",
    'db__remove_db_linked_resource' => 'Questo database è utilizzato da un\'applicazione del web. Può essere rimosso solo dopo aver disinstallato l\'applicazione web.',
    'db__remove_db_users' => "I seguenti utenti del database %3 nel sito web %2 appartenenti al cliente %1 verranno rimossi:",
    'db__remove_db_users_of_cl' => "I seguenti utenti del database %3 nel sito web %2 appartenenti al cliente %1 verranno rimossi:",
    'db__select_db_for_remove' => "Seleziona il database da rimuovere.",
    'db__select_db_users_for_remove' => "Selezionate gli utenti del database da rimuovere.",
    'db__unable_create_db_user' => "Impossibile creare l'utente del database: %1",
    'db__unable_define_db_name' => "Impossibile definire il nome del database: %1",
    'db__unable_define_db_user' => "Impossibile definire l'utente del database: %1",
    'db__unable_define_db_users' => "Impossibile definire gli utenti del database: %1",
    'db__unable_select_dom_name' => "Impossibile selezionare il dominio: %1",
    'db_edit__db_for_dom' => "Utenti del database %1 nel dominio %2",
    'db_edit__invalid_db_name' => "Il nome del database non è valido.",
    'db_edit__no_users' => "Non ci sono utenti con le credenziali per questo database.",
    'db_edit__unable_define_db_usrs' => "Impossibile definire l'utente del databases: %1",
    'db_edit__unable_select_db_usr' => "Impossibile selezionare l'utente del database.",
    'db_edit__db_user_password_for_' => "Prego inserisci la password per collegarti come utente del database %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Aggiungere utente del database",
    'db_usr_edit__db_usr_name' => "Nome dell'utente del Database",
    'db_usr_edit__edit_db_usr' => "Modifica dell'utente del database",
    'db_usr_edit__for_db' => "nel database %1",
    'db_usr_edit__not_create_pass' => "Questa operazione creerà un account utente per il database privo di password. Volete creare l'utente senza una password?",
    'dbuser__only_one_user_can_be_default' => "Solo un utente può essere reso predefinito.",
    'db_server__cannot_delete_default' => "Il server database predefinito non può essere eliminato.",
    'db_server__cannot_delete_local' => "Il server database locale non può essere eliminato.",
    'db_server__cannot_delete_used' => 'Un server database non può essere eliminato se ci sono database o utenti di database ospitati su di esso.',
    'demo__disabled_in_demo' => "Operazione non supportata nella versione demo.",
    'defaultcomponents__title' => "Selezione servizi di terze parti",
    'defaultcomponents__select_default' => "Selezione il componente di default %1", //to check
    'defaultcomponents__not_installed' => "(non installato)",
    'defaultcomponents__not_configured' => "(non configurato)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Alcune categorie di servizi contengono selezioni non valide o non sono state effettuate selezioni.",
    'defaultcomponents__depends_on' => "(richiede %1)",
    'defaultcomponents__parameters' => "Parametri di %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "Server SQL",
    'component_name__sqladmin' => "Amministratore web MySQL",
    'component_name__sqladminmysql' => "Amministratore web MySQL",
    'component_name__dnsserver' => "Server DNS",
    'component_name__firewall' => "Firewall",
    'component_name__ftpserver' => "Server FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Server di posta",
    'component_name__local_mailserver' => "Server di posta locale",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Scripting web",
    'component_name__spamfilter' => "Filtro antispam",
    'component_name__stats' => "Statistiche Web",
    'component_name__stunnel' => "Wrapper SSL/TLS",
    'component_name__webmail' => "WebMail",
    'component_name__webpublish' => "Pubblicazione web",
    'component_name__webserver' => "Server web",
    'dns__dns_record_invalid_values' => 'I valori di record DNS specificati non sono corretti: %1: %2',
    'dns__dns_record_not_found' => 'Record DNS non trovato',
    'dns__dns_zone_invalid_values' => 'I parametri della zona DNS specificati sono errati.',

    'dns__soa_mname_title' => 'Server di nomi primario',
    'dns__soa_mname_legend' => 'Server di nomi',
    'dns__soa_mname_autoselect' => '(Selezione automatica)',

    'dns__dns_zone_off_remove_title' => "I seguenti record della risorsa saranno rimossi dalla zona %1:",
    'dns__dns_zone_master_remove_title' => "Rimozione dei registri di risorse dalla zona DNS %1 in corso",
    'dns__dns_zone_slave_remove_title' => "I seguenti record per il server di nomi primario di %1 saranno eliminati:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Inserisci record SPF',
    'dns_add__is_spf_syntax' => 'Record SPF',
    'dns_add__spf_value_is_invalid' => "Il valore per il record SPF non è corretto, deve iniziare con 'v=spf'",
    'dns__dns_zone_status' => "Stato del DNS zone .",
    'dns__invalid_ip_address' => "L'indirizzo IP del nuovo server DNS primario non è valido oppure è vuoto.",
    'dns__ip_address' => "Indirizzo IP",
    'dns__master_dns_type' => "è un server DNS primario",
    'dns__masters' => "server DNS primari",
    'dns__soa_minimum_too_large' => 'Si sconsiglia di eseguire il caching di risposte negative per più di tre ore.',
    'dns__select_masters_to_remove' => "Selezionare i server DNS primari da eliminare.",
    'dns__select_template_record_to_remove' => 'Selezionare i record dei modelli DNS da eliminare.',
    'dns__nameservers_for_domain' => "Nameserver per il dominio",
    'dns__remove_dns_zone_of_domain__' => "Rimozione record DNS per il dominio %1",
    'dns__remove_dns_zone_template__' => "I seguenti record DNS saranno eliminati dal modello:",
    'dns__remove_this_dns_record?' => "Siete sicuri di voler rimuovere questo record DNS?",
    'dns__restore_default' => "Ripristinando la DNS zone dal template",
    'dns__restore_default_confirm' => "Il ripristino della zona DNS escluderà la configurazione della zona DNS attuale. Continuare comunque?",
    'dns__restore_default_error' => "Errore durante il ripristino del DNS zone:",
    'dns__slave_dns_type' => "è un server DNS secondario",
    'dns__subdomain_dns_rec_removed' => "È stato rimosso il registro A dalla zona del sottodominio %1.",
    'dns__zone_switched_off_no_ns' => "La zona è stata disattivata perché non c'è un record NS %1, obbligatorio nella zona. Per aggiungere il record NS alla zona, fai clic sul pulsante Aggiungi Record.",
    'dns__cant_switch_on_no_ns' => "La zona non può essere attivata perché non c'è un record NS %1, obbligatorio nella zona. Per aggiungere il record NS alla zona, fai clic sul pulsante Aggiungi Record.",
    'dns__unable_activate/deactivate_dns' => "Impossibile abilitare/disabilitare il DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Impossibile aggiungere il server DNS primario: voce duplicata.",
    'dns__unable_add_dns_master_local_ip' => "Impossibile aggiungere l'indirizzo IP del server DNS primario: questo record deve essere creato su un server remoto.",
    'dns__unable_define_dns_record' => "Impossibile definire il record DNS : %1",
    'dns__unable_get_dns_template_status' => "Impossibile recupera lo stato del DNS template .",
    'dns__unable_remove_dns_rec' => "Impossibile rimuovere il record DNS : %1",
    'dns__warnings__' => "I risultati della modifica della DNS zone :",
    'dns__you_not_have_perm_manage_dns' => "Permessi insufficienti per la gestione DNS Zone di questo dominio",
    'dns__cant_create_record_with_server_ip' => "Impossibile aggiungere questo indirizzo IP perché coincide con l'indirizzo IP di questo server gestito da Plesk.",

    'dns__tabs_acl' => "Trasferimenti di zona",
    'dns__acl_add_network_legend' => "Aggiungi rete",
    'dns__acl_add_ip_legend' => "Aggiungi indirizzo IP",
    'dns__acl_network_not_allowed' => "Questo indirizzo di rete non è consentito dal DNS in Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP indirizzo/maschera",
    'dns__acl_enter_ip_address' => "Indirizzo IP",
    'dns__acl_list_network_legend' => "Network che possono ottenere una copia della zona DNS",
    'dns__acl_list_ip_legend' => "Indirizzi IP che possono ottenere una copia della zona DNS",
    'bt_dns_acl_add_network' => "Aggiungi rete",
    'bt_dns_acl_add_ip' => "Aggiungi indirizzo IP",

    'dns_add__add_rec_for_zone' => "Aggiungi %1 per la zona %2",
    'dns_add__canonical_dom_name_is_invalid' => "Nome canonico del dominio non valido.",
    'dns_add__enter_canonical_name' => "Nome canonico",
    'dns_add__enter_dom_name' => "Nome del dominio",
    'dns_add__enter_ip_address' => "Indirizzo IP",
    'dns_add__enter_ip_mask' => "Indirizzo IP e maschera di rete",
    'dns_add__enter_mail_domain' => "Dominio di posta",
    'dns_add__enter_mail_exchanger' => "Server exchange di posta",
    'dns_add__enter_nameserver' => "Server di nomi",
    'dns_add__enter_txt_record' => "Registro TXT",
    'dns_add__enter_service_name' => "Nome di servizio",
    'dns_add__hint_service_name' => "Esempio: SIP (senza sottolineatura)",
    'dns_add__enter_protocol' => "Protocollo",
    'dns_add__hint_protocol_name' => "Esempio: TCP (senza sottolineatura)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priorità",
    'dns_add__specify_weight_of_service' => "Peso relativo per i record con la stessa priorità",
    'dns_add__enter_target_host' => "Host obiettivo",
    'dns_add__hint_target_host' => "Esempio: esempio.com",
    'dns_add__enter_target_port' => "Porta obiettivo",
    'dns_add__caa_tag' => "Etichetta",
    'dns_add__caa_value' => "Valore",
    'dns_add-invalid-A_ip' => "Indirizzo IP non è valido.",
    'dns_add-invalid-AAAA_ip' => "Indirizzo IP non è valido.",
    'dns_add-invalid-PTR_ip_mask' => "Accoppiamento indirizzo IP/maschera di rete non valido.",
    'dns_add-invalid-SRV_service_name' => "Nome del servizio non valido",
    'dns_add-invalid-SRV_protocol_name' => "Protocollo non valido",
    'dns_add-invalid-SRV_target_port' => "Porta obiettivo non valida",

    'dns_add__invalid_ip' => "Indirizzo IP non è valido.",
    'dns_add__low' => "basso",
    'dns_add__mail_dom_name_is_invalid' => "Il nome dominio Mail non è valido.",
    'dns_add__nameserver_is_invalid' => "Il Name server non è valido.",
    'dns_add__record' => "Registro %1",
    'dns_add__select_prefer_for_mail_exchange_server' => "Specificare la priorità del server mail exchange",
    'dns_add__unable_insert_new_dns_rec' => "Impossibile inserire un nuovo DNS record: %1",
    'dns_add__very_high' => "molto alto",
    'dom_ctrl__allowed' => "permesso",
    'dom_ctrl__db' => "Database di MariaDB/MySQL",
    'dom_ctrl__mssql_db' => "Database MS SQL",
    'dom_ctrl__disk_space' => "Spazio su disco",
    'dom_ctrl__dom_adm' => "Dominio %1 di %2",
    'dom_ctrl__dom_cl' => "Dominio %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Il dominio presenta la configurazione d'inoltro con l'URL d'inoltro non definito",
    'dom_ctrl__domain_has_frame_forwarding' => "Il dominio presenta l'inoltro in frame verso l'URL %1",
    'dom_ctrl__domain_has_no_hosting' => "L'hosting per il dominio non è configurato",
    'dom_ctrl__domain_has_physical_hosting' => "L'hosting web è configurato per questo dominio sull'indirizzo IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Il Dominio presenta l'inoltro standard verso l'URL %1",
    'dom_ctrl__maillists' => "Liste di posta",
    'dom_ctrl__mboxes' => "Caselle postali",
    'dom_ctrl__mg' => "Inoltri di posta",
    'dom_ctrl__resource_name' => "Risorse",
    'dom_ctrl__resp' => "Risposte automatiche",
    'dom_ctrl__subdom' => "Sottodomini",
    'dom_ctrl__dom_aliases' => "Alias di dominio",
    'dom_ctrl__traffic' => "Traffico",
    'dom_ctrl__unable_activate/deactivate_dom' => "Impossibile abilitare/disabilitare il dominio: %1",
    'dom_ctrl__used' => "Usato",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Utenti web",
    'dom_pref__bounce_with_phrase' => "Rimbalzo con messaggio",
    'dom_pref__bounce' => "Respingere",
    'dom_pref__catch_addr' => "Inoltra a indirizzo",
    'dom_pref__reject' => 'Rifiuta',
    'dom_pref__confirm_domain_removing' => "Non dimenticare di informare gli utenti del dominio della variazione del nome. Sei sicuro di voler rinominare il dominio?",
    'dom_pref__db_inconsystency' => "inconsistenza de database.",
    'dom_pref__dbs' => "database",
    'dom_pref__delete_traffic_stat' => "Conservare le statistiche web e del traffico",
    'dom_pref__delete_traffic_stat_older' => "Conservare le statistiche web e del traffico",
    'dom_pref__dom_level_name_conflict' => "Il nome utente dell'amministratore del dominio è in conflitto con un nome utente o con uno dei clienti.",
    'dom_pref__invalid_disk_space_limit' => "Limite dello spazio disco non valido. Valore massimo: %1",
    'dom_pref__invalid_expiration_date_limit' => "Periodo di validità non valido.",
    'dom_pref__invalid_max_traffic_limit' => "Limite del traffico non valido: Valore massimo: %1",
    'dom_pref__limits_of_dom' => "Limiti per il Dominio %1",
    'dom_pref__mail_grps' => "gruppi di posta",
    'dom_pref__mail_nonexistent_user' => "Cosa fare con la posta inviata ad utenti inesistenti",
    'dom_pref__mail_redirs' => "Inoltri di posta",
    'dom_pref__mail_resps' => "Risposte automatiche di posta",
    'dom_pref__max_limit_is_invalid' => "%1 non è valido.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Numero massimo di %1 non è valido.",
    'dom_pref__new_limit_less_currently_used' => "%1: richiesti - %2, in uso - %3",
    'dom_pref__older_that' => "per",
    'dom_pref__postboxes' => "caselle postali",
    'dom_pref__preferences_of_dom' => "Impostazioni per il dominio %1",
    'dom_pref__redirect_to_itself' => "Il dominio avrà l'inoltro impostato verso sé stesso",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Avete specificato il periodo di conservazione delle statistiche del traffico inferiore di quello del valore totale definito per il server (%1 mese/i). Il periodo è stato impostato pari al valore di default per il server (%1 mese/i).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Impossibile aggiungere il prefisso www al dominio: %1",
    'dom_pref__unable_define_physical_hst_param' => "Impossibile definire i parametri di hosting fisico: %1",
    'dom_pref__unable_rename_domain' => "Impossibile rinominare il dominio %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Impossibile impostare la quota mailbox per questo dominio: %1",
    'dom_pref__unable_set_up_web_user_script' => "Impossibile impostare gli script per l'utente web: %1",
    'dom_pref__unlimited' => "Illimitato",
    'dom_pref__web_usrs' => "utenti web",
    'dom_pref__you_already_have_%object' => "Hai già %1",
    'cu_domain__error_unable_update_ftp_users' => 'Impossibile aggiornare gli utenti FTP del dominio: %1',
    'dom_cli__warning_ignore_quota' => 'ATTENZIONE: L\'opzione "hard_quota" è stata ignorata: la quota disco fisso non è supportata',
    'dom_user_client_login_exist' => "Impossibile consentire l'accesso dell'amministratore del dominio a Plesk nel dominio %1: questo nome utente è già in uso.",
    'domain__unable_to_turn_on_service' => "Impossibile attivare il servizio %1.",
    'domains__change_the_status_of_domain?' => "Siete sicuri di voler modificare lo stato del dominio %1?",
    'domains__unable_to_change_client_status' => "Impossibile cambiare lo stato dell'account cliente: %1",
    'domains__unable_update_apache_settings' => "Impossibile aggiornare le impostazioni di Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Diritti insufficienti per cancellare domini.",
    'domains_list__unable_remove_doms' => "Impossibile rimuovere i domini: %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Seleziona gli alias di dominio da eliminare.',
    'domain_aliases_remove__title' => 'Elimina alias di dominio',
    'domain_aliases__max_aliases_reached_for_dom' => "È stato raggiunto il limite sul numero di alias per questo dominio.",
    'domain_edit__edit_title' => 'Modifica alias di dominio',
    'domain_alias_edit__type' => 'Tipo alias di dominio',
    'domain_aliases__list_header' => 'Alias di dominio',
    'domain_aliases__name' => 'Nome',
    'domain_aliases__type' => 'Tipo',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Alias di dominio',
    'domain_aliases__legend' => 'Alias di dominio',
    'domain_alias__domain_exists' => 'Esiste già un dominio con questo nome.',
    'domain_alias__subdomain_exists' => 'Esiste già un sottodominio con questo nome.',
    'domain_alias__dns_record_exists' => 'Esiste già un record DNS con il nome specificato dell\'alias di dominio.',
    'domain_alias__domain_alias_exists' => "Esiste già un alias di dominio con questo nome.",
    'domain_alias__invalid_type_full' => 'Il server di posta elettronica non supporta gli alias di dominio',
    'domain_alias__redirect_exists' => 'È stato rilevato il reindirizzamento verso sé stesso.',

    'ds__anonymous_ftp' => "FTP Anonimo",
    'drweb__pagetitle' => 'Impostazioni dell\'antivirus',
    'drweb__drweb' => 'Controllo antivirus per email',
    'drweb__drweb_direction' => 'Verifica la presenta di virus nella posta',
    'drweb__drweb_direction_off' => 'Non controllare se ci sono virus',
    'drweb__drweb_direction_any' => 'Email in ingresso e in uscita',
    'drweb__drweb_direction_from' => 'Email in uscita',
    'drweb__drweb_direction_to' => 'Email in ingresso',
    'drweb__disable_reason_key' => 'Dr.Web non è previsto dalla chiave di licenza.',
    'drweb__disable_reason_perm' => 'Permessi insufficienti per gestire Dr.Web.',
    'drweb__disable_reason_install' => 'Dr.Web antivirus non è installato.',
    'drweb__filters' => 'Filtri antivirus',
    'ds__dns' => "Zona DNS",
    'ds__mail' => "Posta",
    'dumps_list__deletion_page_title' => "I seguenti file di backup per il dominio %1 saranno rimossi:",
    'dumps_list__dumpfile_is_invalid' => "Il file %1 non è un file di backup di dominio valido.",
    'dumps_list__page_title' => "Archivio dei file di backup",
    'dumps_upload__page_title' => "Caricamento di file di backup nell'archivio",
    'dumps_list__repository_is_not_exist' => "L'archivio di file di backup è inesistente.",
    'dumps_list__unable_to_remove' => "Impossibile rimuovere il file di backup: %1",
    'dumps_list__dumpfile_can_conflict' => "Il nome di file specificato è in conflitto con il file %1. Prego, specifica un altro nome.",
    'dusr_ed__allow_dl_usr_access' => "Consentire l'accesso dell'amministratore del dominio",
    'dusr_ed__information' => "Proprietà dell'Amministratore del Dominio %1",
    'dusr_ed__locale' => "Lingua per l'amministratore del dominio.",
    'dusr_ed__skin' => "Tema dell'interfaccia dell'amministratore del dominio",
    'dusr_ed__personal_information' => 'Informazioni personali',
    'ess__error' => "Errore",
    'example__' => "Esempio: %1",
    'extras__allow_certificate_purchasing' => "Permetti acquisto certificati",
    'extras__allow_domain_registration' => "Permetti registrazione dominio",
    'extras__allow_extras' => "Permetti servizi extra",
    'extras__buy_new_key' => "La corrente licenza non consente la modifica di questi oggetti.",
    'extras__setup_services' => "Configura servizi aggiuntivi",

    'ruleeditform__error' => 'Impossibile aggiornare la regola del firewall.',
    'ruleeditform__name_is_required' => 'Indica il nome della regola',
    'ruleeditform__profiles_is_required' => 'Selezionare almeno un profilo.',
    'ruleeditform__invalid_ip' => 'Il network o l\'indirizzo IP specificato non è valido.',
    'ruleeditform__invalid_port' => 'La porta specificata non è valida. I valori possibili sono 1000 o 1000-1051',

    'get_password__encrypted_password' => "Impossibile inviare l'informazione sulla password: la password è memorizzata in modo crittografato.",
    'get_password__mail_error' => "Si è verificato un errore durante il tentativo d'invio della password all'indirizzo e-mail %1: %2",
    'get_password__mail_ok' => "La password è stata inviata all'indirizzo e-mail: %1",
    'get_password__message' => "Il tuo nome utente per accedere al sistema: %1\nLa tua password è %2",
    'get_password__subject' => "Password di accesso al sistema",
    'groups__available' => "mail group disponibili",
    'groups__groups_for_mailname' => "Gruppi di mail ai quali l'account di posta %1 è sottoscritto",
    'groups__member_of' => "Iscritto ai seguenti mail group",
    'help__help_area' => "Assistenza.",
    'hst_def__auth_disabled' => "proibito",
    'hst_def__auth_enabled' => "consentito",
    'hst_def__change_curr_dns_ip' => "L'indirizzo IP nel record A DNS sarà modificato",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Nessuno degli indirizzi del record A DNS coincide con l'account di hosting che si sta creando",
    'hst_def__dest_url' => "URL di destinazione",
    'hst_def__disk_quota' => "Quota disco",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Il limite di spazio che state impostando è superato dal limite di spazio della directory incoming FTP Anonimo. Il limite di spazio della directory incoming del FTP Anonimo non deve superare i limiti di spazio disco del dominio.",
    'hst_def__frame_forwarding_definition' => "Assegnazione dell'inoltro in frame per il dominio %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Attenzione: L'utente FTP %1 è usato nelle impostazioni dell'account di hosting ma non è presente nel sistema.",
    'hst_def__hst_type_is_not_defined' => "Tipologia di hosting non definita",
    'hst_def__ip_based' => "IP-based",
    'hst_def__name_based_power_anonymous_ftp_down' => "Il trasferimento di questo account di hosting a un indirizzo IP condiviso renderà il servizio FTP anonimo non disponibile per questo dominio. Procedere comunque?",
    'hst_def__password_is_invalid_password_syntax' => "Password non valida. Non utilizzate apostrofi, virgolette e caratteri nazionali nella password. La password deve essere lunga da 5 a 14 caratteri e non deve coincidere con la login.",
    'hst_def__shell' => "L'accesso SSH alla shell del server sotto l'utente di sistema dell'abbonamento",
    'hst_def__shell_windows' => "Accesso del Desktop Remoto al server come utente di sistema dell'abbonamento",
    'hst_def__standard_forwarding_definition' => "Assegnazione dell'inoltro standard per il dominio %1",
    'hst_def__title_name_based' => "Name-based",
    'hst_def__unable_create/update_physic_hst' => "Impossibile creare/aggiornare l'hosting fisico: %1",
    'hst_def__unable_create/update_std_fwd' => "Impossibile creare/aggiornare l'inoltro standard: %1",
    'hst_def__unable_create_forwarding_myself' => "Impossibile creare l'inoltro al dominio stesso.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Impossibile consentire l'uso di una directory singola per memorizzare il contenuto SSL/TLS e non-SSL/TLS: Il supporto SSL/TLS non è attivato.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Impossibile attivare il supporto SSL/TLS: nessun certificato SSL/TLS installato",
    'hst_def__url_is_invalid' => "L'URL non è valido.",
    'hst_def__virtual_host_access' => "Accesso al virtual host per il Dominio %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ATTENZIONE. Questo host virtuale utilizza un indirizzo IP inesistente per l'hosting.",
    'hst_def__you_have_no_ips' => "Non hai indirizzi IP disponibili e non sei autorizzato a creare hosting Name-based",
    'hst_sel__header' => "Per ospitare un sito web su questo server, scegli l'opzione Hosting fisico.\n Per configurare l'inoltro di dominio verso un sito su un computer diverso, scegli l'opzione Inoltro frame o Inoltro standard.\n Con l'inoltro standard, un utente viene reindirizzato verso il sito e il vero URL del sito viene visualizzato nel suo browser, affinché l'utente sia al corrente del reindirizzamento. Con l'inoltro frame, un utente viene reindirizzato verso il sito senza sapere che il sito in realtà risiede in una posizione diversa.",
    'hst_sel__physical_hst' => "Hosting fisico",
    'hst_sel__select_hst_type' => "Selezionate una tipologia di hosting per il dominio",
    'hst_sel__select_hst_type_warning' => "Selezionate una tipologia di hosting per il dominio",
    'hst_sel__hosting_exists' => "Impossibile creare l'hosting perché è già configurato per questo dominio. Sarete reindirizzati alla sezione di gestione dominio.",
    'hst_sel__standard_frw' => "Inoltro standard",
    'hst_sel__frame_frw' => "Inoltro frame",
    '__frame_frw' => "Inoltro frame",
    '__hosting_exists' => "Impossibile creare l'hosting perché è già configurato per questo dominio. Sarete reindirizzati alla sezione di gestione dominio.",
    '__choose_hst_type' => "Selezionare la tipologia di hosting richiesta.",
    '__no_hst_conf' => "Nessun hosting configurato per il dominio.",
    '__physical_hst' => "Hosting fisico",
    '__select_hst_type' => "Selezionate una tipologia di hosting per il dominio",
    '__standard_frw' => "Inoltro standard",
    '__warning' => "Attenzione!! Tutte le impostazioni precedenti verranno cancellate. Siete sicuri di volere modificare la tipologia di hosting?",
    'i_cl_off' => "Cliente inattivo.",
    'i_cl_off_by_admin' => "L'account cliente è sospeso dall'amministratore del server.",
    'i_cl_off_expired' => "L'account cliente è scaduto.",
    'i_cl_on' => "Cliente attivo.",

    'icf__title' => 'Firewall connessione internet',
    'icf__if_legend' => 'Interfacce',
    'icf__mode' => 'Modo',

    'invalid_value' => 'Il valore non è valido',

    'ip_addr__already_exists' => "L'indirizzo IP %1 esiste già .",
    'ip_addr__cant_add' => "L'IP %1 non esiste o appartiene al pool IP di un altro cliente",
    'ip_alias__interface' => "Interfaccia",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 L'indirizzo IP per il virtual hosting name-based non è valido.",
    'ip_alias__invalid_ip_or_netmask' => "Accoppiamento indirizzo IP/maschera di rete non valido.",
    'ip_alias__orig_ip_can_not_be_deleted' => "L'indirizzo IP %1 è l'indirizzo IP del server originale, per cui non puoi rimuoverlo.",
    'ip_alias__ip_is_invalid' => "%1 L'indirizzo IP non è valido.",
    'ip_alias__ip_mask_is_invalid' => "L'IP mask %1 non è valido.",
    'ip_alias__ip_not_exist' => "L'indirizzo IP %1 non esiste.",
    'ip_alias__ip_address_and_mask' => 'Maschera di sottorete e indirizzo IP',
    'ip_alias__mask' => "Subnet mask",
    'ip_alias__remove_selected_ip_aliases?' => "Siete sicuri di voler rimuovere gli alias IP selezionati?",
    'ip_alias__select_ip' => "Selezionate almeno un indirizzo IP dalla lista per rimuoverlo.",
    'ip_alias__this_ip_used_for_domain' => "(%1) questo indirizzo IP è usato per il dominio %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) questo indirizzo IP è usato per virtual hosting name-based.",
    'ip_alias__unable_add_ip' => "Impossibile aggiungere l'alias IP : %1",
    'ip_alias__unable_remove_ip' => "Impossibile rimuovere l/gli alias IP : %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Non potete modificare l'indirizzo IP in condiviso, questo renderebbe l'FTP Anonimo indisponibile per il dominio '%1' .",
    'ip_ctrl__ip_addr' => "L'indirizzo IP %2 nell'interfaccia %1",
    'ip_ctrl__ip_exists_many_pools' => "Non è possibile modificare il tipo di IP. Questo indirizzo IP appartiene ai pool di diversi utenti contemporaneamente.",
    'ip_ctrl__ssl_cert' => "Certificato SSL/TLS",
    'limit__date_in_past' => "Il periodo di validità non è valido. %1 risulta nel passato.",
    'limit__enter_date' => "Inserire data",
    'limit__max_db' => "Database",
    'limit__name_disk_space' => "spazio su disco",
    'limit__name_max_box' => "caselle postali",
    'limit__name_max_db' => "Database di MariaDB/MySQL",
    'limit__name_max_dom' => "domini",
    'limit__name_max_maillists' => "liste di posta",
    'limit__name_max_subdom' => "sottodomini",
    'limit__name_max_traffic' => "traffico",
    'limit__name_max_wu' => "utenti web",
    'limit__name_mbox_quota' => "quota della casella postale",
    'limit__name_max_mn' => "account di posta",
    'limit__name_max_cl' => 'clienti',
    'limit__name_total_mboxes_quota' => "quota totale della casella postale",
    'limit__name_mysql_dbase_space' => "Spazio del database MariaDB/MySQL",
    'limit__name_mssql_dbase_space' => "Spazio del database MSSQL",
    'limit__name_pgsql_dbase_space' => "Spazio database PostgreSQL",
    'limit__name_expiration' => 'data di scadenza',

    'locale_upload__unable_to_install' => 'Impossibile installare il file del pacchetto lingua',
    'locale_upload__wrong_package' => 'Il file che hai caricato non contiene un language pack valido per questa versione di Plesk.',
    'locale_upload__wrong_locale' => 'Il file che hai caricato non contiene un pacchetto lingua valido.',

    'ma__create_title' => 'Creazione dell\'alias di posta per %1',
    'ma__edit_title' => "Modifica alias di mail %1",
    'ma__enter_new_alias' => "Inserire un nuovo alias.",
    'ma__invalid_alias' => "Alias di mail non valido.",
    'ma__mail_aliases_mailname' => "Alias di posta per l'account mail %1",
    'ma__mailname_does_not_exist' => "L'account di posta non esiste.",
    'ma__select_ma_for_remove' => "Selezionate gli alias di mail da rimuovere.",
    'ma__unable_to_add_new_ma' => "Impossibile aggiungere un alias di posta: %1",

    'mail_queue__not_allowed_by_license_key' => 'La gestione della coda della posta non è consentita della chiave della licenza',
    'maillist__' => "Mailing list %1",
    'maillist__already_exists' => "La mailing list esiste già .",
    'maillist__mail_alias_already_exists_in_this_domain' => "L'alias di mail %1 esiste già in questo dominio",
    'maillists__' => "Mailing list %1",
    'maillists__limit_cl_max_maillists' => "È stato raggiunto il limite di liste di posta per il cliente (limite: %1, usato: %2)",
    'maillists__limit_dom_max_maillists' => "È stato raggiunto il limite di liste di posta per il dominio.",
    'maillists__list' => "Liste di posta",
    'maillists__mailman_not_installed_or_conf' => "\nIl server Mailman non è installato o configurato \nin questo server. Contattate l'amministratore per richiedere l'installazione o la configurazione di MailMan.",
    'maillists__status' => "Il servizio di mailing list è attivato",
    'maillists__unable_to_delete__' => "Impossibile cancellare la mailing list: %1",
    'maillists__disabled_text' => 'Impossibile gestire le mailing list perché i componenti di server delle liste di posta Mailman non è installato o configurato.',
    'maillist_member__already_exists' => 'L\'utente è già iscritto a questa mailing list.',
    'maillist_member__not_exists' => 'Questo utente non risulta iscritto alla mailing list.',
    'mailserver_switching_warning' => "Attenzione!\n\nCambiare il server mail e' un'operazione da eseguirsi solo durante la configurazione iniziale e, se il server e' gia' in uso, causa i problemi seguenti: perdita delle impostazioni e del contenuto delle mailbox, e, in caso il server a cui si vuol passare sia già configurato, vari conflitti.\nSe questo server è attualmente utilizzato e sei certo di voler passare ad un altro, faresti meglio ad avvisare i clienti circa l'operazione in modo che possano scaricare e salvare la loro posta.",
    'manager__access_denied' => "Accesso negato: %1",
    'manager__admin' => "Amministratore",
    'manager__client' => 'Cliente',
    'manager__domain' => "Dominio",
    'manager__domain_cl_limit_exceeding' => "È stato raggiunto il limite di domini per questo account cliente.",
    'manager__domain_is_not_yours' => "Il dominio %1 non vi appartiene.",
    'manager__domain_key_limit_exceeding' => "Il limite della creazione di domini definita dalla vostra chiave di licenza è stato raggiunto.",
    'manager__no_perm_to_call' => "Non avete il permesso per chiamare %1.",
    'manager__no_perm_to_create_domains' => "Non avete il permesso per creare domini.",
    'manager__no_perm_to_modify_domain' => "Non avete il permesso per modificare il dominio %1.",
    'manager__no_perm_to_modify_domains' => "Non avete il permesso per modificare i domini.",
    'manager__no_perm_to_remove_domain' => "Non avete il permesso per rimuovere il dominio %1.",
    'manager__no_perm_to_remove_domains' => "Non avete il permesso per rimuovere domini.",
    'manager__node_doesnt_exist' => "%1 non esiste.",
    'manager__user_disabled' => "Il vostro account è stato sospeso. Non potete usare il sistema.",
    'mail_quota_unsupported' => "non supportato dal server di mail",
    'mbox_quota_unsupported' => "non supportato dal server di mail",
    'mn__create_title' => "Crea un account di posta",
    'mn__edit_title' => "Impostazioni",
    'mn__files_list_title' => "Allegati",
    'mn__files_remove' => "Rimuovi file dalla cartella allegati. Questi file sono probabilmente usati dalle risposte automatiche. Essi saranno eliminati sia dalla cartella sia per le risposte automatiche che li utilizzano.",
    'mn__files_select_for_remove' => "Seleziona i file da rimuovere.",
    'mn__mail_alias_form' => "Form per alias di mail",
    'mn__mail_aliases_list' => "Mail alias",
    'mn__mailbox' => "Gestione Mailbox",
    'mn__unable_define_mn' => "Impossibile impostare gli account di posta: %1",
    'mn__unable_remove_mbox_quota' => "Impossibile rimuovere la quota di mailbox: %1",
    'mn__upload_file' => "Caricare file",
    'mn_edit__attach_filename_changed' => 'Il file caricato %1 è stato rinominato %2 perché il suo nome conteneva caratteri non-ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Devi aggiungere almeno un iscritto al mail group prima di abilitarlo.",
    'mn_edit__add_resp_or_turn_off_box' => "Devi aggiungere una risposta automatica o deselezionare la casella di controllo della risposta automatica.",
    'mn_edit__attachments' => "Allegati",
    'mn_edit__dom_quota_less_then_quota' => "La dimensione di questa mailbox non deve superare il limite sulla quantità di spazio su disco assegnato per le malbox di questo dominio.",
    'mn_edit__enter_external_rcpnt_email' => "Immetti l'indirizzo e-mail di un membro del gruppo di posta esterno",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Digita un indirizzo per l'inoltro della posta o deseleziona la casella di controllo.",
    'mn_edit__ext_rcpnt_email_invalid' => "L'indirizzo e-mail del destinatario esterno non è valido.",
    'mn_edit__file_exists' => "Il file esiste. Sovrascrivere?",
    'mn_edit__files_deld_from_repository' => "Questi file verranno eliminati dall'archivio e dalle risposte automatiche che li contengono. Procedere?",
    'mn_edit__mail_name' => "Account di posta",
    'mn_edit__mail_name_invalid' => "Il nome dell'account di posta non è valido.",
    'mn_edit__mail_redir' => "Inoltri di posta",
    'mn_edit__mail_redir_add' => "Aggiungere Utente al Gruppo di Posta",
    'mn_edit__mail_resps' => "Risposte automatiche di posta",
    'mn_edit__mailbox' => "Casella postale",
    'mn_edit__enable_mailbox' => "Casella postale",
    'mn_edit__mailgroup' => "mail group",
    'mn_edit__mailgroup_addresses' => "Iscritti al mail group",
    'mn_edit__mailgroup_disabled' => "Disponibile soltanto quando l'account di posta è già stato aggiunto",
    'mn_edit__max_dom_quota' => "Default per il Dominio (%1)",
    'mn_edit__mbox_quota_invalid' => "La quota Mailbox non è valida.",
    'mn_edit__new_resp_name' => "Nome della nuova risposta automatica",
    'mn_edit__no_autoresponders' => "Devi aggiungere almeno una risposta automatica prima di attivare o disattivare il servizio di risposte automatiche.",
    'mn_edit__no_file_sel' => "Nessun file selezionato.",
    'mn_edit__no_mail_addresses' => "Non è stato specificato o selezionato alcun indirizzo e-mail.",
    'mn_edit__none' => "Nessuno",
    'mn_edit__not_create_pass' => "Questo non creerà una password per questo account.\nSenza una password, l'utente non sarà in grado di visualizzare ed inviare posta elettronica.",
    'mn_edit__redir_email_invalid' => "L'indirizzo d'inoltro non è valido.",
    'mn_edit__redirect_addr' => "Indirizzo d'inoltro",
    'mn_edit__remove_autoresp?' => "Sei sicuro di voler rimuovere la risposta automatica?",
    'mn_edit__remove_rcpnts?' => "Siete sicuri di voler rimuovere questi destinatari?",
    'mn_edit__repository' => "Cartella",
    'mn_edit__resps_attach' => "File in allegato alla risposta automatica",
    'mn_edit__select_rcpnt_from_list' => "Selezionare almeno un destinatario dalla lista da rimuovere.",
    'mn_edit__select_registered_users' => "Seleziona utenti registrati",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Avete scelto di avere una mailbox ma non ne avete impostato la password.",
    'mn_edit__unable_act_deact_mail_group' => "Impossibile attivare o disattivare il gruppo di posta: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Impossibile attivare o disattivare l'inoltro di posta: %1",
    'mn_edit__unable_act_deact_postbox' => "Impossibile attivare o disattivare la casella postale: %1",
    'mn_edit__unable_act_deact_resp' => "Impossibile attivare o disattivare le risposte automatiche: %1",
    'mn_edit__unable_add_attach' => "Impossibile aggiungere l'allegato: %1",
    'mn_edit__unable_add_mail_group_member' => "Impossibile aggiungere un iscritto al mail group : %1",
    'mn_edit__unable_add_resp' => "Impossibile aggiungere una risposta automatica: %1",
    'mn_edit__unable_change_mail_name' => "Impossibile cambiare il nome dell'account di posta: %1",
    'mn_edit__unable_deactivate_mail_group' => "Impossibile disattivare il mail group: %1",
    'mn_edit__unable_deactivate_resp' => "Impossibile disattivare le risposte automatiche di posta: %1",
    'mn_edit__unable_define_resp_id' => "Impossibile definire l'ID della risposta automatica: %1",
    'mn_edit__unable_remove_attach' => "Impossibile rimuovere l'/gli allegato/i: %1",
    'mn_edit__unable_remove_autoresp' => "Impossibile rimuovere la risposta automatica: %1",
    'mn_edit__unable_remove_mail_group_member' => "Impossibile rimuovere gli iscritti dal mail group : %1",
    'mn_edit__wrong_way' => 'I messaggi indirizzati a %1 non saranno processati, dato che l\'account di posta non ha una mailbox o un reindirizzamento attivati.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'La casella postale nell\'indirizzo %1 è stata disattivata. I messaggi nella casella postale non sono stati eliminati, ma non sarà possibile recuperarli attraverso i protocolli IMAP o POP3.',
    'mn_list__mail_names_for_domain' => "Account di posta nel dominio %1",
    'mn_list__sa_cannot_unable' => "Impossibile attivare il filtro antispam",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Cliente',
    'mn_list__tab_title_domain' => 'Dominio',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Nome",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "A",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Impossibile eliminare gli account di posta: %1",
    'module_upload__module_was_installed' => 'Questo modulo è già installato. Se desideri installare una nuova versione di questo modulo, disinstalla il modulo tramite Plesk e prova ad installarlo successivamente.',
    'module_upload__unable_to_install' => 'Impossibile installare il file pacchetto del modulo',
    'module_upload__wrong_package' => 'Il file caricato è un pacchetto del modulo non supportato.',
    'module_upload__wrong_module' => 'Il file caricato non contiene un pacchetto del modulo.',

    'news_articles_title' => 'Notizie Plesk',
    'notification_text__invalid_subject_length' => "Lunghezza oggetto dell’avviso non valida. Dovrebbe essere compreso tra 1 e 255 caratteri.",
    'notification_text__invalid_text_length' => "Testo della notifica di lunghezza non valida. (consentito da 1 a 65533 caratteri).",
    'notification_text__subject' => "Oggetto avviso",
    'notification_text__text' => "Testo Avviso",
    'notification_text__title' => "Modifica Avviso",
    'notification_text__unable_set_text' => "Impossibile modificare il testo dell'avviso:",

    'odbc__cant_add_dsn' => "Impossibile aggiungere il DSN %1: %2",
    'odbc__cant_connect' => "Impossibile connettere all'origine dei dati usando le impostazioni definite. Il server ha restituito: %1",
    'odbc__cant_delete_dsn' => "Impossibile cancellare il DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Impossibile ottenere l'informazione sui driver.",
    'odbc__cant_get_drivers' => "Impossibile ottenre la lista dei driver ODBC: %1",
    'odbc__cant_open_info_file' => "Impossibile aprire il file con l'informazione dei driver ODBC.",
    'odbc__cant_parse_string' => "Impossibile analizzare la stringa di connessione.",
    'odbc__driver_not_set' => "Il driver non è impostato",
    'odbc__driver_or_name_not_set' => "Il driver o il nome della connessione ODBC non sono stati impostati",
    'odbc__dsn_already_exists' => "Un DSN con questo nome (%1) è già presente nel sistema",
    'odbc__dsn_not_exists' => "Questo DSN non esiste",
    'odbc__enter_dsn_name' => "Inserire il nome DSN",
    'odbc__invalid_dsn_name' => "Sintassi per la connessione ODBC errata (%1): utilizzare solo simboli alfanumerici.",
    'odbc__no_such_driver' => "Il driver ODBC con questo nome (%1) non è supportato.",
    'odbc__unknown_driver' => "Nome di driver sconosciuto (%1).",
    'odbc_dsn_system' => "DSN di sistema",

    'pb__aliases' => "Alias",
    'pb__anonftp' => "FTP Anonimo",
    'pb__autoinstaller_releases' => 'Aggiornamento',
    'pb__cert' => "Certificati",
    'pb__cl_pool' => "Indirizzi IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Impostazioni",
    'pb__cl_rpt' => "Segnala",
    'pb__cl_rpt_list' => "Personalizza",
    'pb__cl_templates' => "Modelli di cliente",
    'pb__cl_traffic' => "Traffico",
    'pb__cl_traffic_history' => "Storico traffico",
    'pb__cl_traffic_of' => "Traffico di %1",
    'pb__client' => "%1",
    'pb__clients' => "Clienti",
    'pb__comp_info' => "Componenti del server",
    'pb__common_acl' => 'ACL di consenso trasferimento',
    'pb__cp_access' => "Accesso",
    'pb__crontab' => "Pianificatore",
    'pb__scheduler' => "Pianificatore",
    'pb__custom_buttons' => "Pulsanti personalizzati",
    'pb__databases_db' => 'Database',
    'pb__sqlservers_db' => 'Server SQL', //to check
    'pb__db' => "Database",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Server database',
    'pb__dl_usr_ed' => "Amministratore di dominio",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limiti del dominio",
    'pb__dom_pref' => "Impostazioni",
    'pb__dom_sum_report' => "Report riassuntivo dei domini",
    'pb__dom_templates' => "Modelli di Dominio",
    'pb__dom_traffic' => "Traffico di %1",
    'pb__domains' => "Domini",
    'pb__domain_aliases' => 'Alias di dominio',
    'pb__dumps_list' => "Archivio dei file di backup",
    'pb__forwarding_setup' => "Configurazione d'inoltro",
    'pb__filemanager' => "Manager di File",
    'pb__ip_aliasing' => "Indirizzi IP",
    'pb__ip_clients' => "Rimozione indirizzi IP",
    'pb__license_management' => 'Informazioni sulla licenza',
    'pb__locales' => 'Impostazioni internazionali',
    'pb__log_files' => "File di registro",
    'pb__mail' => 'Posta',
    'pb__mail_name_files' => "Allegati",
    'pb__mail_name_redirects' => "Inoltri di posta",
    'pb__mail_name_resp_attach_add' => "Nuovo allegato",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Risposte automatiche di posta",
    'pb__mail_names' => "Posta",
    'pb__maillists' => "Liste di posta",
    'pb__modules' => 'Moduli',
    'pb__modules_management' => 'Gestisci moduli',
    'pb__notifications' => "Notifiche",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Configura Hosting fisico",
    'pb__prtd_dirs' => "Directory protette",
    'pb__prtdir_edit' => "%1",
    'pb__report_list' => "Personalizza",
    'pb__server' => "Server",
    'pb__sessions' => "Sessioni",
    'pb__sapp_pool' => "Pool di Applicazioni Web",
    'pb__siteapp_install' => 'Installazione di applicazioni web',
    'pb__site_app_pkgs' => 'Applicazioni Web',
    'pb__site_apps' => "Applicazioni Web",
    'pb__additional_key_info' => 'Proprietà chiave licenza',
    'pb__additional_key_properties' => 'Proprietà chiave licenza',
    'pb__skins' => 'Skin',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtro antispam",
    'pb__statistics' => "Statistiche",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Sottodomini",
    'pb__templates' => "Template",
    'pb__virtualdirs' => 'Directory virtuali',
    'pb__web_users' => "Utenti web",
    'pdir__invalid_hst' => "La tipologia di hosting non è valida. Deve essere fisico.",
    'pdir__pd_id_is_undefined' => "L'ID della directory protetta non è definito.",
    'pdir__pdir_exist' => "La directory con questo nome è già protetta.",
    'pdir__pdir_not_exist' => "La directory protetta non esiste.",
    'pdir__pdir_usr_not_exist' => "L'utente per la directory protetta non esiste.",
    'pdir__remove_pdir_usrs' => "I seguenti utenti della directory protetta %2 nel sito web %1 verranno rimossi:",
    'pdir__remove_pdir_usrs_on_subdom' => "I seguenti utenti della directory protetta %2 nel sottodominio %1 verranno rimossi:",
    'pdir__select_pdir_usrs_for_remove' => "Seleziona gli utenti della directory protetta da eliminare.",
    'pdir__select_pdirs_to_remove' => "Seleziona le directory dal quale volete rimuovere la protezione.",
    'pdir__unable_define_pdir_users' => "Impossibile definire gli utenti della directory protetta.",
    'pdir__unable_define_pdirs_properties' => "Impossibile impostare le proprietà delle directory protette: %1",
    'pdir__unable_select_dom_param' => "Impossibile selezionare i parametri del Dominio : %1",
    'pdir_ed__dir_already_protect' => "La directory è già protetta.",
    'pdir_ed__invalid_login' => "Hai specificato un nome utente non valido.",
    'pdir_ed__login_exists' => "Questo utente esiste già. Prova a specificare un altro nome utente.",
    'pdir_ed__pdir_users' => "Utenti della directory protetta",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Seleziona almeno una casella di controllo tra SSL/TLS e non-SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Impossibile creare l'utente per la directory protetta: %1",
    'pdir_ed__unable_create_pdir' => "Impossibile creare la directory protetta: %1",
    'pdir_ed__unable_define_hst_type' => "Impossibile definire la tipologia di hosting.",
    'pdir_ed__unable_update_pdir' => "Impossibile salvare le impostazioni della directory protetta: %1",
    'pdir_ed__wrong_symbol_in_header' => "Non usare il carattere %1 nel titolo della directory.",
    'pdir_usr_ed__not_create_pass' => "Questa opzione non assegnerà una password all'utente della directory protetta. Senza password l'utente non sarà in grado di effettuare il login.",
    'pdir_usr_ed__unable_select_pdir_usr' => "Impossibile selezionare l'utente della directory protetta : %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Impossibile definire gli utenti della directory protetta: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Impossibile rimuovere gli utenti della directory protetta: %1",
    'phosting__anonftp_encrypt' => 'La password dell\'utente FTP è codificata, e quindi non può essere utilizzata per proteggere la directory /plesk-stat/webstat/. Reinserisci la password FTP, o deseleziona l\'opzione "accessibile tramite directory protetta da password \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Il nome di dominio %%domain_name%% risolve all'indirizzo IP %%dns_ip_address%%. Al tuo sito web è assegnato l'indirizzo IP %%hosting_ip_address%%. Se il tuo sito web non appare nel browser quando ti riferisci ad esso con il suo nome, vai alla schermata della gestione del DNS (Domini > Nome di dominio > DNS) e cambia le proprietà del registro di risorsa A: assegna l'indirizzo IP %%hosting_ip_address%% al nome di dominio %%domain_name%%.",
    'phosting__ip_change_warning' => "L'indirizzo IP è stato modificato. Le variazioni corrispondenti sono state applicate anche alla zona DNS del dominio.",
    'phosting__other_hosting_exists_on_ip' => "Non e' possibile modificare il certificato perche' questo indirizzo IP viene utilizzato in un o piu' account di hosting.",
    'phosting__unable_to_change_certificate' => "Impossibile installare il certificato: %1",
    'phosting__unable_to_change_ip_address' => "Impossibile modificare l'indirizzo IP: %1",
    'phosting__unable_to_set_cert' => "Impossibile impostare il certificato SSL/TLS: %1",
    'phosting__unable_update' => "Impossibile aggiornare le impostazioni di hosting: %1",
    'phosting__unable_manage' => "Impossibile gestire l'hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Impossibile configurare Fail2ban per il monitoraggio dei registri di dominio. La prossima volta che il servizio Fail2ban verrà riavviato, i registri verranno monitorati automaticamente.\n%1",

    'picker_acl_record__tittle' => 'Seleziona un record ACL',
    'picker_autoresponder__title' => 'Seleziona una risposta automatica',
    'picker_black_list__domain_name' => 'Seleziona un Nome a Dominio',
    'picker_certificate' => 'Seleziona un certificato SSL/TLS',

    'picker_dns_zone_template__title' => 'Seleziona record di risorsa',
    'picker_domain__title' => 'Seleziona un sito web',
    'picker_domain_alias__title' => 'Selezionare un Alias di Dominio',
    'picker_resource_record__title' => 'Seleziona record di risorsa',
    'picker_disabled_resource_record__title' => 'Selezionare un Name Server',
    'picker_ip_address__title' => 'Selezionare un Indirizzo IP',
    'picker_ip_address_clients__title' => 'Seleziona clienti che usano questo indirizzo IP',
    'picker_mail_queue' => 'Seleziona messaggi e-mail',
    'picker_site_application__title' => 'Selezionare un\'Applicazione Web',
    'picker_subdomain__title' => 'Scegli un Sottodominio',
    'picker_web_user__title' => 'Selezionare un Utente Web',
    'picker_custom_button__title' => 'Selezionare un Pulsante Personalizzato',
    'picker_license_key__title' => "Selezione della chiave di licenza",
    'picker_spamfilter_address__title' => 'Seleziona un Indirizzo Filtro Antispam',
    'picker_white_list__networks' => 'Selezione del Network',

    'plesk_key__action_logs' => "Registro di azioni realizzate dagli utenti di Plesk.",
    'plesk_key__app_vault' => "Application vault",
    'plesk_key__backup' => "Funzioni di backup e ripristino",
    'plesk_key__client_templs' => "Gestione di piani di servizio",
    'plesk_key__clients' => "Account utente (rivenditori e clienti)",
    'plesk_key__resellers_only' => "Account utente (rivenditori)",
    'plesk_key__customers_only' => "Account utente (clienti)",
    'plesk_key__domains' => "Domini",
    'plesk_key__domain_aliases' => "Alias di dominio",
    'plesk_key__subdomains_limit' => "Sottodomini",
    'plesk_key__databases' => "Database",
    'plesk_key__mssql_databases' => "Database MS SQL",
    'plesk_key__manage_dashboard' => 'Personalizzazione della Home page',
    'plesk_key__drweb' => "Gestione antivirus",
    'plesk_key__event_manager' => "Gestore di eventi",
    'plesk_key__expirations' => "Gestione di date di scadenza di account",
    'plesk_key__group_ops' => "Modifica di multipli oggetti alla volta",
    'plesk_key__expiration' => "Data scadenza key",
    'plesk_key__edition_name' => "Edizione Plesk",
    'plesk_key__key_number' => "Numero Key",
    'plesk_key__languages' => "Pacchetto lingua",
    'plesk_key__mailnames' => "Account di posta",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Supporto di Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Collegamenti per acquistare certificati SSL/TLS e servizi di registrazione di domini",
    'plesk_key__myplesk_server_id' => "Identificatore MPC server slave",
    'plesk_key__notifications' => "Gestione di notifiche",
    'plesk_key__postgresql' => "Supporto di server database PostgreSQL",
    'plesk_key__qmail_queue' => 'Gestione della coda di posta',
    'plesk_key__remote_db' => 'Hosting del database remoto',
    'plesk_key__slave_servers' => "Server secondari",
    'plesk_key__spamassassin' => "Gestione del filtro antispam",
    'plesk_key__subdomains' => "Gestione sottodomini",
    'plesk_key__sys_access' => "Gestione dell'accesso al server",
    'plesk_key__traffic_reports' => "Report sull'utilizzo del traffico",
    'plesk_key__tts' => "Helpdesk",
    'plesk_key__virtuozzo' => "Valido solo per Virtuozzo Containers",
    'plesk_key__webusers' => "Utenti web",
    'plesk_key__cpu_cores' => 'Core CPU',
    'plesk_key__ram' => 'Memoria',
    'plesk_key__license_update_date' => 'Prossimo aggiornamento chiave di licenza',
    'plesk_key__autoinstaller_config' => 'Gestione di impostazioni dell\'updater',
    'plesk_key__check_wrong' => "La chiave di licenza non è valida. Per usare Plesk, è necessario ottenere ed installare una nuova chiave di licenza valida.",
    'plesk_key__upload_check_wrong' => 'La chiave di licenza caricata non è valida.',
    'plesk_key__revert_check_wrong' => 'La chiave di licenza installata precedentemente non è valida.',
    'plesk_key__viruozzo_only_key' => 'È consentito l\'uso della chiave di licenza solo con Plesk operativo all\'interno di Virtuozzo Containers.',
    'plesk_key__ip_ranges_exceeded' => 'Puoi usare questa copia di licenza di Plesk solo con i seguenti indirizzi IP: %2. I seguenti indirizzi IP non sono coperti dalla tua licenza: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'La quantità delle risorse attualmente usate supera i limiti definiti dalla vostra licenza.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Il numero di siti web ospitati sul server supera i limiti definiti dalla tua licenza. Hai %2 siti ospitati; la tua licenza consente di ospitare solo %1 siti.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Il numero degli alias di dominio presenti sul server eccede il limite definito per la tua licenza. Ha %2 alias di dominio; la tua licenza consente l\'hosting di soli %1 alias di dominio.',
    'plesk_key__limits_exceeded_lim-subdom' => 'Il numero di sottodomini presenti sul server supera il limite definito per la tua licenza. Hai a disposizione %2 alias di sottodominio; il numero di alias consentiti dalla tua licenza è pari a %1.',
    'plesk_key__limits_exceeded_lim-db' => 'Il numero di database presenti sul server supera il limite definito per la tua licenza. Hai a disposizione %2 database; il numero di database consentiti dalla tua licenza è pari a %1.',
    'plesk_key__limits_exceeded_lim-mssql-db' => 'Il numero di database MS SQL presenti sul server supera il limite definito per la tua licenza. Hai a disposizione %2 database; il numero di database consentiti dalla tua licenza è pari a %1.',
    'plesk_key__limits_exceeded_lim_cl' => 'Il numero di account cliente serviti supera i limiti definiti dalla tua licenza. Hai %2 account cliente attualmente serviti; la tua licenza consente di servire solo %1 account cliente.',
    'plesk_key__limits_exceeded_lim_mn' => 'Il numero di account di posta elettronica distribuiti supera i limiti definiti dalla tua licenza.%2 account di posta sono stati al momento distribuiti;la tua licenza consente di servire solo %1 account di posta.',
    'plesk_key__limits_exceeded_lim_wu' => 'Il numero di account per utenti web serviti eccede il limite definito dalla tua licenza. Tu hai %2 account per utenti web serviti attualmente; la tua licenza consente di servire solo %1 account per utenti web.',
    'plesk_key__limits_exceeded_MLS' => 'Il numero di pacchetti lingua correntemente installati supera i limiti definiti dalla vostra licenza. Ci sono %2 pacchetti lingua in uso; la vostra licenza consente di installare solo %1 pacchetti lingua.',
    'plesk_key__wrong_version' => 'Stai cercando di usare una chiave di licenza creata per un\'altra versione di Plesk. Contatta i rappresentanti Plesk per ottenere una chiave di licenza adeguata.',
    'plesk_key__other_product' => 'Stai provando ad usare una chiave di licenza creata per un altro prodotto. Contatta i rappresentanti Plesk per ottenere una chiave di licenza adeguata.',
    'plesk_key__invalid_machine_id_trial' => 'La tua licenza attuale non è valida poiché risulta già attiva su un altro server Plesk. Per continuare a usare Plesk, installa una nuova licenza o nuovamente la tua licenza attuale digitando il relativo codice di attivazione (se ne hai uno).',
    'plesk_key__invalid_machine_id_retail' => 'La tua licenza attuale non è valida poiché risulta già attiva su un altro server Plesk. L\'EULA di WebPros (https://www.plesk.com/legal/) vieta l\'uso della medesima licenza su due o più server contemporaneamente. Per continuare a usare Plesk, installa una nuova licenza o nuovamente la tua licenza attuale digitando il relativo codice di attivazione. Puoi trovarlo nell\'e-mail che hai ricevuto all\'atto dell\'acquisto della licenza stessa.<br>Non riesci a trovare il codice di attivazione? Puoi recuperarlo tramite Plesk 360, accedendo a https://platform360.io/ con l\'indirizzo e-mail usato per l\'acquisto della licenza: troverai il codice nella scheda "Licenze". In alternativa, puoi contattare il supporto per le licenze e gli acquisti di Plesk tramite l\'apposito modulo online (https://www.plesk.com/licensing-and-purchase-support/). Ricorda di menzionare il tuo numero di licenza nel campo "How can we help you?" del modulo.',
    'plesk_key__limits_exceeded_error' => 'Impossibile installare la chiave di licenza: Le quantità di risorse attualmente usate supera i limiti definiti per la chiave di licenza scaricata.',
    'plesk_key__limits_exceeded_note' => 'Le quantità di risorse attualmente usate supera i limiti definiti per la chiave di licenza scaricata.',
    'plesk_key__hardware_limits_exceeded' => 'La configurazione dell\'hardware supera i limiti definiti dalla licenza Plesk.',
    'plesk_key__hardware_limits_exceeded_lim-ram' => 'Il server ha %1 di memoria installati, ma la licenza non ne permette più di %2.',
    'plesk_key__hardware_limits_exceeded_lim-cpu-cores' => 'Il server ha %1 core di CPU installati, ma la licenza non ne permette più di %2.',
    'plesk_key__key_file_invalid' => 'Il file della chiave inviato non è valido o non contiene una chiave di licenza.',
    'plesk_key__server_request_error' => 'Impossibile aggiornare la licenza. Assicurati che le connessioni al server di licenze ka.plesk.com sulla porta TCP %1 non siano bloccate. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Visualizza come procedere</a>.',
    'key__no_key_file_in_zip' => 'Il file .zip inviato non contiene nessuna chiave di licenza',
    'key__key_upload' => 'Installazione chiave di licenza',
    'additional_key__prop_name' => 'Proprietà',
    'additional_key__prop_value' => 'Valore',
    'additional_key__descr_name' => 'Nome chiave',
    'additional_key__descr_key_number' => 'Numero Key',
    'additional_key__descr_key_vz' => "Questa chiave di licenza è destinata all'utilizzo esclusivo di Virtuozzo Containers.",
    'additional_key__descr_key_mailboxes' => 'Caselle postali',
    'additional_key__descr_lim_date' => 'Data di scadenza',
    'additional_key__descr_license_update_date' => 'Prossimo aggiornamento chiave di licenza',
    'additional_key__file_invalid' => 'Il file della chiave inviato non è valido o non contiene una chiave di licenza.',
    'additional_key__file_incompatible' => 'La chiave di licenza inviata non è valida per questa applicazione.',
    'additional_key__not_exists' => 'Nessuna chiave di licenza installata.',
    'additional_key_update__result_response' => 'Risposta del server di licenza: %1',
    'additional_key_update__result_network' => 'Impossibile connettersi al server di licenza. Prego controlla che la tua rete consenta la comunicazione verso %1: %2.',
    'additional_key_update__result_lock' => 'L\'aggiornamento della chiave è già in corso',
    'additional_key_update__result_internal_error' => 'Si è verificato un errore durante l\'aggiornamento della chiave di licenza: %1',

    'proceed_to_cl_pool' => "Prosegui alla configurazione del pool IP del cliente",
    'proceed_to_hosting_setup' => "Procedere con l'impostazione dell'hosting",
    'removeCerts__remove_certificates_cp' => "I seguenti certificati saranno rimossi:",
    'removeCerts__remove_certificates_domain' => "I seguenti certificati di proprietà di %1 saranno rimossi: ",
    'removeClientsIP_remove_clients_ip' => "Questo indirizzo ip verrà rimosso dai pool dei seguenti clienti:",
    'removeMailAliases__remove_mail_aliases' => "I seguenti alias per l'account di posta %1 saranno eliminati:",
    'removeMailNames__remove_mailnames' => "I seguenti account di posta ed alias verranno rimossi dal dominio %1:",
    'removeMailNames__remove_mailnames_of_cl' => "I seguenti alias ed account di posta verranno rimossi dal dominio %2 appartenente al cliente %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Questi account di posta non saranno eliminati.",
    'removeFtpSessions__remove_title' => "Le seguenti sessioni FTP saranno terminate:",
    'removeTemplates__remove_templates' => "Le seguenti template saranno rimossi:",
    'resp_edit__always_respond' => "Rispondi sempre",
    'resp_edit__reply_subject' => "Oggetto di risposta",
    'resp_edit__answer_subject' => "Rispondi con il soggetto",
    'resp_edit__answer_txt' => "Rispondi con il testo",
    'resp_edit__attach' => "Allega file",
    'resp_edit__default_subject' => "Re: %1",
    'resp_edit__for' => "per",
    'resp_edit__frw_rqst_email' => "Dopo la risposta automatica, invia il messaggio originale all'indirizzo e-mail indicato",
    'resp_edit__fwd_email_invalid' => "Indirizzo e-mail di destinazione non valido.",
    'resp_edit__in_body' => "nel corpo del testo",
    'resp_edit__in_subject' => "nell'oggetto",
    'resp_edit__invalid_resp_freq' => "La frequenza di risposta non è valida.",
    'resp_edit__invalid_rqst_txt' => "Il testo nella richiesta non è valido.",
    'resp_edit__invalid_store_lim_num' => "Il limite non è valido.",
    'resp_edit__limits_title' => "Limiti",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Il numero di risposte giornaliere supera quello definito. Permesso: %1, richieste: %2",
    'resp_edit__no_files_sel' => "Nessun file selezionato.",
    'resp_edit__no_txt_supplied' => "Nessun testo fornito.",
    'resp_edit__reply_title' => "Rispondi",
    'resp_edit__reply_to_address' => "Indirizzo di risposta",
    'resp_edit__reply_to_invalid' => "L Indirizzo di risposta non è valido.",
    'resp_edit__reply_uniq_email' => "Rispondi all'indirizzo e-mail unico non più di",
    'resp_edit__conditions_title' => "Condizioni",
    'resp_edit__request_title' => "Richiesta",
    'resp_edit__resp' => "Risposta automatica",
    'resp_edit__resp_name' => "Nome della risposta automatica",
    'resp_edit__resp_not_exist' => "La risposta automatica non esiste.",
    'resp_edit__resp_status' => "Stato della risposta automatica",
    'resp_edit__rqst_txt' => 'Testo richiesta',
    'resp_edit__select_files_on_server_for_attach' => "Seleziona i file da allegare",
    'resp_edit__store_up_to' => "Memorizza sino a",
    'resp_edit__subj_line_invalid' => "L'oggetto non è corretto.",
    'resp_edit__text_too_big' => "Il messaggio di risposta è troppo lungo.",
    'resp_edit__times_in_a_day' => "volte al giorno.",
    'resp_edit__unable_define_resp_cond' => "Impossibile definire la condizione della risposta automatica: %1",
    'resp_edit__unable_define_resp_status' => "Impossibile definire lo stato della risposta automatica: %1",
    'resp_edit__unable_turn_on_resp' => "Impossibile attivare la risposta automatica: %1",
    'resp_edit__uniq_email' => "indirizzo e-mail unico",
    'resp_edit__content_type' => 'Formato invio email',
    'resp_edit__content_type_text' => 'Testo normale',
    'resp_edit__content_type_html' => 'Modalità HTML',
    'resp_edit__charset' => 'Codifica',
    'restart__dns' => 'Server DNS (%1)',
    'restart__drweb' => 'Antivirus Plesk Premium',
    'restart__mail' => "Server IMAP/POP3 (%1)",
    'restart__mssql' => "Server Microsoft SQL",
    'restart__mysql' => "Server MariaDB/MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Servizi",
    'restart__smtp' => "Server SMTP (%1)",
    'restart__spamd' => "Filtro antispam",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "WEB Server (%1)",
    'restart__ftp' => "Server FTP (%1)",
    'restart__service_start' => 'Concedere un po\' di tempo al servizio per avviarsi.',
    'restart__service_stop' => 'Concedere un po\' di tempo al servizio per arrestarsi.',
    'restart__service_restart' => 'Concedere un po\' di tempo al servizio per riavviarsi.',
    'rm_domains__some_domains_are_not_exist' => "Alcuni dei domini specificati non esistono. Probabilmente sono stati rimossi da un altro utente.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "GruppPost",
    'rpt_cl_dom_mail_lists' => "MList",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBox",
    'rpt_cl_dom_redirects' => "Inoltri",
    'rpt_cl_dom_subdomains' => "Sottodom",
    'rpt_cl_dom_domain_aliases' => "DAlias",
    'rpt_cl_dom_web_users' => "UtentiW",
    'rpt_cl_report_for_admin__' => "Report per l'amministratore %1",
    'rpt_cl_report_for_reseller__' => "Report per rivenditore %1",
    'rpt_cl_report_for_cl__' => "Report su cliente %1",
    'rpt_cl_section_domains' => "Domini",
    'rpt_cl_section_full_domains' => "Domini",
    'rpt_cl_section_general' => "Generale",
    'rpt_create' => "Crea report",
    'rpt_empty' => "Il report deve contenere almeno una sezione",
    'rpt_dom_report_for_dom__' => "Report dominio per %1",
    'rpt_dom_section_databases' => "Database",
    'rpt_dom_section_full_databases' => "Database",
    'rpt_dom_section_full_maillists' => "Liste di posta",
    'rpt_dom_section_full_mailnames' => "Account di posta",
    'rpt_dom_section_full_webusers' => "Utenti web",
    'rpt_dom_section_full_siteapps' => 'Applicazioni Web',
    'rpt_dom_section_full_aspnetapps' => 'Applicazioni web di ASP.NET',
    'rpt_dom_section_general' => "Generale",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Liste di posta",
    'rpt_dom_section_mailnames' => "Account di posta",
    'rpt_dom_section_siteapps' => 'Applicazioni Web',
    'rpt_dom_section_aspnetapps' => 'Applicazioni web di ASP.NET',
    'rpt_dom_section_webusers' => "Utenti web",
    'rpt_dom_title_wa_status' => "A",
    'rpt_edit__' => "Edit report %1",
    'rpt_enter_email_address' => "Immetti l'indirizzo e-mail a cui verrà inviato il resoconto.",
    'rpt_list' => "Layout personalizzato per il report",
    'rpt_section_full' => "Completo",
    'rpt_section_none' => "Nessuno",
    'rpt_section_summary' => "Sommario",
    'rpt_default_full' => 'Report completo',
    'rpt_default_summary' => 'Rapporto riassuntivo',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Errore durante l'invio del report: %1",
    'rpt_send_report_by_email_ok__' => "Il rapporto è stato inviato a %1",
    'sa_action' => "Azione",
    'sa_action_del' => "Elimina",
    'sa_action_desc' => "Cosa fare con lo spam",
    'sa_action_save' => "Indicare come spam e salvare nella mailbox",
    'sa_admin_blacklist' => "Black list dell'amministratore",
    'sa_admin_whitelist' => "Lista bianca dell'amministratore",
    'sa_db_del_confirm' => "Siete sicuri di voler eliminare il database del Filtro Spam?",
    'sa_eml_in_ignorelist' => "Il messaggio è nella lista di elementi da ignorare",
    'sa_empty_email' => "Impossibile aggiungere un modello di e-mail vuoto.",
    'sa_exists_email' => "Tale modello email esiste già.",
    'sa_disabled__mailname_not_filtering' => "Le impostazioni correnti del server non consentono l'uso di filtri di mail per questo account di posta",
    'sa_disabled__filtering_is_disabled' => 'Il filtro antispam è stato disattivato dall\'amministratore del server',
    'sa_disabled__hasnt_mailbox' => "Impossibile attivare il filtro antispam senza una mailbox",
    'sa_enable_filter' => "Attiva il filtro antispam",
    'sa_forget' => "dimentica",
    'sa_from' => "Da",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Il Pattern non è valido.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Apprendimento filtro antispam',
    'sa_trainer__tools_legend' => 'Strumenti',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Messaggi nella tua mailbox',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Soggetto',
    'sa_trainer__from' => 'Da',
    'sa_trainer__date' => 'Data',
    'sa_trainer__info_text' => 'Messaggi appresi: %1 come spam, %2 come non-spam, %3 totali.',
    'sa_trainer__messages' => 'messaggio/i',
    'sa_trainer__select__all' => 'Tutti',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Non-Spam',
    'sa_trainer__select__unknown_only' => 'Sconosciuto',
    'sa_trainer__cannot_remove_messages' => 'Impossibile eliminare i messaggi selezionati dalla mailbox.',
    'sa_trainer__remove_messages_confirm' => 'Sei sicuro di voler eliminare i messaggi selezionati dalla mailbox?',
    'sa_subj' => "Soggetto",
    'sa_training' => "Apprendimento filtro antispam",
    'sa_training_legend' => "Filtro autoapprendimento Bayesian",
    'sa_use_srv_settings' => "Usare le impostazioni globali del server",
    'sa_user_blacklist' => "Black list utente",
    'sa_user_whitelist' => "Lista bianca dell'utente",
    'sa_usr_disabled_by_srv' => "Le impostazioni individuali del filtro antispam non sono consentite dall'amministratore del server",
    'sa_usr_no_postbox' => "Impossibile abilitare il filtro spam perché la casella postale è disattivata per questo account di posta.",
    'sa_filters' => 'Filtri spam',
    'spamfilter__tools_legend' => 'Strumenti',
    'spamfilter__prefs_legend' => 'Impostazioni',
    'spamfilter__max_children' => 'Il numero massimo di processi di lavoro di spamd da eseguire',
    'spamfilter__rewrite_header_subject_hint' => 'Lascia questo campo vuoto se non vuoi aggiungere alcun testo.Digita _SCORE_ se vuoi includere il punteggio nell\'oggetto del messaggio.',
    'spamfilter__reject_spam' => 'Cancella le email spam quando arrivano nella mailbox.',
    'spamfilter__enabled' => 'Attivato',
    'spamfilter_addresses_list__items' => 'indirizzi',
    'spamfilter_addresses__remove_title' => 'I seguenti indirizzi saranno eliminati dall\'elenco:',
    'spamfilter_addresses__empty_selection' => 'Nessun indirizzo selezionato',
    'server__admin_info' => "Informazioni dell'amministratore",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Inserire la descrizione del bug di seguito",
    'server__power_management' => "Gestione alimentazione",
    'server__services' => "Servizi",
    'server__system' => "Sistema",
    'server__title' => "Amministrazione Server",
    'server_preferences__admin_skin' => "Stile dell'interfaccia amministrativa",
    'server_preferences__default_language' => "Lingua predefinita",
    'server_preferences__default_skin' => "Stile di Default",
    'server_preferences__restart_apache_interval' => "intervallo di restart di Apache",
    'server_preferences__system' => 'Impostazioni di sistema',
    'mail__tabs_preferences' => "Impostazioni",
    'mail__tabs_white_list' => "Lista Bianca",
    'mail__tabs_smarthost' => "Smarthost",
    'server_preferences__use_vocabulary' => "Controlla le password delle mailbox nel dizionario",
    'sessions__agreement' => "Si, voglio terminare queste sessioni.",
    'sessions__select_sessions_for_remove' => "Selezionare le sessioni da terminare.",
    'sessions__tabs_cp_sessions' => 'Sessioni Plesk',
    'sessions__tabs_ftp_sessions' => 'Sessioni FTP',
    'sessions__ftp_sessions_login' => 'Nome utente dell\'account FTP',
    'sessions__ftp_sessions_domain' => 'Nome del dominio',
    'sessions__ftp_sessions_path' => 'Posizione corrente',
    'sessions__ftp_sessions_file' => 'Nome di file',
    'sessions__ftp_sessions_action' => 'Stato',
    'sessions__ftp_sessions_speed' => 'Velocità',
    'sessions__ftp_sessions_comp' => 'Completato (%)',

    'site_apps__access_level' => 'Livello di accesso',
    'site_apps__access_level_commercial' => 'Commerciale',
    'site_apps__access_level_free' => 'Gratis',
    'site_apps__action_installer' => "Installazione di applicazioni web",
    'site_apps__action_reconfigure' => "Riconfigurazione dell'applicazione web",
    'site_apps__custom_button_level' => 'Creare un pulsante personalizzato per accedere a questa applicazione?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nessuno',
    'site_apps__custom_button_level_domain_user_only' => 'Sì',
    'site_apps__custom_button_level_false' => 'Nessuno',
    'site_apps__custom_button_level_domain' => 'Sì, renderlo disponibile solo per il dominio corrente',
    'site_apps__custom_button_level_client' => 'Sì, e rendila disponibile a tutti i domini del cliente',
    'site_apps__custom_button_level_admin' => 'Sì, renderlo disponibile per tutti i domini',
    'site_apps__description' => "Descrizione",
    'site_apps__dir_used_by_sapp__' => "La directory \"%1\" è utilizzata da un'altra applicazione web",
    'site_apps__dir_used_by_unknown__' => "La directory \"%1\" esiste già. Il suo contenuto sarà sovrascritto se continuate avanti.",
    'site_apps__dir_invalid_name__' => "Il nome della directory %1 non e' corretto.",
    'site_apps__file_name' => 'Nome del file di applicazione web',
    'site_apps__invalid_install_prefix' => "Prefisso di installazione non valido",
    'site_apps__invalid_package' => "Applicazione web non valida",
    'site_apps__key_status' => 'Gestione licenze',
    'site_apps__key_status_free' => 'Di libera distribuzione. Nessuna licenza richiesta',
    'site_apps__key_status_ok' => 'La chiave di licenza necessaria è installata',
    'site_apps__key_status_problem' => 'La chiave di licenza necessaria non è installata',
    'site_apps__name' => "Nome",
    'site_apps__no_domains' => 'L\'applicazione web non può essere installata. C\'è già un\'altra applicazione web installata nella directory principale del dominio. Puoi decidere di creare un sottodominio per l\'applicazione web.',
    'site_apps__package_info_' => "Informazione sull'Applicazione Web",
    'site_apps__package_integrated' => "applicazione preintegrata, impossibile rimuoverla",
    'site_apps__pool_select_packages_to_add' => 'Selezionare le applicazioni web da aggiungere al pool',
    'site_apps__release' => "Release",
    'site_apps__resource_used_by_sapp' => "Questa risorsa è utilizzata da un'applicazione web installata",
    'site_apps__root_used_by_sapp' => "Questa risorsa è utilizzata da un'applicazione web installata",
    'site_apps__these_domains_will_not_delete' => 'Questi (sotto)domini non saranno eliminati',
    'site_apps__upload_site_app_pkg_title' => 'Caricare nuova applicazione web',
    'site_apps__version' => "Versione",
    'site_apps__access_to' => "Accesso a %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__archiver_not_installed' => "Impossibile estrarre il contenuto dell'archivio. Possibilmente l'archivio non è installato sul server. Contattare l'amministratore di {$PROD_NAME} per richiedere l'installazione del software di archiviazione.",
    'skeleton__archive_corrupted' => "Il controllo archivio ha determinato che il file è rovinato o il tipo di archivio non è supportato.",
    'skeleton__archive_too_large' => "Il controllo dell'archivio ha verificato che il file supera la dimensione massimo.",
    'skeleton__not_supported_archive_type' => "Questo tipo di archivio (file %1) non è supportato",
    'skin_download__title' => 'Download tema grafico',
    'skin_download_now__title' => 'Download tema grafico in corso',
    'skin_download_now__text' => 'Creazione di un pacchetto di skin in corso.<br>Questa procedura può richiedere alcuni minuti.<br> Sarà possibile continuare ad utilizzare Plesk dopo la comparsa della finestra di dialogo.',
    'skin_file__help_for_using_types' => "Utilizzare gli archivi di skin in uno dei seguenti formati:",
    'skin_info__title' => 'Proprietà tema grafico',
    'skin_mng_err__rpm_not_skin' => 'Questo RPM non è un pacchetto di skin Plesk.',
    'skin_mng_err__psa_install_noreloc' => 'Impossibile installare il tema rpm nella posizione specificata.',
    'skin_mng_err__already_exists' => 'La cartella di installazione dei temi esiste già, e contiene un pacchetto tema inviato.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Il file inviato non è un pacchetto tema RPM valido.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Il file inviato non è un pacchetto tema valido.',
    'skin_mng_err__rpm_upgrade_base' => "Il file inviato non è un pacchetto tema grafico {$PROD_NAME} valido.",
    'skin_mng_err__rpm_upgrade_other' => 'Impossibile installare il tema: formato tema non valido.',
    'skin_mng_err__no_a_skin' => "Il file inviato non è un pacchetto tema grafico {$PROD_NAME} valido.",
    'skin_upload__title' => 'Caricare Nuova Skin',
    'skin_upload__already_exists' => "La skin '%1' esiste già.",
    'skin_upload__unable_to_apply' => "Il file caricato non contiene una skin di Plesk o il formato dell'archivio non è compatibile.",
    'skin_upload__unable_to_rename__' => "Non e' possibile rinominare lo skin %2 in %1: %3",
    'skin_upload__file_name' => 'Percorso del package del tema grafico',
    'skins_list__title' => 'Elenco temi grafici',
    'skins_remove__title' => 'Rimozione tema grafico',
    'skins_remove__select_skins_for_remove' => 'Selezionare le skin da rimuovere.',

    'spf__unable_update' => 'Impossibile aggiornare i parametri SPF',
    'statistics__active_domains' => "Domini attivi",
    'statistics__clients' => "Clienti",
    'statistics__subdomains' => "Sottodomini",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Database",
    'statistics__db_users' => "Utenti database",
    'statistics__dirs' => "Directory protette",
    'statistics__dom_active' => "Attivo/a",
    'statistics__dom_passive' => "Passivo/a",
    'statistics__dom_problem' => "Problema",
    'statistics__domains' => "Domini",
    'statistics__domains_with_host' => "Domini con hosting",
    'statistics__doms' => "Domini",
    'statistics__filesystem' => "Sistema di file",
    'statistics__general' => "Generale",
    'statistics__hdd_available' => "Disponibile",
    'statistics__hdd_capacity' => "Capacità",
    'statistics__hdd_total' => "Totale",
    'statistics__hdd_usage' => "Utilizzo dell'Hard Disk",
    'statistics__hdd_used' => "Usato",
    'statistics__ip' => "Indirizzo IP",
    'statistics__key_number' => "Numero Key",
    'statistics__l1' => "Ultimo minuto",
    'statistics__l15' => "Ultimi 15 minuti",
    'statistics__l5' => "Ultimi 5 minuti",
    'statistics__la' => "Utilizzo di CPU",
    'statistics__mail_autoresponders' => "Risposte automatiche",
    'statistics__mail_boxes' => "Caselle postali",
    'statistics__mail_groups' => "mail group",
    'statistics__mail_lists' => "Liste di posta",
    'statistics__mail_redirects' => "Inoltri di posta",
    'statistics__mem' => "Utilizzo memoria",
    'statistics__mem_usage' => "Utilizzo",
    'statistics__memory_available' => "Disponibile",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Cached",
    'statistics__memory_free' => "Libero",
    'statistics__memory_shared' => "Condivisi",
    'statistics__memory_total' => "Totale",
    'statistics__memory_used' => "Usato",
    'statistics__os' => "SO",
    'statistics__problem_clients' => "Clienti con problemi",
    'statistics__problem_domains' => "Domini con problemi",
    'statistics__swap' => "Utilizzo di Swap",
    'statistics__swap_free' => "Libero",
    'statistics__swap_total' => "Totale",
    'statistics__swap_usage' => "Utilizzo",
    'statistics__swap_used' => "Usato",
    'statistics__system_stat' => "Informazioni del server",
    'statistics__unable_define_active_doms' => "Impossibile definire il numero di domini attivi: %1",
    'statistics__unable_define_inactive_doms' => "Impossibile definire il numero di domini inattivi: %1",
    'statistics__failed_define_swap_usage' => 'Impossibile definire l\'utilizzo di swap',
    'statistics__failed_define_load_averages' => 'Impossibile definire le medie di carica',
    'statistics__up_time' => "Sistema attivo da:",
    'statistics__ver' => "Versione",
    'statistics__web_users' => "Utenti web",
    'statistics__mem_win' => "Utilizzo della memoria fisica",
    'statistics__memory_total_win' => "Totale",
    'statistics__memory_used_win' => "Usato",
    'statistics__memory_free_win' => "Disponibile",
    'statistics__swap_win' => "Utilizzo della memoria virtuale",
    'statistics__swap_total_win' => "Totale",
    'statistics__swap_used_win' => "Usato",
    'statistics__swap_free_win' => "Disponibile",
    'status__domain_has_reasons_to_be_off' => "Il dominio è ancora sospeso per il seguente motivo: %1",
    'subdomain__create__' => "Creare un sottodominio nel dominio %1",
    'subdomain__edit__' => "Gestire il sottodominio %1",
    'subdomain__invalid_name' => "Nome subdominio non valido",
    'subdomain__incorrect_name' => "Nome sottodominio non valido.",
    'subdomains__maillists_enabled_in_domain' => "Nome di sottodominio non valido nelle liste.%1: questo nome di dominio è già in uso dalle liste di posta nel dominio %1.",
    'subdomains__dalias_exists' => 'Esiste già un alias di dominio con questo nome.',
    'subdomains__name_exists' => "Esiste già un sottodominio con questo nome.",
    'subdomains__regular_domain_exists' => "Esiste già un dominio con questo nome.",
    'subdomains__domain_alias_exists' => 'Esiste già un alias di dominio con questo nome.',
    'subdomains__remove_subdomains_on_domain' => "I seguenti sottodomini per il dominio %1 saranno rimossi:",
    'subdomains__select_subdomains_for_remove' => "Seleziona i sottodomini da rimuovere.",
    'subdomains__webmail_enabled_in_domain' => "Webmail del nome di sottodominio non valido.%1: questo nome di dominio è già in uso per accedere al webmail nel dominio %1.",
    'subdomains__dns_record_already_exists' => 'Impossibile creare il sottodominio %1 perché c\'è già un record DNS che punta all\'host %1.',
    'subdomains__www_prefix_in_domain' => "Nome del sottodominio errato www.%1: il dominio %1 ha già il prefisso WWW.",
    'subdomains__user_type_quota_exceeds' => 'Impossibile cambiare l\'account dell\'utente perché questo causerebbe il superamento dello spazio su disco consentito.',
    'subdomains__creation_in_dns_slave' => "Il server di nomi di Plesk agisce da server di nomi secondario per questo dominio. Per la corretta risoluzione del tuo sottodominio, assicurati che il file di zona sul server DNS primario contenga il registro %1.",
    'sys_user__attributes_not_changed' => "\nI seguenti attributi di sistema non sono stati modificati: %1",
    'sys_user__no_access_without_password' => "Non avete impostato una password. L'utente di sistema verrà creato ma non potrà effettuare il login nel sistema, sino a che non gli verrà assegnata una password. Volete procedere comunque?",
    'sys_user__no_hard_quota' => "non supportato",
    'sysuser__zero_quota_is_unlimited' => "0 senza limiti",
    'template__num_excl_ips' => "Assegna indirizzi IP dedicati al cliente.",
    'template__sel_sh_ips' => "Indirizzi IP condivisi selezionati",
    'template__av_sh_ips' => "Indirizzi IP condivisi disponibili",
    'template__up_to_excl_ip' => "Fino a %1 indirizzi IP",
    'templates__all_clients' => "Tutti i clienti",
    'templates__cl_domain_templates' => "Template per %1",
    'templates__cl_templates' => "Modelli di cliente",
    'time__invalid_ip' => "L'indirizzo IP il nome del dominio non sono validi.",
    '__please_select_country' => 'Prego, seleziona la tua nazione',
    'time__unable_set_time' => "Impossibile gestire la data di sistema: %1",
    'time__sinchronization_setup_error' => 'Impossibile impostare la sincronizzazione dell\'orario: timemng non riuscito: %1',
    'time__sinchronization_disable_error' => 'Impossibile disattivare la sincronizzazione dell\'orario: timemng non riuscito: %1',
    'tmpl__create' => "Crea template",
    'tmpl__edit__' => 'Modello %1',
    'tmpl__logrotation_warn' => "Le azioni di rotazione log impostate in questo template verranno eseguite soltanto in caso di creazione di un hosting fisico.",
    'tmpl__name' => "Nome Template",
    'tmpl__dom_exist' => "Esiste già un modello di dominio con questo nome nel pool di modelli dell'amministratore o del cliente.",
    'tmpl__name_invalid' => "Il Nome template non è valido o è vuoto.",
    'tmpl__use_next_ip_addr' => "Verra' utilizzato il prossimo indirizzo IP libero disponibile.",
    'tmpl_name_already_exists' => "Un modello dal nome '%1' esiste già.",

    'vh_based__no_free_ip_for_vh' => "Non ci sono più indirizzi IP disponibili per l'hosting basato su IP. Per favore, aggiungere un indirizzo IP.",

    'wu__at_domains_text' => "Consenti il formato di accesso webuser@%1",
    'wu__unable_create' => "Impossibile creare l'utente web: %1",
    'wu_edit__disk_quota' => "Quota disco",
    'wu_edit__invalid_pass' => "La Password non è valida.",
    'wu_edit__invalid_quota' => "Il valore della quota disco specificata non è valida. Specificare un valore intero positivo.",
    'wu_edit__invalid_quota_value' => "La quota dello spazio disco indicata è minore di quella attualmente usata (%1MB). Alcune funzionalità potrebbero non essere più disponibili. Sei sicuro di voler continuare?",
    'wu_edit__not_create_pass' => "Proseguendo in questa azione non verrà creata una password per l'utente web. Senza password l'utente non potrà collegarsi.",
    'wu_edit__unable_update' => "Impossibile aggiornare le proprietà dell'utente web: %1",

    'dns__tabs_general' => 'Impostazioni zona',
    'dns__tabs_zone_settings' => 'Record SOA',
    'soa__seconds' => 'secondi',
    'soa__minutes' => 'minuti',
    'soa__hours' => 'ore',
    'soa__days' => 'giorni',

    'DomainSubdirectory' => 'Sottodirectory di destinazione',

    'filemanager__select_codepage' => 'Seleziona la tabella codici:',

    'bt_server_app_add' => 'Aggiungi applicazione del server',
    'packages_list' => 'Applicazioni server',

    'bt_packages_management' => 'Gestione pacchetti',
    'pb__packages_management' => 'Gestione applicazioni',
    'bt_package_new' => 'Aggiungi applicazione',
    '__packages' => 'Applicazioni server',

    'dom_ctrl__mysql_dbase_space' => 'Totale quota database MariaDB/MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Totale quota database MS SQL',

    'dns_add__enter_ixfr_path' => 'Inserisci percorso IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Il record SPF TXT esiste già. Può esistere un solo record SPF. Per aggiungere un record, elimina prima quello esistente.',

    'component_name__network' => 'Rete',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Imposta tema',
    'bt_set_skin' => 'Imposta tema',
    'firewall__rule_already_exists' => 'La regola con nome "%1" esiste già',
    'firewall__rule_readonly' => 'La regola "%1" è a sola lettura',
    'pb__firewall' => 'Firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Protezione antivirus',
    'antivirus__antivirus_direction_off' => 'Disattivato',
    'antivirus__antivirus_direction_any' => 'Email in ingresso e in uscita',
    'antivirus__antivirus_direction_from' => 'Email in uscita',
    'antivirus__antivirus_direction_to' => 'Email in ingresso',
    'antivirus__unable_to_update_settings' => 'Impossibile cambiare le impostazioni dell\'antivirus: %1',




    '__normal' => 'Normale',
    '__low' => 'Basso',
    '__high' => 'Alto',

    'mail__antivirus' => "Antivirus interno del mailserver",
    'mail__use_internal_antivirus' => 'Utilizza l\'antivirus interno',

    'sa__tabs_blacklist' => 'Lista Nera',

    '__mysql_databases' => 'Database di MariaDB/MySQL',

    'cl_perm__mysql_dbase_space' => 'Totale quota database MariaDB/MySQL',
    'cl_perm__mssql_dbase_space' => 'Totale quota database MS SQL',
    'cl_perm__max_mssql_db' => 'Numero massimo di database Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Quota per tutte le caselle postali',

    'i_i_cl_on' => 'L\'account cliente è attivo.',
    'i_i_cl_off_by_admin' => 'L\'account cliente è sospeso dall\'amministratore.',

    'sa_exists_tn' => 'La rete è già presente nella lista.',

    'defaultcomponents__not_activated' => 'non attivato',

    'bt_traffic_at_domains' => 'Traffico',

    '__awstats_perl_warning' => 'Se Perl non è installato, AWStats non consente agli utenti di controllare le statistiche degli anni precedenti.',

    'class_client__mysql_dbase_space' => 'Il valore supera il limite del cliente.',
    'class_client__mssql_dbase_space' => 'Il valore supera il limite del cliente.',
    'class_client__max_mssql_db' => 'Il valore supera il limite del cliente.',

    'dns__remove_transfer_restrictions_list_items' => 'I network seguenti saranno eliminati dall\'elenco dei controlli degli accessi:',

    'bt_up' => "Su",
    'bt_down' => "Giù",

    'bt_install_selected' => 'Installa selezionati', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Il dominio risolve ad un altro indirizzo IP: (%1). Correggi le impostazioni DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Il server di posta attualmente in uso non supporta le mailbox ed i gruppi di mail attivi contemporaneamente. Premi OK per attivare la mailbox disattivando i gruppi di mail. Premi Annulla per lasciare le cose come stanno.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Il server di posta attualmente in uso non supporta mailbox né gruppi di posta attivati contemporaneamente. Premere OK per attivare i gruppi di posta, pur disattivando la mailbox. Premere Annullare per non realizzare nessuna azione.',

    'mysql_dbase_space_limit' => 'Limite spazio database MariaDB/MySQL',
    'mysql_dbase_usage' => 'Utilizzo spazio database MariaDB/MySQL',
    'mssql_dbase_space_limit' => 'Limite spazio database Microsoft SQL Server',
    'mssql_dbase_usage' => 'Utilizzo spazio database Microsoft SQL Server',

    '__statistics' => "Statistiche", //indirect

    'dns__soa_minimum_value_is_big' => 'L\'impostazione del valore del TTL minimo superiore a 3 ore puo\' rendere i tuoi domini inaccessibili per alcuni degli amministratori di dominio. E\' raccomandato impostare tale valore solo se il restrar dei tuoi nomi a dominio lo richiede espressamente.',

    'virusfilter__interface_not_available' => 'Non sono disponibili filtri antivirus.',
    'virusfilter__none_virus_filter' => 'Nessuno',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'disattivato',
    'virusfilter__status_any' => 'posta in arrivo ed in uscita',
    'virusfilter__status_outgoing' => 'solo la posta in uscita',
    'virusfilter__status_incoming' => 'solo la posta in arrivo',

    'visibility__root_override_parse_error' => 'Si è verificato un errore di sintassi nel file %1 alla linea %2.',

    'sb__not_support_publishing_api' => "Il componente non supporta la pubblicazione automatica",

    'component_name__cphosting' => "Hosting Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'L\'impostazione della quota delle mailbox non è supportata dal server mail corrente.',
    '__unable_get_total_mboxes_quota' => 'L\'impostazione della quota delle mailbox non è supportata dal server mail corrente.',

    'install_prefix__parent_not_exists' => "La directory superiore non esiste.",

    'bt_change_version' => 'Cambia versione',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Selezionare Tutti",
    '__uncheck_all' => "Deselezionare Tutto",

    'dns__editing_domain_controller_zone' => "La modifica dei record della zona DNS per il controller del dominio può causare dei problemi nel funzionamento del dominio",

    'pb__interface_management' => "Gestione dell'interfaccia",
    'interface_management__tabs_skins' => "Skin",
    'interface_management__tabs_interface_templates' => "Modelli interfaccia",
    'interface_management__tabs_locales' => "Impostazioni internazionali",
    'locales_list__title' => "Pacchetti lingua",
    'locales_list__legend' => "Lingue disponibili",
    'locales_list__active_title' => "A",
    'locales_list__locale_title' => "Pacchetto lingua",
    'locales_list__lang_title' => "Lingua",
    'locales_list__country_title' => "Paese",
    'locales_list__used_title' => "Usato",

    'backup__suspend_warning_during_backup' => "Il dominio non sarà disponibile durante la procedura del backup",
    'backup__suspend_warning_during_restore' => "Il dominio non sarà disponibile durante la procedura del ripristino",
    'backup__suspend_domain' => "Sospendere Dominio",

    'locales_list__mls_limit' => "La corrente licenza di Plesk consente l'utilizzo di %2 lingue. Al momento, hai %1 lingue impostate quali disponibili agli utenti, il che supera il numero fornito con la licenza. Seleziona %2 lingue da usare e rendi il resto non disponibili agli utenti cliccando sulle relative icone nella colonna 'S'.",

    'bt_change_owner' => 'Assegnare Nuovo Proprietario',
    'chown__limit_name' => 'Nome risorsa',
    'chown__error_limits' => "Impossibile continuare il trasferimento dell'abbonamento: l'abbonamento richiede più risorse di quelle che il provider del nuovo proprietario può fornire.",
    'chown__error_empty_ip_pool' => "Impossibile continuare il trasferimento dell'abbonamento: Il pool IP del provider del nuovo proprietario è vuoto. Accertati che il provider abbia almeno un indirizzo ip nel pool.",

    'backup__backup_time' => 'Ora backup',
    'backup__backup_time_hour' => 'ore',
    'backup__backup_time_minute' => 'minuti',
    'backup__every' => 'ogni',
    'backup__day_of_month' => 'giorno del mese',

    'subdomain__select_hst_type' => 'Seleziona il tipo di hosting per il sottodominio',
    'hst_sel__subdom_subfolder_hst' => 'Sottodominio nella sottocartella',
    'subdomain__www_root_folder_not_exists' => 'La home directory dle sito %1 non esiste',
    '__site_home_dir' => 'Home directory del sito',
    'subdomain__aspnet_disabled_domain' => 'disattivato dal dominio',

    'domains__remove_description' => 'Tutti i dati sul dominio, inclusi i contenuti e le impostazioni dei domini e dei relativi sottodomini, i dati delle applicazioni web, i contenuti delle caselle di posta, la posta elettronica, le impostazioni dell\'antivirus e dei filtri antispam, i file di log, i dati del backup del dominio ed i certificati SSL/TLS saranno eliminati. Se non hai un file di backup sulla tua macchina locale, tutti i dati andranno irrimediabilmente persi.',
    'subdomains__remove_description' => 'Tutti i dati del sottodominio, inclusi il suo contenuto e le sue impostazioni, i dati delle applicazioni web e i file di registro saranno eliminati. Se non hai un file di backup sulla tua macchina locale, tutti i dati andranno irrimediabilmente persi.',

    'mail__tabs_spam_filtering' => 'Filtraggio dello spam',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Usa le impostazioni server-wide di default (Fai la scansione)',
    'antivirus__use_server_settings_no_scan' => 'Usa le impostazioni server-wide di default (Non fare la scansione)',
    'antivirus__check_for_viruses' => 'Fai la scansione antivirus',
    'antivirus__dont_check_for_viruses' => 'Non fare la scansione antivirus',
    'antivirus__incoming_mail' => 'Posta in entrata',
    'antivirus__outgoing_mail' => 'Posta in uscita',

    'domain_alias__CNAME_dns_record_exists' => 'Esiste già un record CNAME nel DNS con lo stesso nome',
    'domain_alias__A_dns_record_exists' => 'Esiste già un record A nel DNS con lo stesso nome',
    'domain_alias__bad_prefix' => 'Prefisso errato per l\'alias di dominio',
    'domain_alias__domain_doesnt_exist' => "Il dominio non esiste",

    'dns__zone_ttl_message_info' => 'Se il valore TTL non è specificato, per questo registro DNS verrà utilizzato il valore TTL (%1) nel modello registri SOA.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWstats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Un file con nome index.html sarà creato per essere poi reindirizzato all'applicazione web selezionata. Se un file con nome index.html esiste già, sarà salvato come index.html.old e sarà sostituito con quello nuovo. Premere OK per confermare.",

    'bt_ftp_ctrl' => "Account FTP aggiuntivi",
    'ftp_users_no_permission' => "Non hai il permesso di gestire gli account FTP per questo dominio",
    'ftp_users_limit_reached' => "È stato raggiunto il numero massimo di account FTP per questo dominio",
    'pb__ftp_ctrl' => "Gestione FTP",
    'class_client__max_subftp_users' => "Account FTP aggiuntivi",

    '__client_form_settings' => "Impostazioni del cliente",
    '__sbnet_client_keep_sbnet' => "Conserva il corrispondente account utente in Presence Builder",
    '__sbnet_cant_add_more_sites' => "È stato raggiunto il limite di siti che possono usare Presence Builder per questo cliente",
    '__sbnet_legend_text' => "Integrazione di Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Crea un account utente corrispondente in Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Stai cercando di rimuovere l'account utente di Web Presence Builder associato a questo cliente. Di conseguenza, dal sistema di Presence Builder saranno eliminati tutti i siti web dell'utente e tutte le impostazioni importanti, eliminando la capacità per modificare i siti web esistenti tramite Presence Builder, anche se attiverai l'opzione più tardi. Se creerai un account utente di Presence Builder più tardi, dovrai creare e pubblicare tutti i tuoi siti web da capo. Vuoi disattivare la creazione e la pubblicazione di siti web con Presence Builder?",
    'sb__build_site_with_subdomains' => "Crea i sottodomini per il Blog e la Fotogallery",
    '__sbnet_client_dont_have_sbuser' => "Impossibile creare e pubblicare un sito usando Presence Builder: Utente di Presence Builder inesistente",

    '__component_disabled' => "Componente disattivato",

    'subdomains__physical_path_not_exist' => "Vi sono sottodomini collegati a cartelle fisiche non esistenti",

    'dnsserver_bind_to_msdns_switching_warning' => "Attenzione: Sarano trasferiti solo i primi 254 indirizzi IP delle sottoreti con le mask /8 e /16 presenti nell'elenco dei controlli degli accessi. Saranno trasferiti come indirizzi IP separati. Vuoi continuare?",

    '__sbnet_net_framework_required_for_site' => "I siti di Presence Builder potrebbero richiedere il supporto ASP.NET 2.0 sul tuo dominio.\nSi consiglia di abilitare il supporto ASP.NET 2.0 se si utilizza Presence Builder.",

    'subdomain_auto_create_dir' => "Crea una directory fisica per il sottodominio",

    'sa_trainer__unable_to_get_messages_list' => "Impossibile reperire l'elenco dei messaggi nella mailbox: %1",
    'sa_trainer__pass_doesnt_exist' => "Manca la password per questo account di posta",

    '__sitebuilder_error' => "Si è verificato un errore durante il tentativo di connessione a Presence Builder. Contatta il tuo service provider per richiedere assistenza.",
    'wsb_error_user_not_exist' => "Questo account utente di Presence Builder è inesistente.",
    'wsb_error_site_already_exist' => "Questo sito esiste già in Presence Builder.",
    'wsb_error_site_limit_reached' => "È stato raggiunto il limite di siti in Presence Builder.",
    'wsb_error_internal_error' => "Si è verificato un errore interno in Presence Builder. Contatta il tuo service provider per richiedere assistenza.",
    'wsb_error_user_already_exist' => "Esiste già un utente con questo nome in Presence Builder.",
    'sb_error_user_not_exist' => "L'utente di Presence Builder è inesistente.",
    'wsb_error_object_not_found' => "Presence Builder non è riuscito a trovare la voce dell'host occorrente.",

    'mg_no_mail_groups' => "Non ci sono gruppi di posta",

    'drweb__drweb_incoming' => 'Controllo antivirus della posta in ingresso',
    'drweb__drweb_outgoing' => 'Controllo antivirus della posta in uscita',
    'drweb__disable_reason_serv' => 'Il server di posta non supporta le impostazioni del filtro antivirus a livello di mailbox',

    'vz_sitebuilder3_client_cant_be_created' => "Impossibile creare l'account cliente: Non è installata la versione 3.1 di SiteBuilder o una versione superiore",

    // new limits

    'class_client__max_odbc' => "Connessioni ODBC",
    'cl_perm__max_odbc' => "numero massimo di connessioni ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'A',
    'domain_alias__list_name' => 'Nome dell\'alias di dominio',
    'domain_alias__list_ascii_name' => 'In formato ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Gestione dell\'interfaccia',
    'pb__interface_templates' => 'Gestione dell\'interfaccia',
    'pb__interface_clients' => 'Clienti che usano %1',

    // service management
    'bt_service_showall' => "Mostra tutto",
    'bt_service_hideall' => "Nascondi Tutto",
    'bt_service_start' => "Avvia",
    'bt_service_stop' => "Arresta",
    'bt_service_restart' => "Riavvia",
    'bt_service_disable' => "Disattiva",
    'bt_service_manual' => "Manuale",
    'bt_service_auto' => "Auto",
    'service_startup_auto' => 'Automatico',
    'service_startup_manual' => 'Manuale',
    'service_startup_disabled' => 'Disattivato',
    'service_action_ok' => "L'operazione con servizio di %1 e' stata complatata con successo",
    'service_action_failed_disabled_service' => "Impossibile completare l'operaizone con il servizio %1 perchè è disattivato",
    'service_action_failed_error' => "Non e' possibile completare l'operazione: %1",
    'service_group_action_ok' => "L'operazione con i seguenti servizi e' stata completata con successo:\n%1",
    'service_group_action_disabled' => "Impossibile completare l'operazione con i servizi seguenti perchè sono disattivati:\n %1",
    'service_group_action_failed' => "Non e' possibile completare l'operazione con i seguenti servizi:\n%1.\nPer ricevere informazioni dettagliate in merito agli errore, eseguire l'operazione con ciascun servizio separatamente.",

    // php 4vs5
    'bt_php' => "Impostazioni PHP",

    'bt_insert' => "Inserisci",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Si è verificato un errore nel database di Presence Builder. Contatta il tuo service provider per richiedere assistenza.",
    'wsb_error_sitebuilder_access_denied_error' => "Impossibile accedere al file: Presence Builder non dispone dei diritti di accesso per il file o la cartella richiesti. Contatta il tuo service provider per richiedere assistenza.",
    'wsb_error_sitebuilder_connection_failed' => "Impossibile connettere a Presence Builder perché si è persa la connessione. Contatta il tuo service provider per richiedere assistenza.",
    'wsb_error_critical_during_operation' => "Si è verificato un errore critico di Presence Builder:%1",
    'wsb_error_license_during_operation' => "Si è verificato un errore con la licenza di Presence Builder:%1",
    'wsb_error_during_operation' => "Si è verificato un errore di Presence Builder:%1",
    'wsb_error_license_error' => "È stato rilevato un limite nella licenza di Presence Builder.",

    // Other
    '__confrim_service_stop' => "Avviso! Arrestando il servizio %1, Plesk potrebbe smettere di funzionare. Sei sicuro di voler arrestare il servizio %1?",
    'index_redirect_help_text' => 'Ora sarete automaticamente reindirizzati al sito web richiesto. Se il vostro browser non supporta il reindirizzamento, cliccare %1 qui %2',
    'bt_default_settings' => "Ripristina le impostazioni di default",
    'logfiles__remove_failed' => "Non e' possibile cancellare il file %1: il file e' bloccato da un'altra applicazione. Prova di nuovo piu' tardi",
    'subdomain__invalid_homedirectory' => "La directory principale specificata del sottodominio non è valida.",
    'scheduler_item__empty_filename' => "Specifica il file eseguibile da eseguire",
    'subdomains__overlapped_domain_exists' => 'Un sottodominio e\' sovrapposto dalla zona DNS del dominio %1',
    'subdomains__overlapped_domain_alias_exists' => 'Il sottodominio è sovrapposto dalla zona DNS dell\'alias di dominio %1',
    'services_action_none_selected' => 'Non e\' possibile completare l\'operazione: seleziona i servizi richiesti',
    'cl_perm__max_subftp_users' => "numero massimo di account FTP aggiuntivi",
    'login_up__access_denied_no_cp_access' => 'Accesso negato. Non hai permessi per accedere a Plesk.',
    'drweb__disable_reason_admin' => "Le impostazioni del filtro antivirus al livello della casella postale non sono consentite dalle norme del server.",

    '__use_default' => 'Usare predefinito',

    'webalizer_hidden_referrer__already_exist' => 'Questo elemento esiste già.',
    'webalizer_group_referrer__already_exist' => 'Un gruppo di referenti con questo nome esiste già.',

    'pb__dashboard' => 'Home',

    'server_interface__page_title' => 'Impostazioni dell\'interfaccia del server',
    'server_interface__tabs_locales' => 'Impostazioni internazionali',
    'server_interface__tabs_skins' => 'Skin',
    'server_interface__tabs_interface_templates' => 'Modelli interfaccia',
    'bt_server_interface' => 'Preferenze dell\'interfaccia',
    'pb__server_interface' => 'Preferenze dell\'interfaccia',

    'bt_wizard_next' => 'Avanti >>',
    'bt_wizard_prev' => '<< Indietro',

    '__limit_exceeded_max_dom_server' => 'Non puoi ospitare più domini in questo server perché è stato raggiunto il limite di domini consentiti sul server dalla chiave di licenza. Contatta il tuo service provider per risolvere questo problema.',
    '__limit_exceeded_max_subdom_server' => 'Non puoi ospitare più sottodomini in questo server. Contatta il tuo service provider.',
    '__limit_exceeded_max_dom_aliases_server' => 'Non puoi configurare più alias di dominio su questo server. Contatta il tuo service provider.',
    '__limit_exceeded_max_wu_server' => 'Non puoi creare più utenti web perché è stato raggiunto il limite di utenti web consentiti sul server dalla chiave di licenza.Contatta il tuo service provider per risolvere questo problema.',
    '__limit_exceeded_max_mn_server' => 'Non puoi creare più account di posta perché è stato raggiunto il limite di account di posta consentiti sul server dalla chiave di licenza. Contatta il tuo service provider per risolvere questo problema.',

    '__limit_exceeded_max_cl_useradmin' => 'È stato superato il limite di account cliente definito dalla tua chiave di licenza (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'È stato raggiunto il limite del numero di domini definito dalla vostra chiave di licenza (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Avete raggiunto il limite sul numero di sottodomini definito dalla vostra chiave di licenza (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Avete raggiunto il limite sul numero di alias di dominio definito dalla vostra chiave di licenza (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Non hai piu\' spazio disco libero a disposizione.',
    '__limit_exceeded_max_wu_useradmin' => 'Hai raggiunto il limite del numero di account utente web definito dalla tua chiave di licenza (%2).',
    '__limit_exceeded_max_db_useradmin' => 'Hai raggiunto il limite del numero di database definito dalla tua chiave di licenza (%2).',
    '__limit_exceeded_max_box_useradmin' => 'Hai raggiunto il limite del numero di mailbox definito dalla tua chiave di licenza (%2).',
    '__limit_exceeded_max_mn_useradmin' => 'È stato superato il limite di account e-mail definito dalla tua chiave di licenza (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Hai raggiunto il limite del numero di mailing list definito dalla tua chiave di licenza (%2).',

    '__limit_exceeded_max_dom_userclient' => 'È stato raggiunto il limite sul numero di domini (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Avete raggiunto il limite sul numero di domini (%2) permesso dal vostro service provider',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Avete raggiunto il limite sul numero di alias di dominio (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Avete raggiunto il limite di utilizzo dello spazio su disco (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Avete raggiunto il limite sulla quantità dell\'utilizzo di larghezza di banda mensile (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Avete raggiunto il limite sul numero di utenti web (%2) permesso dal vostro service provider.',
    '__limit_exceeded_max_db_userclient' => 'Avete raggiunto il limite sul numero di database (%2)',
    '__limit_exceeded_max_box_userclient' => 'Avete raggiunto il limite sul numero di caselle postali (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Avete raggiunto il limite sul numero di caselle postali (%2)',
    '__limit_exceeded_expiration_userclient' => 'Il vostro account è scaduto il %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Avete raggiunto il limite sul numero di domini (%2) permesso dal vostro service provider',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Avete raggiunto il limite sul numero di alias di dominio (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Avete raggiunto il limite di utilizzo dello spazio su disco (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Avete raggiunto il limite sulla quantità di utilizzo di larghezza di banda mensile (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Avete raggiunto il limite sul numero di account utente web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Avete raggiunto il limite sul numero di database (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Avete raggiunto il limite sul numero di caselle postali (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Avete raggiunto il limite sul numero di caselle postali (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Il vostro account è scaduto il %2',

    'sapp_error_validation_not_found' => 'Impossibile validare l\'applicazione web perché uno dei file richiesti (%1) non è stato trovato. Contattare il rappresentante del supporto tecnico per ottenere aiuto.',
    'sapp_error_validation_spec_failed' => 'L\'applicazione web caricata non è conforme alle specificazioni di AppPacks: %1.',
    'sapp_error_validation_register' => 'Impossibile registrare l\'applicazione web che si trova nella directory "%1": %2 È necessario rimuovere l\'applicazione web dal server poichè non funzionerà correttamente.',

    'sapp__install_failed' => 'Installazione dell\'applicazione web non riuscita: %1',
    'sapp__install_res_failed' => 'Creazione della risorsa richiesta non riuscita.',

    'server_preferences__subdomains_blog_and_photo' => 'Creare sottodomini di Blog e Galleria Fotografica in modo predefinito.',
    'plesk_key__blog_and_photo' => 'Possibilità di gestire lo stato predefinito dei checkbox Crea blog e fotogallery dei sottodomini',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Impossibile cambiare il tipo d\'indirizzo IP in dedicato perché è assegnato a più di un utente.',

    // 8.1.1

    '__write_modify_warning' => 'Selezionando i permessi di scrittura/modifica aggiuntivi, consentirà a certe applicazioni web di funzionare correttamente, ma aumenterà notevolmente i rischi per la sicurezza',
    '__write_modify_subdomain_warning' => 'Selezionando i permessi di scrittura/modifica aggiuntivi, consentirà a certe applicazioni web di funzionare correttamente, ma aumenterà notevolmente i rischi per la sicurezza',

    'phosting__php_incorrect_version_used' => "Sono stati rilevati problemi nella versione di PHP. Per risolvere questi problemi, seleziona il checkbox con la versione di PHP richiesta qui sotto e clicca OK. Per disattivare PHP su questo dominio clicca OK senza selezionare la versione di PHP.",
    'fp__mail_preferences' => 'Impostazioni di posta',

    'mail__invalid_white_pattern' => 'Il valore specificato non è valido. Usa i seguenti formati: mail@esempio.com per indirizzi e-mail, esempio.com per domini.',
    'mail__invalid_black_pattern' => 'Il valore specificato non è valido. Usa il seguente formato: mail@esempio.com per indirizzi e-mail, esempio.com per domini.',

    'resp_edit__reply_as_html' => 'Invia come HTML',
    'exception__path_very_long' => "Percorso troppo lungo. Accertati che ci siano meno di %1 caratteri nel percorso.",

    // 8.2


    //SAPP
    'sapp_on' => 'Attivato',
    'sapp_off' => 'Disattivato',
    'sapp_directive_aspect' => 'Richiesta',
    'sapp_databases_num' => 'Database',
    'sapp_db_required' => 'Richiesta',
    'sapp_Required' => 'Richiesta',
    'sapp_Variant' => 'Variante',
    'sapp_db_id' => 'Id del database',
    'sapp_db_id_type' => 'DB (id: %1) tipo',
    'sapp_db_id_min_version' => 'DB (id: %1) versione minima',
    'sapp_db_id_table_prefix' => 'DB (id: %1) prefisso tabella',
    'sapp_Default' => 'Valore predefinito',
    'sapp_apache_mod_req' => 'Modulo Apache',
    'sapp_dbtype_not_installed' => 'non installato',
    'sapp_apache_mod_not_installed' => 'non installato',
    'sapp_error_invalid_type' => 'L\'applicazione "%1" non supporta l\'azione richiesta.',
    'sapp_error_unknown_app_type' => 'Tipo di applicazione non supportato: %1.',
    'sapp__ssl_text' => 'Installare l\'applicazione nell\'host virtuale "http://" o "https://"?',
    'sapp__app_to_upgrade' => 'Applicazioni da aggiornare',
    'sapp__upgrade_apps_title' => 'Aggiornare applicazioni',
    'sapp__upgrade_to_ver' => 'Aggiornare alla versione',
    'sapp__choose_pkg_ver' => 'Seleziona un pacchetto...',
    'sapp__pkg_cant_upgrade_pkg' => 'Il pacchetto "%1" non può essere usato per aggiornare l\'applicazione web "%2".',
    'sapp__app_ugrade_error' => 'Impossibile aggiornare l\'applicazione: %1. Prego contatta il tuo amministratore di sistema.',
    'sapp__no_suitable_db_found' => 'Nessun database appropriato trovato.',
    'sapp__upgrade_success' =>  'L\'upgrade dell\'applicazione è stata completata con esito positivo.',
    'sapp__pkg_info_changelog' => 'Cronologia delle modifiche',
    'sapp_requirement_legend' => 'Caratteristiche di hosting richieste dall\'applicazione',

    // other
    'bt_apply' => 'Applica',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Per creare un alias di posta, la mailbox deve essere attivatra su questo account di posta. Attivare la mailbox?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Disattivando la mailbox eliminerà gli alias di posta poichè termineranno di funzionare. Disattivare la mailbox?',
    'antivirus__disable_reason_install' => 'Non puoi gestire l\'antivirus perché non è installato.',
    'antivirus__disable_reason_key' => 'Non puoi gestire l\'antivirus perché non è stato attivato da una corretta chiave di licenza.',
    'antivirus__disable_reason_deny_personal_settings' => 'Non puoi gestire l\'antivirus perché le norme sul server proibisce le impostazioni individuali per l\'antivirus.',
    'change_foreign_user_password' => 'Cambiare Password',
    'change_foreign_user_password_hint' => "L'utente non appartiene a questa applicazione. Clicca sul link per accedere a un'altra aplicazione e cambia lì la password dell'utente. Per farlo, sono necessari i diritti dell'applicazione.",
    'cf_url_text' => 'URL JDBC',
    'cf_sendStringParametersAsUnicode_text' => 'Formato stringa',
    'lang_unknown' => 'Lingua sconosciuta',
    'pb__cl_ed' => 'Dettagli del cliente',
    'pb__actionlog' => 'Registro azioni',
    'pb__cl_limits' => 'Limiti del cliente',
    'pb__edit' => 'Modifica',
    'pb__subdom_edit' => 'Impostazioni di hosting',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Fare il backup del contenuto delle caselle di posta',

    'maillist_import_result' => "\nQuantità totale di indirizzi e-mail nel file:%1\nquantità di indirizzi e-mail importati: %2\nquantità di indirizzi e-mail già esistenti: %3\nquantità di indirizzi e-mail duplicati nel file specificato: %4\nquantità di indirizzi e-mail non validi nel file: %5",
    'maillist_import_error' => 'Impossibile importare la lista di indirizzi e-mail',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Il file che avete selezionato è vuoto o non è un documento HTML valido nella codifica selezionata. Seleziona la codificazione giusta o semplicemente aggiungi del contenuto al file.",

    'dom_pref__external_mail_srv' => "Reindirizza a server di posta esterno con l'indirizzo IP",
    'mn_edit__store_messages' => 'Casella postale',

    // aps

    'sapp__before_upgrade_notice' => 'Si raccomanda di realizzare il backup dell\'applicazione e dei dati dell\'utente prima d\'iniziare la procedura dell\'upgrade.',
    'sapp__application_properties' => 'Proprietà dell\'applicazione',
    'sapp__application_root_descr' => 'La pagina principale dell\'applicazione',

    'sapp__aps_license_invalid_id' => 'La chiave di licenza ha un ID non valido: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'La licenza con il numero di chiave %1 esiste già nel database.',
    'sapp__aps_lic_del_used' => 'Impossibile eliminare la chiave di licenza. È usata da una delle applicazioni installate.',
    'sapp__aps_lic_del_unknown' => 'Impossibile eliminare la chiave di licenza: %1',
    'sapp__aps_cappi_duplicate' => "Questa applicazione è già nel pool di applicazioni di questo cliente",
    'sapp__appi_not_shared_no_install' => "Non è presente alcuna applicazione di questo tipo nel pool di applicazioni del cliente. Se vuoi installare questa applicazione su un sito, devi prima aggiungerla al pool di applicazioni del cliente.",
    'sapp__appi_shared_not_client' => "Non è presente alcuna applicazione di questo tipo nel pool di applicazioni del cliente. Se vuoi aggiornare l'applicazione alla versione specificata, devi prima aggiungere la versione dell'applicazione al pool di applicazioni del cliente.",
    'sapp__apply_license_script_not_found' => 'Impossibile trovare lo scrip "apply-license" per questa applicazione web.',
    'sapp__unable_to_activate_key' => 'Errore nel tentativo di attivazione della chiave di licenza: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Ci sono applicazioni installate che richiedono la presenza di questa applicazione web nel sistema.',
    'sapp__unable_to_delete_ai_in_pool' => 'Questa applicazione è ancora nel pool del cliente. Se vuoi rimuovere questa applicazione, devi prima eliminarla dai pool di applicazioni di tutti i clienti o renderla gratuita.',
    'sapp__unable_to_delete_app_template' => 'Impossibile eliminare l\'applicazione #%1: %2',
    'sapp__limit_exceeded_client' => 'È stato raggiunto il limite del numero di volte che potete installare questa applicazione web (%2).',


    // atis module

    '_week_on' => 'settimana su',
    '__week_first' => 'primo',
    '__week_second' => 'seconda',
    '__week_third' => 'terza',
    '__week_fourth' => 'quarta',
    '__week_last' => 'Ultimo',
    '__not_started' => 'In attesa',
    '__started' => 'In funzionamento',
    '__cancel_pending' => 'Annullamento in corso',
    '__canceled' => 'Annullato',
    '__error' => 'Errore',
    '__done' => 'Fatto',

    '__php_cgi_handler' => 'Applicazione CGI',
    '__php_isapi_handler' => 'Estensione ISAPI',
    '__php_fastcgi_handler' => 'Applicazione FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'eseguire come',

    'cf_dbfolder_text' => 'Cartella del Database',
    'cf_isnewdb_text' => 'Creare Database',
    'cf_isnewdb_title' => 'Scegli la casella di controllo se il database deve essere creato',

    'pb__site_apps_upgrade' => 'Aggiornamento di applicazioni web',

    'detach' => 'Disconnetti',
    'preferences' => "Cambiare Password",

    'toolsbar__switch_user?' => "Siete sicuri di voler accedere sotto un altro account utente?",
    '__aps_left' => 'Installazioni rimaste',
    'aps__license_key' => 'Chiave di licenza',
    'aps__download_code' => 'Scaricamento della chiave di licenza e codice di attivazione',
    'aps__license_key_hint' => 'Recupero dal server di licenze utilizzando il codice di attivazione',
    'aps__database_not_available' => 'non disponibile, verificare i limiti del dominio o del cliente',
    'aps__yes' => 'sì',
    'aps__no' => 'no',
    '__click_to_enlarge' => 'Cliccare per ingrandire',
    'site_apps__back_to_list' => 'Ritornare alla lista',
    'sapp__pkg_info_installation_requirements' => 'Requisiti per l\'installazione',
    '__close_window' => 'Chiudi',

    //SAPP END

    'skin_info__already_default' => 'Questo tema grafico è già impostato come predefinito.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Antivirus Plesk Premium',
    'drweb:properties_page_title' => 'Impostazioni antivirus Plesk Premium per %1',
    'drweb:properties_legend' => 'Impostazioni',
    'drweb:status' => 'Verifica la presenta di virus nella posta',

    // sb integration
    'sitebuilder_wizard' => 'Procedura guidata di Presence Builder',
    'dom_site_builder' => 'Fai clic per aprire la procedura guidata di Presence Builder.',
    'sb_plesk_admin_url' => 'URL del server Presence Builder. Accertati che questo indirizzo venga correttamente risolto in DNS',
    'sb_plesk_admin_login' => 'Nome utente per l\'accesso all\'amministratore del server per Presence Builder',
    'sb_plesk_admin_password' => 'Password amministratore',
    'sb_sitebuilder_preferences' => 'Credenziali dell\'amministratore di Presence Builder',
    'sb__server' => 'Preferenze dell\'amministratore di sistema di Presence Builder',
    'sb__sitebuilder_support' => 'Supporto di Presence Builder',
    'sb_keep_sb_user' => 'Conserva il corrispondente account utente in Presence Builder',
    'sb_create_sb_user' => 'Crea un account utente corrispondente in Presence Builder',
    'sb__build_site_using_sitebuilder' => "Crea un sito web usando Presence Builder",
    'sb_no_current_sb_server_set' => 'La connessione a Presence Builder non è ancora configurata: devi aggiungere un registro A nel modello di zona DNS perché punti verso il server di Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Impossibile ripristinare l'informazione dal sistema di Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Impossibile connettere a Presence Builder: nome utente o password non validi.",
    'sb_init_sb_manager' => "Inizializzazione gestore Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Connessione non riuscita al sistema di Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Questo cliente non ha un account utente in Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder non è configurato.",
    'sb_err_you_dont_have_sbaccount' => "Autorizzazione non riuscita su Presence Builder.",
    'sb_error_critical_during_operation' => "Si è verificato un errore in Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Il supporto di autenticazione unica non è attivato in Plesk.",

    'warning__super_zone_exist' => "È stata creata la zona %1. Nonostante, questo nome di zona è una sottozona per un'altra zona %2 già presente, appartenente ad un altro utente %3. Ciò è possibile, ma accertatevi di avere scelto l'utente corretto.",
    'error__super_zone_exist' => "Impossibile creare una zona DNS perché la sua superzona appartiene ad un altro utente.",

    'locales__files_not_exits' => 'Impossibile cambiare locale: i file di language pack dell\'interfaccia specificati non esistono nel sistema.',
    'locales__unavailable' => 'Impossibile modificare locale: il language pack specificato per l\'interfaccia non è disponibile.',

    // DB BU

    'pb__dbbackup_list' => 'File di backup del database',
    // server
    'dbbackup__server_backup_settings' => 'Backup',
    'dbbackup__network_temp_dir' => 'Directory di rete temporanea',
    'dbbackup__network_user' => 'Nome utente',
    'dbbackup__network_pass' => 'Password',
    // domain
    'dbbackup__add_database_legend' => 'Ripristinare il database in memoria di backup',
    'dbbackup__add_database_restore' => 'Ripristinare il database dal file di backup',
    'dbbackup__add_database_file' => 'File di backup del database',
    'dbbackup__add_database_user' => 'Nome utente predefinito',
    'dbbackup__add_database_pass' => 'Password utente predefinita',
    'dbbackup__add_database_pass2' => 'Conferma della password utente predefinita',

    'bt_dbbackup_now' => 'Esegui backup',

    'bt_repair' => 'Ripara',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Il caricamento dei dump del database del server SQL è proibito dal provider di hosting.',

    // APS categories

    'cf_invalid_password' => 'La password non può superare i 16 caratteri',
    'cf_invalid_description_length' => 'La descrizione non può superare i 256 simboli',
    'ip_addr__ip_used_by_external_mail_server' => 'L\'indirizzo IP %1 è già in uso da un server di posta esterno',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Nome utente o password dell\'account FTP non validi. Specifica le credenziali giuste dell\'utente FTP.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'È stato raggiunto il limite di modifiche del numero seriale. Non è possibile realizzare ulteriori modifiche nella zona DNS per oggi.',
    'dns__zone_apply_changes' => 'Le modifiche realizzate nei record DNS non sono ancora state salvate. Le modifiche realizzate sono evidenziate sotto. Cliccare su Aggiornare per applicare le modifiche nelle zone DNS o cliccare su Ritornare per abbandonare le modifiche.',
    'dns__update_dns_zone' => 'Cliccare per salvare le modifiche realizzate nei record DNS',
    'dns__revert_dns_zone' => 'Cliccare per annullare le modifiche realizzate nei record DNS',
    'bt_revert' => 'Ripristina',
    'dns__dns_zone_has_beed_updated' => 'Le modifiche realizzate nei record DNS sono state salvate.',
    'dns__dns_zone_has_beed_reverted' => 'Le modifiche realizzate nei record DNS sono state annullate.',
    'db__nondefault_server_not_allowed' => 'Non è permesso l\'uso del server database non predefinito.',

    'site_apps__non_removable' => 'Elementi che non possono attualemente essere rimossi',
    'site_apps__non_removable_items' => 'Le seguenti applicazioni web non possono essere rimosse:',

    'rpt_reseller_section_general' => 'Generale',
    'rpt_reseller_section_domains' => 'Domini',
    'rpt_reseller_section_clients' => 'Clienti',
    'statistics__cl_active_domains' => "Domini attivi",
    'rpt_reseller_cl_domains' => "Domini",
    'rpt_reseller_cl_subdomains' => "Sottodomini",
    'by__cl_domains' => "domini dei clienti",
    'dom_ctrl__cl_mboxes' => "Caselle postali",
    'rpt_reseller_cl_redirects' => "Inoltri",
    'rpt_reseller_cl_mail_groups' => "mail group",
    'rpt_reseller_cl_mail_resps' => "Risposte automatiche",
    'rpt_reseller_cl_mail_lists' => "Liste di posta",
    'rpt_reseller_cl_web_users' => "Utenti web",
    'rpt_reseller_cl_data_bases' => "Database",

    'statistics__active_clients' => 'Clienti con abbonamenti attivi',
    'statistics__clients_active_domains' => 'Domini attivi',
    'statistics__clients_doms' => 'Domini',
    'statistics__cl_doms' => 'Domini',
    '__clients_subdomains' => 'Sottodomini',
    '__clients_domains' => 'Domini',
    'dom_ctrl__clients_mboxes' => 'Caselle postali',
    'dom_ctrl__clients_redir' => 'Inoltri',
    'dom_ctrl__clients_mg' => 'mail group',
    'dom_ctrl__clients_resp' => 'Risposte automatiche',
    'dom_ctrl__clients_maillists' => 'Liste di posta',
    'dom_ctrl__clients_wu' => 'Utenti web',
    'dom_ctrl__clients_db' => 'Database',

    'dom_ctrl__cl_redir' => 'Inoltri', // to resolve!
    'dom_ctrl__cl_mg' => 'mail group', // to resolve!
    'dom_ctrl__cl_resp' => 'Risposte automatiche', // to resolve!
    'dom_ctrl__cl_maillists' => 'Liste di posta', // to resolve!
    'dom_ctrl__cl_wu' => 'Utenti web', // to resolve!
    'dom_ctrl__cl_db' => 'Database', // to resolve!

    'rpt_cl_section_clients' => 'Clienti',

    'rpt_admin_section_general' => 'Generale',
    'rpt_admin_section_resellers' => 'Rivenditori',
    'rpt_admin_section_clients' => 'Clienti',
    'rpt_admin_section_personal_clients' => 'Propri clienti',
    'rpt_admin_section_domains' => 'Domini',
    'rpt_admin_section_personal_domains' => 'Domini personali',

    'rpt_reseller_section_personal_domains' => 'Domini personali',

    // RESELLERS

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Consenti overselling",
    'limits__reseller_oversell_description' => "L'overselling consente al rivenditore di vendere più risorse di quelle che gli sono state assegnate in realtà. Se l'overselling è permesso, il rivenditore si basa sull'utilizzo di risorse attuale invece dell'assegnazione iniziale di risorse",
    'limits__overuse_block_text' => "Norme sul sovrautilizzo",
    'limits__overuse_block_true_text' => "Il sovrautilizzo non è consentito",
    'limits__reseller_overuse_block_true_description' => "Bloccare la sovrautilizzazione delle risorse. L'utilizzo attuale delle risorse non può superare l'assegnazione iniziale delle risorse",
    'limits__overuse_block_false_text' => "Sovrautilizzo consentito",
    'limits__reseller_overuse_block_false_description' => "Non bloccare la sovrautilizzazione delle risorse, permettere al rivenditore di usare più risorse di quante fornite inizialmente. L'attuale utilizzo delle risorse può superare l'assegnazione iniziale delle risorse",
    'limits__reseller_overuse_notify_text' => "Notificare il rivendotore riguardo il superamento dei limiti delle risorse",
    'reseller_perm__manage_sh_access_disabled' => "Il rivenditore non può consentire o proibire l'acceso shell",
    'reseller_perm__manage_sh_access_chrooted' => "Il rivenditore può permettere l'acesso solo a un ambiente di chroot.",
    'reseller_perm__manage_sh_access_any' => "Il rivenditore può permettere l'accesso a qualsiasi tipo di shell",
    'template__reseller_num_excl_ips' => "Assegna indirizzi IP dedicati al rivenditore",

    // Reseller's Home page
    'domains__reseller_info' => "%1 clienti, %2 domini, %3 di spazio su disco usato, %4 di dati trasferiti.",
    'domains__reseller_info_hiding_traffic' => "%1 clienti, %2 domini, %3 di spazio su disco usato.",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Tutte le applicazioni web sono ora ordinate per categorie, risultando così più facile da scegliere l'applicazione giusta da installare.",
    'feature__domainkeys__reseller' => "È possibile usare il meccanismo di autenticazione del mittente di posta di DKIM per ridurre la quantità di posta spam e phishing.",

    '__reseller_form' => "Formulario del rivenditore",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Rendere questo modello disponibile per altri utenti",
    'template__shared_description' => "Selezionare quest'opzione se desiderate che i vostri clienti siano in grado di usare questo modello.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "L'amministratore del dominio non può consentire né proibire l'accesso shell",
    'domain_perm__manage_sh_access_chrooted' => "L'amministratore del dominio può consentire l'accesso solo all'ambiente di chroot.",
    'domain_perm__manage_sh_access_any' => "L'amministratore del dominio può consentire l'accesso a qualsiasi tipo di shell",

    // APS Catalog
    'bt_add_to_vault' => "Aggiungere al Vault",
    'bt_hide_updates' => "Nascondere aggiornamenti disponibili",
    'bt_show_updates' => "Visualizzare aggiornamenti disponibili",

    '__site_apps__applications' => "Applicazioni",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Applicazioni selezionate da aggiungere al vault",
    'site_apps__application_selected' => "Selezionate",
    'site_apps__currently_in_vault' => "Esistono già altre versioni nel vault:",
    'site_apps__new_versions' => "Nuove versioni:",
    'site_apps__patches' => "Patch:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Numero di applicazioni pianificate da aggiungere al vault: %1",
    'site_apps__applications_downloading_now' => "Scaricamento in corso delle seguenti applicazioni: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Già nel vault",

    // Server > Action Log
    'bt_skin_edit' => "Modificare la Descrizione della Skin (tema grafico)",
    'limits__oversell_legend' => "Overselling",
    'limitsManager__limit_available_error' => "Impossibile assegnare la quantità richiesta di risorse (%%quantity%% %%limitName%%). Solo %%available%% %%limitName%% sono disponibili.",
    'limitsManager__limit_reserved_error' => "Impossibile impostare il limite richiesto sull'utilizzo delle risorse (%%quantity%% %%limitName%%) perché il nuovo valore è inferiore alla quantità di risorse riservate per i tuoi clienti (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Impossibile impostare il limite richiesto sull'utilizzo delle risorse (%%quantity%% %%limitName%%) perché il nuovo valore è inferiore alla quantità attuale di risorse già usate dai vostri account e siti (%%used%% %%limitName%%).",

    'domains_list__resource__filter_title' => "Utilizzo delle risorse",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Catalogo di applicazioni APS",
    'site_apps__applications_have_updates' => "Sono disponibili le versioni aggiornate delle seguenti applicazioni:\n%1\nPer visualizzare gli aggiornamenti, verificate che l'area di Ricerca sia visibile e selezionate la casella di controllo <b>Mostrare solo aggiornamenti</b>, quindi trovate le applicazioni che vi interessano.",
    'site_apps__progress_adding_to_vault' => "Aggiungere al vault:",
    'site_apps__progress_done_message' => "Avanzamento:",
    'site_apps__progress_applications_left' => "%1 di %2 applicazioni rimaste",
    'site_apps__download_item_long_task_title' => "Scaricare applicazione APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Scaricare applicazioni APS dal Catalogo APS",
    'site_apps__last_check_for_updates' => "ultima verifica di aggiornamenti: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Tutte le applicazioni pianificate sono state correttamente aggiunte all'Application Vault",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 applicazioni pianificate sono state correttamente aggiunte all'Application Vault.",
    'site_apps__no_search_results' => 'Nessun\'applicazione trovata. Provare diverse richieste di ricerca o cercare applicazioni per categorie.',
    'site_apps__search_results_title' => 'Risultati della ricerca',
    '__site_apps__search_by_application' => 'Nome dell\'applicazione',
    '__site_apps__search_by_vendor' => 'Fabbricante',
    '__site_apps__search_by_vendor__all' => 'Tutti i fabbricanti',
    '__site_apps__search_by_packager' => 'Packager',
    '__site_apps__search_by_certification_level' => 'Livello di certificazione',
    '__site_apps__search_by_cert__any' => 'Qualsiasi',
    '__site_apps__search_by_cert__silver_and_higher' => 'Silver e superiori',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gold e superiori',
    '__retry' => 'Riprovare',
    'site_apps__application_packager_site' => 'Packager',
    'site_apps__add_to_pool_message' => "Le applicazioni contrassegnate come \"disponibili per tutti\" sono automaticamente distribuite a tutti i rivenditori e clienti per una quantità illimitata d'installazioni. Le applicazioni limitate sono distribuite a tutti i rivenditori e clienti in modo manuale ed individuale con un numero di installazioni disponibili esplicitamente specificato.",
    'site_apps__make_available_for_all' => "Rendere le applicazioni selezionate disponibili per tutti gli utenti",

    'site_apps__broadcast_app_text' => "Le applicazioni contrassegnate come \"disponibili per tutti\" sono automaticamente distribuite a tutti i rivenditori e clienti per una quantità illimitata d'installazioni. Le applicazioni limitate sono distribuite a tutti i rivenditori e clienti in modo manuale ed individuale con un numero di installazioni disponibili esplicitamente specificato.",
    'site_apps__broadcast_app_name' => 'Rendere l\'applicazione disponibile per tutti gli utenti',

    // User Application Pool per application
    'site_apps__available_clients' => 'Utenti disponibili',
    'site_apps__no_more_clients_to_add_to_pool' => 'Non ci sono più account utente a cui fornire quest\'applicazione',

    // Installed application instances
    'site_apps__installations' => 'Installazioni',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Nome di dominio e indirizzo IP",
    '__assign_ip_address' => "Assegnare indirizzo IP",
    '__switch_on_service' => "Attivare il servizio",
    '__hosting_configuration' => "Configurazione hosting",
    '__vrt_hst' => "Hosting di siti web",
    '__vrt_hst_hint' => "Ospita un sito web su questo server.",
    '__fwd' => "Inoltro",
    '__web_hosting_settings' => "Impostazioni di hosting",
    '__fwd_hint' => "Reindirizza i visitatori verso un altro sito web.",
    '__none_hint' => "Non ospitare il sito web al momento.",
    '__login_hint' => "Questo nome utente è usato per accedere al tuo sito web tramite FTP",
    '__password_hint' => "Questa password è usata per accedere al tuo sito web tramite FTP",
    '__advanced_hosting_setup' => "Configura le impostazioni avanzate di hosting del sito web",
    '__domain_creation_successful' => "Il dominio è stato creato.",
    'bt_hosting_settings' => "Impostazioni di hosting",
    '__change_hosting_type' => "Cambiare tipologia di hosting per il dominio %1",
    '__hosting_type_change_warning' => "Quando si cambia la tipologia di hosting per inoltro, tutti i file e directory correlati al vostro sito vengono rimossi dal server. Assicuratevi di salvare una copia locale del vostro sito.",
    '__current_hosting_type' => "Tipologia di hosting attuale",
    '__new_hosting_type' => "Nuova tipologia di hosting",
    '__fwd_settings' => "Impostazioni d'inoltro",
    '__fwd_settings_legend' => "Impostazioni d'inoltro",
    '__fwd_destination_url' => "URL di destinazione",
    '__fwd_type' => "Tipologia d'inoltro",
    '__fwd_type_standart' => "Inoltro standard",
    '__fwd_type_standart_hint' => "Reindirizza i visitatori del sito web verso un altro sito, mostrando l'indirizzo di destinazione, in modo che siano al corrente del reindirizzamento.",
    '__fwd_type_frame' => "Inoltro frame",
    '__fwd_type_frame_hint' => "Reindirizza i visitatori del sito web verso un altro sito, senza mostrare l'indirizzo di destinazione, in modo che non siano al corrente del reindirizzamento.",
    '__hosting_type_template_warning' => "Il tipo di hosting che hai selezionato è diverso da quello specificato nel modello. Se continui, le impostazioni di hosting web nel modello selezionato verranno ignorate. Sei sicuro di voler impostare il tipo di hosting selezionato?",

    '__no_resellers_selected' => "È necessario selezionare almeno un account rivenditore.",

    'ippool_Manager__no_available_ips' => "Non ci sono indirizzi IP vacanti nel pool di IP.",
    'ippool_Manager__ip_shared' => "condiviso",
    'ippool_Manager__ip_exclusive' => "dedicato",

    'ippoolManager__ip_shared' => "condiviso",
    'ippoolManager__ip_exclusive' => "dedicato",

    '__users_list' => "Utenti",
    '__users' => "Utenti",
    '__user_name' => "Nome utente",

    'limit__name_max_dom_aliases' => "alias di dominio",
    'limit__name_max_subftp_users' => "account FTP addizionali",
    'limit__name_max_mssql_db' => "Database del server Microsoft SQL",
    'limit__name_max_iis_app_pools' => "Pool di applicazioni IIS",
    'limit__name_max_odbc' => "Connessioni ODBC",
    'total_mboxes_quota_unsupported' => 'non supportato dal server di mail',
    'limit_soft__disk_space' => 'Notificare dopo il superamento dello spazio su disco',
    'limit_soft__max_traffic' => 'Notificare dopo il superamento del traffico',
    'limitsManager__commit_failed' => "Impossibile modificare i limiti delle risorse.",
    'limitsManager__date_in_past' => "Data di scadenza errata %1.",
    'limitsManager__limit_not_supported' => "I limiti per il tipo di risorsa %1 non possono essere impostati.",
    'limitsManager__limit_oversell_inconsistency' => "Impossibile assegnare le quantità specificate di risorse con l'overselling disattivato.",
    'limitsManager__limit_overuse_inconsistency' => "L'utilizzo delle risorse supera i limiti definiti.",
    'limitsManager__no_resource_available' => "Non ci sono risorse disponibili di questo tipo (%%limitName%%). Richiesto: %%quantity%%; disponibile: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Non ci sono risorse di questo tipo (%%limitName%%) disponibili dal tuo service provider. Richiesto: %%quantity%%; disponibile: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "La data di scadenza deve essere inferiore o uguale a %1.",
    'limitsManager__invalid_disk_space_limit' => "La quantità di spazio su disco deve essere inferiore o uguale a %1.",
    'limitsManager__invalid_max_traffic_limit' => "La quantità di traffico deve essere inferiore o uguale a %1.",
    'ippoolManager__ip_has_suballocations' => "Impossibile cambiare il tipo di indirizzo IP già assegnato a un utente. L'indirizzo IP %%ip%%  è già assegnato all'/agli utente/i come indirizzo IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Questo indirizzo IP è già assegnato all'utente.",
    'ippoolManager__ip_is_not_in_pool' => "Non c'è alcun indirizzo IP %%ip%% nel pool.",
    'ippoolManager__can_not_allocate_ip' => "L'indirizzo IP %%ip%% è disponibile solo come %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "L'indirizzo IP %%ip%%  non può essere assegnato come dedicato.",
    'ippoolManager__ip_used_by_hst_or_frw' => "L'indirizzo IP %%ip%% è già usato per hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "L'accesso FTP anonimo è già attivato per l'indirizzo IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Non ci sono indirizzi IP vacanti.",
    'ippoolManager__no_available_ips' => "Non ci sono indirizzi IP disponibili.",
    'templates__dublicate_name' => "Un modello con questo nome esiste già. Selezionare un altro nome per questo modello.",
    'cl_perm__client_limits_exceeded' => "I valori specificati sul limite di risorse superano i valori permessi dal vostro piano di hosting oppure questi valori forniscono meno risorse di quelle usate attualmente dai vostri siti.",
    'cl_perm__reseller_limits_exceeded' => "I valori specificati sul limite di risorse superano i valori permessi dal vostro piano di hosting oppure questi valori forniscono meno risorse di quelle usate attualmente dagli account utente e dai siti.",

    'site_apps__preferences_show_all_versions_title' => "Visualizzare la lista completa di versioni per ogni applicazione recuperata dal catalogo",
    'site_apps__preferences_show_all_versions_hint' => "Se questa opzione è selezionata, l'operazione può durare a lungo dovuto al fatto di recuperare tutte le versioni di ogni applicazione ogni volta che aprite il catalogo. Se questa opzione non è selezionata, solo le ultime versioni verranno visualizzate.",
    '__select_user_template' => "Creare un account utente basato su un modello",
    'ip_already_added_to_all_clients' => "Questo indirizzo IP è già assegnato a tutti gli utenti.",

    'site_apps__cancelled_apps' => "Avete annullato l'aggiunta delle seguenti applicazioni: %2",

    'sb_url_is_not_resolved' => 'L\'URL non può essere risolto: verificare le vostre impostazioni DNS. L\'URL %1 deve risolvere nell\'indirizzo IP del server con Presence Builder installato.',

    'ip_addr__is_last_on_interface' => 'Impossibile rimuovere l\'indirizzi IP %%ip%%  perché è l\'ultimo indirizzo IP presente su un\'interfaccia di rete.',
    'ip_addr__used_for_current_session' => 'Impossibile rimuovere l\'indirizzo IP %%ip%% perché è usato da una sessione attiva.',
    'ip_addr__used_for_hosting' => 'Impossibile rimuovere l\'indirizzo ip %%ip%% perché è usato per ospitare un sito web.',
    'ip_addr__is_main' => 'Impossibile rimuovere l\'indirizzo IP %%ip%% perché è l\'indirizzo IP primario di un\'interfaccia di rete.',
    'ip_addr__ip_used_by_message_submission' => 'Impossibile rimuovere l\'indirizzo IP %%ip%% perché è usato per l\'invio di messaggi di posta',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domini di clienti',
    'excl_ip_num' => 'Indirizzo IP dedicato',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder non è installato.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Il permesso per consentire la vendita al di sopra delle disponibilità non può essere revocato giacché l\'utente ha già assegnato più risorse di quelle disponibili, tramite il modo di overselling.',
    'limitsManager__invalid_limit_value' => 'Il valore specificato %%value%% non è corretto per il limite %%limit_name%%',
    'limit__max_mn' => 'Numero massimo di account di posta',

    'limits__client_overuse_description' => 'Le norme sul sovrautilizzo indicano a Plesk cosa fare quando l\'utilizzo delle risorse supera l\'assegnazione di risorse iniziale.',
    'limits__client_overuse_block_true_description' => 'Bloccare la sovrautilizzazione delle risorse. L\'utilizzo attuale delle risorse non può superare l\'assegnazione iniziale delle risorse',
    'limits__client_overuse_block_false_description' => 'Non bloccare il sovrautilizzo delle risorse, consentendo al cliente di usare più risorse di quanto inizialmente fornite. L\'attuale utilizzo delle risorse può superare l\'assegnazione iniziale delle risorse',
    'limits__client_overuse_notify_text' => 'Informare il cliente del superamento dei limiti delle risorse',

    'limits__domain_overuse_description' => 'Le norme sul sovrautilizzo indicano a Plesk cosa fare quando l\'utilizzo delle risorse supera l\'assegnazione di risorse iniziale.',
    'limits__domain_overuse_block_true_description' => 'Le norme sul sovrautilizzo indicano a Plesk cosa fare quando le risorse vengono sovrautilizzate.',
    'limits__domain_overuse_block_false_description' => 'Non bloccare il sovrautilizzo delle risorse, consentendo al dominio di usare più risorse di quanto inizialmente fornite. L\'utilizzo reale delle risorse può superare l\'assegnazione iniziale delle risorse',
    'limits__domain_overuse_notify_text' => 'Notificare il proprietario del dominio riguardo il superamento dei limiti delle risorse',

    'dns__dns_rr_delete' => 'Elementi che verranno rimossi',
    'dns__delete_rr' => 'I seguenti record DNS verranno rimossi dalla zona DNS:',
    'dns__dns_rr_delete_non_removable' => 'Elementi che non possono attualemente essere rimossi',
    'dns__non_delete_rr' => 'I seguenti record DNS non possono essere rimossi:',
    'dns__dns_rr_delete_confirm_message' => 'Confermare la rimozione dei record DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Formato di applicazione web sconosciuto: l\'applicazione web potrebbe essere non disponibile per l\'installazione e l\'utilizzo.',

    '__php_handler_type_desc' => 'Eseguire PHP come',
    'sfdk_domain_sign__failed' => 'Si è verificato un errore non identificato nel tentativo di attivare la firma di posta con DKIM sul dominio. Consultare il registro di errori del server per ulteriori informazioni.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Notifica sul successo dell\'aggiornamento della chiave di Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Notifica sul rinvio dell\'aggiornamento della chiave di Plesk',
    'pkey_notify__subj_update_error_notification' => 'Notifica sull\'errore dell\'aggiornamento della chiave di Plesk',
    'pkey_notify__update_successful' => '%1 aggiornamento completato correttamente.',
    'pkey_notify__update_failed_no_more_try' => 'Impossibile aggiornare %1. La chiave che stai provando ad inviare non è valida. Non è più possibile riprovare l\'aggiornamento della chiave.',
    'pkey_notify__update_failed_try_later' => 'Impossibile aggiornare %1: si è verificato un errore durante l\'elaborazione della tua chiave. È possibile cercare di ripristinare la chiave manualmente in Plesk (Strumenti e Impostazioni > Informazioni sulla licenza) o lasciare che Plesk provi ad aggiornarla nelle prossime 24 ore. Se non vuoi ricevere più questa notifica, rimuovi la chiave da Plesk.',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domini',
    'rpt_reseller_dom_subdomains' => 'Sottodom',
    'rpt_reseller_dom_domain_aliases' => 'DAlias',
    'rpt_reseller_dom_postboxes' => 'MBox',
    'rpt_reseller_dom_redirects' => 'Inoltri',
    'rpt_reseller_dom_mail_groups' => 'GruppPost',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MList',
    'rpt_reseller_dom_web_users' => 'UtentiW',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Clienti',
    '__cl_name' => 'Nome del cliente',
    '__cl_creation_date' => 'Data di creazione',
    '__clients_traffic' => 'Traffico del cliente',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder non è installato.',
    'sitebuilder_disabled' => 'Presence Builder è disattivato.',
    'b_sitebuilder_disabled' => 'Presence Builder è disattivato.',
    'webmail_not_installed' => 'Il software webmail non è installato.',
    'webmail_disabled' => 'Il servizio Webmail è disattivato.',
    'spamassassin_not_installed' => 'SpamAssassin non è installato.',
    // pfu:
    'anonymous_ftp_shared' => 'Impossibile configurare il FTP anonimo: tipo d\'indirizzo IP condiviso.',
    'anonymous_ftp_used' => 'Impossibile configurare il FTP anonimo: l\'indirizzo IP è in uso da un altro dominio per il servizio FTP anonimo.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET non è installato.',
    'site_builder_no_package' => 'Presence Builder non è disponibile. Verifica che Presence Builder sia installato e selezionato come componente attivo.',
    'site_builder_not_configured' => 'Presence Builder non è configurato.',

    // various

    'disabled_by_admin' => 'Disattivato dall\'amministratore del server',

    '__not_allowed' => 'Non consentito',

    '__ip_addr_state_unknown' => "L'indirizzo IP non è operativo al momento poiché il sistema sta ancora elaborando la vostra richiesta. Si prega di attendere un minuto.",

    'ip_addr__repair_is_not_allowed' => 'L\'indirizzo IP non può essere riparato sotto l\'ambiente di Virtuozzo.',

    'ippoolManager__ip_used_by_nohost_domain' => "Impossibile rimuovere L'indirizzo IP %%ip%% non può essere rimosso perché è utilizzato da uno o più domini senza hosting.",
    'ippoolManager__ip_used_for_mail_service' => "L'indirizzo IP %%ip%% non può essere rimosso, perché è utilizzato da uno o più domini come indirizzo IP del servizio di posta.",
    'ippoolManager__ip_used_for_send_emails' => "L'indirizzo IP %%ip%% non può essere rimosso, perché è utilizzato per inviare e-mail da un IP specifico (vedi Impostazioni del server di posta).",
    'ippoolManager__ip_used_in_dns_zone' => 'L\'indirizzo IP %%ip%%  non può essere rimosso perché è utilizzato dalla zona DNS di uno o più domini.',
    'ip_ctrl__cannot_manage_on_vz' => 'Questa installazione di Plesk funziona con Virtuozzo Containers. I nuovi indirizzi IP possono essere aggiunti solo dall\'amministratore del nodo di Virtuozzo Containers.',

    'client_template__limits_auto_adjusted' => 'I limiti dal modello del cliente sono stati automaticamente regolati.',

    '__entries' => 'Voci',

    '__path_is_not_set' => 'Il percorso non è stato specificato. Determinare un percorso valido.',

    'defaultcomponents__imap_required' => '(L\'attuale server di posta non supporta IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk supporta solo il software di statistiche web commerciale per il calcolo delle statistiche del sottodominio.Attualmente, non è installato nessun software di questo tipo nel sistema.',


    'server_settings_invalid_traffic_statistics' => 'Parametro del recupero statistiche del traffico non valido.',
    'server_settings_invalid_logrotate_period' => 'Parametro del periodo di rotazione dei registri non valido.',

    'spam_filter/address/file_size' => 'Impossibile caricare il file.La dimensione massima di un file da caricare è %1.',
    'spam_filter/address/file_empty_content' => 'Si sono verificati dei problemi nella lettura degli indirizzi email dal file. Assicurati di caricare un file con codifica UTF-8 contenente uno o più indirizzi email, quindi riprova.',
    'spam_filter/address/addresses_empty_content' => 'Non ci sono indirizzi email nella lista.',
    'spam_filter/address/addresses_available' => 'Verranno aggiunti unicamente i %1 primi indirizzi e-mail unici.',
    'spam_filter/address/invalid_addresses' => 'I seguenti indirizzi email non sono validi: %1.',

    'current_resources' => 'Risorse attuali',
    'plan_limitations' => 'Pianifica limitazioni',
    'cannot_switch_plan' => 'Impossibile passare al piano selezionato, le risorse attuali indicate di seguito superano le limitazioni del piano:',
];