<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Eigenschaften des zusätzlichen Schlüssels',
    'additional-key-info.update' => 'Zusätzlichen Schlüssel abrufen',
    'additional-key-info.updateDescription' => 'Zusätzlichen Schlüssel abrufen und installieren.',
    'additional-key-info.download' => 'Schlüssel herunterladen',
    'additional-key-info.downloadDescription' => 'Aktuellen Lizenzschlüssel herunterladen.',
    'additional-key-info.install' => 'Schlüssel installieren',
    'additional-key-info.installDescription' => 'Aktuellen Lizenzschlüssel installieren.',
    'additional-key-info.revert' => 'Rollback für Schlüssel ausführen',
    'additional-key-info.revertDescription' => 'Stellen Sie den zuvor installierten Lizenzschlüssel wieder her.',
    'additional-key-info.revertNotAvailableDescription' => 'Kein Schlüssel installiert.',
    'additional-key-info.installSuccess' => 'Die Installation des Lizenzschlüssels ist gestartet.',

    'additional-key-revert.title' => 'Zusätzlicher Schlüssel-Rollback',
    'additional-key-revert.success' => 'Der zusätzliche Schlüssel wurde zurückgesetzt.',

    'additional-key-upload.title' => 'Einen Lizenzschlüssel installieren',
    'additional-key-upload.success' => 'Der neue zusätzliche Schlüssel wurde hochgeladen.',

    'additional-keys.title' => 'Zusätzliche Lizenzschlüssel',

    'change-subscriptions-owner.title' => 'Ausgewählte Abonnements neu zuweisen',
    'change-subscriptions-owner.success' => 'Der Besitzer des Abonnements wurde geändert',

    'customers.hint' => 'Hier können Sie die Konten Ihrer Hosting-Service-Kunden verwalten: Erstellen Sie Konten zusammen mit Abonnements bestimmter Services, verwalten Sie die bestehenden Kunden oder entfernen Sie Konten. Wenn Sie die dem Kunden bereitgestellten Websites, E-Mail-Services oder andere Services verwalten wollen, gehen Sie zum Kunden-Panel des Kunden, indem Sie auf den Link in der rechten Spalte der Liste klicken.',

    'customer-domains.hint' => 'Hier können Sie Websites erstellen und verwalten.',

    'customer-subscriptions.hint' => 'Hier können Sie die Abonnements des Kunden verwalten.',

    'domains.hint' => 'Hier können Sie Informationen zu allen Domainnamen anzeigen, die im System registriert sind, und die Hosting-Services verwalten. Wenn Sie eine Domain für sich selbst oder für Hosting-Kunden hinzufügen möchten, klicken Sie einfach auf "Domain hinzufügen". Während der Erstellung einer Domain werden Sie aufgefordert, einen neuen Kunden und ein neues Abonnement zu erstellen oder aus den bestehenden Optionen auszuwählen.',

    'database-servers.title' => 'Datenbankserver',

    'database-server-create.title' => 'Neuer Datenbankserver',

    'database-server-properties.title' => 'Datenbankserver',

    'database-server-upgrade.drawerTitle' => 'MariaDB-Upgrade',
    'database-server-upgrade.drawerTitle.completed' => 'Upgrade abgeschlossen',
    'database-server-upgrade.drawerSubTitle.line1' => 'Die Leiste kann nicht geschlossen werden, da das Upgrade noch nicht beendet ist.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Bei Problemen während des Upgrades finden Sie hilfreiche Informationen %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Der MariaDB-Datenbankserver wurde auf die Version %%releaseVersion%% upgegradet. Falls Probleme auftreten, finden Sie hilfreiche Informationen %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'Die LTS-Version wurde installiert.',
    'database-server-upgrade.troubleshootingArticle' => 'in diesem KB-Artikel',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Details zur Fehlerbehebung bei Problemen mit dem MariaDB-Upgrade finden Sie %%troubleshootingArticle%%.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Sie können ein Upgrade für Ihren lokalen MariaDB-Datenbankserver auf die aktuelle LTS-Version (langfristiger Support) durchführen.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Wir empfehlen dringend, vor dem Upgrade ein Backup des Servers zu erstellen und das Upgrade durchzuführen, wenn die Websites gerade nicht ausgelastet sind.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Während des MariaDB-Upgrades sind der Plesk Server und die gehosteten Websites nicht verfügbar. Das MariaDB-Upgrade wird in der Regel ohne Fehler abgeschlossen und dauert etwa 10 Minuten. Es kann aber der gesamte Server betroffen sein.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Hinweis: Wenn Sie MariaDB 5.5 verwenden, führt Plesk zunächst ein Upgrade auf MariaDB 10.5 durch. Nachdem das Upgrade abgeschlossen ist, starten Sie diesen Assistenten erneut, um auf die aktuelle LTS-Version von MariaDB zu aktualisieren.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Aktuelle Version',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Version für das Upgrade auswählen',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Es sind keine Hauptversionen vorhanden',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Versionshinweise',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Release-Datum: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'End-of-Life-Datum: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Upgrades können nur für MariaDB-Forks durchgeführt werden, die vom BS- oder MariaDB-Anbieter stammen.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Überprüfungen vor dem Upgrade',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'MariaDB-Konfigurationsdateien parsen',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Datenbanken mit mysqlcheck analysieren',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Analysiere die Paket-Manager-Konfiguration',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Überprüfung der Systemkompatibilität',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'WebSocket überprüfen',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Um mit dem Upgrade fortzufahren, klicken Sie alle Kontrollkästchen an. Vergewissern Sie sich unbedingt, dass Sie mit den Konfigurationsänderungen einverstanden sind, die das Upgrade mit sich bringt, und dass Sie Zugriff auf die Wiederherstellungsoptionen haben.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Die folgenden Variablen werden aus Gründen der Kompatibilität mit der neuen Version entfernt:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => 'Die folgenden Konfigurationsdateien werden entfernt, da sie Teil des mariadb-server-Pakets sind, das aktualisiert wird:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} aus {count, plural, one {der Datei {files}} other {den # Dateien: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Zugriff auf Wiederherstellungsoptionen (Server-Befehlszeilenkonsole und Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Ich habe SSH-Zugriff auf den Server',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Verwenden Sie einen SSH-Client oder öffnen Sie die %%sshTerminalExtension%% in einem neuen Browsertab (schließen Sie das Fenster der SSH-Terminal-Erweiterung nicht, bevor das Upgrade abgeschlossen ist). Sollte das Upgrade fehlschlagen, kann die Wiederherstellung via SSH-Zugriff erfolgen.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'SSH Terminal-Erweiterung',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Ich habe Zugriff auf Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Öffnen Sie %%repairKit%% in einem neuen Browsertab und melden Sie sich mit den Administrator-Anmeldedaten an. Schließen Sie das Fenster der Repair Kit-Erweiterung erst, wenn das Upgrade abgeschlossen ist.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Backup der Datenbanken erstellen',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Alle Datenbanken auf dem Server vor dem Upgrade sichern',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk speichert das Backup der Datenbanken in dem Verzeichnis %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket ist in Plesk nicht verfügbar',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Ohne WebSocket sehen Sie das Resultat des Upgrades nicht in Echtzeit.',

    'database-server-upgrade.submitPopover.title' => 'Um Datenverlust zu verhindern, empfehlen wir dringend, ein Speicherabbild der gehosteten Datenbanken zu erstellen, bevor Sie fortfahren. Weiter ohne Speicherabbild?',

    'database-server-databases.title' => 'Datenbanken',

    'database-server-change-password.title' => 'Administratorpasswort',

    'home.title' => 'Start',

    'license.title' => 'Lizenzinformationen',

    'primary-key-info.title' => 'Plesk Lizenzschlüssel',
    'primary-key-info.update' => 'Schlüssel abrufen',
    'primary-key-info.updateDescription' => 'Bestellte Lizenzschlüssel abrufen und installieren.',
    'primary-key-info.upload' => 'Schlüssel installieren',
    'primary-key-info.uploadDescription' => 'Neuen Lizenzschlüssel hochladen und installieren.',
    'primary-key-info.revert' => 'Rollback für Schlüssel ausführen',
    'primary-key-info.revertDescription' => 'Stellen Sie den zuvor installierten Lizenzschlüssel wieder her.',
    'primary-key-info.expireTitle' => 'Plesk-Lizenz abgelaufen',
    'primary-key-info.header' => 'Daher sind einige wichtige Dienste nicht mehr verfügbar. %%warning%%',
    'primary-key-info.headWarning' => 'Ihre Websites könnten gefährdet sein.',
    'primary-key-info.softwareUpdatesTitle' => 'Softwareupdates',
    'primary-key-info.softwareUpdates' => '%%title%% sind deaktiviert. Ihr System kann Bedrohungen ausgesetzt sein.',
    'primary-key-info.websiteBackupsTitle' => 'Website-Backups',
    'primary-key-info.websiteBackups' => '%%title%% sind nicht mehr verfügbar. Es besteht die Gefahr von Datenverlust.',
    'primary-key-info.sslCertificatesTitle' => 'SSL/TLS-Zertifikate',
    'primary-key-info.sslCertificates' => '%%title%% werden nicht automatisch erneuert. Dies kann die Sicherheit und das Vertrauen beeinträchtigen.',
    'primary-key-info.monitoringTitle' => 'Monitoring',
    'primary-key-info.monitoring' => '%%title%% ist nicht verfügbar. Überlastungen und Leistungsprobleme können unbemerkt bleiben.',
    'primary-key-info.fileDbManagementTitle' => 'Datei- und Datenbankverwaltung',
    'primary-key-info.fileDbManagement' => '%%title%% ist deaktiviert. Sie können Ihre Dateien und Datenbanken nicht effizient verwalten.',
    'primary-key-info.technicalSupportTitle' => 'Technischer Support',
    'primary-key-info.technicalSupport' => '%%title%% ist nicht verfügbar. Fehlende Unterstützung bei Serverproblemen kann zu längeren Ausfällen führen.',
    'primary-key-info.renewLicense' => 'Wenn Sie diese Funktionen wieder nutzen möchten, kaufen Sie jetzt eine neue Plesk-Lizenz.',
    'primary-key-info.footer' => 'Falls Sie Fragen haben oder Hilfe benötigen, ',
    'primary-key-info.supportLink' => 'wenden Sie sich an den Plesk-Support',

    'primary-key-revert.title' => 'Lizenzschlüssel-Rollback',
    'primary-key-revert.success' => 'Der Plesk-Schlüssel wurde zurückgesetzt.',

    'primary-key-upload.title' => 'Einen Lizenzschlüssel installieren',
    'primary-key-upload.success' => 'Der neue Plesk Schlüssel wurde hochgeladen.',

    'resellers.hint' => 'Hier verwalten Sie die Konten von Resellern. Das sind Ihre Kunden, die Hosting-Services weiterverkaufen sowie ihre eigenen Websites hosten. Hier können Sie Konten zusammen mit Service-Abonnements erstellen, Reseller verwalten und Konten entfernen.',

    'reseller-customers.hint' => 'Hier können Sie Kunden einrichten und verwalten.',

    'reseller-domains.hint' => 'Hier können Sie Websites erstellen und verwalten.',

    'reseller-subscriptions.hint' => 'Hier können Sie die Abonnements des Resellers verwalten.',

    'subscriptions.hint' => 'Kunden erhalten Hosting-Services von Ihnen, indem sie ein Hosting-Paket abonnieren. Hier können Sie diese Abonnements und Ihre eigenen Abonnements verwalten, die Sie zum Hosten Ihrer Websites erstellen. Wenn Sie die mit einem Abonnement bereitgestellten Websites, E-Mail-Services oder anderen Services verwalten wollen, gehen Sie zum Kunden-Panel des Abonnenten, indem Sie auf den Link in der rechten Spalte der Liste klicken.',

    'server-mail-settings.title' => 'Einstellungen',
    'server-mail-spam-filter.title' => 'Spamfilterung',
    'server-mail-antivirus.title' => 'Virenschutz',
    'server-mail-black-list.title' => 'Schwarze Liste',
    'server-mail-white-list.title' => 'Whitelist',
    'server-mail-queue.title' => 'E-Mail-Warteschlange',
    'server-mail-statistics.title' => 'Statistiken',
    'server-mail-smarthost.title' => 'Smarthost',

    'server-spam-filter.settings' => 'Einstellungen',
    'server-spam-filter.black-list' => 'Schwarze Liste',
    'server-spam-filter.white-list' => 'Whitelist',

    'firewall.title' => 'Firewall-Verwaltung',
    'firewall-general.title' => 'Allgemein',
    'firewall-general.toggleStatus' => 'Firewall-Schutz',
    'firewall-general.buttonDefault' => 'Auf Standard zurücksetzen',
    'firewall-general.buttonPanic' => 'Panikmodus',
    'firewall-general.confirmationDefault' => 'Die Firewall-Einstellungen auf die Standardeinstellungen zurücksetzen?',
    'firewall-general.confirmationPanic' => 'Panikmodus einschalten? Die Benutzer können dann nicht auf ihre Domains zugreifen und einige Netzwerkdienste funktionieren möglicherweise nicht mehr.',
    'firewall-general.successDefault' => 'Die Firewall-Einstellungen wurden auf die Standardwerte zurückgesetzt.',
    'firewall-general.successPanic' => 'Der Panikmodus wurde aktiviert.',
    'firewall-general.info' => 'Aus Sicherheitsgründen blockiert die Firewall alle Verbindungen, die nicht ausdrücklich erlaubt sind. Sie können eine Verbindung zulassen, indem Sie eine Regel erstellen. Weitere Informationen finden Sie in der Dokumentation',
    'firewall-general.interfaces' => 'Netzwerkschnittstellen',
    'firewall-icmp.title' => 'ICMP-Protokoll',
    'firewall-rules.title' => 'Firewall-Regeln',

    'dns.title' => 'DNS-Einstellungen',
    'dns-records.title' => 'Vorlage für Zoneneintrag',
    'dns-soa-record.title' => 'Vorlage für Zoneneinstellungen',

    'php-handler.title' => 'Einstellungen für %%name%%',
    'php-handler.extensions.title' => 'Erweiterungen',
    'php-handler.extensions.description' => 'Diese Einstellungen für PHP-Erweiterungen sind nur für diesen Handler vorgesehen.',
    'php-handler.extensions.descriptionShared' => 'Diese Einstellungen sind für folgende PHP-Handler gleich: %%handlers%%. Die Einstellungen gelten für alle Websites, die diese Handler nutzen.',
    'php-handler.extensions.buttonManage' => 'PECL-Pakete verwalten',
    'php-handler.extensions.manage.title' => 'PECL-Pakete verwalten',
    'php-handler.extensions.manage.risks' => 'PHP-Erweiterungen werden von PECL-Paketen Dritter bereitgestellt. Sie installieren sie auf eigenes Risiko.',
    'php-handler.extensions.manage.description' => 'Installieren, aktualisieren und deinstallieren Sie PECL-Pakete. Die Änderungen werden auf alle Websites angewendet, die auf %%handlers%% ausgeführt werden.',
    'php-handler.extensions.manage.notFound' => 'Warum ist das erwünschte Pakete nicht auf der Liste?',
    'php-handler.extensions.manage.limitations' => 'PHP-Erweiterungen, die vom Anbieter des Kontrollpanels und des Betriebssystems geliefert werden, sind in der Liste nicht aufgeführt.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Aktualisieren",
    'ServerInformation.sectionGeneral' => "Allgemein",
    'ServerInformation.cpu' => "CPU",
    'ServerInformation.version' => "Version",
    'ServerInformation.os' => "Betriebssystem",
    'ServerInformation.key' => "Plesk Lizenzschlüssel",
    'ServerInformation.uptime' => "Erreichbarkeit",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# Tag} other {# Tage}} {hours, plural, one {# Stunde} other {# Stunden}} {minutes, plural, one {# Minute} other {# Minuten}}",
    'ServerInformation.sectionCpu' => "CPU-Auslastung",
    'ServerInformation.la1min' => "Letzte Minute",
    'ServerInformation.la5min' => "Letzte 5 Minuten",
    'ServerInformation.la15min' => "Letzte 15 Minuten",
    'ServerInformation.sectionMemory' => "Speicherauslastung",
    'ServerInformation.memoryHardware' => "Hardware",
    'ServerInformation.memoryTotalNoKernel' => "Gesamt (ohne Kernel)",
    'ServerInformation.memoryTotal' => "Gesamt",
    'ServerInformation.memoryUsed' => "Verwendet",
    'ServerInformation.memoryFree' => "Frei",
    'ServerInformation.memoryShared' => "Gemeinsam genutzt",
    'ServerInformation.memoryBuffer' => "Puffer",
    'ServerInformation.memoryCached' => "Im Zwischenspeicher",
    'ServerInformation.memoryAvailable' => "Verfügbar",
    'ServerInformation.memoryUsage' => "Belegung",
    'ServerInformation.sectionSwap' => "Swap-Nutzung",
    'ServerInformation.sectionVirtualMemory' => "Ausnutzung des virtuellen Speichers",
    'ServerInformation.swapTotal' => "Gesamt",
    'ServerInformation.swapUsed' => "Verwendet",
    'ServerInformation.swapFree' => "Frei",
    'ServerInformation.swapUsage' => "Belegung",
    'ServerInformation.sectionHarddisk' => "Festplattenauslastung",
    'ServerInformation.harddiskDirectory' => "Dateisystem",
    'ServerInformation.harddiskProtectedDir' => "Wichtige Verzeichnisse",
    'ServerInformation.harddiskTotal' => "Gesamt",
    'ServerInformation.harddiskUsed' => "Verwendet",
    'ServerInformation.harddiskAvailable' => "Verfügbar",
    'ServerInformation.harddiskCapacity' => "Kapazität",
    'ServerInformation.sectionDomains' => "Domains",
    'ServerInformation.activeDomains' => "Aktiv",
    'ServerInformation.inactiveDomains' => "Inaktiv",
    'ServerInformation.problemDomains' => "Probleme",
    'ServerInformation.refreshed' => "Information aktualisiert.",

    'ServerAbout.copyright' => '© 2025 WebPros International GmbH. Alle Rechte vorbehalten.',
    'ServerAbout.linkLicenseManagement' => 'Lizenzinformationen anzeigen',
    'ServerAbout.panelVersion' => 'Version',
    'ServerAbout.installedPatchVersion' => 'Update Nr. %%patch%%',
    'ServerAbout.licenseKey' => 'Lizenzschlüssel',
    'ServerAbout.productDescription' => 'Plesk ist die führende WebOps-Plattform zum Ausführen, Automatisieren und Ausbauen von Anwendungen, Websites und Hosting-Unternehmen.',
    'ServerAbout.readEula' => 'Mehr Informationen unter %%link%%',
    'ServerAbout.linkEula' => 'Endbenutzer-Lizenzvertrag',
    'ServerAbout.visitForum' => 'Besuchen Sie %%link%%.',
    'ServerAbout.linkForum' => 'Plesk Forum',
    'ServerAbout.followUs' => 'Folgen Sie uns',
    'ServerAbout.visitSite' => 'Weitere Informationen unter %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Finden Sie inspirierende Ideen unter %%link%%.',
    'ServerAbout.linkBlog' => 'Plesk Blog',

    'ServerAbout.darkThemePromoTitle' => 'Glückwunsch!',
    'ServerAbout.darkThemePromoDescription' => 'Sie haben ein Zauberkätzchen gefunden.',
    'ServerAbout.darkThemePromoButton' => 'Whoosh! Willkommen auf der dunklen Seite',
    'ServerAbout.darkThemeTourDescription' => 'Schalten Sie diese Option um, um das dunkle Thema für Ihre Benutzeroberfläche zu aktivieren oder zu deaktivieren.',
    'ServerAbout.darkThemeTourButton' => 'OK',

    'ts-sessions.title' => 'Terminalserver-Sitzungen',
    'ts-sessions-properties.title' => 'Eigenschaften der Sitzung',

    'BandwidthLimiting.bandwidthThrottling' => 'Sie können die Bandbreiteneinschränkung nicht kontrollieren, da QoS nicht installiert ist.',
    'BandwidthLimiting.virtualHostingRequired' => 'Bandbreitenlimits sind nur für Domains mit Webhosting verfügbar.',
    'BandwidthLimiting.bandwidthLabel' => 'Maximale Bandbreitenauslastung',
    'BandwidthLimiting.bandwidthHint' => 'Das Bandbreitennutzungslimit gilt nur für Daten, die über das HTTP-Protokoll übertragen werden.',
    'BandwidthLimiting.maxConnectionLabel' => 'Verbindungen begrenzt auf',
    'BandwidthLimiting.maxConnectionHint' => 'Wenn Sie die Bandbreite beschränken, wird empfohlen, auch die Anzahl an gleichzeitigen Verbindungen zu der Website einzuschränken. Ansonsten wird die Serverlast im Fall von häufigen Website-Abfragen durch die Webserver-Prozesse erhöht.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'Einstellungen für Bandbreitenlimit wurden geändert.',
    'BandwidthLimiting.unlimited' => 'Unbegrenzt',

    'ip-address-domains.title' => 'Websites, die die IP-Adresse %%ipAddress%% (%%type%%) verwenden',
    'ip-address-domains.site' => 'Website',
    'ip-address-domains.setAsDefault' => 'Als Standard festlegen',
    'ip-address-domains.type-SHARED' => 'gemeinsam genutzt',
    'ip-address-domains.type-EXCLUSIVE' => 'dediziert',

    'HotlinkProtection.virtualHostingRequired' => 'Der Hotlinking-Schutz ist nur für Domains mit Webhosting verfügbar.',
    'HotlinkProtection.enabledLabel' => 'Schutz vor Hotlinking aktivieren',
    'HotlinkProtection.extensionsLabel' => 'Geschützte Dateierweiterungen',
    'HotlinkProtection.friendsLabel' => 'Adressen von zugelassenen Websites',
    'HotlinkProtection.success' => 'Einstellungen für den Hotlinking-Schutz wurden geändert.',

    'Odbc.add' => 'ODBC DSN hinzufügen',
    'Odbc.resourceUsage' => '%%used%% erstellt / %%allowed%% zugelassen.',
    'Odbc.limitExceeded' => 'Das Limit der ODBC-DSN-Verbindungen wurde überschritten.',
    'Odbc.unlimited' => 'Unbegrenzt',
    'Odbc.addTooltip' => 'Fügen Sie eine ODBC-Datenquelle hinzu.',
    'Odbc.status' => 'Status',
    'Odbc.name' => 'Verbindungsname',
    'Odbc.driver' => 'Treiber',
    'Odbc.description' => 'Verbindungsbeschreibung',
    'Odbc.hostname' => 'Hostname',
    'Odbc.statusSystem' => 'Es ist eine System-DSN.',
    'Odbc.statusConfigured' => 'DSN ist konfiguriert.',
    'Odbc.statusNotConfigured' => 'DSN ist nicht konfiguriert.',
    'Odbc.noSelectionText' => 'Wählen Sie mindestens ein Element aus, das entfernt werden soll.',
    'Odbc.removeConfirmation' => 'Die {count, plural, one {}=1 {Verbindung {name}} other {# ausgewählten Verbindungen}} entfernen?',
    'Odbc.removeSuccess' => 'Die ausgewählten Verbindungen wurden entfernt.',

    'DomainAliasSettings.title' => 'Einstellungen für Domain-Alias',
    'DomainAliasSettings.updateSuccess' => 'Die Eigenschaften des Domain-Alias %%name%% wurden geändert. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Die Website-Einstellungen werden in %%restartInterval%% Minuten übernommen.',

    'Home.Backup.offStatus' => 'Dies ist kein gültiges Backup. Die Daten können aus dieser Datei nicht wiederhergestellt werden.',
    'Home.Backup.task-failedStatus' => 'Die Backup-Aufgabe ist fehlgeschlagen.',
    'Home.Backup.activeSchedule' => 'Zeitplan: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Zeitplan: %%schedules%%',
    'Home.Backup.noSchedule' => "Es wurde kein Backup geplant",
    'Home.Backup.period_hourly' => 'Mehrmals täglich %%schedule%%',
    'Home.Backup.period_daily' => 'Täglich %%schedule%%',
    'Home.Backup.period_weekly' => 'Wöchentlich %%schedule%%',
    'Home.Backup.period_monthly' => 'Monatlich %%schedule%%',
    'Home.Backup.create' => 'Backup erstellen',
    'Home.Backup.schedule' => 'Zeitplan',
    'Home.ChangeLog.seeHistory' => 'Änderungsverlauf anzeigen',
    'Home.CustomButtons.add' => 'Benutzerdefinierte Schaltfläche hinzufügen',
    'Home.CustomButtons.noButtons' => 'Es sind keine benutzerdefinierten Schaltflächen vorhanden',
    'Home.Customization.title' => 'Dashboard',
    'Home.Customization.description' => 'Wählen Sie, welche Option Sie sehen möchten',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Server',
    'Home.Customization.securitySection' => 'Sicherheit',
    'Home.Customization.backup' => 'Letztes Serverbackup',
    'Home.Customization.ipBan' => 'Sperren von IP-Adressen',
    'Home.Customization.mailQueue' => 'E-Mail-Warteschlange',
    'Home.Customization.mySubscriptions' => 'Meine Abonnements',
    'Home.Customization.overusedSubscriptions' => 'Abonnements mit Überbeanspruchung',
    'Home.Customization.serverInfo' => 'Serverinformationen',
    'Home.Customization.updates' => 'Plesk Updates',
    'Home.Customization.promo' => 'Promo',
    'Home.Customization.changeLog' => 'Neue Funktionen',
    'Home.Customization.customButtons' => 'Benutzerdefinierte Schaltflächen',
    'Home.EmptyView.title' => 'Wählen Sie einfach aus, was Ihr Dashboard enthalten soll.',
    'Home.EmptyView.titleLocked' => 'Das Dashboard wurde von Ihrem Service-Provider gesperrt.',
    'Home.EmptyView.customize' => 'Anpassen',
    'Home.Extension.title' => 'Erweiterung',
    'Home.IpBan.banned' => 'Gesperrt',
    'Home.IpBan.trusted' => 'Vertrauenswürdig',
    'Home.IpBan.more' => 'Mehr anzeigen',
    'Home.MailQueue.total' => 'Gesamt',
    'Home.MailQueue.deferred' => 'Zurückgestellt',
    'Home.MailQueue.held' => 'Gehalten',
    'Home.MailQueue.more' => 'Mehr anzeigen',
    'Home.MailQueue.clean' => 'E-Mail-Warteschlange leeren',
    'Home.MailQueue.checkLogs' => 'Protokoll einsehen',
    'Home.MailQueue.repair' => 'Reparieren',
    'Home.MailQueue.cleanConfirmQuestion' => 'E-Mail-Warteschlange leeren?',
    'Home.MailQueue.cleanConfirmYes' => 'Ja',
    'Home.MailQueue.cleanConfirmNo' => 'Nein',
    'Home.MailQueue.queueCleaned' => 'Die Mail-Warteschlange wurde erfolgreich gelöscht.',
    'Home.OverusedSubscriptions.empty' => 'Keine Abonnements mit Überbeanspruchung gefunden',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% von %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Alle mit Überbeanspruchung anzeigen: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'In der Liste öffnen',
    'Home.PromoNewHomeView.title' => 'Willkommen auf Ihrer neuen Startseite!',
    'Home.PromoNewHomeView.description' => 'Wenn Sie Probleme damit haben, geben Sie uns bitte Feedback. Es hilft uns dabei, Features weiter zu verbessern.',
    'Home.PromoNewHomeView.feedback' => 'Feedback geben',
    'Home.PromoNewHomeView.switch' => 'Zurück zur alten Startseitenansicht',
    'Home.ServerInfo.hostname' => 'Hostname',
    'Home.ServerInfo.ipAddress' => 'IP-Adresse',
    'Home.ServerInfo.publicIpAddress' => 'Öffentliche IP-Adresse',
    'Home.ServerInfo.os' => 'Betriebssystem',
    'Home.ServerInfo.uptime' => 'Erreichbarkeit',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# Tag} other {# Tage}} {hours, plural, one {# Stunde} other {# Stunden}} {minutes, plural, one {# Minute} other {# Minuten}}",
    'Home.ServerInfo.more' => 'Mehr anzeigen',
    'Home.Subscriptions.add' => 'Neue hinzufügen',
    'Home.Subscriptions.empty' => 'Sie können Abonnements erstellen, um mehrere Websites in einem isolierten Bereich auf dem Server zu hosten. %%link%%',
    'Home.Subscriptions.help' => 'Mehr erfahren',
    'Home.Updates.title' => 'Produkt-Updates',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% Update %%patch%%',
    'Home.Updates.manageComponents' => 'Komponenten hinzufügen oder entfernen',
    'Home.Updates.lastUpdated' => 'Zuletzt aktualisiert: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Auf Updates überprüfen',
    'Home.Updates.enableAutoupdate' => 'Automatische Updates zulassen',
    'Home.Updates.lastChecked' => 'Zuletzt geprüft: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => '%%availableVersion%% ist verfügbar',
    'Home.Updates.installNewVersion' => 'Jetzt installieren',
    'Home.Updates.patchAvailable' => 'Es sind Updates der Nebenversion verfügbar',
    'Home.Updates.patchAvailableVersion' => 'Updates der Nebenversion für %%currentVersion%% sind verfügbar',
    'Home.Updates.installPatch' => 'Jetzt aktualisieren',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Update für {package} ist} other {Updates für {package} sind}} verfügbar',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# Paket} other {# Pakete}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Jetzt aktualisieren} other {Alles aktualisieren}}',
    'Home.Promo.Customize.title' => 'Gestalten Sie das Dashboard ganz nach Ihren Vorstellungen!',
    'Home.Promo.Customize.content' => 'Mit dem neuen personalisierbaren Dashboard haben Sie die für Sie wichtigsten Funktionen immer im Blick',
    'Home.Promo.Customize.action' => 'Anpassen',
    'Home.Promo.SwitchToPuv.title' => 'Kennen Sie schon die Ansichten in der Benutzeroberfläche von Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Wenn Sie Ihren Kunden keine Hosting-Dienste im Rahmen von Service-Paketen anbieten, ist eventuell die Oberfläche geeigneter, die für die Verwaltung von Websites, deren Dateien, Datenbanken, E-Mail-Konten und Webanwendungen bequemer ist.',
    'Home.Promo.SwitchToPuv.action' => 'Jetzt ausprobieren',
    'Home.Status.error' => 'Fehler',
    'Home.Status.warning' => 'Warnung',
    'Home.Status.info' => 'Info',

    'HostingSettings.title' => 'Hosting-Einstellungen',
    'HostingSettings.updateSuccess' => 'Die Einstellungen wurden aktualisiert.',
    'HostingSettings.emptyLogin' => 'Sie müssen einen Benutzernamen angeben.',
    'HostingSettings.emptyPassword' => 'Sie müssen ein Passwort angeben.',
    'HostingSettings.ipV6OnlyNotSupported' => 'Der FTP-Server unterstützt kein IPv6 .Weisen Sie mindestens eine IPv4-Adresse zu, andernfalls wird der Benutzer nicht in der Lage sein, Dateien auf den Server via FTP hochzuladen.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Domaineinstellungen',
    'HostingSettings.domainSettingsSection.domainName' => 'Domainname',
    'HostingSettings.domainSettingsSection.description' => 'Zum Beispiel example.com ',

    'HostingSettings.submitPopover.title' => 'Inhalt von %%website%% entfernen',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Wenn Sie den Hostingtyp "Website" in "%%type%%" ändern, wird der gesamte Inhalt der Website, einschließlich der folgenden Verzeichnisse, dauerhaft entfernt:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Möchten Sie den Hosting-Typ für Ihre Website ändern?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Um auf weitere Einstellungen zuzugreifen, geben Sie die Anmeldedaten des Systembenutzers ein und klicken dann auf „Webspace erstellen“.',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Um auf weitere Einstellungen zuzugreifen, klicken Sie auf „Weiter“, um das Hosting zu erstellen.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Hosting-Typ',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Typ',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Webseite',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Weiterleitung',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Kein Webhosting',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Nutzen Sie die DNS-Zone der Domain, um Postfächer unter diesem Domainnamen zu verwenden.',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Der Pfad zum Basisverzeichnis der Website',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Bevorzugte Domain',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Die Besucher werden über eine SEO-freundliche HTTP 301-Weiterleitung hierher umgeleitet.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Besucher weiterleiten an',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Weiterleitungsart',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Dauerhaft verschoben (Code 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Leiten Sie Website-Besucher auf eine andere Website weiter und lassen Sie sie die Zieladresse sehen. Eine derartige Weiterleitung sorgt für den Erhalt des Suchmaschinen-Rankings der Website.',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Temporär verschoben (Code 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Leiten Sie Besucher auf eine temporäre Kopie der Website weiter, wenn Sie nicht wollen, dass Suchmaschinen die temporäre Website indexieren.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Frame-Weiterleitung',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Leiten Sie Besucher auf eine andere Website weiter, aber lassen Sie ihnen nicht die Zieladresse anzeigen, damit sie die Weiterleitung nicht bemerken.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Bevorzugte Domain',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Keine',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Dokumentstamm',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Der Dokumentstamm kann nicht geändert werden, da Webanwendungen auf dieser Website installiert sind.',
    'HostingSettings.domainSettingsSection.save' => 'Speichern',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Kompatibilitätsmodus',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Führen Sie die Website im Kompatibilitätsmodus für die veraltete Option zur Trennung von SSL/TLS-Inhalt und Inhalt ohne SSL/TLS aus.',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Diese Website wird im Kompatibilitätsmodus ausgeführt. Sie kann daher nicht über die Plesk Oberfläche verwaltet werden. Das liegt daran, dass Sie vor dem Upgrade die veraltete Option zur Trennung von SSL/TLS-Inhalt und Inhalt ohne SSL/TLS verwendet haben. Ab Plesk 11 werden über HTTP- und HTTPS-Verbindungen verfügbare Inhalte einer Website im selben Verzeichnis gespeichert. Wir empfehlen, alle Daten aus dem Verzeichnis `httpsdocs/` nach `httpdocs/` zu verschieben und dann den Kompatibilitätsmodus zu deaktivieren. Dadurch werden auch die im Verzeichnis `httpsdocs/` installierten Anwendungen über das Internet zugänglich. Beachten Sie, dass Sie den Kompatibilitätsmodus nicht wieder aktivieren können.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Diese Einstellung ändern?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Die Änderung dieser Einstellung widerspricht den Sicherheitsrichtlinien des Servers und kann die Leistung beeinträchtigen oder den Server anfällig für Angriffe machen.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Ändern',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Zurücksetzen',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Voreingestellte sichere Einstellungen werden angewendet',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Um die Sicherheit zu erhöhen, sollten Sie die vordefinierten sicheren Einstellungen verwenden. Beachten Sie, dass bestimmte Berechtigungen es den Abonnenten erlauben, diese Einstellungen zu ändern.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Vordefinierte sichere Einstellungen anwenden',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Weitere Informationen zu sicheren Hosting-Einstellungen',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'SSL/TLS-Unterstützung',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Aktiviert',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Verschlüsselung der Verbindungen zwischen der Website und dem Browser des Besuchers.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Zertifikat',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Um HTTPS zu aktivieren, laden Sie ein SSL/TLS-Zertifikat in das Repository der Domain hoch und wählen es dann hier aus.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Besucher über eine SEO-freundliche 301-Umleitung von HTTP zu HTTPS weiterleiten',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'Sie haben keine SSL/TLS-Zertifikate in Ihrem Repository. Um ein Zertifikat hinzuzufügen, gehen Sie zu %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'dieser Seite',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (anderes Repository)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Nicht ausgewählt',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Web-Scripting',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Wählen Sie aus, welche Programmier- und Skriptsprachen vom Webserver interpretiert werden müssen.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'cgi-bin-Verzeichnis befindet sich in %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'SSI für *.htm- und *.html-Dateien verwenden',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Microsoft ASP.NET-Version',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Benutzerdefinierte Fehlerdokumente',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'cgi-bin-Verzeichnis befindet sich in',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'Dokumentstamm dieser Domain',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'Stammverzeichnis des Webspaces',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'der Stamm dieser Domain im alten Stil',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Benutzerdefinierte Fehlerdokumente',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Zusätzliche Schreib-/ Änderungsrechte',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Veröffentlichen mit Web Deploy',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Webstatistiken',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Tool',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Zugriff auf meine Webstatistiken mit meinem FTP-Benutzernamen und Passwort schützen',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Deaktiviert',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Webspace-Einstellungen',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-Adressen',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Datenträgerkontingent',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Aktiviert',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Verhindern Sie den Zugriff auf die Dateien der Website, wenn das in den Abonnementeinstellungen festgelegte Speicherplatzkontingent (falls vorhanden) überschritten wird.',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Das Datenträgerkontingent wird aufgrund der Konfiguration des Dateisystems des Servers nicht unterstützt.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Anmeldedaten für Systembenutzer',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Verwalten Sie die Dateien und Verzeichnisse der Website über FTP oder den Dateimanager. Zugriff auf den Server über SSH, wenn erlaubt.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Verwalten Sie die Dateien und Verzeichnisse der Website über FTP oder den Dateimanager. Zugriff auf den Server über Remotedesktop, wenn erlaubt.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Benutzername',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Passwort',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Geben Sie hier ein neues Passwort ein, um das Passwort des Systembenutzers zu ändern.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'SSH-Zugriff',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Zugriff via Remotedesktop',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Aktiviert',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Mit den Zugangsdaten des Systembenutzers auf den Server zugreifen.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Typ',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Deaktiviert',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Für {count, plural, one {}other {# Domains}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Die folgenden Einstellungen gelten für alle {count, plural, one {}other {# Domains im Webspace {name}}}:',

    'OdbcAdd.title' => 'ODBC-DSN hinzufügen',
    'OdbcAdd.nameLabel' => 'Verbindungsname',
    'OdbcAdd.descriptionLabel' => 'Verbindungsbeschreibung',
    'OdbcAdd.driver' => 'Treiber',
    'OdbcAdd.submit' => 'ODBC-DSN-Verbindung erstellen',

    'OdbcEdit.title' => 'ODBC-Verbindung einrichten',
    'OdbcEdit.saveSuccess' => 'Die Einstellungen der Verbindung wurden gespeichert.',
    'OdbcEdit.test' => 'Verbindung testen',
    'OdbcEdit.connectSuccess' => 'Verbindung erfolgreich.',

    'OdbcEdit.excel.driver.label' => 'Treiber',
    'OdbcEdit.excel.dbq.label' => 'Pfad der Datenbankdatei',
    'OdbcEdit.excel.defaultdir.label' => 'Standard-Datenverzeichnis',
    'OdbcEdit.excel.fil.label' => 'Datenbankversion',
    'OdbcEdit.excel.maxbuffersize.label' => 'Maximale Puffergröße',
    'OdbcEdit.excel.pagetimeout.label' => 'Seiten-Timeout',

    'OdbcEdit.access.driver.label' => 'Treiber',
    'OdbcEdit.access.dbq.label' => 'Pfad der Datenbankdatei',
    'OdbcEdit.access.uid.label' => 'Login-ID',
    'OdbcEdit.access.pwd.label' => 'Passwort',
    'OdbcEdit.access.pagetimeout.label' => 'Seiten-Timeout',
    'OdbcEdit.access.pagetimeout.description' => 'Der Zeitraum in Zehntelsekunden, für die eine unbenutzte Seite im Puffer verbleibt. Diese Option gilt für alle Datenquellen, die den Microsoft Access-Treiber verwenden.',
    'OdbcEdit.access.maxbuffersize.label' => 'Maximale Puffergröße',
    'OdbcEdit.access.maxbuffersize.description' => 'Die Größe des internen Puffers in KB, ausgerichtet auf 256 KB-Grenze.',
    'OdbcEdit.access.readonly.label' => 'Schreibgeschützt',
    'OdbcEdit.access.readonly.description' => 'Kennzeichnet die Datenbank als schreibgeschützt, um Updates zu verhindern.',
    'OdbcEdit.access.exclusive.label' => 'Exklusiv',
    'OdbcEdit.access.exclusive.description' => 'Kennzeichnet die Datenbank als exklusiv, um gemeinsam verwendete Updates zu verhindern.',
    'OdbcEdit.access.safetransactions.label' => 'Sichere Transaktionen',
    'OdbcEdit.access.safetransactions.description' => 'Bei 0 (Standardwert) werden alle Transaktionen sofort ausgeführt. Bei 1 werden alle Transaktionen nur bei einer Ausführungsoperation auf dem Datenträger gespeichert, die Performance ist jedoch leicht vermindert.',
    'OdbcEdit.access.threads.label' => 'Threads',
    'OdbcEdit.access.threads.description' => 'Anzahl der Hintergrund-Threads, die die Maschine verwenden soll.',
    'OdbcEdit.access.maxscanrows.label' => 'Maximale Anzahl der zu prüfenden Zeilen',
    'OdbcEdit.access.maxscanrows.description' => 'Anzahl der zu durchsuchenden Zeilen bei Einstellen des Datentyps einer Spalte basierend auf vorhandenen Daten',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Gibt an, wie außerhalb einer Transaktion vorgenommene Änderungen in die Datenbank geschrieben werden.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Gibt an, ob der MS Access-Treiber explizite benutzerdefinierte Transaktionen asynchron ausführt.',

    'OdbcEdit.mssql.driver.label' => 'Treiber',
    'OdbcEdit.mssql.server.label' => 'Server',
    'OdbcEdit.mssql.uid.label' => 'Login-ID',
    'OdbcEdit.mssql.pwd.label' => 'Passwort',
    'OdbcEdit.mssql.database.label' => 'Standard-Datenbank',
    'OdbcEdit.mssql.app.label' => 'Anwendungsname',
    'OdbcEdit.mssql.wsid.label' => 'Workstation-ID',
    'OdbcEdit.mssql.language.label' => 'Standardsprache',
    'OdbcEdit.mssql.oemtoansi.label' => 'Konvertierung der erweiterten Zeichen in OEM-Werte',

    'OdbcEdit.mysql.driver.label' => 'MySQL-ODBC-Treiber',
    'OdbcEdit.mysql.server.label' => 'Server',
    'OdbcEdit.mysql.server.description' => 'Hostname des MariaDB/MySQL-Servers',
    'OdbcEdit.mysql.database.label' => 'Standard-Datenbank',
    'OdbcEdit.mysql.user.label' => 'Benutzername',
    'OdbcEdit.mysql.user.description' => 'Der Benutzername für die Verbindung mit MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Passwort',
    'OdbcEdit.mysql.password.description' => 'Passwort für das Benutzerkonto auf dem Server',
    'OdbcEdit.mysql.port.label' => 'Port',
    'OdbcEdit.mysql.port.description' => 'Zu verwendender TCP/IP-Port, wenn der Server nicht der Local Host ist.',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => '(Von) Windows benannte Verbindungsleitung, wenn der Server der Local Host ist.',
    'OdbcEdit.mysql.option.label' => 'Option',
    'OdbcEdit.mysql.option.description' => 'Optionen, die die Funktionen von MyODBC bestimmen. <<a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">Weitere Informationen</a>',

    'ProtectedDirectoryList.add' => 'Geschütztes Verzeichnis hinzufügen',
    'ProtectedDirectoryList.addTooltip' => 'Erstellen Sie ein geschütztes Verzeichnis.',
    'ProtectedDirectoryList.name' => 'Name',
    'ProtectedDirectoryList.realmTitle' => 'Titel des geschützten Bereichs',
    'ProtectedDirectoryList.noSelectionText' => 'Wählen Sie mindestens ein Element aus, das entfernt werden soll.',
    'ProtectedDirectoryList.edit' => 'Bearbeiten',
    'ProtectedDirectoryList.remove' => 'Schutz entfernen',
    'ProtectedDirectoryList.removeTooltip' => 'Schutz für ausgewählte Verzeichnisse entfernen.',
    'ProtectedDirectoryList.removeConfirmation' => 'Dieser Vorgang führt dazu, dass der Schutz {count, plural, one {}=1 {des Verzeichnisses „{name}“} other {# ausgewählten Verzeichnissen}} entfernt wird. {count, plural, one {}=1 {Dieses Verzeichnis} other {Die Verzeichnisse}} werden für Internetnutzer frei zugänglich sein.',
    'ProtectedDirectoryList.removeSuccess' => 'Die ausgewählten Verzeichnisse wurden entfernt.',

    'ProtectedDirectoryAdd.title' => 'Erstellen Sie ein geschütztes Verzeichnis',
    'ProtectedDirectoryAdd.submit' => 'Erstellen',
    'ProtectedDirectoryAdd.success' => 'Das geschützte Verzeichnis %%path%% wurde erfolgreich erstellt',

    'ProtectedDirectoryEdit.title' => 'Geschützte Verzeichnis-Einstellungen',
    'ProtectedDirectoryEdit.success' => 'Geschützte Verzeichnis-Einstellungen wurden geändert',

    'ProtectedDirectoryUserAdd.title' => 'Benutzer für geschütztes Verzeichnis erstellen',
    'ProtectedDirectoryUserAdd.subtitle' => 'Verzeichnis %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Benutzername',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Passwort',
    'ProtectedDirectoryUserAdd.submit' => 'Erstellen',
    'ProtectedDirectoryUserAdd.success' => 'Der Benutzer %%login%% des geschützten Verzeichnisses wurde erstellt.',

    'ProtectedDirectoryUserPassword.title' => 'Passwort für den Benutzer des geschützten Verzeichnisses',
    'ProtectedDirectoryUserPassword.subtitle' => 'Benutzer %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Passwort',
    'ProtectedDirectoryUserPassword.submit' => 'Speichern',
    'ProtectedDirectoryUserPassword.success' => 'Die Benutzeranmeldeinformationen wurden gespeichert.',

    'SummaryReport.Layout.title' => 'Berichtlayout-Eigenschaften',
    'SummaryReport.Layout.success' => 'Berichtlayout %%name%% wurde aktualisiert.',

    'SummaryReport.Layout.Add.title' => 'Berichtlayout erstellen',
    'SummaryReport.Layout.Add.success' => 'Berichtlayout %%name%% wurde erstellt.',

    'SummaryReport.Report.buttonLayouts' => 'Layouts',
    'SummaryReport.Report.buttonSchedule' => 'Zeitplan',
    'SummaryReport.Report.buttonProperties' => 'Eigenschaften',
    'SummaryReport.Report.buttonTrafficHistory' => 'Traffic-Verlauf',
    'SummaryReport.Report.buttonPrint' => 'Drucken',
    'SummaryReport.Report.buttonSend' => 'Per E-Mail senden',
    'SummaryReport.Report.successSent' => 'Der Bericht wurde an %%email%% versendet',

    'SummaryReport.Schedule.Properties.title' => 'Zustellungsplan für %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Berichtzustellungsplan wurde aktualisiert.',

    'SummaryReport.Schedule.Add.title' => 'Zustellungspläne für %%name%% erstellen',
    'SummaryReport.Schedule.Add.success' => 'Berichtzustellungsplan wurde erstellt.',

    'VirtualDirectory.errNotExist' => 'Dieses virtuelle Verzeichnis ist mit einem nicht existierenden physischen Ordner verknüpft.',
    'VirtualDirectory.errNoPermissions' => 'Sie haben keine Berechtigung, den Inhalt dieses Verzeichnisses zu sehen.',
    'VirtualDirectory.buttonProperties' => 'Verzeichnis-eigenschaften',
    'VirtualDirectory.buttonPropertiesHint' => 'Eigenschaften von virtuellem Verzeichnis anzeigen und ändern.',
    'VirtualDirectory.buttonPermissions' => 'Verzeichniszugriffs-berechtigungen',
    'VirtualDirectory.buttonPermissionsHint' => 'Richten Sie Verzeichniszugriffsberechtigungen ein.',
    'VirtualDirectory.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.buttonAspDotNetHint' => 'ASP.NET-Einstellungen konfigurieren.',
    'VirtualDirectory.buttonPhp' => 'PHP',
    'VirtualDirectory.buttonPhpHint' => 'PHP-Einstellungen konfigurieren.',
    'VirtualDirectory.tabBrowse' => 'Verzeichnisse',
    'VirtualDirectory.tabBrowseHint' => 'Arbeiten Sie mit physischen und virtuellen Dateien und Verzeichnissen unter der Website %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'MIME-Typen',
    'VirtualDirectory.tabMimeTypesHint' => 'Registrierte MIME-Typen verwalten.',
    'VirtualDirectory.tabErrorDocs' => 'Fehlerdokumente',
    'VirtualDirectory.tabErrorDocsHint' => 'Fehlerdokumente verwalten.',
    'VirtualDirectory.tabProtection' => 'Schutz',
    'VirtualDirectory.tabProtectionHint' => 'Schränken Sie den Zugriff auf das Verzeichnis durch einen Passwortschutz ein.',

    'VirtualDirectory.errorDocType.default' => 'Standard',
    'VirtualDirectory.errorDocType.file' => 'Datei',
    'VirtualDirectory.errorDocType.url' => 'URL',

    'VirtualDirectory.CreateDirectory.title' => 'Verzeichnis erstellen',
    'VirtualDirectory.CreateDirectory.name' => 'Verzeichnisname',
    'VirtualDirectory.CreateDirectory.success' => 'Das Verzeichnis %%name%% wurde erstellt.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Das Verzeichnis %%name%% existiert bereits.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Virtuelles Verzeichnis erstellen',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'Das Verzeichnis %%name%% wurde erstellt.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Eigenschaften von virtuellem Verzeichnis',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Das virtuelle Verzeichnis wurde bearbeitet.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Schließen',

    'VirtualDirectory.MimeTypeList.add' => 'MIME-Typ hinzufügen',
    'VirtualDirectory.MimeTypeList.edit' => 'MIME-Typ bearbeiten',
    'VirtualDirectory.MimeTypeList.addHint' => 'Neuen MIME-Typ registrieren.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Erweiterung',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Inhalt',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Wählen Sie mindestens ein Element aus, das entfernt werden soll.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Möchten Sie {count, plural, =1 {den ausgewählten MIME-Typ} one {den # ausgewählten MIME-Typ #} other {die # ausgewählten MIME-Typen}} entfernen?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Die ausgewählten MIME-Typen wurden entfernt.',

    'VirtualDirectory.CreateMimeType.title' => 'MIME-Typ hinzufügen',
    'VirtualDirectory.CreateMimeType.success' => 'Der neue MIME-Typ wurde registriert.',

    'VirtualDirectory.EditMimeType.title' => 'MIME-Typ bearbeiten',
    'VirtualDirectory.EditMimeType.success' => 'Der MIME-Typ wurde bearbeitet.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Fehler',
    'VirtualDirectory.ErrorDocList.columnName' => 'Beschreibung',
    'VirtualDirectory.ErrorDocList.columnType' => 'Typ',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Ort',
    'VirtualDirectory.ErrorDocList.edit' => 'Bearbeiten',

    'VirtualDirectory.EditErrorDoc.title' => 'Fehlerdokument bearbeiten',
    'VirtualDirectory.EditErrorDoc.success' => 'Das Fehlerdokument wurde bearbeitet.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Fehler',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Typ',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Ort',

    'VirtualDirectory.Protection.notSupported' => 'Verzeichnisschutz wird für dieses Verzeichnis nicht unterstützt, da der Name entweder länger als 245 Zeichen ist oder dieser nicht unterstützte Zeichen enthält.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Schutz für virtuelle Verzeichnisse ist deaktiviert',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Schützen',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'Das Verzeichnis %%path%% ist nun geschützt.',
    'VirtualDirectory.Protection.tools' => 'Tools',
    'VirtualDirectory.Protection.removeProtection' => 'Schutz entfernen',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Erstellen Sie eine URL, die dem für alle zugänglichen Verzeichnis entspricht.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Schutz für das virtuelle Verzeichnis entfernen? Dadurch werden alle Benutzer des geschützten Verzeichnisses sowie die Einstellungen für den Verzeichnisschutz entfernt.',
    'VirtualDirectory.Protection.settings' => 'Einstellungen',
    'VirtualDirectory.Protection.settingsTooltip' => 'Speicherort des Verzeichnisses anzeigen und einen Titel für den geschützten Bereich angeben.',

    'VirtualDirectory.AspDotNet.title' => 'ASP.NET-Einstellungen konfigurieren',

    'VirtualDirectory.Php.title' => 'PHP-Version',
    'VirtualDirectory.Php.version' => 'Version',
    'VirtualDirectory.Php.success' => 'PHP-Version wurde aktualisiert.',


    'MassMailPage.sendEmail' => 'Massen-E-Mail senden',
    'MassMailPage.selectAtLeastOneTemplate' => 'Wählen Sie mindestens ein Template aus',
    'MassMailPage.confirmRemoval' => 'Sind Sie sicher, dass Sie {count, select, 1 {das ausgewählte Template} other {die ausgewählten Templates}} entfernen möchten?',
    'MassMailPage.remove' => 'Entfernen',
    'MassMailPage.filters' => 'Filter',
    'MassMailPage.name' => 'Template-Name',
    'MassMailPage.sender' => 'Absender',
    'MassMailPage.recipients' => 'Empfänger',
    'MassMailPage.subject' => 'Betreff',
    'MassMailPage.created' => 'Erstellungsdatum',
    'MassMailPage.send' => 'Senden',
    'MassMailPage.recipientsNone' => 'Keiner',
    'MassMailPage.recipientsAdmins' => 'Administrator',
    'MassMailPage.recipientsResellers' => 'Alle Reseller',
    'MassMailPage.recipientsResellersSelected' => 'Ausgewählte Reseller',
    'MassMailPage.recipientsResellersExcept' => 'Alle Reseller außer den ausgewählten',
    'MassMailPage.recipientsClients' => 'Alle Kunden',
    'MassMailPage.recipientsClientsSelected' => 'Ausgewählte Kunden',
    'MassMailPage.recipientsClientsExcept' => 'Alle Kunden außer den ausgewählten',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {Template} other {Templates}} entfernt.',
    'MassMailPage.emptyViewTitle' => 'Keine Massen-E-Mail-Templates',
    'MassMailPage.addNew' => 'Template erstellen',
    'CreateMassMailTemplatePage.templateCreated' => 'Das Template wurde erstellt.',
    'EditMassMailTemplatePage.templateUpdated' => 'Das Template wurde aktualisiert.',
    'SendMassMailPage.emailSent' => 'Die E-Mail wurde gesendet.',
    'SendMassMailPage.fieldIsRequired' => 'Das Feld darf nicht leer sein',
    'SendMassMailPage.saveAsTemplate' => 'Verfasste Nachricht als neues Template speichern',
    'SendMassMailPage.newTemplateName' => 'Neuer Template-Name',
    'SendMassMailPage.selectedTemplate' => 'Ausgewähltes Template',
    'SendMassMailPage.send' => 'Senden',
    'VirtualHostTemplatePage.name' => 'Name',
    'VirtualHostTemplatePage.sizeInBytes' => 'Größe',
    'VirtualHostTemplatePage.modified' => 'Änderungsdatum',
    'VirtualHostTemplatePage.permissions' => 'Berechtigungen',
    'VirtualHostTemplatePage.user' => 'Benutzer',
    'VirtualHostTemplatePage.group' => 'Gruppe',
    'VirtualHostTemplatePage.uploadTemplate' => 'Hochladen',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Die Vorlage wurde hochgeladen.',
    'VirtualHostTemplatePage.root' => 'Virtuelle Vorlage-Verzeichnis',
    'VirtualHostTemplatePage.emptyViewTitle' => 'Keine Dateien in der Vorlage',
    'VirtualHostTemplatePage.total' => 'Anzahl Gegenstände im Verzeichnis {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Als Standard festlegen',
    'VirtualHostTemplatePage.successfullyReset' => 'Die Vorlage wurde zu Standard geändert.',

    'TrafficUsageByDomain.List.service' => 'Dienst',
    'TrafficUsageByDomain.List.usage' => 'Verwendet',
    'TrafficUsageByDomain.List.incoming' => 'In',
    'TrafficUsageByDomain.List.outgoing' => 'Aus',
    'TrafficUsageByDomain.List.percentOfAll' => '% von allen',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Domainname',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Besitzername",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Verwendet',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Grenzwert',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Verfügbar',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Verbrauch (in %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Nur meine Domains',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Nur Reseller-Domains',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Besitzername',

    'TrafficUsageByReseller.emptyView' => 'Der Reseller hat keine Kunden',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Domains des Resellers",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Reseller-Kundendomains: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Information und Statistiken',
    'InfoAndStatistics.Main.overview' => 'Überblick',
    'InfoAndStatistics.Main.domains' => 'Domains',
    'InfoAndStatistics.Main.trafficUsage' => 'Traffic-Nutzung',
    'InfoAndStatistics.Main.reports' => 'Berichte',
    'InfoAndStatistics.Main.serverSettings' => 'Servereinstellungen',
    'InfoAndStatistics.TrafficUsage.customers' => 'Kunden',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Reseller',
    'InfoAndStatistics.TrafficUsage.domains' => 'Domains',

    'ConfigureMailClient.title' => 'E-Mail-Client auswählen',
    'ConfigureMailClient.description' => 'Zur automatischen Einrichtung von %%email%%',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Manuell',
    'ConfigureMailClient.Common.email' => 'Email:',
    'ConfigureMailClient.Common.start' => 'Starten',
    'ConfigureMailClient.Common.finish' => 'Fertigstellen',
    'ConfigureMailClient.Common.next' => 'Weiter',
    'ConfigureMailClient.Common.prev' => 'Zurück',
    'ConfigureMailClient.Common.back' => 'Zurück',
    'ConfigureMailClient.Common.manualLink' => 'Probleme beim Hinzufügen Ihres E-Mail-Kontos? Versuchen Sie die manuelle Einrichtung.',
    'ConfigureMailClient.Thunderbird.title' => 'E-Mail-Konto einrichten',
    'ConfigureMailClient.Thunderbird.description' => 'Folgen Sie der Anleitung, um Ihr E-Mail-Konto in Mozilla Thunderbird hinzuzufügen.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Thunderbird öffnen',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Öffnen Sie Thunderbird auf Ihrem Computer und klicken Sie dann im Hauptmenü von Thunderbird auf "Konten-Einstellungen".',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Konto hinzufügen',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Klicken Sie auf ”Konten-Aktionen” und dann auf "E-Mail-Konto hinzufügen".',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Informationen eingeben',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Geben Sie Ihren Namen so ein, wie er in allen von Ihnen gesendeten Nachrichten erscheinen soll. Geben Sie außerdem Ihre E-Mail-Adresse und Ihr Passwort ein und klicken Sie dann auf "Weiter".',
    'ConfigureMailClient.Thunderbird.step4.title' => 'Fertig!',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Es wird nun versucht, Ihr E-Mail-Konto automatisch in Thunderbird hinzuzufügen.',

    'ConfigureMailClient.Outlook.title' => 'E-Mail-Konto einrichten',
    'ConfigureMailClient.Outlook.warning' => 'Wir können Ihr E-Mail-Konto nicht automatisch in Outlook 2019 oder höher hinzufügen.',
    'ConfigureMailClient.Outlook.warningTooltip' => 'Wir nutzen die automatische Erkennung, um E-Mail-Konten automatisch hinzuzufügen. Outlook-Versionen ab Outlook 2019 nutzen Microsoft-Proxy-Server für Anfragen zur automatischen Erkennung, welche von Plesk oder der Plesk Premium Email-Erweiterung nicht unterstützt werden.',
    'ConfigureMailClient.Outlook.description' => 'Folgen Sie der Anleitung, um Ihr E-Mail-Konto in Microsoft Office Outlook 2016 hinzuzufügen.',
    'ConfigureMailClient.Outlook.step1.title' => 'Neues Konto hinzufügen',
    'ConfigureMailClient.Outlook.step1.description' => 'Öffnen Sie Outlook 2016 auf Ihrem Computer und gehen Sie dann zum Tab "Datei".',
    'ConfigureMailClient.Outlook.step2.title' => 'Neues Konto hinzufügen',
    'ConfigureMailClient.Outlook.step2.description' => 'Klicken Sie auf "Konto hinzufügen".',
    'ConfigureMailClient.Outlook.step3.title' => 'E-Mail-Adresse eingeben',
    'ConfigureMailClient.Outlook.step3.description' => 'Geben Sie Ihre E-Mail-Adresse ein.',
    'ConfigureMailClient.Outlook.step4.title' => 'Passwort eingeben',
    'ConfigureMailClient.Outlook.step4.description' => 'Geben Sie das Passwort für Ihr E-Mail-Konto ein und klicken Sie auf "Verbinden".',
    'ConfigureMailClient.Outlook.step5.title' => 'Fertig!',
    'ConfigureMailClient.Outlook.step5.description' => 'Klicken Sie auf "OK", um die Einrichtung des Kontos abzuschließen.',

    'ConfigureMailClient.Gmail.title' => 'E-Mail-Konto einrichten',
    'ConfigureMailClient.Gmail.description' => 'Folgen Sie der Anleitung, um Ihr E-Mail-Konto in der Gmail-App auf Ihrem Mobilgerät hinzuzufügen.',
    'ConfigureMailClient.Gmail.step1.title' => 'Neues Konto hinzufügen',
    'ConfigureMailClient.Gmail.step1.description1' => 'Öffnen Sie die Gmail-App auf Ihrem Android-Telefon. Tippen Sie oben rechts auf Ihr Profilbild.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Tippen Sie auf "Weiteres Konto hinzufügen".',
    'ConfigureMailClient.Gmail.step1.description3' => 'Tippen Sie auf "Sonstige".',
    'ConfigureMailClient.Gmail.step2.title' => 'E-Mail-Adresse eingeben',
    'ConfigureMailClient.Gmail.step2.description' => 'Geben Sie Ihre E-Mail-Adresse ein und tippen Sie auf "Weiter".',
    'ConfigureMailClient.Gmail.step3.title' => 'Kontotyp auswählen',
    'ConfigureMailClient.Gmail.step3.description' => 'Wenn Sie Kopien der heruntergeladenen E-Mail-Nachrichten auf dem Server speichern möchten, tippen Sie auf "Privat (IMAP)". Um heruntergeladene E-Mail-Nachrichten vom Server zu löschen, tippen Sie auf "Privat (POP3)".',
    'ConfigureMailClient.Gmail.step4.title' => 'Passwort eingeben',
    'ConfigureMailClient.Gmail.step4.description' => 'Geben Sie das Passwort für Ihr E-Mail-Konto ein und tippen Sie auf "Weiter".',
    'ConfigureMailClient.Gmail.step5.title' => 'Einstellungen zum Entfernen von E-Mails',
    'ConfigureMailClient.Gmail.step5.description' => 'Geben Sie an, ob in der App gelöschte E-Mails auch vom Server gelöscht werden sollen. Tippen Sie dann auf "Weiter".',
    'ConfigureMailClient.Gmail.step6.title' => 'Konto-Optionen',
    'ConfigureMailClient.Gmail.step6.description1' => 'Die Einstellungen des Ausgangsservers werden automatisch in der App abgerufen.',
    'ConfigureMailClient.Gmail.step6.description2' => 'Ändern Sie gegebenenfalls die Standardoptionen für das Konto und tippen Sie dann auf "Weiter".',
    'ConfigureMailClient.Gmail.step7.title' => 'Fertig!',
    'ConfigureMailClient.Gmail.step7.description1' => '(Optional) Geben Sie Ihren Namen ein, so wie er in gesendeten Nachrichten angezeigt werden soll.',
    'ConfigureMailClient.Gmail.step7.description2' => 'Tippen Sie auf "Weiter", um die Einrichtung des Kontos abzuschließen.',

    'ConfigureMailClient.Ios.title' => 'E-Mail-Konto einrichten',
    'ConfigureMailClient.Ios.description' => 'Scannen Sie den QR-Code oder öffnen Sie den Link unten auf Ihrem iOS-Gerät, um Ihr E-Mail-Konto automatisch in der iOS Mail-App hinzuzufügen.',
    'ConfigureMailClient.Ios.link'  =>  'Konto in iOS Mail hinzufügen',

    'ConfigureMailClient.Manual.title' => 'E-Mail-Konto manuell einrichten',
    'ConfigureMailClient.Manual.description' => 'Verwenden Sie die folgenden Werte beim Hinzufügen von %%email%% in Ihrem E-Mail-Client.',
    'ConfigureMailClient.Manual.username' => 'Mailserver-Benutzername:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Postausgangsserver (erfordert Authentifizierung):',
    'ConfigureMailClient.Manual.incomingServer' => 'Posteingangsserver:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Unterstützte Protokolle für eingehende E-Mails:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Unterstützte Protokolle für ausgehende E-Mails:',


    'Databases.Page.title' => 'Datenbanken für %%database%%',
    'Databases.Page.databaseTab' => 'Datenbanken',
    'Databases.Page.userTab' => 'Benutzerverwaltung',
    'Databases.Page.serversLink' => 'Datenbankserver',
    'Databases.Page.backupLink' => 'Backup-Manager',

    'Databases.List.add' => 'Datenbank hinzufügen',
    'Databases.List.find' => 'Datenbank suchen...',
    'Databases.List.databaseColumn' => 'Datenbank',
    'Databases.List.relatedToColumn' => 'Verknüpft mit',
    'Databases.List.relatedToDomains' => 'Gehört zu %%domains%%',
    'Databases.List.noRelatedDomains' => 'Diese Datenbank einer Website zuweisen',
    'Databases.List.noDomainRelations' => 'Keine verknüpften Websites',
    'Databases.List.changeRelatedDomain' => 'Ändern',
    'Databases.List.connectionInfo' => 'Informationen zur Verbindung',
    'Databases.List.downloadDump' => 'Abbild exportieren',
    'Databases.List.uploadDump' => 'Abbild importieren',
    'Databases.List.copy' => 'Datenbank kopieren',
    'Databases.List.checkDatabase' => 'Überprüfen und reparieren',
    'Databases.List.assignToSubscription' => 'Zu Abonnement verschieben',
    'Databases.List.assignToSubscription_powerUser' => 'Zu Webspace verschieben',
    'Databases.List.remove' => 'Entfernen',
    'Databases.List.removeConfirmation' => 'Datenbank %%name%% entfernen?',
    'Databases.List.removeButtonDisabledHint' => 'Diese Datenbank kann nicht entfernt werden, weil sie von einer installierten Webanwendung verwendet wird.',
    'Databases.List.databaseRemoved' => 'Die Datenbank wurde entfernt.',
    'Databases.List.downloadMsSqlClient' => 'Lokalen SQL-Client herunterladen',
    'Databases.List.downloadMsSqlClientHint' => 'Lokalen SQL-Client herunterladen',
    'Databases.List.webadmin' => 'Web Admin',
    'Databases.List.webadminHint' => 'Greifen Sie via Webadmin der Datenbank auf diesen Server zu.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => 'Das Abbild kann nicht %%action%% werden: Das Abonnement ist gesperrt.',
    'Databases.List.dumpExport' => 'exportiert',
    'Databases.List.dumpImport' => 'importiert',

    'Databases.DatabaseSummary.host' => 'Host',
    'Databases.DatabaseSummary.serverUnavailable' => 'Der Server ist nicht verfügbar.',
    'Databases.DatabaseSummary.user' => 'Benutzer',
    'Databases.DatabaseSummary.users' => 'Benutzer',
    'Databases.DatabaseSummary.noUser' => 'Keine Datenbankbenutzer',
    'Databases.DatabaseSummary.seeAll' => 'Alle anzeigen',
    'Databases.DatabaseSummary.createUser' => 'Benutzer erstellen',
    'Databases.DatabaseSummary.calculatingSize' => 'Berechnen der Größe...',
    'Databases.DatabaseSummary.tablesCount' => 'Tabellen',
    'Databases.DatabaseSummary.size' => 'Größe',

    'Databases.InPlaceSelect.editButtonHint' => 'Bearbeiten',
    'Databases.InPlaceSelect.saveButtonHint' => 'Speichern',
    'Databases.InPlaceSelect.closeButtonHint' => 'Abbrechen',

    'Databases.ConnectionInfo.title' => 'Verbindungsdetails',
    'Databases.ConnectionInfo.description' => 'für die Datenbank %%database%%',
    'Databases.ConnectionInfo.hint' => 'Sie können diese Verbindungsdetails für die Datenbank zum Beispiel bei der Installation einer Webanwendung verwenden.',
    'Databases.ConnectionInfo.host' => 'Host',
    'Databases.ConnectionInfo.databaseName' => 'Datenbankname',
    'Databases.ConnectionInfo.user' => 'Benutzername',
    'Databases.ConnectionInfo.password' => 'Passwort',
    'Databases.ConnectionInfo.noDefaultUser' => 'Kein Standardbenutzer',

    'Databases.Add.title' => 'Datenbank hinzufügen',
    'Databases.Add.name' => 'Datenbankname',
    'Databases.Add.server' => 'Datenbankserver',
    'Databases.Add.versionCut' => 'v%%version%%',
    'Databases.Add.relatedDomain' => 'Zugehörige Website',
    'Databases.Add.noDomainRelations' => 'Keine zugehörigen Websites',
    'Databases.Add.userSection' => 'Benutzer',
    'Databases.Add.userSectionDescription' => 'Erstellen Sie einen Standard-Datenbankbenutzer. Plesk greift im Namen dieses Benutzers auf die Datenbank zu. Sollten dieser Datenbank keine Datenbankbenutzer zugewiesen sein, kann nicht darauf zugegriffen werden.',
    'Databases.Add.createUser' => 'Datenbankbenutzer erstellen',
    'Databases.Add.username' => 'Datenbankbenutzername',
    'Databases.Add.password' => 'Passwort',
    'Databases.Add.passwordConfirmation' => 'Passwort bestätigen',
    'Databases.Add.allDbAccess' => 'Der Benutzer hat Zugriff auf alle Datenbanken innerhalb des ausgewählten Abonnements',
    'Databases.Add.aclRadio' => 'Zugriffssteuerung',
    'Databases.Add.aclLocalhost' => 'Nur lokale Verbindungen zulassen',
    'Databases.Add.aclAny' => 'Remoteverbindungen von beliebigem Host zulassen',
    'Databases.Add.aclCustom' => 'Remoteverbindungen zulassen von',
    'Databases.Add.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nDie angegebenen Hosts dürfen im Namen dieses Benutzers auf die Datenbank zugreifen.",
    'Databases.Add.remoteAccess' => 'Remotezugriff',
    'Databases.Add.remoteAccessDenied' => 'Firewallregeln des Systems verwenden',
    'Databases.Add.remoteAccessAllowed' => 'Remoteverbindungen zulassen von',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nDie angegebenen IP-Adressen dürfen durch eine Firewall-Regel auf den Datenbankserver zugreifen. Ihre Änderungen an dieser Liste werden vorab von Ihrem Hosting-Provider moderiert.",
    'Databases.Add.remoteAccessHint' => 'Bitte wenden Sie sich an Ihren Hosting-Provider und stellen Sie sicher, dass die oben gewählte Option den aktuell geltenden Firewallregeln für externe Zugriffe auf MariaDB/MySQL entspricht.',
    'Databases.Add.example' => "Zum Beispiel:\n%%example%%",
    'Databases.Add.denied' => 'Firewallregeln des Systems verwenden',
    'Databases.Add.allowed' => 'Remoteverbindungen zulassen von',
    'Databases.Add.databaseCreated' => 'Die Datenbank %%name%% wurde erstellt.',
    'Databases.Add.create' => 'Datenbank erstellen',

    'Databases.Clone.title' => 'Datenbank kopieren',
    'Databases.Clone.clone' => 'OK',
    'Databases.Clone.warning' => 'Warnung: Wenn die Tabellennamen übereinstimmen, wird die Tabelle in der Quelle die Tabelle im Ziel ersetzen.',
    'Databases.Clone.formDescription' => 'Kopieren Sie die Datenbankinhalte in eine neue oder eine bestehende Datenbank. Werden sie in eine bestehende Datenbank kopiert, werden die Tabellen der Quelldatenbank zur Liste der Tabellen in der Zieldatenbank hinzugefügt.',
    'Databases.Clone.copyData' => 'Vollständige Kopie erstellen',
    'Databases.Clone.copyDataHint' => 'Ist diese Option ausgewählt, wird die gesamte Datenbank (einschl. Struktur und Daten) kopiert. Wenn diese Option nicht ausgewählt ist, wird nur die Struktur der Tabellen kopiert.',
    'Databases.Clone.copyHint' => 'Die Datenbank "%%databaseName%%" wird kopiert',
    'Databases.Clone.server' => 'Zieldatenbankserver',
    'Databases.Clone.versionCut' => 'v%%version%%',
    'Databases.Clone.externalServer' => 'Sonstige...',
    'Databases.Clone.database' => 'Zieldatenbank',
    'Databases.Clone.newDatabase' => 'Datenbank mit folgendem Namen erstellen',
    'Databases.Clone.newDatabaseName' => 'Name der neuen Datenbank',
    'Databases.Clone.existingDatabaseName' => 'Name der vorhandenen Datenbank',
    'Databases.Clone.existingDatabase' => 'In vorhandene Datenbank kopieren',
    'Databases.Clone.externalDbHost' => 'Hostname oder IP-Adresse',
    'Databases.Clone.externalDbLogin' => 'Benutzername',
    'Databases.Clone.externalDbPassword' => 'Passwort',
    'Databases.Clone.subscription' => 'Ziel-Abonnement',
    'Databases.Clone.subscription_powerUser' => 'Ziel-Webspace',
    'Databases.Clone.cloneInProgress' => 'Datenbank %%source%% wird in die Datenbank %%destination%% geklont. Sie werden per E-Mail (%%email%%) über den Fortschritt benachrichtigt.',
    'Databases.Clone.unableToClone' => 'Datenbank "%%source%%" kann nicht kopiert werden.',
    'Databases.Clone.unableToCreateExternalDatabase' => 'Die Datenbank "%%destination%%" kann auf dem angegebenen Server nicht erstellt werden.',
    'Databases.Clone.databaseCloned' => 'Die Datenbank "%%source%%" wurde kopiert.',
    'Databases.Clone.emailSubjSuccess' => 'Die Datenbank "%%sourceDatabase%%" wurde kopiert.',
    'Databases.Clone.emailSubjFailure' => 'Die Datenbank "%%sourceDatabase%%" konnte nicht kopiert werden.',
    'Databases.Clone.emailBodySuccess' => 'Die Datenbank "%%sourceDatabase%%" (%%sourceHost%%) wurde in die Datenbank "%%destDatabase%%" (%%destHost%%) kopiert.',
    'Databases.Clone.emailBodyFailure' => 'Die Datenbank "%%sourceDatabase%%" (%%sourceHost%%) kann nicht in die Datenbank "%%destDatabase%%" (%%destHost%%) kopiert werden. Der Kopiervorgang wurde abgebrochen.',
    'Databases.Clone.localServer' => 'lokaler Server',

    "Databases.Import.confirm" => 'Abbild importieren',
    'Databases.Import.recreateDatabase' => 'Datenbank neu erstellen',
    'Databases.Import.rootDirectory' => 'Stammverzeichnis',
    'Databases.Import.uploadFromFile' => 'Abbild vom lokalen Computer hochladen',
    'Databases.Import.uploadFromWebspace' => 'Abbild vom Hosting-Server importieren',
    'Databases.Import.uploadHint' => 'Sie importieren ein Abbild in "%%databaseName%%"',
    'Databases.Import.uploadPopupTitle' => 'Datenbankabbild importieren',
    'Databases.Import.uploading' => 'Importiere...',
    'Databases.Import.waitMessage' => 'Bitte warten...',

    "Databases.Export.confirm" => 'Abbild exportieren',
    'Databases.Export.downloadDumpAutomatically' => 'Abbild automatisch nach der Erstellung herunterladen',
    'Databases.Export.downloadDumpName' => 'Name der Abbilddatei',
    'Databases.Export.downloadHint' => 'Sie sind dabei, ein Abbild von "%%database%%" zu erstellen und es herunterzuladen',
    'Databases.Export.downloadPopupTitle' => 'Abbild exportieren',
    'Databases.Export.downloadRelativePath' => 'Abbild in folgendem Verzeichnis speichern',
    'Databases.Export.rootDirectory' => 'Stammverzeichnis',
    'Databases.Export.waitMessage' => 'Bitte warten...',

    'Databases.MoveToSubscription.title' => 'Datenbanken zu anderem Abonnement verschieben',
    'Databases.MoveToSubscription.title_powerUser' => 'Datenbanken zu anderem Webspace verschieben',
    'Databases.MoveToSubscription.description' => 'Die Datenbank "%%name%%" wird verschoben',
    'Databases.MoveToSubscription.hint' => 'Die ausgewählten Datenbanken werden in das ausgewählte Abonnement verschoben. Datenbankbenutzer werden ebenfalls verschoben, es sei denn, sie haben Zugriff auf andere Datenbanken. Benutzer, die bisher auf die Datenbank zugreifen konnten, können sie nach dem Verschieben nicht mehr über den Link in Plesk öffnen.',
    'Databases.MoveToSubscription.subscriptionName' => 'Zu Abonnement verschieben',
    'Databases.MoveToSubscription.subscriptionName_powerUser' => 'Zu Webspace verschieben',
    'Databases.MoveToSubscription.save' => 'Datenbank verschieben',

];