<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'cgroups.size' => 'Valor no válido: "%value%". El valor debe ser igual o superior a %unitMin%, igual o inferior a %unitMax% y no puede ser 0.',
    'cgroups.unlimited' => 'Ilimitado',
    'cgroups.period' => 'Valor no válido: "%value%". El valor debe ser 5 minutos, una hora o un día, especificado en segundos (300, 3600 o 86400).',

    'file.fileIsImageFalseType' => 'El archivo que está intentando cargar no es una imagen.',
    'file.fileUploadErrorIniSize' => 'El archivo que está intentado cargar excede el tamaño ini definido.',
    'file.fileUploadErrorFormSize' => 'El archivo que está intentando cargar excede el tamaño del formulario definido.',
    'file.fileUploadErrorPartial' => 'El archivo solo se ha cargado de forma parcial.',
    'file.fileUploadErrorNoFile' => 'El archivo no ha sido cargado.',
    'file.fileUploadErrorNoTmpDir' => 'No se ha encontrado ningún directorio temporal para el archivo que está intentando cargar.',
    'file.fileUploadErrorCantWrite' => 'No se puede escribir el archivo que está intentando cargar.',
    'file.fileUploadErrorExtension' => 'La extensión devolvió un error mientras se cargaba el archivo.',
    'file.fileUploadErrorAttack' => 'El archivo se cargó de forma ilegal, lo que puede tratarse de un intento de intrusión.',
    'file.fileUploadErrorFileNotFound' => 'No se ha encontrado el archivo que está intentando cargar.',
    'file.fileUploadErrorUnknown' => 'Error desconocido mientras se cargaba el archivo.',
    'file.fileExtensionFalse' => 'El archivo que está intentando cargar tiene una extensión no permitida.',
    'file.fileExistsDoesNotExist' => 'El archivo o directorio especificado no existe.',

    'hostname.hostnameIpAddressNotAllowed' => "'%value%' parece ser una dirección IP, pero no se permiten direcciones IP",
    'hostname.hostnameUnknownTld' => "'%value%' no parece ser un nombre de host DNS pero no puede coincidir el TLD con la lista conocida",
    'hostname.hostnameDashCharacter' => "'%value%' parece ser un nombre de host DNS pero contiene un guión (-) en una posición que no es válida",
    'hostname.hostnameInvalidHostnameSchema' => "'%value%' parece ser un nombre de host DNS pero no coincide con el esquema de nombre de host para el TLD '%tld%'",
    'hostname.hostnameUndecipherableTld' => "'%value%' no parece ser un nombre de host DNS pero no puede extraer la parte TLD",
    'hostname.hostnameInvalidHostname' => "'%value%' no coincide con la estructura esperada para un nombre de host DNS",
    'hostname.hostnameInvalidLocalName' => "'%value%' no parece ser un nombre de red local válido",
    'hostname.hostnameLocalNameNotAllowed' => "'%value%' parece ser un nombre de red local pero no se permiten nombres de red locales",

    'port.notBetween' => 'El valor del puerto especificado no es válido. Debe ser un valor entre 1 y 65535, ambos incluidos.',

    'dns.invalidSoaValue' => 'El valor no es válido. Este debe estar entre 1 segundo y 68 años.',

    'isEmpty' => 'Este campo obligatorio está vacío. Indique un valor para este campo.',
    'stringLengthTooShort' => "'%value%' tiene menos de %min% caracteres.",
    'stringLengthTooLong' => "'%value%' tiene más de %max% caracteres.",
    'regexNotMatch' => "'%value%' no coincide con el patrón '%pattern%'.",
    'notAlnum' => "'%value%' tiene caracteres que no son alfanuméricos. Compruebe que solo está usando caracteres alfanuméricos.",
    'alnumStringEmpty' => "El valor está vacío.",
    'stringEmpty' => "'%value%' está vacío.",
    'loginSyntax' => 'En el nombre de usuario puede usar símbolos alfanuméricos, guiones (-), puntos (.), comillas simples (\'), símbolos de porcentaje (%) y guiones bajos (_). El nombre del usuario debe empezar por un símbolo alfanumérico.',
    'loginExists' => 'La cuenta de usuario %value% ya existe.',
    'cu_admin_alias__login_exists' => 'La cuenta de usuario ya existe.',
    'loginPassword' => 'La contraseña no puede contener el nombre de usuario.',
    'passwordSyntax' => 'La contraseña contiene caracteres no permitidos.',
    'passwordLength' => 'La contraseña debe tener una longitud de entre %minLength% y %maxLength% caracteres.',
    'domain_invalid_name' => 'El nombre de dominio indicado no es válido. Indique un nombre de dominio válido como dominio.com.',
    'dns_domain_invalid_name' => 'El nombre de dominio especificado no es válido.',
    'dns_domain_template_invalid_name' => 'La plantilla de nombre de dominio especificada no es válida.',
    'not_ascii_string' => 'El valor no es una cadena ASCII válida.',
    'not_printable_string' => 'El valor no debe incluir caracteres no impresos.',
    'invalid_locale' => "El idioma de la interfaz especificado '%value%' no está disponible o instalado.",
    'virtual_directory_name_invalid' => 'En el nombre del directorio, use únicamente caracteres alfanuméricos, guiones bajos y guiones.',
    'virtual_directory_name_reserved' => 'Este nombre está reservado.',
    'virtualDirectoryAlreadyExists' => 'Ya existe un directorio con el mismo nombre.',
    'virtualDirectoryPathIsInvalid' => 'La ruta física no es válida o no existe.',
    'virtualDirectoryErrorDocFileLocation' => 'Ubicación del archivo no válida.',
    'virtualDirectoryErrorDocAbsoluteUrl' => 'Formato URL erróneo. Introduzca una URL absoluta en el host virtual (sitio).',
    'invalid_city_name' => 'El nombre de la ciudad introducido no es válido',
    'invalid_country_code' => 'Código de país no válido',
    'not_specified_country_code' => 'País es un campo obligatorio que debería especificarse de forma explícita.',
    'invalid_system_user_login' => 'El usuario del sistema no es válido',
    'invalid_rfc_domain_name' => 'El nombre de dominio indicado no es un dominio RFC válido',
    'idn_name_conversion' => 'No se pudo convertir el nombre de dominio de IDN a Punycode',
    'domain_label_too_long' => 'Ninguna de las partes del nombre de dominio puede estar formada por más de 63 caracteres.',
    'domain_label_too_long_idn' => 'El dominio usa un nombre de dominio internacionalizado. Ninguna de las partes de su nombre, al convertirse a Punycode, puede estar formada por más de 63 caracteres.',
    'domain_starts_with_www' => 'Introduzca un nombre de dominio sin el prefijo \'www\'. El prefijo www para el dominio se añadirá automáticamente a la configuración del servidor web.',
    'domain_already_exists' => 'Este nombre de dominio ya existe.',
    'domain_without_www_already_exists' => 'Este nombre de dominio ya existe sin el prefijo \'www\'.',
    'domain_with_www_already_exists' => 'Este nombre de dominio ya existe con el prefijo \'www\'.',
    'subdomain_conflicts_with_existing_domain' => 'Ya existe un dominio con el mismo nombre que el subdominio \'%value%\'.',
    'restrict_domain_creation' => 'La directiva a nivel del servidor prohíbe el nombre de dominio especificado. Si usted es el propietario de este dominio, rogamos contacte con su proveedor de hosting.',
    'dns_record_already_exists' => 'Este registro DNS ya existe.',
    'domain_like_hostname' => 'Este nombre de dominio es el mismo que el nombre de host del servidor.',
    'passwordsNotMatch' => 'Las contraseñas indicadas no coinciden.',
    'stringsNotEqual' => 'Los valores no son iguales.',
    'equalMailAliases' => 'El alias de email especificado es el mismo que otro alias de email.',
    'mailAliasExist' => 'El alias de email especificado ya existe.',
    'mailNameExist' => 'La dirección de email especificada ya existe.',
    'mailListExist' => 'La dirección indicada ya está asignada a una lista de correo.',
    'mailAutoReplyHeadersSpaceError' => "Los encabezados de respuesta automática no deben contener ningún espacio",
    'mailAutoReplyHeadersInvalidValueError' => 'Algunos campos están vacíos o contienen un valor incorrecto.',
    'sysUserExist' => 'El nombre de usuario indicado ya está siendo usado por otro usuario de sistema. Indique otro nombre de usuario.',
    'emailAddressInvalid' => 'La dirección de email indicada no es válida. Indique una dirección válida que coincida con el siguiente patrón: johndoe@example.com.',
    'emailAddressInvalidLocal' => 'La dirección de email especificada no es válida. Esta debe pertenecer al dominio seleccionado. El administrador es la única persona que puede especificar direcciones de email externas en este caso.',
    'emailAddressSpecialNames' => 'La dirección de email especificada no es válida. La parte del nombre de usuario de la dirección no puede empezar por un nombre de sistema reservado (como por ejemplo con, lpt1, prn) separado por un punto (.) de la parte restante del nombre de usuario.',
    'dkimSelectorInvalid' => 'El selector DKIM especificado no es válido: %value%',
    'longAddress' => 'La dirección de email es demasiado larga.',
    'longMailboxAddressMailServer' => 'La parte del nombre de usuario de la dirección de email es demasiado larga para este servidor de correo. Indique un nombre de usuario que no esté formado por más de %%max%% símbolos.',
    'longFullAddressMailServer' => 'La dirección de email es demasiado larga para este servidor de correo. Indique una dirección de menos de %%max%% símbolos.',
    'dir_invalid_name' => 'Directorio de destino no válido.',
    'directoryHidesDomain' => 'Este directorio no puede usarse porque solaparía un sitio web presente en %path%. Este solapamiento haría que el sitio web no estuviera disponible.',
    'directoryHidesAnotherApplication' => 'Este directorio no puede usarse porque solaparía otra aplicación instalada en %path%. Este solapamiento haría que la aplicación instalada no estuviera disponible.',
    'directoryIsBehindAnotherApplication' => 'Este directorio no puede usarse porque sería solapado por otra aplicación instalada en %path%. Este solapamiento haría que la aplicación no estuviera disponible.',
    'domainLoginSyntaxWindows' => 'El nombre de usuario debe empezar por un carácter alfabético y no debe tener más de %%maxlength%% caracteres. De todos modos, los primeros caracteres pueden ser alfanuméricos en minúscula, guiones o guiones bajos y puntos. El nombre de usuario no puede acabar con un punto.',
    'domainLoginSyntaxUnix' => 'El nombre de usuario no puede estar formado por más de %%maxlength%% caracteres y solo puede incluir caracteres alfanuméricos en minúsculas, guiones y guiones bajos. El nombre de usuario debería empezar con un carácter alfanumérico en minúsculas',
    'notLocalMssqlHost' => 'No un nombre de host MSSQL local',
    'invalidMailTo' => 'No un enlace mailto: válido',
    'passwordsNotEqual' => 'Las contraseñas indicadas no coinciden.',
    'passwordPolicy' => '%policyError%',
    'fileImageSizeWidthTooBig' => "La imagen '%value%' que está intentando cargar es demasiado ancha ('%width%'). Las imágenes cargadas no pueden tener un ancho superior a '%maxwidth%'.",
    'fileImageSizeWidthTooSmall' => "La imagen '%value%' que está intentando cargar no es suficientemente ancha ('%width%'). Las imágenes cargadas deben tener un ancho mínimo de '%minwidth%'.",
    'fileImageSizeHeightTooBig' => "La altura de la imagen '%value%' que está intentando cargar es demasiado alta ('%height%'). Las imágenes cargadas no pueden tener una altura superior a '%maxheight%'.",
    'fileImageSizeHeightTooSmall' => "La altura de la imagen '%value%' que está intentando cargar es demasiado baja ('%height%'). Las imágenes cargadas no pueden tener una altura inferior a '%minheight%'.",
    'fileImageSizeNotDetected' => "No se ha podido detectar el tamaño de la imagen '%value%' que está intentando cargar.",
    'fileImageSizeNotReadable' => "No se ha podido leer la imagen '%value%\\ que está intentando cargar.",
    'passwordConfirmation' => 'Confirme la contraseña',
    'databaseUserNameExists' => 'Ya existe un nombre de usuario de la base de datos denominado %value%.',
    'invalidUserName' => 'El nombre de usuario de la base de datos contiene caracteres no permitidos.',
    'longUserName' => 'El nombre de usuario de la base de datos tiene más de %%max%% caracteres.',
    'forbiddenName' => 'No se permite el nombre de usuario de base de datos "%value%".',
    'invalidAdminLogin' => 'No se pueden usar las credenciales del usuario seleccionado para el acceso del administrador. El nombre de usuario indicado no es válido: %%cause%%',
    'invalidAdminPassword' => 'No se pueden usar las credenciales del usuario seleccionado para el acceso del administrador. La contraseña indicada no es válida: %%cause%%',
    'passwordLengthTooShort' => "la contraseña tiene menos de %min% caracteres.",
    'passwordLengthTooLong' => "la contraseña tiene más de %max% caracteres.",
    'passwordRegexNotMatch' => "la contraseña no coincide con el patrón '%pattern%'.",
    'fileSharingEmptyFolderName' => "Indique un nombre para la carpeta.",
    'fileSharingInvalidFolderName' => "El nombre de carpeta indicado no es válido. Este no puede contener ninguno de los siguientes caracteres: \\ / : * ? \" < > |",
    'fileSharingFolderExists' => "No se puede crear la carpeta con el nombre indicado porque ya existe una carpeta con este nombre.",
    'invalidUrl' => 'La dirección especificada no es válida. Indique una dirección válida como http://dominio.com.',
    'domainVirtualdirectoryReservedName' => 'Este nombre de directorio está reservado. Indique otro nombre para su directorio virtual.',
    'domainVirtualdirectoryInvalidName' => 'El nombre del directorio solo debería contener caracteres alfanuméricos, guiones bajos y guiones.',
    'filesharingPathUnavailable' => 'En el dominio especificado ya existe un directorio con este nombre. Indique otro nombre para el directorio.',
    'filesharingSslNotAvailableOnDomain' => 'Ha seleccionado utilizar vínculos seguros pero el dominio no tiene habilitado SSL/TLS. Seleccione un dominio con soporte para SSL/TLS o deseleccione la casilla Generar vínculos seguros.',
    'filesharingSslRedirectOnDomain' => 'El dominio seleccionado tiene activada la opción "Redireccionamiento 301 permanente de HTTP a HTTPS preservando SEO". Si desea configurar la compartición de archivos, seleccione un dominio que no tenga esta opción activada o seleccione la casilla "Generar vínculos seguros a archivos y carpetas".',
    'filesharingSslNotAvailableOnDefaultDomain' => 'Ha seleccionado utilizar vínculos seguros en el nombre de host o dirección IP del servidor, pero estos vínculos solo pueden crearse en sitios web que soporten SSL/TLS. Cree un sitio web con soporte para SSL/TLS o deseleccione la casilla Generar vínculos seguros.',
    'filesharingDefaultDomainSelectedOnServerIp' => 'Ha seleccionado la dirección IP del servidor que tiene asignado un dominio predeterminado. Seleccione un sitio web como URL raíz en vez de la dirección IP.',
    'physicalPathOnDomainAlreadyExists' => 'Ya existe un directorio con este nombre.',
    'virtualPathOnDomainAlreadyExists' => 'Ya existe un directorio virtual con este nombre.',
    'sysUserLoginSyntaxWindows' => 'En el nombre de usuario puede utilizar símbolos alfanuméricos, guiones (-), puntos (.) y guiones bajos (_). El nombre de usuario debe empezar por un símbolo alfanumérico.',
    'sysUserLoginSyntaxUnix' => 'En el nombre de usuario puede utilizar símbolos alfanuméricos en minúscula, guiones (-), puntos (.) y guiones bajos (_). El nombre de usuario debe empezar por un símbolo alfanumérico.',
    'docrootNotInWebspaceRoot' => 'El directorio especificado no se encuentra dentro del directorio raíz de la suscripción.',
    'docrootContainsSpecialCharacters' => 'El nombre de directorio indicado contiene símbolos que no pueden ser utilizados.',
    'docrootWithinProhibitedDirectory' => 'El directorio especificado contiene un directorio de servicio.',
    'docrootWithinInstalledApplication' => 'El directorio especificado es solapado por una aplicación web instalada en %path%.',
    'docrootIsNotDirectory' => 'La ruta especificada no puede usarse porque su parte se refiere a un archivo.',
    'docrootTooLongPart' => 'El nombre del directorio especificado es demasiado largo.',
    'subdomainWrongName' => '%errorDescription%',
    'subdomainWrongDomain' => 'Se ha seleccionado un dominio incorrecto.',
    'domainAliasWrongName' => '%errorDescription%',
    'phoneRegexNotMatch' => 'Ha indicado un número de teléfono incorrecto que contenía símbolos no permitidos.',
    'stateInvalid' => 'Se ha indicado un estado o provincia incorrecto.',
    'zipRegexNotMatch' => 'Se ha indicado un código postal incorrecto.',
    'limitValueInvalid' => 'El límite especificado no es válido.',
    'softLimitValueInvalid' => 'El valor debe estar en el rango de %%MIN%%..%%MAX%%.',
    'outgoingMessagesLimitValueInvalid' => 'El valor debe estar en el rango de %%MIN%%..%%MAX%%. El administrador de Plesk es la única persona que puede ajustar esta opción.',
    'limitMssqlDatabaseFileSizeValueInvalid' => 'El tamaño del archivo de una base de datos MS SQL debe ser un número entero entre 0 y 16 TB.',
    'limitMssqlDatabaseLogFileSizeValueInvalid' => 'El tamaño del archivo de registro de una base de datos MS SQL debe ser un número entero entre 0 y 2 TB.',
    'limitDiskspaceValueInvalid' => 'El límite de espacio en disco debe ser un número entero entre 0 y 4095 TB.',
    'limitTrafficValueInvalid' => 'El límite de tráfico debe ser un número entero entre 0 y 4095 TB/mes.',
    'limitMboxQuotaValueInvalid' => 'El límite de tamaño del buzón de correo debe ser un número entero entre 0 y 4095 TB.',
    'limitRetainPeriodValueInvalid' => 'El valor de "Conservar estadísticas de tráfico y web" en los planes de servicio no puede ser inferior al valor de "Conservar estadísticas de tráfico y web" en Herramientas y configuración> Configuración del servidor. Especifique un número entero mayor o igual a %%MIN%% e inferior a %%MAX%%.',
    'limitValueOverused' => 'La cantidad de recursos usados en este momento excede el valor límite especificado. No puede especificar un valor inferior a %%used%%',
    'limitValueOverselled' => 'El límite de uso de recursos de %%reserved%% ya está asignado a suscripciones. No puede especificar un valor inferior a %%reserved%%',
    'lessThan' => "'%value%' es inferior a '%min%'",
    'greaterThan' => "'%value%' es superior a '%max%'",
    'greaterThanDiskQuota' => "%value% es superior a la cuota de disco (%max%)",
    'notDigits' => 'El valor debe ser un número entero.',
    'digitsInvalid' => 'El valor debe ser un número entero.',
    'digitsStringEmpty' => 'El valor debe ser un número entero.',
    'isEqual' => "El valor no debe ser igual a '%invalidValue%'.",
    'notInt' => 'El valor debe ser un número entero.',
    'maillistNameInvalid' => 'La dirección especificada de la lista de correo no es válida.',
    'maillistReservedNameAlreadyExists' => 'La dirección especificada ya está reservada.',
    'maillistAlreadyExists' => 'La dirección especificada ya está siendo usada por una lista de correo.',
    'maillistAlreadyExistsOnServer' => 'El nombre especificado de la lista de correo ya está siendo usado por otra suscripción',
    'mailnameAlreadyExists' => 'La dirección de email especificada ya existe.',
    'mailaliasAlreadyExists' => 'La dirección especificada ya está siendo usada por un alias de email.',
    'autoresponderEndDateIsInvalid' => 'Indique una fecha futura.',
    'mailPostboxLimit' => '%message%',
    'userEmailLimitExceeded' => '%limitManagerMessage%',

    'zxcvbnEstimator.passwordStrength' => 'Su contraseña no es suficientemente compleja. Conforme a la directiva del servidor, la seguridad mínima es de %strength%.',
    'zxcvbnEstimator.passwordStrengthVeryWeak' => 'Muy poco segura (no recomendado)',
    'zxcvbnEstimator.passwordStrengthWeak' => 'Poco segura (no recomendado)',
    'zxcvbnEstimator.passwordStrengthMediocre' => 'Media',
    'zxcvbnEstimator.passwordStrengthStrong' => 'Segura (recomendado)',
    'zxcvbnEstimator.passwordStrengthStronger' => 'Muy segura',
    'zxcvbnEstimator.passwordStrengthVeryWeakHint' => 'Puede ser fácilmente susceptible a ataques de fuerza bruta. Vulnerable a rellenado de credenciales y ataques de diccionario.',
    'zxcvbnEstimator.passwordStrengthWeakHint' => 'Puede ser fácilmente susceptible a ataques de fuerza bruta. Menos vulnerable a rellenado de credenciales y ataques de diccionario.',
    'zxcvbnEstimator.passwordStrengthMediocreHint' => 'Puede ser susceptible a ataques de fuerza bruta.',
    'zxcvbnEstimator.passwordStrengthStrongHint' => 'Poco susceptible a ataques de fuerza bruta. Algo de protección frente a ataques offline.',
    'zxcvbnEstimator.passwordStrengthStrongerHint' => 'Muy poco susceptible a ataques de fuerza bruta. Protección razonable frente a ataques offline.',

    'emailCantBeRenamed' => "El servidor no soporta el cambio de nombre de cuentas de correo.",
    'emailOwnedByAnotherUser' => "Esta dirección de email es propiedad de otro usuario.",
    'maillistAdminEmailShouldExistsOnDomain' => 'La dirección de email del administrador de la lista de correo debe estar registrada en el mismo dominio que la lista de correo.',
    'webmailExists' => "El servicio webmail '%value%' ya existe.",
    'invalidDbName' => 'El nombre de la base de datos sólo puede contener símbolos alfanuméricos, puntos, guiones y guiones bajos.',
    'longDbName' => 'El nombre de la base de datos es demasiado largo.',
    'dbNameClash' => 'El nombre de la base de datos y el nombre del usuario de la base de datos deben ser distintos.',
    'dbConnectFailed' => 'No ha sido posible conectar con el servidor de base de datos. Verifique las credenciales del usuario de la base de datos y las restricciones de acceso.',
    'databaseNameAlreadyExists' => 'Ya existe una base de datos denominada %value%.',
    'wrongUrlSyntax' => 'La dirección especificada no es válida. Indique una dirección válida en formato http://dominio.com, relativo/ruta o mailto:address',
    'connectionRefused' => 'Conexión rechazada.',
    'loginIncorrect' => 'Nombre de usuario incorrecto',
    'failedToChangeDirectory' => 'El directorio no existe',
    'failedToChangeMode' => 'Error al cambiar el modo',
    'failedToCreateDirectory' => 'Creación de archivos no permitida',
    'failedToRenameDirectory' => 'No se permite el cambio de nombres de archivo',
    'failedToDeleteDirectory' => 'No se permite la eliminación de archivos',
    'ipInvalid' => "'%value%' no parece ser una dirección IP válida o presenta un tipo incorrecto.",
    'ipv6IsNotGlobal' => "'%value%' no es una dirección IP pública.",
    'ipMaskInvalid' => "'%value%' no parece ser una máscara de dirección IP válida.",
    'ipInvalidForInterface' => 'La dirección IP especificada no puede usarse en una interfaz de red. Especifique una dirección IP válida con máscara o rango de prefijo de subred.',
    'ipInvalidForInterfaceIpv6NotAvailable' => 'La dirección IP especificada no puede usarse en la interfaz de red seleccionada porque el soporte para IPv6 está desactivado para esta interfaz.',
    'ipAlreadyExists' => 'La dirección IP %value% ya existe.',
    'notInArray' => 'Opción no soportada.',
    'ipAddressIsNotSelected' => 'Debe seleccionar al menos una dirección IP.',
    'noServiceNodeSpecified' => 'error interno: no ha especificado ningún nodo de servicio.',
    'serviceNodeInvalidName' => 'El nombre del nodo de servicio "%value%" no es válido.',
    'serviceNodeNameAlreadyExists' => 'Ya existe un nodo de servicio denominado "%value%".',
    'serviceNodeIpUsed' => "No se puede eliminar el nodo de servicio porque la dirección IP está registrada.",
    'serviceNodeIpAddressAlreadyExists' => 'El nodo de servicio con la dirección IP "%value%" ya existe.',
    'serviceNodeInvalidTransport' => 'El nombre de transporte "%value%" no es válido.',
    'app_non_unique_setting_value' => 'Otro objeto tiene el mismo valor de parámetro. Este parámetro debe ser único para este objeto.',
    'wrongLocalUrlSyntax' => 'La dirección especificada no es válida. Especifique una dirección local válida como /smb/web/view.',
    'phpIsapiHandlerTypeNotSupported' => 'El tipo de gestor ISAPI no es soportado por la versión PHP actual.',
    'dbNameNotExist' => 'La base de datos especificada no existe.',
    'invalidBooleanValue' => 'Los valores permitidos son "verdadero" o "falso".',
    'invalidMimeType' => 'El tipo MIME especificado no es válido: "%value%".',
    'invalidHeaders' => 'El encabezado especificado no es válido: "%value%".',
    'invalidHandler' => 'El controlador especificado no es válido: "%value%".',
    'invalidAllowDeny' => 'La directiva Allow/Deny es inválida: "%value%".',
    'nonUniqueAllowDeny' => 'El valor especificado para la directiva Allow/Deny ya existe: "%value%".',
    'maxItemsCountExeededAllowDeny' => 'El número de direcciones IP presentes en la lista debe ser inferior o igual a %value%.',
    'invalidDirectoryIndex' => 'El archivo de índice del directorio raíz especificado no es válido.',
    'invalidNginxProxyMode' => 'El valor especificado para la propiedad nginxProxyMode no es válido. Los valores permitidos son "verdadero" o "falso".',
    'invalidNginxTransparentMode' => 'El valor especificado para la propiedad nginxTransparentMode no es válido. Los valores permitidos son "verdadero" o "falso".',
    'invalidNginxServeStatic' => 'El valor especificado para la propiedad nginxServeStatic no es válido. Los valores permitidos son "verdadero" o "falso".',
    'invalidStaticFilesExtensions' => 'Las extensiones de los archivos estáticos especificadas no son válidas: "%value%".',
    'invalidNginxServePhp' => 'El valor especificado para la propiedad nginxServePhp no es válido. Los valores permitidos son "verdadero" o "falso".',
    'invalidDocuments' => 'El nombre del documento no puede contener comas (",").',
    'duplicateDocuments' => 'Los siguientes documentos ya existen en la lista de documentos predeterminados: "%value%"',
    'protected_directory_invalid_name' => 'Nombre del directorio protegido no válido.',
    'protected_directory_invalid_login' => 'El nombre de usuario del usuario de un directorio protegido con contraseña no puede contener más de 20 caracteres alfanuméricos. Este nombre puede contener el signo de guión ("-"), pero no puede empezar con él.',
    'notARelativePath' => 'La ruta debe ser relativa',
    'cannotUseJunctions' => 'No pueden usarse uniones fuera del espacio web como directorio de compilación temporal',
    'notBetween' => '%value% no está entre "%min%" y "%max%", ambos inclusive',
    'notBetweenStrict' => '%value% no se encuentra estrictamente entre "%min%" y "%max%"',
    'redirectToMyself' => 'El sitio web no puede redireccionarse a sí mismo. Introduzca una dirección de destino que no sea la URL del sitio web principal.',
    'redirectToAlias' => 'El sitio web no puede redireccionarse a su alias. Introduzca una dirección de destino que no sea la dirección del alias del sitio web principal.',
    'relativePathInvalid' => 'La ruta especificada no es válida.',
    'aspDotNetSettingsInvalid' => 'Uno o más de los valores especificados para la configuración de ASP.NET no son válidos.',
    'mboxOutgoingMessagesLimitValueInvalid' => 'El valor del límite de correo saliente para un buzón debe ser superior a "%%MIN%%".',
    'domainOutgoingMessagesLimitValueInvalid' => 'El valor del límite de correo saliente para un dominio debe ser superior a "%%MIN%%".',
    'subscriptionOutgoingMessagesLimitValueInvalid' => 'El valor del límite de correo saliente para una suscripción debe ser superior a "%%MIN%%".',
    'iisAuthNotEnabled' => 'La autenticación anónima o de Windows debe estar activada en la configuración del servidor web para el dominio.',
    'mboxOutgoingMessagesLimitValueInvalidDigit' => 'El valor del límite de correos salientes para un buzón de correo debe ser un número entero positivo o bien \'predeterminado\'. Asimismo también puede ser \'-1\' para el valor \'Ilimitado\'.',
    'domainOutgoingMessagesLimitValueInvalidDigit' => 'El valor del límite de correos salientes para un dominio debe ser un número entero positivo o bien \'predeterminado\'. Asimismo, también puede ser \'-1\' para el valor \'Ilimitado\'.',
    'subscriptionOutgoingMessagesLimitValueInvalidDigit' => 'El valor del límite de correos salientes para una suscripción debe ser un número entero positivo o bien \'predeterminado\'. Asimismo también puede ser \'-1\' para el valor \'Ilimitado\'.',
    'outgoingMessagesReportPeriodValueInvalid' => 'No se soporta el valor especificado para el periodo de informes.',
    'outgoingMessagesNotificationPeriodValueInvalid' => 'No se soporta el valor especificado para el periodo de notificación.',
    'textItemsListInvalid' => 'El elemento especificado no es válido: "%value%".',
    'textItemsListInvalidMulti' => 'Los elementos indicados no son válidos: "%value%".',
    'textItemsListNonUnique' => 'El valor especificado ya existe: "%value%".',
    'textItemsListMaxItemsCountExeeded' => 'El número de elementos no debería ser superior a %value%.',
    'invalidAcl' => 'El host especificado no es válido: "%value%".',
    'nonUniqueAcl' => 'El valor especificado para el host ya existe: "%value%".',
    'httpInvalidStatusFormat' => 'Los códigos de estado deben ser números en formato 400 o 400.1',
    'httpInvalidStatusCode' => 'Los códigos de estado deben estar entre %%minCode%% y %%maxCode%%',
    'httpInvalidStatusSubCode' => 'Los códigos de subestado deben estar entre %%minSubCode%% y %%maxSubCode%%',
    'httpInvalidStatusRange' => 'Los rangos de estado deberían especificar un rango entre un valor mínimo y un valor máximo',
    'phpSettingValueByteRegexNotMatch' => 'Se ha especificado un valor incorrecto. Indique un número entero y un carácter corto (K para kilobyte, M para megabyte, G para gigabyte, por ejemplo, 128M) ',
    'phpFpmServersAmountNotPositive' => "El valor debe ser un número positivo",
    'phpFpmServersAmountLessThan' => "'%value%' es inferior a '%%min%%' (%%field%%)",
    'phpFpmServersAmountGreaterThan' => "'%value%' es superior a '%%max%%' (%%field%%)",
    'phpInvalidIniSyntax' => "Se detectó una sintacis INI no válida en la línea %%line%%: '%%text%%'",
    'portRangeInvalid' => 'El rango de puertos indicado no es válido. El valor a la izquierda debe ser inferior al de la derecha.',
    'portRangeValueInvalid' => 'El valor %value% en el rango de puertos no es válido. Este debe estar entre %min% y %max%.',
    'domainResolvesToAnotherIp' => 'El dominio resuelve a la dirección IP incorrecta (%value%). Si desea publicar su sitio web, corrija %%dnsSettingsLink%%.',
    'domainNotResolved' => 'El dominio no puede resolverse. Para publicar su sitio, corrija %%dnsSettingsLink%%.',
    'dnsSettingsLink' => 'Configuración DNS',
    'backupRotationSingleValueInvalid' => 'Límite excedido.',
    'backupRotationMultipleValueInvalid' => 'Límite excedido por todos los backups programados en el almacenamiento local: %%details%%.',
    'backupRotationDetail' => '{count, plural, one {# backup {type}} other {# backups {type}}}',
    'backupRotationTypeHourly' => 'por hora',
    'backupRotationTypeDaily' => 'cada día',
    'backupRotationTypeWeekly' => 'cada semana',
    'backupRotationTypeMonthly' => 'cada mes',

    'backupPathInvalidCharacters' => '"%value%" contiene caracteres que no son válidos.',
    'backupPathInvalidDot' => '"%value%" contiene una ruta "." o ".." que no es válida.',
    'networkAccessAlreadyExists' => 'La red ya está presente en la lista de restricción de acceso de IPs.',
    'codeRegexNotMatch' => 'El código de activación no es válido.',
    'nameUsedForPlesk' => 'No pudo crearse el dominio porque su nombre está presente en la URL que usa para acceder a Plesk. Para crearlo, acceda a Plesk mediante https://%value%:8443 o https://plesk.%value%.',
    'invalidNameDirectory' => 'El nombre indicado no es válido.',
    'invalidPasswordCharacters' => 'La contraseña no puede incluir comillas, espacios o caracteres nacionales.',
    'invalidPasswordLength' => 'La longitud de la contraseña debería ser de %%min%%-%%max%% caracteres.',
    'passwordContainsLogin' => 'La contraseña no debería incluir el nombre de usuario.',

    'invalidPhpExtensionName' => 'El nombre de la extensión no es válido.',
    'hexStringNotMatch' => 'El valor especificado no parece ser una cadena hexadecimal válida.',
    'invalidCertificateData' => 'El valor especificado no parece ser un dato de certificado válido.',
    'invalidSha256Hash' => 'El valor especificado no parece ser un hash SHA-256 válido.',
    'invalidSha512Hash' => 'El valor especificado no parece ser un hash SHA-512 válido.',
    'invalidTlsaMatchingType' => 'Se ha indicado un tipo de coincidencia TLSA que no es válido.',

    'invalidHttpsIpv4hint' => 'El valor especificado debe estar vacío o contener una lista de direcciones IPv4 separadas por comas.',
    'invalidHttpsIpv6hint' => 'El valor especificado debe estar vacío o contener una lista de direcciones IPv6 separadas por comas.',
    'invalidHttpsProtocols' => 'El valor especificado no debe contener espacios en blanco ni los caracteres \'=\', \'\\\' y no debe tener más de 255 bytes.',
    'invalidHttpsVal' => 'El valor del registro DNS HTTPS debe cumplir con el estándar RFC 9460.',
    'invalidHttpsValHost' => 'El valor de la opción de host de destino debe ser un nombre de dominio válido o estar vacío.',
    'invalidHttpsValPort' => 'El valor de la opción "puerto" debe estar comprendido entre 0 y 65535, ambos incluidos.',
    'invalidHttpsValProtocols' => 'El valor de la opción "alpn" no debe contener espacios en blanco ni los caracteres \'=\', \'\\\' y no debe tener más de 255 bytes.',
    'invalidHttpsValIpv4hint' => 'El valor de la opción "ipv4hint" debe estar vacío o contener una lista de direcciones IPv4 separadas por comas.',
    'invalidHttpsValIpv6hint' => 'El valor de la opción "ipv6hint" debe estar vacío o contener una lista de direcciones IPv6 separadas por comas.',

    'fail2ban.invalidIpsWithJailsList' => 'La lista de direcciones IP y los nombres de jail deben especificarse en el formato \'IP,JAIL[;IP,JAIL...]\'.',
    'fail2ban.invalidIp' => 'Las direcciones IP de la lista deben ser direcciones IP válidas o máscaras CIDR.',
    'fail2ban.invalidIpList' => 'La lista de direcciones IP debe especificarse en el formato \'IP[;IP...]\'.',
    'fail2ban.invalidJail' => 'Los jails de la lista deben existir y estar activos en el servidor.',
    'fail2ban.ipTooLong' => 'Las direcciones IP de la lista no deben tener más de {max, plural, one {# carácter} other {# caracteres}}.',
    'fail2ban.ipTrusted' => 'Las direcciones IP de la lista no deben ser direcciones IP de confianza.',
    'fail2ban.banTrustedIp' => 'La dirección IP está marcada como dirección de confianza y no se puede prohibir.',

    'notifyInvalid' => 'Se esperan los siguientes valores: %value%.',

    'cronStyleError' => 'La sintaxis crontab no es válida.',
    'cronStyleErrorWin' => 'No se permite el uso de barras (/) ni guiones (-).',

    'scheduler.sysUserLoginInvalid' => 'El usuario del sistema con el nombre %value% no está permitido o no existe.',

    'smarthost.invalidHostname' => 'El valor especificado debe ser un nombre de dominio válido o una dirección IP.',
    'smarthost.invalidUsernameCharacters' => 'El nombre de usuario solo puede contener letras, números y caracteres especiales, excepto %%invalid%%.',
    'smarthost.invalidUsernameLength' => 'El nombre de usuario debe tener una longitud de entre %%minLength%% y %%maxLength%% caracteres.',
    'smarthost.invalidEncryption' => 'Opción no soportada.',
];