<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream envió un encabezado demasiado grande mientras respondía al encabezado de la respuesta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Listo en breve.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "Error interno del servidor 500: aquí no se permite la opción FollowSymLinks"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Listo en breve.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "el servidor alcanzó la opción max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Síntomas</h4><ul><li><p>Aquellos sitios web que tengan el controlador PHP configurado como <strong>aplicación FPM servida por Apache</strong> o bien <strong>aplicación FPM servida por nginx</strong> en <strong>Dominios</strong> &gt; <strong>example.com</strong> &gt; <strong>Configuración PHP</strong> experimentan uno de los siguientes problemas:</p><ul><li><p>carga lenta</p></li><li><p>no accesible (de forma permanente o periódica) con un error 50x en un navegador web:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>En el archivo de registro de errores de PHP-FPM aparece el siguiente mensaje <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (donde <em>XX</em> es la versión de PHP usada por los sitios web):</p><pre>ADVERTENCIA: el servidor [pool example.com] alcanzó la opción max_children (*), considere aumentarla</pre><ul><li><p>El mensaje que aparece arriba suele ir acompañado del siguiente error:</p><pre>no pudo leerse lo que dice el secundario: descriptor de archivo incorrecto (9)</pre></li></ul></li><li><p>Si en el servidor se ha activado nginx, es posible que los siguientes mensajes de error aparezcan en el archivo de registro de errores del dominio <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>El <code>pm.max_children</code> de PHP-FPM ha sido alcanzado por el/los sitio(s) web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Aumente el límite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Aumente el límite <code>pm.max_children</code> para los dominios afectados:</p><ol><li><p>Conéctese al servidor Plesk mediante <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Encuentre los dominios afectados usando el siguiente comando:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> el número a la izquierda indica cuántas veces el sitio web ha alcanzado el límite <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Acceda a Plesk</a>.</p></li><li><p>Vaya a <strong>Dominios</strong> &gt; <strong>example.com</strong> &gt; <strong>Configuración PHP</strong> &gt; <strong>Configuración PHP-FPM</strong>.</p></li><li><p>Aumente el valor <code>pm.max_children</code> para el dominio y aplique los cambios. Aumente este valor para todos los dominios detallados en el paso 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Demasiados archivos abiertos"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx no puede iniciarse/volver a cargarse en un servidor Plesk, puesto que hay demasiados archivos abiertos</p><h4>Síntomas</h4><ul><li><p>El servicio nginx no puede iniciarse/volverse a cargar debido al siguiente error en el archivo <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>No es posible acceder a algunos o a todos los sitios web</p></li><li><p>La advertencia se muestra en <strong>Herramientas y configuración &gt; Diagnosticar y reparar</strong>:</p><pre style="white-space: pre-wrap;">Al comprobar el valor ULIMIT de nginx se encontraron N dominios en el servidor. Es posible que exista un problema con el límite predeterminado de nginx en cuanto a archivos abiertos</pre></li><li><p>Las aplicaciones web NodeJS y Ruby muestran el error 502 Bad Gateway cuando se efectúan algunas tareas de Plesk, como puede ser el caso de la creación de dominios, suscripciones, cambios en Apache o Nginx, etc:</p><pre style="white-space: pre-wrap;">Error del servidor<br>502 Bad Gateway <br>El servidor web recibió una respuesta no válida cuando actuaba como pasarela o servidor proxy.</pre></li><li><p>Una vez <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">instalado un nuevo certificado para el dominio</a>, el certificado anterior todavía se muestra en un navegador web, si bien el certificado correcto se encuentra seleccionado en la página <strong>Dominios &gt; example.com &gt; Configuración de hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>El host virtual de nginx abre 4 archivos de registro para cada host virtual con hosting físico:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Como consecuencia, se excede el número máximo de archivos abiertos por parte del servidor nginx debido a un gran número de dominios (generalmente más de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Aumente el límite de archivos abiertos',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Advertencia:</strong> la ejecución de la utilidad <code>websrv_ulimits</code> sin la opción <strong>--no-restart</strong> inicia la recreación de los archivos de configuración web para todos los dominios y puede ocasionar un tiempo de interrupción del servicio significativo en el caso de alojar una gran cantidad de sitios web.<br><br>Ejecute el comando durante el periodo de mantenimiento.</div><p>Una buena práctica es establecer un valor de límite de archivos abiertos que al menos sea superior a la <strong>cantidad de dominios en Plesk * 16</strong>. En el ejemplo que se muestra a continuación se detalla cómo establecer el límite a 4096:</p><ol><li><p>Conéctese al servidor mediante <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Establezca el límite de archivos abiertos a 4096 tanto para Apache como para nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Reinicie Apache y los servicios nginx en <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Herramientas y configuración &gt; Administración de servicios</strong> para aplicar los cambios.</p></li><li><p>Compruebe que \'Max open files limit\' se aplicó correctamente tras el reinicio de los servicios web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Si esta solución no le ayudó, establezca el límite mediante la utilidad <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Cuerpo de la respuesta demasiado grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Listo en breve.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Acceso denegado con código 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Síntomas</h4><ul><li><p>ModSecurity está instalado y activado en <strong>Herramientas y configuración > Firewall para aplicaciones web (ModSecurity) > Modo de firewall para aplicaciones web > Activado</strong>.</p></li><li>No puede cargarse un sitio web alojado en Plesk. No es posible efectuar operaciones en el sitio web como gestionar WordPress, acceder al webmail o acceder al archivo <code>robots.txt</code>. El navegador puede mostrar uno de los siguientes errores: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>En el archivo de registro <code>/var/log/modsec_audit.log</code> o en la página Registros de Plesk (<strong>Dominios</strong> &gt; <strong>example.com</strong> &gt; <strong>Registros</strong>) aparece un mensaje de error de ModSecurity como el siguiente: <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>El firewall para aplicaciones web de ModSecurity está activado con un conjunto de reglas extremadamente restrictivas como OWASP, Comodo o un conjunto de reglas personalizado como Imunify360. Los conjuntos de reglas restrictivos pueden bloquear algunas operaciones en el sitio web.</p><p><Strong>Nota:</strong> el error de ModSecurity puede denotar un ataque en su servidor. Aplique las soluciones detalladas a continuación únicamente si está seguro de que ModSecurity bloquea un uso válido de su sitio web.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Desactive el conjunto de reglas de ModSecurity por ID o etiqueta',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Localice el ID de la regla que bloquea el uso legítimo de su sitio web. Encontrará los IDs en los mensajes de error en el archivo de registro <code>/var/log/modsec_audit.log</code>. El ID es un número entero entre comillas con el prefijo <code>id</code> entre corchetes. Por ejemplo, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Desactive conjuntos de reglas específicos en Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Cambie a otro conjunto de reglas de ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Cambie a un conjunto de reglas de ModSecurity menos restrictivo, como por ejemplo "Atomic ModSecurity Ruleset". Para ello, vaya a <strong>Herramientas y configuración</strong> > <strong>Firewall para aplicaciones web (ModSecurity)</strong> > <strong>Configuración</strong>, seleccione <strong>Atomic Standard</strong> y haga clic en <strong>ACEPTAR</strong> para aplicar los cambios.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Error interno del servidor 500: Tamaño de memoria permitido de XXX agotado"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Síntomas</h4><ul><li><p>No es posible acceder a un sitio web alojado en Plesk:</p><pre>500 Internal Server Error</pre></li><li><p>En el registro del sitio web puede verse el siguiente error:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Al sitio web no se le ha asignado suficiente memoria para procesarse.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Aumente memory_limit del sitio web',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restricción open_basedir en efecto"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Síntomas</h4><ul><li><p>No es posible acceder a un sitio web debido a uno de los siguientes errores mostrados en el navegador web:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>En la página Registros del dominio (<strong>Dominios</strong> > <strong>example.com</strong> > <strong>Registros</strong>) se aprecia el siguiente mensaje de error:</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'El script PHP está intentando acceder a un directorio para el que no se ha permitido el acceso. Esta restricción viene definida por la directiva de PHP <code>open_basedir</code> de forma individualizada para cada dominio. Por omisión, <code>open_basedir</code> permite el acceso a los directorios de raíz de documentos del dominio y a <code>tmp</code>, así como a la ruta de sesiones predeterminada del sistema.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Añada la ruta adicional a la directiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Desactive la directiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Vaya a la página <strong>Dominios &gt example.com &gt Configuración PHP</strong> y defina la directiva <code>open_basedir</code> a "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Prohibido AH01797: cliente denegado por la configuración del servidor"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Síntomas</h4><ul><li><p>El sitio web muestra un error similar al siguiente:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>El archivo de registro <code>/var/www/vhosts/system/example.com/logs/error_log</code> contiene errores como el siguiente:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>La configuración actual de Apache no permite el acceso al sitio web.</p><p>En el caso de archivos como .htaccess y .htpasswd, esto es de esperar, puesto que estos archivos no deben ser accesibles mediante el servidor web.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Compruebe la configuración del servidor y archivos .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "No es posible acceder a un directorio de sitio web: 403 Prohibido"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Síntomas</h4><ul><li><p>No es posible acceder a un ubicación específica de un sitio web, como por ejemplo <code>http://example.com/some_folder</code>. Se produce el siguiente error:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>En el archivo <code>/var/www/vhosts/example.com/logs/error_log<code/> aparece el siguiente error:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>El directorio solicitado no contiene archivos de índice o bien la exploración de directorios no está activada.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Añada un archivo de índice al directorio',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Active la exploración de directorios',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "No es posible acceder a un directorio de un sitio web en Plesk: 403 Prohibido"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Síntomas</h4><ul><li><p>No es posible acceder a un ubicación específica de un sitio web, como por ejemplo <code>http://example.com/some_folder</code>. Se produce el siguiente error:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>En el archivo <code>/var/www/vhosts/example.com/logs/error_log</code> aparece el siguiente error:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>El directorio solicitado no contiene archivos de índice o bien la exploración de directorios no está activada.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Añada un archivo de índice al directorio',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Active la exploración de directorios',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "el servidor alcanzó la opción MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Listo en breve.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Límite de cuerpo de petición PHP "el cliente pretendía enviar un cuerpo demasiado grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Listo en breve.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Límite de cuerpo de petición PHP "el cliente pretendía enviar un cuerpo demasiado grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Listo en breve.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sesiones PHP "Error interno del servidor 503" o "No pudieron leerse los datos de la sesión"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Listo en breve.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Prohibido: pcfg_openfile: no pudo comprobarse el archivo htaccess. Compruebe que puede leerse"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Síntomas</h4><ul><li><p>Un sitio web alojado en Plesk no funciona:</p><pre>No tiene permisos para acceder a / en este servidor. <br> Además, se produjo un error 403 Forbidden mientras se intentaba usar un ErrorDocument para gestionar la petición.</pre><p>En vez del error anterior, también puede ver la página en blanco.</p></li><li><p>El registro de errores del dominio presente en <strong>Dominios &gt example.com &gt Registros</strong> contiene lo siguiente:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Permisos incorrectos para las carpetas o archivos del dominio.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Repare los permisos para el contenido del sitio web',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Lea el artículo de la base de conocimiento y siga las indicaciones allí detalladas</a>.</p></li></ol>',
];